info = {
    "name": "uk",
    "date_order": "DMY",
    "january": [
        "січ",
        "січень",
        "січня"
    ],
    "february": [
        "лют",
        "лютий",
        "лютого"
    ],
    "march": [
        "бер",
        "березень",
        "березня"
    ],
    "april": [
        "кві",
        "квіт",
        "квітень",
        "квітня"
    ],
    "may": [
        "тра",
        "трав",
        "травень",
        "травня"
    ],
    "june": [
        "чер",
        "черв",
        "червень",
        "червня"
    ],
    "july": [
        "лип",
        "липень",
        "липня"
    ],
    "august": [
        "сер",
        "серп",
        "серпень",
        "серпня"
    ],
    "september": [
        "вер",
        "вересень",
        "вересня"
    ],
    "october": [
        "жов",
        "жовт",
        "жовтень",
        "жовтня"
    ],
    "november": [
        "лис",
        "лист",
        "листопад",
        "листопада"
    ],
    "december": [
        "гру",
        "груд",
        "грудень",
        "грудня"
    ],
    "monday": [
        "пн",
        "понеділок",
        "пон"
    ],
    "tuesday": [
        "вт",
        "вівторок",
        "вів"
    ],
    "wednesday": [
        "середа",
        "ср"
    ],
    "thursday": [
        "четвер",
        "чт",
        "чет"
    ],
    "friday": [
        "п'ятниця",
        "пт"
    ],
    "saturday": [
        "сб",
        "субота",
        "суб"
    ],
    "sunday": [
        "нд",
        "неділя",
        "нед"
    ],
    "am": [
        "дп"
    ],
    "pm": [
        "пп"
    ],
    "year": [
        "р",
        "рік",
        "роки",
        "років"
    ],
    "month": [
        "міс",
        "місяць",
        "місяці",
        "місяців"
    ],
    "week": [
        "тиж",
        "тиждень",
        "тижні",
        "тижнів"
    ],
    "day": [
        "д",
        "день",
        "дні",
        "днів"
    ],
    "hour": [
        "год",
        "година",
        "години",
        "годин",
        "годину",
        "г"
    ],
    "minute": [
        "хв",
        "хвилина",
        "хвилини",
        "хвилин",
        "хвилину"
    ],
    "second": [
        "с",
        "секунда",
        "секунди",
        "секунд",
        "секунду",
        "сек"
    ],
    "relative-type": {
        "0 day ago": [
            "сьогодні"
        ],
        "0 hour ago": [
            "цієї години"
        ],
        "0 minute ago": [
            "цієї хвилини"
        ],
        "0 month ago": [
            "цього місяця"
        ],
        "0 second ago": [
            "зараз"
        ],
        "0 week ago": [
            "цього тижня"
        ],
        "0 year ago": [
            "цього року"
        ],
        "1 day ago": [
            "учора",
            "вчора"
        ],
        "1 month ago": [
            "минулого місяця"
        ],
        "1 week ago": [
            "минулого тижня"
        ],
        "1 year ago": [
            "торік"
        ],
        "in 1 day": [
            "завтра"
        ],
        "in 1 month": [
            "наступного місяця"
        ],
        "in 1 week": [
            "наступного тижня"
        ],
        "in 1 year": [
            "наступного року"
        ],
        "2 day ago": [
            "позавчора"
        ]
    },
    "relative-type-regex": {
        "\\1 day ago": [
            "(\\d+) д тому",
            "(\\d+) день тому",
            "(\\d+) дн тому",
            "(\\d+) дня тому"
        ],
        "\\1 hour ago": [
            "(\\d+) год тому",
            "(\\d+) години тому",
            "(\\d+) годину тому"
        ],
        "\\1 minute ago": [
            "(\\d+) хв тому",
            "(\\d+) хвилини тому",
            "(\\d+) хвилину тому"
        ],
        "\\1 month ago": [
            "(\\d+) міс тому",
            "(\\d+) місяць тому",
            "(\\d+) місяця тому"
        ],
        "\\1 second ago": [
            "(\\d+) с тому",
            "(\\d+) секунди тому",
            "(\\d+) секунду тому"
        ],
        "\\1 week ago": [
            "(\\d+) тиж тому",
            "(\\d+) тиждень тому",
            "(\\d+) тижня тому"
        ],
        "\\1 year ago": [
            "(\\d+) р тому",
            "(\\d+) року тому",
            "(\\d+) рік тому"
        ],
        "in \\1 day": [
            "за (\\d+) д",
            "через (\\d+) день",
            "через (\\d+) дн",
            "через (\\d+) дня"
        ],
        "in \\1 hour": [
            "за (\\d+) год",
            "через (\\d+) год",
            "через (\\d+) години",
            "через (\\d+) годину"
        ],
        "in \\1 minute": [
            "за (\\d+) хв",
            "через (\\d+) хв",
            "через (\\d+) хвилини",
            "через (\\d+) хвилину"
        ],
        "in \\1 month": [
            "за (\\d+) міс",
            "через (\\d+) міс",
            "через (\\d+) місяць",
            "через (\\d+) місяця"
        ],
        "in \\1 second": [
            "за (\\d+) с",
            "через (\\d+) с",
            "через (\\d+) секунди",
            "через (\\d+) секунду"
        ],
        "in \\1 week": [
            "за (\\d+) тиж",
            "через (\\d+) тиж",
            "через (\\d+) тиждень",
            "через (\\d+) тижня"
        ],
        "in \\1 year": [
            "за (\\d+) р",
            "через (\\d+) р",
            "через (\\d+) року",
            "через (\\d+) рік"
        ]
    },
    "locale_specific": {},
    "skip": [
        "близько",
        "о",
        "об",
        "і",
        " ",
        "'",
        ",",
        "-",
        ".",
        "/",
        ";",
        "@",
        "[",
        "]",
        "|",
        "，"
    ],
    "sentence_splitter_group": 1,
    "ago": [
        "тому",
        "назад"
    ],
    "in": [
        "протягом"
    ],
    "simplifications": [
        {
            "^година": "1 година"
        },
        {
            "^годину": "1 годину"
        },
        {
            "^хвилину": "1 хвилину"
        },
        {
            "^секунду": "1 секунду"
        },
        {
            "кілька секунд": "44 секунди"
        },
        {
            "кілька хвилин": "2 хвилини"
        },
        {
            "опів на": "30 хвилин"
        },
        {
            "за чверть": "15 хвилин"
        }
    ]
}
