# Singularity

[![CI](https://github.com/hpcng/singularity/actions/workflows/ci.yml/badge.svg)](https://github.com/hpcng/singularity/actions/workflows/ci.yml)

- [Guidelines for Contributing](CONTRIBUTING.md)
- [Pull Request Template](.github/PULL_REQUEST_TEMPLATE.md)
- [Project License](LICENSE.md)
- [Documentation](https://singularity.hpcng.org/docs/)
- [Community Meetings / Minutes / Roadmap](https://drive.google.com/drive/u/0/folders/1npfBhIDxqeJIUHZ0tMeuHPvc_iB4T2B6)
- [Support](#support)
- [Citation](#citing-singularity)

Singularity is an open source container platform designed to be simple, fast,
and secure. Singularity is optimized for compute focused enterprise and HPC
workloads, allowing untrusted users to run untrusted containers in a trusted
way.

Check out [talks about Singularity](https://singularity.hpcng.org/talks)
and some [use cases of Singularity](https://singularity.hpcng.org/usecases)
on our website.


## Getting Started with Singularity

To install Singularity from source, see the [installation
instructions](INSTALL.md). For other installation options, see [our
guide](https://singularity.hpcng.org/admin-docs/master/installation.html).

System administrators can learn how to configure Singularity, and get an
overview of its architecture and security features in the [administrator
guide](https://singularity.hpcng.org/admin-docs/master/).

For users, see the [user
guide](https://singularity.hpcng.org/user-docs/master/) for details on how to use
and build Singularity containers.

## Contributing to Singularity

Community contributions are always greatly appreciated. To start developing
Singularity, check out the [guidelines for contributing](CONTRIBUTING.md).

Our roadmap, other documents, and user/developer meeting information can be
found in the [singularity community page](https://singularity.hpcng.org/help).

We also welcome contributions to our [user
guide](https://github.com/hpcng/singularity-userdocs) and [admin
guide](https://github.com/hpcng/singularity-admindocs).

## Support

To get help with Singularity, check out the [Singularity
Help](https://singularity.hpcng.org/help) web page.

## Go Version Compatibility

Singularity aims to maintain support for the two most recent stable versions
of Go. This corresponds to the Go
[Release Maintenance
Policy](https://github.com/golang/go/wiki/Go-Release-Cycle#release-maintenance)
and [Security Policy](https://golang.org/security),
ensuring critical bug fixes and security patches are available for all
supported language versions.

## Citing Singularity

```
Kurtzer GM, Sochat V, Bauer MW (2017) Singularity: Scientific containers for mobility of compute. PLoS ONE 12(5): e0177459. https://doi.org/10.1371/journal.pone.0177459
```

We also have a Zenodo citation:

```
Kurtzer, Gregory M. et. al. Singularity - Linux application and environment
containers for science. 10.5281/zenodo.1310023
```

https://doi.org/10.5281/zenodo.1310023

This is an 'all versions' DOI. Follow the link to Zenodo to obtain a DOI specific
to a particular version of Singularity.


## License

_Unless otherwise noted, this project is licensed under a 3-clause BSD license
found in the [license file](LICENSE.md)._
