/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import java.nio.Bits;
import java.nio.ByteBuffer;
import java.nio.ByteBufferAsLongBufferRB;
import java.nio.ByteOrder;
import java.nio.LongBuffer;

class ByteBufferAsLongBufferB
extends LongBuffer {
    protected final ByteBuffer bb;
    protected final int offset;

    ByteBufferAsLongBufferB(ByteBuffer bb) {
        super(-1, 0, bb.remaining() >> 3, bb.remaining() >> 3);
        this.bb = bb;
        int cap = this.capacity();
        this.limit(cap);
        int pos = this.position();
        assert (pos <= cap);
        this.offset = pos;
    }

    ByteBufferAsLongBufferB(ByteBuffer bb, int mark, int pos, int lim, int cap, int off) {
        super(mark, pos, lim, cap);
        this.bb = bb;
        this.offset = off;
    }

    @Override
    public LongBuffer slice() {
        int lim;
        int pos = this.position();
        int rem = pos <= (lim = this.limit()) ? lim - pos : 0;
        int off = (pos << 3) + this.offset;
        assert (off >= 0);
        return new ByteBufferAsLongBufferB(this.bb, -1, 0, rem, rem, off);
    }

    @Override
    public LongBuffer duplicate() {
        return new ByteBufferAsLongBufferB(this.bb, this.markValue(), this.position(), this.limit(), this.capacity(), this.offset);
    }

    @Override
    public LongBuffer asReadOnlyBuffer() {
        return new ByteBufferAsLongBufferRB(this.bb, this.markValue(), this.position(), this.limit(), this.capacity(), this.offset);
    }

    protected int ix(int i) {
        return (i << 3) + this.offset;
    }

    @Override
    public long get() {
        return Bits.getLongB(this.bb, this.ix(this.nextGetIndex()));
    }

    @Override
    public long get(int i) {
        return Bits.getLongB(this.bb, this.ix(this.checkIndex(i)));
    }

    @Override
    public LongBuffer put(long x) {
        Bits.putLongB(this.bb, this.ix(this.nextPutIndex()), x);
        return this;
    }

    @Override
    public LongBuffer put(int i, long x) {
        Bits.putLongB(this.bb, this.ix(this.checkIndex(i)), x);
        return this;
    }

    @Override
    public LongBuffer compact() {
        int pos = this.position();
        int lim = this.limit();
        assert (pos <= lim);
        int rem = pos <= lim ? lim - pos : 0;
        ByteBuffer db = this.bb.duplicate();
        db.limit(this.ix(lim));
        db.position(this.ix(0));
        ByteBuffer sb = db.slice();
        sb.position(pos << 3);
        sb.compact();
        this.position(rem);
        this.limit(this.capacity());
        this.discardMark();
        return this;
    }

    @Override
    public boolean isDirect() {
        return this.bb.isDirect();
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public ByteOrder order() {
        return ByteOrder.BIG_ENDIAN;
    }
}

