/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.core;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import javax.management.ObjectName;
import org.apache.catalina.Container;
import org.apache.catalina.Engine;
import org.apache.catalina.Executor;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleState;
import org.apache.catalina.Server;
import org.apache.catalina.Service;
import org.apache.catalina.connector.Connector;
import org.apache.catalina.mbeans.MBeanUtils;
import org.apache.catalina.util.LifecycleMBeanBase;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.res.StringManager;

public class StandardService
extends LifecycleMBeanBase
implements Service {
    private static final Log log = LogFactory.getLog(StandardService.class);
    private static final String info = "org.apache.catalina.core.StandardService/1.0";
    private String name = null;
    private static final StringManager sm = StringManager.getManager((String)"org.apache.catalina.core");
    private Server server = null;
    protected PropertyChangeSupport support = new PropertyChangeSupport(this);
    protected Connector[] connectors = new Connector[0];
    private final Object connectorsLock = new Object();
    protected ArrayList<Executor> executors = new ArrayList();
    protected Container container = null;
    private ClassLoader parentClassLoader = null;

    @Override
    public Container getContainer() {
        return this.container;
    }

    @Override
    public void setContainer(Container container) {
        Container container2 = this.container;
        if (container2 != null && container2 instanceof Engine) {
            ((Engine)container2).setService(null);
        }
        this.container = container;
        if (this.container != null && this.container instanceof Engine) {
            ((Engine)this.container).setService(this);
        }
        if (this.getState().isAvailable() && this.container != null) {
            try {
                this.container.start();
            }
            catch (LifecycleException lifecycleException) {
                // empty catch block
            }
        }
        if (this.getState().isAvailable() && container2 != null) {
            try {
                container2.stop();
            }
            catch (LifecycleException lifecycleException) {
                // empty catch block
            }
        }
        this.support.firePropertyChange("container", container2, this.container);
    }

    @Override
    public String getInfo() {
        return info;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String string) {
        this.name = string;
    }

    @Override
    public Server getServer() {
        return this.server;
    }

    @Override
    public void setServer(Server server) {
        this.server = server;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addConnector(Connector connector) {
        Object object = this.connectorsLock;
        synchronized (object) {
            connector.setService(this);
            Connector[] connectorArray = new Connector[this.connectors.length + 1];
            System.arraycopy(this.connectors, 0, connectorArray, 0, this.connectors.length);
            connectorArray[this.connectors.length] = connector;
            this.connectors = connectorArray;
            if (this.getState().isAvailable()) {
                try {
                    connector.start();
                }
                catch (LifecycleException lifecycleException) {
                    log.error((Object)sm.getString("standardService.connector.startFailed", new Object[]{connector}), (Throwable)lifecycleException);
                }
            }
            this.support.firePropertyChange("connector", null, connector);
        }
    }

    public ObjectName[] getConnectorNames() {
        ObjectName[] objectNameArray = new ObjectName[this.connectors.length];
        for (int i = 0; i < objectNameArray.length; ++i) {
            objectNameArray[i] = this.connectors[i].getObjectName();
        }
        return objectNameArray;
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.addPropertyChangeListener(propertyChangeListener);
    }

    @Override
    public Connector[] findConnectors() {
        return this.connectors;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeConnector(Connector connector) {
        Object object = this.connectorsLock;
        synchronized (object) {
            int n;
            int n2 = -1;
            for (n = 0; n < this.connectors.length; ++n) {
                if (connector != this.connectors[n]) continue;
                n2 = n;
                break;
            }
            if (n2 < 0) {
                return;
            }
            if (this.connectors[n2].getState().isAvailable()) {
                try {
                    this.connectors[n2].stop();
                }
                catch (LifecycleException lifecycleException) {
                    log.error((Object)sm.getString("standardService.connector.stopFailed", new Object[]{this.connectors[n2]}), (Throwable)lifecycleException);
                }
            }
            connector.setService(null);
            n = 0;
            Connector[] connectorArray = new Connector[this.connectors.length - 1];
            for (int i = 0; i < this.connectors.length; ++i) {
                if (i == n2) continue;
                connectorArray[n++] = this.connectors[i];
            }
            this.connectors = connectorArray;
            this.support.firePropertyChange("connector", connector, null);
        }
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.removePropertyChangeListener(propertyChangeListener);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("StandardService[");
        stringBuilder.append(this.getName());
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addExecutor(Executor executor) {
        ArrayList<Executor> arrayList = this.executors;
        synchronized (arrayList) {
            if (!this.executors.contains(executor)) {
                this.executors.add(executor);
                if (this.getState().isAvailable()) {
                    try {
                        executor.start();
                    }
                    catch (LifecycleException lifecycleException) {
                        log.error((Object)"Executor.start", (Throwable)lifecycleException);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Executor[] findExecutors() {
        ArrayList<Executor> arrayList = this.executors;
        synchronized (arrayList) {
            Executor[] executorArray = new Executor[this.executors.size()];
            this.executors.toArray(executorArray);
            return executorArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Executor getExecutor(String string) {
        ArrayList<Executor> arrayList = this.executors;
        synchronized (arrayList) {
            for (Executor executor : this.executors) {
                if (!string.equals(executor.getName())) continue;
                return executor;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeExecutor(Executor executor) {
        ArrayList<Executor> arrayList = this.executors;
        synchronized (arrayList) {
            if (this.executors.remove(executor) && this.getState().isAvailable()) {
                try {
                    executor.stop();
                }
                catch (LifecycleException lifecycleException) {
                    log.error((Object)"Executor.stop", (Throwable)lifecycleException);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void startInternal() throws LifecycleException {
        Object object;
        if (log.isInfoEnabled()) {
            log.info((Object)sm.getString("standardService.start.name", new Object[]{this.name}));
        }
        this.setState(LifecycleState.STARTING);
        if (this.container != null) {
            object = this.container;
            synchronized (object) {
                this.container.start();
            }
        }
        object = this.executors;
        synchronized (object) {
            for (Executor executor : this.executors) {
                executor.start();
            }
        }
        object = this.connectorsLock;
        synchronized (object) {
            for (Connector connector : this.connectors) {
                try {
                    if (connector.getState() == LifecycleState.FAILED) continue;
                    connector.start();
                }
                catch (Exception exception) {
                    log.error((Object)sm.getString("standardService.connector.startFailed", new Object[]{connector}), (Throwable)exception);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void stopInternal() throws LifecycleException {
        ArrayList<Executor> arrayList = this.connectorsLock;
        synchronized (arrayList) {
            for (Connector connector : this.connectors) {
                try {
                    connector.pause();
                }
                catch (Exception exception) {
                    log.error((Object)sm.getString("standardService.connector.pauseFailed", new Object[]{connector}), (Throwable)exception);
                }
            }
        }
        if (log.isInfoEnabled()) {
            log.info((Object)sm.getString("standardService.stop.name", new Object[]{this.name}));
        }
        this.setState(LifecycleState.STOPPING);
        if (this.container != null) {
            arrayList = this.container;
            synchronized (arrayList) {
                this.container.stop();
            }
        }
        arrayList = this.connectorsLock;
        synchronized (arrayList) {
            for (Connector connector : this.connectors) {
                if (!LifecycleState.STARTED.equals((Object)connector.getState())) continue;
                try {
                    connector.stop();
                }
                catch (Exception exception) {
                    log.error((Object)sm.getString("standardService.connector.stopFailed", new Object[]{connector}), (Throwable)exception);
                }
            }
        }
        arrayList = this.executors;
        synchronized (arrayList) {
            for (Executor executor : this.executors) {
                executor.stop();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void initInternal() throws LifecycleException {
        super.initInternal();
        if (this.container != null) {
            this.container.init();
        }
        for (Executor executor : this.findExecutors()) {
            if (executor instanceof LifecycleMBeanBase) {
                ((LifecycleMBeanBase)((Object)executor)).setDomain(this.getDomain());
            }
            executor.init();
        }
        Object object = this.connectorsLock;
        synchronized (object) {
            for (Connector connector : this.connectors) {
                try {
                    connector.init();
                }
                catch (Exception exception) {
                    String string = sm.getString("standardService.connector.initFailed", new Object[]{connector});
                    log.error((Object)string, (Throwable)exception);
                    if (!Boolean.getBoolean("org.apache.catalina.startup.EXIT_ON_INIT_FAILURE")) continue;
                    throw new LifecycleException(string);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void destroyInternal() throws LifecycleException {
        Executor[] executorArray = this.connectorsLock;
        synchronized (this.connectorsLock) {
            Connector[] connectorArray = this.connectors;
            int n = connectorArray.length;
            for (int i = 0; i < n; ++i) {
                Connector connector = connectorArray[i];
                try {
                    connector.destroy();
                    continue;
                }
                catch (Exception exception) {
                    log.error((Object)sm.getString("standardService.connector.destroyFailed", new Object[]{connector}), (Throwable)exception);
                }
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            for (Executor executor : this.findExecutors()) {
                executor.destroy();
            }
            if (this.container != null) {
                this.container.destroy();
            }
            super.destroyInternal();
            return;
        }
    }

    @Override
    public ClassLoader getParentClassLoader() {
        if (this.parentClassLoader != null) {
            return this.parentClassLoader;
        }
        if (this.server != null) {
            return this.server.getParentClassLoader();
        }
        return ClassLoader.getSystemClassLoader();
    }

    @Override
    public void setParentClassLoader(ClassLoader classLoader) {
        ClassLoader classLoader2 = this.parentClassLoader;
        this.parentClassLoader = classLoader;
        this.support.firePropertyChange("parentClassLoader", classLoader2, this.parentClassLoader);
    }

    @Override
    protected String getDomainInternal() {
        return MBeanUtils.getDomain(this);
    }

    @Override
    public final String getObjectNameKeyProperties() {
        return "type=Service";
    }
}

