/*
 * Decompiled with CFR 0.152.
 */
package org.apache.coyote;

import java.security.AccessController;
import org.apache.coyote.AsyncContextCallback;
import org.apache.coyote.Constants;
import org.apache.coyote.ContainerThreadMarker;
import org.apache.coyote.Processor;
import org.apache.tomcat.util.net.AbstractEndpoint;
import org.apache.tomcat.util.res.StringManager;
import org.apache.tomcat.util.security.PrivilegedGetTccl;
import org.apache.tomcat.util.security.PrivilegedSetTccl;

public class AsyncStateMachine<S> {
    private static final StringManager sm = StringManager.getManager(AsyncStateMachine.class);
    private volatile AsyncState state = AsyncState.DISPATCHED;
    private AsyncContextCallback asyncCtxt = null;
    private Processor<S> processor;

    public AsyncStateMachine(Processor<S> processor) {
        this.processor = processor;
    }

    public boolean isAsync() {
        return this.state.isAsync();
    }

    public boolean isAsyncDispatching() {
        return this.state.isDispatching();
    }

    public boolean isAsyncStarted() {
        return this.state.isStarted();
    }

    public boolean isAsyncTimingOut() {
        return this.state == AsyncState.TIMING_OUT;
    }

    public boolean isAsyncError() {
        return this.state == AsyncState.ERROR;
    }

    public boolean isCompleting() {
        return this.state.isCompleting();
    }

    public synchronized void asyncStart(AsyncContextCallback asyncContextCallback) {
        if (this.state != AsyncState.DISPATCHED) {
            throw new IllegalStateException(sm.getString("asyncStateMachine.invalidAsyncState", new Object[]{"asyncStart()", this.state}));
        }
        this.state = AsyncState.STARTING;
        this.asyncCtxt = asyncContextCallback;
    }

    public synchronized AbstractEndpoint.Handler.SocketState asyncPostProcess() {
        if (this.state == AsyncState.COMPLETE_PENDING) {
            this.state = AsyncState.COMPLETING;
            return AbstractEndpoint.Handler.SocketState.ASYNC_END;
        }
        if (this.state == AsyncState.DISPATCH_PENDING) {
            this.state = AsyncState.DISPATCHING;
            return AbstractEndpoint.Handler.SocketState.ASYNC_END;
        }
        if (this.state == AsyncState.STARTING) {
            this.state = AsyncState.STARTED;
            return AbstractEndpoint.Handler.SocketState.LONG;
        }
        if (this.state == AsyncState.MUST_COMPLETE || this.state == AsyncState.COMPLETING) {
            this.asyncCtxt.fireOnComplete();
            this.state = AsyncState.DISPATCHED;
            return AbstractEndpoint.Handler.SocketState.ASYNC_END;
        }
        if (this.state == AsyncState.MUST_DISPATCH) {
            this.state = AsyncState.DISPATCHING;
            return AbstractEndpoint.Handler.SocketState.ASYNC_END;
        }
        if (this.state == AsyncState.DISPATCHING) {
            this.state = AsyncState.DISPATCHED;
            return AbstractEndpoint.Handler.SocketState.ASYNC_END;
        }
        if (this.state == AsyncState.STARTED) {
            return AbstractEndpoint.Handler.SocketState.LONG;
        }
        throw new IllegalStateException(sm.getString("asyncStateMachine.invalidAsyncState", new Object[]{"asyncPostProcess()", this.state}));
    }

    public synchronized boolean asyncComplete() {
        if (!ContainerThreadMarker.isContainerThread() && this.state == AsyncState.STARTING) {
            this.state = AsyncState.COMPLETE_PENDING;
            return false;
        }
        boolean bl = false;
        if (this.state == AsyncState.STARTING || this.state == AsyncState.MUST_ERROR) {
            this.state = AsyncState.MUST_COMPLETE;
        } else if (this.state == AsyncState.STARTED) {
            this.state = AsyncState.COMPLETING;
            bl = true;
        } else if (this.state == AsyncState.TIMING_OUT || this.state == AsyncState.ERROR) {
            this.state = AsyncState.COMPLETING;
        } else {
            throw new IllegalStateException(sm.getString("asyncStateMachine.invalidAsyncState", new Object[]{"asyncComplete()", this.state}));
        }
        return bl;
    }

    public synchronized boolean asyncTimeout() {
        if (this.state == AsyncState.STARTED) {
            this.state = AsyncState.TIMING_OUT;
            return true;
        }
        if (this.state == AsyncState.COMPLETING || this.state == AsyncState.DISPATCHING || this.state == AsyncState.DISPATCHED) {
            return false;
        }
        throw new IllegalStateException(sm.getString("asyncStateMachine.invalidAsyncState", new Object[]{"asyncTimeout()", this.state}));
    }

    public synchronized boolean asyncDispatch() {
        if (!ContainerThreadMarker.isContainerThread() && this.state == AsyncState.STARTING) {
            this.state = AsyncState.DISPATCH_PENDING;
            return false;
        }
        boolean bl = false;
        if (this.state == AsyncState.STARTING || this.state == AsyncState.MUST_ERROR) {
            this.state = AsyncState.MUST_DISPATCH;
        } else if (this.state == AsyncState.STARTED) {
            this.state = AsyncState.DISPATCHING;
            bl = true;
        } else if (this.state == AsyncState.TIMING_OUT || this.state == AsyncState.ERROR) {
            this.state = AsyncState.DISPATCHING;
        } else {
            throw new IllegalStateException(sm.getString("asyncStateMachine.invalidAsyncState", new Object[]{"asyncDispatch()", this.state}));
        }
        return bl;
    }

    public synchronized void asyncDispatched() {
        if (this.state != AsyncState.DISPATCHING && this.state != AsyncState.MUST_DISPATCH) {
            throw new IllegalStateException(sm.getString("asyncStateMachine.invalidAsyncState", new Object[]{"asyncDispatched()", this.state}));
        }
        this.state = AsyncState.DISPATCHED;
    }

    public synchronized boolean asyncError() {
        this.state = this.state == AsyncState.STARTING ? AsyncState.MUST_ERROR : AsyncState.ERROR;
        return !ContainerThreadMarker.isContainerThread();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void asyncRun(Runnable runnable) {
        if (this.state == AsyncState.STARTING || this.state == AsyncState.STARTED) {
            ClassLoader classLoader;
            PrivilegedGetTccl privilegedGetTccl;
            if (Constants.IS_SECURITY_ENABLED) {
                privilegedGetTccl = new PrivilegedGetTccl();
                classLoader = (ClassLoader)AccessController.doPrivileged(privilegedGetTccl);
            } else {
                classLoader = Thread.currentThread().getContextClassLoader();
            }
            try {
                if (Constants.IS_SECURITY_ENABLED) {
                    privilegedGetTccl = new PrivilegedSetTccl(this.getClass().getClassLoader());
                    AccessController.doPrivileged(privilegedGetTccl);
                } else {
                    Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
                }
                this.processor.getExecutor().execute(runnable);
            }
            finally {
                if (Constants.IS_SECURITY_ENABLED) {
                    privilegedGetTccl = new PrivilegedSetTccl(classLoader);
                    AccessController.doPrivileged(privilegedGetTccl);
                } else {
                    Thread.currentThread().setContextClassLoader(classLoader);
                }
            }
        } else {
            throw new IllegalStateException(sm.getString("asyncStateMachine.invalidAsyncState", new Object[]{"asyncRun()", this.state}));
        }
    }

    synchronized boolean isAvailable() {
        if (this.asyncCtxt == null) {
            return false;
        }
        return this.asyncCtxt.isAvailable();
    }

    public synchronized void recycle() {
        this.notifyAll();
        this.asyncCtxt = null;
        this.state = AsyncState.DISPATCHED;
    }

    private static enum AsyncState {
        DISPATCHED(false, false, false, false),
        STARTING(true, true, false, false),
        STARTED(true, true, false, false),
        MUST_COMPLETE(true, true, true, false),
        COMPLETE_PENDING(true, true, false, false),
        COMPLETING(true, false, true, false),
        TIMING_OUT(true, true, false, false),
        MUST_DISPATCH(true, true, false, true),
        DISPATCH_PENDING(true, true, false, false),
        DISPATCHING(true, false, false, true),
        MUST_ERROR(true, true, false, false),
        ERROR(true, true, false, false);

        private final boolean isAsync;
        private final boolean isStarted;
        private final boolean isCompleting;
        private final boolean isDispatching;

        private AsyncState(boolean bl, boolean bl2, boolean bl3, boolean bl4) {
            this.isAsync = bl;
            this.isStarted = bl2;
            this.isCompleting = bl3;
            this.isDispatching = bl4;
        }

        public boolean isAsync() {
            return this.isAsync;
        }

        public boolean isStarted() {
            return this.isStarted;
        }

        public boolean isDispatching() {
            return this.isDispatching;
        }

        public boolean isCompleting() {
            return this.isCompleting;
        }
    }
}

