/*
 * Decompiled with CFR 0.152.
 */
package org.openide.loaders;

import java.io.IOException;
import java.util.List;
import org.netbeans.api.templates.FileBuilder;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.MultiDataObject;
import org.openide.util.NbBundle;

public class FileEntry
extends MultiDataObject.Entry {
    static final long serialVersionUID = 5972727204237511983L;

    public FileEntry(MultiDataObject multiDataObject, FileObject fileObject) {
        MultiDataObject multiDataObject2 = multiDataObject;
        multiDataObject2.getClass();
        super(multiDataObject2, fileObject);
    }

    @Override
    public FileObject copy(FileObject fileObject, String string) throws IOException {
        FileObject fileObject2 = this.getFile();
        String string2 = fileObject2.getName() + string;
        return fileObject2.copy(fileObject, string2, fileObject2.getExt());
    }

    @Override
    public FileObject copyRename(FileObject fileObject, String string, String string2) throws IOException {
        FileObject fileObject2 = this.getFile();
        return fileObject2.copy(fileObject, string, string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FileObject rename(String string) throws IOException {
        boolean bl = this.isLocked();
        FileLock fileLock = this.takeLock();
        try {
            this.getFile().rename(fileLock, string, this.getFile().getExt());
        }
        finally {
            if (!bl) {
                fileLock.releaseLock();
            }
        }
        return this.getFile();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FileObject move(FileObject fileObject, String string) throws IOException {
        boolean bl = this.isLocked();
        FileObject fileObject2 = this.getFile();
        FileLock fileLock = this.takeLock();
        try {
            String string2 = fileObject2.getName() + string;
            FileObject fileObject3 = fileObject2.move(fileLock, fileObject, string2, fileObject2.getExt());
            if (fileObject3 == null) {
                throw new IOException(fileObject2 + "move(" + fileLock + ", " + fileObject + ", " + string2 + ", " + fileObject2.getExt() + " yields null!");
            }
            FileObject fileObject4 = fileObject3;
            return fileObject4;
        }
        finally {
            if (!bl) {
                fileLock.releaseLock();
            }
        }
    }

    @Override
    public void delete() throws IOException {
        boolean bl = this.isLocked();
        FileLock fileLock = this.takeLock();
        try {
            this.getFile().delete(fileLock);
        }
        finally {
            if (!bl) {
                fileLock.releaseLock();
            }
        }
    }

    @Override
    public FileObject createFromTemplate(FileObject fileObject, String string) throws IOException {
        FileObject fileObject2 = FileBuilder.createFromTemplate((FileObject)this.getFile(), (FileObject)fileObject, (String)string, DataObject.CreateAction.getCallParameters(string), (FileBuilder.Mode)FileBuilder.Mode.COPY);
        DataObject.setTemplate(fileObject2, false);
        return fileObject2;
    }

    public static final class Folder
    extends MultiDataObject.Entry {
        public Folder(MultiDataObject multiDataObject, FileObject fileObject) {
            MultiDataObject multiDataObject2 = multiDataObject;
            multiDataObject2.getClass();
            super(multiDataObject2, fileObject);
        }

        @Override
        public FileObject copy(FileObject fileObject, String string) throws IOException {
            String string2 = string + (this.getFile().getExt().length() > 0 ? "." + this.getFile().getExt() : "");
            FileObject fileObject2 = FileUtil.createFolder((FileObject)fileObject, (String)(this.getFile().getName() + string2));
            FileUtil.copyAttributes((FileObject)this.getFile(), (FileObject)fileObject2);
            return fileObject2;
        }

        @Override
        public FileObject move(FileObject fileObject, String string) throws IOException {
            return this.copy(fileObject, string);
        }

        @Override
        public FileObject createFromTemplate(FileObject fileObject, String string) throws IOException {
            if (string == null) {
                string = FileUtil.findFreeFileName((FileObject)fileObject, (String)this.getFile().getName(), (String)this.getFile().getExt());
            }
            FileObject fileObject2 = FileUtil.createFolder((FileObject)fileObject, (String)string);
            FileUtil.copyAttributes((FileObject)this.getFile(), (FileObject)fileObject2);
            DataObject.setTemplate(fileObject2, false);
            return fileObject2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public FileObject rename(String string) throws IOException {
            boolean bl = this.isLocked();
            FileLock fileLock = this.takeLock();
            try {
                this.getFile().rename(fileLock, string, null);
            }
            finally {
                if (!bl) {
                    fileLock.releaseLock();
                }
            }
            return this.getFile();
        }

        @Override
        public void delete() throws IOException {
            boolean bl = this.isLocked();
            FileLock fileLock = this.takeLock();
            try {
                this.getFile().delete(fileLock);
            }
            finally {
                if (!bl) {
                    fileLock.releaseLock();
                }
            }
        }
    }

    public static final class Numb
    extends MultiDataObject.Entry {
        static final long serialVersionUID = -6572157492885890612L;

        public Numb(MultiDataObject multiDataObject, FileObject fileObject) {
            MultiDataObject multiDataObject2 = multiDataObject;
            multiDataObject2.getClass();
            super(multiDataObject2, fileObject);
        }

        @Override
        public boolean isImportant() {
            return false;
        }

        @Override
        public FileObject copy(FileObject fileObject, String string) {
            return null;
        }

        @Override
        public FileObject rename(String string) throws IOException {
            this.stdBehaving();
            return null;
        }

        @Override
        public FileObject move(FileObject fileObject, String string) throws IOException {
            this.stdBehaving();
            return null;
        }

        @Override
        public void delete() throws IOException {
            this.stdBehaving();
        }

        private void stdBehaving() throws IOException {
            if (this.getFile() == null) {
                return;
            }
            if (this.isLocked()) {
                throw new IOException(NbBundle.getBundle(FileEntry.class).getString("EXC_SharedAccess"));
            }
            FileLock fileLock = this.takeLock();
            try {
                this.getFile().delete(fileLock);
            }
            finally {
                if (fileLock != null) {
                    fileLock.releaseLock();
                }
            }
        }

        @Override
        public FileObject createFromTemplate(FileObject fileObject, String string) {
            return null;
        }
    }

    public static abstract class Format
    extends FileEntry {
        static final long serialVersionUID = 8896750589709521197L;

        public Format(MultiDataObject multiDataObject, FileObject fileObject) {
            super(multiDataObject, fileObject);
        }

        @Override
        public FileObject createFromTemplate(FileObject fileObject, String string) throws IOException {
            String string2 = this.getFile().getExt();
            if (string == null) {
                string = FileUtil.findFreeFileName((FileObject)fileObject, (String)this.getFile().getName(), (String)string2);
            }
            java.text.Format format = this.createFormat(fileObject, string, string2);
            List list = new FileBuilder(this.getFile(), fileObject).name(string).withParameters(DataObject.CreateAction.getCallParameters(string)).useFormat(format).build();
            FileObject fileObject2 = (FileObject)list.get(0);
            DataObject.setTemplate(fileObject2, false);
            return fileObject2;
        }

        protected abstract java.text.Format createFormat(FileObject var1, String var2, String var3);
    }
}

