/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.core.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import org.graalvm.visualvm.core.datasource.DataSource;
import org.graalvm.visualvm.core.datasource.descriptor.DataSourceDescriptor;
import org.graalvm.visualvm.core.datasource.descriptor.DataSourceDescriptorFactory;
import org.graalvm.visualvm.core.datasupport.DataRemovedListener;
import org.graalvm.visualvm.core.datasupport.Stateful;
import org.graalvm.visualvm.core.ui.DataSourceWindowManager;
import org.graalvm.visualvm.uisupport.UISupport;
import org.openide.util.NbBundle;

final class DataSourceCaption<X extends DataSource>
extends JPanel
implements PropertyChangeListener,
DataRemovedListener<DataSource> {
    private static final boolean ANIMATE = Boolean.getBoolean("org.graalvm.visualvm.core.ui.DataSourceCaption.animate");
    private static final int ANIMATION_RATE = Integer.getInteger("org.graalvm.visualvm.core.ui.DataSourceCaption.animationRate", 80);
    private static final Color DISABLED_CAPTION = new Color(128, 128, 128);
    private static final String APPLICATION_PID_PREFIX = "(pid";
    private static final String APPLICATION_PID_SUFFIX = ")";
    private final DataSource dataSourceMaster;
    private final DataSourceDescriptor<X> dataSourceMasterDescriptor;
    private final boolean tracksChanges;
    private boolean isAvailable;
    private boolean isDirty = false;
    private String name;
    private String description;
    private boolean finished = false;
    private JLabel presenter1;
    private JLabel presenter2;
    private Timer busyIconTimer;
    private int busyIconIndex;

    DataSourceCaption(X dataSource) {
        this.initComponents();
        this.dataSourceMaster = DataSourceWindowManager.getViewMaster(dataSource);
        this.tracksChanges = dataSource == this.dataSourceMaster;
        this.dataSourceMaster.addPropertyChangeListener(this);
        this.dataSourceMasterDescriptor = DataSourceDescriptorFactory.getDescriptor(this.dataSourceMaster);
        this.dataSourceMasterDescriptor.addPropertyChangeListener(this);
        this.initAvailable();
        this.name = this.dataSourceMasterDescriptor.getName();
        this.description = this.dataSourceMasterDescriptor.getDescription();
        this.updateCaption();
        this.updateDescription();
        this.updateAvailable();
        this.dataSourceMaster.notifyWhenRemoved(this);
    }

    @Override
    public void propertyChange(final PropertyChangeEvent evt) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                String propertyName = evt.getPropertyName();
                if ("prop_state".equals(propertyName)) {
                    int state = (Integer)evt.getNewValue();
                    DataSourceCaption.this.isAvailable = state == 1;
                    if (DataSourceCaption.this.tracksChanges && !DataSourceCaption.this.isDirty && DataSourceCaption.this.isAvailable && (Integer)evt.getOldValue() == 0) {
                        DataSourceCaption.this.isDirty = true;
                    }
                    DataSourceCaption.this.updateAvailable();
                    DataSourceCaption.this.updateCaption();
                } else if ("prop_name".equals(propertyName)) {
                    DataSourceCaption.this.name = (String)evt.getNewValue();
                    DataSourceCaption.this.updateCaption();
                } else if ("prop_description".equals(propertyName)) {
                    DataSourceCaption.this.description = (String)evt.getNewValue();
                    DataSourceCaption.this.updateDescription();
                } else if ("prop_icon".equals(propertyName)) {
                    // empty if block
                }
            }
        });
    }

    @Override
    public void dataRemoved(DataSource dataSource) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                DataSourceCaption.this.finish();
                DataSourceCaption.this.isAvailable = false;
                DataSourceCaption.this.updateAvailable();
                DataSourceCaption.this.updateCaption();
            }
        });
    }

    public synchronized void finish() {
        if (this.finished) {
            return;
        }
        this.finished = true;
        this.dataSourceMaster.removePropertyChangeListener(this);
        this.dataSourceMasterDescriptor.removePropertyChangeListener(this);
    }

    private void updateAvailable() {
        if (this.isAvailable) {
            if (ANIMATE) {
                this.busyIconIndex = 0;
                if (this.busyIconTimer == null) {
                    this.createTimer();
                }
                this.busyIconTimer.start();
            } else {
                this.presenter1.setIcon(new ImageIcon(this.getClass().getResource("/org/graalvm/visualvm/core/ui/resources/busy-icon4.png")));
            }
        } else {
            if (this.busyIconTimer != null) {
                this.busyIconTimer.stop();
            }
            this.presenter1.setIcon(new ImageIcon(this.getClass().getResource("/org/graalvm/visualvm/core/ui/resources/idle-icon.png")));
        }
        if (this.isDirty && !this.isOpaque()) {
            JLabel l = new JLabel(NbBundle.getMessage(DataSourceCaption.class, (String)"DataSourceCaption_LBL_Reload")){

                @Override
                public Dimension getMinimumSize() {
                    Dimension dim = super.getMinimumSize();
                    dim.height = super.getPreferredSize().height;
                    return dim;
                }
            };
            GridBagConstraints c = new GridBagConstraints();
            c.gridx = 2;
            c.gridy = 0;
            c.weighty = 1.0;
            c.anchor = 1792;
            c.insets = new Insets(0, 16, 0, 0);
            c.fill = 0;
            this.add((Component)l, c);
            JButton b = new JButton(NbBundle.getMessage(DataSourceCaption.class, (String)"DataSourceCaption_BTN_Reload")){

                @Override
                protected void fireActionPerformed(ActionEvent e) {
                    super.fireActionPerformed(e);
                    DataSourceWindowManager.sharedInstance().reopenDataSource(DataSourceCaption.this.dataSourceMaster);
                }

                @Override
                public Dimension getMinimumSize() {
                    Dimension dim = super.getMinimumSize();
                    dim.height = super.getPreferredSize().height;
                    return dim;
                }
            };
            c = new GridBagConstraints();
            c.gridx = 3;
            c.gridy = 0;
            c.weighty = 0.0;
            c.anchor = 1792;
            c.insets = new Insets(0, 8, 0, 0);
            c.fill = 0;
            this.add((Component)b, c);
            this.setOpaque(true);
            this.setBackground(UISupport.isDarkResultsBackground() ? new Color(150, 0, 0) : Color.YELLOW);
            this.invalidate();
            this.revalidate();
            this.doLayout();
            this.repaint();
        }
    }

    private void updateCaption() {
        this.name = this.name.replace(">", "&gt;");
        this.name = this.name.replace("<", "&lt;");
        Color textColor = this.isAvailable ? UIManager.getColor("Label.foreground") : DISABLED_CAPTION;
        this.presenter1.setForeground(textColor);
        this.presenter2.setForeground(textColor);
        if (this.name.contains(APPLICATION_PID_PREFIX) && this.name.contains(APPLICATION_PID_SUFFIX)) {
            int startPid = this.name.indexOf(APPLICATION_PID_PREFIX);
            this.presenter1.setText(this.name.substring(0, startPid));
            this.presenter2.setText(this.name.substring(startPid));
        } else {
            this.presenter1.setText(this.name);
            this.presenter2.setText("");
        }
    }

    private void updateDescription() {
        if (this.description == null || this.description.trim().isEmpty()) {
            this.presenter1.setToolTipText(null);
            this.presenter2.setToolTipText(null);
        } else {
            this.presenter1.setToolTipText(this.description);
            this.presenter2.setToolTipText(this.description);
        }
    }

    private void createTimer() {
        final Icon[] busyIcons = new Icon[15];
        for (int i = 0; i < busyIcons.length; ++i) {
            busyIcons[i] = new ImageIcon(this.getClass().getResource("/org/graalvm/visualvm/core/ui/resources/busy-icon" + i + ".png"));
        }
        this.busyIconTimer = new Timer(ANIMATION_RATE, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!ANIMATE) {
                    if (DataSourceCaption.this.busyIconTimer != null) {
                        DataSourceCaption.this.busyIconTimer.stop();
                    }
                    DataSourceCaption.this.presenter1.setIcon(new ImageIcon(this.getClass().getResource("/org/graalvm/visualvm/core/ui/resources/busy-icon4.png")));
                } else {
                    DataSourceCaption.this.busyIconIndex = (DataSourceCaption.this.busyIconIndex + 1) % busyIcons.length;
                    if (!DataSourceCaption.this.isShowing()) {
                        return;
                    }
                    DataSourceCaption.this.presenter1.setIcon(busyIcons[DataSourceCaption.this.busyIconIndex]);
                }
            }
        });
    }

    private void initAvailable() {
        Stateful statefulDataSource;
        this.isAvailable = this.dataSourceMaster instanceof Stateful ? (statefulDataSource = (Stateful)((Object)this.dataSourceMaster)).getState() == 1 : true;
    }

    private void initComponents() {
        this.setLayout(new GridBagLayout());
        this.presenter1 = new JLabel("XXX"){

            @Override
            public Dimension getMinimumSize() {
                Dimension dim = super.getMinimumSize();
                dim.height = super.getPreferredSize().height;
                return dim;
            }
        };
        Font f = this.presenter1.getFont();
        this.presenter1.setFont(f.deriveFont(1, f.getSize2D() * 1.2f));
        this.presenter1.setIconTextGap(6);
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.weighty = 1.0;
        c.anchor = 1792;
        c.fill = 0;
        this.add((Component)this.presenter1, c);
        this.presenter2 = new JLabel("(123)"){

            @Override
            public Dimension getMinimumSize() {
                Dimension dim = super.getMinimumSize();
                dim.height = super.getPreferredSize().height;
                return dim;
            }
        };
        this.presenter2.setFont(this.presenter2.getFont().deriveFont(this.presenter1.getFont().getSize2D()));
        c = new GridBagConstraints();
        c.gridx = 1;
        c.gridy = 0;
        c.weighty = 1.0;
        c.anchor = 1792;
        c.fill = 0;
        this.add((Component)this.presenter2, c);
        JLabel l = new JLabel(NbBundle.getMessage(DataSourceCaption.class, (String)"DataSourceCaption_LBL_Reload")){

            @Override
            public Dimension getMinimumSize() {
                Dimension dim = super.getMinimumSize();
                dim.height = super.getPreferredSize().height;
                return dim;
            }
        };
        c = new GridBagConstraints();
        c.gridx = 2;
        c.gridy = 0;
        c.weighty = 1.0;
        c.anchor = 1792;
        c.insets = new Insets(0, 16, 0, 0);
        c.fill = 0;
        this.add((Component)l, c);
        JButton b = new JButton(NbBundle.getMessage(DataSourceCaption.class, (String)"DataSourceCaption_BTN_Reload")){

            @Override
            public Dimension getMinimumSize() {
                Dimension dim = super.getMinimumSize();
                dim.height = super.getPreferredSize().height;
                return dim;
            }
        };
        c = new GridBagConstraints();
        c.gridx = 3;
        c.gridy = 0;
        c.weighty = 0.0;
        c.anchor = 1792;
        c.insets = new Insets(0, 8, 0, 0);
        c.fill = 0;
        this.add((Component)b, c);
        final Dimension fixedDim = new Dimension(0, this.getPreferredSize().height);
        JPanel spacer = new JPanel(null){
            {
                super(x0);
                this.setOpaque(false);
            }

            @Override
            public Dimension getPreferredSize() {
                return fixedDim;
            }

            @Override
            public Dimension getMinimumSize() {
                return fixedDim;
            }
        };
        c = new GridBagConstraints();
        c.gridx = 100;
        c.gridy = 0;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.anchor = 1792;
        c.fill = 2;
        this.add((Component)spacer, c);
        this.setOpaque(false);
        this.remove(l);
        this.remove(b);
    }
}

