/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.texparserlib.latex;

import com.dickimawbooks.texparserlib.ControlSequence;
import com.dickimawbooks.texparserlib.Expandable;
import com.dickimawbooks.texparserlib.TeXObject;
import com.dickimawbooks.texparserlib.TeXObjectList;
import com.dickimawbooks.texparserlib.TeXParser;
import com.dickimawbooks.texparserlib.TeXPath;
import com.dickimawbooks.texparserlib.latex.LaTeXParserListener;
import java.io.IOException;

public class Bibliography
extends ControlSequence {
    public Bibliography() {
        this("bibliography");
    }

    public Bibliography(String string) {
        super(string);
    }

    @Override
    public Object clone() {
        return new Bibliography(this.getName());
    }

    @Override
    public void process(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        TeXObjectList teXObjectList2;
        TeXObject teXObject = teXObjectList.popArg(teXParser);
        if (teXObject instanceof Expandable && (teXObjectList2 = ((Expandable)((Object)teXObject)).expandfully(teXParser, teXObjectList)) != null) {
            teXObject = teXObjectList2;
        }
        this.doBibliography(teXParser, teXObject);
    }

    @Override
    public void process(TeXParser teXParser) throws IOException {
        TeXObjectList teXObjectList;
        TeXObject teXObject = teXParser.popNextArg();
        if (teXObject instanceof Expandable && (teXObjectList = ((Expandable)((Object)teXObject)).expandfully(teXParser)) != null) {
            teXObject = teXObjectList;
        }
        this.doBibliography(teXParser, teXObject);
    }

    protected boolean doBibliography(TeXParser teXParser, TeXObject teXObject) throws IOException {
        LaTeXParserListener laTeXParserListener = (LaTeXParserListener)teXParser.getListener();
        String[] stringArray = teXObject.toString(teXParser).split(",");
        TeXPath[] teXPathArray = new TeXPath[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            teXPathArray[i] = new TeXPath(teXParser, stringArray[i].trim(), "bib");
            laTeXParserListener.addFileReference(teXPathArray[i]);
        }
        TeXPath teXPath = new TeXPath(teXParser, laTeXParserListener.getBblFile());
        laTeXParserListener.addFileReference(teXPath);
        return laTeXParserListener.bibliography(teXPathArray, teXPath);
    }
}

