/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.panel;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.Map;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import net.miginfocom.swing.MigLayout;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.gui.SwingGUI;
import net.sf.freecol.client.gui.panel.FreeColPanel;
import net.sf.freecol.client.gui.panel.PlayersTable;
import net.sf.freecol.client.gui.panel.Utility;
import net.sf.freecol.common.i18n.Messages;
import net.sf.freecol.common.io.FreeColDirectories;
import net.sf.freecol.common.model.GameOptions;
import net.sf.freecol.common.model.Nation;
import net.sf.freecol.common.model.NationOptions;
import net.sf.freecol.common.model.Specification;
import net.sf.freecol.common.option.MapGeneratorOptions;
import net.sf.freecol.common.option.OptionGroup;

public final class StartGamePanel
extends FreeColPanel {
    private static final Logger logger = Logger.getLogger(StartGamePanel.class.getName());
    private static final int START = 0;
    private static final int CANCEL = 1;
    private static final int READY = 3;
    private static final int CHAT = 4;
    private static final int GAME_OPTIONS = 5;
    private static final int MAP_GENERATOR_OPTIONS = 6;
    private boolean singlePlayerGame;
    private JCheckBox readyBox;
    private JTextField chat;
    private JTextArea chatArea;
    private JButton start;
    private JButton cancel;
    private JButton gameOptions;
    private JButton mapGeneratorOptions;
    private PlayersTable table;

    public StartGamePanel(FreeColClient freeColClient) {
        super(freeColClient, new MigLayout("fill, wrap 2"));
    }

    public void initialize(boolean singlePlayer) {
        this.removeAll();
        this.singlePlayerGame = singlePlayer;
        if (singlePlayer || this.getMyPlayer().isAdmin()) {
            Specification spec = this.getSpecification();
            String gtag = GameOptions.getXMLElementTagName();
            File gof = FreeColDirectories.getOptionsFile("game_options.xml");
            OptionGroup gog = gof.exists() ? spec.loadOptionsFile(gtag, gof) : null;
            gog = gog != null ? spec.mergeGroup(gog) : spec.getOptionGroup(gtag);
            Specification.saveOptionsFile(gog, gof);
            String mtag = MapGeneratorOptions.getXMLElementTagName();
            File mof = FreeColDirectories.getOptionsFile("map_generator_options.xml");
            OptionGroup mog = mof.exists() ? spec.loadOptionsFile(mtag, mof) : null;
            mog = mog != null ? spec.mergeGroup(mog) : spec.getOptionGroup(mtag);
            Specification.saveOptionsFile(mog, mof);
        }
        NationOptions nationOptions = this.getGame().getNationOptions();
        this.cancel = Utility.localizedButton("cancel");
        this.setCancelComponent(this.cancel);
        JScrollPane chatScroll = null;
        this.table = new PlayersTable(this.getFreeColClient(), nationOptions, this.getMyPlayer());
        this.start = Utility.localizedButton("startGame");
        this.gameOptions = Utility.localizedButton(Messages.nameKey(GameOptions.getXMLElementTagName()));
        this.mapGeneratorOptions = Utility.localizedButton(Messages.nameKey(MapGeneratorOptions.getXMLElementTagName()));
        this.readyBox = new JCheckBox(Messages.message("startGamePanel.iAmReady"));
        if (this.singlePlayerGame) {
            this.getMyPlayer().setReady(false);
            this.readyBox.setSelected(true);
        } else {
            this.readyBox.setSelected(this.getMyPlayer().isReady());
            this.chat = new JTextField();
            this.chatArea = new JTextArea();
            chatScroll = new JScrollPane(this.chatArea, 22, 31);
        }
        this.refreshPlayersTable();
        JScrollPane tableScroll = new JScrollPane(this.table, 20, 31);
        tableScroll.getViewport().setOpaque(false);
        this.add((Component)tableScroll, "width 600:, grow");
        if (!this.singlePlayerGame) {
            this.add((Component)chatScroll, "width 250:, grow");
        }
        this.add((Component)this.mapGeneratorOptions, "newline, split 2, growx, top, sg");
        this.add((Component)this.gameOptions, "growx, top, sg");
        if (!this.singlePlayerGame) {
            this.add((Component)this.chat, "grow, top");
        }
        this.add((Component)this.readyBox, "newline");
        this.add((Component)this.start, "newline, span, split 2, tag ok");
        this.add((Component)this.cancel, "tag cancel");
        this.start.setActionCommand(String.valueOf(0));
        this.cancel.setActionCommand(String.valueOf(1));
        this.readyBox.setActionCommand(String.valueOf(3));
        this.gameOptions.setActionCommand(String.valueOf(5));
        this.mapGeneratorOptions.setActionCommand(String.valueOf(6));
        if (!this.singlePlayerGame) {
            this.chat.setActionCommand(String.valueOf(4));
            this.chat.addActionListener(this);
            this.chatArea.setEditable(false);
            this.chatArea.setLineWrap(true);
            this.chatArea.setWrapStyleWord(true);
            this.chatArea.setText("");
        }
        this.start.addActionListener(this);
        this.cancel.addActionListener(this);
        this.readyBox.addActionListener(this);
        this.gameOptions.addActionListener(this);
        this.mapGeneratorOptions.addActionListener(this);
        this.setEnabled(true);
    }

    @Override
    public void requestFocus() {
        this.start.requestFocus();
    }

    public void updateMapGeneratorOptions() {
        this.getFreeColClient().getGame().getMapGeneratorOptions().getOption("model.option.mapWidth");
        this.getFreeColClient().getGame().getMapGeneratorOptions().getOption("model.option.mapHeight");
    }

    public void updateGameOptions() {
    }

    @Override
    public void setEnabled(boolean enabled) {
        Component[] components;
        super.setEnabled(enabled);
        for (Component component : components = this.getComponents()) {
            component.setEnabled(enabled);
        }
        if (this.singlePlayerGame && enabled) {
            this.readyBox.setEnabled(false);
        }
        if (enabled) {
            this.start.setEnabled(this.getFreeColClient().isAdmin());
        }
        this.gameOptions.setEnabled(enabled);
    }

    private boolean checkVictoryConditions() {
        Specification spec = this.getSpecification();
        if (this.singlePlayerGame && spec.getBoolean("model.option.victoryDefeatEuropeans") && !spec.getBoolean("model.option.victoryDefeatREF")) {
            int n = 0;
            for (Map.Entry<Nation, NationOptions.NationState> e : this.getGame().getNationOptions().getNations().entrySet()) {
                if (!e.getKey().getType().isEuropean() || e.getKey().isUnknownEnemy() || e.getValue() == NationOptions.NationState.NOT_AVAILABLE) continue;
                ++n;
            }
            if (n == 0) {
                this.getGUI().showInformationMessage("info.noEuropeans");
                return false;
            }
        }
        return true;
    }

    public void displayChat(String senderName, String message, boolean privateChat) {
        if (privateChat) {
            this.chatArea.append(senderName + " (" + Messages.message("private") + "): " + message + '\n');
        } else {
            this.chatArea.append(senderName + ": " + message + '\n');
        }
    }

    public void refreshPlayersTable() {
        if (this.table != null) {
            this.table.update();
        }
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        String command = ae.getActionCommand();
        FreeColClient fcc = this.getFreeColClient();
        SwingGUI gui = this.getGUI();
        try {
            switch (Integer.parseInt(command)) {
                case 0: {
                    int row = this.table.getSelectedRow();
                    int col = this.table.getSelectedColumn();
                    if (row > -1 && col > -1) {
                        this.table.getCellEditor(row, col).stopCellEditing();
                    }
                    if (!this.checkVictoryConditions()) break;
                    if (this.singlePlayerGame) {
                        this.getMyPlayer().setReady(true);
                    }
                    fcc.getPreGameController().requestLaunch();
                    break;
                }
                case 1: {
                    fcc.getConnectController().quitGame(true);
                    gui.removeFromCanvas(this);
                    gui.showNewPanel();
                    break;
                }
                case 3: {
                    fcc.getPreGameController().setReady(this.readyBox.isSelected());
                    this.refreshPlayersTable();
                    break;
                }
                case 4: {
                    if (!this.chat.getText().isEmpty()) {
                        fcc.getPreGameController().chat(this.chat.getText());
                        this.displayChat(this.getMyPlayer().getName(), this.chat.getText(), false);
                        this.chat.setText("");
                    }
                    break;
                }
                case 5: {
                    OptionGroup go = gui.showGameOptionsDialog(fcc.isAdmin(), true);
                    if (go != null) {
                        fcc.getGame().setGameOptions(go);
                        fcc.getPreGameController().updateGameOptions();
                    }
                    break;
                }
                case 6: {
                    OptionGroup mgo = gui.showMapGeneratorOptionsDialog(fcc.isAdmin());
                    if (mgo != null) {
                        fcc.getGame().setMapGeneratorOptions(mgo);
                        fcc.getPreGameController().updateMapGeneratorOptions();
                    }
                    break;
                }
                default: {
                    super.actionPerformed(ae);
                }
            }
        }
        catch (NumberFormatException nfe) {
            logger.warning("Invalid ActionEvent, not a number: " + command);
        }
    }

    @Override
    public void removeNotify() {
        this.start.removeActionListener(this);
        this.cancel.removeActionListener(this);
        this.readyBox.removeActionListener(this);
        this.gameOptions.removeActionListener(this);
        this.mapGeneratorOptions.removeActionListener(this);
        if (this.chat != null) {
            this.chat.removeActionListener(this);
        }
    }
}

