# This file has been autogenerated by the pywayland scanner

# Copyright © 2012, 2013 Intel Corporation
#
# Permission is hereby granted, free of charge, to any person obtaining a
# copy of this software and associated documentation files (the "Software"),
# to deal in the Software without restriction, including without limitation
# the rights to use, copy, modify, merge, publish, distribute, sublicense,
# and/or sell copies of the Software, and to permit persons to whom the
# Software is furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice (including the next
# paragraph) shall be included in all copies or substantial portions of the
# Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
# THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
# FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
# DEALINGS IN THE SOFTWARE.

from pywayland.protocol_core import Argument, ArgumentType, Global, Interface, Proxy, Resource
from ..wayland import WlKeyboard


class ZwpInputMethodContextV1(Interface):
    """Input method context

    Corresponds to a text input on the input method side. An input method
    context is created on text input activation on the input method side. It
    allows receiving information about the text input from the application via
    events. Input method contexts do not keep state after deactivation and
    should be destroyed after deactivation is handled.

    Text is generally UTF-8 encoded, indices and lengths are in bytes.

    Serials are used to synchronize the state between the text input and an
    input method. New serials are sent by the text input in the commit_state
    request and are used by the input method to indicate the known text input
    state in events like preedit_string, commit_string, and keysym. The text
    input can then ignore events from the input method which are based on an
    outdated state (for example after a reset).

    Warning! The protocol described in this file is experimental and backward
    incompatible changes may be made. Backward compatible changes may be added
    together with the corresponding interface version bump. Backward
    incompatible changes are done by bumping the version number in the protocol
    and interface names and resetting the interface version. Once the protocol
    is to be declared stable, the 'z' prefix and the version number in the
    protocol and interface names are removed and the interface version number
    is reset.
    """

    name = "zwp_input_method_context_v1"
    version = 1


class ZwpInputMethodContextV1Proxy(Proxy):
    interface = ZwpInputMethodContextV1

    @ZwpInputMethodContextV1.request()
    def destroy(self):
        """destroy
        """
        self._marshal(0)
        self._destroy()

    @ZwpInputMethodContextV1.request(
        Argument(ArgumentType.Uint),
        Argument(ArgumentType.String),
    )
    def commit_string(self, serial, text):
        """Commit string

        Send the commit string text for insertion to the application.

        The text to commit could be either just a single character after a key
        press or the result of some composing (pre-edit). It could be also an
        empty text when some text should be removed (see
        delete_surrounding_text) or when the input cursor should be moved (see
        cursor_position).

        Any previously set composing text will be removed.

        :param serial:
            serial of the latest known text input state
        :type serial:
            `ArgumentType.Uint`
        :param text:
        :type text:
            `ArgumentType.String`
        """
        self._marshal(1, serial, text)

    @ZwpInputMethodContextV1.request(
        Argument(ArgumentType.Uint),
        Argument(ArgumentType.String),
        Argument(ArgumentType.String),
    )
    def preedit_string(self, serial, text, commit):
        """Pre-edit string

        Send the pre-edit string text to the application text input.

        The commit text can be used to replace the pre-edit text on reset (for
        example on unfocus).

        Previously sent preedit_style and preedit_cursor requests are also
        processed by the text_input.

        :param serial:
            serial of the latest known text input state
        :type serial:
            `ArgumentType.Uint`
        :param text:
        :type text:
            `ArgumentType.String`
        :param commit:
        :type commit:
            `ArgumentType.String`
        """
        self._marshal(2, serial, text, commit)

    @ZwpInputMethodContextV1.request(
        Argument(ArgumentType.Uint),
        Argument(ArgumentType.Uint),
        Argument(ArgumentType.Uint),
    )
    def preedit_styling(self, index, length, style):
        """Pre-edit styling

        Set the styling information on composing text. The style is applied for
        length in bytes from index relative to the beginning of the composing
        text (as byte offset). Multiple styles can be applied to a composing
        text.

        This request should be sent before sending a preedit_string request.

        :param index:
        :type index:
            `ArgumentType.Uint`
        :param length:
        :type length:
            `ArgumentType.Uint`
        :param style:
        :type style:
            `ArgumentType.Uint`
        """
        self._marshal(3, index, length, style)

    @ZwpInputMethodContextV1.request(
        Argument(ArgumentType.Int),
    )
    def preedit_cursor(self, index):
        """Pre-edit cursor

        Set the cursor position inside the composing text (as byte offset)
        relative to the start of the composing text.

        When index is negative no cursor should be displayed.

        This request should be sent before sending a preedit_string request.

        :param index:
        :type index:
            `ArgumentType.Int`
        """
        self._marshal(4, index)

    @ZwpInputMethodContextV1.request(
        Argument(ArgumentType.Int),
        Argument(ArgumentType.Uint),
    )
    def delete_surrounding_text(self, index, length):
        """Delete text

        Remove the surrounding text.

        This request will be handled on the text_input side directly following
        a commit_string request.

        :param index:
        :type index:
            `ArgumentType.Int`
        :param length:
        :type length:
            `ArgumentType.Uint`
        """
        self._marshal(5, index, length)

    @ZwpInputMethodContextV1.request(
        Argument(ArgumentType.Int),
        Argument(ArgumentType.Int),
    )
    def cursor_position(self, index, anchor):
        """Set cursor to a new position

        Set the cursor and anchor to a new position. Index is the new cursor
        position in bytes (when >= 0 this is relative to the end of the
        inserted text, otherwise it is relative to the beginning of the
        inserted text). Anchor is the new anchor position in bytes (when >= 0
        this is relative to the end of the inserted text, otherwise it is
        relative to the beginning of the inserted text). When there should be
        no selected text, anchor should be the same as index.

        This request will be handled on the text_input side directly following
        a commit_string request.

        :param index:
        :type index:
            `ArgumentType.Int`
        :param anchor:
        :type anchor:
            `ArgumentType.Int`
        """
        self._marshal(6, index, anchor)

    @ZwpInputMethodContextV1.request(
        Argument(ArgumentType.Array),
    )
    def modifiers_map(self, map):
        """modifiers_map

        :param map:
        :type map:
            `ArgumentType.Array`
        """
        self._marshal(7, map)

    @ZwpInputMethodContextV1.request(
        Argument(ArgumentType.Uint),
        Argument(ArgumentType.Uint),
        Argument(ArgumentType.Uint),
        Argument(ArgumentType.Uint),
        Argument(ArgumentType.Uint),
    )
    def keysym(self, serial, time, sym, state, modifiers):
        """Keysym

        Notify when a key event was sent. Key events should not be used for
        normal text input operations, which should be done with commit_string,
        delete_surrounding_text, etc. The key event follows the
        :class:`~pywayland.protocol.wayland.WlKeyboard` key event convention.
        Sym is an XKB keysym, state is a
        :class:`~pywayland.protocol.wayland.WlKeyboard` key_state.

        :param serial:
            serial of the latest known text input state
        :type serial:
            `ArgumentType.Uint`
        :param time:
        :type time:
            `ArgumentType.Uint`
        :param sym:
        :type sym:
            `ArgumentType.Uint`
        :param state:
        :type state:
            `ArgumentType.Uint`
        :param modifiers:
        :type modifiers:
            `ArgumentType.Uint`
        """
        self._marshal(8, serial, time, sym, state, modifiers)

    @ZwpInputMethodContextV1.request(
        Argument(ArgumentType.NewId, interface=WlKeyboard),
    )
    def grab_keyboard(self):
        """Grab hardware keyboard

        Allow an input method to receive hardware keyboard input and process
        key events to generate text events (with pre-edit) over the wire. This
        allows input methods which compose multiple key events for inputting
        text like it is done for CJK languages.

        :returns:
            :class:`~pywayland.protocol.wayland.WlKeyboard`
        """
        keyboard = self._marshal_constructor(9, WlKeyboard)
        return keyboard

    @ZwpInputMethodContextV1.request(
        Argument(ArgumentType.Uint),
        Argument(ArgumentType.Uint),
        Argument(ArgumentType.Uint),
        Argument(ArgumentType.Uint),
    )
    def key(self, serial, time, key, state):
        """Forward key event

        Forward a :class:`~pywayland.protocol.wayland.WlKeyboard`::key event to
        the client that was not processed by the input method itself. Should be
        used when filtering key events with grab_keyboard.  The arguments
        should be the ones from the
        :class:`~pywayland.protocol.wayland.WlKeyboard`::key event.

        For generating custom key events use the keysym request instead.

        :param serial:
            serial from :class:`~pywayland.protocol.wayland.WlKeyboard`::key
        :type serial:
            `ArgumentType.Uint`
        :param time:
            time from :class:`~pywayland.protocol.wayland.WlKeyboard`::key
        :type time:
            `ArgumentType.Uint`
        :param key:
            key from :class:`~pywayland.protocol.wayland.WlKeyboard`::key
        :type key:
            `ArgumentType.Uint`
        :param state:
            state from :class:`~pywayland.protocol.wayland.WlKeyboard`::key
        :type state:
            `ArgumentType.Uint`
        """
        self._marshal(10, serial, time, key, state)

    @ZwpInputMethodContextV1.request(
        Argument(ArgumentType.Uint),
        Argument(ArgumentType.Uint),
        Argument(ArgumentType.Uint),
        Argument(ArgumentType.Uint),
        Argument(ArgumentType.Uint),
    )
    def modifiers(self, serial, mods_depressed, mods_latched, mods_locked, group):
        """Forward modifiers event

        Forward a :class:`~pywayland.protocol.wayland.WlKeyboard`::modifiers
        event to the client that was not processed by the input method itself.
        Should be used when filtering key events with grab_keyboard. The
        arguments should be the ones from the
        :class:`~pywayland.protocol.wayland.WlKeyboard`::modifiers event.

        :param serial:
            serial from
            :class:`~pywayland.protocol.wayland.WlKeyboard`::modifiers
        :type serial:
            `ArgumentType.Uint`
        :param mods_depressed:
            mods_depressed from
            :class:`~pywayland.protocol.wayland.WlKeyboard`::modifiers
        :type mods_depressed:
            `ArgumentType.Uint`
        :param mods_latched:
            mods_latched from
            :class:`~pywayland.protocol.wayland.WlKeyboard`::modifiers
        :type mods_latched:
            `ArgumentType.Uint`
        :param mods_locked:
            mods_locked from
            :class:`~pywayland.protocol.wayland.WlKeyboard`::modifiers
        :type mods_locked:
            `ArgumentType.Uint`
        :param group:
            group from
            :class:`~pywayland.protocol.wayland.WlKeyboard`::modifiers
        :type group:
            `ArgumentType.Uint`
        """
        self._marshal(11, serial, mods_depressed, mods_latched, mods_locked, group)

    @ZwpInputMethodContextV1.request(
        Argument(ArgumentType.Uint),
        Argument(ArgumentType.String),
    )
    def language(self, serial, language):
        """language

        :param serial:
            serial of the latest known text input state
        :type serial:
            `ArgumentType.Uint`
        :param language:
        :type language:
            `ArgumentType.String`
        """
        self._marshal(12, serial, language)

    @ZwpInputMethodContextV1.request(
        Argument(ArgumentType.Uint),
        Argument(ArgumentType.Uint),
    )
    def text_direction(self, serial, direction):
        """text_direction

        :param serial:
            serial of the latest known text input state
        :type serial:
            `ArgumentType.Uint`
        :param direction:
        :type direction:
            `ArgumentType.Uint`
        """
        self._marshal(13, serial, direction)


class ZwpInputMethodContextV1Resource(Resource):
    interface = ZwpInputMethodContextV1

    @ZwpInputMethodContextV1.event(
        Argument(ArgumentType.String),
        Argument(ArgumentType.Uint),
        Argument(ArgumentType.Uint),
    )
    def surrounding_text(self, text, cursor, anchor):
        """Surrounding text event

        The plain surrounding text around the input position. Cursor is the
        position in bytes within the surrounding text relative to the beginning
        of the text. Anchor is the position in bytes of the selection anchor
        within the surrounding text relative to the beginning of the text. If
        there is no selected text then anchor is the same as cursor.

        :param text:
        :type text:
            `ArgumentType.String`
        :param cursor:
        :type cursor:
            `ArgumentType.Uint`
        :param anchor:
        :type anchor:
            `ArgumentType.Uint`
        """
        self._post_event(0, text, cursor, anchor)

    @ZwpInputMethodContextV1.event()
    def reset(self):
        """reset
        """
        self._post_event(1)

    @ZwpInputMethodContextV1.event(
        Argument(ArgumentType.Uint),
        Argument(ArgumentType.Uint),
    )
    def content_type(self, hint, purpose):
        """content_type

        :param hint:
        :type hint:
            `ArgumentType.Uint`
        :param purpose:
        :type purpose:
            `ArgumentType.Uint`
        """
        self._post_event(2, hint, purpose)

    @ZwpInputMethodContextV1.event(
        Argument(ArgumentType.Uint),
        Argument(ArgumentType.Uint),
    )
    def invoke_action(self, button, index):
        """invoke_action

        :param button:
        :type button:
            `ArgumentType.Uint`
        :param index:
        :type index:
            `ArgumentType.Uint`
        """
        self._post_event(3, button, index)

    @ZwpInputMethodContextV1.event(
        Argument(ArgumentType.Uint),
    )
    def commit_state(self, serial):
        """commit_state

        :param serial:
            serial of text input state
        :type serial:
            `ArgumentType.Uint`
        """
        self._post_event(4, serial)

    @ZwpInputMethodContextV1.event(
        Argument(ArgumentType.String),
    )
    def preferred_language(self, language):
        """preferred_language

        :param language:
        :type language:
            `ArgumentType.String`
        """
        self._post_event(5, language)


class ZwpInputMethodContextV1Global(Global):
    interface = ZwpInputMethodContextV1


ZwpInputMethodContextV1._gen_c()
ZwpInputMethodContextV1.proxy_class = ZwpInputMethodContextV1Proxy
ZwpInputMethodContextV1.resource_class = ZwpInputMethodContextV1Resource
ZwpInputMethodContextV1.global_class = ZwpInputMethodContextV1Global
