/*
 * Decompiled with CFR 0.152.
 */
package sun.text.normalizer;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import sun.text.normalizer.CharTrie;
import sun.text.normalizer.ICUBinary;
import sun.text.normalizer.ICUData;

public final class UBiDiProps {
    private static UBiDiProps gBdp = null;
    private static UBiDiProps gBdpDummy = null;
    private int[] indexes;
    private int[] mirrors;
    private byte[] jgArray;
    private CharTrie trie;
    private static final String DATA_FILE_NAME = "/sun/text/resources/ubidi.icu";
    private static final byte[] FMT = new byte[]{66, 105, 68, 105};
    private static final int IX_INDEX_TOP = 0;
    private static final int IX_MIRROR_LENGTH = 3;
    private static final int IX_JG_START = 4;
    private static final int IX_JG_LIMIT = 5;
    private static final int IX_TOP = 16;
    private static final int CLASS_MASK = 31;

    public UBiDiProps() throws IOException {
        InputStream is = ICUData.getStream(DATA_FILE_NAME);
        BufferedInputStream b = new BufferedInputStream(is, 4096);
        this.readData(b);
        b.close();
        is.close();
    }

    private void readData(InputStream is) throws IOException {
        int i;
        DataInputStream inputStream = new DataInputStream(is);
        ICUBinary.readHeader(inputStream, FMT, new IsAcceptable());
        int count = inputStream.readInt();
        if (count < 0) {
            throw new IOException("indexes[0] too small in /sun/text/resources/ubidi.icu");
        }
        this.indexes = new int[count];
        this.indexes[0] = count;
        for (i = 1; i < count; ++i) {
            this.indexes[i] = inputStream.readInt();
        }
        this.trie = new CharTrie(inputStream, null);
        count = this.indexes[3];
        if (count > 0) {
            this.mirrors = new int[count];
            for (i = 0; i < count; ++i) {
                this.mirrors[i] = inputStream.readInt();
            }
        }
        count = this.indexes[5] - this.indexes[4];
        this.jgArray = new byte[count];
        for (i = 0; i < count; ++i) {
            this.jgArray[i] = inputStream.readByte();
        }
    }

    public static final synchronized UBiDiProps getSingleton() throws IOException {
        if (gBdp == null) {
            gBdp = new UBiDiProps();
        }
        return gBdp;
    }

    private UBiDiProps(boolean makeDummy) {
        this.indexes = new int[16];
        this.indexes[0] = 16;
        this.trie = new CharTrie(0, 0, null);
    }

    public static final synchronized UBiDiProps getDummy() {
        if (gBdpDummy == null) {
            gBdpDummy = new UBiDiProps(true);
        }
        return gBdpDummy;
    }

    public final int getClass(int c) {
        return UBiDiProps.getClassFromProps(this.trie.getCodePointValue(c));
    }

    private static final int getClassFromProps(int props) {
        return props & 0x1F;
    }

    private final class IsAcceptable
    implements ICUBinary.Authenticate {
        private IsAcceptable() {
        }

        @Override
        public boolean isDataVersionAcceptable(byte[] version) {
            return version[0] == 1 && version[2] == 5 && version[3] == 2;
        }
    }
}

