/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper.compiler;

import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.el.ELContext;
import javax.el.ELException;
import javax.el.ExpressionFactory;
import javax.servlet.jsp.tagext.BodyTag;
import javax.servlet.jsp.tagext.DynamicAttributes;
import javax.servlet.jsp.tagext.IterationTag;
import javax.servlet.jsp.tagext.JspIdConsumer;
import javax.servlet.jsp.tagext.SimpleTag;
import javax.servlet.jsp.tagext.TagAttributeInfo;
import javax.servlet.jsp.tagext.TagData;
import javax.servlet.jsp.tagext.TagFileInfo;
import javax.servlet.jsp.tagext.TagInfo;
import javax.servlet.jsp.tagext.TagVariableInfo;
import javax.servlet.jsp.tagext.TryCatchFinally;
import javax.servlet.jsp.tagext.VariableInfo;
import org.apache.jasper.Constants;
import org.apache.jasper.JasperException;
import org.apache.jasper.compiler.ELNode;
import org.apache.jasper.compiler.Localizer;
import org.apache.jasper.compiler.Mark;
import org.apache.jasper.compiler.TagConstants;
import org.apache.jasper.compiler.tagplugin.TagPluginContext;
import org.xml.sax.Attributes;

abstract class Node
implements TagConstants {
    private static final VariableInfo[] ZERO_VARIABLE_INFO = new VariableInfo[0];
    protected Attributes attrs;
    protected Attributes taglibAttrs;
    protected Attributes nonTaglibXmlnsAttrs;
    protected Nodes body;
    protected String text;
    protected Mark startMark;
    protected int beginJavaLine;
    protected int endJavaLine;
    protected Node parent;
    protected Nodes namedAttributeNodes;
    protected String qName;
    protected String localName;
    protected String innerClassName;
    private boolean isDummy;

    public Node() {
        this.isDummy = true;
    }

    public Node(Mark mark, Node node) {
        this.startMark = mark;
        this.isDummy = mark == null;
        this.addToParent(node);
    }

    public Node(String string, String string2, Attributes attributes, Mark mark, Node node) {
        this.qName = string;
        this.localName = string2;
        this.attrs = attributes;
        this.startMark = mark;
        this.isDummy = mark == null;
        this.addToParent(node);
    }

    public Node(String string, String string2, Attributes attributes, Attributes attributes2, Attributes attributes3, Mark mark, Node node) {
        this.qName = string;
        this.localName = string2;
        this.attrs = attributes;
        this.nonTaglibXmlnsAttrs = attributes2;
        this.taglibAttrs = attributes3;
        this.startMark = mark;
        this.isDummy = mark == null;
        this.addToParent(node);
    }

    public Node(String string, String string2, String string3, Mark mark, Node node) {
        this.qName = string;
        this.localName = string2;
        this.text = string3;
        this.startMark = mark;
        this.isDummy = mark == null;
        this.addToParent(node);
    }

    public String getQName() {
        return this.qName;
    }

    public String getLocalName() {
        return this.localName;
    }

    public Attributes getAttributes() {
        return this.attrs;
    }

    public Attributes getTaglibAttributes() {
        return this.taglibAttrs;
    }

    public Attributes getNonTaglibXmlnsAttributes() {
        return this.nonTaglibXmlnsAttrs;
    }

    public void setAttributes(Attributes attributes) {
        this.attrs = attributes;
    }

    public String getAttributeValue(String string) {
        return this.attrs == null ? null : this.attrs.getValue(string);
    }

    public String getTextAttribute(String string) {
        String string2 = this.getAttributeValue(string);
        if (string2 != null) {
            return string2;
        }
        NamedAttribute namedAttribute = this.getNamedAttributeNode(string);
        if (namedAttribute == null) {
            return null;
        }
        return namedAttribute.getText();
    }

    public NamedAttribute getNamedAttributeNode(String string) {
        NamedAttribute namedAttribute = null;
        Nodes nodes = this.getNamedAttributeNodes();
        int n = nodes.size();
        for (int i = 0; i < n; ++i) {
            NamedAttribute namedAttribute2 = (NamedAttribute)nodes.getNode(i);
            boolean bl = false;
            int n2 = string.indexOf(58);
            bl = n2 != -1 ? namedAttribute2.getName().equals(string) : namedAttribute2.getLocalName().equals(string);
            if (!bl) continue;
            namedAttribute = namedAttribute2;
            break;
        }
        return namedAttribute;
    }

    public Nodes getNamedAttributeNodes() {
        if (this.namedAttributeNodes != null) {
            return this.namedAttributeNodes;
        }
        Nodes nodes = new Nodes();
        Nodes nodes2 = this.getBody();
        if (nodes2 != null) {
            int n = nodes2.size();
            for (int i = 0; i < n; ++i) {
                Node node = nodes2.getNode(i);
                if (node instanceof NamedAttribute) {
                    nodes.add(node);
                    continue;
                }
                if (!(node instanceof Comment)) break;
            }
        }
        this.namedAttributeNodes = nodes;
        return nodes;
    }

    public Nodes getBody() {
        return this.body;
    }

    public void setBody(Nodes nodes) {
        this.body = nodes;
    }

    public String getText() {
        return this.text;
    }

    public Mark getStart() {
        return this.startMark;
    }

    public Node getParent() {
        return this.parent;
    }

    public int getBeginJavaLine() {
        return this.beginJavaLine;
    }

    public void setBeginJavaLine(int n) {
        this.beginJavaLine = n;
    }

    public int getEndJavaLine() {
        return this.endJavaLine;
    }

    public void setEndJavaLine(int n) {
        this.endJavaLine = n;
    }

    public boolean isDummy() {
        return this.isDummy;
    }

    public Root getRoot() {
        Node node = this;
        while (!(node instanceof Root)) {
            node = node.getParent();
        }
        return (Root)node;
    }

    public String getInnerClassName() {
        return this.innerClassName;
    }

    public void setInnerClassName(String string) {
        this.innerClassName = string;
    }

    abstract void accept(Visitor var1) throws JasperException;

    private void addToParent(Node node) {
        if (node != null) {
            this.parent = node;
            Nodes nodes = node.getBody();
            if (nodes == null) {
                nodes = new Nodes();
                node.setBody(nodes);
            }
            nodes.add(this);
        }
    }

    public static class Visitor {
        protected void doVisit(Node node) throws JasperException {
        }

        protected void visitBody(Node node) throws JasperException {
            if (node.getBody() != null) {
                node.getBody().visit(this);
            }
        }

        public void visit(Root root) throws JasperException {
            this.doVisit(root);
            this.visitBody(root);
        }

        public void visit(JspRoot jspRoot) throws JasperException {
            this.doVisit(jspRoot);
            this.visitBody(jspRoot);
        }

        public void visit(PageDirective pageDirective) throws JasperException {
            this.doVisit(pageDirective);
        }

        public void visit(TagDirective tagDirective) throws JasperException {
            this.doVisit(tagDirective);
        }

        public void visit(IncludeDirective includeDirective) throws JasperException {
            this.doVisit(includeDirective);
            this.visitBody(includeDirective);
        }

        public void visit(TaglibDirective taglibDirective) throws JasperException {
            this.doVisit(taglibDirective);
        }

        public void visit(AttributeDirective attributeDirective) throws JasperException {
            this.doVisit(attributeDirective);
        }

        public void visit(VariableDirective variableDirective) throws JasperException {
            this.doVisit(variableDirective);
        }

        public void visit(Comment comment) throws JasperException {
            this.doVisit(comment);
        }

        public void visit(Declaration declaration) throws JasperException {
            this.doVisit(declaration);
        }

        public void visit(Expression expression) throws JasperException {
            this.doVisit(expression);
        }

        public void visit(Scriptlet scriptlet) throws JasperException {
            this.doVisit(scriptlet);
        }

        public void visit(ELExpression eLExpression) throws JasperException {
            this.doVisit(eLExpression);
        }

        public void visit(IncludeAction includeAction) throws JasperException {
            this.doVisit(includeAction);
            this.visitBody(includeAction);
        }

        public void visit(ForwardAction forwardAction) throws JasperException {
            this.doVisit(forwardAction);
            this.visitBody(forwardAction);
        }

        public void visit(GetProperty getProperty) throws JasperException {
            this.doVisit(getProperty);
            this.visitBody(getProperty);
        }

        public void visit(SetProperty setProperty) throws JasperException {
            this.doVisit(setProperty);
            this.visitBody(setProperty);
        }

        public void visit(ParamAction paramAction) throws JasperException {
            this.doVisit(paramAction);
            this.visitBody(paramAction);
        }

        public void visit(ParamsAction paramsAction) throws JasperException {
            this.doVisit(paramsAction);
            this.visitBody(paramsAction);
        }

        public void visit(FallBackAction fallBackAction) throws JasperException {
            this.doVisit(fallBackAction);
            this.visitBody(fallBackAction);
        }

        public void visit(UseBean useBean) throws JasperException {
            this.doVisit(useBean);
            this.visitBody(useBean);
        }

        public void visit(PlugIn plugIn) throws JasperException {
            this.doVisit(plugIn);
            this.visitBody(plugIn);
        }

        public void visit(CustomTag customTag) throws JasperException {
            this.doVisit(customTag);
            this.visitBody(customTag);
        }

        public void visit(UninterpretedTag uninterpretedTag) throws JasperException {
            this.doVisit(uninterpretedTag);
            this.visitBody(uninterpretedTag);
        }

        public void visit(JspElement jspElement) throws JasperException {
            this.doVisit(jspElement);
            this.visitBody(jspElement);
        }

        public void visit(JspText jspText) throws JasperException {
            this.doVisit(jspText);
            this.visitBody(jspText);
        }

        public void visit(NamedAttribute namedAttribute) throws JasperException {
            this.doVisit(namedAttribute);
            this.visitBody(namedAttribute);
        }

        public void visit(JspBody jspBody) throws JasperException {
            this.doVisit(jspBody);
            this.visitBody(jspBody);
        }

        public void visit(InvokeAction invokeAction) throws JasperException {
            this.doVisit(invokeAction);
            this.visitBody(invokeAction);
        }

        public void visit(DoBodyAction doBodyAction) throws JasperException {
            this.doVisit(doBodyAction);
            this.visitBody(doBodyAction);
        }

        public void visit(TemplateText templateText) throws JasperException {
            this.doVisit(templateText);
        }

        public void visit(JspOutput jspOutput) throws JasperException {
            this.doVisit(jspOutput);
        }

        public void visit(AttributeGenerator attributeGenerator) throws JasperException {
            this.doVisit(attributeGenerator);
        }
    }

    public static class Nodes {
        private List<Node> list;
        private Root root;
        private boolean generatedInBuffer;

        public Nodes() {
            this.list = new Vector<Node>();
        }

        public Nodes(Root root) {
            this.root = root;
            this.list = new Vector<Node>();
            this.list.add(root);
        }

        public void add(Node node) {
            this.list.add(node);
            this.root = null;
        }

        public void remove(Node node) {
            this.list.remove(node);
        }

        public void visit(Visitor visitor) throws JasperException {
            for (Node node : this.list) {
                node.accept(visitor);
            }
        }

        public int size() {
            return this.list.size();
        }

        public Node getNode(int n) {
            Node node = null;
            try {
                node = this.list.get(n);
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                // empty catch block
            }
            return node;
        }

        public Root getRoot() {
            return this.root;
        }

        public boolean isGeneratedInBuffer() {
            return this.generatedInBuffer;
        }

        public void setGeneratedInBuffer(boolean bl) {
            this.generatedInBuffer = bl;
        }
    }

    public static class JspAttribute {
        private String qName;
        private String uri;
        private String localName;
        private String value;
        private boolean expression;
        private boolean dynamic;
        private final ELNode.Nodes el;
        private final TagAttributeInfo tai;
        private boolean namedAttribute;
        private NamedAttribute namedAttributeNode;

        JspAttribute(TagAttributeInfo tagAttributeInfo, String string, String string2, String string3, String string4, boolean bl, ELNode.Nodes nodes, boolean bl2) {
            this.qName = string;
            this.uri = string2;
            this.localName = string3;
            this.value = string4;
            this.namedAttributeNode = null;
            this.expression = bl;
            this.el = nodes;
            this.dynamic = bl2;
            this.namedAttribute = false;
            this.tai = tagAttributeInfo;
        }

        public void validateEL(ExpressionFactory expressionFactory, ELContext eLContext) throws ELException {
            if (this.el != null) {
                expressionFactory.createValueExpression(eLContext, this.value, String.class);
            }
        }

        JspAttribute(NamedAttribute namedAttribute, TagAttributeInfo tagAttributeInfo, boolean bl) {
            this.qName = namedAttribute.getName();
            this.localName = namedAttribute.getLocalName();
            this.value = null;
            this.namedAttributeNode = namedAttribute;
            this.expression = false;
            this.el = null;
            this.dynamic = bl;
            this.namedAttribute = true;
            this.tai = null;
        }

        public String getName() {
            return this.qName;
        }

        public String getLocalName() {
            return this.localName;
        }

        public String getURI() {
            return this.uri;
        }

        public TagAttributeInfo getTagAttributeInfo() {
            return this.tai;
        }

        public boolean isDeferredInput() {
            return this.tai != null ? this.tai.isDeferredValue() : false;
        }

        public boolean isDeferredMethodInput() {
            return this.tai != null ? this.tai.isDeferredMethod() : false;
        }

        public String getExpectedTypeName() {
            if (this.tai != null) {
                int n;
                String string;
                if (this.isDeferredInput()) {
                    return this.tai.getExpectedTypeName();
                }
                if (this.isDeferredMethodInput() && (string = this.tai.getMethodSignature()) != null && (n = string.trim().indexOf(32)) > 0) {
                    return string.substring(0, n).trim();
                }
            }
            return "java.lang.Object";
        }

        public String[] getParameterTypeNames() {
            String string;
            if (this.tai != null && this.isDeferredMethodInput() && (string = this.tai.getMethodSignature()) != null) {
                string = string.trim();
                string = string.substring(string.indexOf(40) + 1);
                if ((string = string.substring(0, string.length() - 1)).trim().length() > 0) {
                    String[] stringArray = string.split(",");
                    for (int i = 0; i < stringArray.length; ++i) {
                        stringArray[i] = stringArray[i].trim();
                    }
                    return stringArray;
                }
            }
            return new String[0];
        }

        public String getValue() {
            return this.value;
        }

        public NamedAttribute getNamedAttributeNode() {
            return this.namedAttributeNode;
        }

        public boolean isExpression() {
            return this.expression;
        }

        public boolean isNamedAttribute() {
            return this.namedAttribute;
        }

        public boolean isELInterpreterInput() {
            return this.el != null || this.isDeferredInput() || this.isDeferredMethodInput();
        }

        public boolean isLiteral() {
            return !this.expression && this.el == null && !this.namedAttribute;
        }

        public boolean isDynamic() {
            return this.dynamic;
        }

        public ELNode.Nodes getEL() {
            return this.el;
        }
    }

    public static class TemplateText
    extends Node {
        private ArrayList<Integer> extraSmap = null;

        public TemplateText(String string, Mark mark, Node node) {
            super(null, null, string, mark, node);
        }

        @Override
        public void accept(Visitor visitor) throws JasperException {
            visitor.visit(this);
        }

        public void ltrim() {
            int n;
            for (n = 0; n < this.text.length() && this.text.charAt(n) <= ' '; ++n) {
            }
            this.text = this.text.substring(n);
        }

        public void setText(String string) {
            this.text = string;
        }

        public void rtrim() {
            int n;
            for (n = this.text.length(); n > 0 && this.text.charAt(n - 1) <= ' '; --n) {
            }
            this.text = this.text.substring(0, n);
        }

        public boolean isAllSpace() {
            boolean bl = true;
            for (int i = 0; i < this.text.length(); ++i) {
                if (Character.isWhitespace(this.text.charAt(i))) continue;
                bl = false;
                break;
            }
            return bl;
        }

        public void addSmap(int n) {
            if (this.extraSmap == null) {
                this.extraSmap = new ArrayList();
            }
            this.extraSmap.add(n);
        }

        public ArrayList<Integer> getExtraSmap() {
            return this.extraSmap;
        }
    }

    public static class JspBody
    extends Node {
        private ChildInfo childInfo = new ChildInfo();

        public JspBody(Mark mark, Node node) {
            this("jsp:body", (Attributes)null, (Attributes)null, mark, node);
        }

        public JspBody(String string, Attributes attributes, Attributes attributes2, Mark mark, Node node) {
            super(string, "body", null, attributes, attributes2, mark, node);
        }

        @Override
        public void accept(Visitor visitor) throws JasperException {
            visitor.visit(this);
        }

        public ChildInfo getChildInfo() {
            return this.childInfo;
        }
    }

    public static class NamedAttribute
    extends Node {
        private String temporaryVariableName;
        private boolean trim = true;
        private JspAttribute omit;
        private ChildInfo childInfo;
        private String name;
        private String localName;
        private String prefix;

        public NamedAttribute(Attributes attributes, Mark mark, Node node) {
            this("jsp:attribute", attributes, null, null, mark, node);
        }

        public NamedAttribute(String string, Attributes attributes, Attributes attributes2, Attributes attributes3, Mark mark, Node node) {
            super(string, "attribute", attributes, attributes2, attributes3, mark, node);
            if ("false".equals(this.getAttributeValue("trim"))) {
                this.trim = false;
            }
            this.childInfo = new ChildInfo();
            this.name = this.getAttributeValue("name");
            if (this.name != null) {
                this.localName = this.name;
                int n = this.name.indexOf(58);
                if (n != -1) {
                    this.prefix = this.name.substring(0, n);
                    this.localName = this.name.substring(n + 1);
                }
            }
        }

        @Override
        public void accept(Visitor visitor) throws JasperException {
            visitor.visit(this);
        }

        public String getName() {
            return this.name;
        }

        @Override
        public String getLocalName() {
            return this.localName;
        }

        public String getPrefix() {
            return this.prefix;
        }

        public ChildInfo getChildInfo() {
            return this.childInfo;
        }

        public boolean isTrim() {
            return this.trim;
        }

        public void setOmit(JspAttribute jspAttribute) {
            this.omit = jspAttribute;
        }

        public JspAttribute getOmit() {
            return this.omit;
        }

        public String getTemporaryVariableName() {
            if (this.temporaryVariableName == null) {
                this.temporaryVariableName = this.getRoot().nextTemporaryVariableName();
            }
            return this.temporaryVariableName;
        }

        @Override
        public String getText() {
            String string = "";
            if (this.getBody() != null) {
                class AttributeVisitor
                extends Visitor {
                    String attrValue = null;

                    AttributeVisitor() {
                    }

                    @Override
                    public void visit(TemplateText templateText) {
                        this.attrValue = templateText.getText();
                    }

                    public String getAttrValue() {
                        return this.attrValue;
                    }
                }
                AttributeVisitor attributeVisitor = new AttributeVisitor();
                try {
                    this.getBody().visit(attributeVisitor);
                }
                catch (JasperException jasperException) {
                    // empty catch block
                }
                string = attributeVisitor.getAttrValue();
            }
            return string;
        }
    }

    public static class JspText
    extends Node {
        public JspText(String string, Attributes attributes, Attributes attributes2, Mark mark, Node node) {
            super(string, "text", null, attributes, attributes2, mark, node);
        }

        @Override
        public void accept(Visitor visitor) throws JasperException {
            visitor.visit(this);
        }
    }

    public static class AttributeGenerator
    extends Node {
        String name;
        CustomTag tag;

        public AttributeGenerator(Mark mark, String string, CustomTag customTag) {
            super(mark, null);
            this.name = string;
            this.tag = customTag;
        }

        @Override
        public void accept(Visitor visitor) throws JasperException {
            visitor.visit(this);
        }

        public String getName() {
            return this.name;
        }

        public CustomTag getTag() {
            return this.tag;
        }
    }

    public static class CustomTag
    extends Node {
        private String uri;
        private String prefix;
        private JspAttribute[] jspAttrs;
        private TagData tagData;
        private String tagHandlerPoolName;
        private TagInfo tagInfo;
        private TagFileInfo tagFileInfo;
        private Class<?> tagHandlerClass;
        private VariableInfo[] varInfos;
        private int customNestingLevel;
        private ChildInfo childInfo;
        private boolean implementsIterationTag;
        private boolean implementsBodyTag;
        private boolean implementsTryCatchFinally;
        private boolean implementsJspIdConsumer;
        private boolean implementsSimpleTag;
        private boolean implementsDynamicAttributes;
        private List<Object> atBeginScriptingVars;
        private List<Object> atEndScriptingVars;
        private List<Object> nestedScriptingVars;
        private CustomTag customTagParent;
        private Integer numCount;
        private boolean useTagPlugin;
        private TagPluginContext tagPluginContext;
        private Nodes atSTag;
        private Nodes atETag;

        public CustomTag(String string, String string2, String string3, String string4, Attributes attributes, Mark mark, Node node, TagInfo tagInfo, Class<?> clazz) {
            this(string, string2, string3, string4, attributes, null, null, mark, node, tagInfo, clazz);
        }

        public CustomTag(String string, String string2, String string3, String string4, Attributes attributes, Attributes attributes2, Attributes attributes3, Mark mark, Node node, TagInfo tagInfo, Class<?> clazz) {
            super(string, string3, attributes, attributes2, attributes3, mark, node);
            this.uri = string4;
            this.prefix = string2;
            this.tagInfo = tagInfo;
            this.tagHandlerClass = clazz;
            this.customNestingLevel = this.makeCustomNestingLevel();
            this.childInfo = new ChildInfo();
            this.implementsIterationTag = IterationTag.class.isAssignableFrom(clazz);
            this.implementsBodyTag = BodyTag.class.isAssignableFrom(clazz);
            this.implementsTryCatchFinally = TryCatchFinally.class.isAssignableFrom(clazz);
            this.implementsSimpleTag = SimpleTag.class.isAssignableFrom(clazz);
            this.implementsDynamicAttributes = DynamicAttributes.class.isAssignableFrom(clazz);
            this.implementsJspIdConsumer = JspIdConsumer.class.isAssignableFrom(clazz);
        }

        public CustomTag(String string, String string2, String string3, String string4, Attributes attributes, Mark mark, Node node, TagFileInfo tagFileInfo) {
            this(string, string2, string3, string4, attributes, null, null, mark, node, tagFileInfo);
        }

        public CustomTag(String string, String string2, String string3, String string4, Attributes attributes, Attributes attributes2, Attributes attributes3, Mark mark, Node node, TagFileInfo tagFileInfo) {
            super(string, string3, attributes, attributes2, attributes3, mark, node);
            this.uri = string4;
            this.prefix = string2;
            this.tagFileInfo = tagFileInfo;
            this.tagInfo = tagFileInfo.getTagInfo();
            this.customNestingLevel = this.makeCustomNestingLevel();
            this.childInfo = new ChildInfo();
            this.implementsIterationTag = false;
            this.implementsBodyTag = false;
            this.implementsTryCatchFinally = false;
            this.implementsSimpleTag = true;
            this.implementsJspIdConsumer = false;
            this.implementsDynamicAttributes = this.tagInfo.hasDynamicAttributes();
        }

        @Override
        public void accept(Visitor visitor) throws JasperException {
            visitor.visit(this);
        }

        public String getURI() {
            return this.uri;
        }

        public String getPrefix() {
            return this.prefix;
        }

        public void setJspAttributes(JspAttribute[] jspAttributeArray) {
            this.jspAttrs = jspAttributeArray;
        }

        public JspAttribute[] getJspAttributes() {
            return this.jspAttrs;
        }

        public ChildInfo getChildInfo() {
            return this.childInfo;
        }

        public void setTagData(TagData tagData) {
            this.tagData = tagData;
            this.varInfos = this.tagInfo.getVariableInfo(tagData);
            if (this.varInfos == null) {
                this.varInfos = ZERO_VARIABLE_INFO;
            }
        }

        public TagData getTagData() {
            return this.tagData;
        }

        public void setTagHandlerPoolName(String string) {
            this.tagHandlerPoolName = string;
        }

        public String getTagHandlerPoolName() {
            return this.tagHandlerPoolName;
        }

        public TagInfo getTagInfo() {
            return this.tagInfo;
        }

        public TagFileInfo getTagFileInfo() {
            return this.tagFileInfo;
        }

        public boolean isTagFile() {
            return this.tagFileInfo != null;
        }

        public Class<?> getTagHandlerClass() {
            return this.tagHandlerClass;
        }

        public void setTagHandlerClass(Class<?> clazz) {
            this.tagHandlerClass = clazz;
        }

        public boolean implementsIterationTag() {
            return this.implementsIterationTag;
        }

        public boolean implementsBodyTag() {
            return this.implementsBodyTag;
        }

        public boolean implementsTryCatchFinally() {
            return this.implementsTryCatchFinally;
        }

        public boolean implementsJspIdConsumer() {
            return this.implementsJspIdConsumer;
        }

        public boolean implementsSimpleTag() {
            return this.implementsSimpleTag;
        }

        public boolean implementsDynamicAttributes() {
            return this.implementsDynamicAttributes;
        }

        public TagVariableInfo[] getTagVariableInfos() {
            return this.tagInfo.getTagVariableInfos();
        }

        public VariableInfo[] getVariableInfos() {
            return this.varInfos;
        }

        public void setCustomTagParent(CustomTag customTag) {
            this.customTagParent = customTag;
        }

        public CustomTag getCustomTagParent() {
            return this.customTagParent;
        }

        public void setNumCount(Integer n) {
            this.numCount = n;
        }

        public Integer getNumCount() {
            return this.numCount;
        }

        public void setScriptingVars(List<Object> list, int n) {
            switch (n) {
                case 1: {
                    this.atBeginScriptingVars = list;
                    break;
                }
                case 2: {
                    this.atEndScriptingVars = list;
                    break;
                }
                case 0: {
                    this.nestedScriptingVars = list;
                }
            }
        }

        public List<Object> getScriptingVars(int n) {
            List<Object> list = null;
            switch (n) {
                case 1: {
                    list = this.atBeginScriptingVars;
                    break;
                }
                case 2: {
                    list = this.atEndScriptingVars;
                    break;
                }
                case 0: {
                    list = this.nestedScriptingVars;
                }
            }
            return list;
        }

        public int getCustomNestingLevel() {
            return this.customNestingLevel;
        }

        public boolean checkIfAttributeIsJspFragment(String string) {
            TagAttributeInfo[] tagAttributeInfoArray;
            boolean bl = false;
            for (TagAttributeInfo tagAttributeInfo : tagAttributeInfoArray = this.tagInfo.getAttributes()) {
                if (!tagAttributeInfo.getName().equals(string) || !tagAttributeInfo.isFragment()) continue;
                bl = true;
                break;
            }
            return bl;
        }

        public void setUseTagPlugin(boolean bl) {
            this.useTagPlugin = bl;
        }

        public boolean useTagPlugin() {
            return this.useTagPlugin;
        }

        public void setTagPluginContext(TagPluginContext tagPluginContext) {
            this.tagPluginContext = tagPluginContext;
        }

        public TagPluginContext getTagPluginContext() {
            return this.tagPluginContext;
        }

        public void setAtSTag(Nodes nodes) {
            this.atSTag = nodes;
        }

        public Nodes getAtSTag() {
            return this.atSTag;
        }

        public void setAtETag(Nodes nodes) {
            this.atETag = nodes;
        }

        public Nodes getAtETag() {
            return this.atETag;
        }

        private int makeCustomNestingLevel() {
            int n = 0;
            Node node = this.parent;
            while (node != null) {
                if (node instanceof CustomTag && this.qName.equals(((CustomTag)node).qName)) {
                    ++n;
                }
                node = node.parent;
            }
            return n;
        }

        public boolean hasEmptyBody() {
            boolean bl = true;
            Nodes nodes = this.getBody();
            if (nodes != null) {
                int n = nodes.size();
                for (int i = 0; i < n; ++i) {
                    Node node = nodes.getNode(i);
                    if (node instanceof NamedAttribute) continue;
                    if (node instanceof JspBody) {
                        bl = node.getBody() == null;
                        break;
                    }
                    bl = false;
                    break;
                }
            }
            return bl;
        }
    }

    public static class ChildInfo {
        private boolean scriptless;
        private boolean hasUseBean;
        private boolean hasIncludeAction;
        private boolean hasParamAction;
        private boolean hasSetProperty;
        private boolean hasScriptingVars;

        public void setScriptless(boolean bl) {
            this.scriptless = bl;
        }

        public boolean isScriptless() {
            return this.scriptless;
        }

        public void setHasUseBean(boolean bl) {
            this.hasUseBean = bl;
        }

        public boolean hasUseBean() {
            return this.hasUseBean;
        }

        public void setHasIncludeAction(boolean bl) {
            this.hasIncludeAction = bl;
        }

        public boolean hasIncludeAction() {
            return this.hasIncludeAction;
        }

        public void setHasParamAction(boolean bl) {
            this.hasParamAction = bl;
        }

        public boolean hasParamAction() {
            return this.hasParamAction;
        }

        public void setHasSetProperty(boolean bl) {
            this.hasSetProperty = bl;
        }

        public boolean hasSetProperty() {
            return this.hasSetProperty;
        }

        public void setHasScriptingVars(boolean bl) {
            this.hasScriptingVars = bl;
        }

        public boolean hasScriptingVars() {
            return this.hasScriptingVars;
        }
    }

    public static class JspOutput
    extends Node {
        public JspOutput(String string, Attributes attributes, Attributes attributes2, Attributes attributes3, Mark mark, Node node) {
            super(string, "output", attributes, attributes2, attributes3, mark, node);
        }

        @Override
        public void accept(Visitor visitor) throws JasperException {
            visitor.visit(this);
        }
    }

    public static class JspElement
    extends Node {
        private JspAttribute[] jspAttrs;
        private JspAttribute nameAttr;

        public JspElement(Attributes attributes, Mark mark, Node node) {
            this("jsp:element", attributes, null, null, mark, node);
        }

        public JspElement(String string, Attributes attributes, Attributes attributes2, Attributes attributes3, Mark mark, Node node) {
            super(string, "element", attributes, attributes2, attributes3, mark, node);
        }

        @Override
        public void accept(Visitor visitor) throws JasperException {
            visitor.visit(this);
        }

        public void setJspAttributes(JspAttribute[] jspAttributeArray) {
            this.jspAttrs = jspAttributeArray;
        }

        public JspAttribute[] getJspAttributes() {
            return this.jspAttrs;
        }

        public void setNameAttribute(JspAttribute jspAttribute) {
            this.nameAttr = jspAttribute;
        }

        public JspAttribute getNameAttribute() {
            return this.nameAttr;
        }
    }

    public static class UninterpretedTag
    extends Node {
        private JspAttribute[] jspAttrs;

        public UninterpretedTag(String string, String string2, Attributes attributes, Attributes attributes2, Attributes attributes3, Mark mark, Node node) {
            super(string, string2, attributes, attributes2, attributes3, mark, node);
        }

        @Override
        public void accept(Visitor visitor) throws JasperException {
            visitor.visit(this);
        }

        public void setJspAttributes(JspAttribute[] jspAttributeArray) {
            this.jspAttrs = jspAttributeArray;
        }

        public JspAttribute[] getJspAttributes() {
            return this.jspAttrs;
        }
    }

    public static class PlugIn
    extends Node {
        private JspAttribute width;
        private JspAttribute height;

        public PlugIn(Attributes attributes, Mark mark, Node node) {
            this("jsp:plugin", attributes, null, null, mark, node);
        }

        public PlugIn(String string, Attributes attributes, Attributes attributes2, Attributes attributes3, Mark mark, Node node) {
            super(string, "plugin", attributes, attributes2, attributes3, mark, node);
        }

        @Override
        public void accept(Visitor visitor) throws JasperException {
            visitor.visit(this);
        }

        public void setHeight(JspAttribute jspAttribute) {
            this.height = jspAttribute;
        }

        public void setWidth(JspAttribute jspAttribute) {
            this.width = jspAttribute;
        }

        public JspAttribute getHeight() {
            return this.height;
        }

        public JspAttribute getWidth() {
            return this.width;
        }
    }

    public static class UseBean
    extends Node {
        JspAttribute beanName;

        public UseBean(Attributes attributes, Mark mark, Node node) {
            this("jsp:useBean", attributes, null, null, mark, node);
        }

        public UseBean(String string, Attributes attributes, Attributes attributes2, Attributes attributes3, Mark mark, Node node) {
            super(string, "useBean", attributes, attributes2, attributes3, mark, node);
        }

        @Override
        public void accept(Visitor visitor) throws JasperException {
            visitor.visit(this);
        }

        public void setBeanName(JspAttribute jspAttribute) {
            this.beanName = jspAttribute;
        }

        public JspAttribute getBeanName() {
            return this.beanName;
        }
    }

    public static class SetProperty
    extends Node {
        private JspAttribute value;

        public SetProperty(Attributes attributes, Mark mark, Node node) {
            this("jsp:setProperty", attributes, null, null, mark, node);
        }

        public SetProperty(String string, Attributes attributes, Attributes attributes2, Attributes attributes3, Mark mark, Node node) {
            super(string, "setProperty", attributes, attributes2, attributes3, mark, node);
        }

        @Override
        public void accept(Visitor visitor) throws JasperException {
            visitor.visit(this);
        }

        public void setValue(JspAttribute jspAttribute) {
            this.value = jspAttribute;
        }

        public JspAttribute getValue() {
            return this.value;
        }
    }

    public static class GetProperty
    extends Node {
        public GetProperty(Attributes attributes, Mark mark, Node node) {
            this("jsp:getProperty", attributes, null, null, mark, node);
        }

        public GetProperty(String string, Attributes attributes, Attributes attributes2, Attributes attributes3, Mark mark, Node node) {
            super(string, "getProperty", attributes, attributes2, attributes3, mark, node);
        }

        @Override
        public void accept(Visitor visitor) throws JasperException {
            visitor.visit(this);
        }
    }

    public static class ForwardAction
    extends Node {
        private JspAttribute page;

        public ForwardAction(Attributes attributes, Mark mark, Node node) {
            this("jsp:forward", attributes, null, null, mark, node);
        }

        public ForwardAction(String string, Attributes attributes, Attributes attributes2, Attributes attributes3, Mark mark, Node node) {
            super(string, "forward", attributes, attributes2, attributes3, mark, node);
        }

        @Override
        public void accept(Visitor visitor) throws JasperException {
            visitor.visit(this);
        }

        public void setPage(JspAttribute jspAttribute) {
            this.page = jspAttribute;
        }

        public JspAttribute getPage() {
            return this.page;
        }
    }

    public static class IncludeAction
    extends Node {
        private JspAttribute page;

        public IncludeAction(Attributes attributes, Mark mark, Node node) {
            this("jsp:include", attributes, null, null, mark, node);
        }

        public IncludeAction(String string, Attributes attributes, Attributes attributes2, Attributes attributes3, Mark mark, Node node) {
            super(string, "include", attributes, attributes2, attributes3, mark, node);
        }

        @Override
        public void accept(Visitor visitor) throws JasperException {
            visitor.visit(this);
        }

        public void setPage(JspAttribute jspAttribute) {
            this.page = jspAttribute;
        }

        public JspAttribute getPage() {
            return this.page;
        }
    }

    public static class FallBackAction
    extends Node {
        public FallBackAction(Mark mark, Node node) {
            this("jsp:fallback", (Attributes)null, (Attributes)null, mark, node);
        }

        public FallBackAction(String string, Attributes attributes, Attributes attributes2, Mark mark, Node node) {
            super(string, "fallback", null, attributes, attributes2, mark, node);
        }

        @Override
        public void accept(Visitor visitor) throws JasperException {
            visitor.visit(this);
        }
    }

    public static class ParamsAction
    extends Node {
        public ParamsAction(Mark mark, Node node) {
            this("jsp:params", (Attributes)null, (Attributes)null, mark, node);
        }

        public ParamsAction(String string, Attributes attributes, Attributes attributes2, Mark mark, Node node) {
            super(string, "params", null, attributes, attributes2, mark, node);
        }

        @Override
        public void accept(Visitor visitor) throws JasperException {
            visitor.visit(this);
        }
    }

    public static class ParamAction
    extends Node {
        JspAttribute value;

        public ParamAction(Attributes attributes, Mark mark, Node node) {
            this("jsp:param", attributes, null, null, mark, node);
        }

        public ParamAction(String string, Attributes attributes, Attributes attributes2, Attributes attributes3, Mark mark, Node node) {
            super(string, "param", attributes, attributes2, attributes3, mark, node);
        }

        @Override
        public void accept(Visitor visitor) throws JasperException {
            visitor.visit(this);
        }

        public void setValue(JspAttribute jspAttribute) {
            this.value = jspAttribute;
        }

        public JspAttribute getValue() {
            return this.value;
        }
    }

    public static class ELExpression
    extends Node {
        private ELNode.Nodes el;
        private final char type;

        public ELExpression(char c, String string, Mark mark, Node node) {
            super(null, null, string, mark, node);
            this.type = c;
        }

        @Override
        public void accept(Visitor visitor) throws JasperException {
            visitor.visit(this);
        }

        public void setEL(ELNode.Nodes nodes) {
            this.el = nodes;
        }

        public ELNode.Nodes getEL() {
            return this.el;
        }

        public char getType() {
            return this.type;
        }
    }

    public static class Scriptlet
    extends ScriptingElement {
        public Scriptlet(String string, Mark mark, Node node) {
            super("jsp:scriptlet", "scriptlet", string, mark, node);
        }

        public Scriptlet(String string, Attributes attributes, Attributes attributes2, Mark mark, Node node) {
            super(string, "scriptlet", attributes, attributes2, mark, node);
        }

        @Override
        public void accept(Visitor visitor) throws JasperException {
            visitor.visit(this);
        }
    }

    public static class Expression
    extends ScriptingElement {
        public Expression(String string, Mark mark, Node node) {
            super("jsp:expression", "expression", string, mark, node);
        }

        public Expression(String string, Attributes attributes, Attributes attributes2, Mark mark, Node node) {
            super(string, "expression", attributes, attributes2, mark, node);
        }

        @Override
        public void accept(Visitor visitor) throws JasperException {
            visitor.visit(this);
        }
    }

    public static class Declaration
    extends ScriptingElement {
        public Declaration(String string, Mark mark, Node node) {
            super("jsp:declaration", "declaration", string, mark, node);
        }

        public Declaration(String string, Attributes attributes, Attributes attributes2, Mark mark, Node node) {
            super(string, "declaration", attributes, attributes2, mark, node);
        }

        @Override
        public void accept(Visitor visitor) throws JasperException {
            visitor.visit(this);
        }
    }

    public static abstract class ScriptingElement
    extends Node {
        public ScriptingElement(String string, String string2, String string3, Mark mark, Node node) {
            super(string, string2, string3, mark, node);
        }

        public ScriptingElement(String string, String string2, Attributes attributes, Attributes attributes2, Mark mark, Node node) {
            super(string, string2, null, attributes, attributes2, mark, node);
        }

        @Override
        public String getText() {
            String string = this.text;
            if (string == null) {
                if (this.body != null) {
                    StringBuilder stringBuilder = new StringBuilder();
                    for (int i = 0; i < this.body.size(); ++i) {
                        stringBuilder.append(this.body.getNode(i).getText());
                    }
                    string = stringBuilder.toString();
                } else {
                    string = "";
                }
            }
            return string;
        }

        @Override
        public Mark getStart() {
            if (this.text == null && this.body != null && this.body.size() > 0) {
                return this.body.getNode(0).getStart();
            }
            return super.getStart();
        }
    }

    public static class Comment
    extends Node {
        public Comment(String string, Mark mark, Node node) {
            super(null, null, string, mark, node);
        }

        @Override
        public void accept(Visitor visitor) throws JasperException {
            visitor.visit(this);
        }
    }

    public static class DoBodyAction
    extends Node {
        public DoBodyAction(Attributes attributes, Mark mark, Node node) {
            this("jsp:doBody", attributes, null, null, mark, node);
        }

        public DoBodyAction(String string, Attributes attributes, Attributes attributes2, Attributes attributes3, Mark mark, Node node) {
            super(string, "doBody", attributes, attributes2, attributes3, mark, node);
        }

        @Override
        public void accept(Visitor visitor) throws JasperException {
            visitor.visit(this);
        }
    }

    public static class InvokeAction
    extends Node {
        public InvokeAction(Attributes attributes, Mark mark, Node node) {
            this("jsp:invoke", attributes, null, null, mark, node);
        }

        public InvokeAction(String string, Attributes attributes, Attributes attributes2, Attributes attributes3, Mark mark, Node node) {
            super(string, "invoke", attributes, attributes2, attributes3, mark, node);
        }

        @Override
        public void accept(Visitor visitor) throws JasperException {
            visitor.visit(this);
        }
    }

    public static class VariableDirective
    extends Node {
        public VariableDirective(Attributes attributes, Mark mark, Node node) {
            this("jsp:directive.variable", attributes, null, null, mark, node);
        }

        public VariableDirective(String string, Attributes attributes, Attributes attributes2, Attributes attributes3, Mark mark, Node node) {
            super(string, "directive.variable", attributes, attributes2, attributes3, mark, node);
        }

        @Override
        public void accept(Visitor visitor) throws JasperException {
            visitor.visit(this);
        }
    }

    public static class AttributeDirective
    extends Node {
        public AttributeDirective(Attributes attributes, Mark mark, Node node) {
            this("jsp:directive.attribute", attributes, null, null, mark, node);
        }

        public AttributeDirective(String string, Attributes attributes, Attributes attributes2, Attributes attributes3, Mark mark, Node node) {
            super(string, "directive.attribute", attributes, attributes2, attributes3, mark, node);
        }

        @Override
        public void accept(Visitor visitor) throws JasperException {
            visitor.visit(this);
        }
    }

    public static class TagDirective
    extends Node {
        private Vector<String> imports = new Vector();

        public TagDirective(Attributes attributes, Mark mark, Node node) {
            this("jsp:directive.tag", attributes, null, null, mark, node);
        }

        public TagDirective(String string, Attributes attributes, Attributes attributes2, Attributes attributes3, Mark mark, Node node) {
            super(string, "directive.tag", attributes, attributes2, attributes3, mark, node);
        }

        @Override
        public void accept(Visitor visitor) throws JasperException {
            visitor.visit(this);
        }

        public void addImport(String string) {
            int n;
            int n2 = 0;
            while ((n = string.indexOf(44, n2)) != -1) {
                this.imports.add(string.substring(n2, n).trim());
                n2 = n + 1;
            }
            if (n2 == 0) {
                this.imports.add(string.trim());
            } else {
                this.imports.add(string.substring(n2).trim());
            }
        }

        public List<String> getImports() {
            return this.imports;
        }
    }

    public static class TaglibDirective
    extends Node {
        public TaglibDirective(Attributes attributes, Mark mark, Node node) {
            super("jsp:taglib", "taglib", attributes, mark, node);
        }

        @Override
        public void accept(Visitor visitor) throws JasperException {
            visitor.visit(this);
        }
    }

    public static class IncludeDirective
    extends Node {
        public IncludeDirective(Attributes attributes, Mark mark, Node node) {
            this("jsp:directive.include", attributes, null, null, mark, node);
        }

        public IncludeDirective(String string, Attributes attributes, Attributes attributes2, Attributes attributes3, Mark mark, Node node) {
            super(string, "directive.include", attributes, attributes2, attributes3, mark, node);
        }

        @Override
        public void accept(Visitor visitor) throws JasperException {
            visitor.visit(this);
        }
    }

    public static class PageDirective
    extends Node {
        private Vector<String> imports = new Vector();

        public PageDirective(Attributes attributes, Mark mark, Node node) {
            this("jsp:directive.page", attributes, null, null, mark, node);
        }

        public PageDirective(String string, Attributes attributes, Attributes attributes2, Attributes attributes3, Mark mark, Node node) {
            super(string, "directive.page", attributes, attributes2, attributes3, mark, node);
        }

        @Override
        public void accept(Visitor visitor) throws JasperException {
            visitor.visit(this);
        }

        public void addImport(String string) {
            int n;
            int n2 = 0;
            while ((n = string.indexOf(44, n2)) != -1) {
                this.imports.add(this.validateImport(string.substring(n2, n)));
                n2 = n + 1;
            }
            if (n2 == 0) {
                this.imports.add(this.validateImport(string));
            } else {
                this.imports.add(this.validateImport(string.substring(n2)));
            }
        }

        public List<String> getImports() {
            return this.imports;
        }

        private String validateImport(String string) {
            if (string.indexOf(59) > -1) {
                throw new IllegalArgumentException(Localizer.getMessage("jsp.error.page.invalid.import"));
            }
            return string.trim();
        }
    }

    public static class JspRoot
    extends Node {
        public JspRoot(String string, Attributes attributes, Attributes attributes2, Attributes attributes3, Mark mark, Node node) {
            super(string, "root", attributes, attributes2, attributes3, mark, node);
        }

        @Override
        public void accept(Visitor visitor) throws JasperException {
            visitor.visit(this);
        }
    }

    public static class Root
    extends Node {
        private Root parentRoot;
        private boolean isXmlSyntax;
        private String pageEnc;
        private String jspConfigPageEnc;
        private boolean isDefaultPageEncoding;
        private boolean isEncodingSpecifiedInProlog;
        private boolean isBomPresent;
        private int tempSequenceNumber = 0;

        Root(Mark mark, Node node, boolean bl) {
            super(mark, node);
            Node node2;
            this.isXmlSyntax = bl;
            this.qName = "jsp:root";
            this.localName = "root";
            for (node2 = node; node2 != null && !(node2 instanceof Root); node2 = node2.getParent()) {
            }
            this.parentRoot = (Root)node2;
        }

        @Override
        public void accept(Visitor visitor) throws JasperException {
            visitor.visit(this);
        }

        public boolean isXmlSyntax() {
            return this.isXmlSyntax;
        }

        public void setJspConfigPageEncoding(String string) {
            this.jspConfigPageEnc = string;
        }

        public String getJspConfigPageEncoding() {
            return this.jspConfigPageEnc;
        }

        public void setPageEncoding(String string) {
            this.pageEnc = string;
        }

        public String getPageEncoding() {
            return this.pageEnc;
        }

        public void setIsDefaultPageEncoding(boolean bl) {
            this.isDefaultPageEncoding = bl;
        }

        public boolean isDefaultPageEncoding() {
            return this.isDefaultPageEncoding;
        }

        public void setIsEncodingSpecifiedInProlog(boolean bl) {
            this.isEncodingSpecifiedInProlog = bl;
        }

        public boolean isEncodingSpecifiedInProlog() {
            return this.isEncodingSpecifiedInProlog;
        }

        public void setIsBomPresent(boolean bl) {
            this.isBomPresent = bl;
        }

        public boolean isBomPresent() {
            return this.isBomPresent;
        }

        public Root getParentRoot() {
            return this.parentRoot;
        }

        public String nextTemporaryVariableName() {
            if (this.parentRoot == null) {
                return Constants.TEMP_VARIABLE_NAME_PREFIX + this.tempSequenceNumber++;
            }
            return this.parentRoot.nextTemporaryVariableName();
        }
    }
}

