/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.osm;

import java.util.List;
import org.openstreetmap.josm.data.osm.INode;
import org.openstreetmap.josm.data.osm.IPrimitive;
import org.openstreetmap.josm.data.osm.IRelation;
import org.openstreetmap.josm.data.osm.NameFormatter;

public interface IWay<N extends INode>
extends IPrimitive {
    public int getNodesCount();

    default public boolean isEmpty() {
        return this.getNodesCount() == 0;
    }

    default public int getRealNodesCount() {
        int count = this.getNodesCount();
        return this.isClosed() ? count - 1 : count;
    }

    public N getNode(int var1);

    public List<N> getNodes();

    public List<Long> getNodeIds();

    public long getNodeId(int var1);

    public void setNodes(List<N> var1);

    public boolean isClosed();

    @Override
    default public int compareTo(IPrimitive o) {
        if (o instanceof IRelation) {
            return 1;
        }
        return o instanceof IWay ? Long.compare(this.getUniqueId(), o.getUniqueId()) : -1;
    }

    @Override
    default public String getDisplayName(NameFormatter formatter) {
        return formatter.format(this);
    }

    public N firstNode();

    public N lastNode();

    public boolean isFirstLastNode(INode var1);

    public boolean isInnerNode(INode var1);

    default public boolean hasIncompleteNodes() {
        return false;
    }
}

