import sys
from _typeshed import ReadableBuffer
from typing_extensions import SupportsIndex, final

if sys.version_info >= (3, 0):
    from hashlib import _Hash
else:
    from hashlib import _hash as _Hash

VERSION: str
XXHASH_VERSION: str

class _IntDigestHash(_Hash):
    @property
    def seed(self) -> int: ...
    @property
    def digestsize(self) -> int: ...
    def __init__(self, input: ReadableBuffer | str = ..., seed: SupportsIndex = ...) -> None: ...
    def intdigest(self) -> int: ...
    def reset(self) -> None: ...

# python-xxhash v2.0.0 does not support the string or usedforsecurity kwargs
@final
class xxh32(_IntDigestHash): ...

@final
class xxh64(_IntDigestHash): ...

@final
class xxh3_64(_IntDigestHash): ...

@final
class xxh3_128(_IntDigestHash): ...

def xxh32_digest(input: ReadableBuffer | str, seed: SupportsIndex = ...) -> bytes: ...
def xxh32_intdigest(input: ReadableBuffer | str, seed: SupportsIndex = ...) -> int: ...
def xxh32_hexdigest(input: ReadableBuffer | str, seed: SupportsIndex = ...) -> str: ...
def xxh64_digest(input: ReadableBuffer | str, seed: SupportsIndex = ...) -> bytes: ...
def xxh64_intdigest(input: ReadableBuffer | str, seed: SupportsIndex = ...) -> int: ...
def xxh64_hexdigest(input: ReadableBuffer | str, seed: SupportsIndex = ...) -> str: ...
def xxh3_64_digest(input: ReadableBuffer | str, seed: SupportsIndex = ...) -> bytes: ...
def xxh3_64_intdigest(input: ReadableBuffer | str, seed: SupportsIndex = ...) -> int: ...
def xxh3_64_hexdigest(input: ReadableBuffer | str, seed: SupportsIndex = ...) -> str: ...
def xxh3_128_digest(input: ReadableBuffer | str, seed: SupportsIndex = ...) -> bytes: ...
def xxh3_128_intdigest(input: ReadableBuffer | str, seed: SupportsIndex = ...) -> int: ...
def xxh3_128_hexdigest(input: ReadableBuffer | str, seed: SupportsIndex = ...) -> str: ...

xxh128 = xxh3_128
xxh128_digest = xxh3_128_digest
xxh128_intdigest = xxh3_128_intdigest
xxh128_hexdigest = xxh3_128_hexdigest
