/* src/cysignals/cysignals_config.h.  Generated from cysignals_config.h.in by configure.  */
/*
 * Should cysignals be compiled with support for verbose debugging
 * output? The debug level itself needs to be set using the C function
 * _set_debug_level() or the Python function set_debug_level().
 * Enabling this will make the code slower, even if the debug level is
 * set to 0.
 */
#ifndef ENABLE_DEBUG_CYSIGNALS
/* #undef ENABLE_DEBUG_CYSIGNALS */
#endif


/*
 * Should sig_on() use sigsetjmp(env, 0) instead of setjmp(env)? This
 * is needed on BSD and OS X because setjmp() saves the signal mask.
 * With glibc, we also use sigsetjmp because it's faster.
 */
#ifndef CYSIGNALS_USE_SIGSETJMP
#define CYSIGNALS_USE_SIGSETJMP 1
#endif


/* Should we use an assembly implementation of cysetjmp()? */
#ifndef CYSIGNALS_ASM_CYSETJMP
/* #undef CYSIGNALS_ASM_CYSETJMP */
#endif


/* An implementation of atomic variables might not be allowed with OpenMP */
#define CYSIGNALS_C_ATOMIC_WITH_OPENMP 1
/* #undef CYSIGNALS_CXX_ATOMIC_WITH_OPENMP */
#define CYSIGNALS_STD_ATOMIC_WITH_OPENMP 1

/* Which implementation of atomic variables (if any) to use? */
#ifndef __cplusplus

#if defined(CYSIGNALS_C_ATOMIC_WITH_OPENMP) || !defined(_OPENMP)
#define CYSIGNALS_C_ATOMIC 1
#endif

#else

#if defined(CYSIGNALS_CXX_ATOMIC_WITH_OPENMP) || !defined(_OPENMP)
/* #undef CYSIGNALS_CXX_ATOMIC */
#endif
#if defined(CYSIGNALS_STD_ATOMIC_WITH_OPENMP) || !defined(_OPENMP)
#define CYSIGNALS_STD_ATOMIC 1
#endif

#endif
