# This file has been autogenerated by the pywayland scanner

# Copyright © 2017 Collabora, Ltd.
#
# Permission is hereby granted, free of charge, to any person obtaining a
# copy of this software and associated documentation files (the "Software"),
# to deal in the Software without restriction, including without limitation
# the rights to use, copy, modify, merge, publish, distribute, sublicense,
# and/or sell copies of the Software, and to permit persons to whom the
# Software is furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice (including the next
# paragraph) shall be included in all copies or substantial portions of the
# Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
# THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
# FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
# DEALINGS IN THE SOFTWARE.

from pywayland.protocol_core import Argument, ArgumentType, Global, Interface, Proxy, Resource


class ZwpInputTimestampsV1(Interface):
    """Context object for input timestamps

    Provides high-resolution timestamp events for a set of subscribed input
    events. The set of subscribed input events is determined by the
    :class:`~pywayland.protocol.input_timestamps_unstable_v1.ZwpInputTimestampsManagerV1`
    request used to create this object.
    """

    name = "zwp_input_timestamps_v1"
    version = 1


class ZwpInputTimestampsV1Proxy(Proxy):
    interface = ZwpInputTimestampsV1

    @ZwpInputTimestampsV1.request()
    def destroy(self):
        """Destroy the input timestamps object

        Informs the server that the client will no longer be using this
        protocol object. After the server processes the request, no more
        timestamp events will be emitted.
        """
        self._marshal(0)
        self._destroy()


class ZwpInputTimestampsV1Resource(Resource):
    interface = ZwpInputTimestampsV1

    @ZwpInputTimestampsV1.event(
        Argument(ArgumentType.Uint),
        Argument(ArgumentType.Uint),
        Argument(ArgumentType.Uint),
    )
    def timestamp(self, tv_sec_hi, tv_sec_lo, tv_nsec):
        """High-resolution timestamp event

        The timestamp event is associated with the first subsequent input event
        carrying a timestamp which belongs to the set of input events this
        object is subscribed to.

        The timestamp provided by this event is a high-resolution version of
        the timestamp argument of the associated input event. The provided
        timestamp is in the same clock domain and is at least as accurate as
        the associated input event timestamp.

        The timestamp is expressed as tv_sec_hi, tv_sec_lo, tv_nsec triples,
        each component being an unsigned 32-bit value. Whole seconds are in
        tv_sec which is a 64-bit value combined from tv_sec_hi and tv_sec_lo,
        and the additional fractional part in tv_nsec as nanoseconds. Hence,
        for valid timestamps tv_nsec must be in [0, 999999999].

        :param tv_sec_hi:
            high 32 bits of the seconds part of the timestamp
        :type tv_sec_hi:
            `ArgumentType.Uint`
        :param tv_sec_lo:
            low 32 bits of the seconds part of the timestamp
        :type tv_sec_lo:
            `ArgumentType.Uint`
        :param tv_nsec:
            nanoseconds part of the timestamp
        :type tv_nsec:
            `ArgumentType.Uint`
        """
        self._post_event(0, tv_sec_hi, tv_sec_lo, tv_nsec)


class ZwpInputTimestampsV1Global(Global):
    interface = ZwpInputTimestampsV1


ZwpInputTimestampsV1._gen_c()
ZwpInputTimestampsV1.proxy_class = ZwpInputTimestampsV1Proxy
ZwpInputTimestampsV1.resource_class = ZwpInputTimestampsV1Resource
ZwpInputTimestampsV1.global_class = ZwpInputTimestampsV1Global
