/* appstream.vapi generated by vapigen, do not modify. */

[CCode (cprefix = "As", gir_namespace = "AppStream", gir_version = "1.0", lower_case_cprefix = "as_")]
namespace AppStream {
	[CCode (cheader_filename = "appstream.h", type_id = "as_agreement_get_type ()")]
	public class Agreement : GLib.Object {
		[CCode (has_construct_function = false)]
		[Version (since = "0.12.1")]
		public Agreement ();
		public void add_section (AppStream.AgreementSection agreement_section);
		[Version (since = "0.12.1")]
		public AppStream.AgreementKind get_kind ();
		[Version (since = "0.12.1")]
		public unowned AppStream.AgreementSection? get_section_default ();
		[Version (since = "0.12.1")]
		public unowned GLib.GenericArray<AppStream.AgreementSection> get_sections ();
		[Version (since = "0.12.1")]
		public unowned string get_version_id ();
		[Version (since = "0.12.1")]
		public void set_kind (AppStream.AgreementKind kind);
		[Version (since = "0.12.1")]
		public void set_version_id (string version_id);
	}
	[CCode (cheader_filename = "appstream.h", type_id = "as_agreement_section_get_type ()")]
	public class AgreementSection : GLib.Object {
		[CCode (has_construct_function = false)]
		[Version (since = "0.12.1")]
		public AgreementSection ();
		public unowned string get_active_locale ();
		[Version (since = "0.12.1")]
		public unowned string get_description ();
		[Version (since = "0.12.1")]
		public unowned string get_kind ();
		[Version (since = "0.12.1")]
		public unowned string get_name ();
		public void set_active_locale (string locale);
		[Version (since = "0.12.1")]
		public void set_description (string desc, string? locale);
		[Version (since = "0.12.1")]
		public void set_kind (string kind);
		[Version (since = "0.12.1")]
		public void set_name (string name, string? locale);
	}
	[CCode (cheader_filename = "appstream.h", type_id = "as_artifact_get_type ()")]
	public class Artifact : GLib.Object {
		[CCode (has_construct_function = false)]
		public Artifact ();
		public void add_checksum (AppStream.Checksum cs);
		public void add_location (string location);
		public AppStream.BundleKind get_bundle_kind ();
		public unowned AppStream.Checksum? get_checksum (AppStream.ChecksumKind kind);
		public unowned GLib.GenericArray<AppStream.Checksum> get_checksums ();
		public unowned string get_filename ();
		public AppStream.ArtifactKind get_kind ();
		public unowned GLib.GenericArray<string> get_locations ();
		public unowned string get_platform ();
		public uint64 get_size (AppStream.SizeKind kind);
		public void set_bundle_kind (AppStream.BundleKind kind);
		public void set_filename (string filename);
		public void set_kind (AppStream.ArtifactKind kind);
		public void set_platform (string platform);
		public void set_size (uint64 size, AppStream.SizeKind kind);
	}
	[CCode (cheader_filename = "appstream.h", type_id = "as_bundle_get_type ()")]
	public class Bundle : GLib.Object {
		[CCode (has_construct_function = false)]
		[Version (since = "0.10")]
		public Bundle ();
		[Version (since = "0.10")]
		public unowned string get_id ();
		[Version (since = "0.10")]
		public AppStream.BundleKind get_kind ();
		[Version (since = "0.10")]
		public void set_id (string id);
		[Version (since = "0.10")]
		public void set_kind (AppStream.BundleKind kind);
	}
	[CCode (cheader_filename = "appstream.h", type_id = "as_category_get_type ()")]
	public class Category : GLib.Object {
		[CCode (has_construct_function = false)]
		public Category ();
		public void add_child (AppStream.Category subcat);
		public void add_component (AppStream.Component cpt);
		public void add_desktop_group (string group_name);
		public unowned GLib.GenericArray<AppStream.Category> get_children ();
		public unowned GLib.GenericArray<AppStream.Component> get_components ();
		public unowned GLib.GenericArray<string> get_desktop_groups ();
		public unowned string get_icon ();
		public unowned string get_id ();
		public unowned string get_name ();
		public unowned string get_summary ();
		public bool has_children ();
		public bool has_component (AppStream.Component cpt);
		public void remove_child (AppStream.Category subcat);
		public void set_icon (string value);
		public void set_id (string id);
		public void set_name (string value);
		public void set_summary (string value);
		public void* children { get; }
		public string icon { get; set; }
		public string id { get; set; }
		public string name { get; set; }
		public string summary { get; }
	}
	[CCode (cheader_filename = "appstream.h", type_id = "as_checksum_get_type ()")]
	public class Checksum : GLib.Object {
		[CCode (has_construct_function = false)]
		public Checksum ();
		[CCode (has_construct_function = false)]
		[Version (since = "0.12.11")]
		public Checksum.for_kind_value (AppStream.ChecksumKind kind, string value);
		public AppStream.ChecksumKind get_kind ();
		public unowned string get_value ();
		public void set_kind (AppStream.ChecksumKind kind);
		public void set_value (string value);
	}
	[CCode (cheader_filename = "appstream.h", type_id = "as_component_get_type ()")]
	public class Component : GLib.Object {
		[CCode (has_construct_function = false)]
		public Component ();
		[Version (since = "0.9.2")]
		public void add_addon (AppStream.Component addon);
		[Version (since = "0.12.1")]
		public void add_agreement (AppStream.Agreement agreement);
		[Version (since = "0.8.0")]
		public void add_bundle (AppStream.Bundle bundle);
		public void add_category (string category);
		[Version (since = "0.11.0")]
		public void add_content_rating (AppStream.ContentRating content_rating);
		[Version (since = "0.7.0")]
		public void add_extends (string cpt_id);
		public void add_icon (AppStream.Icon icon);
		[Version (since = "0.7.0")]
		public void add_language (string? locale, int percentage);
		[Version (since = "0.11.0")]
		public void add_launchable (AppStream.Launchable launchable);
		[Version (since = "0.6.2")]
		public void add_provided (AppStream.Provided prov);
		public void add_provided_item (AppStream.ProvidedKind kind, string item);
		[Version (since = "0.12.0")]
		public void add_relation (AppStream.Relation relation);
		public void add_release (AppStream.Release release);
		[Version (since = "0.14.0")]
		public void add_review (AppStream.Review review);
		public void add_screenshot (AppStream.Screenshot sshot);
		public void add_suggested (AppStream.Suggested suggested);
		[Version (since = "0.14.8")]
		public bool add_tag (string ns, string tag);
		[Version (since = "0.9.2")]
		public void add_translation (AppStream.Translation tr);
		[Version (since = "0.6.2")]
		public void add_url (AppStream.UrlKind url_kind, string url);
		[Version (since = "0.14.5")]
		public void clear_languages ();
		[Version (since = "0.14.8")]
		public void clear_tags ();
		public unowned string get_active_locale ();
		[Version (since = "0.9.2")]
		public unowned GLib.GenericArray<AppStream.Component> get_addons ();
		[Version (since = "0.12.1")]
		public unowned AppStream.Agreement? get_agreement_by_kind (AppStream.AgreementKind kind);
		[Version (since = "0.14.8")]
		public unowned GLib.GenericArray<AppStream.Agreement> get_agreements ();
		[Version (since = "0.14.0")]
		public unowned string get_branch ();
		[Version (since = "0.8.0")]
		public unowned AppStream.Bundle? get_bundle (AppStream.BundleKind bundle_kind);
		[Version (since = "0.10")]
		public unowned GLib.GenericArray<AppStream.Bundle> get_bundles ();
		public unowned GLib.GenericArray<string> get_categories ();
		public unowned GLib.GenericArray<string> get_compulsory_for_desktops ();
		[Version (since = "0.11.0")]
		public unowned AppStream.ContentRating? get_content_rating (string kind);
		[Version (since = "0.11.0")]
		public unowned GLib.GenericArray<AppStream.ContentRating> get_content_ratings ();
		[Version (since = "0.11.2")]
		public unowned AppStream.Context? get_context ();
		[Version (since = "0.10.5")]
		public unowned GLib.HashTable<void*,void*> get_custom ();
		[Version (since = "0.10.5")]
		public unowned string get_custom_value (string key);
		public unowned string get_data_id ();
		public unowned string get_description ();
		[Version (deprecated = true, deprecated_since = "0.11.0", since = "0.9.8")]
		public unowned string get_desktop_id ();
		public unowned string get_developer_name ();
		[Version (since = "0.7.0")]
		public unowned GLib.GenericArray<string>? get_extends ();
		public unowned AppStream.Icon? get_icon_by_size (uint width, uint height);
		public unowned GLib.GenericArray<AppStream.Icon> get_icons ();
		public unowned string get_id ();
		[CCode (array_length = false, array_null_terminated = true)]
		public unowned string[] get_keywords ();
		public unowned GLib.HashTable<void*,void*> get_keywords_table ();
		public AppStream.ComponentKind get_kind ();
		[Version (since = "0.7.0")]
		public int get_language (string? locale);
		[Version (since = "0.7.0")]
		public GLib.List<weak string> get_languages ();
		[Version (since = "0.11.0")]
		public unowned AppStream.Launchable? get_launchable (AppStream.LaunchableKind kind);
		[Version (since = "0.11.0")]
		public unowned GLib.GenericArray<AppStream.Launchable> get_launchables ();
		[Version (since = "0.9.8")]
		public AppStream.MergeKind get_merge_kind ();
		public unowned string get_metadata_license ();
		public unowned string get_name ();
		public unowned GLib.HashTable<void*,void*> get_name_table ();
		[Version (since = "0.12.10")]
		public unowned string get_name_variant_suffix ();
		public unowned string get_origin ();
		public unowned string get_pkgname ();
		[CCode (array_length = false, array_null_terminated = true)]
		public unowned string[] get_pkgnames ();
		[Version (since = "0.6.1")]
		public int get_priority ();
		public unowned string get_project_group ();
		public unowned string get_project_license ();
		public unowned GLib.GenericArray<AppStream.Provided> get_provided ();
		public unowned AppStream.Provided? get_provided_for_kind (AppStream.ProvidedKind kind);
		[Version (since = "0.12.0")]
		public unowned GLib.GenericArray<AppStream.Relation> get_recommends ();
		public unowned GLib.GenericArray<AppStream.Release> get_releases ();
		[Version (since = "0.12.0")]
		public unowned GLib.GenericArray<AppStream.Relation> get_requires ();
		[Version (since = "0.14.0")]
		public unowned GLib.GenericArray<AppStream.Review> get_reviews ();
		[Version (since = "0.10.2")]
		public AppStream.ComponentScope get_scope ();
		public unowned GLib.GenericArray<AppStream.Screenshot> get_screenshots ();
		[Version (since = "0.9.7")]
		public GLib.GenericArray<weak string> get_search_tokens ();
		[Version (since = "0.12.11")]
		public uint get_sort_score ();
		public unowned string get_source_pkgname ();
		public unowned GLib.GenericArray<AppStream.Suggested> get_suggested ();
		public unowned string get_summary ();
		public unowned GLib.HashTable<void*,void*> get_summary_table ();
		[Version (since = "0.14.8")]
		public unowned GLib.GenericArray<AppStream.Relation> get_supports ();
		[Version (since = "0.9.2")]
		public unowned GLib.GenericArray<AppStream.Translation> get_translations ();
		[Version (since = "0.6.2")]
		public unowned string? get_url (AppStream.UrlKind url_kind);
		public AppStream.ValueFlags get_value_flags ();
		public bool has_bundle ();
		public bool has_category (string category);
		[Version (since = "0.14.8")]
		public bool has_tag (string ns, string tag);
		[Version (since = "0.10.5")]
		public bool insert_custom_value (string key, string value);
		public bool is_compulsory_for_desktop (string desktop);
		[Version (since = "0.10.2")]
		public bool is_ignored ();
		public bool is_member_of_category (AppStream.Category category);
		public bool is_valid ();
		[Version (since = "0.14.0")]
		public bool load_from_bytes (AppStream.Context context, AppStream.FormatKind format, GLib.Bytes bytes) throws GLib.Error;
		[Version (since = "0.12.10")]
		public bool load_from_xml_data (AppStream.Context context, string data) throws GLib.Error;
		[Version (since = "0.14.8")]
		public bool remove_tag (string ns, string tag);
		[Version (since = "0.9.7")]
		public uint search_matches (string term);
		[Version (since = "0.9.8")]
		public uint search_matches_all (string terms);
		public void set_active_locale (string? locale);
		[Version (since = "0.14.0")]
		public void set_branch (string branch);
		public void set_compulsory_for_desktop (string desktop);
		public void set_data_id (string value);
		public void set_description (string value, string? locale);
		public void set_developer_name (string value, string? locale);
		public void set_id (string value);
		public void set_keywords ([CCode (array_length = false, array_null_terminated = true)] string[] value, string? locale);
		public void set_kind (AppStream.ComponentKind value);
		[Version (since = "0.9.8")]
		public void set_merge_kind (AppStream.MergeKind kind);
		public void set_metadata_license (string value);
		public void set_name (string value, string? locale);
		[Version (since = "0.12.10")]
		public void set_name_variant_suffix (string value, string? locale);
		public void set_origin (string origin);
		[Version (since = "0.14.5")]
		public void set_pkgname (string pkgname);
		public void set_pkgnames ([CCode (array_length = false, array_null_terminated = true)] string[] packages);
		[Version (since = "0.6.1")]
		public void set_priority (int priority);
		public void set_project_group (string value);
		public void set_project_license (string value);
		public void set_scope (AppStream.ComponentScope scope);
		[Version (since = "0.9.8")]
		public void set_sort_score (uint score);
		public void set_source_pkgname (string spkgname);
		public void set_summary (string value, string? locale);
		public void set_value_flags (AppStream.ValueFlags flags);
		public string to_string ();
		[Version (since = "0.12.10")]
		public string to_xml_data (AppStream.Context context) throws GLib.Error;
		public GLib.GenericArray<void*> categories { get; }
		[NoAccessorMethod]
		public string description { owned get; set; }
		[NoAccessorMethod]
		public string developer_name { owned get; set; }
		public GLib.List<AppStream.Icon> icons { get; }
		public string id { get; set; }
		[CCode (array_length = false, array_null_terminated = true)]
		[NoAccessorMethod]
		public string[] keywords { owned get; set; }
		public AppStream.ComponentKind kind { get; set; }
		[NoAccessorMethod]
		public string name { owned get; set; }
		[CCode (array_length = false, array_null_terminated = true)]
		public string[] pkgnames { get; set; }
		public string project_group { get; set; }
		public string project_license { get; set; }
		public GLib.GenericArray<AppStream.Screenshot> screenshots { get; }
		[NoAccessorMethod]
		public string summary { owned get; set; }
		[NoAccessorMethod]
		public GLib.HashTable<AppStream.UrlKind,string> urls { owned get; }
	}
	[CCode (cheader_filename = "appstream.h", type_id = "as_content_rating_get_type ()")]
	public class ContentRating : GLib.Object {
		[CCode (has_construct_function = false)]
		[Version (since = "0.11.0")]
		public ContentRating ();
		[Version (since = "0.14.0")]
		public void add_attribute (string id, AppStream.ContentRatingValue value);
		[Version (since = "0.12.12")]
		public static AppStream.ContentRatingValue attribute_from_csm_age (string id, uint age);
		[Version (since = "0.12.12")]
		public static unowned string attribute_get_description (string id, AppStream.ContentRatingValue value);
		[Version (since = "0.12.10")]
		public static uint attribute_to_csm_age (string id, AppStream.ContentRatingValue value);
		[CCode (array_length = false, array_null_terminated = true)]
		[Version (since = "0.12.10")]
		public static (unowned string)[] get_all_rating_ids ();
		[Version (since = "0.11.0")]
		public unowned string get_kind ();
		[Version (since = "0.11.0")]
		public uint get_minimum_age ();
		[CCode (array_length = false, array_null_terminated = true)]
		[Version (since = "0.12.10")]
		public (unowned string)[] get_rating_ids ();
		[Version (since = "0.11.0")]
		public AppStream.ContentRatingValue get_value (string id);
		[Version (since = "0.11.0")]
		public void set_kind (string kind);
		[Version (since = "0.11.0")]
		public void set_value (string id, AppStream.ContentRatingValue value);
	}
	[CCode (cheader_filename = "appstream.h", type_id = "as_context_get_type ()")]
	public class Context : GLib.Object {
		[CCode (has_construct_function = false)]
		public Context ();
		public unowned string get_filename ();
		public AppStream.FormatVersion get_format_version ();
		public unowned string get_locale ();
		public bool get_locale_all_enabled ();
		public unowned string get_media_baseurl ();
		public unowned string get_origin ();
		public int get_priority ();
		public AppStream.FormatStyle get_style ();
		public bool has_media_baseurl ();
		public void set_filename (string fname);
		public void set_format_version (AppStream.FormatVersion ver);
		public void set_locale (string value);
		public void set_media_baseurl (string value);
		public void set_origin (string value);
		public void set_priority (int priority);
		public void set_style (AppStream.FormatStyle style);
	}
	[CCode (cheader_filename = "appstream.h", type_id = "as_distro_details_get_type ()")]
	public class DistroDetails : GLib.Object {
		[CCode (has_construct_function = false)]
		public DistroDetails ();
		public bool get_bool (string key, bool default_val);
		public unowned string get_cid ();
		public unowned string get_homepage ();
		public unowned string get_id ();
		public unowned string get_name ();
		public string get_str (string key);
		public unowned string get_version ();
		public string homepage { get; }
		public string id { get; }
		public string name { get; }
		public string version { get; }
	}
	[CCode (cheader_filename = "appstream.h", type_id = "as_icon_get_type ()")]
	public class Icon : GLib.Object {
		[CCode (has_construct_function = false)]
		public Icon ();
		public unowned string get_filename ();
		public uint get_height ();
		public AppStream.IconKind get_kind ();
		public unowned string get_name ();
		[Version (since = "0.11.0")]
		public uint get_scale ();
		public unowned string get_url ();
		public uint get_width ();
		public void set_filename (string filename);
		public void set_height (uint height);
		public void set_kind (AppStream.IconKind kind);
		public void set_name (string name);
		[Version (since = "0.11.0")]
		public void set_scale (uint scale);
		public void set_url (string url);
		public void set_width (uint width);
	}
	[CCode (cheader_filename = "appstream.h", type_id = "as_image_get_type ()")]
	public class Image : GLib.Object {
		[CCode (has_construct_function = false)]
		public Image ();
		public uint get_height ();
		public AppStream.ImageKind get_kind ();
		[Version (since = "0.9.5")]
		public unowned string get_locale ();
		public unowned string get_url ();
		public uint get_width ();
		public void set_height (uint height);
		public void set_kind (AppStream.ImageKind kind);
		[Version (since = "0.9.5")]
		public void set_locale (string locale);
		public void set_url (string url);
		public void set_width (uint width);
	}
	[CCode (cheader_filename = "appstream.h", type_id = "as_issue_get_type ()")]
	public class Issue : GLib.Object {
		[CCode (has_construct_function = false)]
		public Issue ();
		public unowned string get_id ();
		public AppStream.IssueKind get_kind ();
		public unowned string get_url ();
		public void set_id (string id);
		public void set_kind (AppStream.IssueKind kind);
		public void set_url (string url);
	}
	[CCode (cheader_filename = "appstream.h", type_id = "as_launchable_get_type ()")]
	public class Launchable : GLib.Object {
		[CCode (has_construct_function = false)]
		[Version (since = "0.11.0")]
		public Launchable ();
		[Version (since = "0.11.0")]
		public void add_entry (string entry);
		[Version (since = "0.11.0")]
		public unowned GLib.GenericArray<string> get_entries ();
		[Version (since = "0.11.0")]
		public AppStream.LaunchableKind get_kind ();
		[Version (since = "0.11.0")]
		public void set_kind (AppStream.LaunchableKind kind);
	}
	[CCode (cheader_filename = "appstream.h", type_id = "as_metadata_get_type ()")]
	public class Metadata : GLib.Object {
		[CCode (has_construct_function = false)]
		public Metadata ();
		public void add_component (AppStream.Component cpt);
		public void clear_components ();
		public string component_to_metainfo (AppStream.FormatKind format) throws GLib.Error;
		public string components_to_collection (AppStream.FormatKind format) throws GLib.Error;
		[Version (since = "0.14.0")]
		public static AppStream.FormatStyle file_guess_style (string filename);
		public unowned string get_architecture ();
		public unowned AppStream.Component? get_component ();
		public unowned GLib.GenericArray<AppStream.Component> get_components ();
		public AppStream.FormatStyle get_format_style ();
		public AppStream.FormatVersion get_format_version ();
		public unowned string get_locale ();
		public unowned string get_media_baseurl ();
		public unowned string get_origin ();
		public AppStream.ParseFlags get_parse_flags ();
		public bool get_update_existing ();
		public bool get_write_header ();
		public bool parse (string data, AppStream.FormatKind format) throws GLib.Error;
		[Version (since = "0.14.0")]
		public bool parse_bytes (GLib.Bytes bytes, AppStream.FormatKind format) throws GLib.Error;
		public bool parse_desktop_data (string data, string cid) throws GLib.Error;
		public bool parse_file (GLib.File file, AppStream.FormatKind format) throws GLib.Error;
		public bool save_collection (string fname, AppStream.FormatKind format) throws GLib.Error;
		public bool save_metainfo (string fname, AppStream.FormatKind format) throws GLib.Error;
		public void set_architecture (string arch);
		public void set_format_style (AppStream.FormatStyle mode);
		public void set_format_version (AppStream.FormatVersion version);
		public void set_locale (string locale);
		public void set_media_baseurl (string url);
		public void set_origin (string origin);
		public void set_parse_flags (AppStream.ParseFlags flags);
		public void set_update_existing (bool update);
		public void set_write_header (bool wheader);
	}
	[CCode (cheader_filename = "appstream.h", type_id = "as_pool_get_type ()")]
	public class Pool : GLib.Object {
		[CCode (has_construct_function = false)]
		public Pool ();
		[Version (deprecated = true, deprecated_since = "0.14.7")]
		public bool add_component (AppStream.Component cpt) throws GLib.Error;
		[Version (since = "0.14.8")]
		public bool add_components (GLib.GenericArray<AppStream.Component> cpts) throws GLib.Error;
		public void add_extra_data_location (string directory, AppStream.FormatStyle format_style);
		[Version (since = "0.14.7")]
		public void add_flags (AppStream.PoolFlags flags);
		[Version (deprecated = true, deprecated_since = "0.14.7")]
		public void add_metadata_location (string directory);
		[CCode (array_length = false, array_null_terminated = true)]
		public string[] build_search_tokens (string search);
		public void clear ();
		public bool clear2 () throws GLib.Error;
		[Version (deprecated = true, deprecated_since = "0.14.7")]
		public void clear_metadata_locations ();
		[Version (deprecated = true, deprecated_since = "0.14.7")]
		public AppStream.CacheFlags get_cache_flags ();
		[Version (deprecated = true, deprecated_since = "0.14.7")]
		public unowned string get_cache_location ();
		public GLib.GenericArray<AppStream.Component> get_components ();
		public GLib.GenericArray<AppStream.Component> get_components_by_categories (string categories);
		[Version (since = "0.14.7")]
		public GLib.GenericArray<AppStream.Component> get_components_by_extends (string extended_id);
		public GLib.GenericArray<AppStream.Component> get_components_by_id (string cid);
		public GLib.GenericArray<AppStream.Component> get_components_by_kind (AppStream.ComponentKind kind);
		[Version (since = "0.11.4")]
		public GLib.GenericArray<AppStream.Component> get_components_by_launchable (AppStream.LaunchableKind kind, string id);
		public GLib.GenericArray<AppStream.Component> get_components_by_provided_item (AppStream.ProvidedKind kind, string item);
		public AppStream.PoolFlags get_flags ();
		public unowned string get_locale ();
		public bool load (GLib.Cancellable? cancellable = null) throws GLib.Error;
		[Version (since = "0.12.10")]
		public async bool load_async (GLib.Cancellable? cancellable) throws GLib.Error;
		public bool load_cache_file (string fname) throws GLib.Error;
		public bool refresh_cache (bool force) throws GLib.Error;
		[Version (since = "0.14.7")]
		public void remove_flags (AppStream.PoolFlags flags);
		[Version (since = "0.14.7")]
		public void reset_extra_data_locations ();
		public bool save_cache_file (string fname) throws GLib.Error;
		[Version (since = "0.9.7")]
		public GLib.GenericArray<AppStream.Component> search (string search);
		[Version (deprecated = true, deprecated_since = "0.14.7")]
		public void set_cache_flags (AppStream.CacheFlags flags);
		[Version (deprecated = true, deprecated_since = "0.14.7", since = "0.12.7")]
		public void set_cache_location (string fname);
		public void set_flags (AppStream.PoolFlags flags);
		[Version (since = "0.14.7")]
		public void set_load_std_data_locations (bool enabled);
		public void set_locale (string locale);
		[Version (since = "0.14.8")]
		public virtual signal void changed ();
	}
	[CCode (cheader_filename = "appstream.h", type_id = "as_provided_get_type ()")]
	public class Provided : GLib.Object {
		[CCode (has_construct_function = false)]
		public Provided ();
		public void add_item (string item);
		public unowned GLib.GenericArray<string> get_items ();
		public AppStream.ProvidedKind get_kind ();
		public bool has_item (string item);
		public void set_kind (AppStream.ProvidedKind kind);
	}
	[CCode (cheader_filename = "appstream.h", type_id = "as_relation_get_type ()")]
	public class Relation : GLib.Object {
		[CCode (has_construct_function = false)]
		[Version (since = "0.11.0")]
		public Relation ();
		[Version (since = "0.12.0")]
		public AppStream.RelationCompare get_compare ();
		[Version (since = "0.12.12")]
		public AppStream.DisplaySideKind get_display_side_kind ();
		[Version (since = "0.12.0")]
		public AppStream.RelationItemKind get_item_kind ();
		[Version (since = "0.12.0")]
		public AppStream.RelationKind get_kind ();
		[Version (since = "0.12.0")]
		public unowned string get_value ();
		[Version (since = "0.12.11")]
		public AppStream.ControlKind get_value_control_kind ();
		[Version (since = "0.12.12")]
		public AppStream.DisplayLengthKind get_value_display_length_kind ();
		[Version (since = "0.12.0")]
		public int get_value_int ();
		[Version (since = "0.12.12")]
		public int get_value_px ();
		[Version (since = "0.12.12")]
		public unowned string get_value_str ();
		[Version (since = "0.12.0")]
		public unowned string get_version ();
		[Version (since = "0.12.0")]
		public void set_compare (AppStream.RelationCompare compare);
		[Version (since = "0.12.12")]
		public void set_display_side_kind (AppStream.DisplaySideKind kind);
		[Version (since = "0.12.0")]
		public void set_item_kind (AppStream.RelationItemKind kind);
		[Version (since = "0.12.0")]
		public void set_kind (AppStream.RelationKind kind);
		[Version (since = "0.12.0")]
		public void set_value (string value);
		[Version (since = "0.12.12")]
		public void set_value_control_kind (AppStream.ControlKind kind);
		[Version (since = "0.12.12")]
		public void set_value_display_length_kind (AppStream.DisplayLengthKind kind);
		[Version (since = "0.12.12")]
		public void set_value_int (int value);
		[Version (since = "0.12.12")]
		public void set_value_px (int logical_px);
		[Version (since = "0.12.12")]
		public void set_value_str (string value);
		[Version (since = "0.12.0")]
		public void set_version (string version);
		[Version (since = "0.12.0")]
		public bool version_compare (string version) throws GLib.Error;
	}
	[CCode (cheader_filename = "appstream.h", type_id = "as_release_get_type ()")]
	public class Release : GLib.Object {
		[CCode (has_construct_function = false)]
		public Release ();
		[Version (since = "0.12.6")]
		public void add_artifact (AppStream.Artifact artifact);
		[Version (deprecated = true, since = "0.8.2")]
		public void add_checksum (AppStream.Checksum cs);
		[Version (since = "0.12.9")]
		public void add_issue (AppStream.Issue issue);
		[Version (deprecated = true, since = "0.8.1")]
		public void add_location (string location);
		public unowned string get_active_locale ();
		[Version (since = "0.12.6")]
		public unowned GLib.GenericArray<AppStream.Artifact> get_artifacts ();
		[Version (deprecated = true, since = "0.8.2")]
		public unowned AppStream.Checksum? get_checksum (AppStream.ChecksumKind kind);
		[Version (deprecated = true, since = "0.10")]
		public unowned GLib.GenericArray<AppStream.Checksum> get_checksums ();
		[Version (since = "0.12.5")]
		public unowned string get_date ();
		[Version (since = "0.12.5")]
		public unowned string get_date_eol ();
		public unowned string? get_description ();
		[Version (since = "0.12.9")]
		public unowned GLib.GenericArray<AppStream.Issue> get_issues ();
		[Version (since = "0.12.0")]
		public AppStream.ReleaseKind get_kind ();
		[Version (deprecated = true, since = "0.8.1")]
		public unowned GLib.GenericArray<string> get_locations ();
		[Version (deprecated = true, since = "0.8.6")]
		public uint64 get_size (AppStream.SizeKind kind);
		public uint64 get_timestamp ();
		[Version (since = "0.12.5")]
		public uint64 get_timestamp_eol ();
		[Version (since = "0.6.5")]
		public AppStream.UrgencyKind get_urgency ();
		[Version (since = "0.12.5")]
		public unowned string? get_url (AppStream.ReleaseUrlKind url_kind);
		public unowned string? get_version ();
		public void set_active_locale (string locale);
		[Version (since = "0.12.5")]
		public void set_date (string date);
		[Version (since = "0.12.5")]
		public void set_date_eol (string date);
		public void set_description (string description, string locale);
		[Version (since = "0.12.0")]
		public void set_kind (AppStream.ReleaseKind kind);
		[Version (deprecated = true, since = "0.8.6")]
		public void set_size (uint64 size, AppStream.SizeKind kind);
		public void set_timestamp (uint64 timestamp);
		[Version (since = "0.12.5")]
		public void set_timestamp_eol (uint64 timestamp);
		[Version (since = "0.6.5")]
		public void set_urgency (AppStream.UrgencyKind urgency);
		[Version (since = "0.12.5")]
		public void set_url (AppStream.ReleaseUrlKind url_kind, string url);
		public void set_version (string version);
		public int vercmp (AppStream.Release rel2);
	}
	[CCode (cheader_filename = "appstream.h", type_id = "as_review_get_type ()")]
	public class Review : GLib.Object {
		[CCode (has_construct_function = false)]
		[Version (since = "0.14.0")]
		public Review ();
		[Version (since = "0.14.0")]
		public void add_flags (AppStream.ReviewFlags flags);
		[Version (since = "0.14.0")]
		public void add_metadata (string key, string value);
		[Version (since = "0.14.0")]
		public bool equal (AppStream.Review review2);
		[Version (since = "0.14.0")]
		public unowned GLib.DateTime get_date ();
		[Version (since = "0.14.0")]
		public unowned string get_description ();
		[Version (since = "0.14.0")]
		public AppStream.ReviewFlags get_flags ();
		[Version (since = "0.14.0")]
		public unowned string get_id ();
		[Version (since = "0.14.0")]
		public unowned string get_locale ();
		[Version (since = "0.14.0")]
		public unowned string get_metadata_item (string key);
		[Version (since = "0.14.0")]
		public int get_priority ();
		[Version (since = "0.14.0")]
		public int get_rating ();
		[Version (since = "0.14.0")]
		public unowned string get_reviewer_id ();
		[Version (since = "0.14.0")]
		public unowned string get_reviewer_name ();
		[Version (since = "0.14.0")]
		public unowned string get_summary ();
		[Version (since = "0.14.0")]
		public unowned string get_version ();
		[Version (since = "0.14.0")]
		public void set_date (GLib.DateTime date);
		[Version (since = "0.14.0")]
		public void set_description (string description);
		[Version (since = "0.14.0")]
		public void set_flags (AppStream.ReviewFlags flags);
		[Version (since = "0.14.0")]
		public void set_id (string id);
		[Version (since = "0.14.0")]
		public void set_locale (string locale);
		[Version (since = "0.14.0")]
		public void set_priority (int priority);
		[Version (since = "0.14.0")]
		public void set_rating (int rating);
		[Version (since = "0.14.0")]
		public void set_reviewer_id (string reviewer_id);
		[Version (since = "0.14.0")]
		public void set_reviewer_name (string reviewer_name);
		[Version (since = "0.14.0")]
		public void set_summary (string summary);
		[Version (since = "0.14.0")]
		public void set_version (string version);
		[Version (since = "0.14.0")]
		public AppStream.Review date { get; set construct; }
		[Version (since = "0.14.0")]
		public string description { get; set construct; }
		[Version (since = "0.14.0")]
		public uint64 flags { get; set construct; }
		[Version (since = "0.14.0")]
		public string id { get; set construct; }
		[Version (since = "0.14.0")]
		public string locale { get; set construct; }
		[Version (since = "0.14.0")]
		public int rating { get; set construct; }
		[Version (since = "0.14.0")]
		public string reviewer_id { get; set construct; }
		[Version (since = "0.14.0")]
		public string reviewer_name { get; set construct; }
		[Version (since = "0.14.0")]
		public string summary { get; set construct; }
		[Version (since = "0.14.0")]
		public string version { get; set construct; }
	}
	[CCode (cheader_filename = "appstream.h", type_id = "as_screenshot_get_type ()")]
	public class Screenshot : GLib.Object {
		[CCode (has_construct_function = false)]
		public Screenshot ();
		public void add_image (AppStream.Image image);
		public void add_video (AppStream.Video video);
		public unowned string get_active_locale ();
		public unowned string get_caption ();
		[Version (since = "0.14.0")]
		public unowned AppStream.Image get_image (uint width, uint height);
		public unowned GLib.GenericArray<AppStream.Image> get_images ();
		[Version (since = "0.10")]
		public unowned GLib.GenericArray<AppStream.Image> get_images_all ();
		public AppStream.ScreenshotKind get_kind ();
		public AppStream.ScreenshotMediaKind get_media_kind ();
		public unowned GLib.GenericArray<AppStream.Video> get_videos ();
		public bool is_valid ();
		public void set_active_locale (string locale);
		public void set_caption (string caption, string locale);
		public void set_kind (AppStream.ScreenshotKind kind);
	}
	[CCode (cheader_filename = "appstream.h", type_id = "as_suggested_get_type ()")]
	public class Suggested : GLib.Object {
		[CCode (has_construct_function = false)]
		public Suggested ();
		public void add_id (string cid);
		public unowned GLib.GenericArray<string> get_ids ();
		public AppStream.SuggestedKind get_kind ();
		public bool is_valid ();
		public void set_kind (AppStream.SuggestedKind kind);
	}
	[CCode (cheader_filename = "appstream.h", type_id = "as_translation_get_type ()")]
	public class Translation : GLib.Object {
		[CCode (has_construct_function = false)]
		public Translation ();
		public unowned string get_id ();
		public AppStream.TranslationKind get_kind ();
		[Version (since = "0.14.6")]
		public unowned string get_source_locale ();
		public void set_id (string id);
		public void set_kind (AppStream.TranslationKind kind);
		[Version (since = "0.14.6")]
		public void set_source_locale (string? locale);
	}
	[CCode (cheader_filename = "appstream.h", type_id = "as_validator_get_type ()")]
	public class Validator : GLib.Object {
		[CCode (has_construct_function = false)]
		public Validator ();
		public void clear_issues ();
		public bool get_check_urls ();
		public GLib.List<weak AppStream.ValidatorIssue> get_issues ();
		[Version (since = "0.12.8")]
		public unowned GLib.HashTable<string,GLib.GenericArray<AppStream.ValidatorIssue>> get_issues_per_file ();
		public bool get_report_yaml (string yaml_report);
		public unowned string get_tag_explanation (string tag);
		public AppStream.IssueSeverity get_tag_severity (string tag);
		[CCode (array_length = false, array_null_terminated = true)]
		public string[] get_tags ();
		public void set_check_urls (bool value);
		[Version (since = "0.14.0")]
		public bool validate_bytes (GLib.Bytes metadata);
		public bool validate_data (string metadata);
		public bool validate_file (GLib.File metadata_file);
		public bool validate_tree (string root_dir);
	}
	[CCode (cheader_filename = "appstream.h", type_id = "as_validator_issue_get_type ()")]
	public class ValidatorIssue : GLib.Object {
		[CCode (has_construct_function = false)]
		public ValidatorIssue ();
		public unowned string get_cid ();
		[Version (since = "0.12.8")]
		public unowned string get_explanation ();
		public unowned string get_filename ();
		[Version (since = "0.12.8")]
		public unowned string get_hint ();
		public AppStream.IssueSeverity get_importance ();
		public long get_line ();
		public string get_location ();
		public unowned string get_message ();
		public AppStream.IssueSeverity get_severity ();
		[Version (since = "0.12.8")]
		public unowned string get_tag ();
		public void set_cid (string cid);
		[Version (since = "0.12.8")]
		public void set_explanation (string explanation);
		public void set_filename (string fname);
		[Version (since = "0.12.8")]
		public void set_hint (string hint);
		public void set_importance (AppStream.IssueSeverity importance);
		public void set_line (long line);
		public void set_message (string message);
		public void set_severity (AppStream.IssueSeverity severity);
		[Version (since = "0.12.8")]
		public void set_tag (string tag);
	}
	[CCode (cheader_filename = "appstream.h", type_id = "as_video_get_type ()")]
	public class Video : GLib.Object {
		[CCode (has_construct_function = false)]
		public Video ();
		public AppStream.VideoCodecKind get_codec_kind ();
		public AppStream.VideoContainerKind get_container_kind ();
		public uint get_height ();
		public unowned string get_locale ();
		public unowned string get_url ();
		public uint get_width ();
		public void set_codec_kind (AppStream.VideoCodecKind kind);
		public void set_container_kind (AppStream.VideoContainerKind kind);
		public void set_height (uint height);
		public void set_locale (string locale);
		public void set_url (string url);
		public void set_width (uint width);
	}
	[CCode (cheader_filename = "appstream.h", cprefix = "AS_AGREEMENT_KIND_", type_id = "as_agreement_kind_get_type ()")]
	public enum AgreementKind {
		UNKNOWN,
		GENERIC,
		EULA,
		PRIVACY;
		[Version (since = "0.12.1")]
		public static AppStream.AgreementKind from_string (string value);
		[Version (since = "0.12.1")]
		public unowned string to_string ();
	}
	[CCode (cheader_filename = "appstream.h", cprefix = "AS_ARTIFACT_KIND_", type_id = "as_artifact_kind_get_type ()")]
	public enum ArtifactKind {
		UNKNOWN,
		SOURCE,
		BINARY;
		public static AppStream.ArtifactKind from_string (string kind);
		public unowned string to_string ();
	}
	[CCode (cheader_filename = "appstream.h", cprefix = "AS_BUNDLE_KIND_", type_id = "as_bundle_kind_get_type ()")]
	public enum BundleKind {
		UNKNOWN,
		PACKAGE,
		LIMBA,
		FLATPAK,
		APPIMAGE,
		SNAP,
		TARBALL,
		CABINET;
		public static AppStream.BundleKind from_string (string bundle_str);
		[Version (since = "0.8.0")]
		public unowned string to_string ();
	}
	[CCode (cheader_filename = "appstream.h", cprefix = "AS_CACHE_FLAG_", type_id = "as_cache_flags_get_type ()")]
	[Flags]
	public enum CacheFlags {
		NONE,
		USE_USER,
		USE_SYSTEM,
		NO_CLEAR,
		REFRESH_SYSTEM
	}
	[CCode (cheader_filename = "appstream.h", cprefix = "AS_CHECKSUM_KIND_", type_id = "as_checksum_kind_get_type ()")]
	public enum ChecksumKind {
		NONE,
		SHA1,
		SHA256,
		BLAKE2B,
		BLAKE2S;
		public static AppStream.ChecksumKind from_string (string kind_str);
		public unowned string to_string ();
	}
	[CCode (cheader_filename = "appstream.h", cprefix = "AS_COMPONENT_KIND_", has_type_id = false)]
	public enum ComponentKind {
		[Version (deprecated = true, replacement = "INPUT_METHOD")]
		INPUTMETHOD,
		UNKNOWN,
		GENERIC,
		DESKTOP_APP,
		CONSOLE_APP,
		WEB_APP,
		ADDON,
		FONT,
		CODEC,
		INPUT_METHOD,
		FIRMWARE,
		DRIVER,
		LOCALIZATION,
		SERVICE,
		REPOSITORY,
		OPERATING_SYSTEM,
		ICON_THEME,
		RUNTIME;
		public static AppStream.ComponentKind from_string (string kind_str);
		public unowned string to_string ();
	}
	[CCode (cheader_filename = "appstream.h", cprefix = "AS_COMPONENT_SCOPE_", type_id = "as_component_scope_get_type ()")]
	public enum ComponentScope {
		UNKNOWN,
		SYSTEM,
		USER;
		public static AppStream.ComponentScope from_string (string scope_str);
		public unowned string to_string ();
	}
	[CCode (cheader_filename = "appstream.h", cprefix = "AS_CONTENT_RATING_SYSTEM_", type_id = "as_content_rating_system_get_type ()")]
	[Version (since = "0.12.12")]
	public enum ContentRatingSystem {
		UNKNOWN,
		INCAA,
		ACB,
		DJCTQ,
		GSRR,
		PEGI,
		KAVI,
		USK,
		ESRA,
		CERO,
		OFLCNZ,
		RUSSIA,
		MDA,
		GRAC,
		ESRB,
		IARC;
		public string? format_age (uint age);
		public static AppStream.ContentRatingSystem from_locale (string locale);
		[CCode (array_length_pos = 0.2, array_length_type = "gsize")]
		public uint[] get_csm_ages ();
		[CCode (array_length = false, array_null_terminated = true)]
		public string[] get_formatted_ages ();
		public unowned string? to_string ();
	}
	[CCode (cheader_filename = "appstream.h", cprefix = "AS_CONTENT_RATING_VALUE_", type_id = "as_content_rating_value_get_type ()")]
	public enum ContentRatingValue {
		UNKNOWN,
		NONE,
		MILD,
		MODERATE,
		INTENSE;
		[Version (since = "0.11.0")]
		public static AppStream.ContentRatingValue from_string (string value);
		[Version (since = "0.11.0")]
		public unowned string to_string ();
	}
	[CCode (cheader_filename = "appstream.h", cprefix = "AS_CONTROL_KIND_", type_id = "as_control_kind_get_type ()")]
	public enum ControlKind {
		UNKNOWN,
		POINTING,
		KEYBOARD,
		CONSOLE,
		TOUCH,
		GAMEPAD,
		VOICE,
		VISION,
		TV_REMOTE,
		TABLET;
		[Version (since = "0.12.11")]
		public static AppStream.ControlKind from_string (string kind_str);
		[Version (since = "0.12.11")]
		public unowned string to_string ();
	}
	[CCode (cheader_filename = "appstream.h", cprefix = "AS_DATA_ID_MATCH_FLAG_", type_id = "as_data_id_match_flags_get_type ()")]
	[Flags]
	public enum DataIdMatchFlags {
		NONE,
		SCOPE,
		BUNDLE_KIND,
		ORIGIN,
		ID,
		BRANCH
	}
	[CCode (cheader_filename = "appstream.h", cprefix = "AS_DISPLAY_LENGTH_KIND_", type_id = "as_display_length_kind_get_type ()")]
	public enum DisplayLengthKind {
		UNKNOWN,
		XSMALL,
		SMALL,
		MEDIUM,
		LARGE,
		XLARGE;
		[Version (since = "0.12.12")]
		public static AppStream.DisplayLengthKind from_string (string kind_str);
		[Version (since = "0.12.12")]
		public unowned string to_string ();
	}
	[CCode (cheader_filename = "appstream.h", cprefix = "AS_DISPLAY_SIDE_KIND_", type_id = "as_display_side_kind_get_type ()")]
	public enum DisplaySideKind {
		UNKNOWN,
		SHORTEST,
		LONGEST;
		[Version (since = "0.12.12")]
		public static AppStream.DisplaySideKind from_string (string kind_str);
		[Version (since = "0.12.12")]
		public unowned string to_string ();
	}
	[CCode (cheader_filename = "appstream.h", cprefix = "AS_FORMAT_KIND_", type_id = "as_format_kind_get_type ()")]
	public enum FormatKind {
		UNKNOWN,
		XML,
		YAML,
		DESKTOP_ENTRY;
		[Version (since = "0.10")]
		public static AppStream.FormatKind from_string (string kind_str);
		[Version (since = "0.10")]
		public unowned string to_string ();
	}
	[CCode (cheader_filename = "appstream.h", cprefix = "AS_FORMAT_STYLE_", type_id = "as_format_style_get_type ()")]
	public enum FormatStyle {
		UNKNOWN,
		METAINFO,
		COLLECTION
	}
	[CCode (cheader_filename = "appstream.h", cprefix = "AS_FORMAT_VERSION_", type_id = "as_format_version_get_type ()")]
	public enum FormatVersion {
		V0_6,
		V0_7,
		V0_8,
		V0_9,
		V0_10,
		V0_11,
		V0_12,
		V0_13,
		V0_14,
		UNKNOWN;
		[Version (since = "0.10")]
		public static AppStream.FormatVersion from_string (string version_str);
		[Version (since = "0.10")]
		public unowned string to_string ();
	}
	[CCode (cheader_filename = "appstream.h", cprefix = "AS_ICON_KIND_", type_id = "as_icon_kind_get_type ()")]
	public enum IconKind {
		UNKNOWN,
		CACHED,
		STOCK,
		LOCAL,
		REMOTE;
		public static AppStream.IconKind from_string (string kind_str);
		public unowned string to_string ();
	}
	[CCode (cheader_filename = "appstream.h", cprefix = "AS_IMAGE_KIND_", type_id = "as_image_kind_get_type ()")]
	public enum ImageKind {
		UNKNOWN,
		SOURCE,
		THUMBNAIL;
		public static AppStream.ImageKind from_string (string kind);
		public unowned string to_string ();
	}
	[CCode (cheader_filename = "appstream.h", cprefix = "AS_ISSUE_KIND_", type_id = "as_issue_kind_get_type ()")]
	public enum IssueKind {
		UNKNOWN,
		GENERIC,
		CVE;
		public static AppStream.IssueKind from_string (string kind_str);
		public unowned string to_string ();
	}
	[CCode (cheader_filename = "appstream.h", cprefix = "AS_ISSUE_SEVERITY_", type_id = "as_issue_severity_get_type ()")]
	public enum IssueSeverity {
		UNKNOWN,
		ERROR,
		WARNING,
		INFO,
		PEDANTIC;
		public static AppStream.IssueSeverity from_string (string str);
		public unowned string to_string ();
	}
	[CCode (cheader_filename = "appstream.h", cprefix = "AS_LAUNCHABLE_KIND_", type_id = "as_launchable_kind_get_type ()")]
	public enum LaunchableKind {
		UNKNOWN,
		DESKTOP_ID,
		SERVICE,
		COCKPIT_MANIFEST,
		URL;
		[Version (since = "0.11.0")]
		public static AppStream.LaunchableKind from_string (string kind_str);
		[Version (since = "0.11.0")]
		public unowned string to_string ();
	}
	[CCode (cheader_filename = "appstream.h", cprefix = "AS_MERGE_KIND_", type_id = "as_merge_kind_get_type ()")]
	public enum MergeKind {
		NONE,
		REPLACE,
		APPEND,
		REMOVE_COMPONENT;
		public static AppStream.MergeKind from_string (string kind_str);
		public unowned string to_string ();
	}
	[CCode (cheader_filename = "appstream.h", cprefix = "AS_METADATA_LOCATION_", type_id = "as_metadata_location_get_type ()")]
	public enum MetadataLocation {
		SHARED,
		STATE,
		CACHE,
		USER
	}
	[CCode (cheader_filename = "appstream.h", cprefix = "AS_PARSE_FLAG_", type_id = "as_parse_flags_get_type ()")]
	[Flags]
	public enum ParseFlags {
		NONE,
		IGNORE_MEDIABASEURL
	}
	[CCode (cheader_filename = "appstream.h", cprefix = "AS_POOL_FLAG_", has_type_id = false)]
	public enum PoolFlag {
		[Version (deprecated = true, replacement = "LOAD_OS_COLLECTION")]
		READ_COLLECTION,
		[Version (deprecated = true, replacement = "LOAD_OS_METAINFO")]
		READ_METAINFO,
		[Version (deprecated = true, replacement = "LOAD_OS_DESKTOP_FILES")]
		READ_DESKTOP_FILES
	}
	[CCode (cheader_filename = "appstream.h", cprefix = "AS_POOL_FLAG_", type_id = "as_pool_flags_get_type ()")]
	[Flags]
	public enum PoolFlags {
		NONE,
		LOAD_OS_COLLECTION,
		LOAD_OS_METAINFO,
		LOAD_OS_DESKTOP_FILES,
		LOAD_FLATPAK,
		IGNORE_CACHE_AGE,
		RESOLVE_ADDONS,
		PREFER_OS_METAINFO,
		MONITOR
	}
	[CCode (cheader_filename = "appstream.h", cprefix = "AS_PROVIDED_KIND_", has_type_id = false)]
	public enum ProvidedKind {
		[Version (deprecated = true, replacement = "MEDIATYPE")]
		MIMETYPE,
		UNKNOWN,
		LIBRARY,
		BINARY,
		MEDIATYPE,
		FONT,
		MODALIAS,
		PYTHON_2,
		PYTHON,
		DBUS_SYSTEM,
		DBUS_USER,
		FIRMWARE_RUNTIME,
		FIRMWARE_FLASHED,
		ID;
		public static AppStream.ProvidedKind from_string (string kind_str);
		public unowned string to_l10n_string ();
		public unowned string to_string ();
	}
	[CCode (cheader_filename = "appstream.h", cprefix = "AS_RELATION_COMPARE_", type_id = "as_relation_compare_get_type ()")]
	public enum RelationCompare {
		UNKNOWN,
		EQ,
		NE,
		LT,
		GT,
		LE,
		GE;
		[Version (since = "0.12.0")]
		public static AppStream.RelationCompare from_string (string compare_str);
		[Version (since = "0.12.0")]
		public unowned string to_string ();
		[Version (since = "0.12.0")]
		public unowned string to_symbols_string ();
	}
	[CCode (cheader_filename = "appstream.h", cprefix = "AS_RELATION_ITEM_KIND_", type_id = "as_relation_item_kind_get_type ()")]
	public enum RelationItemKind {
		UNKNOWN,
		ID,
		MODALIAS,
		KERNEL,
		MEMORY,
		FIRMWARE,
		CONTROL,
		DISPLAY_LENGTH,
		HARDWARE;
		[Version (since = "0.12.0")]
		public static AppStream.RelationItemKind from_string (string kind_str);
		[Version (since = "0.12.0")]
		public unowned string to_string ();
	}
	[CCode (cheader_filename = "appstream.h", cprefix = "AS_RELATION_KIND_", type_id = "as_relation_kind_get_type ()")]
	public enum RelationKind {
		UNKNOWN,
		REQUIRES,
		RECOMMENDS,
		SUPPORTS;
		[Version (since = "0.12.0")]
		public static AppStream.RelationKind from_string (string kind_str);
		[Version (since = "0.12.0")]
		public unowned string to_string ();
	}
	[CCode (cheader_filename = "appstream.h", cprefix = "AS_RELEASE_KIND_", type_id = "as_release_kind_get_type ()")]
	[Version (since = "0.12.0")]
	public enum ReleaseKind {
		UNKNOWN,
		STABLE,
		DEVELOPMENT;
		public static AppStream.ReleaseKind from_string (string kind_str);
		public unowned string to_string ();
	}
	[CCode (cheader_filename = "appstream.h", cprefix = "AS_RELEASE_URL_KIND_", type_id = "as_release_url_kind_get_type ()")]
	[Version (since = "0.12.5")]
	public enum ReleaseUrlKind {
		UNKNOWN,
		DETAILS;
		public static AppStream.ReleaseUrlKind from_string (string kind_str);
		public unowned string to_string ();
	}
	[CCode (cheader_filename = "appstream.h", cprefix = "AS_REVIEW_FLAG_", type_id = "as_review_flags_get_type ()")]
	[Flags]
	[Version (since = "0.14.0")]
	public enum ReviewFlags {
		NONE,
		SELF,
		VOTED
	}
	[CCode (cheader_filename = "appstream.h", cprefix = "AS_SCREENSHOT_KIND_", type_id = "as_screenshot_kind_get_type ()")]
	public enum ScreenshotKind {
		UNKNOWN,
		DEFAULT,
		EXTRA;
		public static AppStream.ScreenshotKind from_string (string kind);
		public unowned string to_string ();
	}
	[CCode (cheader_filename = "appstream.h", cprefix = "AS_SCREENSHOT_MEDIA_KIND_", type_id = "as_screenshot_media_kind_get_type ()")]
	public enum ScreenshotMediaKind {
		UNKNOWN,
		IMAGE,
		VIDEO
	}
	[CCode (cheader_filename = "appstream.h", cprefix = "AS_SEARCH_TOKEN_MATCH_", has_type_id = false)]
	[Flags]
	public enum SearchTokenMatch {
		NONE,
		MEDIATYPE,
		PKGNAME,
		ORIGIN,
		DESCRIPTION,
		SUMMARY,
		KEYWORD,
		NAME,
		ID
	}
	[CCode (cheader_filename = "appstream.h", cprefix = "AS_SIZE_KIND_", type_id = "as_size_kind_get_type ()")]
	[Version (since = "0.8.6")]
	public enum SizeKind {
		UNKNOWN,
		DOWNLOAD,
		INSTALLED;
		public static AppStream.SizeKind from_string (string size_kind);
		public unowned string to_string ();
	}
	[CCode (cheader_filename = "appstream.h", cprefix = "AS_SUGGESTED_KIND_", type_id = "as_suggested_kind_get_type ()")]
	public enum SuggestedKind {
		UNKNOWN,
		UPSTREAM,
		HEURISTIC;
		public static AppStream.SuggestedKind from_string (string kind_str);
		public unowned string to_string ();
	}
	[CCode (cheader_filename = "appstream.h", cprefix = "AS_TRANSLATION_KIND_", type_id = "as_translation_kind_get_type ()")]
	public enum TranslationKind {
		UNKNOWN,
		GETTEXT,
		QT;
		public static AppStream.TranslationKind from_string (string kind_str);
		public unowned string to_string ();
	}
	[CCode (cheader_filename = "appstream.h", cprefix = "AS_URGENCY_KIND_", type_id = "as_urgency_kind_get_type ()")]
	public enum UrgencyKind {
		UNKNOWN,
		LOW,
		MEDIUM,
		HIGH,
		CRITICAL;
		[Version (since = "0.6.5")]
		public static AppStream.UrgencyKind from_string (string urgency_kind);
		[Version (since = "0.6.5")]
		public unowned string to_string ();
	}
	[CCode (cheader_filename = "appstream.h", cprefix = "AS_URL_KIND_", type_id = "as_url_kind_get_type ()")]
	public enum UrlKind {
		UNKNOWN,
		HOMEPAGE,
		BUGTRACKER,
		FAQ,
		HELP,
		DONATION,
		TRANSLATE,
		CONTACT;
		public static AppStream.UrlKind from_string (string url_kind);
		public unowned string to_string ();
	}
	[CCode (cheader_filename = "appstream.h", cprefix = "AS_VALUE_FLAG_", type_id = "as_value_flags_get_type ()")]
	[Flags]
	public enum ValueFlags {
		NONE,
		DUPLICATE_CHECK,
		NO_TRANSLATION_FALLBACK
	}
	[CCode (cheader_filename = "appstream.h", cprefix = "AS_VERCMP_FLAG_", type_id = "as_vercmp_flags_get_type ()")]
	[Flags]
	public enum VercmpFlags {
		NONE,
		IGNORE_EPOCH
	}
	[CCode (cheader_filename = "appstream.h", cprefix = "AS_VIDEO_CODEC_KIND_", type_id = "as_video_codec_kind_get_type ()")]
	public enum VideoCodecKind {
		UNKNOWN,
		VP9,
		AV1;
		public static AppStream.VideoCodecKind from_string (string str);
		public unowned string to_string ();
	}
	[CCode (cheader_filename = "appstream.h", cprefix = "AS_VIDEO_CONTAINER_KIND_", type_id = "as_video_container_kind_get_type ()")]
	public enum VideoContainerKind {
		UNKNOWN,
		MKV,
		WEBM;
		public static AppStream.VideoContainerKind from_string (string str);
		public unowned string to_string ();
	}
	[CCode (cheader_filename = "appstream.h", cprefix = "AS_METADATA_ERROR_")]
	public errordomain MetadataError {
		FAILED,
		PARSE,
		FORMAT_UNEXPECTED,
		NO_COMPONENT,
		VALUE_MISSING;
		public static GLib.Quark quark ();
	}
	[CCode (cheader_filename = "appstream.h", cprefix = "AS_POOL_ERROR_")]
	public errordomain PoolError {
		FAILED,
		TARGET_NOT_WRITABLE,
		INCOMPLETE,
		COLLISION,
		OLD_CACHE;
		public static GLib.Quark quark ();
	}
	[CCode (cheader_filename = "appstream.h", cprefix = "AS_UTILS_ERROR_")]
	public errordomain UtilsError {
		FAILED;
		[Version (since = "0.14.0")]
		public static GLib.Quark quark ();
	}
	[CCode (cheader_filename = "appstream.h", cname = "AS_IMAGE_LARGE_HEIGHT")]
	public const int IMAGE_LARGE_HEIGHT;
	[CCode (cheader_filename = "appstream.h", cname = "AS_IMAGE_LARGE_WIDTH")]
	public const int IMAGE_LARGE_WIDTH;
	[CCode (cheader_filename = "appstream.h", cname = "AS_IMAGE_NORMAL_HEIGHT")]
	public const int IMAGE_NORMAL_HEIGHT;
	[CCode (cheader_filename = "appstream.h", cname = "AS_IMAGE_NORMAL_WIDTH")]
	public const int IMAGE_NORMAL_WIDTH;
	[CCode (cheader_filename = "appstream.h", cname = "AS_IMAGE_THUMBNAIL_HEIGHT")]
	public const int IMAGE_THUMBNAIL_HEIGHT;
	[CCode (cheader_filename = "appstream.h", cname = "AS_IMAGE_THUMBNAIL_WIDTH")]
	public const int IMAGE_THUMBNAIL_WIDTH;
	[CCode (cheader_filename = "appstream.h", cname = "AS_MAJOR_VERSION")]
	public const int MAJOR_VERSION;
	[CCode (cheader_filename = "appstream.h", cname = "AS_MICRO_VERSION")]
	public const int MICRO_VERSION;
	[CCode (cheader_filename = "appstream.h", cname = "AS_MINOR_VERSION")]
	public const int MINOR_VERSION;
	[CCode (cheader_filename = "appstream.h")]
	[Version (replacement = "AgreementKind.from_string", since = "0.12.1")]
	public static AppStream.AgreementKind agreement_kind_from_string (string value);
	[CCode (cheader_filename = "appstream.h")]
	[Version (replacement = "AgreementKind.to_string", since = "0.12.1")]
	public static unowned string agreement_kind_to_string (AppStream.AgreementKind value);
	[CCode (cheader_filename = "appstream.h")]
	[Version (replacement = "ArtifactKind.from_string")]
	public static AppStream.ArtifactKind artifact_kind_from_string (string kind);
	[CCode (cheader_filename = "appstream.h")]
	[Version (replacement = "ArtifactKind.to_string")]
	public static unowned string artifact_kind_to_string (AppStream.ArtifactKind kind);
	[CCode (cheader_filename = "appstream.h")]
	[Version (replacement = "BundleKind.from_string")]
	public static AppStream.BundleKind bundle_kind_from_string (string bundle_str);
	[CCode (cheader_filename = "appstream.h")]
	[Version (replacement = "BundleKind.to_string", since = "0.8.0")]
	public static unowned string bundle_kind_to_string (AppStream.BundleKind kind);
	[CCode (cheader_filename = "appstream.h")]
	[Version (replacement = "ChecksumKind.from_string")]
	public static AppStream.ChecksumKind checksum_kind_from_string (string kind_str);
	[CCode (cheader_filename = "appstream.h")]
	[Version (replacement = "ChecksumKind.to_string")]
	public static unowned string checksum_kind_to_string (AppStream.ChecksumKind kind);
	[CCode (cheader_filename = "appstream.h")]
	[Version (replacement = "ComponentKind.from_string")]
	public static AppStream.ComponentKind component_kind_from_string (string kind_str);
	[CCode (cheader_filename = "appstream.h")]
	[Version (replacement = "ComponentKind.to_string")]
	public static unowned string component_kind_to_string (AppStream.ComponentKind kind);
	[CCode (cheader_filename = "appstream.h")]
	[Version (replacement = "ComponentScope.from_string")]
	public static AppStream.ComponentScope component_scope_from_string (string scope_str);
	[CCode (cheader_filename = "appstream.h")]
	[Version (replacement = "ComponentScope.to_string")]
	public static unowned string component_scope_to_string (AppStream.ComponentScope scope);
	[CCode (cheader_filename = "appstream.h")]
	[Version (replacement = "ContentRatingSystem.format_age", since = "0.12.12")]
	public static string? content_rating_system_format_age (AppStream.ContentRatingSystem system, uint age);
	[CCode (cheader_filename = "appstream.h")]
	[Version (replacement = "ContentRatingSystem.from_locale", since = "0.12.12")]
	public static AppStream.ContentRatingSystem content_rating_system_from_locale (string locale);
	[CCode (array_length_pos = 1.1, array_length_type = "gsize", cheader_filename = "appstream.h")]
	[Version (replacement = "ContentRatingSystem.get_csm_ages", since = "0.12.12")]
	public static uint[] content_rating_system_get_csm_ages (AppStream.ContentRatingSystem system);
	[CCode (array_length = false, array_null_terminated = true, cheader_filename = "appstream.h")]
	[Version (replacement = "ContentRatingSystem.get_formatted_ages", since = "0.12.12")]
	public static string[] content_rating_system_get_formatted_ages (AppStream.ContentRatingSystem system);
	[CCode (cheader_filename = "appstream.h")]
	[Version (replacement = "ContentRatingSystem.to_string", since = "0.12.12")]
	public static unowned string? content_rating_system_to_string (AppStream.ContentRatingSystem system);
	[CCode (cheader_filename = "appstream.h")]
	[Version (replacement = "ContentRatingValue.from_string", since = "0.11.0")]
	public static AppStream.ContentRatingValue content_rating_value_from_string (string value);
	[CCode (cheader_filename = "appstream.h")]
	[Version (replacement = "ContentRatingValue.to_string", since = "0.11.0")]
	public static unowned string content_rating_value_to_string (AppStream.ContentRatingValue value);
	[CCode (cheader_filename = "appstream.h")]
	[Version (replacement = "ControlKind.from_string", since = "0.12.11")]
	public static AppStream.ControlKind control_kind_from_string (string kind_str);
	[CCode (cheader_filename = "appstream.h")]
	[Version (replacement = "ControlKind.to_string", since = "0.12.11")]
	public static unowned string control_kind_to_string (AppStream.ControlKind kind);
	[CCode (cheader_filename = "appstream.h")]
	[Version (replacement = "DisplayLengthKind.from_string", since = "0.12.12")]
	public static AppStream.DisplayLengthKind display_length_kind_from_string (string kind_str);
	[CCode (cheader_filename = "appstream.h")]
	[Version (replacement = "DisplayLengthKind.to_string", since = "0.12.12")]
	public static unowned string display_length_kind_to_string (AppStream.DisplayLengthKind kind);
	[CCode (cheader_filename = "appstream.h")]
	[Version (replacement = "DisplaySideKind.from_string", since = "0.12.12")]
	public static AppStream.DisplaySideKind display_side_kind_from_string (string kind_str);
	[CCode (cheader_filename = "appstream.h")]
	[Version (replacement = "DisplaySideKind.to_string", since = "0.12.12")]
	public static unowned string display_side_kind_to_string (AppStream.DisplaySideKind kind);
	[CCode (cheader_filename = "appstream.h")]
	[Version (replacement = "FormatKind.from_string", since = "0.10")]
	public static AppStream.FormatKind format_kind_from_string (string kind_str);
	[CCode (cheader_filename = "appstream.h")]
	[Version (replacement = "FormatKind.to_string", since = "0.10")]
	public static unowned string format_kind_to_string (AppStream.FormatKind kind);
	[CCode (cheader_filename = "appstream.h")]
	[Version (replacement = "FormatVersion.from_string", since = "0.10")]
	public static AppStream.FormatVersion format_version_from_string (string version_str);
	[CCode (cheader_filename = "appstream.h")]
	[Version (replacement = "FormatVersion.to_string", since = "0.10")]
	public static unowned string format_version_to_string (AppStream.FormatVersion version);
	[CCode (cheader_filename = "appstream.h")]
	public static unowned string get_appstream_version ();
	[CCode (cheader_filename = "appstream.h")]
	public static string get_current_distro_component_id ();
	[CCode (cheader_filename = "appstream.h")]
	public static GLib.GenericArray<AppStream.Category> get_default_categories (bool with_special);
	[CCode (cheader_filename = "appstream.h")]
	[Version (since = "0.12.7")]
	public static string get_license_url (string license);
	[CCode (cheader_filename = "appstream.h")]
	public static uint gstring_replace (GLib.StringBuilder string, string find, string replace);
	[CCode (cheader_filename = "appstream.h")]
	public static uint gstring_replace2 (GLib.StringBuilder string, string find, string replace, uint limit);
	[CCode (cheader_filename = "appstream.h")]
	[Version (replacement = "IconKind.from_string")]
	public static AppStream.IconKind icon_kind_from_string (string kind_str);
	[CCode (cheader_filename = "appstream.h")]
	[Version (replacement = "IconKind.to_string")]
	public static unowned string icon_kind_to_string (AppStream.IconKind kind);
	[CCode (cheader_filename = "appstream.h")]
	[Version (replacement = "ImageKind.from_string")]
	public static AppStream.ImageKind image_kind_from_string (string kind);
	[CCode (cheader_filename = "appstream.h")]
	[Version (replacement = "ImageKind.to_string")]
	public static unowned string image_kind_to_string (AppStream.ImageKind kind);
	[CCode (cheader_filename = "appstream.h")]
	[Version (since = "0.12.10")]
	public static bool is_spdx_license_exception_id (string exception_id);
	[CCode (cheader_filename = "appstream.h")]
	[Version (since = "0.9.8")]
	public static bool is_spdx_license_expression (string license);
	[CCode (cheader_filename = "appstream.h")]
	[Version (since = "0.9.8")]
	public static bool is_spdx_license_id (string license_id);
	[CCode (cheader_filename = "appstream.h")]
	[Version (replacement = "IssueKind.from_string")]
	public static AppStream.IssueKind issue_kind_from_string (string kind_str);
	[CCode (cheader_filename = "appstream.h")]
	[Version (replacement = "IssueKind.to_string")]
	public static unowned string issue_kind_to_string (AppStream.IssueKind kind);
	[CCode (cheader_filename = "appstream.h")]
	[Version (replacement = "IssueSeverity.from_string")]
	public static AppStream.IssueSeverity issue_severity_from_string (string str);
	[CCode (cheader_filename = "appstream.h")]
	[Version (replacement = "IssueSeverity.to_string")]
	public static unowned string issue_severity_to_string (AppStream.IssueSeverity severity);
	[CCode (cheader_filename = "appstream.h")]
	[Version (replacement = "LaunchableKind.from_string", since = "0.11.0")]
	public static AppStream.LaunchableKind launchable_kind_from_string (string kind_str);
	[CCode (cheader_filename = "appstream.h")]
	[Version (replacement = "LaunchableKind.to_string", since = "0.11.0")]
	public static unowned string launchable_kind_to_string (AppStream.LaunchableKind kind);
	[CCode (cheader_filename = "appstream.h")]
	[Version (since = "0.12.10")]
	public static bool license_is_free_license (string license);
	[CCode (cheader_filename = "appstream.h")]
	public static bool license_is_metadata_license (string license);
	[CCode (cheader_filename = "appstream.h")]
	public static bool license_is_metadata_license_id (string license_id);
	[CCode (cheader_filename = "appstream.h")]
	[Version (since = "0.9.8")]
	public static string license_to_spdx_id (string license);
	[CCode (cheader_filename = "appstream.h")]
	public static string markup_convert_simple (string markup) throws GLib.Error;
	[CCode (array_length = false, array_null_terminated = true, cheader_filename = "appstream.h")]
	[Version (since = "0.14.0")]
	public static string[] markup_strsplit_words (string text, uint line_len);
	[CCode (cheader_filename = "appstream.h")]
	[Version (replacement = "MergeKind.from_string")]
	public static AppStream.MergeKind merge_kind_from_string (string kind_str);
	[CCode (cheader_filename = "appstream.h")]
	[Version (replacement = "MergeKind.to_string")]
	public static unowned string merge_kind_to_string (AppStream.MergeKind kind);
	[CCode (cheader_filename = "appstream.h")]
	[Version (replacement = "MetadataError.quark")]
	public static GLib.Quark metadata_error_quark ();
	[CCode (cheader_filename = "appstream.h")]
	[Version (replacement = "PoolError.quark")]
	public static GLib.Quark pool_error_quark ();
	[CCode (cheader_filename = "appstream.h")]
	[Version (replacement = "ProvidedKind.from_string")]
	public static AppStream.ProvidedKind provided_kind_from_string (string kind_str);
	[CCode (cheader_filename = "appstream.h")]
	[Version (replacement = "ProvidedKind.to_l10n_string")]
	public static unowned string provided_kind_to_l10n_string (AppStream.ProvidedKind kind);
	[CCode (cheader_filename = "appstream.h")]
	[Version (replacement = "ProvidedKind.to_string")]
	public static unowned string provided_kind_to_string (AppStream.ProvidedKind kind);
	[CCode (cheader_filename = "appstream.h")]
	[Version (replacement = "RelationCompare.from_string", since = "0.12.0")]
	public static AppStream.RelationCompare relation_compare_from_string (string compare_str);
	[CCode (cheader_filename = "appstream.h")]
	[Version (replacement = "RelationCompare.to_string", since = "0.12.0")]
	public static unowned string relation_compare_to_string (AppStream.RelationCompare compare);
	[CCode (cheader_filename = "appstream.h")]
	[Version (replacement = "RelationCompare.to_symbols_string", since = "0.12.0")]
	public static unowned string relation_compare_to_symbols_string (AppStream.RelationCompare compare);
	[CCode (cheader_filename = "appstream.h")]
	[Version (replacement = "RelationItemKind.from_string", since = "0.12.0")]
	public static AppStream.RelationItemKind relation_item_kind_from_string (string kind_str);
	[CCode (cheader_filename = "appstream.h")]
	[Version (replacement = "RelationItemKind.to_string", since = "0.12.0")]
	public static unowned string relation_item_kind_to_string (AppStream.RelationItemKind kind);
	[CCode (cheader_filename = "appstream.h")]
	[Version (replacement = "RelationKind.from_string", since = "0.12.0")]
	public static AppStream.RelationKind relation_kind_from_string (string kind_str);
	[CCode (cheader_filename = "appstream.h")]
	[Version (replacement = "RelationKind.to_string", since = "0.12.0")]
	public static unowned string relation_kind_to_string (AppStream.RelationKind kind);
	[CCode (cheader_filename = "appstream.h")]
	[Version (replacement = "ReleaseKind.from_string", since = "0.12.0")]
	public static AppStream.ReleaseKind release_kind_from_string (string kind_str);
	[CCode (cheader_filename = "appstream.h")]
	[Version (replacement = "ReleaseKind.to_string", since = "0.12.0")]
	public static unowned string release_kind_to_string (AppStream.ReleaseKind kind);
	[CCode (cheader_filename = "appstream.h")]
	[Version (replacement = "ReleaseUrlKind.from_string", since = "0.12.5")]
	public static AppStream.ReleaseUrlKind release_url_kind_from_string (string kind_str);
	[CCode (cheader_filename = "appstream.h")]
	[Version (replacement = "ReleaseUrlKind.to_string", since = "0.12.5")]
	public static unowned string release_url_kind_to_string (AppStream.ReleaseUrlKind kind);
	[CCode (cheader_filename = "appstream.h")]
	[Version (replacement = "ScreenshotKind.from_string")]
	public static AppStream.ScreenshotKind screenshot_kind_from_string (string kind);
	[CCode (cheader_filename = "appstream.h")]
	[Version (replacement = "ScreenshotKind.to_string")]
	public static unowned string screenshot_kind_to_string (AppStream.ScreenshotKind kind);
	[CCode (cheader_filename = "appstream.h")]
	[Version (replacement = "SizeKind.from_string")]
	public static AppStream.SizeKind size_kind_from_string (string size_kind);
	[CCode (cheader_filename = "appstream.h")]
	[Version (replacement = "SizeKind.to_string")]
	public static unowned string size_kind_to_string (AppStream.SizeKind size_kind);
	[CCode (cheader_filename = "appstream.h")]
	[Version (since = "0.9.8")]
	public static string? spdx_license_detokenize (string license_tokens);
	[CCode (array_length = false, array_null_terminated = true, cheader_filename = "appstream.h")]
	[Version (since = "0.9.8")]
	public static string[]? spdx_license_tokenize (string license);
	[CCode (cheader_filename = "appstream.h")]
	[Version (replacement = "SuggestedKind.from_string")]
	public static AppStream.SuggestedKind suggested_kind_from_string (string kind_str);
	[CCode (cheader_filename = "appstream.h")]
	[Version (replacement = "SuggestedKind.to_string")]
	public static unowned string suggested_kind_to_string (AppStream.SuggestedKind kind);
	[CCode (cheader_filename = "appstream.h")]
	[Version (replacement = "TranslationKind.from_string")]
	public static AppStream.TranslationKind translation_kind_from_string (string kind_str);
	[CCode (cheader_filename = "appstream.h")]
	[Version (replacement = "TranslationKind.to_string")]
	public static unowned string translation_kind_to_string (AppStream.TranslationKind kind);
	[CCode (cheader_filename = "appstream.h")]
	[Version (replacement = "UrgencyKind.from_string", since = "0.6.5")]
	public static AppStream.UrgencyKind urgency_kind_from_string (string urgency_kind);
	[CCode (cheader_filename = "appstream.h")]
	[Version (replacement = "UrgencyKind.to_string", since = "0.6.5")]
	public static unowned string urgency_kind_to_string (AppStream.UrgencyKind urgency_kind);
	[CCode (cheader_filename = "appstream.h")]
	[Version (replacement = "UrlKind.from_string")]
	public static AppStream.UrlKind url_kind_from_string (string url_kind);
	[CCode (cheader_filename = "appstream.h")]
	[Version (replacement = "UrlKind.to_string")]
	public static unowned string url_kind_to_string (AppStream.UrlKind url_kind);
	[CCode (cheader_filename = "appstream.h")]
	[Version (since = "0.14.0")]
	public static string utils_build_data_id (AppStream.ComponentScope scope, AppStream.BundleKind bundle_kind, string origin, string cid, string branch);
	[CCode (cheader_filename = "appstream.h")]
	public static int utils_compare_versions (string a, string b);
	[CCode (cheader_filename = "appstream.h")]
	[Version (since = "0.14.0")]
	public static bool utils_data_id_equal (string data_id1, string data_id2);
	[CCode (cheader_filename = "appstream.h")]
	public static string utils_data_id_get_cid (string data_id);
	[CCode (cheader_filename = "appstream.h")]
	[Version (since = "0.14.0")]
	public static uint utils_data_id_hash (string data_id);
	[CCode (cheader_filename = "appstream.h")]
	[Version (since = "0.14.0")]
	public static bool utils_data_id_match (string data_id1, string data_id2, AppStream.DataIdMatchFlags match_flags);
	[CCode (cheader_filename = "appstream.h")]
	[Version (since = "0.14.0")]
	public static bool utils_data_id_valid (string data_id);
	[CCode (cheader_filename = "appstream.h")]
	[Version (replacement = "UtilsError.quark", since = "0.14.0")]
	public static GLib.Quark utils_error_quark ();
	[CCode (cheader_filename = "appstream.h")]
	[Version (since = "0.14.8")]
	public static AppStream.ComponentScope utils_guess_scope_from_path (string path);
	[CCode (cheader_filename = "appstream.h")]
	[Version (since = "0.14.0")]
	public static bool utils_install_metadata_file (AppStream.MetadataLocation location, string filename, string origin, string destdir) throws GLib.Error;
	[CCode (cheader_filename = "appstream.h")]
	public static bool utils_is_category_name (string category_name);
	[CCode (cheader_filename = "appstream.h")]
	[Version (since = "0.10.0")]
	public static bool utils_is_desktop_environment (string desktop);
	[CCode (cheader_filename = "appstream.h")]
	[Version (since = "0.14.0")]
	public static bool utils_is_platform_triplet (string triplet);
	[CCode (cheader_filename = "appstream.h")]
	[Version (since = "0.9.8")]
	public static bool utils_is_tld (string tld);
	[CCode (cheader_filename = "appstream.h")]
	[Version (since = "0.9.5")]
	public static bool utils_locale_is_compatible (string locale1, string locale2);
	[CCode (cheader_filename = "appstream.h")]
	public static void utils_sort_components_into_categories (GLib.GenericArray<AppStream.Component> cpts, GLib.GenericArray<AppStream.Category> categories, bool check_duplicates);
	[CCode (cheader_filename = "appstream.h")]
	public static int vercmp (string a, string b, AppStream.VercmpFlags flags);
	[CCode (cheader_filename = "appstream.h")]
	public static int vercmp_simple (string a, string b);
	[CCode (cheader_filename = "appstream.h")]
	[Version (since = "0.14.0")]
	public static unowned string version_string ();
	[CCode (cheader_filename = "appstream.h")]
	[Version (replacement = "VideoCodecKind.from_string")]
	public static AppStream.VideoCodecKind video_codec_kind_from_string (string str);
	[CCode (cheader_filename = "appstream.h")]
	[Version (replacement = "VideoCodecKind.to_string")]
	public static unowned string video_codec_kind_to_string (AppStream.VideoCodecKind kind);
	[CCode (cheader_filename = "appstream.h")]
	[Version (replacement = "VideoContainerKind.from_string")]
	public static AppStream.VideoContainerKind video_container_kind_from_string (string str);
	[CCode (cheader_filename = "appstream.h")]
	[Version (replacement = "VideoContainerKind.to_string")]
	public static unowned string video_container_kind_to_string (AppStream.VideoContainerKind kind);
}
