/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.lib.profiler.snaptracer.impl.timeline;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.LinearGradientPaint;
import java.awt.Rectangle;
import org.graalvm.visualvm.lib.charts.ChartContext;
import org.graalvm.visualvm.lib.charts.ChartDecorator;
import org.graalvm.visualvm.lib.charts.swing.Utils;
import org.graalvm.visualvm.lib.profiler.snaptracer.impl.timeline.TimelineChart;
import org.graalvm.visualvm.lib.ui.UIUtils;

final class RowForegroundDecorator
implements ChartDecorator {
    private static final Color SELECTED_FILTER;
    private static final float[] FRACTIONS;
    private static final Color[] COLORS;
    private final TimelineChart chart;
    private final boolean gradient;
    private final boolean selection;

    RowForegroundDecorator(TimelineChart chart, boolean gradient, boolean selection) {
        this.chart = chart;
        this.gradient = gradient;
        this.selection = selection;
    }

    public void paint(Graphics2D g, Rectangle dirtyArea, ChartContext context) {
        if (this.gradient || this.selection) {
            int rowsCount = this.chart.getRowsCount();
            for (int i = 0; i < rowsCount; ++i) {
                TimelineChart.Row row = this.chart.getRow(i);
                ChartContext rowContext = row.getContext();
                int y = Utils.checkedInt((double)rowContext.getViewportOffsetY());
                int h = Utils.checkedInt((double)(rowContext.getViewportHeight() - 1));
                if (this.gradient) {
                    g.setPaint(new LinearGradientPaint(0.0f, y, 0.0f, y + h, FRACTIONS, COLORS));
                    g.fillRect(0, y, this.chart.getWidth(), h);
                }
                if (!this.selection || !this.chart.isRowSelected(row)) continue;
                g.setColor(SELECTED_FILTER);
                g.fillRect(0, y, this.chart.getWidth(), h);
            }
        }
    }

    static {
        Color[] colorArray;
        SELECTED_FILTER = new Color(0, 0, 200, 25);
        FRACTIONS = new float[]{0.0f, 0.49f, 0.51f, 1.0f};
        if (!UIUtils.isDarkResultsBackground()) {
            Color[] colorArray2 = new Color[4];
            colorArray2[0] = new Color(250, 251, 252, 120);
            colorArray2[1] = new Color(237, 240, 242, 120);
            colorArray2[2] = new Color(229, 233, 236, 125);
            colorArray = colorArray2;
            colorArray2[3] = new Color(215, 221, 226, 130);
        } else {
            Color[] colorArray3 = new Color[4];
            colorArray3[0] = new Color(40, 41, 42, 110);
            colorArray3[1] = new Color(31, 32, 34, 110);
            colorArray3[2] = new Color(29, 27, 30, 115);
            colorArray = colorArray3;
            colorArray3[3] = new Color(13, 17, 22, 120);
        }
        COLORS = colorArray;
    }
}

