/*
 * Decompiled with CFR 0.152.
 */
package sun.security.krb5.internal;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import sun.misc.IOUtils;
import sun.security.krb5.internal.Krb5;
import sun.security.krb5.internal.NetClient;

class TCPClient
extends NetClient {
    private Socket tcpSocket = new Socket();
    private BufferedOutputStream out;
    private BufferedInputStream in;

    TCPClient(String hostname, int port, int timeout) throws IOException {
        this.tcpSocket.connect(new InetSocketAddress(hostname, port), timeout);
        this.out = new BufferedOutputStream(this.tcpSocket.getOutputStream());
        this.in = new BufferedInputStream(this.tcpSocket.getInputStream());
        this.tcpSocket.setSoTimeout(timeout);
    }

    @Override
    public void send(byte[] data) throws IOException {
        byte[] lenField = new byte[4];
        TCPClient.intToNetworkByteOrder(data.length, lenField, 0, 4);
        this.out.write(lenField);
        this.out.write(data);
        this.out.flush();
    }

    @Override
    public byte[] receive() throws IOException {
        byte[] lenField = new byte[4];
        int count = this.readFully(lenField, 4);
        if (count != 4) {
            if (Krb5.DEBUG) {
                System.out.println(">>>DEBUG: TCPClient could not read length field");
            }
            return null;
        }
        int len = TCPClient.networkByteOrderToInt(lenField, 0, 4);
        if (Krb5.DEBUG) {
            System.out.println(">>>DEBUG: TCPClient reading " + len + " bytes");
        }
        if (len <= 0) {
            if (Krb5.DEBUG) {
                System.out.println(">>>DEBUG: TCPClient zero or negative length field: " + len);
            }
            return null;
        }
        try {
            return IOUtils.readExactlyNBytes(this.in, len);
        }
        catch (IOException ioe) {
            if (Krb5.DEBUG) {
                System.out.println(">>>DEBUG: TCPClient could not read complete packet (" + len + "/" + count + ")");
            }
            return null;
        }
    }

    @Override
    public void close() throws IOException {
        this.tcpSocket.close();
    }

    private int readFully(byte[] inBuf, int total) throws IOException {
        int pos = 0;
        while (total > 0) {
            int count = this.in.read(inBuf, pos, total);
            if (count == -1) {
                return pos == 0 ? -1 : pos;
            }
            pos += count;
            total -= count;
        }
        return pos;
    }

    private static int networkByteOrderToInt(byte[] buf, int start, int count) {
        if (count > 4) {
            throw new IllegalArgumentException("Cannot handle more than 4 bytes");
        }
        int answer = 0;
        for (int i = 0; i < count; ++i) {
            answer <<= 8;
            answer |= buf[start + i] & 0xFF;
        }
        return answer;
    }

    private static void intToNetworkByteOrder(int num, byte[] buf, int start, int count) {
        if (count > 4) {
            throw new IllegalArgumentException("Cannot handle more than 4 bytes");
        }
        for (int i = count - 1; i >= 0; --i) {
            buf[start + i] = (byte)(num & 0xFF);
            num >>>= 8;
        }
    }
}

