/*
 * Copyright (c) 2012, 2021, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (C) 1991-2016 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in 
 * http://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that
 * (a) this copyright and permission notice appear with all copies 
 * of the Data Files or Software,
 * (b) this copyright and permission notice appear in associated 
 * documentation, and
 * (c) there is clear notice in each modified Data File or in the Software
 * as well as in the documentation associated with the Data File(s) or
 * Software that the data or software has been modified.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.TimeZoneNamesBundle;

public class TimeZoneNames_gd extends TimeZoneNamesBundle {
    @Override
    protected final Object[][] getContents() {
        final String[] Moscow = new String[] {
               "Bun-\u00e0m Mhosgo",
               "",
               "T\u00ecde samhraidh Mhosgo",
               "",
               "\u00c0m Mhosgo",
               "",
            };
        final String[] Pakistan = new String[] {
               "Bun-\u00e0m Pagast\u00e0in",
               "",
               "T\u00ecde samhraidh Pagast\u00e0in",
               "",
               "\u00c0m Pagast\u00e0in",
               "",
            };
        final String[] Magadan = new String[] {
               "Bun-\u00e0m Magadan",
               "",
               "T\u00ecde Samhraidh Magadan",
               "",
               "\u00c0m Magadan",
               "",
            };
        final String[] Europe_Central = new String[] {
               "Bun-\u00e0m Meadhan na Roinn-E\u00f2rpa",
               "CET",
               "T\u00ecde samhraidh Meadhan na Roinn-E\u00f2rpa",
               "CEST",
               "\u00c0m Meadhan na Roinn-E\u00f2rpa",
               "CET",
            };
        final String[] Acre = new String[] {
               "Bun-\u00e0m Acre",
               "",
               "T\u00ecde samhraidh Acre",
               "",
               "\u00c0m Acre",
               "",
            };
        final String[] America_Eastern = new String[] {
               "Bun-\u00e0m Aimeireaga a Tuath an Ear",
               "EST",
               "T\u00ecde samhraidh Aimeireaga a Tuath an Ear",
               "EDT",
               "\u00c0m Aimeireaga a Tuath an Ear",
               "ET",
            };
        final String[] Lord_Howe = new String[] {
               "Bun-\u00e0m Lord Howe",
               "",
               "T\u00ecde samhraidh Lord Howe",
               "",
               "\u00c0m Lord Howe",
               "",
            };
        final String[] New_Zealand = new String[] {
               "Bun-\u00e0m Shealainn Nuaidh",
               "",
               "T\u00ecde samhraidh Shealainn Nuaidh",
               "",
               "\u00c0m Shealainn Nuaidh",
               "",
            };
        final String[] Indian_Ocean = new String[] {
               "\u00c0m Cuan nan Innseachan",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Yakutsk = new String[] {
               "Bun-\u00e0m Yakutsk",
               "",
               "T\u00ecde samhraidh Yakutsk",
               "",
               "\u00c0m Yakutsk",
               "",
            };
        final String[] East_Timor = new String[] {
               "\u00c0m Th\u00ecomor an Ear",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Kosrae = new String[] {
               "\u00c0m Kosrae",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Europe_Eastern = new String[] {
               "Bun-\u00e0m na Roinn-E\u00f2rpa an Ear",
               "EET",
               "T\u00ecde samhraidh na Roinn-E\u00f2rpa an Ear",
               "EEST",
               "\u00c0m na Roinn-E\u00f2rpa an Ear",
               "EET",
            };
        final String[] Argentina_Western = new String[] {
               "Bun-\u00e0m na h-Argantaine Siaraich",
               "",
               "T\u00ecde samhraidh na h-Argantaine Siaraich",
               "",
               "\u00c0m na h-Argantaine Siaraich",
               "",
            };
        final String[] Ponape = new String[] {
               "\u00c0m Pohnpei",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Bolivia = new String[] {
               "\u00c0m Boilibhia",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Pierre_Miquelon = new String[] {
               "Bun-\u00e0m Saint Pierre agus Miquelon",
               "",
               "T\u00ecde Samhraidh Saint Pierre agus Miquelon",
               "",
               "\u00c0m Saint Pierre agus Miquelon",
               "",
            };
        final String[] Indochina = new String[] {
               "\u00c0m S\u00ecn-Innseanach",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Yekaterinburg = new String[] {
               "Bun-\u00e0m Yekaterinburg",
               "",
               "T\u00ecde samhraidh Yekaterinburg",
               "",
               "\u00c0m Yekaterinburg",
               "",
            };
        final String[] Maldives = new String[] {
               "\u00c0m nan Eileanan Mhaladaibh",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tahiti = new String[] {
               "\u00c0m Tahiti",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Wallis = new String[] {
               "\u00c0m Uallas agus Futuna",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Africa_Southern = new String[] {
               "\u00c0m Afraga a Deas",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Syowa = new String[] {
               "\u00c0m Shyowa",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Line_Islands = new String[] {
               "\u00c0m Eileanan Teraina",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Uzbekistan = new String[] {
               "Bun-\u00e0m Usbagast\u00e0n",
               "",
               "T\u00ecde samhraidh Usbagast\u00e0n",
               "",
               "\u00c0m Usbagast\u00e0n",
               "",
            };
        final String[] Mongolia = new String[] {
               "Bun-\u00e0m Ulan Bator",
               "",
               "T\u00ecde samhraidh Ulan Bator",
               "",
               "\u00c0m Ulan Bator",
               "",
            };
        final String[] America_Central = new String[] {
               "Bun-\u00e0m Meadhan Aimeireaga a Tuath",
               "CST",
               "T\u00ecde samhraidh Meadhan Aimeireaga a Tuath",
               "CDT",
               "\u00c0m Meadhan Aimeireaga a Tuath",
               "CT",
            };
        final String[] Niue = new String[] {
               "\u00c0m Niue",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Wake = new String[] {
               "\u00c0m Eilean Wake",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Falkland = new String[] {
               "Bun-\u00e0m nan Eileanan F\u00e0clannach",
               "",
               "T\u00ecde samhraidh nan Eileanan F\u00e0clannach",
               "",
               "\u00c0m nan Eileanan F\u00e0clannach",
               "",
            };
        final String[] Apia = new String[] {
               "Bun-\u00e0m Apia",
               "",
               "T\u00ecde samhraidh Apia",
               "",
               "\u00c0m Apia",
               "",
            };
        final String[] Bhutan = new String[] {
               "\u00c0m But\u00e0in",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Nauru = new String[] {
               "\u00c0m Nabhru",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Kazakhstan_Western = new String[] {
               "\u00c0m Casachst\u00e0in an Iar",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Christmas = new String[] {
               "\u00c0m Eilean na Nollaig",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Reunion = new String[] {
               "\u00c0m Reunion",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Cocos = new String[] {
               "\u00c0m Eileanan Chocos",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Chatham = new String[] {
               "Bun-\u00e0m Chatham",
               "",
               "T\u00ecde samhraidh Chatham",
               "",
               "\u00c0m Chatham",
               "",
            };
        final String[] Vostok = new String[] {
               "\u00c0m Vostok",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Argentina = new String[] {
               "Bun-\u00e0m na h-Argantaine",
               "",
               "T\u00ecde samhraidh na h-Argantaine",
               "",
               "\u00c0m na h-Argantaine",
               "",
            };
        final String[] Gambier = new String[] {
               "\u00c0m Ghambier",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Galapagos = new String[] {
               "\u00c0m Ghalapagos",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Venezuela = new String[] {
               "\u00c0m na Bheiniseala",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Phoenix_Islands = new String[] {
               "\u00c0m Eileanan Phoenix",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Cape_Verde = new String[] {
               "Bun-\u00e0m a\u2019 Chip Uaine",
               "",
               "T\u00ecde samhraidh a\u2019 Chip Uaine",
               "",
               "\u00c0m a\u2019 Chip Uaine",
               "",
            };
        final String[] Norfolk = new String[] {
               "\u00c0m Eilein Norfolk",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Samoa = new String[] {
               "Bun-\u00e0m Samotha",
               "",
               "T\u00ecde samhraidh Samotha",
               "",
               "\u00c0m Samotha",
               "",
            };
        final String[] Davis = new String[] {
               "\u00c0m Dhavis",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Cuba = new String[] {
               "Bun-\u00e0m C\u00f9ba",
               "",
               "T\u00ecde samhraidh C\u00f9ba",
               "",
               "\u00c0m C\u00f9ba",
               "",
            };
        final String[] GMT = new String[] {
               "Greenwich Mean Time",
               "GMT",
               "",
               "",
               "",
               "",
            };
        final String[] Philippines = new String[] {
               "Bun-\u00e0m nan Eilean Filipineach",
               "",
               "T\u00ecde samhraidh nan Eilean Filipineach",
               "",
               "\u00c0m nan Eilean Filipineach",
               "",
            };
        final String[] French_Southern = new String[] {
               "\u00c0m Deasach agus Antartaigeach na Frainge",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] New_Caledonia = new String[] {
               "Bun-\u00e0m Chailleann Nuaidh",
               "",
               "T\u00ecde samhraidh Chailleann Nuaidh",
               "",
               "\u00c0m Chailleann Nuaidh",
               "",
            };
        final String[] Brunei = new String[] {
               "\u00c0m Bhr\u00f9naigh D\u00e0r as-Sal\u00e0m",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Iran = new String[] {
               "Bun-\u00e0m Ior\u00e0in",
               "",
               "T\u00ecde samhraidh Ior\u00e0in",
               "",
               "\u00c0m Ior\u00e0in",
               "",
            };
        final String[] Tajikistan = new String[] {
               "\u00c0m Taidigeast\u00e0in",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tonga = new String[] {
               "Bun-\u00e0m Tonga",
               "",
               "T\u00ecde samhraidh Tonga",
               "",
               "\u00c0m Tonga",
               "",
            };
        final String[] Bangladesh = new String[] {
               "Bun-\u00e0m Bangladais",
               "",
               "T\u00ecde samhraidh Bangladais",
               "",
               "\u00c0m Bangladais",
               "",
            };
        final String[] Peru = new String[] {
               "Bun-\u00e0m Pear\u00f9",
               "",
               "T\u00ecde samhraidh Pear\u00f9",
               "",
               "\u00c0m Pear\u00f9",
               "",
            };
        final String[] Greenland_Eastern = new String[] {
               "Bun-\u00e0m na Graonlainn an Ear",
               "",
               "T\u00ecde samhraidh na Graonlainn an Ear",
               "",
               "\u00c0m na Graonlainn an Ear",
               "",
            };
        final String[] Indonesia_Eastern = new String[] {
               "\u00c0m nan Innd-Innse an Ear",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Kyrgystan = new String[] {
               "\u00c0m C\u00ecorgastain",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Australia_Eastern = new String[] {
               "Bun-\u00e0m Astr\u00e0ilia an Ear",
               "",
               "T\u00ecde samhraidh Astr\u00e0ilia an Ear",
               "",
               "\u00c0m Astr\u00e0ilia an Ear",
               "",
            };
        final String[] French_Guiana = new String[] {
               "\u00c0m Guidhe\u00e0na na Frainge",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Colombia = new String[] {
               "Bun-\u00e0m Coloimbia",
               "",
               "T\u00ecde samhraidh Coloimbia",
               "",
               "\u00c0m Coloimbia",
               "",
            };
        final String[] Chile = new String[] {
               "Bun-\u00e0m na Sile",
               "",
               "T\u00ecde samhraidh na Sile",
               "",
               "\u00c0m na Sile",
               "",
            };
        final String[] Gilbert_Islands = new String[] {
               "\u00c0m Eileanan Ghileabairt",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Irkutsk = new String[] {
               "Bun-\u00e0m Irkutsk",
               "",
               "T\u00ecde Samhraidh Irkutsk",
               "",
               "\u00c0m Irkutsk",
               "",
            };
        final String[] Georgia = new String[] {
               "Bun-\u00e0m na Cairtbheile",
               "",
               "T\u00ecde samhraidh na Cairtbheile",
               "",
               "\u00c0m na Cairtbheile",
               "",
            };
        final String[] Choibalsan = new String[] {
               "Bun-\u00e0m Choibalsan",
               "",
               "T\u00ecde samhraidh Choibalsan",
               "",
               "\u00c0m Choibalsan",
               "",
            };
        final String[] China = new String[] {
               "Bun-\u00e0m na S\u00ecne",
               "",
               "T\u00ecde samhraidh na S\u00ecne",
               "",
               "\u00c0m na S\u00ecne",
               "",
            };
        final String[] Armenia = new String[] {
               "Bun-\u00e0m Airmeinia",
               "",
               "T\u00ecde samhraidh Airmeinia",
               "",
               "\u00c0m Airmeinia",
               "",
            };
        final String[] Africa_Central = new String[] {
               "\u00c0m Meadhan Afraga",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Japan = new String[] {
               "Bun-\u00e0m na Seapaine",
               "",
               "T\u00ecde samhraidh na Seapaine",
               "",
               "\u00c0m na Seapaine",
               "",
            };
        final String[] Taipei = new String[] {
               "Bun-\u00e0m Taipei",
               "",
               "T\u00ecde samhraidh Taipei",
               "",
               "\u00c0m Taipei",
               "",
            };
        final String[] Hovd = new String[] {
               "Bun-\u00e0m Hovd",
               "",
               "T\u00ecde samhraidh Hovd",
               "",
               "\u00c0m Hovd",
               "",
            };
        final String[] Australia_CentralWestern = new String[] {
               "Bun-\u00e0m Meadhan Astr\u00e0ilia an Iar",
               "",
               "T\u00ecde samhraidh Meadhan Astr\u00e0ilia an Iar",
               "",
               "\u00c0m Meadhan Astr\u00e0ilia an Iar",
               "",
            };
        final String[] Sakhalin = new String[] {
               "Bun-\u00e0m Sakhalin",
               "",
               "T\u00ecde samhraidh Sakhalin",
               "",
               "\u00c0m Sakhalin",
               "",
            };
        final String[] Paraguay = new String[] {
               "Bun-\u00e0m Paraguaidh",
               "",
               "T\u00ecde samhraidh Paraguaidh",
               "",
               "\u00c0m Paraguaidh",
               "",
            };
        final String[] Casey = new String[] {
               "\u00c0m Chasey",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Malaysia = new String[] {
               "\u00c0m Mhalaidhsea",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] ETC_UTC = new String[] {
               "\u00c0m Uile-choitcheann Co-\u00f2rdanaichte",
               "UTC",
               "",
               "",
               "",
               "",
            };
        final String[] Mauritius = new String[] {
               "Bun-\u00e0m nan Eileanan Mhoiriseas",
               "",
               "T\u00ecde samhraidh nan Eileanan Mhoiriseas",
               "",
               "\u00c0m nan Eileanan Mhoiriseas",
               "",
            };
        final String[] Africa_Eastern = new String[] {
               "\u00c0m Afraga an Ear",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Solomon = new String[] {
               "\u00c0m Eileanan Sholaimh",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Marshall_Islands = new String[] {
               "\u00c0m Eileanan Mharshall",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Newfoundland = new String[] {
               "Bun-\u00e0m Talamh an \u00c8isg",
               "",
               "T\u00ecde samhraidh Talamh an \u00c8isg",
               "",
               "\u00c0m Talamh an \u00c8isg",
               "",
            };
        final String[] Afghanistan = new String[] {
               "\u00c0m Afghanast\u00e0in",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hong_Kong = new String[] {
               "Bun-\u00e0m Hong Kong",
               "",
               "T\u00ecde samhraidh Hong Kong",
               "",
               "\u00c0m Hong Kong",
               "",
            };
        final String[] Atlantic = new String[] {
               "Bun-\u00e0m a\u2019 Chuain Siar",
               "AST",
               "T\u00ecde samhraidh a\u2019 Chuain Siar",
               "ADT",
               "\u00c0m a\u2019 Chuain Siar",
               "AT",
            };
        final String[] Israel = new String[] {
               "Bun-\u00e0m Iosrael",
               "",
               "T\u00ecde samhraidh Iosrael",
               "",
               "\u00c0m Iosrael",
               "",
            };
        final String[] Indonesia_Central = new String[] {
               "\u00c0m Meadhan nan Innd-Innse",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Omsk = new String[] {
               "Bun-\u00e0m Omsk",
               "",
               "T\u00ecde samhraidh Omsk",
               "",
               "\u00c0m Omsk",
               "",
            };
        final String[] Seychelles = new String[] {
               "\u00c0m nan Eileanan Sheiseall",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Uruguay = new String[] {
               "Bun-\u00e0m Uruguaidh",
               "",
               "T\u00ecde samhraidh Uruguaidh",
               "",
               "\u00c0m Uruguaidh",
               "",
            };
        final String[] Nepal = new String[] {
               "\u00c0m Neap\u00e0l",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Truk = new String[] {
               "\u00c0m Chuuk",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Vanuatu = new String[] {
               "Bun-\u00e0m Vanuatu",
               "",
               "T\u00ecde samhraidh Vanuatu",
               "",
               "\u00c0m Vanuatu",
               "",
            };
        final String[] Novosibirsk = new String[] {
               "Bun-\u00e0m Novosibirsk",
               "",
               "T\u00ecde samhraidh Novosibirsk",
               "",
               "\u00c0m Novosibirsk",
               "",
            };
        final String[] Singapore = new String[] {
               "\u00c0m Singeap\u00f2r",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Azores = new String[] {
               "Bun-\u00e0m nan Eileanan Asorach",
               "",
               "T\u00ecde samhraidh nan Eileanan Asorach",
               "",
               "\u00c0m nan Eileanan Asorach",
               "",
            };
        final String[] Suriname = new String[] {
               "\u00c0m Suranaim",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Krasnoyarsk = new String[] {
               "Bun-\u00e0m Krasnoyarsk",
               "",
               "T\u00ecde samhraidh Krasnoyarsk",
               "",
               "\u00c0m Krasnoyarsk",
               "",
            };
        final String[] Myanmar = new String[] {
               "\u00c0m Mi\u00e0nmar",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Amazon = new String[] {
               "Bun-\u00e0m Amasoin",
               "",
               "T\u00ecde samhraidh Amasoin",
               "",
               "\u00c0m Amasoin",
               "",
            };
        final String[] Kazakhstan_Eastern = new String[] {
               "\u00c0m Casachst\u00e0in an Ear",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Fiji = new String[] {
               "Bun-\u00e0m F\u00ecdi",
               "",
               "T\u00ecde samhraidh F\u00ecdi",
               "",
               "\u00c0m F\u00ecdi",
               "",
            };
        final String[] Kamchatka = new String[] {
               "Bun-\u00e0m Petropavlovsk-Kamchatsky",
               "",
               "T\u00ecde samhraidh Petropavlovsk-Kamchatsky",
               "",
               "\u00c0m Petropavlovsk-Kamchatsky",
               "",
            };
        final String[] Tuvalu = new String[] {
               "\u00c0m Tubhalu",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Macquarie = new String[] {
               "\u00c0m Eilein MhicGuaire",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hawaii_Aleutian = new String[] {
               "Bun-\u00e0m nan Eileanan Hawai\u2019i \u2019s Aleutach",
               "HAST",
               "T\u00ecde Samhraidh nan Eileanan Hawai\u2019i \u2019s Aleutach",
               "HADT",
               "\u00c0m nan Eileanan Hawai\u2019i \u2019s Aleutach",
               "HAT",
            };
        final String[] Australia_Central = new String[] {
               "Bun-\u00e0m Meadhan Astr\u00e0ilia",
               "",
               "T\u00ecde samhraidh Meadhan Astr\u00e0ilia",
               "",
               "\u00c0m Meadhan Astr\u00e0ilia",
               "",
            };
        final String[] America_Pacific = new String[] {
               "Bun-\u00e0m a\u2019 Chuain S\u00e8imh",
               "PST",
               "T\u00ecde samhraidh a\u2019 Chuain S\u00e8imh",
               "PDT",
               "\u00c0m a\u2019 Chuain S\u00e8imh",
               "PT",
            };
        final String[] Turkmenistan = new String[] {
               "Bun-\u00e0m Turcmanast\u00e0in",
               "",
               "T\u00ecde samhraidh Turcmanast\u00e0in",
               "",
               "\u00c0m Turcmanast\u00e0in",
               "",
            };
        final String[] Europe_Western = new String[] {
               "Bun-\u00e0m na Roinn-E\u00f2rpa an Iar",
               "WET",
               "T\u00ecde samhraidh na Roinn-E\u00f2rpa an Iar",
               "WEST",
               "\u00c0m na Roinn-E\u00f2rpa an Iar",
               "WET",
            };
        final String[] Guyana = new String[] {
               "\u00c0m Guidhe\u00e0na",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Pitcairn = new String[] {
               "\u00c0m Peit a\u2019 Ch\u00e0irn",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Rothera = new String[] {
               "\u00c0m Rothera",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Palau = new String[] {
               "\u00c0m Palabh",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Azerbaijan = new String[] {
               "Bun-\u00e0m Asarbaide\u00e0in",
               "",
               "T\u00ecde samhraidh Asarbaide\u00e0in",
               "",
               "\u00c0m Asarbaide\u00e0in",
               "",
            };
        final String[] Mawson = new String[] {
               "\u00c0m Mhawson",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mexico_Pacific = new String[] {
               "Bun-\u00e0m a\u2019 Chuain S\u00e8imh Mheagsago",
               "",
               "T\u00ecde samhraidh a\u2019 Chuain S\u00e8imh Mheagsago",
               "",
               "\u00c0m a\u2019 Chuain S\u00e8imh Mheagsago",
               "",
            };
        final String[] Africa_Western = new String[] {
               "Bun-\u00e0m Afraga an Iar",
               "",
               "T\u00ecde Samhraidh Afraga an Iar",
               "",
               "\u00c0m Afraga an Iar",
               "",
            };
        final String[] South_Georgia = new String[] {
               "\u00c0m Se\u00f2rsea a Deas",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Easter = new String[] {
               "Bun-\u00e0m Eilean na C\u00e0isge",
               "",
               "T\u00ecde samhraidh Eilean na C\u00e0isge",
               "",
               "\u00c0m Eilean na C\u00e0isge",
               "",
            };
        final String[] Mexico_Northwest = new String[] {
               "Bun-\u00e0m Mheagsago an Iar-thuath",
               "",
               "T\u00ecde samhraidh Mheagsago an Iar-thuath",
               "",
               "\u00c0m Mheagsago an Iar-thuath",
               "",
            };
        final String[] DumontDUrville = new String[] {
               "\u00c0m Dumont-d\u2019Urville",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Greenland_Western = new String[] {
               "Bun-\u00e0m na Graonlainn an Iar",
               "",
               "T\u00ecde samhraidh na Graonlainn an Iar",
               "",
               "\u00c0m na Graonlainn an Iar",
               "",
            };
        final String[] Ecuador = new String[] {
               "\u00c0m Eacuadoir",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Gulf = new String[] {
               "\u00c0m a\u2019 Chamais",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Korea = new String[] {
               "Bun-\u00e0m Choir\u00e8a",
               "",
               "T\u00ecde samhraidh Choir\u00e8a",
               "",
               "\u00c0m Choir\u00e8a",
               "",
            };
        final String[] Australia_Western = new String[] {
               "Bun-\u00e0m Astr\u00e0ilia an Iar",
               "",
               "T\u00ecde samhraidh Astr\u00e0ilia an Iar",
               "",
               "\u00c0m Astr\u00e0ilia an Iar",
               "",
            };
        final String[] Indonesia_Western = new String[] {
               "\u00c0m nan Innd-Innse an Iar",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] America_Mountain = new String[] {
               "Bun-\u00e0m Monadh Aimeireaga a Tuath",
               "MST",
               "T\u00ecde samhraidh Monadh Aimeireaga a Tuath",
               "MDT",
               "\u00c0m Monadh Aimeireaga a Tuath",
               "MT",
            };
        final String[] Marquesas = new String[] {
               "\u00c0m Eileanan a\u2019 Mharcais",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Arabian = new String[] {
               "Bun-\u00e0m Arabach",
               "",
               "T\u00ecde samhraidh Arabach",
               "",
               "\u00c0m Arabach",
               "",
            };
        final String[] Alaska = new String[] {
               "Bun-\u00e0m Alaska",
               "AKST",
               "T\u00ecde samhraidh Alaska",
               "AKDT",
               "\u00c0m Alaska",
               "AKT",
            };
        final String[] Vladivostok = new String[] {
               "Bun-\u00e0m Vladivostok",
               "",
               "T\u00ecde Samhraidh Vladivostok",
               "",
               "\u00c0m Vladivostok",
               "",
            };
        final String[] Chamorro = new String[] {
               "\u00c0m Chamorro",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tokelau = new String[] {
               "\u00c0m Tokelau",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Papua_New_Guinea = new String[] {
               "\u00c0m Gini Nuaidh Paputhaiche",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Noronha = new String[] {
               "Bun-\u00e0m Fernando de Noronha",
               "",
               "T\u00ecde Samhraidh Fernando de Noronha",
               "",
               "\u00c0m Fernando de Noronha",
               "",
            };
        final String[] Brasilia = new String[] {
               "Bun-\u00e0m Bhrasilia",
               "",
               "T\u00ecde samhraidh Bhrasilia",
               "",
               "\u00c0m Bhrasilia",
               "",
            };
        final String[] Anadyr = new String[] {
               "Bun-\u00e0m Anadyr",
               "",
               "T\u00ecde samhraidh Anadyr",
               "",
               "\u00c0m Anadyr",
               "",
            };
        final String[] Samara = new String[] {
               "Bun-\u00e0m Samara",
               "",
               "T\u00ecde samhraidh Samara",
               "",
               "\u00c0m Samara",
               "",
            };
        final String[] Pyongyang = new String[] {
               "\u00c0m Pyeongyang",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] India = new String[] {
               "\u00c0m nan Innseachan",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Cook = new String[] {
               "Bun-\u00e0m Eileanan Cook",
               "",
               "Leth-th\u00ecde samhraidh Eileanan Cook",
               "",
               "\u00c0m Eileanan Cook",
               "",
            };
        final Object[][] data = new Object[][] {
            { "America/Los_Angeles", America_Pacific },
            { "America/Denver", America_Mountain },
            { "America/Phoenix", America_Mountain },
            { "America/Chicago", America_Central },
            { "America/New_York", America_Eastern },
            { "America/Indianapolis", America_Eastern },
            { "Pacific/Honolulu",
                new String[] {
                    "Bun-\u00e0m nan Eileanan Hawai\u2019i \u2019s Aleutach",
                    "HST",
                    "T\u00ecde Samhraidh nan Eileanan Hawai\u2019i \u2019s Aleutach",
                    "HDT",
                    "\u00c0m nan Eileanan Hawai\u2019i \u2019s Aleutach",
                    "HST",
                }
            },
            { "America/Anchorage", Alaska },
            { "America/Halifax", Atlantic },
            { "America/Sitka", Alaska },
            { "America/St_Johns", Newfoundland },
            { "Europe/Paris", Europe_Central },
            { "GMT", GMT },
            { "Africa/Casablanca", Europe_Western },
            { "Asia/Jerusalem", Israel },
            { "Asia/Tokyo", Japan },
            { "Europe/Bucharest", Europe_Eastern },
            { "Asia/Shanghai", China },
            { "UTC", ETC_UTC },
            { "Asia/Aden", Arabian },
            { "timezone.excity.America/Phoenix", "Phoenix" },
            { "timezone.excity.America/Antigua", "Aint\u00ecoga" },
            { "timezone.excity.Europe/Ljubljana", "Ljubljana" },
            { "Asia/Aqtau", Kazakhstan_Western },
            { "timezone.excity.Pacific/Marquesas", "Eileanan a\u2019 Mharcais" },
            { "America/El_Salvador", America_Central },
            { "timezone.excity.America/Buenos_Aires", "Buenos Aires" },
            { "Asia/Pontianak", Indonesia_Western },
            { "timezone.excity.America/Danmarkshavn", "Danmarkshavn" },
            { "timezone.excity.America/Anchorage", "Anchorage" },
            { "Africa/Mbabane", Africa_Southern },
            { "Asia/Kuching", Malaysia },
            { "Europe/London",
                new String[] {
                    "Greenwich Mean Time",
                    "GMT",
                    "T\u00ecde samhraidh Bhreatainn",
                    "TSB",
                    "",
                    "",
                }
            },
            { "timezone.excity.Antarctica/Vostok", "Vostok" },
            { "America/Panama", America_Eastern },
            { "JST", Japan },
            { "timezone.excity.Pacific/Fiji", "F\u00ecdi" },
            { "timezone.excity.Europe/Gibraltar", "Diobraltar" },
            { "Europe/Jersey", GMT },
            { "timezone.excity.Africa/Malabo", "Malabo" },
            { "America/Eirunepe", Acre },
            { "Europe/Luxembourg", Europe_Central },
            { "timezone.excity.Africa/Libreville", "Libreville" },
            { "Europe/Zaporozhye", Europe_Eastern },
            { "timezone.excity.Africa/Dakar", "Dakar" },
            { "Atlantic/St_Helena", GMT },
            { "timezone.excity.Africa/Addis_Ababa", "Addis Ab\u00e4ba" },
            { "timezone.excity.Africa/Kinshasa", "Kinshasa" },
            { "timezone.excity.Asia/Dushanbe", "Dushanbe" },
            { "Europe/Guernsey", GMT },
            { "America/Grand_Turk", America_Eastern },
            { "Asia/Samarkand", Uzbekistan },
            { "timezone.excity.Europe/Tallinn", "Tallinn" },
            { "Asia/Phnom_Penh", Indochina },
            { "Africa/Kigali", Africa_Central },
            { "BET", Brasilia },
            { "timezone.excity.Pacific/Guam", "Guam" },
            { "timezone.excity.Europe/Vaduz", "Vaduz" },
            { "America/Argentina/Salta", Argentina },
            { "Africa/Tripoli", Europe_Eastern },
            { "Africa/Banjul", GMT },
            { "timezone.excity.America/Santa_Isabel", "Santa Isabel" },
            { "timezone.excity.Asia/Barnaul", "Barnaul" },
            { "Antarctica/Syowa", Syowa },
            { "timezone.excity.Africa/Maseru", "Maseru" },
            { "Pacific/Palau", Palau },
            { "timezone.excity.Europe/London", "D\u00f9n \u00c8ideann/Lunnainn" },
            { "America/Montevideo", Uruguay },
            { "Africa/Windhoek", Africa_Central },
            { "Asia/Karachi", Pakistan },
            { "timezone.excity.Pacific/Pitcairn", "Peit a\u2019 Ch\u00e0irn" },
            { "Australia/Perth", Australia_Western },
            { "Asia/Chita", Yakutsk },
            { "Pacific/Easter", Easter },
            { "Antarctica/Davis", Davis },
            { "timezone.excity.Asia/Krasnoyarsk", "Krasnoyarsk" },
            { "Antarctica/McMurdo", New_Zealand },
            { "timezone.excity.America/Nome", "Nome" },
            { "Pacific/Tahiti", Tahiti },
            { "timezone.excity.America/Vancouver", "Vancouver" },
            { "timezone.excity.America/Matamoros", "Matamoros" },
            { "Africa/Asmera", Africa_Eastern },
            { "Europe/Busingen", Europe_Central },
            { "timezone.excity.Asia/Choibalsan", "Choibalsan" },
            { "timezone.excity.America/Inuvik", "Inuuvik" },
            { "Africa/Malabo", Africa_Western },
            { "America/Catamarca", Argentina },
            { "America/Godthab", Greenland_Western },
            { "timezone.excity.America/St_Lucia", "Naomh L\u00f9isea" },
            { "timezone.excity.Asia/Novokuznetsk", "Novokuznetsk" },
            { "timezone.excity.Europe/Berlin", "Berlin" },
            { "Africa/Lagos", Africa_Western },
            { "timezone.excity.Pacific/Midway", "Midway" },
            { "Europe/Rome", Europe_Central },
            { "Indian/Mauritius", Mauritius },
            { "timezone.excity.America/Martinique", "Mairtinic" },
            { "America/Dawson_Creek", America_Mountain },
            { "America/St_Thomas", Atlantic },
            { "Europe/Zurich", Europe_Central },
            { "Asia/Dili", East_Timor },
            { "timezone.excity.Australia/Perth", "Perth" },
            { "Africa/Bamako", GMT },
            { "timezone.excity.Africa/Asmera", "Asmar\u00e0" },
            { "timezone.excity.Arctic/Longyearbyen", "Longyearbyen" },
            { "Pacific/Wallis", Wallis },
            { "timezone.excity.America/Tegucigalpa", "Tegucigalpa" },
            { "timezone.excity.Africa/Windhoek", "Windhoek" },
            { "Africa/Lubumbashi", Africa_Central },
            { "timezone.excity.Pacific/Majuro", "Majuro" },
            { "Asia/Choibalsan", Choibalsan },
            { "Asia/Omsk", Omsk },
            { "Europe/Vaduz", Europe_Central },
            { "timezone.excity.Africa/Banjul", "Banjul" },
            { "Asia/Dhaka", Bangladesh },
            { "timezone.excity.Australia/Lindeman", "Lindeman" },
            { "timezone.excity.America/Miquelon", "Miquelon" },
            { "Asia/Yekaterinburg", Yekaterinburg },
            { "America/Louisville", America_Eastern },
            { "timezone.excity.America/Jujuy", "Jujuy" },
            { "timezone.excity.America/Argentina/Ushuaia", "Ushuaia" },
            { "timezone.excity.America/Cayenne", "Cayenne" },
            { "Pacific/Chatham", Chatham },
            { "Asia/Jayapura", Indonesia_Eastern },
            { "timezone.excity.America/Belize", "A\u2019 Bheil\u00ecs" },
            { "Asia/Dushanbe", Tajikistan },
            { "America/Guyana", Guyana },
            { "America/Martinique", Atlantic },
            { "Europe/Berlin", Europe_Central },
            { "timezone.excity.Asia/Bangkok", "Bangkok" },
            { "Europe/Moscow", Moscow },
            { "America/Puerto_Rico", Atlantic },
            { "Pacific/Ponape", Ponape },
            { "Europe/Stockholm", Europe_Central },
            { "Europe/Budapest", Europe_Central },
            { "Europe/Helsinki", Europe_Eastern },
            { "timezone.excity.America/Montevideo", "Montevideo" },
            { "timezone.excity.Pacific/Johnston", "Johnston" },
            { "America/Cayenne", French_Guiana },
            { "timezone.excity.Europe/Jersey", "De\u00e0rsaidh" },
            { "timezone.excity.America/Pangnirtung", "Pangniqtuuq" },
            { "timezone.excity.Atlantic/South_Georgia", "Se\u00f2rsea a Deas" },
            { "Pacific/Fiji", Fiji },
            { "timezone.excity.Africa/Juba", "Juba" },
            { "America/Rainy_River", America_Central },
            { "Indian/Maldives", Maldives },
            { "SystemV/AST4", Atlantic },
            { "timezone.excity.America/Havana", "Havana" },
            { "timezone.excity.Europe/Madrid", "Madrid" },
            { "Asia/Oral", Kazakhstan_Western },
            { "timezone.excity.America/Detroit", "Detroit" },
            { "America/Yellowknife", America_Mountain },
            { "Pacific/Enderbury", Phoenix_Islands },
            { "America/Juneau", Alaska },
            { "America/Indiana/Vevay", America_Eastern },
            { "timezone.excity.America/Grenada", "Grean\u00e0da" },
            { "timezone.excity.Asia/Phnom_Penh", "Phnom Penh" },
            { "timezone.excity.Asia/Hebron", "Hebron" },
            { "timezone.excity.Europe/Rome", "An R\u00f2imh" },
            { "Asia/Jakarta", Indonesia_Western },
            { "timezone.excity.Antarctica/Mawson", "Mawson" },
            { "timezone.excity.Asia/Karachi", "Kar\u0101c\u012b" },
            { "timezone.excity.America/Resolute", "Qausuittuq" },
            { "timezone.excity.Africa/Nouakchott", "Nouakchott" },
            { "timezone.excity.Africa/Bamako", "Bamako" },
            { "timezone.excity.America/Argentina/Salta", "Salta" },
            { "America/Recife", Brasilia },
            { "America/Buenos_Aires", Argentina },
            { "timezone.excity.Asia/Muscat", "Muscat" },
            { "America/Noronha", Noronha },
            { "timezone.excity.Africa/El_Aaiun", "El Aai\u00fan" },
            { "timezone.excity.Australia/Hobart", "Hobart" },
            { "Australia/Adelaide", Australia_Central },
            { "timezone.excity.America/Lima", "Lima" },
            { "timezone.excity.Asia/Atyrau", "Atyrau" },
            { "America/Paramaribo", Suriname },
            { "timezone.excity.Asia/Bishkek", "Bishkek" },
            { "America/Indiana/Vincennes", America_Eastern },
            { "Antarctica/Mawson", Mawson },
            { "timezone.excity.America/Paramaribo", "Paramaribo" },
            { "Antarctica/Troll", GMT },
            { "timezone.excity.America/Ojinaga", "Ojinaga" },
            { "timezone.excity.Europe/Zurich", "Z\u00fcrich" },
            { "Europe/Samara", Samara },
            { "America/Antigua", Atlantic },
            { "timezone.excity.America/Sao_Paulo", "S\u00e3o Paulo" },
            { "Pacific/Gambier", Gambier },
            { "Africa/Gaborone", Africa_Central },
            { "Asia/Pyongyang", Pyongyang },
            { "timezone.excity.America/New_York", "Nuadh Eabhrac" },
            { "Asia/Gaza", Europe_Eastern },
            { "timezone.excity.Africa/Accra", "Accra" },
            { "timezone.excity.Etc/Unknown", "Baile neo-aithnichte" },
            { "Asia/Qyzylorda", Kazakhstan_Eastern },
            { "timezone.excity.America/Thule", "Qaanaaq" },
            { "timezone.excity.America/Grand_Turk", "An Turc Mh\u00f2r" },
            { "America/Yakutat", Alaska },
            { "Europe/Vienna", Europe_Central },
            { "timezone.excity.America/Winnipeg", "Winnipeg" },
            { "timezone.excity.Antarctica/Macquarie", "Eilean MhicGuaire" },
            { "timezone.excity.Europe/Uzhgorod", "Uzhgorod" },
            { "timezone.excity.America/Caracas", "Caracas" },
            { "timezone.excity.America/Dawson_Creek", "Dawson Creek" },
            { "timezone.excity.America/Bogota", "Bogot\u00e1" },
            { "timezone.excity.Asia/Baku", "Baku" },
            { "timezone.excity.Asia/Hovd", "Khovd" },
            { "timezone.excity.Africa/Harare", "Harare" },
            { "Europe/Tirane", Europe_Central },
            { "timezone.excity.America/Blanc-Sablon", "Blanc-Sablon" },
            { "timezone.excity.Africa/Algiers", "Algiers" },
            { "Australia/Broken_Hill", Australia_Central },
            { "Europe/Riga", Europe_Eastern },
            { "timezone.excity.Africa/Khartoum", "Khartoum" },
            { "Africa/Abidjan", GMT },
            { "America/Santarem", Brasilia },
            { "timezone.excity.Asia/Khandyga", "Khandyga" },
            { "EST5EDT", America_Eastern },
            { "Pacific/Guam", Chamorro },
            { "Atlantic/Bermuda", Atlantic },
            { "timezone.excity.Pacific/Galapagos", "Gal\u00e1pagos" },
            { "America/Costa_Rica", America_Central },
            { "America/Dawson", America_Pacific },
            { "Europe/Amsterdam", Europe_Central },
            { "timezone.excity.America/Argentina/Tucuman", "Tucum\u00e1n" },
            { "timezone.excity.America/Rio_Branco", "Rio Branco" },
            { "Africa/Accra", GMT },
            { "timezone.excity.Europe/Ulyanovsk", "Ulyanovsk" },
            { "timezone.excity.Africa/Niamey", "Niamey" },
            { "timezone.excity.Indian/Mayotte", "Mayotte" },
            { "America/Maceio", Brasilia },
            { "Australia/Lord_Howe", Lord_Howe },
            { "Europe/Dublin",
                new String[] {
                    "Greenwich Mean Time",
                    "GMT",
                    "Bun-\u00e0m na h-\u00c8ireann",
                    "TS\u00c8 (\u00c8irinn)",
                    "",
                    "",
                }
            },
            { "Pacific/Truk", Truk },
            { "timezone.excity.Africa/Conakry", "Conakry" },
            { "timezone.excity.Asia/Jakarta", "Jakarta" },
            { "SST", Solomon },
            { "America/Jamaica", America_Eastern },
            { "Asia/Bishkek", Kyrgystan },
            { "Atlantic/Stanley", Falkland },
            { "timezone.excity.Europe/Saratov", "Saratov" },
            { "SystemV/CST6", America_Central },
            { "timezone.excity.Pacific/Efate", "Efate" },
            { "timezone.excity.Asia/Aqtobe", "Aqt\u00f6be" },
            { "Asia/Vladivostok", Vladivostok },
            { "timezone.excity.Atlantic/St_Helena", "Eilean Naomh Eilidh" },
            { "Africa/Maputo", Africa_Central },
            { "Africa/El_Aaiun", Europe_Western },
            { "Africa/Ouagadougou", GMT },
            { "timezone.excity.Pacific/Rarotonga", "Rarotonga" },
            { "timezone.excity.Europe/Luxembourg", "Lugsamburg" },
            { "America/Cayman", America_Eastern },
            { "Asia/Ulaanbaatar", Mongolia },
            { "Asia/Baghdad", Arabian },
            { "timezone.excity.Asia/Bahrain", "Bachrain" },
            { "timezone.excity.Indian/Mahe", "Mah\u00e9" },
            { "Europe/San_Marino", Europe_Central },
            { "America/Indiana/Tell_City", America_Central },
            { "BST", Bangladesh },
            { "timezone.excity.Europe/Isle_of_Man", "Eilean Mhanainn" },
            { "Pacific/Saipan", Chamorro },
            { "timezone.excity.America/Curacao", "Cura\u00e7ao" },
            { "timezone.excity.Pacific/Nauru", "Nabhru" },
            { "timezone.excity.Pacific/Pago_Pago", "Pago Pago" },
            { "Antarctica/Rothera", Rothera },
            { "timezone.excity.America/Guyana", "Guidhe\u00e0na" },
            { "Asia/Damascus", Europe_Eastern },
            { "MIT", Apia },
            { "America/Argentina/San_Luis", Argentina_Western },
            { "timezone.excity.Europe/Paris", "Paras" },
            { "timezone.excity.Europe/Zagreb", "Zagreb" },
            { "Africa/Porto-Novo", Africa_Western },
            { "America/La_Paz", Bolivia },
            { "timezone.excity.America/Swift_Current", "Swift Current" },
            { "Asia/Manila", Philippines },
            { "Asia/Bangkok", Indochina },
            { "timezone.excity.America/Tortola", "Tortola" },
            { "Atlantic/Madeira", Europe_Western },
            { "America/Thunder_Bay", America_Eastern },
            { "timezone.excity.Europe/Budapest", "Budapest" },
            { "timezone.excity.America/Catamarca", "Catamarca" },
            { "timezone.excity.America/Port_of_Spain", "Port na Sp\u00e0inne" },
            { "timezone.excity.Asia/Chita", "Chita" },
            { "America/Indiana/Marengo", America_Eastern },
            { "timezone.excity.America/Rankin_Inlet", "Kangiqliniq" },
            { "timezone.excity.America/Santarem", "Santar\u00e9m" },
            { "timezone.excity.Asia/Tomsk", "Tomsk" },
            { "timezone.excity.Europe/Helsinki", "Helsinki" },
            { "America/Mexico_City", America_Central },
            { "timezone.excity.America/Yakutat", "Yakutat" },
            { "Antarctica/Vostok", Vostok },
            { "Europe/Andorra", Europe_Central },
            { "timezone.excity.Asia/Anadyr", "Anadyr" },
            { "timezone.excity.Asia/Urumqi", "\u00dcr\u00fcmqi" },
            { "timezone.excity.America/Costa_Rica", "Costa R\u00eccea" },
            { "timezone.excity.Africa/Lagos", "Lagos" },
            { "timezone.excity.Africa/Bissau", "Bissau" },
            { "America/Matamoros", America_Central },
            { "America/Blanc-Sablon", Atlantic },
            { "Asia/Riyadh", Arabian },
            { "timezone.excity.Africa/Douala", "Douala" },
            { "Europe/Oslo", Europe_Central },
            { "timezone.excity.Africa/Mogadishu", "Mogadishu" },
            { "timezone.excity.America/Bahia_Banderas", "Bah\u00eda de Banderas" },
            { "timezone.excity.Asia/Jayapura", "Jayapura" },
            { "America/Menominee", America_Central },
            { "timezone.excity.Pacific/Guadalcanal", "Guadalcanal" },
            { "America/Resolute", America_Central },
            { "timezone.excity.Africa/Lome", "Lom\u00e9" },
            { "timezone.excity.America/Nassau", "Nassau" },
            { "Africa/Kampala", Africa_Eastern },
            { "Asia/Krasnoyarsk", Krasnoyarsk },
            { "timezone.excity.Asia/Kuwait", "Cuibh\u00e8it" },
            { "timezone.excity.America/Santo_Domingo", "Santo Domingo" },
            { "America/Edmonton", America_Mountain },
            { "Europe/Podgorica", Europe_Central },
            { "timezone.excity.Europe/Moscow", "Mosgo" },
            { "Africa/Bujumbura", Africa_Central },
            { "Europe/Minsk", Moscow },
            { "Pacific/Auckland", New_Zealand },
            { "timezone.excity.Asia/Taipei", "Taipei" },
            { "Asia/Qatar", Arabian },
            { "Europe/Kiev", Europe_Eastern },
            { "America/Port-au-Prince", America_Eastern },
            { "Europe/Belfast",
                new String[] {
                    "Greenwich Mean Time",
                    "GMT",
                    "T\u00ecde samhraidh Bhreatainn",
                    "TSB",
                    "",
                    "",
                }
            },
            { "Asia/Ashgabat", Turkmenistan },
            { "timezone.excity.Asia/Dhaka", "Dhaka" },
            { "America/Nipigon", America_Eastern },
            { "Atlantic/Jan_Mayen", Europe_Central },
            { "America/Fortaleza", Brasilia },
            { "America/Hermosillo", Mexico_Pacific },
            { "timezone.excity.America/Fort_Nelson", "Fort Nelson" },
            { "Africa/Maseru", Africa_Southern },
            { "Africa/Kinshasa", Africa_Western },
            { "Asia/Seoul", Korea },
            { "America/Lima", Peru },
            { "Asia/Brunei", Brunei },
            { "America/Santa_Isabel", Mexico_Northwest },
            { "timezone.excity.Asia/Famagusta", "Famagusta" },
            { "America/Cambridge_Bay", America_Mountain },
            { "Asia/Colombo", India },
            { "Indian/Antananarivo", Africa_Eastern },
            { "America/Vancouver", America_Pacific },
            { "timezone.excity.America/Marigot", "Marigot" },
            { "Africa/Blantyre", Africa_Central },
            { "America/Detroit", America_Eastern },
            { "America/Thule", Atlantic },
            { "timezone.excity.Africa/Lubumbashi", "Lubumbashi" },
            { "Asia/Hong_Kong", Hong_Kong },
            { "timezone.excity.Asia/Ulaanbaatar", "Ulaanbaatar" },
            { "timezone.excity.Antarctica/McMurdo", "McMurdo" },
            { "Asia/Sakhalin", Sakhalin },
            { "timezone.excity.Asia/Novosibirsk", "Novosibirsk" },
            { "Africa/Harare", Africa_Central },
            { "timezone.excity.Asia/Srednekolymsk", "Srednekolymsk" },
            { "America/Nome", Alaska },
            { "timezone.excity.Africa/Nairobi", "Nairobi" },
            { "Europe/Tallinn", Europe_Eastern },
            { "Africa/Johannesburg", Africa_Southern },
            { "timezone.excity.Pacific/Fakaofo", "Fakaofo" },
            { "EAT", Africa_Eastern },
            { "Africa/Bangui", Africa_Western },
            { "Africa/Juba", Africa_Eastern },
            { "America/Campo_Grande", Amazon },
            { "America/Belem", Brasilia },
            { "timezone.excity.Asia/Tokyo", "T\u014dky\u014d" },
            { "Asia/Saigon", Indochina },
            { "timezone.excity.Africa/Johannesburg", "Hannsaborgh" },
            { "Africa/Timbuktu", GMT },
            { "America/Bahia", Brasilia },
            { "America/Goose_Bay", Atlantic },
            { "timezone.excity.Europe/Dublin", "Baile \u00c0tha Cliath" },
            { "timezone.excity.Antarctica/Casey", "Casey" },
            { "timezone.excity.Atlantic/Cape_Verde", "An Ceap Uaine" },
            { "timezone.excity.Africa/Maputo", "Maputo" },
            { "timezone.excity.Africa/Luanda", "Luanda" },
            { "timezone.excity.America/Goose_Bay", "Goose Bay" },
            { "timezone.excity.America/Los_Angeles", "Los Angeles" },
            { "timezone.excity.America/Eirunepe", "Eirunep\u00e9" },
            { "America/Whitehorse", America_Pacific },
            { "timezone.excity.America/Cuiaba", "Cuiab\u00e1" },
            { "Pacific/Noumea", New_Caledonia },
            { "ECT", Europe_Central },
            { "timezone.excity.Atlantic/Azores", "Ponta Delgada" },
            { "timezone.excity.Australia/Melbourne", "Melbourne" },
            { "America/Montreal", America_Eastern },
            { "timezone.excity.America/Anguilla", "Anguillia" },
            { "timezone.excity.Pacific/Honolulu", "Honolulu" },
            { "Asia/Makassar", Indonesia_Central },
            { "America/Argentina/San_Juan", Argentina },
            { "Asia/Nicosia", Europe_Eastern },
            { "America/Indiana/Winamac", America_Eastern },
            { "timezone.excity.Australia/Brisbane", "Brisbane" },
            { "timezone.excity.Indian/Antananarivo", "Antananarivo" },
            { "SystemV/MST7MDT", America_Mountain },
            { "timezone.excity.America/Manaus", "Manaus" },
            { "timezone.excity.Asia/Vientiane", "Viang Chan" },
            { "America/Grenada", Atlantic },
            { "Asia/Khandyga", Yakutsk },
            { "Asia/Thimphu", Bhutan },
            { "Asia/Rangoon", Myanmar },
            { "timezone.excity.Indian/Christmas", "Nollaig" },
            { "Asia/Calcutta", India },
            { "America/Argentina/Tucuman", Argentina },
            { "Asia/Kabul", Afghanistan },
            { "Indian/Cocos", Cocos },
            { "timezone.excity.Asia/Aqtau", "Aqtau" },
            { "timezone.excity.America/Regina", "Regina" },
            { "SystemV/YST9YDT", Alaska },
            { "America/Merida", America_Central },
            { "CAT", Africa_Central },
            { "America/St_Kitts", Atlantic },
            { "timezone.excity.America/Thunder_Bay", "Thunder Bay" },
            { "America/Fort_Nelson", America_Mountain },
            { "America/Caracas", Venezuela },
            { "Asia/Hebron", Europe_Eastern },
            { "SystemV/PST8PDT", America_Pacific },
            { "Africa/Monrovia", GMT },
            { "Asia/Ust-Nera", Vladivostok },
            { "timezone.excity.America/Louisville", "Louisville" },
            { "timezone.excity.America/Cancun", "Canc\u00fan" },
            { "timezone.excity.Australia/Broken_Hill", "Broken Hill" },
            { "timezone.excity.Europe/Kaliningrad", "Kaliningrad" },
            { "America/North_Dakota/New_Salem", America_Central },
            { "timezone.excity.Pacific/Kiritimati", "Kiritimati" },
            { "Australia/Melbourne", Australia_Eastern },
            { "Asia/Irkutsk", Irkutsk },
            { "America/Shiprock", America_Mountain },
            { "timezone.excity.Europe/Tirane", "Tiran\u00eb" },
            { "timezone.excity.Europe/Prague", "Pr\u00e0g" },
            { "timezone.excity.Pacific/Tarawa", "Tarawa" },
            { "Europe/Vatican", Europe_Central },
            { "timezone.excity.America/Asuncion", "Asunci\u00f3n" },
            { "Asia/Amman", Europe_Eastern },
            { "Etc/UTC", ETC_UTC },
            { "timezone.excity.Europe/Chisinau", "Chi\u0219in\u0103u" },
            { "timezone.excity.America/Moncton", "Moncton" },
            { "Asia/Singapore", Singapore },
            { "timezone.excity.America/Guatemala", "Guatamala" },
            { "SystemV/EST5EDT", America_Eastern },
            { "Pacific/Guadalcanal", Solomon },
            { "Europe/Athens", Europe_Eastern },
            { "timezone.excity.Europe/Vilnius", "Vilnius" },
            { "Europe/Monaco", Europe_Central },
            { "timezone.excity.America/Chicago", "Chicago" },
            { "America/Cuiaba", Amazon },
            { "timezone.excity.Europe/San_Marino", "San Marino" },
            { "Africa/Nairobi", Africa_Eastern },
            { "America/Marigot", Atlantic },
            { "timezone.excity.Asia/Irkutsk", "Irkutsk" },
            { "Pacific/Kwajalein", Marshall_Islands },
            { "Africa/Cairo", Europe_Eastern },
            { "Pacific/Pago_Pago", Samoa },
            { "Pacific/Rarotonga", Cook },
            { "America/Guatemala", America_Central },
            { "Australia/Hobart", Australia_Eastern },
            { "timezone.excity.America/Chihuahua", "Chihuahua" },
            { "timezone.excity.Europe/Skopje", "Skopje" },
            { "America/Belize", America_Central },
            { "America/Managua", America_Central },
            { "America/Indiana/Petersburg", America_Eastern },
            { "Asia/Yerevan", Armenia },
            { "Europe/Brussels", Europe_Central },
            { "timezone.excity.Atlantic/Reykjavik", "Reykjav\u00edk" },
            { "timezone.excity.Asia/Kamchatka", "Kamchatka" },
            { "Europe/Warsaw", Europe_Central },
            { "Pacific/Yap", Truk },
            { "timezone.excity.Asia/Yakutsk", "Yakutsk" },
            { "timezone.excity.Africa/Djibouti", "Diob\u00f9taidh" },
            { "America/Tegucigalpa", America_Central },
            { "timezone.excity.America/Recife", "Recife" },
            { "timezone.excity.Pacific/Wallis", "Uallas" },
            { "America/Miquelon", Pierre_Miquelon },
            { "timezone.excity.Africa/Porto-Novo", "Porto-Novo" },
            { "timezone.excity.Antarctica/Palmer", "Palmer" },
            { "timezone.excity.Asia/Tashkent", "Tashkent" },
            { "timezone.excity.America/Argentina/San_Juan", "San Juan" },
            { "timezone.excity.Antarctica/Rothera", "Rothera" },
            { "timezone.excity.Asia/Shanghai", "Shanghai" },
            { "timezone.excity.America/Juneau", "Juneau" },
            { "timezone.excity.Pacific/Bougainville", "Bougainville" },
            { "timezone.excity.Pacific/Apia", "Apia" },
            { "Asia/Almaty", Kazakhstan_Eastern },
            { "timezone.excity.America/El_Salvador", "An Salbhador" },
            { "Asia/Dubai", Gulf },
            { "Europe/Isle_of_Man", GMT },
            { "America/Araguaina", Brasilia },
            { "timezone.excity.Pacific/Easter", "Rapa Nui" },
            { "ACT", Australia_Central },
            { "Asia/Novosibirsk", Novosibirsk },
            { "Africa/Tunis", Europe_Central },
            { "Pacific/Fakaofo", Tokelau },
            { "Indian/Comoro", Africa_Eastern },
            { "timezone.excity.Pacific/Niue", "Niue" },
            { "timezone.excity.America/Menominee", "Menominee" },
            { "Pacific/Port_Moresby", Papua_New_Guinea },
            { "timezone.excity.Australia/Lord_Howe", "Lord Howe" },
            { "Indian/Reunion", Reunion },
            { "Europe/Kaliningrad", Europe_Eastern },
            { "timezone.excity.Asia/Magadan", "Magadan" },
            { "timezone.excity.Pacific/Wake", "Wake" },
            { "timezone.excity.Atlantic/Canary", "Na h-Eileanan Can\u00e0rach" },
            { "Africa/Mogadishu", Africa_Eastern },
            { "timezone.excity.America/Glace_Bay", "Glasbaidh" },
            { "timezone.excity.Africa/Casablanca", "Casablanca" },
            { "Etc/GMT", GMT },
            { "timezone.excity.America/Kralendijk", "Kralendijk" },
            { "America/Manaus", Amazon },
            { "Africa/Freetown", GMT },
            { "Asia/Macau", China },
            { "Europe/Malta", Europe_Central },
            { "timezone.excity.Asia/Yerevan", "Yerevan" },
            { "timezone.excity.Europe/Kirov", "Kirov" },
            { "timezone.excity.America/Creston", "Creston" },
            { "timezone.excity.Africa/Cairo", "Cairo" },
            { "AET", Australia_Eastern },
            { "America/Argentina/Rio_Gallegos", Argentina },
            { "timezone.excity.Europe/Warsaw", "Warsaw" },
            { "Europe/Skopje", Europe_Central },
            { "Europe/Sarajevo", Europe_Central },
            { "America/Cordoba", Argentina },
            { "America/Regina", America_Central },
            { "Africa/Algiers", Europe_Central },
            { "Europe/Mariehamn", Europe_Eastern },
            { "America/Anguilla", Atlantic },
            { "Europe/Gibraltar", Europe_Central },
            { "Africa/Conakry", GMT },
            { "America/Havana", Cuba },
            { "timezone.excity.America/Edmonton", "Edmonton" },
            { "timezone.excity.Africa/Sao_Tome", "S\u00e3o Tom\u00e9" },
            { "timezone.excity.Africa/Abidjan", "Abidjan" },
            { "timezone.excity.America/Dawson", "Dawson" },
            { "America/Barbados", Atlantic },
            { "timezone.excity.America/Guadeloupe", "Guadalup" },
            { "timezone.excity.Africa/Freetown", "Freetown" },
            { "Atlantic/Cape_Verde", Cape_Verde },
            { "timezone.excity.America/Fortaleza", "Fortaleza" },
            { "timezone.excity.Europe/Vatican", "A\u2019 Bhatacan" },
            { "timezone.excity.Asia/Almaty", "Almaty" },
            { "timezone.excity.Asia/Tbilisi", "Tbilisi" },
            { "Pacific/Johnston", Hawaii_Aleutian },
            { "Europe/Ljubljana", Europe_Central },
            { "America/Sao_Paulo", Brasilia },
            { "timezone.excity.Europe/Andorra", "Andorra" },
            { "timezone.excity.Europe/Minsk", "Minsk" },
            { "America/Curacao", Atlantic },
            { "timezone.excity.Africa/Monrovia", "Monrovia" },
            { "America/Guayaquil", Ecuador },
            { "timezone.excity.Africa/Mbabane", "Mbabane" },
            { "timezone.excity.America/Rainy_River", "Rainy River" },
            { "timezone.excity.Asia/Beirut", "Beirut" },
            { "Europe/Chisinau", Europe_Eastern },
            { "America/Rankin_Inlet", America_Central },
            { "Australia/Eucla", Australia_CentralWestern },
            { "timezone.excity.Asia/Pontianak", "Pontianak" },
            { "timezone.excity.America/Adak", "Adak" },
            { "Europe/Zagreb", Europe_Central },
            { "timezone.excity.America/Toronto", "Toronto" },
            { "America/Port_of_Spain", Atlantic },
            { "Asia/Beirut", Europe_Eastern },
            { "timezone.excity.Asia/Baghdad", "Baghd\u0101d" },
            { "Africa/Sao_Tome", Africa_Western },
            { "Indian/Chagos", Indian_Ocean },
            { "timezone.excity.America/Metlakatla", "Metlakatla" },
            { "Asia/Yakutsk", Yakutsk },
            { "Pacific/Galapagos", Galapagos },
            { "timezone.excity.America/Maceio", "Macei\u00f3" },
            { "timezone.excity.America/Guayaquil", "Guayaquil" },
            { "Africa/Ndjamena", Africa_Western },
            { "timezone.excity.America/St_Vincent", "Naomh Bhionsant" },
            { "timezone.excity.America/Panama", "Panama" },
            { "timezone.excity.Europe/Simferopol", "Simferopol" },
            { "timezone.excity.Indian/Kerguelen", "Kergelenn" },
            { "CNT", Newfoundland },
            { "timezone.excity.Europe/Volgograd", "Volgograd" },
            { "timezone.excity.Europe/Monaco", "Monaco" },
            { "Asia/Tashkent", Uzbekistan },
            { "Africa/Ceuta", Europe_Central },
            { "timezone.excity.America/La_Paz", "La Paz" },
            { "timezone.excity.Africa/Tripoli", "Tripoli" },
            { "America/Swift_Current", America_Central },
            { "timezone.excity.Pacific/Enderbury", "Enderbury" },
            { "timezone.excity.Asia/Pyongyang", "Pyeongyang" },
            { "timezone.excity.Europe/Bucharest", "Bucharest" },
            { "America/Metlakatla", Alaska },
            { "timezone.excity.Europe/Athens", "An \u00c0ithne" },
            { "Africa/Djibouti", Africa_Eastern },
            { "Europe/Simferopol", Moscow },
            { "Europe/Sofia", Europe_Eastern },
            { "Africa/Nouakchott", GMT },
            { "timezone.excity.America/Porto_Velho", "Porto Velho" },
            { "Europe/Prague", Europe_Central },
            { "timezone.excity.America/Managua", "Managua" },
            { "America/Kralendijk", Atlantic },
            { "Indian/Christmas", Christmas },
            { "NET", Armenia },
            { "America/Inuvik", America_Mountain },
            { "America/Iqaluit", America_Eastern },
            { "Pacific/Funafuti", Tuvalu },
            { "Antarctica/Macquarie", Macquarie },
            { "timezone.excity.America/Montserrat", "Montsarat" },
            { "America/Moncton", Atlantic },
            { "timezone.excity.Europe/Copenhagen", "Beirbh" },
            { "timezone.excity.Australia/Darwin", "Darwin" },
            { "America/St_Vincent", Atlantic },
            { "PST8PDT", America_Pacific },
            { "timezone.excity.Asia/Jerusalem", "Ierusalam" },
            { "Atlantic/Faeroe", Europe_Western },
            { "timezone.excity.Asia/Riyadh", "Riyadh" },
            { "Antarctica/Casey", Casey },
            { "Europe/Copenhagen", Europe_Central },
            { "timezone.excity.Africa/Bangui", "Bangui" },
            { "timezone.excity.Africa/Lusaka", "Lusaka" },
            { "Atlantic/Azores", Azores },
            { "timezone.excity.Asia/Ust-Nera", "Ust-Nera" },
            { "timezone.excity.Asia/Damascus", "Damascus" },
            { "Pacific/Pitcairn", Pitcairn },
            { "timezone.excity.Pacific/Kosrae", "Kosrae" },
            { "America/Mazatlan", Mexico_Pacific },
            { "Pacific/Nauru", Nauru },
            { "timezone.excity.Africa/Brazzaville", "Brazzaville" },
            { "timezone.excity.America/Argentina/Rio_Gallegos", "R\u00edo Gallegos" },
            { "SystemV/MST7", America_Mountain },
            { "America/Dominica", Atlantic },
            { "timezone.excity.America/Bahia", "Bahia" },
            { "America/Mendoza", Argentina },
            { "timezone.excity.Asia/Tehran", "Tehr\u0101n" },
            { "timezone.excity.Pacific/Tahiti", "Tahiti" },
            { "timezone.excity.America/St_Kitts", "Naomh Cr\u00ecstean" },
            { "America/Asuncion", Paraguay },
            { "America/Boise", America_Mountain },
            { "Australia/Currie", Australia_Eastern },
            { "timezone.excity.Africa/Dar_es_Salaam", "D\u00e0r as-Sal\u00e0m" },
            { "timezone.excity.America/Monterrey", "Monterrey" },
            { "Pacific/Wake", Wake },
            { "timezone.excity.America/Belem", "Bel\u00e9m" },
            { "Asia/Chongqing", China },
            { "America/Indiana/Knox", America_Central },
            { "timezone.excity.Asia/Saigon", "Cathair Ho Chi Minh" },
            { "PLT", Pakistan },
            { "America/North_Dakota/Beulah", America_Central },
            { "timezone.excity.Asia/Makassar", "Makassar" },
            { "Pacific/Apia", Apia },
            { "Pacific/Niue", Niue },
            { "timezone.excity.Asia/Yekaterinburg", "Yekaterinburg" },
            { "CST", America_Central },
            { "timezone.excity.Europe/Sofia", "Sofiya" },
            { "MST7MDT", America_Mountain },
            { "America/Monterrey", America_Central },
            { "America/Nassau", America_Eastern },
            { "timezone.excity.Europe/Astrakhan", "Astrakhan" },
            { "timezone.excity.America/Yellowknife", "Yellowknife" },
            { "timezone.excity.Europe/Belgrade", "Belgrade" },
            { "timezone.excity.America/Puerto_Rico", "Porto R\u00ecceo" },
            { "timezone.excity.America/Denver", "Denver" },
            { "Indian/Mahe", Seychelles },
            { "Asia/Aqtobe", Kazakhstan_Western },
            { "CTT", China },
            { "timezone.excity.Asia/Gaza", "G\u00e0sa" },
            { "timezone.excity.Africa/Ceuta", "Ceuta" },
            { "Africa/Libreville", Africa_Western },
            { "America/Kentucky/Monticello", America_Eastern },
            { "America/Coral_Harbour", America_Eastern },
            { "Pacific/Marquesas", Marquesas },
            { "timezone.excity.Antarctica/Troll", "Troll" },
            { "America/Aruba", Atlantic },
            { "America/North_Dakota/Center", America_Central },
            { "PNT", America_Mountain },
            { "timezone.excity.Asia/Hong_Kong", "Hong Kong" },
            { "timezone.excity.America/Port-au-Prince", "Port-au-Prince" },
            { "America/Tijuana", America_Pacific },
            { "timezone.excity.Australia/Eucla", "Eucla" },
            { "timezone.excity.America/Mexico_City", "Cathair Mheagsago" },
            { "timezone.excity.Pacific/Kwajalein", "Kwajalein" },
            { "SystemV/YST9", Gambier },
            { "Africa/Douala", Africa_Western },
            { "America/Chihuahua", Mexico_Pacific },
            { "America/Ojinaga", America_Mountain },
            { "Asia/Hovd", Hovd },
            { "timezone.excity.Europe/Lisbon", "Lisbon" },
            { "timezone.excity.Pacific/Gambier", "Mangareva" },
            { "timezone.excity.America/Boise", "Boise" },
            { "America/Santiago", Chile },
            { "timezone.excity.Europe/Zaporozhye", "Zaporozhye" },
            { "Asia/Baku", Azerbaijan },
            { "ART", Europe_Eastern },
            { "America/Argentina/Ushuaia", Argentina },
            { "Atlantic/Reykjavik", GMT },
            { "Africa/Brazzaville", Africa_Western },
            { "Antarctica/DumontDUrville", DumontDUrville },
            { "timezone.excity.America/Dominica", "Doiminicea" },
            { "Asia/Taipei", Taipei },
            { "Antarctica/South_Pole", New_Zealand },
            { "timezone.excity.Africa/Kampala", "Kampala" },
            { "timezone.excity.Pacific/Chatham", "Chatham" },
            { "Africa/Dar_es_Salaam", Africa_Eastern },
            { "Africa/Addis_Ababa", Africa_Eastern },
            { "AST", Alaska },
            { "Europe/Uzhgorod", Europe_Eastern },
            { "timezone.excity.Asia/Colombo", "Colombo" },
            { "timezone.excity.Pacific/Port_Moresby", "Port Moresby" },
            { "America/Creston", America_Mountain },
            { "timezone.excity.America/Mendoza", "Mendoza" },
            { "Asia/Vientiane", Indochina },
            { "timezone.excity.America/Noronha", "Noronha" },
            { "timezone.excity.Asia/Sakhalin", "Sakhalin" },
            { "Pacific/Kiritimati", Line_Islands },
            { "timezone.excity.America/Nipigon", "Nipigon" },
            { "timezone.excity.Europe/Guernsey", "Ge\u00e0rnsaidh" },
            { "timezone.excity.America/Argentina/San_Luis", "San Luis" },
            { "timezone.excity.Europe/Riga", "R\u012bga" },
            { "timezone.excity.America/Araguaina", "Aragua\u00edna" },
            { "Atlantic/South_Georgia", South_Georgia },
            { "Europe/Lisbon", Europe_Western },
            { "Asia/Harbin", China },
            { "PRT", Atlantic },
            { "Asia/Novokuznetsk", Krasnoyarsk },
            { "timezone.excity.America/Cordoba", "C\u00f3rdoba" },
            { "timezone.excity.America/Cambridge_Bay", "Cambridge Bay" },
            { "CST6CDT", America_Central },
            { "Atlantic/Canary", Europe_Western },
            { "Asia/Kuwait", Arabian },
            { "SystemV/HST10",
                new String[] {
                    "Bun-\u00e0m nan Eileanan Hawai\u2019i \u2019s Aleutach",
                    "HST",
                    "T\u00ecde Samhraidh nan Eileanan Hawai\u2019i \u2019s Aleutach",
                    "HDT",
                    "\u00c0m nan Eileanan Hawai\u2019i \u2019s Aleutach",
                    "HST",
                }
            },
            { "Pacific/Efate", Vanuatu },
            { "Africa/Lome", GMT },
            { "America/Bogota", Colombia },
            { "America/Adak", Hawaii_Aleutian },
            { "Pacific/Norfolk", Norfolk },
            { "timezone.excity.America/Campo_Grande", "Campo Grande" },
            { "timezone.excity.Africa/Blantyre", "Blantyre" },
            { "timezone.excity.Europe/Malta", "Malta" },
            { "Pacific/Tarawa", Gilbert_Islands },
            { "timezone.excity.Asia/Qatar", "Catar" },
            { "timezone.excity.Australia/Sydney", "Sidni" },
            { "timezone.excity.America/Sitka", "Sitka" },
            { "PST", America_Pacific },
            { "SystemV/EST5", America_Eastern },
            { "timezone.excity.Antarctica/Davis", "Davis" },
            { "America/Santo_Domingo", Atlantic },
            { "timezone.excity.America/Aruba", "Ar\u00f9ba" },
            { "timezone.excity.Asia/Qyzylorda", "Q\u0131z\u0131lorda" },
            { "America/Glace_Bay", Atlantic },
            { "Asia/Magadan", Magadan },
            { "SystemV/PST8", Pitcairn },
            { "timezone.excity.Indian/Mauritius", "Na h-Eileanan Mhoiriseas" },
            { "America/St_Barthelemy", Atlantic },
            { "timezone.excity.America/Argentina/La_Rioja", "La Rioja" },
            { "Africa/Luanda", Africa_Western },
            { "timezone.excity.Europe/Mariehamn", "Mariehamn" },
            { "timezone.excity.America/St_Barthelemy", "Saint Barth\u00e9lemy" },
            { "timezone.excity.America/Santiago", "Santiago" },
            { "Asia/Muscat", Gulf },
            { "Asia/Bahrain", Arabian },
            { "Europe/Vilnius", Europe_Eastern },
            { "timezone.excity.Asia/Oral", "Oral" },
            { "America/Cancun", America_Eastern },
            { "timezone.excity.Asia/Manila", "Manila" },
            { "Pacific/Kosrae", Kosrae },
            { "Australia/Sydney", Australia_Eastern },
            { "timezone.excity.America/Indianapolis", "Indianapolis" },
            { "America/St_Lucia", Atlantic },
            { "Europe/Madrid", Europe_Central },
            { "America/Bahia_Banderas", America_Central },
            { "America/Montserrat", Atlantic },
            { "timezone.excity.Asia/Seoul", "Seoul" },
            { "Australia/Brisbane", Australia_Eastern },
            { "Indian/Mayotte", Africa_Eastern },
            { "timezone.excity.Europe/Busingen", "Busingen" },
            { "Europe/Volgograd", Moscow },
            { "America/Lower_Princes", Atlantic },
            { "timezone.excity.Europe/Istanbul", "Istanbul" },
            { "America/Rio_Branco", Acre },
            { "timezone.excity.Europe/Sarajevo", "Sarajevo" },
            { "America/Danmarkshavn", GMT },
            { "timezone.excity.Africa/Ndjamena", "N\u2019Djam\u00e9na" },
            { "timezone.excity.America/Punta_Arenas", "Punta Arenas" },
            { "timezone.excity.Africa/Kigali", "Kigali" },
            { "timezone.excity.Asia/Vladivostok", "Vladivostok" },
            { "Africa/Lusaka", Africa_Central },
            { "timezone.excity.Africa/Tunis", "Tunis" },
            { "timezone.excity.Asia/Macau", "Mac\u00e0thu" },
            { "America/Argentina/La_Rioja", Argentina },
            { "Africa/Dakar", GMT },
            { "SystemV/CST6CDT", America_Central },
            { "America/Tortola", Atlantic },
            { "America/Porto_Velho", Amazon },
            { "America/Scoresbysund", Greenland_Eastern },
            { "Asia/Kamchatka", Kamchatka },
            { "NST", New_Zealand },
            { "timezone.excity.Asia/Samarkand", "Samarkand" },
            { "Africa/Khartoum", Africa_Central },
            { "timezone.excity.Asia/Singapore", "Singeap\u00f2r" },
            { "timezone.excity.Australia/Adelaide", "Adelaide" },
            { "Europe/Belgrade", Europe_Central },
            { "timezone.excity.Europe/Vienna", "Vienna" },
            { "Africa/Bissau", GMT },
            { "timezone.excity.America/Cayman", "Caimean" },
            { "timezone.excity.Europe/Bratislava", "Bratislava" },
            { "Asia/Tehran", Iran },
            { "timezone.excity.America/Barbados", "Barbados" },
            { "timezone.excity.Asia/Nicosia", "Nicosia" },
            { "timezone.excity.Europe/Kiev", "Kiev" },
            { "timezone.excity.Asia/Dili", "Dili" },
            { "timezone.excity.Asia/Omsk", "Omsk" },
            { "timezone.excity.Africa/Bujumbura", "Bujumbura" },
            { "Pacific/Midway", Samoa },
            { "America/Jujuy", Argentina },
            { "timezone.excity.America/Mazatlan", "Mazatl\u00e1n" },
            { "timezone.excity.Asia/Brunei", "Br\u00f9naigh" },
            { "timezone.excity.Atlantic/Faeroe", "F\u00e0ro" },
            { "timezone.excity.America/Whitehorse", "Whitehorse" },
            { "timezone.excity.Asia/Kuching", "Kuching" },
            { "timezone.excity.America/Halifax", "Halifax" },
            { "timezone.excity.America/Merida", "M\u00e9rida" },
            { "America/Pangnirtung", America_Eastern },
            { "timezone.excity.Pacific/Palau", "Palabh" },
            { "Asia/Katmandu", Nepal },
            { "timezone.excity.Pacific/Auckland", "Auckland" },
            { "Africa/Niamey", Africa_Western },
            { "timezone.excity.Pacific/Norfolk", "Norfolk" },
            { "Asia/Tbilisi", Georgia },
            { "timezone.excity.Asia/Ashgabat", "A\u015fgabat" },
            { "timezone.excity.Pacific/Tongatapu", "Tongatapu" },
            { "timezone.excity.Antarctica/Syowa", "Syowa" },
            { "timezone.excity.America/Jamaica", "Diameuga" },
            { "timezone.excity.Pacific/Funafuti", "Funafuti" },
            { "timezone.excity.America/Hermosillo", "Hermosillo" },
            { "timezone.excity.Europe/Podgorica", "Podgorica" },
            { "timezone.excity.Indian/Reunion", "R\u00e9union" },
            { "timezone.excity.Pacific/Noumea", "Noumea" },
            { "timezone.excity.Asia/Aden", "Aden" },
            { "timezone.excity.Europe/Oslo", "Oslo" },
            { "America/Boa_Vista", Amazon },
            { "Asia/Atyrau", Kazakhstan_Western },
            { "Australia/Darwin", Australia_Central },
            { "Asia/Kuala_Lumpur", Malaysia },
            { "Europe/Bratislava", Europe_Central },
            { "timezone.excity.Atlantic/Stanley", "Stanley" },
            { "Pacific/Tongatapu", Tonga },
            { "timezone.excity.Asia/Rangoon", "Rangun" },
            { "timezone.excity.Asia/Thimphu", "Thimphu" },
            { "timezone.excity.Asia/Dubai", "Dubai" },
            { "Arctic/Longyearbyen", Europe_Central },
            { "timezone.excity.Asia/Kuala_Lumpur", "Kuala Lumpur" },
            { "America/Guadeloupe", Atlantic },
            { "Indian/Kerguelen", French_Southern },
            { "timezone.excity.Africa/Ouagadougou", "Ouagadougou" },
            { "timezone.excity.Africa/Gaborone", "Gaborone" },
            { "Asia/Anadyr", Anadyr },
            { "timezone.excity.Indian/Chagos", "Chagos" },
            { "timezone.excity.America/Iqaluit", "Iqaluit" },
            { "timezone.excity.Asia/Kabul", "Kabul" },
            { "America/Winnipeg", America_Central },
            { "timezone.excity.Europe/Amsterdam", "Amsterdam" },
            { "timezone.excity.Atlantic/Bermuda", "Bearm\u00f9da" },
            { "timezone.excity.Pacific/Saipan", "Saipan" },
            { "timezone.excity.Indian/Cocos", "Cocos" },
            { "timezone.excity.Australia/Currie", "Currie" },
            { "SystemV/AST4ADT", Atlantic },
            { "timezone.excity.Asia/Amman", "Amm\u0101n" },
            { "America/Toronto", America_Eastern },
            { "timezone.excity.Europe/Brussels", "A\u2019 Bhruiseal" },
            { "Australia/Lindeman", Australia_Eastern },
            { "timezone.excity.Atlantic/Madeira", "Madeira" },
            { "timezone.excity.Indian/Comoro", "Comoro" },
            { "timezone.excity.America/Boa_Vista", "Boa Vista" },
            { "Pacific/Majuro", Marshall_Islands },
            { "timezone.excity.Europe/Stockholm", "Stockholm" },
            { "timezone.excity.Europe/Samara", "Samara" },
            { "timezone.excity.America/Tijuana", "Tijuana" },
            { "timezone.excity.Indian/Maldives", "Na h-Eileanan Mhaladaibh" },
        };
        return data;
    }
}
