/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.dbcp.pool.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import java.util.TimerTask;
import org.apache.tomcat.dbcp.pool.BaseObjectPool;
import org.apache.tomcat.dbcp.pool.PoolUtils;
import org.apache.tomcat.dbcp.pool.PoolableObjectFactory;
import org.apache.tomcat.dbcp.pool.impl.CursorableLinkedList;
import org.apache.tomcat.dbcp.pool.impl.EvictionTimer;
import org.apache.tomcat.dbcp.pool.impl.GenericKeyedObjectPool;

public class GenericObjectPool<T>
extends BaseObjectPool<T> {
    public static final byte WHEN_EXHAUSTED_FAIL = 0;
    public static final byte WHEN_EXHAUSTED_BLOCK = 1;
    public static final byte WHEN_EXHAUSTED_GROW = 2;
    public static final int DEFAULT_MAX_IDLE = 8;
    public static final int DEFAULT_MIN_IDLE = 0;
    public static final int DEFAULT_MAX_ACTIVE = 8;
    public static final byte DEFAULT_WHEN_EXHAUSTED_ACTION = 1;
    public static final boolean DEFAULT_LIFO = true;
    public static final long DEFAULT_MAX_WAIT = -1L;
    public static final boolean DEFAULT_TEST_ON_BORROW = false;
    public static final boolean DEFAULT_TEST_ON_RETURN = false;
    public static final boolean DEFAULT_TEST_WHILE_IDLE = false;
    public static final long DEFAULT_TIME_BETWEEN_EVICTION_RUNS_MILLIS = -1L;
    public static final int DEFAULT_NUM_TESTS_PER_EVICTION_RUN = 3;
    public static final long DEFAULT_MIN_EVICTABLE_IDLE_TIME_MILLIS = 1800000L;
    public static final long DEFAULT_SOFT_MIN_EVICTABLE_IDLE_TIME_MILLIS = -1L;
    private int _maxIdle = 8;
    private int _minIdle = 0;
    private int _maxActive = 8;
    private long _maxWait = -1L;
    private byte _whenExhaustedAction = 1;
    private volatile boolean _testOnBorrow = false;
    private volatile boolean _testOnReturn = false;
    private boolean _testWhileIdle = false;
    private long _timeBetweenEvictionRunsMillis = -1L;
    private int _numTestsPerEvictionRun = 3;
    private long _minEvictableIdleTimeMillis = 1800000L;
    private long _softMinEvictableIdleTimeMillis = -1L;
    private boolean _lifo = true;
    private CursorableLinkedList<GenericKeyedObjectPool.ObjectTimestampPair<T>> _pool = null;
    private CursorableLinkedList.Cursor _evictionCursor = null;
    private PoolableObjectFactory<T> _factory = null;
    private ClassLoader _factoryClassLoader = null;
    private int _numActive = 0;
    private Evictor _evictor = null;
    private int _numInternalProcessing = 0;
    private final LinkedList<Latch<T>> _allocationQueue = new LinkedList();

    public GenericObjectPool() {
        this(null, 8, 1, -1L, 8, 0, false, false, -1L, 3, 1800000L, false);
    }

    public GenericObjectPool(PoolableObjectFactory<T> poolableObjectFactory) {
        this(poolableObjectFactory, 8, 1, -1L, 8, 0, false, false, -1L, 3, 1800000L, false);
    }

    public GenericObjectPool(PoolableObjectFactory<T> poolableObjectFactory, Config config) {
        this(poolableObjectFactory, config.maxActive, config.whenExhaustedAction, config.maxWait, config.maxIdle, config.minIdle, config.testOnBorrow, config.testOnReturn, config.timeBetweenEvictionRunsMillis, config.numTestsPerEvictionRun, config.minEvictableIdleTimeMillis, config.testWhileIdle, config.softMinEvictableIdleTimeMillis, config.lifo);
    }

    public GenericObjectPool(PoolableObjectFactory<T> poolableObjectFactory, int n) {
        this(poolableObjectFactory, n, 1, -1L, 8, 0, false, false, -1L, 3, 1800000L, false);
    }

    public GenericObjectPool(PoolableObjectFactory<T> poolableObjectFactory, int n, byte by, long l) {
        this(poolableObjectFactory, n, by, l, 8, 0, false, false, -1L, 3, 1800000L, false);
    }

    public GenericObjectPool(PoolableObjectFactory<T> poolableObjectFactory, int n, byte by, long l, boolean bl, boolean bl2) {
        this(poolableObjectFactory, n, by, l, 8, 0, bl, bl2, -1L, 3, 1800000L, false);
    }

    public GenericObjectPool(PoolableObjectFactory<T> poolableObjectFactory, int n, byte by, long l, int n2) {
        this(poolableObjectFactory, n, by, l, n2, 0, false, false, -1L, 3, 1800000L, false);
    }

    public GenericObjectPool(PoolableObjectFactory<T> poolableObjectFactory, int n, byte by, long l, int n2, boolean bl, boolean bl2) {
        this(poolableObjectFactory, n, by, l, n2, 0, bl, bl2, -1L, 3, 1800000L, false);
    }

    public GenericObjectPool(PoolableObjectFactory<T> poolableObjectFactory, int n, byte by, long l, int n2, boolean bl, boolean bl2, long l2, int n3, long l3, boolean bl3) {
        this(poolableObjectFactory, n, by, l, n2, 0, bl, bl2, l2, n3, l3, bl3);
    }

    public GenericObjectPool(PoolableObjectFactory<T> poolableObjectFactory, int n, byte by, long l, int n2, int n3, boolean bl, boolean bl2, long l2, int n4, long l3, boolean bl3) {
        this(poolableObjectFactory, n, by, l, n2, n3, bl, bl2, l2, n4, l3, bl3, -1L);
    }

    public GenericObjectPool(PoolableObjectFactory<T> poolableObjectFactory, int n, byte by, long l, int n2, int n3, boolean bl, boolean bl2, long l2, int n4, long l3, boolean bl3, long l4) {
        this(poolableObjectFactory, n, by, l, n2, n3, bl, bl2, l2, n4, l3, bl3, l4, true);
    }

    public GenericObjectPool(PoolableObjectFactory<T> poolableObjectFactory, int n, byte by, long l, int n2, int n3, boolean bl, boolean bl2, long l2, int n4, long l3, boolean bl3, long l4, boolean bl4) {
        this._factory = poolableObjectFactory;
        this._factoryClassLoader = Thread.currentThread().getContextClassLoader();
        this._maxActive = n;
        this._lifo = bl4;
        switch (by) {
            case 0: 
            case 1: 
            case 2: {
                this._whenExhaustedAction = by;
                break;
            }
            default: {
                throw new IllegalArgumentException("whenExhaustedAction " + by + " not recognized.");
            }
        }
        this._maxWait = l;
        this._maxIdle = n2;
        this._minIdle = n3;
        this._testOnBorrow = bl;
        this._testOnReturn = bl2;
        this._timeBetweenEvictionRunsMillis = l2;
        this._numTestsPerEvictionRun = n4;
        this._minEvictableIdleTimeMillis = l3;
        this._softMinEvictableIdleTimeMillis = l4;
        this._testWhileIdle = bl3;
        this._pool = new CursorableLinkedList();
        this.startEvictor(this._timeBetweenEvictionRunsMillis);
    }

    public synchronized int getMaxActive() {
        return this._maxActive;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMaxActive(int n) {
        GenericObjectPool genericObjectPool = this;
        synchronized (genericObjectPool) {
            this._maxActive = n;
        }
        this.allocate();
    }

    public synchronized byte getWhenExhaustedAction() {
        return this._whenExhaustedAction;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setWhenExhaustedAction(byte by) {
        GenericObjectPool genericObjectPool = this;
        synchronized (genericObjectPool) {
            switch (by) {
                case 0: 
                case 1: 
                case 2: {
                    this._whenExhaustedAction = by;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("whenExhaustedAction " + by + " not recognized.");
                }
            }
        }
        this.allocate();
    }

    public synchronized long getMaxWait() {
        return this._maxWait;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMaxWait(long l) {
        GenericObjectPool genericObjectPool = this;
        synchronized (genericObjectPool) {
            this._maxWait = l;
        }
        this.allocate();
    }

    public synchronized int getMaxIdle() {
        return this._maxIdle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMaxIdle(int n) {
        GenericObjectPool genericObjectPool = this;
        synchronized (genericObjectPool) {
            this._maxIdle = n;
        }
        this.allocate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMinIdle(int n) {
        GenericObjectPool genericObjectPool = this;
        synchronized (genericObjectPool) {
            this._minIdle = n;
        }
        this.allocate();
    }

    public synchronized int getMinIdle() {
        if (this._minIdle > this._maxIdle) {
            return this._maxIdle;
        }
        return this._minIdle;
    }

    public boolean getTestOnBorrow() {
        return this._testOnBorrow;
    }

    public void setTestOnBorrow(boolean bl) {
        this._testOnBorrow = bl;
    }

    public boolean getTestOnReturn() {
        return this._testOnReturn;
    }

    public void setTestOnReturn(boolean bl) {
        this._testOnReturn = bl;
    }

    public synchronized long getTimeBetweenEvictionRunsMillis() {
        return this._timeBetweenEvictionRunsMillis;
    }

    public synchronized void setTimeBetweenEvictionRunsMillis(long l) {
        this._timeBetweenEvictionRunsMillis = l;
        this.startEvictor(this._timeBetweenEvictionRunsMillis);
    }

    public synchronized int getNumTestsPerEvictionRun() {
        return this._numTestsPerEvictionRun;
    }

    public synchronized void setNumTestsPerEvictionRun(int n) {
        this._numTestsPerEvictionRun = n;
    }

    public synchronized long getMinEvictableIdleTimeMillis() {
        return this._minEvictableIdleTimeMillis;
    }

    public synchronized void setMinEvictableIdleTimeMillis(long l) {
        this._minEvictableIdleTimeMillis = l;
    }

    public synchronized long getSoftMinEvictableIdleTimeMillis() {
        return this._softMinEvictableIdleTimeMillis;
    }

    public synchronized void setSoftMinEvictableIdleTimeMillis(long l) {
        this._softMinEvictableIdleTimeMillis = l;
    }

    public synchronized boolean getTestWhileIdle() {
        return this._testWhileIdle;
    }

    public synchronized void setTestWhileIdle(boolean bl) {
        this._testWhileIdle = bl;
    }

    public synchronized boolean getLifo() {
        return this._lifo;
    }

    public synchronized void setLifo(boolean bl) {
        this._lifo = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setConfig(Config config) {
        GenericObjectPool genericObjectPool = this;
        synchronized (genericObjectPool) {
            this.setMaxIdle(config.maxIdle);
            this.setMinIdle(config.minIdle);
            this.setMaxActive(config.maxActive);
            this.setMaxWait(config.maxWait);
            this.setWhenExhaustedAction(config.whenExhaustedAction);
            this.setTestOnBorrow(config.testOnBorrow);
            this.setTestOnReturn(config.testOnReturn);
            this.setTestWhileIdle(config.testWhileIdle);
            this.setNumTestsPerEvictionRun(config.numTestsPerEvictionRun);
            this.setMinEvictableIdleTimeMillis(config.minEvictableIdleTimeMillis);
            this.setTimeBetweenEvictionRunsMillis(config.timeBetweenEvictionRunsMillis);
            this.setSoftMinEvictableIdleTimeMillis(config.softMinEvictableIdleTimeMillis);
            this.setLifo(config.lifo);
        }
        this.allocate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public T borrowObject() throws Exception {
        long l;
        byte by;
        long l2 = System.currentTimeMillis();
        Latch latch = new Latch();
        Object object = this;
        synchronized (object) {
            by = this._whenExhaustedAction;
            l = this._maxWait;
            this._allocationQueue.add(latch);
        }
        this.allocate();
        block47: while (true) {
            GenericObjectPool genericObjectPool;
            object = this;
            synchronized (object) {
                this.assertOpen();
            }
            if (latch.getPair() == null && !latch.mayCreate()) {
                switch (by) {
                    case 2: {
                        object = this;
                        synchronized (object) {
                            if (latch.getPair() == null && !latch.mayCreate()) {
                                this._allocationQueue.remove(latch);
                                ++this._numInternalProcessing;
                            }
                            break;
                        }
                    }
                    case 0: {
                        object = this;
                        synchronized (object) {
                            if (latch.getPair() != null || latch.mayCreate()) {
                                break;
                            }
                            this._allocationQueue.remove(latch);
                            throw new NoSuchElementException("Pool exhausted");
                        }
                    }
                    case 1: {
                        try {
                            object = latch;
                            synchronized (object) {
                                if (latch.getPair() != null || latch.mayCreate()) {
                                    break;
                                }
                                if (l <= 0L) {
                                    latch.wait();
                                } else {
                                    long l3 = System.currentTimeMillis() - l2;
                                    long l4 = l - l3;
                                    if (l4 > 0L) {
                                        latch.wait(l4);
                                    }
                                }
                            }
                            if (this.isClosed()) {
                                throw new IllegalStateException("Pool closed");
                            }
                        }
                        catch (InterruptedException interruptedException) {
                            boolean bl;
                            boolean bl2 = false;
                            genericObjectPool = this;
                            synchronized (genericObjectPool) {
                                if (latch.getPair() == null && !latch.mayCreate()) {
                                    this._allocationQueue.remove(latch);
                                } else if (latch.getPair() == null && latch.mayCreate()) {
                                    --this._numInternalProcessing;
                                    bl = true;
                                } else {
                                    --this._numInternalProcessing;
                                    ++this._numActive;
                                    this.returnObject(latch.getPair().getValue());
                                }
                            }
                            if (bl) {
                                this.allocate();
                            }
                            Thread.currentThread().interrupt();
                            throw interruptedException;
                        }
                        if (l <= 0L || System.currentTimeMillis() - l2 < l) continue block47;
                        object = this;
                        synchronized (object) {
                            if (latch.getPair() != null || latch.mayCreate()) {
                                break;
                            }
                            this._allocationQueue.remove(latch);
                            throw new NoSuchElementException("Timeout waiting for idle object");
                        }
                    }
                    default: {
                        throw new IllegalArgumentException("WhenExhaustedAction property " + by + " not recognized.");
                    }
                }
            }
            boolean bl = false;
            if (null == latch.getPair()) {
                try {
                    T t = this._factory.makeObject();
                    latch.setPair(new GenericKeyedObjectPool.ObjectTimestampPair<T>(t));
                    bl = true;
                }
                finally {
                    if (!bl) {
                        GenericObjectPool genericObjectPool2 = this;
                        synchronized (genericObjectPool2) {
                            --this._numInternalProcessing;
                        }
                        this.allocate();
                    }
                }
            }
            try {
                this._factory.activateObject(latch.getPair().getValue());
                if (this._testOnBorrow && !this._factory.validateObject(latch.getPair().getValue())) {
                    throw new Exception("ValidateObject failed");
                }
                GenericObjectPool genericObjectPool3 = this;
                synchronized (genericObjectPool3) {
                    --this._numInternalProcessing;
                    ++this._numActive;
                    return latch.getPair().getValue();
                }
            }
            catch (Throwable throwable) {
                PoolUtils.checkRethrow(throwable);
                try {
                    this._factory.destroyObject(latch.getPair().getValue());
                }
                catch (Throwable throwable2) {
                    PoolUtils.checkRethrow(throwable2);
                }
                genericObjectPool = this;
                synchronized (genericObjectPool) {
                    --this._numInternalProcessing;
                    if (!bl) {
                        latch.reset();
                        this._allocationQueue.add(0, latch);
                    }
                }
                this.allocate();
                if (bl) throw new NoSuchElementException("Could not create a validated object, cause: " + throwable.getMessage());
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void allocate() {
        Latch<T> latch;
        Latch<T> latch2;
        if (this.isClosed()) {
            return;
        }
        while (!this._pool.isEmpty() && !this._allocationQueue.isEmpty()) {
            latch2 = this._allocationQueue.removeFirst();
            ((Latch)latch2).setPair(this._pool.removeFirst());
            ++this._numInternalProcessing;
            latch = latch2;
            synchronized (latch) {
                latch2.notify();
            }
        }
        while (!(this._allocationQueue.isEmpty() || this._maxActive >= 0 && this._numActive + this._numInternalProcessing >= this._maxActive)) {
            latch2 = this._allocationQueue.removeFirst();
            ((Latch)latch2).setMayCreate(true);
            ++this._numInternalProcessing;
            latch = latch2;
            synchronized (latch) {
                latch2.notify();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void invalidateObject(T t) throws Exception {
        try {
            if (this._factory != null) {
                this._factory.destroyObject(t);
            }
        }
        finally {
            GenericObjectPool genericObjectPool = this;
            synchronized (genericObjectPool) {
                --this._numActive;
            }
            this.allocate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        ArrayList<GenericKeyedObjectPool.ObjectTimestampPair<T>> arrayList = new ArrayList<GenericKeyedObjectPool.ObjectTimestampPair<T>>();
        GenericObjectPool genericObjectPool = this;
        synchronized (genericObjectPool) {
            arrayList.addAll(this._pool);
            this._numInternalProcessing += this._pool._size;
            this._pool.clear();
        }
        this.destroy(arrayList, this._factory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void destroy(Collection<GenericKeyedObjectPool.ObjectTimestampPair<T>> collection, PoolableObjectFactory<T> poolableObjectFactory) {
        Iterator<GenericKeyedObjectPool.ObjectTimestampPair<T>> iterator = collection.iterator();
        while (iterator.hasNext()) {
            try {
                poolableObjectFactory.destroyObject(iterator.next().getValue());
            }
            catch (Exception exception) {}
            continue;
            finally {
                GenericObjectPool genericObjectPool = this;
                synchronized (genericObjectPool) {
                    --this._numInternalProcessing;
                }
                this.allocate();
            }
        }
    }

    @Override
    public synchronized int getNumActive() {
        return this._numActive;
    }

    @Override
    public synchronized int getNumIdle() {
        return this._pool.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void returnObject(T t) throws Exception {
        block7: {
            try {
                this.addObjectToPool(t, true);
            }
            catch (Exception exception) {
                if (this._factory == null) break block7;
                try {
                    this._factory.destroyObject(t);
                }
                catch (Exception exception2) {
                    // empty catch block
                }
                GenericObjectPool genericObjectPool = this;
                synchronized (genericObjectPool) {
                    --this._numActive;
                }
                this.allocate();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addObjectToPool(T t, boolean bl) throws Exception {
        boolean bl2 = true;
        if (this._testOnReturn && !this._factory.validateObject(t)) {
            bl2 = false;
        } else {
            this._factory.passivateObject(t);
        }
        boolean bl3 = !bl2;
        boolean bl4 = false;
        GenericObjectPool genericObjectPool = this;
        synchronized (genericObjectPool) {
            if (this.isClosed()) {
                bl3 = true;
            } else if (this._maxIdle >= 0 && this._pool.size() >= this._maxIdle) {
                bl3 = true;
            } else if (bl2) {
                if (this._lifo) {
                    this._pool.addFirst(new GenericKeyedObjectPool.ObjectTimestampPair<T>(t));
                } else {
                    this._pool.addLast(new GenericKeyedObjectPool.ObjectTimestampPair<T>(t));
                }
                if (bl) {
                    --this._numActive;
                }
                bl4 = true;
            }
        }
        if (bl4) {
            this.allocate();
        }
        if (bl3) {
            try {
                this._factory.destroyObject(t);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (bl) {
                genericObjectPool = this;
                synchronized (genericObjectPool) {
                    --this._numActive;
                }
                this.allocate();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws Exception {
        super.close();
        GenericObjectPool genericObjectPool = this;
        synchronized (genericObjectPool) {
            this.clear();
            this.startEvictor(-1L);
            while (this._allocationQueue.size() > 0) {
                Latch<T> latch;
                Latch<T> latch2 = latch = this._allocationQueue.removeFirst();
                synchronized (latch2) {
                    latch.notify();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public void setFactory(PoolableObjectFactory<T> poolableObjectFactory) throws IllegalStateException {
        ArrayList<GenericKeyedObjectPool.ObjectTimestampPair<T>> arrayList = new ArrayList<GenericKeyedObjectPool.ObjectTimestampPair<T>>();
        PoolableObjectFactory<T> poolableObjectFactory2 = this._factory;
        GenericObjectPool genericObjectPool = this;
        synchronized (genericObjectPool) {
            this.assertOpen();
            if (0 < this.getNumActive()) {
                throw new IllegalStateException("Objects are already active");
            }
            arrayList.addAll(this._pool);
            this._numInternalProcessing += this._pool._size;
            this._pool.clear();
            this._factory = poolableObjectFactory;
            this._factoryClassLoader = Thread.currentThread().getContextClassLoader();
        }
        this.destroy(arrayList, poolableObjectFactory2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void evict() throws Exception {
        this.assertOpen();
        GenericObjectPool genericObjectPool = this;
        synchronized (genericObjectPool) {
            if (this._pool.isEmpty()) {
                return;
            }
            if (null == this._evictionCursor) {
                this._evictionCursor = this._pool.cursor(this._lifo ? this._pool.size() : 0);
            }
        }
        int n = this.getNumTests();
        for (int i = 0; i < n; ++i) {
            GenericKeyedObjectPool.ObjectTimestampPair objectTimestampPair;
            GenericObjectPool genericObjectPool2 = this;
            synchronized (genericObjectPool2) {
                if (this._lifo && !this._evictionCursor.hasPrevious() || !this._lifo && !this._evictionCursor.hasNext()) {
                    this._evictionCursor.close();
                    this._evictionCursor = this._pool.cursor(this._lifo ? this._pool.size() : 0);
                }
                objectTimestampPair = this._lifo ? (GenericKeyedObjectPool.ObjectTimestampPair)this._evictionCursor.previous() : (GenericKeyedObjectPool.ObjectTimestampPair)this._evictionCursor.next();
                this._evictionCursor.remove();
                ++this._numInternalProcessing;
            }
            boolean bl = false;
            long l = System.currentTimeMillis() - objectTimestampPair.getTstamp();
            if (this.getMinEvictableIdleTimeMillis() > 0L && l > this.getMinEvictableIdleTimeMillis()) {
                bl = true;
            } else if (this.getSoftMinEvictableIdleTimeMillis() > 0L && l > this.getSoftMinEvictableIdleTimeMillis() && this.getNumIdle() + 1 > this.getMinIdle()) {
                bl = true;
            }
            if (this.getTestWhileIdle() && !bl) {
                boolean bl2 = false;
                try {
                    this._factory.activateObject(objectTimestampPair.getValue());
                    bl2 = true;
                }
                catch (Exception exception) {
                    bl = true;
                }
                if (bl2) {
                    if (!this._factory.validateObject(objectTimestampPair.getValue())) {
                        bl = true;
                    } else {
                        try {
                            this._factory.passivateObject(objectTimestampPair.getValue());
                        }
                        catch (Exception exception) {
                            bl = true;
                        }
                    }
                }
            }
            if (bl) {
                try {
                    this._factory.destroyObject(objectTimestampPair.getValue());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            GenericObjectPool genericObjectPool3 = this;
            synchronized (genericObjectPool3) {
                if (!bl) {
                    this._evictionCursor.add(objectTimestampPair);
                    if (this._lifo) {
                        this._evictionCursor.previous();
                    }
                }
                --this._numInternalProcessing;
                continue;
            }
        }
        this.allocate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensureMinIdle() throws Exception {
        int n = this.calculateDeficit(false);
        for (int i = 0; i < n && this.calculateDeficit(true) > 0; ++i) {
            try {
                this.addObject();
                continue;
            }
            finally {
                GenericObjectPool genericObjectPool = this;
                synchronized (genericObjectPool) {
                    --this._numInternalProcessing;
                }
                this.allocate();
            }
        }
    }

    private synchronized int calculateDeficit(boolean bl) {
        int n = this.getMinIdle() - this.getNumIdle();
        if (this._maxActive > 0) {
            int n2 = Math.max(0, this.getMaxActive() - this.getNumActive() - this.getNumIdle() - this._numInternalProcessing);
            n = Math.min(n, n2);
        }
        if (bl && n > 0) {
            ++this._numInternalProcessing;
        }
        return n;
    }

    @Override
    public void addObject() throws Exception {
        this.assertOpen();
        if (this._factory == null) {
            throw new IllegalStateException("Cannot add objects without a factory.");
        }
        T t = this._factory.makeObject();
        try {
            this.assertOpen();
            this.addObjectToPool(t, false);
        }
        catch (IllegalStateException illegalStateException) {
            try {
                this._factory.destroyObject(t);
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw illegalStateException;
        }
    }

    protected synchronized void startEvictor(long l) {
        if (null != this._evictor) {
            EvictionTimer.cancel(this._evictor);
            this._evictor = null;
        }
        if (l > 0L) {
            this._evictor = new Evictor();
            EvictionTimer.schedule(this._evictor, l, l);
        }
    }

    synchronized String debugInfo() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Active: ").append(this.getNumActive()).append("\n");
        stringBuffer.append("Idle: ").append(this.getNumIdle()).append("\n");
        stringBuffer.append("Idle Objects:\n");
        Iterator<GenericKeyedObjectPool.ObjectTimestampPair<T>> iterator = this._pool.iterator();
        long l = System.currentTimeMillis();
        while (iterator.hasNext()) {
            GenericKeyedObjectPool.ObjectTimestampPair<T> objectTimestampPair = iterator.next();
            stringBuffer.append("\t").append(objectTimestampPair.getValue()).append("\t").append(l - objectTimestampPair.getTstamp()).append("\n");
        }
        return stringBuffer.toString();
    }

    private int getNumTests() {
        if (this._numTestsPerEvictionRun >= 0) {
            return Math.min(this._numTestsPerEvictionRun, this._pool.size());
        }
        return (int)Math.ceil((double)this._pool.size() / Math.abs((double)this._numTestsPerEvictionRun));
    }

    private static final class Latch<T> {
        private GenericKeyedObjectPool.ObjectTimestampPair<T> _pair;
        private boolean _mayCreate = false;

        private Latch() {
        }

        private synchronized GenericKeyedObjectPool.ObjectTimestampPair<T> getPair() {
            return this._pair;
        }

        private synchronized void setPair(GenericKeyedObjectPool.ObjectTimestampPair<T> objectTimestampPair) {
            this._pair = objectTimestampPair;
        }

        private synchronized boolean mayCreate() {
            return this._mayCreate;
        }

        private synchronized void setMayCreate(boolean bl) {
            this._mayCreate = bl;
        }

        private synchronized void reset() {
            this._pair = null;
            this._mayCreate = false;
        }
    }

    public static class Config {
        public int maxIdle = 8;
        public int minIdle = 0;
        public int maxActive = 8;
        public long maxWait = -1L;
        public byte whenExhaustedAction = 1;
        public boolean testOnBorrow = false;
        public boolean testOnReturn = false;
        public boolean testWhileIdle = false;
        public long timeBetweenEvictionRunsMillis = -1L;
        public int numTestsPerEvictionRun = 3;
        public long minEvictableIdleTimeMillis = 1800000L;
        public long softMinEvictableIdleTimeMillis = -1L;
        public boolean lifo = true;
    }

    private class Evictor
    extends TimerTask {
        private Evictor() {
        }

        @Override
        public void run() {
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            try {
                Thread.currentThread().setContextClassLoader(GenericObjectPool.this._factoryClassLoader);
                try {
                    GenericObjectPool.this.evict();
                }
                catch (Exception exception) {
                }
                catch (OutOfMemoryError outOfMemoryError) {
                    outOfMemoryError.printStackTrace(System.err);
                }
                try {
                    GenericObjectPool.this.ensureMinIdle();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            finally {
                Thread.currentThread().setContextClassLoader(classLoader);
            }
        }
    }
}

