/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsDevice;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ActionListener;
import java.awt.event.KeyListener;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.font.TextLayout;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.beans.PropertyVetoException;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JDesktopPane;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JLayeredPane;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.swing.plaf.basic.BasicInternalFrameUI;
import net.sf.freecol.FreeCol;
import net.sf.freecol.client.ClientOptions;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.gui.CanvasMapEditorMouseListener;
import net.sf.freecol.client.gui.CanvasMouseListener;
import net.sf.freecol.client.gui.CanvasMouseMotionListener;
import net.sf.freecol.client.gui.ChatDisplay;
import net.sf.freecol.client.gui.ChoiceItem;
import net.sf.freecol.client.gui.DialogHandler;
import net.sf.freecol.client.gui.FrameMotionListener;
import net.sf.freecol.client.gui.FreeColFrame;
import net.sf.freecol.client.gui.GUIMessage;
import net.sf.freecol.client.gui.GrayLayer;
import net.sf.freecol.client.gui.MapViewer;
import net.sf.freecol.client.gui.SwingGUI;
import net.sf.freecol.client.gui.TilePopup;
import net.sf.freecol.client.gui.action.FreeColAction;
import net.sf.freecol.client.gui.panel.AboutPanel;
import net.sf.freecol.client.gui.panel.BuildQueuePanel;
import net.sf.freecol.client.gui.panel.CaptureGoodsDialog;
import net.sf.freecol.client.gui.panel.ChatPanel;
import net.sf.freecol.client.gui.panel.ChooseFoundingFatherDialog;
import net.sf.freecol.client.gui.panel.ClientOptionsDialog;
import net.sf.freecol.client.gui.panel.ColonyPanel;
import net.sf.freecol.client.gui.panel.ColopediaPanel;
import net.sf.freecol.client.gui.panel.ColorChooserPanel;
import net.sf.freecol.client.gui.panel.CompactLabourReport;
import net.sf.freecol.client.gui.panel.ConfirmDeclarationDialog;
import net.sf.freecol.client.gui.panel.DeclarationPanel;
import net.sf.freecol.client.gui.panel.DifficultyDialog;
import net.sf.freecol.client.gui.panel.DumpCargoDialog;
import net.sf.freecol.client.gui.panel.EditOptionDialog;
import net.sf.freecol.client.gui.panel.EditSettlementDialog;
import net.sf.freecol.client.gui.panel.EmigrationDialog;
import net.sf.freecol.client.gui.panel.EndTurnDialog;
import net.sf.freecol.client.gui.panel.ErrorPanel;
import net.sf.freecol.client.gui.panel.EuropePanel;
import net.sf.freecol.client.gui.panel.EventPanel;
import net.sf.freecol.client.gui.panel.FindSettlementPanel;
import net.sf.freecol.client.gui.panel.FirstContactDialog;
import net.sf.freecol.client.gui.panel.FreeColChoiceDialog;
import net.sf.freecol.client.gui.panel.FreeColConfirmDialog;
import net.sf.freecol.client.gui.panel.FreeColDialog;
import net.sf.freecol.client.gui.panel.FreeColPanel;
import net.sf.freecol.client.gui.panel.FreeColStringInputDialog;
import net.sf.freecol.client.gui.panel.GameOptionsDialog;
import net.sf.freecol.client.gui.panel.IndianSettlementPanel;
import net.sf.freecol.client.gui.panel.InformationPanel;
import net.sf.freecol.client.gui.panel.LabourData;
import net.sf.freecol.client.gui.panel.LoadDialog;
import net.sf.freecol.client.gui.panel.LoadingSavegameDialog;
import net.sf.freecol.client.gui.panel.MainPanel;
import net.sf.freecol.client.gui.panel.MapEditorTransformPanel;
import net.sf.freecol.client.gui.panel.MapGeneratorOptionsDialog;
import net.sf.freecol.client.gui.panel.MapSizeDialog;
import net.sf.freecol.client.gui.panel.MonarchDialog;
import net.sf.freecol.client.gui.panel.NegotiationDialog;
import net.sf.freecol.client.gui.panel.NewPanel;
import net.sf.freecol.client.gui.panel.Parameters;
import net.sf.freecol.client.gui.panel.ParametersDialog;
import net.sf.freecol.client.gui.panel.PreCombatDialog;
import net.sf.freecol.client.gui.panel.PurchasePanel;
import net.sf.freecol.client.gui.panel.RecruitPanel;
import net.sf.freecol.client.gui.panel.ReportCargoPanel;
import net.sf.freecol.client.gui.panel.ReportClassicColonyPanel;
import net.sf.freecol.client.gui.panel.ReportCompactColonyPanel;
import net.sf.freecol.client.gui.panel.ReportContinentalCongressPanel;
import net.sf.freecol.client.gui.panel.ReportEducationPanel;
import net.sf.freecol.client.gui.panel.ReportExplorationPanel;
import net.sf.freecol.client.gui.panel.ReportForeignAffairPanel;
import net.sf.freecol.client.gui.panel.ReportHighScoresPanel;
import net.sf.freecol.client.gui.panel.ReportHistoryPanel;
import net.sf.freecol.client.gui.panel.ReportIndianPanel;
import net.sf.freecol.client.gui.panel.ReportLabourDetailPanel;
import net.sf.freecol.client.gui.panel.ReportLabourPanel;
import net.sf.freecol.client.gui.panel.ReportMilitaryPanel;
import net.sf.freecol.client.gui.panel.ReportNavalPanel;
import net.sf.freecol.client.gui.panel.ReportPanel;
import net.sf.freecol.client.gui.panel.ReportProductionPanel;
import net.sf.freecol.client.gui.panel.ReportReligiousPanel;
import net.sf.freecol.client.gui.panel.ReportRequirementsPanel;
import net.sf.freecol.client.gui.panel.ReportTradePanel;
import net.sf.freecol.client.gui.panel.ReportTurnPanel;
import net.sf.freecol.client.gui.panel.RiverStyleDialog;
import net.sf.freecol.client.gui.panel.SaveDialog;
import net.sf.freecol.client.gui.panel.ScaleMapSizeDialog;
import net.sf.freecol.client.gui.panel.SelectAmountDialog;
import net.sf.freecol.client.gui.panel.SelectDestinationDialog;
import net.sf.freecol.client.gui.panel.SelectTributeAmountDialog;
import net.sf.freecol.client.gui.panel.ServerListPanel;
import net.sf.freecol.client.gui.panel.StartGamePanel;
import net.sf.freecol.client.gui.panel.StatisticsPanel;
import net.sf.freecol.client.gui.panel.StatusPanel;
import net.sf.freecol.client.gui.panel.TilePanel;
import net.sf.freecol.client.gui.panel.TradeRouteInputPanel;
import net.sf.freecol.client.gui.panel.TradeRoutePanel;
import net.sf.freecol.client.gui.panel.TrainPanel;
import net.sf.freecol.client.gui.panel.Utility;
import net.sf.freecol.client.gui.panel.VictoryDialog;
import net.sf.freecol.client.gui.panel.WarehouseDialog;
import net.sf.freecol.client.gui.panel.WorkProductionPanel;
import net.sf.freecol.common.ServerInfo;
import net.sf.freecol.common.i18n.Messages;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.DiplomaticTrade;
import net.sf.freecol.common.model.Direction;
import net.sf.freecol.common.model.FoundingFather;
import net.sf.freecol.common.model.FreeColGameObject;
import net.sf.freecol.common.model.FreeColObject;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.Goods;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.HighScore;
import net.sf.freecol.common.model.IndianSettlement;
import net.sf.freecol.common.model.Location;
import net.sf.freecol.common.model.ModelMessage;
import net.sf.freecol.common.model.Monarch;
import net.sf.freecol.common.model.PathNode;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Settlement;
import net.sf.freecol.common.model.Specification;
import net.sf.freecol.common.model.StringTemplate;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.TradeRoute;
import net.sf.freecol.common.model.TypeCountMap;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.model.UnitType;
import net.sf.freecol.common.option.IntegerOption;
import net.sf.freecol.common.option.Option;
import net.sf.freecol.common.option.OptionGroup;
import net.sf.freecol.common.resources.ResourceManager;

public final class Canvas
extends JDesktopPane {
    private static final Logger logger = Logger.getLogger(Canvas.class.getName());
    private static final int MAXTRY = 3;
    private final FreeColClient freeColClient;
    private final SwingGUI gui;
    private final GraphicsDevice graphicsDevice;
    private FreeColFrame frame;
    private boolean windowed;
    private MainPanel mainPanel;
    private final StartGamePanel startGamePanel;
    private final StatusPanel statusPanel;
    private final ChatPanel chatPanel;
    private final ChatDisplay chatDisplay;
    private final MapViewer mapViewer;
    private Point gotoDragPoint;
    private GrayLayer greyLayer;
    private final ServerListPanel serverListPanel;
    private Dimension oldSize = null;
    private boolean clientOptionsDialogShowing = false;
    private LoadingSavegameDialog loadingSavegameDialog;
    private FileFilter[] fileFilters = null;
    private final List<FreeColDialog<?>> dialogs = new ArrayList();

    Canvas(FreeColClient freeColClient, GraphicsDevice graphicsDevice, SwingGUI gui, Dimension desiredSize, MapViewer mapViewer) {
        this.freeColClient = freeColClient;
        this.gui = gui;
        this.graphicsDevice = graphicsDevice;
        this.chatDisplay = new ChatDisplay();
        this.mapViewer = mapViewer;
        Rectangle windowBounds = null;
        if (desiredSize == null) {
            if (graphicsDevice.isFullScreenSupported()) {
                this.windowed = false;
                logger.info("Full screen mode used.");
            } else {
                this.windowed = true;
                logger.warning("Full screen mode not supported.");
                System.err.println(Messages.message("client.fullScreen"));
            }
        } else {
            this.windowed = true;
            if (desiredSize.width > 0 && desiredSize.height > 0) {
                windowBounds = new Rectangle(desiredSize);
                logger.info("Windowed mode using desired window size of " + desiredSize);
            } else {
                logger.info("Windowed mode used.");
            }
        }
        this.setDoubleBuffered(true);
        this.setOpaque(false);
        this.setLayout(null);
        this.startGamePanel = new StartGamePanel(freeColClient);
        this.serverListPanel = new ServerListPanel(freeColClient, freeColClient.getConnectController());
        this.statusPanel = new StatusPanel(freeColClient);
        this.chatPanel = new ChatPanel(freeColClient);
        this.setFocusable(true);
        this.setFocusTraversalKeysEnabled(false);
        this.createKeyBindings();
        this.createFrame(null, windowBounds);
        mapViewer.startCursorBlinking();
        logger.info("Canvas created.");
    }

    boolean isWindowed() {
        return this.windowed;
    }

    void changeWindowedMode() {
        JMenuBar menuBar = null;
        Rectangle windowBounds = null;
        if (this.frame != null) {
            menuBar = this.frame.getJMenuBar();
            if (this.windowed) {
                windowBounds = this.frame.getBounds();
            }
            this.frame.setVisible(false);
            this.frame.dispose();
        }
        this.windowed = !this.windowed;
        this.createFrame(menuBar, windowBounds);
    }

    private void createFrame(JMenuBar menuBar, Rectangle windowBounds) {
        this.frame = new FreeColFrame(this.freeColClient, this.graphicsDevice, menuBar, this, this.windowed, windowBounds);
        this.updateSizes();
        this.frame.setVisible(true);
    }

    void startMapEditorGUI() {
        if (this.frame == null) {
            return;
        }
        this.gui.resetMapZoom();
        this.frame.setMapEditorMenuBar();
        this.showMapEditorTransformPanel();
        CanvasMapEditorMouseListener listener = new CanvasMapEditorMouseListener(this.freeColClient, this);
        this.addMouseListener(listener);
        this.addMouseMotionListener(listener);
    }

    void quit() throws Exception {
        if (this.frame != null && !this.windowed) {
            this.frame.exitFullScreen();
        }
    }

    void initializeInGame() {
        if (this.frame == null) {
            return;
        }
        this.frame.setInGameMenuBar();
    }

    void resetMenuBar() {
        if (this.frame == null) {
            return;
        }
        this.frame.resetMenuBar();
    }

    void updateMenuBar() {
        if (this.frame == null) {
            return;
        }
        this.frame.updateMenuBar();
    }

    boolean scrollMap(Direction direction) {
        return this.mapViewer.scrollMap(direction);
    }

    Tile convertToMapTile(int x, int y) {
        return this.mapViewer.convertToMapTile(x, y);
    }

    public int getViewMode() {
        return this.mapViewer.getViewMode();
    }

    Unit getActiveUnit() {
        return this.mapViewer.getActiveUnit();
    }

    void setCurrentPath(PathNode path) {
        this.mapViewer.setCurrentPath(path);
    }

    void updateCurrentPathForActiveUnit() {
        this.mapViewer.updateCurrentPathForActiveUnit();
    }

    Point getDragPoint() {
        return this.gotoDragPoint;
    }

    void setDragPoint(int x, int y) {
        this.gotoDragPoint = new Point(x, y);
    }

    boolean isGotoStarted() {
        return this.mapViewer.isGotoStarted();
    }

    PathNode getGotoPath() {
        return this.mapViewer.getGotoPath();
    }

    void setGotoPath(PathNode gotoPath) {
        this.mapViewer.setGotoPath(gotoPath);
        this.refresh();
    }

    void startGoto() {
        this.setCursor((Cursor)UIManager.get("cursor.go"));
        this.mapViewer.startGoto();
        this.refresh();
    }

    void stopGoto() {
        this.setCursor(null);
        this.mapViewer.stopGoto();
        this.refresh();
    }

    private JInternalFrame addAsFrame(JComponent comp, boolean toolBox, PopupPosition popupPosition, boolean resizable) {
        JInternalFrame f;
        int FRAME_EMPTY_SPACE = 60;
        JInternalFrame jInternalFrame = f = toolBox ? new ToolBoxFrame() : new JInternalFrame();
        if (f.getContentPane() instanceof JComponent) {
            JComponent c = (JComponent)f.getContentPane();
            c.setOpaque(false);
            c.setBorder(null);
        }
        if (comp.getBorder() != null) {
            if (comp.getBorder() instanceof EmptyBorder) {
                f.setBorder(Utility.blankBorder(10, 10, 10, 10));
            } else {
                f.setBorder(comp.getBorder());
                comp.setBorder(Utility.blankBorder(5, 5, 5, 5));
            }
        } else {
            f.setBorder(null);
        }
        FrameMotionListener fml = new FrameMotionListener(f);
        comp.addMouseMotionListener(fml);
        comp.addMouseListener(fml);
        if (f.getUI() instanceof BasicInternalFrameUI) {
            BasicInternalFrameUI biu = (BasicInternalFrameUI)f.getUI();
            biu.setNorthPane(null);
            biu.setSouthPane(null);
            biu.setWestPane(null);
            biu.setEastPane(null);
        }
        f.getContentPane().add(comp);
        f.setOpaque(false);
        f.pack();
        int width = f.getWidth();
        int height = f.getHeight();
        if (width > this.getWidth() - 60) {
            width = Math.min(width, this.getWidth());
        }
        if (height > this.getHeight() - 60) {
            height = Math.min(height, this.getHeight());
        }
        f.setSize(width, height);
        Point p = this.chooseLocation(comp, width, height, popupPosition);
        f.setLocation(p);
        this.add((Component)f, MODAL_LAYER);
        f.setName(comp.getClass().getSimpleName());
        f.setFrameIcon(null);
        f.setVisible(true);
        f.setResizable(resizable);
        try {
            f.setSelected(true);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        return f;
    }

    private void addCentered(Component comp, Integer i) {
        comp.setLocation((this.getWidth() - comp.getWidth()) / 2, (this.getHeight() - comp.getHeight()) / 2);
        this.add(comp, i);
    }

    private void addToCanvas(Component comp, Integer i) {
        if (comp != this.statusPanel && !(comp instanceof JMenuItem) && this.statusPanel.isVisible()) {
            this.removeFromCanvas(this.statusPanel);
        }
        try {
            super.add(comp, i == null ? JLayeredPane.DEFAULT_LAYER : i);
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "addToCanvas(" + comp + ", " + i + ") failed.", e);
        }
    }

    private Point chooseLocation(Component comp, int width, int height, PopupPosition popupPosition) {
        Point p = null;
        if (comp instanceof FreeColPanel && (p = this.getSavedPosition(comp)) != null && (p.getX() < 0.0 || p.getX() >= (double)(this.getWidth() - width) || p.getY() < 0.0 || p.getY() >= (double)(this.getHeight() - height))) {
            p = null;
        }
        int x = 0;
        int y = 0;
        if (p != null) {
            x = (int)p.getX();
            y = (int)p.getY();
        } else if (popupPosition != null) {
            switch (popupPosition) {
                case CENTERED: {
                    x = (this.getWidth() - width) / 2;
                    y = (this.getHeight() - height) / 2;
                    break;
                }
                case CENTERED_LEFT: {
                    x = (this.getWidth() - width) / 4;
                    y = (this.getHeight() - height) / 2;
                    break;
                }
                case CENTERED_RIGHT: {
                    x = (this.getWidth() - width) * 3 / 4;
                    y = (this.getHeight() - height) / 2;
                    break;
                }
                case ORIGIN: {
                    y = 0;
                    x = 0;
                }
            }
        }
        p = this.getClearSpace(x, y, width, height, 3);
        if (p != null && p.x >= 0 && p.x < this.getWidth() && p.y >= 0 && p.y < this.getHeight()) {
            x = p.x;
            y = p.y;
        }
        return new Point(x, y);
    }

    private void createKeyBindings() {
        for (Option option : this.freeColClient.getActionManager().getOptions()) {
            FreeColAction action = (FreeColAction)option;
            this.getInputMap().put(action.getAccelerator(), action.getId());
            this.getActionMap().put(action.getId(), action);
        }
    }

    private Point getClearSpace(int x, int y, int w, int h, int tries) {
        Rectangle bounds = this.getBounds();
        if (!bounds.contains(x, y)) {
            return null;
        }
        tries = 3 * tries + 1;
        ArrayList<Point> todo = new ArrayList<Point>();
        Point p = new Point(x, y);
        todo.add(p);
        List allComponents = Arrays.stream(this.getComponents()).filter(c -> !(c instanceof GrayLayer) && c.isValid()).collect(Collectors.toList());
        for (FreeColDialog<?> fcd : this.dialogs) {
            allComponents.add(fcd);
        }
        int bestScore = Integer.MAX_VALUE;
        Point best = p;
        while (!todo.isEmpty()) {
            p = (Point)todo.remove(0);
            Rectangle r = new Rectangle(p.x, p.y, w, h);
            if (!bounds.contains(r)) continue;
            int foundScore = 0;
            Component found = null;
            for (Component c2 : allComponents) {
                Rectangle rr;
                int score;
                if (!c2.getBounds().intersects(r) || foundScore >= (score = (int)Math.round((rr = c2.getBounds().intersection(r)).getWidth() * rr.getHeight()))) continue;
                foundScore = score;
                found = c2;
            }
            if (found == null) {
                return p;
            }
            if (bestScore > foundScore) {
                bestScore = foundScore;
                best = p;
            }
            if (--tries <= 0) break;
            int n = todo.size();
            int x0 = found.getX() + found.getWidth() + 1;
            int y0 = found.getY() + found.getHeight() + 1;
            int x1 = bounds.x + bounds.width - w - 1;
            int y1 = bounds.y + bounds.height - h - 1;
            int x2 = bounds.x;
            int y2 = bounds.y;
            boolean x0ok = bounds.contains(x0 + w, y);
            boolean y0ok = bounds.contains(x, y0 + h);
            boolean x1ok = bounds.contains(x1, y);
            boolean y1ok = bounds.contains(x, y1);
            todo.add(n, new Point(x0ok ? x0 : (x1ok ? x1 : x2), y0ok ? y0 : (y1ok ? y1 : y2)));
            todo.add(n, new Point(x, y0ok ? y0 : (y1ok ? y1 : y2)));
            todo.add(n, new Point(x0ok ? x0 : (x1ok ? x1 : x2), y));
        }
        return best;
    }

    private ColonyPanel getColonyPanel(Colony colony) {
        for (Component c1 : this.getComponents()) {
            if (!(c1 instanceof JInternalFrame)) continue;
            for (Component c2 : ((JInternalFrame)c1).getContentPane().getComponents()) {
                if (!(c2 instanceof ColonyPanel) || ((ColonyPanel)c2).getColony() != colony) continue;
                return (ColonyPanel)c2;
            }
        }
        return null;
    }

    private JInternalFrame getInternalFrame(Component c) {
        Component temp;
        for (temp = c; temp != null && !(temp instanceof JInternalFrame); temp = temp.getParent()) {
        }
        return (JInternalFrame)temp;
    }

    private PopupPosition setOffsetFocus(Tile tile) {
        if (tile == null) {
            return PopupPosition.CENTERED;
        }
        int where = this.mapViewer.setOffsetFocus(tile);
        return where > 0 ? PopupPosition.CENTERED_LEFT : (where < 0 ? PopupPosition.CENTERED_RIGHT : PopupPosition.CENTERED);
    }

    private Point getSavedPosition(Component comp) {
        ClientOptions co = this.freeColClient.getClientOptions();
        if (co == null) {
            return null;
        }
        try {
            if (!co.getBoolean("model.option.rememberPanelPositions")) {
                return null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        String className = comp.getClass().getName();
        try {
            return new Point(co.getInteger(className + ".x"), co.getInteger(className + ".y"));
        }
        catch (Exception e) {
            return null;
        }
    }

    private Dimension getSavedSize(Component comp) {
        ClientOptions co = this.freeColClient.getClientOptions();
        if (co == null) {
            return null;
        }
        try {
            if (!co.getBoolean("model.option.rememberPanelSizes")) {
                return null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        String className = comp.getClass().getName();
        try {
            return new Dimension(co.getInteger(className + ".w"), co.getInteger(className + ".h"));
        }
        catch (Exception e) {
            return null;
        }
    }

    private FileFilter[] getFileFilters() {
        if (this.fileFilters == null) {
            String s = Messages.message("filter.savedGames");
            this.fileFilters = new FileFilter[]{new FileNameExtensionFilter(s, "fsg")};
        }
        return this.fileFilters;
    }

    private void notifyClose(Component c, JInternalFrame frame) {
        if (frame == null) {
            return;
        }
        if (c instanceof FreeColPanel) {
            FreeColPanel fcp = (FreeColPanel)c;
            fcp.firePropertyChange("closing", false, true);
            this.savePosition(fcp, frame.getLocation());
            this.saveSize(fcp, fcp.getSize());
        }
    }

    private void removeEuropeanSubpanels() {
        FreeColPanel panel = this.getExistingFreeColPanel(RecruitPanel.class);
        if (panel != null) {
            this.removeFromCanvas(panel);
        }
        if ((panel = this.getExistingFreeColPanel(PurchasePanel.class)) != null) {
            this.removeFromCanvas(panel);
        }
        if ((panel = this.getExistingFreeColPanel(TrainPanel.class)) != null) {
            this.removeFromCanvas(panel);
        }
    }

    private void saveInteger(String className, String key, int value) {
        if (this.freeColClient != null && this.freeColClient.getClientOptions() != null) {
            Option o = this.freeColClient.getClientOptions().getOption(className + key);
            if (o == null) {
                Specification specification = this.freeColClient.getGame() == null ? null : this.freeColClient.getGame().getSpecification();
                IntegerOption io = new IntegerOption(className + key, specification);
                io.setValue(value);
                this.freeColClient.getClientOptions().add(io);
            } else if (o instanceof IntegerOption) {
                ((IntegerOption)o).setValue(value);
            }
        }
    }

    private void savePosition(Component comp, Point position) {
        try {
            if (!this.freeColClient.getClientOptions().getBoolean("model.option.rememberPanelPositions")) {
                return;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        String className = comp.getClass().getName();
        this.saveInteger(className, ".x", position.x);
        this.saveInteger(className, ".y", position.y);
    }

    private void saveSize(Component comp, Dimension size) {
        try {
            if (!this.freeColClient.getClientOptions().getBoolean("model.option.rememberPanelSizes")) {
                return;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        String className = comp.getClass().getName();
        this.saveInteger(className, ".w", size.width);
        this.saveInteger(className, ".h", size.height);
    }

    private void restartBlinking() {
        if (this.mapViewer.getViewMode() != 0) {
            return;
        }
        for (FreeColDialog<?> f : this.dialogs) {
            if (!f.isModal()) continue;
            return;
        }
        this.mapViewer.restartBlinking();
    }

    private void stopBlinking() {
        this.mapViewer.stopBlinking();
    }

    private <T> T showFreeColDialog(FreeColDialog<T> freeColDialog, Tile tile) {
        this.viewFreeColDialog(freeColDialog, tile);
        T response = freeColDialog.getResponse();
        this.remove(freeColDialog);
        this.dialogRemove(freeColDialog);
        if (freeColDialog.isModal()) {
            this.restartBlinking();
        }
        return response;
    }

    private void showFreeColPanel(FreeColPanel panel, Tile tile, boolean resizable) {
        this.showSubPanel(panel, this.setOffsetFocus(tile), resizable);
    }

    private void showSubPanel(FreeColPanel panel, boolean resizable) {
        this.showSubPanel(panel, PopupPosition.CENTERED, resizable);
    }

    private void showSubPanel(FreeColPanel panel, PopupPosition popupPosition, boolean resizable) {
        this.repaint();
        this.addAsFrame(panel, false, popupPosition, resizable);
        panel.requestFocus();
    }

    @Override
    public Component add(Component comp) {
        this.add(comp, JLayeredPane.DEFAULT_LAYER);
        return comp;
    }

    public void add(Component comp, Integer i) {
        this.addToCanvas(comp, i);
        this.gui.updateMenuBar();
    }

    void closeMenus() {
        for (JInternalFrame frame : this.getAllFrames()) {
            for (Component c : frame.getContentPane().getComponents()) {
                this.notifyClose(c, frame);
            }
            frame.dispose();
        }
        while (!this.dialogs.isEmpty()) {
            FreeColDialog<?> dialog = this.dialogs.remove(0);
            dialog.dispose();
        }
    }

    void closeMainPanel() {
        if (this.mainPanel != null) {
            this.remove(this.mainPanel);
            this.mainPanel = null;
        }
    }

    void closeStatusPanel() {
        if (this.statusPanel.isVisible()) {
            this.remove(this.statusPanel);
        }
    }

    boolean containsInGameComponents() {
        KeyListener[] keyListeners = this.getKeyListeners();
        if (keyListeners.length > 0) {
            return true;
        }
        MouseListener[] mouseListeners = this.getMouseListeners();
        if (mouseListeners.length > 0) {
            return true;
        }
        MouseMotionListener[] mouseMotionListeners = this.getMouseMotionListeners();
        return mouseMotionListeners.length > 0;
    }

    void displayChatMessage(GUIMessage message) {
        this.chatDisplay.addMessage(message);
        this.repaint(0, 0, this.getWidth(), this.getHeight());
    }

    private void dialogAdd(FreeColDialog<?> fcd) {
        this.dialogs.add(fcd);
    }

    void dialogRemove(FreeColDialog<?> fcd) {
        this.dialogs.remove(fcd);
    }

    private <T extends FreeColPanel> T getExistingFreeColPanel(Class<T> type) {
        for (Component c1 : this.getComponents()) {
            if (!(c1 instanceof JInternalFrame)) continue;
            for (Component c2 : ((JInternalFrame)c1).getContentPane().getComponents()) {
                try {
                    FreeColPanel ret = (FreeColPanel)type.cast(c2);
                    if (ret == null) continue;
                    JInternalFrame jif = (JInternalFrame)c1;
                    SwingUtilities.invokeLater(() -> {
                        jif.toFront();
                        jif.repaint();
                    });
                    return (T)ret;
                }
                catch (ClassCastException classCastException) {
                    // empty catch block
                }
            }
        }
        return null;
    }

    LoadingSavegameDialog getLoadingSavegameDialog() {
        return this.loadingSavegameDialog;
    }

    Component getShowingSubPanel() {
        for (Component c : this.getComponents()) {
            if (c instanceof ToolBoxFrame) continue;
            if (c instanceof JInternalFrame) {
                return c;
            }
            if (!(c instanceof JInternalFrame.JDesktopIcon)) continue;
            return c;
        }
        return null;
    }

    boolean isClientOptionsDialogShowing() {
        return this.clientOptionsDialogShowing;
    }

    boolean isMapboardActionsEnabled() {
        return !this.isShowingSubPanel();
    }

    boolean isShowingSubPanel() {
        return this.getShowingSubPanel() != null;
    }

    void refresh() {
        this.repaint(0, 0, this.getWidth(), this.getHeight());
    }

    public void removeFromCanvas(Component comp) {
        if (comp == null) {
            return;
        }
        Rectangle updateBounds = comp.getBounds();
        JInternalFrame frame = this.getInternalFrame(comp);
        this.notifyClose(comp, frame);
        if (frame != null && frame != comp) {
            frame.dispose();
        } else {
            try {
                super.remove(comp);
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "Java crash", e);
            }
        }
        this.repaint(updateBounds.x, updateBounds.y, updateBounds.width, updateBounds.height);
    }

    void removeInGameComponents() {
        MouseListener[] mouseListeners;
        KeyListener[] keyListeners;
        for (KeyListener keyListener : keyListeners = this.getKeyListeners()) {
            this.removeKeyListener(keyListener);
        }
        for (MouseListener mouseListener : mouseListeners = this.getMouseListeners()) {
            this.removeMouseListener(mouseListener);
        }
        MouseMotionListener[] mouseMotionListeners = this.getMouseMotionListeners();
        for (MouseMotionListener mouseMotionListener : mouseMotionListeners) {
            this.removeMouseMotionListener(mouseMotionListener);
        }
        for (Component c : this.getComponents()) {
            this.removeFromCanvas(c);
        }
    }

    void restoreSavedSize(Component comp, Dimension d) {
        Dimension pref = comp.getPreferredSize();
        Dimension sugg = d == null ? pref : d;
        boolean save = false;
        Dimension size = this.getSavedSize(comp);
        if (size == null) {
            size = new Dimension(pref);
            save = true;
        }
        if (size.width < sugg.width) {
            size.width = sugg.width;
            save = true;
        }
        if (size.height < sugg.height) {
            size.height = sugg.height;
            save = true;
        }
        if (size.width < pref.width) {
            size.width = pref.width;
            save = true;
        }
        if (size.height < pref.height) {
            size.height = pref.height;
            save = true;
        }
        if (save) {
            this.saveSize(comp, size);
        }
        if (!pref.equals(size)) {
            comp.setPreferredSize(size);
        }
    }

    void returnToTitle() {
        this.removeInGameComponents();
        this.showMainPanel(null);
        this.repaint();
    }

    void setupMouseListeners() {
        this.addMouseListener(new CanvasMouseListener(this.freeColClient, this));
        this.addMouseMotionListener(new CanvasMouseMotionListener(this.freeColClient, this));
    }

    private void updateSizes() {
        if (this.oldSize == null || this.oldSize.width != this.getWidth() || this.oldSize.height != this.getHeight()) {
            this.gui.updateMapControlsInCanvas();
            this.mapViewer.setSize(this.getSize());
            this.mapViewer.forceReposition();
            this.oldSize = this.getSize();
        }
    }

    @Override
    public void paintComponent(Graphics g) {
        this.updateSizes();
        Graphics2D g2d = (Graphics2D)g;
        this.chatDisplay.removeOldMessages();
        Dimension size = this.getSize();
        if (this.freeColClient.getGame() != null && this.freeColClient.getGame().getMap() != null && this.mapViewer.getFocus() != null && this.freeColClient.isInGame()) {
            this.mapViewer.displayMap(g2d);
            if (!this.freeColClient.isMapEditor() && this.freeColClient.getGame() != null && !this.freeColClient.currentPlayerIsMyPlayer()) {
                if (this.greyLayer == null) {
                    this.greyLayer = new GrayLayer(this.freeColClient);
                }
                if (this.greyLayer.getParent() == null) {
                    this.add((Component)this.greyLayer, JLayeredPane.DRAG_LAYER);
                }
                this.greyLayer.setBounds(0, 0, size.width, size.height);
                this.greyLayer.setPlayer(this.freeColClient.getGame().getCurrentPlayer());
            } else if (this.greyLayer != null && this.greyLayer.getParent() != null) {
                this.removeFromCanvas(this.greyLayer);
            }
            this.chatDisplay.display(g2d, this.mapViewer.getImageLibrary(), size);
        } else if (!this.freeColClient.isMapEditor()) {
            String bgImageKey = "image.flavor.Canvas.map";
            if (ResourceManager.hasImageResource("image.flavor.Canvas.map")) {
                BufferedImage bgImage = ResourceManager.getImage("image.flavor.Canvas.map");
                g2d.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
                g2d.drawImage(bgImage, 0, 0, size.width, size.height, this);
                String versionStr = "v. " + FreeCol.getVersion();
                Font oldFont = g2d.getFont();
                Color oldColor = g2d.getColor();
                Font newFont = oldFont.deriveFont(1);
                TextLayout layout = new TextLayout(versionStr, newFont, g2d.getFontRenderContext());
                Rectangle2D bounds = layout.getBounds();
                float x = (float)size.width - (float)bounds.getWidth() - 5.0f;
                float y = (float)size.height - (float)bounds.getHeight();
                g2d.setColor(Color.white);
                layout.draw(g2d, x, y);
                g2d.setFont(oldFont);
                g2d.setColor(oldColor);
            } else {
                g2d.setColor(Color.BLACK);
                g2d.fillRect(0, 0, size.width, size.height);
            }
        } else {
            g2d.setColor(Color.BLACK);
            g2d.fillRect(0, 0, size.width, size.height);
        }
    }

    @Override
    public void remove(Component comp) {
        this.removeFromCanvas(comp);
        this.gui.updateMenuBar();
        if (comp != this.statusPanel && !this.isShowingSubPanel()) {
            this.requestFocus();
        }
    }

    void refreshPlayersTable() {
        this.startGamePanel.refreshPlayersTable();
    }

    void updateGameOptions() {
        this.startGamePanel.updateGameOptions();
    }

    void updateMapGeneratorOptions() {
        this.startGamePanel.updateMapGeneratorOptions();
    }

    <T> T showChoiceDialog(Tile tile, Object obj, ImageIcon icon, String cancelKey, List<ChoiceItem<T>> choices) {
        FreeColChoiceDialog<T> fcd = new FreeColChoiceDialog<T>(this.freeColClient, (JFrame)this.frame, true, obj, icon, cancelKey, choices);
        return this.showFreeColDialog(fcd, tile);
    }

    boolean showConfirmDialog(Tile tile, Object obj, ImageIcon icon, String okKey, String cancelKey) {
        FreeColConfirmDialog fcd = new FreeColConfirmDialog(this.freeColClient, (JFrame)this.frame, true, obj, icon, okKey, cancelKey);
        return this.showFreeColDialog(fcd, tile);
    }

    String showInputDialog(Tile tile, StringTemplate template, String defaultValue, String okKey, String cancelKey) {
        FreeColStringInputDialog fcd = new FreeColStringInputDialog(this.freeColClient, (JFrame)this.frame, true, Messages.message(template), defaultValue, okKey, cancelKey);
        return this.showFreeColDialog(fcd, tile);
    }

    private <T> void viewFreeColDialog(FreeColDialog<T> freeColDialog, Tile tile) {
        PopupPosition pp = this.setOffsetFocus(tile);
        if (!freeColDialog.isModal()) {
            int canvasWidth = this.getWidth();
            int dialogWidth = freeColDialog.getWidth();
            if (dialogWidth * 2 <= canvasWidth) {
                Point location = freeColDialog.getLocation();
                if (pp == PopupPosition.CENTERED_LEFT) {
                    freeColDialog.setLocation(location.x - canvasWidth / 4, location.y);
                } else if (pp == PopupPosition.CENTERED_RIGHT) {
                    freeColDialog.setLocation(location.x + canvasWidth / 4, location.y);
                }
            }
        }
        this.dialogAdd(freeColDialog);
        if (freeColDialog.isModal()) {
            this.stopBlinking();
        }
        freeColDialog.requestFocus();
        freeColDialog.setVisible(true);
    }

    void removeTradeRoutePanel(TradeRoutePanel panel) {
        this.remove(panel);
        TradeRouteInputPanel trip = this.getExistingFreeColPanel(TradeRouteInputPanel.class);
        if (trip != null) {
            trip.cancelTradeRoute();
        }
    }

    void showAboutPanel() {
        this.showSubPanel(new AboutPanel(this.freeColClient), false);
    }

    void showBuildQueuePanel(Colony colony) {
        BuildQueuePanel panel = this.getExistingFreeColPanel(BuildQueuePanel.class);
        if (panel == null || panel.getColony() != colony) {
            this.showSubPanel(new BuildQueuePanel(this.freeColClient, colony), true);
        }
    }

    void showBuildQueuePanel(Colony colony, Runnable callBack) {
        BuildQueuePanel panel = new BuildQueuePanel(this.freeColClient, colony);
        panel.addClosingCallback(callBack);
        this.showSubPanel(panel, true);
    }

    void showCaptureGoodsDialog(Unit unit, List<Goods> gl, DialogHandler<List<Goods>> handler) {
        SwingUtilities.invokeLater(new DialogCallback<List<Goods>>(new CaptureGoodsDialog(this.freeColClient, this.frame, unit, gl), null, handler));
    }

    void showChatPanel() {
        if (this.freeColClient.isSinglePlayer()) {
            return;
        }
        this.showSubPanel(this.chatPanel, true);
    }

    void showChooseFoundingFatherDialog(List<FoundingFather> ffs, DialogHandler<FoundingFather> handler) {
        SwingUtilities.invokeLater(new DialogCallback<FoundingFather>(new ChooseFoundingFatherDialog(this.freeColClient, this.frame, ffs), null, handler));
    }

    OptionGroup showClientOptionsDialog() {
        ClientOptionsDialog dialog = new ClientOptionsDialog(this.freeColClient, this.frame);
        OptionGroup group = null;
        this.clientOptionsDialogShowing = true;
        try {
            group = this.showFreeColDialog(dialog, null);
        }
        finally {
            this.clientOptionsDialogShowing = false;
        }
        return group;
    }

    public ColonyPanel showColonyPanel(Colony colony, Unit unit) {
        ColonyPanel panel = this.getColonyPanel(colony);
        if (panel == null) {
            panel = new ColonyPanel(this.freeColClient, colony);
            this.showFreeColPanel(panel, colony.getTile(), true);
        } else {
            panel.requestFocus();
        }
        if (unit != null) {
            panel.setSelectedUnit(unit);
        }
        return panel;
    }

    void showColopediaPanel(String nodeId) {
        this.showSubPanel(new ColopediaPanel(this.freeColClient, nodeId), true);
    }

    ColorChooserPanel showColorChooserPanel(ActionListener al) {
        ColorChooserPanel ccp = new ColorChooserPanel(this.freeColClient, al);
        this.showFreeColPanel(ccp, null, false);
        return ccp;
    }

    void showCompactLabourReport() {
        CompactLabourReport details = new CompactLabourReport(this.freeColClient);
        details.initialize();
        this.showSubPanel(details, false);
    }

    void showCompactLabourReport(LabourData.UnitData unitData) {
        CompactLabourReport details = new CompactLabourReport(this.freeColClient, unitData);
        details.initialize();
        this.showSubPanel(details, false);
    }

    List<String> showConfirmDeclarationDialog() {
        return this.showFreeColDialog(new ConfirmDeclarationDialog(this.freeColClient, this.frame), null);
    }

    void showDeclarationPanel() {
        this.showSubPanel(new DeclarationPanel(this.freeColClient), PopupPosition.CENTERED, false);
    }

    OptionGroup showDifficultyDialog(Specification spec, OptionGroup group, boolean editable) {
        return this.showFreeColDialog(new DifficultyDialog(this.freeColClient, this.frame, spec, group, editable), null);
    }

    void showDumpCargoDialog(Unit unit, DialogHandler<List<Goods>> handler) {
        SwingUtilities.invokeLater(new DialogCallback<List<Goods>>(new DumpCargoDialog(this.freeColClient, this.frame, unit), unit.getTile(), handler));
    }

    boolean showEditOptionDialog(Option option) {
        return this.showFreeColDialog(new EditOptionDialog(this.freeColClient, this.frame, option), null);
    }

    void showEditSettlementDialog(IndianSettlement settlement) {
        this.showFreeColDialog(new EditSettlementDialog(this.freeColClient, this.frame, settlement), null);
    }

    void showEmigrationDialog(Player player, boolean fountainOfYouth, DialogHandler<Integer> handler) {
        SwingUtilities.invokeLater(new DialogCallback<Integer>(new EmigrationDialog(this.freeColClient, this.frame, player.getEurope(), fountainOfYouth), null, handler));
    }

    void showEndTurnDialog(List<Unit> units, DialogHandler<Boolean> handler) {
        SwingUtilities.invokeLater(new DialogCallback<Boolean>(new EndTurnDialog(this.freeColClient, this.frame, units), null, handler));
    }

    void showErrorMessage(String messageId) {
        this.showErrorMessage(messageId, "Unspecified error: " + messageId);
    }

    void showErrorMessage(String messageId, String message) {
        String display = null;
        if (messageId != null) {
            display = Messages.message(messageId);
        }
        if (display == null || display.isEmpty()) {
            display = message;
        }
        ErrorPanel errorPanel = new ErrorPanel(this.freeColClient, display);
        this.showSubPanel(errorPanel, true);
    }

    void showEuropePanel() {
        if (this.freeColClient.getGame() == null) {
            return;
        }
        EuropePanel panel = this.getExistingFreeColPanel(EuropePanel.class);
        if (panel == null) {
            panel = new EuropePanel(this.freeColClient, this.getHeight() > 780);
            panel.addClosingCallback(() -> this.removeEuropeanSubpanels());
            this.showSubPanel(panel, true);
        }
    }

    void showEventPanel(String header, String image, String footer) {
        this.showSubPanel(new EventPanel(this.freeColClient, header, image, footer), PopupPosition.CENTERED, false);
    }

    void showFindSettlementPanel() {
        this.showSubPanel(new FindSettlementPanel(this.freeColClient), PopupPosition.ORIGIN, true);
    }

    void showFirstContactDialog(Player player, Player other, Tile tile, int settlementCount, DialogHandler<Boolean> handler) {
        SwingUtilities.invokeLater(new DialogCallback<Boolean>(new FirstContactDialog(this.freeColClient, this.frame, player, other, tile, settlementCount), tile, handler));
    }

    void showForeignColony(Settlement settlement) {
        if (settlement instanceof Colony) {
            Colony colony = this.freeColClient.getFreeColServer().getGame().getFreeColGameObject(settlement.getId(), Colony.class);
            this.showColonyPanel(colony, null);
        }
    }

    OptionGroup showGameOptionsDialog(boolean editable, boolean custom) {
        GameOptionsDialog god = new GameOptionsDialog(this.freeColClient, this.frame, editable, custom);
        return this.showFreeColDialog(god, null);
    }

    void showHighScoresPanel(String messageId, List<HighScore> scores) {
        this.showSubPanel(new ReportHighScoresPanel(this.freeColClient, messageId, scores), PopupPosition.CENTERED, true);
    }

    void showIndianSettlementPanel(IndianSettlement indianSettlement) {
        IndianSettlementPanel panel = new IndianSettlementPanel(this.freeColClient, indianSettlement);
        this.showFreeColPanel(panel, indianSettlement.getTile(), true);
    }

    private static ImageIcon createImageIcon(Image image) {
        return image == null ? null : new ImageIcon(image);
    }

    private ImageIcon createObjectImageIcon(FreeColObject display) {
        return display == null ? null : Canvas.createImageIcon(this.gui.getImageLibrary().getObjectImage(display, 2.0f));
    }

    void showInformationMessage(FreeColObject displayObject, StringTemplate template) {
        ImageIcon icon = null;
        Tile tile = null;
        if (displayObject != null) {
            icon = this.createObjectImageIcon(displayObject);
            tile = displayObject instanceof Location ? ((Location)((Object)displayObject)).getTile() : null;
        }
        this.showInformationMessage(displayObject, tile, icon, template);
    }

    void showInformationMessage(FreeColObject displayObject, Tile tile, ImageIcon icon, StringTemplate template) {
        String text = Messages.message(template);
        this.showFreeColPanel(new InformationPanel(this.freeColClient, text, displayObject, icon), tile, true);
    }

    File showLoadDialog(File directory, FileFilter[] filters) {
        if (filters == null) {
            filters = this.getFileFilters();
        }
        File response = null;
        while ((response = this.showFreeColDialog(new LoadDialog(this.freeColClient, this.frame, directory, filters), null)) != null && !response.isFile()) {
            this.showErrorMessage("error.noSuchFile");
        }
        return response;
    }

    boolean showLoadingSavegameDialog(boolean publicServer, boolean singlePlayer) {
        this.loadingSavegameDialog = new LoadingSavegameDialog(this.freeColClient, this.frame);
        return this.showFreeColDialog(this.loadingSavegameDialog, null);
    }

    void showLogFilePanel() {
        this.showSubPanel(new ErrorPanel(this.freeColClient), true);
    }

    void showMainPanel(String userMsg) {
        this.closeMenus();
        this.frame.removeMenuBar();
        this.mainPanel = new MainPanel(this.freeColClient);
        this.addCentered(this.mainPanel, JLayeredPane.DEFAULT_LAYER);
        if (userMsg != null) {
            this.gui.showInformationMessage(userMsg);
        }
        this.mainPanel.requestFocus();
    }

    void showMapEditorTransformPanel() {
        JInternalFrame f = this.addAsFrame(new MapEditorTransformPanel(this.freeColClient), true, PopupPosition.CENTERED, false);
        f.setLocation(f.getX(), 50);
        this.repaint();
    }

    OptionGroup showMapGeneratorOptionsDialog(boolean editable) {
        MapGeneratorOptionsDialog mgod = new MapGeneratorOptionsDialog(this.freeColClient, this.frame, editable);
        return this.showFreeColDialog(mgod, null);
    }

    Dimension showMapSizeDialog() {
        return this.showFreeColDialog(new MapSizeDialog(this.freeColClient, this.frame), null);
    }

    void showModelMessages(List<ModelMessage> messages) {
        if (messages.isEmpty()) {
            return;
        }
        Game game = this.freeColClient.getGame();
        int n = messages.size();
        String[] texts = new String[n];
        FreeColObject[] fcos = new FreeColObject[n];
        ImageIcon[] icons = new ImageIcon[n];
        Tile tile = null;
        for (int i = 0; i < n; ++i) {
            ModelMessage m = messages.get(i);
            texts[i] = Messages.message(m);
            fcos[i] = game.getMessageSource(m);
            icons[i] = this.createObjectImageIcon(game.getMessageDisplay(m));
            if (tile != null || !(fcos[i] instanceof Location)) continue;
            tile = ((Location)((Object)fcos[i])).getTile();
        }
        this.showFreeColPanel(new InformationPanel(this.freeColClient, texts, fcos, icons), tile, true);
    }

    void showMonarchDialog(Monarch.MonarchAction action, StringTemplate template, String monarchKey, DialogHandler<Boolean> handler) {
        SwingUtilities.invokeLater(new DialogCallback<Boolean>(new MonarchDialog(this.freeColClient, this.frame, action, template, monarchKey), null, handler));
    }

    void showNamingDialog(StringTemplate template, String defaultName, Unit unit, DialogHandler<String> handler) {
        SwingUtilities.invokeLater(new DialogCallback<String>(new FreeColStringInputDialog(this.freeColClient, (JFrame)this.frame, false, Messages.message(template), defaultName, "ok", null), unit.getTile(), handler));
    }

    DiplomaticTrade showNegotiationDialog(FreeColGameObject our, FreeColGameObject other, DiplomaticTrade agreement, StringTemplate comment) {
        if (!(our instanceof Unit) && !(our instanceof Colony) || !(other instanceof Unit) && !(other instanceof Colony) || our instanceof Colony && other instanceof Colony) {
            throw new RuntimeException("Bad DTD args: " + our + ", " + other);
        }
        NegotiationDialog dtd = new NegotiationDialog(this.freeColClient, this.frame, our, other, agreement, comment);
        return this.showFreeColDialog(dtd, ((Location)((Object)our)).getTile());
    }

    void showNewPanel(Specification specification) {
        this.showSubPanel(new NewPanel(this.freeColClient, specification), false);
    }

    void showVideoComponent(Component vp, MouseListener ml, KeyListener kl) {
        this.addMouseListener(ml);
        this.addKeyListener(kl);
        this.addCentered(vp, JLayeredPane.PALETTE_LAYER);
    }

    Parameters showParametersDialog() {
        return this.showFreeColDialog(new ParametersDialog(this.freeColClient, this.frame), null);
    }

    boolean showPreCombatDialog(Unit attacker, FreeColGameObject defender, Tile tile) {
        return this.showFreeColDialog(new PreCombatDialog(this.freeColClient, this.frame, attacker, defender), tile);
    }

    void showPurchasePanel() {
        PurchasePanel panel = this.getExistingFreeColPanel(PurchasePanel.class);
        if (panel == null) {
            this.showFreeColPanel(new PurchasePanel(this.freeColClient), null, false);
        }
    }

    void showRecruitPanel() {
        RecruitPanel panel = this.getExistingFreeColPanel(RecruitPanel.class);
        if (panel == null) {
            this.showFreeColPanel(new RecruitPanel(this.freeColClient), null, false);
        }
    }

    void showReportLabourDetailPanel(UnitType unitType, Map<UnitType, Map<Location, Integer>> data, TypeCountMap<UnitType> unitCount, List<Colony> colonies) {
        ReportLabourDetailPanel details = new ReportLabourDetailPanel(this.freeColClient, unitType, data, unitCount, colonies);
        details.initialize();
        this.showSubPanel(details, true);
    }

    String showRiverStyleDialog(Tile tile) {
        return this.showFreeColDialog(new RiverStyleDialog(this.freeColClient, this.frame), tile);
    }

    public File showSaveDialog(File directory, FileFilter[] filters, String defaultName) {
        if (filters == null) {
            filters = this.getFileFilters();
        }
        return this.showFreeColDialog(new SaveDialog(this.freeColClient, this.frame, directory, filters, defaultName), null);
    }

    Dimension showScaleMapSizeDialog() {
        return this.showFreeColDialog(new ScaleMapSizeDialog(this.freeColClient, this.frame), null);
    }

    int showSelectAmountDialog(GoodsType goodsType, int available, int defaultAmount, boolean needToPay) {
        SelectAmountDialog fcd = new SelectAmountDialog(this.freeColClient, this.frame, goodsType, available, defaultAmount, needToPay);
        Integer result = this.showFreeColDialog(fcd, null);
        return result == null ? -1 : result;
    }

    int showSelectTributeAmountDialog(StringTemplate question, int maximum) {
        SelectTributeAmountDialog fcd = new SelectTributeAmountDialog(this.freeColClient, this.frame, question, maximum);
        Integer result = this.showFreeColDialog(fcd, null);
        return result == null ? -1 : result;
    }

    Location showSelectDestinationDialog(Unit unit) {
        return this.showFreeColDialog(new SelectDestinationDialog(this.freeColClient, this.frame, unit), unit.getTile());
    }

    void showServerListPanel(List<ServerInfo> serverList) {
        this.closeMenus();
        this.serverListPanel.initialize(serverList);
        this.showSubPanel(this.serverListPanel, true);
    }

    ColonyPanel showSpyColonyPanel(Tile tile) {
        Colony colony = tile.getColony();
        if (colony == null) {
            return null;
        }
        ColonyPanel panel = new ColonyPanel(this.freeColClient, colony);
        this.showFreeColPanel(panel, tile, true);
        return panel;
    }

    void showStartGamePanel(Game game, Player player, boolean singlePlayerMode) {
        if (game == null) {
            logger.warning("StartGamePanel requires game != null.");
        } else if (player == null) {
            logger.warning("StartGamePanel requires player != null.");
        } else {
            this.closeMenus();
            this.startGamePanel.initialize(singlePlayerMode);
            this.showSubPanel(this.startGamePanel, false);
        }
    }

    void showStatisticsPanel() {
        this.showSubPanel(new StatisticsPanel(this.freeColClient), true);
    }

    void showStatusPanel(String message) {
        this.statusPanel.setStatusMessage(message);
        this.addCentered(this.statusPanel, JLayeredPane.POPUP_LAYER);
    }

    void showTilePanel(Tile tile) {
        if (tile == null || !tile.isExplored()) {
            return;
        }
        this.showSubPanel(new TilePanel(this.freeColClient, tile), false);
    }

    void showTilePopup(Tile tile, int x, int y) {
        if (tile == null) {
            return;
        }
        TilePopup tp = new TilePopup(this.freeColClient, this, tile);
        if (tp.hasItem()) {
            tp.show(this, x, y);
            tp.repaint();
        } else if (tile.isExplored()) {
            this.showTilePanel(tile);
        }
    }

    void showTradeRoutePanel(Unit unit) {
        this.showFreeColPanel(new TradeRoutePanel(this.freeColClient, unit), unit == null ? null : unit.getTile(), true);
    }

    void showTradeRouteInputPanel(TradeRoute newRoute, Runnable callBack) {
        TradeRouteInputPanel panel = new TradeRouteInputPanel(this.freeColClient, newRoute);
        panel.addClosingCallback(callBack);
        this.showSubPanel(panel, null, true);
    }

    void showTrainPanel() {
        TrainPanel panel = this.getExistingFreeColPanel(TrainPanel.class);
        if (panel == null) {
            this.showFreeColPanel(new TrainPanel(this.freeColClient), null, false);
        }
    }

    void showVictoryDialog(DialogHandler<Boolean> handler) {
        SwingUtilities.invokeLater(new DialogCallback<Boolean>(new VictoryDialog(this.freeColClient, this.frame), null, handler));
    }

    boolean showWarehouseDialog(Colony colony) {
        return this.showFreeColDialog(new WarehouseDialog(this.freeColClient, this.frame, colony), null);
    }

    void showWorkProductionPanel(Unit unit) {
        this.showSubPanel(new WorkProductionPanel(this.freeColClient, unit), true);
    }

    void updateEuropeanSubpanels() {
        TrainPanel tp;
        PurchasePanel pp;
        RecruitPanel rp = this.getExistingFreeColPanel(RecruitPanel.class);
        if (rp != null) {
            rp.update();
        }
        if ((pp = this.getExistingFreeColPanel(PurchasePanel.class)) != null) {
            pp.update();
        }
        if ((tp = this.getExistingFreeColPanel(TrainPanel.class)) != null) {
            tp.update();
        }
    }

    void showReportCargoPanel() {
        ReportCargoPanel r = this.getExistingFreeColPanel(ReportCargoPanel.class);
        if (r == null) {
            this.showSubPanel(new ReportCargoPanel(this.freeColClient), true);
        }
    }

    void showReportColonyPanel() {
        ReportPanel r;
        boolean compact;
        try {
            compact = this.freeColClient.getClientOptions().getInteger("model.option.colonyReport") == 1;
        }
        catch (Exception e) {
            compact = false;
        }
        ReportPanel reportPanel = r = compact ? (ReportPanel)this.getExistingFreeColPanel(ReportCompactColonyPanel.class) : (ReportPanel)this.getExistingFreeColPanel(ReportClassicColonyPanel.class);
        if (r == null) {
            this.showSubPanel(compact ? new ReportCompactColonyPanel(this.freeColClient) : new ReportClassicColonyPanel(this.freeColClient), true);
        }
    }

    void showReportContinentalCongressPanel() {
        ReportContinentalCongressPanel r = this.getExistingFreeColPanel(ReportContinentalCongressPanel.class);
        if (r == null) {
            this.showSubPanel(new ReportContinentalCongressPanel(this.freeColClient), true);
        }
    }

    void showReportEducationPanel() {
        ReportEducationPanel r = this.getExistingFreeColPanel(ReportEducationPanel.class);
        if (r == null) {
            this.showSubPanel(new ReportEducationPanel(this.freeColClient), true);
        }
    }

    void showReportExplorationPanel() {
        ReportExplorationPanel r = this.getExistingFreeColPanel(ReportExplorationPanel.class);
        if (r == null) {
            this.showSubPanel(new ReportExplorationPanel(this.freeColClient), true);
        }
    }

    void showReportForeignAffairPanel() {
        ReportForeignAffairPanel r = this.getExistingFreeColPanel(ReportForeignAffairPanel.class);
        if (r == null) {
            this.showSubPanel(new ReportForeignAffairPanel(this.freeColClient), true);
        }
    }

    void showReportHistoryPanel() {
        ReportHistoryPanel r = this.getExistingFreeColPanel(ReportHistoryPanel.class);
        if (r == null) {
            this.showSubPanel(new ReportHistoryPanel(this.freeColClient), true);
        }
    }

    void showReportIndianPanel() {
        ReportIndianPanel r = this.getExistingFreeColPanel(ReportIndianPanel.class);
        if (r == null) {
            this.showSubPanel(new ReportIndianPanel(this.freeColClient), true);
        }
    }

    void showReportLabourPanel() {
        ReportLabourPanel r = this.getExistingFreeColPanel(ReportLabourPanel.class);
        if (r == null) {
            this.showSubPanel(new ReportLabourPanel(this.freeColClient), true);
        }
    }

    void showReportMilitaryPanel() {
        ReportMilitaryPanel r = this.getExistingFreeColPanel(ReportMilitaryPanel.class);
        if (r == null) {
            this.showSubPanel(new ReportMilitaryPanel(this.freeColClient), true);
        }
    }

    void showReportNavalPanel() {
        ReportNavalPanel r = this.getExistingFreeColPanel(ReportNavalPanel.class);
        if (r == null) {
            this.showSubPanel(new ReportNavalPanel(this.freeColClient), true);
        }
    }

    void showReportProductionPanel() {
        ReportProductionPanel r = this.getExistingFreeColPanel(ReportProductionPanel.class);
        if (r == null) {
            this.showSubPanel(new ReportProductionPanel(this.freeColClient), true);
        }
    }

    void showReportReligiousPanel() {
        ReportReligiousPanel r = this.getExistingFreeColPanel(ReportReligiousPanel.class);
        if (r == null) {
            this.showSubPanel(new ReportReligiousPanel(this.freeColClient), true);
        }
    }

    void showReportRequirementsPanel() {
        ReportRequirementsPanel r = this.getExistingFreeColPanel(ReportRequirementsPanel.class);
        if (r == null) {
            this.showSubPanel(new ReportRequirementsPanel(this.freeColClient), true);
        }
    }

    void showReportTradePanel() {
        ReportTradePanel r = this.getExistingFreeColPanel(ReportTradePanel.class);
        if (r == null) {
            this.showSubPanel(new ReportTradePanel(this.freeColClient), true);
        }
    }

    void showReportTurnPanel(List<ModelMessage> messages) {
        ReportTurnPanel r = this.getExistingFreeColPanel(ReportTurnPanel.class);
        if (r == null) {
            this.showSubPanel(new ReportTurnPanel(this.freeColClient, messages), true);
        } else {
            r.setMessages(messages);
        }
    }

    private static class ToolBoxFrame
    extends JInternalFrame {
        private ToolBoxFrame() {
        }
    }

    private static enum PopupPosition {
        ORIGIN,
        CENTERED,
        CENTERED_LEFT,
        CENTERED_RIGHT;

    }

    private class DialogCallback<T>
    implements Runnable {
        private final FreeColDialog<T> fcd;
        private final Tile tile;
        private final DialogHandler<T> handler;

        public DialogCallback(FreeColDialog<T> fcd, Tile tile, DialogHandler<T> handler) {
            this.fcd = fcd;
            this.tile = tile;
            this.handler = handler;
        }

        @Override
        public void run() {
            Canvas.this.viewFreeColDialog(this.fcd, this.tile);
            new Thread(this.fcd.toString()){

                @Override
                public void run() {
                    while (!DialogCallback.this.fcd.responded()) {
                        try {
                            Thread.sleep(500L);
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                    DialogCallback.this.handler.handle(DialogCallback.this.fcd.getResponse());
                }
            }.start();
        }
    }
}

