/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.util.io;

import java.io.Closeable;
import java.io.IOException;
import java.nio.channels.Channel;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SeekableByteChannel;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SocketChannel;
import java.nio.channels.WritableByteChannel;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.locks.ReentrantLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import jnr.constants.platform.Errno;
import jnr.constants.platform.OpenFlags;
import org.jcodings.Encoding;
import org.jcodings.Ptr;
import org.jcodings.transcode.EConv;
import org.jcodings.transcode.EConvResult;
import org.jruby.Finalizable;
import org.jruby.Ruby;
import org.jruby.RubyArgsFile;
import org.jruby.RubyBignum;
import org.jruby.RubyBoolean;
import org.jruby.RubyEncoding;
import org.jruby.RubyException;
import org.jruby.RubyFixnum;
import org.jruby.RubyIO;
import org.jruby.RubyNumeric;
import org.jruby.RubyString;
import org.jruby.RubyThread;
import org.jruby.exceptions.RaiseException;
import org.jruby.platform.Platform;
import org.jruby.runtime.Block;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;
import org.jruby.util.ShellLauncher;
import org.jruby.util.StringSupport;
import org.jruby.util.io.ChannelFD;
import org.jruby.util.io.EncodingUtils;
import org.jruby.util.io.IOEncodable;
import org.jruby.util.io.InvalidValueException;
import org.jruby.util.io.ModeFlags;
import org.jruby.util.io.PosixShim;

public class OpenFile
implements Finalizable {
    public static final int READABLE = 1;
    public static final int WRITABLE = 2;
    public static final int READWRITE = 3;
    public static final int BINMODE = 4;
    public static final int SYNC = 8;
    public static final int TTY = 16;
    public static final int DUPLEX = 32;
    public static final int APPEND = 64;
    public static final int CREATE = 128;
    public static final int WSPLIT = 512;
    public static final int EXCLUSIVE = 1024;
    public static final int TRUNC = 2048;
    public static final int TEXTMODE = 4096;
    public static final int SETENC_BY_BOM = 0x100000;
    public static final int TMPFILE = 0x410000;
    public static final int PREP = 65536;
    public static final int SYNCWRITE = 10;
    public static final int PIPE_BUF = 512;
    public static final int BUFSIZ = 1024;
    private ChannelFD fd;
    private int mode;
    private long pid = -1L;
    private Process process;
    private int lineno;
    private String pathv;
    private Finalizer finalizer;
    public Closeable stdio_file;
    public volatile FileLock currentLock;
    public IOEncodable.ConvConfig encs = new IOEncodable.ConvConfig();
    public EConv readconv;
    public EConv writeconv;
    public Encoding writeconvAsciicompat;
    public int writeconvPreEcflags;
    public IRubyObject writeconvPreEcopts;
    public boolean writeconvInitialized;
    public volatile ReentrantReadWriteLock write_lock;
    private final ReentrantLock lock = new ReentrantLock();
    public final Buffer wbuf = new Buffer();
    public final Buffer rbuf = new Buffer();
    public final Buffer cbuf = new Buffer();
    public RubyIO tiedIOForWriting;
    private boolean nonblock = false;
    public final PosixShim posix;
    private final Ruby runtime;
    protected volatile Set<RubyThread> blockingThreads;
    @Deprecated
    public static final Finalizer PIPE_FINALIZE = new Finalizer(){

        @Override
        public void finalize(Ruby runtime2, OpenFile fptr, boolean noraise) {
            if (!Platform.IS_WINDOWS) {
                boolean status2 = false;
                if (fptr.stdio_file != null) {
                    fptr.posix.close(fptr.stdio_file);
                }
                fptr.setFD(null);
                fptr.stdio_file = null;
            } else {
                fptr.finalize(runtime2.getCurrentContext(), noraise);
            }
        }
    };
    public static final int MORE_CHAR_SUSPENDED = 0;
    public static final int MORE_CHAR_FINISHED = 1;
    public static final int EOF = -1;
    public static final int IO_RBUF_CAPA_MIN = 8192;
    public static final int IO_CBUF_CAPA_MIN = 131072;
    public static final int IO_WBUF_CAPA_MIN = 8192;
    private static final byte[] EMPTY_BYTE_ARRAY = ByteList.NULL_ARRAY;
    static final RubyThread.ReadWrite<OpenFile> READ_TASK = new RubyThread.ReadWrite<OpenFile>(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int run(ThreadContext context, OpenFile fptr, byte[] buffer, int start2, int length2) throws InterruptedException {
            ChannelFD fd = fptr.fd;
            assert (fptr.lockedByMe());
            fptr.unlock();
            try {
                int n = fptr.posix.read(fd, buffer, start2, length2, fptr.nonblock);
                return n;
            }
            finally {
                fptr.lock();
            }
        }

        @Override
        public void wakeup(RubyThread thread2, OpenFile data2) {
            thread2.getNativeThread().interrupt();
        }
    };
    static final RubyThread.ReadWrite<OpenFile> WRITE_TASK = new RubyThread.ReadWrite<OpenFile>(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int run(ThreadContext context, OpenFile fptr, byte[] bytes2, int start2, int length2) throws InterruptedException {
            assert (fptr.lockedByMe());
            fptr.unlock();
            try {
                int n = fptr.posix.write(fptr.fd, bytes2, start2, length2, fptr.nonblock);
                return n;
            }
            finally {
                fptr.lock();
            }
        }

        @Override
        public void wakeup(RubyThread thread2, OpenFile data2) {
            thread2.getNativeThread().interrupt();
        }
    };

    public OpenFile(IRubyObject nil) {
        this.runtime = nil.getRuntime();
        this.writeconvAsciicompat = null;
        this.writeconvPreEcopts = nil;
        this.encs.ecopts = nil;
        this.posix = new PosixShim(this.runtime);
    }

    public void ascii8bitBinmode(Ruby runtime2) {
        if (this.readconv != null) {
            this.readconv.close();
            this.readconv = null;
        }
        if (this.writeconv != null) {
            this.writeconv.close();
            this.writeconv = null;
        }
        this.setBinmode();
        this.clearTextMode();
        this.encs.enc = EncodingUtils.ascii8bitEncoding(runtime2);
        this.encs.enc2 = null;
        this.encs.ecflags = 0;
        this.encs.ecopts = runtime2.getNil();
        this.clearCodeConversion();
    }

    public void checkReopenSeek(ThreadContext context, Ruby runtime2, long pos2) {
        if (this.seek(context, pos2, 0) == -1L && this.errno() != null) {
            throw runtime2.newErrnoFromErrno(this.errno(), this.getPath());
        }
    }

    public void clearStdio() {
        this.stdio_file = null;
    }

    public String PREP_STDIO_NAME() {
        return this.pathv;
    }

    public boolean READ_DATA_PENDING() {
        return this.rbuf.len != 0;
    }

    public int READ_DATA_PENDING_COUNT() {
        return this.rbuf.len;
    }

    public byte[] READ_DATA_PENDING_PTR() {
        return this.rbuf.ptr;
    }

    public int READ_DATA_PENDING_OFF() {
        return this.rbuf.off;
    }

    public int READ_DATA_PENDING_START() {
        return this.rbuf.start;
    }

    public boolean READ_DATA_BUFFERED() {
        return this.READ_DATA_PENDING();
    }

    public boolean READ_CHAR_PENDING() {
        return this.cbuf.len != 0;
    }

    public int READ_CHAR_PENDING_COUNT() {
        return this.cbuf.len;
    }

    public byte[] READ_CHAR_PENDING_PTR() {
        return this.cbuf.ptr;
    }

    public int READ_CHAR_PENDING_OFF() {
        return this.cbuf.off;
    }

    public int READ_CHAR_PENDING_START() {
        return this.cbuf.start;
    }

    public void READ_CHECK(ThreadContext context) {
        if (!this.READ_DATA_PENDING()) {
            this.checkClosed();
        }
    }

    public boolean IS_PREP_STDIO() {
        return (this.mode & 0x10000) == 65536;
    }

    public void setFD(ChannelFD fd) {
        this.fd = fd;
    }

    public void setChannel(Channel fd) {
        this.fd = new ChannelFD(fd, this.runtime.getPosix(), this.runtime.getFilenoUtil());
    }

    public int getMode() {
        return this.mode;
    }

    public String getModeAsString(Ruby runtime2) {
        String modeString = OpenFile.getStringFromMode(this.mode);
        if (modeString == null) {
            throw runtime2.newArgumentError("Illegal access modenum " + Integer.toOctalString(this.mode));
        }
        return modeString;
    }

    public static int getModeFlagsAsIntFrom(int fmode) {
        int oflags = 0;
        if ((fmode & 1) != 0) {
            oflags = (fmode & 2) != 0 ? (oflags |= ModeFlags.RDWR) : (oflags |= ModeFlags.RDONLY);
        } else if ((fmode & 2) != 0) {
            oflags |= ModeFlags.WRONLY;
        }
        if ((fmode & 0x40) != 0) {
            oflags |= ModeFlags.APPEND;
        }
        if ((fmode & 0x80) != 0) {
            oflags |= ModeFlags.CREAT;
        }
        if ((fmode & 4) != 0) {
            oflags |= ModeFlags.BINARY;
        }
        if ((fmode & 0x1000) != 0) {
            oflags |= 0x10000000;
        }
        if ((fmode & 0x800) != 0) {
            oflags |= ModeFlags.TRUNC;
        }
        if ((fmode & 0x400) != 0) {
            oflags |= ModeFlags.EXCL;
        }
        return oflags;
    }

    public static String ioOflagsModestr(Ruby runtime2, int oflags) {
        if ((oflags & OpenFlags.O_EXLOCK.intValue()) != 0) {
            throw runtime2.newArgumentError("exclusive access mode is not supported");
        }
        int accmode = oflags & (OpenFlags.O_RDONLY.intValue() | OpenFlags.O_WRONLY.intValue() | OpenFlags.O_RDWR.intValue());
        if ((oflags & OpenFlags.O_APPEND.intValue()) != 0) {
            if (accmode == OpenFlags.O_WRONLY.intValue()) {
                return OpenFile.MODE_BINARY(oflags, "a", "ab");
            }
            if (accmode == OpenFlags.O_RDWR.intValue()) {
                return OpenFile.MODE_BINARY(oflags, "a+", "ab+");
            }
        }
        switch (OpenFlags.valueOf(oflags & (OpenFlags.O_RDONLY.intValue() | OpenFlags.O_WRONLY.intValue() | OpenFlags.O_RDWR.intValue()))) {
            default: {
                throw runtime2.newArgumentError("invalid access oflags 0x" + Integer.toHexString(oflags));
            }
            case O_RDONLY: {
                return OpenFile.MODE_BINARY(oflags, "r", "rb");
            }
            case O_WRONLY: {
                return OpenFile.MODE_BINARY(oflags, "w", "wb");
            }
            case O_RDWR: 
        }
        return OpenFile.MODE_BINARY(oflags, "r+", "rb+");
    }

    public static int ioModestrOflags(Ruby runtime2, String modestr) {
        return OpenFile.ioFmodeOflags(OpenFile.ioModestrFmode(runtime2, modestr));
    }

    public static int ioFmodeOflags(int fmode) {
        int oflags = 0;
        switch (fmode & 3) {
            case 1: {
                oflags |= OpenFlags.O_RDONLY.intValue();
                break;
            }
            case 2: {
                oflags |= OpenFlags.O_WRONLY.intValue();
                break;
            }
            case 3: {
                oflags |= OpenFlags.O_RDWR.intValue();
            }
        }
        if ((fmode & 0x40) != 0) {
            oflags |= OpenFlags.O_APPEND.intValue();
        }
        if ((fmode & 0x800) != 0) {
            oflags |= OpenFlags.O_TRUNC.intValue();
        }
        if ((fmode & 0x80) != 0) {
            oflags |= OpenFlags.O_CREAT.intValue();
        }
        if ((fmode & 0x400) != 0) {
            oflags |= OpenFlags.O_EXCL.intValue();
        }
        if (OpenFlags.O_BINARY.defined() && (fmode & 4) != 0) {
            oflags |= OpenFlags.O_BINARY.intValue();
        }
        return oflags;
    }

    public static int ioModestrFmode(Ruby runtime2, String modestr) {
        int fmode = 0;
        char[] mChars = modestr.toCharArray();
        char[] pChars = null;
        int m = 0;
        int p2 = 0;
        if (mChars.length == 0) {
            throw runtime2.newArgumentError("invalid access mode " + modestr);
        }
        switch (mChars[m++]) {
            case 'r': {
                fmode |= 1;
                break;
            }
            case 'w': {
                fmode |= 0x882;
                break;
            }
            case 'a': {
                fmode |= 0xC2;
                break;
            }
            default: {
                throw runtime2.newArgumentError("invalid access mode " + modestr);
            }
        }
        block12: while (m < mChars.length) {
            switch (mChars[m++]) {
                case 'b': {
                    fmode |= 4;
                    continue block12;
                }
                case 't': {
                    fmode |= 0x1000;
                    continue block12;
                }
                case '+': {
                    fmode |= 3;
                    continue block12;
                }
                case 'x': {
                    if (mChars[0] != 'w') {
                        throw runtime2.newArgumentError("invalid access mode " + modestr);
                    }
                    fmode |= 0x400;
                    continue block12;
                }
                case ':': {
                    pChars = mChars;
                    p2 = m;
                    if ((fmode & 4) == 0 || (fmode & 0x1000) == 0) break block12;
                    throw runtime2.newArgumentError("invalid access mode " + modestr);
                }
                default: {
                    throw runtime2.newArgumentError("invalid access mode " + modestr);
                }
            }
        }
        if ((fmode & 4) != 0 && (fmode & 0x1000) != 0) {
            throw runtime2.newArgumentError("invalid access mode " + modestr);
        }
        if (p2 != 0 && OpenFile.ioEncnameBomP(new String(pChars, p2, pChars.length - p2), 0L)) {
            fmode |= 0x100000;
        }
        return fmode;
    }

    static boolean ioEncnameBomP(String name2, long len) {
        String bom_prefix = "bom|utf-";
        int bom_prefix_len = bom_prefix.length();
        if (len == 0L) {
            int p2 = name2.indexOf(58);
            len = p2 != -1 ? (long)p2 : (long)name2.length();
        }
        return len > (long)bom_prefix_len && name2.compareToIgnoreCase(bom_prefix) == 0;
    }

    private static String MODE_BINARY(int oflags, String a, String b2) {
        if (OpenFlags.O_BINARY.defined() && (oflags & OpenFlags.O_BINARY.intValue()) != 0) {
            return b2;
        }
        return a;
    }

    public static String getStringFromMode(int mode2) {
        if ((mode2 & 0x40) != 0) {
            if ((mode2 & 3) != 0) {
                return "ab+";
            }
            return "ab";
        }
        switch (mode2 & 3) {
            case 1: {
                return "rb";
            }
            case 2: {
                return "wb";
            }
            case 3: {
                if ((mode2 & 0x80) != 0) {
                    return "wb+";
                }
                return "rb+";
            }
        }
        return null;
    }

    public void checkCharReadable(ThreadContext context) {
        OpenFile wfptr;
        this.checkClosed();
        if ((this.mode & 1) == 0) {
            throw this.runtime.newIOError("not opened for reading");
        }
        if (this.wbuf.len != 0 && this.io_fflush(context) < 0) {
            throw this.runtime.newErrnoFromErrno(this.posix.getErrno(), "error flushing");
        }
        if (this.tiedIOForWriting != null && (wfptr = this.tiedIOForWriting.getOpenFileChecked()).io_fflush(context) < 0) {
            throw this.runtime.newErrnoFromErrno(wfptr.posix.getErrno(), wfptr.getPath());
        }
    }

    public void checkByteReadable(ThreadContext context) {
        this.checkCharReadable(context);
        if (this.READ_CHAR_PENDING()) {
            throw this.runtime.newIOError("byte oriented read for character buffered IO");
        }
    }

    public void checkReadable(ThreadContext context) {
        this.checkByteReadable(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int io_fflush(ThreadContext context) {
        boolean locked = this.lock();
        try {
            this.checkClosed();
            if (this.wbuf.len == 0) {
                int n = 0;
                return n;
            }
            this.checkClosed();
            while (this.wbuf.len > 0 && this.flushBuffer() != 0) {
                if (!this.waitWritable(context)) {
                    int n = -1;
                    return n;
                }
                this.checkClosed();
            }
        }
        finally {
            if (locked) {
                this.unlock();
            }
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean waitWritable(ThreadContext context, long timeout2) {
        boolean locked = this.lock();
        try {
            if (this.posix.getErrno() == null) {
                boolean bl = false;
                return bl;
            }
            this.checkClosed();
            switch (this.posix.getErrno()) {
                case EINTR: {
                    this.runtime.getCurrentContext().pollThreadEvents();
                    boolean bl = true;
                    return bl;
                }
                case EAGAIN: 
                case EWOULDBLOCK: {
                    this.ready(this.runtime, context.getThread(), 12, timeout2);
                    boolean bl = true;
                    return bl;
                }
            }
            boolean bl = false;
            return bl;
        }
        finally {
            if (locked) {
                this.unlock();
            }
        }
    }

    public boolean waitWritable(ThreadContext context) {
        return this.waitWritable(context, 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean waitReadable(ThreadContext context, long timeout2) {
        boolean locked = this.lock();
        try {
            if (this.posix.getErrno() == null) {
                boolean bl = false;
                return bl;
            }
            this.checkClosed();
            switch (this.posix.getErrno()) {
                case EINTR: {
                    this.runtime.getCurrentContext().pollThreadEvents();
                    boolean bl = true;
                    return bl;
                }
                case EAGAIN: 
                case EWOULDBLOCK: {
                    this.ready(this.runtime, context.getThread(), 1, timeout2);
                    boolean bl = true;
                    return bl;
                }
            }
            boolean bl = false;
            return bl;
        }
        finally {
            if (locked) {
                this.unlock();
            }
        }
    }

    public boolean waitReadable(ThreadContext context) {
        return this.waitReadable(context, -1L);
    }

    public boolean ready(Ruby runtime2, RubyThread thread2, int ops, long timeout2) {
        boolean locked = this.lock();
        try {
            if (this.fd.chSelect != null) {
                int realOps = ops & this.fd.chSelect.validOps();
                if ((realOps & 4) != (ops & 4)) {
                    boolean bl = true;
                    return bl;
                }
                boolean bl = thread2.select((Channel)this.fd.chSelect, this, realOps, timeout2);
                return bl;
            }
            if (this.fd.chSeek != null) {
                boolean realOps = this.fd.chSeek.position() != -1L && this.fd.chSeek.size() != -1L && this.fd.chSeek.position() < this.fd.chSeek.size();
                return realOps;
            }
            boolean realOps = false;
            return realOps;
        }
        catch (IOException ioe) {
            throw runtime2.newIOErrorFromException(ioe);
        }
        finally {
            if (locked) {
                this.unlock();
            }
        }
    }

    public boolean readyNow(ThreadContext context) {
        return this.ready(context.runtime, context.getThread(), 1, 0L);
    }

    public int flushBuffer() {
        if (this.write_lock != null) {
            this.write_lock.writeLock().lock();
            try {
                int n = this.flushBufferAsync2();
                return n;
            }
            finally {
                this.write_lock.writeLock().unlock();
            }
        }
        return this.flushBufferAsync2();
    }

    public int flushBufferAsync2() {
        return this.flushBufferSync2();
    }

    private int flushBufferSync2() {
        int result2 = this.flushBufferSync();
        return result2;
    }

    private int flushBufferSync() {
        int l = this.writableLength(this.wbuf.len);
        int r = this.posix.write(this.fd, this.wbuf.ptr, this.wbuf.off, l, this.nonblock);
        if (this.wbuf.len <= r) {
            this.wbuf.off = 0;
            this.wbuf.len = 0;
            return 0;
        }
        if (0 <= r) {
            this.wbuf.off += r;
            this.wbuf.len -= r;
            this.posix.setErrno(Errno.EAGAIN);
        }
        return -1;
    }

    private int writableLength(int l) {
        return l;
    }

    private boolean wsplit() {
        return (this.mode & 0x200) != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long seek(ThreadContext context, long offset2, int whence) {
        boolean locked = this.lock();
        try {
            this.flushBeforeSeek(context);
            long l = this.posix.lseek(this.fd, offset2, whence);
            return l;
        }
        finally {
            if (locked) {
                this.unlock();
            }
        }
    }

    private void flushBeforeSeek(ThreadContext context) {
        boolean locked = this.lock();
        try {
            if (this.io_fflush(context) < 0) {
                throw context.runtime.newErrnoFromErrno(this.posix.getErrno(), "");
            }
            this.unread(context);
            this.posix.setErrno(null);
        }
        finally {
            if (locked) {
                this.unlock();
            }
        }
    }

    public void checkWritable(ThreadContext context) {
        boolean locked = this.lock();
        try {
            this.checkClosed();
            if ((this.mode & 2) == 0) {
                throw context.runtime.newIOError("not opened for writing");
            }
            if (this.rbuf.len != 0) {
                this.unread(context);
            }
        }
        finally {
            if (locked) {
                this.unlock();
            }
        }
    }

    public void checkClosed() {
        if (this.fd == null) {
            throw this.runtime.newIOError("closed stream");
        }
    }

    public boolean isBinmode() {
        return (this.mode & 4) != 0;
    }

    public boolean isTextMode() {
        return (this.mode & 0x1000) != 0;
    }

    public void setTextMode() {
        this.mode |= 0x1000;
    }

    public void clearTextMode() {
        this.mode &= 0xFFFFEFFF;
    }

    public void setBinmode() {
        this.mode |= 4;
    }

    public boolean isOpen() {
        return this.fd != null;
    }

    public boolean isReadable() {
        return (this.mode & 1) != 0;
    }

    public boolean isWritable() {
        return (this.mode & 2) != 0;
    }

    public boolean isDuplex() {
        return (this.mode & 0x20) != 0;
    }

    public boolean isReadBuffered() {
        return this.READ_DATA_BUFFERED();
    }

    public boolean isWriteBuffered() {
        return false;
    }

    public void setSync(boolean sync2) {
        boolean locked = this.lock();
        try {
            this.mode = sync2 ? (this.mode |= 8) : (this.mode &= 0xFFFFFFF7);
        }
        finally {
            if (locked) {
                this.unlock();
            }
        }
    }

    public boolean isSync() {
        return (this.mode & 0x18) != 0;
    }

    public void setMode(int modes) {
        this.mode = modes;
    }

    public Process getProcess() {
        return this.process;
    }

    public void setProcess(Process process) {
        this.process = process;
    }

    public long getPid() {
        if (this.pid != -1L) {
            return this.pid;
        }
        return ShellLauncher.getPidFromProcess(this.process);
    }

    public void setPid(long pid2) {
        this.pid = pid2;
    }

    public int getLineNumber() {
        return this.lineno;
    }

    public void setLineNumber(int lineNumber) {
        this.lineno = lineNumber;
    }

    public String getPath() {
        return this.pathv;
    }

    public void setPath(String path2) {
        this.pathv = path2;
    }

    public boolean isAutoclose() {
        return (this.mode & 0x10000) == 0;
    }

    public void setAutoclose(boolean autoclose2) {
        boolean locked = this.lock();
        try {
            this.mode = !autoclose2 ? (this.mode |= 0x10000) : (this.mode &= 0xFFFEFFFF);
        }
        finally {
            if (locked) {
                this.unlock();
            }
        }
    }

    public Finalizer getFinalizer() {
        return this.finalizer;
    }

    public void setFinalizer(Finalizer finalizer) {
        this.finalizer = finalizer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanup(Ruby runtime2, boolean noraise) {
        boolean locked = this.lock();
        try {
            if (this.finalizer != null) {
                this.finalizer.finalize(runtime2, this, noraise);
            } else {
                this.finalize(runtime2.getCurrentContext(), noraise);
            }
        }
        finally {
            if (locked) {
                this.unlock();
            }
        }
    }

    @Override
    public void finalize() {
        if (this.fd != null && this.isAutoclose()) {
            this.finalize(this.runtime.getCurrentContext(), true);
        }
    }

    public void finalize(ThreadContext context, boolean noraise) {
        this.finalizeFlush(context, noraise);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finalizeFlush(ThreadContext context, boolean noraise) {
        IRubyObject err = context.nil;
        ChannelFD fd = this.fd();
        Closeable stdio_file = this.stdio_file;
        if (this.writeconv != null) {
            if (this.write_lock != null && !noraise) {
                this.write_lock.writeLock().lock();
                try {
                    this.finishWriteconv(context, noraise);
                }
                finally {
                    this.write_lock.writeLock().unlock();
                }
            } else {
                err = this.finishWriteconv(context, noraise);
            }
        }
        if (this.wbuf.len != 0) {
            if (noraise) {
                if (this.flushBufferSync() < 0 && err == context.nil) {
                    err = context.tru;
                }
            } else if (this.io_fflush(context) < 0 && err == context.nil) {
                err = RubyFixnum.newFixnum(this.runtime, this.posix.getErrno() == null ? 0L : this.posix.getErrno().longValue());
            }
        }
        this.fd = null;
        this.clearStdio();
        this.mode &= 0xFFFFFFFC;
        if (!this.IS_PREP_STDIO() && !this.isStdio()) {
            if (stdio_file != null) {
                if (this.posix.close(stdio_file) < 0 && err.isNil()) {
                    err = noraise ? context.tru : RubyNumeric.int2fix(this.runtime, this.posix.getErrno().intValue());
                }
            } else if (fd != null && this.posix.close(fd) < 0 && err.isNil()) {
                IRubyObject iRubyObject = err = noraise ? context.tru : this.runtime.newFixnum(this.posix.getErrno().intValue());
            }
        }
        if (!err.isNil() && !noraise) {
            if (err instanceof RubyFixnum || err instanceof RubyBignum) {
                this.posix.setErrno(Errno.valueOf(RubyNumeric.num2int(err)));
                throw this.runtime.newErrnoFromErrno(this.posix.getErrno(), this.pathv);
            }
            throw ((RubyException)err).toThrowable();
        }
    }

    public boolean needsReadConversion() {
        return Platform.IS_WINDOWS ? this.encs.enc2 != null || (this.encs.ecflags & 0xFFFFEFFF) != 0 || this.isTextMode() : this.encs.enc2 != null || this.NEED_NEWLINE_DECORATOR_ON_READ();
    }

    public boolean needsWriteConversion(ThreadContext context) {
        Encoding ascii8bit = context.runtime.getEncodingService().getAscii8bitEncoding();
        return Platform.IS_WINDOWS ? this.encs.enc != null && this.encs.enc != ascii8bit || (this.encs.ecflags & 0xF0EF00) != 0 : this.encs.enc != null && this.encs.enc != ascii8bit || this.NEED_NEWLINE_DECORATOR_ON_WRITE() || (this.encs.ecflags & 0xF0FF00) != 0;
    }

    public void makeReadConversion(ThreadContext context, int size2) {
        if (this.readconv == null) {
            byte[] dname;
            byte[] sname;
            int ecflags = this.encs.ecflags & 0xFFFFCFFF;
            IRubyObject ecopts = this.encs.ecopts;
            if (this.encs.enc2 != null) {
                sname = this.encs.enc2.getName();
                dname = this.encs.enc.getName();
            } else {
                dname = EMPTY_BYTE_ARRAY;
                sname = EMPTY_BYTE_ARRAY;
            }
            this.readconv = EncodingUtils.econvOpenOpts(context, sname, dname, ecflags, ecopts);
            if (this.readconv == null) {
                throw EncodingUtils.econvOpenExc(context, sname, dname, ecflags);
            }
            this.cbuf.off = 0;
            this.cbuf.len = 0;
            if (size2 < 131072) {
                size2 = 131072;
            }
            this.cbuf.capa = size2;
            this.cbuf.ptr = new byte[this.cbuf.capa];
        }
    }

    public void makeReadConversion(ThreadContext context) {
        this.makeReadConversion(context, 131072);
    }

    public void makeWriteConversion(ThreadContext context) {
        if (this.writeconvInitialized) {
            return;
        }
        this.writeconvInitialized = true;
        int ecflags = this.encs.ecflags & 0xFFFFF0FF;
        IRubyObject ecopts = this.encs.ecopts;
        Encoding ascii8bit = context.runtime.getEncodingService().getAscii8bitEncoding();
        if (this.encs.enc == null || this.encs.enc == ascii8bit && this.encs.enc2 == null) {
            this.writeconvPreEcflags = 0;
            this.writeconvPreEcopts = context.nil;
            this.writeconv = EncodingUtils.econvOpenOpts(context, EMPTY_BYTE_ARRAY, EMPTY_BYTE_ARRAY, ecflags, ecopts);
            if (this.writeconv == null) {
                throw EncodingUtils.econvOpenExc(context, EMPTY_BYTE_ARRAY, EMPTY_BYTE_ARRAY, ecflags);
            }
            this.writeconvAsciicompat = null;
        } else {
            Encoding sEncoding;
            Encoding enc = this.encs.enc2 != null ? this.encs.enc2 : this.encs.enc;
            Encoding tmpEnc = EncodingUtils.econvAsciicompatEncoding(enc);
            byte[] senc = tmpEnc == null ? null : tmpEnc.getName();
            Encoding encoding2 = sEncoding = tmpEnc == null ? null : tmpEnc;
            if (sEncoding == null && (this.encs.ecflags & 0xF00000) == 0) {
                this.writeconvPreEcflags = ecflags;
                this.writeconvPreEcopts = ecopts;
                this.writeconv = null;
                this.writeconvAsciicompat = null;
            } else {
                byte[] denc;
                this.writeconvPreEcflags = ecflags & 0xFF0FFFFF;
                this.writeconvPreEcopts = ecopts;
                if (sEncoding != null) {
                    denc = enc.getName();
                    this.writeconvAsciicompat = sEncoding;
                } else {
                    denc = EMPTY_BYTE_ARRAY;
                    senc = EMPTY_BYTE_ARRAY;
                    this.writeconvAsciicompat = enc;
                }
                ecflags = this.encs.ecflags & 0xF000FF;
                ecopts = this.encs.ecopts;
                this.writeconv = EncodingUtils.econvOpenOpts(context, senc, denc, ecflags, ecopts);
                if (this.writeconv == null) {
                    throw EncodingUtils.econvOpenExc(context, senc, denc, ecflags);
                }
            }
        }
    }

    public void clearReadConversion() {
        this.readconv = null;
    }

    public void clearCodeConversion() {
        this.readconv = null;
        this.writeconv = null;
    }

    public int IO_RBUF_CAPA_FOR() {
        return this.needsReadConversion() ? 131072 : 8192;
    }

    public int appendline(ThreadContext context, int delim, ByteList[] strp, int[] lp) {
        ByteList str = strp[0];
        int limit2 = lp[0];
        if (this.needsReadConversion()) {
            this.SET_BINARY_MODE();
            this.makeReadConversion(context);
            do {
                int e;
                int searchlen;
                if ((searchlen = this.READ_CHAR_PENDING_COUNT()) <= 0) continue;
                byte[] pBytes = this.READ_CHAR_PENDING_PTR();
                int p2 = this.READ_CHAR_PENDING_OFF();
                if (0 < limit2 && limit2 < searchlen) {
                    searchlen = limit2;
                }
                if ((e = OpenFile.memchr(pBytes, p2, delim, searchlen)) != -1) {
                    int len = e - p2 + 1;
                    if (str == null) {
                        strp[0] = str = new ByteList(pBytes, p2, len);
                    } else {
                        str.append(pBytes, p2, len);
                    }
                    this.cbuf.off += len;
                    this.cbuf.len -= len;
                    lp[0] = limit2 -= len;
                    return delim;
                }
                if (str == null) {
                    strp[0] = str = new ByteList(pBytes, p2, searchlen);
                } else {
                    EncodingUtils.rbStrBufCat(context.runtime, str, pBytes, p2, searchlen);
                }
                this.cbuf.off += searchlen;
                this.cbuf.len -= searchlen;
                if ((limit2 -= searchlen) != 0) continue;
                lp[0] = limit2;
                return str.get(str.getRealSize() - 1) & 0xFF;
            } while (this.moreChar(context) != 1);
            this.clearReadConversion();
            lp[0] = limit2;
            return -1;
        }
        this.NEED_NEWLINE_DECORATOR_ON_READ_CHECK();
        do {
            int pending;
            if ((pending = this.READ_DATA_PENDING_COUNT()) > 0) {
                int last2;
                int e;
                byte[] pBytes = this.READ_DATA_PENDING_PTR();
                int p3 = this.READ_DATA_PENDING_OFF();
                if (limit2 > 0 && pending > limit2) {
                    pending = limit2;
                }
                if ((e = OpenFile.memchr(pBytes, p3, delim, pending)) != -1) {
                    pending = e - p3 + 1;
                }
                if (str != null) {
                    last2 = str.getRealSize();
                    str.ensure(last2 + pending);
                } else {
                    last2 = 0;
                    strp[0] = str = new ByteList(pending);
                }
                this.readBufferedData(str.getUnsafeBytes(), last2 + str.getBegin(), pending);
                str.setRealSize(last2 + pending);
                limit2 -= pending;
                if (e != -1) {
                    lp[0] = limit2;
                    return delim;
                }
                if (limit2 == 0) {
                    lp[0] = limit2;
                    return str.get(str.getRealSize() - 1) & 0xFF;
                }
            }
            this.READ_CHECK(context);
        } while (this.fillbuf(context) >= 0);
        lp[0] = limit2;
        return -1;
    }

    private static int memchr(byte[] pBytes, int p2, int delim, int length2) {
        for (int i2 = p2; i2 < p2 + length2; ++i2) {
            if ((pBytes[i2] & 0xFF) != delim) continue;
            return i2;
        }
        return -1;
    }

    public void NEED_NEWLINE_DECORATOR_ON_READ_CHECK() {
        if (this.NEED_NEWLINE_DECORATOR_ON_READ()) {
            if (this.isReadable() && (this.encs.ecflags & 0x3F00) == 0) {
                this.SET_BINARY_MODE();
            } else {
                this.SET_TEXT_MODE();
            }
        }
    }

    public boolean NEED_NEWLINE_DECORATOR_ON_READ() {
        return this.isTextMode();
    }

    public boolean NEED_NEWLINE_DECORATOR_ON_WRITE() {
        return this.isTextMode();
    }

    public int moreChar(ThreadContext context) {
        Object v = this.fillCbuf(context, 131072);
        if (!(v instanceof Integer) || (Integer)v != 0 && (Integer)v != 1) {
            throw (RaiseException)v;
        }
        return (Integer)v;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object fillCbuf(ThreadContext context, int ec_flags) {
        ec_flags |= 0x10000;
        boolean locked = this.lock();
        try {
            EConvResult res;
            int de;
            int ds;
            if (this.cbuf.len == this.cbuf.capa) {
                Integer n = 0;
                return n;
            }
            if (this.cbuf.len == 0) {
                this.cbuf.off = 0;
            } else if (this.cbuf.off + this.cbuf.len == this.cbuf.capa) {
                System.arraycopy(this.cbuf.ptr, this.cbuf.off, this.cbuf.ptr, 0, this.cbuf.len);
                this.cbuf.off = 0;
            }
            int cbuf_len0 = this.cbuf.len;
            Ptr spPtr = new Ptr();
            Ptr dpPtr = new Ptr();
            while (true) {
                RaiseException exc;
                int ss = spPtr.p = this.rbuf.off;
                int se = spPtr.p + this.rbuf.len;
                ds = dpPtr.p = this.cbuf.off + this.cbuf.len;
                de = this.cbuf.capa;
                res = this.readconv.convert(this.rbuf.ptr, spPtr, se, this.cbuf.ptr, dpPtr, de, ec_flags);
                this.rbuf.off += spPtr.p - ss;
                this.rbuf.len -= spPtr.p - ss;
                this.cbuf.len += dpPtr.p - ds;
                int putbackable = this.readconv.putbackable();
                if (putbackable != 0) {
                    this.readconv.putback(this.rbuf.ptr, this.rbuf.off - putbackable, putbackable);
                    this.rbuf.off -= putbackable;
                    this.rbuf.len += putbackable;
                }
                if ((exc = EncodingUtils.makeEconvException(context.runtime, this.readconv)) != null) {
                    RaiseException raiseException = exc;
                    return raiseException;
                }
                if (cbuf_len0 != this.cbuf.len) {
                    Integer n = 0;
                    return n;
                }
                if (res == EConvResult.Finished) {
                    Integer n = 1;
                    return n;
                }
                if (res != EConvResult.SourceBufferEmpty || this.rbuf.len != 0) continue;
                this.READ_CHECK(context);
                if (this.fillbuf(context) == -1) break;
            }
            if (this.readconv == null) {
                Integer n = 1;
                return n;
            }
            ds = dpPtr.p = this.cbuf.off + this.cbuf.len;
            de = this.cbuf.capa;
            res = this.readconv.convert(null, null, 0, this.cbuf.ptr, dpPtr, de, 0);
            this.cbuf.len += dpPtr.p - ds;
            EncodingUtils.econvCheckError(context, this.readconv);
            if (cbuf_len0 != this.cbuf.len) {
                Integer n = 0;
                return n;
            }
        }
        finally {
            if (locked) {
                this.unlock();
            }
        }
        return 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int readBufferedData(byte[] ptrBytes, int ptr, int len) {
        boolean locked = this.lock();
        try {
            int n = this.rbuf.len;
            if (n <= 0) {
                int n2 = n;
                return n2;
            }
            if (n > len) {
                n = len;
            }
            System.arraycopy(this.rbuf.ptr, this.rbuf.start + this.rbuf.off, ptrBytes, ptr, n);
            this.rbuf.off += n;
            this.rbuf.len -= n;
            int n3 = n;
            return n3;
        }
        finally {
            if (locked) {
                this.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int fillbuf(ThreadContext context) {
        boolean locked = this.lock();
        try {
            if (this.rbuf.ptr == null) {
                this.rbuf.off = 0;
                this.rbuf.len = 0;
                this.rbuf.capa = this.IO_RBUF_CAPA_FOR();
                this.rbuf.ptr = new byte[this.rbuf.capa];
                if (Platform.IS_WINDOWS) {
                    --this.rbuf.capa;
                }
            }
            if (this.rbuf.len == 0) {
                int r;
                while ((r = OpenFile.readInternal(context, this, this.fd, this.rbuf.ptr, 0, this.rbuf.capa)) < 0) {
                    if (this.waitReadable(context, this.fd)) continue;
                    throw context.runtime.newErrnoFromErrno(this.posix.getErrno(), "channel: " + this.fd + (this.pathv != null ? " " + this.pathv : ""));
                }
                if (r > 0) {
                    this.checkClosed();
                }
                this.rbuf.off = 0;
                this.rbuf.len = r;
                if (r == 0) {
                    int n = -1;
                    return n;
                }
            }
        }
        finally {
            if (locked) {
                this.unlock();
            }
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int readInternal(ThreadContext context, OpenFile fptr, ChannelFD fd, byte[] bufBytes, int buf, int count2) {
        fptr.unlock();
        try {
            if (fd.chSelect != null && fd.chNative == null && !fptr.nonblock) {
                context.getThread().select((Channel)fd.chSelect, fptr, 1);
            }
        }
        finally {
            fptr.lock();
        }
        try {
            return context.getThread().executeReadWrite(context, fptr, bufBytes, buf, count2, READ_TASK);
        }
        catch (InterruptedException ie) {
            throw context.runtime.newConcurrencyError("IO operation interrupted");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean waitReadable(ThreadContext context, ChannelFD fd) {
        this.checkClosed();
        boolean locked = this.lock();
        try {
            if (!fd.ch.isOpen()) {
                this.posix.setErrno(Errno.EBADF);
                boolean bl = false;
                return bl;
            }
            if (this.posix.getErrno() != null && this.posix.getErrno() != Errno.EAGAIN && this.posix.getErrno() != Errno.EWOULDBLOCK && this.posix.getErrno() != Errno.EINTR) {
                boolean bl = false;
                return bl;
            }
            if (fd.chSelect != null) {
                this.unlock();
                try {
                    boolean bl = context.getThread().select((Channel)fd.chSelect, this, 1);
                    return bl;
                }
                finally {
                    this.lock();
                }
            }
            if (fd.chSeek != null) {
                boolean bl = true;
                return bl;
            }
        }
        finally {
            if (locked) {
                this.unlock();
            }
        }
        return false;
    }

    public Encoding readEncoding(Ruby runtime2) {
        return this.encs.enc != null ? this.encs.enc : EncodingUtils.defaultExternalEncoding(runtime2);
    }

    public Encoding inputEncoding(Ruby runtime2) {
        return this.encs.enc2 != null ? this.encs.enc2 : this.readEncoding(runtime2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean swallow(ThreadContext context, int term) {
        Ruby runtime2 = context.runtime;
        boolean locked = this.lock();
        try {
            if (this.needsReadConversion()) {
                int cnt;
                Encoding enc = this.readEncoding(runtime2);
                boolean needconv = enc.minLength() != 1;
                this.SET_BINARY_MODE();
                this.makeReadConversion(context);
                do {
                    int[] i2 = new int[]{0};
                    while ((cnt = this.READ_CHAR_PENDING_COUNT()) > 0) {
                        byte[] pBytes = this.READ_CHAR_PENDING_PTR();
                        int p2 = this.READ_CHAR_PENDING_OFF();
                        i2[0] = 0;
                        if (!needconv) {
                            if (pBytes[p2] != term) {
                                boolean bl = true;
                                return bl;
                            }
                            i2[0] = cnt;
                            while ((i2[0] = i2[0] - 1) != 0 && pBytes[++p2] == term) {
                            }
                        } else {
                            int e = p2 + cnt;
                            if (EncodingUtils.encAscget(pBytes, p2, e, i2, enc) != term) {
                                boolean bl = true;
                                return bl;
                            }
                            while ((p2 += i2[0]) < e && EncodingUtils.encAscget(pBytes, p2, e, i2, enc) == term) {
                            }
                            i2[0] = e - p2;
                        }
                        this.shiftCbuf(context, cnt - i2[0], null);
                    }
                } while (this.moreChar(context) != 1);
                cnt = 0;
                return cnt != 0;
            }
            this.NEED_NEWLINE_DECORATOR_ON_READ_CHECK();
            while (true) {
                int cnt;
                if ((cnt = this.READ_DATA_PENDING_COUNT()) > 0) {
                    byte[] buf = new byte[1024];
                    byte[] pBytes = this.READ_DATA_PENDING_PTR();
                    int p3 = this.READ_DATA_PENDING_OFF();
                    if (cnt > buf.length) {
                        cnt = buf.length;
                    }
                    if ((pBytes[p3] & 0xFF) != term) {
                        boolean bl = true;
                        return bl;
                    }
                    int i3 = cnt;
                    while (--i3 != 0 && (pBytes[++p3] & 0xFF) == term) {
                    }
                    if (this.readBufferedData(buf, 0, cnt - i3) != 0) continue;
                    throw context.runtime.newRuntimeError("failure copying buffered IO bytes");
                }
                this.READ_CHECK(context);
                if (this.fillbuf(context) != 0) break;
            }
        }
        finally {
            if (locked) {
                this.unlock();
            }
        }
        return false;
    }

    public RubyString shiftCbuf(ThreadContext context, int len, IRubyObject strp) {
        RubyString str = null;
        if (strp != null) {
            str = strp.isNil() ? RubyString.newStringLight(context.runtime, len) : (RubyString)strp;
            str.setTaint(true);
            EncodingUtils.encAssociateIndex(str, this.encs.enc);
        }
        return this.shiftCbuf(len, str);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RubyString shiftCbuf(int len, RubyString str) {
        boolean locked = this.lock();
        try {
            if (str != null) {
                str.cat(this.cbuf.ptr, this.cbuf.off, len);
                str.setTaint(true);
                EncodingUtils.encAssociateIndex(str, this.encs.enc);
            }
            this.cbuf.off += len;
            this.cbuf.len -= len;
            if (this.cbuf.len == 0) {
                this.cbuf.off = 0;
            } else if (this.cbuf.capa / 2 < this.cbuf.off) {
                System.arraycopy(this.cbuf.ptr, this.cbuf.off, this.cbuf.ptr, 0, this.cbuf.len);
                this.cbuf.off = 0;
            }
            RubyString rubyString = str;
            return rubyString;
        }
        finally {
            if (locked) {
                this.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IRubyObject getlineFast(ThreadContext context, Encoding enc, RubyIO io2, boolean chomp2) {
        Ruby runtime2 = context.runtime;
        RubyString str = null;
        int len = 0;
        int pos2 = 0;
        int cr = 0;
        boolean locked = this.lock();
        try {
            do {
                int pending;
                if ((pending = this.READ_DATA_PENDING_COUNT()) > 0) {
                    ByteList strByteList;
                    byte[] pBytes = this.READ_DATA_PENDING_PTR();
                    int p2 = this.READ_DATA_PENDING_OFF();
                    int chomplen = 0;
                    int e = OpenFile.memchr(pBytes, p2, 10, pending);
                    if (e != -1) {
                        pending = e - p2 + 1;
                        if (chomp2) {
                            chomplen = (pending > 1 && pBytes[e - 1] == 13 ? 1 : 0) + 1;
                        }
                    }
                    if (str == null) {
                        str = RubyString.newString(runtime2, pBytes, p2, pending - chomplen);
                        strByteList = str.getByteList();
                        this.rbuf.off += pending;
                        this.rbuf.len -= pending;
                    } else {
                        str.resize(len + pending - chomplen);
                        strByteList = str.getByteList();
                        this.readBufferedData(strByteList.unsafeBytes(), strByteList.begin() + len, pending - chomplen);
                        this.rbuf.off += chomplen;
                        this.rbuf.len -= chomplen;
                    }
                    int beg = strByteList.begin();
                    pos2 = (int)((long)pos2 + StringSupport.codeRangeScanRestartable(enc, strByteList.unsafeBytes(), beg + pos2, beg + (len += pending - chomplen), cr));
                    if (e != -1) break;
                }
                this.READ_CHECK(context);
            } while (this.fillbuf(context) >= 0);
            if (str == null) {
                IRubyObject iRubyObject = context.nil;
                return iRubyObject;
            }
            str = (RubyString)EncodingUtils.ioEncStr(runtime2, str, this);
            str.setCodeRange(cr);
            this.incrementLineno(runtime2, io2);
        }
        finally {
            if (locked) {
                this.unlock();
            }
        }
        return str;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void incrementLineno(Ruby runtime2, RubyIO io2) {
        boolean locked = this.lock();
        try {
            ++this.lineno;
            if (RubyArgsFile.ArgsFileData.getArgsFileData(runtime2).isCurrentFile(io2)) {
                runtime2.setCurrentLine(runtime2.getCurrentLine() + 1);
            } else {
                runtime2.setCurrentLine(this.lineno);
            }
        }
        finally {
            if (locked) {
                this.unlock();
            }
        }
    }

    @Deprecated
    public void incrementLineno(Ruby runtime2) {
        boolean locked = this.lock();
        try {
            ++this.lineno;
        }
        finally {
            if (locked) {
                this.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IRubyObject readAll(ThreadContext context, int siz, IRubyObject str) {
        int cr;
        Ruby runtime2 = context.runtime;
        boolean locked = this.lock();
        try {
            if (this.needsReadConversion()) {
                this.SET_BINARY_MODE();
                str = EncodingUtils.setStrBuf(runtime2, str, 0);
                this.makeReadConversion(context);
                while (true) {
                    Object v;
                    if (this.cbuf.len != 0) {
                        str = this.shiftCbuf(context, this.cbuf.len, str);
                    }
                    if (!(v = this.fillCbuf(context, 0)).equals(0) && !v.equals(1)) {
                        if (this.cbuf.len != 0) {
                            this.shiftCbuf(context, this.cbuf.len, str);
                        }
                        throw (RaiseException)v;
                    }
                    if (!v.equals(1)) continue;
                    this.clearReadConversion();
                    IRubyObject iRubyObject = EncodingUtils.ioEncStr(runtime2, str, this);
                    return iRubyObject;
                }
            }
            this.NEED_NEWLINE_DECORATOR_ON_READ_CHECK();
            int bytes2 = 0;
            int pos2 = 0;
            Encoding enc = this.readEncoding(runtime2);
            cr = 0;
            if (siz == 0) {
                siz = 1024;
            }
            while (true) {
                this.READ_CHECK(context);
                str = EncodingUtils.setStrBuf(context.runtime, str, siz);
                ByteList strByteList = ((RubyString)str).getByteList();
                int n = this.fread(context, strByteList.unsafeBytes(), strByteList.begin() + bytes2, siz - bytes2);
                if (n == 0 && bytes2 == 0) {
                    ((RubyString)str).resize(0);
                    break;
                }
                strByteList.setRealSize(bytes2 += n);
                int beg = strByteList.begin();
                pos2 = (int)((long)pos2 + StringSupport.codeRangeScanRestartable(enc, strByteList.unsafeBytes(), beg + pos2, beg + bytes2, cr));
                if (bytes2 < siz) break;
                siz += 1024;
                ((RubyString)str).modify(1024);
            }
            str = EncodingUtils.ioEncStr(runtime2, str, this);
        }
        finally {
            if (locked) {
                this.unlock();
            }
        }
        ((RubyString)str).setCodeRange(cr);
        return str;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int ioBufread(ThreadContext context, byte[] ptrBytes, int ptr, int len) {
        int offset2 = 0;
        int n = len;
        boolean locked = this.lock();
        try {
            if (!this.READ_DATA_PENDING()) {
                block5: while (n > 0) {
                    int c;
                    while ((c = OpenFile.readInternal(context, this, this.fd, ptrBytes, ptr + offset2, n)) != 0) {
                        if (c < 0) {
                            if (this.waitReadable(context, this.fd)) continue;
                            int n2 = -1;
                            return n2;
                        }
                        offset2 += c;
                        if ((n -= c) > 0) continue block5;
                    }
                    break block5;
                }
                int n3 = len - n;
                return n3;
            }
            do {
                if (n <= 0) return len - n;
                int c = this.readBufferedData(ptrBytes, ptr + offset2, n);
                if (c > 0) {
                    offset2 += c;
                    if ((n -= c) <= 0) {
                        return len - n;
                    }
                }
                this.checkClosed();
            } while (this.fillbuf(context) >= 0);
            return len - n;
        }
        finally {
            if (locked) {
                this.unlock();
            }
        }
    }

    public int fread(ThreadContext context, byte[] buffer, int offset2, int size2) {
        if ((size2 = this.ioBufread(context, buffer, offset2, size2)) < 0) {
            throw context.runtime.newErrnoFromErrno(this.posix.getErrno(), this.pathv);
        }
        return size2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ungetbyte(ThreadContext context, IRubyObject str) {
        int len = ((RubyString)str).size();
        boolean locked = this.lock();
        try {
            if (this.rbuf.ptr == null) {
                int min_capa = this.IO_RBUF_CAPA_FOR();
                this.rbuf.off = 0;
                this.rbuf.len = 0;
                this.rbuf.capa = len > min_capa ? len : min_capa;
                this.rbuf.ptr = new byte[this.rbuf.capa];
            }
            if (this.rbuf.capa < len + this.rbuf.len) {
                throw context.runtime.newIOError("ungetbyte failed");
            }
            if (this.rbuf.off < len) {
                System.arraycopy(this.rbuf.ptr, this.rbuf.off, this.rbuf.ptr, this.rbuf.capa - this.rbuf.len, this.rbuf.len);
                this.rbuf.off = this.rbuf.capa - this.rbuf.len;
            }
            this.rbuf.off -= len;
            this.rbuf.len += len;
            ByteList strByteList = ((RubyString)str).getByteList();
            System.arraycopy(strByteList.unsafeBytes(), strByteList.begin(), this.rbuf.ptr, this.rbuf.off, len);
        }
        finally {
            if (locked) {
                this.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IRubyObject getc(ThreadContext context, Encoding enc) {
        IRubyObject str;
        Ruby runtime2 = context.runtime;
        int cr = 0;
        boolean locked = this.lock();
        try {
            if (this.needsReadConversion()) {
                int r;
                Encoding read_enc;
                IRubyObject str2;
                block26: {
                    str2 = context.nil;
                    read_enc = this.readEncoding(runtime2);
                    this.SET_BINARY_MODE();
                    this.makeReadConversion(context, 0);
                    do {
                        if (this.cbuf.len == 0) continue;
                        r = StringSupport.preciseLength(read_enc, this.cbuf.ptr, this.cbuf.off, this.cbuf.off + this.cbuf.len);
                        if (StringSupport.MBCLEN_NEEDMORE_P(r)) {
                            if (this.cbuf.len != this.cbuf.capa) continue;
                            throw runtime2.newIOError("too long character");
                        }
                        break block26;
                    } while (this.moreChar(context) != 1);
                    if (this.cbuf.len == 0) {
                        this.clearReadConversion();
                        IRubyObject iRubyObject = context.nil;
                        return iRubyObject;
                    }
                    str2 = RubyString.newString(runtime2, this.cbuf.ptr, this.cbuf.off, 1, read_enc);
                    ++this.cbuf.off;
                    --this.cbuf.len;
                    if (this.cbuf.len == 0) {
                        this.clearReadConversion();
                    }
                    ((RubyString)str2).setCodeRange(48);
                    IRubyObject iRubyObject = str2;
                    return iRubyObject;
                }
                if (StringSupport.MBCLEN_INVALID_P(r)) {
                    r = read_enc.length(this.cbuf.ptr, this.cbuf.off, this.cbuf.off + this.cbuf.len);
                    str2 = this.shiftCbuf(context, r, str2);
                    cr = 48;
                } else {
                    str2 = this.shiftCbuf(context, StringSupport.MBCLEN_CHARFOUND_LEN(r), str2);
                    cr = 32;
                    if (StringSupport.MBCLEN_CHARFOUND_LEN(r) == 1 && read_enc.isAsciiCompatible() && Encoding.isAscii(((RubyString)str2).getByteList().get(0))) {
                        cr = 16;
                    }
                }
                str2 = EncodingUtils.ioEncStr(runtime2, str2, this);
                ((RubyString)str2).setCodeRange(cr);
                IRubyObject iRubyObject = str2;
                return iRubyObject;
            }
            this.NEED_NEWLINE_DECORATOR_ON_READ_CHECK();
            if (this.fillbuf(context) < 0) {
                IRubyObject read_enc = context.nil;
                return read_enc;
            }
            if (enc.isAsciiCompatible() && Encoding.isAscii(this.rbuf.ptr[this.rbuf.off])) {
                str = RubyString.newString(runtime2, this.rbuf.ptr, this.rbuf.off, 1);
                ++this.rbuf.off;
                --this.rbuf.len;
                cr = 16;
            } else {
                int n;
                int r = StringSupport.preciseLength(enc, this.rbuf.ptr, this.rbuf.off, this.rbuf.off + this.rbuf.len);
                if (StringSupport.MBCLEN_CHARFOUND_P(r) && (n = StringSupport.MBCLEN_CHARFOUND_LEN(r)) <= this.rbuf.len) {
                    str = RubyString.newString(runtime2, this.rbuf.ptr, this.rbuf.off, n);
                    this.rbuf.off += n;
                    this.rbuf.len -= n;
                    cr = 32;
                } else if (StringSupport.MBCLEN_NEEDMORE_P(r)) {
                    str = RubyString.newString(runtime2, this.rbuf.ptr, this.rbuf.off, this.rbuf.len);
                    this.rbuf.len = 0;
                    while (this.fillbuf(context) != -1) {
                        ((RubyString)str).cat(this.rbuf.ptr[this.rbuf.off]);
                        ++this.rbuf.off;
                        --this.rbuf.len;
                        ByteList strByteList = ((RubyString)str).getByteList();
                        r = StringSupport.preciseLength(enc, strByteList.unsafeBytes(), strByteList.getBegin(), strByteList.getBegin() + strByteList.length());
                        if (StringSupport.MBCLEN_NEEDMORE_P(r)) continue;
                        if (StringSupport.MBCLEN_CHARFOUND_P(r)) {
                            cr = 32;
                        }
                        break;
                    }
                } else {
                    str = RubyString.newString(runtime2, this.rbuf.ptr, this.rbuf.off, 1);
                    ++this.rbuf.off;
                    --this.rbuf.len;
                }
            }
            if (cr == 0) {
                cr = 48;
            }
            str = EncodingUtils.ioEncStr(runtime2, str, this);
        }
        finally {
            if (locked) {
                this.unlock();
            }
        }
        ((RubyString)str).setCodeRange(cr);
        return str;
    }

    public synchronized long tell(ThreadContext context) {
        this.flushBeforeSeek(context);
        return this.posix.lseek(this.fd, 0L, 1);
    }

    public synchronized void unread(ThreadContext context) {
        if (Platform.IS_WINDOWS) {
            this.unreadWindows(context);
        } else {
            this.unreadPosix();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unreadPosix() {
        boolean locked = this.lock();
        try {
            this.checkClosed();
            if (this.rbuf.len == 0 || (this.mode & 0x20) != 0) {
                return;
            }
            this.posix.setErrno(null);
            long r = this.posix.lseek(this.fd, -this.rbuf.len, 1);
            if (r == -1L && this.posix.getErrno() != null) {
                if (this.posix.getErrno() == Errno.ESPIPE) {
                    this.mode |= 0x20;
                }
                return;
            }
            this.rbuf.off = 0;
            this.rbuf.len = 0;
        }
        finally {
            if (locked) {
                this.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unreadWindows(ThreadContext context) {
        Ruby runtime2 = context.runtime;
        int newlines = 0;
        int buf = 0;
        boolean locked = this.lock();
        try {
            this.checkClosed();
            if (this.rbuf.len == 0 || (this.mode & 0x20) != 0) {
                return;
            }
            long pos2 = this.posix.lseek(this.fd, 0L, 1);
            if (pos2 == -1L && this.posix.getErrno() != null) {
                if (this.posix.getErrno() == Errno.ESPIPE) {
                    this.mode |= 0x20;
                }
                return;
            }
            long extra_max = pos2 - (long)this.rbuf.len;
            byte[] pBytes = this.rbuf.ptr;
            int p2 = this.rbuf.off;
            if (this.rbuf.ptr[this.rbuf.capa - 1] == 13) {
                ++newlines;
            }
            for (long i2 = 0L; i2 < (long)this.rbuf.len; ++i2) {
                if (pBytes[p2] == 10) {
                    ++newlines;
                }
                if (extra_max == (long)newlines) break;
                ++p2;
            }
            byte[] bufBytes = new byte[this.rbuf.len + newlines];
            while (newlines >= 0) {
                long r = this.posix.lseek(this.fd, pos2 - (long)this.rbuf.len - (long)newlines, 0);
                if (newlines == 0) break;
                if (r == -1L) {
                    --newlines;
                    continue;
                }
                int read_size = OpenFile.readInternal(context, this, this.fd, bufBytes, buf, this.rbuf.len + newlines);
                if (read_size < 0) {
                    throw runtime2.newErrnoFromErrno(this.posix.getErrno(), this.pathv);
                }
                if (read_size == this.rbuf.len) {
                    this.posix.lseek(this.fd, r, 0);
                    break;
                }
                --newlines;
            }
            this.rbuf.off = 0;
            this.rbuf.len = 0;
        }
        finally {
            if (locked) {
                this.unlock();
            }
        }
    }

    public long fwrite(ThreadContext context, RubyString str, boolean nosync) {
        if (Platform.IS_WINDOWS && this.isStdio() && System.console() != null) {
            return OpenFile.rbW32WriteConsole(str);
        }
        str = this.doWriteconv(context, str);
        ByteList strByteList = str.getByteList();
        return this.binwriteInt(context, strByteList.unsafeBytes(), strByteList.begin(), strByteList.length(), nosync);
    }

    public int fwrite(ThreadContext context, byte[] bytes2, int start2, int length2, Encoding encoding2, boolean nosync) {
        if (Platform.IS_WINDOWS && this.isStdio() && System.console() != null) {
            return OpenFile.rbW32WriteConsole(bytes2, start2, length2, encoding2);
        }
        ByteList str = this.doWriteconv(context, bytes2, start2, length2, encoding2);
        if (str != null) {
            bytes2 = str.unsafeBytes();
            start2 = str.begin();
            length2 = str.realSize();
        }
        return this.binwriteInt(context, bytes2, start2, length2, nosync);
    }

    public static long rbW32WriteConsole(RubyString buffer) {
        ByteList bl = buffer.getByteList();
        return OpenFile.rbW32WriteConsole(bl.unsafeBytes(), bl.begin(), bl.realSize(), bl.getEncoding());
    }

    public static int rbW32WriteConsole(byte[] bytes2, int start2, int length2, Encoding encoding2) {
        System.console().printf("%s", RubyEncoding.decode(bytes2, start2, length2, encoding2.getCharset()));
        return length2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RubyString doWriteconv(ThreadContext context, RubyString str) {
        boolean locked = this.lock();
        try {
            if (this.needsWriteConversion(context)) {
                this.SET_BINARY_MODE();
                this.makeWriteConversion(context);
                Encoding common_encoding = this.getCommonEncodingForWriteConv(context, str.getEncoding());
                if (common_encoding != null) {
                    str = (RubyString)EncodingUtils.rbStrEncode(context, str, this.runtime.getEncodingService().convertEncodingToRubyEncoding(common_encoding), this.writeconvPreEcflags, this.writeconvPreEcopts);
                }
                if (this.writeconv != null) {
                    str = context.runtime.newString(EncodingUtils.econvStrConvert(context, this.writeconv, str.getByteList(), 65536));
                }
            }
        }
        finally {
            if (locked) {
                this.unlock();
            }
        }
        return str;
    }

    protected Encoding getCommonEncodingForWriteConv(ThreadContext context, Encoding strEncoding) {
        Encoding common_encoding = null;
        if (this.writeconv != null) {
            int fmode = this.mode;
            if (this.writeconvAsciicompat != null) {
                common_encoding = this.writeconvAsciicompat;
            } else if (EncodingUtils.MODE_BTMODE(fmode, EncodingUtils.DEFAULT_TEXTMODE, 0, 1) != 0 && !strEncoding.isAsciiCompatible()) {
                throw context.runtime.newArgumentError("ASCII incompatible string written for text mode IO without encoding conversion: %s" + strEncoding.toString());
            }
        } else if (this.encs.enc2 != null) {
            common_encoding = this.encs.enc2;
        } else if (this.encs.enc != EncodingUtils.ascii8bitEncoding(context.runtime)) {
            common_encoding = this.encs.enc;
        }
        return common_encoding;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ByteList doWriteconv(ThreadContext context, byte[] bytes2, int start2, int length2, Encoding encoding2) {
        boolean locked = this.lock();
        ByteList newBytes = null;
        try {
            if (this.needsWriteConversion(context)) {
                this.SET_BINARY_MODE();
                this.makeWriteConversion(context);
                Encoding common_encoding = this.getCommonEncodingForWriteConv(context, encoding2);
                if (common_encoding != null) {
                    newBytes = EncodingUtils.rbByteEncode(context, bytes2, start2, length2, encoding2, 0, common_encoding, this.writeconvPreEcflags, this.writeconvPreEcopts);
                }
                if (this.writeconv != null) {
                    newBytes = newBytes != null ? EncodingUtils.econvStrConvert(context, this.writeconv, newBytes, 65536) : EncodingUtils.econvByteConvert(context, this.writeconv, bytes2, start2, length2, 65536);
                }
            }
        }
        finally {
            if (locked) {
                this.unlock();
            }
        }
        return newBytes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int binwriteInt(ThreadContext context, byte[] ptrBytes, int ptr, int len, boolean nosync) {
        int offset2 = 0;
        context.blockingThreadPoll();
        boolean locked = this.lock();
        try {
            int n = len;
            if (n <= 0) {
                int n2 = n;
                return n2;
            }
            if (this.wbuf.ptr == null && (nosync || (this.mode & 8) == 0)) {
                this.wbuf.off = 0;
                this.wbuf.len = 0;
                this.wbuf.capa = 8192;
                this.wbuf.ptr = new byte[this.wbuf.capa];
            }
            if (!nosync && (this.mode & 0x18) != 0 || this.wbuf.ptr != null && this.wbuf.capa <= this.wbuf.len + len) {
                int n3;
                if (this.wbuf.len != 0 && this.wbuf.len + len <= this.wbuf.capa) {
                    if (this.wbuf.capa < this.wbuf.off + this.wbuf.len + len) {
                        System.arraycopy(this.wbuf.ptr, this.wbuf.off, this.wbuf.ptr, 0, this.wbuf.len);
                        this.wbuf.off = 0;
                    }
                    System.arraycopy(ptrBytes, ptr + offset2, this.wbuf.ptr, this.wbuf.off + this.wbuf.len, len);
                    this.wbuf.len += len;
                    n = 0;
                }
                if (this.io_fflush(context) < 0) {
                    int n4 = -1;
                    return n4;
                }
                if (n == 0) {
                    int n5 = len;
                    return n5;
                }
                this.checkClosed();
                OpenFile fptr = this;
                do {
                    int r;
                    int start2 = ptr + offset2;
                    int length2 = n;
                    if (this.write_lock != null) {
                        this.write_lock.writeLock().lock();
                        try {
                            r = OpenFile.binwriteString(fptr, ptrBytes, start2, length2);
                        }
                        finally {
                            this.write_lock.writeLock().unlock();
                        }
                    } else {
                        int l = this.writableLength(n);
                        r = OpenFile.writeInternal(context, this, ptrBytes, ptr + offset2, l);
                    }
                    if (r == n) {
                        n3 = len;
                        return n3;
                    }
                    if (0 <= r) {
                        offset2 += r;
                        n -= r;
                        this.posix.setErrno(Errno.EAGAIN);
                    }
                    if (!this.waitWritable(context)) break;
                    this.checkClosed();
                } while (offset2 < len);
                n3 = -1;
                return n3;
            }
            if (this.wbuf.off != 0) {
                if (this.wbuf.len != 0) {
                    System.arraycopy(this.wbuf.ptr, this.wbuf.off, this.wbuf.ptr, 0, this.wbuf.len);
                }
                this.wbuf.off = 0;
            }
            System.arraycopy(ptrBytes, ptr + offset2, this.wbuf.ptr, this.wbuf.off + this.wbuf.len, len);
            this.wbuf.len += len;
        }
        finally {
            if (locked) {
                this.unlock();
            }
        }
        return len;
    }

    static int binwriteString(OpenFile fptr, byte[] bytes2, int start2, int length2) {
        int l = fptr.writableLength(length2);
        return fptr.writeInternal2(fptr.fd, bytes2, start2, l);
    }

    public static int writeInternal(ThreadContext context, OpenFile fptr, byte[] bufBytes, int buf, int count2) {
        try {
            return context.getThread().executeReadWrite(context, fptr, bufBytes, buf, count2, WRITE_TASK);
        }
        catch (InterruptedException ie) {
            throw context.runtime.newConcurrencyError("IO operation interrupted");
        }
    }

    int writeInternal2(ChannelFD fd, byte[] bufBytes, int buf, int count2) {
        return this.posix.write(fd, bufBytes, buf, count2, this.nonblock);
    }

    public ChannelFD fd() {
        return this.fd;
    }

    public Channel channel() {
        assert (this.fd != null);
        return this.fd.ch;
    }

    public ReadableByteChannel readChannel() {
        assert (this.fd != null);
        return this.fd.chRead;
    }

    public WritableByteChannel writeChannel() {
        assert (this.fd != null);
        return this.fd.chWrite;
    }

    public SeekableByteChannel seekChannel() {
        assert (this.fd != null);
        return this.fd.chSeek;
    }

    public SelectableChannel selectChannel() {
        assert (this.fd != null);
        return this.fd.chSelect;
    }

    public FileChannel fileChannel() {
        assert (this.fd != null);
        return this.fd.chFile;
    }

    public SocketChannel socketChannel() {
        assert (this.fd != null);
        return this.fd.chSock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    IRubyObject finishWriteconv(ThreadContext context, boolean noalloc) {
        Ptr dpPtr = new Ptr();
        boolean locked = this.lock();
        try {
            if (this.wbuf.ptr == null) {
                byte[] buf = new byte[1024];
                EConvResult res = EConvResult.DestinationBufferFull;
                while (res == EConvResult.DestinationBufferFull) {
                    byte[] dsBytes = buf;
                    dpPtr.p = 0;
                    int ds = 0;
                    int de = buf.length;
                    res = this.writeconv.convert(null, null, 0, dsBytes, dpPtr, de, 0);
                    if (dpPtr.p - ds != 0) {
                        long r;
                        while ((r = this.write_lock != null && this.write_lock.isWriteLockedByCurrentThread() ? (long)this.writeInternal2(this.fd, dsBytes, ds, dpPtr.p - ds) : (long)OpenFile.writeInternal(context, this, dsBytes, ds, dpPtr.p - ds)) != (long)(dpPtr.p - ds)) {
                            if (0L <= r) {
                                ds = (int)((long)ds + r);
                            }
                            if (this.waitWritable(context)) {
                                if (this.fd != null) continue;
                                RubyBoolean rubyBoolean = noalloc ? context.tru : this.runtime.newIOError("closed stream").getException();
                                return rubyBoolean;
                            }
                            RubyBoolean rubyBoolean = noalloc ? context.tru : RubyFixnum.newFixnum(this.runtime, this.posix.getErrno() == null ? 0L : this.posix.getErrno().longValue());
                            return rubyBoolean;
                        }
                    }
                    if (res != EConvResult.InvalidByteSequence && res != EConvResult.IncompleteInput && res != EConvResult.UndefinedConversion) continue;
                    RubyBoolean rubyBoolean = noalloc ? context.tru : EncodingUtils.makeEconvException(this.runtime, this.writeconv).getException();
                    return rubyBoolean;
                }
                IRubyObject iRubyObject = context.nil;
                return iRubyObject;
            }
            EConvResult res = EConvResult.DestinationBufferFull;
            while (res == EConvResult.DestinationBufferFull) {
                if (this.wbuf.len == this.wbuf.capa && this.io_fflush(context) < 0) {
                    RubyBoolean rubyBoolean = noalloc ? context.tru : this.runtime.newFixnum(this.posix.getErrno() == null ? 0L : this.posix.getErrno().longValue());
                    return rubyBoolean;
                }
                byte[] dsBytes = this.wbuf.ptr;
                int ds = dpPtr.p = this.wbuf.off + this.wbuf.len;
                int de = this.wbuf.capa;
                res = this.writeconv.convert(null, null, 0, dsBytes, dpPtr, de, 0);
                this.wbuf.len += dpPtr.p - ds;
                if (res != EConvResult.InvalidByteSequence && res != EConvResult.IncompleteInput && res != EConvResult.UndefinedConversion) continue;
                RubyBoolean rubyBoolean = noalloc ? context.tru : EncodingUtils.makeEconvException(this.runtime, this.writeconv).getException();
                return rubyBoolean;
            }
        }
        finally {
            if (locked) {
                this.unlock();
            }
        }
        return context.nil;
    }

    public void setNonblock(Ruby runtime2) {
        this.setBlocking(runtime2, false);
    }

    public void setBlock(Ruby runtime2) {
        this.setBlocking(runtime2, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBlocking(Ruby runtime2, boolean blocking) {
        block6: {
            boolean locked = this.lock();
            try {
                this.nonblock = !blocking;
                ChannelFD fd = this.fd;
                this.checkClosed();
                if (fd.chSelect == null) break block6;
                try {
                    fd.chSelect.configureBlocking(blocking);
                }
                catch (IOException ioe) {
                    throw runtime2.newIOErrorFromException(ioe);
                }
            }
            finally {
                if (locked) {
                    this.unlock();
                }
            }
        }
    }

    public boolean isBlocking() {
        return !this.nonblock;
    }

    public void checkTTY() {
        if (this.fd.realFileno != -1 && this.runtime.getPosix().isatty(this.fd.realFileno) != 0 || this.stdio_file != null) {
            boolean locked = this.lock();
            try {
                this.mode |= 0x30;
            }
            finally {
                if (locked) {
                    this.unlock();
                }
            }
        }
        this.runtime.getPosix().errno(0);
    }

    public boolean isBOM() {
        return (this.mode & 0x100000) != 0;
    }

    public void setBOM(boolean bom) {
        boolean locked = this.lock();
        try {
            this.mode = bom ? (this.mode |= 0x100000) : (this.mode &= 0xFFEFFFFF);
        }
        finally {
            if (locked) {
                this.unlock();
            }
        }
    }

    public boolean isStdio() {
        return this.stdio_file != null;
    }

    public int readPending() {
        this.lock();
        try {
            if (this.READ_CHAR_PENDING()) {
                int n = 1;
                return n;
            }
            int n = this.READ_DATA_PENDING_COUNT();
            return n;
        }
        finally {
            this.unlock();
        }
    }

    @Deprecated
    public static int getFModeFromString(String modesString) throws InvalidValueException {
        int fmode = 0;
        int length2 = modesString.length();
        if (length2 == 0) {
            throw new InvalidValueException();
        }
        switch (modesString.charAt(0)) {
            case 'r': {
                fmode |= 1;
                break;
            }
            case 'w': {
                fmode |= 0x882;
                break;
            }
            case 'a': {
                fmode |= 0xC2;
                break;
            }
            default: {
                throw new InvalidValueException();
            }
        }
        block11: for (int n = 1; n < length2; ++n) {
            switch (modesString.charAt(n)) {
                case 'b': {
                    fmode |= 4;
                    continue block11;
                }
                case 't': {
                    fmode |= 0x1000;
                    continue block11;
                }
                case '+': {
                    fmode |= 3;
                    continue block11;
                }
                case ':': {
                    break block11;
                }
                default: {
                    throw new InvalidValueException();
                }
            }
        }
        return fmode;
    }

    public int getFileno() {
        return this.fd.bestFileno(true);
    }

    public int threadFlock(ThreadContext context, final int lockMode) {
        int ret = 0;
        try {
            ret = context.getThread().executeTaskBlocking(context, this, new RubyThread.Task<OpenFile, Integer>(){

                @Override
                public Integer run(ThreadContext context, OpenFile openFile) throws InterruptedException {
                    return OpenFile.this.posix.flock(OpenFile.this.fd, lockMode);
                }

                @Override
                public void wakeup(RubyThread thread2, OpenFile openFile) {
                    thread2.getNativeThread().interrupt();
                }
            });
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return ret;
    }

    public Errno errno() {
        return this.posix.getErrno();
    }

    public void errno(Errno newErrno) {
        this.posix.setErrno(newErrno);
    }

    public static int cloexecDup2(PosixShim posix, ChannelFD oldfd, ChannelFD newfd) {
        int ret;
        if (oldfd == newfd) {
            ret = 0;
        } else {
            ret = posix.dup2(oldfd, newfd);
            if (ret == -1) {
                return -1;
            }
        }
        OpenFile.fdFixCloexec(posix, ret);
        return ret;
    }

    public static void fdFixCloexec(PosixShim posix, int fd) {
        if (fd >= 0 && fd < 100000) {
            int ret;
            int flags2 = posix.fcntlGetFD(fd);
            if (flags2 == -1) {
                throw new AssertionError((Object)String.format("BUG: rb_maygvl_fd_fix_cloexec: fcntl(%d, F_GETFD) failed: %s", fd, posix.getErrno().description()));
            }
            int flags22 = fd <= 2 ? flags2 & 0xFFFFFFFE : flags2 | 1;
            if (flags2 != flags22 && (ret = posix.fcntlSetFD(fd, flags22)) == -1) {
                throw new AssertionError((Object)String.format("BUG: rb_maygvl_fd_fix_cloexec: fcntl(%d, F_SETFD, %d) failed: %s", fd, flags22, posix.getErrno().description()));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addBlockingThread(RubyThread thread2) {
        Object object;
        Set<RubyThread> blockingThreads = this.blockingThreads;
        if (blockingThreads == null) {
            object = this;
            synchronized (object) {
                blockingThreads = this.blockingThreads;
                if (blockingThreads == null) {
                    this.blockingThreads = blockingThreads = new HashSet<RubyThread>(1);
                }
            }
        }
        object = blockingThreads;
        synchronized (object) {
            blockingThreads.add(thread2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeBlockingThread(RubyThread thread2) {
        Set<RubyThread> blockingThreads = this.blockingThreads;
        if (blockingThreads == null) {
            return;
        }
        Set<RubyThread> set2 = blockingThreads;
        synchronized (set2) {
            blockingThreads.remove(thread2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void interruptBlockingThreads(ThreadContext context) {
        Set<RubyThread> blockingThreads = this.blockingThreads;
        if (blockingThreads == null) {
            return;
        }
        Set<RubyThread> set2 = blockingThreads;
        synchronized (set2) {
            for (RubyThread thread2 : blockingThreads) {
                if (thread2 == context.getThread()) continue;
                RubyException exception2 = (RubyException)this.runtime.getIOError().newInstance(context, this.runtime.newString("stream closed in another thread"), Block.NULL_BLOCK);
                thread2.raise(exception2);
            }
        }
    }

    public void waitForBlockingThreads(ThreadContext context) {
        Set<RubyThread> blockingThreads = this.blockingThreads;
        if (blockingThreads == null) {
            return;
        }
        while (blockingThreads.size() > 0) {
            try {
                context.getThread().sleep(1L);
            }
            catch (InterruptedException ie) {
                break;
            }
        }
    }

    public void SET_BINARY_MODE() {
    }

    private void SET_TEXT_MODE() {
    }

    public int remainSize() {
        long pos2;
        int siz = this.READ_DATA_PENDING_COUNT();
        long size2 = this.posix.size(this.fd);
        if (size2 >= 0L && (pos2 = this.posix.lseek(this.fd, 0L, 1)) != -1L && size2 > pos2) {
            if ((long)siz + (size2 - pos2) > Integer.MAX_VALUE) {
                throw this.runtime.newIOError("file too big for single read");
            }
            siz = (int)((long)siz + (size2 - pos2));
        } else {
            siz += 1024;
        }
        return siz;
    }

    public boolean lock() {
        if (this.lock.isHeldByCurrentThread()) {
            return false;
        }
        this.lock.lock();
        return true;
    }

    public void unlock() {
        assert (this.lock.isHeldByCurrentThread());
        this.lock.unlock();
    }

    public boolean lockedByMe() {
        return this.lock.isHeldByCurrentThread();
    }

    @Deprecated
    public long binwrite(ThreadContext context, byte[] ptrBytes, int ptr, int len, boolean nosync) {
        return this.binwriteInt(context, ptrBytes, ptr, len, nosync);
    }

    public static class Buffer {
        public byte[] ptr;
        public int start;
        public int off;
        public int len;
        public int capa;
    }

    public static interface Finalizer {
        public void finalize(Ruby var1, OpenFile var2, boolean var3);
    }
}

