/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.model;

import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotationValue;
import org.semanticweb.owlapi.model.OWLAnonymousIndividual;
import org.semanticweb.owlapi.model.OWLLiteral;

public interface HasAnnotationValue {
    default public Optional<IRI> iriValue() {
        return Optional.ofNullable(this.annotationValue().asIRI().orNull());
    }

    default public Optional<OWLLiteral> literalValue() {
        return Optional.ofNullable(this.annotationValue().asLiteral().orNull());
    }

    default public Optional<OWLAnonymousIndividual> anonymousIndividualValue() {
        return Optional.ofNullable(this.annotationValue().asAnonymousIndividual().orNull());
    }

    public OWLAnnotationValue annotationValue();

    default public <T extends OWLAnnotationValue> void when(Class<T> witness, Predicate<T> p, Consumer<T> c, Runnable r) {
        OWLAnnotationValue t = this.annotationValue();
        if (witness.isInstance(t)) {
            OWLAnnotationValue av = (OWLAnnotationValue)witness.cast(t);
            if (p.test(av)) {
                c.accept(av);
            } else {
                r.run();
            }
        } else {
            r.run();
        }
    }

    default public <T extends OWLAnnotationValue, O> O map(Class<T> witness, Predicate<T> p, Function<T, O> f, Supplier<O> s) {
        OWLAnnotationValue t = this.annotationValue();
        if (witness.isInstance(t)) {
            OWLAnnotationValue av = (OWLAnnotationValue)witness.cast(t);
            if (p.test(av)) {
                return f.apply(av);
            }
            return s.get();
        }
        return s.get();
    }

    default public <T extends OWLAnnotationValue, O> O map(Class<T> witness, Predicate<T> p, Function<T, O> f, O defaultValue) {
        OWLAnnotationValue t = this.annotationValue();
        if (witness.isInstance(t)) {
            OWLAnnotationValue av = (OWLAnnotationValue)witness.cast(t);
            if (p.test(av)) {
                return f.apply(av);
            }
            return defaultValue;
        }
        return defaultValue;
    }

    default public void ifLiteral(Consumer<OWLLiteral> literalConsumer) {
        OWLAnnotationValue value = this.annotationValue();
        if (value.isLiteral()) {
            literalConsumer.accept((OWLLiteral)value);
        }
    }

    default public void ifLiteralOrElse(Consumer<OWLLiteral> literalConsumer, Runnable elseAction) {
        OWLAnnotationValue value = this.annotationValue();
        if (value.isLiteral()) {
            literalConsumer.accept((OWLLiteral)value);
        } else {
            elseAction.run();
        }
    }

    default public void ifIri(Consumer<IRI> iriConsumer) {
        OWLAnnotationValue value = this.annotationValue();
        if (value.isIRI()) {
            iriConsumer.accept((IRI)value);
        }
    }

    default public void ifIriOrElse(Consumer<IRI> iriConsumer, Runnable elseAction) {
        OWLAnnotationValue value = this.annotationValue();
        if (value.isIRI()) {
            iriConsumer.accept((IRI)value);
        } else {
            elseAction.run();
        }
    }

    default public void ifAnonymousIndividual(Consumer<OWLAnonymousIndividual> anonConsumer) {
        OWLAnnotationValue value = this.annotationValue();
        if (value.isIndividual()) {
            anonConsumer.accept((OWLAnonymousIndividual)value);
        }
    }

    default public void ifAnonymousIndividualOrElse(Consumer<OWLAnonymousIndividual> anonConsumer, Runnable elseAction) {
        OWLAnnotationValue value = this.annotationValue();
        if (value.isIndividual()) {
            anonConsumer.accept((OWLAnonymousIndividual)value);
        } else {
            elseAction.run();
        }
    }

    default public <T> Optional<T> mapLiteral(Function<OWLLiteral, T> function) {
        OWLAnnotationValue value = this.annotationValue();
        if (value.isLiteral()) {
            return Optional.ofNullable(function.apply((OWLLiteral)value));
        }
        return Optional.empty();
    }

    default public <T> T mapLiteralOrElse(Function<OWLLiteral, T> function, T defaultValue) {
        OWLAnnotationValue value = this.annotationValue();
        if (value.isLiteral()) {
            return function.apply((OWLLiteral)value);
        }
        return defaultValue;
    }

    default public <T> T mapLiteralOrElseGet(Function<OWLLiteral, T> function, Supplier<T> defaultValue) {
        OWLAnnotationValue value = this.annotationValue();
        if (value.isLiteral()) {
            return function.apply((OWLLiteral)value);
        }
        return defaultValue.get();
    }

    default public <T> Optional<T> mapIri(Function<IRI, T> function) {
        OWLAnnotationValue value = this.annotationValue();
        if (value.isIRI()) {
            return Optional.ofNullable(function.apply((IRI)value));
        }
        return Optional.empty();
    }

    default public <T> T mapIriOrElse(Function<IRI, T> function, T defaultValue) {
        OWLAnnotationValue value = this.annotationValue();
        if (value.isIRI()) {
            return function.apply((IRI)value);
        }
        return defaultValue;
    }

    default public <T> T mapIriOrElseGet(Function<IRI, T> function, Supplier<T> defaultValue) {
        OWLAnnotationValue value = this.annotationValue();
        if (value.isIRI()) {
            return function.apply((IRI)value);
        }
        return defaultValue.get();
    }

    default public <T> Optional<T> mapAnonymousIndividual(Function<OWLAnonymousIndividual, T> function) {
        OWLAnnotationValue value = this.annotationValue();
        if (value.isIRI()) {
            return Optional.ofNullable(function.apply((OWLAnonymousIndividual)value));
        }
        return Optional.empty();
    }

    default public <T> T mapAnonymousIndividualOrElse(Function<OWLAnonymousIndividual, T> function, T defaultValue) {
        OWLAnnotationValue value = this.annotationValue();
        if (value.isAnonymous()) {
            return function.apply((OWLAnonymousIndividual)value);
        }
        return defaultValue;
    }

    default public <T> T mapAnonymousIndividualOrElseGet(Function<OWLAnonymousIndividual, T> function, Supplier<T> defaultValue) {
        OWLAnnotationValue value = this.annotationValue();
        if (value.isAnonymous()) {
            return function.apply((OWLAnonymousIndividual)value);
        }
        return defaultValue.get();
    }

    default public void ifValue(Consumer<OWLLiteral> literalConsumer, Consumer<IRI> iriConsumer, Consumer<OWLAnonymousIndividual> anonConsumer) {
        OWLAnnotationValue value = this.annotationValue();
        if (value.isLiteral()) {
            this.ifLiteral(literalConsumer);
        } else if (value.isIRI()) {
            this.ifIri(iriConsumer);
        } else {
            this.ifAnonymousIndividual(anonConsumer);
        }
    }

    default public <T> Optional<T> mapValue(Function<OWLLiteral, T> literalFunction, Function<IRI, T> iriFunction, Function<OWLAnonymousIndividual, T> anonFunction) {
        OWLAnnotationValue value = this.annotationValue();
        if (value.isLiteral()) {
            return this.mapLiteral(literalFunction);
        }
        if (value.isIRI()) {
            return this.mapIri(iriFunction);
        }
        return this.mapAnonymousIndividual(anonFunction);
    }
}

