// Automatically generated file. DO NOT EDIT.
// Generated by gen-device-svd.go from nrf52840.svd, see https://github.com/NordicSemiconductor/nrfx/tree/master/mdk

//go:build nrf && nrf52840
// +build nrf,nrf52840

// nRF52840 reference description for radio MCU with ARM 32-bit Cortex-M4 Microcontroller
//
//     Copyright (c) 2010 - 2020, Nordic Semiconductor ASA All rights reserved.
//
//     Redistribution and use in source and binary forms, with or without
//     modification, are permitted provided that the following conditions are met:
//
//     1. Redistributions of source code must retain the above copyright notice, this
//     list of conditions and the following disclaimer.
//
//     2. Redistributions in binary form must reproduce the above copyright
//     notice, this list of conditions and the following disclaimer in the
//     documentation and/or other materials provided with the distribution.
//
//     3. Neither the name of Nordic Semiconductor ASA nor the names of its
//     contributors may be used to endorse or promote products derived from this
//     software without specific prior written permission.
//
//     THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
//     AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
//     IMPLIED WARRANTIES OF MERCHANTABILITY, AND FITNESS FOR A PARTICULAR PURPOSE
//     ARE DISCLAIMED. IN NO EVENT SHALL NORDIC SEMICONDUCTOR ASA OR CONTRIBUTORS BE
//     LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
//     CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
//     SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
//     INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
//     CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
//     ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
//     POSSIBILITY OF SUCH DAMAGE.
package nrf

import (
	"runtime/volatile"
	"unsafe"
)

// Some information about this device.
const (
	Device       = "nrf52840"
	CPU          = "CM4"
	FPUPresent   = true
	NVICPrioBits = 3
)

// Interrupt numbers.
const (
	// Clock control // Power control
	IRQ_POWER_CLOCK = 0

	// Clock control
	IRQ_CLOCK = 0

	// Power control
	IRQ_POWER = 0

	// 2.4 GHz radio
	IRQ_RADIO = 1

	// Universal Asynchronous Receiver/Transmitter // UART with EasyDMA 0
	IRQ_UARTE0_UART0 = 2

	// Universal Asynchronous Receiver/Transmitter
	IRQ_UART0 = 2

	// UART with EasyDMA 0
	IRQ_UARTE0 = 2

	// Serial Peripheral Interface 0 // Serial Peripheral Interface Master with EasyDMA 0 // SPI Slave 0 // I2C compatible Two-Wire Interface 0 // I2C compatible Two-Wire Master Interface with EasyDMA 0 // I2C compatible Two-Wire Slave Interface with EasyDMA 0
	IRQ_SPIM0_SPIS0_TWIM0_TWIS0_SPI0_TWI0 = 3

	// Serial Peripheral Interface 0
	IRQ_SPI0 = 3

	// Serial Peripheral Interface Master with EasyDMA 0
	IRQ_SPIM0 = 3

	// SPI Slave 0
	IRQ_SPIS0 = 3

	// I2C compatible Two-Wire Interface 0
	IRQ_TWI0 = 3

	// I2C compatible Two-Wire Master Interface with EasyDMA 0
	IRQ_TWIM0 = 3

	// I2C compatible Two-Wire Slave Interface with EasyDMA 0
	IRQ_TWIS0 = 3

	// Serial Peripheral Interface 1 // Serial Peripheral Interface Master with EasyDMA 1 // SPI Slave 1 // I2C compatible Two-Wire Interface 1 // I2C compatible Two-Wire Master Interface with EasyDMA 1 // I2C compatible Two-Wire Slave Interface with EasyDMA 1
	IRQ_SPIM1_SPIS1_TWIM1_TWIS1_SPI1_TWI1 = 4

	// Serial Peripheral Interface 1
	IRQ_SPI1 = 4

	// Serial Peripheral Interface Master with EasyDMA 1
	IRQ_SPIM1 = 4

	// SPI Slave 1
	IRQ_SPIS1 = 4

	// I2C compatible Two-Wire Interface 1
	IRQ_TWI1 = 4

	// I2C compatible Two-Wire Master Interface with EasyDMA 1
	IRQ_TWIM1 = 4

	// I2C compatible Two-Wire Slave Interface with EasyDMA 1
	IRQ_TWIS1 = 4

	// NFC-A compatible radio
	IRQ_NFCT = 5

	// GPIO Tasks and Events
	IRQ_GPIOTE = 6

	// Successive approximation register (SAR) analog-to-digital converter
	IRQ_SAADC = 7

	// Timer/Counter 0
	IRQ_TIMER0 = 8

	// Timer/Counter 1
	IRQ_TIMER1 = 9

	// Timer/Counter 2
	IRQ_TIMER2 = 10

	// Real time counter 0
	IRQ_RTC0 = 11

	// Temperature Sensor
	IRQ_TEMP = 12

	// Random Number Generator
	IRQ_RNG = 13

	// AES ECB Mode Encryption
	IRQ_ECB = 14

	// Accelerated Address Resolver // AES CCM Mode Encryption
	IRQ_CCM_AAR = 15

	// Accelerated Address Resolver
	IRQ_AAR = 15

	// AES CCM Mode Encryption
	IRQ_CCM = 15

	// Watchdog Timer
	IRQ_WDT = 16

	// Real time counter 1
	IRQ_RTC1 = 17

	// Quadrature Decoder
	IRQ_QDEC = 18

	// Comparator // Low Power Comparator
	IRQ_COMP_LPCOMP = 19

	// Comparator
	IRQ_COMP = 19

	// Low Power Comparator
	IRQ_LPCOMP = 19

	// Event Generator Unit 0 // Software interrupt 0
	IRQ_SWI0_EGU0 = 20

	// Event Generator Unit 0
	IRQ_EGU0 = 20

	// Software interrupt 0
	IRQ_SWI0 = 20

	// Event Generator Unit 1 // Software interrupt 1
	IRQ_SWI1_EGU1 = 21

	// Event Generator Unit 1
	IRQ_EGU1 = 21

	// Software interrupt 1
	IRQ_SWI1 = 21

	// Event Generator Unit 2 // Software interrupt 2
	IRQ_SWI2_EGU2 = 22

	// Event Generator Unit 2
	IRQ_EGU2 = 22

	// Software interrupt 2
	IRQ_SWI2 = 22

	// Event Generator Unit 3 // Software interrupt 3
	IRQ_SWI3_EGU3 = 23

	// Event Generator Unit 3
	IRQ_EGU3 = 23

	// Software interrupt 3
	IRQ_SWI3 = 23

	// Event Generator Unit 4 // Software interrupt 4
	IRQ_SWI4_EGU4 = 24

	// Event Generator Unit 4
	IRQ_EGU4 = 24

	// Software interrupt 4
	IRQ_SWI4 = 24

	// Event Generator Unit 5 // Software interrupt 5
	IRQ_SWI5_EGU5 = 25

	// Event Generator Unit 5
	IRQ_EGU5 = 25

	// Software interrupt 5
	IRQ_SWI5 = 25

	// Timer/Counter 3
	IRQ_TIMER3 = 26

	// Timer/Counter 4
	IRQ_TIMER4 = 27

	// Pulse width modulation unit 0
	IRQ_PWM0 = 28

	// Pulse Density Modulation (Digital Microphone) Interface
	IRQ_PDM = 29

	// Memory Watch Unit
	IRQ_MWU = 32

	// Pulse width modulation unit 1
	IRQ_PWM1 = 33

	// Pulse width modulation unit 2
	IRQ_PWM2 = 34

	// Serial Peripheral Interface 2 // Serial Peripheral Interface Master with EasyDMA 2 // SPI Slave 2
	IRQ_SPIM2_SPIS2_SPI2 = 35

	// Serial Peripheral Interface 2
	IRQ_SPI2 = 35

	// Serial Peripheral Interface Master with EasyDMA 2
	IRQ_SPIM2 = 35

	// SPI Slave 2
	IRQ_SPIS2 = 35

	// Real time counter 2
	IRQ_RTC2 = 36

	// Inter-IC Sound
	IRQ_I2S = 37

	// FPU
	IRQ_FPU = 38

	// Universal serial bus device
	IRQ_USBD = 39

	// UART with EasyDMA 1
	IRQ_UARTE1 = 40

	// External flash interface
	IRQ_QSPI = 41

	// ARM TrustZone CryptoCell register interface
	IRQ_CRYPTOCELL = 42

	// Pulse width modulation unit 3
	IRQ_PWM3 = 45

	// Serial Peripheral Interface Master with EasyDMA 3
	IRQ_SPIM3 = 47

	// Highest interrupt number on this device.
	IRQ_max = 47
)

// Pseudo function call that is replaced by the compiler with the actual
// functions registered through interrupt.New.
//go:linkname callHandlers runtime/interrupt.callHandlers
func callHandlers(num int)

//export POWER_CLOCK_IRQHandler
func interruptPOWER_CLOCK() {
	callHandlers(IRQ_POWER_CLOCK)
}

//export RADIO_IRQHandler
func interruptRADIO() {
	callHandlers(IRQ_RADIO)
}

//export UARTE0_UART0_IRQHandler
func interruptUARTE0_UART0() {
	callHandlers(IRQ_UARTE0_UART0)
}

//export SPIM0_SPIS0_TWIM0_TWIS0_SPI0_TWI0_IRQHandler
func interruptSPIM0_SPIS0_TWIM0_TWIS0_SPI0_TWI0() {
	callHandlers(IRQ_SPIM0_SPIS0_TWIM0_TWIS0_SPI0_TWI0)
}

//export SPIM1_SPIS1_TWIM1_TWIS1_SPI1_TWI1_IRQHandler
func interruptSPIM1_SPIS1_TWIM1_TWIS1_SPI1_TWI1() {
	callHandlers(IRQ_SPIM1_SPIS1_TWIM1_TWIS1_SPI1_TWI1)
}

//export NFCT_IRQHandler
func interruptNFCT() {
	callHandlers(IRQ_NFCT)
}

//export GPIOTE_IRQHandler
func interruptGPIOTE() {
	callHandlers(IRQ_GPIOTE)
}

//export SAADC_IRQHandler
func interruptSAADC() {
	callHandlers(IRQ_SAADC)
}

//export TIMER0_IRQHandler
func interruptTIMER0() {
	callHandlers(IRQ_TIMER0)
}

//export TIMER1_IRQHandler
func interruptTIMER1() {
	callHandlers(IRQ_TIMER1)
}

//export TIMER2_IRQHandler
func interruptTIMER2() {
	callHandlers(IRQ_TIMER2)
}

//export RTC0_IRQHandler
func interruptRTC0() {
	callHandlers(IRQ_RTC0)
}

//export TEMP_IRQHandler
func interruptTEMP() {
	callHandlers(IRQ_TEMP)
}

//export RNG_IRQHandler
func interruptRNG() {
	callHandlers(IRQ_RNG)
}

//export ECB_IRQHandler
func interruptECB() {
	callHandlers(IRQ_ECB)
}

//export CCM_AAR_IRQHandler
func interruptCCM_AAR() {
	callHandlers(IRQ_CCM_AAR)
}

//export WDT_IRQHandler
func interruptWDT() {
	callHandlers(IRQ_WDT)
}

//export RTC1_IRQHandler
func interruptRTC1() {
	callHandlers(IRQ_RTC1)
}

//export QDEC_IRQHandler
func interruptQDEC() {
	callHandlers(IRQ_QDEC)
}

//export COMP_LPCOMP_IRQHandler
func interruptCOMP_LPCOMP() {
	callHandlers(IRQ_COMP_LPCOMP)
}

//export SWI0_EGU0_IRQHandler
func interruptSWI0_EGU0() {
	callHandlers(IRQ_SWI0_EGU0)
}

//export SWI1_EGU1_IRQHandler
func interruptSWI1_EGU1() {
	callHandlers(IRQ_SWI1_EGU1)
}

//export SWI2_EGU2_IRQHandler
func interruptSWI2_EGU2() {
	callHandlers(IRQ_SWI2_EGU2)
}

//export SWI3_EGU3_IRQHandler
func interruptSWI3_EGU3() {
	callHandlers(IRQ_SWI3_EGU3)
}

//export SWI4_EGU4_IRQHandler
func interruptSWI4_EGU4() {
	callHandlers(IRQ_SWI4_EGU4)
}

//export SWI5_EGU5_IRQHandler
func interruptSWI5_EGU5() {
	callHandlers(IRQ_SWI5_EGU5)
}

//export TIMER3_IRQHandler
func interruptTIMER3() {
	callHandlers(IRQ_TIMER3)
}

//export TIMER4_IRQHandler
func interruptTIMER4() {
	callHandlers(IRQ_TIMER4)
}

//export PWM0_IRQHandler
func interruptPWM0() {
	callHandlers(IRQ_PWM0)
}

//export PDM_IRQHandler
func interruptPDM() {
	callHandlers(IRQ_PDM)
}

//export MWU_IRQHandler
func interruptMWU() {
	callHandlers(IRQ_MWU)
}

//export PWM1_IRQHandler
func interruptPWM1() {
	callHandlers(IRQ_PWM1)
}

//export PWM2_IRQHandler
func interruptPWM2() {
	callHandlers(IRQ_PWM2)
}

//export SPIM2_SPIS2_SPI2_IRQHandler
func interruptSPIM2_SPIS2_SPI2() {
	callHandlers(IRQ_SPIM2_SPIS2_SPI2)
}

//export RTC2_IRQHandler
func interruptRTC2() {
	callHandlers(IRQ_RTC2)
}

//export I2S_IRQHandler
func interruptI2S() {
	callHandlers(IRQ_I2S)
}

//export FPU_IRQHandler
func interruptFPU() {
	callHandlers(IRQ_FPU)
}

//export USBD_IRQHandler
func interruptUSBD() {
	callHandlers(IRQ_USBD)
}

//export UARTE1_IRQHandler
func interruptUARTE1() {
	callHandlers(IRQ_UARTE1)
}

//export QSPI_IRQHandler
func interruptQSPI() {
	callHandlers(IRQ_QSPI)
}

//export CRYPTOCELL_IRQHandler
func interruptCRYPTOCELL() {
	callHandlers(IRQ_CRYPTOCELL)
}

//export PWM3_IRQHandler
func interruptPWM3() {
	callHandlers(IRQ_PWM3)
}

//export SPIM3_IRQHandler
func interruptSPIM3() {
	callHandlers(IRQ_SPIM3)
}

// Peripherals.
var (
	// Factory information configuration registers
	FICR = (*FICR_Type)(unsafe.Pointer(uintptr(0x10000000)))

	// User information configuration registers
	UICR = (*UICR_Type)(unsafe.Pointer(uintptr(0x10001000)))

	// Clock control
	CLOCK = (*CLOCK_Type)(unsafe.Pointer(uintptr(0x40000000)))

	// Power control
	POWER = (*POWER_Type)(unsafe.Pointer(uintptr(0x40000000)))

	// GPIO Port 1
	P0 = (*GPIO_Type)(unsafe.Pointer(uintptr(0x50000000)))

	// 2.4 GHz radio
	RADIO = (*RADIO_Type)(unsafe.Pointer(uintptr(0x40001000)))

	// Universal Asynchronous Receiver/Transmitter
	UART0 = (*UART_Type)(unsafe.Pointer(uintptr(0x40002000)))

	// UART with EasyDMA 0
	UARTE0 = (*UARTE_Type)(unsafe.Pointer(uintptr(0x40002000)))

	// Serial Peripheral Interface 0
	SPI0 = (*SPI_Type)(unsafe.Pointer(uintptr(0x40003000)))

	// Serial Peripheral Interface Master with EasyDMA 0
	SPIM0 = (*SPIM_Type)(unsafe.Pointer(uintptr(0x40003000)))

	// SPI Slave 0
	SPIS0 = (*SPIS_Type)(unsafe.Pointer(uintptr(0x40003000)))

	// I2C compatible Two-Wire Interface 0
	TWI0 = (*TWI_Type)(unsafe.Pointer(uintptr(0x40003000)))

	// I2C compatible Two-Wire Master Interface with EasyDMA 0
	TWIM0 = (*TWIM_Type)(unsafe.Pointer(uintptr(0x40003000)))

	// I2C compatible Two-Wire Slave Interface with EasyDMA 0
	TWIS0 = (*TWIS_Type)(unsafe.Pointer(uintptr(0x40003000)))

	// NFC-A compatible radio
	NFCT = (*NFCT_Type)(unsafe.Pointer(uintptr(0x40005000)))

	// GPIO Tasks and Events
	GPIOTE = (*GPIOTE_Type)(unsafe.Pointer(uintptr(0x40006000)))

	// Successive approximation register (SAR) analog-to-digital converter
	SAADC = (*SAADC_Type)(unsafe.Pointer(uintptr(0x40007000)))

	// Timer/Counter 0
	TIMER0 = (*TIMER_Type)(unsafe.Pointer(uintptr(0x40008000)))

	// Real time counter 0
	RTC0 = (*RTC_Type)(unsafe.Pointer(uintptr(0x4000b000)))

	// Temperature Sensor
	TEMP = (*TEMP_Type)(unsafe.Pointer(uintptr(0x4000c000)))

	// Random Number Generator
	RNG = (*RNG_Type)(unsafe.Pointer(uintptr(0x4000d000)))

	// AES ECB Mode Encryption
	ECB = (*ECB_Type)(unsafe.Pointer(uintptr(0x4000e000)))

	// Accelerated Address Resolver
	AAR = (*AAR_Type)(unsafe.Pointer(uintptr(0x4000f000)))

	// AES CCM Mode Encryption
	CCM = (*CCM_Type)(unsafe.Pointer(uintptr(0x4000f000)))

	// Watchdog Timer
	WDT = (*WDT_Type)(unsafe.Pointer(uintptr(0x40010000)))

	// Quadrature Decoder
	QDEC = (*QDEC_Type)(unsafe.Pointer(uintptr(0x40012000)))

	// Comparator
	COMP = (*COMP_Type)(unsafe.Pointer(uintptr(0x40013000)))

	// Low Power Comparator
	LPCOMP = (*LPCOMP_Type)(unsafe.Pointer(uintptr(0x40013000)))

	// Event Generator Unit 0
	EGU0 = (*EGU_Type)(unsafe.Pointer(uintptr(0x40014000)))

	// Software interrupt 0
	SWI0 = (*SWI_Type)(unsafe.Pointer(uintptr(0x40014000)))

	// Pulse width modulation unit 0
	PWM0 = (*PWM_Type)(unsafe.Pointer(uintptr(0x4001c000)))

	// Pulse Density Modulation (Digital Microphone) Interface
	PDM = (*PDM_Type)(unsafe.Pointer(uintptr(0x4001d000)))

	// Access control lists
	ACL = (*ACL_Type)(unsafe.Pointer(uintptr(0x4001e000)))

	// Non Volatile Memory Controller
	NVMC = (*NVMC_Type)(unsafe.Pointer(uintptr(0x4001e000)))

	// Programmable Peripheral Interconnect
	PPI = (*PPI_Type)(unsafe.Pointer(uintptr(0x4001f000)))

	// Memory Watch Unit
	MWU = (*MWU_Type)(unsafe.Pointer(uintptr(0x40020000)))

	// Inter-IC Sound
	I2S = (*I2S_Type)(unsafe.Pointer(uintptr(0x40025000)))

	// FPU
	FPU = (*FPU_Type)(unsafe.Pointer(uintptr(0x40026000)))

	// Universal serial bus device
	USBD = (*USBD_Type)(unsafe.Pointer(uintptr(0x40027000)))

	// External flash interface
	QSPI = (*QSPI_Type)(unsafe.Pointer(uintptr(0x40029000)))

	// CRYPTOCELL HOST_RGF interface
	CC_HOST_RGF = (*CC_HOST_RGF_Type)(unsafe.Pointer(uintptr(0x5002a000)))

	// ARM TrustZone CryptoCell register interface
	CRYPTOCELL = (*CRYPTOCELL_Type)(unsafe.Pointer(uintptr(0x5002a000)))

	// GPIO Port 2
	P1 = (*GPIO_Type)(unsafe.Pointer(uintptr(0x50000300)))

	// Serial Peripheral Interface 1
	SPI1 = (*SPI_Type)(unsafe.Pointer(uintptr(0x40004000)))

	// Serial Peripheral Interface Master with EasyDMA 1
	SPIM1 = (*SPIM_Type)(unsafe.Pointer(uintptr(0x40004000)))

	// SPI Slave 1
	SPIS1 = (*SPIS_Type)(unsafe.Pointer(uintptr(0x40004000)))

	// I2C compatible Two-Wire Interface 1
	TWI1 = (*TWI_Type)(unsafe.Pointer(uintptr(0x40004000)))

	// I2C compatible Two-Wire Master Interface with EasyDMA 1
	TWIM1 = (*TWIM_Type)(unsafe.Pointer(uintptr(0x40004000)))

	// I2C compatible Two-Wire Slave Interface with EasyDMA 1
	TWIS1 = (*TWIS_Type)(unsafe.Pointer(uintptr(0x40004000)))

	// Timer/Counter 1
	TIMER1 = (*TIMER_Type)(unsafe.Pointer(uintptr(0x40009000)))

	// Timer/Counter 2
	TIMER2 = (*TIMER_Type)(unsafe.Pointer(uintptr(0x4000a000)))

	// Real time counter 1
	RTC1 = (*RTC_Type)(unsafe.Pointer(uintptr(0x40011000)))

	// Event Generator Unit 1
	EGU1 = (*EGU_Type)(unsafe.Pointer(uintptr(0x40015000)))

	// Software interrupt 1
	SWI1 = (*SWI_Type)(unsafe.Pointer(uintptr(0x40015000)))

	// Event Generator Unit 2
	EGU2 = (*EGU_Type)(unsafe.Pointer(uintptr(0x40016000)))

	// Software interrupt 2
	SWI2 = (*SWI_Type)(unsafe.Pointer(uintptr(0x40016000)))

	// Event Generator Unit 3
	EGU3 = (*EGU_Type)(unsafe.Pointer(uintptr(0x40017000)))

	// Software interrupt 3
	SWI3 = (*SWI_Type)(unsafe.Pointer(uintptr(0x40017000)))

	// Event Generator Unit 4
	EGU4 = (*EGU_Type)(unsafe.Pointer(uintptr(0x40018000)))

	// Software interrupt 4
	SWI4 = (*SWI_Type)(unsafe.Pointer(uintptr(0x40018000)))

	// Event Generator Unit 5
	EGU5 = (*EGU_Type)(unsafe.Pointer(uintptr(0x40019000)))

	// Software interrupt 5
	SWI5 = (*SWI_Type)(unsafe.Pointer(uintptr(0x40019000)))

	// Timer/Counter 3
	TIMER3 = (*TIMER_Type)(unsafe.Pointer(uintptr(0x4001a000)))

	// Timer/Counter 4
	TIMER4 = (*TIMER_Type)(unsafe.Pointer(uintptr(0x4001b000)))

	// Pulse width modulation unit 1
	PWM1 = (*PWM_Type)(unsafe.Pointer(uintptr(0x40021000)))

	// Pulse width modulation unit 2
	PWM2 = (*PWM_Type)(unsafe.Pointer(uintptr(0x40022000)))

	// Serial Peripheral Interface 2
	SPI2 = (*SPI_Type)(unsafe.Pointer(uintptr(0x40023000)))

	// Serial Peripheral Interface Master with EasyDMA 2
	SPIM2 = (*SPIM_Type)(unsafe.Pointer(uintptr(0x40023000)))

	// SPI Slave 2
	SPIS2 = (*SPIS_Type)(unsafe.Pointer(uintptr(0x40023000)))

	// Real time counter 2
	RTC2 = (*RTC_Type)(unsafe.Pointer(uintptr(0x40024000)))

	// UART with EasyDMA 1
	UARTE1 = (*UARTE_Type)(unsafe.Pointer(uintptr(0x40028000)))

	// Pulse width modulation unit 3
	PWM3 = (*PWM_Type)(unsafe.Pointer(uintptr(0x4002d000)))

	// Serial Peripheral Interface Master with EasyDMA 3
	SPIM3 = (*SPIM_Type)(unsafe.Pointer(uintptr(0x4002f000)))
)

// Factory information configuration registers
type FICR_Type struct {
	_              [16]byte
	CODEPAGESIZE   volatile.Register32 // 0x10
	CODESIZE       volatile.Register32 // 0x14
	_              [72]byte
	DEVICEID       [2]volatile.Register32 // 0x60
	_              [24]byte
	ER             [4]volatile.Register32 // 0x80
	IR             [4]volatile.Register32 // 0x90
	DEVICEADDRTYPE volatile.Register32    // 0xA0
	DEVICEADDR     [2]volatile.Register32 // 0xA4
	_              [84]byte
	INFO           struct {
		PART    volatile.Register32
		VARIANT volatile.Register32
		PACKAGE volatile.Register32
		RAM     volatile.Register32
		FLASH   volatile.Register32
	} // 0x100
	_        [572]byte
	PRODTEST [3]volatile.Register32 // 0x350
	_        [168]byte
	TEMP     struct {
		A0 volatile.Register32
		A1 volatile.Register32
		A2 volatile.Register32
		A3 volatile.Register32
		A4 volatile.Register32
		A5 volatile.Register32
		B0 volatile.Register32
		B1 volatile.Register32
		B2 volatile.Register32
		B3 volatile.Register32
		B4 volatile.Register32
		B5 volatile.Register32
		T0 volatile.Register32
		T1 volatile.Register32
		T2 volatile.Register32
		T3 volatile.Register32
		T4 volatile.Register32
	} // 0x404
	_   [8]byte
	NFC struct {
		TAGHEADER0 volatile.Register32
		TAGHEADER1 volatile.Register32
		TAGHEADER2 volatile.Register32
		TAGHEADER3 volatile.Register32
	} // 0x450
	_       [1952]byte
	TRNG90B struct {
		BYTES    volatile.Register32
		RCCUTOFF volatile.Register32
		APCUTOFF volatile.Register32
		STARTUP  volatile.Register32
		ROSC1    volatile.Register32
		ROSC2    volatile.Register32
		ROSC3    volatile.Register32
		ROSC4    volatile.Register32
	} // 0xC00
}

// User information configuration registers
type UICR_Type struct {
	_         [20]byte
	NRFFW     [13]volatile.Register32 // 0x14
	_         [8]byte
	NRFHW     [12]volatile.Register32 // 0x50
	CUSTOMER  [32]volatile.Register32 // 0x80
	_         [256]byte
	PSELRESET [2]volatile.Register32 // 0x200
	APPROTECT volatile.Register32    // 0x208
	NFCPINS   volatile.Register32    // 0x20C
	DEBUGCTRL volatile.Register32    // 0x210
	_         [240]byte
	REGOUT0   volatile.Register32 // 0x304
}

// Clock control
type CLOCK_Type struct {
	TASKS_HFCLKSTART    volatile.Register32 // 0x0
	TASKS_HFCLKSTOP     volatile.Register32 // 0x4
	TASKS_LFCLKSTART    volatile.Register32 // 0x8
	TASKS_LFCLKSTOP     volatile.Register32 // 0xC
	TASKS_CAL           volatile.Register32 // 0x10
	TASKS_CTSTART       volatile.Register32 // 0x14
	TASKS_CTSTOP        volatile.Register32 // 0x18
	_                   [228]byte
	EVENTS_HFCLKSTARTED volatile.Register32 // 0x100
	EVENTS_LFCLKSTARTED volatile.Register32 // 0x104
	_                   [4]byte
	EVENTS_DONE         volatile.Register32 // 0x10C
	EVENTS_CTTO         volatile.Register32 // 0x110
	_                   [20]byte
	EVENTS_CTSTARTED    volatile.Register32 // 0x128
	EVENTS_CTSTOPPED    volatile.Register32 // 0x12C
	_                   [468]byte
	INTENSET            volatile.Register32 // 0x304
	INTENCLR            volatile.Register32 // 0x308
	_                   [252]byte
	HFCLKRUN            volatile.Register32 // 0x408
	HFCLKSTAT           volatile.Register32 // 0x40C
	_                   [4]byte
	LFCLKRUN            volatile.Register32 // 0x414
	LFCLKSTAT           volatile.Register32 // 0x418
	LFCLKSRCCOPY        volatile.Register32 // 0x41C
	_                   [248]byte
	LFCLKSRC            volatile.Register32 // 0x518
	_                   [12]byte
	HFXODEBOUNCE        volatile.Register32 // 0x528
	_                   [12]byte
	CTIV                volatile.Register32 // 0x538
	_                   [32]byte
	TRACECONFIG         volatile.Register32 // 0x55C
	_                   [84]byte
	LFRCMODE            volatile.Register32 // 0x5B4
}

// Power control
type POWER_Type struct {
	_                  [120]byte
	TASKS_CONSTLAT     volatile.Register32 // 0x78
	TASKS_LOWPWR       volatile.Register32 // 0x7C
	_                  [136]byte
	EVENTS_POFWARN     volatile.Register32 // 0x108
	_                  [8]byte
	EVENTS_SLEEPENTER  volatile.Register32 // 0x114
	EVENTS_SLEEPEXIT   volatile.Register32 // 0x118
	EVENTS_USBDETECTED volatile.Register32 // 0x11C
	EVENTS_USBREMOVED  volatile.Register32 // 0x120
	EVENTS_USBPWRRDY   volatile.Register32 // 0x124
	_                  [476]byte
	INTENSET           volatile.Register32 // 0x304
	INTENCLR           volatile.Register32 // 0x308
	_                  [244]byte
	RESETREAS          volatile.Register32 // 0x400
	_                  [36]byte
	RAMSTATUS          volatile.Register32 // 0x428
	_                  [12]byte
	USBREGSTATUS       volatile.Register32 // 0x438
	_                  [196]byte
	SYSTEMOFF          volatile.Register32 // 0x500
	_                  [12]byte
	POFCON             volatile.Register32 // 0x510
	_                  [8]byte
	GPREGRET           volatile.Register32 // 0x51C
	GPREGRET2          volatile.Register32 // 0x520
	_                  [84]byte
	DCDCEN             volatile.Register32 // 0x578
	_                  [4]byte
	DCDCEN0            volatile.Register32 // 0x580
	_                  [188]byte
	MAINREGSTATUS      volatile.Register32 // 0x640
	_                  [700]byte
	RAM                [9]struct {
		POWER    volatile.Register32
		POWERSET volatile.Register32
		POWERCLR volatile.Register32
		_        [4]byte
	} // 0x900
}

// GPIO Port 1
type GPIO_Type struct {
	_          [1284]byte
	OUT        volatile.Register32 // 0x504
	OUTSET     volatile.Register32 // 0x508
	OUTCLR     volatile.Register32 // 0x50C
	IN         volatile.Register32 // 0x510
	DIR        volatile.Register32 // 0x514
	DIRSET     volatile.Register32 // 0x518
	DIRCLR     volatile.Register32 // 0x51C
	LATCH      volatile.Register32 // 0x520
	DETECTMODE volatile.Register32 // 0x524
	_          [472]byte
	PIN_CNF    [32]volatile.Register32 // 0x700
}

// 2.4 GHz radio
type RADIO_Type struct {
	TASKS_TXEN        volatile.Register32 // 0x0
	TASKS_RXEN        volatile.Register32 // 0x4
	TASKS_START       volatile.Register32 // 0x8
	TASKS_STOP        volatile.Register32 // 0xC
	TASKS_DISABLE     volatile.Register32 // 0x10
	TASKS_RSSISTART   volatile.Register32 // 0x14
	TASKS_RSSISTOP    volatile.Register32 // 0x18
	TASKS_BCSTART     volatile.Register32 // 0x1C
	TASKS_BCSTOP      volatile.Register32 // 0x20
	TASKS_EDSTART     volatile.Register32 // 0x24
	TASKS_EDSTOP      volatile.Register32 // 0x28
	TASKS_CCASTART    volatile.Register32 // 0x2C
	TASKS_CCASTOP     volatile.Register32 // 0x30
	_                 [204]byte
	EVENTS_READY      volatile.Register32 // 0x100
	EVENTS_ADDRESS    volatile.Register32 // 0x104
	EVENTS_PAYLOAD    volatile.Register32 // 0x108
	EVENTS_END        volatile.Register32 // 0x10C
	EVENTS_DISABLED   volatile.Register32 // 0x110
	EVENTS_DEVMATCH   volatile.Register32 // 0x114
	EVENTS_DEVMISS    volatile.Register32 // 0x118
	EVENTS_RSSIEND    volatile.Register32 // 0x11C
	_                 [8]byte
	EVENTS_BCMATCH    volatile.Register32 // 0x128
	_                 [4]byte
	EVENTS_CRCOK      volatile.Register32 // 0x130
	EVENTS_CRCERROR   volatile.Register32 // 0x134
	EVENTS_FRAMESTART volatile.Register32 // 0x138
	EVENTS_EDEND      volatile.Register32 // 0x13C
	EVENTS_EDSTOPPED  volatile.Register32 // 0x140
	EVENTS_CCAIDLE    volatile.Register32 // 0x144
	EVENTS_CCABUSY    volatile.Register32 // 0x148
	EVENTS_CCASTOPPED volatile.Register32 // 0x14C
	EVENTS_RATEBOOST  volatile.Register32 // 0x150
	EVENTS_TXREADY    volatile.Register32 // 0x154
	EVENTS_RXREADY    volatile.Register32 // 0x158
	EVENTS_MHRMATCH   volatile.Register32 // 0x15C
	_                 [8]byte
	EVENTS_SYNC       volatile.Register32 // 0x168
	EVENTS_PHYEND     volatile.Register32 // 0x16C
	_                 [144]byte
	SHORTS            volatile.Register32 // 0x200
	_                 [256]byte
	INTENSET          volatile.Register32 // 0x304
	INTENCLR          volatile.Register32 // 0x308
	_                 [244]byte
	CRCSTATUS         volatile.Register32 // 0x400
	_                 [4]byte
	RXMATCH           volatile.Register32 // 0x408
	RXCRC             volatile.Register32 // 0x40C
	DAI               volatile.Register32 // 0x410
	PDUSTAT           volatile.Register32 // 0x414
	_                 [236]byte
	PACKETPTR         volatile.Register32 // 0x504
	FREQUENCY         volatile.Register32 // 0x508
	TXPOWER           volatile.Register32 // 0x50C
	MODE              volatile.Register32 // 0x510
	PCNF0             volatile.Register32 // 0x514
	PCNF1             volatile.Register32 // 0x518
	BASE0             volatile.Register32 // 0x51C
	BASE1             volatile.Register32 // 0x520
	PREFIX0           volatile.Register32 // 0x524
	PREFIX1           volatile.Register32 // 0x528
	TXADDRESS         volatile.Register32 // 0x52C
	RXADDRESSES       volatile.Register32 // 0x530
	CRCCNF            volatile.Register32 // 0x534
	CRCPOLY           volatile.Register32 // 0x538
	CRCINIT           volatile.Register32 // 0x53C
	_                 [4]byte
	TIFS              volatile.Register32 // 0x544
	RSSISAMPLE        volatile.Register32 // 0x548
	_                 [4]byte
	STATE             volatile.Register32 // 0x550
	DATAWHITEIV       volatile.Register32 // 0x554
	_                 [8]byte
	BCC               volatile.Register32 // 0x560
	_                 [156]byte
	DAB               [8]volatile.Register32 // 0x600
	DAP               [8]volatile.Register32 // 0x620
	DACNF             volatile.Register32    // 0x640
	MHRMATCHCONF      volatile.Register32    // 0x644
	MHRMATCHMAS       volatile.Register32    // 0x648
	_                 [4]byte
	MODECNF0          volatile.Register32 // 0x650
	_                 [12]byte
	SFD               volatile.Register32 // 0x660
	EDCNT             volatile.Register32 // 0x664
	EDSAMPLE          volatile.Register32 // 0x668
	CCACTRL           volatile.Register32 // 0x66C
	_                 [2444]byte
	POWER             volatile.Register32 // 0xFFC
}

// Universal Asynchronous Receiver/Transmitter
type UART_Type struct {
	TASKS_STARTRX volatile.Register32 // 0x0
	TASKS_STOPRX  volatile.Register32 // 0x4
	TASKS_STARTTX volatile.Register32 // 0x8
	TASKS_STOPTX  volatile.Register32 // 0xC
	_             [12]byte
	TASKS_SUSPEND volatile.Register32 // 0x1C
	_             [224]byte
	EVENTS_CTS    volatile.Register32 // 0x100
	EVENTS_NCTS   volatile.Register32 // 0x104
	EVENTS_RXDRDY volatile.Register32 // 0x108
	_             [16]byte
	EVENTS_TXDRDY volatile.Register32 // 0x11C
	_             [4]byte
	EVENTS_ERROR  volatile.Register32 // 0x124
	_             [28]byte
	EVENTS_RXTO   volatile.Register32 // 0x144
	_             [184]byte
	SHORTS        volatile.Register32 // 0x200
	_             [256]byte
	INTENSET      volatile.Register32 // 0x304
	INTENCLR      volatile.Register32 // 0x308
	_             [372]byte
	ERRORSRC      volatile.Register32 // 0x480
	_             [124]byte
	ENABLE        volatile.Register32 // 0x500
	_             [4]byte
	PSEL          struct {
		RTS volatile.Register32
		TXD volatile.Register32
		CTS volatile.Register32
		RXD volatile.Register32
	} // 0x508
	RXD      volatile.Register32 // 0x518
	TXD      volatile.Register32 // 0x51C
	_        [4]byte
	BAUDRATE volatile.Register32 // 0x524
	_        [68]byte
	CONFIG   volatile.Register32 // 0x56C
}

// UART with EasyDMA 0
type UARTE_Type struct {
	TASKS_STARTRX    volatile.Register32 // 0x0
	TASKS_STOPRX     volatile.Register32 // 0x4
	TASKS_STARTTX    volatile.Register32 // 0x8
	TASKS_STOPTX     volatile.Register32 // 0xC
	_                [28]byte
	TASKS_FLUSHRX    volatile.Register32 // 0x2C
	_                [208]byte
	EVENTS_CTS       volatile.Register32 // 0x100
	EVENTS_NCTS      volatile.Register32 // 0x104
	EVENTS_RXDRDY    volatile.Register32 // 0x108
	_                [4]byte
	EVENTS_ENDRX     volatile.Register32 // 0x110
	_                [8]byte
	EVENTS_TXDRDY    volatile.Register32 // 0x11C
	EVENTS_ENDTX     volatile.Register32 // 0x120
	EVENTS_ERROR     volatile.Register32 // 0x124
	_                [28]byte
	EVENTS_RXTO      volatile.Register32 // 0x144
	_                [4]byte
	EVENTS_RXSTARTED volatile.Register32 // 0x14C
	EVENTS_TXSTARTED volatile.Register32 // 0x150
	_                [4]byte
	EVENTS_TXSTOPPED volatile.Register32 // 0x158
	_                [164]byte
	SHORTS           volatile.Register32 // 0x200
	_                [252]byte
	INTEN            volatile.Register32 // 0x300
	INTENSET         volatile.Register32 // 0x304
	INTENCLR         volatile.Register32 // 0x308
	_                [372]byte
	ERRORSRC         volatile.Register32 // 0x480
	_                [124]byte
	ENABLE           volatile.Register32 // 0x500
	_                [4]byte
	PSEL             struct {
		RTS volatile.Register32
		TXD volatile.Register32
		CTS volatile.Register32
		RXD volatile.Register32
	} // 0x508
	_        [12]byte
	BAUDRATE volatile.Register32 // 0x524
	_        [12]byte
	RXD      struct {
		PTR    volatile.Register32
		MAXCNT volatile.Register32
		AMOUNT volatile.Register32
	} // 0x534
	_   [4]byte
	TXD struct {
		PTR    volatile.Register32
		MAXCNT volatile.Register32
		AMOUNT volatile.Register32
	} // 0x544
	_      [28]byte
	CONFIG volatile.Register32 // 0x56C
}

// Serial Peripheral Interface 0
type SPI_Type struct {
	_            [264]byte
	EVENTS_READY volatile.Register32 // 0x108
	_            [504]byte
	INTENSET     volatile.Register32 // 0x304
	INTENCLR     volatile.Register32 // 0x308
	_            [500]byte
	ENABLE       volatile.Register32 // 0x500
	_            [4]byte
	PSEL         struct {
		SCK  volatile.Register32
		MOSI volatile.Register32
		MISO volatile.Register32
	} // 0x508
	_         [4]byte
	RXD       volatile.Register32 // 0x518
	TXD       volatile.Register32 // 0x51C
	_         [4]byte
	FREQUENCY volatile.Register32 // 0x524
	_         [44]byte
	CONFIG    volatile.Register32 // 0x554
}

// Serial Peripheral Interface Master with EasyDMA 0
type SPIM_Type struct {
	_              [16]byte
	TASKS_START    volatile.Register32 // 0x10
	TASKS_STOP     volatile.Register32 // 0x14
	_              [4]byte
	TASKS_SUSPEND  volatile.Register32 // 0x1C
	TASKS_RESUME   volatile.Register32 // 0x20
	_              [224]byte
	EVENTS_STOPPED volatile.Register32 // 0x104
	_              [8]byte
	EVENTS_ENDRX   volatile.Register32 // 0x110
	_              [4]byte
	EVENTS_END     volatile.Register32 // 0x118
	_              [4]byte
	EVENTS_ENDTX   volatile.Register32 // 0x120
	_              [40]byte
	EVENTS_STARTED volatile.Register32 // 0x14C
	_              [176]byte
	SHORTS         volatile.Register32 // 0x200
	_              [256]byte
	INTENSET       volatile.Register32 // 0x304
	INTENCLR       volatile.Register32 // 0x308
	_              [244]byte
	STALLSTAT      volatile.Register32 // 0x400
	_              [252]byte
	ENABLE         volatile.Register32 // 0x500
	_              [4]byte
	PSEL           struct {
		SCK  volatile.Register32
		MOSI volatile.Register32
		MISO volatile.Register32
		CSN  volatile.Register32
	} // 0x508
	_         [12]byte
	FREQUENCY volatile.Register32 // 0x524
	_         [12]byte
	RXD       struct {
		PTR    volatile.Register32
		MAXCNT volatile.Register32
		AMOUNT volatile.Register32
		LIST   volatile.Register32
	} // 0x534
	TXD struct {
		PTR    volatile.Register32
		MAXCNT volatile.Register32
		AMOUNT volatile.Register32
		LIST   volatile.Register32
	} // 0x544
	CONFIG   volatile.Register32 // 0x554
	_        [8]byte
	IFTIMING struct {
		RXDELAY volatile.Register32
		CSNDUR  volatile.Register32
	} // 0x560
	CSNPOL  volatile.Register32 // 0x568
	PSELDCX volatile.Register32 // 0x56C
	DCXCNT  volatile.Register32 // 0x570
	_       [76]byte
	ORC     volatile.Register32 // 0x5C0
}

// SPI Slave 0
type SPIS_Type struct {
	_               [36]byte
	TASKS_ACQUIRE   volatile.Register32 // 0x24
	TASKS_RELEASE   volatile.Register32 // 0x28
	_               [216]byte
	EVENTS_END      volatile.Register32 // 0x104
	_               [8]byte
	EVENTS_ENDRX    volatile.Register32 // 0x110
	_               [20]byte
	EVENTS_ACQUIRED volatile.Register32 // 0x128
	_               [212]byte
	SHORTS          volatile.Register32 // 0x200
	_               [256]byte
	INTENSET        volatile.Register32 // 0x304
	INTENCLR        volatile.Register32 // 0x308
	_               [244]byte
	SEMSTAT         volatile.Register32 // 0x400
	_               [60]byte
	STATUS          volatile.Register32 // 0x440
	_               [188]byte
	ENABLE          volatile.Register32 // 0x500
	_               [4]byte
	PSEL            struct {
		SCK  volatile.Register32
		MISO volatile.Register32
		MOSI volatile.Register32
		CSN  volatile.Register32
	} // 0x508
	_   [28]byte
	RXD struct {
		PTR    volatile.Register32
		MAXCNT volatile.Register32
		AMOUNT volatile.Register32
		LIST   volatile.Register32
	} // 0x534
	TXD struct {
		PTR    volatile.Register32
		MAXCNT volatile.Register32
		AMOUNT volatile.Register32
		LIST   volatile.Register32
	} // 0x544
	CONFIG volatile.Register32 // 0x554
	_      [4]byte
	DEF    volatile.Register32 // 0x55C
	_      [96]byte
	ORC    volatile.Register32 // 0x5C0
}

// I2C compatible Two-Wire Interface 0
type TWI_Type struct {
	TASKS_STARTRX    volatile.Register32 // 0x0
	_                [4]byte
	TASKS_STARTTX    volatile.Register32 // 0x8
	_                [8]byte
	TASKS_STOP       volatile.Register32 // 0x14
	_                [4]byte
	TASKS_SUSPEND    volatile.Register32 // 0x1C
	TASKS_RESUME     volatile.Register32 // 0x20
	_                [224]byte
	EVENTS_STOPPED   volatile.Register32 // 0x104
	EVENTS_RXDREADY  volatile.Register32 // 0x108
	_                [16]byte
	EVENTS_TXDSENT   volatile.Register32 // 0x11C
	_                [4]byte
	EVENTS_ERROR     volatile.Register32 // 0x124
	_                [16]byte
	EVENTS_BB        volatile.Register32 // 0x138
	_                [12]byte
	EVENTS_SUSPENDED volatile.Register32 // 0x148
	_                [180]byte
	SHORTS           volatile.Register32 // 0x200
	_                [256]byte
	INTENSET         volatile.Register32 // 0x304
	INTENCLR         volatile.Register32 // 0x308
	_                [440]byte
	ERRORSRC         volatile.Register32 // 0x4C4
	_                [56]byte
	ENABLE           volatile.Register32 // 0x500
	_                [4]byte
	PSEL             struct {
		SCL volatile.Register32
		SDA volatile.Register32
	} // 0x508
	_         [8]byte
	RXD       volatile.Register32 // 0x518
	TXD       volatile.Register32 // 0x51C
	_         [4]byte
	FREQUENCY volatile.Register32 // 0x524
	_         [96]byte
	ADDRESS   volatile.Register32 // 0x588
}

// I2C compatible Two-Wire Master Interface with EasyDMA 0
type TWIM_Type struct {
	TASKS_STARTRX    volatile.Register32 // 0x0
	_                [4]byte
	TASKS_STARTTX    volatile.Register32 // 0x8
	_                [8]byte
	TASKS_STOP       volatile.Register32 // 0x14
	_                [4]byte
	TASKS_SUSPEND    volatile.Register32 // 0x1C
	TASKS_RESUME     volatile.Register32 // 0x20
	_                [224]byte
	EVENTS_STOPPED   volatile.Register32 // 0x104
	_                [28]byte
	EVENTS_ERROR     volatile.Register32 // 0x124
	_                [32]byte
	EVENTS_SUSPENDED volatile.Register32 // 0x148
	EVENTS_RXSTARTED volatile.Register32 // 0x14C
	EVENTS_TXSTARTED volatile.Register32 // 0x150
	_                [8]byte
	EVENTS_LASTRX    volatile.Register32 // 0x15C
	EVENTS_LASTTX    volatile.Register32 // 0x160
	_                [156]byte
	SHORTS           volatile.Register32 // 0x200
	_                [252]byte
	INTEN            volatile.Register32 // 0x300
	INTENSET         volatile.Register32 // 0x304
	INTENCLR         volatile.Register32 // 0x308
	_                [440]byte
	ERRORSRC         volatile.Register32 // 0x4C4
	_                [56]byte
	ENABLE           volatile.Register32 // 0x500
	_                [4]byte
	PSEL             struct {
		SCL volatile.Register32
		SDA volatile.Register32
	} // 0x508
	_         [20]byte
	FREQUENCY volatile.Register32 // 0x524
	_         [12]byte
	RXD       struct {
		PTR    volatile.Register32
		MAXCNT volatile.Register32
		AMOUNT volatile.Register32
		LIST   volatile.Register32
	} // 0x534
	TXD struct {
		PTR    volatile.Register32
		MAXCNT volatile.Register32
		AMOUNT volatile.Register32
		LIST   volatile.Register32
	} // 0x544
	_       [52]byte
	ADDRESS volatile.Register32 // 0x588
}

// I2C compatible Two-Wire Slave Interface with EasyDMA 0
type TWIS_Type struct {
	_                [20]byte
	TASKS_STOP       volatile.Register32 // 0x14
	_                [4]byte
	TASKS_SUSPEND    volatile.Register32 // 0x1C
	TASKS_RESUME     volatile.Register32 // 0x20
	_                [12]byte
	TASKS_PREPARERX  volatile.Register32 // 0x30
	TASKS_PREPARETX  volatile.Register32 // 0x34
	_                [204]byte
	EVENTS_STOPPED   volatile.Register32 // 0x104
	_                [28]byte
	EVENTS_ERROR     volatile.Register32 // 0x124
	_                [36]byte
	EVENTS_RXSTARTED volatile.Register32 // 0x14C
	EVENTS_TXSTARTED volatile.Register32 // 0x150
	_                [16]byte
	EVENTS_WRITE     volatile.Register32 // 0x164
	EVENTS_READ      volatile.Register32 // 0x168
	_                [148]byte
	SHORTS           volatile.Register32 // 0x200
	_                [252]byte
	INTEN            volatile.Register32 // 0x300
	INTENSET         volatile.Register32 // 0x304
	INTENCLR         volatile.Register32 // 0x308
	_                [452]byte
	ERRORSRC         volatile.Register32 // 0x4D0
	MATCH            volatile.Register32 // 0x4D4
	_                [40]byte
	ENABLE           volatile.Register32 // 0x500
	_                [4]byte
	PSEL             struct {
		SCL volatile.Register32
		SDA volatile.Register32
	} // 0x508
	_   [36]byte
	RXD struct {
		PTR    volatile.Register32
		MAXCNT volatile.Register32
		AMOUNT volatile.Register32
		LIST   volatile.Register32
	} // 0x534
	TXD struct {
		PTR    volatile.Register32
		MAXCNT volatile.Register32
		AMOUNT volatile.Register32
		LIST   volatile.Register32
	} // 0x544
	_       [52]byte
	ADDRESS [2]volatile.Register32 // 0x588
	_       [4]byte
	CONFIG  volatile.Register32 // 0x594
	_       [40]byte
	ORC     volatile.Register32 // 0x5C0
}

// NFC-A compatible radio
type NFCT_Type struct {
	TASKS_ACTIVATE           volatile.Register32 // 0x0
	TASKS_DISABLE            volatile.Register32 // 0x4
	TASKS_SENSE              volatile.Register32 // 0x8
	TASKS_STARTTX            volatile.Register32 // 0xC
	_                        [12]byte
	TASKS_ENABLERXDATA       volatile.Register32 // 0x1C
	_                        [4]byte
	TASKS_GOIDLE             volatile.Register32 // 0x24
	TASKS_GOSLEEP            volatile.Register32 // 0x28
	_                        [212]byte
	EVENTS_READY             volatile.Register32 // 0x100
	EVENTS_FIELDDETECTED     volatile.Register32 // 0x104
	EVENTS_FIELDLOST         volatile.Register32 // 0x108
	EVENTS_TXFRAMESTART      volatile.Register32 // 0x10C
	EVENTS_TXFRAMEEND        volatile.Register32 // 0x110
	EVENTS_RXFRAMESTART      volatile.Register32 // 0x114
	EVENTS_RXFRAMEEND        volatile.Register32 // 0x118
	EVENTS_ERROR             volatile.Register32 // 0x11C
	_                        [8]byte
	EVENTS_RXERROR           volatile.Register32 // 0x128
	EVENTS_ENDRX             volatile.Register32 // 0x12C
	EVENTS_ENDTX             volatile.Register32 // 0x130
	_                        [4]byte
	EVENTS_AUTOCOLRESSTARTED volatile.Register32 // 0x138
	_                        [12]byte
	EVENTS_COLLISION         volatile.Register32 // 0x148
	EVENTS_SELECTED          volatile.Register32 // 0x14C
	EVENTS_STARTED           volatile.Register32 // 0x150
	_                        [172]byte
	SHORTS                   volatile.Register32 // 0x200
	_                        [252]byte
	INTEN                    volatile.Register32 // 0x300
	INTENSET                 volatile.Register32 // 0x304
	INTENCLR                 volatile.Register32 // 0x308
	_                        [248]byte
	ERRORSTATUS              volatile.Register32 // 0x404
	_                        [4]byte
	FRAMESTATUS              struct {
		RX volatile.Register32
	} // 0x40C
	NFCTAGSTATE    volatile.Register32 // 0x410
	_              [12]byte
	SLEEPSTATE     volatile.Register32 // 0x420
	_              [24]byte
	FIELDPRESENT   volatile.Register32 // 0x43C
	_              [196]byte
	FRAMEDELAYMIN  volatile.Register32 // 0x504
	FRAMEDELAYMAX  volatile.Register32 // 0x508
	FRAMEDELAYMODE volatile.Register32 // 0x50C
	PACKETPTR      volatile.Register32 // 0x510
	MAXLEN         volatile.Register32 // 0x514
	TXD            struct {
		FRAMECONFIG volatile.Register32
		AMOUNT      volatile.Register32
	} // 0x518
	RXD struct {
		FRAMECONFIG volatile.Register32
		AMOUNT      volatile.Register32
	} // 0x520
	_                [104]byte
	NFCID1_LAST      volatile.Register32 // 0x590
	NFCID1_2ND_LAST  volatile.Register32 // 0x594
	NFCID1_3RD_LAST  volatile.Register32 // 0x598
	AUTOCOLRESCONFIG volatile.Register32 // 0x59C
	SENSRES          volatile.Register32 // 0x5A0
	SELRES           volatile.Register32 // 0x5A4
}

// GPIO Tasks and Events
type GPIOTE_Type struct {
	TASKS_OUT   [8]volatile.Register32 // 0x0
	_           [16]byte
	TASKS_SET   [8]volatile.Register32 // 0x30
	_           [16]byte
	TASKS_CLR   [8]volatile.Register32 // 0x60
	_           [128]byte
	EVENTS_IN   [8]volatile.Register32 // 0x100
	_           [92]byte
	EVENTS_PORT volatile.Register32 // 0x17C
	_           [388]byte
	INTENSET    volatile.Register32 // 0x304
	INTENCLR    volatile.Register32 // 0x308
	_           [516]byte
	CONFIG      [8]volatile.Register32 // 0x510
}

// Successive approximation register (SAR) analog-to-digital converter
type SAADC_Type struct {
	TASKS_START           volatile.Register32 // 0x0
	TASKS_SAMPLE          volatile.Register32 // 0x4
	TASKS_STOP            volatile.Register32 // 0x8
	TASKS_CALIBRATEOFFSET volatile.Register32 // 0xC
	_                     [240]byte
	EVENTS_STARTED        volatile.Register32 // 0x100
	EVENTS_END            volatile.Register32 // 0x104
	EVENTS_DONE           volatile.Register32 // 0x108
	EVENTS_RESULTDONE     volatile.Register32 // 0x10C
	EVENTS_CALIBRATEDONE  volatile.Register32 // 0x110
	EVENTS_STOPPED        volatile.Register32 // 0x114
	EVENTS_CH             [8]struct {
		LIMITH volatile.Register32
		LIMITL volatile.Register32
	} // 0x118
	_        [424]byte
	INTEN    volatile.Register32 // 0x300
	INTENSET volatile.Register32 // 0x304
	INTENCLR volatile.Register32 // 0x308
	_        [244]byte
	STATUS   volatile.Register32 // 0x400
	_        [252]byte
	ENABLE   volatile.Register32 // 0x500
	_        [12]byte
	CH       [8]struct {
		PSELP  volatile.Register32
		PSELN  volatile.Register32
		CONFIG volatile.Register32
		LIMIT  volatile.Register32
	} // 0x510
	_          [96]byte
	RESOLUTION volatile.Register32 // 0x5F0
	OVERSAMPLE volatile.Register32 // 0x5F4
	SAMPLERATE volatile.Register32 // 0x5F8
	_          [48]byte
	RESULT     struct {
		PTR    volatile.Register32
		MAXCNT volatile.Register32
		AMOUNT volatile.Register32
	} // 0x62C
}

// Timer/Counter 0
type TIMER_Type struct {
	TASKS_START    volatile.Register32 // 0x0
	TASKS_STOP     volatile.Register32 // 0x4
	TASKS_COUNT    volatile.Register32 // 0x8
	TASKS_CLEAR    volatile.Register32 // 0xC
	TASKS_SHUTDOWN volatile.Register32 // 0x10
	_              [44]byte
	TASKS_CAPTURE  [6]volatile.Register32 // 0x40
	_              [232]byte
	EVENTS_COMPARE [6]volatile.Register32 // 0x140
	_              [168]byte
	SHORTS         volatile.Register32 // 0x200
	_              [256]byte
	INTENSET       volatile.Register32 // 0x304
	INTENCLR       volatile.Register32 // 0x308
	_              [504]byte
	MODE           volatile.Register32 // 0x504
	BITMODE        volatile.Register32 // 0x508
	_              [4]byte
	PRESCALER      volatile.Register32 // 0x510
	_              [44]byte
	CC             [6]volatile.Register32 // 0x540
}

// Real time counter 0
type RTC_Type struct {
	TASKS_START      volatile.Register32 // 0x0
	TASKS_STOP       volatile.Register32 // 0x4
	TASKS_CLEAR      volatile.Register32 // 0x8
	TASKS_TRIGOVRFLW volatile.Register32 // 0xC
	_                [240]byte
	EVENTS_TICK      volatile.Register32 // 0x100
	EVENTS_OVRFLW    volatile.Register32 // 0x104
	_                [56]byte
	EVENTS_COMPARE   [4]volatile.Register32 // 0x140
	_                [436]byte
	INTENSET         volatile.Register32 // 0x304
	INTENCLR         volatile.Register32 // 0x308
	_                [52]byte
	EVTEN            volatile.Register32 // 0x340
	EVTENSET         volatile.Register32 // 0x344
	EVTENCLR         volatile.Register32 // 0x348
	_                [440]byte
	COUNTER          volatile.Register32 // 0x504
	PRESCALER        volatile.Register32 // 0x508
	_                [52]byte
	CC               [4]volatile.Register32 // 0x540
}

// Temperature Sensor
type TEMP_Type struct {
	TASKS_START    volatile.Register32 // 0x0
	TASKS_STOP     volatile.Register32 // 0x4
	_              [248]byte
	EVENTS_DATARDY volatile.Register32 // 0x100
	_              [512]byte
	INTENSET       volatile.Register32 // 0x304
	INTENCLR       volatile.Register32 // 0x308
	_              [508]byte
	TEMP           volatile.Register32 // 0x508
	_              [20]byte
	A0             volatile.Register32 // 0x520
	A1             volatile.Register32 // 0x524
	A2             volatile.Register32 // 0x528
	A3             volatile.Register32 // 0x52C
	A4             volatile.Register32 // 0x530
	A5             volatile.Register32 // 0x534
	_              [8]byte
	B0             volatile.Register32 // 0x540
	B1             volatile.Register32 // 0x544
	B2             volatile.Register32 // 0x548
	B3             volatile.Register32 // 0x54C
	B4             volatile.Register32 // 0x550
	B5             volatile.Register32 // 0x554
	_              [8]byte
	T0             volatile.Register32 // 0x560
	T1             volatile.Register32 // 0x564
	T2             volatile.Register32 // 0x568
	T3             volatile.Register32 // 0x56C
	T4             volatile.Register32 // 0x570
}

// Random Number Generator
type RNG_Type struct {
	TASKS_START   volatile.Register32 // 0x0
	TASKS_STOP    volatile.Register32 // 0x4
	_             [248]byte
	EVENTS_VALRDY volatile.Register32 // 0x100
	_             [252]byte
	SHORTS        volatile.Register32 // 0x200
	_             [256]byte
	INTENSET      volatile.Register32 // 0x304
	INTENCLR      volatile.Register32 // 0x308
	_             [504]byte
	CONFIG        volatile.Register32 // 0x504
	VALUE         volatile.Register32 // 0x508
}

// AES ECB Mode Encryption
type ECB_Type struct {
	TASKS_STARTECB  volatile.Register32 // 0x0
	TASKS_STOPECB   volatile.Register32 // 0x4
	_               [248]byte
	EVENTS_ENDECB   volatile.Register32 // 0x100
	EVENTS_ERRORECB volatile.Register32 // 0x104
	_               [508]byte
	INTENSET        volatile.Register32 // 0x304
	INTENCLR        volatile.Register32 // 0x308
	_               [504]byte
	ECBDATAPTR      volatile.Register32 // 0x504
}

// Accelerated Address Resolver
type AAR_Type struct {
	TASKS_START        volatile.Register32 // 0x0
	_                  [4]byte
	TASKS_STOP         volatile.Register32 // 0x8
	_                  [244]byte
	EVENTS_END         volatile.Register32 // 0x100
	EVENTS_RESOLVED    volatile.Register32 // 0x104
	EVENTS_NOTRESOLVED volatile.Register32 // 0x108
	_                  [504]byte
	INTENSET           volatile.Register32 // 0x304
	INTENCLR           volatile.Register32 // 0x308
	_                  [244]byte
	STATUS             volatile.Register32 // 0x400
	_                  [252]byte
	ENABLE             volatile.Register32 // 0x500
	NIRK               volatile.Register32 // 0x504
	IRKPTR             volatile.Register32 // 0x508
	_                  [4]byte
	ADDRPTR            volatile.Register32 // 0x510
	SCRATCHPTR         volatile.Register32 // 0x514
}

// AES CCM Mode Encryption
type CCM_Type struct {
	TASKS_KSGEN        volatile.Register32 // 0x0
	TASKS_CRYPT        volatile.Register32 // 0x4
	TASKS_STOP         volatile.Register32 // 0x8
	TASKS_RATEOVERRIDE volatile.Register32 // 0xC
	_                  [240]byte
	EVENTS_ENDKSGEN    volatile.Register32 // 0x100
	EVENTS_ENDCRYPT    volatile.Register32 // 0x104
	EVENTS_ERROR       volatile.Register32 // 0x108
	_                  [244]byte
	SHORTS             volatile.Register32 // 0x200
	_                  [256]byte
	INTENSET           volatile.Register32 // 0x304
	INTENCLR           volatile.Register32 // 0x308
	_                  [244]byte
	MICSTATUS          volatile.Register32 // 0x400
	_                  [252]byte
	ENABLE             volatile.Register32 // 0x500
	MODE               volatile.Register32 // 0x504
	CNFPTR             volatile.Register32 // 0x508
	INPTR              volatile.Register32 // 0x50C
	OUTPTR             volatile.Register32 // 0x510
	SCRATCHPTR         volatile.Register32 // 0x514
	MAXPACKETSIZE      volatile.Register32 // 0x518
	RATEOVERRIDE       volatile.Register32 // 0x51C
}

// Watchdog Timer
type WDT_Type struct {
	TASKS_START    volatile.Register32 // 0x0
	_              [252]byte
	EVENTS_TIMEOUT volatile.Register32 // 0x100
	_              [512]byte
	INTENSET       volatile.Register32 // 0x304
	INTENCLR       volatile.Register32 // 0x308
	_              [244]byte
	RUNSTATUS      volatile.Register32 // 0x400
	REQSTATUS      volatile.Register32 // 0x404
	_              [252]byte
	CRV            volatile.Register32 // 0x504
	RREN           volatile.Register32 // 0x508
	CONFIG         volatile.Register32 // 0x50C
	_              [240]byte
	RR             [8]volatile.Register32 // 0x600
}

// Quadrature Decoder
type QDEC_Type struct {
	TASKS_START      volatile.Register32 // 0x0
	TASKS_STOP       volatile.Register32 // 0x4
	TASKS_READCLRACC volatile.Register32 // 0x8
	TASKS_RDCLRACC   volatile.Register32 // 0xC
	TASKS_RDCLRDBL   volatile.Register32 // 0x10
	_                [236]byte
	EVENTS_SAMPLERDY volatile.Register32 // 0x100
	EVENTS_REPORTRDY volatile.Register32 // 0x104
	EVENTS_ACCOF     volatile.Register32 // 0x108
	EVENTS_DBLRDY    volatile.Register32 // 0x10C
	EVENTS_STOPPED   volatile.Register32 // 0x110
	_                [236]byte
	SHORTS           volatile.Register32 // 0x200
	_                [256]byte
	INTENSET         volatile.Register32 // 0x304
	INTENCLR         volatile.Register32 // 0x308
	_                [500]byte
	ENABLE           volatile.Register32 // 0x500
	LEDPOL           volatile.Register32 // 0x504
	SAMPLEPER        volatile.Register32 // 0x508
	SAMPLE           volatile.Register32 // 0x50C
	REPORTPER        volatile.Register32 // 0x510
	ACC              volatile.Register32 // 0x514
	ACCREAD          volatile.Register32 // 0x518
	PSEL             struct {
		LED volatile.Register32
		A   volatile.Register32
		B   volatile.Register32
	} // 0x51C
	DBFEN      volatile.Register32 // 0x528
	_          [20]byte
	LEDPRE     volatile.Register32 // 0x540
	ACCDBL     volatile.Register32 // 0x544
	ACCDBLREAD volatile.Register32 // 0x548
}

// Comparator
type COMP_Type struct {
	TASKS_START  volatile.Register32 // 0x0
	TASKS_STOP   volatile.Register32 // 0x4
	TASKS_SAMPLE volatile.Register32 // 0x8
	_            [244]byte
	EVENTS_READY volatile.Register32 // 0x100
	EVENTS_DOWN  volatile.Register32 // 0x104
	EVENTS_UP    volatile.Register32 // 0x108
	EVENTS_CROSS volatile.Register32 // 0x10C
	_            [240]byte
	SHORTS       volatile.Register32 // 0x200
	_            [252]byte
	INTEN        volatile.Register32 // 0x300
	INTENSET     volatile.Register32 // 0x304
	INTENCLR     volatile.Register32 // 0x308
	_            [244]byte
	RESULT       volatile.Register32 // 0x400
	_            [252]byte
	ENABLE       volatile.Register32 // 0x500
	PSEL         volatile.Register32 // 0x504
	REFSEL       volatile.Register32 // 0x508
	EXTREFSEL    volatile.Register32 // 0x50C
	_            [32]byte
	TH           volatile.Register32 // 0x530
	MODE         volatile.Register32 // 0x534
	HYST         volatile.Register32 // 0x538
}

// Low Power Comparator
type LPCOMP_Type struct {
	TASKS_START  volatile.Register32 // 0x0
	TASKS_STOP   volatile.Register32 // 0x4
	TASKS_SAMPLE volatile.Register32 // 0x8
	_            [244]byte
	EVENTS_READY volatile.Register32 // 0x100
	EVENTS_DOWN  volatile.Register32 // 0x104
	EVENTS_UP    volatile.Register32 // 0x108
	EVENTS_CROSS volatile.Register32 // 0x10C
	_            [240]byte
	SHORTS       volatile.Register32 // 0x200
	_            [256]byte
	INTENSET     volatile.Register32 // 0x304
	INTENCLR     volatile.Register32 // 0x308
	_            [244]byte
	RESULT       volatile.Register32 // 0x400
	_            [252]byte
	ENABLE       volatile.Register32 // 0x500
	PSEL         volatile.Register32 // 0x504
	REFSEL       volatile.Register32 // 0x508
	EXTREFSEL    volatile.Register32 // 0x50C
	_            [16]byte
	ANADETECT    volatile.Register32 // 0x520
	_            [20]byte
	HYST         volatile.Register32 // 0x538
}

// Event Generator Unit 0
type EGU_Type struct {
	TASKS_TRIGGER    [16]volatile.Register32 // 0x0
	_                [192]byte
	EVENTS_TRIGGERED [16]volatile.Register32 // 0x100
	_                [448]byte
	INTEN            volatile.Register32 // 0x300
	INTENSET         volatile.Register32 // 0x304
	INTENCLR         volatile.Register32 // 0x308
}

// Software interrupt 0
type SWI_Type struct {
	UNUSED volatile.Register32 // 0x0
}

// Pulse width modulation unit 0
type PWM_Type struct {
	_                   [4]byte
	TASKS_STOP          volatile.Register32    // 0x4
	TASKS_SEQSTART      [2]volatile.Register32 // 0x8
	TASKS_NEXTSTEP      volatile.Register32    // 0x10
	_                   [240]byte
	EVENTS_STOPPED      volatile.Register32    // 0x104
	EVENTS_SEQSTARTED   [2]volatile.Register32 // 0x108
	EVENTS_SEQEND       [2]volatile.Register32 // 0x110
	EVENTS_PWMPERIODEND volatile.Register32    // 0x118
	EVENTS_LOOPSDONE    volatile.Register32    // 0x11C
	_                   [224]byte
	SHORTS              volatile.Register32 // 0x200
	_                   [252]byte
	INTEN               volatile.Register32 // 0x300
	INTENSET            volatile.Register32 // 0x304
	INTENCLR            volatile.Register32 // 0x308
	_                   [500]byte
	ENABLE              volatile.Register32 // 0x500
	MODE                volatile.Register32 // 0x504
	COUNTERTOP          volatile.Register32 // 0x508
	PRESCALER           volatile.Register32 // 0x50C
	DECODER             volatile.Register32 // 0x510
	LOOP                volatile.Register32 // 0x514
	_                   [8]byte
	SEQ                 [2]struct {
		PTR      volatile.Register32
		CNT      volatile.Register32
		REFRESH  volatile.Register32
		ENDDELAY volatile.Register32
		_        [16]byte
	} // 0x520
	PSEL struct {
		OUT [4]volatile.Register32
	} // 0x560
}

// Pulse Density Modulation (Digital Microphone) Interface
type PDM_Type struct {
	TASKS_START    volatile.Register32 // 0x0
	TASKS_STOP     volatile.Register32 // 0x4
	_              [248]byte
	EVENTS_STARTED volatile.Register32 // 0x100
	EVENTS_STOPPED volatile.Register32 // 0x104
	EVENTS_END     volatile.Register32 // 0x108
	_              [500]byte
	INTEN          volatile.Register32 // 0x300
	INTENSET       volatile.Register32 // 0x304
	INTENCLR       volatile.Register32 // 0x308
	_              [500]byte
	ENABLE         volatile.Register32 // 0x500
	PDMCLKCTRL     volatile.Register32 // 0x504
	MODE           volatile.Register32 // 0x508
	_              [12]byte
	GAINL          volatile.Register32 // 0x518
	GAINR          volatile.Register32 // 0x51C
	RATIO          volatile.Register32 // 0x520
	_              [28]byte
	PSEL           struct {
		CLK volatile.Register32
		DIN volatile.Register32
	} // 0x540
	_      [24]byte
	SAMPLE struct {
		PTR    volatile.Register32
		MAXCNT volatile.Register32
	} // 0x560
}

// Access control lists
type ACL_Type struct {
	_   [2048]byte
	ACL [8]struct {
		ADDR volatile.Register32
		SIZE volatile.Register32
		PERM volatile.Register32
		_    [4]byte
	} // 0x800
}

// Non Volatile Memory Controller
type NVMC_Type struct {
	_                   [1024]byte
	READY               volatile.Register32 // 0x400
	_                   [4]byte
	READYNEXT           volatile.Register32 // 0x408
	_                   [248]byte
	CONFIG              volatile.Register32 // 0x504
	ERASEPAGE           volatile.Register32 // 0x508
	ERASEALL            volatile.Register32 // 0x50C
	ERASEPCR0           volatile.Register32 // 0x510
	ERASEUICR           volatile.Register32 // 0x514
	ERASEPAGEPARTIAL    volatile.Register32 // 0x518
	ERASEPAGEPARTIALCFG volatile.Register32 // 0x51C
	_                   [32]byte
	ICACHECNF           volatile.Register32 // 0x540
	_                   [4]byte
	IHIT                volatile.Register32 // 0x548
	IMISS               volatile.Register32 // 0x54C
}

// Programmable Peripheral Interconnect
type PPI_Type struct {
	TASKS_CHG [6]struct {
		EN  volatile.Register32
		DIS volatile.Register32
	} // 0x0
	_       [1232]byte
	CHEN    volatile.Register32 // 0x500
	CHENSET volatile.Register32 // 0x504
	CHENCLR volatile.Register32 // 0x508
	_       [4]byte
	CH      [20]struct {
		EEP volatile.Register32
		TEP volatile.Register32
	} // 0x510
	_    [592]byte
	CHG  [6]volatile.Register32 // 0x800
	_    [248]byte
	FORK [32]struct {
		TEP volatile.Register32
	} // 0x910
}

// Memory Watch Unit
type MWU_Type struct {
	_             [256]byte
	EVENTS_REGION [4]struct {
		WA volatile.Register32
		RA volatile.Register32
	} // 0x100
	_              [64]byte
	EVENTS_PREGION [2]struct {
		WA volatile.Register32
		RA volatile.Register32
	} // 0x160
	_         [400]byte
	INTEN     volatile.Register32 // 0x300
	INTENSET  volatile.Register32 // 0x304
	INTENCLR  volatile.Register32 // 0x308
	_         [20]byte
	NMIEN     volatile.Register32 // 0x320
	NMIENSET  volatile.Register32 // 0x324
	NMIENCLR  volatile.Register32 // 0x328
	_         [212]byte
	PERREGION [2]struct {
		SUBSTATWA volatile.Register32
		SUBSTATRA volatile.Register32
	} // 0x400
	_           [256]byte
	REGIONEN    volatile.Register32 // 0x510
	REGIONENSET volatile.Register32 // 0x514
	REGIONENCLR volatile.Register32 // 0x518
	_           [228]byte
	REGION      [4]struct {
		START volatile.Register32
		END   volatile.Register32
		_     [8]byte
	} // 0x600
	_       [128]byte
	PREGION [2]struct {
		START volatile.Register32
		END   volatile.Register32
		SUBS  volatile.Register32
		_     [4]byte
	} // 0x6C0
}

// Inter-IC Sound
type I2S_Type struct {
	TASKS_START     volatile.Register32 // 0x0
	TASKS_STOP      volatile.Register32 // 0x4
	_               [252]byte
	EVENTS_RXPTRUPD volatile.Register32 // 0x104
	EVENTS_STOPPED  volatile.Register32 // 0x108
	_               [8]byte
	EVENTS_TXPTRUPD volatile.Register32 // 0x114
	_               [488]byte
	INTEN           volatile.Register32 // 0x300
	INTENSET        volatile.Register32 // 0x304
	INTENCLR        volatile.Register32 // 0x308
	_               [500]byte
	ENABLE          volatile.Register32 // 0x500
	CONFIG          struct {
		MODE     volatile.Register32
		RXEN     volatile.Register32
		TXEN     volatile.Register32
		MCKEN    volatile.Register32
		MCKFREQ  volatile.Register32
		RATIO    volatile.Register32
		SWIDTH   volatile.Register32
		ALIGN    volatile.Register32
		FORMAT   volatile.Register32
		CHANNELS volatile.Register32
	} // 0x504
	_   [12]byte
	RXD struct {
		PTR volatile.Register32
	} // 0x538
	_   [4]byte
	TXD struct {
		PTR volatile.Register32
	} // 0x540
	_     [12]byte
	RXTXD struct {
		MAXCNT volatile.Register32
	} // 0x550
	_    [12]byte
	PSEL struct {
		MCK   volatile.Register32
		SCK   volatile.Register32
		LRCK  volatile.Register32
		SDIN  volatile.Register32
		SDOUT volatile.Register32
	} // 0x560
}

// FPU
type FPU_Type struct {
	UNUSED volatile.Register32 // 0x0
}

// Universal serial bus device
type USBD_Type struct {
	_                  [4]byte
	TASKS_STARTEPIN    [8]volatile.Register32 // 0x4
	TASKS_STARTISOIN   volatile.Register32    // 0x24
	TASKS_STARTEPOUT   [8]volatile.Register32 // 0x28
	TASKS_STARTISOOUT  volatile.Register32    // 0x48
	TASKS_EP0RCVOUT    volatile.Register32    // 0x4C
	TASKS_EP0STATUS    volatile.Register32    // 0x50
	TASKS_EP0STALL     volatile.Register32    // 0x54
	TASKS_DPDMDRIVE    volatile.Register32    // 0x58
	TASKS_DPDMNODRIVE  volatile.Register32    // 0x5C
	_                  [160]byte
	EVENTS_USBRESET    volatile.Register32    // 0x100
	EVENTS_STARTED     volatile.Register32    // 0x104
	EVENTS_ENDEPIN     [8]volatile.Register32 // 0x108
	EVENTS_EP0DATADONE volatile.Register32    // 0x128
	EVENTS_ENDISOIN    volatile.Register32    // 0x12C
	EVENTS_ENDEPOUT    [8]volatile.Register32 // 0x130
	EVENTS_ENDISOOUT   volatile.Register32    // 0x150
	EVENTS_SOF         volatile.Register32    // 0x154
	EVENTS_USBEVENT    volatile.Register32    // 0x158
	EVENTS_EP0SETUP    volatile.Register32    // 0x15C
	EVENTS_EPDATA      volatile.Register32    // 0x160
	_                  [156]byte
	SHORTS             volatile.Register32 // 0x200
	_                  [252]byte
	INTEN              volatile.Register32 // 0x300
	INTENSET           volatile.Register32 // 0x304
	INTENCLR           volatile.Register32 // 0x308
	_                  [244]byte
	EVENTCAUSE         volatile.Register32 // 0x400
	_                  [28]byte
	HALTED             struct {
		EPIN  [8]volatile.Register32
		_     [4]byte
		EPOUT [8]volatile.Register32
	} // 0x420
	_             [4]byte
	EPSTATUS      volatile.Register32 // 0x468
	EPDATASTATUS  volatile.Register32 // 0x46C
	USBADDR       volatile.Register32 // 0x470
	_             [12]byte
	BMREQUESTTYPE volatile.Register32 // 0x480
	BREQUEST      volatile.Register32 // 0x484
	WVALUEL       volatile.Register32 // 0x488
	WVALUEH       volatile.Register32 // 0x48C
	WINDEXL       volatile.Register32 // 0x490
	WINDEXH       volatile.Register32 // 0x494
	WLENGTHL      volatile.Register32 // 0x498
	WLENGTHH      volatile.Register32 // 0x49C
	SIZE          struct {
		EPOUT  [8]volatile.Register32
		ISOOUT volatile.Register32
	} // 0x4A0
	_           [60]byte
	ENABLE      volatile.Register32 // 0x500
	USBPULLUP   volatile.Register32 // 0x504
	DPDMVALUE   volatile.Register32 // 0x508
	DTOGGLE     volatile.Register32 // 0x50C
	EPINEN      volatile.Register32 // 0x510
	EPOUTEN     volatile.Register32 // 0x514
	EPSTALL     volatile.Register32 // 0x518
	ISOSPLIT    volatile.Register32 // 0x51C
	FRAMECNTR   volatile.Register32 // 0x520
	_           [8]byte
	LOWPOWER    volatile.Register32 // 0x52C
	ISOINCONFIG volatile.Register32 // 0x530
	_           [204]byte
	EPIN        [8]struct {
		PTR    volatile.Register32
		MAXCNT volatile.Register32
		AMOUNT volatile.Register32
		_      [8]byte
	} // 0x600
	ISOIN struct {
		PTR    volatile.Register32
		MAXCNT volatile.Register32
		AMOUNT volatile.Register32
	} // 0x6A0
	_     [84]byte
	EPOUT [8]struct {
		PTR    volatile.Register32
		MAXCNT volatile.Register32
		AMOUNT volatile.Register32
		_      [8]byte
	} // 0x700
	ISOOUT struct {
		PTR    volatile.Register32
		MAXCNT volatile.Register32
		AMOUNT volatile.Register32
	} // 0x7A0
}

// External flash interface
type QSPI_Type struct {
	TASKS_ACTIVATE   volatile.Register32 // 0x0
	TASKS_READSTART  volatile.Register32 // 0x4
	TASKS_WRITESTART volatile.Register32 // 0x8
	TASKS_ERASESTART volatile.Register32 // 0xC
	TASKS_DEACTIVATE volatile.Register32 // 0x10
	_                [236]byte
	EVENTS_READY     volatile.Register32 // 0x100
	_                [508]byte
	INTEN            volatile.Register32 // 0x300
	INTENSET         volatile.Register32 // 0x304
	INTENCLR         volatile.Register32 // 0x308
	_                [500]byte
	ENABLE           volatile.Register32 // 0x500
	READ             struct {
		SRC volatile.Register32
		DST volatile.Register32
		CNT volatile.Register32
	} // 0x504
	WRITE struct {
		DST volatile.Register32
		SRC volatile.Register32
		CNT volatile.Register32
	} // 0x510
	ERASE struct {
		PTR volatile.Register32
		LEN volatile.Register32
	} // 0x51C
	PSEL struct {
		SCK volatile.Register32
		CSN volatile.Register32
		_   [4]byte
		IO0 volatile.Register32
		IO1 volatile.Register32
		IO2 volatile.Register32
		IO3 volatile.Register32
	} // 0x524
	XIPOFFSET  volatile.Register32 // 0x540
	IFCONFIG0  volatile.Register32 // 0x544
	_          [184]byte
	IFCONFIG1  volatile.Register32 // 0x600
	STATUS     volatile.Register32 // 0x604
	_          [12]byte
	DPMDUR     volatile.Register32 // 0x614
	_          [12]byte
	ADDRCONF   volatile.Register32 // 0x624
	_          [12]byte
	CINSTRCONF volatile.Register32 // 0x634
	CINSTRDAT0 volatile.Register32 // 0x638
	CINSTRDAT1 volatile.Register32 // 0x63C
	IFTIMING   volatile.Register32 // 0x640
}

// CRYPTOCELL HOST_RGF interface
type CC_HOST_RGF_Type struct {
	_                   [6712]byte
	HOST_CRYPTOKEY_SEL  volatile.Register32 // 0x1A38
	_                   [16]byte
	HOST_IOT_KPRTL_LOCK volatile.Register32 // 0x1A4C
	HOST_IOT_KDR0       volatile.Register32 // 0x1A50
	HOST_IOT_KDR1       volatile.Register32 // 0x1A54
	HOST_IOT_KDR2       volatile.Register32 // 0x1A58
	HOST_IOT_KDR3       volatile.Register32 // 0x1A5C
	HOST_IOT_LCS        volatile.Register32 // 0x1A60
}

// ARM TrustZone CryptoCell register interface
type CRYPTOCELL_Type struct {
	_      [1280]byte
	ENABLE volatile.Register32 // 0x500
}

// Bitfields for FICR: Factory information configuration registers
const (
	// CODEPAGESIZE: Code memory page size
	// Position of CODEPAGESIZE field.
	FICR_CODEPAGESIZE_CODEPAGESIZE_Pos = 0x0
	// Bit mask of CODEPAGESIZE field.
	FICR_CODEPAGESIZE_CODEPAGESIZE_Msk = 0xffffffff

	// CODESIZE: Code memory size
	// Position of CODESIZE field.
	FICR_CODESIZE_CODESIZE_Pos = 0x0
	// Bit mask of CODESIZE field.
	FICR_CODESIZE_CODESIZE_Msk = 0xffffffff

	// DEVICEID: Description collection: Device identifier
	// Position of DEVICEID field.
	FICR_DEVICEID_DEVICEID_Pos = 0x0
	// Bit mask of DEVICEID field.
	FICR_DEVICEID_DEVICEID_Msk = 0xffffffff

	// ER: Description collection: Encryption root, word n
	// Position of ER field.
	FICR_ER_ER_Pos = 0x0
	// Bit mask of ER field.
	FICR_ER_ER_Msk = 0xffffffff

	// IR: Description collection: Identity Root, word n
	// Position of IR field.
	FICR_IR_IR_Pos = 0x0
	// Bit mask of IR field.
	FICR_IR_IR_Msk = 0xffffffff

	// DEVICEADDRTYPE: Device address type
	// Position of DEVICEADDRTYPE field.
	FICR_DEVICEADDRTYPE_DEVICEADDRTYPE_Pos = 0x0
	// Bit mask of DEVICEADDRTYPE field.
	FICR_DEVICEADDRTYPE_DEVICEADDRTYPE_Msk = 0x1
	// Bit DEVICEADDRTYPE.
	FICR_DEVICEADDRTYPE_DEVICEADDRTYPE = 0x1
	// Public address
	FICR_DEVICEADDRTYPE_DEVICEADDRTYPE_Public = 0x0
	// Random address
	FICR_DEVICEADDRTYPE_DEVICEADDRTYPE_Random = 0x1

	// DEVICEADDR: Description collection: Device address n
	// Position of DEVICEADDR field.
	FICR_DEVICEADDR_DEVICEADDR_Pos = 0x0
	// Bit mask of DEVICEADDR field.
	FICR_DEVICEADDR_DEVICEADDR_Msk = 0xffffffff

	// INFO.PART: Part code
	// Position of PART field.
	FICR_INFO_PART_PART_Pos = 0x0
	// Bit mask of PART field.
	FICR_INFO_PART_PART_Msk = 0xffffffff
	// nRF52833
	FICR_INFO_PART_PART_N52833 = 0x52833
	// nRF52840
	FICR_INFO_PART_PART_N52840 = 0x52840
	// Unspecified
	FICR_INFO_PART_PART_Unspecified = 0xffffffff

	// INFO.VARIANT: Build code (hardware version and production configuration)
	// Position of VARIANT field.
	FICR_INFO_VARIANT_VARIANT_Pos = 0x0
	// Bit mask of VARIANT field.
	FICR_INFO_VARIANT_VARIANT_Msk = 0xffffffff
	// AAAA
	FICR_INFO_VARIANT_VARIANT_AAAA = 0x41414141
	// BAAA
	FICR_INFO_VARIANT_VARIANT_BAAA = 0x42414141
	// CAAA
	FICR_INFO_VARIANT_VARIANT_CAAA = 0x43414141
	// AABA
	FICR_INFO_VARIANT_VARIANT_AABA = 0x41414241
	// AABB
	FICR_INFO_VARIANT_VARIANT_AABB = 0x41414242
	// AACA
	FICR_INFO_VARIANT_VARIANT_AACA = 0x41414341
	// AAAB
	FICR_INFO_VARIANT_VARIANT_AAAB = 0x41414142
	// Unspecified
	FICR_INFO_VARIANT_VARIANT_Unspecified = 0xffffffff

	// INFO.PACKAGE: Package option
	// Position of PACKAGE field.
	FICR_INFO_PACKAGE_PACKAGE_Pos = 0x0
	// Bit mask of PACKAGE field.
	FICR_INFO_PACKAGE_PACKAGE_Msk = 0xffffffff
	// QIxx - 73-pin aQFN
	FICR_INFO_PACKAGE_PACKAGE_QI = 0x2004
	// CKxx - WLCSP
	FICR_INFO_PACKAGE_PACKAGE_CK = 0x2005
	// Unspecified
	FICR_INFO_PACKAGE_PACKAGE_Unspecified = 0xffffffff

	// INFO.RAM: RAM variant
	// Position of RAM field.
	FICR_INFO_RAM_RAM_Pos = 0x0
	// Bit mask of RAM field.
	FICR_INFO_RAM_RAM_Msk = 0xffffffff
	// 16 kByte RAM
	FICR_INFO_RAM_RAM_K16 = 0x10
	// 32 kByte RAM
	FICR_INFO_RAM_RAM_K32 = 0x20
	// 64 kByte RAM
	FICR_INFO_RAM_RAM_K64 = 0x40
	// 128 kByte RAM
	FICR_INFO_RAM_RAM_K128 = 0x80
	// 256 kByte RAM
	FICR_INFO_RAM_RAM_K256 = 0x100
	// Unspecified
	FICR_INFO_RAM_RAM_Unspecified = 0xffffffff

	// INFO.FLASH: Flash variant
	// Position of FLASH field.
	FICR_INFO_FLASH_FLASH_Pos = 0x0
	// Bit mask of FLASH field.
	FICR_INFO_FLASH_FLASH_Msk = 0xffffffff
	// 128 kByte FLASH
	FICR_INFO_FLASH_FLASH_K128 = 0x80
	// 256 kByte FLASH
	FICR_INFO_FLASH_FLASH_K256 = 0x100
	// 512 kByte FLASH
	FICR_INFO_FLASH_FLASH_K512 = 0x200
	// 1 MByte FLASH
	FICR_INFO_FLASH_FLASH_K1024 = 0x400
	// 2 MByte FLASH
	FICR_INFO_FLASH_FLASH_K2048 = 0x800
	// Unspecified
	FICR_INFO_FLASH_FLASH_Unspecified = 0xffffffff

	// PRODTEST: Description collection: Production test signature n
	// Position of PRODTEST field.
	FICR_PRODTEST_PRODTEST_Pos = 0x0
	// Bit mask of PRODTEST field.
	FICR_PRODTEST_PRODTEST_Msk = 0xffffffff
	// Production tests done
	FICR_PRODTEST_PRODTEST_Done = 0xbb42319f
	// Production tests not done
	FICR_PRODTEST_PRODTEST_NotDone = 0xffffffff

	// TEMP.A0: Slope definition A0
	// Position of A field.
	FICR_TEMP_A0_A_Pos = 0x0
	// Bit mask of A field.
	FICR_TEMP_A0_A_Msk = 0xfff

	// TEMP.A1: Slope definition A1
	// Position of A field.
	FICR_TEMP_A1_A_Pos = 0x0
	// Bit mask of A field.
	FICR_TEMP_A1_A_Msk = 0xfff

	// TEMP.A2: Slope definition A2
	// Position of A field.
	FICR_TEMP_A2_A_Pos = 0x0
	// Bit mask of A field.
	FICR_TEMP_A2_A_Msk = 0xfff

	// TEMP.A3: Slope definition A3
	// Position of A field.
	FICR_TEMP_A3_A_Pos = 0x0
	// Bit mask of A field.
	FICR_TEMP_A3_A_Msk = 0xfff

	// TEMP.A4: Slope definition A4
	// Position of A field.
	FICR_TEMP_A4_A_Pos = 0x0
	// Bit mask of A field.
	FICR_TEMP_A4_A_Msk = 0xfff

	// TEMP.A5: Slope definition A5
	// Position of A field.
	FICR_TEMP_A5_A_Pos = 0x0
	// Bit mask of A field.
	FICR_TEMP_A5_A_Msk = 0xfff

	// TEMP.B0: Y-intercept B0
	// Position of B field.
	FICR_TEMP_B0_B_Pos = 0x0
	// Bit mask of B field.
	FICR_TEMP_B0_B_Msk = 0x3fff

	// TEMP.B1: Y-intercept B1
	// Position of B field.
	FICR_TEMP_B1_B_Pos = 0x0
	// Bit mask of B field.
	FICR_TEMP_B1_B_Msk = 0x3fff

	// TEMP.B2: Y-intercept B2
	// Position of B field.
	FICR_TEMP_B2_B_Pos = 0x0
	// Bit mask of B field.
	FICR_TEMP_B2_B_Msk = 0x3fff

	// TEMP.B3: Y-intercept B3
	// Position of B field.
	FICR_TEMP_B3_B_Pos = 0x0
	// Bit mask of B field.
	FICR_TEMP_B3_B_Msk = 0x3fff

	// TEMP.B4: Y-intercept B4
	// Position of B field.
	FICR_TEMP_B4_B_Pos = 0x0
	// Bit mask of B field.
	FICR_TEMP_B4_B_Msk = 0x3fff

	// TEMP.B5: Y-intercept B5
	// Position of B field.
	FICR_TEMP_B5_B_Pos = 0x0
	// Bit mask of B field.
	FICR_TEMP_B5_B_Msk = 0x3fff

	// TEMP.T0: Segment end T0
	// Position of T field.
	FICR_TEMP_T0_T_Pos = 0x0
	// Bit mask of T field.
	FICR_TEMP_T0_T_Msk = 0xff

	// TEMP.T1: Segment end T1
	// Position of T field.
	FICR_TEMP_T1_T_Pos = 0x0
	// Bit mask of T field.
	FICR_TEMP_T1_T_Msk = 0xff

	// TEMP.T2: Segment end T2
	// Position of T field.
	FICR_TEMP_T2_T_Pos = 0x0
	// Bit mask of T field.
	FICR_TEMP_T2_T_Msk = 0xff

	// TEMP.T3: Segment end T3
	// Position of T field.
	FICR_TEMP_T3_T_Pos = 0x0
	// Bit mask of T field.
	FICR_TEMP_T3_T_Msk = 0xff

	// TEMP.T4: Segment end T4
	// Position of T field.
	FICR_TEMP_T4_T_Pos = 0x0
	// Bit mask of T field.
	FICR_TEMP_T4_T_Msk = 0xff

	// NFC.TAGHEADER0: Default header for NFC tag. Software can read these values to populate NFCID1_3RD_LAST, NFCID1_2ND_LAST, and NFCID1_LAST.
	// Position of MFGID field.
	FICR_NFC_TAGHEADER0_MFGID_Pos = 0x0
	// Bit mask of MFGID field.
	FICR_NFC_TAGHEADER0_MFGID_Msk = 0xff
	// Position of UD1 field.
	FICR_NFC_TAGHEADER0_UD1_Pos = 0x8
	// Bit mask of UD1 field.
	FICR_NFC_TAGHEADER0_UD1_Msk = 0xff00
	// Position of UD2 field.
	FICR_NFC_TAGHEADER0_UD2_Pos = 0x10
	// Bit mask of UD2 field.
	FICR_NFC_TAGHEADER0_UD2_Msk = 0xff0000
	// Position of UD3 field.
	FICR_NFC_TAGHEADER0_UD3_Pos = 0x18
	// Bit mask of UD3 field.
	FICR_NFC_TAGHEADER0_UD3_Msk = 0xff000000

	// NFC.TAGHEADER1: Default header for NFC tag. Software can read these values to populate NFCID1_3RD_LAST, NFCID1_2ND_LAST, and NFCID1_LAST.
	// Position of UD4 field.
	FICR_NFC_TAGHEADER1_UD4_Pos = 0x0
	// Bit mask of UD4 field.
	FICR_NFC_TAGHEADER1_UD4_Msk = 0xff
	// Position of UD5 field.
	FICR_NFC_TAGHEADER1_UD5_Pos = 0x8
	// Bit mask of UD5 field.
	FICR_NFC_TAGHEADER1_UD5_Msk = 0xff00
	// Position of UD6 field.
	FICR_NFC_TAGHEADER1_UD6_Pos = 0x10
	// Bit mask of UD6 field.
	FICR_NFC_TAGHEADER1_UD6_Msk = 0xff0000
	// Position of UD7 field.
	FICR_NFC_TAGHEADER1_UD7_Pos = 0x18
	// Bit mask of UD7 field.
	FICR_NFC_TAGHEADER1_UD7_Msk = 0xff000000

	// NFC.TAGHEADER2: Default header for NFC tag. Software can read these values to populate NFCID1_3RD_LAST, NFCID1_2ND_LAST, and NFCID1_LAST.
	// Position of UD8 field.
	FICR_NFC_TAGHEADER2_UD8_Pos = 0x0
	// Bit mask of UD8 field.
	FICR_NFC_TAGHEADER2_UD8_Msk = 0xff
	// Position of UD9 field.
	FICR_NFC_TAGHEADER2_UD9_Pos = 0x8
	// Bit mask of UD9 field.
	FICR_NFC_TAGHEADER2_UD9_Msk = 0xff00
	// Position of UD10 field.
	FICR_NFC_TAGHEADER2_UD10_Pos = 0x10
	// Bit mask of UD10 field.
	FICR_NFC_TAGHEADER2_UD10_Msk = 0xff0000
	// Position of UD11 field.
	FICR_NFC_TAGHEADER2_UD11_Pos = 0x18
	// Bit mask of UD11 field.
	FICR_NFC_TAGHEADER2_UD11_Msk = 0xff000000

	// NFC.TAGHEADER3: Default header for NFC tag. Software can read these values to populate NFCID1_3RD_LAST, NFCID1_2ND_LAST, and NFCID1_LAST.
	// Position of UD12 field.
	FICR_NFC_TAGHEADER3_UD12_Pos = 0x0
	// Bit mask of UD12 field.
	FICR_NFC_TAGHEADER3_UD12_Msk = 0xff
	// Position of UD13 field.
	FICR_NFC_TAGHEADER3_UD13_Pos = 0x8
	// Bit mask of UD13 field.
	FICR_NFC_TAGHEADER3_UD13_Msk = 0xff00
	// Position of UD14 field.
	FICR_NFC_TAGHEADER3_UD14_Pos = 0x10
	// Bit mask of UD14 field.
	FICR_NFC_TAGHEADER3_UD14_Msk = 0xff0000
	// Position of UD15 field.
	FICR_NFC_TAGHEADER3_UD15_Pos = 0x18
	// Bit mask of UD15 field.
	FICR_NFC_TAGHEADER3_UD15_Msk = 0xff000000

	// TRNG90B.BYTES: Amount of bytes for the required entropy bits
	// Position of BYTES field.
	FICR_TRNG90B_BYTES_BYTES_Pos = 0x0
	// Bit mask of BYTES field.
	FICR_TRNG90B_BYTES_BYTES_Msk = 0xffffffff

	// TRNG90B.RCCUTOFF: Repetition counter cutoff
	// Position of RCCUTOFF field.
	FICR_TRNG90B_RCCUTOFF_RCCUTOFF_Pos = 0x0
	// Bit mask of RCCUTOFF field.
	FICR_TRNG90B_RCCUTOFF_RCCUTOFF_Msk = 0xffffffff

	// TRNG90B.APCUTOFF: Adaptive proportion cutoff
	// Position of APCUTOFF field.
	FICR_TRNG90B_APCUTOFF_APCUTOFF_Pos = 0x0
	// Bit mask of APCUTOFF field.
	FICR_TRNG90B_APCUTOFF_APCUTOFF_Msk = 0xffffffff

	// TRNG90B.STARTUP: Amount of bytes for the startup tests
	// Position of STARTUP field.
	FICR_TRNG90B_STARTUP_STARTUP_Pos = 0x0
	// Bit mask of STARTUP field.
	FICR_TRNG90B_STARTUP_STARTUP_Msk = 0xffffffff

	// TRNG90B.ROSC1: Sample count for ring oscillator 1
	// Position of ROSC1 field.
	FICR_TRNG90B_ROSC1_ROSC1_Pos = 0x0
	// Bit mask of ROSC1 field.
	FICR_TRNG90B_ROSC1_ROSC1_Msk = 0xffffffff

	// TRNG90B.ROSC2: Sample count for ring oscillator 2
	// Position of ROSC2 field.
	FICR_TRNG90B_ROSC2_ROSC2_Pos = 0x0
	// Bit mask of ROSC2 field.
	FICR_TRNG90B_ROSC2_ROSC2_Msk = 0xffffffff

	// TRNG90B.ROSC3: Sample count for ring oscillator 3
	// Position of ROSC3 field.
	FICR_TRNG90B_ROSC3_ROSC3_Pos = 0x0
	// Bit mask of ROSC3 field.
	FICR_TRNG90B_ROSC3_ROSC3_Msk = 0xffffffff

	// TRNG90B.ROSC4: Sample count for ring oscillator 4
	// Position of ROSC4 field.
	FICR_TRNG90B_ROSC4_ROSC4_Pos = 0x0
	// Bit mask of ROSC4 field.
	FICR_TRNG90B_ROSC4_ROSC4_Msk = 0xffffffff
)

// Bitfields for UICR: User information configuration registers
const (
	// NRFFW: Description collection: Reserved for Nordic firmware design
	// Position of NRFFW field.
	UICR_NRFFW_NRFFW_Pos = 0x0
	// Bit mask of NRFFW field.
	UICR_NRFFW_NRFFW_Msk = 0xffffffff

	// NRFHW: Description collection: Reserved for Nordic hardware design
	// Position of NRFHW field.
	UICR_NRFHW_NRFHW_Pos = 0x0
	// Bit mask of NRFHW field.
	UICR_NRFHW_NRFHW_Msk = 0xffffffff

	// CUSTOMER: Description collection: Reserved for customer
	// Position of CUSTOMER field.
	UICR_CUSTOMER_CUSTOMER_Pos = 0x0
	// Bit mask of CUSTOMER field.
	UICR_CUSTOMER_CUSTOMER_Msk = 0xffffffff

	// PSELRESET: Description collection: Mapping of the nRESET function (see POWER chapter for details)
	// Position of PIN field.
	UICR_PSELRESET_PIN_Pos = 0x0
	// Bit mask of PIN field.
	UICR_PSELRESET_PIN_Msk = 0x1f
	// Position of PORT field.
	UICR_PSELRESET_PORT_Pos = 0x5
	// Bit mask of PORT field.
	UICR_PSELRESET_PORT_Msk = 0x20
	// Bit PORT.
	UICR_PSELRESET_PORT = 0x20
	// Position of CONNECT field.
	UICR_PSELRESET_CONNECT_Pos = 0x1f
	// Bit mask of CONNECT field.
	UICR_PSELRESET_CONNECT_Msk = 0x80000000
	// Bit CONNECT.
	UICR_PSELRESET_CONNECT = 0x80000000
	// Disconnect
	UICR_PSELRESET_CONNECT_Disconnected = 0x1
	// Connect
	UICR_PSELRESET_CONNECT_Connected = 0x0

	// APPROTECT: Access port protection
	// Position of PALL field.
	UICR_APPROTECT_PALL_Pos = 0x0
	// Bit mask of PALL field.
	UICR_APPROTECT_PALL_Msk = 0xff
	// Disable
	UICR_APPROTECT_PALL_Disabled = 0xff
	// Enable
	UICR_APPROTECT_PALL_Enabled = 0x0

	// NFCPINS: Setting of pins dedicated to NFC functionality: NFC antenna or GPIO
	// Position of PROTECT field.
	UICR_NFCPINS_PROTECT_Pos = 0x0
	// Bit mask of PROTECT field.
	UICR_NFCPINS_PROTECT_Msk = 0x1
	// Bit PROTECT.
	UICR_NFCPINS_PROTECT = 0x1
	// Operation as GPIO pins. Same protection as normal GPIO pins
	UICR_NFCPINS_PROTECT_Disabled = 0x0
	// Operation as NFC antenna pins. Configures the protection for NFC operation
	UICR_NFCPINS_PROTECT_NFC = 0x1

	// DEBUGCTRL: Processor debug control
	// Position of CPUNIDEN field.
	UICR_DEBUGCTRL_CPUNIDEN_Pos = 0x0
	// Bit mask of CPUNIDEN field.
	UICR_DEBUGCTRL_CPUNIDEN_Msk = 0xff
	// Enable CPU ITM and ETM functionality (default behavior)
	UICR_DEBUGCTRL_CPUNIDEN_Enabled = 0xff
	// Disable CPU ITM and ETM functionality
	UICR_DEBUGCTRL_CPUNIDEN_Disabled = 0x0
	// Position of CPUFPBEN field.
	UICR_DEBUGCTRL_CPUFPBEN_Pos = 0x8
	// Bit mask of CPUFPBEN field.
	UICR_DEBUGCTRL_CPUFPBEN_Msk = 0xff00
	// Enable CPU FPB unit (default behavior)
	UICR_DEBUGCTRL_CPUFPBEN_Enabled = 0xff
	// Disable CPU FPB unit. Writes into the FPB registers will be ignored.
	UICR_DEBUGCTRL_CPUFPBEN_Disabled = 0x0

	// REGOUT0: GPIO reference voltage / external output supply voltage in high voltage mode
	// Position of VOUT field.
	UICR_REGOUT0_VOUT_Pos = 0x0
	// Bit mask of VOUT field.
	UICR_REGOUT0_VOUT_Msk = 0x7
	// 1.8 V
	UICR_REGOUT0_VOUT_1V8 = 0x0
	// 2.1 V
	UICR_REGOUT0_VOUT_2V1 = 0x1
	// 2.4 V
	UICR_REGOUT0_VOUT_2V4 = 0x2
	// 2.7 V
	UICR_REGOUT0_VOUT_2V7 = 0x3
	// 3.0 V
	UICR_REGOUT0_VOUT_3V0 = 0x4
	// 3.3 V
	UICR_REGOUT0_VOUT_3V3 = 0x5
	// Default voltage: 1.8 V
	UICR_REGOUT0_VOUT_DEFAULT = 0x7
)

// Bitfields for CLOCK: Clock control
const (
	// TASKS_HFCLKSTART: Start HFXO crystal oscillator
	// Position of TASKS_HFCLKSTART field.
	CLOCK_TASKS_HFCLKSTART_TASKS_HFCLKSTART_Pos = 0x0
	// Bit mask of TASKS_HFCLKSTART field.
	CLOCK_TASKS_HFCLKSTART_TASKS_HFCLKSTART_Msk = 0x1
	// Bit TASKS_HFCLKSTART.
	CLOCK_TASKS_HFCLKSTART_TASKS_HFCLKSTART = 0x1
	// Trigger task
	CLOCK_TASKS_HFCLKSTART_TASKS_HFCLKSTART_Trigger = 0x1

	// TASKS_HFCLKSTOP: Stop HFXO crystal oscillator
	// Position of TASKS_HFCLKSTOP field.
	CLOCK_TASKS_HFCLKSTOP_TASKS_HFCLKSTOP_Pos = 0x0
	// Bit mask of TASKS_HFCLKSTOP field.
	CLOCK_TASKS_HFCLKSTOP_TASKS_HFCLKSTOP_Msk = 0x1
	// Bit TASKS_HFCLKSTOP.
	CLOCK_TASKS_HFCLKSTOP_TASKS_HFCLKSTOP = 0x1
	// Trigger task
	CLOCK_TASKS_HFCLKSTOP_TASKS_HFCLKSTOP_Trigger = 0x1

	// TASKS_LFCLKSTART: Start LFCLK
	// Position of TASKS_LFCLKSTART field.
	CLOCK_TASKS_LFCLKSTART_TASKS_LFCLKSTART_Pos = 0x0
	// Bit mask of TASKS_LFCLKSTART field.
	CLOCK_TASKS_LFCLKSTART_TASKS_LFCLKSTART_Msk = 0x1
	// Bit TASKS_LFCLKSTART.
	CLOCK_TASKS_LFCLKSTART_TASKS_LFCLKSTART = 0x1
	// Trigger task
	CLOCK_TASKS_LFCLKSTART_TASKS_LFCLKSTART_Trigger = 0x1

	// TASKS_LFCLKSTOP: Stop LFCLK
	// Position of TASKS_LFCLKSTOP field.
	CLOCK_TASKS_LFCLKSTOP_TASKS_LFCLKSTOP_Pos = 0x0
	// Bit mask of TASKS_LFCLKSTOP field.
	CLOCK_TASKS_LFCLKSTOP_TASKS_LFCLKSTOP_Msk = 0x1
	// Bit TASKS_LFCLKSTOP.
	CLOCK_TASKS_LFCLKSTOP_TASKS_LFCLKSTOP = 0x1
	// Trigger task
	CLOCK_TASKS_LFCLKSTOP_TASKS_LFCLKSTOP_Trigger = 0x1

	// TASKS_CAL: Start calibration of LFRC
	// Position of TASKS_CAL field.
	CLOCK_TASKS_CAL_TASKS_CAL_Pos = 0x0
	// Bit mask of TASKS_CAL field.
	CLOCK_TASKS_CAL_TASKS_CAL_Msk = 0x1
	// Bit TASKS_CAL.
	CLOCK_TASKS_CAL_TASKS_CAL = 0x1
	// Trigger task
	CLOCK_TASKS_CAL_TASKS_CAL_Trigger = 0x1

	// TASKS_CTSTART: Start calibration timer
	// Position of TASKS_CTSTART field.
	CLOCK_TASKS_CTSTART_TASKS_CTSTART_Pos = 0x0
	// Bit mask of TASKS_CTSTART field.
	CLOCK_TASKS_CTSTART_TASKS_CTSTART_Msk = 0x1
	// Bit TASKS_CTSTART.
	CLOCK_TASKS_CTSTART_TASKS_CTSTART = 0x1
	// Trigger task
	CLOCK_TASKS_CTSTART_TASKS_CTSTART_Trigger = 0x1

	// TASKS_CTSTOP: Stop calibration timer
	// Position of TASKS_CTSTOP field.
	CLOCK_TASKS_CTSTOP_TASKS_CTSTOP_Pos = 0x0
	// Bit mask of TASKS_CTSTOP field.
	CLOCK_TASKS_CTSTOP_TASKS_CTSTOP_Msk = 0x1
	// Bit TASKS_CTSTOP.
	CLOCK_TASKS_CTSTOP_TASKS_CTSTOP = 0x1
	// Trigger task
	CLOCK_TASKS_CTSTOP_TASKS_CTSTOP_Trigger = 0x1

	// EVENTS_HFCLKSTARTED: HFXO crystal oscillator started
	// Position of EVENTS_HFCLKSTARTED field.
	CLOCK_EVENTS_HFCLKSTARTED_EVENTS_HFCLKSTARTED_Pos = 0x0
	// Bit mask of EVENTS_HFCLKSTARTED field.
	CLOCK_EVENTS_HFCLKSTARTED_EVENTS_HFCLKSTARTED_Msk = 0x1
	// Bit EVENTS_HFCLKSTARTED.
	CLOCK_EVENTS_HFCLKSTARTED_EVENTS_HFCLKSTARTED = 0x1
	// Event not generated
	CLOCK_EVENTS_HFCLKSTARTED_EVENTS_HFCLKSTARTED_NotGenerated = 0x0
	// Event generated
	CLOCK_EVENTS_HFCLKSTARTED_EVENTS_HFCLKSTARTED_Generated = 0x1

	// EVENTS_LFCLKSTARTED: LFCLK started
	// Position of EVENTS_LFCLKSTARTED field.
	CLOCK_EVENTS_LFCLKSTARTED_EVENTS_LFCLKSTARTED_Pos = 0x0
	// Bit mask of EVENTS_LFCLKSTARTED field.
	CLOCK_EVENTS_LFCLKSTARTED_EVENTS_LFCLKSTARTED_Msk = 0x1
	// Bit EVENTS_LFCLKSTARTED.
	CLOCK_EVENTS_LFCLKSTARTED_EVENTS_LFCLKSTARTED = 0x1
	// Event not generated
	CLOCK_EVENTS_LFCLKSTARTED_EVENTS_LFCLKSTARTED_NotGenerated = 0x0
	// Event generated
	CLOCK_EVENTS_LFCLKSTARTED_EVENTS_LFCLKSTARTED_Generated = 0x1

	// EVENTS_DONE: Calibration of LFRC completed
	// Position of EVENTS_DONE field.
	CLOCK_EVENTS_DONE_EVENTS_DONE_Pos = 0x0
	// Bit mask of EVENTS_DONE field.
	CLOCK_EVENTS_DONE_EVENTS_DONE_Msk = 0x1
	// Bit EVENTS_DONE.
	CLOCK_EVENTS_DONE_EVENTS_DONE = 0x1
	// Event not generated
	CLOCK_EVENTS_DONE_EVENTS_DONE_NotGenerated = 0x0
	// Event generated
	CLOCK_EVENTS_DONE_EVENTS_DONE_Generated = 0x1

	// EVENTS_CTTO: Calibration timer timeout
	// Position of EVENTS_CTTO field.
	CLOCK_EVENTS_CTTO_EVENTS_CTTO_Pos = 0x0
	// Bit mask of EVENTS_CTTO field.
	CLOCK_EVENTS_CTTO_EVENTS_CTTO_Msk = 0x1
	// Bit EVENTS_CTTO.
	CLOCK_EVENTS_CTTO_EVENTS_CTTO = 0x1
	// Event not generated
	CLOCK_EVENTS_CTTO_EVENTS_CTTO_NotGenerated = 0x0
	// Event generated
	CLOCK_EVENTS_CTTO_EVENTS_CTTO_Generated = 0x1

	// EVENTS_CTSTARTED: Calibration timer has been started and is ready to process new tasks
	// Position of EVENTS_CTSTARTED field.
	CLOCK_EVENTS_CTSTARTED_EVENTS_CTSTARTED_Pos = 0x0
	// Bit mask of EVENTS_CTSTARTED field.
	CLOCK_EVENTS_CTSTARTED_EVENTS_CTSTARTED_Msk = 0x1
	// Bit EVENTS_CTSTARTED.
	CLOCK_EVENTS_CTSTARTED_EVENTS_CTSTARTED = 0x1
	// Event not generated
	CLOCK_EVENTS_CTSTARTED_EVENTS_CTSTARTED_NotGenerated = 0x0
	// Event generated
	CLOCK_EVENTS_CTSTARTED_EVENTS_CTSTARTED_Generated = 0x1

	// EVENTS_CTSTOPPED: Calibration timer has been stopped and is ready to process new tasks
	// Position of EVENTS_CTSTOPPED field.
	CLOCK_EVENTS_CTSTOPPED_EVENTS_CTSTOPPED_Pos = 0x0
	// Bit mask of EVENTS_CTSTOPPED field.
	CLOCK_EVENTS_CTSTOPPED_EVENTS_CTSTOPPED_Msk = 0x1
	// Bit EVENTS_CTSTOPPED.
	CLOCK_EVENTS_CTSTOPPED_EVENTS_CTSTOPPED = 0x1
	// Event not generated
	CLOCK_EVENTS_CTSTOPPED_EVENTS_CTSTOPPED_NotGenerated = 0x0
	// Event generated
	CLOCK_EVENTS_CTSTOPPED_EVENTS_CTSTOPPED_Generated = 0x1

	// INTENSET: Enable interrupt
	// Position of HFCLKSTARTED field.
	CLOCK_INTENSET_HFCLKSTARTED_Pos = 0x0
	// Bit mask of HFCLKSTARTED field.
	CLOCK_INTENSET_HFCLKSTARTED_Msk = 0x1
	// Bit HFCLKSTARTED.
	CLOCK_INTENSET_HFCLKSTARTED = 0x1
	// Read: Disabled
	CLOCK_INTENSET_HFCLKSTARTED_Disabled = 0x0
	// Read: Enabled
	CLOCK_INTENSET_HFCLKSTARTED_Enabled = 0x1
	// Enable
	CLOCK_INTENSET_HFCLKSTARTED_Set = 0x1
	// Position of LFCLKSTARTED field.
	CLOCK_INTENSET_LFCLKSTARTED_Pos = 0x1
	// Bit mask of LFCLKSTARTED field.
	CLOCK_INTENSET_LFCLKSTARTED_Msk = 0x2
	// Bit LFCLKSTARTED.
	CLOCK_INTENSET_LFCLKSTARTED = 0x2
	// Read: Disabled
	CLOCK_INTENSET_LFCLKSTARTED_Disabled = 0x0
	// Read: Enabled
	CLOCK_INTENSET_LFCLKSTARTED_Enabled = 0x1
	// Enable
	CLOCK_INTENSET_LFCLKSTARTED_Set = 0x1
	// Position of DONE field.
	CLOCK_INTENSET_DONE_Pos = 0x3
	// Bit mask of DONE field.
	CLOCK_INTENSET_DONE_Msk = 0x8
	// Bit DONE.
	CLOCK_INTENSET_DONE = 0x8
	// Read: Disabled
	CLOCK_INTENSET_DONE_Disabled = 0x0
	// Read: Enabled
	CLOCK_INTENSET_DONE_Enabled = 0x1
	// Enable
	CLOCK_INTENSET_DONE_Set = 0x1
	// Position of CTTO field.
	CLOCK_INTENSET_CTTO_Pos = 0x4
	// Bit mask of CTTO field.
	CLOCK_INTENSET_CTTO_Msk = 0x10
	// Bit CTTO.
	CLOCK_INTENSET_CTTO = 0x10
	// Read: Disabled
	CLOCK_INTENSET_CTTO_Disabled = 0x0
	// Read: Enabled
	CLOCK_INTENSET_CTTO_Enabled = 0x1
	// Enable
	CLOCK_INTENSET_CTTO_Set = 0x1
	// Position of CTSTARTED field.
	CLOCK_INTENSET_CTSTARTED_Pos = 0xa
	// Bit mask of CTSTARTED field.
	CLOCK_INTENSET_CTSTARTED_Msk = 0x400
	// Bit CTSTARTED.
	CLOCK_INTENSET_CTSTARTED = 0x400
	// Read: Disabled
	CLOCK_INTENSET_CTSTARTED_Disabled = 0x0
	// Read: Enabled
	CLOCK_INTENSET_CTSTARTED_Enabled = 0x1
	// Enable
	CLOCK_INTENSET_CTSTARTED_Set = 0x1
	// Position of CTSTOPPED field.
	CLOCK_INTENSET_CTSTOPPED_Pos = 0xb
	// Bit mask of CTSTOPPED field.
	CLOCK_INTENSET_CTSTOPPED_Msk = 0x800
	// Bit CTSTOPPED.
	CLOCK_INTENSET_CTSTOPPED = 0x800
	// Read: Disabled
	CLOCK_INTENSET_CTSTOPPED_Disabled = 0x0
	// Read: Enabled
	CLOCK_INTENSET_CTSTOPPED_Enabled = 0x1
	// Enable
	CLOCK_INTENSET_CTSTOPPED_Set = 0x1

	// INTENCLR: Disable interrupt
	// Position of HFCLKSTARTED field.
	CLOCK_INTENCLR_HFCLKSTARTED_Pos = 0x0
	// Bit mask of HFCLKSTARTED field.
	CLOCK_INTENCLR_HFCLKSTARTED_Msk = 0x1
	// Bit HFCLKSTARTED.
	CLOCK_INTENCLR_HFCLKSTARTED = 0x1
	// Read: Disabled
	CLOCK_INTENCLR_HFCLKSTARTED_Disabled = 0x0
	// Read: Enabled
	CLOCK_INTENCLR_HFCLKSTARTED_Enabled = 0x1
	// Disable
	CLOCK_INTENCLR_HFCLKSTARTED_Clear = 0x1
	// Position of LFCLKSTARTED field.
	CLOCK_INTENCLR_LFCLKSTARTED_Pos = 0x1
	// Bit mask of LFCLKSTARTED field.
	CLOCK_INTENCLR_LFCLKSTARTED_Msk = 0x2
	// Bit LFCLKSTARTED.
	CLOCK_INTENCLR_LFCLKSTARTED = 0x2
	// Read: Disabled
	CLOCK_INTENCLR_LFCLKSTARTED_Disabled = 0x0
	// Read: Enabled
	CLOCK_INTENCLR_LFCLKSTARTED_Enabled = 0x1
	// Disable
	CLOCK_INTENCLR_LFCLKSTARTED_Clear = 0x1
	// Position of DONE field.
	CLOCK_INTENCLR_DONE_Pos = 0x3
	// Bit mask of DONE field.
	CLOCK_INTENCLR_DONE_Msk = 0x8
	// Bit DONE.
	CLOCK_INTENCLR_DONE = 0x8
	// Read: Disabled
	CLOCK_INTENCLR_DONE_Disabled = 0x0
	// Read: Enabled
	CLOCK_INTENCLR_DONE_Enabled = 0x1
	// Disable
	CLOCK_INTENCLR_DONE_Clear = 0x1
	// Position of CTTO field.
	CLOCK_INTENCLR_CTTO_Pos = 0x4
	// Bit mask of CTTO field.
	CLOCK_INTENCLR_CTTO_Msk = 0x10
	// Bit CTTO.
	CLOCK_INTENCLR_CTTO = 0x10
	// Read: Disabled
	CLOCK_INTENCLR_CTTO_Disabled = 0x0
	// Read: Enabled
	CLOCK_INTENCLR_CTTO_Enabled = 0x1
	// Disable
	CLOCK_INTENCLR_CTTO_Clear = 0x1
	// Position of CTSTARTED field.
	CLOCK_INTENCLR_CTSTARTED_Pos = 0xa
	// Bit mask of CTSTARTED field.
	CLOCK_INTENCLR_CTSTARTED_Msk = 0x400
	// Bit CTSTARTED.
	CLOCK_INTENCLR_CTSTARTED = 0x400
	// Read: Disabled
	CLOCK_INTENCLR_CTSTARTED_Disabled = 0x0
	// Read: Enabled
	CLOCK_INTENCLR_CTSTARTED_Enabled = 0x1
	// Disable
	CLOCK_INTENCLR_CTSTARTED_Clear = 0x1
	// Position of CTSTOPPED field.
	CLOCK_INTENCLR_CTSTOPPED_Pos = 0xb
	// Bit mask of CTSTOPPED field.
	CLOCK_INTENCLR_CTSTOPPED_Msk = 0x800
	// Bit CTSTOPPED.
	CLOCK_INTENCLR_CTSTOPPED = 0x800
	// Read: Disabled
	CLOCK_INTENCLR_CTSTOPPED_Disabled = 0x0
	// Read: Enabled
	CLOCK_INTENCLR_CTSTOPPED_Enabled = 0x1
	// Disable
	CLOCK_INTENCLR_CTSTOPPED_Clear = 0x1

	// HFCLKRUN: Status indicating that HFCLKSTART task has been triggered
	// Position of STATUS field.
	CLOCK_HFCLKRUN_STATUS_Pos = 0x0
	// Bit mask of STATUS field.
	CLOCK_HFCLKRUN_STATUS_Msk = 0x1
	// Bit STATUS.
	CLOCK_HFCLKRUN_STATUS = 0x1
	// Task not triggered
	CLOCK_HFCLKRUN_STATUS_NotTriggered = 0x0
	// Task triggered
	CLOCK_HFCLKRUN_STATUS_Triggered = 0x1

	// HFCLKSTAT: HFCLK status
	// Position of SRC field.
	CLOCK_HFCLKSTAT_SRC_Pos = 0x0
	// Bit mask of SRC field.
	CLOCK_HFCLKSTAT_SRC_Msk = 0x1
	// Bit SRC.
	CLOCK_HFCLKSTAT_SRC = 0x1
	// 64 MHz internal oscillator (HFINT)
	CLOCK_HFCLKSTAT_SRC_RC = 0x0
	// 64 MHz crystal oscillator (HFXO)
	CLOCK_HFCLKSTAT_SRC_Xtal = 0x1
	// Position of STATE field.
	CLOCK_HFCLKSTAT_STATE_Pos = 0x10
	// Bit mask of STATE field.
	CLOCK_HFCLKSTAT_STATE_Msk = 0x10000
	// Bit STATE.
	CLOCK_HFCLKSTAT_STATE = 0x10000
	// HFCLK not running
	CLOCK_HFCLKSTAT_STATE_NotRunning = 0x0
	// HFCLK running
	CLOCK_HFCLKSTAT_STATE_Running = 0x1

	// LFCLKRUN: Status indicating that LFCLKSTART task has been triggered
	// Position of STATUS field.
	CLOCK_LFCLKRUN_STATUS_Pos = 0x0
	// Bit mask of STATUS field.
	CLOCK_LFCLKRUN_STATUS_Msk = 0x1
	// Bit STATUS.
	CLOCK_LFCLKRUN_STATUS = 0x1
	// Task not triggered
	CLOCK_LFCLKRUN_STATUS_NotTriggered = 0x0
	// Task triggered
	CLOCK_LFCLKRUN_STATUS_Triggered = 0x1

	// LFCLKSTAT: LFCLK status
	// Position of SRC field.
	CLOCK_LFCLKSTAT_SRC_Pos = 0x0
	// Bit mask of SRC field.
	CLOCK_LFCLKSTAT_SRC_Msk = 0x3
	// 32.768 kHz RC oscillator (LFRC)
	CLOCK_LFCLKSTAT_SRC_RC = 0x0
	// 32.768 kHz crystal oscillator (LFXO)
	CLOCK_LFCLKSTAT_SRC_Xtal = 0x1
	// 32.768 kHz synthesized from HFCLK (LFSYNT)
	CLOCK_LFCLKSTAT_SRC_Synth = 0x2
	// Position of STATE field.
	CLOCK_LFCLKSTAT_STATE_Pos = 0x10
	// Bit mask of STATE field.
	CLOCK_LFCLKSTAT_STATE_Msk = 0x10000
	// Bit STATE.
	CLOCK_LFCLKSTAT_STATE = 0x10000
	// LFCLK not running
	CLOCK_LFCLKSTAT_STATE_NotRunning = 0x0
	// LFCLK running
	CLOCK_LFCLKSTAT_STATE_Running = 0x1

	// LFCLKSRCCOPY: Copy of LFCLKSRC register, set when LFCLKSTART task was triggered
	// Position of SRC field.
	CLOCK_LFCLKSRCCOPY_SRC_Pos = 0x0
	// Bit mask of SRC field.
	CLOCK_LFCLKSRCCOPY_SRC_Msk = 0x3
	// 32.768 kHz RC oscillator (LFRC)
	CLOCK_LFCLKSRCCOPY_SRC_RC = 0x0
	// 32.768 kHz crystal oscillator (LFXO)
	CLOCK_LFCLKSRCCOPY_SRC_Xtal = 0x1
	// 32.768 kHz synthesized from HFCLK (LFSYNT)
	CLOCK_LFCLKSRCCOPY_SRC_Synth = 0x2

	// LFCLKSRC: Clock source for the LFCLK
	// Position of SRC field.
	CLOCK_LFCLKSRC_SRC_Pos = 0x0
	// Bit mask of SRC field.
	CLOCK_LFCLKSRC_SRC_Msk = 0x3
	// 32.768 kHz RC oscillator (LFRC)
	CLOCK_LFCLKSRC_SRC_RC = 0x0
	// 32.768 kHz crystal oscillator (LFXO)
	CLOCK_LFCLKSRC_SRC_Xtal = 0x1
	// 32.768 kHz synthesized from HFCLK (LFSYNT)
	CLOCK_LFCLKSRC_SRC_Synth = 0x2
	// Position of BYPASS field.
	CLOCK_LFCLKSRC_BYPASS_Pos = 0x10
	// Bit mask of BYPASS field.
	CLOCK_LFCLKSRC_BYPASS_Msk = 0x10000
	// Bit BYPASS.
	CLOCK_LFCLKSRC_BYPASS = 0x10000
	// Disable (use with Xtal or low-swing external source)
	CLOCK_LFCLKSRC_BYPASS_Disabled = 0x0
	// Enable (use with rail-to-rail external source)
	CLOCK_LFCLKSRC_BYPASS_Enabled = 0x1
	// Position of EXTERNAL field.
	CLOCK_LFCLKSRC_EXTERNAL_Pos = 0x11
	// Bit mask of EXTERNAL field.
	CLOCK_LFCLKSRC_EXTERNAL_Msk = 0x20000
	// Bit EXTERNAL.
	CLOCK_LFCLKSRC_EXTERNAL = 0x20000
	// Disable external source (use with Xtal)
	CLOCK_LFCLKSRC_EXTERNAL_Disabled = 0x0
	// Enable use of external source instead of Xtal (SRC needs to be set to Xtal)
	CLOCK_LFCLKSRC_EXTERNAL_Enabled = 0x1

	// HFXODEBOUNCE: HFXO debounce time. The HFXO is started by triggering the TASKS_HFCLKSTART task.
	// Position of HFXODEBOUNCE field.
	CLOCK_HFXODEBOUNCE_HFXODEBOUNCE_Pos = 0x0
	// Bit mask of HFXODEBOUNCE field.
	CLOCK_HFXODEBOUNCE_HFXODEBOUNCE_Msk = 0xff
	// 256 us debounce time. Recommended for TSX-3225, FA-20H and FA-128 crystals.
	CLOCK_HFXODEBOUNCE_HFXODEBOUNCE_Db256us = 0x10
	// 1024 us debounce time. Recommended for NX1612AA and NX1210AB crystals.
	CLOCK_HFXODEBOUNCE_HFXODEBOUNCE_Db1024us = 0x40

	// CTIV: Calibration timer interval
	// Position of CTIV field.
	CLOCK_CTIV_CTIV_Pos = 0x0
	// Bit mask of CTIV field.
	CLOCK_CTIV_CTIV_Msk = 0x7f

	// TRACECONFIG: Clocking options for the trace port debug interface
	// Position of TRACEPORTSPEED field.
	CLOCK_TRACECONFIG_TRACEPORTSPEED_Pos = 0x0
	// Bit mask of TRACEPORTSPEED field.
	CLOCK_TRACECONFIG_TRACEPORTSPEED_Msk = 0x3
	// 32 MHz trace port clock (TRACECLK = 16 MHz)
	CLOCK_TRACECONFIG_TRACEPORTSPEED_32MHz = 0x0
	// 16 MHz trace port clock (TRACECLK = 8 MHz)
	CLOCK_TRACECONFIG_TRACEPORTSPEED_16MHz = 0x1
	// 8 MHz trace port clock (TRACECLK = 4 MHz)
	CLOCK_TRACECONFIG_TRACEPORTSPEED_8MHz = 0x2
	// 4 MHz trace port clock (TRACECLK = 2 MHz)
	CLOCK_TRACECONFIG_TRACEPORTSPEED_4MHz = 0x3
	// Position of TRACEMUX field.
	CLOCK_TRACECONFIG_TRACEMUX_Pos = 0x10
	// Bit mask of TRACEMUX field.
	CLOCK_TRACECONFIG_TRACEMUX_Msk = 0x30000
	// No trace signals routed to pins. All pins can be used as regular GPIOs.
	CLOCK_TRACECONFIG_TRACEMUX_GPIO = 0x0
	// SWO trace signal routed to pin. Remaining pins can be used as regular GPIOs.
	CLOCK_TRACECONFIG_TRACEMUX_Serial = 0x1
	// All trace signals (TRACECLK and TRACEDATA[n]) routed to pins.
	CLOCK_TRACECONFIG_TRACEMUX_Parallel = 0x2

	// LFRCMODE: LFRC mode configuration
	// Position of MODE field.
	CLOCK_LFRCMODE_MODE_Pos = 0x0
	// Bit mask of MODE field.
	CLOCK_LFRCMODE_MODE_Msk = 0x1
	// Bit MODE.
	CLOCK_LFRCMODE_MODE = 0x1
	// Normal mode
	CLOCK_LFRCMODE_MODE_Normal = 0x0
	// Ultra-low power mode (ULP)
	CLOCK_LFRCMODE_MODE_ULP = 0x1
	// Position of STATUS field.
	CLOCK_LFRCMODE_STATUS_Pos = 0x10
	// Bit mask of STATUS field.
	CLOCK_LFRCMODE_STATUS_Msk = 0x10000
	// Bit STATUS.
	CLOCK_LFRCMODE_STATUS = 0x10000
	// Normal mode
	CLOCK_LFRCMODE_STATUS_Normal = 0x0
	// Ultra-low power mode (ULP)
	CLOCK_LFRCMODE_STATUS_ULP = 0x1
)

// Bitfields for POWER: Power control
const (
	// TASKS_CONSTLAT: Enable Constant Latency mode
	// Position of TASKS_CONSTLAT field.
	POWER_TASKS_CONSTLAT_TASKS_CONSTLAT_Pos = 0x0
	// Bit mask of TASKS_CONSTLAT field.
	POWER_TASKS_CONSTLAT_TASKS_CONSTLAT_Msk = 0x1
	// Bit TASKS_CONSTLAT.
	POWER_TASKS_CONSTLAT_TASKS_CONSTLAT = 0x1
	// Trigger task
	POWER_TASKS_CONSTLAT_TASKS_CONSTLAT_Trigger = 0x1

	// TASKS_LOWPWR: Enable Low-power mode (variable latency)
	// Position of TASKS_LOWPWR field.
	POWER_TASKS_LOWPWR_TASKS_LOWPWR_Pos = 0x0
	// Bit mask of TASKS_LOWPWR field.
	POWER_TASKS_LOWPWR_TASKS_LOWPWR_Msk = 0x1
	// Bit TASKS_LOWPWR.
	POWER_TASKS_LOWPWR_TASKS_LOWPWR = 0x1
	// Trigger task
	POWER_TASKS_LOWPWR_TASKS_LOWPWR_Trigger = 0x1

	// EVENTS_POFWARN: Power failure warning
	// Position of EVENTS_POFWARN field.
	POWER_EVENTS_POFWARN_EVENTS_POFWARN_Pos = 0x0
	// Bit mask of EVENTS_POFWARN field.
	POWER_EVENTS_POFWARN_EVENTS_POFWARN_Msk = 0x1
	// Bit EVENTS_POFWARN.
	POWER_EVENTS_POFWARN_EVENTS_POFWARN = 0x1
	// Event not generated
	POWER_EVENTS_POFWARN_EVENTS_POFWARN_NotGenerated = 0x0
	// Event generated
	POWER_EVENTS_POFWARN_EVENTS_POFWARN_Generated = 0x1

	// EVENTS_SLEEPENTER: CPU entered WFI/WFE sleep
	// Position of EVENTS_SLEEPENTER field.
	POWER_EVENTS_SLEEPENTER_EVENTS_SLEEPENTER_Pos = 0x0
	// Bit mask of EVENTS_SLEEPENTER field.
	POWER_EVENTS_SLEEPENTER_EVENTS_SLEEPENTER_Msk = 0x1
	// Bit EVENTS_SLEEPENTER.
	POWER_EVENTS_SLEEPENTER_EVENTS_SLEEPENTER = 0x1
	// Event not generated
	POWER_EVENTS_SLEEPENTER_EVENTS_SLEEPENTER_NotGenerated = 0x0
	// Event generated
	POWER_EVENTS_SLEEPENTER_EVENTS_SLEEPENTER_Generated = 0x1

	// EVENTS_SLEEPEXIT: CPU exited WFI/WFE sleep
	// Position of EVENTS_SLEEPEXIT field.
	POWER_EVENTS_SLEEPEXIT_EVENTS_SLEEPEXIT_Pos = 0x0
	// Bit mask of EVENTS_SLEEPEXIT field.
	POWER_EVENTS_SLEEPEXIT_EVENTS_SLEEPEXIT_Msk = 0x1
	// Bit EVENTS_SLEEPEXIT.
	POWER_EVENTS_SLEEPEXIT_EVENTS_SLEEPEXIT = 0x1
	// Event not generated
	POWER_EVENTS_SLEEPEXIT_EVENTS_SLEEPEXIT_NotGenerated = 0x0
	// Event generated
	POWER_EVENTS_SLEEPEXIT_EVENTS_SLEEPEXIT_Generated = 0x1

	// EVENTS_USBDETECTED: Voltage supply detected on VBUS
	// Position of EVENTS_USBDETECTED field.
	POWER_EVENTS_USBDETECTED_EVENTS_USBDETECTED_Pos = 0x0
	// Bit mask of EVENTS_USBDETECTED field.
	POWER_EVENTS_USBDETECTED_EVENTS_USBDETECTED_Msk = 0x1
	// Bit EVENTS_USBDETECTED.
	POWER_EVENTS_USBDETECTED_EVENTS_USBDETECTED = 0x1
	// Event not generated
	POWER_EVENTS_USBDETECTED_EVENTS_USBDETECTED_NotGenerated = 0x0
	// Event generated
	POWER_EVENTS_USBDETECTED_EVENTS_USBDETECTED_Generated = 0x1

	// EVENTS_USBREMOVED: Voltage supply removed from VBUS
	// Position of EVENTS_USBREMOVED field.
	POWER_EVENTS_USBREMOVED_EVENTS_USBREMOVED_Pos = 0x0
	// Bit mask of EVENTS_USBREMOVED field.
	POWER_EVENTS_USBREMOVED_EVENTS_USBREMOVED_Msk = 0x1
	// Bit EVENTS_USBREMOVED.
	POWER_EVENTS_USBREMOVED_EVENTS_USBREMOVED = 0x1
	// Event not generated
	POWER_EVENTS_USBREMOVED_EVENTS_USBREMOVED_NotGenerated = 0x0
	// Event generated
	POWER_EVENTS_USBREMOVED_EVENTS_USBREMOVED_Generated = 0x1

	// EVENTS_USBPWRRDY: USB 3.3 V supply ready
	// Position of EVENTS_USBPWRRDY field.
	POWER_EVENTS_USBPWRRDY_EVENTS_USBPWRRDY_Pos = 0x0
	// Bit mask of EVENTS_USBPWRRDY field.
	POWER_EVENTS_USBPWRRDY_EVENTS_USBPWRRDY_Msk = 0x1
	// Bit EVENTS_USBPWRRDY.
	POWER_EVENTS_USBPWRRDY_EVENTS_USBPWRRDY = 0x1
	// Event not generated
	POWER_EVENTS_USBPWRRDY_EVENTS_USBPWRRDY_NotGenerated = 0x0
	// Event generated
	POWER_EVENTS_USBPWRRDY_EVENTS_USBPWRRDY_Generated = 0x1

	// INTENSET: Enable interrupt
	// Position of POFWARN field.
	POWER_INTENSET_POFWARN_Pos = 0x2
	// Bit mask of POFWARN field.
	POWER_INTENSET_POFWARN_Msk = 0x4
	// Bit POFWARN.
	POWER_INTENSET_POFWARN = 0x4
	// Read: Disabled
	POWER_INTENSET_POFWARN_Disabled = 0x0
	// Read: Enabled
	POWER_INTENSET_POFWARN_Enabled = 0x1
	// Enable
	POWER_INTENSET_POFWARN_Set = 0x1
	// Position of SLEEPENTER field.
	POWER_INTENSET_SLEEPENTER_Pos = 0x5
	// Bit mask of SLEEPENTER field.
	POWER_INTENSET_SLEEPENTER_Msk = 0x20
	// Bit SLEEPENTER.
	POWER_INTENSET_SLEEPENTER = 0x20
	// Read: Disabled
	POWER_INTENSET_SLEEPENTER_Disabled = 0x0
	// Read: Enabled
	POWER_INTENSET_SLEEPENTER_Enabled = 0x1
	// Enable
	POWER_INTENSET_SLEEPENTER_Set = 0x1
	// Position of SLEEPEXIT field.
	POWER_INTENSET_SLEEPEXIT_Pos = 0x6
	// Bit mask of SLEEPEXIT field.
	POWER_INTENSET_SLEEPEXIT_Msk = 0x40
	// Bit SLEEPEXIT.
	POWER_INTENSET_SLEEPEXIT = 0x40
	// Read: Disabled
	POWER_INTENSET_SLEEPEXIT_Disabled = 0x0
	// Read: Enabled
	POWER_INTENSET_SLEEPEXIT_Enabled = 0x1
	// Enable
	POWER_INTENSET_SLEEPEXIT_Set = 0x1
	// Position of USBDETECTED field.
	POWER_INTENSET_USBDETECTED_Pos = 0x7
	// Bit mask of USBDETECTED field.
	POWER_INTENSET_USBDETECTED_Msk = 0x80
	// Bit USBDETECTED.
	POWER_INTENSET_USBDETECTED = 0x80
	// Read: Disabled
	POWER_INTENSET_USBDETECTED_Disabled = 0x0
	// Read: Enabled
	POWER_INTENSET_USBDETECTED_Enabled = 0x1
	// Enable
	POWER_INTENSET_USBDETECTED_Set = 0x1
	// Position of USBREMOVED field.
	POWER_INTENSET_USBREMOVED_Pos = 0x8
	// Bit mask of USBREMOVED field.
	POWER_INTENSET_USBREMOVED_Msk = 0x100
	// Bit USBREMOVED.
	POWER_INTENSET_USBREMOVED = 0x100
	// Read: Disabled
	POWER_INTENSET_USBREMOVED_Disabled = 0x0
	// Read: Enabled
	POWER_INTENSET_USBREMOVED_Enabled = 0x1
	// Enable
	POWER_INTENSET_USBREMOVED_Set = 0x1
	// Position of USBPWRRDY field.
	POWER_INTENSET_USBPWRRDY_Pos = 0x9
	// Bit mask of USBPWRRDY field.
	POWER_INTENSET_USBPWRRDY_Msk = 0x200
	// Bit USBPWRRDY.
	POWER_INTENSET_USBPWRRDY = 0x200
	// Read: Disabled
	POWER_INTENSET_USBPWRRDY_Disabled = 0x0
	// Read: Enabled
	POWER_INTENSET_USBPWRRDY_Enabled = 0x1
	// Enable
	POWER_INTENSET_USBPWRRDY_Set = 0x1

	// INTENCLR: Disable interrupt
	// Position of POFWARN field.
	POWER_INTENCLR_POFWARN_Pos = 0x2
	// Bit mask of POFWARN field.
	POWER_INTENCLR_POFWARN_Msk = 0x4
	// Bit POFWARN.
	POWER_INTENCLR_POFWARN = 0x4
	// Read: Disabled
	POWER_INTENCLR_POFWARN_Disabled = 0x0
	// Read: Enabled
	POWER_INTENCLR_POFWARN_Enabled = 0x1
	// Disable
	POWER_INTENCLR_POFWARN_Clear = 0x1
	// Position of SLEEPENTER field.
	POWER_INTENCLR_SLEEPENTER_Pos = 0x5
	// Bit mask of SLEEPENTER field.
	POWER_INTENCLR_SLEEPENTER_Msk = 0x20
	// Bit SLEEPENTER.
	POWER_INTENCLR_SLEEPENTER = 0x20
	// Read: Disabled
	POWER_INTENCLR_SLEEPENTER_Disabled = 0x0
	// Read: Enabled
	POWER_INTENCLR_SLEEPENTER_Enabled = 0x1
	// Disable
	POWER_INTENCLR_SLEEPENTER_Clear = 0x1
	// Position of SLEEPEXIT field.
	POWER_INTENCLR_SLEEPEXIT_Pos = 0x6
	// Bit mask of SLEEPEXIT field.
	POWER_INTENCLR_SLEEPEXIT_Msk = 0x40
	// Bit SLEEPEXIT.
	POWER_INTENCLR_SLEEPEXIT = 0x40
	// Read: Disabled
	POWER_INTENCLR_SLEEPEXIT_Disabled = 0x0
	// Read: Enabled
	POWER_INTENCLR_SLEEPEXIT_Enabled = 0x1
	// Disable
	POWER_INTENCLR_SLEEPEXIT_Clear = 0x1
	// Position of USBDETECTED field.
	POWER_INTENCLR_USBDETECTED_Pos = 0x7
	// Bit mask of USBDETECTED field.
	POWER_INTENCLR_USBDETECTED_Msk = 0x80
	// Bit USBDETECTED.
	POWER_INTENCLR_USBDETECTED = 0x80
	// Read: Disabled
	POWER_INTENCLR_USBDETECTED_Disabled = 0x0
	// Read: Enabled
	POWER_INTENCLR_USBDETECTED_Enabled = 0x1
	// Disable
	POWER_INTENCLR_USBDETECTED_Clear = 0x1
	// Position of USBREMOVED field.
	POWER_INTENCLR_USBREMOVED_Pos = 0x8
	// Bit mask of USBREMOVED field.
	POWER_INTENCLR_USBREMOVED_Msk = 0x100
	// Bit USBREMOVED.
	POWER_INTENCLR_USBREMOVED = 0x100
	// Read: Disabled
	POWER_INTENCLR_USBREMOVED_Disabled = 0x0
	// Read: Enabled
	POWER_INTENCLR_USBREMOVED_Enabled = 0x1
	// Disable
	POWER_INTENCLR_USBREMOVED_Clear = 0x1
	// Position of USBPWRRDY field.
	POWER_INTENCLR_USBPWRRDY_Pos = 0x9
	// Bit mask of USBPWRRDY field.
	POWER_INTENCLR_USBPWRRDY_Msk = 0x200
	// Bit USBPWRRDY.
	POWER_INTENCLR_USBPWRRDY = 0x200
	// Read: Disabled
	POWER_INTENCLR_USBPWRRDY_Disabled = 0x0
	// Read: Enabled
	POWER_INTENCLR_USBPWRRDY_Enabled = 0x1
	// Disable
	POWER_INTENCLR_USBPWRRDY_Clear = 0x1

	// RESETREAS: Reset reason
	// Position of RESETPIN field.
	POWER_RESETREAS_RESETPIN_Pos = 0x0
	// Bit mask of RESETPIN field.
	POWER_RESETREAS_RESETPIN_Msk = 0x1
	// Bit RESETPIN.
	POWER_RESETREAS_RESETPIN = 0x1
	// Not detected
	POWER_RESETREAS_RESETPIN_NotDetected = 0x0
	// Detected
	POWER_RESETREAS_RESETPIN_Detected = 0x1
	// Position of DOG field.
	POWER_RESETREAS_DOG_Pos = 0x1
	// Bit mask of DOG field.
	POWER_RESETREAS_DOG_Msk = 0x2
	// Bit DOG.
	POWER_RESETREAS_DOG = 0x2
	// Not detected
	POWER_RESETREAS_DOG_NotDetected = 0x0
	// Detected
	POWER_RESETREAS_DOG_Detected = 0x1
	// Position of SREQ field.
	POWER_RESETREAS_SREQ_Pos = 0x2
	// Bit mask of SREQ field.
	POWER_RESETREAS_SREQ_Msk = 0x4
	// Bit SREQ.
	POWER_RESETREAS_SREQ = 0x4
	// Not detected
	POWER_RESETREAS_SREQ_NotDetected = 0x0
	// Detected
	POWER_RESETREAS_SREQ_Detected = 0x1
	// Position of LOCKUP field.
	POWER_RESETREAS_LOCKUP_Pos = 0x3
	// Bit mask of LOCKUP field.
	POWER_RESETREAS_LOCKUP_Msk = 0x8
	// Bit LOCKUP.
	POWER_RESETREAS_LOCKUP = 0x8
	// Not detected
	POWER_RESETREAS_LOCKUP_NotDetected = 0x0
	// Detected
	POWER_RESETREAS_LOCKUP_Detected = 0x1
	// Position of OFF field.
	POWER_RESETREAS_OFF_Pos = 0x10
	// Bit mask of OFF field.
	POWER_RESETREAS_OFF_Msk = 0x10000
	// Bit OFF.
	POWER_RESETREAS_OFF = 0x10000
	// Not detected
	POWER_RESETREAS_OFF_NotDetected = 0x0
	// Detected
	POWER_RESETREAS_OFF_Detected = 0x1
	// Position of LPCOMP field.
	POWER_RESETREAS_LPCOMP_Pos = 0x11
	// Bit mask of LPCOMP field.
	POWER_RESETREAS_LPCOMP_Msk = 0x20000
	// Bit LPCOMP.
	POWER_RESETREAS_LPCOMP = 0x20000
	// Not detected
	POWER_RESETREAS_LPCOMP_NotDetected = 0x0
	// Detected
	POWER_RESETREAS_LPCOMP_Detected = 0x1
	// Position of DIF field.
	POWER_RESETREAS_DIF_Pos = 0x12
	// Bit mask of DIF field.
	POWER_RESETREAS_DIF_Msk = 0x40000
	// Bit DIF.
	POWER_RESETREAS_DIF = 0x40000
	// Not detected
	POWER_RESETREAS_DIF_NotDetected = 0x0
	// Detected
	POWER_RESETREAS_DIF_Detected = 0x1
	// Position of NFC field.
	POWER_RESETREAS_NFC_Pos = 0x13
	// Bit mask of NFC field.
	POWER_RESETREAS_NFC_Msk = 0x80000
	// Bit NFC.
	POWER_RESETREAS_NFC = 0x80000
	// Not detected
	POWER_RESETREAS_NFC_NotDetected = 0x0
	// Detected
	POWER_RESETREAS_NFC_Detected = 0x1
	// Position of VBUS field.
	POWER_RESETREAS_VBUS_Pos = 0x14
	// Bit mask of VBUS field.
	POWER_RESETREAS_VBUS_Msk = 0x100000
	// Bit VBUS.
	POWER_RESETREAS_VBUS = 0x100000
	// Not detected
	POWER_RESETREAS_VBUS_NotDetected = 0x0
	// Detected
	POWER_RESETREAS_VBUS_Detected = 0x1

	// RAMSTATUS: Deprecated register - RAM status register
	// Position of RAMBLOCK0 field.
	POWER_RAMSTATUS_RAMBLOCK0_Pos = 0x0
	// Bit mask of RAMBLOCK0 field.
	POWER_RAMSTATUS_RAMBLOCK0_Msk = 0x1
	// Bit RAMBLOCK0.
	POWER_RAMSTATUS_RAMBLOCK0 = 0x1
	// Off
	POWER_RAMSTATUS_RAMBLOCK0_Off = 0x0
	// On
	POWER_RAMSTATUS_RAMBLOCK0_On = 0x1
	// Position of RAMBLOCK1 field.
	POWER_RAMSTATUS_RAMBLOCK1_Pos = 0x1
	// Bit mask of RAMBLOCK1 field.
	POWER_RAMSTATUS_RAMBLOCK1_Msk = 0x2
	// Bit RAMBLOCK1.
	POWER_RAMSTATUS_RAMBLOCK1 = 0x2
	// Off
	POWER_RAMSTATUS_RAMBLOCK1_Off = 0x0
	// On
	POWER_RAMSTATUS_RAMBLOCK1_On = 0x1
	// Position of RAMBLOCK2 field.
	POWER_RAMSTATUS_RAMBLOCK2_Pos = 0x2
	// Bit mask of RAMBLOCK2 field.
	POWER_RAMSTATUS_RAMBLOCK2_Msk = 0x4
	// Bit RAMBLOCK2.
	POWER_RAMSTATUS_RAMBLOCK2 = 0x4
	// Off
	POWER_RAMSTATUS_RAMBLOCK2_Off = 0x0
	// On
	POWER_RAMSTATUS_RAMBLOCK2_On = 0x1
	// Position of RAMBLOCK3 field.
	POWER_RAMSTATUS_RAMBLOCK3_Pos = 0x3
	// Bit mask of RAMBLOCK3 field.
	POWER_RAMSTATUS_RAMBLOCK3_Msk = 0x8
	// Bit RAMBLOCK3.
	POWER_RAMSTATUS_RAMBLOCK3 = 0x8
	// Off
	POWER_RAMSTATUS_RAMBLOCK3_Off = 0x0
	// On
	POWER_RAMSTATUS_RAMBLOCK3_On = 0x1

	// USBREGSTATUS: USB supply status
	// Position of VBUSDETECT field.
	POWER_USBREGSTATUS_VBUSDETECT_Pos = 0x0
	// Bit mask of VBUSDETECT field.
	POWER_USBREGSTATUS_VBUSDETECT_Msk = 0x1
	// Bit VBUSDETECT.
	POWER_USBREGSTATUS_VBUSDETECT = 0x1
	// VBUS voltage below valid threshold
	POWER_USBREGSTATUS_VBUSDETECT_NoVbus = 0x0
	// VBUS voltage above valid threshold
	POWER_USBREGSTATUS_VBUSDETECT_VbusPresent = 0x1
	// Position of OUTPUTRDY field.
	POWER_USBREGSTATUS_OUTPUTRDY_Pos = 0x1
	// Bit mask of OUTPUTRDY field.
	POWER_USBREGSTATUS_OUTPUTRDY_Msk = 0x2
	// Bit OUTPUTRDY.
	POWER_USBREGSTATUS_OUTPUTRDY = 0x2
	// USBREG output settling time not elapsed
	POWER_USBREGSTATUS_OUTPUTRDY_NotReady = 0x0
	// USBREG output settling time elapsed (same information as USBPWRRDY event)
	POWER_USBREGSTATUS_OUTPUTRDY_Ready = 0x1

	// SYSTEMOFF: System OFF register
	// Position of SYSTEMOFF field.
	POWER_SYSTEMOFF_SYSTEMOFF_Pos = 0x0
	// Bit mask of SYSTEMOFF field.
	POWER_SYSTEMOFF_SYSTEMOFF_Msk = 0x1
	// Bit SYSTEMOFF.
	POWER_SYSTEMOFF_SYSTEMOFF = 0x1
	// Enable System OFF mode
	POWER_SYSTEMOFF_SYSTEMOFF_Enter = 0x1

	// POFCON: Power-fail comparator configuration
	// Position of POF field.
	POWER_POFCON_POF_Pos = 0x0
	// Bit mask of POF field.
	POWER_POFCON_POF_Msk = 0x1
	// Bit POF.
	POWER_POFCON_POF = 0x1
	// Disable
	POWER_POFCON_POF_Disabled = 0x0
	// Enable
	POWER_POFCON_POF_Enabled = 0x1
	// Position of THRESHOLD field.
	POWER_POFCON_THRESHOLD_Pos = 0x1
	// Bit mask of THRESHOLD field.
	POWER_POFCON_THRESHOLD_Msk = 0x1e
	// Set threshold to 1.7 V
	POWER_POFCON_THRESHOLD_V17 = 0x4
	// Set threshold to 1.8 V
	POWER_POFCON_THRESHOLD_V18 = 0x5
	// Set threshold to 1.9 V
	POWER_POFCON_THRESHOLD_V19 = 0x6
	// Set threshold to 2.0 V
	POWER_POFCON_THRESHOLD_V20 = 0x7
	// Set threshold to 2.1 V
	POWER_POFCON_THRESHOLD_V21 = 0x8
	// Set threshold to 2.2 V
	POWER_POFCON_THRESHOLD_V22 = 0x9
	// Set threshold to 2.3 V
	POWER_POFCON_THRESHOLD_V23 = 0xa
	// Set threshold to 2.4 V
	POWER_POFCON_THRESHOLD_V24 = 0xb
	// Set threshold to 2.5 V
	POWER_POFCON_THRESHOLD_V25 = 0xc
	// Set threshold to 2.6 V
	POWER_POFCON_THRESHOLD_V26 = 0xd
	// Set threshold to 2.7 V
	POWER_POFCON_THRESHOLD_V27 = 0xe
	// Set threshold to 2.8 V
	POWER_POFCON_THRESHOLD_V28 = 0xf
	// Position of THRESHOLDVDDH field.
	POWER_POFCON_THRESHOLDVDDH_Pos = 0x8
	// Bit mask of THRESHOLDVDDH field.
	POWER_POFCON_THRESHOLDVDDH_Msk = 0xf00
	// Set threshold to 2.7 V
	POWER_POFCON_THRESHOLDVDDH_V27 = 0x0
	// Set threshold to 2.8 V
	POWER_POFCON_THRESHOLDVDDH_V28 = 0x1
	// Set threshold to 2.9 V
	POWER_POFCON_THRESHOLDVDDH_V29 = 0x2
	// Set threshold to 3.0 V
	POWER_POFCON_THRESHOLDVDDH_V30 = 0x3
	// Set threshold to 3.1 V
	POWER_POFCON_THRESHOLDVDDH_V31 = 0x4
	// Set threshold to 3.2 V
	POWER_POFCON_THRESHOLDVDDH_V32 = 0x5
	// Set threshold to 3.3 V
	POWER_POFCON_THRESHOLDVDDH_V33 = 0x6
	// Set threshold to 3.4 V
	POWER_POFCON_THRESHOLDVDDH_V34 = 0x7
	// Set threshold to 3.5 V
	POWER_POFCON_THRESHOLDVDDH_V35 = 0x8
	// Set threshold to 3.6 V
	POWER_POFCON_THRESHOLDVDDH_V36 = 0x9
	// Set threshold to 3.7 V
	POWER_POFCON_THRESHOLDVDDH_V37 = 0xa
	// Set threshold to 3.8 V
	POWER_POFCON_THRESHOLDVDDH_V38 = 0xb
	// Set threshold to 3.9 V
	POWER_POFCON_THRESHOLDVDDH_V39 = 0xc
	// Set threshold to 4.0 V
	POWER_POFCON_THRESHOLDVDDH_V40 = 0xd
	// Set threshold to 4.1 V
	POWER_POFCON_THRESHOLDVDDH_V41 = 0xe
	// Set threshold to 4.2 V
	POWER_POFCON_THRESHOLDVDDH_V42 = 0xf

	// GPREGRET: General purpose retention register
	// Position of GPREGRET field.
	POWER_GPREGRET_GPREGRET_Pos = 0x0
	// Bit mask of GPREGRET field.
	POWER_GPREGRET_GPREGRET_Msk = 0xff

	// GPREGRET2: General purpose retention register
	// Position of GPREGRET field.
	POWER_GPREGRET2_GPREGRET_Pos = 0x0
	// Bit mask of GPREGRET field.
	POWER_GPREGRET2_GPREGRET_Msk = 0xff

	// DCDCEN: Enable DC/DC converter for REG1 stage
	// Position of DCDCEN field.
	POWER_DCDCEN_DCDCEN_Pos = 0x0
	// Bit mask of DCDCEN field.
	POWER_DCDCEN_DCDCEN_Msk = 0x1
	// Bit DCDCEN.
	POWER_DCDCEN_DCDCEN = 0x1
	// Disable
	POWER_DCDCEN_DCDCEN_Disabled = 0x0
	// Enable
	POWER_DCDCEN_DCDCEN_Enabled = 0x1

	// DCDCEN0: Enable DC/DC converter for REG0 stage
	// Position of DCDCEN field.
	POWER_DCDCEN0_DCDCEN_Pos = 0x0
	// Bit mask of DCDCEN field.
	POWER_DCDCEN0_DCDCEN_Msk = 0x1
	// Bit DCDCEN.
	POWER_DCDCEN0_DCDCEN = 0x1
	// Disable
	POWER_DCDCEN0_DCDCEN_Disabled = 0x0
	// Enable
	POWER_DCDCEN0_DCDCEN_Enabled = 0x1

	// MAINREGSTATUS: Main supply status
	// Position of MAINREGSTATUS field.
	POWER_MAINREGSTATUS_MAINREGSTATUS_Pos = 0x0
	// Bit mask of MAINREGSTATUS field.
	POWER_MAINREGSTATUS_MAINREGSTATUS_Msk = 0x1
	// Bit MAINREGSTATUS.
	POWER_MAINREGSTATUS_MAINREGSTATUS = 0x1
	// Normal voltage mode. Voltage supplied on VDD.
	POWER_MAINREGSTATUS_MAINREGSTATUS_Normal = 0x0
	// High voltage mode. Voltage supplied on VDDH.
	POWER_MAINREGSTATUS_MAINREGSTATUS_High = 0x1

	// RAM.POWER: Description cluster: RAMn power control register
	// Position of S0POWER field.
	POWER_RAM_POWER_S0POWER_Pos = 0x0
	// Bit mask of S0POWER field.
	POWER_RAM_POWER_S0POWER_Msk = 0x1
	// Bit S0POWER.
	POWER_RAM_POWER_S0POWER = 0x1
	// Off
	POWER_RAM_POWER_S0POWER_Off = 0x0
	// On
	POWER_RAM_POWER_S0POWER_On = 0x1
	// Position of S1POWER field.
	POWER_RAM_POWER_S1POWER_Pos = 0x1
	// Bit mask of S1POWER field.
	POWER_RAM_POWER_S1POWER_Msk = 0x2
	// Bit S1POWER.
	POWER_RAM_POWER_S1POWER = 0x2
	// Off
	POWER_RAM_POWER_S1POWER_Off = 0x0
	// On
	POWER_RAM_POWER_S1POWER_On = 0x1
	// Position of S2POWER field.
	POWER_RAM_POWER_S2POWER_Pos = 0x2
	// Bit mask of S2POWER field.
	POWER_RAM_POWER_S2POWER_Msk = 0x4
	// Bit S2POWER.
	POWER_RAM_POWER_S2POWER = 0x4
	// Off
	POWER_RAM_POWER_S2POWER_Off = 0x0
	// On
	POWER_RAM_POWER_S2POWER_On = 0x1
	// Position of S3POWER field.
	POWER_RAM_POWER_S3POWER_Pos = 0x3
	// Bit mask of S3POWER field.
	POWER_RAM_POWER_S3POWER_Msk = 0x8
	// Bit S3POWER.
	POWER_RAM_POWER_S3POWER = 0x8
	// Off
	POWER_RAM_POWER_S3POWER_Off = 0x0
	// On
	POWER_RAM_POWER_S3POWER_On = 0x1
	// Position of S4POWER field.
	POWER_RAM_POWER_S4POWER_Pos = 0x4
	// Bit mask of S4POWER field.
	POWER_RAM_POWER_S4POWER_Msk = 0x10
	// Bit S4POWER.
	POWER_RAM_POWER_S4POWER = 0x10
	// Off
	POWER_RAM_POWER_S4POWER_Off = 0x0
	// On
	POWER_RAM_POWER_S4POWER_On = 0x1
	// Position of S5POWER field.
	POWER_RAM_POWER_S5POWER_Pos = 0x5
	// Bit mask of S5POWER field.
	POWER_RAM_POWER_S5POWER_Msk = 0x20
	// Bit S5POWER.
	POWER_RAM_POWER_S5POWER = 0x20
	// Off
	POWER_RAM_POWER_S5POWER_Off = 0x0
	// On
	POWER_RAM_POWER_S5POWER_On = 0x1
	// Position of S6POWER field.
	POWER_RAM_POWER_S6POWER_Pos = 0x6
	// Bit mask of S6POWER field.
	POWER_RAM_POWER_S6POWER_Msk = 0x40
	// Bit S6POWER.
	POWER_RAM_POWER_S6POWER = 0x40
	// Off
	POWER_RAM_POWER_S6POWER_Off = 0x0
	// On
	POWER_RAM_POWER_S6POWER_On = 0x1
	// Position of S7POWER field.
	POWER_RAM_POWER_S7POWER_Pos = 0x7
	// Bit mask of S7POWER field.
	POWER_RAM_POWER_S7POWER_Msk = 0x80
	// Bit S7POWER.
	POWER_RAM_POWER_S7POWER = 0x80
	// Off
	POWER_RAM_POWER_S7POWER_Off = 0x0
	// On
	POWER_RAM_POWER_S7POWER_On = 0x1
	// Position of S8POWER field.
	POWER_RAM_POWER_S8POWER_Pos = 0x8
	// Bit mask of S8POWER field.
	POWER_RAM_POWER_S8POWER_Msk = 0x100
	// Bit S8POWER.
	POWER_RAM_POWER_S8POWER = 0x100
	// Off
	POWER_RAM_POWER_S8POWER_Off = 0x0
	// On
	POWER_RAM_POWER_S8POWER_On = 0x1
	// Position of S9POWER field.
	POWER_RAM_POWER_S9POWER_Pos = 0x9
	// Bit mask of S9POWER field.
	POWER_RAM_POWER_S9POWER_Msk = 0x200
	// Bit S9POWER.
	POWER_RAM_POWER_S9POWER = 0x200
	// Off
	POWER_RAM_POWER_S9POWER_Off = 0x0
	// On
	POWER_RAM_POWER_S9POWER_On = 0x1
	// Position of S10POWER field.
	POWER_RAM_POWER_S10POWER_Pos = 0xa
	// Bit mask of S10POWER field.
	POWER_RAM_POWER_S10POWER_Msk = 0x400
	// Bit S10POWER.
	POWER_RAM_POWER_S10POWER = 0x400
	// Off
	POWER_RAM_POWER_S10POWER_Off = 0x0
	// On
	POWER_RAM_POWER_S10POWER_On = 0x1
	// Position of S11POWER field.
	POWER_RAM_POWER_S11POWER_Pos = 0xb
	// Bit mask of S11POWER field.
	POWER_RAM_POWER_S11POWER_Msk = 0x800
	// Bit S11POWER.
	POWER_RAM_POWER_S11POWER = 0x800
	// Off
	POWER_RAM_POWER_S11POWER_Off = 0x0
	// On
	POWER_RAM_POWER_S11POWER_On = 0x1
	// Position of S12POWER field.
	POWER_RAM_POWER_S12POWER_Pos = 0xc
	// Bit mask of S12POWER field.
	POWER_RAM_POWER_S12POWER_Msk = 0x1000
	// Bit S12POWER.
	POWER_RAM_POWER_S12POWER = 0x1000
	// Off
	POWER_RAM_POWER_S12POWER_Off = 0x0
	// On
	POWER_RAM_POWER_S12POWER_On = 0x1
	// Position of S13POWER field.
	POWER_RAM_POWER_S13POWER_Pos = 0xd
	// Bit mask of S13POWER field.
	POWER_RAM_POWER_S13POWER_Msk = 0x2000
	// Bit S13POWER.
	POWER_RAM_POWER_S13POWER = 0x2000
	// Off
	POWER_RAM_POWER_S13POWER_Off = 0x0
	// On
	POWER_RAM_POWER_S13POWER_On = 0x1
	// Position of S14POWER field.
	POWER_RAM_POWER_S14POWER_Pos = 0xe
	// Bit mask of S14POWER field.
	POWER_RAM_POWER_S14POWER_Msk = 0x4000
	// Bit S14POWER.
	POWER_RAM_POWER_S14POWER = 0x4000
	// Off
	POWER_RAM_POWER_S14POWER_Off = 0x0
	// On
	POWER_RAM_POWER_S14POWER_On = 0x1
	// Position of S15POWER field.
	POWER_RAM_POWER_S15POWER_Pos = 0xf
	// Bit mask of S15POWER field.
	POWER_RAM_POWER_S15POWER_Msk = 0x8000
	// Bit S15POWER.
	POWER_RAM_POWER_S15POWER = 0x8000
	// Off
	POWER_RAM_POWER_S15POWER_Off = 0x0
	// On
	POWER_RAM_POWER_S15POWER_On = 0x1
	// Position of S0RETENTION field.
	POWER_RAM_POWER_S0RETENTION_Pos = 0x10
	// Bit mask of S0RETENTION field.
	POWER_RAM_POWER_S0RETENTION_Msk = 0x10000
	// Bit S0RETENTION.
	POWER_RAM_POWER_S0RETENTION = 0x10000
	// Off
	POWER_RAM_POWER_S0RETENTION_Off = 0x0
	// On
	POWER_RAM_POWER_S0RETENTION_On = 0x1
	// Position of S1RETENTION field.
	POWER_RAM_POWER_S1RETENTION_Pos = 0x11
	// Bit mask of S1RETENTION field.
	POWER_RAM_POWER_S1RETENTION_Msk = 0x20000
	// Bit S1RETENTION.
	POWER_RAM_POWER_S1RETENTION = 0x20000
	// Off
	POWER_RAM_POWER_S1RETENTION_Off = 0x0
	// On
	POWER_RAM_POWER_S1RETENTION_On = 0x1
	// Position of S2RETENTION field.
	POWER_RAM_POWER_S2RETENTION_Pos = 0x12
	// Bit mask of S2RETENTION field.
	POWER_RAM_POWER_S2RETENTION_Msk = 0x40000
	// Bit S2RETENTION.
	POWER_RAM_POWER_S2RETENTION = 0x40000
	// Off
	POWER_RAM_POWER_S2RETENTION_Off = 0x0
	// On
	POWER_RAM_POWER_S2RETENTION_On = 0x1
	// Position of S3RETENTION field.
	POWER_RAM_POWER_S3RETENTION_Pos = 0x13
	// Bit mask of S3RETENTION field.
	POWER_RAM_POWER_S3RETENTION_Msk = 0x80000
	// Bit S3RETENTION.
	POWER_RAM_POWER_S3RETENTION = 0x80000
	// Off
	POWER_RAM_POWER_S3RETENTION_Off = 0x0
	// On
	POWER_RAM_POWER_S3RETENTION_On = 0x1
	// Position of S4RETENTION field.
	POWER_RAM_POWER_S4RETENTION_Pos = 0x14
	// Bit mask of S4RETENTION field.
	POWER_RAM_POWER_S4RETENTION_Msk = 0x100000
	// Bit S4RETENTION.
	POWER_RAM_POWER_S4RETENTION = 0x100000
	// Off
	POWER_RAM_POWER_S4RETENTION_Off = 0x0
	// On
	POWER_RAM_POWER_S4RETENTION_On = 0x1
	// Position of S5RETENTION field.
	POWER_RAM_POWER_S5RETENTION_Pos = 0x15
	// Bit mask of S5RETENTION field.
	POWER_RAM_POWER_S5RETENTION_Msk = 0x200000
	// Bit S5RETENTION.
	POWER_RAM_POWER_S5RETENTION = 0x200000
	// Off
	POWER_RAM_POWER_S5RETENTION_Off = 0x0
	// On
	POWER_RAM_POWER_S5RETENTION_On = 0x1
	// Position of S6RETENTION field.
	POWER_RAM_POWER_S6RETENTION_Pos = 0x16
	// Bit mask of S6RETENTION field.
	POWER_RAM_POWER_S6RETENTION_Msk = 0x400000
	// Bit S6RETENTION.
	POWER_RAM_POWER_S6RETENTION = 0x400000
	// Off
	POWER_RAM_POWER_S6RETENTION_Off = 0x0
	// On
	POWER_RAM_POWER_S6RETENTION_On = 0x1
	// Position of S7RETENTION field.
	POWER_RAM_POWER_S7RETENTION_Pos = 0x17
	// Bit mask of S7RETENTION field.
	POWER_RAM_POWER_S7RETENTION_Msk = 0x800000
	// Bit S7RETENTION.
	POWER_RAM_POWER_S7RETENTION = 0x800000
	// Off
	POWER_RAM_POWER_S7RETENTION_Off = 0x0
	// On
	POWER_RAM_POWER_S7RETENTION_On = 0x1
	// Position of S8RETENTION field.
	POWER_RAM_POWER_S8RETENTION_Pos = 0x18
	// Bit mask of S8RETENTION field.
	POWER_RAM_POWER_S8RETENTION_Msk = 0x1000000
	// Bit S8RETENTION.
	POWER_RAM_POWER_S8RETENTION = 0x1000000
	// Off
	POWER_RAM_POWER_S8RETENTION_Off = 0x0
	// On
	POWER_RAM_POWER_S8RETENTION_On = 0x1
	// Position of S9RETENTION field.
	POWER_RAM_POWER_S9RETENTION_Pos = 0x19
	// Bit mask of S9RETENTION field.
	POWER_RAM_POWER_S9RETENTION_Msk = 0x2000000
	// Bit S9RETENTION.
	POWER_RAM_POWER_S9RETENTION = 0x2000000
	// Off
	POWER_RAM_POWER_S9RETENTION_Off = 0x0
	// On
	POWER_RAM_POWER_S9RETENTION_On = 0x1
	// Position of S10RETENTION field.
	POWER_RAM_POWER_S10RETENTION_Pos = 0x1a
	// Bit mask of S10RETENTION field.
	POWER_RAM_POWER_S10RETENTION_Msk = 0x4000000
	// Bit S10RETENTION.
	POWER_RAM_POWER_S10RETENTION = 0x4000000
	// Off
	POWER_RAM_POWER_S10RETENTION_Off = 0x0
	// On
	POWER_RAM_POWER_S10RETENTION_On = 0x1
	// Position of S11RETENTION field.
	POWER_RAM_POWER_S11RETENTION_Pos = 0x1b
	// Bit mask of S11RETENTION field.
	POWER_RAM_POWER_S11RETENTION_Msk = 0x8000000
	// Bit S11RETENTION.
	POWER_RAM_POWER_S11RETENTION = 0x8000000
	// Off
	POWER_RAM_POWER_S11RETENTION_Off = 0x0
	// On
	POWER_RAM_POWER_S11RETENTION_On = 0x1
	// Position of S12RETENTION field.
	POWER_RAM_POWER_S12RETENTION_Pos = 0x1c
	// Bit mask of S12RETENTION field.
	POWER_RAM_POWER_S12RETENTION_Msk = 0x10000000
	// Bit S12RETENTION.
	POWER_RAM_POWER_S12RETENTION = 0x10000000
	// Off
	POWER_RAM_POWER_S12RETENTION_Off = 0x0
	// On
	POWER_RAM_POWER_S12RETENTION_On = 0x1
	// Position of S13RETENTION field.
	POWER_RAM_POWER_S13RETENTION_Pos = 0x1d
	// Bit mask of S13RETENTION field.
	POWER_RAM_POWER_S13RETENTION_Msk = 0x20000000
	// Bit S13RETENTION.
	POWER_RAM_POWER_S13RETENTION = 0x20000000
	// Off
	POWER_RAM_POWER_S13RETENTION_Off = 0x0
	// On
	POWER_RAM_POWER_S13RETENTION_On = 0x1
	// Position of S14RETENTION field.
	POWER_RAM_POWER_S14RETENTION_Pos = 0x1e
	// Bit mask of S14RETENTION field.
	POWER_RAM_POWER_S14RETENTION_Msk = 0x40000000
	// Bit S14RETENTION.
	POWER_RAM_POWER_S14RETENTION = 0x40000000
	// Off
	POWER_RAM_POWER_S14RETENTION_Off = 0x0
	// On
	POWER_RAM_POWER_S14RETENTION_On = 0x1
	// Position of S15RETENTION field.
	POWER_RAM_POWER_S15RETENTION_Pos = 0x1f
	// Bit mask of S15RETENTION field.
	POWER_RAM_POWER_S15RETENTION_Msk = 0x80000000
	// Bit S15RETENTION.
	POWER_RAM_POWER_S15RETENTION = 0x80000000
	// Off
	POWER_RAM_POWER_S15RETENTION_Off = 0x0
	// On
	POWER_RAM_POWER_S15RETENTION_On = 0x1

	// RAM.POWERSET: Description cluster: RAMn power control set register
	// Position of S0POWER field.
	POWER_RAM_POWERSET_S0POWER_Pos = 0x0
	// Bit mask of S0POWER field.
	POWER_RAM_POWERSET_S0POWER_Msk = 0x1
	// Bit S0POWER.
	POWER_RAM_POWERSET_S0POWER = 0x1
	// On
	POWER_RAM_POWERSET_S0POWER_On = 0x1
	// Position of S1POWER field.
	POWER_RAM_POWERSET_S1POWER_Pos = 0x1
	// Bit mask of S1POWER field.
	POWER_RAM_POWERSET_S1POWER_Msk = 0x2
	// Bit S1POWER.
	POWER_RAM_POWERSET_S1POWER = 0x2
	// On
	POWER_RAM_POWERSET_S1POWER_On = 0x1
	// Position of S2POWER field.
	POWER_RAM_POWERSET_S2POWER_Pos = 0x2
	// Bit mask of S2POWER field.
	POWER_RAM_POWERSET_S2POWER_Msk = 0x4
	// Bit S2POWER.
	POWER_RAM_POWERSET_S2POWER = 0x4
	// On
	POWER_RAM_POWERSET_S2POWER_On = 0x1
	// Position of S3POWER field.
	POWER_RAM_POWERSET_S3POWER_Pos = 0x3
	// Bit mask of S3POWER field.
	POWER_RAM_POWERSET_S3POWER_Msk = 0x8
	// Bit S3POWER.
	POWER_RAM_POWERSET_S3POWER = 0x8
	// On
	POWER_RAM_POWERSET_S3POWER_On = 0x1
	// Position of S4POWER field.
	POWER_RAM_POWERSET_S4POWER_Pos = 0x4
	// Bit mask of S4POWER field.
	POWER_RAM_POWERSET_S4POWER_Msk = 0x10
	// Bit S4POWER.
	POWER_RAM_POWERSET_S4POWER = 0x10
	// On
	POWER_RAM_POWERSET_S4POWER_On = 0x1
	// Position of S5POWER field.
	POWER_RAM_POWERSET_S5POWER_Pos = 0x5
	// Bit mask of S5POWER field.
	POWER_RAM_POWERSET_S5POWER_Msk = 0x20
	// Bit S5POWER.
	POWER_RAM_POWERSET_S5POWER = 0x20
	// On
	POWER_RAM_POWERSET_S5POWER_On = 0x1
	// Position of S6POWER field.
	POWER_RAM_POWERSET_S6POWER_Pos = 0x6
	// Bit mask of S6POWER field.
	POWER_RAM_POWERSET_S6POWER_Msk = 0x40
	// Bit S6POWER.
	POWER_RAM_POWERSET_S6POWER = 0x40
	// On
	POWER_RAM_POWERSET_S6POWER_On = 0x1
	// Position of S7POWER field.
	POWER_RAM_POWERSET_S7POWER_Pos = 0x7
	// Bit mask of S7POWER field.
	POWER_RAM_POWERSET_S7POWER_Msk = 0x80
	// Bit S7POWER.
	POWER_RAM_POWERSET_S7POWER = 0x80
	// On
	POWER_RAM_POWERSET_S7POWER_On = 0x1
	// Position of S8POWER field.
	POWER_RAM_POWERSET_S8POWER_Pos = 0x8
	// Bit mask of S8POWER field.
	POWER_RAM_POWERSET_S8POWER_Msk = 0x100
	// Bit S8POWER.
	POWER_RAM_POWERSET_S8POWER = 0x100
	// On
	POWER_RAM_POWERSET_S8POWER_On = 0x1
	// Position of S9POWER field.
	POWER_RAM_POWERSET_S9POWER_Pos = 0x9
	// Bit mask of S9POWER field.
	POWER_RAM_POWERSET_S9POWER_Msk = 0x200
	// Bit S9POWER.
	POWER_RAM_POWERSET_S9POWER = 0x200
	// On
	POWER_RAM_POWERSET_S9POWER_On = 0x1
	// Position of S10POWER field.
	POWER_RAM_POWERSET_S10POWER_Pos = 0xa
	// Bit mask of S10POWER field.
	POWER_RAM_POWERSET_S10POWER_Msk = 0x400
	// Bit S10POWER.
	POWER_RAM_POWERSET_S10POWER = 0x400
	// On
	POWER_RAM_POWERSET_S10POWER_On = 0x1
	// Position of S11POWER field.
	POWER_RAM_POWERSET_S11POWER_Pos = 0xb
	// Bit mask of S11POWER field.
	POWER_RAM_POWERSET_S11POWER_Msk = 0x800
	// Bit S11POWER.
	POWER_RAM_POWERSET_S11POWER = 0x800
	// On
	POWER_RAM_POWERSET_S11POWER_On = 0x1
	// Position of S12POWER field.
	POWER_RAM_POWERSET_S12POWER_Pos = 0xc
	// Bit mask of S12POWER field.
	POWER_RAM_POWERSET_S12POWER_Msk = 0x1000
	// Bit S12POWER.
	POWER_RAM_POWERSET_S12POWER = 0x1000
	// On
	POWER_RAM_POWERSET_S12POWER_On = 0x1
	// Position of S13POWER field.
	POWER_RAM_POWERSET_S13POWER_Pos = 0xd
	// Bit mask of S13POWER field.
	POWER_RAM_POWERSET_S13POWER_Msk = 0x2000
	// Bit S13POWER.
	POWER_RAM_POWERSET_S13POWER = 0x2000
	// On
	POWER_RAM_POWERSET_S13POWER_On = 0x1
	// Position of S14POWER field.
	POWER_RAM_POWERSET_S14POWER_Pos = 0xe
	// Bit mask of S14POWER field.
	POWER_RAM_POWERSET_S14POWER_Msk = 0x4000
	// Bit S14POWER.
	POWER_RAM_POWERSET_S14POWER = 0x4000
	// On
	POWER_RAM_POWERSET_S14POWER_On = 0x1
	// Position of S15POWER field.
	POWER_RAM_POWERSET_S15POWER_Pos = 0xf
	// Bit mask of S15POWER field.
	POWER_RAM_POWERSET_S15POWER_Msk = 0x8000
	// Bit S15POWER.
	POWER_RAM_POWERSET_S15POWER = 0x8000
	// On
	POWER_RAM_POWERSET_S15POWER_On = 0x1
	// Position of S0RETENTION field.
	POWER_RAM_POWERSET_S0RETENTION_Pos = 0x10
	// Bit mask of S0RETENTION field.
	POWER_RAM_POWERSET_S0RETENTION_Msk = 0x10000
	// Bit S0RETENTION.
	POWER_RAM_POWERSET_S0RETENTION = 0x10000
	// On
	POWER_RAM_POWERSET_S0RETENTION_On = 0x1
	// Position of S1RETENTION field.
	POWER_RAM_POWERSET_S1RETENTION_Pos = 0x11
	// Bit mask of S1RETENTION field.
	POWER_RAM_POWERSET_S1RETENTION_Msk = 0x20000
	// Bit S1RETENTION.
	POWER_RAM_POWERSET_S1RETENTION = 0x20000
	// On
	POWER_RAM_POWERSET_S1RETENTION_On = 0x1
	// Position of S2RETENTION field.
	POWER_RAM_POWERSET_S2RETENTION_Pos = 0x12
	// Bit mask of S2RETENTION field.
	POWER_RAM_POWERSET_S2RETENTION_Msk = 0x40000
	// Bit S2RETENTION.
	POWER_RAM_POWERSET_S2RETENTION = 0x40000
	// On
	POWER_RAM_POWERSET_S2RETENTION_On = 0x1
	// Position of S3RETENTION field.
	POWER_RAM_POWERSET_S3RETENTION_Pos = 0x13
	// Bit mask of S3RETENTION field.
	POWER_RAM_POWERSET_S3RETENTION_Msk = 0x80000
	// Bit S3RETENTION.
	POWER_RAM_POWERSET_S3RETENTION = 0x80000
	// On
	POWER_RAM_POWERSET_S3RETENTION_On = 0x1
	// Position of S4RETENTION field.
	POWER_RAM_POWERSET_S4RETENTION_Pos = 0x14
	// Bit mask of S4RETENTION field.
	POWER_RAM_POWERSET_S4RETENTION_Msk = 0x100000
	// Bit S4RETENTION.
	POWER_RAM_POWERSET_S4RETENTION = 0x100000
	// On
	POWER_RAM_POWERSET_S4RETENTION_On = 0x1
	// Position of S5RETENTION field.
	POWER_RAM_POWERSET_S5RETENTION_Pos = 0x15
	// Bit mask of S5RETENTION field.
	POWER_RAM_POWERSET_S5RETENTION_Msk = 0x200000
	// Bit S5RETENTION.
	POWER_RAM_POWERSET_S5RETENTION = 0x200000
	// On
	POWER_RAM_POWERSET_S5RETENTION_On = 0x1
	// Position of S6RETENTION field.
	POWER_RAM_POWERSET_S6RETENTION_Pos = 0x16
	// Bit mask of S6RETENTION field.
	POWER_RAM_POWERSET_S6RETENTION_Msk = 0x400000
	// Bit S6RETENTION.
	POWER_RAM_POWERSET_S6RETENTION = 0x400000
	// On
	POWER_RAM_POWERSET_S6RETENTION_On = 0x1
	// Position of S7RETENTION field.
	POWER_RAM_POWERSET_S7RETENTION_Pos = 0x17
	// Bit mask of S7RETENTION field.
	POWER_RAM_POWERSET_S7RETENTION_Msk = 0x800000
	// Bit S7RETENTION.
	POWER_RAM_POWERSET_S7RETENTION = 0x800000
	// On
	POWER_RAM_POWERSET_S7RETENTION_On = 0x1
	// Position of S8RETENTION field.
	POWER_RAM_POWERSET_S8RETENTION_Pos = 0x18
	// Bit mask of S8RETENTION field.
	POWER_RAM_POWERSET_S8RETENTION_Msk = 0x1000000
	// Bit S8RETENTION.
	POWER_RAM_POWERSET_S8RETENTION = 0x1000000
	// On
	POWER_RAM_POWERSET_S8RETENTION_On = 0x1
	// Position of S9RETENTION field.
	POWER_RAM_POWERSET_S9RETENTION_Pos = 0x19
	// Bit mask of S9RETENTION field.
	POWER_RAM_POWERSET_S9RETENTION_Msk = 0x2000000
	// Bit S9RETENTION.
	POWER_RAM_POWERSET_S9RETENTION = 0x2000000
	// On
	POWER_RAM_POWERSET_S9RETENTION_On = 0x1
	// Position of S10RETENTION field.
	POWER_RAM_POWERSET_S10RETENTION_Pos = 0x1a
	// Bit mask of S10RETENTION field.
	POWER_RAM_POWERSET_S10RETENTION_Msk = 0x4000000
	// Bit S10RETENTION.
	POWER_RAM_POWERSET_S10RETENTION = 0x4000000
	// On
	POWER_RAM_POWERSET_S10RETENTION_On = 0x1
	// Position of S11RETENTION field.
	POWER_RAM_POWERSET_S11RETENTION_Pos = 0x1b
	// Bit mask of S11RETENTION field.
	POWER_RAM_POWERSET_S11RETENTION_Msk = 0x8000000
	// Bit S11RETENTION.
	POWER_RAM_POWERSET_S11RETENTION = 0x8000000
	// On
	POWER_RAM_POWERSET_S11RETENTION_On = 0x1
	// Position of S12RETENTION field.
	POWER_RAM_POWERSET_S12RETENTION_Pos = 0x1c
	// Bit mask of S12RETENTION field.
	POWER_RAM_POWERSET_S12RETENTION_Msk = 0x10000000
	// Bit S12RETENTION.
	POWER_RAM_POWERSET_S12RETENTION = 0x10000000
	// On
	POWER_RAM_POWERSET_S12RETENTION_On = 0x1
	// Position of S13RETENTION field.
	POWER_RAM_POWERSET_S13RETENTION_Pos = 0x1d
	// Bit mask of S13RETENTION field.
	POWER_RAM_POWERSET_S13RETENTION_Msk = 0x20000000
	// Bit S13RETENTION.
	POWER_RAM_POWERSET_S13RETENTION = 0x20000000
	// On
	POWER_RAM_POWERSET_S13RETENTION_On = 0x1
	// Position of S14RETENTION field.
	POWER_RAM_POWERSET_S14RETENTION_Pos = 0x1e
	// Bit mask of S14RETENTION field.
	POWER_RAM_POWERSET_S14RETENTION_Msk = 0x40000000
	// Bit S14RETENTION.
	POWER_RAM_POWERSET_S14RETENTION = 0x40000000
	// On
	POWER_RAM_POWERSET_S14RETENTION_On = 0x1
	// Position of S15RETENTION field.
	POWER_RAM_POWERSET_S15RETENTION_Pos = 0x1f
	// Bit mask of S15RETENTION field.
	POWER_RAM_POWERSET_S15RETENTION_Msk = 0x80000000
	// Bit S15RETENTION.
	POWER_RAM_POWERSET_S15RETENTION = 0x80000000
	// On
	POWER_RAM_POWERSET_S15RETENTION_On = 0x1

	// RAM.POWERCLR: Description cluster: RAMn power control clear register
	// Position of S0POWER field.
	POWER_RAM_POWERCLR_S0POWER_Pos = 0x0
	// Bit mask of S0POWER field.
	POWER_RAM_POWERCLR_S0POWER_Msk = 0x1
	// Bit S0POWER.
	POWER_RAM_POWERCLR_S0POWER = 0x1
	// Off
	POWER_RAM_POWERCLR_S0POWER_Off = 0x1
	// Position of S1POWER field.
	POWER_RAM_POWERCLR_S1POWER_Pos = 0x1
	// Bit mask of S1POWER field.
	POWER_RAM_POWERCLR_S1POWER_Msk = 0x2
	// Bit S1POWER.
	POWER_RAM_POWERCLR_S1POWER = 0x2
	// Off
	POWER_RAM_POWERCLR_S1POWER_Off = 0x1
	// Position of S2POWER field.
	POWER_RAM_POWERCLR_S2POWER_Pos = 0x2
	// Bit mask of S2POWER field.
	POWER_RAM_POWERCLR_S2POWER_Msk = 0x4
	// Bit S2POWER.
	POWER_RAM_POWERCLR_S2POWER = 0x4
	// Off
	POWER_RAM_POWERCLR_S2POWER_Off = 0x1
	// Position of S3POWER field.
	POWER_RAM_POWERCLR_S3POWER_Pos = 0x3
	// Bit mask of S3POWER field.
	POWER_RAM_POWERCLR_S3POWER_Msk = 0x8
	// Bit S3POWER.
	POWER_RAM_POWERCLR_S3POWER = 0x8
	// Off
	POWER_RAM_POWERCLR_S3POWER_Off = 0x1
	// Position of S4POWER field.
	POWER_RAM_POWERCLR_S4POWER_Pos = 0x4
	// Bit mask of S4POWER field.
	POWER_RAM_POWERCLR_S4POWER_Msk = 0x10
	// Bit S4POWER.
	POWER_RAM_POWERCLR_S4POWER = 0x10
	// Off
	POWER_RAM_POWERCLR_S4POWER_Off = 0x1
	// Position of S5POWER field.
	POWER_RAM_POWERCLR_S5POWER_Pos = 0x5
	// Bit mask of S5POWER field.
	POWER_RAM_POWERCLR_S5POWER_Msk = 0x20
	// Bit S5POWER.
	POWER_RAM_POWERCLR_S5POWER = 0x20
	// Off
	POWER_RAM_POWERCLR_S5POWER_Off = 0x1
	// Position of S6POWER field.
	POWER_RAM_POWERCLR_S6POWER_Pos = 0x6
	// Bit mask of S6POWER field.
	POWER_RAM_POWERCLR_S6POWER_Msk = 0x40
	// Bit S6POWER.
	POWER_RAM_POWERCLR_S6POWER = 0x40
	// Off
	POWER_RAM_POWERCLR_S6POWER_Off = 0x1
	// Position of S7POWER field.
	POWER_RAM_POWERCLR_S7POWER_Pos = 0x7
	// Bit mask of S7POWER field.
	POWER_RAM_POWERCLR_S7POWER_Msk = 0x80
	// Bit S7POWER.
	POWER_RAM_POWERCLR_S7POWER = 0x80
	// Off
	POWER_RAM_POWERCLR_S7POWER_Off = 0x1
	// Position of S8POWER field.
	POWER_RAM_POWERCLR_S8POWER_Pos = 0x8
	// Bit mask of S8POWER field.
	POWER_RAM_POWERCLR_S8POWER_Msk = 0x100
	// Bit S8POWER.
	POWER_RAM_POWERCLR_S8POWER = 0x100
	// Off
	POWER_RAM_POWERCLR_S8POWER_Off = 0x1
	// Position of S9POWER field.
	POWER_RAM_POWERCLR_S9POWER_Pos = 0x9
	// Bit mask of S9POWER field.
	POWER_RAM_POWERCLR_S9POWER_Msk = 0x200
	// Bit S9POWER.
	POWER_RAM_POWERCLR_S9POWER = 0x200
	// Off
	POWER_RAM_POWERCLR_S9POWER_Off = 0x1
	// Position of S10POWER field.
	POWER_RAM_POWERCLR_S10POWER_Pos = 0xa
	// Bit mask of S10POWER field.
	POWER_RAM_POWERCLR_S10POWER_Msk = 0x400
	// Bit S10POWER.
	POWER_RAM_POWERCLR_S10POWER = 0x400
	// Off
	POWER_RAM_POWERCLR_S10POWER_Off = 0x1
	// Position of S11POWER field.
	POWER_RAM_POWERCLR_S11POWER_Pos = 0xb
	// Bit mask of S11POWER field.
	POWER_RAM_POWERCLR_S11POWER_Msk = 0x800
	// Bit S11POWER.
	POWER_RAM_POWERCLR_S11POWER = 0x800
	// Off
	POWER_RAM_POWERCLR_S11POWER_Off = 0x1
	// Position of S12POWER field.
	POWER_RAM_POWERCLR_S12POWER_Pos = 0xc
	// Bit mask of S12POWER field.
	POWER_RAM_POWERCLR_S12POWER_Msk = 0x1000
	// Bit S12POWER.
	POWER_RAM_POWERCLR_S12POWER = 0x1000
	// Off
	POWER_RAM_POWERCLR_S12POWER_Off = 0x1
	// Position of S13POWER field.
	POWER_RAM_POWERCLR_S13POWER_Pos = 0xd
	// Bit mask of S13POWER field.
	POWER_RAM_POWERCLR_S13POWER_Msk = 0x2000
	// Bit S13POWER.
	POWER_RAM_POWERCLR_S13POWER = 0x2000
	// Off
	POWER_RAM_POWERCLR_S13POWER_Off = 0x1
	// Position of S14POWER field.
	POWER_RAM_POWERCLR_S14POWER_Pos = 0xe
	// Bit mask of S14POWER field.
	POWER_RAM_POWERCLR_S14POWER_Msk = 0x4000
	// Bit S14POWER.
	POWER_RAM_POWERCLR_S14POWER = 0x4000
	// Off
	POWER_RAM_POWERCLR_S14POWER_Off = 0x1
	// Position of S15POWER field.
	POWER_RAM_POWERCLR_S15POWER_Pos = 0xf
	// Bit mask of S15POWER field.
	POWER_RAM_POWERCLR_S15POWER_Msk = 0x8000
	// Bit S15POWER.
	POWER_RAM_POWERCLR_S15POWER = 0x8000
	// Off
	POWER_RAM_POWERCLR_S15POWER_Off = 0x1
	// Position of S0RETENTION field.
	POWER_RAM_POWERCLR_S0RETENTION_Pos = 0x10
	// Bit mask of S0RETENTION field.
	POWER_RAM_POWERCLR_S0RETENTION_Msk = 0x10000
	// Bit S0RETENTION.
	POWER_RAM_POWERCLR_S0RETENTION = 0x10000
	// Off
	POWER_RAM_POWERCLR_S0RETENTION_Off = 0x1
	// Position of S1RETENTION field.
	POWER_RAM_POWERCLR_S1RETENTION_Pos = 0x11
	// Bit mask of S1RETENTION field.
	POWER_RAM_POWERCLR_S1RETENTION_Msk = 0x20000
	// Bit S1RETENTION.
	POWER_RAM_POWERCLR_S1RETENTION = 0x20000
	// Off
	POWER_RAM_POWERCLR_S1RETENTION_Off = 0x1
	// Position of S2RETENTION field.
	POWER_RAM_POWERCLR_S2RETENTION_Pos = 0x12
	// Bit mask of S2RETENTION field.
	POWER_RAM_POWERCLR_S2RETENTION_Msk = 0x40000
	// Bit S2RETENTION.
	POWER_RAM_POWERCLR_S2RETENTION = 0x40000
	// Off
	POWER_RAM_POWERCLR_S2RETENTION_Off = 0x1
	// Position of S3RETENTION field.
	POWER_RAM_POWERCLR_S3RETENTION_Pos = 0x13
	// Bit mask of S3RETENTION field.
	POWER_RAM_POWERCLR_S3RETENTION_Msk = 0x80000
	// Bit S3RETENTION.
	POWER_RAM_POWERCLR_S3RETENTION = 0x80000
	// Off
	POWER_RAM_POWERCLR_S3RETENTION_Off = 0x1
	// Position of S4RETENTION field.
	POWER_RAM_POWERCLR_S4RETENTION_Pos = 0x14
	// Bit mask of S4RETENTION field.
	POWER_RAM_POWERCLR_S4RETENTION_Msk = 0x100000
	// Bit S4RETENTION.
	POWER_RAM_POWERCLR_S4RETENTION = 0x100000
	// Off
	POWER_RAM_POWERCLR_S4RETENTION_Off = 0x1
	// Position of S5RETENTION field.
	POWER_RAM_POWERCLR_S5RETENTION_Pos = 0x15
	// Bit mask of S5RETENTION field.
	POWER_RAM_POWERCLR_S5RETENTION_Msk = 0x200000
	// Bit S5RETENTION.
	POWER_RAM_POWERCLR_S5RETENTION = 0x200000
	// Off
	POWER_RAM_POWERCLR_S5RETENTION_Off = 0x1
	// Position of S6RETENTION field.
	POWER_RAM_POWERCLR_S6RETENTION_Pos = 0x16
	// Bit mask of S6RETENTION field.
	POWER_RAM_POWERCLR_S6RETENTION_Msk = 0x400000
	// Bit S6RETENTION.
	POWER_RAM_POWERCLR_S6RETENTION = 0x400000
	// Off
	POWER_RAM_POWERCLR_S6RETENTION_Off = 0x1
	// Position of S7RETENTION field.
	POWER_RAM_POWERCLR_S7RETENTION_Pos = 0x17
	// Bit mask of S7RETENTION field.
	POWER_RAM_POWERCLR_S7RETENTION_Msk = 0x800000
	// Bit S7RETENTION.
	POWER_RAM_POWERCLR_S7RETENTION = 0x800000
	// Off
	POWER_RAM_POWERCLR_S7RETENTION_Off = 0x1
	// Position of S8RETENTION field.
	POWER_RAM_POWERCLR_S8RETENTION_Pos = 0x18
	// Bit mask of S8RETENTION field.
	POWER_RAM_POWERCLR_S8RETENTION_Msk = 0x1000000
	// Bit S8RETENTION.
	POWER_RAM_POWERCLR_S8RETENTION = 0x1000000
	// Off
	POWER_RAM_POWERCLR_S8RETENTION_Off = 0x1
	// Position of S9RETENTION field.
	POWER_RAM_POWERCLR_S9RETENTION_Pos = 0x19
	// Bit mask of S9RETENTION field.
	POWER_RAM_POWERCLR_S9RETENTION_Msk = 0x2000000
	// Bit S9RETENTION.
	POWER_RAM_POWERCLR_S9RETENTION = 0x2000000
	// Off
	POWER_RAM_POWERCLR_S9RETENTION_Off = 0x1
	// Position of S10RETENTION field.
	POWER_RAM_POWERCLR_S10RETENTION_Pos = 0x1a
	// Bit mask of S10RETENTION field.
	POWER_RAM_POWERCLR_S10RETENTION_Msk = 0x4000000
	// Bit S10RETENTION.
	POWER_RAM_POWERCLR_S10RETENTION = 0x4000000
	// Off
	POWER_RAM_POWERCLR_S10RETENTION_Off = 0x1
	// Position of S11RETENTION field.
	POWER_RAM_POWERCLR_S11RETENTION_Pos = 0x1b
	// Bit mask of S11RETENTION field.
	POWER_RAM_POWERCLR_S11RETENTION_Msk = 0x8000000
	// Bit S11RETENTION.
	POWER_RAM_POWERCLR_S11RETENTION = 0x8000000
	// Off
	POWER_RAM_POWERCLR_S11RETENTION_Off = 0x1
	// Position of S12RETENTION field.
	POWER_RAM_POWERCLR_S12RETENTION_Pos = 0x1c
	// Bit mask of S12RETENTION field.
	POWER_RAM_POWERCLR_S12RETENTION_Msk = 0x10000000
	// Bit S12RETENTION.
	POWER_RAM_POWERCLR_S12RETENTION = 0x10000000
	// Off
	POWER_RAM_POWERCLR_S12RETENTION_Off = 0x1
	// Position of S13RETENTION field.
	POWER_RAM_POWERCLR_S13RETENTION_Pos = 0x1d
	// Bit mask of S13RETENTION field.
	POWER_RAM_POWERCLR_S13RETENTION_Msk = 0x20000000
	// Bit S13RETENTION.
	POWER_RAM_POWERCLR_S13RETENTION = 0x20000000
	// Off
	POWER_RAM_POWERCLR_S13RETENTION_Off = 0x1
	// Position of S14RETENTION field.
	POWER_RAM_POWERCLR_S14RETENTION_Pos = 0x1e
	// Bit mask of S14RETENTION field.
	POWER_RAM_POWERCLR_S14RETENTION_Msk = 0x40000000
	// Bit S14RETENTION.
	POWER_RAM_POWERCLR_S14RETENTION = 0x40000000
	// Off
	POWER_RAM_POWERCLR_S14RETENTION_Off = 0x1
	// Position of S15RETENTION field.
	POWER_RAM_POWERCLR_S15RETENTION_Pos = 0x1f
	// Bit mask of S15RETENTION field.
	POWER_RAM_POWERCLR_S15RETENTION_Msk = 0x80000000
	// Bit S15RETENTION.
	POWER_RAM_POWERCLR_S15RETENTION = 0x80000000
	// Off
	POWER_RAM_POWERCLR_S15RETENTION_Off = 0x1
)

// Bitfields for P0: GPIO Port 1
const (
	// OUT: Write GPIO port
	// Position of PIN0 field.
	GPIO_OUT_PIN0_Pos = 0x0
	// Bit mask of PIN0 field.
	GPIO_OUT_PIN0_Msk = 0x1
	// Bit PIN0.
	GPIO_OUT_PIN0 = 0x1
	// Pin driver is low
	GPIO_OUT_PIN0_Low = 0x0
	// Pin driver is high
	GPIO_OUT_PIN0_High = 0x1
	// Position of PIN1 field.
	GPIO_OUT_PIN1_Pos = 0x1
	// Bit mask of PIN1 field.
	GPIO_OUT_PIN1_Msk = 0x2
	// Bit PIN1.
	GPIO_OUT_PIN1 = 0x2
	// Pin driver is low
	GPIO_OUT_PIN1_Low = 0x0
	// Pin driver is high
	GPIO_OUT_PIN1_High = 0x1
	// Position of PIN2 field.
	GPIO_OUT_PIN2_Pos = 0x2
	// Bit mask of PIN2 field.
	GPIO_OUT_PIN2_Msk = 0x4
	// Bit PIN2.
	GPIO_OUT_PIN2 = 0x4
	// Pin driver is low
	GPIO_OUT_PIN2_Low = 0x0
	// Pin driver is high
	GPIO_OUT_PIN2_High = 0x1
	// Position of PIN3 field.
	GPIO_OUT_PIN3_Pos = 0x3
	// Bit mask of PIN3 field.
	GPIO_OUT_PIN3_Msk = 0x8
	// Bit PIN3.
	GPIO_OUT_PIN3 = 0x8
	// Pin driver is low
	GPIO_OUT_PIN3_Low = 0x0
	// Pin driver is high
	GPIO_OUT_PIN3_High = 0x1
	// Position of PIN4 field.
	GPIO_OUT_PIN4_Pos = 0x4
	// Bit mask of PIN4 field.
	GPIO_OUT_PIN4_Msk = 0x10
	// Bit PIN4.
	GPIO_OUT_PIN4 = 0x10
	// Pin driver is low
	GPIO_OUT_PIN4_Low = 0x0
	// Pin driver is high
	GPIO_OUT_PIN4_High = 0x1
	// Position of PIN5 field.
	GPIO_OUT_PIN5_Pos = 0x5
	// Bit mask of PIN5 field.
	GPIO_OUT_PIN5_Msk = 0x20
	// Bit PIN5.
	GPIO_OUT_PIN5 = 0x20
	// Pin driver is low
	GPIO_OUT_PIN5_Low = 0x0
	// Pin driver is high
	GPIO_OUT_PIN5_High = 0x1
	// Position of PIN6 field.
	GPIO_OUT_PIN6_Pos = 0x6
	// Bit mask of PIN6 field.
	GPIO_OUT_PIN6_Msk = 0x40
	// Bit PIN6.
	GPIO_OUT_PIN6 = 0x40
	// Pin driver is low
	GPIO_OUT_PIN6_Low = 0x0
	// Pin driver is high
	GPIO_OUT_PIN6_High = 0x1
	// Position of PIN7 field.
	GPIO_OUT_PIN7_Pos = 0x7
	// Bit mask of PIN7 field.
	GPIO_OUT_PIN7_Msk = 0x80
	// Bit PIN7.
	GPIO_OUT_PIN7 = 0x80
	// Pin driver is low
	GPIO_OUT_PIN7_Low = 0x0
	// Pin driver is high
	GPIO_OUT_PIN7_High = 0x1
	// Position of PIN8 field.
	GPIO_OUT_PIN8_Pos = 0x8
	// Bit mask of PIN8 field.
	GPIO_OUT_PIN8_Msk = 0x100
	// Bit PIN8.
	GPIO_OUT_PIN8 = 0x100
	// Pin driver is low
	GPIO_OUT_PIN8_Low = 0x0
	// Pin driver is high
	GPIO_OUT_PIN8_High = 0x1
	// Position of PIN9 field.
	GPIO_OUT_PIN9_Pos = 0x9
	// Bit mask of PIN9 field.
	GPIO_OUT_PIN9_Msk = 0x200
	// Bit PIN9.
	GPIO_OUT_PIN9 = 0x200
	// Pin driver is low
	GPIO_OUT_PIN9_Low = 0x0
	// Pin driver is high
	GPIO_OUT_PIN9_High = 0x1
	// Position of PIN10 field.
	GPIO_OUT_PIN10_Pos = 0xa
	// Bit mask of PIN10 field.
	GPIO_OUT_PIN10_Msk = 0x400
	// Bit PIN10.
	GPIO_OUT_PIN10 = 0x400
	// Pin driver is low
	GPIO_OUT_PIN10_Low = 0x0
	// Pin driver is high
	GPIO_OUT_PIN10_High = 0x1
	// Position of PIN11 field.
	GPIO_OUT_PIN11_Pos = 0xb
	// Bit mask of PIN11 field.
	GPIO_OUT_PIN11_Msk = 0x800
	// Bit PIN11.
	GPIO_OUT_PIN11 = 0x800
	// Pin driver is low
	GPIO_OUT_PIN11_Low = 0x0
	// Pin driver is high
	GPIO_OUT_PIN11_High = 0x1
	// Position of PIN12 field.
	GPIO_OUT_PIN12_Pos = 0xc
	// Bit mask of PIN12 field.
	GPIO_OUT_PIN12_Msk = 0x1000
	// Bit PIN12.
	GPIO_OUT_PIN12 = 0x1000
	// Pin driver is low
	GPIO_OUT_PIN12_Low = 0x0
	// Pin driver is high
	GPIO_OUT_PIN12_High = 0x1
	// Position of PIN13 field.
	GPIO_OUT_PIN13_Pos = 0xd
	// Bit mask of PIN13 field.
	GPIO_OUT_PIN13_Msk = 0x2000
	// Bit PIN13.
	GPIO_OUT_PIN13 = 0x2000
	// Pin driver is low
	GPIO_OUT_PIN13_Low = 0x0
	// Pin driver is high
	GPIO_OUT_PIN13_High = 0x1
	// Position of PIN14 field.
	GPIO_OUT_PIN14_Pos = 0xe
	// Bit mask of PIN14 field.
	GPIO_OUT_PIN14_Msk = 0x4000
	// Bit PIN14.
	GPIO_OUT_PIN14 = 0x4000
	// Pin driver is low
	GPIO_OUT_PIN14_Low = 0x0
	// Pin driver is high
	GPIO_OUT_PIN14_High = 0x1
	// Position of PIN15 field.
	GPIO_OUT_PIN15_Pos = 0xf
	// Bit mask of PIN15 field.
	GPIO_OUT_PIN15_Msk = 0x8000
	// Bit PIN15.
	GPIO_OUT_PIN15 = 0x8000
	// Pin driver is low
	GPIO_OUT_PIN15_Low = 0x0
	// Pin driver is high
	GPIO_OUT_PIN15_High = 0x1
	// Position of PIN16 field.
	GPIO_OUT_PIN16_Pos = 0x10
	// Bit mask of PIN16 field.
	GPIO_OUT_PIN16_Msk = 0x10000
	// Bit PIN16.
	GPIO_OUT_PIN16 = 0x10000
	// Pin driver is low
	GPIO_OUT_PIN16_Low = 0x0
	// Pin driver is high
	GPIO_OUT_PIN16_High = 0x1
	// Position of PIN17 field.
	GPIO_OUT_PIN17_Pos = 0x11
	// Bit mask of PIN17 field.
	GPIO_OUT_PIN17_Msk = 0x20000
	// Bit PIN17.
	GPIO_OUT_PIN17 = 0x20000
	// Pin driver is low
	GPIO_OUT_PIN17_Low = 0x0
	// Pin driver is high
	GPIO_OUT_PIN17_High = 0x1
	// Position of PIN18 field.
	GPIO_OUT_PIN18_Pos = 0x12
	// Bit mask of PIN18 field.
	GPIO_OUT_PIN18_Msk = 0x40000
	// Bit PIN18.
	GPIO_OUT_PIN18 = 0x40000
	// Pin driver is low
	GPIO_OUT_PIN18_Low = 0x0
	// Pin driver is high
	GPIO_OUT_PIN18_High = 0x1
	// Position of PIN19 field.
	GPIO_OUT_PIN19_Pos = 0x13
	// Bit mask of PIN19 field.
	GPIO_OUT_PIN19_Msk = 0x80000
	// Bit PIN19.
	GPIO_OUT_PIN19 = 0x80000
	// Pin driver is low
	GPIO_OUT_PIN19_Low = 0x0
	// Pin driver is high
	GPIO_OUT_PIN19_High = 0x1
	// Position of PIN20 field.
	GPIO_OUT_PIN20_Pos = 0x14
	// Bit mask of PIN20 field.
	GPIO_OUT_PIN20_Msk = 0x100000
	// Bit PIN20.
	GPIO_OUT_PIN20 = 0x100000
	// Pin driver is low
	GPIO_OUT_PIN20_Low = 0x0
	// Pin driver is high
	GPIO_OUT_PIN20_High = 0x1
	// Position of PIN21 field.
	GPIO_OUT_PIN21_Pos = 0x15
	// Bit mask of PIN21 field.
	GPIO_OUT_PIN21_Msk = 0x200000
	// Bit PIN21.
	GPIO_OUT_PIN21 = 0x200000
	// Pin driver is low
	GPIO_OUT_PIN21_Low = 0x0
	// Pin driver is high
	GPIO_OUT_PIN21_High = 0x1
	// Position of PIN22 field.
	GPIO_OUT_PIN22_Pos = 0x16
	// Bit mask of PIN22 field.
	GPIO_OUT_PIN22_Msk = 0x400000
	// Bit PIN22.
	GPIO_OUT_PIN22 = 0x400000
	// Pin driver is low
	GPIO_OUT_PIN22_Low = 0x0
	// Pin driver is high
	GPIO_OUT_PIN22_High = 0x1
	// Position of PIN23 field.
	GPIO_OUT_PIN23_Pos = 0x17
	// Bit mask of PIN23 field.
	GPIO_OUT_PIN23_Msk = 0x800000
	// Bit PIN23.
	GPIO_OUT_PIN23 = 0x800000
	// Pin driver is low
	GPIO_OUT_PIN23_Low = 0x0
	// Pin driver is high
	GPIO_OUT_PIN23_High = 0x1
	// Position of PIN24 field.
	GPIO_OUT_PIN24_Pos = 0x18
	// Bit mask of PIN24 field.
	GPIO_OUT_PIN24_Msk = 0x1000000
	// Bit PIN24.
	GPIO_OUT_PIN24 = 0x1000000
	// Pin driver is low
	GPIO_OUT_PIN24_Low = 0x0
	// Pin driver is high
	GPIO_OUT_PIN24_High = 0x1
	// Position of PIN25 field.
	GPIO_OUT_PIN25_Pos = 0x19
	// Bit mask of PIN25 field.
	GPIO_OUT_PIN25_Msk = 0x2000000
	// Bit PIN25.
	GPIO_OUT_PIN25 = 0x2000000
	// Pin driver is low
	GPIO_OUT_PIN25_Low = 0x0
	// Pin driver is high
	GPIO_OUT_PIN25_High = 0x1
	// Position of PIN26 field.
	GPIO_OUT_PIN26_Pos = 0x1a
	// Bit mask of PIN26 field.
	GPIO_OUT_PIN26_Msk = 0x4000000
	// Bit PIN26.
	GPIO_OUT_PIN26 = 0x4000000
	// Pin driver is low
	GPIO_OUT_PIN26_Low = 0x0
	// Pin driver is high
	GPIO_OUT_PIN26_High = 0x1
	// Position of PIN27 field.
	GPIO_OUT_PIN27_Pos = 0x1b
	// Bit mask of PIN27 field.
	GPIO_OUT_PIN27_Msk = 0x8000000
	// Bit PIN27.
	GPIO_OUT_PIN27 = 0x8000000
	// Pin driver is low
	GPIO_OUT_PIN27_Low = 0x0
	// Pin driver is high
	GPIO_OUT_PIN27_High = 0x1
	// Position of PIN28 field.
	GPIO_OUT_PIN28_Pos = 0x1c
	// Bit mask of PIN28 field.
	GPIO_OUT_PIN28_Msk = 0x10000000
	// Bit PIN28.
	GPIO_OUT_PIN28 = 0x10000000
	// Pin driver is low
	GPIO_OUT_PIN28_Low = 0x0
	// Pin driver is high
	GPIO_OUT_PIN28_High = 0x1
	// Position of PIN29 field.
	GPIO_OUT_PIN29_Pos = 0x1d
	// Bit mask of PIN29 field.
	GPIO_OUT_PIN29_Msk = 0x20000000
	// Bit PIN29.
	GPIO_OUT_PIN29 = 0x20000000
	// Pin driver is low
	GPIO_OUT_PIN29_Low = 0x0
	// Pin driver is high
	GPIO_OUT_PIN29_High = 0x1
	// Position of PIN30 field.
	GPIO_OUT_PIN30_Pos = 0x1e
	// Bit mask of PIN30 field.
	GPIO_OUT_PIN30_Msk = 0x40000000
	// Bit PIN30.
	GPIO_OUT_PIN30 = 0x40000000
	// Pin driver is low
	GPIO_OUT_PIN30_Low = 0x0
	// Pin driver is high
	GPIO_OUT_PIN30_High = 0x1
	// Position of PIN31 field.
	GPIO_OUT_PIN31_Pos = 0x1f
	// Bit mask of PIN31 field.
	GPIO_OUT_PIN31_Msk = 0x80000000
	// Bit PIN31.
	GPIO_OUT_PIN31 = 0x80000000
	// Pin driver is low
	GPIO_OUT_PIN31_Low = 0x0
	// Pin driver is high
	GPIO_OUT_PIN31_High = 0x1

	// OUTSET: Set individual bits in GPIO port
	// Position of PIN0 field.
	GPIO_OUTSET_PIN0_Pos = 0x0
	// Bit mask of PIN0 field.
	GPIO_OUTSET_PIN0_Msk = 0x1
	// Bit PIN0.
	GPIO_OUTSET_PIN0 = 0x1
	// Read: pin driver is low
	GPIO_OUTSET_PIN0_Low = 0x0
	// Read: pin driver is high
	GPIO_OUTSET_PIN0_High = 0x1
	// Write: writing a '1' sets the pin high; writing a '0' has no effect
	GPIO_OUTSET_PIN0_Set = 0x1
	// Position of PIN1 field.
	GPIO_OUTSET_PIN1_Pos = 0x1
	// Bit mask of PIN1 field.
	GPIO_OUTSET_PIN1_Msk = 0x2
	// Bit PIN1.
	GPIO_OUTSET_PIN1 = 0x2
	// Read: pin driver is low
	GPIO_OUTSET_PIN1_Low = 0x0
	// Read: pin driver is high
	GPIO_OUTSET_PIN1_High = 0x1
	// Write: writing a '1' sets the pin high; writing a '0' has no effect
	GPIO_OUTSET_PIN1_Set = 0x1
	// Position of PIN2 field.
	GPIO_OUTSET_PIN2_Pos = 0x2
	// Bit mask of PIN2 field.
	GPIO_OUTSET_PIN2_Msk = 0x4
	// Bit PIN2.
	GPIO_OUTSET_PIN2 = 0x4
	// Read: pin driver is low
	GPIO_OUTSET_PIN2_Low = 0x0
	// Read: pin driver is high
	GPIO_OUTSET_PIN2_High = 0x1
	// Write: writing a '1' sets the pin high; writing a '0' has no effect
	GPIO_OUTSET_PIN2_Set = 0x1
	// Position of PIN3 field.
	GPIO_OUTSET_PIN3_Pos = 0x3
	// Bit mask of PIN3 field.
	GPIO_OUTSET_PIN3_Msk = 0x8
	// Bit PIN3.
	GPIO_OUTSET_PIN3 = 0x8
	// Read: pin driver is low
	GPIO_OUTSET_PIN3_Low = 0x0
	// Read: pin driver is high
	GPIO_OUTSET_PIN3_High = 0x1
	// Write: writing a '1' sets the pin high; writing a '0' has no effect
	GPIO_OUTSET_PIN3_Set = 0x1
	// Position of PIN4 field.
	GPIO_OUTSET_PIN4_Pos = 0x4
	// Bit mask of PIN4 field.
	GPIO_OUTSET_PIN4_Msk = 0x10
	// Bit PIN4.
	GPIO_OUTSET_PIN4 = 0x10
	// Read: pin driver is low
	GPIO_OUTSET_PIN4_Low = 0x0
	// Read: pin driver is high
	GPIO_OUTSET_PIN4_High = 0x1
	// Write: writing a '1' sets the pin high; writing a '0' has no effect
	GPIO_OUTSET_PIN4_Set = 0x1
	// Position of PIN5 field.
	GPIO_OUTSET_PIN5_Pos = 0x5
	// Bit mask of PIN5 field.
	GPIO_OUTSET_PIN5_Msk = 0x20
	// Bit PIN5.
	GPIO_OUTSET_PIN5 = 0x20
	// Read: pin driver is low
	GPIO_OUTSET_PIN5_Low = 0x0
	// Read: pin driver is high
	GPIO_OUTSET_PIN5_High = 0x1
	// Write: writing a '1' sets the pin high; writing a '0' has no effect
	GPIO_OUTSET_PIN5_Set = 0x1
	// Position of PIN6 field.
	GPIO_OUTSET_PIN6_Pos = 0x6
	// Bit mask of PIN6 field.
	GPIO_OUTSET_PIN6_Msk = 0x40
	// Bit PIN6.
	GPIO_OUTSET_PIN6 = 0x40
	// Read: pin driver is low
	GPIO_OUTSET_PIN6_Low = 0x0
	// Read: pin driver is high
	GPIO_OUTSET_PIN6_High = 0x1
	// Write: writing a '1' sets the pin high; writing a '0' has no effect
	GPIO_OUTSET_PIN6_Set = 0x1
	// Position of PIN7 field.
	GPIO_OUTSET_PIN7_Pos = 0x7
	// Bit mask of PIN7 field.
	GPIO_OUTSET_PIN7_Msk = 0x80
	// Bit PIN7.
	GPIO_OUTSET_PIN7 = 0x80
	// Read: pin driver is low
	GPIO_OUTSET_PIN7_Low = 0x0
	// Read: pin driver is high
	GPIO_OUTSET_PIN7_High = 0x1
	// Write: writing a '1' sets the pin high; writing a '0' has no effect
	GPIO_OUTSET_PIN7_Set = 0x1
	// Position of PIN8 field.
	GPIO_OUTSET_PIN8_Pos = 0x8
	// Bit mask of PIN8 field.
	GPIO_OUTSET_PIN8_Msk = 0x100
	// Bit PIN8.
	GPIO_OUTSET_PIN8 = 0x100
	// Read: pin driver is low
	GPIO_OUTSET_PIN8_Low = 0x0
	// Read: pin driver is high
	GPIO_OUTSET_PIN8_High = 0x1
	// Write: writing a '1' sets the pin high; writing a '0' has no effect
	GPIO_OUTSET_PIN8_Set = 0x1
	// Position of PIN9 field.
	GPIO_OUTSET_PIN9_Pos = 0x9
	// Bit mask of PIN9 field.
	GPIO_OUTSET_PIN9_Msk = 0x200
	// Bit PIN9.
	GPIO_OUTSET_PIN9 = 0x200
	// Read: pin driver is low
	GPIO_OUTSET_PIN9_Low = 0x0
	// Read: pin driver is high
	GPIO_OUTSET_PIN9_High = 0x1
	// Write: writing a '1' sets the pin high; writing a '0' has no effect
	GPIO_OUTSET_PIN9_Set = 0x1
	// Position of PIN10 field.
	GPIO_OUTSET_PIN10_Pos = 0xa
	// Bit mask of PIN10 field.
	GPIO_OUTSET_PIN10_Msk = 0x400
	// Bit PIN10.
	GPIO_OUTSET_PIN10 = 0x400
	// Read: pin driver is low
	GPIO_OUTSET_PIN10_Low = 0x0
	// Read: pin driver is high
	GPIO_OUTSET_PIN10_High = 0x1
	// Write: writing a '1' sets the pin high; writing a '0' has no effect
	GPIO_OUTSET_PIN10_Set = 0x1
	// Position of PIN11 field.
	GPIO_OUTSET_PIN11_Pos = 0xb
	// Bit mask of PIN11 field.
	GPIO_OUTSET_PIN11_Msk = 0x800
	// Bit PIN11.
	GPIO_OUTSET_PIN11 = 0x800
	// Read: pin driver is low
	GPIO_OUTSET_PIN11_Low = 0x0
	// Read: pin driver is high
	GPIO_OUTSET_PIN11_High = 0x1
	// Write: writing a '1' sets the pin high; writing a '0' has no effect
	GPIO_OUTSET_PIN11_Set = 0x1
	// Position of PIN12 field.
	GPIO_OUTSET_PIN12_Pos = 0xc
	// Bit mask of PIN12 field.
	GPIO_OUTSET_PIN12_Msk = 0x1000
	// Bit PIN12.
	GPIO_OUTSET_PIN12 = 0x1000
	// Read: pin driver is low
	GPIO_OUTSET_PIN12_Low = 0x0
	// Read: pin driver is high
	GPIO_OUTSET_PIN12_High = 0x1
	// Write: writing a '1' sets the pin high; writing a '0' has no effect
	GPIO_OUTSET_PIN12_Set = 0x1
	// Position of PIN13 field.
	GPIO_OUTSET_PIN13_Pos = 0xd
	// Bit mask of PIN13 field.
	GPIO_OUTSET_PIN13_Msk = 0x2000
	// Bit PIN13.
	GPIO_OUTSET_PIN13 = 0x2000
	// Read: pin driver is low
	GPIO_OUTSET_PIN13_Low = 0x0
	// Read: pin driver is high
	GPIO_OUTSET_PIN13_High = 0x1
	// Write: writing a '1' sets the pin high; writing a '0' has no effect
	GPIO_OUTSET_PIN13_Set = 0x1
	// Position of PIN14 field.
	GPIO_OUTSET_PIN14_Pos = 0xe
	// Bit mask of PIN14 field.
	GPIO_OUTSET_PIN14_Msk = 0x4000
	// Bit PIN14.
	GPIO_OUTSET_PIN14 = 0x4000
	// Read: pin driver is low
	GPIO_OUTSET_PIN14_Low = 0x0
	// Read: pin driver is high
	GPIO_OUTSET_PIN14_High = 0x1
	// Write: writing a '1' sets the pin high; writing a '0' has no effect
	GPIO_OUTSET_PIN14_Set = 0x1
	// Position of PIN15 field.
	GPIO_OUTSET_PIN15_Pos = 0xf
	// Bit mask of PIN15 field.
	GPIO_OUTSET_PIN15_Msk = 0x8000
	// Bit PIN15.
	GPIO_OUTSET_PIN15 = 0x8000
	// Read: pin driver is low
	GPIO_OUTSET_PIN15_Low = 0x0
	// Read: pin driver is high
	GPIO_OUTSET_PIN15_High = 0x1
	// Write: writing a '1' sets the pin high; writing a '0' has no effect
	GPIO_OUTSET_PIN15_Set = 0x1
	// Position of PIN16 field.
	GPIO_OUTSET_PIN16_Pos = 0x10
	// Bit mask of PIN16 field.
	GPIO_OUTSET_PIN16_Msk = 0x10000
	// Bit PIN16.
	GPIO_OUTSET_PIN16 = 0x10000
	// Read: pin driver is low
	GPIO_OUTSET_PIN16_Low = 0x0
	// Read: pin driver is high
	GPIO_OUTSET_PIN16_High = 0x1
	// Write: writing a '1' sets the pin high; writing a '0' has no effect
	GPIO_OUTSET_PIN16_Set = 0x1
	// Position of PIN17 field.
	GPIO_OUTSET_PIN17_Pos = 0x11
	// Bit mask of PIN17 field.
	GPIO_OUTSET_PIN17_Msk = 0x20000
	// Bit PIN17.
	GPIO_OUTSET_PIN17 = 0x20000
	// Read: pin driver is low
	GPIO_OUTSET_PIN17_Low = 0x0
	// Read: pin driver is high
	GPIO_OUTSET_PIN17_High = 0x1
	// Write: writing a '1' sets the pin high; writing a '0' has no effect
	GPIO_OUTSET_PIN17_Set = 0x1
	// Position of PIN18 field.
	GPIO_OUTSET_PIN18_Pos = 0x12
	// Bit mask of PIN18 field.
	GPIO_OUTSET_PIN18_Msk = 0x40000
	// Bit PIN18.
	GPIO_OUTSET_PIN18 = 0x40000
	// Read: pin driver is low
	GPIO_OUTSET_PIN18_Low = 0x0
	// Read: pin driver is high
	GPIO_OUTSET_PIN18_High = 0x1
	// Write: writing a '1' sets the pin high; writing a '0' has no effect
	GPIO_OUTSET_PIN18_Set = 0x1
	// Position of PIN19 field.
	GPIO_OUTSET_PIN19_Pos = 0x13
	// Bit mask of PIN19 field.
	GPIO_OUTSET_PIN19_Msk = 0x80000
	// Bit PIN19.
	GPIO_OUTSET_PIN19 = 0x80000
	// Read: pin driver is low
	GPIO_OUTSET_PIN19_Low = 0x0
	// Read: pin driver is high
	GPIO_OUTSET_PIN19_High = 0x1
	// Write: writing a '1' sets the pin high; writing a '0' has no effect
	GPIO_OUTSET_PIN19_Set = 0x1
	// Position of PIN20 field.
	GPIO_OUTSET_PIN20_Pos = 0x14
	// Bit mask of PIN20 field.
	GPIO_OUTSET_PIN20_Msk = 0x100000
	// Bit PIN20.
	GPIO_OUTSET_PIN20 = 0x100000
	// Read: pin driver is low
	GPIO_OUTSET_PIN20_Low = 0x0
	// Read: pin driver is high
	GPIO_OUTSET_PIN20_High = 0x1
	// Write: writing a '1' sets the pin high; writing a '0' has no effect
	GPIO_OUTSET_PIN20_Set = 0x1
	// Position of PIN21 field.
	GPIO_OUTSET_PIN21_Pos = 0x15
	// Bit mask of PIN21 field.
	GPIO_OUTSET_PIN21_Msk = 0x200000
	// Bit PIN21.
	GPIO_OUTSET_PIN21 = 0x200000
	// Read: pin driver is low
	GPIO_OUTSET_PIN21_Low = 0x0
	// Read: pin driver is high
	GPIO_OUTSET_PIN21_High = 0x1
	// Write: writing a '1' sets the pin high; writing a '0' has no effect
	GPIO_OUTSET_PIN21_Set = 0x1
	// Position of PIN22 field.
	GPIO_OUTSET_PIN22_Pos = 0x16
	// Bit mask of PIN22 field.
	GPIO_OUTSET_PIN22_Msk = 0x400000
	// Bit PIN22.
	GPIO_OUTSET_PIN22 = 0x400000
	// Read: pin driver is low
	GPIO_OUTSET_PIN22_Low = 0x0
	// Read: pin driver is high
	GPIO_OUTSET_PIN22_High = 0x1
	// Write: writing a '1' sets the pin high; writing a '0' has no effect
	GPIO_OUTSET_PIN22_Set = 0x1
	// Position of PIN23 field.
	GPIO_OUTSET_PIN23_Pos = 0x17
	// Bit mask of PIN23 field.
	GPIO_OUTSET_PIN23_Msk = 0x800000
	// Bit PIN23.
	GPIO_OUTSET_PIN23 = 0x800000
	// Read: pin driver is low
	GPIO_OUTSET_PIN23_Low = 0x0
	// Read: pin driver is high
	GPIO_OUTSET_PIN23_High = 0x1
	// Write: writing a '1' sets the pin high; writing a '0' has no effect
	GPIO_OUTSET_PIN23_Set = 0x1
	// Position of PIN24 field.
	GPIO_OUTSET_PIN24_Pos = 0x18
	// Bit mask of PIN24 field.
	GPIO_OUTSET_PIN24_Msk = 0x1000000
	// Bit PIN24.
	GPIO_OUTSET_PIN24 = 0x1000000
	// Read: pin driver is low
	GPIO_OUTSET_PIN24_Low = 0x0
	// Read: pin driver is high
	GPIO_OUTSET_PIN24_High = 0x1
	// Write: writing a '1' sets the pin high; writing a '0' has no effect
	GPIO_OUTSET_PIN24_Set = 0x1
	// Position of PIN25 field.
	GPIO_OUTSET_PIN25_Pos = 0x19
	// Bit mask of PIN25 field.
	GPIO_OUTSET_PIN25_Msk = 0x2000000
	// Bit PIN25.
	GPIO_OUTSET_PIN25 = 0x2000000
	// Read: pin driver is low
	GPIO_OUTSET_PIN25_Low = 0x0
	// Read: pin driver is high
	GPIO_OUTSET_PIN25_High = 0x1
	// Write: writing a '1' sets the pin high; writing a '0' has no effect
	GPIO_OUTSET_PIN25_Set = 0x1
	// Position of PIN26 field.
	GPIO_OUTSET_PIN26_Pos = 0x1a
	// Bit mask of PIN26 field.
	GPIO_OUTSET_PIN26_Msk = 0x4000000
	// Bit PIN26.
	GPIO_OUTSET_PIN26 = 0x4000000
	// Read: pin driver is low
	GPIO_OUTSET_PIN26_Low = 0x0
	// Read: pin driver is high
	GPIO_OUTSET_PIN26_High = 0x1
	// Write: writing a '1' sets the pin high; writing a '0' has no effect
	GPIO_OUTSET_PIN26_Set = 0x1
	// Position of PIN27 field.
	GPIO_OUTSET_PIN27_Pos = 0x1b
	// Bit mask of PIN27 field.
	GPIO_OUTSET_PIN27_Msk = 0x8000000
	// Bit PIN27.
	GPIO_OUTSET_PIN27 = 0x8000000
	// Read: pin driver is low
	GPIO_OUTSET_PIN27_Low = 0x0
	// Read: pin driver is high
	GPIO_OUTSET_PIN27_High = 0x1
	// Write: writing a '1' sets the pin high; writing a '0' has no effect
	GPIO_OUTSET_PIN27_Set = 0x1
	// Position of PIN28 field.
	GPIO_OUTSET_PIN28_Pos = 0x1c
	// Bit mask of PIN28 field.
	GPIO_OUTSET_PIN28_Msk = 0x10000000
	// Bit PIN28.
	GPIO_OUTSET_PIN28 = 0x10000000
	// Read: pin driver is low
	GPIO_OUTSET_PIN28_Low = 0x0
	// Read: pin driver is high
	GPIO_OUTSET_PIN28_High = 0x1
	// Write: writing a '1' sets the pin high; writing a '0' has no effect
	GPIO_OUTSET_PIN28_Set = 0x1
	// Position of PIN29 field.
	GPIO_OUTSET_PIN29_Pos = 0x1d
	// Bit mask of PIN29 field.
	GPIO_OUTSET_PIN29_Msk = 0x20000000
	// Bit PIN29.
	GPIO_OUTSET_PIN29 = 0x20000000
	// Read: pin driver is low
	GPIO_OUTSET_PIN29_Low = 0x0
	// Read: pin driver is high
	GPIO_OUTSET_PIN29_High = 0x1
	// Write: writing a '1' sets the pin high; writing a '0' has no effect
	GPIO_OUTSET_PIN29_Set = 0x1
	// Position of PIN30 field.
	GPIO_OUTSET_PIN30_Pos = 0x1e
	// Bit mask of PIN30 field.
	GPIO_OUTSET_PIN30_Msk = 0x40000000
	// Bit PIN30.
	GPIO_OUTSET_PIN30 = 0x40000000
	// Read: pin driver is low
	GPIO_OUTSET_PIN30_Low = 0x0
	// Read: pin driver is high
	GPIO_OUTSET_PIN30_High = 0x1
	// Write: writing a '1' sets the pin high; writing a '0' has no effect
	GPIO_OUTSET_PIN30_Set = 0x1
	// Position of PIN31 field.
	GPIO_OUTSET_PIN31_Pos = 0x1f
	// Bit mask of PIN31 field.
	GPIO_OUTSET_PIN31_Msk = 0x80000000
	// Bit PIN31.
	GPIO_OUTSET_PIN31 = 0x80000000
	// Read: pin driver is low
	GPIO_OUTSET_PIN31_Low = 0x0
	// Read: pin driver is high
	GPIO_OUTSET_PIN31_High = 0x1
	// Write: writing a '1' sets the pin high; writing a '0' has no effect
	GPIO_OUTSET_PIN31_Set = 0x1

	// OUTCLR: Clear individual bits in GPIO port
	// Position of PIN0 field.
	GPIO_OUTCLR_PIN0_Pos = 0x0
	// Bit mask of PIN0 field.
	GPIO_OUTCLR_PIN0_Msk = 0x1
	// Bit PIN0.
	GPIO_OUTCLR_PIN0 = 0x1
	// Read: pin driver is low
	GPIO_OUTCLR_PIN0_Low = 0x0
	// Read: pin driver is high
	GPIO_OUTCLR_PIN0_High = 0x1
	// Write: writing a '1' sets the pin low; writing a '0' has no effect
	GPIO_OUTCLR_PIN0_Clear = 0x1
	// Position of PIN1 field.
	GPIO_OUTCLR_PIN1_Pos = 0x1
	// Bit mask of PIN1 field.
	GPIO_OUTCLR_PIN1_Msk = 0x2
	// Bit PIN1.
	GPIO_OUTCLR_PIN1 = 0x2
	// Read: pin driver is low
	GPIO_OUTCLR_PIN1_Low = 0x0
	// Read: pin driver is high
	GPIO_OUTCLR_PIN1_High = 0x1
	// Write: writing a '1' sets the pin low; writing a '0' has no effect
	GPIO_OUTCLR_PIN1_Clear = 0x1
	// Position of PIN2 field.
	GPIO_OUTCLR_PIN2_Pos = 0x2
	// Bit mask of PIN2 field.
	GPIO_OUTCLR_PIN2_Msk = 0x4
	// Bit PIN2.
	GPIO_OUTCLR_PIN2 = 0x4
	// Read: pin driver is low
	GPIO_OUTCLR_PIN2_Low = 0x0
	// Read: pin driver is high
	GPIO_OUTCLR_PIN2_High = 0x1
	// Write: writing a '1' sets the pin low; writing a '0' has no effect
	GPIO_OUTCLR_PIN2_Clear = 0x1
	// Position of PIN3 field.
	GPIO_OUTCLR_PIN3_Pos = 0x3
	// Bit mask of PIN3 field.
	GPIO_OUTCLR_PIN3_Msk = 0x8
	// Bit PIN3.
	GPIO_OUTCLR_PIN3 = 0x8
	// Read: pin driver is low
	GPIO_OUTCLR_PIN3_Low = 0x0
	// Read: pin driver is high
	GPIO_OUTCLR_PIN3_High = 0x1
	// Write: writing a '1' sets the pin low; writing a '0' has no effect
	GPIO_OUTCLR_PIN3_Clear = 0x1
	// Position of PIN4 field.
	GPIO_OUTCLR_PIN4_Pos = 0x4
	// Bit mask of PIN4 field.
	GPIO_OUTCLR_PIN4_Msk = 0x10
	// Bit PIN4.
	GPIO_OUTCLR_PIN4 = 0x10
	// Read: pin driver is low
	GPIO_OUTCLR_PIN4_Low = 0x0
	// Read: pin driver is high
	GPIO_OUTCLR_PIN4_High = 0x1
	// Write: writing a '1' sets the pin low; writing a '0' has no effect
	GPIO_OUTCLR_PIN4_Clear = 0x1
	// Position of PIN5 field.
	GPIO_OUTCLR_PIN5_Pos = 0x5
	// Bit mask of PIN5 field.
	GPIO_OUTCLR_PIN5_Msk = 0x20
	// Bit PIN5.
	GPIO_OUTCLR_PIN5 = 0x20
	// Read: pin driver is low
	GPIO_OUTCLR_PIN5_Low = 0x0
	// Read: pin driver is high
	GPIO_OUTCLR_PIN5_High = 0x1
	// Write: writing a '1' sets the pin low; writing a '0' has no effect
	GPIO_OUTCLR_PIN5_Clear = 0x1
	// Position of PIN6 field.
	GPIO_OUTCLR_PIN6_Pos = 0x6
	// Bit mask of PIN6 field.
	GPIO_OUTCLR_PIN6_Msk = 0x40
	// Bit PIN6.
	GPIO_OUTCLR_PIN6 = 0x40
	// Read: pin driver is low
	GPIO_OUTCLR_PIN6_Low = 0x0
	// Read: pin driver is high
	GPIO_OUTCLR_PIN6_High = 0x1
	// Write: writing a '1' sets the pin low; writing a '0' has no effect
	GPIO_OUTCLR_PIN6_Clear = 0x1
	// Position of PIN7 field.
	GPIO_OUTCLR_PIN7_Pos = 0x7
	// Bit mask of PIN7 field.
	GPIO_OUTCLR_PIN7_Msk = 0x80
	// Bit PIN7.
	GPIO_OUTCLR_PIN7 = 0x80
	// Read: pin driver is low
	GPIO_OUTCLR_PIN7_Low = 0x0
	// Read: pin driver is high
	GPIO_OUTCLR_PIN7_High = 0x1
	// Write: writing a '1' sets the pin low; writing a '0' has no effect
	GPIO_OUTCLR_PIN7_Clear = 0x1
	// Position of PIN8 field.
	GPIO_OUTCLR_PIN8_Pos = 0x8
	// Bit mask of PIN8 field.
	GPIO_OUTCLR_PIN8_Msk = 0x100
	// Bit PIN8.
	GPIO_OUTCLR_PIN8 = 0x100
	// Read: pin driver is low
	GPIO_OUTCLR_PIN8_Low = 0x0
	// Read: pin driver is high
	GPIO_OUTCLR_PIN8_High = 0x1
	// Write: writing a '1' sets the pin low; writing a '0' has no effect
	GPIO_OUTCLR_PIN8_Clear = 0x1
	// Position of PIN9 field.
	GPIO_OUTCLR_PIN9_Pos = 0x9
	// Bit mask of PIN9 field.
	GPIO_OUTCLR_PIN9_Msk = 0x200
	// Bit PIN9.
	GPIO_OUTCLR_PIN9 = 0x200
	// Read: pin driver is low
	GPIO_OUTCLR_PIN9_Low = 0x0
	// Read: pin driver is high
	GPIO_OUTCLR_PIN9_High = 0x1
	// Write: writing a '1' sets the pin low; writing a '0' has no effect
	GPIO_OUTCLR_PIN9_Clear = 0x1
	// Position of PIN10 field.
	GPIO_OUTCLR_PIN10_Pos = 0xa
	// Bit mask of PIN10 field.
	GPIO_OUTCLR_PIN10_Msk = 0x400
	// Bit PIN10.
	GPIO_OUTCLR_PIN10 = 0x400
	// Read: pin driver is low
	GPIO_OUTCLR_PIN10_Low = 0x0
	// Read: pin driver is high
	GPIO_OUTCLR_PIN10_High = 0x1
	// Write: writing a '1' sets the pin low; writing a '0' has no effect
	GPIO_OUTCLR_PIN10_Clear = 0x1
	// Position of PIN11 field.
	GPIO_OUTCLR_PIN11_Pos = 0xb
	// Bit mask of PIN11 field.
	GPIO_OUTCLR_PIN11_Msk = 0x800
	// Bit PIN11.
	GPIO_OUTCLR_PIN11 = 0x800
	// Read: pin driver is low
	GPIO_OUTCLR_PIN11_Low = 0x0
	// Read: pin driver is high
	GPIO_OUTCLR_PIN11_High = 0x1
	// Write: writing a '1' sets the pin low; writing a '0' has no effect
	GPIO_OUTCLR_PIN11_Clear = 0x1
	// Position of PIN12 field.
	GPIO_OUTCLR_PIN12_Pos = 0xc
	// Bit mask of PIN12 field.
	GPIO_OUTCLR_PIN12_Msk = 0x1000
	// Bit PIN12.
	GPIO_OUTCLR_PIN12 = 0x1000
	// Read: pin driver is low
	GPIO_OUTCLR_PIN12_Low = 0x0
	// Read: pin driver is high
	GPIO_OUTCLR_PIN12_High = 0x1
	// Write: writing a '1' sets the pin low; writing a '0' has no effect
	GPIO_OUTCLR_PIN12_Clear = 0x1
	// Position of PIN13 field.
	GPIO_OUTCLR_PIN13_Pos = 0xd
	// Bit mask of PIN13 field.
	GPIO_OUTCLR_PIN13_Msk = 0x2000
	// Bit PIN13.
	GPIO_OUTCLR_PIN13 = 0x2000
	// Read: pin driver is low
	GPIO_OUTCLR_PIN13_Low = 0x0
	// Read: pin driver is high
	GPIO_OUTCLR_PIN13_High = 0x1
	// Write: writing a '1' sets the pin low; writing a '0' has no effect
	GPIO_OUTCLR_PIN13_Clear = 0x1
	// Position of PIN14 field.
	GPIO_OUTCLR_PIN14_Pos = 0xe
	// Bit mask of PIN14 field.
	GPIO_OUTCLR_PIN14_Msk = 0x4000
	// Bit PIN14.
	GPIO_OUTCLR_PIN14 = 0x4000
	// Read: pin driver is low
	GPIO_OUTCLR_PIN14_Low = 0x0
	// Read: pin driver is high
	GPIO_OUTCLR_PIN14_High = 0x1
	// Write: writing a '1' sets the pin low; writing a '0' has no effect
	GPIO_OUTCLR_PIN14_Clear = 0x1
	// Position of PIN15 field.
	GPIO_OUTCLR_PIN15_Pos = 0xf
	// Bit mask of PIN15 field.
	GPIO_OUTCLR_PIN15_Msk = 0x8000
	// Bit PIN15.
	GPIO_OUTCLR_PIN15 = 0x8000
	// Read: pin driver is low
	GPIO_OUTCLR_PIN15_Low = 0x0
	// Read: pin driver is high
	GPIO_OUTCLR_PIN15_High = 0x1
	// Write: writing a '1' sets the pin low; writing a '0' has no effect
	GPIO_OUTCLR_PIN15_Clear = 0x1
	// Position of PIN16 field.
	GPIO_OUTCLR_PIN16_Pos = 0x10
	// Bit mask of PIN16 field.
	GPIO_OUTCLR_PIN16_Msk = 0x10000
	// Bit PIN16.
	GPIO_OUTCLR_PIN16 = 0x10000
	// Read: pin driver is low
	GPIO_OUTCLR_PIN16_Low = 0x0
	// Read: pin driver is high
	GPIO_OUTCLR_PIN16_High = 0x1
	// Write: writing a '1' sets the pin low; writing a '0' has no effect
	GPIO_OUTCLR_PIN16_Clear = 0x1
	// Position of PIN17 field.
	GPIO_OUTCLR_PIN17_Pos = 0x11
	// Bit mask of PIN17 field.
	GPIO_OUTCLR_PIN17_Msk = 0x20000
	// Bit PIN17.
	GPIO_OUTCLR_PIN17 = 0x20000
	// Read: pin driver is low
	GPIO_OUTCLR_PIN17_Low = 0x0
	// Read: pin driver is high
	GPIO_OUTCLR_PIN17_High = 0x1
	// Write: writing a '1' sets the pin low; writing a '0' has no effect
	GPIO_OUTCLR_PIN17_Clear = 0x1
	// Position of PIN18 field.
	GPIO_OUTCLR_PIN18_Pos = 0x12
	// Bit mask of PIN18 field.
	GPIO_OUTCLR_PIN18_Msk = 0x40000
	// Bit PIN18.
	GPIO_OUTCLR_PIN18 = 0x40000
	// Read: pin driver is low
	GPIO_OUTCLR_PIN18_Low = 0x0
	// Read: pin driver is high
	GPIO_OUTCLR_PIN18_High = 0x1
	// Write: writing a '1' sets the pin low; writing a '0' has no effect
	GPIO_OUTCLR_PIN18_Clear = 0x1
	// Position of PIN19 field.
	GPIO_OUTCLR_PIN19_Pos = 0x13
	// Bit mask of PIN19 field.
	GPIO_OUTCLR_PIN19_Msk = 0x80000
	// Bit PIN19.
	GPIO_OUTCLR_PIN19 = 0x80000
	// Read: pin driver is low
	GPIO_OUTCLR_PIN19_Low = 0x0
	// Read: pin driver is high
	GPIO_OUTCLR_PIN19_High = 0x1
	// Write: writing a '1' sets the pin low; writing a '0' has no effect
	GPIO_OUTCLR_PIN19_Clear = 0x1
	// Position of PIN20 field.
	GPIO_OUTCLR_PIN20_Pos = 0x14
	// Bit mask of PIN20 field.
	GPIO_OUTCLR_PIN20_Msk = 0x100000
	// Bit PIN20.
	GPIO_OUTCLR_PIN20 = 0x100000
	// Read: pin driver is low
	GPIO_OUTCLR_PIN20_Low = 0x0
	// Read: pin driver is high
	GPIO_OUTCLR_PIN20_High = 0x1
	// Write: writing a '1' sets the pin low; writing a '0' has no effect
	GPIO_OUTCLR_PIN20_Clear = 0x1
	// Position of PIN21 field.
	GPIO_OUTCLR_PIN21_Pos = 0x15
	// Bit mask of PIN21 field.
	GPIO_OUTCLR_PIN21_Msk = 0x200000
	// Bit PIN21.
	GPIO_OUTCLR_PIN21 = 0x200000
	// Read: pin driver is low
	GPIO_OUTCLR_PIN21_Low = 0x0
	// Read: pin driver is high
	GPIO_OUTCLR_PIN21_High = 0x1
	// Write: writing a '1' sets the pin low; writing a '0' has no effect
	GPIO_OUTCLR_PIN21_Clear = 0x1
	// Position of PIN22 field.
	GPIO_OUTCLR_PIN22_Pos = 0x16
	// Bit mask of PIN22 field.
	GPIO_OUTCLR_PIN22_Msk = 0x400000
	// Bit PIN22.
	GPIO_OUTCLR_PIN22 = 0x400000
	// Read: pin driver is low
	GPIO_OUTCLR_PIN22_Low = 0x0
	// Read: pin driver is high
	GPIO_OUTCLR_PIN22_High = 0x1
	// Write: writing a '1' sets the pin low; writing a '0' has no effect
	GPIO_OUTCLR_PIN22_Clear = 0x1
	// Position of PIN23 field.
	GPIO_OUTCLR_PIN23_Pos = 0x17
	// Bit mask of PIN23 field.
	GPIO_OUTCLR_PIN23_Msk = 0x800000
	// Bit PIN23.
	GPIO_OUTCLR_PIN23 = 0x800000
	// Read: pin driver is low
	GPIO_OUTCLR_PIN23_Low = 0x0
	// Read: pin driver is high
	GPIO_OUTCLR_PIN23_High = 0x1
	// Write: writing a '1' sets the pin low; writing a '0' has no effect
	GPIO_OUTCLR_PIN23_Clear = 0x1
	// Position of PIN24 field.
	GPIO_OUTCLR_PIN24_Pos = 0x18
	// Bit mask of PIN24 field.
	GPIO_OUTCLR_PIN24_Msk = 0x1000000
	// Bit PIN24.
	GPIO_OUTCLR_PIN24 = 0x1000000
	// Read: pin driver is low
	GPIO_OUTCLR_PIN24_Low = 0x0
	// Read: pin driver is high
	GPIO_OUTCLR_PIN24_High = 0x1
	// Write: writing a '1' sets the pin low; writing a '0' has no effect
	GPIO_OUTCLR_PIN24_Clear = 0x1
	// Position of PIN25 field.
	GPIO_OUTCLR_PIN25_Pos = 0x19
	// Bit mask of PIN25 field.
	GPIO_OUTCLR_PIN25_Msk = 0x2000000
	// Bit PIN25.
	GPIO_OUTCLR_PIN25 = 0x2000000
	// Read: pin driver is low
	GPIO_OUTCLR_PIN25_Low = 0x0
	// Read: pin driver is high
	GPIO_OUTCLR_PIN25_High = 0x1
	// Write: writing a '1' sets the pin low; writing a '0' has no effect
	GPIO_OUTCLR_PIN25_Clear = 0x1
	// Position of PIN26 field.
	GPIO_OUTCLR_PIN26_Pos = 0x1a
	// Bit mask of PIN26 field.
	GPIO_OUTCLR_PIN26_Msk = 0x4000000
	// Bit PIN26.
	GPIO_OUTCLR_PIN26 = 0x4000000
	// Read: pin driver is low
	GPIO_OUTCLR_PIN26_Low = 0x0
	// Read: pin driver is high
	GPIO_OUTCLR_PIN26_High = 0x1
	// Write: writing a '1' sets the pin low; writing a '0' has no effect
	GPIO_OUTCLR_PIN26_Clear = 0x1
	// Position of PIN27 field.
	GPIO_OUTCLR_PIN27_Pos = 0x1b
	// Bit mask of PIN27 field.
	GPIO_OUTCLR_PIN27_Msk = 0x8000000
	// Bit PIN27.
	GPIO_OUTCLR_PIN27 = 0x8000000
	// Read: pin driver is low
	GPIO_OUTCLR_PIN27_Low = 0x0
	// Read: pin driver is high
	GPIO_OUTCLR_PIN27_High = 0x1
	// Write: writing a '1' sets the pin low; writing a '0' has no effect
	GPIO_OUTCLR_PIN27_Clear = 0x1
	// Position of PIN28 field.
	GPIO_OUTCLR_PIN28_Pos = 0x1c
	// Bit mask of PIN28 field.
	GPIO_OUTCLR_PIN28_Msk = 0x10000000
	// Bit PIN28.
	GPIO_OUTCLR_PIN28 = 0x10000000
	// Read: pin driver is low
	GPIO_OUTCLR_PIN28_Low = 0x0
	// Read: pin driver is high
	GPIO_OUTCLR_PIN28_High = 0x1
	// Write: writing a '1' sets the pin low; writing a '0' has no effect
	GPIO_OUTCLR_PIN28_Clear = 0x1
	// Position of PIN29 field.
	GPIO_OUTCLR_PIN29_Pos = 0x1d
	// Bit mask of PIN29 field.
	GPIO_OUTCLR_PIN29_Msk = 0x20000000
	// Bit PIN29.
	GPIO_OUTCLR_PIN29 = 0x20000000
	// Read: pin driver is low
	GPIO_OUTCLR_PIN29_Low = 0x0
	// Read: pin driver is high
	GPIO_OUTCLR_PIN29_High = 0x1
	// Write: writing a '1' sets the pin low; writing a '0' has no effect
	GPIO_OUTCLR_PIN29_Clear = 0x1
	// Position of PIN30 field.
	GPIO_OUTCLR_PIN30_Pos = 0x1e
	// Bit mask of PIN30 field.
	GPIO_OUTCLR_PIN30_Msk = 0x40000000
	// Bit PIN30.
	GPIO_OUTCLR_PIN30 = 0x40000000
	// Read: pin driver is low
	GPIO_OUTCLR_PIN30_Low = 0x0
	// Read: pin driver is high
	GPIO_OUTCLR_PIN30_High = 0x1
	// Write: writing a '1' sets the pin low; writing a '0' has no effect
	GPIO_OUTCLR_PIN30_Clear = 0x1
	// Position of PIN31 field.
	GPIO_OUTCLR_PIN31_Pos = 0x1f
	// Bit mask of PIN31 field.
	GPIO_OUTCLR_PIN31_Msk = 0x80000000
	// Bit PIN31.
	GPIO_OUTCLR_PIN31 = 0x80000000
	// Read: pin driver is low
	GPIO_OUTCLR_PIN31_Low = 0x0
	// Read: pin driver is high
	GPIO_OUTCLR_PIN31_High = 0x1
	// Write: writing a '1' sets the pin low; writing a '0' has no effect
	GPIO_OUTCLR_PIN31_Clear = 0x1

	// IN: Read GPIO port
	// Position of PIN0 field.
	GPIO_IN_PIN0_Pos = 0x0
	// Bit mask of PIN0 field.
	GPIO_IN_PIN0_Msk = 0x1
	// Bit PIN0.
	GPIO_IN_PIN0 = 0x1
	// Pin input is low
	GPIO_IN_PIN0_Low = 0x0
	// Pin input is high
	GPIO_IN_PIN0_High = 0x1
	// Position of PIN1 field.
	GPIO_IN_PIN1_Pos = 0x1
	// Bit mask of PIN1 field.
	GPIO_IN_PIN1_Msk = 0x2
	// Bit PIN1.
	GPIO_IN_PIN1 = 0x2
	// Pin input is low
	GPIO_IN_PIN1_Low = 0x0
	// Pin input is high
	GPIO_IN_PIN1_High = 0x1
	// Position of PIN2 field.
	GPIO_IN_PIN2_Pos = 0x2
	// Bit mask of PIN2 field.
	GPIO_IN_PIN2_Msk = 0x4
	// Bit PIN2.
	GPIO_IN_PIN2 = 0x4
	// Pin input is low
	GPIO_IN_PIN2_Low = 0x0
	// Pin input is high
	GPIO_IN_PIN2_High = 0x1
	// Position of PIN3 field.
	GPIO_IN_PIN3_Pos = 0x3
	// Bit mask of PIN3 field.
	GPIO_IN_PIN3_Msk = 0x8
	// Bit PIN3.
	GPIO_IN_PIN3 = 0x8
	// Pin input is low
	GPIO_IN_PIN3_Low = 0x0
	// Pin input is high
	GPIO_IN_PIN3_High = 0x1
	// Position of PIN4 field.
	GPIO_IN_PIN4_Pos = 0x4
	// Bit mask of PIN4 field.
	GPIO_IN_PIN4_Msk = 0x10
	// Bit PIN4.
	GPIO_IN_PIN4 = 0x10
	// Pin input is low
	GPIO_IN_PIN4_Low = 0x0
	// Pin input is high
	GPIO_IN_PIN4_High = 0x1
	// Position of PIN5 field.
	GPIO_IN_PIN5_Pos = 0x5
	// Bit mask of PIN5 field.
	GPIO_IN_PIN5_Msk = 0x20
	// Bit PIN5.
	GPIO_IN_PIN5 = 0x20
	// Pin input is low
	GPIO_IN_PIN5_Low = 0x0
	// Pin input is high
	GPIO_IN_PIN5_High = 0x1
	// Position of PIN6 field.
	GPIO_IN_PIN6_Pos = 0x6
	// Bit mask of PIN6 field.
	GPIO_IN_PIN6_Msk = 0x40
	// Bit PIN6.
	GPIO_IN_PIN6 = 0x40
	// Pin input is low
	GPIO_IN_PIN6_Low = 0x0
	// Pin input is high
	GPIO_IN_PIN6_High = 0x1
	// Position of PIN7 field.
	GPIO_IN_PIN7_Pos = 0x7
	// Bit mask of PIN7 field.
	GPIO_IN_PIN7_Msk = 0x80
	// Bit PIN7.
	GPIO_IN_PIN7 = 0x80
	// Pin input is low
	GPIO_IN_PIN7_Low = 0x0
	// Pin input is high
	GPIO_IN_PIN7_High = 0x1
	// Position of PIN8 field.
	GPIO_IN_PIN8_Pos = 0x8
	// Bit mask of PIN8 field.
	GPIO_IN_PIN8_Msk = 0x100
	// Bit PIN8.
	GPIO_IN_PIN8 = 0x100
	// Pin input is low
	GPIO_IN_PIN8_Low = 0x0
	// Pin input is high
	GPIO_IN_PIN8_High = 0x1
	// Position of PIN9 field.
	GPIO_IN_PIN9_Pos = 0x9
	// Bit mask of PIN9 field.
	GPIO_IN_PIN9_Msk = 0x200
	// Bit PIN9.
	GPIO_IN_PIN9 = 0x200
	// Pin input is low
	GPIO_IN_PIN9_Low = 0x0
	// Pin input is high
	GPIO_IN_PIN9_High = 0x1
	// Position of PIN10 field.
	GPIO_IN_PIN10_Pos = 0xa
	// Bit mask of PIN10 field.
	GPIO_IN_PIN10_Msk = 0x400
	// Bit PIN10.
	GPIO_IN_PIN10 = 0x400
	// Pin input is low
	GPIO_IN_PIN10_Low = 0x0
	// Pin input is high
	GPIO_IN_PIN10_High = 0x1
	// Position of PIN11 field.
	GPIO_IN_PIN11_Pos = 0xb
	// Bit mask of PIN11 field.
	GPIO_IN_PIN11_Msk = 0x800
	// Bit PIN11.
	GPIO_IN_PIN11 = 0x800
	// Pin input is low
	GPIO_IN_PIN11_Low = 0x0
	// Pin input is high
	GPIO_IN_PIN11_High = 0x1
	// Position of PIN12 field.
	GPIO_IN_PIN12_Pos = 0xc
	// Bit mask of PIN12 field.
	GPIO_IN_PIN12_Msk = 0x1000
	// Bit PIN12.
	GPIO_IN_PIN12 = 0x1000
	// Pin input is low
	GPIO_IN_PIN12_Low = 0x0
	// Pin input is high
	GPIO_IN_PIN12_High = 0x1
	// Position of PIN13 field.
	GPIO_IN_PIN13_Pos = 0xd
	// Bit mask of PIN13 field.
	GPIO_IN_PIN13_Msk = 0x2000
	// Bit PIN13.
	GPIO_IN_PIN13 = 0x2000
	// Pin input is low
	GPIO_IN_PIN13_Low = 0x0
	// Pin input is high
	GPIO_IN_PIN13_High = 0x1
	// Position of PIN14 field.
	GPIO_IN_PIN14_Pos = 0xe
	// Bit mask of PIN14 field.
	GPIO_IN_PIN14_Msk = 0x4000
	// Bit PIN14.
	GPIO_IN_PIN14 = 0x4000
	// Pin input is low
	GPIO_IN_PIN14_Low = 0x0
	// Pin input is high
	GPIO_IN_PIN14_High = 0x1
	// Position of PIN15 field.
	GPIO_IN_PIN15_Pos = 0xf
	// Bit mask of PIN15 field.
	GPIO_IN_PIN15_Msk = 0x8000
	// Bit PIN15.
	GPIO_IN_PIN15 = 0x8000
	// Pin input is low
	GPIO_IN_PIN15_Low = 0x0
	// Pin input is high
	GPIO_IN_PIN15_High = 0x1
	// Position of PIN16 field.
	GPIO_IN_PIN16_Pos = 0x10
	// Bit mask of PIN16 field.
	GPIO_IN_PIN16_Msk = 0x10000
	// Bit PIN16.
	GPIO_IN_PIN16 = 0x10000
	// Pin input is low
	GPIO_IN_PIN16_Low = 0x0
	// Pin input is high
	GPIO_IN_PIN16_High = 0x1
	// Position of PIN17 field.
	GPIO_IN_PIN17_Pos = 0x11
	// Bit mask of PIN17 field.
	GPIO_IN_PIN17_Msk = 0x20000
	// Bit PIN17.
	GPIO_IN_PIN17 = 0x20000
	// Pin input is low
	GPIO_IN_PIN17_Low = 0x0
	// Pin input is high
	GPIO_IN_PIN17_High = 0x1
	// Position of PIN18 field.
	GPIO_IN_PIN18_Pos = 0x12
	// Bit mask of PIN18 field.
	GPIO_IN_PIN18_Msk = 0x40000
	// Bit PIN18.
	GPIO_IN_PIN18 = 0x40000
	// Pin input is low
	GPIO_IN_PIN18_Low = 0x0
	// Pin input is high
	GPIO_IN_PIN18_High = 0x1
	// Position of PIN19 field.
	GPIO_IN_PIN19_Pos = 0x13
	// Bit mask of PIN19 field.
	GPIO_IN_PIN19_Msk = 0x80000
	// Bit PIN19.
	GPIO_IN_PIN19 = 0x80000
	// Pin input is low
	GPIO_IN_PIN19_Low = 0x0
	// Pin input is high
	GPIO_IN_PIN19_High = 0x1
	// Position of PIN20 field.
	GPIO_IN_PIN20_Pos = 0x14
	// Bit mask of PIN20 field.
	GPIO_IN_PIN20_Msk = 0x100000
	// Bit PIN20.
	GPIO_IN_PIN20 = 0x100000
	// Pin input is low
	GPIO_IN_PIN20_Low = 0x0
	// Pin input is high
	GPIO_IN_PIN20_High = 0x1
	// Position of PIN21 field.
	GPIO_IN_PIN21_Pos = 0x15
	// Bit mask of PIN21 field.
	GPIO_IN_PIN21_Msk = 0x200000
	// Bit PIN21.
	GPIO_IN_PIN21 = 0x200000
	// Pin input is low
	GPIO_IN_PIN21_Low = 0x0
	// Pin input is high
	GPIO_IN_PIN21_High = 0x1
	// Position of PIN22 field.
	GPIO_IN_PIN22_Pos = 0x16
	// Bit mask of PIN22 field.
	GPIO_IN_PIN22_Msk = 0x400000
	// Bit PIN22.
	GPIO_IN_PIN22 = 0x400000
	// Pin input is low
	GPIO_IN_PIN22_Low = 0x0
	// Pin input is high
	GPIO_IN_PIN22_High = 0x1
	// Position of PIN23 field.
	GPIO_IN_PIN23_Pos = 0x17
	// Bit mask of PIN23 field.
	GPIO_IN_PIN23_Msk = 0x800000
	// Bit PIN23.
	GPIO_IN_PIN23 = 0x800000
	// Pin input is low
	GPIO_IN_PIN23_Low = 0x0
	// Pin input is high
	GPIO_IN_PIN23_High = 0x1
	// Position of PIN24 field.
	GPIO_IN_PIN24_Pos = 0x18
	// Bit mask of PIN24 field.
	GPIO_IN_PIN24_Msk = 0x1000000
	// Bit PIN24.
	GPIO_IN_PIN24 = 0x1000000
	// Pin input is low
	GPIO_IN_PIN24_Low = 0x0
	// Pin input is high
	GPIO_IN_PIN24_High = 0x1
	// Position of PIN25 field.
	GPIO_IN_PIN25_Pos = 0x19
	// Bit mask of PIN25 field.
	GPIO_IN_PIN25_Msk = 0x2000000
	// Bit PIN25.
	GPIO_IN_PIN25 = 0x2000000
	// Pin input is low
	GPIO_IN_PIN25_Low = 0x0
	// Pin input is high
	GPIO_IN_PIN25_High = 0x1
	// Position of PIN26 field.
	GPIO_IN_PIN26_Pos = 0x1a
	// Bit mask of PIN26 field.
	GPIO_IN_PIN26_Msk = 0x4000000
	// Bit PIN26.
	GPIO_IN_PIN26 = 0x4000000
	// Pin input is low
	GPIO_IN_PIN26_Low = 0x0
	// Pin input is high
	GPIO_IN_PIN26_High = 0x1
	// Position of PIN27 field.
	GPIO_IN_PIN27_Pos = 0x1b
	// Bit mask of PIN27 field.
	GPIO_IN_PIN27_Msk = 0x8000000
	// Bit PIN27.
	GPIO_IN_PIN27 = 0x8000000
	// Pin input is low
	GPIO_IN_PIN27_Low = 0x0
	// Pin input is high
	GPIO_IN_PIN27_High = 0x1
	// Position of PIN28 field.
	GPIO_IN_PIN28_Pos = 0x1c
	// Bit mask of PIN28 field.
	GPIO_IN_PIN28_Msk = 0x10000000
	// Bit PIN28.
	GPIO_IN_PIN28 = 0x10000000
	// Pin input is low
	GPIO_IN_PIN28_Low = 0x0
	// Pin input is high
	GPIO_IN_PIN28_High = 0x1
	// Position of PIN29 field.
	GPIO_IN_PIN29_Pos = 0x1d
	// Bit mask of PIN29 field.
	GPIO_IN_PIN29_Msk = 0x20000000
	// Bit PIN29.
	GPIO_IN_PIN29 = 0x20000000
	// Pin input is low
	GPIO_IN_PIN29_Low = 0x0
	// Pin input is high
	GPIO_IN_PIN29_High = 0x1
	// Position of PIN30 field.
	GPIO_IN_PIN30_Pos = 0x1e
	// Bit mask of PIN30 field.
	GPIO_IN_PIN30_Msk = 0x40000000
	// Bit PIN30.
	GPIO_IN_PIN30 = 0x40000000
	// Pin input is low
	GPIO_IN_PIN30_Low = 0x0
	// Pin input is high
	GPIO_IN_PIN30_High = 0x1
	// Position of PIN31 field.
	GPIO_IN_PIN31_Pos = 0x1f
	// Bit mask of PIN31 field.
	GPIO_IN_PIN31_Msk = 0x80000000
	// Bit PIN31.
	GPIO_IN_PIN31 = 0x80000000
	// Pin input is low
	GPIO_IN_PIN31_Low = 0x0
	// Pin input is high
	GPIO_IN_PIN31_High = 0x1

	// DIR: Direction of GPIO pins
	// Position of PIN0 field.
	GPIO_DIR_PIN0_Pos = 0x0
	// Bit mask of PIN0 field.
	GPIO_DIR_PIN0_Msk = 0x1
	// Bit PIN0.
	GPIO_DIR_PIN0 = 0x1
	// Pin set as input
	GPIO_DIR_PIN0_Input = 0x0
	// Pin set as output
	GPIO_DIR_PIN0_Output = 0x1
	// Position of PIN1 field.
	GPIO_DIR_PIN1_Pos = 0x1
	// Bit mask of PIN1 field.
	GPIO_DIR_PIN1_Msk = 0x2
	// Bit PIN1.
	GPIO_DIR_PIN1 = 0x2
	// Pin set as input
	GPIO_DIR_PIN1_Input = 0x0
	// Pin set as output
	GPIO_DIR_PIN1_Output = 0x1
	// Position of PIN2 field.
	GPIO_DIR_PIN2_Pos = 0x2
	// Bit mask of PIN2 field.
	GPIO_DIR_PIN2_Msk = 0x4
	// Bit PIN2.
	GPIO_DIR_PIN2 = 0x4
	// Pin set as input
	GPIO_DIR_PIN2_Input = 0x0
	// Pin set as output
	GPIO_DIR_PIN2_Output = 0x1
	// Position of PIN3 field.
	GPIO_DIR_PIN3_Pos = 0x3
	// Bit mask of PIN3 field.
	GPIO_DIR_PIN3_Msk = 0x8
	// Bit PIN3.
	GPIO_DIR_PIN3 = 0x8
	// Pin set as input
	GPIO_DIR_PIN3_Input = 0x0
	// Pin set as output
	GPIO_DIR_PIN3_Output = 0x1
	// Position of PIN4 field.
	GPIO_DIR_PIN4_Pos = 0x4
	// Bit mask of PIN4 field.
	GPIO_DIR_PIN4_Msk = 0x10
	// Bit PIN4.
	GPIO_DIR_PIN4 = 0x10
	// Pin set as input
	GPIO_DIR_PIN4_Input = 0x0
	// Pin set as output
	GPIO_DIR_PIN4_Output = 0x1
	// Position of PIN5 field.
	GPIO_DIR_PIN5_Pos = 0x5
	// Bit mask of PIN5 field.
	GPIO_DIR_PIN5_Msk = 0x20
	// Bit PIN5.
	GPIO_DIR_PIN5 = 0x20
	// Pin set as input
	GPIO_DIR_PIN5_Input = 0x0
	// Pin set as output
	GPIO_DIR_PIN5_Output = 0x1
	// Position of PIN6 field.
	GPIO_DIR_PIN6_Pos = 0x6
	// Bit mask of PIN6 field.
	GPIO_DIR_PIN6_Msk = 0x40
	// Bit PIN6.
	GPIO_DIR_PIN6 = 0x40
	// Pin set as input
	GPIO_DIR_PIN6_Input = 0x0
	// Pin set as output
	GPIO_DIR_PIN6_Output = 0x1
	// Position of PIN7 field.
	GPIO_DIR_PIN7_Pos = 0x7
	// Bit mask of PIN7 field.
	GPIO_DIR_PIN7_Msk = 0x80
	// Bit PIN7.
	GPIO_DIR_PIN7 = 0x80
	// Pin set as input
	GPIO_DIR_PIN7_Input = 0x0
	// Pin set as output
	GPIO_DIR_PIN7_Output = 0x1
	// Position of PIN8 field.
	GPIO_DIR_PIN8_Pos = 0x8
	// Bit mask of PIN8 field.
	GPIO_DIR_PIN8_Msk = 0x100
	// Bit PIN8.
	GPIO_DIR_PIN8 = 0x100
	// Pin set as input
	GPIO_DIR_PIN8_Input = 0x0
	// Pin set as output
	GPIO_DIR_PIN8_Output = 0x1
	// Position of PIN9 field.
	GPIO_DIR_PIN9_Pos = 0x9
	// Bit mask of PIN9 field.
	GPIO_DIR_PIN9_Msk = 0x200
	// Bit PIN9.
	GPIO_DIR_PIN9 = 0x200
	// Pin set as input
	GPIO_DIR_PIN9_Input = 0x0
	// Pin set as output
	GPIO_DIR_PIN9_Output = 0x1
	// Position of PIN10 field.
	GPIO_DIR_PIN10_Pos = 0xa
	// Bit mask of PIN10 field.
	GPIO_DIR_PIN10_Msk = 0x400
	// Bit PIN10.
	GPIO_DIR_PIN10 = 0x400
	// Pin set as input
	GPIO_DIR_PIN10_Input = 0x0
	// Pin set as output
	GPIO_DIR_PIN10_Output = 0x1
	// Position of PIN11 field.
	GPIO_DIR_PIN11_Pos = 0xb
	// Bit mask of PIN11 field.
	GPIO_DIR_PIN11_Msk = 0x800
	// Bit PIN11.
	GPIO_DIR_PIN11 = 0x800
	// Pin set as input
	GPIO_DIR_PIN11_Input = 0x0
	// Pin set as output
	GPIO_DIR_PIN11_Output = 0x1
	// Position of PIN12 field.
	GPIO_DIR_PIN12_Pos = 0xc
	// Bit mask of PIN12 field.
	GPIO_DIR_PIN12_Msk = 0x1000
	// Bit PIN12.
	GPIO_DIR_PIN12 = 0x1000
	// Pin set as input
	GPIO_DIR_PIN12_Input = 0x0
	// Pin set as output
	GPIO_DIR_PIN12_Output = 0x1
	// Position of PIN13 field.
	GPIO_DIR_PIN13_Pos = 0xd
	// Bit mask of PIN13 field.
	GPIO_DIR_PIN13_Msk = 0x2000
	// Bit PIN13.
	GPIO_DIR_PIN13 = 0x2000
	// Pin set as input
	GPIO_DIR_PIN13_Input = 0x0
	// Pin set as output
	GPIO_DIR_PIN13_Output = 0x1
	// Position of PIN14 field.
	GPIO_DIR_PIN14_Pos = 0xe
	// Bit mask of PIN14 field.
	GPIO_DIR_PIN14_Msk = 0x4000
	// Bit PIN14.
	GPIO_DIR_PIN14 = 0x4000
	// Pin set as input
	GPIO_DIR_PIN14_Input = 0x0
	// Pin set as output
	GPIO_DIR_PIN14_Output = 0x1
	// Position of PIN15 field.
	GPIO_DIR_PIN15_Pos = 0xf
	// Bit mask of PIN15 field.
	GPIO_DIR_PIN15_Msk = 0x8000
	// Bit PIN15.
	GPIO_DIR_PIN15 = 0x8000
	// Pin set as input
	GPIO_DIR_PIN15_Input = 0x0
	// Pin set as output
	GPIO_DIR_PIN15_Output = 0x1
	// Position of PIN16 field.
	GPIO_DIR_PIN16_Pos = 0x10
	// Bit mask of PIN16 field.
	GPIO_DIR_PIN16_Msk = 0x10000
	// Bit PIN16.
	GPIO_DIR_PIN16 = 0x10000
	// Pin set as input
	GPIO_DIR_PIN16_Input = 0x0
	// Pin set as output
	GPIO_DIR_PIN16_Output = 0x1
	// Position of PIN17 field.
	GPIO_DIR_PIN17_Pos = 0x11
	// Bit mask of PIN17 field.
	GPIO_DIR_PIN17_Msk = 0x20000
	// Bit PIN17.
	GPIO_DIR_PIN17 = 0x20000
	// Pin set as input
	GPIO_DIR_PIN17_Input = 0x0
	// Pin set as output
	GPIO_DIR_PIN17_Output = 0x1
	// Position of PIN18 field.
	GPIO_DIR_PIN18_Pos = 0x12
	// Bit mask of PIN18 field.
	GPIO_DIR_PIN18_Msk = 0x40000
	// Bit PIN18.
	GPIO_DIR_PIN18 = 0x40000
	// Pin set as input
	GPIO_DIR_PIN18_Input = 0x0
	// Pin set as output
	GPIO_DIR_PIN18_Output = 0x1
	// Position of PIN19 field.
	GPIO_DIR_PIN19_Pos = 0x13
	// Bit mask of PIN19 field.
	GPIO_DIR_PIN19_Msk = 0x80000
	// Bit PIN19.
	GPIO_DIR_PIN19 = 0x80000
	// Pin set as input
	GPIO_DIR_PIN19_Input = 0x0
	// Pin set as output
	GPIO_DIR_PIN19_Output = 0x1
	// Position of PIN20 field.
	GPIO_DIR_PIN20_Pos = 0x14
	// Bit mask of PIN20 field.
	GPIO_DIR_PIN20_Msk = 0x100000
	// Bit PIN20.
	GPIO_DIR_PIN20 = 0x100000
	// Pin set as input
	GPIO_DIR_PIN20_Input = 0x0
	// Pin set as output
	GPIO_DIR_PIN20_Output = 0x1
	// Position of PIN21 field.
	GPIO_DIR_PIN21_Pos = 0x15
	// Bit mask of PIN21 field.
	GPIO_DIR_PIN21_Msk = 0x200000
	// Bit PIN21.
	GPIO_DIR_PIN21 = 0x200000
	// Pin set as input
	GPIO_DIR_PIN21_Input = 0x0
	// Pin set as output
	GPIO_DIR_PIN21_Output = 0x1
	// Position of PIN22 field.
	GPIO_DIR_PIN22_Pos = 0x16
	// Bit mask of PIN22 field.
	GPIO_DIR_PIN22_Msk = 0x400000
	// Bit PIN22.
	GPIO_DIR_PIN22 = 0x400000
	// Pin set as input
	GPIO_DIR_PIN22_Input = 0x0
	// Pin set as output
	GPIO_DIR_PIN22_Output = 0x1
	// Position of PIN23 field.
	GPIO_DIR_PIN23_Pos = 0x17
	// Bit mask of PIN23 field.
	GPIO_DIR_PIN23_Msk = 0x800000
	// Bit PIN23.
	GPIO_DIR_PIN23 = 0x800000
	// Pin set as input
	GPIO_DIR_PIN23_Input = 0x0
	// Pin set as output
	GPIO_DIR_PIN23_Output = 0x1
	// Position of PIN24 field.
	GPIO_DIR_PIN24_Pos = 0x18
	// Bit mask of PIN24 field.
	GPIO_DIR_PIN24_Msk = 0x1000000
	// Bit PIN24.
	GPIO_DIR_PIN24 = 0x1000000
	// Pin set as input
	GPIO_DIR_PIN24_Input = 0x0
	// Pin set as output
	GPIO_DIR_PIN24_Output = 0x1
	// Position of PIN25 field.
	GPIO_DIR_PIN25_Pos = 0x19
	// Bit mask of PIN25 field.
	GPIO_DIR_PIN25_Msk = 0x2000000
	// Bit PIN25.
	GPIO_DIR_PIN25 = 0x2000000
	// Pin set as input
	GPIO_DIR_PIN25_Input = 0x0
	// Pin set as output
	GPIO_DIR_PIN25_Output = 0x1
	// Position of PIN26 field.
	GPIO_DIR_PIN26_Pos = 0x1a
	// Bit mask of PIN26 field.
	GPIO_DIR_PIN26_Msk = 0x4000000
	// Bit PIN26.
	GPIO_DIR_PIN26 = 0x4000000
	// Pin set as input
	GPIO_DIR_PIN26_Input = 0x0
	// Pin set as output
	GPIO_DIR_PIN26_Output = 0x1
	// Position of PIN27 field.
	GPIO_DIR_PIN27_Pos = 0x1b
	// Bit mask of PIN27 field.
	GPIO_DIR_PIN27_Msk = 0x8000000
	// Bit PIN27.
	GPIO_DIR_PIN27 = 0x8000000
	// Pin set as input
	GPIO_DIR_PIN27_Input = 0x0
	// Pin set as output
	GPIO_DIR_PIN27_Output = 0x1
	// Position of PIN28 field.
	GPIO_DIR_PIN28_Pos = 0x1c
	// Bit mask of PIN28 field.
	GPIO_DIR_PIN28_Msk = 0x10000000
	// Bit PIN28.
	GPIO_DIR_PIN28 = 0x10000000
	// Pin set as input
	GPIO_DIR_PIN28_Input = 0x0
	// Pin set as output
	GPIO_DIR_PIN28_Output = 0x1
	// Position of PIN29 field.
	GPIO_DIR_PIN29_Pos = 0x1d
	// Bit mask of PIN29 field.
	GPIO_DIR_PIN29_Msk = 0x20000000
	// Bit PIN29.
	GPIO_DIR_PIN29 = 0x20000000
	// Pin set as input
	GPIO_DIR_PIN29_Input = 0x0
	// Pin set as output
	GPIO_DIR_PIN29_Output = 0x1
	// Position of PIN30 field.
	GPIO_DIR_PIN30_Pos = 0x1e
	// Bit mask of PIN30 field.
	GPIO_DIR_PIN30_Msk = 0x40000000
	// Bit PIN30.
	GPIO_DIR_PIN30 = 0x40000000
	// Pin set as input
	GPIO_DIR_PIN30_Input = 0x0
	// Pin set as output
	GPIO_DIR_PIN30_Output = 0x1
	// Position of PIN31 field.
	GPIO_DIR_PIN31_Pos = 0x1f
	// Bit mask of PIN31 field.
	GPIO_DIR_PIN31_Msk = 0x80000000
	// Bit PIN31.
	GPIO_DIR_PIN31 = 0x80000000
	// Pin set as input
	GPIO_DIR_PIN31_Input = 0x0
	// Pin set as output
	GPIO_DIR_PIN31_Output = 0x1

	// DIRSET: DIR set register
	// Position of PIN0 field.
	GPIO_DIRSET_PIN0_Pos = 0x0
	// Bit mask of PIN0 field.
	GPIO_DIRSET_PIN0_Msk = 0x1
	// Bit PIN0.
	GPIO_DIRSET_PIN0 = 0x1
	// Read: pin set as input
	GPIO_DIRSET_PIN0_Input = 0x0
	// Read: pin set as output
	GPIO_DIRSET_PIN0_Output = 0x1
	// Write: writing a '1' sets pin to output; writing a '0' has no effect
	GPIO_DIRSET_PIN0_Set = 0x1
	// Position of PIN1 field.
	GPIO_DIRSET_PIN1_Pos = 0x1
	// Bit mask of PIN1 field.
	GPIO_DIRSET_PIN1_Msk = 0x2
	// Bit PIN1.
	GPIO_DIRSET_PIN1 = 0x2
	// Read: pin set as input
	GPIO_DIRSET_PIN1_Input = 0x0
	// Read: pin set as output
	GPIO_DIRSET_PIN1_Output = 0x1
	// Write: writing a '1' sets pin to output; writing a '0' has no effect
	GPIO_DIRSET_PIN1_Set = 0x1
	// Position of PIN2 field.
	GPIO_DIRSET_PIN2_Pos = 0x2
	// Bit mask of PIN2 field.
	GPIO_DIRSET_PIN2_Msk = 0x4
	// Bit PIN2.
	GPIO_DIRSET_PIN2 = 0x4
	// Read: pin set as input
	GPIO_DIRSET_PIN2_Input = 0x0
	// Read: pin set as output
	GPIO_DIRSET_PIN2_Output = 0x1
	// Write: writing a '1' sets pin to output; writing a '0' has no effect
	GPIO_DIRSET_PIN2_Set = 0x1
	// Position of PIN3 field.
	GPIO_DIRSET_PIN3_Pos = 0x3
	// Bit mask of PIN3 field.
	GPIO_DIRSET_PIN3_Msk = 0x8
	// Bit PIN3.
	GPIO_DIRSET_PIN3 = 0x8
	// Read: pin set as input
	GPIO_DIRSET_PIN3_Input = 0x0
	// Read: pin set as output
	GPIO_DIRSET_PIN3_Output = 0x1
	// Write: writing a '1' sets pin to output; writing a '0' has no effect
	GPIO_DIRSET_PIN3_Set = 0x1
	// Position of PIN4 field.
	GPIO_DIRSET_PIN4_Pos = 0x4
	// Bit mask of PIN4 field.
	GPIO_DIRSET_PIN4_Msk = 0x10
	// Bit PIN4.
	GPIO_DIRSET_PIN4 = 0x10
	// Read: pin set as input
	GPIO_DIRSET_PIN4_Input = 0x0
	// Read: pin set as output
	GPIO_DIRSET_PIN4_Output = 0x1
	// Write: writing a '1' sets pin to output; writing a '0' has no effect
	GPIO_DIRSET_PIN4_Set = 0x1
	// Position of PIN5 field.
	GPIO_DIRSET_PIN5_Pos = 0x5
	// Bit mask of PIN5 field.
	GPIO_DIRSET_PIN5_Msk = 0x20
	// Bit PIN5.
	GPIO_DIRSET_PIN5 = 0x20
	// Read: pin set as input
	GPIO_DIRSET_PIN5_Input = 0x0
	// Read: pin set as output
	GPIO_DIRSET_PIN5_Output = 0x1
	// Write: writing a '1' sets pin to output; writing a '0' has no effect
	GPIO_DIRSET_PIN5_Set = 0x1
	// Position of PIN6 field.
	GPIO_DIRSET_PIN6_Pos = 0x6
	// Bit mask of PIN6 field.
	GPIO_DIRSET_PIN6_Msk = 0x40
	// Bit PIN6.
	GPIO_DIRSET_PIN6 = 0x40
	// Read: pin set as input
	GPIO_DIRSET_PIN6_Input = 0x0
	// Read: pin set as output
	GPIO_DIRSET_PIN6_Output = 0x1
	// Write: writing a '1' sets pin to output; writing a '0' has no effect
	GPIO_DIRSET_PIN6_Set = 0x1
	// Position of PIN7 field.
	GPIO_DIRSET_PIN7_Pos = 0x7
	// Bit mask of PIN7 field.
	GPIO_DIRSET_PIN7_Msk = 0x80
	// Bit PIN7.
	GPIO_DIRSET_PIN7 = 0x80
	// Read: pin set as input
	GPIO_DIRSET_PIN7_Input = 0x0
	// Read: pin set as output
	GPIO_DIRSET_PIN7_Output = 0x1
	// Write: writing a '1' sets pin to output; writing a '0' has no effect
	GPIO_DIRSET_PIN7_Set = 0x1
	// Position of PIN8 field.
	GPIO_DIRSET_PIN8_Pos = 0x8
	// Bit mask of PIN8 field.
	GPIO_DIRSET_PIN8_Msk = 0x100
	// Bit PIN8.
	GPIO_DIRSET_PIN8 = 0x100
	// Read: pin set as input
	GPIO_DIRSET_PIN8_Input = 0x0
	// Read: pin set as output
	GPIO_DIRSET_PIN8_Output = 0x1
	// Write: writing a '1' sets pin to output; writing a '0' has no effect
	GPIO_DIRSET_PIN8_Set = 0x1
	// Position of PIN9 field.
	GPIO_DIRSET_PIN9_Pos = 0x9
	// Bit mask of PIN9 field.
	GPIO_DIRSET_PIN9_Msk = 0x200
	// Bit PIN9.
	GPIO_DIRSET_PIN9 = 0x200
	// Read: pin set as input
	GPIO_DIRSET_PIN9_Input = 0x0
	// Read: pin set as output
	GPIO_DIRSET_PIN9_Output = 0x1
	// Write: writing a '1' sets pin to output; writing a '0' has no effect
	GPIO_DIRSET_PIN9_Set = 0x1
	// Position of PIN10 field.
	GPIO_DIRSET_PIN10_Pos = 0xa
	// Bit mask of PIN10 field.
	GPIO_DIRSET_PIN10_Msk = 0x400
	// Bit PIN10.
	GPIO_DIRSET_PIN10 = 0x400
	// Read: pin set as input
	GPIO_DIRSET_PIN10_Input = 0x0
	// Read: pin set as output
	GPIO_DIRSET_PIN10_Output = 0x1
	// Write: writing a '1' sets pin to output; writing a '0' has no effect
	GPIO_DIRSET_PIN10_Set = 0x1
	// Position of PIN11 field.
	GPIO_DIRSET_PIN11_Pos = 0xb
	// Bit mask of PIN11 field.
	GPIO_DIRSET_PIN11_Msk = 0x800
	// Bit PIN11.
	GPIO_DIRSET_PIN11 = 0x800
	// Read: pin set as input
	GPIO_DIRSET_PIN11_Input = 0x0
	// Read: pin set as output
	GPIO_DIRSET_PIN11_Output = 0x1
	// Write: writing a '1' sets pin to output; writing a '0' has no effect
	GPIO_DIRSET_PIN11_Set = 0x1
	// Position of PIN12 field.
	GPIO_DIRSET_PIN12_Pos = 0xc
	// Bit mask of PIN12 field.
	GPIO_DIRSET_PIN12_Msk = 0x1000
	// Bit PIN12.
	GPIO_DIRSET_PIN12 = 0x1000
	// Read: pin set as input
	GPIO_DIRSET_PIN12_Input = 0x0
	// Read: pin set as output
	GPIO_DIRSET_PIN12_Output = 0x1
	// Write: writing a '1' sets pin to output; writing a '0' has no effect
	GPIO_DIRSET_PIN12_Set = 0x1
	// Position of PIN13 field.
	GPIO_DIRSET_PIN13_Pos = 0xd
	// Bit mask of PIN13 field.
	GPIO_DIRSET_PIN13_Msk = 0x2000
	// Bit PIN13.
	GPIO_DIRSET_PIN13 = 0x2000
	// Read: pin set as input
	GPIO_DIRSET_PIN13_Input = 0x0
	// Read: pin set as output
	GPIO_DIRSET_PIN13_Output = 0x1
	// Write: writing a '1' sets pin to output; writing a '0' has no effect
	GPIO_DIRSET_PIN13_Set = 0x1
	// Position of PIN14 field.
	GPIO_DIRSET_PIN14_Pos = 0xe
	// Bit mask of PIN14 field.
	GPIO_DIRSET_PIN14_Msk = 0x4000
	// Bit PIN14.
	GPIO_DIRSET_PIN14 = 0x4000
	// Read: pin set as input
	GPIO_DIRSET_PIN14_Input = 0x0
	// Read: pin set as output
	GPIO_DIRSET_PIN14_Output = 0x1
	// Write: writing a '1' sets pin to output; writing a '0' has no effect
	GPIO_DIRSET_PIN14_Set = 0x1
	// Position of PIN15 field.
	GPIO_DIRSET_PIN15_Pos = 0xf
	// Bit mask of PIN15 field.
	GPIO_DIRSET_PIN15_Msk = 0x8000
	// Bit PIN15.
	GPIO_DIRSET_PIN15 = 0x8000
	// Read: pin set as input
	GPIO_DIRSET_PIN15_Input = 0x0
	// Read: pin set as output
	GPIO_DIRSET_PIN15_Output = 0x1
	// Write: writing a '1' sets pin to output; writing a '0' has no effect
	GPIO_DIRSET_PIN15_Set = 0x1
	// Position of PIN16 field.
	GPIO_DIRSET_PIN16_Pos = 0x10
	// Bit mask of PIN16 field.
	GPIO_DIRSET_PIN16_Msk = 0x10000
	// Bit PIN16.
	GPIO_DIRSET_PIN16 = 0x10000
	// Read: pin set as input
	GPIO_DIRSET_PIN16_Input = 0x0
	// Read: pin set as output
	GPIO_DIRSET_PIN16_Output = 0x1
	// Write: writing a '1' sets pin to output; writing a '0' has no effect
	GPIO_DIRSET_PIN16_Set = 0x1
	// Position of PIN17 field.
	GPIO_DIRSET_PIN17_Pos = 0x11
	// Bit mask of PIN17 field.
	GPIO_DIRSET_PIN17_Msk = 0x20000
	// Bit PIN17.
	GPIO_DIRSET_PIN17 = 0x20000
	// Read: pin set as input
	GPIO_DIRSET_PIN17_Input = 0x0
	// Read: pin set as output
	GPIO_DIRSET_PIN17_Output = 0x1
	// Write: writing a '1' sets pin to output; writing a '0' has no effect
	GPIO_DIRSET_PIN17_Set = 0x1
	// Position of PIN18 field.
	GPIO_DIRSET_PIN18_Pos = 0x12
	// Bit mask of PIN18 field.
	GPIO_DIRSET_PIN18_Msk = 0x40000
	// Bit PIN18.
	GPIO_DIRSET_PIN18 = 0x40000
	// Read: pin set as input
	GPIO_DIRSET_PIN18_Input = 0x0
	// Read: pin set as output
	GPIO_DIRSET_PIN18_Output = 0x1
	// Write: writing a '1' sets pin to output; writing a '0' has no effect
	GPIO_DIRSET_PIN18_Set = 0x1
	// Position of PIN19 field.
	GPIO_DIRSET_PIN19_Pos = 0x13
	// Bit mask of PIN19 field.
	GPIO_DIRSET_PIN19_Msk = 0x80000
	// Bit PIN19.
	GPIO_DIRSET_PIN19 = 0x80000
	// Read: pin set as input
	GPIO_DIRSET_PIN19_Input = 0x0
	// Read: pin set as output
	GPIO_DIRSET_PIN19_Output = 0x1
	// Write: writing a '1' sets pin to output; writing a '0' has no effect
	GPIO_DIRSET_PIN19_Set = 0x1
	// Position of PIN20 field.
	GPIO_DIRSET_PIN20_Pos = 0x14
	// Bit mask of PIN20 field.
	GPIO_DIRSET_PIN20_Msk = 0x100000
	// Bit PIN20.
	GPIO_DIRSET_PIN20 = 0x100000
	// Read: pin set as input
	GPIO_DIRSET_PIN20_Input = 0x0
	// Read: pin set as output
	GPIO_DIRSET_PIN20_Output = 0x1
	// Write: writing a '1' sets pin to output; writing a '0' has no effect
	GPIO_DIRSET_PIN20_Set = 0x1
	// Position of PIN21 field.
	GPIO_DIRSET_PIN21_Pos = 0x15
	// Bit mask of PIN21 field.
	GPIO_DIRSET_PIN21_Msk = 0x200000
	// Bit PIN21.
	GPIO_DIRSET_PIN21 = 0x200000
	// Read: pin set as input
	GPIO_DIRSET_PIN21_Input = 0x0
	// Read: pin set as output
	GPIO_DIRSET_PIN21_Output = 0x1
	// Write: writing a '1' sets pin to output; writing a '0' has no effect
	GPIO_DIRSET_PIN21_Set = 0x1
	// Position of PIN22 field.
	GPIO_DIRSET_PIN22_Pos = 0x16
	// Bit mask of PIN22 field.
	GPIO_DIRSET_PIN22_Msk = 0x400000
	// Bit PIN22.
	GPIO_DIRSET_PIN22 = 0x400000
	// Read: pin set as input
	GPIO_DIRSET_PIN22_Input = 0x0
	// Read: pin set as output
	GPIO_DIRSET_PIN22_Output = 0x1
	// Write: writing a '1' sets pin to output; writing a '0' has no effect
	GPIO_DIRSET_PIN22_Set = 0x1
	// Position of PIN23 field.
	GPIO_DIRSET_PIN23_Pos = 0x17
	// Bit mask of PIN23 field.
	GPIO_DIRSET_PIN23_Msk = 0x800000
	// Bit PIN23.
	GPIO_DIRSET_PIN23 = 0x800000
	// Read: pin set as input
	GPIO_DIRSET_PIN23_Input = 0x0
	// Read: pin set as output
	GPIO_DIRSET_PIN23_Output = 0x1
	// Write: writing a '1' sets pin to output; writing a '0' has no effect
	GPIO_DIRSET_PIN23_Set = 0x1
	// Position of PIN24 field.
	GPIO_DIRSET_PIN24_Pos = 0x18
	// Bit mask of PIN24 field.
	GPIO_DIRSET_PIN24_Msk = 0x1000000
	// Bit PIN24.
	GPIO_DIRSET_PIN24 = 0x1000000
	// Read: pin set as input
	GPIO_DIRSET_PIN24_Input = 0x0
	// Read: pin set as output
	GPIO_DIRSET_PIN24_Output = 0x1
	// Write: writing a '1' sets pin to output; writing a '0' has no effect
	GPIO_DIRSET_PIN24_Set = 0x1
	// Position of PIN25 field.
	GPIO_DIRSET_PIN25_Pos = 0x19
	// Bit mask of PIN25 field.
	GPIO_DIRSET_PIN25_Msk = 0x2000000
	// Bit PIN25.
	GPIO_DIRSET_PIN25 = 0x2000000
	// Read: pin set as input
	GPIO_DIRSET_PIN25_Input = 0x0
	// Read: pin set as output
	GPIO_DIRSET_PIN25_Output = 0x1
	// Write: writing a '1' sets pin to output; writing a '0' has no effect
	GPIO_DIRSET_PIN25_Set = 0x1
	// Position of PIN26 field.
	GPIO_DIRSET_PIN26_Pos = 0x1a
	// Bit mask of PIN26 field.
	GPIO_DIRSET_PIN26_Msk = 0x4000000
	// Bit PIN26.
	GPIO_DIRSET_PIN26 = 0x4000000
	// Read: pin set as input
	GPIO_DIRSET_PIN26_Input = 0x0
	// Read: pin set as output
	GPIO_DIRSET_PIN26_Output = 0x1
	// Write: writing a '1' sets pin to output; writing a '0' has no effect
	GPIO_DIRSET_PIN26_Set = 0x1
	// Position of PIN27 field.
	GPIO_DIRSET_PIN27_Pos = 0x1b
	// Bit mask of PIN27 field.
	GPIO_DIRSET_PIN27_Msk = 0x8000000
	// Bit PIN27.
	GPIO_DIRSET_PIN27 = 0x8000000
	// Read: pin set as input
	GPIO_DIRSET_PIN27_Input = 0x0
	// Read: pin set as output
	GPIO_DIRSET_PIN27_Output = 0x1
	// Write: writing a '1' sets pin to output; writing a '0' has no effect
	GPIO_DIRSET_PIN27_Set = 0x1
	// Position of PIN28 field.
	GPIO_DIRSET_PIN28_Pos = 0x1c
	// Bit mask of PIN28 field.
	GPIO_DIRSET_PIN28_Msk = 0x10000000
	// Bit PIN28.
	GPIO_DIRSET_PIN28 = 0x10000000
	// Read: pin set as input
	GPIO_DIRSET_PIN28_Input = 0x0
	// Read: pin set as output
	GPIO_DIRSET_PIN28_Output = 0x1
	// Write: writing a '1' sets pin to output; writing a '0' has no effect
	GPIO_DIRSET_PIN28_Set = 0x1
	// Position of PIN29 field.
	GPIO_DIRSET_PIN29_Pos = 0x1d
	// Bit mask of PIN29 field.
	GPIO_DIRSET_PIN29_Msk = 0x20000000
	// Bit PIN29.
	GPIO_DIRSET_PIN29 = 0x20000000
	// Read: pin set as input
	GPIO_DIRSET_PIN29_Input = 0x0
	// Read: pin set as output
	GPIO_DIRSET_PIN29_Output = 0x1
	// Write: writing a '1' sets pin to output; writing a '0' has no effect
	GPIO_DIRSET_PIN29_Set = 0x1
	// Position of PIN30 field.
	GPIO_DIRSET_PIN30_Pos = 0x1e
	// Bit mask of PIN30 field.
	GPIO_DIRSET_PIN30_Msk = 0x40000000
	// Bit PIN30.
	GPIO_DIRSET_PIN30 = 0x40000000
	// Read: pin set as input
	GPIO_DIRSET_PIN30_Input = 0x0
	// Read: pin set as output
	GPIO_DIRSET_PIN30_Output = 0x1
	// Write: writing a '1' sets pin to output; writing a '0' has no effect
	GPIO_DIRSET_PIN30_Set = 0x1
	// Position of PIN31 field.
	GPIO_DIRSET_PIN31_Pos = 0x1f
	// Bit mask of PIN31 field.
	GPIO_DIRSET_PIN31_Msk = 0x80000000
	// Bit PIN31.
	GPIO_DIRSET_PIN31 = 0x80000000
	// Read: pin set as input
	GPIO_DIRSET_PIN31_Input = 0x0
	// Read: pin set as output
	GPIO_DIRSET_PIN31_Output = 0x1
	// Write: writing a '1' sets pin to output; writing a '0' has no effect
	GPIO_DIRSET_PIN31_Set = 0x1

	// DIRCLR: DIR clear register
	// Position of PIN0 field.
	GPIO_DIRCLR_PIN0_Pos = 0x0
	// Bit mask of PIN0 field.
	GPIO_DIRCLR_PIN0_Msk = 0x1
	// Bit PIN0.
	GPIO_DIRCLR_PIN0 = 0x1
	// Read: pin set as input
	GPIO_DIRCLR_PIN0_Input = 0x0
	// Read: pin set as output
	GPIO_DIRCLR_PIN0_Output = 0x1
	// Write: writing a '1' sets pin to input; writing a '0' has no effect
	GPIO_DIRCLR_PIN0_Clear = 0x1
	// Position of PIN1 field.
	GPIO_DIRCLR_PIN1_Pos = 0x1
	// Bit mask of PIN1 field.
	GPIO_DIRCLR_PIN1_Msk = 0x2
	// Bit PIN1.
	GPIO_DIRCLR_PIN1 = 0x2
	// Read: pin set as input
	GPIO_DIRCLR_PIN1_Input = 0x0
	// Read: pin set as output
	GPIO_DIRCLR_PIN1_Output = 0x1
	// Write: writing a '1' sets pin to input; writing a '0' has no effect
	GPIO_DIRCLR_PIN1_Clear = 0x1
	// Position of PIN2 field.
	GPIO_DIRCLR_PIN2_Pos = 0x2
	// Bit mask of PIN2 field.
	GPIO_DIRCLR_PIN2_Msk = 0x4
	// Bit PIN2.
	GPIO_DIRCLR_PIN2 = 0x4
	// Read: pin set as input
	GPIO_DIRCLR_PIN2_Input = 0x0
	// Read: pin set as output
	GPIO_DIRCLR_PIN2_Output = 0x1
	// Write: writing a '1' sets pin to input; writing a '0' has no effect
	GPIO_DIRCLR_PIN2_Clear = 0x1
	// Position of PIN3 field.
	GPIO_DIRCLR_PIN3_Pos = 0x3
	// Bit mask of PIN3 field.
	GPIO_DIRCLR_PIN3_Msk = 0x8
	// Bit PIN3.
	GPIO_DIRCLR_PIN3 = 0x8
	// Read: pin set as input
	GPIO_DIRCLR_PIN3_Input = 0x0
	// Read: pin set as output
	GPIO_DIRCLR_PIN3_Output = 0x1
	// Write: writing a '1' sets pin to input; writing a '0' has no effect
	GPIO_DIRCLR_PIN3_Clear = 0x1
	// Position of PIN4 field.
	GPIO_DIRCLR_PIN4_Pos = 0x4
	// Bit mask of PIN4 field.
	GPIO_DIRCLR_PIN4_Msk = 0x10
	// Bit PIN4.
	GPIO_DIRCLR_PIN4 = 0x10
	// Read: pin set as input
	GPIO_DIRCLR_PIN4_Input = 0x0
	// Read: pin set as output
	GPIO_DIRCLR_PIN4_Output = 0x1
	// Write: writing a '1' sets pin to input; writing a '0' has no effect
	GPIO_DIRCLR_PIN4_Clear = 0x1
	// Position of PIN5 field.
	GPIO_DIRCLR_PIN5_Pos = 0x5
	// Bit mask of PIN5 field.
	GPIO_DIRCLR_PIN5_Msk = 0x20
	// Bit PIN5.
	GPIO_DIRCLR_PIN5 = 0x20
	// Read: pin set as input
	GPIO_DIRCLR_PIN5_Input = 0x0
	// Read: pin set as output
	GPIO_DIRCLR_PIN5_Output = 0x1
	// Write: writing a '1' sets pin to input; writing a '0' has no effect
	GPIO_DIRCLR_PIN5_Clear = 0x1
	// Position of PIN6 field.
	GPIO_DIRCLR_PIN6_Pos = 0x6
	// Bit mask of PIN6 field.
	GPIO_DIRCLR_PIN6_Msk = 0x40
	// Bit PIN6.
	GPIO_DIRCLR_PIN6 = 0x40
	// Read: pin set as input
	GPIO_DIRCLR_PIN6_Input = 0x0
	// Read: pin set as output
	GPIO_DIRCLR_PIN6_Output = 0x1
	// Write: writing a '1' sets pin to input; writing a '0' has no effect
	GPIO_DIRCLR_PIN6_Clear = 0x1
	// Position of PIN7 field.
	GPIO_DIRCLR_PIN7_Pos = 0x7
	// Bit mask of PIN7 field.
	GPIO_DIRCLR_PIN7_Msk = 0x80
	// Bit PIN7.
	GPIO_DIRCLR_PIN7 = 0x80
	// Read: pin set as input
	GPIO_DIRCLR_PIN7_Input = 0x0
	// Read: pin set as output
	GPIO_DIRCLR_PIN7_Output = 0x1
	// Write: writing a '1' sets pin to input; writing a '0' has no effect
	GPIO_DIRCLR_PIN7_Clear = 0x1
	// Position of PIN8 field.
	GPIO_DIRCLR_PIN8_Pos = 0x8
	// Bit mask of PIN8 field.
	GPIO_DIRCLR_PIN8_Msk = 0x100
	// Bit PIN8.
	GPIO_DIRCLR_PIN8 = 0x100
	// Read: pin set as input
	GPIO_DIRCLR_PIN8_Input = 0x0
	// Read: pin set as output
	GPIO_DIRCLR_PIN8_Output = 0x1
	// Write: writing a '1' sets pin to input; writing a '0' has no effect
	GPIO_DIRCLR_PIN8_Clear = 0x1
	// Position of PIN9 field.
	GPIO_DIRCLR_PIN9_Pos = 0x9
	// Bit mask of PIN9 field.
	GPIO_DIRCLR_PIN9_Msk = 0x200
	// Bit PIN9.
	GPIO_DIRCLR_PIN9 = 0x200
	// Read: pin set as input
	GPIO_DIRCLR_PIN9_Input = 0x0
	// Read: pin set as output
	GPIO_DIRCLR_PIN9_Output = 0x1
	// Write: writing a '1' sets pin to input; writing a '0' has no effect
	GPIO_DIRCLR_PIN9_Clear = 0x1
	// Position of PIN10 field.
	GPIO_DIRCLR_PIN10_Pos = 0xa
	// Bit mask of PIN10 field.
	GPIO_DIRCLR_PIN10_Msk = 0x400
	// Bit PIN10.
	GPIO_DIRCLR_PIN10 = 0x400
	// Read: pin set as input
	GPIO_DIRCLR_PIN10_Input = 0x0
	// Read: pin set as output
	GPIO_DIRCLR_PIN10_Output = 0x1
	// Write: writing a '1' sets pin to input; writing a '0' has no effect
	GPIO_DIRCLR_PIN10_Clear = 0x1
	// Position of PIN11 field.
	GPIO_DIRCLR_PIN11_Pos = 0xb
	// Bit mask of PIN11 field.
	GPIO_DIRCLR_PIN11_Msk = 0x800
	// Bit PIN11.
	GPIO_DIRCLR_PIN11 = 0x800
	// Read: pin set as input
	GPIO_DIRCLR_PIN11_Input = 0x0
	// Read: pin set as output
	GPIO_DIRCLR_PIN11_Output = 0x1
	// Write: writing a '1' sets pin to input; writing a '0' has no effect
	GPIO_DIRCLR_PIN11_Clear = 0x1
	// Position of PIN12 field.
	GPIO_DIRCLR_PIN12_Pos = 0xc
	// Bit mask of PIN12 field.
	GPIO_DIRCLR_PIN12_Msk = 0x1000
	// Bit PIN12.
	GPIO_DIRCLR_PIN12 = 0x1000
	// Read: pin set as input
	GPIO_DIRCLR_PIN12_Input = 0x0
	// Read: pin set as output
	GPIO_DIRCLR_PIN12_Output = 0x1
	// Write: writing a '1' sets pin to input; writing a '0' has no effect
	GPIO_DIRCLR_PIN12_Clear = 0x1
	// Position of PIN13 field.
	GPIO_DIRCLR_PIN13_Pos = 0xd
	// Bit mask of PIN13 field.
	GPIO_DIRCLR_PIN13_Msk = 0x2000
	// Bit PIN13.
	GPIO_DIRCLR_PIN13 = 0x2000
	// Read: pin set as input
	GPIO_DIRCLR_PIN13_Input = 0x0
	// Read: pin set as output
	GPIO_DIRCLR_PIN13_Output = 0x1
	// Write: writing a '1' sets pin to input; writing a '0' has no effect
	GPIO_DIRCLR_PIN13_Clear = 0x1
	// Position of PIN14 field.
	GPIO_DIRCLR_PIN14_Pos = 0xe
	// Bit mask of PIN14 field.
	GPIO_DIRCLR_PIN14_Msk = 0x4000
	// Bit PIN14.
	GPIO_DIRCLR_PIN14 = 0x4000
	// Read: pin set as input
	GPIO_DIRCLR_PIN14_Input = 0x0
	// Read: pin set as output
	GPIO_DIRCLR_PIN14_Output = 0x1
	// Write: writing a '1' sets pin to input; writing a '0' has no effect
	GPIO_DIRCLR_PIN14_Clear = 0x1
	// Position of PIN15 field.
	GPIO_DIRCLR_PIN15_Pos = 0xf
	// Bit mask of PIN15 field.
	GPIO_DIRCLR_PIN15_Msk = 0x8000
	// Bit PIN15.
	GPIO_DIRCLR_PIN15 = 0x8000
	// Read: pin set as input
	GPIO_DIRCLR_PIN15_Input = 0x0
	// Read: pin set as output
	GPIO_DIRCLR_PIN15_Output = 0x1
	// Write: writing a '1' sets pin to input; writing a '0' has no effect
	GPIO_DIRCLR_PIN15_Clear = 0x1
	// Position of PIN16 field.
	GPIO_DIRCLR_PIN16_Pos = 0x10
	// Bit mask of PIN16 field.
	GPIO_DIRCLR_PIN16_Msk = 0x10000
	// Bit PIN16.
	GPIO_DIRCLR_PIN16 = 0x10000
	// Read: pin set as input
	GPIO_DIRCLR_PIN16_Input = 0x0
	// Read: pin set as output
	GPIO_DIRCLR_PIN16_Output = 0x1
	// Write: writing a '1' sets pin to input; writing a '0' has no effect
	GPIO_DIRCLR_PIN16_Clear = 0x1
	// Position of PIN17 field.
	GPIO_DIRCLR_PIN17_Pos = 0x11
	// Bit mask of PIN17 field.
	GPIO_DIRCLR_PIN17_Msk = 0x20000
	// Bit PIN17.
	GPIO_DIRCLR_PIN17 = 0x20000
	// Read: pin set as input
	GPIO_DIRCLR_PIN17_Input = 0x0
	// Read: pin set as output
	GPIO_DIRCLR_PIN17_Output = 0x1
	// Write: writing a '1' sets pin to input; writing a '0' has no effect
	GPIO_DIRCLR_PIN17_Clear = 0x1
	// Position of PIN18 field.
	GPIO_DIRCLR_PIN18_Pos = 0x12
	// Bit mask of PIN18 field.
	GPIO_DIRCLR_PIN18_Msk = 0x40000
	// Bit PIN18.
	GPIO_DIRCLR_PIN18 = 0x40000
	// Read: pin set as input
	GPIO_DIRCLR_PIN18_Input = 0x0
	// Read: pin set as output
	GPIO_DIRCLR_PIN18_Output = 0x1
	// Write: writing a '1' sets pin to input; writing a '0' has no effect
	GPIO_DIRCLR_PIN18_Clear = 0x1
	// Position of PIN19 field.
	GPIO_DIRCLR_PIN19_Pos = 0x13
	// Bit mask of PIN19 field.
	GPIO_DIRCLR_PIN19_Msk = 0x80000
	// Bit PIN19.
	GPIO_DIRCLR_PIN19 = 0x80000
	// Read: pin set as input
	GPIO_DIRCLR_PIN19_Input = 0x0
	// Read: pin set as output
	GPIO_DIRCLR_PIN19_Output = 0x1
	// Write: writing a '1' sets pin to input; writing a '0' has no effect
	GPIO_DIRCLR_PIN19_Clear = 0x1
	// Position of PIN20 field.
	GPIO_DIRCLR_PIN20_Pos = 0x14
	// Bit mask of PIN20 field.
	GPIO_DIRCLR_PIN20_Msk = 0x100000
	// Bit PIN20.
	GPIO_DIRCLR_PIN20 = 0x100000
	// Read: pin set as input
	GPIO_DIRCLR_PIN20_Input = 0x0
	// Read: pin set as output
	GPIO_DIRCLR_PIN20_Output = 0x1
	// Write: writing a '1' sets pin to input; writing a '0' has no effect
	GPIO_DIRCLR_PIN20_Clear = 0x1
	// Position of PIN21 field.
	GPIO_DIRCLR_PIN21_Pos = 0x15
	// Bit mask of PIN21 field.
	GPIO_DIRCLR_PIN21_Msk = 0x200000
	// Bit PIN21.
	GPIO_DIRCLR_PIN21 = 0x200000
	// Read: pin set as input
	GPIO_DIRCLR_PIN21_Input = 0x0
	// Read: pin set as output
	GPIO_DIRCLR_PIN21_Output = 0x1
	// Write: writing a '1' sets pin to input; writing a '0' has no effect
	GPIO_DIRCLR_PIN21_Clear = 0x1
	// Position of PIN22 field.
	GPIO_DIRCLR_PIN22_Pos = 0x16
	// Bit mask of PIN22 field.
	GPIO_DIRCLR_PIN22_Msk = 0x400000
	// Bit PIN22.
	GPIO_DIRCLR_PIN22 = 0x400000
	// Read: pin set as input
	GPIO_DIRCLR_PIN22_Input = 0x0
	// Read: pin set as output
	GPIO_DIRCLR_PIN22_Output = 0x1
	// Write: writing a '1' sets pin to input; writing a '0' has no effect
	GPIO_DIRCLR_PIN22_Clear = 0x1
	// Position of PIN23 field.
	GPIO_DIRCLR_PIN23_Pos = 0x17
	// Bit mask of PIN23 field.
	GPIO_DIRCLR_PIN23_Msk = 0x800000
	// Bit PIN23.
	GPIO_DIRCLR_PIN23 = 0x800000
	// Read: pin set as input
	GPIO_DIRCLR_PIN23_Input = 0x0
	// Read: pin set as output
	GPIO_DIRCLR_PIN23_Output = 0x1
	// Write: writing a '1' sets pin to input; writing a '0' has no effect
	GPIO_DIRCLR_PIN23_Clear = 0x1
	// Position of PIN24 field.
	GPIO_DIRCLR_PIN24_Pos = 0x18
	// Bit mask of PIN24 field.
	GPIO_DIRCLR_PIN24_Msk = 0x1000000
	// Bit PIN24.
	GPIO_DIRCLR_PIN24 = 0x1000000
	// Read: pin set as input
	GPIO_DIRCLR_PIN24_Input = 0x0
	// Read: pin set as output
	GPIO_DIRCLR_PIN24_Output = 0x1
	// Write: writing a '1' sets pin to input; writing a '0' has no effect
	GPIO_DIRCLR_PIN24_Clear = 0x1
	// Position of PIN25 field.
	GPIO_DIRCLR_PIN25_Pos = 0x19
	// Bit mask of PIN25 field.
	GPIO_DIRCLR_PIN25_Msk = 0x2000000
	// Bit PIN25.
	GPIO_DIRCLR_PIN25 = 0x2000000
	// Read: pin set as input
	GPIO_DIRCLR_PIN25_Input = 0x0
	// Read: pin set as output
	GPIO_DIRCLR_PIN25_Output = 0x1
	// Write: writing a '1' sets pin to input; writing a '0' has no effect
	GPIO_DIRCLR_PIN25_Clear = 0x1
	// Position of PIN26 field.
	GPIO_DIRCLR_PIN26_Pos = 0x1a
	// Bit mask of PIN26 field.
	GPIO_DIRCLR_PIN26_Msk = 0x4000000
	// Bit PIN26.
	GPIO_DIRCLR_PIN26 = 0x4000000
	// Read: pin set as input
	GPIO_DIRCLR_PIN26_Input = 0x0
	// Read: pin set as output
	GPIO_DIRCLR_PIN26_Output = 0x1
	// Write: writing a '1' sets pin to input; writing a '0' has no effect
	GPIO_DIRCLR_PIN26_Clear = 0x1
	// Position of PIN27 field.
	GPIO_DIRCLR_PIN27_Pos = 0x1b
	// Bit mask of PIN27 field.
	GPIO_DIRCLR_PIN27_Msk = 0x8000000
	// Bit PIN27.
	GPIO_DIRCLR_PIN27 = 0x8000000
	// Read: pin set as input
	GPIO_DIRCLR_PIN27_Input = 0x0
	// Read: pin set as output
	GPIO_DIRCLR_PIN27_Output = 0x1
	// Write: writing a '1' sets pin to input; writing a '0' has no effect
	GPIO_DIRCLR_PIN27_Clear = 0x1
	// Position of PIN28 field.
	GPIO_DIRCLR_PIN28_Pos = 0x1c
	// Bit mask of PIN28 field.
	GPIO_DIRCLR_PIN28_Msk = 0x10000000
	// Bit PIN28.
	GPIO_DIRCLR_PIN28 = 0x10000000
	// Read: pin set as input
	GPIO_DIRCLR_PIN28_Input = 0x0
	// Read: pin set as output
	GPIO_DIRCLR_PIN28_Output = 0x1
	// Write: writing a '1' sets pin to input; writing a '0' has no effect
	GPIO_DIRCLR_PIN28_Clear = 0x1
	// Position of PIN29 field.
	GPIO_DIRCLR_PIN29_Pos = 0x1d
	// Bit mask of PIN29 field.
	GPIO_DIRCLR_PIN29_Msk = 0x20000000
	// Bit PIN29.
	GPIO_DIRCLR_PIN29 = 0x20000000
	// Read: pin set as input
	GPIO_DIRCLR_PIN29_Input = 0x0
	// Read: pin set as output
	GPIO_DIRCLR_PIN29_Output = 0x1
	// Write: writing a '1' sets pin to input; writing a '0' has no effect
	GPIO_DIRCLR_PIN29_Clear = 0x1
	// Position of PIN30 field.
	GPIO_DIRCLR_PIN30_Pos = 0x1e
	// Bit mask of PIN30 field.
	GPIO_DIRCLR_PIN30_Msk = 0x40000000
	// Bit PIN30.
	GPIO_DIRCLR_PIN30 = 0x40000000
	// Read: pin set as input
	GPIO_DIRCLR_PIN30_Input = 0x0
	// Read: pin set as output
	GPIO_DIRCLR_PIN30_Output = 0x1
	// Write: writing a '1' sets pin to input; writing a '0' has no effect
	GPIO_DIRCLR_PIN30_Clear = 0x1
	// Position of PIN31 field.
	GPIO_DIRCLR_PIN31_Pos = 0x1f
	// Bit mask of PIN31 field.
	GPIO_DIRCLR_PIN31_Msk = 0x80000000
	// Bit PIN31.
	GPIO_DIRCLR_PIN31 = 0x80000000
	// Read: pin set as input
	GPIO_DIRCLR_PIN31_Input = 0x0
	// Read: pin set as output
	GPIO_DIRCLR_PIN31_Output = 0x1
	// Write: writing a '1' sets pin to input; writing a '0' has no effect
	GPIO_DIRCLR_PIN31_Clear = 0x1

	// LATCH: Latch register indicating what GPIO pins that have met the criteria set in the PIN_CNF[n].SENSE registers
	// Position of PIN0 field.
	GPIO_LATCH_PIN0_Pos = 0x0
	// Bit mask of PIN0 field.
	GPIO_LATCH_PIN0_Msk = 0x1
	// Bit PIN0.
	GPIO_LATCH_PIN0 = 0x1
	// Criteria has not been met
	GPIO_LATCH_PIN0_NotLatched = 0x0
	// Criteria has been met
	GPIO_LATCH_PIN0_Latched = 0x1
	// Position of PIN1 field.
	GPIO_LATCH_PIN1_Pos = 0x1
	// Bit mask of PIN1 field.
	GPIO_LATCH_PIN1_Msk = 0x2
	// Bit PIN1.
	GPIO_LATCH_PIN1 = 0x2
	// Criteria has not been met
	GPIO_LATCH_PIN1_NotLatched = 0x0
	// Criteria has been met
	GPIO_LATCH_PIN1_Latched = 0x1
	// Position of PIN2 field.
	GPIO_LATCH_PIN2_Pos = 0x2
	// Bit mask of PIN2 field.
	GPIO_LATCH_PIN2_Msk = 0x4
	// Bit PIN2.
	GPIO_LATCH_PIN2 = 0x4
	// Criteria has not been met
	GPIO_LATCH_PIN2_NotLatched = 0x0
	// Criteria has been met
	GPIO_LATCH_PIN2_Latched = 0x1
	// Position of PIN3 field.
	GPIO_LATCH_PIN3_Pos = 0x3
	// Bit mask of PIN3 field.
	GPIO_LATCH_PIN3_Msk = 0x8
	// Bit PIN3.
	GPIO_LATCH_PIN3 = 0x8
	// Criteria has not been met
	GPIO_LATCH_PIN3_NotLatched = 0x0
	// Criteria has been met
	GPIO_LATCH_PIN3_Latched = 0x1
	// Position of PIN4 field.
	GPIO_LATCH_PIN4_Pos = 0x4
	// Bit mask of PIN4 field.
	GPIO_LATCH_PIN4_Msk = 0x10
	// Bit PIN4.
	GPIO_LATCH_PIN4 = 0x10
	// Criteria has not been met
	GPIO_LATCH_PIN4_NotLatched = 0x0
	// Criteria has been met
	GPIO_LATCH_PIN4_Latched = 0x1
	// Position of PIN5 field.
	GPIO_LATCH_PIN5_Pos = 0x5
	// Bit mask of PIN5 field.
	GPIO_LATCH_PIN5_Msk = 0x20
	// Bit PIN5.
	GPIO_LATCH_PIN5 = 0x20
	// Criteria has not been met
	GPIO_LATCH_PIN5_NotLatched = 0x0
	// Criteria has been met
	GPIO_LATCH_PIN5_Latched = 0x1
	// Position of PIN6 field.
	GPIO_LATCH_PIN6_Pos = 0x6
	// Bit mask of PIN6 field.
	GPIO_LATCH_PIN6_Msk = 0x40
	// Bit PIN6.
	GPIO_LATCH_PIN6 = 0x40
	// Criteria has not been met
	GPIO_LATCH_PIN6_NotLatched = 0x0
	// Criteria has been met
	GPIO_LATCH_PIN6_Latched = 0x1
	// Position of PIN7 field.
	GPIO_LATCH_PIN7_Pos = 0x7
	// Bit mask of PIN7 field.
	GPIO_LATCH_PIN7_Msk = 0x80
	// Bit PIN7.
	GPIO_LATCH_PIN7 = 0x80
	// Criteria has not been met
	GPIO_LATCH_PIN7_NotLatched = 0x0
	// Criteria has been met
	GPIO_LATCH_PIN7_Latched = 0x1
	// Position of PIN8 field.
	GPIO_LATCH_PIN8_Pos = 0x8
	// Bit mask of PIN8 field.
	GPIO_LATCH_PIN8_Msk = 0x100
	// Bit PIN8.
	GPIO_LATCH_PIN8 = 0x100
	// Criteria has not been met
	GPIO_LATCH_PIN8_NotLatched = 0x0
	// Criteria has been met
	GPIO_LATCH_PIN8_Latched = 0x1
	// Position of PIN9 field.
	GPIO_LATCH_PIN9_Pos = 0x9
	// Bit mask of PIN9 field.
	GPIO_LATCH_PIN9_Msk = 0x200
	// Bit PIN9.
	GPIO_LATCH_PIN9 = 0x200
	// Criteria has not been met
	GPIO_LATCH_PIN9_NotLatched = 0x0
	// Criteria has been met
	GPIO_LATCH_PIN9_Latched = 0x1
	// Position of PIN10 field.
	GPIO_LATCH_PIN10_Pos = 0xa
	// Bit mask of PIN10 field.
	GPIO_LATCH_PIN10_Msk = 0x400
	// Bit PIN10.
	GPIO_LATCH_PIN10 = 0x400
	// Criteria has not been met
	GPIO_LATCH_PIN10_NotLatched = 0x0
	// Criteria has been met
	GPIO_LATCH_PIN10_Latched = 0x1
	// Position of PIN11 field.
	GPIO_LATCH_PIN11_Pos = 0xb
	// Bit mask of PIN11 field.
	GPIO_LATCH_PIN11_Msk = 0x800
	// Bit PIN11.
	GPIO_LATCH_PIN11 = 0x800
	// Criteria has not been met
	GPIO_LATCH_PIN11_NotLatched = 0x0
	// Criteria has been met
	GPIO_LATCH_PIN11_Latched = 0x1
	// Position of PIN12 field.
	GPIO_LATCH_PIN12_Pos = 0xc
	// Bit mask of PIN12 field.
	GPIO_LATCH_PIN12_Msk = 0x1000
	// Bit PIN12.
	GPIO_LATCH_PIN12 = 0x1000
	// Criteria has not been met
	GPIO_LATCH_PIN12_NotLatched = 0x0
	// Criteria has been met
	GPIO_LATCH_PIN12_Latched = 0x1
	// Position of PIN13 field.
	GPIO_LATCH_PIN13_Pos = 0xd
	// Bit mask of PIN13 field.
	GPIO_LATCH_PIN13_Msk = 0x2000
	// Bit PIN13.
	GPIO_LATCH_PIN13 = 0x2000
	// Criteria has not been met
	GPIO_LATCH_PIN13_NotLatched = 0x0
	// Criteria has been met
	GPIO_LATCH_PIN13_Latched = 0x1
	// Position of PIN14 field.
	GPIO_LATCH_PIN14_Pos = 0xe
	// Bit mask of PIN14 field.
	GPIO_LATCH_PIN14_Msk = 0x4000
	// Bit PIN14.
	GPIO_LATCH_PIN14 = 0x4000
	// Criteria has not been met
	GPIO_LATCH_PIN14_NotLatched = 0x0
	// Criteria has been met
	GPIO_LATCH_PIN14_Latched = 0x1
	// Position of PIN15 field.
	GPIO_LATCH_PIN15_Pos = 0xf
	// Bit mask of PIN15 field.
	GPIO_LATCH_PIN15_Msk = 0x8000
	// Bit PIN15.
	GPIO_LATCH_PIN15 = 0x8000
	// Criteria has not been met
	GPIO_LATCH_PIN15_NotLatched = 0x0
	// Criteria has been met
	GPIO_LATCH_PIN15_Latched = 0x1
	// Position of PIN16 field.
	GPIO_LATCH_PIN16_Pos = 0x10
	// Bit mask of PIN16 field.
	GPIO_LATCH_PIN16_Msk = 0x10000
	// Bit PIN16.
	GPIO_LATCH_PIN16 = 0x10000
	// Criteria has not been met
	GPIO_LATCH_PIN16_NotLatched = 0x0
	// Criteria has been met
	GPIO_LATCH_PIN16_Latched = 0x1
	// Position of PIN17 field.
	GPIO_LATCH_PIN17_Pos = 0x11
	// Bit mask of PIN17 field.
	GPIO_LATCH_PIN17_Msk = 0x20000
	// Bit PIN17.
	GPIO_LATCH_PIN17 = 0x20000
	// Criteria has not been met
	GPIO_LATCH_PIN17_NotLatched = 0x0
	// Criteria has been met
	GPIO_LATCH_PIN17_Latched = 0x1
	// Position of PIN18 field.
	GPIO_LATCH_PIN18_Pos = 0x12
	// Bit mask of PIN18 field.
	GPIO_LATCH_PIN18_Msk = 0x40000
	// Bit PIN18.
	GPIO_LATCH_PIN18 = 0x40000
	// Criteria has not been met
	GPIO_LATCH_PIN18_NotLatched = 0x0
	// Criteria has been met
	GPIO_LATCH_PIN18_Latched = 0x1
	// Position of PIN19 field.
	GPIO_LATCH_PIN19_Pos = 0x13
	// Bit mask of PIN19 field.
	GPIO_LATCH_PIN19_Msk = 0x80000
	// Bit PIN19.
	GPIO_LATCH_PIN19 = 0x80000
	// Criteria has not been met
	GPIO_LATCH_PIN19_NotLatched = 0x0
	// Criteria has been met
	GPIO_LATCH_PIN19_Latched = 0x1
	// Position of PIN20 field.
	GPIO_LATCH_PIN20_Pos = 0x14
	// Bit mask of PIN20 field.
	GPIO_LATCH_PIN20_Msk = 0x100000
	// Bit PIN20.
	GPIO_LATCH_PIN20 = 0x100000
	// Criteria has not been met
	GPIO_LATCH_PIN20_NotLatched = 0x0
	// Criteria has been met
	GPIO_LATCH_PIN20_Latched = 0x1
	// Position of PIN21 field.
	GPIO_LATCH_PIN21_Pos = 0x15
	// Bit mask of PIN21 field.
	GPIO_LATCH_PIN21_Msk = 0x200000
	// Bit PIN21.
	GPIO_LATCH_PIN21 = 0x200000
	// Criteria has not been met
	GPIO_LATCH_PIN21_NotLatched = 0x0
	// Criteria has been met
	GPIO_LATCH_PIN21_Latched = 0x1
	// Position of PIN22 field.
	GPIO_LATCH_PIN22_Pos = 0x16
	// Bit mask of PIN22 field.
	GPIO_LATCH_PIN22_Msk = 0x400000
	// Bit PIN22.
	GPIO_LATCH_PIN22 = 0x400000
	// Criteria has not been met
	GPIO_LATCH_PIN22_NotLatched = 0x0
	// Criteria has been met
	GPIO_LATCH_PIN22_Latched = 0x1
	// Position of PIN23 field.
	GPIO_LATCH_PIN23_Pos = 0x17
	// Bit mask of PIN23 field.
	GPIO_LATCH_PIN23_Msk = 0x800000
	// Bit PIN23.
	GPIO_LATCH_PIN23 = 0x800000
	// Criteria has not been met
	GPIO_LATCH_PIN23_NotLatched = 0x0
	// Criteria has been met
	GPIO_LATCH_PIN23_Latched = 0x1
	// Position of PIN24 field.
	GPIO_LATCH_PIN24_Pos = 0x18
	// Bit mask of PIN24 field.
	GPIO_LATCH_PIN24_Msk = 0x1000000
	// Bit PIN24.
	GPIO_LATCH_PIN24 = 0x1000000
	// Criteria has not been met
	GPIO_LATCH_PIN24_NotLatched = 0x0
	// Criteria has been met
	GPIO_LATCH_PIN24_Latched = 0x1
	// Position of PIN25 field.
	GPIO_LATCH_PIN25_Pos = 0x19
	// Bit mask of PIN25 field.
	GPIO_LATCH_PIN25_Msk = 0x2000000
	// Bit PIN25.
	GPIO_LATCH_PIN25 = 0x2000000
	// Criteria has not been met
	GPIO_LATCH_PIN25_NotLatched = 0x0
	// Criteria has been met
	GPIO_LATCH_PIN25_Latched = 0x1
	// Position of PIN26 field.
	GPIO_LATCH_PIN26_Pos = 0x1a
	// Bit mask of PIN26 field.
	GPIO_LATCH_PIN26_Msk = 0x4000000
	// Bit PIN26.
	GPIO_LATCH_PIN26 = 0x4000000
	// Criteria has not been met
	GPIO_LATCH_PIN26_NotLatched = 0x0
	// Criteria has been met
	GPIO_LATCH_PIN26_Latched = 0x1
	// Position of PIN27 field.
	GPIO_LATCH_PIN27_Pos = 0x1b
	// Bit mask of PIN27 field.
	GPIO_LATCH_PIN27_Msk = 0x8000000
	// Bit PIN27.
	GPIO_LATCH_PIN27 = 0x8000000
	// Criteria has not been met
	GPIO_LATCH_PIN27_NotLatched = 0x0
	// Criteria has been met
	GPIO_LATCH_PIN27_Latched = 0x1
	// Position of PIN28 field.
	GPIO_LATCH_PIN28_Pos = 0x1c
	// Bit mask of PIN28 field.
	GPIO_LATCH_PIN28_Msk = 0x10000000
	// Bit PIN28.
	GPIO_LATCH_PIN28 = 0x10000000
	// Criteria has not been met
	GPIO_LATCH_PIN28_NotLatched = 0x0
	// Criteria has been met
	GPIO_LATCH_PIN28_Latched = 0x1
	// Position of PIN29 field.
	GPIO_LATCH_PIN29_Pos = 0x1d
	// Bit mask of PIN29 field.
	GPIO_LATCH_PIN29_Msk = 0x20000000
	// Bit PIN29.
	GPIO_LATCH_PIN29 = 0x20000000
	// Criteria has not been met
	GPIO_LATCH_PIN29_NotLatched = 0x0
	// Criteria has been met
	GPIO_LATCH_PIN29_Latched = 0x1
	// Position of PIN30 field.
	GPIO_LATCH_PIN30_Pos = 0x1e
	// Bit mask of PIN30 field.
	GPIO_LATCH_PIN30_Msk = 0x40000000
	// Bit PIN30.
	GPIO_LATCH_PIN30 = 0x40000000
	// Criteria has not been met
	GPIO_LATCH_PIN30_NotLatched = 0x0
	// Criteria has been met
	GPIO_LATCH_PIN30_Latched = 0x1
	// Position of PIN31 field.
	GPIO_LATCH_PIN31_Pos = 0x1f
	// Bit mask of PIN31 field.
	GPIO_LATCH_PIN31_Msk = 0x80000000
	// Bit PIN31.
	GPIO_LATCH_PIN31 = 0x80000000
	// Criteria has not been met
	GPIO_LATCH_PIN31_NotLatched = 0x0
	// Criteria has been met
	GPIO_LATCH_PIN31_Latched = 0x1

	// DETECTMODE: Select between default DETECT signal behaviour and LDETECT mode
	// Position of DETECTMODE field.
	GPIO_DETECTMODE_DETECTMODE_Pos = 0x0
	// Bit mask of DETECTMODE field.
	GPIO_DETECTMODE_DETECTMODE_Msk = 0x1
	// Bit DETECTMODE.
	GPIO_DETECTMODE_DETECTMODE = 0x1
	// DETECT directly connected to PIN DETECT signals
	GPIO_DETECTMODE_DETECTMODE_Default = 0x0
	// Use the latched LDETECT behaviour
	GPIO_DETECTMODE_DETECTMODE_LDETECT = 0x1

	// PIN_CNF: Description collection: Configuration of GPIO pins
	// Position of DIR field.
	GPIO_PIN_CNF_DIR_Pos = 0x0
	// Bit mask of DIR field.
	GPIO_PIN_CNF_DIR_Msk = 0x1
	// Bit DIR.
	GPIO_PIN_CNF_DIR = 0x1
	// Configure pin as an input pin
	GPIO_PIN_CNF_DIR_Input = 0x0
	// Configure pin as an output pin
	GPIO_PIN_CNF_DIR_Output = 0x1
	// Position of INPUT field.
	GPIO_PIN_CNF_INPUT_Pos = 0x1
	// Bit mask of INPUT field.
	GPIO_PIN_CNF_INPUT_Msk = 0x2
	// Bit INPUT.
	GPIO_PIN_CNF_INPUT = 0x2
	// Connect input buffer
	GPIO_PIN_CNF_INPUT_Connect = 0x0
	// Disconnect input buffer
	GPIO_PIN_CNF_INPUT_Disconnect = 0x1
	// Position of PULL field.
	GPIO_PIN_CNF_PULL_Pos = 0x2
	// Bit mask of PULL field.
	GPIO_PIN_CNF_PULL_Msk = 0xc
	// No pull
	GPIO_PIN_CNF_PULL_Disabled = 0x0
	// Pull down on pin
	GPIO_PIN_CNF_PULL_Pulldown = 0x1
	// Pull up on pin
	GPIO_PIN_CNF_PULL_Pullup = 0x3
	// Position of DRIVE field.
	GPIO_PIN_CNF_DRIVE_Pos = 0x8
	// Bit mask of DRIVE field.
	GPIO_PIN_CNF_DRIVE_Msk = 0x700
	// Standard '0', standard '1'
	GPIO_PIN_CNF_DRIVE_S0S1 = 0x0
	// High drive '0', standard '1'
	GPIO_PIN_CNF_DRIVE_H0S1 = 0x1
	// Standard '0', high drive '1'
	GPIO_PIN_CNF_DRIVE_S0H1 = 0x2
	// High drive '0', high 'drive '1''
	GPIO_PIN_CNF_DRIVE_H0H1 = 0x3
	// Disconnect '0' standard '1' (normally used for wired-or connections)
	GPIO_PIN_CNF_DRIVE_D0S1 = 0x4
	// Disconnect '0', high drive '1' (normally used for wired-or connections)
	GPIO_PIN_CNF_DRIVE_D0H1 = 0x5
	// Standard '0'. disconnect '1' (normally used for wired-and connections)
	GPIO_PIN_CNF_DRIVE_S0D1 = 0x6
	// High drive '0', disconnect '1' (normally used for wired-and connections)
	GPIO_PIN_CNF_DRIVE_H0D1 = 0x7
	// Position of SENSE field.
	GPIO_PIN_CNF_SENSE_Pos = 0x10
	// Bit mask of SENSE field.
	GPIO_PIN_CNF_SENSE_Msk = 0x30000
	// Disabled
	GPIO_PIN_CNF_SENSE_Disabled = 0x0
	// Sense for high level
	GPIO_PIN_CNF_SENSE_High = 0x2
	// Sense for low level
	GPIO_PIN_CNF_SENSE_Low = 0x3
)

// Bitfields for RADIO: 2.4 GHz radio
const (
	// TASKS_TXEN: Enable RADIO in TX mode
	// Position of TASKS_TXEN field.
	RADIO_TASKS_TXEN_TASKS_TXEN_Pos = 0x0
	// Bit mask of TASKS_TXEN field.
	RADIO_TASKS_TXEN_TASKS_TXEN_Msk = 0x1
	// Bit TASKS_TXEN.
	RADIO_TASKS_TXEN_TASKS_TXEN = 0x1
	// Trigger task
	RADIO_TASKS_TXEN_TASKS_TXEN_Trigger = 0x1

	// TASKS_RXEN: Enable RADIO in RX mode
	// Position of TASKS_RXEN field.
	RADIO_TASKS_RXEN_TASKS_RXEN_Pos = 0x0
	// Bit mask of TASKS_RXEN field.
	RADIO_TASKS_RXEN_TASKS_RXEN_Msk = 0x1
	// Bit TASKS_RXEN.
	RADIO_TASKS_RXEN_TASKS_RXEN = 0x1
	// Trigger task
	RADIO_TASKS_RXEN_TASKS_RXEN_Trigger = 0x1

	// TASKS_START: Start RADIO
	// Position of TASKS_START field.
	RADIO_TASKS_START_TASKS_START_Pos = 0x0
	// Bit mask of TASKS_START field.
	RADIO_TASKS_START_TASKS_START_Msk = 0x1
	// Bit TASKS_START.
	RADIO_TASKS_START_TASKS_START = 0x1
	// Trigger task
	RADIO_TASKS_START_TASKS_START_Trigger = 0x1

	// TASKS_STOP: Stop RADIO
	// Position of TASKS_STOP field.
	RADIO_TASKS_STOP_TASKS_STOP_Pos = 0x0
	// Bit mask of TASKS_STOP field.
	RADIO_TASKS_STOP_TASKS_STOP_Msk = 0x1
	// Bit TASKS_STOP.
	RADIO_TASKS_STOP_TASKS_STOP = 0x1
	// Trigger task
	RADIO_TASKS_STOP_TASKS_STOP_Trigger = 0x1

	// TASKS_DISABLE: Disable RADIO
	// Position of TASKS_DISABLE field.
	RADIO_TASKS_DISABLE_TASKS_DISABLE_Pos = 0x0
	// Bit mask of TASKS_DISABLE field.
	RADIO_TASKS_DISABLE_TASKS_DISABLE_Msk = 0x1
	// Bit TASKS_DISABLE.
	RADIO_TASKS_DISABLE_TASKS_DISABLE = 0x1
	// Trigger task
	RADIO_TASKS_DISABLE_TASKS_DISABLE_Trigger = 0x1

	// TASKS_RSSISTART: Start the RSSI and take one single sample of the receive signal strength
	// Position of TASKS_RSSISTART field.
	RADIO_TASKS_RSSISTART_TASKS_RSSISTART_Pos = 0x0
	// Bit mask of TASKS_RSSISTART field.
	RADIO_TASKS_RSSISTART_TASKS_RSSISTART_Msk = 0x1
	// Bit TASKS_RSSISTART.
	RADIO_TASKS_RSSISTART_TASKS_RSSISTART = 0x1
	// Trigger task
	RADIO_TASKS_RSSISTART_TASKS_RSSISTART_Trigger = 0x1

	// TASKS_RSSISTOP: Stop the RSSI measurement
	// Position of TASKS_RSSISTOP field.
	RADIO_TASKS_RSSISTOP_TASKS_RSSISTOP_Pos = 0x0
	// Bit mask of TASKS_RSSISTOP field.
	RADIO_TASKS_RSSISTOP_TASKS_RSSISTOP_Msk = 0x1
	// Bit TASKS_RSSISTOP.
	RADIO_TASKS_RSSISTOP_TASKS_RSSISTOP = 0x1
	// Trigger task
	RADIO_TASKS_RSSISTOP_TASKS_RSSISTOP_Trigger = 0x1

	// TASKS_BCSTART: Start the bit counter
	// Position of TASKS_BCSTART field.
	RADIO_TASKS_BCSTART_TASKS_BCSTART_Pos = 0x0
	// Bit mask of TASKS_BCSTART field.
	RADIO_TASKS_BCSTART_TASKS_BCSTART_Msk = 0x1
	// Bit TASKS_BCSTART.
	RADIO_TASKS_BCSTART_TASKS_BCSTART = 0x1
	// Trigger task
	RADIO_TASKS_BCSTART_TASKS_BCSTART_Trigger = 0x1

	// TASKS_BCSTOP: Stop the bit counter
	// Position of TASKS_BCSTOP field.
	RADIO_TASKS_BCSTOP_TASKS_BCSTOP_Pos = 0x0
	// Bit mask of TASKS_BCSTOP field.
	RADIO_TASKS_BCSTOP_TASKS_BCSTOP_Msk = 0x1
	// Bit TASKS_BCSTOP.
	RADIO_TASKS_BCSTOP_TASKS_BCSTOP = 0x1
	// Trigger task
	RADIO_TASKS_BCSTOP_TASKS_BCSTOP_Trigger = 0x1

	// TASKS_EDSTART: Start the energy detect measurement used in IEEE 802.15.4 mode
	// Position of TASKS_EDSTART field.
	RADIO_TASKS_EDSTART_TASKS_EDSTART_Pos = 0x0
	// Bit mask of TASKS_EDSTART field.
	RADIO_TASKS_EDSTART_TASKS_EDSTART_Msk = 0x1
	// Bit TASKS_EDSTART.
	RADIO_TASKS_EDSTART_TASKS_EDSTART = 0x1
	// Trigger task
	RADIO_TASKS_EDSTART_TASKS_EDSTART_Trigger = 0x1

	// TASKS_EDSTOP: Stop the energy detect measurement
	// Position of TASKS_EDSTOP field.
	RADIO_TASKS_EDSTOP_TASKS_EDSTOP_Pos = 0x0
	// Bit mask of TASKS_EDSTOP field.
	RADIO_TASKS_EDSTOP_TASKS_EDSTOP_Msk = 0x1
	// Bit TASKS_EDSTOP.
	RADIO_TASKS_EDSTOP_TASKS_EDSTOP = 0x1
	// Trigger task
	RADIO_TASKS_EDSTOP_TASKS_EDSTOP_Trigger = 0x1

	// TASKS_CCASTART: Start the clear channel assessment used in IEEE 802.15.4 mode
	// Position of TASKS_CCASTART field.
	RADIO_TASKS_CCASTART_TASKS_CCASTART_Pos = 0x0
	// Bit mask of TASKS_CCASTART field.
	RADIO_TASKS_CCASTART_TASKS_CCASTART_Msk = 0x1
	// Bit TASKS_CCASTART.
	RADIO_TASKS_CCASTART_TASKS_CCASTART = 0x1
	// Trigger task
	RADIO_TASKS_CCASTART_TASKS_CCASTART_Trigger = 0x1

	// TASKS_CCASTOP: Stop the clear channel assessment
	// Position of TASKS_CCASTOP field.
	RADIO_TASKS_CCASTOP_TASKS_CCASTOP_Pos = 0x0
	// Bit mask of TASKS_CCASTOP field.
	RADIO_TASKS_CCASTOP_TASKS_CCASTOP_Msk = 0x1
	// Bit TASKS_CCASTOP.
	RADIO_TASKS_CCASTOP_TASKS_CCASTOP = 0x1
	// Trigger task
	RADIO_TASKS_CCASTOP_TASKS_CCASTOP_Trigger = 0x1

	// EVENTS_READY: RADIO has ramped up and is ready to be started
	// Position of EVENTS_READY field.
	RADIO_EVENTS_READY_EVENTS_READY_Pos = 0x0
	// Bit mask of EVENTS_READY field.
	RADIO_EVENTS_READY_EVENTS_READY_Msk = 0x1
	// Bit EVENTS_READY.
	RADIO_EVENTS_READY_EVENTS_READY = 0x1
	// Event not generated
	RADIO_EVENTS_READY_EVENTS_READY_NotGenerated = 0x0
	// Event generated
	RADIO_EVENTS_READY_EVENTS_READY_Generated = 0x1

	// EVENTS_ADDRESS: Address sent or received
	// Position of EVENTS_ADDRESS field.
	RADIO_EVENTS_ADDRESS_EVENTS_ADDRESS_Pos = 0x0
	// Bit mask of EVENTS_ADDRESS field.
	RADIO_EVENTS_ADDRESS_EVENTS_ADDRESS_Msk = 0x1
	// Bit EVENTS_ADDRESS.
	RADIO_EVENTS_ADDRESS_EVENTS_ADDRESS = 0x1
	// Event not generated
	RADIO_EVENTS_ADDRESS_EVENTS_ADDRESS_NotGenerated = 0x0
	// Event generated
	RADIO_EVENTS_ADDRESS_EVENTS_ADDRESS_Generated = 0x1

	// EVENTS_PAYLOAD: Packet payload sent or received
	// Position of EVENTS_PAYLOAD field.
	RADIO_EVENTS_PAYLOAD_EVENTS_PAYLOAD_Pos = 0x0
	// Bit mask of EVENTS_PAYLOAD field.
	RADIO_EVENTS_PAYLOAD_EVENTS_PAYLOAD_Msk = 0x1
	// Bit EVENTS_PAYLOAD.
	RADIO_EVENTS_PAYLOAD_EVENTS_PAYLOAD = 0x1
	// Event not generated
	RADIO_EVENTS_PAYLOAD_EVENTS_PAYLOAD_NotGenerated = 0x0
	// Event generated
	RADIO_EVENTS_PAYLOAD_EVENTS_PAYLOAD_Generated = 0x1

	// EVENTS_END: Packet sent or received
	// Position of EVENTS_END field.
	RADIO_EVENTS_END_EVENTS_END_Pos = 0x0
	// Bit mask of EVENTS_END field.
	RADIO_EVENTS_END_EVENTS_END_Msk = 0x1
	// Bit EVENTS_END.
	RADIO_EVENTS_END_EVENTS_END = 0x1
	// Event not generated
	RADIO_EVENTS_END_EVENTS_END_NotGenerated = 0x0
	// Event generated
	RADIO_EVENTS_END_EVENTS_END_Generated = 0x1

	// EVENTS_DISABLED: RADIO has been disabled
	// Position of EVENTS_DISABLED field.
	RADIO_EVENTS_DISABLED_EVENTS_DISABLED_Pos = 0x0
	// Bit mask of EVENTS_DISABLED field.
	RADIO_EVENTS_DISABLED_EVENTS_DISABLED_Msk = 0x1
	// Bit EVENTS_DISABLED.
	RADIO_EVENTS_DISABLED_EVENTS_DISABLED = 0x1
	// Event not generated
	RADIO_EVENTS_DISABLED_EVENTS_DISABLED_NotGenerated = 0x0
	// Event generated
	RADIO_EVENTS_DISABLED_EVENTS_DISABLED_Generated = 0x1

	// EVENTS_DEVMATCH: A device address match occurred on the last received packet
	// Position of EVENTS_DEVMATCH field.
	RADIO_EVENTS_DEVMATCH_EVENTS_DEVMATCH_Pos = 0x0
	// Bit mask of EVENTS_DEVMATCH field.
	RADIO_EVENTS_DEVMATCH_EVENTS_DEVMATCH_Msk = 0x1
	// Bit EVENTS_DEVMATCH.
	RADIO_EVENTS_DEVMATCH_EVENTS_DEVMATCH = 0x1
	// Event not generated
	RADIO_EVENTS_DEVMATCH_EVENTS_DEVMATCH_NotGenerated = 0x0
	// Event generated
	RADIO_EVENTS_DEVMATCH_EVENTS_DEVMATCH_Generated = 0x1

	// EVENTS_DEVMISS: No device address match occurred on the last received packet
	// Position of EVENTS_DEVMISS field.
	RADIO_EVENTS_DEVMISS_EVENTS_DEVMISS_Pos = 0x0
	// Bit mask of EVENTS_DEVMISS field.
	RADIO_EVENTS_DEVMISS_EVENTS_DEVMISS_Msk = 0x1
	// Bit EVENTS_DEVMISS.
	RADIO_EVENTS_DEVMISS_EVENTS_DEVMISS = 0x1
	// Event not generated
	RADIO_EVENTS_DEVMISS_EVENTS_DEVMISS_NotGenerated = 0x0
	// Event generated
	RADIO_EVENTS_DEVMISS_EVENTS_DEVMISS_Generated = 0x1

	// EVENTS_RSSIEND: Sampling of receive signal strength complete
	// Position of EVENTS_RSSIEND field.
	RADIO_EVENTS_RSSIEND_EVENTS_RSSIEND_Pos = 0x0
	// Bit mask of EVENTS_RSSIEND field.
	RADIO_EVENTS_RSSIEND_EVENTS_RSSIEND_Msk = 0x1
	// Bit EVENTS_RSSIEND.
	RADIO_EVENTS_RSSIEND_EVENTS_RSSIEND = 0x1
	// Event not generated
	RADIO_EVENTS_RSSIEND_EVENTS_RSSIEND_NotGenerated = 0x0
	// Event generated
	RADIO_EVENTS_RSSIEND_EVENTS_RSSIEND_Generated = 0x1

	// EVENTS_BCMATCH: Bit counter reached bit count value
	// Position of EVENTS_BCMATCH field.
	RADIO_EVENTS_BCMATCH_EVENTS_BCMATCH_Pos = 0x0
	// Bit mask of EVENTS_BCMATCH field.
	RADIO_EVENTS_BCMATCH_EVENTS_BCMATCH_Msk = 0x1
	// Bit EVENTS_BCMATCH.
	RADIO_EVENTS_BCMATCH_EVENTS_BCMATCH = 0x1
	// Event not generated
	RADIO_EVENTS_BCMATCH_EVENTS_BCMATCH_NotGenerated = 0x0
	// Event generated
	RADIO_EVENTS_BCMATCH_EVENTS_BCMATCH_Generated = 0x1

	// EVENTS_CRCOK: Packet received with CRC ok
	// Position of EVENTS_CRCOK field.
	RADIO_EVENTS_CRCOK_EVENTS_CRCOK_Pos = 0x0
	// Bit mask of EVENTS_CRCOK field.
	RADIO_EVENTS_CRCOK_EVENTS_CRCOK_Msk = 0x1
	// Bit EVENTS_CRCOK.
	RADIO_EVENTS_CRCOK_EVENTS_CRCOK = 0x1
	// Event not generated
	RADIO_EVENTS_CRCOK_EVENTS_CRCOK_NotGenerated = 0x0
	// Event generated
	RADIO_EVENTS_CRCOK_EVENTS_CRCOK_Generated = 0x1

	// EVENTS_CRCERROR: Packet received with CRC error
	// Position of EVENTS_CRCERROR field.
	RADIO_EVENTS_CRCERROR_EVENTS_CRCERROR_Pos = 0x0
	// Bit mask of EVENTS_CRCERROR field.
	RADIO_EVENTS_CRCERROR_EVENTS_CRCERROR_Msk = 0x1
	// Bit EVENTS_CRCERROR.
	RADIO_EVENTS_CRCERROR_EVENTS_CRCERROR = 0x1
	// Event not generated
	RADIO_EVENTS_CRCERROR_EVENTS_CRCERROR_NotGenerated = 0x0
	// Event generated
	RADIO_EVENTS_CRCERROR_EVENTS_CRCERROR_Generated = 0x1

	// EVENTS_FRAMESTART: IEEE 802.15.4 length field received
	// Position of EVENTS_FRAMESTART field.
	RADIO_EVENTS_FRAMESTART_EVENTS_FRAMESTART_Pos = 0x0
	// Bit mask of EVENTS_FRAMESTART field.
	RADIO_EVENTS_FRAMESTART_EVENTS_FRAMESTART_Msk = 0x1
	// Bit EVENTS_FRAMESTART.
	RADIO_EVENTS_FRAMESTART_EVENTS_FRAMESTART = 0x1
	// Event not generated
	RADIO_EVENTS_FRAMESTART_EVENTS_FRAMESTART_NotGenerated = 0x0
	// Event generated
	RADIO_EVENTS_FRAMESTART_EVENTS_FRAMESTART_Generated = 0x1

	// EVENTS_EDEND: Sampling of energy detection complete. A new ED sample is ready for readout from the RADIO.EDSAMPLE register.
	// Position of EVENTS_EDEND field.
	RADIO_EVENTS_EDEND_EVENTS_EDEND_Pos = 0x0
	// Bit mask of EVENTS_EDEND field.
	RADIO_EVENTS_EDEND_EVENTS_EDEND_Msk = 0x1
	// Bit EVENTS_EDEND.
	RADIO_EVENTS_EDEND_EVENTS_EDEND = 0x1
	// Event not generated
	RADIO_EVENTS_EDEND_EVENTS_EDEND_NotGenerated = 0x0
	// Event generated
	RADIO_EVENTS_EDEND_EVENTS_EDEND_Generated = 0x1

	// EVENTS_EDSTOPPED: The sampling of energy detection has stopped
	// Position of EVENTS_EDSTOPPED field.
	RADIO_EVENTS_EDSTOPPED_EVENTS_EDSTOPPED_Pos = 0x0
	// Bit mask of EVENTS_EDSTOPPED field.
	RADIO_EVENTS_EDSTOPPED_EVENTS_EDSTOPPED_Msk = 0x1
	// Bit EVENTS_EDSTOPPED.
	RADIO_EVENTS_EDSTOPPED_EVENTS_EDSTOPPED = 0x1
	// Event not generated
	RADIO_EVENTS_EDSTOPPED_EVENTS_EDSTOPPED_NotGenerated = 0x0
	// Event generated
	RADIO_EVENTS_EDSTOPPED_EVENTS_EDSTOPPED_Generated = 0x1

	// EVENTS_CCAIDLE: Wireless medium in idle - clear to send
	// Position of EVENTS_CCAIDLE field.
	RADIO_EVENTS_CCAIDLE_EVENTS_CCAIDLE_Pos = 0x0
	// Bit mask of EVENTS_CCAIDLE field.
	RADIO_EVENTS_CCAIDLE_EVENTS_CCAIDLE_Msk = 0x1
	// Bit EVENTS_CCAIDLE.
	RADIO_EVENTS_CCAIDLE_EVENTS_CCAIDLE = 0x1
	// Event not generated
	RADIO_EVENTS_CCAIDLE_EVENTS_CCAIDLE_NotGenerated = 0x0
	// Event generated
	RADIO_EVENTS_CCAIDLE_EVENTS_CCAIDLE_Generated = 0x1

	// EVENTS_CCABUSY: Wireless medium busy - do not send
	// Position of EVENTS_CCABUSY field.
	RADIO_EVENTS_CCABUSY_EVENTS_CCABUSY_Pos = 0x0
	// Bit mask of EVENTS_CCABUSY field.
	RADIO_EVENTS_CCABUSY_EVENTS_CCABUSY_Msk = 0x1
	// Bit EVENTS_CCABUSY.
	RADIO_EVENTS_CCABUSY_EVENTS_CCABUSY = 0x1
	// Event not generated
	RADIO_EVENTS_CCABUSY_EVENTS_CCABUSY_NotGenerated = 0x0
	// Event generated
	RADIO_EVENTS_CCABUSY_EVENTS_CCABUSY_Generated = 0x1

	// EVENTS_CCASTOPPED: The CCA has stopped
	// Position of EVENTS_CCASTOPPED field.
	RADIO_EVENTS_CCASTOPPED_EVENTS_CCASTOPPED_Pos = 0x0
	// Bit mask of EVENTS_CCASTOPPED field.
	RADIO_EVENTS_CCASTOPPED_EVENTS_CCASTOPPED_Msk = 0x1
	// Bit EVENTS_CCASTOPPED.
	RADIO_EVENTS_CCASTOPPED_EVENTS_CCASTOPPED = 0x1
	// Event not generated
	RADIO_EVENTS_CCASTOPPED_EVENTS_CCASTOPPED_NotGenerated = 0x0
	// Event generated
	RADIO_EVENTS_CCASTOPPED_EVENTS_CCASTOPPED_Generated = 0x1

	// EVENTS_RATEBOOST: Ble_LR CI field received, receive mode is changed from Ble_LR125Kbit to Ble_LR500Kbit.
	// Position of EVENTS_RATEBOOST field.
	RADIO_EVENTS_RATEBOOST_EVENTS_RATEBOOST_Pos = 0x0
	// Bit mask of EVENTS_RATEBOOST field.
	RADIO_EVENTS_RATEBOOST_EVENTS_RATEBOOST_Msk = 0x1
	// Bit EVENTS_RATEBOOST.
	RADIO_EVENTS_RATEBOOST_EVENTS_RATEBOOST = 0x1
	// Event not generated
	RADIO_EVENTS_RATEBOOST_EVENTS_RATEBOOST_NotGenerated = 0x0
	// Event generated
	RADIO_EVENTS_RATEBOOST_EVENTS_RATEBOOST_Generated = 0x1

	// EVENTS_TXREADY: RADIO has ramped up and is ready to be started TX path
	// Position of EVENTS_TXREADY field.
	RADIO_EVENTS_TXREADY_EVENTS_TXREADY_Pos = 0x0
	// Bit mask of EVENTS_TXREADY field.
	RADIO_EVENTS_TXREADY_EVENTS_TXREADY_Msk = 0x1
	// Bit EVENTS_TXREADY.
	RADIO_EVENTS_TXREADY_EVENTS_TXREADY = 0x1
	// Event not generated
	RADIO_EVENTS_TXREADY_EVENTS_TXREADY_NotGenerated = 0x0
	// Event generated
	RADIO_EVENTS_TXREADY_EVENTS_TXREADY_Generated = 0x1

	// EVENTS_RXREADY: RADIO has ramped up and is ready to be started RX path
	// Position of EVENTS_RXREADY field.
	RADIO_EVENTS_RXREADY_EVENTS_RXREADY_Pos = 0x0
	// Bit mask of EVENTS_RXREADY field.
	RADIO_EVENTS_RXREADY_EVENTS_RXREADY_Msk = 0x1
	// Bit EVENTS_RXREADY.
	RADIO_EVENTS_RXREADY_EVENTS_RXREADY = 0x1
	// Event not generated
	RADIO_EVENTS_RXREADY_EVENTS_RXREADY_NotGenerated = 0x0
	// Event generated
	RADIO_EVENTS_RXREADY_EVENTS_RXREADY_Generated = 0x1

	// EVENTS_MHRMATCH: MAC header match found
	// Position of EVENTS_MHRMATCH field.
	RADIO_EVENTS_MHRMATCH_EVENTS_MHRMATCH_Pos = 0x0
	// Bit mask of EVENTS_MHRMATCH field.
	RADIO_EVENTS_MHRMATCH_EVENTS_MHRMATCH_Msk = 0x1
	// Bit EVENTS_MHRMATCH.
	RADIO_EVENTS_MHRMATCH_EVENTS_MHRMATCH = 0x1
	// Event not generated
	RADIO_EVENTS_MHRMATCH_EVENTS_MHRMATCH_NotGenerated = 0x0
	// Event generated
	RADIO_EVENTS_MHRMATCH_EVENTS_MHRMATCH_Generated = 0x1

	// EVENTS_SYNC: Preamble indicator.
	// Position of EVENTS_SYNC field.
	RADIO_EVENTS_SYNC_EVENTS_SYNC_Pos = 0x0
	// Bit mask of EVENTS_SYNC field.
	RADIO_EVENTS_SYNC_EVENTS_SYNC_Msk = 0x1
	// Bit EVENTS_SYNC.
	RADIO_EVENTS_SYNC_EVENTS_SYNC = 0x1
	// Event not generated
	RADIO_EVENTS_SYNC_EVENTS_SYNC_NotGenerated = 0x0
	// Event generated
	RADIO_EVENTS_SYNC_EVENTS_SYNC_Generated = 0x1

	// EVENTS_PHYEND: Generated in Ble_LR125Kbit, Ble_LR500Kbit and Ieee802154_250Kbit modes when last bit is sent on air.
	// Position of EVENTS_PHYEND field.
	RADIO_EVENTS_PHYEND_EVENTS_PHYEND_Pos = 0x0
	// Bit mask of EVENTS_PHYEND field.
	RADIO_EVENTS_PHYEND_EVENTS_PHYEND_Msk = 0x1
	// Bit EVENTS_PHYEND.
	RADIO_EVENTS_PHYEND_EVENTS_PHYEND = 0x1
	// Event not generated
	RADIO_EVENTS_PHYEND_EVENTS_PHYEND_NotGenerated = 0x0
	// Event generated
	RADIO_EVENTS_PHYEND_EVENTS_PHYEND_Generated = 0x1

	// SHORTS: Shortcuts between local events and tasks
	// Position of READY_START field.
	RADIO_SHORTS_READY_START_Pos = 0x0
	// Bit mask of READY_START field.
	RADIO_SHORTS_READY_START_Msk = 0x1
	// Bit READY_START.
	RADIO_SHORTS_READY_START = 0x1
	// Disable shortcut
	RADIO_SHORTS_READY_START_Disabled = 0x0
	// Enable shortcut
	RADIO_SHORTS_READY_START_Enabled = 0x1
	// Position of END_DISABLE field.
	RADIO_SHORTS_END_DISABLE_Pos = 0x1
	// Bit mask of END_DISABLE field.
	RADIO_SHORTS_END_DISABLE_Msk = 0x2
	// Bit END_DISABLE.
	RADIO_SHORTS_END_DISABLE = 0x2
	// Disable shortcut
	RADIO_SHORTS_END_DISABLE_Disabled = 0x0
	// Enable shortcut
	RADIO_SHORTS_END_DISABLE_Enabled = 0x1
	// Position of DISABLED_TXEN field.
	RADIO_SHORTS_DISABLED_TXEN_Pos = 0x2
	// Bit mask of DISABLED_TXEN field.
	RADIO_SHORTS_DISABLED_TXEN_Msk = 0x4
	// Bit DISABLED_TXEN.
	RADIO_SHORTS_DISABLED_TXEN = 0x4
	// Disable shortcut
	RADIO_SHORTS_DISABLED_TXEN_Disabled = 0x0
	// Enable shortcut
	RADIO_SHORTS_DISABLED_TXEN_Enabled = 0x1
	// Position of DISABLED_RXEN field.
	RADIO_SHORTS_DISABLED_RXEN_Pos = 0x3
	// Bit mask of DISABLED_RXEN field.
	RADIO_SHORTS_DISABLED_RXEN_Msk = 0x8
	// Bit DISABLED_RXEN.
	RADIO_SHORTS_DISABLED_RXEN = 0x8
	// Disable shortcut
	RADIO_SHORTS_DISABLED_RXEN_Disabled = 0x0
	// Enable shortcut
	RADIO_SHORTS_DISABLED_RXEN_Enabled = 0x1
	// Position of ADDRESS_RSSISTART field.
	RADIO_SHORTS_ADDRESS_RSSISTART_Pos = 0x4
	// Bit mask of ADDRESS_RSSISTART field.
	RADIO_SHORTS_ADDRESS_RSSISTART_Msk = 0x10
	// Bit ADDRESS_RSSISTART.
	RADIO_SHORTS_ADDRESS_RSSISTART = 0x10
	// Disable shortcut
	RADIO_SHORTS_ADDRESS_RSSISTART_Disabled = 0x0
	// Enable shortcut
	RADIO_SHORTS_ADDRESS_RSSISTART_Enabled = 0x1
	// Position of END_START field.
	RADIO_SHORTS_END_START_Pos = 0x5
	// Bit mask of END_START field.
	RADIO_SHORTS_END_START_Msk = 0x20
	// Bit END_START.
	RADIO_SHORTS_END_START = 0x20
	// Disable shortcut
	RADIO_SHORTS_END_START_Disabled = 0x0
	// Enable shortcut
	RADIO_SHORTS_END_START_Enabled = 0x1
	// Position of ADDRESS_BCSTART field.
	RADIO_SHORTS_ADDRESS_BCSTART_Pos = 0x6
	// Bit mask of ADDRESS_BCSTART field.
	RADIO_SHORTS_ADDRESS_BCSTART_Msk = 0x40
	// Bit ADDRESS_BCSTART.
	RADIO_SHORTS_ADDRESS_BCSTART = 0x40
	// Disable shortcut
	RADIO_SHORTS_ADDRESS_BCSTART_Disabled = 0x0
	// Enable shortcut
	RADIO_SHORTS_ADDRESS_BCSTART_Enabled = 0x1
	// Position of DISABLED_RSSISTOP field.
	RADIO_SHORTS_DISABLED_RSSISTOP_Pos = 0x8
	// Bit mask of DISABLED_RSSISTOP field.
	RADIO_SHORTS_DISABLED_RSSISTOP_Msk = 0x100
	// Bit DISABLED_RSSISTOP.
	RADIO_SHORTS_DISABLED_RSSISTOP = 0x100
	// Disable shortcut
	RADIO_SHORTS_DISABLED_RSSISTOP_Disabled = 0x0
	// Enable shortcut
	RADIO_SHORTS_DISABLED_RSSISTOP_Enabled = 0x1
	// Position of RXREADY_CCASTART field.
	RADIO_SHORTS_RXREADY_CCASTART_Pos = 0xb
	// Bit mask of RXREADY_CCASTART field.
	RADIO_SHORTS_RXREADY_CCASTART_Msk = 0x800
	// Bit RXREADY_CCASTART.
	RADIO_SHORTS_RXREADY_CCASTART = 0x800
	// Disable shortcut
	RADIO_SHORTS_RXREADY_CCASTART_Disabled = 0x0
	// Enable shortcut
	RADIO_SHORTS_RXREADY_CCASTART_Enabled = 0x1
	// Position of CCAIDLE_TXEN field.
	RADIO_SHORTS_CCAIDLE_TXEN_Pos = 0xc
	// Bit mask of CCAIDLE_TXEN field.
	RADIO_SHORTS_CCAIDLE_TXEN_Msk = 0x1000
	// Bit CCAIDLE_TXEN.
	RADIO_SHORTS_CCAIDLE_TXEN = 0x1000
	// Disable shortcut
	RADIO_SHORTS_CCAIDLE_TXEN_Disabled = 0x0
	// Enable shortcut
	RADIO_SHORTS_CCAIDLE_TXEN_Enabled = 0x1
	// Position of CCABUSY_DISABLE field.
	RADIO_SHORTS_CCABUSY_DISABLE_Pos = 0xd
	// Bit mask of CCABUSY_DISABLE field.
	RADIO_SHORTS_CCABUSY_DISABLE_Msk = 0x2000
	// Bit CCABUSY_DISABLE.
	RADIO_SHORTS_CCABUSY_DISABLE = 0x2000
	// Disable shortcut
	RADIO_SHORTS_CCABUSY_DISABLE_Disabled = 0x0
	// Enable shortcut
	RADIO_SHORTS_CCABUSY_DISABLE_Enabled = 0x1
	// Position of FRAMESTART_BCSTART field.
	RADIO_SHORTS_FRAMESTART_BCSTART_Pos = 0xe
	// Bit mask of FRAMESTART_BCSTART field.
	RADIO_SHORTS_FRAMESTART_BCSTART_Msk = 0x4000
	// Bit FRAMESTART_BCSTART.
	RADIO_SHORTS_FRAMESTART_BCSTART = 0x4000
	// Disable shortcut
	RADIO_SHORTS_FRAMESTART_BCSTART_Disabled = 0x0
	// Enable shortcut
	RADIO_SHORTS_FRAMESTART_BCSTART_Enabled = 0x1
	// Position of READY_EDSTART field.
	RADIO_SHORTS_READY_EDSTART_Pos = 0xf
	// Bit mask of READY_EDSTART field.
	RADIO_SHORTS_READY_EDSTART_Msk = 0x8000
	// Bit READY_EDSTART.
	RADIO_SHORTS_READY_EDSTART = 0x8000
	// Disable shortcut
	RADIO_SHORTS_READY_EDSTART_Disabled = 0x0
	// Enable shortcut
	RADIO_SHORTS_READY_EDSTART_Enabled = 0x1
	// Position of EDEND_DISABLE field.
	RADIO_SHORTS_EDEND_DISABLE_Pos = 0x10
	// Bit mask of EDEND_DISABLE field.
	RADIO_SHORTS_EDEND_DISABLE_Msk = 0x10000
	// Bit EDEND_DISABLE.
	RADIO_SHORTS_EDEND_DISABLE = 0x10000
	// Disable shortcut
	RADIO_SHORTS_EDEND_DISABLE_Disabled = 0x0
	// Enable shortcut
	RADIO_SHORTS_EDEND_DISABLE_Enabled = 0x1
	// Position of CCAIDLE_STOP field.
	RADIO_SHORTS_CCAIDLE_STOP_Pos = 0x11
	// Bit mask of CCAIDLE_STOP field.
	RADIO_SHORTS_CCAIDLE_STOP_Msk = 0x20000
	// Bit CCAIDLE_STOP.
	RADIO_SHORTS_CCAIDLE_STOP = 0x20000
	// Disable shortcut
	RADIO_SHORTS_CCAIDLE_STOP_Disabled = 0x0
	// Enable shortcut
	RADIO_SHORTS_CCAIDLE_STOP_Enabled = 0x1
	// Position of TXREADY_START field.
	RADIO_SHORTS_TXREADY_START_Pos = 0x12
	// Bit mask of TXREADY_START field.
	RADIO_SHORTS_TXREADY_START_Msk = 0x40000
	// Bit TXREADY_START.
	RADIO_SHORTS_TXREADY_START = 0x40000
	// Disable shortcut
	RADIO_SHORTS_TXREADY_START_Disabled = 0x0
	// Enable shortcut
	RADIO_SHORTS_TXREADY_START_Enabled = 0x1
	// Position of RXREADY_START field.
	RADIO_SHORTS_RXREADY_START_Pos = 0x13
	// Bit mask of RXREADY_START field.
	RADIO_SHORTS_RXREADY_START_Msk = 0x80000
	// Bit RXREADY_START.
	RADIO_SHORTS_RXREADY_START = 0x80000
	// Disable shortcut
	RADIO_SHORTS_RXREADY_START_Disabled = 0x0
	// Enable shortcut
	RADIO_SHORTS_RXREADY_START_Enabled = 0x1
	// Position of PHYEND_DISABLE field.
	RADIO_SHORTS_PHYEND_DISABLE_Pos = 0x14
	// Bit mask of PHYEND_DISABLE field.
	RADIO_SHORTS_PHYEND_DISABLE_Msk = 0x100000
	// Bit PHYEND_DISABLE.
	RADIO_SHORTS_PHYEND_DISABLE = 0x100000
	// Disable shortcut
	RADIO_SHORTS_PHYEND_DISABLE_Disabled = 0x0
	// Enable shortcut
	RADIO_SHORTS_PHYEND_DISABLE_Enabled = 0x1
	// Position of PHYEND_START field.
	RADIO_SHORTS_PHYEND_START_Pos = 0x15
	// Bit mask of PHYEND_START field.
	RADIO_SHORTS_PHYEND_START_Msk = 0x200000
	// Bit PHYEND_START.
	RADIO_SHORTS_PHYEND_START = 0x200000
	// Disable shortcut
	RADIO_SHORTS_PHYEND_START_Disabled = 0x0
	// Enable shortcut
	RADIO_SHORTS_PHYEND_START_Enabled = 0x1

	// INTENSET: Enable interrupt
	// Position of READY field.
	RADIO_INTENSET_READY_Pos = 0x0
	// Bit mask of READY field.
	RADIO_INTENSET_READY_Msk = 0x1
	// Bit READY.
	RADIO_INTENSET_READY = 0x1
	// Read: Disabled
	RADIO_INTENSET_READY_Disabled = 0x0
	// Read: Enabled
	RADIO_INTENSET_READY_Enabled = 0x1
	// Enable
	RADIO_INTENSET_READY_Set = 0x1
	// Position of ADDRESS field.
	RADIO_INTENSET_ADDRESS_Pos = 0x1
	// Bit mask of ADDRESS field.
	RADIO_INTENSET_ADDRESS_Msk = 0x2
	// Bit ADDRESS.
	RADIO_INTENSET_ADDRESS = 0x2
	// Read: Disabled
	RADIO_INTENSET_ADDRESS_Disabled = 0x0
	// Read: Enabled
	RADIO_INTENSET_ADDRESS_Enabled = 0x1
	// Enable
	RADIO_INTENSET_ADDRESS_Set = 0x1
	// Position of PAYLOAD field.
	RADIO_INTENSET_PAYLOAD_Pos = 0x2
	// Bit mask of PAYLOAD field.
	RADIO_INTENSET_PAYLOAD_Msk = 0x4
	// Bit PAYLOAD.
	RADIO_INTENSET_PAYLOAD = 0x4
	// Read: Disabled
	RADIO_INTENSET_PAYLOAD_Disabled = 0x0
	// Read: Enabled
	RADIO_INTENSET_PAYLOAD_Enabled = 0x1
	// Enable
	RADIO_INTENSET_PAYLOAD_Set = 0x1
	// Position of END field.
	RADIO_INTENSET_END_Pos = 0x3
	// Bit mask of END field.
	RADIO_INTENSET_END_Msk = 0x8
	// Bit END.
	RADIO_INTENSET_END = 0x8
	// Read: Disabled
	RADIO_INTENSET_END_Disabled = 0x0
	// Read: Enabled
	RADIO_INTENSET_END_Enabled = 0x1
	// Enable
	RADIO_INTENSET_END_Set = 0x1
	// Position of DISABLED field.
	RADIO_INTENSET_DISABLED_Pos = 0x4
	// Bit mask of DISABLED field.
	RADIO_INTENSET_DISABLED_Msk = 0x10
	// Bit DISABLED.
	RADIO_INTENSET_DISABLED = 0x10
	// Read: Disabled
	RADIO_INTENSET_DISABLED_Disabled = 0x0
	// Read: Enabled
	RADIO_INTENSET_DISABLED_Enabled = 0x1
	// Enable
	RADIO_INTENSET_DISABLED_Set = 0x1
	// Position of DEVMATCH field.
	RADIO_INTENSET_DEVMATCH_Pos = 0x5
	// Bit mask of DEVMATCH field.
	RADIO_INTENSET_DEVMATCH_Msk = 0x20
	// Bit DEVMATCH.
	RADIO_INTENSET_DEVMATCH = 0x20
	// Read: Disabled
	RADIO_INTENSET_DEVMATCH_Disabled = 0x0
	// Read: Enabled
	RADIO_INTENSET_DEVMATCH_Enabled = 0x1
	// Enable
	RADIO_INTENSET_DEVMATCH_Set = 0x1
	// Position of DEVMISS field.
	RADIO_INTENSET_DEVMISS_Pos = 0x6
	// Bit mask of DEVMISS field.
	RADIO_INTENSET_DEVMISS_Msk = 0x40
	// Bit DEVMISS.
	RADIO_INTENSET_DEVMISS = 0x40
	// Read: Disabled
	RADIO_INTENSET_DEVMISS_Disabled = 0x0
	// Read: Enabled
	RADIO_INTENSET_DEVMISS_Enabled = 0x1
	// Enable
	RADIO_INTENSET_DEVMISS_Set = 0x1
	// Position of RSSIEND field.
	RADIO_INTENSET_RSSIEND_Pos = 0x7
	// Bit mask of RSSIEND field.
	RADIO_INTENSET_RSSIEND_Msk = 0x80
	// Bit RSSIEND.
	RADIO_INTENSET_RSSIEND = 0x80
	// Read: Disabled
	RADIO_INTENSET_RSSIEND_Disabled = 0x0
	// Read: Enabled
	RADIO_INTENSET_RSSIEND_Enabled = 0x1
	// Enable
	RADIO_INTENSET_RSSIEND_Set = 0x1
	// Position of BCMATCH field.
	RADIO_INTENSET_BCMATCH_Pos = 0xa
	// Bit mask of BCMATCH field.
	RADIO_INTENSET_BCMATCH_Msk = 0x400
	// Bit BCMATCH.
	RADIO_INTENSET_BCMATCH = 0x400
	// Read: Disabled
	RADIO_INTENSET_BCMATCH_Disabled = 0x0
	// Read: Enabled
	RADIO_INTENSET_BCMATCH_Enabled = 0x1
	// Enable
	RADIO_INTENSET_BCMATCH_Set = 0x1
	// Position of CRCOK field.
	RADIO_INTENSET_CRCOK_Pos = 0xc
	// Bit mask of CRCOK field.
	RADIO_INTENSET_CRCOK_Msk = 0x1000
	// Bit CRCOK.
	RADIO_INTENSET_CRCOK = 0x1000
	// Read: Disabled
	RADIO_INTENSET_CRCOK_Disabled = 0x0
	// Read: Enabled
	RADIO_INTENSET_CRCOK_Enabled = 0x1
	// Enable
	RADIO_INTENSET_CRCOK_Set = 0x1
	// Position of CRCERROR field.
	RADIO_INTENSET_CRCERROR_Pos = 0xd
	// Bit mask of CRCERROR field.
	RADIO_INTENSET_CRCERROR_Msk = 0x2000
	// Bit CRCERROR.
	RADIO_INTENSET_CRCERROR = 0x2000
	// Read: Disabled
	RADIO_INTENSET_CRCERROR_Disabled = 0x0
	// Read: Enabled
	RADIO_INTENSET_CRCERROR_Enabled = 0x1
	// Enable
	RADIO_INTENSET_CRCERROR_Set = 0x1
	// Position of FRAMESTART field.
	RADIO_INTENSET_FRAMESTART_Pos = 0xe
	// Bit mask of FRAMESTART field.
	RADIO_INTENSET_FRAMESTART_Msk = 0x4000
	// Bit FRAMESTART.
	RADIO_INTENSET_FRAMESTART = 0x4000
	// Read: Disabled
	RADIO_INTENSET_FRAMESTART_Disabled = 0x0
	// Read: Enabled
	RADIO_INTENSET_FRAMESTART_Enabled = 0x1
	// Enable
	RADIO_INTENSET_FRAMESTART_Set = 0x1
	// Position of EDEND field.
	RADIO_INTENSET_EDEND_Pos = 0xf
	// Bit mask of EDEND field.
	RADIO_INTENSET_EDEND_Msk = 0x8000
	// Bit EDEND.
	RADIO_INTENSET_EDEND = 0x8000
	// Read: Disabled
	RADIO_INTENSET_EDEND_Disabled = 0x0
	// Read: Enabled
	RADIO_INTENSET_EDEND_Enabled = 0x1
	// Enable
	RADIO_INTENSET_EDEND_Set = 0x1
	// Position of EDSTOPPED field.
	RADIO_INTENSET_EDSTOPPED_Pos = 0x10
	// Bit mask of EDSTOPPED field.
	RADIO_INTENSET_EDSTOPPED_Msk = 0x10000
	// Bit EDSTOPPED.
	RADIO_INTENSET_EDSTOPPED = 0x10000
	// Read: Disabled
	RADIO_INTENSET_EDSTOPPED_Disabled = 0x0
	// Read: Enabled
	RADIO_INTENSET_EDSTOPPED_Enabled = 0x1
	// Enable
	RADIO_INTENSET_EDSTOPPED_Set = 0x1
	// Position of CCAIDLE field.
	RADIO_INTENSET_CCAIDLE_Pos = 0x11
	// Bit mask of CCAIDLE field.
	RADIO_INTENSET_CCAIDLE_Msk = 0x20000
	// Bit CCAIDLE.
	RADIO_INTENSET_CCAIDLE = 0x20000
	// Read: Disabled
	RADIO_INTENSET_CCAIDLE_Disabled = 0x0
	// Read: Enabled
	RADIO_INTENSET_CCAIDLE_Enabled = 0x1
	// Enable
	RADIO_INTENSET_CCAIDLE_Set = 0x1
	// Position of CCABUSY field.
	RADIO_INTENSET_CCABUSY_Pos = 0x12
	// Bit mask of CCABUSY field.
	RADIO_INTENSET_CCABUSY_Msk = 0x40000
	// Bit CCABUSY.
	RADIO_INTENSET_CCABUSY = 0x40000
	// Read: Disabled
	RADIO_INTENSET_CCABUSY_Disabled = 0x0
	// Read: Enabled
	RADIO_INTENSET_CCABUSY_Enabled = 0x1
	// Enable
	RADIO_INTENSET_CCABUSY_Set = 0x1
	// Position of CCASTOPPED field.
	RADIO_INTENSET_CCASTOPPED_Pos = 0x13
	// Bit mask of CCASTOPPED field.
	RADIO_INTENSET_CCASTOPPED_Msk = 0x80000
	// Bit CCASTOPPED.
	RADIO_INTENSET_CCASTOPPED = 0x80000
	// Read: Disabled
	RADIO_INTENSET_CCASTOPPED_Disabled = 0x0
	// Read: Enabled
	RADIO_INTENSET_CCASTOPPED_Enabled = 0x1
	// Enable
	RADIO_INTENSET_CCASTOPPED_Set = 0x1
	// Position of RATEBOOST field.
	RADIO_INTENSET_RATEBOOST_Pos = 0x14
	// Bit mask of RATEBOOST field.
	RADIO_INTENSET_RATEBOOST_Msk = 0x100000
	// Bit RATEBOOST.
	RADIO_INTENSET_RATEBOOST = 0x100000
	// Read: Disabled
	RADIO_INTENSET_RATEBOOST_Disabled = 0x0
	// Read: Enabled
	RADIO_INTENSET_RATEBOOST_Enabled = 0x1
	// Enable
	RADIO_INTENSET_RATEBOOST_Set = 0x1
	// Position of TXREADY field.
	RADIO_INTENSET_TXREADY_Pos = 0x15
	// Bit mask of TXREADY field.
	RADIO_INTENSET_TXREADY_Msk = 0x200000
	// Bit TXREADY.
	RADIO_INTENSET_TXREADY = 0x200000
	// Read: Disabled
	RADIO_INTENSET_TXREADY_Disabled = 0x0
	// Read: Enabled
	RADIO_INTENSET_TXREADY_Enabled = 0x1
	// Enable
	RADIO_INTENSET_TXREADY_Set = 0x1
	// Position of RXREADY field.
	RADIO_INTENSET_RXREADY_Pos = 0x16
	// Bit mask of RXREADY field.
	RADIO_INTENSET_RXREADY_Msk = 0x400000
	// Bit RXREADY.
	RADIO_INTENSET_RXREADY = 0x400000
	// Read: Disabled
	RADIO_INTENSET_RXREADY_Disabled = 0x0
	// Read: Enabled
	RADIO_INTENSET_RXREADY_Enabled = 0x1
	// Enable
	RADIO_INTENSET_RXREADY_Set = 0x1
	// Position of MHRMATCH field.
	RADIO_INTENSET_MHRMATCH_Pos = 0x17
	// Bit mask of MHRMATCH field.
	RADIO_INTENSET_MHRMATCH_Msk = 0x800000
	// Bit MHRMATCH.
	RADIO_INTENSET_MHRMATCH = 0x800000
	// Read: Disabled
	RADIO_INTENSET_MHRMATCH_Disabled = 0x0
	// Read: Enabled
	RADIO_INTENSET_MHRMATCH_Enabled = 0x1
	// Enable
	RADIO_INTENSET_MHRMATCH_Set = 0x1
	// Position of SYNC field.
	RADIO_INTENSET_SYNC_Pos = 0x1a
	// Bit mask of SYNC field.
	RADIO_INTENSET_SYNC_Msk = 0x4000000
	// Bit SYNC.
	RADIO_INTENSET_SYNC = 0x4000000
	// Read: Disabled
	RADIO_INTENSET_SYNC_Disabled = 0x0
	// Read: Enabled
	RADIO_INTENSET_SYNC_Enabled = 0x1
	// Enable
	RADIO_INTENSET_SYNC_Set = 0x1
	// Position of PHYEND field.
	RADIO_INTENSET_PHYEND_Pos = 0x1b
	// Bit mask of PHYEND field.
	RADIO_INTENSET_PHYEND_Msk = 0x8000000
	// Bit PHYEND.
	RADIO_INTENSET_PHYEND = 0x8000000
	// Read: Disabled
	RADIO_INTENSET_PHYEND_Disabled = 0x0
	// Read: Enabled
	RADIO_INTENSET_PHYEND_Enabled = 0x1
	// Enable
	RADIO_INTENSET_PHYEND_Set = 0x1

	// INTENCLR: Disable interrupt
	// Position of READY field.
	RADIO_INTENCLR_READY_Pos = 0x0
	// Bit mask of READY field.
	RADIO_INTENCLR_READY_Msk = 0x1
	// Bit READY.
	RADIO_INTENCLR_READY = 0x1
	// Read: Disabled
	RADIO_INTENCLR_READY_Disabled = 0x0
	// Read: Enabled
	RADIO_INTENCLR_READY_Enabled = 0x1
	// Disable
	RADIO_INTENCLR_READY_Clear = 0x1
	// Position of ADDRESS field.
	RADIO_INTENCLR_ADDRESS_Pos = 0x1
	// Bit mask of ADDRESS field.
	RADIO_INTENCLR_ADDRESS_Msk = 0x2
	// Bit ADDRESS.
	RADIO_INTENCLR_ADDRESS = 0x2
	// Read: Disabled
	RADIO_INTENCLR_ADDRESS_Disabled = 0x0
	// Read: Enabled
	RADIO_INTENCLR_ADDRESS_Enabled = 0x1
	// Disable
	RADIO_INTENCLR_ADDRESS_Clear = 0x1
	// Position of PAYLOAD field.
	RADIO_INTENCLR_PAYLOAD_Pos = 0x2
	// Bit mask of PAYLOAD field.
	RADIO_INTENCLR_PAYLOAD_Msk = 0x4
	// Bit PAYLOAD.
	RADIO_INTENCLR_PAYLOAD = 0x4
	// Read: Disabled
	RADIO_INTENCLR_PAYLOAD_Disabled = 0x0
	// Read: Enabled
	RADIO_INTENCLR_PAYLOAD_Enabled = 0x1
	// Disable
	RADIO_INTENCLR_PAYLOAD_Clear = 0x1
	// Position of END field.
	RADIO_INTENCLR_END_Pos = 0x3
	// Bit mask of END field.
	RADIO_INTENCLR_END_Msk = 0x8
	// Bit END.
	RADIO_INTENCLR_END = 0x8
	// Read: Disabled
	RADIO_INTENCLR_END_Disabled = 0x0
	// Read: Enabled
	RADIO_INTENCLR_END_Enabled = 0x1
	// Disable
	RADIO_INTENCLR_END_Clear = 0x1
	// Position of DISABLED field.
	RADIO_INTENCLR_DISABLED_Pos = 0x4
	// Bit mask of DISABLED field.
	RADIO_INTENCLR_DISABLED_Msk = 0x10
	// Bit DISABLED.
	RADIO_INTENCLR_DISABLED = 0x10
	// Read: Disabled
	RADIO_INTENCLR_DISABLED_Disabled = 0x0
	// Read: Enabled
	RADIO_INTENCLR_DISABLED_Enabled = 0x1
	// Disable
	RADIO_INTENCLR_DISABLED_Clear = 0x1
	// Position of DEVMATCH field.
	RADIO_INTENCLR_DEVMATCH_Pos = 0x5
	// Bit mask of DEVMATCH field.
	RADIO_INTENCLR_DEVMATCH_Msk = 0x20
	// Bit DEVMATCH.
	RADIO_INTENCLR_DEVMATCH = 0x20
	// Read: Disabled
	RADIO_INTENCLR_DEVMATCH_Disabled = 0x0
	// Read: Enabled
	RADIO_INTENCLR_DEVMATCH_Enabled = 0x1
	// Disable
	RADIO_INTENCLR_DEVMATCH_Clear = 0x1
	// Position of DEVMISS field.
	RADIO_INTENCLR_DEVMISS_Pos = 0x6
	// Bit mask of DEVMISS field.
	RADIO_INTENCLR_DEVMISS_Msk = 0x40
	// Bit DEVMISS.
	RADIO_INTENCLR_DEVMISS = 0x40
	// Read: Disabled
	RADIO_INTENCLR_DEVMISS_Disabled = 0x0
	// Read: Enabled
	RADIO_INTENCLR_DEVMISS_Enabled = 0x1
	// Disable
	RADIO_INTENCLR_DEVMISS_Clear = 0x1
	// Position of RSSIEND field.
	RADIO_INTENCLR_RSSIEND_Pos = 0x7
	// Bit mask of RSSIEND field.
	RADIO_INTENCLR_RSSIEND_Msk = 0x80
	// Bit RSSIEND.
	RADIO_INTENCLR_RSSIEND = 0x80
	// Read: Disabled
	RADIO_INTENCLR_RSSIEND_Disabled = 0x0
	// Read: Enabled
	RADIO_INTENCLR_RSSIEND_Enabled = 0x1
	// Disable
	RADIO_INTENCLR_RSSIEND_Clear = 0x1
	// Position of BCMATCH field.
	RADIO_INTENCLR_BCMATCH_Pos = 0xa
	// Bit mask of BCMATCH field.
	RADIO_INTENCLR_BCMATCH_Msk = 0x400
	// Bit BCMATCH.
	RADIO_INTENCLR_BCMATCH = 0x400
	// Read: Disabled
	RADIO_INTENCLR_BCMATCH_Disabled = 0x0
	// Read: Enabled
	RADIO_INTENCLR_BCMATCH_Enabled = 0x1
	// Disable
	RADIO_INTENCLR_BCMATCH_Clear = 0x1
	// Position of CRCOK field.
	RADIO_INTENCLR_CRCOK_Pos = 0xc
	// Bit mask of CRCOK field.
	RADIO_INTENCLR_CRCOK_Msk = 0x1000
	// Bit CRCOK.
	RADIO_INTENCLR_CRCOK = 0x1000
	// Read: Disabled
	RADIO_INTENCLR_CRCOK_Disabled = 0x0
	// Read: Enabled
	RADIO_INTENCLR_CRCOK_Enabled = 0x1
	// Disable
	RADIO_INTENCLR_CRCOK_Clear = 0x1
	// Position of CRCERROR field.
	RADIO_INTENCLR_CRCERROR_Pos = 0xd
	// Bit mask of CRCERROR field.
	RADIO_INTENCLR_CRCERROR_Msk = 0x2000
	// Bit CRCERROR.
	RADIO_INTENCLR_CRCERROR = 0x2000
	// Read: Disabled
	RADIO_INTENCLR_CRCERROR_Disabled = 0x0
	// Read: Enabled
	RADIO_INTENCLR_CRCERROR_Enabled = 0x1
	// Disable
	RADIO_INTENCLR_CRCERROR_Clear = 0x1
	// Position of FRAMESTART field.
	RADIO_INTENCLR_FRAMESTART_Pos = 0xe
	// Bit mask of FRAMESTART field.
	RADIO_INTENCLR_FRAMESTART_Msk = 0x4000
	// Bit FRAMESTART.
	RADIO_INTENCLR_FRAMESTART = 0x4000
	// Read: Disabled
	RADIO_INTENCLR_FRAMESTART_Disabled = 0x0
	// Read: Enabled
	RADIO_INTENCLR_FRAMESTART_Enabled = 0x1
	// Disable
	RADIO_INTENCLR_FRAMESTART_Clear = 0x1
	// Position of EDEND field.
	RADIO_INTENCLR_EDEND_Pos = 0xf
	// Bit mask of EDEND field.
	RADIO_INTENCLR_EDEND_Msk = 0x8000
	// Bit EDEND.
	RADIO_INTENCLR_EDEND = 0x8000
	// Read: Disabled
	RADIO_INTENCLR_EDEND_Disabled = 0x0
	// Read: Enabled
	RADIO_INTENCLR_EDEND_Enabled = 0x1
	// Disable
	RADIO_INTENCLR_EDEND_Clear = 0x1
	// Position of EDSTOPPED field.
	RADIO_INTENCLR_EDSTOPPED_Pos = 0x10
	// Bit mask of EDSTOPPED field.
	RADIO_INTENCLR_EDSTOPPED_Msk = 0x10000
	// Bit EDSTOPPED.
	RADIO_INTENCLR_EDSTOPPED = 0x10000
	// Read: Disabled
	RADIO_INTENCLR_EDSTOPPED_Disabled = 0x0
	// Read: Enabled
	RADIO_INTENCLR_EDSTOPPED_Enabled = 0x1
	// Disable
	RADIO_INTENCLR_EDSTOPPED_Clear = 0x1
	// Position of CCAIDLE field.
	RADIO_INTENCLR_CCAIDLE_Pos = 0x11
	// Bit mask of CCAIDLE field.
	RADIO_INTENCLR_CCAIDLE_Msk = 0x20000
	// Bit CCAIDLE.
	RADIO_INTENCLR_CCAIDLE = 0x20000
	// Read: Disabled
	RADIO_INTENCLR_CCAIDLE_Disabled = 0x0
	// Read: Enabled
	RADIO_INTENCLR_CCAIDLE_Enabled = 0x1
	// Disable
	RADIO_INTENCLR_CCAIDLE_Clear = 0x1
	// Position of CCABUSY field.
	RADIO_INTENCLR_CCABUSY_Pos = 0x12
	// Bit mask of CCABUSY field.
	RADIO_INTENCLR_CCABUSY_Msk = 0x40000
	// Bit CCABUSY.
	RADIO_INTENCLR_CCABUSY = 0x40000
	// Read: Disabled
	RADIO_INTENCLR_CCABUSY_Disabled = 0x0
	// Read: Enabled
	RADIO_INTENCLR_CCABUSY_Enabled = 0x1
	// Disable
	RADIO_INTENCLR_CCABUSY_Clear = 0x1
	// Position of CCASTOPPED field.
	RADIO_INTENCLR_CCASTOPPED_Pos = 0x13
	// Bit mask of CCASTOPPED field.
	RADIO_INTENCLR_CCASTOPPED_Msk = 0x80000
	// Bit CCASTOPPED.
	RADIO_INTENCLR_CCASTOPPED = 0x80000
	// Read: Disabled
	RADIO_INTENCLR_CCASTOPPED_Disabled = 0x0
	// Read: Enabled
	RADIO_INTENCLR_CCASTOPPED_Enabled = 0x1
	// Disable
	RADIO_INTENCLR_CCASTOPPED_Clear = 0x1
	// Position of RATEBOOST field.
	RADIO_INTENCLR_RATEBOOST_Pos = 0x14
	// Bit mask of RATEBOOST field.
	RADIO_INTENCLR_RATEBOOST_Msk = 0x100000
	// Bit RATEBOOST.
	RADIO_INTENCLR_RATEBOOST = 0x100000
	// Read: Disabled
	RADIO_INTENCLR_RATEBOOST_Disabled = 0x0
	// Read: Enabled
	RADIO_INTENCLR_RATEBOOST_Enabled = 0x1
	// Disable
	RADIO_INTENCLR_RATEBOOST_Clear = 0x1
	// Position of TXREADY field.
	RADIO_INTENCLR_TXREADY_Pos = 0x15
	// Bit mask of TXREADY field.
	RADIO_INTENCLR_TXREADY_Msk = 0x200000
	// Bit TXREADY.
	RADIO_INTENCLR_TXREADY = 0x200000
	// Read: Disabled
	RADIO_INTENCLR_TXREADY_Disabled = 0x0
	// Read: Enabled
	RADIO_INTENCLR_TXREADY_Enabled = 0x1
	// Disable
	RADIO_INTENCLR_TXREADY_Clear = 0x1
	// Position of RXREADY field.
	RADIO_INTENCLR_RXREADY_Pos = 0x16
	// Bit mask of RXREADY field.
	RADIO_INTENCLR_RXREADY_Msk = 0x400000
	// Bit RXREADY.
	RADIO_INTENCLR_RXREADY = 0x400000
	// Read: Disabled
	RADIO_INTENCLR_RXREADY_Disabled = 0x0
	// Read: Enabled
	RADIO_INTENCLR_RXREADY_Enabled = 0x1
	// Disable
	RADIO_INTENCLR_RXREADY_Clear = 0x1
	// Position of MHRMATCH field.
	RADIO_INTENCLR_MHRMATCH_Pos = 0x17
	// Bit mask of MHRMATCH field.
	RADIO_INTENCLR_MHRMATCH_Msk = 0x800000
	// Bit MHRMATCH.
	RADIO_INTENCLR_MHRMATCH = 0x800000
	// Read: Disabled
	RADIO_INTENCLR_MHRMATCH_Disabled = 0x0
	// Read: Enabled
	RADIO_INTENCLR_MHRMATCH_Enabled = 0x1
	// Disable
	RADIO_INTENCLR_MHRMATCH_Clear = 0x1
	// Position of SYNC field.
	RADIO_INTENCLR_SYNC_Pos = 0x1a
	// Bit mask of SYNC field.
	RADIO_INTENCLR_SYNC_Msk = 0x4000000
	// Bit SYNC.
	RADIO_INTENCLR_SYNC = 0x4000000
	// Read: Disabled
	RADIO_INTENCLR_SYNC_Disabled = 0x0
	// Read: Enabled
	RADIO_INTENCLR_SYNC_Enabled = 0x1
	// Disable
	RADIO_INTENCLR_SYNC_Clear = 0x1
	// Position of PHYEND field.
	RADIO_INTENCLR_PHYEND_Pos = 0x1b
	// Bit mask of PHYEND field.
	RADIO_INTENCLR_PHYEND_Msk = 0x8000000
	// Bit PHYEND.
	RADIO_INTENCLR_PHYEND = 0x8000000
	// Read: Disabled
	RADIO_INTENCLR_PHYEND_Disabled = 0x0
	// Read: Enabled
	RADIO_INTENCLR_PHYEND_Enabled = 0x1
	// Disable
	RADIO_INTENCLR_PHYEND_Clear = 0x1

	// CRCSTATUS: CRC status
	// Position of CRCSTATUS field.
	RADIO_CRCSTATUS_CRCSTATUS_Pos = 0x0
	// Bit mask of CRCSTATUS field.
	RADIO_CRCSTATUS_CRCSTATUS_Msk = 0x1
	// Bit CRCSTATUS.
	RADIO_CRCSTATUS_CRCSTATUS = 0x1
	// Packet received with CRC error
	RADIO_CRCSTATUS_CRCSTATUS_CRCError = 0x0
	// Packet received with CRC ok
	RADIO_CRCSTATUS_CRCSTATUS_CRCOk = 0x1

	// RXMATCH: Received address
	// Position of RXMATCH field.
	RADIO_RXMATCH_RXMATCH_Pos = 0x0
	// Bit mask of RXMATCH field.
	RADIO_RXMATCH_RXMATCH_Msk = 0x7

	// RXCRC: CRC field of previously received packet
	// Position of RXCRC field.
	RADIO_RXCRC_RXCRC_Pos = 0x0
	// Bit mask of RXCRC field.
	RADIO_RXCRC_RXCRC_Msk = 0xffffff

	// DAI: Device address match index
	// Position of DAI field.
	RADIO_DAI_DAI_Pos = 0x0
	// Bit mask of DAI field.
	RADIO_DAI_DAI_Msk = 0x7

	// PDUSTAT: Payload status
	// Position of PDUSTAT field.
	RADIO_PDUSTAT_PDUSTAT_Pos = 0x0
	// Bit mask of PDUSTAT field.
	RADIO_PDUSTAT_PDUSTAT_Msk = 0x1
	// Bit PDUSTAT.
	RADIO_PDUSTAT_PDUSTAT = 0x1
	// Payload less than PCNF1.MAXLEN
	RADIO_PDUSTAT_PDUSTAT_LessThan = 0x0
	// Payload greater than PCNF1.MAXLEN
	RADIO_PDUSTAT_PDUSTAT_GreaterThan = 0x1
	// Position of CISTAT field.
	RADIO_PDUSTAT_CISTAT_Pos = 0x1
	// Bit mask of CISTAT field.
	RADIO_PDUSTAT_CISTAT_Msk = 0x6
	// Frame is received at 125kbps
	RADIO_PDUSTAT_CISTAT_LR125kbit = 0x0
	// Frame is received at 500kbps
	RADIO_PDUSTAT_CISTAT_LR500kbit = 0x1

	// PACKETPTR: Packet pointer
	// Position of PACKETPTR field.
	RADIO_PACKETPTR_PACKETPTR_Pos = 0x0
	// Bit mask of PACKETPTR field.
	RADIO_PACKETPTR_PACKETPTR_Msk = 0xffffffff

	// FREQUENCY: Frequency
	// Position of FREQUENCY field.
	RADIO_FREQUENCY_FREQUENCY_Pos = 0x0
	// Bit mask of FREQUENCY field.
	RADIO_FREQUENCY_FREQUENCY_Msk = 0x7f
	// Position of MAP field.
	RADIO_FREQUENCY_MAP_Pos = 0x8
	// Bit mask of MAP field.
	RADIO_FREQUENCY_MAP_Msk = 0x100
	// Bit MAP.
	RADIO_FREQUENCY_MAP = 0x100
	// Channel map between 2400 MHZ .. 2500 MHz
	RADIO_FREQUENCY_MAP_Default = 0x0
	// Channel map between 2360 MHZ .. 2460 MHz
	RADIO_FREQUENCY_MAP_Low = 0x1

	// TXPOWER: Output power
	// Position of TXPOWER field.
	RADIO_TXPOWER_TXPOWER_Pos = 0x0
	// Bit mask of TXPOWER field.
	RADIO_TXPOWER_TXPOWER_Msk = 0xff
	// +8 dBm
	RADIO_TXPOWER_TXPOWER_Pos8dBm = 0x8
	// +7 dBm
	RADIO_TXPOWER_TXPOWER_Pos7dBm = 0x7
	// +6 dBm
	RADIO_TXPOWER_TXPOWER_Pos6dBm = 0x6
	// +5 dBm
	RADIO_TXPOWER_TXPOWER_Pos5dBm = 0x5
	// +4 dBm
	RADIO_TXPOWER_TXPOWER_Pos4dBm = 0x4
	// +3 dBm
	RADIO_TXPOWER_TXPOWER_Pos3dBm = 0x3
	// +2 dBm
	RADIO_TXPOWER_TXPOWER_Pos2dBm = 0x2
	// 0 dBm
	RADIO_TXPOWER_TXPOWER_0dBm = 0x0
	// -4 dBm
	RADIO_TXPOWER_TXPOWER_Neg4dBm = 0xfc
	// -8 dBm
	RADIO_TXPOWER_TXPOWER_Neg8dBm = 0xf8
	// -12 dBm
	RADIO_TXPOWER_TXPOWER_Neg12dBm = 0xf4
	// -16 dBm
	RADIO_TXPOWER_TXPOWER_Neg16dBm = 0xf0
	// -20 dBm
	RADIO_TXPOWER_TXPOWER_Neg20dBm = 0xec
	// Deprecated enumerator - -40 dBm
	RADIO_TXPOWER_TXPOWER_Neg30dBm = 0xe2
	// -40 dBm
	RADIO_TXPOWER_TXPOWER_Neg40dBm = 0xd8

	// MODE: Data rate and modulation
	// Position of MODE field.
	RADIO_MODE_MODE_Pos = 0x0
	// Bit mask of MODE field.
	RADIO_MODE_MODE_Msk = 0xf
	// 1 Mbit/s Nordic proprietary radio mode
	RADIO_MODE_MODE_Nrf_1Mbit = 0x0
	// 2 Mbit/s Nordic proprietary radio mode
	RADIO_MODE_MODE_Nrf_2Mbit = 0x1
	// 1 Mbit/s BLE
	RADIO_MODE_MODE_Ble_1Mbit = 0x3
	// 2 Mbit/s BLE
	RADIO_MODE_MODE_Ble_2Mbit = 0x4
	// Long range 125 kbit/s TX, 125 kbit/s and 500 kbit/s RX
	RADIO_MODE_MODE_Ble_LR125Kbit = 0x5
	// Long range 500 kbit/s TX, 125 kbit/s and 500 kbit/s RX
	RADIO_MODE_MODE_Ble_LR500Kbit = 0x6
	// IEEE 802.15.4-2006 250 kbit/s
	RADIO_MODE_MODE_Ieee802154_250Kbit = 0xf

	// PCNF0: Packet configuration register 0
	// Position of LFLEN field.
	RADIO_PCNF0_LFLEN_Pos = 0x0
	// Bit mask of LFLEN field.
	RADIO_PCNF0_LFLEN_Msk = 0xf
	// Position of S0LEN field.
	RADIO_PCNF0_S0LEN_Pos = 0x8
	// Bit mask of S0LEN field.
	RADIO_PCNF0_S0LEN_Msk = 0x100
	// Bit S0LEN.
	RADIO_PCNF0_S0LEN = 0x100
	// Position of S1LEN field.
	RADIO_PCNF0_S1LEN_Pos = 0x10
	// Bit mask of S1LEN field.
	RADIO_PCNF0_S1LEN_Msk = 0xf0000
	// Position of S1INCL field.
	RADIO_PCNF0_S1INCL_Pos = 0x14
	// Bit mask of S1INCL field.
	RADIO_PCNF0_S1INCL_Msk = 0x100000
	// Bit S1INCL.
	RADIO_PCNF0_S1INCL = 0x100000
	// Include S1 field in RAM only if S1LEN &gt; 0
	RADIO_PCNF0_S1INCL_Automatic = 0x0
	// Always include S1 field in RAM independent of S1LEN
	RADIO_PCNF0_S1INCL_Include = 0x1
	// Position of CILEN field.
	RADIO_PCNF0_CILEN_Pos = 0x16
	// Bit mask of CILEN field.
	RADIO_PCNF0_CILEN_Msk = 0xc00000
	// Position of PLEN field.
	RADIO_PCNF0_PLEN_Pos = 0x18
	// Bit mask of PLEN field.
	RADIO_PCNF0_PLEN_Msk = 0x3000000
	// 8-bit preamble
	RADIO_PCNF0_PLEN_8bit = 0x0
	// 16-bit preamble
	RADIO_PCNF0_PLEN_16bit = 0x1
	// 32-bit zero preamble - used for IEEE 802.15.4
	RADIO_PCNF0_PLEN_32bitZero = 0x2
	// Preamble - used for BLE long range
	RADIO_PCNF0_PLEN_LongRange = 0x3
	// Position of CRCINC field.
	RADIO_PCNF0_CRCINC_Pos = 0x1a
	// Bit mask of CRCINC field.
	RADIO_PCNF0_CRCINC_Msk = 0x4000000
	// Bit CRCINC.
	RADIO_PCNF0_CRCINC = 0x4000000
	// LENGTH does not contain CRC
	RADIO_PCNF0_CRCINC_Exclude = 0x0
	// LENGTH includes CRC
	RADIO_PCNF0_CRCINC_Include = 0x1
	// Position of TERMLEN field.
	RADIO_PCNF0_TERMLEN_Pos = 0x1d
	// Bit mask of TERMLEN field.
	RADIO_PCNF0_TERMLEN_Msk = 0x60000000

	// PCNF1: Packet configuration register 1
	// Position of MAXLEN field.
	RADIO_PCNF1_MAXLEN_Pos = 0x0
	// Bit mask of MAXLEN field.
	RADIO_PCNF1_MAXLEN_Msk = 0xff
	// Position of STATLEN field.
	RADIO_PCNF1_STATLEN_Pos = 0x8
	// Bit mask of STATLEN field.
	RADIO_PCNF1_STATLEN_Msk = 0xff00
	// Position of BALEN field.
	RADIO_PCNF1_BALEN_Pos = 0x10
	// Bit mask of BALEN field.
	RADIO_PCNF1_BALEN_Msk = 0x70000
	// Position of ENDIAN field.
	RADIO_PCNF1_ENDIAN_Pos = 0x18
	// Bit mask of ENDIAN field.
	RADIO_PCNF1_ENDIAN_Msk = 0x1000000
	// Bit ENDIAN.
	RADIO_PCNF1_ENDIAN = 0x1000000
	// Least significant bit on air first
	RADIO_PCNF1_ENDIAN_Little = 0x0
	// Most significant bit on air first
	RADIO_PCNF1_ENDIAN_Big = 0x1
	// Position of WHITEEN field.
	RADIO_PCNF1_WHITEEN_Pos = 0x19
	// Bit mask of WHITEEN field.
	RADIO_PCNF1_WHITEEN_Msk = 0x2000000
	// Bit WHITEEN.
	RADIO_PCNF1_WHITEEN = 0x2000000
	// Disable
	RADIO_PCNF1_WHITEEN_Disabled = 0x0
	// Enable
	RADIO_PCNF1_WHITEEN_Enabled = 0x1

	// BASE0: Base address 0
	// Position of BASE0 field.
	RADIO_BASE0_BASE0_Pos = 0x0
	// Bit mask of BASE0 field.
	RADIO_BASE0_BASE0_Msk = 0xffffffff

	// BASE1: Base address 1
	// Position of BASE1 field.
	RADIO_BASE1_BASE1_Pos = 0x0
	// Bit mask of BASE1 field.
	RADIO_BASE1_BASE1_Msk = 0xffffffff

	// PREFIX0: Prefixes bytes for logical addresses 0-3
	// Position of AP0 field.
	RADIO_PREFIX0_AP0_Pos = 0x0
	// Bit mask of AP0 field.
	RADIO_PREFIX0_AP0_Msk = 0xff
	// Position of AP1 field.
	RADIO_PREFIX0_AP1_Pos = 0x8
	// Bit mask of AP1 field.
	RADIO_PREFIX0_AP1_Msk = 0xff00
	// Position of AP2 field.
	RADIO_PREFIX0_AP2_Pos = 0x10
	// Bit mask of AP2 field.
	RADIO_PREFIX0_AP2_Msk = 0xff0000
	// Position of AP3 field.
	RADIO_PREFIX0_AP3_Pos = 0x18
	// Bit mask of AP3 field.
	RADIO_PREFIX0_AP3_Msk = 0xff000000

	// PREFIX1: Prefixes bytes for logical addresses 4-7
	// Position of AP4 field.
	RADIO_PREFIX1_AP4_Pos = 0x0
	// Bit mask of AP4 field.
	RADIO_PREFIX1_AP4_Msk = 0xff
	// Position of AP5 field.
	RADIO_PREFIX1_AP5_Pos = 0x8
	// Bit mask of AP5 field.
	RADIO_PREFIX1_AP5_Msk = 0xff00
	// Position of AP6 field.
	RADIO_PREFIX1_AP6_Pos = 0x10
	// Bit mask of AP6 field.
	RADIO_PREFIX1_AP6_Msk = 0xff0000
	// Position of AP7 field.
	RADIO_PREFIX1_AP7_Pos = 0x18
	// Bit mask of AP7 field.
	RADIO_PREFIX1_AP7_Msk = 0xff000000

	// TXADDRESS: Transmit address select
	// Position of TXADDRESS field.
	RADIO_TXADDRESS_TXADDRESS_Pos = 0x0
	// Bit mask of TXADDRESS field.
	RADIO_TXADDRESS_TXADDRESS_Msk = 0x7

	// RXADDRESSES: Receive address select
	// Position of ADDR0 field.
	RADIO_RXADDRESSES_ADDR0_Pos = 0x0
	// Bit mask of ADDR0 field.
	RADIO_RXADDRESSES_ADDR0_Msk = 0x1
	// Bit ADDR0.
	RADIO_RXADDRESSES_ADDR0 = 0x1
	// Disable
	RADIO_RXADDRESSES_ADDR0_Disabled = 0x0
	// Enable
	RADIO_RXADDRESSES_ADDR0_Enabled = 0x1
	// Position of ADDR1 field.
	RADIO_RXADDRESSES_ADDR1_Pos = 0x1
	// Bit mask of ADDR1 field.
	RADIO_RXADDRESSES_ADDR1_Msk = 0x2
	// Bit ADDR1.
	RADIO_RXADDRESSES_ADDR1 = 0x2
	// Disable
	RADIO_RXADDRESSES_ADDR1_Disabled = 0x0
	// Enable
	RADIO_RXADDRESSES_ADDR1_Enabled = 0x1
	// Position of ADDR2 field.
	RADIO_RXADDRESSES_ADDR2_Pos = 0x2
	// Bit mask of ADDR2 field.
	RADIO_RXADDRESSES_ADDR2_Msk = 0x4
	// Bit ADDR2.
	RADIO_RXADDRESSES_ADDR2 = 0x4
	// Disable
	RADIO_RXADDRESSES_ADDR2_Disabled = 0x0
	// Enable
	RADIO_RXADDRESSES_ADDR2_Enabled = 0x1
	// Position of ADDR3 field.
	RADIO_RXADDRESSES_ADDR3_Pos = 0x3
	// Bit mask of ADDR3 field.
	RADIO_RXADDRESSES_ADDR3_Msk = 0x8
	// Bit ADDR3.
	RADIO_RXADDRESSES_ADDR3 = 0x8
	// Disable
	RADIO_RXADDRESSES_ADDR3_Disabled = 0x0
	// Enable
	RADIO_RXADDRESSES_ADDR3_Enabled = 0x1
	// Position of ADDR4 field.
	RADIO_RXADDRESSES_ADDR4_Pos = 0x4
	// Bit mask of ADDR4 field.
	RADIO_RXADDRESSES_ADDR4_Msk = 0x10
	// Bit ADDR4.
	RADIO_RXADDRESSES_ADDR4 = 0x10
	// Disable
	RADIO_RXADDRESSES_ADDR4_Disabled = 0x0
	// Enable
	RADIO_RXADDRESSES_ADDR4_Enabled = 0x1
	// Position of ADDR5 field.
	RADIO_RXADDRESSES_ADDR5_Pos = 0x5
	// Bit mask of ADDR5 field.
	RADIO_RXADDRESSES_ADDR5_Msk = 0x20
	// Bit ADDR5.
	RADIO_RXADDRESSES_ADDR5 = 0x20
	// Disable
	RADIO_RXADDRESSES_ADDR5_Disabled = 0x0
	// Enable
	RADIO_RXADDRESSES_ADDR5_Enabled = 0x1
	// Position of ADDR6 field.
	RADIO_RXADDRESSES_ADDR6_Pos = 0x6
	// Bit mask of ADDR6 field.
	RADIO_RXADDRESSES_ADDR6_Msk = 0x40
	// Bit ADDR6.
	RADIO_RXADDRESSES_ADDR6 = 0x40
	// Disable
	RADIO_RXADDRESSES_ADDR6_Disabled = 0x0
	// Enable
	RADIO_RXADDRESSES_ADDR6_Enabled = 0x1
	// Position of ADDR7 field.
	RADIO_RXADDRESSES_ADDR7_Pos = 0x7
	// Bit mask of ADDR7 field.
	RADIO_RXADDRESSES_ADDR7_Msk = 0x80
	// Bit ADDR7.
	RADIO_RXADDRESSES_ADDR7 = 0x80
	// Disable
	RADIO_RXADDRESSES_ADDR7_Disabled = 0x0
	// Enable
	RADIO_RXADDRESSES_ADDR7_Enabled = 0x1

	// CRCCNF: CRC configuration
	// Position of LEN field.
	RADIO_CRCCNF_LEN_Pos = 0x0
	// Bit mask of LEN field.
	RADIO_CRCCNF_LEN_Msk = 0x3
	// CRC length is zero and CRC calculation is disabled
	RADIO_CRCCNF_LEN_Disabled = 0x0
	// CRC length is one byte and CRC calculation is enabled
	RADIO_CRCCNF_LEN_One = 0x1
	// CRC length is two bytes and CRC calculation is enabled
	RADIO_CRCCNF_LEN_Two = 0x2
	// CRC length is three bytes and CRC calculation is enabled
	RADIO_CRCCNF_LEN_Three = 0x3
	// Position of SKIPADDR field.
	RADIO_CRCCNF_SKIPADDR_Pos = 0x8
	// Bit mask of SKIPADDR field.
	RADIO_CRCCNF_SKIPADDR_Msk = 0x300
	// CRC calculation includes address field
	RADIO_CRCCNF_SKIPADDR_Include = 0x0
	// CRC calculation does not include address field. The CRC calculation will start at the first byte after the address.
	RADIO_CRCCNF_SKIPADDR_Skip = 0x1
	// CRC calculation as per 802.15.4 standard. Starting at first byte after length field.
	RADIO_CRCCNF_SKIPADDR_Ieee802154 = 0x2

	// CRCPOLY: CRC polynomial
	// Position of CRCPOLY field.
	RADIO_CRCPOLY_CRCPOLY_Pos = 0x0
	// Bit mask of CRCPOLY field.
	RADIO_CRCPOLY_CRCPOLY_Msk = 0xffffff

	// CRCINIT: CRC initial value
	// Position of CRCINIT field.
	RADIO_CRCINIT_CRCINIT_Pos = 0x0
	// Bit mask of CRCINIT field.
	RADIO_CRCINIT_CRCINIT_Msk = 0xffffff

	// TIFS: Interframe spacing in us
	// Position of TIFS field.
	RADIO_TIFS_TIFS_Pos = 0x0
	// Bit mask of TIFS field.
	RADIO_TIFS_TIFS_Msk = 0x3ff

	// RSSISAMPLE: RSSI sample
	// Position of RSSISAMPLE field.
	RADIO_RSSISAMPLE_RSSISAMPLE_Pos = 0x0
	// Bit mask of RSSISAMPLE field.
	RADIO_RSSISAMPLE_RSSISAMPLE_Msk = 0x7f

	// STATE: Current radio state
	// Position of STATE field.
	RADIO_STATE_STATE_Pos = 0x0
	// Bit mask of STATE field.
	RADIO_STATE_STATE_Msk = 0xf
	// RADIO is in the Disabled state
	RADIO_STATE_STATE_Disabled = 0x0
	// RADIO is in the RXRU state
	RADIO_STATE_STATE_RxRu = 0x1
	// RADIO is in the RXIDLE state
	RADIO_STATE_STATE_RxIdle = 0x2
	// RADIO is in the RX state
	RADIO_STATE_STATE_Rx = 0x3
	// RADIO is in the RXDISABLED state
	RADIO_STATE_STATE_RxDisable = 0x4
	// RADIO is in the TXRU state
	RADIO_STATE_STATE_TxRu = 0x9
	// RADIO is in the TXIDLE state
	RADIO_STATE_STATE_TxIdle = 0xa
	// RADIO is in the TX state
	RADIO_STATE_STATE_Tx = 0xb
	// RADIO is in the TXDISABLED state
	RADIO_STATE_STATE_TxDisable = 0xc

	// DATAWHITEIV: Data whitening initial value
	// Position of DATAWHITEIV field.
	RADIO_DATAWHITEIV_DATAWHITEIV_Pos = 0x0
	// Bit mask of DATAWHITEIV field.
	RADIO_DATAWHITEIV_DATAWHITEIV_Msk = 0x7f

	// BCC: Bit counter compare
	// Position of BCC field.
	RADIO_BCC_BCC_Pos = 0x0
	// Bit mask of BCC field.
	RADIO_BCC_BCC_Msk = 0xffffffff

	// DAB: Description collection: Device address base segment n
	// Position of DAB field.
	RADIO_DAB_DAB_Pos = 0x0
	// Bit mask of DAB field.
	RADIO_DAB_DAB_Msk = 0xffffffff

	// DAP: Description collection: Device address prefix n
	// Position of DAP field.
	RADIO_DAP_DAP_Pos = 0x0
	// Bit mask of DAP field.
	RADIO_DAP_DAP_Msk = 0xffff

	// DACNF: Device address match configuration
	// Position of ENA0 field.
	RADIO_DACNF_ENA0_Pos = 0x0
	// Bit mask of ENA0 field.
	RADIO_DACNF_ENA0_Msk = 0x1
	// Bit ENA0.
	RADIO_DACNF_ENA0 = 0x1
	// Disabled
	RADIO_DACNF_ENA0_Disabled = 0x0
	// Enabled
	RADIO_DACNF_ENA0_Enabled = 0x1
	// Position of ENA1 field.
	RADIO_DACNF_ENA1_Pos = 0x1
	// Bit mask of ENA1 field.
	RADIO_DACNF_ENA1_Msk = 0x2
	// Bit ENA1.
	RADIO_DACNF_ENA1 = 0x2
	// Disabled
	RADIO_DACNF_ENA1_Disabled = 0x0
	// Enabled
	RADIO_DACNF_ENA1_Enabled = 0x1
	// Position of ENA2 field.
	RADIO_DACNF_ENA2_Pos = 0x2
	// Bit mask of ENA2 field.
	RADIO_DACNF_ENA2_Msk = 0x4
	// Bit ENA2.
	RADIO_DACNF_ENA2 = 0x4
	// Disabled
	RADIO_DACNF_ENA2_Disabled = 0x0
	// Enabled
	RADIO_DACNF_ENA2_Enabled = 0x1
	// Position of ENA3 field.
	RADIO_DACNF_ENA3_Pos = 0x3
	// Bit mask of ENA3 field.
	RADIO_DACNF_ENA3_Msk = 0x8
	// Bit ENA3.
	RADIO_DACNF_ENA3 = 0x8
	// Disabled
	RADIO_DACNF_ENA3_Disabled = 0x0
	// Enabled
	RADIO_DACNF_ENA3_Enabled = 0x1
	// Position of ENA4 field.
	RADIO_DACNF_ENA4_Pos = 0x4
	// Bit mask of ENA4 field.
	RADIO_DACNF_ENA4_Msk = 0x10
	// Bit ENA4.
	RADIO_DACNF_ENA4 = 0x10
	// Disabled
	RADIO_DACNF_ENA4_Disabled = 0x0
	// Enabled
	RADIO_DACNF_ENA4_Enabled = 0x1
	// Position of ENA5 field.
	RADIO_DACNF_ENA5_Pos = 0x5
	// Bit mask of ENA5 field.
	RADIO_DACNF_ENA5_Msk = 0x20
	// Bit ENA5.
	RADIO_DACNF_ENA5 = 0x20
	// Disabled
	RADIO_DACNF_ENA5_Disabled = 0x0
	// Enabled
	RADIO_DACNF_ENA5_Enabled = 0x1
	// Position of ENA6 field.
	RADIO_DACNF_ENA6_Pos = 0x6
	// Bit mask of ENA6 field.
	RADIO_DACNF_ENA6_Msk = 0x40
	// Bit ENA6.
	RADIO_DACNF_ENA6 = 0x40
	// Disabled
	RADIO_DACNF_ENA6_Disabled = 0x0
	// Enabled
	RADIO_DACNF_ENA6_Enabled = 0x1
	// Position of ENA7 field.
	RADIO_DACNF_ENA7_Pos = 0x7
	// Bit mask of ENA7 field.
	RADIO_DACNF_ENA7_Msk = 0x80
	// Bit ENA7.
	RADIO_DACNF_ENA7 = 0x80
	// Disabled
	RADIO_DACNF_ENA7_Disabled = 0x0
	// Enabled
	RADIO_DACNF_ENA7_Enabled = 0x1
	// Position of TXADD0 field.
	RADIO_DACNF_TXADD0_Pos = 0x8
	// Bit mask of TXADD0 field.
	RADIO_DACNF_TXADD0_Msk = 0x100
	// Bit TXADD0.
	RADIO_DACNF_TXADD0 = 0x100
	// Position of TXADD1 field.
	RADIO_DACNF_TXADD1_Pos = 0x9
	// Bit mask of TXADD1 field.
	RADIO_DACNF_TXADD1_Msk = 0x200
	// Bit TXADD1.
	RADIO_DACNF_TXADD1 = 0x200
	// Position of TXADD2 field.
	RADIO_DACNF_TXADD2_Pos = 0xa
	// Bit mask of TXADD2 field.
	RADIO_DACNF_TXADD2_Msk = 0x400
	// Bit TXADD2.
	RADIO_DACNF_TXADD2 = 0x400
	// Position of TXADD3 field.
	RADIO_DACNF_TXADD3_Pos = 0xb
	// Bit mask of TXADD3 field.
	RADIO_DACNF_TXADD3_Msk = 0x800
	// Bit TXADD3.
	RADIO_DACNF_TXADD3 = 0x800
	// Position of TXADD4 field.
	RADIO_DACNF_TXADD4_Pos = 0xc
	// Bit mask of TXADD4 field.
	RADIO_DACNF_TXADD4_Msk = 0x1000
	// Bit TXADD4.
	RADIO_DACNF_TXADD4 = 0x1000
	// Position of TXADD5 field.
	RADIO_DACNF_TXADD5_Pos = 0xd
	// Bit mask of TXADD5 field.
	RADIO_DACNF_TXADD5_Msk = 0x2000
	// Bit TXADD5.
	RADIO_DACNF_TXADD5 = 0x2000
	// Position of TXADD6 field.
	RADIO_DACNF_TXADD6_Pos = 0xe
	// Bit mask of TXADD6 field.
	RADIO_DACNF_TXADD6_Msk = 0x4000
	// Bit TXADD6.
	RADIO_DACNF_TXADD6 = 0x4000
	// Position of TXADD7 field.
	RADIO_DACNF_TXADD7_Pos = 0xf
	// Bit mask of TXADD7 field.
	RADIO_DACNF_TXADD7_Msk = 0x8000
	// Bit TXADD7.
	RADIO_DACNF_TXADD7 = 0x8000

	// MHRMATCHCONF: Search pattern configuration
	// Position of MHRMATCHCONF field.
	RADIO_MHRMATCHCONF_MHRMATCHCONF_Pos = 0x0
	// Bit mask of MHRMATCHCONF field.
	RADIO_MHRMATCHCONF_MHRMATCHCONF_Msk = 0xffffffff

	// MHRMATCHMAS: Pattern mask
	// Position of MHRMATCHMAS field.
	RADIO_MHRMATCHMAS_MHRMATCHMAS_Pos = 0x0
	// Bit mask of MHRMATCHMAS field.
	RADIO_MHRMATCHMAS_MHRMATCHMAS_Msk = 0xffffffff

	// MODECNF0: Radio mode configuration register 0
	// Position of RU field.
	RADIO_MODECNF0_RU_Pos = 0x0
	// Bit mask of RU field.
	RADIO_MODECNF0_RU_Msk = 0x1
	// Bit RU.
	RADIO_MODECNF0_RU = 0x1
	// Default ramp-up time (tRXEN and tTXEN), compatible with firmware written for nRF51
	RADIO_MODECNF0_RU_Default = 0x0
	// Fast ramp-up (tRXEN,FAST and tTXEN,FAST), see electrical specification for more information
	RADIO_MODECNF0_RU_Fast = 0x1
	// Position of DTX field.
	RADIO_MODECNF0_DTX_Pos = 0x8
	// Bit mask of DTX field.
	RADIO_MODECNF0_DTX_Msk = 0x300
	// Transmit '1'
	RADIO_MODECNF0_DTX_B1 = 0x0
	// Transmit '0'
	RADIO_MODECNF0_DTX_B0 = 0x1
	// Transmit center frequency
	RADIO_MODECNF0_DTX_Center = 0x2

	// SFD: IEEE 802.15.4 start of frame delimiter
	// Position of SFD field.
	RADIO_SFD_SFD_Pos = 0x0
	// Bit mask of SFD field.
	RADIO_SFD_SFD_Msk = 0xff

	// EDCNT: IEEE 802.15.4 energy detect loop count
	// Position of EDCNT field.
	RADIO_EDCNT_EDCNT_Pos = 0x0
	// Bit mask of EDCNT field.
	RADIO_EDCNT_EDCNT_Msk = 0x1fffff

	// EDSAMPLE: IEEE 802.15.4 energy detect level
	// Position of EDLVL field.
	RADIO_EDSAMPLE_EDLVL_Pos = 0x0
	// Bit mask of EDLVL field.
	RADIO_EDSAMPLE_EDLVL_Msk = 0xff

	// CCACTRL: IEEE 802.15.4 clear channel assessment control
	// Position of CCAMODE field.
	RADIO_CCACTRL_CCAMODE_Pos = 0x0
	// Bit mask of CCAMODE field.
	RADIO_CCACTRL_CCAMODE_Msk = 0x7
	// Energy above threshold
	RADIO_CCACTRL_CCAMODE_EdMode = 0x0
	// Carrier seen
	RADIO_CCACTRL_CCAMODE_CarrierMode = 0x1
	// Energy above threshold AND carrier seen
	RADIO_CCACTRL_CCAMODE_CarrierAndEdMode = 0x2
	// Energy above threshold OR carrier seen
	RADIO_CCACTRL_CCAMODE_CarrierOrEdMode = 0x3
	// Energy above threshold test mode that will abort when first ED measurement over threshold is seen. No averaging.
	RADIO_CCACTRL_CCAMODE_EdModeTest1 = 0x4
	// Position of CCAEDTHRES field.
	RADIO_CCACTRL_CCAEDTHRES_Pos = 0x8
	// Bit mask of CCAEDTHRES field.
	RADIO_CCACTRL_CCAEDTHRES_Msk = 0xff00
	// Position of CCACORRTHRES field.
	RADIO_CCACTRL_CCACORRTHRES_Pos = 0x10
	// Bit mask of CCACORRTHRES field.
	RADIO_CCACTRL_CCACORRTHRES_Msk = 0xff0000
	// Position of CCACORRCNT field.
	RADIO_CCACTRL_CCACORRCNT_Pos = 0x18
	// Bit mask of CCACORRCNT field.
	RADIO_CCACTRL_CCACORRCNT_Msk = 0xff000000

	// POWER: Peripheral power control
	// Position of POWER field.
	RADIO_POWER_POWER_Pos = 0x0
	// Bit mask of POWER field.
	RADIO_POWER_POWER_Msk = 0x1
	// Bit POWER.
	RADIO_POWER_POWER = 0x1
	// Peripheral is powered off
	RADIO_POWER_POWER_Disabled = 0x0
	// Peripheral is powered on
	RADIO_POWER_POWER_Enabled = 0x1
)

// Bitfields for UART0: Universal Asynchronous Receiver/Transmitter
const (
	// TASKS_STARTRX: Start UART receiver
	// Position of TASKS_STARTRX field.
	UART_TASKS_STARTRX_TASKS_STARTRX_Pos = 0x0
	// Bit mask of TASKS_STARTRX field.
	UART_TASKS_STARTRX_TASKS_STARTRX_Msk = 0x1
	// Bit TASKS_STARTRX.
	UART_TASKS_STARTRX_TASKS_STARTRX = 0x1
	// Trigger task
	UART_TASKS_STARTRX_TASKS_STARTRX_Trigger = 0x1

	// TASKS_STOPRX: Stop UART receiver
	// Position of TASKS_STOPRX field.
	UART_TASKS_STOPRX_TASKS_STOPRX_Pos = 0x0
	// Bit mask of TASKS_STOPRX field.
	UART_TASKS_STOPRX_TASKS_STOPRX_Msk = 0x1
	// Bit TASKS_STOPRX.
	UART_TASKS_STOPRX_TASKS_STOPRX = 0x1
	// Trigger task
	UART_TASKS_STOPRX_TASKS_STOPRX_Trigger = 0x1

	// TASKS_STARTTX: Start UART transmitter
	// Position of TASKS_STARTTX field.
	UART_TASKS_STARTTX_TASKS_STARTTX_Pos = 0x0
	// Bit mask of TASKS_STARTTX field.
	UART_TASKS_STARTTX_TASKS_STARTTX_Msk = 0x1
	// Bit TASKS_STARTTX.
	UART_TASKS_STARTTX_TASKS_STARTTX = 0x1
	// Trigger task
	UART_TASKS_STARTTX_TASKS_STARTTX_Trigger = 0x1

	// TASKS_STOPTX: Stop UART transmitter
	// Position of TASKS_STOPTX field.
	UART_TASKS_STOPTX_TASKS_STOPTX_Pos = 0x0
	// Bit mask of TASKS_STOPTX field.
	UART_TASKS_STOPTX_TASKS_STOPTX_Msk = 0x1
	// Bit TASKS_STOPTX.
	UART_TASKS_STOPTX_TASKS_STOPTX = 0x1
	// Trigger task
	UART_TASKS_STOPTX_TASKS_STOPTX_Trigger = 0x1

	// TASKS_SUSPEND: Suspend UART
	// Position of TASKS_SUSPEND field.
	UART_TASKS_SUSPEND_TASKS_SUSPEND_Pos = 0x0
	// Bit mask of TASKS_SUSPEND field.
	UART_TASKS_SUSPEND_TASKS_SUSPEND_Msk = 0x1
	// Bit TASKS_SUSPEND.
	UART_TASKS_SUSPEND_TASKS_SUSPEND = 0x1
	// Trigger task
	UART_TASKS_SUSPEND_TASKS_SUSPEND_Trigger = 0x1

	// EVENTS_CTS: CTS is activated (set low). Clear To Send.
	// Position of EVENTS_CTS field.
	UART_EVENTS_CTS_EVENTS_CTS_Pos = 0x0
	// Bit mask of EVENTS_CTS field.
	UART_EVENTS_CTS_EVENTS_CTS_Msk = 0x1
	// Bit EVENTS_CTS.
	UART_EVENTS_CTS_EVENTS_CTS = 0x1
	// Event not generated
	UART_EVENTS_CTS_EVENTS_CTS_NotGenerated = 0x0
	// Event generated
	UART_EVENTS_CTS_EVENTS_CTS_Generated = 0x1

	// EVENTS_NCTS: CTS is deactivated (set high). Not Clear To Send.
	// Position of EVENTS_NCTS field.
	UART_EVENTS_NCTS_EVENTS_NCTS_Pos = 0x0
	// Bit mask of EVENTS_NCTS field.
	UART_EVENTS_NCTS_EVENTS_NCTS_Msk = 0x1
	// Bit EVENTS_NCTS.
	UART_EVENTS_NCTS_EVENTS_NCTS = 0x1
	// Event not generated
	UART_EVENTS_NCTS_EVENTS_NCTS_NotGenerated = 0x0
	// Event generated
	UART_EVENTS_NCTS_EVENTS_NCTS_Generated = 0x1

	// EVENTS_RXDRDY: Data received in RXD
	// Position of EVENTS_RXDRDY field.
	UART_EVENTS_RXDRDY_EVENTS_RXDRDY_Pos = 0x0
	// Bit mask of EVENTS_RXDRDY field.
	UART_EVENTS_RXDRDY_EVENTS_RXDRDY_Msk = 0x1
	// Bit EVENTS_RXDRDY.
	UART_EVENTS_RXDRDY_EVENTS_RXDRDY = 0x1
	// Event not generated
	UART_EVENTS_RXDRDY_EVENTS_RXDRDY_NotGenerated = 0x0
	// Event generated
	UART_EVENTS_RXDRDY_EVENTS_RXDRDY_Generated = 0x1

	// EVENTS_TXDRDY: Data sent from TXD
	// Position of EVENTS_TXDRDY field.
	UART_EVENTS_TXDRDY_EVENTS_TXDRDY_Pos = 0x0
	// Bit mask of EVENTS_TXDRDY field.
	UART_EVENTS_TXDRDY_EVENTS_TXDRDY_Msk = 0x1
	// Bit EVENTS_TXDRDY.
	UART_EVENTS_TXDRDY_EVENTS_TXDRDY = 0x1
	// Event not generated
	UART_EVENTS_TXDRDY_EVENTS_TXDRDY_NotGenerated = 0x0
	// Event generated
	UART_EVENTS_TXDRDY_EVENTS_TXDRDY_Generated = 0x1

	// EVENTS_ERROR: Error detected
	// Position of EVENTS_ERROR field.
	UART_EVENTS_ERROR_EVENTS_ERROR_Pos = 0x0
	// Bit mask of EVENTS_ERROR field.
	UART_EVENTS_ERROR_EVENTS_ERROR_Msk = 0x1
	// Bit EVENTS_ERROR.
	UART_EVENTS_ERROR_EVENTS_ERROR = 0x1
	// Event not generated
	UART_EVENTS_ERROR_EVENTS_ERROR_NotGenerated = 0x0
	// Event generated
	UART_EVENTS_ERROR_EVENTS_ERROR_Generated = 0x1

	// EVENTS_RXTO: Receiver timeout
	// Position of EVENTS_RXTO field.
	UART_EVENTS_RXTO_EVENTS_RXTO_Pos = 0x0
	// Bit mask of EVENTS_RXTO field.
	UART_EVENTS_RXTO_EVENTS_RXTO_Msk = 0x1
	// Bit EVENTS_RXTO.
	UART_EVENTS_RXTO_EVENTS_RXTO = 0x1
	// Event not generated
	UART_EVENTS_RXTO_EVENTS_RXTO_NotGenerated = 0x0
	// Event generated
	UART_EVENTS_RXTO_EVENTS_RXTO_Generated = 0x1

	// SHORTS: Shortcuts between local events and tasks
	// Position of CTS_STARTRX field.
	UART_SHORTS_CTS_STARTRX_Pos = 0x3
	// Bit mask of CTS_STARTRX field.
	UART_SHORTS_CTS_STARTRX_Msk = 0x8
	// Bit CTS_STARTRX.
	UART_SHORTS_CTS_STARTRX = 0x8
	// Disable shortcut
	UART_SHORTS_CTS_STARTRX_Disabled = 0x0
	// Enable shortcut
	UART_SHORTS_CTS_STARTRX_Enabled = 0x1
	// Position of NCTS_STOPRX field.
	UART_SHORTS_NCTS_STOPRX_Pos = 0x4
	// Bit mask of NCTS_STOPRX field.
	UART_SHORTS_NCTS_STOPRX_Msk = 0x10
	// Bit NCTS_STOPRX.
	UART_SHORTS_NCTS_STOPRX = 0x10
	// Disable shortcut
	UART_SHORTS_NCTS_STOPRX_Disabled = 0x0
	// Enable shortcut
	UART_SHORTS_NCTS_STOPRX_Enabled = 0x1

	// INTENSET: Enable interrupt
	// Position of CTS field.
	UART_INTENSET_CTS_Pos = 0x0
	// Bit mask of CTS field.
	UART_INTENSET_CTS_Msk = 0x1
	// Bit CTS.
	UART_INTENSET_CTS = 0x1
	// Read: Disabled
	UART_INTENSET_CTS_Disabled = 0x0
	// Read: Enabled
	UART_INTENSET_CTS_Enabled = 0x1
	// Enable
	UART_INTENSET_CTS_Set = 0x1
	// Position of NCTS field.
	UART_INTENSET_NCTS_Pos = 0x1
	// Bit mask of NCTS field.
	UART_INTENSET_NCTS_Msk = 0x2
	// Bit NCTS.
	UART_INTENSET_NCTS = 0x2
	// Read: Disabled
	UART_INTENSET_NCTS_Disabled = 0x0
	// Read: Enabled
	UART_INTENSET_NCTS_Enabled = 0x1
	// Enable
	UART_INTENSET_NCTS_Set = 0x1
	// Position of RXDRDY field.
	UART_INTENSET_RXDRDY_Pos = 0x2
	// Bit mask of RXDRDY field.
	UART_INTENSET_RXDRDY_Msk = 0x4
	// Bit RXDRDY.
	UART_INTENSET_RXDRDY = 0x4
	// Read: Disabled
	UART_INTENSET_RXDRDY_Disabled = 0x0
	// Read: Enabled
	UART_INTENSET_RXDRDY_Enabled = 0x1
	// Enable
	UART_INTENSET_RXDRDY_Set = 0x1
	// Position of TXDRDY field.
	UART_INTENSET_TXDRDY_Pos = 0x7
	// Bit mask of TXDRDY field.
	UART_INTENSET_TXDRDY_Msk = 0x80
	// Bit TXDRDY.
	UART_INTENSET_TXDRDY = 0x80
	// Read: Disabled
	UART_INTENSET_TXDRDY_Disabled = 0x0
	// Read: Enabled
	UART_INTENSET_TXDRDY_Enabled = 0x1
	// Enable
	UART_INTENSET_TXDRDY_Set = 0x1
	// Position of ERROR field.
	UART_INTENSET_ERROR_Pos = 0x9
	// Bit mask of ERROR field.
	UART_INTENSET_ERROR_Msk = 0x200
	// Bit ERROR.
	UART_INTENSET_ERROR = 0x200
	// Read: Disabled
	UART_INTENSET_ERROR_Disabled = 0x0
	// Read: Enabled
	UART_INTENSET_ERROR_Enabled = 0x1
	// Enable
	UART_INTENSET_ERROR_Set = 0x1
	// Position of RXTO field.
	UART_INTENSET_RXTO_Pos = 0x11
	// Bit mask of RXTO field.
	UART_INTENSET_RXTO_Msk = 0x20000
	// Bit RXTO.
	UART_INTENSET_RXTO = 0x20000
	// Read: Disabled
	UART_INTENSET_RXTO_Disabled = 0x0
	// Read: Enabled
	UART_INTENSET_RXTO_Enabled = 0x1
	// Enable
	UART_INTENSET_RXTO_Set = 0x1

	// INTENCLR: Disable interrupt
	// Position of CTS field.
	UART_INTENCLR_CTS_Pos = 0x0
	// Bit mask of CTS field.
	UART_INTENCLR_CTS_Msk = 0x1
	// Bit CTS.
	UART_INTENCLR_CTS = 0x1
	// Read: Disabled
	UART_INTENCLR_CTS_Disabled = 0x0
	// Read: Enabled
	UART_INTENCLR_CTS_Enabled = 0x1
	// Disable
	UART_INTENCLR_CTS_Clear = 0x1
	// Position of NCTS field.
	UART_INTENCLR_NCTS_Pos = 0x1
	// Bit mask of NCTS field.
	UART_INTENCLR_NCTS_Msk = 0x2
	// Bit NCTS.
	UART_INTENCLR_NCTS = 0x2
	// Read: Disabled
	UART_INTENCLR_NCTS_Disabled = 0x0
	// Read: Enabled
	UART_INTENCLR_NCTS_Enabled = 0x1
	// Disable
	UART_INTENCLR_NCTS_Clear = 0x1
	// Position of RXDRDY field.
	UART_INTENCLR_RXDRDY_Pos = 0x2
	// Bit mask of RXDRDY field.
	UART_INTENCLR_RXDRDY_Msk = 0x4
	// Bit RXDRDY.
	UART_INTENCLR_RXDRDY = 0x4
	// Read: Disabled
	UART_INTENCLR_RXDRDY_Disabled = 0x0
	// Read: Enabled
	UART_INTENCLR_RXDRDY_Enabled = 0x1
	// Disable
	UART_INTENCLR_RXDRDY_Clear = 0x1
	// Position of TXDRDY field.
	UART_INTENCLR_TXDRDY_Pos = 0x7
	// Bit mask of TXDRDY field.
	UART_INTENCLR_TXDRDY_Msk = 0x80
	// Bit TXDRDY.
	UART_INTENCLR_TXDRDY = 0x80
	// Read: Disabled
	UART_INTENCLR_TXDRDY_Disabled = 0x0
	// Read: Enabled
	UART_INTENCLR_TXDRDY_Enabled = 0x1
	// Disable
	UART_INTENCLR_TXDRDY_Clear = 0x1
	// Position of ERROR field.
	UART_INTENCLR_ERROR_Pos = 0x9
	// Bit mask of ERROR field.
	UART_INTENCLR_ERROR_Msk = 0x200
	// Bit ERROR.
	UART_INTENCLR_ERROR = 0x200
	// Read: Disabled
	UART_INTENCLR_ERROR_Disabled = 0x0
	// Read: Enabled
	UART_INTENCLR_ERROR_Enabled = 0x1
	// Disable
	UART_INTENCLR_ERROR_Clear = 0x1
	// Position of RXTO field.
	UART_INTENCLR_RXTO_Pos = 0x11
	// Bit mask of RXTO field.
	UART_INTENCLR_RXTO_Msk = 0x20000
	// Bit RXTO.
	UART_INTENCLR_RXTO = 0x20000
	// Read: Disabled
	UART_INTENCLR_RXTO_Disabled = 0x0
	// Read: Enabled
	UART_INTENCLR_RXTO_Enabled = 0x1
	// Disable
	UART_INTENCLR_RXTO_Clear = 0x1

	// ERRORSRC: Error source
	// Position of OVERRUN field.
	UART_ERRORSRC_OVERRUN_Pos = 0x0
	// Bit mask of OVERRUN field.
	UART_ERRORSRC_OVERRUN_Msk = 0x1
	// Bit OVERRUN.
	UART_ERRORSRC_OVERRUN = 0x1
	// Read: error not present
	UART_ERRORSRC_OVERRUN_NotPresent = 0x0
	// Read: error present
	UART_ERRORSRC_OVERRUN_Present = 0x1
	// Position of PARITY field.
	UART_ERRORSRC_PARITY_Pos = 0x1
	// Bit mask of PARITY field.
	UART_ERRORSRC_PARITY_Msk = 0x2
	// Bit PARITY.
	UART_ERRORSRC_PARITY = 0x2
	// Read: error not present
	UART_ERRORSRC_PARITY_NotPresent = 0x0
	// Read: error present
	UART_ERRORSRC_PARITY_Present = 0x1
	// Position of FRAMING field.
	UART_ERRORSRC_FRAMING_Pos = 0x2
	// Bit mask of FRAMING field.
	UART_ERRORSRC_FRAMING_Msk = 0x4
	// Bit FRAMING.
	UART_ERRORSRC_FRAMING = 0x4
	// Read: error not present
	UART_ERRORSRC_FRAMING_NotPresent = 0x0
	// Read: error present
	UART_ERRORSRC_FRAMING_Present = 0x1
	// Position of BREAK field.
	UART_ERRORSRC_BREAK_Pos = 0x3
	// Bit mask of BREAK field.
	UART_ERRORSRC_BREAK_Msk = 0x8
	// Bit BREAK.
	UART_ERRORSRC_BREAK = 0x8
	// Read: error not present
	UART_ERRORSRC_BREAK_NotPresent = 0x0
	// Read: error present
	UART_ERRORSRC_BREAK_Present = 0x1

	// ENABLE: Enable UART
	// Position of ENABLE field.
	UART_ENABLE_ENABLE_Pos = 0x0
	// Bit mask of ENABLE field.
	UART_ENABLE_ENABLE_Msk = 0xf
	// Disable UART
	UART_ENABLE_ENABLE_Disabled = 0x0
	// Enable UART
	UART_ENABLE_ENABLE_Enabled = 0x4

	// PSEL.RTS: Pin select for RTS
	// Position of PIN field.
	UART_PSEL_RTS_PIN_Pos = 0x0
	// Bit mask of PIN field.
	UART_PSEL_RTS_PIN_Msk = 0x1f
	// Position of PORT field.
	UART_PSEL_RTS_PORT_Pos = 0x5
	// Bit mask of PORT field.
	UART_PSEL_RTS_PORT_Msk = 0x20
	// Bit PORT.
	UART_PSEL_RTS_PORT = 0x20
	// Position of CONNECT field.
	UART_PSEL_RTS_CONNECT_Pos = 0x1f
	// Bit mask of CONNECT field.
	UART_PSEL_RTS_CONNECT_Msk = 0x80000000
	// Bit CONNECT.
	UART_PSEL_RTS_CONNECT = 0x80000000
	// Disconnect
	UART_PSEL_RTS_CONNECT_Disconnected = 0x1
	// Connect
	UART_PSEL_RTS_CONNECT_Connected = 0x0

	// PSEL.TXD: Pin select for TXD
	// Position of PIN field.
	UART_PSEL_TXD_PIN_Pos = 0x0
	// Bit mask of PIN field.
	UART_PSEL_TXD_PIN_Msk = 0x1f
	// Position of PORT field.
	UART_PSEL_TXD_PORT_Pos = 0x5
	// Bit mask of PORT field.
	UART_PSEL_TXD_PORT_Msk = 0x20
	// Bit PORT.
	UART_PSEL_TXD_PORT = 0x20
	// Position of CONNECT field.
	UART_PSEL_TXD_CONNECT_Pos = 0x1f
	// Bit mask of CONNECT field.
	UART_PSEL_TXD_CONNECT_Msk = 0x80000000
	// Bit CONNECT.
	UART_PSEL_TXD_CONNECT = 0x80000000
	// Disconnect
	UART_PSEL_TXD_CONNECT_Disconnected = 0x1
	// Connect
	UART_PSEL_TXD_CONNECT_Connected = 0x0

	// PSEL.CTS: Pin select for CTS
	// Position of PIN field.
	UART_PSEL_CTS_PIN_Pos = 0x0
	// Bit mask of PIN field.
	UART_PSEL_CTS_PIN_Msk = 0x1f
	// Position of PORT field.
	UART_PSEL_CTS_PORT_Pos = 0x5
	// Bit mask of PORT field.
	UART_PSEL_CTS_PORT_Msk = 0x20
	// Bit PORT.
	UART_PSEL_CTS_PORT = 0x20
	// Position of CONNECT field.
	UART_PSEL_CTS_CONNECT_Pos = 0x1f
	// Bit mask of CONNECT field.
	UART_PSEL_CTS_CONNECT_Msk = 0x80000000
	// Bit CONNECT.
	UART_PSEL_CTS_CONNECT = 0x80000000
	// Disconnect
	UART_PSEL_CTS_CONNECT_Disconnected = 0x1
	// Connect
	UART_PSEL_CTS_CONNECT_Connected = 0x0

	// PSEL.RXD: Pin select for RXD
	// Position of PIN field.
	UART_PSEL_RXD_PIN_Pos = 0x0
	// Bit mask of PIN field.
	UART_PSEL_RXD_PIN_Msk = 0x1f
	// Position of PORT field.
	UART_PSEL_RXD_PORT_Pos = 0x5
	// Bit mask of PORT field.
	UART_PSEL_RXD_PORT_Msk = 0x20
	// Bit PORT.
	UART_PSEL_RXD_PORT = 0x20
	// Position of CONNECT field.
	UART_PSEL_RXD_CONNECT_Pos = 0x1f
	// Bit mask of CONNECT field.
	UART_PSEL_RXD_CONNECT_Msk = 0x80000000
	// Bit CONNECT.
	UART_PSEL_RXD_CONNECT = 0x80000000
	// Disconnect
	UART_PSEL_RXD_CONNECT_Disconnected = 0x1
	// Connect
	UART_PSEL_RXD_CONNECT_Connected = 0x0

	// RXD: RXD register
	// Position of RXD field.
	UART_RXD_RXD_Pos = 0x0
	// Bit mask of RXD field.
	UART_RXD_RXD_Msk = 0xff

	// TXD: TXD register
	// Position of TXD field.
	UART_TXD_TXD_Pos = 0x0
	// Bit mask of TXD field.
	UART_TXD_TXD_Msk = 0xff

	// BAUDRATE: Baud rate. Accuracy depends on the HFCLK source selected.
	// Position of BAUDRATE field.
	UART_BAUDRATE_BAUDRATE_Pos = 0x0
	// Bit mask of BAUDRATE field.
	UART_BAUDRATE_BAUDRATE_Msk = 0xffffffff
	// 1200 baud (actual rate: 1205)
	UART_BAUDRATE_BAUDRATE_Baud1200 = 0x4f000
	// 2400 baud (actual rate: 2396)
	UART_BAUDRATE_BAUDRATE_Baud2400 = 0x9d000
	// 4800 baud (actual rate: 4808)
	UART_BAUDRATE_BAUDRATE_Baud4800 = 0x13b000
	// 9600 baud (actual rate: 9598)
	UART_BAUDRATE_BAUDRATE_Baud9600 = 0x275000
	// 14400 baud (actual rate: 14414)
	UART_BAUDRATE_BAUDRATE_Baud14400 = 0x3b0000
	// 19200 baud (actual rate: 19208)
	UART_BAUDRATE_BAUDRATE_Baud19200 = 0x4ea000
	// 28800 baud (actual rate: 28829)
	UART_BAUDRATE_BAUDRATE_Baud28800 = 0x75f000
	// 31250 baud
	UART_BAUDRATE_BAUDRATE_Baud31250 = 0x800000
	// 38400 baud (actual rate: 38462)
	UART_BAUDRATE_BAUDRATE_Baud38400 = 0x9d5000
	// 56000 baud (actual rate: 55944)
	UART_BAUDRATE_BAUDRATE_Baud56000 = 0xe50000
	// 57600 baud (actual rate: 57762)
	UART_BAUDRATE_BAUDRATE_Baud57600 = 0xebf000
	// 76800 baud (actual rate: 76923)
	UART_BAUDRATE_BAUDRATE_Baud76800 = 0x13a9000
	// 115200 baud (actual rate: 115942)
	UART_BAUDRATE_BAUDRATE_Baud115200 = 0x1d7e000
	// 230400 baud (actual rate: 231884)
	UART_BAUDRATE_BAUDRATE_Baud230400 = 0x3afb000
	// 250000 baud
	UART_BAUDRATE_BAUDRATE_Baud250000 = 0x4000000
	// 460800 baud (actual rate: 470588)
	UART_BAUDRATE_BAUDRATE_Baud460800 = 0x75f7000
	// 921600 baud (actual rate: 941176)
	UART_BAUDRATE_BAUDRATE_Baud921600 = 0xebed000
	// 1Mega baud
	UART_BAUDRATE_BAUDRATE_Baud1M = 0x10000000

	// CONFIG: Configuration of parity and hardware flow control
	// Position of HWFC field.
	UART_CONFIG_HWFC_Pos = 0x0
	// Bit mask of HWFC field.
	UART_CONFIG_HWFC_Msk = 0x1
	// Bit HWFC.
	UART_CONFIG_HWFC = 0x1
	// Disabled
	UART_CONFIG_HWFC_Disabled = 0x0
	// Enabled
	UART_CONFIG_HWFC_Enabled = 0x1
	// Position of PARITY field.
	UART_CONFIG_PARITY_Pos = 0x1
	// Bit mask of PARITY field.
	UART_CONFIG_PARITY_Msk = 0xe
	// Exclude parity bit
	UART_CONFIG_PARITY_Excluded = 0x0
	// Include parity bit
	UART_CONFIG_PARITY_Included = 0x7
	// Position of STOP field.
	UART_CONFIG_STOP_Pos = 0x4
	// Bit mask of STOP field.
	UART_CONFIG_STOP_Msk = 0x10
	// Bit STOP.
	UART_CONFIG_STOP = 0x10
	// One stop bit
	UART_CONFIG_STOP_One = 0x0
	// Two stop bits
	UART_CONFIG_STOP_Two = 0x1
)

// Bitfields for UARTE0: UART with EasyDMA 0
const (
	// TASKS_STARTRX: Start UART receiver
	// Position of TASKS_STARTRX field.
	UARTE_TASKS_STARTRX_TASKS_STARTRX_Pos = 0x0
	// Bit mask of TASKS_STARTRX field.
	UARTE_TASKS_STARTRX_TASKS_STARTRX_Msk = 0x1
	// Bit TASKS_STARTRX.
	UARTE_TASKS_STARTRX_TASKS_STARTRX = 0x1
	// Trigger task
	UARTE_TASKS_STARTRX_TASKS_STARTRX_Trigger = 0x1

	// TASKS_STOPRX: Stop UART receiver
	// Position of TASKS_STOPRX field.
	UARTE_TASKS_STOPRX_TASKS_STOPRX_Pos = 0x0
	// Bit mask of TASKS_STOPRX field.
	UARTE_TASKS_STOPRX_TASKS_STOPRX_Msk = 0x1
	// Bit TASKS_STOPRX.
	UARTE_TASKS_STOPRX_TASKS_STOPRX = 0x1
	// Trigger task
	UARTE_TASKS_STOPRX_TASKS_STOPRX_Trigger = 0x1

	// TASKS_STARTTX: Start UART transmitter
	// Position of TASKS_STARTTX field.
	UARTE_TASKS_STARTTX_TASKS_STARTTX_Pos = 0x0
	// Bit mask of TASKS_STARTTX field.
	UARTE_TASKS_STARTTX_TASKS_STARTTX_Msk = 0x1
	// Bit TASKS_STARTTX.
	UARTE_TASKS_STARTTX_TASKS_STARTTX = 0x1
	// Trigger task
	UARTE_TASKS_STARTTX_TASKS_STARTTX_Trigger = 0x1

	// TASKS_STOPTX: Stop UART transmitter
	// Position of TASKS_STOPTX field.
	UARTE_TASKS_STOPTX_TASKS_STOPTX_Pos = 0x0
	// Bit mask of TASKS_STOPTX field.
	UARTE_TASKS_STOPTX_TASKS_STOPTX_Msk = 0x1
	// Bit TASKS_STOPTX.
	UARTE_TASKS_STOPTX_TASKS_STOPTX = 0x1
	// Trigger task
	UARTE_TASKS_STOPTX_TASKS_STOPTX_Trigger = 0x1

	// TASKS_FLUSHRX: Flush RX FIFO into RX buffer
	// Position of TASKS_FLUSHRX field.
	UARTE_TASKS_FLUSHRX_TASKS_FLUSHRX_Pos = 0x0
	// Bit mask of TASKS_FLUSHRX field.
	UARTE_TASKS_FLUSHRX_TASKS_FLUSHRX_Msk = 0x1
	// Bit TASKS_FLUSHRX.
	UARTE_TASKS_FLUSHRX_TASKS_FLUSHRX = 0x1
	// Trigger task
	UARTE_TASKS_FLUSHRX_TASKS_FLUSHRX_Trigger = 0x1

	// EVENTS_CTS: CTS is activated (set low). Clear To Send.
	// Position of EVENTS_CTS field.
	UARTE_EVENTS_CTS_EVENTS_CTS_Pos = 0x0
	// Bit mask of EVENTS_CTS field.
	UARTE_EVENTS_CTS_EVENTS_CTS_Msk = 0x1
	// Bit EVENTS_CTS.
	UARTE_EVENTS_CTS_EVENTS_CTS = 0x1
	// Event not generated
	UARTE_EVENTS_CTS_EVENTS_CTS_NotGenerated = 0x0
	// Event generated
	UARTE_EVENTS_CTS_EVENTS_CTS_Generated = 0x1

	// EVENTS_NCTS: CTS is deactivated (set high). Not Clear To Send.
	// Position of EVENTS_NCTS field.
	UARTE_EVENTS_NCTS_EVENTS_NCTS_Pos = 0x0
	// Bit mask of EVENTS_NCTS field.
	UARTE_EVENTS_NCTS_EVENTS_NCTS_Msk = 0x1
	// Bit EVENTS_NCTS.
	UARTE_EVENTS_NCTS_EVENTS_NCTS = 0x1
	// Event not generated
	UARTE_EVENTS_NCTS_EVENTS_NCTS_NotGenerated = 0x0
	// Event generated
	UARTE_EVENTS_NCTS_EVENTS_NCTS_Generated = 0x1

	// EVENTS_RXDRDY: Data received in RXD (but potentially not yet transferred to Data RAM)
	// Position of EVENTS_RXDRDY field.
	UARTE_EVENTS_RXDRDY_EVENTS_RXDRDY_Pos = 0x0
	// Bit mask of EVENTS_RXDRDY field.
	UARTE_EVENTS_RXDRDY_EVENTS_RXDRDY_Msk = 0x1
	// Bit EVENTS_RXDRDY.
	UARTE_EVENTS_RXDRDY_EVENTS_RXDRDY = 0x1
	// Event not generated
	UARTE_EVENTS_RXDRDY_EVENTS_RXDRDY_NotGenerated = 0x0
	// Event generated
	UARTE_EVENTS_RXDRDY_EVENTS_RXDRDY_Generated = 0x1

	// EVENTS_ENDRX: Receive buffer is filled up
	// Position of EVENTS_ENDRX field.
	UARTE_EVENTS_ENDRX_EVENTS_ENDRX_Pos = 0x0
	// Bit mask of EVENTS_ENDRX field.
	UARTE_EVENTS_ENDRX_EVENTS_ENDRX_Msk = 0x1
	// Bit EVENTS_ENDRX.
	UARTE_EVENTS_ENDRX_EVENTS_ENDRX = 0x1
	// Event not generated
	UARTE_EVENTS_ENDRX_EVENTS_ENDRX_NotGenerated = 0x0
	// Event generated
	UARTE_EVENTS_ENDRX_EVENTS_ENDRX_Generated = 0x1

	// EVENTS_TXDRDY: Data sent from TXD
	// Position of EVENTS_TXDRDY field.
	UARTE_EVENTS_TXDRDY_EVENTS_TXDRDY_Pos = 0x0
	// Bit mask of EVENTS_TXDRDY field.
	UARTE_EVENTS_TXDRDY_EVENTS_TXDRDY_Msk = 0x1
	// Bit EVENTS_TXDRDY.
	UARTE_EVENTS_TXDRDY_EVENTS_TXDRDY = 0x1
	// Event not generated
	UARTE_EVENTS_TXDRDY_EVENTS_TXDRDY_NotGenerated = 0x0
	// Event generated
	UARTE_EVENTS_TXDRDY_EVENTS_TXDRDY_Generated = 0x1

	// EVENTS_ENDTX: Last TX byte transmitted
	// Position of EVENTS_ENDTX field.
	UARTE_EVENTS_ENDTX_EVENTS_ENDTX_Pos = 0x0
	// Bit mask of EVENTS_ENDTX field.
	UARTE_EVENTS_ENDTX_EVENTS_ENDTX_Msk = 0x1
	// Bit EVENTS_ENDTX.
	UARTE_EVENTS_ENDTX_EVENTS_ENDTX = 0x1
	// Event not generated
	UARTE_EVENTS_ENDTX_EVENTS_ENDTX_NotGenerated = 0x0
	// Event generated
	UARTE_EVENTS_ENDTX_EVENTS_ENDTX_Generated = 0x1

	// EVENTS_ERROR: Error detected
	// Position of EVENTS_ERROR field.
	UARTE_EVENTS_ERROR_EVENTS_ERROR_Pos = 0x0
	// Bit mask of EVENTS_ERROR field.
	UARTE_EVENTS_ERROR_EVENTS_ERROR_Msk = 0x1
	// Bit EVENTS_ERROR.
	UARTE_EVENTS_ERROR_EVENTS_ERROR = 0x1
	// Event not generated
	UARTE_EVENTS_ERROR_EVENTS_ERROR_NotGenerated = 0x0
	// Event generated
	UARTE_EVENTS_ERROR_EVENTS_ERROR_Generated = 0x1

	// EVENTS_RXTO: Receiver timeout
	// Position of EVENTS_RXTO field.
	UARTE_EVENTS_RXTO_EVENTS_RXTO_Pos = 0x0
	// Bit mask of EVENTS_RXTO field.
	UARTE_EVENTS_RXTO_EVENTS_RXTO_Msk = 0x1
	// Bit EVENTS_RXTO.
	UARTE_EVENTS_RXTO_EVENTS_RXTO = 0x1
	// Event not generated
	UARTE_EVENTS_RXTO_EVENTS_RXTO_NotGenerated = 0x0
	// Event generated
	UARTE_EVENTS_RXTO_EVENTS_RXTO_Generated = 0x1

	// EVENTS_RXSTARTED: UART receiver has started
	// Position of EVENTS_RXSTARTED field.
	UARTE_EVENTS_RXSTARTED_EVENTS_RXSTARTED_Pos = 0x0
	// Bit mask of EVENTS_RXSTARTED field.
	UARTE_EVENTS_RXSTARTED_EVENTS_RXSTARTED_Msk = 0x1
	// Bit EVENTS_RXSTARTED.
	UARTE_EVENTS_RXSTARTED_EVENTS_RXSTARTED = 0x1
	// Event not generated
	UARTE_EVENTS_RXSTARTED_EVENTS_RXSTARTED_NotGenerated = 0x0
	// Event generated
	UARTE_EVENTS_RXSTARTED_EVENTS_RXSTARTED_Generated = 0x1

	// EVENTS_TXSTARTED: UART transmitter has started
	// Position of EVENTS_TXSTARTED field.
	UARTE_EVENTS_TXSTARTED_EVENTS_TXSTARTED_Pos = 0x0
	// Bit mask of EVENTS_TXSTARTED field.
	UARTE_EVENTS_TXSTARTED_EVENTS_TXSTARTED_Msk = 0x1
	// Bit EVENTS_TXSTARTED.
	UARTE_EVENTS_TXSTARTED_EVENTS_TXSTARTED = 0x1
	// Event not generated
	UARTE_EVENTS_TXSTARTED_EVENTS_TXSTARTED_NotGenerated = 0x0
	// Event generated
	UARTE_EVENTS_TXSTARTED_EVENTS_TXSTARTED_Generated = 0x1

	// EVENTS_TXSTOPPED: Transmitter stopped
	// Position of EVENTS_TXSTOPPED field.
	UARTE_EVENTS_TXSTOPPED_EVENTS_TXSTOPPED_Pos = 0x0
	// Bit mask of EVENTS_TXSTOPPED field.
	UARTE_EVENTS_TXSTOPPED_EVENTS_TXSTOPPED_Msk = 0x1
	// Bit EVENTS_TXSTOPPED.
	UARTE_EVENTS_TXSTOPPED_EVENTS_TXSTOPPED = 0x1
	// Event not generated
	UARTE_EVENTS_TXSTOPPED_EVENTS_TXSTOPPED_NotGenerated = 0x0
	// Event generated
	UARTE_EVENTS_TXSTOPPED_EVENTS_TXSTOPPED_Generated = 0x1

	// SHORTS: Shortcuts between local events and tasks
	// Position of ENDRX_STARTRX field.
	UARTE_SHORTS_ENDRX_STARTRX_Pos = 0x5
	// Bit mask of ENDRX_STARTRX field.
	UARTE_SHORTS_ENDRX_STARTRX_Msk = 0x20
	// Bit ENDRX_STARTRX.
	UARTE_SHORTS_ENDRX_STARTRX = 0x20
	// Disable shortcut
	UARTE_SHORTS_ENDRX_STARTRX_Disabled = 0x0
	// Enable shortcut
	UARTE_SHORTS_ENDRX_STARTRX_Enabled = 0x1
	// Position of ENDRX_STOPRX field.
	UARTE_SHORTS_ENDRX_STOPRX_Pos = 0x6
	// Bit mask of ENDRX_STOPRX field.
	UARTE_SHORTS_ENDRX_STOPRX_Msk = 0x40
	// Bit ENDRX_STOPRX.
	UARTE_SHORTS_ENDRX_STOPRX = 0x40
	// Disable shortcut
	UARTE_SHORTS_ENDRX_STOPRX_Disabled = 0x0
	// Enable shortcut
	UARTE_SHORTS_ENDRX_STOPRX_Enabled = 0x1

	// INTEN: Enable or disable interrupt
	// Position of CTS field.
	UARTE_INTEN_CTS_Pos = 0x0
	// Bit mask of CTS field.
	UARTE_INTEN_CTS_Msk = 0x1
	// Bit CTS.
	UARTE_INTEN_CTS = 0x1
	// Disable
	UARTE_INTEN_CTS_Disabled = 0x0
	// Enable
	UARTE_INTEN_CTS_Enabled = 0x1
	// Position of NCTS field.
	UARTE_INTEN_NCTS_Pos = 0x1
	// Bit mask of NCTS field.
	UARTE_INTEN_NCTS_Msk = 0x2
	// Bit NCTS.
	UARTE_INTEN_NCTS = 0x2
	// Disable
	UARTE_INTEN_NCTS_Disabled = 0x0
	// Enable
	UARTE_INTEN_NCTS_Enabled = 0x1
	// Position of RXDRDY field.
	UARTE_INTEN_RXDRDY_Pos = 0x2
	// Bit mask of RXDRDY field.
	UARTE_INTEN_RXDRDY_Msk = 0x4
	// Bit RXDRDY.
	UARTE_INTEN_RXDRDY = 0x4
	// Disable
	UARTE_INTEN_RXDRDY_Disabled = 0x0
	// Enable
	UARTE_INTEN_RXDRDY_Enabled = 0x1
	// Position of ENDRX field.
	UARTE_INTEN_ENDRX_Pos = 0x4
	// Bit mask of ENDRX field.
	UARTE_INTEN_ENDRX_Msk = 0x10
	// Bit ENDRX.
	UARTE_INTEN_ENDRX = 0x10
	// Disable
	UARTE_INTEN_ENDRX_Disabled = 0x0
	// Enable
	UARTE_INTEN_ENDRX_Enabled = 0x1
	// Position of TXDRDY field.
	UARTE_INTEN_TXDRDY_Pos = 0x7
	// Bit mask of TXDRDY field.
	UARTE_INTEN_TXDRDY_Msk = 0x80
	// Bit TXDRDY.
	UARTE_INTEN_TXDRDY = 0x80
	// Disable
	UARTE_INTEN_TXDRDY_Disabled = 0x0
	// Enable
	UARTE_INTEN_TXDRDY_Enabled = 0x1
	// Position of ENDTX field.
	UARTE_INTEN_ENDTX_Pos = 0x8
	// Bit mask of ENDTX field.
	UARTE_INTEN_ENDTX_Msk = 0x100
	// Bit ENDTX.
	UARTE_INTEN_ENDTX = 0x100
	// Disable
	UARTE_INTEN_ENDTX_Disabled = 0x0
	// Enable
	UARTE_INTEN_ENDTX_Enabled = 0x1
	// Position of ERROR field.
	UARTE_INTEN_ERROR_Pos = 0x9
	// Bit mask of ERROR field.
	UARTE_INTEN_ERROR_Msk = 0x200
	// Bit ERROR.
	UARTE_INTEN_ERROR = 0x200
	// Disable
	UARTE_INTEN_ERROR_Disabled = 0x0
	// Enable
	UARTE_INTEN_ERROR_Enabled = 0x1
	// Position of RXTO field.
	UARTE_INTEN_RXTO_Pos = 0x11
	// Bit mask of RXTO field.
	UARTE_INTEN_RXTO_Msk = 0x20000
	// Bit RXTO.
	UARTE_INTEN_RXTO = 0x20000
	// Disable
	UARTE_INTEN_RXTO_Disabled = 0x0
	// Enable
	UARTE_INTEN_RXTO_Enabled = 0x1
	// Position of RXSTARTED field.
	UARTE_INTEN_RXSTARTED_Pos = 0x13
	// Bit mask of RXSTARTED field.
	UARTE_INTEN_RXSTARTED_Msk = 0x80000
	// Bit RXSTARTED.
	UARTE_INTEN_RXSTARTED = 0x80000
	// Disable
	UARTE_INTEN_RXSTARTED_Disabled = 0x0
	// Enable
	UARTE_INTEN_RXSTARTED_Enabled = 0x1
	// Position of TXSTARTED field.
	UARTE_INTEN_TXSTARTED_Pos = 0x14
	// Bit mask of TXSTARTED field.
	UARTE_INTEN_TXSTARTED_Msk = 0x100000
	// Bit TXSTARTED.
	UARTE_INTEN_TXSTARTED = 0x100000
	// Disable
	UARTE_INTEN_TXSTARTED_Disabled = 0x0
	// Enable
	UARTE_INTEN_TXSTARTED_Enabled = 0x1
	// Position of TXSTOPPED field.
	UARTE_INTEN_TXSTOPPED_Pos = 0x16
	// Bit mask of TXSTOPPED field.
	UARTE_INTEN_TXSTOPPED_Msk = 0x400000
	// Bit TXSTOPPED.
	UARTE_INTEN_TXSTOPPED = 0x400000
	// Disable
	UARTE_INTEN_TXSTOPPED_Disabled = 0x0
	// Enable
	UARTE_INTEN_TXSTOPPED_Enabled = 0x1

	// INTENSET: Enable interrupt
	// Position of CTS field.
	UARTE_INTENSET_CTS_Pos = 0x0
	// Bit mask of CTS field.
	UARTE_INTENSET_CTS_Msk = 0x1
	// Bit CTS.
	UARTE_INTENSET_CTS = 0x1
	// Read: Disabled
	UARTE_INTENSET_CTS_Disabled = 0x0
	// Read: Enabled
	UARTE_INTENSET_CTS_Enabled = 0x1
	// Enable
	UARTE_INTENSET_CTS_Set = 0x1
	// Position of NCTS field.
	UARTE_INTENSET_NCTS_Pos = 0x1
	// Bit mask of NCTS field.
	UARTE_INTENSET_NCTS_Msk = 0x2
	// Bit NCTS.
	UARTE_INTENSET_NCTS = 0x2
	// Read: Disabled
	UARTE_INTENSET_NCTS_Disabled = 0x0
	// Read: Enabled
	UARTE_INTENSET_NCTS_Enabled = 0x1
	// Enable
	UARTE_INTENSET_NCTS_Set = 0x1
	// Position of RXDRDY field.
	UARTE_INTENSET_RXDRDY_Pos = 0x2
	// Bit mask of RXDRDY field.
	UARTE_INTENSET_RXDRDY_Msk = 0x4
	// Bit RXDRDY.
	UARTE_INTENSET_RXDRDY = 0x4
	// Read: Disabled
	UARTE_INTENSET_RXDRDY_Disabled = 0x0
	// Read: Enabled
	UARTE_INTENSET_RXDRDY_Enabled = 0x1
	// Enable
	UARTE_INTENSET_RXDRDY_Set = 0x1
	// Position of ENDRX field.
	UARTE_INTENSET_ENDRX_Pos = 0x4
	// Bit mask of ENDRX field.
	UARTE_INTENSET_ENDRX_Msk = 0x10
	// Bit ENDRX.
	UARTE_INTENSET_ENDRX = 0x10
	// Read: Disabled
	UARTE_INTENSET_ENDRX_Disabled = 0x0
	// Read: Enabled
	UARTE_INTENSET_ENDRX_Enabled = 0x1
	// Enable
	UARTE_INTENSET_ENDRX_Set = 0x1
	// Position of TXDRDY field.
	UARTE_INTENSET_TXDRDY_Pos = 0x7
	// Bit mask of TXDRDY field.
	UARTE_INTENSET_TXDRDY_Msk = 0x80
	// Bit TXDRDY.
	UARTE_INTENSET_TXDRDY = 0x80
	// Read: Disabled
	UARTE_INTENSET_TXDRDY_Disabled = 0x0
	// Read: Enabled
	UARTE_INTENSET_TXDRDY_Enabled = 0x1
	// Enable
	UARTE_INTENSET_TXDRDY_Set = 0x1
	// Position of ENDTX field.
	UARTE_INTENSET_ENDTX_Pos = 0x8
	// Bit mask of ENDTX field.
	UARTE_INTENSET_ENDTX_Msk = 0x100
	// Bit ENDTX.
	UARTE_INTENSET_ENDTX = 0x100
	// Read: Disabled
	UARTE_INTENSET_ENDTX_Disabled = 0x0
	// Read: Enabled
	UARTE_INTENSET_ENDTX_Enabled = 0x1
	// Enable
	UARTE_INTENSET_ENDTX_Set = 0x1
	// Position of ERROR field.
	UARTE_INTENSET_ERROR_Pos = 0x9
	// Bit mask of ERROR field.
	UARTE_INTENSET_ERROR_Msk = 0x200
	// Bit ERROR.
	UARTE_INTENSET_ERROR = 0x200
	// Read: Disabled
	UARTE_INTENSET_ERROR_Disabled = 0x0
	// Read: Enabled
	UARTE_INTENSET_ERROR_Enabled = 0x1
	// Enable
	UARTE_INTENSET_ERROR_Set = 0x1
	// Position of RXTO field.
	UARTE_INTENSET_RXTO_Pos = 0x11
	// Bit mask of RXTO field.
	UARTE_INTENSET_RXTO_Msk = 0x20000
	// Bit RXTO.
	UARTE_INTENSET_RXTO = 0x20000
	// Read: Disabled
	UARTE_INTENSET_RXTO_Disabled = 0x0
	// Read: Enabled
	UARTE_INTENSET_RXTO_Enabled = 0x1
	// Enable
	UARTE_INTENSET_RXTO_Set = 0x1
	// Position of RXSTARTED field.
	UARTE_INTENSET_RXSTARTED_Pos = 0x13
	// Bit mask of RXSTARTED field.
	UARTE_INTENSET_RXSTARTED_Msk = 0x80000
	// Bit RXSTARTED.
	UARTE_INTENSET_RXSTARTED = 0x80000
	// Read: Disabled
	UARTE_INTENSET_RXSTARTED_Disabled = 0x0
	// Read: Enabled
	UARTE_INTENSET_RXSTARTED_Enabled = 0x1
	// Enable
	UARTE_INTENSET_RXSTARTED_Set = 0x1
	// Position of TXSTARTED field.
	UARTE_INTENSET_TXSTARTED_Pos = 0x14
	// Bit mask of TXSTARTED field.
	UARTE_INTENSET_TXSTARTED_Msk = 0x100000
	// Bit TXSTARTED.
	UARTE_INTENSET_TXSTARTED = 0x100000
	// Read: Disabled
	UARTE_INTENSET_TXSTARTED_Disabled = 0x0
	// Read: Enabled
	UARTE_INTENSET_TXSTARTED_Enabled = 0x1
	// Enable
	UARTE_INTENSET_TXSTARTED_Set = 0x1
	// Position of TXSTOPPED field.
	UARTE_INTENSET_TXSTOPPED_Pos = 0x16
	// Bit mask of TXSTOPPED field.
	UARTE_INTENSET_TXSTOPPED_Msk = 0x400000
	// Bit TXSTOPPED.
	UARTE_INTENSET_TXSTOPPED = 0x400000
	// Read: Disabled
	UARTE_INTENSET_TXSTOPPED_Disabled = 0x0
	// Read: Enabled
	UARTE_INTENSET_TXSTOPPED_Enabled = 0x1
	// Enable
	UARTE_INTENSET_TXSTOPPED_Set = 0x1

	// INTENCLR: Disable interrupt
	// Position of CTS field.
	UARTE_INTENCLR_CTS_Pos = 0x0
	// Bit mask of CTS field.
	UARTE_INTENCLR_CTS_Msk = 0x1
	// Bit CTS.
	UARTE_INTENCLR_CTS = 0x1
	// Read: Disabled
	UARTE_INTENCLR_CTS_Disabled = 0x0
	// Read: Enabled
	UARTE_INTENCLR_CTS_Enabled = 0x1
	// Disable
	UARTE_INTENCLR_CTS_Clear = 0x1
	// Position of NCTS field.
	UARTE_INTENCLR_NCTS_Pos = 0x1
	// Bit mask of NCTS field.
	UARTE_INTENCLR_NCTS_Msk = 0x2
	// Bit NCTS.
	UARTE_INTENCLR_NCTS = 0x2
	// Read: Disabled
	UARTE_INTENCLR_NCTS_Disabled = 0x0
	// Read: Enabled
	UARTE_INTENCLR_NCTS_Enabled = 0x1
	// Disable
	UARTE_INTENCLR_NCTS_Clear = 0x1
	// Position of RXDRDY field.
	UARTE_INTENCLR_RXDRDY_Pos = 0x2
	// Bit mask of RXDRDY field.
	UARTE_INTENCLR_RXDRDY_Msk = 0x4
	// Bit RXDRDY.
	UARTE_INTENCLR_RXDRDY = 0x4
	// Read: Disabled
	UARTE_INTENCLR_RXDRDY_Disabled = 0x0
	// Read: Enabled
	UARTE_INTENCLR_RXDRDY_Enabled = 0x1
	// Disable
	UARTE_INTENCLR_RXDRDY_Clear = 0x1
	// Position of ENDRX field.
	UARTE_INTENCLR_ENDRX_Pos = 0x4
	// Bit mask of ENDRX field.
	UARTE_INTENCLR_ENDRX_Msk = 0x10
	// Bit ENDRX.
	UARTE_INTENCLR_ENDRX = 0x10
	// Read: Disabled
	UARTE_INTENCLR_ENDRX_Disabled = 0x0
	// Read: Enabled
	UARTE_INTENCLR_ENDRX_Enabled = 0x1
	// Disable
	UARTE_INTENCLR_ENDRX_Clear = 0x1
	// Position of TXDRDY field.
	UARTE_INTENCLR_TXDRDY_Pos = 0x7
	// Bit mask of TXDRDY field.
	UARTE_INTENCLR_TXDRDY_Msk = 0x80
	// Bit TXDRDY.
	UARTE_INTENCLR_TXDRDY = 0x80
	// Read: Disabled
	UARTE_INTENCLR_TXDRDY_Disabled = 0x0
	// Read: Enabled
	UARTE_INTENCLR_TXDRDY_Enabled = 0x1
	// Disable
	UARTE_INTENCLR_TXDRDY_Clear = 0x1
	// Position of ENDTX field.
	UARTE_INTENCLR_ENDTX_Pos = 0x8
	// Bit mask of ENDTX field.
	UARTE_INTENCLR_ENDTX_Msk = 0x100
	// Bit ENDTX.
	UARTE_INTENCLR_ENDTX = 0x100
	// Read: Disabled
	UARTE_INTENCLR_ENDTX_Disabled = 0x0
	// Read: Enabled
	UARTE_INTENCLR_ENDTX_Enabled = 0x1
	// Disable
	UARTE_INTENCLR_ENDTX_Clear = 0x1
	// Position of ERROR field.
	UARTE_INTENCLR_ERROR_Pos = 0x9
	// Bit mask of ERROR field.
	UARTE_INTENCLR_ERROR_Msk = 0x200
	// Bit ERROR.
	UARTE_INTENCLR_ERROR = 0x200
	// Read: Disabled
	UARTE_INTENCLR_ERROR_Disabled = 0x0
	// Read: Enabled
	UARTE_INTENCLR_ERROR_Enabled = 0x1
	// Disable
	UARTE_INTENCLR_ERROR_Clear = 0x1
	// Position of RXTO field.
	UARTE_INTENCLR_RXTO_Pos = 0x11
	// Bit mask of RXTO field.
	UARTE_INTENCLR_RXTO_Msk = 0x20000
	// Bit RXTO.
	UARTE_INTENCLR_RXTO = 0x20000
	// Read: Disabled
	UARTE_INTENCLR_RXTO_Disabled = 0x0
	// Read: Enabled
	UARTE_INTENCLR_RXTO_Enabled = 0x1
	// Disable
	UARTE_INTENCLR_RXTO_Clear = 0x1
	// Position of RXSTARTED field.
	UARTE_INTENCLR_RXSTARTED_Pos = 0x13
	// Bit mask of RXSTARTED field.
	UARTE_INTENCLR_RXSTARTED_Msk = 0x80000
	// Bit RXSTARTED.
	UARTE_INTENCLR_RXSTARTED = 0x80000
	// Read: Disabled
	UARTE_INTENCLR_RXSTARTED_Disabled = 0x0
	// Read: Enabled
	UARTE_INTENCLR_RXSTARTED_Enabled = 0x1
	// Disable
	UARTE_INTENCLR_RXSTARTED_Clear = 0x1
	// Position of TXSTARTED field.
	UARTE_INTENCLR_TXSTARTED_Pos = 0x14
	// Bit mask of TXSTARTED field.
	UARTE_INTENCLR_TXSTARTED_Msk = 0x100000
	// Bit TXSTARTED.
	UARTE_INTENCLR_TXSTARTED = 0x100000
	// Read: Disabled
	UARTE_INTENCLR_TXSTARTED_Disabled = 0x0
	// Read: Enabled
	UARTE_INTENCLR_TXSTARTED_Enabled = 0x1
	// Disable
	UARTE_INTENCLR_TXSTARTED_Clear = 0x1
	// Position of TXSTOPPED field.
	UARTE_INTENCLR_TXSTOPPED_Pos = 0x16
	// Bit mask of TXSTOPPED field.
	UARTE_INTENCLR_TXSTOPPED_Msk = 0x400000
	// Bit TXSTOPPED.
	UARTE_INTENCLR_TXSTOPPED = 0x400000
	// Read: Disabled
	UARTE_INTENCLR_TXSTOPPED_Disabled = 0x0
	// Read: Enabled
	UARTE_INTENCLR_TXSTOPPED_Enabled = 0x1
	// Disable
	UARTE_INTENCLR_TXSTOPPED_Clear = 0x1

	// ERRORSRC: Error source Note : this register is read / write one to clear.
	// Position of OVERRUN field.
	UARTE_ERRORSRC_OVERRUN_Pos = 0x0
	// Bit mask of OVERRUN field.
	UARTE_ERRORSRC_OVERRUN_Msk = 0x1
	// Bit OVERRUN.
	UARTE_ERRORSRC_OVERRUN = 0x1
	// Read: error not present
	UARTE_ERRORSRC_OVERRUN_NotPresent = 0x0
	// Read: error present
	UARTE_ERRORSRC_OVERRUN_Present = 0x1
	// Position of PARITY field.
	UARTE_ERRORSRC_PARITY_Pos = 0x1
	// Bit mask of PARITY field.
	UARTE_ERRORSRC_PARITY_Msk = 0x2
	// Bit PARITY.
	UARTE_ERRORSRC_PARITY = 0x2
	// Read: error not present
	UARTE_ERRORSRC_PARITY_NotPresent = 0x0
	// Read: error present
	UARTE_ERRORSRC_PARITY_Present = 0x1
	// Position of FRAMING field.
	UARTE_ERRORSRC_FRAMING_Pos = 0x2
	// Bit mask of FRAMING field.
	UARTE_ERRORSRC_FRAMING_Msk = 0x4
	// Bit FRAMING.
	UARTE_ERRORSRC_FRAMING = 0x4
	// Read: error not present
	UARTE_ERRORSRC_FRAMING_NotPresent = 0x0
	// Read: error present
	UARTE_ERRORSRC_FRAMING_Present = 0x1
	// Position of BREAK field.
	UARTE_ERRORSRC_BREAK_Pos = 0x3
	// Bit mask of BREAK field.
	UARTE_ERRORSRC_BREAK_Msk = 0x8
	// Bit BREAK.
	UARTE_ERRORSRC_BREAK = 0x8
	// Read: error not present
	UARTE_ERRORSRC_BREAK_NotPresent = 0x0
	// Read: error present
	UARTE_ERRORSRC_BREAK_Present = 0x1

	// ENABLE: Enable UART
	// Position of ENABLE field.
	UARTE_ENABLE_ENABLE_Pos = 0x0
	// Bit mask of ENABLE field.
	UARTE_ENABLE_ENABLE_Msk = 0xf
	// Disable UARTE
	UARTE_ENABLE_ENABLE_Disabled = 0x0
	// Enable UARTE
	UARTE_ENABLE_ENABLE_Enabled = 0x8

	// PSEL.RTS: Pin select for RTS signal
	// Position of PIN field.
	UARTE_PSEL_RTS_PIN_Pos = 0x0
	// Bit mask of PIN field.
	UARTE_PSEL_RTS_PIN_Msk = 0x1f
	// Position of PORT field.
	UARTE_PSEL_RTS_PORT_Pos = 0x5
	// Bit mask of PORT field.
	UARTE_PSEL_RTS_PORT_Msk = 0x20
	// Bit PORT.
	UARTE_PSEL_RTS_PORT = 0x20
	// Position of CONNECT field.
	UARTE_PSEL_RTS_CONNECT_Pos = 0x1f
	// Bit mask of CONNECT field.
	UARTE_PSEL_RTS_CONNECT_Msk = 0x80000000
	// Bit CONNECT.
	UARTE_PSEL_RTS_CONNECT = 0x80000000
	// Disconnect
	UARTE_PSEL_RTS_CONNECT_Disconnected = 0x1
	// Connect
	UARTE_PSEL_RTS_CONNECT_Connected = 0x0

	// PSEL.TXD: Pin select for TXD signal
	// Position of PIN field.
	UARTE_PSEL_TXD_PIN_Pos = 0x0
	// Bit mask of PIN field.
	UARTE_PSEL_TXD_PIN_Msk = 0x1f
	// Position of PORT field.
	UARTE_PSEL_TXD_PORT_Pos = 0x5
	// Bit mask of PORT field.
	UARTE_PSEL_TXD_PORT_Msk = 0x20
	// Bit PORT.
	UARTE_PSEL_TXD_PORT = 0x20
	// Position of CONNECT field.
	UARTE_PSEL_TXD_CONNECT_Pos = 0x1f
	// Bit mask of CONNECT field.
	UARTE_PSEL_TXD_CONNECT_Msk = 0x80000000
	// Bit CONNECT.
	UARTE_PSEL_TXD_CONNECT = 0x80000000
	// Disconnect
	UARTE_PSEL_TXD_CONNECT_Disconnected = 0x1
	// Connect
	UARTE_PSEL_TXD_CONNECT_Connected = 0x0

	// PSEL.CTS: Pin select for CTS signal
	// Position of PIN field.
	UARTE_PSEL_CTS_PIN_Pos = 0x0
	// Bit mask of PIN field.
	UARTE_PSEL_CTS_PIN_Msk = 0x1f
	// Position of PORT field.
	UARTE_PSEL_CTS_PORT_Pos = 0x5
	// Bit mask of PORT field.
	UARTE_PSEL_CTS_PORT_Msk = 0x20
	// Bit PORT.
	UARTE_PSEL_CTS_PORT = 0x20
	// Position of CONNECT field.
	UARTE_PSEL_CTS_CONNECT_Pos = 0x1f
	// Bit mask of CONNECT field.
	UARTE_PSEL_CTS_CONNECT_Msk = 0x80000000
	// Bit CONNECT.
	UARTE_PSEL_CTS_CONNECT = 0x80000000
	// Disconnect
	UARTE_PSEL_CTS_CONNECT_Disconnected = 0x1
	// Connect
	UARTE_PSEL_CTS_CONNECT_Connected = 0x0

	// PSEL.RXD: Pin select for RXD signal
	// Position of PIN field.
	UARTE_PSEL_RXD_PIN_Pos = 0x0
	// Bit mask of PIN field.
	UARTE_PSEL_RXD_PIN_Msk = 0x1f
	// Position of PORT field.
	UARTE_PSEL_RXD_PORT_Pos = 0x5
	// Bit mask of PORT field.
	UARTE_PSEL_RXD_PORT_Msk = 0x20
	// Bit PORT.
	UARTE_PSEL_RXD_PORT = 0x20
	// Position of CONNECT field.
	UARTE_PSEL_RXD_CONNECT_Pos = 0x1f
	// Bit mask of CONNECT field.
	UARTE_PSEL_RXD_CONNECT_Msk = 0x80000000
	// Bit CONNECT.
	UARTE_PSEL_RXD_CONNECT = 0x80000000
	// Disconnect
	UARTE_PSEL_RXD_CONNECT_Disconnected = 0x1
	// Connect
	UARTE_PSEL_RXD_CONNECT_Connected = 0x0

	// BAUDRATE: Baud rate. Accuracy depends on the HFCLK source selected.
	// Position of BAUDRATE field.
	UARTE_BAUDRATE_BAUDRATE_Pos = 0x0
	// Bit mask of BAUDRATE field.
	UARTE_BAUDRATE_BAUDRATE_Msk = 0xffffffff
	// 1200 baud (actual rate: 1205)
	UARTE_BAUDRATE_BAUDRATE_Baud1200 = 0x4f000
	// 2400 baud (actual rate: 2396)
	UARTE_BAUDRATE_BAUDRATE_Baud2400 = 0x9d000
	// 4800 baud (actual rate: 4808)
	UARTE_BAUDRATE_BAUDRATE_Baud4800 = 0x13b000
	// 9600 baud (actual rate: 9598)
	UARTE_BAUDRATE_BAUDRATE_Baud9600 = 0x275000
	// 14400 baud (actual rate: 14401)
	UARTE_BAUDRATE_BAUDRATE_Baud14400 = 0x3af000
	// 19200 baud (actual rate: 19208)
	UARTE_BAUDRATE_BAUDRATE_Baud19200 = 0x4ea000
	// 28800 baud (actual rate: 28777)
	UARTE_BAUDRATE_BAUDRATE_Baud28800 = 0x75c000
	// 31250 baud
	UARTE_BAUDRATE_BAUDRATE_Baud31250 = 0x800000
	// 38400 baud (actual rate: 38369)
	UARTE_BAUDRATE_BAUDRATE_Baud38400 = 0x9d0000
	// 56000 baud (actual rate: 55944)
	UARTE_BAUDRATE_BAUDRATE_Baud56000 = 0xe50000
	// 57600 baud (actual rate: 57554)
	UARTE_BAUDRATE_BAUDRATE_Baud57600 = 0xeb0000
	// 76800 baud (actual rate: 76923)
	UARTE_BAUDRATE_BAUDRATE_Baud76800 = 0x13a9000
	// 115200 baud (actual rate: 115108)
	UARTE_BAUDRATE_BAUDRATE_Baud115200 = 0x1d60000
	// 230400 baud (actual rate: 231884)
	UARTE_BAUDRATE_BAUDRATE_Baud230400 = 0x3b00000
	// 250000 baud
	UARTE_BAUDRATE_BAUDRATE_Baud250000 = 0x4000000
	// 460800 baud (actual rate: 457143)
	UARTE_BAUDRATE_BAUDRATE_Baud460800 = 0x7400000
	// 921600 baud (actual rate: 941176)
	UARTE_BAUDRATE_BAUDRATE_Baud921600 = 0xf000000
	// 1Mega baud
	UARTE_BAUDRATE_BAUDRATE_Baud1M = 0x10000000

	// RXD.PTR: Data pointer
	// Position of PTR field.
	UARTE_RXD_PTR_PTR_Pos = 0x0
	// Bit mask of PTR field.
	UARTE_RXD_PTR_PTR_Msk = 0xffffffff

	// RXD.MAXCNT: Maximum number of bytes in receive buffer
	// Position of MAXCNT field.
	UARTE_RXD_MAXCNT_MAXCNT_Pos = 0x0
	// Bit mask of MAXCNT field.
	UARTE_RXD_MAXCNT_MAXCNT_Msk = 0xffff

	// RXD.AMOUNT: Number of bytes transferred in the last transaction
	// Position of AMOUNT field.
	UARTE_RXD_AMOUNT_AMOUNT_Pos = 0x0
	// Bit mask of AMOUNT field.
	UARTE_RXD_AMOUNT_AMOUNT_Msk = 0xffff

	// TXD.PTR: Data pointer
	// Position of PTR field.
	UARTE_TXD_PTR_PTR_Pos = 0x0
	// Bit mask of PTR field.
	UARTE_TXD_PTR_PTR_Msk = 0xffffffff

	// TXD.MAXCNT: Maximum number of bytes in transmit buffer
	// Position of MAXCNT field.
	UARTE_TXD_MAXCNT_MAXCNT_Pos = 0x0
	// Bit mask of MAXCNT field.
	UARTE_TXD_MAXCNT_MAXCNT_Msk = 0xffff

	// TXD.AMOUNT: Number of bytes transferred in the last transaction
	// Position of AMOUNT field.
	UARTE_TXD_AMOUNT_AMOUNT_Pos = 0x0
	// Bit mask of AMOUNT field.
	UARTE_TXD_AMOUNT_AMOUNT_Msk = 0xffff

	// CONFIG: Configuration of parity and hardware flow control
	// Position of HWFC field.
	UARTE_CONFIG_HWFC_Pos = 0x0
	// Bit mask of HWFC field.
	UARTE_CONFIG_HWFC_Msk = 0x1
	// Bit HWFC.
	UARTE_CONFIG_HWFC = 0x1
	// Disabled
	UARTE_CONFIG_HWFC_Disabled = 0x0
	// Enabled
	UARTE_CONFIG_HWFC_Enabled = 0x1
	// Position of PARITY field.
	UARTE_CONFIG_PARITY_Pos = 0x1
	// Bit mask of PARITY field.
	UARTE_CONFIG_PARITY_Msk = 0xe
	// Exclude parity bit
	UARTE_CONFIG_PARITY_Excluded = 0x0
	// Include even parity bit
	UARTE_CONFIG_PARITY_Included = 0x7
	// Position of STOP field.
	UARTE_CONFIG_STOP_Pos = 0x4
	// Bit mask of STOP field.
	UARTE_CONFIG_STOP_Msk = 0x10
	// Bit STOP.
	UARTE_CONFIG_STOP = 0x10
	// One stop bit
	UARTE_CONFIG_STOP_One = 0x0
	// Two stop bits
	UARTE_CONFIG_STOP_Two = 0x1
)

// Bitfields for SPI0: Serial Peripheral Interface 0
const (
	// EVENTS_READY: TXD byte sent and RXD byte received
	// Position of EVENTS_READY field.
	SPI_EVENTS_READY_EVENTS_READY_Pos = 0x0
	// Bit mask of EVENTS_READY field.
	SPI_EVENTS_READY_EVENTS_READY_Msk = 0x1
	// Bit EVENTS_READY.
	SPI_EVENTS_READY_EVENTS_READY = 0x1
	// Event not generated
	SPI_EVENTS_READY_EVENTS_READY_NotGenerated = 0x0
	// Event generated
	SPI_EVENTS_READY_EVENTS_READY_Generated = 0x1

	// INTENSET: Enable interrupt
	// Position of READY field.
	SPI_INTENSET_READY_Pos = 0x2
	// Bit mask of READY field.
	SPI_INTENSET_READY_Msk = 0x4
	// Bit READY.
	SPI_INTENSET_READY = 0x4
	// Read: Disabled
	SPI_INTENSET_READY_Disabled = 0x0
	// Read: Enabled
	SPI_INTENSET_READY_Enabled = 0x1
	// Enable
	SPI_INTENSET_READY_Set = 0x1

	// INTENCLR: Disable interrupt
	// Position of READY field.
	SPI_INTENCLR_READY_Pos = 0x2
	// Bit mask of READY field.
	SPI_INTENCLR_READY_Msk = 0x4
	// Bit READY.
	SPI_INTENCLR_READY = 0x4
	// Read: Disabled
	SPI_INTENCLR_READY_Disabled = 0x0
	// Read: Enabled
	SPI_INTENCLR_READY_Enabled = 0x1
	// Disable
	SPI_INTENCLR_READY_Clear = 0x1

	// ENABLE: Enable SPI
	// Position of ENABLE field.
	SPI_ENABLE_ENABLE_Pos = 0x0
	// Bit mask of ENABLE field.
	SPI_ENABLE_ENABLE_Msk = 0xf
	// Disable SPI
	SPI_ENABLE_ENABLE_Disabled = 0x0
	// Enable SPI
	SPI_ENABLE_ENABLE_Enabled = 0x1

	// PSEL.SCK: Pin select for SCK
	// Position of PIN field.
	SPI_PSEL_SCK_PIN_Pos = 0x0
	// Bit mask of PIN field.
	SPI_PSEL_SCK_PIN_Msk = 0x1f
	// Position of PORT field.
	SPI_PSEL_SCK_PORT_Pos = 0x5
	// Bit mask of PORT field.
	SPI_PSEL_SCK_PORT_Msk = 0x20
	// Bit PORT.
	SPI_PSEL_SCK_PORT = 0x20
	// Position of CONNECT field.
	SPI_PSEL_SCK_CONNECT_Pos = 0x1f
	// Bit mask of CONNECT field.
	SPI_PSEL_SCK_CONNECT_Msk = 0x80000000
	// Bit CONNECT.
	SPI_PSEL_SCK_CONNECT = 0x80000000
	// Disconnect
	SPI_PSEL_SCK_CONNECT_Disconnected = 0x1
	// Connect
	SPI_PSEL_SCK_CONNECT_Connected = 0x0

	// PSEL.MOSI: Pin select for MOSI signal
	// Position of PIN field.
	SPI_PSEL_MOSI_PIN_Pos = 0x0
	// Bit mask of PIN field.
	SPI_PSEL_MOSI_PIN_Msk = 0x1f
	// Position of PORT field.
	SPI_PSEL_MOSI_PORT_Pos = 0x5
	// Bit mask of PORT field.
	SPI_PSEL_MOSI_PORT_Msk = 0x20
	// Bit PORT.
	SPI_PSEL_MOSI_PORT = 0x20
	// Position of CONNECT field.
	SPI_PSEL_MOSI_CONNECT_Pos = 0x1f
	// Bit mask of CONNECT field.
	SPI_PSEL_MOSI_CONNECT_Msk = 0x80000000
	// Bit CONNECT.
	SPI_PSEL_MOSI_CONNECT = 0x80000000
	// Disconnect
	SPI_PSEL_MOSI_CONNECT_Disconnected = 0x1
	// Connect
	SPI_PSEL_MOSI_CONNECT_Connected = 0x0

	// PSEL.MISO: Pin select for MISO signal
	// Position of PIN field.
	SPI_PSEL_MISO_PIN_Pos = 0x0
	// Bit mask of PIN field.
	SPI_PSEL_MISO_PIN_Msk = 0x1f
	// Position of PORT field.
	SPI_PSEL_MISO_PORT_Pos = 0x5
	// Bit mask of PORT field.
	SPI_PSEL_MISO_PORT_Msk = 0x20
	// Bit PORT.
	SPI_PSEL_MISO_PORT = 0x20
	// Position of CONNECT field.
	SPI_PSEL_MISO_CONNECT_Pos = 0x1f
	// Bit mask of CONNECT field.
	SPI_PSEL_MISO_CONNECT_Msk = 0x80000000
	// Bit CONNECT.
	SPI_PSEL_MISO_CONNECT = 0x80000000
	// Disconnect
	SPI_PSEL_MISO_CONNECT_Disconnected = 0x1
	// Connect
	SPI_PSEL_MISO_CONNECT_Connected = 0x0

	// RXD: RXD register
	// Position of RXD field.
	SPI_RXD_RXD_Pos = 0x0
	// Bit mask of RXD field.
	SPI_RXD_RXD_Msk = 0xff

	// TXD: TXD register
	// Position of TXD field.
	SPI_TXD_TXD_Pos = 0x0
	// Bit mask of TXD field.
	SPI_TXD_TXD_Msk = 0xff

	// FREQUENCY: SPI frequency. Accuracy depends on the HFCLK source selected.
	// Position of FREQUENCY field.
	SPI_FREQUENCY_FREQUENCY_Pos = 0x0
	// Bit mask of FREQUENCY field.
	SPI_FREQUENCY_FREQUENCY_Msk = 0xffffffff
	// 125 kbps
	SPI_FREQUENCY_FREQUENCY_K125 = 0x2000000
	// 250 kbps
	SPI_FREQUENCY_FREQUENCY_K250 = 0x4000000
	// 500 kbps
	SPI_FREQUENCY_FREQUENCY_K500 = 0x8000000
	// 1 Mbps
	SPI_FREQUENCY_FREQUENCY_M1 = 0x10000000
	// 2 Mbps
	SPI_FREQUENCY_FREQUENCY_M2 = 0x20000000
	// 4 Mbps
	SPI_FREQUENCY_FREQUENCY_M4 = 0x40000000
	// 8 Mbps
	SPI_FREQUENCY_FREQUENCY_M8 = 0x80000000

	// CONFIG: Configuration register
	// Position of ORDER field.
	SPI_CONFIG_ORDER_Pos = 0x0
	// Bit mask of ORDER field.
	SPI_CONFIG_ORDER_Msk = 0x1
	// Bit ORDER.
	SPI_CONFIG_ORDER = 0x1
	// Most significant bit shifted out first
	SPI_CONFIG_ORDER_MsbFirst = 0x0
	// Least significant bit shifted out first
	SPI_CONFIG_ORDER_LsbFirst = 0x1
	// Position of CPHA field.
	SPI_CONFIG_CPHA_Pos = 0x1
	// Bit mask of CPHA field.
	SPI_CONFIG_CPHA_Msk = 0x2
	// Bit CPHA.
	SPI_CONFIG_CPHA = 0x2
	// Sample on leading edge of clock, shift serial data on trailing edge
	SPI_CONFIG_CPHA_Leading = 0x0
	// Sample on trailing edge of clock, shift serial data on leading edge
	SPI_CONFIG_CPHA_Trailing = 0x1
	// Position of CPOL field.
	SPI_CONFIG_CPOL_Pos = 0x2
	// Bit mask of CPOL field.
	SPI_CONFIG_CPOL_Msk = 0x4
	// Bit CPOL.
	SPI_CONFIG_CPOL = 0x4
	// Active high
	SPI_CONFIG_CPOL_ActiveHigh = 0x0
	// Active low
	SPI_CONFIG_CPOL_ActiveLow = 0x1
)

// Bitfields for SPIM0: Serial Peripheral Interface Master with EasyDMA 0
const (
	// TASKS_START: Start SPI transaction
	// Position of TASKS_START field.
	SPIM_TASKS_START_TASKS_START_Pos = 0x0
	// Bit mask of TASKS_START field.
	SPIM_TASKS_START_TASKS_START_Msk = 0x1
	// Bit TASKS_START.
	SPIM_TASKS_START_TASKS_START = 0x1
	// Trigger task
	SPIM_TASKS_START_TASKS_START_Trigger = 0x1

	// TASKS_STOP: Stop SPI transaction
	// Position of TASKS_STOP field.
	SPIM_TASKS_STOP_TASKS_STOP_Pos = 0x0
	// Bit mask of TASKS_STOP field.
	SPIM_TASKS_STOP_TASKS_STOP_Msk = 0x1
	// Bit TASKS_STOP.
	SPIM_TASKS_STOP_TASKS_STOP = 0x1
	// Trigger task
	SPIM_TASKS_STOP_TASKS_STOP_Trigger = 0x1

	// TASKS_SUSPEND: Suspend SPI transaction
	// Position of TASKS_SUSPEND field.
	SPIM_TASKS_SUSPEND_TASKS_SUSPEND_Pos = 0x0
	// Bit mask of TASKS_SUSPEND field.
	SPIM_TASKS_SUSPEND_TASKS_SUSPEND_Msk = 0x1
	// Bit TASKS_SUSPEND.
	SPIM_TASKS_SUSPEND_TASKS_SUSPEND = 0x1
	// Trigger task
	SPIM_TASKS_SUSPEND_TASKS_SUSPEND_Trigger = 0x1

	// TASKS_RESUME: Resume SPI transaction
	// Position of TASKS_RESUME field.
	SPIM_TASKS_RESUME_TASKS_RESUME_Pos = 0x0
	// Bit mask of TASKS_RESUME field.
	SPIM_TASKS_RESUME_TASKS_RESUME_Msk = 0x1
	// Bit TASKS_RESUME.
	SPIM_TASKS_RESUME_TASKS_RESUME = 0x1
	// Trigger task
	SPIM_TASKS_RESUME_TASKS_RESUME_Trigger = 0x1

	// EVENTS_STOPPED: SPI transaction has stopped
	// Position of EVENTS_STOPPED field.
	SPIM_EVENTS_STOPPED_EVENTS_STOPPED_Pos = 0x0
	// Bit mask of EVENTS_STOPPED field.
	SPIM_EVENTS_STOPPED_EVENTS_STOPPED_Msk = 0x1
	// Bit EVENTS_STOPPED.
	SPIM_EVENTS_STOPPED_EVENTS_STOPPED = 0x1
	// Event not generated
	SPIM_EVENTS_STOPPED_EVENTS_STOPPED_NotGenerated = 0x0
	// Event generated
	SPIM_EVENTS_STOPPED_EVENTS_STOPPED_Generated = 0x1

	// EVENTS_ENDRX: End of RXD buffer reached
	// Position of EVENTS_ENDRX field.
	SPIM_EVENTS_ENDRX_EVENTS_ENDRX_Pos = 0x0
	// Bit mask of EVENTS_ENDRX field.
	SPIM_EVENTS_ENDRX_EVENTS_ENDRX_Msk = 0x1
	// Bit EVENTS_ENDRX.
	SPIM_EVENTS_ENDRX_EVENTS_ENDRX = 0x1
	// Event not generated
	SPIM_EVENTS_ENDRX_EVENTS_ENDRX_NotGenerated = 0x0
	// Event generated
	SPIM_EVENTS_ENDRX_EVENTS_ENDRX_Generated = 0x1

	// EVENTS_END: End of RXD buffer and TXD buffer reached
	// Position of EVENTS_END field.
	SPIM_EVENTS_END_EVENTS_END_Pos = 0x0
	// Bit mask of EVENTS_END field.
	SPIM_EVENTS_END_EVENTS_END_Msk = 0x1
	// Bit EVENTS_END.
	SPIM_EVENTS_END_EVENTS_END = 0x1
	// Event not generated
	SPIM_EVENTS_END_EVENTS_END_NotGenerated = 0x0
	// Event generated
	SPIM_EVENTS_END_EVENTS_END_Generated = 0x1

	// EVENTS_ENDTX: End of TXD buffer reached
	// Position of EVENTS_ENDTX field.
	SPIM_EVENTS_ENDTX_EVENTS_ENDTX_Pos = 0x0
	// Bit mask of EVENTS_ENDTX field.
	SPIM_EVENTS_ENDTX_EVENTS_ENDTX_Msk = 0x1
	// Bit EVENTS_ENDTX.
	SPIM_EVENTS_ENDTX_EVENTS_ENDTX = 0x1
	// Event not generated
	SPIM_EVENTS_ENDTX_EVENTS_ENDTX_NotGenerated = 0x0
	// Event generated
	SPIM_EVENTS_ENDTX_EVENTS_ENDTX_Generated = 0x1

	// EVENTS_STARTED: Transaction started
	// Position of EVENTS_STARTED field.
	SPIM_EVENTS_STARTED_EVENTS_STARTED_Pos = 0x0
	// Bit mask of EVENTS_STARTED field.
	SPIM_EVENTS_STARTED_EVENTS_STARTED_Msk = 0x1
	// Bit EVENTS_STARTED.
	SPIM_EVENTS_STARTED_EVENTS_STARTED = 0x1
	// Event not generated
	SPIM_EVENTS_STARTED_EVENTS_STARTED_NotGenerated = 0x0
	// Event generated
	SPIM_EVENTS_STARTED_EVENTS_STARTED_Generated = 0x1

	// SHORTS: Shortcuts between local events and tasks
	// Position of END_START field.
	SPIM_SHORTS_END_START_Pos = 0x11
	// Bit mask of END_START field.
	SPIM_SHORTS_END_START_Msk = 0x20000
	// Bit END_START.
	SPIM_SHORTS_END_START = 0x20000
	// Disable shortcut
	SPIM_SHORTS_END_START_Disabled = 0x0
	// Enable shortcut
	SPIM_SHORTS_END_START_Enabled = 0x1

	// INTENSET: Enable interrupt
	// Position of STOPPED field.
	SPIM_INTENSET_STOPPED_Pos = 0x1
	// Bit mask of STOPPED field.
	SPIM_INTENSET_STOPPED_Msk = 0x2
	// Bit STOPPED.
	SPIM_INTENSET_STOPPED = 0x2
	// Read: Disabled
	SPIM_INTENSET_STOPPED_Disabled = 0x0
	// Read: Enabled
	SPIM_INTENSET_STOPPED_Enabled = 0x1
	// Enable
	SPIM_INTENSET_STOPPED_Set = 0x1
	// Position of ENDRX field.
	SPIM_INTENSET_ENDRX_Pos = 0x4
	// Bit mask of ENDRX field.
	SPIM_INTENSET_ENDRX_Msk = 0x10
	// Bit ENDRX.
	SPIM_INTENSET_ENDRX = 0x10
	// Read: Disabled
	SPIM_INTENSET_ENDRX_Disabled = 0x0
	// Read: Enabled
	SPIM_INTENSET_ENDRX_Enabled = 0x1
	// Enable
	SPIM_INTENSET_ENDRX_Set = 0x1
	// Position of END field.
	SPIM_INTENSET_END_Pos = 0x6
	// Bit mask of END field.
	SPIM_INTENSET_END_Msk = 0x40
	// Bit END.
	SPIM_INTENSET_END = 0x40
	// Read: Disabled
	SPIM_INTENSET_END_Disabled = 0x0
	// Read: Enabled
	SPIM_INTENSET_END_Enabled = 0x1
	// Enable
	SPIM_INTENSET_END_Set = 0x1
	// Position of ENDTX field.
	SPIM_INTENSET_ENDTX_Pos = 0x8
	// Bit mask of ENDTX field.
	SPIM_INTENSET_ENDTX_Msk = 0x100
	// Bit ENDTX.
	SPIM_INTENSET_ENDTX = 0x100
	// Read: Disabled
	SPIM_INTENSET_ENDTX_Disabled = 0x0
	// Read: Enabled
	SPIM_INTENSET_ENDTX_Enabled = 0x1
	// Enable
	SPIM_INTENSET_ENDTX_Set = 0x1
	// Position of STARTED field.
	SPIM_INTENSET_STARTED_Pos = 0x13
	// Bit mask of STARTED field.
	SPIM_INTENSET_STARTED_Msk = 0x80000
	// Bit STARTED.
	SPIM_INTENSET_STARTED = 0x80000
	// Read: Disabled
	SPIM_INTENSET_STARTED_Disabled = 0x0
	// Read: Enabled
	SPIM_INTENSET_STARTED_Enabled = 0x1
	// Enable
	SPIM_INTENSET_STARTED_Set = 0x1

	// INTENCLR: Disable interrupt
	// Position of STOPPED field.
	SPIM_INTENCLR_STOPPED_Pos = 0x1
	// Bit mask of STOPPED field.
	SPIM_INTENCLR_STOPPED_Msk = 0x2
	// Bit STOPPED.
	SPIM_INTENCLR_STOPPED = 0x2
	// Read: Disabled
	SPIM_INTENCLR_STOPPED_Disabled = 0x0
	// Read: Enabled
	SPIM_INTENCLR_STOPPED_Enabled = 0x1
	// Disable
	SPIM_INTENCLR_STOPPED_Clear = 0x1
	// Position of ENDRX field.
	SPIM_INTENCLR_ENDRX_Pos = 0x4
	// Bit mask of ENDRX field.
	SPIM_INTENCLR_ENDRX_Msk = 0x10
	// Bit ENDRX.
	SPIM_INTENCLR_ENDRX = 0x10
	// Read: Disabled
	SPIM_INTENCLR_ENDRX_Disabled = 0x0
	// Read: Enabled
	SPIM_INTENCLR_ENDRX_Enabled = 0x1
	// Disable
	SPIM_INTENCLR_ENDRX_Clear = 0x1
	// Position of END field.
	SPIM_INTENCLR_END_Pos = 0x6
	// Bit mask of END field.
	SPIM_INTENCLR_END_Msk = 0x40
	// Bit END.
	SPIM_INTENCLR_END = 0x40
	// Read: Disabled
	SPIM_INTENCLR_END_Disabled = 0x0
	// Read: Enabled
	SPIM_INTENCLR_END_Enabled = 0x1
	// Disable
	SPIM_INTENCLR_END_Clear = 0x1
	// Position of ENDTX field.
	SPIM_INTENCLR_ENDTX_Pos = 0x8
	// Bit mask of ENDTX field.
	SPIM_INTENCLR_ENDTX_Msk = 0x100
	// Bit ENDTX.
	SPIM_INTENCLR_ENDTX = 0x100
	// Read: Disabled
	SPIM_INTENCLR_ENDTX_Disabled = 0x0
	// Read: Enabled
	SPIM_INTENCLR_ENDTX_Enabled = 0x1
	// Disable
	SPIM_INTENCLR_ENDTX_Clear = 0x1
	// Position of STARTED field.
	SPIM_INTENCLR_STARTED_Pos = 0x13
	// Bit mask of STARTED field.
	SPIM_INTENCLR_STARTED_Msk = 0x80000
	// Bit STARTED.
	SPIM_INTENCLR_STARTED = 0x80000
	// Read: Disabled
	SPIM_INTENCLR_STARTED_Disabled = 0x0
	// Read: Enabled
	SPIM_INTENCLR_STARTED_Enabled = 0x1
	// Disable
	SPIM_INTENCLR_STARTED_Clear = 0x1

	// STALLSTAT: Stall status for EasyDMA RAM accesses. The fields in this register is set to STALL by hardware whenever a stall occurres and can be cleared (set to NOSTALL) by the CPU.
	// Position of TX field.
	SPIM_STALLSTAT_TX_Pos = 0x0
	// Bit mask of TX field.
	SPIM_STALLSTAT_TX_Msk = 0x1
	// Bit TX.
	SPIM_STALLSTAT_TX = 0x1
	// No stall
	SPIM_STALLSTAT_TX_NOSTALL = 0x0
	// A stall has occurred
	SPIM_STALLSTAT_TX_STALL = 0x1
	// Position of RX field.
	SPIM_STALLSTAT_RX_Pos = 0x1
	// Bit mask of RX field.
	SPIM_STALLSTAT_RX_Msk = 0x2
	// Bit RX.
	SPIM_STALLSTAT_RX = 0x2
	// No stall
	SPIM_STALLSTAT_RX_NOSTALL = 0x0
	// A stall has occurred
	SPIM_STALLSTAT_RX_STALL = 0x1

	// ENABLE: Enable SPIM
	// Position of ENABLE field.
	SPIM_ENABLE_ENABLE_Pos = 0x0
	// Bit mask of ENABLE field.
	SPIM_ENABLE_ENABLE_Msk = 0xf
	// Disable SPIM
	SPIM_ENABLE_ENABLE_Disabled = 0x0
	// Enable SPIM
	SPIM_ENABLE_ENABLE_Enabled = 0x7

	// PSEL.SCK: Pin select for SCK
	// Position of PIN field.
	SPIM_PSEL_SCK_PIN_Pos = 0x0
	// Bit mask of PIN field.
	SPIM_PSEL_SCK_PIN_Msk = 0x1f
	// Position of PORT field.
	SPIM_PSEL_SCK_PORT_Pos = 0x5
	// Bit mask of PORT field.
	SPIM_PSEL_SCK_PORT_Msk = 0x20
	// Bit PORT.
	SPIM_PSEL_SCK_PORT = 0x20
	// Position of CONNECT field.
	SPIM_PSEL_SCK_CONNECT_Pos = 0x1f
	// Bit mask of CONNECT field.
	SPIM_PSEL_SCK_CONNECT_Msk = 0x80000000
	// Bit CONNECT.
	SPIM_PSEL_SCK_CONNECT = 0x80000000
	// Disconnect
	SPIM_PSEL_SCK_CONNECT_Disconnected = 0x1
	// Connect
	SPIM_PSEL_SCK_CONNECT_Connected = 0x0

	// PSEL.MOSI: Pin select for MOSI signal
	// Position of PIN field.
	SPIM_PSEL_MOSI_PIN_Pos = 0x0
	// Bit mask of PIN field.
	SPIM_PSEL_MOSI_PIN_Msk = 0x1f
	// Position of PORT field.
	SPIM_PSEL_MOSI_PORT_Pos = 0x5
	// Bit mask of PORT field.
	SPIM_PSEL_MOSI_PORT_Msk = 0x20
	// Bit PORT.
	SPIM_PSEL_MOSI_PORT = 0x20
	// Position of CONNECT field.
	SPIM_PSEL_MOSI_CONNECT_Pos = 0x1f
	// Bit mask of CONNECT field.
	SPIM_PSEL_MOSI_CONNECT_Msk = 0x80000000
	// Bit CONNECT.
	SPIM_PSEL_MOSI_CONNECT = 0x80000000
	// Disconnect
	SPIM_PSEL_MOSI_CONNECT_Disconnected = 0x1
	// Connect
	SPIM_PSEL_MOSI_CONNECT_Connected = 0x0

	// PSEL.MISO: Pin select for MISO signal
	// Position of PIN field.
	SPIM_PSEL_MISO_PIN_Pos = 0x0
	// Bit mask of PIN field.
	SPIM_PSEL_MISO_PIN_Msk = 0x1f
	// Position of PORT field.
	SPIM_PSEL_MISO_PORT_Pos = 0x5
	// Bit mask of PORT field.
	SPIM_PSEL_MISO_PORT_Msk = 0x20
	// Bit PORT.
	SPIM_PSEL_MISO_PORT = 0x20
	// Position of CONNECT field.
	SPIM_PSEL_MISO_CONNECT_Pos = 0x1f
	// Bit mask of CONNECT field.
	SPIM_PSEL_MISO_CONNECT_Msk = 0x80000000
	// Bit CONNECT.
	SPIM_PSEL_MISO_CONNECT = 0x80000000
	// Disconnect
	SPIM_PSEL_MISO_CONNECT_Disconnected = 0x1
	// Connect
	SPIM_PSEL_MISO_CONNECT_Connected = 0x0

	// PSEL.CSN: Pin select for CSN
	// Position of PIN field.
	SPIM_PSEL_CSN_PIN_Pos = 0x0
	// Bit mask of PIN field.
	SPIM_PSEL_CSN_PIN_Msk = 0x1f
	// Position of PORT field.
	SPIM_PSEL_CSN_PORT_Pos = 0x5
	// Bit mask of PORT field.
	SPIM_PSEL_CSN_PORT_Msk = 0x20
	// Bit PORT.
	SPIM_PSEL_CSN_PORT = 0x20
	// Position of CONNECT field.
	SPIM_PSEL_CSN_CONNECT_Pos = 0x1f
	// Bit mask of CONNECT field.
	SPIM_PSEL_CSN_CONNECT_Msk = 0x80000000
	// Bit CONNECT.
	SPIM_PSEL_CSN_CONNECT = 0x80000000
	// Disconnect
	SPIM_PSEL_CSN_CONNECT_Disconnected = 0x1
	// Connect
	SPIM_PSEL_CSN_CONNECT_Connected = 0x0

	// FREQUENCY: SPI frequency. Accuracy depends on the HFCLK source selected.
	// Position of FREQUENCY field.
	SPIM_FREQUENCY_FREQUENCY_Pos = 0x0
	// Bit mask of FREQUENCY field.
	SPIM_FREQUENCY_FREQUENCY_Msk = 0xffffffff
	// 125 kbps
	SPIM_FREQUENCY_FREQUENCY_K125 = 0x2000000
	// 250 kbps
	SPIM_FREQUENCY_FREQUENCY_K250 = 0x4000000
	// 500 kbps
	SPIM_FREQUENCY_FREQUENCY_K500 = 0x8000000
	// 1 Mbps
	SPIM_FREQUENCY_FREQUENCY_M1 = 0x10000000
	// 2 Mbps
	SPIM_FREQUENCY_FREQUENCY_M2 = 0x20000000
	// 4 Mbps
	SPIM_FREQUENCY_FREQUENCY_M4 = 0x40000000
	// 8 Mbps
	SPIM_FREQUENCY_FREQUENCY_M8 = 0x80000000
	// 16 Mbps
	SPIM_FREQUENCY_FREQUENCY_M16 = 0xa000000
	// 32 Mbps
	SPIM_FREQUENCY_FREQUENCY_M32 = 0x14000000

	// RXD.PTR: Data pointer
	// Position of PTR field.
	SPIM_RXD_PTR_PTR_Pos = 0x0
	// Bit mask of PTR field.
	SPIM_RXD_PTR_PTR_Msk = 0xffffffff

	// RXD.MAXCNT: Maximum number of bytes in receive buffer
	// Position of MAXCNT field.
	SPIM_RXD_MAXCNT_MAXCNT_Pos = 0x0
	// Bit mask of MAXCNT field.
	SPIM_RXD_MAXCNT_MAXCNT_Msk = 0xffff

	// RXD.AMOUNT: Number of bytes transferred in the last transaction
	// Position of AMOUNT field.
	SPIM_RXD_AMOUNT_AMOUNT_Pos = 0x0
	// Bit mask of AMOUNT field.
	SPIM_RXD_AMOUNT_AMOUNT_Msk = 0xffff

	// RXD.LIST: EasyDMA list type
	// Position of LIST field.
	SPIM_RXD_LIST_LIST_Pos = 0x0
	// Bit mask of LIST field.
	SPIM_RXD_LIST_LIST_Msk = 0x3
	// Disable EasyDMA list
	SPIM_RXD_LIST_LIST_Disabled = 0x0
	// Use array list
	SPIM_RXD_LIST_LIST_ArrayList = 0x1

	// TXD.PTR: Data pointer
	// Position of PTR field.
	SPIM_TXD_PTR_PTR_Pos = 0x0
	// Bit mask of PTR field.
	SPIM_TXD_PTR_PTR_Msk = 0xffffffff

	// TXD.MAXCNT: Number of bytes in transmit buffer
	// Position of MAXCNT field.
	SPIM_TXD_MAXCNT_MAXCNT_Pos = 0x0
	// Bit mask of MAXCNT field.
	SPIM_TXD_MAXCNT_MAXCNT_Msk = 0xffff

	// TXD.AMOUNT: Number of bytes transferred in the last transaction
	// Position of AMOUNT field.
	SPIM_TXD_AMOUNT_AMOUNT_Pos = 0x0
	// Bit mask of AMOUNT field.
	SPIM_TXD_AMOUNT_AMOUNT_Msk = 0xffff

	// TXD.LIST: EasyDMA list type
	// Position of LIST field.
	SPIM_TXD_LIST_LIST_Pos = 0x0
	// Bit mask of LIST field.
	SPIM_TXD_LIST_LIST_Msk = 0x3
	// Disable EasyDMA list
	SPIM_TXD_LIST_LIST_Disabled = 0x0
	// Use array list
	SPIM_TXD_LIST_LIST_ArrayList = 0x1

	// CONFIG: Configuration register
	// Position of ORDER field.
	SPIM_CONFIG_ORDER_Pos = 0x0
	// Bit mask of ORDER field.
	SPIM_CONFIG_ORDER_Msk = 0x1
	// Bit ORDER.
	SPIM_CONFIG_ORDER = 0x1
	// Most significant bit shifted out first
	SPIM_CONFIG_ORDER_MsbFirst = 0x0
	// Least significant bit shifted out first
	SPIM_CONFIG_ORDER_LsbFirst = 0x1
	// Position of CPHA field.
	SPIM_CONFIG_CPHA_Pos = 0x1
	// Bit mask of CPHA field.
	SPIM_CONFIG_CPHA_Msk = 0x2
	// Bit CPHA.
	SPIM_CONFIG_CPHA = 0x2
	// Sample on leading edge of clock, shift serial data on trailing edge
	SPIM_CONFIG_CPHA_Leading = 0x0
	// Sample on trailing edge of clock, shift serial data on leading edge
	SPIM_CONFIG_CPHA_Trailing = 0x1
	// Position of CPOL field.
	SPIM_CONFIG_CPOL_Pos = 0x2
	// Bit mask of CPOL field.
	SPIM_CONFIG_CPOL_Msk = 0x4
	// Bit CPOL.
	SPIM_CONFIG_CPOL = 0x4
	// Active high
	SPIM_CONFIG_CPOL_ActiveHigh = 0x0
	// Active low
	SPIM_CONFIG_CPOL_ActiveLow = 0x1

	// IFTIMING.RXDELAY: Sample delay for input serial data on MISO
	// Position of RXDELAY field.
	SPIM_IFTIMING_RXDELAY_RXDELAY_Pos = 0x0
	// Bit mask of RXDELAY field.
	SPIM_IFTIMING_RXDELAY_RXDELAY_Msk = 0x7

	// IFTIMING.CSNDUR: Minimum duration between edge of CSN and edge of SCK and minimum duration CSN must stay high between transactions
	// Position of CSNDUR field.
	SPIM_IFTIMING_CSNDUR_CSNDUR_Pos = 0x0
	// Bit mask of CSNDUR field.
	SPIM_IFTIMING_CSNDUR_CSNDUR_Msk = 0xff

	// CSNPOL: Polarity of CSN output
	// Position of CSNPOL field.
	SPIM_CSNPOL_CSNPOL_Pos = 0x0
	// Bit mask of CSNPOL field.
	SPIM_CSNPOL_CSNPOL_Msk = 0x1
	// Bit CSNPOL.
	SPIM_CSNPOL_CSNPOL = 0x1
	// Active low (idle state high)
	SPIM_CSNPOL_CSNPOL_LOW = 0x0
	// Active high (idle state low)
	SPIM_CSNPOL_CSNPOL_HIGH = 0x1

	// PSELDCX: Pin select for DCX signal
	// Position of PIN field.
	SPIM_PSELDCX_PIN_Pos = 0x0
	// Bit mask of PIN field.
	SPIM_PSELDCX_PIN_Msk = 0x1f
	// Position of PORT field.
	SPIM_PSELDCX_PORT_Pos = 0x5
	// Bit mask of PORT field.
	SPIM_PSELDCX_PORT_Msk = 0x20
	// Bit PORT.
	SPIM_PSELDCX_PORT = 0x20
	// Position of CONNECT field.
	SPIM_PSELDCX_CONNECT_Pos = 0x1f
	// Bit mask of CONNECT field.
	SPIM_PSELDCX_CONNECT_Msk = 0x80000000
	// Bit CONNECT.
	SPIM_PSELDCX_CONNECT = 0x80000000
	// Disconnect
	SPIM_PSELDCX_CONNECT_Disconnected = 0x1
	// Connect
	SPIM_PSELDCX_CONNECT_Connected = 0x0

	// DCXCNT: DCX configuration
	// Position of DCXCNT field.
	SPIM_DCXCNT_DCXCNT_Pos = 0x0
	// Bit mask of DCXCNT field.
	SPIM_DCXCNT_DCXCNT_Msk = 0xf

	// ORC: Byte transmitted after TXD.MAXCNT bytes have been transmitted in the case when RXD.MAXCNT is greater than TXD.MAXCNT
	// Position of ORC field.
	SPIM_ORC_ORC_Pos = 0x0
	// Bit mask of ORC field.
	SPIM_ORC_ORC_Msk = 0xff
)

// Bitfields for SPIS0: SPI Slave 0
const (
	// TASKS_ACQUIRE: Acquire SPI semaphore
	// Position of TASKS_ACQUIRE field.
	SPIS_TASKS_ACQUIRE_TASKS_ACQUIRE_Pos = 0x0
	// Bit mask of TASKS_ACQUIRE field.
	SPIS_TASKS_ACQUIRE_TASKS_ACQUIRE_Msk = 0x1
	// Bit TASKS_ACQUIRE.
	SPIS_TASKS_ACQUIRE_TASKS_ACQUIRE = 0x1
	// Trigger task
	SPIS_TASKS_ACQUIRE_TASKS_ACQUIRE_Trigger = 0x1

	// TASKS_RELEASE: Release SPI semaphore, enabling the SPI slave to acquire it
	// Position of TASKS_RELEASE field.
	SPIS_TASKS_RELEASE_TASKS_RELEASE_Pos = 0x0
	// Bit mask of TASKS_RELEASE field.
	SPIS_TASKS_RELEASE_TASKS_RELEASE_Msk = 0x1
	// Bit TASKS_RELEASE.
	SPIS_TASKS_RELEASE_TASKS_RELEASE = 0x1
	// Trigger task
	SPIS_TASKS_RELEASE_TASKS_RELEASE_Trigger = 0x1

	// EVENTS_END: Granted transaction completed
	// Position of EVENTS_END field.
	SPIS_EVENTS_END_EVENTS_END_Pos = 0x0
	// Bit mask of EVENTS_END field.
	SPIS_EVENTS_END_EVENTS_END_Msk = 0x1
	// Bit EVENTS_END.
	SPIS_EVENTS_END_EVENTS_END = 0x1
	// Event not generated
	SPIS_EVENTS_END_EVENTS_END_NotGenerated = 0x0
	// Event generated
	SPIS_EVENTS_END_EVENTS_END_Generated = 0x1

	// EVENTS_ENDRX: End of RXD buffer reached
	// Position of EVENTS_ENDRX field.
	SPIS_EVENTS_ENDRX_EVENTS_ENDRX_Pos = 0x0
	// Bit mask of EVENTS_ENDRX field.
	SPIS_EVENTS_ENDRX_EVENTS_ENDRX_Msk = 0x1
	// Bit EVENTS_ENDRX.
	SPIS_EVENTS_ENDRX_EVENTS_ENDRX = 0x1
	// Event not generated
	SPIS_EVENTS_ENDRX_EVENTS_ENDRX_NotGenerated = 0x0
	// Event generated
	SPIS_EVENTS_ENDRX_EVENTS_ENDRX_Generated = 0x1

	// EVENTS_ACQUIRED: Semaphore acquired
	// Position of EVENTS_ACQUIRED field.
	SPIS_EVENTS_ACQUIRED_EVENTS_ACQUIRED_Pos = 0x0
	// Bit mask of EVENTS_ACQUIRED field.
	SPIS_EVENTS_ACQUIRED_EVENTS_ACQUIRED_Msk = 0x1
	// Bit EVENTS_ACQUIRED.
	SPIS_EVENTS_ACQUIRED_EVENTS_ACQUIRED = 0x1
	// Event not generated
	SPIS_EVENTS_ACQUIRED_EVENTS_ACQUIRED_NotGenerated = 0x0
	// Event generated
	SPIS_EVENTS_ACQUIRED_EVENTS_ACQUIRED_Generated = 0x1

	// SHORTS: Shortcuts between local events and tasks
	// Position of END_ACQUIRE field.
	SPIS_SHORTS_END_ACQUIRE_Pos = 0x2
	// Bit mask of END_ACQUIRE field.
	SPIS_SHORTS_END_ACQUIRE_Msk = 0x4
	// Bit END_ACQUIRE.
	SPIS_SHORTS_END_ACQUIRE = 0x4
	// Disable shortcut
	SPIS_SHORTS_END_ACQUIRE_Disabled = 0x0
	// Enable shortcut
	SPIS_SHORTS_END_ACQUIRE_Enabled = 0x1

	// INTENSET: Enable interrupt
	// Position of END field.
	SPIS_INTENSET_END_Pos = 0x1
	// Bit mask of END field.
	SPIS_INTENSET_END_Msk = 0x2
	// Bit END.
	SPIS_INTENSET_END = 0x2
	// Read: Disabled
	SPIS_INTENSET_END_Disabled = 0x0
	// Read: Enabled
	SPIS_INTENSET_END_Enabled = 0x1
	// Enable
	SPIS_INTENSET_END_Set = 0x1
	// Position of ENDRX field.
	SPIS_INTENSET_ENDRX_Pos = 0x4
	// Bit mask of ENDRX field.
	SPIS_INTENSET_ENDRX_Msk = 0x10
	// Bit ENDRX.
	SPIS_INTENSET_ENDRX = 0x10
	// Read: Disabled
	SPIS_INTENSET_ENDRX_Disabled = 0x0
	// Read: Enabled
	SPIS_INTENSET_ENDRX_Enabled = 0x1
	// Enable
	SPIS_INTENSET_ENDRX_Set = 0x1
	// Position of ACQUIRED field.
	SPIS_INTENSET_ACQUIRED_Pos = 0xa
	// Bit mask of ACQUIRED field.
	SPIS_INTENSET_ACQUIRED_Msk = 0x400
	// Bit ACQUIRED.
	SPIS_INTENSET_ACQUIRED = 0x400
	// Read: Disabled
	SPIS_INTENSET_ACQUIRED_Disabled = 0x0
	// Read: Enabled
	SPIS_INTENSET_ACQUIRED_Enabled = 0x1
	// Enable
	SPIS_INTENSET_ACQUIRED_Set = 0x1

	// INTENCLR: Disable interrupt
	// Position of END field.
	SPIS_INTENCLR_END_Pos = 0x1
	// Bit mask of END field.
	SPIS_INTENCLR_END_Msk = 0x2
	// Bit END.
	SPIS_INTENCLR_END = 0x2
	// Read: Disabled
	SPIS_INTENCLR_END_Disabled = 0x0
	// Read: Enabled
	SPIS_INTENCLR_END_Enabled = 0x1
	// Disable
	SPIS_INTENCLR_END_Clear = 0x1
	// Position of ENDRX field.
	SPIS_INTENCLR_ENDRX_Pos = 0x4
	// Bit mask of ENDRX field.
	SPIS_INTENCLR_ENDRX_Msk = 0x10
	// Bit ENDRX.
	SPIS_INTENCLR_ENDRX = 0x10
	// Read: Disabled
	SPIS_INTENCLR_ENDRX_Disabled = 0x0
	// Read: Enabled
	SPIS_INTENCLR_ENDRX_Enabled = 0x1
	// Disable
	SPIS_INTENCLR_ENDRX_Clear = 0x1
	// Position of ACQUIRED field.
	SPIS_INTENCLR_ACQUIRED_Pos = 0xa
	// Bit mask of ACQUIRED field.
	SPIS_INTENCLR_ACQUIRED_Msk = 0x400
	// Bit ACQUIRED.
	SPIS_INTENCLR_ACQUIRED = 0x400
	// Read: Disabled
	SPIS_INTENCLR_ACQUIRED_Disabled = 0x0
	// Read: Enabled
	SPIS_INTENCLR_ACQUIRED_Enabled = 0x1
	// Disable
	SPIS_INTENCLR_ACQUIRED_Clear = 0x1

	// SEMSTAT: Semaphore status register
	// Position of SEMSTAT field.
	SPIS_SEMSTAT_SEMSTAT_Pos = 0x0
	// Bit mask of SEMSTAT field.
	SPIS_SEMSTAT_SEMSTAT_Msk = 0x3
	// Semaphore is free
	SPIS_SEMSTAT_SEMSTAT_Free = 0x0
	// Semaphore is assigned to CPU
	SPIS_SEMSTAT_SEMSTAT_CPU = 0x1
	// Semaphore is assigned to SPI slave
	SPIS_SEMSTAT_SEMSTAT_SPIS = 0x2
	// Semaphore is assigned to SPI but a handover to the CPU is pending
	SPIS_SEMSTAT_SEMSTAT_CPUPending = 0x3

	// STATUS: Status from last transaction
	// Position of OVERREAD field.
	SPIS_STATUS_OVERREAD_Pos = 0x0
	// Bit mask of OVERREAD field.
	SPIS_STATUS_OVERREAD_Msk = 0x1
	// Bit OVERREAD.
	SPIS_STATUS_OVERREAD = 0x1
	// Read: error not present
	SPIS_STATUS_OVERREAD_NotPresent = 0x0
	// Read: error present
	SPIS_STATUS_OVERREAD_Present = 0x1
	// Write: clear error on writing '1'
	SPIS_STATUS_OVERREAD_Clear = 0x1
	// Position of OVERFLOW field.
	SPIS_STATUS_OVERFLOW_Pos = 0x1
	// Bit mask of OVERFLOW field.
	SPIS_STATUS_OVERFLOW_Msk = 0x2
	// Bit OVERFLOW.
	SPIS_STATUS_OVERFLOW = 0x2
	// Read: error not present
	SPIS_STATUS_OVERFLOW_NotPresent = 0x0
	// Read: error present
	SPIS_STATUS_OVERFLOW_Present = 0x1
	// Write: clear error on writing '1'
	SPIS_STATUS_OVERFLOW_Clear = 0x1

	// ENABLE: Enable SPI slave
	// Position of ENABLE field.
	SPIS_ENABLE_ENABLE_Pos = 0x0
	// Bit mask of ENABLE field.
	SPIS_ENABLE_ENABLE_Msk = 0xf
	// Disable SPI slave
	SPIS_ENABLE_ENABLE_Disabled = 0x0
	// Enable SPI slave
	SPIS_ENABLE_ENABLE_Enabled = 0x2

	// PSEL.SCK: Pin select for SCK
	// Position of PIN field.
	SPIS_PSEL_SCK_PIN_Pos = 0x0
	// Bit mask of PIN field.
	SPIS_PSEL_SCK_PIN_Msk = 0x1f
	// Position of PORT field.
	SPIS_PSEL_SCK_PORT_Pos = 0x5
	// Bit mask of PORT field.
	SPIS_PSEL_SCK_PORT_Msk = 0x20
	// Bit PORT.
	SPIS_PSEL_SCK_PORT = 0x20
	// Position of CONNECT field.
	SPIS_PSEL_SCK_CONNECT_Pos = 0x1f
	// Bit mask of CONNECT field.
	SPIS_PSEL_SCK_CONNECT_Msk = 0x80000000
	// Bit CONNECT.
	SPIS_PSEL_SCK_CONNECT = 0x80000000
	// Disconnect
	SPIS_PSEL_SCK_CONNECT_Disconnected = 0x1
	// Connect
	SPIS_PSEL_SCK_CONNECT_Connected = 0x0

	// PSEL.MISO: Pin select for MISO signal
	// Position of PIN field.
	SPIS_PSEL_MISO_PIN_Pos = 0x0
	// Bit mask of PIN field.
	SPIS_PSEL_MISO_PIN_Msk = 0x1f
	// Position of PORT field.
	SPIS_PSEL_MISO_PORT_Pos = 0x5
	// Bit mask of PORT field.
	SPIS_PSEL_MISO_PORT_Msk = 0x20
	// Bit PORT.
	SPIS_PSEL_MISO_PORT = 0x20
	// Position of CONNECT field.
	SPIS_PSEL_MISO_CONNECT_Pos = 0x1f
	// Bit mask of CONNECT field.
	SPIS_PSEL_MISO_CONNECT_Msk = 0x80000000
	// Bit CONNECT.
	SPIS_PSEL_MISO_CONNECT = 0x80000000
	// Disconnect
	SPIS_PSEL_MISO_CONNECT_Disconnected = 0x1
	// Connect
	SPIS_PSEL_MISO_CONNECT_Connected = 0x0

	// PSEL.MOSI: Pin select for MOSI signal
	// Position of PIN field.
	SPIS_PSEL_MOSI_PIN_Pos = 0x0
	// Bit mask of PIN field.
	SPIS_PSEL_MOSI_PIN_Msk = 0x1f
	// Position of PORT field.
	SPIS_PSEL_MOSI_PORT_Pos = 0x5
	// Bit mask of PORT field.
	SPIS_PSEL_MOSI_PORT_Msk = 0x20
	// Bit PORT.
	SPIS_PSEL_MOSI_PORT = 0x20
	// Position of CONNECT field.
	SPIS_PSEL_MOSI_CONNECT_Pos = 0x1f
	// Bit mask of CONNECT field.
	SPIS_PSEL_MOSI_CONNECT_Msk = 0x80000000
	// Bit CONNECT.
	SPIS_PSEL_MOSI_CONNECT = 0x80000000
	// Disconnect
	SPIS_PSEL_MOSI_CONNECT_Disconnected = 0x1
	// Connect
	SPIS_PSEL_MOSI_CONNECT_Connected = 0x0

	// PSEL.CSN: Pin select for CSN signal
	// Position of PIN field.
	SPIS_PSEL_CSN_PIN_Pos = 0x0
	// Bit mask of PIN field.
	SPIS_PSEL_CSN_PIN_Msk = 0x1f
	// Position of PORT field.
	SPIS_PSEL_CSN_PORT_Pos = 0x5
	// Bit mask of PORT field.
	SPIS_PSEL_CSN_PORT_Msk = 0x20
	// Bit PORT.
	SPIS_PSEL_CSN_PORT = 0x20
	// Position of CONNECT field.
	SPIS_PSEL_CSN_CONNECT_Pos = 0x1f
	// Bit mask of CONNECT field.
	SPIS_PSEL_CSN_CONNECT_Msk = 0x80000000
	// Bit CONNECT.
	SPIS_PSEL_CSN_CONNECT = 0x80000000
	// Disconnect
	SPIS_PSEL_CSN_CONNECT_Disconnected = 0x1
	// Connect
	SPIS_PSEL_CSN_CONNECT_Connected = 0x0

	// RXD.PTR: RXD data pointer
	// Position of PTR field.
	SPIS_RXD_PTR_PTR_Pos = 0x0
	// Bit mask of PTR field.
	SPIS_RXD_PTR_PTR_Msk = 0xffffffff

	// RXD.MAXCNT: Maximum number of bytes in receive buffer
	// Position of MAXCNT field.
	SPIS_RXD_MAXCNT_MAXCNT_Pos = 0x0
	// Bit mask of MAXCNT field.
	SPIS_RXD_MAXCNT_MAXCNT_Msk = 0xffff

	// RXD.AMOUNT: Number of bytes received in last granted transaction
	// Position of AMOUNT field.
	SPIS_RXD_AMOUNT_AMOUNT_Pos = 0x0
	// Bit mask of AMOUNT field.
	SPIS_RXD_AMOUNT_AMOUNT_Msk = 0xffff

	// RXD.LIST: EasyDMA list type
	// Position of LIST field.
	SPIS_RXD_LIST_LIST_Pos = 0x0
	// Bit mask of LIST field.
	SPIS_RXD_LIST_LIST_Msk = 0x3
	// Disable EasyDMA list
	SPIS_RXD_LIST_LIST_Disabled = 0x0
	// Use array list
	SPIS_RXD_LIST_LIST_ArrayList = 0x1

	// TXD.PTR: TXD data pointer
	// Position of PTR field.
	SPIS_TXD_PTR_PTR_Pos = 0x0
	// Bit mask of PTR field.
	SPIS_TXD_PTR_PTR_Msk = 0xffffffff

	// TXD.MAXCNT: Maximum number of bytes in transmit buffer
	// Position of MAXCNT field.
	SPIS_TXD_MAXCNT_MAXCNT_Pos = 0x0
	// Bit mask of MAXCNT field.
	SPIS_TXD_MAXCNT_MAXCNT_Msk = 0xffff

	// TXD.AMOUNT: Number of bytes transmitted in last granted transaction
	// Position of AMOUNT field.
	SPIS_TXD_AMOUNT_AMOUNT_Pos = 0x0
	// Bit mask of AMOUNT field.
	SPIS_TXD_AMOUNT_AMOUNT_Msk = 0xffff

	// TXD.LIST: EasyDMA list type
	// Position of LIST field.
	SPIS_TXD_LIST_LIST_Pos = 0x0
	// Bit mask of LIST field.
	SPIS_TXD_LIST_LIST_Msk = 0x3
	// Disable EasyDMA list
	SPIS_TXD_LIST_LIST_Disabled = 0x0
	// Use array list
	SPIS_TXD_LIST_LIST_ArrayList = 0x1

	// CONFIG: Configuration register
	// Position of ORDER field.
	SPIS_CONFIG_ORDER_Pos = 0x0
	// Bit mask of ORDER field.
	SPIS_CONFIG_ORDER_Msk = 0x1
	// Bit ORDER.
	SPIS_CONFIG_ORDER = 0x1
	// Most significant bit shifted out first
	SPIS_CONFIG_ORDER_MsbFirst = 0x0
	// Least significant bit shifted out first
	SPIS_CONFIG_ORDER_LsbFirst = 0x1
	// Position of CPHA field.
	SPIS_CONFIG_CPHA_Pos = 0x1
	// Bit mask of CPHA field.
	SPIS_CONFIG_CPHA_Msk = 0x2
	// Bit CPHA.
	SPIS_CONFIG_CPHA = 0x2
	// Sample on leading edge of clock, shift serial data on trailing edge
	SPIS_CONFIG_CPHA_Leading = 0x0
	// Sample on trailing edge of clock, shift serial data on leading edge
	SPIS_CONFIG_CPHA_Trailing = 0x1
	// Position of CPOL field.
	SPIS_CONFIG_CPOL_Pos = 0x2
	// Bit mask of CPOL field.
	SPIS_CONFIG_CPOL_Msk = 0x4
	// Bit CPOL.
	SPIS_CONFIG_CPOL = 0x4
	// Active high
	SPIS_CONFIG_CPOL_ActiveHigh = 0x0
	// Active low
	SPIS_CONFIG_CPOL_ActiveLow = 0x1

	// DEF: Default character. Character clocked out in case of an ignored transaction.
	// Position of DEF field.
	SPIS_DEF_DEF_Pos = 0x0
	// Bit mask of DEF field.
	SPIS_DEF_DEF_Msk = 0xff

	// ORC: Over-read character
	// Position of ORC field.
	SPIS_ORC_ORC_Pos = 0x0
	// Bit mask of ORC field.
	SPIS_ORC_ORC_Msk = 0xff
)

// Bitfields for TWI0: I2C compatible Two-Wire Interface 0
const (
	// TASKS_STARTRX: Start TWI receive sequence
	// Position of TASKS_STARTRX field.
	TWI_TASKS_STARTRX_TASKS_STARTRX_Pos = 0x0
	// Bit mask of TASKS_STARTRX field.
	TWI_TASKS_STARTRX_TASKS_STARTRX_Msk = 0x1
	// Bit TASKS_STARTRX.
	TWI_TASKS_STARTRX_TASKS_STARTRX = 0x1
	// Trigger task
	TWI_TASKS_STARTRX_TASKS_STARTRX_Trigger = 0x1

	// TASKS_STARTTX: Start TWI transmit sequence
	// Position of TASKS_STARTTX field.
	TWI_TASKS_STARTTX_TASKS_STARTTX_Pos = 0x0
	// Bit mask of TASKS_STARTTX field.
	TWI_TASKS_STARTTX_TASKS_STARTTX_Msk = 0x1
	// Bit TASKS_STARTTX.
	TWI_TASKS_STARTTX_TASKS_STARTTX = 0x1
	// Trigger task
	TWI_TASKS_STARTTX_TASKS_STARTTX_Trigger = 0x1

	// TASKS_STOP: Stop TWI transaction
	// Position of TASKS_STOP field.
	TWI_TASKS_STOP_TASKS_STOP_Pos = 0x0
	// Bit mask of TASKS_STOP field.
	TWI_TASKS_STOP_TASKS_STOP_Msk = 0x1
	// Bit TASKS_STOP.
	TWI_TASKS_STOP_TASKS_STOP = 0x1
	// Trigger task
	TWI_TASKS_STOP_TASKS_STOP_Trigger = 0x1

	// TASKS_SUSPEND: Suspend TWI transaction
	// Position of TASKS_SUSPEND field.
	TWI_TASKS_SUSPEND_TASKS_SUSPEND_Pos = 0x0
	// Bit mask of TASKS_SUSPEND field.
	TWI_TASKS_SUSPEND_TASKS_SUSPEND_Msk = 0x1
	// Bit TASKS_SUSPEND.
	TWI_TASKS_SUSPEND_TASKS_SUSPEND = 0x1
	// Trigger task
	TWI_TASKS_SUSPEND_TASKS_SUSPEND_Trigger = 0x1

	// TASKS_RESUME: Resume TWI transaction
	// Position of TASKS_RESUME field.
	TWI_TASKS_RESUME_TASKS_RESUME_Pos = 0x0
	// Bit mask of TASKS_RESUME field.
	TWI_TASKS_RESUME_TASKS_RESUME_Msk = 0x1
	// Bit TASKS_RESUME.
	TWI_TASKS_RESUME_TASKS_RESUME = 0x1
	// Trigger task
	TWI_TASKS_RESUME_TASKS_RESUME_Trigger = 0x1

	// EVENTS_STOPPED: TWI stopped
	// Position of EVENTS_STOPPED field.
	TWI_EVENTS_STOPPED_EVENTS_STOPPED_Pos = 0x0
	// Bit mask of EVENTS_STOPPED field.
	TWI_EVENTS_STOPPED_EVENTS_STOPPED_Msk = 0x1
	// Bit EVENTS_STOPPED.
	TWI_EVENTS_STOPPED_EVENTS_STOPPED = 0x1
	// Event not generated
	TWI_EVENTS_STOPPED_EVENTS_STOPPED_NotGenerated = 0x0
	// Event generated
	TWI_EVENTS_STOPPED_EVENTS_STOPPED_Generated = 0x1

	// EVENTS_RXDREADY: TWI RXD byte received
	// Position of EVENTS_RXDREADY field.
	TWI_EVENTS_RXDREADY_EVENTS_RXDREADY_Pos = 0x0
	// Bit mask of EVENTS_RXDREADY field.
	TWI_EVENTS_RXDREADY_EVENTS_RXDREADY_Msk = 0x1
	// Bit EVENTS_RXDREADY.
	TWI_EVENTS_RXDREADY_EVENTS_RXDREADY = 0x1
	// Event not generated
	TWI_EVENTS_RXDREADY_EVENTS_RXDREADY_NotGenerated = 0x0
	// Event generated
	TWI_EVENTS_RXDREADY_EVENTS_RXDREADY_Generated = 0x1

	// EVENTS_TXDSENT: TWI TXD byte sent
	// Position of EVENTS_TXDSENT field.
	TWI_EVENTS_TXDSENT_EVENTS_TXDSENT_Pos = 0x0
	// Bit mask of EVENTS_TXDSENT field.
	TWI_EVENTS_TXDSENT_EVENTS_TXDSENT_Msk = 0x1
	// Bit EVENTS_TXDSENT.
	TWI_EVENTS_TXDSENT_EVENTS_TXDSENT = 0x1
	// Event not generated
	TWI_EVENTS_TXDSENT_EVENTS_TXDSENT_NotGenerated = 0x0
	// Event generated
	TWI_EVENTS_TXDSENT_EVENTS_TXDSENT_Generated = 0x1

	// EVENTS_ERROR: TWI error
	// Position of EVENTS_ERROR field.
	TWI_EVENTS_ERROR_EVENTS_ERROR_Pos = 0x0
	// Bit mask of EVENTS_ERROR field.
	TWI_EVENTS_ERROR_EVENTS_ERROR_Msk = 0x1
	// Bit EVENTS_ERROR.
	TWI_EVENTS_ERROR_EVENTS_ERROR = 0x1
	// Event not generated
	TWI_EVENTS_ERROR_EVENTS_ERROR_NotGenerated = 0x0
	// Event generated
	TWI_EVENTS_ERROR_EVENTS_ERROR_Generated = 0x1

	// EVENTS_BB: TWI byte boundary, generated before each byte that is sent or received
	// Position of EVENTS_BB field.
	TWI_EVENTS_BB_EVENTS_BB_Pos = 0x0
	// Bit mask of EVENTS_BB field.
	TWI_EVENTS_BB_EVENTS_BB_Msk = 0x1
	// Bit EVENTS_BB.
	TWI_EVENTS_BB_EVENTS_BB = 0x1
	// Event not generated
	TWI_EVENTS_BB_EVENTS_BB_NotGenerated = 0x0
	// Event generated
	TWI_EVENTS_BB_EVENTS_BB_Generated = 0x1

	// EVENTS_SUSPENDED: TWI entered the suspended state
	// Position of EVENTS_SUSPENDED field.
	TWI_EVENTS_SUSPENDED_EVENTS_SUSPENDED_Pos = 0x0
	// Bit mask of EVENTS_SUSPENDED field.
	TWI_EVENTS_SUSPENDED_EVENTS_SUSPENDED_Msk = 0x1
	// Bit EVENTS_SUSPENDED.
	TWI_EVENTS_SUSPENDED_EVENTS_SUSPENDED = 0x1
	// Event not generated
	TWI_EVENTS_SUSPENDED_EVENTS_SUSPENDED_NotGenerated = 0x0
	// Event generated
	TWI_EVENTS_SUSPENDED_EVENTS_SUSPENDED_Generated = 0x1

	// SHORTS: Shortcuts between local events and tasks
	// Position of BB_SUSPEND field.
	TWI_SHORTS_BB_SUSPEND_Pos = 0x0
	// Bit mask of BB_SUSPEND field.
	TWI_SHORTS_BB_SUSPEND_Msk = 0x1
	// Bit BB_SUSPEND.
	TWI_SHORTS_BB_SUSPEND = 0x1
	// Disable shortcut
	TWI_SHORTS_BB_SUSPEND_Disabled = 0x0
	// Enable shortcut
	TWI_SHORTS_BB_SUSPEND_Enabled = 0x1
	// Position of BB_STOP field.
	TWI_SHORTS_BB_STOP_Pos = 0x1
	// Bit mask of BB_STOP field.
	TWI_SHORTS_BB_STOP_Msk = 0x2
	// Bit BB_STOP.
	TWI_SHORTS_BB_STOP = 0x2
	// Disable shortcut
	TWI_SHORTS_BB_STOP_Disabled = 0x0
	// Enable shortcut
	TWI_SHORTS_BB_STOP_Enabled = 0x1

	// INTENSET: Enable interrupt
	// Position of STOPPED field.
	TWI_INTENSET_STOPPED_Pos = 0x1
	// Bit mask of STOPPED field.
	TWI_INTENSET_STOPPED_Msk = 0x2
	// Bit STOPPED.
	TWI_INTENSET_STOPPED = 0x2
	// Read: Disabled
	TWI_INTENSET_STOPPED_Disabled = 0x0
	// Read: Enabled
	TWI_INTENSET_STOPPED_Enabled = 0x1
	// Enable
	TWI_INTENSET_STOPPED_Set = 0x1
	// Position of RXDREADY field.
	TWI_INTENSET_RXDREADY_Pos = 0x2
	// Bit mask of RXDREADY field.
	TWI_INTENSET_RXDREADY_Msk = 0x4
	// Bit RXDREADY.
	TWI_INTENSET_RXDREADY = 0x4
	// Read: Disabled
	TWI_INTENSET_RXDREADY_Disabled = 0x0
	// Read: Enabled
	TWI_INTENSET_RXDREADY_Enabled = 0x1
	// Enable
	TWI_INTENSET_RXDREADY_Set = 0x1
	// Position of TXDSENT field.
	TWI_INTENSET_TXDSENT_Pos = 0x7
	// Bit mask of TXDSENT field.
	TWI_INTENSET_TXDSENT_Msk = 0x80
	// Bit TXDSENT.
	TWI_INTENSET_TXDSENT = 0x80
	// Read: Disabled
	TWI_INTENSET_TXDSENT_Disabled = 0x0
	// Read: Enabled
	TWI_INTENSET_TXDSENT_Enabled = 0x1
	// Enable
	TWI_INTENSET_TXDSENT_Set = 0x1
	// Position of ERROR field.
	TWI_INTENSET_ERROR_Pos = 0x9
	// Bit mask of ERROR field.
	TWI_INTENSET_ERROR_Msk = 0x200
	// Bit ERROR.
	TWI_INTENSET_ERROR = 0x200
	// Read: Disabled
	TWI_INTENSET_ERROR_Disabled = 0x0
	// Read: Enabled
	TWI_INTENSET_ERROR_Enabled = 0x1
	// Enable
	TWI_INTENSET_ERROR_Set = 0x1
	// Position of BB field.
	TWI_INTENSET_BB_Pos = 0xe
	// Bit mask of BB field.
	TWI_INTENSET_BB_Msk = 0x4000
	// Bit BB.
	TWI_INTENSET_BB = 0x4000
	// Read: Disabled
	TWI_INTENSET_BB_Disabled = 0x0
	// Read: Enabled
	TWI_INTENSET_BB_Enabled = 0x1
	// Enable
	TWI_INTENSET_BB_Set = 0x1
	// Position of SUSPENDED field.
	TWI_INTENSET_SUSPENDED_Pos = 0x12
	// Bit mask of SUSPENDED field.
	TWI_INTENSET_SUSPENDED_Msk = 0x40000
	// Bit SUSPENDED.
	TWI_INTENSET_SUSPENDED = 0x40000
	// Read: Disabled
	TWI_INTENSET_SUSPENDED_Disabled = 0x0
	// Read: Enabled
	TWI_INTENSET_SUSPENDED_Enabled = 0x1
	// Enable
	TWI_INTENSET_SUSPENDED_Set = 0x1

	// INTENCLR: Disable interrupt
	// Position of STOPPED field.
	TWI_INTENCLR_STOPPED_Pos = 0x1
	// Bit mask of STOPPED field.
	TWI_INTENCLR_STOPPED_Msk = 0x2
	// Bit STOPPED.
	TWI_INTENCLR_STOPPED = 0x2
	// Read: Disabled
	TWI_INTENCLR_STOPPED_Disabled = 0x0
	// Read: Enabled
	TWI_INTENCLR_STOPPED_Enabled = 0x1
	// Disable
	TWI_INTENCLR_STOPPED_Clear = 0x1
	// Position of RXDREADY field.
	TWI_INTENCLR_RXDREADY_Pos = 0x2
	// Bit mask of RXDREADY field.
	TWI_INTENCLR_RXDREADY_Msk = 0x4
	// Bit RXDREADY.
	TWI_INTENCLR_RXDREADY = 0x4
	// Read: Disabled
	TWI_INTENCLR_RXDREADY_Disabled = 0x0
	// Read: Enabled
	TWI_INTENCLR_RXDREADY_Enabled = 0x1
	// Disable
	TWI_INTENCLR_RXDREADY_Clear = 0x1
	// Position of TXDSENT field.
	TWI_INTENCLR_TXDSENT_Pos = 0x7
	// Bit mask of TXDSENT field.
	TWI_INTENCLR_TXDSENT_Msk = 0x80
	// Bit TXDSENT.
	TWI_INTENCLR_TXDSENT = 0x80
	// Read: Disabled
	TWI_INTENCLR_TXDSENT_Disabled = 0x0
	// Read: Enabled
	TWI_INTENCLR_TXDSENT_Enabled = 0x1
	// Disable
	TWI_INTENCLR_TXDSENT_Clear = 0x1
	// Position of ERROR field.
	TWI_INTENCLR_ERROR_Pos = 0x9
	// Bit mask of ERROR field.
	TWI_INTENCLR_ERROR_Msk = 0x200
	// Bit ERROR.
	TWI_INTENCLR_ERROR = 0x200
	// Read: Disabled
	TWI_INTENCLR_ERROR_Disabled = 0x0
	// Read: Enabled
	TWI_INTENCLR_ERROR_Enabled = 0x1
	// Disable
	TWI_INTENCLR_ERROR_Clear = 0x1
	// Position of BB field.
	TWI_INTENCLR_BB_Pos = 0xe
	// Bit mask of BB field.
	TWI_INTENCLR_BB_Msk = 0x4000
	// Bit BB.
	TWI_INTENCLR_BB = 0x4000
	// Read: Disabled
	TWI_INTENCLR_BB_Disabled = 0x0
	// Read: Enabled
	TWI_INTENCLR_BB_Enabled = 0x1
	// Disable
	TWI_INTENCLR_BB_Clear = 0x1
	// Position of SUSPENDED field.
	TWI_INTENCLR_SUSPENDED_Pos = 0x12
	// Bit mask of SUSPENDED field.
	TWI_INTENCLR_SUSPENDED_Msk = 0x40000
	// Bit SUSPENDED.
	TWI_INTENCLR_SUSPENDED = 0x40000
	// Read: Disabled
	TWI_INTENCLR_SUSPENDED_Disabled = 0x0
	// Read: Enabled
	TWI_INTENCLR_SUSPENDED_Enabled = 0x1
	// Disable
	TWI_INTENCLR_SUSPENDED_Clear = 0x1

	// ERRORSRC: Error source
	// Position of OVERRUN field.
	TWI_ERRORSRC_OVERRUN_Pos = 0x0
	// Bit mask of OVERRUN field.
	TWI_ERRORSRC_OVERRUN_Msk = 0x1
	// Bit OVERRUN.
	TWI_ERRORSRC_OVERRUN = 0x1
	// Read: no overrun occured
	TWI_ERRORSRC_OVERRUN_NotPresent = 0x0
	// Read: overrun occured
	TWI_ERRORSRC_OVERRUN_Present = 0x1
	// Position of ANACK field.
	TWI_ERRORSRC_ANACK_Pos = 0x1
	// Bit mask of ANACK field.
	TWI_ERRORSRC_ANACK_Msk = 0x2
	// Bit ANACK.
	TWI_ERRORSRC_ANACK = 0x2
	// Read: error not present
	TWI_ERRORSRC_ANACK_NotPresent = 0x0
	// Read: error present
	TWI_ERRORSRC_ANACK_Present = 0x1
	// Position of DNACK field.
	TWI_ERRORSRC_DNACK_Pos = 0x2
	// Bit mask of DNACK field.
	TWI_ERRORSRC_DNACK_Msk = 0x4
	// Bit DNACK.
	TWI_ERRORSRC_DNACK = 0x4
	// Read: error not present
	TWI_ERRORSRC_DNACK_NotPresent = 0x0
	// Read: error present
	TWI_ERRORSRC_DNACK_Present = 0x1

	// ENABLE: Enable TWI
	// Position of ENABLE field.
	TWI_ENABLE_ENABLE_Pos = 0x0
	// Bit mask of ENABLE field.
	TWI_ENABLE_ENABLE_Msk = 0xf
	// Disable TWI
	TWI_ENABLE_ENABLE_Disabled = 0x0
	// Enable TWI
	TWI_ENABLE_ENABLE_Enabled = 0x5

	// PSEL.SCL: Pin select for SCL
	// Position of PIN field.
	TWI_PSEL_SCL_PIN_Pos = 0x0
	// Bit mask of PIN field.
	TWI_PSEL_SCL_PIN_Msk = 0x1f
	// Position of PORT field.
	TWI_PSEL_SCL_PORT_Pos = 0x5
	// Bit mask of PORT field.
	TWI_PSEL_SCL_PORT_Msk = 0x20
	// Bit PORT.
	TWI_PSEL_SCL_PORT = 0x20
	// Position of CONNECT field.
	TWI_PSEL_SCL_CONNECT_Pos = 0x1f
	// Bit mask of CONNECT field.
	TWI_PSEL_SCL_CONNECT_Msk = 0x80000000
	// Bit CONNECT.
	TWI_PSEL_SCL_CONNECT = 0x80000000
	// Disconnect
	TWI_PSEL_SCL_CONNECT_Disconnected = 0x1
	// Connect
	TWI_PSEL_SCL_CONNECT_Connected = 0x0

	// PSEL.SDA: Pin select for SDA
	// Position of PIN field.
	TWI_PSEL_SDA_PIN_Pos = 0x0
	// Bit mask of PIN field.
	TWI_PSEL_SDA_PIN_Msk = 0x1f
	// Position of PORT field.
	TWI_PSEL_SDA_PORT_Pos = 0x5
	// Bit mask of PORT field.
	TWI_PSEL_SDA_PORT_Msk = 0x20
	// Bit PORT.
	TWI_PSEL_SDA_PORT = 0x20
	// Position of CONNECT field.
	TWI_PSEL_SDA_CONNECT_Pos = 0x1f
	// Bit mask of CONNECT field.
	TWI_PSEL_SDA_CONNECT_Msk = 0x80000000
	// Bit CONNECT.
	TWI_PSEL_SDA_CONNECT = 0x80000000
	// Disconnect
	TWI_PSEL_SDA_CONNECT_Disconnected = 0x1
	// Connect
	TWI_PSEL_SDA_CONNECT_Connected = 0x0

	// RXD: RXD register
	// Position of RXD field.
	TWI_RXD_RXD_Pos = 0x0
	// Bit mask of RXD field.
	TWI_RXD_RXD_Msk = 0xff

	// TXD: TXD register
	// Position of TXD field.
	TWI_TXD_TXD_Pos = 0x0
	// Bit mask of TXD field.
	TWI_TXD_TXD_Msk = 0xff

	// FREQUENCY: TWI frequency. Accuracy depends on the HFCLK source selected.
	// Position of FREQUENCY field.
	TWI_FREQUENCY_FREQUENCY_Pos = 0x0
	// Bit mask of FREQUENCY field.
	TWI_FREQUENCY_FREQUENCY_Msk = 0xffffffff
	// 100 kbps
	TWI_FREQUENCY_FREQUENCY_K100 = 0x1980000
	// 250 kbps
	TWI_FREQUENCY_FREQUENCY_K250 = 0x4000000
	// 400 kbps (actual rate 410.256 kbps)
	TWI_FREQUENCY_FREQUENCY_K400 = 0x6680000

	// ADDRESS: Address used in the TWI transfer
	// Position of ADDRESS field.
	TWI_ADDRESS_ADDRESS_Pos = 0x0
	// Bit mask of ADDRESS field.
	TWI_ADDRESS_ADDRESS_Msk = 0x7f
)

// Bitfields for TWIM0: I2C compatible Two-Wire Master Interface with EasyDMA 0
const (
	// TASKS_STARTRX: Start TWI receive sequence
	// Position of TASKS_STARTRX field.
	TWIM_TASKS_STARTRX_TASKS_STARTRX_Pos = 0x0
	// Bit mask of TASKS_STARTRX field.
	TWIM_TASKS_STARTRX_TASKS_STARTRX_Msk = 0x1
	// Bit TASKS_STARTRX.
	TWIM_TASKS_STARTRX_TASKS_STARTRX = 0x1
	// Trigger task
	TWIM_TASKS_STARTRX_TASKS_STARTRX_Trigger = 0x1

	// TASKS_STARTTX: Start TWI transmit sequence
	// Position of TASKS_STARTTX field.
	TWIM_TASKS_STARTTX_TASKS_STARTTX_Pos = 0x0
	// Bit mask of TASKS_STARTTX field.
	TWIM_TASKS_STARTTX_TASKS_STARTTX_Msk = 0x1
	// Bit TASKS_STARTTX.
	TWIM_TASKS_STARTTX_TASKS_STARTTX = 0x1
	// Trigger task
	TWIM_TASKS_STARTTX_TASKS_STARTTX_Trigger = 0x1

	// TASKS_STOP: Stop TWI transaction. Must be issued while the TWI master is not suspended.
	// Position of TASKS_STOP field.
	TWIM_TASKS_STOP_TASKS_STOP_Pos = 0x0
	// Bit mask of TASKS_STOP field.
	TWIM_TASKS_STOP_TASKS_STOP_Msk = 0x1
	// Bit TASKS_STOP.
	TWIM_TASKS_STOP_TASKS_STOP = 0x1
	// Trigger task
	TWIM_TASKS_STOP_TASKS_STOP_Trigger = 0x1

	// TASKS_SUSPEND: Suspend TWI transaction
	// Position of TASKS_SUSPEND field.
	TWIM_TASKS_SUSPEND_TASKS_SUSPEND_Pos = 0x0
	// Bit mask of TASKS_SUSPEND field.
	TWIM_TASKS_SUSPEND_TASKS_SUSPEND_Msk = 0x1
	// Bit TASKS_SUSPEND.
	TWIM_TASKS_SUSPEND_TASKS_SUSPEND = 0x1
	// Trigger task
	TWIM_TASKS_SUSPEND_TASKS_SUSPEND_Trigger = 0x1

	// TASKS_RESUME: Resume TWI transaction
	// Position of TASKS_RESUME field.
	TWIM_TASKS_RESUME_TASKS_RESUME_Pos = 0x0
	// Bit mask of TASKS_RESUME field.
	TWIM_TASKS_RESUME_TASKS_RESUME_Msk = 0x1
	// Bit TASKS_RESUME.
	TWIM_TASKS_RESUME_TASKS_RESUME = 0x1
	// Trigger task
	TWIM_TASKS_RESUME_TASKS_RESUME_Trigger = 0x1

	// EVENTS_STOPPED: TWI stopped
	// Position of EVENTS_STOPPED field.
	TWIM_EVENTS_STOPPED_EVENTS_STOPPED_Pos = 0x0
	// Bit mask of EVENTS_STOPPED field.
	TWIM_EVENTS_STOPPED_EVENTS_STOPPED_Msk = 0x1
	// Bit EVENTS_STOPPED.
	TWIM_EVENTS_STOPPED_EVENTS_STOPPED = 0x1
	// Event not generated
	TWIM_EVENTS_STOPPED_EVENTS_STOPPED_NotGenerated = 0x0
	// Event generated
	TWIM_EVENTS_STOPPED_EVENTS_STOPPED_Generated = 0x1

	// EVENTS_ERROR: TWI error
	// Position of EVENTS_ERROR field.
	TWIM_EVENTS_ERROR_EVENTS_ERROR_Pos = 0x0
	// Bit mask of EVENTS_ERROR field.
	TWIM_EVENTS_ERROR_EVENTS_ERROR_Msk = 0x1
	// Bit EVENTS_ERROR.
	TWIM_EVENTS_ERROR_EVENTS_ERROR = 0x1
	// Event not generated
	TWIM_EVENTS_ERROR_EVENTS_ERROR_NotGenerated = 0x0
	// Event generated
	TWIM_EVENTS_ERROR_EVENTS_ERROR_Generated = 0x1

	// EVENTS_SUSPENDED: Last byte has been sent out after the SUSPEND task has been issued, TWI traffic is now suspended.
	// Position of EVENTS_SUSPENDED field.
	TWIM_EVENTS_SUSPENDED_EVENTS_SUSPENDED_Pos = 0x0
	// Bit mask of EVENTS_SUSPENDED field.
	TWIM_EVENTS_SUSPENDED_EVENTS_SUSPENDED_Msk = 0x1
	// Bit EVENTS_SUSPENDED.
	TWIM_EVENTS_SUSPENDED_EVENTS_SUSPENDED = 0x1
	// Event not generated
	TWIM_EVENTS_SUSPENDED_EVENTS_SUSPENDED_NotGenerated = 0x0
	// Event generated
	TWIM_EVENTS_SUSPENDED_EVENTS_SUSPENDED_Generated = 0x1

	// EVENTS_RXSTARTED: Receive sequence started
	// Position of EVENTS_RXSTARTED field.
	TWIM_EVENTS_RXSTARTED_EVENTS_RXSTARTED_Pos = 0x0
	// Bit mask of EVENTS_RXSTARTED field.
	TWIM_EVENTS_RXSTARTED_EVENTS_RXSTARTED_Msk = 0x1
	// Bit EVENTS_RXSTARTED.
	TWIM_EVENTS_RXSTARTED_EVENTS_RXSTARTED = 0x1
	// Event not generated
	TWIM_EVENTS_RXSTARTED_EVENTS_RXSTARTED_NotGenerated = 0x0
	// Event generated
	TWIM_EVENTS_RXSTARTED_EVENTS_RXSTARTED_Generated = 0x1

	// EVENTS_TXSTARTED: Transmit sequence started
	// Position of EVENTS_TXSTARTED field.
	TWIM_EVENTS_TXSTARTED_EVENTS_TXSTARTED_Pos = 0x0
	// Bit mask of EVENTS_TXSTARTED field.
	TWIM_EVENTS_TXSTARTED_EVENTS_TXSTARTED_Msk = 0x1
	// Bit EVENTS_TXSTARTED.
	TWIM_EVENTS_TXSTARTED_EVENTS_TXSTARTED = 0x1
	// Event not generated
	TWIM_EVENTS_TXSTARTED_EVENTS_TXSTARTED_NotGenerated = 0x0
	// Event generated
	TWIM_EVENTS_TXSTARTED_EVENTS_TXSTARTED_Generated = 0x1

	// EVENTS_LASTRX: Byte boundary, starting to receive the last byte
	// Position of EVENTS_LASTRX field.
	TWIM_EVENTS_LASTRX_EVENTS_LASTRX_Pos = 0x0
	// Bit mask of EVENTS_LASTRX field.
	TWIM_EVENTS_LASTRX_EVENTS_LASTRX_Msk = 0x1
	// Bit EVENTS_LASTRX.
	TWIM_EVENTS_LASTRX_EVENTS_LASTRX = 0x1
	// Event not generated
	TWIM_EVENTS_LASTRX_EVENTS_LASTRX_NotGenerated = 0x0
	// Event generated
	TWIM_EVENTS_LASTRX_EVENTS_LASTRX_Generated = 0x1

	// EVENTS_LASTTX: Byte boundary, starting to transmit the last byte
	// Position of EVENTS_LASTTX field.
	TWIM_EVENTS_LASTTX_EVENTS_LASTTX_Pos = 0x0
	// Bit mask of EVENTS_LASTTX field.
	TWIM_EVENTS_LASTTX_EVENTS_LASTTX_Msk = 0x1
	// Bit EVENTS_LASTTX.
	TWIM_EVENTS_LASTTX_EVENTS_LASTTX = 0x1
	// Event not generated
	TWIM_EVENTS_LASTTX_EVENTS_LASTTX_NotGenerated = 0x0
	// Event generated
	TWIM_EVENTS_LASTTX_EVENTS_LASTTX_Generated = 0x1

	// SHORTS: Shortcuts between local events and tasks
	// Position of LASTTX_STARTRX field.
	TWIM_SHORTS_LASTTX_STARTRX_Pos = 0x7
	// Bit mask of LASTTX_STARTRX field.
	TWIM_SHORTS_LASTTX_STARTRX_Msk = 0x80
	// Bit LASTTX_STARTRX.
	TWIM_SHORTS_LASTTX_STARTRX = 0x80
	// Disable shortcut
	TWIM_SHORTS_LASTTX_STARTRX_Disabled = 0x0
	// Enable shortcut
	TWIM_SHORTS_LASTTX_STARTRX_Enabled = 0x1
	// Position of LASTTX_SUSPEND field.
	TWIM_SHORTS_LASTTX_SUSPEND_Pos = 0x8
	// Bit mask of LASTTX_SUSPEND field.
	TWIM_SHORTS_LASTTX_SUSPEND_Msk = 0x100
	// Bit LASTTX_SUSPEND.
	TWIM_SHORTS_LASTTX_SUSPEND = 0x100
	// Disable shortcut
	TWIM_SHORTS_LASTTX_SUSPEND_Disabled = 0x0
	// Enable shortcut
	TWIM_SHORTS_LASTTX_SUSPEND_Enabled = 0x1
	// Position of LASTTX_STOP field.
	TWIM_SHORTS_LASTTX_STOP_Pos = 0x9
	// Bit mask of LASTTX_STOP field.
	TWIM_SHORTS_LASTTX_STOP_Msk = 0x200
	// Bit LASTTX_STOP.
	TWIM_SHORTS_LASTTX_STOP = 0x200
	// Disable shortcut
	TWIM_SHORTS_LASTTX_STOP_Disabled = 0x0
	// Enable shortcut
	TWIM_SHORTS_LASTTX_STOP_Enabled = 0x1
	// Position of LASTRX_STARTTX field.
	TWIM_SHORTS_LASTRX_STARTTX_Pos = 0xa
	// Bit mask of LASTRX_STARTTX field.
	TWIM_SHORTS_LASTRX_STARTTX_Msk = 0x400
	// Bit LASTRX_STARTTX.
	TWIM_SHORTS_LASTRX_STARTTX = 0x400
	// Disable shortcut
	TWIM_SHORTS_LASTRX_STARTTX_Disabled = 0x0
	// Enable shortcut
	TWIM_SHORTS_LASTRX_STARTTX_Enabled = 0x1
	// Position of LASTRX_SUSPEND field.
	TWIM_SHORTS_LASTRX_SUSPEND_Pos = 0xb
	// Bit mask of LASTRX_SUSPEND field.
	TWIM_SHORTS_LASTRX_SUSPEND_Msk = 0x800
	// Bit LASTRX_SUSPEND.
	TWIM_SHORTS_LASTRX_SUSPEND = 0x800
	// Disable shortcut
	TWIM_SHORTS_LASTRX_SUSPEND_Disabled = 0x0
	// Enable shortcut
	TWIM_SHORTS_LASTRX_SUSPEND_Enabled = 0x1
	// Position of LASTRX_STOP field.
	TWIM_SHORTS_LASTRX_STOP_Pos = 0xc
	// Bit mask of LASTRX_STOP field.
	TWIM_SHORTS_LASTRX_STOP_Msk = 0x1000
	// Bit LASTRX_STOP.
	TWIM_SHORTS_LASTRX_STOP = 0x1000
	// Disable shortcut
	TWIM_SHORTS_LASTRX_STOP_Disabled = 0x0
	// Enable shortcut
	TWIM_SHORTS_LASTRX_STOP_Enabled = 0x1

	// INTEN: Enable or disable interrupt
	// Position of STOPPED field.
	TWIM_INTEN_STOPPED_Pos = 0x1
	// Bit mask of STOPPED field.
	TWIM_INTEN_STOPPED_Msk = 0x2
	// Bit STOPPED.
	TWIM_INTEN_STOPPED = 0x2
	// Disable
	TWIM_INTEN_STOPPED_Disabled = 0x0
	// Enable
	TWIM_INTEN_STOPPED_Enabled = 0x1
	// Position of ERROR field.
	TWIM_INTEN_ERROR_Pos = 0x9
	// Bit mask of ERROR field.
	TWIM_INTEN_ERROR_Msk = 0x200
	// Bit ERROR.
	TWIM_INTEN_ERROR = 0x200
	// Disable
	TWIM_INTEN_ERROR_Disabled = 0x0
	// Enable
	TWIM_INTEN_ERROR_Enabled = 0x1
	// Position of SUSPENDED field.
	TWIM_INTEN_SUSPENDED_Pos = 0x12
	// Bit mask of SUSPENDED field.
	TWIM_INTEN_SUSPENDED_Msk = 0x40000
	// Bit SUSPENDED.
	TWIM_INTEN_SUSPENDED = 0x40000
	// Disable
	TWIM_INTEN_SUSPENDED_Disabled = 0x0
	// Enable
	TWIM_INTEN_SUSPENDED_Enabled = 0x1
	// Position of RXSTARTED field.
	TWIM_INTEN_RXSTARTED_Pos = 0x13
	// Bit mask of RXSTARTED field.
	TWIM_INTEN_RXSTARTED_Msk = 0x80000
	// Bit RXSTARTED.
	TWIM_INTEN_RXSTARTED = 0x80000
	// Disable
	TWIM_INTEN_RXSTARTED_Disabled = 0x0
	// Enable
	TWIM_INTEN_RXSTARTED_Enabled = 0x1
	// Position of TXSTARTED field.
	TWIM_INTEN_TXSTARTED_Pos = 0x14
	// Bit mask of TXSTARTED field.
	TWIM_INTEN_TXSTARTED_Msk = 0x100000
	// Bit TXSTARTED.
	TWIM_INTEN_TXSTARTED = 0x100000
	// Disable
	TWIM_INTEN_TXSTARTED_Disabled = 0x0
	// Enable
	TWIM_INTEN_TXSTARTED_Enabled = 0x1
	// Position of LASTRX field.
	TWIM_INTEN_LASTRX_Pos = 0x17
	// Bit mask of LASTRX field.
	TWIM_INTEN_LASTRX_Msk = 0x800000
	// Bit LASTRX.
	TWIM_INTEN_LASTRX = 0x800000
	// Disable
	TWIM_INTEN_LASTRX_Disabled = 0x0
	// Enable
	TWIM_INTEN_LASTRX_Enabled = 0x1
	// Position of LASTTX field.
	TWIM_INTEN_LASTTX_Pos = 0x18
	// Bit mask of LASTTX field.
	TWIM_INTEN_LASTTX_Msk = 0x1000000
	// Bit LASTTX.
	TWIM_INTEN_LASTTX = 0x1000000
	// Disable
	TWIM_INTEN_LASTTX_Disabled = 0x0
	// Enable
	TWIM_INTEN_LASTTX_Enabled = 0x1

	// INTENSET: Enable interrupt
	// Position of STOPPED field.
	TWIM_INTENSET_STOPPED_Pos = 0x1
	// Bit mask of STOPPED field.
	TWIM_INTENSET_STOPPED_Msk = 0x2
	// Bit STOPPED.
	TWIM_INTENSET_STOPPED = 0x2
	// Read: Disabled
	TWIM_INTENSET_STOPPED_Disabled = 0x0
	// Read: Enabled
	TWIM_INTENSET_STOPPED_Enabled = 0x1
	// Enable
	TWIM_INTENSET_STOPPED_Set = 0x1
	// Position of ERROR field.
	TWIM_INTENSET_ERROR_Pos = 0x9
	// Bit mask of ERROR field.
	TWIM_INTENSET_ERROR_Msk = 0x200
	// Bit ERROR.
	TWIM_INTENSET_ERROR = 0x200
	// Read: Disabled
	TWIM_INTENSET_ERROR_Disabled = 0x0
	// Read: Enabled
	TWIM_INTENSET_ERROR_Enabled = 0x1
	// Enable
	TWIM_INTENSET_ERROR_Set = 0x1
	// Position of SUSPENDED field.
	TWIM_INTENSET_SUSPENDED_Pos = 0x12
	// Bit mask of SUSPENDED field.
	TWIM_INTENSET_SUSPENDED_Msk = 0x40000
	// Bit SUSPENDED.
	TWIM_INTENSET_SUSPENDED = 0x40000
	// Read: Disabled
	TWIM_INTENSET_SUSPENDED_Disabled = 0x0
	// Read: Enabled
	TWIM_INTENSET_SUSPENDED_Enabled = 0x1
	// Enable
	TWIM_INTENSET_SUSPENDED_Set = 0x1
	// Position of RXSTARTED field.
	TWIM_INTENSET_RXSTARTED_Pos = 0x13
	// Bit mask of RXSTARTED field.
	TWIM_INTENSET_RXSTARTED_Msk = 0x80000
	// Bit RXSTARTED.
	TWIM_INTENSET_RXSTARTED = 0x80000
	// Read: Disabled
	TWIM_INTENSET_RXSTARTED_Disabled = 0x0
	// Read: Enabled
	TWIM_INTENSET_RXSTARTED_Enabled = 0x1
	// Enable
	TWIM_INTENSET_RXSTARTED_Set = 0x1
	// Position of TXSTARTED field.
	TWIM_INTENSET_TXSTARTED_Pos = 0x14
	// Bit mask of TXSTARTED field.
	TWIM_INTENSET_TXSTARTED_Msk = 0x100000
	// Bit TXSTARTED.
	TWIM_INTENSET_TXSTARTED = 0x100000
	// Read: Disabled
	TWIM_INTENSET_TXSTARTED_Disabled = 0x0
	// Read: Enabled
	TWIM_INTENSET_TXSTARTED_Enabled = 0x1
	// Enable
	TWIM_INTENSET_TXSTARTED_Set = 0x1
	// Position of LASTRX field.
	TWIM_INTENSET_LASTRX_Pos = 0x17
	// Bit mask of LASTRX field.
	TWIM_INTENSET_LASTRX_Msk = 0x800000
	// Bit LASTRX.
	TWIM_INTENSET_LASTRX = 0x800000
	// Read: Disabled
	TWIM_INTENSET_LASTRX_Disabled = 0x0
	// Read: Enabled
	TWIM_INTENSET_LASTRX_Enabled = 0x1
	// Enable
	TWIM_INTENSET_LASTRX_Set = 0x1
	// Position of LASTTX field.
	TWIM_INTENSET_LASTTX_Pos = 0x18
	// Bit mask of LASTTX field.
	TWIM_INTENSET_LASTTX_Msk = 0x1000000
	// Bit LASTTX.
	TWIM_INTENSET_LASTTX = 0x1000000
	// Read: Disabled
	TWIM_INTENSET_LASTTX_Disabled = 0x0
	// Read: Enabled
	TWIM_INTENSET_LASTTX_Enabled = 0x1
	// Enable
	TWIM_INTENSET_LASTTX_Set = 0x1

	// INTENCLR: Disable interrupt
	// Position of STOPPED field.
	TWIM_INTENCLR_STOPPED_Pos = 0x1
	// Bit mask of STOPPED field.
	TWIM_INTENCLR_STOPPED_Msk = 0x2
	// Bit STOPPED.
	TWIM_INTENCLR_STOPPED = 0x2
	// Read: Disabled
	TWIM_INTENCLR_STOPPED_Disabled = 0x0
	// Read: Enabled
	TWIM_INTENCLR_STOPPED_Enabled = 0x1
	// Disable
	TWIM_INTENCLR_STOPPED_Clear = 0x1
	// Position of ERROR field.
	TWIM_INTENCLR_ERROR_Pos = 0x9
	// Bit mask of ERROR field.
	TWIM_INTENCLR_ERROR_Msk = 0x200
	// Bit ERROR.
	TWIM_INTENCLR_ERROR = 0x200
	// Read: Disabled
	TWIM_INTENCLR_ERROR_Disabled = 0x0
	// Read: Enabled
	TWIM_INTENCLR_ERROR_Enabled = 0x1
	// Disable
	TWIM_INTENCLR_ERROR_Clear = 0x1
	// Position of SUSPENDED field.
	TWIM_INTENCLR_SUSPENDED_Pos = 0x12
	// Bit mask of SUSPENDED field.
	TWIM_INTENCLR_SUSPENDED_Msk = 0x40000
	// Bit SUSPENDED.
	TWIM_INTENCLR_SUSPENDED = 0x40000
	// Read: Disabled
	TWIM_INTENCLR_SUSPENDED_Disabled = 0x0
	// Read: Enabled
	TWIM_INTENCLR_SUSPENDED_Enabled = 0x1
	// Disable
	TWIM_INTENCLR_SUSPENDED_Clear = 0x1
	// Position of RXSTARTED field.
	TWIM_INTENCLR_RXSTARTED_Pos = 0x13
	// Bit mask of RXSTARTED field.
	TWIM_INTENCLR_RXSTARTED_Msk = 0x80000
	// Bit RXSTARTED.
	TWIM_INTENCLR_RXSTARTED = 0x80000
	// Read: Disabled
	TWIM_INTENCLR_RXSTARTED_Disabled = 0x0
	// Read: Enabled
	TWIM_INTENCLR_RXSTARTED_Enabled = 0x1
	// Disable
	TWIM_INTENCLR_RXSTARTED_Clear = 0x1
	// Position of TXSTARTED field.
	TWIM_INTENCLR_TXSTARTED_Pos = 0x14
	// Bit mask of TXSTARTED field.
	TWIM_INTENCLR_TXSTARTED_Msk = 0x100000
	// Bit TXSTARTED.
	TWIM_INTENCLR_TXSTARTED = 0x100000
	// Read: Disabled
	TWIM_INTENCLR_TXSTARTED_Disabled = 0x0
	// Read: Enabled
	TWIM_INTENCLR_TXSTARTED_Enabled = 0x1
	// Disable
	TWIM_INTENCLR_TXSTARTED_Clear = 0x1
	// Position of LASTRX field.
	TWIM_INTENCLR_LASTRX_Pos = 0x17
	// Bit mask of LASTRX field.
	TWIM_INTENCLR_LASTRX_Msk = 0x800000
	// Bit LASTRX.
	TWIM_INTENCLR_LASTRX = 0x800000
	// Read: Disabled
	TWIM_INTENCLR_LASTRX_Disabled = 0x0
	// Read: Enabled
	TWIM_INTENCLR_LASTRX_Enabled = 0x1
	// Disable
	TWIM_INTENCLR_LASTRX_Clear = 0x1
	// Position of LASTTX field.
	TWIM_INTENCLR_LASTTX_Pos = 0x18
	// Bit mask of LASTTX field.
	TWIM_INTENCLR_LASTTX_Msk = 0x1000000
	// Bit LASTTX.
	TWIM_INTENCLR_LASTTX = 0x1000000
	// Read: Disabled
	TWIM_INTENCLR_LASTTX_Disabled = 0x0
	// Read: Enabled
	TWIM_INTENCLR_LASTTX_Enabled = 0x1
	// Disable
	TWIM_INTENCLR_LASTTX_Clear = 0x1

	// ERRORSRC: Error source
	// Position of OVERRUN field.
	TWIM_ERRORSRC_OVERRUN_Pos = 0x0
	// Bit mask of OVERRUN field.
	TWIM_ERRORSRC_OVERRUN_Msk = 0x1
	// Bit OVERRUN.
	TWIM_ERRORSRC_OVERRUN = 0x1
	// Error did not occur
	TWIM_ERRORSRC_OVERRUN_NotReceived = 0x0
	// Error occurred
	TWIM_ERRORSRC_OVERRUN_Received = 0x1
	// Position of ANACK field.
	TWIM_ERRORSRC_ANACK_Pos = 0x1
	// Bit mask of ANACK field.
	TWIM_ERRORSRC_ANACK_Msk = 0x2
	// Bit ANACK.
	TWIM_ERRORSRC_ANACK = 0x2
	// Error did not occur
	TWIM_ERRORSRC_ANACK_NotReceived = 0x0
	// Error occurred
	TWIM_ERRORSRC_ANACK_Received = 0x1
	// Position of DNACK field.
	TWIM_ERRORSRC_DNACK_Pos = 0x2
	// Bit mask of DNACK field.
	TWIM_ERRORSRC_DNACK_Msk = 0x4
	// Bit DNACK.
	TWIM_ERRORSRC_DNACK = 0x4
	// Error did not occur
	TWIM_ERRORSRC_DNACK_NotReceived = 0x0
	// Error occurred
	TWIM_ERRORSRC_DNACK_Received = 0x1

	// ENABLE: Enable TWIM
	// Position of ENABLE field.
	TWIM_ENABLE_ENABLE_Pos = 0x0
	// Bit mask of ENABLE field.
	TWIM_ENABLE_ENABLE_Msk = 0xf
	// Disable TWIM
	TWIM_ENABLE_ENABLE_Disabled = 0x0
	// Enable TWIM
	TWIM_ENABLE_ENABLE_Enabled = 0x6

	// PSEL.SCL: Pin select for SCL signal
	// Position of PIN field.
	TWIM_PSEL_SCL_PIN_Pos = 0x0
	// Bit mask of PIN field.
	TWIM_PSEL_SCL_PIN_Msk = 0x1f
	// Position of PORT field.
	TWIM_PSEL_SCL_PORT_Pos = 0x5
	// Bit mask of PORT field.
	TWIM_PSEL_SCL_PORT_Msk = 0x20
	// Bit PORT.
	TWIM_PSEL_SCL_PORT = 0x20
	// Position of CONNECT field.
	TWIM_PSEL_SCL_CONNECT_Pos = 0x1f
	// Bit mask of CONNECT field.
	TWIM_PSEL_SCL_CONNECT_Msk = 0x80000000
	// Bit CONNECT.
	TWIM_PSEL_SCL_CONNECT = 0x80000000
	// Disconnect
	TWIM_PSEL_SCL_CONNECT_Disconnected = 0x1
	// Connect
	TWIM_PSEL_SCL_CONNECT_Connected = 0x0

	// PSEL.SDA: Pin select for SDA signal
	// Position of PIN field.
	TWIM_PSEL_SDA_PIN_Pos = 0x0
	// Bit mask of PIN field.
	TWIM_PSEL_SDA_PIN_Msk = 0x1f
	// Position of PORT field.
	TWIM_PSEL_SDA_PORT_Pos = 0x5
	// Bit mask of PORT field.
	TWIM_PSEL_SDA_PORT_Msk = 0x20
	// Bit PORT.
	TWIM_PSEL_SDA_PORT = 0x20
	// Position of CONNECT field.
	TWIM_PSEL_SDA_CONNECT_Pos = 0x1f
	// Bit mask of CONNECT field.
	TWIM_PSEL_SDA_CONNECT_Msk = 0x80000000
	// Bit CONNECT.
	TWIM_PSEL_SDA_CONNECT = 0x80000000
	// Disconnect
	TWIM_PSEL_SDA_CONNECT_Disconnected = 0x1
	// Connect
	TWIM_PSEL_SDA_CONNECT_Connected = 0x0

	// FREQUENCY: TWI frequency. Accuracy depends on the HFCLK source selected.
	// Position of FREQUENCY field.
	TWIM_FREQUENCY_FREQUENCY_Pos = 0x0
	// Bit mask of FREQUENCY field.
	TWIM_FREQUENCY_FREQUENCY_Msk = 0xffffffff
	// 100 kbps
	TWIM_FREQUENCY_FREQUENCY_K100 = 0x1980000
	// 250 kbps
	TWIM_FREQUENCY_FREQUENCY_K250 = 0x4000000
	// 400 kbps
	TWIM_FREQUENCY_FREQUENCY_K400 = 0x6400000

	// RXD.PTR: Data pointer
	// Position of PTR field.
	TWIM_RXD_PTR_PTR_Pos = 0x0
	// Bit mask of PTR field.
	TWIM_RXD_PTR_PTR_Msk = 0xffffffff

	// RXD.MAXCNT: Maximum number of bytes in receive buffer
	// Position of MAXCNT field.
	TWIM_RXD_MAXCNT_MAXCNT_Pos = 0x0
	// Bit mask of MAXCNT field.
	TWIM_RXD_MAXCNT_MAXCNT_Msk = 0xffff

	// RXD.AMOUNT: Number of bytes transferred in the last transaction
	// Position of AMOUNT field.
	TWIM_RXD_AMOUNT_AMOUNT_Pos = 0x0
	// Bit mask of AMOUNT field.
	TWIM_RXD_AMOUNT_AMOUNT_Msk = 0xffff

	// RXD.LIST: EasyDMA list type
	// Position of LIST field.
	TWIM_RXD_LIST_LIST_Pos = 0x0
	// Bit mask of LIST field.
	TWIM_RXD_LIST_LIST_Msk = 0x7
	// Disable EasyDMA list
	TWIM_RXD_LIST_LIST_Disabled = 0x0
	// Use array list
	TWIM_RXD_LIST_LIST_ArrayList = 0x1

	// TXD.PTR: Data pointer
	// Position of PTR field.
	TWIM_TXD_PTR_PTR_Pos = 0x0
	// Bit mask of PTR field.
	TWIM_TXD_PTR_PTR_Msk = 0xffffffff

	// TXD.MAXCNT: Maximum number of bytes in transmit buffer
	// Position of MAXCNT field.
	TWIM_TXD_MAXCNT_MAXCNT_Pos = 0x0
	// Bit mask of MAXCNT field.
	TWIM_TXD_MAXCNT_MAXCNT_Msk = 0xffff

	// TXD.AMOUNT: Number of bytes transferred in the last transaction
	// Position of AMOUNT field.
	TWIM_TXD_AMOUNT_AMOUNT_Pos = 0x0
	// Bit mask of AMOUNT field.
	TWIM_TXD_AMOUNT_AMOUNT_Msk = 0xffff

	// TXD.LIST: EasyDMA list type
	// Position of LIST field.
	TWIM_TXD_LIST_LIST_Pos = 0x0
	// Bit mask of LIST field.
	TWIM_TXD_LIST_LIST_Msk = 0x7
	// Disable EasyDMA list
	TWIM_TXD_LIST_LIST_Disabled = 0x0
	// Use array list
	TWIM_TXD_LIST_LIST_ArrayList = 0x1

	// ADDRESS: Address used in the TWI transfer
	// Position of ADDRESS field.
	TWIM_ADDRESS_ADDRESS_Pos = 0x0
	// Bit mask of ADDRESS field.
	TWIM_ADDRESS_ADDRESS_Msk = 0x7f
)

// Bitfields for TWIS0: I2C compatible Two-Wire Slave Interface with EasyDMA 0
const (
	// TASKS_STOP: Stop TWI transaction
	// Position of TASKS_STOP field.
	TWIS_TASKS_STOP_TASKS_STOP_Pos = 0x0
	// Bit mask of TASKS_STOP field.
	TWIS_TASKS_STOP_TASKS_STOP_Msk = 0x1
	// Bit TASKS_STOP.
	TWIS_TASKS_STOP_TASKS_STOP = 0x1
	// Trigger task
	TWIS_TASKS_STOP_TASKS_STOP_Trigger = 0x1

	// TASKS_SUSPEND: Suspend TWI transaction
	// Position of TASKS_SUSPEND field.
	TWIS_TASKS_SUSPEND_TASKS_SUSPEND_Pos = 0x0
	// Bit mask of TASKS_SUSPEND field.
	TWIS_TASKS_SUSPEND_TASKS_SUSPEND_Msk = 0x1
	// Bit TASKS_SUSPEND.
	TWIS_TASKS_SUSPEND_TASKS_SUSPEND = 0x1
	// Trigger task
	TWIS_TASKS_SUSPEND_TASKS_SUSPEND_Trigger = 0x1

	// TASKS_RESUME: Resume TWI transaction
	// Position of TASKS_RESUME field.
	TWIS_TASKS_RESUME_TASKS_RESUME_Pos = 0x0
	// Bit mask of TASKS_RESUME field.
	TWIS_TASKS_RESUME_TASKS_RESUME_Msk = 0x1
	// Bit TASKS_RESUME.
	TWIS_TASKS_RESUME_TASKS_RESUME = 0x1
	// Trigger task
	TWIS_TASKS_RESUME_TASKS_RESUME_Trigger = 0x1

	// TASKS_PREPARERX: Prepare the TWI slave to respond to a write command
	// Position of TASKS_PREPARERX field.
	TWIS_TASKS_PREPARERX_TASKS_PREPARERX_Pos = 0x0
	// Bit mask of TASKS_PREPARERX field.
	TWIS_TASKS_PREPARERX_TASKS_PREPARERX_Msk = 0x1
	// Bit TASKS_PREPARERX.
	TWIS_TASKS_PREPARERX_TASKS_PREPARERX = 0x1
	// Trigger task
	TWIS_TASKS_PREPARERX_TASKS_PREPARERX_Trigger = 0x1

	// TASKS_PREPARETX: Prepare the TWI slave to respond to a read command
	// Position of TASKS_PREPARETX field.
	TWIS_TASKS_PREPARETX_TASKS_PREPARETX_Pos = 0x0
	// Bit mask of TASKS_PREPARETX field.
	TWIS_TASKS_PREPARETX_TASKS_PREPARETX_Msk = 0x1
	// Bit TASKS_PREPARETX.
	TWIS_TASKS_PREPARETX_TASKS_PREPARETX = 0x1
	// Trigger task
	TWIS_TASKS_PREPARETX_TASKS_PREPARETX_Trigger = 0x1

	// EVENTS_STOPPED: TWI stopped
	// Position of EVENTS_STOPPED field.
	TWIS_EVENTS_STOPPED_EVENTS_STOPPED_Pos = 0x0
	// Bit mask of EVENTS_STOPPED field.
	TWIS_EVENTS_STOPPED_EVENTS_STOPPED_Msk = 0x1
	// Bit EVENTS_STOPPED.
	TWIS_EVENTS_STOPPED_EVENTS_STOPPED = 0x1
	// Event not generated
	TWIS_EVENTS_STOPPED_EVENTS_STOPPED_NotGenerated = 0x0
	// Event generated
	TWIS_EVENTS_STOPPED_EVENTS_STOPPED_Generated = 0x1

	// EVENTS_ERROR: TWI error
	// Position of EVENTS_ERROR field.
	TWIS_EVENTS_ERROR_EVENTS_ERROR_Pos = 0x0
	// Bit mask of EVENTS_ERROR field.
	TWIS_EVENTS_ERROR_EVENTS_ERROR_Msk = 0x1
	// Bit EVENTS_ERROR.
	TWIS_EVENTS_ERROR_EVENTS_ERROR = 0x1
	// Event not generated
	TWIS_EVENTS_ERROR_EVENTS_ERROR_NotGenerated = 0x0
	// Event generated
	TWIS_EVENTS_ERROR_EVENTS_ERROR_Generated = 0x1

	// EVENTS_RXSTARTED: Receive sequence started
	// Position of EVENTS_RXSTARTED field.
	TWIS_EVENTS_RXSTARTED_EVENTS_RXSTARTED_Pos = 0x0
	// Bit mask of EVENTS_RXSTARTED field.
	TWIS_EVENTS_RXSTARTED_EVENTS_RXSTARTED_Msk = 0x1
	// Bit EVENTS_RXSTARTED.
	TWIS_EVENTS_RXSTARTED_EVENTS_RXSTARTED = 0x1
	// Event not generated
	TWIS_EVENTS_RXSTARTED_EVENTS_RXSTARTED_NotGenerated = 0x0
	// Event generated
	TWIS_EVENTS_RXSTARTED_EVENTS_RXSTARTED_Generated = 0x1

	// EVENTS_TXSTARTED: Transmit sequence started
	// Position of EVENTS_TXSTARTED field.
	TWIS_EVENTS_TXSTARTED_EVENTS_TXSTARTED_Pos = 0x0
	// Bit mask of EVENTS_TXSTARTED field.
	TWIS_EVENTS_TXSTARTED_EVENTS_TXSTARTED_Msk = 0x1
	// Bit EVENTS_TXSTARTED.
	TWIS_EVENTS_TXSTARTED_EVENTS_TXSTARTED = 0x1
	// Event not generated
	TWIS_EVENTS_TXSTARTED_EVENTS_TXSTARTED_NotGenerated = 0x0
	// Event generated
	TWIS_EVENTS_TXSTARTED_EVENTS_TXSTARTED_Generated = 0x1

	// EVENTS_WRITE: Write command received
	// Position of EVENTS_WRITE field.
	TWIS_EVENTS_WRITE_EVENTS_WRITE_Pos = 0x0
	// Bit mask of EVENTS_WRITE field.
	TWIS_EVENTS_WRITE_EVENTS_WRITE_Msk = 0x1
	// Bit EVENTS_WRITE.
	TWIS_EVENTS_WRITE_EVENTS_WRITE = 0x1
	// Event not generated
	TWIS_EVENTS_WRITE_EVENTS_WRITE_NotGenerated = 0x0
	// Event generated
	TWIS_EVENTS_WRITE_EVENTS_WRITE_Generated = 0x1

	// EVENTS_READ: Read command received
	// Position of EVENTS_READ field.
	TWIS_EVENTS_READ_EVENTS_READ_Pos = 0x0
	// Bit mask of EVENTS_READ field.
	TWIS_EVENTS_READ_EVENTS_READ_Msk = 0x1
	// Bit EVENTS_READ.
	TWIS_EVENTS_READ_EVENTS_READ = 0x1
	// Event not generated
	TWIS_EVENTS_READ_EVENTS_READ_NotGenerated = 0x0
	// Event generated
	TWIS_EVENTS_READ_EVENTS_READ_Generated = 0x1

	// SHORTS: Shortcuts between local events and tasks
	// Position of WRITE_SUSPEND field.
	TWIS_SHORTS_WRITE_SUSPEND_Pos = 0xd
	// Bit mask of WRITE_SUSPEND field.
	TWIS_SHORTS_WRITE_SUSPEND_Msk = 0x2000
	// Bit WRITE_SUSPEND.
	TWIS_SHORTS_WRITE_SUSPEND = 0x2000
	// Disable shortcut
	TWIS_SHORTS_WRITE_SUSPEND_Disabled = 0x0
	// Enable shortcut
	TWIS_SHORTS_WRITE_SUSPEND_Enabled = 0x1
	// Position of READ_SUSPEND field.
	TWIS_SHORTS_READ_SUSPEND_Pos = 0xe
	// Bit mask of READ_SUSPEND field.
	TWIS_SHORTS_READ_SUSPEND_Msk = 0x4000
	// Bit READ_SUSPEND.
	TWIS_SHORTS_READ_SUSPEND = 0x4000
	// Disable shortcut
	TWIS_SHORTS_READ_SUSPEND_Disabled = 0x0
	// Enable shortcut
	TWIS_SHORTS_READ_SUSPEND_Enabled = 0x1

	// INTEN: Enable or disable interrupt
	// Position of STOPPED field.
	TWIS_INTEN_STOPPED_Pos = 0x1
	// Bit mask of STOPPED field.
	TWIS_INTEN_STOPPED_Msk = 0x2
	// Bit STOPPED.
	TWIS_INTEN_STOPPED = 0x2
	// Disable
	TWIS_INTEN_STOPPED_Disabled = 0x0
	// Enable
	TWIS_INTEN_STOPPED_Enabled = 0x1
	// Position of ERROR field.
	TWIS_INTEN_ERROR_Pos = 0x9
	// Bit mask of ERROR field.
	TWIS_INTEN_ERROR_Msk = 0x200
	// Bit ERROR.
	TWIS_INTEN_ERROR = 0x200
	// Disable
	TWIS_INTEN_ERROR_Disabled = 0x0
	// Enable
	TWIS_INTEN_ERROR_Enabled = 0x1
	// Position of RXSTARTED field.
	TWIS_INTEN_RXSTARTED_Pos = 0x13
	// Bit mask of RXSTARTED field.
	TWIS_INTEN_RXSTARTED_Msk = 0x80000
	// Bit RXSTARTED.
	TWIS_INTEN_RXSTARTED = 0x80000
	// Disable
	TWIS_INTEN_RXSTARTED_Disabled = 0x0
	// Enable
	TWIS_INTEN_RXSTARTED_Enabled = 0x1
	// Position of TXSTARTED field.
	TWIS_INTEN_TXSTARTED_Pos = 0x14
	// Bit mask of TXSTARTED field.
	TWIS_INTEN_TXSTARTED_Msk = 0x100000
	// Bit TXSTARTED.
	TWIS_INTEN_TXSTARTED = 0x100000
	// Disable
	TWIS_INTEN_TXSTARTED_Disabled = 0x0
	// Enable
	TWIS_INTEN_TXSTARTED_Enabled = 0x1
	// Position of WRITE field.
	TWIS_INTEN_WRITE_Pos = 0x19
	// Bit mask of WRITE field.
	TWIS_INTEN_WRITE_Msk = 0x2000000
	// Bit WRITE.
	TWIS_INTEN_WRITE = 0x2000000
	// Disable
	TWIS_INTEN_WRITE_Disabled = 0x0
	// Enable
	TWIS_INTEN_WRITE_Enabled = 0x1
	// Position of READ field.
	TWIS_INTEN_READ_Pos = 0x1a
	// Bit mask of READ field.
	TWIS_INTEN_READ_Msk = 0x4000000
	// Bit READ.
	TWIS_INTEN_READ = 0x4000000
	// Disable
	TWIS_INTEN_READ_Disabled = 0x0
	// Enable
	TWIS_INTEN_READ_Enabled = 0x1

	// INTENSET: Enable interrupt
	// Position of STOPPED field.
	TWIS_INTENSET_STOPPED_Pos = 0x1
	// Bit mask of STOPPED field.
	TWIS_INTENSET_STOPPED_Msk = 0x2
	// Bit STOPPED.
	TWIS_INTENSET_STOPPED = 0x2
	// Read: Disabled
	TWIS_INTENSET_STOPPED_Disabled = 0x0
	// Read: Enabled
	TWIS_INTENSET_STOPPED_Enabled = 0x1
	// Enable
	TWIS_INTENSET_STOPPED_Set = 0x1
	// Position of ERROR field.
	TWIS_INTENSET_ERROR_Pos = 0x9
	// Bit mask of ERROR field.
	TWIS_INTENSET_ERROR_Msk = 0x200
	// Bit ERROR.
	TWIS_INTENSET_ERROR = 0x200
	// Read: Disabled
	TWIS_INTENSET_ERROR_Disabled = 0x0
	// Read: Enabled
	TWIS_INTENSET_ERROR_Enabled = 0x1
	// Enable
	TWIS_INTENSET_ERROR_Set = 0x1
	// Position of RXSTARTED field.
	TWIS_INTENSET_RXSTARTED_Pos = 0x13
	// Bit mask of RXSTARTED field.
	TWIS_INTENSET_RXSTARTED_Msk = 0x80000
	// Bit RXSTARTED.
	TWIS_INTENSET_RXSTARTED = 0x80000
	// Read: Disabled
	TWIS_INTENSET_RXSTARTED_Disabled = 0x0
	// Read: Enabled
	TWIS_INTENSET_RXSTARTED_Enabled = 0x1
	// Enable
	TWIS_INTENSET_RXSTARTED_Set = 0x1
	// Position of TXSTARTED field.
	TWIS_INTENSET_TXSTARTED_Pos = 0x14
	// Bit mask of TXSTARTED field.
	TWIS_INTENSET_TXSTARTED_Msk = 0x100000
	// Bit TXSTARTED.
	TWIS_INTENSET_TXSTARTED = 0x100000
	// Read: Disabled
	TWIS_INTENSET_TXSTARTED_Disabled = 0x0
	// Read: Enabled
	TWIS_INTENSET_TXSTARTED_Enabled = 0x1
	// Enable
	TWIS_INTENSET_TXSTARTED_Set = 0x1
	// Position of WRITE field.
	TWIS_INTENSET_WRITE_Pos = 0x19
	// Bit mask of WRITE field.
	TWIS_INTENSET_WRITE_Msk = 0x2000000
	// Bit WRITE.
	TWIS_INTENSET_WRITE = 0x2000000
	// Read: Disabled
	TWIS_INTENSET_WRITE_Disabled = 0x0
	// Read: Enabled
	TWIS_INTENSET_WRITE_Enabled = 0x1
	// Enable
	TWIS_INTENSET_WRITE_Set = 0x1
	// Position of READ field.
	TWIS_INTENSET_READ_Pos = 0x1a
	// Bit mask of READ field.
	TWIS_INTENSET_READ_Msk = 0x4000000
	// Bit READ.
	TWIS_INTENSET_READ = 0x4000000
	// Read: Disabled
	TWIS_INTENSET_READ_Disabled = 0x0
	// Read: Enabled
	TWIS_INTENSET_READ_Enabled = 0x1
	// Enable
	TWIS_INTENSET_READ_Set = 0x1

	// INTENCLR: Disable interrupt
	// Position of STOPPED field.
	TWIS_INTENCLR_STOPPED_Pos = 0x1
	// Bit mask of STOPPED field.
	TWIS_INTENCLR_STOPPED_Msk = 0x2
	// Bit STOPPED.
	TWIS_INTENCLR_STOPPED = 0x2
	// Read: Disabled
	TWIS_INTENCLR_STOPPED_Disabled = 0x0
	// Read: Enabled
	TWIS_INTENCLR_STOPPED_Enabled = 0x1
	// Disable
	TWIS_INTENCLR_STOPPED_Clear = 0x1
	// Position of ERROR field.
	TWIS_INTENCLR_ERROR_Pos = 0x9
	// Bit mask of ERROR field.
	TWIS_INTENCLR_ERROR_Msk = 0x200
	// Bit ERROR.
	TWIS_INTENCLR_ERROR = 0x200
	// Read: Disabled
	TWIS_INTENCLR_ERROR_Disabled = 0x0
	// Read: Enabled
	TWIS_INTENCLR_ERROR_Enabled = 0x1
	// Disable
	TWIS_INTENCLR_ERROR_Clear = 0x1
	// Position of RXSTARTED field.
	TWIS_INTENCLR_RXSTARTED_Pos = 0x13
	// Bit mask of RXSTARTED field.
	TWIS_INTENCLR_RXSTARTED_Msk = 0x80000
	// Bit RXSTARTED.
	TWIS_INTENCLR_RXSTARTED = 0x80000
	// Read: Disabled
	TWIS_INTENCLR_RXSTARTED_Disabled = 0x0
	// Read: Enabled
	TWIS_INTENCLR_RXSTARTED_Enabled = 0x1
	// Disable
	TWIS_INTENCLR_RXSTARTED_Clear = 0x1
	// Position of TXSTARTED field.
	TWIS_INTENCLR_TXSTARTED_Pos = 0x14
	// Bit mask of TXSTARTED field.
	TWIS_INTENCLR_TXSTARTED_Msk = 0x100000
	// Bit TXSTARTED.
	TWIS_INTENCLR_TXSTARTED = 0x100000
	// Read: Disabled
	TWIS_INTENCLR_TXSTARTED_Disabled = 0x0
	// Read: Enabled
	TWIS_INTENCLR_TXSTARTED_Enabled = 0x1
	// Disable
	TWIS_INTENCLR_TXSTARTED_Clear = 0x1
	// Position of WRITE field.
	TWIS_INTENCLR_WRITE_Pos = 0x19
	// Bit mask of WRITE field.
	TWIS_INTENCLR_WRITE_Msk = 0x2000000
	// Bit WRITE.
	TWIS_INTENCLR_WRITE = 0x2000000
	// Read: Disabled
	TWIS_INTENCLR_WRITE_Disabled = 0x0
	// Read: Enabled
	TWIS_INTENCLR_WRITE_Enabled = 0x1
	// Disable
	TWIS_INTENCLR_WRITE_Clear = 0x1
	// Position of READ field.
	TWIS_INTENCLR_READ_Pos = 0x1a
	// Bit mask of READ field.
	TWIS_INTENCLR_READ_Msk = 0x4000000
	// Bit READ.
	TWIS_INTENCLR_READ = 0x4000000
	// Read: Disabled
	TWIS_INTENCLR_READ_Disabled = 0x0
	// Read: Enabled
	TWIS_INTENCLR_READ_Enabled = 0x1
	// Disable
	TWIS_INTENCLR_READ_Clear = 0x1

	// ERRORSRC: Error source
	// Position of OVERFLOW field.
	TWIS_ERRORSRC_OVERFLOW_Pos = 0x0
	// Bit mask of OVERFLOW field.
	TWIS_ERRORSRC_OVERFLOW_Msk = 0x1
	// Bit OVERFLOW.
	TWIS_ERRORSRC_OVERFLOW = 0x1
	// Error did not occur
	TWIS_ERRORSRC_OVERFLOW_NotDetected = 0x0
	// Error occurred
	TWIS_ERRORSRC_OVERFLOW_Detected = 0x1
	// Position of DNACK field.
	TWIS_ERRORSRC_DNACK_Pos = 0x2
	// Bit mask of DNACK field.
	TWIS_ERRORSRC_DNACK_Msk = 0x4
	// Bit DNACK.
	TWIS_ERRORSRC_DNACK = 0x4
	// Error did not occur
	TWIS_ERRORSRC_DNACK_NotReceived = 0x0
	// Error occurred
	TWIS_ERRORSRC_DNACK_Received = 0x1
	// Position of OVERREAD field.
	TWIS_ERRORSRC_OVERREAD_Pos = 0x3
	// Bit mask of OVERREAD field.
	TWIS_ERRORSRC_OVERREAD_Msk = 0x8
	// Bit OVERREAD.
	TWIS_ERRORSRC_OVERREAD = 0x8
	// Error did not occur
	TWIS_ERRORSRC_OVERREAD_NotDetected = 0x0
	// Error occurred
	TWIS_ERRORSRC_OVERREAD_Detected = 0x1

	// MATCH: Status register indicating which address had a match
	// Position of MATCH field.
	TWIS_MATCH_MATCH_Pos = 0x0
	// Bit mask of MATCH field.
	TWIS_MATCH_MATCH_Msk = 0x1
	// Bit MATCH.
	TWIS_MATCH_MATCH = 0x1

	// ENABLE: Enable TWIS
	// Position of ENABLE field.
	TWIS_ENABLE_ENABLE_Pos = 0x0
	// Bit mask of ENABLE field.
	TWIS_ENABLE_ENABLE_Msk = 0xf
	// Disable TWIS
	TWIS_ENABLE_ENABLE_Disabled = 0x0
	// Enable TWIS
	TWIS_ENABLE_ENABLE_Enabled = 0x9

	// PSEL.SCL: Pin select for SCL signal
	// Position of PIN field.
	TWIS_PSEL_SCL_PIN_Pos = 0x0
	// Bit mask of PIN field.
	TWIS_PSEL_SCL_PIN_Msk = 0x1f
	// Position of PORT field.
	TWIS_PSEL_SCL_PORT_Pos = 0x5
	// Bit mask of PORT field.
	TWIS_PSEL_SCL_PORT_Msk = 0x20
	// Bit PORT.
	TWIS_PSEL_SCL_PORT = 0x20
	// Position of CONNECT field.
	TWIS_PSEL_SCL_CONNECT_Pos = 0x1f
	// Bit mask of CONNECT field.
	TWIS_PSEL_SCL_CONNECT_Msk = 0x80000000
	// Bit CONNECT.
	TWIS_PSEL_SCL_CONNECT = 0x80000000
	// Disconnect
	TWIS_PSEL_SCL_CONNECT_Disconnected = 0x1
	// Connect
	TWIS_PSEL_SCL_CONNECT_Connected = 0x0

	// PSEL.SDA: Pin select for SDA signal
	// Position of PIN field.
	TWIS_PSEL_SDA_PIN_Pos = 0x0
	// Bit mask of PIN field.
	TWIS_PSEL_SDA_PIN_Msk = 0x1f
	// Position of PORT field.
	TWIS_PSEL_SDA_PORT_Pos = 0x5
	// Bit mask of PORT field.
	TWIS_PSEL_SDA_PORT_Msk = 0x20
	// Bit PORT.
	TWIS_PSEL_SDA_PORT = 0x20
	// Position of CONNECT field.
	TWIS_PSEL_SDA_CONNECT_Pos = 0x1f
	// Bit mask of CONNECT field.
	TWIS_PSEL_SDA_CONNECT_Msk = 0x80000000
	// Bit CONNECT.
	TWIS_PSEL_SDA_CONNECT = 0x80000000
	// Disconnect
	TWIS_PSEL_SDA_CONNECT_Disconnected = 0x1
	// Connect
	TWIS_PSEL_SDA_CONNECT_Connected = 0x0

	// RXD.PTR: RXD Data pointer
	// Position of PTR field.
	TWIS_RXD_PTR_PTR_Pos = 0x0
	// Bit mask of PTR field.
	TWIS_RXD_PTR_PTR_Msk = 0xffffffff

	// RXD.MAXCNT: Maximum number of bytes in RXD buffer
	// Position of MAXCNT field.
	TWIS_RXD_MAXCNT_MAXCNT_Pos = 0x0
	// Bit mask of MAXCNT field.
	TWIS_RXD_MAXCNT_MAXCNT_Msk = 0xffff

	// RXD.AMOUNT: Number of bytes transferred in the last RXD transaction
	// Position of AMOUNT field.
	TWIS_RXD_AMOUNT_AMOUNT_Pos = 0x0
	// Bit mask of AMOUNT field.
	TWIS_RXD_AMOUNT_AMOUNT_Msk = 0xffff

	// RXD.LIST: EasyDMA list type
	// Position of LIST field.
	TWIS_RXD_LIST_LIST_Pos = 0x0
	// Bit mask of LIST field.
	TWIS_RXD_LIST_LIST_Msk = 0x3
	// Disable EasyDMA list
	TWIS_RXD_LIST_LIST_Disabled = 0x0
	// Use array list
	TWIS_RXD_LIST_LIST_ArrayList = 0x1

	// TXD.PTR: TXD Data pointer
	// Position of PTR field.
	TWIS_TXD_PTR_PTR_Pos = 0x0
	// Bit mask of PTR field.
	TWIS_TXD_PTR_PTR_Msk = 0xffffffff

	// TXD.MAXCNT: Maximum number of bytes in TXD buffer
	// Position of MAXCNT field.
	TWIS_TXD_MAXCNT_MAXCNT_Pos = 0x0
	// Bit mask of MAXCNT field.
	TWIS_TXD_MAXCNT_MAXCNT_Msk = 0xffff

	// TXD.AMOUNT: Number of bytes transferred in the last TXD transaction
	// Position of AMOUNT field.
	TWIS_TXD_AMOUNT_AMOUNT_Pos = 0x0
	// Bit mask of AMOUNT field.
	TWIS_TXD_AMOUNT_AMOUNT_Msk = 0xffff

	// TXD.LIST: EasyDMA list type
	// Position of LIST field.
	TWIS_TXD_LIST_LIST_Pos = 0x0
	// Bit mask of LIST field.
	TWIS_TXD_LIST_LIST_Msk = 0x3
	// Disable EasyDMA list
	TWIS_TXD_LIST_LIST_Disabled = 0x0
	// Use array list
	TWIS_TXD_LIST_LIST_ArrayList = 0x1

	// ADDRESS: Description collection: TWI slave address n
	// Position of ADDRESS field.
	TWIS_ADDRESS_ADDRESS_Pos = 0x0
	// Bit mask of ADDRESS field.
	TWIS_ADDRESS_ADDRESS_Msk = 0x7f

	// CONFIG: Configuration register for the address match mechanism
	// Position of ADDRESS0 field.
	TWIS_CONFIG_ADDRESS0_Pos = 0x0
	// Bit mask of ADDRESS0 field.
	TWIS_CONFIG_ADDRESS0_Msk = 0x1
	// Bit ADDRESS0.
	TWIS_CONFIG_ADDRESS0 = 0x1
	// Disabled
	TWIS_CONFIG_ADDRESS0_Disabled = 0x0
	// Enabled
	TWIS_CONFIG_ADDRESS0_Enabled = 0x1
	// Position of ADDRESS1 field.
	TWIS_CONFIG_ADDRESS1_Pos = 0x1
	// Bit mask of ADDRESS1 field.
	TWIS_CONFIG_ADDRESS1_Msk = 0x2
	// Bit ADDRESS1.
	TWIS_CONFIG_ADDRESS1 = 0x2
	// Disabled
	TWIS_CONFIG_ADDRESS1_Disabled = 0x0
	// Enabled
	TWIS_CONFIG_ADDRESS1_Enabled = 0x1

	// ORC: Over-read character. Character sent out in case of an over-read of the transmit buffer.
	// Position of ORC field.
	TWIS_ORC_ORC_Pos = 0x0
	// Bit mask of ORC field.
	TWIS_ORC_ORC_Msk = 0xff
)

// Bitfields for NFCT: NFC-A compatible radio
const (
	// TASKS_ACTIVATE: Activate NFCT peripheral for incoming and outgoing frames, change state to activated
	// Position of TASKS_ACTIVATE field.
	NFCT_TASKS_ACTIVATE_TASKS_ACTIVATE_Pos = 0x0
	// Bit mask of TASKS_ACTIVATE field.
	NFCT_TASKS_ACTIVATE_TASKS_ACTIVATE_Msk = 0x1
	// Bit TASKS_ACTIVATE.
	NFCT_TASKS_ACTIVATE_TASKS_ACTIVATE = 0x1
	// Trigger task
	NFCT_TASKS_ACTIVATE_TASKS_ACTIVATE_Trigger = 0x1

	// TASKS_DISABLE: Disable NFCT peripheral
	// Position of TASKS_DISABLE field.
	NFCT_TASKS_DISABLE_TASKS_DISABLE_Pos = 0x0
	// Bit mask of TASKS_DISABLE field.
	NFCT_TASKS_DISABLE_TASKS_DISABLE_Msk = 0x1
	// Bit TASKS_DISABLE.
	NFCT_TASKS_DISABLE_TASKS_DISABLE = 0x1
	// Trigger task
	NFCT_TASKS_DISABLE_TASKS_DISABLE_Trigger = 0x1

	// TASKS_SENSE: Enable NFC sense field mode, change state to sense mode
	// Position of TASKS_SENSE field.
	NFCT_TASKS_SENSE_TASKS_SENSE_Pos = 0x0
	// Bit mask of TASKS_SENSE field.
	NFCT_TASKS_SENSE_TASKS_SENSE_Msk = 0x1
	// Bit TASKS_SENSE.
	NFCT_TASKS_SENSE_TASKS_SENSE = 0x1
	// Trigger task
	NFCT_TASKS_SENSE_TASKS_SENSE_Trigger = 0x1

	// TASKS_STARTTX: Start transmission of an outgoing frame, change state to transmit
	// Position of TASKS_STARTTX field.
	NFCT_TASKS_STARTTX_TASKS_STARTTX_Pos = 0x0
	// Bit mask of TASKS_STARTTX field.
	NFCT_TASKS_STARTTX_TASKS_STARTTX_Msk = 0x1
	// Bit TASKS_STARTTX.
	NFCT_TASKS_STARTTX_TASKS_STARTTX = 0x1
	// Trigger task
	NFCT_TASKS_STARTTX_TASKS_STARTTX_Trigger = 0x1

	// TASKS_ENABLERXDATA: Initializes the EasyDMA for receive.
	// Position of TASKS_ENABLERXDATA field.
	NFCT_TASKS_ENABLERXDATA_TASKS_ENABLERXDATA_Pos = 0x0
	// Bit mask of TASKS_ENABLERXDATA field.
	NFCT_TASKS_ENABLERXDATA_TASKS_ENABLERXDATA_Msk = 0x1
	// Bit TASKS_ENABLERXDATA.
	NFCT_TASKS_ENABLERXDATA_TASKS_ENABLERXDATA = 0x1
	// Trigger task
	NFCT_TASKS_ENABLERXDATA_TASKS_ENABLERXDATA_Trigger = 0x1

	// TASKS_GOIDLE: Force state machine to IDLE state
	// Position of TASKS_GOIDLE field.
	NFCT_TASKS_GOIDLE_TASKS_GOIDLE_Pos = 0x0
	// Bit mask of TASKS_GOIDLE field.
	NFCT_TASKS_GOIDLE_TASKS_GOIDLE_Msk = 0x1
	// Bit TASKS_GOIDLE.
	NFCT_TASKS_GOIDLE_TASKS_GOIDLE = 0x1
	// Trigger task
	NFCT_TASKS_GOIDLE_TASKS_GOIDLE_Trigger = 0x1

	// TASKS_GOSLEEP: Force state machine to SLEEP_A state
	// Position of TASKS_GOSLEEP field.
	NFCT_TASKS_GOSLEEP_TASKS_GOSLEEP_Pos = 0x0
	// Bit mask of TASKS_GOSLEEP field.
	NFCT_TASKS_GOSLEEP_TASKS_GOSLEEP_Msk = 0x1
	// Bit TASKS_GOSLEEP.
	NFCT_TASKS_GOSLEEP_TASKS_GOSLEEP = 0x1
	// Trigger task
	NFCT_TASKS_GOSLEEP_TASKS_GOSLEEP_Trigger = 0x1

	// EVENTS_READY: The NFCT peripheral is ready to receive and send frames
	// Position of EVENTS_READY field.
	NFCT_EVENTS_READY_EVENTS_READY_Pos = 0x0
	// Bit mask of EVENTS_READY field.
	NFCT_EVENTS_READY_EVENTS_READY_Msk = 0x1
	// Bit EVENTS_READY.
	NFCT_EVENTS_READY_EVENTS_READY = 0x1
	// Event not generated
	NFCT_EVENTS_READY_EVENTS_READY_NotGenerated = 0x0
	// Event generated
	NFCT_EVENTS_READY_EVENTS_READY_Generated = 0x1

	// EVENTS_FIELDDETECTED: Remote NFC field detected
	// Position of EVENTS_FIELDDETECTED field.
	NFCT_EVENTS_FIELDDETECTED_EVENTS_FIELDDETECTED_Pos = 0x0
	// Bit mask of EVENTS_FIELDDETECTED field.
	NFCT_EVENTS_FIELDDETECTED_EVENTS_FIELDDETECTED_Msk = 0x1
	// Bit EVENTS_FIELDDETECTED.
	NFCT_EVENTS_FIELDDETECTED_EVENTS_FIELDDETECTED = 0x1
	// Event not generated
	NFCT_EVENTS_FIELDDETECTED_EVENTS_FIELDDETECTED_NotGenerated = 0x0
	// Event generated
	NFCT_EVENTS_FIELDDETECTED_EVENTS_FIELDDETECTED_Generated = 0x1

	// EVENTS_FIELDLOST: Remote NFC field lost
	// Position of EVENTS_FIELDLOST field.
	NFCT_EVENTS_FIELDLOST_EVENTS_FIELDLOST_Pos = 0x0
	// Bit mask of EVENTS_FIELDLOST field.
	NFCT_EVENTS_FIELDLOST_EVENTS_FIELDLOST_Msk = 0x1
	// Bit EVENTS_FIELDLOST.
	NFCT_EVENTS_FIELDLOST_EVENTS_FIELDLOST = 0x1
	// Event not generated
	NFCT_EVENTS_FIELDLOST_EVENTS_FIELDLOST_NotGenerated = 0x0
	// Event generated
	NFCT_EVENTS_FIELDLOST_EVENTS_FIELDLOST_Generated = 0x1

	// EVENTS_TXFRAMESTART: Marks the start of the first symbol of a transmitted frame
	// Position of EVENTS_TXFRAMESTART field.
	NFCT_EVENTS_TXFRAMESTART_EVENTS_TXFRAMESTART_Pos = 0x0
	// Bit mask of EVENTS_TXFRAMESTART field.
	NFCT_EVENTS_TXFRAMESTART_EVENTS_TXFRAMESTART_Msk = 0x1
	// Bit EVENTS_TXFRAMESTART.
	NFCT_EVENTS_TXFRAMESTART_EVENTS_TXFRAMESTART = 0x1
	// Event not generated
	NFCT_EVENTS_TXFRAMESTART_EVENTS_TXFRAMESTART_NotGenerated = 0x0
	// Event generated
	NFCT_EVENTS_TXFRAMESTART_EVENTS_TXFRAMESTART_Generated = 0x1

	// EVENTS_TXFRAMEEND: Marks the end of the last transmitted on-air symbol of a frame
	// Position of EVENTS_TXFRAMEEND field.
	NFCT_EVENTS_TXFRAMEEND_EVENTS_TXFRAMEEND_Pos = 0x0
	// Bit mask of EVENTS_TXFRAMEEND field.
	NFCT_EVENTS_TXFRAMEEND_EVENTS_TXFRAMEEND_Msk = 0x1
	// Bit EVENTS_TXFRAMEEND.
	NFCT_EVENTS_TXFRAMEEND_EVENTS_TXFRAMEEND = 0x1
	// Event not generated
	NFCT_EVENTS_TXFRAMEEND_EVENTS_TXFRAMEEND_NotGenerated = 0x0
	// Event generated
	NFCT_EVENTS_TXFRAMEEND_EVENTS_TXFRAMEEND_Generated = 0x1

	// EVENTS_RXFRAMESTART: Marks the end of the first symbol of a received frame
	// Position of EVENTS_RXFRAMESTART field.
	NFCT_EVENTS_RXFRAMESTART_EVENTS_RXFRAMESTART_Pos = 0x0
	// Bit mask of EVENTS_RXFRAMESTART field.
	NFCT_EVENTS_RXFRAMESTART_EVENTS_RXFRAMESTART_Msk = 0x1
	// Bit EVENTS_RXFRAMESTART.
	NFCT_EVENTS_RXFRAMESTART_EVENTS_RXFRAMESTART = 0x1
	// Event not generated
	NFCT_EVENTS_RXFRAMESTART_EVENTS_RXFRAMESTART_NotGenerated = 0x0
	// Event generated
	NFCT_EVENTS_RXFRAMESTART_EVENTS_RXFRAMESTART_Generated = 0x1

	// EVENTS_RXFRAMEEND: Received data has been checked (CRC, parity) and transferred to RAM, and EasyDMA has ended accessing the RX buffer
	// Position of EVENTS_RXFRAMEEND field.
	NFCT_EVENTS_RXFRAMEEND_EVENTS_RXFRAMEEND_Pos = 0x0
	// Bit mask of EVENTS_RXFRAMEEND field.
	NFCT_EVENTS_RXFRAMEEND_EVENTS_RXFRAMEEND_Msk = 0x1
	// Bit EVENTS_RXFRAMEEND.
	NFCT_EVENTS_RXFRAMEEND_EVENTS_RXFRAMEEND = 0x1
	// Event not generated
	NFCT_EVENTS_RXFRAMEEND_EVENTS_RXFRAMEEND_NotGenerated = 0x0
	// Event generated
	NFCT_EVENTS_RXFRAMEEND_EVENTS_RXFRAMEEND_Generated = 0x1

	// EVENTS_ERROR: NFC error reported. The ERRORSTATUS register contains details on the source of the error.
	// Position of EVENTS_ERROR field.
	NFCT_EVENTS_ERROR_EVENTS_ERROR_Pos = 0x0
	// Bit mask of EVENTS_ERROR field.
	NFCT_EVENTS_ERROR_EVENTS_ERROR_Msk = 0x1
	// Bit EVENTS_ERROR.
	NFCT_EVENTS_ERROR_EVENTS_ERROR = 0x1
	// Event not generated
	NFCT_EVENTS_ERROR_EVENTS_ERROR_NotGenerated = 0x0
	// Event generated
	NFCT_EVENTS_ERROR_EVENTS_ERROR_Generated = 0x1

	// EVENTS_RXERROR: NFC RX frame error reported. The FRAMESTATUS.RX register contains details on the source of the error.
	// Position of EVENTS_RXERROR field.
	NFCT_EVENTS_RXERROR_EVENTS_RXERROR_Pos = 0x0
	// Bit mask of EVENTS_RXERROR field.
	NFCT_EVENTS_RXERROR_EVENTS_RXERROR_Msk = 0x1
	// Bit EVENTS_RXERROR.
	NFCT_EVENTS_RXERROR_EVENTS_RXERROR = 0x1
	// Event not generated
	NFCT_EVENTS_RXERROR_EVENTS_RXERROR_NotGenerated = 0x0
	// Event generated
	NFCT_EVENTS_RXERROR_EVENTS_RXERROR_Generated = 0x1

	// EVENTS_ENDRX: RX buffer (as defined by PACKETPTR and MAXLEN) in Data RAM full.
	// Position of EVENTS_ENDRX field.
	NFCT_EVENTS_ENDRX_EVENTS_ENDRX_Pos = 0x0
	// Bit mask of EVENTS_ENDRX field.
	NFCT_EVENTS_ENDRX_EVENTS_ENDRX_Msk = 0x1
	// Bit EVENTS_ENDRX.
	NFCT_EVENTS_ENDRX_EVENTS_ENDRX = 0x1
	// Event not generated
	NFCT_EVENTS_ENDRX_EVENTS_ENDRX_NotGenerated = 0x0
	// Event generated
	NFCT_EVENTS_ENDRX_EVENTS_ENDRX_Generated = 0x1

	// EVENTS_ENDTX: Transmission of data in RAM has ended, and EasyDMA has ended accessing the TX buffer
	// Position of EVENTS_ENDTX field.
	NFCT_EVENTS_ENDTX_EVENTS_ENDTX_Pos = 0x0
	// Bit mask of EVENTS_ENDTX field.
	NFCT_EVENTS_ENDTX_EVENTS_ENDTX_Msk = 0x1
	// Bit EVENTS_ENDTX.
	NFCT_EVENTS_ENDTX_EVENTS_ENDTX = 0x1
	// Event not generated
	NFCT_EVENTS_ENDTX_EVENTS_ENDTX_NotGenerated = 0x0
	// Event generated
	NFCT_EVENTS_ENDTX_EVENTS_ENDTX_Generated = 0x1

	// EVENTS_AUTOCOLRESSTARTED: Auto collision resolution process has started
	// Position of EVENTS_AUTOCOLRESSTARTED field.
	NFCT_EVENTS_AUTOCOLRESSTARTED_EVENTS_AUTOCOLRESSTARTED_Pos = 0x0
	// Bit mask of EVENTS_AUTOCOLRESSTARTED field.
	NFCT_EVENTS_AUTOCOLRESSTARTED_EVENTS_AUTOCOLRESSTARTED_Msk = 0x1
	// Bit EVENTS_AUTOCOLRESSTARTED.
	NFCT_EVENTS_AUTOCOLRESSTARTED_EVENTS_AUTOCOLRESSTARTED = 0x1
	// Event not generated
	NFCT_EVENTS_AUTOCOLRESSTARTED_EVENTS_AUTOCOLRESSTARTED_NotGenerated = 0x0
	// Event generated
	NFCT_EVENTS_AUTOCOLRESSTARTED_EVENTS_AUTOCOLRESSTARTED_Generated = 0x1

	// EVENTS_COLLISION: NFC auto collision resolution error reported.
	// Position of EVENTS_COLLISION field.
	NFCT_EVENTS_COLLISION_EVENTS_COLLISION_Pos = 0x0
	// Bit mask of EVENTS_COLLISION field.
	NFCT_EVENTS_COLLISION_EVENTS_COLLISION_Msk = 0x1
	// Bit EVENTS_COLLISION.
	NFCT_EVENTS_COLLISION_EVENTS_COLLISION = 0x1
	// Event not generated
	NFCT_EVENTS_COLLISION_EVENTS_COLLISION_NotGenerated = 0x0
	// Event generated
	NFCT_EVENTS_COLLISION_EVENTS_COLLISION_Generated = 0x1

	// EVENTS_SELECTED: NFC auto collision resolution successfully completed
	// Position of EVENTS_SELECTED field.
	NFCT_EVENTS_SELECTED_EVENTS_SELECTED_Pos = 0x0
	// Bit mask of EVENTS_SELECTED field.
	NFCT_EVENTS_SELECTED_EVENTS_SELECTED_Msk = 0x1
	// Bit EVENTS_SELECTED.
	NFCT_EVENTS_SELECTED_EVENTS_SELECTED = 0x1
	// Event not generated
	NFCT_EVENTS_SELECTED_EVENTS_SELECTED_NotGenerated = 0x0
	// Event generated
	NFCT_EVENTS_SELECTED_EVENTS_SELECTED_Generated = 0x1

	// EVENTS_STARTED: EasyDMA is ready to receive or send frames.
	// Position of EVENTS_STARTED field.
	NFCT_EVENTS_STARTED_EVENTS_STARTED_Pos = 0x0
	// Bit mask of EVENTS_STARTED field.
	NFCT_EVENTS_STARTED_EVENTS_STARTED_Msk = 0x1
	// Bit EVENTS_STARTED.
	NFCT_EVENTS_STARTED_EVENTS_STARTED = 0x1
	// Event not generated
	NFCT_EVENTS_STARTED_EVENTS_STARTED_NotGenerated = 0x0
	// Event generated
	NFCT_EVENTS_STARTED_EVENTS_STARTED_Generated = 0x1

	// SHORTS: Shortcuts between local events and tasks
	// Position of FIELDDETECTED_ACTIVATE field.
	NFCT_SHORTS_FIELDDETECTED_ACTIVATE_Pos = 0x0
	// Bit mask of FIELDDETECTED_ACTIVATE field.
	NFCT_SHORTS_FIELDDETECTED_ACTIVATE_Msk = 0x1
	// Bit FIELDDETECTED_ACTIVATE.
	NFCT_SHORTS_FIELDDETECTED_ACTIVATE = 0x1
	// Disable shortcut
	NFCT_SHORTS_FIELDDETECTED_ACTIVATE_Disabled = 0x0
	// Enable shortcut
	NFCT_SHORTS_FIELDDETECTED_ACTIVATE_Enabled = 0x1
	// Position of FIELDLOST_SENSE field.
	NFCT_SHORTS_FIELDLOST_SENSE_Pos = 0x1
	// Bit mask of FIELDLOST_SENSE field.
	NFCT_SHORTS_FIELDLOST_SENSE_Msk = 0x2
	// Bit FIELDLOST_SENSE.
	NFCT_SHORTS_FIELDLOST_SENSE = 0x2
	// Disable shortcut
	NFCT_SHORTS_FIELDLOST_SENSE_Disabled = 0x0
	// Enable shortcut
	NFCT_SHORTS_FIELDLOST_SENSE_Enabled = 0x1
	// Position of TXFRAMEEND_ENABLERXDATA field.
	NFCT_SHORTS_TXFRAMEEND_ENABLERXDATA_Pos = 0x5
	// Bit mask of TXFRAMEEND_ENABLERXDATA field.
	NFCT_SHORTS_TXFRAMEEND_ENABLERXDATA_Msk = 0x20
	// Bit TXFRAMEEND_ENABLERXDATA.
	NFCT_SHORTS_TXFRAMEEND_ENABLERXDATA = 0x20
	// Disable shortcut
	NFCT_SHORTS_TXFRAMEEND_ENABLERXDATA_Disabled = 0x0
	// Enable shortcut
	NFCT_SHORTS_TXFRAMEEND_ENABLERXDATA_Enabled = 0x1

	// INTEN: Enable or disable interrupt
	// Position of READY field.
	NFCT_INTEN_READY_Pos = 0x0
	// Bit mask of READY field.
	NFCT_INTEN_READY_Msk = 0x1
	// Bit READY.
	NFCT_INTEN_READY = 0x1
	// Disable
	NFCT_INTEN_READY_Disabled = 0x0
	// Enable
	NFCT_INTEN_READY_Enabled = 0x1
	// Position of FIELDDETECTED field.
	NFCT_INTEN_FIELDDETECTED_Pos = 0x1
	// Bit mask of FIELDDETECTED field.
	NFCT_INTEN_FIELDDETECTED_Msk = 0x2
	// Bit FIELDDETECTED.
	NFCT_INTEN_FIELDDETECTED = 0x2
	// Disable
	NFCT_INTEN_FIELDDETECTED_Disabled = 0x0
	// Enable
	NFCT_INTEN_FIELDDETECTED_Enabled = 0x1
	// Position of FIELDLOST field.
	NFCT_INTEN_FIELDLOST_Pos = 0x2
	// Bit mask of FIELDLOST field.
	NFCT_INTEN_FIELDLOST_Msk = 0x4
	// Bit FIELDLOST.
	NFCT_INTEN_FIELDLOST = 0x4
	// Disable
	NFCT_INTEN_FIELDLOST_Disabled = 0x0
	// Enable
	NFCT_INTEN_FIELDLOST_Enabled = 0x1
	// Position of TXFRAMESTART field.
	NFCT_INTEN_TXFRAMESTART_Pos = 0x3
	// Bit mask of TXFRAMESTART field.
	NFCT_INTEN_TXFRAMESTART_Msk = 0x8
	// Bit TXFRAMESTART.
	NFCT_INTEN_TXFRAMESTART = 0x8
	// Disable
	NFCT_INTEN_TXFRAMESTART_Disabled = 0x0
	// Enable
	NFCT_INTEN_TXFRAMESTART_Enabled = 0x1
	// Position of TXFRAMEEND field.
	NFCT_INTEN_TXFRAMEEND_Pos = 0x4
	// Bit mask of TXFRAMEEND field.
	NFCT_INTEN_TXFRAMEEND_Msk = 0x10
	// Bit TXFRAMEEND.
	NFCT_INTEN_TXFRAMEEND = 0x10
	// Disable
	NFCT_INTEN_TXFRAMEEND_Disabled = 0x0
	// Enable
	NFCT_INTEN_TXFRAMEEND_Enabled = 0x1
	// Position of RXFRAMESTART field.
	NFCT_INTEN_RXFRAMESTART_Pos = 0x5
	// Bit mask of RXFRAMESTART field.
	NFCT_INTEN_RXFRAMESTART_Msk = 0x20
	// Bit RXFRAMESTART.
	NFCT_INTEN_RXFRAMESTART = 0x20
	// Disable
	NFCT_INTEN_RXFRAMESTART_Disabled = 0x0
	// Enable
	NFCT_INTEN_RXFRAMESTART_Enabled = 0x1
	// Position of RXFRAMEEND field.
	NFCT_INTEN_RXFRAMEEND_Pos = 0x6
	// Bit mask of RXFRAMEEND field.
	NFCT_INTEN_RXFRAMEEND_Msk = 0x40
	// Bit RXFRAMEEND.
	NFCT_INTEN_RXFRAMEEND = 0x40
	// Disable
	NFCT_INTEN_RXFRAMEEND_Disabled = 0x0
	// Enable
	NFCT_INTEN_RXFRAMEEND_Enabled = 0x1
	// Position of ERROR field.
	NFCT_INTEN_ERROR_Pos = 0x7
	// Bit mask of ERROR field.
	NFCT_INTEN_ERROR_Msk = 0x80
	// Bit ERROR.
	NFCT_INTEN_ERROR = 0x80
	// Disable
	NFCT_INTEN_ERROR_Disabled = 0x0
	// Enable
	NFCT_INTEN_ERROR_Enabled = 0x1
	// Position of RXERROR field.
	NFCT_INTEN_RXERROR_Pos = 0xa
	// Bit mask of RXERROR field.
	NFCT_INTEN_RXERROR_Msk = 0x400
	// Bit RXERROR.
	NFCT_INTEN_RXERROR = 0x400
	// Disable
	NFCT_INTEN_RXERROR_Disabled = 0x0
	// Enable
	NFCT_INTEN_RXERROR_Enabled = 0x1
	// Position of ENDRX field.
	NFCT_INTEN_ENDRX_Pos = 0xb
	// Bit mask of ENDRX field.
	NFCT_INTEN_ENDRX_Msk = 0x800
	// Bit ENDRX.
	NFCT_INTEN_ENDRX = 0x800
	// Disable
	NFCT_INTEN_ENDRX_Disabled = 0x0
	// Enable
	NFCT_INTEN_ENDRX_Enabled = 0x1
	// Position of ENDTX field.
	NFCT_INTEN_ENDTX_Pos = 0xc
	// Bit mask of ENDTX field.
	NFCT_INTEN_ENDTX_Msk = 0x1000
	// Bit ENDTX.
	NFCT_INTEN_ENDTX = 0x1000
	// Disable
	NFCT_INTEN_ENDTX_Disabled = 0x0
	// Enable
	NFCT_INTEN_ENDTX_Enabled = 0x1
	// Position of AUTOCOLRESSTARTED field.
	NFCT_INTEN_AUTOCOLRESSTARTED_Pos = 0xe
	// Bit mask of AUTOCOLRESSTARTED field.
	NFCT_INTEN_AUTOCOLRESSTARTED_Msk = 0x4000
	// Bit AUTOCOLRESSTARTED.
	NFCT_INTEN_AUTOCOLRESSTARTED = 0x4000
	// Disable
	NFCT_INTEN_AUTOCOLRESSTARTED_Disabled = 0x0
	// Enable
	NFCT_INTEN_AUTOCOLRESSTARTED_Enabled = 0x1
	// Position of COLLISION field.
	NFCT_INTEN_COLLISION_Pos = 0x12
	// Bit mask of COLLISION field.
	NFCT_INTEN_COLLISION_Msk = 0x40000
	// Bit COLLISION.
	NFCT_INTEN_COLLISION = 0x40000
	// Disable
	NFCT_INTEN_COLLISION_Disabled = 0x0
	// Enable
	NFCT_INTEN_COLLISION_Enabled = 0x1
	// Position of SELECTED field.
	NFCT_INTEN_SELECTED_Pos = 0x13
	// Bit mask of SELECTED field.
	NFCT_INTEN_SELECTED_Msk = 0x80000
	// Bit SELECTED.
	NFCT_INTEN_SELECTED = 0x80000
	// Disable
	NFCT_INTEN_SELECTED_Disabled = 0x0
	// Enable
	NFCT_INTEN_SELECTED_Enabled = 0x1
	// Position of STARTED field.
	NFCT_INTEN_STARTED_Pos = 0x14
	// Bit mask of STARTED field.
	NFCT_INTEN_STARTED_Msk = 0x100000
	// Bit STARTED.
	NFCT_INTEN_STARTED = 0x100000
	// Disable
	NFCT_INTEN_STARTED_Disabled = 0x0
	// Enable
	NFCT_INTEN_STARTED_Enabled = 0x1

	// INTENSET: Enable interrupt
	// Position of READY field.
	NFCT_INTENSET_READY_Pos = 0x0
	// Bit mask of READY field.
	NFCT_INTENSET_READY_Msk = 0x1
	// Bit READY.
	NFCT_INTENSET_READY = 0x1
	// Read: Disabled
	NFCT_INTENSET_READY_Disabled = 0x0
	// Read: Enabled
	NFCT_INTENSET_READY_Enabled = 0x1
	// Enable
	NFCT_INTENSET_READY_Set = 0x1
	// Position of FIELDDETECTED field.
	NFCT_INTENSET_FIELDDETECTED_Pos = 0x1
	// Bit mask of FIELDDETECTED field.
	NFCT_INTENSET_FIELDDETECTED_Msk = 0x2
	// Bit FIELDDETECTED.
	NFCT_INTENSET_FIELDDETECTED = 0x2
	// Read: Disabled
	NFCT_INTENSET_FIELDDETECTED_Disabled = 0x0
	// Read: Enabled
	NFCT_INTENSET_FIELDDETECTED_Enabled = 0x1
	// Enable
	NFCT_INTENSET_FIELDDETECTED_Set = 0x1
	// Position of FIELDLOST field.
	NFCT_INTENSET_FIELDLOST_Pos = 0x2
	// Bit mask of FIELDLOST field.
	NFCT_INTENSET_FIELDLOST_Msk = 0x4
	// Bit FIELDLOST.
	NFCT_INTENSET_FIELDLOST = 0x4
	// Read: Disabled
	NFCT_INTENSET_FIELDLOST_Disabled = 0x0
	// Read: Enabled
	NFCT_INTENSET_FIELDLOST_Enabled = 0x1
	// Enable
	NFCT_INTENSET_FIELDLOST_Set = 0x1
	// Position of TXFRAMESTART field.
	NFCT_INTENSET_TXFRAMESTART_Pos = 0x3
	// Bit mask of TXFRAMESTART field.
	NFCT_INTENSET_TXFRAMESTART_Msk = 0x8
	// Bit TXFRAMESTART.
	NFCT_INTENSET_TXFRAMESTART = 0x8
	// Read: Disabled
	NFCT_INTENSET_TXFRAMESTART_Disabled = 0x0
	// Read: Enabled
	NFCT_INTENSET_TXFRAMESTART_Enabled = 0x1
	// Enable
	NFCT_INTENSET_TXFRAMESTART_Set = 0x1
	// Position of TXFRAMEEND field.
	NFCT_INTENSET_TXFRAMEEND_Pos = 0x4
	// Bit mask of TXFRAMEEND field.
	NFCT_INTENSET_TXFRAMEEND_Msk = 0x10
	// Bit TXFRAMEEND.
	NFCT_INTENSET_TXFRAMEEND = 0x10
	// Read: Disabled
	NFCT_INTENSET_TXFRAMEEND_Disabled = 0x0
	// Read: Enabled
	NFCT_INTENSET_TXFRAMEEND_Enabled = 0x1
	// Enable
	NFCT_INTENSET_TXFRAMEEND_Set = 0x1
	// Position of RXFRAMESTART field.
	NFCT_INTENSET_RXFRAMESTART_Pos = 0x5
	// Bit mask of RXFRAMESTART field.
	NFCT_INTENSET_RXFRAMESTART_Msk = 0x20
	// Bit RXFRAMESTART.
	NFCT_INTENSET_RXFRAMESTART = 0x20
	// Read: Disabled
	NFCT_INTENSET_RXFRAMESTART_Disabled = 0x0
	// Read: Enabled
	NFCT_INTENSET_RXFRAMESTART_Enabled = 0x1
	// Enable
	NFCT_INTENSET_RXFRAMESTART_Set = 0x1
	// Position of RXFRAMEEND field.
	NFCT_INTENSET_RXFRAMEEND_Pos = 0x6
	// Bit mask of RXFRAMEEND field.
	NFCT_INTENSET_RXFRAMEEND_Msk = 0x40
	// Bit RXFRAMEEND.
	NFCT_INTENSET_RXFRAMEEND = 0x40
	// Read: Disabled
	NFCT_INTENSET_RXFRAMEEND_Disabled = 0x0
	// Read: Enabled
	NFCT_INTENSET_RXFRAMEEND_Enabled = 0x1
	// Enable
	NFCT_INTENSET_RXFRAMEEND_Set = 0x1
	// Position of ERROR field.
	NFCT_INTENSET_ERROR_Pos = 0x7
	// Bit mask of ERROR field.
	NFCT_INTENSET_ERROR_Msk = 0x80
	// Bit ERROR.
	NFCT_INTENSET_ERROR = 0x80
	// Read: Disabled
	NFCT_INTENSET_ERROR_Disabled = 0x0
	// Read: Enabled
	NFCT_INTENSET_ERROR_Enabled = 0x1
	// Enable
	NFCT_INTENSET_ERROR_Set = 0x1
	// Position of RXERROR field.
	NFCT_INTENSET_RXERROR_Pos = 0xa
	// Bit mask of RXERROR field.
	NFCT_INTENSET_RXERROR_Msk = 0x400
	// Bit RXERROR.
	NFCT_INTENSET_RXERROR = 0x400
	// Read: Disabled
	NFCT_INTENSET_RXERROR_Disabled = 0x0
	// Read: Enabled
	NFCT_INTENSET_RXERROR_Enabled = 0x1
	// Enable
	NFCT_INTENSET_RXERROR_Set = 0x1
	// Position of ENDRX field.
	NFCT_INTENSET_ENDRX_Pos = 0xb
	// Bit mask of ENDRX field.
	NFCT_INTENSET_ENDRX_Msk = 0x800
	// Bit ENDRX.
	NFCT_INTENSET_ENDRX = 0x800
	// Read: Disabled
	NFCT_INTENSET_ENDRX_Disabled = 0x0
	// Read: Enabled
	NFCT_INTENSET_ENDRX_Enabled = 0x1
	// Enable
	NFCT_INTENSET_ENDRX_Set = 0x1
	// Position of ENDTX field.
	NFCT_INTENSET_ENDTX_Pos = 0xc
	// Bit mask of ENDTX field.
	NFCT_INTENSET_ENDTX_Msk = 0x1000
	// Bit ENDTX.
	NFCT_INTENSET_ENDTX = 0x1000
	// Read: Disabled
	NFCT_INTENSET_ENDTX_Disabled = 0x0
	// Read: Enabled
	NFCT_INTENSET_ENDTX_Enabled = 0x1
	// Enable
	NFCT_INTENSET_ENDTX_Set = 0x1
	// Position of AUTOCOLRESSTARTED field.
	NFCT_INTENSET_AUTOCOLRESSTARTED_Pos = 0xe
	// Bit mask of AUTOCOLRESSTARTED field.
	NFCT_INTENSET_AUTOCOLRESSTARTED_Msk = 0x4000
	// Bit AUTOCOLRESSTARTED.
	NFCT_INTENSET_AUTOCOLRESSTARTED = 0x4000
	// Read: Disabled
	NFCT_INTENSET_AUTOCOLRESSTARTED_Disabled = 0x0
	// Read: Enabled
	NFCT_INTENSET_AUTOCOLRESSTARTED_Enabled = 0x1
	// Enable
	NFCT_INTENSET_AUTOCOLRESSTARTED_Set = 0x1
	// Position of COLLISION field.
	NFCT_INTENSET_COLLISION_Pos = 0x12
	// Bit mask of COLLISION field.
	NFCT_INTENSET_COLLISION_Msk = 0x40000
	// Bit COLLISION.
	NFCT_INTENSET_COLLISION = 0x40000
	// Read: Disabled
	NFCT_INTENSET_COLLISION_Disabled = 0x0
	// Read: Enabled
	NFCT_INTENSET_COLLISION_Enabled = 0x1
	// Enable
	NFCT_INTENSET_COLLISION_Set = 0x1
	// Position of SELECTED field.
	NFCT_INTENSET_SELECTED_Pos = 0x13
	// Bit mask of SELECTED field.
	NFCT_INTENSET_SELECTED_Msk = 0x80000
	// Bit SELECTED.
	NFCT_INTENSET_SELECTED = 0x80000
	// Read: Disabled
	NFCT_INTENSET_SELECTED_Disabled = 0x0
	// Read: Enabled
	NFCT_INTENSET_SELECTED_Enabled = 0x1
	// Enable
	NFCT_INTENSET_SELECTED_Set = 0x1
	// Position of STARTED field.
	NFCT_INTENSET_STARTED_Pos = 0x14
	// Bit mask of STARTED field.
	NFCT_INTENSET_STARTED_Msk = 0x100000
	// Bit STARTED.
	NFCT_INTENSET_STARTED = 0x100000
	// Read: Disabled
	NFCT_INTENSET_STARTED_Disabled = 0x0
	// Read: Enabled
	NFCT_INTENSET_STARTED_Enabled = 0x1
	// Enable
	NFCT_INTENSET_STARTED_Set = 0x1

	// INTENCLR: Disable interrupt
	// Position of READY field.
	NFCT_INTENCLR_READY_Pos = 0x0
	// Bit mask of READY field.
	NFCT_INTENCLR_READY_Msk = 0x1
	// Bit READY.
	NFCT_INTENCLR_READY = 0x1
	// Read: Disabled
	NFCT_INTENCLR_READY_Disabled = 0x0
	// Read: Enabled
	NFCT_INTENCLR_READY_Enabled = 0x1
	// Disable
	NFCT_INTENCLR_READY_Clear = 0x1
	// Position of FIELDDETECTED field.
	NFCT_INTENCLR_FIELDDETECTED_Pos = 0x1
	// Bit mask of FIELDDETECTED field.
	NFCT_INTENCLR_FIELDDETECTED_Msk = 0x2
	// Bit FIELDDETECTED.
	NFCT_INTENCLR_FIELDDETECTED = 0x2
	// Read: Disabled
	NFCT_INTENCLR_FIELDDETECTED_Disabled = 0x0
	// Read: Enabled
	NFCT_INTENCLR_FIELDDETECTED_Enabled = 0x1
	// Disable
	NFCT_INTENCLR_FIELDDETECTED_Clear = 0x1
	// Position of FIELDLOST field.
	NFCT_INTENCLR_FIELDLOST_Pos = 0x2
	// Bit mask of FIELDLOST field.
	NFCT_INTENCLR_FIELDLOST_Msk = 0x4
	// Bit FIELDLOST.
	NFCT_INTENCLR_FIELDLOST = 0x4
	// Read: Disabled
	NFCT_INTENCLR_FIELDLOST_Disabled = 0x0
	// Read: Enabled
	NFCT_INTENCLR_FIELDLOST_Enabled = 0x1
	// Disable
	NFCT_INTENCLR_FIELDLOST_Clear = 0x1
	// Position of TXFRAMESTART field.
	NFCT_INTENCLR_TXFRAMESTART_Pos = 0x3
	// Bit mask of TXFRAMESTART field.
	NFCT_INTENCLR_TXFRAMESTART_Msk = 0x8
	// Bit TXFRAMESTART.
	NFCT_INTENCLR_TXFRAMESTART = 0x8
	// Read: Disabled
	NFCT_INTENCLR_TXFRAMESTART_Disabled = 0x0
	// Read: Enabled
	NFCT_INTENCLR_TXFRAMESTART_Enabled = 0x1
	// Disable
	NFCT_INTENCLR_TXFRAMESTART_Clear = 0x1
	// Position of TXFRAMEEND field.
	NFCT_INTENCLR_TXFRAMEEND_Pos = 0x4
	// Bit mask of TXFRAMEEND field.
	NFCT_INTENCLR_TXFRAMEEND_Msk = 0x10
	// Bit TXFRAMEEND.
	NFCT_INTENCLR_TXFRAMEEND = 0x10
	// Read: Disabled
	NFCT_INTENCLR_TXFRAMEEND_Disabled = 0x0
	// Read: Enabled
	NFCT_INTENCLR_TXFRAMEEND_Enabled = 0x1
	// Disable
	NFCT_INTENCLR_TXFRAMEEND_Clear = 0x1
	// Position of RXFRAMESTART field.
	NFCT_INTENCLR_RXFRAMESTART_Pos = 0x5
	// Bit mask of RXFRAMESTART field.
	NFCT_INTENCLR_RXFRAMESTART_Msk = 0x20
	// Bit RXFRAMESTART.
	NFCT_INTENCLR_RXFRAMESTART = 0x20
	// Read: Disabled
	NFCT_INTENCLR_RXFRAMESTART_Disabled = 0x0
	// Read: Enabled
	NFCT_INTENCLR_RXFRAMESTART_Enabled = 0x1
	// Disable
	NFCT_INTENCLR_RXFRAMESTART_Clear = 0x1
	// Position of RXFRAMEEND field.
	NFCT_INTENCLR_RXFRAMEEND_Pos = 0x6
	// Bit mask of RXFRAMEEND field.
	NFCT_INTENCLR_RXFRAMEEND_Msk = 0x40
	// Bit RXFRAMEEND.
	NFCT_INTENCLR_RXFRAMEEND = 0x40
	// Read: Disabled
	NFCT_INTENCLR_RXFRAMEEND_Disabled = 0x0
	// Read: Enabled
	NFCT_INTENCLR_RXFRAMEEND_Enabled = 0x1
	// Disable
	NFCT_INTENCLR_RXFRAMEEND_Clear = 0x1
	// Position of ERROR field.
	NFCT_INTENCLR_ERROR_Pos = 0x7
	// Bit mask of ERROR field.
	NFCT_INTENCLR_ERROR_Msk = 0x80
	// Bit ERROR.
	NFCT_INTENCLR_ERROR = 0x80
	// Read: Disabled
	NFCT_INTENCLR_ERROR_Disabled = 0x0
	// Read: Enabled
	NFCT_INTENCLR_ERROR_Enabled = 0x1
	// Disable
	NFCT_INTENCLR_ERROR_Clear = 0x1
	// Position of RXERROR field.
	NFCT_INTENCLR_RXERROR_Pos = 0xa
	// Bit mask of RXERROR field.
	NFCT_INTENCLR_RXERROR_Msk = 0x400
	// Bit RXERROR.
	NFCT_INTENCLR_RXERROR = 0x400
	// Read: Disabled
	NFCT_INTENCLR_RXERROR_Disabled = 0x0
	// Read: Enabled
	NFCT_INTENCLR_RXERROR_Enabled = 0x1
	// Disable
	NFCT_INTENCLR_RXERROR_Clear = 0x1
	// Position of ENDRX field.
	NFCT_INTENCLR_ENDRX_Pos = 0xb
	// Bit mask of ENDRX field.
	NFCT_INTENCLR_ENDRX_Msk = 0x800
	// Bit ENDRX.
	NFCT_INTENCLR_ENDRX = 0x800
	// Read: Disabled
	NFCT_INTENCLR_ENDRX_Disabled = 0x0
	// Read: Enabled
	NFCT_INTENCLR_ENDRX_Enabled = 0x1
	// Disable
	NFCT_INTENCLR_ENDRX_Clear = 0x1
	// Position of ENDTX field.
	NFCT_INTENCLR_ENDTX_Pos = 0xc
	// Bit mask of ENDTX field.
	NFCT_INTENCLR_ENDTX_Msk = 0x1000
	// Bit ENDTX.
	NFCT_INTENCLR_ENDTX = 0x1000
	// Read: Disabled
	NFCT_INTENCLR_ENDTX_Disabled = 0x0
	// Read: Enabled
	NFCT_INTENCLR_ENDTX_Enabled = 0x1
	// Disable
	NFCT_INTENCLR_ENDTX_Clear = 0x1
	// Position of AUTOCOLRESSTARTED field.
	NFCT_INTENCLR_AUTOCOLRESSTARTED_Pos = 0xe
	// Bit mask of AUTOCOLRESSTARTED field.
	NFCT_INTENCLR_AUTOCOLRESSTARTED_Msk = 0x4000
	// Bit AUTOCOLRESSTARTED.
	NFCT_INTENCLR_AUTOCOLRESSTARTED = 0x4000
	// Read: Disabled
	NFCT_INTENCLR_AUTOCOLRESSTARTED_Disabled = 0x0
	// Read: Enabled
	NFCT_INTENCLR_AUTOCOLRESSTARTED_Enabled = 0x1
	// Disable
	NFCT_INTENCLR_AUTOCOLRESSTARTED_Clear = 0x1
	// Position of COLLISION field.
	NFCT_INTENCLR_COLLISION_Pos = 0x12
	// Bit mask of COLLISION field.
	NFCT_INTENCLR_COLLISION_Msk = 0x40000
	// Bit COLLISION.
	NFCT_INTENCLR_COLLISION = 0x40000
	// Read: Disabled
	NFCT_INTENCLR_COLLISION_Disabled = 0x0
	// Read: Enabled
	NFCT_INTENCLR_COLLISION_Enabled = 0x1
	// Disable
	NFCT_INTENCLR_COLLISION_Clear = 0x1
	// Position of SELECTED field.
	NFCT_INTENCLR_SELECTED_Pos = 0x13
	// Bit mask of SELECTED field.
	NFCT_INTENCLR_SELECTED_Msk = 0x80000
	// Bit SELECTED.
	NFCT_INTENCLR_SELECTED = 0x80000
	// Read: Disabled
	NFCT_INTENCLR_SELECTED_Disabled = 0x0
	// Read: Enabled
	NFCT_INTENCLR_SELECTED_Enabled = 0x1
	// Disable
	NFCT_INTENCLR_SELECTED_Clear = 0x1
	// Position of STARTED field.
	NFCT_INTENCLR_STARTED_Pos = 0x14
	// Bit mask of STARTED field.
	NFCT_INTENCLR_STARTED_Msk = 0x100000
	// Bit STARTED.
	NFCT_INTENCLR_STARTED = 0x100000
	// Read: Disabled
	NFCT_INTENCLR_STARTED_Disabled = 0x0
	// Read: Enabled
	NFCT_INTENCLR_STARTED_Enabled = 0x1
	// Disable
	NFCT_INTENCLR_STARTED_Clear = 0x1

	// ERRORSTATUS: NFC Error Status register
	// Position of FRAMEDELAYTIMEOUT field.
	NFCT_ERRORSTATUS_FRAMEDELAYTIMEOUT_Pos = 0x0
	// Bit mask of FRAMEDELAYTIMEOUT field.
	NFCT_ERRORSTATUS_FRAMEDELAYTIMEOUT_Msk = 0x1
	// Bit FRAMEDELAYTIMEOUT.
	NFCT_ERRORSTATUS_FRAMEDELAYTIMEOUT = 0x1

	// FRAMESTATUS.RX: Result of last incoming frame
	// Position of CRCERROR field.
	NFCT_FRAMESTATUS_RX_CRCERROR_Pos = 0x0
	// Bit mask of CRCERROR field.
	NFCT_FRAMESTATUS_RX_CRCERROR_Msk = 0x1
	// Bit CRCERROR.
	NFCT_FRAMESTATUS_RX_CRCERROR = 0x1
	// Valid CRC detected
	NFCT_FRAMESTATUS_RX_CRCERROR_CRCCorrect = 0x0
	// CRC received does not match local check
	NFCT_FRAMESTATUS_RX_CRCERROR_CRCError = 0x1
	// Position of PARITYSTATUS field.
	NFCT_FRAMESTATUS_RX_PARITYSTATUS_Pos = 0x2
	// Bit mask of PARITYSTATUS field.
	NFCT_FRAMESTATUS_RX_PARITYSTATUS_Msk = 0x4
	// Bit PARITYSTATUS.
	NFCT_FRAMESTATUS_RX_PARITYSTATUS = 0x4
	// Frame received with parity OK
	NFCT_FRAMESTATUS_RX_PARITYSTATUS_ParityOK = 0x0
	// Frame received with parity error
	NFCT_FRAMESTATUS_RX_PARITYSTATUS_ParityError = 0x1
	// Position of OVERRUN field.
	NFCT_FRAMESTATUS_RX_OVERRUN_Pos = 0x3
	// Bit mask of OVERRUN field.
	NFCT_FRAMESTATUS_RX_OVERRUN_Msk = 0x8
	// Bit OVERRUN.
	NFCT_FRAMESTATUS_RX_OVERRUN = 0x8
	// No overrun detected
	NFCT_FRAMESTATUS_RX_OVERRUN_NoOverrun = 0x0
	// Overrun error
	NFCT_FRAMESTATUS_RX_OVERRUN_Overrun = 0x1

	// NFCTAGSTATE: NfcTag state register
	// Position of NFCTAGSTATE field.
	NFCT_NFCTAGSTATE_NFCTAGSTATE_Pos = 0x0
	// Bit mask of NFCTAGSTATE field.
	NFCT_NFCTAGSTATE_NFCTAGSTATE_Msk = 0x7
	// Disabled or sense
	NFCT_NFCTAGSTATE_NFCTAGSTATE_Disabled = 0x0
	// RampUp
	NFCT_NFCTAGSTATE_NFCTAGSTATE_RampUp = 0x2
	// Idle
	NFCT_NFCTAGSTATE_NFCTAGSTATE_Idle = 0x3
	// Receive
	NFCT_NFCTAGSTATE_NFCTAGSTATE_Receive = 0x4
	// FrameDelay
	NFCT_NFCTAGSTATE_NFCTAGSTATE_FrameDelay = 0x5
	// Transmit
	NFCT_NFCTAGSTATE_NFCTAGSTATE_Transmit = 0x6

	// SLEEPSTATE: Sleep state during automatic collision resolution
	// Position of SLEEPSTATE field.
	NFCT_SLEEPSTATE_SLEEPSTATE_Pos = 0x0
	// Bit mask of SLEEPSTATE field.
	NFCT_SLEEPSTATE_SLEEPSTATE_Msk = 0x1
	// Bit SLEEPSTATE.
	NFCT_SLEEPSTATE_SLEEPSTATE = 0x1
	// State is IDLE.
	NFCT_SLEEPSTATE_SLEEPSTATE_Idle = 0x0
	// State is SLEEP_A.
	NFCT_SLEEPSTATE_SLEEPSTATE_SleepA = 0x1

	// FIELDPRESENT: Indicates the presence or not of a valid field
	// Position of FIELDPRESENT field.
	NFCT_FIELDPRESENT_FIELDPRESENT_Pos = 0x0
	// Bit mask of FIELDPRESENT field.
	NFCT_FIELDPRESENT_FIELDPRESENT_Msk = 0x1
	// Bit FIELDPRESENT.
	NFCT_FIELDPRESENT_FIELDPRESENT = 0x1
	// No valid field detected
	NFCT_FIELDPRESENT_FIELDPRESENT_NoField = 0x0
	// Valid field detected
	NFCT_FIELDPRESENT_FIELDPRESENT_FieldPresent = 0x1
	// Position of LOCKDETECT field.
	NFCT_FIELDPRESENT_LOCKDETECT_Pos = 0x1
	// Bit mask of LOCKDETECT field.
	NFCT_FIELDPRESENT_LOCKDETECT_Msk = 0x2
	// Bit LOCKDETECT.
	NFCT_FIELDPRESENT_LOCKDETECT = 0x2
	// Not locked to field
	NFCT_FIELDPRESENT_LOCKDETECT_NotLocked = 0x0
	// Locked to field
	NFCT_FIELDPRESENT_LOCKDETECT_Locked = 0x1

	// FRAMEDELAYMIN: Minimum frame delay
	// Position of FRAMEDELAYMIN field.
	NFCT_FRAMEDELAYMIN_FRAMEDELAYMIN_Pos = 0x0
	// Bit mask of FRAMEDELAYMIN field.
	NFCT_FRAMEDELAYMIN_FRAMEDELAYMIN_Msk = 0xffff

	// FRAMEDELAYMAX: Maximum frame delay
	// Position of FRAMEDELAYMAX field.
	NFCT_FRAMEDELAYMAX_FRAMEDELAYMAX_Pos = 0x0
	// Bit mask of FRAMEDELAYMAX field.
	NFCT_FRAMEDELAYMAX_FRAMEDELAYMAX_Msk = 0xfffff

	// FRAMEDELAYMODE: Configuration register for the Frame Delay Timer
	// Position of FRAMEDELAYMODE field.
	NFCT_FRAMEDELAYMODE_FRAMEDELAYMODE_Pos = 0x0
	// Bit mask of FRAMEDELAYMODE field.
	NFCT_FRAMEDELAYMODE_FRAMEDELAYMODE_Msk = 0x3
	// Transmission is independent of frame timer and will start when the STARTTX task is triggered. No timeout.
	NFCT_FRAMEDELAYMODE_FRAMEDELAYMODE_FreeRun = 0x0
	// Frame is transmitted between FRAMEDELAYMIN and FRAMEDELAYMAX
	NFCT_FRAMEDELAYMODE_FRAMEDELAYMODE_Window = 0x1
	// Frame is transmitted exactly at FRAMEDELAYMAX
	NFCT_FRAMEDELAYMODE_FRAMEDELAYMODE_ExactVal = 0x2
	// Frame is transmitted on a bit grid between FRAMEDELAYMIN and FRAMEDELAYMAX
	NFCT_FRAMEDELAYMODE_FRAMEDELAYMODE_WindowGrid = 0x3

	// PACKETPTR: Packet pointer for TXD and RXD data storage in Data RAM
	// Position of PTR field.
	NFCT_PACKETPTR_PTR_Pos = 0x0
	// Bit mask of PTR field.
	NFCT_PACKETPTR_PTR_Msk = 0xffffffff

	// MAXLEN: Size of the RAM buffer allocated to TXD and RXD data storage each
	// Position of MAXLEN field.
	NFCT_MAXLEN_MAXLEN_Pos = 0x0
	// Bit mask of MAXLEN field.
	NFCT_MAXLEN_MAXLEN_Msk = 0x1ff

	// TXD.FRAMECONFIG: Configuration of outgoing frames
	// Position of PARITY field.
	NFCT_TXD_FRAMECONFIG_PARITY_Pos = 0x0
	// Bit mask of PARITY field.
	NFCT_TXD_FRAMECONFIG_PARITY_Msk = 0x1
	// Bit PARITY.
	NFCT_TXD_FRAMECONFIG_PARITY = 0x1
	// Parity is not added to TX frames
	NFCT_TXD_FRAMECONFIG_PARITY_NoParity = 0x0
	// Parity is added to TX frames
	NFCT_TXD_FRAMECONFIG_PARITY_Parity = 0x1
	// Position of DISCARDMODE field.
	NFCT_TXD_FRAMECONFIG_DISCARDMODE_Pos = 0x1
	// Bit mask of DISCARDMODE field.
	NFCT_TXD_FRAMECONFIG_DISCARDMODE_Msk = 0x2
	// Bit DISCARDMODE.
	NFCT_TXD_FRAMECONFIG_DISCARDMODE = 0x2
	// Unused bits are discarded at end of frame (EoF)
	NFCT_TXD_FRAMECONFIG_DISCARDMODE_DiscardEnd = 0x0
	// Unused bits are discarded at start of frame (SoF)
	NFCT_TXD_FRAMECONFIG_DISCARDMODE_DiscardStart = 0x1
	// Position of SOF field.
	NFCT_TXD_FRAMECONFIG_SOF_Pos = 0x2
	// Bit mask of SOF field.
	NFCT_TXD_FRAMECONFIG_SOF_Msk = 0x4
	// Bit SOF.
	NFCT_TXD_FRAMECONFIG_SOF = 0x4
	// SoF symbol not added
	NFCT_TXD_FRAMECONFIG_SOF_NoSoF = 0x0
	// SoF symbol added
	NFCT_TXD_FRAMECONFIG_SOF_SoF = 0x1
	// Position of CRCMODETX field.
	NFCT_TXD_FRAMECONFIG_CRCMODETX_Pos = 0x4
	// Bit mask of CRCMODETX field.
	NFCT_TXD_FRAMECONFIG_CRCMODETX_Msk = 0x10
	// Bit CRCMODETX.
	NFCT_TXD_FRAMECONFIG_CRCMODETX = 0x10
	// CRC is not added to the frame
	NFCT_TXD_FRAMECONFIG_CRCMODETX_NoCRCTX = 0x0
	// 16 bit CRC added to the frame based on all the data read from RAM that is used in the frame
	NFCT_TXD_FRAMECONFIG_CRCMODETX_CRC16TX = 0x1

	// TXD.AMOUNT: Size of outgoing frame
	// Position of TXDATABITS field.
	NFCT_TXD_AMOUNT_TXDATABITS_Pos = 0x0
	// Bit mask of TXDATABITS field.
	NFCT_TXD_AMOUNT_TXDATABITS_Msk = 0x7
	// Position of TXDATABYTES field.
	NFCT_TXD_AMOUNT_TXDATABYTES_Pos = 0x3
	// Bit mask of TXDATABYTES field.
	NFCT_TXD_AMOUNT_TXDATABYTES_Msk = 0xff8

	// RXD.FRAMECONFIG: Configuration of incoming frames
	// Position of PARITY field.
	NFCT_RXD_FRAMECONFIG_PARITY_Pos = 0x0
	// Bit mask of PARITY field.
	NFCT_RXD_FRAMECONFIG_PARITY_Msk = 0x1
	// Bit PARITY.
	NFCT_RXD_FRAMECONFIG_PARITY = 0x1
	// Parity is not expected in RX frames
	NFCT_RXD_FRAMECONFIG_PARITY_NoParity = 0x0
	// Parity is expected in RX frames
	NFCT_RXD_FRAMECONFIG_PARITY_Parity = 0x1
	// Position of SOF field.
	NFCT_RXD_FRAMECONFIG_SOF_Pos = 0x2
	// Bit mask of SOF field.
	NFCT_RXD_FRAMECONFIG_SOF_Msk = 0x4
	// Bit SOF.
	NFCT_RXD_FRAMECONFIG_SOF = 0x4
	// SoF symbol is not expected in RX frames
	NFCT_RXD_FRAMECONFIG_SOF_NoSoF = 0x0
	// SoF symbol is expected in RX frames
	NFCT_RXD_FRAMECONFIG_SOF_SoF = 0x1
	// Position of CRCMODERX field.
	NFCT_RXD_FRAMECONFIG_CRCMODERX_Pos = 0x4
	// Bit mask of CRCMODERX field.
	NFCT_RXD_FRAMECONFIG_CRCMODERX_Msk = 0x10
	// Bit CRCMODERX.
	NFCT_RXD_FRAMECONFIG_CRCMODERX = 0x10
	// CRC is not expected in RX frames
	NFCT_RXD_FRAMECONFIG_CRCMODERX_NoCRCRX = 0x0
	// Last 16 bits in RX frame is CRC, CRC is checked and CRCSTATUS updated
	NFCT_RXD_FRAMECONFIG_CRCMODERX_CRC16RX = 0x1

	// RXD.AMOUNT: Size of last incoming frame
	// Position of RXDATABITS field.
	NFCT_RXD_AMOUNT_RXDATABITS_Pos = 0x0
	// Bit mask of RXDATABITS field.
	NFCT_RXD_AMOUNT_RXDATABITS_Msk = 0x7
	// Position of RXDATABYTES field.
	NFCT_RXD_AMOUNT_RXDATABYTES_Pos = 0x3
	// Bit mask of RXDATABYTES field.
	NFCT_RXD_AMOUNT_RXDATABYTES_Msk = 0xff8

	// NFCID1_LAST: Last NFCID1 part (4, 7 or 10 bytes ID)
	// Position of NFCID1_Z field.
	NFCT_NFCID1_LAST_NFCID1_Z_Pos = 0x0
	// Bit mask of NFCID1_Z field.
	NFCT_NFCID1_LAST_NFCID1_Z_Msk = 0xff
	// Position of NFCID1_Y field.
	NFCT_NFCID1_LAST_NFCID1_Y_Pos = 0x8
	// Bit mask of NFCID1_Y field.
	NFCT_NFCID1_LAST_NFCID1_Y_Msk = 0xff00
	// Position of NFCID1_X field.
	NFCT_NFCID1_LAST_NFCID1_X_Pos = 0x10
	// Bit mask of NFCID1_X field.
	NFCT_NFCID1_LAST_NFCID1_X_Msk = 0xff0000
	// Position of NFCID1_W field.
	NFCT_NFCID1_LAST_NFCID1_W_Pos = 0x18
	// Bit mask of NFCID1_W field.
	NFCT_NFCID1_LAST_NFCID1_W_Msk = 0xff000000

	// NFCID1_2ND_LAST: Second last NFCID1 part (7 or 10 bytes ID)
	// Position of NFCID1_V field.
	NFCT_NFCID1_2ND_LAST_NFCID1_V_Pos = 0x0
	// Bit mask of NFCID1_V field.
	NFCT_NFCID1_2ND_LAST_NFCID1_V_Msk = 0xff
	// Position of NFCID1_U field.
	NFCT_NFCID1_2ND_LAST_NFCID1_U_Pos = 0x8
	// Bit mask of NFCID1_U field.
	NFCT_NFCID1_2ND_LAST_NFCID1_U_Msk = 0xff00
	// Position of NFCID1_T field.
	NFCT_NFCID1_2ND_LAST_NFCID1_T_Pos = 0x10
	// Bit mask of NFCID1_T field.
	NFCT_NFCID1_2ND_LAST_NFCID1_T_Msk = 0xff0000

	// NFCID1_3RD_LAST: Third last NFCID1 part (10 bytes ID)
	// Position of NFCID1_S field.
	NFCT_NFCID1_3RD_LAST_NFCID1_S_Pos = 0x0
	// Bit mask of NFCID1_S field.
	NFCT_NFCID1_3RD_LAST_NFCID1_S_Msk = 0xff
	// Position of NFCID1_R field.
	NFCT_NFCID1_3RD_LAST_NFCID1_R_Pos = 0x8
	// Bit mask of NFCID1_R field.
	NFCT_NFCID1_3RD_LAST_NFCID1_R_Msk = 0xff00
	// Position of NFCID1_Q field.
	NFCT_NFCID1_3RD_LAST_NFCID1_Q_Pos = 0x10
	// Bit mask of NFCID1_Q field.
	NFCT_NFCID1_3RD_LAST_NFCID1_Q_Msk = 0xff0000

	// AUTOCOLRESCONFIG: Controls the auto collision resolution function. This setting must be done before the NFCT peripheral is enabled.
	// Position of MODE field.
	NFCT_AUTOCOLRESCONFIG_MODE_Pos = 0x0
	// Bit mask of MODE field.
	NFCT_AUTOCOLRESCONFIG_MODE_Msk = 0x1
	// Bit MODE.
	NFCT_AUTOCOLRESCONFIG_MODE = 0x1
	// Auto collision resolution enabled
	NFCT_AUTOCOLRESCONFIG_MODE_Enabled = 0x0
	// Auto collision resolution disabled
	NFCT_AUTOCOLRESCONFIG_MODE_Disabled = 0x1

	// SENSRES: NFC-A SENS_RES auto-response settings
	// Position of BITFRAMESDD field.
	NFCT_SENSRES_BITFRAMESDD_Pos = 0x0
	// Bit mask of BITFRAMESDD field.
	NFCT_SENSRES_BITFRAMESDD_Msk = 0x1f
	// SDD pattern 00000
	NFCT_SENSRES_BITFRAMESDD_SDD00000 = 0x0
	// SDD pattern 00001
	NFCT_SENSRES_BITFRAMESDD_SDD00001 = 0x1
	// SDD pattern 00010
	NFCT_SENSRES_BITFRAMESDD_SDD00010 = 0x2
	// SDD pattern 00100
	NFCT_SENSRES_BITFRAMESDD_SDD00100 = 0x4
	// SDD pattern 01000
	NFCT_SENSRES_BITFRAMESDD_SDD01000 = 0x8
	// SDD pattern 10000
	NFCT_SENSRES_BITFRAMESDD_SDD10000 = 0x10
	// Position of RFU5 field.
	NFCT_SENSRES_RFU5_Pos = 0x5
	// Bit mask of RFU5 field.
	NFCT_SENSRES_RFU5_Msk = 0x20
	// Bit RFU5.
	NFCT_SENSRES_RFU5 = 0x20
	// Position of NFCIDSIZE field.
	NFCT_SENSRES_NFCIDSIZE_Pos = 0x6
	// Bit mask of NFCIDSIZE field.
	NFCT_SENSRES_NFCIDSIZE_Msk = 0xc0
	// NFCID1 size: single (4 bytes)
	NFCT_SENSRES_NFCIDSIZE_NFCID1Single = 0x0
	// NFCID1 size: double (7 bytes)
	NFCT_SENSRES_NFCIDSIZE_NFCID1Double = 0x1
	// NFCID1 size: triple (10 bytes)
	NFCT_SENSRES_NFCIDSIZE_NFCID1Triple = 0x2
	// Position of PLATFCONFIG field.
	NFCT_SENSRES_PLATFCONFIG_Pos = 0x8
	// Bit mask of PLATFCONFIG field.
	NFCT_SENSRES_PLATFCONFIG_Msk = 0xf00
	// Position of RFU74 field.
	NFCT_SENSRES_RFU74_Pos = 0xc
	// Bit mask of RFU74 field.
	NFCT_SENSRES_RFU74_Msk = 0xf000

	// SELRES: NFC-A SEL_RES auto-response settings
	// Position of RFU10 field.
	NFCT_SELRES_RFU10_Pos = 0x0
	// Bit mask of RFU10 field.
	NFCT_SELRES_RFU10_Msk = 0x3
	// Position of CASCADE field.
	NFCT_SELRES_CASCADE_Pos = 0x2
	// Bit mask of CASCADE field.
	NFCT_SELRES_CASCADE_Msk = 0x4
	// Bit CASCADE.
	NFCT_SELRES_CASCADE = 0x4
	// Position of RFU43 field.
	NFCT_SELRES_RFU43_Pos = 0x3
	// Bit mask of RFU43 field.
	NFCT_SELRES_RFU43_Msk = 0x18
	// Position of PROTOCOL field.
	NFCT_SELRES_PROTOCOL_Pos = 0x5
	// Bit mask of PROTOCOL field.
	NFCT_SELRES_PROTOCOL_Msk = 0x60
	// Position of RFU7 field.
	NFCT_SELRES_RFU7_Pos = 0x7
	// Bit mask of RFU7 field.
	NFCT_SELRES_RFU7_Msk = 0x80
	// Bit RFU7.
	NFCT_SELRES_RFU7 = 0x80
)

// Bitfields for GPIOTE: GPIO Tasks and Events
const (
	// TASKS_OUT: Description collection: Task for writing to pin specified in CONFIG[n].PSEL. Action on pin is configured in CONFIG[n].POLARITY.
	// Position of TASKS_OUT field.
	GPIOTE_TASKS_OUT_TASKS_OUT_Pos = 0x0
	// Bit mask of TASKS_OUT field.
	GPIOTE_TASKS_OUT_TASKS_OUT_Msk = 0x1
	// Bit TASKS_OUT.
	GPIOTE_TASKS_OUT_TASKS_OUT = 0x1
	// Trigger task
	GPIOTE_TASKS_OUT_TASKS_OUT_Trigger = 0x1

	// TASKS_SET: Description collection: Task for writing to pin specified in CONFIG[n].PSEL. Action on pin is to set it high.
	// Position of TASKS_SET field.
	GPIOTE_TASKS_SET_TASKS_SET_Pos = 0x0
	// Bit mask of TASKS_SET field.
	GPIOTE_TASKS_SET_TASKS_SET_Msk = 0x1
	// Bit TASKS_SET.
	GPIOTE_TASKS_SET_TASKS_SET = 0x1
	// Trigger task
	GPIOTE_TASKS_SET_TASKS_SET_Trigger = 0x1

	// TASKS_CLR: Description collection: Task for writing to pin specified in CONFIG[n].PSEL. Action on pin is to set it low.
	// Position of TASKS_CLR field.
	GPIOTE_TASKS_CLR_TASKS_CLR_Pos = 0x0
	// Bit mask of TASKS_CLR field.
	GPIOTE_TASKS_CLR_TASKS_CLR_Msk = 0x1
	// Bit TASKS_CLR.
	GPIOTE_TASKS_CLR_TASKS_CLR = 0x1
	// Trigger task
	GPIOTE_TASKS_CLR_TASKS_CLR_Trigger = 0x1

	// EVENTS_IN: Description collection: Event generated from pin specified in CONFIG[n].PSEL
	// Position of EVENTS_IN field.
	GPIOTE_EVENTS_IN_EVENTS_IN_Pos = 0x0
	// Bit mask of EVENTS_IN field.
	GPIOTE_EVENTS_IN_EVENTS_IN_Msk = 0x1
	// Bit EVENTS_IN.
	GPIOTE_EVENTS_IN_EVENTS_IN = 0x1
	// Event not generated
	GPIOTE_EVENTS_IN_EVENTS_IN_NotGenerated = 0x0
	// Event generated
	GPIOTE_EVENTS_IN_EVENTS_IN_Generated = 0x1

	// EVENTS_PORT: Event generated from multiple input GPIO pins with SENSE mechanism enabled
	// Position of EVENTS_PORT field.
	GPIOTE_EVENTS_PORT_EVENTS_PORT_Pos = 0x0
	// Bit mask of EVENTS_PORT field.
	GPIOTE_EVENTS_PORT_EVENTS_PORT_Msk = 0x1
	// Bit EVENTS_PORT.
	GPIOTE_EVENTS_PORT_EVENTS_PORT = 0x1
	// Event not generated
	GPIOTE_EVENTS_PORT_EVENTS_PORT_NotGenerated = 0x0
	// Event generated
	GPIOTE_EVENTS_PORT_EVENTS_PORT_Generated = 0x1

	// INTENSET: Enable interrupt
	// Position of IN0 field.
	GPIOTE_INTENSET_IN0_Pos = 0x0
	// Bit mask of IN0 field.
	GPIOTE_INTENSET_IN0_Msk = 0x1
	// Bit IN0.
	GPIOTE_INTENSET_IN0 = 0x1
	// Read: Disabled
	GPIOTE_INTENSET_IN0_Disabled = 0x0
	// Read: Enabled
	GPIOTE_INTENSET_IN0_Enabled = 0x1
	// Enable
	GPIOTE_INTENSET_IN0_Set = 0x1
	// Position of IN1 field.
	GPIOTE_INTENSET_IN1_Pos = 0x1
	// Bit mask of IN1 field.
	GPIOTE_INTENSET_IN1_Msk = 0x2
	// Bit IN1.
	GPIOTE_INTENSET_IN1 = 0x2
	// Read: Disabled
	GPIOTE_INTENSET_IN1_Disabled = 0x0
	// Read: Enabled
	GPIOTE_INTENSET_IN1_Enabled = 0x1
	// Enable
	GPIOTE_INTENSET_IN1_Set = 0x1
	// Position of IN2 field.
	GPIOTE_INTENSET_IN2_Pos = 0x2
	// Bit mask of IN2 field.
	GPIOTE_INTENSET_IN2_Msk = 0x4
	// Bit IN2.
	GPIOTE_INTENSET_IN2 = 0x4
	// Read: Disabled
	GPIOTE_INTENSET_IN2_Disabled = 0x0
	// Read: Enabled
	GPIOTE_INTENSET_IN2_Enabled = 0x1
	// Enable
	GPIOTE_INTENSET_IN2_Set = 0x1
	// Position of IN3 field.
	GPIOTE_INTENSET_IN3_Pos = 0x3
	// Bit mask of IN3 field.
	GPIOTE_INTENSET_IN3_Msk = 0x8
	// Bit IN3.
	GPIOTE_INTENSET_IN3 = 0x8
	// Read: Disabled
	GPIOTE_INTENSET_IN3_Disabled = 0x0
	// Read: Enabled
	GPIOTE_INTENSET_IN3_Enabled = 0x1
	// Enable
	GPIOTE_INTENSET_IN3_Set = 0x1
	// Position of IN4 field.
	GPIOTE_INTENSET_IN4_Pos = 0x4
	// Bit mask of IN4 field.
	GPIOTE_INTENSET_IN4_Msk = 0x10
	// Bit IN4.
	GPIOTE_INTENSET_IN4 = 0x10
	// Read: Disabled
	GPIOTE_INTENSET_IN4_Disabled = 0x0
	// Read: Enabled
	GPIOTE_INTENSET_IN4_Enabled = 0x1
	// Enable
	GPIOTE_INTENSET_IN4_Set = 0x1
	// Position of IN5 field.
	GPIOTE_INTENSET_IN5_Pos = 0x5
	// Bit mask of IN5 field.
	GPIOTE_INTENSET_IN5_Msk = 0x20
	// Bit IN5.
	GPIOTE_INTENSET_IN5 = 0x20
	// Read: Disabled
	GPIOTE_INTENSET_IN5_Disabled = 0x0
	// Read: Enabled
	GPIOTE_INTENSET_IN5_Enabled = 0x1
	// Enable
	GPIOTE_INTENSET_IN5_Set = 0x1
	// Position of IN6 field.
	GPIOTE_INTENSET_IN6_Pos = 0x6
	// Bit mask of IN6 field.
	GPIOTE_INTENSET_IN6_Msk = 0x40
	// Bit IN6.
	GPIOTE_INTENSET_IN6 = 0x40
	// Read: Disabled
	GPIOTE_INTENSET_IN6_Disabled = 0x0
	// Read: Enabled
	GPIOTE_INTENSET_IN6_Enabled = 0x1
	// Enable
	GPIOTE_INTENSET_IN6_Set = 0x1
	// Position of IN7 field.
	GPIOTE_INTENSET_IN7_Pos = 0x7
	// Bit mask of IN7 field.
	GPIOTE_INTENSET_IN7_Msk = 0x80
	// Bit IN7.
	GPIOTE_INTENSET_IN7 = 0x80
	// Read: Disabled
	GPIOTE_INTENSET_IN7_Disabled = 0x0
	// Read: Enabled
	GPIOTE_INTENSET_IN7_Enabled = 0x1
	// Enable
	GPIOTE_INTENSET_IN7_Set = 0x1
	// Position of PORT field.
	GPIOTE_INTENSET_PORT_Pos = 0x1f
	// Bit mask of PORT field.
	GPIOTE_INTENSET_PORT_Msk = 0x80000000
	// Bit PORT.
	GPIOTE_INTENSET_PORT = 0x80000000
	// Read: Disabled
	GPIOTE_INTENSET_PORT_Disabled = 0x0
	// Read: Enabled
	GPIOTE_INTENSET_PORT_Enabled = 0x1
	// Enable
	GPIOTE_INTENSET_PORT_Set = 0x1

	// INTENCLR: Disable interrupt
	// Position of IN0 field.
	GPIOTE_INTENCLR_IN0_Pos = 0x0
	// Bit mask of IN0 field.
	GPIOTE_INTENCLR_IN0_Msk = 0x1
	// Bit IN0.
	GPIOTE_INTENCLR_IN0 = 0x1
	// Read: Disabled
	GPIOTE_INTENCLR_IN0_Disabled = 0x0
	// Read: Enabled
	GPIOTE_INTENCLR_IN0_Enabled = 0x1
	// Disable
	GPIOTE_INTENCLR_IN0_Clear = 0x1
	// Position of IN1 field.
	GPIOTE_INTENCLR_IN1_Pos = 0x1
	// Bit mask of IN1 field.
	GPIOTE_INTENCLR_IN1_Msk = 0x2
	// Bit IN1.
	GPIOTE_INTENCLR_IN1 = 0x2
	// Read: Disabled
	GPIOTE_INTENCLR_IN1_Disabled = 0x0
	// Read: Enabled
	GPIOTE_INTENCLR_IN1_Enabled = 0x1
	// Disable
	GPIOTE_INTENCLR_IN1_Clear = 0x1
	// Position of IN2 field.
	GPIOTE_INTENCLR_IN2_Pos = 0x2
	// Bit mask of IN2 field.
	GPIOTE_INTENCLR_IN2_Msk = 0x4
	// Bit IN2.
	GPIOTE_INTENCLR_IN2 = 0x4
	// Read: Disabled
	GPIOTE_INTENCLR_IN2_Disabled = 0x0
	// Read: Enabled
	GPIOTE_INTENCLR_IN2_Enabled = 0x1
	// Disable
	GPIOTE_INTENCLR_IN2_Clear = 0x1
	// Position of IN3 field.
	GPIOTE_INTENCLR_IN3_Pos = 0x3
	// Bit mask of IN3 field.
	GPIOTE_INTENCLR_IN3_Msk = 0x8
	// Bit IN3.
	GPIOTE_INTENCLR_IN3 = 0x8
	// Read: Disabled
	GPIOTE_INTENCLR_IN3_Disabled = 0x0
	// Read: Enabled
	GPIOTE_INTENCLR_IN3_Enabled = 0x1
	// Disable
	GPIOTE_INTENCLR_IN3_Clear = 0x1
	// Position of IN4 field.
	GPIOTE_INTENCLR_IN4_Pos = 0x4
	// Bit mask of IN4 field.
	GPIOTE_INTENCLR_IN4_Msk = 0x10
	// Bit IN4.
	GPIOTE_INTENCLR_IN4 = 0x10
	// Read: Disabled
	GPIOTE_INTENCLR_IN4_Disabled = 0x0
	// Read: Enabled
	GPIOTE_INTENCLR_IN4_Enabled = 0x1
	// Disable
	GPIOTE_INTENCLR_IN4_Clear = 0x1
	// Position of IN5 field.
	GPIOTE_INTENCLR_IN5_Pos = 0x5
	// Bit mask of IN5 field.
	GPIOTE_INTENCLR_IN5_Msk = 0x20
	// Bit IN5.
	GPIOTE_INTENCLR_IN5 = 0x20
	// Read: Disabled
	GPIOTE_INTENCLR_IN5_Disabled = 0x0
	// Read: Enabled
	GPIOTE_INTENCLR_IN5_Enabled = 0x1
	// Disable
	GPIOTE_INTENCLR_IN5_Clear = 0x1
	// Position of IN6 field.
	GPIOTE_INTENCLR_IN6_Pos = 0x6
	// Bit mask of IN6 field.
	GPIOTE_INTENCLR_IN6_Msk = 0x40
	// Bit IN6.
	GPIOTE_INTENCLR_IN6 = 0x40
	// Read: Disabled
	GPIOTE_INTENCLR_IN6_Disabled = 0x0
	// Read: Enabled
	GPIOTE_INTENCLR_IN6_Enabled = 0x1
	// Disable
	GPIOTE_INTENCLR_IN6_Clear = 0x1
	// Position of IN7 field.
	GPIOTE_INTENCLR_IN7_Pos = 0x7
	// Bit mask of IN7 field.
	GPIOTE_INTENCLR_IN7_Msk = 0x80
	// Bit IN7.
	GPIOTE_INTENCLR_IN7 = 0x80
	// Read: Disabled
	GPIOTE_INTENCLR_IN7_Disabled = 0x0
	// Read: Enabled
	GPIOTE_INTENCLR_IN7_Enabled = 0x1
	// Disable
	GPIOTE_INTENCLR_IN7_Clear = 0x1
	// Position of PORT field.
	GPIOTE_INTENCLR_PORT_Pos = 0x1f
	// Bit mask of PORT field.
	GPIOTE_INTENCLR_PORT_Msk = 0x80000000
	// Bit PORT.
	GPIOTE_INTENCLR_PORT = 0x80000000
	// Read: Disabled
	GPIOTE_INTENCLR_PORT_Disabled = 0x0
	// Read: Enabled
	GPIOTE_INTENCLR_PORT_Enabled = 0x1
	// Disable
	GPIOTE_INTENCLR_PORT_Clear = 0x1

	// CONFIG: Description collection: Configuration for OUT[n], SET[n] and CLR[n] tasks and IN[n] event
	// Position of MODE field.
	GPIOTE_CONFIG_MODE_Pos = 0x0
	// Bit mask of MODE field.
	GPIOTE_CONFIG_MODE_Msk = 0x3
	// Disabled. Pin specified by PSEL will not be acquired by the GPIOTE module.
	GPIOTE_CONFIG_MODE_Disabled = 0x0
	// Event mode
	GPIOTE_CONFIG_MODE_Event = 0x1
	// Task mode
	GPIOTE_CONFIG_MODE_Task = 0x3
	// Position of PSEL field.
	GPIOTE_CONFIG_PSEL_Pos = 0x8
	// Bit mask of PSEL field.
	GPIOTE_CONFIG_PSEL_Msk = 0x1f00
	// Position of PORT field.
	GPIOTE_CONFIG_PORT_Pos = 0xd
	// Bit mask of PORT field.
	GPIOTE_CONFIG_PORT_Msk = 0x2000
	// Bit PORT.
	GPIOTE_CONFIG_PORT = 0x2000
	// Position of POLARITY field.
	GPIOTE_CONFIG_POLARITY_Pos = 0x10
	// Bit mask of POLARITY field.
	GPIOTE_CONFIG_POLARITY_Msk = 0x30000
	// Task mode: No effect on pin from OUT[n] task. Event mode: no IN[n] event generated on pin activity.
	GPIOTE_CONFIG_POLARITY_None = 0x0
	// Task mode: Set pin from OUT[n] task. Event mode: Generate IN[n] event when rising edge on pin.
	GPIOTE_CONFIG_POLARITY_LoToHi = 0x1
	// Task mode: Clear pin from OUT[n] task. Event mode: Generate IN[n] event when falling edge on pin.
	GPIOTE_CONFIG_POLARITY_HiToLo = 0x2
	// Task mode: Toggle pin from OUT[n]. Event mode: Generate IN[n] when any change on pin.
	GPIOTE_CONFIG_POLARITY_Toggle = 0x3
	// Position of OUTINIT field.
	GPIOTE_CONFIG_OUTINIT_Pos = 0x14
	// Bit mask of OUTINIT field.
	GPIOTE_CONFIG_OUTINIT_Msk = 0x100000
	// Bit OUTINIT.
	GPIOTE_CONFIG_OUTINIT = 0x100000
	// Task mode: Initial value of pin before task triggering is low
	GPIOTE_CONFIG_OUTINIT_Low = 0x0
	// Task mode: Initial value of pin before task triggering is high
	GPIOTE_CONFIG_OUTINIT_High = 0x1
)

// Bitfields for SAADC: Successive approximation register (SAR) analog-to-digital converter
const (
	// TASKS_START: Starts the SAADC and prepares the result buffer in RAM
	// Position of TASKS_START field.
	SAADC_TASKS_START_TASKS_START_Pos = 0x0
	// Bit mask of TASKS_START field.
	SAADC_TASKS_START_TASKS_START_Msk = 0x1
	// Bit TASKS_START.
	SAADC_TASKS_START_TASKS_START = 0x1
	// Trigger task
	SAADC_TASKS_START_TASKS_START_Trigger = 0x1

	// TASKS_SAMPLE: Takes one SAADC sample
	// Position of TASKS_SAMPLE field.
	SAADC_TASKS_SAMPLE_TASKS_SAMPLE_Pos = 0x0
	// Bit mask of TASKS_SAMPLE field.
	SAADC_TASKS_SAMPLE_TASKS_SAMPLE_Msk = 0x1
	// Bit TASKS_SAMPLE.
	SAADC_TASKS_SAMPLE_TASKS_SAMPLE = 0x1
	// Trigger task
	SAADC_TASKS_SAMPLE_TASKS_SAMPLE_Trigger = 0x1

	// TASKS_STOP: Stops the SAADC and terminates all on-going conversions
	// Position of TASKS_STOP field.
	SAADC_TASKS_STOP_TASKS_STOP_Pos = 0x0
	// Bit mask of TASKS_STOP field.
	SAADC_TASKS_STOP_TASKS_STOP_Msk = 0x1
	// Bit TASKS_STOP.
	SAADC_TASKS_STOP_TASKS_STOP = 0x1
	// Trigger task
	SAADC_TASKS_STOP_TASKS_STOP_Trigger = 0x1

	// TASKS_CALIBRATEOFFSET: Starts offset auto-calibration
	// Position of TASKS_CALIBRATEOFFSET field.
	SAADC_TASKS_CALIBRATEOFFSET_TASKS_CALIBRATEOFFSET_Pos = 0x0
	// Bit mask of TASKS_CALIBRATEOFFSET field.
	SAADC_TASKS_CALIBRATEOFFSET_TASKS_CALIBRATEOFFSET_Msk = 0x1
	// Bit TASKS_CALIBRATEOFFSET.
	SAADC_TASKS_CALIBRATEOFFSET_TASKS_CALIBRATEOFFSET = 0x1
	// Trigger task
	SAADC_TASKS_CALIBRATEOFFSET_TASKS_CALIBRATEOFFSET_Trigger = 0x1

	// EVENTS_STARTED: The SAADC has started
	// Position of EVENTS_STARTED field.
	SAADC_EVENTS_STARTED_EVENTS_STARTED_Pos = 0x0
	// Bit mask of EVENTS_STARTED field.
	SAADC_EVENTS_STARTED_EVENTS_STARTED_Msk = 0x1
	// Bit EVENTS_STARTED.
	SAADC_EVENTS_STARTED_EVENTS_STARTED = 0x1
	// Event not generated
	SAADC_EVENTS_STARTED_EVENTS_STARTED_NotGenerated = 0x0
	// Event generated
	SAADC_EVENTS_STARTED_EVENTS_STARTED_Generated = 0x1

	// EVENTS_END: The SAADC has filled up the result buffer
	// Position of EVENTS_END field.
	SAADC_EVENTS_END_EVENTS_END_Pos = 0x0
	// Bit mask of EVENTS_END field.
	SAADC_EVENTS_END_EVENTS_END_Msk = 0x1
	// Bit EVENTS_END.
	SAADC_EVENTS_END_EVENTS_END = 0x1
	// Event not generated
	SAADC_EVENTS_END_EVENTS_END_NotGenerated = 0x0
	// Event generated
	SAADC_EVENTS_END_EVENTS_END_Generated = 0x1

	// EVENTS_DONE: A conversion task has been completed. Depending on the configuration, multiple conversions might be needed for a result to be transferred to RAM.
	// Position of EVENTS_DONE field.
	SAADC_EVENTS_DONE_EVENTS_DONE_Pos = 0x0
	// Bit mask of EVENTS_DONE field.
	SAADC_EVENTS_DONE_EVENTS_DONE_Msk = 0x1
	// Bit EVENTS_DONE.
	SAADC_EVENTS_DONE_EVENTS_DONE = 0x1
	// Event not generated
	SAADC_EVENTS_DONE_EVENTS_DONE_NotGenerated = 0x0
	// Event generated
	SAADC_EVENTS_DONE_EVENTS_DONE_Generated = 0x1

	// EVENTS_RESULTDONE: Result ready for transfer to RAM
	// Position of EVENTS_RESULTDONE field.
	SAADC_EVENTS_RESULTDONE_EVENTS_RESULTDONE_Pos = 0x0
	// Bit mask of EVENTS_RESULTDONE field.
	SAADC_EVENTS_RESULTDONE_EVENTS_RESULTDONE_Msk = 0x1
	// Bit EVENTS_RESULTDONE.
	SAADC_EVENTS_RESULTDONE_EVENTS_RESULTDONE = 0x1
	// Event not generated
	SAADC_EVENTS_RESULTDONE_EVENTS_RESULTDONE_NotGenerated = 0x0
	// Event generated
	SAADC_EVENTS_RESULTDONE_EVENTS_RESULTDONE_Generated = 0x1

	// EVENTS_CALIBRATEDONE: Calibration is complete
	// Position of EVENTS_CALIBRATEDONE field.
	SAADC_EVENTS_CALIBRATEDONE_EVENTS_CALIBRATEDONE_Pos = 0x0
	// Bit mask of EVENTS_CALIBRATEDONE field.
	SAADC_EVENTS_CALIBRATEDONE_EVENTS_CALIBRATEDONE_Msk = 0x1
	// Bit EVENTS_CALIBRATEDONE.
	SAADC_EVENTS_CALIBRATEDONE_EVENTS_CALIBRATEDONE = 0x1
	// Event not generated
	SAADC_EVENTS_CALIBRATEDONE_EVENTS_CALIBRATEDONE_NotGenerated = 0x0
	// Event generated
	SAADC_EVENTS_CALIBRATEDONE_EVENTS_CALIBRATEDONE_Generated = 0x1

	// EVENTS_STOPPED: The SAADC has stopped
	// Position of EVENTS_STOPPED field.
	SAADC_EVENTS_STOPPED_EVENTS_STOPPED_Pos = 0x0
	// Bit mask of EVENTS_STOPPED field.
	SAADC_EVENTS_STOPPED_EVENTS_STOPPED_Msk = 0x1
	// Bit EVENTS_STOPPED.
	SAADC_EVENTS_STOPPED_EVENTS_STOPPED = 0x1
	// Event not generated
	SAADC_EVENTS_STOPPED_EVENTS_STOPPED_NotGenerated = 0x0
	// Event generated
	SAADC_EVENTS_STOPPED_EVENTS_STOPPED_Generated = 0x1

	// EVENTS_CH.LIMITH: Description cluster: Last result is equal or above CH[n].LIMIT.HIGH
	// Position of LIMITH field.
	SAADC_EVENTS_CH_LIMITH_LIMITH_Pos = 0x0
	// Bit mask of LIMITH field.
	SAADC_EVENTS_CH_LIMITH_LIMITH_Msk = 0x1
	// Bit LIMITH.
	SAADC_EVENTS_CH_LIMITH_LIMITH = 0x1
	// Event not generated
	SAADC_EVENTS_CH_LIMITH_LIMITH_NotGenerated = 0x0
	// Event generated
	SAADC_EVENTS_CH_LIMITH_LIMITH_Generated = 0x1

	// EVENTS_CH.LIMITL: Description cluster: Last result is equal or below CH[n].LIMIT.LOW
	// Position of LIMITL field.
	SAADC_EVENTS_CH_LIMITL_LIMITL_Pos = 0x0
	// Bit mask of LIMITL field.
	SAADC_EVENTS_CH_LIMITL_LIMITL_Msk = 0x1
	// Bit LIMITL.
	SAADC_EVENTS_CH_LIMITL_LIMITL = 0x1
	// Event not generated
	SAADC_EVENTS_CH_LIMITL_LIMITL_NotGenerated = 0x0
	// Event generated
	SAADC_EVENTS_CH_LIMITL_LIMITL_Generated = 0x1

	// INTEN: Enable or disable interrupt
	// Position of STARTED field.
	SAADC_INTEN_STARTED_Pos = 0x0
	// Bit mask of STARTED field.
	SAADC_INTEN_STARTED_Msk = 0x1
	// Bit STARTED.
	SAADC_INTEN_STARTED = 0x1
	// Disable
	SAADC_INTEN_STARTED_Disabled = 0x0
	// Enable
	SAADC_INTEN_STARTED_Enabled = 0x1
	// Position of END field.
	SAADC_INTEN_END_Pos = 0x1
	// Bit mask of END field.
	SAADC_INTEN_END_Msk = 0x2
	// Bit END.
	SAADC_INTEN_END = 0x2
	// Disable
	SAADC_INTEN_END_Disabled = 0x0
	// Enable
	SAADC_INTEN_END_Enabled = 0x1
	// Position of DONE field.
	SAADC_INTEN_DONE_Pos = 0x2
	// Bit mask of DONE field.
	SAADC_INTEN_DONE_Msk = 0x4
	// Bit DONE.
	SAADC_INTEN_DONE = 0x4
	// Disable
	SAADC_INTEN_DONE_Disabled = 0x0
	// Enable
	SAADC_INTEN_DONE_Enabled = 0x1
	// Position of RESULTDONE field.
	SAADC_INTEN_RESULTDONE_Pos = 0x3
	// Bit mask of RESULTDONE field.
	SAADC_INTEN_RESULTDONE_Msk = 0x8
	// Bit RESULTDONE.
	SAADC_INTEN_RESULTDONE = 0x8
	// Disable
	SAADC_INTEN_RESULTDONE_Disabled = 0x0
	// Enable
	SAADC_INTEN_RESULTDONE_Enabled = 0x1
	// Position of CALIBRATEDONE field.
	SAADC_INTEN_CALIBRATEDONE_Pos = 0x4
	// Bit mask of CALIBRATEDONE field.
	SAADC_INTEN_CALIBRATEDONE_Msk = 0x10
	// Bit CALIBRATEDONE.
	SAADC_INTEN_CALIBRATEDONE = 0x10
	// Disable
	SAADC_INTEN_CALIBRATEDONE_Disabled = 0x0
	// Enable
	SAADC_INTEN_CALIBRATEDONE_Enabled = 0x1
	// Position of STOPPED field.
	SAADC_INTEN_STOPPED_Pos = 0x5
	// Bit mask of STOPPED field.
	SAADC_INTEN_STOPPED_Msk = 0x20
	// Bit STOPPED.
	SAADC_INTEN_STOPPED = 0x20
	// Disable
	SAADC_INTEN_STOPPED_Disabled = 0x0
	// Enable
	SAADC_INTEN_STOPPED_Enabled = 0x1
	// Position of CH0LIMITH field.
	SAADC_INTEN_CH0LIMITH_Pos = 0x6
	// Bit mask of CH0LIMITH field.
	SAADC_INTEN_CH0LIMITH_Msk = 0x40
	// Bit CH0LIMITH.
	SAADC_INTEN_CH0LIMITH = 0x40
	// Disable
	SAADC_INTEN_CH0LIMITH_Disabled = 0x0
	// Enable
	SAADC_INTEN_CH0LIMITH_Enabled = 0x1
	// Position of CH0LIMITL field.
	SAADC_INTEN_CH0LIMITL_Pos = 0x7
	// Bit mask of CH0LIMITL field.
	SAADC_INTEN_CH0LIMITL_Msk = 0x80
	// Bit CH0LIMITL.
	SAADC_INTEN_CH0LIMITL = 0x80
	// Disable
	SAADC_INTEN_CH0LIMITL_Disabled = 0x0
	// Enable
	SAADC_INTEN_CH0LIMITL_Enabled = 0x1
	// Position of CH1LIMITH field.
	SAADC_INTEN_CH1LIMITH_Pos = 0x8
	// Bit mask of CH1LIMITH field.
	SAADC_INTEN_CH1LIMITH_Msk = 0x100
	// Bit CH1LIMITH.
	SAADC_INTEN_CH1LIMITH = 0x100
	// Disable
	SAADC_INTEN_CH1LIMITH_Disabled = 0x0
	// Enable
	SAADC_INTEN_CH1LIMITH_Enabled = 0x1
	// Position of CH1LIMITL field.
	SAADC_INTEN_CH1LIMITL_Pos = 0x9
	// Bit mask of CH1LIMITL field.
	SAADC_INTEN_CH1LIMITL_Msk = 0x200
	// Bit CH1LIMITL.
	SAADC_INTEN_CH1LIMITL = 0x200
	// Disable
	SAADC_INTEN_CH1LIMITL_Disabled = 0x0
	// Enable
	SAADC_INTEN_CH1LIMITL_Enabled = 0x1
	// Position of CH2LIMITH field.
	SAADC_INTEN_CH2LIMITH_Pos = 0xa
	// Bit mask of CH2LIMITH field.
	SAADC_INTEN_CH2LIMITH_Msk = 0x400
	// Bit CH2LIMITH.
	SAADC_INTEN_CH2LIMITH = 0x400
	// Disable
	SAADC_INTEN_CH2LIMITH_Disabled = 0x0
	// Enable
	SAADC_INTEN_CH2LIMITH_Enabled = 0x1
	// Position of CH2LIMITL field.
	SAADC_INTEN_CH2LIMITL_Pos = 0xb
	// Bit mask of CH2LIMITL field.
	SAADC_INTEN_CH2LIMITL_Msk = 0x800
	// Bit CH2LIMITL.
	SAADC_INTEN_CH2LIMITL = 0x800
	// Disable
	SAADC_INTEN_CH2LIMITL_Disabled = 0x0
	// Enable
	SAADC_INTEN_CH2LIMITL_Enabled = 0x1
	// Position of CH3LIMITH field.
	SAADC_INTEN_CH3LIMITH_Pos = 0xc
	// Bit mask of CH3LIMITH field.
	SAADC_INTEN_CH3LIMITH_Msk = 0x1000
	// Bit CH3LIMITH.
	SAADC_INTEN_CH3LIMITH = 0x1000
	// Disable
	SAADC_INTEN_CH3LIMITH_Disabled = 0x0
	// Enable
	SAADC_INTEN_CH3LIMITH_Enabled = 0x1
	// Position of CH3LIMITL field.
	SAADC_INTEN_CH3LIMITL_Pos = 0xd
	// Bit mask of CH3LIMITL field.
	SAADC_INTEN_CH3LIMITL_Msk = 0x2000
	// Bit CH3LIMITL.
	SAADC_INTEN_CH3LIMITL = 0x2000
	// Disable
	SAADC_INTEN_CH3LIMITL_Disabled = 0x0
	// Enable
	SAADC_INTEN_CH3LIMITL_Enabled = 0x1
	// Position of CH4LIMITH field.
	SAADC_INTEN_CH4LIMITH_Pos = 0xe
	// Bit mask of CH4LIMITH field.
	SAADC_INTEN_CH4LIMITH_Msk = 0x4000
	// Bit CH4LIMITH.
	SAADC_INTEN_CH4LIMITH = 0x4000
	// Disable
	SAADC_INTEN_CH4LIMITH_Disabled = 0x0
	// Enable
	SAADC_INTEN_CH4LIMITH_Enabled = 0x1
	// Position of CH4LIMITL field.
	SAADC_INTEN_CH4LIMITL_Pos = 0xf
	// Bit mask of CH4LIMITL field.
	SAADC_INTEN_CH4LIMITL_Msk = 0x8000
	// Bit CH4LIMITL.
	SAADC_INTEN_CH4LIMITL = 0x8000
	// Disable
	SAADC_INTEN_CH4LIMITL_Disabled = 0x0
	// Enable
	SAADC_INTEN_CH4LIMITL_Enabled = 0x1
	// Position of CH5LIMITH field.
	SAADC_INTEN_CH5LIMITH_Pos = 0x10
	// Bit mask of CH5LIMITH field.
	SAADC_INTEN_CH5LIMITH_Msk = 0x10000
	// Bit CH5LIMITH.
	SAADC_INTEN_CH5LIMITH = 0x10000
	// Disable
	SAADC_INTEN_CH5LIMITH_Disabled = 0x0
	// Enable
	SAADC_INTEN_CH5LIMITH_Enabled = 0x1
	// Position of CH5LIMITL field.
	SAADC_INTEN_CH5LIMITL_Pos = 0x11
	// Bit mask of CH5LIMITL field.
	SAADC_INTEN_CH5LIMITL_Msk = 0x20000
	// Bit CH5LIMITL.
	SAADC_INTEN_CH5LIMITL = 0x20000
	// Disable
	SAADC_INTEN_CH5LIMITL_Disabled = 0x0
	// Enable
	SAADC_INTEN_CH5LIMITL_Enabled = 0x1
	// Position of CH6LIMITH field.
	SAADC_INTEN_CH6LIMITH_Pos = 0x12
	// Bit mask of CH6LIMITH field.
	SAADC_INTEN_CH6LIMITH_Msk = 0x40000
	// Bit CH6LIMITH.
	SAADC_INTEN_CH6LIMITH = 0x40000
	// Disable
	SAADC_INTEN_CH6LIMITH_Disabled = 0x0
	// Enable
	SAADC_INTEN_CH6LIMITH_Enabled = 0x1
	// Position of CH6LIMITL field.
	SAADC_INTEN_CH6LIMITL_Pos = 0x13
	// Bit mask of CH6LIMITL field.
	SAADC_INTEN_CH6LIMITL_Msk = 0x80000
	// Bit CH6LIMITL.
	SAADC_INTEN_CH6LIMITL = 0x80000
	// Disable
	SAADC_INTEN_CH6LIMITL_Disabled = 0x0
	// Enable
	SAADC_INTEN_CH6LIMITL_Enabled = 0x1
	// Position of CH7LIMITH field.
	SAADC_INTEN_CH7LIMITH_Pos = 0x14
	// Bit mask of CH7LIMITH field.
	SAADC_INTEN_CH7LIMITH_Msk = 0x100000
	// Bit CH7LIMITH.
	SAADC_INTEN_CH7LIMITH = 0x100000
	// Disable
	SAADC_INTEN_CH7LIMITH_Disabled = 0x0
	// Enable
	SAADC_INTEN_CH7LIMITH_Enabled = 0x1
	// Position of CH7LIMITL field.
	SAADC_INTEN_CH7LIMITL_Pos = 0x15
	// Bit mask of CH7LIMITL field.
	SAADC_INTEN_CH7LIMITL_Msk = 0x200000
	// Bit CH7LIMITL.
	SAADC_INTEN_CH7LIMITL = 0x200000
	// Disable
	SAADC_INTEN_CH7LIMITL_Disabled = 0x0
	// Enable
	SAADC_INTEN_CH7LIMITL_Enabled = 0x1

	// INTENSET: Enable interrupt
	// Position of STARTED field.
	SAADC_INTENSET_STARTED_Pos = 0x0
	// Bit mask of STARTED field.
	SAADC_INTENSET_STARTED_Msk = 0x1
	// Bit STARTED.
	SAADC_INTENSET_STARTED = 0x1
	// Read: Disabled
	SAADC_INTENSET_STARTED_Disabled = 0x0
	// Read: Enabled
	SAADC_INTENSET_STARTED_Enabled = 0x1
	// Enable
	SAADC_INTENSET_STARTED_Set = 0x1
	// Position of END field.
	SAADC_INTENSET_END_Pos = 0x1
	// Bit mask of END field.
	SAADC_INTENSET_END_Msk = 0x2
	// Bit END.
	SAADC_INTENSET_END = 0x2
	// Read: Disabled
	SAADC_INTENSET_END_Disabled = 0x0
	// Read: Enabled
	SAADC_INTENSET_END_Enabled = 0x1
	// Enable
	SAADC_INTENSET_END_Set = 0x1
	// Position of DONE field.
	SAADC_INTENSET_DONE_Pos = 0x2
	// Bit mask of DONE field.
	SAADC_INTENSET_DONE_Msk = 0x4
	// Bit DONE.
	SAADC_INTENSET_DONE = 0x4
	// Read: Disabled
	SAADC_INTENSET_DONE_Disabled = 0x0
	// Read: Enabled
	SAADC_INTENSET_DONE_Enabled = 0x1
	// Enable
	SAADC_INTENSET_DONE_Set = 0x1
	// Position of RESULTDONE field.
	SAADC_INTENSET_RESULTDONE_Pos = 0x3
	// Bit mask of RESULTDONE field.
	SAADC_INTENSET_RESULTDONE_Msk = 0x8
	// Bit RESULTDONE.
	SAADC_INTENSET_RESULTDONE = 0x8
	// Read: Disabled
	SAADC_INTENSET_RESULTDONE_Disabled = 0x0
	// Read: Enabled
	SAADC_INTENSET_RESULTDONE_Enabled = 0x1
	// Enable
	SAADC_INTENSET_RESULTDONE_Set = 0x1
	// Position of CALIBRATEDONE field.
	SAADC_INTENSET_CALIBRATEDONE_Pos = 0x4
	// Bit mask of CALIBRATEDONE field.
	SAADC_INTENSET_CALIBRATEDONE_Msk = 0x10
	// Bit CALIBRATEDONE.
	SAADC_INTENSET_CALIBRATEDONE = 0x10
	// Read: Disabled
	SAADC_INTENSET_CALIBRATEDONE_Disabled = 0x0
	// Read: Enabled
	SAADC_INTENSET_CALIBRATEDONE_Enabled = 0x1
	// Enable
	SAADC_INTENSET_CALIBRATEDONE_Set = 0x1
	// Position of STOPPED field.
	SAADC_INTENSET_STOPPED_Pos = 0x5
	// Bit mask of STOPPED field.
	SAADC_INTENSET_STOPPED_Msk = 0x20
	// Bit STOPPED.
	SAADC_INTENSET_STOPPED = 0x20
	// Read: Disabled
	SAADC_INTENSET_STOPPED_Disabled = 0x0
	// Read: Enabled
	SAADC_INTENSET_STOPPED_Enabled = 0x1
	// Enable
	SAADC_INTENSET_STOPPED_Set = 0x1
	// Position of CH0LIMITH field.
	SAADC_INTENSET_CH0LIMITH_Pos = 0x6
	// Bit mask of CH0LIMITH field.
	SAADC_INTENSET_CH0LIMITH_Msk = 0x40
	// Bit CH0LIMITH.
	SAADC_INTENSET_CH0LIMITH = 0x40
	// Read: Disabled
	SAADC_INTENSET_CH0LIMITH_Disabled = 0x0
	// Read: Enabled
	SAADC_INTENSET_CH0LIMITH_Enabled = 0x1
	// Enable
	SAADC_INTENSET_CH0LIMITH_Set = 0x1
	// Position of CH0LIMITL field.
	SAADC_INTENSET_CH0LIMITL_Pos = 0x7
	// Bit mask of CH0LIMITL field.
	SAADC_INTENSET_CH0LIMITL_Msk = 0x80
	// Bit CH0LIMITL.
	SAADC_INTENSET_CH0LIMITL = 0x80
	// Read: Disabled
	SAADC_INTENSET_CH0LIMITL_Disabled = 0x0
	// Read: Enabled
	SAADC_INTENSET_CH0LIMITL_Enabled = 0x1
	// Enable
	SAADC_INTENSET_CH0LIMITL_Set = 0x1
	// Position of CH1LIMITH field.
	SAADC_INTENSET_CH1LIMITH_Pos = 0x8
	// Bit mask of CH1LIMITH field.
	SAADC_INTENSET_CH1LIMITH_Msk = 0x100
	// Bit CH1LIMITH.
	SAADC_INTENSET_CH1LIMITH = 0x100
	// Read: Disabled
	SAADC_INTENSET_CH1LIMITH_Disabled = 0x0
	// Read: Enabled
	SAADC_INTENSET_CH1LIMITH_Enabled = 0x1
	// Enable
	SAADC_INTENSET_CH1LIMITH_Set = 0x1
	// Position of CH1LIMITL field.
	SAADC_INTENSET_CH1LIMITL_Pos = 0x9
	// Bit mask of CH1LIMITL field.
	SAADC_INTENSET_CH1LIMITL_Msk = 0x200
	// Bit CH1LIMITL.
	SAADC_INTENSET_CH1LIMITL = 0x200
	// Read: Disabled
	SAADC_INTENSET_CH1LIMITL_Disabled = 0x0
	// Read: Enabled
	SAADC_INTENSET_CH1LIMITL_Enabled = 0x1
	// Enable
	SAADC_INTENSET_CH1LIMITL_Set = 0x1
	// Position of CH2LIMITH field.
	SAADC_INTENSET_CH2LIMITH_Pos = 0xa
	// Bit mask of CH2LIMITH field.
	SAADC_INTENSET_CH2LIMITH_Msk = 0x400
	// Bit CH2LIMITH.
	SAADC_INTENSET_CH2LIMITH = 0x400
	// Read: Disabled
	SAADC_INTENSET_CH2LIMITH_Disabled = 0x0
	// Read: Enabled
	SAADC_INTENSET_CH2LIMITH_Enabled = 0x1
	// Enable
	SAADC_INTENSET_CH2LIMITH_Set = 0x1
	// Position of CH2LIMITL field.
	SAADC_INTENSET_CH2LIMITL_Pos = 0xb
	// Bit mask of CH2LIMITL field.
	SAADC_INTENSET_CH2LIMITL_Msk = 0x800
	// Bit CH2LIMITL.
	SAADC_INTENSET_CH2LIMITL = 0x800
	// Read: Disabled
	SAADC_INTENSET_CH2LIMITL_Disabled = 0x0
	// Read: Enabled
	SAADC_INTENSET_CH2LIMITL_Enabled = 0x1
	// Enable
	SAADC_INTENSET_CH2LIMITL_Set = 0x1
	// Position of CH3LIMITH field.
	SAADC_INTENSET_CH3LIMITH_Pos = 0xc
	// Bit mask of CH3LIMITH field.
	SAADC_INTENSET_CH3LIMITH_Msk = 0x1000
	// Bit CH3LIMITH.
	SAADC_INTENSET_CH3LIMITH = 0x1000
	// Read: Disabled
	SAADC_INTENSET_CH3LIMITH_Disabled = 0x0
	// Read: Enabled
	SAADC_INTENSET_CH3LIMITH_Enabled = 0x1
	// Enable
	SAADC_INTENSET_CH3LIMITH_Set = 0x1
	// Position of CH3LIMITL field.
	SAADC_INTENSET_CH3LIMITL_Pos = 0xd
	// Bit mask of CH3LIMITL field.
	SAADC_INTENSET_CH3LIMITL_Msk = 0x2000
	// Bit CH3LIMITL.
	SAADC_INTENSET_CH3LIMITL = 0x2000
	// Read: Disabled
	SAADC_INTENSET_CH3LIMITL_Disabled = 0x0
	// Read: Enabled
	SAADC_INTENSET_CH3LIMITL_Enabled = 0x1
	// Enable
	SAADC_INTENSET_CH3LIMITL_Set = 0x1
	// Position of CH4LIMITH field.
	SAADC_INTENSET_CH4LIMITH_Pos = 0xe
	// Bit mask of CH4LIMITH field.
	SAADC_INTENSET_CH4LIMITH_Msk = 0x4000
	// Bit CH4LIMITH.
	SAADC_INTENSET_CH4LIMITH = 0x4000
	// Read: Disabled
	SAADC_INTENSET_CH4LIMITH_Disabled = 0x0
	// Read: Enabled
	SAADC_INTENSET_CH4LIMITH_Enabled = 0x1
	// Enable
	SAADC_INTENSET_CH4LIMITH_Set = 0x1
	// Position of CH4LIMITL field.
	SAADC_INTENSET_CH4LIMITL_Pos = 0xf
	// Bit mask of CH4LIMITL field.
	SAADC_INTENSET_CH4LIMITL_Msk = 0x8000
	// Bit CH4LIMITL.
	SAADC_INTENSET_CH4LIMITL = 0x8000
	// Read: Disabled
	SAADC_INTENSET_CH4LIMITL_Disabled = 0x0
	// Read: Enabled
	SAADC_INTENSET_CH4LIMITL_Enabled = 0x1
	// Enable
	SAADC_INTENSET_CH4LIMITL_Set = 0x1
	// Position of CH5LIMITH field.
	SAADC_INTENSET_CH5LIMITH_Pos = 0x10
	// Bit mask of CH5LIMITH field.
	SAADC_INTENSET_CH5LIMITH_Msk = 0x10000
	// Bit CH5LIMITH.
	SAADC_INTENSET_CH5LIMITH = 0x10000
	// Read: Disabled
	SAADC_INTENSET_CH5LIMITH_Disabled = 0x0
	// Read: Enabled
	SAADC_INTENSET_CH5LIMITH_Enabled = 0x1
	// Enable
	SAADC_INTENSET_CH5LIMITH_Set = 0x1
	// Position of CH5LIMITL field.
	SAADC_INTENSET_CH5LIMITL_Pos = 0x11
	// Bit mask of CH5LIMITL field.
	SAADC_INTENSET_CH5LIMITL_Msk = 0x20000
	// Bit CH5LIMITL.
	SAADC_INTENSET_CH5LIMITL = 0x20000
	// Read: Disabled
	SAADC_INTENSET_CH5LIMITL_Disabled = 0x0
	// Read: Enabled
	SAADC_INTENSET_CH5LIMITL_Enabled = 0x1
	// Enable
	SAADC_INTENSET_CH5LIMITL_Set = 0x1
	// Position of CH6LIMITH field.
	SAADC_INTENSET_CH6LIMITH_Pos = 0x12
	// Bit mask of CH6LIMITH field.
	SAADC_INTENSET_CH6LIMITH_Msk = 0x40000
	// Bit CH6LIMITH.
	SAADC_INTENSET_CH6LIMITH = 0x40000
	// Read: Disabled
	SAADC_INTENSET_CH6LIMITH_Disabled = 0x0
	// Read: Enabled
	SAADC_INTENSET_CH6LIMITH_Enabled = 0x1
	// Enable
	SAADC_INTENSET_CH6LIMITH_Set = 0x1
	// Position of CH6LIMITL field.
	SAADC_INTENSET_CH6LIMITL_Pos = 0x13
	// Bit mask of CH6LIMITL field.
	SAADC_INTENSET_CH6LIMITL_Msk = 0x80000
	// Bit CH6LIMITL.
	SAADC_INTENSET_CH6LIMITL = 0x80000
	// Read: Disabled
	SAADC_INTENSET_CH6LIMITL_Disabled = 0x0
	// Read: Enabled
	SAADC_INTENSET_CH6LIMITL_Enabled = 0x1
	// Enable
	SAADC_INTENSET_CH6LIMITL_Set = 0x1
	// Position of CH7LIMITH field.
	SAADC_INTENSET_CH7LIMITH_Pos = 0x14
	// Bit mask of CH7LIMITH field.
	SAADC_INTENSET_CH7LIMITH_Msk = 0x100000
	// Bit CH7LIMITH.
	SAADC_INTENSET_CH7LIMITH = 0x100000
	// Read: Disabled
	SAADC_INTENSET_CH7LIMITH_Disabled = 0x0
	// Read: Enabled
	SAADC_INTENSET_CH7LIMITH_Enabled = 0x1
	// Enable
	SAADC_INTENSET_CH7LIMITH_Set = 0x1
	// Position of CH7LIMITL field.
	SAADC_INTENSET_CH7LIMITL_Pos = 0x15
	// Bit mask of CH7LIMITL field.
	SAADC_INTENSET_CH7LIMITL_Msk = 0x200000
	// Bit CH7LIMITL.
	SAADC_INTENSET_CH7LIMITL = 0x200000
	// Read: Disabled
	SAADC_INTENSET_CH7LIMITL_Disabled = 0x0
	// Read: Enabled
	SAADC_INTENSET_CH7LIMITL_Enabled = 0x1
	// Enable
	SAADC_INTENSET_CH7LIMITL_Set = 0x1

	// INTENCLR: Disable interrupt
	// Position of STARTED field.
	SAADC_INTENCLR_STARTED_Pos = 0x0
	// Bit mask of STARTED field.
	SAADC_INTENCLR_STARTED_Msk = 0x1
	// Bit STARTED.
	SAADC_INTENCLR_STARTED = 0x1
	// Read: Disabled
	SAADC_INTENCLR_STARTED_Disabled = 0x0
	// Read: Enabled
	SAADC_INTENCLR_STARTED_Enabled = 0x1
	// Disable
	SAADC_INTENCLR_STARTED_Clear = 0x1
	// Position of END field.
	SAADC_INTENCLR_END_Pos = 0x1
	// Bit mask of END field.
	SAADC_INTENCLR_END_Msk = 0x2
	// Bit END.
	SAADC_INTENCLR_END = 0x2
	// Read: Disabled
	SAADC_INTENCLR_END_Disabled = 0x0
	// Read: Enabled
	SAADC_INTENCLR_END_Enabled = 0x1
	// Disable
	SAADC_INTENCLR_END_Clear = 0x1
	// Position of DONE field.
	SAADC_INTENCLR_DONE_Pos = 0x2
	// Bit mask of DONE field.
	SAADC_INTENCLR_DONE_Msk = 0x4
	// Bit DONE.
	SAADC_INTENCLR_DONE = 0x4
	// Read: Disabled
	SAADC_INTENCLR_DONE_Disabled = 0x0
	// Read: Enabled
	SAADC_INTENCLR_DONE_Enabled = 0x1
	// Disable
	SAADC_INTENCLR_DONE_Clear = 0x1
	// Position of RESULTDONE field.
	SAADC_INTENCLR_RESULTDONE_Pos = 0x3
	// Bit mask of RESULTDONE field.
	SAADC_INTENCLR_RESULTDONE_Msk = 0x8
	// Bit RESULTDONE.
	SAADC_INTENCLR_RESULTDONE = 0x8
	// Read: Disabled
	SAADC_INTENCLR_RESULTDONE_Disabled = 0x0
	// Read: Enabled
	SAADC_INTENCLR_RESULTDONE_Enabled = 0x1
	// Disable
	SAADC_INTENCLR_RESULTDONE_Clear = 0x1
	// Position of CALIBRATEDONE field.
	SAADC_INTENCLR_CALIBRATEDONE_Pos = 0x4
	// Bit mask of CALIBRATEDONE field.
	SAADC_INTENCLR_CALIBRATEDONE_Msk = 0x10
	// Bit CALIBRATEDONE.
	SAADC_INTENCLR_CALIBRATEDONE = 0x10
	// Read: Disabled
	SAADC_INTENCLR_CALIBRATEDONE_Disabled = 0x0
	// Read: Enabled
	SAADC_INTENCLR_CALIBRATEDONE_Enabled = 0x1
	// Disable
	SAADC_INTENCLR_CALIBRATEDONE_Clear = 0x1
	// Position of STOPPED field.
	SAADC_INTENCLR_STOPPED_Pos = 0x5
	// Bit mask of STOPPED field.
	SAADC_INTENCLR_STOPPED_Msk = 0x20
	// Bit STOPPED.
	SAADC_INTENCLR_STOPPED = 0x20
	// Read: Disabled
	SAADC_INTENCLR_STOPPED_Disabled = 0x0
	// Read: Enabled
	SAADC_INTENCLR_STOPPED_Enabled = 0x1
	// Disable
	SAADC_INTENCLR_STOPPED_Clear = 0x1
	// Position of CH0LIMITH field.
	SAADC_INTENCLR_CH0LIMITH_Pos = 0x6
	// Bit mask of CH0LIMITH field.
	SAADC_INTENCLR_CH0LIMITH_Msk = 0x40
	// Bit CH0LIMITH.
	SAADC_INTENCLR_CH0LIMITH = 0x40
	// Read: Disabled
	SAADC_INTENCLR_CH0LIMITH_Disabled = 0x0
	// Read: Enabled
	SAADC_INTENCLR_CH0LIMITH_Enabled = 0x1
	// Disable
	SAADC_INTENCLR_CH0LIMITH_Clear = 0x1
	// Position of CH0LIMITL field.
	SAADC_INTENCLR_CH0LIMITL_Pos = 0x7
	// Bit mask of CH0LIMITL field.
	SAADC_INTENCLR_CH0LIMITL_Msk = 0x80
	// Bit CH0LIMITL.
	SAADC_INTENCLR_CH0LIMITL = 0x80
	// Read: Disabled
	SAADC_INTENCLR_CH0LIMITL_Disabled = 0x0
	// Read: Enabled
	SAADC_INTENCLR_CH0LIMITL_Enabled = 0x1
	// Disable
	SAADC_INTENCLR_CH0LIMITL_Clear = 0x1
	// Position of CH1LIMITH field.
	SAADC_INTENCLR_CH1LIMITH_Pos = 0x8
	// Bit mask of CH1LIMITH field.
	SAADC_INTENCLR_CH1LIMITH_Msk = 0x100
	// Bit CH1LIMITH.
	SAADC_INTENCLR_CH1LIMITH = 0x100
	// Read: Disabled
	SAADC_INTENCLR_CH1LIMITH_Disabled = 0x0
	// Read: Enabled
	SAADC_INTENCLR_CH1LIMITH_Enabled = 0x1
	// Disable
	SAADC_INTENCLR_CH1LIMITH_Clear = 0x1
	// Position of CH1LIMITL field.
	SAADC_INTENCLR_CH1LIMITL_Pos = 0x9
	// Bit mask of CH1LIMITL field.
	SAADC_INTENCLR_CH1LIMITL_Msk = 0x200
	// Bit CH1LIMITL.
	SAADC_INTENCLR_CH1LIMITL = 0x200
	// Read: Disabled
	SAADC_INTENCLR_CH1LIMITL_Disabled = 0x0
	// Read: Enabled
	SAADC_INTENCLR_CH1LIMITL_Enabled = 0x1
	// Disable
	SAADC_INTENCLR_CH1LIMITL_Clear = 0x1
	// Position of CH2LIMITH field.
	SAADC_INTENCLR_CH2LIMITH_Pos = 0xa
	// Bit mask of CH2LIMITH field.
	SAADC_INTENCLR_CH2LIMITH_Msk = 0x400
	// Bit CH2LIMITH.
	SAADC_INTENCLR_CH2LIMITH = 0x400
	// Read: Disabled
	SAADC_INTENCLR_CH2LIMITH_Disabled = 0x0
	// Read: Enabled
	SAADC_INTENCLR_CH2LIMITH_Enabled = 0x1
	// Disable
	SAADC_INTENCLR_CH2LIMITH_Clear = 0x1
	// Position of CH2LIMITL field.
	SAADC_INTENCLR_CH2LIMITL_Pos = 0xb
	// Bit mask of CH2LIMITL field.
	SAADC_INTENCLR_CH2LIMITL_Msk = 0x800
	// Bit CH2LIMITL.
	SAADC_INTENCLR_CH2LIMITL = 0x800
	// Read: Disabled
	SAADC_INTENCLR_CH2LIMITL_Disabled = 0x0
	// Read: Enabled
	SAADC_INTENCLR_CH2LIMITL_Enabled = 0x1
	// Disable
	SAADC_INTENCLR_CH2LIMITL_Clear = 0x1
	// Position of CH3LIMITH field.
	SAADC_INTENCLR_CH3LIMITH_Pos = 0xc
	// Bit mask of CH3LIMITH field.
	SAADC_INTENCLR_CH3LIMITH_Msk = 0x1000
	// Bit CH3LIMITH.
	SAADC_INTENCLR_CH3LIMITH = 0x1000
	// Read: Disabled
	SAADC_INTENCLR_CH3LIMITH_Disabled = 0x0
	// Read: Enabled
	SAADC_INTENCLR_CH3LIMITH_Enabled = 0x1
	// Disable
	SAADC_INTENCLR_CH3LIMITH_Clear = 0x1
	// Position of CH3LIMITL field.
	SAADC_INTENCLR_CH3LIMITL_Pos = 0xd
	// Bit mask of CH3LIMITL field.
	SAADC_INTENCLR_CH3LIMITL_Msk = 0x2000
	// Bit CH3LIMITL.
	SAADC_INTENCLR_CH3LIMITL = 0x2000
	// Read: Disabled
	SAADC_INTENCLR_CH3LIMITL_Disabled = 0x0
	// Read: Enabled
	SAADC_INTENCLR_CH3LIMITL_Enabled = 0x1
	// Disable
	SAADC_INTENCLR_CH3LIMITL_Clear = 0x1
	// Position of CH4LIMITH field.
	SAADC_INTENCLR_CH4LIMITH_Pos = 0xe
	// Bit mask of CH4LIMITH field.
	SAADC_INTENCLR_CH4LIMITH_Msk = 0x4000
	// Bit CH4LIMITH.
	SAADC_INTENCLR_CH4LIMITH = 0x4000
	// Read: Disabled
	SAADC_INTENCLR_CH4LIMITH_Disabled = 0x0
	// Read: Enabled
	SAADC_INTENCLR_CH4LIMITH_Enabled = 0x1
	// Disable
	SAADC_INTENCLR_CH4LIMITH_Clear = 0x1
	// Position of CH4LIMITL field.
	SAADC_INTENCLR_CH4LIMITL_Pos = 0xf
	// Bit mask of CH4LIMITL field.
	SAADC_INTENCLR_CH4LIMITL_Msk = 0x8000
	// Bit CH4LIMITL.
	SAADC_INTENCLR_CH4LIMITL = 0x8000
	// Read: Disabled
	SAADC_INTENCLR_CH4LIMITL_Disabled = 0x0
	// Read: Enabled
	SAADC_INTENCLR_CH4LIMITL_Enabled = 0x1
	// Disable
	SAADC_INTENCLR_CH4LIMITL_Clear = 0x1
	// Position of CH5LIMITH field.
	SAADC_INTENCLR_CH5LIMITH_Pos = 0x10
	// Bit mask of CH5LIMITH field.
	SAADC_INTENCLR_CH5LIMITH_Msk = 0x10000
	// Bit CH5LIMITH.
	SAADC_INTENCLR_CH5LIMITH = 0x10000
	// Read: Disabled
	SAADC_INTENCLR_CH5LIMITH_Disabled = 0x0
	// Read: Enabled
	SAADC_INTENCLR_CH5LIMITH_Enabled = 0x1
	// Disable
	SAADC_INTENCLR_CH5LIMITH_Clear = 0x1
	// Position of CH5LIMITL field.
	SAADC_INTENCLR_CH5LIMITL_Pos = 0x11
	// Bit mask of CH5LIMITL field.
	SAADC_INTENCLR_CH5LIMITL_Msk = 0x20000
	// Bit CH5LIMITL.
	SAADC_INTENCLR_CH5LIMITL = 0x20000
	// Read: Disabled
	SAADC_INTENCLR_CH5LIMITL_Disabled = 0x0
	// Read: Enabled
	SAADC_INTENCLR_CH5LIMITL_Enabled = 0x1
	// Disable
	SAADC_INTENCLR_CH5LIMITL_Clear = 0x1
	// Position of CH6LIMITH field.
	SAADC_INTENCLR_CH6LIMITH_Pos = 0x12
	// Bit mask of CH6LIMITH field.
	SAADC_INTENCLR_CH6LIMITH_Msk = 0x40000
	// Bit CH6LIMITH.
	SAADC_INTENCLR_CH6LIMITH = 0x40000
	// Read: Disabled
	SAADC_INTENCLR_CH6LIMITH_Disabled = 0x0
	// Read: Enabled
	SAADC_INTENCLR_CH6LIMITH_Enabled = 0x1
	// Disable
	SAADC_INTENCLR_CH6LIMITH_Clear = 0x1
	// Position of CH6LIMITL field.
	SAADC_INTENCLR_CH6LIMITL_Pos = 0x13
	// Bit mask of CH6LIMITL field.
	SAADC_INTENCLR_CH6LIMITL_Msk = 0x80000
	// Bit CH6LIMITL.
	SAADC_INTENCLR_CH6LIMITL = 0x80000
	// Read: Disabled
	SAADC_INTENCLR_CH6LIMITL_Disabled = 0x0
	// Read: Enabled
	SAADC_INTENCLR_CH6LIMITL_Enabled = 0x1
	// Disable
	SAADC_INTENCLR_CH6LIMITL_Clear = 0x1
	// Position of CH7LIMITH field.
	SAADC_INTENCLR_CH7LIMITH_Pos = 0x14
	// Bit mask of CH7LIMITH field.
	SAADC_INTENCLR_CH7LIMITH_Msk = 0x100000
	// Bit CH7LIMITH.
	SAADC_INTENCLR_CH7LIMITH = 0x100000
	// Read: Disabled
	SAADC_INTENCLR_CH7LIMITH_Disabled = 0x0
	// Read: Enabled
	SAADC_INTENCLR_CH7LIMITH_Enabled = 0x1
	// Disable
	SAADC_INTENCLR_CH7LIMITH_Clear = 0x1
	// Position of CH7LIMITL field.
	SAADC_INTENCLR_CH7LIMITL_Pos = 0x15
	// Bit mask of CH7LIMITL field.
	SAADC_INTENCLR_CH7LIMITL_Msk = 0x200000
	// Bit CH7LIMITL.
	SAADC_INTENCLR_CH7LIMITL = 0x200000
	// Read: Disabled
	SAADC_INTENCLR_CH7LIMITL_Disabled = 0x0
	// Read: Enabled
	SAADC_INTENCLR_CH7LIMITL_Enabled = 0x1
	// Disable
	SAADC_INTENCLR_CH7LIMITL_Clear = 0x1

	// STATUS: Status
	// Position of STATUS field.
	SAADC_STATUS_STATUS_Pos = 0x0
	// Bit mask of STATUS field.
	SAADC_STATUS_STATUS_Msk = 0x1
	// Bit STATUS.
	SAADC_STATUS_STATUS = 0x1
	// SAADC is ready. No on-going conversions.
	SAADC_STATUS_STATUS_Ready = 0x0
	// SAADC is busy. Conversion in progress.
	SAADC_STATUS_STATUS_Busy = 0x1

	// ENABLE: Enable or disable SAADC
	// Position of ENABLE field.
	SAADC_ENABLE_ENABLE_Pos = 0x0
	// Bit mask of ENABLE field.
	SAADC_ENABLE_ENABLE_Msk = 0x1
	// Bit ENABLE.
	SAADC_ENABLE_ENABLE = 0x1
	// Disable SAADC
	SAADC_ENABLE_ENABLE_Disabled = 0x0
	// Enable SAADC
	SAADC_ENABLE_ENABLE_Enabled = 0x1

	// CH.PSELP: Description cluster: Input positive pin selection for CH[n]
	// Position of PSELP field.
	SAADC_CH_PSELP_PSELP_Pos = 0x0
	// Bit mask of PSELP field.
	SAADC_CH_PSELP_PSELP_Msk = 0x1f
	// Not connected
	SAADC_CH_PSELP_PSELP_NC = 0x0
	// AIN0
	SAADC_CH_PSELP_PSELP_AnalogInput0 = 0x1
	// AIN1
	SAADC_CH_PSELP_PSELP_AnalogInput1 = 0x2
	// AIN2
	SAADC_CH_PSELP_PSELP_AnalogInput2 = 0x3
	// AIN3
	SAADC_CH_PSELP_PSELP_AnalogInput3 = 0x4
	// AIN4
	SAADC_CH_PSELP_PSELP_AnalogInput4 = 0x5
	// AIN5
	SAADC_CH_PSELP_PSELP_AnalogInput5 = 0x6
	// AIN6
	SAADC_CH_PSELP_PSELP_AnalogInput6 = 0x7
	// AIN7
	SAADC_CH_PSELP_PSELP_AnalogInput7 = 0x8
	// VDD
	SAADC_CH_PSELP_PSELP_VDD = 0x9
	// VDDH/5
	SAADC_CH_PSELP_PSELP_VDDHDIV5 = 0xd

	// CH.PSELN: Description cluster: Input negative pin selection for CH[n]
	// Position of PSELN field.
	SAADC_CH_PSELN_PSELN_Pos = 0x0
	// Bit mask of PSELN field.
	SAADC_CH_PSELN_PSELN_Msk = 0x1f
	// Not connected
	SAADC_CH_PSELN_PSELN_NC = 0x0
	// AIN0
	SAADC_CH_PSELN_PSELN_AnalogInput0 = 0x1
	// AIN1
	SAADC_CH_PSELN_PSELN_AnalogInput1 = 0x2
	// AIN2
	SAADC_CH_PSELN_PSELN_AnalogInput2 = 0x3
	// AIN3
	SAADC_CH_PSELN_PSELN_AnalogInput3 = 0x4
	// AIN4
	SAADC_CH_PSELN_PSELN_AnalogInput4 = 0x5
	// AIN5
	SAADC_CH_PSELN_PSELN_AnalogInput5 = 0x6
	// AIN6
	SAADC_CH_PSELN_PSELN_AnalogInput6 = 0x7
	// AIN7
	SAADC_CH_PSELN_PSELN_AnalogInput7 = 0x8
	// VDD
	SAADC_CH_PSELN_PSELN_VDD = 0x9
	// VDDH/5
	SAADC_CH_PSELN_PSELN_VDDHDIV5 = 0xd

	// CH.CONFIG: Description cluster: Input configuration for CH[n]
	// Position of RESP field.
	SAADC_CH_CONFIG_RESP_Pos = 0x0
	// Bit mask of RESP field.
	SAADC_CH_CONFIG_RESP_Msk = 0x3
	// Bypass resistor ladder
	SAADC_CH_CONFIG_RESP_Bypass = 0x0
	// Pull-down to GND
	SAADC_CH_CONFIG_RESP_Pulldown = 0x1
	// Pull-up to VDD
	SAADC_CH_CONFIG_RESP_Pullup = 0x2
	// Set input at VDD/2
	SAADC_CH_CONFIG_RESP_VDD1_2 = 0x3
	// Position of RESN field.
	SAADC_CH_CONFIG_RESN_Pos = 0x4
	// Bit mask of RESN field.
	SAADC_CH_CONFIG_RESN_Msk = 0x30
	// Bypass resistor ladder
	SAADC_CH_CONFIG_RESN_Bypass = 0x0
	// Pull-down to GND
	SAADC_CH_CONFIG_RESN_Pulldown = 0x1
	// Pull-up to VDD
	SAADC_CH_CONFIG_RESN_Pullup = 0x2
	// Set input at VDD/2
	SAADC_CH_CONFIG_RESN_VDD1_2 = 0x3
	// Position of GAIN field.
	SAADC_CH_CONFIG_GAIN_Pos = 0x8
	// Bit mask of GAIN field.
	SAADC_CH_CONFIG_GAIN_Msk = 0x700
	// 1/6
	SAADC_CH_CONFIG_GAIN_Gain1_6 = 0x0
	// 1/5
	SAADC_CH_CONFIG_GAIN_Gain1_5 = 0x1
	// 1/4
	SAADC_CH_CONFIG_GAIN_Gain1_4 = 0x2
	// 1/3
	SAADC_CH_CONFIG_GAIN_Gain1_3 = 0x3
	// 1/2
	SAADC_CH_CONFIG_GAIN_Gain1_2 = 0x4
	// 1
	SAADC_CH_CONFIG_GAIN_Gain1 = 0x5
	// 2
	SAADC_CH_CONFIG_GAIN_Gain2 = 0x6
	// 4
	SAADC_CH_CONFIG_GAIN_Gain4 = 0x7
	// Position of REFSEL field.
	SAADC_CH_CONFIG_REFSEL_Pos = 0xc
	// Bit mask of REFSEL field.
	SAADC_CH_CONFIG_REFSEL_Msk = 0x1000
	// Bit REFSEL.
	SAADC_CH_CONFIG_REFSEL = 0x1000
	// Internal reference (0.6 V)
	SAADC_CH_CONFIG_REFSEL_Internal = 0x0
	// VDD/4 as reference
	SAADC_CH_CONFIG_REFSEL_VDD1_4 = 0x1
	// Position of TACQ field.
	SAADC_CH_CONFIG_TACQ_Pos = 0x10
	// Bit mask of TACQ field.
	SAADC_CH_CONFIG_TACQ_Msk = 0x70000
	// 3 us
	SAADC_CH_CONFIG_TACQ_3us = 0x0
	// 5 us
	SAADC_CH_CONFIG_TACQ_5us = 0x1
	// 10 us
	SAADC_CH_CONFIG_TACQ_10us = 0x2
	// 15 us
	SAADC_CH_CONFIG_TACQ_15us = 0x3
	// 20 us
	SAADC_CH_CONFIG_TACQ_20us = 0x4
	// 40 us
	SAADC_CH_CONFIG_TACQ_40us = 0x5
	// Position of MODE field.
	SAADC_CH_CONFIG_MODE_Pos = 0x14
	// Bit mask of MODE field.
	SAADC_CH_CONFIG_MODE_Msk = 0x100000
	// Bit MODE.
	SAADC_CH_CONFIG_MODE = 0x100000
	// Single-ended, PSELN will be ignored, negative input to SAADC shorted to GND
	SAADC_CH_CONFIG_MODE_SE = 0x0
	// Differential
	SAADC_CH_CONFIG_MODE_Diff = 0x1
	// Position of BURST field.
	SAADC_CH_CONFIG_BURST_Pos = 0x18
	// Bit mask of BURST field.
	SAADC_CH_CONFIG_BURST_Msk = 0x1000000
	// Bit BURST.
	SAADC_CH_CONFIG_BURST = 0x1000000
	// Burst mode is disabled (normal operation)
	SAADC_CH_CONFIG_BURST_Disabled = 0x0
	// Burst mode is enabled. SAADC takes 2^OVERSAMPLE number of samples as fast as it can, and sends the average to Data RAM.
	SAADC_CH_CONFIG_BURST_Enabled = 0x1

	// CH.LIMIT: Description cluster: High/low limits for event monitoring of a channel
	// Position of LOW field.
	SAADC_CH_LIMIT_LOW_Pos = 0x0
	// Bit mask of LOW field.
	SAADC_CH_LIMIT_LOW_Msk = 0xffff
	// Position of HIGH field.
	SAADC_CH_LIMIT_HIGH_Pos = 0x10
	// Bit mask of HIGH field.
	SAADC_CH_LIMIT_HIGH_Msk = 0xffff0000

	// RESOLUTION: Resolution configuration
	// Position of VAL field.
	SAADC_RESOLUTION_VAL_Pos = 0x0
	// Bit mask of VAL field.
	SAADC_RESOLUTION_VAL_Msk = 0x7
	// 8 bits
	SAADC_RESOLUTION_VAL_8bit = 0x0
	// 10 bits
	SAADC_RESOLUTION_VAL_10bit = 0x1
	// 12 bits
	SAADC_RESOLUTION_VAL_12bit = 0x2
	// 14 bits
	SAADC_RESOLUTION_VAL_14bit = 0x3

	// OVERSAMPLE: Oversampling configuration. The RESOLUTION is applied before averaging, thus for high OVERSAMPLE a higher RESOLUTION should be used.
	// Position of OVERSAMPLE field.
	SAADC_OVERSAMPLE_OVERSAMPLE_Pos = 0x0
	// Bit mask of OVERSAMPLE field.
	SAADC_OVERSAMPLE_OVERSAMPLE_Msk = 0xf
	// Bypass oversampling
	SAADC_OVERSAMPLE_OVERSAMPLE_Bypass = 0x0
	// Oversample 2x
	SAADC_OVERSAMPLE_OVERSAMPLE_Over2x = 0x1
	// Oversample 4x
	SAADC_OVERSAMPLE_OVERSAMPLE_Over4x = 0x2
	// Oversample 8x
	SAADC_OVERSAMPLE_OVERSAMPLE_Over8x = 0x3
	// Oversample 16x
	SAADC_OVERSAMPLE_OVERSAMPLE_Over16x = 0x4
	// Oversample 32x
	SAADC_OVERSAMPLE_OVERSAMPLE_Over32x = 0x5
	// Oversample 64x
	SAADC_OVERSAMPLE_OVERSAMPLE_Over64x = 0x6
	// Oversample 128x
	SAADC_OVERSAMPLE_OVERSAMPLE_Over128x = 0x7
	// Oversample 256x
	SAADC_OVERSAMPLE_OVERSAMPLE_Over256x = 0x8

	// SAMPLERATE: Controls normal or continuous sample rate
	// Position of CC field.
	SAADC_SAMPLERATE_CC_Pos = 0x0
	// Bit mask of CC field.
	SAADC_SAMPLERATE_CC_Msk = 0x7ff
	// Position of MODE field.
	SAADC_SAMPLERATE_MODE_Pos = 0xc
	// Bit mask of MODE field.
	SAADC_SAMPLERATE_MODE_Msk = 0x1000
	// Bit MODE.
	SAADC_SAMPLERATE_MODE = 0x1000
	// Rate is controlled from SAMPLE task
	SAADC_SAMPLERATE_MODE_Task = 0x0
	// Rate is controlled from local timer (use CC to control the rate)
	SAADC_SAMPLERATE_MODE_Timers = 0x1

	// RESULT.PTR: Data pointer
	// Position of PTR field.
	SAADC_RESULT_PTR_PTR_Pos = 0x0
	// Bit mask of PTR field.
	SAADC_RESULT_PTR_PTR_Msk = 0xffffffff

	// RESULT.MAXCNT: Maximum number of 16-bit samples to be written to output RAM buffer
	// Position of MAXCNT field.
	SAADC_RESULT_MAXCNT_MAXCNT_Pos = 0x0
	// Bit mask of MAXCNT field.
	SAADC_RESULT_MAXCNT_MAXCNT_Msk = 0x7fff

	// RESULT.AMOUNT: Number of 16-bit samples written to output RAM buffer since the previous START task
	// Position of AMOUNT field.
	SAADC_RESULT_AMOUNT_AMOUNT_Pos = 0x0
	// Bit mask of AMOUNT field.
	SAADC_RESULT_AMOUNT_AMOUNT_Msk = 0x7fff
)

// Bitfields for TIMER0: Timer/Counter 0
const (
	// TASKS_START: Start Timer
	// Position of TASKS_START field.
	TIMER_TASKS_START_TASKS_START_Pos = 0x0
	// Bit mask of TASKS_START field.
	TIMER_TASKS_START_TASKS_START_Msk = 0x1
	// Bit TASKS_START.
	TIMER_TASKS_START_TASKS_START = 0x1
	// Trigger task
	TIMER_TASKS_START_TASKS_START_Trigger = 0x1

	// TASKS_STOP: Stop Timer
	// Position of TASKS_STOP field.
	TIMER_TASKS_STOP_TASKS_STOP_Pos = 0x0
	// Bit mask of TASKS_STOP field.
	TIMER_TASKS_STOP_TASKS_STOP_Msk = 0x1
	// Bit TASKS_STOP.
	TIMER_TASKS_STOP_TASKS_STOP = 0x1
	// Trigger task
	TIMER_TASKS_STOP_TASKS_STOP_Trigger = 0x1

	// TASKS_COUNT: Increment Timer (Counter mode only)
	// Position of TASKS_COUNT field.
	TIMER_TASKS_COUNT_TASKS_COUNT_Pos = 0x0
	// Bit mask of TASKS_COUNT field.
	TIMER_TASKS_COUNT_TASKS_COUNT_Msk = 0x1
	// Bit TASKS_COUNT.
	TIMER_TASKS_COUNT_TASKS_COUNT = 0x1
	// Trigger task
	TIMER_TASKS_COUNT_TASKS_COUNT_Trigger = 0x1

	// TASKS_CLEAR: Clear time
	// Position of TASKS_CLEAR field.
	TIMER_TASKS_CLEAR_TASKS_CLEAR_Pos = 0x0
	// Bit mask of TASKS_CLEAR field.
	TIMER_TASKS_CLEAR_TASKS_CLEAR_Msk = 0x1
	// Bit TASKS_CLEAR.
	TIMER_TASKS_CLEAR_TASKS_CLEAR = 0x1
	// Trigger task
	TIMER_TASKS_CLEAR_TASKS_CLEAR_Trigger = 0x1

	// TASKS_SHUTDOWN: Deprecated register - Shut down timer
	// Position of TASKS_SHUTDOWN field.
	TIMER_TASKS_SHUTDOWN_TASKS_SHUTDOWN_Pos = 0x0
	// Bit mask of TASKS_SHUTDOWN field.
	TIMER_TASKS_SHUTDOWN_TASKS_SHUTDOWN_Msk = 0x1
	// Bit TASKS_SHUTDOWN.
	TIMER_TASKS_SHUTDOWN_TASKS_SHUTDOWN = 0x1
	// Trigger task
	TIMER_TASKS_SHUTDOWN_TASKS_SHUTDOWN_Trigger = 0x1

	// TASKS_CAPTURE: Description collection: Capture Timer value to CC[n] register
	// Position of TASKS_CAPTURE field.
	TIMER_TASKS_CAPTURE_TASKS_CAPTURE_Pos = 0x0
	// Bit mask of TASKS_CAPTURE field.
	TIMER_TASKS_CAPTURE_TASKS_CAPTURE_Msk = 0x1
	// Bit TASKS_CAPTURE.
	TIMER_TASKS_CAPTURE_TASKS_CAPTURE = 0x1
	// Trigger task
	TIMER_TASKS_CAPTURE_TASKS_CAPTURE_Trigger = 0x1

	// EVENTS_COMPARE: Description collection: Compare event on CC[n] match
	// Position of EVENTS_COMPARE field.
	TIMER_EVENTS_COMPARE_EVENTS_COMPARE_Pos = 0x0
	// Bit mask of EVENTS_COMPARE field.
	TIMER_EVENTS_COMPARE_EVENTS_COMPARE_Msk = 0x1
	// Bit EVENTS_COMPARE.
	TIMER_EVENTS_COMPARE_EVENTS_COMPARE = 0x1
	// Event not generated
	TIMER_EVENTS_COMPARE_EVENTS_COMPARE_NotGenerated = 0x0
	// Event generated
	TIMER_EVENTS_COMPARE_EVENTS_COMPARE_Generated = 0x1

	// SHORTS: Shortcuts between local events and tasks
	// Position of COMPARE0_CLEAR field.
	TIMER_SHORTS_COMPARE0_CLEAR_Pos = 0x0
	// Bit mask of COMPARE0_CLEAR field.
	TIMER_SHORTS_COMPARE0_CLEAR_Msk = 0x1
	// Bit COMPARE0_CLEAR.
	TIMER_SHORTS_COMPARE0_CLEAR = 0x1
	// Disable shortcut
	TIMER_SHORTS_COMPARE0_CLEAR_Disabled = 0x0
	// Enable shortcut
	TIMER_SHORTS_COMPARE0_CLEAR_Enabled = 0x1
	// Position of COMPARE1_CLEAR field.
	TIMER_SHORTS_COMPARE1_CLEAR_Pos = 0x1
	// Bit mask of COMPARE1_CLEAR field.
	TIMER_SHORTS_COMPARE1_CLEAR_Msk = 0x2
	// Bit COMPARE1_CLEAR.
	TIMER_SHORTS_COMPARE1_CLEAR = 0x2
	// Disable shortcut
	TIMER_SHORTS_COMPARE1_CLEAR_Disabled = 0x0
	// Enable shortcut
	TIMER_SHORTS_COMPARE1_CLEAR_Enabled = 0x1
	// Position of COMPARE2_CLEAR field.
	TIMER_SHORTS_COMPARE2_CLEAR_Pos = 0x2
	// Bit mask of COMPARE2_CLEAR field.
	TIMER_SHORTS_COMPARE2_CLEAR_Msk = 0x4
	// Bit COMPARE2_CLEAR.
	TIMER_SHORTS_COMPARE2_CLEAR = 0x4
	// Disable shortcut
	TIMER_SHORTS_COMPARE2_CLEAR_Disabled = 0x0
	// Enable shortcut
	TIMER_SHORTS_COMPARE2_CLEAR_Enabled = 0x1
	// Position of COMPARE3_CLEAR field.
	TIMER_SHORTS_COMPARE3_CLEAR_Pos = 0x3
	// Bit mask of COMPARE3_CLEAR field.
	TIMER_SHORTS_COMPARE3_CLEAR_Msk = 0x8
	// Bit COMPARE3_CLEAR.
	TIMER_SHORTS_COMPARE3_CLEAR = 0x8
	// Disable shortcut
	TIMER_SHORTS_COMPARE3_CLEAR_Disabled = 0x0
	// Enable shortcut
	TIMER_SHORTS_COMPARE3_CLEAR_Enabled = 0x1
	// Position of COMPARE4_CLEAR field.
	TIMER_SHORTS_COMPARE4_CLEAR_Pos = 0x4
	// Bit mask of COMPARE4_CLEAR field.
	TIMER_SHORTS_COMPARE4_CLEAR_Msk = 0x10
	// Bit COMPARE4_CLEAR.
	TIMER_SHORTS_COMPARE4_CLEAR = 0x10
	// Disable shortcut
	TIMER_SHORTS_COMPARE4_CLEAR_Disabled = 0x0
	// Enable shortcut
	TIMER_SHORTS_COMPARE4_CLEAR_Enabled = 0x1
	// Position of COMPARE5_CLEAR field.
	TIMER_SHORTS_COMPARE5_CLEAR_Pos = 0x5
	// Bit mask of COMPARE5_CLEAR field.
	TIMER_SHORTS_COMPARE5_CLEAR_Msk = 0x20
	// Bit COMPARE5_CLEAR.
	TIMER_SHORTS_COMPARE5_CLEAR = 0x20
	// Disable shortcut
	TIMER_SHORTS_COMPARE5_CLEAR_Disabled = 0x0
	// Enable shortcut
	TIMER_SHORTS_COMPARE5_CLEAR_Enabled = 0x1
	// Position of COMPARE0_STOP field.
	TIMER_SHORTS_COMPARE0_STOP_Pos = 0x8
	// Bit mask of COMPARE0_STOP field.
	TIMER_SHORTS_COMPARE0_STOP_Msk = 0x100
	// Bit COMPARE0_STOP.
	TIMER_SHORTS_COMPARE0_STOP = 0x100
	// Disable shortcut
	TIMER_SHORTS_COMPARE0_STOP_Disabled = 0x0
	// Enable shortcut
	TIMER_SHORTS_COMPARE0_STOP_Enabled = 0x1
	// Position of COMPARE1_STOP field.
	TIMER_SHORTS_COMPARE1_STOP_Pos = 0x9
	// Bit mask of COMPARE1_STOP field.
	TIMER_SHORTS_COMPARE1_STOP_Msk = 0x200
	// Bit COMPARE1_STOP.
	TIMER_SHORTS_COMPARE1_STOP = 0x200
	// Disable shortcut
	TIMER_SHORTS_COMPARE1_STOP_Disabled = 0x0
	// Enable shortcut
	TIMER_SHORTS_COMPARE1_STOP_Enabled = 0x1
	// Position of COMPARE2_STOP field.
	TIMER_SHORTS_COMPARE2_STOP_Pos = 0xa
	// Bit mask of COMPARE2_STOP field.
	TIMER_SHORTS_COMPARE2_STOP_Msk = 0x400
	// Bit COMPARE2_STOP.
	TIMER_SHORTS_COMPARE2_STOP = 0x400
	// Disable shortcut
	TIMER_SHORTS_COMPARE2_STOP_Disabled = 0x0
	// Enable shortcut
	TIMER_SHORTS_COMPARE2_STOP_Enabled = 0x1
	// Position of COMPARE3_STOP field.
	TIMER_SHORTS_COMPARE3_STOP_Pos = 0xb
	// Bit mask of COMPARE3_STOP field.
	TIMER_SHORTS_COMPARE3_STOP_Msk = 0x800
	// Bit COMPARE3_STOP.
	TIMER_SHORTS_COMPARE3_STOP = 0x800
	// Disable shortcut
	TIMER_SHORTS_COMPARE3_STOP_Disabled = 0x0
	// Enable shortcut
	TIMER_SHORTS_COMPARE3_STOP_Enabled = 0x1
	// Position of COMPARE4_STOP field.
	TIMER_SHORTS_COMPARE4_STOP_Pos = 0xc
	// Bit mask of COMPARE4_STOP field.
	TIMER_SHORTS_COMPARE4_STOP_Msk = 0x1000
	// Bit COMPARE4_STOP.
	TIMER_SHORTS_COMPARE4_STOP = 0x1000
	// Disable shortcut
	TIMER_SHORTS_COMPARE4_STOP_Disabled = 0x0
	// Enable shortcut
	TIMER_SHORTS_COMPARE4_STOP_Enabled = 0x1
	// Position of COMPARE5_STOP field.
	TIMER_SHORTS_COMPARE5_STOP_Pos = 0xd
	// Bit mask of COMPARE5_STOP field.
	TIMER_SHORTS_COMPARE5_STOP_Msk = 0x2000
	// Bit COMPARE5_STOP.
	TIMER_SHORTS_COMPARE5_STOP = 0x2000
	// Disable shortcut
	TIMER_SHORTS_COMPARE5_STOP_Disabled = 0x0
	// Enable shortcut
	TIMER_SHORTS_COMPARE5_STOP_Enabled = 0x1

	// INTENSET: Enable interrupt
	// Position of COMPARE0 field.
	TIMER_INTENSET_COMPARE0_Pos = 0x10
	// Bit mask of COMPARE0 field.
	TIMER_INTENSET_COMPARE0_Msk = 0x10000
	// Bit COMPARE0.
	TIMER_INTENSET_COMPARE0 = 0x10000
	// Read: Disabled
	TIMER_INTENSET_COMPARE0_Disabled = 0x0
	// Read: Enabled
	TIMER_INTENSET_COMPARE0_Enabled = 0x1
	// Enable
	TIMER_INTENSET_COMPARE0_Set = 0x1
	// Position of COMPARE1 field.
	TIMER_INTENSET_COMPARE1_Pos = 0x11
	// Bit mask of COMPARE1 field.
	TIMER_INTENSET_COMPARE1_Msk = 0x20000
	// Bit COMPARE1.
	TIMER_INTENSET_COMPARE1 = 0x20000
	// Read: Disabled
	TIMER_INTENSET_COMPARE1_Disabled = 0x0
	// Read: Enabled
	TIMER_INTENSET_COMPARE1_Enabled = 0x1
	// Enable
	TIMER_INTENSET_COMPARE1_Set = 0x1
	// Position of COMPARE2 field.
	TIMER_INTENSET_COMPARE2_Pos = 0x12
	// Bit mask of COMPARE2 field.
	TIMER_INTENSET_COMPARE2_Msk = 0x40000
	// Bit COMPARE2.
	TIMER_INTENSET_COMPARE2 = 0x40000
	// Read: Disabled
	TIMER_INTENSET_COMPARE2_Disabled = 0x0
	// Read: Enabled
	TIMER_INTENSET_COMPARE2_Enabled = 0x1
	// Enable
	TIMER_INTENSET_COMPARE2_Set = 0x1
	// Position of COMPARE3 field.
	TIMER_INTENSET_COMPARE3_Pos = 0x13
	// Bit mask of COMPARE3 field.
	TIMER_INTENSET_COMPARE3_Msk = 0x80000
	// Bit COMPARE3.
	TIMER_INTENSET_COMPARE3 = 0x80000
	// Read: Disabled
	TIMER_INTENSET_COMPARE3_Disabled = 0x0
	// Read: Enabled
	TIMER_INTENSET_COMPARE3_Enabled = 0x1
	// Enable
	TIMER_INTENSET_COMPARE3_Set = 0x1
	// Position of COMPARE4 field.
	TIMER_INTENSET_COMPARE4_Pos = 0x14
	// Bit mask of COMPARE4 field.
	TIMER_INTENSET_COMPARE4_Msk = 0x100000
	// Bit COMPARE4.
	TIMER_INTENSET_COMPARE4 = 0x100000
	// Read: Disabled
	TIMER_INTENSET_COMPARE4_Disabled = 0x0
	// Read: Enabled
	TIMER_INTENSET_COMPARE4_Enabled = 0x1
	// Enable
	TIMER_INTENSET_COMPARE4_Set = 0x1
	// Position of COMPARE5 field.
	TIMER_INTENSET_COMPARE5_Pos = 0x15
	// Bit mask of COMPARE5 field.
	TIMER_INTENSET_COMPARE5_Msk = 0x200000
	// Bit COMPARE5.
	TIMER_INTENSET_COMPARE5 = 0x200000
	// Read: Disabled
	TIMER_INTENSET_COMPARE5_Disabled = 0x0
	// Read: Enabled
	TIMER_INTENSET_COMPARE5_Enabled = 0x1
	// Enable
	TIMER_INTENSET_COMPARE5_Set = 0x1

	// INTENCLR: Disable interrupt
	// Position of COMPARE0 field.
	TIMER_INTENCLR_COMPARE0_Pos = 0x10
	// Bit mask of COMPARE0 field.
	TIMER_INTENCLR_COMPARE0_Msk = 0x10000
	// Bit COMPARE0.
	TIMER_INTENCLR_COMPARE0 = 0x10000
	// Read: Disabled
	TIMER_INTENCLR_COMPARE0_Disabled = 0x0
	// Read: Enabled
	TIMER_INTENCLR_COMPARE0_Enabled = 0x1
	// Disable
	TIMER_INTENCLR_COMPARE0_Clear = 0x1
	// Position of COMPARE1 field.
	TIMER_INTENCLR_COMPARE1_Pos = 0x11
	// Bit mask of COMPARE1 field.
	TIMER_INTENCLR_COMPARE1_Msk = 0x20000
	// Bit COMPARE1.
	TIMER_INTENCLR_COMPARE1 = 0x20000
	// Read: Disabled
	TIMER_INTENCLR_COMPARE1_Disabled = 0x0
	// Read: Enabled
	TIMER_INTENCLR_COMPARE1_Enabled = 0x1
	// Disable
	TIMER_INTENCLR_COMPARE1_Clear = 0x1
	// Position of COMPARE2 field.
	TIMER_INTENCLR_COMPARE2_Pos = 0x12
	// Bit mask of COMPARE2 field.
	TIMER_INTENCLR_COMPARE2_Msk = 0x40000
	// Bit COMPARE2.
	TIMER_INTENCLR_COMPARE2 = 0x40000
	// Read: Disabled
	TIMER_INTENCLR_COMPARE2_Disabled = 0x0
	// Read: Enabled
	TIMER_INTENCLR_COMPARE2_Enabled = 0x1
	// Disable
	TIMER_INTENCLR_COMPARE2_Clear = 0x1
	// Position of COMPARE3 field.
	TIMER_INTENCLR_COMPARE3_Pos = 0x13
	// Bit mask of COMPARE3 field.
	TIMER_INTENCLR_COMPARE3_Msk = 0x80000
	// Bit COMPARE3.
	TIMER_INTENCLR_COMPARE3 = 0x80000
	// Read: Disabled
	TIMER_INTENCLR_COMPARE3_Disabled = 0x0
	// Read: Enabled
	TIMER_INTENCLR_COMPARE3_Enabled = 0x1
	// Disable
	TIMER_INTENCLR_COMPARE3_Clear = 0x1
	// Position of COMPARE4 field.
	TIMER_INTENCLR_COMPARE4_Pos = 0x14
	// Bit mask of COMPARE4 field.
	TIMER_INTENCLR_COMPARE4_Msk = 0x100000
	// Bit COMPARE4.
	TIMER_INTENCLR_COMPARE4 = 0x100000
	// Read: Disabled
	TIMER_INTENCLR_COMPARE4_Disabled = 0x0
	// Read: Enabled
	TIMER_INTENCLR_COMPARE4_Enabled = 0x1
	// Disable
	TIMER_INTENCLR_COMPARE4_Clear = 0x1
	// Position of COMPARE5 field.
	TIMER_INTENCLR_COMPARE5_Pos = 0x15
	// Bit mask of COMPARE5 field.
	TIMER_INTENCLR_COMPARE5_Msk = 0x200000
	// Bit COMPARE5.
	TIMER_INTENCLR_COMPARE5 = 0x200000
	// Read: Disabled
	TIMER_INTENCLR_COMPARE5_Disabled = 0x0
	// Read: Enabled
	TIMER_INTENCLR_COMPARE5_Enabled = 0x1
	// Disable
	TIMER_INTENCLR_COMPARE5_Clear = 0x1

	// MODE: Timer mode selection
	// Position of MODE field.
	TIMER_MODE_MODE_Pos = 0x0
	// Bit mask of MODE field.
	TIMER_MODE_MODE_Msk = 0x3
	// Select Timer mode
	TIMER_MODE_MODE_Timer = 0x0
	// Deprecated enumerator - Select Counter mode
	TIMER_MODE_MODE_Counter = 0x1
	// Select Low Power Counter mode
	TIMER_MODE_MODE_LowPowerCounter = 0x2

	// BITMODE: Configure the number of bits used by the TIMER
	// Position of BITMODE field.
	TIMER_BITMODE_BITMODE_Pos = 0x0
	// Bit mask of BITMODE field.
	TIMER_BITMODE_BITMODE_Msk = 0x3
	// 16 bit timer bit width
	TIMER_BITMODE_BITMODE_16Bit = 0x0
	// 8 bit timer bit width
	TIMER_BITMODE_BITMODE_08Bit = 0x1
	// 24 bit timer bit width
	TIMER_BITMODE_BITMODE_24Bit = 0x2
	// 32 bit timer bit width
	TIMER_BITMODE_BITMODE_32Bit = 0x3

	// PRESCALER: Timer prescaler register
	// Position of PRESCALER field.
	TIMER_PRESCALER_PRESCALER_Pos = 0x0
	// Bit mask of PRESCALER field.
	TIMER_PRESCALER_PRESCALER_Msk = 0xf

	// CC: Description collection: Capture/Compare register n
	// Position of CC field.
	TIMER_CC_CC_Pos = 0x0
	// Bit mask of CC field.
	TIMER_CC_CC_Msk = 0xffffffff
)

// Bitfields for RTC0: Real time counter 0
const (
	// TASKS_START: Start RTC COUNTER
	// Position of TASKS_START field.
	RTC_TASKS_START_TASKS_START_Pos = 0x0
	// Bit mask of TASKS_START field.
	RTC_TASKS_START_TASKS_START_Msk = 0x1
	// Bit TASKS_START.
	RTC_TASKS_START_TASKS_START = 0x1
	// Trigger task
	RTC_TASKS_START_TASKS_START_Trigger = 0x1

	// TASKS_STOP: Stop RTC COUNTER
	// Position of TASKS_STOP field.
	RTC_TASKS_STOP_TASKS_STOP_Pos = 0x0
	// Bit mask of TASKS_STOP field.
	RTC_TASKS_STOP_TASKS_STOP_Msk = 0x1
	// Bit TASKS_STOP.
	RTC_TASKS_STOP_TASKS_STOP = 0x1
	// Trigger task
	RTC_TASKS_STOP_TASKS_STOP_Trigger = 0x1

	// TASKS_CLEAR: Clear RTC COUNTER
	// Position of TASKS_CLEAR field.
	RTC_TASKS_CLEAR_TASKS_CLEAR_Pos = 0x0
	// Bit mask of TASKS_CLEAR field.
	RTC_TASKS_CLEAR_TASKS_CLEAR_Msk = 0x1
	// Bit TASKS_CLEAR.
	RTC_TASKS_CLEAR_TASKS_CLEAR = 0x1
	// Trigger task
	RTC_TASKS_CLEAR_TASKS_CLEAR_Trigger = 0x1

	// TASKS_TRIGOVRFLW: Set COUNTER to 0xFFFFF0
	// Position of TASKS_TRIGOVRFLW field.
	RTC_TASKS_TRIGOVRFLW_TASKS_TRIGOVRFLW_Pos = 0x0
	// Bit mask of TASKS_TRIGOVRFLW field.
	RTC_TASKS_TRIGOVRFLW_TASKS_TRIGOVRFLW_Msk = 0x1
	// Bit TASKS_TRIGOVRFLW.
	RTC_TASKS_TRIGOVRFLW_TASKS_TRIGOVRFLW = 0x1
	// Trigger task
	RTC_TASKS_TRIGOVRFLW_TASKS_TRIGOVRFLW_Trigger = 0x1

	// EVENTS_TICK: Event on COUNTER increment
	// Position of EVENTS_TICK field.
	RTC_EVENTS_TICK_EVENTS_TICK_Pos = 0x0
	// Bit mask of EVENTS_TICK field.
	RTC_EVENTS_TICK_EVENTS_TICK_Msk = 0x1
	// Bit EVENTS_TICK.
	RTC_EVENTS_TICK_EVENTS_TICK = 0x1
	// Event not generated
	RTC_EVENTS_TICK_EVENTS_TICK_NotGenerated = 0x0
	// Event generated
	RTC_EVENTS_TICK_EVENTS_TICK_Generated = 0x1

	// EVENTS_OVRFLW: Event on COUNTER overflow
	// Position of EVENTS_OVRFLW field.
	RTC_EVENTS_OVRFLW_EVENTS_OVRFLW_Pos = 0x0
	// Bit mask of EVENTS_OVRFLW field.
	RTC_EVENTS_OVRFLW_EVENTS_OVRFLW_Msk = 0x1
	// Bit EVENTS_OVRFLW.
	RTC_EVENTS_OVRFLW_EVENTS_OVRFLW = 0x1
	// Event not generated
	RTC_EVENTS_OVRFLW_EVENTS_OVRFLW_NotGenerated = 0x0
	// Event generated
	RTC_EVENTS_OVRFLW_EVENTS_OVRFLW_Generated = 0x1

	// EVENTS_COMPARE: Description collection: Compare event on CC[n] match
	// Position of EVENTS_COMPARE field.
	RTC_EVENTS_COMPARE_EVENTS_COMPARE_Pos = 0x0
	// Bit mask of EVENTS_COMPARE field.
	RTC_EVENTS_COMPARE_EVENTS_COMPARE_Msk = 0x1
	// Bit EVENTS_COMPARE.
	RTC_EVENTS_COMPARE_EVENTS_COMPARE = 0x1
	// Event not generated
	RTC_EVENTS_COMPARE_EVENTS_COMPARE_NotGenerated = 0x0
	// Event generated
	RTC_EVENTS_COMPARE_EVENTS_COMPARE_Generated = 0x1

	// INTENSET: Enable interrupt
	// Position of TICK field.
	RTC_INTENSET_TICK_Pos = 0x0
	// Bit mask of TICK field.
	RTC_INTENSET_TICK_Msk = 0x1
	// Bit TICK.
	RTC_INTENSET_TICK = 0x1
	// Read: Disabled
	RTC_INTENSET_TICK_Disabled = 0x0
	// Read: Enabled
	RTC_INTENSET_TICK_Enabled = 0x1
	// Enable
	RTC_INTENSET_TICK_Set = 0x1
	// Position of OVRFLW field.
	RTC_INTENSET_OVRFLW_Pos = 0x1
	// Bit mask of OVRFLW field.
	RTC_INTENSET_OVRFLW_Msk = 0x2
	// Bit OVRFLW.
	RTC_INTENSET_OVRFLW = 0x2
	// Read: Disabled
	RTC_INTENSET_OVRFLW_Disabled = 0x0
	// Read: Enabled
	RTC_INTENSET_OVRFLW_Enabled = 0x1
	// Enable
	RTC_INTENSET_OVRFLW_Set = 0x1
	// Position of COMPARE0 field.
	RTC_INTENSET_COMPARE0_Pos = 0x10
	// Bit mask of COMPARE0 field.
	RTC_INTENSET_COMPARE0_Msk = 0x10000
	// Bit COMPARE0.
	RTC_INTENSET_COMPARE0 = 0x10000
	// Read: Disabled
	RTC_INTENSET_COMPARE0_Disabled = 0x0
	// Read: Enabled
	RTC_INTENSET_COMPARE0_Enabled = 0x1
	// Enable
	RTC_INTENSET_COMPARE0_Set = 0x1
	// Position of COMPARE1 field.
	RTC_INTENSET_COMPARE1_Pos = 0x11
	// Bit mask of COMPARE1 field.
	RTC_INTENSET_COMPARE1_Msk = 0x20000
	// Bit COMPARE1.
	RTC_INTENSET_COMPARE1 = 0x20000
	// Read: Disabled
	RTC_INTENSET_COMPARE1_Disabled = 0x0
	// Read: Enabled
	RTC_INTENSET_COMPARE1_Enabled = 0x1
	// Enable
	RTC_INTENSET_COMPARE1_Set = 0x1
	// Position of COMPARE2 field.
	RTC_INTENSET_COMPARE2_Pos = 0x12
	// Bit mask of COMPARE2 field.
	RTC_INTENSET_COMPARE2_Msk = 0x40000
	// Bit COMPARE2.
	RTC_INTENSET_COMPARE2 = 0x40000
	// Read: Disabled
	RTC_INTENSET_COMPARE2_Disabled = 0x0
	// Read: Enabled
	RTC_INTENSET_COMPARE2_Enabled = 0x1
	// Enable
	RTC_INTENSET_COMPARE2_Set = 0x1
	// Position of COMPARE3 field.
	RTC_INTENSET_COMPARE3_Pos = 0x13
	// Bit mask of COMPARE3 field.
	RTC_INTENSET_COMPARE3_Msk = 0x80000
	// Bit COMPARE3.
	RTC_INTENSET_COMPARE3 = 0x80000
	// Read: Disabled
	RTC_INTENSET_COMPARE3_Disabled = 0x0
	// Read: Enabled
	RTC_INTENSET_COMPARE3_Enabled = 0x1
	// Enable
	RTC_INTENSET_COMPARE3_Set = 0x1

	// INTENCLR: Disable interrupt
	// Position of TICK field.
	RTC_INTENCLR_TICK_Pos = 0x0
	// Bit mask of TICK field.
	RTC_INTENCLR_TICK_Msk = 0x1
	// Bit TICK.
	RTC_INTENCLR_TICK = 0x1
	// Read: Disabled
	RTC_INTENCLR_TICK_Disabled = 0x0
	// Read: Enabled
	RTC_INTENCLR_TICK_Enabled = 0x1
	// Disable
	RTC_INTENCLR_TICK_Clear = 0x1
	// Position of OVRFLW field.
	RTC_INTENCLR_OVRFLW_Pos = 0x1
	// Bit mask of OVRFLW field.
	RTC_INTENCLR_OVRFLW_Msk = 0x2
	// Bit OVRFLW.
	RTC_INTENCLR_OVRFLW = 0x2
	// Read: Disabled
	RTC_INTENCLR_OVRFLW_Disabled = 0x0
	// Read: Enabled
	RTC_INTENCLR_OVRFLW_Enabled = 0x1
	// Disable
	RTC_INTENCLR_OVRFLW_Clear = 0x1
	// Position of COMPARE0 field.
	RTC_INTENCLR_COMPARE0_Pos = 0x10
	// Bit mask of COMPARE0 field.
	RTC_INTENCLR_COMPARE0_Msk = 0x10000
	// Bit COMPARE0.
	RTC_INTENCLR_COMPARE0 = 0x10000
	// Read: Disabled
	RTC_INTENCLR_COMPARE0_Disabled = 0x0
	// Read: Enabled
	RTC_INTENCLR_COMPARE0_Enabled = 0x1
	// Disable
	RTC_INTENCLR_COMPARE0_Clear = 0x1
	// Position of COMPARE1 field.
	RTC_INTENCLR_COMPARE1_Pos = 0x11
	// Bit mask of COMPARE1 field.
	RTC_INTENCLR_COMPARE1_Msk = 0x20000
	// Bit COMPARE1.
	RTC_INTENCLR_COMPARE1 = 0x20000
	// Read: Disabled
	RTC_INTENCLR_COMPARE1_Disabled = 0x0
	// Read: Enabled
	RTC_INTENCLR_COMPARE1_Enabled = 0x1
	// Disable
	RTC_INTENCLR_COMPARE1_Clear = 0x1
	// Position of COMPARE2 field.
	RTC_INTENCLR_COMPARE2_Pos = 0x12
	// Bit mask of COMPARE2 field.
	RTC_INTENCLR_COMPARE2_Msk = 0x40000
	// Bit COMPARE2.
	RTC_INTENCLR_COMPARE2 = 0x40000
	// Read: Disabled
	RTC_INTENCLR_COMPARE2_Disabled = 0x0
	// Read: Enabled
	RTC_INTENCLR_COMPARE2_Enabled = 0x1
	// Disable
	RTC_INTENCLR_COMPARE2_Clear = 0x1
	// Position of COMPARE3 field.
	RTC_INTENCLR_COMPARE3_Pos = 0x13
	// Bit mask of COMPARE3 field.
	RTC_INTENCLR_COMPARE3_Msk = 0x80000
	// Bit COMPARE3.
	RTC_INTENCLR_COMPARE3 = 0x80000
	// Read: Disabled
	RTC_INTENCLR_COMPARE3_Disabled = 0x0
	// Read: Enabled
	RTC_INTENCLR_COMPARE3_Enabled = 0x1
	// Disable
	RTC_INTENCLR_COMPARE3_Clear = 0x1

	// EVTEN: Enable or disable event routing
	// Position of TICK field.
	RTC_EVTEN_TICK_Pos = 0x0
	// Bit mask of TICK field.
	RTC_EVTEN_TICK_Msk = 0x1
	// Bit TICK.
	RTC_EVTEN_TICK = 0x1
	// Disable
	RTC_EVTEN_TICK_Disabled = 0x0
	// Disable
	RTC_EVTEN_TICK_Enabled = 0x1
	// Position of OVRFLW field.
	RTC_EVTEN_OVRFLW_Pos = 0x1
	// Bit mask of OVRFLW field.
	RTC_EVTEN_OVRFLW_Msk = 0x2
	// Bit OVRFLW.
	RTC_EVTEN_OVRFLW = 0x2
	// Disable
	RTC_EVTEN_OVRFLW_Disabled = 0x0
	// Disable
	RTC_EVTEN_OVRFLW_Enabled = 0x1
	// Position of COMPARE0 field.
	RTC_EVTEN_COMPARE0_Pos = 0x10
	// Bit mask of COMPARE0 field.
	RTC_EVTEN_COMPARE0_Msk = 0x10000
	// Bit COMPARE0.
	RTC_EVTEN_COMPARE0 = 0x10000
	// Disable
	RTC_EVTEN_COMPARE0_Disabled = 0x0
	// Disable
	RTC_EVTEN_COMPARE0_Enabled = 0x1
	// Position of COMPARE1 field.
	RTC_EVTEN_COMPARE1_Pos = 0x11
	// Bit mask of COMPARE1 field.
	RTC_EVTEN_COMPARE1_Msk = 0x20000
	// Bit COMPARE1.
	RTC_EVTEN_COMPARE1 = 0x20000
	// Disable
	RTC_EVTEN_COMPARE1_Disabled = 0x0
	// Disable
	RTC_EVTEN_COMPARE1_Enabled = 0x1
	// Position of COMPARE2 field.
	RTC_EVTEN_COMPARE2_Pos = 0x12
	// Bit mask of COMPARE2 field.
	RTC_EVTEN_COMPARE2_Msk = 0x40000
	// Bit COMPARE2.
	RTC_EVTEN_COMPARE2 = 0x40000
	// Disable
	RTC_EVTEN_COMPARE2_Disabled = 0x0
	// Disable
	RTC_EVTEN_COMPARE2_Enabled = 0x1
	// Position of COMPARE3 field.
	RTC_EVTEN_COMPARE3_Pos = 0x13
	// Bit mask of COMPARE3 field.
	RTC_EVTEN_COMPARE3_Msk = 0x80000
	// Bit COMPARE3.
	RTC_EVTEN_COMPARE3 = 0x80000
	// Disable
	RTC_EVTEN_COMPARE3_Disabled = 0x0
	// Disable
	RTC_EVTEN_COMPARE3_Enabled = 0x1

	// EVTENSET: Enable event routing
	// Position of TICK field.
	RTC_EVTENSET_TICK_Pos = 0x0
	// Bit mask of TICK field.
	RTC_EVTENSET_TICK_Msk = 0x1
	// Bit TICK.
	RTC_EVTENSET_TICK = 0x1
	// Read: Disabled
	RTC_EVTENSET_TICK_Disabled = 0x0
	// Read: Enabled
	RTC_EVTENSET_TICK_Enabled = 0x1
	// Enable
	RTC_EVTENSET_TICK_Set = 0x1
	// Position of OVRFLW field.
	RTC_EVTENSET_OVRFLW_Pos = 0x1
	// Bit mask of OVRFLW field.
	RTC_EVTENSET_OVRFLW_Msk = 0x2
	// Bit OVRFLW.
	RTC_EVTENSET_OVRFLW = 0x2
	// Read: Disabled
	RTC_EVTENSET_OVRFLW_Disabled = 0x0
	// Read: Enabled
	RTC_EVTENSET_OVRFLW_Enabled = 0x1
	// Enable
	RTC_EVTENSET_OVRFLW_Set = 0x1
	// Position of COMPARE0 field.
	RTC_EVTENSET_COMPARE0_Pos = 0x10
	// Bit mask of COMPARE0 field.
	RTC_EVTENSET_COMPARE0_Msk = 0x10000
	// Bit COMPARE0.
	RTC_EVTENSET_COMPARE0 = 0x10000
	// Read: Disabled
	RTC_EVTENSET_COMPARE0_Disabled = 0x0
	// Read: Enabled
	RTC_EVTENSET_COMPARE0_Enabled = 0x1
	// Enable
	RTC_EVTENSET_COMPARE0_Set = 0x1
	// Position of COMPARE1 field.
	RTC_EVTENSET_COMPARE1_Pos = 0x11
	// Bit mask of COMPARE1 field.
	RTC_EVTENSET_COMPARE1_Msk = 0x20000
	// Bit COMPARE1.
	RTC_EVTENSET_COMPARE1 = 0x20000
	// Read: Disabled
	RTC_EVTENSET_COMPARE1_Disabled = 0x0
	// Read: Enabled
	RTC_EVTENSET_COMPARE1_Enabled = 0x1
	// Enable
	RTC_EVTENSET_COMPARE1_Set = 0x1
	// Position of COMPARE2 field.
	RTC_EVTENSET_COMPARE2_Pos = 0x12
	// Bit mask of COMPARE2 field.
	RTC_EVTENSET_COMPARE2_Msk = 0x40000
	// Bit COMPARE2.
	RTC_EVTENSET_COMPARE2 = 0x40000
	// Read: Disabled
	RTC_EVTENSET_COMPARE2_Disabled = 0x0
	// Read: Enabled
	RTC_EVTENSET_COMPARE2_Enabled = 0x1
	// Enable
	RTC_EVTENSET_COMPARE2_Set = 0x1
	// Position of COMPARE3 field.
	RTC_EVTENSET_COMPARE3_Pos = 0x13
	// Bit mask of COMPARE3 field.
	RTC_EVTENSET_COMPARE3_Msk = 0x80000
	// Bit COMPARE3.
	RTC_EVTENSET_COMPARE3 = 0x80000
	// Read: Disabled
	RTC_EVTENSET_COMPARE3_Disabled = 0x0
	// Read: Enabled
	RTC_EVTENSET_COMPARE3_Enabled = 0x1
	// Enable
	RTC_EVTENSET_COMPARE3_Set = 0x1

	// EVTENCLR: Disable event routing
	// Position of TICK field.
	RTC_EVTENCLR_TICK_Pos = 0x0
	// Bit mask of TICK field.
	RTC_EVTENCLR_TICK_Msk = 0x1
	// Bit TICK.
	RTC_EVTENCLR_TICK = 0x1
	// Read: Disabled
	RTC_EVTENCLR_TICK_Disabled = 0x0
	// Read: Enabled
	RTC_EVTENCLR_TICK_Enabled = 0x1
	// Disable
	RTC_EVTENCLR_TICK_Clear = 0x1
	// Position of OVRFLW field.
	RTC_EVTENCLR_OVRFLW_Pos = 0x1
	// Bit mask of OVRFLW field.
	RTC_EVTENCLR_OVRFLW_Msk = 0x2
	// Bit OVRFLW.
	RTC_EVTENCLR_OVRFLW = 0x2
	// Read: Disabled
	RTC_EVTENCLR_OVRFLW_Disabled = 0x0
	// Read: Enabled
	RTC_EVTENCLR_OVRFLW_Enabled = 0x1
	// Disable
	RTC_EVTENCLR_OVRFLW_Clear = 0x1
	// Position of COMPARE0 field.
	RTC_EVTENCLR_COMPARE0_Pos = 0x10
	// Bit mask of COMPARE0 field.
	RTC_EVTENCLR_COMPARE0_Msk = 0x10000
	// Bit COMPARE0.
	RTC_EVTENCLR_COMPARE0 = 0x10000
	// Read: Disabled
	RTC_EVTENCLR_COMPARE0_Disabled = 0x0
	// Read: Enabled
	RTC_EVTENCLR_COMPARE0_Enabled = 0x1
	// Disable
	RTC_EVTENCLR_COMPARE0_Clear = 0x1
	// Position of COMPARE1 field.
	RTC_EVTENCLR_COMPARE1_Pos = 0x11
	// Bit mask of COMPARE1 field.
	RTC_EVTENCLR_COMPARE1_Msk = 0x20000
	// Bit COMPARE1.
	RTC_EVTENCLR_COMPARE1 = 0x20000
	// Read: Disabled
	RTC_EVTENCLR_COMPARE1_Disabled = 0x0
	// Read: Enabled
	RTC_EVTENCLR_COMPARE1_Enabled = 0x1
	// Disable
	RTC_EVTENCLR_COMPARE1_Clear = 0x1
	// Position of COMPARE2 field.
	RTC_EVTENCLR_COMPARE2_Pos = 0x12
	// Bit mask of COMPARE2 field.
	RTC_EVTENCLR_COMPARE2_Msk = 0x40000
	// Bit COMPARE2.
	RTC_EVTENCLR_COMPARE2 = 0x40000
	// Read: Disabled
	RTC_EVTENCLR_COMPARE2_Disabled = 0x0
	// Read: Enabled
	RTC_EVTENCLR_COMPARE2_Enabled = 0x1
	// Disable
	RTC_EVTENCLR_COMPARE2_Clear = 0x1
	// Position of COMPARE3 field.
	RTC_EVTENCLR_COMPARE3_Pos = 0x13
	// Bit mask of COMPARE3 field.
	RTC_EVTENCLR_COMPARE3_Msk = 0x80000
	// Bit COMPARE3.
	RTC_EVTENCLR_COMPARE3 = 0x80000
	// Read: Disabled
	RTC_EVTENCLR_COMPARE3_Disabled = 0x0
	// Read: Enabled
	RTC_EVTENCLR_COMPARE3_Enabled = 0x1
	// Disable
	RTC_EVTENCLR_COMPARE3_Clear = 0x1

	// COUNTER: Current COUNTER value
	// Position of COUNTER field.
	RTC_COUNTER_COUNTER_Pos = 0x0
	// Bit mask of COUNTER field.
	RTC_COUNTER_COUNTER_Msk = 0xffffff

	// PRESCALER: 12 bit prescaler for COUNTER frequency (32768/(PRESCALER+1)).Must be written when RTC is stopped
	// Position of PRESCALER field.
	RTC_PRESCALER_PRESCALER_Pos = 0x0
	// Bit mask of PRESCALER field.
	RTC_PRESCALER_PRESCALER_Msk = 0xfff

	// CC: Description collection: Compare register n
	// Position of COMPARE field.
	RTC_CC_COMPARE_Pos = 0x0
	// Bit mask of COMPARE field.
	RTC_CC_COMPARE_Msk = 0xffffff
)

// Bitfields for TEMP: Temperature Sensor
const (
	// TASKS_START: Start temperature measurement
	// Position of TASKS_START field.
	TEMP_TASKS_START_TASKS_START_Pos = 0x0
	// Bit mask of TASKS_START field.
	TEMP_TASKS_START_TASKS_START_Msk = 0x1
	// Bit TASKS_START.
	TEMP_TASKS_START_TASKS_START = 0x1
	// Trigger task
	TEMP_TASKS_START_TASKS_START_Trigger = 0x1

	// TASKS_STOP: Stop temperature measurement
	// Position of TASKS_STOP field.
	TEMP_TASKS_STOP_TASKS_STOP_Pos = 0x0
	// Bit mask of TASKS_STOP field.
	TEMP_TASKS_STOP_TASKS_STOP_Msk = 0x1
	// Bit TASKS_STOP.
	TEMP_TASKS_STOP_TASKS_STOP = 0x1
	// Trigger task
	TEMP_TASKS_STOP_TASKS_STOP_Trigger = 0x1

	// EVENTS_DATARDY: Temperature measurement complete, data ready
	// Position of EVENTS_DATARDY field.
	TEMP_EVENTS_DATARDY_EVENTS_DATARDY_Pos = 0x0
	// Bit mask of EVENTS_DATARDY field.
	TEMP_EVENTS_DATARDY_EVENTS_DATARDY_Msk = 0x1
	// Bit EVENTS_DATARDY.
	TEMP_EVENTS_DATARDY_EVENTS_DATARDY = 0x1
	// Event not generated
	TEMP_EVENTS_DATARDY_EVENTS_DATARDY_NotGenerated = 0x0
	// Event generated
	TEMP_EVENTS_DATARDY_EVENTS_DATARDY_Generated = 0x1

	// INTENSET: Enable interrupt
	// Position of DATARDY field.
	TEMP_INTENSET_DATARDY_Pos = 0x0
	// Bit mask of DATARDY field.
	TEMP_INTENSET_DATARDY_Msk = 0x1
	// Bit DATARDY.
	TEMP_INTENSET_DATARDY = 0x1
	// Read: Disabled
	TEMP_INTENSET_DATARDY_Disabled = 0x0
	// Read: Enabled
	TEMP_INTENSET_DATARDY_Enabled = 0x1
	// Enable
	TEMP_INTENSET_DATARDY_Set = 0x1

	// INTENCLR: Disable interrupt
	// Position of DATARDY field.
	TEMP_INTENCLR_DATARDY_Pos = 0x0
	// Bit mask of DATARDY field.
	TEMP_INTENCLR_DATARDY_Msk = 0x1
	// Bit DATARDY.
	TEMP_INTENCLR_DATARDY = 0x1
	// Read: Disabled
	TEMP_INTENCLR_DATARDY_Disabled = 0x0
	// Read: Enabled
	TEMP_INTENCLR_DATARDY_Enabled = 0x1
	// Disable
	TEMP_INTENCLR_DATARDY_Clear = 0x1

	// TEMP: Temperature in degC (0.25deg steps)
	// Position of TEMP field.
	TEMP_TEMP_TEMP_Pos = 0x0
	// Bit mask of TEMP field.
	TEMP_TEMP_TEMP_Msk = 0xffffffff

	// A0: Slope of 1st piece wise linear function
	// Position of A0 field.
	TEMP_A0_A0_Pos = 0x0
	// Bit mask of A0 field.
	TEMP_A0_A0_Msk = 0xfff

	// A1: Slope of 2nd piece wise linear function
	// Position of A1 field.
	TEMP_A1_A1_Pos = 0x0
	// Bit mask of A1 field.
	TEMP_A1_A1_Msk = 0xfff

	// A2: Slope of 3rd piece wise linear function
	// Position of A2 field.
	TEMP_A2_A2_Pos = 0x0
	// Bit mask of A2 field.
	TEMP_A2_A2_Msk = 0xfff

	// A3: Slope of 4th piece wise linear function
	// Position of A3 field.
	TEMP_A3_A3_Pos = 0x0
	// Bit mask of A3 field.
	TEMP_A3_A3_Msk = 0xfff

	// A4: Slope of 5th piece wise linear function
	// Position of A4 field.
	TEMP_A4_A4_Pos = 0x0
	// Bit mask of A4 field.
	TEMP_A4_A4_Msk = 0xfff

	// A5: Slope of 6th piece wise linear function
	// Position of A5 field.
	TEMP_A5_A5_Pos = 0x0
	// Bit mask of A5 field.
	TEMP_A5_A5_Msk = 0xfff

	// B0: y-intercept of 1st piece wise linear function
	// Position of B0 field.
	TEMP_B0_B0_Pos = 0x0
	// Bit mask of B0 field.
	TEMP_B0_B0_Msk = 0x3fff

	// B1: y-intercept of 2nd piece wise linear function
	// Position of B1 field.
	TEMP_B1_B1_Pos = 0x0
	// Bit mask of B1 field.
	TEMP_B1_B1_Msk = 0x3fff

	// B2: y-intercept of 3rd piece wise linear function
	// Position of B2 field.
	TEMP_B2_B2_Pos = 0x0
	// Bit mask of B2 field.
	TEMP_B2_B2_Msk = 0x3fff

	// B3: y-intercept of 4th piece wise linear function
	// Position of B3 field.
	TEMP_B3_B3_Pos = 0x0
	// Bit mask of B3 field.
	TEMP_B3_B3_Msk = 0x3fff

	// B4: y-intercept of 5th piece wise linear function
	// Position of B4 field.
	TEMP_B4_B4_Pos = 0x0
	// Bit mask of B4 field.
	TEMP_B4_B4_Msk = 0x3fff

	// B5: y-intercept of 6th piece wise linear function
	// Position of B5 field.
	TEMP_B5_B5_Pos = 0x0
	// Bit mask of B5 field.
	TEMP_B5_B5_Msk = 0x3fff

	// T0: End point of 1st piece wise linear function
	// Position of T0 field.
	TEMP_T0_T0_Pos = 0x0
	// Bit mask of T0 field.
	TEMP_T0_T0_Msk = 0xff

	// T1: End point of 2nd piece wise linear function
	// Position of T1 field.
	TEMP_T1_T1_Pos = 0x0
	// Bit mask of T1 field.
	TEMP_T1_T1_Msk = 0xff

	// T2: End point of 3rd piece wise linear function
	// Position of T2 field.
	TEMP_T2_T2_Pos = 0x0
	// Bit mask of T2 field.
	TEMP_T2_T2_Msk = 0xff

	// T3: End point of 4th piece wise linear function
	// Position of T3 field.
	TEMP_T3_T3_Pos = 0x0
	// Bit mask of T3 field.
	TEMP_T3_T3_Msk = 0xff

	// T4: End point of 5th piece wise linear function
	// Position of T4 field.
	TEMP_T4_T4_Pos = 0x0
	// Bit mask of T4 field.
	TEMP_T4_T4_Msk = 0xff
)

// Bitfields for RNG: Random Number Generator
const (
	// TASKS_START: Task starting the random number generator
	// Position of TASKS_START field.
	RNG_TASKS_START_TASKS_START_Pos = 0x0
	// Bit mask of TASKS_START field.
	RNG_TASKS_START_TASKS_START_Msk = 0x1
	// Bit TASKS_START.
	RNG_TASKS_START_TASKS_START = 0x1
	// Trigger task
	RNG_TASKS_START_TASKS_START_Trigger = 0x1

	// TASKS_STOP: Task stopping the random number generator
	// Position of TASKS_STOP field.
	RNG_TASKS_STOP_TASKS_STOP_Pos = 0x0
	// Bit mask of TASKS_STOP field.
	RNG_TASKS_STOP_TASKS_STOP_Msk = 0x1
	// Bit TASKS_STOP.
	RNG_TASKS_STOP_TASKS_STOP = 0x1
	// Trigger task
	RNG_TASKS_STOP_TASKS_STOP_Trigger = 0x1

	// EVENTS_VALRDY: Event being generated for every new random number written to the VALUE register
	// Position of EVENTS_VALRDY field.
	RNG_EVENTS_VALRDY_EVENTS_VALRDY_Pos = 0x0
	// Bit mask of EVENTS_VALRDY field.
	RNG_EVENTS_VALRDY_EVENTS_VALRDY_Msk = 0x1
	// Bit EVENTS_VALRDY.
	RNG_EVENTS_VALRDY_EVENTS_VALRDY = 0x1
	// Event not generated
	RNG_EVENTS_VALRDY_EVENTS_VALRDY_NotGenerated = 0x0
	// Event generated
	RNG_EVENTS_VALRDY_EVENTS_VALRDY_Generated = 0x1

	// SHORTS: Shortcuts between local events and tasks
	// Position of VALRDY_STOP field.
	RNG_SHORTS_VALRDY_STOP_Pos = 0x0
	// Bit mask of VALRDY_STOP field.
	RNG_SHORTS_VALRDY_STOP_Msk = 0x1
	// Bit VALRDY_STOP.
	RNG_SHORTS_VALRDY_STOP = 0x1
	// Disable shortcut
	RNG_SHORTS_VALRDY_STOP_Disabled = 0x0
	// Enable shortcut
	RNG_SHORTS_VALRDY_STOP_Enabled = 0x1

	// INTENSET: Enable interrupt
	// Position of VALRDY field.
	RNG_INTENSET_VALRDY_Pos = 0x0
	// Bit mask of VALRDY field.
	RNG_INTENSET_VALRDY_Msk = 0x1
	// Bit VALRDY.
	RNG_INTENSET_VALRDY = 0x1
	// Read: Disabled
	RNG_INTENSET_VALRDY_Disabled = 0x0
	// Read: Enabled
	RNG_INTENSET_VALRDY_Enabled = 0x1
	// Enable
	RNG_INTENSET_VALRDY_Set = 0x1

	// INTENCLR: Disable interrupt
	// Position of VALRDY field.
	RNG_INTENCLR_VALRDY_Pos = 0x0
	// Bit mask of VALRDY field.
	RNG_INTENCLR_VALRDY_Msk = 0x1
	// Bit VALRDY.
	RNG_INTENCLR_VALRDY = 0x1
	// Read: Disabled
	RNG_INTENCLR_VALRDY_Disabled = 0x0
	// Read: Enabled
	RNG_INTENCLR_VALRDY_Enabled = 0x1
	// Disable
	RNG_INTENCLR_VALRDY_Clear = 0x1

	// CONFIG: Configuration register
	// Position of DERCEN field.
	RNG_CONFIG_DERCEN_Pos = 0x0
	// Bit mask of DERCEN field.
	RNG_CONFIG_DERCEN_Msk = 0x1
	// Bit DERCEN.
	RNG_CONFIG_DERCEN = 0x1
	// Disabled
	RNG_CONFIG_DERCEN_Disabled = 0x0
	// Enabled
	RNG_CONFIG_DERCEN_Enabled = 0x1

	// VALUE: Output random number
	// Position of VALUE field.
	RNG_VALUE_VALUE_Pos = 0x0
	// Bit mask of VALUE field.
	RNG_VALUE_VALUE_Msk = 0xff
)

// Bitfields for ECB: AES ECB Mode Encryption
const (
	// TASKS_STARTECB: Start ECB block encrypt
	// Position of TASKS_STARTECB field.
	ECB_TASKS_STARTECB_TASKS_STARTECB_Pos = 0x0
	// Bit mask of TASKS_STARTECB field.
	ECB_TASKS_STARTECB_TASKS_STARTECB_Msk = 0x1
	// Bit TASKS_STARTECB.
	ECB_TASKS_STARTECB_TASKS_STARTECB = 0x1
	// Trigger task
	ECB_TASKS_STARTECB_TASKS_STARTECB_Trigger = 0x1

	// TASKS_STOPECB: Abort a possible executing ECB operation
	// Position of TASKS_STOPECB field.
	ECB_TASKS_STOPECB_TASKS_STOPECB_Pos = 0x0
	// Bit mask of TASKS_STOPECB field.
	ECB_TASKS_STOPECB_TASKS_STOPECB_Msk = 0x1
	// Bit TASKS_STOPECB.
	ECB_TASKS_STOPECB_TASKS_STOPECB = 0x1
	// Trigger task
	ECB_TASKS_STOPECB_TASKS_STOPECB_Trigger = 0x1

	// EVENTS_ENDECB: ECB block encrypt complete
	// Position of EVENTS_ENDECB field.
	ECB_EVENTS_ENDECB_EVENTS_ENDECB_Pos = 0x0
	// Bit mask of EVENTS_ENDECB field.
	ECB_EVENTS_ENDECB_EVENTS_ENDECB_Msk = 0x1
	// Bit EVENTS_ENDECB.
	ECB_EVENTS_ENDECB_EVENTS_ENDECB = 0x1
	// Event not generated
	ECB_EVENTS_ENDECB_EVENTS_ENDECB_NotGenerated = 0x0
	// Event generated
	ECB_EVENTS_ENDECB_EVENTS_ENDECB_Generated = 0x1

	// EVENTS_ERRORECB: ECB block encrypt aborted because of a STOPECB task or due to an error
	// Position of EVENTS_ERRORECB field.
	ECB_EVENTS_ERRORECB_EVENTS_ERRORECB_Pos = 0x0
	// Bit mask of EVENTS_ERRORECB field.
	ECB_EVENTS_ERRORECB_EVENTS_ERRORECB_Msk = 0x1
	// Bit EVENTS_ERRORECB.
	ECB_EVENTS_ERRORECB_EVENTS_ERRORECB = 0x1
	// Event not generated
	ECB_EVENTS_ERRORECB_EVENTS_ERRORECB_NotGenerated = 0x0
	// Event generated
	ECB_EVENTS_ERRORECB_EVENTS_ERRORECB_Generated = 0x1

	// INTENSET: Enable interrupt
	// Position of ENDECB field.
	ECB_INTENSET_ENDECB_Pos = 0x0
	// Bit mask of ENDECB field.
	ECB_INTENSET_ENDECB_Msk = 0x1
	// Bit ENDECB.
	ECB_INTENSET_ENDECB = 0x1
	// Read: Disabled
	ECB_INTENSET_ENDECB_Disabled = 0x0
	// Read: Enabled
	ECB_INTENSET_ENDECB_Enabled = 0x1
	// Enable
	ECB_INTENSET_ENDECB_Set = 0x1
	// Position of ERRORECB field.
	ECB_INTENSET_ERRORECB_Pos = 0x1
	// Bit mask of ERRORECB field.
	ECB_INTENSET_ERRORECB_Msk = 0x2
	// Bit ERRORECB.
	ECB_INTENSET_ERRORECB = 0x2
	// Read: Disabled
	ECB_INTENSET_ERRORECB_Disabled = 0x0
	// Read: Enabled
	ECB_INTENSET_ERRORECB_Enabled = 0x1
	// Enable
	ECB_INTENSET_ERRORECB_Set = 0x1

	// INTENCLR: Disable interrupt
	// Position of ENDECB field.
	ECB_INTENCLR_ENDECB_Pos = 0x0
	// Bit mask of ENDECB field.
	ECB_INTENCLR_ENDECB_Msk = 0x1
	// Bit ENDECB.
	ECB_INTENCLR_ENDECB = 0x1
	// Read: Disabled
	ECB_INTENCLR_ENDECB_Disabled = 0x0
	// Read: Enabled
	ECB_INTENCLR_ENDECB_Enabled = 0x1
	// Disable
	ECB_INTENCLR_ENDECB_Clear = 0x1
	// Position of ERRORECB field.
	ECB_INTENCLR_ERRORECB_Pos = 0x1
	// Bit mask of ERRORECB field.
	ECB_INTENCLR_ERRORECB_Msk = 0x2
	// Bit ERRORECB.
	ECB_INTENCLR_ERRORECB = 0x2
	// Read: Disabled
	ECB_INTENCLR_ERRORECB_Disabled = 0x0
	// Read: Enabled
	ECB_INTENCLR_ERRORECB_Enabled = 0x1
	// Disable
	ECB_INTENCLR_ERRORECB_Clear = 0x1

	// ECBDATAPTR: ECB block encrypt memory pointers
	// Position of ECBDATAPTR field.
	ECB_ECBDATAPTR_ECBDATAPTR_Pos = 0x0
	// Bit mask of ECBDATAPTR field.
	ECB_ECBDATAPTR_ECBDATAPTR_Msk = 0xffffffff
)

// Bitfields for AAR: Accelerated Address Resolver
const (
	// TASKS_START: Start resolving addresses based on IRKs specified in the IRK data structure
	// Position of TASKS_START field.
	AAR_TASKS_START_TASKS_START_Pos = 0x0
	// Bit mask of TASKS_START field.
	AAR_TASKS_START_TASKS_START_Msk = 0x1
	// Bit TASKS_START.
	AAR_TASKS_START_TASKS_START = 0x1
	// Trigger task
	AAR_TASKS_START_TASKS_START_Trigger = 0x1

	// TASKS_STOP: Stop resolving addresses
	// Position of TASKS_STOP field.
	AAR_TASKS_STOP_TASKS_STOP_Pos = 0x0
	// Bit mask of TASKS_STOP field.
	AAR_TASKS_STOP_TASKS_STOP_Msk = 0x1
	// Bit TASKS_STOP.
	AAR_TASKS_STOP_TASKS_STOP = 0x1
	// Trigger task
	AAR_TASKS_STOP_TASKS_STOP_Trigger = 0x1

	// EVENTS_END: Address resolution procedure complete
	// Position of EVENTS_END field.
	AAR_EVENTS_END_EVENTS_END_Pos = 0x0
	// Bit mask of EVENTS_END field.
	AAR_EVENTS_END_EVENTS_END_Msk = 0x1
	// Bit EVENTS_END.
	AAR_EVENTS_END_EVENTS_END = 0x1
	// Event not generated
	AAR_EVENTS_END_EVENTS_END_NotGenerated = 0x0
	// Event generated
	AAR_EVENTS_END_EVENTS_END_Generated = 0x1

	// EVENTS_RESOLVED: Address resolved
	// Position of EVENTS_RESOLVED field.
	AAR_EVENTS_RESOLVED_EVENTS_RESOLVED_Pos = 0x0
	// Bit mask of EVENTS_RESOLVED field.
	AAR_EVENTS_RESOLVED_EVENTS_RESOLVED_Msk = 0x1
	// Bit EVENTS_RESOLVED.
	AAR_EVENTS_RESOLVED_EVENTS_RESOLVED = 0x1
	// Event not generated
	AAR_EVENTS_RESOLVED_EVENTS_RESOLVED_NotGenerated = 0x0
	// Event generated
	AAR_EVENTS_RESOLVED_EVENTS_RESOLVED_Generated = 0x1

	// EVENTS_NOTRESOLVED: Address not resolved
	// Position of EVENTS_NOTRESOLVED field.
	AAR_EVENTS_NOTRESOLVED_EVENTS_NOTRESOLVED_Pos = 0x0
	// Bit mask of EVENTS_NOTRESOLVED field.
	AAR_EVENTS_NOTRESOLVED_EVENTS_NOTRESOLVED_Msk = 0x1
	// Bit EVENTS_NOTRESOLVED.
	AAR_EVENTS_NOTRESOLVED_EVENTS_NOTRESOLVED = 0x1
	// Event not generated
	AAR_EVENTS_NOTRESOLVED_EVENTS_NOTRESOLVED_NotGenerated = 0x0
	// Event generated
	AAR_EVENTS_NOTRESOLVED_EVENTS_NOTRESOLVED_Generated = 0x1

	// INTENSET: Enable interrupt
	// Position of END field.
	AAR_INTENSET_END_Pos = 0x0
	// Bit mask of END field.
	AAR_INTENSET_END_Msk = 0x1
	// Bit END.
	AAR_INTENSET_END = 0x1
	// Read: Disabled
	AAR_INTENSET_END_Disabled = 0x0
	// Read: Enabled
	AAR_INTENSET_END_Enabled = 0x1
	// Enable
	AAR_INTENSET_END_Set = 0x1
	// Position of RESOLVED field.
	AAR_INTENSET_RESOLVED_Pos = 0x1
	// Bit mask of RESOLVED field.
	AAR_INTENSET_RESOLVED_Msk = 0x2
	// Bit RESOLVED.
	AAR_INTENSET_RESOLVED = 0x2
	// Read: Disabled
	AAR_INTENSET_RESOLVED_Disabled = 0x0
	// Read: Enabled
	AAR_INTENSET_RESOLVED_Enabled = 0x1
	// Enable
	AAR_INTENSET_RESOLVED_Set = 0x1
	// Position of NOTRESOLVED field.
	AAR_INTENSET_NOTRESOLVED_Pos = 0x2
	// Bit mask of NOTRESOLVED field.
	AAR_INTENSET_NOTRESOLVED_Msk = 0x4
	// Bit NOTRESOLVED.
	AAR_INTENSET_NOTRESOLVED = 0x4
	// Read: Disabled
	AAR_INTENSET_NOTRESOLVED_Disabled = 0x0
	// Read: Enabled
	AAR_INTENSET_NOTRESOLVED_Enabled = 0x1
	// Enable
	AAR_INTENSET_NOTRESOLVED_Set = 0x1

	// INTENCLR: Disable interrupt
	// Position of END field.
	AAR_INTENCLR_END_Pos = 0x0
	// Bit mask of END field.
	AAR_INTENCLR_END_Msk = 0x1
	// Bit END.
	AAR_INTENCLR_END = 0x1
	// Read: Disabled
	AAR_INTENCLR_END_Disabled = 0x0
	// Read: Enabled
	AAR_INTENCLR_END_Enabled = 0x1
	// Disable
	AAR_INTENCLR_END_Clear = 0x1
	// Position of RESOLVED field.
	AAR_INTENCLR_RESOLVED_Pos = 0x1
	// Bit mask of RESOLVED field.
	AAR_INTENCLR_RESOLVED_Msk = 0x2
	// Bit RESOLVED.
	AAR_INTENCLR_RESOLVED = 0x2
	// Read: Disabled
	AAR_INTENCLR_RESOLVED_Disabled = 0x0
	// Read: Enabled
	AAR_INTENCLR_RESOLVED_Enabled = 0x1
	// Disable
	AAR_INTENCLR_RESOLVED_Clear = 0x1
	// Position of NOTRESOLVED field.
	AAR_INTENCLR_NOTRESOLVED_Pos = 0x2
	// Bit mask of NOTRESOLVED field.
	AAR_INTENCLR_NOTRESOLVED_Msk = 0x4
	// Bit NOTRESOLVED.
	AAR_INTENCLR_NOTRESOLVED = 0x4
	// Read: Disabled
	AAR_INTENCLR_NOTRESOLVED_Disabled = 0x0
	// Read: Enabled
	AAR_INTENCLR_NOTRESOLVED_Enabled = 0x1
	// Disable
	AAR_INTENCLR_NOTRESOLVED_Clear = 0x1

	// STATUS: Resolution status
	// Position of STATUS field.
	AAR_STATUS_STATUS_Pos = 0x0
	// Bit mask of STATUS field.
	AAR_STATUS_STATUS_Msk = 0xf

	// ENABLE: Enable AAR
	// Position of ENABLE field.
	AAR_ENABLE_ENABLE_Pos = 0x0
	// Bit mask of ENABLE field.
	AAR_ENABLE_ENABLE_Msk = 0x3
	// Disable
	AAR_ENABLE_ENABLE_Disabled = 0x0
	// Enable
	AAR_ENABLE_ENABLE_Enabled = 0x3

	// NIRK: Number of IRKs
	// Position of NIRK field.
	AAR_NIRK_NIRK_Pos = 0x0
	// Bit mask of NIRK field.
	AAR_NIRK_NIRK_Msk = 0x1f

	// IRKPTR: Pointer to IRK data structure
	// Position of IRKPTR field.
	AAR_IRKPTR_IRKPTR_Pos = 0x0
	// Bit mask of IRKPTR field.
	AAR_IRKPTR_IRKPTR_Msk = 0xffffffff

	// ADDRPTR: Pointer to the resolvable address
	// Position of ADDRPTR field.
	AAR_ADDRPTR_ADDRPTR_Pos = 0x0
	// Bit mask of ADDRPTR field.
	AAR_ADDRPTR_ADDRPTR_Msk = 0xffffffff

	// SCRATCHPTR: Pointer to data area used for temporary storage
	// Position of SCRATCHPTR field.
	AAR_SCRATCHPTR_SCRATCHPTR_Pos = 0x0
	// Bit mask of SCRATCHPTR field.
	AAR_SCRATCHPTR_SCRATCHPTR_Msk = 0xffffffff
)

// Bitfields for CCM: AES CCM Mode Encryption
const (
	// TASKS_KSGEN: Start generation of key-stream. This operation will stop by itself when completed.
	// Position of TASKS_KSGEN field.
	CCM_TASKS_KSGEN_TASKS_KSGEN_Pos = 0x0
	// Bit mask of TASKS_KSGEN field.
	CCM_TASKS_KSGEN_TASKS_KSGEN_Msk = 0x1
	// Bit TASKS_KSGEN.
	CCM_TASKS_KSGEN_TASKS_KSGEN = 0x1
	// Trigger task
	CCM_TASKS_KSGEN_TASKS_KSGEN_Trigger = 0x1

	// TASKS_CRYPT: Start encryption/decryption. This operation will stop by itself when completed.
	// Position of TASKS_CRYPT field.
	CCM_TASKS_CRYPT_TASKS_CRYPT_Pos = 0x0
	// Bit mask of TASKS_CRYPT field.
	CCM_TASKS_CRYPT_TASKS_CRYPT_Msk = 0x1
	// Bit TASKS_CRYPT.
	CCM_TASKS_CRYPT_TASKS_CRYPT = 0x1
	// Trigger task
	CCM_TASKS_CRYPT_TASKS_CRYPT_Trigger = 0x1

	// TASKS_STOP: Stop encryption/decryption
	// Position of TASKS_STOP field.
	CCM_TASKS_STOP_TASKS_STOP_Pos = 0x0
	// Bit mask of TASKS_STOP field.
	CCM_TASKS_STOP_TASKS_STOP_Msk = 0x1
	// Bit TASKS_STOP.
	CCM_TASKS_STOP_TASKS_STOP = 0x1
	// Trigger task
	CCM_TASKS_STOP_TASKS_STOP_Trigger = 0x1

	// TASKS_RATEOVERRIDE: Override DATARATE setting in MODE register with the contents of the RATEOVERRIDE register for any ongoing encryption/decryption
	// Position of TASKS_RATEOVERRIDE field.
	CCM_TASKS_RATEOVERRIDE_TASKS_RATEOVERRIDE_Pos = 0x0
	// Bit mask of TASKS_RATEOVERRIDE field.
	CCM_TASKS_RATEOVERRIDE_TASKS_RATEOVERRIDE_Msk = 0x1
	// Bit TASKS_RATEOVERRIDE.
	CCM_TASKS_RATEOVERRIDE_TASKS_RATEOVERRIDE = 0x1
	// Trigger task
	CCM_TASKS_RATEOVERRIDE_TASKS_RATEOVERRIDE_Trigger = 0x1

	// EVENTS_ENDKSGEN: Key-stream generation complete
	// Position of EVENTS_ENDKSGEN field.
	CCM_EVENTS_ENDKSGEN_EVENTS_ENDKSGEN_Pos = 0x0
	// Bit mask of EVENTS_ENDKSGEN field.
	CCM_EVENTS_ENDKSGEN_EVENTS_ENDKSGEN_Msk = 0x1
	// Bit EVENTS_ENDKSGEN.
	CCM_EVENTS_ENDKSGEN_EVENTS_ENDKSGEN = 0x1
	// Event not generated
	CCM_EVENTS_ENDKSGEN_EVENTS_ENDKSGEN_NotGenerated = 0x0
	// Event generated
	CCM_EVENTS_ENDKSGEN_EVENTS_ENDKSGEN_Generated = 0x1

	// EVENTS_ENDCRYPT: Encrypt/decrypt complete
	// Position of EVENTS_ENDCRYPT field.
	CCM_EVENTS_ENDCRYPT_EVENTS_ENDCRYPT_Pos = 0x0
	// Bit mask of EVENTS_ENDCRYPT field.
	CCM_EVENTS_ENDCRYPT_EVENTS_ENDCRYPT_Msk = 0x1
	// Bit EVENTS_ENDCRYPT.
	CCM_EVENTS_ENDCRYPT_EVENTS_ENDCRYPT = 0x1
	// Event not generated
	CCM_EVENTS_ENDCRYPT_EVENTS_ENDCRYPT_NotGenerated = 0x0
	// Event generated
	CCM_EVENTS_ENDCRYPT_EVENTS_ENDCRYPT_Generated = 0x1

	// EVENTS_ERROR: Deprecated register - CCM error event
	// Position of EVENTS_ERROR field.
	CCM_EVENTS_ERROR_EVENTS_ERROR_Pos = 0x0
	// Bit mask of EVENTS_ERROR field.
	CCM_EVENTS_ERROR_EVENTS_ERROR_Msk = 0x1
	// Bit EVENTS_ERROR.
	CCM_EVENTS_ERROR_EVENTS_ERROR = 0x1
	// Event not generated
	CCM_EVENTS_ERROR_EVENTS_ERROR_NotGenerated = 0x0
	// Event generated
	CCM_EVENTS_ERROR_EVENTS_ERROR_Generated = 0x1

	// SHORTS: Shortcuts between local events and tasks
	// Position of ENDKSGEN_CRYPT field.
	CCM_SHORTS_ENDKSGEN_CRYPT_Pos = 0x0
	// Bit mask of ENDKSGEN_CRYPT field.
	CCM_SHORTS_ENDKSGEN_CRYPT_Msk = 0x1
	// Bit ENDKSGEN_CRYPT.
	CCM_SHORTS_ENDKSGEN_CRYPT = 0x1
	// Disable shortcut
	CCM_SHORTS_ENDKSGEN_CRYPT_Disabled = 0x0
	// Enable shortcut
	CCM_SHORTS_ENDKSGEN_CRYPT_Enabled = 0x1

	// INTENSET: Enable interrupt
	// Position of ENDKSGEN field.
	CCM_INTENSET_ENDKSGEN_Pos = 0x0
	// Bit mask of ENDKSGEN field.
	CCM_INTENSET_ENDKSGEN_Msk = 0x1
	// Bit ENDKSGEN.
	CCM_INTENSET_ENDKSGEN = 0x1
	// Read: Disabled
	CCM_INTENSET_ENDKSGEN_Disabled = 0x0
	// Read: Enabled
	CCM_INTENSET_ENDKSGEN_Enabled = 0x1
	// Enable
	CCM_INTENSET_ENDKSGEN_Set = 0x1
	// Position of ENDCRYPT field.
	CCM_INTENSET_ENDCRYPT_Pos = 0x1
	// Bit mask of ENDCRYPT field.
	CCM_INTENSET_ENDCRYPT_Msk = 0x2
	// Bit ENDCRYPT.
	CCM_INTENSET_ENDCRYPT = 0x2
	// Read: Disabled
	CCM_INTENSET_ENDCRYPT_Disabled = 0x0
	// Read: Enabled
	CCM_INTENSET_ENDCRYPT_Enabled = 0x1
	// Enable
	CCM_INTENSET_ENDCRYPT_Set = 0x1
	// Position of ERROR field.
	CCM_INTENSET_ERROR_Pos = 0x2
	// Bit mask of ERROR field.
	CCM_INTENSET_ERROR_Msk = 0x4
	// Bit ERROR.
	CCM_INTENSET_ERROR = 0x4
	// Read: Disabled
	CCM_INTENSET_ERROR_Disabled = 0x0
	// Read: Enabled
	CCM_INTENSET_ERROR_Enabled = 0x1
	// Enable
	CCM_INTENSET_ERROR_Set = 0x1

	// INTENCLR: Disable interrupt
	// Position of ENDKSGEN field.
	CCM_INTENCLR_ENDKSGEN_Pos = 0x0
	// Bit mask of ENDKSGEN field.
	CCM_INTENCLR_ENDKSGEN_Msk = 0x1
	// Bit ENDKSGEN.
	CCM_INTENCLR_ENDKSGEN = 0x1
	// Read: Disabled
	CCM_INTENCLR_ENDKSGEN_Disabled = 0x0
	// Read: Enabled
	CCM_INTENCLR_ENDKSGEN_Enabled = 0x1
	// Disable
	CCM_INTENCLR_ENDKSGEN_Clear = 0x1
	// Position of ENDCRYPT field.
	CCM_INTENCLR_ENDCRYPT_Pos = 0x1
	// Bit mask of ENDCRYPT field.
	CCM_INTENCLR_ENDCRYPT_Msk = 0x2
	// Bit ENDCRYPT.
	CCM_INTENCLR_ENDCRYPT = 0x2
	// Read: Disabled
	CCM_INTENCLR_ENDCRYPT_Disabled = 0x0
	// Read: Enabled
	CCM_INTENCLR_ENDCRYPT_Enabled = 0x1
	// Disable
	CCM_INTENCLR_ENDCRYPT_Clear = 0x1
	// Position of ERROR field.
	CCM_INTENCLR_ERROR_Pos = 0x2
	// Bit mask of ERROR field.
	CCM_INTENCLR_ERROR_Msk = 0x4
	// Bit ERROR.
	CCM_INTENCLR_ERROR = 0x4
	// Read: Disabled
	CCM_INTENCLR_ERROR_Disabled = 0x0
	// Read: Enabled
	CCM_INTENCLR_ERROR_Enabled = 0x1
	// Disable
	CCM_INTENCLR_ERROR_Clear = 0x1

	// MICSTATUS: MIC check result
	// Position of MICSTATUS field.
	CCM_MICSTATUS_MICSTATUS_Pos = 0x0
	// Bit mask of MICSTATUS field.
	CCM_MICSTATUS_MICSTATUS_Msk = 0x1
	// Bit MICSTATUS.
	CCM_MICSTATUS_MICSTATUS = 0x1
	// MIC check failed
	CCM_MICSTATUS_MICSTATUS_CheckFailed = 0x0
	// MIC check passed
	CCM_MICSTATUS_MICSTATUS_CheckPassed = 0x1

	// ENABLE: Enable
	// Position of ENABLE field.
	CCM_ENABLE_ENABLE_Pos = 0x0
	// Bit mask of ENABLE field.
	CCM_ENABLE_ENABLE_Msk = 0x3
	// Disable
	CCM_ENABLE_ENABLE_Disabled = 0x0
	// Enable
	CCM_ENABLE_ENABLE_Enabled = 0x2

	// MODE: Operation mode
	// Position of MODE field.
	CCM_MODE_MODE_Pos = 0x0
	// Bit mask of MODE field.
	CCM_MODE_MODE_Msk = 0x1
	// Bit MODE.
	CCM_MODE_MODE = 0x1
	// AES CCM packet encryption mode
	CCM_MODE_MODE_Encryption = 0x0
	// AES CCM packet decryption mode
	CCM_MODE_MODE_Decryption = 0x1
	// Position of DATARATE field.
	CCM_MODE_DATARATE_Pos = 0x10
	// Bit mask of DATARATE field.
	CCM_MODE_DATARATE_Msk = 0x30000
	// 1 Mbps
	CCM_MODE_DATARATE_1Mbit = 0x0
	// 2 Mbps
	CCM_MODE_DATARATE_2Mbit = 0x1
	// 125 Kbps
	CCM_MODE_DATARATE_125Kbps = 0x2
	// 500 Kbps
	CCM_MODE_DATARATE_500Kbps = 0x3
	// Position of LENGTH field.
	CCM_MODE_LENGTH_Pos = 0x18
	// Bit mask of LENGTH field.
	CCM_MODE_LENGTH_Msk = 0x1000000
	// Bit LENGTH.
	CCM_MODE_LENGTH = 0x1000000
	// Default length. Effective length of LENGTH field in encrypted/decrypted packet is 5 bits. A key-stream for packet payloads up to 27 bytes will be generated.
	CCM_MODE_LENGTH_Default = 0x0
	// Extended length. Effective length of LENGTH field in encrypted/decrypted packet is 8 bits. A key-stream for packet payloads up to MAXPACKETSIZE bytes will be generated.
	CCM_MODE_LENGTH_Extended = 0x1

	// CNFPTR: Pointer to data structure holding AES key and NONCE vector
	// Position of CNFPTR field.
	CCM_CNFPTR_CNFPTR_Pos = 0x0
	// Bit mask of CNFPTR field.
	CCM_CNFPTR_CNFPTR_Msk = 0xffffffff

	// INPTR: Input pointer
	// Position of INPTR field.
	CCM_INPTR_INPTR_Pos = 0x0
	// Bit mask of INPTR field.
	CCM_INPTR_INPTR_Msk = 0xffffffff

	// OUTPTR: Output pointer
	// Position of OUTPTR field.
	CCM_OUTPTR_OUTPTR_Pos = 0x0
	// Bit mask of OUTPTR field.
	CCM_OUTPTR_OUTPTR_Msk = 0xffffffff

	// SCRATCHPTR: Pointer to data area used for temporary storage
	// Position of SCRATCHPTR field.
	CCM_SCRATCHPTR_SCRATCHPTR_Pos = 0x0
	// Bit mask of SCRATCHPTR field.
	CCM_SCRATCHPTR_SCRATCHPTR_Msk = 0xffffffff

	// MAXPACKETSIZE: Length of key-stream generated when MODE.LENGTH = Extended.
	// Position of MAXPACKETSIZE field.
	CCM_MAXPACKETSIZE_MAXPACKETSIZE_Pos = 0x0
	// Bit mask of MAXPACKETSIZE field.
	CCM_MAXPACKETSIZE_MAXPACKETSIZE_Msk = 0xff

	// RATEOVERRIDE: Data rate override setting.
	// Position of RATEOVERRIDE field.
	CCM_RATEOVERRIDE_RATEOVERRIDE_Pos = 0x0
	// Bit mask of RATEOVERRIDE field.
	CCM_RATEOVERRIDE_RATEOVERRIDE_Msk = 0x3
	// 1 Mbps
	CCM_RATEOVERRIDE_RATEOVERRIDE_1Mbit = 0x0
	// 2 Mbps
	CCM_RATEOVERRIDE_RATEOVERRIDE_2Mbit = 0x1
	// 125 Kbps
	CCM_RATEOVERRIDE_RATEOVERRIDE_125Kbps = 0x2
	// 500 Kbps
	CCM_RATEOVERRIDE_RATEOVERRIDE_500Kbps = 0x3
)

// Bitfields for WDT: Watchdog Timer
const (
	// TASKS_START: Start the watchdog
	// Position of TASKS_START field.
	WDT_TASKS_START_TASKS_START_Pos = 0x0
	// Bit mask of TASKS_START field.
	WDT_TASKS_START_TASKS_START_Msk = 0x1
	// Bit TASKS_START.
	WDT_TASKS_START_TASKS_START = 0x1
	// Trigger task
	WDT_TASKS_START_TASKS_START_Trigger = 0x1

	// EVENTS_TIMEOUT: Watchdog timeout
	// Position of EVENTS_TIMEOUT field.
	WDT_EVENTS_TIMEOUT_EVENTS_TIMEOUT_Pos = 0x0
	// Bit mask of EVENTS_TIMEOUT field.
	WDT_EVENTS_TIMEOUT_EVENTS_TIMEOUT_Msk = 0x1
	// Bit EVENTS_TIMEOUT.
	WDT_EVENTS_TIMEOUT_EVENTS_TIMEOUT = 0x1
	// Event not generated
	WDT_EVENTS_TIMEOUT_EVENTS_TIMEOUT_NotGenerated = 0x0
	// Event generated
	WDT_EVENTS_TIMEOUT_EVENTS_TIMEOUT_Generated = 0x1

	// INTENSET: Enable interrupt
	// Position of TIMEOUT field.
	WDT_INTENSET_TIMEOUT_Pos = 0x0
	// Bit mask of TIMEOUT field.
	WDT_INTENSET_TIMEOUT_Msk = 0x1
	// Bit TIMEOUT.
	WDT_INTENSET_TIMEOUT = 0x1
	// Read: Disabled
	WDT_INTENSET_TIMEOUT_Disabled = 0x0
	// Read: Enabled
	WDT_INTENSET_TIMEOUT_Enabled = 0x1
	// Enable
	WDT_INTENSET_TIMEOUT_Set = 0x1

	// INTENCLR: Disable interrupt
	// Position of TIMEOUT field.
	WDT_INTENCLR_TIMEOUT_Pos = 0x0
	// Bit mask of TIMEOUT field.
	WDT_INTENCLR_TIMEOUT_Msk = 0x1
	// Bit TIMEOUT.
	WDT_INTENCLR_TIMEOUT = 0x1
	// Read: Disabled
	WDT_INTENCLR_TIMEOUT_Disabled = 0x0
	// Read: Enabled
	WDT_INTENCLR_TIMEOUT_Enabled = 0x1
	// Disable
	WDT_INTENCLR_TIMEOUT_Clear = 0x1

	// RUNSTATUS: Run status
	// Position of RUNSTATUS field.
	WDT_RUNSTATUS_RUNSTATUS_Pos = 0x0
	// Bit mask of RUNSTATUS field.
	WDT_RUNSTATUS_RUNSTATUS_Msk = 0x1
	// Bit RUNSTATUS.
	WDT_RUNSTATUS_RUNSTATUS = 0x1
	// Watchdog not running
	WDT_RUNSTATUS_RUNSTATUS_NotRunning = 0x0
	// Watchdog is running
	WDT_RUNSTATUS_RUNSTATUS_Running = 0x1

	// REQSTATUS: Request status
	// Position of RR0 field.
	WDT_REQSTATUS_RR0_Pos = 0x0
	// Bit mask of RR0 field.
	WDT_REQSTATUS_RR0_Msk = 0x1
	// Bit RR0.
	WDT_REQSTATUS_RR0 = 0x1
	// RR[0] register is not enabled, or are already requesting reload
	WDT_REQSTATUS_RR0_DisabledOrRequested = 0x0
	// RR[0] register is enabled, and are not yet requesting reload
	WDT_REQSTATUS_RR0_EnabledAndUnrequested = 0x1
	// Position of RR1 field.
	WDT_REQSTATUS_RR1_Pos = 0x1
	// Bit mask of RR1 field.
	WDT_REQSTATUS_RR1_Msk = 0x2
	// Bit RR1.
	WDT_REQSTATUS_RR1 = 0x2
	// RR[1] register is not enabled, or are already requesting reload
	WDT_REQSTATUS_RR1_DisabledOrRequested = 0x0
	// RR[1] register is enabled, and are not yet requesting reload
	WDT_REQSTATUS_RR1_EnabledAndUnrequested = 0x1
	// Position of RR2 field.
	WDT_REQSTATUS_RR2_Pos = 0x2
	// Bit mask of RR2 field.
	WDT_REQSTATUS_RR2_Msk = 0x4
	// Bit RR2.
	WDT_REQSTATUS_RR2 = 0x4
	// RR[2] register is not enabled, or are already requesting reload
	WDT_REQSTATUS_RR2_DisabledOrRequested = 0x0
	// RR[2] register is enabled, and are not yet requesting reload
	WDT_REQSTATUS_RR2_EnabledAndUnrequested = 0x1
	// Position of RR3 field.
	WDT_REQSTATUS_RR3_Pos = 0x3
	// Bit mask of RR3 field.
	WDT_REQSTATUS_RR3_Msk = 0x8
	// Bit RR3.
	WDT_REQSTATUS_RR3 = 0x8
	// RR[3] register is not enabled, or are already requesting reload
	WDT_REQSTATUS_RR3_DisabledOrRequested = 0x0
	// RR[3] register is enabled, and are not yet requesting reload
	WDT_REQSTATUS_RR3_EnabledAndUnrequested = 0x1
	// Position of RR4 field.
	WDT_REQSTATUS_RR4_Pos = 0x4
	// Bit mask of RR4 field.
	WDT_REQSTATUS_RR4_Msk = 0x10
	// Bit RR4.
	WDT_REQSTATUS_RR4 = 0x10
	// RR[4] register is not enabled, or are already requesting reload
	WDT_REQSTATUS_RR4_DisabledOrRequested = 0x0
	// RR[4] register is enabled, and are not yet requesting reload
	WDT_REQSTATUS_RR4_EnabledAndUnrequested = 0x1
	// Position of RR5 field.
	WDT_REQSTATUS_RR5_Pos = 0x5
	// Bit mask of RR5 field.
	WDT_REQSTATUS_RR5_Msk = 0x20
	// Bit RR5.
	WDT_REQSTATUS_RR5 = 0x20
	// RR[5] register is not enabled, or are already requesting reload
	WDT_REQSTATUS_RR5_DisabledOrRequested = 0x0
	// RR[5] register is enabled, and are not yet requesting reload
	WDT_REQSTATUS_RR5_EnabledAndUnrequested = 0x1
	// Position of RR6 field.
	WDT_REQSTATUS_RR6_Pos = 0x6
	// Bit mask of RR6 field.
	WDT_REQSTATUS_RR6_Msk = 0x40
	// Bit RR6.
	WDT_REQSTATUS_RR6 = 0x40
	// RR[6] register is not enabled, or are already requesting reload
	WDT_REQSTATUS_RR6_DisabledOrRequested = 0x0
	// RR[6] register is enabled, and are not yet requesting reload
	WDT_REQSTATUS_RR6_EnabledAndUnrequested = 0x1
	// Position of RR7 field.
	WDT_REQSTATUS_RR7_Pos = 0x7
	// Bit mask of RR7 field.
	WDT_REQSTATUS_RR7_Msk = 0x80
	// Bit RR7.
	WDT_REQSTATUS_RR7 = 0x80
	// RR[7] register is not enabled, or are already requesting reload
	WDT_REQSTATUS_RR7_DisabledOrRequested = 0x0
	// RR[7] register is enabled, and are not yet requesting reload
	WDT_REQSTATUS_RR7_EnabledAndUnrequested = 0x1

	// CRV: Counter reload value
	// Position of CRV field.
	WDT_CRV_CRV_Pos = 0x0
	// Bit mask of CRV field.
	WDT_CRV_CRV_Msk = 0xffffffff

	// RREN: Enable register for reload request registers
	// Position of RR0 field.
	WDT_RREN_RR0_Pos = 0x0
	// Bit mask of RR0 field.
	WDT_RREN_RR0_Msk = 0x1
	// Bit RR0.
	WDT_RREN_RR0 = 0x1
	// Disable RR[0] register
	WDT_RREN_RR0_Disabled = 0x0
	// Enable RR[0] register
	WDT_RREN_RR0_Enabled = 0x1
	// Position of RR1 field.
	WDT_RREN_RR1_Pos = 0x1
	// Bit mask of RR1 field.
	WDT_RREN_RR1_Msk = 0x2
	// Bit RR1.
	WDT_RREN_RR1 = 0x2
	// Disable RR[1] register
	WDT_RREN_RR1_Disabled = 0x0
	// Enable RR[1] register
	WDT_RREN_RR1_Enabled = 0x1
	// Position of RR2 field.
	WDT_RREN_RR2_Pos = 0x2
	// Bit mask of RR2 field.
	WDT_RREN_RR2_Msk = 0x4
	// Bit RR2.
	WDT_RREN_RR2 = 0x4
	// Disable RR[2] register
	WDT_RREN_RR2_Disabled = 0x0
	// Enable RR[2] register
	WDT_RREN_RR2_Enabled = 0x1
	// Position of RR3 field.
	WDT_RREN_RR3_Pos = 0x3
	// Bit mask of RR3 field.
	WDT_RREN_RR3_Msk = 0x8
	// Bit RR3.
	WDT_RREN_RR3 = 0x8
	// Disable RR[3] register
	WDT_RREN_RR3_Disabled = 0x0
	// Enable RR[3] register
	WDT_RREN_RR3_Enabled = 0x1
	// Position of RR4 field.
	WDT_RREN_RR4_Pos = 0x4
	// Bit mask of RR4 field.
	WDT_RREN_RR4_Msk = 0x10
	// Bit RR4.
	WDT_RREN_RR4 = 0x10
	// Disable RR[4] register
	WDT_RREN_RR4_Disabled = 0x0
	// Enable RR[4] register
	WDT_RREN_RR4_Enabled = 0x1
	// Position of RR5 field.
	WDT_RREN_RR5_Pos = 0x5
	// Bit mask of RR5 field.
	WDT_RREN_RR5_Msk = 0x20
	// Bit RR5.
	WDT_RREN_RR5 = 0x20
	// Disable RR[5] register
	WDT_RREN_RR5_Disabled = 0x0
	// Enable RR[5] register
	WDT_RREN_RR5_Enabled = 0x1
	// Position of RR6 field.
	WDT_RREN_RR6_Pos = 0x6
	// Bit mask of RR6 field.
	WDT_RREN_RR6_Msk = 0x40
	// Bit RR6.
	WDT_RREN_RR6 = 0x40
	// Disable RR[6] register
	WDT_RREN_RR6_Disabled = 0x0
	// Enable RR[6] register
	WDT_RREN_RR6_Enabled = 0x1
	// Position of RR7 field.
	WDT_RREN_RR7_Pos = 0x7
	// Bit mask of RR7 field.
	WDT_RREN_RR7_Msk = 0x80
	// Bit RR7.
	WDT_RREN_RR7 = 0x80
	// Disable RR[7] register
	WDT_RREN_RR7_Disabled = 0x0
	// Enable RR[7] register
	WDT_RREN_RR7_Enabled = 0x1

	// CONFIG: Configuration register
	// Position of SLEEP field.
	WDT_CONFIG_SLEEP_Pos = 0x0
	// Bit mask of SLEEP field.
	WDT_CONFIG_SLEEP_Msk = 0x1
	// Bit SLEEP.
	WDT_CONFIG_SLEEP = 0x1
	// Pause watchdog while the CPU is sleeping
	WDT_CONFIG_SLEEP_Pause = 0x0
	// Keep the watchdog running while the CPU is sleeping
	WDT_CONFIG_SLEEP_Run = 0x1
	// Position of HALT field.
	WDT_CONFIG_HALT_Pos = 0x3
	// Bit mask of HALT field.
	WDT_CONFIG_HALT_Msk = 0x8
	// Bit HALT.
	WDT_CONFIG_HALT = 0x8
	// Pause watchdog while the CPU is halted by the debugger
	WDT_CONFIG_HALT_Pause = 0x0
	// Keep the watchdog running while the CPU is halted by the debugger
	WDT_CONFIG_HALT_Run = 0x1

	// RR: Description collection: Reload request n
	// Position of RR field.
	WDT_RR_RR_Pos = 0x0
	// Bit mask of RR field.
	WDT_RR_RR_Msk = 0xffffffff
	// Value to request a reload of the watchdog timer
	WDT_RR_RR_Reload = 0x6e524635
)

// Bitfields for QDEC: Quadrature Decoder
const (
	// TASKS_START: Task starting the quadrature decoder
	// Position of TASKS_START field.
	QDEC_TASKS_START_TASKS_START_Pos = 0x0
	// Bit mask of TASKS_START field.
	QDEC_TASKS_START_TASKS_START_Msk = 0x1
	// Bit TASKS_START.
	QDEC_TASKS_START_TASKS_START = 0x1
	// Trigger task
	QDEC_TASKS_START_TASKS_START_Trigger = 0x1

	// TASKS_STOP: Task stopping the quadrature decoder
	// Position of TASKS_STOP field.
	QDEC_TASKS_STOP_TASKS_STOP_Pos = 0x0
	// Bit mask of TASKS_STOP field.
	QDEC_TASKS_STOP_TASKS_STOP_Msk = 0x1
	// Bit TASKS_STOP.
	QDEC_TASKS_STOP_TASKS_STOP = 0x1
	// Trigger task
	QDEC_TASKS_STOP_TASKS_STOP_Trigger = 0x1

	// TASKS_READCLRACC: Read and clear ACC and ACCDBL
	// Position of TASKS_READCLRACC field.
	QDEC_TASKS_READCLRACC_TASKS_READCLRACC_Pos = 0x0
	// Bit mask of TASKS_READCLRACC field.
	QDEC_TASKS_READCLRACC_TASKS_READCLRACC_Msk = 0x1
	// Bit TASKS_READCLRACC.
	QDEC_TASKS_READCLRACC_TASKS_READCLRACC = 0x1
	// Trigger task
	QDEC_TASKS_READCLRACC_TASKS_READCLRACC_Trigger = 0x1

	// TASKS_RDCLRACC: Read and clear ACC
	// Position of TASKS_RDCLRACC field.
	QDEC_TASKS_RDCLRACC_TASKS_RDCLRACC_Pos = 0x0
	// Bit mask of TASKS_RDCLRACC field.
	QDEC_TASKS_RDCLRACC_TASKS_RDCLRACC_Msk = 0x1
	// Bit TASKS_RDCLRACC.
	QDEC_TASKS_RDCLRACC_TASKS_RDCLRACC = 0x1
	// Trigger task
	QDEC_TASKS_RDCLRACC_TASKS_RDCLRACC_Trigger = 0x1

	// TASKS_RDCLRDBL: Read and clear ACCDBL
	// Position of TASKS_RDCLRDBL field.
	QDEC_TASKS_RDCLRDBL_TASKS_RDCLRDBL_Pos = 0x0
	// Bit mask of TASKS_RDCLRDBL field.
	QDEC_TASKS_RDCLRDBL_TASKS_RDCLRDBL_Msk = 0x1
	// Bit TASKS_RDCLRDBL.
	QDEC_TASKS_RDCLRDBL_TASKS_RDCLRDBL = 0x1
	// Trigger task
	QDEC_TASKS_RDCLRDBL_TASKS_RDCLRDBL_Trigger = 0x1

	// EVENTS_SAMPLERDY: Event being generated for every new sample value written to the SAMPLE register
	// Position of EVENTS_SAMPLERDY field.
	QDEC_EVENTS_SAMPLERDY_EVENTS_SAMPLERDY_Pos = 0x0
	// Bit mask of EVENTS_SAMPLERDY field.
	QDEC_EVENTS_SAMPLERDY_EVENTS_SAMPLERDY_Msk = 0x1
	// Bit EVENTS_SAMPLERDY.
	QDEC_EVENTS_SAMPLERDY_EVENTS_SAMPLERDY = 0x1
	// Event not generated
	QDEC_EVENTS_SAMPLERDY_EVENTS_SAMPLERDY_NotGenerated = 0x0
	// Event generated
	QDEC_EVENTS_SAMPLERDY_EVENTS_SAMPLERDY_Generated = 0x1

	// EVENTS_REPORTRDY: Non-null report ready
	// Position of EVENTS_REPORTRDY field.
	QDEC_EVENTS_REPORTRDY_EVENTS_REPORTRDY_Pos = 0x0
	// Bit mask of EVENTS_REPORTRDY field.
	QDEC_EVENTS_REPORTRDY_EVENTS_REPORTRDY_Msk = 0x1
	// Bit EVENTS_REPORTRDY.
	QDEC_EVENTS_REPORTRDY_EVENTS_REPORTRDY = 0x1
	// Event not generated
	QDEC_EVENTS_REPORTRDY_EVENTS_REPORTRDY_NotGenerated = 0x0
	// Event generated
	QDEC_EVENTS_REPORTRDY_EVENTS_REPORTRDY_Generated = 0x1

	// EVENTS_ACCOF: ACC or ACCDBL register overflow
	// Position of EVENTS_ACCOF field.
	QDEC_EVENTS_ACCOF_EVENTS_ACCOF_Pos = 0x0
	// Bit mask of EVENTS_ACCOF field.
	QDEC_EVENTS_ACCOF_EVENTS_ACCOF_Msk = 0x1
	// Bit EVENTS_ACCOF.
	QDEC_EVENTS_ACCOF_EVENTS_ACCOF = 0x1
	// Event not generated
	QDEC_EVENTS_ACCOF_EVENTS_ACCOF_NotGenerated = 0x0
	// Event generated
	QDEC_EVENTS_ACCOF_EVENTS_ACCOF_Generated = 0x1

	// EVENTS_DBLRDY: Double displacement(s) detected
	// Position of EVENTS_DBLRDY field.
	QDEC_EVENTS_DBLRDY_EVENTS_DBLRDY_Pos = 0x0
	// Bit mask of EVENTS_DBLRDY field.
	QDEC_EVENTS_DBLRDY_EVENTS_DBLRDY_Msk = 0x1
	// Bit EVENTS_DBLRDY.
	QDEC_EVENTS_DBLRDY_EVENTS_DBLRDY = 0x1
	// Event not generated
	QDEC_EVENTS_DBLRDY_EVENTS_DBLRDY_NotGenerated = 0x0
	// Event generated
	QDEC_EVENTS_DBLRDY_EVENTS_DBLRDY_Generated = 0x1

	// EVENTS_STOPPED: QDEC has been stopped
	// Position of EVENTS_STOPPED field.
	QDEC_EVENTS_STOPPED_EVENTS_STOPPED_Pos = 0x0
	// Bit mask of EVENTS_STOPPED field.
	QDEC_EVENTS_STOPPED_EVENTS_STOPPED_Msk = 0x1
	// Bit EVENTS_STOPPED.
	QDEC_EVENTS_STOPPED_EVENTS_STOPPED = 0x1
	// Event not generated
	QDEC_EVENTS_STOPPED_EVENTS_STOPPED_NotGenerated = 0x0
	// Event generated
	QDEC_EVENTS_STOPPED_EVENTS_STOPPED_Generated = 0x1

	// SHORTS: Shortcuts between local events and tasks
	// Position of REPORTRDY_READCLRACC field.
	QDEC_SHORTS_REPORTRDY_READCLRACC_Pos = 0x0
	// Bit mask of REPORTRDY_READCLRACC field.
	QDEC_SHORTS_REPORTRDY_READCLRACC_Msk = 0x1
	// Bit REPORTRDY_READCLRACC.
	QDEC_SHORTS_REPORTRDY_READCLRACC = 0x1
	// Disable shortcut
	QDEC_SHORTS_REPORTRDY_READCLRACC_Disabled = 0x0
	// Enable shortcut
	QDEC_SHORTS_REPORTRDY_READCLRACC_Enabled = 0x1
	// Position of SAMPLERDY_STOP field.
	QDEC_SHORTS_SAMPLERDY_STOP_Pos = 0x1
	// Bit mask of SAMPLERDY_STOP field.
	QDEC_SHORTS_SAMPLERDY_STOP_Msk = 0x2
	// Bit SAMPLERDY_STOP.
	QDEC_SHORTS_SAMPLERDY_STOP = 0x2
	// Disable shortcut
	QDEC_SHORTS_SAMPLERDY_STOP_Disabled = 0x0
	// Enable shortcut
	QDEC_SHORTS_SAMPLERDY_STOP_Enabled = 0x1
	// Position of REPORTRDY_RDCLRACC field.
	QDEC_SHORTS_REPORTRDY_RDCLRACC_Pos = 0x2
	// Bit mask of REPORTRDY_RDCLRACC field.
	QDEC_SHORTS_REPORTRDY_RDCLRACC_Msk = 0x4
	// Bit REPORTRDY_RDCLRACC.
	QDEC_SHORTS_REPORTRDY_RDCLRACC = 0x4
	// Disable shortcut
	QDEC_SHORTS_REPORTRDY_RDCLRACC_Disabled = 0x0
	// Enable shortcut
	QDEC_SHORTS_REPORTRDY_RDCLRACC_Enabled = 0x1
	// Position of REPORTRDY_STOP field.
	QDEC_SHORTS_REPORTRDY_STOP_Pos = 0x3
	// Bit mask of REPORTRDY_STOP field.
	QDEC_SHORTS_REPORTRDY_STOP_Msk = 0x8
	// Bit REPORTRDY_STOP.
	QDEC_SHORTS_REPORTRDY_STOP = 0x8
	// Disable shortcut
	QDEC_SHORTS_REPORTRDY_STOP_Disabled = 0x0
	// Enable shortcut
	QDEC_SHORTS_REPORTRDY_STOP_Enabled = 0x1
	// Position of DBLRDY_RDCLRDBL field.
	QDEC_SHORTS_DBLRDY_RDCLRDBL_Pos = 0x4
	// Bit mask of DBLRDY_RDCLRDBL field.
	QDEC_SHORTS_DBLRDY_RDCLRDBL_Msk = 0x10
	// Bit DBLRDY_RDCLRDBL.
	QDEC_SHORTS_DBLRDY_RDCLRDBL = 0x10
	// Disable shortcut
	QDEC_SHORTS_DBLRDY_RDCLRDBL_Disabled = 0x0
	// Enable shortcut
	QDEC_SHORTS_DBLRDY_RDCLRDBL_Enabled = 0x1
	// Position of DBLRDY_STOP field.
	QDEC_SHORTS_DBLRDY_STOP_Pos = 0x5
	// Bit mask of DBLRDY_STOP field.
	QDEC_SHORTS_DBLRDY_STOP_Msk = 0x20
	// Bit DBLRDY_STOP.
	QDEC_SHORTS_DBLRDY_STOP = 0x20
	// Disable shortcut
	QDEC_SHORTS_DBLRDY_STOP_Disabled = 0x0
	// Enable shortcut
	QDEC_SHORTS_DBLRDY_STOP_Enabled = 0x1
	// Position of SAMPLERDY_READCLRACC field.
	QDEC_SHORTS_SAMPLERDY_READCLRACC_Pos = 0x6
	// Bit mask of SAMPLERDY_READCLRACC field.
	QDEC_SHORTS_SAMPLERDY_READCLRACC_Msk = 0x40
	// Bit SAMPLERDY_READCLRACC.
	QDEC_SHORTS_SAMPLERDY_READCLRACC = 0x40
	// Disable shortcut
	QDEC_SHORTS_SAMPLERDY_READCLRACC_Disabled = 0x0
	// Enable shortcut
	QDEC_SHORTS_SAMPLERDY_READCLRACC_Enabled = 0x1

	// INTENSET: Enable interrupt
	// Position of SAMPLERDY field.
	QDEC_INTENSET_SAMPLERDY_Pos = 0x0
	// Bit mask of SAMPLERDY field.
	QDEC_INTENSET_SAMPLERDY_Msk = 0x1
	// Bit SAMPLERDY.
	QDEC_INTENSET_SAMPLERDY = 0x1
	// Read: Disabled
	QDEC_INTENSET_SAMPLERDY_Disabled = 0x0
	// Read: Enabled
	QDEC_INTENSET_SAMPLERDY_Enabled = 0x1
	// Enable
	QDEC_INTENSET_SAMPLERDY_Set = 0x1
	// Position of REPORTRDY field.
	QDEC_INTENSET_REPORTRDY_Pos = 0x1
	// Bit mask of REPORTRDY field.
	QDEC_INTENSET_REPORTRDY_Msk = 0x2
	// Bit REPORTRDY.
	QDEC_INTENSET_REPORTRDY = 0x2
	// Read: Disabled
	QDEC_INTENSET_REPORTRDY_Disabled = 0x0
	// Read: Enabled
	QDEC_INTENSET_REPORTRDY_Enabled = 0x1
	// Enable
	QDEC_INTENSET_REPORTRDY_Set = 0x1
	// Position of ACCOF field.
	QDEC_INTENSET_ACCOF_Pos = 0x2
	// Bit mask of ACCOF field.
	QDEC_INTENSET_ACCOF_Msk = 0x4
	// Bit ACCOF.
	QDEC_INTENSET_ACCOF = 0x4
	// Read: Disabled
	QDEC_INTENSET_ACCOF_Disabled = 0x0
	// Read: Enabled
	QDEC_INTENSET_ACCOF_Enabled = 0x1
	// Enable
	QDEC_INTENSET_ACCOF_Set = 0x1
	// Position of DBLRDY field.
	QDEC_INTENSET_DBLRDY_Pos = 0x3
	// Bit mask of DBLRDY field.
	QDEC_INTENSET_DBLRDY_Msk = 0x8
	// Bit DBLRDY.
	QDEC_INTENSET_DBLRDY = 0x8
	// Read: Disabled
	QDEC_INTENSET_DBLRDY_Disabled = 0x0
	// Read: Enabled
	QDEC_INTENSET_DBLRDY_Enabled = 0x1
	// Enable
	QDEC_INTENSET_DBLRDY_Set = 0x1
	// Position of STOPPED field.
	QDEC_INTENSET_STOPPED_Pos = 0x4
	// Bit mask of STOPPED field.
	QDEC_INTENSET_STOPPED_Msk = 0x10
	// Bit STOPPED.
	QDEC_INTENSET_STOPPED = 0x10
	// Read: Disabled
	QDEC_INTENSET_STOPPED_Disabled = 0x0
	// Read: Enabled
	QDEC_INTENSET_STOPPED_Enabled = 0x1
	// Enable
	QDEC_INTENSET_STOPPED_Set = 0x1

	// INTENCLR: Disable interrupt
	// Position of SAMPLERDY field.
	QDEC_INTENCLR_SAMPLERDY_Pos = 0x0
	// Bit mask of SAMPLERDY field.
	QDEC_INTENCLR_SAMPLERDY_Msk = 0x1
	// Bit SAMPLERDY.
	QDEC_INTENCLR_SAMPLERDY = 0x1
	// Read: Disabled
	QDEC_INTENCLR_SAMPLERDY_Disabled = 0x0
	// Read: Enabled
	QDEC_INTENCLR_SAMPLERDY_Enabled = 0x1
	// Disable
	QDEC_INTENCLR_SAMPLERDY_Clear = 0x1
	// Position of REPORTRDY field.
	QDEC_INTENCLR_REPORTRDY_Pos = 0x1
	// Bit mask of REPORTRDY field.
	QDEC_INTENCLR_REPORTRDY_Msk = 0x2
	// Bit REPORTRDY.
	QDEC_INTENCLR_REPORTRDY = 0x2
	// Read: Disabled
	QDEC_INTENCLR_REPORTRDY_Disabled = 0x0
	// Read: Enabled
	QDEC_INTENCLR_REPORTRDY_Enabled = 0x1
	// Disable
	QDEC_INTENCLR_REPORTRDY_Clear = 0x1
	// Position of ACCOF field.
	QDEC_INTENCLR_ACCOF_Pos = 0x2
	// Bit mask of ACCOF field.
	QDEC_INTENCLR_ACCOF_Msk = 0x4
	// Bit ACCOF.
	QDEC_INTENCLR_ACCOF = 0x4
	// Read: Disabled
	QDEC_INTENCLR_ACCOF_Disabled = 0x0
	// Read: Enabled
	QDEC_INTENCLR_ACCOF_Enabled = 0x1
	// Disable
	QDEC_INTENCLR_ACCOF_Clear = 0x1
	// Position of DBLRDY field.
	QDEC_INTENCLR_DBLRDY_Pos = 0x3
	// Bit mask of DBLRDY field.
	QDEC_INTENCLR_DBLRDY_Msk = 0x8
	// Bit DBLRDY.
	QDEC_INTENCLR_DBLRDY = 0x8
	// Read: Disabled
	QDEC_INTENCLR_DBLRDY_Disabled = 0x0
	// Read: Enabled
	QDEC_INTENCLR_DBLRDY_Enabled = 0x1
	// Disable
	QDEC_INTENCLR_DBLRDY_Clear = 0x1
	// Position of STOPPED field.
	QDEC_INTENCLR_STOPPED_Pos = 0x4
	// Bit mask of STOPPED field.
	QDEC_INTENCLR_STOPPED_Msk = 0x10
	// Bit STOPPED.
	QDEC_INTENCLR_STOPPED = 0x10
	// Read: Disabled
	QDEC_INTENCLR_STOPPED_Disabled = 0x0
	// Read: Enabled
	QDEC_INTENCLR_STOPPED_Enabled = 0x1
	// Disable
	QDEC_INTENCLR_STOPPED_Clear = 0x1

	// ENABLE: Enable the quadrature decoder
	// Position of ENABLE field.
	QDEC_ENABLE_ENABLE_Pos = 0x0
	// Bit mask of ENABLE field.
	QDEC_ENABLE_ENABLE_Msk = 0x1
	// Bit ENABLE.
	QDEC_ENABLE_ENABLE = 0x1
	// Disable
	QDEC_ENABLE_ENABLE_Disabled = 0x0
	// Enable
	QDEC_ENABLE_ENABLE_Enabled = 0x1

	// LEDPOL: LED output pin polarity
	// Position of LEDPOL field.
	QDEC_LEDPOL_LEDPOL_Pos = 0x0
	// Bit mask of LEDPOL field.
	QDEC_LEDPOL_LEDPOL_Msk = 0x1
	// Bit LEDPOL.
	QDEC_LEDPOL_LEDPOL = 0x1
	// Led active on output pin low
	QDEC_LEDPOL_LEDPOL_ActiveLow = 0x0
	// Led active on output pin high
	QDEC_LEDPOL_LEDPOL_ActiveHigh = 0x1

	// SAMPLEPER: Sample period
	// Position of SAMPLEPER field.
	QDEC_SAMPLEPER_SAMPLEPER_Pos = 0x0
	// Bit mask of SAMPLEPER field.
	QDEC_SAMPLEPER_SAMPLEPER_Msk = 0xf
	// 128 us
	QDEC_SAMPLEPER_SAMPLEPER_128us = 0x0
	// 256 us
	QDEC_SAMPLEPER_SAMPLEPER_256us = 0x1
	// 512 us
	QDEC_SAMPLEPER_SAMPLEPER_512us = 0x2
	// 1024 us
	QDEC_SAMPLEPER_SAMPLEPER_1024us = 0x3
	// 2048 us
	QDEC_SAMPLEPER_SAMPLEPER_2048us = 0x4
	// 4096 us
	QDEC_SAMPLEPER_SAMPLEPER_4096us = 0x5
	// 8192 us
	QDEC_SAMPLEPER_SAMPLEPER_8192us = 0x6
	// 16384 us
	QDEC_SAMPLEPER_SAMPLEPER_16384us = 0x7
	// 32768 us
	QDEC_SAMPLEPER_SAMPLEPER_32ms = 0x8
	// 65536 us
	QDEC_SAMPLEPER_SAMPLEPER_65ms = 0x9
	// 131072 us
	QDEC_SAMPLEPER_SAMPLEPER_131ms = 0xa

	// SAMPLE: Motion sample value
	// Position of SAMPLE field.
	QDEC_SAMPLE_SAMPLE_Pos = 0x0
	// Bit mask of SAMPLE field.
	QDEC_SAMPLE_SAMPLE_Msk = 0xffffffff

	// REPORTPER: Number of samples to be taken before REPORTRDY and DBLRDY events can be generated
	// Position of REPORTPER field.
	QDEC_REPORTPER_REPORTPER_Pos = 0x0
	// Bit mask of REPORTPER field.
	QDEC_REPORTPER_REPORTPER_Msk = 0xf
	// 10 samples / report
	QDEC_REPORTPER_REPORTPER_10Smpl = 0x0
	// 40 samples / report
	QDEC_REPORTPER_REPORTPER_40Smpl = 0x1
	// 80 samples / report
	QDEC_REPORTPER_REPORTPER_80Smpl = 0x2
	// 120 samples / report
	QDEC_REPORTPER_REPORTPER_120Smpl = 0x3
	// 160 samples / report
	QDEC_REPORTPER_REPORTPER_160Smpl = 0x4
	// 200 samples / report
	QDEC_REPORTPER_REPORTPER_200Smpl = 0x5
	// 240 samples / report
	QDEC_REPORTPER_REPORTPER_240Smpl = 0x6
	// 280 samples / report
	QDEC_REPORTPER_REPORTPER_280Smpl = 0x7
	// 1 sample / report
	QDEC_REPORTPER_REPORTPER_1Smpl = 0x8

	// ACC: Register accumulating the valid transitions
	// Position of ACC field.
	QDEC_ACC_ACC_Pos = 0x0
	// Bit mask of ACC field.
	QDEC_ACC_ACC_Msk = 0xffffffff

	// ACCREAD: Snapshot of the ACC register, updated by the READCLRACC or RDCLRACC task
	// Position of ACCREAD field.
	QDEC_ACCREAD_ACCREAD_Pos = 0x0
	// Bit mask of ACCREAD field.
	QDEC_ACCREAD_ACCREAD_Msk = 0xffffffff

	// PSEL.LED: Pin select for LED signal
	// Position of PIN field.
	QDEC_PSEL_LED_PIN_Pos = 0x0
	// Bit mask of PIN field.
	QDEC_PSEL_LED_PIN_Msk = 0x1f
	// Position of PORT field.
	QDEC_PSEL_LED_PORT_Pos = 0x5
	// Bit mask of PORT field.
	QDEC_PSEL_LED_PORT_Msk = 0x20
	// Bit PORT.
	QDEC_PSEL_LED_PORT = 0x20
	// Position of CONNECT field.
	QDEC_PSEL_LED_CONNECT_Pos = 0x1f
	// Bit mask of CONNECT field.
	QDEC_PSEL_LED_CONNECT_Msk = 0x80000000
	// Bit CONNECT.
	QDEC_PSEL_LED_CONNECT = 0x80000000
	// Disconnect
	QDEC_PSEL_LED_CONNECT_Disconnected = 0x1
	// Connect
	QDEC_PSEL_LED_CONNECT_Connected = 0x0

	// PSEL.A: Pin select for A signal
	// Position of PIN field.
	QDEC_PSEL_A_PIN_Pos = 0x0
	// Bit mask of PIN field.
	QDEC_PSEL_A_PIN_Msk = 0x1f
	// Position of PORT field.
	QDEC_PSEL_A_PORT_Pos = 0x5
	// Bit mask of PORT field.
	QDEC_PSEL_A_PORT_Msk = 0x20
	// Bit PORT.
	QDEC_PSEL_A_PORT = 0x20
	// Position of CONNECT field.
	QDEC_PSEL_A_CONNECT_Pos = 0x1f
	// Bit mask of CONNECT field.
	QDEC_PSEL_A_CONNECT_Msk = 0x80000000
	// Bit CONNECT.
	QDEC_PSEL_A_CONNECT = 0x80000000
	// Disconnect
	QDEC_PSEL_A_CONNECT_Disconnected = 0x1
	// Connect
	QDEC_PSEL_A_CONNECT_Connected = 0x0

	// PSEL.B: Pin select for B signal
	// Position of PIN field.
	QDEC_PSEL_B_PIN_Pos = 0x0
	// Bit mask of PIN field.
	QDEC_PSEL_B_PIN_Msk = 0x1f
	// Position of PORT field.
	QDEC_PSEL_B_PORT_Pos = 0x5
	// Bit mask of PORT field.
	QDEC_PSEL_B_PORT_Msk = 0x20
	// Bit PORT.
	QDEC_PSEL_B_PORT = 0x20
	// Position of CONNECT field.
	QDEC_PSEL_B_CONNECT_Pos = 0x1f
	// Bit mask of CONNECT field.
	QDEC_PSEL_B_CONNECT_Msk = 0x80000000
	// Bit CONNECT.
	QDEC_PSEL_B_CONNECT = 0x80000000
	// Disconnect
	QDEC_PSEL_B_CONNECT_Disconnected = 0x1
	// Connect
	QDEC_PSEL_B_CONNECT_Connected = 0x0

	// DBFEN: Enable input debounce filters
	// Position of DBFEN field.
	QDEC_DBFEN_DBFEN_Pos = 0x0
	// Bit mask of DBFEN field.
	QDEC_DBFEN_DBFEN_Msk = 0x1
	// Bit DBFEN.
	QDEC_DBFEN_DBFEN = 0x1
	// Debounce input filters disabled
	QDEC_DBFEN_DBFEN_Disabled = 0x0
	// Debounce input filters enabled
	QDEC_DBFEN_DBFEN_Enabled = 0x1

	// LEDPRE: Time period the LED is switched ON prior to sampling
	// Position of LEDPRE field.
	QDEC_LEDPRE_LEDPRE_Pos = 0x0
	// Bit mask of LEDPRE field.
	QDEC_LEDPRE_LEDPRE_Msk = 0x1ff

	// ACCDBL: Register accumulating the number of detected double transitions
	// Position of ACCDBL field.
	QDEC_ACCDBL_ACCDBL_Pos = 0x0
	// Bit mask of ACCDBL field.
	QDEC_ACCDBL_ACCDBL_Msk = 0xf

	// ACCDBLREAD: Snapshot of the ACCDBL, updated by the READCLRACC or RDCLRDBL task
	// Position of ACCDBLREAD field.
	QDEC_ACCDBLREAD_ACCDBLREAD_Pos = 0x0
	// Bit mask of ACCDBLREAD field.
	QDEC_ACCDBLREAD_ACCDBLREAD_Msk = 0xf
)

// Bitfields for COMP: Comparator
const (
	// TASKS_START: Start comparator
	// Position of TASKS_START field.
	COMP_TASKS_START_TASKS_START_Pos = 0x0
	// Bit mask of TASKS_START field.
	COMP_TASKS_START_TASKS_START_Msk = 0x1
	// Bit TASKS_START.
	COMP_TASKS_START_TASKS_START = 0x1
	// Trigger task
	COMP_TASKS_START_TASKS_START_Trigger = 0x1

	// TASKS_STOP: Stop comparator
	// Position of TASKS_STOP field.
	COMP_TASKS_STOP_TASKS_STOP_Pos = 0x0
	// Bit mask of TASKS_STOP field.
	COMP_TASKS_STOP_TASKS_STOP_Msk = 0x1
	// Bit TASKS_STOP.
	COMP_TASKS_STOP_TASKS_STOP = 0x1
	// Trigger task
	COMP_TASKS_STOP_TASKS_STOP_Trigger = 0x1

	// TASKS_SAMPLE: Sample comparator value
	// Position of TASKS_SAMPLE field.
	COMP_TASKS_SAMPLE_TASKS_SAMPLE_Pos = 0x0
	// Bit mask of TASKS_SAMPLE field.
	COMP_TASKS_SAMPLE_TASKS_SAMPLE_Msk = 0x1
	// Bit TASKS_SAMPLE.
	COMP_TASKS_SAMPLE_TASKS_SAMPLE = 0x1
	// Trigger task
	COMP_TASKS_SAMPLE_TASKS_SAMPLE_Trigger = 0x1

	// EVENTS_READY: COMP is ready and output is valid
	// Position of EVENTS_READY field.
	COMP_EVENTS_READY_EVENTS_READY_Pos = 0x0
	// Bit mask of EVENTS_READY field.
	COMP_EVENTS_READY_EVENTS_READY_Msk = 0x1
	// Bit EVENTS_READY.
	COMP_EVENTS_READY_EVENTS_READY = 0x1
	// Event not generated
	COMP_EVENTS_READY_EVENTS_READY_NotGenerated = 0x0
	// Event generated
	COMP_EVENTS_READY_EVENTS_READY_Generated = 0x1

	// EVENTS_DOWN: Downward crossing
	// Position of EVENTS_DOWN field.
	COMP_EVENTS_DOWN_EVENTS_DOWN_Pos = 0x0
	// Bit mask of EVENTS_DOWN field.
	COMP_EVENTS_DOWN_EVENTS_DOWN_Msk = 0x1
	// Bit EVENTS_DOWN.
	COMP_EVENTS_DOWN_EVENTS_DOWN = 0x1
	// Event not generated
	COMP_EVENTS_DOWN_EVENTS_DOWN_NotGenerated = 0x0
	// Event generated
	COMP_EVENTS_DOWN_EVENTS_DOWN_Generated = 0x1

	// EVENTS_UP: Upward crossing
	// Position of EVENTS_UP field.
	COMP_EVENTS_UP_EVENTS_UP_Pos = 0x0
	// Bit mask of EVENTS_UP field.
	COMP_EVENTS_UP_EVENTS_UP_Msk = 0x1
	// Bit EVENTS_UP.
	COMP_EVENTS_UP_EVENTS_UP = 0x1
	// Event not generated
	COMP_EVENTS_UP_EVENTS_UP_NotGenerated = 0x0
	// Event generated
	COMP_EVENTS_UP_EVENTS_UP_Generated = 0x1

	// EVENTS_CROSS: Downward or upward crossing
	// Position of EVENTS_CROSS field.
	COMP_EVENTS_CROSS_EVENTS_CROSS_Pos = 0x0
	// Bit mask of EVENTS_CROSS field.
	COMP_EVENTS_CROSS_EVENTS_CROSS_Msk = 0x1
	// Bit EVENTS_CROSS.
	COMP_EVENTS_CROSS_EVENTS_CROSS = 0x1
	// Event not generated
	COMP_EVENTS_CROSS_EVENTS_CROSS_NotGenerated = 0x0
	// Event generated
	COMP_EVENTS_CROSS_EVENTS_CROSS_Generated = 0x1

	// SHORTS: Shortcuts between local events and tasks
	// Position of READY_SAMPLE field.
	COMP_SHORTS_READY_SAMPLE_Pos = 0x0
	// Bit mask of READY_SAMPLE field.
	COMP_SHORTS_READY_SAMPLE_Msk = 0x1
	// Bit READY_SAMPLE.
	COMP_SHORTS_READY_SAMPLE = 0x1
	// Disable shortcut
	COMP_SHORTS_READY_SAMPLE_Disabled = 0x0
	// Enable shortcut
	COMP_SHORTS_READY_SAMPLE_Enabled = 0x1
	// Position of READY_STOP field.
	COMP_SHORTS_READY_STOP_Pos = 0x1
	// Bit mask of READY_STOP field.
	COMP_SHORTS_READY_STOP_Msk = 0x2
	// Bit READY_STOP.
	COMP_SHORTS_READY_STOP = 0x2
	// Disable shortcut
	COMP_SHORTS_READY_STOP_Disabled = 0x0
	// Enable shortcut
	COMP_SHORTS_READY_STOP_Enabled = 0x1
	// Position of DOWN_STOP field.
	COMP_SHORTS_DOWN_STOP_Pos = 0x2
	// Bit mask of DOWN_STOP field.
	COMP_SHORTS_DOWN_STOP_Msk = 0x4
	// Bit DOWN_STOP.
	COMP_SHORTS_DOWN_STOP = 0x4
	// Disable shortcut
	COMP_SHORTS_DOWN_STOP_Disabled = 0x0
	// Enable shortcut
	COMP_SHORTS_DOWN_STOP_Enabled = 0x1
	// Position of UP_STOP field.
	COMP_SHORTS_UP_STOP_Pos = 0x3
	// Bit mask of UP_STOP field.
	COMP_SHORTS_UP_STOP_Msk = 0x8
	// Bit UP_STOP.
	COMP_SHORTS_UP_STOP = 0x8
	// Disable shortcut
	COMP_SHORTS_UP_STOP_Disabled = 0x0
	// Enable shortcut
	COMP_SHORTS_UP_STOP_Enabled = 0x1
	// Position of CROSS_STOP field.
	COMP_SHORTS_CROSS_STOP_Pos = 0x4
	// Bit mask of CROSS_STOP field.
	COMP_SHORTS_CROSS_STOP_Msk = 0x10
	// Bit CROSS_STOP.
	COMP_SHORTS_CROSS_STOP = 0x10
	// Disable shortcut
	COMP_SHORTS_CROSS_STOP_Disabled = 0x0
	// Enable shortcut
	COMP_SHORTS_CROSS_STOP_Enabled = 0x1

	// INTEN: Enable or disable interrupt
	// Position of READY field.
	COMP_INTEN_READY_Pos = 0x0
	// Bit mask of READY field.
	COMP_INTEN_READY_Msk = 0x1
	// Bit READY.
	COMP_INTEN_READY = 0x1
	// Disable
	COMP_INTEN_READY_Disabled = 0x0
	// Enable
	COMP_INTEN_READY_Enabled = 0x1
	// Position of DOWN field.
	COMP_INTEN_DOWN_Pos = 0x1
	// Bit mask of DOWN field.
	COMP_INTEN_DOWN_Msk = 0x2
	// Bit DOWN.
	COMP_INTEN_DOWN = 0x2
	// Disable
	COMP_INTEN_DOWN_Disabled = 0x0
	// Enable
	COMP_INTEN_DOWN_Enabled = 0x1
	// Position of UP field.
	COMP_INTEN_UP_Pos = 0x2
	// Bit mask of UP field.
	COMP_INTEN_UP_Msk = 0x4
	// Bit UP.
	COMP_INTEN_UP = 0x4
	// Disable
	COMP_INTEN_UP_Disabled = 0x0
	// Enable
	COMP_INTEN_UP_Enabled = 0x1
	// Position of CROSS field.
	COMP_INTEN_CROSS_Pos = 0x3
	// Bit mask of CROSS field.
	COMP_INTEN_CROSS_Msk = 0x8
	// Bit CROSS.
	COMP_INTEN_CROSS = 0x8
	// Disable
	COMP_INTEN_CROSS_Disabled = 0x0
	// Enable
	COMP_INTEN_CROSS_Enabled = 0x1

	// INTENSET: Enable interrupt
	// Position of READY field.
	COMP_INTENSET_READY_Pos = 0x0
	// Bit mask of READY field.
	COMP_INTENSET_READY_Msk = 0x1
	// Bit READY.
	COMP_INTENSET_READY = 0x1
	// Read: Disabled
	COMP_INTENSET_READY_Disabled = 0x0
	// Read: Enabled
	COMP_INTENSET_READY_Enabled = 0x1
	// Enable
	COMP_INTENSET_READY_Set = 0x1
	// Position of DOWN field.
	COMP_INTENSET_DOWN_Pos = 0x1
	// Bit mask of DOWN field.
	COMP_INTENSET_DOWN_Msk = 0x2
	// Bit DOWN.
	COMP_INTENSET_DOWN = 0x2
	// Read: Disabled
	COMP_INTENSET_DOWN_Disabled = 0x0
	// Read: Enabled
	COMP_INTENSET_DOWN_Enabled = 0x1
	// Enable
	COMP_INTENSET_DOWN_Set = 0x1
	// Position of UP field.
	COMP_INTENSET_UP_Pos = 0x2
	// Bit mask of UP field.
	COMP_INTENSET_UP_Msk = 0x4
	// Bit UP.
	COMP_INTENSET_UP = 0x4
	// Read: Disabled
	COMP_INTENSET_UP_Disabled = 0x0
	// Read: Enabled
	COMP_INTENSET_UP_Enabled = 0x1
	// Enable
	COMP_INTENSET_UP_Set = 0x1
	// Position of CROSS field.
	COMP_INTENSET_CROSS_Pos = 0x3
	// Bit mask of CROSS field.
	COMP_INTENSET_CROSS_Msk = 0x8
	// Bit CROSS.
	COMP_INTENSET_CROSS = 0x8
	// Read: Disabled
	COMP_INTENSET_CROSS_Disabled = 0x0
	// Read: Enabled
	COMP_INTENSET_CROSS_Enabled = 0x1
	// Enable
	COMP_INTENSET_CROSS_Set = 0x1

	// INTENCLR: Disable interrupt
	// Position of READY field.
	COMP_INTENCLR_READY_Pos = 0x0
	// Bit mask of READY field.
	COMP_INTENCLR_READY_Msk = 0x1
	// Bit READY.
	COMP_INTENCLR_READY = 0x1
	// Read: Disabled
	COMP_INTENCLR_READY_Disabled = 0x0
	// Read: Enabled
	COMP_INTENCLR_READY_Enabled = 0x1
	// Disable
	COMP_INTENCLR_READY_Clear = 0x1
	// Position of DOWN field.
	COMP_INTENCLR_DOWN_Pos = 0x1
	// Bit mask of DOWN field.
	COMP_INTENCLR_DOWN_Msk = 0x2
	// Bit DOWN.
	COMP_INTENCLR_DOWN = 0x2
	// Read: Disabled
	COMP_INTENCLR_DOWN_Disabled = 0x0
	// Read: Enabled
	COMP_INTENCLR_DOWN_Enabled = 0x1
	// Disable
	COMP_INTENCLR_DOWN_Clear = 0x1
	// Position of UP field.
	COMP_INTENCLR_UP_Pos = 0x2
	// Bit mask of UP field.
	COMP_INTENCLR_UP_Msk = 0x4
	// Bit UP.
	COMP_INTENCLR_UP = 0x4
	// Read: Disabled
	COMP_INTENCLR_UP_Disabled = 0x0
	// Read: Enabled
	COMP_INTENCLR_UP_Enabled = 0x1
	// Disable
	COMP_INTENCLR_UP_Clear = 0x1
	// Position of CROSS field.
	COMP_INTENCLR_CROSS_Pos = 0x3
	// Bit mask of CROSS field.
	COMP_INTENCLR_CROSS_Msk = 0x8
	// Bit CROSS.
	COMP_INTENCLR_CROSS = 0x8
	// Read: Disabled
	COMP_INTENCLR_CROSS_Disabled = 0x0
	// Read: Enabled
	COMP_INTENCLR_CROSS_Enabled = 0x1
	// Disable
	COMP_INTENCLR_CROSS_Clear = 0x1

	// RESULT: Compare result
	// Position of RESULT field.
	COMP_RESULT_RESULT_Pos = 0x0
	// Bit mask of RESULT field.
	COMP_RESULT_RESULT_Msk = 0x1
	// Bit RESULT.
	COMP_RESULT_RESULT = 0x1
	// Input voltage is below the threshold (VIN+ &lt; VIN-)
	COMP_RESULT_RESULT_Below = 0x0
	// Input voltage is above the threshold (VIN+ &gt; VIN-)
	COMP_RESULT_RESULT_Above = 0x1

	// ENABLE: COMP enable
	// Position of ENABLE field.
	COMP_ENABLE_ENABLE_Pos = 0x0
	// Bit mask of ENABLE field.
	COMP_ENABLE_ENABLE_Msk = 0x3
	// Disable
	COMP_ENABLE_ENABLE_Disabled = 0x0
	// Enable
	COMP_ENABLE_ENABLE_Enabled = 0x2

	// PSEL: Pin select
	// Position of PSEL field.
	COMP_PSEL_PSEL_Pos = 0x0
	// Bit mask of PSEL field.
	COMP_PSEL_PSEL_Msk = 0x7
	// AIN0 selected as analog input
	COMP_PSEL_PSEL_AnalogInput0 = 0x0
	// AIN1 selected as analog input
	COMP_PSEL_PSEL_AnalogInput1 = 0x1
	// AIN2 selected as analog input
	COMP_PSEL_PSEL_AnalogInput2 = 0x2
	// AIN3 selected as analog input
	COMP_PSEL_PSEL_AnalogInput3 = 0x3
	// AIN4 selected as analog input
	COMP_PSEL_PSEL_AnalogInput4 = 0x4
	// AIN5 selected as analog input
	COMP_PSEL_PSEL_AnalogInput5 = 0x5
	// AIN6 selected as analog input
	COMP_PSEL_PSEL_AnalogInput6 = 0x6
	// AIN7 selected as analog input
	COMP_PSEL_PSEL_AnalogInput7 = 0x7

	// REFSEL: Reference source select for single-ended mode
	// Position of REFSEL field.
	COMP_REFSEL_REFSEL_Pos = 0x0
	// Bit mask of REFSEL field.
	COMP_REFSEL_REFSEL_Msk = 0x7
	// VREF = internal 1.2 V reference (VDD &gt;= 1.7 V)
	COMP_REFSEL_REFSEL_Int1V2 = 0x0
	// VREF = internal 1.8 V reference (VDD &gt;= VREF + 0.2 V)
	COMP_REFSEL_REFSEL_Int1V8 = 0x1
	// VREF = internal 2.4 V reference (VDD &gt;= VREF + 0.2 V)
	COMP_REFSEL_REFSEL_Int2V4 = 0x2
	// VREF = VDD
	COMP_REFSEL_REFSEL_VDD = 0x4
	// VREF = AREF (VDD &gt;= VREF &gt;= AREFMIN)
	COMP_REFSEL_REFSEL_ARef = 0x5

	// EXTREFSEL: External reference select
	// Position of EXTREFSEL field.
	COMP_EXTREFSEL_EXTREFSEL_Pos = 0x0
	// Bit mask of EXTREFSEL field.
	COMP_EXTREFSEL_EXTREFSEL_Msk = 0x7
	// Use AIN0 as external analog reference
	COMP_EXTREFSEL_EXTREFSEL_AnalogReference0 = 0x0
	// Use AIN1 as external analog reference
	COMP_EXTREFSEL_EXTREFSEL_AnalogReference1 = 0x1
	// Use AIN2 as external analog reference
	COMP_EXTREFSEL_EXTREFSEL_AnalogReference2 = 0x2
	// Use AIN3 as external analog reference
	COMP_EXTREFSEL_EXTREFSEL_AnalogReference3 = 0x3
	// Use AIN4 as external analog reference
	COMP_EXTREFSEL_EXTREFSEL_AnalogReference4 = 0x4
	// Use AIN5 as external analog reference
	COMP_EXTREFSEL_EXTREFSEL_AnalogReference5 = 0x5
	// Use AIN6 as external analog reference
	COMP_EXTREFSEL_EXTREFSEL_AnalogReference6 = 0x6
	// Use AIN7 as external analog reference
	COMP_EXTREFSEL_EXTREFSEL_AnalogReference7 = 0x7

	// TH: Threshold configuration for hysteresis unit
	// Position of THDOWN field.
	COMP_TH_THDOWN_Pos = 0x0
	// Bit mask of THDOWN field.
	COMP_TH_THDOWN_Msk = 0x3f
	// Position of THUP field.
	COMP_TH_THUP_Pos = 0x8
	// Bit mask of THUP field.
	COMP_TH_THUP_Msk = 0x3f00

	// MODE: Mode configuration
	// Position of SP field.
	COMP_MODE_SP_Pos = 0x0
	// Bit mask of SP field.
	COMP_MODE_SP_Msk = 0x3
	// Low-power mode
	COMP_MODE_SP_Low = 0x0
	// Normal mode
	COMP_MODE_SP_Normal = 0x1
	// High-speed mode
	COMP_MODE_SP_High = 0x2
	// Position of MAIN field.
	COMP_MODE_MAIN_Pos = 0x8
	// Bit mask of MAIN field.
	COMP_MODE_MAIN_Msk = 0x100
	// Bit MAIN.
	COMP_MODE_MAIN = 0x100
	// Single-ended mode
	COMP_MODE_MAIN_SE = 0x0
	// Differential mode
	COMP_MODE_MAIN_Diff = 0x1

	// HYST: Comparator hysteresis enable
	// Position of HYST field.
	COMP_HYST_HYST_Pos = 0x0
	// Bit mask of HYST field.
	COMP_HYST_HYST_Msk = 0x1
	// Bit HYST.
	COMP_HYST_HYST = 0x1
	// Comparator hysteresis disabled
	COMP_HYST_HYST_NoHyst = 0x0
	// Comparator hysteresis enabled
	COMP_HYST_HYST_Hyst50mV = 0x1
)

// Bitfields for LPCOMP: Low Power Comparator
const (
	// TASKS_START: Start comparator
	// Position of TASKS_START field.
	LPCOMP_TASKS_START_TASKS_START_Pos = 0x0
	// Bit mask of TASKS_START field.
	LPCOMP_TASKS_START_TASKS_START_Msk = 0x1
	// Bit TASKS_START.
	LPCOMP_TASKS_START_TASKS_START = 0x1
	// Trigger task
	LPCOMP_TASKS_START_TASKS_START_Trigger = 0x1

	// TASKS_STOP: Stop comparator
	// Position of TASKS_STOP field.
	LPCOMP_TASKS_STOP_TASKS_STOP_Pos = 0x0
	// Bit mask of TASKS_STOP field.
	LPCOMP_TASKS_STOP_TASKS_STOP_Msk = 0x1
	// Bit TASKS_STOP.
	LPCOMP_TASKS_STOP_TASKS_STOP = 0x1
	// Trigger task
	LPCOMP_TASKS_STOP_TASKS_STOP_Trigger = 0x1

	// TASKS_SAMPLE: Sample comparator value
	// Position of TASKS_SAMPLE field.
	LPCOMP_TASKS_SAMPLE_TASKS_SAMPLE_Pos = 0x0
	// Bit mask of TASKS_SAMPLE field.
	LPCOMP_TASKS_SAMPLE_TASKS_SAMPLE_Msk = 0x1
	// Bit TASKS_SAMPLE.
	LPCOMP_TASKS_SAMPLE_TASKS_SAMPLE = 0x1
	// Trigger task
	LPCOMP_TASKS_SAMPLE_TASKS_SAMPLE_Trigger = 0x1

	// EVENTS_READY: LPCOMP is ready and output is valid
	// Position of EVENTS_READY field.
	LPCOMP_EVENTS_READY_EVENTS_READY_Pos = 0x0
	// Bit mask of EVENTS_READY field.
	LPCOMP_EVENTS_READY_EVENTS_READY_Msk = 0x1
	// Bit EVENTS_READY.
	LPCOMP_EVENTS_READY_EVENTS_READY = 0x1
	// Event not generated
	LPCOMP_EVENTS_READY_EVENTS_READY_NotGenerated = 0x0
	// Event generated
	LPCOMP_EVENTS_READY_EVENTS_READY_Generated = 0x1

	// EVENTS_DOWN: Downward crossing
	// Position of EVENTS_DOWN field.
	LPCOMP_EVENTS_DOWN_EVENTS_DOWN_Pos = 0x0
	// Bit mask of EVENTS_DOWN field.
	LPCOMP_EVENTS_DOWN_EVENTS_DOWN_Msk = 0x1
	// Bit EVENTS_DOWN.
	LPCOMP_EVENTS_DOWN_EVENTS_DOWN = 0x1
	// Event not generated
	LPCOMP_EVENTS_DOWN_EVENTS_DOWN_NotGenerated = 0x0
	// Event generated
	LPCOMP_EVENTS_DOWN_EVENTS_DOWN_Generated = 0x1

	// EVENTS_UP: Upward crossing
	// Position of EVENTS_UP field.
	LPCOMP_EVENTS_UP_EVENTS_UP_Pos = 0x0
	// Bit mask of EVENTS_UP field.
	LPCOMP_EVENTS_UP_EVENTS_UP_Msk = 0x1
	// Bit EVENTS_UP.
	LPCOMP_EVENTS_UP_EVENTS_UP = 0x1
	// Event not generated
	LPCOMP_EVENTS_UP_EVENTS_UP_NotGenerated = 0x0
	// Event generated
	LPCOMP_EVENTS_UP_EVENTS_UP_Generated = 0x1

	// EVENTS_CROSS: Downward or upward crossing
	// Position of EVENTS_CROSS field.
	LPCOMP_EVENTS_CROSS_EVENTS_CROSS_Pos = 0x0
	// Bit mask of EVENTS_CROSS field.
	LPCOMP_EVENTS_CROSS_EVENTS_CROSS_Msk = 0x1
	// Bit EVENTS_CROSS.
	LPCOMP_EVENTS_CROSS_EVENTS_CROSS = 0x1
	// Event not generated
	LPCOMP_EVENTS_CROSS_EVENTS_CROSS_NotGenerated = 0x0
	// Event generated
	LPCOMP_EVENTS_CROSS_EVENTS_CROSS_Generated = 0x1

	// SHORTS: Shortcuts between local events and tasks
	// Position of READY_SAMPLE field.
	LPCOMP_SHORTS_READY_SAMPLE_Pos = 0x0
	// Bit mask of READY_SAMPLE field.
	LPCOMP_SHORTS_READY_SAMPLE_Msk = 0x1
	// Bit READY_SAMPLE.
	LPCOMP_SHORTS_READY_SAMPLE = 0x1
	// Disable shortcut
	LPCOMP_SHORTS_READY_SAMPLE_Disabled = 0x0
	// Enable shortcut
	LPCOMP_SHORTS_READY_SAMPLE_Enabled = 0x1
	// Position of READY_STOP field.
	LPCOMP_SHORTS_READY_STOP_Pos = 0x1
	// Bit mask of READY_STOP field.
	LPCOMP_SHORTS_READY_STOP_Msk = 0x2
	// Bit READY_STOP.
	LPCOMP_SHORTS_READY_STOP = 0x2
	// Disable shortcut
	LPCOMP_SHORTS_READY_STOP_Disabled = 0x0
	// Enable shortcut
	LPCOMP_SHORTS_READY_STOP_Enabled = 0x1
	// Position of DOWN_STOP field.
	LPCOMP_SHORTS_DOWN_STOP_Pos = 0x2
	// Bit mask of DOWN_STOP field.
	LPCOMP_SHORTS_DOWN_STOP_Msk = 0x4
	// Bit DOWN_STOP.
	LPCOMP_SHORTS_DOWN_STOP = 0x4
	// Disable shortcut
	LPCOMP_SHORTS_DOWN_STOP_Disabled = 0x0
	// Enable shortcut
	LPCOMP_SHORTS_DOWN_STOP_Enabled = 0x1
	// Position of UP_STOP field.
	LPCOMP_SHORTS_UP_STOP_Pos = 0x3
	// Bit mask of UP_STOP field.
	LPCOMP_SHORTS_UP_STOP_Msk = 0x8
	// Bit UP_STOP.
	LPCOMP_SHORTS_UP_STOP = 0x8
	// Disable shortcut
	LPCOMP_SHORTS_UP_STOP_Disabled = 0x0
	// Enable shortcut
	LPCOMP_SHORTS_UP_STOP_Enabled = 0x1
	// Position of CROSS_STOP field.
	LPCOMP_SHORTS_CROSS_STOP_Pos = 0x4
	// Bit mask of CROSS_STOP field.
	LPCOMP_SHORTS_CROSS_STOP_Msk = 0x10
	// Bit CROSS_STOP.
	LPCOMP_SHORTS_CROSS_STOP = 0x10
	// Disable shortcut
	LPCOMP_SHORTS_CROSS_STOP_Disabled = 0x0
	// Enable shortcut
	LPCOMP_SHORTS_CROSS_STOP_Enabled = 0x1

	// INTENSET: Enable interrupt
	// Position of READY field.
	LPCOMP_INTENSET_READY_Pos = 0x0
	// Bit mask of READY field.
	LPCOMP_INTENSET_READY_Msk = 0x1
	// Bit READY.
	LPCOMP_INTENSET_READY = 0x1
	// Read: Disabled
	LPCOMP_INTENSET_READY_Disabled = 0x0
	// Read: Enabled
	LPCOMP_INTENSET_READY_Enabled = 0x1
	// Enable
	LPCOMP_INTENSET_READY_Set = 0x1
	// Position of DOWN field.
	LPCOMP_INTENSET_DOWN_Pos = 0x1
	// Bit mask of DOWN field.
	LPCOMP_INTENSET_DOWN_Msk = 0x2
	// Bit DOWN.
	LPCOMP_INTENSET_DOWN = 0x2
	// Read: Disabled
	LPCOMP_INTENSET_DOWN_Disabled = 0x0
	// Read: Enabled
	LPCOMP_INTENSET_DOWN_Enabled = 0x1
	// Enable
	LPCOMP_INTENSET_DOWN_Set = 0x1
	// Position of UP field.
	LPCOMP_INTENSET_UP_Pos = 0x2
	// Bit mask of UP field.
	LPCOMP_INTENSET_UP_Msk = 0x4
	// Bit UP.
	LPCOMP_INTENSET_UP = 0x4
	// Read: Disabled
	LPCOMP_INTENSET_UP_Disabled = 0x0
	// Read: Enabled
	LPCOMP_INTENSET_UP_Enabled = 0x1
	// Enable
	LPCOMP_INTENSET_UP_Set = 0x1
	// Position of CROSS field.
	LPCOMP_INTENSET_CROSS_Pos = 0x3
	// Bit mask of CROSS field.
	LPCOMP_INTENSET_CROSS_Msk = 0x8
	// Bit CROSS.
	LPCOMP_INTENSET_CROSS = 0x8
	// Read: Disabled
	LPCOMP_INTENSET_CROSS_Disabled = 0x0
	// Read: Enabled
	LPCOMP_INTENSET_CROSS_Enabled = 0x1
	// Enable
	LPCOMP_INTENSET_CROSS_Set = 0x1

	// INTENCLR: Disable interrupt
	// Position of READY field.
	LPCOMP_INTENCLR_READY_Pos = 0x0
	// Bit mask of READY field.
	LPCOMP_INTENCLR_READY_Msk = 0x1
	// Bit READY.
	LPCOMP_INTENCLR_READY = 0x1
	// Read: Disabled
	LPCOMP_INTENCLR_READY_Disabled = 0x0
	// Read: Enabled
	LPCOMP_INTENCLR_READY_Enabled = 0x1
	// Disable
	LPCOMP_INTENCLR_READY_Clear = 0x1
	// Position of DOWN field.
	LPCOMP_INTENCLR_DOWN_Pos = 0x1
	// Bit mask of DOWN field.
	LPCOMP_INTENCLR_DOWN_Msk = 0x2
	// Bit DOWN.
	LPCOMP_INTENCLR_DOWN = 0x2
	// Read: Disabled
	LPCOMP_INTENCLR_DOWN_Disabled = 0x0
	// Read: Enabled
	LPCOMP_INTENCLR_DOWN_Enabled = 0x1
	// Disable
	LPCOMP_INTENCLR_DOWN_Clear = 0x1
	// Position of UP field.
	LPCOMP_INTENCLR_UP_Pos = 0x2
	// Bit mask of UP field.
	LPCOMP_INTENCLR_UP_Msk = 0x4
	// Bit UP.
	LPCOMP_INTENCLR_UP = 0x4
	// Read: Disabled
	LPCOMP_INTENCLR_UP_Disabled = 0x0
	// Read: Enabled
	LPCOMP_INTENCLR_UP_Enabled = 0x1
	// Disable
	LPCOMP_INTENCLR_UP_Clear = 0x1
	// Position of CROSS field.
	LPCOMP_INTENCLR_CROSS_Pos = 0x3
	// Bit mask of CROSS field.
	LPCOMP_INTENCLR_CROSS_Msk = 0x8
	// Bit CROSS.
	LPCOMP_INTENCLR_CROSS = 0x8
	// Read: Disabled
	LPCOMP_INTENCLR_CROSS_Disabled = 0x0
	// Read: Enabled
	LPCOMP_INTENCLR_CROSS_Enabled = 0x1
	// Disable
	LPCOMP_INTENCLR_CROSS_Clear = 0x1

	// RESULT: Compare result
	// Position of RESULT field.
	LPCOMP_RESULT_RESULT_Pos = 0x0
	// Bit mask of RESULT field.
	LPCOMP_RESULT_RESULT_Msk = 0x1
	// Bit RESULT.
	LPCOMP_RESULT_RESULT = 0x1
	// Input voltage is below the reference threshold (VIN+ &lt; VIN-).
	LPCOMP_RESULT_RESULT_Below = 0x0
	// Input voltage is above the reference threshold (VIN+ &gt; VIN-).
	LPCOMP_RESULT_RESULT_Above = 0x1

	// ENABLE: Enable LPCOMP
	// Position of ENABLE field.
	LPCOMP_ENABLE_ENABLE_Pos = 0x0
	// Bit mask of ENABLE field.
	LPCOMP_ENABLE_ENABLE_Msk = 0x3
	// Disable
	LPCOMP_ENABLE_ENABLE_Disabled = 0x0
	// Enable
	LPCOMP_ENABLE_ENABLE_Enabled = 0x1

	// PSEL: Input pin select
	// Position of PSEL field.
	LPCOMP_PSEL_PSEL_Pos = 0x0
	// Bit mask of PSEL field.
	LPCOMP_PSEL_PSEL_Msk = 0x7
	// AIN0 selected as analog input
	LPCOMP_PSEL_PSEL_AnalogInput0 = 0x0
	// AIN1 selected as analog input
	LPCOMP_PSEL_PSEL_AnalogInput1 = 0x1
	// AIN2 selected as analog input
	LPCOMP_PSEL_PSEL_AnalogInput2 = 0x2
	// AIN3 selected as analog input
	LPCOMP_PSEL_PSEL_AnalogInput3 = 0x3
	// AIN4 selected as analog input
	LPCOMP_PSEL_PSEL_AnalogInput4 = 0x4
	// AIN5 selected as analog input
	LPCOMP_PSEL_PSEL_AnalogInput5 = 0x5
	// AIN6 selected as analog input
	LPCOMP_PSEL_PSEL_AnalogInput6 = 0x6
	// AIN7 selected as analog input
	LPCOMP_PSEL_PSEL_AnalogInput7 = 0x7

	// REFSEL: Reference select
	// Position of REFSEL field.
	LPCOMP_REFSEL_REFSEL_Pos = 0x0
	// Bit mask of REFSEL field.
	LPCOMP_REFSEL_REFSEL_Msk = 0xf
	// VDD * 1/8 selected as reference
	LPCOMP_REFSEL_REFSEL_Ref1_8Vdd = 0x0
	// VDD * 2/8 selected as reference
	LPCOMP_REFSEL_REFSEL_Ref2_8Vdd = 0x1
	// VDD * 3/8 selected as reference
	LPCOMP_REFSEL_REFSEL_Ref3_8Vdd = 0x2
	// VDD * 4/8 selected as reference
	LPCOMP_REFSEL_REFSEL_Ref4_8Vdd = 0x3
	// VDD * 5/8 selected as reference
	LPCOMP_REFSEL_REFSEL_Ref5_8Vdd = 0x4
	// VDD * 6/8 selected as reference
	LPCOMP_REFSEL_REFSEL_Ref6_8Vdd = 0x5
	// VDD * 7/8 selected as reference
	LPCOMP_REFSEL_REFSEL_Ref7_8Vdd = 0x6
	// External analog reference selected
	LPCOMP_REFSEL_REFSEL_ARef = 0x7
	// VDD * 1/16 selected as reference
	LPCOMP_REFSEL_REFSEL_Ref1_16Vdd = 0x8
	// VDD * 3/16 selected as reference
	LPCOMP_REFSEL_REFSEL_Ref3_16Vdd = 0x9
	// VDD * 5/16 selected as reference
	LPCOMP_REFSEL_REFSEL_Ref5_16Vdd = 0xa
	// VDD * 7/16 selected as reference
	LPCOMP_REFSEL_REFSEL_Ref7_16Vdd = 0xb
	// VDD * 9/16 selected as reference
	LPCOMP_REFSEL_REFSEL_Ref9_16Vdd = 0xc
	// VDD * 11/16 selected as reference
	LPCOMP_REFSEL_REFSEL_Ref11_16Vdd = 0xd
	// VDD * 13/16 selected as reference
	LPCOMP_REFSEL_REFSEL_Ref13_16Vdd = 0xe
	// VDD * 15/16 selected as reference
	LPCOMP_REFSEL_REFSEL_Ref15_16Vdd = 0xf

	// EXTREFSEL: External reference select
	// Position of EXTREFSEL field.
	LPCOMP_EXTREFSEL_EXTREFSEL_Pos = 0x0
	// Bit mask of EXTREFSEL field.
	LPCOMP_EXTREFSEL_EXTREFSEL_Msk = 0x1
	// Bit EXTREFSEL.
	LPCOMP_EXTREFSEL_EXTREFSEL = 0x1
	// Use AIN0 as external analog reference
	LPCOMP_EXTREFSEL_EXTREFSEL_AnalogReference0 = 0x0
	// Use AIN1 as external analog reference
	LPCOMP_EXTREFSEL_EXTREFSEL_AnalogReference1 = 0x1

	// ANADETECT: Analog detect configuration
	// Position of ANADETECT field.
	LPCOMP_ANADETECT_ANADETECT_Pos = 0x0
	// Bit mask of ANADETECT field.
	LPCOMP_ANADETECT_ANADETECT_Msk = 0x3
	// Generate ANADETECT on crossing, both upward crossing and downward crossing
	LPCOMP_ANADETECT_ANADETECT_Cross = 0x0
	// Generate ANADETECT on upward crossing only
	LPCOMP_ANADETECT_ANADETECT_Up = 0x1
	// Generate ANADETECT on downward crossing only
	LPCOMP_ANADETECT_ANADETECT_Down = 0x2

	// HYST: Comparator hysteresis enable
	// Position of HYST field.
	LPCOMP_HYST_HYST_Pos = 0x0
	// Bit mask of HYST field.
	LPCOMP_HYST_HYST_Msk = 0x1
	// Bit HYST.
	LPCOMP_HYST_HYST = 0x1
	// Comparator hysteresis disabled
	LPCOMP_HYST_HYST_Disabled = 0x0
	// Comparator hysteresis enabled
	LPCOMP_HYST_HYST_Enabled = 0x1
)

// Bitfields for EGU0: Event Generator Unit 0
const (
	// TASKS_TRIGGER: Description collection: Trigger n for triggering the corresponding TRIGGERED[n] event
	// Position of TASKS_TRIGGER field.
	EGU_TASKS_TRIGGER_TASKS_TRIGGER_Pos = 0x0
	// Bit mask of TASKS_TRIGGER field.
	EGU_TASKS_TRIGGER_TASKS_TRIGGER_Msk = 0x1
	// Bit TASKS_TRIGGER.
	EGU_TASKS_TRIGGER_TASKS_TRIGGER = 0x1
	// Trigger task
	EGU_TASKS_TRIGGER_TASKS_TRIGGER_Trigger = 0x1

	// EVENTS_TRIGGERED: Description collection: Event number n generated by triggering the corresponding TRIGGER[n] task
	// Position of EVENTS_TRIGGERED field.
	EGU_EVENTS_TRIGGERED_EVENTS_TRIGGERED_Pos = 0x0
	// Bit mask of EVENTS_TRIGGERED field.
	EGU_EVENTS_TRIGGERED_EVENTS_TRIGGERED_Msk = 0x1
	// Bit EVENTS_TRIGGERED.
	EGU_EVENTS_TRIGGERED_EVENTS_TRIGGERED = 0x1
	// Event not generated
	EGU_EVENTS_TRIGGERED_EVENTS_TRIGGERED_NotGenerated = 0x0
	// Event generated
	EGU_EVENTS_TRIGGERED_EVENTS_TRIGGERED_Generated = 0x1

	// INTEN: Enable or disable interrupt
	// Position of TRIGGERED0 field.
	EGU_INTEN_TRIGGERED0_Pos = 0x0
	// Bit mask of TRIGGERED0 field.
	EGU_INTEN_TRIGGERED0_Msk = 0x1
	// Bit TRIGGERED0.
	EGU_INTEN_TRIGGERED0 = 0x1
	// Disable
	EGU_INTEN_TRIGGERED0_Disabled = 0x0
	// Enable
	EGU_INTEN_TRIGGERED0_Enabled = 0x1
	// Position of TRIGGERED1 field.
	EGU_INTEN_TRIGGERED1_Pos = 0x1
	// Bit mask of TRIGGERED1 field.
	EGU_INTEN_TRIGGERED1_Msk = 0x2
	// Bit TRIGGERED1.
	EGU_INTEN_TRIGGERED1 = 0x2
	// Disable
	EGU_INTEN_TRIGGERED1_Disabled = 0x0
	// Enable
	EGU_INTEN_TRIGGERED1_Enabled = 0x1
	// Position of TRIGGERED2 field.
	EGU_INTEN_TRIGGERED2_Pos = 0x2
	// Bit mask of TRIGGERED2 field.
	EGU_INTEN_TRIGGERED2_Msk = 0x4
	// Bit TRIGGERED2.
	EGU_INTEN_TRIGGERED2 = 0x4
	// Disable
	EGU_INTEN_TRIGGERED2_Disabled = 0x0
	// Enable
	EGU_INTEN_TRIGGERED2_Enabled = 0x1
	// Position of TRIGGERED3 field.
	EGU_INTEN_TRIGGERED3_Pos = 0x3
	// Bit mask of TRIGGERED3 field.
	EGU_INTEN_TRIGGERED3_Msk = 0x8
	// Bit TRIGGERED3.
	EGU_INTEN_TRIGGERED3 = 0x8
	// Disable
	EGU_INTEN_TRIGGERED3_Disabled = 0x0
	// Enable
	EGU_INTEN_TRIGGERED3_Enabled = 0x1
	// Position of TRIGGERED4 field.
	EGU_INTEN_TRIGGERED4_Pos = 0x4
	// Bit mask of TRIGGERED4 field.
	EGU_INTEN_TRIGGERED4_Msk = 0x10
	// Bit TRIGGERED4.
	EGU_INTEN_TRIGGERED4 = 0x10
	// Disable
	EGU_INTEN_TRIGGERED4_Disabled = 0x0
	// Enable
	EGU_INTEN_TRIGGERED4_Enabled = 0x1
	// Position of TRIGGERED5 field.
	EGU_INTEN_TRIGGERED5_Pos = 0x5
	// Bit mask of TRIGGERED5 field.
	EGU_INTEN_TRIGGERED5_Msk = 0x20
	// Bit TRIGGERED5.
	EGU_INTEN_TRIGGERED5 = 0x20
	// Disable
	EGU_INTEN_TRIGGERED5_Disabled = 0x0
	// Enable
	EGU_INTEN_TRIGGERED5_Enabled = 0x1
	// Position of TRIGGERED6 field.
	EGU_INTEN_TRIGGERED6_Pos = 0x6
	// Bit mask of TRIGGERED6 field.
	EGU_INTEN_TRIGGERED6_Msk = 0x40
	// Bit TRIGGERED6.
	EGU_INTEN_TRIGGERED6 = 0x40
	// Disable
	EGU_INTEN_TRIGGERED6_Disabled = 0x0
	// Enable
	EGU_INTEN_TRIGGERED6_Enabled = 0x1
	// Position of TRIGGERED7 field.
	EGU_INTEN_TRIGGERED7_Pos = 0x7
	// Bit mask of TRIGGERED7 field.
	EGU_INTEN_TRIGGERED7_Msk = 0x80
	// Bit TRIGGERED7.
	EGU_INTEN_TRIGGERED7 = 0x80
	// Disable
	EGU_INTEN_TRIGGERED7_Disabled = 0x0
	// Enable
	EGU_INTEN_TRIGGERED7_Enabled = 0x1
	// Position of TRIGGERED8 field.
	EGU_INTEN_TRIGGERED8_Pos = 0x8
	// Bit mask of TRIGGERED8 field.
	EGU_INTEN_TRIGGERED8_Msk = 0x100
	// Bit TRIGGERED8.
	EGU_INTEN_TRIGGERED8 = 0x100
	// Disable
	EGU_INTEN_TRIGGERED8_Disabled = 0x0
	// Enable
	EGU_INTEN_TRIGGERED8_Enabled = 0x1
	// Position of TRIGGERED9 field.
	EGU_INTEN_TRIGGERED9_Pos = 0x9
	// Bit mask of TRIGGERED9 field.
	EGU_INTEN_TRIGGERED9_Msk = 0x200
	// Bit TRIGGERED9.
	EGU_INTEN_TRIGGERED9 = 0x200
	// Disable
	EGU_INTEN_TRIGGERED9_Disabled = 0x0
	// Enable
	EGU_INTEN_TRIGGERED9_Enabled = 0x1
	// Position of TRIGGERED10 field.
	EGU_INTEN_TRIGGERED10_Pos = 0xa
	// Bit mask of TRIGGERED10 field.
	EGU_INTEN_TRIGGERED10_Msk = 0x400
	// Bit TRIGGERED10.
	EGU_INTEN_TRIGGERED10 = 0x400
	// Disable
	EGU_INTEN_TRIGGERED10_Disabled = 0x0
	// Enable
	EGU_INTEN_TRIGGERED10_Enabled = 0x1
	// Position of TRIGGERED11 field.
	EGU_INTEN_TRIGGERED11_Pos = 0xb
	// Bit mask of TRIGGERED11 field.
	EGU_INTEN_TRIGGERED11_Msk = 0x800
	// Bit TRIGGERED11.
	EGU_INTEN_TRIGGERED11 = 0x800
	// Disable
	EGU_INTEN_TRIGGERED11_Disabled = 0x0
	// Enable
	EGU_INTEN_TRIGGERED11_Enabled = 0x1
	// Position of TRIGGERED12 field.
	EGU_INTEN_TRIGGERED12_Pos = 0xc
	// Bit mask of TRIGGERED12 field.
	EGU_INTEN_TRIGGERED12_Msk = 0x1000
	// Bit TRIGGERED12.
	EGU_INTEN_TRIGGERED12 = 0x1000
	// Disable
	EGU_INTEN_TRIGGERED12_Disabled = 0x0
	// Enable
	EGU_INTEN_TRIGGERED12_Enabled = 0x1
	// Position of TRIGGERED13 field.
	EGU_INTEN_TRIGGERED13_Pos = 0xd
	// Bit mask of TRIGGERED13 field.
	EGU_INTEN_TRIGGERED13_Msk = 0x2000
	// Bit TRIGGERED13.
	EGU_INTEN_TRIGGERED13 = 0x2000
	// Disable
	EGU_INTEN_TRIGGERED13_Disabled = 0x0
	// Enable
	EGU_INTEN_TRIGGERED13_Enabled = 0x1
	// Position of TRIGGERED14 field.
	EGU_INTEN_TRIGGERED14_Pos = 0xe
	// Bit mask of TRIGGERED14 field.
	EGU_INTEN_TRIGGERED14_Msk = 0x4000
	// Bit TRIGGERED14.
	EGU_INTEN_TRIGGERED14 = 0x4000
	// Disable
	EGU_INTEN_TRIGGERED14_Disabled = 0x0
	// Enable
	EGU_INTEN_TRIGGERED14_Enabled = 0x1
	// Position of TRIGGERED15 field.
	EGU_INTEN_TRIGGERED15_Pos = 0xf
	// Bit mask of TRIGGERED15 field.
	EGU_INTEN_TRIGGERED15_Msk = 0x8000
	// Bit TRIGGERED15.
	EGU_INTEN_TRIGGERED15 = 0x8000
	// Disable
	EGU_INTEN_TRIGGERED15_Disabled = 0x0
	// Enable
	EGU_INTEN_TRIGGERED15_Enabled = 0x1

	// INTENSET: Enable interrupt
	// Position of TRIGGERED0 field.
	EGU_INTENSET_TRIGGERED0_Pos = 0x0
	// Bit mask of TRIGGERED0 field.
	EGU_INTENSET_TRIGGERED0_Msk = 0x1
	// Bit TRIGGERED0.
	EGU_INTENSET_TRIGGERED0 = 0x1
	// Read: Disabled
	EGU_INTENSET_TRIGGERED0_Disabled = 0x0
	// Read: Enabled
	EGU_INTENSET_TRIGGERED0_Enabled = 0x1
	// Enable
	EGU_INTENSET_TRIGGERED0_Set = 0x1
	// Position of TRIGGERED1 field.
	EGU_INTENSET_TRIGGERED1_Pos = 0x1
	// Bit mask of TRIGGERED1 field.
	EGU_INTENSET_TRIGGERED1_Msk = 0x2
	// Bit TRIGGERED1.
	EGU_INTENSET_TRIGGERED1 = 0x2
	// Read: Disabled
	EGU_INTENSET_TRIGGERED1_Disabled = 0x0
	// Read: Enabled
	EGU_INTENSET_TRIGGERED1_Enabled = 0x1
	// Enable
	EGU_INTENSET_TRIGGERED1_Set = 0x1
	// Position of TRIGGERED2 field.
	EGU_INTENSET_TRIGGERED2_Pos = 0x2
	// Bit mask of TRIGGERED2 field.
	EGU_INTENSET_TRIGGERED2_Msk = 0x4
	// Bit TRIGGERED2.
	EGU_INTENSET_TRIGGERED2 = 0x4
	// Read: Disabled
	EGU_INTENSET_TRIGGERED2_Disabled = 0x0
	// Read: Enabled
	EGU_INTENSET_TRIGGERED2_Enabled = 0x1
	// Enable
	EGU_INTENSET_TRIGGERED2_Set = 0x1
	// Position of TRIGGERED3 field.
	EGU_INTENSET_TRIGGERED3_Pos = 0x3
	// Bit mask of TRIGGERED3 field.
	EGU_INTENSET_TRIGGERED3_Msk = 0x8
	// Bit TRIGGERED3.
	EGU_INTENSET_TRIGGERED3 = 0x8
	// Read: Disabled
	EGU_INTENSET_TRIGGERED3_Disabled = 0x0
	// Read: Enabled
	EGU_INTENSET_TRIGGERED3_Enabled = 0x1
	// Enable
	EGU_INTENSET_TRIGGERED3_Set = 0x1
	// Position of TRIGGERED4 field.
	EGU_INTENSET_TRIGGERED4_Pos = 0x4
	// Bit mask of TRIGGERED4 field.
	EGU_INTENSET_TRIGGERED4_Msk = 0x10
	// Bit TRIGGERED4.
	EGU_INTENSET_TRIGGERED4 = 0x10
	// Read: Disabled
	EGU_INTENSET_TRIGGERED4_Disabled = 0x0
	// Read: Enabled
	EGU_INTENSET_TRIGGERED4_Enabled = 0x1
	// Enable
	EGU_INTENSET_TRIGGERED4_Set = 0x1
	// Position of TRIGGERED5 field.
	EGU_INTENSET_TRIGGERED5_Pos = 0x5
	// Bit mask of TRIGGERED5 field.
	EGU_INTENSET_TRIGGERED5_Msk = 0x20
	// Bit TRIGGERED5.
	EGU_INTENSET_TRIGGERED5 = 0x20
	// Read: Disabled
	EGU_INTENSET_TRIGGERED5_Disabled = 0x0
	// Read: Enabled
	EGU_INTENSET_TRIGGERED5_Enabled = 0x1
	// Enable
	EGU_INTENSET_TRIGGERED5_Set = 0x1
	// Position of TRIGGERED6 field.
	EGU_INTENSET_TRIGGERED6_Pos = 0x6
	// Bit mask of TRIGGERED6 field.
	EGU_INTENSET_TRIGGERED6_Msk = 0x40
	// Bit TRIGGERED6.
	EGU_INTENSET_TRIGGERED6 = 0x40
	// Read: Disabled
	EGU_INTENSET_TRIGGERED6_Disabled = 0x0
	// Read: Enabled
	EGU_INTENSET_TRIGGERED6_Enabled = 0x1
	// Enable
	EGU_INTENSET_TRIGGERED6_Set = 0x1
	// Position of TRIGGERED7 field.
	EGU_INTENSET_TRIGGERED7_Pos = 0x7
	// Bit mask of TRIGGERED7 field.
	EGU_INTENSET_TRIGGERED7_Msk = 0x80
	// Bit TRIGGERED7.
	EGU_INTENSET_TRIGGERED7 = 0x80
	// Read: Disabled
	EGU_INTENSET_TRIGGERED7_Disabled = 0x0
	// Read: Enabled
	EGU_INTENSET_TRIGGERED7_Enabled = 0x1
	// Enable
	EGU_INTENSET_TRIGGERED7_Set = 0x1
	// Position of TRIGGERED8 field.
	EGU_INTENSET_TRIGGERED8_Pos = 0x8
	// Bit mask of TRIGGERED8 field.
	EGU_INTENSET_TRIGGERED8_Msk = 0x100
	// Bit TRIGGERED8.
	EGU_INTENSET_TRIGGERED8 = 0x100
	// Read: Disabled
	EGU_INTENSET_TRIGGERED8_Disabled = 0x0
	// Read: Enabled
	EGU_INTENSET_TRIGGERED8_Enabled = 0x1
	// Enable
	EGU_INTENSET_TRIGGERED8_Set = 0x1
	// Position of TRIGGERED9 field.
	EGU_INTENSET_TRIGGERED9_Pos = 0x9
	// Bit mask of TRIGGERED9 field.
	EGU_INTENSET_TRIGGERED9_Msk = 0x200
	// Bit TRIGGERED9.
	EGU_INTENSET_TRIGGERED9 = 0x200
	// Read: Disabled
	EGU_INTENSET_TRIGGERED9_Disabled = 0x0
	// Read: Enabled
	EGU_INTENSET_TRIGGERED9_Enabled = 0x1
	// Enable
	EGU_INTENSET_TRIGGERED9_Set = 0x1
	// Position of TRIGGERED10 field.
	EGU_INTENSET_TRIGGERED10_Pos = 0xa
	// Bit mask of TRIGGERED10 field.
	EGU_INTENSET_TRIGGERED10_Msk = 0x400
	// Bit TRIGGERED10.
	EGU_INTENSET_TRIGGERED10 = 0x400
	// Read: Disabled
	EGU_INTENSET_TRIGGERED10_Disabled = 0x0
	// Read: Enabled
	EGU_INTENSET_TRIGGERED10_Enabled = 0x1
	// Enable
	EGU_INTENSET_TRIGGERED10_Set = 0x1
	// Position of TRIGGERED11 field.
	EGU_INTENSET_TRIGGERED11_Pos = 0xb
	// Bit mask of TRIGGERED11 field.
	EGU_INTENSET_TRIGGERED11_Msk = 0x800
	// Bit TRIGGERED11.
	EGU_INTENSET_TRIGGERED11 = 0x800
	// Read: Disabled
	EGU_INTENSET_TRIGGERED11_Disabled = 0x0
	// Read: Enabled
	EGU_INTENSET_TRIGGERED11_Enabled = 0x1
	// Enable
	EGU_INTENSET_TRIGGERED11_Set = 0x1
	// Position of TRIGGERED12 field.
	EGU_INTENSET_TRIGGERED12_Pos = 0xc
	// Bit mask of TRIGGERED12 field.
	EGU_INTENSET_TRIGGERED12_Msk = 0x1000
	// Bit TRIGGERED12.
	EGU_INTENSET_TRIGGERED12 = 0x1000
	// Read: Disabled
	EGU_INTENSET_TRIGGERED12_Disabled = 0x0
	// Read: Enabled
	EGU_INTENSET_TRIGGERED12_Enabled = 0x1
	// Enable
	EGU_INTENSET_TRIGGERED12_Set = 0x1
	// Position of TRIGGERED13 field.
	EGU_INTENSET_TRIGGERED13_Pos = 0xd
	// Bit mask of TRIGGERED13 field.
	EGU_INTENSET_TRIGGERED13_Msk = 0x2000
	// Bit TRIGGERED13.
	EGU_INTENSET_TRIGGERED13 = 0x2000
	// Read: Disabled
	EGU_INTENSET_TRIGGERED13_Disabled = 0x0
	// Read: Enabled
	EGU_INTENSET_TRIGGERED13_Enabled = 0x1
	// Enable
	EGU_INTENSET_TRIGGERED13_Set = 0x1
	// Position of TRIGGERED14 field.
	EGU_INTENSET_TRIGGERED14_Pos = 0xe
	// Bit mask of TRIGGERED14 field.
	EGU_INTENSET_TRIGGERED14_Msk = 0x4000
	// Bit TRIGGERED14.
	EGU_INTENSET_TRIGGERED14 = 0x4000
	// Read: Disabled
	EGU_INTENSET_TRIGGERED14_Disabled = 0x0
	// Read: Enabled
	EGU_INTENSET_TRIGGERED14_Enabled = 0x1
	// Enable
	EGU_INTENSET_TRIGGERED14_Set = 0x1
	// Position of TRIGGERED15 field.
	EGU_INTENSET_TRIGGERED15_Pos = 0xf
	// Bit mask of TRIGGERED15 field.
	EGU_INTENSET_TRIGGERED15_Msk = 0x8000
	// Bit TRIGGERED15.
	EGU_INTENSET_TRIGGERED15 = 0x8000
	// Read: Disabled
	EGU_INTENSET_TRIGGERED15_Disabled = 0x0
	// Read: Enabled
	EGU_INTENSET_TRIGGERED15_Enabled = 0x1
	// Enable
	EGU_INTENSET_TRIGGERED15_Set = 0x1

	// INTENCLR: Disable interrupt
	// Position of TRIGGERED0 field.
	EGU_INTENCLR_TRIGGERED0_Pos = 0x0
	// Bit mask of TRIGGERED0 field.
	EGU_INTENCLR_TRIGGERED0_Msk = 0x1
	// Bit TRIGGERED0.
	EGU_INTENCLR_TRIGGERED0 = 0x1
	// Read: Disabled
	EGU_INTENCLR_TRIGGERED0_Disabled = 0x0
	// Read: Enabled
	EGU_INTENCLR_TRIGGERED0_Enabled = 0x1
	// Disable
	EGU_INTENCLR_TRIGGERED0_Clear = 0x1
	// Position of TRIGGERED1 field.
	EGU_INTENCLR_TRIGGERED1_Pos = 0x1
	// Bit mask of TRIGGERED1 field.
	EGU_INTENCLR_TRIGGERED1_Msk = 0x2
	// Bit TRIGGERED1.
	EGU_INTENCLR_TRIGGERED1 = 0x2
	// Read: Disabled
	EGU_INTENCLR_TRIGGERED1_Disabled = 0x0
	// Read: Enabled
	EGU_INTENCLR_TRIGGERED1_Enabled = 0x1
	// Disable
	EGU_INTENCLR_TRIGGERED1_Clear = 0x1
	// Position of TRIGGERED2 field.
	EGU_INTENCLR_TRIGGERED2_Pos = 0x2
	// Bit mask of TRIGGERED2 field.
	EGU_INTENCLR_TRIGGERED2_Msk = 0x4
	// Bit TRIGGERED2.
	EGU_INTENCLR_TRIGGERED2 = 0x4
	// Read: Disabled
	EGU_INTENCLR_TRIGGERED2_Disabled = 0x0
	// Read: Enabled
	EGU_INTENCLR_TRIGGERED2_Enabled = 0x1
	// Disable
	EGU_INTENCLR_TRIGGERED2_Clear = 0x1
	// Position of TRIGGERED3 field.
	EGU_INTENCLR_TRIGGERED3_Pos = 0x3
	// Bit mask of TRIGGERED3 field.
	EGU_INTENCLR_TRIGGERED3_Msk = 0x8
	// Bit TRIGGERED3.
	EGU_INTENCLR_TRIGGERED3 = 0x8
	// Read: Disabled
	EGU_INTENCLR_TRIGGERED3_Disabled = 0x0
	// Read: Enabled
	EGU_INTENCLR_TRIGGERED3_Enabled = 0x1
	// Disable
	EGU_INTENCLR_TRIGGERED3_Clear = 0x1
	// Position of TRIGGERED4 field.
	EGU_INTENCLR_TRIGGERED4_Pos = 0x4
	// Bit mask of TRIGGERED4 field.
	EGU_INTENCLR_TRIGGERED4_Msk = 0x10
	// Bit TRIGGERED4.
	EGU_INTENCLR_TRIGGERED4 = 0x10
	// Read: Disabled
	EGU_INTENCLR_TRIGGERED4_Disabled = 0x0
	// Read: Enabled
	EGU_INTENCLR_TRIGGERED4_Enabled = 0x1
	// Disable
	EGU_INTENCLR_TRIGGERED4_Clear = 0x1
	// Position of TRIGGERED5 field.
	EGU_INTENCLR_TRIGGERED5_Pos = 0x5
	// Bit mask of TRIGGERED5 field.
	EGU_INTENCLR_TRIGGERED5_Msk = 0x20
	// Bit TRIGGERED5.
	EGU_INTENCLR_TRIGGERED5 = 0x20
	// Read: Disabled
	EGU_INTENCLR_TRIGGERED5_Disabled = 0x0
	// Read: Enabled
	EGU_INTENCLR_TRIGGERED5_Enabled = 0x1
	// Disable
	EGU_INTENCLR_TRIGGERED5_Clear = 0x1
	// Position of TRIGGERED6 field.
	EGU_INTENCLR_TRIGGERED6_Pos = 0x6
	// Bit mask of TRIGGERED6 field.
	EGU_INTENCLR_TRIGGERED6_Msk = 0x40
	// Bit TRIGGERED6.
	EGU_INTENCLR_TRIGGERED6 = 0x40
	// Read: Disabled
	EGU_INTENCLR_TRIGGERED6_Disabled = 0x0
	// Read: Enabled
	EGU_INTENCLR_TRIGGERED6_Enabled = 0x1
	// Disable
	EGU_INTENCLR_TRIGGERED6_Clear = 0x1
	// Position of TRIGGERED7 field.
	EGU_INTENCLR_TRIGGERED7_Pos = 0x7
	// Bit mask of TRIGGERED7 field.
	EGU_INTENCLR_TRIGGERED7_Msk = 0x80
	// Bit TRIGGERED7.
	EGU_INTENCLR_TRIGGERED7 = 0x80
	// Read: Disabled
	EGU_INTENCLR_TRIGGERED7_Disabled = 0x0
	// Read: Enabled
	EGU_INTENCLR_TRIGGERED7_Enabled = 0x1
	// Disable
	EGU_INTENCLR_TRIGGERED7_Clear = 0x1
	// Position of TRIGGERED8 field.
	EGU_INTENCLR_TRIGGERED8_Pos = 0x8
	// Bit mask of TRIGGERED8 field.
	EGU_INTENCLR_TRIGGERED8_Msk = 0x100
	// Bit TRIGGERED8.
	EGU_INTENCLR_TRIGGERED8 = 0x100
	// Read: Disabled
	EGU_INTENCLR_TRIGGERED8_Disabled = 0x0
	// Read: Enabled
	EGU_INTENCLR_TRIGGERED8_Enabled = 0x1
	// Disable
	EGU_INTENCLR_TRIGGERED8_Clear = 0x1
	// Position of TRIGGERED9 field.
	EGU_INTENCLR_TRIGGERED9_Pos = 0x9
	// Bit mask of TRIGGERED9 field.
	EGU_INTENCLR_TRIGGERED9_Msk = 0x200
	// Bit TRIGGERED9.
	EGU_INTENCLR_TRIGGERED9 = 0x200
	// Read: Disabled
	EGU_INTENCLR_TRIGGERED9_Disabled = 0x0
	// Read: Enabled
	EGU_INTENCLR_TRIGGERED9_Enabled = 0x1
	// Disable
	EGU_INTENCLR_TRIGGERED9_Clear = 0x1
	// Position of TRIGGERED10 field.
	EGU_INTENCLR_TRIGGERED10_Pos = 0xa
	// Bit mask of TRIGGERED10 field.
	EGU_INTENCLR_TRIGGERED10_Msk = 0x400
	// Bit TRIGGERED10.
	EGU_INTENCLR_TRIGGERED10 = 0x400
	// Read: Disabled
	EGU_INTENCLR_TRIGGERED10_Disabled = 0x0
	// Read: Enabled
	EGU_INTENCLR_TRIGGERED10_Enabled = 0x1
	// Disable
	EGU_INTENCLR_TRIGGERED10_Clear = 0x1
	// Position of TRIGGERED11 field.
	EGU_INTENCLR_TRIGGERED11_Pos = 0xb
	// Bit mask of TRIGGERED11 field.
	EGU_INTENCLR_TRIGGERED11_Msk = 0x800
	// Bit TRIGGERED11.
	EGU_INTENCLR_TRIGGERED11 = 0x800
	// Read: Disabled
	EGU_INTENCLR_TRIGGERED11_Disabled = 0x0
	// Read: Enabled
	EGU_INTENCLR_TRIGGERED11_Enabled = 0x1
	// Disable
	EGU_INTENCLR_TRIGGERED11_Clear = 0x1
	// Position of TRIGGERED12 field.
	EGU_INTENCLR_TRIGGERED12_Pos = 0xc
	// Bit mask of TRIGGERED12 field.
	EGU_INTENCLR_TRIGGERED12_Msk = 0x1000
	// Bit TRIGGERED12.
	EGU_INTENCLR_TRIGGERED12 = 0x1000
	// Read: Disabled
	EGU_INTENCLR_TRIGGERED12_Disabled = 0x0
	// Read: Enabled
	EGU_INTENCLR_TRIGGERED12_Enabled = 0x1
	// Disable
	EGU_INTENCLR_TRIGGERED12_Clear = 0x1
	// Position of TRIGGERED13 field.
	EGU_INTENCLR_TRIGGERED13_Pos = 0xd
	// Bit mask of TRIGGERED13 field.
	EGU_INTENCLR_TRIGGERED13_Msk = 0x2000
	// Bit TRIGGERED13.
	EGU_INTENCLR_TRIGGERED13 = 0x2000
	// Read: Disabled
	EGU_INTENCLR_TRIGGERED13_Disabled = 0x0
	// Read: Enabled
	EGU_INTENCLR_TRIGGERED13_Enabled = 0x1
	// Disable
	EGU_INTENCLR_TRIGGERED13_Clear = 0x1
	// Position of TRIGGERED14 field.
	EGU_INTENCLR_TRIGGERED14_Pos = 0xe
	// Bit mask of TRIGGERED14 field.
	EGU_INTENCLR_TRIGGERED14_Msk = 0x4000
	// Bit TRIGGERED14.
	EGU_INTENCLR_TRIGGERED14 = 0x4000
	// Read: Disabled
	EGU_INTENCLR_TRIGGERED14_Disabled = 0x0
	// Read: Enabled
	EGU_INTENCLR_TRIGGERED14_Enabled = 0x1
	// Disable
	EGU_INTENCLR_TRIGGERED14_Clear = 0x1
	// Position of TRIGGERED15 field.
	EGU_INTENCLR_TRIGGERED15_Pos = 0xf
	// Bit mask of TRIGGERED15 field.
	EGU_INTENCLR_TRIGGERED15_Msk = 0x8000
	// Bit TRIGGERED15.
	EGU_INTENCLR_TRIGGERED15 = 0x8000
	// Read: Disabled
	EGU_INTENCLR_TRIGGERED15_Disabled = 0x0
	// Read: Enabled
	EGU_INTENCLR_TRIGGERED15_Enabled = 0x1
	// Disable
	EGU_INTENCLR_TRIGGERED15_Clear = 0x1
)

// Bitfields for SWI0: Software interrupt 0
const ()

// Bitfields for PWM0: Pulse width modulation unit 0
const (
	// TASKS_STOP: Stops PWM pulse generation on all channels at the end of current PWM period, and stops sequence playback
	// Position of TASKS_STOP field.
	PWM_TASKS_STOP_TASKS_STOP_Pos = 0x0
	// Bit mask of TASKS_STOP field.
	PWM_TASKS_STOP_TASKS_STOP_Msk = 0x1
	// Bit TASKS_STOP.
	PWM_TASKS_STOP_TASKS_STOP = 0x1
	// Trigger task
	PWM_TASKS_STOP_TASKS_STOP_Trigger = 0x1

	// TASKS_SEQSTART: Description collection: Loads the first PWM value on all enabled channels from sequence n, and starts playing that sequence at the rate defined in SEQ[n]REFRESH and/or DECODER.MODE. Causes PWM generation to start if not running.
	// Position of TASKS_SEQSTART field.
	PWM_TASKS_SEQSTART_TASKS_SEQSTART_Pos = 0x0
	// Bit mask of TASKS_SEQSTART field.
	PWM_TASKS_SEQSTART_TASKS_SEQSTART_Msk = 0x1
	// Bit TASKS_SEQSTART.
	PWM_TASKS_SEQSTART_TASKS_SEQSTART = 0x1
	// Trigger task
	PWM_TASKS_SEQSTART_TASKS_SEQSTART_Trigger = 0x1

	// TASKS_NEXTSTEP: Steps by one value in the current sequence on all enabled channels if DECODER.MODE=NextStep. Does not cause PWM generation to start if not running.
	// Position of TASKS_NEXTSTEP field.
	PWM_TASKS_NEXTSTEP_TASKS_NEXTSTEP_Pos = 0x0
	// Bit mask of TASKS_NEXTSTEP field.
	PWM_TASKS_NEXTSTEP_TASKS_NEXTSTEP_Msk = 0x1
	// Bit TASKS_NEXTSTEP.
	PWM_TASKS_NEXTSTEP_TASKS_NEXTSTEP = 0x1
	// Trigger task
	PWM_TASKS_NEXTSTEP_TASKS_NEXTSTEP_Trigger = 0x1

	// EVENTS_STOPPED: Response to STOP task, emitted when PWM pulses are no longer generated
	// Position of EVENTS_STOPPED field.
	PWM_EVENTS_STOPPED_EVENTS_STOPPED_Pos = 0x0
	// Bit mask of EVENTS_STOPPED field.
	PWM_EVENTS_STOPPED_EVENTS_STOPPED_Msk = 0x1
	// Bit EVENTS_STOPPED.
	PWM_EVENTS_STOPPED_EVENTS_STOPPED = 0x1
	// Event not generated
	PWM_EVENTS_STOPPED_EVENTS_STOPPED_NotGenerated = 0x0
	// Event generated
	PWM_EVENTS_STOPPED_EVENTS_STOPPED_Generated = 0x1

	// EVENTS_SEQSTARTED: Description collection: First PWM period started on sequence n
	// Position of EVENTS_SEQSTARTED field.
	PWM_EVENTS_SEQSTARTED_EVENTS_SEQSTARTED_Pos = 0x0
	// Bit mask of EVENTS_SEQSTARTED field.
	PWM_EVENTS_SEQSTARTED_EVENTS_SEQSTARTED_Msk = 0x1
	// Bit EVENTS_SEQSTARTED.
	PWM_EVENTS_SEQSTARTED_EVENTS_SEQSTARTED = 0x1
	// Event not generated
	PWM_EVENTS_SEQSTARTED_EVENTS_SEQSTARTED_NotGenerated = 0x0
	// Event generated
	PWM_EVENTS_SEQSTARTED_EVENTS_SEQSTARTED_Generated = 0x1

	// EVENTS_SEQEND: Description collection: Emitted at end of every sequence n, when last value from RAM has been applied to wave counter
	// Position of EVENTS_SEQEND field.
	PWM_EVENTS_SEQEND_EVENTS_SEQEND_Pos = 0x0
	// Bit mask of EVENTS_SEQEND field.
	PWM_EVENTS_SEQEND_EVENTS_SEQEND_Msk = 0x1
	// Bit EVENTS_SEQEND.
	PWM_EVENTS_SEQEND_EVENTS_SEQEND = 0x1
	// Event not generated
	PWM_EVENTS_SEQEND_EVENTS_SEQEND_NotGenerated = 0x0
	// Event generated
	PWM_EVENTS_SEQEND_EVENTS_SEQEND_Generated = 0x1

	// EVENTS_PWMPERIODEND: Emitted at the end of each PWM period
	// Position of EVENTS_PWMPERIODEND field.
	PWM_EVENTS_PWMPERIODEND_EVENTS_PWMPERIODEND_Pos = 0x0
	// Bit mask of EVENTS_PWMPERIODEND field.
	PWM_EVENTS_PWMPERIODEND_EVENTS_PWMPERIODEND_Msk = 0x1
	// Bit EVENTS_PWMPERIODEND.
	PWM_EVENTS_PWMPERIODEND_EVENTS_PWMPERIODEND = 0x1
	// Event not generated
	PWM_EVENTS_PWMPERIODEND_EVENTS_PWMPERIODEND_NotGenerated = 0x0
	// Event generated
	PWM_EVENTS_PWMPERIODEND_EVENTS_PWMPERIODEND_Generated = 0x1

	// EVENTS_LOOPSDONE: Concatenated sequences have been played the amount of times defined in LOOP.CNT
	// Position of EVENTS_LOOPSDONE field.
	PWM_EVENTS_LOOPSDONE_EVENTS_LOOPSDONE_Pos = 0x0
	// Bit mask of EVENTS_LOOPSDONE field.
	PWM_EVENTS_LOOPSDONE_EVENTS_LOOPSDONE_Msk = 0x1
	// Bit EVENTS_LOOPSDONE.
	PWM_EVENTS_LOOPSDONE_EVENTS_LOOPSDONE = 0x1
	// Event not generated
	PWM_EVENTS_LOOPSDONE_EVENTS_LOOPSDONE_NotGenerated = 0x0
	// Event generated
	PWM_EVENTS_LOOPSDONE_EVENTS_LOOPSDONE_Generated = 0x1

	// SHORTS: Shortcuts between local events and tasks
	// Position of SEQEND0_STOP field.
	PWM_SHORTS_SEQEND0_STOP_Pos = 0x0
	// Bit mask of SEQEND0_STOP field.
	PWM_SHORTS_SEQEND0_STOP_Msk = 0x1
	// Bit SEQEND0_STOP.
	PWM_SHORTS_SEQEND0_STOP = 0x1
	// Disable shortcut
	PWM_SHORTS_SEQEND0_STOP_Disabled = 0x0
	// Enable shortcut
	PWM_SHORTS_SEQEND0_STOP_Enabled = 0x1
	// Position of SEQEND1_STOP field.
	PWM_SHORTS_SEQEND1_STOP_Pos = 0x1
	// Bit mask of SEQEND1_STOP field.
	PWM_SHORTS_SEQEND1_STOP_Msk = 0x2
	// Bit SEQEND1_STOP.
	PWM_SHORTS_SEQEND1_STOP = 0x2
	// Disable shortcut
	PWM_SHORTS_SEQEND1_STOP_Disabled = 0x0
	// Enable shortcut
	PWM_SHORTS_SEQEND1_STOP_Enabled = 0x1
	// Position of LOOPSDONE_SEQSTART0 field.
	PWM_SHORTS_LOOPSDONE_SEQSTART0_Pos = 0x2
	// Bit mask of LOOPSDONE_SEQSTART0 field.
	PWM_SHORTS_LOOPSDONE_SEQSTART0_Msk = 0x4
	// Bit LOOPSDONE_SEQSTART0.
	PWM_SHORTS_LOOPSDONE_SEQSTART0 = 0x4
	// Disable shortcut
	PWM_SHORTS_LOOPSDONE_SEQSTART0_Disabled = 0x0
	// Enable shortcut
	PWM_SHORTS_LOOPSDONE_SEQSTART0_Enabled = 0x1
	// Position of LOOPSDONE_SEQSTART1 field.
	PWM_SHORTS_LOOPSDONE_SEQSTART1_Pos = 0x3
	// Bit mask of LOOPSDONE_SEQSTART1 field.
	PWM_SHORTS_LOOPSDONE_SEQSTART1_Msk = 0x8
	// Bit LOOPSDONE_SEQSTART1.
	PWM_SHORTS_LOOPSDONE_SEQSTART1 = 0x8
	// Disable shortcut
	PWM_SHORTS_LOOPSDONE_SEQSTART1_Disabled = 0x0
	// Enable shortcut
	PWM_SHORTS_LOOPSDONE_SEQSTART1_Enabled = 0x1
	// Position of LOOPSDONE_STOP field.
	PWM_SHORTS_LOOPSDONE_STOP_Pos = 0x4
	// Bit mask of LOOPSDONE_STOP field.
	PWM_SHORTS_LOOPSDONE_STOP_Msk = 0x10
	// Bit LOOPSDONE_STOP.
	PWM_SHORTS_LOOPSDONE_STOP = 0x10
	// Disable shortcut
	PWM_SHORTS_LOOPSDONE_STOP_Disabled = 0x0
	// Enable shortcut
	PWM_SHORTS_LOOPSDONE_STOP_Enabled = 0x1

	// INTEN: Enable or disable interrupt
	// Position of STOPPED field.
	PWM_INTEN_STOPPED_Pos = 0x1
	// Bit mask of STOPPED field.
	PWM_INTEN_STOPPED_Msk = 0x2
	// Bit STOPPED.
	PWM_INTEN_STOPPED = 0x2
	// Disable
	PWM_INTEN_STOPPED_Disabled = 0x0
	// Enable
	PWM_INTEN_STOPPED_Enabled = 0x1
	// Position of SEQSTARTED0 field.
	PWM_INTEN_SEQSTARTED0_Pos = 0x2
	// Bit mask of SEQSTARTED0 field.
	PWM_INTEN_SEQSTARTED0_Msk = 0x4
	// Bit SEQSTARTED0.
	PWM_INTEN_SEQSTARTED0 = 0x4
	// Disable
	PWM_INTEN_SEQSTARTED0_Disabled = 0x0
	// Enable
	PWM_INTEN_SEQSTARTED0_Enabled = 0x1
	// Position of SEQSTARTED1 field.
	PWM_INTEN_SEQSTARTED1_Pos = 0x3
	// Bit mask of SEQSTARTED1 field.
	PWM_INTEN_SEQSTARTED1_Msk = 0x8
	// Bit SEQSTARTED1.
	PWM_INTEN_SEQSTARTED1 = 0x8
	// Disable
	PWM_INTEN_SEQSTARTED1_Disabled = 0x0
	// Enable
	PWM_INTEN_SEQSTARTED1_Enabled = 0x1
	// Position of SEQEND0 field.
	PWM_INTEN_SEQEND0_Pos = 0x4
	// Bit mask of SEQEND0 field.
	PWM_INTEN_SEQEND0_Msk = 0x10
	// Bit SEQEND0.
	PWM_INTEN_SEQEND0 = 0x10
	// Disable
	PWM_INTEN_SEQEND0_Disabled = 0x0
	// Enable
	PWM_INTEN_SEQEND0_Enabled = 0x1
	// Position of SEQEND1 field.
	PWM_INTEN_SEQEND1_Pos = 0x5
	// Bit mask of SEQEND1 field.
	PWM_INTEN_SEQEND1_Msk = 0x20
	// Bit SEQEND1.
	PWM_INTEN_SEQEND1 = 0x20
	// Disable
	PWM_INTEN_SEQEND1_Disabled = 0x0
	// Enable
	PWM_INTEN_SEQEND1_Enabled = 0x1
	// Position of PWMPERIODEND field.
	PWM_INTEN_PWMPERIODEND_Pos = 0x6
	// Bit mask of PWMPERIODEND field.
	PWM_INTEN_PWMPERIODEND_Msk = 0x40
	// Bit PWMPERIODEND.
	PWM_INTEN_PWMPERIODEND = 0x40
	// Disable
	PWM_INTEN_PWMPERIODEND_Disabled = 0x0
	// Enable
	PWM_INTEN_PWMPERIODEND_Enabled = 0x1
	// Position of LOOPSDONE field.
	PWM_INTEN_LOOPSDONE_Pos = 0x7
	// Bit mask of LOOPSDONE field.
	PWM_INTEN_LOOPSDONE_Msk = 0x80
	// Bit LOOPSDONE.
	PWM_INTEN_LOOPSDONE = 0x80
	// Disable
	PWM_INTEN_LOOPSDONE_Disabled = 0x0
	// Enable
	PWM_INTEN_LOOPSDONE_Enabled = 0x1

	// INTENSET: Enable interrupt
	// Position of STOPPED field.
	PWM_INTENSET_STOPPED_Pos = 0x1
	// Bit mask of STOPPED field.
	PWM_INTENSET_STOPPED_Msk = 0x2
	// Bit STOPPED.
	PWM_INTENSET_STOPPED = 0x2
	// Read: Disabled
	PWM_INTENSET_STOPPED_Disabled = 0x0
	// Read: Enabled
	PWM_INTENSET_STOPPED_Enabled = 0x1
	// Enable
	PWM_INTENSET_STOPPED_Set = 0x1
	// Position of SEQSTARTED0 field.
	PWM_INTENSET_SEQSTARTED0_Pos = 0x2
	// Bit mask of SEQSTARTED0 field.
	PWM_INTENSET_SEQSTARTED0_Msk = 0x4
	// Bit SEQSTARTED0.
	PWM_INTENSET_SEQSTARTED0 = 0x4
	// Read: Disabled
	PWM_INTENSET_SEQSTARTED0_Disabled = 0x0
	// Read: Enabled
	PWM_INTENSET_SEQSTARTED0_Enabled = 0x1
	// Enable
	PWM_INTENSET_SEQSTARTED0_Set = 0x1
	// Position of SEQSTARTED1 field.
	PWM_INTENSET_SEQSTARTED1_Pos = 0x3
	// Bit mask of SEQSTARTED1 field.
	PWM_INTENSET_SEQSTARTED1_Msk = 0x8
	// Bit SEQSTARTED1.
	PWM_INTENSET_SEQSTARTED1 = 0x8
	// Read: Disabled
	PWM_INTENSET_SEQSTARTED1_Disabled = 0x0
	// Read: Enabled
	PWM_INTENSET_SEQSTARTED1_Enabled = 0x1
	// Enable
	PWM_INTENSET_SEQSTARTED1_Set = 0x1
	// Position of SEQEND0 field.
	PWM_INTENSET_SEQEND0_Pos = 0x4
	// Bit mask of SEQEND0 field.
	PWM_INTENSET_SEQEND0_Msk = 0x10
	// Bit SEQEND0.
	PWM_INTENSET_SEQEND0 = 0x10
	// Read: Disabled
	PWM_INTENSET_SEQEND0_Disabled = 0x0
	// Read: Enabled
	PWM_INTENSET_SEQEND0_Enabled = 0x1
	// Enable
	PWM_INTENSET_SEQEND0_Set = 0x1
	// Position of SEQEND1 field.
	PWM_INTENSET_SEQEND1_Pos = 0x5
	// Bit mask of SEQEND1 field.
	PWM_INTENSET_SEQEND1_Msk = 0x20
	// Bit SEQEND1.
	PWM_INTENSET_SEQEND1 = 0x20
	// Read: Disabled
	PWM_INTENSET_SEQEND1_Disabled = 0x0
	// Read: Enabled
	PWM_INTENSET_SEQEND1_Enabled = 0x1
	// Enable
	PWM_INTENSET_SEQEND1_Set = 0x1
	// Position of PWMPERIODEND field.
	PWM_INTENSET_PWMPERIODEND_Pos = 0x6
	// Bit mask of PWMPERIODEND field.
	PWM_INTENSET_PWMPERIODEND_Msk = 0x40
	// Bit PWMPERIODEND.
	PWM_INTENSET_PWMPERIODEND = 0x40
	// Read: Disabled
	PWM_INTENSET_PWMPERIODEND_Disabled = 0x0
	// Read: Enabled
	PWM_INTENSET_PWMPERIODEND_Enabled = 0x1
	// Enable
	PWM_INTENSET_PWMPERIODEND_Set = 0x1
	// Position of LOOPSDONE field.
	PWM_INTENSET_LOOPSDONE_Pos = 0x7
	// Bit mask of LOOPSDONE field.
	PWM_INTENSET_LOOPSDONE_Msk = 0x80
	// Bit LOOPSDONE.
	PWM_INTENSET_LOOPSDONE = 0x80
	// Read: Disabled
	PWM_INTENSET_LOOPSDONE_Disabled = 0x0
	// Read: Enabled
	PWM_INTENSET_LOOPSDONE_Enabled = 0x1
	// Enable
	PWM_INTENSET_LOOPSDONE_Set = 0x1

	// INTENCLR: Disable interrupt
	// Position of STOPPED field.
	PWM_INTENCLR_STOPPED_Pos = 0x1
	// Bit mask of STOPPED field.
	PWM_INTENCLR_STOPPED_Msk = 0x2
	// Bit STOPPED.
	PWM_INTENCLR_STOPPED = 0x2
	// Read: Disabled
	PWM_INTENCLR_STOPPED_Disabled = 0x0
	// Read: Enabled
	PWM_INTENCLR_STOPPED_Enabled = 0x1
	// Disable
	PWM_INTENCLR_STOPPED_Clear = 0x1
	// Position of SEQSTARTED0 field.
	PWM_INTENCLR_SEQSTARTED0_Pos = 0x2
	// Bit mask of SEQSTARTED0 field.
	PWM_INTENCLR_SEQSTARTED0_Msk = 0x4
	// Bit SEQSTARTED0.
	PWM_INTENCLR_SEQSTARTED0 = 0x4
	// Read: Disabled
	PWM_INTENCLR_SEQSTARTED0_Disabled = 0x0
	// Read: Enabled
	PWM_INTENCLR_SEQSTARTED0_Enabled = 0x1
	// Disable
	PWM_INTENCLR_SEQSTARTED0_Clear = 0x1
	// Position of SEQSTARTED1 field.
	PWM_INTENCLR_SEQSTARTED1_Pos = 0x3
	// Bit mask of SEQSTARTED1 field.
	PWM_INTENCLR_SEQSTARTED1_Msk = 0x8
	// Bit SEQSTARTED1.
	PWM_INTENCLR_SEQSTARTED1 = 0x8
	// Read: Disabled
	PWM_INTENCLR_SEQSTARTED1_Disabled = 0x0
	// Read: Enabled
	PWM_INTENCLR_SEQSTARTED1_Enabled = 0x1
	// Disable
	PWM_INTENCLR_SEQSTARTED1_Clear = 0x1
	// Position of SEQEND0 field.
	PWM_INTENCLR_SEQEND0_Pos = 0x4
	// Bit mask of SEQEND0 field.
	PWM_INTENCLR_SEQEND0_Msk = 0x10
	// Bit SEQEND0.
	PWM_INTENCLR_SEQEND0 = 0x10
	// Read: Disabled
	PWM_INTENCLR_SEQEND0_Disabled = 0x0
	// Read: Enabled
	PWM_INTENCLR_SEQEND0_Enabled = 0x1
	// Disable
	PWM_INTENCLR_SEQEND0_Clear = 0x1
	// Position of SEQEND1 field.
	PWM_INTENCLR_SEQEND1_Pos = 0x5
	// Bit mask of SEQEND1 field.
	PWM_INTENCLR_SEQEND1_Msk = 0x20
	// Bit SEQEND1.
	PWM_INTENCLR_SEQEND1 = 0x20
	// Read: Disabled
	PWM_INTENCLR_SEQEND1_Disabled = 0x0
	// Read: Enabled
	PWM_INTENCLR_SEQEND1_Enabled = 0x1
	// Disable
	PWM_INTENCLR_SEQEND1_Clear = 0x1
	// Position of PWMPERIODEND field.
	PWM_INTENCLR_PWMPERIODEND_Pos = 0x6
	// Bit mask of PWMPERIODEND field.
	PWM_INTENCLR_PWMPERIODEND_Msk = 0x40
	// Bit PWMPERIODEND.
	PWM_INTENCLR_PWMPERIODEND = 0x40
	// Read: Disabled
	PWM_INTENCLR_PWMPERIODEND_Disabled = 0x0
	// Read: Enabled
	PWM_INTENCLR_PWMPERIODEND_Enabled = 0x1
	// Disable
	PWM_INTENCLR_PWMPERIODEND_Clear = 0x1
	// Position of LOOPSDONE field.
	PWM_INTENCLR_LOOPSDONE_Pos = 0x7
	// Bit mask of LOOPSDONE field.
	PWM_INTENCLR_LOOPSDONE_Msk = 0x80
	// Bit LOOPSDONE.
	PWM_INTENCLR_LOOPSDONE = 0x80
	// Read: Disabled
	PWM_INTENCLR_LOOPSDONE_Disabled = 0x0
	// Read: Enabled
	PWM_INTENCLR_LOOPSDONE_Enabled = 0x1
	// Disable
	PWM_INTENCLR_LOOPSDONE_Clear = 0x1

	// ENABLE: PWM module enable register
	// Position of ENABLE field.
	PWM_ENABLE_ENABLE_Pos = 0x0
	// Bit mask of ENABLE field.
	PWM_ENABLE_ENABLE_Msk = 0x1
	// Bit ENABLE.
	PWM_ENABLE_ENABLE = 0x1
	// Disabled
	PWM_ENABLE_ENABLE_Disabled = 0x0
	// Enable
	PWM_ENABLE_ENABLE_Enabled = 0x1

	// MODE: Selects operating mode of the wave counter
	// Position of UPDOWN field.
	PWM_MODE_UPDOWN_Pos = 0x0
	// Bit mask of UPDOWN field.
	PWM_MODE_UPDOWN_Msk = 0x1
	// Bit UPDOWN.
	PWM_MODE_UPDOWN = 0x1
	// Up counter, edge-aligned PWM duty cycle
	PWM_MODE_UPDOWN_Up = 0x0
	// Up and down counter, center-aligned PWM duty cycle
	PWM_MODE_UPDOWN_UpAndDown = 0x1

	// COUNTERTOP: Value up to which the pulse generator counter counts
	// Position of COUNTERTOP field.
	PWM_COUNTERTOP_COUNTERTOP_Pos = 0x0
	// Bit mask of COUNTERTOP field.
	PWM_COUNTERTOP_COUNTERTOP_Msk = 0x7fff

	// PRESCALER: Configuration for PWM_CLK
	// Position of PRESCALER field.
	PWM_PRESCALER_PRESCALER_Pos = 0x0
	// Bit mask of PRESCALER field.
	PWM_PRESCALER_PRESCALER_Msk = 0x7
	// Divide by 1 (16 MHz)
	PWM_PRESCALER_PRESCALER_DIV_1 = 0x0
	// Divide by 2 (8 MHz)
	PWM_PRESCALER_PRESCALER_DIV_2 = 0x1
	// Divide by 4 (4 MHz)
	PWM_PRESCALER_PRESCALER_DIV_4 = 0x2
	// Divide by 8 (2 MHz)
	PWM_PRESCALER_PRESCALER_DIV_8 = 0x3
	// Divide by 16 (1 MHz)
	PWM_PRESCALER_PRESCALER_DIV_16 = 0x4
	// Divide by 32 (500 kHz)
	PWM_PRESCALER_PRESCALER_DIV_32 = 0x5
	// Divide by 64 (250 kHz)
	PWM_PRESCALER_PRESCALER_DIV_64 = 0x6
	// Divide by 128 (125 kHz)
	PWM_PRESCALER_PRESCALER_DIV_128 = 0x7

	// DECODER: Configuration of the decoder
	// Position of LOAD field.
	PWM_DECODER_LOAD_Pos = 0x0
	// Bit mask of LOAD field.
	PWM_DECODER_LOAD_Msk = 0x3
	// 1st half word (16-bit) used in all PWM channels 0..3
	PWM_DECODER_LOAD_Common = 0x0
	// 1st half word (16-bit) used in channel 0..1; 2nd word in channel 2..3
	PWM_DECODER_LOAD_Grouped = 0x1
	// 1st half word (16-bit) in ch.0; 2nd in ch.1; ...; 4th in ch.3
	PWM_DECODER_LOAD_Individual = 0x2
	// 1st half word (16-bit) in ch.0; 2nd in ch.1; ...; 4th in COUNTERTOP
	PWM_DECODER_LOAD_WaveForm = 0x3
	// Position of MODE field.
	PWM_DECODER_MODE_Pos = 0x8
	// Bit mask of MODE field.
	PWM_DECODER_MODE_Msk = 0x100
	// Bit MODE.
	PWM_DECODER_MODE = 0x100
	// SEQ[n].REFRESH is used to determine loading internal compare registers
	PWM_DECODER_MODE_RefreshCount = 0x0
	// NEXTSTEP task causes a new value to be loaded to internal compare registers
	PWM_DECODER_MODE_NextStep = 0x1

	// LOOP: Number of playbacks of a loop
	// Position of CNT field.
	PWM_LOOP_CNT_Pos = 0x0
	// Bit mask of CNT field.
	PWM_LOOP_CNT_Msk = 0xffff
	// Looping disabled (stop at the end of the sequence)
	PWM_LOOP_CNT_Disabled = 0x0

	// SEQ.PTR: Description cluster: Beginning address in RAM of this sequence
	// Position of PTR field.
	PWM_SEQ_PTR_PTR_Pos = 0x0
	// Bit mask of PTR field.
	PWM_SEQ_PTR_PTR_Msk = 0xffffffff

	// SEQ.CNT: Description cluster: Number of values (duty cycles) in this sequence
	// Position of CNT field.
	PWM_SEQ_CNT_CNT_Pos = 0x0
	// Bit mask of CNT field.
	PWM_SEQ_CNT_CNT_Msk = 0x7fff
	// Sequence is disabled, and shall not be started as it is empty
	PWM_SEQ_CNT_CNT_Disabled = 0x0

	// SEQ.REFRESH: Description cluster: Number of additional PWM periods between samples loaded into compare register
	// Position of CNT field.
	PWM_SEQ_REFRESH_CNT_Pos = 0x0
	// Bit mask of CNT field.
	PWM_SEQ_REFRESH_CNT_Msk = 0xffffff
	// Update every PWM period
	PWM_SEQ_REFRESH_CNT_Continuous = 0x0

	// SEQ.ENDDELAY: Description cluster: Time added after the sequence
	// Position of CNT field.
	PWM_SEQ_ENDDELAY_CNT_Pos = 0x0
	// Bit mask of CNT field.
	PWM_SEQ_ENDDELAY_CNT_Msk = 0xffffff

	// PSEL.OUT: Description collection: Output pin select for PWM channel n
	// Position of PIN field.
	PWM_PSEL_OUT_PIN_Pos = 0x0
	// Bit mask of PIN field.
	PWM_PSEL_OUT_PIN_Msk = 0x1f
	// Position of PORT field.
	PWM_PSEL_OUT_PORT_Pos = 0x5
	// Bit mask of PORT field.
	PWM_PSEL_OUT_PORT_Msk = 0x20
	// Bit PORT.
	PWM_PSEL_OUT_PORT = 0x20
	// Position of CONNECT field.
	PWM_PSEL_OUT_CONNECT_Pos = 0x1f
	// Bit mask of CONNECT field.
	PWM_PSEL_OUT_CONNECT_Msk = 0x80000000
	// Bit CONNECT.
	PWM_PSEL_OUT_CONNECT = 0x80000000
	// Disconnect
	PWM_PSEL_OUT_CONNECT_Disconnected = 0x1
	// Connect
	PWM_PSEL_OUT_CONNECT_Connected = 0x0
)

// Bitfields for PDM: Pulse Density Modulation (Digital Microphone) Interface
const (
	// TASKS_START: Starts continuous PDM transfer
	// Position of TASKS_START field.
	PDM_TASKS_START_TASKS_START_Pos = 0x0
	// Bit mask of TASKS_START field.
	PDM_TASKS_START_TASKS_START_Msk = 0x1
	// Bit TASKS_START.
	PDM_TASKS_START_TASKS_START = 0x1
	// Trigger task
	PDM_TASKS_START_TASKS_START_Trigger = 0x1

	// TASKS_STOP: Stops PDM transfer
	// Position of TASKS_STOP field.
	PDM_TASKS_STOP_TASKS_STOP_Pos = 0x0
	// Bit mask of TASKS_STOP field.
	PDM_TASKS_STOP_TASKS_STOP_Msk = 0x1
	// Bit TASKS_STOP.
	PDM_TASKS_STOP_TASKS_STOP = 0x1
	// Trigger task
	PDM_TASKS_STOP_TASKS_STOP_Trigger = 0x1

	// EVENTS_STARTED: PDM transfer has started
	// Position of EVENTS_STARTED field.
	PDM_EVENTS_STARTED_EVENTS_STARTED_Pos = 0x0
	// Bit mask of EVENTS_STARTED field.
	PDM_EVENTS_STARTED_EVENTS_STARTED_Msk = 0x1
	// Bit EVENTS_STARTED.
	PDM_EVENTS_STARTED_EVENTS_STARTED = 0x1
	// Event not generated
	PDM_EVENTS_STARTED_EVENTS_STARTED_NotGenerated = 0x0
	// Event generated
	PDM_EVENTS_STARTED_EVENTS_STARTED_Generated = 0x1

	// EVENTS_STOPPED: PDM transfer has finished
	// Position of EVENTS_STOPPED field.
	PDM_EVENTS_STOPPED_EVENTS_STOPPED_Pos = 0x0
	// Bit mask of EVENTS_STOPPED field.
	PDM_EVENTS_STOPPED_EVENTS_STOPPED_Msk = 0x1
	// Bit EVENTS_STOPPED.
	PDM_EVENTS_STOPPED_EVENTS_STOPPED = 0x1
	// Event not generated
	PDM_EVENTS_STOPPED_EVENTS_STOPPED_NotGenerated = 0x0
	// Event generated
	PDM_EVENTS_STOPPED_EVENTS_STOPPED_Generated = 0x1

	// EVENTS_END: The PDM has written the last sample specified by SAMPLE.MAXCNT (or the last sample after a STOP task has been received) to Data RAM
	// Position of EVENTS_END field.
	PDM_EVENTS_END_EVENTS_END_Pos = 0x0
	// Bit mask of EVENTS_END field.
	PDM_EVENTS_END_EVENTS_END_Msk = 0x1
	// Bit EVENTS_END.
	PDM_EVENTS_END_EVENTS_END = 0x1
	// Event not generated
	PDM_EVENTS_END_EVENTS_END_NotGenerated = 0x0
	// Event generated
	PDM_EVENTS_END_EVENTS_END_Generated = 0x1

	// INTEN: Enable or disable interrupt
	// Position of STARTED field.
	PDM_INTEN_STARTED_Pos = 0x0
	// Bit mask of STARTED field.
	PDM_INTEN_STARTED_Msk = 0x1
	// Bit STARTED.
	PDM_INTEN_STARTED = 0x1
	// Disable
	PDM_INTEN_STARTED_Disabled = 0x0
	// Enable
	PDM_INTEN_STARTED_Enabled = 0x1
	// Position of STOPPED field.
	PDM_INTEN_STOPPED_Pos = 0x1
	// Bit mask of STOPPED field.
	PDM_INTEN_STOPPED_Msk = 0x2
	// Bit STOPPED.
	PDM_INTEN_STOPPED = 0x2
	// Disable
	PDM_INTEN_STOPPED_Disabled = 0x0
	// Enable
	PDM_INTEN_STOPPED_Enabled = 0x1
	// Position of END field.
	PDM_INTEN_END_Pos = 0x2
	// Bit mask of END field.
	PDM_INTEN_END_Msk = 0x4
	// Bit END.
	PDM_INTEN_END = 0x4
	// Disable
	PDM_INTEN_END_Disabled = 0x0
	// Enable
	PDM_INTEN_END_Enabled = 0x1

	// INTENSET: Enable interrupt
	// Position of STARTED field.
	PDM_INTENSET_STARTED_Pos = 0x0
	// Bit mask of STARTED field.
	PDM_INTENSET_STARTED_Msk = 0x1
	// Bit STARTED.
	PDM_INTENSET_STARTED = 0x1
	// Read: Disabled
	PDM_INTENSET_STARTED_Disabled = 0x0
	// Read: Enabled
	PDM_INTENSET_STARTED_Enabled = 0x1
	// Enable
	PDM_INTENSET_STARTED_Set = 0x1
	// Position of STOPPED field.
	PDM_INTENSET_STOPPED_Pos = 0x1
	// Bit mask of STOPPED field.
	PDM_INTENSET_STOPPED_Msk = 0x2
	// Bit STOPPED.
	PDM_INTENSET_STOPPED = 0x2
	// Read: Disabled
	PDM_INTENSET_STOPPED_Disabled = 0x0
	// Read: Enabled
	PDM_INTENSET_STOPPED_Enabled = 0x1
	// Enable
	PDM_INTENSET_STOPPED_Set = 0x1
	// Position of END field.
	PDM_INTENSET_END_Pos = 0x2
	// Bit mask of END field.
	PDM_INTENSET_END_Msk = 0x4
	// Bit END.
	PDM_INTENSET_END = 0x4
	// Read: Disabled
	PDM_INTENSET_END_Disabled = 0x0
	// Read: Enabled
	PDM_INTENSET_END_Enabled = 0x1
	// Enable
	PDM_INTENSET_END_Set = 0x1

	// INTENCLR: Disable interrupt
	// Position of STARTED field.
	PDM_INTENCLR_STARTED_Pos = 0x0
	// Bit mask of STARTED field.
	PDM_INTENCLR_STARTED_Msk = 0x1
	// Bit STARTED.
	PDM_INTENCLR_STARTED = 0x1
	// Read: Disabled
	PDM_INTENCLR_STARTED_Disabled = 0x0
	// Read: Enabled
	PDM_INTENCLR_STARTED_Enabled = 0x1
	// Disable
	PDM_INTENCLR_STARTED_Clear = 0x1
	// Position of STOPPED field.
	PDM_INTENCLR_STOPPED_Pos = 0x1
	// Bit mask of STOPPED field.
	PDM_INTENCLR_STOPPED_Msk = 0x2
	// Bit STOPPED.
	PDM_INTENCLR_STOPPED = 0x2
	// Read: Disabled
	PDM_INTENCLR_STOPPED_Disabled = 0x0
	// Read: Enabled
	PDM_INTENCLR_STOPPED_Enabled = 0x1
	// Disable
	PDM_INTENCLR_STOPPED_Clear = 0x1
	// Position of END field.
	PDM_INTENCLR_END_Pos = 0x2
	// Bit mask of END field.
	PDM_INTENCLR_END_Msk = 0x4
	// Bit END.
	PDM_INTENCLR_END = 0x4
	// Read: Disabled
	PDM_INTENCLR_END_Disabled = 0x0
	// Read: Enabled
	PDM_INTENCLR_END_Enabled = 0x1
	// Disable
	PDM_INTENCLR_END_Clear = 0x1

	// ENABLE: PDM module enable register
	// Position of ENABLE field.
	PDM_ENABLE_ENABLE_Pos = 0x0
	// Bit mask of ENABLE field.
	PDM_ENABLE_ENABLE_Msk = 0x1
	// Bit ENABLE.
	PDM_ENABLE_ENABLE = 0x1
	// Disable
	PDM_ENABLE_ENABLE_Disabled = 0x0
	// Enable
	PDM_ENABLE_ENABLE_Enabled = 0x1

	// PDMCLKCTRL: PDM clock generator control
	// Position of FREQ field.
	PDM_PDMCLKCTRL_FREQ_Pos = 0x0
	// Bit mask of FREQ field.
	PDM_PDMCLKCTRL_FREQ_Msk = 0xffffffff
	// PDM_CLK = 32 MHz / 32 = 1.000 MHz
	PDM_PDMCLKCTRL_FREQ_1000K = 0x8000000
	// PDM_CLK = 32 MHz / 31 = 1.032 MHz. Nominal clock for RATIO=Ratio64.
	PDM_PDMCLKCTRL_FREQ_Default = 0x8400000
	// PDM_CLK = 32 MHz / 30 = 1.067 MHz
	PDM_PDMCLKCTRL_FREQ_1067K = 0x8800000
	// PDM_CLK = 32 MHz / 26 = 1.231 MHz
	PDM_PDMCLKCTRL_FREQ_1231K = 0x9800000
	// PDM_CLK = 32 MHz / 25 = 1.280 MHz. Nominal clock for RATIO=Ratio80.
	PDM_PDMCLKCTRL_FREQ_1280K = 0xa000000
	// PDM_CLK = 32 MHz / 24 = 1.333 MHz
	PDM_PDMCLKCTRL_FREQ_1333K = 0xa800000

	// MODE: Defines the routing of the connected PDM microphones' signals
	// Position of OPERATION field.
	PDM_MODE_OPERATION_Pos = 0x0
	// Bit mask of OPERATION field.
	PDM_MODE_OPERATION_Msk = 0x1
	// Bit OPERATION.
	PDM_MODE_OPERATION = 0x1
	// Sample and store one pair (Left + Right) of 16bit samples per RAM word R=[31:16]; L=[15:0]
	PDM_MODE_OPERATION_Stereo = 0x0
	// Sample and store two successive Left samples (16 bit each) per RAM word L1=[31:16]; L0=[15:0]
	PDM_MODE_OPERATION_Mono = 0x1
	// Position of EDGE field.
	PDM_MODE_EDGE_Pos = 0x1
	// Bit mask of EDGE field.
	PDM_MODE_EDGE_Msk = 0x2
	// Bit EDGE.
	PDM_MODE_EDGE = 0x2
	// Left (or mono) is sampled on falling edge of PDM_CLK
	PDM_MODE_EDGE_LeftFalling = 0x0
	// Left (or mono) is sampled on rising edge of PDM_CLK
	PDM_MODE_EDGE_LeftRising = 0x1

	// GAINL: Left output gain adjustment
	// Position of GAINL field.
	PDM_GAINL_GAINL_Pos = 0x0
	// Bit mask of GAINL field.
	PDM_GAINL_GAINL_Msk = 0x7f
	// -20dB gain adjustment (minimum)
	PDM_GAINL_GAINL_MinGain = 0x0
	// 0dB gain adjustment
	PDM_GAINL_GAINL_DefaultGain = 0x28
	// +20dB gain adjustment (maximum)
	PDM_GAINL_GAINL_MaxGain = 0x50

	// GAINR: Right output gain adjustment
	// Position of GAINR field.
	PDM_GAINR_GAINR_Pos = 0x0
	// Bit mask of GAINR field.
	PDM_GAINR_GAINR_Msk = 0x7f
	// -20dB gain adjustment (minimum)
	PDM_GAINR_GAINR_MinGain = 0x0
	// 0dB gain adjustment
	PDM_GAINR_GAINR_DefaultGain = 0x28
	// +20dB gain adjustment (maximum)
	PDM_GAINR_GAINR_MaxGain = 0x50

	// RATIO: Selects the ratio between PDM_CLK and output sample rate. Change PDMCLKCTRL accordingly.
	// Position of RATIO field.
	PDM_RATIO_RATIO_Pos = 0x0
	// Bit mask of RATIO field.
	PDM_RATIO_RATIO_Msk = 0x1
	// Bit RATIO.
	PDM_RATIO_RATIO = 0x1
	// Ratio of 64
	PDM_RATIO_RATIO_Ratio64 = 0x0
	// Ratio of 80
	PDM_RATIO_RATIO_Ratio80 = 0x1

	// PSEL.CLK: Pin number configuration for PDM CLK signal
	// Position of PIN field.
	PDM_PSEL_CLK_PIN_Pos = 0x0
	// Bit mask of PIN field.
	PDM_PSEL_CLK_PIN_Msk = 0x1f
	// Position of PORT field.
	PDM_PSEL_CLK_PORT_Pos = 0x5
	// Bit mask of PORT field.
	PDM_PSEL_CLK_PORT_Msk = 0x20
	// Bit PORT.
	PDM_PSEL_CLK_PORT = 0x20
	// Position of CONNECT field.
	PDM_PSEL_CLK_CONNECT_Pos = 0x1f
	// Bit mask of CONNECT field.
	PDM_PSEL_CLK_CONNECT_Msk = 0x80000000
	// Bit CONNECT.
	PDM_PSEL_CLK_CONNECT = 0x80000000
	// Disconnect
	PDM_PSEL_CLK_CONNECT_Disconnected = 0x1
	// Connect
	PDM_PSEL_CLK_CONNECT_Connected = 0x0

	// PSEL.DIN: Pin number configuration for PDM DIN signal
	// Position of PIN field.
	PDM_PSEL_DIN_PIN_Pos = 0x0
	// Bit mask of PIN field.
	PDM_PSEL_DIN_PIN_Msk = 0x1f
	// Position of PORT field.
	PDM_PSEL_DIN_PORT_Pos = 0x5
	// Bit mask of PORT field.
	PDM_PSEL_DIN_PORT_Msk = 0x20
	// Bit PORT.
	PDM_PSEL_DIN_PORT = 0x20
	// Position of CONNECT field.
	PDM_PSEL_DIN_CONNECT_Pos = 0x1f
	// Bit mask of CONNECT field.
	PDM_PSEL_DIN_CONNECT_Msk = 0x80000000
	// Bit CONNECT.
	PDM_PSEL_DIN_CONNECT = 0x80000000
	// Disconnect
	PDM_PSEL_DIN_CONNECT_Disconnected = 0x1
	// Connect
	PDM_PSEL_DIN_CONNECT_Connected = 0x0

	// SAMPLE.PTR: RAM address pointer to write samples to with EasyDMA
	// Position of SAMPLEPTR field.
	PDM_SAMPLE_PTR_SAMPLEPTR_Pos = 0x0
	// Bit mask of SAMPLEPTR field.
	PDM_SAMPLE_PTR_SAMPLEPTR_Msk = 0xffffffff

	// SAMPLE.MAXCNT: Number of samples to allocate memory for in EasyDMA mode
	// Position of BUFFSIZE field.
	PDM_SAMPLE_MAXCNT_BUFFSIZE_Pos = 0x0
	// Bit mask of BUFFSIZE field.
	PDM_SAMPLE_MAXCNT_BUFFSIZE_Msk = 0x7fff
)

// Bitfields for ACL: Access control lists
const (
	// ACL.ADDR: Description cluster: Configure the word-aligned start address of region n to protect
	// Position of ADDR field.
	ACL_ACL_ADDR_ADDR_Pos = 0x0
	// Bit mask of ADDR field.
	ACL_ACL_ADDR_ADDR_Msk = 0xffffffff

	// ACL.SIZE: Description cluster: Size of region to protect counting from address ACL[n].ADDR. Write '0' as no effect.
	// Position of SIZE field.
	ACL_ACL_SIZE_SIZE_Pos = 0x0
	// Bit mask of SIZE field.
	ACL_ACL_SIZE_SIZE_Msk = 0xffffffff

	// ACL.PERM: Description cluster: Access permissions for region n as defined by start address ACL[n].ADDR and size ACL[n].SIZE
	// Position of WRITE field.
	ACL_ACL_PERM_WRITE_Pos = 0x1
	// Bit mask of WRITE field.
	ACL_ACL_PERM_WRITE_Msk = 0x2
	// Bit WRITE.
	ACL_ACL_PERM_WRITE = 0x2
	// Allow write and erase instructions to region n
	ACL_ACL_PERM_WRITE_Enable = 0x0
	// Block write and erase instructions to region n
	ACL_ACL_PERM_WRITE_Disable = 0x1
	// Position of READ field.
	ACL_ACL_PERM_READ_Pos = 0x2
	// Bit mask of READ field.
	ACL_ACL_PERM_READ_Msk = 0x4
	// Bit READ.
	ACL_ACL_PERM_READ = 0x4
	// Allow read instructions to region n
	ACL_ACL_PERM_READ_Enable = 0x0
	// Block read instructions to region n
	ACL_ACL_PERM_READ_Disable = 0x1
)

// Bitfields for NVMC: Non Volatile Memory Controller
const (
	// READY: Ready flag
	// Position of READY field.
	NVMC_READY_READY_Pos = 0x0
	// Bit mask of READY field.
	NVMC_READY_READY_Msk = 0x1
	// Bit READY.
	NVMC_READY_READY = 0x1
	// NVMC is busy (on-going write or erase operation)
	NVMC_READY_READY_Busy = 0x0
	// NVMC is ready
	NVMC_READY_READY_Ready = 0x1

	// READYNEXT: Ready flag
	// Position of READYNEXT field.
	NVMC_READYNEXT_READYNEXT_Pos = 0x0
	// Bit mask of READYNEXT field.
	NVMC_READYNEXT_READYNEXT_Msk = 0x1
	// Bit READYNEXT.
	NVMC_READYNEXT_READYNEXT = 0x1
	// NVMC cannot accept any write operation
	NVMC_READYNEXT_READYNEXT_Busy = 0x0
	// NVMC is ready
	NVMC_READYNEXT_READYNEXT_Ready = 0x1

	// CONFIG: Configuration register
	// Position of WEN field.
	NVMC_CONFIG_WEN_Pos = 0x0
	// Bit mask of WEN field.
	NVMC_CONFIG_WEN_Msk = 0x3
	// Read only access
	NVMC_CONFIG_WEN_Ren = 0x0
	// Write enabled
	NVMC_CONFIG_WEN_Wen = 0x1
	// Erase enabled
	NVMC_CONFIG_WEN_Een = 0x2

	// ERASEPAGE: Register for erasing a page in code area
	// Position of ERASEPAGE field.
	NVMC_ERASEPAGE_ERASEPAGE_Pos = 0x0
	// Bit mask of ERASEPAGE field.
	NVMC_ERASEPAGE_ERASEPAGE_Msk = 0xffffffff

	// ERASEPCR1: Deprecated register - Register for erasing a page in code area. Equivalent to ERASEPAGE.
	// Position of ERASEPCR1 field.
	NVMC_ERASEPCR1_ERASEPCR1_Pos = 0x0
	// Bit mask of ERASEPCR1 field.
	NVMC_ERASEPCR1_ERASEPCR1_Msk = 0xffffffff

	// ERASEALL: Register for erasing all non-volatile user memory
	// Position of ERASEALL field.
	NVMC_ERASEALL_ERASEALL_Pos = 0x0
	// Bit mask of ERASEALL field.
	NVMC_ERASEALL_ERASEALL_Msk = 0x1
	// Bit ERASEALL.
	NVMC_ERASEALL_ERASEALL = 0x1
	// No operation
	NVMC_ERASEALL_ERASEALL_NoOperation = 0x0
	// Start chip erase
	NVMC_ERASEALL_ERASEALL_Erase = 0x1

	// ERASEPCR0: Deprecated register - Register for erasing a page in code area. Equivalent to ERASEPAGE.
	// Position of ERASEPCR0 field.
	NVMC_ERASEPCR0_ERASEPCR0_Pos = 0x0
	// Bit mask of ERASEPCR0 field.
	NVMC_ERASEPCR0_ERASEPCR0_Msk = 0xffffffff

	// ERASEUICR: Register for erasing user information configuration registers
	// Position of ERASEUICR field.
	NVMC_ERASEUICR_ERASEUICR_Pos = 0x0
	// Bit mask of ERASEUICR field.
	NVMC_ERASEUICR_ERASEUICR_Msk = 0x1
	// Bit ERASEUICR.
	NVMC_ERASEUICR_ERASEUICR = 0x1
	// No operation
	NVMC_ERASEUICR_ERASEUICR_NoOperation = 0x0
	// Start erase of UICR
	NVMC_ERASEUICR_ERASEUICR_Erase = 0x1

	// ERASEPAGEPARTIAL: Register for partial erase of a page in code area
	// Position of ERASEPAGEPARTIAL field.
	NVMC_ERASEPAGEPARTIAL_ERASEPAGEPARTIAL_Pos = 0x0
	// Bit mask of ERASEPAGEPARTIAL field.
	NVMC_ERASEPAGEPARTIAL_ERASEPAGEPARTIAL_Msk = 0xffffffff

	// ERASEPAGEPARTIALCFG: Register for partial erase configuration
	// Position of DURATION field.
	NVMC_ERASEPAGEPARTIALCFG_DURATION_Pos = 0x0
	// Bit mask of DURATION field.
	NVMC_ERASEPAGEPARTIALCFG_DURATION_Msk = 0x7f

	// ICACHECNF: I-code cache configuration register.
	// Position of CACHEEN field.
	NVMC_ICACHECNF_CACHEEN_Pos = 0x0
	// Bit mask of CACHEEN field.
	NVMC_ICACHECNF_CACHEEN_Msk = 0x1
	// Bit CACHEEN.
	NVMC_ICACHECNF_CACHEEN = 0x1
	// Disable cache. Invalidates all cache entries.
	NVMC_ICACHECNF_CACHEEN_Disabled = 0x0
	// Enable cache
	NVMC_ICACHECNF_CACHEEN_Enabled = 0x1
	// Position of CACHEPROFEN field.
	NVMC_ICACHECNF_CACHEPROFEN_Pos = 0x8
	// Bit mask of CACHEPROFEN field.
	NVMC_ICACHECNF_CACHEPROFEN_Msk = 0x100
	// Bit CACHEPROFEN.
	NVMC_ICACHECNF_CACHEPROFEN = 0x100
	// Disable cache profiling
	NVMC_ICACHECNF_CACHEPROFEN_Disabled = 0x0
	// Enable cache profiling
	NVMC_ICACHECNF_CACHEPROFEN_Enabled = 0x1

	// IHIT: I-code cache hit counter.
	// Position of HITS field.
	NVMC_IHIT_HITS_Pos = 0x0
	// Bit mask of HITS field.
	NVMC_IHIT_HITS_Msk = 0xffffffff

	// IMISS: I-code cache miss counter.
	// Position of MISSES field.
	NVMC_IMISS_MISSES_Pos = 0x0
	// Bit mask of MISSES field.
	NVMC_IMISS_MISSES_Msk = 0xffffffff
)

// Bitfields for PPI: Programmable Peripheral Interconnect
const (
	// TASKS_CHG.EN: Description cluster: Enable channel group n
	// Position of EN field.
	PPI_TASKS_CHG_EN_EN_Pos = 0x0
	// Bit mask of EN field.
	PPI_TASKS_CHG_EN_EN_Msk = 0x1
	// Bit EN.
	PPI_TASKS_CHG_EN_EN = 0x1
	// Trigger task
	PPI_TASKS_CHG_EN_EN_Trigger = 0x1

	// TASKS_CHG.DIS: Description cluster: Disable channel group n
	// Position of DIS field.
	PPI_TASKS_CHG_DIS_DIS_Pos = 0x0
	// Bit mask of DIS field.
	PPI_TASKS_CHG_DIS_DIS_Msk = 0x1
	// Bit DIS.
	PPI_TASKS_CHG_DIS_DIS = 0x1
	// Trigger task
	PPI_TASKS_CHG_DIS_DIS_Trigger = 0x1

	// CHEN: Channel enable register
	// Position of CH0 field.
	PPI_CHEN_CH0_Pos = 0x0
	// Bit mask of CH0 field.
	PPI_CHEN_CH0_Msk = 0x1
	// Bit CH0.
	PPI_CHEN_CH0 = 0x1
	// Disable channel
	PPI_CHEN_CH0_Disabled = 0x0
	// Enable channel
	PPI_CHEN_CH0_Enabled = 0x1
	// Position of CH1 field.
	PPI_CHEN_CH1_Pos = 0x1
	// Bit mask of CH1 field.
	PPI_CHEN_CH1_Msk = 0x2
	// Bit CH1.
	PPI_CHEN_CH1 = 0x2
	// Disable channel
	PPI_CHEN_CH1_Disabled = 0x0
	// Enable channel
	PPI_CHEN_CH1_Enabled = 0x1
	// Position of CH2 field.
	PPI_CHEN_CH2_Pos = 0x2
	// Bit mask of CH2 field.
	PPI_CHEN_CH2_Msk = 0x4
	// Bit CH2.
	PPI_CHEN_CH2 = 0x4
	// Disable channel
	PPI_CHEN_CH2_Disabled = 0x0
	// Enable channel
	PPI_CHEN_CH2_Enabled = 0x1
	// Position of CH3 field.
	PPI_CHEN_CH3_Pos = 0x3
	// Bit mask of CH3 field.
	PPI_CHEN_CH3_Msk = 0x8
	// Bit CH3.
	PPI_CHEN_CH3 = 0x8
	// Disable channel
	PPI_CHEN_CH3_Disabled = 0x0
	// Enable channel
	PPI_CHEN_CH3_Enabled = 0x1
	// Position of CH4 field.
	PPI_CHEN_CH4_Pos = 0x4
	// Bit mask of CH4 field.
	PPI_CHEN_CH4_Msk = 0x10
	// Bit CH4.
	PPI_CHEN_CH4 = 0x10
	// Disable channel
	PPI_CHEN_CH4_Disabled = 0x0
	// Enable channel
	PPI_CHEN_CH4_Enabled = 0x1
	// Position of CH5 field.
	PPI_CHEN_CH5_Pos = 0x5
	// Bit mask of CH5 field.
	PPI_CHEN_CH5_Msk = 0x20
	// Bit CH5.
	PPI_CHEN_CH5 = 0x20
	// Disable channel
	PPI_CHEN_CH5_Disabled = 0x0
	// Enable channel
	PPI_CHEN_CH5_Enabled = 0x1
	// Position of CH6 field.
	PPI_CHEN_CH6_Pos = 0x6
	// Bit mask of CH6 field.
	PPI_CHEN_CH6_Msk = 0x40
	// Bit CH6.
	PPI_CHEN_CH6 = 0x40
	// Disable channel
	PPI_CHEN_CH6_Disabled = 0x0
	// Enable channel
	PPI_CHEN_CH6_Enabled = 0x1
	// Position of CH7 field.
	PPI_CHEN_CH7_Pos = 0x7
	// Bit mask of CH7 field.
	PPI_CHEN_CH7_Msk = 0x80
	// Bit CH7.
	PPI_CHEN_CH7 = 0x80
	// Disable channel
	PPI_CHEN_CH7_Disabled = 0x0
	// Enable channel
	PPI_CHEN_CH7_Enabled = 0x1
	// Position of CH8 field.
	PPI_CHEN_CH8_Pos = 0x8
	// Bit mask of CH8 field.
	PPI_CHEN_CH8_Msk = 0x100
	// Bit CH8.
	PPI_CHEN_CH8 = 0x100
	// Disable channel
	PPI_CHEN_CH8_Disabled = 0x0
	// Enable channel
	PPI_CHEN_CH8_Enabled = 0x1
	// Position of CH9 field.
	PPI_CHEN_CH9_Pos = 0x9
	// Bit mask of CH9 field.
	PPI_CHEN_CH9_Msk = 0x200
	// Bit CH9.
	PPI_CHEN_CH9 = 0x200
	// Disable channel
	PPI_CHEN_CH9_Disabled = 0x0
	// Enable channel
	PPI_CHEN_CH9_Enabled = 0x1
	// Position of CH10 field.
	PPI_CHEN_CH10_Pos = 0xa
	// Bit mask of CH10 field.
	PPI_CHEN_CH10_Msk = 0x400
	// Bit CH10.
	PPI_CHEN_CH10 = 0x400
	// Disable channel
	PPI_CHEN_CH10_Disabled = 0x0
	// Enable channel
	PPI_CHEN_CH10_Enabled = 0x1
	// Position of CH11 field.
	PPI_CHEN_CH11_Pos = 0xb
	// Bit mask of CH11 field.
	PPI_CHEN_CH11_Msk = 0x800
	// Bit CH11.
	PPI_CHEN_CH11 = 0x800
	// Disable channel
	PPI_CHEN_CH11_Disabled = 0x0
	// Enable channel
	PPI_CHEN_CH11_Enabled = 0x1
	// Position of CH12 field.
	PPI_CHEN_CH12_Pos = 0xc
	// Bit mask of CH12 field.
	PPI_CHEN_CH12_Msk = 0x1000
	// Bit CH12.
	PPI_CHEN_CH12 = 0x1000
	// Disable channel
	PPI_CHEN_CH12_Disabled = 0x0
	// Enable channel
	PPI_CHEN_CH12_Enabled = 0x1
	// Position of CH13 field.
	PPI_CHEN_CH13_Pos = 0xd
	// Bit mask of CH13 field.
	PPI_CHEN_CH13_Msk = 0x2000
	// Bit CH13.
	PPI_CHEN_CH13 = 0x2000
	// Disable channel
	PPI_CHEN_CH13_Disabled = 0x0
	// Enable channel
	PPI_CHEN_CH13_Enabled = 0x1
	// Position of CH14 field.
	PPI_CHEN_CH14_Pos = 0xe
	// Bit mask of CH14 field.
	PPI_CHEN_CH14_Msk = 0x4000
	// Bit CH14.
	PPI_CHEN_CH14 = 0x4000
	// Disable channel
	PPI_CHEN_CH14_Disabled = 0x0
	// Enable channel
	PPI_CHEN_CH14_Enabled = 0x1
	// Position of CH15 field.
	PPI_CHEN_CH15_Pos = 0xf
	// Bit mask of CH15 field.
	PPI_CHEN_CH15_Msk = 0x8000
	// Bit CH15.
	PPI_CHEN_CH15 = 0x8000
	// Disable channel
	PPI_CHEN_CH15_Disabled = 0x0
	// Enable channel
	PPI_CHEN_CH15_Enabled = 0x1
	// Position of CH16 field.
	PPI_CHEN_CH16_Pos = 0x10
	// Bit mask of CH16 field.
	PPI_CHEN_CH16_Msk = 0x10000
	// Bit CH16.
	PPI_CHEN_CH16 = 0x10000
	// Disable channel
	PPI_CHEN_CH16_Disabled = 0x0
	// Enable channel
	PPI_CHEN_CH16_Enabled = 0x1
	// Position of CH17 field.
	PPI_CHEN_CH17_Pos = 0x11
	// Bit mask of CH17 field.
	PPI_CHEN_CH17_Msk = 0x20000
	// Bit CH17.
	PPI_CHEN_CH17 = 0x20000
	// Disable channel
	PPI_CHEN_CH17_Disabled = 0x0
	// Enable channel
	PPI_CHEN_CH17_Enabled = 0x1
	// Position of CH18 field.
	PPI_CHEN_CH18_Pos = 0x12
	// Bit mask of CH18 field.
	PPI_CHEN_CH18_Msk = 0x40000
	// Bit CH18.
	PPI_CHEN_CH18 = 0x40000
	// Disable channel
	PPI_CHEN_CH18_Disabled = 0x0
	// Enable channel
	PPI_CHEN_CH18_Enabled = 0x1
	// Position of CH19 field.
	PPI_CHEN_CH19_Pos = 0x13
	// Bit mask of CH19 field.
	PPI_CHEN_CH19_Msk = 0x80000
	// Bit CH19.
	PPI_CHEN_CH19 = 0x80000
	// Disable channel
	PPI_CHEN_CH19_Disabled = 0x0
	// Enable channel
	PPI_CHEN_CH19_Enabled = 0x1
	// Position of CH20 field.
	PPI_CHEN_CH20_Pos = 0x14
	// Bit mask of CH20 field.
	PPI_CHEN_CH20_Msk = 0x100000
	// Bit CH20.
	PPI_CHEN_CH20 = 0x100000
	// Disable channel
	PPI_CHEN_CH20_Disabled = 0x0
	// Enable channel
	PPI_CHEN_CH20_Enabled = 0x1
	// Position of CH21 field.
	PPI_CHEN_CH21_Pos = 0x15
	// Bit mask of CH21 field.
	PPI_CHEN_CH21_Msk = 0x200000
	// Bit CH21.
	PPI_CHEN_CH21 = 0x200000
	// Disable channel
	PPI_CHEN_CH21_Disabled = 0x0
	// Enable channel
	PPI_CHEN_CH21_Enabled = 0x1
	// Position of CH22 field.
	PPI_CHEN_CH22_Pos = 0x16
	// Bit mask of CH22 field.
	PPI_CHEN_CH22_Msk = 0x400000
	// Bit CH22.
	PPI_CHEN_CH22 = 0x400000
	// Disable channel
	PPI_CHEN_CH22_Disabled = 0x0
	// Enable channel
	PPI_CHEN_CH22_Enabled = 0x1
	// Position of CH23 field.
	PPI_CHEN_CH23_Pos = 0x17
	// Bit mask of CH23 field.
	PPI_CHEN_CH23_Msk = 0x800000
	// Bit CH23.
	PPI_CHEN_CH23 = 0x800000
	// Disable channel
	PPI_CHEN_CH23_Disabled = 0x0
	// Enable channel
	PPI_CHEN_CH23_Enabled = 0x1
	// Position of CH24 field.
	PPI_CHEN_CH24_Pos = 0x18
	// Bit mask of CH24 field.
	PPI_CHEN_CH24_Msk = 0x1000000
	// Bit CH24.
	PPI_CHEN_CH24 = 0x1000000
	// Disable channel
	PPI_CHEN_CH24_Disabled = 0x0
	// Enable channel
	PPI_CHEN_CH24_Enabled = 0x1
	// Position of CH25 field.
	PPI_CHEN_CH25_Pos = 0x19
	// Bit mask of CH25 field.
	PPI_CHEN_CH25_Msk = 0x2000000
	// Bit CH25.
	PPI_CHEN_CH25 = 0x2000000
	// Disable channel
	PPI_CHEN_CH25_Disabled = 0x0
	// Enable channel
	PPI_CHEN_CH25_Enabled = 0x1
	// Position of CH26 field.
	PPI_CHEN_CH26_Pos = 0x1a
	// Bit mask of CH26 field.
	PPI_CHEN_CH26_Msk = 0x4000000
	// Bit CH26.
	PPI_CHEN_CH26 = 0x4000000
	// Disable channel
	PPI_CHEN_CH26_Disabled = 0x0
	// Enable channel
	PPI_CHEN_CH26_Enabled = 0x1
	// Position of CH27 field.
	PPI_CHEN_CH27_Pos = 0x1b
	// Bit mask of CH27 field.
	PPI_CHEN_CH27_Msk = 0x8000000
	// Bit CH27.
	PPI_CHEN_CH27 = 0x8000000
	// Disable channel
	PPI_CHEN_CH27_Disabled = 0x0
	// Enable channel
	PPI_CHEN_CH27_Enabled = 0x1
	// Position of CH28 field.
	PPI_CHEN_CH28_Pos = 0x1c
	// Bit mask of CH28 field.
	PPI_CHEN_CH28_Msk = 0x10000000
	// Bit CH28.
	PPI_CHEN_CH28 = 0x10000000
	// Disable channel
	PPI_CHEN_CH28_Disabled = 0x0
	// Enable channel
	PPI_CHEN_CH28_Enabled = 0x1
	// Position of CH29 field.
	PPI_CHEN_CH29_Pos = 0x1d
	// Bit mask of CH29 field.
	PPI_CHEN_CH29_Msk = 0x20000000
	// Bit CH29.
	PPI_CHEN_CH29 = 0x20000000
	// Disable channel
	PPI_CHEN_CH29_Disabled = 0x0
	// Enable channel
	PPI_CHEN_CH29_Enabled = 0x1
	// Position of CH30 field.
	PPI_CHEN_CH30_Pos = 0x1e
	// Bit mask of CH30 field.
	PPI_CHEN_CH30_Msk = 0x40000000
	// Bit CH30.
	PPI_CHEN_CH30 = 0x40000000
	// Disable channel
	PPI_CHEN_CH30_Disabled = 0x0
	// Enable channel
	PPI_CHEN_CH30_Enabled = 0x1
	// Position of CH31 field.
	PPI_CHEN_CH31_Pos = 0x1f
	// Bit mask of CH31 field.
	PPI_CHEN_CH31_Msk = 0x80000000
	// Bit CH31.
	PPI_CHEN_CH31 = 0x80000000
	// Disable channel
	PPI_CHEN_CH31_Disabled = 0x0
	// Enable channel
	PPI_CHEN_CH31_Enabled = 0x1

	// CHENSET: Channel enable set register
	// Position of CH0 field.
	PPI_CHENSET_CH0_Pos = 0x0
	// Bit mask of CH0 field.
	PPI_CHENSET_CH0_Msk = 0x1
	// Bit CH0.
	PPI_CHENSET_CH0 = 0x1
	// Read: channel disabled
	PPI_CHENSET_CH0_Disabled = 0x0
	// Read: channel enabled
	PPI_CHENSET_CH0_Enabled = 0x1
	// Write: Enable channel
	PPI_CHENSET_CH0_Set = 0x1
	// Position of CH1 field.
	PPI_CHENSET_CH1_Pos = 0x1
	// Bit mask of CH1 field.
	PPI_CHENSET_CH1_Msk = 0x2
	// Bit CH1.
	PPI_CHENSET_CH1 = 0x2
	// Read: channel disabled
	PPI_CHENSET_CH1_Disabled = 0x0
	// Read: channel enabled
	PPI_CHENSET_CH1_Enabled = 0x1
	// Write: Enable channel
	PPI_CHENSET_CH1_Set = 0x1
	// Position of CH2 field.
	PPI_CHENSET_CH2_Pos = 0x2
	// Bit mask of CH2 field.
	PPI_CHENSET_CH2_Msk = 0x4
	// Bit CH2.
	PPI_CHENSET_CH2 = 0x4
	// Read: channel disabled
	PPI_CHENSET_CH2_Disabled = 0x0
	// Read: channel enabled
	PPI_CHENSET_CH2_Enabled = 0x1
	// Write: Enable channel
	PPI_CHENSET_CH2_Set = 0x1
	// Position of CH3 field.
	PPI_CHENSET_CH3_Pos = 0x3
	// Bit mask of CH3 field.
	PPI_CHENSET_CH3_Msk = 0x8
	// Bit CH3.
	PPI_CHENSET_CH3 = 0x8
	// Read: channel disabled
	PPI_CHENSET_CH3_Disabled = 0x0
	// Read: channel enabled
	PPI_CHENSET_CH3_Enabled = 0x1
	// Write: Enable channel
	PPI_CHENSET_CH3_Set = 0x1
	// Position of CH4 field.
	PPI_CHENSET_CH4_Pos = 0x4
	// Bit mask of CH4 field.
	PPI_CHENSET_CH4_Msk = 0x10
	// Bit CH4.
	PPI_CHENSET_CH4 = 0x10
	// Read: channel disabled
	PPI_CHENSET_CH4_Disabled = 0x0
	// Read: channel enabled
	PPI_CHENSET_CH4_Enabled = 0x1
	// Write: Enable channel
	PPI_CHENSET_CH4_Set = 0x1
	// Position of CH5 field.
	PPI_CHENSET_CH5_Pos = 0x5
	// Bit mask of CH5 field.
	PPI_CHENSET_CH5_Msk = 0x20
	// Bit CH5.
	PPI_CHENSET_CH5 = 0x20
	// Read: channel disabled
	PPI_CHENSET_CH5_Disabled = 0x0
	// Read: channel enabled
	PPI_CHENSET_CH5_Enabled = 0x1
	// Write: Enable channel
	PPI_CHENSET_CH5_Set = 0x1
	// Position of CH6 field.
	PPI_CHENSET_CH6_Pos = 0x6
	// Bit mask of CH6 field.
	PPI_CHENSET_CH6_Msk = 0x40
	// Bit CH6.
	PPI_CHENSET_CH6 = 0x40
	// Read: channel disabled
	PPI_CHENSET_CH6_Disabled = 0x0
	// Read: channel enabled
	PPI_CHENSET_CH6_Enabled = 0x1
	// Write: Enable channel
	PPI_CHENSET_CH6_Set = 0x1
	// Position of CH7 field.
	PPI_CHENSET_CH7_Pos = 0x7
	// Bit mask of CH7 field.
	PPI_CHENSET_CH7_Msk = 0x80
	// Bit CH7.
	PPI_CHENSET_CH7 = 0x80
	// Read: channel disabled
	PPI_CHENSET_CH7_Disabled = 0x0
	// Read: channel enabled
	PPI_CHENSET_CH7_Enabled = 0x1
	// Write: Enable channel
	PPI_CHENSET_CH7_Set = 0x1
	// Position of CH8 field.
	PPI_CHENSET_CH8_Pos = 0x8
	// Bit mask of CH8 field.
	PPI_CHENSET_CH8_Msk = 0x100
	// Bit CH8.
	PPI_CHENSET_CH8 = 0x100
	// Read: channel disabled
	PPI_CHENSET_CH8_Disabled = 0x0
	// Read: channel enabled
	PPI_CHENSET_CH8_Enabled = 0x1
	// Write: Enable channel
	PPI_CHENSET_CH8_Set = 0x1
	// Position of CH9 field.
	PPI_CHENSET_CH9_Pos = 0x9
	// Bit mask of CH9 field.
	PPI_CHENSET_CH9_Msk = 0x200
	// Bit CH9.
	PPI_CHENSET_CH9 = 0x200
	// Read: channel disabled
	PPI_CHENSET_CH9_Disabled = 0x0
	// Read: channel enabled
	PPI_CHENSET_CH9_Enabled = 0x1
	// Write: Enable channel
	PPI_CHENSET_CH9_Set = 0x1
	// Position of CH10 field.
	PPI_CHENSET_CH10_Pos = 0xa
	// Bit mask of CH10 field.
	PPI_CHENSET_CH10_Msk = 0x400
	// Bit CH10.
	PPI_CHENSET_CH10 = 0x400
	// Read: channel disabled
	PPI_CHENSET_CH10_Disabled = 0x0
	// Read: channel enabled
	PPI_CHENSET_CH10_Enabled = 0x1
	// Write: Enable channel
	PPI_CHENSET_CH10_Set = 0x1
	// Position of CH11 field.
	PPI_CHENSET_CH11_Pos = 0xb
	// Bit mask of CH11 field.
	PPI_CHENSET_CH11_Msk = 0x800
	// Bit CH11.
	PPI_CHENSET_CH11 = 0x800
	// Read: channel disabled
	PPI_CHENSET_CH11_Disabled = 0x0
	// Read: channel enabled
	PPI_CHENSET_CH11_Enabled = 0x1
	// Write: Enable channel
	PPI_CHENSET_CH11_Set = 0x1
	// Position of CH12 field.
	PPI_CHENSET_CH12_Pos = 0xc
	// Bit mask of CH12 field.
	PPI_CHENSET_CH12_Msk = 0x1000
	// Bit CH12.
	PPI_CHENSET_CH12 = 0x1000
	// Read: channel disabled
	PPI_CHENSET_CH12_Disabled = 0x0
	// Read: channel enabled
	PPI_CHENSET_CH12_Enabled = 0x1
	// Write: Enable channel
	PPI_CHENSET_CH12_Set = 0x1
	// Position of CH13 field.
	PPI_CHENSET_CH13_Pos = 0xd
	// Bit mask of CH13 field.
	PPI_CHENSET_CH13_Msk = 0x2000
	// Bit CH13.
	PPI_CHENSET_CH13 = 0x2000
	// Read: channel disabled
	PPI_CHENSET_CH13_Disabled = 0x0
	// Read: channel enabled
	PPI_CHENSET_CH13_Enabled = 0x1
	// Write: Enable channel
	PPI_CHENSET_CH13_Set = 0x1
	// Position of CH14 field.
	PPI_CHENSET_CH14_Pos = 0xe
	// Bit mask of CH14 field.
	PPI_CHENSET_CH14_Msk = 0x4000
	// Bit CH14.
	PPI_CHENSET_CH14 = 0x4000
	// Read: channel disabled
	PPI_CHENSET_CH14_Disabled = 0x0
	// Read: channel enabled
	PPI_CHENSET_CH14_Enabled = 0x1
	// Write: Enable channel
	PPI_CHENSET_CH14_Set = 0x1
	// Position of CH15 field.
	PPI_CHENSET_CH15_Pos = 0xf
	// Bit mask of CH15 field.
	PPI_CHENSET_CH15_Msk = 0x8000
	// Bit CH15.
	PPI_CHENSET_CH15 = 0x8000
	// Read: channel disabled
	PPI_CHENSET_CH15_Disabled = 0x0
	// Read: channel enabled
	PPI_CHENSET_CH15_Enabled = 0x1
	// Write: Enable channel
	PPI_CHENSET_CH15_Set = 0x1
	// Position of CH16 field.
	PPI_CHENSET_CH16_Pos = 0x10
	// Bit mask of CH16 field.
	PPI_CHENSET_CH16_Msk = 0x10000
	// Bit CH16.
	PPI_CHENSET_CH16 = 0x10000
	// Read: channel disabled
	PPI_CHENSET_CH16_Disabled = 0x0
	// Read: channel enabled
	PPI_CHENSET_CH16_Enabled = 0x1
	// Write: Enable channel
	PPI_CHENSET_CH16_Set = 0x1
	// Position of CH17 field.
	PPI_CHENSET_CH17_Pos = 0x11
	// Bit mask of CH17 field.
	PPI_CHENSET_CH17_Msk = 0x20000
	// Bit CH17.
	PPI_CHENSET_CH17 = 0x20000
	// Read: channel disabled
	PPI_CHENSET_CH17_Disabled = 0x0
	// Read: channel enabled
	PPI_CHENSET_CH17_Enabled = 0x1
	// Write: Enable channel
	PPI_CHENSET_CH17_Set = 0x1
	// Position of CH18 field.
	PPI_CHENSET_CH18_Pos = 0x12
	// Bit mask of CH18 field.
	PPI_CHENSET_CH18_Msk = 0x40000
	// Bit CH18.
	PPI_CHENSET_CH18 = 0x40000
	// Read: channel disabled
	PPI_CHENSET_CH18_Disabled = 0x0
	// Read: channel enabled
	PPI_CHENSET_CH18_Enabled = 0x1
	// Write: Enable channel
	PPI_CHENSET_CH18_Set = 0x1
	// Position of CH19 field.
	PPI_CHENSET_CH19_Pos = 0x13
	// Bit mask of CH19 field.
	PPI_CHENSET_CH19_Msk = 0x80000
	// Bit CH19.
	PPI_CHENSET_CH19 = 0x80000
	// Read: channel disabled
	PPI_CHENSET_CH19_Disabled = 0x0
	// Read: channel enabled
	PPI_CHENSET_CH19_Enabled = 0x1
	// Write: Enable channel
	PPI_CHENSET_CH19_Set = 0x1
	// Position of CH20 field.
	PPI_CHENSET_CH20_Pos = 0x14
	// Bit mask of CH20 field.
	PPI_CHENSET_CH20_Msk = 0x100000
	// Bit CH20.
	PPI_CHENSET_CH20 = 0x100000
	// Read: channel disabled
	PPI_CHENSET_CH20_Disabled = 0x0
	// Read: channel enabled
	PPI_CHENSET_CH20_Enabled = 0x1
	// Write: Enable channel
	PPI_CHENSET_CH20_Set = 0x1
	// Position of CH21 field.
	PPI_CHENSET_CH21_Pos = 0x15
	// Bit mask of CH21 field.
	PPI_CHENSET_CH21_Msk = 0x200000
	// Bit CH21.
	PPI_CHENSET_CH21 = 0x200000
	// Read: channel disabled
	PPI_CHENSET_CH21_Disabled = 0x0
	// Read: channel enabled
	PPI_CHENSET_CH21_Enabled = 0x1
	// Write: Enable channel
	PPI_CHENSET_CH21_Set = 0x1
	// Position of CH22 field.
	PPI_CHENSET_CH22_Pos = 0x16
	// Bit mask of CH22 field.
	PPI_CHENSET_CH22_Msk = 0x400000
	// Bit CH22.
	PPI_CHENSET_CH22 = 0x400000
	// Read: channel disabled
	PPI_CHENSET_CH22_Disabled = 0x0
	// Read: channel enabled
	PPI_CHENSET_CH22_Enabled = 0x1
	// Write: Enable channel
	PPI_CHENSET_CH22_Set = 0x1
	// Position of CH23 field.
	PPI_CHENSET_CH23_Pos = 0x17
	// Bit mask of CH23 field.
	PPI_CHENSET_CH23_Msk = 0x800000
	// Bit CH23.
	PPI_CHENSET_CH23 = 0x800000
	// Read: channel disabled
	PPI_CHENSET_CH23_Disabled = 0x0
	// Read: channel enabled
	PPI_CHENSET_CH23_Enabled = 0x1
	// Write: Enable channel
	PPI_CHENSET_CH23_Set = 0x1
	// Position of CH24 field.
	PPI_CHENSET_CH24_Pos = 0x18
	// Bit mask of CH24 field.
	PPI_CHENSET_CH24_Msk = 0x1000000
	// Bit CH24.
	PPI_CHENSET_CH24 = 0x1000000
	// Read: channel disabled
	PPI_CHENSET_CH24_Disabled = 0x0
	// Read: channel enabled
	PPI_CHENSET_CH24_Enabled = 0x1
	// Write: Enable channel
	PPI_CHENSET_CH24_Set = 0x1
	// Position of CH25 field.
	PPI_CHENSET_CH25_Pos = 0x19
	// Bit mask of CH25 field.
	PPI_CHENSET_CH25_Msk = 0x2000000
	// Bit CH25.
	PPI_CHENSET_CH25 = 0x2000000
	// Read: channel disabled
	PPI_CHENSET_CH25_Disabled = 0x0
	// Read: channel enabled
	PPI_CHENSET_CH25_Enabled = 0x1
	// Write: Enable channel
	PPI_CHENSET_CH25_Set = 0x1
	// Position of CH26 field.
	PPI_CHENSET_CH26_Pos = 0x1a
	// Bit mask of CH26 field.
	PPI_CHENSET_CH26_Msk = 0x4000000
	// Bit CH26.
	PPI_CHENSET_CH26 = 0x4000000
	// Read: channel disabled
	PPI_CHENSET_CH26_Disabled = 0x0
	// Read: channel enabled
	PPI_CHENSET_CH26_Enabled = 0x1
	// Write: Enable channel
	PPI_CHENSET_CH26_Set = 0x1
	// Position of CH27 field.
	PPI_CHENSET_CH27_Pos = 0x1b
	// Bit mask of CH27 field.
	PPI_CHENSET_CH27_Msk = 0x8000000
	// Bit CH27.
	PPI_CHENSET_CH27 = 0x8000000
	// Read: channel disabled
	PPI_CHENSET_CH27_Disabled = 0x0
	// Read: channel enabled
	PPI_CHENSET_CH27_Enabled = 0x1
	// Write: Enable channel
	PPI_CHENSET_CH27_Set = 0x1
	// Position of CH28 field.
	PPI_CHENSET_CH28_Pos = 0x1c
	// Bit mask of CH28 field.
	PPI_CHENSET_CH28_Msk = 0x10000000
	// Bit CH28.
	PPI_CHENSET_CH28 = 0x10000000
	// Read: channel disabled
	PPI_CHENSET_CH28_Disabled = 0x0
	// Read: channel enabled
	PPI_CHENSET_CH28_Enabled = 0x1
	// Write: Enable channel
	PPI_CHENSET_CH28_Set = 0x1
	// Position of CH29 field.
	PPI_CHENSET_CH29_Pos = 0x1d
	// Bit mask of CH29 field.
	PPI_CHENSET_CH29_Msk = 0x20000000
	// Bit CH29.
	PPI_CHENSET_CH29 = 0x20000000
	// Read: channel disabled
	PPI_CHENSET_CH29_Disabled = 0x0
	// Read: channel enabled
	PPI_CHENSET_CH29_Enabled = 0x1
	// Write: Enable channel
	PPI_CHENSET_CH29_Set = 0x1
	// Position of CH30 field.
	PPI_CHENSET_CH30_Pos = 0x1e
	// Bit mask of CH30 field.
	PPI_CHENSET_CH30_Msk = 0x40000000
	// Bit CH30.
	PPI_CHENSET_CH30 = 0x40000000
	// Read: channel disabled
	PPI_CHENSET_CH30_Disabled = 0x0
	// Read: channel enabled
	PPI_CHENSET_CH30_Enabled = 0x1
	// Write: Enable channel
	PPI_CHENSET_CH30_Set = 0x1
	// Position of CH31 field.
	PPI_CHENSET_CH31_Pos = 0x1f
	// Bit mask of CH31 field.
	PPI_CHENSET_CH31_Msk = 0x80000000
	// Bit CH31.
	PPI_CHENSET_CH31 = 0x80000000
	// Read: channel disabled
	PPI_CHENSET_CH31_Disabled = 0x0
	// Read: channel enabled
	PPI_CHENSET_CH31_Enabled = 0x1
	// Write: Enable channel
	PPI_CHENSET_CH31_Set = 0x1

	// CHENCLR: Channel enable clear register
	// Position of CH0 field.
	PPI_CHENCLR_CH0_Pos = 0x0
	// Bit mask of CH0 field.
	PPI_CHENCLR_CH0_Msk = 0x1
	// Bit CH0.
	PPI_CHENCLR_CH0 = 0x1
	// Read: channel disabled
	PPI_CHENCLR_CH0_Disabled = 0x0
	// Read: channel enabled
	PPI_CHENCLR_CH0_Enabled = 0x1
	// Write: disable channel
	PPI_CHENCLR_CH0_Clear = 0x1
	// Position of CH1 field.
	PPI_CHENCLR_CH1_Pos = 0x1
	// Bit mask of CH1 field.
	PPI_CHENCLR_CH1_Msk = 0x2
	// Bit CH1.
	PPI_CHENCLR_CH1 = 0x2
	// Read: channel disabled
	PPI_CHENCLR_CH1_Disabled = 0x0
	// Read: channel enabled
	PPI_CHENCLR_CH1_Enabled = 0x1
	// Write: disable channel
	PPI_CHENCLR_CH1_Clear = 0x1
	// Position of CH2 field.
	PPI_CHENCLR_CH2_Pos = 0x2
	// Bit mask of CH2 field.
	PPI_CHENCLR_CH2_Msk = 0x4
	// Bit CH2.
	PPI_CHENCLR_CH2 = 0x4
	// Read: channel disabled
	PPI_CHENCLR_CH2_Disabled = 0x0
	// Read: channel enabled
	PPI_CHENCLR_CH2_Enabled = 0x1
	// Write: disable channel
	PPI_CHENCLR_CH2_Clear = 0x1
	// Position of CH3 field.
	PPI_CHENCLR_CH3_Pos = 0x3
	// Bit mask of CH3 field.
	PPI_CHENCLR_CH3_Msk = 0x8
	// Bit CH3.
	PPI_CHENCLR_CH3 = 0x8
	// Read: channel disabled
	PPI_CHENCLR_CH3_Disabled = 0x0
	// Read: channel enabled
	PPI_CHENCLR_CH3_Enabled = 0x1
	// Write: disable channel
	PPI_CHENCLR_CH3_Clear = 0x1
	// Position of CH4 field.
	PPI_CHENCLR_CH4_Pos = 0x4
	// Bit mask of CH4 field.
	PPI_CHENCLR_CH4_Msk = 0x10
	// Bit CH4.
	PPI_CHENCLR_CH4 = 0x10
	// Read: channel disabled
	PPI_CHENCLR_CH4_Disabled = 0x0
	// Read: channel enabled
	PPI_CHENCLR_CH4_Enabled = 0x1
	// Write: disable channel
	PPI_CHENCLR_CH4_Clear = 0x1
	// Position of CH5 field.
	PPI_CHENCLR_CH5_Pos = 0x5
	// Bit mask of CH5 field.
	PPI_CHENCLR_CH5_Msk = 0x20
	// Bit CH5.
	PPI_CHENCLR_CH5 = 0x20
	// Read: channel disabled
	PPI_CHENCLR_CH5_Disabled = 0x0
	// Read: channel enabled
	PPI_CHENCLR_CH5_Enabled = 0x1
	// Write: disable channel
	PPI_CHENCLR_CH5_Clear = 0x1
	// Position of CH6 field.
	PPI_CHENCLR_CH6_Pos = 0x6
	// Bit mask of CH6 field.
	PPI_CHENCLR_CH6_Msk = 0x40
	// Bit CH6.
	PPI_CHENCLR_CH6 = 0x40
	// Read: channel disabled
	PPI_CHENCLR_CH6_Disabled = 0x0
	// Read: channel enabled
	PPI_CHENCLR_CH6_Enabled = 0x1
	// Write: disable channel
	PPI_CHENCLR_CH6_Clear = 0x1
	// Position of CH7 field.
	PPI_CHENCLR_CH7_Pos = 0x7
	// Bit mask of CH7 field.
	PPI_CHENCLR_CH7_Msk = 0x80
	// Bit CH7.
	PPI_CHENCLR_CH7 = 0x80
	// Read: channel disabled
	PPI_CHENCLR_CH7_Disabled = 0x0
	// Read: channel enabled
	PPI_CHENCLR_CH7_Enabled = 0x1
	// Write: disable channel
	PPI_CHENCLR_CH7_Clear = 0x1
	// Position of CH8 field.
	PPI_CHENCLR_CH8_Pos = 0x8
	// Bit mask of CH8 field.
	PPI_CHENCLR_CH8_Msk = 0x100
	// Bit CH8.
	PPI_CHENCLR_CH8 = 0x100
	// Read: channel disabled
	PPI_CHENCLR_CH8_Disabled = 0x0
	// Read: channel enabled
	PPI_CHENCLR_CH8_Enabled = 0x1
	// Write: disable channel
	PPI_CHENCLR_CH8_Clear = 0x1
	// Position of CH9 field.
	PPI_CHENCLR_CH9_Pos = 0x9
	// Bit mask of CH9 field.
	PPI_CHENCLR_CH9_Msk = 0x200
	// Bit CH9.
	PPI_CHENCLR_CH9 = 0x200
	// Read: channel disabled
	PPI_CHENCLR_CH9_Disabled = 0x0
	// Read: channel enabled
	PPI_CHENCLR_CH9_Enabled = 0x1
	// Write: disable channel
	PPI_CHENCLR_CH9_Clear = 0x1
	// Position of CH10 field.
	PPI_CHENCLR_CH10_Pos = 0xa
	// Bit mask of CH10 field.
	PPI_CHENCLR_CH10_Msk = 0x400
	// Bit CH10.
	PPI_CHENCLR_CH10 = 0x400
	// Read: channel disabled
	PPI_CHENCLR_CH10_Disabled = 0x0
	// Read: channel enabled
	PPI_CHENCLR_CH10_Enabled = 0x1
	// Write: disable channel
	PPI_CHENCLR_CH10_Clear = 0x1
	// Position of CH11 field.
	PPI_CHENCLR_CH11_Pos = 0xb
	// Bit mask of CH11 field.
	PPI_CHENCLR_CH11_Msk = 0x800
	// Bit CH11.
	PPI_CHENCLR_CH11 = 0x800
	// Read: channel disabled
	PPI_CHENCLR_CH11_Disabled = 0x0
	// Read: channel enabled
	PPI_CHENCLR_CH11_Enabled = 0x1
	// Write: disable channel
	PPI_CHENCLR_CH11_Clear = 0x1
	// Position of CH12 field.
	PPI_CHENCLR_CH12_Pos = 0xc
	// Bit mask of CH12 field.
	PPI_CHENCLR_CH12_Msk = 0x1000
	// Bit CH12.
	PPI_CHENCLR_CH12 = 0x1000
	// Read: channel disabled
	PPI_CHENCLR_CH12_Disabled = 0x0
	// Read: channel enabled
	PPI_CHENCLR_CH12_Enabled = 0x1
	// Write: disable channel
	PPI_CHENCLR_CH12_Clear = 0x1
	// Position of CH13 field.
	PPI_CHENCLR_CH13_Pos = 0xd
	// Bit mask of CH13 field.
	PPI_CHENCLR_CH13_Msk = 0x2000
	// Bit CH13.
	PPI_CHENCLR_CH13 = 0x2000
	// Read: channel disabled
	PPI_CHENCLR_CH13_Disabled = 0x0
	// Read: channel enabled
	PPI_CHENCLR_CH13_Enabled = 0x1
	// Write: disable channel
	PPI_CHENCLR_CH13_Clear = 0x1
	// Position of CH14 field.
	PPI_CHENCLR_CH14_Pos = 0xe
	// Bit mask of CH14 field.
	PPI_CHENCLR_CH14_Msk = 0x4000
	// Bit CH14.
	PPI_CHENCLR_CH14 = 0x4000
	// Read: channel disabled
	PPI_CHENCLR_CH14_Disabled = 0x0
	// Read: channel enabled
	PPI_CHENCLR_CH14_Enabled = 0x1
	// Write: disable channel
	PPI_CHENCLR_CH14_Clear = 0x1
	// Position of CH15 field.
	PPI_CHENCLR_CH15_Pos = 0xf
	// Bit mask of CH15 field.
	PPI_CHENCLR_CH15_Msk = 0x8000
	// Bit CH15.
	PPI_CHENCLR_CH15 = 0x8000
	// Read: channel disabled
	PPI_CHENCLR_CH15_Disabled = 0x0
	// Read: channel enabled
	PPI_CHENCLR_CH15_Enabled = 0x1
	// Write: disable channel
	PPI_CHENCLR_CH15_Clear = 0x1
	// Position of CH16 field.
	PPI_CHENCLR_CH16_Pos = 0x10
	// Bit mask of CH16 field.
	PPI_CHENCLR_CH16_Msk = 0x10000
	// Bit CH16.
	PPI_CHENCLR_CH16 = 0x10000
	// Read: channel disabled
	PPI_CHENCLR_CH16_Disabled = 0x0
	// Read: channel enabled
	PPI_CHENCLR_CH16_Enabled = 0x1
	// Write: disable channel
	PPI_CHENCLR_CH16_Clear = 0x1
	// Position of CH17 field.
	PPI_CHENCLR_CH17_Pos = 0x11
	// Bit mask of CH17 field.
	PPI_CHENCLR_CH17_Msk = 0x20000
	// Bit CH17.
	PPI_CHENCLR_CH17 = 0x20000
	// Read: channel disabled
	PPI_CHENCLR_CH17_Disabled = 0x0
	// Read: channel enabled
	PPI_CHENCLR_CH17_Enabled = 0x1
	// Write: disable channel
	PPI_CHENCLR_CH17_Clear = 0x1
	// Position of CH18 field.
	PPI_CHENCLR_CH18_Pos = 0x12
	// Bit mask of CH18 field.
	PPI_CHENCLR_CH18_Msk = 0x40000
	// Bit CH18.
	PPI_CHENCLR_CH18 = 0x40000
	// Read: channel disabled
	PPI_CHENCLR_CH18_Disabled = 0x0
	// Read: channel enabled
	PPI_CHENCLR_CH18_Enabled = 0x1
	// Write: disable channel
	PPI_CHENCLR_CH18_Clear = 0x1
	// Position of CH19 field.
	PPI_CHENCLR_CH19_Pos = 0x13
	// Bit mask of CH19 field.
	PPI_CHENCLR_CH19_Msk = 0x80000
	// Bit CH19.
	PPI_CHENCLR_CH19 = 0x80000
	// Read: channel disabled
	PPI_CHENCLR_CH19_Disabled = 0x0
	// Read: channel enabled
	PPI_CHENCLR_CH19_Enabled = 0x1
	// Write: disable channel
	PPI_CHENCLR_CH19_Clear = 0x1
	// Position of CH20 field.
	PPI_CHENCLR_CH20_Pos = 0x14
	// Bit mask of CH20 field.
	PPI_CHENCLR_CH20_Msk = 0x100000
	// Bit CH20.
	PPI_CHENCLR_CH20 = 0x100000
	// Read: channel disabled
	PPI_CHENCLR_CH20_Disabled = 0x0
	// Read: channel enabled
	PPI_CHENCLR_CH20_Enabled = 0x1
	// Write: disable channel
	PPI_CHENCLR_CH20_Clear = 0x1
	// Position of CH21 field.
	PPI_CHENCLR_CH21_Pos = 0x15
	// Bit mask of CH21 field.
	PPI_CHENCLR_CH21_Msk = 0x200000
	// Bit CH21.
	PPI_CHENCLR_CH21 = 0x200000
	// Read: channel disabled
	PPI_CHENCLR_CH21_Disabled = 0x0
	// Read: channel enabled
	PPI_CHENCLR_CH21_Enabled = 0x1
	// Write: disable channel
	PPI_CHENCLR_CH21_Clear = 0x1
	// Position of CH22 field.
	PPI_CHENCLR_CH22_Pos = 0x16
	// Bit mask of CH22 field.
	PPI_CHENCLR_CH22_Msk = 0x400000
	// Bit CH22.
	PPI_CHENCLR_CH22 = 0x400000
	// Read: channel disabled
	PPI_CHENCLR_CH22_Disabled = 0x0
	// Read: channel enabled
	PPI_CHENCLR_CH22_Enabled = 0x1
	// Write: disable channel
	PPI_CHENCLR_CH22_Clear = 0x1
	// Position of CH23 field.
	PPI_CHENCLR_CH23_Pos = 0x17
	// Bit mask of CH23 field.
	PPI_CHENCLR_CH23_Msk = 0x800000
	// Bit CH23.
	PPI_CHENCLR_CH23 = 0x800000
	// Read: channel disabled
	PPI_CHENCLR_CH23_Disabled = 0x0
	// Read: channel enabled
	PPI_CHENCLR_CH23_Enabled = 0x1
	// Write: disable channel
	PPI_CHENCLR_CH23_Clear = 0x1
	// Position of CH24 field.
	PPI_CHENCLR_CH24_Pos = 0x18
	// Bit mask of CH24 field.
	PPI_CHENCLR_CH24_Msk = 0x1000000
	// Bit CH24.
	PPI_CHENCLR_CH24 = 0x1000000
	// Read: channel disabled
	PPI_CHENCLR_CH24_Disabled = 0x0
	// Read: channel enabled
	PPI_CHENCLR_CH24_Enabled = 0x1
	// Write: disable channel
	PPI_CHENCLR_CH24_Clear = 0x1
	// Position of CH25 field.
	PPI_CHENCLR_CH25_Pos = 0x19
	// Bit mask of CH25 field.
	PPI_CHENCLR_CH25_Msk = 0x2000000
	// Bit CH25.
	PPI_CHENCLR_CH25 = 0x2000000
	// Read: channel disabled
	PPI_CHENCLR_CH25_Disabled = 0x0
	// Read: channel enabled
	PPI_CHENCLR_CH25_Enabled = 0x1
	// Write: disable channel
	PPI_CHENCLR_CH25_Clear = 0x1
	// Position of CH26 field.
	PPI_CHENCLR_CH26_Pos = 0x1a
	// Bit mask of CH26 field.
	PPI_CHENCLR_CH26_Msk = 0x4000000
	// Bit CH26.
	PPI_CHENCLR_CH26 = 0x4000000
	// Read: channel disabled
	PPI_CHENCLR_CH26_Disabled = 0x0
	// Read: channel enabled
	PPI_CHENCLR_CH26_Enabled = 0x1
	// Write: disable channel
	PPI_CHENCLR_CH26_Clear = 0x1
	// Position of CH27 field.
	PPI_CHENCLR_CH27_Pos = 0x1b
	// Bit mask of CH27 field.
	PPI_CHENCLR_CH27_Msk = 0x8000000
	// Bit CH27.
	PPI_CHENCLR_CH27 = 0x8000000
	// Read: channel disabled
	PPI_CHENCLR_CH27_Disabled = 0x0
	// Read: channel enabled
	PPI_CHENCLR_CH27_Enabled = 0x1
	// Write: disable channel
	PPI_CHENCLR_CH27_Clear = 0x1
	// Position of CH28 field.
	PPI_CHENCLR_CH28_Pos = 0x1c
	// Bit mask of CH28 field.
	PPI_CHENCLR_CH28_Msk = 0x10000000
	// Bit CH28.
	PPI_CHENCLR_CH28 = 0x10000000
	// Read: channel disabled
	PPI_CHENCLR_CH28_Disabled = 0x0
	// Read: channel enabled
	PPI_CHENCLR_CH28_Enabled = 0x1
	// Write: disable channel
	PPI_CHENCLR_CH28_Clear = 0x1
	// Position of CH29 field.
	PPI_CHENCLR_CH29_Pos = 0x1d
	// Bit mask of CH29 field.
	PPI_CHENCLR_CH29_Msk = 0x20000000
	// Bit CH29.
	PPI_CHENCLR_CH29 = 0x20000000
	// Read: channel disabled
	PPI_CHENCLR_CH29_Disabled = 0x0
	// Read: channel enabled
	PPI_CHENCLR_CH29_Enabled = 0x1
	// Write: disable channel
	PPI_CHENCLR_CH29_Clear = 0x1
	// Position of CH30 field.
	PPI_CHENCLR_CH30_Pos = 0x1e
	// Bit mask of CH30 field.
	PPI_CHENCLR_CH30_Msk = 0x40000000
	// Bit CH30.
	PPI_CHENCLR_CH30 = 0x40000000
	// Read: channel disabled
	PPI_CHENCLR_CH30_Disabled = 0x0
	// Read: channel enabled
	PPI_CHENCLR_CH30_Enabled = 0x1
	// Write: disable channel
	PPI_CHENCLR_CH30_Clear = 0x1
	// Position of CH31 field.
	PPI_CHENCLR_CH31_Pos = 0x1f
	// Bit mask of CH31 field.
	PPI_CHENCLR_CH31_Msk = 0x80000000
	// Bit CH31.
	PPI_CHENCLR_CH31 = 0x80000000
	// Read: channel disabled
	PPI_CHENCLR_CH31_Disabled = 0x0
	// Read: channel enabled
	PPI_CHENCLR_CH31_Enabled = 0x1
	// Write: disable channel
	PPI_CHENCLR_CH31_Clear = 0x1

	// CH.EEP: Description cluster: Channel n event end-point
	// Position of EEP field.
	PPI_CH_EEP_EEP_Pos = 0x0
	// Bit mask of EEP field.
	PPI_CH_EEP_EEP_Msk = 0xffffffff

	// CH.TEP: Description cluster: Channel n task end-point
	// Position of TEP field.
	PPI_CH_TEP_TEP_Pos = 0x0
	// Bit mask of TEP field.
	PPI_CH_TEP_TEP_Msk = 0xffffffff

	// CHG: Description collection: Channel group n
	// Position of CH0 field.
	PPI_CHG_CH0_Pos = 0x0
	// Bit mask of CH0 field.
	PPI_CHG_CH0_Msk = 0x1
	// Bit CH0.
	PPI_CHG_CH0 = 0x1
	// Exclude
	PPI_CHG_CH0_Excluded = 0x0
	// Include
	PPI_CHG_CH0_Included = 0x1
	// Position of CH1 field.
	PPI_CHG_CH1_Pos = 0x1
	// Bit mask of CH1 field.
	PPI_CHG_CH1_Msk = 0x2
	// Bit CH1.
	PPI_CHG_CH1 = 0x2
	// Exclude
	PPI_CHG_CH1_Excluded = 0x0
	// Include
	PPI_CHG_CH1_Included = 0x1
	// Position of CH2 field.
	PPI_CHG_CH2_Pos = 0x2
	// Bit mask of CH2 field.
	PPI_CHG_CH2_Msk = 0x4
	// Bit CH2.
	PPI_CHG_CH2 = 0x4
	// Exclude
	PPI_CHG_CH2_Excluded = 0x0
	// Include
	PPI_CHG_CH2_Included = 0x1
	// Position of CH3 field.
	PPI_CHG_CH3_Pos = 0x3
	// Bit mask of CH3 field.
	PPI_CHG_CH3_Msk = 0x8
	// Bit CH3.
	PPI_CHG_CH3 = 0x8
	// Exclude
	PPI_CHG_CH3_Excluded = 0x0
	// Include
	PPI_CHG_CH3_Included = 0x1
	// Position of CH4 field.
	PPI_CHG_CH4_Pos = 0x4
	// Bit mask of CH4 field.
	PPI_CHG_CH4_Msk = 0x10
	// Bit CH4.
	PPI_CHG_CH4 = 0x10
	// Exclude
	PPI_CHG_CH4_Excluded = 0x0
	// Include
	PPI_CHG_CH4_Included = 0x1
	// Position of CH5 field.
	PPI_CHG_CH5_Pos = 0x5
	// Bit mask of CH5 field.
	PPI_CHG_CH5_Msk = 0x20
	// Bit CH5.
	PPI_CHG_CH5 = 0x20
	// Exclude
	PPI_CHG_CH5_Excluded = 0x0
	// Include
	PPI_CHG_CH5_Included = 0x1
	// Position of CH6 field.
	PPI_CHG_CH6_Pos = 0x6
	// Bit mask of CH6 field.
	PPI_CHG_CH6_Msk = 0x40
	// Bit CH6.
	PPI_CHG_CH6 = 0x40
	// Exclude
	PPI_CHG_CH6_Excluded = 0x0
	// Include
	PPI_CHG_CH6_Included = 0x1
	// Position of CH7 field.
	PPI_CHG_CH7_Pos = 0x7
	// Bit mask of CH7 field.
	PPI_CHG_CH7_Msk = 0x80
	// Bit CH7.
	PPI_CHG_CH7 = 0x80
	// Exclude
	PPI_CHG_CH7_Excluded = 0x0
	// Include
	PPI_CHG_CH7_Included = 0x1
	// Position of CH8 field.
	PPI_CHG_CH8_Pos = 0x8
	// Bit mask of CH8 field.
	PPI_CHG_CH8_Msk = 0x100
	// Bit CH8.
	PPI_CHG_CH8 = 0x100
	// Exclude
	PPI_CHG_CH8_Excluded = 0x0
	// Include
	PPI_CHG_CH8_Included = 0x1
	// Position of CH9 field.
	PPI_CHG_CH9_Pos = 0x9
	// Bit mask of CH9 field.
	PPI_CHG_CH9_Msk = 0x200
	// Bit CH9.
	PPI_CHG_CH9 = 0x200
	// Exclude
	PPI_CHG_CH9_Excluded = 0x0
	// Include
	PPI_CHG_CH9_Included = 0x1
	// Position of CH10 field.
	PPI_CHG_CH10_Pos = 0xa
	// Bit mask of CH10 field.
	PPI_CHG_CH10_Msk = 0x400
	// Bit CH10.
	PPI_CHG_CH10 = 0x400
	// Exclude
	PPI_CHG_CH10_Excluded = 0x0
	// Include
	PPI_CHG_CH10_Included = 0x1
	// Position of CH11 field.
	PPI_CHG_CH11_Pos = 0xb
	// Bit mask of CH11 field.
	PPI_CHG_CH11_Msk = 0x800
	// Bit CH11.
	PPI_CHG_CH11 = 0x800
	// Exclude
	PPI_CHG_CH11_Excluded = 0x0
	// Include
	PPI_CHG_CH11_Included = 0x1
	// Position of CH12 field.
	PPI_CHG_CH12_Pos = 0xc
	// Bit mask of CH12 field.
	PPI_CHG_CH12_Msk = 0x1000
	// Bit CH12.
	PPI_CHG_CH12 = 0x1000
	// Exclude
	PPI_CHG_CH12_Excluded = 0x0
	// Include
	PPI_CHG_CH12_Included = 0x1
	// Position of CH13 field.
	PPI_CHG_CH13_Pos = 0xd
	// Bit mask of CH13 field.
	PPI_CHG_CH13_Msk = 0x2000
	// Bit CH13.
	PPI_CHG_CH13 = 0x2000
	// Exclude
	PPI_CHG_CH13_Excluded = 0x0
	// Include
	PPI_CHG_CH13_Included = 0x1
	// Position of CH14 field.
	PPI_CHG_CH14_Pos = 0xe
	// Bit mask of CH14 field.
	PPI_CHG_CH14_Msk = 0x4000
	// Bit CH14.
	PPI_CHG_CH14 = 0x4000
	// Exclude
	PPI_CHG_CH14_Excluded = 0x0
	// Include
	PPI_CHG_CH14_Included = 0x1
	// Position of CH15 field.
	PPI_CHG_CH15_Pos = 0xf
	// Bit mask of CH15 field.
	PPI_CHG_CH15_Msk = 0x8000
	// Bit CH15.
	PPI_CHG_CH15 = 0x8000
	// Exclude
	PPI_CHG_CH15_Excluded = 0x0
	// Include
	PPI_CHG_CH15_Included = 0x1
	// Position of CH16 field.
	PPI_CHG_CH16_Pos = 0x10
	// Bit mask of CH16 field.
	PPI_CHG_CH16_Msk = 0x10000
	// Bit CH16.
	PPI_CHG_CH16 = 0x10000
	// Exclude
	PPI_CHG_CH16_Excluded = 0x0
	// Include
	PPI_CHG_CH16_Included = 0x1
	// Position of CH17 field.
	PPI_CHG_CH17_Pos = 0x11
	// Bit mask of CH17 field.
	PPI_CHG_CH17_Msk = 0x20000
	// Bit CH17.
	PPI_CHG_CH17 = 0x20000
	// Exclude
	PPI_CHG_CH17_Excluded = 0x0
	// Include
	PPI_CHG_CH17_Included = 0x1
	// Position of CH18 field.
	PPI_CHG_CH18_Pos = 0x12
	// Bit mask of CH18 field.
	PPI_CHG_CH18_Msk = 0x40000
	// Bit CH18.
	PPI_CHG_CH18 = 0x40000
	// Exclude
	PPI_CHG_CH18_Excluded = 0x0
	// Include
	PPI_CHG_CH18_Included = 0x1
	// Position of CH19 field.
	PPI_CHG_CH19_Pos = 0x13
	// Bit mask of CH19 field.
	PPI_CHG_CH19_Msk = 0x80000
	// Bit CH19.
	PPI_CHG_CH19 = 0x80000
	// Exclude
	PPI_CHG_CH19_Excluded = 0x0
	// Include
	PPI_CHG_CH19_Included = 0x1
	// Position of CH20 field.
	PPI_CHG_CH20_Pos = 0x14
	// Bit mask of CH20 field.
	PPI_CHG_CH20_Msk = 0x100000
	// Bit CH20.
	PPI_CHG_CH20 = 0x100000
	// Exclude
	PPI_CHG_CH20_Excluded = 0x0
	// Include
	PPI_CHG_CH20_Included = 0x1
	// Position of CH21 field.
	PPI_CHG_CH21_Pos = 0x15
	// Bit mask of CH21 field.
	PPI_CHG_CH21_Msk = 0x200000
	// Bit CH21.
	PPI_CHG_CH21 = 0x200000
	// Exclude
	PPI_CHG_CH21_Excluded = 0x0
	// Include
	PPI_CHG_CH21_Included = 0x1
	// Position of CH22 field.
	PPI_CHG_CH22_Pos = 0x16
	// Bit mask of CH22 field.
	PPI_CHG_CH22_Msk = 0x400000
	// Bit CH22.
	PPI_CHG_CH22 = 0x400000
	// Exclude
	PPI_CHG_CH22_Excluded = 0x0
	// Include
	PPI_CHG_CH22_Included = 0x1
	// Position of CH23 field.
	PPI_CHG_CH23_Pos = 0x17
	// Bit mask of CH23 field.
	PPI_CHG_CH23_Msk = 0x800000
	// Bit CH23.
	PPI_CHG_CH23 = 0x800000
	// Exclude
	PPI_CHG_CH23_Excluded = 0x0
	// Include
	PPI_CHG_CH23_Included = 0x1
	// Position of CH24 field.
	PPI_CHG_CH24_Pos = 0x18
	// Bit mask of CH24 field.
	PPI_CHG_CH24_Msk = 0x1000000
	// Bit CH24.
	PPI_CHG_CH24 = 0x1000000
	// Exclude
	PPI_CHG_CH24_Excluded = 0x0
	// Include
	PPI_CHG_CH24_Included = 0x1
	// Position of CH25 field.
	PPI_CHG_CH25_Pos = 0x19
	// Bit mask of CH25 field.
	PPI_CHG_CH25_Msk = 0x2000000
	// Bit CH25.
	PPI_CHG_CH25 = 0x2000000
	// Exclude
	PPI_CHG_CH25_Excluded = 0x0
	// Include
	PPI_CHG_CH25_Included = 0x1
	// Position of CH26 field.
	PPI_CHG_CH26_Pos = 0x1a
	// Bit mask of CH26 field.
	PPI_CHG_CH26_Msk = 0x4000000
	// Bit CH26.
	PPI_CHG_CH26 = 0x4000000
	// Exclude
	PPI_CHG_CH26_Excluded = 0x0
	// Include
	PPI_CHG_CH26_Included = 0x1
	// Position of CH27 field.
	PPI_CHG_CH27_Pos = 0x1b
	// Bit mask of CH27 field.
	PPI_CHG_CH27_Msk = 0x8000000
	// Bit CH27.
	PPI_CHG_CH27 = 0x8000000
	// Exclude
	PPI_CHG_CH27_Excluded = 0x0
	// Include
	PPI_CHG_CH27_Included = 0x1
	// Position of CH28 field.
	PPI_CHG_CH28_Pos = 0x1c
	// Bit mask of CH28 field.
	PPI_CHG_CH28_Msk = 0x10000000
	// Bit CH28.
	PPI_CHG_CH28 = 0x10000000
	// Exclude
	PPI_CHG_CH28_Excluded = 0x0
	// Include
	PPI_CHG_CH28_Included = 0x1
	// Position of CH29 field.
	PPI_CHG_CH29_Pos = 0x1d
	// Bit mask of CH29 field.
	PPI_CHG_CH29_Msk = 0x20000000
	// Bit CH29.
	PPI_CHG_CH29 = 0x20000000
	// Exclude
	PPI_CHG_CH29_Excluded = 0x0
	// Include
	PPI_CHG_CH29_Included = 0x1
	// Position of CH30 field.
	PPI_CHG_CH30_Pos = 0x1e
	// Bit mask of CH30 field.
	PPI_CHG_CH30_Msk = 0x40000000
	// Bit CH30.
	PPI_CHG_CH30 = 0x40000000
	// Exclude
	PPI_CHG_CH30_Excluded = 0x0
	// Include
	PPI_CHG_CH30_Included = 0x1
	// Position of CH31 field.
	PPI_CHG_CH31_Pos = 0x1f
	// Bit mask of CH31 field.
	PPI_CHG_CH31_Msk = 0x80000000
	// Bit CH31.
	PPI_CHG_CH31 = 0x80000000
	// Exclude
	PPI_CHG_CH31_Excluded = 0x0
	// Include
	PPI_CHG_CH31_Included = 0x1

	// FORK.TEP: Description cluster: Channel n task end-point
	// Position of TEP field.
	PPI_FORK_TEP_TEP_Pos = 0x0
	// Bit mask of TEP field.
	PPI_FORK_TEP_TEP_Msk = 0xffffffff
)

// Bitfields for MWU: Memory Watch Unit
const (
	// EVENTS_REGION.WA: Description cluster: Write access to region n detected
	// Position of WA field.
	MWU_EVENTS_REGION_WA_WA_Pos = 0x0
	// Bit mask of WA field.
	MWU_EVENTS_REGION_WA_WA_Msk = 0x1
	// Bit WA.
	MWU_EVENTS_REGION_WA_WA = 0x1
	// Event not generated
	MWU_EVENTS_REGION_WA_WA_NotGenerated = 0x0
	// Event generated
	MWU_EVENTS_REGION_WA_WA_Generated = 0x1

	// EVENTS_REGION.RA: Description cluster: Read access to region n detected
	// Position of RA field.
	MWU_EVENTS_REGION_RA_RA_Pos = 0x0
	// Bit mask of RA field.
	MWU_EVENTS_REGION_RA_RA_Msk = 0x1
	// Bit RA.
	MWU_EVENTS_REGION_RA_RA = 0x1
	// Event not generated
	MWU_EVENTS_REGION_RA_RA_NotGenerated = 0x0
	// Event generated
	MWU_EVENTS_REGION_RA_RA_Generated = 0x1

	// EVENTS_PREGION.WA: Description cluster: Write access to peripheral region n detected
	// Position of WA field.
	MWU_EVENTS_PREGION_WA_WA_Pos = 0x0
	// Bit mask of WA field.
	MWU_EVENTS_PREGION_WA_WA_Msk = 0x1
	// Bit WA.
	MWU_EVENTS_PREGION_WA_WA = 0x1
	// Event not generated
	MWU_EVENTS_PREGION_WA_WA_NotGenerated = 0x0
	// Event generated
	MWU_EVENTS_PREGION_WA_WA_Generated = 0x1

	// EVENTS_PREGION.RA: Description cluster: Read access to peripheral region n detected
	// Position of RA field.
	MWU_EVENTS_PREGION_RA_RA_Pos = 0x0
	// Bit mask of RA field.
	MWU_EVENTS_PREGION_RA_RA_Msk = 0x1
	// Bit RA.
	MWU_EVENTS_PREGION_RA_RA = 0x1
	// Event not generated
	MWU_EVENTS_PREGION_RA_RA_NotGenerated = 0x0
	// Event generated
	MWU_EVENTS_PREGION_RA_RA_Generated = 0x1

	// INTEN: Enable or disable interrupt
	// Position of REGION0WA field.
	MWU_INTEN_REGION0WA_Pos = 0x0
	// Bit mask of REGION0WA field.
	MWU_INTEN_REGION0WA_Msk = 0x1
	// Bit REGION0WA.
	MWU_INTEN_REGION0WA = 0x1
	// Disable
	MWU_INTEN_REGION0WA_Disabled = 0x0
	// Enable
	MWU_INTEN_REGION0WA_Enabled = 0x1
	// Position of REGION0RA field.
	MWU_INTEN_REGION0RA_Pos = 0x1
	// Bit mask of REGION0RA field.
	MWU_INTEN_REGION0RA_Msk = 0x2
	// Bit REGION0RA.
	MWU_INTEN_REGION0RA = 0x2
	// Disable
	MWU_INTEN_REGION0RA_Disabled = 0x0
	// Enable
	MWU_INTEN_REGION0RA_Enabled = 0x1
	// Position of REGION1WA field.
	MWU_INTEN_REGION1WA_Pos = 0x2
	// Bit mask of REGION1WA field.
	MWU_INTEN_REGION1WA_Msk = 0x4
	// Bit REGION1WA.
	MWU_INTEN_REGION1WA = 0x4
	// Disable
	MWU_INTEN_REGION1WA_Disabled = 0x0
	// Enable
	MWU_INTEN_REGION1WA_Enabled = 0x1
	// Position of REGION1RA field.
	MWU_INTEN_REGION1RA_Pos = 0x3
	// Bit mask of REGION1RA field.
	MWU_INTEN_REGION1RA_Msk = 0x8
	// Bit REGION1RA.
	MWU_INTEN_REGION1RA = 0x8
	// Disable
	MWU_INTEN_REGION1RA_Disabled = 0x0
	// Enable
	MWU_INTEN_REGION1RA_Enabled = 0x1
	// Position of REGION2WA field.
	MWU_INTEN_REGION2WA_Pos = 0x4
	// Bit mask of REGION2WA field.
	MWU_INTEN_REGION2WA_Msk = 0x10
	// Bit REGION2WA.
	MWU_INTEN_REGION2WA = 0x10
	// Disable
	MWU_INTEN_REGION2WA_Disabled = 0x0
	// Enable
	MWU_INTEN_REGION2WA_Enabled = 0x1
	// Position of REGION2RA field.
	MWU_INTEN_REGION2RA_Pos = 0x5
	// Bit mask of REGION2RA field.
	MWU_INTEN_REGION2RA_Msk = 0x20
	// Bit REGION2RA.
	MWU_INTEN_REGION2RA = 0x20
	// Disable
	MWU_INTEN_REGION2RA_Disabled = 0x0
	// Enable
	MWU_INTEN_REGION2RA_Enabled = 0x1
	// Position of REGION3WA field.
	MWU_INTEN_REGION3WA_Pos = 0x6
	// Bit mask of REGION3WA field.
	MWU_INTEN_REGION3WA_Msk = 0x40
	// Bit REGION3WA.
	MWU_INTEN_REGION3WA = 0x40
	// Disable
	MWU_INTEN_REGION3WA_Disabled = 0x0
	// Enable
	MWU_INTEN_REGION3WA_Enabled = 0x1
	// Position of REGION3RA field.
	MWU_INTEN_REGION3RA_Pos = 0x7
	// Bit mask of REGION3RA field.
	MWU_INTEN_REGION3RA_Msk = 0x80
	// Bit REGION3RA.
	MWU_INTEN_REGION3RA = 0x80
	// Disable
	MWU_INTEN_REGION3RA_Disabled = 0x0
	// Enable
	MWU_INTEN_REGION3RA_Enabled = 0x1
	// Position of PREGION0WA field.
	MWU_INTEN_PREGION0WA_Pos = 0x18
	// Bit mask of PREGION0WA field.
	MWU_INTEN_PREGION0WA_Msk = 0x1000000
	// Bit PREGION0WA.
	MWU_INTEN_PREGION0WA = 0x1000000
	// Disable
	MWU_INTEN_PREGION0WA_Disabled = 0x0
	// Enable
	MWU_INTEN_PREGION0WA_Enabled = 0x1
	// Position of PREGION0RA field.
	MWU_INTEN_PREGION0RA_Pos = 0x19
	// Bit mask of PREGION0RA field.
	MWU_INTEN_PREGION0RA_Msk = 0x2000000
	// Bit PREGION0RA.
	MWU_INTEN_PREGION0RA = 0x2000000
	// Disable
	MWU_INTEN_PREGION0RA_Disabled = 0x0
	// Enable
	MWU_INTEN_PREGION0RA_Enabled = 0x1
	// Position of PREGION1WA field.
	MWU_INTEN_PREGION1WA_Pos = 0x1a
	// Bit mask of PREGION1WA field.
	MWU_INTEN_PREGION1WA_Msk = 0x4000000
	// Bit PREGION1WA.
	MWU_INTEN_PREGION1WA = 0x4000000
	// Disable
	MWU_INTEN_PREGION1WA_Disabled = 0x0
	// Enable
	MWU_INTEN_PREGION1WA_Enabled = 0x1
	// Position of PREGION1RA field.
	MWU_INTEN_PREGION1RA_Pos = 0x1b
	// Bit mask of PREGION1RA field.
	MWU_INTEN_PREGION1RA_Msk = 0x8000000
	// Bit PREGION1RA.
	MWU_INTEN_PREGION1RA = 0x8000000
	// Disable
	MWU_INTEN_PREGION1RA_Disabled = 0x0
	// Enable
	MWU_INTEN_PREGION1RA_Enabled = 0x1

	// INTENSET: Enable interrupt
	// Position of REGION0WA field.
	MWU_INTENSET_REGION0WA_Pos = 0x0
	// Bit mask of REGION0WA field.
	MWU_INTENSET_REGION0WA_Msk = 0x1
	// Bit REGION0WA.
	MWU_INTENSET_REGION0WA = 0x1
	// Read: Disabled
	MWU_INTENSET_REGION0WA_Disabled = 0x0
	// Read: Enabled
	MWU_INTENSET_REGION0WA_Enabled = 0x1
	// Enable
	MWU_INTENSET_REGION0WA_Set = 0x1
	// Position of REGION0RA field.
	MWU_INTENSET_REGION0RA_Pos = 0x1
	// Bit mask of REGION0RA field.
	MWU_INTENSET_REGION0RA_Msk = 0x2
	// Bit REGION0RA.
	MWU_INTENSET_REGION0RA = 0x2
	// Read: Disabled
	MWU_INTENSET_REGION0RA_Disabled = 0x0
	// Read: Enabled
	MWU_INTENSET_REGION0RA_Enabled = 0x1
	// Enable
	MWU_INTENSET_REGION0RA_Set = 0x1
	// Position of REGION1WA field.
	MWU_INTENSET_REGION1WA_Pos = 0x2
	// Bit mask of REGION1WA field.
	MWU_INTENSET_REGION1WA_Msk = 0x4
	// Bit REGION1WA.
	MWU_INTENSET_REGION1WA = 0x4
	// Read: Disabled
	MWU_INTENSET_REGION1WA_Disabled = 0x0
	// Read: Enabled
	MWU_INTENSET_REGION1WA_Enabled = 0x1
	// Enable
	MWU_INTENSET_REGION1WA_Set = 0x1
	// Position of REGION1RA field.
	MWU_INTENSET_REGION1RA_Pos = 0x3
	// Bit mask of REGION1RA field.
	MWU_INTENSET_REGION1RA_Msk = 0x8
	// Bit REGION1RA.
	MWU_INTENSET_REGION1RA = 0x8
	// Read: Disabled
	MWU_INTENSET_REGION1RA_Disabled = 0x0
	// Read: Enabled
	MWU_INTENSET_REGION1RA_Enabled = 0x1
	// Enable
	MWU_INTENSET_REGION1RA_Set = 0x1
	// Position of REGION2WA field.
	MWU_INTENSET_REGION2WA_Pos = 0x4
	// Bit mask of REGION2WA field.
	MWU_INTENSET_REGION2WA_Msk = 0x10
	// Bit REGION2WA.
	MWU_INTENSET_REGION2WA = 0x10
	// Read: Disabled
	MWU_INTENSET_REGION2WA_Disabled = 0x0
	// Read: Enabled
	MWU_INTENSET_REGION2WA_Enabled = 0x1
	// Enable
	MWU_INTENSET_REGION2WA_Set = 0x1
	// Position of REGION2RA field.
	MWU_INTENSET_REGION2RA_Pos = 0x5
	// Bit mask of REGION2RA field.
	MWU_INTENSET_REGION2RA_Msk = 0x20
	// Bit REGION2RA.
	MWU_INTENSET_REGION2RA = 0x20
	// Read: Disabled
	MWU_INTENSET_REGION2RA_Disabled = 0x0
	// Read: Enabled
	MWU_INTENSET_REGION2RA_Enabled = 0x1
	// Enable
	MWU_INTENSET_REGION2RA_Set = 0x1
	// Position of REGION3WA field.
	MWU_INTENSET_REGION3WA_Pos = 0x6
	// Bit mask of REGION3WA field.
	MWU_INTENSET_REGION3WA_Msk = 0x40
	// Bit REGION3WA.
	MWU_INTENSET_REGION3WA = 0x40
	// Read: Disabled
	MWU_INTENSET_REGION3WA_Disabled = 0x0
	// Read: Enabled
	MWU_INTENSET_REGION3WA_Enabled = 0x1
	// Enable
	MWU_INTENSET_REGION3WA_Set = 0x1
	// Position of REGION3RA field.
	MWU_INTENSET_REGION3RA_Pos = 0x7
	// Bit mask of REGION3RA field.
	MWU_INTENSET_REGION3RA_Msk = 0x80
	// Bit REGION3RA.
	MWU_INTENSET_REGION3RA = 0x80
	// Read: Disabled
	MWU_INTENSET_REGION3RA_Disabled = 0x0
	// Read: Enabled
	MWU_INTENSET_REGION3RA_Enabled = 0x1
	// Enable
	MWU_INTENSET_REGION3RA_Set = 0x1
	// Position of PREGION0WA field.
	MWU_INTENSET_PREGION0WA_Pos = 0x18
	// Bit mask of PREGION0WA field.
	MWU_INTENSET_PREGION0WA_Msk = 0x1000000
	// Bit PREGION0WA.
	MWU_INTENSET_PREGION0WA = 0x1000000
	// Read: Disabled
	MWU_INTENSET_PREGION0WA_Disabled = 0x0
	// Read: Enabled
	MWU_INTENSET_PREGION0WA_Enabled = 0x1
	// Enable
	MWU_INTENSET_PREGION0WA_Set = 0x1
	// Position of PREGION0RA field.
	MWU_INTENSET_PREGION0RA_Pos = 0x19
	// Bit mask of PREGION0RA field.
	MWU_INTENSET_PREGION0RA_Msk = 0x2000000
	// Bit PREGION0RA.
	MWU_INTENSET_PREGION0RA = 0x2000000
	// Read: Disabled
	MWU_INTENSET_PREGION0RA_Disabled = 0x0
	// Read: Enabled
	MWU_INTENSET_PREGION0RA_Enabled = 0x1
	// Enable
	MWU_INTENSET_PREGION0RA_Set = 0x1
	// Position of PREGION1WA field.
	MWU_INTENSET_PREGION1WA_Pos = 0x1a
	// Bit mask of PREGION1WA field.
	MWU_INTENSET_PREGION1WA_Msk = 0x4000000
	// Bit PREGION1WA.
	MWU_INTENSET_PREGION1WA = 0x4000000
	// Read: Disabled
	MWU_INTENSET_PREGION1WA_Disabled = 0x0
	// Read: Enabled
	MWU_INTENSET_PREGION1WA_Enabled = 0x1
	// Enable
	MWU_INTENSET_PREGION1WA_Set = 0x1
	// Position of PREGION1RA field.
	MWU_INTENSET_PREGION1RA_Pos = 0x1b
	// Bit mask of PREGION1RA field.
	MWU_INTENSET_PREGION1RA_Msk = 0x8000000
	// Bit PREGION1RA.
	MWU_INTENSET_PREGION1RA = 0x8000000
	// Read: Disabled
	MWU_INTENSET_PREGION1RA_Disabled = 0x0
	// Read: Enabled
	MWU_INTENSET_PREGION1RA_Enabled = 0x1
	// Enable
	MWU_INTENSET_PREGION1RA_Set = 0x1

	// INTENCLR: Disable interrupt
	// Position of REGION0WA field.
	MWU_INTENCLR_REGION0WA_Pos = 0x0
	// Bit mask of REGION0WA field.
	MWU_INTENCLR_REGION0WA_Msk = 0x1
	// Bit REGION0WA.
	MWU_INTENCLR_REGION0WA = 0x1
	// Read: Disabled
	MWU_INTENCLR_REGION0WA_Disabled = 0x0
	// Read: Enabled
	MWU_INTENCLR_REGION0WA_Enabled = 0x1
	// Disable
	MWU_INTENCLR_REGION0WA_Clear = 0x1
	// Position of REGION0RA field.
	MWU_INTENCLR_REGION0RA_Pos = 0x1
	// Bit mask of REGION0RA field.
	MWU_INTENCLR_REGION0RA_Msk = 0x2
	// Bit REGION0RA.
	MWU_INTENCLR_REGION0RA = 0x2
	// Read: Disabled
	MWU_INTENCLR_REGION0RA_Disabled = 0x0
	// Read: Enabled
	MWU_INTENCLR_REGION0RA_Enabled = 0x1
	// Disable
	MWU_INTENCLR_REGION0RA_Clear = 0x1
	// Position of REGION1WA field.
	MWU_INTENCLR_REGION1WA_Pos = 0x2
	// Bit mask of REGION1WA field.
	MWU_INTENCLR_REGION1WA_Msk = 0x4
	// Bit REGION1WA.
	MWU_INTENCLR_REGION1WA = 0x4
	// Read: Disabled
	MWU_INTENCLR_REGION1WA_Disabled = 0x0
	// Read: Enabled
	MWU_INTENCLR_REGION1WA_Enabled = 0x1
	// Disable
	MWU_INTENCLR_REGION1WA_Clear = 0x1
	// Position of REGION1RA field.
	MWU_INTENCLR_REGION1RA_Pos = 0x3
	// Bit mask of REGION1RA field.
	MWU_INTENCLR_REGION1RA_Msk = 0x8
	// Bit REGION1RA.
	MWU_INTENCLR_REGION1RA = 0x8
	// Read: Disabled
	MWU_INTENCLR_REGION1RA_Disabled = 0x0
	// Read: Enabled
	MWU_INTENCLR_REGION1RA_Enabled = 0x1
	// Disable
	MWU_INTENCLR_REGION1RA_Clear = 0x1
	// Position of REGION2WA field.
	MWU_INTENCLR_REGION2WA_Pos = 0x4
	// Bit mask of REGION2WA field.
	MWU_INTENCLR_REGION2WA_Msk = 0x10
	// Bit REGION2WA.
	MWU_INTENCLR_REGION2WA = 0x10
	// Read: Disabled
	MWU_INTENCLR_REGION2WA_Disabled = 0x0
	// Read: Enabled
	MWU_INTENCLR_REGION2WA_Enabled = 0x1
	// Disable
	MWU_INTENCLR_REGION2WA_Clear = 0x1
	// Position of REGION2RA field.
	MWU_INTENCLR_REGION2RA_Pos = 0x5
	// Bit mask of REGION2RA field.
	MWU_INTENCLR_REGION2RA_Msk = 0x20
	// Bit REGION2RA.
	MWU_INTENCLR_REGION2RA = 0x20
	// Read: Disabled
	MWU_INTENCLR_REGION2RA_Disabled = 0x0
	// Read: Enabled
	MWU_INTENCLR_REGION2RA_Enabled = 0x1
	// Disable
	MWU_INTENCLR_REGION2RA_Clear = 0x1
	// Position of REGION3WA field.
	MWU_INTENCLR_REGION3WA_Pos = 0x6
	// Bit mask of REGION3WA field.
	MWU_INTENCLR_REGION3WA_Msk = 0x40
	// Bit REGION3WA.
	MWU_INTENCLR_REGION3WA = 0x40
	// Read: Disabled
	MWU_INTENCLR_REGION3WA_Disabled = 0x0
	// Read: Enabled
	MWU_INTENCLR_REGION3WA_Enabled = 0x1
	// Disable
	MWU_INTENCLR_REGION3WA_Clear = 0x1
	// Position of REGION3RA field.
	MWU_INTENCLR_REGION3RA_Pos = 0x7
	// Bit mask of REGION3RA field.
	MWU_INTENCLR_REGION3RA_Msk = 0x80
	// Bit REGION3RA.
	MWU_INTENCLR_REGION3RA = 0x80
	// Read: Disabled
	MWU_INTENCLR_REGION3RA_Disabled = 0x0
	// Read: Enabled
	MWU_INTENCLR_REGION3RA_Enabled = 0x1
	// Disable
	MWU_INTENCLR_REGION3RA_Clear = 0x1
	// Position of PREGION0WA field.
	MWU_INTENCLR_PREGION0WA_Pos = 0x18
	// Bit mask of PREGION0WA field.
	MWU_INTENCLR_PREGION0WA_Msk = 0x1000000
	// Bit PREGION0WA.
	MWU_INTENCLR_PREGION0WA = 0x1000000
	// Read: Disabled
	MWU_INTENCLR_PREGION0WA_Disabled = 0x0
	// Read: Enabled
	MWU_INTENCLR_PREGION0WA_Enabled = 0x1
	// Disable
	MWU_INTENCLR_PREGION0WA_Clear = 0x1
	// Position of PREGION0RA field.
	MWU_INTENCLR_PREGION0RA_Pos = 0x19
	// Bit mask of PREGION0RA field.
	MWU_INTENCLR_PREGION0RA_Msk = 0x2000000
	// Bit PREGION0RA.
	MWU_INTENCLR_PREGION0RA = 0x2000000
	// Read: Disabled
	MWU_INTENCLR_PREGION0RA_Disabled = 0x0
	// Read: Enabled
	MWU_INTENCLR_PREGION0RA_Enabled = 0x1
	// Disable
	MWU_INTENCLR_PREGION0RA_Clear = 0x1
	// Position of PREGION1WA field.
	MWU_INTENCLR_PREGION1WA_Pos = 0x1a
	// Bit mask of PREGION1WA field.
	MWU_INTENCLR_PREGION1WA_Msk = 0x4000000
	// Bit PREGION1WA.
	MWU_INTENCLR_PREGION1WA = 0x4000000
	// Read: Disabled
	MWU_INTENCLR_PREGION1WA_Disabled = 0x0
	// Read: Enabled
	MWU_INTENCLR_PREGION1WA_Enabled = 0x1
	// Disable
	MWU_INTENCLR_PREGION1WA_Clear = 0x1
	// Position of PREGION1RA field.
	MWU_INTENCLR_PREGION1RA_Pos = 0x1b
	// Bit mask of PREGION1RA field.
	MWU_INTENCLR_PREGION1RA_Msk = 0x8000000
	// Bit PREGION1RA.
	MWU_INTENCLR_PREGION1RA = 0x8000000
	// Read: Disabled
	MWU_INTENCLR_PREGION1RA_Disabled = 0x0
	// Read: Enabled
	MWU_INTENCLR_PREGION1RA_Enabled = 0x1
	// Disable
	MWU_INTENCLR_PREGION1RA_Clear = 0x1

	// NMIEN: Enable or disable interrupt
	// Position of REGION0WA field.
	MWU_NMIEN_REGION0WA_Pos = 0x0
	// Bit mask of REGION0WA field.
	MWU_NMIEN_REGION0WA_Msk = 0x1
	// Bit REGION0WA.
	MWU_NMIEN_REGION0WA = 0x1
	// Disable
	MWU_NMIEN_REGION0WA_Disabled = 0x0
	// Enable
	MWU_NMIEN_REGION0WA_Enabled = 0x1
	// Position of REGION0RA field.
	MWU_NMIEN_REGION0RA_Pos = 0x1
	// Bit mask of REGION0RA field.
	MWU_NMIEN_REGION0RA_Msk = 0x2
	// Bit REGION0RA.
	MWU_NMIEN_REGION0RA = 0x2
	// Disable
	MWU_NMIEN_REGION0RA_Disabled = 0x0
	// Enable
	MWU_NMIEN_REGION0RA_Enabled = 0x1
	// Position of REGION1WA field.
	MWU_NMIEN_REGION1WA_Pos = 0x2
	// Bit mask of REGION1WA field.
	MWU_NMIEN_REGION1WA_Msk = 0x4
	// Bit REGION1WA.
	MWU_NMIEN_REGION1WA = 0x4
	// Disable
	MWU_NMIEN_REGION1WA_Disabled = 0x0
	// Enable
	MWU_NMIEN_REGION1WA_Enabled = 0x1
	// Position of REGION1RA field.
	MWU_NMIEN_REGION1RA_Pos = 0x3
	// Bit mask of REGION1RA field.
	MWU_NMIEN_REGION1RA_Msk = 0x8
	// Bit REGION1RA.
	MWU_NMIEN_REGION1RA = 0x8
	// Disable
	MWU_NMIEN_REGION1RA_Disabled = 0x0
	// Enable
	MWU_NMIEN_REGION1RA_Enabled = 0x1
	// Position of REGION2WA field.
	MWU_NMIEN_REGION2WA_Pos = 0x4
	// Bit mask of REGION2WA field.
	MWU_NMIEN_REGION2WA_Msk = 0x10
	// Bit REGION2WA.
	MWU_NMIEN_REGION2WA = 0x10
	// Disable
	MWU_NMIEN_REGION2WA_Disabled = 0x0
	// Enable
	MWU_NMIEN_REGION2WA_Enabled = 0x1
	// Position of REGION2RA field.
	MWU_NMIEN_REGION2RA_Pos = 0x5
	// Bit mask of REGION2RA field.
	MWU_NMIEN_REGION2RA_Msk = 0x20
	// Bit REGION2RA.
	MWU_NMIEN_REGION2RA = 0x20
	// Disable
	MWU_NMIEN_REGION2RA_Disabled = 0x0
	// Enable
	MWU_NMIEN_REGION2RA_Enabled = 0x1
	// Position of REGION3WA field.
	MWU_NMIEN_REGION3WA_Pos = 0x6
	// Bit mask of REGION3WA field.
	MWU_NMIEN_REGION3WA_Msk = 0x40
	// Bit REGION3WA.
	MWU_NMIEN_REGION3WA = 0x40
	// Disable
	MWU_NMIEN_REGION3WA_Disabled = 0x0
	// Enable
	MWU_NMIEN_REGION3WA_Enabled = 0x1
	// Position of REGION3RA field.
	MWU_NMIEN_REGION3RA_Pos = 0x7
	// Bit mask of REGION3RA field.
	MWU_NMIEN_REGION3RA_Msk = 0x80
	// Bit REGION3RA.
	MWU_NMIEN_REGION3RA = 0x80
	// Disable
	MWU_NMIEN_REGION3RA_Disabled = 0x0
	// Enable
	MWU_NMIEN_REGION3RA_Enabled = 0x1
	// Position of PREGION0WA field.
	MWU_NMIEN_PREGION0WA_Pos = 0x18
	// Bit mask of PREGION0WA field.
	MWU_NMIEN_PREGION0WA_Msk = 0x1000000
	// Bit PREGION0WA.
	MWU_NMIEN_PREGION0WA = 0x1000000
	// Disable
	MWU_NMIEN_PREGION0WA_Disabled = 0x0
	// Enable
	MWU_NMIEN_PREGION0WA_Enabled = 0x1
	// Position of PREGION0RA field.
	MWU_NMIEN_PREGION0RA_Pos = 0x19
	// Bit mask of PREGION0RA field.
	MWU_NMIEN_PREGION0RA_Msk = 0x2000000
	// Bit PREGION0RA.
	MWU_NMIEN_PREGION0RA = 0x2000000
	// Disable
	MWU_NMIEN_PREGION0RA_Disabled = 0x0
	// Enable
	MWU_NMIEN_PREGION0RA_Enabled = 0x1
	// Position of PREGION1WA field.
	MWU_NMIEN_PREGION1WA_Pos = 0x1a
	// Bit mask of PREGION1WA field.
	MWU_NMIEN_PREGION1WA_Msk = 0x4000000
	// Bit PREGION1WA.
	MWU_NMIEN_PREGION1WA = 0x4000000
	// Disable
	MWU_NMIEN_PREGION1WA_Disabled = 0x0
	// Enable
	MWU_NMIEN_PREGION1WA_Enabled = 0x1
	// Position of PREGION1RA field.
	MWU_NMIEN_PREGION1RA_Pos = 0x1b
	// Bit mask of PREGION1RA field.
	MWU_NMIEN_PREGION1RA_Msk = 0x8000000
	// Bit PREGION1RA.
	MWU_NMIEN_PREGION1RA = 0x8000000
	// Disable
	MWU_NMIEN_PREGION1RA_Disabled = 0x0
	// Enable
	MWU_NMIEN_PREGION1RA_Enabled = 0x1

	// NMIENSET: Enable interrupt
	// Position of REGION0WA field.
	MWU_NMIENSET_REGION0WA_Pos = 0x0
	// Bit mask of REGION0WA field.
	MWU_NMIENSET_REGION0WA_Msk = 0x1
	// Bit REGION0WA.
	MWU_NMIENSET_REGION0WA = 0x1
	// Read: Disabled
	MWU_NMIENSET_REGION0WA_Disabled = 0x0
	// Read: Enabled
	MWU_NMIENSET_REGION0WA_Enabled = 0x1
	// Enable
	MWU_NMIENSET_REGION0WA_Set = 0x1
	// Position of REGION0RA field.
	MWU_NMIENSET_REGION0RA_Pos = 0x1
	// Bit mask of REGION0RA field.
	MWU_NMIENSET_REGION0RA_Msk = 0x2
	// Bit REGION0RA.
	MWU_NMIENSET_REGION0RA = 0x2
	// Read: Disabled
	MWU_NMIENSET_REGION0RA_Disabled = 0x0
	// Read: Enabled
	MWU_NMIENSET_REGION0RA_Enabled = 0x1
	// Enable
	MWU_NMIENSET_REGION0RA_Set = 0x1
	// Position of REGION1WA field.
	MWU_NMIENSET_REGION1WA_Pos = 0x2
	// Bit mask of REGION1WA field.
	MWU_NMIENSET_REGION1WA_Msk = 0x4
	// Bit REGION1WA.
	MWU_NMIENSET_REGION1WA = 0x4
	// Read: Disabled
	MWU_NMIENSET_REGION1WA_Disabled = 0x0
	// Read: Enabled
	MWU_NMIENSET_REGION1WA_Enabled = 0x1
	// Enable
	MWU_NMIENSET_REGION1WA_Set = 0x1
	// Position of REGION1RA field.
	MWU_NMIENSET_REGION1RA_Pos = 0x3
	// Bit mask of REGION1RA field.
	MWU_NMIENSET_REGION1RA_Msk = 0x8
	// Bit REGION1RA.
	MWU_NMIENSET_REGION1RA = 0x8
	// Read: Disabled
	MWU_NMIENSET_REGION1RA_Disabled = 0x0
	// Read: Enabled
	MWU_NMIENSET_REGION1RA_Enabled = 0x1
	// Enable
	MWU_NMIENSET_REGION1RA_Set = 0x1
	// Position of REGION2WA field.
	MWU_NMIENSET_REGION2WA_Pos = 0x4
	// Bit mask of REGION2WA field.
	MWU_NMIENSET_REGION2WA_Msk = 0x10
	// Bit REGION2WA.
	MWU_NMIENSET_REGION2WA = 0x10
	// Read: Disabled
	MWU_NMIENSET_REGION2WA_Disabled = 0x0
	// Read: Enabled
	MWU_NMIENSET_REGION2WA_Enabled = 0x1
	// Enable
	MWU_NMIENSET_REGION2WA_Set = 0x1
	// Position of REGION2RA field.
	MWU_NMIENSET_REGION2RA_Pos = 0x5
	// Bit mask of REGION2RA field.
	MWU_NMIENSET_REGION2RA_Msk = 0x20
	// Bit REGION2RA.
	MWU_NMIENSET_REGION2RA = 0x20
	// Read: Disabled
	MWU_NMIENSET_REGION2RA_Disabled = 0x0
	// Read: Enabled
	MWU_NMIENSET_REGION2RA_Enabled = 0x1
	// Enable
	MWU_NMIENSET_REGION2RA_Set = 0x1
	// Position of REGION3WA field.
	MWU_NMIENSET_REGION3WA_Pos = 0x6
	// Bit mask of REGION3WA field.
	MWU_NMIENSET_REGION3WA_Msk = 0x40
	// Bit REGION3WA.
	MWU_NMIENSET_REGION3WA = 0x40
	// Read: Disabled
	MWU_NMIENSET_REGION3WA_Disabled = 0x0
	// Read: Enabled
	MWU_NMIENSET_REGION3WA_Enabled = 0x1
	// Enable
	MWU_NMIENSET_REGION3WA_Set = 0x1
	// Position of REGION3RA field.
	MWU_NMIENSET_REGION3RA_Pos = 0x7
	// Bit mask of REGION3RA field.
	MWU_NMIENSET_REGION3RA_Msk = 0x80
	// Bit REGION3RA.
	MWU_NMIENSET_REGION3RA = 0x80
	// Read: Disabled
	MWU_NMIENSET_REGION3RA_Disabled = 0x0
	// Read: Enabled
	MWU_NMIENSET_REGION3RA_Enabled = 0x1
	// Enable
	MWU_NMIENSET_REGION3RA_Set = 0x1
	// Position of PREGION0WA field.
	MWU_NMIENSET_PREGION0WA_Pos = 0x18
	// Bit mask of PREGION0WA field.
	MWU_NMIENSET_PREGION0WA_Msk = 0x1000000
	// Bit PREGION0WA.
	MWU_NMIENSET_PREGION0WA = 0x1000000
	// Read: Disabled
	MWU_NMIENSET_PREGION0WA_Disabled = 0x0
	// Read: Enabled
	MWU_NMIENSET_PREGION0WA_Enabled = 0x1
	// Enable
	MWU_NMIENSET_PREGION0WA_Set = 0x1
	// Position of PREGION0RA field.
	MWU_NMIENSET_PREGION0RA_Pos = 0x19
	// Bit mask of PREGION0RA field.
	MWU_NMIENSET_PREGION0RA_Msk = 0x2000000
	// Bit PREGION0RA.
	MWU_NMIENSET_PREGION0RA = 0x2000000
	// Read: Disabled
	MWU_NMIENSET_PREGION0RA_Disabled = 0x0
	// Read: Enabled
	MWU_NMIENSET_PREGION0RA_Enabled = 0x1
	// Enable
	MWU_NMIENSET_PREGION0RA_Set = 0x1
	// Position of PREGION1WA field.
	MWU_NMIENSET_PREGION1WA_Pos = 0x1a
	// Bit mask of PREGION1WA field.
	MWU_NMIENSET_PREGION1WA_Msk = 0x4000000
	// Bit PREGION1WA.
	MWU_NMIENSET_PREGION1WA = 0x4000000
	// Read: Disabled
	MWU_NMIENSET_PREGION1WA_Disabled = 0x0
	// Read: Enabled
	MWU_NMIENSET_PREGION1WA_Enabled = 0x1
	// Enable
	MWU_NMIENSET_PREGION1WA_Set = 0x1
	// Position of PREGION1RA field.
	MWU_NMIENSET_PREGION1RA_Pos = 0x1b
	// Bit mask of PREGION1RA field.
	MWU_NMIENSET_PREGION1RA_Msk = 0x8000000
	// Bit PREGION1RA.
	MWU_NMIENSET_PREGION1RA = 0x8000000
	// Read: Disabled
	MWU_NMIENSET_PREGION1RA_Disabled = 0x0
	// Read: Enabled
	MWU_NMIENSET_PREGION1RA_Enabled = 0x1
	// Enable
	MWU_NMIENSET_PREGION1RA_Set = 0x1

	// NMIENCLR: Disable interrupt
	// Position of REGION0WA field.
	MWU_NMIENCLR_REGION0WA_Pos = 0x0
	// Bit mask of REGION0WA field.
	MWU_NMIENCLR_REGION0WA_Msk = 0x1
	// Bit REGION0WA.
	MWU_NMIENCLR_REGION0WA = 0x1
	// Read: Disabled
	MWU_NMIENCLR_REGION0WA_Disabled = 0x0
	// Read: Enabled
	MWU_NMIENCLR_REGION0WA_Enabled = 0x1
	// Disable
	MWU_NMIENCLR_REGION0WA_Clear = 0x1
	// Position of REGION0RA field.
	MWU_NMIENCLR_REGION0RA_Pos = 0x1
	// Bit mask of REGION0RA field.
	MWU_NMIENCLR_REGION0RA_Msk = 0x2
	// Bit REGION0RA.
	MWU_NMIENCLR_REGION0RA = 0x2
	// Read: Disabled
	MWU_NMIENCLR_REGION0RA_Disabled = 0x0
	// Read: Enabled
	MWU_NMIENCLR_REGION0RA_Enabled = 0x1
	// Disable
	MWU_NMIENCLR_REGION0RA_Clear = 0x1
	// Position of REGION1WA field.
	MWU_NMIENCLR_REGION1WA_Pos = 0x2
	// Bit mask of REGION1WA field.
	MWU_NMIENCLR_REGION1WA_Msk = 0x4
	// Bit REGION1WA.
	MWU_NMIENCLR_REGION1WA = 0x4
	// Read: Disabled
	MWU_NMIENCLR_REGION1WA_Disabled = 0x0
	// Read: Enabled
	MWU_NMIENCLR_REGION1WA_Enabled = 0x1
	// Disable
	MWU_NMIENCLR_REGION1WA_Clear = 0x1
	// Position of REGION1RA field.
	MWU_NMIENCLR_REGION1RA_Pos = 0x3
	// Bit mask of REGION1RA field.
	MWU_NMIENCLR_REGION1RA_Msk = 0x8
	// Bit REGION1RA.
	MWU_NMIENCLR_REGION1RA = 0x8
	// Read: Disabled
	MWU_NMIENCLR_REGION1RA_Disabled = 0x0
	// Read: Enabled
	MWU_NMIENCLR_REGION1RA_Enabled = 0x1
	// Disable
	MWU_NMIENCLR_REGION1RA_Clear = 0x1
	// Position of REGION2WA field.
	MWU_NMIENCLR_REGION2WA_Pos = 0x4
	// Bit mask of REGION2WA field.
	MWU_NMIENCLR_REGION2WA_Msk = 0x10
	// Bit REGION2WA.
	MWU_NMIENCLR_REGION2WA = 0x10
	// Read: Disabled
	MWU_NMIENCLR_REGION2WA_Disabled = 0x0
	// Read: Enabled
	MWU_NMIENCLR_REGION2WA_Enabled = 0x1
	// Disable
	MWU_NMIENCLR_REGION2WA_Clear = 0x1
	// Position of REGION2RA field.
	MWU_NMIENCLR_REGION2RA_Pos = 0x5
	// Bit mask of REGION2RA field.
	MWU_NMIENCLR_REGION2RA_Msk = 0x20
	// Bit REGION2RA.
	MWU_NMIENCLR_REGION2RA = 0x20
	// Read: Disabled
	MWU_NMIENCLR_REGION2RA_Disabled = 0x0
	// Read: Enabled
	MWU_NMIENCLR_REGION2RA_Enabled = 0x1
	// Disable
	MWU_NMIENCLR_REGION2RA_Clear = 0x1
	// Position of REGION3WA field.
	MWU_NMIENCLR_REGION3WA_Pos = 0x6
	// Bit mask of REGION3WA field.
	MWU_NMIENCLR_REGION3WA_Msk = 0x40
	// Bit REGION3WA.
	MWU_NMIENCLR_REGION3WA = 0x40
	// Read: Disabled
	MWU_NMIENCLR_REGION3WA_Disabled = 0x0
	// Read: Enabled
	MWU_NMIENCLR_REGION3WA_Enabled = 0x1
	// Disable
	MWU_NMIENCLR_REGION3WA_Clear = 0x1
	// Position of REGION3RA field.
	MWU_NMIENCLR_REGION3RA_Pos = 0x7
	// Bit mask of REGION3RA field.
	MWU_NMIENCLR_REGION3RA_Msk = 0x80
	// Bit REGION3RA.
	MWU_NMIENCLR_REGION3RA = 0x80
	// Read: Disabled
	MWU_NMIENCLR_REGION3RA_Disabled = 0x0
	// Read: Enabled
	MWU_NMIENCLR_REGION3RA_Enabled = 0x1
	// Disable
	MWU_NMIENCLR_REGION3RA_Clear = 0x1
	// Position of PREGION0WA field.
	MWU_NMIENCLR_PREGION0WA_Pos = 0x18
	// Bit mask of PREGION0WA field.
	MWU_NMIENCLR_PREGION0WA_Msk = 0x1000000
	// Bit PREGION0WA.
	MWU_NMIENCLR_PREGION0WA = 0x1000000
	// Read: Disabled
	MWU_NMIENCLR_PREGION0WA_Disabled = 0x0
	// Read: Enabled
	MWU_NMIENCLR_PREGION0WA_Enabled = 0x1
	// Disable
	MWU_NMIENCLR_PREGION0WA_Clear = 0x1
	// Position of PREGION0RA field.
	MWU_NMIENCLR_PREGION0RA_Pos = 0x19
	// Bit mask of PREGION0RA field.
	MWU_NMIENCLR_PREGION0RA_Msk = 0x2000000
	// Bit PREGION0RA.
	MWU_NMIENCLR_PREGION0RA = 0x2000000
	// Read: Disabled
	MWU_NMIENCLR_PREGION0RA_Disabled = 0x0
	// Read: Enabled
	MWU_NMIENCLR_PREGION0RA_Enabled = 0x1
	// Disable
	MWU_NMIENCLR_PREGION0RA_Clear = 0x1
	// Position of PREGION1WA field.
	MWU_NMIENCLR_PREGION1WA_Pos = 0x1a
	// Bit mask of PREGION1WA field.
	MWU_NMIENCLR_PREGION1WA_Msk = 0x4000000
	// Bit PREGION1WA.
	MWU_NMIENCLR_PREGION1WA = 0x4000000
	// Read: Disabled
	MWU_NMIENCLR_PREGION1WA_Disabled = 0x0
	// Read: Enabled
	MWU_NMIENCLR_PREGION1WA_Enabled = 0x1
	// Disable
	MWU_NMIENCLR_PREGION1WA_Clear = 0x1
	// Position of PREGION1RA field.
	MWU_NMIENCLR_PREGION1RA_Pos = 0x1b
	// Bit mask of PREGION1RA field.
	MWU_NMIENCLR_PREGION1RA_Msk = 0x8000000
	// Bit PREGION1RA.
	MWU_NMIENCLR_PREGION1RA = 0x8000000
	// Read: Disabled
	MWU_NMIENCLR_PREGION1RA_Disabled = 0x0
	// Read: Enabled
	MWU_NMIENCLR_PREGION1RA_Enabled = 0x1
	// Disable
	MWU_NMIENCLR_PREGION1RA_Clear = 0x1

	// PERREGION.SUBSTATWA: Description cluster: Source of event/interrupt in region n, write access detected while corresponding subregion was enabled for watching
	// Position of SR0 field.
	MWU_PERREGION_SUBSTATWA_SR0_Pos = 0x0
	// Bit mask of SR0 field.
	MWU_PERREGION_SUBSTATWA_SR0_Msk = 0x1
	// Bit SR0.
	MWU_PERREGION_SUBSTATWA_SR0 = 0x1
	// No write access occurred in this subregion
	MWU_PERREGION_SUBSTATWA_SR0_NoAccess = 0x0
	// Write access(es) occurred in this subregion
	MWU_PERREGION_SUBSTATWA_SR0_Access = 0x1
	// Position of SR1 field.
	MWU_PERREGION_SUBSTATWA_SR1_Pos = 0x1
	// Bit mask of SR1 field.
	MWU_PERREGION_SUBSTATWA_SR1_Msk = 0x2
	// Bit SR1.
	MWU_PERREGION_SUBSTATWA_SR1 = 0x2
	// No write access occurred in this subregion
	MWU_PERREGION_SUBSTATWA_SR1_NoAccess = 0x0
	// Write access(es) occurred in this subregion
	MWU_PERREGION_SUBSTATWA_SR1_Access = 0x1
	// Position of SR2 field.
	MWU_PERREGION_SUBSTATWA_SR2_Pos = 0x2
	// Bit mask of SR2 field.
	MWU_PERREGION_SUBSTATWA_SR2_Msk = 0x4
	// Bit SR2.
	MWU_PERREGION_SUBSTATWA_SR2 = 0x4
	// No write access occurred in this subregion
	MWU_PERREGION_SUBSTATWA_SR2_NoAccess = 0x0
	// Write access(es) occurred in this subregion
	MWU_PERREGION_SUBSTATWA_SR2_Access = 0x1
	// Position of SR3 field.
	MWU_PERREGION_SUBSTATWA_SR3_Pos = 0x3
	// Bit mask of SR3 field.
	MWU_PERREGION_SUBSTATWA_SR3_Msk = 0x8
	// Bit SR3.
	MWU_PERREGION_SUBSTATWA_SR3 = 0x8
	// No write access occurred in this subregion
	MWU_PERREGION_SUBSTATWA_SR3_NoAccess = 0x0
	// Write access(es) occurred in this subregion
	MWU_PERREGION_SUBSTATWA_SR3_Access = 0x1
	// Position of SR4 field.
	MWU_PERREGION_SUBSTATWA_SR4_Pos = 0x4
	// Bit mask of SR4 field.
	MWU_PERREGION_SUBSTATWA_SR4_Msk = 0x10
	// Bit SR4.
	MWU_PERREGION_SUBSTATWA_SR4 = 0x10
	// No write access occurred in this subregion
	MWU_PERREGION_SUBSTATWA_SR4_NoAccess = 0x0
	// Write access(es) occurred in this subregion
	MWU_PERREGION_SUBSTATWA_SR4_Access = 0x1
	// Position of SR5 field.
	MWU_PERREGION_SUBSTATWA_SR5_Pos = 0x5
	// Bit mask of SR5 field.
	MWU_PERREGION_SUBSTATWA_SR5_Msk = 0x20
	// Bit SR5.
	MWU_PERREGION_SUBSTATWA_SR5 = 0x20
	// No write access occurred in this subregion
	MWU_PERREGION_SUBSTATWA_SR5_NoAccess = 0x0
	// Write access(es) occurred in this subregion
	MWU_PERREGION_SUBSTATWA_SR5_Access = 0x1
	// Position of SR6 field.
	MWU_PERREGION_SUBSTATWA_SR6_Pos = 0x6
	// Bit mask of SR6 field.
	MWU_PERREGION_SUBSTATWA_SR6_Msk = 0x40
	// Bit SR6.
	MWU_PERREGION_SUBSTATWA_SR6 = 0x40
	// No write access occurred in this subregion
	MWU_PERREGION_SUBSTATWA_SR6_NoAccess = 0x0
	// Write access(es) occurred in this subregion
	MWU_PERREGION_SUBSTATWA_SR6_Access = 0x1
	// Position of SR7 field.
	MWU_PERREGION_SUBSTATWA_SR7_Pos = 0x7
	// Bit mask of SR7 field.
	MWU_PERREGION_SUBSTATWA_SR7_Msk = 0x80
	// Bit SR7.
	MWU_PERREGION_SUBSTATWA_SR7 = 0x80
	// No write access occurred in this subregion
	MWU_PERREGION_SUBSTATWA_SR7_NoAccess = 0x0
	// Write access(es) occurred in this subregion
	MWU_PERREGION_SUBSTATWA_SR7_Access = 0x1
	// Position of SR8 field.
	MWU_PERREGION_SUBSTATWA_SR8_Pos = 0x8
	// Bit mask of SR8 field.
	MWU_PERREGION_SUBSTATWA_SR8_Msk = 0x100
	// Bit SR8.
	MWU_PERREGION_SUBSTATWA_SR8 = 0x100
	// No write access occurred in this subregion
	MWU_PERREGION_SUBSTATWA_SR8_NoAccess = 0x0
	// Write access(es) occurred in this subregion
	MWU_PERREGION_SUBSTATWA_SR8_Access = 0x1
	// Position of SR9 field.
	MWU_PERREGION_SUBSTATWA_SR9_Pos = 0x9
	// Bit mask of SR9 field.
	MWU_PERREGION_SUBSTATWA_SR9_Msk = 0x200
	// Bit SR9.
	MWU_PERREGION_SUBSTATWA_SR9 = 0x200
	// No write access occurred in this subregion
	MWU_PERREGION_SUBSTATWA_SR9_NoAccess = 0x0
	// Write access(es) occurred in this subregion
	MWU_PERREGION_SUBSTATWA_SR9_Access = 0x1
	// Position of SR10 field.
	MWU_PERREGION_SUBSTATWA_SR10_Pos = 0xa
	// Bit mask of SR10 field.
	MWU_PERREGION_SUBSTATWA_SR10_Msk = 0x400
	// Bit SR10.
	MWU_PERREGION_SUBSTATWA_SR10 = 0x400
	// No write access occurred in this subregion
	MWU_PERREGION_SUBSTATWA_SR10_NoAccess = 0x0
	// Write access(es) occurred in this subregion
	MWU_PERREGION_SUBSTATWA_SR10_Access = 0x1
	// Position of SR11 field.
	MWU_PERREGION_SUBSTATWA_SR11_Pos = 0xb
	// Bit mask of SR11 field.
	MWU_PERREGION_SUBSTATWA_SR11_Msk = 0x800
	// Bit SR11.
	MWU_PERREGION_SUBSTATWA_SR11 = 0x800
	// No write access occurred in this subregion
	MWU_PERREGION_SUBSTATWA_SR11_NoAccess = 0x0
	// Write access(es) occurred in this subregion
	MWU_PERREGION_SUBSTATWA_SR11_Access = 0x1
	// Position of SR12 field.
	MWU_PERREGION_SUBSTATWA_SR12_Pos = 0xc
	// Bit mask of SR12 field.
	MWU_PERREGION_SUBSTATWA_SR12_Msk = 0x1000
	// Bit SR12.
	MWU_PERREGION_SUBSTATWA_SR12 = 0x1000
	// No write access occurred in this subregion
	MWU_PERREGION_SUBSTATWA_SR12_NoAccess = 0x0
	// Write access(es) occurred in this subregion
	MWU_PERREGION_SUBSTATWA_SR12_Access = 0x1
	// Position of SR13 field.
	MWU_PERREGION_SUBSTATWA_SR13_Pos = 0xd
	// Bit mask of SR13 field.
	MWU_PERREGION_SUBSTATWA_SR13_Msk = 0x2000
	// Bit SR13.
	MWU_PERREGION_SUBSTATWA_SR13 = 0x2000
	// No write access occurred in this subregion
	MWU_PERREGION_SUBSTATWA_SR13_NoAccess = 0x0
	// Write access(es) occurred in this subregion
	MWU_PERREGION_SUBSTATWA_SR13_Access = 0x1
	// Position of SR14 field.
	MWU_PERREGION_SUBSTATWA_SR14_Pos = 0xe
	// Bit mask of SR14 field.
	MWU_PERREGION_SUBSTATWA_SR14_Msk = 0x4000
	// Bit SR14.
	MWU_PERREGION_SUBSTATWA_SR14 = 0x4000
	// No write access occurred in this subregion
	MWU_PERREGION_SUBSTATWA_SR14_NoAccess = 0x0
	// Write access(es) occurred in this subregion
	MWU_PERREGION_SUBSTATWA_SR14_Access = 0x1
	// Position of SR15 field.
	MWU_PERREGION_SUBSTATWA_SR15_Pos = 0xf
	// Bit mask of SR15 field.
	MWU_PERREGION_SUBSTATWA_SR15_Msk = 0x8000
	// Bit SR15.
	MWU_PERREGION_SUBSTATWA_SR15 = 0x8000
	// No write access occurred in this subregion
	MWU_PERREGION_SUBSTATWA_SR15_NoAccess = 0x0
	// Write access(es) occurred in this subregion
	MWU_PERREGION_SUBSTATWA_SR15_Access = 0x1
	// Position of SR16 field.
	MWU_PERREGION_SUBSTATWA_SR16_Pos = 0x10
	// Bit mask of SR16 field.
	MWU_PERREGION_SUBSTATWA_SR16_Msk = 0x10000
	// Bit SR16.
	MWU_PERREGION_SUBSTATWA_SR16 = 0x10000
	// No write access occurred in this subregion
	MWU_PERREGION_SUBSTATWA_SR16_NoAccess = 0x0
	// Write access(es) occurred in this subregion
	MWU_PERREGION_SUBSTATWA_SR16_Access = 0x1
	// Position of SR17 field.
	MWU_PERREGION_SUBSTATWA_SR17_Pos = 0x11
	// Bit mask of SR17 field.
	MWU_PERREGION_SUBSTATWA_SR17_Msk = 0x20000
	// Bit SR17.
	MWU_PERREGION_SUBSTATWA_SR17 = 0x20000
	// No write access occurred in this subregion
	MWU_PERREGION_SUBSTATWA_SR17_NoAccess = 0x0
	// Write access(es) occurred in this subregion
	MWU_PERREGION_SUBSTATWA_SR17_Access = 0x1
	// Position of SR18 field.
	MWU_PERREGION_SUBSTATWA_SR18_Pos = 0x12
	// Bit mask of SR18 field.
	MWU_PERREGION_SUBSTATWA_SR18_Msk = 0x40000
	// Bit SR18.
	MWU_PERREGION_SUBSTATWA_SR18 = 0x40000
	// No write access occurred in this subregion
	MWU_PERREGION_SUBSTATWA_SR18_NoAccess = 0x0
	// Write access(es) occurred in this subregion
	MWU_PERREGION_SUBSTATWA_SR18_Access = 0x1
	// Position of SR19 field.
	MWU_PERREGION_SUBSTATWA_SR19_Pos = 0x13
	// Bit mask of SR19 field.
	MWU_PERREGION_SUBSTATWA_SR19_Msk = 0x80000
	// Bit SR19.
	MWU_PERREGION_SUBSTATWA_SR19 = 0x80000
	// No write access occurred in this subregion
	MWU_PERREGION_SUBSTATWA_SR19_NoAccess = 0x0
	// Write access(es) occurred in this subregion
	MWU_PERREGION_SUBSTATWA_SR19_Access = 0x1
	// Position of SR20 field.
	MWU_PERREGION_SUBSTATWA_SR20_Pos = 0x14
	// Bit mask of SR20 field.
	MWU_PERREGION_SUBSTATWA_SR20_Msk = 0x100000
	// Bit SR20.
	MWU_PERREGION_SUBSTATWA_SR20 = 0x100000
	// No write access occurred in this subregion
	MWU_PERREGION_SUBSTATWA_SR20_NoAccess = 0x0
	// Write access(es) occurred in this subregion
	MWU_PERREGION_SUBSTATWA_SR20_Access = 0x1
	// Position of SR21 field.
	MWU_PERREGION_SUBSTATWA_SR21_Pos = 0x15
	// Bit mask of SR21 field.
	MWU_PERREGION_SUBSTATWA_SR21_Msk = 0x200000
	// Bit SR21.
	MWU_PERREGION_SUBSTATWA_SR21 = 0x200000
	// No write access occurred in this subregion
	MWU_PERREGION_SUBSTATWA_SR21_NoAccess = 0x0
	// Write access(es) occurred in this subregion
	MWU_PERREGION_SUBSTATWA_SR21_Access = 0x1
	// Position of SR22 field.
	MWU_PERREGION_SUBSTATWA_SR22_Pos = 0x16
	// Bit mask of SR22 field.
	MWU_PERREGION_SUBSTATWA_SR22_Msk = 0x400000
	// Bit SR22.
	MWU_PERREGION_SUBSTATWA_SR22 = 0x400000
	// No write access occurred in this subregion
	MWU_PERREGION_SUBSTATWA_SR22_NoAccess = 0x0
	// Write access(es) occurred in this subregion
	MWU_PERREGION_SUBSTATWA_SR22_Access = 0x1
	// Position of SR23 field.
	MWU_PERREGION_SUBSTATWA_SR23_Pos = 0x17
	// Bit mask of SR23 field.
	MWU_PERREGION_SUBSTATWA_SR23_Msk = 0x800000
	// Bit SR23.
	MWU_PERREGION_SUBSTATWA_SR23 = 0x800000
	// No write access occurred in this subregion
	MWU_PERREGION_SUBSTATWA_SR23_NoAccess = 0x0
	// Write access(es) occurred in this subregion
	MWU_PERREGION_SUBSTATWA_SR23_Access = 0x1
	// Position of SR24 field.
	MWU_PERREGION_SUBSTATWA_SR24_Pos = 0x18
	// Bit mask of SR24 field.
	MWU_PERREGION_SUBSTATWA_SR24_Msk = 0x1000000
	// Bit SR24.
	MWU_PERREGION_SUBSTATWA_SR24 = 0x1000000
	// No write access occurred in this subregion
	MWU_PERREGION_SUBSTATWA_SR24_NoAccess = 0x0
	// Write access(es) occurred in this subregion
	MWU_PERREGION_SUBSTATWA_SR24_Access = 0x1
	// Position of SR25 field.
	MWU_PERREGION_SUBSTATWA_SR25_Pos = 0x19
	// Bit mask of SR25 field.
	MWU_PERREGION_SUBSTATWA_SR25_Msk = 0x2000000
	// Bit SR25.
	MWU_PERREGION_SUBSTATWA_SR25 = 0x2000000
	// No write access occurred in this subregion
	MWU_PERREGION_SUBSTATWA_SR25_NoAccess = 0x0
	// Write access(es) occurred in this subregion
	MWU_PERREGION_SUBSTATWA_SR25_Access = 0x1
	// Position of SR26 field.
	MWU_PERREGION_SUBSTATWA_SR26_Pos = 0x1a
	// Bit mask of SR26 field.
	MWU_PERREGION_SUBSTATWA_SR26_Msk = 0x4000000
	// Bit SR26.
	MWU_PERREGION_SUBSTATWA_SR26 = 0x4000000
	// No write access occurred in this subregion
	MWU_PERREGION_SUBSTATWA_SR26_NoAccess = 0x0
	// Write access(es) occurred in this subregion
	MWU_PERREGION_SUBSTATWA_SR26_Access = 0x1
	// Position of SR27 field.
	MWU_PERREGION_SUBSTATWA_SR27_Pos = 0x1b
	// Bit mask of SR27 field.
	MWU_PERREGION_SUBSTATWA_SR27_Msk = 0x8000000
	// Bit SR27.
	MWU_PERREGION_SUBSTATWA_SR27 = 0x8000000
	// No write access occurred in this subregion
	MWU_PERREGION_SUBSTATWA_SR27_NoAccess = 0x0
	// Write access(es) occurred in this subregion
	MWU_PERREGION_SUBSTATWA_SR27_Access = 0x1
	// Position of SR28 field.
	MWU_PERREGION_SUBSTATWA_SR28_Pos = 0x1c
	// Bit mask of SR28 field.
	MWU_PERREGION_SUBSTATWA_SR28_Msk = 0x10000000
	// Bit SR28.
	MWU_PERREGION_SUBSTATWA_SR28 = 0x10000000
	// No write access occurred in this subregion
	MWU_PERREGION_SUBSTATWA_SR28_NoAccess = 0x0
	// Write access(es) occurred in this subregion
	MWU_PERREGION_SUBSTATWA_SR28_Access = 0x1
	// Position of SR29 field.
	MWU_PERREGION_SUBSTATWA_SR29_Pos = 0x1d
	// Bit mask of SR29 field.
	MWU_PERREGION_SUBSTATWA_SR29_Msk = 0x20000000
	// Bit SR29.
	MWU_PERREGION_SUBSTATWA_SR29 = 0x20000000
	// No write access occurred in this subregion
	MWU_PERREGION_SUBSTATWA_SR29_NoAccess = 0x0
	// Write access(es) occurred in this subregion
	MWU_PERREGION_SUBSTATWA_SR29_Access = 0x1
	// Position of SR30 field.
	MWU_PERREGION_SUBSTATWA_SR30_Pos = 0x1e
	// Bit mask of SR30 field.
	MWU_PERREGION_SUBSTATWA_SR30_Msk = 0x40000000
	// Bit SR30.
	MWU_PERREGION_SUBSTATWA_SR30 = 0x40000000
	// No write access occurred in this subregion
	MWU_PERREGION_SUBSTATWA_SR30_NoAccess = 0x0
	// Write access(es) occurred in this subregion
	MWU_PERREGION_SUBSTATWA_SR30_Access = 0x1
	// Position of SR31 field.
	MWU_PERREGION_SUBSTATWA_SR31_Pos = 0x1f
	// Bit mask of SR31 field.
	MWU_PERREGION_SUBSTATWA_SR31_Msk = 0x80000000
	// Bit SR31.
	MWU_PERREGION_SUBSTATWA_SR31 = 0x80000000
	// No write access occurred in this subregion
	MWU_PERREGION_SUBSTATWA_SR31_NoAccess = 0x0
	// Write access(es) occurred in this subregion
	MWU_PERREGION_SUBSTATWA_SR31_Access = 0x1

	// PERREGION.SUBSTATRA: Description cluster: Source of event/interrupt in region n, read access detected while corresponding subregion was enabled for watching
	// Position of SR0 field.
	MWU_PERREGION_SUBSTATRA_SR0_Pos = 0x0
	// Bit mask of SR0 field.
	MWU_PERREGION_SUBSTATRA_SR0_Msk = 0x1
	// Bit SR0.
	MWU_PERREGION_SUBSTATRA_SR0 = 0x1
	// No read access occurred in this subregion
	MWU_PERREGION_SUBSTATRA_SR0_NoAccess = 0x0
	// Read access(es) occurred in this subregion
	MWU_PERREGION_SUBSTATRA_SR0_Access = 0x1
	// Position of SR1 field.
	MWU_PERREGION_SUBSTATRA_SR1_Pos = 0x1
	// Bit mask of SR1 field.
	MWU_PERREGION_SUBSTATRA_SR1_Msk = 0x2
	// Bit SR1.
	MWU_PERREGION_SUBSTATRA_SR1 = 0x2
	// No read access occurred in this subregion
	MWU_PERREGION_SUBSTATRA_SR1_NoAccess = 0x0
	// Read access(es) occurred in this subregion
	MWU_PERREGION_SUBSTATRA_SR1_Access = 0x1
	// Position of SR2 field.
	MWU_PERREGION_SUBSTATRA_SR2_Pos = 0x2
	// Bit mask of SR2 field.
	MWU_PERREGION_SUBSTATRA_SR2_Msk = 0x4
	// Bit SR2.
	MWU_PERREGION_SUBSTATRA_SR2 = 0x4
	// No read access occurred in this subregion
	MWU_PERREGION_SUBSTATRA_SR2_NoAccess = 0x0
	// Read access(es) occurred in this subregion
	MWU_PERREGION_SUBSTATRA_SR2_Access = 0x1
	// Position of SR3 field.
	MWU_PERREGION_SUBSTATRA_SR3_Pos = 0x3
	// Bit mask of SR3 field.
	MWU_PERREGION_SUBSTATRA_SR3_Msk = 0x8
	// Bit SR3.
	MWU_PERREGION_SUBSTATRA_SR3 = 0x8
	// No read access occurred in this subregion
	MWU_PERREGION_SUBSTATRA_SR3_NoAccess = 0x0
	// Read access(es) occurred in this subregion
	MWU_PERREGION_SUBSTATRA_SR3_Access = 0x1
	// Position of SR4 field.
	MWU_PERREGION_SUBSTATRA_SR4_Pos = 0x4
	// Bit mask of SR4 field.
	MWU_PERREGION_SUBSTATRA_SR4_Msk = 0x10
	// Bit SR4.
	MWU_PERREGION_SUBSTATRA_SR4 = 0x10
	// No read access occurred in this subregion
	MWU_PERREGION_SUBSTATRA_SR4_NoAccess = 0x0
	// Read access(es) occurred in this subregion
	MWU_PERREGION_SUBSTATRA_SR4_Access = 0x1
	// Position of SR5 field.
	MWU_PERREGION_SUBSTATRA_SR5_Pos = 0x5
	// Bit mask of SR5 field.
	MWU_PERREGION_SUBSTATRA_SR5_Msk = 0x20
	// Bit SR5.
	MWU_PERREGION_SUBSTATRA_SR5 = 0x20
	// No read access occurred in this subregion
	MWU_PERREGION_SUBSTATRA_SR5_NoAccess = 0x0
	// Read access(es) occurred in this subregion
	MWU_PERREGION_SUBSTATRA_SR5_Access = 0x1
	// Position of SR6 field.
	MWU_PERREGION_SUBSTATRA_SR6_Pos = 0x6
	// Bit mask of SR6 field.
	MWU_PERREGION_SUBSTATRA_SR6_Msk = 0x40
	// Bit SR6.
	MWU_PERREGION_SUBSTATRA_SR6 = 0x40
	// No read access occurred in this subregion
	MWU_PERREGION_SUBSTATRA_SR6_NoAccess = 0x0
	// Read access(es) occurred in this subregion
	MWU_PERREGION_SUBSTATRA_SR6_Access = 0x1
	// Position of SR7 field.
	MWU_PERREGION_SUBSTATRA_SR7_Pos = 0x7
	// Bit mask of SR7 field.
	MWU_PERREGION_SUBSTATRA_SR7_Msk = 0x80
	// Bit SR7.
	MWU_PERREGION_SUBSTATRA_SR7 = 0x80
	// No read access occurred in this subregion
	MWU_PERREGION_SUBSTATRA_SR7_NoAccess = 0x0
	// Read access(es) occurred in this subregion
	MWU_PERREGION_SUBSTATRA_SR7_Access = 0x1
	// Position of SR8 field.
	MWU_PERREGION_SUBSTATRA_SR8_Pos = 0x8
	// Bit mask of SR8 field.
	MWU_PERREGION_SUBSTATRA_SR8_Msk = 0x100
	// Bit SR8.
	MWU_PERREGION_SUBSTATRA_SR8 = 0x100
	// No read access occurred in this subregion
	MWU_PERREGION_SUBSTATRA_SR8_NoAccess = 0x0
	// Read access(es) occurred in this subregion
	MWU_PERREGION_SUBSTATRA_SR8_Access = 0x1
	// Position of SR9 field.
	MWU_PERREGION_SUBSTATRA_SR9_Pos = 0x9
	// Bit mask of SR9 field.
	MWU_PERREGION_SUBSTATRA_SR9_Msk = 0x200
	// Bit SR9.
	MWU_PERREGION_SUBSTATRA_SR9 = 0x200
	// No read access occurred in this subregion
	MWU_PERREGION_SUBSTATRA_SR9_NoAccess = 0x0
	// Read access(es) occurred in this subregion
	MWU_PERREGION_SUBSTATRA_SR9_Access = 0x1
	// Position of SR10 field.
	MWU_PERREGION_SUBSTATRA_SR10_Pos = 0xa
	// Bit mask of SR10 field.
	MWU_PERREGION_SUBSTATRA_SR10_Msk = 0x400
	// Bit SR10.
	MWU_PERREGION_SUBSTATRA_SR10 = 0x400
	// No read access occurred in this subregion
	MWU_PERREGION_SUBSTATRA_SR10_NoAccess = 0x0
	// Read access(es) occurred in this subregion
	MWU_PERREGION_SUBSTATRA_SR10_Access = 0x1
	// Position of SR11 field.
	MWU_PERREGION_SUBSTATRA_SR11_Pos = 0xb
	// Bit mask of SR11 field.
	MWU_PERREGION_SUBSTATRA_SR11_Msk = 0x800
	// Bit SR11.
	MWU_PERREGION_SUBSTATRA_SR11 = 0x800
	// No read access occurred in this subregion
	MWU_PERREGION_SUBSTATRA_SR11_NoAccess = 0x0
	// Read access(es) occurred in this subregion
	MWU_PERREGION_SUBSTATRA_SR11_Access = 0x1
	// Position of SR12 field.
	MWU_PERREGION_SUBSTATRA_SR12_Pos = 0xc
	// Bit mask of SR12 field.
	MWU_PERREGION_SUBSTATRA_SR12_Msk = 0x1000
	// Bit SR12.
	MWU_PERREGION_SUBSTATRA_SR12 = 0x1000
	// No read access occurred in this subregion
	MWU_PERREGION_SUBSTATRA_SR12_NoAccess = 0x0
	// Read access(es) occurred in this subregion
	MWU_PERREGION_SUBSTATRA_SR12_Access = 0x1
	// Position of SR13 field.
	MWU_PERREGION_SUBSTATRA_SR13_Pos = 0xd
	// Bit mask of SR13 field.
	MWU_PERREGION_SUBSTATRA_SR13_Msk = 0x2000
	// Bit SR13.
	MWU_PERREGION_SUBSTATRA_SR13 = 0x2000
	// No read access occurred in this subregion
	MWU_PERREGION_SUBSTATRA_SR13_NoAccess = 0x0
	// Read access(es) occurred in this subregion
	MWU_PERREGION_SUBSTATRA_SR13_Access = 0x1
	// Position of SR14 field.
	MWU_PERREGION_SUBSTATRA_SR14_Pos = 0xe
	// Bit mask of SR14 field.
	MWU_PERREGION_SUBSTATRA_SR14_Msk = 0x4000
	// Bit SR14.
	MWU_PERREGION_SUBSTATRA_SR14 = 0x4000
	// No read access occurred in this subregion
	MWU_PERREGION_SUBSTATRA_SR14_NoAccess = 0x0
	// Read access(es) occurred in this subregion
	MWU_PERREGION_SUBSTATRA_SR14_Access = 0x1
	// Position of SR15 field.
	MWU_PERREGION_SUBSTATRA_SR15_Pos = 0xf
	// Bit mask of SR15 field.
	MWU_PERREGION_SUBSTATRA_SR15_Msk = 0x8000
	// Bit SR15.
	MWU_PERREGION_SUBSTATRA_SR15 = 0x8000
	// No read access occurred in this subregion
	MWU_PERREGION_SUBSTATRA_SR15_NoAccess = 0x0
	// Read access(es) occurred in this subregion
	MWU_PERREGION_SUBSTATRA_SR15_Access = 0x1
	// Position of SR16 field.
	MWU_PERREGION_SUBSTATRA_SR16_Pos = 0x10
	// Bit mask of SR16 field.
	MWU_PERREGION_SUBSTATRA_SR16_Msk = 0x10000
	// Bit SR16.
	MWU_PERREGION_SUBSTATRA_SR16 = 0x10000
	// No read access occurred in this subregion
	MWU_PERREGION_SUBSTATRA_SR16_NoAccess = 0x0
	// Read access(es) occurred in this subregion
	MWU_PERREGION_SUBSTATRA_SR16_Access = 0x1
	// Position of SR17 field.
	MWU_PERREGION_SUBSTATRA_SR17_Pos = 0x11
	// Bit mask of SR17 field.
	MWU_PERREGION_SUBSTATRA_SR17_Msk = 0x20000
	// Bit SR17.
	MWU_PERREGION_SUBSTATRA_SR17 = 0x20000
	// No read access occurred in this subregion
	MWU_PERREGION_SUBSTATRA_SR17_NoAccess = 0x0
	// Read access(es) occurred in this subregion
	MWU_PERREGION_SUBSTATRA_SR17_Access = 0x1
	// Position of SR18 field.
	MWU_PERREGION_SUBSTATRA_SR18_Pos = 0x12
	// Bit mask of SR18 field.
	MWU_PERREGION_SUBSTATRA_SR18_Msk = 0x40000
	// Bit SR18.
	MWU_PERREGION_SUBSTATRA_SR18 = 0x40000
	// No read access occurred in this subregion
	MWU_PERREGION_SUBSTATRA_SR18_NoAccess = 0x0
	// Read access(es) occurred in this subregion
	MWU_PERREGION_SUBSTATRA_SR18_Access = 0x1
	// Position of SR19 field.
	MWU_PERREGION_SUBSTATRA_SR19_Pos = 0x13
	// Bit mask of SR19 field.
	MWU_PERREGION_SUBSTATRA_SR19_Msk = 0x80000
	// Bit SR19.
	MWU_PERREGION_SUBSTATRA_SR19 = 0x80000
	// No read access occurred in this subregion
	MWU_PERREGION_SUBSTATRA_SR19_NoAccess = 0x0
	// Read access(es) occurred in this subregion
	MWU_PERREGION_SUBSTATRA_SR19_Access = 0x1
	// Position of SR20 field.
	MWU_PERREGION_SUBSTATRA_SR20_Pos = 0x14
	// Bit mask of SR20 field.
	MWU_PERREGION_SUBSTATRA_SR20_Msk = 0x100000
	// Bit SR20.
	MWU_PERREGION_SUBSTATRA_SR20 = 0x100000
	// No read access occurred in this subregion
	MWU_PERREGION_SUBSTATRA_SR20_NoAccess = 0x0
	// Read access(es) occurred in this subregion
	MWU_PERREGION_SUBSTATRA_SR20_Access = 0x1
	// Position of SR21 field.
	MWU_PERREGION_SUBSTATRA_SR21_Pos = 0x15
	// Bit mask of SR21 field.
	MWU_PERREGION_SUBSTATRA_SR21_Msk = 0x200000
	// Bit SR21.
	MWU_PERREGION_SUBSTATRA_SR21 = 0x200000
	// No read access occurred in this subregion
	MWU_PERREGION_SUBSTATRA_SR21_NoAccess = 0x0
	// Read access(es) occurred in this subregion
	MWU_PERREGION_SUBSTATRA_SR21_Access = 0x1
	// Position of SR22 field.
	MWU_PERREGION_SUBSTATRA_SR22_Pos = 0x16
	// Bit mask of SR22 field.
	MWU_PERREGION_SUBSTATRA_SR22_Msk = 0x400000
	// Bit SR22.
	MWU_PERREGION_SUBSTATRA_SR22 = 0x400000
	// No read access occurred in this subregion
	MWU_PERREGION_SUBSTATRA_SR22_NoAccess = 0x0
	// Read access(es) occurred in this subregion
	MWU_PERREGION_SUBSTATRA_SR22_Access = 0x1
	// Position of SR23 field.
	MWU_PERREGION_SUBSTATRA_SR23_Pos = 0x17
	// Bit mask of SR23 field.
	MWU_PERREGION_SUBSTATRA_SR23_Msk = 0x800000
	// Bit SR23.
	MWU_PERREGION_SUBSTATRA_SR23 = 0x800000
	// No read access occurred in this subregion
	MWU_PERREGION_SUBSTATRA_SR23_NoAccess = 0x0
	// Read access(es) occurred in this subregion
	MWU_PERREGION_SUBSTATRA_SR23_Access = 0x1
	// Position of SR24 field.
	MWU_PERREGION_SUBSTATRA_SR24_Pos = 0x18
	// Bit mask of SR24 field.
	MWU_PERREGION_SUBSTATRA_SR24_Msk = 0x1000000
	// Bit SR24.
	MWU_PERREGION_SUBSTATRA_SR24 = 0x1000000
	// No read access occurred in this subregion
	MWU_PERREGION_SUBSTATRA_SR24_NoAccess = 0x0
	// Read access(es) occurred in this subregion
	MWU_PERREGION_SUBSTATRA_SR24_Access = 0x1
	// Position of SR25 field.
	MWU_PERREGION_SUBSTATRA_SR25_Pos = 0x19
	// Bit mask of SR25 field.
	MWU_PERREGION_SUBSTATRA_SR25_Msk = 0x2000000
	// Bit SR25.
	MWU_PERREGION_SUBSTATRA_SR25 = 0x2000000
	// No read access occurred in this subregion
	MWU_PERREGION_SUBSTATRA_SR25_NoAccess = 0x0
	// Read access(es) occurred in this subregion
	MWU_PERREGION_SUBSTATRA_SR25_Access = 0x1
	// Position of SR26 field.
	MWU_PERREGION_SUBSTATRA_SR26_Pos = 0x1a
	// Bit mask of SR26 field.
	MWU_PERREGION_SUBSTATRA_SR26_Msk = 0x4000000
	// Bit SR26.
	MWU_PERREGION_SUBSTATRA_SR26 = 0x4000000
	// No read access occurred in this subregion
	MWU_PERREGION_SUBSTATRA_SR26_NoAccess = 0x0
	// Read access(es) occurred in this subregion
	MWU_PERREGION_SUBSTATRA_SR26_Access = 0x1
	// Position of SR27 field.
	MWU_PERREGION_SUBSTATRA_SR27_Pos = 0x1b
	// Bit mask of SR27 field.
	MWU_PERREGION_SUBSTATRA_SR27_Msk = 0x8000000
	// Bit SR27.
	MWU_PERREGION_SUBSTATRA_SR27 = 0x8000000
	// No read access occurred in this subregion
	MWU_PERREGION_SUBSTATRA_SR27_NoAccess = 0x0
	// Read access(es) occurred in this subregion
	MWU_PERREGION_SUBSTATRA_SR27_Access = 0x1
	// Position of SR28 field.
	MWU_PERREGION_SUBSTATRA_SR28_Pos = 0x1c
	// Bit mask of SR28 field.
	MWU_PERREGION_SUBSTATRA_SR28_Msk = 0x10000000
	// Bit SR28.
	MWU_PERREGION_SUBSTATRA_SR28 = 0x10000000
	// No read access occurred in this subregion
	MWU_PERREGION_SUBSTATRA_SR28_NoAccess = 0x0
	// Read access(es) occurred in this subregion
	MWU_PERREGION_SUBSTATRA_SR28_Access = 0x1
	// Position of SR29 field.
	MWU_PERREGION_SUBSTATRA_SR29_Pos = 0x1d
	// Bit mask of SR29 field.
	MWU_PERREGION_SUBSTATRA_SR29_Msk = 0x20000000
	// Bit SR29.
	MWU_PERREGION_SUBSTATRA_SR29 = 0x20000000
	// No read access occurred in this subregion
	MWU_PERREGION_SUBSTATRA_SR29_NoAccess = 0x0
	// Read access(es) occurred in this subregion
	MWU_PERREGION_SUBSTATRA_SR29_Access = 0x1
	// Position of SR30 field.
	MWU_PERREGION_SUBSTATRA_SR30_Pos = 0x1e
	// Bit mask of SR30 field.
	MWU_PERREGION_SUBSTATRA_SR30_Msk = 0x40000000
	// Bit SR30.
	MWU_PERREGION_SUBSTATRA_SR30 = 0x40000000
	// No read access occurred in this subregion
	MWU_PERREGION_SUBSTATRA_SR30_NoAccess = 0x0
	// Read access(es) occurred in this subregion
	MWU_PERREGION_SUBSTATRA_SR30_Access = 0x1
	// Position of SR31 field.
	MWU_PERREGION_SUBSTATRA_SR31_Pos = 0x1f
	// Bit mask of SR31 field.
	MWU_PERREGION_SUBSTATRA_SR31_Msk = 0x80000000
	// Bit SR31.
	MWU_PERREGION_SUBSTATRA_SR31 = 0x80000000
	// No read access occurred in this subregion
	MWU_PERREGION_SUBSTATRA_SR31_NoAccess = 0x0
	// Read access(es) occurred in this subregion
	MWU_PERREGION_SUBSTATRA_SR31_Access = 0x1

	// REGIONEN: Enable/disable regions watch
	// Position of RGN0WA field.
	MWU_REGIONEN_RGN0WA_Pos = 0x0
	// Bit mask of RGN0WA field.
	MWU_REGIONEN_RGN0WA_Msk = 0x1
	// Bit RGN0WA.
	MWU_REGIONEN_RGN0WA = 0x1
	// Disable write access watch in this region
	MWU_REGIONEN_RGN0WA_Disable = 0x0
	// Enable write access watch in this region
	MWU_REGIONEN_RGN0WA_Enable = 0x1
	// Position of RGN0RA field.
	MWU_REGIONEN_RGN0RA_Pos = 0x1
	// Bit mask of RGN0RA field.
	MWU_REGIONEN_RGN0RA_Msk = 0x2
	// Bit RGN0RA.
	MWU_REGIONEN_RGN0RA = 0x2
	// Disable read access watch in this region
	MWU_REGIONEN_RGN0RA_Disable = 0x0
	// Enable read access watch in this region
	MWU_REGIONEN_RGN0RA_Enable = 0x1
	// Position of RGN1WA field.
	MWU_REGIONEN_RGN1WA_Pos = 0x2
	// Bit mask of RGN1WA field.
	MWU_REGIONEN_RGN1WA_Msk = 0x4
	// Bit RGN1WA.
	MWU_REGIONEN_RGN1WA = 0x4
	// Disable write access watch in this region
	MWU_REGIONEN_RGN1WA_Disable = 0x0
	// Enable write access watch in this region
	MWU_REGIONEN_RGN1WA_Enable = 0x1
	// Position of RGN1RA field.
	MWU_REGIONEN_RGN1RA_Pos = 0x3
	// Bit mask of RGN1RA field.
	MWU_REGIONEN_RGN1RA_Msk = 0x8
	// Bit RGN1RA.
	MWU_REGIONEN_RGN1RA = 0x8
	// Disable read access watch in this region
	MWU_REGIONEN_RGN1RA_Disable = 0x0
	// Enable read access watch in this region
	MWU_REGIONEN_RGN1RA_Enable = 0x1
	// Position of RGN2WA field.
	MWU_REGIONEN_RGN2WA_Pos = 0x4
	// Bit mask of RGN2WA field.
	MWU_REGIONEN_RGN2WA_Msk = 0x10
	// Bit RGN2WA.
	MWU_REGIONEN_RGN2WA = 0x10
	// Disable write access watch in this region
	MWU_REGIONEN_RGN2WA_Disable = 0x0
	// Enable write access watch in this region
	MWU_REGIONEN_RGN2WA_Enable = 0x1
	// Position of RGN2RA field.
	MWU_REGIONEN_RGN2RA_Pos = 0x5
	// Bit mask of RGN2RA field.
	MWU_REGIONEN_RGN2RA_Msk = 0x20
	// Bit RGN2RA.
	MWU_REGIONEN_RGN2RA = 0x20
	// Disable read access watch in this region
	MWU_REGIONEN_RGN2RA_Disable = 0x0
	// Enable read access watch in this region
	MWU_REGIONEN_RGN2RA_Enable = 0x1
	// Position of RGN3WA field.
	MWU_REGIONEN_RGN3WA_Pos = 0x6
	// Bit mask of RGN3WA field.
	MWU_REGIONEN_RGN3WA_Msk = 0x40
	// Bit RGN3WA.
	MWU_REGIONEN_RGN3WA = 0x40
	// Disable write access watch in this region
	MWU_REGIONEN_RGN3WA_Disable = 0x0
	// Enable write access watch in this region
	MWU_REGIONEN_RGN3WA_Enable = 0x1
	// Position of RGN3RA field.
	MWU_REGIONEN_RGN3RA_Pos = 0x7
	// Bit mask of RGN3RA field.
	MWU_REGIONEN_RGN3RA_Msk = 0x80
	// Bit RGN3RA.
	MWU_REGIONEN_RGN3RA = 0x80
	// Disable read access watch in this region
	MWU_REGIONEN_RGN3RA_Disable = 0x0
	// Enable read access watch in this region
	MWU_REGIONEN_RGN3RA_Enable = 0x1
	// Position of PRGN0WA field.
	MWU_REGIONEN_PRGN0WA_Pos = 0x18
	// Bit mask of PRGN0WA field.
	MWU_REGIONEN_PRGN0WA_Msk = 0x1000000
	// Bit PRGN0WA.
	MWU_REGIONEN_PRGN0WA = 0x1000000
	// Disable write access watch in this PREGION
	MWU_REGIONEN_PRGN0WA_Disable = 0x0
	// Enable write access watch in this PREGION
	MWU_REGIONEN_PRGN0WA_Enable = 0x1
	// Position of PRGN0RA field.
	MWU_REGIONEN_PRGN0RA_Pos = 0x19
	// Bit mask of PRGN0RA field.
	MWU_REGIONEN_PRGN0RA_Msk = 0x2000000
	// Bit PRGN0RA.
	MWU_REGIONEN_PRGN0RA = 0x2000000
	// Disable read access watch in this PREGION
	MWU_REGIONEN_PRGN0RA_Disable = 0x0
	// Enable read access watch in this PREGION
	MWU_REGIONEN_PRGN0RA_Enable = 0x1
	// Position of PRGN1WA field.
	MWU_REGIONEN_PRGN1WA_Pos = 0x1a
	// Bit mask of PRGN1WA field.
	MWU_REGIONEN_PRGN1WA_Msk = 0x4000000
	// Bit PRGN1WA.
	MWU_REGIONEN_PRGN1WA = 0x4000000
	// Disable write access watch in this PREGION
	MWU_REGIONEN_PRGN1WA_Disable = 0x0
	// Enable write access watch in this PREGION
	MWU_REGIONEN_PRGN1WA_Enable = 0x1
	// Position of PRGN1RA field.
	MWU_REGIONEN_PRGN1RA_Pos = 0x1b
	// Bit mask of PRGN1RA field.
	MWU_REGIONEN_PRGN1RA_Msk = 0x8000000
	// Bit PRGN1RA.
	MWU_REGIONEN_PRGN1RA = 0x8000000
	// Disable read access watch in this PREGION
	MWU_REGIONEN_PRGN1RA_Disable = 0x0
	// Enable read access watch in this PREGION
	MWU_REGIONEN_PRGN1RA_Enable = 0x1

	// REGIONENSET: Enable regions watch
	// Position of RGN0WA field.
	MWU_REGIONENSET_RGN0WA_Pos = 0x0
	// Bit mask of RGN0WA field.
	MWU_REGIONENSET_RGN0WA_Msk = 0x1
	// Bit RGN0WA.
	MWU_REGIONENSET_RGN0WA = 0x1
	// Write access watch in this region is disabled
	MWU_REGIONENSET_RGN0WA_Disabled = 0x0
	// Write access watch in this region is enabled
	MWU_REGIONENSET_RGN0WA_Enabled = 0x1
	// Enable write access watch in this region
	MWU_REGIONENSET_RGN0WA_Set = 0x1
	// Position of RGN0RA field.
	MWU_REGIONENSET_RGN0RA_Pos = 0x1
	// Bit mask of RGN0RA field.
	MWU_REGIONENSET_RGN0RA_Msk = 0x2
	// Bit RGN0RA.
	MWU_REGIONENSET_RGN0RA = 0x2
	// Read access watch in this region is disabled
	MWU_REGIONENSET_RGN0RA_Disabled = 0x0
	// Read access watch in this region is enabled
	MWU_REGIONENSET_RGN0RA_Enabled = 0x1
	// Enable read access watch in this region
	MWU_REGIONENSET_RGN0RA_Set = 0x1
	// Position of RGN1WA field.
	MWU_REGIONENSET_RGN1WA_Pos = 0x2
	// Bit mask of RGN1WA field.
	MWU_REGIONENSET_RGN1WA_Msk = 0x4
	// Bit RGN1WA.
	MWU_REGIONENSET_RGN1WA = 0x4
	// Write access watch in this region is disabled
	MWU_REGIONENSET_RGN1WA_Disabled = 0x0
	// Write access watch in this region is enabled
	MWU_REGIONENSET_RGN1WA_Enabled = 0x1
	// Enable write access watch in this region
	MWU_REGIONENSET_RGN1WA_Set = 0x1
	// Position of RGN1RA field.
	MWU_REGIONENSET_RGN1RA_Pos = 0x3
	// Bit mask of RGN1RA field.
	MWU_REGIONENSET_RGN1RA_Msk = 0x8
	// Bit RGN1RA.
	MWU_REGIONENSET_RGN1RA = 0x8
	// Read access watch in this region is disabled
	MWU_REGIONENSET_RGN1RA_Disabled = 0x0
	// Read access watch in this region is enabled
	MWU_REGIONENSET_RGN1RA_Enabled = 0x1
	// Enable read access watch in this region
	MWU_REGIONENSET_RGN1RA_Set = 0x1
	// Position of RGN2WA field.
	MWU_REGIONENSET_RGN2WA_Pos = 0x4
	// Bit mask of RGN2WA field.
	MWU_REGIONENSET_RGN2WA_Msk = 0x10
	// Bit RGN2WA.
	MWU_REGIONENSET_RGN2WA = 0x10
	// Write access watch in this region is disabled
	MWU_REGIONENSET_RGN2WA_Disabled = 0x0
	// Write access watch in this region is enabled
	MWU_REGIONENSET_RGN2WA_Enabled = 0x1
	// Enable write access watch in this region
	MWU_REGIONENSET_RGN2WA_Set = 0x1
	// Position of RGN2RA field.
	MWU_REGIONENSET_RGN2RA_Pos = 0x5
	// Bit mask of RGN2RA field.
	MWU_REGIONENSET_RGN2RA_Msk = 0x20
	// Bit RGN2RA.
	MWU_REGIONENSET_RGN2RA = 0x20
	// Read access watch in this region is disabled
	MWU_REGIONENSET_RGN2RA_Disabled = 0x0
	// Read access watch in this region is enabled
	MWU_REGIONENSET_RGN2RA_Enabled = 0x1
	// Enable read access watch in this region
	MWU_REGIONENSET_RGN2RA_Set = 0x1
	// Position of RGN3WA field.
	MWU_REGIONENSET_RGN3WA_Pos = 0x6
	// Bit mask of RGN3WA field.
	MWU_REGIONENSET_RGN3WA_Msk = 0x40
	// Bit RGN3WA.
	MWU_REGIONENSET_RGN3WA = 0x40
	// Write access watch in this region is disabled
	MWU_REGIONENSET_RGN3WA_Disabled = 0x0
	// Write access watch in this region is enabled
	MWU_REGIONENSET_RGN3WA_Enabled = 0x1
	// Enable write access watch in this region
	MWU_REGIONENSET_RGN3WA_Set = 0x1
	// Position of RGN3RA field.
	MWU_REGIONENSET_RGN3RA_Pos = 0x7
	// Bit mask of RGN3RA field.
	MWU_REGIONENSET_RGN3RA_Msk = 0x80
	// Bit RGN3RA.
	MWU_REGIONENSET_RGN3RA = 0x80
	// Read access watch in this region is disabled
	MWU_REGIONENSET_RGN3RA_Disabled = 0x0
	// Read access watch in this region is enabled
	MWU_REGIONENSET_RGN3RA_Enabled = 0x1
	// Enable read access watch in this region
	MWU_REGIONENSET_RGN3RA_Set = 0x1
	// Position of PRGN0WA field.
	MWU_REGIONENSET_PRGN0WA_Pos = 0x18
	// Bit mask of PRGN0WA field.
	MWU_REGIONENSET_PRGN0WA_Msk = 0x1000000
	// Bit PRGN0WA.
	MWU_REGIONENSET_PRGN0WA = 0x1000000
	// Write access watch in this PREGION is disabled
	MWU_REGIONENSET_PRGN0WA_Disabled = 0x0
	// Write access watch in this PREGION is enabled
	MWU_REGIONENSET_PRGN0WA_Enabled = 0x1
	// Enable write access watch in this PREGION
	MWU_REGIONENSET_PRGN0WA_Set = 0x1
	// Position of PRGN0RA field.
	MWU_REGIONENSET_PRGN0RA_Pos = 0x19
	// Bit mask of PRGN0RA field.
	MWU_REGIONENSET_PRGN0RA_Msk = 0x2000000
	// Bit PRGN0RA.
	MWU_REGIONENSET_PRGN0RA = 0x2000000
	// Read access watch in this PREGION is disabled
	MWU_REGIONENSET_PRGN0RA_Disabled = 0x0
	// Read access watch in this PREGION is enabled
	MWU_REGIONENSET_PRGN0RA_Enabled = 0x1
	// Enable read access watch in this PREGION
	MWU_REGIONENSET_PRGN0RA_Set = 0x1
	// Position of PRGN1WA field.
	MWU_REGIONENSET_PRGN1WA_Pos = 0x1a
	// Bit mask of PRGN1WA field.
	MWU_REGIONENSET_PRGN1WA_Msk = 0x4000000
	// Bit PRGN1WA.
	MWU_REGIONENSET_PRGN1WA = 0x4000000
	// Write access watch in this PREGION is disabled
	MWU_REGIONENSET_PRGN1WA_Disabled = 0x0
	// Write access watch in this PREGION is enabled
	MWU_REGIONENSET_PRGN1WA_Enabled = 0x1
	// Enable write access watch in this PREGION
	MWU_REGIONENSET_PRGN1WA_Set = 0x1
	// Position of PRGN1RA field.
	MWU_REGIONENSET_PRGN1RA_Pos = 0x1b
	// Bit mask of PRGN1RA field.
	MWU_REGIONENSET_PRGN1RA_Msk = 0x8000000
	// Bit PRGN1RA.
	MWU_REGIONENSET_PRGN1RA = 0x8000000
	// Read access watch in this PREGION is disabled
	MWU_REGIONENSET_PRGN1RA_Disabled = 0x0
	// Read access watch in this PREGION is enabled
	MWU_REGIONENSET_PRGN1RA_Enabled = 0x1
	// Enable read access watch in this PREGION
	MWU_REGIONENSET_PRGN1RA_Set = 0x1

	// REGIONENCLR: Disable regions watch
	// Position of RGN0WA field.
	MWU_REGIONENCLR_RGN0WA_Pos = 0x0
	// Bit mask of RGN0WA field.
	MWU_REGIONENCLR_RGN0WA_Msk = 0x1
	// Bit RGN0WA.
	MWU_REGIONENCLR_RGN0WA = 0x1
	// Write access watch in this region is disabled
	MWU_REGIONENCLR_RGN0WA_Disabled = 0x0
	// Write access watch in this region is enabled
	MWU_REGIONENCLR_RGN0WA_Enabled = 0x1
	// Disable write access watch in this region
	MWU_REGIONENCLR_RGN0WA_Clear = 0x1
	// Position of RGN0RA field.
	MWU_REGIONENCLR_RGN0RA_Pos = 0x1
	// Bit mask of RGN0RA field.
	MWU_REGIONENCLR_RGN0RA_Msk = 0x2
	// Bit RGN0RA.
	MWU_REGIONENCLR_RGN0RA = 0x2
	// Read access watch in this region is disabled
	MWU_REGIONENCLR_RGN0RA_Disabled = 0x0
	// Read access watch in this region is enabled
	MWU_REGIONENCLR_RGN0RA_Enabled = 0x1
	// Disable read access watch in this region
	MWU_REGIONENCLR_RGN0RA_Clear = 0x1
	// Position of RGN1WA field.
	MWU_REGIONENCLR_RGN1WA_Pos = 0x2
	// Bit mask of RGN1WA field.
	MWU_REGIONENCLR_RGN1WA_Msk = 0x4
	// Bit RGN1WA.
	MWU_REGIONENCLR_RGN1WA = 0x4
	// Write access watch in this region is disabled
	MWU_REGIONENCLR_RGN1WA_Disabled = 0x0
	// Write access watch in this region is enabled
	MWU_REGIONENCLR_RGN1WA_Enabled = 0x1
	// Disable write access watch in this region
	MWU_REGIONENCLR_RGN1WA_Clear = 0x1
	// Position of RGN1RA field.
	MWU_REGIONENCLR_RGN1RA_Pos = 0x3
	// Bit mask of RGN1RA field.
	MWU_REGIONENCLR_RGN1RA_Msk = 0x8
	// Bit RGN1RA.
	MWU_REGIONENCLR_RGN1RA = 0x8
	// Read access watch in this region is disabled
	MWU_REGIONENCLR_RGN1RA_Disabled = 0x0
	// Read access watch in this region is enabled
	MWU_REGIONENCLR_RGN1RA_Enabled = 0x1
	// Disable read access watch in this region
	MWU_REGIONENCLR_RGN1RA_Clear = 0x1
	// Position of RGN2WA field.
	MWU_REGIONENCLR_RGN2WA_Pos = 0x4
	// Bit mask of RGN2WA field.
	MWU_REGIONENCLR_RGN2WA_Msk = 0x10
	// Bit RGN2WA.
	MWU_REGIONENCLR_RGN2WA = 0x10
	// Write access watch in this region is disabled
	MWU_REGIONENCLR_RGN2WA_Disabled = 0x0
	// Write access watch in this region is enabled
	MWU_REGIONENCLR_RGN2WA_Enabled = 0x1
	// Disable write access watch in this region
	MWU_REGIONENCLR_RGN2WA_Clear = 0x1
	// Position of RGN2RA field.
	MWU_REGIONENCLR_RGN2RA_Pos = 0x5
	// Bit mask of RGN2RA field.
	MWU_REGIONENCLR_RGN2RA_Msk = 0x20
	// Bit RGN2RA.
	MWU_REGIONENCLR_RGN2RA = 0x20
	// Read access watch in this region is disabled
	MWU_REGIONENCLR_RGN2RA_Disabled = 0x0
	// Read access watch in this region is enabled
	MWU_REGIONENCLR_RGN2RA_Enabled = 0x1
	// Disable read access watch in this region
	MWU_REGIONENCLR_RGN2RA_Clear = 0x1
	// Position of RGN3WA field.
	MWU_REGIONENCLR_RGN3WA_Pos = 0x6
	// Bit mask of RGN3WA field.
	MWU_REGIONENCLR_RGN3WA_Msk = 0x40
	// Bit RGN3WA.
	MWU_REGIONENCLR_RGN3WA = 0x40
	// Write access watch in this region is disabled
	MWU_REGIONENCLR_RGN3WA_Disabled = 0x0
	// Write access watch in this region is enabled
	MWU_REGIONENCLR_RGN3WA_Enabled = 0x1
	// Disable write access watch in this region
	MWU_REGIONENCLR_RGN3WA_Clear = 0x1
	// Position of RGN3RA field.
	MWU_REGIONENCLR_RGN3RA_Pos = 0x7
	// Bit mask of RGN3RA field.
	MWU_REGIONENCLR_RGN3RA_Msk = 0x80
	// Bit RGN3RA.
	MWU_REGIONENCLR_RGN3RA = 0x80
	// Read access watch in this region is disabled
	MWU_REGIONENCLR_RGN3RA_Disabled = 0x0
	// Read access watch in this region is enabled
	MWU_REGIONENCLR_RGN3RA_Enabled = 0x1
	// Disable read access watch in this region
	MWU_REGIONENCLR_RGN3RA_Clear = 0x1
	// Position of PRGN0WA field.
	MWU_REGIONENCLR_PRGN0WA_Pos = 0x18
	// Bit mask of PRGN0WA field.
	MWU_REGIONENCLR_PRGN0WA_Msk = 0x1000000
	// Bit PRGN0WA.
	MWU_REGIONENCLR_PRGN0WA = 0x1000000
	// Write access watch in this PREGION is disabled
	MWU_REGIONENCLR_PRGN0WA_Disabled = 0x0
	// Write access watch in this PREGION is enabled
	MWU_REGIONENCLR_PRGN0WA_Enabled = 0x1
	// Disable write access watch in this PREGION
	MWU_REGIONENCLR_PRGN0WA_Clear = 0x1
	// Position of PRGN0RA field.
	MWU_REGIONENCLR_PRGN0RA_Pos = 0x19
	// Bit mask of PRGN0RA field.
	MWU_REGIONENCLR_PRGN0RA_Msk = 0x2000000
	// Bit PRGN0RA.
	MWU_REGIONENCLR_PRGN0RA = 0x2000000
	// Read access watch in this PREGION is disabled
	MWU_REGIONENCLR_PRGN0RA_Disabled = 0x0
	// Read access watch in this PREGION is enabled
	MWU_REGIONENCLR_PRGN0RA_Enabled = 0x1
	// Disable read access watch in this PREGION
	MWU_REGIONENCLR_PRGN0RA_Clear = 0x1
	// Position of PRGN1WA field.
	MWU_REGIONENCLR_PRGN1WA_Pos = 0x1a
	// Bit mask of PRGN1WA field.
	MWU_REGIONENCLR_PRGN1WA_Msk = 0x4000000
	// Bit PRGN1WA.
	MWU_REGIONENCLR_PRGN1WA = 0x4000000
	// Write access watch in this PREGION is disabled
	MWU_REGIONENCLR_PRGN1WA_Disabled = 0x0
	// Write access watch in this PREGION is enabled
	MWU_REGIONENCLR_PRGN1WA_Enabled = 0x1
	// Disable write access watch in this PREGION
	MWU_REGIONENCLR_PRGN1WA_Clear = 0x1
	// Position of PRGN1RA field.
	MWU_REGIONENCLR_PRGN1RA_Pos = 0x1b
	// Bit mask of PRGN1RA field.
	MWU_REGIONENCLR_PRGN1RA_Msk = 0x8000000
	// Bit PRGN1RA.
	MWU_REGIONENCLR_PRGN1RA = 0x8000000
	// Read access watch in this PREGION is disabled
	MWU_REGIONENCLR_PRGN1RA_Disabled = 0x0
	// Read access watch in this PREGION is enabled
	MWU_REGIONENCLR_PRGN1RA_Enabled = 0x1
	// Disable read access watch in this PREGION
	MWU_REGIONENCLR_PRGN1RA_Clear = 0x1

	// REGION.START: Description cluster: Start address for region n
	// Position of START field.
	MWU_REGION_START_START_Pos = 0x0
	// Bit mask of START field.
	MWU_REGION_START_START_Msk = 0xffffffff

	// REGION.END: Description cluster: End address of region n
	// Position of END field.
	MWU_REGION_END_END_Pos = 0x0
	// Bit mask of END field.
	MWU_REGION_END_END_Msk = 0xffffffff

	// PREGION.START: Description cluster: Reserved for future use
	// Position of START field.
	MWU_PREGION_START_START_Pos = 0x0
	// Bit mask of START field.
	MWU_PREGION_START_START_Msk = 0xffffffff

	// PREGION.END: Description cluster: Reserved for future use
	// Position of END field.
	MWU_PREGION_END_END_Pos = 0x0
	// Bit mask of END field.
	MWU_PREGION_END_END_Msk = 0xffffffff

	// PREGION.SUBS: Description cluster: Subregions of region n
	// Position of SR0 field.
	MWU_PREGION_SUBS_SR0_Pos = 0x0
	// Bit mask of SR0 field.
	MWU_PREGION_SUBS_SR0_Msk = 0x1
	// Bit SR0.
	MWU_PREGION_SUBS_SR0 = 0x1
	// Exclude
	MWU_PREGION_SUBS_SR0_Exclude = 0x0
	// Include
	MWU_PREGION_SUBS_SR0_Include = 0x1
	// Position of SR1 field.
	MWU_PREGION_SUBS_SR1_Pos = 0x1
	// Bit mask of SR1 field.
	MWU_PREGION_SUBS_SR1_Msk = 0x2
	// Bit SR1.
	MWU_PREGION_SUBS_SR1 = 0x2
	// Exclude
	MWU_PREGION_SUBS_SR1_Exclude = 0x0
	// Include
	MWU_PREGION_SUBS_SR1_Include = 0x1
	// Position of SR2 field.
	MWU_PREGION_SUBS_SR2_Pos = 0x2
	// Bit mask of SR2 field.
	MWU_PREGION_SUBS_SR2_Msk = 0x4
	// Bit SR2.
	MWU_PREGION_SUBS_SR2 = 0x4
	// Exclude
	MWU_PREGION_SUBS_SR2_Exclude = 0x0
	// Include
	MWU_PREGION_SUBS_SR2_Include = 0x1
	// Position of SR3 field.
	MWU_PREGION_SUBS_SR3_Pos = 0x3
	// Bit mask of SR3 field.
	MWU_PREGION_SUBS_SR3_Msk = 0x8
	// Bit SR3.
	MWU_PREGION_SUBS_SR3 = 0x8
	// Exclude
	MWU_PREGION_SUBS_SR3_Exclude = 0x0
	// Include
	MWU_PREGION_SUBS_SR3_Include = 0x1
	// Position of SR4 field.
	MWU_PREGION_SUBS_SR4_Pos = 0x4
	// Bit mask of SR4 field.
	MWU_PREGION_SUBS_SR4_Msk = 0x10
	// Bit SR4.
	MWU_PREGION_SUBS_SR4 = 0x10
	// Exclude
	MWU_PREGION_SUBS_SR4_Exclude = 0x0
	// Include
	MWU_PREGION_SUBS_SR4_Include = 0x1
	// Position of SR5 field.
	MWU_PREGION_SUBS_SR5_Pos = 0x5
	// Bit mask of SR5 field.
	MWU_PREGION_SUBS_SR5_Msk = 0x20
	// Bit SR5.
	MWU_PREGION_SUBS_SR5 = 0x20
	// Exclude
	MWU_PREGION_SUBS_SR5_Exclude = 0x0
	// Include
	MWU_PREGION_SUBS_SR5_Include = 0x1
	// Position of SR6 field.
	MWU_PREGION_SUBS_SR6_Pos = 0x6
	// Bit mask of SR6 field.
	MWU_PREGION_SUBS_SR6_Msk = 0x40
	// Bit SR6.
	MWU_PREGION_SUBS_SR6 = 0x40
	// Exclude
	MWU_PREGION_SUBS_SR6_Exclude = 0x0
	// Include
	MWU_PREGION_SUBS_SR6_Include = 0x1
	// Position of SR7 field.
	MWU_PREGION_SUBS_SR7_Pos = 0x7
	// Bit mask of SR7 field.
	MWU_PREGION_SUBS_SR7_Msk = 0x80
	// Bit SR7.
	MWU_PREGION_SUBS_SR7 = 0x80
	// Exclude
	MWU_PREGION_SUBS_SR7_Exclude = 0x0
	// Include
	MWU_PREGION_SUBS_SR7_Include = 0x1
	// Position of SR8 field.
	MWU_PREGION_SUBS_SR8_Pos = 0x8
	// Bit mask of SR8 field.
	MWU_PREGION_SUBS_SR8_Msk = 0x100
	// Bit SR8.
	MWU_PREGION_SUBS_SR8 = 0x100
	// Exclude
	MWU_PREGION_SUBS_SR8_Exclude = 0x0
	// Include
	MWU_PREGION_SUBS_SR8_Include = 0x1
	// Position of SR9 field.
	MWU_PREGION_SUBS_SR9_Pos = 0x9
	// Bit mask of SR9 field.
	MWU_PREGION_SUBS_SR9_Msk = 0x200
	// Bit SR9.
	MWU_PREGION_SUBS_SR9 = 0x200
	// Exclude
	MWU_PREGION_SUBS_SR9_Exclude = 0x0
	// Include
	MWU_PREGION_SUBS_SR9_Include = 0x1
	// Position of SR10 field.
	MWU_PREGION_SUBS_SR10_Pos = 0xa
	// Bit mask of SR10 field.
	MWU_PREGION_SUBS_SR10_Msk = 0x400
	// Bit SR10.
	MWU_PREGION_SUBS_SR10 = 0x400
	// Exclude
	MWU_PREGION_SUBS_SR10_Exclude = 0x0
	// Include
	MWU_PREGION_SUBS_SR10_Include = 0x1
	// Position of SR11 field.
	MWU_PREGION_SUBS_SR11_Pos = 0xb
	// Bit mask of SR11 field.
	MWU_PREGION_SUBS_SR11_Msk = 0x800
	// Bit SR11.
	MWU_PREGION_SUBS_SR11 = 0x800
	// Exclude
	MWU_PREGION_SUBS_SR11_Exclude = 0x0
	// Include
	MWU_PREGION_SUBS_SR11_Include = 0x1
	// Position of SR12 field.
	MWU_PREGION_SUBS_SR12_Pos = 0xc
	// Bit mask of SR12 field.
	MWU_PREGION_SUBS_SR12_Msk = 0x1000
	// Bit SR12.
	MWU_PREGION_SUBS_SR12 = 0x1000
	// Exclude
	MWU_PREGION_SUBS_SR12_Exclude = 0x0
	// Include
	MWU_PREGION_SUBS_SR12_Include = 0x1
	// Position of SR13 field.
	MWU_PREGION_SUBS_SR13_Pos = 0xd
	// Bit mask of SR13 field.
	MWU_PREGION_SUBS_SR13_Msk = 0x2000
	// Bit SR13.
	MWU_PREGION_SUBS_SR13 = 0x2000
	// Exclude
	MWU_PREGION_SUBS_SR13_Exclude = 0x0
	// Include
	MWU_PREGION_SUBS_SR13_Include = 0x1
	// Position of SR14 field.
	MWU_PREGION_SUBS_SR14_Pos = 0xe
	// Bit mask of SR14 field.
	MWU_PREGION_SUBS_SR14_Msk = 0x4000
	// Bit SR14.
	MWU_PREGION_SUBS_SR14 = 0x4000
	// Exclude
	MWU_PREGION_SUBS_SR14_Exclude = 0x0
	// Include
	MWU_PREGION_SUBS_SR14_Include = 0x1
	// Position of SR15 field.
	MWU_PREGION_SUBS_SR15_Pos = 0xf
	// Bit mask of SR15 field.
	MWU_PREGION_SUBS_SR15_Msk = 0x8000
	// Bit SR15.
	MWU_PREGION_SUBS_SR15 = 0x8000
	// Exclude
	MWU_PREGION_SUBS_SR15_Exclude = 0x0
	// Include
	MWU_PREGION_SUBS_SR15_Include = 0x1
	// Position of SR16 field.
	MWU_PREGION_SUBS_SR16_Pos = 0x10
	// Bit mask of SR16 field.
	MWU_PREGION_SUBS_SR16_Msk = 0x10000
	// Bit SR16.
	MWU_PREGION_SUBS_SR16 = 0x10000
	// Exclude
	MWU_PREGION_SUBS_SR16_Exclude = 0x0
	// Include
	MWU_PREGION_SUBS_SR16_Include = 0x1
	// Position of SR17 field.
	MWU_PREGION_SUBS_SR17_Pos = 0x11
	// Bit mask of SR17 field.
	MWU_PREGION_SUBS_SR17_Msk = 0x20000
	// Bit SR17.
	MWU_PREGION_SUBS_SR17 = 0x20000
	// Exclude
	MWU_PREGION_SUBS_SR17_Exclude = 0x0
	// Include
	MWU_PREGION_SUBS_SR17_Include = 0x1
	// Position of SR18 field.
	MWU_PREGION_SUBS_SR18_Pos = 0x12
	// Bit mask of SR18 field.
	MWU_PREGION_SUBS_SR18_Msk = 0x40000
	// Bit SR18.
	MWU_PREGION_SUBS_SR18 = 0x40000
	// Exclude
	MWU_PREGION_SUBS_SR18_Exclude = 0x0
	// Include
	MWU_PREGION_SUBS_SR18_Include = 0x1
	// Position of SR19 field.
	MWU_PREGION_SUBS_SR19_Pos = 0x13
	// Bit mask of SR19 field.
	MWU_PREGION_SUBS_SR19_Msk = 0x80000
	// Bit SR19.
	MWU_PREGION_SUBS_SR19 = 0x80000
	// Exclude
	MWU_PREGION_SUBS_SR19_Exclude = 0x0
	// Include
	MWU_PREGION_SUBS_SR19_Include = 0x1
	// Position of SR20 field.
	MWU_PREGION_SUBS_SR20_Pos = 0x14
	// Bit mask of SR20 field.
	MWU_PREGION_SUBS_SR20_Msk = 0x100000
	// Bit SR20.
	MWU_PREGION_SUBS_SR20 = 0x100000
	// Exclude
	MWU_PREGION_SUBS_SR20_Exclude = 0x0
	// Include
	MWU_PREGION_SUBS_SR20_Include = 0x1
	// Position of SR21 field.
	MWU_PREGION_SUBS_SR21_Pos = 0x15
	// Bit mask of SR21 field.
	MWU_PREGION_SUBS_SR21_Msk = 0x200000
	// Bit SR21.
	MWU_PREGION_SUBS_SR21 = 0x200000
	// Exclude
	MWU_PREGION_SUBS_SR21_Exclude = 0x0
	// Include
	MWU_PREGION_SUBS_SR21_Include = 0x1
	// Position of SR22 field.
	MWU_PREGION_SUBS_SR22_Pos = 0x16
	// Bit mask of SR22 field.
	MWU_PREGION_SUBS_SR22_Msk = 0x400000
	// Bit SR22.
	MWU_PREGION_SUBS_SR22 = 0x400000
	// Exclude
	MWU_PREGION_SUBS_SR22_Exclude = 0x0
	// Include
	MWU_PREGION_SUBS_SR22_Include = 0x1
	// Position of SR23 field.
	MWU_PREGION_SUBS_SR23_Pos = 0x17
	// Bit mask of SR23 field.
	MWU_PREGION_SUBS_SR23_Msk = 0x800000
	// Bit SR23.
	MWU_PREGION_SUBS_SR23 = 0x800000
	// Exclude
	MWU_PREGION_SUBS_SR23_Exclude = 0x0
	// Include
	MWU_PREGION_SUBS_SR23_Include = 0x1
	// Position of SR24 field.
	MWU_PREGION_SUBS_SR24_Pos = 0x18
	// Bit mask of SR24 field.
	MWU_PREGION_SUBS_SR24_Msk = 0x1000000
	// Bit SR24.
	MWU_PREGION_SUBS_SR24 = 0x1000000
	// Exclude
	MWU_PREGION_SUBS_SR24_Exclude = 0x0
	// Include
	MWU_PREGION_SUBS_SR24_Include = 0x1
	// Position of SR25 field.
	MWU_PREGION_SUBS_SR25_Pos = 0x19
	// Bit mask of SR25 field.
	MWU_PREGION_SUBS_SR25_Msk = 0x2000000
	// Bit SR25.
	MWU_PREGION_SUBS_SR25 = 0x2000000
	// Exclude
	MWU_PREGION_SUBS_SR25_Exclude = 0x0
	// Include
	MWU_PREGION_SUBS_SR25_Include = 0x1
	// Position of SR26 field.
	MWU_PREGION_SUBS_SR26_Pos = 0x1a
	// Bit mask of SR26 field.
	MWU_PREGION_SUBS_SR26_Msk = 0x4000000
	// Bit SR26.
	MWU_PREGION_SUBS_SR26 = 0x4000000
	// Exclude
	MWU_PREGION_SUBS_SR26_Exclude = 0x0
	// Include
	MWU_PREGION_SUBS_SR26_Include = 0x1
	// Position of SR27 field.
	MWU_PREGION_SUBS_SR27_Pos = 0x1b
	// Bit mask of SR27 field.
	MWU_PREGION_SUBS_SR27_Msk = 0x8000000
	// Bit SR27.
	MWU_PREGION_SUBS_SR27 = 0x8000000
	// Exclude
	MWU_PREGION_SUBS_SR27_Exclude = 0x0
	// Include
	MWU_PREGION_SUBS_SR27_Include = 0x1
	// Position of SR28 field.
	MWU_PREGION_SUBS_SR28_Pos = 0x1c
	// Bit mask of SR28 field.
	MWU_PREGION_SUBS_SR28_Msk = 0x10000000
	// Bit SR28.
	MWU_PREGION_SUBS_SR28 = 0x10000000
	// Exclude
	MWU_PREGION_SUBS_SR28_Exclude = 0x0
	// Include
	MWU_PREGION_SUBS_SR28_Include = 0x1
	// Position of SR29 field.
	MWU_PREGION_SUBS_SR29_Pos = 0x1d
	// Bit mask of SR29 field.
	MWU_PREGION_SUBS_SR29_Msk = 0x20000000
	// Bit SR29.
	MWU_PREGION_SUBS_SR29 = 0x20000000
	// Exclude
	MWU_PREGION_SUBS_SR29_Exclude = 0x0
	// Include
	MWU_PREGION_SUBS_SR29_Include = 0x1
	// Position of SR30 field.
	MWU_PREGION_SUBS_SR30_Pos = 0x1e
	// Bit mask of SR30 field.
	MWU_PREGION_SUBS_SR30_Msk = 0x40000000
	// Bit SR30.
	MWU_PREGION_SUBS_SR30 = 0x40000000
	// Exclude
	MWU_PREGION_SUBS_SR30_Exclude = 0x0
	// Include
	MWU_PREGION_SUBS_SR30_Include = 0x1
	// Position of SR31 field.
	MWU_PREGION_SUBS_SR31_Pos = 0x1f
	// Bit mask of SR31 field.
	MWU_PREGION_SUBS_SR31_Msk = 0x80000000
	// Bit SR31.
	MWU_PREGION_SUBS_SR31 = 0x80000000
	// Exclude
	MWU_PREGION_SUBS_SR31_Exclude = 0x0
	// Include
	MWU_PREGION_SUBS_SR31_Include = 0x1
)

// Bitfields for I2S: Inter-IC Sound
const (
	// TASKS_START: Starts continuous I2S transfer. Also starts MCK generator when this is enabled.
	// Position of TASKS_START field.
	I2S_TASKS_START_TASKS_START_Pos = 0x0
	// Bit mask of TASKS_START field.
	I2S_TASKS_START_TASKS_START_Msk = 0x1
	// Bit TASKS_START.
	I2S_TASKS_START_TASKS_START = 0x1
	// Trigger task
	I2S_TASKS_START_TASKS_START_Trigger = 0x1

	// TASKS_STOP: Stops I2S transfer. Also stops MCK generator. Triggering this task will cause the STOPPED event to be generated.
	// Position of TASKS_STOP field.
	I2S_TASKS_STOP_TASKS_STOP_Pos = 0x0
	// Bit mask of TASKS_STOP field.
	I2S_TASKS_STOP_TASKS_STOP_Msk = 0x1
	// Bit TASKS_STOP.
	I2S_TASKS_STOP_TASKS_STOP = 0x1
	// Trigger task
	I2S_TASKS_STOP_TASKS_STOP_Trigger = 0x1

	// EVENTS_RXPTRUPD: The RXD.PTR register has been copied to internal double-buffers. When the I2S module is started and RX is enabled, this event will be generated for every RXTXD.MAXCNT words that are received on the SDIN pin.
	// Position of EVENTS_RXPTRUPD field.
	I2S_EVENTS_RXPTRUPD_EVENTS_RXPTRUPD_Pos = 0x0
	// Bit mask of EVENTS_RXPTRUPD field.
	I2S_EVENTS_RXPTRUPD_EVENTS_RXPTRUPD_Msk = 0x1
	// Bit EVENTS_RXPTRUPD.
	I2S_EVENTS_RXPTRUPD_EVENTS_RXPTRUPD = 0x1
	// Event not generated
	I2S_EVENTS_RXPTRUPD_EVENTS_RXPTRUPD_NotGenerated = 0x0
	// Event generated
	I2S_EVENTS_RXPTRUPD_EVENTS_RXPTRUPD_Generated = 0x1

	// EVENTS_STOPPED: I2S transfer stopped.
	// Position of EVENTS_STOPPED field.
	I2S_EVENTS_STOPPED_EVENTS_STOPPED_Pos = 0x0
	// Bit mask of EVENTS_STOPPED field.
	I2S_EVENTS_STOPPED_EVENTS_STOPPED_Msk = 0x1
	// Bit EVENTS_STOPPED.
	I2S_EVENTS_STOPPED_EVENTS_STOPPED = 0x1
	// Event not generated
	I2S_EVENTS_STOPPED_EVENTS_STOPPED_NotGenerated = 0x0
	// Event generated
	I2S_EVENTS_STOPPED_EVENTS_STOPPED_Generated = 0x1

	// EVENTS_TXPTRUPD: The TDX.PTR register has been copied to internal double-buffers. When the I2S module is started and TX is enabled, this event will be generated for every RXTXD.MAXCNT words that are sent on the SDOUT pin.
	// Position of EVENTS_TXPTRUPD field.
	I2S_EVENTS_TXPTRUPD_EVENTS_TXPTRUPD_Pos = 0x0
	// Bit mask of EVENTS_TXPTRUPD field.
	I2S_EVENTS_TXPTRUPD_EVENTS_TXPTRUPD_Msk = 0x1
	// Bit EVENTS_TXPTRUPD.
	I2S_EVENTS_TXPTRUPD_EVENTS_TXPTRUPD = 0x1
	// Event not generated
	I2S_EVENTS_TXPTRUPD_EVENTS_TXPTRUPD_NotGenerated = 0x0
	// Event generated
	I2S_EVENTS_TXPTRUPD_EVENTS_TXPTRUPD_Generated = 0x1

	// INTEN: Enable or disable interrupt
	// Position of RXPTRUPD field.
	I2S_INTEN_RXPTRUPD_Pos = 0x1
	// Bit mask of RXPTRUPD field.
	I2S_INTEN_RXPTRUPD_Msk = 0x2
	// Bit RXPTRUPD.
	I2S_INTEN_RXPTRUPD = 0x2
	// Disable
	I2S_INTEN_RXPTRUPD_Disabled = 0x0
	// Enable
	I2S_INTEN_RXPTRUPD_Enabled = 0x1
	// Position of STOPPED field.
	I2S_INTEN_STOPPED_Pos = 0x2
	// Bit mask of STOPPED field.
	I2S_INTEN_STOPPED_Msk = 0x4
	// Bit STOPPED.
	I2S_INTEN_STOPPED = 0x4
	// Disable
	I2S_INTEN_STOPPED_Disabled = 0x0
	// Enable
	I2S_INTEN_STOPPED_Enabled = 0x1
	// Position of TXPTRUPD field.
	I2S_INTEN_TXPTRUPD_Pos = 0x5
	// Bit mask of TXPTRUPD field.
	I2S_INTEN_TXPTRUPD_Msk = 0x20
	// Bit TXPTRUPD.
	I2S_INTEN_TXPTRUPD = 0x20
	// Disable
	I2S_INTEN_TXPTRUPD_Disabled = 0x0
	// Enable
	I2S_INTEN_TXPTRUPD_Enabled = 0x1

	// INTENSET: Enable interrupt
	// Position of RXPTRUPD field.
	I2S_INTENSET_RXPTRUPD_Pos = 0x1
	// Bit mask of RXPTRUPD field.
	I2S_INTENSET_RXPTRUPD_Msk = 0x2
	// Bit RXPTRUPD.
	I2S_INTENSET_RXPTRUPD = 0x2
	// Read: Disabled
	I2S_INTENSET_RXPTRUPD_Disabled = 0x0
	// Read: Enabled
	I2S_INTENSET_RXPTRUPD_Enabled = 0x1
	// Enable
	I2S_INTENSET_RXPTRUPD_Set = 0x1
	// Position of STOPPED field.
	I2S_INTENSET_STOPPED_Pos = 0x2
	// Bit mask of STOPPED field.
	I2S_INTENSET_STOPPED_Msk = 0x4
	// Bit STOPPED.
	I2S_INTENSET_STOPPED = 0x4
	// Read: Disabled
	I2S_INTENSET_STOPPED_Disabled = 0x0
	// Read: Enabled
	I2S_INTENSET_STOPPED_Enabled = 0x1
	// Enable
	I2S_INTENSET_STOPPED_Set = 0x1
	// Position of TXPTRUPD field.
	I2S_INTENSET_TXPTRUPD_Pos = 0x5
	// Bit mask of TXPTRUPD field.
	I2S_INTENSET_TXPTRUPD_Msk = 0x20
	// Bit TXPTRUPD.
	I2S_INTENSET_TXPTRUPD = 0x20
	// Read: Disabled
	I2S_INTENSET_TXPTRUPD_Disabled = 0x0
	// Read: Enabled
	I2S_INTENSET_TXPTRUPD_Enabled = 0x1
	// Enable
	I2S_INTENSET_TXPTRUPD_Set = 0x1

	// INTENCLR: Disable interrupt
	// Position of RXPTRUPD field.
	I2S_INTENCLR_RXPTRUPD_Pos = 0x1
	// Bit mask of RXPTRUPD field.
	I2S_INTENCLR_RXPTRUPD_Msk = 0x2
	// Bit RXPTRUPD.
	I2S_INTENCLR_RXPTRUPD = 0x2
	// Read: Disabled
	I2S_INTENCLR_RXPTRUPD_Disabled = 0x0
	// Read: Enabled
	I2S_INTENCLR_RXPTRUPD_Enabled = 0x1
	// Disable
	I2S_INTENCLR_RXPTRUPD_Clear = 0x1
	// Position of STOPPED field.
	I2S_INTENCLR_STOPPED_Pos = 0x2
	// Bit mask of STOPPED field.
	I2S_INTENCLR_STOPPED_Msk = 0x4
	// Bit STOPPED.
	I2S_INTENCLR_STOPPED = 0x4
	// Read: Disabled
	I2S_INTENCLR_STOPPED_Disabled = 0x0
	// Read: Enabled
	I2S_INTENCLR_STOPPED_Enabled = 0x1
	// Disable
	I2S_INTENCLR_STOPPED_Clear = 0x1
	// Position of TXPTRUPD field.
	I2S_INTENCLR_TXPTRUPD_Pos = 0x5
	// Bit mask of TXPTRUPD field.
	I2S_INTENCLR_TXPTRUPD_Msk = 0x20
	// Bit TXPTRUPD.
	I2S_INTENCLR_TXPTRUPD = 0x20
	// Read: Disabled
	I2S_INTENCLR_TXPTRUPD_Disabled = 0x0
	// Read: Enabled
	I2S_INTENCLR_TXPTRUPD_Enabled = 0x1
	// Disable
	I2S_INTENCLR_TXPTRUPD_Clear = 0x1

	// ENABLE: Enable I2S module.
	// Position of ENABLE field.
	I2S_ENABLE_ENABLE_Pos = 0x0
	// Bit mask of ENABLE field.
	I2S_ENABLE_ENABLE_Msk = 0x1
	// Bit ENABLE.
	I2S_ENABLE_ENABLE = 0x1
	// Disable
	I2S_ENABLE_ENABLE_Disabled = 0x0
	// Enable
	I2S_ENABLE_ENABLE_Enabled = 0x1

	// CONFIG.MODE: I2S mode.
	// Position of MODE field.
	I2S_CONFIG_MODE_MODE_Pos = 0x0
	// Bit mask of MODE field.
	I2S_CONFIG_MODE_MODE_Msk = 0x1
	// Bit MODE.
	I2S_CONFIG_MODE_MODE = 0x1
	// Master mode. SCK and LRCK generated from internal master clcok (MCK) and output on pins defined by PSEL.xxx.
	I2S_CONFIG_MODE_MODE_Master = 0x0
	// Slave mode. SCK and LRCK generated by external master and received on pins defined by PSEL.xxx
	I2S_CONFIG_MODE_MODE_Slave = 0x1

	// CONFIG.RXEN: Reception (RX) enable.
	// Position of RXEN field.
	I2S_CONFIG_RXEN_RXEN_Pos = 0x0
	// Bit mask of RXEN field.
	I2S_CONFIG_RXEN_RXEN_Msk = 0x1
	// Bit RXEN.
	I2S_CONFIG_RXEN_RXEN = 0x1
	// Reception disabled and now data will be written to the RXD.PTR address.
	I2S_CONFIG_RXEN_RXEN_Disabled = 0x0
	// Reception enabled.
	I2S_CONFIG_RXEN_RXEN_Enabled = 0x1

	// CONFIG.TXEN: Transmission (TX) enable.
	// Position of TXEN field.
	I2S_CONFIG_TXEN_TXEN_Pos = 0x0
	// Bit mask of TXEN field.
	I2S_CONFIG_TXEN_TXEN_Msk = 0x1
	// Bit TXEN.
	I2S_CONFIG_TXEN_TXEN = 0x1
	// Transmission disabled and now data will be read from the RXD.TXD address.
	I2S_CONFIG_TXEN_TXEN_Disabled = 0x0
	// Transmission enabled.
	I2S_CONFIG_TXEN_TXEN_Enabled = 0x1

	// CONFIG.MCKEN: Master clock generator enable.
	// Position of MCKEN field.
	I2S_CONFIG_MCKEN_MCKEN_Pos = 0x0
	// Bit mask of MCKEN field.
	I2S_CONFIG_MCKEN_MCKEN_Msk = 0x1
	// Bit MCKEN.
	I2S_CONFIG_MCKEN_MCKEN = 0x1
	// Master clock generator disabled and PSEL.MCK not connected(available as GPIO).
	I2S_CONFIG_MCKEN_MCKEN_Disabled = 0x0
	// Master clock generator running and MCK output on PSEL.MCK.
	I2S_CONFIG_MCKEN_MCKEN_Enabled = 0x1

	// CONFIG.MCKFREQ: Master clock generator frequency.
	// Position of MCKFREQ field.
	I2S_CONFIG_MCKFREQ_MCKFREQ_Pos = 0x0
	// Bit mask of MCKFREQ field.
	I2S_CONFIG_MCKFREQ_MCKFREQ_Msk = 0xffffffff
	// 32 MHz / 8 = 4.0 MHz
	I2S_CONFIG_MCKFREQ_MCKFREQ_32MDIV8 = 0x20000000
	// 32 MHz / 10 = 3.2 MHz
	I2S_CONFIG_MCKFREQ_MCKFREQ_32MDIV10 = 0x18000000
	// 32 MHz / 11 = 2.9090909 MHz
	I2S_CONFIG_MCKFREQ_MCKFREQ_32MDIV11 = 0x16000000
	// 32 MHz / 15 = 2.1333333 MHz
	I2S_CONFIG_MCKFREQ_MCKFREQ_32MDIV15 = 0x11000000
	// 32 MHz / 16 = 2.0 MHz
	I2S_CONFIG_MCKFREQ_MCKFREQ_32MDIV16 = 0x10000000
	// 32 MHz / 21 = 1.5238095
	I2S_CONFIG_MCKFREQ_MCKFREQ_32MDIV21 = 0xc000000
	// 32 MHz / 23 = 1.3913043 MHz
	I2S_CONFIG_MCKFREQ_MCKFREQ_32MDIV23 = 0xb000000
	// 32 MHz / 30 = 1.0666667 MHz
	I2S_CONFIG_MCKFREQ_MCKFREQ_32MDIV30 = 0x8800000
	// 32 MHz / 31 = 1.0322581 MHz
	I2S_CONFIG_MCKFREQ_MCKFREQ_32MDIV31 = 0x8400000
	// 32 MHz / 32 = 1.0 MHz
	I2S_CONFIG_MCKFREQ_MCKFREQ_32MDIV32 = 0x8000000
	// 32 MHz / 42 = 0.7619048 MHz
	I2S_CONFIG_MCKFREQ_MCKFREQ_32MDIV42 = 0x6000000
	// 32 MHz / 63 = 0.5079365 MHz
	I2S_CONFIG_MCKFREQ_MCKFREQ_32MDIV63 = 0x4100000
	// 32 MHz / 125 = 0.256 MHz
	I2S_CONFIG_MCKFREQ_MCKFREQ_32MDIV125 = 0x20c0000

	// CONFIG.RATIO: MCK / LRCK ratio.
	// Position of RATIO field.
	I2S_CONFIG_RATIO_RATIO_Pos = 0x0
	// Bit mask of RATIO field.
	I2S_CONFIG_RATIO_RATIO_Msk = 0xf
	// LRCK = MCK / 32
	I2S_CONFIG_RATIO_RATIO_32X = 0x0
	// LRCK = MCK / 48
	I2S_CONFIG_RATIO_RATIO_48X = 0x1
	// LRCK = MCK / 64
	I2S_CONFIG_RATIO_RATIO_64X = 0x2
	// LRCK = MCK / 96
	I2S_CONFIG_RATIO_RATIO_96X = 0x3
	// LRCK = MCK / 128
	I2S_CONFIG_RATIO_RATIO_128X = 0x4
	// LRCK = MCK / 192
	I2S_CONFIG_RATIO_RATIO_192X = 0x5
	// LRCK = MCK / 256
	I2S_CONFIG_RATIO_RATIO_256X = 0x6
	// LRCK = MCK / 384
	I2S_CONFIG_RATIO_RATIO_384X = 0x7
	// LRCK = MCK / 512
	I2S_CONFIG_RATIO_RATIO_512X = 0x8

	// CONFIG.SWIDTH: Sample width.
	// Position of SWIDTH field.
	I2S_CONFIG_SWIDTH_SWIDTH_Pos = 0x0
	// Bit mask of SWIDTH field.
	I2S_CONFIG_SWIDTH_SWIDTH_Msk = 0x3
	// 8 bit.
	I2S_CONFIG_SWIDTH_SWIDTH_8Bit = 0x0
	// 16 bit.
	I2S_CONFIG_SWIDTH_SWIDTH_16Bit = 0x1
	// 24 bit.
	I2S_CONFIG_SWIDTH_SWIDTH_24Bit = 0x2

	// CONFIG.ALIGN: Alignment of sample within a frame.
	// Position of ALIGN field.
	I2S_CONFIG_ALIGN_ALIGN_Pos = 0x0
	// Bit mask of ALIGN field.
	I2S_CONFIG_ALIGN_ALIGN_Msk = 0x1
	// Bit ALIGN.
	I2S_CONFIG_ALIGN_ALIGN = 0x1
	// Left-aligned.
	I2S_CONFIG_ALIGN_ALIGN_Left = 0x0
	// Right-aligned.
	I2S_CONFIG_ALIGN_ALIGN_Right = 0x1

	// CONFIG.FORMAT: Frame format.
	// Position of FORMAT field.
	I2S_CONFIG_FORMAT_FORMAT_Pos = 0x0
	// Bit mask of FORMAT field.
	I2S_CONFIG_FORMAT_FORMAT_Msk = 0x1
	// Bit FORMAT.
	I2S_CONFIG_FORMAT_FORMAT = 0x1
	// Original I2S format.
	I2S_CONFIG_FORMAT_FORMAT_I2S = 0x0
	// Alternate (left- or right-aligned) format.
	I2S_CONFIG_FORMAT_FORMAT_Aligned = 0x1

	// CONFIG.CHANNELS: Enable channels.
	// Position of CHANNELS field.
	I2S_CONFIG_CHANNELS_CHANNELS_Pos = 0x0
	// Bit mask of CHANNELS field.
	I2S_CONFIG_CHANNELS_CHANNELS_Msk = 0x3
	// Stereo.
	I2S_CONFIG_CHANNELS_CHANNELS_Stereo = 0x0
	// Left only.
	I2S_CONFIG_CHANNELS_CHANNELS_Left = 0x1
	// Right only.
	I2S_CONFIG_CHANNELS_CHANNELS_Right = 0x2

	// RXD.PTR: Receive buffer RAM start address.
	// Position of PTR field.
	I2S_RXD_PTR_PTR_Pos = 0x0
	// Bit mask of PTR field.
	I2S_RXD_PTR_PTR_Msk = 0xffffffff

	// TXD.PTR: Transmit buffer RAM start address.
	// Position of PTR field.
	I2S_TXD_PTR_PTR_Pos = 0x0
	// Bit mask of PTR field.
	I2S_TXD_PTR_PTR_Msk = 0xffffffff

	// RXTXD.MAXCNT: Size of RXD and TXD buffers.
	// Position of MAXCNT field.
	I2S_RXTXD_MAXCNT_MAXCNT_Pos = 0x0
	// Bit mask of MAXCNT field.
	I2S_RXTXD_MAXCNT_MAXCNT_Msk = 0x3fff

	// PSEL.MCK: Pin select for MCK signal.
	// Position of PIN field.
	I2S_PSEL_MCK_PIN_Pos = 0x0
	// Bit mask of PIN field.
	I2S_PSEL_MCK_PIN_Msk = 0x1f
	// Position of PORT field.
	I2S_PSEL_MCK_PORT_Pos = 0x5
	// Bit mask of PORT field.
	I2S_PSEL_MCK_PORT_Msk = 0x20
	// Bit PORT.
	I2S_PSEL_MCK_PORT = 0x20
	// Position of CONNECT field.
	I2S_PSEL_MCK_CONNECT_Pos = 0x1f
	// Bit mask of CONNECT field.
	I2S_PSEL_MCK_CONNECT_Msk = 0x80000000
	// Bit CONNECT.
	I2S_PSEL_MCK_CONNECT = 0x80000000
	// Disconnect
	I2S_PSEL_MCK_CONNECT_Disconnected = 0x1
	// Connect
	I2S_PSEL_MCK_CONNECT_Connected = 0x0

	// PSEL.SCK: Pin select for SCK signal.
	// Position of PIN field.
	I2S_PSEL_SCK_PIN_Pos = 0x0
	// Bit mask of PIN field.
	I2S_PSEL_SCK_PIN_Msk = 0x1f
	// Position of PORT field.
	I2S_PSEL_SCK_PORT_Pos = 0x5
	// Bit mask of PORT field.
	I2S_PSEL_SCK_PORT_Msk = 0x20
	// Bit PORT.
	I2S_PSEL_SCK_PORT = 0x20
	// Position of CONNECT field.
	I2S_PSEL_SCK_CONNECT_Pos = 0x1f
	// Bit mask of CONNECT field.
	I2S_PSEL_SCK_CONNECT_Msk = 0x80000000
	// Bit CONNECT.
	I2S_PSEL_SCK_CONNECT = 0x80000000
	// Disconnect
	I2S_PSEL_SCK_CONNECT_Disconnected = 0x1
	// Connect
	I2S_PSEL_SCK_CONNECT_Connected = 0x0

	// PSEL.LRCK: Pin select for LRCK signal.
	// Position of PIN field.
	I2S_PSEL_LRCK_PIN_Pos = 0x0
	// Bit mask of PIN field.
	I2S_PSEL_LRCK_PIN_Msk = 0x1f
	// Position of PORT field.
	I2S_PSEL_LRCK_PORT_Pos = 0x5
	// Bit mask of PORT field.
	I2S_PSEL_LRCK_PORT_Msk = 0x20
	// Bit PORT.
	I2S_PSEL_LRCK_PORT = 0x20
	// Position of CONNECT field.
	I2S_PSEL_LRCK_CONNECT_Pos = 0x1f
	// Bit mask of CONNECT field.
	I2S_PSEL_LRCK_CONNECT_Msk = 0x80000000
	// Bit CONNECT.
	I2S_PSEL_LRCK_CONNECT = 0x80000000
	// Disconnect
	I2S_PSEL_LRCK_CONNECT_Disconnected = 0x1
	// Connect
	I2S_PSEL_LRCK_CONNECT_Connected = 0x0

	// PSEL.SDIN: Pin select for SDIN signal.
	// Position of PIN field.
	I2S_PSEL_SDIN_PIN_Pos = 0x0
	// Bit mask of PIN field.
	I2S_PSEL_SDIN_PIN_Msk = 0x1f
	// Position of PORT field.
	I2S_PSEL_SDIN_PORT_Pos = 0x5
	// Bit mask of PORT field.
	I2S_PSEL_SDIN_PORT_Msk = 0x20
	// Bit PORT.
	I2S_PSEL_SDIN_PORT = 0x20
	// Position of CONNECT field.
	I2S_PSEL_SDIN_CONNECT_Pos = 0x1f
	// Bit mask of CONNECT field.
	I2S_PSEL_SDIN_CONNECT_Msk = 0x80000000
	// Bit CONNECT.
	I2S_PSEL_SDIN_CONNECT = 0x80000000
	// Disconnect
	I2S_PSEL_SDIN_CONNECT_Disconnected = 0x1
	// Connect
	I2S_PSEL_SDIN_CONNECT_Connected = 0x0

	// PSEL.SDOUT: Pin select for SDOUT signal.
	// Position of PIN field.
	I2S_PSEL_SDOUT_PIN_Pos = 0x0
	// Bit mask of PIN field.
	I2S_PSEL_SDOUT_PIN_Msk = 0x1f
	// Position of PORT field.
	I2S_PSEL_SDOUT_PORT_Pos = 0x5
	// Bit mask of PORT field.
	I2S_PSEL_SDOUT_PORT_Msk = 0x20
	// Bit PORT.
	I2S_PSEL_SDOUT_PORT = 0x20
	// Position of CONNECT field.
	I2S_PSEL_SDOUT_CONNECT_Pos = 0x1f
	// Bit mask of CONNECT field.
	I2S_PSEL_SDOUT_CONNECT_Msk = 0x80000000
	// Bit CONNECT.
	I2S_PSEL_SDOUT_CONNECT = 0x80000000
	// Disconnect
	I2S_PSEL_SDOUT_CONNECT_Disconnected = 0x1
	// Connect
	I2S_PSEL_SDOUT_CONNECT_Connected = 0x0
)

// Bitfields for FPU: FPU
const ()

// Bitfields for USBD: Universal serial bus device
const (
	// TASKS_STARTEPIN: Description collection: Captures the EPIN[n].PTR and EPIN[n].MAXCNT registers values, and enables endpoint IN n to respond to traffic from host
	// Position of TASKS_STARTEPIN field.
	USBD_TASKS_STARTEPIN_TASKS_STARTEPIN_Pos = 0x0
	// Bit mask of TASKS_STARTEPIN field.
	USBD_TASKS_STARTEPIN_TASKS_STARTEPIN_Msk = 0x1
	// Bit TASKS_STARTEPIN.
	USBD_TASKS_STARTEPIN_TASKS_STARTEPIN = 0x1
	// Trigger task
	USBD_TASKS_STARTEPIN_TASKS_STARTEPIN_Trigger = 0x1

	// TASKS_STARTISOIN: Captures the ISOIN.PTR and ISOIN.MAXCNT registers values, and enables sending data on ISO endpoint
	// Position of TASKS_STARTISOIN field.
	USBD_TASKS_STARTISOIN_TASKS_STARTISOIN_Pos = 0x0
	// Bit mask of TASKS_STARTISOIN field.
	USBD_TASKS_STARTISOIN_TASKS_STARTISOIN_Msk = 0x1
	// Bit TASKS_STARTISOIN.
	USBD_TASKS_STARTISOIN_TASKS_STARTISOIN = 0x1
	// Trigger task
	USBD_TASKS_STARTISOIN_TASKS_STARTISOIN_Trigger = 0x1

	// TASKS_STARTEPOUT: Description collection: Captures the EPOUT[n].PTR and EPOUT[n].MAXCNT registers values, and enables endpoint n to respond to traffic from host
	// Position of TASKS_STARTEPOUT field.
	USBD_TASKS_STARTEPOUT_TASKS_STARTEPOUT_Pos = 0x0
	// Bit mask of TASKS_STARTEPOUT field.
	USBD_TASKS_STARTEPOUT_TASKS_STARTEPOUT_Msk = 0x1
	// Bit TASKS_STARTEPOUT.
	USBD_TASKS_STARTEPOUT_TASKS_STARTEPOUT = 0x1
	// Trigger task
	USBD_TASKS_STARTEPOUT_TASKS_STARTEPOUT_Trigger = 0x1

	// TASKS_STARTISOOUT: Captures the ISOOUT.PTR and ISOOUT.MAXCNT registers values, and enables receiving of data on ISO endpoint
	// Position of TASKS_STARTISOOUT field.
	USBD_TASKS_STARTISOOUT_TASKS_STARTISOOUT_Pos = 0x0
	// Bit mask of TASKS_STARTISOOUT field.
	USBD_TASKS_STARTISOOUT_TASKS_STARTISOOUT_Msk = 0x1
	// Bit TASKS_STARTISOOUT.
	USBD_TASKS_STARTISOOUT_TASKS_STARTISOOUT = 0x1
	// Trigger task
	USBD_TASKS_STARTISOOUT_TASKS_STARTISOOUT_Trigger = 0x1

	// TASKS_EP0RCVOUT: Allows OUT data stage on control endpoint 0
	// Position of TASKS_EP0RCVOUT field.
	USBD_TASKS_EP0RCVOUT_TASKS_EP0RCVOUT_Pos = 0x0
	// Bit mask of TASKS_EP0RCVOUT field.
	USBD_TASKS_EP0RCVOUT_TASKS_EP0RCVOUT_Msk = 0x1
	// Bit TASKS_EP0RCVOUT.
	USBD_TASKS_EP0RCVOUT_TASKS_EP0RCVOUT = 0x1
	// Trigger task
	USBD_TASKS_EP0RCVOUT_TASKS_EP0RCVOUT_Trigger = 0x1

	// TASKS_EP0STATUS: Allows status stage on control endpoint 0
	// Position of TASKS_EP0STATUS field.
	USBD_TASKS_EP0STATUS_TASKS_EP0STATUS_Pos = 0x0
	// Bit mask of TASKS_EP0STATUS field.
	USBD_TASKS_EP0STATUS_TASKS_EP0STATUS_Msk = 0x1
	// Bit TASKS_EP0STATUS.
	USBD_TASKS_EP0STATUS_TASKS_EP0STATUS = 0x1
	// Trigger task
	USBD_TASKS_EP0STATUS_TASKS_EP0STATUS_Trigger = 0x1

	// TASKS_EP0STALL: Stalls data and status stage on control endpoint 0
	// Position of TASKS_EP0STALL field.
	USBD_TASKS_EP0STALL_TASKS_EP0STALL_Pos = 0x0
	// Bit mask of TASKS_EP0STALL field.
	USBD_TASKS_EP0STALL_TASKS_EP0STALL_Msk = 0x1
	// Bit TASKS_EP0STALL.
	USBD_TASKS_EP0STALL_TASKS_EP0STALL = 0x1
	// Trigger task
	USBD_TASKS_EP0STALL_TASKS_EP0STALL_Trigger = 0x1

	// TASKS_DPDMDRIVE: Forces D+ and D- lines into the state defined in the DPDMVALUE register
	// Position of TASKS_DPDMDRIVE field.
	USBD_TASKS_DPDMDRIVE_TASKS_DPDMDRIVE_Pos = 0x0
	// Bit mask of TASKS_DPDMDRIVE field.
	USBD_TASKS_DPDMDRIVE_TASKS_DPDMDRIVE_Msk = 0x1
	// Bit TASKS_DPDMDRIVE.
	USBD_TASKS_DPDMDRIVE_TASKS_DPDMDRIVE = 0x1
	// Trigger task
	USBD_TASKS_DPDMDRIVE_TASKS_DPDMDRIVE_Trigger = 0x1

	// TASKS_DPDMNODRIVE: Stops forcing D+ and D- lines into any state (USB engine takes control)
	// Position of TASKS_DPDMNODRIVE field.
	USBD_TASKS_DPDMNODRIVE_TASKS_DPDMNODRIVE_Pos = 0x0
	// Bit mask of TASKS_DPDMNODRIVE field.
	USBD_TASKS_DPDMNODRIVE_TASKS_DPDMNODRIVE_Msk = 0x1
	// Bit TASKS_DPDMNODRIVE.
	USBD_TASKS_DPDMNODRIVE_TASKS_DPDMNODRIVE = 0x1
	// Trigger task
	USBD_TASKS_DPDMNODRIVE_TASKS_DPDMNODRIVE_Trigger = 0x1

	// EVENTS_USBRESET: Signals that a USB reset condition has been detected on USB lines
	// Position of EVENTS_USBRESET field.
	USBD_EVENTS_USBRESET_EVENTS_USBRESET_Pos = 0x0
	// Bit mask of EVENTS_USBRESET field.
	USBD_EVENTS_USBRESET_EVENTS_USBRESET_Msk = 0x1
	// Bit EVENTS_USBRESET.
	USBD_EVENTS_USBRESET_EVENTS_USBRESET = 0x1
	// Event not generated
	USBD_EVENTS_USBRESET_EVENTS_USBRESET_NotGenerated = 0x0
	// Event generated
	USBD_EVENTS_USBRESET_EVENTS_USBRESET_Generated = 0x1

	// EVENTS_STARTED: Confirms that the EPIN[n].PTR and EPIN[n].MAXCNT, or EPOUT[n].PTR and EPOUT[n].MAXCNT registers have been captured on all endpoints reported in the EPSTATUS register
	// Position of EVENTS_STARTED field.
	USBD_EVENTS_STARTED_EVENTS_STARTED_Pos = 0x0
	// Bit mask of EVENTS_STARTED field.
	USBD_EVENTS_STARTED_EVENTS_STARTED_Msk = 0x1
	// Bit EVENTS_STARTED.
	USBD_EVENTS_STARTED_EVENTS_STARTED = 0x1
	// Event not generated
	USBD_EVENTS_STARTED_EVENTS_STARTED_NotGenerated = 0x0
	// Event generated
	USBD_EVENTS_STARTED_EVENTS_STARTED_Generated = 0x1

	// EVENTS_ENDEPIN: Description collection: The whole EPIN[n] buffer has been consumed. The RAM buffer can be accessed safely by software.
	// Position of EVENTS_ENDEPIN field.
	USBD_EVENTS_ENDEPIN_EVENTS_ENDEPIN_Pos = 0x0
	// Bit mask of EVENTS_ENDEPIN field.
	USBD_EVENTS_ENDEPIN_EVENTS_ENDEPIN_Msk = 0x1
	// Bit EVENTS_ENDEPIN.
	USBD_EVENTS_ENDEPIN_EVENTS_ENDEPIN = 0x1
	// Event not generated
	USBD_EVENTS_ENDEPIN_EVENTS_ENDEPIN_NotGenerated = 0x0
	// Event generated
	USBD_EVENTS_ENDEPIN_EVENTS_ENDEPIN_Generated = 0x1

	// EVENTS_EP0DATADONE: An acknowledged data transfer has taken place on the control endpoint
	// Position of EVENTS_EP0DATADONE field.
	USBD_EVENTS_EP0DATADONE_EVENTS_EP0DATADONE_Pos = 0x0
	// Bit mask of EVENTS_EP0DATADONE field.
	USBD_EVENTS_EP0DATADONE_EVENTS_EP0DATADONE_Msk = 0x1
	// Bit EVENTS_EP0DATADONE.
	USBD_EVENTS_EP0DATADONE_EVENTS_EP0DATADONE = 0x1
	// Event not generated
	USBD_EVENTS_EP0DATADONE_EVENTS_EP0DATADONE_NotGenerated = 0x0
	// Event generated
	USBD_EVENTS_EP0DATADONE_EVENTS_EP0DATADONE_Generated = 0x1

	// EVENTS_ENDISOIN: The whole ISOIN buffer has been consumed. The RAM buffer can be accessed safely by software.
	// Position of EVENTS_ENDISOIN field.
	USBD_EVENTS_ENDISOIN_EVENTS_ENDISOIN_Pos = 0x0
	// Bit mask of EVENTS_ENDISOIN field.
	USBD_EVENTS_ENDISOIN_EVENTS_ENDISOIN_Msk = 0x1
	// Bit EVENTS_ENDISOIN.
	USBD_EVENTS_ENDISOIN_EVENTS_ENDISOIN = 0x1
	// Event not generated
	USBD_EVENTS_ENDISOIN_EVENTS_ENDISOIN_NotGenerated = 0x0
	// Event generated
	USBD_EVENTS_ENDISOIN_EVENTS_ENDISOIN_Generated = 0x1

	// EVENTS_ENDEPOUT: Description collection: The whole EPOUT[n] buffer has been consumed. The RAM buffer can be accessed safely by software.
	// Position of EVENTS_ENDEPOUT field.
	USBD_EVENTS_ENDEPOUT_EVENTS_ENDEPOUT_Pos = 0x0
	// Bit mask of EVENTS_ENDEPOUT field.
	USBD_EVENTS_ENDEPOUT_EVENTS_ENDEPOUT_Msk = 0x1
	// Bit EVENTS_ENDEPOUT.
	USBD_EVENTS_ENDEPOUT_EVENTS_ENDEPOUT = 0x1
	// Event not generated
	USBD_EVENTS_ENDEPOUT_EVENTS_ENDEPOUT_NotGenerated = 0x0
	// Event generated
	USBD_EVENTS_ENDEPOUT_EVENTS_ENDEPOUT_Generated = 0x1

	// EVENTS_ENDISOOUT: The whole ISOOUT buffer has been consumed. The RAM buffer can be accessed safely by software.
	// Position of EVENTS_ENDISOOUT field.
	USBD_EVENTS_ENDISOOUT_EVENTS_ENDISOOUT_Pos = 0x0
	// Bit mask of EVENTS_ENDISOOUT field.
	USBD_EVENTS_ENDISOOUT_EVENTS_ENDISOOUT_Msk = 0x1
	// Bit EVENTS_ENDISOOUT.
	USBD_EVENTS_ENDISOOUT_EVENTS_ENDISOOUT = 0x1
	// Event not generated
	USBD_EVENTS_ENDISOOUT_EVENTS_ENDISOOUT_NotGenerated = 0x0
	// Event generated
	USBD_EVENTS_ENDISOOUT_EVENTS_ENDISOOUT_Generated = 0x1

	// EVENTS_SOF: Signals that a SOF (start of frame) condition has been detected on USB lines
	// Position of EVENTS_SOF field.
	USBD_EVENTS_SOF_EVENTS_SOF_Pos = 0x0
	// Bit mask of EVENTS_SOF field.
	USBD_EVENTS_SOF_EVENTS_SOF_Msk = 0x1
	// Bit EVENTS_SOF.
	USBD_EVENTS_SOF_EVENTS_SOF = 0x1
	// Event not generated
	USBD_EVENTS_SOF_EVENTS_SOF_NotGenerated = 0x0
	// Event generated
	USBD_EVENTS_SOF_EVENTS_SOF_Generated = 0x1

	// EVENTS_USBEVENT: An event or an error not covered by specific events has occurred. Check EVENTCAUSE register to find the cause.
	// Position of EVENTS_USBEVENT field.
	USBD_EVENTS_USBEVENT_EVENTS_USBEVENT_Pos = 0x0
	// Bit mask of EVENTS_USBEVENT field.
	USBD_EVENTS_USBEVENT_EVENTS_USBEVENT_Msk = 0x1
	// Bit EVENTS_USBEVENT.
	USBD_EVENTS_USBEVENT_EVENTS_USBEVENT = 0x1
	// Event not generated
	USBD_EVENTS_USBEVENT_EVENTS_USBEVENT_NotGenerated = 0x0
	// Event generated
	USBD_EVENTS_USBEVENT_EVENTS_USBEVENT_Generated = 0x1

	// EVENTS_EP0SETUP: A valid SETUP token has been received (and acknowledged) on the control endpoint
	// Position of EVENTS_EP0SETUP field.
	USBD_EVENTS_EP0SETUP_EVENTS_EP0SETUP_Pos = 0x0
	// Bit mask of EVENTS_EP0SETUP field.
	USBD_EVENTS_EP0SETUP_EVENTS_EP0SETUP_Msk = 0x1
	// Bit EVENTS_EP0SETUP.
	USBD_EVENTS_EP0SETUP_EVENTS_EP0SETUP = 0x1
	// Event not generated
	USBD_EVENTS_EP0SETUP_EVENTS_EP0SETUP_NotGenerated = 0x0
	// Event generated
	USBD_EVENTS_EP0SETUP_EVENTS_EP0SETUP_Generated = 0x1

	// EVENTS_EPDATA: A data transfer has occurred on a data endpoint, indicated by the EPDATASTATUS register
	// Position of EVENTS_EPDATA field.
	USBD_EVENTS_EPDATA_EVENTS_EPDATA_Pos = 0x0
	// Bit mask of EVENTS_EPDATA field.
	USBD_EVENTS_EPDATA_EVENTS_EPDATA_Msk = 0x1
	// Bit EVENTS_EPDATA.
	USBD_EVENTS_EPDATA_EVENTS_EPDATA = 0x1
	// Event not generated
	USBD_EVENTS_EPDATA_EVENTS_EPDATA_NotGenerated = 0x0
	// Event generated
	USBD_EVENTS_EPDATA_EVENTS_EPDATA_Generated = 0x1

	// SHORTS: Shortcuts between local events and tasks
	// Position of EP0DATADONE_STARTEPIN0 field.
	USBD_SHORTS_EP0DATADONE_STARTEPIN0_Pos = 0x0
	// Bit mask of EP0DATADONE_STARTEPIN0 field.
	USBD_SHORTS_EP0DATADONE_STARTEPIN0_Msk = 0x1
	// Bit EP0DATADONE_STARTEPIN0.
	USBD_SHORTS_EP0DATADONE_STARTEPIN0 = 0x1
	// Disable shortcut
	USBD_SHORTS_EP0DATADONE_STARTEPIN0_Disabled = 0x0
	// Enable shortcut
	USBD_SHORTS_EP0DATADONE_STARTEPIN0_Enabled = 0x1
	// Position of EP0DATADONE_STARTEPOUT0 field.
	USBD_SHORTS_EP0DATADONE_STARTEPOUT0_Pos = 0x1
	// Bit mask of EP0DATADONE_STARTEPOUT0 field.
	USBD_SHORTS_EP0DATADONE_STARTEPOUT0_Msk = 0x2
	// Bit EP0DATADONE_STARTEPOUT0.
	USBD_SHORTS_EP0DATADONE_STARTEPOUT0 = 0x2
	// Disable shortcut
	USBD_SHORTS_EP0DATADONE_STARTEPOUT0_Disabled = 0x0
	// Enable shortcut
	USBD_SHORTS_EP0DATADONE_STARTEPOUT0_Enabled = 0x1
	// Position of EP0DATADONE_EP0STATUS field.
	USBD_SHORTS_EP0DATADONE_EP0STATUS_Pos = 0x2
	// Bit mask of EP0DATADONE_EP0STATUS field.
	USBD_SHORTS_EP0DATADONE_EP0STATUS_Msk = 0x4
	// Bit EP0DATADONE_EP0STATUS.
	USBD_SHORTS_EP0DATADONE_EP0STATUS = 0x4
	// Disable shortcut
	USBD_SHORTS_EP0DATADONE_EP0STATUS_Disabled = 0x0
	// Enable shortcut
	USBD_SHORTS_EP0DATADONE_EP0STATUS_Enabled = 0x1
	// Position of ENDEPOUT0_EP0STATUS field.
	USBD_SHORTS_ENDEPOUT0_EP0STATUS_Pos = 0x3
	// Bit mask of ENDEPOUT0_EP0STATUS field.
	USBD_SHORTS_ENDEPOUT0_EP0STATUS_Msk = 0x8
	// Bit ENDEPOUT0_EP0STATUS.
	USBD_SHORTS_ENDEPOUT0_EP0STATUS = 0x8
	// Disable shortcut
	USBD_SHORTS_ENDEPOUT0_EP0STATUS_Disabled = 0x0
	// Enable shortcut
	USBD_SHORTS_ENDEPOUT0_EP0STATUS_Enabled = 0x1
	// Position of ENDEPOUT0_EP0RCVOUT field.
	USBD_SHORTS_ENDEPOUT0_EP0RCVOUT_Pos = 0x4
	// Bit mask of ENDEPOUT0_EP0RCVOUT field.
	USBD_SHORTS_ENDEPOUT0_EP0RCVOUT_Msk = 0x10
	// Bit ENDEPOUT0_EP0RCVOUT.
	USBD_SHORTS_ENDEPOUT0_EP0RCVOUT = 0x10
	// Disable shortcut
	USBD_SHORTS_ENDEPOUT0_EP0RCVOUT_Disabled = 0x0
	// Enable shortcut
	USBD_SHORTS_ENDEPOUT0_EP0RCVOUT_Enabled = 0x1

	// INTEN: Enable or disable interrupt
	// Position of USBRESET field.
	USBD_INTEN_USBRESET_Pos = 0x0
	// Bit mask of USBRESET field.
	USBD_INTEN_USBRESET_Msk = 0x1
	// Bit USBRESET.
	USBD_INTEN_USBRESET = 0x1
	// Disable
	USBD_INTEN_USBRESET_Disabled = 0x0
	// Enable
	USBD_INTEN_USBRESET_Enabled = 0x1
	// Position of STARTED field.
	USBD_INTEN_STARTED_Pos = 0x1
	// Bit mask of STARTED field.
	USBD_INTEN_STARTED_Msk = 0x2
	// Bit STARTED.
	USBD_INTEN_STARTED = 0x2
	// Disable
	USBD_INTEN_STARTED_Disabled = 0x0
	// Enable
	USBD_INTEN_STARTED_Enabled = 0x1
	// Position of ENDEPIN0 field.
	USBD_INTEN_ENDEPIN0_Pos = 0x2
	// Bit mask of ENDEPIN0 field.
	USBD_INTEN_ENDEPIN0_Msk = 0x4
	// Bit ENDEPIN0.
	USBD_INTEN_ENDEPIN0 = 0x4
	// Disable
	USBD_INTEN_ENDEPIN0_Disabled = 0x0
	// Enable
	USBD_INTEN_ENDEPIN0_Enabled = 0x1
	// Position of ENDEPIN1 field.
	USBD_INTEN_ENDEPIN1_Pos = 0x3
	// Bit mask of ENDEPIN1 field.
	USBD_INTEN_ENDEPIN1_Msk = 0x8
	// Bit ENDEPIN1.
	USBD_INTEN_ENDEPIN1 = 0x8
	// Disable
	USBD_INTEN_ENDEPIN1_Disabled = 0x0
	// Enable
	USBD_INTEN_ENDEPIN1_Enabled = 0x1
	// Position of ENDEPIN2 field.
	USBD_INTEN_ENDEPIN2_Pos = 0x4
	// Bit mask of ENDEPIN2 field.
	USBD_INTEN_ENDEPIN2_Msk = 0x10
	// Bit ENDEPIN2.
	USBD_INTEN_ENDEPIN2 = 0x10
	// Disable
	USBD_INTEN_ENDEPIN2_Disabled = 0x0
	// Enable
	USBD_INTEN_ENDEPIN2_Enabled = 0x1
	// Position of ENDEPIN3 field.
	USBD_INTEN_ENDEPIN3_Pos = 0x5
	// Bit mask of ENDEPIN3 field.
	USBD_INTEN_ENDEPIN3_Msk = 0x20
	// Bit ENDEPIN3.
	USBD_INTEN_ENDEPIN3 = 0x20
	// Disable
	USBD_INTEN_ENDEPIN3_Disabled = 0x0
	// Enable
	USBD_INTEN_ENDEPIN3_Enabled = 0x1
	// Position of ENDEPIN4 field.
	USBD_INTEN_ENDEPIN4_Pos = 0x6
	// Bit mask of ENDEPIN4 field.
	USBD_INTEN_ENDEPIN4_Msk = 0x40
	// Bit ENDEPIN4.
	USBD_INTEN_ENDEPIN4 = 0x40
	// Disable
	USBD_INTEN_ENDEPIN4_Disabled = 0x0
	// Enable
	USBD_INTEN_ENDEPIN4_Enabled = 0x1
	// Position of ENDEPIN5 field.
	USBD_INTEN_ENDEPIN5_Pos = 0x7
	// Bit mask of ENDEPIN5 field.
	USBD_INTEN_ENDEPIN5_Msk = 0x80
	// Bit ENDEPIN5.
	USBD_INTEN_ENDEPIN5 = 0x80
	// Disable
	USBD_INTEN_ENDEPIN5_Disabled = 0x0
	// Enable
	USBD_INTEN_ENDEPIN5_Enabled = 0x1
	// Position of ENDEPIN6 field.
	USBD_INTEN_ENDEPIN6_Pos = 0x8
	// Bit mask of ENDEPIN6 field.
	USBD_INTEN_ENDEPIN6_Msk = 0x100
	// Bit ENDEPIN6.
	USBD_INTEN_ENDEPIN6 = 0x100
	// Disable
	USBD_INTEN_ENDEPIN6_Disabled = 0x0
	// Enable
	USBD_INTEN_ENDEPIN6_Enabled = 0x1
	// Position of ENDEPIN7 field.
	USBD_INTEN_ENDEPIN7_Pos = 0x9
	// Bit mask of ENDEPIN7 field.
	USBD_INTEN_ENDEPIN7_Msk = 0x200
	// Bit ENDEPIN7.
	USBD_INTEN_ENDEPIN7 = 0x200
	// Disable
	USBD_INTEN_ENDEPIN7_Disabled = 0x0
	// Enable
	USBD_INTEN_ENDEPIN7_Enabled = 0x1
	// Position of EP0DATADONE field.
	USBD_INTEN_EP0DATADONE_Pos = 0xa
	// Bit mask of EP0DATADONE field.
	USBD_INTEN_EP0DATADONE_Msk = 0x400
	// Bit EP0DATADONE.
	USBD_INTEN_EP0DATADONE = 0x400
	// Disable
	USBD_INTEN_EP0DATADONE_Disabled = 0x0
	// Enable
	USBD_INTEN_EP0DATADONE_Enabled = 0x1
	// Position of ENDISOIN field.
	USBD_INTEN_ENDISOIN_Pos = 0xb
	// Bit mask of ENDISOIN field.
	USBD_INTEN_ENDISOIN_Msk = 0x800
	// Bit ENDISOIN.
	USBD_INTEN_ENDISOIN = 0x800
	// Disable
	USBD_INTEN_ENDISOIN_Disabled = 0x0
	// Enable
	USBD_INTEN_ENDISOIN_Enabled = 0x1
	// Position of ENDEPOUT0 field.
	USBD_INTEN_ENDEPOUT0_Pos = 0xc
	// Bit mask of ENDEPOUT0 field.
	USBD_INTEN_ENDEPOUT0_Msk = 0x1000
	// Bit ENDEPOUT0.
	USBD_INTEN_ENDEPOUT0 = 0x1000
	// Disable
	USBD_INTEN_ENDEPOUT0_Disabled = 0x0
	// Enable
	USBD_INTEN_ENDEPOUT0_Enabled = 0x1
	// Position of ENDEPOUT1 field.
	USBD_INTEN_ENDEPOUT1_Pos = 0xd
	// Bit mask of ENDEPOUT1 field.
	USBD_INTEN_ENDEPOUT1_Msk = 0x2000
	// Bit ENDEPOUT1.
	USBD_INTEN_ENDEPOUT1 = 0x2000
	// Disable
	USBD_INTEN_ENDEPOUT1_Disabled = 0x0
	// Enable
	USBD_INTEN_ENDEPOUT1_Enabled = 0x1
	// Position of ENDEPOUT2 field.
	USBD_INTEN_ENDEPOUT2_Pos = 0xe
	// Bit mask of ENDEPOUT2 field.
	USBD_INTEN_ENDEPOUT2_Msk = 0x4000
	// Bit ENDEPOUT2.
	USBD_INTEN_ENDEPOUT2 = 0x4000
	// Disable
	USBD_INTEN_ENDEPOUT2_Disabled = 0x0
	// Enable
	USBD_INTEN_ENDEPOUT2_Enabled = 0x1
	// Position of ENDEPOUT3 field.
	USBD_INTEN_ENDEPOUT3_Pos = 0xf
	// Bit mask of ENDEPOUT3 field.
	USBD_INTEN_ENDEPOUT3_Msk = 0x8000
	// Bit ENDEPOUT3.
	USBD_INTEN_ENDEPOUT3 = 0x8000
	// Disable
	USBD_INTEN_ENDEPOUT3_Disabled = 0x0
	// Enable
	USBD_INTEN_ENDEPOUT3_Enabled = 0x1
	// Position of ENDEPOUT4 field.
	USBD_INTEN_ENDEPOUT4_Pos = 0x10
	// Bit mask of ENDEPOUT4 field.
	USBD_INTEN_ENDEPOUT4_Msk = 0x10000
	// Bit ENDEPOUT4.
	USBD_INTEN_ENDEPOUT4 = 0x10000
	// Disable
	USBD_INTEN_ENDEPOUT4_Disabled = 0x0
	// Enable
	USBD_INTEN_ENDEPOUT4_Enabled = 0x1
	// Position of ENDEPOUT5 field.
	USBD_INTEN_ENDEPOUT5_Pos = 0x11
	// Bit mask of ENDEPOUT5 field.
	USBD_INTEN_ENDEPOUT5_Msk = 0x20000
	// Bit ENDEPOUT5.
	USBD_INTEN_ENDEPOUT5 = 0x20000
	// Disable
	USBD_INTEN_ENDEPOUT5_Disabled = 0x0
	// Enable
	USBD_INTEN_ENDEPOUT5_Enabled = 0x1
	// Position of ENDEPOUT6 field.
	USBD_INTEN_ENDEPOUT6_Pos = 0x12
	// Bit mask of ENDEPOUT6 field.
	USBD_INTEN_ENDEPOUT6_Msk = 0x40000
	// Bit ENDEPOUT6.
	USBD_INTEN_ENDEPOUT6 = 0x40000
	// Disable
	USBD_INTEN_ENDEPOUT6_Disabled = 0x0
	// Enable
	USBD_INTEN_ENDEPOUT6_Enabled = 0x1
	// Position of ENDEPOUT7 field.
	USBD_INTEN_ENDEPOUT7_Pos = 0x13
	// Bit mask of ENDEPOUT7 field.
	USBD_INTEN_ENDEPOUT7_Msk = 0x80000
	// Bit ENDEPOUT7.
	USBD_INTEN_ENDEPOUT7 = 0x80000
	// Disable
	USBD_INTEN_ENDEPOUT7_Disabled = 0x0
	// Enable
	USBD_INTEN_ENDEPOUT7_Enabled = 0x1
	// Position of ENDISOOUT field.
	USBD_INTEN_ENDISOOUT_Pos = 0x14
	// Bit mask of ENDISOOUT field.
	USBD_INTEN_ENDISOOUT_Msk = 0x100000
	// Bit ENDISOOUT.
	USBD_INTEN_ENDISOOUT = 0x100000
	// Disable
	USBD_INTEN_ENDISOOUT_Disabled = 0x0
	// Enable
	USBD_INTEN_ENDISOOUT_Enabled = 0x1
	// Position of SOF field.
	USBD_INTEN_SOF_Pos = 0x15
	// Bit mask of SOF field.
	USBD_INTEN_SOF_Msk = 0x200000
	// Bit SOF.
	USBD_INTEN_SOF = 0x200000
	// Disable
	USBD_INTEN_SOF_Disabled = 0x0
	// Enable
	USBD_INTEN_SOF_Enabled = 0x1
	// Position of USBEVENT field.
	USBD_INTEN_USBEVENT_Pos = 0x16
	// Bit mask of USBEVENT field.
	USBD_INTEN_USBEVENT_Msk = 0x400000
	// Bit USBEVENT.
	USBD_INTEN_USBEVENT = 0x400000
	// Disable
	USBD_INTEN_USBEVENT_Disabled = 0x0
	// Enable
	USBD_INTEN_USBEVENT_Enabled = 0x1
	// Position of EP0SETUP field.
	USBD_INTEN_EP0SETUP_Pos = 0x17
	// Bit mask of EP0SETUP field.
	USBD_INTEN_EP0SETUP_Msk = 0x800000
	// Bit EP0SETUP.
	USBD_INTEN_EP0SETUP = 0x800000
	// Disable
	USBD_INTEN_EP0SETUP_Disabled = 0x0
	// Enable
	USBD_INTEN_EP0SETUP_Enabled = 0x1
	// Position of EPDATA field.
	USBD_INTEN_EPDATA_Pos = 0x18
	// Bit mask of EPDATA field.
	USBD_INTEN_EPDATA_Msk = 0x1000000
	// Bit EPDATA.
	USBD_INTEN_EPDATA = 0x1000000
	// Disable
	USBD_INTEN_EPDATA_Disabled = 0x0
	// Enable
	USBD_INTEN_EPDATA_Enabled = 0x1

	// INTENSET: Enable interrupt
	// Position of USBRESET field.
	USBD_INTENSET_USBRESET_Pos = 0x0
	// Bit mask of USBRESET field.
	USBD_INTENSET_USBRESET_Msk = 0x1
	// Bit USBRESET.
	USBD_INTENSET_USBRESET = 0x1
	// Read: Disabled
	USBD_INTENSET_USBRESET_Disabled = 0x0
	// Read: Enabled
	USBD_INTENSET_USBRESET_Enabled = 0x1
	// Enable
	USBD_INTENSET_USBRESET_Set = 0x1
	// Position of STARTED field.
	USBD_INTENSET_STARTED_Pos = 0x1
	// Bit mask of STARTED field.
	USBD_INTENSET_STARTED_Msk = 0x2
	// Bit STARTED.
	USBD_INTENSET_STARTED = 0x2
	// Read: Disabled
	USBD_INTENSET_STARTED_Disabled = 0x0
	// Read: Enabled
	USBD_INTENSET_STARTED_Enabled = 0x1
	// Enable
	USBD_INTENSET_STARTED_Set = 0x1
	// Position of ENDEPIN0 field.
	USBD_INTENSET_ENDEPIN0_Pos = 0x2
	// Bit mask of ENDEPIN0 field.
	USBD_INTENSET_ENDEPIN0_Msk = 0x4
	// Bit ENDEPIN0.
	USBD_INTENSET_ENDEPIN0 = 0x4
	// Read: Disabled
	USBD_INTENSET_ENDEPIN0_Disabled = 0x0
	// Read: Enabled
	USBD_INTENSET_ENDEPIN0_Enabled = 0x1
	// Enable
	USBD_INTENSET_ENDEPIN0_Set = 0x1
	// Position of ENDEPIN1 field.
	USBD_INTENSET_ENDEPIN1_Pos = 0x3
	// Bit mask of ENDEPIN1 field.
	USBD_INTENSET_ENDEPIN1_Msk = 0x8
	// Bit ENDEPIN1.
	USBD_INTENSET_ENDEPIN1 = 0x8
	// Read: Disabled
	USBD_INTENSET_ENDEPIN1_Disabled = 0x0
	// Read: Enabled
	USBD_INTENSET_ENDEPIN1_Enabled = 0x1
	// Enable
	USBD_INTENSET_ENDEPIN1_Set = 0x1
	// Position of ENDEPIN2 field.
	USBD_INTENSET_ENDEPIN2_Pos = 0x4
	// Bit mask of ENDEPIN2 field.
	USBD_INTENSET_ENDEPIN2_Msk = 0x10
	// Bit ENDEPIN2.
	USBD_INTENSET_ENDEPIN2 = 0x10
	// Read: Disabled
	USBD_INTENSET_ENDEPIN2_Disabled = 0x0
	// Read: Enabled
	USBD_INTENSET_ENDEPIN2_Enabled = 0x1
	// Enable
	USBD_INTENSET_ENDEPIN2_Set = 0x1
	// Position of ENDEPIN3 field.
	USBD_INTENSET_ENDEPIN3_Pos = 0x5
	// Bit mask of ENDEPIN3 field.
	USBD_INTENSET_ENDEPIN3_Msk = 0x20
	// Bit ENDEPIN3.
	USBD_INTENSET_ENDEPIN3 = 0x20
	// Read: Disabled
	USBD_INTENSET_ENDEPIN3_Disabled = 0x0
	// Read: Enabled
	USBD_INTENSET_ENDEPIN3_Enabled = 0x1
	// Enable
	USBD_INTENSET_ENDEPIN3_Set = 0x1
	// Position of ENDEPIN4 field.
	USBD_INTENSET_ENDEPIN4_Pos = 0x6
	// Bit mask of ENDEPIN4 field.
	USBD_INTENSET_ENDEPIN4_Msk = 0x40
	// Bit ENDEPIN4.
	USBD_INTENSET_ENDEPIN4 = 0x40
	// Read: Disabled
	USBD_INTENSET_ENDEPIN4_Disabled = 0x0
	// Read: Enabled
	USBD_INTENSET_ENDEPIN4_Enabled = 0x1
	// Enable
	USBD_INTENSET_ENDEPIN4_Set = 0x1
	// Position of ENDEPIN5 field.
	USBD_INTENSET_ENDEPIN5_Pos = 0x7
	// Bit mask of ENDEPIN5 field.
	USBD_INTENSET_ENDEPIN5_Msk = 0x80
	// Bit ENDEPIN5.
	USBD_INTENSET_ENDEPIN5 = 0x80
	// Read: Disabled
	USBD_INTENSET_ENDEPIN5_Disabled = 0x0
	// Read: Enabled
	USBD_INTENSET_ENDEPIN5_Enabled = 0x1
	// Enable
	USBD_INTENSET_ENDEPIN5_Set = 0x1
	// Position of ENDEPIN6 field.
	USBD_INTENSET_ENDEPIN6_Pos = 0x8
	// Bit mask of ENDEPIN6 field.
	USBD_INTENSET_ENDEPIN6_Msk = 0x100
	// Bit ENDEPIN6.
	USBD_INTENSET_ENDEPIN6 = 0x100
	// Read: Disabled
	USBD_INTENSET_ENDEPIN6_Disabled = 0x0
	// Read: Enabled
	USBD_INTENSET_ENDEPIN6_Enabled = 0x1
	// Enable
	USBD_INTENSET_ENDEPIN6_Set = 0x1
	// Position of ENDEPIN7 field.
	USBD_INTENSET_ENDEPIN7_Pos = 0x9
	// Bit mask of ENDEPIN7 field.
	USBD_INTENSET_ENDEPIN7_Msk = 0x200
	// Bit ENDEPIN7.
	USBD_INTENSET_ENDEPIN7 = 0x200
	// Read: Disabled
	USBD_INTENSET_ENDEPIN7_Disabled = 0x0
	// Read: Enabled
	USBD_INTENSET_ENDEPIN7_Enabled = 0x1
	// Enable
	USBD_INTENSET_ENDEPIN7_Set = 0x1
	// Position of EP0DATADONE field.
	USBD_INTENSET_EP0DATADONE_Pos = 0xa
	// Bit mask of EP0DATADONE field.
	USBD_INTENSET_EP0DATADONE_Msk = 0x400
	// Bit EP0DATADONE.
	USBD_INTENSET_EP0DATADONE = 0x400
	// Read: Disabled
	USBD_INTENSET_EP0DATADONE_Disabled = 0x0
	// Read: Enabled
	USBD_INTENSET_EP0DATADONE_Enabled = 0x1
	// Enable
	USBD_INTENSET_EP0DATADONE_Set = 0x1
	// Position of ENDISOIN field.
	USBD_INTENSET_ENDISOIN_Pos = 0xb
	// Bit mask of ENDISOIN field.
	USBD_INTENSET_ENDISOIN_Msk = 0x800
	// Bit ENDISOIN.
	USBD_INTENSET_ENDISOIN = 0x800
	// Read: Disabled
	USBD_INTENSET_ENDISOIN_Disabled = 0x0
	// Read: Enabled
	USBD_INTENSET_ENDISOIN_Enabled = 0x1
	// Enable
	USBD_INTENSET_ENDISOIN_Set = 0x1
	// Position of ENDEPOUT0 field.
	USBD_INTENSET_ENDEPOUT0_Pos = 0xc
	// Bit mask of ENDEPOUT0 field.
	USBD_INTENSET_ENDEPOUT0_Msk = 0x1000
	// Bit ENDEPOUT0.
	USBD_INTENSET_ENDEPOUT0 = 0x1000
	// Read: Disabled
	USBD_INTENSET_ENDEPOUT0_Disabled = 0x0
	// Read: Enabled
	USBD_INTENSET_ENDEPOUT0_Enabled = 0x1
	// Enable
	USBD_INTENSET_ENDEPOUT0_Set = 0x1
	// Position of ENDEPOUT1 field.
	USBD_INTENSET_ENDEPOUT1_Pos = 0xd
	// Bit mask of ENDEPOUT1 field.
	USBD_INTENSET_ENDEPOUT1_Msk = 0x2000
	// Bit ENDEPOUT1.
	USBD_INTENSET_ENDEPOUT1 = 0x2000
	// Read: Disabled
	USBD_INTENSET_ENDEPOUT1_Disabled = 0x0
	// Read: Enabled
	USBD_INTENSET_ENDEPOUT1_Enabled = 0x1
	// Enable
	USBD_INTENSET_ENDEPOUT1_Set = 0x1
	// Position of ENDEPOUT2 field.
	USBD_INTENSET_ENDEPOUT2_Pos = 0xe
	// Bit mask of ENDEPOUT2 field.
	USBD_INTENSET_ENDEPOUT2_Msk = 0x4000
	// Bit ENDEPOUT2.
	USBD_INTENSET_ENDEPOUT2 = 0x4000
	// Read: Disabled
	USBD_INTENSET_ENDEPOUT2_Disabled = 0x0
	// Read: Enabled
	USBD_INTENSET_ENDEPOUT2_Enabled = 0x1
	// Enable
	USBD_INTENSET_ENDEPOUT2_Set = 0x1
	// Position of ENDEPOUT3 field.
	USBD_INTENSET_ENDEPOUT3_Pos = 0xf
	// Bit mask of ENDEPOUT3 field.
	USBD_INTENSET_ENDEPOUT3_Msk = 0x8000
	// Bit ENDEPOUT3.
	USBD_INTENSET_ENDEPOUT3 = 0x8000
	// Read: Disabled
	USBD_INTENSET_ENDEPOUT3_Disabled = 0x0
	// Read: Enabled
	USBD_INTENSET_ENDEPOUT3_Enabled = 0x1
	// Enable
	USBD_INTENSET_ENDEPOUT3_Set = 0x1
	// Position of ENDEPOUT4 field.
	USBD_INTENSET_ENDEPOUT4_Pos = 0x10
	// Bit mask of ENDEPOUT4 field.
	USBD_INTENSET_ENDEPOUT4_Msk = 0x10000
	// Bit ENDEPOUT4.
	USBD_INTENSET_ENDEPOUT4 = 0x10000
	// Read: Disabled
	USBD_INTENSET_ENDEPOUT4_Disabled = 0x0
	// Read: Enabled
	USBD_INTENSET_ENDEPOUT4_Enabled = 0x1
	// Enable
	USBD_INTENSET_ENDEPOUT4_Set = 0x1
	// Position of ENDEPOUT5 field.
	USBD_INTENSET_ENDEPOUT5_Pos = 0x11
	// Bit mask of ENDEPOUT5 field.
	USBD_INTENSET_ENDEPOUT5_Msk = 0x20000
	// Bit ENDEPOUT5.
	USBD_INTENSET_ENDEPOUT5 = 0x20000
	// Read: Disabled
	USBD_INTENSET_ENDEPOUT5_Disabled = 0x0
	// Read: Enabled
	USBD_INTENSET_ENDEPOUT5_Enabled = 0x1
	// Enable
	USBD_INTENSET_ENDEPOUT5_Set = 0x1
	// Position of ENDEPOUT6 field.
	USBD_INTENSET_ENDEPOUT6_Pos = 0x12
	// Bit mask of ENDEPOUT6 field.
	USBD_INTENSET_ENDEPOUT6_Msk = 0x40000
	// Bit ENDEPOUT6.
	USBD_INTENSET_ENDEPOUT6 = 0x40000
	// Read: Disabled
	USBD_INTENSET_ENDEPOUT6_Disabled = 0x0
	// Read: Enabled
	USBD_INTENSET_ENDEPOUT6_Enabled = 0x1
	// Enable
	USBD_INTENSET_ENDEPOUT6_Set = 0x1
	// Position of ENDEPOUT7 field.
	USBD_INTENSET_ENDEPOUT7_Pos = 0x13
	// Bit mask of ENDEPOUT7 field.
	USBD_INTENSET_ENDEPOUT7_Msk = 0x80000
	// Bit ENDEPOUT7.
	USBD_INTENSET_ENDEPOUT7 = 0x80000
	// Read: Disabled
	USBD_INTENSET_ENDEPOUT7_Disabled = 0x0
	// Read: Enabled
	USBD_INTENSET_ENDEPOUT7_Enabled = 0x1
	// Enable
	USBD_INTENSET_ENDEPOUT7_Set = 0x1
	// Position of ENDISOOUT field.
	USBD_INTENSET_ENDISOOUT_Pos = 0x14
	// Bit mask of ENDISOOUT field.
	USBD_INTENSET_ENDISOOUT_Msk = 0x100000
	// Bit ENDISOOUT.
	USBD_INTENSET_ENDISOOUT = 0x100000
	// Read: Disabled
	USBD_INTENSET_ENDISOOUT_Disabled = 0x0
	// Read: Enabled
	USBD_INTENSET_ENDISOOUT_Enabled = 0x1
	// Enable
	USBD_INTENSET_ENDISOOUT_Set = 0x1
	// Position of SOF field.
	USBD_INTENSET_SOF_Pos = 0x15
	// Bit mask of SOF field.
	USBD_INTENSET_SOF_Msk = 0x200000
	// Bit SOF.
	USBD_INTENSET_SOF = 0x200000
	// Read: Disabled
	USBD_INTENSET_SOF_Disabled = 0x0
	// Read: Enabled
	USBD_INTENSET_SOF_Enabled = 0x1
	// Enable
	USBD_INTENSET_SOF_Set = 0x1
	// Position of USBEVENT field.
	USBD_INTENSET_USBEVENT_Pos = 0x16
	// Bit mask of USBEVENT field.
	USBD_INTENSET_USBEVENT_Msk = 0x400000
	// Bit USBEVENT.
	USBD_INTENSET_USBEVENT = 0x400000
	// Read: Disabled
	USBD_INTENSET_USBEVENT_Disabled = 0x0
	// Read: Enabled
	USBD_INTENSET_USBEVENT_Enabled = 0x1
	// Enable
	USBD_INTENSET_USBEVENT_Set = 0x1
	// Position of EP0SETUP field.
	USBD_INTENSET_EP0SETUP_Pos = 0x17
	// Bit mask of EP0SETUP field.
	USBD_INTENSET_EP0SETUP_Msk = 0x800000
	// Bit EP0SETUP.
	USBD_INTENSET_EP0SETUP = 0x800000
	// Read: Disabled
	USBD_INTENSET_EP0SETUP_Disabled = 0x0
	// Read: Enabled
	USBD_INTENSET_EP0SETUP_Enabled = 0x1
	// Enable
	USBD_INTENSET_EP0SETUP_Set = 0x1
	// Position of EPDATA field.
	USBD_INTENSET_EPDATA_Pos = 0x18
	// Bit mask of EPDATA field.
	USBD_INTENSET_EPDATA_Msk = 0x1000000
	// Bit EPDATA.
	USBD_INTENSET_EPDATA = 0x1000000
	// Read: Disabled
	USBD_INTENSET_EPDATA_Disabled = 0x0
	// Read: Enabled
	USBD_INTENSET_EPDATA_Enabled = 0x1
	// Enable
	USBD_INTENSET_EPDATA_Set = 0x1

	// INTENCLR: Disable interrupt
	// Position of USBRESET field.
	USBD_INTENCLR_USBRESET_Pos = 0x0
	// Bit mask of USBRESET field.
	USBD_INTENCLR_USBRESET_Msk = 0x1
	// Bit USBRESET.
	USBD_INTENCLR_USBRESET = 0x1
	// Read: Disabled
	USBD_INTENCLR_USBRESET_Disabled = 0x0
	// Read: Enabled
	USBD_INTENCLR_USBRESET_Enabled = 0x1
	// Disable
	USBD_INTENCLR_USBRESET_Clear = 0x1
	// Position of STARTED field.
	USBD_INTENCLR_STARTED_Pos = 0x1
	// Bit mask of STARTED field.
	USBD_INTENCLR_STARTED_Msk = 0x2
	// Bit STARTED.
	USBD_INTENCLR_STARTED = 0x2
	// Read: Disabled
	USBD_INTENCLR_STARTED_Disabled = 0x0
	// Read: Enabled
	USBD_INTENCLR_STARTED_Enabled = 0x1
	// Disable
	USBD_INTENCLR_STARTED_Clear = 0x1
	// Position of ENDEPIN0 field.
	USBD_INTENCLR_ENDEPIN0_Pos = 0x2
	// Bit mask of ENDEPIN0 field.
	USBD_INTENCLR_ENDEPIN0_Msk = 0x4
	// Bit ENDEPIN0.
	USBD_INTENCLR_ENDEPIN0 = 0x4
	// Read: Disabled
	USBD_INTENCLR_ENDEPIN0_Disabled = 0x0
	// Read: Enabled
	USBD_INTENCLR_ENDEPIN0_Enabled = 0x1
	// Disable
	USBD_INTENCLR_ENDEPIN0_Clear = 0x1
	// Position of ENDEPIN1 field.
	USBD_INTENCLR_ENDEPIN1_Pos = 0x3
	// Bit mask of ENDEPIN1 field.
	USBD_INTENCLR_ENDEPIN1_Msk = 0x8
	// Bit ENDEPIN1.
	USBD_INTENCLR_ENDEPIN1 = 0x8
	// Read: Disabled
	USBD_INTENCLR_ENDEPIN1_Disabled = 0x0
	// Read: Enabled
	USBD_INTENCLR_ENDEPIN1_Enabled = 0x1
	// Disable
	USBD_INTENCLR_ENDEPIN1_Clear = 0x1
	// Position of ENDEPIN2 field.
	USBD_INTENCLR_ENDEPIN2_Pos = 0x4
	// Bit mask of ENDEPIN2 field.
	USBD_INTENCLR_ENDEPIN2_Msk = 0x10
	// Bit ENDEPIN2.
	USBD_INTENCLR_ENDEPIN2 = 0x10
	// Read: Disabled
	USBD_INTENCLR_ENDEPIN2_Disabled = 0x0
	// Read: Enabled
	USBD_INTENCLR_ENDEPIN2_Enabled = 0x1
	// Disable
	USBD_INTENCLR_ENDEPIN2_Clear = 0x1
	// Position of ENDEPIN3 field.
	USBD_INTENCLR_ENDEPIN3_Pos = 0x5
	// Bit mask of ENDEPIN3 field.
	USBD_INTENCLR_ENDEPIN3_Msk = 0x20
	// Bit ENDEPIN3.
	USBD_INTENCLR_ENDEPIN3 = 0x20
	// Read: Disabled
	USBD_INTENCLR_ENDEPIN3_Disabled = 0x0
	// Read: Enabled
	USBD_INTENCLR_ENDEPIN3_Enabled = 0x1
	// Disable
	USBD_INTENCLR_ENDEPIN3_Clear = 0x1
	// Position of ENDEPIN4 field.
	USBD_INTENCLR_ENDEPIN4_Pos = 0x6
	// Bit mask of ENDEPIN4 field.
	USBD_INTENCLR_ENDEPIN4_Msk = 0x40
	// Bit ENDEPIN4.
	USBD_INTENCLR_ENDEPIN4 = 0x40
	// Read: Disabled
	USBD_INTENCLR_ENDEPIN4_Disabled = 0x0
	// Read: Enabled
	USBD_INTENCLR_ENDEPIN4_Enabled = 0x1
	// Disable
	USBD_INTENCLR_ENDEPIN4_Clear = 0x1
	// Position of ENDEPIN5 field.
	USBD_INTENCLR_ENDEPIN5_Pos = 0x7
	// Bit mask of ENDEPIN5 field.
	USBD_INTENCLR_ENDEPIN5_Msk = 0x80
	// Bit ENDEPIN5.
	USBD_INTENCLR_ENDEPIN5 = 0x80
	// Read: Disabled
	USBD_INTENCLR_ENDEPIN5_Disabled = 0x0
	// Read: Enabled
	USBD_INTENCLR_ENDEPIN5_Enabled = 0x1
	// Disable
	USBD_INTENCLR_ENDEPIN5_Clear = 0x1
	// Position of ENDEPIN6 field.
	USBD_INTENCLR_ENDEPIN6_Pos = 0x8
	// Bit mask of ENDEPIN6 field.
	USBD_INTENCLR_ENDEPIN6_Msk = 0x100
	// Bit ENDEPIN6.
	USBD_INTENCLR_ENDEPIN6 = 0x100
	// Read: Disabled
	USBD_INTENCLR_ENDEPIN6_Disabled = 0x0
	// Read: Enabled
	USBD_INTENCLR_ENDEPIN6_Enabled = 0x1
	// Disable
	USBD_INTENCLR_ENDEPIN6_Clear = 0x1
	// Position of ENDEPIN7 field.
	USBD_INTENCLR_ENDEPIN7_Pos = 0x9
	// Bit mask of ENDEPIN7 field.
	USBD_INTENCLR_ENDEPIN7_Msk = 0x200
	// Bit ENDEPIN7.
	USBD_INTENCLR_ENDEPIN7 = 0x200
	// Read: Disabled
	USBD_INTENCLR_ENDEPIN7_Disabled = 0x0
	// Read: Enabled
	USBD_INTENCLR_ENDEPIN7_Enabled = 0x1
	// Disable
	USBD_INTENCLR_ENDEPIN7_Clear = 0x1
	// Position of EP0DATADONE field.
	USBD_INTENCLR_EP0DATADONE_Pos = 0xa
	// Bit mask of EP0DATADONE field.
	USBD_INTENCLR_EP0DATADONE_Msk = 0x400
	// Bit EP0DATADONE.
	USBD_INTENCLR_EP0DATADONE = 0x400
	// Read: Disabled
	USBD_INTENCLR_EP0DATADONE_Disabled = 0x0
	// Read: Enabled
	USBD_INTENCLR_EP0DATADONE_Enabled = 0x1
	// Disable
	USBD_INTENCLR_EP0DATADONE_Clear = 0x1
	// Position of ENDISOIN field.
	USBD_INTENCLR_ENDISOIN_Pos = 0xb
	// Bit mask of ENDISOIN field.
	USBD_INTENCLR_ENDISOIN_Msk = 0x800
	// Bit ENDISOIN.
	USBD_INTENCLR_ENDISOIN = 0x800
	// Read: Disabled
	USBD_INTENCLR_ENDISOIN_Disabled = 0x0
	// Read: Enabled
	USBD_INTENCLR_ENDISOIN_Enabled = 0x1
	// Disable
	USBD_INTENCLR_ENDISOIN_Clear = 0x1
	// Position of ENDEPOUT0 field.
	USBD_INTENCLR_ENDEPOUT0_Pos = 0xc
	// Bit mask of ENDEPOUT0 field.
	USBD_INTENCLR_ENDEPOUT0_Msk = 0x1000
	// Bit ENDEPOUT0.
	USBD_INTENCLR_ENDEPOUT0 = 0x1000
	// Read: Disabled
	USBD_INTENCLR_ENDEPOUT0_Disabled = 0x0
	// Read: Enabled
	USBD_INTENCLR_ENDEPOUT0_Enabled = 0x1
	// Disable
	USBD_INTENCLR_ENDEPOUT0_Clear = 0x1
	// Position of ENDEPOUT1 field.
	USBD_INTENCLR_ENDEPOUT1_Pos = 0xd
	// Bit mask of ENDEPOUT1 field.
	USBD_INTENCLR_ENDEPOUT1_Msk = 0x2000
	// Bit ENDEPOUT1.
	USBD_INTENCLR_ENDEPOUT1 = 0x2000
	// Read: Disabled
	USBD_INTENCLR_ENDEPOUT1_Disabled = 0x0
	// Read: Enabled
	USBD_INTENCLR_ENDEPOUT1_Enabled = 0x1
	// Disable
	USBD_INTENCLR_ENDEPOUT1_Clear = 0x1
	// Position of ENDEPOUT2 field.
	USBD_INTENCLR_ENDEPOUT2_Pos = 0xe
	// Bit mask of ENDEPOUT2 field.
	USBD_INTENCLR_ENDEPOUT2_Msk = 0x4000
	// Bit ENDEPOUT2.
	USBD_INTENCLR_ENDEPOUT2 = 0x4000
	// Read: Disabled
	USBD_INTENCLR_ENDEPOUT2_Disabled = 0x0
	// Read: Enabled
	USBD_INTENCLR_ENDEPOUT2_Enabled = 0x1
	// Disable
	USBD_INTENCLR_ENDEPOUT2_Clear = 0x1
	// Position of ENDEPOUT3 field.
	USBD_INTENCLR_ENDEPOUT3_Pos = 0xf
	// Bit mask of ENDEPOUT3 field.
	USBD_INTENCLR_ENDEPOUT3_Msk = 0x8000
	// Bit ENDEPOUT3.
	USBD_INTENCLR_ENDEPOUT3 = 0x8000
	// Read: Disabled
	USBD_INTENCLR_ENDEPOUT3_Disabled = 0x0
	// Read: Enabled
	USBD_INTENCLR_ENDEPOUT3_Enabled = 0x1
	// Disable
	USBD_INTENCLR_ENDEPOUT3_Clear = 0x1
	// Position of ENDEPOUT4 field.
	USBD_INTENCLR_ENDEPOUT4_Pos = 0x10
	// Bit mask of ENDEPOUT4 field.
	USBD_INTENCLR_ENDEPOUT4_Msk = 0x10000
	// Bit ENDEPOUT4.
	USBD_INTENCLR_ENDEPOUT4 = 0x10000
	// Read: Disabled
	USBD_INTENCLR_ENDEPOUT4_Disabled = 0x0
	// Read: Enabled
	USBD_INTENCLR_ENDEPOUT4_Enabled = 0x1
	// Disable
	USBD_INTENCLR_ENDEPOUT4_Clear = 0x1
	// Position of ENDEPOUT5 field.
	USBD_INTENCLR_ENDEPOUT5_Pos = 0x11
	// Bit mask of ENDEPOUT5 field.
	USBD_INTENCLR_ENDEPOUT5_Msk = 0x20000
	// Bit ENDEPOUT5.
	USBD_INTENCLR_ENDEPOUT5 = 0x20000
	// Read: Disabled
	USBD_INTENCLR_ENDEPOUT5_Disabled = 0x0
	// Read: Enabled
	USBD_INTENCLR_ENDEPOUT5_Enabled = 0x1
	// Disable
	USBD_INTENCLR_ENDEPOUT5_Clear = 0x1
	// Position of ENDEPOUT6 field.
	USBD_INTENCLR_ENDEPOUT6_Pos = 0x12
	// Bit mask of ENDEPOUT6 field.
	USBD_INTENCLR_ENDEPOUT6_Msk = 0x40000
	// Bit ENDEPOUT6.
	USBD_INTENCLR_ENDEPOUT6 = 0x40000
	// Read: Disabled
	USBD_INTENCLR_ENDEPOUT6_Disabled = 0x0
	// Read: Enabled
	USBD_INTENCLR_ENDEPOUT6_Enabled = 0x1
	// Disable
	USBD_INTENCLR_ENDEPOUT6_Clear = 0x1
	// Position of ENDEPOUT7 field.
	USBD_INTENCLR_ENDEPOUT7_Pos = 0x13
	// Bit mask of ENDEPOUT7 field.
	USBD_INTENCLR_ENDEPOUT7_Msk = 0x80000
	// Bit ENDEPOUT7.
	USBD_INTENCLR_ENDEPOUT7 = 0x80000
	// Read: Disabled
	USBD_INTENCLR_ENDEPOUT7_Disabled = 0x0
	// Read: Enabled
	USBD_INTENCLR_ENDEPOUT7_Enabled = 0x1
	// Disable
	USBD_INTENCLR_ENDEPOUT7_Clear = 0x1
	// Position of ENDISOOUT field.
	USBD_INTENCLR_ENDISOOUT_Pos = 0x14
	// Bit mask of ENDISOOUT field.
	USBD_INTENCLR_ENDISOOUT_Msk = 0x100000
	// Bit ENDISOOUT.
	USBD_INTENCLR_ENDISOOUT = 0x100000
	// Read: Disabled
	USBD_INTENCLR_ENDISOOUT_Disabled = 0x0
	// Read: Enabled
	USBD_INTENCLR_ENDISOOUT_Enabled = 0x1
	// Disable
	USBD_INTENCLR_ENDISOOUT_Clear = 0x1
	// Position of SOF field.
	USBD_INTENCLR_SOF_Pos = 0x15
	// Bit mask of SOF field.
	USBD_INTENCLR_SOF_Msk = 0x200000
	// Bit SOF.
	USBD_INTENCLR_SOF = 0x200000
	// Read: Disabled
	USBD_INTENCLR_SOF_Disabled = 0x0
	// Read: Enabled
	USBD_INTENCLR_SOF_Enabled = 0x1
	// Disable
	USBD_INTENCLR_SOF_Clear = 0x1
	// Position of USBEVENT field.
	USBD_INTENCLR_USBEVENT_Pos = 0x16
	// Bit mask of USBEVENT field.
	USBD_INTENCLR_USBEVENT_Msk = 0x400000
	// Bit USBEVENT.
	USBD_INTENCLR_USBEVENT = 0x400000
	// Read: Disabled
	USBD_INTENCLR_USBEVENT_Disabled = 0x0
	// Read: Enabled
	USBD_INTENCLR_USBEVENT_Enabled = 0x1
	// Disable
	USBD_INTENCLR_USBEVENT_Clear = 0x1
	// Position of EP0SETUP field.
	USBD_INTENCLR_EP0SETUP_Pos = 0x17
	// Bit mask of EP0SETUP field.
	USBD_INTENCLR_EP0SETUP_Msk = 0x800000
	// Bit EP0SETUP.
	USBD_INTENCLR_EP0SETUP = 0x800000
	// Read: Disabled
	USBD_INTENCLR_EP0SETUP_Disabled = 0x0
	// Read: Enabled
	USBD_INTENCLR_EP0SETUP_Enabled = 0x1
	// Disable
	USBD_INTENCLR_EP0SETUP_Clear = 0x1
	// Position of EPDATA field.
	USBD_INTENCLR_EPDATA_Pos = 0x18
	// Bit mask of EPDATA field.
	USBD_INTENCLR_EPDATA_Msk = 0x1000000
	// Bit EPDATA.
	USBD_INTENCLR_EPDATA = 0x1000000
	// Read: Disabled
	USBD_INTENCLR_EPDATA_Disabled = 0x0
	// Read: Enabled
	USBD_INTENCLR_EPDATA_Enabled = 0x1
	// Disable
	USBD_INTENCLR_EPDATA_Clear = 0x1

	// EVENTCAUSE: Details on what caused the USBEVENT event
	// Position of ISOOUTCRC field.
	USBD_EVENTCAUSE_ISOOUTCRC_Pos = 0x0
	// Bit mask of ISOOUTCRC field.
	USBD_EVENTCAUSE_ISOOUTCRC_Msk = 0x1
	// Bit ISOOUTCRC.
	USBD_EVENTCAUSE_ISOOUTCRC = 0x1
	// No error detected
	USBD_EVENTCAUSE_ISOOUTCRC_NotDetected = 0x0
	// Error detected
	USBD_EVENTCAUSE_ISOOUTCRC_Detected = 0x1
	// Position of SUSPEND field.
	USBD_EVENTCAUSE_SUSPEND_Pos = 0x8
	// Bit mask of SUSPEND field.
	USBD_EVENTCAUSE_SUSPEND_Msk = 0x100
	// Bit SUSPEND.
	USBD_EVENTCAUSE_SUSPEND = 0x100
	// Suspend not detected
	USBD_EVENTCAUSE_SUSPEND_NotDetected = 0x0
	// Suspend detected
	USBD_EVENTCAUSE_SUSPEND_Detected = 0x1
	// Position of RESUME field.
	USBD_EVENTCAUSE_RESUME_Pos = 0x9
	// Bit mask of RESUME field.
	USBD_EVENTCAUSE_RESUME_Msk = 0x200
	// Bit RESUME.
	USBD_EVENTCAUSE_RESUME = 0x200
	// Resume not detected
	USBD_EVENTCAUSE_RESUME_NotDetected = 0x0
	// Resume detected
	USBD_EVENTCAUSE_RESUME_Detected = 0x1
	// Position of USBWUALLOWED field.
	USBD_EVENTCAUSE_USBWUALLOWED_Pos = 0xa
	// Bit mask of USBWUALLOWED field.
	USBD_EVENTCAUSE_USBWUALLOWED_Msk = 0x400
	// Bit USBWUALLOWED.
	USBD_EVENTCAUSE_USBWUALLOWED = 0x400
	// Wake up not allowed
	USBD_EVENTCAUSE_USBWUALLOWED_NotAllowed = 0x0
	// Wake up allowed
	USBD_EVENTCAUSE_USBWUALLOWED_Allowed = 0x1
	// Position of READY field.
	USBD_EVENTCAUSE_READY_Pos = 0xb
	// Bit mask of READY field.
	USBD_EVENTCAUSE_READY_Msk = 0x800
	// Bit READY.
	USBD_EVENTCAUSE_READY = 0x800
	// USBEVENT was not issued due to USBD peripheral ready
	USBD_EVENTCAUSE_READY_NotDetected = 0x0
	// USBD peripheral is ready
	USBD_EVENTCAUSE_READY_Ready = 0x1

	// HALTED.EPIN: Description collection: IN endpoint halted status. Can be used as is as response to a GetStatus() request to endpoint.
	// Position of GETSTATUS field.
	USBD_HALTED_EPIN_GETSTATUS_Pos = 0x0
	// Bit mask of GETSTATUS field.
	USBD_HALTED_EPIN_GETSTATUS_Msk = 0xffff
	// Endpoint is not halted
	USBD_HALTED_EPIN_GETSTATUS_NotHalted = 0x0
	// Endpoint is halted
	USBD_HALTED_EPIN_GETSTATUS_Halted = 0x1

	// HALTED.EPOUT: Description collection: OUT endpoint halted status. Can be used as is as response to a GetStatus() request to endpoint.
	// Position of GETSTATUS field.
	USBD_HALTED_EPOUT_GETSTATUS_Pos = 0x0
	// Bit mask of GETSTATUS field.
	USBD_HALTED_EPOUT_GETSTATUS_Msk = 0xffff
	// Endpoint is not halted
	USBD_HALTED_EPOUT_GETSTATUS_NotHalted = 0x0
	// Endpoint is halted
	USBD_HALTED_EPOUT_GETSTATUS_Halted = 0x1

	// EPSTATUS: Provides information on which endpoint's EasyDMA registers have been captured
	// Position of EPIN0 field.
	USBD_EPSTATUS_EPIN0_Pos = 0x0
	// Bit mask of EPIN0 field.
	USBD_EPSTATUS_EPIN0_Msk = 0x1
	// Bit EPIN0.
	USBD_EPSTATUS_EPIN0 = 0x1
	// EasyDMA registers have not been captured for this endpoint
	USBD_EPSTATUS_EPIN0_NoData = 0x0
	// EasyDMA registers have been captured for this endpoint
	USBD_EPSTATUS_EPIN0_DataDone = 0x1
	// Position of EPIN1 field.
	USBD_EPSTATUS_EPIN1_Pos = 0x1
	// Bit mask of EPIN1 field.
	USBD_EPSTATUS_EPIN1_Msk = 0x2
	// Bit EPIN1.
	USBD_EPSTATUS_EPIN1 = 0x2
	// EasyDMA registers have not been captured for this endpoint
	USBD_EPSTATUS_EPIN1_NoData = 0x0
	// EasyDMA registers have been captured for this endpoint
	USBD_EPSTATUS_EPIN1_DataDone = 0x1
	// Position of EPIN2 field.
	USBD_EPSTATUS_EPIN2_Pos = 0x2
	// Bit mask of EPIN2 field.
	USBD_EPSTATUS_EPIN2_Msk = 0x4
	// Bit EPIN2.
	USBD_EPSTATUS_EPIN2 = 0x4
	// EasyDMA registers have not been captured for this endpoint
	USBD_EPSTATUS_EPIN2_NoData = 0x0
	// EasyDMA registers have been captured for this endpoint
	USBD_EPSTATUS_EPIN2_DataDone = 0x1
	// Position of EPIN3 field.
	USBD_EPSTATUS_EPIN3_Pos = 0x3
	// Bit mask of EPIN3 field.
	USBD_EPSTATUS_EPIN3_Msk = 0x8
	// Bit EPIN3.
	USBD_EPSTATUS_EPIN3 = 0x8
	// EasyDMA registers have not been captured for this endpoint
	USBD_EPSTATUS_EPIN3_NoData = 0x0
	// EasyDMA registers have been captured for this endpoint
	USBD_EPSTATUS_EPIN3_DataDone = 0x1
	// Position of EPIN4 field.
	USBD_EPSTATUS_EPIN4_Pos = 0x4
	// Bit mask of EPIN4 field.
	USBD_EPSTATUS_EPIN4_Msk = 0x10
	// Bit EPIN4.
	USBD_EPSTATUS_EPIN4 = 0x10
	// EasyDMA registers have not been captured for this endpoint
	USBD_EPSTATUS_EPIN4_NoData = 0x0
	// EasyDMA registers have been captured for this endpoint
	USBD_EPSTATUS_EPIN4_DataDone = 0x1
	// Position of EPIN5 field.
	USBD_EPSTATUS_EPIN5_Pos = 0x5
	// Bit mask of EPIN5 field.
	USBD_EPSTATUS_EPIN5_Msk = 0x20
	// Bit EPIN5.
	USBD_EPSTATUS_EPIN5 = 0x20
	// EasyDMA registers have not been captured for this endpoint
	USBD_EPSTATUS_EPIN5_NoData = 0x0
	// EasyDMA registers have been captured for this endpoint
	USBD_EPSTATUS_EPIN5_DataDone = 0x1
	// Position of EPIN6 field.
	USBD_EPSTATUS_EPIN6_Pos = 0x6
	// Bit mask of EPIN6 field.
	USBD_EPSTATUS_EPIN6_Msk = 0x40
	// Bit EPIN6.
	USBD_EPSTATUS_EPIN6 = 0x40
	// EasyDMA registers have not been captured for this endpoint
	USBD_EPSTATUS_EPIN6_NoData = 0x0
	// EasyDMA registers have been captured for this endpoint
	USBD_EPSTATUS_EPIN6_DataDone = 0x1
	// Position of EPIN7 field.
	USBD_EPSTATUS_EPIN7_Pos = 0x7
	// Bit mask of EPIN7 field.
	USBD_EPSTATUS_EPIN7_Msk = 0x80
	// Bit EPIN7.
	USBD_EPSTATUS_EPIN7 = 0x80
	// EasyDMA registers have not been captured for this endpoint
	USBD_EPSTATUS_EPIN7_NoData = 0x0
	// EasyDMA registers have been captured for this endpoint
	USBD_EPSTATUS_EPIN7_DataDone = 0x1
	// Position of EPIN8 field.
	USBD_EPSTATUS_EPIN8_Pos = 0x8
	// Bit mask of EPIN8 field.
	USBD_EPSTATUS_EPIN8_Msk = 0x100
	// Bit EPIN8.
	USBD_EPSTATUS_EPIN8 = 0x100
	// EasyDMA registers have not been captured for this endpoint
	USBD_EPSTATUS_EPIN8_NoData = 0x0
	// EasyDMA registers have been captured for this endpoint
	USBD_EPSTATUS_EPIN8_DataDone = 0x1
	// Position of EPOUT0 field.
	USBD_EPSTATUS_EPOUT0_Pos = 0x10
	// Bit mask of EPOUT0 field.
	USBD_EPSTATUS_EPOUT0_Msk = 0x10000
	// Bit EPOUT0.
	USBD_EPSTATUS_EPOUT0 = 0x10000
	// EasyDMA registers have not been captured for this endpoint
	USBD_EPSTATUS_EPOUT0_NoData = 0x0
	// EasyDMA registers have been captured for this endpoint
	USBD_EPSTATUS_EPOUT0_DataDone = 0x1
	// Position of EPOUT1 field.
	USBD_EPSTATUS_EPOUT1_Pos = 0x11
	// Bit mask of EPOUT1 field.
	USBD_EPSTATUS_EPOUT1_Msk = 0x20000
	// Bit EPOUT1.
	USBD_EPSTATUS_EPOUT1 = 0x20000
	// EasyDMA registers have not been captured for this endpoint
	USBD_EPSTATUS_EPOUT1_NoData = 0x0
	// EasyDMA registers have been captured for this endpoint
	USBD_EPSTATUS_EPOUT1_DataDone = 0x1
	// Position of EPOUT2 field.
	USBD_EPSTATUS_EPOUT2_Pos = 0x12
	// Bit mask of EPOUT2 field.
	USBD_EPSTATUS_EPOUT2_Msk = 0x40000
	// Bit EPOUT2.
	USBD_EPSTATUS_EPOUT2 = 0x40000
	// EasyDMA registers have not been captured for this endpoint
	USBD_EPSTATUS_EPOUT2_NoData = 0x0
	// EasyDMA registers have been captured for this endpoint
	USBD_EPSTATUS_EPOUT2_DataDone = 0x1
	// Position of EPOUT3 field.
	USBD_EPSTATUS_EPOUT3_Pos = 0x13
	// Bit mask of EPOUT3 field.
	USBD_EPSTATUS_EPOUT3_Msk = 0x80000
	// Bit EPOUT3.
	USBD_EPSTATUS_EPOUT3 = 0x80000
	// EasyDMA registers have not been captured for this endpoint
	USBD_EPSTATUS_EPOUT3_NoData = 0x0
	// EasyDMA registers have been captured for this endpoint
	USBD_EPSTATUS_EPOUT3_DataDone = 0x1
	// Position of EPOUT4 field.
	USBD_EPSTATUS_EPOUT4_Pos = 0x14
	// Bit mask of EPOUT4 field.
	USBD_EPSTATUS_EPOUT4_Msk = 0x100000
	// Bit EPOUT4.
	USBD_EPSTATUS_EPOUT4 = 0x100000
	// EasyDMA registers have not been captured for this endpoint
	USBD_EPSTATUS_EPOUT4_NoData = 0x0
	// EasyDMA registers have been captured for this endpoint
	USBD_EPSTATUS_EPOUT4_DataDone = 0x1
	// Position of EPOUT5 field.
	USBD_EPSTATUS_EPOUT5_Pos = 0x15
	// Bit mask of EPOUT5 field.
	USBD_EPSTATUS_EPOUT5_Msk = 0x200000
	// Bit EPOUT5.
	USBD_EPSTATUS_EPOUT5 = 0x200000
	// EasyDMA registers have not been captured for this endpoint
	USBD_EPSTATUS_EPOUT5_NoData = 0x0
	// EasyDMA registers have been captured for this endpoint
	USBD_EPSTATUS_EPOUT5_DataDone = 0x1
	// Position of EPOUT6 field.
	USBD_EPSTATUS_EPOUT6_Pos = 0x16
	// Bit mask of EPOUT6 field.
	USBD_EPSTATUS_EPOUT6_Msk = 0x400000
	// Bit EPOUT6.
	USBD_EPSTATUS_EPOUT6 = 0x400000
	// EasyDMA registers have not been captured for this endpoint
	USBD_EPSTATUS_EPOUT6_NoData = 0x0
	// EasyDMA registers have been captured for this endpoint
	USBD_EPSTATUS_EPOUT6_DataDone = 0x1
	// Position of EPOUT7 field.
	USBD_EPSTATUS_EPOUT7_Pos = 0x17
	// Bit mask of EPOUT7 field.
	USBD_EPSTATUS_EPOUT7_Msk = 0x800000
	// Bit EPOUT7.
	USBD_EPSTATUS_EPOUT7 = 0x800000
	// EasyDMA registers have not been captured for this endpoint
	USBD_EPSTATUS_EPOUT7_NoData = 0x0
	// EasyDMA registers have been captured for this endpoint
	USBD_EPSTATUS_EPOUT7_DataDone = 0x1
	// Position of EPOUT8 field.
	USBD_EPSTATUS_EPOUT8_Pos = 0x18
	// Bit mask of EPOUT8 field.
	USBD_EPSTATUS_EPOUT8_Msk = 0x1000000
	// Bit EPOUT8.
	USBD_EPSTATUS_EPOUT8 = 0x1000000
	// EasyDMA registers have not been captured for this endpoint
	USBD_EPSTATUS_EPOUT8_NoData = 0x0
	// EasyDMA registers have been captured for this endpoint
	USBD_EPSTATUS_EPOUT8_DataDone = 0x1

	// EPDATASTATUS: Provides information on which endpoint(s) an acknowledged data transfer has occurred (EPDATA event)
	// Position of EPIN1 field.
	USBD_EPDATASTATUS_EPIN1_Pos = 0x1
	// Bit mask of EPIN1 field.
	USBD_EPDATASTATUS_EPIN1_Msk = 0x2
	// Bit EPIN1.
	USBD_EPDATASTATUS_EPIN1 = 0x2
	// No acknowledged data transfer on this endpoint
	USBD_EPDATASTATUS_EPIN1_NotDone = 0x0
	// Acknowledged data transfer on this endpoint has occurred
	USBD_EPDATASTATUS_EPIN1_DataDone = 0x1
	// Position of EPIN2 field.
	USBD_EPDATASTATUS_EPIN2_Pos = 0x2
	// Bit mask of EPIN2 field.
	USBD_EPDATASTATUS_EPIN2_Msk = 0x4
	// Bit EPIN2.
	USBD_EPDATASTATUS_EPIN2 = 0x4
	// No acknowledged data transfer on this endpoint
	USBD_EPDATASTATUS_EPIN2_NotDone = 0x0
	// Acknowledged data transfer on this endpoint has occurred
	USBD_EPDATASTATUS_EPIN2_DataDone = 0x1
	// Position of EPIN3 field.
	USBD_EPDATASTATUS_EPIN3_Pos = 0x3
	// Bit mask of EPIN3 field.
	USBD_EPDATASTATUS_EPIN3_Msk = 0x8
	// Bit EPIN3.
	USBD_EPDATASTATUS_EPIN3 = 0x8
	// No acknowledged data transfer on this endpoint
	USBD_EPDATASTATUS_EPIN3_NotDone = 0x0
	// Acknowledged data transfer on this endpoint has occurred
	USBD_EPDATASTATUS_EPIN3_DataDone = 0x1
	// Position of EPIN4 field.
	USBD_EPDATASTATUS_EPIN4_Pos = 0x4
	// Bit mask of EPIN4 field.
	USBD_EPDATASTATUS_EPIN4_Msk = 0x10
	// Bit EPIN4.
	USBD_EPDATASTATUS_EPIN4 = 0x10
	// No acknowledged data transfer on this endpoint
	USBD_EPDATASTATUS_EPIN4_NotDone = 0x0
	// Acknowledged data transfer on this endpoint has occurred
	USBD_EPDATASTATUS_EPIN4_DataDone = 0x1
	// Position of EPIN5 field.
	USBD_EPDATASTATUS_EPIN5_Pos = 0x5
	// Bit mask of EPIN5 field.
	USBD_EPDATASTATUS_EPIN5_Msk = 0x20
	// Bit EPIN5.
	USBD_EPDATASTATUS_EPIN5 = 0x20
	// No acknowledged data transfer on this endpoint
	USBD_EPDATASTATUS_EPIN5_NotDone = 0x0
	// Acknowledged data transfer on this endpoint has occurred
	USBD_EPDATASTATUS_EPIN5_DataDone = 0x1
	// Position of EPIN6 field.
	USBD_EPDATASTATUS_EPIN6_Pos = 0x6
	// Bit mask of EPIN6 field.
	USBD_EPDATASTATUS_EPIN6_Msk = 0x40
	// Bit EPIN6.
	USBD_EPDATASTATUS_EPIN6 = 0x40
	// No acknowledged data transfer on this endpoint
	USBD_EPDATASTATUS_EPIN6_NotDone = 0x0
	// Acknowledged data transfer on this endpoint has occurred
	USBD_EPDATASTATUS_EPIN6_DataDone = 0x1
	// Position of EPIN7 field.
	USBD_EPDATASTATUS_EPIN7_Pos = 0x7
	// Bit mask of EPIN7 field.
	USBD_EPDATASTATUS_EPIN7_Msk = 0x80
	// Bit EPIN7.
	USBD_EPDATASTATUS_EPIN7 = 0x80
	// No acknowledged data transfer on this endpoint
	USBD_EPDATASTATUS_EPIN7_NotDone = 0x0
	// Acknowledged data transfer on this endpoint has occurred
	USBD_EPDATASTATUS_EPIN7_DataDone = 0x1
	// Position of EPOUT1 field.
	USBD_EPDATASTATUS_EPOUT1_Pos = 0x11
	// Bit mask of EPOUT1 field.
	USBD_EPDATASTATUS_EPOUT1_Msk = 0x20000
	// Bit EPOUT1.
	USBD_EPDATASTATUS_EPOUT1 = 0x20000
	// No acknowledged data transfer on this endpoint
	USBD_EPDATASTATUS_EPOUT1_NotStarted = 0x0
	// Acknowledged data transfer on this endpoint has occurred
	USBD_EPDATASTATUS_EPOUT1_Started = 0x1
	// Position of EPOUT2 field.
	USBD_EPDATASTATUS_EPOUT2_Pos = 0x12
	// Bit mask of EPOUT2 field.
	USBD_EPDATASTATUS_EPOUT2_Msk = 0x40000
	// Bit EPOUT2.
	USBD_EPDATASTATUS_EPOUT2 = 0x40000
	// No acknowledged data transfer on this endpoint
	USBD_EPDATASTATUS_EPOUT2_NotStarted = 0x0
	// Acknowledged data transfer on this endpoint has occurred
	USBD_EPDATASTATUS_EPOUT2_Started = 0x1
	// Position of EPOUT3 field.
	USBD_EPDATASTATUS_EPOUT3_Pos = 0x13
	// Bit mask of EPOUT3 field.
	USBD_EPDATASTATUS_EPOUT3_Msk = 0x80000
	// Bit EPOUT3.
	USBD_EPDATASTATUS_EPOUT3 = 0x80000
	// No acknowledged data transfer on this endpoint
	USBD_EPDATASTATUS_EPOUT3_NotStarted = 0x0
	// Acknowledged data transfer on this endpoint has occurred
	USBD_EPDATASTATUS_EPOUT3_Started = 0x1
	// Position of EPOUT4 field.
	USBD_EPDATASTATUS_EPOUT4_Pos = 0x14
	// Bit mask of EPOUT4 field.
	USBD_EPDATASTATUS_EPOUT4_Msk = 0x100000
	// Bit EPOUT4.
	USBD_EPDATASTATUS_EPOUT4 = 0x100000
	// No acknowledged data transfer on this endpoint
	USBD_EPDATASTATUS_EPOUT4_NotStarted = 0x0
	// Acknowledged data transfer on this endpoint has occurred
	USBD_EPDATASTATUS_EPOUT4_Started = 0x1
	// Position of EPOUT5 field.
	USBD_EPDATASTATUS_EPOUT5_Pos = 0x15
	// Bit mask of EPOUT5 field.
	USBD_EPDATASTATUS_EPOUT5_Msk = 0x200000
	// Bit EPOUT5.
	USBD_EPDATASTATUS_EPOUT5 = 0x200000
	// No acknowledged data transfer on this endpoint
	USBD_EPDATASTATUS_EPOUT5_NotStarted = 0x0
	// Acknowledged data transfer on this endpoint has occurred
	USBD_EPDATASTATUS_EPOUT5_Started = 0x1
	// Position of EPOUT6 field.
	USBD_EPDATASTATUS_EPOUT6_Pos = 0x16
	// Bit mask of EPOUT6 field.
	USBD_EPDATASTATUS_EPOUT6_Msk = 0x400000
	// Bit EPOUT6.
	USBD_EPDATASTATUS_EPOUT6 = 0x400000
	// No acknowledged data transfer on this endpoint
	USBD_EPDATASTATUS_EPOUT6_NotStarted = 0x0
	// Acknowledged data transfer on this endpoint has occurred
	USBD_EPDATASTATUS_EPOUT6_Started = 0x1
	// Position of EPOUT7 field.
	USBD_EPDATASTATUS_EPOUT7_Pos = 0x17
	// Bit mask of EPOUT7 field.
	USBD_EPDATASTATUS_EPOUT7_Msk = 0x800000
	// Bit EPOUT7.
	USBD_EPDATASTATUS_EPOUT7 = 0x800000
	// No acknowledged data transfer on this endpoint
	USBD_EPDATASTATUS_EPOUT7_NotStarted = 0x0
	// Acknowledged data transfer on this endpoint has occurred
	USBD_EPDATASTATUS_EPOUT7_Started = 0x1

	// USBADDR: Device USB address
	// Position of ADDR field.
	USBD_USBADDR_ADDR_Pos = 0x0
	// Bit mask of ADDR field.
	USBD_USBADDR_ADDR_Msk = 0x7f

	// BMREQUESTTYPE: SETUP data, byte 0, bmRequestType
	// Position of RECIPIENT field.
	USBD_BMREQUESTTYPE_RECIPIENT_Pos = 0x0
	// Bit mask of RECIPIENT field.
	USBD_BMREQUESTTYPE_RECIPIENT_Msk = 0x1f
	// Device
	USBD_BMREQUESTTYPE_RECIPIENT_Device = 0x0
	// Interface
	USBD_BMREQUESTTYPE_RECIPIENT_Interface = 0x1
	// Endpoint
	USBD_BMREQUESTTYPE_RECIPIENT_Endpoint = 0x2
	// Other
	USBD_BMREQUESTTYPE_RECIPIENT_Other = 0x3
	// Position of TYPE field.
	USBD_BMREQUESTTYPE_TYPE_Pos = 0x5
	// Bit mask of TYPE field.
	USBD_BMREQUESTTYPE_TYPE_Msk = 0x60
	// Standard
	USBD_BMREQUESTTYPE_TYPE_Standard = 0x0
	// Class
	USBD_BMREQUESTTYPE_TYPE_Class = 0x1
	// Vendor
	USBD_BMREQUESTTYPE_TYPE_Vendor = 0x2
	// Position of DIRECTION field.
	USBD_BMREQUESTTYPE_DIRECTION_Pos = 0x7
	// Bit mask of DIRECTION field.
	USBD_BMREQUESTTYPE_DIRECTION_Msk = 0x80
	// Bit DIRECTION.
	USBD_BMREQUESTTYPE_DIRECTION = 0x80
	// Host-to-device
	USBD_BMREQUESTTYPE_DIRECTION_HostToDevice = 0x0
	// Device-to-host
	USBD_BMREQUESTTYPE_DIRECTION_DeviceToHost = 0x1

	// BREQUEST: SETUP data, byte 1, bRequest
	// Position of BREQUEST field.
	USBD_BREQUEST_BREQUEST_Pos = 0x0
	// Bit mask of BREQUEST field.
	USBD_BREQUEST_BREQUEST_Msk = 0xff
	// Standard request GET_STATUS
	USBD_BREQUEST_BREQUEST_STD_GET_STATUS = 0x0
	// Standard request CLEAR_FEATURE
	USBD_BREQUEST_BREQUEST_STD_CLEAR_FEATURE = 0x1
	// Standard request SET_FEATURE
	USBD_BREQUEST_BREQUEST_STD_SET_FEATURE = 0x3
	// Standard request SET_ADDRESS
	USBD_BREQUEST_BREQUEST_STD_SET_ADDRESS = 0x5
	// Standard request GET_DESCRIPTOR
	USBD_BREQUEST_BREQUEST_STD_GET_DESCRIPTOR = 0x6
	// Standard request SET_DESCRIPTOR
	USBD_BREQUEST_BREQUEST_STD_SET_DESCRIPTOR = 0x7
	// Standard request GET_CONFIGURATION
	USBD_BREQUEST_BREQUEST_STD_GET_CONFIGURATION = 0x8
	// Standard request SET_CONFIGURATION
	USBD_BREQUEST_BREQUEST_STD_SET_CONFIGURATION = 0x9
	// Standard request GET_INTERFACE
	USBD_BREQUEST_BREQUEST_STD_GET_INTERFACE = 0xa
	// Standard request SET_INTERFACE
	USBD_BREQUEST_BREQUEST_STD_SET_INTERFACE = 0xb
	// Standard request SYNCH_FRAME
	USBD_BREQUEST_BREQUEST_STD_SYNCH_FRAME = 0xc

	// WVALUEL: SETUP data, byte 2, LSB of wValue
	// Position of WVALUEL field.
	USBD_WVALUEL_WVALUEL_Pos = 0x0
	// Bit mask of WVALUEL field.
	USBD_WVALUEL_WVALUEL_Msk = 0xff

	// WVALUEH: SETUP data, byte 3, MSB of wValue
	// Position of WVALUEH field.
	USBD_WVALUEH_WVALUEH_Pos = 0x0
	// Bit mask of WVALUEH field.
	USBD_WVALUEH_WVALUEH_Msk = 0xff

	// WINDEXL: SETUP data, byte 4, LSB of wIndex
	// Position of WINDEXL field.
	USBD_WINDEXL_WINDEXL_Pos = 0x0
	// Bit mask of WINDEXL field.
	USBD_WINDEXL_WINDEXL_Msk = 0xff

	// WINDEXH: SETUP data, byte 5, MSB of wIndex
	// Position of WINDEXH field.
	USBD_WINDEXH_WINDEXH_Pos = 0x0
	// Bit mask of WINDEXH field.
	USBD_WINDEXH_WINDEXH_Msk = 0xff

	// WLENGTHL: SETUP data, byte 6, LSB of wLength
	// Position of WLENGTHL field.
	USBD_WLENGTHL_WLENGTHL_Pos = 0x0
	// Bit mask of WLENGTHL field.
	USBD_WLENGTHL_WLENGTHL_Msk = 0xff

	// WLENGTHH: SETUP data, byte 7, MSB of wLength
	// Position of WLENGTHH field.
	USBD_WLENGTHH_WLENGTHH_Pos = 0x0
	// Bit mask of WLENGTHH field.
	USBD_WLENGTHH_WLENGTHH_Msk = 0xff

	// SIZE.EPOUT: Description collection: Number of bytes received last in the data stage of this OUT endpoint
	// Position of SIZE field.
	USBD_SIZE_EPOUT_SIZE_Pos = 0x0
	// Bit mask of SIZE field.
	USBD_SIZE_EPOUT_SIZE_Msk = 0x7f

	// SIZE.ISOOUT: Number of bytes received last on this ISO OUT data endpoint
	// Position of SIZE field.
	USBD_SIZE_ISOOUT_SIZE_Pos = 0x0
	// Bit mask of SIZE field.
	USBD_SIZE_ISOOUT_SIZE_Msk = 0x3ff
	// Position of ZERO field.
	USBD_SIZE_ISOOUT_ZERO_Pos = 0x10
	// Bit mask of ZERO field.
	USBD_SIZE_ISOOUT_ZERO_Msk = 0x10000
	// Bit ZERO.
	USBD_SIZE_ISOOUT_ZERO = 0x10000
	// No zero-length data received, use value in SIZE
	USBD_SIZE_ISOOUT_ZERO_Normal = 0x0
	// Zero-length data received, ignore value in SIZE
	USBD_SIZE_ISOOUT_ZERO_ZeroData = 0x1

	// ENABLE: Enable USB
	// Position of ENABLE field.
	USBD_ENABLE_ENABLE_Pos = 0x0
	// Bit mask of ENABLE field.
	USBD_ENABLE_ENABLE_Msk = 0x1
	// Bit ENABLE.
	USBD_ENABLE_ENABLE = 0x1
	// USB peripheral is disabled
	USBD_ENABLE_ENABLE_Disabled = 0x0
	// USB peripheral is enabled
	USBD_ENABLE_ENABLE_Enabled = 0x1

	// USBPULLUP: Control of the USB pull-up
	// Position of CONNECT field.
	USBD_USBPULLUP_CONNECT_Pos = 0x0
	// Bit mask of CONNECT field.
	USBD_USBPULLUP_CONNECT_Msk = 0x1
	// Bit CONNECT.
	USBD_USBPULLUP_CONNECT = 0x1
	// Pull-up is disconnected
	USBD_USBPULLUP_CONNECT_Disabled = 0x0
	// Pull-up is connected to D+
	USBD_USBPULLUP_CONNECT_Enabled = 0x1

	// DPDMVALUE: State D+ and D- lines will be forced into by the DPDMDRIVE task. The DPDMNODRIVE task reverts the control of the lines to MAC IP (no forcing).
	// Position of STATE field.
	USBD_DPDMVALUE_STATE_Pos = 0x0
	// Bit mask of STATE field.
	USBD_DPDMVALUE_STATE_Msk = 0x1f
	// D+ forced low, D- forced high (K state) for a timing preset in hardware (50 us or 5 ms, depending on bus state)
	USBD_DPDMVALUE_STATE_Resume = 0x1
	// D+ forced high, D- forced low (J state)
	USBD_DPDMVALUE_STATE_J = 0x2
	// D+ forced low, D- forced high (K state)
	USBD_DPDMVALUE_STATE_K = 0x4

	// DTOGGLE: Data toggle control and status
	// Position of EP field.
	USBD_DTOGGLE_EP_Pos = 0x0
	// Bit mask of EP field.
	USBD_DTOGGLE_EP_Msk = 0x7
	// Position of IO field.
	USBD_DTOGGLE_IO_Pos = 0x7
	// Bit mask of IO field.
	USBD_DTOGGLE_IO_Msk = 0x80
	// Bit IO.
	USBD_DTOGGLE_IO = 0x80
	// Selects OUT endpoint
	USBD_DTOGGLE_IO_Out = 0x0
	// Selects IN endpoint
	USBD_DTOGGLE_IO_In = 0x1
	// Position of VALUE field.
	USBD_DTOGGLE_VALUE_Pos = 0x8
	// Bit mask of VALUE field.
	USBD_DTOGGLE_VALUE_Msk = 0x300
	// No action on data toggle when writing the register with this value
	USBD_DTOGGLE_VALUE_Nop = 0x0
	// Data toggle is DATA0 on endpoint set by EP and IO
	USBD_DTOGGLE_VALUE_Data0 = 0x1
	// Data toggle is DATA1 on endpoint set by EP and IO
	USBD_DTOGGLE_VALUE_Data1 = 0x2

	// EPINEN: Endpoint IN enable
	// Position of IN0 field.
	USBD_EPINEN_IN0_Pos = 0x0
	// Bit mask of IN0 field.
	USBD_EPINEN_IN0_Msk = 0x1
	// Bit IN0.
	USBD_EPINEN_IN0 = 0x1
	// Disable endpoint IN 0 (no response to IN tokens)
	USBD_EPINEN_IN0_Disable = 0x0
	// Enable endpoint IN 0 (response to IN tokens)
	USBD_EPINEN_IN0_Enable = 0x1
	// Position of IN1 field.
	USBD_EPINEN_IN1_Pos = 0x1
	// Bit mask of IN1 field.
	USBD_EPINEN_IN1_Msk = 0x2
	// Bit IN1.
	USBD_EPINEN_IN1 = 0x2
	// Disable endpoint IN 1 (no response to IN tokens)
	USBD_EPINEN_IN1_Disable = 0x0
	// Enable endpoint IN 1 (response to IN tokens)
	USBD_EPINEN_IN1_Enable = 0x1
	// Position of IN2 field.
	USBD_EPINEN_IN2_Pos = 0x2
	// Bit mask of IN2 field.
	USBD_EPINEN_IN2_Msk = 0x4
	// Bit IN2.
	USBD_EPINEN_IN2 = 0x4
	// Disable endpoint IN 2 (no response to IN tokens)
	USBD_EPINEN_IN2_Disable = 0x0
	// Enable endpoint IN 2 (response to IN tokens)
	USBD_EPINEN_IN2_Enable = 0x1
	// Position of IN3 field.
	USBD_EPINEN_IN3_Pos = 0x3
	// Bit mask of IN3 field.
	USBD_EPINEN_IN3_Msk = 0x8
	// Bit IN3.
	USBD_EPINEN_IN3 = 0x8
	// Disable endpoint IN 3 (no response to IN tokens)
	USBD_EPINEN_IN3_Disable = 0x0
	// Enable endpoint IN 3 (response to IN tokens)
	USBD_EPINEN_IN3_Enable = 0x1
	// Position of IN4 field.
	USBD_EPINEN_IN4_Pos = 0x4
	// Bit mask of IN4 field.
	USBD_EPINEN_IN4_Msk = 0x10
	// Bit IN4.
	USBD_EPINEN_IN4 = 0x10
	// Disable endpoint IN 4 (no response to IN tokens)
	USBD_EPINEN_IN4_Disable = 0x0
	// Enable endpoint IN 4 (response to IN tokens)
	USBD_EPINEN_IN4_Enable = 0x1
	// Position of IN5 field.
	USBD_EPINEN_IN5_Pos = 0x5
	// Bit mask of IN5 field.
	USBD_EPINEN_IN5_Msk = 0x20
	// Bit IN5.
	USBD_EPINEN_IN5 = 0x20
	// Disable endpoint IN 5 (no response to IN tokens)
	USBD_EPINEN_IN5_Disable = 0x0
	// Enable endpoint IN 5 (response to IN tokens)
	USBD_EPINEN_IN5_Enable = 0x1
	// Position of IN6 field.
	USBD_EPINEN_IN6_Pos = 0x6
	// Bit mask of IN6 field.
	USBD_EPINEN_IN6_Msk = 0x40
	// Bit IN6.
	USBD_EPINEN_IN6 = 0x40
	// Disable endpoint IN 6 (no response to IN tokens)
	USBD_EPINEN_IN6_Disable = 0x0
	// Enable endpoint IN 6 (response to IN tokens)
	USBD_EPINEN_IN6_Enable = 0x1
	// Position of IN7 field.
	USBD_EPINEN_IN7_Pos = 0x7
	// Bit mask of IN7 field.
	USBD_EPINEN_IN7_Msk = 0x80
	// Bit IN7.
	USBD_EPINEN_IN7 = 0x80
	// Disable endpoint IN 7 (no response to IN tokens)
	USBD_EPINEN_IN7_Disable = 0x0
	// Enable endpoint IN 7 (response to IN tokens)
	USBD_EPINEN_IN7_Enable = 0x1
	// Position of ISOIN field.
	USBD_EPINEN_ISOIN_Pos = 0x8
	// Bit mask of ISOIN field.
	USBD_EPINEN_ISOIN_Msk = 0x100
	// Bit ISOIN.
	USBD_EPINEN_ISOIN = 0x100
	// Disable ISO IN endpoint 8
	USBD_EPINEN_ISOIN_Disable = 0x0
	// Enable ISO IN endpoint 8
	USBD_EPINEN_ISOIN_Enable = 0x1

	// EPOUTEN: Endpoint OUT enable
	// Position of OUT0 field.
	USBD_EPOUTEN_OUT0_Pos = 0x0
	// Bit mask of OUT0 field.
	USBD_EPOUTEN_OUT0_Msk = 0x1
	// Bit OUT0.
	USBD_EPOUTEN_OUT0 = 0x1
	// Disable endpoint OUT 0 (no response to OUT tokens)
	USBD_EPOUTEN_OUT0_Disable = 0x0
	// Enable endpoint OUT 0 (response to OUT tokens)
	USBD_EPOUTEN_OUT0_Enable = 0x1
	// Position of OUT1 field.
	USBD_EPOUTEN_OUT1_Pos = 0x1
	// Bit mask of OUT1 field.
	USBD_EPOUTEN_OUT1_Msk = 0x2
	// Bit OUT1.
	USBD_EPOUTEN_OUT1 = 0x2
	// Disable endpoint OUT 1 (no response to OUT tokens)
	USBD_EPOUTEN_OUT1_Disable = 0x0
	// Enable endpoint OUT 1 (response to OUT tokens)
	USBD_EPOUTEN_OUT1_Enable = 0x1
	// Position of OUT2 field.
	USBD_EPOUTEN_OUT2_Pos = 0x2
	// Bit mask of OUT2 field.
	USBD_EPOUTEN_OUT2_Msk = 0x4
	// Bit OUT2.
	USBD_EPOUTEN_OUT2 = 0x4
	// Disable endpoint OUT 2 (no response to OUT tokens)
	USBD_EPOUTEN_OUT2_Disable = 0x0
	// Enable endpoint OUT 2 (response to OUT tokens)
	USBD_EPOUTEN_OUT2_Enable = 0x1
	// Position of OUT3 field.
	USBD_EPOUTEN_OUT3_Pos = 0x3
	// Bit mask of OUT3 field.
	USBD_EPOUTEN_OUT3_Msk = 0x8
	// Bit OUT3.
	USBD_EPOUTEN_OUT3 = 0x8
	// Disable endpoint OUT 3 (no response to OUT tokens)
	USBD_EPOUTEN_OUT3_Disable = 0x0
	// Enable endpoint OUT 3 (response to OUT tokens)
	USBD_EPOUTEN_OUT3_Enable = 0x1
	// Position of OUT4 field.
	USBD_EPOUTEN_OUT4_Pos = 0x4
	// Bit mask of OUT4 field.
	USBD_EPOUTEN_OUT4_Msk = 0x10
	// Bit OUT4.
	USBD_EPOUTEN_OUT4 = 0x10
	// Disable endpoint OUT 4 (no response to OUT tokens)
	USBD_EPOUTEN_OUT4_Disable = 0x0
	// Enable endpoint OUT 4 (response to OUT tokens)
	USBD_EPOUTEN_OUT4_Enable = 0x1
	// Position of OUT5 field.
	USBD_EPOUTEN_OUT5_Pos = 0x5
	// Bit mask of OUT5 field.
	USBD_EPOUTEN_OUT5_Msk = 0x20
	// Bit OUT5.
	USBD_EPOUTEN_OUT5 = 0x20
	// Disable endpoint OUT 5 (no response to OUT tokens)
	USBD_EPOUTEN_OUT5_Disable = 0x0
	// Enable endpoint OUT 5 (response to OUT tokens)
	USBD_EPOUTEN_OUT5_Enable = 0x1
	// Position of OUT6 field.
	USBD_EPOUTEN_OUT6_Pos = 0x6
	// Bit mask of OUT6 field.
	USBD_EPOUTEN_OUT6_Msk = 0x40
	// Bit OUT6.
	USBD_EPOUTEN_OUT6 = 0x40
	// Disable endpoint OUT 6 (no response to OUT tokens)
	USBD_EPOUTEN_OUT6_Disable = 0x0
	// Enable endpoint OUT 6 (response to OUT tokens)
	USBD_EPOUTEN_OUT6_Enable = 0x1
	// Position of OUT7 field.
	USBD_EPOUTEN_OUT7_Pos = 0x7
	// Bit mask of OUT7 field.
	USBD_EPOUTEN_OUT7_Msk = 0x80
	// Bit OUT7.
	USBD_EPOUTEN_OUT7 = 0x80
	// Disable endpoint OUT 7 (no response to OUT tokens)
	USBD_EPOUTEN_OUT7_Disable = 0x0
	// Enable endpoint OUT 7 (response to OUT tokens)
	USBD_EPOUTEN_OUT7_Enable = 0x1
	// Position of ISOOUT field.
	USBD_EPOUTEN_ISOOUT_Pos = 0x8
	// Bit mask of ISOOUT field.
	USBD_EPOUTEN_ISOOUT_Msk = 0x100
	// Bit ISOOUT.
	USBD_EPOUTEN_ISOOUT = 0x100
	// Disable ISO OUT endpoint 8
	USBD_EPOUTEN_ISOOUT_Disable = 0x0
	// Enable ISO OUT endpoint 8
	USBD_EPOUTEN_ISOOUT_Enable = 0x1

	// EPSTALL: STALL endpoints
	// Position of EP field.
	USBD_EPSTALL_EP_Pos = 0x0
	// Bit mask of EP field.
	USBD_EPSTALL_EP_Msk = 0x7
	// Position of IO field.
	USBD_EPSTALL_IO_Pos = 0x7
	// Bit mask of IO field.
	USBD_EPSTALL_IO_Msk = 0x80
	// Bit IO.
	USBD_EPSTALL_IO = 0x80
	// Selects OUT endpoint
	USBD_EPSTALL_IO_Out = 0x0
	// Selects IN endpoint
	USBD_EPSTALL_IO_In = 0x1
	// Position of STALL field.
	USBD_EPSTALL_STALL_Pos = 0x8
	// Bit mask of STALL field.
	USBD_EPSTALL_STALL_Msk = 0x100
	// Bit STALL.
	USBD_EPSTALL_STALL = 0x100
	// Don't stall selected endpoint
	USBD_EPSTALL_STALL_UnStall = 0x0
	// Stall selected endpoint
	USBD_EPSTALL_STALL_Stall = 0x1

	// ISOSPLIT: Controls the split of ISO buffers
	// Position of SPLIT field.
	USBD_ISOSPLIT_SPLIT_Pos = 0x0
	// Bit mask of SPLIT field.
	USBD_ISOSPLIT_SPLIT_Msk = 0xffff
	// Full buffer dedicated to either iso IN or OUT
	USBD_ISOSPLIT_SPLIT_OneDir = 0x0
	// Lower half for IN, upper half for OUT
	USBD_ISOSPLIT_SPLIT_HalfIN = 0x80

	// FRAMECNTR: Returns the current value of the start of frame counter
	// Position of FRAMECNTR field.
	USBD_FRAMECNTR_FRAMECNTR_Pos = 0x0
	// Bit mask of FRAMECNTR field.
	USBD_FRAMECNTR_FRAMECNTR_Msk = 0x7ff

	// LOWPOWER: Controls USBD peripheral low power mode during USB suspend
	// Position of LOWPOWER field.
	USBD_LOWPOWER_LOWPOWER_Pos = 0x0
	// Bit mask of LOWPOWER field.
	USBD_LOWPOWER_LOWPOWER_Msk = 0x1
	// Bit LOWPOWER.
	USBD_LOWPOWER_LOWPOWER = 0x1
	// Software must write this value to exit low power mode and before performing a remote wake-up
	USBD_LOWPOWER_LOWPOWER_ForceNormal = 0x0
	// Software must write this value to enter low power mode after DMA and software have finished interacting with the USB peripheral
	USBD_LOWPOWER_LOWPOWER_LowPower = 0x1

	// ISOINCONFIG: Controls the response of the ISO IN endpoint to an IN token when no data is ready to be sent
	// Position of RESPONSE field.
	USBD_ISOINCONFIG_RESPONSE_Pos = 0x0
	// Bit mask of RESPONSE field.
	USBD_ISOINCONFIG_RESPONSE_Msk = 0x1
	// Bit RESPONSE.
	USBD_ISOINCONFIG_RESPONSE = 0x1
	// Endpoint does not respond in that case
	USBD_ISOINCONFIG_RESPONSE_NoResp = 0x0
	// Endpoint responds with a zero-length data packet in that case
	USBD_ISOINCONFIG_RESPONSE_ZeroData = 0x1

	// EPIN.PTR: Description cluster: Data pointer
	// Position of PTR field.
	USBD_EPIN_PTR_PTR_Pos = 0x0
	// Bit mask of PTR field.
	USBD_EPIN_PTR_PTR_Msk = 0xffffffff

	// EPIN.MAXCNT: Description cluster: Maximum number of bytes to transfer
	// Position of MAXCNT field.
	USBD_EPIN_MAXCNT_MAXCNT_Pos = 0x0
	// Bit mask of MAXCNT field.
	USBD_EPIN_MAXCNT_MAXCNT_Msk = 0x7f

	// EPIN.AMOUNT: Description cluster: Number of bytes transferred in the last transaction
	// Position of AMOUNT field.
	USBD_EPIN_AMOUNT_AMOUNT_Pos = 0x0
	// Bit mask of AMOUNT field.
	USBD_EPIN_AMOUNT_AMOUNT_Msk = 0x7f

	// ISOIN.PTR: Data pointer
	// Position of PTR field.
	USBD_ISOIN_PTR_PTR_Pos = 0x0
	// Bit mask of PTR field.
	USBD_ISOIN_PTR_PTR_Msk = 0xffffffff

	// ISOIN.MAXCNT: Maximum number of bytes to transfer
	// Position of MAXCNT field.
	USBD_ISOIN_MAXCNT_MAXCNT_Pos = 0x0
	// Bit mask of MAXCNT field.
	USBD_ISOIN_MAXCNT_MAXCNT_Msk = 0x3ff

	// ISOIN.AMOUNT: Number of bytes transferred in the last transaction
	// Position of AMOUNT field.
	USBD_ISOIN_AMOUNT_AMOUNT_Pos = 0x0
	// Bit mask of AMOUNT field.
	USBD_ISOIN_AMOUNT_AMOUNT_Msk = 0x3ff

	// EPOUT.PTR: Description cluster: Data pointer
	// Position of PTR field.
	USBD_EPOUT_PTR_PTR_Pos = 0x0
	// Bit mask of PTR field.
	USBD_EPOUT_PTR_PTR_Msk = 0xffffffff

	// EPOUT.MAXCNT: Description cluster: Maximum number of bytes to transfer
	// Position of MAXCNT field.
	USBD_EPOUT_MAXCNT_MAXCNT_Pos = 0x0
	// Bit mask of MAXCNT field.
	USBD_EPOUT_MAXCNT_MAXCNT_Msk = 0x7f

	// EPOUT.AMOUNT: Description cluster: Number of bytes transferred in the last transaction
	// Position of AMOUNT field.
	USBD_EPOUT_AMOUNT_AMOUNT_Pos = 0x0
	// Bit mask of AMOUNT field.
	USBD_EPOUT_AMOUNT_AMOUNT_Msk = 0x7f

	// ISOOUT.PTR: Data pointer
	// Position of PTR field.
	USBD_ISOOUT_PTR_PTR_Pos = 0x0
	// Bit mask of PTR field.
	USBD_ISOOUT_PTR_PTR_Msk = 0xffffffff

	// ISOOUT.MAXCNT: Maximum number of bytes to transfer
	// Position of MAXCNT field.
	USBD_ISOOUT_MAXCNT_MAXCNT_Pos = 0x0
	// Bit mask of MAXCNT field.
	USBD_ISOOUT_MAXCNT_MAXCNT_Msk = 0x3ff

	// ISOOUT.AMOUNT: Number of bytes transferred in the last transaction
	// Position of AMOUNT field.
	USBD_ISOOUT_AMOUNT_AMOUNT_Pos = 0x0
	// Bit mask of AMOUNT field.
	USBD_ISOOUT_AMOUNT_AMOUNT_Msk = 0x3ff
)

// Bitfields for QSPI: External flash interface
const (
	// TASKS_ACTIVATE: Activate QSPI interface
	// Position of TASKS_ACTIVATE field.
	QSPI_TASKS_ACTIVATE_TASKS_ACTIVATE_Pos = 0x0
	// Bit mask of TASKS_ACTIVATE field.
	QSPI_TASKS_ACTIVATE_TASKS_ACTIVATE_Msk = 0x1
	// Bit TASKS_ACTIVATE.
	QSPI_TASKS_ACTIVATE_TASKS_ACTIVATE = 0x1
	// Trigger task
	QSPI_TASKS_ACTIVATE_TASKS_ACTIVATE_Trigger = 0x1

	// TASKS_READSTART: Start transfer from external flash memory to internal RAM
	// Position of TASKS_READSTART field.
	QSPI_TASKS_READSTART_TASKS_READSTART_Pos = 0x0
	// Bit mask of TASKS_READSTART field.
	QSPI_TASKS_READSTART_TASKS_READSTART_Msk = 0x1
	// Bit TASKS_READSTART.
	QSPI_TASKS_READSTART_TASKS_READSTART = 0x1
	// Trigger task
	QSPI_TASKS_READSTART_TASKS_READSTART_Trigger = 0x1

	// TASKS_WRITESTART: Start transfer from internal RAM to external flash memory
	// Position of TASKS_WRITESTART field.
	QSPI_TASKS_WRITESTART_TASKS_WRITESTART_Pos = 0x0
	// Bit mask of TASKS_WRITESTART field.
	QSPI_TASKS_WRITESTART_TASKS_WRITESTART_Msk = 0x1
	// Bit TASKS_WRITESTART.
	QSPI_TASKS_WRITESTART_TASKS_WRITESTART = 0x1
	// Trigger task
	QSPI_TASKS_WRITESTART_TASKS_WRITESTART_Trigger = 0x1

	// TASKS_ERASESTART: Start external flash memory erase operation
	// Position of TASKS_ERASESTART field.
	QSPI_TASKS_ERASESTART_TASKS_ERASESTART_Pos = 0x0
	// Bit mask of TASKS_ERASESTART field.
	QSPI_TASKS_ERASESTART_TASKS_ERASESTART_Msk = 0x1
	// Bit TASKS_ERASESTART.
	QSPI_TASKS_ERASESTART_TASKS_ERASESTART = 0x1
	// Trigger task
	QSPI_TASKS_ERASESTART_TASKS_ERASESTART_Trigger = 0x1

	// TASKS_DEACTIVATE: Deactivate QSPI interface
	// Position of TASKS_DEACTIVATE field.
	QSPI_TASKS_DEACTIVATE_TASKS_DEACTIVATE_Pos = 0x0
	// Bit mask of TASKS_DEACTIVATE field.
	QSPI_TASKS_DEACTIVATE_TASKS_DEACTIVATE_Msk = 0x1
	// Bit TASKS_DEACTIVATE.
	QSPI_TASKS_DEACTIVATE_TASKS_DEACTIVATE = 0x1
	// Trigger task
	QSPI_TASKS_DEACTIVATE_TASKS_DEACTIVATE_Trigger = 0x1

	// EVENTS_READY: QSPI peripheral is ready. This event will be generated as a response to any QSPI task.
	// Position of EVENTS_READY field.
	QSPI_EVENTS_READY_EVENTS_READY_Pos = 0x0
	// Bit mask of EVENTS_READY field.
	QSPI_EVENTS_READY_EVENTS_READY_Msk = 0x1
	// Bit EVENTS_READY.
	QSPI_EVENTS_READY_EVENTS_READY = 0x1
	// Event not generated
	QSPI_EVENTS_READY_EVENTS_READY_NotGenerated = 0x0
	// Event generated
	QSPI_EVENTS_READY_EVENTS_READY_Generated = 0x1

	// INTEN: Enable or disable interrupt
	// Position of READY field.
	QSPI_INTEN_READY_Pos = 0x0
	// Bit mask of READY field.
	QSPI_INTEN_READY_Msk = 0x1
	// Bit READY.
	QSPI_INTEN_READY = 0x1
	// Disable
	QSPI_INTEN_READY_Disabled = 0x0
	// Enable
	QSPI_INTEN_READY_Enabled = 0x1

	// INTENSET: Enable interrupt
	// Position of READY field.
	QSPI_INTENSET_READY_Pos = 0x0
	// Bit mask of READY field.
	QSPI_INTENSET_READY_Msk = 0x1
	// Bit READY.
	QSPI_INTENSET_READY = 0x1
	// Read: Disabled
	QSPI_INTENSET_READY_Disabled = 0x0
	// Read: Enabled
	QSPI_INTENSET_READY_Enabled = 0x1
	// Enable
	QSPI_INTENSET_READY_Set = 0x1

	// INTENCLR: Disable interrupt
	// Position of READY field.
	QSPI_INTENCLR_READY_Pos = 0x0
	// Bit mask of READY field.
	QSPI_INTENCLR_READY_Msk = 0x1
	// Bit READY.
	QSPI_INTENCLR_READY = 0x1
	// Read: Disabled
	QSPI_INTENCLR_READY_Disabled = 0x0
	// Read: Enabled
	QSPI_INTENCLR_READY_Enabled = 0x1
	// Disable
	QSPI_INTENCLR_READY_Clear = 0x1

	// ENABLE: Enable QSPI peripheral and acquire the pins selected in PSELn registers
	// Position of ENABLE field.
	QSPI_ENABLE_ENABLE_Pos = 0x0
	// Bit mask of ENABLE field.
	QSPI_ENABLE_ENABLE_Msk = 0x1
	// Bit ENABLE.
	QSPI_ENABLE_ENABLE = 0x1
	// Disable QSPI
	QSPI_ENABLE_ENABLE_Disabled = 0x0
	// Enable QSPI
	QSPI_ENABLE_ENABLE_Enabled = 0x1

	// READ.SRC: Flash memory source address
	// Position of SRC field.
	QSPI_READ_SRC_SRC_Pos = 0x0
	// Bit mask of SRC field.
	QSPI_READ_SRC_SRC_Msk = 0xffffffff

	// READ.DST: RAM destination address
	// Position of DST field.
	QSPI_READ_DST_DST_Pos = 0x0
	// Bit mask of DST field.
	QSPI_READ_DST_DST_Msk = 0xffffffff

	// READ.CNT: Read transfer length
	// Position of CNT field.
	QSPI_READ_CNT_CNT_Pos = 0x0
	// Bit mask of CNT field.
	QSPI_READ_CNT_CNT_Msk = 0x3ffff

	// WRITE.DST: Flash destination address
	// Position of DST field.
	QSPI_WRITE_DST_DST_Pos = 0x0
	// Bit mask of DST field.
	QSPI_WRITE_DST_DST_Msk = 0xffffffff

	// WRITE.SRC: RAM source address
	// Position of SRC field.
	QSPI_WRITE_SRC_SRC_Pos = 0x0
	// Bit mask of SRC field.
	QSPI_WRITE_SRC_SRC_Msk = 0xffffffff

	// WRITE.CNT: Write transfer length
	// Position of CNT field.
	QSPI_WRITE_CNT_CNT_Pos = 0x0
	// Bit mask of CNT field.
	QSPI_WRITE_CNT_CNT_Msk = 0x3ffff

	// ERASE.PTR: Start address of flash block to be erased
	// Position of PTR field.
	QSPI_ERASE_PTR_PTR_Pos = 0x0
	// Bit mask of PTR field.
	QSPI_ERASE_PTR_PTR_Msk = 0xffffffff

	// ERASE.LEN: Size of block to be erased.
	// Position of LEN field.
	QSPI_ERASE_LEN_LEN_Pos = 0x0
	// Bit mask of LEN field.
	QSPI_ERASE_LEN_LEN_Msk = 0x3
	// Erase 4 kB block (flash command 0x20)
	QSPI_ERASE_LEN_LEN_4KB = 0x0
	// Erase 64 kB block (flash command 0xD8)
	QSPI_ERASE_LEN_LEN_64KB = 0x1
	// Erase all (flash command 0xC7)
	QSPI_ERASE_LEN_LEN_All = 0x2

	// PSEL.SCK: Pin select for serial clock SCK
	// Position of PIN field.
	QSPI_PSEL_SCK_PIN_Pos = 0x0
	// Bit mask of PIN field.
	QSPI_PSEL_SCK_PIN_Msk = 0x1f
	// Position of PORT field.
	QSPI_PSEL_SCK_PORT_Pos = 0x5
	// Bit mask of PORT field.
	QSPI_PSEL_SCK_PORT_Msk = 0x20
	// Bit PORT.
	QSPI_PSEL_SCK_PORT = 0x20
	// Position of CONNECT field.
	QSPI_PSEL_SCK_CONNECT_Pos = 0x1f
	// Bit mask of CONNECT field.
	QSPI_PSEL_SCK_CONNECT_Msk = 0x80000000
	// Bit CONNECT.
	QSPI_PSEL_SCK_CONNECT = 0x80000000
	// Disconnect
	QSPI_PSEL_SCK_CONNECT_Disconnected = 0x1
	// Connect
	QSPI_PSEL_SCK_CONNECT_Connected = 0x0

	// PSEL.CSN: Pin select for chip select signal CSN.
	// Position of PIN field.
	QSPI_PSEL_CSN_PIN_Pos = 0x0
	// Bit mask of PIN field.
	QSPI_PSEL_CSN_PIN_Msk = 0x1f
	// Position of PORT field.
	QSPI_PSEL_CSN_PORT_Pos = 0x5
	// Bit mask of PORT field.
	QSPI_PSEL_CSN_PORT_Msk = 0x20
	// Bit PORT.
	QSPI_PSEL_CSN_PORT = 0x20
	// Position of CONNECT field.
	QSPI_PSEL_CSN_CONNECT_Pos = 0x1f
	// Bit mask of CONNECT field.
	QSPI_PSEL_CSN_CONNECT_Msk = 0x80000000
	// Bit CONNECT.
	QSPI_PSEL_CSN_CONNECT = 0x80000000
	// Disconnect
	QSPI_PSEL_CSN_CONNECT_Disconnected = 0x1
	// Connect
	QSPI_PSEL_CSN_CONNECT_Connected = 0x0

	// PSEL.IO0: Pin select for serial data MOSI/IO0.
	// Position of PIN field.
	QSPI_PSEL_IO0_PIN_Pos = 0x0
	// Bit mask of PIN field.
	QSPI_PSEL_IO0_PIN_Msk = 0x1f
	// Position of PORT field.
	QSPI_PSEL_IO0_PORT_Pos = 0x5
	// Bit mask of PORT field.
	QSPI_PSEL_IO0_PORT_Msk = 0x20
	// Bit PORT.
	QSPI_PSEL_IO0_PORT = 0x20
	// Position of CONNECT field.
	QSPI_PSEL_IO0_CONNECT_Pos = 0x1f
	// Bit mask of CONNECT field.
	QSPI_PSEL_IO0_CONNECT_Msk = 0x80000000
	// Bit CONNECT.
	QSPI_PSEL_IO0_CONNECT = 0x80000000
	// Disconnect
	QSPI_PSEL_IO0_CONNECT_Disconnected = 0x1
	// Connect
	QSPI_PSEL_IO0_CONNECT_Connected = 0x0

	// PSEL.IO1: Pin select for serial data MISO/IO1.
	// Position of PIN field.
	QSPI_PSEL_IO1_PIN_Pos = 0x0
	// Bit mask of PIN field.
	QSPI_PSEL_IO1_PIN_Msk = 0x1f
	// Position of PORT field.
	QSPI_PSEL_IO1_PORT_Pos = 0x5
	// Bit mask of PORT field.
	QSPI_PSEL_IO1_PORT_Msk = 0x20
	// Bit PORT.
	QSPI_PSEL_IO1_PORT = 0x20
	// Position of CONNECT field.
	QSPI_PSEL_IO1_CONNECT_Pos = 0x1f
	// Bit mask of CONNECT field.
	QSPI_PSEL_IO1_CONNECT_Msk = 0x80000000
	// Bit CONNECT.
	QSPI_PSEL_IO1_CONNECT = 0x80000000
	// Disconnect
	QSPI_PSEL_IO1_CONNECT_Disconnected = 0x1
	// Connect
	QSPI_PSEL_IO1_CONNECT_Connected = 0x0

	// PSEL.IO2: Pin select for serial data IO2.
	// Position of PIN field.
	QSPI_PSEL_IO2_PIN_Pos = 0x0
	// Bit mask of PIN field.
	QSPI_PSEL_IO2_PIN_Msk = 0x1f
	// Position of PORT field.
	QSPI_PSEL_IO2_PORT_Pos = 0x5
	// Bit mask of PORT field.
	QSPI_PSEL_IO2_PORT_Msk = 0x20
	// Bit PORT.
	QSPI_PSEL_IO2_PORT = 0x20
	// Position of CONNECT field.
	QSPI_PSEL_IO2_CONNECT_Pos = 0x1f
	// Bit mask of CONNECT field.
	QSPI_PSEL_IO2_CONNECT_Msk = 0x80000000
	// Bit CONNECT.
	QSPI_PSEL_IO2_CONNECT = 0x80000000
	// Disconnect
	QSPI_PSEL_IO2_CONNECT_Disconnected = 0x1
	// Connect
	QSPI_PSEL_IO2_CONNECT_Connected = 0x0

	// PSEL.IO3: Pin select for serial data IO3.
	// Position of PIN field.
	QSPI_PSEL_IO3_PIN_Pos = 0x0
	// Bit mask of PIN field.
	QSPI_PSEL_IO3_PIN_Msk = 0x1f
	// Position of PORT field.
	QSPI_PSEL_IO3_PORT_Pos = 0x5
	// Bit mask of PORT field.
	QSPI_PSEL_IO3_PORT_Msk = 0x20
	// Bit PORT.
	QSPI_PSEL_IO3_PORT = 0x20
	// Position of CONNECT field.
	QSPI_PSEL_IO3_CONNECT_Pos = 0x1f
	// Bit mask of CONNECT field.
	QSPI_PSEL_IO3_CONNECT_Msk = 0x80000000
	// Bit CONNECT.
	QSPI_PSEL_IO3_CONNECT = 0x80000000
	// Disconnect
	QSPI_PSEL_IO3_CONNECT_Disconnected = 0x1
	// Connect
	QSPI_PSEL_IO3_CONNECT_Connected = 0x0

	// XIPOFFSET: Address offset into the external memory for Execute in Place operation.
	// Position of XIPOFFSET field.
	QSPI_XIPOFFSET_XIPOFFSET_Pos = 0x0
	// Bit mask of XIPOFFSET field.
	QSPI_XIPOFFSET_XIPOFFSET_Msk = 0xffffffff

	// IFCONFIG0: Interface configuration.
	// Position of READOC field.
	QSPI_IFCONFIG0_READOC_Pos = 0x0
	// Bit mask of READOC field.
	QSPI_IFCONFIG0_READOC_Msk = 0x7
	// Single data line SPI. FAST_READ (opcode 0x0B).
	QSPI_IFCONFIG0_READOC_FASTREAD = 0x0
	// Dual data line SPI. READ2O (opcode 0x3B).
	QSPI_IFCONFIG0_READOC_READ2O = 0x1
	// Dual data line SPI. READ2IO (opcode 0xBB).
	QSPI_IFCONFIG0_READOC_READ2IO = 0x2
	// Quad data line SPI. READ4O (opcode 0x6B).
	QSPI_IFCONFIG0_READOC_READ4O = 0x3
	// Quad data line SPI. READ4IO (opcode 0xEB).
	QSPI_IFCONFIG0_READOC_READ4IO = 0x4
	// Position of WRITEOC field.
	QSPI_IFCONFIG0_WRITEOC_Pos = 0x3
	// Bit mask of WRITEOC field.
	QSPI_IFCONFIG0_WRITEOC_Msk = 0x38
	// Single data line SPI. PP (opcode 0x02).
	QSPI_IFCONFIG0_WRITEOC_PP = 0x0
	// Dual data line SPI. PP2O (opcode 0xA2).
	QSPI_IFCONFIG0_WRITEOC_PP2O = 0x1
	// Quad data line SPI. PP4O (opcode 0x32).
	QSPI_IFCONFIG0_WRITEOC_PP4O = 0x2
	// Quad data line SPI. PP4IO (opcode 0x38).
	QSPI_IFCONFIG0_WRITEOC_PP4IO = 0x3
	// Position of ADDRMODE field.
	QSPI_IFCONFIG0_ADDRMODE_Pos = 0x6
	// Bit mask of ADDRMODE field.
	QSPI_IFCONFIG0_ADDRMODE_Msk = 0x40
	// Bit ADDRMODE.
	QSPI_IFCONFIG0_ADDRMODE = 0x40
	// 24-bit addressing.
	QSPI_IFCONFIG0_ADDRMODE_24BIT = 0x0
	// 32-bit addressing.
	QSPI_IFCONFIG0_ADDRMODE_32BIT = 0x1
	// Position of DPMENABLE field.
	QSPI_IFCONFIG0_DPMENABLE_Pos = 0x7
	// Bit mask of DPMENABLE field.
	QSPI_IFCONFIG0_DPMENABLE_Msk = 0x80
	// Bit DPMENABLE.
	QSPI_IFCONFIG0_DPMENABLE = 0x80
	// Disable DPM feature.
	QSPI_IFCONFIG0_DPMENABLE_Disable = 0x0
	// Enable DPM feature.
	QSPI_IFCONFIG0_DPMENABLE_Enable = 0x1
	// Position of PPSIZE field.
	QSPI_IFCONFIG0_PPSIZE_Pos = 0xc
	// Bit mask of PPSIZE field.
	QSPI_IFCONFIG0_PPSIZE_Msk = 0x1000
	// Bit PPSIZE.
	QSPI_IFCONFIG0_PPSIZE = 0x1000
	// 256 bytes.
	QSPI_IFCONFIG0_PPSIZE_256Bytes = 0x0
	// 512 bytes.
	QSPI_IFCONFIG0_PPSIZE_512Bytes = 0x1

	// IFCONFIG1: Interface configuration.
	// Position of SCKDELAY field.
	QSPI_IFCONFIG1_SCKDELAY_Pos = 0x0
	// Bit mask of SCKDELAY field.
	QSPI_IFCONFIG1_SCKDELAY_Msk = 0xff
	// Position of DPMEN field.
	QSPI_IFCONFIG1_DPMEN_Pos = 0x18
	// Bit mask of DPMEN field.
	QSPI_IFCONFIG1_DPMEN_Msk = 0x1000000
	// Bit DPMEN.
	QSPI_IFCONFIG1_DPMEN = 0x1000000
	// Exit DPM.
	QSPI_IFCONFIG1_DPMEN_Exit = 0x0
	// Enter DPM.
	QSPI_IFCONFIG1_DPMEN_Enter = 0x1
	// Position of SPIMODE field.
	QSPI_IFCONFIG1_SPIMODE_Pos = 0x19
	// Bit mask of SPIMODE field.
	QSPI_IFCONFIG1_SPIMODE_Msk = 0x2000000
	// Bit SPIMODE.
	QSPI_IFCONFIG1_SPIMODE = 0x2000000
	// Mode 0: Data are captured on the clock rising edge and data is output on a falling edge. Base level of clock is 0 (CPOL=0, CPHA=0).
	QSPI_IFCONFIG1_SPIMODE_MODE0 = 0x0
	// Mode 3: Data are captured on the clock falling edge and data is output on a rising edge. Base level of clock is 1 (CPOL=1, CPHA=1).
	QSPI_IFCONFIG1_SPIMODE_MODE3 = 0x1
	// Position of SCKFREQ field.
	QSPI_IFCONFIG1_SCKFREQ_Pos = 0x1c
	// Bit mask of SCKFREQ field.
	QSPI_IFCONFIG1_SCKFREQ_Msk = 0xf0000000

	// STATUS: Status register.
	// Position of DPM field.
	QSPI_STATUS_DPM_Pos = 0x2
	// Bit mask of DPM field.
	QSPI_STATUS_DPM_Msk = 0x4
	// Bit DPM.
	QSPI_STATUS_DPM = 0x4
	// External flash is not in DPM.
	QSPI_STATUS_DPM_Disabled = 0x0
	// External flash is in DPM.
	QSPI_STATUS_DPM_Enabled = 0x1
	// Position of READY field.
	QSPI_STATUS_READY_Pos = 0x3
	// Bit mask of READY field.
	QSPI_STATUS_READY_Msk = 0x8
	// Bit READY.
	QSPI_STATUS_READY = 0x8
	// QSPI peripheral is ready. It is allowed to trigger new tasks, writing custom instructions or enter/exit DPM.
	QSPI_STATUS_READY_READY = 0x1
	// QSPI peripheral is busy. It is not allowed to trigger any new tasks, writing custom instructions or enter/exit DPM.
	QSPI_STATUS_READY_BUSY = 0x0
	// Position of SREG field.
	QSPI_STATUS_SREG_Pos = 0x18
	// Bit mask of SREG field.
	QSPI_STATUS_SREG_Msk = 0xff000000

	// DPMDUR: Set the duration required to enter/exit deep power-down mode (DPM).
	// Position of ENTER field.
	QSPI_DPMDUR_ENTER_Pos = 0x0
	// Bit mask of ENTER field.
	QSPI_DPMDUR_ENTER_Msk = 0xffff
	// Position of EXIT field.
	QSPI_DPMDUR_EXIT_Pos = 0x10
	// Bit mask of EXIT field.
	QSPI_DPMDUR_EXIT_Msk = 0xffff0000

	// ADDRCONF: Extended address configuration.
	// Position of OPCODE field.
	QSPI_ADDRCONF_OPCODE_Pos = 0x0
	// Bit mask of OPCODE field.
	QSPI_ADDRCONF_OPCODE_Msk = 0xff
	// Position of BYTE0 field.
	QSPI_ADDRCONF_BYTE0_Pos = 0x8
	// Bit mask of BYTE0 field.
	QSPI_ADDRCONF_BYTE0_Msk = 0xff00
	// Position of BYTE1 field.
	QSPI_ADDRCONF_BYTE1_Pos = 0x10
	// Bit mask of BYTE1 field.
	QSPI_ADDRCONF_BYTE1_Msk = 0xff0000
	// Position of MODE field.
	QSPI_ADDRCONF_MODE_Pos = 0x18
	// Bit mask of MODE field.
	QSPI_ADDRCONF_MODE_Msk = 0x3000000
	// Do not send any instruction.
	QSPI_ADDRCONF_MODE_NoInstr = 0x0
	// Send opcode.
	QSPI_ADDRCONF_MODE_Opcode = 0x1
	// Send opcode, byte0.
	QSPI_ADDRCONF_MODE_OpByte0 = 0x2
	// Send opcode, byte0, byte1.
	QSPI_ADDRCONF_MODE_All = 0x3
	// Position of WIPWAIT field.
	QSPI_ADDRCONF_WIPWAIT_Pos = 0x1a
	// Bit mask of WIPWAIT field.
	QSPI_ADDRCONF_WIPWAIT_Msk = 0x4000000
	// Bit WIPWAIT.
	QSPI_ADDRCONF_WIPWAIT = 0x4000000
	// No wait.
	QSPI_ADDRCONF_WIPWAIT_Disable = 0x0
	// Wait.
	QSPI_ADDRCONF_WIPWAIT_Enable = 0x1
	// Position of WREN field.
	QSPI_ADDRCONF_WREN_Pos = 0x1b
	// Bit mask of WREN field.
	QSPI_ADDRCONF_WREN_Msk = 0x8000000
	// Bit WREN.
	QSPI_ADDRCONF_WREN = 0x8000000
	// Do not send WREN.
	QSPI_ADDRCONF_WREN_Disable = 0x0
	// Send WREN.
	QSPI_ADDRCONF_WREN_Enable = 0x1

	// CINSTRCONF: Custom instruction configuration register.
	// Position of OPCODE field.
	QSPI_CINSTRCONF_OPCODE_Pos = 0x0
	// Bit mask of OPCODE field.
	QSPI_CINSTRCONF_OPCODE_Msk = 0xff
	// Position of LENGTH field.
	QSPI_CINSTRCONF_LENGTH_Pos = 0x8
	// Bit mask of LENGTH field.
	QSPI_CINSTRCONF_LENGTH_Msk = 0xf00
	// Send opcode only.
	QSPI_CINSTRCONF_LENGTH_1B = 0x1
	// Send opcode, CINSTRDAT0.BYTE0.
	QSPI_CINSTRCONF_LENGTH_2B = 0x2
	// Send opcode, CINSTRDAT0.BYTE0 -&gt; CINSTRDAT0.BYTE1.
	QSPI_CINSTRCONF_LENGTH_3B = 0x3
	// Send opcode, CINSTRDAT0.BYTE0 -&gt; CINSTRDAT0.BYTE2.
	QSPI_CINSTRCONF_LENGTH_4B = 0x4
	// Send opcode, CINSTRDAT0.BYTE0 -&gt; CINSTRDAT0.BYTE3.
	QSPI_CINSTRCONF_LENGTH_5B = 0x5
	// Send opcode, CINSTRDAT0.BYTE0 -&gt; CINSTRDAT1.BYTE4.
	QSPI_CINSTRCONF_LENGTH_6B = 0x6
	// Send opcode, CINSTRDAT0.BYTE0 -&gt; CINSTRDAT1.BYTE5.
	QSPI_CINSTRCONF_LENGTH_7B = 0x7
	// Send opcode, CINSTRDAT0.BYTE0 -&gt; CINSTRDAT1.BYTE6.
	QSPI_CINSTRCONF_LENGTH_8B = 0x8
	// Send opcode, CINSTRDAT0.BYTE0 -&gt; CINSTRDAT1.BYTE7.
	QSPI_CINSTRCONF_LENGTH_9B = 0x9
	// Position of LIO2 field.
	QSPI_CINSTRCONF_LIO2_Pos = 0xc
	// Bit mask of LIO2 field.
	QSPI_CINSTRCONF_LIO2_Msk = 0x1000
	// Bit LIO2.
	QSPI_CINSTRCONF_LIO2 = 0x1000
	// Position of LIO3 field.
	QSPI_CINSTRCONF_LIO3_Pos = 0xd
	// Bit mask of LIO3 field.
	QSPI_CINSTRCONF_LIO3_Msk = 0x2000
	// Bit LIO3.
	QSPI_CINSTRCONF_LIO3 = 0x2000
	// Position of WIPWAIT field.
	QSPI_CINSTRCONF_WIPWAIT_Pos = 0xe
	// Bit mask of WIPWAIT field.
	QSPI_CINSTRCONF_WIPWAIT_Msk = 0x4000
	// Bit WIPWAIT.
	QSPI_CINSTRCONF_WIPWAIT = 0x4000
	// No wait.
	QSPI_CINSTRCONF_WIPWAIT_Disable = 0x0
	// Wait.
	QSPI_CINSTRCONF_WIPWAIT_Enable = 0x1
	// Position of WREN field.
	QSPI_CINSTRCONF_WREN_Pos = 0xf
	// Bit mask of WREN field.
	QSPI_CINSTRCONF_WREN_Msk = 0x8000
	// Bit WREN.
	QSPI_CINSTRCONF_WREN = 0x8000
	// Do not send WREN.
	QSPI_CINSTRCONF_WREN_Disable = 0x0
	// Send WREN.
	QSPI_CINSTRCONF_WREN_Enable = 0x1
	// Position of LFEN field.
	QSPI_CINSTRCONF_LFEN_Pos = 0x10
	// Bit mask of LFEN field.
	QSPI_CINSTRCONF_LFEN_Msk = 0x10000
	// Bit LFEN.
	QSPI_CINSTRCONF_LFEN = 0x10000
	// Long frame mode disabled
	QSPI_CINSTRCONF_LFEN_Disable = 0x0
	// Long frame mode enabled
	QSPI_CINSTRCONF_LFEN_Enable = 0x1
	// Position of LFSTOP field.
	QSPI_CINSTRCONF_LFSTOP_Pos = 0x11
	// Bit mask of LFSTOP field.
	QSPI_CINSTRCONF_LFSTOP_Msk = 0x20000
	// Bit LFSTOP.
	QSPI_CINSTRCONF_LFSTOP = 0x20000
	// Stop
	QSPI_CINSTRCONF_LFSTOP_Stop = 0x1

	// CINSTRDAT0: Custom instruction data register 0.
	// Position of BYTE0 field.
	QSPI_CINSTRDAT0_BYTE0_Pos = 0x0
	// Bit mask of BYTE0 field.
	QSPI_CINSTRDAT0_BYTE0_Msk = 0xff
	// Position of BYTE1 field.
	QSPI_CINSTRDAT0_BYTE1_Pos = 0x8
	// Bit mask of BYTE1 field.
	QSPI_CINSTRDAT0_BYTE1_Msk = 0xff00
	// Position of BYTE2 field.
	QSPI_CINSTRDAT0_BYTE2_Pos = 0x10
	// Bit mask of BYTE2 field.
	QSPI_CINSTRDAT0_BYTE2_Msk = 0xff0000
	// Position of BYTE3 field.
	QSPI_CINSTRDAT0_BYTE3_Pos = 0x18
	// Bit mask of BYTE3 field.
	QSPI_CINSTRDAT0_BYTE3_Msk = 0xff000000

	// CINSTRDAT1: Custom instruction data register 1.
	// Position of BYTE4 field.
	QSPI_CINSTRDAT1_BYTE4_Pos = 0x0
	// Bit mask of BYTE4 field.
	QSPI_CINSTRDAT1_BYTE4_Msk = 0xff
	// Position of BYTE5 field.
	QSPI_CINSTRDAT1_BYTE5_Pos = 0x8
	// Bit mask of BYTE5 field.
	QSPI_CINSTRDAT1_BYTE5_Msk = 0xff00
	// Position of BYTE6 field.
	QSPI_CINSTRDAT1_BYTE6_Pos = 0x10
	// Bit mask of BYTE6 field.
	QSPI_CINSTRDAT1_BYTE6_Msk = 0xff0000
	// Position of BYTE7 field.
	QSPI_CINSTRDAT1_BYTE7_Pos = 0x18
	// Bit mask of BYTE7 field.
	QSPI_CINSTRDAT1_BYTE7_Msk = 0xff000000

	// IFTIMING: SPI interface timing.
	// Position of RXDELAY field.
	QSPI_IFTIMING_RXDELAY_Pos = 0x8
	// Bit mask of RXDELAY field.
	QSPI_IFTIMING_RXDELAY_Msk = 0x700
)

// Bitfields for CC_HOST_RGF: CRYPTOCELL HOST_RGF interface
const (
	// HOST_CRYPTOKEY_SEL: AES hardware key select
	// Position of HOST_CRYPTOKEY_SEL field.
	CC_HOST_RGF_HOST_CRYPTOKEY_SEL_HOST_CRYPTOKEY_SEL_Pos = 0x0
	// Bit mask of HOST_CRYPTOKEY_SEL field.
	CC_HOST_RGF_HOST_CRYPTOKEY_SEL_HOST_CRYPTOKEY_SEL_Msk = 0x3
	// Use device root key K_DR from CRYPTOCELL AO power domain
	CC_HOST_RGF_HOST_CRYPTOKEY_SEL_HOST_CRYPTOKEY_SEL_K_DR = 0x0
	// Use hard-coded RTL key K_PRTL
	CC_HOST_RGF_HOST_CRYPTOKEY_SEL_HOST_CRYPTOKEY_SEL_K_PRTL = 0x1
	// Use provided session key
	CC_HOST_RGF_HOST_CRYPTOKEY_SEL_HOST_CRYPTOKEY_SEL_Session = 0x2

	// HOST_IOT_KPRTL_LOCK: This write-once register is the K_PRTL lock register. When this register is set, K_PRTL can not be used and a zeroed key will be used instead. The value of this register is saved in the CRYPTOCELL AO power domain.
	// Position of HOST_IOT_KPRTL_LOCK field.
	CC_HOST_RGF_HOST_IOT_KPRTL_LOCK_HOST_IOT_KPRTL_LOCK_Pos = 0x0
	// Bit mask of HOST_IOT_KPRTL_LOCK field.
	CC_HOST_RGF_HOST_IOT_KPRTL_LOCK_HOST_IOT_KPRTL_LOCK_Msk = 0x1
	// Bit HOST_IOT_KPRTL_LOCK.
	CC_HOST_RGF_HOST_IOT_KPRTL_LOCK_HOST_IOT_KPRTL_LOCK = 0x1
	// K_PRTL can be selected for use from register HOST_CRYPTOKEY_SEL
	CC_HOST_RGF_HOST_IOT_KPRTL_LOCK_HOST_IOT_KPRTL_LOCK_Disabled = 0x0
	// K_PRTL has been locked until next power-on reset (POR). If K_PRTL is selected anyway, a zeroed key will be used instead.
	CC_HOST_RGF_HOST_IOT_KPRTL_LOCK_HOST_IOT_KPRTL_LOCK_Enabled = 0x1

	// HOST_IOT_KDR0: This register holds bits 31:0 of K_DR. The value of this register is saved in the CRYPTOCELL AO power domain. Reading from this address returns the K_DR valid status indicating if K_DR is successfully retained.
	// Position of HOST_IOT_KDR0 field.
	CC_HOST_RGF_HOST_IOT_KDR0_HOST_IOT_KDR0_Pos = 0x0
	// Bit mask of HOST_IOT_KDR0 field.
	CC_HOST_RGF_HOST_IOT_KDR0_HOST_IOT_KDR0_Msk = 0xffffffff

	// HOST_IOT_KDR1: This register holds bits 63:32 of K_DR. The value of this register is saved in the CRYPTOCELL AO power domain.
	// Position of HOST_IOT_KDR1 field.
	CC_HOST_RGF_HOST_IOT_KDR1_HOST_IOT_KDR1_Pos = 0x0
	// Bit mask of HOST_IOT_KDR1 field.
	CC_HOST_RGF_HOST_IOT_KDR1_HOST_IOT_KDR1_Msk = 0xffffffff

	// HOST_IOT_KDR2: This register holds bits 95:64 of K_DR. The value of this register is saved in the CRYPTOCELL AO power domain.
	// Position of HOST_IOT_KDR2 field.
	CC_HOST_RGF_HOST_IOT_KDR2_HOST_IOT_KDR2_Pos = 0x0
	// Bit mask of HOST_IOT_KDR2 field.
	CC_HOST_RGF_HOST_IOT_KDR2_HOST_IOT_KDR2_Msk = 0xffffffff

	// HOST_IOT_KDR3: This register holds bits 127:96 of K_DR. The value of this register is saved in the CRYPTOCELL AO power domain.
	// Position of HOST_IOT_KDR3 field.
	CC_HOST_RGF_HOST_IOT_KDR3_HOST_IOT_KDR3_Pos = 0x0
	// Bit mask of HOST_IOT_KDR3 field.
	CC_HOST_RGF_HOST_IOT_KDR3_HOST_IOT_KDR3_Msk = 0xffffffff

	// HOST_IOT_LCS: Controls lifecycle state (LCS) for CRYPTOCELL subsystem
	// Position of LCS field.
	CC_HOST_RGF_HOST_IOT_LCS_LCS_Pos = 0x0
	// Bit mask of LCS field.
	CC_HOST_RGF_HOST_IOT_LCS_LCS_Msk = 0x7
	// CC310 operates in debug mode
	CC_HOST_RGF_HOST_IOT_LCS_LCS_Debug = 0x0
	// CC310 operates in secure mode
	CC_HOST_RGF_HOST_IOT_LCS_LCS_Secure = 0x2
	// Position of LCS_IS_VALID field.
	CC_HOST_RGF_HOST_IOT_LCS_LCS_IS_VALID_Pos = 0x8
	// Bit mask of LCS_IS_VALID field.
	CC_HOST_RGF_HOST_IOT_LCS_LCS_IS_VALID_Msk = 0x100
	// Bit LCS_IS_VALID.
	CC_HOST_RGF_HOST_IOT_LCS_LCS_IS_VALID = 0x100
	// A valid LCS is not yet retained in the CRYPTOCELL AO power domain
	CC_HOST_RGF_HOST_IOT_LCS_LCS_IS_VALID_Invalid = 0x0
	// A valid LCS is successfully retained in the CRYPTOCELL AO power domain
	CC_HOST_RGF_HOST_IOT_LCS_LCS_IS_VALID_Valid = 0x1
)

// Bitfields for CRYPTOCELL: ARM TrustZone CryptoCell register interface
const (
	// ENABLE: Enable CRYPTOCELL subsystem
	// Position of ENABLE field.
	CRYPTOCELL_ENABLE_ENABLE_Pos = 0x0
	// Bit mask of ENABLE field.
	CRYPTOCELL_ENABLE_ENABLE_Msk = 0x1
	// Bit ENABLE.
	CRYPTOCELL_ENABLE_ENABLE = 0x1
	// CRYPTOCELL subsystem disabled
	CRYPTOCELL_ENABLE_ENABLE_Disabled = 0x0
	// CRYPTOCELL subsystem enabled
	CRYPTOCELL_ENABLE_ENABLE_Enabled = 0x1
)
