/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.core;

import jakarta.servlet.http.HttpServletMapping;
import jakarta.servlet.http.MappingMatch;
import org.apache.catalina.mapper.MappingData;

public class ApplicationMapping {
    private final MappingData mappingData;
    private volatile HttpServletMapping mapping = null;

    public ApplicationMapping(MappingData mappingData) {
        this.mappingData = mappingData;
    }

    public HttpServletMapping getHttpServletMapping() {
        if (this.mapping == null) {
            String string = this.mappingData.wrapper == null ? "" : this.mappingData.wrapper.getName();
            if (this.mappingData.matchType == null) {
                this.mapping = new MappingImpl("", "", null, string);
            } else {
                switch (this.mappingData.matchType) {
                    case CONTEXT_ROOT: {
                        this.mapping = new MappingImpl("", "", this.mappingData.matchType, string);
                        break;
                    }
                    case DEFAULT: {
                        this.mapping = new MappingImpl("", "/", this.mappingData.matchType, string);
                        break;
                    }
                    case EXACT: {
                        this.mapping = new MappingImpl(this.mappingData.wrapperPath.toString().substring(1), this.mappingData.wrapperPath.toString(), this.mappingData.matchType, string);
                        break;
                    }
                    case EXTENSION: {
                        String string2 = this.mappingData.wrapperPath.toString();
                        int n = string2.lastIndexOf(46);
                        this.mapping = new MappingImpl(string2.substring(1, n), "*" + string2.substring(n), this.mappingData.matchType, string);
                        break;
                    }
                    case PATH: {
                        String string3 = this.mappingData.pathInfo.isNull() ? null : this.mappingData.pathInfo.toString().substring(1);
                        this.mapping = new MappingImpl(string3, this.mappingData.wrapperPath.toString() + "/*", this.mappingData.matchType, string);
                    }
                }
            }
        }
        return this.mapping;
    }

    public void recycle() {
        this.mapping = null;
    }

    private static class MappingImpl
    implements HttpServletMapping {
        private final String matchValue;
        private final String pattern;
        private final MappingMatch mappingType;
        private final String servletName;

        public MappingImpl(String string, String string2, MappingMatch mappingMatch, String string3) {
            this.matchValue = string;
            this.pattern = string2;
            this.mappingType = mappingMatch;
            this.servletName = string3;
        }

        public String getMatchValue() {
            return this.matchValue;
        }

        public String getPattern() {
            return this.pattern;
        }

        public MappingMatch getMappingMatch() {
            return this.mappingType;
        }

        public String getServletName() {
            return this.servletName;
        }
    }
}

