/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.websocket;

import jakarta.websocket.CloseReason;
import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.CompletionHandler;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.res.StringManager;
import org.apache.tomcat.websocket.AsyncChannelWrapper;
import org.apache.tomcat.websocket.ReadBufferOverflowException;
import org.apache.tomcat.websocket.Transformation;
import org.apache.tomcat.websocket.WsFrameBase;
import org.apache.tomcat.websocket.WsIOException;
import org.apache.tomcat.websocket.WsSession;

public class WsFrameClient
extends WsFrameBase {
    private final Log log = LogFactory.getLog(WsFrameClient.class);
    private static final StringManager sm = StringManager.getManager(WsFrameClient.class);
    private final AsyncChannelWrapper channel;
    private final CompletionHandler<Integer, Void> handler;
    private volatile ByteBuffer response;

    public WsFrameClient(ByteBuffer byteBuffer, AsyncChannelWrapper asyncChannelWrapper, WsSession wsSession, Transformation transformation) {
        super(wsSession, transformation);
        this.response = byteBuffer;
        this.channel = asyncChannelWrapper;
        this.handler = new WsFrameClientCompletionHandler();
    }

    void startInputProcessing() {
        try {
            this.processSocketRead();
        }
        catch (IOException iOException) {
            this.close(iOException);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void processSocketRead() throws IOException {
        block4: while (true) {
            switch (this.getReadState()) {
                case WAITING: {
                    if (!this.changeReadState(WsFrameBase.ReadState.WAITING, WsFrameBase.ReadState.PROCESSING)) continue block4;
                    while (this.response.hasRemaining()) {
                        if (this.isSuspended()) {
                            if (!this.changeReadState(WsFrameBase.ReadState.SUSPENDING_PROCESS, WsFrameBase.ReadState.SUSPENDED)) continue;
                            return;
                        }
                        this.inputBuffer.mark();
                        this.inputBuffer.position(this.inputBuffer.limit()).limit(this.inputBuffer.capacity());
                        int n = Math.min(this.response.remaining(), this.inputBuffer.remaining());
                        int n2 = this.response.limit();
                        this.response.limit(this.response.position() + n);
                        this.inputBuffer.put(this.response);
                        this.response.limit(n2);
                        this.inputBuffer.limit(this.inputBuffer.position()).reset();
                        this.processInputBuffer();
                    }
                    this.response.clear();
                    if (this.isOpen()) {
                        this.channel.read(this.response, null, this.handler);
                        return;
                    } else {
                        this.changeReadState(WsFrameBase.ReadState.CLOSING);
                    }
                    return;
                }
                case SUSPENDING_WAIT: {
                    if (this.changeReadState(WsFrameBase.ReadState.SUSPENDING_WAIT, WsFrameBase.ReadState.SUSPENDED)) return;
                    continue block4;
                }
            }
            break;
        }
        throw new IllegalStateException(sm.getString("wsFrameServer.illegalReadState", new Object[]{this.getReadState()}));
    }

    private final void close(Throwable throwable) {
        this.changeReadState(WsFrameBase.ReadState.CLOSING);
        CloseReason closeReason = throwable instanceof WsIOException ? ((WsIOException)throwable).getCloseReason() : new CloseReason((CloseReason.CloseCode)CloseReason.CloseCodes.CLOSED_ABNORMALLY, throwable.getMessage());
        this.wsSession.doClose(closeReason, closeReason, true);
    }

    @Override
    protected boolean isMasked() {
        return false;
    }

    @Override
    protected Log getLog() {
        return this.log;
    }

    @Override
    protected void resumeProcessing() {
        this.resumeProcessing(true);
    }

    private void resumeProcessing(boolean bl) {
        try {
            this.processSocketRead();
        }
        catch (IOException iOException) {
            if (bl) {
                if (this.isOpen()) {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)sm.getString("wsFrameClient.ioe"), (Throwable)iOException);
                    }
                    this.close(iOException);
                }
            }
            this.close(iOException);
        }
    }

    private class WsFrameClientCompletionHandler
    implements CompletionHandler<Integer, Void> {
        private WsFrameClientCompletionHandler() {
        }

        @Override
        public void completed(Integer n, Void void_) {
            if (n == -1) {
                if (WsFrameClient.this.isOpen()) {
                    WsFrameClient.this.close(new EOFException());
                }
                return;
            }
            WsFrameClient.this.response.flip();
            this.doResumeProcessing(true);
        }

        @Override
        public void failed(Throwable throwable, Void void_) {
            if (WsFrameClient.this.log.isDebugEnabled()) {
                WsFrameClient.this.log.debug((Object)sm.getString("wsFrame.readFailed"), throwable);
            }
            if (throwable instanceof ReadBufferOverflowException) {
                WsFrameClient.this.response = ByteBuffer.allocate(((ReadBufferOverflowException)throwable).getMinBufferSize());
                WsFrameClient.this.response.flip();
                this.doResumeProcessing(false);
            } else {
                WsFrameClient.this.close(throwable);
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private void doResumeProcessing(boolean bl) {
            block4: while (true) {
                switch (WsFrameClient.this.getReadState()) {
                    case PROCESSING: {
                        if (!WsFrameClient.this.changeReadState(WsFrameBase.ReadState.PROCESSING, WsFrameBase.ReadState.WAITING)) continue block4;
                        WsFrameClient.this.resumeProcessing(bl);
                        return;
                    }
                    case SUSPENDING_PROCESS: {
                        if (WsFrameClient.this.changeReadState(WsFrameBase.ReadState.SUSPENDING_PROCESS, WsFrameBase.ReadState.SUSPENDED)) return;
                        continue block4;
                    }
                }
                break;
            }
            throw new IllegalStateException(sm.getString("wsFrame.illegalReadState", new Object[]{WsFrameClient.this.getReadState()}));
        }
    }
}

