/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.apt.dispatch;

import java.util.Iterator;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.processing.Processor;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.TypeElement;

public class ProcessorInfo {
    final Processor _processor;
    final Set<String> _supportedOptions;
    final SourceVersion _supportedSourceVersion;
    private final Pattern _supportedAnnotationTypesPattern;
    private final boolean _supportsStar;
    private boolean _hasBeenCalled;

    public ProcessorInfo(Processor processor) {
        this._processor = processor;
        this._hasBeenCalled = false;
        this._supportedSourceVersion = processor.getSupportedSourceVersion();
        this._supportedOptions = processor.getSupportedOptions();
        Set<String> set = processor.getSupportedAnnotationTypes();
        boolean bl = false;
        if (null != set && !set.isEmpty()) {
            StringBuilder stringBuilder = new StringBuilder();
            Iterator<String> iterator = set.iterator();
            while (true) {
                String string = iterator.next();
                bl |= "*".equals(string);
                String string2 = string.replace(".", "\\.");
                String string3 = string2.replace("*", ".*");
                stringBuilder.append(string3);
                if (!iterator.hasNext()) break;
                stringBuilder.append('|');
            }
            this._supportedAnnotationTypesPattern = Pattern.compile(stringBuilder.toString());
        } else {
            this._supportedAnnotationTypesPattern = null;
        }
        this._supportsStar = bl;
    }

    public boolean computeSupportedAnnotations(Set<TypeElement> set, Set<TypeElement> set2) {
        if (null != set && !set.isEmpty() && null != this._supportedAnnotationTypesPattern) {
            for (TypeElement typeElement : set) {
                Matcher matcher = this._supportedAnnotationTypesPattern.matcher(typeElement.getQualifiedName().toString());
                if (!matcher.matches()) continue;
                set2.add(typeElement);
            }
        }
        boolean bl = this._hasBeenCalled || this._supportsStar || !set2.isEmpty();
        this._hasBeenCalled |= bl;
        return bl;
    }

    public boolean supportsStar() {
        return this._supportsStar;
    }

    public void reset() {
        this._hasBeenCalled = false;
    }

    public int hashCode() {
        return this._processor.getClass().hashCode();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        ProcessorInfo processorInfo = (ProcessorInfo)object;
        return this._processor.getClass().equals(processorInfo._processor.getClass());
    }

    public String toString() {
        return this._processor.getClass().getName();
    }

    public String getSupportedAnnotationTypesAsString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('[');
        Iterator<String> iterator = this._processor.getSupportedAnnotationTypes().iterator();
        boolean bl = iterator.hasNext();
        while (bl) {
            stringBuilder.append(iterator.next());
            bl = iterator.hasNext();
            if (!bl) continue;
            stringBuilder.append(',');
        }
        stringBuilder.append(']');
        return stringBuilder.toString();
    }
}

