/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.heapviewer.utils;

import java.text.Format;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.swing.SortOrder;
import org.graalvm.visualvm.heapviewer.model.DataType;
import org.graalvm.visualvm.heapviewer.model.HeapViewerNode;
import org.graalvm.visualvm.heapviewer.model.HeapViewerNodeFilter;
import org.graalvm.visualvm.heapviewer.model.Progress;
import org.graalvm.visualvm.heapviewer.utils.Bundle;
import org.graalvm.visualvm.heapviewer.utils.InterruptibleIterator;
import org.graalvm.visualvm.heapviewer.utils.MoreObjectsNode;
import org.graalvm.visualvm.heapviewer.utils.ProgressIterator;
import org.graalvm.visualvm.heapviewer.utils.SortedObjectsBuffer;
import org.graalvm.visualvm.lib.jfluid.heap.Heap;
import org.graalvm.visualvm.lib.ui.Formatters;

public abstract class NodesComputer<T> {
    private static final int EXTRA_ALLOWED_ITEMS = 10;
    private final int itemsCount;
    private final int maxItemsCount;

    public NodesComputer(int maxItemsCount) {
        this(Integer.MAX_VALUE, maxItemsCount);
    }

    public NodesComputer(int itemsCount, int maxItemsCount) {
        this.itemsCount = itemsCount;
        this.maxItemsCount = maxItemsCount;
    }

    protected abstract boolean sorts(DataType var1);

    protected abstract HeapViewerNode createNode(T var1);

    protected abstract ProgressIterator<T> objectsIterator(int var1, Progress var2);

    protected String getMoreNodesString(String moreNodesCount) {
        return Bundle.NodesComputer_MoreNodes(moreNodesCount);
    }

    protected String getSamplesContainerString(String objectsCount) {
        return Bundle.NodesComputer_SamplesContainer(objectsCount);
    }

    protected String getNodesContainerString(String firstNodeIdx, String lastNodeIdx) {
        return Bundle.NodesComputer_NodesContainer(firstNodeIdx, lastNodeIdx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HeapViewerNode[] computeNodes(HeapViewerNode parent, final Heap heap, String viewID, final HeapViewerNodeFilter viewFilter, List<DataType> dataTypes, List<SortOrder> sortOrders, Progress progress) throws InterruptedException {
        T[] objects;
        ObjectsIterator objectsIt;
        SortOrder sortOrder;
        DataType dataType;
        if (this.itemsCount <= this.maxItemsCount + 10) {
            int i = 0;
            HeapViewerNode[] nodes = new HeapViewerNode[this.itemsCount];
            NodesIterator nodesIt = this.nodesIterator(0, viewFilter, heap, progress);
            while (nodesIt.hasNext()) {
                nodes[i++] = (HeapViewerNode)((Object)nodesIt.next());
            }
            if (Thread.currentThread().isInterrupted()) {
                throw new InterruptedException();
            }
            if (i < this.itemsCount) {
                nodes = Arrays.copyOf(nodes, i);
            }
            return nodes;
        }
        DataType dataType2 = dataType = dataTypes == null || dataTypes.isEmpty() ? null : dataTypes.get(0);
        if (dataType != null && !this.sorts(dataType)) {
            dataType = null;
        }
        SortOrder sortOrder2 = sortOrder = dataType == null || sortOrders == null || sortOrders.isEmpty() ? null : sortOrders.get(0);
        if (this.itemsCount < Integer.MAX_VALUE && viewFilter == null && (dataType == null || sortOrder == null || SortOrder.UNSORTED.equals((Object)sortOrder))) {
            int i = 0;
            HeapViewerNode[] nodes = new HeapViewerNode[this.maxItemsCount + 1];
            NodesIterator nodesIt = this.nodesIterator(0, viewFilter, heap, progress);
            while (i < this.maxItemsCount && nodesIt.hasNext()) {
                nodes[i++] = (HeapViewerNode)((Object)nodesIt.next());
            }
            if (Thread.currentThread().isInterrupted()) {
                throw new InterruptedException();
            }
            Format format = Formatters.numberFormat();
            String moreNodesString = this.getMoreNodesString(format.format(this.itemsCount - this.maxItemsCount));
            nodes[this.maxItemsCount] = new MoreObjectsNode<T>(moreNodesString, this.itemsCount, this.itemsCount, nodesIt.nextObject, this.maxItemsCount - 1){

                @Override
                protected boolean sorts(DataType dataType) {
                    return NodesComputer.this.sorts(dataType);
                }

                @Override
                protected HeapViewerNode createNode(T object) {
                    return NodesComputer.this.createNode(object);
                }

                @Override
                protected Iterator<T> objectsIterator(int index, Progress progress) {
                    return NodesComputer.this.objectsIterator(index, 0, -1, viewFilter, heap, progress);
                }

                @Override
                protected String getSamplesContainerString(String objectsCount) {
                    return NodesComputer.this.getSamplesContainerString(objectsCount);
                }

                @Override
                protected String getNodesContainerString(String firstNodeIdx, String lastNodeIdx) {
                    return NodesComputer.this.getNodesContainerString(firstNodeIdx, lastNodeIdx);
                }
            };
            return nodes;
        }
        SortedObjectsBuffer buffer = new SortedObjectsBuffer<T>(this.maxItemsCount, null, dataType, sortOrder, null, heap, parent){

            @Override
            protected boolean sorts(DataType dataType) {
                return NodesComputer.this.sorts(dataType);
            }

            @Override
            protected HeapViewerNode createNode(T object) {
                return NodesComputer.this.createNode(object);
            }
        };
        try {
            if (this.itemsCount == Integer.MAX_VALUE) {
                progress.setupUnknownSteps();
            } else {
                progress.setupKnownSteps(this.itemsCount);
            }
            objectsIt = this.objectsIterator(0, 0, -1, viewFilter, heap, progress);
            while (objectsIt.hasNext()) {
                buffer.add(objectsIt.next());
            }
            if (Thread.currentThread().isInterrupted()) {
                throw new InterruptedException();
            }
            objects = buffer.getObjects();
        }
        finally {
            progress.finish();
        }
        int objectsCount = objects.length;
        final int totalOwnItems = objectsIt.getTotalOwnItems();
        if (objectsCount == totalOwnItems) {
            HeapViewerNode[] nodes = new HeapViewerNode[objectsCount];
            for (int i = 0; i < objectsCount; ++i) {
                nodes[i] = this.createNode(objects[i]);
            }
            return nodes;
        }
        HeapViewerNode[] nodes = new HeapViewerNode[objectsCount + 1];
        Object lastObject = null;
        for (int i = 0; i < objectsCount; ++i) {
            nodes[i] = this.createNode(objects[i]);
            if (i != this.maxItemsCount - 1) continue;
            lastObject = objects[i];
        }
        final int firstOwnItem = objectsIt.getFirstOwnItem();
        Format format = Formatters.numberFormat();
        String moreNodesString = this.getMoreNodesString(format.format(totalOwnItems - this.maxItemsCount));
        nodes[objectsCount] = new MoreObjectsNode<T>(moreNodesString, totalOwnItems, objectsIt.getTotalItems(), lastObject, objectsCount - 1){

            @Override
            protected boolean sorts(DataType dataType) {
                return NodesComputer.this.sorts(dataType);
            }

            @Override
            protected HeapViewerNode createNode(T object) {
                return NodesComputer.this.createNode(object);
            }

            @Override
            protected Iterator<T> objectsIterator(int index, Progress progress) {
                return NodesComputer.this.objectsIterator(index, firstOwnItem, totalOwnItems, viewFilter, heap, progress);
            }

            @Override
            protected String getSamplesContainerString(String objectsCount) {
                return NodesComputer.this.getSamplesContainerString(objectsCount);
            }

            @Override
            protected String getNodesContainerString(String firstNodeIdx, String lastNodeIdx) {
                return NodesComputer.this.getNodesContainerString(firstNodeIdx, lastNodeIdx);
            }
        };
        return nodes;
    }

    public static Iterator<Integer> integerIterator(final int start, final int end) {
        return new Iterator<Integer>(){
            private int value;
            private final int endValue;
            {
                this.value = start;
                this.endValue = end;
            }

            @Override
            public boolean hasNext() {
                return this.value < this.endValue;
            }

            @Override
            public Integer next() {
                return this.value++;
            }
        };
    }

    private ObjectsIterator objectsIterator(int index, int knownInnerStart, int knownOuterCount, HeapViewerNodeFilter viewFilter, Heap heap, Progress progress) {
        return viewFilter == null ? new PlainObjectsIterator(index, progress) : new FilteredObjectsIterator(index, knownInnerStart <= 0 ? 0 : knownInnerStart - 1, knownOuterCount, viewFilter, heap, progress);
    }

    private NodesIterator nodesIterator(int index, HeapViewerNodeFilter viewFilter, Heap heap, Progress progress) {
        return viewFilter == null ? new PlainNodesIterator(index, progress) : new FilteredNodesIterator(index, viewFilter, heap, progress);
    }

    private class FilteredNodesIterator
    extends NodesIterator {
        private final Iterator<T> iterator;
        private final HeapViewerNodeFilter viewFilter;
        private final Heap heap;
        private HeapViewerNode nextNode;

        FilteredNodesIterator(int index, HeapViewerNodeFilter viewFilter, Heap heap, Progress progress) {
            this.iterator = new InterruptibleIterator(NodesComputer.this.objectsIterator(0, progress));
            this.viewFilter = viewFilter;
            this.heap = heap;
            while (index-- > 0) {
                this.hasNext();
            }
        }

        @Override
        public boolean hasNext() {
            this.nextNode = this.nextNode();
            return this.nextNode != null;
        }

        @Override
        public HeapViewerNode next() {
            return this.nextNode;
        }

        private HeapViewerNode nextNode() {
            while (this.iterator.hasNext()) {
                this.nextObject = this.iterator.next();
                HeapViewerNode node = NodesComputer.this.createNode(this.nextObject);
                if (!this.viewFilter.passes(node, this.heap)) continue;
                return node;
            }
            this.nextObject = null;
            return null;
        }
    }

    private class PlainNodesIterator
    extends NodesIterator {
        private final Iterator<T> iterator;

        PlainNodesIterator(int index, Progress progress) {
            this.iterator = new InterruptibleIterator(NodesComputer.this.objectsIterator(index, progress));
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public HeapViewerNode next() {
            this.nextObject = this.iterator.next();
            return NodesComputer.this.createNode(this.nextObject);
        }
    }

    private abstract class NodesIterator
    implements Iterator<HeapViewerNode> {
        T nextObject;

        private NodesIterator() {
        }

        T nextObject() {
            return this.nextObject;
        }
    }

    private class FilteredObjectsIterator
    extends ObjectsIterator {
        private final Iterator<T> iterator;
        private final int knownTotalOwnItems;
        private final HeapViewerNodeFilter viewFilter;
        private final Heap heap;
        private T nextObject;

        FilteredObjectsIterator(int index, int knownFirstOwnItem, int knownTotalOwnItems, HeapViewerNodeFilter viewFilter, Heap heap, Progress progress) {
            this.iterator = new InterruptibleIterator(NodesComputer.this.objectsIterator(knownFirstOwnItem, progress));
            this.knownTotalOwnItems = knownTotalOwnItems;
            this.viewFilter = viewFilter;
            this.heap = heap;
            this.firstOwnItem = -1;
            while (index-- > 0) {
                this.hasNext();
            }
        }

        @Override
        public boolean hasNext() {
            if (this.knownTotalOwnItems >= 0 && this.knownTotalOwnItems == this.totalOwnItems) {
                return false;
            }
            this.nextObject = this.nextObject();
            return this.nextObject != null;
        }

        @Override
        public T next() {
            ++this.totalOwnItems;
            return this.nextObject;
        }

        private T nextObject() {
            while (this.iterator.hasNext()) {
                ++this.totalItems;
                Object object = this.iterator.next();
                HeapViewerNode node = NodesComputer.this.createNode(object);
                if (!this.viewFilter.passes(node, this.heap)) continue;
                if (this.firstOwnItem == -1) {
                    this.firstOwnItem = this.totalItems;
                }
                return object;
            }
            return null;
        }
    }

    private class PlainObjectsIterator
    extends ObjectsIterator {
        private final Iterator<T> iterator;

        PlainObjectsIterator(int index, Progress progress) {
            this.iterator = new InterruptibleIterator(NodesComputer.this.objectsIterator(index, progress));
            this.totalItems = index;
            this.firstOwnItem = index;
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public T next() {
            ++this.totalItems;
            ++this.totalOwnItems;
            return this.iterator.next();
        }
    }

    private abstract class ObjectsIterator
    implements Iterator<T> {
        int totalItems;
        int firstOwnItem;
        int totalOwnItems;

        private ObjectsIterator() {
        }

        int getTotalItems() {
            return this.totalItems;
        }

        int getFirstOwnItem() {
            return this.firstOwnItem;
        }

        int getTotalOwnItems() {
            return this.totalOwnItems;
        }
    }
}

