/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans;

import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.netbeans.ProxyClassLoader;

final class ProxyClassParents {
    private final Set<ProxyClassLoader> parentSet;
    private final boolean transitive;
    private final ClassLoader systemCL;

    private ProxyClassParents(ClassLoader classLoader, Set<ProxyClassLoader> set, boolean bl) {
        this.systemCL = classLoader;
        this.parentSet = set;
        this.transitive = bl;
    }

    static ProxyClassParents coalesceParents(ClassLoader classLoader, ClassLoader[] classLoaderArray, ClassLoader classLoader2, boolean bl) throws IllegalArgumentException {
        ClassLoader[] classLoaderArray2 = new ClassLoader[]{classLoader2};
        Set<ProxyClassLoader> set = ProxyClassParents.coalesceAppend(classLoader, Collections.emptySet(), classLoaderArray, classLoaderArray2);
        return new ProxyClassParents(classLoaderArray2[0], set, bl);
    }

    private static Set<ProxyClassLoader> coalesceAppend(ClassLoader classLoader, Set<ProxyClassLoader> set, ClassLoader[] classLoaderArray, ClassLoader[] classLoaderArray2) throws IllegalArgumentException {
        int n = set.size() + classLoaderArray.length;
        LinkedHashSet<ClassLoader> linkedHashSet = new LinkedHashSet<ClassLoader>(n);
        linkedHashSet.addAll(set);
        if (linkedHashSet.containsAll(Arrays.asList(classLoaderArray))) {
            return set;
        }
        for (ClassLoader classLoader2 : classLoaderArray) {
            ProxyClassParents.addRec(classLoader, linkedHashSet, classLoader2);
        }
        boolean bl = true;
        LinkedHashSet<ProxyClassLoader> linkedHashSet2 = new LinkedHashSet<ProxyClassLoader>(linkedHashSet.size());
        for (ClassLoader classLoader2 : linkedHashSet) {
            if (bl) {
                if (classLoader2 instanceof ProxyClassLoader) {
                    bl = false;
                    linkedHashSet2.add((ProxyClassLoader)classLoader2);
                    continue;
                }
                if (ProxyClassParents.isParentOf(classLoaderArray2[0], classLoader2)) {
                    classLoaderArray2[0] = classLoader2;
                    continue;
                }
                throw new IllegalArgumentException("Bad ClassLoader ordering: " + Arrays.asList(classLoaderArray));
            }
            if (classLoader2 instanceof ProxyClassLoader) {
                linkedHashSet2.add((ProxyClassLoader)classLoader2);
                continue;
            }
            throw new IllegalArgumentException("Bad ClassLoader ordering: " + Arrays.asList(classLoaderArray));
        }
        return linkedHashSet2;
    }

    private static void addRec(ClassLoader classLoader, Set<ClassLoader> set, ClassLoader classLoader2) throws IllegalArgumentException {
        if (classLoader2 == classLoader) {
            throw new IllegalArgumentException("cycle in parents");
        }
        if (set.contains(classLoader2)) {
            return;
        }
        if (classLoader2 instanceof ProxyClassLoader && ((ProxyClassLoader)classLoader2).parents.transitive) {
            for (ProxyClassLoader proxyClassLoader : ((ProxyClassLoader)classLoader2).parents.loaders()) {
                ProxyClassParents.addRec(classLoader, set, proxyClassLoader);
            }
        }
        set.add(classLoader2);
    }

    boolean contains(ProxyClassLoader proxyClassLoader) {
        return this.parentSet.contains(proxyClassLoader);
    }

    Iterable<ProxyClassLoader> loaders() {
        boolean bl = false;
        if (!$assertionsDisabled) {
            bl = true;
            if (!true) {
                throw new AssertionError();
            }
        }
        return bl ? Collections.unmodifiableSet(this.parentSet) : this.parentSet;
    }

    int size() {
        return this.parentSet.size();
    }

    ProxyClassParents append(ClassLoader classLoader, ClassLoader[] classLoaderArray) {
        ClassLoader[] classLoaderArray2 = new ClassLoader[]{this.systemCL};
        Set<ProxyClassLoader> set = ProxyClassParents.coalesceAppend(classLoader, this.parentSet, classLoaderArray, classLoaderArray2);
        return new ProxyClassParents(classLoaderArray2[0], set, this.transitive);
    }

    private static boolean isParentOf(ClassLoader classLoader, ClassLoader classLoader2) {
        while (classLoader2 != null) {
            if (classLoader2 == classLoader) {
                return true;
            }
            classLoader2 = classLoader2.getParent();
        }
        return false;
    }

    ClassLoader systemCL() {
        return this.systemCL;
    }

    boolean isTransitive() {
        return this.transitive;
    }

    ProxyClassParents changeSystemClassLoader(ClassLoader classLoader) {
        return new ProxyClassParents(classLoader, this.parentSet, this.transitive);
    }
}

