/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.json.parse.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.directwebremoting.extend.Property;
import org.directwebremoting.json.parse.JsonDecoder;
import org.directwebremoting.json.parse.JsonParseException;
import org.directwebremoting.json.parse.impl.StatefulJsonDecoder;

class ConverterJsonDecoder
implements JsonDecoder {
    protected final LinkedList<Object> stack = new LinkedList();
    protected final LinkedList<Property> destinations = new LinkedList();
    protected Object last = null;

    public ConverterJsonDecoder(Property property) {
        this.destinations.addLast(property);
    }

    @Override
    public Object getRoot() throws JsonParseException {
        return this.last;
    }

    @Override
    public void beginObject(String propertyName) throws JsonParseException {
        this.stack.addLast(new HashMap());
    }

    @Override
    public void endObject(String propertyName) throws JsonParseException {
        this.last = this.stack.removeLast();
        if (!this.stack.isEmpty()) {
            this.add(propertyName, this.last);
        }
    }

    @Override
    public void beginArray(String propertyName) throws JsonParseException {
        this.stack.addLast(new ArrayList());
    }

    @Override
    public void endArray(String propertyName) throws JsonParseException {
        this.last = this.stack.removeLast();
        if (this.stack.size() > 0) {
            this.add(propertyName, this.last);
        }
    }

    public void add(String propertyName, Object value) {
        if (propertyName == null) {
            List array = (List)this.stack.getLast();
            array.add(value);
        } else {
            Map map = (Map)this.stack.getLast();
            map.put(propertyName, value);
        }
    }

    @Override
    public void addString(String propertyName, String value) throws JsonParseException {
        this.add(propertyName, value);
    }

    @Override
    public void addNumber(String propertyName, String intPart, String floatPart, String expPart) throws JsonParseException {
        Object value = StatefulJsonDecoder.realizeNumber(intPart, floatPart, expPart);
        this.add(propertyName, value);
    }

    @Override
    public void addBoolean(String propertyName, boolean value) throws JsonParseException {
        this.add(propertyName, value);
    }

    @Override
    public void addNull(String propertyName) throws JsonParseException {
        this.add(propertyName, null);
    }
}

