/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.nkf;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Matcher;
import org.jruby.ext.nkf.Option;

public class Options {
    private final Map<String, Option> shortOpts = new LinkedHashMap<String, Option>();
    private final Map<String, Option> longOpts = new LinkedHashMap<String, Option>();

    public Options addOption(String opt) {
        return this.addOption(opt, null);
    }

    public Options addOption(String opt, String longOpt) {
        return this.addOption(opt, longOpt, null);
    }

    public Options addOption(String opt, String longOpt, String pattern) {
        return this.addOption(new Option(opt, longOpt, pattern));
    }

    public Options addOption(Option opt) {
        if (opt.hasLongOpt()) {
            this.longOpts.put(opt.getLongOpt(), opt);
        }
        if (opt.hasShortOpt()) {
            this.shortOpts.put(opt.getOpt(), opt);
        }
        return this;
    }

    boolean hasShortOption(String opt) {
        for (Map.Entry<String, Option> e : this.shortOpts.entrySet()) {
            if (!opt.startsWith(e.getKey())) continue;
            return true;
        }
        return false;
    }

    public Option matchShortOption(String opt) {
        for (Map.Entry<String, Option> e : this.shortOpts.entrySet()) {
            Matcher m;
            if (!opt.startsWith(e.getKey())) continue;
            Option cmd = e.getValue();
            if (cmd.hasArg() && (m = cmd.pattern().matcher(opt)).find()) {
                cmd.setValue(m.group());
            }
            return cmd;
        }
        return null;
    }

    boolean hasLongOption(String opt) {
        for (Map.Entry<String, Option> e : this.longOpts.entrySet()) {
            if (!opt.startsWith(e.getKey())) continue;
            return true;
        }
        return false;
    }

    Option matchLongOption(String opt) {
        for (Map.Entry<String, Option> e : this.longOpts.entrySet()) {
            Matcher m;
            if (!opt.startsWith(e.getKey())) continue;
            Option cmd = e.getValue();
            if (cmd.hasArg() && (m = cmd.pattern().matcher(opt)).find()) {
                cmd.setValue(m.group(1));
            }
            return cmd;
        }
        return null;
    }
}

