/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.IntBuffer;
import javax.media.j3d.J3dI18N;

public class NioImageBuffer {
    int width;
    int height;
    ImageType imageType;
    Buffer buffer;
    BufferType bufferType;
    int bytesPerPixel;
    int elementsPerPixel;

    public NioImageBuffer(int n, int n2, ImageType imageType) {
        this.processParams(n, n2, imageType);
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(n * n2 * this.bytesPerPixel);
        switch (this.bufferType) {
            case BYTE_BUFFER: {
                this.buffer = byteBuffer;
                break;
            }
            case INT_BUFFER: {
                this.buffer = byteBuffer.order(ByteOrder.nativeOrder()).asIntBuffer();
                break;
            }
            default: {
                throw new AssertionError((Object)"missing case statement");
            }
        }
    }

    public NioImageBuffer(int n, int n2, ImageType imageType, Buffer buffer) {
        this.processParams(n, n2, imageType);
        this.setDataBuffer(buffer);
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public ImageType getImageType() {
        return this.imageType;
    }

    public void setDataBuffer(Buffer buffer) {
        if (buffer == null) {
            throw new NullPointerException();
        }
        if (buffer.limit() != this.width * this.height * this.elementsPerPixel) {
            throw new IllegalArgumentException(J3dI18N.getString("NioImageBuffer3"));
        }
        switch (this.bufferType) {
            case BYTE_BUFFER: {
                if (!(buffer instanceof ByteBuffer)) {
                    throw new IllegalArgumentException(J3dI18N.getString("NioImageBuffer4"));
                }
                this.buffer = ((ByteBuffer)buffer).duplicate().rewind();
                break;
            }
            case INT_BUFFER: {
                if (!(buffer instanceof IntBuffer)) {
                    throw new IllegalArgumentException(J3dI18N.getString("NioImageBuffer4"));
                }
                if (((IntBuffer)buffer).order() != ByteOrder.nativeOrder()) {
                    throw new IllegalArgumentException(J3dI18N.getString("NioImageBuffer5"));
                }
                this.buffer = ((IntBuffer)buffer).duplicate().rewind();
                break;
            }
            default: {
                throw new AssertionError((Object)"missing case statement");
            }
        }
    }

    public Buffer getDataBuffer() {
        Buffer buffer = null;
        switch (this.bufferType) {
            case BYTE_BUFFER: {
                buffer = ((ByteBuffer)this.buffer).duplicate();
                break;
            }
            case INT_BUFFER: {
                buffer = ((IntBuffer)this.buffer).duplicate();
                break;
            }
            default: {
                throw new AssertionError((Object)"missing case statement");
            }
        }
        return buffer.rewind();
    }

    private void processParams(int n, int n2, ImageType imageType) {
        if (n < 1) {
            throw new IllegalArgumentException(J3dI18N.getString("NioImageBuffer0"));
        }
        if (n2 < 1) {
            throw new IllegalArgumentException(J3dI18N.getString("NioImageBuffer1"));
        }
        switch (imageType) {
            case TYPE_3BYTE_BGR: {
                this.bufferType = BufferType.BYTE_BUFFER;
                this.bytesPerPixel = 3;
                this.elementsPerPixel = 3;
                break;
            }
            case TYPE_3BYTE_RGB: {
                this.bufferType = BufferType.BYTE_BUFFER;
                this.bytesPerPixel = 3;
                this.elementsPerPixel = 3;
                break;
            }
            case TYPE_4BYTE_ABGR: {
                this.bufferType = BufferType.BYTE_BUFFER;
                this.bytesPerPixel = 4;
                this.elementsPerPixel = 4;
                break;
            }
            case TYPE_4BYTE_RGBA: {
                this.bufferType = BufferType.BYTE_BUFFER;
                this.bytesPerPixel = 4;
                this.elementsPerPixel = 4;
                break;
            }
            case TYPE_BYTE_GRAY: {
                this.bufferType = BufferType.BYTE_BUFFER;
                this.bytesPerPixel = 1;
                this.elementsPerPixel = 1;
                break;
            }
            case TYPE_INT_ARGB: 
            case TYPE_INT_BGR: 
            case TYPE_INT_RGB: {
                this.bufferType = BufferType.INT_BUFFER;
                this.bytesPerPixel = 4;
                this.elementsPerPixel = 1;
                break;
            }
            default: {
                throw new AssertionError((Object)"missing case statement");
            }
        }
        this.width = n;
        this.height = n2;
        this.imageType = imageType;
    }

    static enum BufferType {
        BYTE_BUFFER,
        INT_BUFFER;

    }

    public static enum ImageType {
        TYPE_3BYTE_BGR,
        TYPE_3BYTE_RGB,
        TYPE_4BYTE_ABGR,
        TYPE_4BYTE_RGBA,
        TYPE_BYTE_GRAY,
        TYPE_INT_ARGB,
        TYPE_INT_BGR,
        TYPE_INT_RGB;

    }
}

