// Automatically generated file. DO NOT EDIT.
// Generated by gen-device-svd.go from stm32l0x2.svd, see https://github.com/tinygo-org/stm32-svd

//go:build stm32 && stm32l0x2
// +build stm32,stm32l0x2

// STM32L0x2
//

package stm32

import (
	"runtime/volatile"
	"unsafe"
)

// Some information about this device.
const (
	Device       = "STM32L0x2"
	CPU          = "CM0+"
	FPUPresent   = false
	NVICPrioBits = 2
)

// Interrupt numbers.
const (
	// System window watchdog
	IRQ_WWDG = 0

	// External interrupt/event controller
	IRQ_PVD = 1

	// Real-time clock
	IRQ_RTC = 2

	// Reset and clock control
	IRQ_RCC = 4

	// External interrupt/event controller
	IRQ_EXTI0_1 = 5

	// External interrupt/event controller // Analog-to-digital converter
	IRQ_EXTI2_3 = 6

	// External interrupt/event controller
	IRQ_EXTI4_15 = 7

	// Touch sensing controller
	IRQ_TSC = 8

	// Direct memory access controller
	IRQ_DMA1_Channel1 = 9

	// Direct memory access controller
	IRQ_DMA1_Channel2_3 = 10

	// Direct memory access controller
	IRQ_DMA1_Channel4_7 = 11

	// Debug support
	IRQ_ADC_COMP = 12

	// Low power timer
	IRQ_LPTIM1 = 13

	IRQ_USART4_USART5 = 14

	IRQ_TIM2 = 15

	// Basic-timers
	IRQ_TIM3 = 16

	IRQ_TIM6_DAC = 17

	// General-purpose-timers
	IRQ_TIM7 = 18

	// General-purpose-timers
	IRQ_TIM21 = 20

	// Power control
	IRQ_I2C3 = 21

	// Universal synchronous asynchronous receiver transmitter
	IRQ_TIM22 = 22

	IRQ_I2C1 = 23

	IRQ_I2C2 = 24

	IRQ_SPI1 = 25

	// Inter-integrated circuit
	IRQ_SPI2 = 26

	IRQ_USART1 = 27

	IRQ_USART2 = 28

	// Advanced encryption standard hardware accelerator
	IRQ_AES_RNG_LPUART1 = 29

	// Universal serial bus full-speed device interface
	IRQ_USB = 31

	// Highest interrupt number on this device.
	IRQ_max = 31
)

// Pseudo function call that is replaced by the compiler with the actual
// functions registered through interrupt.New.
//go:linkname callHandlers runtime/interrupt.callHandlers
func callHandlers(num int)

//export WWDG_IRQHandler
func interruptWWDG() {
	callHandlers(IRQ_WWDG)
}

//export PVD_IRQHandler
func interruptPVD() {
	callHandlers(IRQ_PVD)
}

//export RTC_IRQHandler
func interruptRTC() {
	callHandlers(IRQ_RTC)
}

//export RCC_IRQHandler
func interruptRCC() {
	callHandlers(IRQ_RCC)
}

//export EXTI0_1_IRQHandler
func interruptEXTI0_1() {
	callHandlers(IRQ_EXTI0_1)
}

//export EXTI2_3_IRQHandler
func interruptEXTI2_3() {
	callHandlers(IRQ_EXTI2_3)
}

//export EXTI4_15_IRQHandler
func interruptEXTI4_15() {
	callHandlers(IRQ_EXTI4_15)
}

//export TSC_IRQHandler
func interruptTSC() {
	callHandlers(IRQ_TSC)
}

//export DMA1_Channel1_IRQHandler
func interruptDMA1_Channel1() {
	callHandlers(IRQ_DMA1_Channel1)
}

//export DMA1_Channel2_3_IRQHandler
func interruptDMA1_Channel2_3() {
	callHandlers(IRQ_DMA1_Channel2_3)
}

//export DMA1_Channel4_7_IRQHandler
func interruptDMA1_Channel4_7() {
	callHandlers(IRQ_DMA1_Channel4_7)
}

//export ADC_COMP_IRQHandler
func interruptADC_COMP() {
	callHandlers(IRQ_ADC_COMP)
}

//export LPTIM1_IRQHandler
func interruptLPTIM1() {
	callHandlers(IRQ_LPTIM1)
}

//export USART4_USART5_IRQHandler
func interruptUSART4_USART5() {
	callHandlers(IRQ_USART4_USART5)
}

//export TIM2_IRQHandler
func interruptTIM2() {
	callHandlers(IRQ_TIM2)
}

//export TIM3_IRQHandler
func interruptTIM3() {
	callHandlers(IRQ_TIM3)
}

//export TIM6_DAC_IRQHandler
func interruptTIM6_DAC() {
	callHandlers(IRQ_TIM6_DAC)
}

//export TIM7_IRQHandler
func interruptTIM7() {
	callHandlers(IRQ_TIM7)
}

//export TIM21_IRQHandler
func interruptTIM21() {
	callHandlers(IRQ_TIM21)
}

//export I2C3_IRQHandler
func interruptI2C3() {
	callHandlers(IRQ_I2C3)
}

//export TIM22_IRQHandler
func interruptTIM22() {
	callHandlers(IRQ_TIM22)
}

//export I2C1_IRQHandler
func interruptI2C1() {
	callHandlers(IRQ_I2C1)
}

//export I2C2_IRQHandler
func interruptI2C2() {
	callHandlers(IRQ_I2C2)
}

//export SPI1_IRQHandler
func interruptSPI1() {
	callHandlers(IRQ_SPI1)
}

//export SPI2_IRQHandler
func interruptSPI2() {
	callHandlers(IRQ_SPI2)
}

//export USART1_IRQHandler
func interruptUSART1() {
	callHandlers(IRQ_USART1)
}

//export USART2_IRQHandler
func interruptUSART2() {
	callHandlers(IRQ_USART2)
}

//export AES_RNG_LPUART1_IRQHandler
func interruptAES_RNG_LPUART1() {
	callHandlers(IRQ_AES_RNG_LPUART1)
}

//export USB_IRQHandler
func interruptUSB() {
	callHandlers(IRQ_USB)
}

// Peripherals.
var (
	// Advanced encryption standard hardware accelerator
	AES = (*AES_Type)(unsafe.Pointer(uintptr(0x40026000)))

	// Digital-to-analog converter
	DAC = (*DAC_Type)(unsafe.Pointer(uintptr(0x40007400)))

	// Direct memory access controller
	DMA1 = (*DMA_Type)(unsafe.Pointer(uintptr(0x40020000)))

	// Cyclic redundancy check calculation unit
	CRC = (*CRC_Type)(unsafe.Pointer(uintptr(0x40023000)))

	// General-purpose I/Os
	GPIOA = (*GPIO_Type)(unsafe.Pointer(uintptr(0x50000000)))

	// General-purpose I/Os
	GPIOB = (*GPIO_Type)(unsafe.Pointer(uintptr(0x50000400)))

	// Low power timer
	LPTIM = (*LPTIM_Type)(unsafe.Pointer(uintptr(0x40007c00)))

	// Random number generator
	RNG = (*RNG_Type)(unsafe.Pointer(uintptr(0x40025000)))

	// Real-time clock
	RTC = (*RTC_Type)(unsafe.Pointer(uintptr(0x40002800)))

	// Universal synchronous asynchronous receiver transmitter
	USART1 = (*USART_Type)(unsafe.Pointer(uintptr(0x40013800)))

	// Touch sensing controller
	TSC = (*TSC_Type)(unsafe.Pointer(uintptr(0x40024000)))

	// Independent watchdog
	IWDG = (*IWDG_Type)(unsafe.Pointer(uintptr(0x40003000)))

	// System window watchdog
	WWDG = (*WWDG_Type)(unsafe.Pointer(uintptr(0x40002c00)))

	// Universal serial bus full-speed device interface
	USB = (*USB_Type)(unsafe.Pointer(uintptr(0x40005c00)))

	// Clock recovery system
	CRS = (*CRS_Type)(unsafe.Pointer(uintptr(0x40006c00)))

	// Firewall
	FW = (*Firewall_Type)(unsafe.Pointer(uintptr(0x40011c00)))

	// Reset and clock control
	RCC = (*RCC_Type)(unsafe.Pointer(uintptr(0x40021000)))

	// System configuration controller and Comparator
	SYSCFG = (*SYSCFG_Type)(unsafe.Pointer(uintptr(0x40010000)))

	// Serial peripheral interface
	SPI1 = (*SPI_Type)(unsafe.Pointer(uintptr(0x40013000)))

	// Inter-integrated circuit
	I2C1 = (*I2C_Type)(unsafe.Pointer(uintptr(0x40005400)))

	// Power control
	PWR = (*PWR_Type)(unsafe.Pointer(uintptr(0x40007000)))

	// Flash
	FLASH = (*Flash_Type)(unsafe.Pointer(uintptr(0x40022000)))

	// External interrupt/event controller
	EXTI = (*EXTI_Type)(unsafe.Pointer(uintptr(0x40010400)))

	// Analog-to-digital converter
	ADC = (*ADC_Type)(unsafe.Pointer(uintptr(0x40012400)))

	// Debug support
	DBG = (*DBGMCU_Type)(unsafe.Pointer(uintptr(0x40015800)))

	// General-purpose-timers
	TIM2 = (*TIM_Type)(unsafe.Pointer(uintptr(0x40000000)))

	// Basic-timers
	TIM6 = (*TIM_Type)(unsafe.Pointer(uintptr(0x40001000)))

	// General-purpose-timers
	TIM21 = (*TIM_Type)(unsafe.Pointer(uintptr(0x40010800)))

	// General-purpose-timers
	TIM22 = (*TIM_Type)(unsafe.Pointer(uintptr(0x40011400)))

	// Universal synchronous asynchronous receiver transmitter
	LPUART1 = (*USART_Type)(unsafe.Pointer(uintptr(0x40004800)))

	// Nested Vectored Interrupt Controller
	NVIC = (*NVIC_Type)(unsafe.Pointer(uintptr(0xe000e100)))

	// Memory protection unit
	MPU = (*MPU_Type)(unsafe.Pointer(uintptr(0xe000ed90)))

	// SysTick timer
	STK = (*STK_Type)(unsafe.Pointer(uintptr(0xe000e010)))

	// System control block
	SCB = (*SCB_Type)(unsafe.Pointer(uintptr(0xe000ed00)))

	// General-purpose I/Os
	GPIOC = (*GPIO_Type)(unsafe.Pointer(uintptr(0x50000800)))

	// General-purpose I/Os
	GPIOD = (*GPIO_Type)(unsafe.Pointer(uintptr(0x50000c00)))

	// General-purpose I/Os
	GPIOH = (*GPIO_Type)(unsafe.Pointer(uintptr(0x50001c00)))

	// General-purpose I/Os
	GPIOE = (*GPIO_Type)(unsafe.Pointer(uintptr(0x50001000)))

	// Universal synchronous asynchronous receiver transmitter
	USART2 = (*USART_Type)(unsafe.Pointer(uintptr(0x40004400)))

	// Universal synchronous asynchronous receiver transmitter
	USART4 = (*USART_Type)(unsafe.Pointer(uintptr(0x40004c00)))

	// Universal synchronous asynchronous receiver transmitter
	USART5 = (*USART_Type)(unsafe.Pointer(uintptr(0x40005000)))

	// Serial peripheral interface
	SPI2 = (*SPI_Type)(unsafe.Pointer(uintptr(0x40003800)))

	// Inter-integrated circuit
	I2C2 = (*I2C_Type)(unsafe.Pointer(uintptr(0x40005800)))

	// Inter-integrated circuit
	I2C3 = (*I2C_Type)(unsafe.Pointer(uintptr(0x40007800)))

	// General-purpose-timers
	TIM3 = (*TIM_Type)(unsafe.Pointer(uintptr(0x40000400)))

	// Basic-timers
	TIM7 = (*TIM_Type)(unsafe.Pointer(uintptr(0x40001400)))
)

// Advanced encryption standard hardware accelerator
type AES_Type struct {
	CR    volatile.Register32 // 0x0
	SR    volatile.Register32 // 0x4
	DINR  volatile.Register32 // 0x8
	DOUTR volatile.Register32 // 0xC
	KEYR0 volatile.Register32 // 0x10
	KEYR1 volatile.Register32 // 0x14
	KEYR2 volatile.Register32 // 0x18
	KEYR3 volatile.Register32 // 0x1C
	IVR0  volatile.Register32 // 0x20
	IVR1  volatile.Register32 // 0x24
	IVR2  volatile.Register32 // 0x28
	IVR3  volatile.Register32 // 0x2C
}

// Digital-to-analog converter
type DAC_Type struct {
	CR      volatile.Register32 // 0x0
	SWTRIGR volatile.Register32 // 0x4
	DHR12R1 volatile.Register32 // 0x8
	DHR12L1 volatile.Register32 // 0xC
	DHR8R1  volatile.Register32 // 0x10
	DHR12R2 volatile.Register32 // 0x14
	DHR12L2 volatile.Register32 // 0x18
	DHR8R2  volatile.Register32 // 0x1C
	DHR12RD volatile.Register32 // 0x20
	DHR12LD volatile.Register32 // 0x24
	DHR8RD  volatile.Register32 // 0x28
	DOR1    volatile.Register32 // 0x2C
	DOR2    volatile.Register32 // 0x30
	SR      volatile.Register32 // 0x34
}

// Direct memory access controller
type DMA_Type struct {
	ISR  volatile.Register32 // 0x0
	IFCR volatile.Register32 // 0x4
	CH   [7]struct {
		CR   volatile.Register32
		NDTR volatile.Register32
		PAR  volatile.Register32
		MAR  volatile.Register32
		_    [4]byte
	} // 0x8
	_     [20]byte
	CSELR volatile.Register32 // 0xA8
}

// Cyclic redundancy check calculation unit
type CRC_Type struct {
	DR   volatile.Register32 // 0x0
	IDR  volatile.Register32 // 0x4
	CR   volatile.Register32 // 0x8
	_    [4]byte
	INIT volatile.Register32 // 0x10
	POL  volatile.Register32 // 0x14
}

// General-purpose I/Os
type GPIO_Type struct {
	MODER   volatile.Register32 // 0x0
	OTYPER  volatile.Register32 // 0x4
	OSPEEDR volatile.Register32 // 0x8
	PUPDR   volatile.Register32 // 0xC
	IDR     volatile.Register32 // 0x10
	ODR     volatile.Register32 // 0x14
	BSRR    volatile.Register32 // 0x18
	LCKR    volatile.Register32 // 0x1C
	AFRL    volatile.Register32 // 0x20
	AFRH    volatile.Register32 // 0x24
	BRR     volatile.Register32 // 0x28
}

// Low power timer
type LPTIM_Type struct {
	ISR  volatile.Register32 // 0x0
	ICR  volatile.Register32 // 0x4
	IER  volatile.Register32 // 0x8
	CFGR volatile.Register32 // 0xC
	CR   volatile.Register32 // 0x10
	CMP  volatile.Register32 // 0x14
	ARR  volatile.Register32 // 0x18
	CNT  volatile.Register32 // 0x1C
}

// Random number generator
type RNG_Type struct {
	CR volatile.Register32 // 0x0
	SR volatile.Register32 // 0x4
	DR volatile.Register32 // 0x8
}

// Real-time clock
type RTC_Type struct {
	TR       volatile.Register32 // 0x0
	DR       volatile.Register32 // 0x4
	CR       volatile.Register32 // 0x8
	ISR      volatile.Register32 // 0xC
	PRER     volatile.Register32 // 0x10
	WUTR     volatile.Register32 // 0x14
	_        [4]byte
	ALRMAR   volatile.Register32 // 0x1C
	ALRMBR   volatile.Register32 // 0x20
	WPR      volatile.Register32 // 0x24
	SSR      volatile.Register32 // 0x28
	SHIFTR   volatile.Register32 // 0x2C
	TSTR     volatile.Register32 // 0x30
	TSDR     volatile.Register32 // 0x34
	TSSSR    volatile.Register32 // 0x38
	CALR     volatile.Register32 // 0x3C
	TAMPCR   volatile.Register32 // 0x40
	ALRMASSR volatile.Register32 // 0x44
	ALRMBSSR volatile.Register32 // 0x48
	OR       volatile.Register32 // 0x4C
	BKP0R    volatile.Register32 // 0x50
	BKP1R    volatile.Register32 // 0x54
	BKP2R    volatile.Register32 // 0x58
	BKP3R    volatile.Register32 // 0x5C
	BKP4R    volatile.Register32 // 0x60
}

// Universal synchronous asynchronous receiver transmitter
type USART_Type struct {
	CR1  volatile.Register32 // 0x0
	CR2  volatile.Register32 // 0x4
	CR3  volatile.Register32 // 0x8
	BRR  volatile.Register32 // 0xC
	GTPR volatile.Register32 // 0x10
	RTOR volatile.Register32 // 0x14
	RQR  volatile.Register32 // 0x18
	ISR  volatile.Register32 // 0x1C
	ICR  volatile.Register32 // 0x20
	RDR  volatile.Register32 // 0x24
	TDR  volatile.Register32 // 0x28
}

// Touch sensing controller
type TSC_Type struct {
	CR     volatile.Register32 // 0x0
	IER    volatile.Register32 // 0x4
	ICR    volatile.Register32 // 0x8
	ISR    volatile.Register32 // 0xC
	IOHCR  volatile.Register32 // 0x10
	_      [4]byte
	IOASCR volatile.Register32 // 0x18
	_      [4]byte
	IOSCR  volatile.Register32 // 0x20
	_      [4]byte
	IOCCR  volatile.Register32 // 0x28
	_      [4]byte
	IOGCSR volatile.Register32 // 0x30
	IOG1CR volatile.Register32 // 0x34
	IOG2CR volatile.Register32 // 0x38
	IOG3CR volatile.Register32 // 0x3C
	IOG4CR volatile.Register32 // 0x40
	IOG5CR volatile.Register32 // 0x44
	IOG6CR volatile.Register32 // 0x48
	IOG7CR volatile.Register32 // 0x4C
	IOG8CR volatile.Register32 // 0x50
}

// Independent watchdog
type IWDG_Type struct {
	KR   volatile.Register32 // 0x0
	PR   volatile.Register32 // 0x4
	RLR  volatile.Register32 // 0x8
	SR   volatile.Register32 // 0xC
	WINR volatile.Register32 // 0x10
}

// System window watchdog
type WWDG_Type struct {
	CR  volatile.Register32 // 0x0
	CFR volatile.Register32 // 0x4
	SR  volatile.Register32 // 0x8
}

// Universal serial bus full-speed device interface
type USB_Type struct {
	EP0R   volatile.Register32 // 0x0
	EP1R   volatile.Register32 // 0x4
	EP2R   volatile.Register32 // 0x8
	EP3R   volatile.Register32 // 0xC
	EP4R   volatile.Register32 // 0x10
	EP5R   volatile.Register32 // 0x14
	EP6R   volatile.Register32 // 0x18
	EP7R   volatile.Register32 // 0x1C
	_      [32]byte
	CNTR   volatile.Register32 // 0x40
	ISTR   volatile.Register32 // 0x44
	FNR    volatile.Register32 // 0x48
	DADDR  volatile.Register32 // 0x4C
	BTABLE volatile.Register32 // 0x50
	LPMCSR volatile.Register32 // 0x54
	BCDR   volatile.Register32 // 0x58
}

// Clock recovery system
type CRS_Type struct {
	CR   volatile.Register32 // 0x0
	CFGR volatile.Register32 // 0x4
	ISR  volatile.Register32 // 0x8
	ICR  volatile.Register32 // 0xC
}

// Firewall
type Firewall_Type struct {
	CSSA   volatile.Register32 // 0x0
	CSL    volatile.Register32 // 0x4
	NVDSSA volatile.Register32 // 0x8
	NVDSL  volatile.Register32 // 0xC
	VDSSA  volatile.Register32 // 0x10
	VDSL   volatile.Register32 // 0x14
	_      [8]byte
	CR     volatile.Register32 // 0x20
}

// Reset and clock control
type RCC_Type struct {
	CR        volatile.Register32 // 0x0
	ICSCR     volatile.Register32 // 0x4
	CRRCR     volatile.Register32 // 0x8
	CFGR      volatile.Register32 // 0xC
	CIER      volatile.Register32 // 0x10
	CIFR      volatile.Register32 // 0x14
	CICR      volatile.Register32 // 0x18
	IOPRSTR   volatile.Register32 // 0x1C
	AHBRSTR   volatile.Register32 // 0x20
	APB2RSTR  volatile.Register32 // 0x24
	APB1RSTR  volatile.Register32 // 0x28
	IOPENR    volatile.Register32 // 0x2C
	AHBENR    volatile.Register32 // 0x30
	APB2ENR   volatile.Register32 // 0x34
	APB1ENR   volatile.Register32 // 0x38
	IOPSMEN   volatile.Register32 // 0x3C
	AHBSMENR  volatile.Register32 // 0x40
	APB2SMENR volatile.Register32 // 0x44
	APB1SMENR volatile.Register32 // 0x48
	CCIPR     volatile.Register32 // 0x4C
	CSR       volatile.Register32 // 0x50
}

// System configuration controller and Comparator
type SYSCFG_Type struct {
	CFGR1     volatile.Register32 // 0x0
	CFGR2     volatile.Register32 // 0x4
	EXTICR1   volatile.Register32 // 0x8
	EXTICR2   volatile.Register32 // 0xC
	EXTICR3   volatile.Register32 // 0x10
	EXTICR4   volatile.Register32 // 0x14
	COMP1_CSR volatile.Register32 // 0x18
	COMP2_CSR volatile.Register32 // 0x1C
	CFGR3     volatile.Register32 // 0x20
}

// Serial peripheral interface
type SPI_Type struct {
	CR1     volatile.Register32 // 0x0
	CR2     volatile.Register32 // 0x4
	SR      volatile.Register32 // 0x8
	DR      volatile.Register32 // 0xC
	CRCPR   volatile.Register32 // 0x10
	RXCRCR  volatile.Register32 // 0x14
	TXCRCR  volatile.Register32 // 0x18
	I2SCFGR volatile.Register32 // 0x1C
	I2SPR   volatile.Register32 // 0x20
}

// Inter-integrated circuit
type I2C_Type struct {
	CR1      volatile.Register32 // 0x0
	CR2      volatile.Register32 // 0x4
	OAR1     volatile.Register32 // 0x8
	OAR2     volatile.Register32 // 0xC
	TIMINGR  volatile.Register32 // 0x10
	TIMEOUTR volatile.Register32 // 0x14
	ISR      volatile.Register32 // 0x18
	ICR      volatile.Register32 // 0x1C
	PECR     volatile.Register32 // 0x20
	RXDR     volatile.Register32 // 0x24
	TXDR     volatile.Register32 // 0x28
}

// Power control
type PWR_Type struct {
	CR  volatile.Register32 // 0x0
	CSR volatile.Register32 // 0x4
}

// Flash
type Flash_Type struct {
	ACR     volatile.Register32 // 0x0
	PECR    volatile.Register32 // 0x4
	PDKEYR  volatile.Register32 // 0x8
	PEKEYR  volatile.Register32 // 0xC
	PRGKEYR volatile.Register32 // 0x10
	OPTKEYR volatile.Register32 // 0x14
	SR      volatile.Register32 // 0x18
	OPTR    volatile.Register32 // 0x1C
	WRPROT1 volatile.Register32 // 0x20
	_       [92]byte
	WRPROT2 volatile.Register32 // 0x80
}

// External interrupt/event controller
type EXTI_Type struct {
	IMR   volatile.Register32 // 0x0
	EMR   volatile.Register32 // 0x4
	RTSR  volatile.Register32 // 0x8
	FTSR  volatile.Register32 // 0xC
	SWIER volatile.Register32 // 0x10
	PR    volatile.Register32 // 0x14
}

// Analog-to-digital converter
type ADC_Type struct {
	ISR     volatile.Register32 // 0x0
	IER     volatile.Register32 // 0x4
	CR      volatile.Register32 // 0x8
	CFGR1   volatile.Register32 // 0xC
	CFGR2   volatile.Register32 // 0x10
	SMPR    volatile.Register32 // 0x14
	_       [8]byte
	TR      volatile.Register32 // 0x20
	_       [4]byte
	CHSELR  volatile.Register32 // 0x28
	_       [20]byte
	DR      volatile.Register32 // 0x40
	_       [112]byte
	CALFACT volatile.Register32 // 0xB4
	_       [592]byte
	CCR     volatile.Register32 // 0x308
}

// Debug support
type DBGMCU_Type struct {
	IDCODE  volatile.Register32 // 0x0
	CR      volatile.Register32 // 0x4
	APB1_FZ volatile.Register32 // 0x8
	APB2_FZ volatile.Register32 // 0xC
}

// General-purpose-timers
type TIM_Type struct {
	CR1          volatile.Register32 // 0x0
	CR2          volatile.Register32 // 0x4
	SMCR         volatile.Register32 // 0x8
	DIER         volatile.Register32 // 0xC
	SR           volatile.Register32 // 0x10
	EGR          volatile.Register32 // 0x14
	CCMR1_Output volatile.Register32 // 0x18
	CCMR2_Output volatile.Register32 // 0x1C
	CCER         volatile.Register32 // 0x20
	CNT          volatile.Register16 // 0x24
	_            [2]byte
	PSC          volatile.Register32 // 0x28
	ARR          volatile.Register16 // 0x2C
	_            [6]byte
	CCR1         volatile.Register16 // 0x34
	_            [2]byte
	CCR2         volatile.Register16 // 0x38
	_            [2]byte
	CCR3         volatile.Register16 // 0x3C
	_            [2]byte
	CCR4         volatile.Register16 // 0x40
	_            [6]byte
	DCR          volatile.Register32 // 0x48
	DMAR         volatile.Register32 // 0x4C
	OR           volatile.Register32 // 0x50
}

// Nested Vectored Interrupt Controller
type NVIC_Type struct {
	ISER volatile.Register32 // 0x0
	_    [124]byte
	ICER volatile.Register32 // 0x80
	_    [124]byte
	ISPR volatile.Register32 // 0x100
	_    [124]byte
	ICPR volatile.Register32 // 0x180
	_    [380]byte
	IPR0 volatile.Register32 // 0x300
	IPR1 volatile.Register32 // 0x304
	IPR2 volatile.Register32 // 0x308
	IPR3 volatile.Register32 // 0x30C
	IPR4 volatile.Register32 // 0x310
	IPR5 volatile.Register32 // 0x314
	IPR6 volatile.Register32 // 0x318
	IPR7 volatile.Register32 // 0x31C
}

// Memory protection unit
type MPU_Type struct {
	MPU_TYPER volatile.Register32 // 0x0
	MPU_CTRL  volatile.Register32 // 0x4
	MPU_RNR   volatile.Register32 // 0x8
	MPU_RBAR  volatile.Register32 // 0xC
	MPU_RASR  volatile.Register32 // 0x10
}

// SysTick timer
type STK_Type struct {
	CSR   volatile.Register32 // 0x0
	RVR   volatile.Register32 // 0x4
	CVR   volatile.Register32 // 0x8
	CALIB volatile.Register32 // 0xC
}

// System control block
type SCB_Type struct {
	CPUID volatile.Register32 // 0x0
	ICSR  volatile.Register32 // 0x4
	VTOR  volatile.Register32 // 0x8
	AIRCR volatile.Register32 // 0xC
	SCR   volatile.Register32 // 0x10
	CCR   volatile.Register32 // 0x14
	_     [4]byte
	SHPR2 volatile.Register32 // 0x1C
	SHPR3 volatile.Register32 // 0x20
}

// Bitfields for AES: Advanced encryption standard hardware accelerator
const (
	// CR: control register
	// Position of DMAOUTEN field.
	AES_CR_DMAOUTEN_Pos = 0xc
	// Bit mask of DMAOUTEN field.
	AES_CR_DMAOUTEN_Msk = 0x1000
	// Bit DMAOUTEN.
	AES_CR_DMAOUTEN = 0x1000
	// Disable DMA Output
	AES_CR_DMAOUTEN_Disabled = 0x0
	// Enabled DMA Output
	AES_CR_DMAOUTEN_Enabled = 0x1
	// Position of DMAINEN field.
	AES_CR_DMAINEN_Pos = 0xb
	// Bit mask of DMAINEN field.
	AES_CR_DMAINEN_Msk = 0x800
	// Bit DMAINEN.
	AES_CR_DMAINEN = 0x800
	// Disable DMA Input
	AES_CR_DMAINEN_Disabled = 0x0
	// Enable DMA Input
	AES_CR_DMAINEN_Enabled = 0x1
	// Position of ERRIE field.
	AES_CR_ERRIE_Pos = 0xa
	// Bit mask of ERRIE field.
	AES_CR_ERRIE_Msk = 0x400
	// Bit ERRIE.
	AES_CR_ERRIE = 0x400
	// Disable (mask) error interrupt
	AES_CR_ERRIE_Disabled = 0x0
	// Enable error interrupt
	AES_CR_ERRIE_Enabled = 0x1
	// Position of CCFIE field.
	AES_CR_CCFIE_Pos = 0x9
	// Bit mask of CCFIE field.
	AES_CR_CCFIE_Msk = 0x200
	// Bit CCFIE.
	AES_CR_CCFIE = 0x200
	// Disable (mask) CCF interrupt
	AES_CR_CCFIE_Disabled = 0x0
	// Enable CCF interrupt
	AES_CR_CCFIE_Enabled = 0x1
	// Position of ERRC field.
	AES_CR_ERRC_Pos = 0x8
	// Bit mask of ERRC field.
	AES_CR_ERRC_Msk = 0x100
	// Bit ERRC.
	AES_CR_ERRC = 0x100
	// Clear RDERR and WRERR flags
	AES_CR_ERRC_Clear = 0x1
	// Position of CCFC field.
	AES_CR_CCFC_Pos = 0x7
	// Bit mask of CCFC field.
	AES_CR_CCFC_Msk = 0x80
	// Bit CCFC.
	AES_CR_CCFC = 0x80
	// Clear computation complete flag
	AES_CR_CCFC_Clear = 0x1
	// Position of CHMOD field.
	AES_CR_CHMOD_Pos = 0x5
	// Bit mask of CHMOD field.
	AES_CR_CHMOD_Msk = 0x60
	// Electronic codebook (ECB)
	AES_CR_CHMOD_ECB = 0x0
	// Cipher-Block Chaining (CBC)
	AES_CR_CHMOD_CBC = 0x1
	// Counter Mode (CTR)
	AES_CR_CHMOD_CTR = 0x2
	// Position of MODE field.
	AES_CR_MODE_Pos = 0x3
	// Bit mask of MODE field.
	AES_CR_MODE_Msk = 0x18
	// Mode 1: encryption
	AES_CR_MODE_Mode1 = 0x0
	// Mode 2: key derivation (or key preparation for ECB/CBC decryption)
	AES_CR_MODE_Mode2 = 0x1
	// Mode 3: decryption
	AES_CR_MODE_Mode3 = 0x2
	// Mode 4: key derivation then single decryption
	AES_CR_MODE_Mode4 = 0x3
	// Position of DATATYPE field.
	AES_CR_DATATYPE_Pos = 0x1
	// Bit mask of DATATYPE field.
	AES_CR_DATATYPE_Msk = 0x6
	// Word
	AES_CR_DATATYPE_None = 0x0
	// Half-word (16-bit)
	AES_CR_DATATYPE_HalfWord = 0x1
	// Byte (8-bit)
	AES_CR_DATATYPE_Byte = 0x2
	// Bit
	AES_CR_DATATYPE_Bit = 0x3
	// Position of EN field.
	AES_CR_EN_Pos = 0x0
	// Bit mask of EN field.
	AES_CR_EN_Msk = 0x1
	// Bit EN.
	AES_CR_EN = 0x1
	// Disable AES
	AES_CR_EN_Disabled = 0x0
	// Enable AES
	AES_CR_EN_Enabled = 0x1

	// SR: status register
	// Position of WRERR field.
	AES_SR_WRERR_Pos = 0x2
	// Bit mask of WRERR field.
	AES_SR_WRERR_Msk = 0x4
	// Bit WRERR.
	AES_SR_WRERR = 0x4
	// Write error not detected
	AES_SR_WRERR_NoError = 0x0
	// Write error detected
	AES_SR_WRERR_Error = 0x1
	// Position of RDERR field.
	AES_SR_RDERR_Pos = 0x1
	// Bit mask of RDERR field.
	AES_SR_RDERR_Msk = 0x2
	// Bit RDERR.
	AES_SR_RDERR = 0x2
	// Read error not detected
	AES_SR_RDERR_NoError = 0x0
	// Read error detected
	AES_SR_RDERR_Error = 0x1
	// Position of CCF field.
	AES_SR_CCF_Pos = 0x0
	// Bit mask of CCF field.
	AES_SR_CCF_Msk = 0x1
	// Bit CCF.
	AES_SR_CCF = 0x1
	// Computation complete
	AES_SR_CCF_Complete = 0x0
	// Computation not complete
	AES_SR_CCF_NotComplete = 0x1

	// DINR: data input register
	// Position of DIN field.
	AES_DINR_DIN_Pos = 0x0
	// Bit mask of DIN field.
	AES_DINR_DIN_Msk = 0xffffffff

	// DOUTR: data output register
	// Position of DOUT field.
	AES_DOUTR_DOUT_Pos = 0x0
	// Bit mask of DOUT field.
	AES_DOUTR_DOUT_Msk = 0xffffffff

	// KEYR0: key register 0
	// Position of KEY0 field.
	AES_KEYR0_KEY0_Pos = 0x0
	// Bit mask of KEY0 field.
	AES_KEYR0_KEY0_Msk = 0xffffffff

	// KEYR1: key register 1
	// Position of KEY1 field.
	AES_KEYR1_KEY1_Pos = 0x0
	// Bit mask of KEY1 field.
	AES_KEYR1_KEY1_Msk = 0xffffffff

	// KEYR2: key register 2
	// Position of KEY2 field.
	AES_KEYR2_KEY2_Pos = 0x0
	// Bit mask of KEY2 field.
	AES_KEYR2_KEY2_Msk = 0xffffffff

	// KEYR3: key register 3
	// Position of KEY3 field.
	AES_KEYR3_KEY3_Pos = 0x0
	// Bit mask of KEY3 field.
	AES_KEYR3_KEY3_Msk = 0xffffffff

	// IVR0: initialization vector register 0
	// Position of IV0 field.
	AES_IVR0_IV0_Pos = 0x0
	// Bit mask of IV0 field.
	AES_IVR0_IV0_Msk = 0xffffffff

	// IVR1: initialization vector register 1
	// Position of IV1 field.
	AES_IVR1_IV1_Pos = 0x0
	// Bit mask of IV1 field.
	AES_IVR1_IV1_Msk = 0xffffffff

	// IVR2: initialization vector register 2
	// Position of IV2 field.
	AES_IVR2_IV2_Pos = 0x0
	// Bit mask of IV2 field.
	AES_IVR2_IV2_Msk = 0xffffffff

	// IVR3: initialization vector register 3
	// Position of IV3 field.
	AES_IVR3_IV3_Pos = 0x0
	// Bit mask of IV3 field.
	AES_IVR3_IV3_Msk = 0xffffffff
)

// Bitfields for DAC: Digital-to-analog converter
const (
	// CR: control register
	// Position of DMAUDRIE1 field.
	DAC_CR_DMAUDRIE1_Pos = 0xd
	// Bit mask of DMAUDRIE1 field.
	DAC_CR_DMAUDRIE1_Msk = 0x2000
	// Bit DMAUDRIE1.
	DAC_CR_DMAUDRIE1 = 0x2000
	// DAC channel X DMA Underrun Interrupt disabled
	DAC_CR_DMAUDRIE1_Disabled = 0x0
	// DAC channel X DMA Underrun Interrupt enabled
	DAC_CR_DMAUDRIE1_Enabled = 0x1
	// Position of DMAEN1 field.
	DAC_CR_DMAEN1_Pos = 0xc
	// Bit mask of DMAEN1 field.
	DAC_CR_DMAEN1_Msk = 0x1000
	// Bit DMAEN1.
	DAC_CR_DMAEN1 = 0x1000
	// DAC channel X DMA mode disabled
	DAC_CR_DMAEN1_Disabled = 0x0
	// DAC channel X DMA mode enabled
	DAC_CR_DMAEN1_Enabled = 0x1
	// Position of MAMP1 field.
	DAC_CR_MAMP1_Pos = 0x8
	// Bit mask of MAMP1 field.
	DAC_CR_MAMP1_Msk = 0xf00
	// Position of WAVE1 field.
	DAC_CR_WAVE1_Pos = 0x6
	// Bit mask of WAVE1 field.
	DAC_CR_WAVE1_Msk = 0xc0
	// Position of TSEL1 field.
	DAC_CR_TSEL1_Pos = 0x3
	// Bit mask of TSEL1 field.
	DAC_CR_TSEL1_Msk = 0x38
	// Timer 6 TRGO event
	DAC_CR_TSEL1_TIM6_TRGO = 0x0
	// Timer 3 TRGO event
	DAC_CR_TSEL1_TIM3_TRGO = 0x1
	// Timer 7 TRGO event
	DAC_CR_TSEL1_TIM7_TRGO = 0x2
	// Timer 15 TRGO event
	DAC_CR_TSEL1_TIM15_TRGO = 0x3
	// Timer 2 TRGO event
	DAC_CR_TSEL1_TIM2_TRGO = 0x4
	// EXTI line9
	DAC_CR_TSEL1_EXTI9 = 0x6
	// Software trigger
	DAC_CR_TSEL1_SOFTWARE = 0x7
	// Position of TEN1 field.
	DAC_CR_TEN1_Pos = 0x2
	// Bit mask of TEN1 field.
	DAC_CR_TEN1_Msk = 0x4
	// Bit TEN1.
	DAC_CR_TEN1 = 0x4
	// DAC channel X trigger disabled
	DAC_CR_TEN1_Disabled = 0x0
	// DAC channel X trigger enabled
	DAC_CR_TEN1_Enabled = 0x1
	// Position of BOFF1 field.
	DAC_CR_BOFF1_Pos = 0x1
	// Bit mask of BOFF1 field.
	DAC_CR_BOFF1_Msk = 0x2
	// Bit BOFF1.
	DAC_CR_BOFF1 = 0x2
	// DAC channel X output buffer enabled
	DAC_CR_BOFF1_Enabled = 0x0
	// DAC channel X output buffer disabled
	DAC_CR_BOFF1_Disabled = 0x1
	// Position of EN1 field.
	DAC_CR_EN1_Pos = 0x0
	// Bit mask of EN1 field.
	DAC_CR_EN1_Msk = 0x1
	// Bit EN1.
	DAC_CR_EN1 = 0x1
	// DAC channel X disabled
	DAC_CR_EN1_Disabled = 0x0
	// DAC channel X enabled
	DAC_CR_EN1_Enabled = 0x1

	// SWTRIGR: software trigger register
	// Position of SWTRIG1 field.
	DAC_SWTRIGR_SWTRIG1_Pos = 0x0
	// Bit mask of SWTRIG1 field.
	DAC_SWTRIGR_SWTRIG1_Msk = 0x1
	// Bit SWTRIG1.
	DAC_SWTRIGR_SWTRIG1 = 0x1
	// DAC channel X software trigger disabled
	DAC_SWTRIGR_SWTRIG1_Disabled = 0x0
	// DAC channel X software trigger enabled
	DAC_SWTRIGR_SWTRIG1_Enabled = 0x1

	// DHR12R1: channel1 12-bit right-aligned data holding register
	// Position of DACC1DHR field.
	DAC_DHR12R1_DACC1DHR_Pos = 0x0
	// Bit mask of DACC1DHR field.
	DAC_DHR12R1_DACC1DHR_Msk = 0xfff

	// DHR12L1: channel1 12-bit left-aligned data holding register
	// Position of DACC1DHR field.
	DAC_DHR12L1_DACC1DHR_Pos = 0x4
	// Bit mask of DACC1DHR field.
	DAC_DHR12L1_DACC1DHR_Msk = 0xfff0

	// DHR8R1: channel1 8-bit right-aligned data holding register
	// Position of DACC1DHR field.
	DAC_DHR8R1_DACC1DHR_Pos = 0x0
	// Bit mask of DACC1DHR field.
	DAC_DHR8R1_DACC1DHR_Msk = 0xff

	// DHR12R2: channel2 12-bit right-aligned data holding register
	// Position of DACC2DHR field.
	DAC_DHR12R2_DACC2DHR_Pos = 0x0
	// Bit mask of DACC2DHR field.
	DAC_DHR12R2_DACC2DHR_Msk = 0xfff

	// DHR12L2: channel2 12-bit left-aligned data holding register
	// Position of DACC2DHR field.
	DAC_DHR12L2_DACC2DHR_Pos = 0x4
	// Bit mask of DACC2DHR field.
	DAC_DHR12L2_DACC2DHR_Msk = 0xfff0

	// DHR8R2: channel2 8-bit right-aligned data holding register
	// Position of DACC2DHR field.
	DAC_DHR8R2_DACC2DHR_Pos = 0x0
	// Bit mask of DACC2DHR field.
	DAC_DHR8R2_DACC2DHR_Msk = 0xff

	// DHR12RD: Dual DAC 12-bit right-aligned data holding register
	// Position of DACC1DHR field.
	DAC_DHR12RD_DACC1DHR_Pos = 0x0
	// Bit mask of DACC1DHR field.
	DAC_DHR12RD_DACC1DHR_Msk = 0xfff
	// Position of DACC2DHR field.
	DAC_DHR12RD_DACC2DHR_Pos = 0x10
	// Bit mask of DACC2DHR field.
	DAC_DHR12RD_DACC2DHR_Msk = 0xfff0000

	// DHR12LD: Dual DAC 12-bit left-aligned data holding register
	// Position of DACC1DHR field.
	DAC_DHR12LD_DACC1DHR_Pos = 0x4
	// Bit mask of DACC1DHR field.
	DAC_DHR12LD_DACC1DHR_Msk = 0xfff0
	// Position of DACC2DHR field.
	DAC_DHR12LD_DACC2DHR_Pos = 0x14
	// Bit mask of DACC2DHR field.
	DAC_DHR12LD_DACC2DHR_Msk = 0xfff00000

	// DHR8RD: Dual DAC 8-bit right-aligned data holding register
	// Position of DACC1DHR field.
	DAC_DHR8RD_DACC1DHR_Pos = 0x0
	// Bit mask of DACC1DHR field.
	DAC_DHR8RD_DACC1DHR_Msk = 0xff
	// Position of DACC2DHR field.
	DAC_DHR8RD_DACC2DHR_Pos = 0x8
	// Bit mask of DACC2DHR field.
	DAC_DHR8RD_DACC2DHR_Msk = 0xff00

	// DOR1: channel1 data output register
	// Position of DACC1DOR field.
	DAC_DOR1_DACC1DOR_Pos = 0x0
	// Bit mask of DACC1DOR field.
	DAC_DOR1_DACC1DOR_Msk = 0xfff

	// DOR2: channel2 data output register
	// Position of DACC2DOR field.
	DAC_DOR2_DACC2DOR_Pos = 0x0
	// Bit mask of DACC2DOR field.
	DAC_DOR2_DACC2DOR_Msk = 0xfff

	// SR: status register
	// Position of DMAUDR1 field.
	DAC_SR_DMAUDR1_Pos = 0xd
	// Bit mask of DMAUDR1 field.
	DAC_SR_DMAUDR1_Msk = 0x2000
	// Bit DMAUDR1.
	DAC_SR_DMAUDR1 = 0x2000
	// No DMA underrun error condition occurred for DAC channel X
	DAC_SR_DMAUDR1_NoUnderrun = 0x0
	// DMA underrun error condition occurred for DAC channel X
	DAC_SR_DMAUDR1_Underrun = 0x1
)

// Bitfields for DMA1: Direct memory access controller
const (
	// ISR: interrupt status register
	// Position of TEIF7 field.
	DMA_ISR_TEIF7_Pos = 0x1b
	// Bit mask of TEIF7 field.
	DMA_ISR_TEIF7_Msk = 0x8000000
	// Bit TEIF7.
	DMA_ISR_TEIF7 = 0x8000000
	// No transfer error
	DMA_ISR_TEIF7_NoError = 0x0
	// A transfer error has occured
	DMA_ISR_TEIF7_Error = 0x1
	// Position of HTIF7 field.
	DMA_ISR_HTIF7_Pos = 0x1a
	// Bit mask of HTIF7 field.
	DMA_ISR_HTIF7_Msk = 0x4000000
	// Bit HTIF7.
	DMA_ISR_HTIF7 = 0x4000000
	// No half transfer event
	DMA_ISR_HTIF7_NotHalf = 0x0
	// A half transfer event has occured
	DMA_ISR_HTIF7_Half = 0x1
	// Position of TCIF7 field.
	DMA_ISR_TCIF7_Pos = 0x19
	// Bit mask of TCIF7 field.
	DMA_ISR_TCIF7_Msk = 0x2000000
	// Bit TCIF7.
	DMA_ISR_TCIF7 = 0x2000000
	// No transfer complete event
	DMA_ISR_TCIF7_NotComplete = 0x0
	// A transfer complete event has occured
	DMA_ISR_TCIF7_Complete = 0x1
	// Position of GIF7 field.
	DMA_ISR_GIF7_Pos = 0x18
	// Bit mask of GIF7 field.
	DMA_ISR_GIF7_Msk = 0x1000000
	// Bit GIF7.
	DMA_ISR_GIF7 = 0x1000000
	// No transfer error, half event, complete event
	DMA_ISR_GIF7_NoEvent = 0x0
	// A transfer error, half event or complete event has occured
	DMA_ISR_GIF7_Event = 0x1
	// Position of TEIF6 field.
	DMA_ISR_TEIF6_Pos = 0x17
	// Bit mask of TEIF6 field.
	DMA_ISR_TEIF6_Msk = 0x800000
	// Bit TEIF6.
	DMA_ISR_TEIF6 = 0x800000
	// No transfer error
	DMA_ISR_TEIF6_NoError = 0x0
	// A transfer error has occured
	DMA_ISR_TEIF6_Error = 0x1
	// Position of HTIF6 field.
	DMA_ISR_HTIF6_Pos = 0x16
	// Bit mask of HTIF6 field.
	DMA_ISR_HTIF6_Msk = 0x400000
	// Bit HTIF6.
	DMA_ISR_HTIF6 = 0x400000
	// No half transfer event
	DMA_ISR_HTIF6_NotHalf = 0x0
	// A half transfer event has occured
	DMA_ISR_HTIF6_Half = 0x1
	// Position of TCIF6 field.
	DMA_ISR_TCIF6_Pos = 0x15
	// Bit mask of TCIF6 field.
	DMA_ISR_TCIF6_Msk = 0x200000
	// Bit TCIF6.
	DMA_ISR_TCIF6 = 0x200000
	// No transfer complete event
	DMA_ISR_TCIF6_NotComplete = 0x0
	// A transfer complete event has occured
	DMA_ISR_TCIF6_Complete = 0x1
	// Position of GIF6 field.
	DMA_ISR_GIF6_Pos = 0x14
	// Bit mask of GIF6 field.
	DMA_ISR_GIF6_Msk = 0x100000
	// Bit GIF6.
	DMA_ISR_GIF6 = 0x100000
	// No transfer error, half event, complete event
	DMA_ISR_GIF6_NoEvent = 0x0
	// A transfer error, half event or complete event has occured
	DMA_ISR_GIF6_Event = 0x1
	// Position of TEIF5 field.
	DMA_ISR_TEIF5_Pos = 0x13
	// Bit mask of TEIF5 field.
	DMA_ISR_TEIF5_Msk = 0x80000
	// Bit TEIF5.
	DMA_ISR_TEIF5 = 0x80000
	// No transfer error
	DMA_ISR_TEIF5_NoError = 0x0
	// A transfer error has occured
	DMA_ISR_TEIF5_Error = 0x1
	// Position of HTIF5 field.
	DMA_ISR_HTIF5_Pos = 0x12
	// Bit mask of HTIF5 field.
	DMA_ISR_HTIF5_Msk = 0x40000
	// Bit HTIF5.
	DMA_ISR_HTIF5 = 0x40000
	// No half transfer event
	DMA_ISR_HTIF5_NotHalf = 0x0
	// A half transfer event has occured
	DMA_ISR_HTIF5_Half = 0x1
	// Position of TCIF5 field.
	DMA_ISR_TCIF5_Pos = 0x11
	// Bit mask of TCIF5 field.
	DMA_ISR_TCIF5_Msk = 0x20000
	// Bit TCIF5.
	DMA_ISR_TCIF5 = 0x20000
	// No transfer complete event
	DMA_ISR_TCIF5_NotComplete = 0x0
	// A transfer complete event has occured
	DMA_ISR_TCIF5_Complete = 0x1
	// Position of GIF5 field.
	DMA_ISR_GIF5_Pos = 0x10
	// Bit mask of GIF5 field.
	DMA_ISR_GIF5_Msk = 0x10000
	// Bit GIF5.
	DMA_ISR_GIF5 = 0x10000
	// No transfer error, half event, complete event
	DMA_ISR_GIF5_NoEvent = 0x0
	// A transfer error, half event or complete event has occured
	DMA_ISR_GIF5_Event = 0x1
	// Position of TEIF4 field.
	DMA_ISR_TEIF4_Pos = 0xf
	// Bit mask of TEIF4 field.
	DMA_ISR_TEIF4_Msk = 0x8000
	// Bit TEIF4.
	DMA_ISR_TEIF4 = 0x8000
	// No transfer error
	DMA_ISR_TEIF4_NoError = 0x0
	// A transfer error has occured
	DMA_ISR_TEIF4_Error = 0x1
	// Position of HTIF4 field.
	DMA_ISR_HTIF4_Pos = 0xe
	// Bit mask of HTIF4 field.
	DMA_ISR_HTIF4_Msk = 0x4000
	// Bit HTIF4.
	DMA_ISR_HTIF4 = 0x4000
	// No half transfer event
	DMA_ISR_HTIF4_NotHalf = 0x0
	// A half transfer event has occured
	DMA_ISR_HTIF4_Half = 0x1
	// Position of TCIF4 field.
	DMA_ISR_TCIF4_Pos = 0xd
	// Bit mask of TCIF4 field.
	DMA_ISR_TCIF4_Msk = 0x2000
	// Bit TCIF4.
	DMA_ISR_TCIF4 = 0x2000
	// No transfer complete event
	DMA_ISR_TCIF4_NotComplete = 0x0
	// A transfer complete event has occured
	DMA_ISR_TCIF4_Complete = 0x1
	// Position of GIF4 field.
	DMA_ISR_GIF4_Pos = 0xc
	// Bit mask of GIF4 field.
	DMA_ISR_GIF4_Msk = 0x1000
	// Bit GIF4.
	DMA_ISR_GIF4 = 0x1000
	// No transfer error, half event, complete event
	DMA_ISR_GIF4_NoEvent = 0x0
	// A transfer error, half event or complete event has occured
	DMA_ISR_GIF4_Event = 0x1
	// Position of TEIF3 field.
	DMA_ISR_TEIF3_Pos = 0xb
	// Bit mask of TEIF3 field.
	DMA_ISR_TEIF3_Msk = 0x800
	// Bit TEIF3.
	DMA_ISR_TEIF3 = 0x800
	// No transfer error
	DMA_ISR_TEIF3_NoError = 0x0
	// A transfer error has occured
	DMA_ISR_TEIF3_Error = 0x1
	// Position of HTIF3 field.
	DMA_ISR_HTIF3_Pos = 0xa
	// Bit mask of HTIF3 field.
	DMA_ISR_HTIF3_Msk = 0x400
	// Bit HTIF3.
	DMA_ISR_HTIF3 = 0x400
	// No half transfer event
	DMA_ISR_HTIF3_NotHalf = 0x0
	// A half transfer event has occured
	DMA_ISR_HTIF3_Half = 0x1
	// Position of TCIF3 field.
	DMA_ISR_TCIF3_Pos = 0x9
	// Bit mask of TCIF3 field.
	DMA_ISR_TCIF3_Msk = 0x200
	// Bit TCIF3.
	DMA_ISR_TCIF3 = 0x200
	// No transfer complete event
	DMA_ISR_TCIF3_NotComplete = 0x0
	// A transfer complete event has occured
	DMA_ISR_TCIF3_Complete = 0x1
	// Position of GIF3 field.
	DMA_ISR_GIF3_Pos = 0x8
	// Bit mask of GIF3 field.
	DMA_ISR_GIF3_Msk = 0x100
	// Bit GIF3.
	DMA_ISR_GIF3 = 0x100
	// No transfer error, half event, complete event
	DMA_ISR_GIF3_NoEvent = 0x0
	// A transfer error, half event or complete event has occured
	DMA_ISR_GIF3_Event = 0x1
	// Position of TEIF2 field.
	DMA_ISR_TEIF2_Pos = 0x7
	// Bit mask of TEIF2 field.
	DMA_ISR_TEIF2_Msk = 0x80
	// Bit TEIF2.
	DMA_ISR_TEIF2 = 0x80
	// No transfer error
	DMA_ISR_TEIF2_NoError = 0x0
	// A transfer error has occured
	DMA_ISR_TEIF2_Error = 0x1
	// Position of HTIF2 field.
	DMA_ISR_HTIF2_Pos = 0x6
	// Bit mask of HTIF2 field.
	DMA_ISR_HTIF2_Msk = 0x40
	// Bit HTIF2.
	DMA_ISR_HTIF2 = 0x40
	// No half transfer event
	DMA_ISR_HTIF2_NotHalf = 0x0
	// A half transfer event has occured
	DMA_ISR_HTIF2_Half = 0x1
	// Position of TCIF2 field.
	DMA_ISR_TCIF2_Pos = 0x5
	// Bit mask of TCIF2 field.
	DMA_ISR_TCIF2_Msk = 0x20
	// Bit TCIF2.
	DMA_ISR_TCIF2 = 0x20
	// No transfer complete event
	DMA_ISR_TCIF2_NotComplete = 0x0
	// A transfer complete event has occured
	DMA_ISR_TCIF2_Complete = 0x1
	// Position of GIF2 field.
	DMA_ISR_GIF2_Pos = 0x4
	// Bit mask of GIF2 field.
	DMA_ISR_GIF2_Msk = 0x10
	// Bit GIF2.
	DMA_ISR_GIF2 = 0x10
	// No transfer error, half event, complete event
	DMA_ISR_GIF2_NoEvent = 0x0
	// A transfer error, half event or complete event has occured
	DMA_ISR_GIF2_Event = 0x1
	// Position of TEIF1 field.
	DMA_ISR_TEIF1_Pos = 0x3
	// Bit mask of TEIF1 field.
	DMA_ISR_TEIF1_Msk = 0x8
	// Bit TEIF1.
	DMA_ISR_TEIF1 = 0x8
	// No transfer error
	DMA_ISR_TEIF1_NoError = 0x0
	// A transfer error has occured
	DMA_ISR_TEIF1_Error = 0x1
	// Position of HTIF1 field.
	DMA_ISR_HTIF1_Pos = 0x2
	// Bit mask of HTIF1 field.
	DMA_ISR_HTIF1_Msk = 0x4
	// Bit HTIF1.
	DMA_ISR_HTIF1 = 0x4
	// No half transfer event
	DMA_ISR_HTIF1_NotHalf = 0x0
	// A half transfer event has occured
	DMA_ISR_HTIF1_Half = 0x1
	// Position of TCIF1 field.
	DMA_ISR_TCIF1_Pos = 0x1
	// Bit mask of TCIF1 field.
	DMA_ISR_TCIF1_Msk = 0x2
	// Bit TCIF1.
	DMA_ISR_TCIF1 = 0x2
	// No transfer complete event
	DMA_ISR_TCIF1_NotComplete = 0x0
	// A transfer complete event has occured
	DMA_ISR_TCIF1_Complete = 0x1
	// Position of GIF1 field.
	DMA_ISR_GIF1_Pos = 0x0
	// Bit mask of GIF1 field.
	DMA_ISR_GIF1_Msk = 0x1
	// Bit GIF1.
	DMA_ISR_GIF1 = 0x1
	// No transfer error, half event, complete event
	DMA_ISR_GIF1_NoEvent = 0x0
	// A transfer error, half event or complete event has occured
	DMA_ISR_GIF1_Event = 0x1

	// IFCR: interrupt flag clear register
	// Position of CTEIF7 field.
	DMA_IFCR_CTEIF7_Pos = 0x1b
	// Bit mask of CTEIF7 field.
	DMA_IFCR_CTEIF7_Msk = 0x8000000
	// Bit CTEIF7.
	DMA_IFCR_CTEIF7 = 0x8000000
	// Clears the TEIF flag in the ISR register
	DMA_IFCR_CTEIF7_Clear = 0x1
	// Position of CHTIF7 field.
	DMA_IFCR_CHTIF7_Pos = 0x1a
	// Bit mask of CHTIF7 field.
	DMA_IFCR_CHTIF7_Msk = 0x4000000
	// Bit CHTIF7.
	DMA_IFCR_CHTIF7 = 0x4000000
	// Clears the HTIF flag in the ISR register
	DMA_IFCR_CHTIF7_Clear = 0x1
	// Position of CTCIF7 field.
	DMA_IFCR_CTCIF7_Pos = 0x19
	// Bit mask of CTCIF7 field.
	DMA_IFCR_CTCIF7_Msk = 0x2000000
	// Bit CTCIF7.
	DMA_IFCR_CTCIF7 = 0x2000000
	// Clears the TCIF flag in the ISR register
	DMA_IFCR_CTCIF7_Clear = 0x1
	// Position of CGIF7 field.
	DMA_IFCR_CGIF7_Pos = 0x18
	// Bit mask of CGIF7 field.
	DMA_IFCR_CGIF7_Msk = 0x1000000
	// Bit CGIF7.
	DMA_IFCR_CGIF7 = 0x1000000
	// Clears the GIF, TEIF, HTIF, TCIF flags in the ISR register
	DMA_IFCR_CGIF7_Clear = 0x1
	// Position of CTEIF6 field.
	DMA_IFCR_CTEIF6_Pos = 0x17
	// Bit mask of CTEIF6 field.
	DMA_IFCR_CTEIF6_Msk = 0x800000
	// Bit CTEIF6.
	DMA_IFCR_CTEIF6 = 0x800000
	// Clears the TEIF flag in the ISR register
	DMA_IFCR_CTEIF6_Clear = 0x1
	// Position of CHTIF6 field.
	DMA_IFCR_CHTIF6_Pos = 0x16
	// Bit mask of CHTIF6 field.
	DMA_IFCR_CHTIF6_Msk = 0x400000
	// Bit CHTIF6.
	DMA_IFCR_CHTIF6 = 0x400000
	// Clears the HTIF flag in the ISR register
	DMA_IFCR_CHTIF6_Clear = 0x1
	// Position of CTCIF6 field.
	DMA_IFCR_CTCIF6_Pos = 0x15
	// Bit mask of CTCIF6 field.
	DMA_IFCR_CTCIF6_Msk = 0x200000
	// Bit CTCIF6.
	DMA_IFCR_CTCIF6 = 0x200000
	// Clears the TCIF flag in the ISR register
	DMA_IFCR_CTCIF6_Clear = 0x1
	// Position of CGIF6 field.
	DMA_IFCR_CGIF6_Pos = 0x14
	// Bit mask of CGIF6 field.
	DMA_IFCR_CGIF6_Msk = 0x100000
	// Bit CGIF6.
	DMA_IFCR_CGIF6 = 0x100000
	// Clears the GIF, TEIF, HTIF, TCIF flags in the ISR register
	DMA_IFCR_CGIF6_Clear = 0x1
	// Position of CTEIF5 field.
	DMA_IFCR_CTEIF5_Pos = 0x13
	// Bit mask of CTEIF5 field.
	DMA_IFCR_CTEIF5_Msk = 0x80000
	// Bit CTEIF5.
	DMA_IFCR_CTEIF5 = 0x80000
	// Clears the TEIF flag in the ISR register
	DMA_IFCR_CTEIF5_Clear = 0x1
	// Position of CHTIF5 field.
	DMA_IFCR_CHTIF5_Pos = 0x12
	// Bit mask of CHTIF5 field.
	DMA_IFCR_CHTIF5_Msk = 0x40000
	// Bit CHTIF5.
	DMA_IFCR_CHTIF5 = 0x40000
	// Clears the HTIF flag in the ISR register
	DMA_IFCR_CHTIF5_Clear = 0x1
	// Position of CTCIF5 field.
	DMA_IFCR_CTCIF5_Pos = 0x11
	// Bit mask of CTCIF5 field.
	DMA_IFCR_CTCIF5_Msk = 0x20000
	// Bit CTCIF5.
	DMA_IFCR_CTCIF5 = 0x20000
	// Clears the TCIF flag in the ISR register
	DMA_IFCR_CTCIF5_Clear = 0x1
	// Position of CGIF5 field.
	DMA_IFCR_CGIF5_Pos = 0x10
	// Bit mask of CGIF5 field.
	DMA_IFCR_CGIF5_Msk = 0x10000
	// Bit CGIF5.
	DMA_IFCR_CGIF5 = 0x10000
	// Clears the GIF, TEIF, HTIF, TCIF flags in the ISR register
	DMA_IFCR_CGIF5_Clear = 0x1
	// Position of CTEIF4 field.
	DMA_IFCR_CTEIF4_Pos = 0xf
	// Bit mask of CTEIF4 field.
	DMA_IFCR_CTEIF4_Msk = 0x8000
	// Bit CTEIF4.
	DMA_IFCR_CTEIF4 = 0x8000
	// Clears the TEIF flag in the ISR register
	DMA_IFCR_CTEIF4_Clear = 0x1
	// Position of CHTIF4 field.
	DMA_IFCR_CHTIF4_Pos = 0xe
	// Bit mask of CHTIF4 field.
	DMA_IFCR_CHTIF4_Msk = 0x4000
	// Bit CHTIF4.
	DMA_IFCR_CHTIF4 = 0x4000
	// Clears the HTIF flag in the ISR register
	DMA_IFCR_CHTIF4_Clear = 0x1
	// Position of CTCIF4 field.
	DMA_IFCR_CTCIF4_Pos = 0xd
	// Bit mask of CTCIF4 field.
	DMA_IFCR_CTCIF4_Msk = 0x2000
	// Bit CTCIF4.
	DMA_IFCR_CTCIF4 = 0x2000
	// Clears the TCIF flag in the ISR register
	DMA_IFCR_CTCIF4_Clear = 0x1
	// Position of CGIF4 field.
	DMA_IFCR_CGIF4_Pos = 0xc
	// Bit mask of CGIF4 field.
	DMA_IFCR_CGIF4_Msk = 0x1000
	// Bit CGIF4.
	DMA_IFCR_CGIF4 = 0x1000
	// Clears the GIF, TEIF, HTIF, TCIF flags in the ISR register
	DMA_IFCR_CGIF4_Clear = 0x1
	// Position of CTEIF3 field.
	DMA_IFCR_CTEIF3_Pos = 0xb
	// Bit mask of CTEIF3 field.
	DMA_IFCR_CTEIF3_Msk = 0x800
	// Bit CTEIF3.
	DMA_IFCR_CTEIF3 = 0x800
	// Clears the TEIF flag in the ISR register
	DMA_IFCR_CTEIF3_Clear = 0x1
	// Position of CHTIF3 field.
	DMA_IFCR_CHTIF3_Pos = 0xa
	// Bit mask of CHTIF3 field.
	DMA_IFCR_CHTIF3_Msk = 0x400
	// Bit CHTIF3.
	DMA_IFCR_CHTIF3 = 0x400
	// Clears the HTIF flag in the ISR register
	DMA_IFCR_CHTIF3_Clear = 0x1
	// Position of CTCIF3 field.
	DMA_IFCR_CTCIF3_Pos = 0x9
	// Bit mask of CTCIF3 field.
	DMA_IFCR_CTCIF3_Msk = 0x200
	// Bit CTCIF3.
	DMA_IFCR_CTCIF3 = 0x200
	// Clears the TCIF flag in the ISR register
	DMA_IFCR_CTCIF3_Clear = 0x1
	// Position of CGIF3 field.
	DMA_IFCR_CGIF3_Pos = 0x8
	// Bit mask of CGIF3 field.
	DMA_IFCR_CGIF3_Msk = 0x100
	// Bit CGIF3.
	DMA_IFCR_CGIF3 = 0x100
	// Clears the GIF, TEIF, HTIF, TCIF flags in the ISR register
	DMA_IFCR_CGIF3_Clear = 0x1
	// Position of CTEIF2 field.
	DMA_IFCR_CTEIF2_Pos = 0x7
	// Bit mask of CTEIF2 field.
	DMA_IFCR_CTEIF2_Msk = 0x80
	// Bit CTEIF2.
	DMA_IFCR_CTEIF2 = 0x80
	// Clears the TEIF flag in the ISR register
	DMA_IFCR_CTEIF2_Clear = 0x1
	// Position of CHTIF2 field.
	DMA_IFCR_CHTIF2_Pos = 0x6
	// Bit mask of CHTIF2 field.
	DMA_IFCR_CHTIF2_Msk = 0x40
	// Bit CHTIF2.
	DMA_IFCR_CHTIF2 = 0x40
	// Clears the HTIF flag in the ISR register
	DMA_IFCR_CHTIF2_Clear = 0x1
	// Position of CTCIF2 field.
	DMA_IFCR_CTCIF2_Pos = 0x5
	// Bit mask of CTCIF2 field.
	DMA_IFCR_CTCIF2_Msk = 0x20
	// Bit CTCIF2.
	DMA_IFCR_CTCIF2 = 0x20
	// Clears the TCIF flag in the ISR register
	DMA_IFCR_CTCIF2_Clear = 0x1
	// Position of CGIF2 field.
	DMA_IFCR_CGIF2_Pos = 0x4
	// Bit mask of CGIF2 field.
	DMA_IFCR_CGIF2_Msk = 0x10
	// Bit CGIF2.
	DMA_IFCR_CGIF2 = 0x10
	// Clears the GIF, TEIF, HTIF, TCIF flags in the ISR register
	DMA_IFCR_CGIF2_Clear = 0x1
	// Position of CTEIF1 field.
	DMA_IFCR_CTEIF1_Pos = 0x3
	// Bit mask of CTEIF1 field.
	DMA_IFCR_CTEIF1_Msk = 0x8
	// Bit CTEIF1.
	DMA_IFCR_CTEIF1 = 0x8
	// Clears the TEIF flag in the ISR register
	DMA_IFCR_CTEIF1_Clear = 0x1
	// Position of CHTIF1 field.
	DMA_IFCR_CHTIF1_Pos = 0x2
	// Bit mask of CHTIF1 field.
	DMA_IFCR_CHTIF1_Msk = 0x4
	// Bit CHTIF1.
	DMA_IFCR_CHTIF1 = 0x4
	// Clears the HTIF flag in the ISR register
	DMA_IFCR_CHTIF1_Clear = 0x1
	// Position of CTCIF1 field.
	DMA_IFCR_CTCIF1_Pos = 0x1
	// Bit mask of CTCIF1 field.
	DMA_IFCR_CTCIF1_Msk = 0x2
	// Bit CTCIF1.
	DMA_IFCR_CTCIF1 = 0x2
	// Clears the TCIF flag in the ISR register
	DMA_IFCR_CTCIF1_Clear = 0x1
	// Position of CGIF1 field.
	DMA_IFCR_CGIF1_Pos = 0x0
	// Bit mask of CGIF1 field.
	DMA_IFCR_CGIF1_Msk = 0x1
	// Bit CGIF1.
	DMA_IFCR_CGIF1 = 0x1
	// Clears the GIF, TEIF, HTIF, TCIF flags in the ISR register
	DMA_IFCR_CGIF1_Clear = 0x1

	// CH.CR: channel x configuration register
	// Position of MEM2MEM field.
	DMA_CH_CR_MEM2MEM_Pos = 0xe
	// Bit mask of MEM2MEM field.
	DMA_CH_CR_MEM2MEM_Msk = 0x4000
	// Bit MEM2MEM.
	DMA_CH_CR_MEM2MEM = 0x4000
	// Memory to memory mode disabled
	DMA_CH_CR_MEM2MEM_Disabled = 0x0
	// Memory to memory mode enabled
	DMA_CH_CR_MEM2MEM_Enabled = 0x1
	// Position of PL field.
	DMA_CH_CR_PL_Pos = 0xc
	// Bit mask of PL field.
	DMA_CH_CR_PL_Msk = 0x3000
	// Low priority
	DMA_CH_CR_PL_Low = 0x0
	// Medium priority
	DMA_CH_CR_PL_Medium = 0x1
	// High priority
	DMA_CH_CR_PL_High = 0x2
	// Very high priority
	DMA_CH_CR_PL_VeryHigh = 0x3
	// Position of MSIZE field.
	DMA_CH_CR_MSIZE_Pos = 0xa
	// Bit mask of MSIZE field.
	DMA_CH_CR_MSIZE_Msk = 0xc00
	// 8-bit size
	DMA_CH_CR_MSIZE_Bits8 = 0x0
	// 16-bit size
	DMA_CH_CR_MSIZE_Bits16 = 0x1
	// 32-bit size
	DMA_CH_CR_MSIZE_Bits32 = 0x2
	// Position of PSIZE field.
	DMA_CH_CR_PSIZE_Pos = 0x8
	// Bit mask of PSIZE field.
	DMA_CH_CR_PSIZE_Msk = 0x300
	// 8-bit size
	DMA_CH_CR_PSIZE_Bits8 = 0x0
	// 16-bit size
	DMA_CH_CR_PSIZE_Bits16 = 0x1
	// 32-bit size
	DMA_CH_CR_PSIZE_Bits32 = 0x2
	// Position of MINC field.
	DMA_CH_CR_MINC_Pos = 0x7
	// Bit mask of MINC field.
	DMA_CH_CR_MINC_Msk = 0x80
	// Bit MINC.
	DMA_CH_CR_MINC = 0x80
	// Increment mode disabled
	DMA_CH_CR_MINC_Disabled = 0x0
	// Increment mode enabled
	DMA_CH_CR_MINC_Enabled = 0x1
	// Position of PINC field.
	DMA_CH_CR_PINC_Pos = 0x6
	// Bit mask of PINC field.
	DMA_CH_CR_PINC_Msk = 0x40
	// Bit PINC.
	DMA_CH_CR_PINC = 0x40
	// Increment mode disabled
	DMA_CH_CR_PINC_Disabled = 0x0
	// Increment mode enabled
	DMA_CH_CR_PINC_Enabled = 0x1
	// Position of CIRC field.
	DMA_CH_CR_CIRC_Pos = 0x5
	// Bit mask of CIRC field.
	DMA_CH_CR_CIRC_Msk = 0x20
	// Bit CIRC.
	DMA_CH_CR_CIRC = 0x20
	// Circular buffer disabled
	DMA_CH_CR_CIRC_Disabled = 0x0
	// Circular buffer enabled
	DMA_CH_CR_CIRC_Enabled = 0x1
	// Position of DIR field.
	DMA_CH_CR_DIR_Pos = 0x4
	// Bit mask of DIR field.
	DMA_CH_CR_DIR_Msk = 0x10
	// Bit DIR.
	DMA_CH_CR_DIR = 0x10
	// Read from peripheral
	DMA_CH_CR_DIR_FromPeripheral = 0x0
	// Read from memory
	DMA_CH_CR_DIR_FromMemory = 0x1
	// Position of TEIE field.
	DMA_CH_CR_TEIE_Pos = 0x3
	// Bit mask of TEIE field.
	DMA_CH_CR_TEIE_Msk = 0x8
	// Bit TEIE.
	DMA_CH_CR_TEIE = 0x8
	// Transfer Error interrupt disabled
	DMA_CH_CR_TEIE_Disabled = 0x0
	// Transfer Error interrupt enabled
	DMA_CH_CR_TEIE_Enabled = 0x1
	// Position of HTIE field.
	DMA_CH_CR_HTIE_Pos = 0x2
	// Bit mask of HTIE field.
	DMA_CH_CR_HTIE_Msk = 0x4
	// Bit HTIE.
	DMA_CH_CR_HTIE = 0x4
	// Half Transfer interrupt disabled
	DMA_CH_CR_HTIE_Disabled = 0x0
	// Half Transfer interrupt enabled
	DMA_CH_CR_HTIE_Enabled = 0x1
	// Position of TCIE field.
	DMA_CH_CR_TCIE_Pos = 0x1
	// Bit mask of TCIE field.
	DMA_CH_CR_TCIE_Msk = 0x2
	// Bit TCIE.
	DMA_CH_CR_TCIE = 0x2
	// Transfer Complete interrupt disabled
	DMA_CH_CR_TCIE_Disabled = 0x0
	// Transfer Complete interrupt enabled
	DMA_CH_CR_TCIE_Enabled = 0x1
	// Position of EN field.
	DMA_CH_CR_EN_Pos = 0x0
	// Bit mask of EN field.
	DMA_CH_CR_EN_Msk = 0x1
	// Bit EN.
	DMA_CH_CR_EN = 0x1
	// Channel disabled
	DMA_CH_CR_EN_Disabled = 0x0
	// Channel enabled
	DMA_CH_CR_EN_Enabled = 0x1

	// CH.NDTR: channel x number of data register
	// Position of NDT field.
	DMA_CH_NDTR_NDT_Pos = 0x0
	// Bit mask of NDT field.
	DMA_CH_NDTR_NDT_Msk = 0xffff

	// CH.PAR: channel x peripheral address register
	// Position of PA field.
	DMA_CH_PAR_PA_Pos = 0x0
	// Bit mask of PA field.
	DMA_CH_PAR_PA_Msk = 0xffffffff

	// CH.MAR: channel x memory address register
	// Position of MA field.
	DMA_CH_MAR_MA_Pos = 0x0
	// Bit mask of MA field.
	DMA_CH_MAR_MA_Msk = 0xffffffff

	// CSELR: channel selection register
	// Position of C7S field.
	DMA_CSELR_C7S_Pos = 0x18
	// Bit mask of C7S field.
	DMA_CSELR_C7S_Msk = 0xf000000
	// Default mapping
	DMA_CSELR_C7S_NoMapping = 0x0
	// Mapping 1
	DMA_CSELR_C7S_Map1 = 0x1
	// Mapping 2
	DMA_CSELR_C7S_Map2 = 0x2
	// Mapping 3
	DMA_CSELR_C7S_Map3 = 0x3
	// Mapping 4
	DMA_CSELR_C7S_Map4 = 0x4
	// Mapping 5
	DMA_CSELR_C7S_Map5 = 0x5
	// Mapping 6
	DMA_CSELR_C7S_Map6 = 0x6
	// Mapping 7
	DMA_CSELR_C7S_Map7 = 0x7
	// Mapping 8
	DMA_CSELR_C7S_Map8 = 0x8
	// Mapping 9
	DMA_CSELR_C7S_Map9 = 0x9
	// Mapping 10
	DMA_CSELR_C7S_Map10 = 0xa
	// Mapping 11
	DMA_CSELR_C7S_Map11 = 0xb
	// Mapping 12
	DMA_CSELR_C7S_Map12 = 0xc
	// Mapping 13
	DMA_CSELR_C7S_Map13 = 0xd
	// Mapping 14
	DMA_CSELR_C7S_Map14 = 0xe
	// Mapping 15
	DMA_CSELR_C7S_Map15 = 0xf
	// Position of C6S field.
	DMA_CSELR_C6S_Pos = 0x14
	// Bit mask of C6S field.
	DMA_CSELR_C6S_Msk = 0xf00000
	// Default mapping
	DMA_CSELR_C6S_NoMapping = 0x0
	// Mapping 1
	DMA_CSELR_C6S_Map1 = 0x1
	// Mapping 2
	DMA_CSELR_C6S_Map2 = 0x2
	// Mapping 3
	DMA_CSELR_C6S_Map3 = 0x3
	// Mapping 4
	DMA_CSELR_C6S_Map4 = 0x4
	// Mapping 5
	DMA_CSELR_C6S_Map5 = 0x5
	// Mapping 6
	DMA_CSELR_C6S_Map6 = 0x6
	// Mapping 7
	DMA_CSELR_C6S_Map7 = 0x7
	// Mapping 8
	DMA_CSELR_C6S_Map8 = 0x8
	// Mapping 9
	DMA_CSELR_C6S_Map9 = 0x9
	// Mapping 10
	DMA_CSELR_C6S_Map10 = 0xa
	// Mapping 11
	DMA_CSELR_C6S_Map11 = 0xb
	// Mapping 12
	DMA_CSELR_C6S_Map12 = 0xc
	// Mapping 13
	DMA_CSELR_C6S_Map13 = 0xd
	// Mapping 14
	DMA_CSELR_C6S_Map14 = 0xe
	// Mapping 15
	DMA_CSELR_C6S_Map15 = 0xf
	// Position of C5S field.
	DMA_CSELR_C5S_Pos = 0x10
	// Bit mask of C5S field.
	DMA_CSELR_C5S_Msk = 0xf0000
	// Default mapping
	DMA_CSELR_C5S_NoMapping = 0x0
	// Mapping 1
	DMA_CSELR_C5S_Map1 = 0x1
	// Mapping 2
	DMA_CSELR_C5S_Map2 = 0x2
	// Mapping 3
	DMA_CSELR_C5S_Map3 = 0x3
	// Mapping 4
	DMA_CSELR_C5S_Map4 = 0x4
	// Mapping 5
	DMA_CSELR_C5S_Map5 = 0x5
	// Mapping 6
	DMA_CSELR_C5S_Map6 = 0x6
	// Mapping 7
	DMA_CSELR_C5S_Map7 = 0x7
	// Mapping 8
	DMA_CSELR_C5S_Map8 = 0x8
	// Mapping 9
	DMA_CSELR_C5S_Map9 = 0x9
	// Mapping 10
	DMA_CSELR_C5S_Map10 = 0xa
	// Mapping 11
	DMA_CSELR_C5S_Map11 = 0xb
	// Mapping 12
	DMA_CSELR_C5S_Map12 = 0xc
	// Mapping 13
	DMA_CSELR_C5S_Map13 = 0xd
	// Mapping 14
	DMA_CSELR_C5S_Map14 = 0xe
	// Mapping 15
	DMA_CSELR_C5S_Map15 = 0xf
	// Position of C4S field.
	DMA_CSELR_C4S_Pos = 0xc
	// Bit mask of C4S field.
	DMA_CSELR_C4S_Msk = 0xf000
	// Default mapping
	DMA_CSELR_C4S_NoMapping = 0x0
	// Mapping 1
	DMA_CSELR_C4S_Map1 = 0x1
	// Mapping 2
	DMA_CSELR_C4S_Map2 = 0x2
	// Mapping 3
	DMA_CSELR_C4S_Map3 = 0x3
	// Mapping 4
	DMA_CSELR_C4S_Map4 = 0x4
	// Mapping 5
	DMA_CSELR_C4S_Map5 = 0x5
	// Mapping 6
	DMA_CSELR_C4S_Map6 = 0x6
	// Mapping 7
	DMA_CSELR_C4S_Map7 = 0x7
	// Mapping 8
	DMA_CSELR_C4S_Map8 = 0x8
	// Mapping 9
	DMA_CSELR_C4S_Map9 = 0x9
	// Mapping 10
	DMA_CSELR_C4S_Map10 = 0xa
	// Mapping 11
	DMA_CSELR_C4S_Map11 = 0xb
	// Mapping 12
	DMA_CSELR_C4S_Map12 = 0xc
	// Mapping 13
	DMA_CSELR_C4S_Map13 = 0xd
	// Mapping 14
	DMA_CSELR_C4S_Map14 = 0xe
	// Mapping 15
	DMA_CSELR_C4S_Map15 = 0xf
	// Position of C3S field.
	DMA_CSELR_C3S_Pos = 0x8
	// Bit mask of C3S field.
	DMA_CSELR_C3S_Msk = 0xf00
	// Default mapping
	DMA_CSELR_C3S_NoMapping = 0x0
	// Mapping 1
	DMA_CSELR_C3S_Map1 = 0x1
	// Mapping 2
	DMA_CSELR_C3S_Map2 = 0x2
	// Mapping 3
	DMA_CSELR_C3S_Map3 = 0x3
	// Mapping 4
	DMA_CSELR_C3S_Map4 = 0x4
	// Mapping 5
	DMA_CSELR_C3S_Map5 = 0x5
	// Mapping 6
	DMA_CSELR_C3S_Map6 = 0x6
	// Mapping 7
	DMA_CSELR_C3S_Map7 = 0x7
	// Mapping 8
	DMA_CSELR_C3S_Map8 = 0x8
	// Mapping 9
	DMA_CSELR_C3S_Map9 = 0x9
	// Mapping 10
	DMA_CSELR_C3S_Map10 = 0xa
	// Mapping 11
	DMA_CSELR_C3S_Map11 = 0xb
	// Mapping 12
	DMA_CSELR_C3S_Map12 = 0xc
	// Mapping 13
	DMA_CSELR_C3S_Map13 = 0xd
	// Mapping 14
	DMA_CSELR_C3S_Map14 = 0xe
	// Mapping 15
	DMA_CSELR_C3S_Map15 = 0xf
	// Position of C2S field.
	DMA_CSELR_C2S_Pos = 0x4
	// Bit mask of C2S field.
	DMA_CSELR_C2S_Msk = 0xf0
	// Default mapping
	DMA_CSELR_C2S_NoMapping = 0x0
	// Mapping 1
	DMA_CSELR_C2S_Map1 = 0x1
	// Mapping 2
	DMA_CSELR_C2S_Map2 = 0x2
	// Mapping 3
	DMA_CSELR_C2S_Map3 = 0x3
	// Mapping 4
	DMA_CSELR_C2S_Map4 = 0x4
	// Mapping 5
	DMA_CSELR_C2S_Map5 = 0x5
	// Mapping 6
	DMA_CSELR_C2S_Map6 = 0x6
	// Mapping 7
	DMA_CSELR_C2S_Map7 = 0x7
	// Mapping 8
	DMA_CSELR_C2S_Map8 = 0x8
	// Mapping 9
	DMA_CSELR_C2S_Map9 = 0x9
	// Mapping 10
	DMA_CSELR_C2S_Map10 = 0xa
	// Mapping 11
	DMA_CSELR_C2S_Map11 = 0xb
	// Mapping 12
	DMA_CSELR_C2S_Map12 = 0xc
	// Mapping 13
	DMA_CSELR_C2S_Map13 = 0xd
	// Mapping 14
	DMA_CSELR_C2S_Map14 = 0xe
	// Mapping 15
	DMA_CSELR_C2S_Map15 = 0xf
	// Position of C1S field.
	DMA_CSELR_C1S_Pos = 0x0
	// Bit mask of C1S field.
	DMA_CSELR_C1S_Msk = 0xf
	// Default mapping
	DMA_CSELR_C1S_NoMapping = 0x0
	// Mapping 1
	DMA_CSELR_C1S_Map1 = 0x1
	// Mapping 2
	DMA_CSELR_C1S_Map2 = 0x2
	// Mapping 3
	DMA_CSELR_C1S_Map3 = 0x3
	// Mapping 4
	DMA_CSELR_C1S_Map4 = 0x4
	// Mapping 5
	DMA_CSELR_C1S_Map5 = 0x5
	// Mapping 6
	DMA_CSELR_C1S_Map6 = 0x6
	// Mapping 7
	DMA_CSELR_C1S_Map7 = 0x7
	// Mapping 8
	DMA_CSELR_C1S_Map8 = 0x8
	// Mapping 9
	DMA_CSELR_C1S_Map9 = 0x9
	// Mapping 10
	DMA_CSELR_C1S_Map10 = 0xa
	// Mapping 11
	DMA_CSELR_C1S_Map11 = 0xb
	// Mapping 12
	DMA_CSELR_C1S_Map12 = 0xc
	// Mapping 13
	DMA_CSELR_C1S_Map13 = 0xd
	// Mapping 14
	DMA_CSELR_C1S_Map14 = 0xe
	// Mapping 15
	DMA_CSELR_C1S_Map15 = 0xf
)

// Bitfields for CRC: Cyclic redundancy check calculation unit
const (
	// DR: Data register
	// Position of DR field.
	CRC_DR_DR_Pos = 0x0
	// Bit mask of DR field.
	CRC_DR_DR_Msk = 0xffffffff

	// DR8: Data register - byte sized
	// Position of DR8 field.
	CRC_DR8_DR8_Pos = 0x0
	// Bit mask of DR8 field.
	CRC_DR8_DR8_Msk = 0xff

	// DR16: Data register - half-word sized
	// Position of DR16 field.
	CRC_DR16_DR16_Pos = 0x0
	// Bit mask of DR16 field.
	CRC_DR16_DR16_Msk = 0xffff

	// IDR: Independent data register
	// Position of IDR field.
	CRC_IDR_IDR_Pos = 0x0
	// Bit mask of IDR field.
	CRC_IDR_IDR_Msk = 0xff

	// CR: Control register
	// Position of REV_OUT field.
	CRC_CR_REV_OUT_Pos = 0x7
	// Bit mask of REV_OUT field.
	CRC_CR_REV_OUT_Msk = 0x80
	// Bit REV_OUT.
	CRC_CR_REV_OUT = 0x80
	// Bit order not affected
	CRC_CR_REV_OUT_Normal = 0x0
	// Bit reversed output
	CRC_CR_REV_OUT_Reversed = 0x1
	// Position of REV_IN field.
	CRC_CR_REV_IN_Pos = 0x5
	// Bit mask of REV_IN field.
	CRC_CR_REV_IN_Msk = 0x60
	// Bit order not affected
	CRC_CR_REV_IN_Normal = 0x0
	// Bit reversal done by byte
	CRC_CR_REV_IN_Byte = 0x1
	// Bit reversal done by half-word
	CRC_CR_REV_IN_HalfWord = 0x2
	// Bit reversal done by word
	CRC_CR_REV_IN_Word = 0x3
	// Position of POLYSIZE field.
	CRC_CR_POLYSIZE_Pos = 0x3
	// Bit mask of POLYSIZE field.
	CRC_CR_POLYSIZE_Msk = 0x18
	// 32-bit polynomial
	CRC_CR_POLYSIZE_Polysize32 = 0x0
	// 16-bit polynomial
	CRC_CR_POLYSIZE_Polysize16 = 0x1
	// 8-bit polynomial
	CRC_CR_POLYSIZE_Polysize8 = 0x2
	// 7-bit polynomial
	CRC_CR_POLYSIZE_Polysize7 = 0x3
	// Position of RESET field.
	CRC_CR_RESET_Pos = 0x0
	// Bit mask of RESET field.
	CRC_CR_RESET_Msk = 0x1
	// Bit RESET.
	CRC_CR_RESET = 0x1
	// Resets the CRC calculation unit and sets the data register to 0xFFFF FFFF
	CRC_CR_RESET_Reset = 0x1

	// INIT: Initial CRC value
	// Position of INIT field.
	CRC_INIT_INIT_Pos = 0x0
	// Bit mask of INIT field.
	CRC_INIT_INIT_Msk = 0xffffffff

	// POL: polynomial
	// Position of POL field.
	CRC_POL_POL_Pos = 0x0
	// Bit mask of POL field.
	CRC_POL_POL_Msk = 0xffffffff
)

// Bitfields for GPIOA: General-purpose I/Os
const (
	// MODER: GPIO port mode register
	// Position of MODE0 field.
	GPIO_MODER_MODE0_Pos = 0x0
	// Bit mask of MODE0 field.
	GPIO_MODER_MODE0_Msk = 0x3
	// Input mode (reset state)
	GPIO_MODER_MODE0_Input = 0x0
	// General purpose output mode
	GPIO_MODER_MODE0_Output = 0x1
	// Alternate function mode
	GPIO_MODER_MODE0_Alternate = 0x2
	// Analog mode
	GPIO_MODER_MODE0_Analog = 0x3
	// Position of MODE1 field.
	GPIO_MODER_MODE1_Pos = 0x2
	// Bit mask of MODE1 field.
	GPIO_MODER_MODE1_Msk = 0xc
	// Input mode (reset state)
	GPIO_MODER_MODE1_Input = 0x0
	// General purpose output mode
	GPIO_MODER_MODE1_Output = 0x1
	// Alternate function mode
	GPIO_MODER_MODE1_Alternate = 0x2
	// Analog mode
	GPIO_MODER_MODE1_Analog = 0x3
	// Position of MODE2 field.
	GPIO_MODER_MODE2_Pos = 0x4
	// Bit mask of MODE2 field.
	GPIO_MODER_MODE2_Msk = 0x30
	// Input mode (reset state)
	GPIO_MODER_MODE2_Input = 0x0
	// General purpose output mode
	GPIO_MODER_MODE2_Output = 0x1
	// Alternate function mode
	GPIO_MODER_MODE2_Alternate = 0x2
	// Analog mode
	GPIO_MODER_MODE2_Analog = 0x3
	// Position of MODE3 field.
	GPIO_MODER_MODE3_Pos = 0x6
	// Bit mask of MODE3 field.
	GPIO_MODER_MODE3_Msk = 0xc0
	// Input mode (reset state)
	GPIO_MODER_MODE3_Input = 0x0
	// General purpose output mode
	GPIO_MODER_MODE3_Output = 0x1
	// Alternate function mode
	GPIO_MODER_MODE3_Alternate = 0x2
	// Analog mode
	GPIO_MODER_MODE3_Analog = 0x3
	// Position of MODE4 field.
	GPIO_MODER_MODE4_Pos = 0x8
	// Bit mask of MODE4 field.
	GPIO_MODER_MODE4_Msk = 0x300
	// Input mode (reset state)
	GPIO_MODER_MODE4_Input = 0x0
	// General purpose output mode
	GPIO_MODER_MODE4_Output = 0x1
	// Alternate function mode
	GPIO_MODER_MODE4_Alternate = 0x2
	// Analog mode
	GPIO_MODER_MODE4_Analog = 0x3
	// Position of MODE5 field.
	GPIO_MODER_MODE5_Pos = 0xa
	// Bit mask of MODE5 field.
	GPIO_MODER_MODE5_Msk = 0xc00
	// Input mode (reset state)
	GPIO_MODER_MODE5_Input = 0x0
	// General purpose output mode
	GPIO_MODER_MODE5_Output = 0x1
	// Alternate function mode
	GPIO_MODER_MODE5_Alternate = 0x2
	// Analog mode
	GPIO_MODER_MODE5_Analog = 0x3
	// Position of MODE6 field.
	GPIO_MODER_MODE6_Pos = 0xc
	// Bit mask of MODE6 field.
	GPIO_MODER_MODE6_Msk = 0x3000
	// Input mode (reset state)
	GPIO_MODER_MODE6_Input = 0x0
	// General purpose output mode
	GPIO_MODER_MODE6_Output = 0x1
	// Alternate function mode
	GPIO_MODER_MODE6_Alternate = 0x2
	// Analog mode
	GPIO_MODER_MODE6_Analog = 0x3
	// Position of MODE7 field.
	GPIO_MODER_MODE7_Pos = 0xe
	// Bit mask of MODE7 field.
	GPIO_MODER_MODE7_Msk = 0xc000
	// Input mode (reset state)
	GPIO_MODER_MODE7_Input = 0x0
	// General purpose output mode
	GPIO_MODER_MODE7_Output = 0x1
	// Alternate function mode
	GPIO_MODER_MODE7_Alternate = 0x2
	// Analog mode
	GPIO_MODER_MODE7_Analog = 0x3
	// Position of MODE8 field.
	GPIO_MODER_MODE8_Pos = 0x10
	// Bit mask of MODE8 field.
	GPIO_MODER_MODE8_Msk = 0x30000
	// Input mode (reset state)
	GPIO_MODER_MODE8_Input = 0x0
	// General purpose output mode
	GPIO_MODER_MODE8_Output = 0x1
	// Alternate function mode
	GPIO_MODER_MODE8_Alternate = 0x2
	// Analog mode
	GPIO_MODER_MODE8_Analog = 0x3
	// Position of MODE9 field.
	GPIO_MODER_MODE9_Pos = 0x12
	// Bit mask of MODE9 field.
	GPIO_MODER_MODE9_Msk = 0xc0000
	// Input mode (reset state)
	GPIO_MODER_MODE9_Input = 0x0
	// General purpose output mode
	GPIO_MODER_MODE9_Output = 0x1
	// Alternate function mode
	GPIO_MODER_MODE9_Alternate = 0x2
	// Analog mode
	GPIO_MODER_MODE9_Analog = 0x3
	// Position of MODE10 field.
	GPIO_MODER_MODE10_Pos = 0x14
	// Bit mask of MODE10 field.
	GPIO_MODER_MODE10_Msk = 0x300000
	// Input mode (reset state)
	GPIO_MODER_MODE10_Input = 0x0
	// General purpose output mode
	GPIO_MODER_MODE10_Output = 0x1
	// Alternate function mode
	GPIO_MODER_MODE10_Alternate = 0x2
	// Analog mode
	GPIO_MODER_MODE10_Analog = 0x3
	// Position of MODE11 field.
	GPIO_MODER_MODE11_Pos = 0x16
	// Bit mask of MODE11 field.
	GPIO_MODER_MODE11_Msk = 0xc00000
	// Input mode (reset state)
	GPIO_MODER_MODE11_Input = 0x0
	// General purpose output mode
	GPIO_MODER_MODE11_Output = 0x1
	// Alternate function mode
	GPIO_MODER_MODE11_Alternate = 0x2
	// Analog mode
	GPIO_MODER_MODE11_Analog = 0x3
	// Position of MODE12 field.
	GPIO_MODER_MODE12_Pos = 0x18
	// Bit mask of MODE12 field.
	GPIO_MODER_MODE12_Msk = 0x3000000
	// Input mode (reset state)
	GPIO_MODER_MODE12_Input = 0x0
	// General purpose output mode
	GPIO_MODER_MODE12_Output = 0x1
	// Alternate function mode
	GPIO_MODER_MODE12_Alternate = 0x2
	// Analog mode
	GPIO_MODER_MODE12_Analog = 0x3
	// Position of MODE13 field.
	GPIO_MODER_MODE13_Pos = 0x1a
	// Bit mask of MODE13 field.
	GPIO_MODER_MODE13_Msk = 0xc000000
	// Input mode (reset state)
	GPIO_MODER_MODE13_Input = 0x0
	// General purpose output mode
	GPIO_MODER_MODE13_Output = 0x1
	// Alternate function mode
	GPIO_MODER_MODE13_Alternate = 0x2
	// Analog mode
	GPIO_MODER_MODE13_Analog = 0x3
	// Position of MODE14 field.
	GPIO_MODER_MODE14_Pos = 0x1c
	// Bit mask of MODE14 field.
	GPIO_MODER_MODE14_Msk = 0x30000000
	// Input mode (reset state)
	GPIO_MODER_MODE14_Input = 0x0
	// General purpose output mode
	GPIO_MODER_MODE14_Output = 0x1
	// Alternate function mode
	GPIO_MODER_MODE14_Alternate = 0x2
	// Analog mode
	GPIO_MODER_MODE14_Analog = 0x3
	// Position of MODE15 field.
	GPIO_MODER_MODE15_Pos = 0x1e
	// Bit mask of MODE15 field.
	GPIO_MODER_MODE15_Msk = 0xc0000000
	// Input mode (reset state)
	GPIO_MODER_MODE15_Input = 0x0
	// General purpose output mode
	GPIO_MODER_MODE15_Output = 0x1
	// Alternate function mode
	GPIO_MODER_MODE15_Alternate = 0x2
	// Analog mode
	GPIO_MODER_MODE15_Analog = 0x3

	// OTYPER: GPIO port output type register
	// Position of OT15 field.
	GPIO_OTYPER_OT15_Pos = 0xf
	// Bit mask of OT15 field.
	GPIO_OTYPER_OT15_Msk = 0x8000
	// Bit OT15.
	GPIO_OTYPER_OT15 = 0x8000
	// Output push-pull (reset state)
	GPIO_OTYPER_OT15_PushPull = 0x0
	// Output open-drain
	GPIO_OTYPER_OT15_OpenDrain = 0x1
	// Position of OT14 field.
	GPIO_OTYPER_OT14_Pos = 0xe
	// Bit mask of OT14 field.
	GPIO_OTYPER_OT14_Msk = 0x4000
	// Bit OT14.
	GPIO_OTYPER_OT14 = 0x4000
	// Output push-pull (reset state)
	GPIO_OTYPER_OT14_PushPull = 0x0
	// Output open-drain
	GPIO_OTYPER_OT14_OpenDrain = 0x1
	// Position of OT13 field.
	GPIO_OTYPER_OT13_Pos = 0xd
	// Bit mask of OT13 field.
	GPIO_OTYPER_OT13_Msk = 0x2000
	// Bit OT13.
	GPIO_OTYPER_OT13 = 0x2000
	// Output push-pull (reset state)
	GPIO_OTYPER_OT13_PushPull = 0x0
	// Output open-drain
	GPIO_OTYPER_OT13_OpenDrain = 0x1
	// Position of OT12 field.
	GPIO_OTYPER_OT12_Pos = 0xc
	// Bit mask of OT12 field.
	GPIO_OTYPER_OT12_Msk = 0x1000
	// Bit OT12.
	GPIO_OTYPER_OT12 = 0x1000
	// Output push-pull (reset state)
	GPIO_OTYPER_OT12_PushPull = 0x0
	// Output open-drain
	GPIO_OTYPER_OT12_OpenDrain = 0x1
	// Position of OT11 field.
	GPIO_OTYPER_OT11_Pos = 0xb
	// Bit mask of OT11 field.
	GPIO_OTYPER_OT11_Msk = 0x800
	// Bit OT11.
	GPIO_OTYPER_OT11 = 0x800
	// Output push-pull (reset state)
	GPIO_OTYPER_OT11_PushPull = 0x0
	// Output open-drain
	GPIO_OTYPER_OT11_OpenDrain = 0x1
	// Position of OT10 field.
	GPIO_OTYPER_OT10_Pos = 0xa
	// Bit mask of OT10 field.
	GPIO_OTYPER_OT10_Msk = 0x400
	// Bit OT10.
	GPIO_OTYPER_OT10 = 0x400
	// Output push-pull (reset state)
	GPIO_OTYPER_OT10_PushPull = 0x0
	// Output open-drain
	GPIO_OTYPER_OT10_OpenDrain = 0x1
	// Position of OT9 field.
	GPIO_OTYPER_OT9_Pos = 0x9
	// Bit mask of OT9 field.
	GPIO_OTYPER_OT9_Msk = 0x200
	// Bit OT9.
	GPIO_OTYPER_OT9 = 0x200
	// Output push-pull (reset state)
	GPIO_OTYPER_OT9_PushPull = 0x0
	// Output open-drain
	GPIO_OTYPER_OT9_OpenDrain = 0x1
	// Position of OT8 field.
	GPIO_OTYPER_OT8_Pos = 0x8
	// Bit mask of OT8 field.
	GPIO_OTYPER_OT8_Msk = 0x100
	// Bit OT8.
	GPIO_OTYPER_OT8 = 0x100
	// Output push-pull (reset state)
	GPIO_OTYPER_OT8_PushPull = 0x0
	// Output open-drain
	GPIO_OTYPER_OT8_OpenDrain = 0x1
	// Position of OT7 field.
	GPIO_OTYPER_OT7_Pos = 0x7
	// Bit mask of OT7 field.
	GPIO_OTYPER_OT7_Msk = 0x80
	// Bit OT7.
	GPIO_OTYPER_OT7 = 0x80
	// Output push-pull (reset state)
	GPIO_OTYPER_OT7_PushPull = 0x0
	// Output open-drain
	GPIO_OTYPER_OT7_OpenDrain = 0x1
	// Position of OT6 field.
	GPIO_OTYPER_OT6_Pos = 0x6
	// Bit mask of OT6 field.
	GPIO_OTYPER_OT6_Msk = 0x40
	// Bit OT6.
	GPIO_OTYPER_OT6 = 0x40
	// Output push-pull (reset state)
	GPIO_OTYPER_OT6_PushPull = 0x0
	// Output open-drain
	GPIO_OTYPER_OT6_OpenDrain = 0x1
	// Position of OT5 field.
	GPIO_OTYPER_OT5_Pos = 0x5
	// Bit mask of OT5 field.
	GPIO_OTYPER_OT5_Msk = 0x20
	// Bit OT5.
	GPIO_OTYPER_OT5 = 0x20
	// Output push-pull (reset state)
	GPIO_OTYPER_OT5_PushPull = 0x0
	// Output open-drain
	GPIO_OTYPER_OT5_OpenDrain = 0x1
	// Position of OT4 field.
	GPIO_OTYPER_OT4_Pos = 0x4
	// Bit mask of OT4 field.
	GPIO_OTYPER_OT4_Msk = 0x10
	// Bit OT4.
	GPIO_OTYPER_OT4 = 0x10
	// Output push-pull (reset state)
	GPIO_OTYPER_OT4_PushPull = 0x0
	// Output open-drain
	GPIO_OTYPER_OT4_OpenDrain = 0x1
	// Position of OT3 field.
	GPIO_OTYPER_OT3_Pos = 0x3
	// Bit mask of OT3 field.
	GPIO_OTYPER_OT3_Msk = 0x8
	// Bit OT3.
	GPIO_OTYPER_OT3 = 0x8
	// Output push-pull (reset state)
	GPIO_OTYPER_OT3_PushPull = 0x0
	// Output open-drain
	GPIO_OTYPER_OT3_OpenDrain = 0x1
	// Position of OT2 field.
	GPIO_OTYPER_OT2_Pos = 0x2
	// Bit mask of OT2 field.
	GPIO_OTYPER_OT2_Msk = 0x4
	// Bit OT2.
	GPIO_OTYPER_OT2 = 0x4
	// Output push-pull (reset state)
	GPIO_OTYPER_OT2_PushPull = 0x0
	// Output open-drain
	GPIO_OTYPER_OT2_OpenDrain = 0x1
	// Position of OT1 field.
	GPIO_OTYPER_OT1_Pos = 0x1
	// Bit mask of OT1 field.
	GPIO_OTYPER_OT1_Msk = 0x2
	// Bit OT1.
	GPIO_OTYPER_OT1 = 0x2
	// Output push-pull (reset state)
	GPIO_OTYPER_OT1_PushPull = 0x0
	// Output open-drain
	GPIO_OTYPER_OT1_OpenDrain = 0x1
	// Position of OT0 field.
	GPIO_OTYPER_OT0_Pos = 0x0
	// Bit mask of OT0 field.
	GPIO_OTYPER_OT0_Msk = 0x1
	// Bit OT0.
	GPIO_OTYPER_OT0 = 0x1
	// Output push-pull (reset state)
	GPIO_OTYPER_OT0_PushPull = 0x0
	// Output open-drain
	GPIO_OTYPER_OT0_OpenDrain = 0x1

	// OSPEEDR: GPIO port output speed register
	// Position of OSPEED15 field.
	GPIO_OSPEEDR_OSPEED15_Pos = 0x1e
	// Bit mask of OSPEED15 field.
	GPIO_OSPEEDR_OSPEED15_Msk = 0xc0000000
	// Low speed
	GPIO_OSPEEDR_OSPEED15_LowSpeed = 0x0
	// Medium speed
	GPIO_OSPEEDR_OSPEED15_MediumSpeed = 0x1
	// High speed
	GPIO_OSPEEDR_OSPEED15_HighSpeed = 0x2
	// Very high speed
	GPIO_OSPEEDR_OSPEED15_VeryHighSpeed = 0x3
	// Position of OSPEED14 field.
	GPIO_OSPEEDR_OSPEED14_Pos = 0x1c
	// Bit mask of OSPEED14 field.
	GPIO_OSPEEDR_OSPEED14_Msk = 0x30000000
	// Low speed
	GPIO_OSPEEDR_OSPEED14_LowSpeed = 0x0
	// Medium speed
	GPIO_OSPEEDR_OSPEED14_MediumSpeed = 0x1
	// High speed
	GPIO_OSPEEDR_OSPEED14_HighSpeed = 0x2
	// Very high speed
	GPIO_OSPEEDR_OSPEED14_VeryHighSpeed = 0x3
	// Position of OSPEED13 field.
	GPIO_OSPEEDR_OSPEED13_Pos = 0x1a
	// Bit mask of OSPEED13 field.
	GPIO_OSPEEDR_OSPEED13_Msk = 0xc000000
	// Low speed
	GPIO_OSPEEDR_OSPEED13_LowSpeed = 0x0
	// Medium speed
	GPIO_OSPEEDR_OSPEED13_MediumSpeed = 0x1
	// High speed
	GPIO_OSPEEDR_OSPEED13_HighSpeed = 0x2
	// Very high speed
	GPIO_OSPEEDR_OSPEED13_VeryHighSpeed = 0x3
	// Position of OSPEED12 field.
	GPIO_OSPEEDR_OSPEED12_Pos = 0x18
	// Bit mask of OSPEED12 field.
	GPIO_OSPEEDR_OSPEED12_Msk = 0x3000000
	// Low speed
	GPIO_OSPEEDR_OSPEED12_LowSpeed = 0x0
	// Medium speed
	GPIO_OSPEEDR_OSPEED12_MediumSpeed = 0x1
	// High speed
	GPIO_OSPEEDR_OSPEED12_HighSpeed = 0x2
	// Very high speed
	GPIO_OSPEEDR_OSPEED12_VeryHighSpeed = 0x3
	// Position of OSPEED11 field.
	GPIO_OSPEEDR_OSPEED11_Pos = 0x16
	// Bit mask of OSPEED11 field.
	GPIO_OSPEEDR_OSPEED11_Msk = 0xc00000
	// Low speed
	GPIO_OSPEEDR_OSPEED11_LowSpeed = 0x0
	// Medium speed
	GPIO_OSPEEDR_OSPEED11_MediumSpeed = 0x1
	// High speed
	GPIO_OSPEEDR_OSPEED11_HighSpeed = 0x2
	// Very high speed
	GPIO_OSPEEDR_OSPEED11_VeryHighSpeed = 0x3
	// Position of OSPEED10 field.
	GPIO_OSPEEDR_OSPEED10_Pos = 0x14
	// Bit mask of OSPEED10 field.
	GPIO_OSPEEDR_OSPEED10_Msk = 0x300000
	// Low speed
	GPIO_OSPEEDR_OSPEED10_LowSpeed = 0x0
	// Medium speed
	GPIO_OSPEEDR_OSPEED10_MediumSpeed = 0x1
	// High speed
	GPIO_OSPEEDR_OSPEED10_HighSpeed = 0x2
	// Very high speed
	GPIO_OSPEEDR_OSPEED10_VeryHighSpeed = 0x3
	// Position of OSPEED9 field.
	GPIO_OSPEEDR_OSPEED9_Pos = 0x12
	// Bit mask of OSPEED9 field.
	GPIO_OSPEEDR_OSPEED9_Msk = 0xc0000
	// Low speed
	GPIO_OSPEEDR_OSPEED9_LowSpeed = 0x0
	// Medium speed
	GPIO_OSPEEDR_OSPEED9_MediumSpeed = 0x1
	// High speed
	GPIO_OSPEEDR_OSPEED9_HighSpeed = 0x2
	// Very high speed
	GPIO_OSPEEDR_OSPEED9_VeryHighSpeed = 0x3
	// Position of OSPEED8 field.
	GPIO_OSPEEDR_OSPEED8_Pos = 0x10
	// Bit mask of OSPEED8 field.
	GPIO_OSPEEDR_OSPEED8_Msk = 0x30000
	// Low speed
	GPIO_OSPEEDR_OSPEED8_LowSpeed = 0x0
	// Medium speed
	GPIO_OSPEEDR_OSPEED8_MediumSpeed = 0x1
	// High speed
	GPIO_OSPEEDR_OSPEED8_HighSpeed = 0x2
	// Very high speed
	GPIO_OSPEEDR_OSPEED8_VeryHighSpeed = 0x3
	// Position of OSPEED7 field.
	GPIO_OSPEEDR_OSPEED7_Pos = 0xe
	// Bit mask of OSPEED7 field.
	GPIO_OSPEEDR_OSPEED7_Msk = 0xc000
	// Low speed
	GPIO_OSPEEDR_OSPEED7_LowSpeed = 0x0
	// Medium speed
	GPIO_OSPEEDR_OSPEED7_MediumSpeed = 0x1
	// High speed
	GPIO_OSPEEDR_OSPEED7_HighSpeed = 0x2
	// Very high speed
	GPIO_OSPEEDR_OSPEED7_VeryHighSpeed = 0x3
	// Position of OSPEED6 field.
	GPIO_OSPEEDR_OSPEED6_Pos = 0xc
	// Bit mask of OSPEED6 field.
	GPIO_OSPEEDR_OSPEED6_Msk = 0x3000
	// Low speed
	GPIO_OSPEEDR_OSPEED6_LowSpeed = 0x0
	// Medium speed
	GPIO_OSPEEDR_OSPEED6_MediumSpeed = 0x1
	// High speed
	GPIO_OSPEEDR_OSPEED6_HighSpeed = 0x2
	// Very high speed
	GPIO_OSPEEDR_OSPEED6_VeryHighSpeed = 0x3
	// Position of OSPEED5 field.
	GPIO_OSPEEDR_OSPEED5_Pos = 0xa
	// Bit mask of OSPEED5 field.
	GPIO_OSPEEDR_OSPEED5_Msk = 0xc00
	// Low speed
	GPIO_OSPEEDR_OSPEED5_LowSpeed = 0x0
	// Medium speed
	GPIO_OSPEEDR_OSPEED5_MediumSpeed = 0x1
	// High speed
	GPIO_OSPEEDR_OSPEED5_HighSpeed = 0x2
	// Very high speed
	GPIO_OSPEEDR_OSPEED5_VeryHighSpeed = 0x3
	// Position of OSPEED4 field.
	GPIO_OSPEEDR_OSPEED4_Pos = 0x8
	// Bit mask of OSPEED4 field.
	GPIO_OSPEEDR_OSPEED4_Msk = 0x300
	// Low speed
	GPIO_OSPEEDR_OSPEED4_LowSpeed = 0x0
	// Medium speed
	GPIO_OSPEEDR_OSPEED4_MediumSpeed = 0x1
	// High speed
	GPIO_OSPEEDR_OSPEED4_HighSpeed = 0x2
	// Very high speed
	GPIO_OSPEEDR_OSPEED4_VeryHighSpeed = 0x3
	// Position of OSPEED3 field.
	GPIO_OSPEEDR_OSPEED3_Pos = 0x6
	// Bit mask of OSPEED3 field.
	GPIO_OSPEEDR_OSPEED3_Msk = 0xc0
	// Low speed
	GPIO_OSPEEDR_OSPEED3_LowSpeed = 0x0
	// Medium speed
	GPIO_OSPEEDR_OSPEED3_MediumSpeed = 0x1
	// High speed
	GPIO_OSPEEDR_OSPEED3_HighSpeed = 0x2
	// Very high speed
	GPIO_OSPEEDR_OSPEED3_VeryHighSpeed = 0x3
	// Position of OSPEED2 field.
	GPIO_OSPEEDR_OSPEED2_Pos = 0x4
	// Bit mask of OSPEED2 field.
	GPIO_OSPEEDR_OSPEED2_Msk = 0x30
	// Low speed
	GPIO_OSPEEDR_OSPEED2_LowSpeed = 0x0
	// Medium speed
	GPIO_OSPEEDR_OSPEED2_MediumSpeed = 0x1
	// High speed
	GPIO_OSPEEDR_OSPEED2_HighSpeed = 0x2
	// Very high speed
	GPIO_OSPEEDR_OSPEED2_VeryHighSpeed = 0x3
	// Position of OSPEED1 field.
	GPIO_OSPEEDR_OSPEED1_Pos = 0x2
	// Bit mask of OSPEED1 field.
	GPIO_OSPEEDR_OSPEED1_Msk = 0xc
	// Low speed
	GPIO_OSPEEDR_OSPEED1_LowSpeed = 0x0
	// Medium speed
	GPIO_OSPEEDR_OSPEED1_MediumSpeed = 0x1
	// High speed
	GPIO_OSPEEDR_OSPEED1_HighSpeed = 0x2
	// Very high speed
	GPIO_OSPEEDR_OSPEED1_VeryHighSpeed = 0x3
	// Position of OSPEED0 field.
	GPIO_OSPEEDR_OSPEED0_Pos = 0x0
	// Bit mask of OSPEED0 field.
	GPIO_OSPEEDR_OSPEED0_Msk = 0x3
	// Low speed
	GPIO_OSPEEDR_OSPEED0_LowSpeed = 0x0
	// Medium speed
	GPIO_OSPEEDR_OSPEED0_MediumSpeed = 0x1
	// High speed
	GPIO_OSPEEDR_OSPEED0_HighSpeed = 0x2
	// Very high speed
	GPIO_OSPEEDR_OSPEED0_VeryHighSpeed = 0x3

	// PUPDR: GPIO port pull-up/pull-down register
	// Position of PUPD15 field.
	GPIO_PUPDR_PUPD15_Pos = 0x1e
	// Bit mask of PUPD15 field.
	GPIO_PUPDR_PUPD15_Msk = 0xc0000000
	// No pull-up, pull-down
	GPIO_PUPDR_PUPD15_Floating = 0x0
	// Pull-up
	GPIO_PUPDR_PUPD15_PullUp = 0x1
	// Pull-down
	GPIO_PUPDR_PUPD15_PullDown = 0x2
	// Position of PUPD14 field.
	GPIO_PUPDR_PUPD14_Pos = 0x1c
	// Bit mask of PUPD14 field.
	GPIO_PUPDR_PUPD14_Msk = 0x30000000
	// No pull-up, pull-down
	GPIO_PUPDR_PUPD14_Floating = 0x0
	// Pull-up
	GPIO_PUPDR_PUPD14_PullUp = 0x1
	// Pull-down
	GPIO_PUPDR_PUPD14_PullDown = 0x2
	// Position of PUPD13 field.
	GPIO_PUPDR_PUPD13_Pos = 0x1a
	// Bit mask of PUPD13 field.
	GPIO_PUPDR_PUPD13_Msk = 0xc000000
	// No pull-up, pull-down
	GPIO_PUPDR_PUPD13_Floating = 0x0
	// Pull-up
	GPIO_PUPDR_PUPD13_PullUp = 0x1
	// Pull-down
	GPIO_PUPDR_PUPD13_PullDown = 0x2
	// Position of PUPD12 field.
	GPIO_PUPDR_PUPD12_Pos = 0x18
	// Bit mask of PUPD12 field.
	GPIO_PUPDR_PUPD12_Msk = 0x3000000
	// No pull-up, pull-down
	GPIO_PUPDR_PUPD12_Floating = 0x0
	// Pull-up
	GPIO_PUPDR_PUPD12_PullUp = 0x1
	// Pull-down
	GPIO_PUPDR_PUPD12_PullDown = 0x2
	// Position of PUPD11 field.
	GPIO_PUPDR_PUPD11_Pos = 0x16
	// Bit mask of PUPD11 field.
	GPIO_PUPDR_PUPD11_Msk = 0xc00000
	// No pull-up, pull-down
	GPIO_PUPDR_PUPD11_Floating = 0x0
	// Pull-up
	GPIO_PUPDR_PUPD11_PullUp = 0x1
	// Pull-down
	GPIO_PUPDR_PUPD11_PullDown = 0x2
	// Position of PUPD10 field.
	GPIO_PUPDR_PUPD10_Pos = 0x14
	// Bit mask of PUPD10 field.
	GPIO_PUPDR_PUPD10_Msk = 0x300000
	// No pull-up, pull-down
	GPIO_PUPDR_PUPD10_Floating = 0x0
	// Pull-up
	GPIO_PUPDR_PUPD10_PullUp = 0x1
	// Pull-down
	GPIO_PUPDR_PUPD10_PullDown = 0x2
	// Position of PUPD9 field.
	GPIO_PUPDR_PUPD9_Pos = 0x12
	// Bit mask of PUPD9 field.
	GPIO_PUPDR_PUPD9_Msk = 0xc0000
	// No pull-up, pull-down
	GPIO_PUPDR_PUPD9_Floating = 0x0
	// Pull-up
	GPIO_PUPDR_PUPD9_PullUp = 0x1
	// Pull-down
	GPIO_PUPDR_PUPD9_PullDown = 0x2
	// Position of PUPD8 field.
	GPIO_PUPDR_PUPD8_Pos = 0x10
	// Bit mask of PUPD8 field.
	GPIO_PUPDR_PUPD8_Msk = 0x30000
	// No pull-up, pull-down
	GPIO_PUPDR_PUPD8_Floating = 0x0
	// Pull-up
	GPIO_PUPDR_PUPD8_PullUp = 0x1
	// Pull-down
	GPIO_PUPDR_PUPD8_PullDown = 0x2
	// Position of PUPD7 field.
	GPIO_PUPDR_PUPD7_Pos = 0xe
	// Bit mask of PUPD7 field.
	GPIO_PUPDR_PUPD7_Msk = 0xc000
	// No pull-up, pull-down
	GPIO_PUPDR_PUPD7_Floating = 0x0
	// Pull-up
	GPIO_PUPDR_PUPD7_PullUp = 0x1
	// Pull-down
	GPIO_PUPDR_PUPD7_PullDown = 0x2
	// Position of PUPD6 field.
	GPIO_PUPDR_PUPD6_Pos = 0xc
	// Bit mask of PUPD6 field.
	GPIO_PUPDR_PUPD6_Msk = 0x3000
	// No pull-up, pull-down
	GPIO_PUPDR_PUPD6_Floating = 0x0
	// Pull-up
	GPIO_PUPDR_PUPD6_PullUp = 0x1
	// Pull-down
	GPIO_PUPDR_PUPD6_PullDown = 0x2
	// Position of PUPD5 field.
	GPIO_PUPDR_PUPD5_Pos = 0xa
	// Bit mask of PUPD5 field.
	GPIO_PUPDR_PUPD5_Msk = 0xc00
	// No pull-up, pull-down
	GPIO_PUPDR_PUPD5_Floating = 0x0
	// Pull-up
	GPIO_PUPDR_PUPD5_PullUp = 0x1
	// Pull-down
	GPIO_PUPDR_PUPD5_PullDown = 0x2
	// Position of PUPD4 field.
	GPIO_PUPDR_PUPD4_Pos = 0x8
	// Bit mask of PUPD4 field.
	GPIO_PUPDR_PUPD4_Msk = 0x300
	// No pull-up, pull-down
	GPIO_PUPDR_PUPD4_Floating = 0x0
	// Pull-up
	GPIO_PUPDR_PUPD4_PullUp = 0x1
	// Pull-down
	GPIO_PUPDR_PUPD4_PullDown = 0x2
	// Position of PUPD3 field.
	GPIO_PUPDR_PUPD3_Pos = 0x6
	// Bit mask of PUPD3 field.
	GPIO_PUPDR_PUPD3_Msk = 0xc0
	// No pull-up, pull-down
	GPIO_PUPDR_PUPD3_Floating = 0x0
	// Pull-up
	GPIO_PUPDR_PUPD3_PullUp = 0x1
	// Pull-down
	GPIO_PUPDR_PUPD3_PullDown = 0x2
	// Position of PUPD2 field.
	GPIO_PUPDR_PUPD2_Pos = 0x4
	// Bit mask of PUPD2 field.
	GPIO_PUPDR_PUPD2_Msk = 0x30
	// No pull-up, pull-down
	GPIO_PUPDR_PUPD2_Floating = 0x0
	// Pull-up
	GPIO_PUPDR_PUPD2_PullUp = 0x1
	// Pull-down
	GPIO_PUPDR_PUPD2_PullDown = 0x2
	// Position of PUPD1 field.
	GPIO_PUPDR_PUPD1_Pos = 0x2
	// Bit mask of PUPD1 field.
	GPIO_PUPDR_PUPD1_Msk = 0xc
	// No pull-up, pull-down
	GPIO_PUPDR_PUPD1_Floating = 0x0
	// Pull-up
	GPIO_PUPDR_PUPD1_PullUp = 0x1
	// Pull-down
	GPIO_PUPDR_PUPD1_PullDown = 0x2
	// Position of PUPD0 field.
	GPIO_PUPDR_PUPD0_Pos = 0x0
	// Bit mask of PUPD0 field.
	GPIO_PUPDR_PUPD0_Msk = 0x3
	// No pull-up, pull-down
	GPIO_PUPDR_PUPD0_Floating = 0x0
	// Pull-up
	GPIO_PUPDR_PUPD0_PullUp = 0x1
	// Pull-down
	GPIO_PUPDR_PUPD0_PullDown = 0x2

	// IDR: GPIO port input data register
	// Position of ID15 field.
	GPIO_IDR_ID15_Pos = 0xf
	// Bit mask of ID15 field.
	GPIO_IDR_ID15_Msk = 0x8000
	// Bit ID15.
	GPIO_IDR_ID15 = 0x8000
	// Input is logic high
	GPIO_IDR_ID15_High = 0x1
	// Input is logic low
	GPIO_IDR_ID15_Low = 0x0
	// Position of ID14 field.
	GPIO_IDR_ID14_Pos = 0xe
	// Bit mask of ID14 field.
	GPIO_IDR_ID14_Msk = 0x4000
	// Bit ID14.
	GPIO_IDR_ID14 = 0x4000
	// Input is logic high
	GPIO_IDR_ID14_High = 0x1
	// Input is logic low
	GPIO_IDR_ID14_Low = 0x0
	// Position of ID13 field.
	GPIO_IDR_ID13_Pos = 0xd
	// Bit mask of ID13 field.
	GPIO_IDR_ID13_Msk = 0x2000
	// Bit ID13.
	GPIO_IDR_ID13 = 0x2000
	// Input is logic high
	GPIO_IDR_ID13_High = 0x1
	// Input is logic low
	GPIO_IDR_ID13_Low = 0x0
	// Position of ID12 field.
	GPIO_IDR_ID12_Pos = 0xc
	// Bit mask of ID12 field.
	GPIO_IDR_ID12_Msk = 0x1000
	// Bit ID12.
	GPIO_IDR_ID12 = 0x1000
	// Input is logic high
	GPIO_IDR_ID12_High = 0x1
	// Input is logic low
	GPIO_IDR_ID12_Low = 0x0
	// Position of ID11 field.
	GPIO_IDR_ID11_Pos = 0xb
	// Bit mask of ID11 field.
	GPIO_IDR_ID11_Msk = 0x800
	// Bit ID11.
	GPIO_IDR_ID11 = 0x800
	// Input is logic high
	GPIO_IDR_ID11_High = 0x1
	// Input is logic low
	GPIO_IDR_ID11_Low = 0x0
	// Position of ID10 field.
	GPIO_IDR_ID10_Pos = 0xa
	// Bit mask of ID10 field.
	GPIO_IDR_ID10_Msk = 0x400
	// Bit ID10.
	GPIO_IDR_ID10 = 0x400
	// Input is logic high
	GPIO_IDR_ID10_High = 0x1
	// Input is logic low
	GPIO_IDR_ID10_Low = 0x0
	// Position of ID9 field.
	GPIO_IDR_ID9_Pos = 0x9
	// Bit mask of ID9 field.
	GPIO_IDR_ID9_Msk = 0x200
	// Bit ID9.
	GPIO_IDR_ID9 = 0x200
	// Input is logic high
	GPIO_IDR_ID9_High = 0x1
	// Input is logic low
	GPIO_IDR_ID9_Low = 0x0
	// Position of ID8 field.
	GPIO_IDR_ID8_Pos = 0x8
	// Bit mask of ID8 field.
	GPIO_IDR_ID8_Msk = 0x100
	// Bit ID8.
	GPIO_IDR_ID8 = 0x100
	// Input is logic high
	GPIO_IDR_ID8_High = 0x1
	// Input is logic low
	GPIO_IDR_ID8_Low = 0x0
	// Position of ID7 field.
	GPIO_IDR_ID7_Pos = 0x7
	// Bit mask of ID7 field.
	GPIO_IDR_ID7_Msk = 0x80
	// Bit ID7.
	GPIO_IDR_ID7 = 0x80
	// Input is logic high
	GPIO_IDR_ID7_High = 0x1
	// Input is logic low
	GPIO_IDR_ID7_Low = 0x0
	// Position of ID6 field.
	GPIO_IDR_ID6_Pos = 0x6
	// Bit mask of ID6 field.
	GPIO_IDR_ID6_Msk = 0x40
	// Bit ID6.
	GPIO_IDR_ID6 = 0x40
	// Input is logic high
	GPIO_IDR_ID6_High = 0x1
	// Input is logic low
	GPIO_IDR_ID6_Low = 0x0
	// Position of ID5 field.
	GPIO_IDR_ID5_Pos = 0x5
	// Bit mask of ID5 field.
	GPIO_IDR_ID5_Msk = 0x20
	// Bit ID5.
	GPIO_IDR_ID5 = 0x20
	// Input is logic high
	GPIO_IDR_ID5_High = 0x1
	// Input is logic low
	GPIO_IDR_ID5_Low = 0x0
	// Position of ID4 field.
	GPIO_IDR_ID4_Pos = 0x4
	// Bit mask of ID4 field.
	GPIO_IDR_ID4_Msk = 0x10
	// Bit ID4.
	GPIO_IDR_ID4 = 0x10
	// Input is logic high
	GPIO_IDR_ID4_High = 0x1
	// Input is logic low
	GPIO_IDR_ID4_Low = 0x0
	// Position of ID3 field.
	GPIO_IDR_ID3_Pos = 0x3
	// Bit mask of ID3 field.
	GPIO_IDR_ID3_Msk = 0x8
	// Bit ID3.
	GPIO_IDR_ID3 = 0x8
	// Input is logic high
	GPIO_IDR_ID3_High = 0x1
	// Input is logic low
	GPIO_IDR_ID3_Low = 0x0
	// Position of ID2 field.
	GPIO_IDR_ID2_Pos = 0x2
	// Bit mask of ID2 field.
	GPIO_IDR_ID2_Msk = 0x4
	// Bit ID2.
	GPIO_IDR_ID2 = 0x4
	// Input is logic high
	GPIO_IDR_ID2_High = 0x1
	// Input is logic low
	GPIO_IDR_ID2_Low = 0x0
	// Position of ID1 field.
	GPIO_IDR_ID1_Pos = 0x1
	// Bit mask of ID1 field.
	GPIO_IDR_ID1_Msk = 0x2
	// Bit ID1.
	GPIO_IDR_ID1 = 0x2
	// Input is logic high
	GPIO_IDR_ID1_High = 0x1
	// Input is logic low
	GPIO_IDR_ID1_Low = 0x0
	// Position of ID0 field.
	GPIO_IDR_ID0_Pos = 0x0
	// Bit mask of ID0 field.
	GPIO_IDR_ID0_Msk = 0x1
	// Bit ID0.
	GPIO_IDR_ID0 = 0x1
	// Input is logic high
	GPIO_IDR_ID0_High = 0x1
	// Input is logic low
	GPIO_IDR_ID0_Low = 0x0

	// ODR: GPIO port output data register
	// Position of OD15 field.
	GPIO_ODR_OD15_Pos = 0xf
	// Bit mask of OD15 field.
	GPIO_ODR_OD15_Msk = 0x8000
	// Bit OD15.
	GPIO_ODR_OD15 = 0x8000
	// Set output to logic high
	GPIO_ODR_OD15_High = 0x1
	// Set output to logic low
	GPIO_ODR_OD15_Low = 0x0
	// Position of OD14 field.
	GPIO_ODR_OD14_Pos = 0xe
	// Bit mask of OD14 field.
	GPIO_ODR_OD14_Msk = 0x4000
	// Bit OD14.
	GPIO_ODR_OD14 = 0x4000
	// Set output to logic high
	GPIO_ODR_OD14_High = 0x1
	// Set output to logic low
	GPIO_ODR_OD14_Low = 0x0
	// Position of OD13 field.
	GPIO_ODR_OD13_Pos = 0xd
	// Bit mask of OD13 field.
	GPIO_ODR_OD13_Msk = 0x2000
	// Bit OD13.
	GPIO_ODR_OD13 = 0x2000
	// Set output to logic high
	GPIO_ODR_OD13_High = 0x1
	// Set output to logic low
	GPIO_ODR_OD13_Low = 0x0
	// Position of OD12 field.
	GPIO_ODR_OD12_Pos = 0xc
	// Bit mask of OD12 field.
	GPIO_ODR_OD12_Msk = 0x1000
	// Bit OD12.
	GPIO_ODR_OD12 = 0x1000
	// Set output to logic high
	GPIO_ODR_OD12_High = 0x1
	// Set output to logic low
	GPIO_ODR_OD12_Low = 0x0
	// Position of OD11 field.
	GPIO_ODR_OD11_Pos = 0xb
	// Bit mask of OD11 field.
	GPIO_ODR_OD11_Msk = 0x800
	// Bit OD11.
	GPIO_ODR_OD11 = 0x800
	// Set output to logic high
	GPIO_ODR_OD11_High = 0x1
	// Set output to logic low
	GPIO_ODR_OD11_Low = 0x0
	// Position of OD10 field.
	GPIO_ODR_OD10_Pos = 0xa
	// Bit mask of OD10 field.
	GPIO_ODR_OD10_Msk = 0x400
	// Bit OD10.
	GPIO_ODR_OD10 = 0x400
	// Set output to logic high
	GPIO_ODR_OD10_High = 0x1
	// Set output to logic low
	GPIO_ODR_OD10_Low = 0x0
	// Position of OD9 field.
	GPIO_ODR_OD9_Pos = 0x9
	// Bit mask of OD9 field.
	GPIO_ODR_OD9_Msk = 0x200
	// Bit OD9.
	GPIO_ODR_OD9 = 0x200
	// Set output to logic high
	GPIO_ODR_OD9_High = 0x1
	// Set output to logic low
	GPIO_ODR_OD9_Low = 0x0
	// Position of OD8 field.
	GPIO_ODR_OD8_Pos = 0x8
	// Bit mask of OD8 field.
	GPIO_ODR_OD8_Msk = 0x100
	// Bit OD8.
	GPIO_ODR_OD8 = 0x100
	// Set output to logic high
	GPIO_ODR_OD8_High = 0x1
	// Set output to logic low
	GPIO_ODR_OD8_Low = 0x0
	// Position of OD7 field.
	GPIO_ODR_OD7_Pos = 0x7
	// Bit mask of OD7 field.
	GPIO_ODR_OD7_Msk = 0x80
	// Bit OD7.
	GPIO_ODR_OD7 = 0x80
	// Set output to logic high
	GPIO_ODR_OD7_High = 0x1
	// Set output to logic low
	GPIO_ODR_OD7_Low = 0x0
	// Position of OD6 field.
	GPIO_ODR_OD6_Pos = 0x6
	// Bit mask of OD6 field.
	GPIO_ODR_OD6_Msk = 0x40
	// Bit OD6.
	GPIO_ODR_OD6 = 0x40
	// Set output to logic high
	GPIO_ODR_OD6_High = 0x1
	// Set output to logic low
	GPIO_ODR_OD6_Low = 0x0
	// Position of OD5 field.
	GPIO_ODR_OD5_Pos = 0x5
	// Bit mask of OD5 field.
	GPIO_ODR_OD5_Msk = 0x20
	// Bit OD5.
	GPIO_ODR_OD5 = 0x20
	// Set output to logic high
	GPIO_ODR_OD5_High = 0x1
	// Set output to logic low
	GPIO_ODR_OD5_Low = 0x0
	// Position of OD4 field.
	GPIO_ODR_OD4_Pos = 0x4
	// Bit mask of OD4 field.
	GPIO_ODR_OD4_Msk = 0x10
	// Bit OD4.
	GPIO_ODR_OD4 = 0x10
	// Set output to logic high
	GPIO_ODR_OD4_High = 0x1
	// Set output to logic low
	GPIO_ODR_OD4_Low = 0x0
	// Position of OD3 field.
	GPIO_ODR_OD3_Pos = 0x3
	// Bit mask of OD3 field.
	GPIO_ODR_OD3_Msk = 0x8
	// Bit OD3.
	GPIO_ODR_OD3 = 0x8
	// Set output to logic high
	GPIO_ODR_OD3_High = 0x1
	// Set output to logic low
	GPIO_ODR_OD3_Low = 0x0
	// Position of OD2 field.
	GPIO_ODR_OD2_Pos = 0x2
	// Bit mask of OD2 field.
	GPIO_ODR_OD2_Msk = 0x4
	// Bit OD2.
	GPIO_ODR_OD2 = 0x4
	// Set output to logic high
	GPIO_ODR_OD2_High = 0x1
	// Set output to logic low
	GPIO_ODR_OD2_Low = 0x0
	// Position of OD1 field.
	GPIO_ODR_OD1_Pos = 0x1
	// Bit mask of OD1 field.
	GPIO_ODR_OD1_Msk = 0x2
	// Bit OD1.
	GPIO_ODR_OD1 = 0x2
	// Set output to logic high
	GPIO_ODR_OD1_High = 0x1
	// Set output to logic low
	GPIO_ODR_OD1_Low = 0x0
	// Position of OD0 field.
	GPIO_ODR_OD0_Pos = 0x0
	// Bit mask of OD0 field.
	GPIO_ODR_OD0_Msk = 0x1
	// Bit OD0.
	GPIO_ODR_OD0 = 0x1
	// Set output to logic high
	GPIO_ODR_OD0_High = 0x1
	// Set output to logic low
	GPIO_ODR_OD0_Low = 0x0

	// BSRR: GPIO port bit set/reset register
	// Position of BR15 field.
	GPIO_BSRR_BR15_Pos = 0x1f
	// Bit mask of BR15 field.
	GPIO_BSRR_BR15_Msk = 0x80000000
	// Bit BR15.
	GPIO_BSRR_BR15 = 0x80000000
	// Resets the corresponding ODx bit
	GPIO_BSRR_BR15_Reset = 0x1
	// Position of BR14 field.
	GPIO_BSRR_BR14_Pos = 0x1e
	// Bit mask of BR14 field.
	GPIO_BSRR_BR14_Msk = 0x40000000
	// Bit BR14.
	GPIO_BSRR_BR14 = 0x40000000
	// Resets the corresponding ODx bit
	GPIO_BSRR_BR14_Reset = 0x1
	// Position of BR13 field.
	GPIO_BSRR_BR13_Pos = 0x1d
	// Bit mask of BR13 field.
	GPIO_BSRR_BR13_Msk = 0x20000000
	// Bit BR13.
	GPIO_BSRR_BR13 = 0x20000000
	// Resets the corresponding ODx bit
	GPIO_BSRR_BR13_Reset = 0x1
	// Position of BR12 field.
	GPIO_BSRR_BR12_Pos = 0x1c
	// Bit mask of BR12 field.
	GPIO_BSRR_BR12_Msk = 0x10000000
	// Bit BR12.
	GPIO_BSRR_BR12 = 0x10000000
	// Resets the corresponding ODx bit
	GPIO_BSRR_BR12_Reset = 0x1
	// Position of BR11 field.
	GPIO_BSRR_BR11_Pos = 0x1b
	// Bit mask of BR11 field.
	GPIO_BSRR_BR11_Msk = 0x8000000
	// Bit BR11.
	GPIO_BSRR_BR11 = 0x8000000
	// Resets the corresponding ODx bit
	GPIO_BSRR_BR11_Reset = 0x1
	// Position of BR10 field.
	GPIO_BSRR_BR10_Pos = 0x1a
	// Bit mask of BR10 field.
	GPIO_BSRR_BR10_Msk = 0x4000000
	// Bit BR10.
	GPIO_BSRR_BR10 = 0x4000000
	// Resets the corresponding ODx bit
	GPIO_BSRR_BR10_Reset = 0x1
	// Position of BR9 field.
	GPIO_BSRR_BR9_Pos = 0x19
	// Bit mask of BR9 field.
	GPIO_BSRR_BR9_Msk = 0x2000000
	// Bit BR9.
	GPIO_BSRR_BR9 = 0x2000000
	// Resets the corresponding ODx bit
	GPIO_BSRR_BR9_Reset = 0x1
	// Position of BR8 field.
	GPIO_BSRR_BR8_Pos = 0x18
	// Bit mask of BR8 field.
	GPIO_BSRR_BR8_Msk = 0x1000000
	// Bit BR8.
	GPIO_BSRR_BR8 = 0x1000000
	// Resets the corresponding ODx bit
	GPIO_BSRR_BR8_Reset = 0x1
	// Position of BR7 field.
	GPIO_BSRR_BR7_Pos = 0x17
	// Bit mask of BR7 field.
	GPIO_BSRR_BR7_Msk = 0x800000
	// Bit BR7.
	GPIO_BSRR_BR7 = 0x800000
	// Resets the corresponding ODx bit
	GPIO_BSRR_BR7_Reset = 0x1
	// Position of BR6 field.
	GPIO_BSRR_BR6_Pos = 0x16
	// Bit mask of BR6 field.
	GPIO_BSRR_BR6_Msk = 0x400000
	// Bit BR6.
	GPIO_BSRR_BR6 = 0x400000
	// Resets the corresponding ODx bit
	GPIO_BSRR_BR6_Reset = 0x1
	// Position of BR5 field.
	GPIO_BSRR_BR5_Pos = 0x15
	// Bit mask of BR5 field.
	GPIO_BSRR_BR5_Msk = 0x200000
	// Bit BR5.
	GPIO_BSRR_BR5 = 0x200000
	// Resets the corresponding ODx bit
	GPIO_BSRR_BR5_Reset = 0x1
	// Position of BR4 field.
	GPIO_BSRR_BR4_Pos = 0x14
	// Bit mask of BR4 field.
	GPIO_BSRR_BR4_Msk = 0x100000
	// Bit BR4.
	GPIO_BSRR_BR4 = 0x100000
	// Resets the corresponding ODx bit
	GPIO_BSRR_BR4_Reset = 0x1
	// Position of BR3 field.
	GPIO_BSRR_BR3_Pos = 0x13
	// Bit mask of BR3 field.
	GPIO_BSRR_BR3_Msk = 0x80000
	// Bit BR3.
	GPIO_BSRR_BR3 = 0x80000
	// Resets the corresponding ODx bit
	GPIO_BSRR_BR3_Reset = 0x1
	// Position of BR2 field.
	GPIO_BSRR_BR2_Pos = 0x12
	// Bit mask of BR2 field.
	GPIO_BSRR_BR2_Msk = 0x40000
	// Bit BR2.
	GPIO_BSRR_BR2 = 0x40000
	// Resets the corresponding ODx bit
	GPIO_BSRR_BR2_Reset = 0x1
	// Position of BR1 field.
	GPIO_BSRR_BR1_Pos = 0x11
	// Bit mask of BR1 field.
	GPIO_BSRR_BR1_Msk = 0x20000
	// Bit BR1.
	GPIO_BSRR_BR1 = 0x20000
	// Resets the corresponding ODx bit
	GPIO_BSRR_BR1_Reset = 0x1
	// Position of BR0 field.
	GPIO_BSRR_BR0_Pos = 0x10
	// Bit mask of BR0 field.
	GPIO_BSRR_BR0_Msk = 0x10000
	// Bit BR0.
	GPIO_BSRR_BR0 = 0x10000
	// Resets the corresponding ODx bit
	GPIO_BSRR_BR0_Reset = 0x1
	// Position of BS15 field.
	GPIO_BSRR_BS15_Pos = 0xf
	// Bit mask of BS15 field.
	GPIO_BSRR_BS15_Msk = 0x8000
	// Bit BS15.
	GPIO_BSRR_BS15 = 0x8000
	// Sets the corresponding ODx bit
	GPIO_BSRR_BS15_Set = 0x1
	// Position of BS14 field.
	GPIO_BSRR_BS14_Pos = 0xe
	// Bit mask of BS14 field.
	GPIO_BSRR_BS14_Msk = 0x4000
	// Bit BS14.
	GPIO_BSRR_BS14 = 0x4000
	// Sets the corresponding ODx bit
	GPIO_BSRR_BS14_Set = 0x1
	// Position of BS13 field.
	GPIO_BSRR_BS13_Pos = 0xd
	// Bit mask of BS13 field.
	GPIO_BSRR_BS13_Msk = 0x2000
	// Bit BS13.
	GPIO_BSRR_BS13 = 0x2000
	// Sets the corresponding ODx bit
	GPIO_BSRR_BS13_Set = 0x1
	// Position of BS12 field.
	GPIO_BSRR_BS12_Pos = 0xc
	// Bit mask of BS12 field.
	GPIO_BSRR_BS12_Msk = 0x1000
	// Bit BS12.
	GPIO_BSRR_BS12 = 0x1000
	// Sets the corresponding ODx bit
	GPIO_BSRR_BS12_Set = 0x1
	// Position of BS11 field.
	GPIO_BSRR_BS11_Pos = 0xb
	// Bit mask of BS11 field.
	GPIO_BSRR_BS11_Msk = 0x800
	// Bit BS11.
	GPIO_BSRR_BS11 = 0x800
	// Sets the corresponding ODx bit
	GPIO_BSRR_BS11_Set = 0x1
	// Position of BS10 field.
	GPIO_BSRR_BS10_Pos = 0xa
	// Bit mask of BS10 field.
	GPIO_BSRR_BS10_Msk = 0x400
	// Bit BS10.
	GPIO_BSRR_BS10 = 0x400
	// Sets the corresponding ODx bit
	GPIO_BSRR_BS10_Set = 0x1
	// Position of BS9 field.
	GPIO_BSRR_BS9_Pos = 0x9
	// Bit mask of BS9 field.
	GPIO_BSRR_BS9_Msk = 0x200
	// Bit BS9.
	GPIO_BSRR_BS9 = 0x200
	// Sets the corresponding ODx bit
	GPIO_BSRR_BS9_Set = 0x1
	// Position of BS8 field.
	GPIO_BSRR_BS8_Pos = 0x8
	// Bit mask of BS8 field.
	GPIO_BSRR_BS8_Msk = 0x100
	// Bit BS8.
	GPIO_BSRR_BS8 = 0x100
	// Sets the corresponding ODx bit
	GPIO_BSRR_BS8_Set = 0x1
	// Position of BS7 field.
	GPIO_BSRR_BS7_Pos = 0x7
	// Bit mask of BS7 field.
	GPIO_BSRR_BS7_Msk = 0x80
	// Bit BS7.
	GPIO_BSRR_BS7 = 0x80
	// Sets the corresponding ODx bit
	GPIO_BSRR_BS7_Set = 0x1
	// Position of BS6 field.
	GPIO_BSRR_BS6_Pos = 0x6
	// Bit mask of BS6 field.
	GPIO_BSRR_BS6_Msk = 0x40
	// Bit BS6.
	GPIO_BSRR_BS6 = 0x40
	// Sets the corresponding ODx bit
	GPIO_BSRR_BS6_Set = 0x1
	// Position of BS5 field.
	GPIO_BSRR_BS5_Pos = 0x5
	// Bit mask of BS5 field.
	GPIO_BSRR_BS5_Msk = 0x20
	// Bit BS5.
	GPIO_BSRR_BS5 = 0x20
	// Sets the corresponding ODx bit
	GPIO_BSRR_BS5_Set = 0x1
	// Position of BS4 field.
	GPIO_BSRR_BS4_Pos = 0x4
	// Bit mask of BS4 field.
	GPIO_BSRR_BS4_Msk = 0x10
	// Bit BS4.
	GPIO_BSRR_BS4 = 0x10
	// Sets the corresponding ODx bit
	GPIO_BSRR_BS4_Set = 0x1
	// Position of BS3 field.
	GPIO_BSRR_BS3_Pos = 0x3
	// Bit mask of BS3 field.
	GPIO_BSRR_BS3_Msk = 0x8
	// Bit BS3.
	GPIO_BSRR_BS3 = 0x8
	// Sets the corresponding ODx bit
	GPIO_BSRR_BS3_Set = 0x1
	// Position of BS2 field.
	GPIO_BSRR_BS2_Pos = 0x2
	// Bit mask of BS2 field.
	GPIO_BSRR_BS2_Msk = 0x4
	// Bit BS2.
	GPIO_BSRR_BS2 = 0x4
	// Sets the corresponding ODx bit
	GPIO_BSRR_BS2_Set = 0x1
	// Position of BS1 field.
	GPIO_BSRR_BS1_Pos = 0x1
	// Bit mask of BS1 field.
	GPIO_BSRR_BS1_Msk = 0x2
	// Bit BS1.
	GPIO_BSRR_BS1 = 0x2
	// Sets the corresponding ODx bit
	GPIO_BSRR_BS1_Set = 0x1
	// Position of BS0 field.
	GPIO_BSRR_BS0_Pos = 0x0
	// Bit mask of BS0 field.
	GPIO_BSRR_BS0_Msk = 0x1
	// Bit BS0.
	GPIO_BSRR_BS0 = 0x1
	// Sets the corresponding ODx bit
	GPIO_BSRR_BS0_Set = 0x1

	// LCKR: GPIO port configuration lock register
	// Position of LCKK field.
	GPIO_LCKR_LCKK_Pos = 0x10
	// Bit mask of LCKK field.
	GPIO_LCKR_LCKK_Msk = 0x10000
	// Bit LCKK.
	GPIO_LCKR_LCKK = 0x10000
	// Port configuration lock key not active
	GPIO_LCKR_LCKK_NotActive = 0x0
	// Port configuration lock key active
	GPIO_LCKR_LCKK_Active = 0x1
	// Position of LCK15 field.
	GPIO_LCKR_LCK15_Pos = 0xf
	// Bit mask of LCK15 field.
	GPIO_LCKR_LCK15_Msk = 0x8000
	// Bit LCK15.
	GPIO_LCKR_LCK15 = 0x8000
	// Port configuration not locked
	GPIO_LCKR_LCK15_Unlocked = 0x0
	// Port configuration locked
	GPIO_LCKR_LCK15_Locked = 0x1
	// Position of LCK14 field.
	GPIO_LCKR_LCK14_Pos = 0xe
	// Bit mask of LCK14 field.
	GPIO_LCKR_LCK14_Msk = 0x4000
	// Bit LCK14.
	GPIO_LCKR_LCK14 = 0x4000
	// Port configuration not locked
	GPIO_LCKR_LCK14_Unlocked = 0x0
	// Port configuration locked
	GPIO_LCKR_LCK14_Locked = 0x1
	// Position of LCK13 field.
	GPIO_LCKR_LCK13_Pos = 0xd
	// Bit mask of LCK13 field.
	GPIO_LCKR_LCK13_Msk = 0x2000
	// Bit LCK13.
	GPIO_LCKR_LCK13 = 0x2000
	// Port configuration not locked
	GPIO_LCKR_LCK13_Unlocked = 0x0
	// Port configuration locked
	GPIO_LCKR_LCK13_Locked = 0x1
	// Position of LCK12 field.
	GPIO_LCKR_LCK12_Pos = 0xc
	// Bit mask of LCK12 field.
	GPIO_LCKR_LCK12_Msk = 0x1000
	// Bit LCK12.
	GPIO_LCKR_LCK12 = 0x1000
	// Port configuration not locked
	GPIO_LCKR_LCK12_Unlocked = 0x0
	// Port configuration locked
	GPIO_LCKR_LCK12_Locked = 0x1
	// Position of LCK11 field.
	GPIO_LCKR_LCK11_Pos = 0xb
	// Bit mask of LCK11 field.
	GPIO_LCKR_LCK11_Msk = 0x800
	// Bit LCK11.
	GPIO_LCKR_LCK11 = 0x800
	// Port configuration not locked
	GPIO_LCKR_LCK11_Unlocked = 0x0
	// Port configuration locked
	GPIO_LCKR_LCK11_Locked = 0x1
	// Position of LCK10 field.
	GPIO_LCKR_LCK10_Pos = 0xa
	// Bit mask of LCK10 field.
	GPIO_LCKR_LCK10_Msk = 0x400
	// Bit LCK10.
	GPIO_LCKR_LCK10 = 0x400
	// Port configuration not locked
	GPIO_LCKR_LCK10_Unlocked = 0x0
	// Port configuration locked
	GPIO_LCKR_LCK10_Locked = 0x1
	// Position of LCK9 field.
	GPIO_LCKR_LCK9_Pos = 0x9
	// Bit mask of LCK9 field.
	GPIO_LCKR_LCK9_Msk = 0x200
	// Bit LCK9.
	GPIO_LCKR_LCK9 = 0x200
	// Port configuration not locked
	GPIO_LCKR_LCK9_Unlocked = 0x0
	// Port configuration locked
	GPIO_LCKR_LCK9_Locked = 0x1
	// Position of LCK8 field.
	GPIO_LCKR_LCK8_Pos = 0x8
	// Bit mask of LCK8 field.
	GPIO_LCKR_LCK8_Msk = 0x100
	// Bit LCK8.
	GPIO_LCKR_LCK8 = 0x100
	// Port configuration not locked
	GPIO_LCKR_LCK8_Unlocked = 0x0
	// Port configuration locked
	GPIO_LCKR_LCK8_Locked = 0x1
	// Position of LCK7 field.
	GPIO_LCKR_LCK7_Pos = 0x7
	// Bit mask of LCK7 field.
	GPIO_LCKR_LCK7_Msk = 0x80
	// Bit LCK7.
	GPIO_LCKR_LCK7 = 0x80
	// Port configuration not locked
	GPIO_LCKR_LCK7_Unlocked = 0x0
	// Port configuration locked
	GPIO_LCKR_LCK7_Locked = 0x1
	// Position of LCK6 field.
	GPIO_LCKR_LCK6_Pos = 0x6
	// Bit mask of LCK6 field.
	GPIO_LCKR_LCK6_Msk = 0x40
	// Bit LCK6.
	GPIO_LCKR_LCK6 = 0x40
	// Port configuration not locked
	GPIO_LCKR_LCK6_Unlocked = 0x0
	// Port configuration locked
	GPIO_LCKR_LCK6_Locked = 0x1
	// Position of LCK5 field.
	GPIO_LCKR_LCK5_Pos = 0x5
	// Bit mask of LCK5 field.
	GPIO_LCKR_LCK5_Msk = 0x20
	// Bit LCK5.
	GPIO_LCKR_LCK5 = 0x20
	// Port configuration not locked
	GPIO_LCKR_LCK5_Unlocked = 0x0
	// Port configuration locked
	GPIO_LCKR_LCK5_Locked = 0x1
	// Position of LCK4 field.
	GPIO_LCKR_LCK4_Pos = 0x4
	// Bit mask of LCK4 field.
	GPIO_LCKR_LCK4_Msk = 0x10
	// Bit LCK4.
	GPIO_LCKR_LCK4 = 0x10
	// Port configuration not locked
	GPIO_LCKR_LCK4_Unlocked = 0x0
	// Port configuration locked
	GPIO_LCKR_LCK4_Locked = 0x1
	// Position of LCK3 field.
	GPIO_LCKR_LCK3_Pos = 0x3
	// Bit mask of LCK3 field.
	GPIO_LCKR_LCK3_Msk = 0x8
	// Bit LCK3.
	GPIO_LCKR_LCK3 = 0x8
	// Port configuration not locked
	GPIO_LCKR_LCK3_Unlocked = 0x0
	// Port configuration locked
	GPIO_LCKR_LCK3_Locked = 0x1
	// Position of LCK2 field.
	GPIO_LCKR_LCK2_Pos = 0x2
	// Bit mask of LCK2 field.
	GPIO_LCKR_LCK2_Msk = 0x4
	// Bit LCK2.
	GPIO_LCKR_LCK2 = 0x4
	// Port configuration not locked
	GPIO_LCKR_LCK2_Unlocked = 0x0
	// Port configuration locked
	GPIO_LCKR_LCK2_Locked = 0x1
	// Position of LCK1 field.
	GPIO_LCKR_LCK1_Pos = 0x1
	// Bit mask of LCK1 field.
	GPIO_LCKR_LCK1_Msk = 0x2
	// Bit LCK1.
	GPIO_LCKR_LCK1 = 0x2
	// Port configuration not locked
	GPIO_LCKR_LCK1_Unlocked = 0x0
	// Port configuration locked
	GPIO_LCKR_LCK1_Locked = 0x1
	// Position of LCK0 field.
	GPIO_LCKR_LCK0_Pos = 0x0
	// Bit mask of LCK0 field.
	GPIO_LCKR_LCK0_Msk = 0x1
	// Bit LCK0.
	GPIO_LCKR_LCK0 = 0x1
	// Port configuration not locked
	GPIO_LCKR_LCK0_Unlocked = 0x0
	// Port configuration locked
	GPIO_LCKR_LCK0_Locked = 0x1

	// AFRL: GPIO alternate function low register
	// Position of AFSEL7 field.
	GPIO_AFRL_AFSEL7_Pos = 0x1c
	// Bit mask of AFSEL7 field.
	GPIO_AFRL_AFSEL7_Msk = 0xf0000000
	// AF0
	GPIO_AFRL_AFSEL7_AF0 = 0x0
	// AF1
	GPIO_AFRL_AFSEL7_AF1 = 0x1
	// AF2
	GPIO_AFRL_AFSEL7_AF2 = 0x2
	// AF3
	GPIO_AFRL_AFSEL7_AF3 = 0x3
	// AF4
	GPIO_AFRL_AFSEL7_AF4 = 0x4
	// AF5
	GPIO_AFRL_AFSEL7_AF5 = 0x5
	// AF6
	GPIO_AFRL_AFSEL7_AF6 = 0x6
	// AF7
	GPIO_AFRL_AFSEL7_AF7 = 0x7
	// Position of AFSEL6 field.
	GPIO_AFRL_AFSEL6_Pos = 0x18
	// Bit mask of AFSEL6 field.
	GPIO_AFRL_AFSEL6_Msk = 0xf000000
	// AF0
	GPIO_AFRL_AFSEL6_AF0 = 0x0
	// AF1
	GPIO_AFRL_AFSEL6_AF1 = 0x1
	// AF2
	GPIO_AFRL_AFSEL6_AF2 = 0x2
	// AF3
	GPIO_AFRL_AFSEL6_AF3 = 0x3
	// AF4
	GPIO_AFRL_AFSEL6_AF4 = 0x4
	// AF5
	GPIO_AFRL_AFSEL6_AF5 = 0x5
	// AF6
	GPIO_AFRL_AFSEL6_AF6 = 0x6
	// AF7
	GPIO_AFRL_AFSEL6_AF7 = 0x7
	// Position of AFSEL5 field.
	GPIO_AFRL_AFSEL5_Pos = 0x14
	// Bit mask of AFSEL5 field.
	GPIO_AFRL_AFSEL5_Msk = 0xf00000
	// AF0
	GPIO_AFRL_AFSEL5_AF0 = 0x0
	// AF1
	GPIO_AFRL_AFSEL5_AF1 = 0x1
	// AF2
	GPIO_AFRL_AFSEL5_AF2 = 0x2
	// AF3
	GPIO_AFRL_AFSEL5_AF3 = 0x3
	// AF4
	GPIO_AFRL_AFSEL5_AF4 = 0x4
	// AF5
	GPIO_AFRL_AFSEL5_AF5 = 0x5
	// AF6
	GPIO_AFRL_AFSEL5_AF6 = 0x6
	// AF7
	GPIO_AFRL_AFSEL5_AF7 = 0x7
	// Position of AFSEL4 field.
	GPIO_AFRL_AFSEL4_Pos = 0x10
	// Bit mask of AFSEL4 field.
	GPIO_AFRL_AFSEL4_Msk = 0xf0000
	// AF0
	GPIO_AFRL_AFSEL4_AF0 = 0x0
	// AF1
	GPIO_AFRL_AFSEL4_AF1 = 0x1
	// AF2
	GPIO_AFRL_AFSEL4_AF2 = 0x2
	// AF3
	GPIO_AFRL_AFSEL4_AF3 = 0x3
	// AF4
	GPIO_AFRL_AFSEL4_AF4 = 0x4
	// AF5
	GPIO_AFRL_AFSEL4_AF5 = 0x5
	// AF6
	GPIO_AFRL_AFSEL4_AF6 = 0x6
	// AF7
	GPIO_AFRL_AFSEL4_AF7 = 0x7
	// Position of AFSEL3 field.
	GPIO_AFRL_AFSEL3_Pos = 0xc
	// Bit mask of AFSEL3 field.
	GPIO_AFRL_AFSEL3_Msk = 0xf000
	// AF0
	GPIO_AFRL_AFSEL3_AF0 = 0x0
	// AF1
	GPIO_AFRL_AFSEL3_AF1 = 0x1
	// AF2
	GPIO_AFRL_AFSEL3_AF2 = 0x2
	// AF3
	GPIO_AFRL_AFSEL3_AF3 = 0x3
	// AF4
	GPIO_AFRL_AFSEL3_AF4 = 0x4
	// AF5
	GPIO_AFRL_AFSEL3_AF5 = 0x5
	// AF6
	GPIO_AFRL_AFSEL3_AF6 = 0x6
	// AF7
	GPIO_AFRL_AFSEL3_AF7 = 0x7
	// Position of AFSEL2 field.
	GPIO_AFRL_AFSEL2_Pos = 0x8
	// Bit mask of AFSEL2 field.
	GPIO_AFRL_AFSEL2_Msk = 0xf00
	// AF0
	GPIO_AFRL_AFSEL2_AF0 = 0x0
	// AF1
	GPIO_AFRL_AFSEL2_AF1 = 0x1
	// AF2
	GPIO_AFRL_AFSEL2_AF2 = 0x2
	// AF3
	GPIO_AFRL_AFSEL2_AF3 = 0x3
	// AF4
	GPIO_AFRL_AFSEL2_AF4 = 0x4
	// AF5
	GPIO_AFRL_AFSEL2_AF5 = 0x5
	// AF6
	GPIO_AFRL_AFSEL2_AF6 = 0x6
	// AF7
	GPIO_AFRL_AFSEL2_AF7 = 0x7
	// Position of AFSEL1 field.
	GPIO_AFRL_AFSEL1_Pos = 0x4
	// Bit mask of AFSEL1 field.
	GPIO_AFRL_AFSEL1_Msk = 0xf0
	// AF0
	GPIO_AFRL_AFSEL1_AF0 = 0x0
	// AF1
	GPIO_AFRL_AFSEL1_AF1 = 0x1
	// AF2
	GPIO_AFRL_AFSEL1_AF2 = 0x2
	// AF3
	GPIO_AFRL_AFSEL1_AF3 = 0x3
	// AF4
	GPIO_AFRL_AFSEL1_AF4 = 0x4
	// AF5
	GPIO_AFRL_AFSEL1_AF5 = 0x5
	// AF6
	GPIO_AFRL_AFSEL1_AF6 = 0x6
	// AF7
	GPIO_AFRL_AFSEL1_AF7 = 0x7
	// Position of AFSEL0 field.
	GPIO_AFRL_AFSEL0_Pos = 0x0
	// Bit mask of AFSEL0 field.
	GPIO_AFRL_AFSEL0_Msk = 0xf
	// AF0
	GPIO_AFRL_AFSEL0_AF0 = 0x0
	// AF1
	GPIO_AFRL_AFSEL0_AF1 = 0x1
	// AF2
	GPIO_AFRL_AFSEL0_AF2 = 0x2
	// AF3
	GPIO_AFRL_AFSEL0_AF3 = 0x3
	// AF4
	GPIO_AFRL_AFSEL0_AF4 = 0x4
	// AF5
	GPIO_AFRL_AFSEL0_AF5 = 0x5
	// AF6
	GPIO_AFRL_AFSEL0_AF6 = 0x6
	// AF7
	GPIO_AFRL_AFSEL0_AF7 = 0x7

	// AFRH: GPIO alternate function high register
	// Position of AFSEL15 field.
	GPIO_AFRH_AFSEL15_Pos = 0x1c
	// Bit mask of AFSEL15 field.
	GPIO_AFRH_AFSEL15_Msk = 0xf0000000
	// AF0
	GPIO_AFRH_AFSEL15_AF0 = 0x0
	// AF1
	GPIO_AFRH_AFSEL15_AF1 = 0x1
	// AF2
	GPIO_AFRH_AFSEL15_AF2 = 0x2
	// AF3
	GPIO_AFRH_AFSEL15_AF3 = 0x3
	// AF4
	GPIO_AFRH_AFSEL15_AF4 = 0x4
	// AF5
	GPIO_AFRH_AFSEL15_AF5 = 0x5
	// AF6
	GPIO_AFRH_AFSEL15_AF6 = 0x6
	// AF7
	GPIO_AFRH_AFSEL15_AF7 = 0x7
	// Position of AFSEL14 field.
	GPIO_AFRH_AFSEL14_Pos = 0x18
	// Bit mask of AFSEL14 field.
	GPIO_AFRH_AFSEL14_Msk = 0xf000000
	// AF0
	GPIO_AFRH_AFSEL14_AF0 = 0x0
	// AF1
	GPIO_AFRH_AFSEL14_AF1 = 0x1
	// AF2
	GPIO_AFRH_AFSEL14_AF2 = 0x2
	// AF3
	GPIO_AFRH_AFSEL14_AF3 = 0x3
	// AF4
	GPIO_AFRH_AFSEL14_AF4 = 0x4
	// AF5
	GPIO_AFRH_AFSEL14_AF5 = 0x5
	// AF6
	GPIO_AFRH_AFSEL14_AF6 = 0x6
	// AF7
	GPIO_AFRH_AFSEL14_AF7 = 0x7
	// Position of AFSEL13 field.
	GPIO_AFRH_AFSEL13_Pos = 0x14
	// Bit mask of AFSEL13 field.
	GPIO_AFRH_AFSEL13_Msk = 0xf00000
	// AF0
	GPIO_AFRH_AFSEL13_AF0 = 0x0
	// AF1
	GPIO_AFRH_AFSEL13_AF1 = 0x1
	// AF2
	GPIO_AFRH_AFSEL13_AF2 = 0x2
	// AF3
	GPIO_AFRH_AFSEL13_AF3 = 0x3
	// AF4
	GPIO_AFRH_AFSEL13_AF4 = 0x4
	// AF5
	GPIO_AFRH_AFSEL13_AF5 = 0x5
	// AF6
	GPIO_AFRH_AFSEL13_AF6 = 0x6
	// AF7
	GPIO_AFRH_AFSEL13_AF7 = 0x7
	// Position of AFSEL12 field.
	GPIO_AFRH_AFSEL12_Pos = 0x10
	// Bit mask of AFSEL12 field.
	GPIO_AFRH_AFSEL12_Msk = 0xf0000
	// AF0
	GPIO_AFRH_AFSEL12_AF0 = 0x0
	// AF1
	GPIO_AFRH_AFSEL12_AF1 = 0x1
	// AF2
	GPIO_AFRH_AFSEL12_AF2 = 0x2
	// AF3
	GPIO_AFRH_AFSEL12_AF3 = 0x3
	// AF4
	GPIO_AFRH_AFSEL12_AF4 = 0x4
	// AF5
	GPIO_AFRH_AFSEL12_AF5 = 0x5
	// AF6
	GPIO_AFRH_AFSEL12_AF6 = 0x6
	// AF7
	GPIO_AFRH_AFSEL12_AF7 = 0x7
	// Position of AFSEL11 field.
	GPIO_AFRH_AFSEL11_Pos = 0xc
	// Bit mask of AFSEL11 field.
	GPIO_AFRH_AFSEL11_Msk = 0xf000
	// AF0
	GPIO_AFRH_AFSEL11_AF0 = 0x0
	// AF1
	GPIO_AFRH_AFSEL11_AF1 = 0x1
	// AF2
	GPIO_AFRH_AFSEL11_AF2 = 0x2
	// AF3
	GPIO_AFRH_AFSEL11_AF3 = 0x3
	// AF4
	GPIO_AFRH_AFSEL11_AF4 = 0x4
	// AF5
	GPIO_AFRH_AFSEL11_AF5 = 0x5
	// AF6
	GPIO_AFRH_AFSEL11_AF6 = 0x6
	// AF7
	GPIO_AFRH_AFSEL11_AF7 = 0x7
	// Position of AFSEL10 field.
	GPIO_AFRH_AFSEL10_Pos = 0x8
	// Bit mask of AFSEL10 field.
	GPIO_AFRH_AFSEL10_Msk = 0xf00
	// AF0
	GPIO_AFRH_AFSEL10_AF0 = 0x0
	// AF1
	GPIO_AFRH_AFSEL10_AF1 = 0x1
	// AF2
	GPIO_AFRH_AFSEL10_AF2 = 0x2
	// AF3
	GPIO_AFRH_AFSEL10_AF3 = 0x3
	// AF4
	GPIO_AFRH_AFSEL10_AF4 = 0x4
	// AF5
	GPIO_AFRH_AFSEL10_AF5 = 0x5
	// AF6
	GPIO_AFRH_AFSEL10_AF6 = 0x6
	// AF7
	GPIO_AFRH_AFSEL10_AF7 = 0x7
	// Position of AFSEL9 field.
	GPIO_AFRH_AFSEL9_Pos = 0x4
	// Bit mask of AFSEL9 field.
	GPIO_AFRH_AFSEL9_Msk = 0xf0
	// AF0
	GPIO_AFRH_AFSEL9_AF0 = 0x0
	// AF1
	GPIO_AFRH_AFSEL9_AF1 = 0x1
	// AF2
	GPIO_AFRH_AFSEL9_AF2 = 0x2
	// AF3
	GPIO_AFRH_AFSEL9_AF3 = 0x3
	// AF4
	GPIO_AFRH_AFSEL9_AF4 = 0x4
	// AF5
	GPIO_AFRH_AFSEL9_AF5 = 0x5
	// AF6
	GPIO_AFRH_AFSEL9_AF6 = 0x6
	// AF7
	GPIO_AFRH_AFSEL9_AF7 = 0x7
	// Position of AFSEL8 field.
	GPIO_AFRH_AFSEL8_Pos = 0x0
	// Bit mask of AFSEL8 field.
	GPIO_AFRH_AFSEL8_Msk = 0xf
	// AF0
	GPIO_AFRH_AFSEL8_AF0 = 0x0
	// AF1
	GPIO_AFRH_AFSEL8_AF1 = 0x1
	// AF2
	GPIO_AFRH_AFSEL8_AF2 = 0x2
	// AF3
	GPIO_AFRH_AFSEL8_AF3 = 0x3
	// AF4
	GPIO_AFRH_AFSEL8_AF4 = 0x4
	// AF5
	GPIO_AFRH_AFSEL8_AF5 = 0x5
	// AF6
	GPIO_AFRH_AFSEL8_AF6 = 0x6
	// AF7
	GPIO_AFRH_AFSEL8_AF7 = 0x7

	// BRR: GPIO port bit reset register
	// Position of BR15 field.
	GPIO_BRR_BR15_Pos = 0xf
	// Bit mask of BR15 field.
	GPIO_BRR_BR15_Msk = 0x8000
	// Bit BR15.
	GPIO_BRR_BR15 = 0x8000
	// Position of BR14 field.
	GPIO_BRR_BR14_Pos = 0xe
	// Bit mask of BR14 field.
	GPIO_BRR_BR14_Msk = 0x4000
	// Bit BR14.
	GPIO_BRR_BR14 = 0x4000
	// Position of BR13 field.
	GPIO_BRR_BR13_Pos = 0xd
	// Bit mask of BR13 field.
	GPIO_BRR_BR13_Msk = 0x2000
	// Bit BR13.
	GPIO_BRR_BR13 = 0x2000
	// Position of BR12 field.
	GPIO_BRR_BR12_Pos = 0xc
	// Bit mask of BR12 field.
	GPIO_BRR_BR12_Msk = 0x1000
	// Bit BR12.
	GPIO_BRR_BR12 = 0x1000
	// Position of BR11 field.
	GPIO_BRR_BR11_Pos = 0xb
	// Bit mask of BR11 field.
	GPIO_BRR_BR11_Msk = 0x800
	// Bit BR11.
	GPIO_BRR_BR11 = 0x800
	// Position of BR10 field.
	GPIO_BRR_BR10_Pos = 0xa
	// Bit mask of BR10 field.
	GPIO_BRR_BR10_Msk = 0x400
	// Bit BR10.
	GPIO_BRR_BR10 = 0x400
	// Position of BR9 field.
	GPIO_BRR_BR9_Pos = 0x9
	// Bit mask of BR9 field.
	GPIO_BRR_BR9_Msk = 0x200
	// Bit BR9.
	GPIO_BRR_BR9 = 0x200
	// Position of BR8 field.
	GPIO_BRR_BR8_Pos = 0x8
	// Bit mask of BR8 field.
	GPIO_BRR_BR8_Msk = 0x100
	// Bit BR8.
	GPIO_BRR_BR8 = 0x100
	// Position of BR7 field.
	GPIO_BRR_BR7_Pos = 0x7
	// Bit mask of BR7 field.
	GPIO_BRR_BR7_Msk = 0x80
	// Bit BR7.
	GPIO_BRR_BR7 = 0x80
	// Position of BR6 field.
	GPIO_BRR_BR6_Pos = 0x6
	// Bit mask of BR6 field.
	GPIO_BRR_BR6_Msk = 0x40
	// Bit BR6.
	GPIO_BRR_BR6 = 0x40
	// Position of BR5 field.
	GPIO_BRR_BR5_Pos = 0x5
	// Bit mask of BR5 field.
	GPIO_BRR_BR5_Msk = 0x20
	// Bit BR5.
	GPIO_BRR_BR5 = 0x20
	// Position of BR4 field.
	GPIO_BRR_BR4_Pos = 0x4
	// Bit mask of BR4 field.
	GPIO_BRR_BR4_Msk = 0x10
	// Bit BR4.
	GPIO_BRR_BR4 = 0x10
	// Position of BR3 field.
	GPIO_BRR_BR3_Pos = 0x3
	// Bit mask of BR3 field.
	GPIO_BRR_BR3_Msk = 0x8
	// Bit BR3.
	GPIO_BRR_BR3 = 0x8
	// Position of BR2 field.
	GPIO_BRR_BR2_Pos = 0x2
	// Bit mask of BR2 field.
	GPIO_BRR_BR2_Msk = 0x4
	// Bit BR2.
	GPIO_BRR_BR2 = 0x4
	// Position of BR1 field.
	GPIO_BRR_BR1_Pos = 0x1
	// Bit mask of BR1 field.
	GPIO_BRR_BR1_Msk = 0x2
	// Bit BR1.
	GPIO_BRR_BR1 = 0x2
	// Position of BR0 field.
	GPIO_BRR_BR0_Pos = 0x0
	// Bit mask of BR0 field.
	GPIO_BRR_BR0_Msk = 0x1
	// Bit BR0.
	GPIO_BRR_BR0 = 0x1
)

// Bitfields for LPTIM: Low power timer
const (
	// ISR: Interrupt and Status Register
	// Position of DOWN field.
	LPTIM_ISR_DOWN_Pos = 0x6
	// Bit mask of DOWN field.
	LPTIM_ISR_DOWN_Msk = 0x40
	// Bit DOWN.
	LPTIM_ISR_DOWN = 0x40
	// Counter direction change up to down
	LPTIM_ISR_DOWN_Set = 0x1
	// Position of UP field.
	LPTIM_ISR_UP_Pos = 0x5
	// Bit mask of UP field.
	LPTIM_ISR_UP_Msk = 0x20
	// Bit UP.
	LPTIM_ISR_UP = 0x20
	// Counter direction change down to up
	LPTIM_ISR_UP_Set = 0x1
	// Position of ARROK field.
	LPTIM_ISR_ARROK_Pos = 0x4
	// Bit mask of ARROK field.
	LPTIM_ISR_ARROK_Msk = 0x10
	// Bit ARROK.
	LPTIM_ISR_ARROK = 0x10
	// Autoreload register update OK
	LPTIM_ISR_ARROK_Set = 0x1
	// Position of CMPOK field.
	LPTIM_ISR_CMPOK_Pos = 0x3
	// Bit mask of CMPOK field.
	LPTIM_ISR_CMPOK_Msk = 0x8
	// Bit CMPOK.
	LPTIM_ISR_CMPOK = 0x8
	// Compare register update OK
	LPTIM_ISR_CMPOK_Set = 0x1
	// Position of EXTTRIG field.
	LPTIM_ISR_EXTTRIG_Pos = 0x2
	// Bit mask of EXTTRIG field.
	LPTIM_ISR_EXTTRIG_Msk = 0x4
	// Bit EXTTRIG.
	LPTIM_ISR_EXTTRIG = 0x4
	// External trigger edge event
	LPTIM_ISR_EXTTRIG_Set = 0x1
	// Position of ARRM field.
	LPTIM_ISR_ARRM_Pos = 0x1
	// Bit mask of ARRM field.
	LPTIM_ISR_ARRM_Msk = 0x2
	// Bit ARRM.
	LPTIM_ISR_ARRM = 0x2
	// Autoreload match
	LPTIM_ISR_ARRM_Set = 0x1
	// Position of CMPM field.
	LPTIM_ISR_CMPM_Pos = 0x0
	// Bit mask of CMPM field.
	LPTIM_ISR_CMPM_Msk = 0x1
	// Bit CMPM.
	LPTIM_ISR_CMPM = 0x1
	// Compare match
	LPTIM_ISR_CMPM_Set = 0x1

	// ICR: Interrupt Clear Register
	// Position of DOWNCF field.
	LPTIM_ICR_DOWNCF_Pos = 0x6
	// Bit mask of DOWNCF field.
	LPTIM_ICR_DOWNCF_Msk = 0x40
	// Bit DOWNCF.
	LPTIM_ICR_DOWNCF = 0x40
	// Direction change to down Clear Flag
	LPTIM_ICR_DOWNCF_Clear = 0x1
	// Position of UPCF field.
	LPTIM_ICR_UPCF_Pos = 0x5
	// Bit mask of UPCF field.
	LPTIM_ICR_UPCF_Msk = 0x20
	// Bit UPCF.
	LPTIM_ICR_UPCF = 0x20
	// Direction change to up Clear Flag
	LPTIM_ICR_UPCF_Clear = 0x1
	// Position of ARROKCF field.
	LPTIM_ICR_ARROKCF_Pos = 0x4
	// Bit mask of ARROKCF field.
	LPTIM_ICR_ARROKCF_Msk = 0x10
	// Bit ARROKCF.
	LPTIM_ICR_ARROKCF = 0x10
	// Autoreload register update OK Clear Flag
	LPTIM_ICR_ARROKCF_Clear = 0x1
	// Position of CMPOKCF field.
	LPTIM_ICR_CMPOKCF_Pos = 0x3
	// Bit mask of CMPOKCF field.
	LPTIM_ICR_CMPOKCF_Msk = 0x8
	// Bit CMPOKCF.
	LPTIM_ICR_CMPOKCF = 0x8
	// Compare register update OK Clear Flag
	LPTIM_ICR_CMPOKCF_Clear = 0x1
	// Position of EXTTRIGCF field.
	LPTIM_ICR_EXTTRIGCF_Pos = 0x2
	// Bit mask of EXTTRIGCF field.
	LPTIM_ICR_EXTTRIGCF_Msk = 0x4
	// Bit EXTTRIGCF.
	LPTIM_ICR_EXTTRIGCF = 0x4
	// External trigger valid edge Clear Flag
	LPTIM_ICR_EXTTRIGCF_Clear = 0x1
	// Position of ARRMCF field.
	LPTIM_ICR_ARRMCF_Pos = 0x1
	// Bit mask of ARRMCF field.
	LPTIM_ICR_ARRMCF_Msk = 0x2
	// Bit ARRMCF.
	LPTIM_ICR_ARRMCF = 0x2
	// Autoreload match Clear Flag
	LPTIM_ICR_ARRMCF_Clear = 0x1
	// Position of CMPMCF field.
	LPTIM_ICR_CMPMCF_Pos = 0x0
	// Bit mask of CMPMCF field.
	LPTIM_ICR_CMPMCF_Msk = 0x1
	// Bit CMPMCF.
	LPTIM_ICR_CMPMCF = 0x1
	// Compare match Clear Flag
	LPTIM_ICR_CMPMCF_Clear = 0x1

	// IER: Interrupt Enable Register
	// Position of DOWNIE field.
	LPTIM_IER_DOWNIE_Pos = 0x6
	// Bit mask of DOWNIE field.
	LPTIM_IER_DOWNIE_Msk = 0x40
	// Bit DOWNIE.
	LPTIM_IER_DOWNIE = 0x40
	// DOWN interrupt disabled
	LPTIM_IER_DOWNIE_Disabled = 0x0
	// DOWN interrupt enabled
	LPTIM_IER_DOWNIE_Enabled = 0x1
	// Position of UPIE field.
	LPTIM_IER_UPIE_Pos = 0x5
	// Bit mask of UPIE field.
	LPTIM_IER_UPIE_Msk = 0x20
	// Bit UPIE.
	LPTIM_IER_UPIE = 0x20
	// UP interrupt disabled
	LPTIM_IER_UPIE_Disabled = 0x0
	// UP interrupt enabled
	LPTIM_IER_UPIE_Enabled = 0x1
	// Position of ARROKIE field.
	LPTIM_IER_ARROKIE_Pos = 0x4
	// Bit mask of ARROKIE field.
	LPTIM_IER_ARROKIE_Msk = 0x10
	// Bit ARROKIE.
	LPTIM_IER_ARROKIE = 0x10
	// ARROK interrupt disabled
	LPTIM_IER_ARROKIE_Disabled = 0x0
	// ARROK interrupt enabled
	LPTIM_IER_ARROKIE_Enabled = 0x1
	// Position of CMPOKIE field.
	LPTIM_IER_CMPOKIE_Pos = 0x3
	// Bit mask of CMPOKIE field.
	LPTIM_IER_CMPOKIE_Msk = 0x8
	// Bit CMPOKIE.
	LPTIM_IER_CMPOKIE = 0x8
	// CMPOK interrupt disabled
	LPTIM_IER_CMPOKIE_Disabled = 0x0
	// CMPOK interrupt enabled
	LPTIM_IER_CMPOKIE_Enabled = 0x1
	// Position of EXTTRIGIE field.
	LPTIM_IER_EXTTRIGIE_Pos = 0x2
	// Bit mask of EXTTRIGIE field.
	LPTIM_IER_EXTTRIGIE_Msk = 0x4
	// Bit EXTTRIGIE.
	LPTIM_IER_EXTTRIGIE = 0x4
	// EXTTRIG interrupt disabled
	LPTIM_IER_EXTTRIGIE_Disabled = 0x0
	// EXTTRIG interrupt enabled
	LPTIM_IER_EXTTRIGIE_Enabled = 0x1
	// Position of ARRMIE field.
	LPTIM_IER_ARRMIE_Pos = 0x1
	// Bit mask of ARRMIE field.
	LPTIM_IER_ARRMIE_Msk = 0x2
	// Bit ARRMIE.
	LPTIM_IER_ARRMIE = 0x2
	// ARRM interrupt disabled
	LPTIM_IER_ARRMIE_Disabled = 0x0
	// ARRM interrupt enabled
	LPTIM_IER_ARRMIE_Enabled = 0x1
	// Position of CMPMIE field.
	LPTIM_IER_CMPMIE_Pos = 0x0
	// Bit mask of CMPMIE field.
	LPTIM_IER_CMPMIE_Msk = 0x1
	// Bit CMPMIE.
	LPTIM_IER_CMPMIE = 0x1
	// CMPM interrupt disabled
	LPTIM_IER_CMPMIE_Disabled = 0x0
	// CMPM interrupt enabled
	LPTIM_IER_CMPMIE_Enabled = 0x1

	// CFGR: Configuration Register
	// Position of ENC field.
	LPTIM_CFGR_ENC_Pos = 0x18
	// Bit mask of ENC field.
	LPTIM_CFGR_ENC_Msk = 0x1000000
	// Bit ENC.
	LPTIM_CFGR_ENC = 0x1000000
	// Encoder mode disabled
	LPTIM_CFGR_ENC_Disabled = 0x0
	// Encoder mode enabled
	LPTIM_CFGR_ENC_Enabled = 0x1
	// Position of COUNTMODE field.
	LPTIM_CFGR_COUNTMODE_Pos = 0x17
	// Bit mask of COUNTMODE field.
	LPTIM_CFGR_COUNTMODE_Msk = 0x800000
	// Bit COUNTMODE.
	LPTIM_CFGR_COUNTMODE = 0x800000
	// The counter is incremented following each internal clock pulse
	LPTIM_CFGR_COUNTMODE_Internal = 0x0
	// The counter is incremented following each valid clock pulse on the LPTIM external Input1
	LPTIM_CFGR_COUNTMODE_External = 0x1
	// Position of PRELOAD field.
	LPTIM_CFGR_PRELOAD_Pos = 0x16
	// Bit mask of PRELOAD field.
	LPTIM_CFGR_PRELOAD_Msk = 0x400000
	// Bit PRELOAD.
	LPTIM_CFGR_PRELOAD = 0x400000
	// Registers are updated after each APB bus write access
	LPTIM_CFGR_PRELOAD_Immediate = 0x0
	// Registers are updated at the end of the current LPTIM period
	LPTIM_CFGR_PRELOAD_EndOfPeriod = 0x1
	// Position of WAVPOL field.
	LPTIM_CFGR_WAVPOL_Pos = 0x15
	// Bit mask of WAVPOL field.
	LPTIM_CFGR_WAVPOL_Msk = 0x200000
	// Bit WAVPOL.
	LPTIM_CFGR_WAVPOL = 0x200000
	// The LPTIM output reflects the compare results between LPTIM_ARR and LPTIM_CMP registers
	LPTIM_CFGR_WAVPOL_Positive = 0x0
	// The LPTIM output reflects the inverse of the compare results between LPTIM_ARR and LPTIM_CMP registers
	LPTIM_CFGR_WAVPOL_Negative = 0x1
	// Position of WAVE field.
	LPTIM_CFGR_WAVE_Pos = 0x14
	// Bit mask of WAVE field.
	LPTIM_CFGR_WAVE_Msk = 0x100000
	// Bit WAVE.
	LPTIM_CFGR_WAVE = 0x100000
	// Deactivate Set-once mode, PWM / One Pulse waveform (depending on OPMODE bit)
	LPTIM_CFGR_WAVE_Inactive = 0x0
	// Activate the Set-once mode
	LPTIM_CFGR_WAVE_Active = 0x1
	// Position of TIMOUT field.
	LPTIM_CFGR_TIMOUT_Pos = 0x13
	// Bit mask of TIMOUT field.
	LPTIM_CFGR_TIMOUT_Msk = 0x80000
	// Bit TIMOUT.
	LPTIM_CFGR_TIMOUT = 0x80000
	// A trigger event arriving when the timer is already started will be ignored
	LPTIM_CFGR_TIMOUT_Disabled = 0x0
	// A trigger event arriving when the timer is already started will reset and restart the counter
	LPTIM_CFGR_TIMOUT_Enabled = 0x1
	// Position of TRIGEN field.
	LPTIM_CFGR_TRIGEN_Pos = 0x11
	// Bit mask of TRIGEN field.
	LPTIM_CFGR_TRIGEN_Msk = 0x60000
	// Software trigger (counting start is initiated by software)
	LPTIM_CFGR_TRIGEN_SW = 0x0
	// Rising edge is the active edge
	LPTIM_CFGR_TRIGEN_RisingEdge = 0x1
	// Falling edge is the active edge
	LPTIM_CFGR_TRIGEN_FallingEdge = 0x2
	// Both edges are active edges
	LPTIM_CFGR_TRIGEN_BothEdges = 0x3
	// Position of TRIGSEL field.
	LPTIM_CFGR_TRIGSEL_Pos = 0xd
	// Bit mask of TRIGSEL field.
	LPTIM_CFGR_TRIGSEL_Msk = 0xe000
	// lptim_ext_trig0
	LPTIM_CFGR_TRIGSEL_Trig0 = 0x0
	// lptim_ext_trig1
	LPTIM_CFGR_TRIGSEL_Trig1 = 0x1
	// lptim_ext_trig2
	LPTIM_CFGR_TRIGSEL_Trig2 = 0x2
	// lptim_ext_trig3
	LPTIM_CFGR_TRIGSEL_Trig3 = 0x3
	// lptim_ext_trig4
	LPTIM_CFGR_TRIGSEL_Trig4 = 0x4
	// lptim_ext_trig5
	LPTIM_CFGR_TRIGSEL_Trig5 = 0x5
	// lptim_ext_trig6
	LPTIM_CFGR_TRIGSEL_Trig6 = 0x6
	// lptim_ext_trig7
	LPTIM_CFGR_TRIGSEL_Trig7 = 0x7
	// Position of PRESC field.
	LPTIM_CFGR_PRESC_Pos = 0x9
	// Bit mask of PRESC field.
	LPTIM_CFGR_PRESC_Msk = 0xe00
	// /1
	LPTIM_CFGR_PRESC_Div1 = 0x0
	// /2
	LPTIM_CFGR_PRESC_Div2 = 0x1
	// /4
	LPTIM_CFGR_PRESC_Div4 = 0x2
	// /8
	LPTIM_CFGR_PRESC_Div8 = 0x3
	// /16
	LPTIM_CFGR_PRESC_Div16 = 0x4
	// /32
	LPTIM_CFGR_PRESC_Div32 = 0x5
	// /64
	LPTIM_CFGR_PRESC_Div64 = 0x6
	// /128
	LPTIM_CFGR_PRESC_Div128 = 0x7
	// Position of TRGFLT field.
	LPTIM_CFGR_TRGFLT_Pos = 0x6
	// Bit mask of TRGFLT field.
	LPTIM_CFGR_TRGFLT_Msk = 0xc0
	// Any trigger active level change is considered as a valid trigger
	LPTIM_CFGR_TRGFLT_Immediate = 0x0
	// Trigger active level change must be stable for at least 2 clock periods before it is considered as valid trigger
	LPTIM_CFGR_TRGFLT_Clocks2 = 0x1
	// Trigger active level change must be stable for at least 4 clock periods before it is considered as valid trigger
	LPTIM_CFGR_TRGFLT_Clocks4 = 0x2
	// Trigger active level change must be stable for at least 8 clock periods before it is considered as valid trigger
	LPTIM_CFGR_TRGFLT_Clocks8 = 0x3
	// Position of CKFLT field.
	LPTIM_CFGR_CKFLT_Pos = 0x3
	// Bit mask of CKFLT field.
	LPTIM_CFGR_CKFLT_Msk = 0x18
	// Any external clock signal level change is considered as a valid transition
	LPTIM_CFGR_CKFLT_Immediate = 0x0
	// External clock signal level change must be stable for at least 2 clock periods before it is considered as valid transition
	LPTIM_CFGR_CKFLT_Clocks2 = 0x1
	// External clock signal level change must be stable for at least 4 clock periods before it is considered as valid transition
	LPTIM_CFGR_CKFLT_Clocks4 = 0x2
	// External clock signal level change must be stable for at least 8 clock periods before it is considered as valid transition
	LPTIM_CFGR_CKFLT_Clocks8 = 0x3
	// Position of CKPOL field.
	LPTIM_CFGR_CKPOL_Pos = 0x1
	// Bit mask of CKPOL field.
	LPTIM_CFGR_CKPOL_Msk = 0x6
	// The rising edge is the active edge used for counting. If LPTIM is in encoder mode: Encoder sub-mode 1 is active.
	LPTIM_CFGR_CKPOL_RisingEdge = 0x0
	// The falling edge is the active edge used for counting. If LPTIM is in encoder mode: Encoder sub-mode 2 is active.
	LPTIM_CFGR_CKPOL_FallingEdge = 0x1
	// Both edges are active edge. If LPTIM is in encoder mode: Encoder sub-mode 3 is active.
	LPTIM_CFGR_CKPOL_BothEdges = 0x2
	// Position of CKSEL field.
	LPTIM_CFGR_CKSEL_Pos = 0x0
	// Bit mask of CKSEL field.
	LPTIM_CFGR_CKSEL_Msk = 0x1
	// Bit CKSEL.
	LPTIM_CFGR_CKSEL = 0x1
	// LPTIM is clocked by internal clock source (APB clock or any of the embedded oscillators)
	LPTIM_CFGR_CKSEL_Internal = 0x0
	// LPTIM is clocked by an external clock source through the LPTIM external Input1
	LPTIM_CFGR_CKSEL_External = 0x1

	// CR: Control Register
	// Position of CNTSTRT field.
	LPTIM_CR_CNTSTRT_Pos = 0x2
	// Bit mask of CNTSTRT field.
	LPTIM_CR_CNTSTRT_Msk = 0x4
	// Bit CNTSTRT.
	LPTIM_CR_CNTSTRT = 0x4
	// Timer start in Continuous mode
	LPTIM_CR_CNTSTRT_Start = 0x1
	// Position of SNGSTRT field.
	LPTIM_CR_SNGSTRT_Pos = 0x1
	// Bit mask of SNGSTRT field.
	LPTIM_CR_SNGSTRT_Msk = 0x2
	// Bit SNGSTRT.
	LPTIM_CR_SNGSTRT = 0x2
	// LPTIM start in Single mode
	LPTIM_CR_SNGSTRT_Start = 0x1
	// Position of ENABLE field.
	LPTIM_CR_ENABLE_Pos = 0x0
	// Bit mask of ENABLE field.
	LPTIM_CR_ENABLE_Msk = 0x1
	// Bit ENABLE.
	LPTIM_CR_ENABLE = 0x1
	// LPTIM is disabled
	LPTIM_CR_ENABLE_Disabled = 0x0
	// LPTIM is enabled
	LPTIM_CR_ENABLE_Enabled = 0x1

	// CMP: Compare Register
	// Position of CMP field.
	LPTIM_CMP_CMP_Pos = 0x0
	// Bit mask of CMP field.
	LPTIM_CMP_CMP_Msk = 0xffff

	// ARR: Autoreload Register
	// Position of ARR field.
	LPTIM_ARR_ARR_Pos = 0x0
	// Bit mask of ARR field.
	LPTIM_ARR_ARR_Msk = 0xffff

	// CNT: Counter Register
	// Position of CNT field.
	LPTIM_CNT_CNT_Pos = 0x0
	// Bit mask of CNT field.
	LPTIM_CNT_CNT_Msk = 0xffff
)

// Bitfields for RNG: Random number generator
const (
	// CR: control register
	// Position of IE field.
	RNG_CR_IE_Pos = 0x3
	// Bit mask of IE field.
	RNG_CR_IE_Msk = 0x8
	// Bit IE.
	RNG_CR_IE = 0x8
	// Position of RNGEN field.
	RNG_CR_RNGEN_Pos = 0x2
	// Bit mask of RNGEN field.
	RNG_CR_RNGEN_Msk = 0x4
	// Bit RNGEN.
	RNG_CR_RNGEN = 0x4

	// SR: status register
	// Position of SEIS field.
	RNG_SR_SEIS_Pos = 0x6
	// Bit mask of SEIS field.
	RNG_SR_SEIS_Msk = 0x40
	// Bit SEIS.
	RNG_SR_SEIS = 0x40
	// Position of CEIS field.
	RNG_SR_CEIS_Pos = 0x5
	// Bit mask of CEIS field.
	RNG_SR_CEIS_Msk = 0x20
	// Bit CEIS.
	RNG_SR_CEIS = 0x20
	// Position of SECS field.
	RNG_SR_SECS_Pos = 0x2
	// Bit mask of SECS field.
	RNG_SR_SECS_Msk = 0x4
	// Bit SECS.
	RNG_SR_SECS = 0x4
	// Position of CECS field.
	RNG_SR_CECS_Pos = 0x1
	// Bit mask of CECS field.
	RNG_SR_CECS_Msk = 0x2
	// Bit CECS.
	RNG_SR_CECS = 0x2
	// Position of DRDY field.
	RNG_SR_DRDY_Pos = 0x0
	// Bit mask of DRDY field.
	RNG_SR_DRDY_Msk = 0x1
	// Bit DRDY.
	RNG_SR_DRDY = 0x1

	// DR: data register
	// Position of RNDATA field.
	RNG_DR_RNDATA_Pos = 0x0
	// Bit mask of RNDATA field.
	RNG_DR_RNDATA_Msk = 0xffffffff
)

// Bitfields for RTC: Real-time clock
const (
	// TR: RTC time register
	// Position of PM field.
	RTC_TR_PM_Pos = 0x16
	// Bit mask of PM field.
	RTC_TR_PM_Msk = 0x400000
	// Bit PM.
	RTC_TR_PM = 0x400000
	// AM or 24-hour format
	RTC_TR_PM_AM = 0x0
	// PM
	RTC_TR_PM_PM = 0x1
	// Position of HT field.
	RTC_TR_HT_Pos = 0x14
	// Bit mask of HT field.
	RTC_TR_HT_Msk = 0x300000
	// Position of HU field.
	RTC_TR_HU_Pos = 0x10
	// Bit mask of HU field.
	RTC_TR_HU_Msk = 0xf0000
	// Position of MNT field.
	RTC_TR_MNT_Pos = 0xc
	// Bit mask of MNT field.
	RTC_TR_MNT_Msk = 0x7000
	// Position of MNU field.
	RTC_TR_MNU_Pos = 0x8
	// Bit mask of MNU field.
	RTC_TR_MNU_Msk = 0xf00
	// Position of ST field.
	RTC_TR_ST_Pos = 0x4
	// Bit mask of ST field.
	RTC_TR_ST_Msk = 0x70
	// Position of SU field.
	RTC_TR_SU_Pos = 0x0
	// Bit mask of SU field.
	RTC_TR_SU_Msk = 0xf

	// DR: RTC date register
	// Position of YT field.
	RTC_DR_YT_Pos = 0x14
	// Bit mask of YT field.
	RTC_DR_YT_Msk = 0xf00000
	// Position of YU field.
	RTC_DR_YU_Pos = 0x10
	// Bit mask of YU field.
	RTC_DR_YU_Msk = 0xf0000
	// Position of WDU field.
	RTC_DR_WDU_Pos = 0xd
	// Bit mask of WDU field.
	RTC_DR_WDU_Msk = 0xe000
	// Position of MT field.
	RTC_DR_MT_Pos = 0xc
	// Bit mask of MT field.
	RTC_DR_MT_Msk = 0x1000
	// Bit MT.
	RTC_DR_MT = 0x1000
	// Position of MU field.
	RTC_DR_MU_Pos = 0x8
	// Bit mask of MU field.
	RTC_DR_MU_Msk = 0xf00
	// Position of DT field.
	RTC_DR_DT_Pos = 0x4
	// Bit mask of DT field.
	RTC_DR_DT_Msk = 0x30
	// Position of DU field.
	RTC_DR_DU_Pos = 0x0
	// Bit mask of DU field.
	RTC_DR_DU_Msk = 0xf

	// CR: RTC control register
	// Position of COE field.
	RTC_CR_COE_Pos = 0x17
	// Bit mask of COE field.
	RTC_CR_COE_Msk = 0x800000
	// Bit COE.
	RTC_CR_COE = 0x800000
	// Calibration output disabled
	RTC_CR_COE_Disabled = 0x0
	// Calibration output enabled
	RTC_CR_COE_Enabled = 0x1
	// Position of OSEL field.
	RTC_CR_OSEL_Pos = 0x15
	// Bit mask of OSEL field.
	RTC_CR_OSEL_Msk = 0x600000
	// Output disabled
	RTC_CR_OSEL_Disabled = 0x0
	// Alarm A output enabled
	RTC_CR_OSEL_AlarmA = 0x1
	// Alarm B output enabled
	RTC_CR_OSEL_AlarmB = 0x2
	// Wakeup output enabled
	RTC_CR_OSEL_Wakeup = 0x3
	// Position of POL field.
	RTC_CR_POL_Pos = 0x14
	// Bit mask of POL field.
	RTC_CR_POL_Msk = 0x100000
	// Bit POL.
	RTC_CR_POL = 0x100000
	// The pin is high when ALRAF/ALRBF/WUTF is asserted (depending on OSEL[1:0])
	RTC_CR_POL_High = 0x0
	// The pin is low when ALRAF/ALRBF/WUTF is asserted (depending on OSEL[1:0])
	RTC_CR_POL_Low = 0x1
	// Position of COSEL field.
	RTC_CR_COSEL_Pos = 0x13
	// Bit mask of COSEL field.
	RTC_CR_COSEL_Msk = 0x80000
	// Bit COSEL.
	RTC_CR_COSEL = 0x80000
	// Calibration output is 512 Hz (with default prescaler setting)
	RTC_CR_COSEL_CalFreq_512Hz = 0x0
	// Calibration output is 1 Hz (with default prescaler setting)
	RTC_CR_COSEL_CalFreq_1Hz = 0x1
	// Position of BKP field.
	RTC_CR_BKP_Pos = 0x12
	// Bit mask of BKP field.
	RTC_CR_BKP_Msk = 0x40000
	// Bit BKP.
	RTC_CR_BKP = 0x40000
	// Daylight Saving Time change has not been performed
	RTC_CR_BKP_DST_Not_Changed = 0x0
	// Daylight Saving Time change has been performed
	RTC_CR_BKP_DST_Changed = 0x1
	// Position of SUB1H field.
	RTC_CR_SUB1H_Pos = 0x11
	// Bit mask of SUB1H field.
	RTC_CR_SUB1H_Msk = 0x20000
	// Bit SUB1H.
	RTC_CR_SUB1H = 0x20000
	// Subtracts 1 hour to the current time. This can be used for winter time change outside initialization mode
	RTC_CR_SUB1H_Sub1 = 0x1
	// Position of ADD1H field.
	RTC_CR_ADD1H_Pos = 0x10
	// Bit mask of ADD1H field.
	RTC_CR_ADD1H_Msk = 0x10000
	// Bit ADD1H.
	RTC_CR_ADD1H = 0x10000
	// Adds 1 hour to the current time. This can be used for summer time change outside initialization mode
	RTC_CR_ADD1H_Add1 = 0x1
	// Position of TSIE field.
	RTC_CR_TSIE_Pos = 0xf
	// Bit mask of TSIE field.
	RTC_CR_TSIE_Msk = 0x8000
	// Bit TSIE.
	RTC_CR_TSIE = 0x8000
	// Time-stamp Interrupt disabled
	RTC_CR_TSIE_Disabled = 0x0
	// Time-stamp Interrupt enabled
	RTC_CR_TSIE_Enabled = 0x1
	// Position of WUTIE field.
	RTC_CR_WUTIE_Pos = 0xe
	// Bit mask of WUTIE field.
	RTC_CR_WUTIE_Msk = 0x4000
	// Bit WUTIE.
	RTC_CR_WUTIE = 0x4000
	// Wakeup timer interrupt disabled
	RTC_CR_WUTIE_Disabled = 0x0
	// Wakeup timer interrupt enabled
	RTC_CR_WUTIE_Enabled = 0x1
	// Position of ALRBIE field.
	RTC_CR_ALRBIE_Pos = 0xd
	// Bit mask of ALRBIE field.
	RTC_CR_ALRBIE_Msk = 0x2000
	// Bit ALRBIE.
	RTC_CR_ALRBIE = 0x2000
	// Alarm B Interrupt disabled
	RTC_CR_ALRBIE_Disabled = 0x0
	// Alarm B Interrupt enabled
	RTC_CR_ALRBIE_Enabled = 0x1
	// Position of ALRAIE field.
	RTC_CR_ALRAIE_Pos = 0xc
	// Bit mask of ALRAIE field.
	RTC_CR_ALRAIE_Msk = 0x1000
	// Bit ALRAIE.
	RTC_CR_ALRAIE = 0x1000
	// Alarm A interrupt disabled
	RTC_CR_ALRAIE_Disabled = 0x0
	// Alarm A interrupt enabled
	RTC_CR_ALRAIE_Enabled = 0x1
	// Position of TSE field.
	RTC_CR_TSE_Pos = 0xb
	// Bit mask of TSE field.
	RTC_CR_TSE_Msk = 0x800
	// Bit TSE.
	RTC_CR_TSE = 0x800
	// Timestamp disabled
	RTC_CR_TSE_Disabled = 0x0
	// Timestamp enabled
	RTC_CR_TSE_Enabled = 0x1
	// Position of WUTE field.
	RTC_CR_WUTE_Pos = 0xa
	// Bit mask of WUTE field.
	RTC_CR_WUTE_Msk = 0x400
	// Bit WUTE.
	RTC_CR_WUTE = 0x400
	// Wakeup timer disabled
	RTC_CR_WUTE_Disabled = 0x0
	// Wakeup timer enabled
	RTC_CR_WUTE_Enabled = 0x1
	// Position of ALRBE field.
	RTC_CR_ALRBE_Pos = 0x9
	// Bit mask of ALRBE field.
	RTC_CR_ALRBE_Msk = 0x200
	// Bit ALRBE.
	RTC_CR_ALRBE = 0x200
	// Alarm B disabled
	RTC_CR_ALRBE_Disabled = 0x0
	// Alarm B enabled
	RTC_CR_ALRBE_Enabled = 0x1
	// Position of ALRAE field.
	RTC_CR_ALRAE_Pos = 0x8
	// Bit mask of ALRAE field.
	RTC_CR_ALRAE_Msk = 0x100
	// Bit ALRAE.
	RTC_CR_ALRAE = 0x100
	// Alarm A disabled
	RTC_CR_ALRAE_Disabled = 0x0
	// Alarm A enabled
	RTC_CR_ALRAE_Enabled = 0x1
	// Position of FMT field.
	RTC_CR_FMT_Pos = 0x6
	// Bit mask of FMT field.
	RTC_CR_FMT_Msk = 0x40
	// Bit FMT.
	RTC_CR_FMT = 0x40
	// 24 hour/day format
	RTC_CR_FMT_Twenty_Four_Hour = 0x0
	// AM/PM hour format
	RTC_CR_FMT_AM_PM = 0x1
	// Position of BYPSHAD field.
	RTC_CR_BYPSHAD_Pos = 0x5
	// Bit mask of BYPSHAD field.
	RTC_CR_BYPSHAD_Msk = 0x20
	// Bit BYPSHAD.
	RTC_CR_BYPSHAD = 0x20
	// Calendar values (when reading from RTC_SSR, RTC_TR, and RTC_DR) are taken from the shadow registers, which are updated once every two RTCCLK cycles
	RTC_CR_BYPSHAD_ShadowReg = 0x0
	// Calendar values (when reading from RTC_SSR, RTC_TR, and RTC_DR) are taken directly from the calendar counters
	RTC_CR_BYPSHAD_BypassShadowReg = 0x1
	// Position of REFCKON field.
	RTC_CR_REFCKON_Pos = 0x4
	// Bit mask of REFCKON field.
	RTC_CR_REFCKON_Msk = 0x10
	// Bit REFCKON.
	RTC_CR_REFCKON = 0x10
	// RTC_REFIN detection disabled
	RTC_CR_REFCKON_Disabled = 0x0
	// RTC_REFIN detection enabled
	RTC_CR_REFCKON_Enabled = 0x1
	// Position of TSEDGE field.
	RTC_CR_TSEDGE_Pos = 0x3
	// Bit mask of TSEDGE field.
	RTC_CR_TSEDGE_Msk = 0x8
	// Bit TSEDGE.
	RTC_CR_TSEDGE = 0x8
	// RTC_TS input rising edge generates a time-stamp event
	RTC_CR_TSEDGE_RisingEdge = 0x0
	// RTC_TS input falling edge generates a time-stamp event
	RTC_CR_TSEDGE_FallingEdge = 0x1
	// Position of WUCKSEL field.
	RTC_CR_WUCKSEL_Pos = 0x0
	// Bit mask of WUCKSEL field.
	RTC_CR_WUCKSEL_Msk = 0x7
	// RTC/16 clock is selected
	RTC_CR_WUCKSEL_Div16 = 0x0
	// RTC/8 clock is selected
	RTC_CR_WUCKSEL_Div8 = 0x1
	// RTC/4 clock is selected
	RTC_CR_WUCKSEL_Div4 = 0x2
	// RTC/2 clock is selected
	RTC_CR_WUCKSEL_Div2 = 0x3
	// ck_spre (usually 1 Hz) clock is selected
	RTC_CR_WUCKSEL_ClockSpare = 0x4
	// ck_spre (usually 1 Hz) clock is selected and 2^16 is added to the WUT counter value
	RTC_CR_WUCKSEL_ClockSpareWithOffset = 0x6

	// ISR: RTC initialization and status register
	// Position of TAMP2F field.
	RTC_ISR_TAMP2F_Pos = 0xe
	// Bit mask of TAMP2F field.
	RTC_ISR_TAMP2F_Msk = 0x4000
	// Bit TAMP2F.
	RTC_ISR_TAMP2F = 0x4000
	// This flag is set by hardware when a tamper detection event is detected on the RTC_TAMPx input
	RTC_ISR_TAMP2F_Tampered = 0x1
	// Flag cleared by software writing 0
	RTC_ISR_TAMP2F_Clear = 0x0
	// Position of TAMP1F field.
	RTC_ISR_TAMP1F_Pos = 0xd
	// Bit mask of TAMP1F field.
	RTC_ISR_TAMP1F_Msk = 0x2000
	// Bit TAMP1F.
	RTC_ISR_TAMP1F = 0x2000
	// This flag is set by hardware when a tamper detection event is detected on the RTC_TAMPx input
	RTC_ISR_TAMP1F_Tampered = 0x1
	// Flag cleared by software writing 0
	RTC_ISR_TAMP1F_Clear = 0x0
	// Position of TSOVF field.
	RTC_ISR_TSOVF_Pos = 0xc
	// Bit mask of TSOVF field.
	RTC_ISR_TSOVF_Msk = 0x1000
	// Bit TSOVF.
	RTC_ISR_TSOVF = 0x1000
	// This flag is set by hardware when a time-stamp event occurs while TSF is already set
	RTC_ISR_TSOVF_Overflow = 0x1
	// This flag is cleared by software by writing 0
	RTC_ISR_TSOVF_Clear = 0x0
	// Position of TSF field.
	RTC_ISR_TSF_Pos = 0xb
	// Bit mask of TSF field.
	RTC_ISR_TSF_Msk = 0x800
	// Bit TSF.
	RTC_ISR_TSF = 0x800
	// This flag is set by hardware when a time-stamp event occurs
	RTC_ISR_TSF_TimestampEvent = 0x1
	// This flag is cleared by software by writing 0
	RTC_ISR_TSF_Clear = 0x0
	// Position of WUTF field.
	RTC_ISR_WUTF_Pos = 0xa
	// Bit mask of WUTF field.
	RTC_ISR_WUTF_Msk = 0x400
	// Bit WUTF.
	RTC_ISR_WUTF = 0x400
	// This flag is set by hardware when the wakeup auto-reload counter reaches 0
	RTC_ISR_WUTF_Zero = 0x1
	// This flag is cleared by software by writing 0
	RTC_ISR_WUTF_Clear = 0x0
	// Position of ALRBF field.
	RTC_ISR_ALRBF_Pos = 0x9
	// Bit mask of ALRBF field.
	RTC_ISR_ALRBF_Msk = 0x200
	// Bit ALRBF.
	RTC_ISR_ALRBF = 0x200
	// This flag is set by hardware when the time/date registers (RTC_TR and RTC_DR) match the Alarm B register (RTC_ALRMBR)
	RTC_ISR_ALRBF_Match = 0x1
	// This flag is cleared by software by writing 0
	RTC_ISR_ALRBF_Clear = 0x0
	// Position of ALRAF field.
	RTC_ISR_ALRAF_Pos = 0x8
	// Bit mask of ALRAF field.
	RTC_ISR_ALRAF_Msk = 0x100
	// Bit ALRAF.
	RTC_ISR_ALRAF = 0x100
	// This flag is set by hardware when the time/date registers (RTC_TR and RTC_DR) match the Alarm A register (RTC_ALRMAR)
	RTC_ISR_ALRAF_Match = 0x1
	// This flag is cleared by software by writing 0
	RTC_ISR_ALRAF_Clear = 0x0
	// Position of INIT field.
	RTC_ISR_INIT_Pos = 0x7
	// Bit mask of INIT field.
	RTC_ISR_INIT_Msk = 0x80
	// Bit INIT.
	RTC_ISR_INIT = 0x80
	// Free running mode
	RTC_ISR_INIT_FreeRunningMode = 0x0
	// Initialization mode used to program time and date register (RTC_TR and RTC_DR), and prescaler register (RTC_PRER). Counters are stopped and start counting from the new value when INIT is reset.
	RTC_ISR_INIT_InitMode = 0x1
	// Position of INITF field.
	RTC_ISR_INITF_Pos = 0x6
	// Bit mask of INITF field.
	RTC_ISR_INITF_Msk = 0x40
	// Bit INITF.
	RTC_ISR_INITF = 0x40
	// Calendar registers update is not allowed
	RTC_ISR_INITF_NotAllowed = 0x0
	// Calendar registers update is allowed
	RTC_ISR_INITF_Allowed = 0x1
	// Position of RSF field.
	RTC_ISR_RSF_Pos = 0x5
	// Bit mask of RSF field.
	RTC_ISR_RSF_Msk = 0x20
	// Bit RSF.
	RTC_ISR_RSF = 0x20
	// Calendar shadow registers not yet synchronized
	RTC_ISR_RSF_NotSynced = 0x0
	// Calendar shadow registers synchronized
	RTC_ISR_RSF_Synced = 0x1
	// This flag is cleared by software by writing 0
	RTC_ISR_RSF_Clear = 0x0
	// Position of INITS field.
	RTC_ISR_INITS_Pos = 0x4
	// Bit mask of INITS field.
	RTC_ISR_INITS_Msk = 0x10
	// Bit INITS.
	RTC_ISR_INITS = 0x10
	// Calendar has not been initialized
	RTC_ISR_INITS_NotInitalized = 0x0
	// Calendar has been initialized
	RTC_ISR_INITS_Initalized = 0x1
	// Position of SHPF field.
	RTC_ISR_SHPF_Pos = 0x3
	// Bit mask of SHPF field.
	RTC_ISR_SHPF_Msk = 0x8
	// Bit SHPF.
	RTC_ISR_SHPF = 0x8
	// No shift operation is pending
	RTC_ISR_SHPF_NoShiftPending = 0x0
	// A shift operation is pending
	RTC_ISR_SHPF_ShiftPending = 0x1
	// Position of WUTWF field.
	RTC_ISR_WUTWF_Pos = 0x2
	// Bit mask of WUTWF field.
	RTC_ISR_WUTWF_Msk = 0x4
	// Bit WUTWF.
	RTC_ISR_WUTWF = 0x4
	// Wakeup timer configuration update not allowed
	RTC_ISR_WUTWF_UpdateNotAllowed = 0x0
	// Wakeup timer configuration update allowed
	RTC_ISR_WUTWF_UpdateAllowed = 0x1
	// Position of ALRBWF field.
	RTC_ISR_ALRBWF_Pos = 0x1
	// Bit mask of ALRBWF field.
	RTC_ISR_ALRBWF_Msk = 0x2
	// Bit ALRBWF.
	RTC_ISR_ALRBWF = 0x2
	// Alarm update not allowed
	RTC_ISR_ALRBWF_UpdateNotAllowed = 0x0
	// Alarm update allowed
	RTC_ISR_ALRBWF_UpdateAllowed = 0x1
	// Position of ALRAWF field.
	RTC_ISR_ALRAWF_Pos = 0x0
	// Bit mask of ALRAWF field.
	RTC_ISR_ALRAWF_Msk = 0x1
	// Bit ALRAWF.
	RTC_ISR_ALRAWF = 0x1
	// Alarm update not allowed
	RTC_ISR_ALRAWF_UpdateNotAllowed = 0x0
	// Alarm update allowed
	RTC_ISR_ALRAWF_UpdateAllowed = 0x1
	// Position of RECALPF field.
	RTC_ISR_RECALPF_Pos = 0x10
	// Bit mask of RECALPF field.
	RTC_ISR_RECALPF_Msk = 0x10000
	// Bit RECALPF.
	RTC_ISR_RECALPF = 0x10000
	// The RECALPF status flag is automatically set to 1 when software writes to the RTC_CALR register, indicating that the RTC_CALR register is blocked. When the new calibration settings are taken into account, this bit returns to 0
	RTC_ISR_RECALPF_Pending = 0x1
	// Position of TAMP3F field.
	RTC_ISR_TAMP3F_Pos = 0xf
	// Bit mask of TAMP3F field.
	RTC_ISR_TAMP3F_Msk = 0x8000
	// Bit TAMP3F.
	RTC_ISR_TAMP3F = 0x8000
	// This flag is set by hardware when a tamper detection event is detected on the RTC_TAMPx input
	RTC_ISR_TAMP3F_Tampered = 0x1
	// Flag cleared by software writing 0
	RTC_ISR_TAMP3F_Clear = 0x0

	// PRER: RTC prescaler register
	// Position of PREDIV_A field.
	RTC_PRER_PREDIV_A_Pos = 0x10
	// Bit mask of PREDIV_A field.
	RTC_PRER_PREDIV_A_Msk = 0x7f0000
	// Position of PREDIV_S field.
	RTC_PRER_PREDIV_S_Pos = 0x0
	// Bit mask of PREDIV_S field.
	RTC_PRER_PREDIV_S_Msk = 0xffff

	// WUTR: RTC wakeup timer register
	// Position of WUT field.
	RTC_WUTR_WUT_Pos = 0x0
	// Bit mask of WUT field.
	RTC_WUTR_WUT_Msk = 0xffff

	// ALRMAR: RTC alarm A register
	// Position of MSK4 field.
	RTC_ALRMAR_MSK4_Pos = 0x1f
	// Bit mask of MSK4 field.
	RTC_ALRMAR_MSK4_Msk = 0x80000000
	// Bit MSK4.
	RTC_ALRMAR_MSK4 = 0x80000000
	// Alarm set if the date/day match
	RTC_ALRMAR_MSK4_Mask = 0x0
	// Date/day don’t care in Alarm comparison
	RTC_ALRMAR_MSK4_NotMask = 0x1
	// Position of WDSEL field.
	RTC_ALRMAR_WDSEL_Pos = 0x1e
	// Bit mask of WDSEL field.
	RTC_ALRMAR_WDSEL_Msk = 0x40000000
	// Bit WDSEL.
	RTC_ALRMAR_WDSEL = 0x40000000
	// DU[3:0] represents the date units
	RTC_ALRMAR_WDSEL_DateUnits = 0x0
	// DU[3:0] represents the week day. DT[1:0] is don’t care.
	RTC_ALRMAR_WDSEL_WeekDay = 0x1
	// Position of DT field.
	RTC_ALRMAR_DT_Pos = 0x1c
	// Bit mask of DT field.
	RTC_ALRMAR_DT_Msk = 0x30000000
	// Position of DU field.
	RTC_ALRMAR_DU_Pos = 0x18
	// Bit mask of DU field.
	RTC_ALRMAR_DU_Msk = 0xf000000
	// Position of MSK3 field.
	RTC_ALRMAR_MSK3_Pos = 0x17
	// Bit mask of MSK3 field.
	RTC_ALRMAR_MSK3_Msk = 0x800000
	// Bit MSK3.
	RTC_ALRMAR_MSK3 = 0x800000
	// Alarm set if the date/day match
	RTC_ALRMAR_MSK3_Mask = 0x0
	// Date/day don’t care in Alarm comparison
	RTC_ALRMAR_MSK3_NotMask = 0x1
	// Position of PM field.
	RTC_ALRMAR_PM_Pos = 0x16
	// Bit mask of PM field.
	RTC_ALRMAR_PM_Msk = 0x400000
	// Bit PM.
	RTC_ALRMAR_PM = 0x400000
	// AM or 24-hour format
	RTC_ALRMAR_PM_AM = 0x0
	// PM
	RTC_ALRMAR_PM_PM = 0x1
	// Position of HT field.
	RTC_ALRMAR_HT_Pos = 0x14
	// Bit mask of HT field.
	RTC_ALRMAR_HT_Msk = 0x300000
	// Position of HU field.
	RTC_ALRMAR_HU_Pos = 0x10
	// Bit mask of HU field.
	RTC_ALRMAR_HU_Msk = 0xf0000
	// Position of MSK2 field.
	RTC_ALRMAR_MSK2_Pos = 0xf
	// Bit mask of MSK2 field.
	RTC_ALRMAR_MSK2_Msk = 0x8000
	// Bit MSK2.
	RTC_ALRMAR_MSK2 = 0x8000
	// Alarm set if the date/day match
	RTC_ALRMAR_MSK2_Mask = 0x0
	// Date/day don’t care in Alarm comparison
	RTC_ALRMAR_MSK2_NotMask = 0x1
	// Position of MNT field.
	RTC_ALRMAR_MNT_Pos = 0xc
	// Bit mask of MNT field.
	RTC_ALRMAR_MNT_Msk = 0x7000
	// Position of MNU field.
	RTC_ALRMAR_MNU_Pos = 0x8
	// Bit mask of MNU field.
	RTC_ALRMAR_MNU_Msk = 0xf00
	// Position of MSK1 field.
	RTC_ALRMAR_MSK1_Pos = 0x7
	// Bit mask of MSK1 field.
	RTC_ALRMAR_MSK1_Msk = 0x80
	// Bit MSK1.
	RTC_ALRMAR_MSK1 = 0x80
	// Alarm set if the date/day match
	RTC_ALRMAR_MSK1_Mask = 0x0
	// Date/day don’t care in Alarm comparison
	RTC_ALRMAR_MSK1_NotMask = 0x1
	// Position of ST field.
	RTC_ALRMAR_ST_Pos = 0x4
	// Bit mask of ST field.
	RTC_ALRMAR_ST_Msk = 0x70
	// Position of SU field.
	RTC_ALRMAR_SU_Pos = 0x0
	// Bit mask of SU field.
	RTC_ALRMAR_SU_Msk = 0xf

	// ALRMBR: RTC alarm B register
	// Position of MSK4 field.
	RTC_ALRMBR_MSK4_Pos = 0x1f
	// Bit mask of MSK4 field.
	RTC_ALRMBR_MSK4_Msk = 0x80000000
	// Bit MSK4.
	RTC_ALRMBR_MSK4 = 0x80000000
	// Alarm set if the date/day match
	RTC_ALRMBR_MSK4_Mask = 0x0
	// Date/day don’t care in Alarm comparison
	RTC_ALRMBR_MSK4_NotMask = 0x1
	// Position of WDSEL field.
	RTC_ALRMBR_WDSEL_Pos = 0x1e
	// Bit mask of WDSEL field.
	RTC_ALRMBR_WDSEL_Msk = 0x40000000
	// Bit WDSEL.
	RTC_ALRMBR_WDSEL = 0x40000000
	// DU[3:0] represents the date units
	RTC_ALRMBR_WDSEL_DateUnits = 0x0
	// DU[3:0] represents the week day. DT[1:0] is don’t care.
	RTC_ALRMBR_WDSEL_WeekDay = 0x1
	// Position of DT field.
	RTC_ALRMBR_DT_Pos = 0x1c
	// Bit mask of DT field.
	RTC_ALRMBR_DT_Msk = 0x30000000
	// Position of DU field.
	RTC_ALRMBR_DU_Pos = 0x18
	// Bit mask of DU field.
	RTC_ALRMBR_DU_Msk = 0xf000000
	// Position of MSK3 field.
	RTC_ALRMBR_MSK3_Pos = 0x17
	// Bit mask of MSK3 field.
	RTC_ALRMBR_MSK3_Msk = 0x800000
	// Bit MSK3.
	RTC_ALRMBR_MSK3 = 0x800000
	// Alarm set if the date/day match
	RTC_ALRMBR_MSK3_Mask = 0x0
	// Date/day don’t care in Alarm comparison
	RTC_ALRMBR_MSK3_NotMask = 0x1
	// Position of PM field.
	RTC_ALRMBR_PM_Pos = 0x16
	// Bit mask of PM field.
	RTC_ALRMBR_PM_Msk = 0x400000
	// Bit PM.
	RTC_ALRMBR_PM = 0x400000
	// AM or 24-hour format
	RTC_ALRMBR_PM_AM = 0x0
	// PM
	RTC_ALRMBR_PM_PM = 0x1
	// Position of HT field.
	RTC_ALRMBR_HT_Pos = 0x14
	// Bit mask of HT field.
	RTC_ALRMBR_HT_Msk = 0x300000
	// Position of HU field.
	RTC_ALRMBR_HU_Pos = 0x10
	// Bit mask of HU field.
	RTC_ALRMBR_HU_Msk = 0xf0000
	// Position of MSK2 field.
	RTC_ALRMBR_MSK2_Pos = 0xf
	// Bit mask of MSK2 field.
	RTC_ALRMBR_MSK2_Msk = 0x8000
	// Bit MSK2.
	RTC_ALRMBR_MSK2 = 0x8000
	// Alarm set if the date/day match
	RTC_ALRMBR_MSK2_Mask = 0x0
	// Date/day don’t care in Alarm comparison
	RTC_ALRMBR_MSK2_NotMask = 0x1
	// Position of MNT field.
	RTC_ALRMBR_MNT_Pos = 0xc
	// Bit mask of MNT field.
	RTC_ALRMBR_MNT_Msk = 0x7000
	// Position of MNU field.
	RTC_ALRMBR_MNU_Pos = 0x8
	// Bit mask of MNU field.
	RTC_ALRMBR_MNU_Msk = 0xf00
	// Position of MSK1 field.
	RTC_ALRMBR_MSK1_Pos = 0x7
	// Bit mask of MSK1 field.
	RTC_ALRMBR_MSK1_Msk = 0x80
	// Bit MSK1.
	RTC_ALRMBR_MSK1 = 0x80
	// Alarm set if the date/day match
	RTC_ALRMBR_MSK1_Mask = 0x0
	// Date/day don’t care in Alarm comparison
	RTC_ALRMBR_MSK1_NotMask = 0x1
	// Position of ST field.
	RTC_ALRMBR_ST_Pos = 0x4
	// Bit mask of ST field.
	RTC_ALRMBR_ST_Msk = 0x70
	// Position of SU field.
	RTC_ALRMBR_SU_Pos = 0x0
	// Bit mask of SU field.
	RTC_ALRMBR_SU_Msk = 0xf

	// WPR: write protection register
	// Position of KEY field.
	RTC_WPR_KEY_Pos = 0x0
	// Bit mask of KEY field.
	RTC_WPR_KEY_Msk = 0xff

	// SSR: RTC sub second register
	// Position of SS field.
	RTC_SSR_SS_Pos = 0x0
	// Bit mask of SS field.
	RTC_SSR_SS_Msk = 0xffff

	// SHIFTR: RTC shift control register
	// Position of ADD1S field.
	RTC_SHIFTR_ADD1S_Pos = 0x1f
	// Bit mask of ADD1S field.
	RTC_SHIFTR_ADD1S_Msk = 0x80000000
	// Bit ADD1S.
	RTC_SHIFTR_ADD1S = 0x80000000
	// Add one second to the clock/calendar
	RTC_SHIFTR_ADD1S_Add1 = 0x1
	// Position of SUBFS field.
	RTC_SHIFTR_SUBFS_Pos = 0x0
	// Bit mask of SUBFS field.
	RTC_SHIFTR_SUBFS_Msk = 0x7fff

	// TSTR: RTC timestamp time register
	// Position of PM field.
	RTC_TSTR_PM_Pos = 0x16
	// Bit mask of PM field.
	RTC_TSTR_PM_Msk = 0x400000
	// Bit PM.
	RTC_TSTR_PM = 0x400000
	// Position of HT field.
	RTC_TSTR_HT_Pos = 0x14
	// Bit mask of HT field.
	RTC_TSTR_HT_Msk = 0x300000
	// Position of HU field.
	RTC_TSTR_HU_Pos = 0x10
	// Bit mask of HU field.
	RTC_TSTR_HU_Msk = 0xf0000
	// Position of MNT field.
	RTC_TSTR_MNT_Pos = 0xc
	// Bit mask of MNT field.
	RTC_TSTR_MNT_Msk = 0x7000
	// Position of MNU field.
	RTC_TSTR_MNU_Pos = 0x8
	// Bit mask of MNU field.
	RTC_TSTR_MNU_Msk = 0xf00
	// Position of ST field.
	RTC_TSTR_ST_Pos = 0x4
	// Bit mask of ST field.
	RTC_TSTR_ST_Msk = 0x70
	// Position of SU field.
	RTC_TSTR_SU_Pos = 0x0
	// Bit mask of SU field.
	RTC_TSTR_SU_Msk = 0xf

	// TSDR: RTC timestamp date register
	// Position of WDU field.
	RTC_TSDR_WDU_Pos = 0xd
	// Bit mask of WDU field.
	RTC_TSDR_WDU_Msk = 0xe000
	// Position of MT field.
	RTC_TSDR_MT_Pos = 0xc
	// Bit mask of MT field.
	RTC_TSDR_MT_Msk = 0x1000
	// Bit MT.
	RTC_TSDR_MT = 0x1000
	// Position of MU field.
	RTC_TSDR_MU_Pos = 0x8
	// Bit mask of MU field.
	RTC_TSDR_MU_Msk = 0xf00
	// Position of DT field.
	RTC_TSDR_DT_Pos = 0x4
	// Bit mask of DT field.
	RTC_TSDR_DT_Msk = 0x30
	// Position of DU field.
	RTC_TSDR_DU_Pos = 0x0
	// Bit mask of DU field.
	RTC_TSDR_DU_Msk = 0xf

	// TSSSR: RTC time-stamp sub second register
	// Position of SS field.
	RTC_TSSSR_SS_Pos = 0x0
	// Bit mask of SS field.
	RTC_TSSSR_SS_Msk = 0xffff

	// CALR: RTC calibration register
	// Position of CALP field.
	RTC_CALR_CALP_Pos = 0xf
	// Bit mask of CALP field.
	RTC_CALR_CALP_Msk = 0x8000
	// Bit CALP.
	RTC_CALR_CALP = 0x8000
	// No RTCCLK pulses are added
	RTC_CALR_CALP_NoChange = 0x0
	// One RTCCLK pulse is effectively inserted every 2^11 pulses (frequency increased by 488.5 ppm)
	RTC_CALR_CALP_IncreaseFreq = 0x1
	// Position of CALW8 field.
	RTC_CALR_CALW8_Pos = 0xe
	// Bit mask of CALW8 field.
	RTC_CALR_CALW8_Msk = 0x4000
	// Bit CALW8.
	RTC_CALR_CALW8 = 0x4000
	// When CALW8 is set to ‘1’, the 8-second calibration cycle period is selected
	RTC_CALR_CALW8_Eight_Second = 0x1
	// Position of CALW16 field.
	RTC_CALR_CALW16_Pos = 0xd
	// Bit mask of CALW16 field.
	RTC_CALR_CALW16_Msk = 0x2000
	// Bit CALW16.
	RTC_CALR_CALW16 = 0x2000
	// When CALW16 is set to ‘1’, the 16-second calibration cycle period is selected.This bit must not be set to ‘1’ if CALW8=1
	RTC_CALR_CALW16_Sixteen_Second = 0x1
	// Position of CALM field.
	RTC_CALR_CALM_Pos = 0x0
	// Bit mask of CALM field.
	RTC_CALR_CALM_Msk = 0x1ff

	// TAMPCR: RTC tamper configuration register
	// Position of TAMP2MF field.
	RTC_TAMPCR_TAMP2MF_Pos = 0x15
	// Bit mask of TAMP2MF field.
	RTC_TAMPCR_TAMP2MF_Msk = 0x200000
	// Bit TAMP2MF.
	RTC_TAMPCR_TAMP2MF = 0x200000
	// Tamper x event generates a trigger event and TAMPxF must be cleared by software to allow next tamper event detection
	RTC_TAMPCR_TAMP2MF_NotMasked = 0x0
	// Tamper x event generates a trigger event. TAMPxF is masked and internally cleared by hardware. The backup registers are not erased.
	RTC_TAMPCR_TAMP2MF_Masked = 0x1
	// Position of TAMP2NOERASE field.
	RTC_TAMPCR_TAMP2NOERASE_Pos = 0x14
	// Bit mask of TAMP2NOERASE field.
	RTC_TAMPCR_TAMP2NOERASE_Msk = 0x100000
	// Bit TAMP2NOERASE.
	RTC_TAMPCR_TAMP2NOERASE = 0x100000
	// Tamper x event erases the backup registers
	RTC_TAMPCR_TAMP2NOERASE_Erase = 0x0
	// Tamper x event does not erase the backup registers
	RTC_TAMPCR_TAMP2NOERASE_NoErase = 0x1
	// Position of TAMP2IE field.
	RTC_TAMPCR_TAMP2IE_Pos = 0x13
	// Bit mask of TAMP2IE field.
	RTC_TAMPCR_TAMP2IE_Msk = 0x80000
	// Bit TAMP2IE.
	RTC_TAMPCR_TAMP2IE = 0x80000
	// Tamper x interrupt is disabled if TAMPIE = 0
	RTC_TAMPCR_TAMP2IE_Disabled = 0x0
	// Tamper x interrupt enabled
	RTC_TAMPCR_TAMP2IE_Enabled = 0x1
	// Position of TAMP1MF field.
	RTC_TAMPCR_TAMP1MF_Pos = 0x12
	// Bit mask of TAMP1MF field.
	RTC_TAMPCR_TAMP1MF_Msk = 0x40000
	// Bit TAMP1MF.
	RTC_TAMPCR_TAMP1MF = 0x40000
	// Tamper x event generates a trigger event and TAMPxF must be cleared by software to allow next tamper event detection
	RTC_TAMPCR_TAMP1MF_NotMasked = 0x0
	// Tamper x event generates a trigger event. TAMPxF is masked and internally cleared by hardware. The backup registers are not erased.
	RTC_TAMPCR_TAMP1MF_Masked = 0x1
	// Position of TAMP1NOERASE field.
	RTC_TAMPCR_TAMP1NOERASE_Pos = 0x11
	// Bit mask of TAMP1NOERASE field.
	RTC_TAMPCR_TAMP1NOERASE_Msk = 0x20000
	// Bit TAMP1NOERASE.
	RTC_TAMPCR_TAMP1NOERASE = 0x20000
	// Tamper x event erases the backup registers
	RTC_TAMPCR_TAMP1NOERASE_Erase = 0x0
	// Tamper x event does not erase the backup registers
	RTC_TAMPCR_TAMP1NOERASE_NoErase = 0x1
	// Position of TAMP1IE field.
	RTC_TAMPCR_TAMP1IE_Pos = 0x10
	// Bit mask of TAMP1IE field.
	RTC_TAMPCR_TAMP1IE_Msk = 0x10000
	// Bit TAMP1IE.
	RTC_TAMPCR_TAMP1IE = 0x10000
	// Tamper x interrupt is disabled if TAMPIE = 0
	RTC_TAMPCR_TAMP1IE_Disabled = 0x0
	// Tamper x interrupt enabled
	RTC_TAMPCR_TAMP1IE_Enabled = 0x1
	// Position of TAMPPUDIS field.
	RTC_TAMPCR_TAMPPUDIS_Pos = 0xf
	// Bit mask of TAMPPUDIS field.
	RTC_TAMPCR_TAMPPUDIS_Msk = 0x8000
	// Bit TAMPPUDIS.
	RTC_TAMPCR_TAMPPUDIS = 0x8000
	// Precharge RTC_TAMPx pins before sampling (enable internal pull-up)
	RTC_TAMPCR_TAMPPUDIS_Enabled = 0x0
	// Disable precharge of RTC_TAMPx pins
	RTC_TAMPCR_TAMPPUDIS_Disabled = 0x1
	// Position of TAMPPRCH field.
	RTC_TAMPCR_TAMPPRCH_Pos = 0xd
	// Bit mask of TAMPPRCH field.
	RTC_TAMPCR_TAMPPRCH_Msk = 0x6000
	// 1 RTCCLK cycle
	RTC_TAMPCR_TAMPPRCH_Cycles1 = 0x0
	// 2 RTCCLK cycles
	RTC_TAMPCR_TAMPPRCH_Cycles2 = 0x1
	// 4 RTCCLK cycles
	RTC_TAMPCR_TAMPPRCH_Cycles4 = 0x2
	// 8 RTCCLK cycles
	RTC_TAMPCR_TAMPPRCH_Cycles8 = 0x3
	// Position of TAMPFLT field.
	RTC_TAMPCR_TAMPFLT_Pos = 0xb
	// Bit mask of TAMPFLT field.
	RTC_TAMPCR_TAMPFLT_Msk = 0x1800
	// Tamper event is activated on edge of RTC_TAMPx input transitions to the active level (no internal pull-up on RTC_TAMPx input)
	RTC_TAMPCR_TAMPFLT_Immediate = 0x0
	// Tamper event is activated after 2 consecutive samples at the active level
	RTC_TAMPCR_TAMPFLT_Samples2 = 0x1
	// Tamper event is activated after 4 consecutive samples at the active level
	RTC_TAMPCR_TAMPFLT_Samples4 = 0x2
	// Tamper event is activated after 8 consecutive samples at the active level
	RTC_TAMPCR_TAMPFLT_Samples8 = 0x3
	// Position of TAMPFREQ field.
	RTC_TAMPCR_TAMPFREQ_Pos = 0x8
	// Bit mask of TAMPFREQ field.
	RTC_TAMPCR_TAMPFREQ_Msk = 0x700
	// RTCCLK / 32768 (1 Hz when RTCCLK = 32768 Hz)
	RTC_TAMPCR_TAMPFREQ_Div32768 = 0x0
	// RTCCLK / 16384 (2 Hz when RTCCLK = 32768 Hz)
	RTC_TAMPCR_TAMPFREQ_Div16384 = 0x1
	// RTCCLK / 8192 (4 Hz when RTCCLK = 32768 Hz)
	RTC_TAMPCR_TAMPFREQ_Div8192 = 0x2
	// RTCCLK / 4096 (8 Hz when RTCCLK = 32768 Hz)
	RTC_TAMPCR_TAMPFREQ_Div4096 = 0x3
	// RTCCLK / 2048 (16 Hz when RTCCLK = 32768 Hz)
	RTC_TAMPCR_TAMPFREQ_Div2048 = 0x4
	// RTCCLK / 1024 (32 Hz when RTCCLK = 32768 Hz)
	RTC_TAMPCR_TAMPFREQ_Div1024 = 0x5
	// RTCCLK / 512 (64 Hz when RTCCLK = 32768 Hz)
	RTC_TAMPCR_TAMPFREQ_Div512 = 0x6
	// RTCCLK / 256 (128 Hz when RTCCLK = 32768 Hz)
	RTC_TAMPCR_TAMPFREQ_Div256 = 0x7
	// Position of TAMPTS field.
	RTC_TAMPCR_TAMPTS_Pos = 0x7
	// Bit mask of TAMPTS field.
	RTC_TAMPCR_TAMPTS_Msk = 0x80
	// Bit TAMPTS.
	RTC_TAMPCR_TAMPTS = 0x80
	// Tamper detection event does not cause a timestamp to be saved
	RTC_TAMPCR_TAMPTS_NoSave = 0x0
	// Save timestamp on tamper detection event
	RTC_TAMPCR_TAMPTS_Save = 0x1
	// Position of TAMP2TRG field.
	RTC_TAMPCR_TAMP2TRG_Pos = 0x4
	// Bit mask of TAMP2TRG field.
	RTC_TAMPCR_TAMP2TRG_Msk = 0x10
	// Bit TAMP2TRG.
	RTC_TAMPCR_TAMP2TRG = 0x10
	// If TAMPFLT = 00: RTC_TAMPx input rising edge triggers a tamper detection event. If TAMPFLT ≠ 00: RTC_TAMPx input staying low triggers a tamper detection event.
	RTC_TAMPCR_TAMP2TRG_RisingEdge = 0x0
	// If TAMPFLT = 00: RTC_TAMPx input staying high triggers a tamper detection event. If TAMPFLT ≠ 00: RTC_TAMPx input falling edge triggers a tamper detection event
	RTC_TAMPCR_TAMP2TRG_FallingEdge = 0x1
	// Position of TAMP2E field.
	RTC_TAMPCR_TAMP2E_Pos = 0x3
	// Bit mask of TAMP2E field.
	RTC_TAMPCR_TAMP2E_Msk = 0x8
	// Bit TAMP2E.
	RTC_TAMPCR_TAMP2E = 0x8
	// RTC_TAMPx input detection disabled
	RTC_TAMPCR_TAMP2E_Disabled = 0x0
	// RTC_TAMPx input detection enabled
	RTC_TAMPCR_TAMP2E_Enabled = 0x1
	// Position of TAMPIE field.
	RTC_TAMPCR_TAMPIE_Pos = 0x2
	// Bit mask of TAMPIE field.
	RTC_TAMPCR_TAMPIE_Msk = 0x4
	// Bit TAMPIE.
	RTC_TAMPCR_TAMPIE = 0x4
	// Tamper interrupt disabled
	RTC_TAMPCR_TAMPIE_Disabled = 0x0
	// Tamper interrupt enabled
	RTC_TAMPCR_TAMPIE_Enabled = 0x1
	// Position of TAMP1TRG field.
	RTC_TAMPCR_TAMP1TRG_Pos = 0x1
	// Bit mask of TAMP1TRG field.
	RTC_TAMPCR_TAMP1TRG_Msk = 0x2
	// Bit TAMP1TRG.
	RTC_TAMPCR_TAMP1TRG = 0x2
	// If TAMPFLT = 00: RTC_TAMPx input rising edge triggers a tamper detection event. If TAMPFLT ≠ 00: RTC_TAMPx input staying low triggers a tamper detection event.
	RTC_TAMPCR_TAMP1TRG_RisingEdge = 0x0
	// If TAMPFLT = 00: RTC_TAMPx input staying high triggers a tamper detection event. If TAMPFLT ≠ 00: RTC_TAMPx input falling edge triggers a tamper detection event
	RTC_TAMPCR_TAMP1TRG_FallingEdge = 0x1
	// Position of TAMP1E field.
	RTC_TAMPCR_TAMP1E_Pos = 0x0
	// Bit mask of TAMP1E field.
	RTC_TAMPCR_TAMP1E_Msk = 0x1
	// Bit TAMP1E.
	RTC_TAMPCR_TAMP1E = 0x1
	// RTC_TAMPx input detection disabled
	RTC_TAMPCR_TAMP1E_Disabled = 0x0
	// RTC_TAMPx input detection enabled
	RTC_TAMPCR_TAMP1E_Enabled = 0x1
	// Position of TAMP3MF field.
	RTC_TAMPCR_TAMP3MF_Pos = 0x18
	// Bit mask of TAMP3MF field.
	RTC_TAMPCR_TAMP3MF_Msk = 0x1000000
	// Bit TAMP3MF.
	RTC_TAMPCR_TAMP3MF = 0x1000000
	// Tamper x event generates a trigger event and TAMPxF must be cleared by software to allow next tamper event detection
	RTC_TAMPCR_TAMP3MF_NotMasked = 0x0
	// Tamper x event generates a trigger event. TAMPxF is masked and internally cleared by hardware. The backup registers are not erased.
	RTC_TAMPCR_TAMP3MF_Masked = 0x1
	// Position of TAMP3NOERASE field.
	RTC_TAMPCR_TAMP3NOERASE_Pos = 0x17
	// Bit mask of TAMP3NOERASE field.
	RTC_TAMPCR_TAMP3NOERASE_Msk = 0x800000
	// Bit TAMP3NOERASE.
	RTC_TAMPCR_TAMP3NOERASE = 0x800000
	// Tamper x event erases the backup registers
	RTC_TAMPCR_TAMP3NOERASE_Erase = 0x0
	// Tamper x event does not erase the backup registers
	RTC_TAMPCR_TAMP3NOERASE_NoErase = 0x1
	// Position of TAMP3IE field.
	RTC_TAMPCR_TAMP3IE_Pos = 0x16
	// Bit mask of TAMP3IE field.
	RTC_TAMPCR_TAMP3IE_Msk = 0x400000
	// Bit TAMP3IE.
	RTC_TAMPCR_TAMP3IE = 0x400000
	// Tamper x interrupt is disabled if TAMPIE = 0
	RTC_TAMPCR_TAMP3IE_Disabled = 0x0
	// Tamper x interrupt enabled
	RTC_TAMPCR_TAMP3IE_Enabled = 0x1
	// Position of TAMP3TRG field.
	RTC_TAMPCR_TAMP3TRG_Pos = 0x6
	// Bit mask of TAMP3TRG field.
	RTC_TAMPCR_TAMP3TRG_Msk = 0x40
	// Bit TAMP3TRG.
	RTC_TAMPCR_TAMP3TRG = 0x40
	// If TAMPFLT = 00: RTC_TAMPx input rising edge triggers a tamper detection event. If TAMPFLT ≠ 00: RTC_TAMPx input staying low triggers a tamper detection event.
	RTC_TAMPCR_TAMP3TRG_RisingEdge = 0x0
	// If TAMPFLT = 00: RTC_TAMPx input staying high triggers a tamper detection event. If TAMPFLT ≠ 00: RTC_TAMPx input falling edge triggers a tamper detection event
	RTC_TAMPCR_TAMP3TRG_FallingEdge = 0x1
	// Position of TAMP3E field.
	RTC_TAMPCR_TAMP3E_Pos = 0x5
	// Bit mask of TAMP3E field.
	RTC_TAMPCR_TAMP3E_Msk = 0x20
	// Bit TAMP3E.
	RTC_TAMPCR_TAMP3E = 0x20
	// RTC_TAMPx input detection disabled
	RTC_TAMPCR_TAMP3E_Disabled = 0x0
	// RTC_TAMPx input detection enabled
	RTC_TAMPCR_TAMP3E_Enabled = 0x1

	// ALRMASSR: RTC alarm A sub second register
	// Position of MASKSS field.
	RTC_ALRMASSR_MASKSS_Pos = 0x18
	// Bit mask of MASKSS field.
	RTC_ALRMASSR_MASKSS_Msk = 0xf000000
	// Position of SS field.
	RTC_ALRMASSR_SS_Pos = 0x0
	// Bit mask of SS field.
	RTC_ALRMASSR_SS_Msk = 0x7fff

	// ALRMBSSR: RTC alarm B sub second register
	// Position of MASKSS field.
	RTC_ALRMBSSR_MASKSS_Pos = 0x18
	// Bit mask of MASKSS field.
	RTC_ALRMBSSR_MASKSS_Msk = 0xf000000
	// Position of SS field.
	RTC_ALRMBSSR_SS_Pos = 0x0
	// Bit mask of SS field.
	RTC_ALRMBSSR_SS_Msk = 0x7fff

	// OR: option register
	// Position of RTC_OUT_RMP field.
	RTC_OR_RTC_OUT_RMP_Pos = 0x1
	// Bit mask of RTC_OUT_RMP field.
	RTC_OR_RTC_OUT_RMP_Msk = 0x2
	// Bit RTC_OUT_RMP.
	RTC_OR_RTC_OUT_RMP = 0x2
	// Position of RTC_ALARM_TYPE field.
	RTC_OR_RTC_ALARM_TYPE_Pos = 0x0
	// Bit mask of RTC_ALARM_TYPE field.
	RTC_OR_RTC_ALARM_TYPE_Msk = 0x1
	// Bit RTC_ALARM_TYPE.
	RTC_OR_RTC_ALARM_TYPE = 0x1

	// BKP0R: RTC backup registers
	// Position of BKP field.
	RTC_BKPR_BKP_Pos = 0x0
	// Bit mask of BKP field.
	RTC_BKPR_BKP_Msk = 0xffffffff
)

// Bitfields for USART1: Universal synchronous asynchronous receiver transmitter
const (
	// CR1: Control register 1
	// Position of M1 field.
	USART_CR1_M1_Pos = 0x1c
	// Bit mask of M1 field.
	USART_CR1_M1_Msk = 0x10000000
	// Bit M1.
	USART_CR1_M1 = 0x10000000
	// Use M0 to set the data bits
	USART_CR1_M1_M0 = 0x0
	// 1 start bit, 7 data bits, n stop bits
	USART_CR1_M1_Bit7 = 0x1
	// Position of EOBIE field.
	USART_CR1_EOBIE_Pos = 0x1b
	// Bit mask of EOBIE field.
	USART_CR1_EOBIE_Msk = 0x8000000
	// Bit EOBIE.
	USART_CR1_EOBIE = 0x8000000
	// Interrupt is inhibited
	USART_CR1_EOBIE_Disabled = 0x0
	// A USART interrupt is generated when the EOBF flag is set in the ISR register
	USART_CR1_EOBIE_Enabled = 0x1
	// Position of RTOIE field.
	USART_CR1_RTOIE_Pos = 0x1a
	// Bit mask of RTOIE field.
	USART_CR1_RTOIE_Msk = 0x4000000
	// Bit RTOIE.
	USART_CR1_RTOIE = 0x4000000
	// Interrupt is inhibited
	USART_CR1_RTOIE_Disabled = 0x0
	// An USART interrupt is generated when the RTOF bit is set in the ISR register
	USART_CR1_RTOIE_Enabled = 0x1
	// Position of OVER8 field.
	USART_CR1_OVER8_Pos = 0xf
	// Bit mask of OVER8 field.
	USART_CR1_OVER8_Msk = 0x8000
	// Bit OVER8.
	USART_CR1_OVER8 = 0x8000
	// Oversampling by 16
	USART_CR1_OVER8_Oversampling16 = 0x0
	// Oversampling by 8
	USART_CR1_OVER8_Oversampling8 = 0x1
	// Position of CMIE field.
	USART_CR1_CMIE_Pos = 0xe
	// Bit mask of CMIE field.
	USART_CR1_CMIE_Msk = 0x4000
	// Bit CMIE.
	USART_CR1_CMIE = 0x4000
	// Interrupt is disabled
	USART_CR1_CMIE_Disabled = 0x0
	// Interrupt is generated when the CMF bit is set in the ISR register
	USART_CR1_CMIE_Enabled = 0x1
	// Position of MME field.
	USART_CR1_MME_Pos = 0xd
	// Bit mask of MME field.
	USART_CR1_MME_Msk = 0x2000
	// Bit MME.
	USART_CR1_MME = 0x2000
	// Receiver in active mode permanently
	USART_CR1_MME_Disabled = 0x0
	// Receiver can switch between mute mode and active mode
	USART_CR1_MME_Enabled = 0x1
	// Position of M0 field.
	USART_CR1_M0_Pos = 0xc
	// Bit mask of M0 field.
	USART_CR1_M0_Msk = 0x1000
	// Bit M0.
	USART_CR1_M0 = 0x1000
	// 1 start bit, 8 data bits, n stop bits
	USART_CR1_M0_Bit8 = 0x0
	// 1 start bit, 9 data bits, n stop bits
	USART_CR1_M0_Bit9 = 0x1
	// Position of WAKE field.
	USART_CR1_WAKE_Pos = 0xb
	// Bit mask of WAKE field.
	USART_CR1_WAKE_Msk = 0x800
	// Bit WAKE.
	USART_CR1_WAKE = 0x800
	// Idle line
	USART_CR1_WAKE_Idle = 0x0
	// Address mask
	USART_CR1_WAKE_Address = 0x1
	// Position of PCE field.
	USART_CR1_PCE_Pos = 0xa
	// Bit mask of PCE field.
	USART_CR1_PCE_Msk = 0x400
	// Bit PCE.
	USART_CR1_PCE = 0x400
	// Parity control disabled
	USART_CR1_PCE_Disabled = 0x0
	// Parity control enabled
	USART_CR1_PCE_Enabled = 0x1
	// Position of PS field.
	USART_CR1_PS_Pos = 0x9
	// Bit mask of PS field.
	USART_CR1_PS_Msk = 0x200
	// Bit PS.
	USART_CR1_PS = 0x200
	// Even parity
	USART_CR1_PS_Even = 0x0
	// Odd parity
	USART_CR1_PS_Odd = 0x1
	// Position of PEIE field.
	USART_CR1_PEIE_Pos = 0x8
	// Bit mask of PEIE field.
	USART_CR1_PEIE_Msk = 0x100
	// Bit PEIE.
	USART_CR1_PEIE = 0x100
	// Interrupt is disabled
	USART_CR1_PEIE_Disabled = 0x0
	// Interrupt is generated whenever PE=1 in the ISR register
	USART_CR1_PEIE_Enabled = 0x1
	// Position of TXEIE field.
	USART_CR1_TXEIE_Pos = 0x7
	// Bit mask of TXEIE field.
	USART_CR1_TXEIE_Msk = 0x80
	// Bit TXEIE.
	USART_CR1_TXEIE = 0x80
	// Interrupt is disabled
	USART_CR1_TXEIE_Disabled = 0x0
	// Interrupt is generated whenever TXE=1 in the ISR register
	USART_CR1_TXEIE_Enabled = 0x1
	// Position of TCIE field.
	USART_CR1_TCIE_Pos = 0x6
	// Bit mask of TCIE field.
	USART_CR1_TCIE_Msk = 0x40
	// Bit TCIE.
	USART_CR1_TCIE = 0x40
	// Interrupt is disabled
	USART_CR1_TCIE_Disabled = 0x0
	// Interrupt is generated whenever TC=1 in the ISR register
	USART_CR1_TCIE_Enabled = 0x1
	// Position of RXNEIE field.
	USART_CR1_RXNEIE_Pos = 0x5
	// Bit mask of RXNEIE field.
	USART_CR1_RXNEIE_Msk = 0x20
	// Bit RXNEIE.
	USART_CR1_RXNEIE = 0x20
	// Interrupt is disabled
	USART_CR1_RXNEIE_Disabled = 0x0
	// Interrupt is generated whenever ORE=1 or RXNE=1 in the ISR register
	USART_CR1_RXNEIE_Enabled = 0x1
	// Position of IDLEIE field.
	USART_CR1_IDLEIE_Pos = 0x4
	// Bit mask of IDLEIE field.
	USART_CR1_IDLEIE_Msk = 0x10
	// Bit IDLEIE.
	USART_CR1_IDLEIE = 0x10
	// Interrupt is disabled
	USART_CR1_IDLEIE_Disabled = 0x0
	// Interrupt is generated whenever IDLE=1 in the ISR register
	USART_CR1_IDLEIE_Enabled = 0x1
	// Position of TE field.
	USART_CR1_TE_Pos = 0x3
	// Bit mask of TE field.
	USART_CR1_TE_Msk = 0x8
	// Bit TE.
	USART_CR1_TE = 0x8
	// Transmitter is disabled
	USART_CR1_TE_Disabled = 0x0
	// Transmitter is enabled
	USART_CR1_TE_Enabled = 0x1
	// Position of RE field.
	USART_CR1_RE_Pos = 0x2
	// Bit mask of RE field.
	USART_CR1_RE_Msk = 0x4
	// Bit RE.
	USART_CR1_RE = 0x4
	// Receiver is disabled
	USART_CR1_RE_Disabled = 0x0
	// Receiver is enabled
	USART_CR1_RE_Enabled = 0x1
	// Position of UESM field.
	USART_CR1_UESM_Pos = 0x1
	// Bit mask of UESM field.
	USART_CR1_UESM_Msk = 0x2
	// Bit UESM.
	USART_CR1_UESM = 0x2
	// USART not able to wake up the MCU from Stop mode
	USART_CR1_UESM_Disabled = 0x0
	// USART able to wake up the MCU from Stop mode
	USART_CR1_UESM_Enabled = 0x1
	// Position of UE field.
	USART_CR1_UE_Pos = 0x0
	// Bit mask of UE field.
	USART_CR1_UE_Msk = 0x1
	// Bit UE.
	USART_CR1_UE = 0x1
	// UART is disabled
	USART_CR1_UE_Disabled = 0x0
	// UART is enabled
	USART_CR1_UE_Enabled = 0x1
	// Position of DEAT field.
	USART_CR1_DEAT_Pos = 0x15
	// Bit mask of DEAT field.
	USART_CR1_DEAT_Msk = 0x3e00000
	// Position of DEDT field.
	USART_CR1_DEDT_Pos = 0x10
	// Bit mask of DEDT field.
	USART_CR1_DEDT_Msk = 0x1f0000

	// CR2: Control register 2
	// Position of RTOEN field.
	USART_CR2_RTOEN_Pos = 0x17
	// Bit mask of RTOEN field.
	USART_CR2_RTOEN_Msk = 0x800000
	// Bit RTOEN.
	USART_CR2_RTOEN = 0x800000
	// Receiver timeout feature disabled
	USART_CR2_RTOEN_Disabled = 0x0
	// Receiver timeout feature enabled
	USART_CR2_RTOEN_Enabled = 0x1
	// Position of ABREN field.
	USART_CR2_ABREN_Pos = 0x14
	// Bit mask of ABREN field.
	USART_CR2_ABREN_Msk = 0x100000
	// Bit ABREN.
	USART_CR2_ABREN = 0x100000
	// Auto baud rate detection is disabled
	USART_CR2_ABREN_Disabled = 0x0
	// Auto baud rate detection is enabled
	USART_CR2_ABREN_Enabled = 0x1
	// Position of MSBFIRST field.
	USART_CR2_MSBFIRST_Pos = 0x13
	// Bit mask of MSBFIRST field.
	USART_CR2_MSBFIRST_Msk = 0x80000
	// Bit MSBFIRST.
	USART_CR2_MSBFIRST = 0x80000
	// data is transmitted/received with data bit 0 first, following the start bit
	USART_CR2_MSBFIRST_LSB = 0x0
	// data is transmitted/received with MSB (bit 7/8/9) first, following the start bit
	USART_CR2_MSBFIRST_MSB = 0x1
	// Position of DATAINV field.
	USART_CR2_DATAINV_Pos = 0x12
	// Bit mask of DATAINV field.
	USART_CR2_DATAINV_Msk = 0x40000
	// Bit DATAINV.
	USART_CR2_DATAINV = 0x40000
	// Logical data from the data register are send/received in positive/direct logic
	USART_CR2_DATAINV_Positive = 0x0
	// Logical data from the data register are send/received in negative/inverse logic
	USART_CR2_DATAINV_Negative = 0x1
	// Position of TXINV field.
	USART_CR2_TXINV_Pos = 0x11
	// Bit mask of TXINV field.
	USART_CR2_TXINV_Msk = 0x20000
	// Bit TXINV.
	USART_CR2_TXINV = 0x20000
	// TX pin signal works using the standard logic levels
	USART_CR2_TXINV_Standard = 0x0
	// TX pin signal values are inverted
	USART_CR2_TXINV_Inverted = 0x1
	// Position of RXINV field.
	USART_CR2_RXINV_Pos = 0x10
	// Bit mask of RXINV field.
	USART_CR2_RXINV_Msk = 0x10000
	// Bit RXINV.
	USART_CR2_RXINV = 0x10000
	// RX pin signal works using the standard logic levels
	USART_CR2_RXINV_Standard = 0x0
	// RX pin signal values are inverted
	USART_CR2_RXINV_Inverted = 0x1
	// Position of SWAP field.
	USART_CR2_SWAP_Pos = 0xf
	// Bit mask of SWAP field.
	USART_CR2_SWAP_Msk = 0x8000
	// Bit SWAP.
	USART_CR2_SWAP = 0x8000
	// TX/RX pins are used as defined in standard pinout
	USART_CR2_SWAP_Standard = 0x0
	// The TX and RX pins functions are swapped
	USART_CR2_SWAP_Swapped = 0x1
	// Position of LINEN field.
	USART_CR2_LINEN_Pos = 0xe
	// Bit mask of LINEN field.
	USART_CR2_LINEN_Msk = 0x4000
	// Bit LINEN.
	USART_CR2_LINEN = 0x4000
	// LIN mode disabled
	USART_CR2_LINEN_Disabled = 0x0
	// LIN mode enabled
	USART_CR2_LINEN_Enabled = 0x1
	// Position of STOP field.
	USART_CR2_STOP_Pos = 0xc
	// Bit mask of STOP field.
	USART_CR2_STOP_Msk = 0x3000
	// 1 stop bit
	USART_CR2_STOP_Stop1 = 0x0
	// 0.5 stop bit
	USART_CR2_STOP_Stop0p5 = 0x1
	// 2 stop bit
	USART_CR2_STOP_Stop2 = 0x2
	// 1.5 stop bit
	USART_CR2_STOP_Stop1p5 = 0x3
	// Position of CLKEN field.
	USART_CR2_CLKEN_Pos = 0xb
	// Bit mask of CLKEN field.
	USART_CR2_CLKEN_Msk = 0x800
	// Bit CLKEN.
	USART_CR2_CLKEN = 0x800
	// CK pin disabled
	USART_CR2_CLKEN_Disabled = 0x0
	// CK pin enabled
	USART_CR2_CLKEN_Enabled = 0x1
	// Position of CPOL field.
	USART_CR2_CPOL_Pos = 0xa
	// Bit mask of CPOL field.
	USART_CR2_CPOL_Msk = 0x400
	// Bit CPOL.
	USART_CR2_CPOL = 0x400
	// Steady low value on CK pin outside transmission window
	USART_CR2_CPOL_Low = 0x0
	// Steady high value on CK pin outside transmission window
	USART_CR2_CPOL_High = 0x1
	// Position of CPHA field.
	USART_CR2_CPHA_Pos = 0x9
	// Bit mask of CPHA field.
	USART_CR2_CPHA_Msk = 0x200
	// Bit CPHA.
	USART_CR2_CPHA = 0x200
	// The first clock transition is the first data capture edge
	USART_CR2_CPHA_First = 0x0
	// The second clock transition is the first data capture edge
	USART_CR2_CPHA_Second = 0x1
	// Position of LBCL field.
	USART_CR2_LBCL_Pos = 0x8
	// Bit mask of LBCL field.
	USART_CR2_LBCL_Msk = 0x100
	// Bit LBCL.
	USART_CR2_LBCL = 0x100
	// The clock pulse of the last data bit is not output to the CK pin
	USART_CR2_LBCL_NotOutput = 0x0
	// The clock pulse of the last data bit is output to the CK pin
	USART_CR2_LBCL_Output = 0x1
	// Position of LBDIE field.
	USART_CR2_LBDIE_Pos = 0x6
	// Bit mask of LBDIE field.
	USART_CR2_LBDIE_Msk = 0x40
	// Bit LBDIE.
	USART_CR2_LBDIE = 0x40
	// Interrupt is inhibited
	USART_CR2_LBDIE_Disabled = 0x0
	// An interrupt is generated whenever LBDF=1 in the ISR register
	USART_CR2_LBDIE_Enabled = 0x1
	// Position of LBDL field.
	USART_CR2_LBDL_Pos = 0x5
	// Bit mask of LBDL field.
	USART_CR2_LBDL_Msk = 0x20
	// Bit LBDL.
	USART_CR2_LBDL = 0x20
	// 10-bit break detection
	USART_CR2_LBDL_Bit10 = 0x0
	// 11-bit break detection
	USART_CR2_LBDL_Bit11 = 0x1
	// Position of ADDM7 field.
	USART_CR2_ADDM7_Pos = 0x4
	// Bit mask of ADDM7 field.
	USART_CR2_ADDM7_Msk = 0x10
	// Bit ADDM7.
	USART_CR2_ADDM7 = 0x10
	// 4-bit address detection
	USART_CR2_ADDM7_Bit4 = 0x0
	// 7-bit address detection
	USART_CR2_ADDM7_Bit7 = 0x1
	// Position of ADD field.
	USART_CR2_ADD_Pos = 0x18
	// Bit mask of ADD field.
	USART_CR2_ADD_Msk = 0xff000000
	// Position of ABRMOD field.
	USART_CR2_ABRMOD_Pos = 0x15
	// Bit mask of ABRMOD field.
	USART_CR2_ABRMOD_Msk = 0x600000
	// Measurement of the start bit is used to detect the baud rate
	USART_CR2_ABRMOD_Start = 0x0
	// Falling edge to falling edge measurement
	USART_CR2_ABRMOD_Edge = 0x1
	// 0x7F frame detection
	USART_CR2_ABRMOD_Frame7F = 0x2
	// 0x55 frame detection
	USART_CR2_ABRMOD_Frame55 = 0x3

	// CR3: Control register 3
	// Position of WUFIE field.
	USART_CR3_WUFIE_Pos = 0x16
	// Bit mask of WUFIE field.
	USART_CR3_WUFIE_Msk = 0x400000
	// Bit WUFIE.
	USART_CR3_WUFIE = 0x400000
	// Interrupt is inhibited
	USART_CR3_WUFIE_Disabled = 0x0
	// An USART interrupt is generated whenever WUF=1 in the ISR register
	USART_CR3_WUFIE_Enabled = 0x1
	// Position of WUS field.
	USART_CR3_WUS_Pos = 0x14
	// Bit mask of WUS field.
	USART_CR3_WUS_Msk = 0x300000
	// WUF active on address match
	USART_CR3_WUS_Address = 0x0
	// WuF active on Start bit detection
	USART_CR3_WUS_Start = 0x2
	// WUF active on RXNE
	USART_CR3_WUS_RXNE = 0x3
	// Position of SCARCNT field.
	USART_CR3_SCARCNT_Pos = 0x11
	// Bit mask of SCARCNT field.
	USART_CR3_SCARCNT_Msk = 0xe0000
	// Position of DEP field.
	USART_CR3_DEP_Pos = 0xf
	// Bit mask of DEP field.
	USART_CR3_DEP_Msk = 0x8000
	// Bit DEP.
	USART_CR3_DEP = 0x8000
	// DE signal is active high
	USART_CR3_DEP_High = 0x0
	// DE signal is active low
	USART_CR3_DEP_Low = 0x1
	// Position of DEM field.
	USART_CR3_DEM_Pos = 0xe
	// Bit mask of DEM field.
	USART_CR3_DEM_Msk = 0x4000
	// Bit DEM.
	USART_CR3_DEM = 0x4000
	// DE function is disabled
	USART_CR3_DEM_Disabled = 0x0
	// The DE signal is output on the RTS pin
	USART_CR3_DEM_Enabled = 0x1
	// Position of DDRE field.
	USART_CR3_DDRE_Pos = 0xd
	// Bit mask of DDRE field.
	USART_CR3_DDRE_Msk = 0x2000
	// Bit DDRE.
	USART_CR3_DDRE = 0x2000
	// DMA is not disabled in case of reception error
	USART_CR3_DDRE_NotDisabled = 0x0
	// DMA is disabled following a reception error
	USART_CR3_DDRE_Disabled = 0x1
	// Position of OVRDIS field.
	USART_CR3_OVRDIS_Pos = 0xc
	// Bit mask of OVRDIS field.
	USART_CR3_OVRDIS_Msk = 0x1000
	// Bit OVRDIS.
	USART_CR3_OVRDIS = 0x1000
	// Overrun Error Flag, ORE, is set when received data is not read before receiving new data
	USART_CR3_OVRDIS_Enabled = 0x0
	// Overrun functionality is disabled. If new data is received while the RXNE flag is still set the ORE flag is not set and the new received data overwrites the previous content of the RDR register
	USART_CR3_OVRDIS_Disabled = 0x1
	// Position of ONEBIT field.
	USART_CR3_ONEBIT_Pos = 0xb
	// Bit mask of ONEBIT field.
	USART_CR3_ONEBIT_Msk = 0x800
	// Bit ONEBIT.
	USART_CR3_ONEBIT = 0x800
	// Three sample bit method
	USART_CR3_ONEBIT_Sample3 = 0x0
	// One sample bit method
	USART_CR3_ONEBIT_Sample1 = 0x1
	// Position of CTSIE field.
	USART_CR3_CTSIE_Pos = 0xa
	// Bit mask of CTSIE field.
	USART_CR3_CTSIE_Msk = 0x400
	// Bit CTSIE.
	USART_CR3_CTSIE = 0x400
	// Interrupt is inhibited
	USART_CR3_CTSIE_Disabled = 0x0
	// An interrupt is generated whenever CTSIF=1 in the ISR register
	USART_CR3_CTSIE_Enabled = 0x1
	// Position of CTSE field.
	USART_CR3_CTSE_Pos = 0x9
	// Bit mask of CTSE field.
	USART_CR3_CTSE_Msk = 0x200
	// Bit CTSE.
	USART_CR3_CTSE = 0x200
	// CTS hardware flow control disabled
	USART_CR3_CTSE_Disabled = 0x0
	// CTS mode enabled, data is only transmitted when the CTS input is asserted
	USART_CR3_CTSE_Enabled = 0x1
	// Position of RTSE field.
	USART_CR3_RTSE_Pos = 0x8
	// Bit mask of RTSE field.
	USART_CR3_RTSE_Msk = 0x100
	// Bit RTSE.
	USART_CR3_RTSE = 0x100
	// RTS hardware flow control disabled
	USART_CR3_RTSE_Disabled = 0x0
	// RTS output enabled, data is only requested when there is space in the receive buffer
	USART_CR3_RTSE_Enabled = 0x1
	// Position of DMAT field.
	USART_CR3_DMAT_Pos = 0x7
	// Bit mask of DMAT field.
	USART_CR3_DMAT_Msk = 0x80
	// Bit DMAT.
	USART_CR3_DMAT = 0x80
	// DMA mode is disabled for transmission
	USART_CR3_DMAT_Disabled = 0x0
	// DMA mode is enabled for transmission
	USART_CR3_DMAT_Enabled = 0x1
	// Position of DMAR field.
	USART_CR3_DMAR_Pos = 0x6
	// Bit mask of DMAR field.
	USART_CR3_DMAR_Msk = 0x40
	// Bit DMAR.
	USART_CR3_DMAR = 0x40
	// DMA mode is disabled for reception
	USART_CR3_DMAR_Disabled = 0x0
	// DMA mode is enabled for reception
	USART_CR3_DMAR_Enabled = 0x1
	// Position of SCEN field.
	USART_CR3_SCEN_Pos = 0x5
	// Bit mask of SCEN field.
	USART_CR3_SCEN_Msk = 0x20
	// Bit SCEN.
	USART_CR3_SCEN = 0x20
	// Smartcard Mode disabled
	USART_CR3_SCEN_Disabled = 0x0
	// Smartcard Mode enabled
	USART_CR3_SCEN_Enabled = 0x1
	// Position of NACK field.
	USART_CR3_NACK_Pos = 0x4
	// Bit mask of NACK field.
	USART_CR3_NACK_Msk = 0x10
	// Bit NACK.
	USART_CR3_NACK = 0x10
	// NACK transmission in case of parity error is disabled
	USART_CR3_NACK_Disabled = 0x0
	// NACK transmission during parity error is enabled
	USART_CR3_NACK_Enabled = 0x1
	// Position of HDSEL field.
	USART_CR3_HDSEL_Pos = 0x3
	// Bit mask of HDSEL field.
	USART_CR3_HDSEL_Msk = 0x8
	// Bit HDSEL.
	USART_CR3_HDSEL = 0x8
	// Half duplex mode is not selected
	USART_CR3_HDSEL_NotSelected = 0x0
	// Half duplex mode is selected
	USART_CR3_HDSEL_Selected = 0x1
	// Position of IRLP field.
	USART_CR3_IRLP_Pos = 0x2
	// Bit mask of IRLP field.
	USART_CR3_IRLP_Msk = 0x4
	// Bit IRLP.
	USART_CR3_IRLP = 0x4
	// Normal mode
	USART_CR3_IRLP_Normal = 0x0
	// Low-power mode
	USART_CR3_IRLP_LowPower = 0x1
	// Position of IREN field.
	USART_CR3_IREN_Pos = 0x1
	// Bit mask of IREN field.
	USART_CR3_IREN_Msk = 0x2
	// Bit IREN.
	USART_CR3_IREN = 0x2
	// IrDA disabled
	USART_CR3_IREN_Disabled = 0x0
	// IrDA enabled
	USART_CR3_IREN_Enabled = 0x1
	// Position of EIE field.
	USART_CR3_EIE_Pos = 0x0
	// Bit mask of EIE field.
	USART_CR3_EIE_Msk = 0x1
	// Bit EIE.
	USART_CR3_EIE = 0x1
	// Interrupt is inhibited
	USART_CR3_EIE_Disabled = 0x0
	// An interrupt is generated when FE=1 or ORE=1 or NF=1 in the ISR register
	USART_CR3_EIE_Enabled = 0x1

	// BRR: Baud rate register
	// Position of BRR field.
	USART_BRR_BRR_Pos = 0x0
	// Bit mask of BRR field.
	USART_BRR_BRR_Msk = 0xffff

	// GTPR: Guard time and prescaler register
	// Position of GT field.
	USART_GTPR_GT_Pos = 0x8
	// Bit mask of GT field.
	USART_GTPR_GT_Msk = 0xff00
	// Position of PSC field.
	USART_GTPR_PSC_Pos = 0x0
	// Bit mask of PSC field.
	USART_GTPR_PSC_Msk = 0xff

	// RTOR: Receiver timeout register
	// Position of BLEN field.
	USART_RTOR_BLEN_Pos = 0x18
	// Bit mask of BLEN field.
	USART_RTOR_BLEN_Msk = 0xff000000
	// Position of RTO field.
	USART_RTOR_RTO_Pos = 0x0
	// Bit mask of RTO field.
	USART_RTOR_RTO_Msk = 0xffffff

	// RQR: Request register
	// Position of TXFRQ field.
	USART_RQR_TXFRQ_Pos = 0x4
	// Bit mask of TXFRQ field.
	USART_RQR_TXFRQ_Msk = 0x10
	// Bit TXFRQ.
	USART_RQR_TXFRQ = 0x10
	// Set the TXE flags. This allows to discard the transmit data
	USART_RQR_TXFRQ_Discard = 0x1
	// Position of RXFRQ field.
	USART_RQR_RXFRQ_Pos = 0x3
	// Bit mask of RXFRQ field.
	USART_RQR_RXFRQ_Msk = 0x8
	// Bit RXFRQ.
	USART_RQR_RXFRQ = 0x8
	// clears the RXNE flag. This allows to discard the received data without reading it, and avoid an overrun condition
	USART_RQR_RXFRQ_Discard = 0x1
	// Position of MMRQ field.
	USART_RQR_MMRQ_Pos = 0x2
	// Bit mask of MMRQ field.
	USART_RQR_MMRQ_Msk = 0x4
	// Bit MMRQ.
	USART_RQR_MMRQ = 0x4
	// Puts the USART in mute mode and sets the RWU flag
	USART_RQR_MMRQ_Mute = 0x1
	// Position of SBKRQ field.
	USART_RQR_SBKRQ_Pos = 0x1
	// Bit mask of SBKRQ field.
	USART_RQR_SBKRQ_Msk = 0x2
	// Bit SBKRQ.
	USART_RQR_SBKRQ = 0x2
	// sets the SBKF flag and request to send a BREAK on the line, as soon as the transmit machine is available
	USART_RQR_SBKRQ_Break = 0x1
	// Position of ABRRQ field.
	USART_RQR_ABRRQ_Pos = 0x0
	// Bit mask of ABRRQ field.
	USART_RQR_ABRRQ_Msk = 0x1
	// Bit ABRRQ.
	USART_RQR_ABRRQ = 0x1
	// resets the ABRF flag in the USART_ISR and request an automatic baud rate measurement on the next received data frame
	USART_RQR_ABRRQ_Request = 0x1

	// ISR: Interrupt & status register
	// Position of REACK field.
	USART_ISR_REACK_Pos = 0x16
	// Bit mask of REACK field.
	USART_ISR_REACK_Msk = 0x400000
	// Bit REACK.
	USART_ISR_REACK = 0x400000
	// Position of TEACK field.
	USART_ISR_TEACK_Pos = 0x15
	// Bit mask of TEACK field.
	USART_ISR_TEACK_Msk = 0x200000
	// Bit TEACK.
	USART_ISR_TEACK = 0x200000
	// Position of WUF field.
	USART_ISR_WUF_Pos = 0x14
	// Bit mask of WUF field.
	USART_ISR_WUF_Msk = 0x100000
	// Bit WUF.
	USART_ISR_WUF = 0x100000
	// Position of RWU field.
	USART_ISR_RWU_Pos = 0x13
	// Bit mask of RWU field.
	USART_ISR_RWU_Msk = 0x80000
	// Bit RWU.
	USART_ISR_RWU = 0x80000
	// Position of SBKF field.
	USART_ISR_SBKF_Pos = 0x12
	// Bit mask of SBKF field.
	USART_ISR_SBKF_Msk = 0x40000
	// Bit SBKF.
	USART_ISR_SBKF = 0x40000
	// Position of CMF field.
	USART_ISR_CMF_Pos = 0x11
	// Bit mask of CMF field.
	USART_ISR_CMF_Msk = 0x20000
	// Bit CMF.
	USART_ISR_CMF = 0x20000
	// Position of BUSY field.
	USART_ISR_BUSY_Pos = 0x10
	// Bit mask of BUSY field.
	USART_ISR_BUSY_Msk = 0x10000
	// Bit BUSY.
	USART_ISR_BUSY = 0x10000
	// Position of ABRF field.
	USART_ISR_ABRF_Pos = 0xf
	// Bit mask of ABRF field.
	USART_ISR_ABRF_Msk = 0x8000
	// Bit ABRF.
	USART_ISR_ABRF = 0x8000
	// Position of ABRE field.
	USART_ISR_ABRE_Pos = 0xe
	// Bit mask of ABRE field.
	USART_ISR_ABRE_Msk = 0x4000
	// Bit ABRE.
	USART_ISR_ABRE = 0x4000
	// Position of EOBF field.
	USART_ISR_EOBF_Pos = 0xc
	// Bit mask of EOBF field.
	USART_ISR_EOBF_Msk = 0x1000
	// Bit EOBF.
	USART_ISR_EOBF = 0x1000
	// Position of RTOF field.
	USART_ISR_RTOF_Pos = 0xb
	// Bit mask of RTOF field.
	USART_ISR_RTOF_Msk = 0x800
	// Bit RTOF.
	USART_ISR_RTOF = 0x800
	// Position of CTS field.
	USART_ISR_CTS_Pos = 0xa
	// Bit mask of CTS field.
	USART_ISR_CTS_Msk = 0x400
	// Bit CTS.
	USART_ISR_CTS = 0x400
	// Position of CTSIF field.
	USART_ISR_CTSIF_Pos = 0x9
	// Bit mask of CTSIF field.
	USART_ISR_CTSIF_Msk = 0x200
	// Bit CTSIF.
	USART_ISR_CTSIF = 0x200
	// Position of LBDF field.
	USART_ISR_LBDF_Pos = 0x8
	// Bit mask of LBDF field.
	USART_ISR_LBDF_Msk = 0x100
	// Bit LBDF.
	USART_ISR_LBDF = 0x100
	// Position of TXE field.
	USART_ISR_TXE_Pos = 0x7
	// Bit mask of TXE field.
	USART_ISR_TXE_Msk = 0x80
	// Bit TXE.
	USART_ISR_TXE = 0x80
	// Position of TC field.
	USART_ISR_TC_Pos = 0x6
	// Bit mask of TC field.
	USART_ISR_TC_Msk = 0x40
	// Bit TC.
	USART_ISR_TC = 0x40
	// Position of RXNE field.
	USART_ISR_RXNE_Pos = 0x5
	// Bit mask of RXNE field.
	USART_ISR_RXNE_Msk = 0x20
	// Bit RXNE.
	USART_ISR_RXNE = 0x20
	// Position of IDLE field.
	USART_ISR_IDLE_Pos = 0x4
	// Bit mask of IDLE field.
	USART_ISR_IDLE_Msk = 0x10
	// Bit IDLE.
	USART_ISR_IDLE = 0x10
	// Position of ORE field.
	USART_ISR_ORE_Pos = 0x3
	// Bit mask of ORE field.
	USART_ISR_ORE_Msk = 0x8
	// Bit ORE.
	USART_ISR_ORE = 0x8
	// Position of NF field.
	USART_ISR_NF_Pos = 0x2
	// Bit mask of NF field.
	USART_ISR_NF_Msk = 0x4
	// Bit NF.
	USART_ISR_NF = 0x4
	// Position of FE field.
	USART_ISR_FE_Pos = 0x1
	// Bit mask of FE field.
	USART_ISR_FE_Msk = 0x2
	// Bit FE.
	USART_ISR_FE = 0x2
	// Position of PE field.
	USART_ISR_PE_Pos = 0x0
	// Bit mask of PE field.
	USART_ISR_PE_Msk = 0x1
	// Bit PE.
	USART_ISR_PE = 0x1

	// ICR: Interrupt flag clear register
	// Position of WUCF field.
	USART_ICR_WUCF_Pos = 0x14
	// Bit mask of WUCF field.
	USART_ICR_WUCF_Msk = 0x100000
	// Bit WUCF.
	USART_ICR_WUCF = 0x100000
	// Clears the WUF flag in the ISR register
	USART_ICR_WUCF_Clear = 0x1
	// Position of CMCF field.
	USART_ICR_CMCF_Pos = 0x11
	// Bit mask of CMCF field.
	USART_ICR_CMCF_Msk = 0x20000
	// Bit CMCF.
	USART_ICR_CMCF = 0x20000
	// Clears the CMF flag in the ISR register
	USART_ICR_CMCF_Clear = 0x1
	// Position of EOBCF field.
	USART_ICR_EOBCF_Pos = 0xc
	// Bit mask of EOBCF field.
	USART_ICR_EOBCF_Msk = 0x1000
	// Bit EOBCF.
	USART_ICR_EOBCF = 0x1000
	// Clears the EOBF flag in the ISR register
	USART_ICR_EOBCF_Clear = 0x1
	// Position of RTOCF field.
	USART_ICR_RTOCF_Pos = 0xb
	// Bit mask of RTOCF field.
	USART_ICR_RTOCF_Msk = 0x800
	// Bit RTOCF.
	USART_ICR_RTOCF = 0x800
	// Clears the RTOF flag in the ISR register
	USART_ICR_RTOCF_Clear = 0x1
	// Position of CTSCF field.
	USART_ICR_CTSCF_Pos = 0x9
	// Bit mask of CTSCF field.
	USART_ICR_CTSCF_Msk = 0x200
	// Bit CTSCF.
	USART_ICR_CTSCF = 0x200
	// Clears the CTSIF flag in the ISR register
	USART_ICR_CTSCF_Clear = 0x1
	// Position of LBDCF field.
	USART_ICR_LBDCF_Pos = 0x8
	// Bit mask of LBDCF field.
	USART_ICR_LBDCF_Msk = 0x100
	// Bit LBDCF.
	USART_ICR_LBDCF = 0x100
	// Clears the LBDF flag in the ISR register
	USART_ICR_LBDCF_Clear = 0x1
	// Position of TCCF field.
	USART_ICR_TCCF_Pos = 0x6
	// Bit mask of TCCF field.
	USART_ICR_TCCF_Msk = 0x40
	// Bit TCCF.
	USART_ICR_TCCF = 0x40
	// Clears the TC flag in the ISR register
	USART_ICR_TCCF_Clear = 0x1
	// Position of IDLECF field.
	USART_ICR_IDLECF_Pos = 0x4
	// Bit mask of IDLECF field.
	USART_ICR_IDLECF_Msk = 0x10
	// Bit IDLECF.
	USART_ICR_IDLECF = 0x10
	// Clears the IDLE flag in the ISR register
	USART_ICR_IDLECF_Clear = 0x1
	// Position of ORECF field.
	USART_ICR_ORECF_Pos = 0x3
	// Bit mask of ORECF field.
	USART_ICR_ORECF_Msk = 0x8
	// Bit ORECF.
	USART_ICR_ORECF = 0x8
	// Clears the ORE flag in the ISR register
	USART_ICR_ORECF_Clear = 0x1
	// Position of NCF field.
	USART_ICR_NCF_Pos = 0x2
	// Bit mask of NCF field.
	USART_ICR_NCF_Msk = 0x4
	// Bit NCF.
	USART_ICR_NCF = 0x4
	// Clears the NF flag in the ISR register
	USART_ICR_NCF_Clear = 0x1
	// Position of FECF field.
	USART_ICR_FECF_Pos = 0x1
	// Bit mask of FECF field.
	USART_ICR_FECF_Msk = 0x2
	// Bit FECF.
	USART_ICR_FECF = 0x2
	// Clears the FE flag in the ISR register
	USART_ICR_FECF_Clear = 0x1
	// Position of PECF field.
	USART_ICR_PECF_Pos = 0x0
	// Bit mask of PECF field.
	USART_ICR_PECF_Msk = 0x1
	// Bit PECF.
	USART_ICR_PECF = 0x1
	// Clears the PE flag in the ISR register
	USART_ICR_PECF_Clear = 0x1

	// RDR: Receive data register
	// Position of RDR field.
	USART_RDR_RDR_Pos = 0x0
	// Bit mask of RDR field.
	USART_RDR_RDR_Msk = 0x1ff

	// TDR: Transmit data register
	// Position of TDR field.
	USART_TDR_TDR_Pos = 0x0
	// Bit mask of TDR field.
	USART_TDR_TDR_Msk = 0x1ff
)

// Bitfields for TSC: Touch sensing controller
const (
	// CR: control register
	// Position of CTPH field.
	TSC_CR_CTPH_Pos = 0x1c
	// Bit mask of CTPH field.
	TSC_CR_CTPH_Msk = 0xf0000000
	// Position of CTPL field.
	TSC_CR_CTPL_Pos = 0x18
	// Bit mask of CTPL field.
	TSC_CR_CTPL_Msk = 0xf000000
	// Position of SSD field.
	TSC_CR_SSD_Pos = 0x11
	// Bit mask of SSD field.
	TSC_CR_SSD_Msk = 0xfe0000
	// Position of SSE field.
	TSC_CR_SSE_Pos = 0x10
	// Bit mask of SSE field.
	TSC_CR_SSE_Msk = 0x10000
	// Bit SSE.
	TSC_CR_SSE = 0x10000
	// Position of SSPSC field.
	TSC_CR_SSPSC_Pos = 0xf
	// Bit mask of SSPSC field.
	TSC_CR_SSPSC_Msk = 0x8000
	// Bit SSPSC.
	TSC_CR_SSPSC = 0x8000
	// Position of PGPSC field.
	TSC_CR_PGPSC_Pos = 0xc
	// Bit mask of PGPSC field.
	TSC_CR_PGPSC_Msk = 0x7000
	// Position of MCV field.
	TSC_CR_MCV_Pos = 0x5
	// Bit mask of MCV field.
	TSC_CR_MCV_Msk = 0xe0
	// Position of IODEF field.
	TSC_CR_IODEF_Pos = 0x4
	// Bit mask of IODEF field.
	TSC_CR_IODEF_Msk = 0x10
	// Bit IODEF.
	TSC_CR_IODEF = 0x10
	// Position of SYNCPOL field.
	TSC_CR_SYNCPOL_Pos = 0x3
	// Bit mask of SYNCPOL field.
	TSC_CR_SYNCPOL_Msk = 0x8
	// Bit SYNCPOL.
	TSC_CR_SYNCPOL = 0x8
	// Position of AM field.
	TSC_CR_AM_Pos = 0x2
	// Bit mask of AM field.
	TSC_CR_AM_Msk = 0x4
	// Bit AM.
	TSC_CR_AM = 0x4
	// Position of START field.
	TSC_CR_START_Pos = 0x1
	// Bit mask of START field.
	TSC_CR_START_Msk = 0x2
	// Bit START.
	TSC_CR_START = 0x2
	// Position of TSCE field.
	TSC_CR_TSCE_Pos = 0x0
	// Bit mask of TSCE field.
	TSC_CR_TSCE_Msk = 0x1
	// Bit TSCE.
	TSC_CR_TSCE = 0x1

	// IER: interrupt enable register
	// Position of MCEIE field.
	TSC_IER_MCEIE_Pos = 0x1
	// Bit mask of MCEIE field.
	TSC_IER_MCEIE_Msk = 0x2
	// Bit MCEIE.
	TSC_IER_MCEIE = 0x2
	// Position of EOAIE field.
	TSC_IER_EOAIE_Pos = 0x0
	// Bit mask of EOAIE field.
	TSC_IER_EOAIE_Msk = 0x1
	// Bit EOAIE.
	TSC_IER_EOAIE = 0x1

	// ICR: interrupt clear register
	// Position of MCEIC field.
	TSC_ICR_MCEIC_Pos = 0x1
	// Bit mask of MCEIC field.
	TSC_ICR_MCEIC_Msk = 0x2
	// Bit MCEIC.
	TSC_ICR_MCEIC = 0x2
	// Position of EOAIC field.
	TSC_ICR_EOAIC_Pos = 0x0
	// Bit mask of EOAIC field.
	TSC_ICR_EOAIC_Msk = 0x1
	// Bit EOAIC.
	TSC_ICR_EOAIC = 0x1

	// ISR: interrupt status register
	// Position of MCEF field.
	TSC_ISR_MCEF_Pos = 0x1
	// Bit mask of MCEF field.
	TSC_ISR_MCEF_Msk = 0x2
	// Bit MCEF.
	TSC_ISR_MCEF = 0x2
	// Position of EOAF field.
	TSC_ISR_EOAF_Pos = 0x0
	// Bit mask of EOAF field.
	TSC_ISR_EOAF_Msk = 0x1
	// Bit EOAF.
	TSC_ISR_EOAF = 0x1

	// IOHCR: I/O hysteresis control register
	// Position of G8_IO4 field.
	TSC_IOHCR_G8_IO4_Pos = 0x1f
	// Bit mask of G8_IO4 field.
	TSC_IOHCR_G8_IO4_Msk = 0x80000000
	// Bit G8_IO4.
	TSC_IOHCR_G8_IO4 = 0x80000000
	// Position of G8_IO3 field.
	TSC_IOHCR_G8_IO3_Pos = 0x1e
	// Bit mask of G8_IO3 field.
	TSC_IOHCR_G8_IO3_Msk = 0x40000000
	// Bit G8_IO3.
	TSC_IOHCR_G8_IO3 = 0x40000000
	// Position of G8_IO2 field.
	TSC_IOHCR_G8_IO2_Pos = 0x1d
	// Bit mask of G8_IO2 field.
	TSC_IOHCR_G8_IO2_Msk = 0x20000000
	// Bit G8_IO2.
	TSC_IOHCR_G8_IO2 = 0x20000000
	// Position of G8_IO1 field.
	TSC_IOHCR_G8_IO1_Pos = 0x1c
	// Bit mask of G8_IO1 field.
	TSC_IOHCR_G8_IO1_Msk = 0x10000000
	// Bit G8_IO1.
	TSC_IOHCR_G8_IO1 = 0x10000000
	// Position of G7_IO4 field.
	TSC_IOHCR_G7_IO4_Pos = 0x1b
	// Bit mask of G7_IO4 field.
	TSC_IOHCR_G7_IO4_Msk = 0x8000000
	// Bit G7_IO4.
	TSC_IOHCR_G7_IO4 = 0x8000000
	// Position of G7_IO3 field.
	TSC_IOHCR_G7_IO3_Pos = 0x1a
	// Bit mask of G7_IO3 field.
	TSC_IOHCR_G7_IO3_Msk = 0x4000000
	// Bit G7_IO3.
	TSC_IOHCR_G7_IO3 = 0x4000000
	// Position of G7_IO2 field.
	TSC_IOHCR_G7_IO2_Pos = 0x19
	// Bit mask of G7_IO2 field.
	TSC_IOHCR_G7_IO2_Msk = 0x2000000
	// Bit G7_IO2.
	TSC_IOHCR_G7_IO2 = 0x2000000
	// Position of G7_IO1 field.
	TSC_IOHCR_G7_IO1_Pos = 0x18
	// Bit mask of G7_IO1 field.
	TSC_IOHCR_G7_IO1_Msk = 0x1000000
	// Bit G7_IO1.
	TSC_IOHCR_G7_IO1 = 0x1000000
	// Position of G6_IO4 field.
	TSC_IOHCR_G6_IO4_Pos = 0x17
	// Bit mask of G6_IO4 field.
	TSC_IOHCR_G6_IO4_Msk = 0x800000
	// Bit G6_IO4.
	TSC_IOHCR_G6_IO4 = 0x800000
	// Position of G6_IO3 field.
	TSC_IOHCR_G6_IO3_Pos = 0x16
	// Bit mask of G6_IO3 field.
	TSC_IOHCR_G6_IO3_Msk = 0x400000
	// Bit G6_IO3.
	TSC_IOHCR_G6_IO3 = 0x400000
	// Position of G6_IO2 field.
	TSC_IOHCR_G6_IO2_Pos = 0x15
	// Bit mask of G6_IO2 field.
	TSC_IOHCR_G6_IO2_Msk = 0x200000
	// Bit G6_IO2.
	TSC_IOHCR_G6_IO2 = 0x200000
	// Position of G6_IO1 field.
	TSC_IOHCR_G6_IO1_Pos = 0x14
	// Bit mask of G6_IO1 field.
	TSC_IOHCR_G6_IO1_Msk = 0x100000
	// Bit G6_IO1.
	TSC_IOHCR_G6_IO1 = 0x100000
	// Position of G5_IO4 field.
	TSC_IOHCR_G5_IO4_Pos = 0x13
	// Bit mask of G5_IO4 field.
	TSC_IOHCR_G5_IO4_Msk = 0x80000
	// Bit G5_IO4.
	TSC_IOHCR_G5_IO4 = 0x80000
	// Position of G5_IO3 field.
	TSC_IOHCR_G5_IO3_Pos = 0x12
	// Bit mask of G5_IO3 field.
	TSC_IOHCR_G5_IO3_Msk = 0x40000
	// Bit G5_IO3.
	TSC_IOHCR_G5_IO3 = 0x40000
	// Position of G5_IO2 field.
	TSC_IOHCR_G5_IO2_Pos = 0x11
	// Bit mask of G5_IO2 field.
	TSC_IOHCR_G5_IO2_Msk = 0x20000
	// Bit G5_IO2.
	TSC_IOHCR_G5_IO2 = 0x20000
	// Position of G5_IO1 field.
	TSC_IOHCR_G5_IO1_Pos = 0x10
	// Bit mask of G5_IO1 field.
	TSC_IOHCR_G5_IO1_Msk = 0x10000
	// Bit G5_IO1.
	TSC_IOHCR_G5_IO1 = 0x10000
	// Position of G4_IO4 field.
	TSC_IOHCR_G4_IO4_Pos = 0xf
	// Bit mask of G4_IO4 field.
	TSC_IOHCR_G4_IO4_Msk = 0x8000
	// Bit G4_IO4.
	TSC_IOHCR_G4_IO4 = 0x8000
	// Position of G4_IO3 field.
	TSC_IOHCR_G4_IO3_Pos = 0xe
	// Bit mask of G4_IO3 field.
	TSC_IOHCR_G4_IO3_Msk = 0x4000
	// Bit G4_IO3.
	TSC_IOHCR_G4_IO3 = 0x4000
	// Position of G4_IO2 field.
	TSC_IOHCR_G4_IO2_Pos = 0xd
	// Bit mask of G4_IO2 field.
	TSC_IOHCR_G4_IO2_Msk = 0x2000
	// Bit G4_IO2.
	TSC_IOHCR_G4_IO2 = 0x2000
	// Position of G4_IO1 field.
	TSC_IOHCR_G4_IO1_Pos = 0xc
	// Bit mask of G4_IO1 field.
	TSC_IOHCR_G4_IO1_Msk = 0x1000
	// Bit G4_IO1.
	TSC_IOHCR_G4_IO1 = 0x1000
	// Position of G3_IO4 field.
	TSC_IOHCR_G3_IO4_Pos = 0xb
	// Bit mask of G3_IO4 field.
	TSC_IOHCR_G3_IO4_Msk = 0x800
	// Bit G3_IO4.
	TSC_IOHCR_G3_IO4 = 0x800
	// Position of G3_IO3 field.
	TSC_IOHCR_G3_IO3_Pos = 0xa
	// Bit mask of G3_IO3 field.
	TSC_IOHCR_G3_IO3_Msk = 0x400
	// Bit G3_IO3.
	TSC_IOHCR_G3_IO3 = 0x400
	// Position of G3_IO2 field.
	TSC_IOHCR_G3_IO2_Pos = 0x9
	// Bit mask of G3_IO2 field.
	TSC_IOHCR_G3_IO2_Msk = 0x200
	// Bit G3_IO2.
	TSC_IOHCR_G3_IO2 = 0x200
	// Position of G3_IO1 field.
	TSC_IOHCR_G3_IO1_Pos = 0x8
	// Bit mask of G3_IO1 field.
	TSC_IOHCR_G3_IO1_Msk = 0x100
	// Bit G3_IO1.
	TSC_IOHCR_G3_IO1 = 0x100
	// Position of G2_IO4 field.
	TSC_IOHCR_G2_IO4_Pos = 0x7
	// Bit mask of G2_IO4 field.
	TSC_IOHCR_G2_IO4_Msk = 0x80
	// Bit G2_IO4.
	TSC_IOHCR_G2_IO4 = 0x80
	// Position of G2_IO3 field.
	TSC_IOHCR_G2_IO3_Pos = 0x6
	// Bit mask of G2_IO3 field.
	TSC_IOHCR_G2_IO3_Msk = 0x40
	// Bit G2_IO3.
	TSC_IOHCR_G2_IO3 = 0x40
	// Position of G2_IO2 field.
	TSC_IOHCR_G2_IO2_Pos = 0x5
	// Bit mask of G2_IO2 field.
	TSC_IOHCR_G2_IO2_Msk = 0x20
	// Bit G2_IO2.
	TSC_IOHCR_G2_IO2 = 0x20
	// Position of G2_IO1 field.
	TSC_IOHCR_G2_IO1_Pos = 0x4
	// Bit mask of G2_IO1 field.
	TSC_IOHCR_G2_IO1_Msk = 0x10
	// Bit G2_IO1.
	TSC_IOHCR_G2_IO1 = 0x10
	// Position of G1_IO4 field.
	TSC_IOHCR_G1_IO4_Pos = 0x3
	// Bit mask of G1_IO4 field.
	TSC_IOHCR_G1_IO4_Msk = 0x8
	// Bit G1_IO4.
	TSC_IOHCR_G1_IO4 = 0x8
	// Position of G1_IO3 field.
	TSC_IOHCR_G1_IO3_Pos = 0x2
	// Bit mask of G1_IO3 field.
	TSC_IOHCR_G1_IO3_Msk = 0x4
	// Bit G1_IO3.
	TSC_IOHCR_G1_IO3 = 0x4
	// Position of G1_IO2 field.
	TSC_IOHCR_G1_IO2_Pos = 0x1
	// Bit mask of G1_IO2 field.
	TSC_IOHCR_G1_IO2_Msk = 0x2
	// Bit G1_IO2.
	TSC_IOHCR_G1_IO2 = 0x2
	// Position of G1_IO1 field.
	TSC_IOHCR_G1_IO1_Pos = 0x0
	// Bit mask of G1_IO1 field.
	TSC_IOHCR_G1_IO1_Msk = 0x1
	// Bit G1_IO1.
	TSC_IOHCR_G1_IO1 = 0x1

	// IOASCR: I/O analog switch control register
	// Position of G8_IO4 field.
	TSC_IOASCR_G8_IO4_Pos = 0x1f
	// Bit mask of G8_IO4 field.
	TSC_IOASCR_G8_IO4_Msk = 0x80000000
	// Bit G8_IO4.
	TSC_IOASCR_G8_IO4 = 0x80000000
	// Position of G8_IO3 field.
	TSC_IOASCR_G8_IO3_Pos = 0x1e
	// Bit mask of G8_IO3 field.
	TSC_IOASCR_G8_IO3_Msk = 0x40000000
	// Bit G8_IO3.
	TSC_IOASCR_G8_IO3 = 0x40000000
	// Position of G8_IO2 field.
	TSC_IOASCR_G8_IO2_Pos = 0x1d
	// Bit mask of G8_IO2 field.
	TSC_IOASCR_G8_IO2_Msk = 0x20000000
	// Bit G8_IO2.
	TSC_IOASCR_G8_IO2 = 0x20000000
	// Position of G8_IO1 field.
	TSC_IOASCR_G8_IO1_Pos = 0x1c
	// Bit mask of G8_IO1 field.
	TSC_IOASCR_G8_IO1_Msk = 0x10000000
	// Bit G8_IO1.
	TSC_IOASCR_G8_IO1 = 0x10000000
	// Position of G7_IO4 field.
	TSC_IOASCR_G7_IO4_Pos = 0x1b
	// Bit mask of G7_IO4 field.
	TSC_IOASCR_G7_IO4_Msk = 0x8000000
	// Bit G7_IO4.
	TSC_IOASCR_G7_IO4 = 0x8000000
	// Position of G7_IO3 field.
	TSC_IOASCR_G7_IO3_Pos = 0x1a
	// Bit mask of G7_IO3 field.
	TSC_IOASCR_G7_IO3_Msk = 0x4000000
	// Bit G7_IO3.
	TSC_IOASCR_G7_IO3 = 0x4000000
	// Position of G7_IO2 field.
	TSC_IOASCR_G7_IO2_Pos = 0x19
	// Bit mask of G7_IO2 field.
	TSC_IOASCR_G7_IO2_Msk = 0x2000000
	// Bit G7_IO2.
	TSC_IOASCR_G7_IO2 = 0x2000000
	// Position of G7_IO1 field.
	TSC_IOASCR_G7_IO1_Pos = 0x18
	// Bit mask of G7_IO1 field.
	TSC_IOASCR_G7_IO1_Msk = 0x1000000
	// Bit G7_IO1.
	TSC_IOASCR_G7_IO1 = 0x1000000
	// Position of G6_IO4 field.
	TSC_IOASCR_G6_IO4_Pos = 0x17
	// Bit mask of G6_IO4 field.
	TSC_IOASCR_G6_IO4_Msk = 0x800000
	// Bit G6_IO4.
	TSC_IOASCR_G6_IO4 = 0x800000
	// Position of G6_IO3 field.
	TSC_IOASCR_G6_IO3_Pos = 0x16
	// Bit mask of G6_IO3 field.
	TSC_IOASCR_G6_IO3_Msk = 0x400000
	// Bit G6_IO3.
	TSC_IOASCR_G6_IO3 = 0x400000
	// Position of G6_IO2 field.
	TSC_IOASCR_G6_IO2_Pos = 0x15
	// Bit mask of G6_IO2 field.
	TSC_IOASCR_G6_IO2_Msk = 0x200000
	// Bit G6_IO2.
	TSC_IOASCR_G6_IO2 = 0x200000
	// Position of G6_IO1 field.
	TSC_IOASCR_G6_IO1_Pos = 0x14
	// Bit mask of G6_IO1 field.
	TSC_IOASCR_G6_IO1_Msk = 0x100000
	// Bit G6_IO1.
	TSC_IOASCR_G6_IO1 = 0x100000
	// Position of G5_IO4 field.
	TSC_IOASCR_G5_IO4_Pos = 0x13
	// Bit mask of G5_IO4 field.
	TSC_IOASCR_G5_IO4_Msk = 0x80000
	// Bit G5_IO4.
	TSC_IOASCR_G5_IO4 = 0x80000
	// Position of G5_IO3 field.
	TSC_IOASCR_G5_IO3_Pos = 0x12
	// Bit mask of G5_IO3 field.
	TSC_IOASCR_G5_IO3_Msk = 0x40000
	// Bit G5_IO3.
	TSC_IOASCR_G5_IO3 = 0x40000
	// Position of G5_IO2 field.
	TSC_IOASCR_G5_IO2_Pos = 0x11
	// Bit mask of G5_IO2 field.
	TSC_IOASCR_G5_IO2_Msk = 0x20000
	// Bit G5_IO2.
	TSC_IOASCR_G5_IO2 = 0x20000
	// Position of G5_IO1 field.
	TSC_IOASCR_G5_IO1_Pos = 0x10
	// Bit mask of G5_IO1 field.
	TSC_IOASCR_G5_IO1_Msk = 0x10000
	// Bit G5_IO1.
	TSC_IOASCR_G5_IO1 = 0x10000
	// Position of G4_IO4 field.
	TSC_IOASCR_G4_IO4_Pos = 0xf
	// Bit mask of G4_IO4 field.
	TSC_IOASCR_G4_IO4_Msk = 0x8000
	// Bit G4_IO4.
	TSC_IOASCR_G4_IO4 = 0x8000
	// Position of G4_IO3 field.
	TSC_IOASCR_G4_IO3_Pos = 0xe
	// Bit mask of G4_IO3 field.
	TSC_IOASCR_G4_IO3_Msk = 0x4000
	// Bit G4_IO3.
	TSC_IOASCR_G4_IO3 = 0x4000
	// Position of G4_IO2 field.
	TSC_IOASCR_G4_IO2_Pos = 0xd
	// Bit mask of G4_IO2 field.
	TSC_IOASCR_G4_IO2_Msk = 0x2000
	// Bit G4_IO2.
	TSC_IOASCR_G4_IO2 = 0x2000
	// Position of G4_IO1 field.
	TSC_IOASCR_G4_IO1_Pos = 0xc
	// Bit mask of G4_IO1 field.
	TSC_IOASCR_G4_IO1_Msk = 0x1000
	// Bit G4_IO1.
	TSC_IOASCR_G4_IO1 = 0x1000
	// Position of G3_IO4 field.
	TSC_IOASCR_G3_IO4_Pos = 0xb
	// Bit mask of G3_IO4 field.
	TSC_IOASCR_G3_IO4_Msk = 0x800
	// Bit G3_IO4.
	TSC_IOASCR_G3_IO4 = 0x800
	// Position of G3_IO3 field.
	TSC_IOASCR_G3_IO3_Pos = 0xa
	// Bit mask of G3_IO3 field.
	TSC_IOASCR_G3_IO3_Msk = 0x400
	// Bit G3_IO3.
	TSC_IOASCR_G3_IO3 = 0x400
	// Position of G3_IO2 field.
	TSC_IOASCR_G3_IO2_Pos = 0x9
	// Bit mask of G3_IO2 field.
	TSC_IOASCR_G3_IO2_Msk = 0x200
	// Bit G3_IO2.
	TSC_IOASCR_G3_IO2 = 0x200
	// Position of G3_IO1 field.
	TSC_IOASCR_G3_IO1_Pos = 0x8
	// Bit mask of G3_IO1 field.
	TSC_IOASCR_G3_IO1_Msk = 0x100
	// Bit G3_IO1.
	TSC_IOASCR_G3_IO1 = 0x100
	// Position of G2_IO4 field.
	TSC_IOASCR_G2_IO4_Pos = 0x7
	// Bit mask of G2_IO4 field.
	TSC_IOASCR_G2_IO4_Msk = 0x80
	// Bit G2_IO4.
	TSC_IOASCR_G2_IO4 = 0x80
	// Position of G2_IO3 field.
	TSC_IOASCR_G2_IO3_Pos = 0x6
	// Bit mask of G2_IO3 field.
	TSC_IOASCR_G2_IO3_Msk = 0x40
	// Bit G2_IO3.
	TSC_IOASCR_G2_IO3 = 0x40
	// Position of G2_IO2 field.
	TSC_IOASCR_G2_IO2_Pos = 0x5
	// Bit mask of G2_IO2 field.
	TSC_IOASCR_G2_IO2_Msk = 0x20
	// Bit G2_IO2.
	TSC_IOASCR_G2_IO2 = 0x20
	// Position of G2_IO1 field.
	TSC_IOASCR_G2_IO1_Pos = 0x4
	// Bit mask of G2_IO1 field.
	TSC_IOASCR_G2_IO1_Msk = 0x10
	// Bit G2_IO1.
	TSC_IOASCR_G2_IO1 = 0x10
	// Position of G1_IO4 field.
	TSC_IOASCR_G1_IO4_Pos = 0x3
	// Bit mask of G1_IO4 field.
	TSC_IOASCR_G1_IO4_Msk = 0x8
	// Bit G1_IO4.
	TSC_IOASCR_G1_IO4 = 0x8
	// Position of G1_IO3 field.
	TSC_IOASCR_G1_IO3_Pos = 0x2
	// Bit mask of G1_IO3 field.
	TSC_IOASCR_G1_IO3_Msk = 0x4
	// Bit G1_IO3.
	TSC_IOASCR_G1_IO3 = 0x4
	// Position of G1_IO2 field.
	TSC_IOASCR_G1_IO2_Pos = 0x1
	// Bit mask of G1_IO2 field.
	TSC_IOASCR_G1_IO2_Msk = 0x2
	// Bit G1_IO2.
	TSC_IOASCR_G1_IO2 = 0x2
	// Position of G1_IO1 field.
	TSC_IOASCR_G1_IO1_Pos = 0x0
	// Bit mask of G1_IO1 field.
	TSC_IOASCR_G1_IO1_Msk = 0x1
	// Bit G1_IO1.
	TSC_IOASCR_G1_IO1 = 0x1

	// IOSCR: I/O sampling control register
	// Position of G8_IO4 field.
	TSC_IOSCR_G8_IO4_Pos = 0x1f
	// Bit mask of G8_IO4 field.
	TSC_IOSCR_G8_IO4_Msk = 0x80000000
	// Bit G8_IO4.
	TSC_IOSCR_G8_IO4 = 0x80000000
	// Position of G8_IO3 field.
	TSC_IOSCR_G8_IO3_Pos = 0x1e
	// Bit mask of G8_IO3 field.
	TSC_IOSCR_G8_IO3_Msk = 0x40000000
	// Bit G8_IO3.
	TSC_IOSCR_G8_IO3 = 0x40000000
	// Position of G8_IO2 field.
	TSC_IOSCR_G8_IO2_Pos = 0x1d
	// Bit mask of G8_IO2 field.
	TSC_IOSCR_G8_IO2_Msk = 0x20000000
	// Bit G8_IO2.
	TSC_IOSCR_G8_IO2 = 0x20000000
	// Position of G8_IO1 field.
	TSC_IOSCR_G8_IO1_Pos = 0x1c
	// Bit mask of G8_IO1 field.
	TSC_IOSCR_G8_IO1_Msk = 0x10000000
	// Bit G8_IO1.
	TSC_IOSCR_G8_IO1 = 0x10000000
	// Position of G7_IO4 field.
	TSC_IOSCR_G7_IO4_Pos = 0x1b
	// Bit mask of G7_IO4 field.
	TSC_IOSCR_G7_IO4_Msk = 0x8000000
	// Bit G7_IO4.
	TSC_IOSCR_G7_IO4 = 0x8000000
	// Position of G7_IO3 field.
	TSC_IOSCR_G7_IO3_Pos = 0x1a
	// Bit mask of G7_IO3 field.
	TSC_IOSCR_G7_IO3_Msk = 0x4000000
	// Bit G7_IO3.
	TSC_IOSCR_G7_IO3 = 0x4000000
	// Position of G7_IO2 field.
	TSC_IOSCR_G7_IO2_Pos = 0x19
	// Bit mask of G7_IO2 field.
	TSC_IOSCR_G7_IO2_Msk = 0x2000000
	// Bit G7_IO2.
	TSC_IOSCR_G7_IO2 = 0x2000000
	// Position of G7_IO1 field.
	TSC_IOSCR_G7_IO1_Pos = 0x18
	// Bit mask of G7_IO1 field.
	TSC_IOSCR_G7_IO1_Msk = 0x1000000
	// Bit G7_IO1.
	TSC_IOSCR_G7_IO1 = 0x1000000
	// Position of G6_IO4 field.
	TSC_IOSCR_G6_IO4_Pos = 0x17
	// Bit mask of G6_IO4 field.
	TSC_IOSCR_G6_IO4_Msk = 0x800000
	// Bit G6_IO4.
	TSC_IOSCR_G6_IO4 = 0x800000
	// Position of G6_IO3 field.
	TSC_IOSCR_G6_IO3_Pos = 0x16
	// Bit mask of G6_IO3 field.
	TSC_IOSCR_G6_IO3_Msk = 0x400000
	// Bit G6_IO3.
	TSC_IOSCR_G6_IO3 = 0x400000
	// Position of G6_IO2 field.
	TSC_IOSCR_G6_IO2_Pos = 0x15
	// Bit mask of G6_IO2 field.
	TSC_IOSCR_G6_IO2_Msk = 0x200000
	// Bit G6_IO2.
	TSC_IOSCR_G6_IO2 = 0x200000
	// Position of G6_IO1 field.
	TSC_IOSCR_G6_IO1_Pos = 0x14
	// Bit mask of G6_IO1 field.
	TSC_IOSCR_G6_IO1_Msk = 0x100000
	// Bit G6_IO1.
	TSC_IOSCR_G6_IO1 = 0x100000
	// Position of G5_IO4 field.
	TSC_IOSCR_G5_IO4_Pos = 0x13
	// Bit mask of G5_IO4 field.
	TSC_IOSCR_G5_IO4_Msk = 0x80000
	// Bit G5_IO4.
	TSC_IOSCR_G5_IO4 = 0x80000
	// Position of G5_IO3 field.
	TSC_IOSCR_G5_IO3_Pos = 0x12
	// Bit mask of G5_IO3 field.
	TSC_IOSCR_G5_IO3_Msk = 0x40000
	// Bit G5_IO3.
	TSC_IOSCR_G5_IO3 = 0x40000
	// Position of G5_IO2 field.
	TSC_IOSCR_G5_IO2_Pos = 0x11
	// Bit mask of G5_IO2 field.
	TSC_IOSCR_G5_IO2_Msk = 0x20000
	// Bit G5_IO2.
	TSC_IOSCR_G5_IO2 = 0x20000
	// Position of G5_IO1 field.
	TSC_IOSCR_G5_IO1_Pos = 0x10
	// Bit mask of G5_IO1 field.
	TSC_IOSCR_G5_IO1_Msk = 0x10000
	// Bit G5_IO1.
	TSC_IOSCR_G5_IO1 = 0x10000
	// Position of G4_IO4 field.
	TSC_IOSCR_G4_IO4_Pos = 0xf
	// Bit mask of G4_IO4 field.
	TSC_IOSCR_G4_IO4_Msk = 0x8000
	// Bit G4_IO4.
	TSC_IOSCR_G4_IO4 = 0x8000
	// Position of G4_IO3 field.
	TSC_IOSCR_G4_IO3_Pos = 0xe
	// Bit mask of G4_IO3 field.
	TSC_IOSCR_G4_IO3_Msk = 0x4000
	// Bit G4_IO3.
	TSC_IOSCR_G4_IO3 = 0x4000
	// Position of G4_IO2 field.
	TSC_IOSCR_G4_IO2_Pos = 0xd
	// Bit mask of G4_IO2 field.
	TSC_IOSCR_G4_IO2_Msk = 0x2000
	// Bit G4_IO2.
	TSC_IOSCR_G4_IO2 = 0x2000
	// Position of G4_IO1 field.
	TSC_IOSCR_G4_IO1_Pos = 0xc
	// Bit mask of G4_IO1 field.
	TSC_IOSCR_G4_IO1_Msk = 0x1000
	// Bit G4_IO1.
	TSC_IOSCR_G4_IO1 = 0x1000
	// Position of G3_IO4 field.
	TSC_IOSCR_G3_IO4_Pos = 0xb
	// Bit mask of G3_IO4 field.
	TSC_IOSCR_G3_IO4_Msk = 0x800
	// Bit G3_IO4.
	TSC_IOSCR_G3_IO4 = 0x800
	// Position of G3_IO3 field.
	TSC_IOSCR_G3_IO3_Pos = 0xa
	// Bit mask of G3_IO3 field.
	TSC_IOSCR_G3_IO3_Msk = 0x400
	// Bit G3_IO3.
	TSC_IOSCR_G3_IO3 = 0x400
	// Position of G3_IO2 field.
	TSC_IOSCR_G3_IO2_Pos = 0x9
	// Bit mask of G3_IO2 field.
	TSC_IOSCR_G3_IO2_Msk = 0x200
	// Bit G3_IO2.
	TSC_IOSCR_G3_IO2 = 0x200
	// Position of G3_IO1 field.
	TSC_IOSCR_G3_IO1_Pos = 0x8
	// Bit mask of G3_IO1 field.
	TSC_IOSCR_G3_IO1_Msk = 0x100
	// Bit G3_IO1.
	TSC_IOSCR_G3_IO1 = 0x100
	// Position of G2_IO4 field.
	TSC_IOSCR_G2_IO4_Pos = 0x7
	// Bit mask of G2_IO4 field.
	TSC_IOSCR_G2_IO4_Msk = 0x80
	// Bit G2_IO4.
	TSC_IOSCR_G2_IO4 = 0x80
	// Position of G2_IO3 field.
	TSC_IOSCR_G2_IO3_Pos = 0x6
	// Bit mask of G2_IO3 field.
	TSC_IOSCR_G2_IO3_Msk = 0x40
	// Bit G2_IO3.
	TSC_IOSCR_G2_IO3 = 0x40
	// Position of G2_IO2 field.
	TSC_IOSCR_G2_IO2_Pos = 0x5
	// Bit mask of G2_IO2 field.
	TSC_IOSCR_G2_IO2_Msk = 0x20
	// Bit G2_IO2.
	TSC_IOSCR_G2_IO2 = 0x20
	// Position of G2_IO1 field.
	TSC_IOSCR_G2_IO1_Pos = 0x4
	// Bit mask of G2_IO1 field.
	TSC_IOSCR_G2_IO1_Msk = 0x10
	// Bit G2_IO1.
	TSC_IOSCR_G2_IO1 = 0x10
	// Position of G1_IO4 field.
	TSC_IOSCR_G1_IO4_Pos = 0x3
	// Bit mask of G1_IO4 field.
	TSC_IOSCR_G1_IO4_Msk = 0x8
	// Bit G1_IO4.
	TSC_IOSCR_G1_IO4 = 0x8
	// Position of G1_IO3 field.
	TSC_IOSCR_G1_IO3_Pos = 0x2
	// Bit mask of G1_IO3 field.
	TSC_IOSCR_G1_IO3_Msk = 0x4
	// Bit G1_IO3.
	TSC_IOSCR_G1_IO3 = 0x4
	// Position of G1_IO2 field.
	TSC_IOSCR_G1_IO2_Pos = 0x1
	// Bit mask of G1_IO2 field.
	TSC_IOSCR_G1_IO2_Msk = 0x2
	// Bit G1_IO2.
	TSC_IOSCR_G1_IO2 = 0x2
	// Position of G1_IO1 field.
	TSC_IOSCR_G1_IO1_Pos = 0x0
	// Bit mask of G1_IO1 field.
	TSC_IOSCR_G1_IO1_Msk = 0x1
	// Bit G1_IO1.
	TSC_IOSCR_G1_IO1 = 0x1

	// IOCCR: I/O channel control register
	// Position of G8_IO4 field.
	TSC_IOCCR_G8_IO4_Pos = 0x1f
	// Bit mask of G8_IO4 field.
	TSC_IOCCR_G8_IO4_Msk = 0x80000000
	// Bit G8_IO4.
	TSC_IOCCR_G8_IO4 = 0x80000000
	// Position of G8_IO3 field.
	TSC_IOCCR_G8_IO3_Pos = 0x1e
	// Bit mask of G8_IO3 field.
	TSC_IOCCR_G8_IO3_Msk = 0x40000000
	// Bit G8_IO3.
	TSC_IOCCR_G8_IO3 = 0x40000000
	// Position of G8_IO2 field.
	TSC_IOCCR_G8_IO2_Pos = 0x1d
	// Bit mask of G8_IO2 field.
	TSC_IOCCR_G8_IO2_Msk = 0x20000000
	// Bit G8_IO2.
	TSC_IOCCR_G8_IO2 = 0x20000000
	// Position of G8_IO1 field.
	TSC_IOCCR_G8_IO1_Pos = 0x1c
	// Bit mask of G8_IO1 field.
	TSC_IOCCR_G8_IO1_Msk = 0x10000000
	// Bit G8_IO1.
	TSC_IOCCR_G8_IO1 = 0x10000000
	// Position of G7_IO4 field.
	TSC_IOCCR_G7_IO4_Pos = 0x1b
	// Bit mask of G7_IO4 field.
	TSC_IOCCR_G7_IO4_Msk = 0x8000000
	// Bit G7_IO4.
	TSC_IOCCR_G7_IO4 = 0x8000000
	// Position of G7_IO3 field.
	TSC_IOCCR_G7_IO3_Pos = 0x1a
	// Bit mask of G7_IO3 field.
	TSC_IOCCR_G7_IO3_Msk = 0x4000000
	// Bit G7_IO3.
	TSC_IOCCR_G7_IO3 = 0x4000000
	// Position of G7_IO2 field.
	TSC_IOCCR_G7_IO2_Pos = 0x19
	// Bit mask of G7_IO2 field.
	TSC_IOCCR_G7_IO2_Msk = 0x2000000
	// Bit G7_IO2.
	TSC_IOCCR_G7_IO2 = 0x2000000
	// Position of G7_IO1 field.
	TSC_IOCCR_G7_IO1_Pos = 0x18
	// Bit mask of G7_IO1 field.
	TSC_IOCCR_G7_IO1_Msk = 0x1000000
	// Bit G7_IO1.
	TSC_IOCCR_G7_IO1 = 0x1000000
	// Position of G6_IO4 field.
	TSC_IOCCR_G6_IO4_Pos = 0x17
	// Bit mask of G6_IO4 field.
	TSC_IOCCR_G6_IO4_Msk = 0x800000
	// Bit G6_IO4.
	TSC_IOCCR_G6_IO4 = 0x800000
	// Position of G6_IO3 field.
	TSC_IOCCR_G6_IO3_Pos = 0x16
	// Bit mask of G6_IO3 field.
	TSC_IOCCR_G6_IO3_Msk = 0x400000
	// Bit G6_IO3.
	TSC_IOCCR_G6_IO3 = 0x400000
	// Position of G6_IO2 field.
	TSC_IOCCR_G6_IO2_Pos = 0x15
	// Bit mask of G6_IO2 field.
	TSC_IOCCR_G6_IO2_Msk = 0x200000
	// Bit G6_IO2.
	TSC_IOCCR_G6_IO2 = 0x200000
	// Position of G6_IO1 field.
	TSC_IOCCR_G6_IO1_Pos = 0x14
	// Bit mask of G6_IO1 field.
	TSC_IOCCR_G6_IO1_Msk = 0x100000
	// Bit G6_IO1.
	TSC_IOCCR_G6_IO1 = 0x100000
	// Position of G5_IO4 field.
	TSC_IOCCR_G5_IO4_Pos = 0x13
	// Bit mask of G5_IO4 field.
	TSC_IOCCR_G5_IO4_Msk = 0x80000
	// Bit G5_IO4.
	TSC_IOCCR_G5_IO4 = 0x80000
	// Position of G5_IO3 field.
	TSC_IOCCR_G5_IO3_Pos = 0x12
	// Bit mask of G5_IO3 field.
	TSC_IOCCR_G5_IO3_Msk = 0x40000
	// Bit G5_IO3.
	TSC_IOCCR_G5_IO3 = 0x40000
	// Position of G5_IO2 field.
	TSC_IOCCR_G5_IO2_Pos = 0x11
	// Bit mask of G5_IO2 field.
	TSC_IOCCR_G5_IO2_Msk = 0x20000
	// Bit G5_IO2.
	TSC_IOCCR_G5_IO2 = 0x20000
	// Position of G5_IO1 field.
	TSC_IOCCR_G5_IO1_Pos = 0x10
	// Bit mask of G5_IO1 field.
	TSC_IOCCR_G5_IO1_Msk = 0x10000
	// Bit G5_IO1.
	TSC_IOCCR_G5_IO1 = 0x10000
	// Position of G4_IO4 field.
	TSC_IOCCR_G4_IO4_Pos = 0xf
	// Bit mask of G4_IO4 field.
	TSC_IOCCR_G4_IO4_Msk = 0x8000
	// Bit G4_IO4.
	TSC_IOCCR_G4_IO4 = 0x8000
	// Position of G4_IO3 field.
	TSC_IOCCR_G4_IO3_Pos = 0xe
	// Bit mask of G4_IO3 field.
	TSC_IOCCR_G4_IO3_Msk = 0x4000
	// Bit G4_IO3.
	TSC_IOCCR_G4_IO3 = 0x4000
	// Position of G4_IO2 field.
	TSC_IOCCR_G4_IO2_Pos = 0xd
	// Bit mask of G4_IO2 field.
	TSC_IOCCR_G4_IO2_Msk = 0x2000
	// Bit G4_IO2.
	TSC_IOCCR_G4_IO2 = 0x2000
	// Position of G4_IO1 field.
	TSC_IOCCR_G4_IO1_Pos = 0xc
	// Bit mask of G4_IO1 field.
	TSC_IOCCR_G4_IO1_Msk = 0x1000
	// Bit G4_IO1.
	TSC_IOCCR_G4_IO1 = 0x1000
	// Position of G3_IO4 field.
	TSC_IOCCR_G3_IO4_Pos = 0xb
	// Bit mask of G3_IO4 field.
	TSC_IOCCR_G3_IO4_Msk = 0x800
	// Bit G3_IO4.
	TSC_IOCCR_G3_IO4 = 0x800
	// Position of G3_IO3 field.
	TSC_IOCCR_G3_IO3_Pos = 0xa
	// Bit mask of G3_IO3 field.
	TSC_IOCCR_G3_IO3_Msk = 0x400
	// Bit G3_IO3.
	TSC_IOCCR_G3_IO3 = 0x400
	// Position of G3_IO2 field.
	TSC_IOCCR_G3_IO2_Pos = 0x9
	// Bit mask of G3_IO2 field.
	TSC_IOCCR_G3_IO2_Msk = 0x200
	// Bit G3_IO2.
	TSC_IOCCR_G3_IO2 = 0x200
	// Position of G3_IO1 field.
	TSC_IOCCR_G3_IO1_Pos = 0x8
	// Bit mask of G3_IO1 field.
	TSC_IOCCR_G3_IO1_Msk = 0x100
	// Bit G3_IO1.
	TSC_IOCCR_G3_IO1 = 0x100
	// Position of G2_IO4 field.
	TSC_IOCCR_G2_IO4_Pos = 0x7
	// Bit mask of G2_IO4 field.
	TSC_IOCCR_G2_IO4_Msk = 0x80
	// Bit G2_IO4.
	TSC_IOCCR_G2_IO4 = 0x80
	// Position of G2_IO3 field.
	TSC_IOCCR_G2_IO3_Pos = 0x6
	// Bit mask of G2_IO3 field.
	TSC_IOCCR_G2_IO3_Msk = 0x40
	// Bit G2_IO3.
	TSC_IOCCR_G2_IO3 = 0x40
	// Position of G2_IO2 field.
	TSC_IOCCR_G2_IO2_Pos = 0x5
	// Bit mask of G2_IO2 field.
	TSC_IOCCR_G2_IO2_Msk = 0x20
	// Bit G2_IO2.
	TSC_IOCCR_G2_IO2 = 0x20
	// Position of G2_IO1 field.
	TSC_IOCCR_G2_IO1_Pos = 0x4
	// Bit mask of G2_IO1 field.
	TSC_IOCCR_G2_IO1_Msk = 0x10
	// Bit G2_IO1.
	TSC_IOCCR_G2_IO1 = 0x10
	// Position of G1_IO4 field.
	TSC_IOCCR_G1_IO4_Pos = 0x3
	// Bit mask of G1_IO4 field.
	TSC_IOCCR_G1_IO4_Msk = 0x8
	// Bit G1_IO4.
	TSC_IOCCR_G1_IO4 = 0x8
	// Position of G1_IO3 field.
	TSC_IOCCR_G1_IO3_Pos = 0x2
	// Bit mask of G1_IO3 field.
	TSC_IOCCR_G1_IO3_Msk = 0x4
	// Bit G1_IO3.
	TSC_IOCCR_G1_IO3 = 0x4
	// Position of G1_IO2 field.
	TSC_IOCCR_G1_IO2_Pos = 0x1
	// Bit mask of G1_IO2 field.
	TSC_IOCCR_G1_IO2_Msk = 0x2
	// Bit G1_IO2.
	TSC_IOCCR_G1_IO2 = 0x2
	// Position of G1_IO1 field.
	TSC_IOCCR_G1_IO1_Pos = 0x0
	// Bit mask of G1_IO1 field.
	TSC_IOCCR_G1_IO1_Msk = 0x1
	// Bit G1_IO1.
	TSC_IOCCR_G1_IO1 = 0x1

	// IOGCSR: I/O group control status register
	// Position of G8S field.
	TSC_IOGCSR_G8S_Pos = 0x17
	// Bit mask of G8S field.
	TSC_IOGCSR_G8S_Msk = 0x800000
	// Bit G8S.
	TSC_IOGCSR_G8S = 0x800000
	// Position of G7S field.
	TSC_IOGCSR_G7S_Pos = 0x16
	// Bit mask of G7S field.
	TSC_IOGCSR_G7S_Msk = 0x400000
	// Bit G7S.
	TSC_IOGCSR_G7S = 0x400000
	// Position of G6S field.
	TSC_IOGCSR_G6S_Pos = 0x15
	// Bit mask of G6S field.
	TSC_IOGCSR_G6S_Msk = 0x200000
	// Bit G6S.
	TSC_IOGCSR_G6S = 0x200000
	// Position of G5S field.
	TSC_IOGCSR_G5S_Pos = 0x14
	// Bit mask of G5S field.
	TSC_IOGCSR_G5S_Msk = 0x100000
	// Bit G5S.
	TSC_IOGCSR_G5S = 0x100000
	// Position of G4S field.
	TSC_IOGCSR_G4S_Pos = 0x13
	// Bit mask of G4S field.
	TSC_IOGCSR_G4S_Msk = 0x80000
	// Bit G4S.
	TSC_IOGCSR_G4S = 0x80000
	// Position of G3S field.
	TSC_IOGCSR_G3S_Pos = 0x12
	// Bit mask of G3S field.
	TSC_IOGCSR_G3S_Msk = 0x40000
	// Bit G3S.
	TSC_IOGCSR_G3S = 0x40000
	// Position of G2S field.
	TSC_IOGCSR_G2S_Pos = 0x11
	// Bit mask of G2S field.
	TSC_IOGCSR_G2S_Msk = 0x20000
	// Bit G2S.
	TSC_IOGCSR_G2S = 0x20000
	// Position of G1S field.
	TSC_IOGCSR_G1S_Pos = 0x10
	// Bit mask of G1S field.
	TSC_IOGCSR_G1S_Msk = 0x10000
	// Bit G1S.
	TSC_IOGCSR_G1S = 0x10000
	// Position of G8E field.
	TSC_IOGCSR_G8E_Pos = 0x7
	// Bit mask of G8E field.
	TSC_IOGCSR_G8E_Msk = 0x80
	// Bit G8E.
	TSC_IOGCSR_G8E = 0x80
	// Position of G7E field.
	TSC_IOGCSR_G7E_Pos = 0x6
	// Bit mask of G7E field.
	TSC_IOGCSR_G7E_Msk = 0x40
	// Bit G7E.
	TSC_IOGCSR_G7E = 0x40
	// Position of G6E field.
	TSC_IOGCSR_G6E_Pos = 0x5
	// Bit mask of G6E field.
	TSC_IOGCSR_G6E_Msk = 0x20
	// Bit G6E.
	TSC_IOGCSR_G6E = 0x20
	// Position of G5E field.
	TSC_IOGCSR_G5E_Pos = 0x4
	// Bit mask of G5E field.
	TSC_IOGCSR_G5E_Msk = 0x10
	// Bit G5E.
	TSC_IOGCSR_G5E = 0x10
	// Position of G4E field.
	TSC_IOGCSR_G4E_Pos = 0x3
	// Bit mask of G4E field.
	TSC_IOGCSR_G4E_Msk = 0x8
	// Bit G4E.
	TSC_IOGCSR_G4E = 0x8
	// Position of G3E field.
	TSC_IOGCSR_G3E_Pos = 0x2
	// Bit mask of G3E field.
	TSC_IOGCSR_G3E_Msk = 0x4
	// Bit G3E.
	TSC_IOGCSR_G3E = 0x4
	// Position of G2E field.
	TSC_IOGCSR_G2E_Pos = 0x1
	// Bit mask of G2E field.
	TSC_IOGCSR_G2E_Msk = 0x2
	// Bit G2E.
	TSC_IOGCSR_G2E = 0x2
	// Position of G1E field.
	TSC_IOGCSR_G1E_Pos = 0x0
	// Bit mask of G1E field.
	TSC_IOGCSR_G1E_Msk = 0x1
	// Bit G1E.
	TSC_IOGCSR_G1E = 0x1

	// IOG1CR: I/O group x counter register
	// Position of CNT field.
	TSC_IOGCR_CNT_Pos = 0x0
	// Bit mask of CNT field.
	TSC_IOGCR_CNT_Msk = 0x3fff
)

// Bitfields for IWDG: Independent watchdog
const (
	// KR: Key register
	// Position of KEY field.
	IWDG_KR_KEY_Pos = 0x0
	// Bit mask of KEY field.
	IWDG_KR_KEY_Msk = 0xffff
	// Enable access to PR, RLR and WINR registers (0x5555)
	IWDG_KR_KEY_Enable = 0x5555
	// Reset the watchdog value (0xAAAA)
	IWDG_KR_KEY_Reset = 0xaaaa
	// Start the watchdog (0xCCCC)
	IWDG_KR_KEY_Start = 0xcccc

	// PR: Prescaler register
	// Position of PR field.
	IWDG_PR_PR_Pos = 0x0
	// Bit mask of PR field.
	IWDG_PR_PR_Msk = 0x7
	// Divider /4
	IWDG_PR_PR_DivideBy4 = 0x0
	// Divider /8
	IWDG_PR_PR_DivideBy8 = 0x1
	// Divider /16
	IWDG_PR_PR_DivideBy16 = 0x2
	// Divider /32
	IWDG_PR_PR_DivideBy32 = 0x3
	// Divider /64
	IWDG_PR_PR_DivideBy64 = 0x4
	// Divider /128
	IWDG_PR_PR_DivideBy128 = 0x5
	// Divider /256
	IWDG_PR_PR_DivideBy256 = 0x6
	// Divider /256
	IWDG_PR_PR_DivideBy256bis = 0x7

	// RLR: Reload register
	// Position of RL field.
	IWDG_RLR_RL_Pos = 0x0
	// Bit mask of RL field.
	IWDG_RLR_RL_Msk = 0xfff

	// SR: Status register
	// Position of WVU field.
	IWDG_SR_WVU_Pos = 0x2
	// Bit mask of WVU field.
	IWDG_SR_WVU_Msk = 0x4
	// Bit WVU.
	IWDG_SR_WVU = 0x4
	// Position of RVU field.
	IWDG_SR_RVU_Pos = 0x1
	// Bit mask of RVU field.
	IWDG_SR_RVU_Msk = 0x2
	// Bit RVU.
	IWDG_SR_RVU = 0x2
	// Position of PVU field.
	IWDG_SR_PVU_Pos = 0x0
	// Bit mask of PVU field.
	IWDG_SR_PVU_Msk = 0x1
	// Bit PVU.
	IWDG_SR_PVU = 0x1

	// WINR: Window register
	// Position of WIN field.
	IWDG_WINR_WIN_Pos = 0x0
	// Bit mask of WIN field.
	IWDG_WINR_WIN_Msk = 0xfff
)

// Bitfields for WWDG: System window watchdog
const (
	// CR: Control register
	// Position of WDGA field.
	WWDG_CR_WDGA_Pos = 0x7
	// Bit mask of WDGA field.
	WWDG_CR_WDGA_Msk = 0x80
	// Bit WDGA.
	WWDG_CR_WDGA = 0x80
	// Watchdog disabled
	WWDG_CR_WDGA_Disabled = 0x0
	// Watchdog enabled
	WWDG_CR_WDGA_Enabled = 0x1
	// Position of T field.
	WWDG_CR_T_Pos = 0x0
	// Bit mask of T field.
	WWDG_CR_T_Msk = 0x7f

	// CFR: Configuration register
	// Position of EWI field.
	WWDG_CFR_EWI_Pos = 0x9
	// Bit mask of EWI field.
	WWDG_CFR_EWI_Msk = 0x200
	// Bit EWI.
	WWDG_CFR_EWI = 0x200
	// interrupt occurs whenever the counter reaches the value 0x40
	WWDG_CFR_EWI_Enable = 0x1
	// Position of W field.
	WWDG_CFR_W_Pos = 0x0
	// Bit mask of W field.
	WWDG_CFR_W_Msk = 0x7f
	// Position of WDGTB field.
	WWDG_CFR_WDGTB_Pos = 0x7
	// Bit mask of WDGTB field.
	WWDG_CFR_WDGTB_Msk = 0x180
	// Counter clock (PCLK1 div 4096) div 1
	WWDG_CFR_WDGTB_Div1 = 0x0
	// Counter clock (PCLK1 div 4096) div 2
	WWDG_CFR_WDGTB_Div2 = 0x1
	// Counter clock (PCLK1 div 4096) div 4
	WWDG_CFR_WDGTB_Div4 = 0x2
	// Counter clock (PCLK1 div 4096) div 8
	WWDG_CFR_WDGTB_Div8 = 0x3

	// SR: Status register
	// Position of EWIF field.
	WWDG_SR_EWIF_Pos = 0x0
	// Bit mask of EWIF field.
	WWDG_SR_EWIF_Msk = 0x1
	// Bit EWIF.
	WWDG_SR_EWIF = 0x1
	// The EWI Interrupt Service Routine has been triggered
	WWDG_SR_EWIF_Pending = 0x1
	// The EWI Interrupt Service Routine has been serviced
	WWDG_SR_EWIF_Finished = 0x0
)

// Bitfields for USB: Universal serial bus full-speed device interface
const (
	// EP0R: endpoint register
	// Position of CTR_RX field.
	USB_EP0R_CTR_RX_Pos = 0xf
	// Bit mask of CTR_RX field.
	USB_EP0R_CTR_RX_Msk = 0x8000
	// Bit CTR_RX.
	USB_EP0R_CTR_RX = 0x8000
	// Position of DTOG_RX field.
	USB_EP0R_DTOG_RX_Pos = 0xe
	// Bit mask of DTOG_RX field.
	USB_EP0R_DTOG_RX_Msk = 0x4000
	// Bit DTOG_RX.
	USB_EP0R_DTOG_RX = 0x4000
	// Position of STAT_RX field.
	USB_EP0R_STAT_RX_Pos = 0xc
	// Bit mask of STAT_RX field.
	USB_EP0R_STAT_RX_Msk = 0x3000
	// all reception requests addressed to this endpoint are ignored
	USB_EP0R_STAT_RX_Disabled = 0x0
	// the endpoint is stalled and all reception requests result in a STALL handshake
	USB_EP0R_STAT_RX_Stall = 0x1
	// the endpoint is naked and all reception requests result in a NAK handshake
	USB_EP0R_STAT_RX_Nak = 0x2
	// this endpoint is enabled for reception
	USB_EP0R_STAT_RX_Valid = 0x3
	// Position of SETUP field.
	USB_EP0R_SETUP_Pos = 0xb
	// Bit mask of SETUP field.
	USB_EP0R_SETUP_Msk = 0x800
	// Bit SETUP.
	USB_EP0R_SETUP = 0x800
	// Position of EP_TYPE field.
	USB_EP0R_EP_TYPE_Pos = 0x9
	// Bit mask of EP_TYPE field.
	USB_EP0R_EP_TYPE_Msk = 0x600
	// Bulk endpoint
	USB_EP0R_EP_TYPE_Bulk = 0x0
	// Control endpoint
	USB_EP0R_EP_TYPE_Control = 0x1
	// Iso endpoint
	USB_EP0R_EP_TYPE_Iso = 0x2
	// Interrupt endpoint
	USB_EP0R_EP_TYPE_Interrupt = 0x3
	// Position of EP_KIND field.
	USB_EP0R_EP_KIND_Pos = 0x8
	// Bit mask of EP_KIND field.
	USB_EP0R_EP_KIND_Msk = 0x100
	// Bit EP_KIND.
	USB_EP0R_EP_KIND = 0x100
	// Position of CTR_TX field.
	USB_EP0R_CTR_TX_Pos = 0x7
	// Bit mask of CTR_TX field.
	USB_EP0R_CTR_TX_Msk = 0x80
	// Bit CTR_TX.
	USB_EP0R_CTR_TX = 0x80
	// Position of DTOG_TX field.
	USB_EP0R_DTOG_TX_Pos = 0x6
	// Bit mask of DTOG_TX field.
	USB_EP0R_DTOG_TX_Msk = 0x40
	// Bit DTOG_TX.
	USB_EP0R_DTOG_TX = 0x40
	// Position of STAT_TX field.
	USB_EP0R_STAT_TX_Pos = 0x4
	// Bit mask of STAT_TX field.
	USB_EP0R_STAT_TX_Msk = 0x30
	// all transmission requests addressed to this endpoint are ignored
	USB_EP0R_STAT_TX_Disabled = 0x0
	// the endpoint is stalled and all transmission requests result in a STALL handshake
	USB_EP0R_STAT_TX_Stall = 0x1
	// the endpoint is naked and all transmission requests result in a NAK handshake
	USB_EP0R_STAT_TX_Nak = 0x2
	// this endpoint is enabled for transmission
	USB_EP0R_STAT_TX_Valid = 0x3
	// Position of EA field.
	USB_EP0R_EA_Pos = 0x0
	// Bit mask of EA field.
	USB_EP0R_EA_Msk = 0xf

	// EP1R: endpoint register
	// Position of CTR_RX field.
	USB_EP1R_CTR_RX_Pos = 0xf
	// Bit mask of CTR_RX field.
	USB_EP1R_CTR_RX_Msk = 0x8000
	// Bit CTR_RX.
	USB_EP1R_CTR_RX = 0x8000
	// Position of DTOG_RX field.
	USB_EP1R_DTOG_RX_Pos = 0xe
	// Bit mask of DTOG_RX field.
	USB_EP1R_DTOG_RX_Msk = 0x4000
	// Bit DTOG_RX.
	USB_EP1R_DTOG_RX = 0x4000
	// Position of STAT_RX field.
	USB_EP1R_STAT_RX_Pos = 0xc
	// Bit mask of STAT_RX field.
	USB_EP1R_STAT_RX_Msk = 0x3000
	// all reception requests addressed to this endpoint are ignored
	USB_EP1R_STAT_RX_Disabled = 0x0
	// the endpoint is stalled and all reception requests result in a STALL handshake
	USB_EP1R_STAT_RX_Stall = 0x1
	// the endpoint is naked and all reception requests result in a NAK handshake
	USB_EP1R_STAT_RX_Nak = 0x2
	// this endpoint is enabled for reception
	USB_EP1R_STAT_RX_Valid = 0x3
	// Position of SETUP field.
	USB_EP1R_SETUP_Pos = 0xb
	// Bit mask of SETUP field.
	USB_EP1R_SETUP_Msk = 0x800
	// Bit SETUP.
	USB_EP1R_SETUP = 0x800
	// Position of EP_TYPE field.
	USB_EP1R_EP_TYPE_Pos = 0x9
	// Bit mask of EP_TYPE field.
	USB_EP1R_EP_TYPE_Msk = 0x600
	// Bulk endpoint
	USB_EP1R_EP_TYPE_Bulk = 0x0
	// Control endpoint
	USB_EP1R_EP_TYPE_Control = 0x1
	// Iso endpoint
	USB_EP1R_EP_TYPE_Iso = 0x2
	// Interrupt endpoint
	USB_EP1R_EP_TYPE_Interrupt = 0x3
	// Position of EP_KIND field.
	USB_EP1R_EP_KIND_Pos = 0x8
	// Bit mask of EP_KIND field.
	USB_EP1R_EP_KIND_Msk = 0x100
	// Bit EP_KIND.
	USB_EP1R_EP_KIND = 0x100
	// Position of CTR_TX field.
	USB_EP1R_CTR_TX_Pos = 0x7
	// Bit mask of CTR_TX field.
	USB_EP1R_CTR_TX_Msk = 0x80
	// Bit CTR_TX.
	USB_EP1R_CTR_TX = 0x80
	// Position of DTOG_TX field.
	USB_EP1R_DTOG_TX_Pos = 0x6
	// Bit mask of DTOG_TX field.
	USB_EP1R_DTOG_TX_Msk = 0x40
	// Bit DTOG_TX.
	USB_EP1R_DTOG_TX = 0x40
	// Position of STAT_TX field.
	USB_EP1R_STAT_TX_Pos = 0x4
	// Bit mask of STAT_TX field.
	USB_EP1R_STAT_TX_Msk = 0x30
	// all transmission requests addressed to this endpoint are ignored
	USB_EP1R_STAT_TX_Disabled = 0x0
	// the endpoint is stalled and all transmission requests result in a STALL handshake
	USB_EP1R_STAT_TX_Stall = 0x1
	// the endpoint is naked and all transmission requests result in a NAK handshake
	USB_EP1R_STAT_TX_Nak = 0x2
	// this endpoint is enabled for transmission
	USB_EP1R_STAT_TX_Valid = 0x3
	// Position of EA field.
	USB_EP1R_EA_Pos = 0x0
	// Bit mask of EA field.
	USB_EP1R_EA_Msk = 0xf

	// EP2R: endpoint register
	// Position of CTR_RX field.
	USB_EP2R_CTR_RX_Pos = 0xf
	// Bit mask of CTR_RX field.
	USB_EP2R_CTR_RX_Msk = 0x8000
	// Bit CTR_RX.
	USB_EP2R_CTR_RX = 0x8000
	// Position of DTOG_RX field.
	USB_EP2R_DTOG_RX_Pos = 0xe
	// Bit mask of DTOG_RX field.
	USB_EP2R_DTOG_RX_Msk = 0x4000
	// Bit DTOG_RX.
	USB_EP2R_DTOG_RX = 0x4000
	// Position of STAT_RX field.
	USB_EP2R_STAT_RX_Pos = 0xc
	// Bit mask of STAT_RX field.
	USB_EP2R_STAT_RX_Msk = 0x3000
	// all reception requests addressed to this endpoint are ignored
	USB_EP2R_STAT_RX_Disabled = 0x0
	// the endpoint is stalled and all reception requests result in a STALL handshake
	USB_EP2R_STAT_RX_Stall = 0x1
	// the endpoint is naked and all reception requests result in a NAK handshake
	USB_EP2R_STAT_RX_Nak = 0x2
	// this endpoint is enabled for reception
	USB_EP2R_STAT_RX_Valid = 0x3
	// Position of SETUP field.
	USB_EP2R_SETUP_Pos = 0xb
	// Bit mask of SETUP field.
	USB_EP2R_SETUP_Msk = 0x800
	// Bit SETUP.
	USB_EP2R_SETUP = 0x800
	// Position of EP_TYPE field.
	USB_EP2R_EP_TYPE_Pos = 0x9
	// Bit mask of EP_TYPE field.
	USB_EP2R_EP_TYPE_Msk = 0x600
	// Bulk endpoint
	USB_EP2R_EP_TYPE_Bulk = 0x0
	// Control endpoint
	USB_EP2R_EP_TYPE_Control = 0x1
	// Iso endpoint
	USB_EP2R_EP_TYPE_Iso = 0x2
	// Interrupt endpoint
	USB_EP2R_EP_TYPE_Interrupt = 0x3
	// Position of EP_KIND field.
	USB_EP2R_EP_KIND_Pos = 0x8
	// Bit mask of EP_KIND field.
	USB_EP2R_EP_KIND_Msk = 0x100
	// Bit EP_KIND.
	USB_EP2R_EP_KIND = 0x100
	// Position of CTR_TX field.
	USB_EP2R_CTR_TX_Pos = 0x7
	// Bit mask of CTR_TX field.
	USB_EP2R_CTR_TX_Msk = 0x80
	// Bit CTR_TX.
	USB_EP2R_CTR_TX = 0x80
	// Position of DTOG_TX field.
	USB_EP2R_DTOG_TX_Pos = 0x6
	// Bit mask of DTOG_TX field.
	USB_EP2R_DTOG_TX_Msk = 0x40
	// Bit DTOG_TX.
	USB_EP2R_DTOG_TX = 0x40
	// Position of STAT_TX field.
	USB_EP2R_STAT_TX_Pos = 0x4
	// Bit mask of STAT_TX field.
	USB_EP2R_STAT_TX_Msk = 0x30
	// all transmission requests addressed to this endpoint are ignored
	USB_EP2R_STAT_TX_Disabled = 0x0
	// the endpoint is stalled and all transmission requests result in a STALL handshake
	USB_EP2R_STAT_TX_Stall = 0x1
	// the endpoint is naked and all transmission requests result in a NAK handshake
	USB_EP2R_STAT_TX_Nak = 0x2
	// this endpoint is enabled for transmission
	USB_EP2R_STAT_TX_Valid = 0x3
	// Position of EA field.
	USB_EP2R_EA_Pos = 0x0
	// Bit mask of EA field.
	USB_EP2R_EA_Msk = 0xf

	// EP3R: endpoint register
	// Position of CTR_RX field.
	USB_EP3R_CTR_RX_Pos = 0xf
	// Bit mask of CTR_RX field.
	USB_EP3R_CTR_RX_Msk = 0x8000
	// Bit CTR_RX.
	USB_EP3R_CTR_RX = 0x8000
	// Position of DTOG_RX field.
	USB_EP3R_DTOG_RX_Pos = 0xe
	// Bit mask of DTOG_RX field.
	USB_EP3R_DTOG_RX_Msk = 0x4000
	// Bit DTOG_RX.
	USB_EP3R_DTOG_RX = 0x4000
	// Position of STAT_RX field.
	USB_EP3R_STAT_RX_Pos = 0xc
	// Bit mask of STAT_RX field.
	USB_EP3R_STAT_RX_Msk = 0x3000
	// all reception requests addressed to this endpoint are ignored
	USB_EP3R_STAT_RX_Disabled = 0x0
	// the endpoint is stalled and all reception requests result in a STALL handshake
	USB_EP3R_STAT_RX_Stall = 0x1
	// the endpoint is naked and all reception requests result in a NAK handshake
	USB_EP3R_STAT_RX_Nak = 0x2
	// this endpoint is enabled for reception
	USB_EP3R_STAT_RX_Valid = 0x3
	// Position of SETUP field.
	USB_EP3R_SETUP_Pos = 0xb
	// Bit mask of SETUP field.
	USB_EP3R_SETUP_Msk = 0x800
	// Bit SETUP.
	USB_EP3R_SETUP = 0x800
	// Position of EP_TYPE field.
	USB_EP3R_EP_TYPE_Pos = 0x9
	// Bit mask of EP_TYPE field.
	USB_EP3R_EP_TYPE_Msk = 0x600
	// Bulk endpoint
	USB_EP3R_EP_TYPE_Bulk = 0x0
	// Control endpoint
	USB_EP3R_EP_TYPE_Control = 0x1
	// Iso endpoint
	USB_EP3R_EP_TYPE_Iso = 0x2
	// Interrupt endpoint
	USB_EP3R_EP_TYPE_Interrupt = 0x3
	// Position of EP_KIND field.
	USB_EP3R_EP_KIND_Pos = 0x8
	// Bit mask of EP_KIND field.
	USB_EP3R_EP_KIND_Msk = 0x100
	// Bit EP_KIND.
	USB_EP3R_EP_KIND = 0x100
	// Position of CTR_TX field.
	USB_EP3R_CTR_TX_Pos = 0x7
	// Bit mask of CTR_TX field.
	USB_EP3R_CTR_TX_Msk = 0x80
	// Bit CTR_TX.
	USB_EP3R_CTR_TX = 0x80
	// Position of DTOG_TX field.
	USB_EP3R_DTOG_TX_Pos = 0x6
	// Bit mask of DTOG_TX field.
	USB_EP3R_DTOG_TX_Msk = 0x40
	// Bit DTOG_TX.
	USB_EP3R_DTOG_TX = 0x40
	// Position of STAT_TX field.
	USB_EP3R_STAT_TX_Pos = 0x4
	// Bit mask of STAT_TX field.
	USB_EP3R_STAT_TX_Msk = 0x30
	// all transmission requests addressed to this endpoint are ignored
	USB_EP3R_STAT_TX_Disabled = 0x0
	// the endpoint is stalled and all transmission requests result in a STALL handshake
	USB_EP3R_STAT_TX_Stall = 0x1
	// the endpoint is naked and all transmission requests result in a NAK handshake
	USB_EP3R_STAT_TX_Nak = 0x2
	// this endpoint is enabled for transmission
	USB_EP3R_STAT_TX_Valid = 0x3
	// Position of EA field.
	USB_EP3R_EA_Pos = 0x0
	// Bit mask of EA field.
	USB_EP3R_EA_Msk = 0xf

	// EP4R: endpoint register
	// Position of CTR_RX field.
	USB_EP4R_CTR_RX_Pos = 0xf
	// Bit mask of CTR_RX field.
	USB_EP4R_CTR_RX_Msk = 0x8000
	// Bit CTR_RX.
	USB_EP4R_CTR_RX = 0x8000
	// Position of DTOG_RX field.
	USB_EP4R_DTOG_RX_Pos = 0xe
	// Bit mask of DTOG_RX field.
	USB_EP4R_DTOG_RX_Msk = 0x4000
	// Bit DTOG_RX.
	USB_EP4R_DTOG_RX = 0x4000
	// Position of STAT_RX field.
	USB_EP4R_STAT_RX_Pos = 0xc
	// Bit mask of STAT_RX field.
	USB_EP4R_STAT_RX_Msk = 0x3000
	// all reception requests addressed to this endpoint are ignored
	USB_EP4R_STAT_RX_Disabled = 0x0
	// the endpoint is stalled and all reception requests result in a STALL handshake
	USB_EP4R_STAT_RX_Stall = 0x1
	// the endpoint is naked and all reception requests result in a NAK handshake
	USB_EP4R_STAT_RX_Nak = 0x2
	// this endpoint is enabled for reception
	USB_EP4R_STAT_RX_Valid = 0x3
	// Position of SETUP field.
	USB_EP4R_SETUP_Pos = 0xb
	// Bit mask of SETUP field.
	USB_EP4R_SETUP_Msk = 0x800
	// Bit SETUP.
	USB_EP4R_SETUP = 0x800
	// Position of EP_TYPE field.
	USB_EP4R_EP_TYPE_Pos = 0x9
	// Bit mask of EP_TYPE field.
	USB_EP4R_EP_TYPE_Msk = 0x600
	// Bulk endpoint
	USB_EP4R_EP_TYPE_Bulk = 0x0
	// Control endpoint
	USB_EP4R_EP_TYPE_Control = 0x1
	// Iso endpoint
	USB_EP4R_EP_TYPE_Iso = 0x2
	// Interrupt endpoint
	USB_EP4R_EP_TYPE_Interrupt = 0x3
	// Position of EP_KIND field.
	USB_EP4R_EP_KIND_Pos = 0x8
	// Bit mask of EP_KIND field.
	USB_EP4R_EP_KIND_Msk = 0x100
	// Bit EP_KIND.
	USB_EP4R_EP_KIND = 0x100
	// Position of CTR_TX field.
	USB_EP4R_CTR_TX_Pos = 0x7
	// Bit mask of CTR_TX field.
	USB_EP4R_CTR_TX_Msk = 0x80
	// Bit CTR_TX.
	USB_EP4R_CTR_TX = 0x80
	// Position of DTOG_TX field.
	USB_EP4R_DTOG_TX_Pos = 0x6
	// Bit mask of DTOG_TX field.
	USB_EP4R_DTOG_TX_Msk = 0x40
	// Bit DTOG_TX.
	USB_EP4R_DTOG_TX = 0x40
	// Position of STAT_TX field.
	USB_EP4R_STAT_TX_Pos = 0x4
	// Bit mask of STAT_TX field.
	USB_EP4R_STAT_TX_Msk = 0x30
	// all transmission requests addressed to this endpoint are ignored
	USB_EP4R_STAT_TX_Disabled = 0x0
	// the endpoint is stalled and all transmission requests result in a STALL handshake
	USB_EP4R_STAT_TX_Stall = 0x1
	// the endpoint is naked and all transmission requests result in a NAK handshake
	USB_EP4R_STAT_TX_Nak = 0x2
	// this endpoint is enabled for transmission
	USB_EP4R_STAT_TX_Valid = 0x3
	// Position of EA field.
	USB_EP4R_EA_Pos = 0x0
	// Bit mask of EA field.
	USB_EP4R_EA_Msk = 0xf

	// EP5R: endpoint register
	// Position of CTR_RX field.
	USB_EP5R_CTR_RX_Pos = 0xf
	// Bit mask of CTR_RX field.
	USB_EP5R_CTR_RX_Msk = 0x8000
	// Bit CTR_RX.
	USB_EP5R_CTR_RX = 0x8000
	// Position of DTOG_RX field.
	USB_EP5R_DTOG_RX_Pos = 0xe
	// Bit mask of DTOG_RX field.
	USB_EP5R_DTOG_RX_Msk = 0x4000
	// Bit DTOG_RX.
	USB_EP5R_DTOG_RX = 0x4000
	// Position of STAT_RX field.
	USB_EP5R_STAT_RX_Pos = 0xc
	// Bit mask of STAT_RX field.
	USB_EP5R_STAT_RX_Msk = 0x3000
	// all reception requests addressed to this endpoint are ignored
	USB_EP5R_STAT_RX_Disabled = 0x0
	// the endpoint is stalled and all reception requests result in a STALL handshake
	USB_EP5R_STAT_RX_Stall = 0x1
	// the endpoint is naked and all reception requests result in a NAK handshake
	USB_EP5R_STAT_RX_Nak = 0x2
	// this endpoint is enabled for reception
	USB_EP5R_STAT_RX_Valid = 0x3
	// Position of SETUP field.
	USB_EP5R_SETUP_Pos = 0xb
	// Bit mask of SETUP field.
	USB_EP5R_SETUP_Msk = 0x800
	// Bit SETUP.
	USB_EP5R_SETUP = 0x800
	// Position of EP_TYPE field.
	USB_EP5R_EP_TYPE_Pos = 0x9
	// Bit mask of EP_TYPE field.
	USB_EP5R_EP_TYPE_Msk = 0x600
	// Bulk endpoint
	USB_EP5R_EP_TYPE_Bulk = 0x0
	// Control endpoint
	USB_EP5R_EP_TYPE_Control = 0x1
	// Iso endpoint
	USB_EP5R_EP_TYPE_Iso = 0x2
	// Interrupt endpoint
	USB_EP5R_EP_TYPE_Interrupt = 0x3
	// Position of EP_KIND field.
	USB_EP5R_EP_KIND_Pos = 0x8
	// Bit mask of EP_KIND field.
	USB_EP5R_EP_KIND_Msk = 0x100
	// Bit EP_KIND.
	USB_EP5R_EP_KIND = 0x100
	// Position of CTR_TX field.
	USB_EP5R_CTR_TX_Pos = 0x7
	// Bit mask of CTR_TX field.
	USB_EP5R_CTR_TX_Msk = 0x80
	// Bit CTR_TX.
	USB_EP5R_CTR_TX = 0x80
	// Position of DTOG_TX field.
	USB_EP5R_DTOG_TX_Pos = 0x6
	// Bit mask of DTOG_TX field.
	USB_EP5R_DTOG_TX_Msk = 0x40
	// Bit DTOG_TX.
	USB_EP5R_DTOG_TX = 0x40
	// Position of STAT_TX field.
	USB_EP5R_STAT_TX_Pos = 0x4
	// Bit mask of STAT_TX field.
	USB_EP5R_STAT_TX_Msk = 0x30
	// all transmission requests addressed to this endpoint are ignored
	USB_EP5R_STAT_TX_Disabled = 0x0
	// the endpoint is stalled and all transmission requests result in a STALL handshake
	USB_EP5R_STAT_TX_Stall = 0x1
	// the endpoint is naked and all transmission requests result in a NAK handshake
	USB_EP5R_STAT_TX_Nak = 0x2
	// this endpoint is enabled for transmission
	USB_EP5R_STAT_TX_Valid = 0x3
	// Position of EA field.
	USB_EP5R_EA_Pos = 0x0
	// Bit mask of EA field.
	USB_EP5R_EA_Msk = 0xf

	// EP6R: endpoint register
	// Position of CTR_RX field.
	USB_EP6R_CTR_RX_Pos = 0xf
	// Bit mask of CTR_RX field.
	USB_EP6R_CTR_RX_Msk = 0x8000
	// Bit CTR_RX.
	USB_EP6R_CTR_RX = 0x8000
	// Position of DTOG_RX field.
	USB_EP6R_DTOG_RX_Pos = 0xe
	// Bit mask of DTOG_RX field.
	USB_EP6R_DTOG_RX_Msk = 0x4000
	// Bit DTOG_RX.
	USB_EP6R_DTOG_RX = 0x4000
	// Position of STAT_RX field.
	USB_EP6R_STAT_RX_Pos = 0xc
	// Bit mask of STAT_RX field.
	USB_EP6R_STAT_RX_Msk = 0x3000
	// all reception requests addressed to this endpoint are ignored
	USB_EP6R_STAT_RX_Disabled = 0x0
	// the endpoint is stalled and all reception requests result in a STALL handshake
	USB_EP6R_STAT_RX_Stall = 0x1
	// the endpoint is naked and all reception requests result in a NAK handshake
	USB_EP6R_STAT_RX_Nak = 0x2
	// this endpoint is enabled for reception
	USB_EP6R_STAT_RX_Valid = 0x3
	// Position of SETUP field.
	USB_EP6R_SETUP_Pos = 0xb
	// Bit mask of SETUP field.
	USB_EP6R_SETUP_Msk = 0x800
	// Bit SETUP.
	USB_EP6R_SETUP = 0x800
	// Position of EP_TYPE field.
	USB_EP6R_EP_TYPE_Pos = 0x9
	// Bit mask of EP_TYPE field.
	USB_EP6R_EP_TYPE_Msk = 0x600
	// Bulk endpoint
	USB_EP6R_EP_TYPE_Bulk = 0x0
	// Control endpoint
	USB_EP6R_EP_TYPE_Control = 0x1
	// Iso endpoint
	USB_EP6R_EP_TYPE_Iso = 0x2
	// Interrupt endpoint
	USB_EP6R_EP_TYPE_Interrupt = 0x3
	// Position of EP_KIND field.
	USB_EP6R_EP_KIND_Pos = 0x8
	// Bit mask of EP_KIND field.
	USB_EP6R_EP_KIND_Msk = 0x100
	// Bit EP_KIND.
	USB_EP6R_EP_KIND = 0x100
	// Position of CTR_TX field.
	USB_EP6R_CTR_TX_Pos = 0x7
	// Bit mask of CTR_TX field.
	USB_EP6R_CTR_TX_Msk = 0x80
	// Bit CTR_TX.
	USB_EP6R_CTR_TX = 0x80
	// Position of DTOG_TX field.
	USB_EP6R_DTOG_TX_Pos = 0x6
	// Bit mask of DTOG_TX field.
	USB_EP6R_DTOG_TX_Msk = 0x40
	// Bit DTOG_TX.
	USB_EP6R_DTOG_TX = 0x40
	// Position of STAT_TX field.
	USB_EP6R_STAT_TX_Pos = 0x4
	// Bit mask of STAT_TX field.
	USB_EP6R_STAT_TX_Msk = 0x30
	// all transmission requests addressed to this endpoint are ignored
	USB_EP6R_STAT_TX_Disabled = 0x0
	// the endpoint is stalled and all transmission requests result in a STALL handshake
	USB_EP6R_STAT_TX_Stall = 0x1
	// the endpoint is naked and all transmission requests result in a NAK handshake
	USB_EP6R_STAT_TX_Nak = 0x2
	// this endpoint is enabled for transmission
	USB_EP6R_STAT_TX_Valid = 0x3
	// Position of EA field.
	USB_EP6R_EA_Pos = 0x0
	// Bit mask of EA field.
	USB_EP6R_EA_Msk = 0xf

	// EP7R: endpoint register
	// Position of CTR_RX field.
	USB_EP7R_CTR_RX_Pos = 0xf
	// Bit mask of CTR_RX field.
	USB_EP7R_CTR_RX_Msk = 0x8000
	// Bit CTR_RX.
	USB_EP7R_CTR_RX = 0x8000
	// Position of DTOG_RX field.
	USB_EP7R_DTOG_RX_Pos = 0xe
	// Bit mask of DTOG_RX field.
	USB_EP7R_DTOG_RX_Msk = 0x4000
	// Bit DTOG_RX.
	USB_EP7R_DTOG_RX = 0x4000
	// Position of STAT_RX field.
	USB_EP7R_STAT_RX_Pos = 0xc
	// Bit mask of STAT_RX field.
	USB_EP7R_STAT_RX_Msk = 0x3000
	// all reception requests addressed to this endpoint are ignored
	USB_EP7R_STAT_RX_Disabled = 0x0
	// the endpoint is stalled and all reception requests result in a STALL handshake
	USB_EP7R_STAT_RX_Stall = 0x1
	// the endpoint is naked and all reception requests result in a NAK handshake
	USB_EP7R_STAT_RX_Nak = 0x2
	// this endpoint is enabled for reception
	USB_EP7R_STAT_RX_Valid = 0x3
	// Position of SETUP field.
	USB_EP7R_SETUP_Pos = 0xb
	// Bit mask of SETUP field.
	USB_EP7R_SETUP_Msk = 0x800
	// Bit SETUP.
	USB_EP7R_SETUP = 0x800
	// Position of EP_TYPE field.
	USB_EP7R_EP_TYPE_Pos = 0x9
	// Bit mask of EP_TYPE field.
	USB_EP7R_EP_TYPE_Msk = 0x600
	// Bulk endpoint
	USB_EP7R_EP_TYPE_Bulk = 0x0
	// Control endpoint
	USB_EP7R_EP_TYPE_Control = 0x1
	// Iso endpoint
	USB_EP7R_EP_TYPE_Iso = 0x2
	// Interrupt endpoint
	USB_EP7R_EP_TYPE_Interrupt = 0x3
	// Position of EP_KIND field.
	USB_EP7R_EP_KIND_Pos = 0x8
	// Bit mask of EP_KIND field.
	USB_EP7R_EP_KIND_Msk = 0x100
	// Bit EP_KIND.
	USB_EP7R_EP_KIND = 0x100
	// Position of CTR_TX field.
	USB_EP7R_CTR_TX_Pos = 0x7
	// Bit mask of CTR_TX field.
	USB_EP7R_CTR_TX_Msk = 0x80
	// Bit CTR_TX.
	USB_EP7R_CTR_TX = 0x80
	// Position of DTOG_TX field.
	USB_EP7R_DTOG_TX_Pos = 0x6
	// Bit mask of DTOG_TX field.
	USB_EP7R_DTOG_TX_Msk = 0x40
	// Bit DTOG_TX.
	USB_EP7R_DTOG_TX = 0x40
	// Position of STAT_TX field.
	USB_EP7R_STAT_TX_Pos = 0x4
	// Bit mask of STAT_TX field.
	USB_EP7R_STAT_TX_Msk = 0x30
	// all transmission requests addressed to this endpoint are ignored
	USB_EP7R_STAT_TX_Disabled = 0x0
	// the endpoint is stalled and all transmission requests result in a STALL handshake
	USB_EP7R_STAT_TX_Stall = 0x1
	// the endpoint is naked and all transmission requests result in a NAK handshake
	USB_EP7R_STAT_TX_Nak = 0x2
	// this endpoint is enabled for transmission
	USB_EP7R_STAT_TX_Valid = 0x3
	// Position of EA field.
	USB_EP7R_EA_Pos = 0x0
	// Bit mask of EA field.
	USB_EP7R_EA_Msk = 0xf

	// CNTR: control register
	// Position of CTRM field.
	USB_CNTR_CTRM_Pos = 0xf
	// Bit mask of CTRM field.
	USB_CNTR_CTRM_Msk = 0x8000
	// Bit CTRM.
	USB_CNTR_CTRM = 0x8000
	// Correct Transfer (CTR) Interrupt disabled
	USB_CNTR_CTRM_Disabled = 0x0
	// CTR Interrupt enabled, an interrupt request is generated when the corresponding bit in the USB_ISTR register is set
	USB_CNTR_CTRM_Enabled = 0x1
	// Position of PMAOVRM field.
	USB_CNTR_PMAOVRM_Pos = 0xe
	// Bit mask of PMAOVRM field.
	USB_CNTR_PMAOVRM_Msk = 0x4000
	// Bit PMAOVRM.
	USB_CNTR_PMAOVRM = 0x4000
	// PMAOVR Interrupt disabled
	USB_CNTR_PMAOVRM_Disabled = 0x0
	// PMAOVR Interrupt enabled, an interrupt request is generated when the corresponding bit in the USB_ISTR register is set
	USB_CNTR_PMAOVRM_Enabled = 0x1
	// Position of ERRM field.
	USB_CNTR_ERRM_Pos = 0xd
	// Bit mask of ERRM field.
	USB_CNTR_ERRM_Msk = 0x2000
	// Bit ERRM.
	USB_CNTR_ERRM = 0x2000
	// ERR Interrupt disabled
	USB_CNTR_ERRM_Disabled = 0x0
	// ERR Interrupt enabled, an interrupt request is generated when the corresponding bit in the USB_ISTR register is set
	USB_CNTR_ERRM_Enabled = 0x1
	// Position of WKUPM field.
	USB_CNTR_WKUPM_Pos = 0xc
	// Bit mask of WKUPM field.
	USB_CNTR_WKUPM_Msk = 0x1000
	// Bit WKUPM.
	USB_CNTR_WKUPM = 0x1000
	// WKUP Interrupt disabled
	USB_CNTR_WKUPM_Disabled = 0x0
	// WKUP Interrupt enabled, an interrupt request is generated when the corresponding bit in the USB_ISTR register is set
	USB_CNTR_WKUPM_Enabled = 0x1
	// Position of SUSPM field.
	USB_CNTR_SUSPM_Pos = 0xb
	// Bit mask of SUSPM field.
	USB_CNTR_SUSPM_Msk = 0x800
	// Bit SUSPM.
	USB_CNTR_SUSPM = 0x800
	// Suspend Mode Request SUSP Interrupt disabled
	USB_CNTR_SUSPM_Disabled = 0x0
	// SUSP Interrupt enabled, an interrupt request is generated when the corresponding bit in the USB_ISTR register is set
	USB_CNTR_SUSPM_Enabled = 0x1
	// Position of RESETM field.
	USB_CNTR_RESETM_Pos = 0xa
	// Bit mask of RESETM field.
	USB_CNTR_RESETM_Msk = 0x400
	// Bit RESETM.
	USB_CNTR_RESETM = 0x400
	// RESET Interrupt disabled
	USB_CNTR_RESETM_Disabled = 0x0
	// RESET Interrupt enabled, an interrupt request is generated when the corresponding bit in the USB_ISTR register is set
	USB_CNTR_RESETM_Enabled = 0x1
	// Position of SOFM field.
	USB_CNTR_SOFM_Pos = 0x9
	// Bit mask of SOFM field.
	USB_CNTR_SOFM_Msk = 0x200
	// Bit SOFM.
	USB_CNTR_SOFM = 0x200
	// SOF Interrupt disabled
	USB_CNTR_SOFM_Disabled = 0x0
	// SOF Interrupt enabled, an interrupt request is generated when the corresponding bit in the USB_ISTR register is set
	USB_CNTR_SOFM_Enabled = 0x1
	// Position of ESOFM field.
	USB_CNTR_ESOFM_Pos = 0x8
	// Bit mask of ESOFM field.
	USB_CNTR_ESOFM_Msk = 0x100
	// Bit ESOFM.
	USB_CNTR_ESOFM = 0x100
	// ESOF Interrupt disabled
	USB_CNTR_ESOFM_Disabled = 0x0
	// ESOF Interrupt enabled, an interrupt request is generated when the corresponding bit in the USB_ISTR register is set
	USB_CNTR_ESOFM_Enabled = 0x1
	// Position of L1REQM field.
	USB_CNTR_L1REQM_Pos = 0x7
	// Bit mask of L1REQM field.
	USB_CNTR_L1REQM_Msk = 0x80
	// Bit L1REQM.
	USB_CNTR_L1REQM = 0x80
	// L1REQ Interrupt disabled
	USB_CNTR_L1REQM_Disabled = 0x0
	// L1REQ Interrupt enabled, an interrupt request is generated when the corresponding bit in the USB_ISTR register is set
	USB_CNTR_L1REQM_Enabled = 0x1
	// Position of L1RESUME field.
	USB_CNTR_L1RESUME_Pos = 0x5
	// Bit mask of L1RESUME field.
	USB_CNTR_L1RESUME_Msk = 0x20
	// Bit L1RESUME.
	USB_CNTR_L1RESUME = 0x20
	// LPM L1 request requested
	USB_CNTR_L1RESUME_Requested = 0x1
	// Position of RESUME field.
	USB_CNTR_RESUME_Pos = 0x4
	// Bit mask of RESUME field.
	USB_CNTR_RESUME_Msk = 0x10
	// Bit RESUME.
	USB_CNTR_RESUME = 0x10
	// Resume requested
	USB_CNTR_RESUME_Requested = 0x1
	// Position of FSUSP field.
	USB_CNTR_FSUSP_Pos = 0x3
	// Bit mask of FSUSP field.
	USB_CNTR_FSUSP_Msk = 0x8
	// Bit FSUSP.
	USB_CNTR_FSUSP = 0x8
	// No effect
	USB_CNTR_FSUSP_NoEffect = 0x0
	// Enter suspend mode. Clocks and static power dissipation in the analog transceiver are left unaffected
	USB_CNTR_FSUSP_Suspend = 0x1
	// Position of LPMODE field.
	USB_CNTR_LPMODE_Pos = 0x2
	// Bit mask of LPMODE field.
	USB_CNTR_LPMODE_Msk = 0x4
	// Bit LPMODE.
	USB_CNTR_LPMODE = 0x4
	// No low-power mode
	USB_CNTR_LPMODE_Disabled = 0x0
	// Enter low-power mode
	USB_CNTR_LPMODE_Enabled = 0x1
	// Position of PDWN field.
	USB_CNTR_PDWN_Pos = 0x1
	// Bit mask of PDWN field.
	USB_CNTR_PDWN_Msk = 0x2
	// Bit PDWN.
	USB_CNTR_PDWN = 0x2
	// No power down
	USB_CNTR_PDWN_Disabled = 0x0
	// Enter power down mode
	USB_CNTR_PDWN_Enabled = 0x1
	// Position of FRES field.
	USB_CNTR_FRES_Pos = 0x0
	// Bit mask of FRES field.
	USB_CNTR_FRES_Msk = 0x1
	// Bit FRES.
	USB_CNTR_FRES = 0x1
	// Clear USB reset
	USB_CNTR_FRES_NoReset = 0x0
	// Force a reset of the USB peripheral, exactly like a RESET signaling on the USB
	USB_CNTR_FRES_Reset = 0x1

	// ISTR: interrupt status register
	// Position of CTR field.
	USB_ISTR_CTR_Pos = 0xf
	// Bit mask of CTR field.
	USB_ISTR_CTR_Msk = 0x8000
	// Bit CTR.
	USB_ISTR_CTR = 0x8000
	// endpoint has successfully completed a transaction
	USB_ISTR_CTR_Completed = 0x1
	// Position of PMAOVR field.
	USB_ISTR_PMAOVR_Pos = 0xe
	// Bit mask of PMAOVR field.
	USB_ISTR_PMAOVR_Msk = 0x4000
	// Bit PMAOVR.
	USB_ISTR_PMAOVR = 0x4000
	// microcontroller has not been able to respond in time to an USB memory request
	USB_ISTR_PMAOVR_Overrun = 0x1
	// Position of ERR field.
	USB_ISTR_ERR_Pos = 0xd
	// Bit mask of ERR field.
	USB_ISTR_ERR_Msk = 0x2000
	// Bit ERR.
	USB_ISTR_ERR = 0x2000
	// One of No ANSwer, Cyclic Redundancy Check, Bit Stuffing or Framing format Violation error occurred
	USB_ISTR_ERR_Error = 0x1
	// Position of WKUP field.
	USB_ISTR_WKUP_Pos = 0xc
	// Bit mask of WKUP field.
	USB_ISTR_WKUP_Msk = 0x1000
	// Bit WKUP.
	USB_ISTR_WKUP = 0x1000
	// activity is detected that wakes up the USB peripheral
	USB_ISTR_WKUP_Wakeup = 0x1
	// Position of SUSP field.
	USB_ISTR_SUSP_Pos = 0xb
	// Bit mask of SUSP field.
	USB_ISTR_SUSP_Msk = 0x800
	// Bit SUSP.
	USB_ISTR_SUSP = 0x800
	// no traffic has been received for 3 ms, indicating a suspend mode request from the USB bus
	USB_ISTR_SUSP_Suspend = 0x1
	// Position of RESET field.
	USB_ISTR_RESET_Pos = 0xa
	// Bit mask of RESET field.
	USB_ISTR_RESET_Msk = 0x400
	// Bit RESET.
	USB_ISTR_RESET = 0x400
	// peripheral detects an active USB RESET signal at its inputs
	USB_ISTR_RESET_Reset = 0x1
	// Position of SOF field.
	USB_ISTR_SOF_Pos = 0x9
	// Bit mask of SOF field.
	USB_ISTR_SOF_Msk = 0x200
	// Bit SOF.
	USB_ISTR_SOF = 0x200
	// beginning of a new USB frame and it is set when a SOF packet arrives through the USB bus
	USB_ISTR_SOF_StartOfFrame = 0x1
	// Position of ESOF field.
	USB_ISTR_ESOF_Pos = 0x8
	// Bit mask of ESOF field.
	USB_ISTR_ESOF_Msk = 0x100
	// Bit ESOF.
	USB_ISTR_ESOF = 0x100
	// an SOF packet is expected but not received
	USB_ISTR_ESOF_ExpectedStartOfFrame = 0x1
	// Position of L1REQ field.
	USB_ISTR_L1REQ_Pos = 0x7
	// Bit mask of L1REQ field.
	USB_ISTR_L1REQ_Msk = 0x80
	// Bit L1REQ.
	USB_ISTR_L1REQ = 0x80
	// LPM command to enter the L1 state is successfully received and acknowledged
	USB_ISTR_L1REQ_Received = 0x1
	// Position of DIR field.
	USB_ISTR_DIR_Pos = 0x4
	// Bit mask of DIR field.
	USB_ISTR_DIR_Msk = 0x10
	// Bit DIR.
	USB_ISTR_DIR = 0x10
	// data transmitted by the USB peripheral to the host PC
	USB_ISTR_DIR_To = 0x0
	// data received by the USB peripheral from the host PC
	USB_ISTR_DIR_From = 0x1
	// Position of EP_ID field.
	USB_ISTR_EP_ID_Pos = 0x0
	// Bit mask of EP_ID field.
	USB_ISTR_EP_ID_Msk = 0xf

	// FNR: frame number register
	// Position of RXDP field.
	USB_FNR_RXDP_Pos = 0xf
	// Bit mask of RXDP field.
	USB_FNR_RXDP_Msk = 0x8000
	// Bit RXDP.
	USB_FNR_RXDP = 0x8000
	// received data plus upstream port data line
	USB_FNR_RXDP_Received = 0x1
	// Position of RXDM field.
	USB_FNR_RXDM_Pos = 0xe
	// Bit mask of RXDM field.
	USB_FNR_RXDM_Msk = 0x4000
	// Bit RXDM.
	USB_FNR_RXDM = 0x4000
	// received data minus upstream port data line
	USB_FNR_RXDM_Received = 0x1
	// Position of LCK field.
	USB_FNR_LCK_Pos = 0xd
	// Bit mask of LCK field.
	USB_FNR_LCK_Msk = 0x2000
	// Bit LCK.
	USB_FNR_LCK = 0x2000
	// the frame timer remains in this state until an USB reset or USB suspend event occurs
	USB_FNR_LCK_Locked = 0x1
	// Position of LSOF field.
	USB_FNR_LSOF_Pos = 0xb
	// Bit mask of LSOF field.
	USB_FNR_LSOF_Msk = 0x1800
	// Position of FN field.
	USB_FNR_FN_Pos = 0x0
	// Bit mask of FN field.
	USB_FNR_FN_Msk = 0x7ff

	// DADDR: device address
	// Position of EF field.
	USB_DADDR_EF_Pos = 0x7
	// Bit mask of EF field.
	USB_DADDR_EF_Msk = 0x80
	// Bit EF.
	USB_DADDR_EF = 0x80
	// USB device disabled
	USB_DADDR_EF_Disabled = 0x0
	// USB device enabled
	USB_DADDR_EF_Enabled = 0x1
	// Position of ADD field.
	USB_DADDR_ADD_Pos = 0x0
	// Bit mask of ADD field.
	USB_DADDR_ADD_Msk = 0x7f

	// BTABLE: Buffer table address
	// Position of BTABLE field.
	USB_BTABLE_BTABLE_Pos = 0x3
	// Bit mask of BTABLE field.
	USB_BTABLE_BTABLE_Msk = 0xfff8

	// LPMCSR: LPM control and status register
	// Position of BESL field.
	USB_LPMCSR_BESL_Pos = 0x4
	// Bit mask of BESL field.
	USB_LPMCSR_BESL_Msk = 0xf0
	// Position of REMWAKE field.
	USB_LPMCSR_REMWAKE_Pos = 0x3
	// Bit mask of REMWAKE field.
	USB_LPMCSR_REMWAKE_Msk = 0x8
	// Bit REMWAKE.
	USB_LPMCSR_REMWAKE = 0x8
	// Position of LPMACK field.
	USB_LPMCSR_LPMACK_Pos = 0x1
	// Bit mask of LPMACK field.
	USB_LPMCSR_LPMACK_Msk = 0x2
	// Bit LPMACK.
	USB_LPMCSR_LPMACK = 0x2
	// the valid LPM Token will be NYET
	USB_LPMCSR_LPMACK_Nyet = 0x0
	// the valid LPM Token will be ACK
	USB_LPMCSR_LPMACK_Ack = 0x1
	// Position of LPMEN field.
	USB_LPMCSR_LPMEN_Pos = 0x0
	// Bit mask of LPMEN field.
	USB_LPMCSR_LPMEN_Msk = 0x1
	// Bit LPMEN.
	USB_LPMCSR_LPMEN = 0x1
	// enable the LPM support within the USB device
	USB_LPMCSR_LPMEN_Disabled = 0x0
	// no LPM transactions are handled
	USB_LPMCSR_LPMEN_Enabled = 0x1

	// BCDR: Battery charging detector
	// Position of DPPU field.
	USB_BCDR_DPPU_Pos = 0xf
	// Bit mask of DPPU field.
	USB_BCDR_DPPU_Msk = 0x8000
	// Bit DPPU.
	USB_BCDR_DPPU = 0x8000
	// signalize disconnect to the host when needed by the user software
	USB_BCDR_DPPU_Disabled = 0x0
	// enable the embedded pull-up on the DP line
	USB_BCDR_DPPU_Enabled = 0x1
	// Position of PS2DET field.
	USB_BCDR_PS2DET_Pos = 0x7
	// Bit mask of PS2DET field.
	USB_BCDR_PS2DET_Msk = 0x80
	// Bit PS2DET.
	USB_BCDR_PS2DET = 0x80
	// Normal port detected
	USB_BCDR_PS2DET_Normal = 0x0
	// PS2 port or proprietary charger detected
	USB_BCDR_PS2DET_PS2 = 0x1
	// Position of SDET field.
	USB_BCDR_SDET_Pos = 0x6
	// Bit mask of SDET field.
	USB_BCDR_SDET_Msk = 0x40
	// Bit SDET.
	USB_BCDR_SDET = 0x40
	// CDP detected
	USB_BCDR_SDET_CDP = 0x0
	// DCP detected
	USB_BCDR_SDET_DCP = 0x1
	// Position of PDET field.
	USB_BCDR_PDET_Pos = 0x5
	// Bit mask of PDET field.
	USB_BCDR_PDET_Msk = 0x20
	// Bit PDET.
	USB_BCDR_PDET = 0x20
	// no BCD support detected
	USB_BCDR_PDET_NoBCD = 0x0
	// BCD support detected
	USB_BCDR_PDET_BCD = 0x1
	// Position of DCDET field.
	USB_BCDR_DCDET_Pos = 0x4
	// Bit mask of DCDET field.
	USB_BCDR_DCDET_Msk = 0x10
	// Bit DCDET.
	USB_BCDR_DCDET = 0x10
	// data lines contact not detected
	USB_BCDR_DCDET_NotDetected = 0x0
	// data lines contact detected
	USB_BCDR_DCDET_Detected = 0x1
	// Position of SDEN field.
	USB_BCDR_SDEN_Pos = 0x3
	// Bit mask of SDEN field.
	USB_BCDR_SDEN_Msk = 0x8
	// Bit SDEN.
	USB_BCDR_SDEN = 0x8
	// Secondary detection (SD) mode disabled
	USB_BCDR_SDEN_Disabled = 0x0
	// Secondary detection (SD) mode enabled
	USB_BCDR_SDEN_Enabled = 0x1
	// Position of PDEN field.
	USB_BCDR_PDEN_Pos = 0x2
	// Bit mask of PDEN field.
	USB_BCDR_PDEN_Msk = 0x4
	// Bit PDEN.
	USB_BCDR_PDEN = 0x4
	// Primary detection (PD) mode disabled
	USB_BCDR_PDEN_Disabled = 0x0
	// Primary detection (PD) mode enabled
	USB_BCDR_PDEN_Enabled = 0x1
	// Position of DCDEN field.
	USB_BCDR_DCDEN_Pos = 0x1
	// Bit mask of DCDEN field.
	USB_BCDR_DCDEN_Msk = 0x2
	// Bit DCDEN.
	USB_BCDR_DCDEN = 0x2
	// Data contact detection (DCD) mode disabled
	USB_BCDR_DCDEN_Disabled = 0x0
	// Data contact detection (DCD) mode enabled
	USB_BCDR_DCDEN_Enabled = 0x1
	// Position of BCDEN field.
	USB_BCDR_BCDEN_Pos = 0x0
	// Bit mask of BCDEN field.
	USB_BCDR_BCDEN_Msk = 0x1
	// Bit BCDEN.
	USB_BCDR_BCDEN = 0x1
	// disable the BCD support
	USB_BCDR_BCDEN_Disabled = 0x0
	// enable the BCD support within the USB device
	USB_BCDR_BCDEN_Enabled = 0x1
)

// Bitfields for CRS: Clock recovery system
const (
	// CR: control register
	// Position of TRIM field.
	CRS_CR_TRIM_Pos = 0x8
	// Bit mask of TRIM field.
	CRS_CR_TRIM_Msk = 0x3f00
	// Position of SWSYNC field.
	CRS_CR_SWSYNC_Pos = 0x7
	// Bit mask of SWSYNC field.
	CRS_CR_SWSYNC_Msk = 0x80
	// Bit SWSYNC.
	CRS_CR_SWSYNC = 0x80
	// Position of AUTOTRIMEN field.
	CRS_CR_AUTOTRIMEN_Pos = 0x6
	// Bit mask of AUTOTRIMEN field.
	CRS_CR_AUTOTRIMEN_Msk = 0x40
	// Bit AUTOTRIMEN.
	CRS_CR_AUTOTRIMEN = 0x40
	// Position of CEN field.
	CRS_CR_CEN_Pos = 0x5
	// Bit mask of CEN field.
	CRS_CR_CEN_Msk = 0x20
	// Bit CEN.
	CRS_CR_CEN = 0x20
	// Position of ESYNCIE field.
	CRS_CR_ESYNCIE_Pos = 0x3
	// Bit mask of ESYNCIE field.
	CRS_CR_ESYNCIE_Msk = 0x8
	// Bit ESYNCIE.
	CRS_CR_ESYNCIE = 0x8
	// Position of ERRIE field.
	CRS_CR_ERRIE_Pos = 0x2
	// Bit mask of ERRIE field.
	CRS_CR_ERRIE_Msk = 0x4
	// Bit ERRIE.
	CRS_CR_ERRIE = 0x4
	// Position of SYNCWARNIE field.
	CRS_CR_SYNCWARNIE_Pos = 0x1
	// Bit mask of SYNCWARNIE field.
	CRS_CR_SYNCWARNIE_Msk = 0x2
	// Bit SYNCWARNIE.
	CRS_CR_SYNCWARNIE = 0x2
	// Position of SYNCOKIE field.
	CRS_CR_SYNCOKIE_Pos = 0x0
	// Bit mask of SYNCOKIE field.
	CRS_CR_SYNCOKIE_Msk = 0x1
	// Bit SYNCOKIE.
	CRS_CR_SYNCOKIE = 0x1

	// CFGR: configuration register
	// Position of SYNCPOL field.
	CRS_CFGR_SYNCPOL_Pos = 0x1f
	// Bit mask of SYNCPOL field.
	CRS_CFGR_SYNCPOL_Msk = 0x80000000
	// Bit SYNCPOL.
	CRS_CFGR_SYNCPOL = 0x80000000
	// Position of SYNCSRC field.
	CRS_CFGR_SYNCSRC_Pos = 0x1c
	// Bit mask of SYNCSRC field.
	CRS_CFGR_SYNCSRC_Msk = 0x30000000
	// Position of SYNCDIV field.
	CRS_CFGR_SYNCDIV_Pos = 0x18
	// Bit mask of SYNCDIV field.
	CRS_CFGR_SYNCDIV_Msk = 0x7000000
	// Position of FELIM field.
	CRS_CFGR_FELIM_Pos = 0x10
	// Bit mask of FELIM field.
	CRS_CFGR_FELIM_Msk = 0xff0000
	// Position of RELOAD field.
	CRS_CFGR_RELOAD_Pos = 0x0
	// Bit mask of RELOAD field.
	CRS_CFGR_RELOAD_Msk = 0xffff

	// ISR: interrupt and status register
	// Position of FECAP field.
	CRS_ISR_FECAP_Pos = 0x10
	// Bit mask of FECAP field.
	CRS_ISR_FECAP_Msk = 0xffff0000
	// Position of FEDIR field.
	CRS_ISR_FEDIR_Pos = 0xf
	// Bit mask of FEDIR field.
	CRS_ISR_FEDIR_Msk = 0x8000
	// Bit FEDIR.
	CRS_ISR_FEDIR = 0x8000
	// Position of TRIMOVF field.
	CRS_ISR_TRIMOVF_Pos = 0xa
	// Bit mask of TRIMOVF field.
	CRS_ISR_TRIMOVF_Msk = 0x400
	// Bit TRIMOVF.
	CRS_ISR_TRIMOVF = 0x400
	// Position of SYNCMISS field.
	CRS_ISR_SYNCMISS_Pos = 0x9
	// Bit mask of SYNCMISS field.
	CRS_ISR_SYNCMISS_Msk = 0x200
	// Bit SYNCMISS.
	CRS_ISR_SYNCMISS = 0x200
	// Position of SYNCERR field.
	CRS_ISR_SYNCERR_Pos = 0x8
	// Bit mask of SYNCERR field.
	CRS_ISR_SYNCERR_Msk = 0x100
	// Bit SYNCERR.
	CRS_ISR_SYNCERR = 0x100
	// Position of ESYNCF field.
	CRS_ISR_ESYNCF_Pos = 0x3
	// Bit mask of ESYNCF field.
	CRS_ISR_ESYNCF_Msk = 0x8
	// Bit ESYNCF.
	CRS_ISR_ESYNCF = 0x8
	// Position of ERRF field.
	CRS_ISR_ERRF_Pos = 0x2
	// Bit mask of ERRF field.
	CRS_ISR_ERRF_Msk = 0x4
	// Bit ERRF.
	CRS_ISR_ERRF = 0x4
	// Position of SYNCWARNF field.
	CRS_ISR_SYNCWARNF_Pos = 0x1
	// Bit mask of SYNCWARNF field.
	CRS_ISR_SYNCWARNF_Msk = 0x2
	// Bit SYNCWARNF.
	CRS_ISR_SYNCWARNF = 0x2
	// Position of SYNCOKF field.
	CRS_ISR_SYNCOKF_Pos = 0x0
	// Bit mask of SYNCOKF field.
	CRS_ISR_SYNCOKF_Msk = 0x1
	// Bit SYNCOKF.
	CRS_ISR_SYNCOKF = 0x1

	// ICR: interrupt flag clear register
	// Position of ESYNCC field.
	CRS_ICR_ESYNCC_Pos = 0x3
	// Bit mask of ESYNCC field.
	CRS_ICR_ESYNCC_Msk = 0x8
	// Bit ESYNCC.
	CRS_ICR_ESYNCC = 0x8
	// Position of ERRC field.
	CRS_ICR_ERRC_Pos = 0x2
	// Bit mask of ERRC field.
	CRS_ICR_ERRC_Msk = 0x4
	// Bit ERRC.
	CRS_ICR_ERRC = 0x4
	// Position of SYNCWARNC field.
	CRS_ICR_SYNCWARNC_Pos = 0x1
	// Bit mask of SYNCWARNC field.
	CRS_ICR_SYNCWARNC_Msk = 0x2
	// Bit SYNCWARNC.
	CRS_ICR_SYNCWARNC = 0x2
	// Position of SYNCOKC field.
	CRS_ICR_SYNCOKC_Pos = 0x0
	// Bit mask of SYNCOKC field.
	CRS_ICR_SYNCOKC_Msk = 0x1
	// Bit SYNCOKC.
	CRS_ICR_SYNCOKC = 0x1
)

// Bitfields for FW: Firewall
const (
	// CSSA: Code segment start address
	// Position of ADD field.
	Firewall_CSSA_ADD_Pos = 0x8
	// Bit mask of ADD field.
	Firewall_CSSA_ADD_Msk = 0xffff00

	// CSL: Code segment length
	// Position of LENG field.
	Firewall_CSL_LENG_Pos = 0x8
	// Bit mask of LENG field.
	Firewall_CSL_LENG_Msk = 0x3fff00

	// NVDSSA: Non-volatile data segment start address
	// Position of ADD field.
	Firewall_NVDSSA_ADD_Pos = 0x8
	// Bit mask of ADD field.
	Firewall_NVDSSA_ADD_Msk = 0xffff00

	// NVDSL: Non-volatile data segment length
	// Position of LENG field.
	Firewall_NVDSL_LENG_Pos = 0x8
	// Bit mask of LENG field.
	Firewall_NVDSL_LENG_Msk = 0x3fff00

	// VDSSA: Volatile data segment start address
	// Position of ADD field.
	Firewall_VDSSA_ADD_Pos = 0x6
	// Bit mask of ADD field.
	Firewall_VDSSA_ADD_Msk = 0xffc0

	// VDSL: Volatile data segment length
	// Position of LENG field.
	Firewall_VDSL_LENG_Pos = 0x6
	// Bit mask of LENG field.
	Firewall_VDSL_LENG_Msk = 0xffc0

	// CR: Configuration register
	// Position of VDE field.
	Firewall_CR_VDE_Pos = 0x2
	// Bit mask of VDE field.
	Firewall_CR_VDE_Msk = 0x4
	// Bit VDE.
	Firewall_CR_VDE = 0x4
	// Volatile data segment cannot be executed if VDS = 0
	Firewall_CR_VDE_NotExecutable = 0x0
	// Volatile data segment is declared executable whatever VDS bit value
	Firewall_CR_VDE_Executable = 0x1
	// Resets volatile data execution bit
	Firewall_CR_VDE_Reset = 0x0
	// Position of VDS field.
	Firewall_CR_VDS_Pos = 0x1
	// Bit mask of VDS field.
	Firewall_CR_VDS_Msk = 0x2
	// Bit VDS.
	Firewall_CR_VDS = 0x2
	// Volatile data segment is not shared and cannot be hit by a non protected executable code when the Firewall is closed
	Firewall_CR_VDS_NotShared = 0x0
	// Volatile data segment is shared with non protected application code
	Firewall_CR_VDS_Shared = 0x1
	// Resets volatile data shared bit
	Firewall_CR_VDS_Reset = 0x0
	// Position of FPA field.
	Firewall_CR_FPA_Pos = 0x0
	// Bit mask of FPA field.
	Firewall_CR_FPA_Msk = 0x1
	// Bit FPA.
	Firewall_CR_FPA = 0x1
	// Any code executed outside the protected segment when the Firewall is opened will generate a system reset
	Firewall_CR_FPA_PreArmReset = 0x0
	// Any code executed outside the protected segment will close the Firewall
	Firewall_CR_FPA_PreArmSet = 0x1
)

// Bitfields for RCC: Reset and clock control
const (
	// CR: Clock control register
	// Position of PLLRDY field.
	RCC_CR_PLLRDY_Pos = 0x19
	// Bit mask of PLLRDY field.
	RCC_CR_PLLRDY_Msk = 0x2000000
	// Bit PLLRDY.
	RCC_CR_PLLRDY = 0x2000000
	// PLL unlocked
	RCC_CR_PLLRDY_Unlocked = 0x0
	// PLL locked
	RCC_CR_PLLRDY_Locked = 0x1
	// Position of PLLON field.
	RCC_CR_PLLON_Pos = 0x18
	// Bit mask of PLLON field.
	RCC_CR_PLLON_Msk = 0x1000000
	// Bit PLLON.
	RCC_CR_PLLON = 0x1000000
	// Clock disabled
	RCC_CR_PLLON_Disabled = 0x0
	// Clock enabled
	RCC_CR_PLLON_Enabled = 0x1
	// Position of RTCPRE field.
	RCC_CR_RTCPRE_Pos = 0x14
	// Bit mask of RTCPRE field.
	RCC_CR_RTCPRE_Msk = 0x300000
	// HSE divided by 2
	RCC_CR_RTCPRE_Div2 = 0x0
	// HSE divided by 4
	RCC_CR_RTCPRE_Div4 = 0x1
	// HSE divided by 8
	RCC_CR_RTCPRE_Div8 = 0x2
	// HSE divided by 16
	RCC_CR_RTCPRE_Div16 = 0x3
	// Position of CSSHSEON field.
	RCC_CR_CSSHSEON_Pos = 0x13
	// Bit mask of CSSHSEON field.
	RCC_CR_CSSHSEON_Msk = 0x80000
	// Bit CSSHSEON.
	RCC_CR_CSSHSEON = 0x80000
	// Clock disabled
	RCC_CR_CSSHSEON_Disabled = 0x0
	// Clock enabled
	RCC_CR_CSSHSEON_Enabled = 0x1
	// Position of HSEBYP field.
	RCC_CR_HSEBYP_Pos = 0x12
	// Bit mask of HSEBYP field.
	RCC_CR_HSEBYP_Msk = 0x40000
	// Bit HSEBYP.
	RCC_CR_HSEBYP = 0x40000
	// HSE oscillator not bypassed
	RCC_CR_HSEBYP_NotBypassed = 0x0
	// HSE oscillator bypassed
	RCC_CR_HSEBYP_Bypassed = 0x1
	// Position of HSERDY field.
	RCC_CR_HSERDY_Pos = 0x11
	// Bit mask of HSERDY field.
	RCC_CR_HSERDY_Msk = 0x20000
	// Bit HSERDY.
	RCC_CR_HSERDY = 0x20000
	// Oscillator is not stable
	RCC_CR_HSERDY_NotReady = 0x0
	// Oscillator is stable
	RCC_CR_HSERDY_Ready = 0x1
	// Position of HSEON field.
	RCC_CR_HSEON_Pos = 0x10
	// Bit mask of HSEON field.
	RCC_CR_HSEON_Msk = 0x10000
	// Bit HSEON.
	RCC_CR_HSEON = 0x10000
	// Clock disabled
	RCC_CR_HSEON_Disabled = 0x0
	// Clock enabled
	RCC_CR_HSEON_Enabled = 0x1
	// Position of MSIRDY field.
	RCC_CR_MSIRDY_Pos = 0x9
	// Bit mask of MSIRDY field.
	RCC_CR_MSIRDY_Msk = 0x200
	// Bit MSIRDY.
	RCC_CR_MSIRDY = 0x200
	// Oscillator is not stable
	RCC_CR_MSIRDY_NotReady = 0x0
	// Oscillator is stable
	RCC_CR_MSIRDY_Ready = 0x1
	// Position of MSION field.
	RCC_CR_MSION_Pos = 0x8
	// Bit mask of MSION field.
	RCC_CR_MSION_Msk = 0x100
	// Bit MSION.
	RCC_CR_MSION = 0x100
	// Clock disabled
	RCC_CR_MSION_Disabled = 0x0
	// Clock enabled
	RCC_CR_MSION_Enabled = 0x1
	// Position of HSI16DIVF field.
	RCC_CR_HSI16DIVF_Pos = 0x4
	// Bit mask of HSI16DIVF field.
	RCC_CR_HSI16DIVF_Msk = 0x10
	// Bit HSI16DIVF.
	RCC_CR_HSI16DIVF = 0x10
	// 16 MHz HSI clock not divided
	RCC_CR_HSI16DIVF_NotDivided = 0x0
	// 16 MHz HSI clock divided by 4
	RCC_CR_HSI16DIVF_Div4 = 0x1
	// Position of HSI16DIVEN field.
	RCC_CR_HSI16DIVEN_Pos = 0x3
	// Bit mask of HSI16DIVEN field.
	RCC_CR_HSI16DIVEN_Msk = 0x8
	// Bit HSI16DIVEN.
	RCC_CR_HSI16DIVEN = 0x8
	// no 16 MHz HSI division requested
	RCC_CR_HSI16DIVEN_NotDivided = 0x0
	// 16 MHz HSI division by 4 requested
	RCC_CR_HSI16DIVEN_Div4 = 0x1
	// Position of HSI16RDYF field.
	RCC_CR_HSI16RDYF_Pos = 0x2
	// Bit mask of HSI16RDYF field.
	RCC_CR_HSI16RDYF_Msk = 0x4
	// Bit HSI16RDYF.
	RCC_CR_HSI16RDYF = 0x4
	// HSI 16 MHz oscillator not ready
	RCC_CR_HSI16RDYF_NotReady = 0x0
	// HSI 16 MHz oscillator ready
	RCC_CR_HSI16RDYF_Ready = 0x1
	// Position of HSI16KERON field.
	RCC_CR_HSI16KERON_Pos = 0x1
	// Bit mask of HSI16KERON field.
	RCC_CR_HSI16KERON_Msk = 0x2
	// Bit HSI16KERON.
	RCC_CR_HSI16KERON = 0x2
	// Clock disabled
	RCC_CR_HSI16KERON_Disabled = 0x0
	// Clock enabled
	RCC_CR_HSI16KERON_Enabled = 0x1
	// Position of HSI16ON field.
	RCC_CR_HSI16ON_Pos = 0x0
	// Bit mask of HSI16ON field.
	RCC_CR_HSI16ON_Msk = 0x1
	// Bit HSI16ON.
	RCC_CR_HSI16ON = 0x1
	// Clock disabled
	RCC_CR_HSI16ON_Disabled = 0x0
	// Clock enabled
	RCC_CR_HSI16ON_Enabled = 0x1
	// Position of HSI16OUTEN field.
	RCC_CR_HSI16OUTEN_Pos = 0x5
	// Bit mask of HSI16OUTEN field.
	RCC_CR_HSI16OUTEN_Msk = 0x20
	// Bit HSI16OUTEN.
	RCC_CR_HSI16OUTEN = 0x20
	// HSI output clock disabled
	RCC_CR_HSI16OUTEN_Disabled = 0x0
	// HSI output clock enabled
	RCC_CR_HSI16OUTEN_Enabled = 0x1

	// ICSCR: Internal clock sources calibration register
	// Position of MSITRIM field.
	RCC_ICSCR_MSITRIM_Pos = 0x18
	// Bit mask of MSITRIM field.
	RCC_ICSCR_MSITRIM_Msk = 0xff000000
	// Position of MSICAL field.
	RCC_ICSCR_MSICAL_Pos = 0x10
	// Bit mask of MSICAL field.
	RCC_ICSCR_MSICAL_Msk = 0xff0000
	// Position of MSIRANGE field.
	RCC_ICSCR_MSIRANGE_Pos = 0xd
	// Bit mask of MSIRANGE field.
	RCC_ICSCR_MSIRANGE_Msk = 0xe000
	// range 0 around 65.536 kHz
	RCC_ICSCR_MSIRANGE_Range0 = 0x0
	// range 1 around 131.072 kHz
	RCC_ICSCR_MSIRANGE_Range1 = 0x1
	// range 2 around 262.144 kHz
	RCC_ICSCR_MSIRANGE_Range2 = 0x2
	// range 3 around 524.288 kHz
	RCC_ICSCR_MSIRANGE_Range3 = 0x3
	// range 4 around 1.048 MHz
	RCC_ICSCR_MSIRANGE_Range4 = 0x4
	// range 5 around 2.097 MHz (reset value)
	RCC_ICSCR_MSIRANGE_Range5 = 0x5
	// range 6 around 4.194 MHz
	RCC_ICSCR_MSIRANGE_Range6 = 0x6
	// not allowed
	RCC_ICSCR_MSIRANGE_Range7 = 0x7
	// Position of HSI16TRIM field.
	RCC_ICSCR_HSI16TRIM_Pos = 0x8
	// Bit mask of HSI16TRIM field.
	RCC_ICSCR_HSI16TRIM_Msk = 0x1f00
	// Position of HSI16CAL field.
	RCC_ICSCR_HSI16CAL_Pos = 0x0
	// Bit mask of HSI16CAL field.
	RCC_ICSCR_HSI16CAL_Msk = 0xff

	// CRRCR: Clock recovery RC register
	// Position of HSI48CAL field.
	RCC_CRRCR_HSI48CAL_Pos = 0x8
	// Bit mask of HSI48CAL field.
	RCC_CRRCR_HSI48CAL_Msk = 0xff00
	// Position of HSI48RDY field.
	RCC_CRRCR_HSI48RDY_Pos = 0x1
	// Bit mask of HSI48RDY field.
	RCC_CRRCR_HSI48RDY_Msk = 0x2
	// Bit HSI48RDY.
	RCC_CRRCR_HSI48RDY = 0x2
	// Position of HSI48ON field.
	RCC_CRRCR_HSI48ON_Pos = 0x0
	// Bit mask of HSI48ON field.
	RCC_CRRCR_HSI48ON_Msk = 0x1
	// Bit HSI48ON.
	RCC_CRRCR_HSI48ON = 0x1
	// Position of HSI48DIV6EN field.
	RCC_CRRCR_HSI48DIV6EN_Pos = 0x2
	// Bit mask of HSI48DIV6EN field.
	RCC_CRRCR_HSI48DIV6EN_Msk = 0x4
	// Bit HSI48DIV6EN.
	RCC_CRRCR_HSI48DIV6EN = 0x4

	// CFGR: Clock configuration register
	// Position of MCOPRE field.
	RCC_CFGR_MCOPRE_Pos = 0x1c
	// Bit mask of MCOPRE field.
	RCC_CFGR_MCOPRE_Msk = 0x70000000
	// No division
	RCC_CFGR_MCOPRE_Div1 = 0x0
	// Division by 2
	RCC_CFGR_MCOPRE_Div2 = 0x1
	// Division by 4
	RCC_CFGR_MCOPRE_Div4 = 0x2
	// Division by 8
	RCC_CFGR_MCOPRE_Div8 = 0x3
	// Division by 16
	RCC_CFGR_MCOPRE_Div16 = 0x4
	// Position of MCOSEL field.
	RCC_CFGR_MCOSEL_Pos = 0x18
	// Bit mask of MCOSEL field.
	RCC_CFGR_MCOSEL_Msk = 0xf000000
	// No clock
	RCC_CFGR_MCOSEL_NoClock = 0x0
	// SYSCLK clock selected
	RCC_CFGR_MCOSEL_SYSCLK = 0x1
	// HSI oscillator clock selected
	RCC_CFGR_MCOSEL_HSI16 = 0x2
	// MSI oscillator clock selected
	RCC_CFGR_MCOSEL_MSI = 0x3
	// HSE oscillator clock selected
	RCC_CFGR_MCOSEL_HSE = 0x4
	// PLL clock selected
	RCC_CFGR_MCOSEL_PLL = 0x5
	// LSI oscillator clock selected
	RCC_CFGR_MCOSEL_LSI = 0x6
	// LSE oscillator clock selected
	RCC_CFGR_MCOSEL_LSE = 0x7
	// Position of PLLDIV field.
	RCC_CFGR_PLLDIV_Pos = 0x16
	// Bit mask of PLLDIV field.
	RCC_CFGR_PLLDIV_Msk = 0xc00000
	// PLLVCO / 2
	RCC_CFGR_PLLDIV_Div2 = 0x1
	// PLLVCO / 3
	RCC_CFGR_PLLDIV_Div3 = 0x2
	// PLLVCO / 4
	RCC_CFGR_PLLDIV_Div4 = 0x3
	// Position of PLLMUL field.
	RCC_CFGR_PLLMUL_Pos = 0x12
	// Bit mask of PLLMUL field.
	RCC_CFGR_PLLMUL_Msk = 0x3c0000
	// PLL clock entry x 3
	RCC_CFGR_PLLMUL_Mul3 = 0x0
	// PLL clock entry x 4
	RCC_CFGR_PLLMUL_Mul4 = 0x1
	// PLL clock entry x 6
	RCC_CFGR_PLLMUL_Mul6 = 0x2
	// PLL clock entry x 8
	RCC_CFGR_PLLMUL_Mul8 = 0x3
	// PLL clock entry x 12
	RCC_CFGR_PLLMUL_Mul12 = 0x4
	// PLL clock entry x 16
	RCC_CFGR_PLLMUL_Mul16 = 0x5
	// PLL clock entry x 24
	RCC_CFGR_PLLMUL_Mul24 = 0x6
	// PLL clock entry x 32
	RCC_CFGR_PLLMUL_Mul32 = 0x7
	// PLL clock entry x 48
	RCC_CFGR_PLLMUL_Mul48 = 0x8
	// Position of PLLSRC field.
	RCC_CFGR_PLLSRC_Pos = 0x10
	// Bit mask of PLLSRC field.
	RCC_CFGR_PLLSRC_Msk = 0x10000
	// Bit PLLSRC.
	RCC_CFGR_PLLSRC = 0x10000
	// HSI selected as PLL input clock
	RCC_CFGR_PLLSRC_HSI16 = 0x0
	// HSE selected as PLL input clock
	RCC_CFGR_PLLSRC_HSE = 0x1
	// Position of STOPWUCK field.
	RCC_CFGR_STOPWUCK_Pos = 0xf
	// Bit mask of STOPWUCK field.
	RCC_CFGR_STOPWUCK_Msk = 0x8000
	// Bit STOPWUCK.
	RCC_CFGR_STOPWUCK = 0x8000
	// Internal 64 KHz to 4 MHz (MSI) oscillator selected as wake-up from Stop clock
	RCC_CFGR_STOPWUCK_MSI = 0x0
	// Internal 16 MHz (HSI) oscillator selected as wake-up from Stop clock (or HSI16/4 if HSI16DIVEN=1)
	RCC_CFGR_STOPWUCK_HSI16 = 0x1
	// Position of PPRE2 field.
	RCC_CFGR_PPRE2_Pos = 0xb
	// Bit mask of PPRE2 field.
	RCC_CFGR_PPRE2_Msk = 0x3800
	// HCLK not divided
	RCC_CFGR_PPRE2_Div1 = 0x0
	// HCLK divided by 2
	RCC_CFGR_PPRE2_Div2 = 0x4
	// HCLK divided by 4
	RCC_CFGR_PPRE2_Div4 = 0x5
	// HCLK divided by 8
	RCC_CFGR_PPRE2_Div8 = 0x6
	// HCLK divided by 16
	RCC_CFGR_PPRE2_Div16 = 0x7
	// Position of PPRE1 field.
	RCC_CFGR_PPRE1_Pos = 0x8
	// Bit mask of PPRE1 field.
	RCC_CFGR_PPRE1_Msk = 0x700
	// HCLK not divided
	RCC_CFGR_PPRE1_Div1 = 0x0
	// HCLK divided by 2
	RCC_CFGR_PPRE1_Div2 = 0x4
	// HCLK divided by 4
	RCC_CFGR_PPRE1_Div4 = 0x5
	// HCLK divided by 8
	RCC_CFGR_PPRE1_Div8 = 0x6
	// HCLK divided by 16
	RCC_CFGR_PPRE1_Div16 = 0x7
	// Position of HPRE field.
	RCC_CFGR_HPRE_Pos = 0x4
	// Bit mask of HPRE field.
	RCC_CFGR_HPRE_Msk = 0xf0
	// system clock not divided
	RCC_CFGR_HPRE_Div1 = 0x0
	// system clock divided by 2
	RCC_CFGR_HPRE_Div2 = 0x8
	// system clock divided by 4
	RCC_CFGR_HPRE_Div4 = 0x9
	// system clock divided by 8
	RCC_CFGR_HPRE_Div8 = 0xa
	// system clock divided by 16
	RCC_CFGR_HPRE_Div16 = 0xb
	// system clock divided by 64
	RCC_CFGR_HPRE_Div64 = 0xc
	// system clock divided by 128
	RCC_CFGR_HPRE_Div128 = 0xd
	// system clock divided by 256
	RCC_CFGR_HPRE_Div256 = 0xe
	// system clock divided by 512
	RCC_CFGR_HPRE_Div512 = 0xf
	// Position of SWS field.
	RCC_CFGR_SWS_Pos = 0x2
	// Bit mask of SWS field.
	RCC_CFGR_SWS_Msk = 0xc
	// MSI oscillator used as system clock
	RCC_CFGR_SWS_MSI = 0x0
	// HSI oscillator used as system clock
	RCC_CFGR_SWS_HSI16 = 0x1
	// HSE oscillator used as system clock
	RCC_CFGR_SWS_HSE = 0x2
	// PLL used as system clock
	RCC_CFGR_SWS_PLL = 0x3
	// Position of SW field.
	RCC_CFGR_SW_Pos = 0x0
	// Bit mask of SW field.
	RCC_CFGR_SW_Msk = 0x3
	// MSI oscillator used as system clock
	RCC_CFGR_SW_MSI = 0x0
	// HSI oscillator used as system clock
	RCC_CFGR_SW_HSI16 = 0x1
	// HSE oscillator used as system clock
	RCC_CFGR_SW_HSE = 0x2
	// PLL used as system clock
	RCC_CFGR_SW_PLL = 0x3

	// CIER: Clock interrupt enable register
	// Position of CSSLSE field.
	RCC_CIER_CSSLSE_Pos = 0x7
	// Bit mask of CSSLSE field.
	RCC_CIER_CSSLSE_Msk = 0x80
	// Bit CSSLSE.
	RCC_CIER_CSSLSE = 0x80
	// LSE CSS interrupt disabled
	RCC_CIER_CSSLSE_Disabled = 0x0
	// LSE CSS interrupt enabled
	RCC_CIER_CSSLSE_Enabled = 0x1
	// Position of HSI48RDYIE field.
	RCC_CIER_HSI48RDYIE_Pos = 0x6
	// Bit mask of HSI48RDYIE field.
	RCC_CIER_HSI48RDYIE_Msk = 0x40
	// Bit HSI48RDYIE.
	RCC_CIER_HSI48RDYIE = 0x40
	// Ready interrupt disabled
	RCC_CIER_HSI48RDYIE_Disabled = 0x0
	// Ready interrupt enabled
	RCC_CIER_HSI48RDYIE_Enabled = 0x1
	// Position of MSIRDYIE field.
	RCC_CIER_MSIRDYIE_Pos = 0x5
	// Bit mask of MSIRDYIE field.
	RCC_CIER_MSIRDYIE_Msk = 0x20
	// Bit MSIRDYIE.
	RCC_CIER_MSIRDYIE = 0x20
	// Ready interrupt disabled
	RCC_CIER_MSIRDYIE_Disabled = 0x0
	// Ready interrupt enabled
	RCC_CIER_MSIRDYIE_Enabled = 0x1
	// Position of PLLRDYIE field.
	RCC_CIER_PLLRDYIE_Pos = 0x4
	// Bit mask of PLLRDYIE field.
	RCC_CIER_PLLRDYIE_Msk = 0x10
	// Bit PLLRDYIE.
	RCC_CIER_PLLRDYIE = 0x10
	// Ready interrupt disabled
	RCC_CIER_PLLRDYIE_Disabled = 0x0
	// Ready interrupt enabled
	RCC_CIER_PLLRDYIE_Enabled = 0x1
	// Position of HSERDYIE field.
	RCC_CIER_HSERDYIE_Pos = 0x3
	// Bit mask of HSERDYIE field.
	RCC_CIER_HSERDYIE_Msk = 0x8
	// Bit HSERDYIE.
	RCC_CIER_HSERDYIE = 0x8
	// Ready interrupt disabled
	RCC_CIER_HSERDYIE_Disabled = 0x0
	// Ready interrupt enabled
	RCC_CIER_HSERDYIE_Enabled = 0x1
	// Position of HSI16RDYIE field.
	RCC_CIER_HSI16RDYIE_Pos = 0x2
	// Bit mask of HSI16RDYIE field.
	RCC_CIER_HSI16RDYIE_Msk = 0x4
	// Bit HSI16RDYIE.
	RCC_CIER_HSI16RDYIE = 0x4
	// Ready interrupt disabled
	RCC_CIER_HSI16RDYIE_Disabled = 0x0
	// Ready interrupt enabled
	RCC_CIER_HSI16RDYIE_Enabled = 0x1
	// Position of LSERDYIE field.
	RCC_CIER_LSERDYIE_Pos = 0x1
	// Bit mask of LSERDYIE field.
	RCC_CIER_LSERDYIE_Msk = 0x2
	// Bit LSERDYIE.
	RCC_CIER_LSERDYIE = 0x2
	// Ready interrupt disabled
	RCC_CIER_LSERDYIE_Disabled = 0x0
	// Ready interrupt enabled
	RCC_CIER_LSERDYIE_Enabled = 0x1
	// Position of LSIRDYIE field.
	RCC_CIER_LSIRDYIE_Pos = 0x0
	// Bit mask of LSIRDYIE field.
	RCC_CIER_LSIRDYIE_Msk = 0x1
	// Bit LSIRDYIE.
	RCC_CIER_LSIRDYIE = 0x1
	// Ready interrupt disabled
	RCC_CIER_LSIRDYIE_Disabled = 0x0
	// Ready interrupt enabled
	RCC_CIER_LSIRDYIE_Enabled = 0x1

	// CIFR: Clock interrupt flag register
	// Position of CSSHSEF field.
	RCC_CIFR_CSSHSEF_Pos = 0x8
	// Bit mask of CSSHSEF field.
	RCC_CIFR_CSSHSEF_Msk = 0x100
	// Bit CSSHSEF.
	RCC_CIFR_CSSHSEF = 0x100
	// No clock security interrupt caused by HSE clock failure
	RCC_CIFR_CSSHSEF_NoClock = 0x0
	// Clock security interrupt caused by HSE clock failure
	RCC_CIFR_CSSHSEF_Clock = 0x1
	// Position of CSSLSEF field.
	RCC_CIFR_CSSLSEF_Pos = 0x7
	// Bit mask of CSSLSEF field.
	RCC_CIFR_CSSLSEF_Msk = 0x80
	// Bit CSSLSEF.
	RCC_CIFR_CSSLSEF = 0x80
	// No failure detected on LSE clock failure
	RCC_CIFR_CSSLSEF_NoFailure = 0x0
	// Failure detected on LSE clock failure
	RCC_CIFR_CSSLSEF_Failure = 0x1
	// Position of HSI48RDYF field.
	RCC_CIFR_HSI48RDYF_Pos = 0x6
	// Bit mask of HSI48RDYF field.
	RCC_CIFR_HSI48RDYF_Msk = 0x40
	// Bit HSI48RDYF.
	RCC_CIFR_HSI48RDYF = 0x40
	// No clock ready interrupt
	RCC_CIFR_HSI48RDYF_NotInterrupted = 0x0
	// Clock ready interrupt
	RCC_CIFR_HSI48RDYF_Interrupted = 0x1
	// Position of MSIRDYF field.
	RCC_CIFR_MSIRDYF_Pos = 0x5
	// Bit mask of MSIRDYF field.
	RCC_CIFR_MSIRDYF_Msk = 0x20
	// Bit MSIRDYF.
	RCC_CIFR_MSIRDYF = 0x20
	// No clock ready interrupt
	RCC_CIFR_MSIRDYF_NotInterrupted = 0x0
	// Clock ready interrupt
	RCC_CIFR_MSIRDYF_Interrupted = 0x1
	// Position of PLLRDYF field.
	RCC_CIFR_PLLRDYF_Pos = 0x4
	// Bit mask of PLLRDYF field.
	RCC_CIFR_PLLRDYF_Msk = 0x10
	// Bit PLLRDYF.
	RCC_CIFR_PLLRDYF = 0x10
	// No clock ready interrupt
	RCC_CIFR_PLLRDYF_NotInterrupted = 0x0
	// Clock ready interrupt
	RCC_CIFR_PLLRDYF_Interrupted = 0x1
	// Position of HSERDYF field.
	RCC_CIFR_HSERDYF_Pos = 0x3
	// Bit mask of HSERDYF field.
	RCC_CIFR_HSERDYF_Msk = 0x8
	// Bit HSERDYF.
	RCC_CIFR_HSERDYF = 0x8
	// No clock ready interrupt
	RCC_CIFR_HSERDYF_NotInterrupted = 0x0
	// Clock ready interrupt
	RCC_CIFR_HSERDYF_Interrupted = 0x1
	// Position of HSI16RDYF field.
	RCC_CIFR_HSI16RDYF_Pos = 0x2
	// Bit mask of HSI16RDYF field.
	RCC_CIFR_HSI16RDYF_Msk = 0x4
	// Bit HSI16RDYF.
	RCC_CIFR_HSI16RDYF = 0x4
	// No clock ready interrupt
	RCC_CIFR_HSI16RDYF_NotInterrupted = 0x0
	// Clock ready interrupt
	RCC_CIFR_HSI16RDYF_Interrupted = 0x1
	// Position of LSERDYF field.
	RCC_CIFR_LSERDYF_Pos = 0x1
	// Bit mask of LSERDYF field.
	RCC_CIFR_LSERDYF_Msk = 0x2
	// Bit LSERDYF.
	RCC_CIFR_LSERDYF = 0x2
	// No clock ready interrupt
	RCC_CIFR_LSERDYF_NotInterrupted = 0x0
	// Clock ready interrupt
	RCC_CIFR_LSERDYF_Interrupted = 0x1
	// Position of LSIRDYF field.
	RCC_CIFR_LSIRDYF_Pos = 0x0
	// Bit mask of LSIRDYF field.
	RCC_CIFR_LSIRDYF_Msk = 0x1
	// Bit LSIRDYF.
	RCC_CIFR_LSIRDYF = 0x1
	// No clock ready interrupt
	RCC_CIFR_LSIRDYF_NotInterrupted = 0x0
	// Clock ready interrupt
	RCC_CIFR_LSIRDYF_Interrupted = 0x1

	// CICR: Clock interrupt clear register
	// Position of CSSHSEC field.
	RCC_CICR_CSSHSEC_Pos = 0x8
	// Bit mask of CSSHSEC field.
	RCC_CICR_CSSHSEC_Msk = 0x100
	// Bit CSSHSEC.
	RCC_CICR_CSSHSEC = 0x100
	// Clear interrupt flag
	RCC_CICR_CSSHSEC_Clear = 0x1
	// Position of CSSLSEC field.
	RCC_CICR_CSSLSEC_Pos = 0x7
	// Bit mask of CSSLSEC field.
	RCC_CICR_CSSLSEC_Msk = 0x80
	// Bit CSSLSEC.
	RCC_CICR_CSSLSEC = 0x80
	// Clear interrupt flag
	RCC_CICR_CSSLSEC_Clear = 0x1
	// Position of HSI48RDYC field.
	RCC_CICR_HSI48RDYC_Pos = 0x6
	// Bit mask of HSI48RDYC field.
	RCC_CICR_HSI48RDYC_Msk = 0x40
	// Bit HSI48RDYC.
	RCC_CICR_HSI48RDYC = 0x40
	// Clear interrupt flag
	RCC_CICR_HSI48RDYC_Clear = 0x1
	// Position of MSIRDYC field.
	RCC_CICR_MSIRDYC_Pos = 0x5
	// Bit mask of MSIRDYC field.
	RCC_CICR_MSIRDYC_Msk = 0x20
	// Bit MSIRDYC.
	RCC_CICR_MSIRDYC = 0x20
	// Clear interrupt flag
	RCC_CICR_MSIRDYC_Clear = 0x1
	// Position of PLLRDYC field.
	RCC_CICR_PLLRDYC_Pos = 0x4
	// Bit mask of PLLRDYC field.
	RCC_CICR_PLLRDYC_Msk = 0x10
	// Bit PLLRDYC.
	RCC_CICR_PLLRDYC = 0x10
	// Clear interrupt flag
	RCC_CICR_PLLRDYC_Clear = 0x1
	// Position of HSERDYC field.
	RCC_CICR_HSERDYC_Pos = 0x3
	// Bit mask of HSERDYC field.
	RCC_CICR_HSERDYC_Msk = 0x8
	// Bit HSERDYC.
	RCC_CICR_HSERDYC = 0x8
	// Clear interrupt flag
	RCC_CICR_HSERDYC_Clear = 0x1
	// Position of HSI16RDYC field.
	RCC_CICR_HSI16RDYC_Pos = 0x2
	// Bit mask of HSI16RDYC field.
	RCC_CICR_HSI16RDYC_Msk = 0x4
	// Bit HSI16RDYC.
	RCC_CICR_HSI16RDYC = 0x4
	// Clear interrupt flag
	RCC_CICR_HSI16RDYC_Clear = 0x1
	// Position of LSERDYC field.
	RCC_CICR_LSERDYC_Pos = 0x1
	// Bit mask of LSERDYC field.
	RCC_CICR_LSERDYC_Msk = 0x2
	// Bit LSERDYC.
	RCC_CICR_LSERDYC = 0x2
	// Clear interrupt flag
	RCC_CICR_LSERDYC_Clear = 0x1
	// Position of LSIRDYC field.
	RCC_CICR_LSIRDYC_Pos = 0x0
	// Bit mask of LSIRDYC field.
	RCC_CICR_LSIRDYC_Msk = 0x1
	// Bit LSIRDYC.
	RCC_CICR_LSIRDYC = 0x1
	// Clear interrupt flag
	RCC_CICR_LSIRDYC_Clear = 0x1

	// IOPRSTR: GPIO reset register
	// Position of IOPHRST field.
	RCC_IOPRSTR_IOPHRST_Pos = 0x7
	// Bit mask of IOPHRST field.
	RCC_IOPRSTR_IOPHRST_Msk = 0x80
	// Bit IOPHRST.
	RCC_IOPRSTR_IOPHRST = 0x80
	// Reset I/O port
	RCC_IOPRSTR_IOPHRST_Reset = 0x1
	// Position of IOPDRST field.
	RCC_IOPRSTR_IOPDRST_Pos = 0x3
	// Bit mask of IOPDRST field.
	RCC_IOPRSTR_IOPDRST_Msk = 0x8
	// Bit IOPDRST.
	RCC_IOPRSTR_IOPDRST = 0x8
	// Reset I/O port
	RCC_IOPRSTR_IOPDRST_Reset = 0x1
	// Position of IOPCRST field.
	RCC_IOPRSTR_IOPCRST_Pos = 0x2
	// Bit mask of IOPCRST field.
	RCC_IOPRSTR_IOPCRST_Msk = 0x4
	// Bit IOPCRST.
	RCC_IOPRSTR_IOPCRST = 0x4
	// Reset I/O port
	RCC_IOPRSTR_IOPCRST_Reset = 0x1
	// Position of IOPBRST field.
	RCC_IOPRSTR_IOPBRST_Pos = 0x1
	// Bit mask of IOPBRST field.
	RCC_IOPRSTR_IOPBRST_Msk = 0x2
	// Bit IOPBRST.
	RCC_IOPRSTR_IOPBRST = 0x2
	// Reset I/O port
	RCC_IOPRSTR_IOPBRST_Reset = 0x1
	// Position of IOPARST field.
	RCC_IOPRSTR_IOPARST_Pos = 0x0
	// Bit mask of IOPARST field.
	RCC_IOPRSTR_IOPARST_Msk = 0x1
	// Bit IOPARST.
	RCC_IOPRSTR_IOPARST = 0x1
	// Reset I/O port
	RCC_IOPRSTR_IOPARST_Reset = 0x1
	// Position of IOPERST field.
	RCC_IOPRSTR_IOPERST_Pos = 0x4
	// Bit mask of IOPERST field.
	RCC_IOPRSTR_IOPERST_Msk = 0x10
	// Bit IOPERST.
	RCC_IOPRSTR_IOPERST = 0x10
	// Reset I/O port
	RCC_IOPRSTR_IOPERST_Reset = 0x1

	// AHBRSTR: AHB peripheral reset register
	// Position of CRYPRST field.
	RCC_AHBRSTR_CRYPRST_Pos = 0x18
	// Bit mask of CRYPRST field.
	RCC_AHBRSTR_CRYPRST_Msk = 0x1000000
	// Bit CRYPRST.
	RCC_AHBRSTR_CRYPRST = 0x1000000
	// Reset the module
	RCC_AHBRSTR_CRYPRST_Reset = 0x1
	// Position of RNGRST field.
	RCC_AHBRSTR_RNGRST_Pos = 0x14
	// Bit mask of RNGRST field.
	RCC_AHBRSTR_RNGRST_Msk = 0x100000
	// Bit RNGRST.
	RCC_AHBRSTR_RNGRST = 0x100000
	// Reset the module
	RCC_AHBRSTR_RNGRST_Reset = 0x1
	// Position of TOUCHRST field.
	RCC_AHBRSTR_TOUCHRST_Pos = 0x10
	// Bit mask of TOUCHRST field.
	RCC_AHBRSTR_TOUCHRST_Msk = 0x10000
	// Bit TOUCHRST.
	RCC_AHBRSTR_TOUCHRST = 0x10000
	// Reset the module
	RCC_AHBRSTR_TOUCHRST_Reset = 0x1
	// Position of CRCRST field.
	RCC_AHBRSTR_CRCRST_Pos = 0xc
	// Bit mask of CRCRST field.
	RCC_AHBRSTR_CRCRST_Msk = 0x1000
	// Bit CRCRST.
	RCC_AHBRSTR_CRCRST = 0x1000
	// Reset the module
	RCC_AHBRSTR_CRCRST_Reset = 0x1
	// Position of MIFRST field.
	RCC_AHBRSTR_MIFRST_Pos = 0x8
	// Bit mask of MIFRST field.
	RCC_AHBRSTR_MIFRST_Msk = 0x100
	// Bit MIFRST.
	RCC_AHBRSTR_MIFRST = 0x100
	// Reset the module
	RCC_AHBRSTR_MIFRST_Reset = 0x1
	// Position of DMARST field.
	RCC_AHBRSTR_DMARST_Pos = 0x0
	// Bit mask of DMARST field.
	RCC_AHBRSTR_DMARST_Msk = 0x1
	// Bit DMARST.
	RCC_AHBRSTR_DMARST = 0x1
	// Reset the module
	RCC_AHBRSTR_DMARST_Reset = 0x1

	// APB2RSTR: APB2 peripheral reset register
	// Position of DBGRST field.
	RCC_APB2RSTR_DBGRST_Pos = 0x16
	// Bit mask of DBGRST field.
	RCC_APB2RSTR_DBGRST_Msk = 0x400000
	// Bit DBGRST.
	RCC_APB2RSTR_DBGRST = 0x400000
	// Reset the module
	RCC_APB2RSTR_DBGRST_Reset = 0x1
	// Position of USART1RST field.
	RCC_APB2RSTR_USART1RST_Pos = 0xe
	// Bit mask of USART1RST field.
	RCC_APB2RSTR_USART1RST_Msk = 0x4000
	// Bit USART1RST.
	RCC_APB2RSTR_USART1RST = 0x4000
	// Reset the module
	RCC_APB2RSTR_USART1RST_Reset = 0x1
	// Position of SPI1RST field.
	RCC_APB2RSTR_SPI1RST_Pos = 0xc
	// Bit mask of SPI1RST field.
	RCC_APB2RSTR_SPI1RST_Msk = 0x1000
	// Bit SPI1RST.
	RCC_APB2RSTR_SPI1RST = 0x1000
	// Reset the module
	RCC_APB2RSTR_SPI1RST_Reset = 0x1
	// Position of ADCRST field.
	RCC_APB2RSTR_ADCRST_Pos = 0x9
	// Bit mask of ADCRST field.
	RCC_APB2RSTR_ADCRST_Msk = 0x200
	// Bit ADCRST.
	RCC_APB2RSTR_ADCRST = 0x200
	// Reset the module
	RCC_APB2RSTR_ADCRST_Reset = 0x1
	// Position of TIM22RST field.
	RCC_APB2RSTR_TIM22RST_Pos = 0x5
	// Bit mask of TIM22RST field.
	RCC_APB2RSTR_TIM22RST_Msk = 0x20
	// Bit TIM22RST.
	RCC_APB2RSTR_TIM22RST = 0x20
	// Reset the module
	RCC_APB2RSTR_TIM22RST_Reset = 0x1
	// Position of TIM21RST field.
	RCC_APB2RSTR_TIM21RST_Pos = 0x2
	// Bit mask of TIM21RST field.
	RCC_APB2RSTR_TIM21RST_Msk = 0x4
	// Bit TIM21RST.
	RCC_APB2RSTR_TIM21RST = 0x4
	// Reset the module
	RCC_APB2RSTR_TIM21RST_Reset = 0x1
	// Position of SYSCFGRST field.
	RCC_APB2RSTR_SYSCFGRST_Pos = 0x0
	// Bit mask of SYSCFGRST field.
	RCC_APB2RSTR_SYSCFGRST_Msk = 0x1
	// Bit SYSCFGRST.
	RCC_APB2RSTR_SYSCFGRST = 0x1
	// Reset the module
	RCC_APB2RSTR_SYSCFGRST_Reset = 0x1

	// APB1RSTR: APB1 peripheral reset register
	// Position of LPTIM1RST field.
	RCC_APB1RSTR_LPTIM1RST_Pos = 0x1f
	// Bit mask of LPTIM1RST field.
	RCC_APB1RSTR_LPTIM1RST_Msk = 0x80000000
	// Bit LPTIM1RST.
	RCC_APB1RSTR_LPTIM1RST = 0x80000000
	// Reset the module
	RCC_APB1RSTR_LPTIM1RST_Reset = 0x1
	// Position of DACRST field.
	RCC_APB1RSTR_DACRST_Pos = 0x1d
	// Bit mask of DACRST field.
	RCC_APB1RSTR_DACRST_Msk = 0x20000000
	// Bit DACRST.
	RCC_APB1RSTR_DACRST = 0x20000000
	// Reset the module
	RCC_APB1RSTR_DACRST_Reset = 0x1
	// Position of PWRRST field.
	RCC_APB1RSTR_PWRRST_Pos = 0x1c
	// Bit mask of PWRRST field.
	RCC_APB1RSTR_PWRRST_Msk = 0x10000000
	// Bit PWRRST.
	RCC_APB1RSTR_PWRRST = 0x10000000
	// Reset the module
	RCC_APB1RSTR_PWRRST_Reset = 0x1
	// Position of CRSRST field.
	RCC_APB1RSTR_CRSRST_Pos = 0x1b
	// Bit mask of CRSRST field.
	RCC_APB1RSTR_CRSRST_Msk = 0x8000000
	// Bit CRSRST.
	RCC_APB1RSTR_CRSRST = 0x8000000
	// Reset the module
	RCC_APB1RSTR_CRSRST_Reset = 0x1
	// Position of USBRST field.
	RCC_APB1RSTR_USBRST_Pos = 0x17
	// Bit mask of USBRST field.
	RCC_APB1RSTR_USBRST_Msk = 0x800000
	// Bit USBRST.
	RCC_APB1RSTR_USBRST = 0x800000
	// Reset the module
	RCC_APB1RSTR_USBRST_Reset = 0x1
	// Position of I2C2RST field.
	RCC_APB1RSTR_I2C2RST_Pos = 0x16
	// Bit mask of I2C2RST field.
	RCC_APB1RSTR_I2C2RST_Msk = 0x400000
	// Bit I2C2RST.
	RCC_APB1RSTR_I2C2RST = 0x400000
	// Reset the module
	RCC_APB1RSTR_I2C2RST_Reset = 0x1
	// Position of I2C1RST field.
	RCC_APB1RSTR_I2C1RST_Pos = 0x15
	// Bit mask of I2C1RST field.
	RCC_APB1RSTR_I2C1RST_Msk = 0x200000
	// Bit I2C1RST.
	RCC_APB1RSTR_I2C1RST = 0x200000
	// Reset the module
	RCC_APB1RSTR_I2C1RST_Reset = 0x1
	// Position of LPUART1RST field.
	RCC_APB1RSTR_LPUART1RST_Pos = 0x12
	// Bit mask of LPUART1RST field.
	RCC_APB1RSTR_LPUART1RST_Msk = 0x40000
	// Bit LPUART1RST.
	RCC_APB1RSTR_LPUART1RST = 0x40000
	// Reset the module
	RCC_APB1RSTR_LPUART1RST_Reset = 0x1
	// Position of LPUART12RST field.
	RCC_APB1RSTR_LPUART12RST_Pos = 0x11
	// Bit mask of LPUART12RST field.
	RCC_APB1RSTR_LPUART12RST_Msk = 0x20000
	// Bit LPUART12RST.
	RCC_APB1RSTR_LPUART12RST = 0x20000
	// Reset the module
	RCC_APB1RSTR_LPUART12RST_Reset = 0x1
	// Position of SPI2RST field.
	RCC_APB1RSTR_SPI2RST_Pos = 0xe
	// Bit mask of SPI2RST field.
	RCC_APB1RSTR_SPI2RST_Msk = 0x4000
	// Bit SPI2RST.
	RCC_APB1RSTR_SPI2RST = 0x4000
	// Reset the module
	RCC_APB1RSTR_SPI2RST_Reset = 0x1
	// Position of WWDRST field.
	RCC_APB1RSTR_WWDRST_Pos = 0xb
	// Bit mask of WWDRST field.
	RCC_APB1RSTR_WWDRST_Msk = 0x800
	// Bit WWDRST.
	RCC_APB1RSTR_WWDRST = 0x800
	// Reset the module
	RCC_APB1RSTR_WWDRST_Reset = 0x1
	// Position of TIM6RST field.
	RCC_APB1RSTR_TIM6RST_Pos = 0x4
	// Bit mask of TIM6RST field.
	RCC_APB1RSTR_TIM6RST_Msk = 0x10
	// Bit TIM6RST.
	RCC_APB1RSTR_TIM6RST = 0x10
	// Reset the module
	RCC_APB1RSTR_TIM6RST_Reset = 0x1
	// Position of TIM2RST field.
	RCC_APB1RSTR_TIM2RST_Pos = 0x0
	// Bit mask of TIM2RST field.
	RCC_APB1RSTR_TIM2RST_Msk = 0x1
	// Bit TIM2RST.
	RCC_APB1RSTR_TIM2RST = 0x1
	// Reset the module
	RCC_APB1RSTR_TIM2RST_Reset = 0x1
	// Position of TIM3RST field.
	RCC_APB1RSTR_TIM3RST_Pos = 0x1
	// Bit mask of TIM3RST field.
	RCC_APB1RSTR_TIM3RST_Msk = 0x2
	// Bit TIM3RST.
	RCC_APB1RSTR_TIM3RST = 0x2
	// Reset the module
	RCC_APB1RSTR_TIM3RST_Reset = 0x1
	// Position of TIM7RST field.
	RCC_APB1RSTR_TIM7RST_Pos = 0x5
	// Bit mask of TIM7RST field.
	RCC_APB1RSTR_TIM7RST_Msk = 0x20
	// Bit TIM7RST.
	RCC_APB1RSTR_TIM7RST = 0x20
	// Reset the module
	RCC_APB1RSTR_TIM7RST_Reset = 0x1
	// Position of USART4RST field.
	RCC_APB1RSTR_USART4RST_Pos = 0x13
	// Bit mask of USART4RST field.
	RCC_APB1RSTR_USART4RST_Msk = 0x80000
	// Bit USART4RST.
	RCC_APB1RSTR_USART4RST = 0x80000
	// Reset the module
	RCC_APB1RSTR_USART4RST_Reset = 0x1
	// Position of USART5RST field.
	RCC_APB1RSTR_USART5RST_Pos = 0x14
	// Bit mask of USART5RST field.
	RCC_APB1RSTR_USART5RST_Msk = 0x100000
	// Bit USART5RST.
	RCC_APB1RSTR_USART5RST = 0x100000
	// Reset the module
	RCC_APB1RSTR_USART5RST_Reset = 0x1
	// Position of I2C3RST field.
	RCC_APB1RSTR_I2C3RST_Pos = 0x1e
	// Bit mask of I2C3RST field.
	RCC_APB1RSTR_I2C3RST_Msk = 0x40000000
	// Bit I2C3RST.
	RCC_APB1RSTR_I2C3RST = 0x40000000
	// Reset the module
	RCC_APB1RSTR_I2C3RST_Reset = 0x1

	// IOPENR: GPIO clock enable register
	// Position of IOPHEN field.
	RCC_IOPENR_IOPHEN_Pos = 0x7
	// Bit mask of IOPHEN field.
	RCC_IOPENR_IOPHEN_Msk = 0x80
	// Bit IOPHEN.
	RCC_IOPENR_IOPHEN = 0x80
	// Port clock disabled
	RCC_IOPENR_IOPHEN_Disabled = 0x0
	// Port clock enabled
	RCC_IOPENR_IOPHEN_Enabled = 0x1
	// Position of IOPDEN field.
	RCC_IOPENR_IOPDEN_Pos = 0x3
	// Bit mask of IOPDEN field.
	RCC_IOPENR_IOPDEN_Msk = 0x8
	// Bit IOPDEN.
	RCC_IOPENR_IOPDEN = 0x8
	// Port clock disabled
	RCC_IOPENR_IOPDEN_Disabled = 0x0
	// Port clock enabled
	RCC_IOPENR_IOPDEN_Enabled = 0x1
	// Position of IOPCEN field.
	RCC_IOPENR_IOPCEN_Pos = 0x2
	// Bit mask of IOPCEN field.
	RCC_IOPENR_IOPCEN_Msk = 0x4
	// Bit IOPCEN.
	RCC_IOPENR_IOPCEN = 0x4
	// Port clock disabled
	RCC_IOPENR_IOPCEN_Disabled = 0x0
	// Port clock enabled
	RCC_IOPENR_IOPCEN_Enabled = 0x1
	// Position of IOPBEN field.
	RCC_IOPENR_IOPBEN_Pos = 0x1
	// Bit mask of IOPBEN field.
	RCC_IOPENR_IOPBEN_Msk = 0x2
	// Bit IOPBEN.
	RCC_IOPENR_IOPBEN = 0x2
	// Port clock disabled
	RCC_IOPENR_IOPBEN_Disabled = 0x0
	// Port clock enabled
	RCC_IOPENR_IOPBEN_Enabled = 0x1
	// Position of IOPAEN field.
	RCC_IOPENR_IOPAEN_Pos = 0x0
	// Bit mask of IOPAEN field.
	RCC_IOPENR_IOPAEN_Msk = 0x1
	// Bit IOPAEN.
	RCC_IOPENR_IOPAEN = 0x1
	// Port clock disabled
	RCC_IOPENR_IOPAEN_Disabled = 0x0
	// Port clock enabled
	RCC_IOPENR_IOPAEN_Enabled = 0x1
	// Position of IOPEEN field.
	RCC_IOPENR_IOPEEN_Pos = 0x4
	// Bit mask of IOPEEN field.
	RCC_IOPENR_IOPEEN_Msk = 0x10
	// Bit IOPEEN.
	RCC_IOPENR_IOPEEN = 0x10
	// Port clock disabled
	RCC_IOPENR_IOPEEN_Disabled = 0x0
	// Port clock enabled
	RCC_IOPENR_IOPEEN_Enabled = 0x1

	// AHBENR: AHB peripheral clock enable register
	// Position of CRYPEN field.
	RCC_AHBENR_CRYPEN_Pos = 0x18
	// Bit mask of CRYPEN field.
	RCC_AHBENR_CRYPEN_Msk = 0x1000000
	// Bit CRYPEN.
	RCC_AHBENR_CRYPEN = 0x1000000
	// Clock disabled
	RCC_AHBENR_CRYPEN_Disabled = 0x0
	// Clock enabled
	RCC_AHBENR_CRYPEN_Enabled = 0x1
	// Position of RNGEN field.
	RCC_AHBENR_RNGEN_Pos = 0x14
	// Bit mask of RNGEN field.
	RCC_AHBENR_RNGEN_Msk = 0x100000
	// Bit RNGEN.
	RCC_AHBENR_RNGEN = 0x100000
	// Clock disabled
	RCC_AHBENR_RNGEN_Disabled = 0x0
	// Clock enabled
	RCC_AHBENR_RNGEN_Enabled = 0x1
	// Position of TOUCHEN field.
	RCC_AHBENR_TOUCHEN_Pos = 0x10
	// Bit mask of TOUCHEN field.
	RCC_AHBENR_TOUCHEN_Msk = 0x10000
	// Bit TOUCHEN.
	RCC_AHBENR_TOUCHEN = 0x10000
	// Clock disabled
	RCC_AHBENR_TOUCHEN_Disabled = 0x0
	// Clock enabled
	RCC_AHBENR_TOUCHEN_Enabled = 0x1
	// Position of CRCEN field.
	RCC_AHBENR_CRCEN_Pos = 0xc
	// Bit mask of CRCEN field.
	RCC_AHBENR_CRCEN_Msk = 0x1000
	// Bit CRCEN.
	RCC_AHBENR_CRCEN = 0x1000
	// Clock disabled
	RCC_AHBENR_CRCEN_Disabled = 0x0
	// Clock enabled
	RCC_AHBENR_CRCEN_Enabled = 0x1
	// Position of MIFEN field.
	RCC_AHBENR_MIFEN_Pos = 0x8
	// Bit mask of MIFEN field.
	RCC_AHBENR_MIFEN_Msk = 0x100
	// Bit MIFEN.
	RCC_AHBENR_MIFEN = 0x100
	// Clock disabled
	RCC_AHBENR_MIFEN_Disabled = 0x0
	// Clock enabled
	RCC_AHBENR_MIFEN_Enabled = 0x1
	// Position of DMAEN field.
	RCC_AHBENR_DMAEN_Pos = 0x0
	// Bit mask of DMAEN field.
	RCC_AHBENR_DMAEN_Msk = 0x1
	// Bit DMAEN.
	RCC_AHBENR_DMAEN = 0x1
	// Clock disabled
	RCC_AHBENR_DMAEN_Disabled = 0x0
	// Clock enabled
	RCC_AHBENR_DMAEN_Enabled = 0x1

	// APB2ENR: APB2 peripheral clock enable register
	// Position of DBGEN field.
	RCC_APB2ENR_DBGEN_Pos = 0x16
	// Bit mask of DBGEN field.
	RCC_APB2ENR_DBGEN_Msk = 0x400000
	// Bit DBGEN.
	RCC_APB2ENR_DBGEN = 0x400000
	// Clock disabled
	RCC_APB2ENR_DBGEN_Disabled = 0x0
	// Clock enabled
	RCC_APB2ENR_DBGEN_Enabled = 0x1
	// Position of USART1EN field.
	RCC_APB2ENR_USART1EN_Pos = 0xe
	// Bit mask of USART1EN field.
	RCC_APB2ENR_USART1EN_Msk = 0x4000
	// Bit USART1EN.
	RCC_APB2ENR_USART1EN = 0x4000
	// Clock disabled
	RCC_APB2ENR_USART1EN_Disabled = 0x0
	// Clock enabled
	RCC_APB2ENR_USART1EN_Enabled = 0x1
	// Position of SPI1EN field.
	RCC_APB2ENR_SPI1EN_Pos = 0xc
	// Bit mask of SPI1EN field.
	RCC_APB2ENR_SPI1EN_Msk = 0x1000
	// Bit SPI1EN.
	RCC_APB2ENR_SPI1EN = 0x1000
	// Clock disabled
	RCC_APB2ENR_SPI1EN_Disabled = 0x0
	// Clock enabled
	RCC_APB2ENR_SPI1EN_Enabled = 0x1
	// Position of ADCEN field.
	RCC_APB2ENR_ADCEN_Pos = 0x9
	// Bit mask of ADCEN field.
	RCC_APB2ENR_ADCEN_Msk = 0x200
	// Bit ADCEN.
	RCC_APB2ENR_ADCEN = 0x200
	// Clock disabled
	RCC_APB2ENR_ADCEN_Disabled = 0x0
	// Clock enabled
	RCC_APB2ENR_ADCEN_Enabled = 0x1
	// Position of MIFIEN field.
	RCC_APB2ENR_MIFIEN_Pos = 0x7
	// Bit mask of MIFIEN field.
	RCC_APB2ENR_MIFIEN_Msk = 0x80
	// Bit MIFIEN.
	RCC_APB2ENR_MIFIEN = 0x80
	// Clock disabled
	RCC_APB2ENR_MIFIEN_Disabled = 0x0
	// Clock enabled
	RCC_APB2ENR_MIFIEN_Enabled = 0x1
	// Position of TIM22EN field.
	RCC_APB2ENR_TIM22EN_Pos = 0x5
	// Bit mask of TIM22EN field.
	RCC_APB2ENR_TIM22EN_Msk = 0x20
	// Bit TIM22EN.
	RCC_APB2ENR_TIM22EN = 0x20
	// Clock disabled
	RCC_APB2ENR_TIM22EN_Disabled = 0x0
	// Clock enabled
	RCC_APB2ENR_TIM22EN_Enabled = 0x1
	// Position of TIM21EN field.
	RCC_APB2ENR_TIM21EN_Pos = 0x2
	// Bit mask of TIM21EN field.
	RCC_APB2ENR_TIM21EN_Msk = 0x4
	// Bit TIM21EN.
	RCC_APB2ENR_TIM21EN = 0x4
	// Clock disabled
	RCC_APB2ENR_TIM21EN_Disabled = 0x0
	// Clock enabled
	RCC_APB2ENR_TIM21EN_Enabled = 0x1
	// Position of SYSCFGEN field.
	RCC_APB2ENR_SYSCFGEN_Pos = 0x0
	// Bit mask of SYSCFGEN field.
	RCC_APB2ENR_SYSCFGEN_Msk = 0x1
	// Bit SYSCFGEN.
	RCC_APB2ENR_SYSCFGEN = 0x1
	// Clock disabled
	RCC_APB2ENR_SYSCFGEN_Disabled = 0x0
	// Clock enabled
	RCC_APB2ENR_SYSCFGEN_Enabled = 0x1

	// APB1ENR: APB1 peripheral clock enable register
	// Position of LPTIM1EN field.
	RCC_APB1ENR_LPTIM1EN_Pos = 0x1f
	// Bit mask of LPTIM1EN field.
	RCC_APB1ENR_LPTIM1EN_Msk = 0x80000000
	// Bit LPTIM1EN.
	RCC_APB1ENR_LPTIM1EN = 0x80000000
	// Clock disabled
	RCC_APB1ENR_LPTIM1EN_Disabled = 0x0
	// Clock enabled
	RCC_APB1ENR_LPTIM1EN_Enabled = 0x1
	// Position of DACEN field.
	RCC_APB1ENR_DACEN_Pos = 0x1d
	// Bit mask of DACEN field.
	RCC_APB1ENR_DACEN_Msk = 0x20000000
	// Bit DACEN.
	RCC_APB1ENR_DACEN = 0x20000000
	// Clock disabled
	RCC_APB1ENR_DACEN_Disabled = 0x0
	// Clock enabled
	RCC_APB1ENR_DACEN_Enabled = 0x1
	// Position of PWREN field.
	RCC_APB1ENR_PWREN_Pos = 0x1c
	// Bit mask of PWREN field.
	RCC_APB1ENR_PWREN_Msk = 0x10000000
	// Bit PWREN.
	RCC_APB1ENR_PWREN = 0x10000000
	// Clock disabled
	RCC_APB1ENR_PWREN_Disabled = 0x0
	// Clock enabled
	RCC_APB1ENR_PWREN_Enabled = 0x1
	// Position of CRSEN field.
	RCC_APB1ENR_CRSEN_Pos = 0x1b
	// Bit mask of CRSEN field.
	RCC_APB1ENR_CRSEN_Msk = 0x8000000
	// Bit CRSEN.
	RCC_APB1ENR_CRSEN = 0x8000000
	// Clock disabled
	RCC_APB1ENR_CRSEN_Disabled = 0x0
	// Clock enabled
	RCC_APB1ENR_CRSEN_Enabled = 0x1
	// Position of USBEN field.
	RCC_APB1ENR_USBEN_Pos = 0x17
	// Bit mask of USBEN field.
	RCC_APB1ENR_USBEN_Msk = 0x800000
	// Bit USBEN.
	RCC_APB1ENR_USBEN = 0x800000
	// Clock disabled
	RCC_APB1ENR_USBEN_Disabled = 0x0
	// Clock enabled
	RCC_APB1ENR_USBEN_Enabled = 0x1
	// Position of I2C2EN field.
	RCC_APB1ENR_I2C2EN_Pos = 0x16
	// Bit mask of I2C2EN field.
	RCC_APB1ENR_I2C2EN_Msk = 0x400000
	// Bit I2C2EN.
	RCC_APB1ENR_I2C2EN = 0x400000
	// Clock disabled
	RCC_APB1ENR_I2C2EN_Disabled = 0x0
	// Clock enabled
	RCC_APB1ENR_I2C2EN_Enabled = 0x1
	// Position of I2C1EN field.
	RCC_APB1ENR_I2C1EN_Pos = 0x15
	// Bit mask of I2C1EN field.
	RCC_APB1ENR_I2C1EN_Msk = 0x200000
	// Bit I2C1EN.
	RCC_APB1ENR_I2C1EN = 0x200000
	// Clock disabled
	RCC_APB1ENR_I2C1EN_Disabled = 0x0
	// Clock enabled
	RCC_APB1ENR_I2C1EN_Enabled = 0x1
	// Position of LPUART1EN field.
	RCC_APB1ENR_LPUART1EN_Pos = 0x12
	// Bit mask of LPUART1EN field.
	RCC_APB1ENR_LPUART1EN_Msk = 0x40000
	// Bit LPUART1EN.
	RCC_APB1ENR_LPUART1EN = 0x40000
	// Clock disabled
	RCC_APB1ENR_LPUART1EN_Disabled = 0x0
	// Clock enabled
	RCC_APB1ENR_LPUART1EN_Enabled = 0x1
	// Position of USART2EN field.
	RCC_APB1ENR_USART2EN_Pos = 0x11
	// Bit mask of USART2EN field.
	RCC_APB1ENR_USART2EN_Msk = 0x20000
	// Bit USART2EN.
	RCC_APB1ENR_USART2EN = 0x20000
	// Clock disabled
	RCC_APB1ENR_USART2EN_Disabled = 0x0
	// Clock enabled
	RCC_APB1ENR_USART2EN_Enabled = 0x1
	// Position of SPI2EN field.
	RCC_APB1ENR_SPI2EN_Pos = 0xe
	// Bit mask of SPI2EN field.
	RCC_APB1ENR_SPI2EN_Msk = 0x4000
	// Bit SPI2EN.
	RCC_APB1ENR_SPI2EN = 0x4000
	// Clock disabled
	RCC_APB1ENR_SPI2EN_Disabled = 0x0
	// Clock enabled
	RCC_APB1ENR_SPI2EN_Enabled = 0x1
	// Position of WWDGEN field.
	RCC_APB1ENR_WWDGEN_Pos = 0xb
	// Bit mask of WWDGEN field.
	RCC_APB1ENR_WWDGEN_Msk = 0x800
	// Bit WWDGEN.
	RCC_APB1ENR_WWDGEN = 0x800
	// Clock disabled
	RCC_APB1ENR_WWDGEN_Disabled = 0x0
	// Clock enabled
	RCC_APB1ENR_WWDGEN_Enabled = 0x1
	// Position of TIM6EN field.
	RCC_APB1ENR_TIM6EN_Pos = 0x4
	// Bit mask of TIM6EN field.
	RCC_APB1ENR_TIM6EN_Msk = 0x10
	// Bit TIM6EN.
	RCC_APB1ENR_TIM6EN = 0x10
	// Clock disabled
	RCC_APB1ENR_TIM6EN_Disabled = 0x0
	// Clock enabled
	RCC_APB1ENR_TIM6EN_Enabled = 0x1
	// Position of TIM2EN field.
	RCC_APB1ENR_TIM2EN_Pos = 0x0
	// Bit mask of TIM2EN field.
	RCC_APB1ENR_TIM2EN_Msk = 0x1
	// Bit TIM2EN.
	RCC_APB1ENR_TIM2EN = 0x1
	// Clock disabled
	RCC_APB1ENR_TIM2EN_Disabled = 0x0
	// Clock enabled
	RCC_APB1ENR_TIM2EN_Enabled = 0x1
	// Position of TIM3EN field.
	RCC_APB1ENR_TIM3EN_Pos = 0x1
	// Bit mask of TIM3EN field.
	RCC_APB1ENR_TIM3EN_Msk = 0x2
	// Bit TIM3EN.
	RCC_APB1ENR_TIM3EN = 0x2
	// Clock disabled
	RCC_APB1ENR_TIM3EN_Disabled = 0x0
	// Clock enabled
	RCC_APB1ENR_TIM3EN_Enabled = 0x1
	// Position of TIM7EN field.
	RCC_APB1ENR_TIM7EN_Pos = 0x5
	// Bit mask of TIM7EN field.
	RCC_APB1ENR_TIM7EN_Msk = 0x20
	// Bit TIM7EN.
	RCC_APB1ENR_TIM7EN = 0x20
	// Clock disabled
	RCC_APB1ENR_TIM7EN_Disabled = 0x0
	// Clock enabled
	RCC_APB1ENR_TIM7EN_Enabled = 0x1
	// Position of USART4EN field.
	RCC_APB1ENR_USART4EN_Pos = 0x13
	// Bit mask of USART4EN field.
	RCC_APB1ENR_USART4EN_Msk = 0x80000
	// Bit USART4EN.
	RCC_APB1ENR_USART4EN = 0x80000
	// Clock disabled
	RCC_APB1ENR_USART4EN_Disabled = 0x0
	// Clock enabled
	RCC_APB1ENR_USART4EN_Enabled = 0x1
	// Position of USART5EN field.
	RCC_APB1ENR_USART5EN_Pos = 0x14
	// Bit mask of USART5EN field.
	RCC_APB1ENR_USART5EN_Msk = 0x100000
	// Bit USART5EN.
	RCC_APB1ENR_USART5EN = 0x100000
	// Clock disabled
	RCC_APB1ENR_USART5EN_Disabled = 0x0
	// Clock enabled
	RCC_APB1ENR_USART5EN_Enabled = 0x1
	// Position of I2C3EN field.
	RCC_APB1ENR_I2C3EN_Pos = 0x1e
	// Bit mask of I2C3EN field.
	RCC_APB1ENR_I2C3EN_Msk = 0x40000000
	// Bit I2C3EN.
	RCC_APB1ENR_I2C3EN = 0x40000000
	// Clock disabled
	RCC_APB1ENR_I2C3EN_Disabled = 0x0
	// Clock enabled
	RCC_APB1ENR_I2C3EN_Enabled = 0x1

	// IOPSMEN: GPIO clock enable in sleep mode register
	// Position of IOPHSMEN field.
	RCC_IOPSMEN_IOPHSMEN_Pos = 0x7
	// Bit mask of IOPHSMEN field.
	RCC_IOPSMEN_IOPHSMEN_Msk = 0x80
	// Bit IOPHSMEN.
	RCC_IOPSMEN_IOPHSMEN = 0x80
	// Port x clock is disabled in Sleep mode
	RCC_IOPSMEN_IOPHSMEN_Disabled = 0x0
	// Port x clock is enabled in Sleep mode (if enabled by IOPHEN)
	RCC_IOPSMEN_IOPHSMEN_Enabled = 0x1
	// Position of IOPDSMEN field.
	RCC_IOPSMEN_IOPDSMEN_Pos = 0x3
	// Bit mask of IOPDSMEN field.
	RCC_IOPSMEN_IOPDSMEN_Msk = 0x8
	// Bit IOPDSMEN.
	RCC_IOPSMEN_IOPDSMEN = 0x8
	// Port x clock is disabled in Sleep mode
	RCC_IOPSMEN_IOPDSMEN_Disabled = 0x0
	// Port x clock is enabled in Sleep mode (if enabled by IOPHEN)
	RCC_IOPSMEN_IOPDSMEN_Enabled = 0x1
	// Position of IOPCSMEN field.
	RCC_IOPSMEN_IOPCSMEN_Pos = 0x2
	// Bit mask of IOPCSMEN field.
	RCC_IOPSMEN_IOPCSMEN_Msk = 0x4
	// Bit IOPCSMEN.
	RCC_IOPSMEN_IOPCSMEN = 0x4
	// Port x clock is disabled in Sleep mode
	RCC_IOPSMEN_IOPCSMEN_Disabled = 0x0
	// Port x clock is enabled in Sleep mode (if enabled by IOPHEN)
	RCC_IOPSMEN_IOPCSMEN_Enabled = 0x1
	// Position of IOPBSMEN field.
	RCC_IOPSMEN_IOPBSMEN_Pos = 0x1
	// Bit mask of IOPBSMEN field.
	RCC_IOPSMEN_IOPBSMEN_Msk = 0x2
	// Bit IOPBSMEN.
	RCC_IOPSMEN_IOPBSMEN = 0x2
	// Port x clock is disabled in Sleep mode
	RCC_IOPSMEN_IOPBSMEN_Disabled = 0x0
	// Port x clock is enabled in Sleep mode (if enabled by IOPHEN)
	RCC_IOPSMEN_IOPBSMEN_Enabled = 0x1
	// Position of IOPASMEN field.
	RCC_IOPSMEN_IOPASMEN_Pos = 0x0
	// Bit mask of IOPASMEN field.
	RCC_IOPSMEN_IOPASMEN_Msk = 0x1
	// Bit IOPASMEN.
	RCC_IOPSMEN_IOPASMEN = 0x1
	// Port x clock is disabled in Sleep mode
	RCC_IOPSMEN_IOPASMEN_Disabled = 0x0
	// Port x clock is enabled in Sleep mode (if enabled by IOPHEN)
	RCC_IOPSMEN_IOPASMEN_Enabled = 0x1
	// Position of IOPESMEN field.
	RCC_IOPSMEN_IOPESMEN_Pos = 0x4
	// Bit mask of IOPESMEN field.
	RCC_IOPSMEN_IOPESMEN_Msk = 0x10
	// Bit IOPESMEN.
	RCC_IOPSMEN_IOPESMEN = 0x10
	// Port x clock is disabled in Sleep mode
	RCC_IOPSMEN_IOPESMEN_Disabled = 0x0
	// Port x clock is enabled in Sleep mode (if enabled by IOPHEN)
	RCC_IOPSMEN_IOPESMEN_Enabled = 0x1

	// AHBSMENR: AHB peripheral clock enable in sleep mode register
	// Position of CRYPSMEN field.
	RCC_AHBSMENR_CRYPSMEN_Pos = 0x18
	// Bit mask of CRYPSMEN field.
	RCC_AHBSMENR_CRYPSMEN_Msk = 0x1000000
	// Bit CRYPSMEN.
	RCC_AHBSMENR_CRYPSMEN = 0x1000000
	// Crypto clock disabled in Sleep mode
	RCC_AHBSMENR_CRYPSMEN_Disabled = 0x0
	// Crypto clock enabled in Sleep mode
	RCC_AHBSMENR_CRYPSMEN_Enabled = 0x1
	// Position of RNGSMEN field.
	RCC_AHBSMENR_RNGSMEN_Pos = 0x14
	// Bit mask of RNGSMEN field.
	RCC_AHBSMENR_RNGSMEN_Msk = 0x100000
	// Bit RNGSMEN.
	RCC_AHBSMENR_RNGSMEN = 0x100000
	// Position of TOUCHSMEN field.
	RCC_AHBSMENR_TOUCHSMEN_Pos = 0x10
	// Bit mask of TOUCHSMEN field.
	RCC_AHBSMENR_TOUCHSMEN_Msk = 0x10000
	// Bit TOUCHSMEN.
	RCC_AHBSMENR_TOUCHSMEN = 0x10000
	// Position of CRCSMEN field.
	RCC_AHBSMENR_CRCSMEN_Pos = 0xc
	// Bit mask of CRCSMEN field.
	RCC_AHBSMENR_CRCSMEN_Msk = 0x1000
	// Bit CRCSMEN.
	RCC_AHBSMENR_CRCSMEN = 0x1000
	// Test integration module clock disabled in Sleep mode
	RCC_AHBSMENR_CRCSMEN_Disabled = 0x0
	// Test integration module clock enabled in Sleep mode (if enabled by CRCEN)
	RCC_AHBSMENR_CRCSMEN_Enabled = 0x1
	// Position of SRAMSMEN field.
	RCC_AHBSMENR_SRAMSMEN_Pos = 0x9
	// Bit mask of SRAMSMEN field.
	RCC_AHBSMENR_SRAMSMEN_Msk = 0x200
	// Bit SRAMSMEN.
	RCC_AHBSMENR_SRAMSMEN = 0x200
	// NVM interface clock disabled in Sleep mode
	RCC_AHBSMENR_SRAMSMEN_Disabled = 0x0
	// NVM interface clock enabled in Sleep mode
	RCC_AHBSMENR_SRAMSMEN_Enabled = 0x1
	// Position of MIFSMEN field.
	RCC_AHBSMENR_MIFSMEN_Pos = 0x8
	// Bit mask of MIFSMEN field.
	RCC_AHBSMENR_MIFSMEN_Msk = 0x100
	// Bit MIFSMEN.
	RCC_AHBSMENR_MIFSMEN = 0x100
	// NVM interface clock disabled in Sleep mode
	RCC_AHBSMENR_MIFSMEN_Disabled = 0x0
	// NVM interface clock enabled in Sleep mode
	RCC_AHBSMENR_MIFSMEN_Enabled = 0x1
	// Position of DMASMEN field.
	RCC_AHBSMENR_DMASMEN_Pos = 0x0
	// Bit mask of DMASMEN field.
	RCC_AHBSMENR_DMASMEN_Msk = 0x1
	// Bit DMASMEN.
	RCC_AHBSMENR_DMASMEN = 0x1
	// DMA clock disabled in Sleep mode
	RCC_AHBSMENR_DMASMEN_Disabled = 0x0
	// DMA clock enabled in Sleep mode
	RCC_AHBSMENR_DMASMEN_Enabled = 0x1

	// APB2SMENR: APB2 peripheral clock enable in sleep mode register
	// Position of DBGSMEN field.
	RCC_APB2SMENR_DBGSMEN_Pos = 0x16
	// Bit mask of DBGSMEN field.
	RCC_APB2SMENR_DBGSMEN_Msk = 0x400000
	// Bit DBGSMEN.
	RCC_APB2SMENR_DBGSMEN = 0x400000
	// Clock disabled
	RCC_APB2SMENR_DBGSMEN_Disabled = 0x0
	// Clock enabled
	RCC_APB2SMENR_DBGSMEN_Enabled = 0x1
	// Position of USART1SMEN field.
	RCC_APB2SMENR_USART1SMEN_Pos = 0xe
	// Bit mask of USART1SMEN field.
	RCC_APB2SMENR_USART1SMEN_Msk = 0x4000
	// Bit USART1SMEN.
	RCC_APB2SMENR_USART1SMEN = 0x4000
	// Clock disabled
	RCC_APB2SMENR_USART1SMEN_Disabled = 0x0
	// Clock enabled
	RCC_APB2SMENR_USART1SMEN_Enabled = 0x1
	// Position of SPI1SMEN field.
	RCC_APB2SMENR_SPI1SMEN_Pos = 0xc
	// Bit mask of SPI1SMEN field.
	RCC_APB2SMENR_SPI1SMEN_Msk = 0x1000
	// Bit SPI1SMEN.
	RCC_APB2SMENR_SPI1SMEN = 0x1000
	// Clock disabled
	RCC_APB2SMENR_SPI1SMEN_Disabled = 0x0
	// Clock enabled
	RCC_APB2SMENR_SPI1SMEN_Enabled = 0x1
	// Position of ADCSMEN field.
	RCC_APB2SMENR_ADCSMEN_Pos = 0x9
	// Bit mask of ADCSMEN field.
	RCC_APB2SMENR_ADCSMEN_Msk = 0x200
	// Bit ADCSMEN.
	RCC_APB2SMENR_ADCSMEN = 0x200
	// Clock disabled
	RCC_APB2SMENR_ADCSMEN_Disabled = 0x0
	// Clock enabled
	RCC_APB2SMENR_ADCSMEN_Enabled = 0x1
	// Position of TIM22SMEN field.
	RCC_APB2SMENR_TIM22SMEN_Pos = 0x5
	// Bit mask of TIM22SMEN field.
	RCC_APB2SMENR_TIM22SMEN_Msk = 0x20
	// Bit TIM22SMEN.
	RCC_APB2SMENR_TIM22SMEN = 0x20
	// Clock disabled
	RCC_APB2SMENR_TIM22SMEN_Disabled = 0x0
	// Clock enabled
	RCC_APB2SMENR_TIM22SMEN_Enabled = 0x1
	// Position of TIM21SMEN field.
	RCC_APB2SMENR_TIM21SMEN_Pos = 0x2
	// Bit mask of TIM21SMEN field.
	RCC_APB2SMENR_TIM21SMEN_Msk = 0x4
	// Bit TIM21SMEN.
	RCC_APB2SMENR_TIM21SMEN = 0x4
	// Clock disabled
	RCC_APB2SMENR_TIM21SMEN_Disabled = 0x0
	// Clock enabled
	RCC_APB2SMENR_TIM21SMEN_Enabled = 0x1
	// Position of SYSCFGSMEN field.
	RCC_APB2SMENR_SYSCFGSMEN_Pos = 0x0
	// Bit mask of SYSCFGSMEN field.
	RCC_APB2SMENR_SYSCFGSMEN_Msk = 0x1
	// Bit SYSCFGSMEN.
	RCC_APB2SMENR_SYSCFGSMEN = 0x1
	// Clock disabled
	RCC_APB2SMENR_SYSCFGSMEN_Disabled = 0x0
	// Clock enabled
	RCC_APB2SMENR_SYSCFGSMEN_Enabled = 0x1

	// APB1SMENR: APB1 peripheral clock enable in sleep mode register
	// Position of LPTIM1SMEN field.
	RCC_APB1SMENR_LPTIM1SMEN_Pos = 0x1f
	// Bit mask of LPTIM1SMEN field.
	RCC_APB1SMENR_LPTIM1SMEN_Msk = 0x80000000
	// Bit LPTIM1SMEN.
	RCC_APB1SMENR_LPTIM1SMEN = 0x80000000
	// Clock disabled
	RCC_APB1SMENR_LPTIM1SMEN_Disabled = 0x0
	// Clock enabled
	RCC_APB1SMENR_LPTIM1SMEN_Enabled = 0x1
	// Position of DACSMEN field.
	RCC_APB1SMENR_DACSMEN_Pos = 0x1d
	// Bit mask of DACSMEN field.
	RCC_APB1SMENR_DACSMEN_Msk = 0x20000000
	// Bit DACSMEN.
	RCC_APB1SMENR_DACSMEN = 0x20000000
	// Clock disabled
	RCC_APB1SMENR_DACSMEN_Disabled = 0x0
	// Clock enabled
	RCC_APB1SMENR_DACSMEN_Enabled = 0x1
	// Position of PWRSMEN field.
	RCC_APB1SMENR_PWRSMEN_Pos = 0x1c
	// Bit mask of PWRSMEN field.
	RCC_APB1SMENR_PWRSMEN_Msk = 0x10000000
	// Bit PWRSMEN.
	RCC_APB1SMENR_PWRSMEN = 0x10000000
	// Clock disabled
	RCC_APB1SMENR_PWRSMEN_Disabled = 0x0
	// Clock enabled
	RCC_APB1SMENR_PWRSMEN_Enabled = 0x1
	// Position of CRSSMEN field.
	RCC_APB1SMENR_CRSSMEN_Pos = 0x1b
	// Bit mask of CRSSMEN field.
	RCC_APB1SMENR_CRSSMEN_Msk = 0x8000000
	// Bit CRSSMEN.
	RCC_APB1SMENR_CRSSMEN = 0x8000000
	// Clock disabled
	RCC_APB1SMENR_CRSSMEN_Disabled = 0x0
	// Clock enabled
	RCC_APB1SMENR_CRSSMEN_Enabled = 0x1
	// Position of USBSMEN field.
	RCC_APB1SMENR_USBSMEN_Pos = 0x17
	// Bit mask of USBSMEN field.
	RCC_APB1SMENR_USBSMEN_Msk = 0x800000
	// Bit USBSMEN.
	RCC_APB1SMENR_USBSMEN = 0x800000
	// Clock disabled
	RCC_APB1SMENR_USBSMEN_Disabled = 0x0
	// Clock enabled
	RCC_APB1SMENR_USBSMEN_Enabled = 0x1
	// Position of I2C2SMEN field.
	RCC_APB1SMENR_I2C2SMEN_Pos = 0x16
	// Bit mask of I2C2SMEN field.
	RCC_APB1SMENR_I2C2SMEN_Msk = 0x400000
	// Bit I2C2SMEN.
	RCC_APB1SMENR_I2C2SMEN = 0x400000
	// Clock disabled
	RCC_APB1SMENR_I2C2SMEN_Disabled = 0x0
	// Clock enabled
	RCC_APB1SMENR_I2C2SMEN_Enabled = 0x1
	// Position of I2C1SMEN field.
	RCC_APB1SMENR_I2C1SMEN_Pos = 0x15
	// Bit mask of I2C1SMEN field.
	RCC_APB1SMENR_I2C1SMEN_Msk = 0x200000
	// Bit I2C1SMEN.
	RCC_APB1SMENR_I2C1SMEN = 0x200000
	// Clock disabled
	RCC_APB1SMENR_I2C1SMEN_Disabled = 0x0
	// Clock enabled
	RCC_APB1SMENR_I2C1SMEN_Enabled = 0x1
	// Position of LPUART1SMEN field.
	RCC_APB1SMENR_LPUART1SMEN_Pos = 0x12
	// Bit mask of LPUART1SMEN field.
	RCC_APB1SMENR_LPUART1SMEN_Msk = 0x40000
	// Bit LPUART1SMEN.
	RCC_APB1SMENR_LPUART1SMEN = 0x40000
	// Clock disabled
	RCC_APB1SMENR_LPUART1SMEN_Disabled = 0x0
	// Clock enabled
	RCC_APB1SMENR_LPUART1SMEN_Enabled = 0x1
	// Position of USART2SMEN field.
	RCC_APB1SMENR_USART2SMEN_Pos = 0x11
	// Bit mask of USART2SMEN field.
	RCC_APB1SMENR_USART2SMEN_Msk = 0x20000
	// Bit USART2SMEN.
	RCC_APB1SMENR_USART2SMEN = 0x20000
	// Clock disabled
	RCC_APB1SMENR_USART2SMEN_Disabled = 0x0
	// Clock enabled
	RCC_APB1SMENR_USART2SMEN_Enabled = 0x1
	// Position of SPI2SMEN field.
	RCC_APB1SMENR_SPI2SMEN_Pos = 0xe
	// Bit mask of SPI2SMEN field.
	RCC_APB1SMENR_SPI2SMEN_Msk = 0x4000
	// Bit SPI2SMEN.
	RCC_APB1SMENR_SPI2SMEN = 0x4000
	// Clock disabled
	RCC_APB1SMENR_SPI2SMEN_Disabled = 0x0
	// Clock enabled
	RCC_APB1SMENR_SPI2SMEN_Enabled = 0x1
	// Position of WWDGSMEN field.
	RCC_APB1SMENR_WWDGSMEN_Pos = 0xb
	// Bit mask of WWDGSMEN field.
	RCC_APB1SMENR_WWDGSMEN_Msk = 0x800
	// Bit WWDGSMEN.
	RCC_APB1SMENR_WWDGSMEN = 0x800
	// Clock disabled
	RCC_APB1SMENR_WWDGSMEN_Disabled = 0x0
	// Clock enabled
	RCC_APB1SMENR_WWDGSMEN_Enabled = 0x1
	// Position of TIM6SMEN field.
	RCC_APB1SMENR_TIM6SMEN_Pos = 0x4
	// Bit mask of TIM6SMEN field.
	RCC_APB1SMENR_TIM6SMEN_Msk = 0x10
	// Bit TIM6SMEN.
	RCC_APB1SMENR_TIM6SMEN = 0x10
	// Clock disabled
	RCC_APB1SMENR_TIM6SMEN_Disabled = 0x0
	// Clock enabled
	RCC_APB1SMENR_TIM6SMEN_Enabled = 0x1
	// Position of TIM2SMEN field.
	RCC_APB1SMENR_TIM2SMEN_Pos = 0x0
	// Bit mask of TIM2SMEN field.
	RCC_APB1SMENR_TIM2SMEN_Msk = 0x1
	// Bit TIM2SMEN.
	RCC_APB1SMENR_TIM2SMEN = 0x1
	// Clock disabled
	RCC_APB1SMENR_TIM2SMEN_Disabled = 0x0
	// Clock enabled
	RCC_APB1SMENR_TIM2SMEN_Enabled = 0x1
	// Position of TIM3SMEN field.
	RCC_APB1SMENR_TIM3SMEN_Pos = 0x1
	// Bit mask of TIM3SMEN field.
	RCC_APB1SMENR_TIM3SMEN_Msk = 0x2
	// Bit TIM3SMEN.
	RCC_APB1SMENR_TIM3SMEN = 0x2
	// Clock disabled
	RCC_APB1SMENR_TIM3SMEN_Disabled = 0x0
	// Clock enabled
	RCC_APB1SMENR_TIM3SMEN_Enabled = 0x1
	// Position of TIM7SMEN field.
	RCC_APB1SMENR_TIM7SMEN_Pos = 0x5
	// Bit mask of TIM7SMEN field.
	RCC_APB1SMENR_TIM7SMEN_Msk = 0x20
	// Bit TIM7SMEN.
	RCC_APB1SMENR_TIM7SMEN = 0x20
	// Clock disabled
	RCC_APB1SMENR_TIM7SMEN_Disabled = 0x0
	// Clock enabled
	RCC_APB1SMENR_TIM7SMEN_Enabled = 0x1
	// Position of USART4SMEN field.
	RCC_APB1SMENR_USART4SMEN_Pos = 0x13
	// Bit mask of USART4SMEN field.
	RCC_APB1SMENR_USART4SMEN_Msk = 0x80000
	// Bit USART4SMEN.
	RCC_APB1SMENR_USART4SMEN = 0x80000
	// Clock disabled
	RCC_APB1SMENR_USART4SMEN_Disabled = 0x0
	// Clock enabled
	RCC_APB1SMENR_USART4SMEN_Enabled = 0x1
	// Position of USART5SMEN field.
	RCC_APB1SMENR_USART5SMEN_Pos = 0x14
	// Bit mask of USART5SMEN field.
	RCC_APB1SMENR_USART5SMEN_Msk = 0x100000
	// Bit USART5SMEN.
	RCC_APB1SMENR_USART5SMEN = 0x100000
	// Clock disabled
	RCC_APB1SMENR_USART5SMEN_Disabled = 0x0
	// Clock enabled
	RCC_APB1SMENR_USART5SMEN_Enabled = 0x1
	// Position of I2C3SMEN field.
	RCC_APB1SMENR_I2C3SMEN_Pos = 0x1e
	// Bit mask of I2C3SMEN field.
	RCC_APB1SMENR_I2C3SMEN_Msk = 0x40000000
	// Bit I2C3SMEN.
	RCC_APB1SMENR_I2C3SMEN = 0x40000000
	// Clock disabled
	RCC_APB1SMENR_I2C3SMEN_Disabled = 0x0
	// Clock enabled
	RCC_APB1SMENR_I2C3SMEN_Enabled = 0x1

	// CCIPR: Clock configuration register
	// Position of HSI48MSEL field.
	RCC_CCIPR_HSI48MSEL_Pos = 0x1a
	// Bit mask of HSI48MSEL field.
	RCC_CCIPR_HSI48MSEL_Msk = 0x4000000
	// Bit HSI48MSEL.
	RCC_CCIPR_HSI48MSEL = 0x4000000
	// Position of I2C3SEL field.
	RCC_CCIPR_I2C3SEL_Pos = 0x10
	// Bit mask of I2C3SEL field.
	RCC_CCIPR_I2C3SEL_Msk = 0x30000
	// APB clock selected as peripheral clock
	RCC_CCIPR_I2C3SEL_APB = 0x0
	// System clock selected as peripheral clock
	RCC_CCIPR_I2C3SEL_SYSTEM = 0x1
	// HSI16 clock selected as peripheral clock
	RCC_CCIPR_I2C3SEL_HSI16 = 0x2
	// Position of LPTIM1SEL field.
	RCC_CCIPR_LPTIM1SEL_Pos = 0x12
	// Bit mask of LPTIM1SEL field.
	RCC_CCIPR_LPTIM1SEL_Msk = 0xc0000
	// APB clock selected as Timer clock
	RCC_CCIPR_LPTIM1SEL_APB = 0x0
	// LSI clock selected as Timer clock
	RCC_CCIPR_LPTIM1SEL_LSI = 0x1
	// HSI16 clock selected as Timer clock
	RCC_CCIPR_LPTIM1SEL_HSI16 = 0x2
	// LSE clock selected as Timer clock
	RCC_CCIPR_LPTIM1SEL_LSE = 0x3
	// Position of I2C1SEL field.
	RCC_CCIPR_I2C1SEL_Pos = 0xc
	// Bit mask of I2C1SEL field.
	RCC_CCIPR_I2C1SEL_Msk = 0x3000
	// APB clock selected as peripheral clock
	RCC_CCIPR_I2C1SEL_APB = 0x0
	// System clock selected as peripheral clock
	RCC_CCIPR_I2C1SEL_SYSTEM = 0x1
	// HSI16 clock selected as peripheral clock
	RCC_CCIPR_I2C1SEL_HSI16 = 0x2
	// Position of LPUART1SEL field.
	RCC_CCIPR_LPUART1SEL_Pos = 0xa
	// Bit mask of LPUART1SEL field.
	RCC_CCIPR_LPUART1SEL_Msk = 0xc00
	// APB clock selected as peripheral clock
	RCC_CCIPR_LPUART1SEL_APB = 0x0
	// System clock selected as peripheral clock
	RCC_CCIPR_LPUART1SEL_SYSTEM = 0x1
	// HSI16 clock selected as peripheral clock
	RCC_CCIPR_LPUART1SEL_HSI16 = 0x2
	// LSE clock selected as peripheral clock
	RCC_CCIPR_LPUART1SEL_LSE = 0x3
	// Position of USART2SEL field.
	RCC_CCIPR_USART2SEL_Pos = 0x2
	// Bit mask of USART2SEL field.
	RCC_CCIPR_USART2SEL_Msk = 0xc
	// APB clock selected as peripheral clock
	RCC_CCIPR_USART2SEL_APB = 0x0
	// System clock selected as peripheral clock
	RCC_CCIPR_USART2SEL_SYSTEM = 0x1
	// HSI16 clock selected as peripheral clock
	RCC_CCIPR_USART2SEL_HSI16 = 0x2
	// LSE clock selected as peripheral clock
	RCC_CCIPR_USART2SEL_LSE = 0x3
	// Position of USART1SEL field.
	RCC_CCIPR_USART1SEL_Pos = 0x0
	// Bit mask of USART1SEL field.
	RCC_CCIPR_USART1SEL_Msk = 0x3
	// APB clock selected as peripheral clock
	RCC_CCIPR_USART1SEL_APB = 0x0
	// System clock selected as peripheral clock
	RCC_CCIPR_USART1SEL_SYSTEM = 0x1
	// HSI16 clock selected as peripheral clock
	RCC_CCIPR_USART1SEL_HSI16 = 0x2
	// LSE clock selected as peripheral clock
	RCC_CCIPR_USART1SEL_LSE = 0x3

	// CSR: Control and status register
	// Position of LPWRRSTF field.
	RCC_CSR_LPWRRSTF_Pos = 0x1f
	// Bit mask of LPWRRSTF field.
	RCC_CSR_LPWRRSTF_Msk = 0x80000000
	// Bit LPWRRSTF.
	RCC_CSR_LPWRRSTF = 0x80000000
	// No reset has occured
	RCC_CSR_LPWRRSTF_NoReset = 0x0
	// A reset has occured
	RCC_CSR_LPWRRSTF_Reset = 0x1
	// Position of WWDGRSTF field.
	RCC_CSR_WWDGRSTF_Pos = 0x1e
	// Bit mask of WWDGRSTF field.
	RCC_CSR_WWDGRSTF_Msk = 0x40000000
	// Bit WWDGRSTF.
	RCC_CSR_WWDGRSTF = 0x40000000
	// No reset has occured
	RCC_CSR_WWDGRSTF_NoReset = 0x0
	// A reset has occured
	RCC_CSR_WWDGRSTF_Reset = 0x1
	// Position of IWDGRSTF field.
	RCC_CSR_IWDGRSTF_Pos = 0x1d
	// Bit mask of IWDGRSTF field.
	RCC_CSR_IWDGRSTF_Msk = 0x20000000
	// Bit IWDGRSTF.
	RCC_CSR_IWDGRSTF = 0x20000000
	// No reset has occured
	RCC_CSR_IWDGRSTF_NoReset = 0x0
	// A reset has occured
	RCC_CSR_IWDGRSTF_Reset = 0x1
	// Position of SFTRSTF field.
	RCC_CSR_SFTRSTF_Pos = 0x1c
	// Bit mask of SFTRSTF field.
	RCC_CSR_SFTRSTF_Msk = 0x10000000
	// Bit SFTRSTF.
	RCC_CSR_SFTRSTF = 0x10000000
	// No reset has occured
	RCC_CSR_SFTRSTF_NoReset = 0x0
	// A reset has occured
	RCC_CSR_SFTRSTF_Reset = 0x1
	// Position of PORRSTF field.
	RCC_CSR_PORRSTF_Pos = 0x1b
	// Bit mask of PORRSTF field.
	RCC_CSR_PORRSTF_Msk = 0x8000000
	// Bit PORRSTF.
	RCC_CSR_PORRSTF = 0x8000000
	// No reset has occured
	RCC_CSR_PORRSTF_NoReset = 0x0
	// A reset has occured
	RCC_CSR_PORRSTF_Reset = 0x1
	// Position of PINRSTF field.
	RCC_CSR_PINRSTF_Pos = 0x1a
	// Bit mask of PINRSTF field.
	RCC_CSR_PINRSTF_Msk = 0x4000000
	// Bit PINRSTF.
	RCC_CSR_PINRSTF = 0x4000000
	// No reset has occured
	RCC_CSR_PINRSTF_NoReset = 0x0
	// A reset has occured
	RCC_CSR_PINRSTF_Reset = 0x1
	// Position of OBLRSTF field.
	RCC_CSR_OBLRSTF_Pos = 0x19
	// Bit mask of OBLRSTF field.
	RCC_CSR_OBLRSTF_Msk = 0x2000000
	// Bit OBLRSTF.
	RCC_CSR_OBLRSTF = 0x2000000
	// No reset has occured
	RCC_CSR_OBLRSTF_NoReset = 0x0
	// A reset has occured
	RCC_CSR_OBLRSTF_Reset = 0x1
	// Position of RMVF field.
	RCC_CSR_RMVF_Pos = 0x18
	// Bit mask of RMVF field.
	RCC_CSR_RMVF_Msk = 0x1000000
	// Bit RMVF.
	RCC_CSR_RMVF = 0x1000000
	// Clears the reset flag
	RCC_CSR_RMVF_Clear = 0x1
	// Position of RTCRST field.
	RCC_CSR_RTCRST_Pos = 0x13
	// Bit mask of RTCRST field.
	RCC_CSR_RTCRST_Msk = 0x80000
	// Bit RTCRST.
	RCC_CSR_RTCRST = 0x80000
	// Resets the RTC peripheral
	RCC_CSR_RTCRST_Reset = 0x1
	// Position of RTCEN field.
	RCC_CSR_RTCEN_Pos = 0x12
	// Bit mask of RTCEN field.
	RCC_CSR_RTCEN_Msk = 0x40000
	// Bit RTCEN.
	RCC_CSR_RTCEN = 0x40000
	// RTC clock disabled
	RCC_CSR_RTCEN_Disabled = 0x0
	// RTC clock enabled
	RCC_CSR_RTCEN_Enabled = 0x1
	// Position of RTCSEL field.
	RCC_CSR_RTCSEL_Pos = 0x10
	// Bit mask of RTCSEL field.
	RCC_CSR_RTCSEL_Msk = 0x30000
	// No clock
	RCC_CSR_RTCSEL_NoClock = 0x0
	// LSE oscillator clock used as RTC clock
	RCC_CSR_RTCSEL_LSE = 0x1
	// LSI oscillator clock used as RTC clock
	RCC_CSR_RTCSEL_LSI = 0x2
	// HSE oscillator clock divided by a programmable prescaler (selection through the RTCPRE[1:0] bits in the RCC clock control register (RCC_CR)) used as the RTC clock
	RCC_CSR_RTCSEL_HSE = 0x3
	// Position of CSSLSED field.
	RCC_CSR_CSSLSED_Pos = 0xe
	// Bit mask of CSSLSED field.
	RCC_CSR_CSSLSED_Msk = 0x4000
	// Bit CSSLSED.
	RCC_CSR_CSSLSED = 0x4000
	// No failure detected on LSE (32 kHz oscillator)
	RCC_CSR_CSSLSED_NoFailure = 0x0
	// Failure detected on LSE (32 kHz oscillator)
	RCC_CSR_CSSLSED_Failure = 0x1
	// Position of CSSLSEON field.
	RCC_CSR_CSSLSEON_Pos = 0xd
	// Bit mask of CSSLSEON field.
	RCC_CSR_CSSLSEON_Msk = 0x2000
	// Bit CSSLSEON.
	RCC_CSR_CSSLSEON = 0x2000
	// Oscillator OFF
	RCC_CSR_CSSLSEON_Off = 0x0
	// Oscillator ON
	RCC_CSR_CSSLSEON_On = 0x1
	// Position of LSEDRV field.
	RCC_CSR_LSEDRV_Pos = 0xb
	// Bit mask of LSEDRV field.
	RCC_CSR_LSEDRV_Msk = 0x1800
	// Lowest drive
	RCC_CSR_LSEDRV_Low = 0x0
	// Medium low drive
	RCC_CSR_LSEDRV_MediumLow = 0x1
	// Medium high drive
	RCC_CSR_LSEDRV_MediumHigh = 0x2
	// Highest drive
	RCC_CSR_LSEDRV_High = 0x3
	// Position of LSEBYP field.
	RCC_CSR_LSEBYP_Pos = 0xa
	// Bit mask of LSEBYP field.
	RCC_CSR_LSEBYP_Msk = 0x400
	// Bit LSEBYP.
	RCC_CSR_LSEBYP = 0x400
	// LSE oscillator not bypassed
	RCC_CSR_LSEBYP_NotBypassed = 0x0
	// LSE oscillator bypassed
	RCC_CSR_LSEBYP_Bypassed = 0x1
	// Position of LSERDY field.
	RCC_CSR_LSERDY_Pos = 0x9
	// Bit mask of LSERDY field.
	RCC_CSR_LSERDY_Msk = 0x200
	// Bit LSERDY.
	RCC_CSR_LSERDY = 0x200
	// Oscillator not ready
	RCC_CSR_LSERDY_NotReady = 0x0
	// Oscillator ready
	RCC_CSR_LSERDY_Ready = 0x1
	// Position of LSEON field.
	RCC_CSR_LSEON_Pos = 0x8
	// Bit mask of LSEON field.
	RCC_CSR_LSEON_Msk = 0x100
	// Bit LSEON.
	RCC_CSR_LSEON = 0x100
	// Oscillator OFF
	RCC_CSR_LSEON_Off = 0x0
	// Oscillator ON
	RCC_CSR_LSEON_On = 0x1
	// Position of LSIRDY field.
	RCC_CSR_LSIRDY_Pos = 0x1
	// Bit mask of LSIRDY field.
	RCC_CSR_LSIRDY_Msk = 0x2
	// Bit LSIRDY.
	RCC_CSR_LSIRDY = 0x2
	// Oscillator not ready
	RCC_CSR_LSIRDY_NotReady = 0x0
	// Oscillator ready
	RCC_CSR_LSIRDY_Ready = 0x1
	// Position of LSION field.
	RCC_CSR_LSION_Pos = 0x0
	// Bit mask of LSION field.
	RCC_CSR_LSION_Msk = 0x1
	// Bit LSION.
	RCC_CSR_LSION = 0x1
	// Oscillator OFF
	RCC_CSR_LSION_Off = 0x0
	// Oscillator ON
	RCC_CSR_LSION_On = 0x1
)

// Bitfields for SYSCFG: System configuration controller and Comparator
const (
	// CFGR1: SYSCFG configuration register 1
	// Position of BOOT_MODE field.
	SYSCFG_CFGR1_BOOT_MODE_Pos = 0x8
	// Bit mask of BOOT_MODE field.
	SYSCFG_CFGR1_BOOT_MODE_Msk = 0x300
	// Main Flash memory boot mode
	SYSCFG_CFGR1_BOOT_MODE_MainFlash = 0x0
	// System Flash memory boot mode
	SYSCFG_CFGR1_BOOT_MODE_SystemFlash = 0x1
	// Embedded SRAM boot mode
	SYSCFG_CFGR1_BOOT_MODE_SRAM = 0x3
	// Position of MEM_MODE field.
	SYSCFG_CFGR1_MEM_MODE_Pos = 0x0
	// Bit mask of MEM_MODE field.
	SYSCFG_CFGR1_MEM_MODE_Msk = 0x3
	// Main Flash memory mapped at 0x0000_0000
	SYSCFG_CFGR1_MEM_MODE_MainFlash = 0x0
	// System Flash memory mapped at 0x0000_0000
	SYSCFG_CFGR1_MEM_MODE_SystemFlash = 0x1
	// Embedded SRAM mapped at 0x0000_0000
	SYSCFG_CFGR1_MEM_MODE_SRAM = 0x3
	// Position of UFB field.
	SYSCFG_CFGR1_UFB_Pos = 0x3
	// Bit mask of UFB field.
	SYSCFG_CFGR1_UFB_Msk = 0x8
	// Bit UFB.
	SYSCFG_CFGR1_UFB = 0x8
	// Flash Program memory Bank 1 is mapped at 0x0800 0000 (and aliased at 0x0000 0000 if MEM_MODE=00) and Data EEPROM Bank 1 at 0x0808 0000 (aliased at 0x0008 0000 if MEM_MODE=00)
	SYSCFG_CFGR1_UFB_Bank1 = 0x0
	// Flash Program memory Bank 2 is mapped at 0x0800 0000 (and aliased at 0x0000 0000 if MEM_MODE=00) and Data EEPROM Bank 2 at 0x0808 0000 (and aliased at 0x0008 0000 if MEM_MODE=00)
	SYSCFG_CFGR1_UFB_Bank2 = 0x1

	// CFGR2: SYSCFG configuration register 2
	// Position of I2C2_FMP field.
	SYSCFG_CFGR2_I2C2_FMP_Pos = 0xd
	// Bit mask of I2C2_FMP field.
	SYSCFG_CFGR2_I2C2_FMP_Msk = 0x2000
	// Bit I2C2_FMP.
	SYSCFG_CFGR2_I2C2_FMP = 0x2000
	// FM+ mode is controlled by I2C_Pxx_FMP bits only
	SYSCFG_CFGR2_I2C2_FMP_Standard = 0x0
	// FM+ mode is enabled on all I2C2 pins selected through selection bits in GPIOx_AFR registers
	SYSCFG_CFGR2_I2C2_FMP_FMP = 0x1
	// Position of I2C1_FMP field.
	SYSCFG_CFGR2_I2C1_FMP_Pos = 0xc
	// Bit mask of I2C1_FMP field.
	SYSCFG_CFGR2_I2C1_FMP_Msk = 0x1000
	// Bit I2C1_FMP.
	SYSCFG_CFGR2_I2C1_FMP = 0x1000
	// FM+ mode is controlled by I2C_Pxx_FMP bits only
	SYSCFG_CFGR2_I2C1_FMP_Standard = 0x0
	// FM+ mode is enabled on all I2C1 pins selected through selection bits in GPIOx_AFR registers
	SYSCFG_CFGR2_I2C1_FMP_FMP = 0x1
	// Position of I2C_PB9_FMP field.
	SYSCFG_CFGR2_I2C_PB9_FMP_Pos = 0xb
	// Bit mask of I2C_PB9_FMP field.
	SYSCFG_CFGR2_I2C_PB9_FMP_Msk = 0x800
	// Bit I2C_PB9_FMP.
	SYSCFG_CFGR2_I2C_PB9_FMP = 0x800
	// PB9 pin operate in standard mode
	SYSCFG_CFGR2_I2C_PB9_FMP_Standard = 0x0
	// I2C FM+ mode enabled on PB9 and the Speed control is bypassed
	SYSCFG_CFGR2_I2C_PB9_FMP_FMP = 0x1
	// Position of I2C_PB8_FMP field.
	SYSCFG_CFGR2_I2C_PB8_FMP_Pos = 0xa
	// Bit mask of I2C_PB8_FMP field.
	SYSCFG_CFGR2_I2C_PB8_FMP_Msk = 0x400
	// Bit I2C_PB8_FMP.
	SYSCFG_CFGR2_I2C_PB8_FMP = 0x400
	// PB8 pin operate in standard mode
	SYSCFG_CFGR2_I2C_PB8_FMP_Standard = 0x0
	// I2C FM+ mode enabled on PB8 and the Speed control is bypassed
	SYSCFG_CFGR2_I2C_PB8_FMP_FMP = 0x1
	// Position of I2C_PB7_FMP field.
	SYSCFG_CFGR2_I2C_PB7_FMP_Pos = 0x9
	// Bit mask of I2C_PB7_FMP field.
	SYSCFG_CFGR2_I2C_PB7_FMP_Msk = 0x200
	// Bit I2C_PB7_FMP.
	SYSCFG_CFGR2_I2C_PB7_FMP = 0x200
	// PB7 pin operate in standard mode
	SYSCFG_CFGR2_I2C_PB7_FMP_Standard = 0x0
	// I2C FM+ mode enabled on PB7 and the Speed control is bypassed
	SYSCFG_CFGR2_I2C_PB7_FMP_FMP = 0x1
	// Position of I2C_PB6_FMP field.
	SYSCFG_CFGR2_I2C_PB6_FMP_Pos = 0x8
	// Bit mask of I2C_PB6_FMP field.
	SYSCFG_CFGR2_I2C_PB6_FMP_Msk = 0x100
	// Bit I2C_PB6_FMP.
	SYSCFG_CFGR2_I2C_PB6_FMP = 0x100
	// PB6 pin operate in standard mode
	SYSCFG_CFGR2_I2C_PB6_FMP_Standard = 0x0
	// I2C FM+ mode enabled on PB6 and the Speed control is bypassed
	SYSCFG_CFGR2_I2C_PB6_FMP_FMP = 0x1
	// Position of I2C3_FMP field.
	SYSCFG_CFGR2_I2C3_FMP_Pos = 0xe
	// Bit mask of I2C3_FMP field.
	SYSCFG_CFGR2_I2C3_FMP_Msk = 0x4000
	// Bit I2C3_FMP.
	SYSCFG_CFGR2_I2C3_FMP = 0x4000
	// FM+ mode is controlled by I2C_Pxx_FMP bits only
	SYSCFG_CFGR2_I2C3_FMP_Standard = 0x0
	// FM+ mode is enabled on all I2C3 pins selected through selection bits in GPIOx_AFR registers
	SYSCFG_CFGR2_I2C3_FMP_FMP = 0x1
	// Position of FWDIS field.
	SYSCFG_CFGR2_FWDIS_Pos = 0x0
	// Bit mask of FWDIS field.
	SYSCFG_CFGR2_FWDIS_Msk = 0x1
	// Bit FWDIS.
	SYSCFG_CFGR2_FWDIS = 0x1
	// Firewall access enabled
	SYSCFG_CFGR2_FWDIS_Enabled = 0x0
	// Firewall access disabled
	SYSCFG_CFGR2_FWDIS_Disabled = 0x1

	// EXTICR1: external interrupt configuration register 1
	// Position of EXTI3 field.
	SYSCFG_EXTICR1_EXTI3_Pos = 0xc
	// Bit mask of EXTI3 field.
	SYSCFG_EXTICR1_EXTI3_Msk = 0xf000
	// Select PA3 as the source input for the EXTI3 external interrupt
	SYSCFG_EXTICR1_EXTI3_PA3 = 0x0
	// Select PB3 as the source input for the EXTI3 external interrupt
	SYSCFG_EXTICR1_EXTI3_PB3 = 0x1
	// Select PC3 as the source input for the EXTI3 external interrupt
	SYSCFG_EXTICR1_EXTI3_PC3 = 0x2
	// Select PD3 as the source input for the EXTI3 external interrupt
	SYSCFG_EXTICR1_EXTI3_PD3 = 0x3
	// Select PE3 as the source input for the EXTI3 external interrupt
	SYSCFG_EXTICR1_EXTI3_PE3 = 0x4
	// Select PH3 as the source input for the EXTI3 external interrupt
	SYSCFG_EXTICR1_EXTI3_PH3 = 0x5
	// Position of EXTI2 field.
	SYSCFG_EXTICR1_EXTI2_Pos = 0x8
	// Bit mask of EXTI2 field.
	SYSCFG_EXTICR1_EXTI2_Msk = 0xf00
	// Select PA2 as the source input for the EXTI2 external interrupt
	SYSCFG_EXTICR1_EXTI2_PA2 = 0x0
	// Select PB2 as the source input for the EXTI2 external interrupt
	SYSCFG_EXTICR1_EXTI2_PB2 = 0x1
	// Select PC2 as the source input for the EXTI2 external interrupt
	SYSCFG_EXTICR1_EXTI2_PC2 = 0x2
	// Select PD2 as the source input for the EXTI2 external interrupt
	SYSCFG_EXTICR1_EXTI2_PD2 = 0x3
	// Select PE2 as the source input for the EXTI2 external interrupt
	SYSCFG_EXTICR1_EXTI2_PE2 = 0x4
	// Select PH2 as the source input for the EXTI2 external interrupt
	SYSCFG_EXTICR1_EXTI2_PH2 = 0x5
	// Position of EXTI1 field.
	SYSCFG_EXTICR1_EXTI1_Pos = 0x4
	// Bit mask of EXTI1 field.
	SYSCFG_EXTICR1_EXTI1_Msk = 0xf0
	// Select PA1 as the source input for the EXTI1 external interrupt
	SYSCFG_EXTICR1_EXTI1_PA1 = 0x0
	// Select PB1 as the source input for the EXTI1 external interrupt
	SYSCFG_EXTICR1_EXTI1_PB1 = 0x1
	// Select PC1 as the source input for the EXTI1 external interrupt
	SYSCFG_EXTICR1_EXTI1_PC1 = 0x2
	// Select PD1 as the source input for the EXTI1 external interrupt
	SYSCFG_EXTICR1_EXTI1_PD1 = 0x3
	// Select PE1 as the source input for the EXTI1 external interrupt
	SYSCFG_EXTICR1_EXTI1_PE1 = 0x4
	// Select PH1 as the source input for the EXTI1 external interrupt
	SYSCFG_EXTICR1_EXTI1_PH1 = 0x5
	// Position of EXTI0 field.
	SYSCFG_EXTICR1_EXTI0_Pos = 0x0
	// Bit mask of EXTI0 field.
	SYSCFG_EXTICR1_EXTI0_Msk = 0xf
	// Select PA0 as the source input for the EXTI0 external interrupt
	SYSCFG_EXTICR1_EXTI0_PA0 = 0x0
	// Select PB0 as the source input for the EXTI0 external interrupt
	SYSCFG_EXTICR1_EXTI0_PB0 = 0x1
	// Select PC0 as the source input for the EXTI0 external interrupt
	SYSCFG_EXTICR1_EXTI0_PC0 = 0x2
	// Select PD0 as the source input for the EXTI0 external interrupt
	SYSCFG_EXTICR1_EXTI0_PD0 = 0x3
	// Select PE0 as the source input for the EXTI0 external interrupt
	SYSCFG_EXTICR1_EXTI0_PE0 = 0x4
	// Select PH0 as the source input for the EXTI0 external interrupt
	SYSCFG_EXTICR1_EXTI0_PH0 = 0x5

	// EXTICR2: external interrupt configuration register 2
	// Position of EXTI7 field.
	SYSCFG_EXTICR2_EXTI7_Pos = 0xc
	// Bit mask of EXTI7 field.
	SYSCFG_EXTICR2_EXTI7_Msk = 0xf000
	// Select PA7 as the source input for the EXTI7 external interrupt
	SYSCFG_EXTICR2_EXTI7_PA7 = 0x0
	// Select PB7 as the source input for the EXTI7 external interrupt
	SYSCFG_EXTICR2_EXTI7_PB7 = 0x1
	// Select PC7 as the source input for the EXTI7 external interrupt
	SYSCFG_EXTICR2_EXTI7_PC7 = 0x2
	// Select PD7 as the source input for the EXTI7 external interrupt
	SYSCFG_EXTICR2_EXTI7_PD7 = 0x3
	// Select PE7 as the source input for the EXTI7 external interrupt
	SYSCFG_EXTICR2_EXTI7_PE7 = 0x4
	// Position of EXTI6 field.
	SYSCFG_EXTICR2_EXTI6_Pos = 0x8
	// Bit mask of EXTI6 field.
	SYSCFG_EXTICR2_EXTI6_Msk = 0xf00
	// Select PA6 as the source input for the EXTI6 external interrupt
	SYSCFG_EXTICR2_EXTI6_PA6 = 0x0
	// Select PB6 as the source input for the EXTI6 external interrupt
	SYSCFG_EXTICR2_EXTI6_PB6 = 0x1
	// Select PC6 as the source input for the EXTI6 external interrupt
	SYSCFG_EXTICR2_EXTI6_PC6 = 0x2
	// Select PD6 as the source input for the EXTI6 external interrupt
	SYSCFG_EXTICR2_EXTI6_PD6 = 0x3
	// Select PE6 as the source input for the EXTI6 external interrupt
	SYSCFG_EXTICR2_EXTI6_PE6 = 0x4
	// Position of EXTI5 field.
	SYSCFG_EXTICR2_EXTI5_Pos = 0x4
	// Bit mask of EXTI5 field.
	SYSCFG_EXTICR2_EXTI5_Msk = 0xf0
	// Select PA5 as the source input for the EXTI5 external interrupt
	SYSCFG_EXTICR2_EXTI5_PA5 = 0x0
	// Select PB5 as the source input for the EXTI5 external interrupt
	SYSCFG_EXTICR2_EXTI5_PB5 = 0x1
	// Select PC5 as the source input for the EXTI5 external interrupt
	SYSCFG_EXTICR2_EXTI5_PC5 = 0x2
	// Select PD5 as the source input for the EXTI5 external interrupt
	SYSCFG_EXTICR2_EXTI5_PD5 = 0x3
	// Select PE5 as the source input for the EXTI5 external interrupt
	SYSCFG_EXTICR2_EXTI5_PE5 = 0x4
	// Position of EXTI4 field.
	SYSCFG_EXTICR2_EXTI4_Pos = 0x0
	// Bit mask of EXTI4 field.
	SYSCFG_EXTICR2_EXTI4_Msk = 0xf
	// Select PA4 as the source input for the EXTI4 external interrupt
	SYSCFG_EXTICR2_EXTI4_PA4 = 0x0
	// Select PB4 as the source input for the EXTI4 external interrupt
	SYSCFG_EXTICR2_EXTI4_PB4 = 0x1
	// Select PC4 as the source input for the EXTI4 external interrupt
	SYSCFG_EXTICR2_EXTI4_PC4 = 0x2
	// Select PD4 as the source input for the EXTI4 external interrupt
	SYSCFG_EXTICR2_EXTI4_PD4 = 0x3
	// Select PE4 as the source input for the EXTI4 external interrupt
	SYSCFG_EXTICR2_EXTI4_PE4 = 0x4

	// EXTICR3: external interrupt configuration register 3
	// Position of EXTI11 field.
	SYSCFG_EXTICR3_EXTI11_Pos = 0xc
	// Bit mask of EXTI11 field.
	SYSCFG_EXTICR3_EXTI11_Msk = 0xf000
	// Select PA11 as the source input for the EXTI11 external interrupt
	SYSCFG_EXTICR3_EXTI11_PA11 = 0x0
	// Select PB11 as the source input for the EXTI11 external interrupt
	SYSCFG_EXTICR3_EXTI11_PB11 = 0x1
	// Select PC11 as the source input for the EXTI11 external interrupt
	SYSCFG_EXTICR3_EXTI11_PC11 = 0x2
	// Select PD11 as the source input for the EXTI11 external interrupt
	SYSCFG_EXTICR3_EXTI11_PD11 = 0x3
	// Select PE11 as the source input for the EXTI11 external interrupt
	SYSCFG_EXTICR3_EXTI11_PE11 = 0x4
	// Select PH11 as the source input for the EXTI11 external interrupt
	SYSCFG_EXTICR3_EXTI11_PH11 = 0x5
	// Position of EXTI10 field.
	SYSCFG_EXTICR3_EXTI10_Pos = 0x8
	// Bit mask of EXTI10 field.
	SYSCFG_EXTICR3_EXTI10_Msk = 0xf00
	// Select PA10 as the source input for the EXTI10 external interrupt
	SYSCFG_EXTICR3_EXTI10_PA10 = 0x0
	// Select PB10 as the source input for the EXTI10 external interrupt
	SYSCFG_EXTICR3_EXTI10_PB10 = 0x1
	// Select PC10 as the source input for the EXTI10 external interrupt
	SYSCFG_EXTICR3_EXTI10_PC10 = 0x2
	// Select PD10 as the source input for the EXTI10 external interrupt
	SYSCFG_EXTICR3_EXTI10_PD10 = 0x3
	// Select PE10 as the source input for the EXTI10 external interrupt
	SYSCFG_EXTICR3_EXTI10_PE10 = 0x4
	// Select PH10 as the source input for the EXTI10 external interrupt
	SYSCFG_EXTICR3_EXTI10_PH10 = 0x5
	// Position of EXTI9 field.
	SYSCFG_EXTICR3_EXTI9_Pos = 0x4
	// Bit mask of EXTI9 field.
	SYSCFG_EXTICR3_EXTI9_Msk = 0xf0
	// Select PA9 as the source input for the EXTI9 external interrupt
	SYSCFG_EXTICR3_EXTI9_PA9 = 0x0
	// Select PB9 as the source input for the EXTI9 external interrupt
	SYSCFG_EXTICR3_EXTI9_PB9 = 0x1
	// Select PC9 as the source input for the EXTI9 external interrupt
	SYSCFG_EXTICR3_EXTI9_PC9 = 0x2
	// Select PD9 as the source input for the EXTI9 external interrupt
	SYSCFG_EXTICR3_EXTI9_PD9 = 0x3
	// Select PE9 as the source input for the EXTI9 external interrupt
	SYSCFG_EXTICR3_EXTI9_PE9 = 0x4
	// Select PH9 as the source input for the EXTI9 external interrupt
	SYSCFG_EXTICR3_EXTI9_PH9 = 0x5
	// Position of EXTI8 field.
	SYSCFG_EXTICR3_EXTI8_Pos = 0x0
	// Bit mask of EXTI8 field.
	SYSCFG_EXTICR3_EXTI8_Msk = 0xf
	// Select PA8 as the source input for the EXTI8 external interrupt
	SYSCFG_EXTICR3_EXTI8_PA8 = 0x0
	// Select PB8 as the source input for the EXTI8 external interrupt
	SYSCFG_EXTICR3_EXTI8_PB8 = 0x1
	// Select PC8 as the source input for the EXTI8 external interrupt
	SYSCFG_EXTICR3_EXTI8_PC8 = 0x2
	// Select PD8 as the source input for the EXTI8 external interrupt
	SYSCFG_EXTICR3_EXTI8_PD8 = 0x3
	// Select PE8 as the source input for the EXTI8 external interrupt
	SYSCFG_EXTICR3_EXTI8_PE8 = 0x4
	// Select PH8 as the source input for the EXTI8 external interrupt
	SYSCFG_EXTICR3_EXTI8_PH8 = 0x5

	// EXTICR4: external interrupt configuration register 4
	// Position of EXTI15 field.
	SYSCFG_EXTICR4_EXTI15_Pos = 0xc
	// Bit mask of EXTI15 field.
	SYSCFG_EXTICR4_EXTI15_Msk = 0xf000
	// Select PA15 as the source input for the EXTI15 external interrupt
	SYSCFG_EXTICR4_EXTI15_PA15 = 0x0
	// Select PB15 as the source input for the EXTI15 external interrupt
	SYSCFG_EXTICR4_EXTI15_PB15 = 0x1
	// Select PC15 as the source input for the EXTI15 external interrupt
	SYSCFG_EXTICR4_EXTI15_PC15 = 0x2
	// Select PD15 as the source input for the EXTI15 external interrupt
	SYSCFG_EXTICR4_EXTI15_PD15 = 0x3
	// Select PE15 as the source input for the EXTI15 external interrupt
	SYSCFG_EXTICR4_EXTI15_PE15 = 0x4
	// Position of EXTI14 field.
	SYSCFG_EXTICR4_EXTI14_Pos = 0x8
	// Bit mask of EXTI14 field.
	SYSCFG_EXTICR4_EXTI14_Msk = 0xf00
	// Select PA14 as the source input for the EXTI14 external interrupt
	SYSCFG_EXTICR4_EXTI14_PA14 = 0x0
	// Select PB14 as the source input for the EXTI14 external interrupt
	SYSCFG_EXTICR4_EXTI14_PB14 = 0x1
	// Select PC14 as the source input for the EXTI14 external interrupt
	SYSCFG_EXTICR4_EXTI14_PC14 = 0x2
	// Select PD14 as the source input for the EXTI14 external interrupt
	SYSCFG_EXTICR4_EXTI14_PD14 = 0x3
	// Select PE14 as the source input for the EXTI14 external interrupt
	SYSCFG_EXTICR4_EXTI14_PE14 = 0x4
	// Position of EXTI13 field.
	SYSCFG_EXTICR4_EXTI13_Pos = 0x4
	// Bit mask of EXTI13 field.
	SYSCFG_EXTICR4_EXTI13_Msk = 0xf0
	// Select PA13 as the source input for the EXTI13 external interrupt
	SYSCFG_EXTICR4_EXTI13_PA13 = 0x0
	// Select PB13 as the source input for the EXTI13 external interrupt
	SYSCFG_EXTICR4_EXTI13_PB13 = 0x1
	// Select PC13 as the source input for the EXTI13 external interrupt
	SYSCFG_EXTICR4_EXTI13_PC13 = 0x2
	// Select PD13 as the source input for the EXTI13 external interrupt
	SYSCFG_EXTICR4_EXTI13_PD13 = 0x3
	// Select PE13 as the source input for the EXTI13 external interrupt
	SYSCFG_EXTICR4_EXTI13_PE13 = 0x4
	// Position of EXTI12 field.
	SYSCFG_EXTICR4_EXTI12_Pos = 0x0
	// Bit mask of EXTI12 field.
	SYSCFG_EXTICR4_EXTI12_Msk = 0xf
	// Select PA12 as the source input for the EXTI12 external interrupt
	SYSCFG_EXTICR4_EXTI12_PA12 = 0x0
	// Select PB12 as the source input for the EXTI12 external interrupt
	SYSCFG_EXTICR4_EXTI12_PB12 = 0x1
	// Select PC12 as the source input for the EXTI12 external interrupt
	SYSCFG_EXTICR4_EXTI12_PC12 = 0x2
	// Select PD12 as the source input for the EXTI12 external interrupt
	SYSCFG_EXTICR4_EXTI12_PD12 = 0x3
	// Select PE12 as the source input for the EXTI12 external interrupt
	SYSCFG_EXTICR4_EXTI12_PE12 = 0x4

	// COMP1_CSR: Comparator 1 control and status register
	// Position of COMP1LOCK field.
	SYSCFG_COMP1_CSR_COMP1LOCK_Pos = 0x1f
	// Bit mask of COMP1LOCK field.
	SYSCFG_COMP1_CSR_COMP1LOCK_Msk = 0x80000000
	// Bit COMP1LOCK.
	SYSCFG_COMP1_CSR_COMP1LOCK = 0x80000000
	// COMP1_CSR[31:0] for comparator 1 are read/write
	SYSCFG_COMP1_CSR_COMP1LOCK_ReadWrite = 0x0
	// COMP1_CSR[31:0] for comparator 1 are read-only
	SYSCFG_COMP1_CSR_COMP1LOCK_ReadOnly = 0x1
	// Position of COMP1VALUE field.
	SYSCFG_COMP1_CSR_COMP1VALUE_Pos = 0x1e
	// Bit mask of COMP1VALUE field.
	SYSCFG_COMP1_CSR_COMP1VALUE_Msk = 0x40000000
	// Bit COMP1VALUE.
	SYSCFG_COMP1_CSR_COMP1VALUE = 0x40000000
	// Comparator values are not equal
	SYSCFG_COMP1_CSR_COMP1VALUE_NotEqual = 0x0
	// Comparator values are equal
	SYSCFG_COMP1_CSR_COMP1VALUE_Equal = 0x1
	// Position of COMP1POLARITY field.
	SYSCFG_COMP1_CSR_COMP1POLARITY_Pos = 0xf
	// Bit mask of COMP1POLARITY field.
	SYSCFG_COMP1_CSR_COMP1POLARITY_Msk = 0x8000
	// Bit COMP1POLARITY.
	SYSCFG_COMP1_CSR_COMP1POLARITY = 0x8000
	// Comparator 1 output value not inverted
	SYSCFG_COMP1_CSR_COMP1POLARITY_NotInverted = 0x0
	// Comparator 1 output value inverted
	SYSCFG_COMP1_CSR_COMP1POLARITY_Inverted = 0x1
	// Position of COMP1LPTIMIN1 field.
	SYSCFG_COMP1_CSR_COMP1LPTIMIN1_Pos = 0xc
	// Bit mask of COMP1LPTIMIN1 field.
	SYSCFG_COMP1_CSR_COMP1LPTIMIN1_Msk = 0x1000
	// Bit COMP1LPTIMIN1.
	SYSCFG_COMP1_CSR_COMP1LPTIMIN1 = 0x1000
	// Comparator 1 output gated
	SYSCFG_COMP1_CSR_COMP1LPTIMIN1_Gated = 0x0
	// Comparator 1 output sent to LPTIM input 1
	SYSCFG_COMP1_CSR_COMP1LPTIMIN1_NotGated = 0x1
	// Position of COMP1WM field.
	SYSCFG_COMP1_CSR_COMP1WM_Pos = 0x8
	// Bit mask of COMP1WM field.
	SYSCFG_COMP1_CSR_COMP1WM_Msk = 0x100
	// Bit COMP1WM.
	SYSCFG_COMP1_CSR_COMP1WM = 0x100
	// Plus input of comparator 1 connected to PA1
	SYSCFG_COMP1_CSR_COMP1WM_PA1 = 0x0
	// Plus input of comparator 1 shorted with Plus input of comparator 2 (see COMP1_CSR)
	SYSCFG_COMP1_CSR_COMP1WM_Comp2Plus = 0x1
	// Position of COMP1INNSEL field.
	SYSCFG_COMP1_CSR_COMP1INNSEL_Pos = 0x4
	// Bit mask of COMP1INNSEL field.
	SYSCFG_COMP1_CSR_COMP1INNSEL_Msk = 0x30
	// VREFINT
	SYSCFG_COMP1_CSR_COMP1INNSEL_VREFINT = 0x0
	// PA0
	SYSCFG_COMP1_CSR_COMP1INNSEL_PA0 = 0x1
	// PA4
	SYSCFG_COMP1_CSR_COMP1INNSEL_PA4 = 0x2
	// PA5
	SYSCFG_COMP1_CSR_COMP1INNSEL_PA5 = 0x3
	// Position of COMP1EN field.
	SYSCFG_COMP1_CSR_COMP1EN_Pos = 0x0
	// Bit mask of COMP1EN field.
	SYSCFG_COMP1_CSR_COMP1EN_Msk = 0x1
	// Bit COMP1EN.
	SYSCFG_COMP1_CSR_COMP1EN = 0x1
	// Comparator 1 switched OFF
	SYSCFG_COMP1_CSR_COMP1EN_Disabled = 0x0
	// Comparator 1 switched ON
	SYSCFG_COMP1_CSR_COMP1EN_Enabled = 0x1

	// COMP2_CSR: Comparator 2 control and status register
	// Position of COMP2LOCK field.
	SYSCFG_COMP2_CSR_COMP2LOCK_Pos = 0x1f
	// Bit mask of COMP2LOCK field.
	SYSCFG_COMP2_CSR_COMP2LOCK_Msk = 0x80000000
	// Bit COMP2LOCK.
	SYSCFG_COMP2_CSR_COMP2LOCK = 0x80000000
	// COMP2_CSR[31:0] for comparator 2 are read/write
	SYSCFG_COMP2_CSR_COMP2LOCK_ReadWrite = 0x0
	// COMP2_CSR[31:0] for comparator 2 are read-only
	SYSCFG_COMP2_CSR_COMP2LOCK_ReadOnly = 0x1
	// Position of COMP2VALUE field.
	SYSCFG_COMP2_CSR_COMP2VALUE_Pos = 0x14
	// Bit mask of COMP2VALUE field.
	SYSCFG_COMP2_CSR_COMP2VALUE_Msk = 0x100000
	// Bit COMP2VALUE.
	SYSCFG_COMP2_CSR_COMP2VALUE = 0x100000
	// Comparator values are not equal
	SYSCFG_COMP2_CSR_COMP2VALUE_NotEqual = 0x0
	// Comparator values are equal
	SYSCFG_COMP2_CSR_COMP2VALUE_Equal = 0x1
	// Position of COMP2POLARITY field.
	SYSCFG_COMP2_CSR_COMP2POLARITY_Pos = 0xf
	// Bit mask of COMP2POLARITY field.
	SYSCFG_COMP2_CSR_COMP2POLARITY_Msk = 0x8000
	// Bit COMP2POLARITY.
	SYSCFG_COMP2_CSR_COMP2POLARITY = 0x8000
	// Comparator 2 output value not inverted
	SYSCFG_COMP2_CSR_COMP2POLARITY_NotInverted = 0x0
	// Comparator 2 output value inverted
	SYSCFG_COMP2_CSR_COMP2POLARITY_Inverted = 0x1
	// Position of COMP2LPTIMIN1 field.
	SYSCFG_COMP2_CSR_COMP2LPTIMIN1_Pos = 0xd
	// Bit mask of COMP2LPTIMIN1 field.
	SYSCFG_COMP2_CSR_COMP2LPTIMIN1_Msk = 0x2000
	// Bit COMP2LPTIMIN1.
	SYSCFG_COMP2_CSR_COMP2LPTIMIN1 = 0x2000
	// Comparator 2 output gated
	SYSCFG_COMP2_CSR_COMP2LPTIMIN1_Gated = 0x0
	// Comparator 2 output sent to LPTIM input 1
	SYSCFG_COMP2_CSR_COMP2LPTIMIN1_NotGated = 0x1
	// Position of COMP2LPTIMIN2 field.
	SYSCFG_COMP2_CSR_COMP2LPTIMIN2_Pos = 0xc
	// Bit mask of COMP2LPTIMIN2 field.
	SYSCFG_COMP2_CSR_COMP2LPTIMIN2_Msk = 0x1000
	// Bit COMP2LPTIMIN2.
	SYSCFG_COMP2_CSR_COMP2LPTIMIN2 = 0x1000
	// Comparator 2 output gated
	SYSCFG_COMP2_CSR_COMP2LPTIMIN2_Gated = 0x0
	// Comparator 2 output sent to LPTIM input 2
	SYSCFG_COMP2_CSR_COMP2LPTIMIN2_NotGated = 0x1
	// Position of COMP2INPSEL field.
	SYSCFG_COMP2_CSR_COMP2INPSEL_Pos = 0x8
	// Bit mask of COMP2INPSEL field.
	SYSCFG_COMP2_CSR_COMP2INPSEL_Msk = 0x700
	// PA3
	SYSCFG_COMP2_CSR_COMP2INPSEL_PA3 = 0x0
	// PB4
	SYSCFG_COMP2_CSR_COMP2INPSEL_PB4 = 0x1
	// PB5
	SYSCFG_COMP2_CSR_COMP2INPSEL_PB5 = 0x2
	// PB6
	SYSCFG_COMP2_CSR_COMP2INPSEL_PB6 = 0x3
	// PB7
	SYSCFG_COMP2_CSR_COMP2INPSEL_PB7 = 0x4
	// PA7
	SYSCFG_COMP2_CSR_COMP2INPSEL_PA7 = 0x5
	// Position of COMP2INNSEL field.
	SYSCFG_COMP2_CSR_COMP2INNSEL_Pos = 0x4
	// Bit mask of COMP2INNSEL field.
	SYSCFG_COMP2_CSR_COMP2INNSEL_Msk = 0x70
	// VREFINT
	SYSCFG_COMP2_CSR_COMP2INNSEL_VREFINT = 0x0
	// PA2
	SYSCFG_COMP2_CSR_COMP2INNSEL_PA2 = 0x1
	// PA4
	SYSCFG_COMP2_CSR_COMP2INNSEL_PA4 = 0x2
	// PA5
	SYSCFG_COMP2_CSR_COMP2INNSEL_PA5 = 0x3
	// 1/4 VREFINT
	SYSCFG_COMP2_CSR_COMP2INNSEL_VREFINT_Div4 = 0x4
	// 1/2 VREFINT
	SYSCFG_COMP2_CSR_COMP2INNSEL_VREFINT_Div2 = 0x5
	// 3/4 VREFINT
	SYSCFG_COMP2_CSR_COMP2INNSEL_VREFINT_Div3_4 = 0x6
	// PB3
	SYSCFG_COMP2_CSR_COMP2INNSEL_PB3 = 0x7
	// Position of COMP2SPEED field.
	SYSCFG_COMP2_CSR_COMP2SPEED_Pos = 0x3
	// Bit mask of COMP2SPEED field.
	SYSCFG_COMP2_CSR_COMP2SPEED_Msk = 0x8
	// Bit COMP2SPEED.
	SYSCFG_COMP2_CSR_COMP2SPEED = 0x8
	// Slow speed
	SYSCFG_COMP2_CSR_COMP2SPEED_Slow = 0x0
	// Fast speed
	SYSCFG_COMP2_CSR_COMP2SPEED_Fast = 0x1
	// Position of COMP2EN field.
	SYSCFG_COMP2_CSR_COMP2EN_Pos = 0x0
	// Bit mask of COMP2EN field.
	SYSCFG_COMP2_CSR_COMP2EN_Msk = 0x1
	// Bit COMP2EN.
	SYSCFG_COMP2_CSR_COMP2EN = 0x1
	// Comparator 2 switched OFF
	SYSCFG_COMP2_CSR_COMP2EN_Disabled = 0x0
	// Comparator 2 switched ON
	SYSCFG_COMP2_CSR_COMP2EN_Enabled = 0x1

	// CFGR3: SYSCFG configuration register 3
	// Position of VREFINT_RDYF field.
	SYSCFG_CFGR3_VREFINT_RDYF_Pos = 0x1e
	// Bit mask of VREFINT_RDYF field.
	SYSCFG_CFGR3_VREFINT_RDYF_Msk = 0x40000000
	// Bit VREFINT_RDYF.
	SYSCFG_CFGR3_VREFINT_RDYF = 0x40000000
	// VREFINT OFF
	SYSCFG_CFGR3_VREFINT_RDYF_NotReady = 0x0
	// VREFINT ready
	SYSCFG_CFGR3_VREFINT_RDYF_Ready = 0x1
	// Position of ENBUF_SENSOR_ADC field.
	SYSCFG_CFGR3_ENBUF_SENSOR_ADC_Pos = 0x9
	// Bit mask of ENBUF_SENSOR_ADC field.
	SYSCFG_CFGR3_ENBUF_SENSOR_ADC_Msk = 0x200
	// Bit ENBUF_SENSOR_ADC.
	SYSCFG_CFGR3_ENBUF_SENSOR_ADC = 0x200
	// Disables the buffer used to generate VREFINT reference for the temperature sensor
	SYSCFG_CFGR3_ENBUF_SENSOR_ADC_Disabled = 0x0
	// Enables the buffer used to generate VREFINT reference for the temperature sensor
	SYSCFG_CFGR3_ENBUF_SENSOR_ADC_Enabled = 0x1
	// Position of SEL_VREF_OUT field.
	SYSCFG_CFGR3_SEL_VREF_OUT_Pos = 0x4
	// Bit mask of SEL_VREF_OUT field.
	SYSCFG_CFGR3_SEL_VREF_OUT_Msk = 0x30
	// no pad connected
	SYSCFG_CFGR3_SEL_VREF_OUT_NoConnection = 0x0
	// PB0 connected
	SYSCFG_CFGR3_SEL_VREF_OUT_PB0 = 0x1
	// PB1 connected
	SYSCFG_CFGR3_SEL_VREF_OUT_PB1 = 0x2
	// PB0 and PB1 connected
	SYSCFG_CFGR3_SEL_VREF_OUT_Both = 0x3
	// Position of ENREF_HSI48 field.
	SYSCFG_CFGR3_ENREF_HSI48_Pos = 0xd
	// Bit mask of ENREF_HSI48 field.
	SYSCFG_CFGR3_ENREF_HSI48_Msk = 0x2000
	// Bit ENREF_HSI48.
	SYSCFG_CFGR3_ENREF_HSI48 = 0x2000
	// Position of REF_LOCK field.
	SYSCFG_CFGR3_REF_LOCK_Pos = 0x1f
	// Bit mask of REF_LOCK field.
	SYSCFG_CFGR3_REF_LOCK_Msk = 0x80000000
	// Bit REF_LOCK.
	SYSCFG_CFGR3_REF_LOCK = 0x80000000
	// SYSCFG_CFGR3[31:0] bits are read/write
	SYSCFG_CFGR3_REF_LOCK_ReadWrite = 0x0
	// SYSCFG_CFGR3[31:0] bits are read-only
	SYSCFG_CFGR3_REF_LOCK_ReadOnly = 0x1
	// Position of ENBUF_VREFINT_COMP2 field.
	SYSCFG_CFGR3_ENBUF_VREFINT_COMP2_Pos = 0xc
	// Bit mask of ENBUF_VREFINT_COMP2 field.
	SYSCFG_CFGR3_ENBUF_VREFINT_COMP2_Msk = 0x1000
	// Bit ENBUF_VREFINT_COMP2.
	SYSCFG_CFGR3_ENBUF_VREFINT_COMP2 = 0x1000
	// Disables the buffer used to generate VREFINT references for COMP2
	SYSCFG_CFGR3_ENBUF_VREFINT_COMP2_Disabled = 0x0
	// Enables the buffer used to generate VREFINT references for COMP2
	SYSCFG_CFGR3_ENBUF_VREFINT_COMP2_Enabled = 0x1
	// Position of ENBUF_VREFINT_ADC field.
	SYSCFG_CFGR3_ENBUF_VREFINT_ADC_Pos = 0x8
	// Bit mask of ENBUF_VREFINT_ADC field.
	SYSCFG_CFGR3_ENBUF_VREFINT_ADC_Msk = 0x100
	// Bit ENBUF_VREFINT_ADC.
	SYSCFG_CFGR3_ENBUF_VREFINT_ADC = 0x100
	// Disables the buffer used to generate VREFINT reference for the ADC
	SYSCFG_CFGR3_ENBUF_VREFINT_ADC_Disabled = 0x0
	// Enables the buffer used to generate VREFINT reference for the ADC
	SYSCFG_CFGR3_ENBUF_VREFINT_ADC_Enabled = 0x1
	// Position of EN_VREFINT field.
	SYSCFG_CFGR3_EN_VREFINT_Pos = 0x0
	// Bit mask of EN_VREFINT field.
	SYSCFG_CFGR3_EN_VREFINT_Msk = 0x1
	// Bit EN_VREFINT.
	SYSCFG_CFGR3_EN_VREFINT = 0x1
	// VREFINT voltage disabled in low-power mode (if ULP=1) and scaler for COMP2 disabled
	SYSCFG_CFGR3_EN_VREFINT_Disabled = 0x0
	// VREFINT voltage enabled in low-power mode and scaler for COMP2 enabled
	SYSCFG_CFGR3_EN_VREFINT_Enabled = 0x1
)

// Bitfields for SPI1: Serial peripheral interface
const (
	// CR1: control register 1
	// Position of BIDIMODE field.
	SPI_CR1_BIDIMODE_Pos = 0xf
	// Bit mask of BIDIMODE field.
	SPI_CR1_BIDIMODE_Msk = 0x8000
	// Bit BIDIMODE.
	SPI_CR1_BIDIMODE = 0x8000
	// 2-line unidirectional data mode selected
	SPI_CR1_BIDIMODE_Unidirectional = 0x0
	// 1-line bidirectional data mode selected
	SPI_CR1_BIDIMODE_Bidirectional = 0x1
	// Position of BIDIOE field.
	SPI_CR1_BIDIOE_Pos = 0xe
	// Bit mask of BIDIOE field.
	SPI_CR1_BIDIOE_Msk = 0x4000
	// Bit BIDIOE.
	SPI_CR1_BIDIOE = 0x4000
	// Output disabled (receive-only mode)
	SPI_CR1_BIDIOE_OutputDisabled = 0x0
	// Output enabled (transmit-only mode)
	SPI_CR1_BIDIOE_OutputEnabled = 0x1
	// Position of CRCEN field.
	SPI_CR1_CRCEN_Pos = 0xd
	// Bit mask of CRCEN field.
	SPI_CR1_CRCEN_Msk = 0x2000
	// Bit CRCEN.
	SPI_CR1_CRCEN = 0x2000
	// CRC calculation disabled
	SPI_CR1_CRCEN_Disabled = 0x0
	// CRC calculation enabled
	SPI_CR1_CRCEN_Enabled = 0x1
	// Position of CRCNEXT field.
	SPI_CR1_CRCNEXT_Pos = 0xc
	// Bit mask of CRCNEXT field.
	SPI_CR1_CRCNEXT_Msk = 0x1000
	// Bit CRCNEXT.
	SPI_CR1_CRCNEXT = 0x1000
	// Next transmit value is from Tx buffer
	SPI_CR1_CRCNEXT_TxBuffer = 0x0
	// Next transmit value is from Tx CRC register
	SPI_CR1_CRCNEXT_CRC = 0x1
	// Position of DFF field.
	SPI_CR1_DFF_Pos = 0xb
	// Bit mask of DFF field.
	SPI_CR1_DFF_Msk = 0x800
	// Bit DFF.
	SPI_CR1_DFF = 0x800
	// 8-bit data frame format is selected for transmission/reception
	SPI_CR1_DFF_EightBit = 0x0
	// 16-bit data frame format is selected for transmission/reception
	SPI_CR1_DFF_SixteenBit = 0x1
	// Position of RXONLY field.
	SPI_CR1_RXONLY_Pos = 0xa
	// Bit mask of RXONLY field.
	SPI_CR1_RXONLY_Msk = 0x400
	// Bit RXONLY.
	SPI_CR1_RXONLY = 0x400
	// Full duplex (Transmit and receive)
	SPI_CR1_RXONLY_FullDuplex = 0x0
	// Output disabled (Receive-only mode)
	SPI_CR1_RXONLY_OutputDisabled = 0x1
	// Position of SSM field.
	SPI_CR1_SSM_Pos = 0x9
	// Bit mask of SSM field.
	SPI_CR1_SSM_Msk = 0x200
	// Bit SSM.
	SPI_CR1_SSM = 0x200
	// Software slave management disabled
	SPI_CR1_SSM_Disabled = 0x0
	// Software slave management enabled
	SPI_CR1_SSM_Enabled = 0x1
	// Position of SSI field.
	SPI_CR1_SSI_Pos = 0x8
	// Bit mask of SSI field.
	SPI_CR1_SSI_Msk = 0x100
	// Bit SSI.
	SPI_CR1_SSI = 0x100
	// 0 is forced onto the NSS pin and the I/O value of the NSS pin is ignored
	SPI_CR1_SSI_SlaveSelected = 0x0
	// 1 is forced onto the NSS pin and the I/O value of the NSS pin is ignored
	SPI_CR1_SSI_SlaveNotSelected = 0x1
	// Position of LSBFIRST field.
	SPI_CR1_LSBFIRST_Pos = 0x7
	// Bit mask of LSBFIRST field.
	SPI_CR1_LSBFIRST_Msk = 0x80
	// Bit LSBFIRST.
	SPI_CR1_LSBFIRST = 0x80
	// Data is transmitted/received with the MSB first
	SPI_CR1_LSBFIRST_MSBFirst = 0x0
	// Data is transmitted/received with the LSB first
	SPI_CR1_LSBFIRST_LSBFirst = 0x1
	// Position of SPE field.
	SPI_CR1_SPE_Pos = 0x6
	// Bit mask of SPE field.
	SPI_CR1_SPE_Msk = 0x40
	// Bit SPE.
	SPI_CR1_SPE = 0x40
	// Peripheral disabled
	SPI_CR1_SPE_Disabled = 0x0
	// Peripheral enabled
	SPI_CR1_SPE_Enabled = 0x1
	// Position of BR field.
	SPI_CR1_BR_Pos = 0x3
	// Bit mask of BR field.
	SPI_CR1_BR_Msk = 0x38
	// f_PCLK / 2
	SPI_CR1_BR_Div2 = 0x0
	// f_PCLK / 4
	SPI_CR1_BR_Div4 = 0x1
	// f_PCLK / 8
	SPI_CR1_BR_Div8 = 0x2
	// f_PCLK / 16
	SPI_CR1_BR_Div16 = 0x3
	// f_PCLK / 32
	SPI_CR1_BR_Div32 = 0x4
	// f_PCLK / 64
	SPI_CR1_BR_Div64 = 0x5
	// f_PCLK / 128
	SPI_CR1_BR_Div128 = 0x6
	// f_PCLK / 256
	SPI_CR1_BR_Div256 = 0x7
	// Position of MSTR field.
	SPI_CR1_MSTR_Pos = 0x2
	// Bit mask of MSTR field.
	SPI_CR1_MSTR_Msk = 0x4
	// Bit MSTR.
	SPI_CR1_MSTR = 0x4
	// Slave configuration
	SPI_CR1_MSTR_Slave = 0x0
	// Master configuration
	SPI_CR1_MSTR_Master = 0x1
	// Position of CPOL field.
	SPI_CR1_CPOL_Pos = 0x1
	// Bit mask of CPOL field.
	SPI_CR1_CPOL_Msk = 0x2
	// Bit CPOL.
	SPI_CR1_CPOL = 0x2
	// CK to 0 when idle
	SPI_CR1_CPOL_IdleLow = 0x0
	// CK to 1 when idle
	SPI_CR1_CPOL_IdleHigh = 0x1
	// Position of CPHA field.
	SPI_CR1_CPHA_Pos = 0x0
	// Bit mask of CPHA field.
	SPI_CR1_CPHA_Msk = 0x1
	// Bit CPHA.
	SPI_CR1_CPHA = 0x1
	// The first clock transition is the first data capture edge
	SPI_CR1_CPHA_FirstEdge = 0x0
	// The second clock transition is the first data capture edge
	SPI_CR1_CPHA_SecondEdge = 0x1

	// CR2: control register 2
	// Position of RXDMAEN field.
	SPI_CR2_RXDMAEN_Pos = 0x0
	// Bit mask of RXDMAEN field.
	SPI_CR2_RXDMAEN_Msk = 0x1
	// Bit RXDMAEN.
	SPI_CR2_RXDMAEN = 0x1
	// Rx buffer DMA disabled
	SPI_CR2_RXDMAEN_Disabled = 0x0
	// Rx buffer DMA enabled
	SPI_CR2_RXDMAEN_Enabled = 0x1
	// Position of TXDMAEN field.
	SPI_CR2_TXDMAEN_Pos = 0x1
	// Bit mask of TXDMAEN field.
	SPI_CR2_TXDMAEN_Msk = 0x2
	// Bit TXDMAEN.
	SPI_CR2_TXDMAEN = 0x2
	// Tx buffer DMA disabled
	SPI_CR2_TXDMAEN_Disabled = 0x0
	// Tx buffer DMA enabled
	SPI_CR2_TXDMAEN_Enabled = 0x1
	// Position of SSOE field.
	SPI_CR2_SSOE_Pos = 0x2
	// Bit mask of SSOE field.
	SPI_CR2_SSOE_Msk = 0x4
	// Bit SSOE.
	SPI_CR2_SSOE = 0x4
	// SS output is disabled in master mode
	SPI_CR2_SSOE_Disabled = 0x0
	// SS output is enabled in master mode
	SPI_CR2_SSOE_Enabled = 0x1
	// Position of FRF field.
	SPI_CR2_FRF_Pos = 0x4
	// Bit mask of FRF field.
	SPI_CR2_FRF_Msk = 0x10
	// Bit FRF.
	SPI_CR2_FRF = 0x10
	// Position of ERRIE field.
	SPI_CR2_ERRIE_Pos = 0x5
	// Bit mask of ERRIE field.
	SPI_CR2_ERRIE_Msk = 0x20
	// Bit ERRIE.
	SPI_CR2_ERRIE = 0x20
	// Error interrupt masked
	SPI_CR2_ERRIE_Masked = 0x0
	// Error interrupt not masked
	SPI_CR2_ERRIE_NotMasked = 0x1
	// Position of RXNEIE field.
	SPI_CR2_RXNEIE_Pos = 0x6
	// Bit mask of RXNEIE field.
	SPI_CR2_RXNEIE_Msk = 0x40
	// Bit RXNEIE.
	SPI_CR2_RXNEIE = 0x40
	// RXE interrupt masked
	SPI_CR2_RXNEIE_Masked = 0x0
	// RXE interrupt not masked
	SPI_CR2_RXNEIE_NotMasked = 0x1
	// Position of TXEIE field.
	SPI_CR2_TXEIE_Pos = 0x7
	// Bit mask of TXEIE field.
	SPI_CR2_TXEIE_Msk = 0x80
	// Bit TXEIE.
	SPI_CR2_TXEIE = 0x80
	// TXE interrupt masked
	SPI_CR2_TXEIE_Masked = 0x0
	// TXE interrupt not masked
	SPI_CR2_TXEIE_NotMasked = 0x1

	// SR: status register
	// Position of RXNE field.
	SPI_SR_RXNE_Pos = 0x0
	// Bit mask of RXNE field.
	SPI_SR_RXNE_Msk = 0x1
	// Bit RXNE.
	SPI_SR_RXNE = 0x1
	// Rx buffer empty
	SPI_SR_RXNE_Empty = 0x0
	// Rx buffer not empty
	SPI_SR_RXNE_NotEmpty = 0x1
	// Position of TXE field.
	SPI_SR_TXE_Pos = 0x1
	// Bit mask of TXE field.
	SPI_SR_TXE_Msk = 0x2
	// Bit TXE.
	SPI_SR_TXE = 0x2
	// Tx buffer not empty
	SPI_SR_TXE_NotEmpty = 0x0
	// Tx buffer empty
	SPI_SR_TXE_Empty = 0x1
	// Position of CHSIDE field.
	SPI_SR_CHSIDE_Pos = 0x2
	// Bit mask of CHSIDE field.
	SPI_SR_CHSIDE_Msk = 0x4
	// Bit CHSIDE.
	SPI_SR_CHSIDE = 0x4
	// Position of UDR field.
	SPI_SR_UDR_Pos = 0x3
	// Bit mask of UDR field.
	SPI_SR_UDR_Msk = 0x8
	// Bit UDR.
	SPI_SR_UDR = 0x8
	// Position of CRCERR field.
	SPI_SR_CRCERR_Pos = 0x4
	// Bit mask of CRCERR field.
	SPI_SR_CRCERR_Msk = 0x10
	// Bit CRCERR.
	SPI_SR_CRCERR = 0x10
	// CRC value received matches the SPIx_RXCRCR value
	SPI_SR_CRCERR_Match = 0x0
	// CRC value received does not match the SPIx_RXCRCR value
	SPI_SR_CRCERR_NoMatch = 0x1
	// Position of MODF field.
	SPI_SR_MODF_Pos = 0x5
	// Bit mask of MODF field.
	SPI_SR_MODF_Msk = 0x20
	// Bit MODF.
	SPI_SR_MODF = 0x20
	// No mode fault occurred
	SPI_SR_MODF_NoFault = 0x0
	// Mode fault occurred
	SPI_SR_MODF_Fault = 0x1
	// Position of OVR field.
	SPI_SR_OVR_Pos = 0x6
	// Bit mask of OVR field.
	SPI_SR_OVR_Msk = 0x40
	// Bit OVR.
	SPI_SR_OVR = 0x40
	// No overrun occurred
	SPI_SR_OVR_NoOverrun = 0x0
	// Overrun occurred
	SPI_SR_OVR_Overrun = 0x1
	// Position of BSY field.
	SPI_SR_BSY_Pos = 0x7
	// Bit mask of BSY field.
	SPI_SR_BSY_Msk = 0x80
	// Bit BSY.
	SPI_SR_BSY = 0x80
	// SPI not busy
	SPI_SR_BSY_NotBusy = 0x0
	// SPI busy
	SPI_SR_BSY_Busy = 0x1
	// Position of FRE field.
	SPI_SR_FRE_Pos = 0x8
	// Bit mask of FRE field.
	SPI_SR_FRE_Msk = 0x100
	// Bit FRE.
	SPI_SR_FRE = 0x100

	// DR: data register
	// Position of DR field.
	SPI_DR_DR_Pos = 0x0
	// Bit mask of DR field.
	SPI_DR_DR_Msk = 0xffff

	// CRCPR: CRC polynomial register
	// Position of CRCPOLY field.
	SPI_CRCPR_CRCPOLY_Pos = 0x0
	// Bit mask of CRCPOLY field.
	SPI_CRCPR_CRCPOLY_Msk = 0xffff

	// RXCRCR: RX CRC register
	// Position of RxCRC field.
	SPI_RXCRCR_RxCRC_Pos = 0x0
	// Bit mask of RxCRC field.
	SPI_RXCRCR_RxCRC_Msk = 0xffff

	// TXCRCR: TX CRC register
	// Position of TxCRC field.
	SPI_TXCRCR_TxCRC_Pos = 0x0
	// Bit mask of TxCRC field.
	SPI_TXCRCR_TxCRC_Msk = 0xffff

	// I2SCFGR: I2S configuration register
	// Position of I2SMOD field.
	SPI_I2SCFGR_I2SMOD_Pos = 0xb
	// Bit mask of I2SMOD field.
	SPI_I2SCFGR_I2SMOD_Msk = 0x800
	// Bit I2SMOD.
	SPI_I2SCFGR_I2SMOD = 0x800
	// Position of I2SE field.
	SPI_I2SCFGR_I2SE_Pos = 0xa
	// Bit mask of I2SE field.
	SPI_I2SCFGR_I2SE_Msk = 0x400
	// Bit I2SE.
	SPI_I2SCFGR_I2SE = 0x400
	// Position of I2SCFG field.
	SPI_I2SCFGR_I2SCFG_Pos = 0x8
	// Bit mask of I2SCFG field.
	SPI_I2SCFGR_I2SCFG_Msk = 0x300
	// Position of PCMSYNC field.
	SPI_I2SCFGR_PCMSYNC_Pos = 0x7
	// Bit mask of PCMSYNC field.
	SPI_I2SCFGR_PCMSYNC_Msk = 0x80
	// Bit PCMSYNC.
	SPI_I2SCFGR_PCMSYNC = 0x80
	// Position of I2SSTD field.
	SPI_I2SCFGR_I2SSTD_Pos = 0x4
	// Bit mask of I2SSTD field.
	SPI_I2SCFGR_I2SSTD_Msk = 0x30
	// Position of CKPOL field.
	SPI_I2SCFGR_CKPOL_Pos = 0x3
	// Bit mask of CKPOL field.
	SPI_I2SCFGR_CKPOL_Msk = 0x8
	// Bit CKPOL.
	SPI_I2SCFGR_CKPOL = 0x8
	// Position of DATLEN field.
	SPI_I2SCFGR_DATLEN_Pos = 0x1
	// Bit mask of DATLEN field.
	SPI_I2SCFGR_DATLEN_Msk = 0x6
	// Position of CHLEN field.
	SPI_I2SCFGR_CHLEN_Pos = 0x0
	// Bit mask of CHLEN field.
	SPI_I2SCFGR_CHLEN_Msk = 0x1
	// Bit CHLEN.
	SPI_I2SCFGR_CHLEN = 0x1

	// I2SPR: I2S prescaler register
	// Position of MCKOE field.
	SPI_I2SPR_MCKOE_Pos = 0x9
	// Bit mask of MCKOE field.
	SPI_I2SPR_MCKOE_Msk = 0x200
	// Bit MCKOE.
	SPI_I2SPR_MCKOE = 0x200
	// Position of ODD field.
	SPI_I2SPR_ODD_Pos = 0x8
	// Bit mask of ODD field.
	SPI_I2SPR_ODD_Msk = 0x100
	// Bit ODD.
	SPI_I2SPR_ODD = 0x100
	// Position of I2SDIV field.
	SPI_I2SPR_I2SDIV_Pos = 0x0
	// Bit mask of I2SDIV field.
	SPI_I2SPR_I2SDIV_Msk = 0xff
)

// Bitfields for I2C1: Inter-integrated circuit
const (
	// CR1: Control register 1
	// Position of PE field.
	I2C_CR1_PE_Pos = 0x0
	// Bit mask of PE field.
	I2C_CR1_PE_Msk = 0x1
	// Bit PE.
	I2C_CR1_PE = 0x1
	// Peripheral disabled
	I2C_CR1_PE_Disabled = 0x0
	// Peripheral enabled
	I2C_CR1_PE_Enabled = 0x1
	// Position of TXIE field.
	I2C_CR1_TXIE_Pos = 0x1
	// Bit mask of TXIE field.
	I2C_CR1_TXIE_Msk = 0x2
	// Bit TXIE.
	I2C_CR1_TXIE = 0x2
	// Transmit (TXIS) interrupt disabled
	I2C_CR1_TXIE_Disabled = 0x0
	// Transmit (TXIS) interrupt enabled
	I2C_CR1_TXIE_Enabled = 0x1
	// Position of RXIE field.
	I2C_CR1_RXIE_Pos = 0x2
	// Bit mask of RXIE field.
	I2C_CR1_RXIE_Msk = 0x4
	// Bit RXIE.
	I2C_CR1_RXIE = 0x4
	// Receive (RXNE) interrupt disabled
	I2C_CR1_RXIE_Disabled = 0x0
	// Receive (RXNE) interrupt enabled
	I2C_CR1_RXIE_Enabled = 0x1
	// Position of ADDRIE field.
	I2C_CR1_ADDRIE_Pos = 0x3
	// Bit mask of ADDRIE field.
	I2C_CR1_ADDRIE_Msk = 0x8
	// Bit ADDRIE.
	I2C_CR1_ADDRIE = 0x8
	// Address match (ADDR) interrupts disabled
	I2C_CR1_ADDRIE_Disabled = 0x0
	// Address match (ADDR) interrupts enabled
	I2C_CR1_ADDRIE_Enabled = 0x1
	// Position of NACKIE field.
	I2C_CR1_NACKIE_Pos = 0x4
	// Bit mask of NACKIE field.
	I2C_CR1_NACKIE_Msk = 0x10
	// Bit NACKIE.
	I2C_CR1_NACKIE = 0x10
	// Not acknowledge (NACKF) received interrupts disabled
	I2C_CR1_NACKIE_Disabled = 0x0
	// Not acknowledge (NACKF) received interrupts enabled
	I2C_CR1_NACKIE_Enabled = 0x1
	// Position of STOPIE field.
	I2C_CR1_STOPIE_Pos = 0x5
	// Bit mask of STOPIE field.
	I2C_CR1_STOPIE_Msk = 0x20
	// Bit STOPIE.
	I2C_CR1_STOPIE = 0x20
	// Stop detection (STOPF) interrupt disabled
	I2C_CR1_STOPIE_Disabled = 0x0
	// Stop detection (STOPF) interrupt enabled
	I2C_CR1_STOPIE_Enabled = 0x1
	// Position of TCIE field.
	I2C_CR1_TCIE_Pos = 0x6
	// Bit mask of TCIE field.
	I2C_CR1_TCIE_Msk = 0x40
	// Bit TCIE.
	I2C_CR1_TCIE = 0x40
	// Transfer Complete interrupt disabled
	I2C_CR1_TCIE_Disabled = 0x0
	// Transfer Complete interrupt enabled
	I2C_CR1_TCIE_Enabled = 0x1
	// Position of ERRIE field.
	I2C_CR1_ERRIE_Pos = 0x7
	// Bit mask of ERRIE field.
	I2C_CR1_ERRIE_Msk = 0x80
	// Bit ERRIE.
	I2C_CR1_ERRIE = 0x80
	// Error detection interrupts disabled
	I2C_CR1_ERRIE_Disabled = 0x0
	// Error detection interrupts enabled
	I2C_CR1_ERRIE_Enabled = 0x1
	// Position of DNF field.
	I2C_CR1_DNF_Pos = 0x8
	// Bit mask of DNF field.
	I2C_CR1_DNF_Msk = 0xf00
	// Digital filter disabled
	I2C_CR1_DNF_NoFilter = 0x0
	// Digital filter enabled and filtering capability up to 1 tI2CCLK
	I2C_CR1_DNF_Filter1 = 0x1
	// Digital filter enabled and filtering capability up to 2 tI2CCLK
	I2C_CR1_DNF_Filter2 = 0x2
	// Digital filter enabled and filtering capability up to 3 tI2CCLK
	I2C_CR1_DNF_Filter3 = 0x3
	// Digital filter enabled and filtering capability up to 4 tI2CCLK
	I2C_CR1_DNF_Filter4 = 0x4
	// Digital filter enabled and filtering capability up to 5 tI2CCLK
	I2C_CR1_DNF_Filter5 = 0x5
	// Digital filter enabled and filtering capability up to 6 tI2CCLK
	I2C_CR1_DNF_Filter6 = 0x6
	// Digital filter enabled and filtering capability up to 7 tI2CCLK
	I2C_CR1_DNF_Filter7 = 0x7
	// Digital filter enabled and filtering capability up to 8 tI2CCLK
	I2C_CR1_DNF_Filter8 = 0x8
	// Digital filter enabled and filtering capability up to 9 tI2CCLK
	I2C_CR1_DNF_Filter9 = 0x9
	// Digital filter enabled and filtering capability up to 10 tI2CCLK
	I2C_CR1_DNF_Filter10 = 0xa
	// Digital filter enabled and filtering capability up to 11 tI2CCLK
	I2C_CR1_DNF_Filter11 = 0xb
	// Digital filter enabled and filtering capability up to 12 tI2CCLK
	I2C_CR1_DNF_Filter12 = 0xc
	// Digital filter enabled and filtering capability up to 13 tI2CCLK
	I2C_CR1_DNF_Filter13 = 0xd
	// Digital filter enabled and filtering capability up to 14 tI2CCLK
	I2C_CR1_DNF_Filter14 = 0xe
	// Digital filter enabled and filtering capability up to 15 tI2CCLK
	I2C_CR1_DNF_Filter15 = 0xf
	// Position of ANFOFF field.
	I2C_CR1_ANFOFF_Pos = 0xc
	// Bit mask of ANFOFF field.
	I2C_CR1_ANFOFF_Msk = 0x1000
	// Bit ANFOFF.
	I2C_CR1_ANFOFF = 0x1000
	// Analog noise filter enabled
	I2C_CR1_ANFOFF_Enabled = 0x0
	// Analog noise filter disabled
	I2C_CR1_ANFOFF_Disabled = 0x1
	// Position of TXDMAEN field.
	I2C_CR1_TXDMAEN_Pos = 0xe
	// Bit mask of TXDMAEN field.
	I2C_CR1_TXDMAEN_Msk = 0x4000
	// Bit TXDMAEN.
	I2C_CR1_TXDMAEN = 0x4000
	// DMA mode disabled for transmission
	I2C_CR1_TXDMAEN_Disabled = 0x0
	// DMA mode enabled for transmission
	I2C_CR1_TXDMAEN_Enabled = 0x1
	// Position of RXDMAEN field.
	I2C_CR1_RXDMAEN_Pos = 0xf
	// Bit mask of RXDMAEN field.
	I2C_CR1_RXDMAEN_Msk = 0x8000
	// Bit RXDMAEN.
	I2C_CR1_RXDMAEN = 0x8000
	// DMA mode disabled for reception
	I2C_CR1_RXDMAEN_Disabled = 0x0
	// DMA mode enabled for reception
	I2C_CR1_RXDMAEN_Enabled = 0x1
	// Position of SBC field.
	I2C_CR1_SBC_Pos = 0x10
	// Bit mask of SBC field.
	I2C_CR1_SBC_Msk = 0x10000
	// Bit SBC.
	I2C_CR1_SBC = 0x10000
	// Slave byte control disabled
	I2C_CR1_SBC_Disabled = 0x0
	// Slave byte control enabled
	I2C_CR1_SBC_Enabled = 0x1
	// Position of NOSTRETCH field.
	I2C_CR1_NOSTRETCH_Pos = 0x11
	// Bit mask of NOSTRETCH field.
	I2C_CR1_NOSTRETCH_Msk = 0x20000
	// Bit NOSTRETCH.
	I2C_CR1_NOSTRETCH = 0x20000
	// Clock stretching enabled
	I2C_CR1_NOSTRETCH_Enabled = 0x0
	// Clock stretching disabled
	I2C_CR1_NOSTRETCH_Disabled = 0x1
	// Position of WUPEN field.
	I2C_CR1_WUPEN_Pos = 0x12
	// Bit mask of WUPEN field.
	I2C_CR1_WUPEN_Msk = 0x40000
	// Bit WUPEN.
	I2C_CR1_WUPEN = 0x40000
	// Wakeup from Stop mode disabled
	I2C_CR1_WUPEN_Disabled = 0x0
	// Wakeup from Stop mode enabled
	I2C_CR1_WUPEN_Enabled = 0x1
	// Position of GCEN field.
	I2C_CR1_GCEN_Pos = 0x13
	// Bit mask of GCEN field.
	I2C_CR1_GCEN_Msk = 0x80000
	// Bit GCEN.
	I2C_CR1_GCEN = 0x80000
	// General call disabled. Address 0b00000000 is NACKed
	I2C_CR1_GCEN_Disabled = 0x0
	// General call enabled. Address 0b00000000 is ACKed
	I2C_CR1_GCEN_Enabled = 0x1
	// Position of SMBHEN field.
	I2C_CR1_SMBHEN_Pos = 0x14
	// Bit mask of SMBHEN field.
	I2C_CR1_SMBHEN_Msk = 0x100000
	// Bit SMBHEN.
	I2C_CR1_SMBHEN = 0x100000
	// Host address disabled. Address 0b0001000x is NACKed
	I2C_CR1_SMBHEN_Disabled = 0x0
	// Host address enabled. Address 0b0001000x is ACKed
	I2C_CR1_SMBHEN_Enabled = 0x1
	// Position of SMBDEN field.
	I2C_CR1_SMBDEN_Pos = 0x15
	// Bit mask of SMBDEN field.
	I2C_CR1_SMBDEN_Msk = 0x200000
	// Bit SMBDEN.
	I2C_CR1_SMBDEN = 0x200000
	// Device default address disabled. Address 0b1100001x is NACKed
	I2C_CR1_SMBDEN_Disabled = 0x0
	// Device default address enabled. Address 0b1100001x is ACKed
	I2C_CR1_SMBDEN_Enabled = 0x1
	// Position of ALERTEN field.
	I2C_CR1_ALERTEN_Pos = 0x16
	// Bit mask of ALERTEN field.
	I2C_CR1_ALERTEN_Msk = 0x400000
	// Bit ALERTEN.
	I2C_CR1_ALERTEN = 0x400000
	// In device mode (SMBHEN=Disabled) Releases SMBA pin high and Alert Response Address Header disabled (0001100x) followed by NACK. In host mode (SMBHEN=Enabled) SMBus Alert pin (SMBA) not supported
	I2C_CR1_ALERTEN_Disabled = 0x0
	// In device mode (SMBHEN=Disabled) Drives SMBA pin low and Alert Response Address Header enabled (0001100x) followed by ACK.In host mode (SMBHEN=Enabled) SMBus Alert pin (SMBA) supported
	I2C_CR1_ALERTEN_Enabled = 0x1
	// Position of PECEN field.
	I2C_CR1_PECEN_Pos = 0x17
	// Bit mask of PECEN field.
	I2C_CR1_PECEN_Msk = 0x800000
	// Bit PECEN.
	I2C_CR1_PECEN = 0x800000
	// PEC calculation disabled
	I2C_CR1_PECEN_Disabled = 0x0
	// PEC calculation enabled
	I2C_CR1_PECEN_Enabled = 0x1

	// CR2: Control register 2
	// Position of PECBYTE field.
	I2C_CR2_PECBYTE_Pos = 0x1a
	// Bit mask of PECBYTE field.
	I2C_CR2_PECBYTE_Msk = 0x4000000
	// Bit PECBYTE.
	I2C_CR2_PECBYTE = 0x4000000
	// No PEC transfer
	I2C_CR2_PECBYTE_NoPec = 0x0
	// PEC transmission/reception is requested
	I2C_CR2_PECBYTE_Pec = 0x1
	// Position of AUTOEND field.
	I2C_CR2_AUTOEND_Pos = 0x19
	// Bit mask of AUTOEND field.
	I2C_CR2_AUTOEND_Msk = 0x2000000
	// Bit AUTOEND.
	I2C_CR2_AUTOEND = 0x2000000
	// Software end mode: TC flag is set when NBYTES data are transferred, stretching SCL low
	I2C_CR2_AUTOEND_Software = 0x0
	// Automatic end mode: a STOP condition is automatically sent when NBYTES data are transferred
	I2C_CR2_AUTOEND_Automatic = 0x1
	// Position of RELOAD field.
	I2C_CR2_RELOAD_Pos = 0x18
	// Bit mask of RELOAD field.
	I2C_CR2_RELOAD_Msk = 0x1000000
	// Bit RELOAD.
	I2C_CR2_RELOAD = 0x1000000
	// The transfer is completed after the NBYTES data transfer (STOP or RESTART will follow)
	I2C_CR2_RELOAD_Completed = 0x0
	// The transfer is not completed after the NBYTES data transfer (NBYTES will be reloaded)
	I2C_CR2_RELOAD_NotCompleted = 0x1
	// Position of NBYTES field.
	I2C_CR2_NBYTES_Pos = 0x10
	// Bit mask of NBYTES field.
	I2C_CR2_NBYTES_Msk = 0xff0000
	// Position of NACK field.
	I2C_CR2_NACK_Pos = 0xf
	// Bit mask of NACK field.
	I2C_CR2_NACK_Msk = 0x8000
	// Bit NACK.
	I2C_CR2_NACK = 0x8000
	// an ACK is sent after current received byte
	I2C_CR2_NACK_Ack = 0x0
	// a NACK is sent after current received byte
	I2C_CR2_NACK_Nack = 0x1
	// Position of STOP field.
	I2C_CR2_STOP_Pos = 0xe
	// Bit mask of STOP field.
	I2C_CR2_STOP_Msk = 0x4000
	// Bit STOP.
	I2C_CR2_STOP = 0x4000
	// No Stop generation
	I2C_CR2_STOP_NoStop = 0x0
	// Stop generation after current byte transfer
	I2C_CR2_STOP_Stop = 0x1
	// Position of START field.
	I2C_CR2_START_Pos = 0xd
	// Bit mask of START field.
	I2C_CR2_START_Msk = 0x2000
	// Bit START.
	I2C_CR2_START = 0x2000
	// No Start generation
	I2C_CR2_START_NoStart = 0x0
	// Restart/Start generation
	I2C_CR2_START_Start = 0x1
	// Position of HEAD10R field.
	I2C_CR2_HEAD10R_Pos = 0xc
	// Bit mask of HEAD10R field.
	I2C_CR2_HEAD10R_Msk = 0x1000
	// Bit HEAD10R.
	I2C_CR2_HEAD10R = 0x1000
	// The master sends the complete 10 bit slave address read sequence
	I2C_CR2_HEAD10R_Complete = 0x0
	// The master only sends the 1st 7 bits of the 10 bit address, followed by Read direction
	I2C_CR2_HEAD10R_Partial = 0x1
	// Position of ADD10 field.
	I2C_CR2_ADD10_Pos = 0xb
	// Bit mask of ADD10 field.
	I2C_CR2_ADD10_Msk = 0x800
	// Bit ADD10.
	I2C_CR2_ADD10 = 0x800
	// The master operates in 7-bit addressing mode
	I2C_CR2_ADD10_Bit7 = 0x0
	// The master operates in 10-bit addressing mode
	I2C_CR2_ADD10_Bit10 = 0x1
	// Position of RD_WRN field.
	I2C_CR2_RD_WRN_Pos = 0xa
	// Bit mask of RD_WRN field.
	I2C_CR2_RD_WRN_Msk = 0x400
	// Bit RD_WRN.
	I2C_CR2_RD_WRN = 0x400
	// Master requests a write transfer
	I2C_CR2_RD_WRN_Write = 0x0
	// Master requests a read transfer
	I2C_CR2_RD_WRN_Read = 0x1
	// Position of SADD field.
	I2C_CR2_SADD_Pos = 0x0
	// Bit mask of SADD field.
	I2C_CR2_SADD_Msk = 0x3ff

	// OAR1: Own address register 1
	// Position of OA1 field.
	I2C_OAR1_OA1_Pos = 0x0
	// Bit mask of OA1 field.
	I2C_OAR1_OA1_Msk = 0x3ff
	// Position of OA1MODE field.
	I2C_OAR1_OA1MODE_Pos = 0xa
	// Bit mask of OA1MODE field.
	I2C_OAR1_OA1MODE_Msk = 0x400
	// Bit OA1MODE.
	I2C_OAR1_OA1MODE = 0x400
	// Own address 1 is a 7-bit address
	I2C_OAR1_OA1MODE_Bit7 = 0x0
	// Own address 1 is a 10-bit address
	I2C_OAR1_OA1MODE_Bit10 = 0x1
	// Position of OA1EN field.
	I2C_OAR1_OA1EN_Pos = 0xf
	// Bit mask of OA1EN field.
	I2C_OAR1_OA1EN_Msk = 0x8000
	// Bit OA1EN.
	I2C_OAR1_OA1EN = 0x8000
	// Own address 1 disabled. The received slave address OA1 is NACKed
	I2C_OAR1_OA1EN_Disabled = 0x0
	// Own address 1 enabled. The received slave address OA1 is ACKed
	I2C_OAR1_OA1EN_Enabled = 0x1

	// OAR2: Own address register 2
	// Position of OA2 field.
	I2C_OAR2_OA2_Pos = 0x1
	// Bit mask of OA2 field.
	I2C_OAR2_OA2_Msk = 0xfe
	// Position of OA2MSK field.
	I2C_OAR2_OA2MSK_Pos = 0x8
	// Bit mask of OA2MSK field.
	I2C_OAR2_OA2MSK_Msk = 0x700
	// No mask
	I2C_OAR2_OA2MSK_NoMask = 0x0
	// OA2[1] is masked and don’t care. Only OA2[7:2] are compared
	I2C_OAR2_OA2MSK_Mask1 = 0x1
	// OA2[2:1] are masked and don’t care. Only OA2[7:3] are compared
	I2C_OAR2_OA2MSK_Mask2 = 0x2
	// OA2[3:1] are masked and don’t care. Only OA2[7:4] are compared
	I2C_OAR2_OA2MSK_Mask3 = 0x3
	// OA2[4:1] are masked and don’t care. Only OA2[7:5] are compared
	I2C_OAR2_OA2MSK_Mask4 = 0x4
	// OA2[5:1] are masked and don’t care. Only OA2[7:6] are compared
	I2C_OAR2_OA2MSK_Mask5 = 0x5
	// OA2[6:1] are masked and don’t care. Only OA2[7] is compared.
	I2C_OAR2_OA2MSK_Mask6 = 0x6
	// OA2[7:1] are masked and don’t care. No comparison is done, and all (except reserved) 7-bit received addresses are acknowledged
	I2C_OAR2_OA2MSK_Mask7 = 0x7
	// Position of OA2EN field.
	I2C_OAR2_OA2EN_Pos = 0xf
	// Bit mask of OA2EN field.
	I2C_OAR2_OA2EN_Msk = 0x8000
	// Bit OA2EN.
	I2C_OAR2_OA2EN = 0x8000
	// Own address 2 disabled. The received slave address OA2 is NACKed
	I2C_OAR2_OA2EN_Disabled = 0x0
	// Own address 2 enabled. The received slave address OA2 is ACKed
	I2C_OAR2_OA2EN_Enabled = 0x1

	// TIMINGR: Timing register
	// Position of SCLL field.
	I2C_TIMINGR_SCLL_Pos = 0x0
	// Bit mask of SCLL field.
	I2C_TIMINGR_SCLL_Msk = 0xff
	// Position of SCLH field.
	I2C_TIMINGR_SCLH_Pos = 0x8
	// Bit mask of SCLH field.
	I2C_TIMINGR_SCLH_Msk = 0xff00
	// Position of SDADEL field.
	I2C_TIMINGR_SDADEL_Pos = 0x10
	// Bit mask of SDADEL field.
	I2C_TIMINGR_SDADEL_Msk = 0xf0000
	// Position of SCLDEL field.
	I2C_TIMINGR_SCLDEL_Pos = 0x14
	// Bit mask of SCLDEL field.
	I2C_TIMINGR_SCLDEL_Msk = 0xf00000
	// Position of PRESC field.
	I2C_TIMINGR_PRESC_Pos = 0x1c
	// Bit mask of PRESC field.
	I2C_TIMINGR_PRESC_Msk = 0xf0000000

	// TIMEOUTR: Status register 1
	// Position of TIMEOUTA field.
	I2C_TIMEOUTR_TIMEOUTA_Pos = 0x0
	// Bit mask of TIMEOUTA field.
	I2C_TIMEOUTR_TIMEOUTA_Msk = 0xfff
	// Position of TIDLE field.
	I2C_TIMEOUTR_TIDLE_Pos = 0xc
	// Bit mask of TIDLE field.
	I2C_TIMEOUTR_TIDLE_Msk = 0x1000
	// Bit TIDLE.
	I2C_TIMEOUTR_TIDLE = 0x1000
	// TIMEOUTA is used to detect SCL low timeout
	I2C_TIMEOUTR_TIDLE_Disabled = 0x0
	// TIMEOUTA is used to detect both SCL and SDA high timeout (bus idle condition)
	I2C_TIMEOUTR_TIDLE_Enabled = 0x1
	// Position of TIMOUTEN field.
	I2C_TIMEOUTR_TIMOUTEN_Pos = 0xf
	// Bit mask of TIMOUTEN field.
	I2C_TIMEOUTR_TIMOUTEN_Msk = 0x8000
	// Bit TIMOUTEN.
	I2C_TIMEOUTR_TIMOUTEN = 0x8000
	// SCL timeout detection is disabled
	I2C_TIMEOUTR_TIMOUTEN_Disabled = 0x0
	// SCL timeout detection is enabled
	I2C_TIMEOUTR_TIMOUTEN_Enabled = 0x1
	// Position of TIMEOUTB field.
	I2C_TIMEOUTR_TIMEOUTB_Pos = 0x10
	// Bit mask of TIMEOUTB field.
	I2C_TIMEOUTR_TIMEOUTB_Msk = 0xfff0000
	// Position of TEXTEN field.
	I2C_TIMEOUTR_TEXTEN_Pos = 0x1f
	// Bit mask of TEXTEN field.
	I2C_TIMEOUTR_TEXTEN_Msk = 0x80000000
	// Bit TEXTEN.
	I2C_TIMEOUTR_TEXTEN = 0x80000000
	// Extended clock timeout detection is disabled
	I2C_TIMEOUTR_TEXTEN_Disabled = 0x0
	// Extended clock timeout detection is enabled
	I2C_TIMEOUTR_TEXTEN_Enabled = 0x1

	// ISR: Interrupt and Status register
	// Position of ADDCODE field.
	I2C_ISR_ADDCODE_Pos = 0x11
	// Bit mask of ADDCODE field.
	I2C_ISR_ADDCODE_Msk = 0xfe0000
	// Position of DIR field.
	I2C_ISR_DIR_Pos = 0x10
	// Bit mask of DIR field.
	I2C_ISR_DIR_Msk = 0x10000
	// Bit DIR.
	I2C_ISR_DIR = 0x10000
	// Write transfer, slave enters receiver mode
	I2C_ISR_DIR_Write = 0x0
	// Read transfer, slave enters transmitter mode
	I2C_ISR_DIR_Read = 0x1
	// Position of BUSY field.
	I2C_ISR_BUSY_Pos = 0xf
	// Bit mask of BUSY field.
	I2C_ISR_BUSY_Msk = 0x8000
	// Bit BUSY.
	I2C_ISR_BUSY = 0x8000
	// No communication is in progress on the bus
	I2C_ISR_BUSY_NotBusy = 0x0
	// A communication is in progress on the bus
	I2C_ISR_BUSY_Busy = 0x1
	// Position of ALERT field.
	I2C_ISR_ALERT_Pos = 0xd
	// Bit mask of ALERT field.
	I2C_ISR_ALERT_Msk = 0x2000
	// Bit ALERT.
	I2C_ISR_ALERT = 0x2000
	// SMBA alert is not detected
	I2C_ISR_ALERT_NoAlert = 0x0
	// SMBA alert event is detected on SMBA pin
	I2C_ISR_ALERT_Alert = 0x1
	// Position of TIMEOUT field.
	I2C_ISR_TIMEOUT_Pos = 0xc
	// Bit mask of TIMEOUT field.
	I2C_ISR_TIMEOUT_Msk = 0x1000
	// Bit TIMEOUT.
	I2C_ISR_TIMEOUT = 0x1000
	// No timeout occured
	I2C_ISR_TIMEOUT_NoTimeout = 0x0
	// Timeout occured
	I2C_ISR_TIMEOUT_Timeout = 0x1
	// Position of PECERR field.
	I2C_ISR_PECERR_Pos = 0xb
	// Bit mask of PECERR field.
	I2C_ISR_PECERR_Msk = 0x800
	// Bit PECERR.
	I2C_ISR_PECERR = 0x800
	// Received PEC does match with PEC register
	I2C_ISR_PECERR_Match = 0x0
	// Received PEC does not match with PEC register
	I2C_ISR_PECERR_NoMatch = 0x1
	// Position of OVR field.
	I2C_ISR_OVR_Pos = 0xa
	// Bit mask of OVR field.
	I2C_ISR_OVR_Msk = 0x400
	// Bit OVR.
	I2C_ISR_OVR = 0x400
	// No overrun/underrun error occurs
	I2C_ISR_OVR_NoOverrun = 0x0
	// slave mode with NOSTRETCH=1, when an overrun/underrun error occurs
	I2C_ISR_OVR_Overrun = 0x1
	// Position of ARLO field.
	I2C_ISR_ARLO_Pos = 0x9
	// Bit mask of ARLO field.
	I2C_ISR_ARLO_Msk = 0x200
	// Bit ARLO.
	I2C_ISR_ARLO = 0x200
	// No arbitration lost
	I2C_ISR_ARLO_NotLost = 0x0
	// Arbitration lost
	I2C_ISR_ARLO_Lost = 0x1
	// Position of BERR field.
	I2C_ISR_BERR_Pos = 0x8
	// Bit mask of BERR field.
	I2C_ISR_BERR_Msk = 0x100
	// Bit BERR.
	I2C_ISR_BERR = 0x100
	// No bus error
	I2C_ISR_BERR_NoError = 0x0
	// Misplaced Start and Stop condition is detected
	I2C_ISR_BERR_Error = 0x1
	// Position of TCR field.
	I2C_ISR_TCR_Pos = 0x7
	// Bit mask of TCR field.
	I2C_ISR_TCR_Msk = 0x80
	// Bit TCR.
	I2C_ISR_TCR = 0x80
	// Transfer is not complete
	I2C_ISR_TCR_NotComplete = 0x0
	// NBYTES has been transfered
	I2C_ISR_TCR_Complete = 0x1
	// Position of TC field.
	I2C_ISR_TC_Pos = 0x6
	// Bit mask of TC field.
	I2C_ISR_TC_Msk = 0x40
	// Bit TC.
	I2C_ISR_TC = 0x40
	// Transfer is not complete
	I2C_ISR_TC_NotComplete = 0x0
	// NBYTES has been transfered
	I2C_ISR_TC_Complete = 0x1
	// Position of STOPF field.
	I2C_ISR_STOPF_Pos = 0x5
	// Bit mask of STOPF field.
	I2C_ISR_STOPF_Msk = 0x20
	// Bit STOPF.
	I2C_ISR_STOPF = 0x20
	// No Stop condition detected
	I2C_ISR_STOPF_NoStop = 0x0
	// Stop condition detected
	I2C_ISR_STOPF_Stop = 0x1
	// Position of NACKF field.
	I2C_ISR_NACKF_Pos = 0x4
	// Bit mask of NACKF field.
	I2C_ISR_NACKF_Msk = 0x10
	// Bit NACKF.
	I2C_ISR_NACKF = 0x10
	// No NACK has been received
	I2C_ISR_NACKF_NoNack = 0x0
	// NACK has been received
	I2C_ISR_NACKF_Nack = 0x1
	// Position of ADDR field.
	I2C_ISR_ADDR_Pos = 0x3
	// Bit mask of ADDR field.
	I2C_ISR_ADDR_Msk = 0x8
	// Bit ADDR.
	I2C_ISR_ADDR = 0x8
	// Adress mismatched or not received
	I2C_ISR_ADDR_NotMatch = 0x0
	// Received slave address matched with one of the enabled slave addresses
	I2C_ISR_ADDR_Match = 0x1
	// Position of RXNE field.
	I2C_ISR_RXNE_Pos = 0x2
	// Bit mask of RXNE field.
	I2C_ISR_RXNE_Msk = 0x4
	// Bit RXNE.
	I2C_ISR_RXNE = 0x4
	// The RXDR register is empty
	I2C_ISR_RXNE_Empty = 0x0
	// Received data is copied into the RXDR register, and is ready to be read
	I2C_ISR_RXNE_NotEmpty = 0x1
	// Position of TXIS field.
	I2C_ISR_TXIS_Pos = 0x1
	// Bit mask of TXIS field.
	I2C_ISR_TXIS_Msk = 0x2
	// Bit TXIS.
	I2C_ISR_TXIS = 0x2
	// The TXDR register is not empty
	I2C_ISR_TXIS_NotEmpty = 0x0
	// The TXDR register is empty and the data to be transmitted must be written in the TXDR register
	I2C_ISR_TXIS_Empty = 0x1
	// Position of TXE field.
	I2C_ISR_TXE_Pos = 0x0
	// Bit mask of TXE field.
	I2C_ISR_TXE_Msk = 0x1
	// Bit TXE.
	I2C_ISR_TXE = 0x1
	// TXDR register not empty
	I2C_ISR_TXE_NotEmpty = 0x0
	// TXDR register empty
	I2C_ISR_TXE_Empty = 0x1

	// ICR: Interrupt clear register
	// Position of ALERTCF field.
	I2C_ICR_ALERTCF_Pos = 0xd
	// Bit mask of ALERTCF field.
	I2C_ICR_ALERTCF_Msk = 0x2000
	// Bit ALERTCF.
	I2C_ICR_ALERTCF = 0x2000
	// Clears the ALERT flag in ISR register
	I2C_ICR_ALERTCF_Clear = 0x1
	// Position of TIMOUTCF field.
	I2C_ICR_TIMOUTCF_Pos = 0xc
	// Bit mask of TIMOUTCF field.
	I2C_ICR_TIMOUTCF_Msk = 0x1000
	// Bit TIMOUTCF.
	I2C_ICR_TIMOUTCF = 0x1000
	// Clears the TIMOUT flag in ISR register
	I2C_ICR_TIMOUTCF_Clear = 0x1
	// Position of PECCF field.
	I2C_ICR_PECCF_Pos = 0xb
	// Bit mask of PECCF field.
	I2C_ICR_PECCF_Msk = 0x800
	// Bit PECCF.
	I2C_ICR_PECCF = 0x800
	// Clears the PEC flag in ISR register
	I2C_ICR_PECCF_Clear = 0x1
	// Position of OVRCF field.
	I2C_ICR_OVRCF_Pos = 0xa
	// Bit mask of OVRCF field.
	I2C_ICR_OVRCF_Msk = 0x400
	// Bit OVRCF.
	I2C_ICR_OVRCF = 0x400
	// Clears the OVR flag in ISR register
	I2C_ICR_OVRCF_Clear = 0x1
	// Position of ARLOCF field.
	I2C_ICR_ARLOCF_Pos = 0x9
	// Bit mask of ARLOCF field.
	I2C_ICR_ARLOCF_Msk = 0x200
	// Bit ARLOCF.
	I2C_ICR_ARLOCF = 0x200
	// Clears the ARLO flag in ISR register
	I2C_ICR_ARLOCF_Clear = 0x1
	// Position of BERRCF field.
	I2C_ICR_BERRCF_Pos = 0x8
	// Bit mask of BERRCF field.
	I2C_ICR_BERRCF_Msk = 0x100
	// Bit BERRCF.
	I2C_ICR_BERRCF = 0x100
	// Clears the BERR flag in ISR register
	I2C_ICR_BERRCF_Clear = 0x1
	// Position of STOPCF field.
	I2C_ICR_STOPCF_Pos = 0x5
	// Bit mask of STOPCF field.
	I2C_ICR_STOPCF_Msk = 0x20
	// Bit STOPCF.
	I2C_ICR_STOPCF = 0x20
	// Clears the STOP flag in ISR register
	I2C_ICR_STOPCF_Clear = 0x1
	// Position of NACKCF field.
	I2C_ICR_NACKCF_Pos = 0x4
	// Bit mask of NACKCF field.
	I2C_ICR_NACKCF_Msk = 0x10
	// Bit NACKCF.
	I2C_ICR_NACKCF = 0x10
	// Clears the NACK flag in ISR register
	I2C_ICR_NACKCF_Clear = 0x1
	// Position of ADDRCF field.
	I2C_ICR_ADDRCF_Pos = 0x3
	// Bit mask of ADDRCF field.
	I2C_ICR_ADDRCF_Msk = 0x8
	// Bit ADDRCF.
	I2C_ICR_ADDRCF = 0x8
	// Clears the ADDR flag in ISR register
	I2C_ICR_ADDRCF_Clear = 0x1

	// PECR: PEC register
	// Position of PEC field.
	I2C_PECR_PEC_Pos = 0x0
	// Bit mask of PEC field.
	I2C_PECR_PEC_Msk = 0xff

	// RXDR: Receive data register
	// Position of RXDATA field.
	I2C_RXDR_RXDATA_Pos = 0x0
	// Bit mask of RXDATA field.
	I2C_RXDR_RXDATA_Msk = 0xff

	// TXDR: Transmit data register
	// Position of TXDATA field.
	I2C_TXDR_TXDATA_Pos = 0x0
	// Bit mask of TXDATA field.
	I2C_TXDR_TXDATA_Msk = 0xff
)

// Bitfields for PWR: Power control
const (
	// CR: power control register
	// Position of LPDS field.
	PWR_CR_LPDS_Pos = 0x0
	// Bit mask of LPDS field.
	PWR_CR_LPDS_Msk = 0x1
	// Bit LPDS.
	PWR_CR_LPDS = 0x1
	// Position of PDDS field.
	PWR_CR_PDDS_Pos = 0x1
	// Bit mask of PDDS field.
	PWR_CR_PDDS_Msk = 0x2
	// Bit PDDS.
	PWR_CR_PDDS = 0x2
	// Enter Stop mode when the CPU enters deepsleep
	PWR_CR_PDDS_STOP_MODE = 0x0
	// Enter Standby mode when the CPU enters deepsleep
	PWR_CR_PDDS_STANDBY_MODE = 0x1
	// Position of CWUF field.
	PWR_CR_CWUF_Pos = 0x2
	// Bit mask of CWUF field.
	PWR_CR_CWUF_Msk = 0x4
	// Bit CWUF.
	PWR_CR_CWUF = 0x4
	// Clear the WUF Wakeup flag after 2 system clock cycles
	PWR_CR_CWUF_Clear = 0x1
	// Position of CSBF field.
	PWR_CR_CSBF_Pos = 0x3
	// Bit mask of CSBF field.
	PWR_CR_CSBF_Msk = 0x8
	// Bit CSBF.
	PWR_CR_CSBF = 0x8
	// Clear the SBF Standby flag
	PWR_CR_CSBF_Clear = 0x1
	// Position of PVDE field.
	PWR_CR_PVDE_Pos = 0x4
	// Bit mask of PVDE field.
	PWR_CR_PVDE_Msk = 0x10
	// Bit PVDE.
	PWR_CR_PVDE = 0x10
	// PVD Disabled
	PWR_CR_PVDE_Disabled = 0x0
	// PVD Enabled
	PWR_CR_PVDE_Enabled = 0x1
	// Position of PLS field.
	PWR_CR_PLS_Pos = 0x5
	// Bit mask of PLS field.
	PWR_CR_PLS_Msk = 0xe0
	// 1.9 V
	PWR_CR_PLS_V1_9 = 0x0
	// 2.1 V
	PWR_CR_PLS_V2_1 = 0x1
	// 2.3 V
	PWR_CR_PLS_V2_3 = 0x2
	// 2.5 V
	PWR_CR_PLS_V2_5 = 0x3
	// 2.7 V
	PWR_CR_PLS_V2_7 = 0x4
	// 2.9 V
	PWR_CR_PLS_V2_9 = 0x5
	// 3.1 V
	PWR_CR_PLS_V3_1 = 0x6
	// External input analog voltage (Compare internally to VREFINT)
	PWR_CR_PLS_External = 0x7
	// Position of DBP field.
	PWR_CR_DBP_Pos = 0x8
	// Bit mask of DBP field.
	PWR_CR_DBP_Msk = 0x100
	// Bit DBP.
	PWR_CR_DBP = 0x100
	// Access to RTC, RTC Backup and RCC CSR registers disabled
	PWR_CR_DBP_Disabled = 0x0
	// Access to RTC, RTC Backup and RCC CSR registers enabled
	PWR_CR_DBP_Enabled = 0x1
	// Position of ULP field.
	PWR_CR_ULP_Pos = 0x9
	// Bit mask of ULP field.
	PWR_CR_ULP_Msk = 0x200
	// Bit ULP.
	PWR_CR_ULP = 0x200
	// VREFINT is on in low-power mode
	PWR_CR_ULP_Enabled = 0x0
	// VREFINT is off in low-power mode
	PWR_CR_ULP_Disabled = 0x1
	// Position of FWU field.
	PWR_CR_FWU_Pos = 0xa
	// Bit mask of FWU field.
	PWR_CR_FWU_Msk = 0x400
	// Bit FWU.
	PWR_CR_FWU = 0x400
	// Low-power modes exit occurs only when VREFINT is ready
	PWR_CR_FWU_Disabled = 0x0
	// VREFINT start up time is ignored when exiting low-power modes
	PWR_CR_FWU_Enabled = 0x1
	// Position of VOS field.
	PWR_CR_VOS_Pos = 0xb
	// Bit mask of VOS field.
	PWR_CR_VOS_Msk = 0x1800
	// 1.8 V (range 1)
	PWR_CR_VOS_V1_8 = 0x1
	// 1.5 V (range 2)
	PWR_CR_VOS_V1_5 = 0x2
	// 1.2 V (range 3)
	PWR_CR_VOS_V1_2 = 0x3
	// Position of DS_EE_KOFF field.
	PWR_CR_DS_EE_KOFF_Pos = 0xd
	// Bit mask of DS_EE_KOFF field.
	PWR_CR_DS_EE_KOFF_Msk = 0x2000
	// Bit DS_EE_KOFF.
	PWR_CR_DS_EE_KOFF = 0x2000
	// NVM woken up when exiting from Deepsleep mode even if the bit RUN_PD is set
	PWR_CR_DS_EE_KOFF_NVMWakeUp = 0x0
	// NVM not woken up when exiting from low-power mode (if the bit RUN_PD is set)
	PWR_CR_DS_EE_KOFF_NVMSleep = 0x1
	// Position of LPRUN field.
	PWR_CR_LPRUN_Pos = 0xe
	// Bit mask of LPRUN field.
	PWR_CR_LPRUN_Msk = 0x4000
	// Bit LPRUN.
	PWR_CR_LPRUN = 0x4000
	// Voltage regulator in Main mode in Low-power run mode
	PWR_CR_LPRUN_MAIN_MODE = 0x0
	// Voltage regulator in low-power mode in Low-power run mode
	PWR_CR_LPRUN_LOW_POWER_MODE = 0x1
	// Position of LPSDSR field.
	PWR_CR_LPSDSR_Pos = 0x0
	// Bit mask of LPSDSR field.
	PWR_CR_LPSDSR_Msk = 0x1
	// Bit LPSDSR.
	PWR_CR_LPSDSR = 0x1
	// Voltage regulator on during Deepsleep/Sleep/Low-power run mode
	PWR_CR_LPSDSR_MAIN_MODE = 0x0
	// Voltage regulator in low-power mode during Deepsleep/Sleep/Low-power run mode
	PWR_CR_LPSDSR_LOW_POWER_MODE = 0x1

	// CSR: power control/status register
	// Position of EWUP2 field.
	PWR_CSR_EWUP2_Pos = 0x9
	// Bit mask of EWUP2 field.
	PWR_CSR_EWUP2_Msk = 0x200
	// Bit EWUP2.
	PWR_CSR_EWUP2 = 0x200
	// WKUP pin 2 is used for general purpose I/Os. An event on the WKUP pin 2 does not wakeup the device from Standby mode
	PWR_CSR_EWUP2_Disabled = 0x0
	// WKUP pin 2 is used for wakeup from Standby mode and forced in input pull down configuration (rising edge on WKUP pin 2 wakes-up the system from Standby mode)
	PWR_CSR_EWUP2_Enabled = 0x1
	// Position of EWUP1 field.
	PWR_CSR_EWUP1_Pos = 0x8
	// Bit mask of EWUP1 field.
	PWR_CSR_EWUP1_Msk = 0x100
	// Bit EWUP1.
	PWR_CSR_EWUP1 = 0x100
	// WKUP pin 1 is used for general purpose I/Os. An event on the WKUP pin 1 does not wakeup the device from Standby mode
	PWR_CSR_EWUP1_Disabled = 0x0
	// WKUP pin 1 is used for wakeup from Standby mode and forced in input pull down configuration (rising edge on WKUP pin 1 wakes-up the system from Standby mode)
	PWR_CSR_EWUP1_Enabled = 0x1
	// Position of VREFINTRDYF field.
	PWR_CSR_VREFINTRDYF_Pos = 0x3
	// Bit mask of VREFINTRDYF field.
	PWR_CSR_VREFINTRDYF_Msk = 0x8
	// Bit VREFINTRDYF.
	PWR_CSR_VREFINTRDYF = 0x8
	// VREFINT is OFF
	PWR_CSR_VREFINTRDYF_NotReady = 0x0
	// VREFINT is ready
	PWR_CSR_VREFINTRDYF_Ready = 0x1
	// Position of PVDO field.
	PWR_CSR_PVDO_Pos = 0x2
	// Bit mask of PVDO field.
	PWR_CSR_PVDO_Msk = 0x4
	// Bit PVDO.
	PWR_CSR_PVDO = 0x4
	// VDD is higher than the PVD threshold selected with the PLS[2:0] bits
	PWR_CSR_PVDO_AboveThreshold = 0x0
	// VDD is lower than the PVD threshold selected with the PLS[2:0] bits
	PWR_CSR_PVDO_BelowThreshold = 0x1
	// Position of SBF field.
	PWR_CSR_SBF_Pos = 0x1
	// Bit mask of SBF field.
	PWR_CSR_SBF_Msk = 0x2
	// Bit SBF.
	PWR_CSR_SBF = 0x2
	// Device has not been in Standby mode
	PWR_CSR_SBF_NoStandbyEvent = 0x0
	// Device has been in Standby mode
	PWR_CSR_SBF_StandbyEvent = 0x1
	// Position of WUF field.
	PWR_CSR_WUF_Pos = 0x0
	// Bit mask of WUF field.
	PWR_CSR_WUF_Msk = 0x1
	// Bit WUF.
	PWR_CSR_WUF = 0x1
	// No wakeup event occurred
	PWR_CSR_WUF_NoWakeupEvent = 0x0
	// A wakeup event was received from the WKUP pin or from the RTC alarm (Alarm A or Alarm B), RTC Tamper event, RTC TimeStamp event or RTC Wakeup)
	PWR_CSR_WUF_WakeupEvent = 0x1
	// Position of VOSF field.
	PWR_CSR_VOSF_Pos = 0x4
	// Bit mask of VOSF field.
	PWR_CSR_VOSF_Msk = 0x10
	// Bit VOSF.
	PWR_CSR_VOSF = 0x10
	// Regulator is ready in the selected voltage range
	PWR_CSR_VOSF_Ready = 0x0
	// Regulator voltage output is changing to the required VOS level
	PWR_CSR_VOSF_NotReady = 0x1
	// Position of REGLPF field.
	PWR_CSR_REGLPF_Pos = 0x5
	// Bit mask of REGLPF field.
	PWR_CSR_REGLPF_Msk = 0x20
	// Bit REGLPF.
	PWR_CSR_REGLPF = 0x20
	// Regulator is ready in Main mode
	PWR_CSR_REGLPF_Ready = 0x0
	// Regulator voltage is in low-power mode
	PWR_CSR_REGLPF_NotReady = 0x1
	// Position of EWUP3 field.
	PWR_CSR_EWUP3_Pos = 0xa
	// Bit mask of EWUP3 field.
	PWR_CSR_EWUP3_Msk = 0x400
	// Bit EWUP3.
	PWR_CSR_EWUP3 = 0x400
	// WKUP pin 3 is used for general purpose I/Os. An event on the WKUP pin 3 does not wakeup the device from Standby mode
	PWR_CSR_EWUP3_Disabled = 0x0
	// WKUP pin 3 is used for wakeup from Standby mode and forced in input pull down configuration (rising edge on WKUP pin 3wakes-up the system from Standby mode)
	PWR_CSR_EWUP3_Enabled = 0x1
)

// Bitfields for FLASH: Flash
const (
	// ACR: Access control register
	// Position of LATENCY field.
	Flash_ACR_LATENCY_Pos = 0x0
	// Bit mask of LATENCY field.
	Flash_ACR_LATENCY_Msk = 0x1
	// Bit LATENCY.
	Flash_ACR_LATENCY = 0x1
	// Zero wait state is used to read a word in the NVM
	Flash_ACR_LATENCY_WS0 = 0x0
	// One wait state is used to read a word in the NVM
	Flash_ACR_LATENCY_WS1 = 0x1
	// Position of PRFTEN field.
	Flash_ACR_PRFTEN_Pos = 0x1
	// Bit mask of PRFTEN field.
	Flash_ACR_PRFTEN_Msk = 0x2
	// Bit PRFTEN.
	Flash_ACR_PRFTEN = 0x2
	// Prefetch is disabled
	Flash_ACR_PRFTEN_Disabled = 0x0
	// Prefetch is enabled
	Flash_ACR_PRFTEN_Enabled = 0x1
	// Position of SLEEP_PD field.
	Flash_ACR_SLEEP_PD_Pos = 0x3
	// Bit mask of SLEEP_PD field.
	Flash_ACR_SLEEP_PD_Msk = 0x8
	// Bit SLEEP_PD.
	Flash_ACR_SLEEP_PD = 0x8
	// When the device is in Sleep mode, the NVM is in Idle mode
	Flash_ACR_SLEEP_PD_NVMIdleMode = 0x0
	// When the device is in Sleep mode, the NVM is in power-down mode
	Flash_ACR_SLEEP_PD_NVMPwrDownMode = 0x1
	// Position of RUN_PD field.
	Flash_ACR_RUN_PD_Pos = 0x4
	// Bit mask of RUN_PD field.
	Flash_ACR_RUN_PD_Msk = 0x10
	// Bit RUN_PD.
	Flash_ACR_RUN_PD = 0x10
	// When the device is in Run mode, the NVM is in Idle mode
	Flash_ACR_RUN_PD_NVMIdleMode = 0x0
	// When the device is in Run mode, the NVM is in power-down mode
	Flash_ACR_RUN_PD_NVMPwrDownMode = 0x1
	// Position of DISAB_BUF field.
	Flash_ACR_DISAB_BUF_Pos = 0x5
	// Bit mask of DISAB_BUF field.
	Flash_ACR_DISAB_BUF_Msk = 0x20
	// Bit DISAB_BUF.
	Flash_ACR_DISAB_BUF = 0x20
	// The buffers are enabled
	Flash_ACR_DISAB_BUF_Enabled = 0x0
	// The buffers are disabled
	Flash_ACR_DISAB_BUF_Disabled = 0x1
	// Position of PRE_READ field.
	Flash_ACR_PRE_READ_Pos = 0x6
	// Bit mask of PRE_READ field.
	Flash_ACR_PRE_READ_Msk = 0x40
	// Bit PRE_READ.
	Flash_ACR_PRE_READ = 0x40
	// The pre-read is disabled
	Flash_ACR_PRE_READ_Disabled = 0x0
	// The pre-read is enabled
	Flash_ACR_PRE_READ_Enabled = 0x1

	// PECR: Program/erase control register
	// Position of PELOCK field.
	Flash_PECR_PELOCK_Pos = 0x0
	// Bit mask of PELOCK field.
	Flash_PECR_PELOCK_Msk = 0x1
	// Bit PELOCK.
	Flash_PECR_PELOCK = 0x1
	// The FLASH_PECR register is unlocked
	Flash_PECR_PELOCK_Unlocked = 0x0
	// The FLASH_PECR register is locked and no write/erase operation can start
	Flash_PECR_PELOCK_Locked = 0x1
	// Position of PRGLOCK field.
	Flash_PECR_PRGLOCK_Pos = 0x1
	// Bit mask of PRGLOCK field.
	Flash_PECR_PRGLOCK_Msk = 0x2
	// Bit PRGLOCK.
	Flash_PECR_PRGLOCK = 0x2
	// The write and erase operations in the Flash program memory are disabled
	Flash_PECR_PRGLOCK_Unlocked = 0x0
	// The write and erase operations in the Flash program memory are enabled
	Flash_PECR_PRGLOCK_Locked = 0x1
	// Position of OPTLOCK field.
	Flash_PECR_OPTLOCK_Pos = 0x2
	// Bit mask of OPTLOCK field.
	Flash_PECR_OPTLOCK_Msk = 0x4
	// Bit OPTLOCK.
	Flash_PECR_OPTLOCK = 0x4
	// The write and erase operations in the Option bytes area are disabled
	Flash_PECR_OPTLOCK_Unlocked = 0x0
	// The write and erase operations in the Option bytes area are enabled
	Flash_PECR_OPTLOCK_Locked = 0x1
	// Position of PROG field.
	Flash_PECR_PROG_Pos = 0x3
	// Bit mask of PROG field.
	Flash_PECR_PROG_Msk = 0x8
	// Bit PROG.
	Flash_PECR_PROG = 0x8
	// The Flash program memory is not selected
	Flash_PECR_PROG_NotSelected = 0x0
	// The Flash program memory is selected
	Flash_PECR_PROG_Selected = 0x1
	// Position of DATA field.
	Flash_PECR_DATA_Pos = 0x4
	// Bit mask of DATA field.
	Flash_PECR_DATA_Msk = 0x10
	// Bit DATA.
	Flash_PECR_DATA = 0x10
	// Data EEPROM not selected
	Flash_PECR_DATA_NotSelected = 0x0
	// Data memory selected
	Flash_PECR_DATA_Selected = 0x1
	// Position of FIX field.
	Flash_PECR_FIX_Pos = 0x8
	// Bit mask of FIX field.
	Flash_PECR_FIX_Msk = 0x100
	// Bit FIX.
	Flash_PECR_FIX = 0x100
	// An erase phase is automatically performed
	Flash_PECR_FIX_AutoErase = 0x0
	// The program operation is always performed with a preliminary erase
	Flash_PECR_FIX_PrelimErase = 0x1
	// Position of ERASE field.
	Flash_PECR_ERASE_Pos = 0x9
	// Bit mask of ERASE field.
	Flash_PECR_ERASE_Msk = 0x200
	// Bit ERASE.
	Flash_PECR_ERASE = 0x200
	// No erase operation requested
	Flash_PECR_ERASE_NoErase = 0x0
	// Erase operation requested
	Flash_PECR_ERASE_Erase = 0x1
	// Position of FPRG field.
	Flash_PECR_FPRG_Pos = 0xa
	// Bit mask of FPRG field.
	Flash_PECR_FPRG_Msk = 0x400
	// Bit FPRG.
	Flash_PECR_FPRG = 0x400
	// Half Page programming disabled
	Flash_PECR_FPRG_Disabled = 0x0
	// Half Page programming enabled
	Flash_PECR_FPRG_Enabled = 0x1
	// Position of PARALLELBANK field.
	Flash_PECR_PARALLELBANK_Pos = 0xf
	// Bit mask of PARALLELBANK field.
	Flash_PECR_PARALLELBANK_Msk = 0x8000
	// Bit PARALLELBANK.
	Flash_PECR_PARALLELBANK = 0x8000
	// Parallel bank mode disabled
	Flash_PECR_PARALLELBANK_Disabled = 0x0
	// Parallel bank mode enabled
	Flash_PECR_PARALLELBANK_Enabled = 0x1
	// Position of EOPIE field.
	Flash_PECR_EOPIE_Pos = 0x10
	// Bit mask of EOPIE field.
	Flash_PECR_EOPIE_Msk = 0x10000
	// Bit EOPIE.
	Flash_PECR_EOPIE = 0x10000
	// End of program interrupt disable
	Flash_PECR_EOPIE_Disabled = 0x0
	// End of program interrupt enable
	Flash_PECR_EOPIE_Enabled = 0x1
	// Position of ERRIE field.
	Flash_PECR_ERRIE_Pos = 0x11
	// Bit mask of ERRIE field.
	Flash_PECR_ERRIE_Msk = 0x20000
	// Bit ERRIE.
	Flash_PECR_ERRIE = 0x20000
	// Error interrupt disable
	Flash_PECR_ERRIE_Disabled = 0x0
	// Error interrupt enable
	Flash_PECR_ERRIE_Enabled = 0x1
	// Position of OBL_LAUNCH field.
	Flash_PECR_OBL_LAUNCH_Pos = 0x12
	// Bit mask of OBL_LAUNCH field.
	Flash_PECR_OBL_LAUNCH_Msk = 0x40000
	// Bit OBL_LAUNCH.
	Flash_PECR_OBL_LAUNCH = 0x40000
	// Option byte loaded
	Flash_PECR_OBL_LAUNCH_Complete = 0x0
	// Option byte loading to be done
	Flash_PECR_OBL_LAUNCH_NotComplete = 0x1
	// Reload option byte
	Flash_PECR_OBL_LAUNCH_Reload = 0x1

	// PDKEYR: Power down key register
	// Position of PDKEYR field.
	Flash_PDKEYR_PDKEYR_Pos = 0x0
	// Bit mask of PDKEYR field.
	Flash_PDKEYR_PDKEYR_Msk = 0xffffffff

	// PEKEYR: Program/erase key register
	// Position of PEKEYR field.
	Flash_PEKEYR_PEKEYR_Pos = 0x0
	// Bit mask of PEKEYR field.
	Flash_PEKEYR_PEKEYR_Msk = 0xffffffff

	// PRGKEYR: Program memory key register
	// Position of PRGKEYR field.
	Flash_PRGKEYR_PRGKEYR_Pos = 0x0
	// Bit mask of PRGKEYR field.
	Flash_PRGKEYR_PRGKEYR_Msk = 0xffffffff

	// OPTKEYR: Option byte key register
	// Position of OPTKEYR field.
	Flash_OPTKEYR_OPTKEYR_Pos = 0x0
	// Bit mask of OPTKEYR field.
	Flash_OPTKEYR_OPTKEYR_Msk = 0xffffffff

	// SR: Status register
	// Position of BSY field.
	Flash_SR_BSY_Pos = 0x0
	// Bit mask of BSY field.
	Flash_SR_BSY_Msk = 0x1
	// Bit BSY.
	Flash_SR_BSY = 0x1
	// No write/erase operation is in progress
	Flash_SR_BSY_Inactive = 0x0
	// No write/erase operation is in progress
	Flash_SR_BSY_Active = 0x1
	// Position of EOP field.
	Flash_SR_EOP_Pos = 0x1
	// Bit mask of EOP field.
	Flash_SR_EOP_Msk = 0x2
	// Bit EOP.
	Flash_SR_EOP = 0x2
	// No EOP operation occurred
	Flash_SR_EOP_NoEvent = 0x0
	// An EOP event occurred
	Flash_SR_EOP_Event = 0x1
	// Position of ENDHV field.
	Flash_SR_ENDHV_Pos = 0x2
	// Bit mask of ENDHV field.
	Flash_SR_ENDHV_Msk = 0x4
	// Bit ENDHV.
	Flash_SR_ENDHV = 0x4
	// High voltage is executing a write/erase operation in the NVM
	Flash_SR_ENDHV_Active = 0x0
	// High voltage is off, no write/erase operation is ongoing
	Flash_SR_ENDHV_Inactive = 0x1
	// Position of READY field.
	Flash_SR_READY_Pos = 0x3
	// Bit mask of READY field.
	Flash_SR_READY_Msk = 0x8
	// Bit READY.
	Flash_SR_READY = 0x8
	// The NVM is not ready
	Flash_SR_READY_NotReady = 0x0
	// The NVM is ready
	Flash_SR_READY_Ready = 0x1
	// Position of WRPERR field.
	Flash_SR_WRPERR_Pos = 0x8
	// Bit mask of WRPERR field.
	Flash_SR_WRPERR_Msk = 0x100
	// Bit WRPERR.
	Flash_SR_WRPERR = 0x100
	// No protection error happened
	Flash_SR_WRPERR_NoError = 0x0
	// One protection error happened
	Flash_SR_WRPERR_Error = 0x1
	// Clear the flag
	Flash_SR_WRPERR_Clear = 0x1
	// Position of PGAERR field.
	Flash_SR_PGAERR_Pos = 0x9
	// Bit mask of PGAERR field.
	Flash_SR_PGAERR_Msk = 0x200
	// Bit PGAERR.
	Flash_SR_PGAERR = 0x200
	// No alignment error happened
	Flash_SR_PGAERR_NoError = 0x0
	// One alignment error happened
	Flash_SR_PGAERR_Error = 0x1
	// Clear the flag
	Flash_SR_PGAERR_Clear = 0x1
	// Position of SIZERR field.
	Flash_SR_SIZERR_Pos = 0xa
	// Bit mask of SIZERR field.
	Flash_SR_SIZERR_Msk = 0x400
	// Bit SIZERR.
	Flash_SR_SIZERR = 0x400
	// No size error happened
	Flash_SR_SIZERR_NoError = 0x0
	// One size error happened
	Flash_SR_SIZERR_Error = 0x1
	// Clear the flag
	Flash_SR_SIZERR_Clear = 0x1
	// Position of OPTVERR field.
	Flash_SR_OPTVERR_Pos = 0xb
	// Bit mask of OPTVERR field.
	Flash_SR_OPTVERR_Msk = 0x800
	// Bit OPTVERR.
	Flash_SR_OPTVERR = 0x800
	// No error happened during the Option bytes loading
	Flash_SR_OPTVERR_NoError = 0x0
	// One or more errors happened during the Option bytes loading
	Flash_SR_OPTVERR_Error = 0x1
	// Clear the flag
	Flash_SR_OPTVERR_Clear = 0x1
	// Position of RDERR field.
	Flash_SR_RDERR_Pos = 0xe
	// Bit mask of RDERR field.
	Flash_SR_RDERR_Msk = 0x4000
	// Bit RDERR.
	Flash_SR_RDERR = 0x4000
	// No read protection error happened.
	Flash_SR_RDERR_NoError = 0x0
	// One read protection error happened
	Flash_SR_RDERR_Error = 0x1
	// Clear the flag
	Flash_SR_RDERR_Clear = 0x1
	// Position of NOTZEROERR field.
	Flash_SR_NOTZEROERR_Pos = 0x10
	// Bit mask of NOTZEROERR field.
	Flash_SR_NOTZEROERR_Msk = 0x10000
	// Bit NOTZEROERR.
	Flash_SR_NOTZEROERR = 0x10000
	// The write operation is done in an erased region or the memory interface can apply an erase before a write
	Flash_SR_NOTZEROERR_NoEvent = 0x0
	// The write operation is attempting to write to a not-erased region and the memory interface cannot apply an erase before a write
	Flash_SR_NOTZEROERR_Event = 0x1
	// Clear the flag
	Flash_SR_NOTZEROERR_Clear = 0x1
	// Position of FWWERR field.
	Flash_SR_FWWERR_Pos = 0x11
	// Bit mask of FWWERR field.
	Flash_SR_FWWERR_Msk = 0x20000
	// Bit FWWERR.
	Flash_SR_FWWERR = 0x20000
	// No write/erase operation aborted to perform a fetch
	Flash_SR_FWWERR_NoError = 0x0
	// A write/erase operation aborted to perform a fetch
	Flash_SR_FWWERR_Error = 0x1
	// Clear the flag
	Flash_SR_FWWERR_Clear = 0x1

	// OPTR: Option byte register
	// Position of RDPROT field.
	Flash_OPTR_RDPROT_Pos = 0x0
	// Bit mask of RDPROT field.
	Flash_OPTR_RDPROT_Msk = 0xff
	// Level 0
	Flash_OPTR_RDPROT_Level0 = 0xaa
	// Level 1
	Flash_OPTR_RDPROT_Level1 = 0x0
	// Level 2
	Flash_OPTR_RDPROT_Level2 = 0xcc
	// Position of BOR_LEV field.
	Flash_OPTR_BOR_LEV_Pos = 0x10
	// Bit mask of BOR_LEV field.
	Flash_OPTR_BOR_LEV_Msk = 0xf0000
	// This is the reset threshold level for the 1.45 V - 1.55 V voltage range (power-down only)
	Flash_OPTR_BOR_LEV_BOR_Off = 0x0
	// Reset threshold level for VBOR0 (around 1.8 V)
	Flash_OPTR_BOR_LEV_BOR_Level1 = 0x1
	// Reset threshold level for VBOR1 (around 2.0 V)
	Flash_OPTR_BOR_LEV_BOR_Level2 = 0x2
	// Reset threshold level for VBOR2 (around 2.5 V)
	Flash_OPTR_BOR_LEV_BOR_Level3 = 0x3
	// Reset threshold level for VBOR3 (around 2.7 V)
	Flash_OPTR_BOR_LEV_BOR_Level4 = 0x4
	// Reset threshold level for VBOR4 (around 3.0 V)
	Flash_OPTR_BOR_LEV_BOR_Level5 = 0x5
	// Position of WPRMOD field.
	Flash_OPTR_WPRMOD_Pos = 0x8
	// Bit mask of WPRMOD field.
	Flash_OPTR_WPRMOD_Msk = 0x100
	// Bit WPRMOD.
	Flash_OPTR_WPRMOD = 0x100
	// PCROP disabled. The WRPROT bits are used as a write protection on a sector.
	Flash_OPTR_WPRMOD_Disabled = 0x0
	// PCROP enabled. The WRPROT bits are used as a read protection on a sector.
	Flash_OPTR_WPRMOD_Enabled = 0x1

	// WRPROT1: Write Protection Register 1
	// Position of WRPROT1 field.
	Flash_WRPROT1_WRPROT1_Pos = 0x0
	// Bit mask of WRPROT1 field.
	Flash_WRPROT1_WRPROT1_Msk = 0xffffffff

	// WRPROT2: Write Protection Register 2
	// Position of WRPROT2 field.
	Flash_WRPROT2_WRPROT2_Pos = 0x0
	// Bit mask of WRPROT2 field.
	Flash_WRPROT2_WRPROT2_Msk = 0xffff
)

// Bitfields for EXTI: External interrupt/event controller
const (
	// IMR: Interrupt mask register (EXTI_IMR)
	// Position of IM0 field.
	EXTI_IMR_IM0_Pos = 0x0
	// Bit mask of IM0 field.
	EXTI_IMR_IM0_Msk = 0x1
	// Bit IM0.
	EXTI_IMR_IM0 = 0x1
	// Interrupt request line is masked
	EXTI_IMR_IM0_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_IMR_IM0_Unmasked = 0x1
	// Position of IM1 field.
	EXTI_IMR_IM1_Pos = 0x1
	// Bit mask of IM1 field.
	EXTI_IMR_IM1_Msk = 0x2
	// Bit IM1.
	EXTI_IMR_IM1 = 0x2
	// Interrupt request line is masked
	EXTI_IMR_IM1_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_IMR_IM1_Unmasked = 0x1
	// Position of IM2 field.
	EXTI_IMR_IM2_Pos = 0x2
	// Bit mask of IM2 field.
	EXTI_IMR_IM2_Msk = 0x4
	// Bit IM2.
	EXTI_IMR_IM2 = 0x4
	// Interrupt request line is masked
	EXTI_IMR_IM2_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_IMR_IM2_Unmasked = 0x1
	// Position of IM3 field.
	EXTI_IMR_IM3_Pos = 0x3
	// Bit mask of IM3 field.
	EXTI_IMR_IM3_Msk = 0x8
	// Bit IM3.
	EXTI_IMR_IM3 = 0x8
	// Interrupt request line is masked
	EXTI_IMR_IM3_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_IMR_IM3_Unmasked = 0x1
	// Position of IM4 field.
	EXTI_IMR_IM4_Pos = 0x4
	// Bit mask of IM4 field.
	EXTI_IMR_IM4_Msk = 0x10
	// Bit IM4.
	EXTI_IMR_IM4 = 0x10
	// Interrupt request line is masked
	EXTI_IMR_IM4_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_IMR_IM4_Unmasked = 0x1
	// Position of IM5 field.
	EXTI_IMR_IM5_Pos = 0x5
	// Bit mask of IM5 field.
	EXTI_IMR_IM5_Msk = 0x20
	// Bit IM5.
	EXTI_IMR_IM5 = 0x20
	// Interrupt request line is masked
	EXTI_IMR_IM5_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_IMR_IM5_Unmasked = 0x1
	// Position of IM6 field.
	EXTI_IMR_IM6_Pos = 0x6
	// Bit mask of IM6 field.
	EXTI_IMR_IM6_Msk = 0x40
	// Bit IM6.
	EXTI_IMR_IM6 = 0x40
	// Interrupt request line is masked
	EXTI_IMR_IM6_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_IMR_IM6_Unmasked = 0x1
	// Position of IM7 field.
	EXTI_IMR_IM7_Pos = 0x7
	// Bit mask of IM7 field.
	EXTI_IMR_IM7_Msk = 0x80
	// Bit IM7.
	EXTI_IMR_IM7 = 0x80
	// Interrupt request line is masked
	EXTI_IMR_IM7_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_IMR_IM7_Unmasked = 0x1
	// Position of IM8 field.
	EXTI_IMR_IM8_Pos = 0x8
	// Bit mask of IM8 field.
	EXTI_IMR_IM8_Msk = 0x100
	// Bit IM8.
	EXTI_IMR_IM8 = 0x100
	// Interrupt request line is masked
	EXTI_IMR_IM8_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_IMR_IM8_Unmasked = 0x1
	// Position of IM9 field.
	EXTI_IMR_IM9_Pos = 0x9
	// Bit mask of IM9 field.
	EXTI_IMR_IM9_Msk = 0x200
	// Bit IM9.
	EXTI_IMR_IM9 = 0x200
	// Interrupt request line is masked
	EXTI_IMR_IM9_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_IMR_IM9_Unmasked = 0x1
	// Position of IM10 field.
	EXTI_IMR_IM10_Pos = 0xa
	// Bit mask of IM10 field.
	EXTI_IMR_IM10_Msk = 0x400
	// Bit IM10.
	EXTI_IMR_IM10 = 0x400
	// Interrupt request line is masked
	EXTI_IMR_IM10_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_IMR_IM10_Unmasked = 0x1
	// Position of IM11 field.
	EXTI_IMR_IM11_Pos = 0xb
	// Bit mask of IM11 field.
	EXTI_IMR_IM11_Msk = 0x800
	// Bit IM11.
	EXTI_IMR_IM11 = 0x800
	// Interrupt request line is masked
	EXTI_IMR_IM11_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_IMR_IM11_Unmasked = 0x1
	// Position of IM12 field.
	EXTI_IMR_IM12_Pos = 0xc
	// Bit mask of IM12 field.
	EXTI_IMR_IM12_Msk = 0x1000
	// Bit IM12.
	EXTI_IMR_IM12 = 0x1000
	// Interrupt request line is masked
	EXTI_IMR_IM12_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_IMR_IM12_Unmasked = 0x1
	// Position of IM13 field.
	EXTI_IMR_IM13_Pos = 0xd
	// Bit mask of IM13 field.
	EXTI_IMR_IM13_Msk = 0x2000
	// Bit IM13.
	EXTI_IMR_IM13 = 0x2000
	// Interrupt request line is masked
	EXTI_IMR_IM13_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_IMR_IM13_Unmasked = 0x1
	// Position of IM14 field.
	EXTI_IMR_IM14_Pos = 0xe
	// Bit mask of IM14 field.
	EXTI_IMR_IM14_Msk = 0x4000
	// Bit IM14.
	EXTI_IMR_IM14 = 0x4000
	// Interrupt request line is masked
	EXTI_IMR_IM14_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_IMR_IM14_Unmasked = 0x1
	// Position of IM15 field.
	EXTI_IMR_IM15_Pos = 0xf
	// Bit mask of IM15 field.
	EXTI_IMR_IM15_Msk = 0x8000
	// Bit IM15.
	EXTI_IMR_IM15 = 0x8000
	// Interrupt request line is masked
	EXTI_IMR_IM15_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_IMR_IM15_Unmasked = 0x1
	// Position of IM16 field.
	EXTI_IMR_IM16_Pos = 0x10
	// Bit mask of IM16 field.
	EXTI_IMR_IM16_Msk = 0x10000
	// Bit IM16.
	EXTI_IMR_IM16 = 0x10000
	// Interrupt request line is masked
	EXTI_IMR_IM16_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_IMR_IM16_Unmasked = 0x1
	// Position of IM17 field.
	EXTI_IMR_IM17_Pos = 0x11
	// Bit mask of IM17 field.
	EXTI_IMR_IM17_Msk = 0x20000
	// Bit IM17.
	EXTI_IMR_IM17 = 0x20000
	// Interrupt request line is masked
	EXTI_IMR_IM17_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_IMR_IM17_Unmasked = 0x1
	// Position of IM18 field.
	EXTI_IMR_IM18_Pos = 0x12
	// Bit mask of IM18 field.
	EXTI_IMR_IM18_Msk = 0x40000
	// Bit IM18.
	EXTI_IMR_IM18 = 0x40000
	// Interrupt request line is masked
	EXTI_IMR_IM18_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_IMR_IM18_Unmasked = 0x1
	// Position of IM19 field.
	EXTI_IMR_IM19_Pos = 0x13
	// Bit mask of IM19 field.
	EXTI_IMR_IM19_Msk = 0x80000
	// Bit IM19.
	EXTI_IMR_IM19 = 0x80000
	// Interrupt request line is masked
	EXTI_IMR_IM19_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_IMR_IM19_Unmasked = 0x1
	// Position of IM20 field.
	EXTI_IMR_IM20_Pos = 0x14
	// Bit mask of IM20 field.
	EXTI_IMR_IM20_Msk = 0x100000
	// Bit IM20.
	EXTI_IMR_IM20 = 0x100000
	// Interrupt request line is masked
	EXTI_IMR_IM20_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_IMR_IM20_Unmasked = 0x1
	// Position of IM21 field.
	EXTI_IMR_IM21_Pos = 0x15
	// Bit mask of IM21 field.
	EXTI_IMR_IM21_Msk = 0x200000
	// Bit IM21.
	EXTI_IMR_IM21 = 0x200000
	// Interrupt request line is masked
	EXTI_IMR_IM21_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_IMR_IM21_Unmasked = 0x1
	// Position of IM22 field.
	EXTI_IMR_IM22_Pos = 0x16
	// Bit mask of IM22 field.
	EXTI_IMR_IM22_Msk = 0x400000
	// Bit IM22.
	EXTI_IMR_IM22 = 0x400000
	// Interrupt request line is masked
	EXTI_IMR_IM22_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_IMR_IM22_Unmasked = 0x1
	// Position of IM23 field.
	EXTI_IMR_IM23_Pos = 0x17
	// Bit mask of IM23 field.
	EXTI_IMR_IM23_Msk = 0x800000
	// Bit IM23.
	EXTI_IMR_IM23 = 0x800000
	// Interrupt request line is masked
	EXTI_IMR_IM23_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_IMR_IM23_Unmasked = 0x1
	// Position of IM24 field.
	EXTI_IMR_IM24_Pos = 0x18
	// Bit mask of IM24 field.
	EXTI_IMR_IM24_Msk = 0x1000000
	// Bit IM24.
	EXTI_IMR_IM24 = 0x1000000
	// Interrupt request line is masked
	EXTI_IMR_IM24_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_IMR_IM24_Unmasked = 0x1
	// Position of IM25 field.
	EXTI_IMR_IM25_Pos = 0x19
	// Bit mask of IM25 field.
	EXTI_IMR_IM25_Msk = 0x2000000
	// Bit IM25.
	EXTI_IMR_IM25 = 0x2000000
	// Interrupt request line is masked
	EXTI_IMR_IM25_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_IMR_IM25_Unmasked = 0x1
	// Position of IM26 field.
	EXTI_IMR_IM26_Pos = 0x1a
	// Bit mask of IM26 field.
	EXTI_IMR_IM26_Msk = 0x4000000
	// Bit IM26.
	EXTI_IMR_IM26 = 0x4000000
	// Interrupt request line is masked
	EXTI_IMR_IM26_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_IMR_IM26_Unmasked = 0x1
	// Position of IM28 field.
	EXTI_IMR_IM28_Pos = 0x1c
	// Bit mask of IM28 field.
	EXTI_IMR_IM28_Msk = 0x10000000
	// Bit IM28.
	EXTI_IMR_IM28 = 0x10000000
	// Interrupt request line is masked
	EXTI_IMR_IM28_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_IMR_IM28_Unmasked = 0x1
	// Position of IM29 field.
	EXTI_IMR_IM29_Pos = 0x1d
	// Bit mask of IM29 field.
	EXTI_IMR_IM29_Msk = 0x20000000
	// Bit IM29.
	EXTI_IMR_IM29 = 0x20000000
	// Interrupt request line is masked
	EXTI_IMR_IM29_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_IMR_IM29_Unmasked = 0x1

	// EMR: Event mask register (EXTI_EMR)
	// Position of EM0 field.
	EXTI_EMR_EM0_Pos = 0x0
	// Bit mask of EM0 field.
	EXTI_EMR_EM0_Msk = 0x1
	// Bit EM0.
	EXTI_EMR_EM0 = 0x1
	// Interrupt request line is masked
	EXTI_EMR_EM0_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_EMR_EM0_Unmasked = 0x1
	// Position of EM1 field.
	EXTI_EMR_EM1_Pos = 0x1
	// Bit mask of EM1 field.
	EXTI_EMR_EM1_Msk = 0x2
	// Bit EM1.
	EXTI_EMR_EM1 = 0x2
	// Interrupt request line is masked
	EXTI_EMR_EM1_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_EMR_EM1_Unmasked = 0x1
	// Position of EM2 field.
	EXTI_EMR_EM2_Pos = 0x2
	// Bit mask of EM2 field.
	EXTI_EMR_EM2_Msk = 0x4
	// Bit EM2.
	EXTI_EMR_EM2 = 0x4
	// Interrupt request line is masked
	EXTI_EMR_EM2_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_EMR_EM2_Unmasked = 0x1
	// Position of EM3 field.
	EXTI_EMR_EM3_Pos = 0x3
	// Bit mask of EM3 field.
	EXTI_EMR_EM3_Msk = 0x8
	// Bit EM3.
	EXTI_EMR_EM3 = 0x8
	// Interrupt request line is masked
	EXTI_EMR_EM3_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_EMR_EM3_Unmasked = 0x1
	// Position of EM4 field.
	EXTI_EMR_EM4_Pos = 0x4
	// Bit mask of EM4 field.
	EXTI_EMR_EM4_Msk = 0x10
	// Bit EM4.
	EXTI_EMR_EM4 = 0x10
	// Interrupt request line is masked
	EXTI_EMR_EM4_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_EMR_EM4_Unmasked = 0x1
	// Position of EM5 field.
	EXTI_EMR_EM5_Pos = 0x5
	// Bit mask of EM5 field.
	EXTI_EMR_EM5_Msk = 0x20
	// Bit EM5.
	EXTI_EMR_EM5 = 0x20
	// Interrupt request line is masked
	EXTI_EMR_EM5_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_EMR_EM5_Unmasked = 0x1
	// Position of EM6 field.
	EXTI_EMR_EM6_Pos = 0x6
	// Bit mask of EM6 field.
	EXTI_EMR_EM6_Msk = 0x40
	// Bit EM6.
	EXTI_EMR_EM6 = 0x40
	// Interrupt request line is masked
	EXTI_EMR_EM6_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_EMR_EM6_Unmasked = 0x1
	// Position of EM7 field.
	EXTI_EMR_EM7_Pos = 0x7
	// Bit mask of EM7 field.
	EXTI_EMR_EM7_Msk = 0x80
	// Bit EM7.
	EXTI_EMR_EM7 = 0x80
	// Interrupt request line is masked
	EXTI_EMR_EM7_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_EMR_EM7_Unmasked = 0x1
	// Position of EM8 field.
	EXTI_EMR_EM8_Pos = 0x8
	// Bit mask of EM8 field.
	EXTI_EMR_EM8_Msk = 0x100
	// Bit EM8.
	EXTI_EMR_EM8 = 0x100
	// Interrupt request line is masked
	EXTI_EMR_EM8_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_EMR_EM8_Unmasked = 0x1
	// Position of EM9 field.
	EXTI_EMR_EM9_Pos = 0x9
	// Bit mask of EM9 field.
	EXTI_EMR_EM9_Msk = 0x200
	// Bit EM9.
	EXTI_EMR_EM9 = 0x200
	// Interrupt request line is masked
	EXTI_EMR_EM9_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_EMR_EM9_Unmasked = 0x1
	// Position of EM10 field.
	EXTI_EMR_EM10_Pos = 0xa
	// Bit mask of EM10 field.
	EXTI_EMR_EM10_Msk = 0x400
	// Bit EM10.
	EXTI_EMR_EM10 = 0x400
	// Interrupt request line is masked
	EXTI_EMR_EM10_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_EMR_EM10_Unmasked = 0x1
	// Position of EM11 field.
	EXTI_EMR_EM11_Pos = 0xb
	// Bit mask of EM11 field.
	EXTI_EMR_EM11_Msk = 0x800
	// Bit EM11.
	EXTI_EMR_EM11 = 0x800
	// Interrupt request line is masked
	EXTI_EMR_EM11_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_EMR_EM11_Unmasked = 0x1
	// Position of EM12 field.
	EXTI_EMR_EM12_Pos = 0xc
	// Bit mask of EM12 field.
	EXTI_EMR_EM12_Msk = 0x1000
	// Bit EM12.
	EXTI_EMR_EM12 = 0x1000
	// Interrupt request line is masked
	EXTI_EMR_EM12_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_EMR_EM12_Unmasked = 0x1
	// Position of EM13 field.
	EXTI_EMR_EM13_Pos = 0xd
	// Bit mask of EM13 field.
	EXTI_EMR_EM13_Msk = 0x2000
	// Bit EM13.
	EXTI_EMR_EM13 = 0x2000
	// Interrupt request line is masked
	EXTI_EMR_EM13_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_EMR_EM13_Unmasked = 0x1
	// Position of EM14 field.
	EXTI_EMR_EM14_Pos = 0xe
	// Bit mask of EM14 field.
	EXTI_EMR_EM14_Msk = 0x4000
	// Bit EM14.
	EXTI_EMR_EM14 = 0x4000
	// Interrupt request line is masked
	EXTI_EMR_EM14_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_EMR_EM14_Unmasked = 0x1
	// Position of EM15 field.
	EXTI_EMR_EM15_Pos = 0xf
	// Bit mask of EM15 field.
	EXTI_EMR_EM15_Msk = 0x8000
	// Bit EM15.
	EXTI_EMR_EM15 = 0x8000
	// Interrupt request line is masked
	EXTI_EMR_EM15_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_EMR_EM15_Unmasked = 0x1
	// Position of EM16 field.
	EXTI_EMR_EM16_Pos = 0x10
	// Bit mask of EM16 field.
	EXTI_EMR_EM16_Msk = 0x10000
	// Bit EM16.
	EXTI_EMR_EM16 = 0x10000
	// Interrupt request line is masked
	EXTI_EMR_EM16_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_EMR_EM16_Unmasked = 0x1
	// Position of EM17 field.
	EXTI_EMR_EM17_Pos = 0x11
	// Bit mask of EM17 field.
	EXTI_EMR_EM17_Msk = 0x20000
	// Bit EM17.
	EXTI_EMR_EM17 = 0x20000
	// Interrupt request line is masked
	EXTI_EMR_EM17_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_EMR_EM17_Unmasked = 0x1
	// Position of EM18 field.
	EXTI_EMR_EM18_Pos = 0x12
	// Bit mask of EM18 field.
	EXTI_EMR_EM18_Msk = 0x40000
	// Bit EM18.
	EXTI_EMR_EM18 = 0x40000
	// Interrupt request line is masked
	EXTI_EMR_EM18_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_EMR_EM18_Unmasked = 0x1
	// Position of EM19 field.
	EXTI_EMR_EM19_Pos = 0x13
	// Bit mask of EM19 field.
	EXTI_EMR_EM19_Msk = 0x80000
	// Bit EM19.
	EXTI_EMR_EM19 = 0x80000
	// Interrupt request line is masked
	EXTI_EMR_EM19_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_EMR_EM19_Unmasked = 0x1
	// Position of EM20 field.
	EXTI_EMR_EM20_Pos = 0x14
	// Bit mask of EM20 field.
	EXTI_EMR_EM20_Msk = 0x100000
	// Bit EM20.
	EXTI_EMR_EM20 = 0x100000
	// Interrupt request line is masked
	EXTI_EMR_EM20_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_EMR_EM20_Unmasked = 0x1
	// Position of EM21 field.
	EXTI_EMR_EM21_Pos = 0x15
	// Bit mask of EM21 field.
	EXTI_EMR_EM21_Msk = 0x200000
	// Bit EM21.
	EXTI_EMR_EM21 = 0x200000
	// Interrupt request line is masked
	EXTI_EMR_EM21_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_EMR_EM21_Unmasked = 0x1
	// Position of EM22 field.
	EXTI_EMR_EM22_Pos = 0x16
	// Bit mask of EM22 field.
	EXTI_EMR_EM22_Msk = 0x400000
	// Bit EM22.
	EXTI_EMR_EM22 = 0x400000
	// Interrupt request line is masked
	EXTI_EMR_EM22_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_EMR_EM22_Unmasked = 0x1
	// Position of EM23 field.
	EXTI_EMR_EM23_Pos = 0x17
	// Bit mask of EM23 field.
	EXTI_EMR_EM23_Msk = 0x800000
	// Bit EM23.
	EXTI_EMR_EM23 = 0x800000
	// Interrupt request line is masked
	EXTI_EMR_EM23_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_EMR_EM23_Unmasked = 0x1
	// Position of EM24 field.
	EXTI_EMR_EM24_Pos = 0x18
	// Bit mask of EM24 field.
	EXTI_EMR_EM24_Msk = 0x1000000
	// Bit EM24.
	EXTI_EMR_EM24 = 0x1000000
	// Interrupt request line is masked
	EXTI_EMR_EM24_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_EMR_EM24_Unmasked = 0x1
	// Position of EM25 field.
	EXTI_EMR_EM25_Pos = 0x19
	// Bit mask of EM25 field.
	EXTI_EMR_EM25_Msk = 0x2000000
	// Bit EM25.
	EXTI_EMR_EM25 = 0x2000000
	// Interrupt request line is masked
	EXTI_EMR_EM25_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_EMR_EM25_Unmasked = 0x1
	// Position of EM26 field.
	EXTI_EMR_EM26_Pos = 0x1a
	// Bit mask of EM26 field.
	EXTI_EMR_EM26_Msk = 0x4000000
	// Bit EM26.
	EXTI_EMR_EM26 = 0x4000000
	// Interrupt request line is masked
	EXTI_EMR_EM26_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_EMR_EM26_Unmasked = 0x1
	// Position of EM28 field.
	EXTI_EMR_EM28_Pos = 0x1c
	// Bit mask of EM28 field.
	EXTI_EMR_EM28_Msk = 0x10000000
	// Bit EM28.
	EXTI_EMR_EM28 = 0x10000000
	// Interrupt request line is masked
	EXTI_EMR_EM28_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_EMR_EM28_Unmasked = 0x1
	// Position of EM29 field.
	EXTI_EMR_EM29_Pos = 0x1d
	// Bit mask of EM29 field.
	EXTI_EMR_EM29_Msk = 0x20000000
	// Bit EM29.
	EXTI_EMR_EM29 = 0x20000000
	// Interrupt request line is masked
	EXTI_EMR_EM29_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_EMR_EM29_Unmasked = 0x1

	// RTSR: Rising Trigger selection register (EXTI_RTSR)
	// Position of RT0 field.
	EXTI_RTSR_RT0_Pos = 0x0
	// Bit mask of RT0 field.
	EXTI_RTSR_RT0_Msk = 0x1
	// Bit RT0.
	EXTI_RTSR_RT0 = 0x1
	// Rising edge trigger is disabled
	EXTI_RTSR_RT0_Disabled = 0x0
	// Rising edge trigger is enabled
	EXTI_RTSR_RT0_Enabled = 0x1
	// Position of RT1 field.
	EXTI_RTSR_RT1_Pos = 0x1
	// Bit mask of RT1 field.
	EXTI_RTSR_RT1_Msk = 0x2
	// Bit RT1.
	EXTI_RTSR_RT1 = 0x2
	// Rising edge trigger is disabled
	EXTI_RTSR_RT1_Disabled = 0x0
	// Rising edge trigger is enabled
	EXTI_RTSR_RT1_Enabled = 0x1
	// Position of RT2 field.
	EXTI_RTSR_RT2_Pos = 0x2
	// Bit mask of RT2 field.
	EXTI_RTSR_RT2_Msk = 0x4
	// Bit RT2.
	EXTI_RTSR_RT2 = 0x4
	// Rising edge trigger is disabled
	EXTI_RTSR_RT2_Disabled = 0x0
	// Rising edge trigger is enabled
	EXTI_RTSR_RT2_Enabled = 0x1
	// Position of RT3 field.
	EXTI_RTSR_RT3_Pos = 0x3
	// Bit mask of RT3 field.
	EXTI_RTSR_RT3_Msk = 0x8
	// Bit RT3.
	EXTI_RTSR_RT3 = 0x8
	// Rising edge trigger is disabled
	EXTI_RTSR_RT3_Disabled = 0x0
	// Rising edge trigger is enabled
	EXTI_RTSR_RT3_Enabled = 0x1
	// Position of RT4 field.
	EXTI_RTSR_RT4_Pos = 0x4
	// Bit mask of RT4 field.
	EXTI_RTSR_RT4_Msk = 0x10
	// Bit RT4.
	EXTI_RTSR_RT4 = 0x10
	// Rising edge trigger is disabled
	EXTI_RTSR_RT4_Disabled = 0x0
	// Rising edge trigger is enabled
	EXTI_RTSR_RT4_Enabled = 0x1
	// Position of RT5 field.
	EXTI_RTSR_RT5_Pos = 0x5
	// Bit mask of RT5 field.
	EXTI_RTSR_RT5_Msk = 0x20
	// Bit RT5.
	EXTI_RTSR_RT5 = 0x20
	// Rising edge trigger is disabled
	EXTI_RTSR_RT5_Disabled = 0x0
	// Rising edge trigger is enabled
	EXTI_RTSR_RT5_Enabled = 0x1
	// Position of RT6 field.
	EXTI_RTSR_RT6_Pos = 0x6
	// Bit mask of RT6 field.
	EXTI_RTSR_RT6_Msk = 0x40
	// Bit RT6.
	EXTI_RTSR_RT6 = 0x40
	// Rising edge trigger is disabled
	EXTI_RTSR_RT6_Disabled = 0x0
	// Rising edge trigger is enabled
	EXTI_RTSR_RT6_Enabled = 0x1
	// Position of RT7 field.
	EXTI_RTSR_RT7_Pos = 0x7
	// Bit mask of RT7 field.
	EXTI_RTSR_RT7_Msk = 0x80
	// Bit RT7.
	EXTI_RTSR_RT7 = 0x80
	// Rising edge trigger is disabled
	EXTI_RTSR_RT7_Disabled = 0x0
	// Rising edge trigger is enabled
	EXTI_RTSR_RT7_Enabled = 0x1
	// Position of RT8 field.
	EXTI_RTSR_RT8_Pos = 0x8
	// Bit mask of RT8 field.
	EXTI_RTSR_RT8_Msk = 0x100
	// Bit RT8.
	EXTI_RTSR_RT8 = 0x100
	// Rising edge trigger is disabled
	EXTI_RTSR_RT8_Disabled = 0x0
	// Rising edge trigger is enabled
	EXTI_RTSR_RT8_Enabled = 0x1
	// Position of RT9 field.
	EXTI_RTSR_RT9_Pos = 0x9
	// Bit mask of RT9 field.
	EXTI_RTSR_RT9_Msk = 0x200
	// Bit RT9.
	EXTI_RTSR_RT9 = 0x200
	// Rising edge trigger is disabled
	EXTI_RTSR_RT9_Disabled = 0x0
	// Rising edge trigger is enabled
	EXTI_RTSR_RT9_Enabled = 0x1
	// Position of RT10 field.
	EXTI_RTSR_RT10_Pos = 0xa
	// Bit mask of RT10 field.
	EXTI_RTSR_RT10_Msk = 0x400
	// Bit RT10.
	EXTI_RTSR_RT10 = 0x400
	// Rising edge trigger is disabled
	EXTI_RTSR_RT10_Disabled = 0x0
	// Rising edge trigger is enabled
	EXTI_RTSR_RT10_Enabled = 0x1
	// Position of RT11 field.
	EXTI_RTSR_RT11_Pos = 0xb
	// Bit mask of RT11 field.
	EXTI_RTSR_RT11_Msk = 0x800
	// Bit RT11.
	EXTI_RTSR_RT11 = 0x800
	// Rising edge trigger is disabled
	EXTI_RTSR_RT11_Disabled = 0x0
	// Rising edge trigger is enabled
	EXTI_RTSR_RT11_Enabled = 0x1
	// Position of RT12 field.
	EXTI_RTSR_RT12_Pos = 0xc
	// Bit mask of RT12 field.
	EXTI_RTSR_RT12_Msk = 0x1000
	// Bit RT12.
	EXTI_RTSR_RT12 = 0x1000
	// Rising edge trigger is disabled
	EXTI_RTSR_RT12_Disabled = 0x0
	// Rising edge trigger is enabled
	EXTI_RTSR_RT12_Enabled = 0x1
	// Position of RT13 field.
	EXTI_RTSR_RT13_Pos = 0xd
	// Bit mask of RT13 field.
	EXTI_RTSR_RT13_Msk = 0x2000
	// Bit RT13.
	EXTI_RTSR_RT13 = 0x2000
	// Rising edge trigger is disabled
	EXTI_RTSR_RT13_Disabled = 0x0
	// Rising edge trigger is enabled
	EXTI_RTSR_RT13_Enabled = 0x1
	// Position of RT14 field.
	EXTI_RTSR_RT14_Pos = 0xe
	// Bit mask of RT14 field.
	EXTI_RTSR_RT14_Msk = 0x4000
	// Bit RT14.
	EXTI_RTSR_RT14 = 0x4000
	// Rising edge trigger is disabled
	EXTI_RTSR_RT14_Disabled = 0x0
	// Rising edge trigger is enabled
	EXTI_RTSR_RT14_Enabled = 0x1
	// Position of RT15 field.
	EXTI_RTSR_RT15_Pos = 0xf
	// Bit mask of RT15 field.
	EXTI_RTSR_RT15_Msk = 0x8000
	// Bit RT15.
	EXTI_RTSR_RT15 = 0x8000
	// Rising edge trigger is disabled
	EXTI_RTSR_RT15_Disabled = 0x0
	// Rising edge trigger is enabled
	EXTI_RTSR_RT15_Enabled = 0x1
	// Position of RT16 field.
	EXTI_RTSR_RT16_Pos = 0x10
	// Bit mask of RT16 field.
	EXTI_RTSR_RT16_Msk = 0x10000
	// Bit RT16.
	EXTI_RTSR_RT16 = 0x10000
	// Rising edge trigger is disabled
	EXTI_RTSR_RT16_Disabled = 0x0
	// Rising edge trigger is enabled
	EXTI_RTSR_RT16_Enabled = 0x1
	// Position of RT17 field.
	EXTI_RTSR_RT17_Pos = 0x11
	// Bit mask of RT17 field.
	EXTI_RTSR_RT17_Msk = 0x20000
	// Bit RT17.
	EXTI_RTSR_RT17 = 0x20000
	// Rising edge trigger is disabled
	EXTI_RTSR_RT17_Disabled = 0x0
	// Rising edge trigger is enabled
	EXTI_RTSR_RT17_Enabled = 0x1
	// Position of RT19 field.
	EXTI_RTSR_RT19_Pos = 0x13
	// Bit mask of RT19 field.
	EXTI_RTSR_RT19_Msk = 0x80000
	// Bit RT19.
	EXTI_RTSR_RT19 = 0x80000
	// Rising edge trigger is disabled
	EXTI_RTSR_RT19_Disabled = 0x0
	// Rising edge trigger is enabled
	EXTI_RTSR_RT19_Enabled = 0x1
	// Position of RT20 field.
	EXTI_RTSR_RT20_Pos = 0x14
	// Bit mask of RT20 field.
	EXTI_RTSR_RT20_Msk = 0x100000
	// Bit RT20.
	EXTI_RTSR_RT20 = 0x100000
	// Rising edge trigger is disabled
	EXTI_RTSR_RT20_Disabled = 0x0
	// Rising edge trigger is enabled
	EXTI_RTSR_RT20_Enabled = 0x1
	// Position of RT21 field.
	EXTI_RTSR_RT21_Pos = 0x15
	// Bit mask of RT21 field.
	EXTI_RTSR_RT21_Msk = 0x200000
	// Bit RT21.
	EXTI_RTSR_RT21 = 0x200000
	// Rising edge trigger is disabled
	EXTI_RTSR_RT21_Disabled = 0x0
	// Rising edge trigger is enabled
	EXTI_RTSR_RT21_Enabled = 0x1
	// Position of RT22 field.
	EXTI_RTSR_RT22_Pos = 0x16
	// Bit mask of RT22 field.
	EXTI_RTSR_RT22_Msk = 0x400000
	// Bit RT22.
	EXTI_RTSR_RT22 = 0x400000
	// Rising edge trigger is disabled
	EXTI_RTSR_RT22_Disabled = 0x0
	// Rising edge trigger is enabled
	EXTI_RTSR_RT22_Enabled = 0x1

	// FTSR: Falling Trigger selection register (EXTI_FTSR)
	// Position of FT0 field.
	EXTI_FTSR_FT0_Pos = 0x0
	// Bit mask of FT0 field.
	EXTI_FTSR_FT0_Msk = 0x1
	// Bit FT0.
	EXTI_FTSR_FT0 = 0x1
	// Falling edge trigger is disabled
	EXTI_FTSR_FT0_Disabled = 0x0
	// Falling edge trigger is enabled
	EXTI_FTSR_FT0_Enabled = 0x1
	// Position of FT1 field.
	EXTI_FTSR_FT1_Pos = 0x1
	// Bit mask of FT1 field.
	EXTI_FTSR_FT1_Msk = 0x2
	// Bit FT1.
	EXTI_FTSR_FT1 = 0x2
	// Falling edge trigger is disabled
	EXTI_FTSR_FT1_Disabled = 0x0
	// Falling edge trigger is enabled
	EXTI_FTSR_FT1_Enabled = 0x1
	// Position of FT2 field.
	EXTI_FTSR_FT2_Pos = 0x2
	// Bit mask of FT2 field.
	EXTI_FTSR_FT2_Msk = 0x4
	// Bit FT2.
	EXTI_FTSR_FT2 = 0x4
	// Falling edge trigger is disabled
	EXTI_FTSR_FT2_Disabled = 0x0
	// Falling edge trigger is enabled
	EXTI_FTSR_FT2_Enabled = 0x1
	// Position of FT3 field.
	EXTI_FTSR_FT3_Pos = 0x3
	// Bit mask of FT3 field.
	EXTI_FTSR_FT3_Msk = 0x8
	// Bit FT3.
	EXTI_FTSR_FT3 = 0x8
	// Falling edge trigger is disabled
	EXTI_FTSR_FT3_Disabled = 0x0
	// Falling edge trigger is enabled
	EXTI_FTSR_FT3_Enabled = 0x1
	// Position of FT4 field.
	EXTI_FTSR_FT4_Pos = 0x4
	// Bit mask of FT4 field.
	EXTI_FTSR_FT4_Msk = 0x10
	// Bit FT4.
	EXTI_FTSR_FT4 = 0x10
	// Falling edge trigger is disabled
	EXTI_FTSR_FT4_Disabled = 0x0
	// Falling edge trigger is enabled
	EXTI_FTSR_FT4_Enabled = 0x1
	// Position of FT5 field.
	EXTI_FTSR_FT5_Pos = 0x5
	// Bit mask of FT5 field.
	EXTI_FTSR_FT5_Msk = 0x20
	// Bit FT5.
	EXTI_FTSR_FT5 = 0x20
	// Falling edge trigger is disabled
	EXTI_FTSR_FT5_Disabled = 0x0
	// Falling edge trigger is enabled
	EXTI_FTSR_FT5_Enabled = 0x1
	// Position of FT6 field.
	EXTI_FTSR_FT6_Pos = 0x6
	// Bit mask of FT6 field.
	EXTI_FTSR_FT6_Msk = 0x40
	// Bit FT6.
	EXTI_FTSR_FT6 = 0x40
	// Falling edge trigger is disabled
	EXTI_FTSR_FT6_Disabled = 0x0
	// Falling edge trigger is enabled
	EXTI_FTSR_FT6_Enabled = 0x1
	// Position of FT7 field.
	EXTI_FTSR_FT7_Pos = 0x7
	// Bit mask of FT7 field.
	EXTI_FTSR_FT7_Msk = 0x80
	// Bit FT7.
	EXTI_FTSR_FT7 = 0x80
	// Falling edge trigger is disabled
	EXTI_FTSR_FT7_Disabled = 0x0
	// Falling edge trigger is enabled
	EXTI_FTSR_FT7_Enabled = 0x1
	// Position of FT8 field.
	EXTI_FTSR_FT8_Pos = 0x8
	// Bit mask of FT8 field.
	EXTI_FTSR_FT8_Msk = 0x100
	// Bit FT8.
	EXTI_FTSR_FT8 = 0x100
	// Falling edge trigger is disabled
	EXTI_FTSR_FT8_Disabled = 0x0
	// Falling edge trigger is enabled
	EXTI_FTSR_FT8_Enabled = 0x1
	// Position of FT9 field.
	EXTI_FTSR_FT9_Pos = 0x9
	// Bit mask of FT9 field.
	EXTI_FTSR_FT9_Msk = 0x200
	// Bit FT9.
	EXTI_FTSR_FT9 = 0x200
	// Falling edge trigger is disabled
	EXTI_FTSR_FT9_Disabled = 0x0
	// Falling edge trigger is enabled
	EXTI_FTSR_FT9_Enabled = 0x1
	// Position of FT10 field.
	EXTI_FTSR_FT10_Pos = 0xa
	// Bit mask of FT10 field.
	EXTI_FTSR_FT10_Msk = 0x400
	// Bit FT10.
	EXTI_FTSR_FT10 = 0x400
	// Falling edge trigger is disabled
	EXTI_FTSR_FT10_Disabled = 0x0
	// Falling edge trigger is enabled
	EXTI_FTSR_FT10_Enabled = 0x1
	// Position of FT11 field.
	EXTI_FTSR_FT11_Pos = 0xb
	// Bit mask of FT11 field.
	EXTI_FTSR_FT11_Msk = 0x800
	// Bit FT11.
	EXTI_FTSR_FT11 = 0x800
	// Falling edge trigger is disabled
	EXTI_FTSR_FT11_Disabled = 0x0
	// Falling edge trigger is enabled
	EXTI_FTSR_FT11_Enabled = 0x1
	// Position of FT12 field.
	EXTI_FTSR_FT12_Pos = 0xc
	// Bit mask of FT12 field.
	EXTI_FTSR_FT12_Msk = 0x1000
	// Bit FT12.
	EXTI_FTSR_FT12 = 0x1000
	// Falling edge trigger is disabled
	EXTI_FTSR_FT12_Disabled = 0x0
	// Falling edge trigger is enabled
	EXTI_FTSR_FT12_Enabled = 0x1
	// Position of FT13 field.
	EXTI_FTSR_FT13_Pos = 0xd
	// Bit mask of FT13 field.
	EXTI_FTSR_FT13_Msk = 0x2000
	// Bit FT13.
	EXTI_FTSR_FT13 = 0x2000
	// Falling edge trigger is disabled
	EXTI_FTSR_FT13_Disabled = 0x0
	// Falling edge trigger is enabled
	EXTI_FTSR_FT13_Enabled = 0x1
	// Position of FT14 field.
	EXTI_FTSR_FT14_Pos = 0xe
	// Bit mask of FT14 field.
	EXTI_FTSR_FT14_Msk = 0x4000
	// Bit FT14.
	EXTI_FTSR_FT14 = 0x4000
	// Falling edge trigger is disabled
	EXTI_FTSR_FT14_Disabled = 0x0
	// Falling edge trigger is enabled
	EXTI_FTSR_FT14_Enabled = 0x1
	// Position of FT15 field.
	EXTI_FTSR_FT15_Pos = 0xf
	// Bit mask of FT15 field.
	EXTI_FTSR_FT15_Msk = 0x8000
	// Bit FT15.
	EXTI_FTSR_FT15 = 0x8000
	// Falling edge trigger is disabled
	EXTI_FTSR_FT15_Disabled = 0x0
	// Falling edge trigger is enabled
	EXTI_FTSR_FT15_Enabled = 0x1
	// Position of FT16 field.
	EXTI_FTSR_FT16_Pos = 0x10
	// Bit mask of FT16 field.
	EXTI_FTSR_FT16_Msk = 0x10000
	// Bit FT16.
	EXTI_FTSR_FT16 = 0x10000
	// Falling edge trigger is disabled
	EXTI_FTSR_FT16_Disabled = 0x0
	// Falling edge trigger is enabled
	EXTI_FTSR_FT16_Enabled = 0x1
	// Position of FT17 field.
	EXTI_FTSR_FT17_Pos = 0x11
	// Bit mask of FT17 field.
	EXTI_FTSR_FT17_Msk = 0x20000
	// Bit FT17.
	EXTI_FTSR_FT17 = 0x20000
	// Falling edge trigger is disabled
	EXTI_FTSR_FT17_Disabled = 0x0
	// Falling edge trigger is enabled
	EXTI_FTSR_FT17_Enabled = 0x1
	// Position of FT19 field.
	EXTI_FTSR_FT19_Pos = 0x13
	// Bit mask of FT19 field.
	EXTI_FTSR_FT19_Msk = 0x80000
	// Bit FT19.
	EXTI_FTSR_FT19 = 0x80000
	// Falling edge trigger is disabled
	EXTI_FTSR_FT19_Disabled = 0x0
	// Falling edge trigger is enabled
	EXTI_FTSR_FT19_Enabled = 0x1
	// Position of FT20 field.
	EXTI_FTSR_FT20_Pos = 0x14
	// Bit mask of FT20 field.
	EXTI_FTSR_FT20_Msk = 0x100000
	// Bit FT20.
	EXTI_FTSR_FT20 = 0x100000
	// Falling edge trigger is disabled
	EXTI_FTSR_FT20_Disabled = 0x0
	// Falling edge trigger is enabled
	EXTI_FTSR_FT20_Enabled = 0x1
	// Position of FT21 field.
	EXTI_FTSR_FT21_Pos = 0x15
	// Bit mask of FT21 field.
	EXTI_FTSR_FT21_Msk = 0x200000
	// Bit FT21.
	EXTI_FTSR_FT21 = 0x200000
	// Falling edge trigger is disabled
	EXTI_FTSR_FT21_Disabled = 0x0
	// Falling edge trigger is enabled
	EXTI_FTSR_FT21_Enabled = 0x1
	// Position of FT22 field.
	EXTI_FTSR_FT22_Pos = 0x16
	// Bit mask of FT22 field.
	EXTI_FTSR_FT22_Msk = 0x400000
	// Bit FT22.
	EXTI_FTSR_FT22 = 0x400000
	// Falling edge trigger is disabled
	EXTI_FTSR_FT22_Disabled = 0x0
	// Falling edge trigger is enabled
	EXTI_FTSR_FT22_Enabled = 0x1

	// SWIER: Software interrupt event register (EXTI_SWIER)
	// Position of SWI0 field.
	EXTI_SWIER_SWI0_Pos = 0x0
	// Bit mask of SWI0 field.
	EXTI_SWIER_SWI0_Msk = 0x1
	// Bit SWI0.
	EXTI_SWIER_SWI0 = 0x1
	// Generates an interrupt request
	EXTI_SWIER_SWI0_Pend = 0x1
	// Position of SWI1 field.
	EXTI_SWIER_SWI1_Pos = 0x1
	// Bit mask of SWI1 field.
	EXTI_SWIER_SWI1_Msk = 0x2
	// Bit SWI1.
	EXTI_SWIER_SWI1 = 0x2
	// Generates an interrupt request
	EXTI_SWIER_SWI1_Pend = 0x1
	// Position of SWI2 field.
	EXTI_SWIER_SWI2_Pos = 0x2
	// Bit mask of SWI2 field.
	EXTI_SWIER_SWI2_Msk = 0x4
	// Bit SWI2.
	EXTI_SWIER_SWI2 = 0x4
	// Generates an interrupt request
	EXTI_SWIER_SWI2_Pend = 0x1
	// Position of SWI3 field.
	EXTI_SWIER_SWI3_Pos = 0x3
	// Bit mask of SWI3 field.
	EXTI_SWIER_SWI3_Msk = 0x8
	// Bit SWI3.
	EXTI_SWIER_SWI3 = 0x8
	// Generates an interrupt request
	EXTI_SWIER_SWI3_Pend = 0x1
	// Position of SWI4 field.
	EXTI_SWIER_SWI4_Pos = 0x4
	// Bit mask of SWI4 field.
	EXTI_SWIER_SWI4_Msk = 0x10
	// Bit SWI4.
	EXTI_SWIER_SWI4 = 0x10
	// Generates an interrupt request
	EXTI_SWIER_SWI4_Pend = 0x1
	// Position of SWI5 field.
	EXTI_SWIER_SWI5_Pos = 0x5
	// Bit mask of SWI5 field.
	EXTI_SWIER_SWI5_Msk = 0x20
	// Bit SWI5.
	EXTI_SWIER_SWI5 = 0x20
	// Generates an interrupt request
	EXTI_SWIER_SWI5_Pend = 0x1
	// Position of SWI6 field.
	EXTI_SWIER_SWI6_Pos = 0x6
	// Bit mask of SWI6 field.
	EXTI_SWIER_SWI6_Msk = 0x40
	// Bit SWI6.
	EXTI_SWIER_SWI6 = 0x40
	// Generates an interrupt request
	EXTI_SWIER_SWI6_Pend = 0x1
	// Position of SWI7 field.
	EXTI_SWIER_SWI7_Pos = 0x7
	// Bit mask of SWI7 field.
	EXTI_SWIER_SWI7_Msk = 0x80
	// Bit SWI7.
	EXTI_SWIER_SWI7 = 0x80
	// Generates an interrupt request
	EXTI_SWIER_SWI7_Pend = 0x1
	// Position of SWI8 field.
	EXTI_SWIER_SWI8_Pos = 0x8
	// Bit mask of SWI8 field.
	EXTI_SWIER_SWI8_Msk = 0x100
	// Bit SWI8.
	EXTI_SWIER_SWI8 = 0x100
	// Generates an interrupt request
	EXTI_SWIER_SWI8_Pend = 0x1
	// Position of SWI9 field.
	EXTI_SWIER_SWI9_Pos = 0x9
	// Bit mask of SWI9 field.
	EXTI_SWIER_SWI9_Msk = 0x200
	// Bit SWI9.
	EXTI_SWIER_SWI9 = 0x200
	// Generates an interrupt request
	EXTI_SWIER_SWI9_Pend = 0x1
	// Position of SWI10 field.
	EXTI_SWIER_SWI10_Pos = 0xa
	// Bit mask of SWI10 field.
	EXTI_SWIER_SWI10_Msk = 0x400
	// Bit SWI10.
	EXTI_SWIER_SWI10 = 0x400
	// Generates an interrupt request
	EXTI_SWIER_SWI10_Pend = 0x1
	// Position of SWI11 field.
	EXTI_SWIER_SWI11_Pos = 0xb
	// Bit mask of SWI11 field.
	EXTI_SWIER_SWI11_Msk = 0x800
	// Bit SWI11.
	EXTI_SWIER_SWI11 = 0x800
	// Generates an interrupt request
	EXTI_SWIER_SWI11_Pend = 0x1
	// Position of SWI12 field.
	EXTI_SWIER_SWI12_Pos = 0xc
	// Bit mask of SWI12 field.
	EXTI_SWIER_SWI12_Msk = 0x1000
	// Bit SWI12.
	EXTI_SWIER_SWI12 = 0x1000
	// Generates an interrupt request
	EXTI_SWIER_SWI12_Pend = 0x1
	// Position of SWI13 field.
	EXTI_SWIER_SWI13_Pos = 0xd
	// Bit mask of SWI13 field.
	EXTI_SWIER_SWI13_Msk = 0x2000
	// Bit SWI13.
	EXTI_SWIER_SWI13 = 0x2000
	// Generates an interrupt request
	EXTI_SWIER_SWI13_Pend = 0x1
	// Position of SWI14 field.
	EXTI_SWIER_SWI14_Pos = 0xe
	// Bit mask of SWI14 field.
	EXTI_SWIER_SWI14_Msk = 0x4000
	// Bit SWI14.
	EXTI_SWIER_SWI14 = 0x4000
	// Generates an interrupt request
	EXTI_SWIER_SWI14_Pend = 0x1
	// Position of SWI15 field.
	EXTI_SWIER_SWI15_Pos = 0xf
	// Bit mask of SWI15 field.
	EXTI_SWIER_SWI15_Msk = 0x8000
	// Bit SWI15.
	EXTI_SWIER_SWI15 = 0x8000
	// Generates an interrupt request
	EXTI_SWIER_SWI15_Pend = 0x1
	// Position of SWI16 field.
	EXTI_SWIER_SWI16_Pos = 0x10
	// Bit mask of SWI16 field.
	EXTI_SWIER_SWI16_Msk = 0x10000
	// Bit SWI16.
	EXTI_SWIER_SWI16 = 0x10000
	// Generates an interrupt request
	EXTI_SWIER_SWI16_Pend = 0x1
	// Position of SWI17 field.
	EXTI_SWIER_SWI17_Pos = 0x11
	// Bit mask of SWI17 field.
	EXTI_SWIER_SWI17_Msk = 0x20000
	// Bit SWI17.
	EXTI_SWIER_SWI17 = 0x20000
	// Generates an interrupt request
	EXTI_SWIER_SWI17_Pend = 0x1
	// Position of SWI19 field.
	EXTI_SWIER_SWI19_Pos = 0x13
	// Bit mask of SWI19 field.
	EXTI_SWIER_SWI19_Msk = 0x80000
	// Bit SWI19.
	EXTI_SWIER_SWI19 = 0x80000
	// Generates an interrupt request
	EXTI_SWIER_SWI19_Pend = 0x1
	// Position of SWI20 field.
	EXTI_SWIER_SWI20_Pos = 0x14
	// Bit mask of SWI20 field.
	EXTI_SWIER_SWI20_Msk = 0x100000
	// Bit SWI20.
	EXTI_SWIER_SWI20 = 0x100000
	// Generates an interrupt request
	EXTI_SWIER_SWI20_Pend = 0x1
	// Position of SWI21 field.
	EXTI_SWIER_SWI21_Pos = 0x15
	// Bit mask of SWI21 field.
	EXTI_SWIER_SWI21_Msk = 0x200000
	// Bit SWI21.
	EXTI_SWIER_SWI21 = 0x200000
	// Generates an interrupt request
	EXTI_SWIER_SWI21_Pend = 0x1
	// Position of SWI22 field.
	EXTI_SWIER_SWI22_Pos = 0x16
	// Bit mask of SWI22 field.
	EXTI_SWIER_SWI22_Msk = 0x400000
	// Bit SWI22.
	EXTI_SWIER_SWI22 = 0x400000
	// Generates an interrupt request
	EXTI_SWIER_SWI22_Pend = 0x1

	// PR: Pending register (EXTI_PR)
	// Position of PIF0 field.
	EXTI_PR_PIF0_Pos = 0x0
	// Bit mask of PIF0 field.
	EXTI_PR_PIF0_Msk = 0x1
	// Bit PIF0.
	EXTI_PR_PIF0 = 0x1
	// No trigger request occurred
	EXTI_PR_PIF0_NotPending = 0x0
	// Selected trigger request occurred
	EXTI_PR_PIF0_Pending = 0x1
	// Clears pending bit
	EXTI_PR_PIF0_Clear = 0x1
	// Position of PIF1 field.
	EXTI_PR_PIF1_Pos = 0x1
	// Bit mask of PIF1 field.
	EXTI_PR_PIF1_Msk = 0x2
	// Bit PIF1.
	EXTI_PR_PIF1 = 0x2
	// No trigger request occurred
	EXTI_PR_PIF1_NotPending = 0x0
	// Selected trigger request occurred
	EXTI_PR_PIF1_Pending = 0x1
	// Clears pending bit
	EXTI_PR_PIF1_Clear = 0x1
	// Position of PIF2 field.
	EXTI_PR_PIF2_Pos = 0x2
	// Bit mask of PIF2 field.
	EXTI_PR_PIF2_Msk = 0x4
	// Bit PIF2.
	EXTI_PR_PIF2 = 0x4
	// No trigger request occurred
	EXTI_PR_PIF2_NotPending = 0x0
	// Selected trigger request occurred
	EXTI_PR_PIF2_Pending = 0x1
	// Clears pending bit
	EXTI_PR_PIF2_Clear = 0x1
	// Position of PIF3 field.
	EXTI_PR_PIF3_Pos = 0x3
	// Bit mask of PIF3 field.
	EXTI_PR_PIF3_Msk = 0x8
	// Bit PIF3.
	EXTI_PR_PIF3 = 0x8
	// No trigger request occurred
	EXTI_PR_PIF3_NotPending = 0x0
	// Selected trigger request occurred
	EXTI_PR_PIF3_Pending = 0x1
	// Clears pending bit
	EXTI_PR_PIF3_Clear = 0x1
	// Position of PIF4 field.
	EXTI_PR_PIF4_Pos = 0x4
	// Bit mask of PIF4 field.
	EXTI_PR_PIF4_Msk = 0x10
	// Bit PIF4.
	EXTI_PR_PIF4 = 0x10
	// No trigger request occurred
	EXTI_PR_PIF4_NotPending = 0x0
	// Selected trigger request occurred
	EXTI_PR_PIF4_Pending = 0x1
	// Clears pending bit
	EXTI_PR_PIF4_Clear = 0x1
	// Position of PIF5 field.
	EXTI_PR_PIF5_Pos = 0x5
	// Bit mask of PIF5 field.
	EXTI_PR_PIF5_Msk = 0x20
	// Bit PIF5.
	EXTI_PR_PIF5 = 0x20
	// No trigger request occurred
	EXTI_PR_PIF5_NotPending = 0x0
	// Selected trigger request occurred
	EXTI_PR_PIF5_Pending = 0x1
	// Clears pending bit
	EXTI_PR_PIF5_Clear = 0x1
	// Position of PIF6 field.
	EXTI_PR_PIF6_Pos = 0x6
	// Bit mask of PIF6 field.
	EXTI_PR_PIF6_Msk = 0x40
	// Bit PIF6.
	EXTI_PR_PIF6 = 0x40
	// No trigger request occurred
	EXTI_PR_PIF6_NotPending = 0x0
	// Selected trigger request occurred
	EXTI_PR_PIF6_Pending = 0x1
	// Clears pending bit
	EXTI_PR_PIF6_Clear = 0x1
	// Position of PIF7 field.
	EXTI_PR_PIF7_Pos = 0x7
	// Bit mask of PIF7 field.
	EXTI_PR_PIF7_Msk = 0x80
	// Bit PIF7.
	EXTI_PR_PIF7 = 0x80
	// No trigger request occurred
	EXTI_PR_PIF7_NotPending = 0x0
	// Selected trigger request occurred
	EXTI_PR_PIF7_Pending = 0x1
	// Clears pending bit
	EXTI_PR_PIF7_Clear = 0x1
	// Position of PIF8 field.
	EXTI_PR_PIF8_Pos = 0x8
	// Bit mask of PIF8 field.
	EXTI_PR_PIF8_Msk = 0x100
	// Bit PIF8.
	EXTI_PR_PIF8 = 0x100
	// No trigger request occurred
	EXTI_PR_PIF8_NotPending = 0x0
	// Selected trigger request occurred
	EXTI_PR_PIF8_Pending = 0x1
	// Clears pending bit
	EXTI_PR_PIF8_Clear = 0x1
	// Position of PIF9 field.
	EXTI_PR_PIF9_Pos = 0x9
	// Bit mask of PIF9 field.
	EXTI_PR_PIF9_Msk = 0x200
	// Bit PIF9.
	EXTI_PR_PIF9 = 0x200
	// No trigger request occurred
	EXTI_PR_PIF9_NotPending = 0x0
	// Selected trigger request occurred
	EXTI_PR_PIF9_Pending = 0x1
	// Clears pending bit
	EXTI_PR_PIF9_Clear = 0x1
	// Position of PIF10 field.
	EXTI_PR_PIF10_Pos = 0xa
	// Bit mask of PIF10 field.
	EXTI_PR_PIF10_Msk = 0x400
	// Bit PIF10.
	EXTI_PR_PIF10 = 0x400
	// No trigger request occurred
	EXTI_PR_PIF10_NotPending = 0x0
	// Selected trigger request occurred
	EXTI_PR_PIF10_Pending = 0x1
	// Clears pending bit
	EXTI_PR_PIF10_Clear = 0x1
	// Position of PIF11 field.
	EXTI_PR_PIF11_Pos = 0xb
	// Bit mask of PIF11 field.
	EXTI_PR_PIF11_Msk = 0x800
	// Bit PIF11.
	EXTI_PR_PIF11 = 0x800
	// No trigger request occurred
	EXTI_PR_PIF11_NotPending = 0x0
	// Selected trigger request occurred
	EXTI_PR_PIF11_Pending = 0x1
	// Clears pending bit
	EXTI_PR_PIF11_Clear = 0x1
	// Position of PIF12 field.
	EXTI_PR_PIF12_Pos = 0xc
	// Bit mask of PIF12 field.
	EXTI_PR_PIF12_Msk = 0x1000
	// Bit PIF12.
	EXTI_PR_PIF12 = 0x1000
	// No trigger request occurred
	EXTI_PR_PIF12_NotPending = 0x0
	// Selected trigger request occurred
	EXTI_PR_PIF12_Pending = 0x1
	// Clears pending bit
	EXTI_PR_PIF12_Clear = 0x1
	// Position of PIF13 field.
	EXTI_PR_PIF13_Pos = 0xd
	// Bit mask of PIF13 field.
	EXTI_PR_PIF13_Msk = 0x2000
	// Bit PIF13.
	EXTI_PR_PIF13 = 0x2000
	// No trigger request occurred
	EXTI_PR_PIF13_NotPending = 0x0
	// Selected trigger request occurred
	EXTI_PR_PIF13_Pending = 0x1
	// Clears pending bit
	EXTI_PR_PIF13_Clear = 0x1
	// Position of PIF14 field.
	EXTI_PR_PIF14_Pos = 0xe
	// Bit mask of PIF14 field.
	EXTI_PR_PIF14_Msk = 0x4000
	// Bit PIF14.
	EXTI_PR_PIF14 = 0x4000
	// No trigger request occurred
	EXTI_PR_PIF14_NotPending = 0x0
	// Selected trigger request occurred
	EXTI_PR_PIF14_Pending = 0x1
	// Clears pending bit
	EXTI_PR_PIF14_Clear = 0x1
	// Position of PIF15 field.
	EXTI_PR_PIF15_Pos = 0xf
	// Bit mask of PIF15 field.
	EXTI_PR_PIF15_Msk = 0x8000
	// Bit PIF15.
	EXTI_PR_PIF15 = 0x8000
	// No trigger request occurred
	EXTI_PR_PIF15_NotPending = 0x0
	// Selected trigger request occurred
	EXTI_PR_PIF15_Pending = 0x1
	// Clears pending bit
	EXTI_PR_PIF15_Clear = 0x1
	// Position of PIF16 field.
	EXTI_PR_PIF16_Pos = 0x10
	// Bit mask of PIF16 field.
	EXTI_PR_PIF16_Msk = 0x10000
	// Bit PIF16.
	EXTI_PR_PIF16 = 0x10000
	// No trigger request occurred
	EXTI_PR_PIF16_NotPending = 0x0
	// Selected trigger request occurred
	EXTI_PR_PIF16_Pending = 0x1
	// Clears pending bit
	EXTI_PR_PIF16_Clear = 0x1
	// Position of PIF17 field.
	EXTI_PR_PIF17_Pos = 0x11
	// Bit mask of PIF17 field.
	EXTI_PR_PIF17_Msk = 0x20000
	// Bit PIF17.
	EXTI_PR_PIF17 = 0x20000
	// No trigger request occurred
	EXTI_PR_PIF17_NotPending = 0x0
	// Selected trigger request occurred
	EXTI_PR_PIF17_Pending = 0x1
	// Clears pending bit
	EXTI_PR_PIF17_Clear = 0x1
	// Position of PIF19 field.
	EXTI_PR_PIF19_Pos = 0x13
	// Bit mask of PIF19 field.
	EXTI_PR_PIF19_Msk = 0x80000
	// Bit PIF19.
	EXTI_PR_PIF19 = 0x80000
	// No trigger request occurred
	EXTI_PR_PIF19_NotPending = 0x0
	// Selected trigger request occurred
	EXTI_PR_PIF19_Pending = 0x1
	// Clears pending bit
	EXTI_PR_PIF19_Clear = 0x1
	// Position of PIF20 field.
	EXTI_PR_PIF20_Pos = 0x14
	// Bit mask of PIF20 field.
	EXTI_PR_PIF20_Msk = 0x100000
	// Bit PIF20.
	EXTI_PR_PIF20 = 0x100000
	// No trigger request occurred
	EXTI_PR_PIF20_NotPending = 0x0
	// Selected trigger request occurred
	EXTI_PR_PIF20_Pending = 0x1
	// Clears pending bit
	EXTI_PR_PIF20_Clear = 0x1
	// Position of PIF21 field.
	EXTI_PR_PIF21_Pos = 0x15
	// Bit mask of PIF21 field.
	EXTI_PR_PIF21_Msk = 0x200000
	// Bit PIF21.
	EXTI_PR_PIF21 = 0x200000
	// No trigger request occurred
	EXTI_PR_PIF21_NotPending = 0x0
	// Selected trigger request occurred
	EXTI_PR_PIF21_Pending = 0x1
	// Clears pending bit
	EXTI_PR_PIF21_Clear = 0x1
	// Position of PIF22 field.
	EXTI_PR_PIF22_Pos = 0x16
	// Bit mask of PIF22 field.
	EXTI_PR_PIF22_Msk = 0x400000
	// Bit PIF22.
	EXTI_PR_PIF22 = 0x400000
	// No trigger request occurred
	EXTI_PR_PIF22_NotPending = 0x0
	// Selected trigger request occurred
	EXTI_PR_PIF22_Pending = 0x1
	// Clears pending bit
	EXTI_PR_PIF22_Clear = 0x1
)

// Bitfields for ADC: Analog-to-digital converter
const (
	// ISR: interrupt and status register
	// Position of ADRDY field.
	ADC_ISR_ADRDY_Pos = 0x0
	// Bit mask of ADRDY field.
	ADC_ISR_ADRDY_Msk = 0x1
	// Bit ADRDY.
	ADC_ISR_ADRDY = 0x1
	// ADC not yet ready to start conversion
	ADC_ISR_ADRDY_NotReady = 0x0
	// ADC ready to start conversion
	ADC_ISR_ADRDY_Ready = 0x1
	// Clear the ADC ready flag
	ADC_ISR_ADRDY_Clear = 0x1
	// Position of EOSMP field.
	ADC_ISR_EOSMP_Pos = 0x1
	// Bit mask of EOSMP field.
	ADC_ISR_EOSMP_Msk = 0x2
	// Bit EOSMP.
	ADC_ISR_EOSMP = 0x2
	// Not at the end of the samplings phase
	ADC_ISR_EOSMP_NotAtEnd = 0x0
	// End of sampling phase reached
	ADC_ISR_EOSMP_AtEnd = 0x1
	// Clear the sampling phase flag
	ADC_ISR_EOSMP_Clear = 0x1
	// Position of EOC field.
	ADC_ISR_EOC_Pos = 0x2
	// Bit mask of EOC field.
	ADC_ISR_EOC_Msk = 0x4
	// Bit EOC.
	ADC_ISR_EOC = 0x4
	// Channel conversion is not complete
	ADC_ISR_EOC_NotComplete = 0x0
	// Channel conversion complete
	ADC_ISR_EOC_Complete = 0x1
	// Clear the channel conversion flag
	ADC_ISR_EOC_Clear = 0x1
	// Position of EOS field.
	ADC_ISR_EOS_Pos = 0x3
	// Bit mask of EOS field.
	ADC_ISR_EOS_Msk = 0x8
	// Bit EOS.
	ADC_ISR_EOS = 0x8
	// Conversion sequence is not complete
	ADC_ISR_EOS_NotComplete = 0x0
	// Conversion sequence complete
	ADC_ISR_EOS_Complete = 0x1
	// Clear the conversion sequence flag
	ADC_ISR_EOS_Clear = 0x1
	// Position of OVR field.
	ADC_ISR_OVR_Pos = 0x4
	// Bit mask of OVR field.
	ADC_ISR_OVR_Msk = 0x10
	// Bit OVR.
	ADC_ISR_OVR = 0x10
	// No overrun occurred
	ADC_ISR_OVR_NoOverrun = 0x0
	// Overrun occurred
	ADC_ISR_OVR_Overrun = 0x1
	// Clear the overrun flag
	ADC_ISR_OVR_Clear = 0x1
	// Position of AWD field.
	ADC_ISR_AWD_Pos = 0x7
	// Bit mask of AWD field.
	ADC_ISR_AWD_Msk = 0x80
	// Bit AWD.
	ADC_ISR_AWD = 0x80
	// No analog watchdog event occurred
	ADC_ISR_AWD_NoEvent = 0x0
	// Analog watchdog event occurred
	ADC_ISR_AWD_Event = 0x1
	// Clear the analog watchdog event flag
	ADC_ISR_AWD_Clear = 0x1
	// Position of EOCAL field.
	ADC_ISR_EOCAL_Pos = 0xb
	// Bit mask of EOCAL field.
	ADC_ISR_EOCAL_Msk = 0x800
	// Bit EOCAL.
	ADC_ISR_EOCAL = 0x800
	// Calibration is not complete
	ADC_ISR_EOCAL_NotComplete = 0x0
	// Calibration complete
	ADC_ISR_EOCAL_Complete = 0x1
	// Clear the calibration flag
	ADC_ISR_EOCAL_Clear = 0x1

	// IER: interrupt enable register
	// Position of ADRDYIE field.
	ADC_IER_ADRDYIE_Pos = 0x0
	// Bit mask of ADRDYIE field.
	ADC_IER_ADRDYIE_Msk = 0x1
	// Bit ADRDYIE.
	ADC_IER_ADRDYIE = 0x1
	// ADRDY interrupt disabled
	ADC_IER_ADRDYIE_Disabled = 0x0
	// ADRDY interrupt enabled. An interrupt is generated when the ADRDY bit is set.
	ADC_IER_ADRDYIE_Enabled = 0x1
	// Position of EOSMPIE field.
	ADC_IER_EOSMPIE_Pos = 0x1
	// Bit mask of EOSMPIE field.
	ADC_IER_EOSMPIE_Msk = 0x2
	// Bit EOSMPIE.
	ADC_IER_EOSMPIE = 0x2
	// EOSMP interrupt disabled
	ADC_IER_EOSMPIE_Disabled = 0x0
	// EOSMP interrupt enabled. An interrupt is generated when the EOSMP bit is set.
	ADC_IER_EOSMPIE_Enabled = 0x1
	// Position of EOCIE field.
	ADC_IER_EOCIE_Pos = 0x2
	// Bit mask of EOCIE field.
	ADC_IER_EOCIE_Msk = 0x4
	// Bit EOCIE.
	ADC_IER_EOCIE = 0x4
	// EOC interrupt disabled
	ADC_IER_EOCIE_Disabled = 0x0
	// EOC interrupt enabled. An interrupt is generated when the EOC bit is set.
	ADC_IER_EOCIE_Enabled = 0x1
	// Position of EOSIE field.
	ADC_IER_EOSIE_Pos = 0x3
	// Bit mask of EOSIE field.
	ADC_IER_EOSIE_Msk = 0x8
	// Bit EOSIE.
	ADC_IER_EOSIE = 0x8
	// EOS interrupt disabled
	ADC_IER_EOSIE_Disabled = 0x0
	// EOS interrupt enabled. An interrupt is generated when the EOS bit is set.
	ADC_IER_EOSIE_Enabled = 0x1
	// Position of OVRIE field.
	ADC_IER_OVRIE_Pos = 0x4
	// Bit mask of OVRIE field.
	ADC_IER_OVRIE_Msk = 0x10
	// Bit OVRIE.
	ADC_IER_OVRIE = 0x10
	// Overrun interrupt disabled
	ADC_IER_OVRIE_Disabled = 0x0
	// Overrun interrupt enabled. An interrupt is generated when the OVR bit is set.
	ADC_IER_OVRIE_Enabled = 0x1
	// Position of AWDIE field.
	ADC_IER_AWDIE_Pos = 0x7
	// Bit mask of AWDIE field.
	ADC_IER_AWDIE_Msk = 0x80
	// Bit AWDIE.
	ADC_IER_AWDIE = 0x80
	// Analog watchdog interrupt disabled
	ADC_IER_AWDIE_Disabled = 0x0
	// Analog watchdog interrupt enabled
	ADC_IER_AWDIE_Enabled = 0x1
	// Position of EOCALIE field.
	ADC_IER_EOCALIE_Pos = 0xb
	// Bit mask of EOCALIE field.
	ADC_IER_EOCALIE_Msk = 0x800
	// Bit EOCALIE.
	ADC_IER_EOCALIE = 0x800
	// End of calibration interrupt disabled
	ADC_IER_EOCALIE_Disabled = 0x0
	// End of calibration interrupt enabled
	ADC_IER_EOCALIE_Enabled = 0x1

	// CR: control register
	// Position of ADEN field.
	ADC_CR_ADEN_Pos = 0x0
	// Bit mask of ADEN field.
	ADC_CR_ADEN_Msk = 0x1
	// Bit ADEN.
	ADC_CR_ADEN = 0x1
	// ADC disabled
	ADC_CR_ADEN_Disabled = 0x0
	// ADC enabled
	ADC_CR_ADEN_Enabled = 0x1
	// Position of ADDIS field.
	ADC_CR_ADDIS_Pos = 0x1
	// Bit mask of ADDIS field.
	ADC_CR_ADDIS_Msk = 0x2
	// Bit ADDIS.
	ADC_CR_ADDIS = 0x2
	// No disable command active
	ADC_CR_ADDIS_NotDisabling = 0x0
	// ADC disabling
	ADC_CR_ADDIS_Disabling = 0x1
	// Disable the ADC
	ADC_CR_ADDIS_Disable = 0x1
	// Position of ADSTART field.
	ADC_CR_ADSTART_Pos = 0x2
	// Bit mask of ADSTART field.
	ADC_CR_ADSTART_Msk = 0x4
	// Bit ADSTART.
	ADC_CR_ADSTART = 0x4
	// No conversion ongoing
	ADC_CR_ADSTART_NotActive = 0x0
	// ADC operating and may be converting
	ADC_CR_ADSTART_Active = 0x1
	// Start the ADC conversion (may be delayed for hardware triggers)
	ADC_CR_ADSTART_StartConversion = 0x1
	// Position of ADSTP field.
	ADC_CR_ADSTP_Pos = 0x4
	// Bit mask of ADSTP field.
	ADC_CR_ADSTP_Msk = 0x10
	// Bit ADSTP.
	ADC_CR_ADSTP = 0x10
	// No stop command active
	ADC_CR_ADSTP_NotStopping = 0x0
	// ADC stopping conversion
	ADC_CR_ADSTP_Stopping = 0x1
	// Stop the active conversion
	ADC_CR_ADSTP_StopConversion = 0x1
	// Position of ADVREGEN field.
	ADC_CR_ADVREGEN_Pos = 0x1c
	// Bit mask of ADVREGEN field.
	ADC_CR_ADVREGEN_Msk = 0x10000000
	// Bit ADVREGEN.
	ADC_CR_ADVREGEN = 0x10000000
	// ADC voltage regulator disabled
	ADC_CR_ADVREGEN_Disabled = 0x0
	// ADC voltage regulator enabled
	ADC_CR_ADVREGEN_Enabled = 0x1
	// Position of ADCAL field.
	ADC_CR_ADCAL_Pos = 0x1f
	// Bit mask of ADCAL field.
	ADC_CR_ADCAL_Msk = 0x80000000
	// Bit ADCAL.
	ADC_CR_ADCAL = 0x80000000
	// ADC calibration either not yet performed or completed
	ADC_CR_ADCAL_NotCalibrating = 0x0
	// ADC calibration in progress
	ADC_CR_ADCAL_Calibrating = 0x1
	// Start the ADC calibration sequence
	ADC_CR_ADCAL_StartCalibration = 0x1

	// CFGR1: configuration register 1
	// Position of AWDCH field.
	ADC_CFGR1_AWDCH_Pos = 0x1a
	// Bit mask of AWDCH field.
	ADC_CFGR1_AWDCH_Msk = 0x7c000000
	// Position of AWDEN field.
	ADC_CFGR1_AWDEN_Pos = 0x17
	// Bit mask of AWDEN field.
	ADC_CFGR1_AWDEN_Msk = 0x800000
	// Bit AWDEN.
	ADC_CFGR1_AWDEN = 0x800000
	// Analog watchdog disabled
	ADC_CFGR1_AWDEN_Disabled = 0x0
	// Analog watchdog enabled
	ADC_CFGR1_AWDEN_Enabled = 0x1
	// Position of AWDSGL field.
	ADC_CFGR1_AWDSGL_Pos = 0x16
	// Bit mask of AWDSGL field.
	ADC_CFGR1_AWDSGL_Msk = 0x400000
	// Bit AWDSGL.
	ADC_CFGR1_AWDSGL = 0x400000
	// Analog watchdog enabled on all channels
	ADC_CFGR1_AWDSGL_AllChannels = 0x0
	// Analog watchdog enabled on a single channel
	ADC_CFGR1_AWDSGL_SingleChannel = 0x1
	// Position of DISCEN field.
	ADC_CFGR1_DISCEN_Pos = 0x10
	// Bit mask of DISCEN field.
	ADC_CFGR1_DISCEN_Msk = 0x10000
	// Bit DISCEN.
	ADC_CFGR1_DISCEN = 0x10000
	// Discontinuous mode disabled
	ADC_CFGR1_DISCEN_Disabled = 0x0
	// Discontinuous mode enabled
	ADC_CFGR1_DISCEN_Enabled = 0x1
	// Position of AUTOFF field.
	ADC_CFGR1_AUTOFF_Pos = 0xf
	// Bit mask of AUTOFF field.
	ADC_CFGR1_AUTOFF_Msk = 0x8000
	// Bit AUTOFF.
	ADC_CFGR1_AUTOFF = 0x8000
	// Auto-off mode disabled
	ADC_CFGR1_AUTOFF_Disabled = 0x0
	// Auto-off mode enabled
	ADC_CFGR1_AUTOFF_Enabled = 0x1
	// Position of WAIT field.
	ADC_CFGR1_WAIT_Pos = 0xe
	// Bit mask of WAIT field.
	ADC_CFGR1_WAIT_Msk = 0x4000
	// Bit WAIT.
	ADC_CFGR1_WAIT = 0x4000
	// Wait conversion mode off
	ADC_CFGR1_WAIT_Disabled = 0x0
	// Wait conversion mode on
	ADC_CFGR1_WAIT_Enabled = 0x1
	// Position of CONT field.
	ADC_CFGR1_CONT_Pos = 0xd
	// Bit mask of CONT field.
	ADC_CFGR1_CONT_Msk = 0x2000
	// Bit CONT.
	ADC_CFGR1_CONT = 0x2000
	// Single conversion mode
	ADC_CFGR1_CONT_Single = 0x0
	// Continuous conversion mode
	ADC_CFGR1_CONT_Continuous = 0x1
	// Position of OVRMOD field.
	ADC_CFGR1_OVRMOD_Pos = 0xc
	// Bit mask of OVRMOD field.
	ADC_CFGR1_OVRMOD_Msk = 0x1000
	// Bit OVRMOD.
	ADC_CFGR1_OVRMOD = 0x1000
	// ADC_DR register is preserved with the old data when an overrun is detected
	ADC_CFGR1_OVRMOD_Preserve = 0x0
	// ADC_DR register is overwritten with the last conversion result when an overrun is detected
	ADC_CFGR1_OVRMOD_Overwrite = 0x1
	// Position of EXTEN field.
	ADC_CFGR1_EXTEN_Pos = 0xa
	// Bit mask of EXTEN field.
	ADC_CFGR1_EXTEN_Msk = 0xc00
	// Hardware trigger detection disabled
	ADC_CFGR1_EXTEN_Disabled = 0x0
	// Hardware trigger detection on the rising edge
	ADC_CFGR1_EXTEN_RisingEdge = 0x1
	// Hardware trigger detection on the falling edge
	ADC_CFGR1_EXTEN_FallingEdge = 0x2
	// Hardware trigger detection on both the rising and falling edges
	ADC_CFGR1_EXTEN_BothEdges = 0x3
	// Position of EXTSEL field.
	ADC_CFGR1_EXTSEL_Pos = 0x6
	// Bit mask of EXTSEL field.
	ADC_CFGR1_EXTSEL_Msk = 0x1c0
	// Timer 6 TRGO event
	ADC_CFGR1_EXTSEL_TIM6_TRGO = 0x0
	// Timer 21 CH2 event
	ADC_CFGR1_EXTSEL_TIM21_CH2 = 0x1
	// Timer 2 TRGO event
	ADC_CFGR1_EXTSEL_TIM2_TRGO = 0x2
	// Timer 2 CH4 event
	ADC_CFGR1_EXTSEL_TIM2_CH4 = 0x3
	// Timer 22 TRGO, Timer 21 TRGO event
	ADC_CFGR1_EXTSEL_TIM22_TRGO = 0x4
	// Timer 2 CH3 event
	ADC_CFGR1_EXTSEL_TIM2_CH3 = 0x5
	// Timer 3 TRGO event
	ADC_CFGR1_EXTSEL_TIM3_TRGO = 0x6
	// EXTI line 11 event
	ADC_CFGR1_EXTSEL_EXTI_LINE11 = 0x7
	// Position of ALIGN field.
	ADC_CFGR1_ALIGN_Pos = 0x5
	// Bit mask of ALIGN field.
	ADC_CFGR1_ALIGN_Msk = 0x20
	// Bit ALIGN.
	ADC_CFGR1_ALIGN = 0x20
	// Right alignment
	ADC_CFGR1_ALIGN_Right = 0x0
	// Left alignment
	ADC_CFGR1_ALIGN_Left = 0x1
	// Position of RES field.
	ADC_CFGR1_RES_Pos = 0x3
	// Bit mask of RES field.
	ADC_CFGR1_RES_Msk = 0x18
	// 12 bits
	ADC_CFGR1_RES_TwelveBit = 0x0
	// 10 bits
	ADC_CFGR1_RES_TenBit = 0x1
	// 8 bits
	ADC_CFGR1_RES_EightBit = 0x2
	// 6 bits
	ADC_CFGR1_RES_SixBit = 0x3
	// Position of SCANDIR field.
	ADC_CFGR1_SCANDIR_Pos = 0x2
	// Bit mask of SCANDIR field.
	ADC_CFGR1_SCANDIR_Msk = 0x4
	// Bit SCANDIR.
	ADC_CFGR1_SCANDIR = 0x4
	// Upward scan (from CHSEL0 to CHSEL18)
	ADC_CFGR1_SCANDIR_Upward = 0x0
	// Backward scan (from CHSEL18 to CHSEL0)
	ADC_CFGR1_SCANDIR_Backward = 0x1
	// Position of DMACFG field.
	ADC_CFGR1_DMACFG_Pos = 0x1
	// Bit mask of DMACFG field.
	ADC_CFGR1_DMACFG_Msk = 0x2
	// Bit DMACFG.
	ADC_CFGR1_DMACFG = 0x2
	// DMA one shot mode selected
	ADC_CFGR1_DMACFG_OneShot = 0x0
	// DMA circular mode selected
	ADC_CFGR1_DMACFG_Circular = 0x1
	// Position of DMAEN field.
	ADC_CFGR1_DMAEN_Pos = 0x0
	// Bit mask of DMAEN field.
	ADC_CFGR1_DMAEN_Msk = 0x1
	// Bit DMAEN.
	ADC_CFGR1_DMAEN = 0x1
	// DMA disabled
	ADC_CFGR1_DMAEN_Disabled = 0x0
	// DMA enabled
	ADC_CFGR1_DMAEN_Enabled = 0x1

	// CFGR2: configuration register 2
	// Position of OVSE field.
	ADC_CFGR2_OVSE_Pos = 0x0
	// Bit mask of OVSE field.
	ADC_CFGR2_OVSE_Msk = 0x1
	// Bit OVSE.
	ADC_CFGR2_OVSE = 0x1
	// Oversampler disabled
	ADC_CFGR2_OVSE_Disabled = 0x0
	// Oversampler enabled
	ADC_CFGR2_OVSE_Enabled = 0x1
	// Position of OVSR field.
	ADC_CFGR2_OVSR_Pos = 0x2
	// Bit mask of OVSR field.
	ADC_CFGR2_OVSR_Msk = 0x1c
	// 2x
	ADC_CFGR2_OVSR_Mul2 = 0x0
	// 4x
	ADC_CFGR2_OVSR_Mul4 = 0x1
	// 8x
	ADC_CFGR2_OVSR_Mul8 = 0x2
	// 16x
	ADC_CFGR2_OVSR_Mul16 = 0x3
	// 32x
	ADC_CFGR2_OVSR_Mul32 = 0x4
	// 64x
	ADC_CFGR2_OVSR_Mul64 = 0x5
	// 128x
	ADC_CFGR2_OVSR_Mul128 = 0x6
	// 256x
	ADC_CFGR2_OVSR_Mul256 = 0x7
	// Position of OVSS field.
	ADC_CFGR2_OVSS_Pos = 0x5
	// Bit mask of OVSS field.
	ADC_CFGR2_OVSS_Msk = 0x1e0
	// Position of TOVS field.
	ADC_CFGR2_TOVS_Pos = 0x9
	// Bit mask of TOVS field.
	ADC_CFGR2_TOVS_Msk = 0x200
	// Bit TOVS.
	ADC_CFGR2_TOVS = 0x200
	// All oversampled conversions for a channel are done consecutively after a trigger
	ADC_CFGR2_TOVS_TriggerAll = 0x0
	// Each oversampled conversion for a channel needs a trigger
	ADC_CFGR2_TOVS_TriggerEach = 0x1
	// Position of CKMODE field.
	ADC_CFGR2_CKMODE_Pos = 0x1e
	// Bit mask of CKMODE field.
	ADC_CFGR2_CKMODE_Msk = 0xc0000000
	// ADCCLK (Asynchronous clock mode)
	ADC_CFGR2_CKMODE_ADCLK = 0x0
	// PCLK/2 (Synchronous clock mode)
	ADC_CFGR2_CKMODE_PCLK_Div2 = 0x1
	// PCLK/4 (Synchronous clock mode)
	ADC_CFGR2_CKMODE_PCLK_Div4 = 0x2
	// PCLK (Synchronous clock mode)
	ADC_CFGR2_CKMODE_PCLK = 0x3

	// SMPR: sampling time register
	// Position of SMP field.
	ADC_SMPR_SMP_Pos = 0x0
	// Bit mask of SMP field.
	ADC_SMPR_SMP_Msk = 0x7
	// 1.5 ADC clock cycles
	ADC_SMPR_SMP_Cycles1_5 = 0x0
	// 3.5 ADC clock cycles
	ADC_SMPR_SMP_Cycles3_5 = 0x1
	// 7.5 ADC clock cycles
	ADC_SMPR_SMP_Cycles7_5 = 0x2
	// 12.5 ADC clock cycles
	ADC_SMPR_SMP_Cycles12_5 = 0x3
	// 19.5 ADC clock cycles
	ADC_SMPR_SMP_Cycles19_5 = 0x4
	// 39.5 ADC clock cycles
	ADC_SMPR_SMP_Cycles39_5 = 0x5
	// 79.5 ADC clock cycles
	ADC_SMPR_SMP_Cycles79_5 = 0x6
	// 160.5 ADC clock cycles
	ADC_SMPR_SMP_Cycles160_5 = 0x7

	// TR: watchdog threshold register
	// Position of HT field.
	ADC_TR_HT_Pos = 0x10
	// Bit mask of HT field.
	ADC_TR_HT_Msk = 0xfff0000
	// Position of LT field.
	ADC_TR_LT_Pos = 0x0
	// Bit mask of LT field.
	ADC_TR_LT_Msk = 0xfff

	// CHSELR: channel selection register
	// Position of CHSEL18 field.
	ADC_CHSELR_CHSEL18_Pos = 0x12
	// Bit mask of CHSEL18 field.
	ADC_CHSELR_CHSEL18_Msk = 0x40000
	// Bit CHSEL18.
	ADC_CHSELR_CHSEL18 = 0x40000
	// Input Channel is not selected for conversion
	ADC_CHSELR_CHSEL18_NotSelected = 0x0
	// Input Channel is selected for conversion
	ADC_CHSELR_CHSEL18_Selected = 0x1
	// Position of CHSEL17 field.
	ADC_CHSELR_CHSEL17_Pos = 0x11
	// Bit mask of CHSEL17 field.
	ADC_CHSELR_CHSEL17_Msk = 0x20000
	// Bit CHSEL17.
	ADC_CHSELR_CHSEL17 = 0x20000
	// Input Channel is not selected for conversion
	ADC_CHSELR_CHSEL17_NotSelected = 0x0
	// Input Channel is selected for conversion
	ADC_CHSELR_CHSEL17_Selected = 0x1
	// Position of CHSEL16 field.
	ADC_CHSELR_CHSEL16_Pos = 0x10
	// Bit mask of CHSEL16 field.
	ADC_CHSELR_CHSEL16_Msk = 0x10000
	// Bit CHSEL16.
	ADC_CHSELR_CHSEL16 = 0x10000
	// Input Channel is not selected for conversion
	ADC_CHSELR_CHSEL16_NotSelected = 0x0
	// Input Channel is selected for conversion
	ADC_CHSELR_CHSEL16_Selected = 0x1
	// Position of CHSEL15 field.
	ADC_CHSELR_CHSEL15_Pos = 0xf
	// Bit mask of CHSEL15 field.
	ADC_CHSELR_CHSEL15_Msk = 0x8000
	// Bit CHSEL15.
	ADC_CHSELR_CHSEL15 = 0x8000
	// Input Channel is not selected for conversion
	ADC_CHSELR_CHSEL15_NotSelected = 0x0
	// Input Channel is selected for conversion
	ADC_CHSELR_CHSEL15_Selected = 0x1
	// Position of CHSEL14 field.
	ADC_CHSELR_CHSEL14_Pos = 0xe
	// Bit mask of CHSEL14 field.
	ADC_CHSELR_CHSEL14_Msk = 0x4000
	// Bit CHSEL14.
	ADC_CHSELR_CHSEL14 = 0x4000
	// Input Channel is not selected for conversion
	ADC_CHSELR_CHSEL14_NotSelected = 0x0
	// Input Channel is selected for conversion
	ADC_CHSELR_CHSEL14_Selected = 0x1
	// Position of CHSEL13 field.
	ADC_CHSELR_CHSEL13_Pos = 0xd
	// Bit mask of CHSEL13 field.
	ADC_CHSELR_CHSEL13_Msk = 0x2000
	// Bit CHSEL13.
	ADC_CHSELR_CHSEL13 = 0x2000
	// Input Channel is not selected for conversion
	ADC_CHSELR_CHSEL13_NotSelected = 0x0
	// Input Channel is selected for conversion
	ADC_CHSELR_CHSEL13_Selected = 0x1
	// Position of CHSEL12 field.
	ADC_CHSELR_CHSEL12_Pos = 0xc
	// Bit mask of CHSEL12 field.
	ADC_CHSELR_CHSEL12_Msk = 0x1000
	// Bit CHSEL12.
	ADC_CHSELR_CHSEL12 = 0x1000
	// Input Channel is not selected for conversion
	ADC_CHSELR_CHSEL12_NotSelected = 0x0
	// Input Channel is selected for conversion
	ADC_CHSELR_CHSEL12_Selected = 0x1
	// Position of CHSEL11 field.
	ADC_CHSELR_CHSEL11_Pos = 0xb
	// Bit mask of CHSEL11 field.
	ADC_CHSELR_CHSEL11_Msk = 0x800
	// Bit CHSEL11.
	ADC_CHSELR_CHSEL11 = 0x800
	// Input Channel is not selected for conversion
	ADC_CHSELR_CHSEL11_NotSelected = 0x0
	// Input Channel is selected for conversion
	ADC_CHSELR_CHSEL11_Selected = 0x1
	// Position of CHSEL10 field.
	ADC_CHSELR_CHSEL10_Pos = 0xa
	// Bit mask of CHSEL10 field.
	ADC_CHSELR_CHSEL10_Msk = 0x400
	// Bit CHSEL10.
	ADC_CHSELR_CHSEL10 = 0x400
	// Input Channel is not selected for conversion
	ADC_CHSELR_CHSEL10_NotSelected = 0x0
	// Input Channel is selected for conversion
	ADC_CHSELR_CHSEL10_Selected = 0x1
	// Position of CHSEL9 field.
	ADC_CHSELR_CHSEL9_Pos = 0x9
	// Bit mask of CHSEL9 field.
	ADC_CHSELR_CHSEL9_Msk = 0x200
	// Bit CHSEL9.
	ADC_CHSELR_CHSEL9 = 0x200
	// Input Channel is not selected for conversion
	ADC_CHSELR_CHSEL9_NotSelected = 0x0
	// Input Channel is selected for conversion
	ADC_CHSELR_CHSEL9_Selected = 0x1
	// Position of CHSEL8 field.
	ADC_CHSELR_CHSEL8_Pos = 0x8
	// Bit mask of CHSEL8 field.
	ADC_CHSELR_CHSEL8_Msk = 0x100
	// Bit CHSEL8.
	ADC_CHSELR_CHSEL8 = 0x100
	// Input Channel is not selected for conversion
	ADC_CHSELR_CHSEL8_NotSelected = 0x0
	// Input Channel is selected for conversion
	ADC_CHSELR_CHSEL8_Selected = 0x1
	// Position of CHSEL7 field.
	ADC_CHSELR_CHSEL7_Pos = 0x7
	// Bit mask of CHSEL7 field.
	ADC_CHSELR_CHSEL7_Msk = 0x80
	// Bit CHSEL7.
	ADC_CHSELR_CHSEL7 = 0x80
	// Input Channel is not selected for conversion
	ADC_CHSELR_CHSEL7_NotSelected = 0x0
	// Input Channel is selected for conversion
	ADC_CHSELR_CHSEL7_Selected = 0x1
	// Position of CHSEL6 field.
	ADC_CHSELR_CHSEL6_Pos = 0x6
	// Bit mask of CHSEL6 field.
	ADC_CHSELR_CHSEL6_Msk = 0x40
	// Bit CHSEL6.
	ADC_CHSELR_CHSEL6 = 0x40
	// Input Channel is not selected for conversion
	ADC_CHSELR_CHSEL6_NotSelected = 0x0
	// Input Channel is selected for conversion
	ADC_CHSELR_CHSEL6_Selected = 0x1
	// Position of CHSEL5 field.
	ADC_CHSELR_CHSEL5_Pos = 0x5
	// Bit mask of CHSEL5 field.
	ADC_CHSELR_CHSEL5_Msk = 0x20
	// Bit CHSEL5.
	ADC_CHSELR_CHSEL5 = 0x20
	// Input Channel is not selected for conversion
	ADC_CHSELR_CHSEL5_NotSelected = 0x0
	// Input Channel is selected for conversion
	ADC_CHSELR_CHSEL5_Selected = 0x1
	// Position of CHSEL4 field.
	ADC_CHSELR_CHSEL4_Pos = 0x4
	// Bit mask of CHSEL4 field.
	ADC_CHSELR_CHSEL4_Msk = 0x10
	// Bit CHSEL4.
	ADC_CHSELR_CHSEL4 = 0x10
	// Input Channel is not selected for conversion
	ADC_CHSELR_CHSEL4_NotSelected = 0x0
	// Input Channel is selected for conversion
	ADC_CHSELR_CHSEL4_Selected = 0x1
	// Position of CHSEL3 field.
	ADC_CHSELR_CHSEL3_Pos = 0x3
	// Bit mask of CHSEL3 field.
	ADC_CHSELR_CHSEL3_Msk = 0x8
	// Bit CHSEL3.
	ADC_CHSELR_CHSEL3 = 0x8
	// Input Channel is not selected for conversion
	ADC_CHSELR_CHSEL3_NotSelected = 0x0
	// Input Channel is selected for conversion
	ADC_CHSELR_CHSEL3_Selected = 0x1
	// Position of CHSEL2 field.
	ADC_CHSELR_CHSEL2_Pos = 0x2
	// Bit mask of CHSEL2 field.
	ADC_CHSELR_CHSEL2_Msk = 0x4
	// Bit CHSEL2.
	ADC_CHSELR_CHSEL2 = 0x4
	// Input Channel is not selected for conversion
	ADC_CHSELR_CHSEL2_NotSelected = 0x0
	// Input Channel is selected for conversion
	ADC_CHSELR_CHSEL2_Selected = 0x1
	// Position of CHSEL1 field.
	ADC_CHSELR_CHSEL1_Pos = 0x1
	// Bit mask of CHSEL1 field.
	ADC_CHSELR_CHSEL1_Msk = 0x2
	// Bit CHSEL1.
	ADC_CHSELR_CHSEL1 = 0x2
	// Input Channel is not selected for conversion
	ADC_CHSELR_CHSEL1_NotSelected = 0x0
	// Input Channel is selected for conversion
	ADC_CHSELR_CHSEL1_Selected = 0x1
	// Position of CHSEL0 field.
	ADC_CHSELR_CHSEL0_Pos = 0x0
	// Bit mask of CHSEL0 field.
	ADC_CHSELR_CHSEL0_Msk = 0x1
	// Bit CHSEL0.
	ADC_CHSELR_CHSEL0 = 0x1
	// Input Channel is not selected for conversion
	ADC_CHSELR_CHSEL0_NotSelected = 0x0
	// Input Channel is selected for conversion
	ADC_CHSELR_CHSEL0_Selected = 0x1

	// DR: data register
	// Position of DATA field.
	ADC_DR_DATA_Pos = 0x0
	// Bit mask of DATA field.
	ADC_DR_DATA_Msk = 0xffff

	// CALFACT: ADC Calibration factor
	// Position of CALFACT field.
	ADC_CALFACT_CALFACT_Pos = 0x0
	// Bit mask of CALFACT field.
	ADC_CALFACT_CALFACT_Msk = 0x7f

	// CCR: ADC common configuration register
	// Position of PRESC field.
	ADC_CCR_PRESC_Pos = 0x12
	// Bit mask of PRESC field.
	ADC_CCR_PRESC_Msk = 0x3c0000
	// Input ADC clock not divided
	ADC_CCR_PRESC_Div1 = 0x0
	// Input ADC clock divided by 2
	ADC_CCR_PRESC_Div2 = 0x1
	// Input ADC clock divided by 4
	ADC_CCR_PRESC_Div4 = 0x2
	// Input ADC clock divided by 6
	ADC_CCR_PRESC_Div6 = 0x3
	// Input ADC clock divided by 8
	ADC_CCR_PRESC_Div8 = 0x4
	// Input ADC clock divided by 10
	ADC_CCR_PRESC_Div10 = 0x5
	// Input ADC clock divided by 12
	ADC_CCR_PRESC_Div12 = 0x6
	// Input ADC clock divided by 16
	ADC_CCR_PRESC_Div16 = 0x7
	// Input ADC clock divided by 32
	ADC_CCR_PRESC_Div32 = 0x8
	// Input ADC clock divided by 64
	ADC_CCR_PRESC_Div64 = 0x9
	// Input ADC clock divided by 128
	ADC_CCR_PRESC_Div128 = 0xa
	// Input ADC clock divided by 256
	ADC_CCR_PRESC_Div256 = 0xb
	// Position of VREFEN field.
	ADC_CCR_VREFEN_Pos = 0x16
	// Bit mask of VREFEN field.
	ADC_CCR_VREFEN_Msk = 0x400000
	// Bit VREFEN.
	ADC_CCR_VREFEN = 0x400000
	// VREFINT disabled
	ADC_CCR_VREFEN_Disabled = 0x0
	// VREFINT enabled
	ADC_CCR_VREFEN_Enabled = 0x1
	// Position of TSEN field.
	ADC_CCR_TSEN_Pos = 0x17
	// Bit mask of TSEN field.
	ADC_CCR_TSEN_Msk = 0x800000
	// Bit TSEN.
	ADC_CCR_TSEN = 0x800000
	// Temperature sensor disabled
	ADC_CCR_TSEN_Disabled = 0x0
	// Temperature sensor enabled
	ADC_CCR_TSEN_Enabled = 0x1
	// Position of LFMEN field.
	ADC_CCR_LFMEN_Pos = 0x19
	// Bit mask of LFMEN field.
	ADC_CCR_LFMEN_Msk = 0x2000000
	// Bit LFMEN.
	ADC_CCR_LFMEN = 0x2000000
	// Low Frequency Mode disabled
	ADC_CCR_LFMEN_Disabled = 0x0
	// Low Frequency Mode enabled
	ADC_CCR_LFMEN_Enabled = 0x1
)

// Bitfields for DBG: Debug support
const (
	// IDCODE: MCU Device ID Code Register
	// Position of DEV_ID field.
	DBGMCU_IDCODE_DEV_ID_Pos = 0x0
	// Bit mask of DEV_ID field.
	DBGMCU_IDCODE_DEV_ID_Msk = 0xfff
	// Position of REV_ID field.
	DBGMCU_IDCODE_REV_ID_Pos = 0x10
	// Bit mask of REV_ID field.
	DBGMCU_IDCODE_REV_ID_Msk = 0xffff0000

	// CR: Debug MCU Configuration Register
	// Position of DBG_STOP field.
	DBGMCU_CR_DBG_STOP_Pos = 0x1
	// Bit mask of DBG_STOP field.
	DBGMCU_CR_DBG_STOP_Msk = 0x2
	// Bit DBG_STOP.
	DBGMCU_CR_DBG_STOP = 0x2
	// Debug Stop Mode Disabled
	DBGMCU_CR_DBG_STOP_Disabled = 0x0
	// Debug Stop Mode Enabled
	DBGMCU_CR_DBG_STOP_Enabled = 0x1
	// Position of DBG_STANDBY field.
	DBGMCU_CR_DBG_STANDBY_Pos = 0x2
	// Bit mask of DBG_STANDBY field.
	DBGMCU_CR_DBG_STANDBY_Msk = 0x4
	// Bit DBG_STANDBY.
	DBGMCU_CR_DBG_STANDBY = 0x4
	// Debug Standby Mode Disabled
	DBGMCU_CR_DBG_STANDBY_Disabled = 0x0
	// Debug Standby Mode Enabled
	DBGMCU_CR_DBG_STANDBY_Enabled = 0x1
	// Position of DBG_SLEEP field.
	DBGMCU_CR_DBG_SLEEP_Pos = 0x0
	// Bit mask of DBG_SLEEP field.
	DBGMCU_CR_DBG_SLEEP_Msk = 0x1
	// Bit DBG_SLEEP.
	DBGMCU_CR_DBG_SLEEP = 0x1
	// Debug Sleep Mode Disabled
	DBGMCU_CR_DBG_SLEEP_Disabled = 0x0
	// Debug Sleep Mode Enabled
	DBGMCU_CR_DBG_SLEEP_Enabled = 0x1

	// APB1_FZ: APB Low Freeze Register
	// Position of DBG_TIMER2_STOP field.
	DBGMCU_APB1_FZ_DBG_TIMER2_STOP_Pos = 0x0
	// Bit mask of DBG_TIMER2_STOP field.
	DBGMCU_APB1_FZ_DBG_TIMER2_STOP_Msk = 0x1
	// Bit DBG_TIMER2_STOP.
	DBGMCU_APB1_FZ_DBG_TIMER2_STOP = 0x1
	// The counter clock of TIMx is fed even if the core is halted
	DBGMCU_APB1_FZ_DBG_TIMER2_STOP_Continue = 0x0
	// The counter clock of TIMx is stopped when the core is halted
	DBGMCU_APB1_FZ_DBG_TIMER2_STOP_Stop = 0x1
	// Position of DBG_TIMER6_STOP field.
	DBGMCU_APB1_FZ_DBG_TIMER6_STOP_Pos = 0x4
	// Bit mask of DBG_TIMER6_STOP field.
	DBGMCU_APB1_FZ_DBG_TIMER6_STOP_Msk = 0x10
	// Bit DBG_TIMER6_STOP.
	DBGMCU_APB1_FZ_DBG_TIMER6_STOP = 0x10
	// The counter clock of TIMx is fed even if the core is halted
	DBGMCU_APB1_FZ_DBG_TIMER6_STOP_Continue = 0x0
	// The counter clock of TIMx is stopped when the core is halted
	DBGMCU_APB1_FZ_DBG_TIMER6_STOP_Stop = 0x1
	// Position of DBG_RTC_STOP field.
	DBGMCU_APB1_FZ_DBG_RTC_STOP_Pos = 0xa
	// Bit mask of DBG_RTC_STOP field.
	DBGMCU_APB1_FZ_DBG_RTC_STOP_Msk = 0x400
	// Bit DBG_RTC_STOP.
	DBGMCU_APB1_FZ_DBG_RTC_STOP = 0x400
	// The clock of the RTC counter is fed even if the core is halted
	DBGMCU_APB1_FZ_DBG_RTC_STOP_Continue = 0x0
	// The clock of the RTC counter is stopped when the core is halted
	DBGMCU_APB1_FZ_DBG_RTC_STOP_Stop = 0x1
	// Position of DBG_WWDG_STOP field.
	DBGMCU_APB1_FZ_DBG_WWDG_STOP_Pos = 0xb
	// Bit mask of DBG_WWDG_STOP field.
	DBGMCU_APB1_FZ_DBG_WWDG_STOP_Msk = 0x800
	// Bit DBG_WWDG_STOP.
	DBGMCU_APB1_FZ_DBG_WWDG_STOP = 0x800
	// The window watchdog counter clock continues even if the core is halted
	DBGMCU_APB1_FZ_DBG_WWDG_STOP_Continue = 0x0
	// The window watchdog counter clock is stopped when the core is halted
	DBGMCU_APB1_FZ_DBG_WWDG_STOP_Stop = 0x1
	// Position of DBG_IWDG_STOP field.
	DBGMCU_APB1_FZ_DBG_IWDG_STOP_Pos = 0xc
	// Bit mask of DBG_IWDG_STOP field.
	DBGMCU_APB1_FZ_DBG_IWDG_STOP_Msk = 0x1000
	// Bit DBG_IWDG_STOP.
	DBGMCU_APB1_FZ_DBG_IWDG_STOP = 0x1000
	// The independent watchdog counter clock continues even if the core is halted
	DBGMCU_APB1_FZ_DBG_IWDG_STOP_Continue = 0x0
	// The independent watchdog counter clock is stopped when the core is halted
	DBGMCU_APB1_FZ_DBG_IWDG_STOP_Stop = 0x1
	// Position of DBG_I2C1_STOP field.
	DBGMCU_APB1_FZ_DBG_I2C1_STOP_Pos = 0x15
	// Bit mask of DBG_I2C1_STOP field.
	DBGMCU_APB1_FZ_DBG_I2C1_STOP_Msk = 0x200000
	// Bit DBG_I2C1_STOP.
	DBGMCU_APB1_FZ_DBG_I2C1_STOP = 0x200000
	// Same behavior as in normal mode
	DBGMCU_APB1_FZ_DBG_I2C1_STOP_NormalMode = 0x0
	// I2C3 SMBUS timeout is frozen
	DBGMCU_APB1_FZ_DBG_I2C1_STOP_SMBusTimeoutFrozen = 0x1
	// Position of DBG_I2C2_STOP field.
	DBGMCU_APB1_FZ_DBG_I2C2_STOP_Pos = 0x16
	// Bit mask of DBG_I2C2_STOP field.
	DBGMCU_APB1_FZ_DBG_I2C2_STOP_Msk = 0x400000
	// Bit DBG_I2C2_STOP.
	DBGMCU_APB1_FZ_DBG_I2C2_STOP = 0x400000
	// Same behavior as in normal mode
	DBGMCU_APB1_FZ_DBG_I2C2_STOP_NormalMode = 0x0
	// I2C3 SMBUS timeout is frozen
	DBGMCU_APB1_FZ_DBG_I2C2_STOP_SMBusTimeoutFrozen = 0x1
	// Position of DBG_LPTIMER_STOP field.
	DBGMCU_APB1_FZ_DBG_LPTIMER_STOP_Pos = 0x1f
	// Bit mask of DBG_LPTIMER_STOP field.
	DBGMCU_APB1_FZ_DBG_LPTIMER_STOP_Msk = 0x80000000
	// Bit DBG_LPTIMER_STOP.
	DBGMCU_APB1_FZ_DBG_LPTIMER_STOP = 0x80000000
	// LPTIM1 counter clock is fed even if the core is halted
	DBGMCU_APB1_FZ_DBG_LPTIMER_STOP_Continue = 0x0
	// LPTIM1 counter clock is stopped when the core is halted
	DBGMCU_APB1_FZ_DBG_LPTIMER_STOP_Stop = 0x1

	// APB2_FZ: APB High Freeze Register
	// Position of DBG_TIMER21_STOP field.
	DBGMCU_APB2_FZ_DBG_TIMER21_STOP_Pos = 0x2
	// Bit mask of DBG_TIMER21_STOP field.
	DBGMCU_APB2_FZ_DBG_TIMER21_STOP_Msk = 0x4
	// Bit DBG_TIMER21_STOP.
	DBGMCU_APB2_FZ_DBG_TIMER21_STOP = 0x4
	// The counter clock of TIMx is fed even if the core is halted
	DBGMCU_APB2_FZ_DBG_TIMER21_STOP_Continue = 0x0
	// The counter clock of TIMx is stopped when the core is halted
	DBGMCU_APB2_FZ_DBG_TIMER21_STOP_Stop = 0x1
	// Position of DBG_TIMER22_STO field.
	DBGMCU_APB2_FZ_DBG_TIMER22_STO_Pos = 0x6
	// Bit mask of DBG_TIMER22_STO field.
	DBGMCU_APB2_FZ_DBG_TIMER22_STO_Msk = 0x40
	// Bit DBG_TIMER22_STO.
	DBGMCU_APB2_FZ_DBG_TIMER22_STO = 0x40
)

// Bitfields for TIM2: General-purpose-timers
const (
	// CR1: control register 1
	// Position of CKD field.
	TIM_CR1_CKD_Pos = 0x8
	// Bit mask of CKD field.
	TIM_CR1_CKD_Msk = 0x300
	// t_DTS = t_CK_INT
	TIM_CR1_CKD_Div1 = 0x0
	// t_DTS = 2 × t_CK_INT
	TIM_CR1_CKD_Div2 = 0x1
	// t_DTS = 4 × t_CK_INT
	TIM_CR1_CKD_Div4 = 0x2
	// Position of ARPE field.
	TIM_CR1_ARPE_Pos = 0x7
	// Bit mask of ARPE field.
	TIM_CR1_ARPE_Msk = 0x80
	// Bit ARPE.
	TIM_CR1_ARPE = 0x80
	// TIMx_APRR register is not buffered
	TIM_CR1_ARPE_Disabled = 0x0
	// TIMx_APRR register is buffered
	TIM_CR1_ARPE_Enabled = 0x1
	// Position of CMS field.
	TIM_CR1_CMS_Pos = 0x5
	// Bit mask of CMS field.
	TIM_CR1_CMS_Msk = 0x60
	// The counter counts up or down depending on the direction bit
	TIM_CR1_CMS_EdgeAligned = 0x0
	// The counter counts up and down alternatively. Output compare interrupt flags are set only when the counter is counting down.
	TIM_CR1_CMS_CenterAligned1 = 0x1
	// The counter counts up and down alternatively. Output compare interrupt flags are set only when the counter is counting up.
	TIM_CR1_CMS_CenterAligned2 = 0x2
	// The counter counts up and down alternatively. Output compare interrupt flags are set both when the counter is counting up or down.
	TIM_CR1_CMS_CenterAligned3 = 0x3
	// Position of DIR field.
	TIM_CR1_DIR_Pos = 0x4
	// Bit mask of DIR field.
	TIM_CR1_DIR_Msk = 0x10
	// Bit DIR.
	TIM_CR1_DIR = 0x10
	// Counter used as upcounter
	TIM_CR1_DIR_Up = 0x0
	// Counter used as downcounter
	TIM_CR1_DIR_Down = 0x1
	// Position of OPM field.
	TIM_CR1_OPM_Pos = 0x3
	// Bit mask of OPM field.
	TIM_CR1_OPM_Msk = 0x8
	// Bit OPM.
	TIM_CR1_OPM = 0x8
	// Counter is not stopped at update event
	TIM_CR1_OPM_Disabled = 0x0
	// Counter stops counting at the next update event (clearing the CEN bit)
	TIM_CR1_OPM_Enabled = 0x1
	// Position of URS field.
	TIM_CR1_URS_Pos = 0x2
	// Bit mask of URS field.
	TIM_CR1_URS_Msk = 0x4
	// Bit URS.
	TIM_CR1_URS = 0x4
	// Any of counter overflow/underflow, setting UG, or update through slave mode, generates an update interrupt or DMA request
	TIM_CR1_URS_AnyEvent = 0x0
	// Only counter overflow/underflow generates an update interrupt or DMA request
	TIM_CR1_URS_CounterOnly = 0x1
	// Position of UDIS field.
	TIM_CR1_UDIS_Pos = 0x1
	// Bit mask of UDIS field.
	TIM_CR1_UDIS_Msk = 0x2
	// Bit UDIS.
	TIM_CR1_UDIS = 0x2
	// Update event enabled
	TIM_CR1_UDIS_Enabled = 0x0
	// Update event disabled
	TIM_CR1_UDIS_Disabled = 0x1
	// Position of CEN field.
	TIM_CR1_CEN_Pos = 0x0
	// Bit mask of CEN field.
	TIM_CR1_CEN_Msk = 0x1
	// Bit CEN.
	TIM_CR1_CEN = 0x1
	// Counter disabled
	TIM_CR1_CEN_Disabled = 0x0
	// Counter enabled
	TIM_CR1_CEN_Enabled = 0x1

	// CR2: control register 2
	// Position of TI1S field.
	TIM_CR2_TI1S_Pos = 0x7
	// Bit mask of TI1S field.
	TIM_CR2_TI1S_Msk = 0x80
	// Bit TI1S.
	TIM_CR2_TI1S = 0x80
	// The TIMx_CH1 pin is connected to TI1 input
	TIM_CR2_TI1S_Normal = 0x0
	// The TIMx_CH1, CH2, CH3 pins are connected to TI1 input
	TIM_CR2_TI1S_XOR = 0x1
	// Position of MMS field.
	TIM_CR2_MMS_Pos = 0x4
	// Bit mask of MMS field.
	TIM_CR2_MMS_Msk = 0x70
	// The UG bit from the TIMx_EGR register is used as trigger output
	TIM_CR2_MMS_Reset = 0x0
	// The counter enable signal, CNT_EN, is used as trigger output
	TIM_CR2_MMS_Enable = 0x1
	// The update event is selected as trigger output
	TIM_CR2_MMS_Update = 0x2
	// The trigger output send a positive pulse when the CC1IF flag it to be set, as soon as a capture or a compare match occurred
	TIM_CR2_MMS_ComparePulse = 0x3
	// OC1REF signal is used as trigger output
	TIM_CR2_MMS_CompareOC1 = 0x4
	// OC2REF signal is used as trigger output
	TIM_CR2_MMS_CompareOC2 = 0x5
	// OC3REF signal is used as trigger output
	TIM_CR2_MMS_CompareOC3 = 0x6
	// OC4REF signal is used as trigger output
	TIM_CR2_MMS_CompareOC4 = 0x7
	// Position of CCDS field.
	TIM_CR2_CCDS_Pos = 0x3
	// Bit mask of CCDS field.
	TIM_CR2_CCDS_Msk = 0x8
	// Bit CCDS.
	TIM_CR2_CCDS = 0x8
	// CCx DMA request sent when CCx event occurs
	TIM_CR2_CCDS_OnCompare = 0x0
	// CCx DMA request sent when update event occurs
	TIM_CR2_CCDS_OnUpdate = 0x1

	// SMCR: slave mode control register
	// Position of ETP field.
	TIM_SMCR_ETP_Pos = 0xf
	// Bit mask of ETP field.
	TIM_SMCR_ETP_Msk = 0x8000
	// Bit ETP.
	TIM_SMCR_ETP = 0x8000
	// ETR is noninverted, active at high level or rising edge
	TIM_SMCR_ETP_NotInverted = 0x0
	// ETR is inverted, active at low level or falling edge
	TIM_SMCR_ETP_Inverted = 0x1
	// Position of ECE field.
	TIM_SMCR_ECE_Pos = 0xe
	// Bit mask of ECE field.
	TIM_SMCR_ECE_Msk = 0x4000
	// Bit ECE.
	TIM_SMCR_ECE = 0x4000
	// External clock mode 2 disabled
	TIM_SMCR_ECE_Disabled = 0x0
	// External clock mode 2 enabled. The counter is clocked by any active edge on the ETRF signal.
	TIM_SMCR_ECE_Enabled = 0x1
	// Position of ETPS field.
	TIM_SMCR_ETPS_Pos = 0xc
	// Bit mask of ETPS field.
	TIM_SMCR_ETPS_Msk = 0x3000
	// Prescaler OFF
	TIM_SMCR_ETPS_Div1 = 0x0
	// ETRP frequency divided by 2
	TIM_SMCR_ETPS_Div2 = 0x1
	// ETRP frequency divided by 4
	TIM_SMCR_ETPS_Div4 = 0x2
	// ETRP frequency divided by 8
	TIM_SMCR_ETPS_Div8 = 0x3
	// Position of ETF field.
	TIM_SMCR_ETF_Pos = 0x8
	// Bit mask of ETF field.
	TIM_SMCR_ETF_Msk = 0xf00
	// No filter, sampling is done at fDTS
	TIM_SMCR_ETF_NoFilter = 0x0
	// fSAMPLING=fCK_INT, N=2
	TIM_SMCR_ETF_FCK_INT_N2 = 0x1
	// fSAMPLING=fCK_INT, N=4
	TIM_SMCR_ETF_FCK_INT_N4 = 0x2
	// fSAMPLING=fCK_INT, N=8
	TIM_SMCR_ETF_FCK_INT_N8 = 0x3
	// fSAMPLING=fDTS/2, N=6
	TIM_SMCR_ETF_FDTS_Div2_N6 = 0x4
	// fSAMPLING=fDTS/2, N=8
	TIM_SMCR_ETF_FDTS_Div2_N8 = 0x5
	// fSAMPLING=fDTS/4, N=6
	TIM_SMCR_ETF_FDTS_Div4_N6 = 0x6
	// fSAMPLING=fDTS/4, N=8
	TIM_SMCR_ETF_FDTS_Div4_N8 = 0x7
	// fSAMPLING=fDTS/8, N=6
	TIM_SMCR_ETF_FDTS_Div8_N6 = 0x8
	// fSAMPLING=fDTS/8, N=8
	TIM_SMCR_ETF_FDTS_Div8_N8 = 0x9
	// fSAMPLING=fDTS/16, N=5
	TIM_SMCR_ETF_FDTS_Div16_N5 = 0xa
	// fSAMPLING=fDTS/16, N=6
	TIM_SMCR_ETF_FDTS_Div16_N6 = 0xb
	// fSAMPLING=fDTS/16, N=8
	TIM_SMCR_ETF_FDTS_Div16_N8 = 0xc
	// fSAMPLING=fDTS/32, N=5
	TIM_SMCR_ETF_FDTS_Div32_N5 = 0xd
	// fSAMPLING=fDTS/32, N=6
	TIM_SMCR_ETF_FDTS_Div32_N6 = 0xe
	// fSAMPLING=fDTS/32, N=8
	TIM_SMCR_ETF_FDTS_Div32_N8 = 0xf
	// Position of MSM field.
	TIM_SMCR_MSM_Pos = 0x7
	// Bit mask of MSM field.
	TIM_SMCR_MSM_Msk = 0x80
	// Bit MSM.
	TIM_SMCR_MSM = 0x80
	// No action
	TIM_SMCR_MSM_NoSync = 0x0
	// The effect of an event on the trigger input (TRGI) is delayed to allow a perfect synchronization between the current timer and its slaves (through TRGO). It is useful if we want to synchronize several timers on a single external event.
	TIM_SMCR_MSM_Sync = 0x1
	// Position of TS field.
	TIM_SMCR_TS_Pos = 0x4
	// Bit mask of TS field.
	TIM_SMCR_TS_Msk = 0x70
	// Internal Trigger 0 (ITR0)
	TIM_SMCR_TS_ITR0 = 0x0
	// Internal Trigger 1 (ITR1)
	TIM_SMCR_TS_ITR1 = 0x1
	// Internal Trigger 2 (ITR2)
	TIM_SMCR_TS_ITR2 = 0x2
	// TI1 Edge Detector (TI1F_ED)
	TIM_SMCR_TS_TI1F_ED = 0x4
	// Filtered Timer Input 1 (TI1FP1)
	TIM_SMCR_TS_TI1FP1 = 0x5
	// Filtered Timer Input 2 (TI2FP2)
	TIM_SMCR_TS_TI2FP2 = 0x6
	// External Trigger input (ETRF)
	TIM_SMCR_TS_ETRF = 0x7
	// Position of SMS field.
	TIM_SMCR_SMS_Pos = 0x0
	// Bit mask of SMS field.
	TIM_SMCR_SMS_Msk = 0x7
	// Slave mode disabled - if CEN = ‘1 then the prescaler is clocked directly by the internal clock.
	TIM_SMCR_SMS_Disabled = 0x0
	// Encoder mode 1 - Counter counts up/down on TI2FP1 edge depending on TI1FP2 level.
	TIM_SMCR_SMS_Encoder_Mode_1 = 0x1
	// Encoder mode 2 - Counter counts up/down on TI1FP2 edge depending on TI2FP1 level.
	TIM_SMCR_SMS_Encoder_Mode_2 = 0x2
	// Encoder mode 3 - Counter counts up/down on both TI1FP1 and TI2FP2 edges depending on the level of the other input.
	TIM_SMCR_SMS_Encoder_Mode_3 = 0x3
	// Reset Mode - Rising edge of the selected trigger input (TRGI) reinitializes the counter and generates an update of the registers.
	TIM_SMCR_SMS_Reset_Mode = 0x4
	// Gated Mode - The counter clock is enabled when the trigger input (TRGI) is high. The counter stops (but is not reset) as soon as the trigger becomes low. Both start and stop of the counter are controlled.
	TIM_SMCR_SMS_Gated_Mode = 0x5
	// Trigger Mode - The counter starts at a rising edge of the trigger TRGI (but it is not reset). Only the start of the counter is controlled.
	TIM_SMCR_SMS_Trigger_Mode = 0x6
	// External Clock Mode 1 - Rising edges of the selected trigger (TRGI) clock the counter.
	TIM_SMCR_SMS_Ext_Clock_Mode = 0x7

	// DIER: DMA/Interrupt enable register
	// Position of TDE field.
	TIM_DIER_TDE_Pos = 0xe
	// Bit mask of TDE field.
	TIM_DIER_TDE_Msk = 0x4000
	// Bit TDE.
	TIM_DIER_TDE = 0x4000
	// Trigger DMA request disabled
	TIM_DIER_TDE_Disabled = 0x0
	// Trigger DMA request enabled
	TIM_DIER_TDE_Enabled = 0x1
	// Position of CC4DE field.
	TIM_DIER_CC4DE_Pos = 0xc
	// Bit mask of CC4DE field.
	TIM_DIER_CC4DE_Msk = 0x1000
	// Bit CC4DE.
	TIM_DIER_CC4DE = 0x1000
	// CCx DMA request disabled
	TIM_DIER_CC4DE_Disabled = 0x0
	// CCx DMA request enabled
	TIM_DIER_CC4DE_Enabled = 0x1
	// Position of CC3DE field.
	TIM_DIER_CC3DE_Pos = 0xb
	// Bit mask of CC3DE field.
	TIM_DIER_CC3DE_Msk = 0x800
	// Bit CC3DE.
	TIM_DIER_CC3DE = 0x800
	// CCx DMA request disabled
	TIM_DIER_CC3DE_Disabled = 0x0
	// CCx DMA request enabled
	TIM_DIER_CC3DE_Enabled = 0x1
	// Position of CC2DE field.
	TIM_DIER_CC2DE_Pos = 0xa
	// Bit mask of CC2DE field.
	TIM_DIER_CC2DE_Msk = 0x400
	// Bit CC2DE.
	TIM_DIER_CC2DE = 0x400
	// CCx DMA request disabled
	TIM_DIER_CC2DE_Disabled = 0x0
	// CCx DMA request enabled
	TIM_DIER_CC2DE_Enabled = 0x1
	// Position of CC1DE field.
	TIM_DIER_CC1DE_Pos = 0x9
	// Bit mask of CC1DE field.
	TIM_DIER_CC1DE_Msk = 0x200
	// Bit CC1DE.
	TIM_DIER_CC1DE = 0x200
	// CCx DMA request disabled
	TIM_DIER_CC1DE_Disabled = 0x0
	// CCx DMA request enabled
	TIM_DIER_CC1DE_Enabled = 0x1
	// Position of UDE field.
	TIM_DIER_UDE_Pos = 0x8
	// Bit mask of UDE field.
	TIM_DIER_UDE_Msk = 0x100
	// Bit UDE.
	TIM_DIER_UDE = 0x100
	// Update DMA request disabled
	TIM_DIER_UDE_Disabled = 0x0
	// Update DMA request enabled
	TIM_DIER_UDE_Enabled = 0x1
	// Position of TIE field.
	TIM_DIER_TIE_Pos = 0x6
	// Bit mask of TIE field.
	TIM_DIER_TIE_Msk = 0x40
	// Bit TIE.
	TIM_DIER_TIE = 0x40
	// Trigger interrupt disabled
	TIM_DIER_TIE_Disabled = 0x0
	// Trigger interrupt enabled
	TIM_DIER_TIE_Enabled = 0x1
	// Position of CC4IE field.
	TIM_DIER_CC4IE_Pos = 0x4
	// Bit mask of CC4IE field.
	TIM_DIER_CC4IE_Msk = 0x10
	// Bit CC4IE.
	TIM_DIER_CC4IE = 0x10
	// CCx interrupt disabled
	TIM_DIER_CC4IE_Disabled = 0x0
	// CCx interrupt enabled
	TIM_DIER_CC4IE_Enabled = 0x1
	// Position of CC3IE field.
	TIM_DIER_CC3IE_Pos = 0x3
	// Bit mask of CC3IE field.
	TIM_DIER_CC3IE_Msk = 0x8
	// Bit CC3IE.
	TIM_DIER_CC3IE = 0x8
	// CCx interrupt disabled
	TIM_DIER_CC3IE_Disabled = 0x0
	// CCx interrupt enabled
	TIM_DIER_CC3IE_Enabled = 0x1
	// Position of CC2IE field.
	TIM_DIER_CC2IE_Pos = 0x2
	// Bit mask of CC2IE field.
	TIM_DIER_CC2IE_Msk = 0x4
	// Bit CC2IE.
	TIM_DIER_CC2IE = 0x4
	// CCx interrupt disabled
	TIM_DIER_CC2IE_Disabled = 0x0
	// CCx interrupt enabled
	TIM_DIER_CC2IE_Enabled = 0x1
	// Position of CC1IE field.
	TIM_DIER_CC1IE_Pos = 0x1
	// Bit mask of CC1IE field.
	TIM_DIER_CC1IE_Msk = 0x2
	// Bit CC1IE.
	TIM_DIER_CC1IE = 0x2
	// CCx interrupt disabled
	TIM_DIER_CC1IE_Disabled = 0x0
	// CCx interrupt enabled
	TIM_DIER_CC1IE_Enabled = 0x1
	// Position of UIE field.
	TIM_DIER_UIE_Pos = 0x0
	// Bit mask of UIE field.
	TIM_DIER_UIE_Msk = 0x1
	// Bit UIE.
	TIM_DIER_UIE = 0x1
	// Update interrupt disabled
	TIM_DIER_UIE_Disabled = 0x0
	// Update interrupt enabled
	TIM_DIER_UIE_Enabled = 0x1

	// SR: status register
	// Position of CC4OF field.
	TIM_SR_CC4OF_Pos = 0xc
	// Bit mask of CC4OF field.
	TIM_SR_CC4OF_Msk = 0x1000
	// Bit CC4OF.
	TIM_SR_CC4OF = 0x1000
	// The counter value has been captured in TIMx_CCRx register while CCxIF flag was already set
	TIM_SR_CC4OF_Overcapture = 0x1
	// Clear flag
	TIM_SR_CC4OF_Clear = 0x0
	// Position of CC3OF field.
	TIM_SR_CC3OF_Pos = 0xb
	// Bit mask of CC3OF field.
	TIM_SR_CC3OF_Msk = 0x800
	// Bit CC3OF.
	TIM_SR_CC3OF = 0x800
	// The counter value has been captured in TIMx_CCRx register while CCxIF flag was already set
	TIM_SR_CC3OF_Overcapture = 0x1
	// Clear flag
	TIM_SR_CC3OF_Clear = 0x0
	// Position of CC2OF field.
	TIM_SR_CC2OF_Pos = 0xa
	// Bit mask of CC2OF field.
	TIM_SR_CC2OF_Msk = 0x400
	// Bit CC2OF.
	TIM_SR_CC2OF = 0x400
	// The counter value has been captured in TIMx_CCRx register while CCxIF flag was already set
	TIM_SR_CC2OF_Overcapture = 0x1
	// Clear flag
	TIM_SR_CC2OF_Clear = 0x0
	// Position of CC1OF field.
	TIM_SR_CC1OF_Pos = 0x9
	// Bit mask of CC1OF field.
	TIM_SR_CC1OF_Msk = 0x200
	// Bit CC1OF.
	TIM_SR_CC1OF = 0x200
	// The counter value has been captured in TIMx_CCRx register while CCxIF flag was already set
	TIM_SR_CC1OF_Overcapture = 0x1
	// Clear flag
	TIM_SR_CC1OF_Clear = 0x0
	// Position of TIF field.
	TIM_SR_TIF_Pos = 0x6
	// Bit mask of TIF field.
	TIM_SR_TIF_Msk = 0x40
	// Bit TIF.
	TIM_SR_TIF = 0x40
	// No trigger event occurred
	TIM_SR_TIF_NoTrigger = 0x0
	// Trigger interrupt pending
	TIM_SR_TIF_Trigger = 0x1
	// Clear flag
	TIM_SR_TIF_Clear = 0x0
	// Position of CC4IF field.
	TIM_SR_CC4IF_Pos = 0x4
	// Bit mask of CC4IF field.
	TIM_SR_CC4IF_Msk = 0x10
	// Bit CC4IF.
	TIM_SR_CC4IF = 0x10
	// If CC1 is an output: The content of the counter TIMx_CNT matches the content of the TIMx_CCR1 register. If CC1 is an input: The counter value has been captured in TIMx_CCR1 register.
	TIM_SR_CC4IF_Match = 0x1
	// Clear flag
	TIM_SR_CC4IF_Clear = 0x0
	// Position of CC3IF field.
	TIM_SR_CC3IF_Pos = 0x3
	// Bit mask of CC3IF field.
	TIM_SR_CC3IF_Msk = 0x8
	// Bit CC3IF.
	TIM_SR_CC3IF = 0x8
	// If CC1 is an output: The content of the counter TIMx_CNT matches the content of the TIMx_CCR1 register. If CC1 is an input: The counter value has been captured in TIMx_CCR1 register.
	TIM_SR_CC3IF_Match = 0x1
	// Clear flag
	TIM_SR_CC3IF_Clear = 0x0
	// Position of CC2IF field.
	TIM_SR_CC2IF_Pos = 0x2
	// Bit mask of CC2IF field.
	TIM_SR_CC2IF_Msk = 0x4
	// Bit CC2IF.
	TIM_SR_CC2IF = 0x4
	// If CC1 is an output: The content of the counter TIMx_CNT matches the content of the TIMx_CCR1 register. If CC1 is an input: The counter value has been captured in TIMx_CCR1 register.
	TIM_SR_CC2IF_Match = 0x1
	// Clear flag
	TIM_SR_CC2IF_Clear = 0x0
	// Position of CC1IF field.
	TIM_SR_CC1IF_Pos = 0x1
	// Bit mask of CC1IF field.
	TIM_SR_CC1IF_Msk = 0x2
	// Bit CC1IF.
	TIM_SR_CC1IF = 0x2
	// If CC1 is an output: The content of the counter TIMx_CNT matches the content of the TIMx_CCR1 register. If CC1 is an input: The counter value has been captured in TIMx_CCR1 register.
	TIM_SR_CC1IF_Match = 0x1
	// Clear flag
	TIM_SR_CC1IF_Clear = 0x0
	// Position of UIF field.
	TIM_SR_UIF_Pos = 0x0
	// Bit mask of UIF field.
	TIM_SR_UIF_Msk = 0x1
	// Bit UIF.
	TIM_SR_UIF = 0x1
	// No update occurred
	TIM_SR_UIF_Clear = 0x0
	// Update interrupt pending.
	TIM_SR_UIF_UpdatePending = 0x1

	// EGR: event generation register
	// Position of TG field.
	TIM_EGR_TG_Pos = 0x6
	// Bit mask of TG field.
	TIM_EGR_TG_Msk = 0x40
	// Bit TG.
	TIM_EGR_TG = 0x40
	// The TIF flag is set in TIMx_SR register. Related interrupt or DMA transfer can occur if enabled.
	TIM_EGR_TG_Trigger = 0x1
	// Position of CC4G field.
	TIM_EGR_CC4G_Pos = 0x4
	// Bit mask of CC4G field.
	TIM_EGR_CC4G_Msk = 0x10
	// Bit CC4G.
	TIM_EGR_CC4G = 0x10
	// If CC1 is an output: CC1IF flag is set, Corresponding interrupt or DMA request is sent if enabled. If CC1 is an input: The current value of the counter is captured in TIMx_CCR1 register.
	TIM_EGR_CC4G_Trigger = 0x1
	// Position of CC3G field.
	TIM_EGR_CC3G_Pos = 0x3
	// Bit mask of CC3G field.
	TIM_EGR_CC3G_Msk = 0x8
	// Bit CC3G.
	TIM_EGR_CC3G = 0x8
	// If CC1 is an output: CC1IF flag is set, Corresponding interrupt or DMA request is sent if enabled. If CC1 is an input: The current value of the counter is captured in TIMx_CCR1 register.
	TIM_EGR_CC3G_Trigger = 0x1
	// Position of CC2G field.
	TIM_EGR_CC2G_Pos = 0x2
	// Bit mask of CC2G field.
	TIM_EGR_CC2G_Msk = 0x4
	// Bit CC2G.
	TIM_EGR_CC2G = 0x4
	// If CC1 is an output: CC1IF flag is set, Corresponding interrupt or DMA request is sent if enabled. If CC1 is an input: The current value of the counter is captured in TIMx_CCR1 register.
	TIM_EGR_CC2G_Trigger = 0x1
	// Position of CC1G field.
	TIM_EGR_CC1G_Pos = 0x1
	// Bit mask of CC1G field.
	TIM_EGR_CC1G_Msk = 0x2
	// Bit CC1G.
	TIM_EGR_CC1G = 0x2
	// If CC1 is an output: CC1IF flag is set, Corresponding interrupt or DMA request is sent if enabled. If CC1 is an input: The current value of the counter is captured in TIMx_CCR1 register.
	TIM_EGR_CC1G_Trigger = 0x1
	// Position of UG field.
	TIM_EGR_UG_Pos = 0x0
	// Bit mask of UG field.
	TIM_EGR_UG_Msk = 0x1
	// Bit UG.
	TIM_EGR_UG = 0x1
	// Re-initializes the timer counter and generates an update of the registers.
	TIM_EGR_UG_Update = 0x1

	// CCMR1_Output: capture/compare mode register 1 (output mode)
	// Position of OC2CE field.
	TIM_CCMR1_Output_OC2CE_Pos = 0xf
	// Bit mask of OC2CE field.
	TIM_CCMR1_Output_OC2CE_Msk = 0x8000
	// Bit OC2CE.
	TIM_CCMR1_Output_OC2CE = 0x8000
	// Position of OC2M field.
	TIM_CCMR1_Output_OC2M_Pos = 0xc
	// Bit mask of OC2M field.
	TIM_CCMR1_Output_OC2M_Msk = 0x7000
	// The comparison between the output compare register TIMx_CCRy and the counter TIMx_CNT has no effect on the outputs
	TIM_CCMR1_Output_OC2M_Frozen = 0x0
	// Set channel to active level on match. OCyREF signal is forced high when the counter matches the capture/compare register
	TIM_CCMR1_Output_OC2M_ActiveOnMatch = 0x1
	// Set channel to inactive level on match. OCyREF signal is forced low when the counter matches the capture/compare register
	TIM_CCMR1_Output_OC2M_InactiveOnMatch = 0x2
	// OCyREF toggles when TIMx_CNT=TIMx_CCRy
	TIM_CCMR1_Output_OC2M_Toggle = 0x3
	// OCyREF is forced low
	TIM_CCMR1_Output_OC2M_ForceInactive = 0x4
	// OCyREF is forced high
	TIM_CCMR1_Output_OC2M_ForceActive = 0x5
	// In upcounting, channel is active as long as TIMx_CNT<TIMx_CCRy else inactive. In downcounting, channel is inactive as long as TIMx_CNT>TIMx_CCRy else active
	TIM_CCMR1_Output_OC2M_PwmMode1 = 0x6
	// Inversely to PwmMode1
	TIM_CCMR1_Output_OC2M_PwmMode2 = 0x7
	// Position of OC2PE field.
	TIM_CCMR1_Output_OC2PE_Pos = 0xb
	// Bit mask of OC2PE field.
	TIM_CCMR1_Output_OC2PE_Msk = 0x800
	// Bit OC2PE.
	TIM_CCMR1_Output_OC2PE = 0x800
	// Preload register on CCR2 disabled. New values written to CCR2 are taken into account immediately
	TIM_CCMR1_Output_OC2PE_Disabled = 0x0
	// Preload register on CCR2 enabled. Preload value is loaded into active register on each update event
	TIM_CCMR1_Output_OC2PE_Enabled = 0x1
	// Position of OC2FE field.
	TIM_CCMR1_Output_OC2FE_Pos = 0xa
	// Bit mask of OC2FE field.
	TIM_CCMR1_Output_OC2FE_Msk = 0x400
	// Bit OC2FE.
	TIM_CCMR1_Output_OC2FE = 0x400
	// Position of CC2S field.
	TIM_CCMR1_Output_CC2S_Pos = 0x8
	// Bit mask of CC2S field.
	TIM_CCMR1_Output_CC2S_Msk = 0x300
	// CC2 channel is configured as output
	TIM_CCMR1_Output_CC2S_Output = 0x0
	// Position of OC1CE field.
	TIM_CCMR1_Output_OC1CE_Pos = 0x7
	// Bit mask of OC1CE field.
	TIM_CCMR1_Output_OC1CE_Msk = 0x80
	// Bit OC1CE.
	TIM_CCMR1_Output_OC1CE = 0x80
	// Position of OC1M field.
	TIM_CCMR1_Output_OC1M_Pos = 0x4
	// Bit mask of OC1M field.
	TIM_CCMR1_Output_OC1M_Msk = 0x70
	// The comparison between the output compare register TIMx_CCRy and the counter TIMx_CNT has no effect on the outputs
	TIM_CCMR1_Output_OC1M_Frozen = 0x0
	// Set channel to active level on match. OCyREF signal is forced high when the counter matches the capture/compare register
	TIM_CCMR1_Output_OC1M_ActiveOnMatch = 0x1
	// Set channel to inactive level on match. OCyREF signal is forced low when the counter matches the capture/compare register
	TIM_CCMR1_Output_OC1M_InactiveOnMatch = 0x2
	// OCyREF toggles when TIMx_CNT=TIMx_CCRy
	TIM_CCMR1_Output_OC1M_Toggle = 0x3
	// OCyREF is forced low
	TIM_CCMR1_Output_OC1M_ForceInactive = 0x4
	// OCyREF is forced high
	TIM_CCMR1_Output_OC1M_ForceActive = 0x5
	// In upcounting, channel is active as long as TIMx_CNT<TIMx_CCRy else inactive. In downcounting, channel is inactive as long as TIMx_CNT>TIMx_CCRy else active
	TIM_CCMR1_Output_OC1M_PwmMode1 = 0x6
	// Inversely to PwmMode1
	TIM_CCMR1_Output_OC1M_PwmMode2 = 0x7
	// Position of OC1PE field.
	TIM_CCMR1_Output_OC1PE_Pos = 0x3
	// Bit mask of OC1PE field.
	TIM_CCMR1_Output_OC1PE_Msk = 0x8
	// Bit OC1PE.
	TIM_CCMR1_Output_OC1PE = 0x8
	// Preload register on CCR1 disabled. New values written to CCR1 are taken into account immediately
	TIM_CCMR1_Output_OC1PE_Disabled = 0x0
	// Preload register on CCR1 enabled. Preload value is loaded into active register on each update event
	TIM_CCMR1_Output_OC1PE_Enabled = 0x1
	// Position of OC1FE field.
	TIM_CCMR1_Output_OC1FE_Pos = 0x2
	// Bit mask of OC1FE field.
	TIM_CCMR1_Output_OC1FE_Msk = 0x4
	// Bit OC1FE.
	TIM_CCMR1_Output_OC1FE = 0x4
	// Position of CC1S field.
	TIM_CCMR1_Output_CC1S_Pos = 0x0
	// Bit mask of CC1S field.
	TIM_CCMR1_Output_CC1S_Msk = 0x3
	// CC1 channel is configured as output
	TIM_CCMR1_Output_CC1S_Output = 0x0

	// CCMR1_Input: capture/compare mode register 1 (input mode)
	// Position of IC2F field.
	TIM_CCMR1_Input_IC2F_Pos = 0xc
	// Bit mask of IC2F field.
	TIM_CCMR1_Input_IC2F_Msk = 0xf000
	// Position of IC2PSC field.
	TIM_CCMR1_Input_IC2PSC_Pos = 0xa
	// Bit mask of IC2PSC field.
	TIM_CCMR1_Input_IC2PSC_Msk = 0xc00
	// Position of CC2S field.
	TIM_CCMR1_Input_CC2S_Pos = 0x8
	// Bit mask of CC2S field.
	TIM_CCMR1_Input_CC2S_Msk = 0x300
	// CC2 channel is configured as input, IC2 is mapped on TI2
	TIM_CCMR1_Input_CC2S_TI2 = 0x1
	// CC2 channel is configured as input, IC2 is mapped on TI1
	TIM_CCMR1_Input_CC2S_TI1 = 0x2
	// CC2 channel is configured as input, IC2 is mapped on TRC
	TIM_CCMR1_Input_CC2S_TRC = 0x3
	// Position of IC1F field.
	TIM_CCMR1_Input_IC1F_Pos = 0x4
	// Bit mask of IC1F field.
	TIM_CCMR1_Input_IC1F_Msk = 0xf0
	// No filter, sampling is done at fDTS
	TIM_CCMR1_Input_IC1F_NoFilter = 0x0
	// fSAMPLING=fCK_INT, N=2
	TIM_CCMR1_Input_IC1F_FCK_INT_N2 = 0x1
	// fSAMPLING=fCK_INT, N=4
	TIM_CCMR1_Input_IC1F_FCK_INT_N4 = 0x2
	// fSAMPLING=fCK_INT, N=8
	TIM_CCMR1_Input_IC1F_FCK_INT_N8 = 0x3
	// fSAMPLING=fDTS/2, N=6
	TIM_CCMR1_Input_IC1F_FDTS_Div2_N6 = 0x4
	// fSAMPLING=fDTS/2, N=8
	TIM_CCMR1_Input_IC1F_FDTS_Div2_N8 = 0x5
	// fSAMPLING=fDTS/4, N=6
	TIM_CCMR1_Input_IC1F_FDTS_Div4_N6 = 0x6
	// fSAMPLING=fDTS/4, N=8
	TIM_CCMR1_Input_IC1F_FDTS_Div4_N8 = 0x7
	// fSAMPLING=fDTS/8, N=6
	TIM_CCMR1_Input_IC1F_FDTS_Div8_N6 = 0x8
	// fSAMPLING=fDTS/8, N=8
	TIM_CCMR1_Input_IC1F_FDTS_Div8_N8 = 0x9
	// fSAMPLING=fDTS/16, N=5
	TIM_CCMR1_Input_IC1F_FDTS_Div16_N5 = 0xa
	// fSAMPLING=fDTS/16, N=6
	TIM_CCMR1_Input_IC1F_FDTS_Div16_N6 = 0xb
	// fSAMPLING=fDTS/16, N=8
	TIM_CCMR1_Input_IC1F_FDTS_Div16_N8 = 0xc
	// fSAMPLING=fDTS/32, N=5
	TIM_CCMR1_Input_IC1F_FDTS_Div32_N5 = 0xd
	// fSAMPLING=fDTS/32, N=6
	TIM_CCMR1_Input_IC1F_FDTS_Div32_N6 = 0xe
	// fSAMPLING=fDTS/32, N=8
	TIM_CCMR1_Input_IC1F_FDTS_Div32_N8 = 0xf
	// Position of IC1PSC field.
	TIM_CCMR1_Input_IC1PSC_Pos = 0x2
	// Bit mask of IC1PSC field.
	TIM_CCMR1_Input_IC1PSC_Msk = 0xc
	// no prescaler, capture is done each time an edge is detected on the capture input
	TIM_CCMR1_Input_IC1PSC_NoPrescaler = 0x0
	// Capture is done once every 2 events
	TIM_CCMR1_Input_IC1PSC_Two_Events = 0x1
	// Capture is done once every 4 events
	TIM_CCMR1_Input_IC1PSC_Four_Events = 0x2
	// Capture is done once every 8 events
	TIM_CCMR1_Input_IC1PSC_Eight_Events = 0x3
	// Position of CC1S field.
	TIM_CCMR1_Input_CC1S_Pos = 0x0
	// Bit mask of CC1S field.
	TIM_CCMR1_Input_CC1S_Msk = 0x3
	// CC1 channel is configured as input, IC1 is mapped on TI1
	TIM_CCMR1_Input_CC1S_TI1 = 0x1
	// CC1 channel is configured as input, IC1 is mapped on TI2
	TIM_CCMR1_Input_CC1S_TI2 = 0x2
	// CC1 channel is configured as input, IC1 is mapped on TRC
	TIM_CCMR1_Input_CC1S_TRC = 0x3

	// CCMR2_Output: capture/compare mode register 2 (output mode)
	// Position of OC4CE field.
	TIM_CCMR2_Output_OC4CE_Pos = 0xf
	// Bit mask of OC4CE field.
	TIM_CCMR2_Output_OC4CE_Msk = 0x8000
	// Bit OC4CE.
	TIM_CCMR2_Output_OC4CE = 0x8000
	// Position of OC4M field.
	TIM_CCMR2_Output_OC4M_Pos = 0xc
	// Bit mask of OC4M field.
	TIM_CCMR2_Output_OC4M_Msk = 0x7000
	// The comparison between the output compare register TIMx_CCRy and the counter TIMx_CNT has no effect on the outputs
	TIM_CCMR2_Output_OC4M_Frozen = 0x0
	// Set channel to active level on match. OCyREF signal is forced high when the counter matches the capture/compare register
	TIM_CCMR2_Output_OC4M_ActiveOnMatch = 0x1
	// Set channel to inactive level on match. OCyREF signal is forced low when the counter matches the capture/compare register
	TIM_CCMR2_Output_OC4M_InactiveOnMatch = 0x2
	// OCyREF toggles when TIMx_CNT=TIMx_CCRy
	TIM_CCMR2_Output_OC4M_Toggle = 0x3
	// OCyREF is forced low
	TIM_CCMR2_Output_OC4M_ForceInactive = 0x4
	// OCyREF is forced high
	TIM_CCMR2_Output_OC4M_ForceActive = 0x5
	// In upcounting, channel is active as long as TIMx_CNT<TIMx_CCRy else inactive. In downcounting, channel is inactive as long as TIMx_CNT>TIMx_CCRy else active
	TIM_CCMR2_Output_OC4M_PwmMode1 = 0x6
	// Inversely to PwmMode1
	TIM_CCMR2_Output_OC4M_PwmMode2 = 0x7
	// Position of OC4PE field.
	TIM_CCMR2_Output_OC4PE_Pos = 0xb
	// Bit mask of OC4PE field.
	TIM_CCMR2_Output_OC4PE_Msk = 0x800
	// Bit OC4PE.
	TIM_CCMR2_Output_OC4PE = 0x800
	// Preload register on CCR4 disabled. New values written to CCR4 are taken into account immediately
	TIM_CCMR2_Output_OC4PE_Disabled = 0x0
	// Preload register on CCR4 enabled. Preload value is loaded into active register on each update event
	TIM_CCMR2_Output_OC4PE_Enabled = 0x1
	// Position of OC4FE field.
	TIM_CCMR2_Output_OC4FE_Pos = 0xa
	// Bit mask of OC4FE field.
	TIM_CCMR2_Output_OC4FE_Msk = 0x400
	// Bit OC4FE.
	TIM_CCMR2_Output_OC4FE = 0x400
	// Position of CC4S field.
	TIM_CCMR2_Output_CC4S_Pos = 0x8
	// Bit mask of CC4S field.
	TIM_CCMR2_Output_CC4S_Msk = 0x300
	// CC4 channel is configured as output
	TIM_CCMR2_Output_CC4S_Output = 0x0
	// Position of OC3CE field.
	TIM_CCMR2_Output_OC3CE_Pos = 0x7
	// Bit mask of OC3CE field.
	TIM_CCMR2_Output_OC3CE_Msk = 0x80
	// Bit OC3CE.
	TIM_CCMR2_Output_OC3CE = 0x80
	// Position of OC3M field.
	TIM_CCMR2_Output_OC3M_Pos = 0x4
	// Bit mask of OC3M field.
	TIM_CCMR2_Output_OC3M_Msk = 0x70
	// The comparison between the output compare register TIMx_CCRy and the counter TIMx_CNT has no effect on the outputs
	TIM_CCMR2_Output_OC3M_Frozen = 0x0
	// Set channel to active level on match. OCyREF signal is forced high when the counter matches the capture/compare register
	TIM_CCMR2_Output_OC3M_ActiveOnMatch = 0x1
	// Set channel to inactive level on match. OCyREF signal is forced low when the counter matches the capture/compare register
	TIM_CCMR2_Output_OC3M_InactiveOnMatch = 0x2
	// OCyREF toggles when TIMx_CNT=TIMx_CCRy
	TIM_CCMR2_Output_OC3M_Toggle = 0x3
	// OCyREF is forced low
	TIM_CCMR2_Output_OC3M_ForceInactive = 0x4
	// OCyREF is forced high
	TIM_CCMR2_Output_OC3M_ForceActive = 0x5
	// In upcounting, channel is active as long as TIMx_CNT<TIMx_CCRy else inactive. In downcounting, channel is inactive as long as TIMx_CNT>TIMx_CCRy else active
	TIM_CCMR2_Output_OC3M_PwmMode1 = 0x6
	// Inversely to PwmMode1
	TIM_CCMR2_Output_OC3M_PwmMode2 = 0x7
	// Position of OC3PE field.
	TIM_CCMR2_Output_OC3PE_Pos = 0x3
	// Bit mask of OC3PE field.
	TIM_CCMR2_Output_OC3PE_Msk = 0x8
	// Bit OC3PE.
	TIM_CCMR2_Output_OC3PE = 0x8
	// Preload register on CCR3 disabled. New values written to CCR3 are taken into account immediately
	TIM_CCMR2_Output_OC3PE_Disabled = 0x0
	// Preload register on CCR3 enabled. Preload value is loaded into active register on each update event
	TIM_CCMR2_Output_OC3PE_Enabled = 0x1
	// Position of OC3FE field.
	TIM_CCMR2_Output_OC3FE_Pos = 0x2
	// Bit mask of OC3FE field.
	TIM_CCMR2_Output_OC3FE_Msk = 0x4
	// Bit OC3FE.
	TIM_CCMR2_Output_OC3FE = 0x4
	// Position of CC3S field.
	TIM_CCMR2_Output_CC3S_Pos = 0x0
	// Bit mask of CC3S field.
	TIM_CCMR2_Output_CC3S_Msk = 0x3
	// CC3 channel is configured as output
	TIM_CCMR2_Output_CC3S_Output = 0x0

	// CCMR2_Input: capture/compare mode register 2 (input mode)
	// Position of IC4F field.
	TIM_CCMR2_Input_IC4F_Pos = 0xc
	// Bit mask of IC4F field.
	TIM_CCMR2_Input_IC4F_Msk = 0xf000
	// Position of IC4PSC field.
	TIM_CCMR2_Input_IC4PSC_Pos = 0xa
	// Bit mask of IC4PSC field.
	TIM_CCMR2_Input_IC4PSC_Msk = 0xc00
	// Position of CC4S field.
	TIM_CCMR2_Input_CC4S_Pos = 0x8
	// Bit mask of CC4S field.
	TIM_CCMR2_Input_CC4S_Msk = 0x300
	// CC4 channel is configured as input, IC4 is mapped on TI4
	TIM_CCMR2_Input_CC4S_TI4 = 0x1
	// CC4 channel is configured as input, IC4 is mapped on TI3
	TIM_CCMR2_Input_CC4S_TI3 = 0x2
	// CC4 channel is configured as input, IC4 is mapped on TRC
	TIM_CCMR2_Input_CC4S_TRC = 0x3
	// Position of IC3F field.
	TIM_CCMR2_Input_IC3F_Pos = 0x4
	// Bit mask of IC3F field.
	TIM_CCMR2_Input_IC3F_Msk = 0xf0
	// Position of IC3PSC field.
	TIM_CCMR2_Input_IC3PSC_Pos = 0x2
	// Bit mask of IC3PSC field.
	TIM_CCMR2_Input_IC3PSC_Msk = 0xc
	// Position of CC3S field.
	TIM_CCMR2_Input_CC3S_Pos = 0x0
	// Bit mask of CC3S field.
	TIM_CCMR2_Input_CC3S_Msk = 0x3
	// CC3 channel is configured as input, IC3 is mapped on TI3
	TIM_CCMR2_Input_CC3S_TI3 = 0x1
	// CC3 channel is configured as input, IC3 is mapped on TI4
	TIM_CCMR2_Input_CC3S_TI4 = 0x2
	// CC3 channel is configured as input, IC3 is mapped on TRC
	TIM_CCMR2_Input_CC3S_TRC = 0x3

	// CCER: capture/compare enable register
	// Position of CC4NP field.
	TIM_CCER_CC4NP_Pos = 0xf
	// Bit mask of CC4NP field.
	TIM_CCER_CC4NP_Msk = 0x8000
	// Bit CC4NP.
	TIM_CCER_CC4NP = 0x8000
	// Negative polarity
	TIM_CCER_CC4NP_Negative = 0x0
	// Positive polarity
	TIM_CCER_CC4NP_Positive = 0x1
	// Position of CC4P field.
	TIM_CCER_CC4P_Pos = 0xd
	// Bit mask of CC4P field.
	TIM_CCER_CC4P_Msk = 0x2000
	// Bit CC4P.
	TIM_CCER_CC4P = 0x2000
	// Noninverted/rising edge
	TIM_CCER_CC4P_RisingEdge = 0x0
	// Inverted/falling edge
	TIM_CCER_CC4P_FallingEdge = 0x1
	// Position of CC4E field.
	TIM_CCER_CC4E_Pos = 0xc
	// Bit mask of CC4E field.
	TIM_CCER_CC4E_Msk = 0x1000
	// Bit CC4E.
	TIM_CCER_CC4E = 0x1000
	// Capture disabled
	TIM_CCER_CC4E_Disabled = 0x0
	// Capture enabled
	TIM_CCER_CC4E_Enabled = 0x1
	// Position of CC3NP field.
	TIM_CCER_CC3NP_Pos = 0xb
	// Bit mask of CC3NP field.
	TIM_CCER_CC3NP_Msk = 0x800
	// Bit CC3NP.
	TIM_CCER_CC3NP = 0x800
	// Negative polarity
	TIM_CCER_CC3NP_Negative = 0x0
	// Positive polarity
	TIM_CCER_CC3NP_Positive = 0x1
	// Position of CC3P field.
	TIM_CCER_CC3P_Pos = 0x9
	// Bit mask of CC3P field.
	TIM_CCER_CC3P_Msk = 0x200
	// Bit CC3P.
	TIM_CCER_CC3P = 0x200
	// Noninverted/rising edge
	TIM_CCER_CC3P_RisingEdge = 0x0
	// Inverted/falling edge
	TIM_CCER_CC3P_FallingEdge = 0x1
	// Position of CC3E field.
	TIM_CCER_CC3E_Pos = 0x8
	// Bit mask of CC3E field.
	TIM_CCER_CC3E_Msk = 0x100
	// Bit CC3E.
	TIM_CCER_CC3E = 0x100
	// Capture disabled
	TIM_CCER_CC3E_Disabled = 0x0
	// Capture enabled
	TIM_CCER_CC3E_Enabled = 0x1
	// Position of CC2NP field.
	TIM_CCER_CC2NP_Pos = 0x7
	// Bit mask of CC2NP field.
	TIM_CCER_CC2NP_Msk = 0x80
	// Bit CC2NP.
	TIM_CCER_CC2NP = 0x80
	// Negative polarity
	TIM_CCER_CC2NP_Negative = 0x0
	// Positive polarity
	TIM_CCER_CC2NP_Positive = 0x1
	// Position of CC2P field.
	TIM_CCER_CC2P_Pos = 0x5
	// Bit mask of CC2P field.
	TIM_CCER_CC2P_Msk = 0x20
	// Bit CC2P.
	TIM_CCER_CC2P = 0x20
	// Noninverted/rising edge
	TIM_CCER_CC2P_RisingEdge = 0x0
	// Inverted/falling edge
	TIM_CCER_CC2P_FallingEdge = 0x1
	// Position of CC2E field.
	TIM_CCER_CC2E_Pos = 0x4
	// Bit mask of CC2E field.
	TIM_CCER_CC2E_Msk = 0x10
	// Bit CC2E.
	TIM_CCER_CC2E = 0x10
	// Capture disabled
	TIM_CCER_CC2E_Disabled = 0x0
	// Capture enabled
	TIM_CCER_CC2E_Enabled = 0x1
	// Position of CC1NP field.
	TIM_CCER_CC1NP_Pos = 0x3
	// Bit mask of CC1NP field.
	TIM_CCER_CC1NP_Msk = 0x8
	// Bit CC1NP.
	TIM_CCER_CC1NP = 0x8
	// Negative polarity
	TIM_CCER_CC1NP_Negative = 0x0
	// Positive polarity
	TIM_CCER_CC1NP_Positive = 0x1
	// Position of CC1P field.
	TIM_CCER_CC1P_Pos = 0x1
	// Bit mask of CC1P field.
	TIM_CCER_CC1P_Msk = 0x2
	// Bit CC1P.
	TIM_CCER_CC1P = 0x2
	// Noninverted/rising edge
	TIM_CCER_CC1P_RisingEdge = 0x0
	// Inverted/falling edge
	TIM_CCER_CC1P_FallingEdge = 0x1
	// Position of CC1E field.
	TIM_CCER_CC1E_Pos = 0x0
	// Bit mask of CC1E field.
	TIM_CCER_CC1E_Msk = 0x1
	// Bit CC1E.
	TIM_CCER_CC1E = 0x1
	// Capture disabled
	TIM_CCER_CC1E_Disabled = 0x0
	// Capture enabled
	TIM_CCER_CC1E_Enabled = 0x1

	// CNT: TIMx counter
	// Position of CNT field.
	TIM_CNT_CNT_Pos = 0x0
	// Bit mask of CNT field.
	TIM_CNT_CNT_Msk = 0xffff

	// PSC: prescaler
	// Position of PSC field.
	TIM_PSC_PSC_Pos = 0x0
	// Bit mask of PSC field.
	TIM_PSC_PSC_Msk = 0xffff

	// ARR: TIMx auto-reload register
	// Position of ARR field.
	TIM_ARR_ARR_Pos = 0x0
	// Bit mask of ARR field.
	TIM_ARR_ARR_Msk = 0xffff

	// CCR1: TIMx capture/compare register 1
	// Position of CCR field.
	TIM_CCR_CCR_Pos = 0x0
	// Bit mask of CCR field.
	TIM_CCR_CCR_Msk = 0xffff

	// DCR: DMA control register
	// Position of DBL field.
	TIM_DCR_DBL_Pos = 0x8
	// Bit mask of DBL field.
	TIM_DCR_DBL_Msk = 0x1f00
	// Position of DBA field.
	TIM_DCR_DBA_Pos = 0x0
	// Bit mask of DBA field.
	TIM_DCR_DBA_Msk = 0x1f

	// DMAR: DMA address for full transfer
	// Position of DMAB field.
	TIM_DMAR_DMAB_Pos = 0x0
	// Bit mask of DMAB field.
	TIM_DMAR_DMAB_Msk = 0xffff

	// OR: TIM2 option register
	// Position of ETR_RMP field.
	TIM_OR_ETR_RMP_Pos = 0x0
	// Bit mask of ETR_RMP field.
	TIM_OR_ETR_RMP_Msk = 0x7
	// TIM2 ETR input is connected to COMP1_OUT
	TIM_OR_ETR_RMP_COMP1_OUT = 0x7
	// TIM2 ETR input is connected to COMP2_OUT
	TIM_OR_ETR_RMP_COMP2_OUT = 0x6
	// TIM2 ETR input is connected to LSE
	TIM_OR_ETR_RMP_LSE = 0x5
	// TIM2 ETR input is connected to HSI16 when HSI16OUTEN bit is set
	TIM_OR_ETR_RMP_HSI = 0x3
	// Position of TI4_RMP field.
	TIM_OR_TI4_RMP_Pos = 0x3
	// Bit mask of TI4_RMP field.
	TIM_OR_TI4_RMP_Msk = 0x18
	// TIM2 TI4 input connected to COMP2_OUT
	TIM_OR_TI4_RMP_COMP2_OUT = 0x1
	// TIM2 TI4 input connected to COMP1_OUT
	TIM_OR_TI4_RMP_COMP1_OUT = 0x2
)

// Bitfields for NVIC: Nested Vectored Interrupt Controller
const (
	// ISER: Interrupt Set Enable Register
	// Position of SETENA field.
	NVIC_ISER_SETENA_Pos = 0x0
	// Bit mask of SETENA field.
	NVIC_ISER_SETENA_Msk = 0xffffffff

	// ICER: Interrupt Clear Enable Register
	// Position of CLRENA field.
	NVIC_ICER_CLRENA_Pos = 0x0
	// Bit mask of CLRENA field.
	NVIC_ICER_CLRENA_Msk = 0xffffffff

	// ISPR: Interrupt Set-Pending Register
	// Position of SETPEND field.
	NVIC_ISPR_SETPEND_Pos = 0x0
	// Bit mask of SETPEND field.
	NVIC_ISPR_SETPEND_Msk = 0xffffffff

	// ICPR: Interrupt Clear-Pending Register
	// Position of CLRPEND field.
	NVIC_ICPR_CLRPEND_Pos = 0x0
	// Bit mask of CLRPEND field.
	NVIC_ICPR_CLRPEND_Msk = 0xffffffff

	// IPR0: Interrupt Priority Register 0
	// Position of PRI_0 field.
	NVIC_IPR0_PRI_0_Pos = 0x0
	// Bit mask of PRI_0 field.
	NVIC_IPR0_PRI_0_Msk = 0xff
	// Position of PRI_1 field.
	NVIC_IPR0_PRI_1_Pos = 0x8
	// Bit mask of PRI_1 field.
	NVIC_IPR0_PRI_1_Msk = 0xff00
	// Position of PRI_2 field.
	NVIC_IPR0_PRI_2_Pos = 0x10
	// Bit mask of PRI_2 field.
	NVIC_IPR0_PRI_2_Msk = 0xff0000
	// Position of PRI_3 field.
	NVIC_IPR0_PRI_3_Pos = 0x18
	// Bit mask of PRI_3 field.
	NVIC_IPR0_PRI_3_Msk = 0xff000000

	// IPR1: Interrupt Priority Register 1
	// Position of PRI_4 field.
	NVIC_IPR1_PRI_4_Pos = 0x0
	// Bit mask of PRI_4 field.
	NVIC_IPR1_PRI_4_Msk = 0xff
	// Position of PRI_5 field.
	NVIC_IPR1_PRI_5_Pos = 0x8
	// Bit mask of PRI_5 field.
	NVIC_IPR1_PRI_5_Msk = 0xff00
	// Position of PRI_6 field.
	NVIC_IPR1_PRI_6_Pos = 0x10
	// Bit mask of PRI_6 field.
	NVIC_IPR1_PRI_6_Msk = 0xff0000
	// Position of PRI_7 field.
	NVIC_IPR1_PRI_7_Pos = 0x18
	// Bit mask of PRI_7 field.
	NVIC_IPR1_PRI_7_Msk = 0xff000000

	// IPR2: Interrupt Priority Register 2
	// Position of PRI_8 field.
	NVIC_IPR2_PRI_8_Pos = 0x0
	// Bit mask of PRI_8 field.
	NVIC_IPR2_PRI_8_Msk = 0xff
	// Position of PRI_9 field.
	NVIC_IPR2_PRI_9_Pos = 0x8
	// Bit mask of PRI_9 field.
	NVIC_IPR2_PRI_9_Msk = 0xff00
	// Position of PRI_10 field.
	NVIC_IPR2_PRI_10_Pos = 0x10
	// Bit mask of PRI_10 field.
	NVIC_IPR2_PRI_10_Msk = 0xff0000
	// Position of PRI_11 field.
	NVIC_IPR2_PRI_11_Pos = 0x18
	// Bit mask of PRI_11 field.
	NVIC_IPR2_PRI_11_Msk = 0xff000000

	// IPR3: Interrupt Priority Register 3
	// Position of PRI_12 field.
	NVIC_IPR3_PRI_12_Pos = 0x0
	// Bit mask of PRI_12 field.
	NVIC_IPR3_PRI_12_Msk = 0xff
	// Position of PRI_13 field.
	NVIC_IPR3_PRI_13_Pos = 0x8
	// Bit mask of PRI_13 field.
	NVIC_IPR3_PRI_13_Msk = 0xff00
	// Position of PRI_14 field.
	NVIC_IPR3_PRI_14_Pos = 0x10
	// Bit mask of PRI_14 field.
	NVIC_IPR3_PRI_14_Msk = 0xff0000
	// Position of PRI_15 field.
	NVIC_IPR3_PRI_15_Pos = 0x18
	// Bit mask of PRI_15 field.
	NVIC_IPR3_PRI_15_Msk = 0xff000000

	// IPR4: Interrupt Priority Register 4
	// Position of PRI_16 field.
	NVIC_IPR4_PRI_16_Pos = 0x0
	// Bit mask of PRI_16 field.
	NVIC_IPR4_PRI_16_Msk = 0xff
	// Position of PRI_17 field.
	NVIC_IPR4_PRI_17_Pos = 0x8
	// Bit mask of PRI_17 field.
	NVIC_IPR4_PRI_17_Msk = 0xff00
	// Position of PRI_18 field.
	NVIC_IPR4_PRI_18_Pos = 0x10
	// Bit mask of PRI_18 field.
	NVIC_IPR4_PRI_18_Msk = 0xff0000
	// Position of PRI_19 field.
	NVIC_IPR4_PRI_19_Pos = 0x18
	// Bit mask of PRI_19 field.
	NVIC_IPR4_PRI_19_Msk = 0xff000000

	// IPR5: Interrupt Priority Register 5
	// Position of PRI_20 field.
	NVIC_IPR5_PRI_20_Pos = 0x0
	// Bit mask of PRI_20 field.
	NVIC_IPR5_PRI_20_Msk = 0xff
	// Position of PRI_21 field.
	NVIC_IPR5_PRI_21_Pos = 0x8
	// Bit mask of PRI_21 field.
	NVIC_IPR5_PRI_21_Msk = 0xff00
	// Position of PRI_22 field.
	NVIC_IPR5_PRI_22_Pos = 0x10
	// Bit mask of PRI_22 field.
	NVIC_IPR5_PRI_22_Msk = 0xff0000
	// Position of PRI_23 field.
	NVIC_IPR5_PRI_23_Pos = 0x18
	// Bit mask of PRI_23 field.
	NVIC_IPR5_PRI_23_Msk = 0xff000000

	// IPR6: Interrupt Priority Register 6
	// Position of PRI_24 field.
	NVIC_IPR6_PRI_24_Pos = 0x0
	// Bit mask of PRI_24 field.
	NVIC_IPR6_PRI_24_Msk = 0xff
	// Position of PRI_25 field.
	NVIC_IPR6_PRI_25_Pos = 0x8
	// Bit mask of PRI_25 field.
	NVIC_IPR6_PRI_25_Msk = 0xff00
	// Position of PRI_26 field.
	NVIC_IPR6_PRI_26_Pos = 0x10
	// Bit mask of PRI_26 field.
	NVIC_IPR6_PRI_26_Msk = 0xff0000
	// Position of PRI_27 field.
	NVIC_IPR6_PRI_27_Pos = 0x18
	// Bit mask of PRI_27 field.
	NVIC_IPR6_PRI_27_Msk = 0xff000000

	// IPR7: Interrupt Priority Register 7
	// Position of PRI_28 field.
	NVIC_IPR7_PRI_28_Pos = 0x0
	// Bit mask of PRI_28 field.
	NVIC_IPR7_PRI_28_Msk = 0xff
	// Position of PRI_29 field.
	NVIC_IPR7_PRI_29_Pos = 0x8
	// Bit mask of PRI_29 field.
	NVIC_IPR7_PRI_29_Msk = 0xff00
	// Position of PRI_30 field.
	NVIC_IPR7_PRI_30_Pos = 0x10
	// Bit mask of PRI_30 field.
	NVIC_IPR7_PRI_30_Msk = 0xff0000
	// Position of PRI_31 field.
	NVIC_IPR7_PRI_31_Pos = 0x18
	// Bit mask of PRI_31 field.
	NVIC_IPR7_PRI_31_Msk = 0xff000000
)

// Bitfields for MPU: Memory protection unit
const (
	// MPU_TYPER: MPU type register
	// Position of SEPARATE field.
	MPU_MPU_TYPER_SEPARATE_Pos = 0x0
	// Bit mask of SEPARATE field.
	MPU_MPU_TYPER_SEPARATE_Msk = 0x1
	// Bit SEPARATE.
	MPU_MPU_TYPER_SEPARATE = 0x1
	// Position of DREGION field.
	MPU_MPU_TYPER_DREGION_Pos = 0x8
	// Bit mask of DREGION field.
	MPU_MPU_TYPER_DREGION_Msk = 0xff00
	// Position of IREGION field.
	MPU_MPU_TYPER_IREGION_Pos = 0x10
	// Bit mask of IREGION field.
	MPU_MPU_TYPER_IREGION_Msk = 0xff0000

	// MPU_CTRL: MPU control register
	// Position of ENABLE field.
	MPU_MPU_CTRL_ENABLE_Pos = 0x0
	// Bit mask of ENABLE field.
	MPU_MPU_CTRL_ENABLE_Msk = 0x1
	// Bit ENABLE.
	MPU_MPU_CTRL_ENABLE = 0x1
	// Position of HFNMIENA field.
	MPU_MPU_CTRL_HFNMIENA_Pos = 0x1
	// Bit mask of HFNMIENA field.
	MPU_MPU_CTRL_HFNMIENA_Msk = 0x2
	// Bit HFNMIENA.
	MPU_MPU_CTRL_HFNMIENA = 0x2
	// Position of PRIVDEFENA field.
	MPU_MPU_CTRL_PRIVDEFENA_Pos = 0x2
	// Bit mask of PRIVDEFENA field.
	MPU_MPU_CTRL_PRIVDEFENA_Msk = 0x4
	// Bit PRIVDEFENA.
	MPU_MPU_CTRL_PRIVDEFENA = 0x4

	// MPU_RNR: MPU region number register
	// Position of REGION field.
	MPU_MPU_RNR_REGION_Pos = 0x0
	// Bit mask of REGION field.
	MPU_MPU_RNR_REGION_Msk = 0xff

	// MPU_RBAR: MPU region base address register
	// Position of REGION field.
	MPU_MPU_RBAR_REGION_Pos = 0x0
	// Bit mask of REGION field.
	MPU_MPU_RBAR_REGION_Msk = 0xf
	// Position of VALID field.
	MPU_MPU_RBAR_VALID_Pos = 0x4
	// Bit mask of VALID field.
	MPU_MPU_RBAR_VALID_Msk = 0x10
	// Bit VALID.
	MPU_MPU_RBAR_VALID = 0x10
	// Position of ADDR field.
	MPU_MPU_RBAR_ADDR_Pos = 0x5
	// Bit mask of ADDR field.
	MPU_MPU_RBAR_ADDR_Msk = 0xffffffe0

	// MPU_RASR: MPU region attribute and size register
	// Position of ENABLE field.
	MPU_MPU_RASR_ENABLE_Pos = 0x0
	// Bit mask of ENABLE field.
	MPU_MPU_RASR_ENABLE_Msk = 0x1
	// Bit ENABLE.
	MPU_MPU_RASR_ENABLE = 0x1
	// Position of SIZE field.
	MPU_MPU_RASR_SIZE_Pos = 0x1
	// Bit mask of SIZE field.
	MPU_MPU_RASR_SIZE_Msk = 0x3e
	// Position of SRD field.
	MPU_MPU_RASR_SRD_Pos = 0x8
	// Bit mask of SRD field.
	MPU_MPU_RASR_SRD_Msk = 0xff00
	// Position of B field.
	MPU_MPU_RASR_B_Pos = 0x10
	// Bit mask of B field.
	MPU_MPU_RASR_B_Msk = 0x10000
	// Bit B.
	MPU_MPU_RASR_B = 0x10000
	// Position of C field.
	MPU_MPU_RASR_C_Pos = 0x11
	// Bit mask of C field.
	MPU_MPU_RASR_C_Msk = 0x20000
	// Bit C.
	MPU_MPU_RASR_C = 0x20000
	// Position of S field.
	MPU_MPU_RASR_S_Pos = 0x12
	// Bit mask of S field.
	MPU_MPU_RASR_S_Msk = 0x40000
	// Bit S.
	MPU_MPU_RASR_S = 0x40000
	// Position of TEX field.
	MPU_MPU_RASR_TEX_Pos = 0x13
	// Bit mask of TEX field.
	MPU_MPU_RASR_TEX_Msk = 0x380000
	// Position of AP field.
	MPU_MPU_RASR_AP_Pos = 0x18
	// Bit mask of AP field.
	MPU_MPU_RASR_AP_Msk = 0x7000000
	// Position of XN field.
	MPU_MPU_RASR_XN_Pos = 0x1c
	// Bit mask of XN field.
	MPU_MPU_RASR_XN_Msk = 0x10000000
	// Bit XN.
	MPU_MPU_RASR_XN = 0x10000000
)

// Bitfields for STK: SysTick timer
const (
	// CSR: SysTick control and status register
	// Position of ENABLE field.
	STK_CSR_ENABLE_Pos = 0x0
	// Bit mask of ENABLE field.
	STK_CSR_ENABLE_Msk = 0x1
	// Bit ENABLE.
	STK_CSR_ENABLE = 0x1
	// Position of TICKINT field.
	STK_CSR_TICKINT_Pos = 0x1
	// Bit mask of TICKINT field.
	STK_CSR_TICKINT_Msk = 0x2
	// Bit TICKINT.
	STK_CSR_TICKINT = 0x2
	// Position of CLKSOURCE field.
	STK_CSR_CLKSOURCE_Pos = 0x2
	// Bit mask of CLKSOURCE field.
	STK_CSR_CLKSOURCE_Msk = 0x4
	// Bit CLKSOURCE.
	STK_CSR_CLKSOURCE = 0x4
	// Position of COUNTFLAG field.
	STK_CSR_COUNTFLAG_Pos = 0x10
	// Bit mask of COUNTFLAG field.
	STK_CSR_COUNTFLAG_Msk = 0x10000
	// Bit COUNTFLAG.
	STK_CSR_COUNTFLAG = 0x10000

	// RVR: SysTick reload value register
	// Position of RELOAD field.
	STK_RVR_RELOAD_Pos = 0x0
	// Bit mask of RELOAD field.
	STK_RVR_RELOAD_Msk = 0xffffff

	// CVR: SysTick current value register
	// Position of CURRENT field.
	STK_CVR_CURRENT_Pos = 0x0
	// Bit mask of CURRENT field.
	STK_CVR_CURRENT_Msk = 0xffffff

	// CALIB: SysTick calibration value register
	// Position of TENMS field.
	STK_CALIB_TENMS_Pos = 0x0
	// Bit mask of TENMS field.
	STK_CALIB_TENMS_Msk = 0xffffff
	// Position of SKEW field.
	STK_CALIB_SKEW_Pos = 0x1e
	// Bit mask of SKEW field.
	STK_CALIB_SKEW_Msk = 0x40000000
	// Bit SKEW.
	STK_CALIB_SKEW = 0x40000000
	// Position of NOREF field.
	STK_CALIB_NOREF_Pos = 0x1f
	// Bit mask of NOREF field.
	STK_CALIB_NOREF_Msk = 0x80000000
	// Bit NOREF.
	STK_CALIB_NOREF = 0x80000000
)

// Bitfields for SCB: System control block
const (
	// CPUID: CPUID base register
	// Position of Revision field.
	SCB_CPUID_Revision_Pos = 0x0
	// Bit mask of Revision field.
	SCB_CPUID_Revision_Msk = 0xf
	// Position of PartNo field.
	SCB_CPUID_PartNo_Pos = 0x4
	// Bit mask of PartNo field.
	SCB_CPUID_PartNo_Msk = 0xfff0
	// Position of Architecture field.
	SCB_CPUID_Architecture_Pos = 0x10
	// Bit mask of Architecture field.
	SCB_CPUID_Architecture_Msk = 0xf0000
	// Position of Variant field.
	SCB_CPUID_Variant_Pos = 0x14
	// Bit mask of Variant field.
	SCB_CPUID_Variant_Msk = 0xf00000
	// Position of Implementer field.
	SCB_CPUID_Implementer_Pos = 0x18
	// Bit mask of Implementer field.
	SCB_CPUID_Implementer_Msk = 0xff000000

	// ICSR: Interrupt control and state register
	// Position of VECTACTIVE field.
	SCB_ICSR_VECTACTIVE_Pos = 0x0
	// Bit mask of VECTACTIVE field.
	SCB_ICSR_VECTACTIVE_Msk = 0x1ff
	// Position of RETTOBASE field.
	SCB_ICSR_RETTOBASE_Pos = 0xb
	// Bit mask of RETTOBASE field.
	SCB_ICSR_RETTOBASE_Msk = 0x800
	// Bit RETTOBASE.
	SCB_ICSR_RETTOBASE = 0x800
	// Position of VECTPENDING field.
	SCB_ICSR_VECTPENDING_Pos = 0xc
	// Bit mask of VECTPENDING field.
	SCB_ICSR_VECTPENDING_Msk = 0x7f000
	// Position of ISRPENDING field.
	SCB_ICSR_ISRPENDING_Pos = 0x16
	// Bit mask of ISRPENDING field.
	SCB_ICSR_ISRPENDING_Msk = 0x400000
	// Bit ISRPENDING.
	SCB_ICSR_ISRPENDING = 0x400000
	// Position of PENDSTCLR field.
	SCB_ICSR_PENDSTCLR_Pos = 0x19
	// Bit mask of PENDSTCLR field.
	SCB_ICSR_PENDSTCLR_Msk = 0x2000000
	// Bit PENDSTCLR.
	SCB_ICSR_PENDSTCLR = 0x2000000
	// Position of PENDSTSET field.
	SCB_ICSR_PENDSTSET_Pos = 0x1a
	// Bit mask of PENDSTSET field.
	SCB_ICSR_PENDSTSET_Msk = 0x4000000
	// Bit PENDSTSET.
	SCB_ICSR_PENDSTSET = 0x4000000
	// Position of PENDSVCLR field.
	SCB_ICSR_PENDSVCLR_Pos = 0x1b
	// Bit mask of PENDSVCLR field.
	SCB_ICSR_PENDSVCLR_Msk = 0x8000000
	// Bit PENDSVCLR.
	SCB_ICSR_PENDSVCLR = 0x8000000
	// Position of PENDSVSET field.
	SCB_ICSR_PENDSVSET_Pos = 0x1c
	// Bit mask of PENDSVSET field.
	SCB_ICSR_PENDSVSET_Msk = 0x10000000
	// Bit PENDSVSET.
	SCB_ICSR_PENDSVSET = 0x10000000
	// Position of NMIPENDSET field.
	SCB_ICSR_NMIPENDSET_Pos = 0x1f
	// Bit mask of NMIPENDSET field.
	SCB_ICSR_NMIPENDSET_Msk = 0x80000000
	// Bit NMIPENDSET.
	SCB_ICSR_NMIPENDSET = 0x80000000

	// VTOR: Vector table offset register
	// Position of TBLOFF field.
	SCB_VTOR_TBLOFF_Pos = 0x7
	// Bit mask of TBLOFF field.
	SCB_VTOR_TBLOFF_Msk = 0xffffff80

	// AIRCR: Application interrupt and reset control register
	// Position of VECTCLRACTIVE field.
	SCB_AIRCR_VECTCLRACTIVE_Pos = 0x1
	// Bit mask of VECTCLRACTIVE field.
	SCB_AIRCR_VECTCLRACTIVE_Msk = 0x2
	// Bit VECTCLRACTIVE.
	SCB_AIRCR_VECTCLRACTIVE = 0x2
	// Position of SYSRESETREQ field.
	SCB_AIRCR_SYSRESETREQ_Pos = 0x2
	// Bit mask of SYSRESETREQ field.
	SCB_AIRCR_SYSRESETREQ_Msk = 0x4
	// Bit SYSRESETREQ.
	SCB_AIRCR_SYSRESETREQ = 0x4
	// Position of ENDIANESS field.
	SCB_AIRCR_ENDIANESS_Pos = 0xf
	// Bit mask of ENDIANESS field.
	SCB_AIRCR_ENDIANESS_Msk = 0x8000
	// Bit ENDIANESS.
	SCB_AIRCR_ENDIANESS = 0x8000
	// Position of VECTKEYSTAT field.
	SCB_AIRCR_VECTKEYSTAT_Pos = 0x10
	// Bit mask of VECTKEYSTAT field.
	SCB_AIRCR_VECTKEYSTAT_Msk = 0xffff0000

	// SCR: System control register
	// Position of SLEEPONEXIT field.
	SCB_SCR_SLEEPONEXIT_Pos = 0x1
	// Bit mask of SLEEPONEXIT field.
	SCB_SCR_SLEEPONEXIT_Msk = 0x2
	// Bit SLEEPONEXIT.
	SCB_SCR_SLEEPONEXIT = 0x2
	// Position of SLEEPDEEP field.
	SCB_SCR_SLEEPDEEP_Pos = 0x2
	// Bit mask of SLEEPDEEP field.
	SCB_SCR_SLEEPDEEP_Msk = 0x4
	// Bit SLEEPDEEP.
	SCB_SCR_SLEEPDEEP = 0x4
	// Position of SEVEONPEND field.
	SCB_SCR_SEVEONPEND_Pos = 0x4
	// Bit mask of SEVEONPEND field.
	SCB_SCR_SEVEONPEND_Msk = 0x10
	// Bit SEVEONPEND.
	SCB_SCR_SEVEONPEND = 0x10

	// CCR: Configuration and control register
	// Position of NONBASETHRDENA field.
	SCB_CCR_NONBASETHRDENA_Pos = 0x0
	// Bit mask of NONBASETHRDENA field.
	SCB_CCR_NONBASETHRDENA_Msk = 0x1
	// Bit NONBASETHRDENA.
	SCB_CCR_NONBASETHRDENA = 0x1
	// Position of USERSETMPEND field.
	SCB_CCR_USERSETMPEND_Pos = 0x1
	// Bit mask of USERSETMPEND field.
	SCB_CCR_USERSETMPEND_Msk = 0x2
	// Bit USERSETMPEND.
	SCB_CCR_USERSETMPEND = 0x2
	// Position of UNALIGN__TRP field.
	SCB_CCR_UNALIGN__TRP_Pos = 0x3
	// Bit mask of UNALIGN__TRP field.
	SCB_CCR_UNALIGN__TRP_Msk = 0x8
	// Bit UNALIGN__TRP.
	SCB_CCR_UNALIGN__TRP = 0x8
	// Position of DIV_0_TRP field.
	SCB_CCR_DIV_0_TRP_Pos = 0x4
	// Bit mask of DIV_0_TRP field.
	SCB_CCR_DIV_0_TRP_Msk = 0x10
	// Bit DIV_0_TRP.
	SCB_CCR_DIV_0_TRP = 0x10
	// Position of BFHFNMIGN field.
	SCB_CCR_BFHFNMIGN_Pos = 0x8
	// Bit mask of BFHFNMIGN field.
	SCB_CCR_BFHFNMIGN_Msk = 0x100
	// Bit BFHFNMIGN.
	SCB_CCR_BFHFNMIGN = 0x100
	// Position of STKALIGN field.
	SCB_CCR_STKALIGN_Pos = 0x9
	// Bit mask of STKALIGN field.
	SCB_CCR_STKALIGN_Msk = 0x200
	// Bit STKALIGN.
	SCB_CCR_STKALIGN = 0x200

	// SHPR2: System handler priority registers
	// Position of PRI_11 field.
	SCB_SHPR2_PRI_11_Pos = 0x18
	// Bit mask of PRI_11 field.
	SCB_SHPR2_PRI_11_Msk = 0xff000000

	// SHPR3: System handler priority registers
	// Position of PRI_14 field.
	SCB_SHPR3_PRI_14_Pos = 0x10
	// Bit mask of PRI_14 field.
	SCB_SHPR3_PRI_14_Msk = 0xff0000
	// Position of PRI_15 field.
	SCB_SHPR3_PRI_15_Pos = 0x18
	// Bit mask of PRI_15 field.
	SCB_SHPR3_PRI_15_Msk = 0xff000000
)
