/*
 * Decompiled with CFR 0.152.
 */
package mediathek.tool.notification;

import java.awt.SystemTray;
import java.awt.TrayIcon;
import java.io.IOException;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import mediathek.config.Icons;
import mediathek.config.Konstanten;
import mediathek.tool.notification.INotificationCenter;
import mediathek.tool.notification.MessageType;
import mediathek.tool.notification.NotificationMessage;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \n2\u00020\u0001:\u0001\nB\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\tH\u0016R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lmediathek/tool/notification/WinNotificationCenter;", "Lmediathek/tool/notification/INotificationCenter;", "()V", "trayIcon", "Ljava/awt/TrayIcon;", "close", "", "displayNotification", "msg", "Lmediathek/tool/notification/NotificationMessage;", "Companion", "MediathekView"})
public final class WinNotificationCenter
implements INotificationCenter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private TrayIcon trayIcon;
    @NotNull
    private static final Logger logger;

    public WinNotificationCenter() {
        if (!SystemTray.isSupported()) {
            logger.error("System Tray is not supported!");
        } else {
            SystemTray tray = SystemTray.getSystemTray();
            TrayIcon trayIcon = this.trayIcon = new TrayIcon(Icons.ICON_TRAY, Intrinsics.stringPlus("MediathekView ", Konstanten.MVVERSION));
            Intrinsics.checkNotNull(trayIcon);
            trayIcon.setImageAutoSize(true);
            tray.add(this.trayIcon);
        }
    }

    @Override
    public void displayNotification(@NotNull NotificationMessage msg) {
        Intrinsics.checkNotNullParameter(msg, "msg");
        if (this.trayIcon != null) {
            Object object = msg.getType();
            int n = WhenMappings.$EnumSwitchMapping$0[((Enum)object).ordinal()];
            TrayIcon.MessageType type = switch (n) {
                case 1 -> TrayIcon.MessageType.INFO;
                case 2 -> TrayIcon.MessageType.ERROR;
                default -> throw new NoWhenBranchMatchedException();
            };
            object = this.trayIcon;
            Intrinsics.checkNotNull(object);
            ((TrayIcon)object).displayMessage(msg.getTitle(), msg.getMessage(), type);
        } else {
            logger.error("TrayIcon is null, not displaying notification");
        }
    }

    @Override
    public void close() throws IOException {
        if (this.trayIcon != null) {
            SystemTray.getSystemTray().remove(this.trayIcon);
        }
    }

    static {
        Logger logger = LogManager.getLogger();
        Intrinsics.checkNotNullExpressionValue(logger, "getLogger()");
        WinNotificationCenter.logger = logger;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lmediathek/tool/notification/WinNotificationCenter$Companion;", "", "()V", "logger", "Lorg/apache/logging/log4j/Logger;", "getLogger", "()Lorg/apache/logging/log4j/Logger;", "MediathekView"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Logger getLogger() {
            return logger;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 5, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[MessageType.values().length];
            nArray[MessageType.INFO.ordinal()] = 1;
            nArray[MessageType.ERROR.ordinal()] = 2;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

