from enum import IntEnum
from typing import overload, NewType, Optional, Tuple

from OCC.Core.Standard import *
from OCC.Core.NCollection import *
from OCC.Core.TDF import *
from OCC.Core.TColStd import *

#the following typedef cannot be wrapped as is
TFunction_DoubleMapIteratorOfDoubleMapOfIntegerLabel = NewType('TFunction_DoubleMapIteratorOfDoubleMapOfIntegerLabel', Any)
#the following typedef cannot be wrapped as is
TFunction_DoubleMapOfIntegerLabel = NewType('TFunction_DoubleMapOfIntegerLabel', Any)

class TFunction_Array1OfDataMapOfGUIDDriver:
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, theLower: int, theUpper: int) -> None: ...
    def __getitem__(self, index: int) -> TFunction_DataMapOfGUIDDriver: ...
    def __setitem__(self, index: int, value: TFunction_DataMapOfGUIDDriver) -> None: ...
    def __len__(self) -> int: ...
    def __iter__(self) -> Iterator[TFunction_DataMapOfGUIDDriver]: ...
    def next(self) -> TFunction_DataMapOfGUIDDriver: ...
    __next__ = next
    def Init(self, theValue: TFunction_DataMapOfGUIDDriver) -> None: ...
    def Size(self) -> int: ...
    def Length(self) -> int: ...
    def IsEmpty(self) -> bool: ...
    def Lower(self) -> int: ...
    def Upper(self) -> int: ...
    def IsDetectable(self) -> bool: ...
    def IsAllocated(self) -> bool: ...
    def First(self) -> TFunction_DataMapOfGUIDDriver: ...
    def Last(self) -> TFunction_DataMapOfGUIDDriver: ...
    def Value(self, theIndex: int) -> TFunction_DataMapOfGUIDDriver: ...
    def SetValue(self, theIndex: int, theValue: TFunction_DataMapOfGUIDDriver) -> None: ...

class TFunction_ExecutionStatus(IntEnum):
	TFunction_ES_WrongDefinition: int = ...
	TFunction_ES_NotExecuted: int = ...
	TFunction_ES_Executing: int = ...
	TFunction_ES_Succeeded: int = ...
	TFunction_ES_Failed: int = ...
TFunction_ES_WrongDefinition = TFunction_ExecutionStatus.TFunction_ES_WrongDefinition
TFunction_ES_NotExecuted = TFunction_ExecutionStatus.TFunction_ES_NotExecuted
TFunction_ES_Executing = TFunction_ExecutionStatus.TFunction_ES_Executing
TFunction_ES_Succeeded = TFunction_ExecutionStatus.TFunction_ES_Succeeded
TFunction_ES_Failed = TFunction_ExecutionStatus.TFunction_ES_Failed

class TFunction_Driver(Standard_Transient):
	def Arguments(self, args: TDF_LabelList) -> None: ...
	def Execute(self, log: TFunction_Logbook) -> int: ...
	def Init(self, L: TDF_Label) -> None: ...
	def Label(self) -> TDF_Label: ...
	def MustExecute(self, log: TFunction_Logbook) -> bool: ...
	def Results(self, res: TDF_LabelList) -> None: ...
	def Validate(self, log: TFunction_Logbook) -> None: ...

class TFunction_DriverTable(Standard_Transient):
	def __init__(self) -> None: ...
	def AddDriver(self, guid: Standard_GUID, driver: TFunction_Driver, thread: Optional[int] = 0) -> bool: ...
	def Clear(self) -> None: ...
	def FindDriver(self, guid: Standard_GUID, driver: TFunction_Driver, thread: Optional[int] = 0) -> bool: ...
	@staticmethod
	def Get() -> TFunction_DriverTable: ...
	def HasDriver(self, guid: Standard_GUID, thread: Optional[int] = 0) -> bool: ...
	def RemoveDriver(self, guid: Standard_GUID, thread: Optional[int] = 0) -> bool: ...

class TFunction_Function(TDF_Attribute):
	def __init__(self) -> None: ...
	def Failed(self) -> bool: ...
	def GetDriverGUID(self) -> Standard_GUID: ...
	def GetFailure(self) -> int: ...
	@staticmethod
	def GetID() -> Standard_GUID: ...
	def ID(self) -> Standard_GUID: ...
	def NewEmpty(self) -> TDF_Attribute: ...
	def Paste(self, into: TDF_Attribute, RT: TDF_RelocationTable) -> None: ...
	def References(self, aDataSet: TDF_DataSet) -> None: ...
	def Restore(self, with_: TDF_Attribute) -> None: ...
	@overload
	@staticmethod
	def Set(L: TDF_Label) -> TFunction_Function: ...
	@overload
	@staticmethod
	def Set(L: TDF_Label, DriverID: Standard_GUID) -> TFunction_Function: ...
	def SetDriverGUID(self, guid: Standard_GUID) -> None: ...
	def SetFailure(self, mode: Optional[int] = 0) -> None: ...

class TFunction_GraphNode(TDF_Attribute):
	def __init__(self) -> None: ...
	@overload
	def AddNext(self, funcID: int) -> bool: ...
	@overload
	def AddNext(self, func: TDF_Label) -> bool: ...
	@overload
	def AddPrevious(self, funcID: int) -> bool: ...
	@overload
	def AddPrevious(self, func: TDF_Label) -> bool: ...
	@staticmethod
	def GetID() -> Standard_GUID: ...
	def GetNext(self) -> TColStd_MapOfInteger: ...
	def GetPrevious(self) -> TColStd_MapOfInteger: ...
	def GetStatus(self) -> TFunction_ExecutionStatus: ...
	def ID(self) -> Standard_GUID: ...
	def NewEmpty(self) -> TDF_Attribute: ...
	def Paste(self, into: TDF_Attribute, RT: TDF_RelocationTable) -> None: ...
	def References(self, aDataSet: TDF_DataSet) -> None: ...
	def RemoveAllNext(self) -> None: ...
	def RemoveAllPrevious(self) -> None: ...
	@overload
	def RemoveNext(self, funcID: int) -> bool: ...
	@overload
	def RemoveNext(self, func: TDF_Label) -> bool: ...
	@overload
	def RemovePrevious(self, funcID: int) -> bool: ...
	@overload
	def RemovePrevious(self, func: TDF_Label) -> bool: ...
	def Restore(self, with_: TDF_Attribute) -> None: ...
	@staticmethod
	def Set(L: TDF_Label) -> TFunction_GraphNode: ...
	def SetStatus(self, status: TFunction_ExecutionStatus) -> None: ...

class TFunction_IFunction:
	@overload
	def __init__(self) -> None: ...
	@overload
	def __init__(self, L: TDF_Label) -> None: ...
	def Arguments(self, args: TDF_LabelList) -> None: ...
	@staticmethod
	def DeleteFunction(L: TDF_Label) -> bool: ...
	def GetAllFunctions(self) -> TFunction_DoubleMapOfIntegerLabel: ...
	def GetDriver(self, thread: Optional[int] = 0) -> TFunction_Driver: ...
	def GetGraphNode(self) -> TFunction_GraphNode: ...
	def GetLogbook(self) -> TFunction_Logbook: ...
	def GetNext(self, prev: TDF_LabelList) -> None: ...
	def GetPrevious(self, prev: TDF_LabelList) -> None: ...
	def GetStatus(self) -> TFunction_ExecutionStatus: ...
	def Init(self, L: TDF_Label) -> None: ...
	def Label(self) -> TDF_Label: ...
	@staticmethod
	def NewFunction(L: TDF_Label, ID: Standard_GUID) -> bool: ...
	def Results(self, res: TDF_LabelList) -> None: ...
	def SetStatus(self, status: TFunction_ExecutionStatus) -> None: ...
	@overload
	@staticmethod
	def UpdateDependencies(Access: TDF_Label) -> bool: ...
	@overload
	def UpdateDependencies(self) -> bool: ...

class TFunction_Iterator:
	@overload
	def __init__(self) -> None: ...
	@overload
	def __init__(self, Access: TDF_Label) -> None: ...
	def Current(self) -> TDF_LabelList: ...
	def GetMaxNbThreads(self) -> int: ...
	def GetStatus(self, func: TDF_Label) -> TFunction_ExecutionStatus: ...
	def GetUsageOfExecutionStatus(self) -> bool: ...
	def Init(self, Access: TDF_Label) -> None: ...
	def More(self) -> bool: ...
	def Next(self) -> None: ...
	def SetStatus(self, func: TDF_Label, status: TFunction_ExecutionStatus) -> None: ...
	def SetUsageOfExecutionStatus(self, usage: bool) -> None: ...

class TFunction_Logbook(TDF_Attribute):
	def __init__(self) -> None: ...
	def Clear(self) -> None: ...
	def Done(self, status: bool) -> None: ...
	@staticmethod
	def GetID() -> Standard_GUID: ...
	def GetImpacted(self) -> TDF_LabelMap: ...
	def GetTouched(self) -> TDF_LabelMap: ...
	@overload
	def GetValid(self) -> TDF_LabelMap: ...
	@overload
	def GetValid(self, Ls: TDF_LabelMap) -> None: ...
	def ID(self) -> Standard_GUID: ...
	def IsDone(self) -> bool: ...
	def IsEmpty(self) -> bool: ...
	def IsModified(self, L: TDF_Label, WithChildren: Optional[bool] = False) -> bool: ...
	def NewEmpty(self) -> TDF_Attribute: ...
	def Paste(self, into: TDF_Attribute, RT: TDF_RelocationTable) -> None: ...
	def Restore(self, with_: TDF_Attribute) -> None: ...
	@staticmethod
	def Set(Access: TDF_Label) -> TFunction_Logbook: ...
	def SetImpacted(self, L: TDF_Label, WithChildren: Optional[bool] = False) -> None: ...
	def SetTouched(self, L: TDF_Label) -> None: ...
	@overload
	def SetValid(self, L: TDF_Label, WithChildren: Optional[bool] = False) -> None: ...
	@overload
	def SetValid(self, Ls: TDF_LabelMap) -> None: ...

class TFunction_Scope(TDF_Attribute):
	def __init__(self) -> None: ...
	def AddFunction(self, L: TDF_Label) -> bool: ...
	def ChangeFunctions(self) -> TFunction_DoubleMapOfIntegerLabel: ...
	def GetFreeID(self) -> int: ...
	@overload
	def GetFunction(self, L: TDF_Label) -> int: ...
	@overload
	def GetFunction(self, ID: int) -> TDF_Label: ...
	def GetFunctions(self) -> TFunction_DoubleMapOfIntegerLabel: ...
	@staticmethod
	def GetID() -> Standard_GUID: ...
	def GetLogbook(self) -> TFunction_Logbook: ...
	@overload
	def HasFunction(self, ID: int) -> bool: ...
	@overload
	def HasFunction(self, L: TDF_Label) -> bool: ...
	def ID(self) -> Standard_GUID: ...
	def NewEmpty(self) -> TDF_Attribute: ...
	def Paste(self, into: TDF_Attribute, RT: TDF_RelocationTable) -> None: ...
	def RemoveAllFunctions(self) -> None: ...
	@overload
	def RemoveFunction(self, L: TDF_Label) -> bool: ...
	@overload
	def RemoveFunction(self, ID: int) -> bool: ...
	def Restore(self, with_: TDF_Attribute) -> None: ...
	@staticmethod
	def Set(Access: TDF_Label) -> TFunction_Scope: ...
	def SetFreeID(self, ID: int) -> None: ...

# harray1 classes

class TFunction_HArray1OfDataMapOfGUIDDriver(TFunction_Array1OfDataMapOfGUIDDriver, Standard_Transient):
    def __init__(self, theLower: int, theUpper: int) -> None: ...
    def Array1(self) -> TFunction_Array1OfDataMapOfGUIDDriver: ...

# harray2 classes
# hsequence classes

TFunction_DriverTable_Get = TFunction_DriverTable.Get
TFunction_Function_GetID = TFunction_Function.GetID
TFunction_Function_Set = TFunction_Function.Set
TFunction_Function_Set = TFunction_Function.Set
TFunction_GraphNode_GetID = TFunction_GraphNode.GetID
TFunction_GraphNode_Set = TFunction_GraphNode.Set
TFunction_IFunction_DeleteFunction = TFunction_IFunction.DeleteFunction
TFunction_IFunction_NewFunction = TFunction_IFunction.NewFunction
TFunction_IFunction_UpdateDependencies = TFunction_IFunction.UpdateDependencies
TFunction_Logbook_GetID = TFunction_Logbook.GetID
TFunction_Logbook_Set = TFunction_Logbook.Set
TFunction_Scope_GetID = TFunction_Scope.GetID
TFunction_Scope_Set = TFunction_Scope.Set
