// Automatically generated file. DO NOT EDIT.
// Generated by gen-device-svd.go from ATSAM3U1C.svd, see https://github.com/posborne/cmsis-svd/tree/master/data/Atmel

//go:build sam && atsam3u1c
// +build sam,atsam3u1c

// Atmel ATSAM3U1C Microcontroller
//

package sam

import (
	"runtime/volatile"
	"unsafe"
)

// Some information about this device.
const (
	Device       = "ATSAM3U1C"
	CPU          = "CM3"
	FPUPresent   = false
	NVICPrioBits = 4
)

// Interrupt numbers.
const (
	// Power Management Controller
	IRQ_PMC = 5

	// Embedded Flash Controller 0
	IRQ_EFC0 = 6

	// Universal Asynchronous Receiver Transmitter
	IRQ_UART = 8

	// Parallel Input/Output Controller A
	IRQ_PIOA = 10

	// Parallel Input/Output Controller B
	IRQ_PIOB = 11

	// Universal Synchronous Asynchronous Receiver Transmitter 0
	IRQ_USART0 = 13

	// Universal Synchronous Asynchronous Receiver Transmitter 1
	IRQ_USART1 = 14

	// Universal Synchronous Asynchronous Receiver Transmitter 2
	IRQ_USART2 = 15

	// High Speed MultiMedia Card Interface
	IRQ_HSMCI = 17

	// Two-wire Interface 0
	IRQ_TWI0 = 18

	// Two-wire Interface 1
	IRQ_TWI1 = 19

	// Serial Peripheral Interface
	IRQ_SPI = 20

	// Synchronous Serial Controller
	IRQ_SSC = 21

	// Timer Counter 0
	IRQ_TC0 = 22

	// Timer Counter 0
	IRQ_TC1 = 23

	// Timer Counter 0
	IRQ_TC2 = 24

	// Pulse Width Modulation Controller
	IRQ_PWM = 25

	// Analog-to-Digital Converter 12bits
	IRQ_ADC12B = 26

	// Analog-to-Digital Converter
	IRQ_ADC = 27

	// DMA Controller
	IRQ_DMAC = 28

	// USB High Speed Device Port
	IRQ_UDPHS = 29

	// Highest interrupt number on this device.
	IRQ_max = 29
)

// Pseudo function call that is replaced by the compiler with the actual
// functions registered through interrupt.New.
//go:linkname callHandlers runtime/interrupt.callHandlers
func callHandlers(num int)

//export PMC_IRQHandler
func interruptPMC() {
	callHandlers(IRQ_PMC)
}

//export EFC0_IRQHandler
func interruptEFC0() {
	callHandlers(IRQ_EFC0)
}

//export UART_IRQHandler
func interruptUART() {
	callHandlers(IRQ_UART)
}

//export PIOA_IRQHandler
func interruptPIOA() {
	callHandlers(IRQ_PIOA)
}

//export PIOB_IRQHandler
func interruptPIOB() {
	callHandlers(IRQ_PIOB)
}

//export USART0_IRQHandler
func interruptUSART0() {
	callHandlers(IRQ_USART0)
}

//export USART1_IRQHandler
func interruptUSART1() {
	callHandlers(IRQ_USART1)
}

//export USART2_IRQHandler
func interruptUSART2() {
	callHandlers(IRQ_USART2)
}

//export HSMCI_IRQHandler
func interruptHSMCI() {
	callHandlers(IRQ_HSMCI)
}

//export TWI0_IRQHandler
func interruptTWI0() {
	callHandlers(IRQ_TWI0)
}

//export TWI1_IRQHandler
func interruptTWI1() {
	callHandlers(IRQ_TWI1)
}

//export SPI_IRQHandler
func interruptSPI() {
	callHandlers(IRQ_SPI)
}

//export SSC_IRQHandler
func interruptSSC() {
	callHandlers(IRQ_SSC)
}

//export TC0_IRQHandler
func interruptTC0() {
	callHandlers(IRQ_TC0)
}

//export TC1_IRQHandler
func interruptTC1() {
	callHandlers(IRQ_TC1)
}

//export TC2_IRQHandler
func interruptTC2() {
	callHandlers(IRQ_TC2)
}

//export PWM_IRQHandler
func interruptPWM() {
	callHandlers(IRQ_PWM)
}

//export ADC12B_IRQHandler
func interruptADC12B() {
	callHandlers(IRQ_ADC12B)
}

//export ADC_IRQHandler
func interruptADC() {
	callHandlers(IRQ_ADC)
}

//export DMAC_IRQHandler
func interruptDMAC() {
	callHandlers(IRQ_DMAC)
}

//export UDPHS_IRQHandler
func interruptUDPHS() {
	callHandlers(IRQ_UDPHS)
}

// Peripherals.
var (
	// High Speed MultiMedia Card Interface
	HSMCI = (*HSMCI_Type)(unsafe.Pointer(uintptr(0x40000000)))

	// Synchronous Serial Controller
	SSC = (*SSC_Type)(unsafe.Pointer(uintptr(0x40004000)))

	// Serial Peripheral Interface
	SPI = (*SPI_Type)(unsafe.Pointer(uintptr(0x40008000)))

	// Timer Counter 0
	TC0 = (*TC_Type)(unsafe.Pointer(uintptr(0x40080000)))

	// Two-wire Interface 0
	TWI0 = (*TWI_Type)(unsafe.Pointer(uintptr(0x40084000)))

	// Two-wire Interface 1
	TWI1 = (*TWI_Type)(unsafe.Pointer(uintptr(0x40088000)))

	// Pulse Width Modulation Controller
	PWM = (*PWM_Type)(unsafe.Pointer(uintptr(0x4008c000)))

	// Universal Synchronous Asynchronous Receiver Transmitter 0
	USART0 = (*USART_Type)(unsafe.Pointer(uintptr(0x40090000)))

	// Universal Synchronous Asynchronous Receiver Transmitter 1
	USART1 = (*USART_Type)(unsafe.Pointer(uintptr(0x40094000)))

	// Universal Synchronous Asynchronous Receiver Transmitter 2
	USART2 = (*USART_Type)(unsafe.Pointer(uintptr(0x40098000)))

	// USB High Speed Device Port
	UDPHS = (*UDPHS_Type)(unsafe.Pointer(uintptr(0x400a4000)))

	// Analog-to-Digital Converter 12bits
	ADC12B = (*ADC12B_Type)(unsafe.Pointer(uintptr(0x400a8000)))

	// Analog-to-Digital Converter
	ADC = (*ADC_Type)(unsafe.Pointer(uintptr(0x400ac000)))

	// DMA Controller
	DMAC = (*DMAC_Type)(unsafe.Pointer(uintptr(0x400b0000)))

	// Static Memory Controller
	SMC = (*EBI_Type)(unsafe.Pointer(uintptr(0x400e0000)))

	// AHB Bus Matrix
	MATRIX = (*MATRIX_Type)(unsafe.Pointer(uintptr(0x400e0200)))

	// Power Management Controller
	PMC = (*PMC_Type)(unsafe.Pointer(uintptr(0x400e0400)))

	// Universal Asynchronous Receiver Transmitter
	UART = (*UART_Type)(unsafe.Pointer(uintptr(0x400e0600)))

	// Chip Identifier
	CHIPID = (*CHIPID_Type)(unsafe.Pointer(uintptr(0x400e0740)))

	// Embedded Flash Controller 0
	EFC0 = (*EFC_Type)(unsafe.Pointer(uintptr(0x400e0800)))

	// Parallel Input/Output Controller A
	PIOA = (*PIO_Type)(unsafe.Pointer(uintptr(0x400e0c00)))

	// Parallel Input/Output Controller B
	PIOB = (*PIO_Type)(unsafe.Pointer(uintptr(0x400e0e00)))

	// Reset Controller
	RSTC = (*SYSC_Type)(unsafe.Pointer(uintptr(0x400e1200)))

	// Supply Controller
	SUPC = (*SYSC_Type)(unsafe.Pointer(uintptr(0x400e1210)))

	// Real-time Timer
	RTT = (*SYSC_Type)(unsafe.Pointer(uintptr(0x400e1230)))

	// Watchdog Timer
	WDT = (*SYSC_Type)(unsafe.Pointer(uintptr(0x400e1250)))

	// Real-time Clock
	RTC = (*SYSC_Type)(unsafe.Pointer(uintptr(0x400e1260)))

	// General Purpose Backup Registers
	GPBR = (*SYSC_Type)(unsafe.Pointer(uintptr(0x400e1290)))
)

// High Speed MultiMedia Card Interface
type HSMCI_Type struct {
	CR    volatile.Register32    // 0x0
	MR    volatile.Register32    // 0x4
	DTOR  volatile.Register32    // 0x8
	SDCR  volatile.Register32    // 0xC
	ARGR  volatile.Register32    // 0x10
	CMDR  volatile.Register32    // 0x14
	BLKR  volatile.Register32    // 0x18
	CSTOR volatile.Register32    // 0x1C
	RSPR  [4]volatile.Register32 // 0x20
	RDR   volatile.Register32    // 0x30
	TDR   volatile.Register32    // 0x34
	_     [8]byte
	SR    volatile.Register32 // 0x40
	IER   volatile.Register32 // 0x44
	IDR   volatile.Register32 // 0x48
	IMR   volatile.Register32 // 0x4C
	DMA   volatile.Register32 // 0x50
	CFG   volatile.Register32 // 0x54
	_     [140]byte
	WPMR  volatile.Register32 // 0xE4
	WPSR  volatile.Register32 // 0xE8
	_     [276]byte
	FIFO  [256]volatile.Register32 // 0x200
}

// Synchronous Serial Controller
type SSC_Type struct {
	CR   volatile.Register32 // 0x0
	CMR  volatile.Register32 // 0x4
	_    [8]byte
	RCMR volatile.Register32 // 0x10
	RFMR volatile.Register32 // 0x14
	TCMR volatile.Register32 // 0x18
	TFMR volatile.Register32 // 0x1C
	RHR  volatile.Register32 // 0x20
	THR  volatile.Register32 // 0x24
	_    [8]byte
	RSHR volatile.Register32 // 0x30
	TSHR volatile.Register32 // 0x34
	RC0R volatile.Register32 // 0x38
	RC1R volatile.Register32 // 0x3C
	SR   volatile.Register32 // 0x40
	IER  volatile.Register32 // 0x44
	IDR  volatile.Register32 // 0x48
	IMR  volatile.Register32 // 0x4C
	_    [148]byte
	WPMR volatile.Register32 // 0xE4
	WPSR volatile.Register32 // 0xE8
}

// Serial Peripheral Interface
type SPI_Type struct {
	CR   volatile.Register32 // 0x0
	MR   volatile.Register32 // 0x4
	RDR  volatile.Register32 // 0x8
	TDR  volatile.Register32 // 0xC
	SR   volatile.Register32 // 0x10
	IER  volatile.Register32 // 0x14
	IDR  volatile.Register32 // 0x18
	IMR  volatile.Register32 // 0x1C
	_    [16]byte
	CSR  [4]volatile.Register32 // 0x30
	_    [164]byte
	WPMR volatile.Register32 // 0xE4
	WPSR volatile.Register32 // 0xE8
}

// Timer Counter 0
type TC_Type struct {
	CCR0 volatile.Register32 // 0x0
	CMR0 volatile.Register32 // 0x4
	_    [8]byte
	CV0  volatile.Register32 // 0x10
	RA0  volatile.Register32 // 0x14
	RB0  volatile.Register32 // 0x18
	RC0  volatile.Register32 // 0x1C
	SR0  volatile.Register32 // 0x20
	IER0 volatile.Register32 // 0x24
	IDR0 volatile.Register32 // 0x28
	IMR0 volatile.Register32 // 0x2C
	_    [16]byte
	CCR1 volatile.Register32 // 0x40
	CMR1 volatile.Register32 // 0x44
	_    [8]byte
	CV1  volatile.Register32 // 0x50
	RA1  volatile.Register32 // 0x54
	RB1  volatile.Register32 // 0x58
	RC1  volatile.Register32 // 0x5C
	SR1  volatile.Register32 // 0x60
	IER1 volatile.Register32 // 0x64
	IDR1 volatile.Register32 // 0x68
	IMR1 volatile.Register32 // 0x6C
	_    [16]byte
	CCR2 volatile.Register32 // 0x80
	CMR2 volatile.Register32 // 0x84
	_    [8]byte
	CV2  volatile.Register32 // 0x90
	RA2  volatile.Register32 // 0x94
	RB2  volatile.Register32 // 0x98
	RC2  volatile.Register32 // 0x9C
	SR2  volatile.Register32 // 0xA0
	IER2 volatile.Register32 // 0xA4
	IDR2 volatile.Register32 // 0xA8
	IMR2 volatile.Register32 // 0xAC
	_    [16]byte
	BCR  volatile.Register32 // 0xC0
	BMR  volatile.Register32 // 0xC4
	QIER volatile.Register32 // 0xC8
	QIDR volatile.Register32 // 0xCC
	QIMR volatile.Register32 // 0xD0
	QISR volatile.Register32 // 0xD4
}

// Two-wire Interface 0
type TWI_Type struct {
	CR   volatile.Register32 // 0x0
	MMR  volatile.Register32 // 0x4
	SMR  volatile.Register32 // 0x8
	IADR volatile.Register32 // 0xC
	CWGR volatile.Register32 // 0x10
	_    [12]byte
	SR   volatile.Register32 // 0x20
	IER  volatile.Register32 // 0x24
	IDR  volatile.Register32 // 0x28
	IMR  volatile.Register32 // 0x2C
	RHR  volatile.Register32 // 0x30
	THR  volatile.Register32 // 0x34
	_    [200]byte
	RPR  volatile.Register32 // 0x100
	RCR  volatile.Register32 // 0x104
	TPR  volatile.Register32 // 0x108
	TCR  volatile.Register32 // 0x10C
	RNPR volatile.Register32 // 0x110
	RNCR volatile.Register32 // 0x114
	TNPR volatile.Register32 // 0x118
	TNCR volatile.Register32 // 0x11C
	PTCR volatile.Register32 // 0x120
	PTSR volatile.Register32 // 0x124
}

// Pulse Width Modulation Controller
type PWM_Type struct {
	CLK      volatile.Register32 // 0x0
	ENA      volatile.Register32 // 0x4
	DIS      volatile.Register32 // 0x8
	SR       volatile.Register32 // 0xC
	IER1     volatile.Register32 // 0x10
	IDR1     volatile.Register32 // 0x14
	IMR1     volatile.Register32 // 0x18
	ISR1     volatile.Register32 // 0x1C
	SCM      volatile.Register32 // 0x20
	_        [4]byte
	SCUC     volatile.Register32 // 0x28
	SCUP     volatile.Register32 // 0x2C
	SCUPUPD  volatile.Register32 // 0x30
	IER2     volatile.Register32 // 0x34
	IDR2     volatile.Register32 // 0x38
	IMR2     volatile.Register32 // 0x3C
	ISR2     volatile.Register32 // 0x40
	OOV      volatile.Register32 // 0x44
	OS       volatile.Register32 // 0x48
	OSS      volatile.Register32 // 0x4C
	OSC      volatile.Register32 // 0x50
	OSSUPD   volatile.Register32 // 0x54
	OSCUPD   volatile.Register32 // 0x58
	FMR      volatile.Register32 // 0x5C
	FSR      volatile.Register32 // 0x60
	FCR      volatile.Register32 // 0x64
	FPV      volatile.Register32 // 0x68
	FPE      volatile.Register32 // 0x6C
	_        [12]byte
	ELMR     [2]volatile.Register32 // 0x7C
	_        [44]byte
	SMMR     volatile.Register32 // 0xB0
	_        [48]byte
	WPCR     volatile.Register32 // 0xE4
	WPSR     volatile.Register32 // 0xE8
	_        [28]byte
	TPR      volatile.Register32 // 0x108
	TCR      volatile.Register32 // 0x10C
	_        [8]byte
	TNPR     volatile.Register32 // 0x118
	TNCR     volatile.Register32 // 0x11C
	PTCR     volatile.Register32 // 0x120
	PTSR     volatile.Register32 // 0x124
	_        [8]byte
	CMPV0    volatile.Register32 // 0x130
	CMPVUPD0 volatile.Register32 // 0x134
	CMPM0    volatile.Register32 // 0x138
	CMPMUPD0 volatile.Register32 // 0x13C
	CMPV1    volatile.Register32 // 0x140
	CMPVUPD1 volatile.Register32 // 0x144
	CMPM1    volatile.Register32 // 0x148
	CMPMUPD1 volatile.Register32 // 0x14C
	CMPV2    volatile.Register32 // 0x150
	CMPVUPD2 volatile.Register32 // 0x154
	CMPM2    volatile.Register32 // 0x158
	CMPMUPD2 volatile.Register32 // 0x15C
	CMPV3    volatile.Register32 // 0x160
	CMPVUPD3 volatile.Register32 // 0x164
	CMPM3    volatile.Register32 // 0x168
	CMPMUPD3 volatile.Register32 // 0x16C
	CMPV4    volatile.Register32 // 0x170
	CMPVUPD4 volatile.Register32 // 0x174
	CMPM4    volatile.Register32 // 0x178
	CMPMUPD4 volatile.Register32 // 0x17C
	CMPV5    volatile.Register32 // 0x180
	CMPVUPD5 volatile.Register32 // 0x184
	CMPM5    volatile.Register32 // 0x188
	CMPMUPD5 volatile.Register32 // 0x18C
	CMPV6    volatile.Register32 // 0x190
	CMPVUPD6 volatile.Register32 // 0x194
	CMPM6    volatile.Register32 // 0x198
	CMPMUPD6 volatile.Register32 // 0x19C
	CMPV7    volatile.Register32 // 0x1A0
	CMPVUPD7 volatile.Register32 // 0x1A4
	CMPM7    volatile.Register32 // 0x1A8
	CMPMUPD7 volatile.Register32 // 0x1AC
	_        [80]byte
	CMR0     volatile.Register32 // 0x200
	CDTY0    volatile.Register32 // 0x204
	CDTYUPD0 volatile.Register32 // 0x208
	CPRD0    volatile.Register32 // 0x20C
	CPRDUPD0 volatile.Register32 // 0x210
	CCNT0    volatile.Register32 // 0x214
	DT0      volatile.Register32 // 0x218
	DTUPD0   volatile.Register32 // 0x21C
	CMR1     volatile.Register32 // 0x220
	CDTY1    volatile.Register32 // 0x224
	CDTYUPD1 volatile.Register32 // 0x228
	CPRD1    volatile.Register32 // 0x22C
	CPRDUPD1 volatile.Register32 // 0x230
	CCNT1    volatile.Register32 // 0x234
	DT1      volatile.Register32 // 0x238
	DTUPD1   volatile.Register32 // 0x23C
	CMR2     volatile.Register32 // 0x240
	CDTY2    volatile.Register32 // 0x244
	CDTYUPD2 volatile.Register32 // 0x248
	CPRD2    volatile.Register32 // 0x24C
	CPRDUPD2 volatile.Register32 // 0x250
	CCNT2    volatile.Register32 // 0x254
	DT2      volatile.Register32 // 0x258
	DTUPD2   volatile.Register32 // 0x25C
	CMR3     volatile.Register32 // 0x260
	CDTY3    volatile.Register32 // 0x264
	CDTYUPD3 volatile.Register32 // 0x268
	CPRD3    volatile.Register32 // 0x26C
	CPRDUPD3 volatile.Register32 // 0x270
	CCNT3    volatile.Register32 // 0x274
	DT3      volatile.Register32 // 0x278
	DTUPD3   volatile.Register32 // 0x27C
}

// Universal Synchronous Asynchronous Receiver Transmitter 0
type USART_Type struct {
	CR   volatile.Register32 // 0x0
	MR   volatile.Register32 // 0x4
	IER  volatile.Register32 // 0x8
	IDR  volatile.Register32 // 0xC
	IMR  volatile.Register32 // 0x10
	CSR  volatile.Register32 // 0x14
	RHR  volatile.Register32 // 0x18
	THR  volatile.Register32 // 0x1C
	BRGR volatile.Register32 // 0x20
	RTOR volatile.Register32 // 0x24
	TTGR volatile.Register32 // 0x28
	_    [20]byte
	FIDI volatile.Register32 // 0x40
	NER  volatile.Register32 // 0x44
	_    [4]byte
	IF   volatile.Register32 // 0x4C
	MAN  volatile.Register32 // 0x50
	_    [144]byte
	WPMR volatile.Register32 // 0xE4
	WPSR volatile.Register32 // 0xE8
	_    [20]byte
	RPR  volatile.Register32 // 0x100
	RCR  volatile.Register32 // 0x104
	TPR  volatile.Register32 // 0x108
	TCR  volatile.Register32 // 0x10C
	RNPR volatile.Register32 // 0x110
	RNCR volatile.Register32 // 0x114
	TNPR volatile.Register32 // 0x118
	TNCR volatile.Register32 // 0x11C
	PTCR volatile.Register32 // 0x120
	PTSR volatile.Register32 // 0x124
}

// USB High Speed Device Port
type UDPHS_Type struct {
	CTRL        volatile.Register32 // 0x0
	FNUM        volatile.Register32 // 0x4
	_           [8]byte
	IEN         volatile.Register32 // 0x10
	INTSTA      volatile.Register32 // 0x14
	CLRINT      volatile.Register32 // 0x18
	EPTRST      volatile.Register32 // 0x1C
	_           [192]byte
	TST         volatile.Register32 // 0xE0
	_           [28]byte
	EPTCFG0     volatile.Register32 // 0x100
	EPTCTLENB0  volatile.Register32 // 0x104
	EPTCTLDIS0  volatile.Register32 // 0x108
	EPTCTL0     volatile.Register32 // 0x10C
	_           [4]byte
	EPTSETSTA0  volatile.Register32 // 0x114
	EPTCLRSTA0  volatile.Register32 // 0x118
	EPTSTA0     volatile.Register32 // 0x11C
	EPTCFG1     volatile.Register32 // 0x120
	EPTCTLENB1  volatile.Register32 // 0x124
	EPTCTLDIS1  volatile.Register32 // 0x128
	EPTCTL1     volatile.Register32 // 0x12C
	_           [4]byte
	EPTSETSTA1  volatile.Register32 // 0x134
	EPTCLRSTA1  volatile.Register32 // 0x138
	EPTSTA1     volatile.Register32 // 0x13C
	EPTCFG2     volatile.Register32 // 0x140
	EPTCTLENB2  volatile.Register32 // 0x144
	EPTCTLDIS2  volatile.Register32 // 0x148
	EPTCTL2     volatile.Register32 // 0x14C
	_           [4]byte
	EPTSETSTA2  volatile.Register32 // 0x154
	EPTCLRSTA2  volatile.Register32 // 0x158
	EPTSTA2     volatile.Register32 // 0x15C
	EPTCFG3     volatile.Register32 // 0x160
	EPTCTLENB3  volatile.Register32 // 0x164
	EPTCTLDIS3  volatile.Register32 // 0x168
	EPTCTL3     volatile.Register32 // 0x16C
	_           [4]byte
	EPTSETSTA3  volatile.Register32 // 0x174
	EPTCLRSTA3  volatile.Register32 // 0x178
	EPTSTA3     volatile.Register32 // 0x17C
	EPTCFG4     volatile.Register32 // 0x180
	EPTCTLENB4  volatile.Register32 // 0x184
	EPTCTLDIS4  volatile.Register32 // 0x188
	EPTCTL4     volatile.Register32 // 0x18C
	_           [4]byte
	EPTSETSTA4  volatile.Register32 // 0x194
	EPTCLRSTA4  volatile.Register32 // 0x198
	EPTSTA4     volatile.Register32 // 0x19C
	EPTCFG5     volatile.Register32 // 0x1A0
	EPTCTLENB5  volatile.Register32 // 0x1A4
	EPTCTLDIS5  volatile.Register32 // 0x1A8
	EPTCTL5     volatile.Register32 // 0x1AC
	_           [4]byte
	EPTSETSTA5  volatile.Register32 // 0x1B4
	EPTCLRSTA5  volatile.Register32 // 0x1B8
	EPTSTA5     volatile.Register32 // 0x1BC
	EPTCFG6     volatile.Register32 // 0x1C0
	EPTCTLENB6  volatile.Register32 // 0x1C4
	EPTCTLDIS6  volatile.Register32 // 0x1C8
	EPTCTL6     volatile.Register32 // 0x1CC
	_           [4]byte
	EPTSETSTA6  volatile.Register32 // 0x1D4
	EPTCLRSTA6  volatile.Register32 // 0x1D8
	EPTSTA6     volatile.Register32 // 0x1DC
	_           [288]byte
	DMANXTDSC0  volatile.Register32 // 0x300
	DMAADDRESS0 volatile.Register32 // 0x304
	DMACONTROL0 volatile.Register32 // 0x308
	DMASTATUS0  volatile.Register32 // 0x30C
	DMANXTDSC1  volatile.Register32 // 0x310
	DMAADDRESS1 volatile.Register32 // 0x314
	DMACONTROL1 volatile.Register32 // 0x318
	DMASTATUS1  volatile.Register32 // 0x31C
	DMANXTDSC2  volatile.Register32 // 0x320
	DMAADDRESS2 volatile.Register32 // 0x324
	DMACONTROL2 volatile.Register32 // 0x328
	DMASTATUS2  volatile.Register32 // 0x32C
	DMANXTDSC3  volatile.Register32 // 0x330
	DMAADDRESS3 volatile.Register32 // 0x334
	DMACONTROL3 volatile.Register32 // 0x338
	DMASTATUS3  volatile.Register32 // 0x33C
	DMANXTDSC4  volatile.Register32 // 0x340
	DMAADDRESS4 volatile.Register32 // 0x344
	DMACONTROL4 volatile.Register32 // 0x348
	DMASTATUS4  volatile.Register32 // 0x34C
	DMANXTDSC5  volatile.Register32 // 0x350
	DMAADDRESS5 volatile.Register32 // 0x354
	DMACONTROL5 volatile.Register32 // 0x358
	DMASTATUS5  volatile.Register32 // 0x35C
}

// Analog-to-Digital Converter 12bits
type ADC12B_Type struct {
	CR   volatile.Register32 // 0x0
	MR   volatile.Register32 // 0x4
	_    [8]byte
	CHER volatile.Register32    // 0x10
	CHDR volatile.Register32    // 0x14
	CHSR volatile.Register32    // 0x18
	SR   volatile.Register32    // 0x1C
	LCDR volatile.Register32    // 0x20
	IER  volatile.Register32    // 0x24
	IDR  volatile.Register32    // 0x28
	IMR  volatile.Register32    // 0x2C
	CDR  [8]volatile.Register32 // 0x30
	_    [20]byte
	ACR  volatile.Register32 // 0x64
	EMR  volatile.Register32 // 0x68
	_    [148]byte
	RPR  volatile.Register32 // 0x100
	RCR  volatile.Register32 // 0x104
	_    [8]byte
	RNPR volatile.Register32 // 0x110
	RNCR volatile.Register32 // 0x114
	_    [8]byte
	PTCR volatile.Register32 // 0x120
	PTSR volatile.Register32 // 0x124
}

// Analog-to-Digital Converter
type ADC_Type struct {
	CR   volatile.Register32 // 0x0
	MR   volatile.Register32 // 0x4
	_    [8]byte
	CHER volatile.Register32    // 0x10
	CHDR volatile.Register32    // 0x14
	CHSR volatile.Register32    // 0x18
	SR   volatile.Register32    // 0x1C
	LCDR volatile.Register32    // 0x20
	IER  volatile.Register32    // 0x24
	IDR  volatile.Register32    // 0x28
	IMR  volatile.Register32    // 0x2C
	CDR  [8]volatile.Register32 // 0x30
	_    [176]byte
	RPR  volatile.Register32 // 0x100
	RCR  volatile.Register32 // 0x104
	_    [8]byte
	RNPR volatile.Register32 // 0x110
	RNCR volatile.Register32 // 0x114
	_    [8]byte
	PTCR volatile.Register32 // 0x120
	PTSR volatile.Register32 // 0x124
}

// DMA Controller
type DMAC_Type struct {
	GCFG   volatile.Register32 // 0x0
	EN     volatile.Register32 // 0x4
	SREQ   volatile.Register32 // 0x8
	CREQ   volatile.Register32 // 0xC
	LAST   volatile.Register32 // 0x10
	_      [4]byte
	EBCIER volatile.Register32 // 0x18
	EBCIDR volatile.Register32 // 0x1C
	EBCIMR volatile.Register32 // 0x20
	EBCISR volatile.Register32 // 0x24
	CHER   volatile.Register32 // 0x28
	CHDR   volatile.Register32 // 0x2C
	CHSR   volatile.Register32 // 0x30
	_      [8]byte
	SADDR0 volatile.Register32 // 0x3C
	DADDR0 volatile.Register32 // 0x40
	DSCR0  volatile.Register32 // 0x44
	CTRLA0 volatile.Register32 // 0x48
	CTRLB0 volatile.Register32 // 0x4C
	CFG0   volatile.Register32 // 0x50
	_      [16]byte
	SADDR1 volatile.Register32 // 0x64
	DADDR1 volatile.Register32 // 0x68
	DSCR1  volatile.Register32 // 0x6C
	CTRLA1 volatile.Register32 // 0x70
	CTRLB1 volatile.Register32 // 0x74
	CFG1   volatile.Register32 // 0x78
	_      [16]byte
	SADDR2 volatile.Register32 // 0x8C
	DADDR2 volatile.Register32 // 0x90
	DSCR2  volatile.Register32 // 0x94
	CTRLA2 volatile.Register32 // 0x98
	CTRLB2 volatile.Register32 // 0x9C
	CFG2   volatile.Register32 // 0xA0
	_      [16]byte
	SADDR3 volatile.Register32 // 0xB4
	DADDR3 volatile.Register32 // 0xB8
	DSCR3  volatile.Register32 // 0xBC
	CTRLA3 volatile.Register32 // 0xC0
	CTRLB3 volatile.Register32 // 0xC4
	CFG3   volatile.Register32 // 0xC8
	_      [280]byte
	WPMR   volatile.Register32 // 0x1E4
	WPSR   volatile.Register32 // 0x1E8
}

// Static Memory Controller
type EBI_Type struct {
	CFG      volatile.Register32 // 0x0
	CTRL     volatile.Register32 // 0x4
	SR       volatile.Register32 // 0x8
	IER      volatile.Register32 // 0xC
	IDR      volatile.Register32 // 0x10
	IMR      volatile.Register32 // 0x14
	ADDR     volatile.Register32 // 0x18
	BANK     volatile.Register32 // 0x1C
	ECC_CTRL volatile.Register32 // 0x20
	ECC_MD   volatile.Register32 // 0x24
	ECC_SR1  volatile.Register32 // 0x28
	ECC_PR0  volatile.Register32 // 0x2C
	ECC_PR1  volatile.Register32 // 0x30
	ECC_SR2  volatile.Register32 // 0x34
	ECC_PR2  volatile.Register32 // 0x38
	ECC_PR3  volatile.Register32 // 0x3C
	ECC_PR4  volatile.Register32 // 0x40
	ECC_PR5  volatile.Register32 // 0x44
	ECC_PR6  volatile.Register32 // 0x48
	ECC_PR7  volatile.Register32 // 0x4C
	ECC_PR8  volatile.Register32 // 0x50
	ECC_PR9  volatile.Register32 // 0x54
	ECC_PR10 volatile.Register32 // 0x58
	ECC_PR11 volatile.Register32 // 0x5C
	ECC_PR12 volatile.Register32 // 0x60
	ECC_PR13 volatile.Register32 // 0x64
	ECC_PR14 volatile.Register32 // 0x68
	ECC_PR15 volatile.Register32 // 0x6C
	SETUP0   volatile.Register32 // 0x70
	PULSE0   volatile.Register32 // 0x74
	CYCLE0   volatile.Register32 // 0x78
	TIMINGS0 volatile.Register32 // 0x7C
	MODE0    volatile.Register32 // 0x80
	SETUP1   volatile.Register32 // 0x84
	PULSE1   volatile.Register32 // 0x88
	CYCLE1   volatile.Register32 // 0x8C
	TIMINGS1 volatile.Register32 // 0x90
	MODE1    volatile.Register32 // 0x94
	SETUP2   volatile.Register32 // 0x98
	PULSE2   volatile.Register32 // 0x9C
	CYCLE2   volatile.Register32 // 0xA0
	TIMINGS2 volatile.Register32 // 0xA4
	MODE2    volatile.Register32 // 0xA8
	SETUP3   volatile.Register32 // 0xAC
	PULSE3   volatile.Register32 // 0xB0
	CYCLE3   volatile.Register32 // 0xB4
	TIMINGS3 volatile.Register32 // 0xB8
	MODE3    volatile.Register32 // 0xBC
	_        [80]byte
	OCMS     volatile.Register32 // 0x110
	KEY1     volatile.Register32 // 0x114
	KEY2     volatile.Register32 // 0x118
	_        [200]byte
	WPCR     volatile.Register32 // 0x1E4
	WPSR     volatile.Register32 // 0x1E8
}

// AHB Bus Matrix
type MATRIX_Type struct {
	MCFG  [5]volatile.Register32 // 0x0
	_     [44]byte
	SCFG  [10]volatile.Register32 // 0x40
	_     [24]byte
	PRAS0 volatile.Register32 // 0x80
	_     [4]byte
	PRAS1 volatile.Register32 // 0x88
	_     [4]byte
	PRAS2 volatile.Register32 // 0x90
	_     [4]byte
	PRAS3 volatile.Register32 // 0x98
	_     [4]byte
	PRAS4 volatile.Register32 // 0xA0
	_     [4]byte
	PRAS5 volatile.Register32 // 0xA8
	_     [4]byte
	PRAS6 volatile.Register32 // 0xB0
	_     [4]byte
	PRAS7 volatile.Register32 // 0xB8
	_     [4]byte
	PRAS8 volatile.Register32 // 0xC0
	_     [4]byte
	PRAS9 volatile.Register32 // 0xC8
	_     [52]byte
	MRCR  volatile.Register32 // 0x100
	_     [224]byte
	WPMR  volatile.Register32 // 0x1E4
	WPSR  volatile.Register32 // 0x1E8
}

// Power Management Controller
type PMC_Type struct {
	PMC_SCER   volatile.Register32 // 0x0
	PMC_SCDR   volatile.Register32 // 0x4
	PMC_SCSR   volatile.Register32 // 0x8
	_          [4]byte
	PMC_PCER0  volatile.Register32 // 0x10
	PMC_PCDR0  volatile.Register32 // 0x14
	PMC_PCSR0  volatile.Register32 // 0x18
	CKGR_UCKR  volatile.Register32 // 0x1C
	CKGR_MOR   volatile.Register32 // 0x20
	CKGR_MCFR  volatile.Register32 // 0x24
	CKGR_PLLAR volatile.Register32 // 0x28
	_          [4]byte
	PMC_MCKR   volatile.Register32 // 0x30
	_          [12]byte
	PMC_PCK    [3]volatile.Register32 // 0x40
	_          [20]byte
	PMC_IER    volatile.Register32 // 0x60
	PMC_IDR    volatile.Register32 // 0x64
	PMC_SR     volatile.Register32 // 0x68
	PMC_IMR    volatile.Register32 // 0x6C
	PMC_FSMR   volatile.Register32 // 0x70
	PMC_FSPR   volatile.Register32 // 0x74
	PMC_FOCR   volatile.Register32 // 0x78
	_          [104]byte
	PMC_WPMR   volatile.Register32 // 0xE4
	PMC_WPSR   volatile.Register32 // 0xE8
}

// Universal Asynchronous Receiver Transmitter
type UART_Type struct {
	CR   volatile.Register32 // 0x0
	MR   volatile.Register32 // 0x4
	IER  volatile.Register32 // 0x8
	IDR  volatile.Register32 // 0xC
	IMR  volatile.Register32 // 0x10
	SR   volatile.Register32 // 0x14
	RHR  volatile.Register32 // 0x18
	THR  volatile.Register32 // 0x1C
	BRGR volatile.Register32 // 0x20
	_    [220]byte
	RPR  volatile.Register32 // 0x100
	RCR  volatile.Register32 // 0x104
	TPR  volatile.Register32 // 0x108
	TCR  volatile.Register32 // 0x10C
	RNPR volatile.Register32 // 0x110
	RNCR volatile.Register32 // 0x114
	TNPR volatile.Register32 // 0x118
	TNCR volatile.Register32 // 0x11C
	PTCR volatile.Register32 // 0x120
	PTSR volatile.Register32 // 0x124
}

// Chip Identifier
type CHIPID_Type struct {
	CIDR volatile.Register32 // 0x0
	EXID volatile.Register32 // 0x4
}

// Embedded Flash Controller 0
type EFC_Type struct {
	FMR volatile.Register32 // 0x0
	FCR volatile.Register32 // 0x4
	FSR volatile.Register32 // 0x8
	FRR volatile.Register32 // 0xC
}

// Parallel Input/Output Controller A
type PIO_Type struct {
	PER    volatile.Register32 // 0x0
	PDR    volatile.Register32 // 0x4
	PSR    volatile.Register32 // 0x8
	_      [4]byte
	OER    volatile.Register32 // 0x10
	ODR    volatile.Register32 // 0x14
	OSR    volatile.Register32 // 0x18
	_      [4]byte
	IFER   volatile.Register32 // 0x20
	IFDR   volatile.Register32 // 0x24
	IFSR   volatile.Register32 // 0x28
	_      [4]byte
	SODR   volatile.Register32 // 0x30
	CODR   volatile.Register32 // 0x34
	ODSR   volatile.Register32 // 0x38
	PDSR   volatile.Register32 // 0x3C
	IER    volatile.Register32 // 0x40
	IDR    volatile.Register32 // 0x44
	IMR    volatile.Register32 // 0x48
	ISR    volatile.Register32 // 0x4C
	MDER   volatile.Register32 // 0x50
	MDDR   volatile.Register32 // 0x54
	MDSR   volatile.Register32 // 0x58
	_      [4]byte
	PUDR   volatile.Register32 // 0x60
	PUER   volatile.Register32 // 0x64
	PUSR   volatile.Register32 // 0x68
	_      [4]byte
	ABSR   volatile.Register32 // 0x70
	_      [12]byte
	SCIFSR volatile.Register32 // 0x80
	DIFSR  volatile.Register32 // 0x84
	IFDGSR volatile.Register32 // 0x88
	SCDR   volatile.Register32 // 0x8C
	_      [16]byte
	OWER   volatile.Register32 // 0xA0
	OWDR   volatile.Register32 // 0xA4
	OWSR   volatile.Register32 // 0xA8
	_      [4]byte
	AIMER  volatile.Register32 // 0xB0
	AIMDR  volatile.Register32 // 0xB4
	AIMMR  volatile.Register32 // 0xB8
	_      [4]byte
	ESR    volatile.Register32 // 0xC0
	LSR    volatile.Register32 // 0xC4
	ELSR   volatile.Register32 // 0xC8
	_      [4]byte
	FELLSR volatile.Register32 // 0xD0
	REHLSR volatile.Register32 // 0xD4
	FRLHSR volatile.Register32 // 0xD8
	_      [4]byte
	LOCKSR volatile.Register32 // 0xE0
	WPMR   volatile.Register32 // 0xE4
	WPSR   volatile.Register32 // 0xE8
}

// Reset Controller
type SYSC_Type struct {
	CR volatile.Register32 // 0x0
	SR volatile.Register32 // 0x4
	MR volatile.Register32 // 0x8
}

// Bitfields for HSMCI: High Speed MultiMedia Card Interface
const (
	// CR: Control Register
	// Position of MCIEN field.
	HSMCI_CR_MCIEN_Pos = 0x0
	// Bit mask of MCIEN field.
	HSMCI_CR_MCIEN_Msk = 0x1
	// Bit MCIEN.
	HSMCI_CR_MCIEN = 0x1
	// Position of MCIDIS field.
	HSMCI_CR_MCIDIS_Pos = 0x1
	// Bit mask of MCIDIS field.
	HSMCI_CR_MCIDIS_Msk = 0x2
	// Bit MCIDIS.
	HSMCI_CR_MCIDIS = 0x2
	// Position of PWSEN field.
	HSMCI_CR_PWSEN_Pos = 0x2
	// Bit mask of PWSEN field.
	HSMCI_CR_PWSEN_Msk = 0x4
	// Bit PWSEN.
	HSMCI_CR_PWSEN = 0x4
	// Position of PWSDIS field.
	HSMCI_CR_PWSDIS_Pos = 0x3
	// Bit mask of PWSDIS field.
	HSMCI_CR_PWSDIS_Msk = 0x8
	// Bit PWSDIS.
	HSMCI_CR_PWSDIS = 0x8
	// Position of SWRST field.
	HSMCI_CR_SWRST_Pos = 0x7
	// Bit mask of SWRST field.
	HSMCI_CR_SWRST_Msk = 0x80
	// Bit SWRST.
	HSMCI_CR_SWRST = 0x80

	// MR: Mode Register
	// Position of CLKDIV field.
	HSMCI_MR_CLKDIV_Pos = 0x0
	// Bit mask of CLKDIV field.
	HSMCI_MR_CLKDIV_Msk = 0xff
	// Position of PWSDIV field.
	HSMCI_MR_PWSDIV_Pos = 0x8
	// Bit mask of PWSDIV field.
	HSMCI_MR_PWSDIV_Msk = 0x700
	// Position of RDPROOF field.
	HSMCI_MR_RDPROOF_Pos = 0xb
	// Bit mask of RDPROOF field.
	HSMCI_MR_RDPROOF_Msk = 0x800
	// Bit RDPROOF.
	HSMCI_MR_RDPROOF = 0x800
	// Position of WRPROOF field.
	HSMCI_MR_WRPROOF_Pos = 0xc
	// Bit mask of WRPROOF field.
	HSMCI_MR_WRPROOF_Msk = 0x1000
	// Bit WRPROOF.
	HSMCI_MR_WRPROOF = 0x1000
	// Position of FBYTE field.
	HSMCI_MR_FBYTE_Pos = 0xd
	// Bit mask of FBYTE field.
	HSMCI_MR_FBYTE_Msk = 0x2000
	// Bit FBYTE.
	HSMCI_MR_FBYTE = 0x2000
	// Position of PADV field.
	HSMCI_MR_PADV_Pos = 0xe
	// Bit mask of PADV field.
	HSMCI_MR_PADV_Msk = 0x4000
	// Bit PADV.
	HSMCI_MR_PADV = 0x4000

	// DTOR: Data Timeout Register
	// Position of DTOCYC field.
	HSMCI_DTOR_DTOCYC_Pos = 0x0
	// Bit mask of DTOCYC field.
	HSMCI_DTOR_DTOCYC_Msk = 0xf
	// Position of DTOMUL field.
	HSMCI_DTOR_DTOMUL_Pos = 0x4
	// Bit mask of DTOMUL field.
	HSMCI_DTOR_DTOMUL_Msk = 0x70
	// DTOCYC
	HSMCI_DTOR_DTOMUL_1 = 0x0
	// DTOCYC x 16
	HSMCI_DTOR_DTOMUL_16 = 0x1
	// DTOCYC x 128
	HSMCI_DTOR_DTOMUL_128 = 0x2
	// DTOCYC x 256
	HSMCI_DTOR_DTOMUL_256 = 0x3
	// DTOCYC x 1024
	HSMCI_DTOR_DTOMUL_1024 = 0x4
	// DTOCYC x 4096
	HSMCI_DTOR_DTOMUL_4096 = 0x5
	// DTOCYC x 65536
	HSMCI_DTOR_DTOMUL_65536 = 0x6
	// DTOCYC x 1048576
	HSMCI_DTOR_DTOMUL_1048576 = 0x7

	// SDCR: SD/SDIO Card Register
	// Position of SDCSEL field.
	HSMCI_SDCR_SDCSEL_Pos = 0x0
	// Bit mask of SDCSEL field.
	HSMCI_SDCR_SDCSEL_Msk = 0x3
	// Slot A is selected.
	HSMCI_SDCR_SDCSEL_SLOTA = 0x0
	// -
	HSMCI_SDCR_SDCSEL_SLOTB = 0x1
	// -
	HSMCI_SDCR_SDCSEL_SLOTC = 0x2
	// -
	HSMCI_SDCR_SDCSEL_SLOTD = 0x3
	// Position of SDCBUS field.
	HSMCI_SDCR_SDCBUS_Pos = 0x6
	// Bit mask of SDCBUS field.
	HSMCI_SDCR_SDCBUS_Msk = 0xc0
	// 1 bit
	HSMCI_SDCR_SDCBUS_1 = 0x0
	// 4 bit
	HSMCI_SDCR_SDCBUS_4 = 0x2
	// 8 bit
	HSMCI_SDCR_SDCBUS_8 = 0x3

	// ARGR: Argument Register
	// Position of ARG field.
	HSMCI_ARGR_ARG_Pos = 0x0
	// Bit mask of ARG field.
	HSMCI_ARGR_ARG_Msk = 0xffffffff

	// CMDR: Command Register
	// Position of CMDNB field.
	HSMCI_CMDR_CMDNB_Pos = 0x0
	// Bit mask of CMDNB field.
	HSMCI_CMDR_CMDNB_Msk = 0x3f
	// Position of RSPTYP field.
	HSMCI_CMDR_RSPTYP_Pos = 0x6
	// Bit mask of RSPTYP field.
	HSMCI_CMDR_RSPTYP_Msk = 0xc0
	// No response.
	HSMCI_CMDR_RSPTYP_NORESP = 0x0
	// 48-bit response.
	HSMCI_CMDR_RSPTYP_48_BIT = 0x1
	// 136-bit response.
	HSMCI_CMDR_RSPTYP_136_BIT = 0x2
	// R1b response type
	HSMCI_CMDR_RSPTYP_R1B = 0x3
	// Position of SPCMD field.
	HSMCI_CMDR_SPCMD_Pos = 0x8
	// Bit mask of SPCMD field.
	HSMCI_CMDR_SPCMD_Msk = 0x700
	// Not a special CMD.
	HSMCI_CMDR_SPCMD_STD = 0x0
	// Initialization CMD: 74 clock cycles for initialization sequence.
	HSMCI_CMDR_SPCMD_INIT = 0x1
	// Synchronized CMD: Wait for the end of the current data block transfer before sending the pending command.
	HSMCI_CMDR_SPCMD_SYNC = 0x2
	// CE-ATA Completion Signal disable Command. The host cancels the ability for the device to return a command completion signal on the command line.
	HSMCI_CMDR_SPCMD_CE_ATA = 0x3
	// Interrupt command: Corresponds to the Interrupt Mode (CMD40).
	HSMCI_CMDR_SPCMD_IT_CMD = 0x4
	// Interrupt response: Corresponds to the Interrupt Mode (CMD40).
	HSMCI_CMDR_SPCMD_IT_RESP = 0x5
	// Boot Operation Request. Start a boot operation mode, the host processor can read boot data from the MMC device directly.
	HSMCI_CMDR_SPCMD_BOR = 0x6
	// End Boot Operation. This command allows the host processor to terminate the boot operation mode.
	HSMCI_CMDR_SPCMD_EBO = 0x7
	// Position of OPDCMD field.
	HSMCI_CMDR_OPDCMD_Pos = 0xb
	// Bit mask of OPDCMD field.
	HSMCI_CMDR_OPDCMD_Msk = 0x800
	// Bit OPDCMD.
	HSMCI_CMDR_OPDCMD = 0x800
	// Push pull command.
	HSMCI_CMDR_OPDCMD_PUSHPULL = 0x0
	// Open drain command.
	HSMCI_CMDR_OPDCMD_OPENDRAIN = 0x1
	// Position of MAXLAT field.
	HSMCI_CMDR_MAXLAT_Pos = 0xc
	// Bit mask of MAXLAT field.
	HSMCI_CMDR_MAXLAT_Msk = 0x1000
	// Bit MAXLAT.
	HSMCI_CMDR_MAXLAT = 0x1000
	// 5-cycle max latency.
	HSMCI_CMDR_MAXLAT_5 = 0x0
	// 64-cycle max latency.
	HSMCI_CMDR_MAXLAT_64 = 0x1
	// Position of TRCMD field.
	HSMCI_CMDR_TRCMD_Pos = 0x10
	// Bit mask of TRCMD field.
	HSMCI_CMDR_TRCMD_Msk = 0x30000
	// No data transfer
	HSMCI_CMDR_TRCMD_NO_DATA = 0x0
	// Start data transfer
	HSMCI_CMDR_TRCMD_START_DATA = 0x1
	// Stop data transfer
	HSMCI_CMDR_TRCMD_STOP_DATA = 0x2
	// Position of TRDIR field.
	HSMCI_CMDR_TRDIR_Pos = 0x12
	// Bit mask of TRDIR field.
	HSMCI_CMDR_TRDIR_Msk = 0x40000
	// Bit TRDIR.
	HSMCI_CMDR_TRDIR = 0x40000
	// Write.
	HSMCI_CMDR_TRDIR_WRITE = 0x0
	// Read.
	HSMCI_CMDR_TRDIR_READ = 0x1
	// Position of TRTYP field.
	HSMCI_CMDR_TRTYP_Pos = 0x13
	// Bit mask of TRTYP field.
	HSMCI_CMDR_TRTYP_Msk = 0x380000
	// MMC/SD Card Single Block
	HSMCI_CMDR_TRTYP_SINGLE = 0x0
	// MMC/SD Card Multiple Block
	HSMCI_CMDR_TRTYP_MULTIPLE = 0x1
	// MMC Stream
	HSMCI_CMDR_TRTYP_STREAM = 0x2
	// SDIO Byte
	HSMCI_CMDR_TRTYP_BYTE = 0x4
	// SDIO Block
	HSMCI_CMDR_TRTYP_BLOCK = 0x5
	// Position of IOSPCMD field.
	HSMCI_CMDR_IOSPCMD_Pos = 0x18
	// Bit mask of IOSPCMD field.
	HSMCI_CMDR_IOSPCMD_Msk = 0x3000000
	// Not an SDIO Special Command
	HSMCI_CMDR_IOSPCMD_STD = 0x0
	// SDIO Suspend Command
	HSMCI_CMDR_IOSPCMD_SUSPEND = 0x1
	// SDIO Resume Command
	HSMCI_CMDR_IOSPCMD_RESUME = 0x2
	// Position of ATACS field.
	HSMCI_CMDR_ATACS_Pos = 0x1a
	// Bit mask of ATACS field.
	HSMCI_CMDR_ATACS_Msk = 0x4000000
	// Bit ATACS.
	HSMCI_CMDR_ATACS = 0x4000000
	// Normal operation mode.
	HSMCI_CMDR_ATACS_NORMAL = 0x0
	// This bit indicates that a completion signal is expected within a programmed amount of time (HSMCI_CSTOR).
	HSMCI_CMDR_ATACS_COMPLETION = 0x1
	// Position of BOOT_ACK field.
	HSMCI_CMDR_BOOT_ACK_Pos = 0x1b
	// Bit mask of BOOT_ACK field.
	HSMCI_CMDR_BOOT_ACK_Msk = 0x8000000
	// Bit BOOT_ACK.
	HSMCI_CMDR_BOOT_ACK = 0x8000000

	// BLKR: Block Register
	// Position of BCNT field.
	HSMCI_BLKR_BCNT_Pos = 0x0
	// Bit mask of BCNT field.
	HSMCI_BLKR_BCNT_Msk = 0xffff
	// Position of BLKLEN field.
	HSMCI_BLKR_BLKLEN_Pos = 0x10
	// Bit mask of BLKLEN field.
	HSMCI_BLKR_BLKLEN_Msk = 0xffff0000

	// CSTOR: Completion Signal Timeout Register
	// Position of CSTOCYC field.
	HSMCI_CSTOR_CSTOCYC_Pos = 0x0
	// Bit mask of CSTOCYC field.
	HSMCI_CSTOR_CSTOCYC_Msk = 0xf
	// Position of CSTOMUL field.
	HSMCI_CSTOR_CSTOMUL_Pos = 0x4
	// Bit mask of CSTOMUL field.
	HSMCI_CSTOR_CSTOMUL_Msk = 0x70
	// CSTOCYC x 1
	HSMCI_CSTOR_CSTOMUL_1 = 0x0
	// CSTOCYC x 16
	HSMCI_CSTOR_CSTOMUL_16 = 0x1
	// CSTOCYC x 128
	HSMCI_CSTOR_CSTOMUL_128 = 0x2
	// CSTOCYC x 256
	HSMCI_CSTOR_CSTOMUL_256 = 0x3
	// CSTOCYC x 1024
	HSMCI_CSTOR_CSTOMUL_1024 = 0x4
	// CSTOCYC x 4096
	HSMCI_CSTOR_CSTOMUL_4096 = 0x5
	// CSTOCYC x 65536
	HSMCI_CSTOR_CSTOMUL_65536 = 0x6
	// CSTOCYC x 1048576
	HSMCI_CSTOR_CSTOMUL_1048576 = 0x7

	// RSPR: Response Register
	// Position of RSP field.
	HSMCI_RSPR_RSP_Pos = 0x0
	// Bit mask of RSP field.
	HSMCI_RSPR_RSP_Msk = 0xffffffff

	// RDR: Receive Data Register
	// Position of DATA field.
	HSMCI_RDR_DATA_Pos = 0x0
	// Bit mask of DATA field.
	HSMCI_RDR_DATA_Msk = 0xffffffff

	// TDR: Transmit Data Register
	// Position of DATA field.
	HSMCI_TDR_DATA_Pos = 0x0
	// Bit mask of DATA field.
	HSMCI_TDR_DATA_Msk = 0xffffffff

	// SR: Status Register
	// Position of CMDRDY field.
	HSMCI_SR_CMDRDY_Pos = 0x0
	// Bit mask of CMDRDY field.
	HSMCI_SR_CMDRDY_Msk = 0x1
	// Bit CMDRDY.
	HSMCI_SR_CMDRDY = 0x1
	// Position of RXRDY field.
	HSMCI_SR_RXRDY_Pos = 0x1
	// Bit mask of RXRDY field.
	HSMCI_SR_RXRDY_Msk = 0x2
	// Bit RXRDY.
	HSMCI_SR_RXRDY = 0x2
	// Position of TXRDY field.
	HSMCI_SR_TXRDY_Pos = 0x2
	// Bit mask of TXRDY field.
	HSMCI_SR_TXRDY_Msk = 0x4
	// Bit TXRDY.
	HSMCI_SR_TXRDY = 0x4
	// Position of BLKE field.
	HSMCI_SR_BLKE_Pos = 0x3
	// Bit mask of BLKE field.
	HSMCI_SR_BLKE_Msk = 0x8
	// Bit BLKE.
	HSMCI_SR_BLKE = 0x8
	// Position of DTIP field.
	HSMCI_SR_DTIP_Pos = 0x4
	// Bit mask of DTIP field.
	HSMCI_SR_DTIP_Msk = 0x10
	// Bit DTIP.
	HSMCI_SR_DTIP = 0x10
	// Position of NOTBUSY field.
	HSMCI_SR_NOTBUSY_Pos = 0x5
	// Bit mask of NOTBUSY field.
	HSMCI_SR_NOTBUSY_Msk = 0x20
	// Bit NOTBUSY.
	HSMCI_SR_NOTBUSY = 0x20
	// Position of MCI_SDIOIRQA field.
	HSMCI_SR_MCI_SDIOIRQA_Pos = 0x8
	// Bit mask of MCI_SDIOIRQA field.
	HSMCI_SR_MCI_SDIOIRQA_Msk = 0x100
	// Bit MCI_SDIOIRQA.
	HSMCI_SR_MCI_SDIOIRQA = 0x100
	// Position of SDIOWAIT field.
	HSMCI_SR_SDIOWAIT_Pos = 0xc
	// Bit mask of SDIOWAIT field.
	HSMCI_SR_SDIOWAIT_Msk = 0x1000
	// Bit SDIOWAIT.
	HSMCI_SR_SDIOWAIT = 0x1000
	// Position of CSRCV field.
	HSMCI_SR_CSRCV_Pos = 0xd
	// Bit mask of CSRCV field.
	HSMCI_SR_CSRCV_Msk = 0x2000
	// Bit CSRCV.
	HSMCI_SR_CSRCV = 0x2000
	// Position of RINDE field.
	HSMCI_SR_RINDE_Pos = 0x10
	// Bit mask of RINDE field.
	HSMCI_SR_RINDE_Msk = 0x10000
	// Bit RINDE.
	HSMCI_SR_RINDE = 0x10000
	// Position of RDIRE field.
	HSMCI_SR_RDIRE_Pos = 0x11
	// Bit mask of RDIRE field.
	HSMCI_SR_RDIRE_Msk = 0x20000
	// Bit RDIRE.
	HSMCI_SR_RDIRE = 0x20000
	// Position of RCRCE field.
	HSMCI_SR_RCRCE_Pos = 0x12
	// Bit mask of RCRCE field.
	HSMCI_SR_RCRCE_Msk = 0x40000
	// Bit RCRCE.
	HSMCI_SR_RCRCE = 0x40000
	// Position of RENDE field.
	HSMCI_SR_RENDE_Pos = 0x13
	// Bit mask of RENDE field.
	HSMCI_SR_RENDE_Msk = 0x80000
	// Bit RENDE.
	HSMCI_SR_RENDE = 0x80000
	// Position of RTOE field.
	HSMCI_SR_RTOE_Pos = 0x14
	// Bit mask of RTOE field.
	HSMCI_SR_RTOE_Msk = 0x100000
	// Bit RTOE.
	HSMCI_SR_RTOE = 0x100000
	// Position of DCRCE field.
	HSMCI_SR_DCRCE_Pos = 0x15
	// Bit mask of DCRCE field.
	HSMCI_SR_DCRCE_Msk = 0x200000
	// Bit DCRCE.
	HSMCI_SR_DCRCE = 0x200000
	// Position of DTOE field.
	HSMCI_SR_DTOE_Pos = 0x16
	// Bit mask of DTOE field.
	HSMCI_SR_DTOE_Msk = 0x400000
	// Bit DTOE.
	HSMCI_SR_DTOE = 0x400000
	// Position of CSTOE field.
	HSMCI_SR_CSTOE_Pos = 0x17
	// Bit mask of CSTOE field.
	HSMCI_SR_CSTOE_Msk = 0x800000
	// Bit CSTOE.
	HSMCI_SR_CSTOE = 0x800000
	// Position of BLKOVRE field.
	HSMCI_SR_BLKOVRE_Pos = 0x18
	// Bit mask of BLKOVRE field.
	HSMCI_SR_BLKOVRE_Msk = 0x1000000
	// Bit BLKOVRE.
	HSMCI_SR_BLKOVRE = 0x1000000
	// Position of DMADONE field.
	HSMCI_SR_DMADONE_Pos = 0x19
	// Bit mask of DMADONE field.
	HSMCI_SR_DMADONE_Msk = 0x2000000
	// Bit DMADONE.
	HSMCI_SR_DMADONE = 0x2000000
	// Position of FIFOEMPTY field.
	HSMCI_SR_FIFOEMPTY_Pos = 0x1a
	// Bit mask of FIFOEMPTY field.
	HSMCI_SR_FIFOEMPTY_Msk = 0x4000000
	// Bit FIFOEMPTY.
	HSMCI_SR_FIFOEMPTY = 0x4000000
	// Position of XFRDONE field.
	HSMCI_SR_XFRDONE_Pos = 0x1b
	// Bit mask of XFRDONE field.
	HSMCI_SR_XFRDONE_Msk = 0x8000000
	// Bit XFRDONE.
	HSMCI_SR_XFRDONE = 0x8000000
	// Position of ACKRCV field.
	HSMCI_SR_ACKRCV_Pos = 0x1c
	// Bit mask of ACKRCV field.
	HSMCI_SR_ACKRCV_Msk = 0x10000000
	// Bit ACKRCV.
	HSMCI_SR_ACKRCV = 0x10000000
	// Position of ACKRCVE field.
	HSMCI_SR_ACKRCVE_Pos = 0x1d
	// Bit mask of ACKRCVE field.
	HSMCI_SR_ACKRCVE_Msk = 0x20000000
	// Bit ACKRCVE.
	HSMCI_SR_ACKRCVE = 0x20000000
	// Position of OVRE field.
	HSMCI_SR_OVRE_Pos = 0x1e
	// Bit mask of OVRE field.
	HSMCI_SR_OVRE_Msk = 0x40000000
	// Bit OVRE.
	HSMCI_SR_OVRE = 0x40000000
	// Position of UNRE field.
	HSMCI_SR_UNRE_Pos = 0x1f
	// Bit mask of UNRE field.
	HSMCI_SR_UNRE_Msk = 0x80000000
	// Bit UNRE.
	HSMCI_SR_UNRE = 0x80000000

	// IER: Interrupt Enable Register
	// Position of CMDRDY field.
	HSMCI_IER_CMDRDY_Pos = 0x0
	// Bit mask of CMDRDY field.
	HSMCI_IER_CMDRDY_Msk = 0x1
	// Bit CMDRDY.
	HSMCI_IER_CMDRDY = 0x1
	// Position of RXRDY field.
	HSMCI_IER_RXRDY_Pos = 0x1
	// Bit mask of RXRDY field.
	HSMCI_IER_RXRDY_Msk = 0x2
	// Bit RXRDY.
	HSMCI_IER_RXRDY = 0x2
	// Position of TXRDY field.
	HSMCI_IER_TXRDY_Pos = 0x2
	// Bit mask of TXRDY field.
	HSMCI_IER_TXRDY_Msk = 0x4
	// Bit TXRDY.
	HSMCI_IER_TXRDY = 0x4
	// Position of BLKE field.
	HSMCI_IER_BLKE_Pos = 0x3
	// Bit mask of BLKE field.
	HSMCI_IER_BLKE_Msk = 0x8
	// Bit BLKE.
	HSMCI_IER_BLKE = 0x8
	// Position of DTIP field.
	HSMCI_IER_DTIP_Pos = 0x4
	// Bit mask of DTIP field.
	HSMCI_IER_DTIP_Msk = 0x10
	// Bit DTIP.
	HSMCI_IER_DTIP = 0x10
	// Position of NOTBUSY field.
	HSMCI_IER_NOTBUSY_Pos = 0x5
	// Bit mask of NOTBUSY field.
	HSMCI_IER_NOTBUSY_Msk = 0x20
	// Bit NOTBUSY.
	HSMCI_IER_NOTBUSY = 0x20
	// Position of MCI_SDIOIRQA field.
	HSMCI_IER_MCI_SDIOIRQA_Pos = 0x8
	// Bit mask of MCI_SDIOIRQA field.
	HSMCI_IER_MCI_SDIOIRQA_Msk = 0x100
	// Bit MCI_SDIOIRQA.
	HSMCI_IER_MCI_SDIOIRQA = 0x100
	// Position of SDIOWAIT field.
	HSMCI_IER_SDIOWAIT_Pos = 0xc
	// Bit mask of SDIOWAIT field.
	HSMCI_IER_SDIOWAIT_Msk = 0x1000
	// Bit SDIOWAIT.
	HSMCI_IER_SDIOWAIT = 0x1000
	// Position of CSRCV field.
	HSMCI_IER_CSRCV_Pos = 0xd
	// Bit mask of CSRCV field.
	HSMCI_IER_CSRCV_Msk = 0x2000
	// Bit CSRCV.
	HSMCI_IER_CSRCV = 0x2000
	// Position of RINDE field.
	HSMCI_IER_RINDE_Pos = 0x10
	// Bit mask of RINDE field.
	HSMCI_IER_RINDE_Msk = 0x10000
	// Bit RINDE.
	HSMCI_IER_RINDE = 0x10000
	// Position of RDIRE field.
	HSMCI_IER_RDIRE_Pos = 0x11
	// Bit mask of RDIRE field.
	HSMCI_IER_RDIRE_Msk = 0x20000
	// Bit RDIRE.
	HSMCI_IER_RDIRE = 0x20000
	// Position of RCRCE field.
	HSMCI_IER_RCRCE_Pos = 0x12
	// Bit mask of RCRCE field.
	HSMCI_IER_RCRCE_Msk = 0x40000
	// Bit RCRCE.
	HSMCI_IER_RCRCE = 0x40000
	// Position of RENDE field.
	HSMCI_IER_RENDE_Pos = 0x13
	// Bit mask of RENDE field.
	HSMCI_IER_RENDE_Msk = 0x80000
	// Bit RENDE.
	HSMCI_IER_RENDE = 0x80000
	// Position of RTOE field.
	HSMCI_IER_RTOE_Pos = 0x14
	// Bit mask of RTOE field.
	HSMCI_IER_RTOE_Msk = 0x100000
	// Bit RTOE.
	HSMCI_IER_RTOE = 0x100000
	// Position of DCRCE field.
	HSMCI_IER_DCRCE_Pos = 0x15
	// Bit mask of DCRCE field.
	HSMCI_IER_DCRCE_Msk = 0x200000
	// Bit DCRCE.
	HSMCI_IER_DCRCE = 0x200000
	// Position of DTOE field.
	HSMCI_IER_DTOE_Pos = 0x16
	// Bit mask of DTOE field.
	HSMCI_IER_DTOE_Msk = 0x400000
	// Bit DTOE.
	HSMCI_IER_DTOE = 0x400000
	// Position of CSTOE field.
	HSMCI_IER_CSTOE_Pos = 0x17
	// Bit mask of CSTOE field.
	HSMCI_IER_CSTOE_Msk = 0x800000
	// Bit CSTOE.
	HSMCI_IER_CSTOE = 0x800000
	// Position of BLKOVRE field.
	HSMCI_IER_BLKOVRE_Pos = 0x18
	// Bit mask of BLKOVRE field.
	HSMCI_IER_BLKOVRE_Msk = 0x1000000
	// Bit BLKOVRE.
	HSMCI_IER_BLKOVRE = 0x1000000
	// Position of DMADONE field.
	HSMCI_IER_DMADONE_Pos = 0x19
	// Bit mask of DMADONE field.
	HSMCI_IER_DMADONE_Msk = 0x2000000
	// Bit DMADONE.
	HSMCI_IER_DMADONE = 0x2000000
	// Position of FIFOEMPTY field.
	HSMCI_IER_FIFOEMPTY_Pos = 0x1a
	// Bit mask of FIFOEMPTY field.
	HSMCI_IER_FIFOEMPTY_Msk = 0x4000000
	// Bit FIFOEMPTY.
	HSMCI_IER_FIFOEMPTY = 0x4000000
	// Position of XFRDONE field.
	HSMCI_IER_XFRDONE_Pos = 0x1b
	// Bit mask of XFRDONE field.
	HSMCI_IER_XFRDONE_Msk = 0x8000000
	// Bit XFRDONE.
	HSMCI_IER_XFRDONE = 0x8000000
	// Position of ACKRCV field.
	HSMCI_IER_ACKRCV_Pos = 0x1c
	// Bit mask of ACKRCV field.
	HSMCI_IER_ACKRCV_Msk = 0x10000000
	// Bit ACKRCV.
	HSMCI_IER_ACKRCV = 0x10000000
	// Position of ACKRCVE field.
	HSMCI_IER_ACKRCVE_Pos = 0x1d
	// Bit mask of ACKRCVE field.
	HSMCI_IER_ACKRCVE_Msk = 0x20000000
	// Bit ACKRCVE.
	HSMCI_IER_ACKRCVE = 0x20000000
	// Position of OVRE field.
	HSMCI_IER_OVRE_Pos = 0x1e
	// Bit mask of OVRE field.
	HSMCI_IER_OVRE_Msk = 0x40000000
	// Bit OVRE.
	HSMCI_IER_OVRE = 0x40000000
	// Position of UNRE field.
	HSMCI_IER_UNRE_Pos = 0x1f
	// Bit mask of UNRE field.
	HSMCI_IER_UNRE_Msk = 0x80000000
	// Bit UNRE.
	HSMCI_IER_UNRE = 0x80000000

	// IDR: Interrupt Disable Register
	// Position of CMDRDY field.
	HSMCI_IDR_CMDRDY_Pos = 0x0
	// Bit mask of CMDRDY field.
	HSMCI_IDR_CMDRDY_Msk = 0x1
	// Bit CMDRDY.
	HSMCI_IDR_CMDRDY = 0x1
	// Position of RXRDY field.
	HSMCI_IDR_RXRDY_Pos = 0x1
	// Bit mask of RXRDY field.
	HSMCI_IDR_RXRDY_Msk = 0x2
	// Bit RXRDY.
	HSMCI_IDR_RXRDY = 0x2
	// Position of TXRDY field.
	HSMCI_IDR_TXRDY_Pos = 0x2
	// Bit mask of TXRDY field.
	HSMCI_IDR_TXRDY_Msk = 0x4
	// Bit TXRDY.
	HSMCI_IDR_TXRDY = 0x4
	// Position of BLKE field.
	HSMCI_IDR_BLKE_Pos = 0x3
	// Bit mask of BLKE field.
	HSMCI_IDR_BLKE_Msk = 0x8
	// Bit BLKE.
	HSMCI_IDR_BLKE = 0x8
	// Position of DTIP field.
	HSMCI_IDR_DTIP_Pos = 0x4
	// Bit mask of DTIP field.
	HSMCI_IDR_DTIP_Msk = 0x10
	// Bit DTIP.
	HSMCI_IDR_DTIP = 0x10
	// Position of NOTBUSY field.
	HSMCI_IDR_NOTBUSY_Pos = 0x5
	// Bit mask of NOTBUSY field.
	HSMCI_IDR_NOTBUSY_Msk = 0x20
	// Bit NOTBUSY.
	HSMCI_IDR_NOTBUSY = 0x20
	// Position of MCI_SDIOIRQA field.
	HSMCI_IDR_MCI_SDIOIRQA_Pos = 0x8
	// Bit mask of MCI_SDIOIRQA field.
	HSMCI_IDR_MCI_SDIOIRQA_Msk = 0x100
	// Bit MCI_SDIOIRQA.
	HSMCI_IDR_MCI_SDIOIRQA = 0x100
	// Position of SDIOWAIT field.
	HSMCI_IDR_SDIOWAIT_Pos = 0xc
	// Bit mask of SDIOWAIT field.
	HSMCI_IDR_SDIOWAIT_Msk = 0x1000
	// Bit SDIOWAIT.
	HSMCI_IDR_SDIOWAIT = 0x1000
	// Position of CSRCV field.
	HSMCI_IDR_CSRCV_Pos = 0xd
	// Bit mask of CSRCV field.
	HSMCI_IDR_CSRCV_Msk = 0x2000
	// Bit CSRCV.
	HSMCI_IDR_CSRCV = 0x2000
	// Position of RINDE field.
	HSMCI_IDR_RINDE_Pos = 0x10
	// Bit mask of RINDE field.
	HSMCI_IDR_RINDE_Msk = 0x10000
	// Bit RINDE.
	HSMCI_IDR_RINDE = 0x10000
	// Position of RDIRE field.
	HSMCI_IDR_RDIRE_Pos = 0x11
	// Bit mask of RDIRE field.
	HSMCI_IDR_RDIRE_Msk = 0x20000
	// Bit RDIRE.
	HSMCI_IDR_RDIRE = 0x20000
	// Position of RCRCE field.
	HSMCI_IDR_RCRCE_Pos = 0x12
	// Bit mask of RCRCE field.
	HSMCI_IDR_RCRCE_Msk = 0x40000
	// Bit RCRCE.
	HSMCI_IDR_RCRCE = 0x40000
	// Position of RENDE field.
	HSMCI_IDR_RENDE_Pos = 0x13
	// Bit mask of RENDE field.
	HSMCI_IDR_RENDE_Msk = 0x80000
	// Bit RENDE.
	HSMCI_IDR_RENDE = 0x80000
	// Position of RTOE field.
	HSMCI_IDR_RTOE_Pos = 0x14
	// Bit mask of RTOE field.
	HSMCI_IDR_RTOE_Msk = 0x100000
	// Bit RTOE.
	HSMCI_IDR_RTOE = 0x100000
	// Position of DCRCE field.
	HSMCI_IDR_DCRCE_Pos = 0x15
	// Bit mask of DCRCE field.
	HSMCI_IDR_DCRCE_Msk = 0x200000
	// Bit DCRCE.
	HSMCI_IDR_DCRCE = 0x200000
	// Position of DTOE field.
	HSMCI_IDR_DTOE_Pos = 0x16
	// Bit mask of DTOE field.
	HSMCI_IDR_DTOE_Msk = 0x400000
	// Bit DTOE.
	HSMCI_IDR_DTOE = 0x400000
	// Position of CSTOE field.
	HSMCI_IDR_CSTOE_Pos = 0x17
	// Bit mask of CSTOE field.
	HSMCI_IDR_CSTOE_Msk = 0x800000
	// Bit CSTOE.
	HSMCI_IDR_CSTOE = 0x800000
	// Position of BLKOVRE field.
	HSMCI_IDR_BLKOVRE_Pos = 0x18
	// Bit mask of BLKOVRE field.
	HSMCI_IDR_BLKOVRE_Msk = 0x1000000
	// Bit BLKOVRE.
	HSMCI_IDR_BLKOVRE = 0x1000000
	// Position of DMADONE field.
	HSMCI_IDR_DMADONE_Pos = 0x19
	// Bit mask of DMADONE field.
	HSMCI_IDR_DMADONE_Msk = 0x2000000
	// Bit DMADONE.
	HSMCI_IDR_DMADONE = 0x2000000
	// Position of FIFOEMPTY field.
	HSMCI_IDR_FIFOEMPTY_Pos = 0x1a
	// Bit mask of FIFOEMPTY field.
	HSMCI_IDR_FIFOEMPTY_Msk = 0x4000000
	// Bit FIFOEMPTY.
	HSMCI_IDR_FIFOEMPTY = 0x4000000
	// Position of XFRDONE field.
	HSMCI_IDR_XFRDONE_Pos = 0x1b
	// Bit mask of XFRDONE field.
	HSMCI_IDR_XFRDONE_Msk = 0x8000000
	// Bit XFRDONE.
	HSMCI_IDR_XFRDONE = 0x8000000
	// Position of ACKRCV field.
	HSMCI_IDR_ACKRCV_Pos = 0x1c
	// Bit mask of ACKRCV field.
	HSMCI_IDR_ACKRCV_Msk = 0x10000000
	// Bit ACKRCV.
	HSMCI_IDR_ACKRCV = 0x10000000
	// Position of ACKRCVE field.
	HSMCI_IDR_ACKRCVE_Pos = 0x1d
	// Bit mask of ACKRCVE field.
	HSMCI_IDR_ACKRCVE_Msk = 0x20000000
	// Bit ACKRCVE.
	HSMCI_IDR_ACKRCVE = 0x20000000
	// Position of OVRE field.
	HSMCI_IDR_OVRE_Pos = 0x1e
	// Bit mask of OVRE field.
	HSMCI_IDR_OVRE_Msk = 0x40000000
	// Bit OVRE.
	HSMCI_IDR_OVRE = 0x40000000
	// Position of UNRE field.
	HSMCI_IDR_UNRE_Pos = 0x1f
	// Bit mask of UNRE field.
	HSMCI_IDR_UNRE_Msk = 0x80000000
	// Bit UNRE.
	HSMCI_IDR_UNRE = 0x80000000

	// IMR: Interrupt Mask Register
	// Position of CMDRDY field.
	HSMCI_IMR_CMDRDY_Pos = 0x0
	// Bit mask of CMDRDY field.
	HSMCI_IMR_CMDRDY_Msk = 0x1
	// Bit CMDRDY.
	HSMCI_IMR_CMDRDY = 0x1
	// Position of RXRDY field.
	HSMCI_IMR_RXRDY_Pos = 0x1
	// Bit mask of RXRDY field.
	HSMCI_IMR_RXRDY_Msk = 0x2
	// Bit RXRDY.
	HSMCI_IMR_RXRDY = 0x2
	// Position of TXRDY field.
	HSMCI_IMR_TXRDY_Pos = 0x2
	// Bit mask of TXRDY field.
	HSMCI_IMR_TXRDY_Msk = 0x4
	// Bit TXRDY.
	HSMCI_IMR_TXRDY = 0x4
	// Position of BLKE field.
	HSMCI_IMR_BLKE_Pos = 0x3
	// Bit mask of BLKE field.
	HSMCI_IMR_BLKE_Msk = 0x8
	// Bit BLKE.
	HSMCI_IMR_BLKE = 0x8
	// Position of DTIP field.
	HSMCI_IMR_DTIP_Pos = 0x4
	// Bit mask of DTIP field.
	HSMCI_IMR_DTIP_Msk = 0x10
	// Bit DTIP.
	HSMCI_IMR_DTIP = 0x10
	// Position of NOTBUSY field.
	HSMCI_IMR_NOTBUSY_Pos = 0x5
	// Bit mask of NOTBUSY field.
	HSMCI_IMR_NOTBUSY_Msk = 0x20
	// Bit NOTBUSY.
	HSMCI_IMR_NOTBUSY = 0x20
	// Position of MCI_SDIOIRQA field.
	HSMCI_IMR_MCI_SDIOIRQA_Pos = 0x8
	// Bit mask of MCI_SDIOIRQA field.
	HSMCI_IMR_MCI_SDIOIRQA_Msk = 0x100
	// Bit MCI_SDIOIRQA.
	HSMCI_IMR_MCI_SDIOIRQA = 0x100
	// Position of SDIOWAIT field.
	HSMCI_IMR_SDIOWAIT_Pos = 0xc
	// Bit mask of SDIOWAIT field.
	HSMCI_IMR_SDIOWAIT_Msk = 0x1000
	// Bit SDIOWAIT.
	HSMCI_IMR_SDIOWAIT = 0x1000
	// Position of CSRCV field.
	HSMCI_IMR_CSRCV_Pos = 0xd
	// Bit mask of CSRCV field.
	HSMCI_IMR_CSRCV_Msk = 0x2000
	// Bit CSRCV.
	HSMCI_IMR_CSRCV = 0x2000
	// Position of RINDE field.
	HSMCI_IMR_RINDE_Pos = 0x10
	// Bit mask of RINDE field.
	HSMCI_IMR_RINDE_Msk = 0x10000
	// Bit RINDE.
	HSMCI_IMR_RINDE = 0x10000
	// Position of RDIRE field.
	HSMCI_IMR_RDIRE_Pos = 0x11
	// Bit mask of RDIRE field.
	HSMCI_IMR_RDIRE_Msk = 0x20000
	// Bit RDIRE.
	HSMCI_IMR_RDIRE = 0x20000
	// Position of RCRCE field.
	HSMCI_IMR_RCRCE_Pos = 0x12
	// Bit mask of RCRCE field.
	HSMCI_IMR_RCRCE_Msk = 0x40000
	// Bit RCRCE.
	HSMCI_IMR_RCRCE = 0x40000
	// Position of RENDE field.
	HSMCI_IMR_RENDE_Pos = 0x13
	// Bit mask of RENDE field.
	HSMCI_IMR_RENDE_Msk = 0x80000
	// Bit RENDE.
	HSMCI_IMR_RENDE = 0x80000
	// Position of RTOE field.
	HSMCI_IMR_RTOE_Pos = 0x14
	// Bit mask of RTOE field.
	HSMCI_IMR_RTOE_Msk = 0x100000
	// Bit RTOE.
	HSMCI_IMR_RTOE = 0x100000
	// Position of DCRCE field.
	HSMCI_IMR_DCRCE_Pos = 0x15
	// Bit mask of DCRCE field.
	HSMCI_IMR_DCRCE_Msk = 0x200000
	// Bit DCRCE.
	HSMCI_IMR_DCRCE = 0x200000
	// Position of DTOE field.
	HSMCI_IMR_DTOE_Pos = 0x16
	// Bit mask of DTOE field.
	HSMCI_IMR_DTOE_Msk = 0x400000
	// Bit DTOE.
	HSMCI_IMR_DTOE = 0x400000
	// Position of CSTOE field.
	HSMCI_IMR_CSTOE_Pos = 0x17
	// Bit mask of CSTOE field.
	HSMCI_IMR_CSTOE_Msk = 0x800000
	// Bit CSTOE.
	HSMCI_IMR_CSTOE = 0x800000
	// Position of BLKOVRE field.
	HSMCI_IMR_BLKOVRE_Pos = 0x18
	// Bit mask of BLKOVRE field.
	HSMCI_IMR_BLKOVRE_Msk = 0x1000000
	// Bit BLKOVRE.
	HSMCI_IMR_BLKOVRE = 0x1000000
	// Position of DMADONE field.
	HSMCI_IMR_DMADONE_Pos = 0x19
	// Bit mask of DMADONE field.
	HSMCI_IMR_DMADONE_Msk = 0x2000000
	// Bit DMADONE.
	HSMCI_IMR_DMADONE = 0x2000000
	// Position of FIFOEMPTY field.
	HSMCI_IMR_FIFOEMPTY_Pos = 0x1a
	// Bit mask of FIFOEMPTY field.
	HSMCI_IMR_FIFOEMPTY_Msk = 0x4000000
	// Bit FIFOEMPTY.
	HSMCI_IMR_FIFOEMPTY = 0x4000000
	// Position of XFRDONE field.
	HSMCI_IMR_XFRDONE_Pos = 0x1b
	// Bit mask of XFRDONE field.
	HSMCI_IMR_XFRDONE_Msk = 0x8000000
	// Bit XFRDONE.
	HSMCI_IMR_XFRDONE = 0x8000000
	// Position of ACKRCV field.
	HSMCI_IMR_ACKRCV_Pos = 0x1c
	// Bit mask of ACKRCV field.
	HSMCI_IMR_ACKRCV_Msk = 0x10000000
	// Bit ACKRCV.
	HSMCI_IMR_ACKRCV = 0x10000000
	// Position of ACKRCVE field.
	HSMCI_IMR_ACKRCVE_Pos = 0x1d
	// Bit mask of ACKRCVE field.
	HSMCI_IMR_ACKRCVE_Msk = 0x20000000
	// Bit ACKRCVE.
	HSMCI_IMR_ACKRCVE = 0x20000000
	// Position of OVRE field.
	HSMCI_IMR_OVRE_Pos = 0x1e
	// Bit mask of OVRE field.
	HSMCI_IMR_OVRE_Msk = 0x40000000
	// Bit OVRE.
	HSMCI_IMR_OVRE = 0x40000000
	// Position of UNRE field.
	HSMCI_IMR_UNRE_Pos = 0x1f
	// Bit mask of UNRE field.
	HSMCI_IMR_UNRE_Msk = 0x80000000
	// Bit UNRE.
	HSMCI_IMR_UNRE = 0x80000000

	// DMA: DMA Configuration Register
	// Position of OFFSET field.
	HSMCI_DMA_OFFSET_Pos = 0x0
	// Bit mask of OFFSET field.
	HSMCI_DMA_OFFSET_Msk = 0x3
	// Position of CHKSIZE field.
	HSMCI_DMA_CHKSIZE_Pos = 0x4
	// Bit mask of CHKSIZE field.
	HSMCI_DMA_CHKSIZE_Msk = 0x70
	// Position of DMAEN field.
	HSMCI_DMA_DMAEN_Pos = 0x8
	// Bit mask of DMAEN field.
	HSMCI_DMA_DMAEN_Msk = 0x100
	// Bit DMAEN.
	HSMCI_DMA_DMAEN = 0x100
	// Position of ROPT field.
	HSMCI_DMA_ROPT_Pos = 0xc
	// Bit mask of ROPT field.
	HSMCI_DMA_ROPT_Msk = 0x1000
	// Bit ROPT.
	HSMCI_DMA_ROPT = 0x1000

	// CFG: Configuration Register
	// Position of FIFOMODE field.
	HSMCI_CFG_FIFOMODE_Pos = 0x0
	// Bit mask of FIFOMODE field.
	HSMCI_CFG_FIFOMODE_Msk = 0x1
	// Bit FIFOMODE.
	HSMCI_CFG_FIFOMODE = 0x1
	// Position of FERRCTRL field.
	HSMCI_CFG_FERRCTRL_Pos = 0x4
	// Bit mask of FERRCTRL field.
	HSMCI_CFG_FERRCTRL_Msk = 0x10
	// Bit FERRCTRL.
	HSMCI_CFG_FERRCTRL = 0x10
	// Position of HSMODE field.
	HSMCI_CFG_HSMODE_Pos = 0x8
	// Bit mask of HSMODE field.
	HSMCI_CFG_HSMODE_Msk = 0x100
	// Bit HSMODE.
	HSMCI_CFG_HSMODE = 0x100
	// Position of LSYNC field.
	HSMCI_CFG_LSYNC_Pos = 0xc
	// Bit mask of LSYNC field.
	HSMCI_CFG_LSYNC_Msk = 0x1000
	// Bit LSYNC.
	HSMCI_CFG_LSYNC = 0x1000

	// WPMR: Write Protection Mode Register
	// Position of WPEN field.
	HSMCI_WPMR_WPEN_Pos = 0x0
	// Bit mask of WPEN field.
	HSMCI_WPMR_WPEN_Msk = 0x1
	// Bit WPEN.
	HSMCI_WPMR_WPEN = 0x1
	// Position of WPKEY field.
	HSMCI_WPMR_WPKEY_Pos = 0x8
	// Bit mask of WPKEY field.
	HSMCI_WPMR_WPKEY_Msk = 0xffffff00
	// Writing any other value in this field aborts the write operation of the WPEN bit.Always reads as 0.
	HSMCI_WPMR_WPKEY_PASSWD = 0x4d4349

	// WPSR: Write Protection Status Register
	// Position of WPVS field.
	HSMCI_WPSR_WPVS_Pos = 0x0
	// Bit mask of WPVS field.
	HSMCI_WPSR_WPVS_Msk = 0xf
	// No Write Protection Violation occurred since the last read of this register (HSMCI_WPSR)
	HSMCI_WPSR_WPVS_NONE = 0x0
	// Write Protection detected unauthorized attempt to write a control register had occurred (since the last read.)
	HSMCI_WPSR_WPVS_WRITE = 0x1
	// Software reset had been performed while Write Protection was enabled (since the last read).
	HSMCI_WPSR_WPVS_RESET = 0x2
	// Both Write Protection violation and software reset with Write Protection enabled have occurred since the last read.
	HSMCI_WPSR_WPVS_BOTH = 0x3
	// Position of WPVSRC field.
	HSMCI_WPSR_WPVSRC_Pos = 0x8
	// Bit mask of WPVSRC field.
	HSMCI_WPSR_WPVSRC_Msk = 0xffff00

	// FIFO: FIFO Memory Aperture0
	// Position of DATA field.
	HSMCI_FIFO_DATA_Pos = 0x0
	// Bit mask of DATA field.
	HSMCI_FIFO_DATA_Msk = 0xffffffff
)

// Bitfields for SSC: Synchronous Serial Controller
const (
	// CR: Control Register
	// Position of RXEN field.
	SSC_CR_RXEN_Pos = 0x0
	// Bit mask of RXEN field.
	SSC_CR_RXEN_Msk = 0x1
	// Bit RXEN.
	SSC_CR_RXEN = 0x1
	// Position of RXDIS field.
	SSC_CR_RXDIS_Pos = 0x1
	// Bit mask of RXDIS field.
	SSC_CR_RXDIS_Msk = 0x2
	// Bit RXDIS.
	SSC_CR_RXDIS = 0x2
	// Position of TXEN field.
	SSC_CR_TXEN_Pos = 0x8
	// Bit mask of TXEN field.
	SSC_CR_TXEN_Msk = 0x100
	// Bit TXEN.
	SSC_CR_TXEN = 0x100
	// Position of TXDIS field.
	SSC_CR_TXDIS_Pos = 0x9
	// Bit mask of TXDIS field.
	SSC_CR_TXDIS_Msk = 0x200
	// Bit TXDIS.
	SSC_CR_TXDIS = 0x200
	// Position of SWRST field.
	SSC_CR_SWRST_Pos = 0xf
	// Bit mask of SWRST field.
	SSC_CR_SWRST_Msk = 0x8000
	// Bit SWRST.
	SSC_CR_SWRST = 0x8000

	// CMR: Clock Mode Register
	// Position of DIV field.
	SSC_CMR_DIV_Pos = 0x0
	// Bit mask of DIV field.
	SSC_CMR_DIV_Msk = 0xfff

	// RCMR: Receive Clock Mode Register
	// Position of CKS field.
	SSC_RCMR_CKS_Pos = 0x0
	// Bit mask of CKS field.
	SSC_RCMR_CKS_Msk = 0x3
	// Divided Clock
	SSC_RCMR_CKS_MCK = 0x0
	// TK Clock signal
	SSC_RCMR_CKS_TK = 0x1
	// RK pin
	SSC_RCMR_CKS_RK = 0x2
	// Position of CKO field.
	SSC_RCMR_CKO_Pos = 0x2
	// Bit mask of CKO field.
	SSC_RCMR_CKO_Msk = 0x1c
	// None, RK pin is an input
	SSC_RCMR_CKO_NONE = 0x0
	// Continuous Receive Clock, RK pin is an output
	SSC_RCMR_CKO_CONTINUOUS = 0x1
	// Receive Clock only during data transfers, RK pin is an output
	SSC_RCMR_CKO_TRANSFER = 0x2
	// Position of CKI field.
	SSC_RCMR_CKI_Pos = 0x5
	// Bit mask of CKI field.
	SSC_RCMR_CKI_Msk = 0x20
	// Bit CKI.
	SSC_RCMR_CKI = 0x20
	// Position of CKG field.
	SSC_RCMR_CKG_Pos = 0x6
	// Bit mask of CKG field.
	SSC_RCMR_CKG_Msk = 0xc0
	// None
	SSC_RCMR_CKG_CONTINUOUS = 0x0
	// Receive Clock enabled only if RF Low
	SSC_RCMR_CKG_EN_RF_LOW = 0x1
	// Receive Clock enabled only if RF High
	SSC_RCMR_CKG_EN_RF_HIGH = 0x2
	// Position of START field.
	SSC_RCMR_START_Pos = 0x8
	// Bit mask of START field.
	SSC_RCMR_START_Msk = 0xf00
	// Continuous, as soon as the receiver is enabled, and immediately after the end of transfer of the previous data.
	SSC_RCMR_START_CONTINUOUS = 0x0
	// Transmit start
	SSC_RCMR_START_TRANSMIT = 0x1
	// Detection of a low level on RF signal
	SSC_RCMR_START_RF_LOW = 0x2
	// Detection of a high level on RF signal
	SSC_RCMR_START_RF_HIGH = 0x3
	// Detection of a falling edge on RF signal
	SSC_RCMR_START_RF_FALLING = 0x4
	// Detection of a rising edge on RF signal
	SSC_RCMR_START_RF_RISING = 0x5
	// Detection of any level change on RF signal
	SSC_RCMR_START_RF_LEVEL = 0x6
	// Detection of any edge on RF signal
	SSC_RCMR_START_RF_EDGE = 0x7
	// Compare 0
	SSC_RCMR_START_CMP_0 = 0x8
	// Position of STOP field.
	SSC_RCMR_STOP_Pos = 0xc
	// Bit mask of STOP field.
	SSC_RCMR_STOP_Msk = 0x1000
	// Bit STOP.
	SSC_RCMR_STOP = 0x1000
	// Position of STTDLY field.
	SSC_RCMR_STTDLY_Pos = 0x10
	// Bit mask of STTDLY field.
	SSC_RCMR_STTDLY_Msk = 0xff0000
	// Position of PERIOD field.
	SSC_RCMR_PERIOD_Pos = 0x18
	// Bit mask of PERIOD field.
	SSC_RCMR_PERIOD_Msk = 0xff000000

	// RFMR: Receive Frame Mode Register
	// Position of DATLEN field.
	SSC_RFMR_DATLEN_Pos = 0x0
	// Bit mask of DATLEN field.
	SSC_RFMR_DATLEN_Msk = 0x1f
	// Position of LOOP field.
	SSC_RFMR_LOOP_Pos = 0x5
	// Bit mask of LOOP field.
	SSC_RFMR_LOOP_Msk = 0x20
	// Bit LOOP.
	SSC_RFMR_LOOP = 0x20
	// Position of MSBF field.
	SSC_RFMR_MSBF_Pos = 0x7
	// Bit mask of MSBF field.
	SSC_RFMR_MSBF_Msk = 0x80
	// Bit MSBF.
	SSC_RFMR_MSBF = 0x80
	// Position of DATNB field.
	SSC_RFMR_DATNB_Pos = 0x8
	// Bit mask of DATNB field.
	SSC_RFMR_DATNB_Msk = 0xf00
	// Position of FSLEN field.
	SSC_RFMR_FSLEN_Pos = 0x10
	// Bit mask of FSLEN field.
	SSC_RFMR_FSLEN_Msk = 0xf0000
	// Position of FSOS field.
	SSC_RFMR_FSOS_Pos = 0x14
	// Bit mask of FSOS field.
	SSC_RFMR_FSOS_Msk = 0x700000
	// None, RF pin is an input
	SSC_RFMR_FSOS_NONE = 0x0
	// Negative Pulse, RF pin is an output
	SSC_RFMR_FSOS_NEGATIVE = 0x1
	// Positive Pulse, RF pin is an output
	SSC_RFMR_FSOS_POSITIVE = 0x2
	// Driven Low during data transfer, RF pin is an output
	SSC_RFMR_FSOS_LOW = 0x3
	// Driven High during data transfer, RF pin is an output
	SSC_RFMR_FSOS_HIGH = 0x4
	// Toggling at each start of data transfer, RF pin is an output
	SSC_RFMR_FSOS_TOGGLING = 0x5
	// Position of FSEDGE field.
	SSC_RFMR_FSEDGE_Pos = 0x18
	// Bit mask of FSEDGE field.
	SSC_RFMR_FSEDGE_Msk = 0x1000000
	// Bit FSEDGE.
	SSC_RFMR_FSEDGE = 0x1000000
	// Positive Edge Detection
	SSC_RFMR_FSEDGE_POSITIVE = 0x0
	// Negative Edge Detection
	SSC_RFMR_FSEDGE_NEGATIVE = 0x1
	// Position of FSLEN_EXT field.
	SSC_RFMR_FSLEN_EXT_Pos = 0x1c
	// Bit mask of FSLEN_EXT field.
	SSC_RFMR_FSLEN_EXT_Msk = 0xf0000000

	// TCMR: Transmit Clock Mode Register
	// Position of CKS field.
	SSC_TCMR_CKS_Pos = 0x0
	// Bit mask of CKS field.
	SSC_TCMR_CKS_Msk = 0x3
	// Divided Clock
	SSC_TCMR_CKS_MCK = 0x0
	// RK Clock signal
	SSC_TCMR_CKS_RK = 0x1
	// TK pin
	SSC_TCMR_CKS_TK = 0x2
	// Position of CKO field.
	SSC_TCMR_CKO_Pos = 0x2
	// Bit mask of CKO field.
	SSC_TCMR_CKO_Msk = 0x1c
	// None, TK pin is an input
	SSC_TCMR_CKO_NONE = 0x0
	// Continuous Transmit Clock, TK pin is an output
	SSC_TCMR_CKO_CONTINUOUS = 0x1
	// Transmit Clock only during data transfers, TK pin is an output
	SSC_TCMR_CKO_TRANSFER = 0x2
	// Position of CKI field.
	SSC_TCMR_CKI_Pos = 0x5
	// Bit mask of CKI field.
	SSC_TCMR_CKI_Msk = 0x20
	// Bit CKI.
	SSC_TCMR_CKI = 0x20
	// Position of CKG field.
	SSC_TCMR_CKG_Pos = 0x6
	// Bit mask of CKG field.
	SSC_TCMR_CKG_Msk = 0xc0
	// None
	SSC_TCMR_CKG_CONTINUOUS = 0x0
	// Transmit Clock enabled only if TF Low
	SSC_TCMR_CKG_EN_TF_LOW = 0x1
	// Transmit Clock enabled only if TF High
	SSC_TCMR_CKG_EN_TF_HIGH = 0x2
	// Position of START field.
	SSC_TCMR_START_Pos = 0x8
	// Bit mask of START field.
	SSC_TCMR_START_Msk = 0xf00
	// Continuous, as soon as a word is written in the SSC_THR Register (if Transmit is enabled), and immediately after the end of transfer of the previous data
	SSC_TCMR_START_CONTINUOUS = 0x0
	// Receive start
	SSC_TCMR_START_RECEIVE = 0x1
	// Detection of a low level on TF signal
	SSC_TCMR_START_TF_LOW = 0x2
	// Detection of a high level on TF signal
	SSC_TCMR_START_TF_HIGH = 0x3
	// Detection of a falling edge on TF signal
	SSC_TCMR_START_TF_FALLING = 0x4
	// Detection of a rising edge on TF signal
	SSC_TCMR_START_TF_RISING = 0x5
	// Detection of any level change on TF signal
	SSC_TCMR_START_TF_LEVEL = 0x6
	// Detection of any edge on TF signal
	SSC_TCMR_START_TF_EDGE = 0x7
	// Position of STTDLY field.
	SSC_TCMR_STTDLY_Pos = 0x10
	// Bit mask of STTDLY field.
	SSC_TCMR_STTDLY_Msk = 0xff0000
	// Position of PERIOD field.
	SSC_TCMR_PERIOD_Pos = 0x18
	// Bit mask of PERIOD field.
	SSC_TCMR_PERIOD_Msk = 0xff000000

	// TFMR: Transmit Frame Mode Register
	// Position of DATLEN field.
	SSC_TFMR_DATLEN_Pos = 0x0
	// Bit mask of DATLEN field.
	SSC_TFMR_DATLEN_Msk = 0x1f
	// Position of DATDEF field.
	SSC_TFMR_DATDEF_Pos = 0x5
	// Bit mask of DATDEF field.
	SSC_TFMR_DATDEF_Msk = 0x20
	// Bit DATDEF.
	SSC_TFMR_DATDEF = 0x20
	// Position of MSBF field.
	SSC_TFMR_MSBF_Pos = 0x7
	// Bit mask of MSBF field.
	SSC_TFMR_MSBF_Msk = 0x80
	// Bit MSBF.
	SSC_TFMR_MSBF = 0x80
	// Position of DATNB field.
	SSC_TFMR_DATNB_Pos = 0x8
	// Bit mask of DATNB field.
	SSC_TFMR_DATNB_Msk = 0xf00
	// Position of FSLEN field.
	SSC_TFMR_FSLEN_Pos = 0x10
	// Bit mask of FSLEN field.
	SSC_TFMR_FSLEN_Msk = 0xf0000
	// Position of FSOS field.
	SSC_TFMR_FSOS_Pos = 0x14
	// Bit mask of FSOS field.
	SSC_TFMR_FSOS_Msk = 0x700000
	// None, RF pin is an input
	SSC_TFMR_FSOS_NONE = 0x0
	// Negative Pulse, RF pin is an output
	SSC_TFMR_FSOS_NEGATIVE = 0x1
	// Positive Pulse, RF pin is an output
	SSC_TFMR_FSOS_POSITIVE = 0x2
	// Driven Low during data transfer
	SSC_TFMR_FSOS_LOW = 0x3
	// Driven High during data transfer
	SSC_TFMR_FSOS_HIGH = 0x4
	// Toggling at each start of data transfer
	SSC_TFMR_FSOS_TOGGLING = 0x5
	// Position of FSDEN field.
	SSC_TFMR_FSDEN_Pos = 0x17
	// Bit mask of FSDEN field.
	SSC_TFMR_FSDEN_Msk = 0x800000
	// Bit FSDEN.
	SSC_TFMR_FSDEN = 0x800000
	// Position of FSEDGE field.
	SSC_TFMR_FSEDGE_Pos = 0x18
	// Bit mask of FSEDGE field.
	SSC_TFMR_FSEDGE_Msk = 0x1000000
	// Bit FSEDGE.
	SSC_TFMR_FSEDGE = 0x1000000
	// Positive Edge Detection
	SSC_TFMR_FSEDGE_POSITIVE = 0x0
	// Negative Edge Detection
	SSC_TFMR_FSEDGE_NEGATIVE = 0x1
	// Position of FSLEN_EXT field.
	SSC_TFMR_FSLEN_EXT_Pos = 0x1c
	// Bit mask of FSLEN_EXT field.
	SSC_TFMR_FSLEN_EXT_Msk = 0xf0000000

	// RHR: Receive Holding Register
	// Position of RDAT field.
	SSC_RHR_RDAT_Pos = 0x0
	// Bit mask of RDAT field.
	SSC_RHR_RDAT_Msk = 0xffffffff

	// THR: Transmit Holding Register
	// Position of TDAT field.
	SSC_THR_TDAT_Pos = 0x0
	// Bit mask of TDAT field.
	SSC_THR_TDAT_Msk = 0xffffffff

	// RSHR: Receive Sync. Holding Register
	// Position of RSDAT field.
	SSC_RSHR_RSDAT_Pos = 0x0
	// Bit mask of RSDAT field.
	SSC_RSHR_RSDAT_Msk = 0xffff

	// TSHR: Transmit Sync. Holding Register
	// Position of TSDAT field.
	SSC_TSHR_TSDAT_Pos = 0x0
	// Bit mask of TSDAT field.
	SSC_TSHR_TSDAT_Msk = 0xffff

	// RC0R: Receive Compare 0 Register
	// Position of CP0 field.
	SSC_RC0R_CP0_Pos = 0x0
	// Bit mask of CP0 field.
	SSC_RC0R_CP0_Msk = 0xffff

	// RC1R: Receive Compare 1 Register
	// Position of CP1 field.
	SSC_RC1R_CP1_Pos = 0x0
	// Bit mask of CP1 field.
	SSC_RC1R_CP1_Msk = 0xffff

	// SR: Status Register
	// Position of TXRDY field.
	SSC_SR_TXRDY_Pos = 0x0
	// Bit mask of TXRDY field.
	SSC_SR_TXRDY_Msk = 0x1
	// Bit TXRDY.
	SSC_SR_TXRDY = 0x1
	// Position of TXEMPTY field.
	SSC_SR_TXEMPTY_Pos = 0x1
	// Bit mask of TXEMPTY field.
	SSC_SR_TXEMPTY_Msk = 0x2
	// Bit TXEMPTY.
	SSC_SR_TXEMPTY = 0x2
	// Position of RXRDY field.
	SSC_SR_RXRDY_Pos = 0x4
	// Bit mask of RXRDY field.
	SSC_SR_RXRDY_Msk = 0x10
	// Bit RXRDY.
	SSC_SR_RXRDY = 0x10
	// Position of OVRUN field.
	SSC_SR_OVRUN_Pos = 0x5
	// Bit mask of OVRUN field.
	SSC_SR_OVRUN_Msk = 0x20
	// Bit OVRUN.
	SSC_SR_OVRUN = 0x20
	// Position of CP0 field.
	SSC_SR_CP0_Pos = 0x8
	// Bit mask of CP0 field.
	SSC_SR_CP0_Msk = 0x100
	// Bit CP0.
	SSC_SR_CP0 = 0x100
	// Position of CP1 field.
	SSC_SR_CP1_Pos = 0x9
	// Bit mask of CP1 field.
	SSC_SR_CP1_Msk = 0x200
	// Bit CP1.
	SSC_SR_CP1 = 0x200
	// Position of TXSYN field.
	SSC_SR_TXSYN_Pos = 0xa
	// Bit mask of TXSYN field.
	SSC_SR_TXSYN_Msk = 0x400
	// Bit TXSYN.
	SSC_SR_TXSYN = 0x400
	// Position of RXSYN field.
	SSC_SR_RXSYN_Pos = 0xb
	// Bit mask of RXSYN field.
	SSC_SR_RXSYN_Msk = 0x800
	// Bit RXSYN.
	SSC_SR_RXSYN = 0x800
	// Position of TXEN field.
	SSC_SR_TXEN_Pos = 0x10
	// Bit mask of TXEN field.
	SSC_SR_TXEN_Msk = 0x10000
	// Bit TXEN.
	SSC_SR_TXEN = 0x10000
	// Position of RXEN field.
	SSC_SR_RXEN_Pos = 0x11
	// Bit mask of RXEN field.
	SSC_SR_RXEN_Msk = 0x20000
	// Bit RXEN.
	SSC_SR_RXEN = 0x20000

	// IER: Interrupt Enable Register
	// Position of TXRDY field.
	SSC_IER_TXRDY_Pos = 0x0
	// Bit mask of TXRDY field.
	SSC_IER_TXRDY_Msk = 0x1
	// Bit TXRDY.
	SSC_IER_TXRDY = 0x1
	// Position of TXEMPTY field.
	SSC_IER_TXEMPTY_Pos = 0x1
	// Bit mask of TXEMPTY field.
	SSC_IER_TXEMPTY_Msk = 0x2
	// Bit TXEMPTY.
	SSC_IER_TXEMPTY = 0x2
	// Position of RXRDY field.
	SSC_IER_RXRDY_Pos = 0x4
	// Bit mask of RXRDY field.
	SSC_IER_RXRDY_Msk = 0x10
	// Bit RXRDY.
	SSC_IER_RXRDY = 0x10
	// Position of OVRUN field.
	SSC_IER_OVRUN_Pos = 0x5
	// Bit mask of OVRUN field.
	SSC_IER_OVRUN_Msk = 0x20
	// Bit OVRUN.
	SSC_IER_OVRUN = 0x20
	// Position of CP0 field.
	SSC_IER_CP0_Pos = 0x8
	// Bit mask of CP0 field.
	SSC_IER_CP0_Msk = 0x100
	// Bit CP0.
	SSC_IER_CP0 = 0x100
	// Position of CP1 field.
	SSC_IER_CP1_Pos = 0x9
	// Bit mask of CP1 field.
	SSC_IER_CP1_Msk = 0x200
	// Bit CP1.
	SSC_IER_CP1 = 0x200
	// Position of TXSYN field.
	SSC_IER_TXSYN_Pos = 0xa
	// Bit mask of TXSYN field.
	SSC_IER_TXSYN_Msk = 0x400
	// Bit TXSYN.
	SSC_IER_TXSYN = 0x400
	// Position of RXSYN field.
	SSC_IER_RXSYN_Pos = 0xb
	// Bit mask of RXSYN field.
	SSC_IER_RXSYN_Msk = 0x800
	// Bit RXSYN.
	SSC_IER_RXSYN = 0x800

	// IDR: Interrupt Disable Register
	// Position of TXRDY field.
	SSC_IDR_TXRDY_Pos = 0x0
	// Bit mask of TXRDY field.
	SSC_IDR_TXRDY_Msk = 0x1
	// Bit TXRDY.
	SSC_IDR_TXRDY = 0x1
	// Position of TXEMPTY field.
	SSC_IDR_TXEMPTY_Pos = 0x1
	// Bit mask of TXEMPTY field.
	SSC_IDR_TXEMPTY_Msk = 0x2
	// Bit TXEMPTY.
	SSC_IDR_TXEMPTY = 0x2
	// Position of RXRDY field.
	SSC_IDR_RXRDY_Pos = 0x4
	// Bit mask of RXRDY field.
	SSC_IDR_RXRDY_Msk = 0x10
	// Bit RXRDY.
	SSC_IDR_RXRDY = 0x10
	// Position of OVRUN field.
	SSC_IDR_OVRUN_Pos = 0x5
	// Bit mask of OVRUN field.
	SSC_IDR_OVRUN_Msk = 0x20
	// Bit OVRUN.
	SSC_IDR_OVRUN = 0x20
	// Position of CP0 field.
	SSC_IDR_CP0_Pos = 0x8
	// Bit mask of CP0 field.
	SSC_IDR_CP0_Msk = 0x100
	// Bit CP0.
	SSC_IDR_CP0 = 0x100
	// Position of CP1 field.
	SSC_IDR_CP1_Pos = 0x9
	// Bit mask of CP1 field.
	SSC_IDR_CP1_Msk = 0x200
	// Bit CP1.
	SSC_IDR_CP1 = 0x200
	// Position of TXSYN field.
	SSC_IDR_TXSYN_Pos = 0xa
	// Bit mask of TXSYN field.
	SSC_IDR_TXSYN_Msk = 0x400
	// Bit TXSYN.
	SSC_IDR_TXSYN = 0x400
	// Position of RXSYN field.
	SSC_IDR_RXSYN_Pos = 0xb
	// Bit mask of RXSYN field.
	SSC_IDR_RXSYN_Msk = 0x800
	// Bit RXSYN.
	SSC_IDR_RXSYN = 0x800

	// IMR: Interrupt Mask Register
	// Position of TXRDY field.
	SSC_IMR_TXRDY_Pos = 0x0
	// Bit mask of TXRDY field.
	SSC_IMR_TXRDY_Msk = 0x1
	// Bit TXRDY.
	SSC_IMR_TXRDY = 0x1
	// Position of TXEMPTY field.
	SSC_IMR_TXEMPTY_Pos = 0x1
	// Bit mask of TXEMPTY field.
	SSC_IMR_TXEMPTY_Msk = 0x2
	// Bit TXEMPTY.
	SSC_IMR_TXEMPTY = 0x2
	// Position of RXRDY field.
	SSC_IMR_RXRDY_Pos = 0x4
	// Bit mask of RXRDY field.
	SSC_IMR_RXRDY_Msk = 0x10
	// Bit RXRDY.
	SSC_IMR_RXRDY = 0x10
	// Position of OVRUN field.
	SSC_IMR_OVRUN_Pos = 0x5
	// Bit mask of OVRUN field.
	SSC_IMR_OVRUN_Msk = 0x20
	// Bit OVRUN.
	SSC_IMR_OVRUN = 0x20
	// Position of CP0 field.
	SSC_IMR_CP0_Pos = 0x8
	// Bit mask of CP0 field.
	SSC_IMR_CP0_Msk = 0x100
	// Bit CP0.
	SSC_IMR_CP0 = 0x100
	// Position of CP1 field.
	SSC_IMR_CP1_Pos = 0x9
	// Bit mask of CP1 field.
	SSC_IMR_CP1_Msk = 0x200
	// Bit CP1.
	SSC_IMR_CP1 = 0x200
	// Position of TXSYN field.
	SSC_IMR_TXSYN_Pos = 0xa
	// Bit mask of TXSYN field.
	SSC_IMR_TXSYN_Msk = 0x400
	// Bit TXSYN.
	SSC_IMR_TXSYN = 0x400
	// Position of RXSYN field.
	SSC_IMR_RXSYN_Pos = 0xb
	// Bit mask of RXSYN field.
	SSC_IMR_RXSYN_Msk = 0x800
	// Bit RXSYN.
	SSC_IMR_RXSYN = 0x800

	// WPMR: Write Protect Mode Register
	// Position of WPEN field.
	SSC_WPMR_WPEN_Pos = 0x0
	// Bit mask of WPEN field.
	SSC_WPMR_WPEN_Msk = 0x1
	// Bit WPEN.
	SSC_WPMR_WPEN = 0x1
	// Position of WPKEY field.
	SSC_WPMR_WPKEY_Pos = 0x8
	// Bit mask of WPKEY field.
	SSC_WPMR_WPKEY_Msk = 0xffffff00
	// Writing any other value in this field aborts the write operation of the WPEN bit.Always reads as 0.
	SSC_WPMR_WPKEY_PASSWD = 0x535343
)

// Bitfields for SPI: Serial Peripheral Interface
const (
	// CR: Control Register
	// Position of SPIEN field.
	SPI_CR_SPIEN_Pos = 0x0
	// Bit mask of SPIEN field.
	SPI_CR_SPIEN_Msk = 0x1
	// Bit SPIEN.
	SPI_CR_SPIEN = 0x1
	// Position of SPIDIS field.
	SPI_CR_SPIDIS_Pos = 0x1
	// Bit mask of SPIDIS field.
	SPI_CR_SPIDIS_Msk = 0x2
	// Bit SPIDIS.
	SPI_CR_SPIDIS = 0x2
	// Position of SWRST field.
	SPI_CR_SWRST_Pos = 0x7
	// Bit mask of SWRST field.
	SPI_CR_SWRST_Msk = 0x80
	// Bit SWRST.
	SPI_CR_SWRST = 0x80
	// Position of LASTXFER field.
	SPI_CR_LASTXFER_Pos = 0x18
	// Bit mask of LASTXFER field.
	SPI_CR_LASTXFER_Msk = 0x1000000
	// Bit LASTXFER.
	SPI_CR_LASTXFER = 0x1000000

	// MR: Mode Register
	// Position of MSTR field.
	SPI_MR_MSTR_Pos = 0x0
	// Bit mask of MSTR field.
	SPI_MR_MSTR_Msk = 0x1
	// Bit MSTR.
	SPI_MR_MSTR = 0x1
	// Position of PS field.
	SPI_MR_PS_Pos = 0x1
	// Bit mask of PS field.
	SPI_MR_PS_Msk = 0x2
	// Bit PS.
	SPI_MR_PS = 0x2
	// Position of PCSDEC field.
	SPI_MR_PCSDEC_Pos = 0x2
	// Bit mask of PCSDEC field.
	SPI_MR_PCSDEC_Msk = 0x4
	// Bit PCSDEC.
	SPI_MR_PCSDEC = 0x4
	// Position of MODFDIS field.
	SPI_MR_MODFDIS_Pos = 0x4
	// Bit mask of MODFDIS field.
	SPI_MR_MODFDIS_Msk = 0x10
	// Bit MODFDIS.
	SPI_MR_MODFDIS = 0x10
	// Position of WDRBT field.
	SPI_MR_WDRBT_Pos = 0x5
	// Bit mask of WDRBT field.
	SPI_MR_WDRBT_Msk = 0x20
	// Bit WDRBT.
	SPI_MR_WDRBT = 0x20
	// Position of LLB field.
	SPI_MR_LLB_Pos = 0x7
	// Bit mask of LLB field.
	SPI_MR_LLB_Msk = 0x80
	// Bit LLB.
	SPI_MR_LLB = 0x80
	// Position of PCS field.
	SPI_MR_PCS_Pos = 0x10
	// Bit mask of PCS field.
	SPI_MR_PCS_Msk = 0xf0000
	// Position of DLYBCS field.
	SPI_MR_DLYBCS_Pos = 0x18
	// Bit mask of DLYBCS field.
	SPI_MR_DLYBCS_Msk = 0xff000000

	// RDR: Receive Data Register
	// Position of RD field.
	SPI_RDR_RD_Pos = 0x0
	// Bit mask of RD field.
	SPI_RDR_RD_Msk = 0xffff
	// Position of PCS field.
	SPI_RDR_PCS_Pos = 0x10
	// Bit mask of PCS field.
	SPI_RDR_PCS_Msk = 0xf0000

	// TDR: Transmit Data Register
	// Position of TD field.
	SPI_TDR_TD_Pos = 0x0
	// Bit mask of TD field.
	SPI_TDR_TD_Msk = 0xffff
	// Position of PCS field.
	SPI_TDR_PCS_Pos = 0x10
	// Bit mask of PCS field.
	SPI_TDR_PCS_Msk = 0xf0000
	// Position of LASTXFER field.
	SPI_TDR_LASTXFER_Pos = 0x18
	// Bit mask of LASTXFER field.
	SPI_TDR_LASTXFER_Msk = 0x1000000
	// Bit LASTXFER.
	SPI_TDR_LASTXFER = 0x1000000

	// SR: Status Register
	// Position of RDRF field.
	SPI_SR_RDRF_Pos = 0x0
	// Bit mask of RDRF field.
	SPI_SR_RDRF_Msk = 0x1
	// Bit RDRF.
	SPI_SR_RDRF = 0x1
	// Position of TDRE field.
	SPI_SR_TDRE_Pos = 0x1
	// Bit mask of TDRE field.
	SPI_SR_TDRE_Msk = 0x2
	// Bit TDRE.
	SPI_SR_TDRE = 0x2
	// Position of MODF field.
	SPI_SR_MODF_Pos = 0x2
	// Bit mask of MODF field.
	SPI_SR_MODF_Msk = 0x4
	// Bit MODF.
	SPI_SR_MODF = 0x4
	// Position of OVRES field.
	SPI_SR_OVRES_Pos = 0x3
	// Bit mask of OVRES field.
	SPI_SR_OVRES_Msk = 0x8
	// Bit OVRES.
	SPI_SR_OVRES = 0x8
	// Position of NSSR field.
	SPI_SR_NSSR_Pos = 0x8
	// Bit mask of NSSR field.
	SPI_SR_NSSR_Msk = 0x100
	// Bit NSSR.
	SPI_SR_NSSR = 0x100
	// Position of TXEMPTY field.
	SPI_SR_TXEMPTY_Pos = 0x9
	// Bit mask of TXEMPTY field.
	SPI_SR_TXEMPTY_Msk = 0x200
	// Bit TXEMPTY.
	SPI_SR_TXEMPTY = 0x200
	// Position of UNDES field.
	SPI_SR_UNDES_Pos = 0xa
	// Bit mask of UNDES field.
	SPI_SR_UNDES_Msk = 0x400
	// Bit UNDES.
	SPI_SR_UNDES = 0x400
	// Position of SPIENS field.
	SPI_SR_SPIENS_Pos = 0x10
	// Bit mask of SPIENS field.
	SPI_SR_SPIENS_Msk = 0x10000
	// Bit SPIENS.
	SPI_SR_SPIENS = 0x10000

	// IER: Interrupt Enable Register
	// Position of RDRF field.
	SPI_IER_RDRF_Pos = 0x0
	// Bit mask of RDRF field.
	SPI_IER_RDRF_Msk = 0x1
	// Bit RDRF.
	SPI_IER_RDRF = 0x1
	// Position of TDRE field.
	SPI_IER_TDRE_Pos = 0x1
	// Bit mask of TDRE field.
	SPI_IER_TDRE_Msk = 0x2
	// Bit TDRE.
	SPI_IER_TDRE = 0x2
	// Position of MODF field.
	SPI_IER_MODF_Pos = 0x2
	// Bit mask of MODF field.
	SPI_IER_MODF_Msk = 0x4
	// Bit MODF.
	SPI_IER_MODF = 0x4
	// Position of OVRES field.
	SPI_IER_OVRES_Pos = 0x3
	// Bit mask of OVRES field.
	SPI_IER_OVRES_Msk = 0x8
	// Bit OVRES.
	SPI_IER_OVRES = 0x8
	// Position of NSSR field.
	SPI_IER_NSSR_Pos = 0x8
	// Bit mask of NSSR field.
	SPI_IER_NSSR_Msk = 0x100
	// Bit NSSR.
	SPI_IER_NSSR = 0x100
	// Position of TXEMPTY field.
	SPI_IER_TXEMPTY_Pos = 0x9
	// Bit mask of TXEMPTY field.
	SPI_IER_TXEMPTY_Msk = 0x200
	// Bit TXEMPTY.
	SPI_IER_TXEMPTY = 0x200
	// Position of UNDES field.
	SPI_IER_UNDES_Pos = 0xa
	// Bit mask of UNDES field.
	SPI_IER_UNDES_Msk = 0x400
	// Bit UNDES.
	SPI_IER_UNDES = 0x400

	// IDR: Interrupt Disable Register
	// Position of RDRF field.
	SPI_IDR_RDRF_Pos = 0x0
	// Bit mask of RDRF field.
	SPI_IDR_RDRF_Msk = 0x1
	// Bit RDRF.
	SPI_IDR_RDRF = 0x1
	// Position of TDRE field.
	SPI_IDR_TDRE_Pos = 0x1
	// Bit mask of TDRE field.
	SPI_IDR_TDRE_Msk = 0x2
	// Bit TDRE.
	SPI_IDR_TDRE = 0x2
	// Position of MODF field.
	SPI_IDR_MODF_Pos = 0x2
	// Bit mask of MODF field.
	SPI_IDR_MODF_Msk = 0x4
	// Bit MODF.
	SPI_IDR_MODF = 0x4
	// Position of OVRES field.
	SPI_IDR_OVRES_Pos = 0x3
	// Bit mask of OVRES field.
	SPI_IDR_OVRES_Msk = 0x8
	// Bit OVRES.
	SPI_IDR_OVRES = 0x8
	// Position of NSSR field.
	SPI_IDR_NSSR_Pos = 0x8
	// Bit mask of NSSR field.
	SPI_IDR_NSSR_Msk = 0x100
	// Bit NSSR.
	SPI_IDR_NSSR = 0x100
	// Position of TXEMPTY field.
	SPI_IDR_TXEMPTY_Pos = 0x9
	// Bit mask of TXEMPTY field.
	SPI_IDR_TXEMPTY_Msk = 0x200
	// Bit TXEMPTY.
	SPI_IDR_TXEMPTY = 0x200
	// Position of UNDES field.
	SPI_IDR_UNDES_Pos = 0xa
	// Bit mask of UNDES field.
	SPI_IDR_UNDES_Msk = 0x400
	// Bit UNDES.
	SPI_IDR_UNDES = 0x400

	// IMR: Interrupt Mask Register
	// Position of RDRF field.
	SPI_IMR_RDRF_Pos = 0x0
	// Bit mask of RDRF field.
	SPI_IMR_RDRF_Msk = 0x1
	// Bit RDRF.
	SPI_IMR_RDRF = 0x1
	// Position of TDRE field.
	SPI_IMR_TDRE_Pos = 0x1
	// Bit mask of TDRE field.
	SPI_IMR_TDRE_Msk = 0x2
	// Bit TDRE.
	SPI_IMR_TDRE = 0x2
	// Position of MODF field.
	SPI_IMR_MODF_Pos = 0x2
	// Bit mask of MODF field.
	SPI_IMR_MODF_Msk = 0x4
	// Bit MODF.
	SPI_IMR_MODF = 0x4
	// Position of OVRES field.
	SPI_IMR_OVRES_Pos = 0x3
	// Bit mask of OVRES field.
	SPI_IMR_OVRES_Msk = 0x8
	// Bit OVRES.
	SPI_IMR_OVRES = 0x8
	// Position of NSSR field.
	SPI_IMR_NSSR_Pos = 0x8
	// Bit mask of NSSR field.
	SPI_IMR_NSSR_Msk = 0x100
	// Bit NSSR.
	SPI_IMR_NSSR = 0x100
	// Position of TXEMPTY field.
	SPI_IMR_TXEMPTY_Pos = 0x9
	// Bit mask of TXEMPTY field.
	SPI_IMR_TXEMPTY_Msk = 0x200
	// Bit TXEMPTY.
	SPI_IMR_TXEMPTY = 0x200
	// Position of UNDES field.
	SPI_IMR_UNDES_Pos = 0xa
	// Bit mask of UNDES field.
	SPI_IMR_UNDES_Msk = 0x400
	// Bit UNDES.
	SPI_IMR_UNDES = 0x400

	// CSR: Chip Select Register
	// Position of CPOL field.
	SPI_CSR_CPOL_Pos = 0x0
	// Bit mask of CPOL field.
	SPI_CSR_CPOL_Msk = 0x1
	// Bit CPOL.
	SPI_CSR_CPOL = 0x1
	// Position of NCPHA field.
	SPI_CSR_NCPHA_Pos = 0x1
	// Bit mask of NCPHA field.
	SPI_CSR_NCPHA_Msk = 0x2
	// Bit NCPHA.
	SPI_CSR_NCPHA = 0x2
	// Position of CSNAAT field.
	SPI_CSR_CSNAAT_Pos = 0x2
	// Bit mask of CSNAAT field.
	SPI_CSR_CSNAAT_Msk = 0x4
	// Bit CSNAAT.
	SPI_CSR_CSNAAT = 0x4
	// Position of CSAAT field.
	SPI_CSR_CSAAT_Pos = 0x3
	// Bit mask of CSAAT field.
	SPI_CSR_CSAAT_Msk = 0x8
	// Bit CSAAT.
	SPI_CSR_CSAAT = 0x8
	// Position of BITS field.
	SPI_CSR_BITS_Pos = 0x4
	// Bit mask of BITS field.
	SPI_CSR_BITS_Msk = 0xf0
	// 8 bits for transfer
	SPI_CSR_BITS_8_BIT = 0x0
	// 9 bits for transfer
	SPI_CSR_BITS_9_BIT = 0x1
	// 10 bits for transfer
	SPI_CSR_BITS_10_BIT = 0x2
	// 11 bits for transfer
	SPI_CSR_BITS_11_BIT = 0x3
	// 12 bits for transfer
	SPI_CSR_BITS_12_BIT = 0x4
	// 13 bits for transfer
	SPI_CSR_BITS_13_BIT = 0x5
	// 14 bits for transfer
	SPI_CSR_BITS_14_BIT = 0x6
	// 15 bits for transfer
	SPI_CSR_BITS_15_BIT = 0x7
	// 16 bits for transfer
	SPI_CSR_BITS_16_BIT = 0x8
	// Position of SCBR field.
	SPI_CSR_SCBR_Pos = 0x8
	// Bit mask of SCBR field.
	SPI_CSR_SCBR_Msk = 0xff00
	// Position of DLYBS field.
	SPI_CSR_DLYBS_Pos = 0x10
	// Bit mask of DLYBS field.
	SPI_CSR_DLYBS_Msk = 0xff0000
	// Position of DLYBCT field.
	SPI_CSR_DLYBCT_Pos = 0x18
	// Bit mask of DLYBCT field.
	SPI_CSR_DLYBCT_Msk = 0xff000000

	// WPMR: Write Protection Control Register
	// Position of WPEN field.
	SPI_WPMR_WPEN_Pos = 0x0
	// Bit mask of WPEN field.
	SPI_WPMR_WPEN_Msk = 0x1
	// Bit WPEN.
	SPI_WPMR_WPEN = 0x1
	// Position of WPKEY field.
	SPI_WPMR_WPKEY_Pos = 0x8
	// Bit mask of WPKEY field.
	SPI_WPMR_WPKEY_Msk = 0xffffff00
	// Writing any other value in this field aborts the write operation of the WPEN bit.Always reads as 0.
	SPI_WPMR_WPKEY_PASSWD = 0x535049

	// WPSR: Write Protection Status Register
	// Position of WPVS field.
	SPI_WPSR_WPVS_Pos = 0x0
	// Bit mask of WPVS field.
	SPI_WPSR_WPVS_Msk = 0x1
	// Bit WPVS.
	SPI_WPSR_WPVS = 0x1
	// Position of WPVSRC field.
	SPI_WPSR_WPVSRC_Pos = 0x8
	// Bit mask of WPVSRC field.
	SPI_WPSR_WPVSRC_Msk = 0xff00
)

// Bitfields for TC0: Timer Counter 0
const (
	// CCR0: Channel Control Register (channel = 0)
	// Position of CLKEN field.
	TC_CCR0_CLKEN_Pos = 0x0
	// Bit mask of CLKEN field.
	TC_CCR0_CLKEN_Msk = 0x1
	// Bit CLKEN.
	TC_CCR0_CLKEN = 0x1
	// Position of CLKDIS field.
	TC_CCR0_CLKDIS_Pos = 0x1
	// Bit mask of CLKDIS field.
	TC_CCR0_CLKDIS_Msk = 0x2
	// Bit CLKDIS.
	TC_CCR0_CLKDIS = 0x2
	// Position of SWTRG field.
	TC_CCR0_SWTRG_Pos = 0x2
	// Bit mask of SWTRG field.
	TC_CCR0_SWTRG_Msk = 0x4
	// Bit SWTRG.
	TC_CCR0_SWTRG = 0x4

	// CMR0: Channel Mode Register (channel = 0)
	// Position of TCCLKS field.
	TC_CMR0_TCCLKS_Pos = 0x0
	// Bit mask of TCCLKS field.
	TC_CMR0_TCCLKS_Msk = 0x7
	// Clock selected: internal MCK/2 clock signal (from PMC)
	TC_CMR0_TCCLKS_TIMER_CLOCK1 = 0x0
	// Clock selected: internal MCK/8 clock signal (from PMC)
	TC_CMR0_TCCLKS_TIMER_CLOCK2 = 0x1
	// Clock selected: internal MCK/32 clock signal (from PMC)
	TC_CMR0_TCCLKS_TIMER_CLOCK3 = 0x2
	// Clock selected: internal MCK/128 clock signal (from PMC)
	TC_CMR0_TCCLKS_TIMER_CLOCK4 = 0x3
	// Clock selected: internal SLCK clock signal (from PMC)
	TC_CMR0_TCCLKS_TIMER_CLOCK5 = 0x4
	// Clock selected: XC0
	TC_CMR0_TCCLKS_XC0 = 0x5
	// Clock selected: XC1
	TC_CMR0_TCCLKS_XC1 = 0x6
	// Clock selected: XC2
	TC_CMR0_TCCLKS_XC2 = 0x7
	// Position of CLKI field.
	TC_CMR0_CLKI_Pos = 0x3
	// Bit mask of CLKI field.
	TC_CMR0_CLKI_Msk = 0x8
	// Bit CLKI.
	TC_CMR0_CLKI = 0x8
	// Position of BURST field.
	TC_CMR0_BURST_Pos = 0x4
	// Bit mask of BURST field.
	TC_CMR0_BURST_Msk = 0x30
	// The clock is not gated by an external signal.
	TC_CMR0_BURST_NONE = 0x0
	// XC0 is ANDed with the selected clock.
	TC_CMR0_BURST_XC0 = 0x1
	// XC1 is ANDed with the selected clock.
	TC_CMR0_BURST_XC1 = 0x2
	// XC2 is ANDed with the selected clock.
	TC_CMR0_BURST_XC2 = 0x3
	// Position of LDBSTOP field.
	TC_CMR0_LDBSTOP_Pos = 0x6
	// Bit mask of LDBSTOP field.
	TC_CMR0_LDBSTOP_Msk = 0x40
	// Bit LDBSTOP.
	TC_CMR0_LDBSTOP = 0x40
	// Position of LDBDIS field.
	TC_CMR0_LDBDIS_Pos = 0x7
	// Bit mask of LDBDIS field.
	TC_CMR0_LDBDIS_Msk = 0x80
	// Bit LDBDIS.
	TC_CMR0_LDBDIS = 0x80
	// Position of ETRGEDG field.
	TC_CMR0_ETRGEDG_Pos = 0x8
	// Bit mask of ETRGEDG field.
	TC_CMR0_ETRGEDG_Msk = 0x300
	// The clock is not gated by an external signal.
	TC_CMR0_ETRGEDG_NONE = 0x0
	// Rising edge
	TC_CMR0_ETRGEDG_RISING = 0x1
	// Falling edge
	TC_CMR0_ETRGEDG_FALLING = 0x2
	// Each edge
	TC_CMR0_ETRGEDG_EDGE = 0x3
	// Position of ABETRG field.
	TC_CMR0_ABETRG_Pos = 0xa
	// Bit mask of ABETRG field.
	TC_CMR0_ABETRG_Msk = 0x400
	// Bit ABETRG.
	TC_CMR0_ABETRG = 0x400
	// Position of CPCTRG field.
	TC_CMR0_CPCTRG_Pos = 0xe
	// Bit mask of CPCTRG field.
	TC_CMR0_CPCTRG_Msk = 0x4000
	// Bit CPCTRG.
	TC_CMR0_CPCTRG = 0x4000
	// Position of WAVE field.
	TC_CMR0_WAVE_Pos = 0xf
	// Bit mask of WAVE field.
	TC_CMR0_WAVE_Msk = 0x8000
	// Bit WAVE.
	TC_CMR0_WAVE = 0x8000
	// Position of LDRA field.
	TC_CMR0_LDRA_Pos = 0x10
	// Bit mask of LDRA field.
	TC_CMR0_LDRA_Msk = 0x30000
	// None
	TC_CMR0_LDRA_NONE = 0x0
	// Rising edge of TIOA
	TC_CMR0_LDRA_RISING = 0x1
	// Falling edge of TIOA
	TC_CMR0_LDRA_FALLING = 0x2
	// Each edge of TIOA
	TC_CMR0_LDRA_EDGE = 0x3
	// Position of LDRB field.
	TC_CMR0_LDRB_Pos = 0x12
	// Bit mask of LDRB field.
	TC_CMR0_LDRB_Msk = 0xc0000
	// None
	TC_CMR0_LDRB_NONE = 0x0
	// Rising edge of TIOA
	TC_CMR0_LDRB_RISING = 0x1
	// Falling edge of TIOA
	TC_CMR0_LDRB_FALLING = 0x2
	// Each edge of TIOA
	TC_CMR0_LDRB_EDGE = 0x3

	// CMR0_WAVEFORM_MODE: Channel Mode Register (channel = 0)
	// Position of TCCLKS field.
	TC_CMR0_WAVEFORM_MODE_TCCLKS_Pos = 0x0
	// Bit mask of TCCLKS field.
	TC_CMR0_WAVEFORM_MODE_TCCLKS_Msk = 0x7
	// Clock selected: internal MCK/2 clock signal (from PMC)
	TC_CMR0_WAVEFORM_MODE_TCCLKS_TIMER_CLOCK1 = 0x0
	// Clock selected: internal MCK/8 clock signal (from PMC)
	TC_CMR0_WAVEFORM_MODE_TCCLKS_TIMER_CLOCK2 = 0x1
	// Clock selected: internal MCK/32 clock signal (from PMC)
	TC_CMR0_WAVEFORM_MODE_TCCLKS_TIMER_CLOCK3 = 0x2
	// Clock selected: internal MCK/128 clock signal (from PMC)
	TC_CMR0_WAVEFORM_MODE_TCCLKS_TIMER_CLOCK4 = 0x3
	// Clock selected: internal SLCK clock signal (from PMC)
	TC_CMR0_WAVEFORM_MODE_TCCLKS_TIMER_CLOCK5 = 0x4
	// Clock selected: XC0
	TC_CMR0_WAVEFORM_MODE_TCCLKS_XC0 = 0x5
	// Clock selected: XC1
	TC_CMR0_WAVEFORM_MODE_TCCLKS_XC1 = 0x6
	// Clock selected: XC2
	TC_CMR0_WAVEFORM_MODE_TCCLKS_XC2 = 0x7
	// Position of CLKI field.
	TC_CMR0_WAVEFORM_MODE_CLKI_Pos = 0x3
	// Bit mask of CLKI field.
	TC_CMR0_WAVEFORM_MODE_CLKI_Msk = 0x8
	// Bit CLKI.
	TC_CMR0_WAVEFORM_MODE_CLKI = 0x8
	// Position of BURST field.
	TC_CMR0_WAVEFORM_MODE_BURST_Pos = 0x4
	// Bit mask of BURST field.
	TC_CMR0_WAVEFORM_MODE_BURST_Msk = 0x30
	// The clock is not gated by an external signal.
	TC_CMR0_WAVEFORM_MODE_BURST_NONE = 0x0
	// XC0 is ANDed with the selected clock.
	TC_CMR0_WAVEFORM_MODE_BURST_XC0 = 0x1
	// XC1 is ANDed with the selected clock.
	TC_CMR0_WAVEFORM_MODE_BURST_XC1 = 0x2
	// XC2 is ANDed with the selected clock.
	TC_CMR0_WAVEFORM_MODE_BURST_XC2 = 0x3
	// Position of CPCSTOP field.
	TC_CMR0_WAVEFORM_MODE_CPCSTOP_Pos = 0x6
	// Bit mask of CPCSTOP field.
	TC_CMR0_WAVEFORM_MODE_CPCSTOP_Msk = 0x40
	// Bit CPCSTOP.
	TC_CMR0_WAVEFORM_MODE_CPCSTOP = 0x40
	// Position of CPCDIS field.
	TC_CMR0_WAVEFORM_MODE_CPCDIS_Pos = 0x7
	// Bit mask of CPCDIS field.
	TC_CMR0_WAVEFORM_MODE_CPCDIS_Msk = 0x80
	// Bit CPCDIS.
	TC_CMR0_WAVEFORM_MODE_CPCDIS = 0x80
	// Position of EEVTEDG field.
	TC_CMR0_WAVEFORM_MODE_EEVTEDG_Pos = 0x8
	// Bit mask of EEVTEDG field.
	TC_CMR0_WAVEFORM_MODE_EEVTEDG_Msk = 0x300
	// None
	TC_CMR0_WAVEFORM_MODE_EEVTEDG_NONE = 0x0
	// Rising edge
	TC_CMR0_WAVEFORM_MODE_EEVTEDG_RISING = 0x1
	// Falling edge
	TC_CMR0_WAVEFORM_MODE_EEVTEDG_FALLING = 0x2
	// Each edge
	TC_CMR0_WAVEFORM_MODE_EEVTEDG_EDGE = 0x3
	// Position of EEVT field.
	TC_CMR0_WAVEFORM_MODE_EEVT_Pos = 0xa
	// Bit mask of EEVT field.
	TC_CMR0_WAVEFORM_MODE_EEVT_Msk = 0xc00
	// TIOB
	TC_CMR0_WAVEFORM_MODE_EEVT_TIOB = 0x0
	// XC0
	TC_CMR0_WAVEFORM_MODE_EEVT_XC0 = 0x1
	// XC1
	TC_CMR0_WAVEFORM_MODE_EEVT_XC1 = 0x2
	// XC2
	TC_CMR0_WAVEFORM_MODE_EEVT_XC2 = 0x3
	// Position of ENETRG field.
	TC_CMR0_WAVEFORM_MODE_ENETRG_Pos = 0xc
	// Bit mask of ENETRG field.
	TC_CMR0_WAVEFORM_MODE_ENETRG_Msk = 0x1000
	// Bit ENETRG.
	TC_CMR0_WAVEFORM_MODE_ENETRG = 0x1000
	// Position of WAVSEL field.
	TC_CMR0_WAVEFORM_MODE_WAVSEL_Pos = 0xd
	// Bit mask of WAVSEL field.
	TC_CMR0_WAVEFORM_MODE_WAVSEL_Msk = 0x6000
	// UP mode without automatic trigger on RC Compare
	TC_CMR0_WAVEFORM_MODE_WAVSEL_UP = 0x0
	// UPDOWN mode without automatic trigger on RC Compare
	TC_CMR0_WAVEFORM_MODE_WAVSEL_UPDOWN = 0x1
	// UP mode with automatic trigger on RC Compare
	TC_CMR0_WAVEFORM_MODE_WAVSEL_UP_RC = 0x2
	// UPDOWN mode with automatic trigger on RC Compare
	TC_CMR0_WAVEFORM_MODE_WAVSEL_UPDOWN_RC = 0x3
	// Position of WAVE field.
	TC_CMR0_WAVEFORM_MODE_WAVE_Pos = 0xf
	// Bit mask of WAVE field.
	TC_CMR0_WAVEFORM_MODE_WAVE_Msk = 0x8000
	// Bit WAVE.
	TC_CMR0_WAVEFORM_MODE_WAVE = 0x8000
	// Position of ACPA field.
	TC_CMR0_WAVEFORM_MODE_ACPA_Pos = 0x10
	// Bit mask of ACPA field.
	TC_CMR0_WAVEFORM_MODE_ACPA_Msk = 0x30000
	// None
	TC_CMR0_WAVEFORM_MODE_ACPA_NONE = 0x0
	// Set
	TC_CMR0_WAVEFORM_MODE_ACPA_SET = 0x1
	// Clear
	TC_CMR0_WAVEFORM_MODE_ACPA_CLEAR = 0x2
	// Toggle
	TC_CMR0_WAVEFORM_MODE_ACPA_TOGGLE = 0x3
	// Position of ACPC field.
	TC_CMR0_WAVEFORM_MODE_ACPC_Pos = 0x12
	// Bit mask of ACPC field.
	TC_CMR0_WAVEFORM_MODE_ACPC_Msk = 0xc0000
	// None
	TC_CMR0_WAVEFORM_MODE_ACPC_NONE = 0x0
	// Set
	TC_CMR0_WAVEFORM_MODE_ACPC_SET = 0x1
	// Clear
	TC_CMR0_WAVEFORM_MODE_ACPC_CLEAR = 0x2
	// Toggle
	TC_CMR0_WAVEFORM_MODE_ACPC_TOGGLE = 0x3
	// Position of AEEVT field.
	TC_CMR0_WAVEFORM_MODE_AEEVT_Pos = 0x14
	// Bit mask of AEEVT field.
	TC_CMR0_WAVEFORM_MODE_AEEVT_Msk = 0x300000
	// None
	TC_CMR0_WAVEFORM_MODE_AEEVT_NONE = 0x0
	// Set
	TC_CMR0_WAVEFORM_MODE_AEEVT_SET = 0x1
	// Clear
	TC_CMR0_WAVEFORM_MODE_AEEVT_CLEAR = 0x2
	// Toggle
	TC_CMR0_WAVEFORM_MODE_AEEVT_TOGGLE = 0x3
	// Position of ASWTRG field.
	TC_CMR0_WAVEFORM_MODE_ASWTRG_Pos = 0x16
	// Bit mask of ASWTRG field.
	TC_CMR0_WAVEFORM_MODE_ASWTRG_Msk = 0xc00000
	// None
	TC_CMR0_WAVEFORM_MODE_ASWTRG_NONE = 0x0
	// Set
	TC_CMR0_WAVEFORM_MODE_ASWTRG_SET = 0x1
	// Clear
	TC_CMR0_WAVEFORM_MODE_ASWTRG_CLEAR = 0x2
	// Toggle
	TC_CMR0_WAVEFORM_MODE_ASWTRG_TOGGLE = 0x3
	// Position of BCPB field.
	TC_CMR0_WAVEFORM_MODE_BCPB_Pos = 0x18
	// Bit mask of BCPB field.
	TC_CMR0_WAVEFORM_MODE_BCPB_Msk = 0x3000000
	// None
	TC_CMR0_WAVEFORM_MODE_BCPB_NONE = 0x0
	// Set
	TC_CMR0_WAVEFORM_MODE_BCPB_SET = 0x1
	// Clear
	TC_CMR0_WAVEFORM_MODE_BCPB_CLEAR = 0x2
	// Toggle
	TC_CMR0_WAVEFORM_MODE_BCPB_TOGGLE = 0x3
	// Position of BCPC field.
	TC_CMR0_WAVEFORM_MODE_BCPC_Pos = 0x1a
	// Bit mask of BCPC field.
	TC_CMR0_WAVEFORM_MODE_BCPC_Msk = 0xc000000
	// None
	TC_CMR0_WAVEFORM_MODE_BCPC_NONE = 0x0
	// Set
	TC_CMR0_WAVEFORM_MODE_BCPC_SET = 0x1
	// Clear
	TC_CMR0_WAVEFORM_MODE_BCPC_CLEAR = 0x2
	// Toggle
	TC_CMR0_WAVEFORM_MODE_BCPC_TOGGLE = 0x3
	// Position of BEEVT field.
	TC_CMR0_WAVEFORM_MODE_BEEVT_Pos = 0x1c
	// Bit mask of BEEVT field.
	TC_CMR0_WAVEFORM_MODE_BEEVT_Msk = 0x30000000
	// None
	TC_CMR0_WAVEFORM_MODE_BEEVT_NONE = 0x0
	// Set
	TC_CMR0_WAVEFORM_MODE_BEEVT_SET = 0x1
	// Clear
	TC_CMR0_WAVEFORM_MODE_BEEVT_CLEAR = 0x2
	// Toggle
	TC_CMR0_WAVEFORM_MODE_BEEVT_TOGGLE = 0x3
	// Position of BSWTRG field.
	TC_CMR0_WAVEFORM_MODE_BSWTRG_Pos = 0x1e
	// Bit mask of BSWTRG field.
	TC_CMR0_WAVEFORM_MODE_BSWTRG_Msk = 0xc0000000
	// None
	TC_CMR0_WAVEFORM_MODE_BSWTRG_NONE = 0x0
	// Set
	TC_CMR0_WAVEFORM_MODE_BSWTRG_SET = 0x1
	// Clear
	TC_CMR0_WAVEFORM_MODE_BSWTRG_CLEAR = 0x2
	// Toggle
	TC_CMR0_WAVEFORM_MODE_BSWTRG_TOGGLE = 0x3

	// CV0: Counter Value (channel = 0)
	// Position of CV field.
	TC_CV0_CV_Pos = 0x0
	// Bit mask of CV field.
	TC_CV0_CV_Msk = 0xffffffff

	// RA0: Register A (channel = 0)
	// Position of RA field.
	TC_RA0_RA_Pos = 0x0
	// Bit mask of RA field.
	TC_RA0_RA_Msk = 0xffffffff

	// RB0: Register B (channel = 0)
	// Position of RB field.
	TC_RB0_RB_Pos = 0x0
	// Bit mask of RB field.
	TC_RB0_RB_Msk = 0xffffffff

	// RC0: Register C (channel = 0)
	// Position of RC field.
	TC_RC0_RC_Pos = 0x0
	// Bit mask of RC field.
	TC_RC0_RC_Msk = 0xffffffff

	// SR0: Status Register (channel = 0)
	// Position of COVFS field.
	TC_SR0_COVFS_Pos = 0x0
	// Bit mask of COVFS field.
	TC_SR0_COVFS_Msk = 0x1
	// Bit COVFS.
	TC_SR0_COVFS = 0x1
	// Position of LOVRS field.
	TC_SR0_LOVRS_Pos = 0x1
	// Bit mask of LOVRS field.
	TC_SR0_LOVRS_Msk = 0x2
	// Bit LOVRS.
	TC_SR0_LOVRS = 0x2
	// Position of CPAS field.
	TC_SR0_CPAS_Pos = 0x2
	// Bit mask of CPAS field.
	TC_SR0_CPAS_Msk = 0x4
	// Bit CPAS.
	TC_SR0_CPAS = 0x4
	// Position of CPBS field.
	TC_SR0_CPBS_Pos = 0x3
	// Bit mask of CPBS field.
	TC_SR0_CPBS_Msk = 0x8
	// Bit CPBS.
	TC_SR0_CPBS = 0x8
	// Position of CPCS field.
	TC_SR0_CPCS_Pos = 0x4
	// Bit mask of CPCS field.
	TC_SR0_CPCS_Msk = 0x10
	// Bit CPCS.
	TC_SR0_CPCS = 0x10
	// Position of LDRAS field.
	TC_SR0_LDRAS_Pos = 0x5
	// Bit mask of LDRAS field.
	TC_SR0_LDRAS_Msk = 0x20
	// Bit LDRAS.
	TC_SR0_LDRAS = 0x20
	// Position of LDRBS field.
	TC_SR0_LDRBS_Pos = 0x6
	// Bit mask of LDRBS field.
	TC_SR0_LDRBS_Msk = 0x40
	// Bit LDRBS.
	TC_SR0_LDRBS = 0x40
	// Position of ETRGS field.
	TC_SR0_ETRGS_Pos = 0x7
	// Bit mask of ETRGS field.
	TC_SR0_ETRGS_Msk = 0x80
	// Bit ETRGS.
	TC_SR0_ETRGS = 0x80
	// Position of CLKSTA field.
	TC_SR0_CLKSTA_Pos = 0x10
	// Bit mask of CLKSTA field.
	TC_SR0_CLKSTA_Msk = 0x10000
	// Bit CLKSTA.
	TC_SR0_CLKSTA = 0x10000
	// Position of MTIOA field.
	TC_SR0_MTIOA_Pos = 0x11
	// Bit mask of MTIOA field.
	TC_SR0_MTIOA_Msk = 0x20000
	// Bit MTIOA.
	TC_SR0_MTIOA = 0x20000
	// Position of MTIOB field.
	TC_SR0_MTIOB_Pos = 0x12
	// Bit mask of MTIOB field.
	TC_SR0_MTIOB_Msk = 0x40000
	// Bit MTIOB.
	TC_SR0_MTIOB = 0x40000

	// IER0: Interrupt Enable Register (channel = 0)
	// Position of COVFS field.
	TC_IER0_COVFS_Pos = 0x0
	// Bit mask of COVFS field.
	TC_IER0_COVFS_Msk = 0x1
	// Bit COVFS.
	TC_IER0_COVFS = 0x1
	// Position of LOVRS field.
	TC_IER0_LOVRS_Pos = 0x1
	// Bit mask of LOVRS field.
	TC_IER0_LOVRS_Msk = 0x2
	// Bit LOVRS.
	TC_IER0_LOVRS = 0x2
	// Position of CPAS field.
	TC_IER0_CPAS_Pos = 0x2
	// Bit mask of CPAS field.
	TC_IER0_CPAS_Msk = 0x4
	// Bit CPAS.
	TC_IER0_CPAS = 0x4
	// Position of CPBS field.
	TC_IER0_CPBS_Pos = 0x3
	// Bit mask of CPBS field.
	TC_IER0_CPBS_Msk = 0x8
	// Bit CPBS.
	TC_IER0_CPBS = 0x8
	// Position of CPCS field.
	TC_IER0_CPCS_Pos = 0x4
	// Bit mask of CPCS field.
	TC_IER0_CPCS_Msk = 0x10
	// Bit CPCS.
	TC_IER0_CPCS = 0x10
	// Position of LDRAS field.
	TC_IER0_LDRAS_Pos = 0x5
	// Bit mask of LDRAS field.
	TC_IER0_LDRAS_Msk = 0x20
	// Bit LDRAS.
	TC_IER0_LDRAS = 0x20
	// Position of LDRBS field.
	TC_IER0_LDRBS_Pos = 0x6
	// Bit mask of LDRBS field.
	TC_IER0_LDRBS_Msk = 0x40
	// Bit LDRBS.
	TC_IER0_LDRBS = 0x40
	// Position of ETRGS field.
	TC_IER0_ETRGS_Pos = 0x7
	// Bit mask of ETRGS field.
	TC_IER0_ETRGS_Msk = 0x80
	// Bit ETRGS.
	TC_IER0_ETRGS = 0x80

	// IDR0: Interrupt Disable Register (channel = 0)
	// Position of COVFS field.
	TC_IDR0_COVFS_Pos = 0x0
	// Bit mask of COVFS field.
	TC_IDR0_COVFS_Msk = 0x1
	// Bit COVFS.
	TC_IDR0_COVFS = 0x1
	// Position of LOVRS field.
	TC_IDR0_LOVRS_Pos = 0x1
	// Bit mask of LOVRS field.
	TC_IDR0_LOVRS_Msk = 0x2
	// Bit LOVRS.
	TC_IDR0_LOVRS = 0x2
	// Position of CPAS field.
	TC_IDR0_CPAS_Pos = 0x2
	// Bit mask of CPAS field.
	TC_IDR0_CPAS_Msk = 0x4
	// Bit CPAS.
	TC_IDR0_CPAS = 0x4
	// Position of CPBS field.
	TC_IDR0_CPBS_Pos = 0x3
	// Bit mask of CPBS field.
	TC_IDR0_CPBS_Msk = 0x8
	// Bit CPBS.
	TC_IDR0_CPBS = 0x8
	// Position of CPCS field.
	TC_IDR0_CPCS_Pos = 0x4
	// Bit mask of CPCS field.
	TC_IDR0_CPCS_Msk = 0x10
	// Bit CPCS.
	TC_IDR0_CPCS = 0x10
	// Position of LDRAS field.
	TC_IDR0_LDRAS_Pos = 0x5
	// Bit mask of LDRAS field.
	TC_IDR0_LDRAS_Msk = 0x20
	// Bit LDRAS.
	TC_IDR0_LDRAS = 0x20
	// Position of LDRBS field.
	TC_IDR0_LDRBS_Pos = 0x6
	// Bit mask of LDRBS field.
	TC_IDR0_LDRBS_Msk = 0x40
	// Bit LDRBS.
	TC_IDR0_LDRBS = 0x40
	// Position of ETRGS field.
	TC_IDR0_ETRGS_Pos = 0x7
	// Bit mask of ETRGS field.
	TC_IDR0_ETRGS_Msk = 0x80
	// Bit ETRGS.
	TC_IDR0_ETRGS = 0x80

	// IMR0: Interrupt Mask Register (channel = 0)
	// Position of COVFS field.
	TC_IMR0_COVFS_Pos = 0x0
	// Bit mask of COVFS field.
	TC_IMR0_COVFS_Msk = 0x1
	// Bit COVFS.
	TC_IMR0_COVFS = 0x1
	// Position of LOVRS field.
	TC_IMR0_LOVRS_Pos = 0x1
	// Bit mask of LOVRS field.
	TC_IMR0_LOVRS_Msk = 0x2
	// Bit LOVRS.
	TC_IMR0_LOVRS = 0x2
	// Position of CPAS field.
	TC_IMR0_CPAS_Pos = 0x2
	// Bit mask of CPAS field.
	TC_IMR0_CPAS_Msk = 0x4
	// Bit CPAS.
	TC_IMR0_CPAS = 0x4
	// Position of CPBS field.
	TC_IMR0_CPBS_Pos = 0x3
	// Bit mask of CPBS field.
	TC_IMR0_CPBS_Msk = 0x8
	// Bit CPBS.
	TC_IMR0_CPBS = 0x8
	// Position of CPCS field.
	TC_IMR0_CPCS_Pos = 0x4
	// Bit mask of CPCS field.
	TC_IMR0_CPCS_Msk = 0x10
	// Bit CPCS.
	TC_IMR0_CPCS = 0x10
	// Position of LDRAS field.
	TC_IMR0_LDRAS_Pos = 0x5
	// Bit mask of LDRAS field.
	TC_IMR0_LDRAS_Msk = 0x20
	// Bit LDRAS.
	TC_IMR0_LDRAS = 0x20
	// Position of LDRBS field.
	TC_IMR0_LDRBS_Pos = 0x6
	// Bit mask of LDRBS field.
	TC_IMR0_LDRBS_Msk = 0x40
	// Bit LDRBS.
	TC_IMR0_LDRBS = 0x40
	// Position of ETRGS field.
	TC_IMR0_ETRGS_Pos = 0x7
	// Bit mask of ETRGS field.
	TC_IMR0_ETRGS_Msk = 0x80
	// Bit ETRGS.
	TC_IMR0_ETRGS = 0x80

	// CCR1: Channel Control Register (channel = 1)
	// Position of CLKEN field.
	TC_CCR1_CLKEN_Pos = 0x0
	// Bit mask of CLKEN field.
	TC_CCR1_CLKEN_Msk = 0x1
	// Bit CLKEN.
	TC_CCR1_CLKEN = 0x1
	// Position of CLKDIS field.
	TC_CCR1_CLKDIS_Pos = 0x1
	// Bit mask of CLKDIS field.
	TC_CCR1_CLKDIS_Msk = 0x2
	// Bit CLKDIS.
	TC_CCR1_CLKDIS = 0x2
	// Position of SWTRG field.
	TC_CCR1_SWTRG_Pos = 0x2
	// Bit mask of SWTRG field.
	TC_CCR1_SWTRG_Msk = 0x4
	// Bit SWTRG.
	TC_CCR1_SWTRG = 0x4

	// CMR1: Channel Mode Register (channel = 1)
	// Position of TCCLKS field.
	TC_CMR1_TCCLKS_Pos = 0x0
	// Bit mask of TCCLKS field.
	TC_CMR1_TCCLKS_Msk = 0x7
	// Clock selected: internal MCK/2 clock signal (from PMC)
	TC_CMR1_TCCLKS_TIMER_CLOCK1 = 0x0
	// Clock selected: internal MCK/8 clock signal (from PMC)
	TC_CMR1_TCCLKS_TIMER_CLOCK2 = 0x1
	// Clock selected: internal MCK/32 clock signal (from PMC)
	TC_CMR1_TCCLKS_TIMER_CLOCK3 = 0x2
	// Clock selected: internal MCK/128 clock signal (from PMC)
	TC_CMR1_TCCLKS_TIMER_CLOCK4 = 0x3
	// Clock selected: internal SLCK clock signal (from PMC)
	TC_CMR1_TCCLKS_TIMER_CLOCK5 = 0x4
	// Clock selected: XC0
	TC_CMR1_TCCLKS_XC0 = 0x5
	// Clock selected: XC1
	TC_CMR1_TCCLKS_XC1 = 0x6
	// Clock selected: XC2
	TC_CMR1_TCCLKS_XC2 = 0x7
	// Position of CLKI field.
	TC_CMR1_CLKI_Pos = 0x3
	// Bit mask of CLKI field.
	TC_CMR1_CLKI_Msk = 0x8
	// Bit CLKI.
	TC_CMR1_CLKI = 0x8
	// Position of BURST field.
	TC_CMR1_BURST_Pos = 0x4
	// Bit mask of BURST field.
	TC_CMR1_BURST_Msk = 0x30
	// The clock is not gated by an external signal.
	TC_CMR1_BURST_NONE = 0x0
	// XC0 is ANDed with the selected clock.
	TC_CMR1_BURST_XC0 = 0x1
	// XC1 is ANDed with the selected clock.
	TC_CMR1_BURST_XC1 = 0x2
	// XC2 is ANDed with the selected clock.
	TC_CMR1_BURST_XC2 = 0x3
	// Position of LDBSTOP field.
	TC_CMR1_LDBSTOP_Pos = 0x6
	// Bit mask of LDBSTOP field.
	TC_CMR1_LDBSTOP_Msk = 0x40
	// Bit LDBSTOP.
	TC_CMR1_LDBSTOP = 0x40
	// Position of LDBDIS field.
	TC_CMR1_LDBDIS_Pos = 0x7
	// Bit mask of LDBDIS field.
	TC_CMR1_LDBDIS_Msk = 0x80
	// Bit LDBDIS.
	TC_CMR1_LDBDIS = 0x80
	// Position of ETRGEDG field.
	TC_CMR1_ETRGEDG_Pos = 0x8
	// Bit mask of ETRGEDG field.
	TC_CMR1_ETRGEDG_Msk = 0x300
	// The clock is not gated by an external signal.
	TC_CMR1_ETRGEDG_NONE = 0x0
	// Rising edge
	TC_CMR1_ETRGEDG_RISING = 0x1
	// Falling edge
	TC_CMR1_ETRGEDG_FALLING = 0x2
	// Each edge
	TC_CMR1_ETRGEDG_EDGE = 0x3
	// Position of ABETRG field.
	TC_CMR1_ABETRG_Pos = 0xa
	// Bit mask of ABETRG field.
	TC_CMR1_ABETRG_Msk = 0x400
	// Bit ABETRG.
	TC_CMR1_ABETRG = 0x400
	// Position of CPCTRG field.
	TC_CMR1_CPCTRG_Pos = 0xe
	// Bit mask of CPCTRG field.
	TC_CMR1_CPCTRG_Msk = 0x4000
	// Bit CPCTRG.
	TC_CMR1_CPCTRG = 0x4000
	// Position of WAVE field.
	TC_CMR1_WAVE_Pos = 0xf
	// Bit mask of WAVE field.
	TC_CMR1_WAVE_Msk = 0x8000
	// Bit WAVE.
	TC_CMR1_WAVE = 0x8000
	// Position of LDRA field.
	TC_CMR1_LDRA_Pos = 0x10
	// Bit mask of LDRA field.
	TC_CMR1_LDRA_Msk = 0x30000
	// None
	TC_CMR1_LDRA_NONE = 0x0
	// Rising edge of TIOA
	TC_CMR1_LDRA_RISING = 0x1
	// Falling edge of TIOA
	TC_CMR1_LDRA_FALLING = 0x2
	// Each edge of TIOA
	TC_CMR1_LDRA_EDGE = 0x3
	// Position of LDRB field.
	TC_CMR1_LDRB_Pos = 0x12
	// Bit mask of LDRB field.
	TC_CMR1_LDRB_Msk = 0xc0000
	// None
	TC_CMR1_LDRB_NONE = 0x0
	// Rising edge of TIOA
	TC_CMR1_LDRB_RISING = 0x1
	// Falling edge of TIOA
	TC_CMR1_LDRB_FALLING = 0x2
	// Each edge of TIOA
	TC_CMR1_LDRB_EDGE = 0x3

	// CMR1_WAVEFORM_MODE: Channel Mode Register (channel = 1)
	// Position of TCCLKS field.
	TC_CMR1_WAVEFORM_MODE_TCCLKS_Pos = 0x0
	// Bit mask of TCCLKS field.
	TC_CMR1_WAVEFORM_MODE_TCCLKS_Msk = 0x7
	// Clock selected: internal MCK/2 clock signal (from PMC)
	TC_CMR1_WAVEFORM_MODE_TCCLKS_TIMER_CLOCK1 = 0x0
	// Clock selected: internal MCK/8 clock signal (from PMC)
	TC_CMR1_WAVEFORM_MODE_TCCLKS_TIMER_CLOCK2 = 0x1
	// Clock selected: internal MCK/32 clock signal (from PMC)
	TC_CMR1_WAVEFORM_MODE_TCCLKS_TIMER_CLOCK3 = 0x2
	// Clock selected: internal MCK/128 clock signal (from PMC)
	TC_CMR1_WAVEFORM_MODE_TCCLKS_TIMER_CLOCK4 = 0x3
	// Clock selected: internal SLCK clock signal (from PMC)
	TC_CMR1_WAVEFORM_MODE_TCCLKS_TIMER_CLOCK5 = 0x4
	// Clock selected: XC0
	TC_CMR1_WAVEFORM_MODE_TCCLKS_XC0 = 0x5
	// Clock selected: XC1
	TC_CMR1_WAVEFORM_MODE_TCCLKS_XC1 = 0x6
	// Clock selected: XC2
	TC_CMR1_WAVEFORM_MODE_TCCLKS_XC2 = 0x7
	// Position of CLKI field.
	TC_CMR1_WAVEFORM_MODE_CLKI_Pos = 0x3
	// Bit mask of CLKI field.
	TC_CMR1_WAVEFORM_MODE_CLKI_Msk = 0x8
	// Bit CLKI.
	TC_CMR1_WAVEFORM_MODE_CLKI = 0x8
	// Position of BURST field.
	TC_CMR1_WAVEFORM_MODE_BURST_Pos = 0x4
	// Bit mask of BURST field.
	TC_CMR1_WAVEFORM_MODE_BURST_Msk = 0x30
	// The clock is not gated by an external signal.
	TC_CMR1_WAVEFORM_MODE_BURST_NONE = 0x0
	// XC0 is ANDed with the selected clock.
	TC_CMR1_WAVEFORM_MODE_BURST_XC0 = 0x1
	// XC1 is ANDed with the selected clock.
	TC_CMR1_WAVEFORM_MODE_BURST_XC1 = 0x2
	// XC2 is ANDed with the selected clock.
	TC_CMR1_WAVEFORM_MODE_BURST_XC2 = 0x3
	// Position of CPCSTOP field.
	TC_CMR1_WAVEFORM_MODE_CPCSTOP_Pos = 0x6
	// Bit mask of CPCSTOP field.
	TC_CMR1_WAVEFORM_MODE_CPCSTOP_Msk = 0x40
	// Bit CPCSTOP.
	TC_CMR1_WAVEFORM_MODE_CPCSTOP = 0x40
	// Position of CPCDIS field.
	TC_CMR1_WAVEFORM_MODE_CPCDIS_Pos = 0x7
	// Bit mask of CPCDIS field.
	TC_CMR1_WAVEFORM_MODE_CPCDIS_Msk = 0x80
	// Bit CPCDIS.
	TC_CMR1_WAVEFORM_MODE_CPCDIS = 0x80
	// Position of EEVTEDG field.
	TC_CMR1_WAVEFORM_MODE_EEVTEDG_Pos = 0x8
	// Bit mask of EEVTEDG field.
	TC_CMR1_WAVEFORM_MODE_EEVTEDG_Msk = 0x300
	// None
	TC_CMR1_WAVEFORM_MODE_EEVTEDG_NONE = 0x0
	// Rising edge
	TC_CMR1_WAVEFORM_MODE_EEVTEDG_RISING = 0x1
	// Falling edge
	TC_CMR1_WAVEFORM_MODE_EEVTEDG_FALLING = 0x2
	// Each edge
	TC_CMR1_WAVEFORM_MODE_EEVTEDG_EDGE = 0x3
	// Position of EEVT field.
	TC_CMR1_WAVEFORM_MODE_EEVT_Pos = 0xa
	// Bit mask of EEVT field.
	TC_CMR1_WAVEFORM_MODE_EEVT_Msk = 0xc00
	// TIOB
	TC_CMR1_WAVEFORM_MODE_EEVT_TIOB = 0x0
	// XC0
	TC_CMR1_WAVEFORM_MODE_EEVT_XC0 = 0x1
	// XC1
	TC_CMR1_WAVEFORM_MODE_EEVT_XC1 = 0x2
	// XC2
	TC_CMR1_WAVEFORM_MODE_EEVT_XC2 = 0x3
	// Position of ENETRG field.
	TC_CMR1_WAVEFORM_MODE_ENETRG_Pos = 0xc
	// Bit mask of ENETRG field.
	TC_CMR1_WAVEFORM_MODE_ENETRG_Msk = 0x1000
	// Bit ENETRG.
	TC_CMR1_WAVEFORM_MODE_ENETRG = 0x1000
	// Position of WAVSEL field.
	TC_CMR1_WAVEFORM_MODE_WAVSEL_Pos = 0xd
	// Bit mask of WAVSEL field.
	TC_CMR1_WAVEFORM_MODE_WAVSEL_Msk = 0x6000
	// UP mode without automatic trigger on RC Compare
	TC_CMR1_WAVEFORM_MODE_WAVSEL_UP = 0x0
	// UPDOWN mode without automatic trigger on RC Compare
	TC_CMR1_WAVEFORM_MODE_WAVSEL_UPDOWN = 0x1
	// UP mode with automatic trigger on RC Compare
	TC_CMR1_WAVEFORM_MODE_WAVSEL_UP_RC = 0x2
	// UPDOWN mode with automatic trigger on RC Compare
	TC_CMR1_WAVEFORM_MODE_WAVSEL_UPDOWN_RC = 0x3
	// Position of WAVE field.
	TC_CMR1_WAVEFORM_MODE_WAVE_Pos = 0xf
	// Bit mask of WAVE field.
	TC_CMR1_WAVEFORM_MODE_WAVE_Msk = 0x8000
	// Bit WAVE.
	TC_CMR1_WAVEFORM_MODE_WAVE = 0x8000
	// Position of ACPA field.
	TC_CMR1_WAVEFORM_MODE_ACPA_Pos = 0x10
	// Bit mask of ACPA field.
	TC_CMR1_WAVEFORM_MODE_ACPA_Msk = 0x30000
	// None
	TC_CMR1_WAVEFORM_MODE_ACPA_NONE = 0x0
	// Set
	TC_CMR1_WAVEFORM_MODE_ACPA_SET = 0x1
	// Clear
	TC_CMR1_WAVEFORM_MODE_ACPA_CLEAR = 0x2
	// Toggle
	TC_CMR1_WAVEFORM_MODE_ACPA_TOGGLE = 0x3
	// Position of ACPC field.
	TC_CMR1_WAVEFORM_MODE_ACPC_Pos = 0x12
	// Bit mask of ACPC field.
	TC_CMR1_WAVEFORM_MODE_ACPC_Msk = 0xc0000
	// None
	TC_CMR1_WAVEFORM_MODE_ACPC_NONE = 0x0
	// Set
	TC_CMR1_WAVEFORM_MODE_ACPC_SET = 0x1
	// Clear
	TC_CMR1_WAVEFORM_MODE_ACPC_CLEAR = 0x2
	// Toggle
	TC_CMR1_WAVEFORM_MODE_ACPC_TOGGLE = 0x3
	// Position of AEEVT field.
	TC_CMR1_WAVEFORM_MODE_AEEVT_Pos = 0x14
	// Bit mask of AEEVT field.
	TC_CMR1_WAVEFORM_MODE_AEEVT_Msk = 0x300000
	// None
	TC_CMR1_WAVEFORM_MODE_AEEVT_NONE = 0x0
	// Set
	TC_CMR1_WAVEFORM_MODE_AEEVT_SET = 0x1
	// Clear
	TC_CMR1_WAVEFORM_MODE_AEEVT_CLEAR = 0x2
	// Toggle
	TC_CMR1_WAVEFORM_MODE_AEEVT_TOGGLE = 0x3
	// Position of ASWTRG field.
	TC_CMR1_WAVEFORM_MODE_ASWTRG_Pos = 0x16
	// Bit mask of ASWTRG field.
	TC_CMR1_WAVEFORM_MODE_ASWTRG_Msk = 0xc00000
	// None
	TC_CMR1_WAVEFORM_MODE_ASWTRG_NONE = 0x0
	// Set
	TC_CMR1_WAVEFORM_MODE_ASWTRG_SET = 0x1
	// Clear
	TC_CMR1_WAVEFORM_MODE_ASWTRG_CLEAR = 0x2
	// Toggle
	TC_CMR1_WAVEFORM_MODE_ASWTRG_TOGGLE = 0x3
	// Position of BCPB field.
	TC_CMR1_WAVEFORM_MODE_BCPB_Pos = 0x18
	// Bit mask of BCPB field.
	TC_CMR1_WAVEFORM_MODE_BCPB_Msk = 0x3000000
	// None
	TC_CMR1_WAVEFORM_MODE_BCPB_NONE = 0x0
	// Set
	TC_CMR1_WAVEFORM_MODE_BCPB_SET = 0x1
	// Clear
	TC_CMR1_WAVEFORM_MODE_BCPB_CLEAR = 0x2
	// Toggle
	TC_CMR1_WAVEFORM_MODE_BCPB_TOGGLE = 0x3
	// Position of BCPC field.
	TC_CMR1_WAVEFORM_MODE_BCPC_Pos = 0x1a
	// Bit mask of BCPC field.
	TC_CMR1_WAVEFORM_MODE_BCPC_Msk = 0xc000000
	// None
	TC_CMR1_WAVEFORM_MODE_BCPC_NONE = 0x0
	// Set
	TC_CMR1_WAVEFORM_MODE_BCPC_SET = 0x1
	// Clear
	TC_CMR1_WAVEFORM_MODE_BCPC_CLEAR = 0x2
	// Toggle
	TC_CMR1_WAVEFORM_MODE_BCPC_TOGGLE = 0x3
	// Position of BEEVT field.
	TC_CMR1_WAVEFORM_MODE_BEEVT_Pos = 0x1c
	// Bit mask of BEEVT field.
	TC_CMR1_WAVEFORM_MODE_BEEVT_Msk = 0x30000000
	// None
	TC_CMR1_WAVEFORM_MODE_BEEVT_NONE = 0x0
	// Set
	TC_CMR1_WAVEFORM_MODE_BEEVT_SET = 0x1
	// Clear
	TC_CMR1_WAVEFORM_MODE_BEEVT_CLEAR = 0x2
	// Toggle
	TC_CMR1_WAVEFORM_MODE_BEEVT_TOGGLE = 0x3
	// Position of BSWTRG field.
	TC_CMR1_WAVEFORM_MODE_BSWTRG_Pos = 0x1e
	// Bit mask of BSWTRG field.
	TC_CMR1_WAVEFORM_MODE_BSWTRG_Msk = 0xc0000000
	// None
	TC_CMR1_WAVEFORM_MODE_BSWTRG_NONE = 0x0
	// Set
	TC_CMR1_WAVEFORM_MODE_BSWTRG_SET = 0x1
	// Clear
	TC_CMR1_WAVEFORM_MODE_BSWTRG_CLEAR = 0x2
	// Toggle
	TC_CMR1_WAVEFORM_MODE_BSWTRG_TOGGLE = 0x3

	// CV1: Counter Value (channel = 1)
	// Position of CV field.
	TC_CV1_CV_Pos = 0x0
	// Bit mask of CV field.
	TC_CV1_CV_Msk = 0xffffffff

	// RA1: Register A (channel = 1)
	// Position of RA field.
	TC_RA1_RA_Pos = 0x0
	// Bit mask of RA field.
	TC_RA1_RA_Msk = 0xffffffff

	// RB1: Register B (channel = 1)
	// Position of RB field.
	TC_RB1_RB_Pos = 0x0
	// Bit mask of RB field.
	TC_RB1_RB_Msk = 0xffffffff

	// RC1: Register C (channel = 1)
	// Position of RC field.
	TC_RC1_RC_Pos = 0x0
	// Bit mask of RC field.
	TC_RC1_RC_Msk = 0xffffffff

	// SR1: Status Register (channel = 1)
	// Position of COVFS field.
	TC_SR1_COVFS_Pos = 0x0
	// Bit mask of COVFS field.
	TC_SR1_COVFS_Msk = 0x1
	// Bit COVFS.
	TC_SR1_COVFS = 0x1
	// Position of LOVRS field.
	TC_SR1_LOVRS_Pos = 0x1
	// Bit mask of LOVRS field.
	TC_SR1_LOVRS_Msk = 0x2
	// Bit LOVRS.
	TC_SR1_LOVRS = 0x2
	// Position of CPAS field.
	TC_SR1_CPAS_Pos = 0x2
	// Bit mask of CPAS field.
	TC_SR1_CPAS_Msk = 0x4
	// Bit CPAS.
	TC_SR1_CPAS = 0x4
	// Position of CPBS field.
	TC_SR1_CPBS_Pos = 0x3
	// Bit mask of CPBS field.
	TC_SR1_CPBS_Msk = 0x8
	// Bit CPBS.
	TC_SR1_CPBS = 0x8
	// Position of CPCS field.
	TC_SR1_CPCS_Pos = 0x4
	// Bit mask of CPCS field.
	TC_SR1_CPCS_Msk = 0x10
	// Bit CPCS.
	TC_SR1_CPCS = 0x10
	// Position of LDRAS field.
	TC_SR1_LDRAS_Pos = 0x5
	// Bit mask of LDRAS field.
	TC_SR1_LDRAS_Msk = 0x20
	// Bit LDRAS.
	TC_SR1_LDRAS = 0x20
	// Position of LDRBS field.
	TC_SR1_LDRBS_Pos = 0x6
	// Bit mask of LDRBS field.
	TC_SR1_LDRBS_Msk = 0x40
	// Bit LDRBS.
	TC_SR1_LDRBS = 0x40
	// Position of ETRGS field.
	TC_SR1_ETRGS_Pos = 0x7
	// Bit mask of ETRGS field.
	TC_SR1_ETRGS_Msk = 0x80
	// Bit ETRGS.
	TC_SR1_ETRGS = 0x80
	// Position of CLKSTA field.
	TC_SR1_CLKSTA_Pos = 0x10
	// Bit mask of CLKSTA field.
	TC_SR1_CLKSTA_Msk = 0x10000
	// Bit CLKSTA.
	TC_SR1_CLKSTA = 0x10000
	// Position of MTIOA field.
	TC_SR1_MTIOA_Pos = 0x11
	// Bit mask of MTIOA field.
	TC_SR1_MTIOA_Msk = 0x20000
	// Bit MTIOA.
	TC_SR1_MTIOA = 0x20000
	// Position of MTIOB field.
	TC_SR1_MTIOB_Pos = 0x12
	// Bit mask of MTIOB field.
	TC_SR1_MTIOB_Msk = 0x40000
	// Bit MTIOB.
	TC_SR1_MTIOB = 0x40000

	// IER1: Interrupt Enable Register (channel = 1)
	// Position of COVFS field.
	TC_IER1_COVFS_Pos = 0x0
	// Bit mask of COVFS field.
	TC_IER1_COVFS_Msk = 0x1
	// Bit COVFS.
	TC_IER1_COVFS = 0x1
	// Position of LOVRS field.
	TC_IER1_LOVRS_Pos = 0x1
	// Bit mask of LOVRS field.
	TC_IER1_LOVRS_Msk = 0x2
	// Bit LOVRS.
	TC_IER1_LOVRS = 0x2
	// Position of CPAS field.
	TC_IER1_CPAS_Pos = 0x2
	// Bit mask of CPAS field.
	TC_IER1_CPAS_Msk = 0x4
	// Bit CPAS.
	TC_IER1_CPAS = 0x4
	// Position of CPBS field.
	TC_IER1_CPBS_Pos = 0x3
	// Bit mask of CPBS field.
	TC_IER1_CPBS_Msk = 0x8
	// Bit CPBS.
	TC_IER1_CPBS = 0x8
	// Position of CPCS field.
	TC_IER1_CPCS_Pos = 0x4
	// Bit mask of CPCS field.
	TC_IER1_CPCS_Msk = 0x10
	// Bit CPCS.
	TC_IER1_CPCS = 0x10
	// Position of LDRAS field.
	TC_IER1_LDRAS_Pos = 0x5
	// Bit mask of LDRAS field.
	TC_IER1_LDRAS_Msk = 0x20
	// Bit LDRAS.
	TC_IER1_LDRAS = 0x20
	// Position of LDRBS field.
	TC_IER1_LDRBS_Pos = 0x6
	// Bit mask of LDRBS field.
	TC_IER1_LDRBS_Msk = 0x40
	// Bit LDRBS.
	TC_IER1_LDRBS = 0x40
	// Position of ETRGS field.
	TC_IER1_ETRGS_Pos = 0x7
	// Bit mask of ETRGS field.
	TC_IER1_ETRGS_Msk = 0x80
	// Bit ETRGS.
	TC_IER1_ETRGS = 0x80

	// IDR1: Interrupt Disable Register (channel = 1)
	// Position of COVFS field.
	TC_IDR1_COVFS_Pos = 0x0
	// Bit mask of COVFS field.
	TC_IDR1_COVFS_Msk = 0x1
	// Bit COVFS.
	TC_IDR1_COVFS = 0x1
	// Position of LOVRS field.
	TC_IDR1_LOVRS_Pos = 0x1
	// Bit mask of LOVRS field.
	TC_IDR1_LOVRS_Msk = 0x2
	// Bit LOVRS.
	TC_IDR1_LOVRS = 0x2
	// Position of CPAS field.
	TC_IDR1_CPAS_Pos = 0x2
	// Bit mask of CPAS field.
	TC_IDR1_CPAS_Msk = 0x4
	// Bit CPAS.
	TC_IDR1_CPAS = 0x4
	// Position of CPBS field.
	TC_IDR1_CPBS_Pos = 0x3
	// Bit mask of CPBS field.
	TC_IDR1_CPBS_Msk = 0x8
	// Bit CPBS.
	TC_IDR1_CPBS = 0x8
	// Position of CPCS field.
	TC_IDR1_CPCS_Pos = 0x4
	// Bit mask of CPCS field.
	TC_IDR1_CPCS_Msk = 0x10
	// Bit CPCS.
	TC_IDR1_CPCS = 0x10
	// Position of LDRAS field.
	TC_IDR1_LDRAS_Pos = 0x5
	// Bit mask of LDRAS field.
	TC_IDR1_LDRAS_Msk = 0x20
	// Bit LDRAS.
	TC_IDR1_LDRAS = 0x20
	// Position of LDRBS field.
	TC_IDR1_LDRBS_Pos = 0x6
	// Bit mask of LDRBS field.
	TC_IDR1_LDRBS_Msk = 0x40
	// Bit LDRBS.
	TC_IDR1_LDRBS = 0x40
	// Position of ETRGS field.
	TC_IDR1_ETRGS_Pos = 0x7
	// Bit mask of ETRGS field.
	TC_IDR1_ETRGS_Msk = 0x80
	// Bit ETRGS.
	TC_IDR1_ETRGS = 0x80

	// IMR1: Interrupt Mask Register (channel = 1)
	// Position of COVFS field.
	TC_IMR1_COVFS_Pos = 0x0
	// Bit mask of COVFS field.
	TC_IMR1_COVFS_Msk = 0x1
	// Bit COVFS.
	TC_IMR1_COVFS = 0x1
	// Position of LOVRS field.
	TC_IMR1_LOVRS_Pos = 0x1
	// Bit mask of LOVRS field.
	TC_IMR1_LOVRS_Msk = 0x2
	// Bit LOVRS.
	TC_IMR1_LOVRS = 0x2
	// Position of CPAS field.
	TC_IMR1_CPAS_Pos = 0x2
	// Bit mask of CPAS field.
	TC_IMR1_CPAS_Msk = 0x4
	// Bit CPAS.
	TC_IMR1_CPAS = 0x4
	// Position of CPBS field.
	TC_IMR1_CPBS_Pos = 0x3
	// Bit mask of CPBS field.
	TC_IMR1_CPBS_Msk = 0x8
	// Bit CPBS.
	TC_IMR1_CPBS = 0x8
	// Position of CPCS field.
	TC_IMR1_CPCS_Pos = 0x4
	// Bit mask of CPCS field.
	TC_IMR1_CPCS_Msk = 0x10
	// Bit CPCS.
	TC_IMR1_CPCS = 0x10
	// Position of LDRAS field.
	TC_IMR1_LDRAS_Pos = 0x5
	// Bit mask of LDRAS field.
	TC_IMR1_LDRAS_Msk = 0x20
	// Bit LDRAS.
	TC_IMR1_LDRAS = 0x20
	// Position of LDRBS field.
	TC_IMR1_LDRBS_Pos = 0x6
	// Bit mask of LDRBS field.
	TC_IMR1_LDRBS_Msk = 0x40
	// Bit LDRBS.
	TC_IMR1_LDRBS = 0x40
	// Position of ETRGS field.
	TC_IMR1_ETRGS_Pos = 0x7
	// Bit mask of ETRGS field.
	TC_IMR1_ETRGS_Msk = 0x80
	// Bit ETRGS.
	TC_IMR1_ETRGS = 0x80

	// CCR2: Channel Control Register (channel = 2)
	// Position of CLKEN field.
	TC_CCR2_CLKEN_Pos = 0x0
	// Bit mask of CLKEN field.
	TC_CCR2_CLKEN_Msk = 0x1
	// Bit CLKEN.
	TC_CCR2_CLKEN = 0x1
	// Position of CLKDIS field.
	TC_CCR2_CLKDIS_Pos = 0x1
	// Bit mask of CLKDIS field.
	TC_CCR2_CLKDIS_Msk = 0x2
	// Bit CLKDIS.
	TC_CCR2_CLKDIS = 0x2
	// Position of SWTRG field.
	TC_CCR2_SWTRG_Pos = 0x2
	// Bit mask of SWTRG field.
	TC_CCR2_SWTRG_Msk = 0x4
	// Bit SWTRG.
	TC_CCR2_SWTRG = 0x4

	// CMR2: Channel Mode Register (channel = 2)
	// Position of TCCLKS field.
	TC_CMR2_TCCLKS_Pos = 0x0
	// Bit mask of TCCLKS field.
	TC_CMR2_TCCLKS_Msk = 0x7
	// Clock selected: internal MCK/2 clock signal (from PMC)
	TC_CMR2_TCCLKS_TIMER_CLOCK1 = 0x0
	// Clock selected: internal MCK/8 clock signal (from PMC)
	TC_CMR2_TCCLKS_TIMER_CLOCK2 = 0x1
	// Clock selected: internal MCK/32 clock signal (from PMC)
	TC_CMR2_TCCLKS_TIMER_CLOCK3 = 0x2
	// Clock selected: internal MCK/128 clock signal (from PMC)
	TC_CMR2_TCCLKS_TIMER_CLOCK4 = 0x3
	// Clock selected: internal SLCK clock signal (from PMC)
	TC_CMR2_TCCLKS_TIMER_CLOCK5 = 0x4
	// Clock selected: XC0
	TC_CMR2_TCCLKS_XC0 = 0x5
	// Clock selected: XC1
	TC_CMR2_TCCLKS_XC1 = 0x6
	// Clock selected: XC2
	TC_CMR2_TCCLKS_XC2 = 0x7
	// Position of CLKI field.
	TC_CMR2_CLKI_Pos = 0x3
	// Bit mask of CLKI field.
	TC_CMR2_CLKI_Msk = 0x8
	// Bit CLKI.
	TC_CMR2_CLKI = 0x8
	// Position of BURST field.
	TC_CMR2_BURST_Pos = 0x4
	// Bit mask of BURST field.
	TC_CMR2_BURST_Msk = 0x30
	// The clock is not gated by an external signal.
	TC_CMR2_BURST_NONE = 0x0
	// XC0 is ANDed with the selected clock.
	TC_CMR2_BURST_XC0 = 0x1
	// XC1 is ANDed with the selected clock.
	TC_CMR2_BURST_XC1 = 0x2
	// XC2 is ANDed with the selected clock.
	TC_CMR2_BURST_XC2 = 0x3
	// Position of LDBSTOP field.
	TC_CMR2_LDBSTOP_Pos = 0x6
	// Bit mask of LDBSTOP field.
	TC_CMR2_LDBSTOP_Msk = 0x40
	// Bit LDBSTOP.
	TC_CMR2_LDBSTOP = 0x40
	// Position of LDBDIS field.
	TC_CMR2_LDBDIS_Pos = 0x7
	// Bit mask of LDBDIS field.
	TC_CMR2_LDBDIS_Msk = 0x80
	// Bit LDBDIS.
	TC_CMR2_LDBDIS = 0x80
	// Position of ETRGEDG field.
	TC_CMR2_ETRGEDG_Pos = 0x8
	// Bit mask of ETRGEDG field.
	TC_CMR2_ETRGEDG_Msk = 0x300
	// The clock is not gated by an external signal.
	TC_CMR2_ETRGEDG_NONE = 0x0
	// Rising edge
	TC_CMR2_ETRGEDG_RISING = 0x1
	// Falling edge
	TC_CMR2_ETRGEDG_FALLING = 0x2
	// Each edge
	TC_CMR2_ETRGEDG_EDGE = 0x3
	// Position of ABETRG field.
	TC_CMR2_ABETRG_Pos = 0xa
	// Bit mask of ABETRG field.
	TC_CMR2_ABETRG_Msk = 0x400
	// Bit ABETRG.
	TC_CMR2_ABETRG = 0x400
	// Position of CPCTRG field.
	TC_CMR2_CPCTRG_Pos = 0xe
	// Bit mask of CPCTRG field.
	TC_CMR2_CPCTRG_Msk = 0x4000
	// Bit CPCTRG.
	TC_CMR2_CPCTRG = 0x4000
	// Position of WAVE field.
	TC_CMR2_WAVE_Pos = 0xf
	// Bit mask of WAVE field.
	TC_CMR2_WAVE_Msk = 0x8000
	// Bit WAVE.
	TC_CMR2_WAVE = 0x8000
	// Position of LDRA field.
	TC_CMR2_LDRA_Pos = 0x10
	// Bit mask of LDRA field.
	TC_CMR2_LDRA_Msk = 0x30000
	// None
	TC_CMR2_LDRA_NONE = 0x0
	// Rising edge of TIOA
	TC_CMR2_LDRA_RISING = 0x1
	// Falling edge of TIOA
	TC_CMR2_LDRA_FALLING = 0x2
	// Each edge of TIOA
	TC_CMR2_LDRA_EDGE = 0x3
	// Position of LDRB field.
	TC_CMR2_LDRB_Pos = 0x12
	// Bit mask of LDRB field.
	TC_CMR2_LDRB_Msk = 0xc0000
	// None
	TC_CMR2_LDRB_NONE = 0x0
	// Rising edge of TIOA
	TC_CMR2_LDRB_RISING = 0x1
	// Falling edge of TIOA
	TC_CMR2_LDRB_FALLING = 0x2
	// Each edge of TIOA
	TC_CMR2_LDRB_EDGE = 0x3

	// CMR2_WAVEFORM_MODE: Channel Mode Register (channel = 2)
	// Position of TCCLKS field.
	TC_CMR2_WAVEFORM_MODE_TCCLKS_Pos = 0x0
	// Bit mask of TCCLKS field.
	TC_CMR2_WAVEFORM_MODE_TCCLKS_Msk = 0x7
	// Clock selected: internal MCK/2 clock signal (from PMC)
	TC_CMR2_WAVEFORM_MODE_TCCLKS_TIMER_CLOCK1 = 0x0
	// Clock selected: internal MCK/8 clock signal (from PMC)
	TC_CMR2_WAVEFORM_MODE_TCCLKS_TIMER_CLOCK2 = 0x1
	// Clock selected: internal MCK/32 clock signal (from PMC)
	TC_CMR2_WAVEFORM_MODE_TCCLKS_TIMER_CLOCK3 = 0x2
	// Clock selected: internal MCK/128 clock signal (from PMC)
	TC_CMR2_WAVEFORM_MODE_TCCLKS_TIMER_CLOCK4 = 0x3
	// Clock selected: internal SLCK clock signal (from PMC)
	TC_CMR2_WAVEFORM_MODE_TCCLKS_TIMER_CLOCK5 = 0x4
	// Clock selected: XC0
	TC_CMR2_WAVEFORM_MODE_TCCLKS_XC0 = 0x5
	// Clock selected: XC1
	TC_CMR2_WAVEFORM_MODE_TCCLKS_XC1 = 0x6
	// Clock selected: XC2
	TC_CMR2_WAVEFORM_MODE_TCCLKS_XC2 = 0x7
	// Position of CLKI field.
	TC_CMR2_WAVEFORM_MODE_CLKI_Pos = 0x3
	// Bit mask of CLKI field.
	TC_CMR2_WAVEFORM_MODE_CLKI_Msk = 0x8
	// Bit CLKI.
	TC_CMR2_WAVEFORM_MODE_CLKI = 0x8
	// Position of BURST field.
	TC_CMR2_WAVEFORM_MODE_BURST_Pos = 0x4
	// Bit mask of BURST field.
	TC_CMR2_WAVEFORM_MODE_BURST_Msk = 0x30
	// The clock is not gated by an external signal.
	TC_CMR2_WAVEFORM_MODE_BURST_NONE = 0x0
	// XC0 is ANDed with the selected clock.
	TC_CMR2_WAVEFORM_MODE_BURST_XC0 = 0x1
	// XC1 is ANDed with the selected clock.
	TC_CMR2_WAVEFORM_MODE_BURST_XC1 = 0x2
	// XC2 is ANDed with the selected clock.
	TC_CMR2_WAVEFORM_MODE_BURST_XC2 = 0x3
	// Position of CPCSTOP field.
	TC_CMR2_WAVEFORM_MODE_CPCSTOP_Pos = 0x6
	// Bit mask of CPCSTOP field.
	TC_CMR2_WAVEFORM_MODE_CPCSTOP_Msk = 0x40
	// Bit CPCSTOP.
	TC_CMR2_WAVEFORM_MODE_CPCSTOP = 0x40
	// Position of CPCDIS field.
	TC_CMR2_WAVEFORM_MODE_CPCDIS_Pos = 0x7
	// Bit mask of CPCDIS field.
	TC_CMR2_WAVEFORM_MODE_CPCDIS_Msk = 0x80
	// Bit CPCDIS.
	TC_CMR2_WAVEFORM_MODE_CPCDIS = 0x80
	// Position of EEVTEDG field.
	TC_CMR2_WAVEFORM_MODE_EEVTEDG_Pos = 0x8
	// Bit mask of EEVTEDG field.
	TC_CMR2_WAVEFORM_MODE_EEVTEDG_Msk = 0x300
	// None
	TC_CMR2_WAVEFORM_MODE_EEVTEDG_NONE = 0x0
	// Rising edge
	TC_CMR2_WAVEFORM_MODE_EEVTEDG_RISING = 0x1
	// Falling edge
	TC_CMR2_WAVEFORM_MODE_EEVTEDG_FALLING = 0x2
	// Each edge
	TC_CMR2_WAVEFORM_MODE_EEVTEDG_EDGE = 0x3
	// Position of EEVT field.
	TC_CMR2_WAVEFORM_MODE_EEVT_Pos = 0xa
	// Bit mask of EEVT field.
	TC_CMR2_WAVEFORM_MODE_EEVT_Msk = 0xc00
	// TIOB
	TC_CMR2_WAVEFORM_MODE_EEVT_TIOB = 0x0
	// XC0
	TC_CMR2_WAVEFORM_MODE_EEVT_XC0 = 0x1
	// XC1
	TC_CMR2_WAVEFORM_MODE_EEVT_XC1 = 0x2
	// XC2
	TC_CMR2_WAVEFORM_MODE_EEVT_XC2 = 0x3
	// Position of ENETRG field.
	TC_CMR2_WAVEFORM_MODE_ENETRG_Pos = 0xc
	// Bit mask of ENETRG field.
	TC_CMR2_WAVEFORM_MODE_ENETRG_Msk = 0x1000
	// Bit ENETRG.
	TC_CMR2_WAVEFORM_MODE_ENETRG = 0x1000
	// Position of WAVSEL field.
	TC_CMR2_WAVEFORM_MODE_WAVSEL_Pos = 0xd
	// Bit mask of WAVSEL field.
	TC_CMR2_WAVEFORM_MODE_WAVSEL_Msk = 0x6000
	// UP mode without automatic trigger on RC Compare
	TC_CMR2_WAVEFORM_MODE_WAVSEL_UP = 0x0
	// UPDOWN mode without automatic trigger on RC Compare
	TC_CMR2_WAVEFORM_MODE_WAVSEL_UPDOWN = 0x1
	// UP mode with automatic trigger on RC Compare
	TC_CMR2_WAVEFORM_MODE_WAVSEL_UP_RC = 0x2
	// UPDOWN mode with automatic trigger on RC Compare
	TC_CMR2_WAVEFORM_MODE_WAVSEL_UPDOWN_RC = 0x3
	// Position of WAVE field.
	TC_CMR2_WAVEFORM_MODE_WAVE_Pos = 0xf
	// Bit mask of WAVE field.
	TC_CMR2_WAVEFORM_MODE_WAVE_Msk = 0x8000
	// Bit WAVE.
	TC_CMR2_WAVEFORM_MODE_WAVE = 0x8000
	// Position of ACPA field.
	TC_CMR2_WAVEFORM_MODE_ACPA_Pos = 0x10
	// Bit mask of ACPA field.
	TC_CMR2_WAVEFORM_MODE_ACPA_Msk = 0x30000
	// None
	TC_CMR2_WAVEFORM_MODE_ACPA_NONE = 0x0
	// Set
	TC_CMR2_WAVEFORM_MODE_ACPA_SET = 0x1
	// Clear
	TC_CMR2_WAVEFORM_MODE_ACPA_CLEAR = 0x2
	// Toggle
	TC_CMR2_WAVEFORM_MODE_ACPA_TOGGLE = 0x3
	// Position of ACPC field.
	TC_CMR2_WAVEFORM_MODE_ACPC_Pos = 0x12
	// Bit mask of ACPC field.
	TC_CMR2_WAVEFORM_MODE_ACPC_Msk = 0xc0000
	// None
	TC_CMR2_WAVEFORM_MODE_ACPC_NONE = 0x0
	// Set
	TC_CMR2_WAVEFORM_MODE_ACPC_SET = 0x1
	// Clear
	TC_CMR2_WAVEFORM_MODE_ACPC_CLEAR = 0x2
	// Toggle
	TC_CMR2_WAVEFORM_MODE_ACPC_TOGGLE = 0x3
	// Position of AEEVT field.
	TC_CMR2_WAVEFORM_MODE_AEEVT_Pos = 0x14
	// Bit mask of AEEVT field.
	TC_CMR2_WAVEFORM_MODE_AEEVT_Msk = 0x300000
	// None
	TC_CMR2_WAVEFORM_MODE_AEEVT_NONE = 0x0
	// Set
	TC_CMR2_WAVEFORM_MODE_AEEVT_SET = 0x1
	// Clear
	TC_CMR2_WAVEFORM_MODE_AEEVT_CLEAR = 0x2
	// Toggle
	TC_CMR2_WAVEFORM_MODE_AEEVT_TOGGLE = 0x3
	// Position of ASWTRG field.
	TC_CMR2_WAVEFORM_MODE_ASWTRG_Pos = 0x16
	// Bit mask of ASWTRG field.
	TC_CMR2_WAVEFORM_MODE_ASWTRG_Msk = 0xc00000
	// None
	TC_CMR2_WAVEFORM_MODE_ASWTRG_NONE = 0x0
	// Set
	TC_CMR2_WAVEFORM_MODE_ASWTRG_SET = 0x1
	// Clear
	TC_CMR2_WAVEFORM_MODE_ASWTRG_CLEAR = 0x2
	// Toggle
	TC_CMR2_WAVEFORM_MODE_ASWTRG_TOGGLE = 0x3
	// Position of BCPB field.
	TC_CMR2_WAVEFORM_MODE_BCPB_Pos = 0x18
	// Bit mask of BCPB field.
	TC_CMR2_WAVEFORM_MODE_BCPB_Msk = 0x3000000
	// None
	TC_CMR2_WAVEFORM_MODE_BCPB_NONE = 0x0
	// Set
	TC_CMR2_WAVEFORM_MODE_BCPB_SET = 0x1
	// Clear
	TC_CMR2_WAVEFORM_MODE_BCPB_CLEAR = 0x2
	// Toggle
	TC_CMR2_WAVEFORM_MODE_BCPB_TOGGLE = 0x3
	// Position of BCPC field.
	TC_CMR2_WAVEFORM_MODE_BCPC_Pos = 0x1a
	// Bit mask of BCPC field.
	TC_CMR2_WAVEFORM_MODE_BCPC_Msk = 0xc000000
	// None
	TC_CMR2_WAVEFORM_MODE_BCPC_NONE = 0x0
	// Set
	TC_CMR2_WAVEFORM_MODE_BCPC_SET = 0x1
	// Clear
	TC_CMR2_WAVEFORM_MODE_BCPC_CLEAR = 0x2
	// Toggle
	TC_CMR2_WAVEFORM_MODE_BCPC_TOGGLE = 0x3
	// Position of BEEVT field.
	TC_CMR2_WAVEFORM_MODE_BEEVT_Pos = 0x1c
	// Bit mask of BEEVT field.
	TC_CMR2_WAVEFORM_MODE_BEEVT_Msk = 0x30000000
	// None
	TC_CMR2_WAVEFORM_MODE_BEEVT_NONE = 0x0
	// Set
	TC_CMR2_WAVEFORM_MODE_BEEVT_SET = 0x1
	// Clear
	TC_CMR2_WAVEFORM_MODE_BEEVT_CLEAR = 0x2
	// Toggle
	TC_CMR2_WAVEFORM_MODE_BEEVT_TOGGLE = 0x3
	// Position of BSWTRG field.
	TC_CMR2_WAVEFORM_MODE_BSWTRG_Pos = 0x1e
	// Bit mask of BSWTRG field.
	TC_CMR2_WAVEFORM_MODE_BSWTRG_Msk = 0xc0000000
	// None
	TC_CMR2_WAVEFORM_MODE_BSWTRG_NONE = 0x0
	// Set
	TC_CMR2_WAVEFORM_MODE_BSWTRG_SET = 0x1
	// Clear
	TC_CMR2_WAVEFORM_MODE_BSWTRG_CLEAR = 0x2
	// Toggle
	TC_CMR2_WAVEFORM_MODE_BSWTRG_TOGGLE = 0x3

	// CV2: Counter Value (channel = 2)
	// Position of CV field.
	TC_CV2_CV_Pos = 0x0
	// Bit mask of CV field.
	TC_CV2_CV_Msk = 0xffffffff

	// RA2: Register A (channel = 2)
	// Position of RA field.
	TC_RA2_RA_Pos = 0x0
	// Bit mask of RA field.
	TC_RA2_RA_Msk = 0xffffffff

	// RB2: Register B (channel = 2)
	// Position of RB field.
	TC_RB2_RB_Pos = 0x0
	// Bit mask of RB field.
	TC_RB2_RB_Msk = 0xffffffff

	// RC2: Register C (channel = 2)
	// Position of RC field.
	TC_RC2_RC_Pos = 0x0
	// Bit mask of RC field.
	TC_RC2_RC_Msk = 0xffffffff

	// SR2: Status Register (channel = 2)
	// Position of COVFS field.
	TC_SR2_COVFS_Pos = 0x0
	// Bit mask of COVFS field.
	TC_SR2_COVFS_Msk = 0x1
	// Bit COVFS.
	TC_SR2_COVFS = 0x1
	// Position of LOVRS field.
	TC_SR2_LOVRS_Pos = 0x1
	// Bit mask of LOVRS field.
	TC_SR2_LOVRS_Msk = 0x2
	// Bit LOVRS.
	TC_SR2_LOVRS = 0x2
	// Position of CPAS field.
	TC_SR2_CPAS_Pos = 0x2
	// Bit mask of CPAS field.
	TC_SR2_CPAS_Msk = 0x4
	// Bit CPAS.
	TC_SR2_CPAS = 0x4
	// Position of CPBS field.
	TC_SR2_CPBS_Pos = 0x3
	// Bit mask of CPBS field.
	TC_SR2_CPBS_Msk = 0x8
	// Bit CPBS.
	TC_SR2_CPBS = 0x8
	// Position of CPCS field.
	TC_SR2_CPCS_Pos = 0x4
	// Bit mask of CPCS field.
	TC_SR2_CPCS_Msk = 0x10
	// Bit CPCS.
	TC_SR2_CPCS = 0x10
	// Position of LDRAS field.
	TC_SR2_LDRAS_Pos = 0x5
	// Bit mask of LDRAS field.
	TC_SR2_LDRAS_Msk = 0x20
	// Bit LDRAS.
	TC_SR2_LDRAS = 0x20
	// Position of LDRBS field.
	TC_SR2_LDRBS_Pos = 0x6
	// Bit mask of LDRBS field.
	TC_SR2_LDRBS_Msk = 0x40
	// Bit LDRBS.
	TC_SR2_LDRBS = 0x40
	// Position of ETRGS field.
	TC_SR2_ETRGS_Pos = 0x7
	// Bit mask of ETRGS field.
	TC_SR2_ETRGS_Msk = 0x80
	// Bit ETRGS.
	TC_SR2_ETRGS = 0x80
	// Position of CLKSTA field.
	TC_SR2_CLKSTA_Pos = 0x10
	// Bit mask of CLKSTA field.
	TC_SR2_CLKSTA_Msk = 0x10000
	// Bit CLKSTA.
	TC_SR2_CLKSTA = 0x10000
	// Position of MTIOA field.
	TC_SR2_MTIOA_Pos = 0x11
	// Bit mask of MTIOA field.
	TC_SR2_MTIOA_Msk = 0x20000
	// Bit MTIOA.
	TC_SR2_MTIOA = 0x20000
	// Position of MTIOB field.
	TC_SR2_MTIOB_Pos = 0x12
	// Bit mask of MTIOB field.
	TC_SR2_MTIOB_Msk = 0x40000
	// Bit MTIOB.
	TC_SR2_MTIOB = 0x40000

	// IER2: Interrupt Enable Register (channel = 2)
	// Position of COVFS field.
	TC_IER2_COVFS_Pos = 0x0
	// Bit mask of COVFS field.
	TC_IER2_COVFS_Msk = 0x1
	// Bit COVFS.
	TC_IER2_COVFS = 0x1
	// Position of LOVRS field.
	TC_IER2_LOVRS_Pos = 0x1
	// Bit mask of LOVRS field.
	TC_IER2_LOVRS_Msk = 0x2
	// Bit LOVRS.
	TC_IER2_LOVRS = 0x2
	// Position of CPAS field.
	TC_IER2_CPAS_Pos = 0x2
	// Bit mask of CPAS field.
	TC_IER2_CPAS_Msk = 0x4
	// Bit CPAS.
	TC_IER2_CPAS = 0x4
	// Position of CPBS field.
	TC_IER2_CPBS_Pos = 0x3
	// Bit mask of CPBS field.
	TC_IER2_CPBS_Msk = 0x8
	// Bit CPBS.
	TC_IER2_CPBS = 0x8
	// Position of CPCS field.
	TC_IER2_CPCS_Pos = 0x4
	// Bit mask of CPCS field.
	TC_IER2_CPCS_Msk = 0x10
	// Bit CPCS.
	TC_IER2_CPCS = 0x10
	// Position of LDRAS field.
	TC_IER2_LDRAS_Pos = 0x5
	// Bit mask of LDRAS field.
	TC_IER2_LDRAS_Msk = 0x20
	// Bit LDRAS.
	TC_IER2_LDRAS = 0x20
	// Position of LDRBS field.
	TC_IER2_LDRBS_Pos = 0x6
	// Bit mask of LDRBS field.
	TC_IER2_LDRBS_Msk = 0x40
	// Bit LDRBS.
	TC_IER2_LDRBS = 0x40
	// Position of ETRGS field.
	TC_IER2_ETRGS_Pos = 0x7
	// Bit mask of ETRGS field.
	TC_IER2_ETRGS_Msk = 0x80
	// Bit ETRGS.
	TC_IER2_ETRGS = 0x80

	// IDR2: Interrupt Disable Register (channel = 2)
	// Position of COVFS field.
	TC_IDR2_COVFS_Pos = 0x0
	// Bit mask of COVFS field.
	TC_IDR2_COVFS_Msk = 0x1
	// Bit COVFS.
	TC_IDR2_COVFS = 0x1
	// Position of LOVRS field.
	TC_IDR2_LOVRS_Pos = 0x1
	// Bit mask of LOVRS field.
	TC_IDR2_LOVRS_Msk = 0x2
	// Bit LOVRS.
	TC_IDR2_LOVRS = 0x2
	// Position of CPAS field.
	TC_IDR2_CPAS_Pos = 0x2
	// Bit mask of CPAS field.
	TC_IDR2_CPAS_Msk = 0x4
	// Bit CPAS.
	TC_IDR2_CPAS = 0x4
	// Position of CPBS field.
	TC_IDR2_CPBS_Pos = 0x3
	// Bit mask of CPBS field.
	TC_IDR2_CPBS_Msk = 0x8
	// Bit CPBS.
	TC_IDR2_CPBS = 0x8
	// Position of CPCS field.
	TC_IDR2_CPCS_Pos = 0x4
	// Bit mask of CPCS field.
	TC_IDR2_CPCS_Msk = 0x10
	// Bit CPCS.
	TC_IDR2_CPCS = 0x10
	// Position of LDRAS field.
	TC_IDR2_LDRAS_Pos = 0x5
	// Bit mask of LDRAS field.
	TC_IDR2_LDRAS_Msk = 0x20
	// Bit LDRAS.
	TC_IDR2_LDRAS = 0x20
	// Position of LDRBS field.
	TC_IDR2_LDRBS_Pos = 0x6
	// Bit mask of LDRBS field.
	TC_IDR2_LDRBS_Msk = 0x40
	// Bit LDRBS.
	TC_IDR2_LDRBS = 0x40
	// Position of ETRGS field.
	TC_IDR2_ETRGS_Pos = 0x7
	// Bit mask of ETRGS field.
	TC_IDR2_ETRGS_Msk = 0x80
	// Bit ETRGS.
	TC_IDR2_ETRGS = 0x80

	// IMR2: Interrupt Mask Register (channel = 2)
	// Position of COVFS field.
	TC_IMR2_COVFS_Pos = 0x0
	// Bit mask of COVFS field.
	TC_IMR2_COVFS_Msk = 0x1
	// Bit COVFS.
	TC_IMR2_COVFS = 0x1
	// Position of LOVRS field.
	TC_IMR2_LOVRS_Pos = 0x1
	// Bit mask of LOVRS field.
	TC_IMR2_LOVRS_Msk = 0x2
	// Bit LOVRS.
	TC_IMR2_LOVRS = 0x2
	// Position of CPAS field.
	TC_IMR2_CPAS_Pos = 0x2
	// Bit mask of CPAS field.
	TC_IMR2_CPAS_Msk = 0x4
	// Bit CPAS.
	TC_IMR2_CPAS = 0x4
	// Position of CPBS field.
	TC_IMR2_CPBS_Pos = 0x3
	// Bit mask of CPBS field.
	TC_IMR2_CPBS_Msk = 0x8
	// Bit CPBS.
	TC_IMR2_CPBS = 0x8
	// Position of CPCS field.
	TC_IMR2_CPCS_Pos = 0x4
	// Bit mask of CPCS field.
	TC_IMR2_CPCS_Msk = 0x10
	// Bit CPCS.
	TC_IMR2_CPCS = 0x10
	// Position of LDRAS field.
	TC_IMR2_LDRAS_Pos = 0x5
	// Bit mask of LDRAS field.
	TC_IMR2_LDRAS_Msk = 0x20
	// Bit LDRAS.
	TC_IMR2_LDRAS = 0x20
	// Position of LDRBS field.
	TC_IMR2_LDRBS_Pos = 0x6
	// Bit mask of LDRBS field.
	TC_IMR2_LDRBS_Msk = 0x40
	// Bit LDRBS.
	TC_IMR2_LDRBS = 0x40
	// Position of ETRGS field.
	TC_IMR2_ETRGS_Pos = 0x7
	// Bit mask of ETRGS field.
	TC_IMR2_ETRGS_Msk = 0x80
	// Bit ETRGS.
	TC_IMR2_ETRGS = 0x80

	// BCR: Block Control Register
	// Position of SYNC field.
	TC_BCR_SYNC_Pos = 0x0
	// Bit mask of SYNC field.
	TC_BCR_SYNC_Msk = 0x1
	// Bit SYNC.
	TC_BCR_SYNC = 0x1

	// BMR: Block Mode Register
	// Position of TC0XC0S field.
	TC_BMR_TC0XC0S_Pos = 0x0
	// Bit mask of TC0XC0S field.
	TC_BMR_TC0XC0S_Msk = 0x3
	// Signal connected to XC0: TCLK0
	TC_BMR_TC0XC0S_TCLK0 = 0x0
	// Signal connected to XC0: TIOA1
	TC_BMR_TC0XC0S_TIOA1 = 0x2
	// Signal connected to XC0: TIOA2
	TC_BMR_TC0XC0S_TIOA2 = 0x3
	// Position of TC1XC1S field.
	TC_BMR_TC1XC1S_Pos = 0x2
	// Bit mask of TC1XC1S field.
	TC_BMR_TC1XC1S_Msk = 0xc
	// Signal connected to XC1: TCLK1
	TC_BMR_TC1XC1S_TCLK1 = 0x0
	// Signal connected to XC1: TIOA0
	TC_BMR_TC1XC1S_TIOA0 = 0x2
	// Signal connected to XC1: TIOA2
	TC_BMR_TC1XC1S_TIOA2 = 0x3
	// Position of TC2XC2S field.
	TC_BMR_TC2XC2S_Pos = 0x4
	// Bit mask of TC2XC2S field.
	TC_BMR_TC2XC2S_Msk = 0x30
	// Signal connected to XC2: TCLK2
	TC_BMR_TC2XC2S_TCLK2 = 0x0
	// Signal connected to XC2: TIOA0
	TC_BMR_TC2XC2S_TIOA0 = 0x2
	// Signal connected to XC2: TIOA1
	TC_BMR_TC2XC2S_TIOA1 = 0x3
	// Position of QDEN field.
	TC_BMR_QDEN_Pos = 0x8
	// Bit mask of QDEN field.
	TC_BMR_QDEN_Msk = 0x100
	// Bit QDEN.
	TC_BMR_QDEN = 0x100
	// Position of POSEN field.
	TC_BMR_POSEN_Pos = 0x9
	// Bit mask of POSEN field.
	TC_BMR_POSEN_Msk = 0x200
	// Bit POSEN.
	TC_BMR_POSEN = 0x200
	// Position of SPEEDEN field.
	TC_BMR_SPEEDEN_Pos = 0xa
	// Bit mask of SPEEDEN field.
	TC_BMR_SPEEDEN_Msk = 0x400
	// Bit SPEEDEN.
	TC_BMR_SPEEDEN = 0x400
	// Position of QDTRANS field.
	TC_BMR_QDTRANS_Pos = 0xb
	// Bit mask of QDTRANS field.
	TC_BMR_QDTRANS_Msk = 0x800
	// Bit QDTRANS.
	TC_BMR_QDTRANS = 0x800
	// Position of EDGPHA field.
	TC_BMR_EDGPHA_Pos = 0xc
	// Bit mask of EDGPHA field.
	TC_BMR_EDGPHA_Msk = 0x1000
	// Bit EDGPHA.
	TC_BMR_EDGPHA = 0x1000
	// Position of INVA field.
	TC_BMR_INVA_Pos = 0xd
	// Bit mask of INVA field.
	TC_BMR_INVA_Msk = 0x2000
	// Bit INVA.
	TC_BMR_INVA = 0x2000
	// Position of INVB field.
	TC_BMR_INVB_Pos = 0xe
	// Bit mask of INVB field.
	TC_BMR_INVB_Msk = 0x4000
	// Bit INVB.
	TC_BMR_INVB = 0x4000
	// Position of INVIDX field.
	TC_BMR_INVIDX_Pos = 0xf
	// Bit mask of INVIDX field.
	TC_BMR_INVIDX_Msk = 0x8000
	// Bit INVIDX.
	TC_BMR_INVIDX = 0x8000
	// Position of SWAP field.
	TC_BMR_SWAP_Pos = 0x10
	// Bit mask of SWAP field.
	TC_BMR_SWAP_Msk = 0x10000
	// Bit SWAP.
	TC_BMR_SWAP = 0x10000
	// Position of IDXPHB field.
	TC_BMR_IDXPHB_Pos = 0x11
	// Bit mask of IDXPHB field.
	TC_BMR_IDXPHB_Msk = 0x20000
	// Bit IDXPHB.
	TC_BMR_IDXPHB = 0x20000
	// Position of MAXFILT field.
	TC_BMR_MAXFILT_Pos = 0x14
	// Bit mask of MAXFILT field.
	TC_BMR_MAXFILT_Msk = 0x3f00000

	// QIER: QDEC Interrupt Enable Register
	// Position of IDX field.
	TC_QIER_IDX_Pos = 0x0
	// Bit mask of IDX field.
	TC_QIER_IDX_Msk = 0x1
	// Bit IDX.
	TC_QIER_IDX = 0x1
	// Position of DIRCHG field.
	TC_QIER_DIRCHG_Pos = 0x1
	// Bit mask of DIRCHG field.
	TC_QIER_DIRCHG_Msk = 0x2
	// Bit DIRCHG.
	TC_QIER_DIRCHG = 0x2
	// Position of QERR field.
	TC_QIER_QERR_Pos = 0x2
	// Bit mask of QERR field.
	TC_QIER_QERR_Msk = 0x4
	// Bit QERR.
	TC_QIER_QERR = 0x4

	// QIDR: QDEC Interrupt Disable Register
	// Position of IDX field.
	TC_QIDR_IDX_Pos = 0x0
	// Bit mask of IDX field.
	TC_QIDR_IDX_Msk = 0x1
	// Bit IDX.
	TC_QIDR_IDX = 0x1
	// Position of DIRCHG field.
	TC_QIDR_DIRCHG_Pos = 0x1
	// Bit mask of DIRCHG field.
	TC_QIDR_DIRCHG_Msk = 0x2
	// Bit DIRCHG.
	TC_QIDR_DIRCHG = 0x2
	// Position of QERR field.
	TC_QIDR_QERR_Pos = 0x2
	// Bit mask of QERR field.
	TC_QIDR_QERR_Msk = 0x4
	// Bit QERR.
	TC_QIDR_QERR = 0x4

	// QIMR: QDEC Interrupt Mask Register
	// Position of IDX field.
	TC_QIMR_IDX_Pos = 0x0
	// Bit mask of IDX field.
	TC_QIMR_IDX_Msk = 0x1
	// Bit IDX.
	TC_QIMR_IDX = 0x1
	// Position of DIRCHG field.
	TC_QIMR_DIRCHG_Pos = 0x1
	// Bit mask of DIRCHG field.
	TC_QIMR_DIRCHG_Msk = 0x2
	// Bit DIRCHG.
	TC_QIMR_DIRCHG = 0x2
	// Position of QERR field.
	TC_QIMR_QERR_Pos = 0x2
	// Bit mask of QERR field.
	TC_QIMR_QERR_Msk = 0x4
	// Bit QERR.
	TC_QIMR_QERR = 0x4

	// QISR: QDEC Interrupt Status Register
	// Position of IDX field.
	TC_QISR_IDX_Pos = 0x0
	// Bit mask of IDX field.
	TC_QISR_IDX_Msk = 0x1
	// Bit IDX.
	TC_QISR_IDX = 0x1
	// Position of DIRCHG field.
	TC_QISR_DIRCHG_Pos = 0x1
	// Bit mask of DIRCHG field.
	TC_QISR_DIRCHG_Msk = 0x2
	// Bit DIRCHG.
	TC_QISR_DIRCHG = 0x2
	// Position of QERR field.
	TC_QISR_QERR_Pos = 0x2
	// Bit mask of QERR field.
	TC_QISR_QERR_Msk = 0x4
	// Bit QERR.
	TC_QISR_QERR = 0x4
	// Position of DIR field.
	TC_QISR_DIR_Pos = 0x8
	// Bit mask of DIR field.
	TC_QISR_DIR_Msk = 0x100
	// Bit DIR.
	TC_QISR_DIR = 0x100
)

// Bitfields for TWI0: Two-wire Interface 0
const (
	// CR: Control Register
	// Position of START field.
	TWI_CR_START_Pos = 0x0
	// Bit mask of START field.
	TWI_CR_START_Msk = 0x1
	// Bit START.
	TWI_CR_START = 0x1
	// Position of STOP field.
	TWI_CR_STOP_Pos = 0x1
	// Bit mask of STOP field.
	TWI_CR_STOP_Msk = 0x2
	// Bit STOP.
	TWI_CR_STOP = 0x2
	// Position of MSEN field.
	TWI_CR_MSEN_Pos = 0x2
	// Bit mask of MSEN field.
	TWI_CR_MSEN_Msk = 0x4
	// Bit MSEN.
	TWI_CR_MSEN = 0x4
	// Position of MSDIS field.
	TWI_CR_MSDIS_Pos = 0x3
	// Bit mask of MSDIS field.
	TWI_CR_MSDIS_Msk = 0x8
	// Bit MSDIS.
	TWI_CR_MSDIS = 0x8
	// Position of SVEN field.
	TWI_CR_SVEN_Pos = 0x4
	// Bit mask of SVEN field.
	TWI_CR_SVEN_Msk = 0x10
	// Bit SVEN.
	TWI_CR_SVEN = 0x10
	// Position of SVDIS field.
	TWI_CR_SVDIS_Pos = 0x5
	// Bit mask of SVDIS field.
	TWI_CR_SVDIS_Msk = 0x20
	// Bit SVDIS.
	TWI_CR_SVDIS = 0x20
	// Position of QUICK field.
	TWI_CR_QUICK_Pos = 0x6
	// Bit mask of QUICK field.
	TWI_CR_QUICK_Msk = 0x40
	// Bit QUICK.
	TWI_CR_QUICK = 0x40
	// Position of SWRST field.
	TWI_CR_SWRST_Pos = 0x7
	// Bit mask of SWRST field.
	TWI_CR_SWRST_Msk = 0x80
	// Bit SWRST.
	TWI_CR_SWRST = 0x80

	// MMR: Master Mode Register
	// Position of IADRSZ field.
	TWI_MMR_IADRSZ_Pos = 0x8
	// Bit mask of IADRSZ field.
	TWI_MMR_IADRSZ_Msk = 0x300
	// No internal device address
	TWI_MMR_IADRSZ_NONE = 0x0
	// One-byte internal device address
	TWI_MMR_IADRSZ_1_BYTE = 0x1
	// Two-byte internal device address
	TWI_MMR_IADRSZ_2_BYTE = 0x2
	// Three-byte internal device address
	TWI_MMR_IADRSZ_3_BYTE = 0x3
	// Position of MREAD field.
	TWI_MMR_MREAD_Pos = 0xc
	// Bit mask of MREAD field.
	TWI_MMR_MREAD_Msk = 0x1000
	// Bit MREAD.
	TWI_MMR_MREAD = 0x1000
	// Position of DADR field.
	TWI_MMR_DADR_Pos = 0x10
	// Bit mask of DADR field.
	TWI_MMR_DADR_Msk = 0x7f0000

	// SMR: Slave Mode Register
	// Position of SADR field.
	TWI_SMR_SADR_Pos = 0x10
	// Bit mask of SADR field.
	TWI_SMR_SADR_Msk = 0x7f0000

	// IADR: Internal Address Register
	// Position of IADR field.
	TWI_IADR_IADR_Pos = 0x0
	// Bit mask of IADR field.
	TWI_IADR_IADR_Msk = 0xffffff

	// CWGR: Clock Waveform Generator Register
	// Position of CLDIV field.
	TWI_CWGR_CLDIV_Pos = 0x0
	// Bit mask of CLDIV field.
	TWI_CWGR_CLDIV_Msk = 0xff
	// Position of CHDIV field.
	TWI_CWGR_CHDIV_Pos = 0x8
	// Bit mask of CHDIV field.
	TWI_CWGR_CHDIV_Msk = 0xff00
	// Position of CKDIV field.
	TWI_CWGR_CKDIV_Pos = 0x10
	// Bit mask of CKDIV field.
	TWI_CWGR_CKDIV_Msk = 0x70000

	// SR: Status Register
	// Position of TXCOMP field.
	TWI_SR_TXCOMP_Pos = 0x0
	// Bit mask of TXCOMP field.
	TWI_SR_TXCOMP_Msk = 0x1
	// Bit TXCOMP.
	TWI_SR_TXCOMP = 0x1
	// Position of RXRDY field.
	TWI_SR_RXRDY_Pos = 0x1
	// Bit mask of RXRDY field.
	TWI_SR_RXRDY_Msk = 0x2
	// Bit RXRDY.
	TWI_SR_RXRDY = 0x2
	// Position of TXRDY field.
	TWI_SR_TXRDY_Pos = 0x2
	// Bit mask of TXRDY field.
	TWI_SR_TXRDY_Msk = 0x4
	// Bit TXRDY.
	TWI_SR_TXRDY = 0x4
	// Position of SVREAD field.
	TWI_SR_SVREAD_Pos = 0x3
	// Bit mask of SVREAD field.
	TWI_SR_SVREAD_Msk = 0x8
	// Bit SVREAD.
	TWI_SR_SVREAD = 0x8
	// Position of SVACC field.
	TWI_SR_SVACC_Pos = 0x4
	// Bit mask of SVACC field.
	TWI_SR_SVACC_Msk = 0x10
	// Bit SVACC.
	TWI_SR_SVACC = 0x10
	// Position of GACC field.
	TWI_SR_GACC_Pos = 0x5
	// Bit mask of GACC field.
	TWI_SR_GACC_Msk = 0x20
	// Bit GACC.
	TWI_SR_GACC = 0x20
	// Position of OVRE field.
	TWI_SR_OVRE_Pos = 0x6
	// Bit mask of OVRE field.
	TWI_SR_OVRE_Msk = 0x40
	// Bit OVRE.
	TWI_SR_OVRE = 0x40
	// Position of NACK field.
	TWI_SR_NACK_Pos = 0x8
	// Bit mask of NACK field.
	TWI_SR_NACK_Msk = 0x100
	// Bit NACK.
	TWI_SR_NACK = 0x100
	// Position of ARBLST field.
	TWI_SR_ARBLST_Pos = 0x9
	// Bit mask of ARBLST field.
	TWI_SR_ARBLST_Msk = 0x200
	// Bit ARBLST.
	TWI_SR_ARBLST = 0x200
	// Position of SCLWS field.
	TWI_SR_SCLWS_Pos = 0xa
	// Bit mask of SCLWS field.
	TWI_SR_SCLWS_Msk = 0x400
	// Bit SCLWS.
	TWI_SR_SCLWS = 0x400
	// Position of EOSACC field.
	TWI_SR_EOSACC_Pos = 0xb
	// Bit mask of EOSACC field.
	TWI_SR_EOSACC_Msk = 0x800
	// Bit EOSACC.
	TWI_SR_EOSACC = 0x800
	// Position of ENDRX field.
	TWI_SR_ENDRX_Pos = 0xc
	// Bit mask of ENDRX field.
	TWI_SR_ENDRX_Msk = 0x1000
	// Bit ENDRX.
	TWI_SR_ENDRX = 0x1000
	// Position of ENDTX field.
	TWI_SR_ENDTX_Pos = 0xd
	// Bit mask of ENDTX field.
	TWI_SR_ENDTX_Msk = 0x2000
	// Bit ENDTX.
	TWI_SR_ENDTX = 0x2000
	// Position of RXBUFF field.
	TWI_SR_RXBUFF_Pos = 0xe
	// Bit mask of RXBUFF field.
	TWI_SR_RXBUFF_Msk = 0x4000
	// Bit RXBUFF.
	TWI_SR_RXBUFF = 0x4000
	// Position of TXBUFE field.
	TWI_SR_TXBUFE_Pos = 0xf
	// Bit mask of TXBUFE field.
	TWI_SR_TXBUFE_Msk = 0x8000
	// Bit TXBUFE.
	TWI_SR_TXBUFE = 0x8000

	// IER: Interrupt Enable Register
	// Position of TXCOMP field.
	TWI_IER_TXCOMP_Pos = 0x0
	// Bit mask of TXCOMP field.
	TWI_IER_TXCOMP_Msk = 0x1
	// Bit TXCOMP.
	TWI_IER_TXCOMP = 0x1
	// Position of RXRDY field.
	TWI_IER_RXRDY_Pos = 0x1
	// Bit mask of RXRDY field.
	TWI_IER_RXRDY_Msk = 0x2
	// Bit RXRDY.
	TWI_IER_RXRDY = 0x2
	// Position of TXRDY field.
	TWI_IER_TXRDY_Pos = 0x2
	// Bit mask of TXRDY field.
	TWI_IER_TXRDY_Msk = 0x4
	// Bit TXRDY.
	TWI_IER_TXRDY = 0x4
	// Position of SVACC field.
	TWI_IER_SVACC_Pos = 0x4
	// Bit mask of SVACC field.
	TWI_IER_SVACC_Msk = 0x10
	// Bit SVACC.
	TWI_IER_SVACC = 0x10
	// Position of GACC field.
	TWI_IER_GACC_Pos = 0x5
	// Bit mask of GACC field.
	TWI_IER_GACC_Msk = 0x20
	// Bit GACC.
	TWI_IER_GACC = 0x20
	// Position of OVRE field.
	TWI_IER_OVRE_Pos = 0x6
	// Bit mask of OVRE field.
	TWI_IER_OVRE_Msk = 0x40
	// Bit OVRE.
	TWI_IER_OVRE = 0x40
	// Position of NACK field.
	TWI_IER_NACK_Pos = 0x8
	// Bit mask of NACK field.
	TWI_IER_NACK_Msk = 0x100
	// Bit NACK.
	TWI_IER_NACK = 0x100
	// Position of ARBLST field.
	TWI_IER_ARBLST_Pos = 0x9
	// Bit mask of ARBLST field.
	TWI_IER_ARBLST_Msk = 0x200
	// Bit ARBLST.
	TWI_IER_ARBLST = 0x200
	// Position of SCL_WS field.
	TWI_IER_SCL_WS_Pos = 0xa
	// Bit mask of SCL_WS field.
	TWI_IER_SCL_WS_Msk = 0x400
	// Bit SCL_WS.
	TWI_IER_SCL_WS = 0x400
	// Position of EOSACC field.
	TWI_IER_EOSACC_Pos = 0xb
	// Bit mask of EOSACC field.
	TWI_IER_EOSACC_Msk = 0x800
	// Bit EOSACC.
	TWI_IER_EOSACC = 0x800
	// Position of ENDRX field.
	TWI_IER_ENDRX_Pos = 0xc
	// Bit mask of ENDRX field.
	TWI_IER_ENDRX_Msk = 0x1000
	// Bit ENDRX.
	TWI_IER_ENDRX = 0x1000
	// Position of ENDTX field.
	TWI_IER_ENDTX_Pos = 0xd
	// Bit mask of ENDTX field.
	TWI_IER_ENDTX_Msk = 0x2000
	// Bit ENDTX.
	TWI_IER_ENDTX = 0x2000
	// Position of RXBUFF field.
	TWI_IER_RXBUFF_Pos = 0xe
	// Bit mask of RXBUFF field.
	TWI_IER_RXBUFF_Msk = 0x4000
	// Bit RXBUFF.
	TWI_IER_RXBUFF = 0x4000
	// Position of TXBUFE field.
	TWI_IER_TXBUFE_Pos = 0xf
	// Bit mask of TXBUFE field.
	TWI_IER_TXBUFE_Msk = 0x8000
	// Bit TXBUFE.
	TWI_IER_TXBUFE = 0x8000

	// IDR: Interrupt Disable Register
	// Position of TXCOMP field.
	TWI_IDR_TXCOMP_Pos = 0x0
	// Bit mask of TXCOMP field.
	TWI_IDR_TXCOMP_Msk = 0x1
	// Bit TXCOMP.
	TWI_IDR_TXCOMP = 0x1
	// Position of RXRDY field.
	TWI_IDR_RXRDY_Pos = 0x1
	// Bit mask of RXRDY field.
	TWI_IDR_RXRDY_Msk = 0x2
	// Bit RXRDY.
	TWI_IDR_RXRDY = 0x2
	// Position of TXRDY field.
	TWI_IDR_TXRDY_Pos = 0x2
	// Bit mask of TXRDY field.
	TWI_IDR_TXRDY_Msk = 0x4
	// Bit TXRDY.
	TWI_IDR_TXRDY = 0x4
	// Position of SVACC field.
	TWI_IDR_SVACC_Pos = 0x4
	// Bit mask of SVACC field.
	TWI_IDR_SVACC_Msk = 0x10
	// Bit SVACC.
	TWI_IDR_SVACC = 0x10
	// Position of GACC field.
	TWI_IDR_GACC_Pos = 0x5
	// Bit mask of GACC field.
	TWI_IDR_GACC_Msk = 0x20
	// Bit GACC.
	TWI_IDR_GACC = 0x20
	// Position of OVRE field.
	TWI_IDR_OVRE_Pos = 0x6
	// Bit mask of OVRE field.
	TWI_IDR_OVRE_Msk = 0x40
	// Bit OVRE.
	TWI_IDR_OVRE = 0x40
	// Position of NACK field.
	TWI_IDR_NACK_Pos = 0x8
	// Bit mask of NACK field.
	TWI_IDR_NACK_Msk = 0x100
	// Bit NACK.
	TWI_IDR_NACK = 0x100
	// Position of ARBLST field.
	TWI_IDR_ARBLST_Pos = 0x9
	// Bit mask of ARBLST field.
	TWI_IDR_ARBLST_Msk = 0x200
	// Bit ARBLST.
	TWI_IDR_ARBLST = 0x200
	// Position of SCL_WS field.
	TWI_IDR_SCL_WS_Pos = 0xa
	// Bit mask of SCL_WS field.
	TWI_IDR_SCL_WS_Msk = 0x400
	// Bit SCL_WS.
	TWI_IDR_SCL_WS = 0x400
	// Position of EOSACC field.
	TWI_IDR_EOSACC_Pos = 0xb
	// Bit mask of EOSACC field.
	TWI_IDR_EOSACC_Msk = 0x800
	// Bit EOSACC.
	TWI_IDR_EOSACC = 0x800
	// Position of ENDRX field.
	TWI_IDR_ENDRX_Pos = 0xc
	// Bit mask of ENDRX field.
	TWI_IDR_ENDRX_Msk = 0x1000
	// Bit ENDRX.
	TWI_IDR_ENDRX = 0x1000
	// Position of ENDTX field.
	TWI_IDR_ENDTX_Pos = 0xd
	// Bit mask of ENDTX field.
	TWI_IDR_ENDTX_Msk = 0x2000
	// Bit ENDTX.
	TWI_IDR_ENDTX = 0x2000
	// Position of RXBUFF field.
	TWI_IDR_RXBUFF_Pos = 0xe
	// Bit mask of RXBUFF field.
	TWI_IDR_RXBUFF_Msk = 0x4000
	// Bit RXBUFF.
	TWI_IDR_RXBUFF = 0x4000
	// Position of TXBUFE field.
	TWI_IDR_TXBUFE_Pos = 0xf
	// Bit mask of TXBUFE field.
	TWI_IDR_TXBUFE_Msk = 0x8000
	// Bit TXBUFE.
	TWI_IDR_TXBUFE = 0x8000

	// IMR: Interrupt Mask Register
	// Position of TXCOMP field.
	TWI_IMR_TXCOMP_Pos = 0x0
	// Bit mask of TXCOMP field.
	TWI_IMR_TXCOMP_Msk = 0x1
	// Bit TXCOMP.
	TWI_IMR_TXCOMP = 0x1
	// Position of RXRDY field.
	TWI_IMR_RXRDY_Pos = 0x1
	// Bit mask of RXRDY field.
	TWI_IMR_RXRDY_Msk = 0x2
	// Bit RXRDY.
	TWI_IMR_RXRDY = 0x2
	// Position of TXRDY field.
	TWI_IMR_TXRDY_Pos = 0x2
	// Bit mask of TXRDY field.
	TWI_IMR_TXRDY_Msk = 0x4
	// Bit TXRDY.
	TWI_IMR_TXRDY = 0x4
	// Position of SVACC field.
	TWI_IMR_SVACC_Pos = 0x4
	// Bit mask of SVACC field.
	TWI_IMR_SVACC_Msk = 0x10
	// Bit SVACC.
	TWI_IMR_SVACC = 0x10
	// Position of GACC field.
	TWI_IMR_GACC_Pos = 0x5
	// Bit mask of GACC field.
	TWI_IMR_GACC_Msk = 0x20
	// Bit GACC.
	TWI_IMR_GACC = 0x20
	// Position of OVRE field.
	TWI_IMR_OVRE_Pos = 0x6
	// Bit mask of OVRE field.
	TWI_IMR_OVRE_Msk = 0x40
	// Bit OVRE.
	TWI_IMR_OVRE = 0x40
	// Position of NACK field.
	TWI_IMR_NACK_Pos = 0x8
	// Bit mask of NACK field.
	TWI_IMR_NACK_Msk = 0x100
	// Bit NACK.
	TWI_IMR_NACK = 0x100
	// Position of ARBLST field.
	TWI_IMR_ARBLST_Pos = 0x9
	// Bit mask of ARBLST field.
	TWI_IMR_ARBLST_Msk = 0x200
	// Bit ARBLST.
	TWI_IMR_ARBLST = 0x200
	// Position of SCL_WS field.
	TWI_IMR_SCL_WS_Pos = 0xa
	// Bit mask of SCL_WS field.
	TWI_IMR_SCL_WS_Msk = 0x400
	// Bit SCL_WS.
	TWI_IMR_SCL_WS = 0x400
	// Position of EOSACC field.
	TWI_IMR_EOSACC_Pos = 0xb
	// Bit mask of EOSACC field.
	TWI_IMR_EOSACC_Msk = 0x800
	// Bit EOSACC.
	TWI_IMR_EOSACC = 0x800
	// Position of ENDRX field.
	TWI_IMR_ENDRX_Pos = 0xc
	// Bit mask of ENDRX field.
	TWI_IMR_ENDRX_Msk = 0x1000
	// Bit ENDRX.
	TWI_IMR_ENDRX = 0x1000
	// Position of ENDTX field.
	TWI_IMR_ENDTX_Pos = 0xd
	// Bit mask of ENDTX field.
	TWI_IMR_ENDTX_Msk = 0x2000
	// Bit ENDTX.
	TWI_IMR_ENDTX = 0x2000
	// Position of RXBUFF field.
	TWI_IMR_RXBUFF_Pos = 0xe
	// Bit mask of RXBUFF field.
	TWI_IMR_RXBUFF_Msk = 0x4000
	// Bit RXBUFF.
	TWI_IMR_RXBUFF = 0x4000
	// Position of TXBUFE field.
	TWI_IMR_TXBUFE_Pos = 0xf
	// Bit mask of TXBUFE field.
	TWI_IMR_TXBUFE_Msk = 0x8000
	// Bit TXBUFE.
	TWI_IMR_TXBUFE = 0x8000

	// RHR: Receive Holding Register
	// Position of RXDATA field.
	TWI_RHR_RXDATA_Pos = 0x0
	// Bit mask of RXDATA field.
	TWI_RHR_RXDATA_Msk = 0xff

	// THR: Transmit Holding Register
	// Position of TXDATA field.
	TWI_THR_TXDATA_Pos = 0x0
	// Bit mask of TXDATA field.
	TWI_THR_TXDATA_Msk = 0xff

	// RPR: Receive Pointer Register
	// Position of RXPTR field.
	TWI_RPR_RXPTR_Pos = 0x0
	// Bit mask of RXPTR field.
	TWI_RPR_RXPTR_Msk = 0xffffffff

	// RCR: Receive Counter Register
	// Position of RXCTR field.
	TWI_RCR_RXCTR_Pos = 0x0
	// Bit mask of RXCTR field.
	TWI_RCR_RXCTR_Msk = 0xffff

	// TPR: Transmit Pointer Register
	// Position of TXPTR field.
	TWI_TPR_TXPTR_Pos = 0x0
	// Bit mask of TXPTR field.
	TWI_TPR_TXPTR_Msk = 0xffffffff

	// TCR: Transmit Counter Register
	// Position of TXCTR field.
	TWI_TCR_TXCTR_Pos = 0x0
	// Bit mask of TXCTR field.
	TWI_TCR_TXCTR_Msk = 0xffff

	// RNPR: Receive Next Pointer Register
	// Position of RXNPTR field.
	TWI_RNPR_RXNPTR_Pos = 0x0
	// Bit mask of RXNPTR field.
	TWI_RNPR_RXNPTR_Msk = 0xffffffff

	// RNCR: Receive Next Counter Register
	// Position of RXNCTR field.
	TWI_RNCR_RXNCTR_Pos = 0x0
	// Bit mask of RXNCTR field.
	TWI_RNCR_RXNCTR_Msk = 0xffff

	// TNPR: Transmit Next Pointer Register
	// Position of TXNPTR field.
	TWI_TNPR_TXNPTR_Pos = 0x0
	// Bit mask of TXNPTR field.
	TWI_TNPR_TXNPTR_Msk = 0xffffffff

	// TNCR: Transmit Next Counter Register
	// Position of TXNCTR field.
	TWI_TNCR_TXNCTR_Pos = 0x0
	// Bit mask of TXNCTR field.
	TWI_TNCR_TXNCTR_Msk = 0xffff

	// PTCR: Transfer Control Register
	// Position of RXTEN field.
	TWI_PTCR_RXTEN_Pos = 0x0
	// Bit mask of RXTEN field.
	TWI_PTCR_RXTEN_Msk = 0x1
	// Bit RXTEN.
	TWI_PTCR_RXTEN = 0x1
	// Position of RXTDIS field.
	TWI_PTCR_RXTDIS_Pos = 0x1
	// Bit mask of RXTDIS field.
	TWI_PTCR_RXTDIS_Msk = 0x2
	// Bit RXTDIS.
	TWI_PTCR_RXTDIS = 0x2
	// Position of TXTEN field.
	TWI_PTCR_TXTEN_Pos = 0x8
	// Bit mask of TXTEN field.
	TWI_PTCR_TXTEN_Msk = 0x100
	// Bit TXTEN.
	TWI_PTCR_TXTEN = 0x100
	// Position of TXTDIS field.
	TWI_PTCR_TXTDIS_Pos = 0x9
	// Bit mask of TXTDIS field.
	TWI_PTCR_TXTDIS_Msk = 0x200
	// Bit TXTDIS.
	TWI_PTCR_TXTDIS = 0x200

	// PTSR: Transfer Status Register
	// Position of RXTEN field.
	TWI_PTSR_RXTEN_Pos = 0x0
	// Bit mask of RXTEN field.
	TWI_PTSR_RXTEN_Msk = 0x1
	// Bit RXTEN.
	TWI_PTSR_RXTEN = 0x1
	// Position of TXTEN field.
	TWI_PTSR_TXTEN_Pos = 0x8
	// Bit mask of TXTEN field.
	TWI_PTSR_TXTEN_Msk = 0x100
	// Bit TXTEN.
	TWI_PTSR_TXTEN = 0x100
)

// Bitfields for PWM: Pulse Width Modulation Controller
const (
	// CLK: PWM Clock Register
	// Position of DIVA field.
	PWM_CLK_DIVA_Pos = 0x0
	// Bit mask of DIVA field.
	PWM_CLK_DIVA_Msk = 0xff
	// Position of PREA field.
	PWM_CLK_PREA_Pos = 0x8
	// Bit mask of PREA field.
	PWM_CLK_PREA_Msk = 0xf00
	// Position of DIVB field.
	PWM_CLK_DIVB_Pos = 0x10
	// Bit mask of DIVB field.
	PWM_CLK_DIVB_Msk = 0xff0000
	// Position of PREB field.
	PWM_CLK_PREB_Pos = 0x18
	// Bit mask of PREB field.
	PWM_CLK_PREB_Msk = 0xf000000

	// ENA: PWM Enable Register
	// Position of CHID0 field.
	PWM_ENA_CHID0_Pos = 0x0
	// Bit mask of CHID0 field.
	PWM_ENA_CHID0_Msk = 0x1
	// Bit CHID0.
	PWM_ENA_CHID0 = 0x1
	// Position of CHID1 field.
	PWM_ENA_CHID1_Pos = 0x1
	// Bit mask of CHID1 field.
	PWM_ENA_CHID1_Msk = 0x2
	// Bit CHID1.
	PWM_ENA_CHID1 = 0x2
	// Position of CHID2 field.
	PWM_ENA_CHID2_Pos = 0x2
	// Bit mask of CHID2 field.
	PWM_ENA_CHID2_Msk = 0x4
	// Bit CHID2.
	PWM_ENA_CHID2 = 0x4
	// Position of CHID3 field.
	PWM_ENA_CHID3_Pos = 0x3
	// Bit mask of CHID3 field.
	PWM_ENA_CHID3_Msk = 0x8
	// Bit CHID3.
	PWM_ENA_CHID3 = 0x8

	// DIS: PWM Disable Register
	// Position of CHID0 field.
	PWM_DIS_CHID0_Pos = 0x0
	// Bit mask of CHID0 field.
	PWM_DIS_CHID0_Msk = 0x1
	// Bit CHID0.
	PWM_DIS_CHID0 = 0x1
	// Position of CHID1 field.
	PWM_DIS_CHID1_Pos = 0x1
	// Bit mask of CHID1 field.
	PWM_DIS_CHID1_Msk = 0x2
	// Bit CHID1.
	PWM_DIS_CHID1 = 0x2
	// Position of CHID2 field.
	PWM_DIS_CHID2_Pos = 0x2
	// Bit mask of CHID2 field.
	PWM_DIS_CHID2_Msk = 0x4
	// Bit CHID2.
	PWM_DIS_CHID2 = 0x4
	// Position of CHID3 field.
	PWM_DIS_CHID3_Pos = 0x3
	// Bit mask of CHID3 field.
	PWM_DIS_CHID3_Msk = 0x8
	// Bit CHID3.
	PWM_DIS_CHID3 = 0x8

	// SR: PWM Status Register
	// Position of CHID0 field.
	PWM_SR_CHID0_Pos = 0x0
	// Bit mask of CHID0 field.
	PWM_SR_CHID0_Msk = 0x1
	// Bit CHID0.
	PWM_SR_CHID0 = 0x1
	// Position of CHID1 field.
	PWM_SR_CHID1_Pos = 0x1
	// Bit mask of CHID1 field.
	PWM_SR_CHID1_Msk = 0x2
	// Bit CHID1.
	PWM_SR_CHID1 = 0x2
	// Position of CHID2 field.
	PWM_SR_CHID2_Pos = 0x2
	// Bit mask of CHID2 field.
	PWM_SR_CHID2_Msk = 0x4
	// Bit CHID2.
	PWM_SR_CHID2 = 0x4
	// Position of CHID3 field.
	PWM_SR_CHID3_Pos = 0x3
	// Bit mask of CHID3 field.
	PWM_SR_CHID3_Msk = 0x8
	// Bit CHID3.
	PWM_SR_CHID3 = 0x8

	// IER1: PWM Interrupt Enable Register 1
	// Position of CHID0 field.
	PWM_IER1_CHID0_Pos = 0x0
	// Bit mask of CHID0 field.
	PWM_IER1_CHID0_Msk = 0x1
	// Bit CHID0.
	PWM_IER1_CHID0 = 0x1
	// Position of CHID1 field.
	PWM_IER1_CHID1_Pos = 0x1
	// Bit mask of CHID1 field.
	PWM_IER1_CHID1_Msk = 0x2
	// Bit CHID1.
	PWM_IER1_CHID1 = 0x2
	// Position of CHID2 field.
	PWM_IER1_CHID2_Pos = 0x2
	// Bit mask of CHID2 field.
	PWM_IER1_CHID2_Msk = 0x4
	// Bit CHID2.
	PWM_IER1_CHID2 = 0x4
	// Position of CHID3 field.
	PWM_IER1_CHID3_Pos = 0x3
	// Bit mask of CHID3 field.
	PWM_IER1_CHID3_Msk = 0x8
	// Bit CHID3.
	PWM_IER1_CHID3 = 0x8
	// Position of FCHID0 field.
	PWM_IER1_FCHID0_Pos = 0x10
	// Bit mask of FCHID0 field.
	PWM_IER1_FCHID0_Msk = 0x10000
	// Bit FCHID0.
	PWM_IER1_FCHID0 = 0x10000
	// Position of FCHID1 field.
	PWM_IER1_FCHID1_Pos = 0x11
	// Bit mask of FCHID1 field.
	PWM_IER1_FCHID1_Msk = 0x20000
	// Bit FCHID1.
	PWM_IER1_FCHID1 = 0x20000
	// Position of FCHID2 field.
	PWM_IER1_FCHID2_Pos = 0x12
	// Bit mask of FCHID2 field.
	PWM_IER1_FCHID2_Msk = 0x40000
	// Bit FCHID2.
	PWM_IER1_FCHID2 = 0x40000
	// Position of FCHID3 field.
	PWM_IER1_FCHID3_Pos = 0x13
	// Bit mask of FCHID3 field.
	PWM_IER1_FCHID3_Msk = 0x80000
	// Bit FCHID3.
	PWM_IER1_FCHID3 = 0x80000

	// IDR1: PWM Interrupt Disable Register 1
	// Position of CHID0 field.
	PWM_IDR1_CHID0_Pos = 0x0
	// Bit mask of CHID0 field.
	PWM_IDR1_CHID0_Msk = 0x1
	// Bit CHID0.
	PWM_IDR1_CHID0 = 0x1
	// Position of CHID1 field.
	PWM_IDR1_CHID1_Pos = 0x1
	// Bit mask of CHID1 field.
	PWM_IDR1_CHID1_Msk = 0x2
	// Bit CHID1.
	PWM_IDR1_CHID1 = 0x2
	// Position of CHID2 field.
	PWM_IDR1_CHID2_Pos = 0x2
	// Bit mask of CHID2 field.
	PWM_IDR1_CHID2_Msk = 0x4
	// Bit CHID2.
	PWM_IDR1_CHID2 = 0x4
	// Position of CHID3 field.
	PWM_IDR1_CHID3_Pos = 0x3
	// Bit mask of CHID3 field.
	PWM_IDR1_CHID3_Msk = 0x8
	// Bit CHID3.
	PWM_IDR1_CHID3 = 0x8
	// Position of FCHID0 field.
	PWM_IDR1_FCHID0_Pos = 0x10
	// Bit mask of FCHID0 field.
	PWM_IDR1_FCHID0_Msk = 0x10000
	// Bit FCHID0.
	PWM_IDR1_FCHID0 = 0x10000
	// Position of FCHID1 field.
	PWM_IDR1_FCHID1_Pos = 0x11
	// Bit mask of FCHID1 field.
	PWM_IDR1_FCHID1_Msk = 0x20000
	// Bit FCHID1.
	PWM_IDR1_FCHID1 = 0x20000
	// Position of FCHID2 field.
	PWM_IDR1_FCHID2_Pos = 0x12
	// Bit mask of FCHID2 field.
	PWM_IDR1_FCHID2_Msk = 0x40000
	// Bit FCHID2.
	PWM_IDR1_FCHID2 = 0x40000
	// Position of FCHID3 field.
	PWM_IDR1_FCHID3_Pos = 0x13
	// Bit mask of FCHID3 field.
	PWM_IDR1_FCHID3_Msk = 0x80000
	// Bit FCHID3.
	PWM_IDR1_FCHID3 = 0x80000

	// IMR1: PWM Interrupt Mask Register 1
	// Position of CHID0 field.
	PWM_IMR1_CHID0_Pos = 0x0
	// Bit mask of CHID0 field.
	PWM_IMR1_CHID0_Msk = 0x1
	// Bit CHID0.
	PWM_IMR1_CHID0 = 0x1
	// Position of CHID1 field.
	PWM_IMR1_CHID1_Pos = 0x1
	// Bit mask of CHID1 field.
	PWM_IMR1_CHID1_Msk = 0x2
	// Bit CHID1.
	PWM_IMR1_CHID1 = 0x2
	// Position of CHID2 field.
	PWM_IMR1_CHID2_Pos = 0x2
	// Bit mask of CHID2 field.
	PWM_IMR1_CHID2_Msk = 0x4
	// Bit CHID2.
	PWM_IMR1_CHID2 = 0x4
	// Position of CHID3 field.
	PWM_IMR1_CHID3_Pos = 0x3
	// Bit mask of CHID3 field.
	PWM_IMR1_CHID3_Msk = 0x8
	// Bit CHID3.
	PWM_IMR1_CHID3 = 0x8
	// Position of FCHID0 field.
	PWM_IMR1_FCHID0_Pos = 0x10
	// Bit mask of FCHID0 field.
	PWM_IMR1_FCHID0_Msk = 0x10000
	// Bit FCHID0.
	PWM_IMR1_FCHID0 = 0x10000
	// Position of FCHID1 field.
	PWM_IMR1_FCHID1_Pos = 0x11
	// Bit mask of FCHID1 field.
	PWM_IMR1_FCHID1_Msk = 0x20000
	// Bit FCHID1.
	PWM_IMR1_FCHID1 = 0x20000
	// Position of FCHID2 field.
	PWM_IMR1_FCHID2_Pos = 0x12
	// Bit mask of FCHID2 field.
	PWM_IMR1_FCHID2_Msk = 0x40000
	// Bit FCHID2.
	PWM_IMR1_FCHID2 = 0x40000
	// Position of FCHID3 field.
	PWM_IMR1_FCHID3_Pos = 0x13
	// Bit mask of FCHID3 field.
	PWM_IMR1_FCHID3_Msk = 0x80000
	// Bit FCHID3.
	PWM_IMR1_FCHID3 = 0x80000

	// ISR1: PWM Interrupt Status Register 1
	// Position of CHID0 field.
	PWM_ISR1_CHID0_Pos = 0x0
	// Bit mask of CHID0 field.
	PWM_ISR1_CHID0_Msk = 0x1
	// Bit CHID0.
	PWM_ISR1_CHID0 = 0x1
	// Position of CHID1 field.
	PWM_ISR1_CHID1_Pos = 0x1
	// Bit mask of CHID1 field.
	PWM_ISR1_CHID1_Msk = 0x2
	// Bit CHID1.
	PWM_ISR1_CHID1 = 0x2
	// Position of CHID2 field.
	PWM_ISR1_CHID2_Pos = 0x2
	// Bit mask of CHID2 field.
	PWM_ISR1_CHID2_Msk = 0x4
	// Bit CHID2.
	PWM_ISR1_CHID2 = 0x4
	// Position of CHID3 field.
	PWM_ISR1_CHID3_Pos = 0x3
	// Bit mask of CHID3 field.
	PWM_ISR1_CHID3_Msk = 0x8
	// Bit CHID3.
	PWM_ISR1_CHID3 = 0x8
	// Position of FCHID0 field.
	PWM_ISR1_FCHID0_Pos = 0x10
	// Bit mask of FCHID0 field.
	PWM_ISR1_FCHID0_Msk = 0x10000
	// Bit FCHID0.
	PWM_ISR1_FCHID0 = 0x10000
	// Position of FCHID1 field.
	PWM_ISR1_FCHID1_Pos = 0x11
	// Bit mask of FCHID1 field.
	PWM_ISR1_FCHID1_Msk = 0x20000
	// Bit FCHID1.
	PWM_ISR1_FCHID1 = 0x20000
	// Position of FCHID2 field.
	PWM_ISR1_FCHID2_Pos = 0x12
	// Bit mask of FCHID2 field.
	PWM_ISR1_FCHID2_Msk = 0x40000
	// Bit FCHID2.
	PWM_ISR1_FCHID2 = 0x40000
	// Position of FCHID3 field.
	PWM_ISR1_FCHID3_Pos = 0x13
	// Bit mask of FCHID3 field.
	PWM_ISR1_FCHID3_Msk = 0x80000
	// Bit FCHID3.
	PWM_ISR1_FCHID3 = 0x80000

	// SCM: PWM Sync Channels Mode Register
	// Position of SYNC0 field.
	PWM_SCM_SYNC0_Pos = 0x0
	// Bit mask of SYNC0 field.
	PWM_SCM_SYNC0_Msk = 0x1
	// Bit SYNC0.
	PWM_SCM_SYNC0 = 0x1
	// Position of SYNC1 field.
	PWM_SCM_SYNC1_Pos = 0x1
	// Bit mask of SYNC1 field.
	PWM_SCM_SYNC1_Msk = 0x2
	// Bit SYNC1.
	PWM_SCM_SYNC1 = 0x2
	// Position of SYNC2 field.
	PWM_SCM_SYNC2_Pos = 0x2
	// Bit mask of SYNC2 field.
	PWM_SCM_SYNC2_Msk = 0x4
	// Bit SYNC2.
	PWM_SCM_SYNC2 = 0x4
	// Position of SYNC3 field.
	PWM_SCM_SYNC3_Pos = 0x3
	// Bit mask of SYNC3 field.
	PWM_SCM_SYNC3_Msk = 0x8
	// Bit SYNC3.
	PWM_SCM_SYNC3 = 0x8
	// Position of UPDM field.
	PWM_SCM_UPDM_Pos = 0x10
	// Bit mask of UPDM field.
	PWM_SCM_UPDM_Msk = 0x30000
	// Manual write of double buffer registers and manual update of synchronous channels
	PWM_SCM_UPDM_MODE0 = 0x0
	// Manual write of double buffer registers and automatic update of synchronous channels
	PWM_SCM_UPDM_MODE1 = 0x1
	// Automatic write of duty-cycle update registers by the PDC and automatic update of synchronous channels
	PWM_SCM_UPDM_MODE2 = 0x2
	// Position of PTRM field.
	PWM_SCM_PTRM_Pos = 0x14
	// Bit mask of PTRM field.
	PWM_SCM_PTRM_Msk = 0x100000
	// Bit PTRM.
	PWM_SCM_PTRM = 0x100000
	// Position of PTRCS field.
	PWM_SCM_PTRCS_Pos = 0x15
	// Bit mask of PTRCS field.
	PWM_SCM_PTRCS_Msk = 0xe00000

	// SCUC: PWM Sync Channels Update Control Register
	// Position of UPDULOCK field.
	PWM_SCUC_UPDULOCK_Pos = 0x0
	// Bit mask of UPDULOCK field.
	PWM_SCUC_UPDULOCK_Msk = 0x1
	// Bit UPDULOCK.
	PWM_SCUC_UPDULOCK = 0x1

	// SCUP: PWM Sync Channels Update Period Register
	// Position of UPR field.
	PWM_SCUP_UPR_Pos = 0x0
	// Bit mask of UPR field.
	PWM_SCUP_UPR_Msk = 0xf
	// Position of UPRCNT field.
	PWM_SCUP_UPRCNT_Pos = 0x4
	// Bit mask of UPRCNT field.
	PWM_SCUP_UPRCNT_Msk = 0xf0

	// SCUPUPD: PWM Sync Channels Update Period Update Register
	// Position of UPRUPD field.
	PWM_SCUPUPD_UPRUPD_Pos = 0x0
	// Bit mask of UPRUPD field.
	PWM_SCUPUPD_UPRUPD_Msk = 0xf

	// IER2: PWM Interrupt Enable Register 2
	// Position of WRDY field.
	PWM_IER2_WRDY_Pos = 0x0
	// Bit mask of WRDY field.
	PWM_IER2_WRDY_Msk = 0x1
	// Bit WRDY.
	PWM_IER2_WRDY = 0x1
	// Position of ENDTX field.
	PWM_IER2_ENDTX_Pos = 0x1
	// Bit mask of ENDTX field.
	PWM_IER2_ENDTX_Msk = 0x2
	// Bit ENDTX.
	PWM_IER2_ENDTX = 0x2
	// Position of TXBUFE field.
	PWM_IER2_TXBUFE_Pos = 0x2
	// Bit mask of TXBUFE field.
	PWM_IER2_TXBUFE_Msk = 0x4
	// Bit TXBUFE.
	PWM_IER2_TXBUFE = 0x4
	// Position of UNRE field.
	PWM_IER2_UNRE_Pos = 0x3
	// Bit mask of UNRE field.
	PWM_IER2_UNRE_Msk = 0x8
	// Bit UNRE.
	PWM_IER2_UNRE = 0x8
	// Position of CMPM0 field.
	PWM_IER2_CMPM0_Pos = 0x8
	// Bit mask of CMPM0 field.
	PWM_IER2_CMPM0_Msk = 0x100
	// Bit CMPM0.
	PWM_IER2_CMPM0 = 0x100
	// Position of CMPM1 field.
	PWM_IER2_CMPM1_Pos = 0x9
	// Bit mask of CMPM1 field.
	PWM_IER2_CMPM1_Msk = 0x200
	// Bit CMPM1.
	PWM_IER2_CMPM1 = 0x200
	// Position of CMPM2 field.
	PWM_IER2_CMPM2_Pos = 0xa
	// Bit mask of CMPM2 field.
	PWM_IER2_CMPM2_Msk = 0x400
	// Bit CMPM2.
	PWM_IER2_CMPM2 = 0x400
	// Position of CMPM3 field.
	PWM_IER2_CMPM3_Pos = 0xb
	// Bit mask of CMPM3 field.
	PWM_IER2_CMPM3_Msk = 0x800
	// Bit CMPM3.
	PWM_IER2_CMPM3 = 0x800
	// Position of CMPM4 field.
	PWM_IER2_CMPM4_Pos = 0xc
	// Bit mask of CMPM4 field.
	PWM_IER2_CMPM4_Msk = 0x1000
	// Bit CMPM4.
	PWM_IER2_CMPM4 = 0x1000
	// Position of CMPM5 field.
	PWM_IER2_CMPM5_Pos = 0xd
	// Bit mask of CMPM5 field.
	PWM_IER2_CMPM5_Msk = 0x2000
	// Bit CMPM5.
	PWM_IER2_CMPM5 = 0x2000
	// Position of CMPM6 field.
	PWM_IER2_CMPM6_Pos = 0xe
	// Bit mask of CMPM6 field.
	PWM_IER2_CMPM6_Msk = 0x4000
	// Bit CMPM6.
	PWM_IER2_CMPM6 = 0x4000
	// Position of CMPM7 field.
	PWM_IER2_CMPM7_Pos = 0xf
	// Bit mask of CMPM7 field.
	PWM_IER2_CMPM7_Msk = 0x8000
	// Bit CMPM7.
	PWM_IER2_CMPM7 = 0x8000
	// Position of CMPU0 field.
	PWM_IER2_CMPU0_Pos = 0x10
	// Bit mask of CMPU0 field.
	PWM_IER2_CMPU0_Msk = 0x10000
	// Bit CMPU0.
	PWM_IER2_CMPU0 = 0x10000
	// Position of CMPU1 field.
	PWM_IER2_CMPU1_Pos = 0x11
	// Bit mask of CMPU1 field.
	PWM_IER2_CMPU1_Msk = 0x20000
	// Bit CMPU1.
	PWM_IER2_CMPU1 = 0x20000
	// Position of CMPU2 field.
	PWM_IER2_CMPU2_Pos = 0x12
	// Bit mask of CMPU2 field.
	PWM_IER2_CMPU2_Msk = 0x40000
	// Bit CMPU2.
	PWM_IER2_CMPU2 = 0x40000
	// Position of CMPU3 field.
	PWM_IER2_CMPU3_Pos = 0x13
	// Bit mask of CMPU3 field.
	PWM_IER2_CMPU3_Msk = 0x80000
	// Bit CMPU3.
	PWM_IER2_CMPU3 = 0x80000
	// Position of CMPU4 field.
	PWM_IER2_CMPU4_Pos = 0x14
	// Bit mask of CMPU4 field.
	PWM_IER2_CMPU4_Msk = 0x100000
	// Bit CMPU4.
	PWM_IER2_CMPU4 = 0x100000
	// Position of CMPU5 field.
	PWM_IER2_CMPU5_Pos = 0x15
	// Bit mask of CMPU5 field.
	PWM_IER2_CMPU5_Msk = 0x200000
	// Bit CMPU5.
	PWM_IER2_CMPU5 = 0x200000
	// Position of CMPU6 field.
	PWM_IER2_CMPU6_Pos = 0x16
	// Bit mask of CMPU6 field.
	PWM_IER2_CMPU6_Msk = 0x400000
	// Bit CMPU6.
	PWM_IER2_CMPU6 = 0x400000
	// Position of CMPU7 field.
	PWM_IER2_CMPU7_Pos = 0x17
	// Bit mask of CMPU7 field.
	PWM_IER2_CMPU7_Msk = 0x800000
	// Bit CMPU7.
	PWM_IER2_CMPU7 = 0x800000

	// IDR2: PWM Interrupt Disable Register 2
	// Position of WRDY field.
	PWM_IDR2_WRDY_Pos = 0x0
	// Bit mask of WRDY field.
	PWM_IDR2_WRDY_Msk = 0x1
	// Bit WRDY.
	PWM_IDR2_WRDY = 0x1
	// Position of ENDTX field.
	PWM_IDR2_ENDTX_Pos = 0x1
	// Bit mask of ENDTX field.
	PWM_IDR2_ENDTX_Msk = 0x2
	// Bit ENDTX.
	PWM_IDR2_ENDTX = 0x2
	// Position of TXBUFE field.
	PWM_IDR2_TXBUFE_Pos = 0x2
	// Bit mask of TXBUFE field.
	PWM_IDR2_TXBUFE_Msk = 0x4
	// Bit TXBUFE.
	PWM_IDR2_TXBUFE = 0x4
	// Position of UNRE field.
	PWM_IDR2_UNRE_Pos = 0x3
	// Bit mask of UNRE field.
	PWM_IDR2_UNRE_Msk = 0x8
	// Bit UNRE.
	PWM_IDR2_UNRE = 0x8
	// Position of CMPM0 field.
	PWM_IDR2_CMPM0_Pos = 0x8
	// Bit mask of CMPM0 field.
	PWM_IDR2_CMPM0_Msk = 0x100
	// Bit CMPM0.
	PWM_IDR2_CMPM0 = 0x100
	// Position of CMPM1 field.
	PWM_IDR2_CMPM1_Pos = 0x9
	// Bit mask of CMPM1 field.
	PWM_IDR2_CMPM1_Msk = 0x200
	// Bit CMPM1.
	PWM_IDR2_CMPM1 = 0x200
	// Position of CMPM2 field.
	PWM_IDR2_CMPM2_Pos = 0xa
	// Bit mask of CMPM2 field.
	PWM_IDR2_CMPM2_Msk = 0x400
	// Bit CMPM2.
	PWM_IDR2_CMPM2 = 0x400
	// Position of CMPM3 field.
	PWM_IDR2_CMPM3_Pos = 0xb
	// Bit mask of CMPM3 field.
	PWM_IDR2_CMPM3_Msk = 0x800
	// Bit CMPM3.
	PWM_IDR2_CMPM3 = 0x800
	// Position of CMPM4 field.
	PWM_IDR2_CMPM4_Pos = 0xc
	// Bit mask of CMPM4 field.
	PWM_IDR2_CMPM4_Msk = 0x1000
	// Bit CMPM4.
	PWM_IDR2_CMPM4 = 0x1000
	// Position of CMPM5 field.
	PWM_IDR2_CMPM5_Pos = 0xd
	// Bit mask of CMPM5 field.
	PWM_IDR2_CMPM5_Msk = 0x2000
	// Bit CMPM5.
	PWM_IDR2_CMPM5 = 0x2000
	// Position of CMPM6 field.
	PWM_IDR2_CMPM6_Pos = 0xe
	// Bit mask of CMPM6 field.
	PWM_IDR2_CMPM6_Msk = 0x4000
	// Bit CMPM6.
	PWM_IDR2_CMPM6 = 0x4000
	// Position of CMPM7 field.
	PWM_IDR2_CMPM7_Pos = 0xf
	// Bit mask of CMPM7 field.
	PWM_IDR2_CMPM7_Msk = 0x8000
	// Bit CMPM7.
	PWM_IDR2_CMPM7 = 0x8000
	// Position of CMPU0 field.
	PWM_IDR2_CMPU0_Pos = 0x10
	// Bit mask of CMPU0 field.
	PWM_IDR2_CMPU0_Msk = 0x10000
	// Bit CMPU0.
	PWM_IDR2_CMPU0 = 0x10000
	// Position of CMPU1 field.
	PWM_IDR2_CMPU1_Pos = 0x11
	// Bit mask of CMPU1 field.
	PWM_IDR2_CMPU1_Msk = 0x20000
	// Bit CMPU1.
	PWM_IDR2_CMPU1 = 0x20000
	// Position of CMPU2 field.
	PWM_IDR2_CMPU2_Pos = 0x12
	// Bit mask of CMPU2 field.
	PWM_IDR2_CMPU2_Msk = 0x40000
	// Bit CMPU2.
	PWM_IDR2_CMPU2 = 0x40000
	// Position of CMPU3 field.
	PWM_IDR2_CMPU3_Pos = 0x13
	// Bit mask of CMPU3 field.
	PWM_IDR2_CMPU3_Msk = 0x80000
	// Bit CMPU3.
	PWM_IDR2_CMPU3 = 0x80000
	// Position of CMPU4 field.
	PWM_IDR2_CMPU4_Pos = 0x14
	// Bit mask of CMPU4 field.
	PWM_IDR2_CMPU4_Msk = 0x100000
	// Bit CMPU4.
	PWM_IDR2_CMPU4 = 0x100000
	// Position of CMPU5 field.
	PWM_IDR2_CMPU5_Pos = 0x15
	// Bit mask of CMPU5 field.
	PWM_IDR2_CMPU5_Msk = 0x200000
	// Bit CMPU5.
	PWM_IDR2_CMPU5 = 0x200000
	// Position of CMPU6 field.
	PWM_IDR2_CMPU6_Pos = 0x16
	// Bit mask of CMPU6 field.
	PWM_IDR2_CMPU6_Msk = 0x400000
	// Bit CMPU6.
	PWM_IDR2_CMPU6 = 0x400000
	// Position of CMPU7 field.
	PWM_IDR2_CMPU7_Pos = 0x17
	// Bit mask of CMPU7 field.
	PWM_IDR2_CMPU7_Msk = 0x800000
	// Bit CMPU7.
	PWM_IDR2_CMPU7 = 0x800000

	// IMR2: PWM Interrupt Mask Register 2
	// Position of WRDY field.
	PWM_IMR2_WRDY_Pos = 0x0
	// Bit mask of WRDY field.
	PWM_IMR2_WRDY_Msk = 0x1
	// Bit WRDY.
	PWM_IMR2_WRDY = 0x1
	// Position of ENDTX field.
	PWM_IMR2_ENDTX_Pos = 0x1
	// Bit mask of ENDTX field.
	PWM_IMR2_ENDTX_Msk = 0x2
	// Bit ENDTX.
	PWM_IMR2_ENDTX = 0x2
	// Position of TXBUFE field.
	PWM_IMR2_TXBUFE_Pos = 0x2
	// Bit mask of TXBUFE field.
	PWM_IMR2_TXBUFE_Msk = 0x4
	// Bit TXBUFE.
	PWM_IMR2_TXBUFE = 0x4
	// Position of UNRE field.
	PWM_IMR2_UNRE_Pos = 0x3
	// Bit mask of UNRE field.
	PWM_IMR2_UNRE_Msk = 0x8
	// Bit UNRE.
	PWM_IMR2_UNRE = 0x8
	// Position of CMPM0 field.
	PWM_IMR2_CMPM0_Pos = 0x8
	// Bit mask of CMPM0 field.
	PWM_IMR2_CMPM0_Msk = 0x100
	// Bit CMPM0.
	PWM_IMR2_CMPM0 = 0x100
	// Position of CMPM1 field.
	PWM_IMR2_CMPM1_Pos = 0x9
	// Bit mask of CMPM1 field.
	PWM_IMR2_CMPM1_Msk = 0x200
	// Bit CMPM1.
	PWM_IMR2_CMPM1 = 0x200
	// Position of CMPM2 field.
	PWM_IMR2_CMPM2_Pos = 0xa
	// Bit mask of CMPM2 field.
	PWM_IMR2_CMPM2_Msk = 0x400
	// Bit CMPM2.
	PWM_IMR2_CMPM2 = 0x400
	// Position of CMPM3 field.
	PWM_IMR2_CMPM3_Pos = 0xb
	// Bit mask of CMPM3 field.
	PWM_IMR2_CMPM3_Msk = 0x800
	// Bit CMPM3.
	PWM_IMR2_CMPM3 = 0x800
	// Position of CMPM4 field.
	PWM_IMR2_CMPM4_Pos = 0xc
	// Bit mask of CMPM4 field.
	PWM_IMR2_CMPM4_Msk = 0x1000
	// Bit CMPM4.
	PWM_IMR2_CMPM4 = 0x1000
	// Position of CMPM5 field.
	PWM_IMR2_CMPM5_Pos = 0xd
	// Bit mask of CMPM5 field.
	PWM_IMR2_CMPM5_Msk = 0x2000
	// Bit CMPM5.
	PWM_IMR2_CMPM5 = 0x2000
	// Position of CMPM6 field.
	PWM_IMR2_CMPM6_Pos = 0xe
	// Bit mask of CMPM6 field.
	PWM_IMR2_CMPM6_Msk = 0x4000
	// Bit CMPM6.
	PWM_IMR2_CMPM6 = 0x4000
	// Position of CMPM7 field.
	PWM_IMR2_CMPM7_Pos = 0xf
	// Bit mask of CMPM7 field.
	PWM_IMR2_CMPM7_Msk = 0x8000
	// Bit CMPM7.
	PWM_IMR2_CMPM7 = 0x8000
	// Position of CMPU0 field.
	PWM_IMR2_CMPU0_Pos = 0x10
	// Bit mask of CMPU0 field.
	PWM_IMR2_CMPU0_Msk = 0x10000
	// Bit CMPU0.
	PWM_IMR2_CMPU0 = 0x10000
	// Position of CMPU1 field.
	PWM_IMR2_CMPU1_Pos = 0x11
	// Bit mask of CMPU1 field.
	PWM_IMR2_CMPU1_Msk = 0x20000
	// Bit CMPU1.
	PWM_IMR2_CMPU1 = 0x20000
	// Position of CMPU2 field.
	PWM_IMR2_CMPU2_Pos = 0x12
	// Bit mask of CMPU2 field.
	PWM_IMR2_CMPU2_Msk = 0x40000
	// Bit CMPU2.
	PWM_IMR2_CMPU2 = 0x40000
	// Position of CMPU3 field.
	PWM_IMR2_CMPU3_Pos = 0x13
	// Bit mask of CMPU3 field.
	PWM_IMR2_CMPU3_Msk = 0x80000
	// Bit CMPU3.
	PWM_IMR2_CMPU3 = 0x80000
	// Position of CMPU4 field.
	PWM_IMR2_CMPU4_Pos = 0x14
	// Bit mask of CMPU4 field.
	PWM_IMR2_CMPU4_Msk = 0x100000
	// Bit CMPU4.
	PWM_IMR2_CMPU4 = 0x100000
	// Position of CMPU5 field.
	PWM_IMR2_CMPU5_Pos = 0x15
	// Bit mask of CMPU5 field.
	PWM_IMR2_CMPU5_Msk = 0x200000
	// Bit CMPU5.
	PWM_IMR2_CMPU5 = 0x200000
	// Position of CMPU6 field.
	PWM_IMR2_CMPU6_Pos = 0x16
	// Bit mask of CMPU6 field.
	PWM_IMR2_CMPU6_Msk = 0x400000
	// Bit CMPU6.
	PWM_IMR2_CMPU6 = 0x400000
	// Position of CMPU7 field.
	PWM_IMR2_CMPU7_Pos = 0x17
	// Bit mask of CMPU7 field.
	PWM_IMR2_CMPU7_Msk = 0x800000
	// Bit CMPU7.
	PWM_IMR2_CMPU7 = 0x800000

	// ISR2: PWM Interrupt Status Register 2
	// Position of WRDY field.
	PWM_ISR2_WRDY_Pos = 0x0
	// Bit mask of WRDY field.
	PWM_ISR2_WRDY_Msk = 0x1
	// Bit WRDY.
	PWM_ISR2_WRDY = 0x1
	// Position of ENDTX field.
	PWM_ISR2_ENDTX_Pos = 0x1
	// Bit mask of ENDTX field.
	PWM_ISR2_ENDTX_Msk = 0x2
	// Bit ENDTX.
	PWM_ISR2_ENDTX = 0x2
	// Position of TXBUFE field.
	PWM_ISR2_TXBUFE_Pos = 0x2
	// Bit mask of TXBUFE field.
	PWM_ISR2_TXBUFE_Msk = 0x4
	// Bit TXBUFE.
	PWM_ISR2_TXBUFE = 0x4
	// Position of UNRE field.
	PWM_ISR2_UNRE_Pos = 0x3
	// Bit mask of UNRE field.
	PWM_ISR2_UNRE_Msk = 0x8
	// Bit UNRE.
	PWM_ISR2_UNRE = 0x8
	// Position of CMPM0 field.
	PWM_ISR2_CMPM0_Pos = 0x8
	// Bit mask of CMPM0 field.
	PWM_ISR2_CMPM0_Msk = 0x100
	// Bit CMPM0.
	PWM_ISR2_CMPM0 = 0x100
	// Position of CMPM1 field.
	PWM_ISR2_CMPM1_Pos = 0x9
	// Bit mask of CMPM1 field.
	PWM_ISR2_CMPM1_Msk = 0x200
	// Bit CMPM1.
	PWM_ISR2_CMPM1 = 0x200
	// Position of CMPM2 field.
	PWM_ISR2_CMPM2_Pos = 0xa
	// Bit mask of CMPM2 field.
	PWM_ISR2_CMPM2_Msk = 0x400
	// Bit CMPM2.
	PWM_ISR2_CMPM2 = 0x400
	// Position of CMPM3 field.
	PWM_ISR2_CMPM3_Pos = 0xb
	// Bit mask of CMPM3 field.
	PWM_ISR2_CMPM3_Msk = 0x800
	// Bit CMPM3.
	PWM_ISR2_CMPM3 = 0x800
	// Position of CMPM4 field.
	PWM_ISR2_CMPM4_Pos = 0xc
	// Bit mask of CMPM4 field.
	PWM_ISR2_CMPM4_Msk = 0x1000
	// Bit CMPM4.
	PWM_ISR2_CMPM4 = 0x1000
	// Position of CMPM5 field.
	PWM_ISR2_CMPM5_Pos = 0xd
	// Bit mask of CMPM5 field.
	PWM_ISR2_CMPM5_Msk = 0x2000
	// Bit CMPM5.
	PWM_ISR2_CMPM5 = 0x2000
	// Position of CMPM6 field.
	PWM_ISR2_CMPM6_Pos = 0xe
	// Bit mask of CMPM6 field.
	PWM_ISR2_CMPM6_Msk = 0x4000
	// Bit CMPM6.
	PWM_ISR2_CMPM6 = 0x4000
	// Position of CMPM7 field.
	PWM_ISR2_CMPM7_Pos = 0xf
	// Bit mask of CMPM7 field.
	PWM_ISR2_CMPM7_Msk = 0x8000
	// Bit CMPM7.
	PWM_ISR2_CMPM7 = 0x8000
	// Position of CMPU0 field.
	PWM_ISR2_CMPU0_Pos = 0x10
	// Bit mask of CMPU0 field.
	PWM_ISR2_CMPU0_Msk = 0x10000
	// Bit CMPU0.
	PWM_ISR2_CMPU0 = 0x10000
	// Position of CMPU1 field.
	PWM_ISR2_CMPU1_Pos = 0x11
	// Bit mask of CMPU1 field.
	PWM_ISR2_CMPU1_Msk = 0x20000
	// Bit CMPU1.
	PWM_ISR2_CMPU1 = 0x20000
	// Position of CMPU2 field.
	PWM_ISR2_CMPU2_Pos = 0x12
	// Bit mask of CMPU2 field.
	PWM_ISR2_CMPU2_Msk = 0x40000
	// Bit CMPU2.
	PWM_ISR2_CMPU2 = 0x40000
	// Position of CMPU3 field.
	PWM_ISR2_CMPU3_Pos = 0x13
	// Bit mask of CMPU3 field.
	PWM_ISR2_CMPU3_Msk = 0x80000
	// Bit CMPU3.
	PWM_ISR2_CMPU3 = 0x80000
	// Position of CMPU4 field.
	PWM_ISR2_CMPU4_Pos = 0x14
	// Bit mask of CMPU4 field.
	PWM_ISR2_CMPU4_Msk = 0x100000
	// Bit CMPU4.
	PWM_ISR2_CMPU4 = 0x100000
	// Position of CMPU5 field.
	PWM_ISR2_CMPU5_Pos = 0x15
	// Bit mask of CMPU5 field.
	PWM_ISR2_CMPU5_Msk = 0x200000
	// Bit CMPU5.
	PWM_ISR2_CMPU5 = 0x200000
	// Position of CMPU6 field.
	PWM_ISR2_CMPU6_Pos = 0x16
	// Bit mask of CMPU6 field.
	PWM_ISR2_CMPU6_Msk = 0x400000
	// Bit CMPU6.
	PWM_ISR2_CMPU6 = 0x400000
	// Position of CMPU7 field.
	PWM_ISR2_CMPU7_Pos = 0x17
	// Bit mask of CMPU7 field.
	PWM_ISR2_CMPU7_Msk = 0x800000
	// Bit CMPU7.
	PWM_ISR2_CMPU7 = 0x800000

	// OOV: PWM Output Override Value Register
	// Position of OOVH0 field.
	PWM_OOV_OOVH0_Pos = 0x0
	// Bit mask of OOVH0 field.
	PWM_OOV_OOVH0_Msk = 0x1
	// Bit OOVH0.
	PWM_OOV_OOVH0 = 0x1
	// Position of OOVH1 field.
	PWM_OOV_OOVH1_Pos = 0x1
	// Bit mask of OOVH1 field.
	PWM_OOV_OOVH1_Msk = 0x2
	// Bit OOVH1.
	PWM_OOV_OOVH1 = 0x2
	// Position of OOVH2 field.
	PWM_OOV_OOVH2_Pos = 0x2
	// Bit mask of OOVH2 field.
	PWM_OOV_OOVH2_Msk = 0x4
	// Bit OOVH2.
	PWM_OOV_OOVH2 = 0x4
	// Position of OOVH3 field.
	PWM_OOV_OOVH3_Pos = 0x3
	// Bit mask of OOVH3 field.
	PWM_OOV_OOVH3_Msk = 0x8
	// Bit OOVH3.
	PWM_OOV_OOVH3 = 0x8
	// Position of OOVL0 field.
	PWM_OOV_OOVL0_Pos = 0x10
	// Bit mask of OOVL0 field.
	PWM_OOV_OOVL0_Msk = 0x10000
	// Bit OOVL0.
	PWM_OOV_OOVL0 = 0x10000
	// Position of OOVL1 field.
	PWM_OOV_OOVL1_Pos = 0x11
	// Bit mask of OOVL1 field.
	PWM_OOV_OOVL1_Msk = 0x20000
	// Bit OOVL1.
	PWM_OOV_OOVL1 = 0x20000
	// Position of OOVL2 field.
	PWM_OOV_OOVL2_Pos = 0x12
	// Bit mask of OOVL2 field.
	PWM_OOV_OOVL2_Msk = 0x40000
	// Bit OOVL2.
	PWM_OOV_OOVL2 = 0x40000
	// Position of OOVL3 field.
	PWM_OOV_OOVL3_Pos = 0x13
	// Bit mask of OOVL3 field.
	PWM_OOV_OOVL3_Msk = 0x80000
	// Bit OOVL3.
	PWM_OOV_OOVL3 = 0x80000

	// OS: PWM Output Selection Register
	// Position of OSH0 field.
	PWM_OS_OSH0_Pos = 0x0
	// Bit mask of OSH0 field.
	PWM_OS_OSH0_Msk = 0x1
	// Bit OSH0.
	PWM_OS_OSH0 = 0x1
	// Position of OSH1 field.
	PWM_OS_OSH1_Pos = 0x1
	// Bit mask of OSH1 field.
	PWM_OS_OSH1_Msk = 0x2
	// Bit OSH1.
	PWM_OS_OSH1 = 0x2
	// Position of OSH2 field.
	PWM_OS_OSH2_Pos = 0x2
	// Bit mask of OSH2 field.
	PWM_OS_OSH2_Msk = 0x4
	// Bit OSH2.
	PWM_OS_OSH2 = 0x4
	// Position of OSH3 field.
	PWM_OS_OSH3_Pos = 0x3
	// Bit mask of OSH3 field.
	PWM_OS_OSH3_Msk = 0x8
	// Bit OSH3.
	PWM_OS_OSH3 = 0x8
	// Position of OSL0 field.
	PWM_OS_OSL0_Pos = 0x10
	// Bit mask of OSL0 field.
	PWM_OS_OSL0_Msk = 0x10000
	// Bit OSL0.
	PWM_OS_OSL0 = 0x10000
	// Position of OSL1 field.
	PWM_OS_OSL1_Pos = 0x11
	// Bit mask of OSL1 field.
	PWM_OS_OSL1_Msk = 0x20000
	// Bit OSL1.
	PWM_OS_OSL1 = 0x20000
	// Position of OSL2 field.
	PWM_OS_OSL2_Pos = 0x12
	// Bit mask of OSL2 field.
	PWM_OS_OSL2_Msk = 0x40000
	// Bit OSL2.
	PWM_OS_OSL2 = 0x40000
	// Position of OSL3 field.
	PWM_OS_OSL3_Pos = 0x13
	// Bit mask of OSL3 field.
	PWM_OS_OSL3_Msk = 0x80000
	// Bit OSL3.
	PWM_OS_OSL3 = 0x80000

	// OSS: PWM Output Selection Set Register
	// Position of OSSH0 field.
	PWM_OSS_OSSH0_Pos = 0x0
	// Bit mask of OSSH0 field.
	PWM_OSS_OSSH0_Msk = 0x1
	// Bit OSSH0.
	PWM_OSS_OSSH0 = 0x1
	// Position of OSSH1 field.
	PWM_OSS_OSSH1_Pos = 0x1
	// Bit mask of OSSH1 field.
	PWM_OSS_OSSH1_Msk = 0x2
	// Bit OSSH1.
	PWM_OSS_OSSH1 = 0x2
	// Position of OSSH2 field.
	PWM_OSS_OSSH2_Pos = 0x2
	// Bit mask of OSSH2 field.
	PWM_OSS_OSSH2_Msk = 0x4
	// Bit OSSH2.
	PWM_OSS_OSSH2 = 0x4
	// Position of OSSH3 field.
	PWM_OSS_OSSH3_Pos = 0x3
	// Bit mask of OSSH3 field.
	PWM_OSS_OSSH3_Msk = 0x8
	// Bit OSSH3.
	PWM_OSS_OSSH3 = 0x8
	// Position of OSSL0 field.
	PWM_OSS_OSSL0_Pos = 0x10
	// Bit mask of OSSL0 field.
	PWM_OSS_OSSL0_Msk = 0x10000
	// Bit OSSL0.
	PWM_OSS_OSSL0 = 0x10000
	// Position of OSSL1 field.
	PWM_OSS_OSSL1_Pos = 0x11
	// Bit mask of OSSL1 field.
	PWM_OSS_OSSL1_Msk = 0x20000
	// Bit OSSL1.
	PWM_OSS_OSSL1 = 0x20000
	// Position of OSSL2 field.
	PWM_OSS_OSSL2_Pos = 0x12
	// Bit mask of OSSL2 field.
	PWM_OSS_OSSL2_Msk = 0x40000
	// Bit OSSL2.
	PWM_OSS_OSSL2 = 0x40000
	// Position of OSSL3 field.
	PWM_OSS_OSSL3_Pos = 0x13
	// Bit mask of OSSL3 field.
	PWM_OSS_OSSL3_Msk = 0x80000
	// Bit OSSL3.
	PWM_OSS_OSSL3 = 0x80000

	// OSC: PWM Output Selection Clear Register
	// Position of OSCH0 field.
	PWM_OSC_OSCH0_Pos = 0x0
	// Bit mask of OSCH0 field.
	PWM_OSC_OSCH0_Msk = 0x1
	// Bit OSCH0.
	PWM_OSC_OSCH0 = 0x1
	// Position of OSCH1 field.
	PWM_OSC_OSCH1_Pos = 0x1
	// Bit mask of OSCH1 field.
	PWM_OSC_OSCH1_Msk = 0x2
	// Bit OSCH1.
	PWM_OSC_OSCH1 = 0x2
	// Position of OSCH2 field.
	PWM_OSC_OSCH2_Pos = 0x2
	// Bit mask of OSCH2 field.
	PWM_OSC_OSCH2_Msk = 0x4
	// Bit OSCH2.
	PWM_OSC_OSCH2 = 0x4
	// Position of OSCH3 field.
	PWM_OSC_OSCH3_Pos = 0x3
	// Bit mask of OSCH3 field.
	PWM_OSC_OSCH3_Msk = 0x8
	// Bit OSCH3.
	PWM_OSC_OSCH3 = 0x8
	// Position of OSCL0 field.
	PWM_OSC_OSCL0_Pos = 0x10
	// Bit mask of OSCL0 field.
	PWM_OSC_OSCL0_Msk = 0x10000
	// Bit OSCL0.
	PWM_OSC_OSCL0 = 0x10000
	// Position of OSCL1 field.
	PWM_OSC_OSCL1_Pos = 0x11
	// Bit mask of OSCL1 field.
	PWM_OSC_OSCL1_Msk = 0x20000
	// Bit OSCL1.
	PWM_OSC_OSCL1 = 0x20000
	// Position of OSCL2 field.
	PWM_OSC_OSCL2_Pos = 0x12
	// Bit mask of OSCL2 field.
	PWM_OSC_OSCL2_Msk = 0x40000
	// Bit OSCL2.
	PWM_OSC_OSCL2 = 0x40000
	// Position of OSCL3 field.
	PWM_OSC_OSCL3_Pos = 0x13
	// Bit mask of OSCL3 field.
	PWM_OSC_OSCL3_Msk = 0x80000
	// Bit OSCL3.
	PWM_OSC_OSCL3 = 0x80000

	// OSSUPD: PWM Output Selection Set Update Register
	// Position of OSSUPH0 field.
	PWM_OSSUPD_OSSUPH0_Pos = 0x0
	// Bit mask of OSSUPH0 field.
	PWM_OSSUPD_OSSUPH0_Msk = 0x1
	// Bit OSSUPH0.
	PWM_OSSUPD_OSSUPH0 = 0x1
	// Position of OSSUPH1 field.
	PWM_OSSUPD_OSSUPH1_Pos = 0x1
	// Bit mask of OSSUPH1 field.
	PWM_OSSUPD_OSSUPH1_Msk = 0x2
	// Bit OSSUPH1.
	PWM_OSSUPD_OSSUPH1 = 0x2
	// Position of OSSUPH2 field.
	PWM_OSSUPD_OSSUPH2_Pos = 0x2
	// Bit mask of OSSUPH2 field.
	PWM_OSSUPD_OSSUPH2_Msk = 0x4
	// Bit OSSUPH2.
	PWM_OSSUPD_OSSUPH2 = 0x4
	// Position of OSSUPH3 field.
	PWM_OSSUPD_OSSUPH3_Pos = 0x3
	// Bit mask of OSSUPH3 field.
	PWM_OSSUPD_OSSUPH3_Msk = 0x8
	// Bit OSSUPH3.
	PWM_OSSUPD_OSSUPH3 = 0x8
	// Position of OSSUPL0 field.
	PWM_OSSUPD_OSSUPL0_Pos = 0x10
	// Bit mask of OSSUPL0 field.
	PWM_OSSUPD_OSSUPL0_Msk = 0x10000
	// Bit OSSUPL0.
	PWM_OSSUPD_OSSUPL0 = 0x10000
	// Position of OSSUPL1 field.
	PWM_OSSUPD_OSSUPL1_Pos = 0x11
	// Bit mask of OSSUPL1 field.
	PWM_OSSUPD_OSSUPL1_Msk = 0x20000
	// Bit OSSUPL1.
	PWM_OSSUPD_OSSUPL1 = 0x20000
	// Position of OSSUPL2 field.
	PWM_OSSUPD_OSSUPL2_Pos = 0x12
	// Bit mask of OSSUPL2 field.
	PWM_OSSUPD_OSSUPL2_Msk = 0x40000
	// Bit OSSUPL2.
	PWM_OSSUPD_OSSUPL2 = 0x40000
	// Position of OSSUPL3 field.
	PWM_OSSUPD_OSSUPL3_Pos = 0x13
	// Bit mask of OSSUPL3 field.
	PWM_OSSUPD_OSSUPL3_Msk = 0x80000
	// Bit OSSUPL3.
	PWM_OSSUPD_OSSUPL3 = 0x80000

	// OSCUPD: PWM Output Selection Clear Update Register
	// Position of OSCUPH0 field.
	PWM_OSCUPD_OSCUPH0_Pos = 0x0
	// Bit mask of OSCUPH0 field.
	PWM_OSCUPD_OSCUPH0_Msk = 0x1
	// Bit OSCUPH0.
	PWM_OSCUPD_OSCUPH0 = 0x1
	// Position of OSCUPH1 field.
	PWM_OSCUPD_OSCUPH1_Pos = 0x1
	// Bit mask of OSCUPH1 field.
	PWM_OSCUPD_OSCUPH1_Msk = 0x2
	// Bit OSCUPH1.
	PWM_OSCUPD_OSCUPH1 = 0x2
	// Position of OSCUPH2 field.
	PWM_OSCUPD_OSCUPH2_Pos = 0x2
	// Bit mask of OSCUPH2 field.
	PWM_OSCUPD_OSCUPH2_Msk = 0x4
	// Bit OSCUPH2.
	PWM_OSCUPD_OSCUPH2 = 0x4
	// Position of OSCUPH3 field.
	PWM_OSCUPD_OSCUPH3_Pos = 0x3
	// Bit mask of OSCUPH3 field.
	PWM_OSCUPD_OSCUPH3_Msk = 0x8
	// Bit OSCUPH3.
	PWM_OSCUPD_OSCUPH3 = 0x8
	// Position of OSCUPL0 field.
	PWM_OSCUPD_OSCUPL0_Pos = 0x10
	// Bit mask of OSCUPL0 field.
	PWM_OSCUPD_OSCUPL0_Msk = 0x10000
	// Bit OSCUPL0.
	PWM_OSCUPD_OSCUPL0 = 0x10000
	// Position of OSCUPL1 field.
	PWM_OSCUPD_OSCUPL1_Pos = 0x11
	// Bit mask of OSCUPL1 field.
	PWM_OSCUPD_OSCUPL1_Msk = 0x20000
	// Bit OSCUPL1.
	PWM_OSCUPD_OSCUPL1 = 0x20000
	// Position of OSCUPL2 field.
	PWM_OSCUPD_OSCUPL2_Pos = 0x12
	// Bit mask of OSCUPL2 field.
	PWM_OSCUPD_OSCUPL2_Msk = 0x40000
	// Bit OSCUPL2.
	PWM_OSCUPD_OSCUPL2 = 0x40000
	// Position of OSCUPL3 field.
	PWM_OSCUPD_OSCUPL3_Pos = 0x13
	// Bit mask of OSCUPL3 field.
	PWM_OSCUPD_OSCUPL3_Msk = 0x80000
	// Bit OSCUPL3.
	PWM_OSCUPD_OSCUPL3 = 0x80000

	// FMR: PWM Fault Mode Register
	// Position of FPOL field.
	PWM_FMR_FPOL_Pos = 0x0
	// Bit mask of FPOL field.
	PWM_FMR_FPOL_Msk = 0xff
	// Position of FMOD field.
	PWM_FMR_FMOD_Pos = 0x8
	// Bit mask of FMOD field.
	PWM_FMR_FMOD_Msk = 0xff00
	// Position of FFIL field.
	PWM_FMR_FFIL_Pos = 0x10
	// Bit mask of FFIL field.
	PWM_FMR_FFIL_Msk = 0xff0000

	// FSR: PWM Fault Status Register
	// Position of FIV field.
	PWM_FSR_FIV_Pos = 0x0
	// Bit mask of FIV field.
	PWM_FSR_FIV_Msk = 0xff
	// Position of FS field.
	PWM_FSR_FS_Pos = 0x8
	// Bit mask of FS field.
	PWM_FSR_FS_Msk = 0xff00

	// FCR: PWM Fault Clear Register
	// Position of FCLR field.
	PWM_FCR_FCLR_Pos = 0x0
	// Bit mask of FCLR field.
	PWM_FCR_FCLR_Msk = 0xff

	// FPV: PWM Fault Protection Value Register
	// Position of FPVH0 field.
	PWM_FPV_FPVH0_Pos = 0x0
	// Bit mask of FPVH0 field.
	PWM_FPV_FPVH0_Msk = 0x1
	// Bit FPVH0.
	PWM_FPV_FPVH0 = 0x1
	// Position of FPVH1 field.
	PWM_FPV_FPVH1_Pos = 0x1
	// Bit mask of FPVH1 field.
	PWM_FPV_FPVH1_Msk = 0x2
	// Bit FPVH1.
	PWM_FPV_FPVH1 = 0x2
	// Position of FPVH2 field.
	PWM_FPV_FPVH2_Pos = 0x2
	// Bit mask of FPVH2 field.
	PWM_FPV_FPVH2_Msk = 0x4
	// Bit FPVH2.
	PWM_FPV_FPVH2 = 0x4
	// Position of FPVH3 field.
	PWM_FPV_FPVH3_Pos = 0x3
	// Bit mask of FPVH3 field.
	PWM_FPV_FPVH3_Msk = 0x8
	// Bit FPVH3.
	PWM_FPV_FPVH3 = 0x8
	// Position of FPVL0 field.
	PWM_FPV_FPVL0_Pos = 0x10
	// Bit mask of FPVL0 field.
	PWM_FPV_FPVL0_Msk = 0x10000
	// Bit FPVL0.
	PWM_FPV_FPVL0 = 0x10000
	// Position of FPVL1 field.
	PWM_FPV_FPVL1_Pos = 0x11
	// Bit mask of FPVL1 field.
	PWM_FPV_FPVL1_Msk = 0x20000
	// Bit FPVL1.
	PWM_FPV_FPVL1 = 0x20000
	// Position of FPVL2 field.
	PWM_FPV_FPVL2_Pos = 0x12
	// Bit mask of FPVL2 field.
	PWM_FPV_FPVL2_Msk = 0x40000
	// Bit FPVL2.
	PWM_FPV_FPVL2 = 0x40000
	// Position of FPVL3 field.
	PWM_FPV_FPVL3_Pos = 0x13
	// Bit mask of FPVL3 field.
	PWM_FPV_FPVL3_Msk = 0x80000
	// Bit FPVL3.
	PWM_FPV_FPVL3 = 0x80000

	// FPE: PWM Fault Protection Enable Register
	// Position of FPE0 field.
	PWM_FPE_FPE0_Pos = 0x0
	// Bit mask of FPE0 field.
	PWM_FPE_FPE0_Msk = 0xff
	// Position of FPE1 field.
	PWM_FPE_FPE1_Pos = 0x8
	// Bit mask of FPE1 field.
	PWM_FPE_FPE1_Msk = 0xff00
	// Position of FPE2 field.
	PWM_FPE_FPE2_Pos = 0x10
	// Bit mask of FPE2 field.
	PWM_FPE_FPE2_Msk = 0xff0000
	// Position of FPE3 field.
	PWM_FPE_FPE3_Pos = 0x18
	// Bit mask of FPE3 field.
	PWM_FPE_FPE3_Msk = 0xff000000

	// ELMR: PWM Event Line 0 Mode Register
	// Position of CSEL0 field.
	PWM_ELMR_CSEL0_Pos = 0x0
	// Bit mask of CSEL0 field.
	PWM_ELMR_CSEL0_Msk = 0x1
	// Bit CSEL0.
	PWM_ELMR_CSEL0 = 0x1
	// Position of CSEL1 field.
	PWM_ELMR_CSEL1_Pos = 0x1
	// Bit mask of CSEL1 field.
	PWM_ELMR_CSEL1_Msk = 0x2
	// Bit CSEL1.
	PWM_ELMR_CSEL1 = 0x2
	// Position of CSEL2 field.
	PWM_ELMR_CSEL2_Pos = 0x2
	// Bit mask of CSEL2 field.
	PWM_ELMR_CSEL2_Msk = 0x4
	// Bit CSEL2.
	PWM_ELMR_CSEL2 = 0x4
	// Position of CSEL3 field.
	PWM_ELMR_CSEL3_Pos = 0x3
	// Bit mask of CSEL3 field.
	PWM_ELMR_CSEL3_Msk = 0x8
	// Bit CSEL3.
	PWM_ELMR_CSEL3 = 0x8
	// Position of CSEL4 field.
	PWM_ELMR_CSEL4_Pos = 0x4
	// Bit mask of CSEL4 field.
	PWM_ELMR_CSEL4_Msk = 0x10
	// Bit CSEL4.
	PWM_ELMR_CSEL4 = 0x10
	// Position of CSEL5 field.
	PWM_ELMR_CSEL5_Pos = 0x5
	// Bit mask of CSEL5 field.
	PWM_ELMR_CSEL5_Msk = 0x20
	// Bit CSEL5.
	PWM_ELMR_CSEL5 = 0x20
	// Position of CSEL6 field.
	PWM_ELMR_CSEL6_Pos = 0x6
	// Bit mask of CSEL6 field.
	PWM_ELMR_CSEL6_Msk = 0x40
	// Bit CSEL6.
	PWM_ELMR_CSEL6 = 0x40
	// Position of CSEL7 field.
	PWM_ELMR_CSEL7_Pos = 0x7
	// Bit mask of CSEL7 field.
	PWM_ELMR_CSEL7_Msk = 0x80
	// Bit CSEL7.
	PWM_ELMR_CSEL7 = 0x80

	// SMMR: PWM Stepper Motor Mode Register
	// Position of GCEN0 field.
	PWM_SMMR_GCEN0_Pos = 0x0
	// Bit mask of GCEN0 field.
	PWM_SMMR_GCEN0_Msk = 0x1
	// Bit GCEN0.
	PWM_SMMR_GCEN0 = 0x1
	// Position of GCEN1 field.
	PWM_SMMR_GCEN1_Pos = 0x1
	// Bit mask of GCEN1 field.
	PWM_SMMR_GCEN1_Msk = 0x2
	// Bit GCEN1.
	PWM_SMMR_GCEN1 = 0x2
	// Position of DOWN0 field.
	PWM_SMMR_DOWN0_Pos = 0x10
	// Bit mask of DOWN0 field.
	PWM_SMMR_DOWN0_Msk = 0x10000
	// Bit DOWN0.
	PWM_SMMR_DOWN0 = 0x10000
	// Position of DOWN1 field.
	PWM_SMMR_DOWN1_Pos = 0x11
	// Bit mask of DOWN1 field.
	PWM_SMMR_DOWN1_Msk = 0x20000
	// Bit DOWN1.
	PWM_SMMR_DOWN1 = 0x20000

	// WPCR: PWM Write Protect Control Register
	// Position of WPCMD field.
	PWM_WPCR_WPCMD_Pos = 0x0
	// Bit mask of WPCMD field.
	PWM_WPCR_WPCMD_Msk = 0x3
	// Position of WPRG0 field.
	PWM_WPCR_WPRG0_Pos = 0x2
	// Bit mask of WPRG0 field.
	PWM_WPCR_WPRG0_Msk = 0x4
	// Bit WPRG0.
	PWM_WPCR_WPRG0 = 0x4
	// Position of WPRG1 field.
	PWM_WPCR_WPRG1_Pos = 0x3
	// Bit mask of WPRG1 field.
	PWM_WPCR_WPRG1_Msk = 0x8
	// Bit WPRG1.
	PWM_WPCR_WPRG1 = 0x8
	// Position of WPRG2 field.
	PWM_WPCR_WPRG2_Pos = 0x4
	// Bit mask of WPRG2 field.
	PWM_WPCR_WPRG2_Msk = 0x10
	// Bit WPRG2.
	PWM_WPCR_WPRG2 = 0x10
	// Position of WPRG3 field.
	PWM_WPCR_WPRG3_Pos = 0x5
	// Bit mask of WPRG3 field.
	PWM_WPCR_WPRG3_Msk = 0x20
	// Bit WPRG3.
	PWM_WPCR_WPRG3 = 0x20
	// Position of WPRG4 field.
	PWM_WPCR_WPRG4_Pos = 0x6
	// Bit mask of WPRG4 field.
	PWM_WPCR_WPRG4_Msk = 0x40
	// Bit WPRG4.
	PWM_WPCR_WPRG4 = 0x40
	// Position of WPRG5 field.
	PWM_WPCR_WPRG5_Pos = 0x7
	// Bit mask of WPRG5 field.
	PWM_WPCR_WPRG5_Msk = 0x80
	// Bit WPRG5.
	PWM_WPCR_WPRG5 = 0x80
	// Position of WPKEY field.
	PWM_WPCR_WPKEY_Pos = 0x8
	// Bit mask of WPKEY field.
	PWM_WPCR_WPKEY_Msk = 0xffffff00

	// WPSR: PWM Write Protect Status Register
	// Position of WPSWS0 field.
	PWM_WPSR_WPSWS0_Pos = 0x0
	// Bit mask of WPSWS0 field.
	PWM_WPSR_WPSWS0_Msk = 0x1
	// Bit WPSWS0.
	PWM_WPSR_WPSWS0 = 0x1
	// Position of WPSWS1 field.
	PWM_WPSR_WPSWS1_Pos = 0x1
	// Bit mask of WPSWS1 field.
	PWM_WPSR_WPSWS1_Msk = 0x2
	// Bit WPSWS1.
	PWM_WPSR_WPSWS1 = 0x2
	// Position of WPSWS2 field.
	PWM_WPSR_WPSWS2_Pos = 0x2
	// Bit mask of WPSWS2 field.
	PWM_WPSR_WPSWS2_Msk = 0x4
	// Bit WPSWS2.
	PWM_WPSR_WPSWS2 = 0x4
	// Position of WPSWS3 field.
	PWM_WPSR_WPSWS3_Pos = 0x3
	// Bit mask of WPSWS3 field.
	PWM_WPSR_WPSWS3_Msk = 0x8
	// Bit WPSWS3.
	PWM_WPSR_WPSWS3 = 0x8
	// Position of WPSWS4 field.
	PWM_WPSR_WPSWS4_Pos = 0x4
	// Bit mask of WPSWS4 field.
	PWM_WPSR_WPSWS4_Msk = 0x10
	// Bit WPSWS4.
	PWM_WPSR_WPSWS4 = 0x10
	// Position of WPSWS5 field.
	PWM_WPSR_WPSWS5_Pos = 0x5
	// Bit mask of WPSWS5 field.
	PWM_WPSR_WPSWS5_Msk = 0x20
	// Bit WPSWS5.
	PWM_WPSR_WPSWS5 = 0x20
	// Position of WPVS field.
	PWM_WPSR_WPVS_Pos = 0x7
	// Bit mask of WPVS field.
	PWM_WPSR_WPVS_Msk = 0x80
	// Bit WPVS.
	PWM_WPSR_WPVS = 0x80
	// Position of WPHWS0 field.
	PWM_WPSR_WPHWS0_Pos = 0x8
	// Bit mask of WPHWS0 field.
	PWM_WPSR_WPHWS0_Msk = 0x100
	// Bit WPHWS0.
	PWM_WPSR_WPHWS0 = 0x100
	// Position of WPHWS1 field.
	PWM_WPSR_WPHWS1_Pos = 0x9
	// Bit mask of WPHWS1 field.
	PWM_WPSR_WPHWS1_Msk = 0x200
	// Bit WPHWS1.
	PWM_WPSR_WPHWS1 = 0x200
	// Position of WPHWS2 field.
	PWM_WPSR_WPHWS2_Pos = 0xa
	// Bit mask of WPHWS2 field.
	PWM_WPSR_WPHWS2_Msk = 0x400
	// Bit WPHWS2.
	PWM_WPSR_WPHWS2 = 0x400
	// Position of WPHWS3 field.
	PWM_WPSR_WPHWS3_Pos = 0xb
	// Bit mask of WPHWS3 field.
	PWM_WPSR_WPHWS3_Msk = 0x800
	// Bit WPHWS3.
	PWM_WPSR_WPHWS3 = 0x800
	// Position of WPHWS4 field.
	PWM_WPSR_WPHWS4_Pos = 0xc
	// Bit mask of WPHWS4 field.
	PWM_WPSR_WPHWS4_Msk = 0x1000
	// Bit WPHWS4.
	PWM_WPSR_WPHWS4 = 0x1000
	// Position of WPHWS5 field.
	PWM_WPSR_WPHWS5_Pos = 0xd
	// Bit mask of WPHWS5 field.
	PWM_WPSR_WPHWS5_Msk = 0x2000
	// Bit WPHWS5.
	PWM_WPSR_WPHWS5 = 0x2000
	// Position of WPVSRC field.
	PWM_WPSR_WPVSRC_Pos = 0x10
	// Bit mask of WPVSRC field.
	PWM_WPSR_WPVSRC_Msk = 0xffff0000

	// TPR: Transmit Pointer Register
	// Position of TXPTR field.
	PWM_TPR_TXPTR_Pos = 0x0
	// Bit mask of TXPTR field.
	PWM_TPR_TXPTR_Msk = 0xffffffff

	// TCR: Transmit Counter Register
	// Position of TXCTR field.
	PWM_TCR_TXCTR_Pos = 0x0
	// Bit mask of TXCTR field.
	PWM_TCR_TXCTR_Msk = 0xffff

	// TNPR: Transmit Next Pointer Register
	// Position of TXNPTR field.
	PWM_TNPR_TXNPTR_Pos = 0x0
	// Bit mask of TXNPTR field.
	PWM_TNPR_TXNPTR_Msk = 0xffffffff

	// TNCR: Transmit Next Counter Register
	// Position of TXNCTR field.
	PWM_TNCR_TXNCTR_Pos = 0x0
	// Bit mask of TXNCTR field.
	PWM_TNCR_TXNCTR_Msk = 0xffff

	// PTCR: Transfer Control Register
	// Position of RXTEN field.
	PWM_PTCR_RXTEN_Pos = 0x0
	// Bit mask of RXTEN field.
	PWM_PTCR_RXTEN_Msk = 0x1
	// Bit RXTEN.
	PWM_PTCR_RXTEN = 0x1
	// Position of RXTDIS field.
	PWM_PTCR_RXTDIS_Pos = 0x1
	// Bit mask of RXTDIS field.
	PWM_PTCR_RXTDIS_Msk = 0x2
	// Bit RXTDIS.
	PWM_PTCR_RXTDIS = 0x2
	// Position of TXTEN field.
	PWM_PTCR_TXTEN_Pos = 0x8
	// Bit mask of TXTEN field.
	PWM_PTCR_TXTEN_Msk = 0x100
	// Bit TXTEN.
	PWM_PTCR_TXTEN = 0x100
	// Position of TXTDIS field.
	PWM_PTCR_TXTDIS_Pos = 0x9
	// Bit mask of TXTDIS field.
	PWM_PTCR_TXTDIS_Msk = 0x200
	// Bit TXTDIS.
	PWM_PTCR_TXTDIS = 0x200

	// PTSR: Transfer Status Register
	// Position of RXTEN field.
	PWM_PTSR_RXTEN_Pos = 0x0
	// Bit mask of RXTEN field.
	PWM_PTSR_RXTEN_Msk = 0x1
	// Bit RXTEN.
	PWM_PTSR_RXTEN = 0x1
	// Position of TXTEN field.
	PWM_PTSR_TXTEN_Pos = 0x8
	// Bit mask of TXTEN field.
	PWM_PTSR_TXTEN_Msk = 0x100
	// Bit TXTEN.
	PWM_PTSR_TXTEN = 0x100

	// CMPV0: PWM Comparison 0 Value Register
	// Position of CV field.
	PWM_CMPV0_CV_Pos = 0x0
	// Bit mask of CV field.
	PWM_CMPV0_CV_Msk = 0xffffff
	// Position of CVM field.
	PWM_CMPV0_CVM_Pos = 0x18
	// Bit mask of CVM field.
	PWM_CMPV0_CVM_Msk = 0x1000000
	// Bit CVM.
	PWM_CMPV0_CVM = 0x1000000

	// CMPVUPD0: PWM Comparison 0 Value Update Register
	// Position of CVUPD field.
	PWM_CMPVUPD0_CVUPD_Pos = 0x0
	// Bit mask of CVUPD field.
	PWM_CMPVUPD0_CVUPD_Msk = 0xffffff
	// Position of CVMUPD field.
	PWM_CMPVUPD0_CVMUPD_Pos = 0x18
	// Bit mask of CVMUPD field.
	PWM_CMPVUPD0_CVMUPD_Msk = 0x1000000
	// Bit CVMUPD.
	PWM_CMPVUPD0_CVMUPD = 0x1000000

	// CMPM0: PWM Comparison 0 Mode Register
	// Position of CEN field.
	PWM_CMPM0_CEN_Pos = 0x0
	// Bit mask of CEN field.
	PWM_CMPM0_CEN_Msk = 0x1
	// Bit CEN.
	PWM_CMPM0_CEN = 0x1
	// Position of CTR field.
	PWM_CMPM0_CTR_Pos = 0x4
	// Bit mask of CTR field.
	PWM_CMPM0_CTR_Msk = 0xf0
	// Position of CPR field.
	PWM_CMPM0_CPR_Pos = 0x8
	// Bit mask of CPR field.
	PWM_CMPM0_CPR_Msk = 0xf00
	// Position of CPRCNT field.
	PWM_CMPM0_CPRCNT_Pos = 0xc
	// Bit mask of CPRCNT field.
	PWM_CMPM0_CPRCNT_Msk = 0xf000
	// Position of CUPR field.
	PWM_CMPM0_CUPR_Pos = 0x10
	// Bit mask of CUPR field.
	PWM_CMPM0_CUPR_Msk = 0xf0000
	// Position of CUPRCNT field.
	PWM_CMPM0_CUPRCNT_Pos = 0x14
	// Bit mask of CUPRCNT field.
	PWM_CMPM0_CUPRCNT_Msk = 0xf00000

	// CMPMUPD0: PWM Comparison 0 Mode Update Register
	// Position of CENUPD field.
	PWM_CMPMUPD0_CENUPD_Pos = 0x0
	// Bit mask of CENUPD field.
	PWM_CMPMUPD0_CENUPD_Msk = 0x1
	// Bit CENUPD.
	PWM_CMPMUPD0_CENUPD = 0x1
	// Position of CTRUPD field.
	PWM_CMPMUPD0_CTRUPD_Pos = 0x4
	// Bit mask of CTRUPD field.
	PWM_CMPMUPD0_CTRUPD_Msk = 0xf0
	// Position of CPRUPD field.
	PWM_CMPMUPD0_CPRUPD_Pos = 0x8
	// Bit mask of CPRUPD field.
	PWM_CMPMUPD0_CPRUPD_Msk = 0xf00
	// Position of CUPRUPD field.
	PWM_CMPMUPD0_CUPRUPD_Pos = 0x10
	// Bit mask of CUPRUPD field.
	PWM_CMPMUPD0_CUPRUPD_Msk = 0xf0000

	// CMPV1: PWM Comparison 1 Value Register
	// Position of CV field.
	PWM_CMPV1_CV_Pos = 0x0
	// Bit mask of CV field.
	PWM_CMPV1_CV_Msk = 0xffffff
	// Position of CVM field.
	PWM_CMPV1_CVM_Pos = 0x18
	// Bit mask of CVM field.
	PWM_CMPV1_CVM_Msk = 0x1000000
	// Bit CVM.
	PWM_CMPV1_CVM = 0x1000000

	// CMPVUPD1: PWM Comparison 1 Value Update Register
	// Position of CVUPD field.
	PWM_CMPVUPD1_CVUPD_Pos = 0x0
	// Bit mask of CVUPD field.
	PWM_CMPVUPD1_CVUPD_Msk = 0xffffff
	// Position of CVMUPD field.
	PWM_CMPVUPD1_CVMUPD_Pos = 0x18
	// Bit mask of CVMUPD field.
	PWM_CMPVUPD1_CVMUPD_Msk = 0x1000000
	// Bit CVMUPD.
	PWM_CMPVUPD1_CVMUPD = 0x1000000

	// CMPM1: PWM Comparison 1 Mode Register
	// Position of CEN field.
	PWM_CMPM1_CEN_Pos = 0x0
	// Bit mask of CEN field.
	PWM_CMPM1_CEN_Msk = 0x1
	// Bit CEN.
	PWM_CMPM1_CEN = 0x1
	// Position of CTR field.
	PWM_CMPM1_CTR_Pos = 0x4
	// Bit mask of CTR field.
	PWM_CMPM1_CTR_Msk = 0xf0
	// Position of CPR field.
	PWM_CMPM1_CPR_Pos = 0x8
	// Bit mask of CPR field.
	PWM_CMPM1_CPR_Msk = 0xf00
	// Position of CPRCNT field.
	PWM_CMPM1_CPRCNT_Pos = 0xc
	// Bit mask of CPRCNT field.
	PWM_CMPM1_CPRCNT_Msk = 0xf000
	// Position of CUPR field.
	PWM_CMPM1_CUPR_Pos = 0x10
	// Bit mask of CUPR field.
	PWM_CMPM1_CUPR_Msk = 0xf0000
	// Position of CUPRCNT field.
	PWM_CMPM1_CUPRCNT_Pos = 0x14
	// Bit mask of CUPRCNT field.
	PWM_CMPM1_CUPRCNT_Msk = 0xf00000

	// CMPMUPD1: PWM Comparison 1 Mode Update Register
	// Position of CENUPD field.
	PWM_CMPMUPD1_CENUPD_Pos = 0x0
	// Bit mask of CENUPD field.
	PWM_CMPMUPD1_CENUPD_Msk = 0x1
	// Bit CENUPD.
	PWM_CMPMUPD1_CENUPD = 0x1
	// Position of CTRUPD field.
	PWM_CMPMUPD1_CTRUPD_Pos = 0x4
	// Bit mask of CTRUPD field.
	PWM_CMPMUPD1_CTRUPD_Msk = 0xf0
	// Position of CPRUPD field.
	PWM_CMPMUPD1_CPRUPD_Pos = 0x8
	// Bit mask of CPRUPD field.
	PWM_CMPMUPD1_CPRUPD_Msk = 0xf00
	// Position of CUPRUPD field.
	PWM_CMPMUPD1_CUPRUPD_Pos = 0x10
	// Bit mask of CUPRUPD field.
	PWM_CMPMUPD1_CUPRUPD_Msk = 0xf0000

	// CMPV2: PWM Comparison 2 Value Register
	// Position of CV field.
	PWM_CMPV2_CV_Pos = 0x0
	// Bit mask of CV field.
	PWM_CMPV2_CV_Msk = 0xffffff
	// Position of CVM field.
	PWM_CMPV2_CVM_Pos = 0x18
	// Bit mask of CVM field.
	PWM_CMPV2_CVM_Msk = 0x1000000
	// Bit CVM.
	PWM_CMPV2_CVM = 0x1000000

	// CMPVUPD2: PWM Comparison 2 Value Update Register
	// Position of CVUPD field.
	PWM_CMPVUPD2_CVUPD_Pos = 0x0
	// Bit mask of CVUPD field.
	PWM_CMPVUPD2_CVUPD_Msk = 0xffffff
	// Position of CVMUPD field.
	PWM_CMPVUPD2_CVMUPD_Pos = 0x18
	// Bit mask of CVMUPD field.
	PWM_CMPVUPD2_CVMUPD_Msk = 0x1000000
	// Bit CVMUPD.
	PWM_CMPVUPD2_CVMUPD = 0x1000000

	// CMPM2: PWM Comparison 2 Mode Register
	// Position of CEN field.
	PWM_CMPM2_CEN_Pos = 0x0
	// Bit mask of CEN field.
	PWM_CMPM2_CEN_Msk = 0x1
	// Bit CEN.
	PWM_CMPM2_CEN = 0x1
	// Position of CTR field.
	PWM_CMPM2_CTR_Pos = 0x4
	// Bit mask of CTR field.
	PWM_CMPM2_CTR_Msk = 0xf0
	// Position of CPR field.
	PWM_CMPM2_CPR_Pos = 0x8
	// Bit mask of CPR field.
	PWM_CMPM2_CPR_Msk = 0xf00
	// Position of CPRCNT field.
	PWM_CMPM2_CPRCNT_Pos = 0xc
	// Bit mask of CPRCNT field.
	PWM_CMPM2_CPRCNT_Msk = 0xf000
	// Position of CUPR field.
	PWM_CMPM2_CUPR_Pos = 0x10
	// Bit mask of CUPR field.
	PWM_CMPM2_CUPR_Msk = 0xf0000
	// Position of CUPRCNT field.
	PWM_CMPM2_CUPRCNT_Pos = 0x14
	// Bit mask of CUPRCNT field.
	PWM_CMPM2_CUPRCNT_Msk = 0xf00000

	// CMPMUPD2: PWM Comparison 2 Mode Update Register
	// Position of CENUPD field.
	PWM_CMPMUPD2_CENUPD_Pos = 0x0
	// Bit mask of CENUPD field.
	PWM_CMPMUPD2_CENUPD_Msk = 0x1
	// Bit CENUPD.
	PWM_CMPMUPD2_CENUPD = 0x1
	// Position of CTRUPD field.
	PWM_CMPMUPD2_CTRUPD_Pos = 0x4
	// Bit mask of CTRUPD field.
	PWM_CMPMUPD2_CTRUPD_Msk = 0xf0
	// Position of CPRUPD field.
	PWM_CMPMUPD2_CPRUPD_Pos = 0x8
	// Bit mask of CPRUPD field.
	PWM_CMPMUPD2_CPRUPD_Msk = 0xf00
	// Position of CUPRUPD field.
	PWM_CMPMUPD2_CUPRUPD_Pos = 0x10
	// Bit mask of CUPRUPD field.
	PWM_CMPMUPD2_CUPRUPD_Msk = 0xf0000

	// CMPV3: PWM Comparison 3 Value Register
	// Position of CV field.
	PWM_CMPV3_CV_Pos = 0x0
	// Bit mask of CV field.
	PWM_CMPV3_CV_Msk = 0xffffff
	// Position of CVM field.
	PWM_CMPV3_CVM_Pos = 0x18
	// Bit mask of CVM field.
	PWM_CMPV3_CVM_Msk = 0x1000000
	// Bit CVM.
	PWM_CMPV3_CVM = 0x1000000

	// CMPVUPD3: PWM Comparison 3 Value Update Register
	// Position of CVUPD field.
	PWM_CMPVUPD3_CVUPD_Pos = 0x0
	// Bit mask of CVUPD field.
	PWM_CMPVUPD3_CVUPD_Msk = 0xffffff
	// Position of CVMUPD field.
	PWM_CMPVUPD3_CVMUPD_Pos = 0x18
	// Bit mask of CVMUPD field.
	PWM_CMPVUPD3_CVMUPD_Msk = 0x1000000
	// Bit CVMUPD.
	PWM_CMPVUPD3_CVMUPD = 0x1000000

	// CMPM3: PWM Comparison 3 Mode Register
	// Position of CEN field.
	PWM_CMPM3_CEN_Pos = 0x0
	// Bit mask of CEN field.
	PWM_CMPM3_CEN_Msk = 0x1
	// Bit CEN.
	PWM_CMPM3_CEN = 0x1
	// Position of CTR field.
	PWM_CMPM3_CTR_Pos = 0x4
	// Bit mask of CTR field.
	PWM_CMPM3_CTR_Msk = 0xf0
	// Position of CPR field.
	PWM_CMPM3_CPR_Pos = 0x8
	// Bit mask of CPR field.
	PWM_CMPM3_CPR_Msk = 0xf00
	// Position of CPRCNT field.
	PWM_CMPM3_CPRCNT_Pos = 0xc
	// Bit mask of CPRCNT field.
	PWM_CMPM3_CPRCNT_Msk = 0xf000
	// Position of CUPR field.
	PWM_CMPM3_CUPR_Pos = 0x10
	// Bit mask of CUPR field.
	PWM_CMPM3_CUPR_Msk = 0xf0000
	// Position of CUPRCNT field.
	PWM_CMPM3_CUPRCNT_Pos = 0x14
	// Bit mask of CUPRCNT field.
	PWM_CMPM3_CUPRCNT_Msk = 0xf00000

	// CMPMUPD3: PWM Comparison 3 Mode Update Register
	// Position of CENUPD field.
	PWM_CMPMUPD3_CENUPD_Pos = 0x0
	// Bit mask of CENUPD field.
	PWM_CMPMUPD3_CENUPD_Msk = 0x1
	// Bit CENUPD.
	PWM_CMPMUPD3_CENUPD = 0x1
	// Position of CTRUPD field.
	PWM_CMPMUPD3_CTRUPD_Pos = 0x4
	// Bit mask of CTRUPD field.
	PWM_CMPMUPD3_CTRUPD_Msk = 0xf0
	// Position of CPRUPD field.
	PWM_CMPMUPD3_CPRUPD_Pos = 0x8
	// Bit mask of CPRUPD field.
	PWM_CMPMUPD3_CPRUPD_Msk = 0xf00
	// Position of CUPRUPD field.
	PWM_CMPMUPD3_CUPRUPD_Pos = 0x10
	// Bit mask of CUPRUPD field.
	PWM_CMPMUPD3_CUPRUPD_Msk = 0xf0000

	// CMPV4: PWM Comparison 4 Value Register
	// Position of CV field.
	PWM_CMPV4_CV_Pos = 0x0
	// Bit mask of CV field.
	PWM_CMPV4_CV_Msk = 0xffffff
	// Position of CVM field.
	PWM_CMPV4_CVM_Pos = 0x18
	// Bit mask of CVM field.
	PWM_CMPV4_CVM_Msk = 0x1000000
	// Bit CVM.
	PWM_CMPV4_CVM = 0x1000000

	// CMPVUPD4: PWM Comparison 4 Value Update Register
	// Position of CVUPD field.
	PWM_CMPVUPD4_CVUPD_Pos = 0x0
	// Bit mask of CVUPD field.
	PWM_CMPVUPD4_CVUPD_Msk = 0xffffff
	// Position of CVMUPD field.
	PWM_CMPVUPD4_CVMUPD_Pos = 0x18
	// Bit mask of CVMUPD field.
	PWM_CMPVUPD4_CVMUPD_Msk = 0x1000000
	// Bit CVMUPD.
	PWM_CMPVUPD4_CVMUPD = 0x1000000

	// CMPM4: PWM Comparison 4 Mode Register
	// Position of CEN field.
	PWM_CMPM4_CEN_Pos = 0x0
	// Bit mask of CEN field.
	PWM_CMPM4_CEN_Msk = 0x1
	// Bit CEN.
	PWM_CMPM4_CEN = 0x1
	// Position of CTR field.
	PWM_CMPM4_CTR_Pos = 0x4
	// Bit mask of CTR field.
	PWM_CMPM4_CTR_Msk = 0xf0
	// Position of CPR field.
	PWM_CMPM4_CPR_Pos = 0x8
	// Bit mask of CPR field.
	PWM_CMPM4_CPR_Msk = 0xf00
	// Position of CPRCNT field.
	PWM_CMPM4_CPRCNT_Pos = 0xc
	// Bit mask of CPRCNT field.
	PWM_CMPM4_CPRCNT_Msk = 0xf000
	// Position of CUPR field.
	PWM_CMPM4_CUPR_Pos = 0x10
	// Bit mask of CUPR field.
	PWM_CMPM4_CUPR_Msk = 0xf0000
	// Position of CUPRCNT field.
	PWM_CMPM4_CUPRCNT_Pos = 0x14
	// Bit mask of CUPRCNT field.
	PWM_CMPM4_CUPRCNT_Msk = 0xf00000

	// CMPMUPD4: PWM Comparison 4 Mode Update Register
	// Position of CENUPD field.
	PWM_CMPMUPD4_CENUPD_Pos = 0x0
	// Bit mask of CENUPD field.
	PWM_CMPMUPD4_CENUPD_Msk = 0x1
	// Bit CENUPD.
	PWM_CMPMUPD4_CENUPD = 0x1
	// Position of CTRUPD field.
	PWM_CMPMUPD4_CTRUPD_Pos = 0x4
	// Bit mask of CTRUPD field.
	PWM_CMPMUPD4_CTRUPD_Msk = 0xf0
	// Position of CPRUPD field.
	PWM_CMPMUPD4_CPRUPD_Pos = 0x8
	// Bit mask of CPRUPD field.
	PWM_CMPMUPD4_CPRUPD_Msk = 0xf00
	// Position of CUPRUPD field.
	PWM_CMPMUPD4_CUPRUPD_Pos = 0x10
	// Bit mask of CUPRUPD field.
	PWM_CMPMUPD4_CUPRUPD_Msk = 0xf0000

	// CMPV5: PWM Comparison 5 Value Register
	// Position of CV field.
	PWM_CMPV5_CV_Pos = 0x0
	// Bit mask of CV field.
	PWM_CMPV5_CV_Msk = 0xffffff
	// Position of CVM field.
	PWM_CMPV5_CVM_Pos = 0x18
	// Bit mask of CVM field.
	PWM_CMPV5_CVM_Msk = 0x1000000
	// Bit CVM.
	PWM_CMPV5_CVM = 0x1000000

	// CMPVUPD5: PWM Comparison 5 Value Update Register
	// Position of CVUPD field.
	PWM_CMPVUPD5_CVUPD_Pos = 0x0
	// Bit mask of CVUPD field.
	PWM_CMPVUPD5_CVUPD_Msk = 0xffffff
	// Position of CVMUPD field.
	PWM_CMPVUPD5_CVMUPD_Pos = 0x18
	// Bit mask of CVMUPD field.
	PWM_CMPVUPD5_CVMUPD_Msk = 0x1000000
	// Bit CVMUPD.
	PWM_CMPVUPD5_CVMUPD = 0x1000000

	// CMPM5: PWM Comparison 5 Mode Register
	// Position of CEN field.
	PWM_CMPM5_CEN_Pos = 0x0
	// Bit mask of CEN field.
	PWM_CMPM5_CEN_Msk = 0x1
	// Bit CEN.
	PWM_CMPM5_CEN = 0x1
	// Position of CTR field.
	PWM_CMPM5_CTR_Pos = 0x4
	// Bit mask of CTR field.
	PWM_CMPM5_CTR_Msk = 0xf0
	// Position of CPR field.
	PWM_CMPM5_CPR_Pos = 0x8
	// Bit mask of CPR field.
	PWM_CMPM5_CPR_Msk = 0xf00
	// Position of CPRCNT field.
	PWM_CMPM5_CPRCNT_Pos = 0xc
	// Bit mask of CPRCNT field.
	PWM_CMPM5_CPRCNT_Msk = 0xf000
	// Position of CUPR field.
	PWM_CMPM5_CUPR_Pos = 0x10
	// Bit mask of CUPR field.
	PWM_CMPM5_CUPR_Msk = 0xf0000
	// Position of CUPRCNT field.
	PWM_CMPM5_CUPRCNT_Pos = 0x14
	// Bit mask of CUPRCNT field.
	PWM_CMPM5_CUPRCNT_Msk = 0xf00000

	// CMPMUPD5: PWM Comparison 5 Mode Update Register
	// Position of CENUPD field.
	PWM_CMPMUPD5_CENUPD_Pos = 0x0
	// Bit mask of CENUPD field.
	PWM_CMPMUPD5_CENUPD_Msk = 0x1
	// Bit CENUPD.
	PWM_CMPMUPD5_CENUPD = 0x1
	// Position of CTRUPD field.
	PWM_CMPMUPD5_CTRUPD_Pos = 0x4
	// Bit mask of CTRUPD field.
	PWM_CMPMUPD5_CTRUPD_Msk = 0xf0
	// Position of CPRUPD field.
	PWM_CMPMUPD5_CPRUPD_Pos = 0x8
	// Bit mask of CPRUPD field.
	PWM_CMPMUPD5_CPRUPD_Msk = 0xf00
	// Position of CUPRUPD field.
	PWM_CMPMUPD5_CUPRUPD_Pos = 0x10
	// Bit mask of CUPRUPD field.
	PWM_CMPMUPD5_CUPRUPD_Msk = 0xf0000

	// CMPV6: PWM Comparison 6 Value Register
	// Position of CV field.
	PWM_CMPV6_CV_Pos = 0x0
	// Bit mask of CV field.
	PWM_CMPV6_CV_Msk = 0xffffff
	// Position of CVM field.
	PWM_CMPV6_CVM_Pos = 0x18
	// Bit mask of CVM field.
	PWM_CMPV6_CVM_Msk = 0x1000000
	// Bit CVM.
	PWM_CMPV6_CVM = 0x1000000

	// CMPVUPD6: PWM Comparison 6 Value Update Register
	// Position of CVUPD field.
	PWM_CMPVUPD6_CVUPD_Pos = 0x0
	// Bit mask of CVUPD field.
	PWM_CMPVUPD6_CVUPD_Msk = 0xffffff
	// Position of CVMUPD field.
	PWM_CMPVUPD6_CVMUPD_Pos = 0x18
	// Bit mask of CVMUPD field.
	PWM_CMPVUPD6_CVMUPD_Msk = 0x1000000
	// Bit CVMUPD.
	PWM_CMPVUPD6_CVMUPD = 0x1000000

	// CMPM6: PWM Comparison 6 Mode Register
	// Position of CEN field.
	PWM_CMPM6_CEN_Pos = 0x0
	// Bit mask of CEN field.
	PWM_CMPM6_CEN_Msk = 0x1
	// Bit CEN.
	PWM_CMPM6_CEN = 0x1
	// Position of CTR field.
	PWM_CMPM6_CTR_Pos = 0x4
	// Bit mask of CTR field.
	PWM_CMPM6_CTR_Msk = 0xf0
	// Position of CPR field.
	PWM_CMPM6_CPR_Pos = 0x8
	// Bit mask of CPR field.
	PWM_CMPM6_CPR_Msk = 0xf00
	// Position of CPRCNT field.
	PWM_CMPM6_CPRCNT_Pos = 0xc
	// Bit mask of CPRCNT field.
	PWM_CMPM6_CPRCNT_Msk = 0xf000
	// Position of CUPR field.
	PWM_CMPM6_CUPR_Pos = 0x10
	// Bit mask of CUPR field.
	PWM_CMPM6_CUPR_Msk = 0xf0000
	// Position of CUPRCNT field.
	PWM_CMPM6_CUPRCNT_Pos = 0x14
	// Bit mask of CUPRCNT field.
	PWM_CMPM6_CUPRCNT_Msk = 0xf00000

	// CMPMUPD6: PWM Comparison 6 Mode Update Register
	// Position of CENUPD field.
	PWM_CMPMUPD6_CENUPD_Pos = 0x0
	// Bit mask of CENUPD field.
	PWM_CMPMUPD6_CENUPD_Msk = 0x1
	// Bit CENUPD.
	PWM_CMPMUPD6_CENUPD = 0x1
	// Position of CTRUPD field.
	PWM_CMPMUPD6_CTRUPD_Pos = 0x4
	// Bit mask of CTRUPD field.
	PWM_CMPMUPD6_CTRUPD_Msk = 0xf0
	// Position of CPRUPD field.
	PWM_CMPMUPD6_CPRUPD_Pos = 0x8
	// Bit mask of CPRUPD field.
	PWM_CMPMUPD6_CPRUPD_Msk = 0xf00
	// Position of CUPRUPD field.
	PWM_CMPMUPD6_CUPRUPD_Pos = 0x10
	// Bit mask of CUPRUPD field.
	PWM_CMPMUPD6_CUPRUPD_Msk = 0xf0000

	// CMPV7: PWM Comparison 7 Value Register
	// Position of CV field.
	PWM_CMPV7_CV_Pos = 0x0
	// Bit mask of CV field.
	PWM_CMPV7_CV_Msk = 0xffffff
	// Position of CVM field.
	PWM_CMPV7_CVM_Pos = 0x18
	// Bit mask of CVM field.
	PWM_CMPV7_CVM_Msk = 0x1000000
	// Bit CVM.
	PWM_CMPV7_CVM = 0x1000000

	// CMPVUPD7: PWM Comparison 7 Value Update Register
	// Position of CVUPD field.
	PWM_CMPVUPD7_CVUPD_Pos = 0x0
	// Bit mask of CVUPD field.
	PWM_CMPVUPD7_CVUPD_Msk = 0xffffff
	// Position of CVMUPD field.
	PWM_CMPVUPD7_CVMUPD_Pos = 0x18
	// Bit mask of CVMUPD field.
	PWM_CMPVUPD7_CVMUPD_Msk = 0x1000000
	// Bit CVMUPD.
	PWM_CMPVUPD7_CVMUPD = 0x1000000

	// CMPM7: PWM Comparison 7 Mode Register
	// Position of CEN field.
	PWM_CMPM7_CEN_Pos = 0x0
	// Bit mask of CEN field.
	PWM_CMPM7_CEN_Msk = 0x1
	// Bit CEN.
	PWM_CMPM7_CEN = 0x1
	// Position of CTR field.
	PWM_CMPM7_CTR_Pos = 0x4
	// Bit mask of CTR field.
	PWM_CMPM7_CTR_Msk = 0xf0
	// Position of CPR field.
	PWM_CMPM7_CPR_Pos = 0x8
	// Bit mask of CPR field.
	PWM_CMPM7_CPR_Msk = 0xf00
	// Position of CPRCNT field.
	PWM_CMPM7_CPRCNT_Pos = 0xc
	// Bit mask of CPRCNT field.
	PWM_CMPM7_CPRCNT_Msk = 0xf000
	// Position of CUPR field.
	PWM_CMPM7_CUPR_Pos = 0x10
	// Bit mask of CUPR field.
	PWM_CMPM7_CUPR_Msk = 0xf0000
	// Position of CUPRCNT field.
	PWM_CMPM7_CUPRCNT_Pos = 0x14
	// Bit mask of CUPRCNT field.
	PWM_CMPM7_CUPRCNT_Msk = 0xf00000

	// CMPMUPD7: PWM Comparison 7 Mode Update Register
	// Position of CENUPD field.
	PWM_CMPMUPD7_CENUPD_Pos = 0x0
	// Bit mask of CENUPD field.
	PWM_CMPMUPD7_CENUPD_Msk = 0x1
	// Bit CENUPD.
	PWM_CMPMUPD7_CENUPD = 0x1
	// Position of CTRUPD field.
	PWM_CMPMUPD7_CTRUPD_Pos = 0x4
	// Bit mask of CTRUPD field.
	PWM_CMPMUPD7_CTRUPD_Msk = 0xf0
	// Position of CPRUPD field.
	PWM_CMPMUPD7_CPRUPD_Pos = 0x8
	// Bit mask of CPRUPD field.
	PWM_CMPMUPD7_CPRUPD_Msk = 0xf00
	// Position of CUPRUPD field.
	PWM_CMPMUPD7_CUPRUPD_Pos = 0x10
	// Bit mask of CUPRUPD field.
	PWM_CMPMUPD7_CUPRUPD_Msk = 0xf0000

	// CMR0: PWM Channel Mode Register (ch_num = 0)
	// Position of CPRE field.
	PWM_CMR0_CPRE_Pos = 0x0
	// Bit mask of CPRE field.
	PWM_CMR0_CPRE_Msk = 0xf
	// Master clock
	PWM_CMR0_CPRE_MCK = 0x0
	// Master clock/2
	PWM_CMR0_CPRE_MCK_DIV_2 = 0x1
	// Master clock/4
	PWM_CMR0_CPRE_MCK_DIV_4 = 0x2
	// Master clock/8
	PWM_CMR0_CPRE_MCK_DIV_8 = 0x3
	// Master clock/16
	PWM_CMR0_CPRE_MCK_DIV_16 = 0x4
	// Master clock/32
	PWM_CMR0_CPRE_MCK_DIV_32 = 0x5
	// Master clock/64
	PWM_CMR0_CPRE_MCK_DIV_64 = 0x6
	// Master clock/128
	PWM_CMR0_CPRE_MCK_DIV_128 = 0x7
	// Master clock/256
	PWM_CMR0_CPRE_MCK_DIV_256 = 0x8
	// Master clock/512
	PWM_CMR0_CPRE_MCK_DIV_512 = 0x9
	// Master clock/1024
	PWM_CMR0_CPRE_MCK_DIV_1024 = 0xa
	// Clock A
	PWM_CMR0_CPRE_CLKA = 0xb
	// Clock B
	PWM_CMR0_CPRE_CLKB = 0xc
	// Position of CALG field.
	PWM_CMR0_CALG_Pos = 0x8
	// Bit mask of CALG field.
	PWM_CMR0_CALG_Msk = 0x100
	// Bit CALG.
	PWM_CMR0_CALG = 0x100
	// Position of CPOL field.
	PWM_CMR0_CPOL_Pos = 0x9
	// Bit mask of CPOL field.
	PWM_CMR0_CPOL_Msk = 0x200
	// Bit CPOL.
	PWM_CMR0_CPOL = 0x200
	// Position of CES field.
	PWM_CMR0_CES_Pos = 0xa
	// Bit mask of CES field.
	PWM_CMR0_CES_Msk = 0x400
	// Bit CES.
	PWM_CMR0_CES = 0x400
	// Position of DTE field.
	PWM_CMR0_DTE_Pos = 0x10
	// Bit mask of DTE field.
	PWM_CMR0_DTE_Msk = 0x10000
	// Bit DTE.
	PWM_CMR0_DTE = 0x10000
	// Position of DTHI field.
	PWM_CMR0_DTHI_Pos = 0x11
	// Bit mask of DTHI field.
	PWM_CMR0_DTHI_Msk = 0x20000
	// Bit DTHI.
	PWM_CMR0_DTHI = 0x20000
	// Position of DTLI field.
	PWM_CMR0_DTLI_Pos = 0x12
	// Bit mask of DTLI field.
	PWM_CMR0_DTLI_Msk = 0x40000
	// Bit DTLI.
	PWM_CMR0_DTLI = 0x40000

	// CDTY0: PWM Channel Duty Cycle Register (ch_num = 0)
	// Position of CDTY field.
	PWM_CDTY0_CDTY_Pos = 0x0
	// Bit mask of CDTY field.
	PWM_CDTY0_CDTY_Msk = 0xffffff

	// CDTYUPD0: PWM Channel Duty Cycle Update Register (ch_num = 0)
	// Position of CDTYUPD field.
	PWM_CDTYUPD0_CDTYUPD_Pos = 0x0
	// Bit mask of CDTYUPD field.
	PWM_CDTYUPD0_CDTYUPD_Msk = 0xffffff

	// CPRD0: PWM Channel Period Register (ch_num = 0)
	// Position of CPRD field.
	PWM_CPRD0_CPRD_Pos = 0x0
	// Bit mask of CPRD field.
	PWM_CPRD0_CPRD_Msk = 0xffffff

	// CPRDUPD0: PWM Channel Period Update Register (ch_num = 0)
	// Position of CPRDUPD field.
	PWM_CPRDUPD0_CPRDUPD_Pos = 0x0
	// Bit mask of CPRDUPD field.
	PWM_CPRDUPD0_CPRDUPD_Msk = 0xffffff

	// CCNT0: PWM Channel Counter Register (ch_num = 0)
	// Position of CNT field.
	PWM_CCNT0_CNT_Pos = 0x0
	// Bit mask of CNT field.
	PWM_CCNT0_CNT_Msk = 0xffffff

	// DT0: PWM Channel Dead Time Register (ch_num = 0)
	// Position of DTH field.
	PWM_DT0_DTH_Pos = 0x0
	// Bit mask of DTH field.
	PWM_DT0_DTH_Msk = 0xffff
	// Position of DTL field.
	PWM_DT0_DTL_Pos = 0x10
	// Bit mask of DTL field.
	PWM_DT0_DTL_Msk = 0xffff0000

	// DTUPD0: PWM Channel Dead Time Update Register (ch_num = 0)
	// Position of DTHUPD field.
	PWM_DTUPD0_DTHUPD_Pos = 0x0
	// Bit mask of DTHUPD field.
	PWM_DTUPD0_DTHUPD_Msk = 0xffff
	// Position of DTLUPD field.
	PWM_DTUPD0_DTLUPD_Pos = 0x10
	// Bit mask of DTLUPD field.
	PWM_DTUPD0_DTLUPD_Msk = 0xffff0000

	// CMR1: PWM Channel Mode Register (ch_num = 1)
	// Position of CPRE field.
	PWM_CMR1_CPRE_Pos = 0x0
	// Bit mask of CPRE field.
	PWM_CMR1_CPRE_Msk = 0xf
	// Master clock
	PWM_CMR1_CPRE_MCK = 0x0
	// Master clock/2
	PWM_CMR1_CPRE_MCK_DIV_2 = 0x1
	// Master clock/4
	PWM_CMR1_CPRE_MCK_DIV_4 = 0x2
	// Master clock/8
	PWM_CMR1_CPRE_MCK_DIV_8 = 0x3
	// Master clock/16
	PWM_CMR1_CPRE_MCK_DIV_16 = 0x4
	// Master clock/32
	PWM_CMR1_CPRE_MCK_DIV_32 = 0x5
	// Master clock/64
	PWM_CMR1_CPRE_MCK_DIV_64 = 0x6
	// Master clock/128
	PWM_CMR1_CPRE_MCK_DIV_128 = 0x7
	// Master clock/256
	PWM_CMR1_CPRE_MCK_DIV_256 = 0x8
	// Master clock/512
	PWM_CMR1_CPRE_MCK_DIV_512 = 0x9
	// Master clock/1024
	PWM_CMR1_CPRE_MCK_DIV_1024 = 0xa
	// Clock A
	PWM_CMR1_CPRE_CLKA = 0xb
	// Clock B
	PWM_CMR1_CPRE_CLKB = 0xc
	// Position of CALG field.
	PWM_CMR1_CALG_Pos = 0x8
	// Bit mask of CALG field.
	PWM_CMR1_CALG_Msk = 0x100
	// Bit CALG.
	PWM_CMR1_CALG = 0x100
	// Position of CPOL field.
	PWM_CMR1_CPOL_Pos = 0x9
	// Bit mask of CPOL field.
	PWM_CMR1_CPOL_Msk = 0x200
	// Bit CPOL.
	PWM_CMR1_CPOL = 0x200
	// Position of CES field.
	PWM_CMR1_CES_Pos = 0xa
	// Bit mask of CES field.
	PWM_CMR1_CES_Msk = 0x400
	// Bit CES.
	PWM_CMR1_CES = 0x400
	// Position of DTE field.
	PWM_CMR1_DTE_Pos = 0x10
	// Bit mask of DTE field.
	PWM_CMR1_DTE_Msk = 0x10000
	// Bit DTE.
	PWM_CMR1_DTE = 0x10000
	// Position of DTHI field.
	PWM_CMR1_DTHI_Pos = 0x11
	// Bit mask of DTHI field.
	PWM_CMR1_DTHI_Msk = 0x20000
	// Bit DTHI.
	PWM_CMR1_DTHI = 0x20000
	// Position of DTLI field.
	PWM_CMR1_DTLI_Pos = 0x12
	// Bit mask of DTLI field.
	PWM_CMR1_DTLI_Msk = 0x40000
	// Bit DTLI.
	PWM_CMR1_DTLI = 0x40000

	// CDTY1: PWM Channel Duty Cycle Register (ch_num = 1)
	// Position of CDTY field.
	PWM_CDTY1_CDTY_Pos = 0x0
	// Bit mask of CDTY field.
	PWM_CDTY1_CDTY_Msk = 0xffffff

	// CDTYUPD1: PWM Channel Duty Cycle Update Register (ch_num = 1)
	// Position of CDTYUPD field.
	PWM_CDTYUPD1_CDTYUPD_Pos = 0x0
	// Bit mask of CDTYUPD field.
	PWM_CDTYUPD1_CDTYUPD_Msk = 0xffffff

	// CPRD1: PWM Channel Period Register (ch_num = 1)
	// Position of CPRD field.
	PWM_CPRD1_CPRD_Pos = 0x0
	// Bit mask of CPRD field.
	PWM_CPRD1_CPRD_Msk = 0xffffff

	// CPRDUPD1: PWM Channel Period Update Register (ch_num = 1)
	// Position of CPRDUPD field.
	PWM_CPRDUPD1_CPRDUPD_Pos = 0x0
	// Bit mask of CPRDUPD field.
	PWM_CPRDUPD1_CPRDUPD_Msk = 0xffffff

	// CCNT1: PWM Channel Counter Register (ch_num = 1)
	// Position of CNT field.
	PWM_CCNT1_CNT_Pos = 0x0
	// Bit mask of CNT field.
	PWM_CCNT1_CNT_Msk = 0xffffff

	// DT1: PWM Channel Dead Time Register (ch_num = 1)
	// Position of DTH field.
	PWM_DT1_DTH_Pos = 0x0
	// Bit mask of DTH field.
	PWM_DT1_DTH_Msk = 0xffff
	// Position of DTL field.
	PWM_DT1_DTL_Pos = 0x10
	// Bit mask of DTL field.
	PWM_DT1_DTL_Msk = 0xffff0000

	// DTUPD1: PWM Channel Dead Time Update Register (ch_num = 1)
	// Position of DTHUPD field.
	PWM_DTUPD1_DTHUPD_Pos = 0x0
	// Bit mask of DTHUPD field.
	PWM_DTUPD1_DTHUPD_Msk = 0xffff
	// Position of DTLUPD field.
	PWM_DTUPD1_DTLUPD_Pos = 0x10
	// Bit mask of DTLUPD field.
	PWM_DTUPD1_DTLUPD_Msk = 0xffff0000

	// CMR2: PWM Channel Mode Register (ch_num = 2)
	// Position of CPRE field.
	PWM_CMR2_CPRE_Pos = 0x0
	// Bit mask of CPRE field.
	PWM_CMR2_CPRE_Msk = 0xf
	// Master clock
	PWM_CMR2_CPRE_MCK = 0x0
	// Master clock/2
	PWM_CMR2_CPRE_MCK_DIV_2 = 0x1
	// Master clock/4
	PWM_CMR2_CPRE_MCK_DIV_4 = 0x2
	// Master clock/8
	PWM_CMR2_CPRE_MCK_DIV_8 = 0x3
	// Master clock/16
	PWM_CMR2_CPRE_MCK_DIV_16 = 0x4
	// Master clock/32
	PWM_CMR2_CPRE_MCK_DIV_32 = 0x5
	// Master clock/64
	PWM_CMR2_CPRE_MCK_DIV_64 = 0x6
	// Master clock/128
	PWM_CMR2_CPRE_MCK_DIV_128 = 0x7
	// Master clock/256
	PWM_CMR2_CPRE_MCK_DIV_256 = 0x8
	// Master clock/512
	PWM_CMR2_CPRE_MCK_DIV_512 = 0x9
	// Master clock/1024
	PWM_CMR2_CPRE_MCK_DIV_1024 = 0xa
	// Clock A
	PWM_CMR2_CPRE_CLKA = 0xb
	// Clock B
	PWM_CMR2_CPRE_CLKB = 0xc
	// Position of CALG field.
	PWM_CMR2_CALG_Pos = 0x8
	// Bit mask of CALG field.
	PWM_CMR2_CALG_Msk = 0x100
	// Bit CALG.
	PWM_CMR2_CALG = 0x100
	// Position of CPOL field.
	PWM_CMR2_CPOL_Pos = 0x9
	// Bit mask of CPOL field.
	PWM_CMR2_CPOL_Msk = 0x200
	// Bit CPOL.
	PWM_CMR2_CPOL = 0x200
	// Position of CES field.
	PWM_CMR2_CES_Pos = 0xa
	// Bit mask of CES field.
	PWM_CMR2_CES_Msk = 0x400
	// Bit CES.
	PWM_CMR2_CES = 0x400
	// Position of DTE field.
	PWM_CMR2_DTE_Pos = 0x10
	// Bit mask of DTE field.
	PWM_CMR2_DTE_Msk = 0x10000
	// Bit DTE.
	PWM_CMR2_DTE = 0x10000
	// Position of DTHI field.
	PWM_CMR2_DTHI_Pos = 0x11
	// Bit mask of DTHI field.
	PWM_CMR2_DTHI_Msk = 0x20000
	// Bit DTHI.
	PWM_CMR2_DTHI = 0x20000
	// Position of DTLI field.
	PWM_CMR2_DTLI_Pos = 0x12
	// Bit mask of DTLI field.
	PWM_CMR2_DTLI_Msk = 0x40000
	// Bit DTLI.
	PWM_CMR2_DTLI = 0x40000

	// CDTY2: PWM Channel Duty Cycle Register (ch_num = 2)
	// Position of CDTY field.
	PWM_CDTY2_CDTY_Pos = 0x0
	// Bit mask of CDTY field.
	PWM_CDTY2_CDTY_Msk = 0xffffff

	// CDTYUPD2: PWM Channel Duty Cycle Update Register (ch_num = 2)
	// Position of CDTYUPD field.
	PWM_CDTYUPD2_CDTYUPD_Pos = 0x0
	// Bit mask of CDTYUPD field.
	PWM_CDTYUPD2_CDTYUPD_Msk = 0xffffff

	// CPRD2: PWM Channel Period Register (ch_num = 2)
	// Position of CPRD field.
	PWM_CPRD2_CPRD_Pos = 0x0
	// Bit mask of CPRD field.
	PWM_CPRD2_CPRD_Msk = 0xffffff

	// CPRDUPD2: PWM Channel Period Update Register (ch_num = 2)
	// Position of CPRDUPD field.
	PWM_CPRDUPD2_CPRDUPD_Pos = 0x0
	// Bit mask of CPRDUPD field.
	PWM_CPRDUPD2_CPRDUPD_Msk = 0xffffff

	// CCNT2: PWM Channel Counter Register (ch_num = 2)
	// Position of CNT field.
	PWM_CCNT2_CNT_Pos = 0x0
	// Bit mask of CNT field.
	PWM_CCNT2_CNT_Msk = 0xffffff

	// DT2: PWM Channel Dead Time Register (ch_num = 2)
	// Position of DTH field.
	PWM_DT2_DTH_Pos = 0x0
	// Bit mask of DTH field.
	PWM_DT2_DTH_Msk = 0xffff
	// Position of DTL field.
	PWM_DT2_DTL_Pos = 0x10
	// Bit mask of DTL field.
	PWM_DT2_DTL_Msk = 0xffff0000

	// DTUPD2: PWM Channel Dead Time Update Register (ch_num = 2)
	// Position of DTHUPD field.
	PWM_DTUPD2_DTHUPD_Pos = 0x0
	// Bit mask of DTHUPD field.
	PWM_DTUPD2_DTHUPD_Msk = 0xffff
	// Position of DTLUPD field.
	PWM_DTUPD2_DTLUPD_Pos = 0x10
	// Bit mask of DTLUPD field.
	PWM_DTUPD2_DTLUPD_Msk = 0xffff0000

	// CMR3: PWM Channel Mode Register (ch_num = 3)
	// Position of CPRE field.
	PWM_CMR3_CPRE_Pos = 0x0
	// Bit mask of CPRE field.
	PWM_CMR3_CPRE_Msk = 0xf
	// Master clock
	PWM_CMR3_CPRE_MCK = 0x0
	// Master clock/2
	PWM_CMR3_CPRE_MCK_DIV_2 = 0x1
	// Master clock/4
	PWM_CMR3_CPRE_MCK_DIV_4 = 0x2
	// Master clock/8
	PWM_CMR3_CPRE_MCK_DIV_8 = 0x3
	// Master clock/16
	PWM_CMR3_CPRE_MCK_DIV_16 = 0x4
	// Master clock/32
	PWM_CMR3_CPRE_MCK_DIV_32 = 0x5
	// Master clock/64
	PWM_CMR3_CPRE_MCK_DIV_64 = 0x6
	// Master clock/128
	PWM_CMR3_CPRE_MCK_DIV_128 = 0x7
	// Master clock/256
	PWM_CMR3_CPRE_MCK_DIV_256 = 0x8
	// Master clock/512
	PWM_CMR3_CPRE_MCK_DIV_512 = 0x9
	// Master clock/1024
	PWM_CMR3_CPRE_MCK_DIV_1024 = 0xa
	// Clock A
	PWM_CMR3_CPRE_CLKA = 0xb
	// Clock B
	PWM_CMR3_CPRE_CLKB = 0xc
	// Position of CALG field.
	PWM_CMR3_CALG_Pos = 0x8
	// Bit mask of CALG field.
	PWM_CMR3_CALG_Msk = 0x100
	// Bit CALG.
	PWM_CMR3_CALG = 0x100
	// Position of CPOL field.
	PWM_CMR3_CPOL_Pos = 0x9
	// Bit mask of CPOL field.
	PWM_CMR3_CPOL_Msk = 0x200
	// Bit CPOL.
	PWM_CMR3_CPOL = 0x200
	// Position of CES field.
	PWM_CMR3_CES_Pos = 0xa
	// Bit mask of CES field.
	PWM_CMR3_CES_Msk = 0x400
	// Bit CES.
	PWM_CMR3_CES = 0x400
	// Position of DTE field.
	PWM_CMR3_DTE_Pos = 0x10
	// Bit mask of DTE field.
	PWM_CMR3_DTE_Msk = 0x10000
	// Bit DTE.
	PWM_CMR3_DTE = 0x10000
	// Position of DTHI field.
	PWM_CMR3_DTHI_Pos = 0x11
	// Bit mask of DTHI field.
	PWM_CMR3_DTHI_Msk = 0x20000
	// Bit DTHI.
	PWM_CMR3_DTHI = 0x20000
	// Position of DTLI field.
	PWM_CMR3_DTLI_Pos = 0x12
	// Bit mask of DTLI field.
	PWM_CMR3_DTLI_Msk = 0x40000
	// Bit DTLI.
	PWM_CMR3_DTLI = 0x40000

	// CDTY3: PWM Channel Duty Cycle Register (ch_num = 3)
	// Position of CDTY field.
	PWM_CDTY3_CDTY_Pos = 0x0
	// Bit mask of CDTY field.
	PWM_CDTY3_CDTY_Msk = 0xffffff

	// CDTYUPD3: PWM Channel Duty Cycle Update Register (ch_num = 3)
	// Position of CDTYUPD field.
	PWM_CDTYUPD3_CDTYUPD_Pos = 0x0
	// Bit mask of CDTYUPD field.
	PWM_CDTYUPD3_CDTYUPD_Msk = 0xffffff

	// CPRD3: PWM Channel Period Register (ch_num = 3)
	// Position of CPRD field.
	PWM_CPRD3_CPRD_Pos = 0x0
	// Bit mask of CPRD field.
	PWM_CPRD3_CPRD_Msk = 0xffffff

	// CPRDUPD3: PWM Channel Period Update Register (ch_num = 3)
	// Position of CPRDUPD field.
	PWM_CPRDUPD3_CPRDUPD_Pos = 0x0
	// Bit mask of CPRDUPD field.
	PWM_CPRDUPD3_CPRDUPD_Msk = 0xffffff

	// CCNT3: PWM Channel Counter Register (ch_num = 3)
	// Position of CNT field.
	PWM_CCNT3_CNT_Pos = 0x0
	// Bit mask of CNT field.
	PWM_CCNT3_CNT_Msk = 0xffffff

	// DT3: PWM Channel Dead Time Register (ch_num = 3)
	// Position of DTH field.
	PWM_DT3_DTH_Pos = 0x0
	// Bit mask of DTH field.
	PWM_DT3_DTH_Msk = 0xffff
	// Position of DTL field.
	PWM_DT3_DTL_Pos = 0x10
	// Bit mask of DTL field.
	PWM_DT3_DTL_Msk = 0xffff0000

	// DTUPD3: PWM Channel Dead Time Update Register (ch_num = 3)
	// Position of DTHUPD field.
	PWM_DTUPD3_DTHUPD_Pos = 0x0
	// Bit mask of DTHUPD field.
	PWM_DTUPD3_DTHUPD_Msk = 0xffff
	// Position of DTLUPD field.
	PWM_DTUPD3_DTLUPD_Pos = 0x10
	// Bit mask of DTLUPD field.
	PWM_DTUPD3_DTLUPD_Msk = 0xffff0000
)

// Bitfields for USART0: Universal Synchronous Asynchronous Receiver Transmitter 0
const (
	// CR: Control Register
	// Position of RSTRX field.
	USART_CR_RSTRX_Pos = 0x2
	// Bit mask of RSTRX field.
	USART_CR_RSTRX_Msk = 0x4
	// Bit RSTRX.
	USART_CR_RSTRX = 0x4
	// Position of RSTTX field.
	USART_CR_RSTTX_Pos = 0x3
	// Bit mask of RSTTX field.
	USART_CR_RSTTX_Msk = 0x8
	// Bit RSTTX.
	USART_CR_RSTTX = 0x8
	// Position of RXEN field.
	USART_CR_RXEN_Pos = 0x4
	// Bit mask of RXEN field.
	USART_CR_RXEN_Msk = 0x10
	// Bit RXEN.
	USART_CR_RXEN = 0x10
	// Position of RXDIS field.
	USART_CR_RXDIS_Pos = 0x5
	// Bit mask of RXDIS field.
	USART_CR_RXDIS_Msk = 0x20
	// Bit RXDIS.
	USART_CR_RXDIS = 0x20
	// Position of TXEN field.
	USART_CR_TXEN_Pos = 0x6
	// Bit mask of TXEN field.
	USART_CR_TXEN_Msk = 0x40
	// Bit TXEN.
	USART_CR_TXEN = 0x40
	// Position of TXDIS field.
	USART_CR_TXDIS_Pos = 0x7
	// Bit mask of TXDIS field.
	USART_CR_TXDIS_Msk = 0x80
	// Bit TXDIS.
	USART_CR_TXDIS = 0x80
	// Position of RSTSTA field.
	USART_CR_RSTSTA_Pos = 0x8
	// Bit mask of RSTSTA field.
	USART_CR_RSTSTA_Msk = 0x100
	// Bit RSTSTA.
	USART_CR_RSTSTA = 0x100
	// Position of STTBRK field.
	USART_CR_STTBRK_Pos = 0x9
	// Bit mask of STTBRK field.
	USART_CR_STTBRK_Msk = 0x200
	// Bit STTBRK.
	USART_CR_STTBRK = 0x200
	// Position of STPBRK field.
	USART_CR_STPBRK_Pos = 0xa
	// Bit mask of STPBRK field.
	USART_CR_STPBRK_Msk = 0x400
	// Bit STPBRK.
	USART_CR_STPBRK = 0x400
	// Position of STTTO field.
	USART_CR_STTTO_Pos = 0xb
	// Bit mask of STTTO field.
	USART_CR_STTTO_Msk = 0x800
	// Bit STTTO.
	USART_CR_STTTO = 0x800
	// Position of SENDA field.
	USART_CR_SENDA_Pos = 0xc
	// Bit mask of SENDA field.
	USART_CR_SENDA_Msk = 0x1000
	// Bit SENDA.
	USART_CR_SENDA = 0x1000
	// Position of RSTIT field.
	USART_CR_RSTIT_Pos = 0xd
	// Bit mask of RSTIT field.
	USART_CR_RSTIT_Msk = 0x2000
	// Bit RSTIT.
	USART_CR_RSTIT = 0x2000
	// Position of RSTNACK field.
	USART_CR_RSTNACK_Pos = 0xe
	// Bit mask of RSTNACK field.
	USART_CR_RSTNACK_Msk = 0x4000
	// Bit RSTNACK.
	USART_CR_RSTNACK = 0x4000
	// Position of RETTO field.
	USART_CR_RETTO_Pos = 0xf
	// Bit mask of RETTO field.
	USART_CR_RETTO_Msk = 0x8000
	// Bit RETTO.
	USART_CR_RETTO = 0x8000
	// Position of DTREN field.
	USART_CR_DTREN_Pos = 0x10
	// Bit mask of DTREN field.
	USART_CR_DTREN_Msk = 0x10000
	// Bit DTREN.
	USART_CR_DTREN = 0x10000
	// Position of DTRDIS field.
	USART_CR_DTRDIS_Pos = 0x11
	// Bit mask of DTRDIS field.
	USART_CR_DTRDIS_Msk = 0x20000
	// Bit DTRDIS.
	USART_CR_DTRDIS = 0x20000
	// Position of RTSEN field.
	USART_CR_RTSEN_Pos = 0x12
	// Bit mask of RTSEN field.
	USART_CR_RTSEN_Msk = 0x40000
	// Bit RTSEN.
	USART_CR_RTSEN = 0x40000
	// Position of RTSDIS field.
	USART_CR_RTSDIS_Pos = 0x13
	// Bit mask of RTSDIS field.
	USART_CR_RTSDIS_Msk = 0x80000
	// Bit RTSDIS.
	USART_CR_RTSDIS = 0x80000

	// CR_SPI_MODE: Control Register
	// Position of RSTRX field.
	USART_CR_SPI_MODE_RSTRX_Pos = 0x2
	// Bit mask of RSTRX field.
	USART_CR_SPI_MODE_RSTRX_Msk = 0x4
	// Bit RSTRX.
	USART_CR_SPI_MODE_RSTRX = 0x4
	// Position of RSTTX field.
	USART_CR_SPI_MODE_RSTTX_Pos = 0x3
	// Bit mask of RSTTX field.
	USART_CR_SPI_MODE_RSTTX_Msk = 0x8
	// Bit RSTTX.
	USART_CR_SPI_MODE_RSTTX = 0x8
	// Position of RXEN field.
	USART_CR_SPI_MODE_RXEN_Pos = 0x4
	// Bit mask of RXEN field.
	USART_CR_SPI_MODE_RXEN_Msk = 0x10
	// Bit RXEN.
	USART_CR_SPI_MODE_RXEN = 0x10
	// Position of RXDIS field.
	USART_CR_SPI_MODE_RXDIS_Pos = 0x5
	// Bit mask of RXDIS field.
	USART_CR_SPI_MODE_RXDIS_Msk = 0x20
	// Bit RXDIS.
	USART_CR_SPI_MODE_RXDIS = 0x20
	// Position of TXEN field.
	USART_CR_SPI_MODE_TXEN_Pos = 0x6
	// Bit mask of TXEN field.
	USART_CR_SPI_MODE_TXEN_Msk = 0x40
	// Bit TXEN.
	USART_CR_SPI_MODE_TXEN = 0x40
	// Position of TXDIS field.
	USART_CR_SPI_MODE_TXDIS_Pos = 0x7
	// Bit mask of TXDIS field.
	USART_CR_SPI_MODE_TXDIS_Msk = 0x80
	// Bit TXDIS.
	USART_CR_SPI_MODE_TXDIS = 0x80
	// Position of RSTSTA field.
	USART_CR_SPI_MODE_RSTSTA_Pos = 0x8
	// Bit mask of RSTSTA field.
	USART_CR_SPI_MODE_RSTSTA_Msk = 0x100
	// Bit RSTSTA.
	USART_CR_SPI_MODE_RSTSTA = 0x100
	// Position of FCS field.
	USART_CR_SPI_MODE_FCS_Pos = 0x12
	// Bit mask of FCS field.
	USART_CR_SPI_MODE_FCS_Msk = 0x40000
	// Bit FCS.
	USART_CR_SPI_MODE_FCS = 0x40000
	// Position of RCS field.
	USART_CR_SPI_MODE_RCS_Pos = 0x13
	// Bit mask of RCS field.
	USART_CR_SPI_MODE_RCS_Msk = 0x80000
	// Bit RCS.
	USART_CR_SPI_MODE_RCS = 0x80000

	// MR: Mode Register
	// Position of USART_MODE field.
	USART_MR_USART_MODE_Pos = 0x0
	// Bit mask of USART_MODE field.
	USART_MR_USART_MODE_Msk = 0xf
	// Normal mode
	USART_MR_USART_MODE_NORMAL = 0x0
	// RS485
	USART_MR_USART_MODE_RS485 = 0x1
	// Hardware Handshaking
	USART_MR_USART_MODE_HW_HANDSHAKING = 0x2
	// Modem
	USART_MR_USART_MODE_MODEM = 0x3
	// IS07816 Protocol: T = 0
	USART_MR_USART_MODE_IS07816_T_0 = 0x4
	// IS07816 Protocol: T = 1
	USART_MR_USART_MODE_IS07816_T_1 = 0x6
	// IrDA
	USART_MR_USART_MODE_IRDA = 0x8
	// SPI Master
	USART_MR_USART_MODE_SPI_MASTER = 0xe
	// SPI Slave
	USART_MR_USART_MODE_SPI_SLAVE = 0xf
	// Position of USCLKS field.
	USART_MR_USCLKS_Pos = 0x4
	// Bit mask of USCLKS field.
	USART_MR_USCLKS_Msk = 0x30
	// Master Clock MCK is selected
	USART_MR_USCLKS_MCK = 0x0
	// Internal Clock Divided MCK/DIV (DIV=8) is selected
	USART_MR_USCLKS_DIV = 0x1
	// Serial Clock SLK is selected
	USART_MR_USCLKS_SCK = 0x3
	// Position of CHRL field.
	USART_MR_CHRL_Pos = 0x6
	// Bit mask of CHRL field.
	USART_MR_CHRL_Msk = 0xc0
	// Character length is 5 bits
	USART_MR_CHRL_5_BIT = 0x0
	// Character length is 6 bits
	USART_MR_CHRL_6_BIT = 0x1
	// Character length is 7 bits
	USART_MR_CHRL_7_BIT = 0x2
	// Character length is 8 bits
	USART_MR_CHRL_8_BIT = 0x3
	// Position of SYNC field.
	USART_MR_SYNC_Pos = 0x8
	// Bit mask of SYNC field.
	USART_MR_SYNC_Msk = 0x100
	// Bit SYNC.
	USART_MR_SYNC = 0x100
	// Position of PAR field.
	USART_MR_PAR_Pos = 0x9
	// Bit mask of PAR field.
	USART_MR_PAR_Msk = 0xe00
	// Even parity
	USART_MR_PAR_EVEN = 0x0
	// Odd parity
	USART_MR_PAR_ODD = 0x1
	// Parity forced to 0 (Space)
	USART_MR_PAR_SPACE = 0x2
	// Parity forced to 1 (Mark)
	USART_MR_PAR_MARK = 0x3
	// No parity
	USART_MR_PAR_NO = 0x4
	// Multidrop mode
	USART_MR_PAR_MULTIDROP = 0x6
	// Position of NBSTOP field.
	USART_MR_NBSTOP_Pos = 0xc
	// Bit mask of NBSTOP field.
	USART_MR_NBSTOP_Msk = 0x3000
	// 1 stop bit
	USART_MR_NBSTOP_1_BIT = 0x0
	// 1.5 stop bit (SYNC = 0) or reserved (SYNC = 1)
	USART_MR_NBSTOP_1_5_BIT = 0x1
	// 2 stop bits
	USART_MR_NBSTOP_2_BIT = 0x2
	// Position of CHMODE field.
	USART_MR_CHMODE_Pos = 0xe
	// Bit mask of CHMODE field.
	USART_MR_CHMODE_Msk = 0xc000
	// Normal Mode
	USART_MR_CHMODE_NORMAL = 0x0
	// Automatic Echo. Receiver input is connected to the TXD pin.
	USART_MR_CHMODE_AUTOMATIC = 0x1
	// Local Loopback. Transmitter output is connected to the Receiver Input.
	USART_MR_CHMODE_LOCAL_LOOPBACK = 0x2
	// Remote Loopback. RXD pin is internally connected to the TXD pin.
	USART_MR_CHMODE_REMOTE_LOOPBACK = 0x3
	// Position of MSBF field.
	USART_MR_MSBF_Pos = 0x10
	// Bit mask of MSBF field.
	USART_MR_MSBF_Msk = 0x10000
	// Bit MSBF.
	USART_MR_MSBF = 0x10000
	// Position of MODE9 field.
	USART_MR_MODE9_Pos = 0x11
	// Bit mask of MODE9 field.
	USART_MR_MODE9_Msk = 0x20000
	// Bit MODE9.
	USART_MR_MODE9 = 0x20000
	// Position of CLKO field.
	USART_MR_CLKO_Pos = 0x12
	// Bit mask of CLKO field.
	USART_MR_CLKO_Msk = 0x40000
	// Bit CLKO.
	USART_MR_CLKO = 0x40000
	// Position of OVER field.
	USART_MR_OVER_Pos = 0x13
	// Bit mask of OVER field.
	USART_MR_OVER_Msk = 0x80000
	// Bit OVER.
	USART_MR_OVER = 0x80000
	// Position of INACK field.
	USART_MR_INACK_Pos = 0x14
	// Bit mask of INACK field.
	USART_MR_INACK_Msk = 0x100000
	// Bit INACK.
	USART_MR_INACK = 0x100000
	// Position of DSNACK field.
	USART_MR_DSNACK_Pos = 0x15
	// Bit mask of DSNACK field.
	USART_MR_DSNACK_Msk = 0x200000
	// Bit DSNACK.
	USART_MR_DSNACK = 0x200000
	// Position of VAR_SYNC field.
	USART_MR_VAR_SYNC_Pos = 0x16
	// Bit mask of VAR_SYNC field.
	USART_MR_VAR_SYNC_Msk = 0x400000
	// Bit VAR_SYNC.
	USART_MR_VAR_SYNC = 0x400000
	// Position of INVDATA field.
	USART_MR_INVDATA_Pos = 0x17
	// Bit mask of INVDATA field.
	USART_MR_INVDATA_Msk = 0x800000
	// Bit INVDATA.
	USART_MR_INVDATA = 0x800000
	// Position of MAX_ITERATION field.
	USART_MR_MAX_ITERATION_Pos = 0x18
	// Bit mask of MAX_ITERATION field.
	USART_MR_MAX_ITERATION_Msk = 0x7000000
	// Position of FILTER field.
	USART_MR_FILTER_Pos = 0x1c
	// Bit mask of FILTER field.
	USART_MR_FILTER_Msk = 0x10000000
	// Bit FILTER.
	USART_MR_FILTER = 0x10000000
	// Position of MAN field.
	USART_MR_MAN_Pos = 0x1d
	// Bit mask of MAN field.
	USART_MR_MAN_Msk = 0x20000000
	// Bit MAN.
	USART_MR_MAN = 0x20000000
	// Position of MODSYNC field.
	USART_MR_MODSYNC_Pos = 0x1e
	// Bit mask of MODSYNC field.
	USART_MR_MODSYNC_Msk = 0x40000000
	// Bit MODSYNC.
	USART_MR_MODSYNC = 0x40000000
	// Position of ONEBIT field.
	USART_MR_ONEBIT_Pos = 0x1f
	// Bit mask of ONEBIT field.
	USART_MR_ONEBIT_Msk = 0x80000000
	// Bit ONEBIT.
	USART_MR_ONEBIT = 0x80000000

	// MR_SPI_MODE: Mode Register
	// Position of USART_MODE field.
	USART_MR_SPI_MODE_USART_MODE_Pos = 0x0
	// Bit mask of USART_MODE field.
	USART_MR_SPI_MODE_USART_MODE_Msk = 0xf
	// SPI Master
	USART_MR_SPI_MODE_USART_MODE_SPI_MASTER = 0xe
	// SPI Slave
	USART_MR_SPI_MODE_USART_MODE_SPI_SLAVE = 0xf
	// Position of USCLKS field.
	USART_MR_SPI_MODE_USCLKS_Pos = 0x4
	// Bit mask of USCLKS field.
	USART_MR_SPI_MODE_USCLKS_Msk = 0x30
	// Master Clock MCK is selected
	USART_MR_SPI_MODE_USCLKS_MCK = 0x0
	// Internal Clock Divided MCK/DIV (DIV=8) is selected
	USART_MR_SPI_MODE_USCLKS_DIV = 0x1
	// Serial Clock SLK is selected
	USART_MR_SPI_MODE_USCLKS_SCK = 0x3
	// Position of CHRL field.
	USART_MR_SPI_MODE_CHRL_Pos = 0x6
	// Bit mask of CHRL field.
	USART_MR_SPI_MODE_CHRL_Msk = 0xc0
	// Character length is 8 bits
	USART_MR_SPI_MODE_CHRL_8_BIT = 0x3
	// Position of CPHA field.
	USART_MR_SPI_MODE_CPHA_Pos = 0x8
	// Bit mask of CPHA field.
	USART_MR_SPI_MODE_CPHA_Msk = 0x100
	// Bit CPHA.
	USART_MR_SPI_MODE_CPHA = 0x100
	// Position of CPOL field.
	USART_MR_SPI_MODE_CPOL_Pos = 0x10
	// Bit mask of CPOL field.
	USART_MR_SPI_MODE_CPOL_Msk = 0x10000
	// Bit CPOL.
	USART_MR_SPI_MODE_CPOL = 0x10000
	// Position of WRDBT field.
	USART_MR_SPI_MODE_WRDBT_Pos = 0x14
	// Bit mask of WRDBT field.
	USART_MR_SPI_MODE_WRDBT_Msk = 0x100000
	// Bit WRDBT.
	USART_MR_SPI_MODE_WRDBT = 0x100000

	// IER: Interrupt Enable Register
	// Position of RXRDY field.
	USART_IER_RXRDY_Pos = 0x0
	// Bit mask of RXRDY field.
	USART_IER_RXRDY_Msk = 0x1
	// Bit RXRDY.
	USART_IER_RXRDY = 0x1
	// Position of TXRDY field.
	USART_IER_TXRDY_Pos = 0x1
	// Bit mask of TXRDY field.
	USART_IER_TXRDY_Msk = 0x2
	// Bit TXRDY.
	USART_IER_TXRDY = 0x2
	// Position of RXBRK field.
	USART_IER_RXBRK_Pos = 0x2
	// Bit mask of RXBRK field.
	USART_IER_RXBRK_Msk = 0x4
	// Bit RXBRK.
	USART_IER_RXBRK = 0x4
	// Position of ENDRX field.
	USART_IER_ENDRX_Pos = 0x3
	// Bit mask of ENDRX field.
	USART_IER_ENDRX_Msk = 0x8
	// Bit ENDRX.
	USART_IER_ENDRX = 0x8
	// Position of ENDTX field.
	USART_IER_ENDTX_Pos = 0x4
	// Bit mask of ENDTX field.
	USART_IER_ENDTX_Msk = 0x10
	// Bit ENDTX.
	USART_IER_ENDTX = 0x10
	// Position of OVRE field.
	USART_IER_OVRE_Pos = 0x5
	// Bit mask of OVRE field.
	USART_IER_OVRE_Msk = 0x20
	// Bit OVRE.
	USART_IER_OVRE = 0x20
	// Position of FRAME field.
	USART_IER_FRAME_Pos = 0x6
	// Bit mask of FRAME field.
	USART_IER_FRAME_Msk = 0x40
	// Bit FRAME.
	USART_IER_FRAME = 0x40
	// Position of PARE field.
	USART_IER_PARE_Pos = 0x7
	// Bit mask of PARE field.
	USART_IER_PARE_Msk = 0x80
	// Bit PARE.
	USART_IER_PARE = 0x80
	// Position of TIMEOUT field.
	USART_IER_TIMEOUT_Pos = 0x8
	// Bit mask of TIMEOUT field.
	USART_IER_TIMEOUT_Msk = 0x100
	// Bit TIMEOUT.
	USART_IER_TIMEOUT = 0x100
	// Position of TXEMPTY field.
	USART_IER_TXEMPTY_Pos = 0x9
	// Bit mask of TXEMPTY field.
	USART_IER_TXEMPTY_Msk = 0x200
	// Bit TXEMPTY.
	USART_IER_TXEMPTY = 0x200
	// Position of ITER field.
	USART_IER_ITER_Pos = 0xa
	// Bit mask of ITER field.
	USART_IER_ITER_Msk = 0x400
	// Bit ITER.
	USART_IER_ITER = 0x400
	// Position of TXBUFE field.
	USART_IER_TXBUFE_Pos = 0xb
	// Bit mask of TXBUFE field.
	USART_IER_TXBUFE_Msk = 0x800
	// Bit TXBUFE.
	USART_IER_TXBUFE = 0x800
	// Position of RXBUFF field.
	USART_IER_RXBUFF_Pos = 0xc
	// Bit mask of RXBUFF field.
	USART_IER_RXBUFF_Msk = 0x1000
	// Bit RXBUFF.
	USART_IER_RXBUFF = 0x1000
	// Position of NACK field.
	USART_IER_NACK_Pos = 0xd
	// Bit mask of NACK field.
	USART_IER_NACK_Msk = 0x2000
	// Bit NACK.
	USART_IER_NACK = 0x2000
	// Position of RIIC field.
	USART_IER_RIIC_Pos = 0x10
	// Bit mask of RIIC field.
	USART_IER_RIIC_Msk = 0x10000
	// Bit RIIC.
	USART_IER_RIIC = 0x10000
	// Position of DSRIC field.
	USART_IER_DSRIC_Pos = 0x11
	// Bit mask of DSRIC field.
	USART_IER_DSRIC_Msk = 0x20000
	// Bit DSRIC.
	USART_IER_DSRIC = 0x20000
	// Position of DCDIC field.
	USART_IER_DCDIC_Pos = 0x12
	// Bit mask of DCDIC field.
	USART_IER_DCDIC_Msk = 0x40000
	// Bit DCDIC.
	USART_IER_DCDIC = 0x40000
	// Position of CTSIC field.
	USART_IER_CTSIC_Pos = 0x13
	// Bit mask of CTSIC field.
	USART_IER_CTSIC_Msk = 0x80000
	// Bit CTSIC.
	USART_IER_CTSIC = 0x80000
	// Position of MANE field.
	USART_IER_MANE_Pos = 0x18
	// Bit mask of MANE field.
	USART_IER_MANE_Msk = 0x1000000
	// Bit MANE.
	USART_IER_MANE = 0x1000000

	// IER_SPI_MODE: Interrupt Enable Register
	// Position of RXRDY field.
	USART_IER_SPI_MODE_RXRDY_Pos = 0x0
	// Bit mask of RXRDY field.
	USART_IER_SPI_MODE_RXRDY_Msk = 0x1
	// Bit RXRDY.
	USART_IER_SPI_MODE_RXRDY = 0x1
	// Position of TXRDY field.
	USART_IER_SPI_MODE_TXRDY_Pos = 0x1
	// Bit mask of TXRDY field.
	USART_IER_SPI_MODE_TXRDY_Msk = 0x2
	// Bit TXRDY.
	USART_IER_SPI_MODE_TXRDY = 0x2
	// Position of ENDRX field.
	USART_IER_SPI_MODE_ENDRX_Pos = 0x3
	// Bit mask of ENDRX field.
	USART_IER_SPI_MODE_ENDRX_Msk = 0x8
	// Bit ENDRX.
	USART_IER_SPI_MODE_ENDRX = 0x8
	// Position of ENDTX field.
	USART_IER_SPI_MODE_ENDTX_Pos = 0x4
	// Bit mask of ENDTX field.
	USART_IER_SPI_MODE_ENDTX_Msk = 0x10
	// Bit ENDTX.
	USART_IER_SPI_MODE_ENDTX = 0x10
	// Position of OVRE field.
	USART_IER_SPI_MODE_OVRE_Pos = 0x5
	// Bit mask of OVRE field.
	USART_IER_SPI_MODE_OVRE_Msk = 0x20
	// Bit OVRE.
	USART_IER_SPI_MODE_OVRE = 0x20
	// Position of TXEMPTY field.
	USART_IER_SPI_MODE_TXEMPTY_Pos = 0x9
	// Bit mask of TXEMPTY field.
	USART_IER_SPI_MODE_TXEMPTY_Msk = 0x200
	// Bit TXEMPTY.
	USART_IER_SPI_MODE_TXEMPTY = 0x200
	// Position of UNRE field.
	USART_IER_SPI_MODE_UNRE_Pos = 0xa
	// Bit mask of UNRE field.
	USART_IER_SPI_MODE_UNRE_Msk = 0x400
	// Bit UNRE.
	USART_IER_SPI_MODE_UNRE = 0x400
	// Position of TXBUFE field.
	USART_IER_SPI_MODE_TXBUFE_Pos = 0xb
	// Bit mask of TXBUFE field.
	USART_IER_SPI_MODE_TXBUFE_Msk = 0x800
	// Bit TXBUFE.
	USART_IER_SPI_MODE_TXBUFE = 0x800
	// Position of RXBUFF field.
	USART_IER_SPI_MODE_RXBUFF_Pos = 0xc
	// Bit mask of RXBUFF field.
	USART_IER_SPI_MODE_RXBUFF_Msk = 0x1000
	// Bit RXBUFF.
	USART_IER_SPI_MODE_RXBUFF = 0x1000

	// IDR: Interrupt Disable Register
	// Position of RXRDY field.
	USART_IDR_RXRDY_Pos = 0x0
	// Bit mask of RXRDY field.
	USART_IDR_RXRDY_Msk = 0x1
	// Bit RXRDY.
	USART_IDR_RXRDY = 0x1
	// Position of TXRDY field.
	USART_IDR_TXRDY_Pos = 0x1
	// Bit mask of TXRDY field.
	USART_IDR_TXRDY_Msk = 0x2
	// Bit TXRDY.
	USART_IDR_TXRDY = 0x2
	// Position of RXBRK field.
	USART_IDR_RXBRK_Pos = 0x2
	// Bit mask of RXBRK field.
	USART_IDR_RXBRK_Msk = 0x4
	// Bit RXBRK.
	USART_IDR_RXBRK = 0x4
	// Position of ENDRX field.
	USART_IDR_ENDRX_Pos = 0x3
	// Bit mask of ENDRX field.
	USART_IDR_ENDRX_Msk = 0x8
	// Bit ENDRX.
	USART_IDR_ENDRX = 0x8
	// Position of ENDTX field.
	USART_IDR_ENDTX_Pos = 0x4
	// Bit mask of ENDTX field.
	USART_IDR_ENDTX_Msk = 0x10
	// Bit ENDTX.
	USART_IDR_ENDTX = 0x10
	// Position of OVRE field.
	USART_IDR_OVRE_Pos = 0x5
	// Bit mask of OVRE field.
	USART_IDR_OVRE_Msk = 0x20
	// Bit OVRE.
	USART_IDR_OVRE = 0x20
	// Position of FRAME field.
	USART_IDR_FRAME_Pos = 0x6
	// Bit mask of FRAME field.
	USART_IDR_FRAME_Msk = 0x40
	// Bit FRAME.
	USART_IDR_FRAME = 0x40
	// Position of PARE field.
	USART_IDR_PARE_Pos = 0x7
	// Bit mask of PARE field.
	USART_IDR_PARE_Msk = 0x80
	// Bit PARE.
	USART_IDR_PARE = 0x80
	// Position of TIMEOUT field.
	USART_IDR_TIMEOUT_Pos = 0x8
	// Bit mask of TIMEOUT field.
	USART_IDR_TIMEOUT_Msk = 0x100
	// Bit TIMEOUT.
	USART_IDR_TIMEOUT = 0x100
	// Position of TXEMPTY field.
	USART_IDR_TXEMPTY_Pos = 0x9
	// Bit mask of TXEMPTY field.
	USART_IDR_TXEMPTY_Msk = 0x200
	// Bit TXEMPTY.
	USART_IDR_TXEMPTY = 0x200
	// Position of ITER field.
	USART_IDR_ITER_Pos = 0xa
	// Bit mask of ITER field.
	USART_IDR_ITER_Msk = 0x400
	// Bit ITER.
	USART_IDR_ITER = 0x400
	// Position of TXBUFE field.
	USART_IDR_TXBUFE_Pos = 0xb
	// Bit mask of TXBUFE field.
	USART_IDR_TXBUFE_Msk = 0x800
	// Bit TXBUFE.
	USART_IDR_TXBUFE = 0x800
	// Position of RXBUFF field.
	USART_IDR_RXBUFF_Pos = 0xc
	// Bit mask of RXBUFF field.
	USART_IDR_RXBUFF_Msk = 0x1000
	// Bit RXBUFF.
	USART_IDR_RXBUFF = 0x1000
	// Position of NACK field.
	USART_IDR_NACK_Pos = 0xd
	// Bit mask of NACK field.
	USART_IDR_NACK_Msk = 0x2000
	// Bit NACK.
	USART_IDR_NACK = 0x2000
	// Position of RIIC field.
	USART_IDR_RIIC_Pos = 0x10
	// Bit mask of RIIC field.
	USART_IDR_RIIC_Msk = 0x10000
	// Bit RIIC.
	USART_IDR_RIIC = 0x10000
	// Position of DSRIC field.
	USART_IDR_DSRIC_Pos = 0x11
	// Bit mask of DSRIC field.
	USART_IDR_DSRIC_Msk = 0x20000
	// Bit DSRIC.
	USART_IDR_DSRIC = 0x20000
	// Position of DCDIC field.
	USART_IDR_DCDIC_Pos = 0x12
	// Bit mask of DCDIC field.
	USART_IDR_DCDIC_Msk = 0x40000
	// Bit DCDIC.
	USART_IDR_DCDIC = 0x40000
	// Position of CTSIC field.
	USART_IDR_CTSIC_Pos = 0x13
	// Bit mask of CTSIC field.
	USART_IDR_CTSIC_Msk = 0x80000
	// Bit CTSIC.
	USART_IDR_CTSIC = 0x80000
	// Position of MANE field.
	USART_IDR_MANE_Pos = 0x18
	// Bit mask of MANE field.
	USART_IDR_MANE_Msk = 0x1000000
	// Bit MANE.
	USART_IDR_MANE = 0x1000000

	// IDR_SPI_MODE: Interrupt Disable Register
	// Position of RXRDY field.
	USART_IDR_SPI_MODE_RXRDY_Pos = 0x0
	// Bit mask of RXRDY field.
	USART_IDR_SPI_MODE_RXRDY_Msk = 0x1
	// Bit RXRDY.
	USART_IDR_SPI_MODE_RXRDY = 0x1
	// Position of TXRDY field.
	USART_IDR_SPI_MODE_TXRDY_Pos = 0x1
	// Bit mask of TXRDY field.
	USART_IDR_SPI_MODE_TXRDY_Msk = 0x2
	// Bit TXRDY.
	USART_IDR_SPI_MODE_TXRDY = 0x2
	// Position of ENDRX field.
	USART_IDR_SPI_MODE_ENDRX_Pos = 0x3
	// Bit mask of ENDRX field.
	USART_IDR_SPI_MODE_ENDRX_Msk = 0x8
	// Bit ENDRX.
	USART_IDR_SPI_MODE_ENDRX = 0x8
	// Position of ENDTX field.
	USART_IDR_SPI_MODE_ENDTX_Pos = 0x4
	// Bit mask of ENDTX field.
	USART_IDR_SPI_MODE_ENDTX_Msk = 0x10
	// Bit ENDTX.
	USART_IDR_SPI_MODE_ENDTX = 0x10
	// Position of OVRE field.
	USART_IDR_SPI_MODE_OVRE_Pos = 0x5
	// Bit mask of OVRE field.
	USART_IDR_SPI_MODE_OVRE_Msk = 0x20
	// Bit OVRE.
	USART_IDR_SPI_MODE_OVRE = 0x20
	// Position of TXEMPTY field.
	USART_IDR_SPI_MODE_TXEMPTY_Pos = 0x9
	// Bit mask of TXEMPTY field.
	USART_IDR_SPI_MODE_TXEMPTY_Msk = 0x200
	// Bit TXEMPTY.
	USART_IDR_SPI_MODE_TXEMPTY = 0x200
	// Position of UNRE field.
	USART_IDR_SPI_MODE_UNRE_Pos = 0xa
	// Bit mask of UNRE field.
	USART_IDR_SPI_MODE_UNRE_Msk = 0x400
	// Bit UNRE.
	USART_IDR_SPI_MODE_UNRE = 0x400
	// Position of TXBUFE field.
	USART_IDR_SPI_MODE_TXBUFE_Pos = 0xb
	// Bit mask of TXBUFE field.
	USART_IDR_SPI_MODE_TXBUFE_Msk = 0x800
	// Bit TXBUFE.
	USART_IDR_SPI_MODE_TXBUFE = 0x800
	// Position of RXBUFF field.
	USART_IDR_SPI_MODE_RXBUFF_Pos = 0xc
	// Bit mask of RXBUFF field.
	USART_IDR_SPI_MODE_RXBUFF_Msk = 0x1000
	// Bit RXBUFF.
	USART_IDR_SPI_MODE_RXBUFF = 0x1000

	// IMR: Interrupt Mask Register
	// Position of RXRDY field.
	USART_IMR_RXRDY_Pos = 0x0
	// Bit mask of RXRDY field.
	USART_IMR_RXRDY_Msk = 0x1
	// Bit RXRDY.
	USART_IMR_RXRDY = 0x1
	// Position of TXRDY field.
	USART_IMR_TXRDY_Pos = 0x1
	// Bit mask of TXRDY field.
	USART_IMR_TXRDY_Msk = 0x2
	// Bit TXRDY.
	USART_IMR_TXRDY = 0x2
	// Position of RXBRK field.
	USART_IMR_RXBRK_Pos = 0x2
	// Bit mask of RXBRK field.
	USART_IMR_RXBRK_Msk = 0x4
	// Bit RXBRK.
	USART_IMR_RXBRK = 0x4
	// Position of ENDRX field.
	USART_IMR_ENDRX_Pos = 0x3
	// Bit mask of ENDRX field.
	USART_IMR_ENDRX_Msk = 0x8
	// Bit ENDRX.
	USART_IMR_ENDRX = 0x8
	// Position of ENDTX field.
	USART_IMR_ENDTX_Pos = 0x4
	// Bit mask of ENDTX field.
	USART_IMR_ENDTX_Msk = 0x10
	// Bit ENDTX.
	USART_IMR_ENDTX = 0x10
	// Position of OVRE field.
	USART_IMR_OVRE_Pos = 0x5
	// Bit mask of OVRE field.
	USART_IMR_OVRE_Msk = 0x20
	// Bit OVRE.
	USART_IMR_OVRE = 0x20
	// Position of FRAME field.
	USART_IMR_FRAME_Pos = 0x6
	// Bit mask of FRAME field.
	USART_IMR_FRAME_Msk = 0x40
	// Bit FRAME.
	USART_IMR_FRAME = 0x40
	// Position of PARE field.
	USART_IMR_PARE_Pos = 0x7
	// Bit mask of PARE field.
	USART_IMR_PARE_Msk = 0x80
	// Bit PARE.
	USART_IMR_PARE = 0x80
	// Position of TIMEOUT field.
	USART_IMR_TIMEOUT_Pos = 0x8
	// Bit mask of TIMEOUT field.
	USART_IMR_TIMEOUT_Msk = 0x100
	// Bit TIMEOUT.
	USART_IMR_TIMEOUT = 0x100
	// Position of TXEMPTY field.
	USART_IMR_TXEMPTY_Pos = 0x9
	// Bit mask of TXEMPTY field.
	USART_IMR_TXEMPTY_Msk = 0x200
	// Bit TXEMPTY.
	USART_IMR_TXEMPTY = 0x200
	// Position of ITER field.
	USART_IMR_ITER_Pos = 0xa
	// Bit mask of ITER field.
	USART_IMR_ITER_Msk = 0x400
	// Bit ITER.
	USART_IMR_ITER = 0x400
	// Position of TXBUFE field.
	USART_IMR_TXBUFE_Pos = 0xb
	// Bit mask of TXBUFE field.
	USART_IMR_TXBUFE_Msk = 0x800
	// Bit TXBUFE.
	USART_IMR_TXBUFE = 0x800
	// Position of RXBUFF field.
	USART_IMR_RXBUFF_Pos = 0xc
	// Bit mask of RXBUFF field.
	USART_IMR_RXBUFF_Msk = 0x1000
	// Bit RXBUFF.
	USART_IMR_RXBUFF = 0x1000
	// Position of NACK field.
	USART_IMR_NACK_Pos = 0xd
	// Bit mask of NACK field.
	USART_IMR_NACK_Msk = 0x2000
	// Bit NACK.
	USART_IMR_NACK = 0x2000
	// Position of RIIC field.
	USART_IMR_RIIC_Pos = 0x10
	// Bit mask of RIIC field.
	USART_IMR_RIIC_Msk = 0x10000
	// Bit RIIC.
	USART_IMR_RIIC = 0x10000
	// Position of DSRIC field.
	USART_IMR_DSRIC_Pos = 0x11
	// Bit mask of DSRIC field.
	USART_IMR_DSRIC_Msk = 0x20000
	// Bit DSRIC.
	USART_IMR_DSRIC = 0x20000
	// Position of DCDIC field.
	USART_IMR_DCDIC_Pos = 0x12
	// Bit mask of DCDIC field.
	USART_IMR_DCDIC_Msk = 0x40000
	// Bit DCDIC.
	USART_IMR_DCDIC = 0x40000
	// Position of CTSIC field.
	USART_IMR_CTSIC_Pos = 0x13
	// Bit mask of CTSIC field.
	USART_IMR_CTSIC_Msk = 0x80000
	// Bit CTSIC.
	USART_IMR_CTSIC = 0x80000
	// Position of MANE field.
	USART_IMR_MANE_Pos = 0x18
	// Bit mask of MANE field.
	USART_IMR_MANE_Msk = 0x1000000
	// Bit MANE.
	USART_IMR_MANE = 0x1000000

	// IMR_SPI_MODE: Interrupt Mask Register
	// Position of RXRDY field.
	USART_IMR_SPI_MODE_RXRDY_Pos = 0x0
	// Bit mask of RXRDY field.
	USART_IMR_SPI_MODE_RXRDY_Msk = 0x1
	// Bit RXRDY.
	USART_IMR_SPI_MODE_RXRDY = 0x1
	// Position of TXRDY field.
	USART_IMR_SPI_MODE_TXRDY_Pos = 0x1
	// Bit mask of TXRDY field.
	USART_IMR_SPI_MODE_TXRDY_Msk = 0x2
	// Bit TXRDY.
	USART_IMR_SPI_MODE_TXRDY = 0x2
	// Position of ENDRX field.
	USART_IMR_SPI_MODE_ENDRX_Pos = 0x3
	// Bit mask of ENDRX field.
	USART_IMR_SPI_MODE_ENDRX_Msk = 0x8
	// Bit ENDRX.
	USART_IMR_SPI_MODE_ENDRX = 0x8
	// Position of ENDTX field.
	USART_IMR_SPI_MODE_ENDTX_Pos = 0x4
	// Bit mask of ENDTX field.
	USART_IMR_SPI_MODE_ENDTX_Msk = 0x10
	// Bit ENDTX.
	USART_IMR_SPI_MODE_ENDTX = 0x10
	// Position of OVRE field.
	USART_IMR_SPI_MODE_OVRE_Pos = 0x5
	// Bit mask of OVRE field.
	USART_IMR_SPI_MODE_OVRE_Msk = 0x20
	// Bit OVRE.
	USART_IMR_SPI_MODE_OVRE = 0x20
	// Position of TXEMPTY field.
	USART_IMR_SPI_MODE_TXEMPTY_Pos = 0x9
	// Bit mask of TXEMPTY field.
	USART_IMR_SPI_MODE_TXEMPTY_Msk = 0x200
	// Bit TXEMPTY.
	USART_IMR_SPI_MODE_TXEMPTY = 0x200
	// Position of UNRE field.
	USART_IMR_SPI_MODE_UNRE_Pos = 0xa
	// Bit mask of UNRE field.
	USART_IMR_SPI_MODE_UNRE_Msk = 0x400
	// Bit UNRE.
	USART_IMR_SPI_MODE_UNRE = 0x400
	// Position of TXBUFE field.
	USART_IMR_SPI_MODE_TXBUFE_Pos = 0xb
	// Bit mask of TXBUFE field.
	USART_IMR_SPI_MODE_TXBUFE_Msk = 0x800
	// Bit TXBUFE.
	USART_IMR_SPI_MODE_TXBUFE = 0x800
	// Position of RXBUFF field.
	USART_IMR_SPI_MODE_RXBUFF_Pos = 0xc
	// Bit mask of RXBUFF field.
	USART_IMR_SPI_MODE_RXBUFF_Msk = 0x1000
	// Bit RXBUFF.
	USART_IMR_SPI_MODE_RXBUFF = 0x1000

	// CSR: Channel Status Register
	// Position of RXRDY field.
	USART_CSR_RXRDY_Pos = 0x0
	// Bit mask of RXRDY field.
	USART_CSR_RXRDY_Msk = 0x1
	// Bit RXRDY.
	USART_CSR_RXRDY = 0x1
	// Position of TXRDY field.
	USART_CSR_TXRDY_Pos = 0x1
	// Bit mask of TXRDY field.
	USART_CSR_TXRDY_Msk = 0x2
	// Bit TXRDY.
	USART_CSR_TXRDY = 0x2
	// Position of RXBRK field.
	USART_CSR_RXBRK_Pos = 0x2
	// Bit mask of RXBRK field.
	USART_CSR_RXBRK_Msk = 0x4
	// Bit RXBRK.
	USART_CSR_RXBRK = 0x4
	// Position of ENDRX field.
	USART_CSR_ENDRX_Pos = 0x3
	// Bit mask of ENDRX field.
	USART_CSR_ENDRX_Msk = 0x8
	// Bit ENDRX.
	USART_CSR_ENDRX = 0x8
	// Position of ENDTX field.
	USART_CSR_ENDTX_Pos = 0x4
	// Bit mask of ENDTX field.
	USART_CSR_ENDTX_Msk = 0x10
	// Bit ENDTX.
	USART_CSR_ENDTX = 0x10
	// Position of OVRE field.
	USART_CSR_OVRE_Pos = 0x5
	// Bit mask of OVRE field.
	USART_CSR_OVRE_Msk = 0x20
	// Bit OVRE.
	USART_CSR_OVRE = 0x20
	// Position of FRAME field.
	USART_CSR_FRAME_Pos = 0x6
	// Bit mask of FRAME field.
	USART_CSR_FRAME_Msk = 0x40
	// Bit FRAME.
	USART_CSR_FRAME = 0x40
	// Position of PARE field.
	USART_CSR_PARE_Pos = 0x7
	// Bit mask of PARE field.
	USART_CSR_PARE_Msk = 0x80
	// Bit PARE.
	USART_CSR_PARE = 0x80
	// Position of TIMEOUT field.
	USART_CSR_TIMEOUT_Pos = 0x8
	// Bit mask of TIMEOUT field.
	USART_CSR_TIMEOUT_Msk = 0x100
	// Bit TIMEOUT.
	USART_CSR_TIMEOUT = 0x100
	// Position of TXEMPTY field.
	USART_CSR_TXEMPTY_Pos = 0x9
	// Bit mask of TXEMPTY field.
	USART_CSR_TXEMPTY_Msk = 0x200
	// Bit TXEMPTY.
	USART_CSR_TXEMPTY = 0x200
	// Position of ITER field.
	USART_CSR_ITER_Pos = 0xa
	// Bit mask of ITER field.
	USART_CSR_ITER_Msk = 0x400
	// Bit ITER.
	USART_CSR_ITER = 0x400
	// Position of TXBUFE field.
	USART_CSR_TXBUFE_Pos = 0xb
	// Bit mask of TXBUFE field.
	USART_CSR_TXBUFE_Msk = 0x800
	// Bit TXBUFE.
	USART_CSR_TXBUFE = 0x800
	// Position of RXBUFF field.
	USART_CSR_RXBUFF_Pos = 0xc
	// Bit mask of RXBUFF field.
	USART_CSR_RXBUFF_Msk = 0x1000
	// Bit RXBUFF.
	USART_CSR_RXBUFF = 0x1000
	// Position of NACK field.
	USART_CSR_NACK_Pos = 0xd
	// Bit mask of NACK field.
	USART_CSR_NACK_Msk = 0x2000
	// Bit NACK.
	USART_CSR_NACK = 0x2000
	// Position of RIIC field.
	USART_CSR_RIIC_Pos = 0x10
	// Bit mask of RIIC field.
	USART_CSR_RIIC_Msk = 0x10000
	// Bit RIIC.
	USART_CSR_RIIC = 0x10000
	// Position of DSRIC field.
	USART_CSR_DSRIC_Pos = 0x11
	// Bit mask of DSRIC field.
	USART_CSR_DSRIC_Msk = 0x20000
	// Bit DSRIC.
	USART_CSR_DSRIC = 0x20000
	// Position of DCDIC field.
	USART_CSR_DCDIC_Pos = 0x12
	// Bit mask of DCDIC field.
	USART_CSR_DCDIC_Msk = 0x40000
	// Bit DCDIC.
	USART_CSR_DCDIC = 0x40000
	// Position of CTSIC field.
	USART_CSR_CTSIC_Pos = 0x13
	// Bit mask of CTSIC field.
	USART_CSR_CTSIC_Msk = 0x80000
	// Bit CTSIC.
	USART_CSR_CTSIC = 0x80000
	// Position of RI field.
	USART_CSR_RI_Pos = 0x14
	// Bit mask of RI field.
	USART_CSR_RI_Msk = 0x100000
	// Bit RI.
	USART_CSR_RI = 0x100000
	// Position of DSR field.
	USART_CSR_DSR_Pos = 0x15
	// Bit mask of DSR field.
	USART_CSR_DSR_Msk = 0x200000
	// Bit DSR.
	USART_CSR_DSR = 0x200000
	// Position of DCD field.
	USART_CSR_DCD_Pos = 0x16
	// Bit mask of DCD field.
	USART_CSR_DCD_Msk = 0x400000
	// Bit DCD.
	USART_CSR_DCD = 0x400000
	// Position of CTS field.
	USART_CSR_CTS_Pos = 0x17
	// Bit mask of CTS field.
	USART_CSR_CTS_Msk = 0x800000
	// Bit CTS.
	USART_CSR_CTS = 0x800000
	// Position of MANERR field.
	USART_CSR_MANERR_Pos = 0x18
	// Bit mask of MANERR field.
	USART_CSR_MANERR_Msk = 0x1000000
	// Bit MANERR.
	USART_CSR_MANERR = 0x1000000

	// CSR_SPI_MODE: Channel Status Register
	// Position of RXRDY field.
	USART_CSR_SPI_MODE_RXRDY_Pos = 0x0
	// Bit mask of RXRDY field.
	USART_CSR_SPI_MODE_RXRDY_Msk = 0x1
	// Bit RXRDY.
	USART_CSR_SPI_MODE_RXRDY = 0x1
	// Position of TXRDY field.
	USART_CSR_SPI_MODE_TXRDY_Pos = 0x1
	// Bit mask of TXRDY field.
	USART_CSR_SPI_MODE_TXRDY_Msk = 0x2
	// Bit TXRDY.
	USART_CSR_SPI_MODE_TXRDY = 0x2
	// Position of ENDRX field.
	USART_CSR_SPI_MODE_ENDRX_Pos = 0x3
	// Bit mask of ENDRX field.
	USART_CSR_SPI_MODE_ENDRX_Msk = 0x8
	// Bit ENDRX.
	USART_CSR_SPI_MODE_ENDRX = 0x8
	// Position of ENDTX field.
	USART_CSR_SPI_MODE_ENDTX_Pos = 0x4
	// Bit mask of ENDTX field.
	USART_CSR_SPI_MODE_ENDTX_Msk = 0x10
	// Bit ENDTX.
	USART_CSR_SPI_MODE_ENDTX = 0x10
	// Position of OVRE field.
	USART_CSR_SPI_MODE_OVRE_Pos = 0x5
	// Bit mask of OVRE field.
	USART_CSR_SPI_MODE_OVRE_Msk = 0x20
	// Bit OVRE.
	USART_CSR_SPI_MODE_OVRE = 0x20
	// Position of TXEMPTY field.
	USART_CSR_SPI_MODE_TXEMPTY_Pos = 0x9
	// Bit mask of TXEMPTY field.
	USART_CSR_SPI_MODE_TXEMPTY_Msk = 0x200
	// Bit TXEMPTY.
	USART_CSR_SPI_MODE_TXEMPTY = 0x200
	// Position of UNRE field.
	USART_CSR_SPI_MODE_UNRE_Pos = 0xa
	// Bit mask of UNRE field.
	USART_CSR_SPI_MODE_UNRE_Msk = 0x400
	// Bit UNRE.
	USART_CSR_SPI_MODE_UNRE = 0x400
	// Position of TXBUFE field.
	USART_CSR_SPI_MODE_TXBUFE_Pos = 0xb
	// Bit mask of TXBUFE field.
	USART_CSR_SPI_MODE_TXBUFE_Msk = 0x800
	// Bit TXBUFE.
	USART_CSR_SPI_MODE_TXBUFE = 0x800
	// Position of RXBUFF field.
	USART_CSR_SPI_MODE_RXBUFF_Pos = 0xc
	// Bit mask of RXBUFF field.
	USART_CSR_SPI_MODE_RXBUFF_Msk = 0x1000
	// Bit RXBUFF.
	USART_CSR_SPI_MODE_RXBUFF = 0x1000

	// RHR: Receiver Holding Register
	// Position of RXCHR field.
	USART_RHR_RXCHR_Pos = 0x0
	// Bit mask of RXCHR field.
	USART_RHR_RXCHR_Msk = 0x1ff
	// Position of RXSYNH field.
	USART_RHR_RXSYNH_Pos = 0xf
	// Bit mask of RXSYNH field.
	USART_RHR_RXSYNH_Msk = 0x8000
	// Bit RXSYNH.
	USART_RHR_RXSYNH = 0x8000

	// THR: Transmitter Holding Register
	// Position of TXCHR field.
	USART_THR_TXCHR_Pos = 0x0
	// Bit mask of TXCHR field.
	USART_THR_TXCHR_Msk = 0x1ff
	// Position of TXSYNH field.
	USART_THR_TXSYNH_Pos = 0xf
	// Bit mask of TXSYNH field.
	USART_THR_TXSYNH_Msk = 0x8000
	// Bit TXSYNH.
	USART_THR_TXSYNH = 0x8000

	// BRGR: Baud Rate Generator Register
	// Position of CD field.
	USART_BRGR_CD_Pos = 0x0
	// Bit mask of CD field.
	USART_BRGR_CD_Msk = 0xffff
	// Position of FP field.
	USART_BRGR_FP_Pos = 0x10
	// Bit mask of FP field.
	USART_BRGR_FP_Msk = 0x70000

	// RTOR: Receiver Time-out Register
	// Position of TO field.
	USART_RTOR_TO_Pos = 0x0
	// Bit mask of TO field.
	USART_RTOR_TO_Msk = 0xffff

	// TTGR: Transmitter Timeguard Register
	// Position of TG field.
	USART_TTGR_TG_Pos = 0x0
	// Bit mask of TG field.
	USART_TTGR_TG_Msk = 0xff

	// FIDI: FI DI Ratio Register
	// Position of FI_DI_RATIO field.
	USART_FIDI_FI_DI_RATIO_Pos = 0x0
	// Bit mask of FI_DI_RATIO field.
	USART_FIDI_FI_DI_RATIO_Msk = 0xffff

	// NER: Number of Errors Register
	// Position of NB_ERRORS field.
	USART_NER_NB_ERRORS_Pos = 0x0
	// Bit mask of NB_ERRORS field.
	USART_NER_NB_ERRORS_Msk = 0xff

	// IF: IrDA Filter Register
	// Position of IRDA_FILTER field.
	USART_IF_IRDA_FILTER_Pos = 0x0
	// Bit mask of IRDA_FILTER field.
	USART_IF_IRDA_FILTER_Msk = 0xff

	// MAN: Manchester Encoder Decoder Register
	// Position of TX_PL field.
	USART_MAN_TX_PL_Pos = 0x0
	// Bit mask of TX_PL field.
	USART_MAN_TX_PL_Msk = 0xf
	// Position of TX_PP field.
	USART_MAN_TX_PP_Pos = 0x8
	// Bit mask of TX_PP field.
	USART_MAN_TX_PP_Msk = 0x300
	// The preamble is composed of '1's
	USART_MAN_TX_PP_ALL_ONE = 0x0
	// The preamble is composed of '0's
	USART_MAN_TX_PP_ALL_ZERO = 0x1
	// The preamble is composed of '01's
	USART_MAN_TX_PP_ZERO_ONE = 0x2
	// The preamble is composed of '10's
	USART_MAN_TX_PP_ONE_ZERO = 0x3
	// Position of TX_MPOL field.
	USART_MAN_TX_MPOL_Pos = 0xc
	// Bit mask of TX_MPOL field.
	USART_MAN_TX_MPOL_Msk = 0x1000
	// Bit TX_MPOL.
	USART_MAN_TX_MPOL = 0x1000
	// Position of RX_PL field.
	USART_MAN_RX_PL_Pos = 0x10
	// Bit mask of RX_PL field.
	USART_MAN_RX_PL_Msk = 0xf0000
	// Position of RX_PP field.
	USART_MAN_RX_PP_Pos = 0x18
	// Bit mask of RX_PP field.
	USART_MAN_RX_PP_Msk = 0x3000000
	// The preamble is composed of '1's
	USART_MAN_RX_PP_ALL_ONE = 0x0
	// The preamble is composed of '0's
	USART_MAN_RX_PP_ALL_ZERO = 0x1
	// The preamble is composed of '01's
	USART_MAN_RX_PP_ZERO_ONE = 0x2
	// The preamble is composed of '10's
	USART_MAN_RX_PP_ONE_ZERO = 0x3
	// Position of RX_MPOL field.
	USART_MAN_RX_MPOL_Pos = 0x1c
	// Bit mask of RX_MPOL field.
	USART_MAN_RX_MPOL_Msk = 0x10000000
	// Bit RX_MPOL.
	USART_MAN_RX_MPOL = 0x10000000
	// Position of ONE field.
	USART_MAN_ONE_Pos = 0x1d
	// Bit mask of ONE field.
	USART_MAN_ONE_Msk = 0x20000000
	// Bit ONE.
	USART_MAN_ONE = 0x20000000
	// Position of DRIFT field.
	USART_MAN_DRIFT_Pos = 0x1e
	// Bit mask of DRIFT field.
	USART_MAN_DRIFT_Msk = 0x40000000
	// Bit DRIFT.
	USART_MAN_DRIFT = 0x40000000

	// WPMR: Write Protect Mode Register
	// Position of WPEN field.
	USART_WPMR_WPEN_Pos = 0x0
	// Bit mask of WPEN field.
	USART_WPMR_WPEN_Msk = 0x1
	// Bit WPEN.
	USART_WPMR_WPEN = 0x1
	// Position of WPKEY field.
	USART_WPMR_WPKEY_Pos = 0x8
	// Bit mask of WPKEY field.
	USART_WPMR_WPKEY_Msk = 0xffffff00
	// Writing any other value in this field aborts the write operation of the WPEN bit. Always reads as 0.
	USART_WPMR_WPKEY_PASSWD = 0x555341

	// WPSR: Write Protect Status Register
	// Position of WPVS field.
	USART_WPSR_WPVS_Pos = 0x0
	// Bit mask of WPVS field.
	USART_WPSR_WPVS_Msk = 0x1
	// Bit WPVS.
	USART_WPSR_WPVS = 0x1
	// Position of WPVSRC field.
	USART_WPSR_WPVSRC_Pos = 0x8
	// Bit mask of WPVSRC field.
	USART_WPSR_WPVSRC_Msk = 0xffff00

	// RPR: Receive Pointer Register
	// Position of RXPTR field.
	USART_RPR_RXPTR_Pos = 0x0
	// Bit mask of RXPTR field.
	USART_RPR_RXPTR_Msk = 0xffffffff

	// RCR: Receive Counter Register
	// Position of RXCTR field.
	USART_RCR_RXCTR_Pos = 0x0
	// Bit mask of RXCTR field.
	USART_RCR_RXCTR_Msk = 0xffff

	// TPR: Transmit Pointer Register
	// Position of TXPTR field.
	USART_TPR_TXPTR_Pos = 0x0
	// Bit mask of TXPTR field.
	USART_TPR_TXPTR_Msk = 0xffffffff

	// TCR: Transmit Counter Register
	// Position of TXCTR field.
	USART_TCR_TXCTR_Pos = 0x0
	// Bit mask of TXCTR field.
	USART_TCR_TXCTR_Msk = 0xffff

	// RNPR: Receive Next Pointer Register
	// Position of RXNPTR field.
	USART_RNPR_RXNPTR_Pos = 0x0
	// Bit mask of RXNPTR field.
	USART_RNPR_RXNPTR_Msk = 0xffffffff

	// RNCR: Receive Next Counter Register
	// Position of RXNCTR field.
	USART_RNCR_RXNCTR_Pos = 0x0
	// Bit mask of RXNCTR field.
	USART_RNCR_RXNCTR_Msk = 0xffff

	// TNPR: Transmit Next Pointer Register
	// Position of TXNPTR field.
	USART_TNPR_TXNPTR_Pos = 0x0
	// Bit mask of TXNPTR field.
	USART_TNPR_TXNPTR_Msk = 0xffffffff

	// TNCR: Transmit Next Counter Register
	// Position of TXNCTR field.
	USART_TNCR_TXNCTR_Pos = 0x0
	// Bit mask of TXNCTR field.
	USART_TNCR_TXNCTR_Msk = 0xffff

	// PTCR: Transfer Control Register
	// Position of RXTEN field.
	USART_PTCR_RXTEN_Pos = 0x0
	// Bit mask of RXTEN field.
	USART_PTCR_RXTEN_Msk = 0x1
	// Bit RXTEN.
	USART_PTCR_RXTEN = 0x1
	// Position of RXTDIS field.
	USART_PTCR_RXTDIS_Pos = 0x1
	// Bit mask of RXTDIS field.
	USART_PTCR_RXTDIS_Msk = 0x2
	// Bit RXTDIS.
	USART_PTCR_RXTDIS = 0x2
	// Position of TXTEN field.
	USART_PTCR_TXTEN_Pos = 0x8
	// Bit mask of TXTEN field.
	USART_PTCR_TXTEN_Msk = 0x100
	// Bit TXTEN.
	USART_PTCR_TXTEN = 0x100
	// Position of TXTDIS field.
	USART_PTCR_TXTDIS_Pos = 0x9
	// Bit mask of TXTDIS field.
	USART_PTCR_TXTDIS_Msk = 0x200
	// Bit TXTDIS.
	USART_PTCR_TXTDIS = 0x200

	// PTSR: Transfer Status Register
	// Position of RXTEN field.
	USART_PTSR_RXTEN_Pos = 0x0
	// Bit mask of RXTEN field.
	USART_PTSR_RXTEN_Msk = 0x1
	// Bit RXTEN.
	USART_PTSR_RXTEN = 0x1
	// Position of TXTEN field.
	USART_PTSR_TXTEN_Pos = 0x8
	// Bit mask of TXTEN field.
	USART_PTSR_TXTEN_Msk = 0x100
	// Bit TXTEN.
	USART_PTSR_TXTEN = 0x100
)

// Bitfields for UDPHS: USB High Speed Device Port
const (
	// CTRL: UDPHS Control Register
	// Position of DEV_ADDR field.
	UDPHS_CTRL_DEV_ADDR_Pos = 0x0
	// Bit mask of DEV_ADDR field.
	UDPHS_CTRL_DEV_ADDR_Msk = 0x7f
	// Position of FADDR_EN field.
	UDPHS_CTRL_FADDR_EN_Pos = 0x7
	// Bit mask of FADDR_EN field.
	UDPHS_CTRL_FADDR_EN_Msk = 0x80
	// Bit FADDR_EN.
	UDPHS_CTRL_FADDR_EN = 0x80
	// Position of EN_UDPHS field.
	UDPHS_CTRL_EN_UDPHS_Pos = 0x8
	// Bit mask of EN_UDPHS field.
	UDPHS_CTRL_EN_UDPHS_Msk = 0x100
	// Bit EN_UDPHS.
	UDPHS_CTRL_EN_UDPHS = 0x100
	// Position of DETACH field.
	UDPHS_CTRL_DETACH_Pos = 0x9
	// Bit mask of DETACH field.
	UDPHS_CTRL_DETACH_Msk = 0x200
	// Bit DETACH.
	UDPHS_CTRL_DETACH = 0x200
	// Position of REWAKEUP field.
	UDPHS_CTRL_REWAKEUP_Pos = 0xa
	// Bit mask of REWAKEUP field.
	UDPHS_CTRL_REWAKEUP_Msk = 0x400
	// Bit REWAKEUP.
	UDPHS_CTRL_REWAKEUP = 0x400
	// Position of PULLD_DIS field.
	UDPHS_CTRL_PULLD_DIS_Pos = 0xb
	// Bit mask of PULLD_DIS field.
	UDPHS_CTRL_PULLD_DIS_Msk = 0x800
	// Bit PULLD_DIS.
	UDPHS_CTRL_PULLD_DIS = 0x800

	// FNUM: UDPHS Frame Number Register
	// Position of MICRO_FRAME_NUM field.
	UDPHS_FNUM_MICRO_FRAME_NUM_Pos = 0x0
	// Bit mask of MICRO_FRAME_NUM field.
	UDPHS_FNUM_MICRO_FRAME_NUM_Msk = 0x7
	// Position of FRAME_NUMBER field.
	UDPHS_FNUM_FRAME_NUMBER_Pos = 0x3
	// Bit mask of FRAME_NUMBER field.
	UDPHS_FNUM_FRAME_NUMBER_Msk = 0x3ff8
	// Position of FNUM_ERR field.
	UDPHS_FNUM_FNUM_ERR_Pos = 0x1f
	// Bit mask of FNUM_ERR field.
	UDPHS_FNUM_FNUM_ERR_Msk = 0x80000000
	// Bit FNUM_ERR.
	UDPHS_FNUM_FNUM_ERR = 0x80000000

	// IEN: UDPHS Interrupt Enable Register
	// Position of DET_SUSPD field.
	UDPHS_IEN_DET_SUSPD_Pos = 0x1
	// Bit mask of DET_SUSPD field.
	UDPHS_IEN_DET_SUSPD_Msk = 0x2
	// Bit DET_SUSPD.
	UDPHS_IEN_DET_SUSPD = 0x2
	// Position of MICRO_SOF field.
	UDPHS_IEN_MICRO_SOF_Pos = 0x2
	// Bit mask of MICRO_SOF field.
	UDPHS_IEN_MICRO_SOF_Msk = 0x4
	// Bit MICRO_SOF.
	UDPHS_IEN_MICRO_SOF = 0x4
	// Position of INT_SOF field.
	UDPHS_IEN_INT_SOF_Pos = 0x3
	// Bit mask of INT_SOF field.
	UDPHS_IEN_INT_SOF_Msk = 0x8
	// Bit INT_SOF.
	UDPHS_IEN_INT_SOF = 0x8
	// Position of ENDRESET field.
	UDPHS_IEN_ENDRESET_Pos = 0x4
	// Bit mask of ENDRESET field.
	UDPHS_IEN_ENDRESET_Msk = 0x10
	// Bit ENDRESET.
	UDPHS_IEN_ENDRESET = 0x10
	// Position of WAKE_UP field.
	UDPHS_IEN_WAKE_UP_Pos = 0x5
	// Bit mask of WAKE_UP field.
	UDPHS_IEN_WAKE_UP_Msk = 0x20
	// Bit WAKE_UP.
	UDPHS_IEN_WAKE_UP = 0x20
	// Position of ENDOFRSM field.
	UDPHS_IEN_ENDOFRSM_Pos = 0x6
	// Bit mask of ENDOFRSM field.
	UDPHS_IEN_ENDOFRSM_Msk = 0x40
	// Bit ENDOFRSM.
	UDPHS_IEN_ENDOFRSM = 0x40
	// Position of UPSTR_RES field.
	UDPHS_IEN_UPSTR_RES_Pos = 0x7
	// Bit mask of UPSTR_RES field.
	UDPHS_IEN_UPSTR_RES_Msk = 0x80
	// Bit UPSTR_RES.
	UDPHS_IEN_UPSTR_RES = 0x80
	// Position of EPT_0 field.
	UDPHS_IEN_EPT_0_Pos = 0x8
	// Bit mask of EPT_0 field.
	UDPHS_IEN_EPT_0_Msk = 0x100
	// Bit EPT_0.
	UDPHS_IEN_EPT_0 = 0x100
	// Position of EPT_1 field.
	UDPHS_IEN_EPT_1_Pos = 0x9
	// Bit mask of EPT_1 field.
	UDPHS_IEN_EPT_1_Msk = 0x200
	// Bit EPT_1.
	UDPHS_IEN_EPT_1 = 0x200
	// Position of EPT_2 field.
	UDPHS_IEN_EPT_2_Pos = 0xa
	// Bit mask of EPT_2 field.
	UDPHS_IEN_EPT_2_Msk = 0x400
	// Bit EPT_2.
	UDPHS_IEN_EPT_2 = 0x400
	// Position of EPT_3 field.
	UDPHS_IEN_EPT_3_Pos = 0xb
	// Bit mask of EPT_3 field.
	UDPHS_IEN_EPT_3_Msk = 0x800
	// Bit EPT_3.
	UDPHS_IEN_EPT_3 = 0x800
	// Position of EPT_4 field.
	UDPHS_IEN_EPT_4_Pos = 0xc
	// Bit mask of EPT_4 field.
	UDPHS_IEN_EPT_4_Msk = 0x1000
	// Bit EPT_4.
	UDPHS_IEN_EPT_4 = 0x1000
	// Position of EPT_5 field.
	UDPHS_IEN_EPT_5_Pos = 0xd
	// Bit mask of EPT_5 field.
	UDPHS_IEN_EPT_5_Msk = 0x2000
	// Bit EPT_5.
	UDPHS_IEN_EPT_5 = 0x2000
	// Position of EPT_6 field.
	UDPHS_IEN_EPT_6_Pos = 0xe
	// Bit mask of EPT_6 field.
	UDPHS_IEN_EPT_6_Msk = 0x4000
	// Bit EPT_6.
	UDPHS_IEN_EPT_6 = 0x4000
	// Position of DMA_1 field.
	UDPHS_IEN_DMA_1_Pos = 0x19
	// Bit mask of DMA_1 field.
	UDPHS_IEN_DMA_1_Msk = 0x2000000
	// Bit DMA_1.
	UDPHS_IEN_DMA_1 = 0x2000000
	// Position of DMA_2 field.
	UDPHS_IEN_DMA_2_Pos = 0x1a
	// Bit mask of DMA_2 field.
	UDPHS_IEN_DMA_2_Msk = 0x4000000
	// Bit DMA_2.
	UDPHS_IEN_DMA_2 = 0x4000000
	// Position of DMA_3 field.
	UDPHS_IEN_DMA_3_Pos = 0x1b
	// Bit mask of DMA_3 field.
	UDPHS_IEN_DMA_3_Msk = 0x8000000
	// Bit DMA_3.
	UDPHS_IEN_DMA_3 = 0x8000000
	// Position of DMA_4 field.
	UDPHS_IEN_DMA_4_Pos = 0x1c
	// Bit mask of DMA_4 field.
	UDPHS_IEN_DMA_4_Msk = 0x10000000
	// Bit DMA_4.
	UDPHS_IEN_DMA_4 = 0x10000000
	// Position of DMA_5 field.
	UDPHS_IEN_DMA_5_Pos = 0x1d
	// Bit mask of DMA_5 field.
	UDPHS_IEN_DMA_5_Msk = 0x20000000
	// Bit DMA_5.
	UDPHS_IEN_DMA_5 = 0x20000000
	// Position of DMA_6 field.
	UDPHS_IEN_DMA_6_Pos = 0x1e
	// Bit mask of DMA_6 field.
	UDPHS_IEN_DMA_6_Msk = 0x40000000
	// Bit DMA_6.
	UDPHS_IEN_DMA_6 = 0x40000000

	// INTSTA: UDPHS Interrupt Status Register
	// Position of SPEED field.
	UDPHS_INTSTA_SPEED_Pos = 0x0
	// Bit mask of SPEED field.
	UDPHS_INTSTA_SPEED_Msk = 0x1
	// Bit SPEED.
	UDPHS_INTSTA_SPEED = 0x1
	// Position of DET_SUSPD field.
	UDPHS_INTSTA_DET_SUSPD_Pos = 0x1
	// Bit mask of DET_SUSPD field.
	UDPHS_INTSTA_DET_SUSPD_Msk = 0x2
	// Bit DET_SUSPD.
	UDPHS_INTSTA_DET_SUSPD = 0x2
	// Position of MICRO_SOF field.
	UDPHS_INTSTA_MICRO_SOF_Pos = 0x2
	// Bit mask of MICRO_SOF field.
	UDPHS_INTSTA_MICRO_SOF_Msk = 0x4
	// Bit MICRO_SOF.
	UDPHS_INTSTA_MICRO_SOF = 0x4
	// Position of INT_SOF field.
	UDPHS_INTSTA_INT_SOF_Pos = 0x3
	// Bit mask of INT_SOF field.
	UDPHS_INTSTA_INT_SOF_Msk = 0x8
	// Bit INT_SOF.
	UDPHS_INTSTA_INT_SOF = 0x8
	// Position of ENDRESET field.
	UDPHS_INTSTA_ENDRESET_Pos = 0x4
	// Bit mask of ENDRESET field.
	UDPHS_INTSTA_ENDRESET_Msk = 0x10
	// Bit ENDRESET.
	UDPHS_INTSTA_ENDRESET = 0x10
	// Position of WAKE_UP field.
	UDPHS_INTSTA_WAKE_UP_Pos = 0x5
	// Bit mask of WAKE_UP field.
	UDPHS_INTSTA_WAKE_UP_Msk = 0x20
	// Bit WAKE_UP.
	UDPHS_INTSTA_WAKE_UP = 0x20
	// Position of ENDOFRSM field.
	UDPHS_INTSTA_ENDOFRSM_Pos = 0x6
	// Bit mask of ENDOFRSM field.
	UDPHS_INTSTA_ENDOFRSM_Msk = 0x40
	// Bit ENDOFRSM.
	UDPHS_INTSTA_ENDOFRSM = 0x40
	// Position of UPSTR_RES field.
	UDPHS_INTSTA_UPSTR_RES_Pos = 0x7
	// Bit mask of UPSTR_RES field.
	UDPHS_INTSTA_UPSTR_RES_Msk = 0x80
	// Bit UPSTR_RES.
	UDPHS_INTSTA_UPSTR_RES = 0x80
	// Position of EPT_0 field.
	UDPHS_INTSTA_EPT_0_Pos = 0x8
	// Bit mask of EPT_0 field.
	UDPHS_INTSTA_EPT_0_Msk = 0x100
	// Bit EPT_0.
	UDPHS_INTSTA_EPT_0 = 0x100
	// Position of EPT_1 field.
	UDPHS_INTSTA_EPT_1_Pos = 0x9
	// Bit mask of EPT_1 field.
	UDPHS_INTSTA_EPT_1_Msk = 0x200
	// Bit EPT_1.
	UDPHS_INTSTA_EPT_1 = 0x200
	// Position of EPT_2 field.
	UDPHS_INTSTA_EPT_2_Pos = 0xa
	// Bit mask of EPT_2 field.
	UDPHS_INTSTA_EPT_2_Msk = 0x400
	// Bit EPT_2.
	UDPHS_INTSTA_EPT_2 = 0x400
	// Position of EPT_3 field.
	UDPHS_INTSTA_EPT_3_Pos = 0xb
	// Bit mask of EPT_3 field.
	UDPHS_INTSTA_EPT_3_Msk = 0x800
	// Bit EPT_3.
	UDPHS_INTSTA_EPT_3 = 0x800
	// Position of EPT_4 field.
	UDPHS_INTSTA_EPT_4_Pos = 0xc
	// Bit mask of EPT_4 field.
	UDPHS_INTSTA_EPT_4_Msk = 0x1000
	// Bit EPT_4.
	UDPHS_INTSTA_EPT_4 = 0x1000
	// Position of EPT_5 field.
	UDPHS_INTSTA_EPT_5_Pos = 0xd
	// Bit mask of EPT_5 field.
	UDPHS_INTSTA_EPT_5_Msk = 0x2000
	// Bit EPT_5.
	UDPHS_INTSTA_EPT_5 = 0x2000
	// Position of EPT_6 field.
	UDPHS_INTSTA_EPT_6_Pos = 0xe
	// Bit mask of EPT_6 field.
	UDPHS_INTSTA_EPT_6_Msk = 0x4000
	// Bit EPT_6.
	UDPHS_INTSTA_EPT_6 = 0x4000
	// Position of DMA_1 field.
	UDPHS_INTSTA_DMA_1_Pos = 0x19
	// Bit mask of DMA_1 field.
	UDPHS_INTSTA_DMA_1_Msk = 0x2000000
	// Bit DMA_1.
	UDPHS_INTSTA_DMA_1 = 0x2000000
	// Position of DMA_2 field.
	UDPHS_INTSTA_DMA_2_Pos = 0x1a
	// Bit mask of DMA_2 field.
	UDPHS_INTSTA_DMA_2_Msk = 0x4000000
	// Bit DMA_2.
	UDPHS_INTSTA_DMA_2 = 0x4000000
	// Position of DMA_3 field.
	UDPHS_INTSTA_DMA_3_Pos = 0x1b
	// Bit mask of DMA_3 field.
	UDPHS_INTSTA_DMA_3_Msk = 0x8000000
	// Bit DMA_3.
	UDPHS_INTSTA_DMA_3 = 0x8000000
	// Position of DMA_4 field.
	UDPHS_INTSTA_DMA_4_Pos = 0x1c
	// Bit mask of DMA_4 field.
	UDPHS_INTSTA_DMA_4_Msk = 0x10000000
	// Bit DMA_4.
	UDPHS_INTSTA_DMA_4 = 0x10000000
	// Position of DMA_5 field.
	UDPHS_INTSTA_DMA_5_Pos = 0x1d
	// Bit mask of DMA_5 field.
	UDPHS_INTSTA_DMA_5_Msk = 0x20000000
	// Bit DMA_5.
	UDPHS_INTSTA_DMA_5 = 0x20000000
	// Position of DMA_6 field.
	UDPHS_INTSTA_DMA_6_Pos = 0x1e
	// Bit mask of DMA_6 field.
	UDPHS_INTSTA_DMA_6_Msk = 0x40000000
	// Bit DMA_6.
	UDPHS_INTSTA_DMA_6 = 0x40000000

	// CLRINT: UDPHS Clear Interrupt Register
	// Position of DET_SUSPD field.
	UDPHS_CLRINT_DET_SUSPD_Pos = 0x1
	// Bit mask of DET_SUSPD field.
	UDPHS_CLRINT_DET_SUSPD_Msk = 0x2
	// Bit DET_SUSPD.
	UDPHS_CLRINT_DET_SUSPD = 0x2
	// Position of MICRO_SOF field.
	UDPHS_CLRINT_MICRO_SOF_Pos = 0x2
	// Bit mask of MICRO_SOF field.
	UDPHS_CLRINT_MICRO_SOF_Msk = 0x4
	// Bit MICRO_SOF.
	UDPHS_CLRINT_MICRO_SOF = 0x4
	// Position of INT_SOF field.
	UDPHS_CLRINT_INT_SOF_Pos = 0x3
	// Bit mask of INT_SOF field.
	UDPHS_CLRINT_INT_SOF_Msk = 0x8
	// Bit INT_SOF.
	UDPHS_CLRINT_INT_SOF = 0x8
	// Position of ENDRESET field.
	UDPHS_CLRINT_ENDRESET_Pos = 0x4
	// Bit mask of ENDRESET field.
	UDPHS_CLRINT_ENDRESET_Msk = 0x10
	// Bit ENDRESET.
	UDPHS_CLRINT_ENDRESET = 0x10
	// Position of WAKE_UP field.
	UDPHS_CLRINT_WAKE_UP_Pos = 0x5
	// Bit mask of WAKE_UP field.
	UDPHS_CLRINT_WAKE_UP_Msk = 0x20
	// Bit WAKE_UP.
	UDPHS_CLRINT_WAKE_UP = 0x20
	// Position of ENDOFRSM field.
	UDPHS_CLRINT_ENDOFRSM_Pos = 0x6
	// Bit mask of ENDOFRSM field.
	UDPHS_CLRINT_ENDOFRSM_Msk = 0x40
	// Bit ENDOFRSM.
	UDPHS_CLRINT_ENDOFRSM = 0x40
	// Position of UPSTR_RES field.
	UDPHS_CLRINT_UPSTR_RES_Pos = 0x7
	// Bit mask of UPSTR_RES field.
	UDPHS_CLRINT_UPSTR_RES_Msk = 0x80
	// Bit UPSTR_RES.
	UDPHS_CLRINT_UPSTR_RES = 0x80

	// EPTRST: UDPHS Endpoints Reset Register
	// Position of EPT_0 field.
	UDPHS_EPTRST_EPT_0_Pos = 0x0
	// Bit mask of EPT_0 field.
	UDPHS_EPTRST_EPT_0_Msk = 0x1
	// Bit EPT_0.
	UDPHS_EPTRST_EPT_0 = 0x1
	// Position of EPT_1 field.
	UDPHS_EPTRST_EPT_1_Pos = 0x1
	// Bit mask of EPT_1 field.
	UDPHS_EPTRST_EPT_1_Msk = 0x2
	// Bit EPT_1.
	UDPHS_EPTRST_EPT_1 = 0x2
	// Position of EPT_2 field.
	UDPHS_EPTRST_EPT_2_Pos = 0x2
	// Bit mask of EPT_2 field.
	UDPHS_EPTRST_EPT_2_Msk = 0x4
	// Bit EPT_2.
	UDPHS_EPTRST_EPT_2 = 0x4
	// Position of EPT_3 field.
	UDPHS_EPTRST_EPT_3_Pos = 0x3
	// Bit mask of EPT_3 field.
	UDPHS_EPTRST_EPT_3_Msk = 0x8
	// Bit EPT_3.
	UDPHS_EPTRST_EPT_3 = 0x8
	// Position of EPT_4 field.
	UDPHS_EPTRST_EPT_4_Pos = 0x4
	// Bit mask of EPT_4 field.
	UDPHS_EPTRST_EPT_4_Msk = 0x10
	// Bit EPT_4.
	UDPHS_EPTRST_EPT_4 = 0x10
	// Position of EPT_5 field.
	UDPHS_EPTRST_EPT_5_Pos = 0x5
	// Bit mask of EPT_5 field.
	UDPHS_EPTRST_EPT_5_Msk = 0x20
	// Bit EPT_5.
	UDPHS_EPTRST_EPT_5 = 0x20
	// Position of EPT_6 field.
	UDPHS_EPTRST_EPT_6_Pos = 0x6
	// Bit mask of EPT_6 field.
	UDPHS_EPTRST_EPT_6_Msk = 0x40
	// Bit EPT_6.
	UDPHS_EPTRST_EPT_6 = 0x40

	// TST: UDPHS Test Register
	// Position of SPEED_CFG field.
	UDPHS_TST_SPEED_CFG_Pos = 0x0
	// Bit mask of SPEED_CFG field.
	UDPHS_TST_SPEED_CFG_Msk = 0x3
	// Normal Mode: The macro is in Full Speed mode, ready to make a High Speed identification, if the host supports it and then to automatically switch to High Speed mode
	UDPHS_TST_SPEED_CFG_NORMAL = 0x0
	// Force High Speed: Set this value to force the hardware to work in High Speed mode. Only for debug or test purpose.
	UDPHS_TST_SPEED_CFG_HIGH_SPEED = 0x2
	// Force Full Speed: Set this value to force the hardware to work only in Full Speed mode. In this configuration, the macro will not respond to a High Speed reset handshake.
	UDPHS_TST_SPEED_CFG_FULL_SPEED = 0x3
	// Position of TST_J field.
	UDPHS_TST_TST_J_Pos = 0x2
	// Bit mask of TST_J field.
	UDPHS_TST_TST_J_Msk = 0x4
	// Bit TST_J.
	UDPHS_TST_TST_J = 0x4
	// Position of TST_K field.
	UDPHS_TST_TST_K_Pos = 0x3
	// Bit mask of TST_K field.
	UDPHS_TST_TST_K_Msk = 0x8
	// Bit TST_K.
	UDPHS_TST_TST_K = 0x8
	// Position of TST_PKT field.
	UDPHS_TST_TST_PKT_Pos = 0x4
	// Bit mask of TST_PKT field.
	UDPHS_TST_TST_PKT_Msk = 0x10
	// Bit TST_PKT.
	UDPHS_TST_TST_PKT = 0x10
	// Position of OPMODE2 field.
	UDPHS_TST_OPMODE2_Pos = 0x5
	// Bit mask of OPMODE2 field.
	UDPHS_TST_OPMODE2_Msk = 0x20
	// Bit OPMODE2.
	UDPHS_TST_OPMODE2 = 0x20

	// EPTCFG0: UDPHS Endpoint Configuration Register (endpoint = 0)
	// Position of EPT_SIZE field.
	UDPHS_EPTCFG0_EPT_SIZE_Pos = 0x0
	// Bit mask of EPT_SIZE field.
	UDPHS_EPTCFG0_EPT_SIZE_Msk = 0x7
	// 8 bytes
	UDPHS_EPTCFG0_EPT_SIZE_8 = 0x0
	// 16 bytes
	UDPHS_EPTCFG0_EPT_SIZE_16 = 0x1
	// 32 bytes
	UDPHS_EPTCFG0_EPT_SIZE_32 = 0x2
	// 64 bytes
	UDPHS_EPTCFG0_EPT_SIZE_64 = 0x3
	// 128 bytes
	UDPHS_EPTCFG0_EPT_SIZE_128 = 0x4
	// 256 bytes
	UDPHS_EPTCFG0_EPT_SIZE_256 = 0x5
	// 512 bytes
	UDPHS_EPTCFG0_EPT_SIZE_512 = 0x6
	// 1024 bytes
	UDPHS_EPTCFG0_EPT_SIZE_1024 = 0x7
	// Position of EPT_DIR field.
	UDPHS_EPTCFG0_EPT_DIR_Pos = 0x3
	// Bit mask of EPT_DIR field.
	UDPHS_EPTCFG0_EPT_DIR_Msk = 0x8
	// Bit EPT_DIR.
	UDPHS_EPTCFG0_EPT_DIR = 0x8
	// Position of EPT_TYPE field.
	UDPHS_EPTCFG0_EPT_TYPE_Pos = 0x4
	// Bit mask of EPT_TYPE field.
	UDPHS_EPTCFG0_EPT_TYPE_Msk = 0x30
	// Control endpoint
	UDPHS_EPTCFG0_EPT_TYPE_CTRL8 = 0x0
	// Isochronous endpoint
	UDPHS_EPTCFG0_EPT_TYPE_ISO = 0x1
	// Bulk endpoint
	UDPHS_EPTCFG0_EPT_TYPE_BULK = 0x2
	// Interrupt endpoint
	UDPHS_EPTCFG0_EPT_TYPE_INT = 0x3
	// Position of BK_NUMBER field.
	UDPHS_EPTCFG0_BK_NUMBER_Pos = 0x6
	// Bit mask of BK_NUMBER field.
	UDPHS_EPTCFG0_BK_NUMBER_Msk = 0xc0
	// Zero bank, the endpoint is not mapped in memory
	UDPHS_EPTCFG0_BK_NUMBER_0 = 0x0
	// One bank (bank 0)
	UDPHS_EPTCFG0_BK_NUMBER_1 = 0x1
	// Double bank (Ping-Pong: bank0/bank1)
	UDPHS_EPTCFG0_BK_NUMBER_2 = 0x2
	// Triple bank (bank0/bank1/bank2)
	UDPHS_EPTCFG0_BK_NUMBER_3 = 0x3
	// Position of NB_TRANS field.
	UDPHS_EPTCFG0_NB_TRANS_Pos = 0x8
	// Bit mask of NB_TRANS field.
	UDPHS_EPTCFG0_NB_TRANS_Msk = 0x300
	// Position of EPT_MAPD field.
	UDPHS_EPTCFG0_EPT_MAPD_Pos = 0x1f
	// Bit mask of EPT_MAPD field.
	UDPHS_EPTCFG0_EPT_MAPD_Msk = 0x80000000
	// Bit EPT_MAPD.
	UDPHS_EPTCFG0_EPT_MAPD = 0x80000000

	// EPTCTLENB0: UDPHS Endpoint Control Enable Register (endpoint = 0)
	// Position of EPT_ENABL field.
	UDPHS_EPTCTLENB0_EPT_ENABL_Pos = 0x0
	// Bit mask of EPT_ENABL field.
	UDPHS_EPTCTLENB0_EPT_ENABL_Msk = 0x1
	// Bit EPT_ENABL.
	UDPHS_EPTCTLENB0_EPT_ENABL = 0x1
	// Position of AUTO_VALID field.
	UDPHS_EPTCTLENB0_AUTO_VALID_Pos = 0x1
	// Bit mask of AUTO_VALID field.
	UDPHS_EPTCTLENB0_AUTO_VALID_Msk = 0x2
	// Bit AUTO_VALID.
	UDPHS_EPTCTLENB0_AUTO_VALID = 0x2
	// Position of INTDIS_DMA field.
	UDPHS_EPTCTLENB0_INTDIS_DMA_Pos = 0x3
	// Bit mask of INTDIS_DMA field.
	UDPHS_EPTCTLENB0_INTDIS_DMA_Msk = 0x8
	// Bit INTDIS_DMA.
	UDPHS_EPTCTLENB0_INTDIS_DMA = 0x8
	// Position of NYET_DIS field.
	UDPHS_EPTCTLENB0_NYET_DIS_Pos = 0x4
	// Bit mask of NYET_DIS field.
	UDPHS_EPTCTLENB0_NYET_DIS_Msk = 0x10
	// Bit NYET_DIS.
	UDPHS_EPTCTLENB0_NYET_DIS = 0x10
	// Position of ERR_OVFLW field.
	UDPHS_EPTCTLENB0_ERR_OVFLW_Pos = 0x8
	// Bit mask of ERR_OVFLW field.
	UDPHS_EPTCTLENB0_ERR_OVFLW_Msk = 0x100
	// Bit ERR_OVFLW.
	UDPHS_EPTCTLENB0_ERR_OVFLW = 0x100
	// Position of RXRDY_TXKL field.
	UDPHS_EPTCTLENB0_RXRDY_TXKL_Pos = 0x9
	// Bit mask of RXRDY_TXKL field.
	UDPHS_EPTCTLENB0_RXRDY_TXKL_Msk = 0x200
	// Bit RXRDY_TXKL.
	UDPHS_EPTCTLENB0_RXRDY_TXKL = 0x200
	// Position of TX_COMPLT field.
	UDPHS_EPTCTLENB0_TX_COMPLT_Pos = 0xa
	// Bit mask of TX_COMPLT field.
	UDPHS_EPTCTLENB0_TX_COMPLT_Msk = 0x400
	// Bit TX_COMPLT.
	UDPHS_EPTCTLENB0_TX_COMPLT = 0x400
	// Position of TXRDY field.
	UDPHS_EPTCTLENB0_TXRDY_Pos = 0xb
	// Bit mask of TXRDY field.
	UDPHS_EPTCTLENB0_TXRDY_Msk = 0x800
	// Bit TXRDY.
	UDPHS_EPTCTLENB0_TXRDY = 0x800
	// Position of RX_SETUP field.
	UDPHS_EPTCTLENB0_RX_SETUP_Pos = 0xc
	// Bit mask of RX_SETUP field.
	UDPHS_EPTCTLENB0_RX_SETUP_Msk = 0x1000
	// Bit RX_SETUP.
	UDPHS_EPTCTLENB0_RX_SETUP = 0x1000
	// Position of STALL_SNT field.
	UDPHS_EPTCTLENB0_STALL_SNT_Pos = 0xd
	// Bit mask of STALL_SNT field.
	UDPHS_EPTCTLENB0_STALL_SNT_Msk = 0x2000
	// Bit STALL_SNT.
	UDPHS_EPTCTLENB0_STALL_SNT = 0x2000
	// Position of NAK_IN field.
	UDPHS_EPTCTLENB0_NAK_IN_Pos = 0xe
	// Bit mask of NAK_IN field.
	UDPHS_EPTCTLENB0_NAK_IN_Msk = 0x4000
	// Bit NAK_IN.
	UDPHS_EPTCTLENB0_NAK_IN = 0x4000
	// Position of NAK_OUT field.
	UDPHS_EPTCTLENB0_NAK_OUT_Pos = 0xf
	// Bit mask of NAK_OUT field.
	UDPHS_EPTCTLENB0_NAK_OUT_Msk = 0x8000
	// Bit NAK_OUT.
	UDPHS_EPTCTLENB0_NAK_OUT = 0x8000
	// Position of BUSY_BANK field.
	UDPHS_EPTCTLENB0_BUSY_BANK_Pos = 0x12
	// Bit mask of BUSY_BANK field.
	UDPHS_EPTCTLENB0_BUSY_BANK_Msk = 0x40000
	// Bit BUSY_BANK.
	UDPHS_EPTCTLENB0_BUSY_BANK = 0x40000
	// Position of SHRT_PCKT field.
	UDPHS_EPTCTLENB0_SHRT_PCKT_Pos = 0x1f
	// Bit mask of SHRT_PCKT field.
	UDPHS_EPTCTLENB0_SHRT_PCKT_Msk = 0x80000000
	// Bit SHRT_PCKT.
	UDPHS_EPTCTLENB0_SHRT_PCKT = 0x80000000

	// EPTCTLENB0_ISOENDPT: UDPHS Endpoint Control Enable Register (endpoint = 0)
	// Position of EPT_ENABL field.
	UDPHS_EPTCTLENB0_ISOENDPT_EPT_ENABL_Pos = 0x0
	// Bit mask of EPT_ENABL field.
	UDPHS_EPTCTLENB0_ISOENDPT_EPT_ENABL_Msk = 0x1
	// Bit EPT_ENABL.
	UDPHS_EPTCTLENB0_ISOENDPT_EPT_ENABL = 0x1
	// Position of AUTO_VALID field.
	UDPHS_EPTCTLENB0_ISOENDPT_AUTO_VALID_Pos = 0x1
	// Bit mask of AUTO_VALID field.
	UDPHS_EPTCTLENB0_ISOENDPT_AUTO_VALID_Msk = 0x2
	// Bit AUTO_VALID.
	UDPHS_EPTCTLENB0_ISOENDPT_AUTO_VALID = 0x2
	// Position of INTDIS_DMA field.
	UDPHS_EPTCTLENB0_ISOENDPT_INTDIS_DMA_Pos = 0x3
	// Bit mask of INTDIS_DMA field.
	UDPHS_EPTCTLENB0_ISOENDPT_INTDIS_DMA_Msk = 0x8
	// Bit INTDIS_DMA.
	UDPHS_EPTCTLENB0_ISOENDPT_INTDIS_DMA = 0x8
	// Position of DATAX_RX field.
	UDPHS_EPTCTLENB0_ISOENDPT_DATAX_RX_Pos = 0x6
	// Bit mask of DATAX_RX field.
	UDPHS_EPTCTLENB0_ISOENDPT_DATAX_RX_Msk = 0x40
	// Bit DATAX_RX.
	UDPHS_EPTCTLENB0_ISOENDPT_DATAX_RX = 0x40
	// Position of MDATA_RX field.
	UDPHS_EPTCTLENB0_ISOENDPT_MDATA_RX_Pos = 0x7
	// Bit mask of MDATA_RX field.
	UDPHS_EPTCTLENB0_ISOENDPT_MDATA_RX_Msk = 0x80
	// Bit MDATA_RX.
	UDPHS_EPTCTLENB0_ISOENDPT_MDATA_RX = 0x80
	// Position of ERR_OVFLW field.
	UDPHS_EPTCTLENB0_ISOENDPT_ERR_OVFLW_Pos = 0x8
	// Bit mask of ERR_OVFLW field.
	UDPHS_EPTCTLENB0_ISOENDPT_ERR_OVFLW_Msk = 0x100
	// Bit ERR_OVFLW.
	UDPHS_EPTCTLENB0_ISOENDPT_ERR_OVFLW = 0x100
	// Position of RXRDY_TXKL field.
	UDPHS_EPTCTLENB0_ISOENDPT_RXRDY_TXKL_Pos = 0x9
	// Bit mask of RXRDY_TXKL field.
	UDPHS_EPTCTLENB0_ISOENDPT_RXRDY_TXKL_Msk = 0x200
	// Bit RXRDY_TXKL.
	UDPHS_EPTCTLENB0_ISOENDPT_RXRDY_TXKL = 0x200
	// Position of TX_COMPLT field.
	UDPHS_EPTCTLENB0_ISOENDPT_TX_COMPLT_Pos = 0xa
	// Bit mask of TX_COMPLT field.
	UDPHS_EPTCTLENB0_ISOENDPT_TX_COMPLT_Msk = 0x400
	// Bit TX_COMPLT.
	UDPHS_EPTCTLENB0_ISOENDPT_TX_COMPLT = 0x400
	// Position of TXRDY_TRER field.
	UDPHS_EPTCTLENB0_ISOENDPT_TXRDY_TRER_Pos = 0xb
	// Bit mask of TXRDY_TRER field.
	UDPHS_EPTCTLENB0_ISOENDPT_TXRDY_TRER_Msk = 0x800
	// Bit TXRDY_TRER.
	UDPHS_EPTCTLENB0_ISOENDPT_TXRDY_TRER = 0x800
	// Position of ERR_FL_ISO field.
	UDPHS_EPTCTLENB0_ISOENDPT_ERR_FL_ISO_Pos = 0xc
	// Bit mask of ERR_FL_ISO field.
	UDPHS_EPTCTLENB0_ISOENDPT_ERR_FL_ISO_Msk = 0x1000
	// Bit ERR_FL_ISO.
	UDPHS_EPTCTLENB0_ISOENDPT_ERR_FL_ISO = 0x1000
	// Position of ERR_CRC_NTR field.
	UDPHS_EPTCTLENB0_ISOENDPT_ERR_CRC_NTR_Pos = 0xd
	// Bit mask of ERR_CRC_NTR field.
	UDPHS_EPTCTLENB0_ISOENDPT_ERR_CRC_NTR_Msk = 0x2000
	// Bit ERR_CRC_NTR.
	UDPHS_EPTCTLENB0_ISOENDPT_ERR_CRC_NTR = 0x2000
	// Position of ERR_FLUSH field.
	UDPHS_EPTCTLENB0_ISOENDPT_ERR_FLUSH_Pos = 0xe
	// Bit mask of ERR_FLUSH field.
	UDPHS_EPTCTLENB0_ISOENDPT_ERR_FLUSH_Msk = 0x4000
	// Bit ERR_FLUSH.
	UDPHS_EPTCTLENB0_ISOENDPT_ERR_FLUSH = 0x4000
	// Position of BUSY_BANK field.
	UDPHS_EPTCTLENB0_ISOENDPT_BUSY_BANK_Pos = 0x12
	// Bit mask of BUSY_BANK field.
	UDPHS_EPTCTLENB0_ISOENDPT_BUSY_BANK_Msk = 0x40000
	// Bit BUSY_BANK.
	UDPHS_EPTCTLENB0_ISOENDPT_BUSY_BANK = 0x40000
	// Position of SHRT_PCKT field.
	UDPHS_EPTCTLENB0_ISOENDPT_SHRT_PCKT_Pos = 0x1f
	// Bit mask of SHRT_PCKT field.
	UDPHS_EPTCTLENB0_ISOENDPT_SHRT_PCKT_Msk = 0x80000000
	// Bit SHRT_PCKT.
	UDPHS_EPTCTLENB0_ISOENDPT_SHRT_PCKT = 0x80000000

	// EPTCTLDIS0: UDPHS Endpoint Control Disable Register (endpoint = 0)
	// Position of EPT_DISABL field.
	UDPHS_EPTCTLDIS0_EPT_DISABL_Pos = 0x0
	// Bit mask of EPT_DISABL field.
	UDPHS_EPTCTLDIS0_EPT_DISABL_Msk = 0x1
	// Bit EPT_DISABL.
	UDPHS_EPTCTLDIS0_EPT_DISABL = 0x1
	// Position of AUTO_VALID field.
	UDPHS_EPTCTLDIS0_AUTO_VALID_Pos = 0x1
	// Bit mask of AUTO_VALID field.
	UDPHS_EPTCTLDIS0_AUTO_VALID_Msk = 0x2
	// Bit AUTO_VALID.
	UDPHS_EPTCTLDIS0_AUTO_VALID = 0x2
	// Position of INTDIS_DMA field.
	UDPHS_EPTCTLDIS0_INTDIS_DMA_Pos = 0x3
	// Bit mask of INTDIS_DMA field.
	UDPHS_EPTCTLDIS0_INTDIS_DMA_Msk = 0x8
	// Bit INTDIS_DMA.
	UDPHS_EPTCTLDIS0_INTDIS_DMA = 0x8
	// Position of NYET_DIS field.
	UDPHS_EPTCTLDIS0_NYET_DIS_Pos = 0x4
	// Bit mask of NYET_DIS field.
	UDPHS_EPTCTLDIS0_NYET_DIS_Msk = 0x10
	// Bit NYET_DIS.
	UDPHS_EPTCTLDIS0_NYET_DIS = 0x10
	// Position of ERR_OVFLW field.
	UDPHS_EPTCTLDIS0_ERR_OVFLW_Pos = 0x8
	// Bit mask of ERR_OVFLW field.
	UDPHS_EPTCTLDIS0_ERR_OVFLW_Msk = 0x100
	// Bit ERR_OVFLW.
	UDPHS_EPTCTLDIS0_ERR_OVFLW = 0x100
	// Position of RXRDY_TXKL field.
	UDPHS_EPTCTLDIS0_RXRDY_TXKL_Pos = 0x9
	// Bit mask of RXRDY_TXKL field.
	UDPHS_EPTCTLDIS0_RXRDY_TXKL_Msk = 0x200
	// Bit RXRDY_TXKL.
	UDPHS_EPTCTLDIS0_RXRDY_TXKL = 0x200
	// Position of TX_COMPLT field.
	UDPHS_EPTCTLDIS0_TX_COMPLT_Pos = 0xa
	// Bit mask of TX_COMPLT field.
	UDPHS_EPTCTLDIS0_TX_COMPLT_Msk = 0x400
	// Bit TX_COMPLT.
	UDPHS_EPTCTLDIS0_TX_COMPLT = 0x400
	// Position of TXRDY field.
	UDPHS_EPTCTLDIS0_TXRDY_Pos = 0xb
	// Bit mask of TXRDY field.
	UDPHS_EPTCTLDIS0_TXRDY_Msk = 0x800
	// Bit TXRDY.
	UDPHS_EPTCTLDIS0_TXRDY = 0x800
	// Position of RX_SETUP field.
	UDPHS_EPTCTLDIS0_RX_SETUP_Pos = 0xc
	// Bit mask of RX_SETUP field.
	UDPHS_EPTCTLDIS0_RX_SETUP_Msk = 0x1000
	// Bit RX_SETUP.
	UDPHS_EPTCTLDIS0_RX_SETUP = 0x1000
	// Position of STALL_SNT field.
	UDPHS_EPTCTLDIS0_STALL_SNT_Pos = 0xd
	// Bit mask of STALL_SNT field.
	UDPHS_EPTCTLDIS0_STALL_SNT_Msk = 0x2000
	// Bit STALL_SNT.
	UDPHS_EPTCTLDIS0_STALL_SNT = 0x2000
	// Position of NAK_IN field.
	UDPHS_EPTCTLDIS0_NAK_IN_Pos = 0xe
	// Bit mask of NAK_IN field.
	UDPHS_EPTCTLDIS0_NAK_IN_Msk = 0x4000
	// Bit NAK_IN.
	UDPHS_EPTCTLDIS0_NAK_IN = 0x4000
	// Position of NAK_OUT field.
	UDPHS_EPTCTLDIS0_NAK_OUT_Pos = 0xf
	// Bit mask of NAK_OUT field.
	UDPHS_EPTCTLDIS0_NAK_OUT_Msk = 0x8000
	// Bit NAK_OUT.
	UDPHS_EPTCTLDIS0_NAK_OUT = 0x8000
	// Position of BUSY_BANK field.
	UDPHS_EPTCTLDIS0_BUSY_BANK_Pos = 0x12
	// Bit mask of BUSY_BANK field.
	UDPHS_EPTCTLDIS0_BUSY_BANK_Msk = 0x40000
	// Bit BUSY_BANK.
	UDPHS_EPTCTLDIS0_BUSY_BANK = 0x40000
	// Position of SHRT_PCKT field.
	UDPHS_EPTCTLDIS0_SHRT_PCKT_Pos = 0x1f
	// Bit mask of SHRT_PCKT field.
	UDPHS_EPTCTLDIS0_SHRT_PCKT_Msk = 0x80000000
	// Bit SHRT_PCKT.
	UDPHS_EPTCTLDIS0_SHRT_PCKT = 0x80000000

	// EPTCTLDIS0_ISOENDPT: UDPHS Endpoint Control Disable Register (endpoint = 0)
	// Position of EPT_DISABL field.
	UDPHS_EPTCTLDIS0_ISOENDPT_EPT_DISABL_Pos = 0x0
	// Bit mask of EPT_DISABL field.
	UDPHS_EPTCTLDIS0_ISOENDPT_EPT_DISABL_Msk = 0x1
	// Bit EPT_DISABL.
	UDPHS_EPTCTLDIS0_ISOENDPT_EPT_DISABL = 0x1
	// Position of AUTO_VALID field.
	UDPHS_EPTCTLDIS0_ISOENDPT_AUTO_VALID_Pos = 0x1
	// Bit mask of AUTO_VALID field.
	UDPHS_EPTCTLDIS0_ISOENDPT_AUTO_VALID_Msk = 0x2
	// Bit AUTO_VALID.
	UDPHS_EPTCTLDIS0_ISOENDPT_AUTO_VALID = 0x2
	// Position of INTDIS_DMA field.
	UDPHS_EPTCTLDIS0_ISOENDPT_INTDIS_DMA_Pos = 0x3
	// Bit mask of INTDIS_DMA field.
	UDPHS_EPTCTLDIS0_ISOENDPT_INTDIS_DMA_Msk = 0x8
	// Bit INTDIS_DMA.
	UDPHS_EPTCTLDIS0_ISOENDPT_INTDIS_DMA = 0x8
	// Position of DATAX_RX field.
	UDPHS_EPTCTLDIS0_ISOENDPT_DATAX_RX_Pos = 0x6
	// Bit mask of DATAX_RX field.
	UDPHS_EPTCTLDIS0_ISOENDPT_DATAX_RX_Msk = 0x40
	// Bit DATAX_RX.
	UDPHS_EPTCTLDIS0_ISOENDPT_DATAX_RX = 0x40
	// Position of MDATA_RX field.
	UDPHS_EPTCTLDIS0_ISOENDPT_MDATA_RX_Pos = 0x7
	// Bit mask of MDATA_RX field.
	UDPHS_EPTCTLDIS0_ISOENDPT_MDATA_RX_Msk = 0x80
	// Bit MDATA_RX.
	UDPHS_EPTCTLDIS0_ISOENDPT_MDATA_RX = 0x80
	// Position of ERR_OVFLW field.
	UDPHS_EPTCTLDIS0_ISOENDPT_ERR_OVFLW_Pos = 0x8
	// Bit mask of ERR_OVFLW field.
	UDPHS_EPTCTLDIS0_ISOENDPT_ERR_OVFLW_Msk = 0x100
	// Bit ERR_OVFLW.
	UDPHS_EPTCTLDIS0_ISOENDPT_ERR_OVFLW = 0x100
	// Position of RXRDY_TXKL field.
	UDPHS_EPTCTLDIS0_ISOENDPT_RXRDY_TXKL_Pos = 0x9
	// Bit mask of RXRDY_TXKL field.
	UDPHS_EPTCTLDIS0_ISOENDPT_RXRDY_TXKL_Msk = 0x200
	// Bit RXRDY_TXKL.
	UDPHS_EPTCTLDIS0_ISOENDPT_RXRDY_TXKL = 0x200
	// Position of TX_COMPLT field.
	UDPHS_EPTCTLDIS0_ISOENDPT_TX_COMPLT_Pos = 0xa
	// Bit mask of TX_COMPLT field.
	UDPHS_EPTCTLDIS0_ISOENDPT_TX_COMPLT_Msk = 0x400
	// Bit TX_COMPLT.
	UDPHS_EPTCTLDIS0_ISOENDPT_TX_COMPLT = 0x400
	// Position of TXRDY_TRER field.
	UDPHS_EPTCTLDIS0_ISOENDPT_TXRDY_TRER_Pos = 0xb
	// Bit mask of TXRDY_TRER field.
	UDPHS_EPTCTLDIS0_ISOENDPT_TXRDY_TRER_Msk = 0x800
	// Bit TXRDY_TRER.
	UDPHS_EPTCTLDIS0_ISOENDPT_TXRDY_TRER = 0x800
	// Position of ERR_FL_ISO field.
	UDPHS_EPTCTLDIS0_ISOENDPT_ERR_FL_ISO_Pos = 0xc
	// Bit mask of ERR_FL_ISO field.
	UDPHS_EPTCTLDIS0_ISOENDPT_ERR_FL_ISO_Msk = 0x1000
	// Bit ERR_FL_ISO.
	UDPHS_EPTCTLDIS0_ISOENDPT_ERR_FL_ISO = 0x1000
	// Position of ERR_CRC_NTR field.
	UDPHS_EPTCTLDIS0_ISOENDPT_ERR_CRC_NTR_Pos = 0xd
	// Bit mask of ERR_CRC_NTR field.
	UDPHS_EPTCTLDIS0_ISOENDPT_ERR_CRC_NTR_Msk = 0x2000
	// Bit ERR_CRC_NTR.
	UDPHS_EPTCTLDIS0_ISOENDPT_ERR_CRC_NTR = 0x2000
	// Position of ERR_FLUSH field.
	UDPHS_EPTCTLDIS0_ISOENDPT_ERR_FLUSH_Pos = 0xe
	// Bit mask of ERR_FLUSH field.
	UDPHS_EPTCTLDIS0_ISOENDPT_ERR_FLUSH_Msk = 0x4000
	// Bit ERR_FLUSH.
	UDPHS_EPTCTLDIS0_ISOENDPT_ERR_FLUSH = 0x4000
	// Position of BUSY_BANK field.
	UDPHS_EPTCTLDIS0_ISOENDPT_BUSY_BANK_Pos = 0x12
	// Bit mask of BUSY_BANK field.
	UDPHS_EPTCTLDIS0_ISOENDPT_BUSY_BANK_Msk = 0x40000
	// Bit BUSY_BANK.
	UDPHS_EPTCTLDIS0_ISOENDPT_BUSY_BANK = 0x40000
	// Position of SHRT_PCKT field.
	UDPHS_EPTCTLDIS0_ISOENDPT_SHRT_PCKT_Pos = 0x1f
	// Bit mask of SHRT_PCKT field.
	UDPHS_EPTCTLDIS0_ISOENDPT_SHRT_PCKT_Msk = 0x80000000
	// Bit SHRT_PCKT.
	UDPHS_EPTCTLDIS0_ISOENDPT_SHRT_PCKT = 0x80000000

	// EPTCTL0: UDPHS Endpoint Control Register (endpoint = 0)
	// Position of EPT_ENABL field.
	UDPHS_EPTCTL0_EPT_ENABL_Pos = 0x0
	// Bit mask of EPT_ENABL field.
	UDPHS_EPTCTL0_EPT_ENABL_Msk = 0x1
	// Bit EPT_ENABL.
	UDPHS_EPTCTL0_EPT_ENABL = 0x1
	// Position of AUTO_VALID field.
	UDPHS_EPTCTL0_AUTO_VALID_Pos = 0x1
	// Bit mask of AUTO_VALID field.
	UDPHS_EPTCTL0_AUTO_VALID_Msk = 0x2
	// Bit AUTO_VALID.
	UDPHS_EPTCTL0_AUTO_VALID = 0x2
	// Position of INTDIS_DMA field.
	UDPHS_EPTCTL0_INTDIS_DMA_Pos = 0x3
	// Bit mask of INTDIS_DMA field.
	UDPHS_EPTCTL0_INTDIS_DMA_Msk = 0x8
	// Bit INTDIS_DMA.
	UDPHS_EPTCTL0_INTDIS_DMA = 0x8
	// Position of NYET_DIS field.
	UDPHS_EPTCTL0_NYET_DIS_Pos = 0x4
	// Bit mask of NYET_DIS field.
	UDPHS_EPTCTL0_NYET_DIS_Msk = 0x10
	// Bit NYET_DIS.
	UDPHS_EPTCTL0_NYET_DIS = 0x10
	// Position of ERR_OVFLW field.
	UDPHS_EPTCTL0_ERR_OVFLW_Pos = 0x8
	// Bit mask of ERR_OVFLW field.
	UDPHS_EPTCTL0_ERR_OVFLW_Msk = 0x100
	// Bit ERR_OVFLW.
	UDPHS_EPTCTL0_ERR_OVFLW = 0x100
	// Position of RXRDY_TXKL field.
	UDPHS_EPTCTL0_RXRDY_TXKL_Pos = 0x9
	// Bit mask of RXRDY_TXKL field.
	UDPHS_EPTCTL0_RXRDY_TXKL_Msk = 0x200
	// Bit RXRDY_TXKL.
	UDPHS_EPTCTL0_RXRDY_TXKL = 0x200
	// Position of TX_COMPLT field.
	UDPHS_EPTCTL0_TX_COMPLT_Pos = 0xa
	// Bit mask of TX_COMPLT field.
	UDPHS_EPTCTL0_TX_COMPLT_Msk = 0x400
	// Bit TX_COMPLT.
	UDPHS_EPTCTL0_TX_COMPLT = 0x400
	// Position of TXRDY field.
	UDPHS_EPTCTL0_TXRDY_Pos = 0xb
	// Bit mask of TXRDY field.
	UDPHS_EPTCTL0_TXRDY_Msk = 0x800
	// Bit TXRDY.
	UDPHS_EPTCTL0_TXRDY = 0x800
	// Position of RX_SETUP field.
	UDPHS_EPTCTL0_RX_SETUP_Pos = 0xc
	// Bit mask of RX_SETUP field.
	UDPHS_EPTCTL0_RX_SETUP_Msk = 0x1000
	// Bit RX_SETUP.
	UDPHS_EPTCTL0_RX_SETUP = 0x1000
	// Position of STALL_SNT field.
	UDPHS_EPTCTL0_STALL_SNT_Pos = 0xd
	// Bit mask of STALL_SNT field.
	UDPHS_EPTCTL0_STALL_SNT_Msk = 0x2000
	// Bit STALL_SNT.
	UDPHS_EPTCTL0_STALL_SNT = 0x2000
	// Position of NAK_IN field.
	UDPHS_EPTCTL0_NAK_IN_Pos = 0xe
	// Bit mask of NAK_IN field.
	UDPHS_EPTCTL0_NAK_IN_Msk = 0x4000
	// Bit NAK_IN.
	UDPHS_EPTCTL0_NAK_IN = 0x4000
	// Position of NAK_OUT field.
	UDPHS_EPTCTL0_NAK_OUT_Pos = 0xf
	// Bit mask of NAK_OUT field.
	UDPHS_EPTCTL0_NAK_OUT_Msk = 0x8000
	// Bit NAK_OUT.
	UDPHS_EPTCTL0_NAK_OUT = 0x8000
	// Position of BUSY_BANK field.
	UDPHS_EPTCTL0_BUSY_BANK_Pos = 0x12
	// Bit mask of BUSY_BANK field.
	UDPHS_EPTCTL0_BUSY_BANK_Msk = 0x40000
	// Bit BUSY_BANK.
	UDPHS_EPTCTL0_BUSY_BANK = 0x40000
	// Position of SHRT_PCKT field.
	UDPHS_EPTCTL0_SHRT_PCKT_Pos = 0x1f
	// Bit mask of SHRT_PCKT field.
	UDPHS_EPTCTL0_SHRT_PCKT_Msk = 0x80000000
	// Bit SHRT_PCKT.
	UDPHS_EPTCTL0_SHRT_PCKT = 0x80000000

	// EPTCTL0_ISOENDPT: UDPHS Endpoint Control Register (endpoint = 0)
	// Position of EPT_ENABL field.
	UDPHS_EPTCTL0_ISOENDPT_EPT_ENABL_Pos = 0x0
	// Bit mask of EPT_ENABL field.
	UDPHS_EPTCTL0_ISOENDPT_EPT_ENABL_Msk = 0x1
	// Bit EPT_ENABL.
	UDPHS_EPTCTL0_ISOENDPT_EPT_ENABL = 0x1
	// Position of AUTO_VALID field.
	UDPHS_EPTCTL0_ISOENDPT_AUTO_VALID_Pos = 0x1
	// Bit mask of AUTO_VALID field.
	UDPHS_EPTCTL0_ISOENDPT_AUTO_VALID_Msk = 0x2
	// Bit AUTO_VALID.
	UDPHS_EPTCTL0_ISOENDPT_AUTO_VALID = 0x2
	// Position of INTDIS_DMA field.
	UDPHS_EPTCTL0_ISOENDPT_INTDIS_DMA_Pos = 0x3
	// Bit mask of INTDIS_DMA field.
	UDPHS_EPTCTL0_ISOENDPT_INTDIS_DMA_Msk = 0x8
	// Bit INTDIS_DMA.
	UDPHS_EPTCTL0_ISOENDPT_INTDIS_DMA = 0x8
	// Position of DATAX_RX field.
	UDPHS_EPTCTL0_ISOENDPT_DATAX_RX_Pos = 0x6
	// Bit mask of DATAX_RX field.
	UDPHS_EPTCTL0_ISOENDPT_DATAX_RX_Msk = 0x40
	// Bit DATAX_RX.
	UDPHS_EPTCTL0_ISOENDPT_DATAX_RX = 0x40
	// Position of MDATA_RX field.
	UDPHS_EPTCTL0_ISOENDPT_MDATA_RX_Pos = 0x7
	// Bit mask of MDATA_RX field.
	UDPHS_EPTCTL0_ISOENDPT_MDATA_RX_Msk = 0x80
	// Bit MDATA_RX.
	UDPHS_EPTCTL0_ISOENDPT_MDATA_RX = 0x80
	// Position of ERR_OVFLW field.
	UDPHS_EPTCTL0_ISOENDPT_ERR_OVFLW_Pos = 0x8
	// Bit mask of ERR_OVFLW field.
	UDPHS_EPTCTL0_ISOENDPT_ERR_OVFLW_Msk = 0x100
	// Bit ERR_OVFLW.
	UDPHS_EPTCTL0_ISOENDPT_ERR_OVFLW = 0x100
	// Position of RXRDY_TXKL field.
	UDPHS_EPTCTL0_ISOENDPT_RXRDY_TXKL_Pos = 0x9
	// Bit mask of RXRDY_TXKL field.
	UDPHS_EPTCTL0_ISOENDPT_RXRDY_TXKL_Msk = 0x200
	// Bit RXRDY_TXKL.
	UDPHS_EPTCTL0_ISOENDPT_RXRDY_TXKL = 0x200
	// Position of TX_COMPLT field.
	UDPHS_EPTCTL0_ISOENDPT_TX_COMPLT_Pos = 0xa
	// Bit mask of TX_COMPLT field.
	UDPHS_EPTCTL0_ISOENDPT_TX_COMPLT_Msk = 0x400
	// Bit TX_COMPLT.
	UDPHS_EPTCTL0_ISOENDPT_TX_COMPLT = 0x400
	// Position of TXRDY_TRER field.
	UDPHS_EPTCTL0_ISOENDPT_TXRDY_TRER_Pos = 0xb
	// Bit mask of TXRDY_TRER field.
	UDPHS_EPTCTL0_ISOENDPT_TXRDY_TRER_Msk = 0x800
	// Bit TXRDY_TRER.
	UDPHS_EPTCTL0_ISOENDPT_TXRDY_TRER = 0x800
	// Position of ERR_FL_ISO field.
	UDPHS_EPTCTL0_ISOENDPT_ERR_FL_ISO_Pos = 0xc
	// Bit mask of ERR_FL_ISO field.
	UDPHS_EPTCTL0_ISOENDPT_ERR_FL_ISO_Msk = 0x1000
	// Bit ERR_FL_ISO.
	UDPHS_EPTCTL0_ISOENDPT_ERR_FL_ISO = 0x1000
	// Position of ERR_CRC_NTR field.
	UDPHS_EPTCTL0_ISOENDPT_ERR_CRC_NTR_Pos = 0xd
	// Bit mask of ERR_CRC_NTR field.
	UDPHS_EPTCTL0_ISOENDPT_ERR_CRC_NTR_Msk = 0x2000
	// Bit ERR_CRC_NTR.
	UDPHS_EPTCTL0_ISOENDPT_ERR_CRC_NTR = 0x2000
	// Position of ERR_FLUSH field.
	UDPHS_EPTCTL0_ISOENDPT_ERR_FLUSH_Pos = 0xe
	// Bit mask of ERR_FLUSH field.
	UDPHS_EPTCTL0_ISOENDPT_ERR_FLUSH_Msk = 0x4000
	// Bit ERR_FLUSH.
	UDPHS_EPTCTL0_ISOENDPT_ERR_FLUSH = 0x4000
	// Position of BUSY_BANK field.
	UDPHS_EPTCTL0_ISOENDPT_BUSY_BANK_Pos = 0x12
	// Bit mask of BUSY_BANK field.
	UDPHS_EPTCTL0_ISOENDPT_BUSY_BANK_Msk = 0x40000
	// Bit BUSY_BANK.
	UDPHS_EPTCTL0_ISOENDPT_BUSY_BANK = 0x40000
	// Position of SHRT_PCKT field.
	UDPHS_EPTCTL0_ISOENDPT_SHRT_PCKT_Pos = 0x1f
	// Bit mask of SHRT_PCKT field.
	UDPHS_EPTCTL0_ISOENDPT_SHRT_PCKT_Msk = 0x80000000
	// Bit SHRT_PCKT.
	UDPHS_EPTCTL0_ISOENDPT_SHRT_PCKT = 0x80000000

	// EPTSETSTA0: UDPHS Endpoint Set Status Register (endpoint = 0)
	// Position of FRCESTALL field.
	UDPHS_EPTSETSTA0_FRCESTALL_Pos = 0x5
	// Bit mask of FRCESTALL field.
	UDPHS_EPTSETSTA0_FRCESTALL_Msk = 0x20
	// Bit FRCESTALL.
	UDPHS_EPTSETSTA0_FRCESTALL = 0x20
	// Position of RXRDY_TXKL field.
	UDPHS_EPTSETSTA0_RXRDY_TXKL_Pos = 0x9
	// Bit mask of RXRDY_TXKL field.
	UDPHS_EPTSETSTA0_RXRDY_TXKL_Msk = 0x200
	// Bit RXRDY_TXKL.
	UDPHS_EPTSETSTA0_RXRDY_TXKL = 0x200
	// Position of TXRDY field.
	UDPHS_EPTSETSTA0_TXRDY_Pos = 0xb
	// Bit mask of TXRDY field.
	UDPHS_EPTSETSTA0_TXRDY_Msk = 0x800
	// Bit TXRDY.
	UDPHS_EPTSETSTA0_TXRDY = 0x800

	// EPTSETSTA0_ISOENDPT: UDPHS Endpoint Set Status Register (endpoint = 0)
	// Position of RXRDY_TXKL field.
	UDPHS_EPTSETSTA0_ISOENDPT_RXRDY_TXKL_Pos = 0x9
	// Bit mask of RXRDY_TXKL field.
	UDPHS_EPTSETSTA0_ISOENDPT_RXRDY_TXKL_Msk = 0x200
	// Bit RXRDY_TXKL.
	UDPHS_EPTSETSTA0_ISOENDPT_RXRDY_TXKL = 0x200
	// Position of TXRDY_TRER field.
	UDPHS_EPTSETSTA0_ISOENDPT_TXRDY_TRER_Pos = 0xb
	// Bit mask of TXRDY_TRER field.
	UDPHS_EPTSETSTA0_ISOENDPT_TXRDY_TRER_Msk = 0x800
	// Bit TXRDY_TRER.
	UDPHS_EPTSETSTA0_ISOENDPT_TXRDY_TRER = 0x800

	// EPTCLRSTA0: UDPHS Endpoint Clear Status Register (endpoint = 0)
	// Position of FRCESTALL field.
	UDPHS_EPTCLRSTA0_FRCESTALL_Pos = 0x5
	// Bit mask of FRCESTALL field.
	UDPHS_EPTCLRSTA0_FRCESTALL_Msk = 0x20
	// Bit FRCESTALL.
	UDPHS_EPTCLRSTA0_FRCESTALL = 0x20
	// Position of TOGGLESQ field.
	UDPHS_EPTCLRSTA0_TOGGLESQ_Pos = 0x6
	// Bit mask of TOGGLESQ field.
	UDPHS_EPTCLRSTA0_TOGGLESQ_Msk = 0x40
	// Bit TOGGLESQ.
	UDPHS_EPTCLRSTA0_TOGGLESQ = 0x40
	// Position of RXRDY_TXKL field.
	UDPHS_EPTCLRSTA0_RXRDY_TXKL_Pos = 0x9
	// Bit mask of RXRDY_TXKL field.
	UDPHS_EPTCLRSTA0_RXRDY_TXKL_Msk = 0x200
	// Bit RXRDY_TXKL.
	UDPHS_EPTCLRSTA0_RXRDY_TXKL = 0x200
	// Position of TX_COMPLT field.
	UDPHS_EPTCLRSTA0_TX_COMPLT_Pos = 0xa
	// Bit mask of TX_COMPLT field.
	UDPHS_EPTCLRSTA0_TX_COMPLT_Msk = 0x400
	// Bit TX_COMPLT.
	UDPHS_EPTCLRSTA0_TX_COMPLT = 0x400
	// Position of RX_SETUP field.
	UDPHS_EPTCLRSTA0_RX_SETUP_Pos = 0xc
	// Bit mask of RX_SETUP field.
	UDPHS_EPTCLRSTA0_RX_SETUP_Msk = 0x1000
	// Bit RX_SETUP.
	UDPHS_EPTCLRSTA0_RX_SETUP = 0x1000
	// Position of STALL_SNT field.
	UDPHS_EPTCLRSTA0_STALL_SNT_Pos = 0xd
	// Bit mask of STALL_SNT field.
	UDPHS_EPTCLRSTA0_STALL_SNT_Msk = 0x2000
	// Bit STALL_SNT.
	UDPHS_EPTCLRSTA0_STALL_SNT = 0x2000
	// Position of NAK_IN field.
	UDPHS_EPTCLRSTA0_NAK_IN_Pos = 0xe
	// Bit mask of NAK_IN field.
	UDPHS_EPTCLRSTA0_NAK_IN_Msk = 0x4000
	// Bit NAK_IN.
	UDPHS_EPTCLRSTA0_NAK_IN = 0x4000
	// Position of NAK_OUT field.
	UDPHS_EPTCLRSTA0_NAK_OUT_Pos = 0xf
	// Bit mask of NAK_OUT field.
	UDPHS_EPTCLRSTA0_NAK_OUT_Msk = 0x8000
	// Bit NAK_OUT.
	UDPHS_EPTCLRSTA0_NAK_OUT = 0x8000

	// EPTCLRSTA0_ISOENDPT: UDPHS Endpoint Clear Status Register (endpoint = 0)
	// Position of TOGGLESQ field.
	UDPHS_EPTCLRSTA0_ISOENDPT_TOGGLESQ_Pos = 0x6
	// Bit mask of TOGGLESQ field.
	UDPHS_EPTCLRSTA0_ISOENDPT_TOGGLESQ_Msk = 0x40
	// Bit TOGGLESQ.
	UDPHS_EPTCLRSTA0_ISOENDPT_TOGGLESQ = 0x40
	// Position of RXRDY_TXKL field.
	UDPHS_EPTCLRSTA0_ISOENDPT_RXRDY_TXKL_Pos = 0x9
	// Bit mask of RXRDY_TXKL field.
	UDPHS_EPTCLRSTA0_ISOENDPT_RXRDY_TXKL_Msk = 0x200
	// Bit RXRDY_TXKL.
	UDPHS_EPTCLRSTA0_ISOENDPT_RXRDY_TXKL = 0x200
	// Position of TX_COMPLT field.
	UDPHS_EPTCLRSTA0_ISOENDPT_TX_COMPLT_Pos = 0xa
	// Bit mask of TX_COMPLT field.
	UDPHS_EPTCLRSTA0_ISOENDPT_TX_COMPLT_Msk = 0x400
	// Bit TX_COMPLT.
	UDPHS_EPTCLRSTA0_ISOENDPT_TX_COMPLT = 0x400
	// Position of ERR_FL_ISO field.
	UDPHS_EPTCLRSTA0_ISOENDPT_ERR_FL_ISO_Pos = 0xc
	// Bit mask of ERR_FL_ISO field.
	UDPHS_EPTCLRSTA0_ISOENDPT_ERR_FL_ISO_Msk = 0x1000
	// Bit ERR_FL_ISO.
	UDPHS_EPTCLRSTA0_ISOENDPT_ERR_FL_ISO = 0x1000
	// Position of ERR_CRC_NTR field.
	UDPHS_EPTCLRSTA0_ISOENDPT_ERR_CRC_NTR_Pos = 0xd
	// Bit mask of ERR_CRC_NTR field.
	UDPHS_EPTCLRSTA0_ISOENDPT_ERR_CRC_NTR_Msk = 0x2000
	// Bit ERR_CRC_NTR.
	UDPHS_EPTCLRSTA0_ISOENDPT_ERR_CRC_NTR = 0x2000
	// Position of ERR_FLUSH field.
	UDPHS_EPTCLRSTA0_ISOENDPT_ERR_FLUSH_Pos = 0xe
	// Bit mask of ERR_FLUSH field.
	UDPHS_EPTCLRSTA0_ISOENDPT_ERR_FLUSH_Msk = 0x4000
	// Bit ERR_FLUSH.
	UDPHS_EPTCLRSTA0_ISOENDPT_ERR_FLUSH = 0x4000

	// EPTSTA0: UDPHS Endpoint Status Register (endpoint = 0)
	// Position of FRCESTALL field.
	UDPHS_EPTSTA0_FRCESTALL_Pos = 0x5
	// Bit mask of FRCESTALL field.
	UDPHS_EPTSTA0_FRCESTALL_Msk = 0x20
	// Bit FRCESTALL.
	UDPHS_EPTSTA0_FRCESTALL = 0x20
	// Position of TOGGLESQ_STA field.
	UDPHS_EPTSTA0_TOGGLESQ_STA_Pos = 0x6
	// Bit mask of TOGGLESQ_STA field.
	UDPHS_EPTSTA0_TOGGLESQ_STA_Msk = 0xc0
	// DATA0
	UDPHS_EPTSTA0_TOGGLESQ_STA_DATA0 = 0x0
	// DATA1
	UDPHS_EPTSTA0_TOGGLESQ_STA_DATA1 = 0x1
	// Reserved for High Bandwidth Isochronous Endpoint
	UDPHS_EPTSTA0_TOGGLESQ_STA_DATA2 = 0x2
	// Reserved for High Bandwidth Isochronous Endpoint
	UDPHS_EPTSTA0_TOGGLESQ_STA_MDATA = 0x3
	// Position of ERR_OVFLW field.
	UDPHS_EPTSTA0_ERR_OVFLW_Pos = 0x8
	// Bit mask of ERR_OVFLW field.
	UDPHS_EPTSTA0_ERR_OVFLW_Msk = 0x100
	// Bit ERR_OVFLW.
	UDPHS_EPTSTA0_ERR_OVFLW = 0x100
	// Position of RXRDY_TXKL field.
	UDPHS_EPTSTA0_RXRDY_TXKL_Pos = 0x9
	// Bit mask of RXRDY_TXKL field.
	UDPHS_EPTSTA0_RXRDY_TXKL_Msk = 0x200
	// Bit RXRDY_TXKL.
	UDPHS_EPTSTA0_RXRDY_TXKL = 0x200
	// Position of TX_COMPLT field.
	UDPHS_EPTSTA0_TX_COMPLT_Pos = 0xa
	// Bit mask of TX_COMPLT field.
	UDPHS_EPTSTA0_TX_COMPLT_Msk = 0x400
	// Bit TX_COMPLT.
	UDPHS_EPTSTA0_TX_COMPLT = 0x400
	// Position of TXRDY field.
	UDPHS_EPTSTA0_TXRDY_Pos = 0xb
	// Bit mask of TXRDY field.
	UDPHS_EPTSTA0_TXRDY_Msk = 0x800
	// Bit TXRDY.
	UDPHS_EPTSTA0_TXRDY = 0x800
	// Position of RX_SETUP field.
	UDPHS_EPTSTA0_RX_SETUP_Pos = 0xc
	// Bit mask of RX_SETUP field.
	UDPHS_EPTSTA0_RX_SETUP_Msk = 0x1000
	// Bit RX_SETUP.
	UDPHS_EPTSTA0_RX_SETUP = 0x1000
	// Position of STALL_SNT field.
	UDPHS_EPTSTA0_STALL_SNT_Pos = 0xd
	// Bit mask of STALL_SNT field.
	UDPHS_EPTSTA0_STALL_SNT_Msk = 0x2000
	// Bit STALL_SNT.
	UDPHS_EPTSTA0_STALL_SNT = 0x2000
	// Position of NAK_IN field.
	UDPHS_EPTSTA0_NAK_IN_Pos = 0xe
	// Bit mask of NAK_IN field.
	UDPHS_EPTSTA0_NAK_IN_Msk = 0x4000
	// Bit NAK_IN.
	UDPHS_EPTSTA0_NAK_IN = 0x4000
	// Position of NAK_OUT field.
	UDPHS_EPTSTA0_NAK_OUT_Pos = 0xf
	// Bit mask of NAK_OUT field.
	UDPHS_EPTSTA0_NAK_OUT_Msk = 0x8000
	// Bit NAK_OUT.
	UDPHS_EPTSTA0_NAK_OUT = 0x8000
	// Position of CURBK_CTLDIR field.
	UDPHS_EPTSTA0_CURBK_CTLDIR_Pos = 0x10
	// Bit mask of CURBK_CTLDIR field.
	UDPHS_EPTSTA0_CURBK_CTLDIR_Msk = 0x30000
	// Position of BUSY_BANK_STA field.
	UDPHS_EPTSTA0_BUSY_BANK_STA_Pos = 0x12
	// Bit mask of BUSY_BANK_STA field.
	UDPHS_EPTSTA0_BUSY_BANK_STA_Msk = 0xc0000
	// 1 busy bank
	UDPHS_EPTSTA0_BUSY_BANK_STA_1BUSYBANK = 0x0
	// 2 busy banks
	UDPHS_EPTSTA0_BUSY_BANK_STA_2BUSYBANKS = 0x1
	// 3 busy banks
	UDPHS_EPTSTA0_BUSY_BANK_STA_3BUSYBANKS = 0x2
	// Position of BYTE_COUNT field.
	UDPHS_EPTSTA0_BYTE_COUNT_Pos = 0x14
	// Bit mask of BYTE_COUNT field.
	UDPHS_EPTSTA0_BYTE_COUNT_Msk = 0x7ff00000
	// Position of SHRT_PCKT field.
	UDPHS_EPTSTA0_SHRT_PCKT_Pos = 0x1f
	// Bit mask of SHRT_PCKT field.
	UDPHS_EPTSTA0_SHRT_PCKT_Msk = 0x80000000
	// Bit SHRT_PCKT.
	UDPHS_EPTSTA0_SHRT_PCKT = 0x80000000

	// EPTSTA0_ISOENDPT: UDPHS Endpoint Status Register (endpoint = 0)
	// Position of TOGGLESQ_STA field.
	UDPHS_EPTSTA0_ISOENDPT_TOGGLESQ_STA_Pos = 0x6
	// Bit mask of TOGGLESQ_STA field.
	UDPHS_EPTSTA0_ISOENDPT_TOGGLESQ_STA_Msk = 0xc0
	// DATA0
	UDPHS_EPTSTA0_ISOENDPT_TOGGLESQ_STA_DATA0 = 0x0
	// DATA1
	UDPHS_EPTSTA0_ISOENDPT_TOGGLESQ_STA_DATA1 = 0x1
	// Data2 (only for High Bandwidth Isochronous Endpoint)
	UDPHS_EPTSTA0_ISOENDPT_TOGGLESQ_STA_DATA2 = 0x2
	// MData (only for High Bandwidth Isochronous Endpoint)
	UDPHS_EPTSTA0_ISOENDPT_TOGGLESQ_STA_MDATA = 0x3
	// Position of ERR_OVFLW field.
	UDPHS_EPTSTA0_ISOENDPT_ERR_OVFLW_Pos = 0x8
	// Bit mask of ERR_OVFLW field.
	UDPHS_EPTSTA0_ISOENDPT_ERR_OVFLW_Msk = 0x100
	// Bit ERR_OVFLW.
	UDPHS_EPTSTA0_ISOENDPT_ERR_OVFLW = 0x100
	// Position of RXRDY_TXKL field.
	UDPHS_EPTSTA0_ISOENDPT_RXRDY_TXKL_Pos = 0x9
	// Bit mask of RXRDY_TXKL field.
	UDPHS_EPTSTA0_ISOENDPT_RXRDY_TXKL_Msk = 0x200
	// Bit RXRDY_TXKL.
	UDPHS_EPTSTA0_ISOENDPT_RXRDY_TXKL = 0x200
	// Position of TX_COMPLT field.
	UDPHS_EPTSTA0_ISOENDPT_TX_COMPLT_Pos = 0xa
	// Bit mask of TX_COMPLT field.
	UDPHS_EPTSTA0_ISOENDPT_TX_COMPLT_Msk = 0x400
	// Bit TX_COMPLT.
	UDPHS_EPTSTA0_ISOENDPT_TX_COMPLT = 0x400
	// Position of TXRDY_TRER field.
	UDPHS_EPTSTA0_ISOENDPT_TXRDY_TRER_Pos = 0xb
	// Bit mask of TXRDY_TRER field.
	UDPHS_EPTSTA0_ISOENDPT_TXRDY_TRER_Msk = 0x800
	// Bit TXRDY_TRER.
	UDPHS_EPTSTA0_ISOENDPT_TXRDY_TRER = 0x800
	// Position of ERR_FL_ISO field.
	UDPHS_EPTSTA0_ISOENDPT_ERR_FL_ISO_Pos = 0xc
	// Bit mask of ERR_FL_ISO field.
	UDPHS_EPTSTA0_ISOENDPT_ERR_FL_ISO_Msk = 0x1000
	// Bit ERR_FL_ISO.
	UDPHS_EPTSTA0_ISOENDPT_ERR_FL_ISO = 0x1000
	// Position of ERR_CRC_NTR field.
	UDPHS_EPTSTA0_ISOENDPT_ERR_CRC_NTR_Pos = 0xd
	// Bit mask of ERR_CRC_NTR field.
	UDPHS_EPTSTA0_ISOENDPT_ERR_CRC_NTR_Msk = 0x2000
	// Bit ERR_CRC_NTR.
	UDPHS_EPTSTA0_ISOENDPT_ERR_CRC_NTR = 0x2000
	// Position of ERR_FLUSH field.
	UDPHS_EPTSTA0_ISOENDPT_ERR_FLUSH_Pos = 0xe
	// Bit mask of ERR_FLUSH field.
	UDPHS_EPTSTA0_ISOENDPT_ERR_FLUSH_Msk = 0x4000
	// Bit ERR_FLUSH.
	UDPHS_EPTSTA0_ISOENDPT_ERR_FLUSH = 0x4000
	// Position of CURBK field.
	UDPHS_EPTSTA0_ISOENDPT_CURBK_Pos = 0x10
	// Bit mask of CURBK field.
	UDPHS_EPTSTA0_ISOENDPT_CURBK_Msk = 0x30000
	// Bank 0 (or single bank)
	UDPHS_EPTSTA0_ISOENDPT_CURBK_BANK0 = 0x0
	// Bank 1
	UDPHS_EPTSTA0_ISOENDPT_CURBK_BANK1 = 0x1
	// Bank 2
	UDPHS_EPTSTA0_ISOENDPT_CURBK_BANK2 = 0x2
	// Position of BUSY_BANK_STA field.
	UDPHS_EPTSTA0_ISOENDPT_BUSY_BANK_STA_Pos = 0x12
	// Bit mask of BUSY_BANK_STA field.
	UDPHS_EPTSTA0_ISOENDPT_BUSY_BANK_STA_Msk = 0xc0000
	// 1 busy bank
	UDPHS_EPTSTA0_ISOENDPT_BUSY_BANK_STA_1BUSYBANK = 0x0
	// 2 busy banks
	UDPHS_EPTSTA0_ISOENDPT_BUSY_BANK_STA_2BUSYBANKS = 0x1
	// 3 busy banks
	UDPHS_EPTSTA0_ISOENDPT_BUSY_BANK_STA_3BUSYBANKS = 0x2
	// Position of BYTE_COUNT field.
	UDPHS_EPTSTA0_ISOENDPT_BYTE_COUNT_Pos = 0x14
	// Bit mask of BYTE_COUNT field.
	UDPHS_EPTSTA0_ISOENDPT_BYTE_COUNT_Msk = 0x7ff00000
	// Position of SHRT_PCKT field.
	UDPHS_EPTSTA0_ISOENDPT_SHRT_PCKT_Pos = 0x1f
	// Bit mask of SHRT_PCKT field.
	UDPHS_EPTSTA0_ISOENDPT_SHRT_PCKT_Msk = 0x80000000
	// Bit SHRT_PCKT.
	UDPHS_EPTSTA0_ISOENDPT_SHRT_PCKT = 0x80000000

	// EPTCFG1: UDPHS Endpoint Configuration Register (endpoint = 1)
	// Position of EPT_SIZE field.
	UDPHS_EPTCFG1_EPT_SIZE_Pos = 0x0
	// Bit mask of EPT_SIZE field.
	UDPHS_EPTCFG1_EPT_SIZE_Msk = 0x7
	// 8 bytes
	UDPHS_EPTCFG1_EPT_SIZE_8 = 0x0
	// 16 bytes
	UDPHS_EPTCFG1_EPT_SIZE_16 = 0x1
	// 32 bytes
	UDPHS_EPTCFG1_EPT_SIZE_32 = 0x2
	// 64 bytes
	UDPHS_EPTCFG1_EPT_SIZE_64 = 0x3
	// 128 bytes
	UDPHS_EPTCFG1_EPT_SIZE_128 = 0x4
	// 256 bytes
	UDPHS_EPTCFG1_EPT_SIZE_256 = 0x5
	// 512 bytes
	UDPHS_EPTCFG1_EPT_SIZE_512 = 0x6
	// 1024 bytes
	UDPHS_EPTCFG1_EPT_SIZE_1024 = 0x7
	// Position of EPT_DIR field.
	UDPHS_EPTCFG1_EPT_DIR_Pos = 0x3
	// Bit mask of EPT_DIR field.
	UDPHS_EPTCFG1_EPT_DIR_Msk = 0x8
	// Bit EPT_DIR.
	UDPHS_EPTCFG1_EPT_DIR = 0x8
	// Position of EPT_TYPE field.
	UDPHS_EPTCFG1_EPT_TYPE_Pos = 0x4
	// Bit mask of EPT_TYPE field.
	UDPHS_EPTCFG1_EPT_TYPE_Msk = 0x30
	// Control endpoint
	UDPHS_EPTCFG1_EPT_TYPE_CTRL8 = 0x0
	// Isochronous endpoint
	UDPHS_EPTCFG1_EPT_TYPE_ISO = 0x1
	// Bulk endpoint
	UDPHS_EPTCFG1_EPT_TYPE_BULK = 0x2
	// Interrupt endpoint
	UDPHS_EPTCFG1_EPT_TYPE_INT = 0x3
	// Position of BK_NUMBER field.
	UDPHS_EPTCFG1_BK_NUMBER_Pos = 0x6
	// Bit mask of BK_NUMBER field.
	UDPHS_EPTCFG1_BK_NUMBER_Msk = 0xc0
	// Zero bank, the endpoint is not mapped in memory
	UDPHS_EPTCFG1_BK_NUMBER_0 = 0x0
	// One bank (bank 0)
	UDPHS_EPTCFG1_BK_NUMBER_1 = 0x1
	// Double bank (Ping-Pong: bank0/bank1)
	UDPHS_EPTCFG1_BK_NUMBER_2 = 0x2
	// Triple bank (bank0/bank1/bank2)
	UDPHS_EPTCFG1_BK_NUMBER_3 = 0x3
	// Position of NB_TRANS field.
	UDPHS_EPTCFG1_NB_TRANS_Pos = 0x8
	// Bit mask of NB_TRANS field.
	UDPHS_EPTCFG1_NB_TRANS_Msk = 0x300
	// Position of EPT_MAPD field.
	UDPHS_EPTCFG1_EPT_MAPD_Pos = 0x1f
	// Bit mask of EPT_MAPD field.
	UDPHS_EPTCFG1_EPT_MAPD_Msk = 0x80000000
	// Bit EPT_MAPD.
	UDPHS_EPTCFG1_EPT_MAPD = 0x80000000

	// EPTCTLENB1: UDPHS Endpoint Control Enable Register (endpoint = 1)
	// Position of EPT_ENABL field.
	UDPHS_EPTCTLENB1_EPT_ENABL_Pos = 0x0
	// Bit mask of EPT_ENABL field.
	UDPHS_EPTCTLENB1_EPT_ENABL_Msk = 0x1
	// Bit EPT_ENABL.
	UDPHS_EPTCTLENB1_EPT_ENABL = 0x1
	// Position of AUTO_VALID field.
	UDPHS_EPTCTLENB1_AUTO_VALID_Pos = 0x1
	// Bit mask of AUTO_VALID field.
	UDPHS_EPTCTLENB1_AUTO_VALID_Msk = 0x2
	// Bit AUTO_VALID.
	UDPHS_EPTCTLENB1_AUTO_VALID = 0x2
	// Position of INTDIS_DMA field.
	UDPHS_EPTCTLENB1_INTDIS_DMA_Pos = 0x3
	// Bit mask of INTDIS_DMA field.
	UDPHS_EPTCTLENB1_INTDIS_DMA_Msk = 0x8
	// Bit INTDIS_DMA.
	UDPHS_EPTCTLENB1_INTDIS_DMA = 0x8
	// Position of NYET_DIS field.
	UDPHS_EPTCTLENB1_NYET_DIS_Pos = 0x4
	// Bit mask of NYET_DIS field.
	UDPHS_EPTCTLENB1_NYET_DIS_Msk = 0x10
	// Bit NYET_DIS.
	UDPHS_EPTCTLENB1_NYET_DIS = 0x10
	// Position of ERR_OVFLW field.
	UDPHS_EPTCTLENB1_ERR_OVFLW_Pos = 0x8
	// Bit mask of ERR_OVFLW field.
	UDPHS_EPTCTLENB1_ERR_OVFLW_Msk = 0x100
	// Bit ERR_OVFLW.
	UDPHS_EPTCTLENB1_ERR_OVFLW = 0x100
	// Position of RXRDY_TXKL field.
	UDPHS_EPTCTLENB1_RXRDY_TXKL_Pos = 0x9
	// Bit mask of RXRDY_TXKL field.
	UDPHS_EPTCTLENB1_RXRDY_TXKL_Msk = 0x200
	// Bit RXRDY_TXKL.
	UDPHS_EPTCTLENB1_RXRDY_TXKL = 0x200
	// Position of TX_COMPLT field.
	UDPHS_EPTCTLENB1_TX_COMPLT_Pos = 0xa
	// Bit mask of TX_COMPLT field.
	UDPHS_EPTCTLENB1_TX_COMPLT_Msk = 0x400
	// Bit TX_COMPLT.
	UDPHS_EPTCTLENB1_TX_COMPLT = 0x400
	// Position of TXRDY field.
	UDPHS_EPTCTLENB1_TXRDY_Pos = 0xb
	// Bit mask of TXRDY field.
	UDPHS_EPTCTLENB1_TXRDY_Msk = 0x800
	// Bit TXRDY.
	UDPHS_EPTCTLENB1_TXRDY = 0x800
	// Position of RX_SETUP field.
	UDPHS_EPTCTLENB1_RX_SETUP_Pos = 0xc
	// Bit mask of RX_SETUP field.
	UDPHS_EPTCTLENB1_RX_SETUP_Msk = 0x1000
	// Bit RX_SETUP.
	UDPHS_EPTCTLENB1_RX_SETUP = 0x1000
	// Position of STALL_SNT field.
	UDPHS_EPTCTLENB1_STALL_SNT_Pos = 0xd
	// Bit mask of STALL_SNT field.
	UDPHS_EPTCTLENB1_STALL_SNT_Msk = 0x2000
	// Bit STALL_SNT.
	UDPHS_EPTCTLENB1_STALL_SNT = 0x2000
	// Position of NAK_IN field.
	UDPHS_EPTCTLENB1_NAK_IN_Pos = 0xe
	// Bit mask of NAK_IN field.
	UDPHS_EPTCTLENB1_NAK_IN_Msk = 0x4000
	// Bit NAK_IN.
	UDPHS_EPTCTLENB1_NAK_IN = 0x4000
	// Position of NAK_OUT field.
	UDPHS_EPTCTLENB1_NAK_OUT_Pos = 0xf
	// Bit mask of NAK_OUT field.
	UDPHS_EPTCTLENB1_NAK_OUT_Msk = 0x8000
	// Bit NAK_OUT.
	UDPHS_EPTCTLENB1_NAK_OUT = 0x8000
	// Position of BUSY_BANK field.
	UDPHS_EPTCTLENB1_BUSY_BANK_Pos = 0x12
	// Bit mask of BUSY_BANK field.
	UDPHS_EPTCTLENB1_BUSY_BANK_Msk = 0x40000
	// Bit BUSY_BANK.
	UDPHS_EPTCTLENB1_BUSY_BANK = 0x40000
	// Position of SHRT_PCKT field.
	UDPHS_EPTCTLENB1_SHRT_PCKT_Pos = 0x1f
	// Bit mask of SHRT_PCKT field.
	UDPHS_EPTCTLENB1_SHRT_PCKT_Msk = 0x80000000
	// Bit SHRT_PCKT.
	UDPHS_EPTCTLENB1_SHRT_PCKT = 0x80000000

	// EPTCTLENB1_ISOENDPT: UDPHS Endpoint Control Enable Register (endpoint = 1)
	// Position of EPT_ENABL field.
	UDPHS_EPTCTLENB1_ISOENDPT_EPT_ENABL_Pos = 0x0
	// Bit mask of EPT_ENABL field.
	UDPHS_EPTCTLENB1_ISOENDPT_EPT_ENABL_Msk = 0x1
	// Bit EPT_ENABL.
	UDPHS_EPTCTLENB1_ISOENDPT_EPT_ENABL = 0x1
	// Position of AUTO_VALID field.
	UDPHS_EPTCTLENB1_ISOENDPT_AUTO_VALID_Pos = 0x1
	// Bit mask of AUTO_VALID field.
	UDPHS_EPTCTLENB1_ISOENDPT_AUTO_VALID_Msk = 0x2
	// Bit AUTO_VALID.
	UDPHS_EPTCTLENB1_ISOENDPT_AUTO_VALID = 0x2
	// Position of INTDIS_DMA field.
	UDPHS_EPTCTLENB1_ISOENDPT_INTDIS_DMA_Pos = 0x3
	// Bit mask of INTDIS_DMA field.
	UDPHS_EPTCTLENB1_ISOENDPT_INTDIS_DMA_Msk = 0x8
	// Bit INTDIS_DMA.
	UDPHS_EPTCTLENB1_ISOENDPT_INTDIS_DMA = 0x8
	// Position of DATAX_RX field.
	UDPHS_EPTCTLENB1_ISOENDPT_DATAX_RX_Pos = 0x6
	// Bit mask of DATAX_RX field.
	UDPHS_EPTCTLENB1_ISOENDPT_DATAX_RX_Msk = 0x40
	// Bit DATAX_RX.
	UDPHS_EPTCTLENB1_ISOENDPT_DATAX_RX = 0x40
	// Position of MDATA_RX field.
	UDPHS_EPTCTLENB1_ISOENDPT_MDATA_RX_Pos = 0x7
	// Bit mask of MDATA_RX field.
	UDPHS_EPTCTLENB1_ISOENDPT_MDATA_RX_Msk = 0x80
	// Bit MDATA_RX.
	UDPHS_EPTCTLENB1_ISOENDPT_MDATA_RX = 0x80
	// Position of ERR_OVFLW field.
	UDPHS_EPTCTLENB1_ISOENDPT_ERR_OVFLW_Pos = 0x8
	// Bit mask of ERR_OVFLW field.
	UDPHS_EPTCTLENB1_ISOENDPT_ERR_OVFLW_Msk = 0x100
	// Bit ERR_OVFLW.
	UDPHS_EPTCTLENB1_ISOENDPT_ERR_OVFLW = 0x100
	// Position of RXRDY_TXKL field.
	UDPHS_EPTCTLENB1_ISOENDPT_RXRDY_TXKL_Pos = 0x9
	// Bit mask of RXRDY_TXKL field.
	UDPHS_EPTCTLENB1_ISOENDPT_RXRDY_TXKL_Msk = 0x200
	// Bit RXRDY_TXKL.
	UDPHS_EPTCTLENB1_ISOENDPT_RXRDY_TXKL = 0x200
	// Position of TX_COMPLT field.
	UDPHS_EPTCTLENB1_ISOENDPT_TX_COMPLT_Pos = 0xa
	// Bit mask of TX_COMPLT field.
	UDPHS_EPTCTLENB1_ISOENDPT_TX_COMPLT_Msk = 0x400
	// Bit TX_COMPLT.
	UDPHS_EPTCTLENB1_ISOENDPT_TX_COMPLT = 0x400
	// Position of TXRDY_TRER field.
	UDPHS_EPTCTLENB1_ISOENDPT_TXRDY_TRER_Pos = 0xb
	// Bit mask of TXRDY_TRER field.
	UDPHS_EPTCTLENB1_ISOENDPT_TXRDY_TRER_Msk = 0x800
	// Bit TXRDY_TRER.
	UDPHS_EPTCTLENB1_ISOENDPT_TXRDY_TRER = 0x800
	// Position of ERR_FL_ISO field.
	UDPHS_EPTCTLENB1_ISOENDPT_ERR_FL_ISO_Pos = 0xc
	// Bit mask of ERR_FL_ISO field.
	UDPHS_EPTCTLENB1_ISOENDPT_ERR_FL_ISO_Msk = 0x1000
	// Bit ERR_FL_ISO.
	UDPHS_EPTCTLENB1_ISOENDPT_ERR_FL_ISO = 0x1000
	// Position of ERR_CRC_NTR field.
	UDPHS_EPTCTLENB1_ISOENDPT_ERR_CRC_NTR_Pos = 0xd
	// Bit mask of ERR_CRC_NTR field.
	UDPHS_EPTCTLENB1_ISOENDPT_ERR_CRC_NTR_Msk = 0x2000
	// Bit ERR_CRC_NTR.
	UDPHS_EPTCTLENB1_ISOENDPT_ERR_CRC_NTR = 0x2000
	// Position of ERR_FLUSH field.
	UDPHS_EPTCTLENB1_ISOENDPT_ERR_FLUSH_Pos = 0xe
	// Bit mask of ERR_FLUSH field.
	UDPHS_EPTCTLENB1_ISOENDPT_ERR_FLUSH_Msk = 0x4000
	// Bit ERR_FLUSH.
	UDPHS_EPTCTLENB1_ISOENDPT_ERR_FLUSH = 0x4000
	// Position of BUSY_BANK field.
	UDPHS_EPTCTLENB1_ISOENDPT_BUSY_BANK_Pos = 0x12
	// Bit mask of BUSY_BANK field.
	UDPHS_EPTCTLENB1_ISOENDPT_BUSY_BANK_Msk = 0x40000
	// Bit BUSY_BANK.
	UDPHS_EPTCTLENB1_ISOENDPT_BUSY_BANK = 0x40000
	// Position of SHRT_PCKT field.
	UDPHS_EPTCTLENB1_ISOENDPT_SHRT_PCKT_Pos = 0x1f
	// Bit mask of SHRT_PCKT field.
	UDPHS_EPTCTLENB1_ISOENDPT_SHRT_PCKT_Msk = 0x80000000
	// Bit SHRT_PCKT.
	UDPHS_EPTCTLENB1_ISOENDPT_SHRT_PCKT = 0x80000000

	// EPTCTLDIS1: UDPHS Endpoint Control Disable Register (endpoint = 1)
	// Position of EPT_DISABL field.
	UDPHS_EPTCTLDIS1_EPT_DISABL_Pos = 0x0
	// Bit mask of EPT_DISABL field.
	UDPHS_EPTCTLDIS1_EPT_DISABL_Msk = 0x1
	// Bit EPT_DISABL.
	UDPHS_EPTCTLDIS1_EPT_DISABL = 0x1
	// Position of AUTO_VALID field.
	UDPHS_EPTCTLDIS1_AUTO_VALID_Pos = 0x1
	// Bit mask of AUTO_VALID field.
	UDPHS_EPTCTLDIS1_AUTO_VALID_Msk = 0x2
	// Bit AUTO_VALID.
	UDPHS_EPTCTLDIS1_AUTO_VALID = 0x2
	// Position of INTDIS_DMA field.
	UDPHS_EPTCTLDIS1_INTDIS_DMA_Pos = 0x3
	// Bit mask of INTDIS_DMA field.
	UDPHS_EPTCTLDIS1_INTDIS_DMA_Msk = 0x8
	// Bit INTDIS_DMA.
	UDPHS_EPTCTLDIS1_INTDIS_DMA = 0x8
	// Position of NYET_DIS field.
	UDPHS_EPTCTLDIS1_NYET_DIS_Pos = 0x4
	// Bit mask of NYET_DIS field.
	UDPHS_EPTCTLDIS1_NYET_DIS_Msk = 0x10
	// Bit NYET_DIS.
	UDPHS_EPTCTLDIS1_NYET_DIS = 0x10
	// Position of ERR_OVFLW field.
	UDPHS_EPTCTLDIS1_ERR_OVFLW_Pos = 0x8
	// Bit mask of ERR_OVFLW field.
	UDPHS_EPTCTLDIS1_ERR_OVFLW_Msk = 0x100
	// Bit ERR_OVFLW.
	UDPHS_EPTCTLDIS1_ERR_OVFLW = 0x100
	// Position of RXRDY_TXKL field.
	UDPHS_EPTCTLDIS1_RXRDY_TXKL_Pos = 0x9
	// Bit mask of RXRDY_TXKL field.
	UDPHS_EPTCTLDIS1_RXRDY_TXKL_Msk = 0x200
	// Bit RXRDY_TXKL.
	UDPHS_EPTCTLDIS1_RXRDY_TXKL = 0x200
	// Position of TX_COMPLT field.
	UDPHS_EPTCTLDIS1_TX_COMPLT_Pos = 0xa
	// Bit mask of TX_COMPLT field.
	UDPHS_EPTCTLDIS1_TX_COMPLT_Msk = 0x400
	// Bit TX_COMPLT.
	UDPHS_EPTCTLDIS1_TX_COMPLT = 0x400
	// Position of TXRDY field.
	UDPHS_EPTCTLDIS1_TXRDY_Pos = 0xb
	// Bit mask of TXRDY field.
	UDPHS_EPTCTLDIS1_TXRDY_Msk = 0x800
	// Bit TXRDY.
	UDPHS_EPTCTLDIS1_TXRDY = 0x800
	// Position of RX_SETUP field.
	UDPHS_EPTCTLDIS1_RX_SETUP_Pos = 0xc
	// Bit mask of RX_SETUP field.
	UDPHS_EPTCTLDIS1_RX_SETUP_Msk = 0x1000
	// Bit RX_SETUP.
	UDPHS_EPTCTLDIS1_RX_SETUP = 0x1000
	// Position of STALL_SNT field.
	UDPHS_EPTCTLDIS1_STALL_SNT_Pos = 0xd
	// Bit mask of STALL_SNT field.
	UDPHS_EPTCTLDIS1_STALL_SNT_Msk = 0x2000
	// Bit STALL_SNT.
	UDPHS_EPTCTLDIS1_STALL_SNT = 0x2000
	// Position of NAK_IN field.
	UDPHS_EPTCTLDIS1_NAK_IN_Pos = 0xe
	// Bit mask of NAK_IN field.
	UDPHS_EPTCTLDIS1_NAK_IN_Msk = 0x4000
	// Bit NAK_IN.
	UDPHS_EPTCTLDIS1_NAK_IN = 0x4000
	// Position of NAK_OUT field.
	UDPHS_EPTCTLDIS1_NAK_OUT_Pos = 0xf
	// Bit mask of NAK_OUT field.
	UDPHS_EPTCTLDIS1_NAK_OUT_Msk = 0x8000
	// Bit NAK_OUT.
	UDPHS_EPTCTLDIS1_NAK_OUT = 0x8000
	// Position of BUSY_BANK field.
	UDPHS_EPTCTLDIS1_BUSY_BANK_Pos = 0x12
	// Bit mask of BUSY_BANK field.
	UDPHS_EPTCTLDIS1_BUSY_BANK_Msk = 0x40000
	// Bit BUSY_BANK.
	UDPHS_EPTCTLDIS1_BUSY_BANK = 0x40000
	// Position of SHRT_PCKT field.
	UDPHS_EPTCTLDIS1_SHRT_PCKT_Pos = 0x1f
	// Bit mask of SHRT_PCKT field.
	UDPHS_EPTCTLDIS1_SHRT_PCKT_Msk = 0x80000000
	// Bit SHRT_PCKT.
	UDPHS_EPTCTLDIS1_SHRT_PCKT = 0x80000000

	// EPTCTLDIS1_ISOENDPT: UDPHS Endpoint Control Disable Register (endpoint = 1)
	// Position of EPT_DISABL field.
	UDPHS_EPTCTLDIS1_ISOENDPT_EPT_DISABL_Pos = 0x0
	// Bit mask of EPT_DISABL field.
	UDPHS_EPTCTLDIS1_ISOENDPT_EPT_DISABL_Msk = 0x1
	// Bit EPT_DISABL.
	UDPHS_EPTCTLDIS1_ISOENDPT_EPT_DISABL = 0x1
	// Position of AUTO_VALID field.
	UDPHS_EPTCTLDIS1_ISOENDPT_AUTO_VALID_Pos = 0x1
	// Bit mask of AUTO_VALID field.
	UDPHS_EPTCTLDIS1_ISOENDPT_AUTO_VALID_Msk = 0x2
	// Bit AUTO_VALID.
	UDPHS_EPTCTLDIS1_ISOENDPT_AUTO_VALID = 0x2
	// Position of INTDIS_DMA field.
	UDPHS_EPTCTLDIS1_ISOENDPT_INTDIS_DMA_Pos = 0x3
	// Bit mask of INTDIS_DMA field.
	UDPHS_EPTCTLDIS1_ISOENDPT_INTDIS_DMA_Msk = 0x8
	// Bit INTDIS_DMA.
	UDPHS_EPTCTLDIS1_ISOENDPT_INTDIS_DMA = 0x8
	// Position of DATAX_RX field.
	UDPHS_EPTCTLDIS1_ISOENDPT_DATAX_RX_Pos = 0x6
	// Bit mask of DATAX_RX field.
	UDPHS_EPTCTLDIS1_ISOENDPT_DATAX_RX_Msk = 0x40
	// Bit DATAX_RX.
	UDPHS_EPTCTLDIS1_ISOENDPT_DATAX_RX = 0x40
	// Position of MDATA_RX field.
	UDPHS_EPTCTLDIS1_ISOENDPT_MDATA_RX_Pos = 0x7
	// Bit mask of MDATA_RX field.
	UDPHS_EPTCTLDIS1_ISOENDPT_MDATA_RX_Msk = 0x80
	// Bit MDATA_RX.
	UDPHS_EPTCTLDIS1_ISOENDPT_MDATA_RX = 0x80
	// Position of ERR_OVFLW field.
	UDPHS_EPTCTLDIS1_ISOENDPT_ERR_OVFLW_Pos = 0x8
	// Bit mask of ERR_OVFLW field.
	UDPHS_EPTCTLDIS1_ISOENDPT_ERR_OVFLW_Msk = 0x100
	// Bit ERR_OVFLW.
	UDPHS_EPTCTLDIS1_ISOENDPT_ERR_OVFLW = 0x100
	// Position of RXRDY_TXKL field.
	UDPHS_EPTCTLDIS1_ISOENDPT_RXRDY_TXKL_Pos = 0x9
	// Bit mask of RXRDY_TXKL field.
	UDPHS_EPTCTLDIS1_ISOENDPT_RXRDY_TXKL_Msk = 0x200
	// Bit RXRDY_TXKL.
	UDPHS_EPTCTLDIS1_ISOENDPT_RXRDY_TXKL = 0x200
	// Position of TX_COMPLT field.
	UDPHS_EPTCTLDIS1_ISOENDPT_TX_COMPLT_Pos = 0xa
	// Bit mask of TX_COMPLT field.
	UDPHS_EPTCTLDIS1_ISOENDPT_TX_COMPLT_Msk = 0x400
	// Bit TX_COMPLT.
	UDPHS_EPTCTLDIS1_ISOENDPT_TX_COMPLT = 0x400
	// Position of TXRDY_TRER field.
	UDPHS_EPTCTLDIS1_ISOENDPT_TXRDY_TRER_Pos = 0xb
	// Bit mask of TXRDY_TRER field.
	UDPHS_EPTCTLDIS1_ISOENDPT_TXRDY_TRER_Msk = 0x800
	// Bit TXRDY_TRER.
	UDPHS_EPTCTLDIS1_ISOENDPT_TXRDY_TRER = 0x800
	// Position of ERR_FL_ISO field.
	UDPHS_EPTCTLDIS1_ISOENDPT_ERR_FL_ISO_Pos = 0xc
	// Bit mask of ERR_FL_ISO field.
	UDPHS_EPTCTLDIS1_ISOENDPT_ERR_FL_ISO_Msk = 0x1000
	// Bit ERR_FL_ISO.
	UDPHS_EPTCTLDIS1_ISOENDPT_ERR_FL_ISO = 0x1000
	// Position of ERR_CRC_NTR field.
	UDPHS_EPTCTLDIS1_ISOENDPT_ERR_CRC_NTR_Pos = 0xd
	// Bit mask of ERR_CRC_NTR field.
	UDPHS_EPTCTLDIS1_ISOENDPT_ERR_CRC_NTR_Msk = 0x2000
	// Bit ERR_CRC_NTR.
	UDPHS_EPTCTLDIS1_ISOENDPT_ERR_CRC_NTR = 0x2000
	// Position of ERR_FLUSH field.
	UDPHS_EPTCTLDIS1_ISOENDPT_ERR_FLUSH_Pos = 0xe
	// Bit mask of ERR_FLUSH field.
	UDPHS_EPTCTLDIS1_ISOENDPT_ERR_FLUSH_Msk = 0x4000
	// Bit ERR_FLUSH.
	UDPHS_EPTCTLDIS1_ISOENDPT_ERR_FLUSH = 0x4000
	// Position of BUSY_BANK field.
	UDPHS_EPTCTLDIS1_ISOENDPT_BUSY_BANK_Pos = 0x12
	// Bit mask of BUSY_BANK field.
	UDPHS_EPTCTLDIS1_ISOENDPT_BUSY_BANK_Msk = 0x40000
	// Bit BUSY_BANK.
	UDPHS_EPTCTLDIS1_ISOENDPT_BUSY_BANK = 0x40000
	// Position of SHRT_PCKT field.
	UDPHS_EPTCTLDIS1_ISOENDPT_SHRT_PCKT_Pos = 0x1f
	// Bit mask of SHRT_PCKT field.
	UDPHS_EPTCTLDIS1_ISOENDPT_SHRT_PCKT_Msk = 0x80000000
	// Bit SHRT_PCKT.
	UDPHS_EPTCTLDIS1_ISOENDPT_SHRT_PCKT = 0x80000000

	// EPTCTL1: UDPHS Endpoint Control Register (endpoint = 1)
	// Position of EPT_ENABL field.
	UDPHS_EPTCTL1_EPT_ENABL_Pos = 0x0
	// Bit mask of EPT_ENABL field.
	UDPHS_EPTCTL1_EPT_ENABL_Msk = 0x1
	// Bit EPT_ENABL.
	UDPHS_EPTCTL1_EPT_ENABL = 0x1
	// Position of AUTO_VALID field.
	UDPHS_EPTCTL1_AUTO_VALID_Pos = 0x1
	// Bit mask of AUTO_VALID field.
	UDPHS_EPTCTL1_AUTO_VALID_Msk = 0x2
	// Bit AUTO_VALID.
	UDPHS_EPTCTL1_AUTO_VALID = 0x2
	// Position of INTDIS_DMA field.
	UDPHS_EPTCTL1_INTDIS_DMA_Pos = 0x3
	// Bit mask of INTDIS_DMA field.
	UDPHS_EPTCTL1_INTDIS_DMA_Msk = 0x8
	// Bit INTDIS_DMA.
	UDPHS_EPTCTL1_INTDIS_DMA = 0x8
	// Position of NYET_DIS field.
	UDPHS_EPTCTL1_NYET_DIS_Pos = 0x4
	// Bit mask of NYET_DIS field.
	UDPHS_EPTCTL1_NYET_DIS_Msk = 0x10
	// Bit NYET_DIS.
	UDPHS_EPTCTL1_NYET_DIS = 0x10
	// Position of ERR_OVFLW field.
	UDPHS_EPTCTL1_ERR_OVFLW_Pos = 0x8
	// Bit mask of ERR_OVFLW field.
	UDPHS_EPTCTL1_ERR_OVFLW_Msk = 0x100
	// Bit ERR_OVFLW.
	UDPHS_EPTCTL1_ERR_OVFLW = 0x100
	// Position of RXRDY_TXKL field.
	UDPHS_EPTCTL1_RXRDY_TXKL_Pos = 0x9
	// Bit mask of RXRDY_TXKL field.
	UDPHS_EPTCTL1_RXRDY_TXKL_Msk = 0x200
	// Bit RXRDY_TXKL.
	UDPHS_EPTCTL1_RXRDY_TXKL = 0x200
	// Position of TX_COMPLT field.
	UDPHS_EPTCTL1_TX_COMPLT_Pos = 0xa
	// Bit mask of TX_COMPLT field.
	UDPHS_EPTCTL1_TX_COMPLT_Msk = 0x400
	// Bit TX_COMPLT.
	UDPHS_EPTCTL1_TX_COMPLT = 0x400
	// Position of TXRDY field.
	UDPHS_EPTCTL1_TXRDY_Pos = 0xb
	// Bit mask of TXRDY field.
	UDPHS_EPTCTL1_TXRDY_Msk = 0x800
	// Bit TXRDY.
	UDPHS_EPTCTL1_TXRDY = 0x800
	// Position of RX_SETUP field.
	UDPHS_EPTCTL1_RX_SETUP_Pos = 0xc
	// Bit mask of RX_SETUP field.
	UDPHS_EPTCTL1_RX_SETUP_Msk = 0x1000
	// Bit RX_SETUP.
	UDPHS_EPTCTL1_RX_SETUP = 0x1000
	// Position of STALL_SNT field.
	UDPHS_EPTCTL1_STALL_SNT_Pos = 0xd
	// Bit mask of STALL_SNT field.
	UDPHS_EPTCTL1_STALL_SNT_Msk = 0x2000
	// Bit STALL_SNT.
	UDPHS_EPTCTL1_STALL_SNT = 0x2000
	// Position of NAK_IN field.
	UDPHS_EPTCTL1_NAK_IN_Pos = 0xe
	// Bit mask of NAK_IN field.
	UDPHS_EPTCTL1_NAK_IN_Msk = 0x4000
	// Bit NAK_IN.
	UDPHS_EPTCTL1_NAK_IN = 0x4000
	// Position of NAK_OUT field.
	UDPHS_EPTCTL1_NAK_OUT_Pos = 0xf
	// Bit mask of NAK_OUT field.
	UDPHS_EPTCTL1_NAK_OUT_Msk = 0x8000
	// Bit NAK_OUT.
	UDPHS_EPTCTL1_NAK_OUT = 0x8000
	// Position of BUSY_BANK field.
	UDPHS_EPTCTL1_BUSY_BANK_Pos = 0x12
	// Bit mask of BUSY_BANK field.
	UDPHS_EPTCTL1_BUSY_BANK_Msk = 0x40000
	// Bit BUSY_BANK.
	UDPHS_EPTCTL1_BUSY_BANK = 0x40000
	// Position of SHRT_PCKT field.
	UDPHS_EPTCTL1_SHRT_PCKT_Pos = 0x1f
	// Bit mask of SHRT_PCKT field.
	UDPHS_EPTCTL1_SHRT_PCKT_Msk = 0x80000000
	// Bit SHRT_PCKT.
	UDPHS_EPTCTL1_SHRT_PCKT = 0x80000000

	// EPTCTL1_ISOENDPT: UDPHS Endpoint Control Register (endpoint = 1)
	// Position of EPT_ENABL field.
	UDPHS_EPTCTL1_ISOENDPT_EPT_ENABL_Pos = 0x0
	// Bit mask of EPT_ENABL field.
	UDPHS_EPTCTL1_ISOENDPT_EPT_ENABL_Msk = 0x1
	// Bit EPT_ENABL.
	UDPHS_EPTCTL1_ISOENDPT_EPT_ENABL = 0x1
	// Position of AUTO_VALID field.
	UDPHS_EPTCTL1_ISOENDPT_AUTO_VALID_Pos = 0x1
	// Bit mask of AUTO_VALID field.
	UDPHS_EPTCTL1_ISOENDPT_AUTO_VALID_Msk = 0x2
	// Bit AUTO_VALID.
	UDPHS_EPTCTL1_ISOENDPT_AUTO_VALID = 0x2
	// Position of INTDIS_DMA field.
	UDPHS_EPTCTL1_ISOENDPT_INTDIS_DMA_Pos = 0x3
	// Bit mask of INTDIS_DMA field.
	UDPHS_EPTCTL1_ISOENDPT_INTDIS_DMA_Msk = 0x8
	// Bit INTDIS_DMA.
	UDPHS_EPTCTL1_ISOENDPT_INTDIS_DMA = 0x8
	// Position of DATAX_RX field.
	UDPHS_EPTCTL1_ISOENDPT_DATAX_RX_Pos = 0x6
	// Bit mask of DATAX_RX field.
	UDPHS_EPTCTL1_ISOENDPT_DATAX_RX_Msk = 0x40
	// Bit DATAX_RX.
	UDPHS_EPTCTL1_ISOENDPT_DATAX_RX = 0x40
	// Position of MDATA_RX field.
	UDPHS_EPTCTL1_ISOENDPT_MDATA_RX_Pos = 0x7
	// Bit mask of MDATA_RX field.
	UDPHS_EPTCTL1_ISOENDPT_MDATA_RX_Msk = 0x80
	// Bit MDATA_RX.
	UDPHS_EPTCTL1_ISOENDPT_MDATA_RX = 0x80
	// Position of ERR_OVFLW field.
	UDPHS_EPTCTL1_ISOENDPT_ERR_OVFLW_Pos = 0x8
	// Bit mask of ERR_OVFLW field.
	UDPHS_EPTCTL1_ISOENDPT_ERR_OVFLW_Msk = 0x100
	// Bit ERR_OVFLW.
	UDPHS_EPTCTL1_ISOENDPT_ERR_OVFLW = 0x100
	// Position of RXRDY_TXKL field.
	UDPHS_EPTCTL1_ISOENDPT_RXRDY_TXKL_Pos = 0x9
	// Bit mask of RXRDY_TXKL field.
	UDPHS_EPTCTL1_ISOENDPT_RXRDY_TXKL_Msk = 0x200
	// Bit RXRDY_TXKL.
	UDPHS_EPTCTL1_ISOENDPT_RXRDY_TXKL = 0x200
	// Position of TX_COMPLT field.
	UDPHS_EPTCTL1_ISOENDPT_TX_COMPLT_Pos = 0xa
	// Bit mask of TX_COMPLT field.
	UDPHS_EPTCTL1_ISOENDPT_TX_COMPLT_Msk = 0x400
	// Bit TX_COMPLT.
	UDPHS_EPTCTL1_ISOENDPT_TX_COMPLT = 0x400
	// Position of TXRDY_TRER field.
	UDPHS_EPTCTL1_ISOENDPT_TXRDY_TRER_Pos = 0xb
	// Bit mask of TXRDY_TRER field.
	UDPHS_EPTCTL1_ISOENDPT_TXRDY_TRER_Msk = 0x800
	// Bit TXRDY_TRER.
	UDPHS_EPTCTL1_ISOENDPT_TXRDY_TRER = 0x800
	// Position of ERR_FL_ISO field.
	UDPHS_EPTCTL1_ISOENDPT_ERR_FL_ISO_Pos = 0xc
	// Bit mask of ERR_FL_ISO field.
	UDPHS_EPTCTL1_ISOENDPT_ERR_FL_ISO_Msk = 0x1000
	// Bit ERR_FL_ISO.
	UDPHS_EPTCTL1_ISOENDPT_ERR_FL_ISO = 0x1000
	// Position of ERR_CRC_NTR field.
	UDPHS_EPTCTL1_ISOENDPT_ERR_CRC_NTR_Pos = 0xd
	// Bit mask of ERR_CRC_NTR field.
	UDPHS_EPTCTL1_ISOENDPT_ERR_CRC_NTR_Msk = 0x2000
	// Bit ERR_CRC_NTR.
	UDPHS_EPTCTL1_ISOENDPT_ERR_CRC_NTR = 0x2000
	// Position of ERR_FLUSH field.
	UDPHS_EPTCTL1_ISOENDPT_ERR_FLUSH_Pos = 0xe
	// Bit mask of ERR_FLUSH field.
	UDPHS_EPTCTL1_ISOENDPT_ERR_FLUSH_Msk = 0x4000
	// Bit ERR_FLUSH.
	UDPHS_EPTCTL1_ISOENDPT_ERR_FLUSH = 0x4000
	// Position of BUSY_BANK field.
	UDPHS_EPTCTL1_ISOENDPT_BUSY_BANK_Pos = 0x12
	// Bit mask of BUSY_BANK field.
	UDPHS_EPTCTL1_ISOENDPT_BUSY_BANK_Msk = 0x40000
	// Bit BUSY_BANK.
	UDPHS_EPTCTL1_ISOENDPT_BUSY_BANK = 0x40000
	// Position of SHRT_PCKT field.
	UDPHS_EPTCTL1_ISOENDPT_SHRT_PCKT_Pos = 0x1f
	// Bit mask of SHRT_PCKT field.
	UDPHS_EPTCTL1_ISOENDPT_SHRT_PCKT_Msk = 0x80000000
	// Bit SHRT_PCKT.
	UDPHS_EPTCTL1_ISOENDPT_SHRT_PCKT = 0x80000000

	// EPTSETSTA1: UDPHS Endpoint Set Status Register (endpoint = 1)
	// Position of FRCESTALL field.
	UDPHS_EPTSETSTA1_FRCESTALL_Pos = 0x5
	// Bit mask of FRCESTALL field.
	UDPHS_EPTSETSTA1_FRCESTALL_Msk = 0x20
	// Bit FRCESTALL.
	UDPHS_EPTSETSTA1_FRCESTALL = 0x20
	// Position of RXRDY_TXKL field.
	UDPHS_EPTSETSTA1_RXRDY_TXKL_Pos = 0x9
	// Bit mask of RXRDY_TXKL field.
	UDPHS_EPTSETSTA1_RXRDY_TXKL_Msk = 0x200
	// Bit RXRDY_TXKL.
	UDPHS_EPTSETSTA1_RXRDY_TXKL = 0x200
	// Position of TXRDY field.
	UDPHS_EPTSETSTA1_TXRDY_Pos = 0xb
	// Bit mask of TXRDY field.
	UDPHS_EPTSETSTA1_TXRDY_Msk = 0x800
	// Bit TXRDY.
	UDPHS_EPTSETSTA1_TXRDY = 0x800

	// EPTSETSTA1_ISOENDPT: UDPHS Endpoint Set Status Register (endpoint = 1)
	// Position of RXRDY_TXKL field.
	UDPHS_EPTSETSTA1_ISOENDPT_RXRDY_TXKL_Pos = 0x9
	// Bit mask of RXRDY_TXKL field.
	UDPHS_EPTSETSTA1_ISOENDPT_RXRDY_TXKL_Msk = 0x200
	// Bit RXRDY_TXKL.
	UDPHS_EPTSETSTA1_ISOENDPT_RXRDY_TXKL = 0x200
	// Position of TXRDY_TRER field.
	UDPHS_EPTSETSTA1_ISOENDPT_TXRDY_TRER_Pos = 0xb
	// Bit mask of TXRDY_TRER field.
	UDPHS_EPTSETSTA1_ISOENDPT_TXRDY_TRER_Msk = 0x800
	// Bit TXRDY_TRER.
	UDPHS_EPTSETSTA1_ISOENDPT_TXRDY_TRER = 0x800

	// EPTCLRSTA1: UDPHS Endpoint Clear Status Register (endpoint = 1)
	// Position of FRCESTALL field.
	UDPHS_EPTCLRSTA1_FRCESTALL_Pos = 0x5
	// Bit mask of FRCESTALL field.
	UDPHS_EPTCLRSTA1_FRCESTALL_Msk = 0x20
	// Bit FRCESTALL.
	UDPHS_EPTCLRSTA1_FRCESTALL = 0x20
	// Position of TOGGLESQ field.
	UDPHS_EPTCLRSTA1_TOGGLESQ_Pos = 0x6
	// Bit mask of TOGGLESQ field.
	UDPHS_EPTCLRSTA1_TOGGLESQ_Msk = 0x40
	// Bit TOGGLESQ.
	UDPHS_EPTCLRSTA1_TOGGLESQ = 0x40
	// Position of RXRDY_TXKL field.
	UDPHS_EPTCLRSTA1_RXRDY_TXKL_Pos = 0x9
	// Bit mask of RXRDY_TXKL field.
	UDPHS_EPTCLRSTA1_RXRDY_TXKL_Msk = 0x200
	// Bit RXRDY_TXKL.
	UDPHS_EPTCLRSTA1_RXRDY_TXKL = 0x200
	// Position of TX_COMPLT field.
	UDPHS_EPTCLRSTA1_TX_COMPLT_Pos = 0xa
	// Bit mask of TX_COMPLT field.
	UDPHS_EPTCLRSTA1_TX_COMPLT_Msk = 0x400
	// Bit TX_COMPLT.
	UDPHS_EPTCLRSTA1_TX_COMPLT = 0x400
	// Position of RX_SETUP field.
	UDPHS_EPTCLRSTA1_RX_SETUP_Pos = 0xc
	// Bit mask of RX_SETUP field.
	UDPHS_EPTCLRSTA1_RX_SETUP_Msk = 0x1000
	// Bit RX_SETUP.
	UDPHS_EPTCLRSTA1_RX_SETUP = 0x1000
	// Position of STALL_SNT field.
	UDPHS_EPTCLRSTA1_STALL_SNT_Pos = 0xd
	// Bit mask of STALL_SNT field.
	UDPHS_EPTCLRSTA1_STALL_SNT_Msk = 0x2000
	// Bit STALL_SNT.
	UDPHS_EPTCLRSTA1_STALL_SNT = 0x2000
	// Position of NAK_IN field.
	UDPHS_EPTCLRSTA1_NAK_IN_Pos = 0xe
	// Bit mask of NAK_IN field.
	UDPHS_EPTCLRSTA1_NAK_IN_Msk = 0x4000
	// Bit NAK_IN.
	UDPHS_EPTCLRSTA1_NAK_IN = 0x4000
	// Position of NAK_OUT field.
	UDPHS_EPTCLRSTA1_NAK_OUT_Pos = 0xf
	// Bit mask of NAK_OUT field.
	UDPHS_EPTCLRSTA1_NAK_OUT_Msk = 0x8000
	// Bit NAK_OUT.
	UDPHS_EPTCLRSTA1_NAK_OUT = 0x8000

	// EPTCLRSTA1_ISOENDPT: UDPHS Endpoint Clear Status Register (endpoint = 1)
	// Position of TOGGLESQ field.
	UDPHS_EPTCLRSTA1_ISOENDPT_TOGGLESQ_Pos = 0x6
	// Bit mask of TOGGLESQ field.
	UDPHS_EPTCLRSTA1_ISOENDPT_TOGGLESQ_Msk = 0x40
	// Bit TOGGLESQ.
	UDPHS_EPTCLRSTA1_ISOENDPT_TOGGLESQ = 0x40
	// Position of RXRDY_TXKL field.
	UDPHS_EPTCLRSTA1_ISOENDPT_RXRDY_TXKL_Pos = 0x9
	// Bit mask of RXRDY_TXKL field.
	UDPHS_EPTCLRSTA1_ISOENDPT_RXRDY_TXKL_Msk = 0x200
	// Bit RXRDY_TXKL.
	UDPHS_EPTCLRSTA1_ISOENDPT_RXRDY_TXKL = 0x200
	// Position of TX_COMPLT field.
	UDPHS_EPTCLRSTA1_ISOENDPT_TX_COMPLT_Pos = 0xa
	// Bit mask of TX_COMPLT field.
	UDPHS_EPTCLRSTA1_ISOENDPT_TX_COMPLT_Msk = 0x400
	// Bit TX_COMPLT.
	UDPHS_EPTCLRSTA1_ISOENDPT_TX_COMPLT = 0x400
	// Position of ERR_FL_ISO field.
	UDPHS_EPTCLRSTA1_ISOENDPT_ERR_FL_ISO_Pos = 0xc
	// Bit mask of ERR_FL_ISO field.
	UDPHS_EPTCLRSTA1_ISOENDPT_ERR_FL_ISO_Msk = 0x1000
	// Bit ERR_FL_ISO.
	UDPHS_EPTCLRSTA1_ISOENDPT_ERR_FL_ISO = 0x1000
	// Position of ERR_CRC_NTR field.
	UDPHS_EPTCLRSTA1_ISOENDPT_ERR_CRC_NTR_Pos = 0xd
	// Bit mask of ERR_CRC_NTR field.
	UDPHS_EPTCLRSTA1_ISOENDPT_ERR_CRC_NTR_Msk = 0x2000
	// Bit ERR_CRC_NTR.
	UDPHS_EPTCLRSTA1_ISOENDPT_ERR_CRC_NTR = 0x2000
	// Position of ERR_FLUSH field.
	UDPHS_EPTCLRSTA1_ISOENDPT_ERR_FLUSH_Pos = 0xe
	// Bit mask of ERR_FLUSH field.
	UDPHS_EPTCLRSTA1_ISOENDPT_ERR_FLUSH_Msk = 0x4000
	// Bit ERR_FLUSH.
	UDPHS_EPTCLRSTA1_ISOENDPT_ERR_FLUSH = 0x4000

	// EPTSTA1: UDPHS Endpoint Status Register (endpoint = 1)
	// Position of FRCESTALL field.
	UDPHS_EPTSTA1_FRCESTALL_Pos = 0x5
	// Bit mask of FRCESTALL field.
	UDPHS_EPTSTA1_FRCESTALL_Msk = 0x20
	// Bit FRCESTALL.
	UDPHS_EPTSTA1_FRCESTALL = 0x20
	// Position of TOGGLESQ_STA field.
	UDPHS_EPTSTA1_TOGGLESQ_STA_Pos = 0x6
	// Bit mask of TOGGLESQ_STA field.
	UDPHS_EPTSTA1_TOGGLESQ_STA_Msk = 0xc0
	// DATA0
	UDPHS_EPTSTA1_TOGGLESQ_STA_DATA0 = 0x0
	// DATA1
	UDPHS_EPTSTA1_TOGGLESQ_STA_DATA1 = 0x1
	// Reserved for High Bandwidth Isochronous Endpoint
	UDPHS_EPTSTA1_TOGGLESQ_STA_DATA2 = 0x2
	// Reserved for High Bandwidth Isochronous Endpoint
	UDPHS_EPTSTA1_TOGGLESQ_STA_MDATA = 0x3
	// Position of ERR_OVFLW field.
	UDPHS_EPTSTA1_ERR_OVFLW_Pos = 0x8
	// Bit mask of ERR_OVFLW field.
	UDPHS_EPTSTA1_ERR_OVFLW_Msk = 0x100
	// Bit ERR_OVFLW.
	UDPHS_EPTSTA1_ERR_OVFLW = 0x100
	// Position of RXRDY_TXKL field.
	UDPHS_EPTSTA1_RXRDY_TXKL_Pos = 0x9
	// Bit mask of RXRDY_TXKL field.
	UDPHS_EPTSTA1_RXRDY_TXKL_Msk = 0x200
	// Bit RXRDY_TXKL.
	UDPHS_EPTSTA1_RXRDY_TXKL = 0x200
	// Position of TX_COMPLT field.
	UDPHS_EPTSTA1_TX_COMPLT_Pos = 0xa
	// Bit mask of TX_COMPLT field.
	UDPHS_EPTSTA1_TX_COMPLT_Msk = 0x400
	// Bit TX_COMPLT.
	UDPHS_EPTSTA1_TX_COMPLT = 0x400
	// Position of TXRDY field.
	UDPHS_EPTSTA1_TXRDY_Pos = 0xb
	// Bit mask of TXRDY field.
	UDPHS_EPTSTA1_TXRDY_Msk = 0x800
	// Bit TXRDY.
	UDPHS_EPTSTA1_TXRDY = 0x800
	// Position of RX_SETUP field.
	UDPHS_EPTSTA1_RX_SETUP_Pos = 0xc
	// Bit mask of RX_SETUP field.
	UDPHS_EPTSTA1_RX_SETUP_Msk = 0x1000
	// Bit RX_SETUP.
	UDPHS_EPTSTA1_RX_SETUP = 0x1000
	// Position of STALL_SNT field.
	UDPHS_EPTSTA1_STALL_SNT_Pos = 0xd
	// Bit mask of STALL_SNT field.
	UDPHS_EPTSTA1_STALL_SNT_Msk = 0x2000
	// Bit STALL_SNT.
	UDPHS_EPTSTA1_STALL_SNT = 0x2000
	// Position of NAK_IN field.
	UDPHS_EPTSTA1_NAK_IN_Pos = 0xe
	// Bit mask of NAK_IN field.
	UDPHS_EPTSTA1_NAK_IN_Msk = 0x4000
	// Bit NAK_IN.
	UDPHS_EPTSTA1_NAK_IN = 0x4000
	// Position of NAK_OUT field.
	UDPHS_EPTSTA1_NAK_OUT_Pos = 0xf
	// Bit mask of NAK_OUT field.
	UDPHS_EPTSTA1_NAK_OUT_Msk = 0x8000
	// Bit NAK_OUT.
	UDPHS_EPTSTA1_NAK_OUT = 0x8000
	// Position of CURBK_CTLDIR field.
	UDPHS_EPTSTA1_CURBK_CTLDIR_Pos = 0x10
	// Bit mask of CURBK_CTLDIR field.
	UDPHS_EPTSTA1_CURBK_CTLDIR_Msk = 0x30000
	// Position of BUSY_BANK_STA field.
	UDPHS_EPTSTA1_BUSY_BANK_STA_Pos = 0x12
	// Bit mask of BUSY_BANK_STA field.
	UDPHS_EPTSTA1_BUSY_BANK_STA_Msk = 0xc0000
	// 1 busy bank
	UDPHS_EPTSTA1_BUSY_BANK_STA_1BUSYBANK = 0x0
	// 2 busy banks
	UDPHS_EPTSTA1_BUSY_BANK_STA_2BUSYBANKS = 0x1
	// 3 busy banks
	UDPHS_EPTSTA1_BUSY_BANK_STA_3BUSYBANKS = 0x2
	// Position of BYTE_COUNT field.
	UDPHS_EPTSTA1_BYTE_COUNT_Pos = 0x14
	// Bit mask of BYTE_COUNT field.
	UDPHS_EPTSTA1_BYTE_COUNT_Msk = 0x7ff00000
	// Position of SHRT_PCKT field.
	UDPHS_EPTSTA1_SHRT_PCKT_Pos = 0x1f
	// Bit mask of SHRT_PCKT field.
	UDPHS_EPTSTA1_SHRT_PCKT_Msk = 0x80000000
	// Bit SHRT_PCKT.
	UDPHS_EPTSTA1_SHRT_PCKT = 0x80000000

	// EPTSTA1_ISOENDPT: UDPHS Endpoint Status Register (endpoint = 1)
	// Position of TOGGLESQ_STA field.
	UDPHS_EPTSTA1_ISOENDPT_TOGGLESQ_STA_Pos = 0x6
	// Bit mask of TOGGLESQ_STA field.
	UDPHS_EPTSTA1_ISOENDPT_TOGGLESQ_STA_Msk = 0xc0
	// DATA0
	UDPHS_EPTSTA1_ISOENDPT_TOGGLESQ_STA_DATA0 = 0x0
	// DATA1
	UDPHS_EPTSTA1_ISOENDPT_TOGGLESQ_STA_DATA1 = 0x1
	// Data2 (only for High Bandwidth Isochronous Endpoint)
	UDPHS_EPTSTA1_ISOENDPT_TOGGLESQ_STA_DATA2 = 0x2
	// MData (only for High Bandwidth Isochronous Endpoint)
	UDPHS_EPTSTA1_ISOENDPT_TOGGLESQ_STA_MDATA = 0x3
	// Position of ERR_OVFLW field.
	UDPHS_EPTSTA1_ISOENDPT_ERR_OVFLW_Pos = 0x8
	// Bit mask of ERR_OVFLW field.
	UDPHS_EPTSTA1_ISOENDPT_ERR_OVFLW_Msk = 0x100
	// Bit ERR_OVFLW.
	UDPHS_EPTSTA1_ISOENDPT_ERR_OVFLW = 0x100
	// Position of RXRDY_TXKL field.
	UDPHS_EPTSTA1_ISOENDPT_RXRDY_TXKL_Pos = 0x9
	// Bit mask of RXRDY_TXKL field.
	UDPHS_EPTSTA1_ISOENDPT_RXRDY_TXKL_Msk = 0x200
	// Bit RXRDY_TXKL.
	UDPHS_EPTSTA1_ISOENDPT_RXRDY_TXKL = 0x200
	// Position of TX_COMPLT field.
	UDPHS_EPTSTA1_ISOENDPT_TX_COMPLT_Pos = 0xa
	// Bit mask of TX_COMPLT field.
	UDPHS_EPTSTA1_ISOENDPT_TX_COMPLT_Msk = 0x400
	// Bit TX_COMPLT.
	UDPHS_EPTSTA1_ISOENDPT_TX_COMPLT = 0x400
	// Position of TXRDY_TRER field.
	UDPHS_EPTSTA1_ISOENDPT_TXRDY_TRER_Pos = 0xb
	// Bit mask of TXRDY_TRER field.
	UDPHS_EPTSTA1_ISOENDPT_TXRDY_TRER_Msk = 0x800
	// Bit TXRDY_TRER.
	UDPHS_EPTSTA1_ISOENDPT_TXRDY_TRER = 0x800
	// Position of ERR_FL_ISO field.
	UDPHS_EPTSTA1_ISOENDPT_ERR_FL_ISO_Pos = 0xc
	// Bit mask of ERR_FL_ISO field.
	UDPHS_EPTSTA1_ISOENDPT_ERR_FL_ISO_Msk = 0x1000
	// Bit ERR_FL_ISO.
	UDPHS_EPTSTA1_ISOENDPT_ERR_FL_ISO = 0x1000
	// Position of ERR_CRC_NTR field.
	UDPHS_EPTSTA1_ISOENDPT_ERR_CRC_NTR_Pos = 0xd
	// Bit mask of ERR_CRC_NTR field.
	UDPHS_EPTSTA1_ISOENDPT_ERR_CRC_NTR_Msk = 0x2000
	// Bit ERR_CRC_NTR.
	UDPHS_EPTSTA1_ISOENDPT_ERR_CRC_NTR = 0x2000
	// Position of ERR_FLUSH field.
	UDPHS_EPTSTA1_ISOENDPT_ERR_FLUSH_Pos = 0xe
	// Bit mask of ERR_FLUSH field.
	UDPHS_EPTSTA1_ISOENDPT_ERR_FLUSH_Msk = 0x4000
	// Bit ERR_FLUSH.
	UDPHS_EPTSTA1_ISOENDPT_ERR_FLUSH = 0x4000
	// Position of CURBK field.
	UDPHS_EPTSTA1_ISOENDPT_CURBK_Pos = 0x10
	// Bit mask of CURBK field.
	UDPHS_EPTSTA1_ISOENDPT_CURBK_Msk = 0x30000
	// Bank 0 (or single bank)
	UDPHS_EPTSTA1_ISOENDPT_CURBK_BANK0 = 0x0
	// Bank 1
	UDPHS_EPTSTA1_ISOENDPT_CURBK_BANK1 = 0x1
	// Bank 2
	UDPHS_EPTSTA1_ISOENDPT_CURBK_BANK2 = 0x2
	// Position of BUSY_BANK_STA field.
	UDPHS_EPTSTA1_ISOENDPT_BUSY_BANK_STA_Pos = 0x12
	// Bit mask of BUSY_BANK_STA field.
	UDPHS_EPTSTA1_ISOENDPT_BUSY_BANK_STA_Msk = 0xc0000
	// 1 busy bank
	UDPHS_EPTSTA1_ISOENDPT_BUSY_BANK_STA_1BUSYBANK = 0x0
	// 2 busy banks
	UDPHS_EPTSTA1_ISOENDPT_BUSY_BANK_STA_2BUSYBANKS = 0x1
	// 3 busy banks
	UDPHS_EPTSTA1_ISOENDPT_BUSY_BANK_STA_3BUSYBANKS = 0x2
	// Position of BYTE_COUNT field.
	UDPHS_EPTSTA1_ISOENDPT_BYTE_COUNT_Pos = 0x14
	// Bit mask of BYTE_COUNT field.
	UDPHS_EPTSTA1_ISOENDPT_BYTE_COUNT_Msk = 0x7ff00000
	// Position of SHRT_PCKT field.
	UDPHS_EPTSTA1_ISOENDPT_SHRT_PCKT_Pos = 0x1f
	// Bit mask of SHRT_PCKT field.
	UDPHS_EPTSTA1_ISOENDPT_SHRT_PCKT_Msk = 0x80000000
	// Bit SHRT_PCKT.
	UDPHS_EPTSTA1_ISOENDPT_SHRT_PCKT = 0x80000000

	// EPTCFG2: UDPHS Endpoint Configuration Register (endpoint = 2)
	// Position of EPT_SIZE field.
	UDPHS_EPTCFG2_EPT_SIZE_Pos = 0x0
	// Bit mask of EPT_SIZE field.
	UDPHS_EPTCFG2_EPT_SIZE_Msk = 0x7
	// 8 bytes
	UDPHS_EPTCFG2_EPT_SIZE_8 = 0x0
	// 16 bytes
	UDPHS_EPTCFG2_EPT_SIZE_16 = 0x1
	// 32 bytes
	UDPHS_EPTCFG2_EPT_SIZE_32 = 0x2
	// 64 bytes
	UDPHS_EPTCFG2_EPT_SIZE_64 = 0x3
	// 128 bytes
	UDPHS_EPTCFG2_EPT_SIZE_128 = 0x4
	// 256 bytes
	UDPHS_EPTCFG2_EPT_SIZE_256 = 0x5
	// 512 bytes
	UDPHS_EPTCFG2_EPT_SIZE_512 = 0x6
	// 1024 bytes
	UDPHS_EPTCFG2_EPT_SIZE_1024 = 0x7
	// Position of EPT_DIR field.
	UDPHS_EPTCFG2_EPT_DIR_Pos = 0x3
	// Bit mask of EPT_DIR field.
	UDPHS_EPTCFG2_EPT_DIR_Msk = 0x8
	// Bit EPT_DIR.
	UDPHS_EPTCFG2_EPT_DIR = 0x8
	// Position of EPT_TYPE field.
	UDPHS_EPTCFG2_EPT_TYPE_Pos = 0x4
	// Bit mask of EPT_TYPE field.
	UDPHS_EPTCFG2_EPT_TYPE_Msk = 0x30
	// Control endpoint
	UDPHS_EPTCFG2_EPT_TYPE_CTRL8 = 0x0
	// Isochronous endpoint
	UDPHS_EPTCFG2_EPT_TYPE_ISO = 0x1
	// Bulk endpoint
	UDPHS_EPTCFG2_EPT_TYPE_BULK = 0x2
	// Interrupt endpoint
	UDPHS_EPTCFG2_EPT_TYPE_INT = 0x3
	// Position of BK_NUMBER field.
	UDPHS_EPTCFG2_BK_NUMBER_Pos = 0x6
	// Bit mask of BK_NUMBER field.
	UDPHS_EPTCFG2_BK_NUMBER_Msk = 0xc0
	// Zero bank, the endpoint is not mapped in memory
	UDPHS_EPTCFG2_BK_NUMBER_0 = 0x0
	// One bank (bank 0)
	UDPHS_EPTCFG2_BK_NUMBER_1 = 0x1
	// Double bank (Ping-Pong: bank0/bank1)
	UDPHS_EPTCFG2_BK_NUMBER_2 = 0x2
	// Triple bank (bank0/bank1/bank2)
	UDPHS_EPTCFG2_BK_NUMBER_3 = 0x3
	// Position of NB_TRANS field.
	UDPHS_EPTCFG2_NB_TRANS_Pos = 0x8
	// Bit mask of NB_TRANS field.
	UDPHS_EPTCFG2_NB_TRANS_Msk = 0x300
	// Position of EPT_MAPD field.
	UDPHS_EPTCFG2_EPT_MAPD_Pos = 0x1f
	// Bit mask of EPT_MAPD field.
	UDPHS_EPTCFG2_EPT_MAPD_Msk = 0x80000000
	// Bit EPT_MAPD.
	UDPHS_EPTCFG2_EPT_MAPD = 0x80000000

	// EPTCTLENB2: UDPHS Endpoint Control Enable Register (endpoint = 2)
	// Position of EPT_ENABL field.
	UDPHS_EPTCTLENB2_EPT_ENABL_Pos = 0x0
	// Bit mask of EPT_ENABL field.
	UDPHS_EPTCTLENB2_EPT_ENABL_Msk = 0x1
	// Bit EPT_ENABL.
	UDPHS_EPTCTLENB2_EPT_ENABL = 0x1
	// Position of AUTO_VALID field.
	UDPHS_EPTCTLENB2_AUTO_VALID_Pos = 0x1
	// Bit mask of AUTO_VALID field.
	UDPHS_EPTCTLENB2_AUTO_VALID_Msk = 0x2
	// Bit AUTO_VALID.
	UDPHS_EPTCTLENB2_AUTO_VALID = 0x2
	// Position of INTDIS_DMA field.
	UDPHS_EPTCTLENB2_INTDIS_DMA_Pos = 0x3
	// Bit mask of INTDIS_DMA field.
	UDPHS_EPTCTLENB2_INTDIS_DMA_Msk = 0x8
	// Bit INTDIS_DMA.
	UDPHS_EPTCTLENB2_INTDIS_DMA = 0x8
	// Position of NYET_DIS field.
	UDPHS_EPTCTLENB2_NYET_DIS_Pos = 0x4
	// Bit mask of NYET_DIS field.
	UDPHS_EPTCTLENB2_NYET_DIS_Msk = 0x10
	// Bit NYET_DIS.
	UDPHS_EPTCTLENB2_NYET_DIS = 0x10
	// Position of ERR_OVFLW field.
	UDPHS_EPTCTLENB2_ERR_OVFLW_Pos = 0x8
	// Bit mask of ERR_OVFLW field.
	UDPHS_EPTCTLENB2_ERR_OVFLW_Msk = 0x100
	// Bit ERR_OVFLW.
	UDPHS_EPTCTLENB2_ERR_OVFLW = 0x100
	// Position of RXRDY_TXKL field.
	UDPHS_EPTCTLENB2_RXRDY_TXKL_Pos = 0x9
	// Bit mask of RXRDY_TXKL field.
	UDPHS_EPTCTLENB2_RXRDY_TXKL_Msk = 0x200
	// Bit RXRDY_TXKL.
	UDPHS_EPTCTLENB2_RXRDY_TXKL = 0x200
	// Position of TX_COMPLT field.
	UDPHS_EPTCTLENB2_TX_COMPLT_Pos = 0xa
	// Bit mask of TX_COMPLT field.
	UDPHS_EPTCTLENB2_TX_COMPLT_Msk = 0x400
	// Bit TX_COMPLT.
	UDPHS_EPTCTLENB2_TX_COMPLT = 0x400
	// Position of TXRDY field.
	UDPHS_EPTCTLENB2_TXRDY_Pos = 0xb
	// Bit mask of TXRDY field.
	UDPHS_EPTCTLENB2_TXRDY_Msk = 0x800
	// Bit TXRDY.
	UDPHS_EPTCTLENB2_TXRDY = 0x800
	// Position of RX_SETUP field.
	UDPHS_EPTCTLENB2_RX_SETUP_Pos = 0xc
	// Bit mask of RX_SETUP field.
	UDPHS_EPTCTLENB2_RX_SETUP_Msk = 0x1000
	// Bit RX_SETUP.
	UDPHS_EPTCTLENB2_RX_SETUP = 0x1000
	// Position of STALL_SNT field.
	UDPHS_EPTCTLENB2_STALL_SNT_Pos = 0xd
	// Bit mask of STALL_SNT field.
	UDPHS_EPTCTLENB2_STALL_SNT_Msk = 0x2000
	// Bit STALL_SNT.
	UDPHS_EPTCTLENB2_STALL_SNT = 0x2000
	// Position of NAK_IN field.
	UDPHS_EPTCTLENB2_NAK_IN_Pos = 0xe
	// Bit mask of NAK_IN field.
	UDPHS_EPTCTLENB2_NAK_IN_Msk = 0x4000
	// Bit NAK_IN.
	UDPHS_EPTCTLENB2_NAK_IN = 0x4000
	// Position of NAK_OUT field.
	UDPHS_EPTCTLENB2_NAK_OUT_Pos = 0xf
	// Bit mask of NAK_OUT field.
	UDPHS_EPTCTLENB2_NAK_OUT_Msk = 0x8000
	// Bit NAK_OUT.
	UDPHS_EPTCTLENB2_NAK_OUT = 0x8000
	// Position of BUSY_BANK field.
	UDPHS_EPTCTLENB2_BUSY_BANK_Pos = 0x12
	// Bit mask of BUSY_BANK field.
	UDPHS_EPTCTLENB2_BUSY_BANK_Msk = 0x40000
	// Bit BUSY_BANK.
	UDPHS_EPTCTLENB2_BUSY_BANK = 0x40000
	// Position of SHRT_PCKT field.
	UDPHS_EPTCTLENB2_SHRT_PCKT_Pos = 0x1f
	// Bit mask of SHRT_PCKT field.
	UDPHS_EPTCTLENB2_SHRT_PCKT_Msk = 0x80000000
	// Bit SHRT_PCKT.
	UDPHS_EPTCTLENB2_SHRT_PCKT = 0x80000000

	// EPTCTLENB2_ISOENDPT: UDPHS Endpoint Control Enable Register (endpoint = 2)
	// Position of EPT_ENABL field.
	UDPHS_EPTCTLENB2_ISOENDPT_EPT_ENABL_Pos = 0x0
	// Bit mask of EPT_ENABL field.
	UDPHS_EPTCTLENB2_ISOENDPT_EPT_ENABL_Msk = 0x1
	// Bit EPT_ENABL.
	UDPHS_EPTCTLENB2_ISOENDPT_EPT_ENABL = 0x1
	// Position of AUTO_VALID field.
	UDPHS_EPTCTLENB2_ISOENDPT_AUTO_VALID_Pos = 0x1
	// Bit mask of AUTO_VALID field.
	UDPHS_EPTCTLENB2_ISOENDPT_AUTO_VALID_Msk = 0x2
	// Bit AUTO_VALID.
	UDPHS_EPTCTLENB2_ISOENDPT_AUTO_VALID = 0x2
	// Position of INTDIS_DMA field.
	UDPHS_EPTCTLENB2_ISOENDPT_INTDIS_DMA_Pos = 0x3
	// Bit mask of INTDIS_DMA field.
	UDPHS_EPTCTLENB2_ISOENDPT_INTDIS_DMA_Msk = 0x8
	// Bit INTDIS_DMA.
	UDPHS_EPTCTLENB2_ISOENDPT_INTDIS_DMA = 0x8
	// Position of DATAX_RX field.
	UDPHS_EPTCTLENB2_ISOENDPT_DATAX_RX_Pos = 0x6
	// Bit mask of DATAX_RX field.
	UDPHS_EPTCTLENB2_ISOENDPT_DATAX_RX_Msk = 0x40
	// Bit DATAX_RX.
	UDPHS_EPTCTLENB2_ISOENDPT_DATAX_RX = 0x40
	// Position of MDATA_RX field.
	UDPHS_EPTCTLENB2_ISOENDPT_MDATA_RX_Pos = 0x7
	// Bit mask of MDATA_RX field.
	UDPHS_EPTCTLENB2_ISOENDPT_MDATA_RX_Msk = 0x80
	// Bit MDATA_RX.
	UDPHS_EPTCTLENB2_ISOENDPT_MDATA_RX = 0x80
	// Position of ERR_OVFLW field.
	UDPHS_EPTCTLENB2_ISOENDPT_ERR_OVFLW_Pos = 0x8
	// Bit mask of ERR_OVFLW field.
	UDPHS_EPTCTLENB2_ISOENDPT_ERR_OVFLW_Msk = 0x100
	// Bit ERR_OVFLW.
	UDPHS_EPTCTLENB2_ISOENDPT_ERR_OVFLW = 0x100
	// Position of RXRDY_TXKL field.
	UDPHS_EPTCTLENB2_ISOENDPT_RXRDY_TXKL_Pos = 0x9
	// Bit mask of RXRDY_TXKL field.
	UDPHS_EPTCTLENB2_ISOENDPT_RXRDY_TXKL_Msk = 0x200
	// Bit RXRDY_TXKL.
	UDPHS_EPTCTLENB2_ISOENDPT_RXRDY_TXKL = 0x200
	// Position of TX_COMPLT field.
	UDPHS_EPTCTLENB2_ISOENDPT_TX_COMPLT_Pos = 0xa
	// Bit mask of TX_COMPLT field.
	UDPHS_EPTCTLENB2_ISOENDPT_TX_COMPLT_Msk = 0x400
	// Bit TX_COMPLT.
	UDPHS_EPTCTLENB2_ISOENDPT_TX_COMPLT = 0x400
	// Position of TXRDY_TRER field.
	UDPHS_EPTCTLENB2_ISOENDPT_TXRDY_TRER_Pos = 0xb
	// Bit mask of TXRDY_TRER field.
	UDPHS_EPTCTLENB2_ISOENDPT_TXRDY_TRER_Msk = 0x800
	// Bit TXRDY_TRER.
	UDPHS_EPTCTLENB2_ISOENDPT_TXRDY_TRER = 0x800
	// Position of ERR_FL_ISO field.
	UDPHS_EPTCTLENB2_ISOENDPT_ERR_FL_ISO_Pos = 0xc
	// Bit mask of ERR_FL_ISO field.
	UDPHS_EPTCTLENB2_ISOENDPT_ERR_FL_ISO_Msk = 0x1000
	// Bit ERR_FL_ISO.
	UDPHS_EPTCTLENB2_ISOENDPT_ERR_FL_ISO = 0x1000
	// Position of ERR_CRC_NTR field.
	UDPHS_EPTCTLENB2_ISOENDPT_ERR_CRC_NTR_Pos = 0xd
	// Bit mask of ERR_CRC_NTR field.
	UDPHS_EPTCTLENB2_ISOENDPT_ERR_CRC_NTR_Msk = 0x2000
	// Bit ERR_CRC_NTR.
	UDPHS_EPTCTLENB2_ISOENDPT_ERR_CRC_NTR = 0x2000
	// Position of ERR_FLUSH field.
	UDPHS_EPTCTLENB2_ISOENDPT_ERR_FLUSH_Pos = 0xe
	// Bit mask of ERR_FLUSH field.
	UDPHS_EPTCTLENB2_ISOENDPT_ERR_FLUSH_Msk = 0x4000
	// Bit ERR_FLUSH.
	UDPHS_EPTCTLENB2_ISOENDPT_ERR_FLUSH = 0x4000
	// Position of BUSY_BANK field.
	UDPHS_EPTCTLENB2_ISOENDPT_BUSY_BANK_Pos = 0x12
	// Bit mask of BUSY_BANK field.
	UDPHS_EPTCTLENB2_ISOENDPT_BUSY_BANK_Msk = 0x40000
	// Bit BUSY_BANK.
	UDPHS_EPTCTLENB2_ISOENDPT_BUSY_BANK = 0x40000
	// Position of SHRT_PCKT field.
	UDPHS_EPTCTLENB2_ISOENDPT_SHRT_PCKT_Pos = 0x1f
	// Bit mask of SHRT_PCKT field.
	UDPHS_EPTCTLENB2_ISOENDPT_SHRT_PCKT_Msk = 0x80000000
	// Bit SHRT_PCKT.
	UDPHS_EPTCTLENB2_ISOENDPT_SHRT_PCKT = 0x80000000

	// EPTCTLDIS2: UDPHS Endpoint Control Disable Register (endpoint = 2)
	// Position of EPT_DISABL field.
	UDPHS_EPTCTLDIS2_EPT_DISABL_Pos = 0x0
	// Bit mask of EPT_DISABL field.
	UDPHS_EPTCTLDIS2_EPT_DISABL_Msk = 0x1
	// Bit EPT_DISABL.
	UDPHS_EPTCTLDIS2_EPT_DISABL = 0x1
	// Position of AUTO_VALID field.
	UDPHS_EPTCTLDIS2_AUTO_VALID_Pos = 0x1
	// Bit mask of AUTO_VALID field.
	UDPHS_EPTCTLDIS2_AUTO_VALID_Msk = 0x2
	// Bit AUTO_VALID.
	UDPHS_EPTCTLDIS2_AUTO_VALID = 0x2
	// Position of INTDIS_DMA field.
	UDPHS_EPTCTLDIS2_INTDIS_DMA_Pos = 0x3
	// Bit mask of INTDIS_DMA field.
	UDPHS_EPTCTLDIS2_INTDIS_DMA_Msk = 0x8
	// Bit INTDIS_DMA.
	UDPHS_EPTCTLDIS2_INTDIS_DMA = 0x8
	// Position of NYET_DIS field.
	UDPHS_EPTCTLDIS2_NYET_DIS_Pos = 0x4
	// Bit mask of NYET_DIS field.
	UDPHS_EPTCTLDIS2_NYET_DIS_Msk = 0x10
	// Bit NYET_DIS.
	UDPHS_EPTCTLDIS2_NYET_DIS = 0x10
	// Position of ERR_OVFLW field.
	UDPHS_EPTCTLDIS2_ERR_OVFLW_Pos = 0x8
	// Bit mask of ERR_OVFLW field.
	UDPHS_EPTCTLDIS2_ERR_OVFLW_Msk = 0x100
	// Bit ERR_OVFLW.
	UDPHS_EPTCTLDIS2_ERR_OVFLW = 0x100
	// Position of RXRDY_TXKL field.
	UDPHS_EPTCTLDIS2_RXRDY_TXKL_Pos = 0x9
	// Bit mask of RXRDY_TXKL field.
	UDPHS_EPTCTLDIS2_RXRDY_TXKL_Msk = 0x200
	// Bit RXRDY_TXKL.
	UDPHS_EPTCTLDIS2_RXRDY_TXKL = 0x200
	// Position of TX_COMPLT field.
	UDPHS_EPTCTLDIS2_TX_COMPLT_Pos = 0xa
	// Bit mask of TX_COMPLT field.
	UDPHS_EPTCTLDIS2_TX_COMPLT_Msk = 0x400
	// Bit TX_COMPLT.
	UDPHS_EPTCTLDIS2_TX_COMPLT = 0x400
	// Position of TXRDY field.
	UDPHS_EPTCTLDIS2_TXRDY_Pos = 0xb
	// Bit mask of TXRDY field.
	UDPHS_EPTCTLDIS2_TXRDY_Msk = 0x800
	// Bit TXRDY.
	UDPHS_EPTCTLDIS2_TXRDY = 0x800
	// Position of RX_SETUP field.
	UDPHS_EPTCTLDIS2_RX_SETUP_Pos = 0xc
	// Bit mask of RX_SETUP field.
	UDPHS_EPTCTLDIS2_RX_SETUP_Msk = 0x1000
	// Bit RX_SETUP.
	UDPHS_EPTCTLDIS2_RX_SETUP = 0x1000
	// Position of STALL_SNT field.
	UDPHS_EPTCTLDIS2_STALL_SNT_Pos = 0xd
	// Bit mask of STALL_SNT field.
	UDPHS_EPTCTLDIS2_STALL_SNT_Msk = 0x2000
	// Bit STALL_SNT.
	UDPHS_EPTCTLDIS2_STALL_SNT = 0x2000
	// Position of NAK_IN field.
	UDPHS_EPTCTLDIS2_NAK_IN_Pos = 0xe
	// Bit mask of NAK_IN field.
	UDPHS_EPTCTLDIS2_NAK_IN_Msk = 0x4000
	// Bit NAK_IN.
	UDPHS_EPTCTLDIS2_NAK_IN = 0x4000
	// Position of NAK_OUT field.
	UDPHS_EPTCTLDIS2_NAK_OUT_Pos = 0xf
	// Bit mask of NAK_OUT field.
	UDPHS_EPTCTLDIS2_NAK_OUT_Msk = 0x8000
	// Bit NAK_OUT.
	UDPHS_EPTCTLDIS2_NAK_OUT = 0x8000
	// Position of BUSY_BANK field.
	UDPHS_EPTCTLDIS2_BUSY_BANK_Pos = 0x12
	// Bit mask of BUSY_BANK field.
	UDPHS_EPTCTLDIS2_BUSY_BANK_Msk = 0x40000
	// Bit BUSY_BANK.
	UDPHS_EPTCTLDIS2_BUSY_BANK = 0x40000
	// Position of SHRT_PCKT field.
	UDPHS_EPTCTLDIS2_SHRT_PCKT_Pos = 0x1f
	// Bit mask of SHRT_PCKT field.
	UDPHS_EPTCTLDIS2_SHRT_PCKT_Msk = 0x80000000
	// Bit SHRT_PCKT.
	UDPHS_EPTCTLDIS2_SHRT_PCKT = 0x80000000

	// EPTCTLDIS2_ISOENDPT: UDPHS Endpoint Control Disable Register (endpoint = 2)
	// Position of EPT_DISABL field.
	UDPHS_EPTCTLDIS2_ISOENDPT_EPT_DISABL_Pos = 0x0
	// Bit mask of EPT_DISABL field.
	UDPHS_EPTCTLDIS2_ISOENDPT_EPT_DISABL_Msk = 0x1
	// Bit EPT_DISABL.
	UDPHS_EPTCTLDIS2_ISOENDPT_EPT_DISABL = 0x1
	// Position of AUTO_VALID field.
	UDPHS_EPTCTLDIS2_ISOENDPT_AUTO_VALID_Pos = 0x1
	// Bit mask of AUTO_VALID field.
	UDPHS_EPTCTLDIS2_ISOENDPT_AUTO_VALID_Msk = 0x2
	// Bit AUTO_VALID.
	UDPHS_EPTCTLDIS2_ISOENDPT_AUTO_VALID = 0x2
	// Position of INTDIS_DMA field.
	UDPHS_EPTCTLDIS2_ISOENDPT_INTDIS_DMA_Pos = 0x3
	// Bit mask of INTDIS_DMA field.
	UDPHS_EPTCTLDIS2_ISOENDPT_INTDIS_DMA_Msk = 0x8
	// Bit INTDIS_DMA.
	UDPHS_EPTCTLDIS2_ISOENDPT_INTDIS_DMA = 0x8
	// Position of DATAX_RX field.
	UDPHS_EPTCTLDIS2_ISOENDPT_DATAX_RX_Pos = 0x6
	// Bit mask of DATAX_RX field.
	UDPHS_EPTCTLDIS2_ISOENDPT_DATAX_RX_Msk = 0x40
	// Bit DATAX_RX.
	UDPHS_EPTCTLDIS2_ISOENDPT_DATAX_RX = 0x40
	// Position of MDATA_RX field.
	UDPHS_EPTCTLDIS2_ISOENDPT_MDATA_RX_Pos = 0x7
	// Bit mask of MDATA_RX field.
	UDPHS_EPTCTLDIS2_ISOENDPT_MDATA_RX_Msk = 0x80
	// Bit MDATA_RX.
	UDPHS_EPTCTLDIS2_ISOENDPT_MDATA_RX = 0x80
	// Position of ERR_OVFLW field.
	UDPHS_EPTCTLDIS2_ISOENDPT_ERR_OVFLW_Pos = 0x8
	// Bit mask of ERR_OVFLW field.
	UDPHS_EPTCTLDIS2_ISOENDPT_ERR_OVFLW_Msk = 0x100
	// Bit ERR_OVFLW.
	UDPHS_EPTCTLDIS2_ISOENDPT_ERR_OVFLW = 0x100
	// Position of RXRDY_TXKL field.
	UDPHS_EPTCTLDIS2_ISOENDPT_RXRDY_TXKL_Pos = 0x9
	// Bit mask of RXRDY_TXKL field.
	UDPHS_EPTCTLDIS2_ISOENDPT_RXRDY_TXKL_Msk = 0x200
	// Bit RXRDY_TXKL.
	UDPHS_EPTCTLDIS2_ISOENDPT_RXRDY_TXKL = 0x200
	// Position of TX_COMPLT field.
	UDPHS_EPTCTLDIS2_ISOENDPT_TX_COMPLT_Pos = 0xa
	// Bit mask of TX_COMPLT field.
	UDPHS_EPTCTLDIS2_ISOENDPT_TX_COMPLT_Msk = 0x400
	// Bit TX_COMPLT.
	UDPHS_EPTCTLDIS2_ISOENDPT_TX_COMPLT = 0x400
	// Position of TXRDY_TRER field.
	UDPHS_EPTCTLDIS2_ISOENDPT_TXRDY_TRER_Pos = 0xb
	// Bit mask of TXRDY_TRER field.
	UDPHS_EPTCTLDIS2_ISOENDPT_TXRDY_TRER_Msk = 0x800
	// Bit TXRDY_TRER.
	UDPHS_EPTCTLDIS2_ISOENDPT_TXRDY_TRER = 0x800
	// Position of ERR_FL_ISO field.
	UDPHS_EPTCTLDIS2_ISOENDPT_ERR_FL_ISO_Pos = 0xc
	// Bit mask of ERR_FL_ISO field.
	UDPHS_EPTCTLDIS2_ISOENDPT_ERR_FL_ISO_Msk = 0x1000
	// Bit ERR_FL_ISO.
	UDPHS_EPTCTLDIS2_ISOENDPT_ERR_FL_ISO = 0x1000
	// Position of ERR_CRC_NTR field.
	UDPHS_EPTCTLDIS2_ISOENDPT_ERR_CRC_NTR_Pos = 0xd
	// Bit mask of ERR_CRC_NTR field.
	UDPHS_EPTCTLDIS2_ISOENDPT_ERR_CRC_NTR_Msk = 0x2000
	// Bit ERR_CRC_NTR.
	UDPHS_EPTCTLDIS2_ISOENDPT_ERR_CRC_NTR = 0x2000
	// Position of ERR_FLUSH field.
	UDPHS_EPTCTLDIS2_ISOENDPT_ERR_FLUSH_Pos = 0xe
	// Bit mask of ERR_FLUSH field.
	UDPHS_EPTCTLDIS2_ISOENDPT_ERR_FLUSH_Msk = 0x4000
	// Bit ERR_FLUSH.
	UDPHS_EPTCTLDIS2_ISOENDPT_ERR_FLUSH = 0x4000
	// Position of BUSY_BANK field.
	UDPHS_EPTCTLDIS2_ISOENDPT_BUSY_BANK_Pos = 0x12
	// Bit mask of BUSY_BANK field.
	UDPHS_EPTCTLDIS2_ISOENDPT_BUSY_BANK_Msk = 0x40000
	// Bit BUSY_BANK.
	UDPHS_EPTCTLDIS2_ISOENDPT_BUSY_BANK = 0x40000
	// Position of SHRT_PCKT field.
	UDPHS_EPTCTLDIS2_ISOENDPT_SHRT_PCKT_Pos = 0x1f
	// Bit mask of SHRT_PCKT field.
	UDPHS_EPTCTLDIS2_ISOENDPT_SHRT_PCKT_Msk = 0x80000000
	// Bit SHRT_PCKT.
	UDPHS_EPTCTLDIS2_ISOENDPT_SHRT_PCKT = 0x80000000

	// EPTCTL2: UDPHS Endpoint Control Register (endpoint = 2)
	// Position of EPT_ENABL field.
	UDPHS_EPTCTL2_EPT_ENABL_Pos = 0x0
	// Bit mask of EPT_ENABL field.
	UDPHS_EPTCTL2_EPT_ENABL_Msk = 0x1
	// Bit EPT_ENABL.
	UDPHS_EPTCTL2_EPT_ENABL = 0x1
	// Position of AUTO_VALID field.
	UDPHS_EPTCTL2_AUTO_VALID_Pos = 0x1
	// Bit mask of AUTO_VALID field.
	UDPHS_EPTCTL2_AUTO_VALID_Msk = 0x2
	// Bit AUTO_VALID.
	UDPHS_EPTCTL2_AUTO_VALID = 0x2
	// Position of INTDIS_DMA field.
	UDPHS_EPTCTL2_INTDIS_DMA_Pos = 0x3
	// Bit mask of INTDIS_DMA field.
	UDPHS_EPTCTL2_INTDIS_DMA_Msk = 0x8
	// Bit INTDIS_DMA.
	UDPHS_EPTCTL2_INTDIS_DMA = 0x8
	// Position of NYET_DIS field.
	UDPHS_EPTCTL2_NYET_DIS_Pos = 0x4
	// Bit mask of NYET_DIS field.
	UDPHS_EPTCTL2_NYET_DIS_Msk = 0x10
	// Bit NYET_DIS.
	UDPHS_EPTCTL2_NYET_DIS = 0x10
	// Position of ERR_OVFLW field.
	UDPHS_EPTCTL2_ERR_OVFLW_Pos = 0x8
	// Bit mask of ERR_OVFLW field.
	UDPHS_EPTCTL2_ERR_OVFLW_Msk = 0x100
	// Bit ERR_OVFLW.
	UDPHS_EPTCTL2_ERR_OVFLW = 0x100
	// Position of RXRDY_TXKL field.
	UDPHS_EPTCTL2_RXRDY_TXKL_Pos = 0x9
	// Bit mask of RXRDY_TXKL field.
	UDPHS_EPTCTL2_RXRDY_TXKL_Msk = 0x200
	// Bit RXRDY_TXKL.
	UDPHS_EPTCTL2_RXRDY_TXKL = 0x200
	// Position of TX_COMPLT field.
	UDPHS_EPTCTL2_TX_COMPLT_Pos = 0xa
	// Bit mask of TX_COMPLT field.
	UDPHS_EPTCTL2_TX_COMPLT_Msk = 0x400
	// Bit TX_COMPLT.
	UDPHS_EPTCTL2_TX_COMPLT = 0x400
	// Position of TXRDY field.
	UDPHS_EPTCTL2_TXRDY_Pos = 0xb
	// Bit mask of TXRDY field.
	UDPHS_EPTCTL2_TXRDY_Msk = 0x800
	// Bit TXRDY.
	UDPHS_EPTCTL2_TXRDY = 0x800
	// Position of RX_SETUP field.
	UDPHS_EPTCTL2_RX_SETUP_Pos = 0xc
	// Bit mask of RX_SETUP field.
	UDPHS_EPTCTL2_RX_SETUP_Msk = 0x1000
	// Bit RX_SETUP.
	UDPHS_EPTCTL2_RX_SETUP = 0x1000
	// Position of STALL_SNT field.
	UDPHS_EPTCTL2_STALL_SNT_Pos = 0xd
	// Bit mask of STALL_SNT field.
	UDPHS_EPTCTL2_STALL_SNT_Msk = 0x2000
	// Bit STALL_SNT.
	UDPHS_EPTCTL2_STALL_SNT = 0x2000
	// Position of NAK_IN field.
	UDPHS_EPTCTL2_NAK_IN_Pos = 0xe
	// Bit mask of NAK_IN field.
	UDPHS_EPTCTL2_NAK_IN_Msk = 0x4000
	// Bit NAK_IN.
	UDPHS_EPTCTL2_NAK_IN = 0x4000
	// Position of NAK_OUT field.
	UDPHS_EPTCTL2_NAK_OUT_Pos = 0xf
	// Bit mask of NAK_OUT field.
	UDPHS_EPTCTL2_NAK_OUT_Msk = 0x8000
	// Bit NAK_OUT.
	UDPHS_EPTCTL2_NAK_OUT = 0x8000
	// Position of BUSY_BANK field.
	UDPHS_EPTCTL2_BUSY_BANK_Pos = 0x12
	// Bit mask of BUSY_BANK field.
	UDPHS_EPTCTL2_BUSY_BANK_Msk = 0x40000
	// Bit BUSY_BANK.
	UDPHS_EPTCTL2_BUSY_BANK = 0x40000
	// Position of SHRT_PCKT field.
	UDPHS_EPTCTL2_SHRT_PCKT_Pos = 0x1f
	// Bit mask of SHRT_PCKT field.
	UDPHS_EPTCTL2_SHRT_PCKT_Msk = 0x80000000
	// Bit SHRT_PCKT.
	UDPHS_EPTCTL2_SHRT_PCKT = 0x80000000

	// EPTCTL2_ISOENDPT: UDPHS Endpoint Control Register (endpoint = 2)
	// Position of EPT_ENABL field.
	UDPHS_EPTCTL2_ISOENDPT_EPT_ENABL_Pos = 0x0
	// Bit mask of EPT_ENABL field.
	UDPHS_EPTCTL2_ISOENDPT_EPT_ENABL_Msk = 0x1
	// Bit EPT_ENABL.
	UDPHS_EPTCTL2_ISOENDPT_EPT_ENABL = 0x1
	// Position of AUTO_VALID field.
	UDPHS_EPTCTL2_ISOENDPT_AUTO_VALID_Pos = 0x1
	// Bit mask of AUTO_VALID field.
	UDPHS_EPTCTL2_ISOENDPT_AUTO_VALID_Msk = 0x2
	// Bit AUTO_VALID.
	UDPHS_EPTCTL2_ISOENDPT_AUTO_VALID = 0x2
	// Position of INTDIS_DMA field.
	UDPHS_EPTCTL2_ISOENDPT_INTDIS_DMA_Pos = 0x3
	// Bit mask of INTDIS_DMA field.
	UDPHS_EPTCTL2_ISOENDPT_INTDIS_DMA_Msk = 0x8
	// Bit INTDIS_DMA.
	UDPHS_EPTCTL2_ISOENDPT_INTDIS_DMA = 0x8
	// Position of DATAX_RX field.
	UDPHS_EPTCTL2_ISOENDPT_DATAX_RX_Pos = 0x6
	// Bit mask of DATAX_RX field.
	UDPHS_EPTCTL2_ISOENDPT_DATAX_RX_Msk = 0x40
	// Bit DATAX_RX.
	UDPHS_EPTCTL2_ISOENDPT_DATAX_RX = 0x40
	// Position of MDATA_RX field.
	UDPHS_EPTCTL2_ISOENDPT_MDATA_RX_Pos = 0x7
	// Bit mask of MDATA_RX field.
	UDPHS_EPTCTL2_ISOENDPT_MDATA_RX_Msk = 0x80
	// Bit MDATA_RX.
	UDPHS_EPTCTL2_ISOENDPT_MDATA_RX = 0x80
	// Position of ERR_OVFLW field.
	UDPHS_EPTCTL2_ISOENDPT_ERR_OVFLW_Pos = 0x8
	// Bit mask of ERR_OVFLW field.
	UDPHS_EPTCTL2_ISOENDPT_ERR_OVFLW_Msk = 0x100
	// Bit ERR_OVFLW.
	UDPHS_EPTCTL2_ISOENDPT_ERR_OVFLW = 0x100
	// Position of RXRDY_TXKL field.
	UDPHS_EPTCTL2_ISOENDPT_RXRDY_TXKL_Pos = 0x9
	// Bit mask of RXRDY_TXKL field.
	UDPHS_EPTCTL2_ISOENDPT_RXRDY_TXKL_Msk = 0x200
	// Bit RXRDY_TXKL.
	UDPHS_EPTCTL2_ISOENDPT_RXRDY_TXKL = 0x200
	// Position of TX_COMPLT field.
	UDPHS_EPTCTL2_ISOENDPT_TX_COMPLT_Pos = 0xa
	// Bit mask of TX_COMPLT field.
	UDPHS_EPTCTL2_ISOENDPT_TX_COMPLT_Msk = 0x400
	// Bit TX_COMPLT.
	UDPHS_EPTCTL2_ISOENDPT_TX_COMPLT = 0x400
	// Position of TXRDY_TRER field.
	UDPHS_EPTCTL2_ISOENDPT_TXRDY_TRER_Pos = 0xb
	// Bit mask of TXRDY_TRER field.
	UDPHS_EPTCTL2_ISOENDPT_TXRDY_TRER_Msk = 0x800
	// Bit TXRDY_TRER.
	UDPHS_EPTCTL2_ISOENDPT_TXRDY_TRER = 0x800
	// Position of ERR_FL_ISO field.
	UDPHS_EPTCTL2_ISOENDPT_ERR_FL_ISO_Pos = 0xc
	// Bit mask of ERR_FL_ISO field.
	UDPHS_EPTCTL2_ISOENDPT_ERR_FL_ISO_Msk = 0x1000
	// Bit ERR_FL_ISO.
	UDPHS_EPTCTL2_ISOENDPT_ERR_FL_ISO = 0x1000
	// Position of ERR_CRC_NTR field.
	UDPHS_EPTCTL2_ISOENDPT_ERR_CRC_NTR_Pos = 0xd
	// Bit mask of ERR_CRC_NTR field.
	UDPHS_EPTCTL2_ISOENDPT_ERR_CRC_NTR_Msk = 0x2000
	// Bit ERR_CRC_NTR.
	UDPHS_EPTCTL2_ISOENDPT_ERR_CRC_NTR = 0x2000
	// Position of ERR_FLUSH field.
	UDPHS_EPTCTL2_ISOENDPT_ERR_FLUSH_Pos = 0xe
	// Bit mask of ERR_FLUSH field.
	UDPHS_EPTCTL2_ISOENDPT_ERR_FLUSH_Msk = 0x4000
	// Bit ERR_FLUSH.
	UDPHS_EPTCTL2_ISOENDPT_ERR_FLUSH = 0x4000
	// Position of BUSY_BANK field.
	UDPHS_EPTCTL2_ISOENDPT_BUSY_BANK_Pos = 0x12
	// Bit mask of BUSY_BANK field.
	UDPHS_EPTCTL2_ISOENDPT_BUSY_BANK_Msk = 0x40000
	// Bit BUSY_BANK.
	UDPHS_EPTCTL2_ISOENDPT_BUSY_BANK = 0x40000
	// Position of SHRT_PCKT field.
	UDPHS_EPTCTL2_ISOENDPT_SHRT_PCKT_Pos = 0x1f
	// Bit mask of SHRT_PCKT field.
	UDPHS_EPTCTL2_ISOENDPT_SHRT_PCKT_Msk = 0x80000000
	// Bit SHRT_PCKT.
	UDPHS_EPTCTL2_ISOENDPT_SHRT_PCKT = 0x80000000

	// EPTSETSTA2: UDPHS Endpoint Set Status Register (endpoint = 2)
	// Position of FRCESTALL field.
	UDPHS_EPTSETSTA2_FRCESTALL_Pos = 0x5
	// Bit mask of FRCESTALL field.
	UDPHS_EPTSETSTA2_FRCESTALL_Msk = 0x20
	// Bit FRCESTALL.
	UDPHS_EPTSETSTA2_FRCESTALL = 0x20
	// Position of RXRDY_TXKL field.
	UDPHS_EPTSETSTA2_RXRDY_TXKL_Pos = 0x9
	// Bit mask of RXRDY_TXKL field.
	UDPHS_EPTSETSTA2_RXRDY_TXKL_Msk = 0x200
	// Bit RXRDY_TXKL.
	UDPHS_EPTSETSTA2_RXRDY_TXKL = 0x200
	// Position of TXRDY field.
	UDPHS_EPTSETSTA2_TXRDY_Pos = 0xb
	// Bit mask of TXRDY field.
	UDPHS_EPTSETSTA2_TXRDY_Msk = 0x800
	// Bit TXRDY.
	UDPHS_EPTSETSTA2_TXRDY = 0x800

	// EPTSETSTA2_ISOENDPT: UDPHS Endpoint Set Status Register (endpoint = 2)
	// Position of RXRDY_TXKL field.
	UDPHS_EPTSETSTA2_ISOENDPT_RXRDY_TXKL_Pos = 0x9
	// Bit mask of RXRDY_TXKL field.
	UDPHS_EPTSETSTA2_ISOENDPT_RXRDY_TXKL_Msk = 0x200
	// Bit RXRDY_TXKL.
	UDPHS_EPTSETSTA2_ISOENDPT_RXRDY_TXKL = 0x200
	// Position of TXRDY_TRER field.
	UDPHS_EPTSETSTA2_ISOENDPT_TXRDY_TRER_Pos = 0xb
	// Bit mask of TXRDY_TRER field.
	UDPHS_EPTSETSTA2_ISOENDPT_TXRDY_TRER_Msk = 0x800
	// Bit TXRDY_TRER.
	UDPHS_EPTSETSTA2_ISOENDPT_TXRDY_TRER = 0x800

	// EPTCLRSTA2: UDPHS Endpoint Clear Status Register (endpoint = 2)
	// Position of FRCESTALL field.
	UDPHS_EPTCLRSTA2_FRCESTALL_Pos = 0x5
	// Bit mask of FRCESTALL field.
	UDPHS_EPTCLRSTA2_FRCESTALL_Msk = 0x20
	// Bit FRCESTALL.
	UDPHS_EPTCLRSTA2_FRCESTALL = 0x20
	// Position of TOGGLESQ field.
	UDPHS_EPTCLRSTA2_TOGGLESQ_Pos = 0x6
	// Bit mask of TOGGLESQ field.
	UDPHS_EPTCLRSTA2_TOGGLESQ_Msk = 0x40
	// Bit TOGGLESQ.
	UDPHS_EPTCLRSTA2_TOGGLESQ = 0x40
	// Position of RXRDY_TXKL field.
	UDPHS_EPTCLRSTA2_RXRDY_TXKL_Pos = 0x9
	// Bit mask of RXRDY_TXKL field.
	UDPHS_EPTCLRSTA2_RXRDY_TXKL_Msk = 0x200
	// Bit RXRDY_TXKL.
	UDPHS_EPTCLRSTA2_RXRDY_TXKL = 0x200
	// Position of TX_COMPLT field.
	UDPHS_EPTCLRSTA2_TX_COMPLT_Pos = 0xa
	// Bit mask of TX_COMPLT field.
	UDPHS_EPTCLRSTA2_TX_COMPLT_Msk = 0x400
	// Bit TX_COMPLT.
	UDPHS_EPTCLRSTA2_TX_COMPLT = 0x400
	// Position of RX_SETUP field.
	UDPHS_EPTCLRSTA2_RX_SETUP_Pos = 0xc
	// Bit mask of RX_SETUP field.
	UDPHS_EPTCLRSTA2_RX_SETUP_Msk = 0x1000
	// Bit RX_SETUP.
	UDPHS_EPTCLRSTA2_RX_SETUP = 0x1000
	// Position of STALL_SNT field.
	UDPHS_EPTCLRSTA2_STALL_SNT_Pos = 0xd
	// Bit mask of STALL_SNT field.
	UDPHS_EPTCLRSTA2_STALL_SNT_Msk = 0x2000
	// Bit STALL_SNT.
	UDPHS_EPTCLRSTA2_STALL_SNT = 0x2000
	// Position of NAK_IN field.
	UDPHS_EPTCLRSTA2_NAK_IN_Pos = 0xe
	// Bit mask of NAK_IN field.
	UDPHS_EPTCLRSTA2_NAK_IN_Msk = 0x4000
	// Bit NAK_IN.
	UDPHS_EPTCLRSTA2_NAK_IN = 0x4000
	// Position of NAK_OUT field.
	UDPHS_EPTCLRSTA2_NAK_OUT_Pos = 0xf
	// Bit mask of NAK_OUT field.
	UDPHS_EPTCLRSTA2_NAK_OUT_Msk = 0x8000
	// Bit NAK_OUT.
	UDPHS_EPTCLRSTA2_NAK_OUT = 0x8000

	// EPTCLRSTA2_ISOENDPT: UDPHS Endpoint Clear Status Register (endpoint = 2)
	// Position of TOGGLESQ field.
	UDPHS_EPTCLRSTA2_ISOENDPT_TOGGLESQ_Pos = 0x6
	// Bit mask of TOGGLESQ field.
	UDPHS_EPTCLRSTA2_ISOENDPT_TOGGLESQ_Msk = 0x40
	// Bit TOGGLESQ.
	UDPHS_EPTCLRSTA2_ISOENDPT_TOGGLESQ = 0x40
	// Position of RXRDY_TXKL field.
	UDPHS_EPTCLRSTA2_ISOENDPT_RXRDY_TXKL_Pos = 0x9
	// Bit mask of RXRDY_TXKL field.
	UDPHS_EPTCLRSTA2_ISOENDPT_RXRDY_TXKL_Msk = 0x200
	// Bit RXRDY_TXKL.
	UDPHS_EPTCLRSTA2_ISOENDPT_RXRDY_TXKL = 0x200
	// Position of TX_COMPLT field.
	UDPHS_EPTCLRSTA2_ISOENDPT_TX_COMPLT_Pos = 0xa
	// Bit mask of TX_COMPLT field.
	UDPHS_EPTCLRSTA2_ISOENDPT_TX_COMPLT_Msk = 0x400
	// Bit TX_COMPLT.
	UDPHS_EPTCLRSTA2_ISOENDPT_TX_COMPLT = 0x400
	// Position of ERR_FL_ISO field.
	UDPHS_EPTCLRSTA2_ISOENDPT_ERR_FL_ISO_Pos = 0xc
	// Bit mask of ERR_FL_ISO field.
	UDPHS_EPTCLRSTA2_ISOENDPT_ERR_FL_ISO_Msk = 0x1000
	// Bit ERR_FL_ISO.
	UDPHS_EPTCLRSTA2_ISOENDPT_ERR_FL_ISO = 0x1000
	// Position of ERR_CRC_NTR field.
	UDPHS_EPTCLRSTA2_ISOENDPT_ERR_CRC_NTR_Pos = 0xd
	// Bit mask of ERR_CRC_NTR field.
	UDPHS_EPTCLRSTA2_ISOENDPT_ERR_CRC_NTR_Msk = 0x2000
	// Bit ERR_CRC_NTR.
	UDPHS_EPTCLRSTA2_ISOENDPT_ERR_CRC_NTR = 0x2000
	// Position of ERR_FLUSH field.
	UDPHS_EPTCLRSTA2_ISOENDPT_ERR_FLUSH_Pos = 0xe
	// Bit mask of ERR_FLUSH field.
	UDPHS_EPTCLRSTA2_ISOENDPT_ERR_FLUSH_Msk = 0x4000
	// Bit ERR_FLUSH.
	UDPHS_EPTCLRSTA2_ISOENDPT_ERR_FLUSH = 0x4000

	// EPTSTA2: UDPHS Endpoint Status Register (endpoint = 2)
	// Position of FRCESTALL field.
	UDPHS_EPTSTA2_FRCESTALL_Pos = 0x5
	// Bit mask of FRCESTALL field.
	UDPHS_EPTSTA2_FRCESTALL_Msk = 0x20
	// Bit FRCESTALL.
	UDPHS_EPTSTA2_FRCESTALL = 0x20
	// Position of TOGGLESQ_STA field.
	UDPHS_EPTSTA2_TOGGLESQ_STA_Pos = 0x6
	// Bit mask of TOGGLESQ_STA field.
	UDPHS_EPTSTA2_TOGGLESQ_STA_Msk = 0xc0
	// DATA0
	UDPHS_EPTSTA2_TOGGLESQ_STA_DATA0 = 0x0
	// DATA1
	UDPHS_EPTSTA2_TOGGLESQ_STA_DATA1 = 0x1
	// Reserved for High Bandwidth Isochronous Endpoint
	UDPHS_EPTSTA2_TOGGLESQ_STA_DATA2 = 0x2
	// Reserved for High Bandwidth Isochronous Endpoint
	UDPHS_EPTSTA2_TOGGLESQ_STA_MDATA = 0x3
	// Position of ERR_OVFLW field.
	UDPHS_EPTSTA2_ERR_OVFLW_Pos = 0x8
	// Bit mask of ERR_OVFLW field.
	UDPHS_EPTSTA2_ERR_OVFLW_Msk = 0x100
	// Bit ERR_OVFLW.
	UDPHS_EPTSTA2_ERR_OVFLW = 0x100
	// Position of RXRDY_TXKL field.
	UDPHS_EPTSTA2_RXRDY_TXKL_Pos = 0x9
	// Bit mask of RXRDY_TXKL field.
	UDPHS_EPTSTA2_RXRDY_TXKL_Msk = 0x200
	// Bit RXRDY_TXKL.
	UDPHS_EPTSTA2_RXRDY_TXKL = 0x200
	// Position of TX_COMPLT field.
	UDPHS_EPTSTA2_TX_COMPLT_Pos = 0xa
	// Bit mask of TX_COMPLT field.
	UDPHS_EPTSTA2_TX_COMPLT_Msk = 0x400
	// Bit TX_COMPLT.
	UDPHS_EPTSTA2_TX_COMPLT = 0x400
	// Position of TXRDY field.
	UDPHS_EPTSTA2_TXRDY_Pos = 0xb
	// Bit mask of TXRDY field.
	UDPHS_EPTSTA2_TXRDY_Msk = 0x800
	// Bit TXRDY.
	UDPHS_EPTSTA2_TXRDY = 0x800
	// Position of RX_SETUP field.
	UDPHS_EPTSTA2_RX_SETUP_Pos = 0xc
	// Bit mask of RX_SETUP field.
	UDPHS_EPTSTA2_RX_SETUP_Msk = 0x1000
	// Bit RX_SETUP.
	UDPHS_EPTSTA2_RX_SETUP = 0x1000
	// Position of STALL_SNT field.
	UDPHS_EPTSTA2_STALL_SNT_Pos = 0xd
	// Bit mask of STALL_SNT field.
	UDPHS_EPTSTA2_STALL_SNT_Msk = 0x2000
	// Bit STALL_SNT.
	UDPHS_EPTSTA2_STALL_SNT = 0x2000
	// Position of NAK_IN field.
	UDPHS_EPTSTA2_NAK_IN_Pos = 0xe
	// Bit mask of NAK_IN field.
	UDPHS_EPTSTA2_NAK_IN_Msk = 0x4000
	// Bit NAK_IN.
	UDPHS_EPTSTA2_NAK_IN = 0x4000
	// Position of NAK_OUT field.
	UDPHS_EPTSTA2_NAK_OUT_Pos = 0xf
	// Bit mask of NAK_OUT field.
	UDPHS_EPTSTA2_NAK_OUT_Msk = 0x8000
	// Bit NAK_OUT.
	UDPHS_EPTSTA2_NAK_OUT = 0x8000
	// Position of CURBK_CTLDIR field.
	UDPHS_EPTSTA2_CURBK_CTLDIR_Pos = 0x10
	// Bit mask of CURBK_CTLDIR field.
	UDPHS_EPTSTA2_CURBK_CTLDIR_Msk = 0x30000
	// Position of BUSY_BANK_STA field.
	UDPHS_EPTSTA2_BUSY_BANK_STA_Pos = 0x12
	// Bit mask of BUSY_BANK_STA field.
	UDPHS_EPTSTA2_BUSY_BANK_STA_Msk = 0xc0000
	// 1 busy bank
	UDPHS_EPTSTA2_BUSY_BANK_STA_1BUSYBANK = 0x0
	// 2 busy banks
	UDPHS_EPTSTA2_BUSY_BANK_STA_2BUSYBANKS = 0x1
	// 3 busy banks
	UDPHS_EPTSTA2_BUSY_BANK_STA_3BUSYBANKS = 0x2
	// Position of BYTE_COUNT field.
	UDPHS_EPTSTA2_BYTE_COUNT_Pos = 0x14
	// Bit mask of BYTE_COUNT field.
	UDPHS_EPTSTA2_BYTE_COUNT_Msk = 0x7ff00000
	// Position of SHRT_PCKT field.
	UDPHS_EPTSTA2_SHRT_PCKT_Pos = 0x1f
	// Bit mask of SHRT_PCKT field.
	UDPHS_EPTSTA2_SHRT_PCKT_Msk = 0x80000000
	// Bit SHRT_PCKT.
	UDPHS_EPTSTA2_SHRT_PCKT = 0x80000000

	// EPTSTA2_ISOENDPT: UDPHS Endpoint Status Register (endpoint = 2)
	// Position of TOGGLESQ_STA field.
	UDPHS_EPTSTA2_ISOENDPT_TOGGLESQ_STA_Pos = 0x6
	// Bit mask of TOGGLESQ_STA field.
	UDPHS_EPTSTA2_ISOENDPT_TOGGLESQ_STA_Msk = 0xc0
	// DATA0
	UDPHS_EPTSTA2_ISOENDPT_TOGGLESQ_STA_DATA0 = 0x0
	// DATA1
	UDPHS_EPTSTA2_ISOENDPT_TOGGLESQ_STA_DATA1 = 0x1
	// Data2 (only for High Bandwidth Isochronous Endpoint)
	UDPHS_EPTSTA2_ISOENDPT_TOGGLESQ_STA_DATA2 = 0x2
	// MData (only for High Bandwidth Isochronous Endpoint)
	UDPHS_EPTSTA2_ISOENDPT_TOGGLESQ_STA_MDATA = 0x3
	// Position of ERR_OVFLW field.
	UDPHS_EPTSTA2_ISOENDPT_ERR_OVFLW_Pos = 0x8
	// Bit mask of ERR_OVFLW field.
	UDPHS_EPTSTA2_ISOENDPT_ERR_OVFLW_Msk = 0x100
	// Bit ERR_OVFLW.
	UDPHS_EPTSTA2_ISOENDPT_ERR_OVFLW = 0x100
	// Position of RXRDY_TXKL field.
	UDPHS_EPTSTA2_ISOENDPT_RXRDY_TXKL_Pos = 0x9
	// Bit mask of RXRDY_TXKL field.
	UDPHS_EPTSTA2_ISOENDPT_RXRDY_TXKL_Msk = 0x200
	// Bit RXRDY_TXKL.
	UDPHS_EPTSTA2_ISOENDPT_RXRDY_TXKL = 0x200
	// Position of TX_COMPLT field.
	UDPHS_EPTSTA2_ISOENDPT_TX_COMPLT_Pos = 0xa
	// Bit mask of TX_COMPLT field.
	UDPHS_EPTSTA2_ISOENDPT_TX_COMPLT_Msk = 0x400
	// Bit TX_COMPLT.
	UDPHS_EPTSTA2_ISOENDPT_TX_COMPLT = 0x400
	// Position of TXRDY_TRER field.
	UDPHS_EPTSTA2_ISOENDPT_TXRDY_TRER_Pos = 0xb
	// Bit mask of TXRDY_TRER field.
	UDPHS_EPTSTA2_ISOENDPT_TXRDY_TRER_Msk = 0x800
	// Bit TXRDY_TRER.
	UDPHS_EPTSTA2_ISOENDPT_TXRDY_TRER = 0x800
	// Position of ERR_FL_ISO field.
	UDPHS_EPTSTA2_ISOENDPT_ERR_FL_ISO_Pos = 0xc
	// Bit mask of ERR_FL_ISO field.
	UDPHS_EPTSTA2_ISOENDPT_ERR_FL_ISO_Msk = 0x1000
	// Bit ERR_FL_ISO.
	UDPHS_EPTSTA2_ISOENDPT_ERR_FL_ISO = 0x1000
	// Position of ERR_CRC_NTR field.
	UDPHS_EPTSTA2_ISOENDPT_ERR_CRC_NTR_Pos = 0xd
	// Bit mask of ERR_CRC_NTR field.
	UDPHS_EPTSTA2_ISOENDPT_ERR_CRC_NTR_Msk = 0x2000
	// Bit ERR_CRC_NTR.
	UDPHS_EPTSTA2_ISOENDPT_ERR_CRC_NTR = 0x2000
	// Position of ERR_FLUSH field.
	UDPHS_EPTSTA2_ISOENDPT_ERR_FLUSH_Pos = 0xe
	// Bit mask of ERR_FLUSH field.
	UDPHS_EPTSTA2_ISOENDPT_ERR_FLUSH_Msk = 0x4000
	// Bit ERR_FLUSH.
	UDPHS_EPTSTA2_ISOENDPT_ERR_FLUSH = 0x4000
	// Position of CURBK field.
	UDPHS_EPTSTA2_ISOENDPT_CURBK_Pos = 0x10
	// Bit mask of CURBK field.
	UDPHS_EPTSTA2_ISOENDPT_CURBK_Msk = 0x30000
	// Bank 0 (or single bank)
	UDPHS_EPTSTA2_ISOENDPT_CURBK_BANK0 = 0x0
	// Bank 1
	UDPHS_EPTSTA2_ISOENDPT_CURBK_BANK1 = 0x1
	// Bank 2
	UDPHS_EPTSTA2_ISOENDPT_CURBK_BANK2 = 0x2
	// Position of BUSY_BANK_STA field.
	UDPHS_EPTSTA2_ISOENDPT_BUSY_BANK_STA_Pos = 0x12
	// Bit mask of BUSY_BANK_STA field.
	UDPHS_EPTSTA2_ISOENDPT_BUSY_BANK_STA_Msk = 0xc0000
	// 1 busy bank
	UDPHS_EPTSTA2_ISOENDPT_BUSY_BANK_STA_1BUSYBANK = 0x0
	// 2 busy banks
	UDPHS_EPTSTA2_ISOENDPT_BUSY_BANK_STA_2BUSYBANKS = 0x1
	// 3 busy banks
	UDPHS_EPTSTA2_ISOENDPT_BUSY_BANK_STA_3BUSYBANKS = 0x2
	// Position of BYTE_COUNT field.
	UDPHS_EPTSTA2_ISOENDPT_BYTE_COUNT_Pos = 0x14
	// Bit mask of BYTE_COUNT field.
	UDPHS_EPTSTA2_ISOENDPT_BYTE_COUNT_Msk = 0x7ff00000
	// Position of SHRT_PCKT field.
	UDPHS_EPTSTA2_ISOENDPT_SHRT_PCKT_Pos = 0x1f
	// Bit mask of SHRT_PCKT field.
	UDPHS_EPTSTA2_ISOENDPT_SHRT_PCKT_Msk = 0x80000000
	// Bit SHRT_PCKT.
	UDPHS_EPTSTA2_ISOENDPT_SHRT_PCKT = 0x80000000

	// EPTCFG3: UDPHS Endpoint Configuration Register (endpoint = 3)
	// Position of EPT_SIZE field.
	UDPHS_EPTCFG3_EPT_SIZE_Pos = 0x0
	// Bit mask of EPT_SIZE field.
	UDPHS_EPTCFG3_EPT_SIZE_Msk = 0x7
	// 8 bytes
	UDPHS_EPTCFG3_EPT_SIZE_8 = 0x0
	// 16 bytes
	UDPHS_EPTCFG3_EPT_SIZE_16 = 0x1
	// 32 bytes
	UDPHS_EPTCFG3_EPT_SIZE_32 = 0x2
	// 64 bytes
	UDPHS_EPTCFG3_EPT_SIZE_64 = 0x3
	// 128 bytes
	UDPHS_EPTCFG3_EPT_SIZE_128 = 0x4
	// 256 bytes
	UDPHS_EPTCFG3_EPT_SIZE_256 = 0x5
	// 512 bytes
	UDPHS_EPTCFG3_EPT_SIZE_512 = 0x6
	// 1024 bytes
	UDPHS_EPTCFG3_EPT_SIZE_1024 = 0x7
	// Position of EPT_DIR field.
	UDPHS_EPTCFG3_EPT_DIR_Pos = 0x3
	// Bit mask of EPT_DIR field.
	UDPHS_EPTCFG3_EPT_DIR_Msk = 0x8
	// Bit EPT_DIR.
	UDPHS_EPTCFG3_EPT_DIR = 0x8
	// Position of EPT_TYPE field.
	UDPHS_EPTCFG3_EPT_TYPE_Pos = 0x4
	// Bit mask of EPT_TYPE field.
	UDPHS_EPTCFG3_EPT_TYPE_Msk = 0x30
	// Control endpoint
	UDPHS_EPTCFG3_EPT_TYPE_CTRL8 = 0x0
	// Isochronous endpoint
	UDPHS_EPTCFG3_EPT_TYPE_ISO = 0x1
	// Bulk endpoint
	UDPHS_EPTCFG3_EPT_TYPE_BULK = 0x2
	// Interrupt endpoint
	UDPHS_EPTCFG3_EPT_TYPE_INT = 0x3
	// Position of BK_NUMBER field.
	UDPHS_EPTCFG3_BK_NUMBER_Pos = 0x6
	// Bit mask of BK_NUMBER field.
	UDPHS_EPTCFG3_BK_NUMBER_Msk = 0xc0
	// Zero bank, the endpoint is not mapped in memory
	UDPHS_EPTCFG3_BK_NUMBER_0 = 0x0
	// One bank (bank 0)
	UDPHS_EPTCFG3_BK_NUMBER_1 = 0x1
	// Double bank (Ping-Pong: bank0/bank1)
	UDPHS_EPTCFG3_BK_NUMBER_2 = 0x2
	// Triple bank (bank0/bank1/bank2)
	UDPHS_EPTCFG3_BK_NUMBER_3 = 0x3
	// Position of NB_TRANS field.
	UDPHS_EPTCFG3_NB_TRANS_Pos = 0x8
	// Bit mask of NB_TRANS field.
	UDPHS_EPTCFG3_NB_TRANS_Msk = 0x300
	// Position of EPT_MAPD field.
	UDPHS_EPTCFG3_EPT_MAPD_Pos = 0x1f
	// Bit mask of EPT_MAPD field.
	UDPHS_EPTCFG3_EPT_MAPD_Msk = 0x80000000
	// Bit EPT_MAPD.
	UDPHS_EPTCFG3_EPT_MAPD = 0x80000000

	// EPTCTLENB3: UDPHS Endpoint Control Enable Register (endpoint = 3)
	// Position of EPT_ENABL field.
	UDPHS_EPTCTLENB3_EPT_ENABL_Pos = 0x0
	// Bit mask of EPT_ENABL field.
	UDPHS_EPTCTLENB3_EPT_ENABL_Msk = 0x1
	// Bit EPT_ENABL.
	UDPHS_EPTCTLENB3_EPT_ENABL = 0x1
	// Position of AUTO_VALID field.
	UDPHS_EPTCTLENB3_AUTO_VALID_Pos = 0x1
	// Bit mask of AUTO_VALID field.
	UDPHS_EPTCTLENB3_AUTO_VALID_Msk = 0x2
	// Bit AUTO_VALID.
	UDPHS_EPTCTLENB3_AUTO_VALID = 0x2
	// Position of INTDIS_DMA field.
	UDPHS_EPTCTLENB3_INTDIS_DMA_Pos = 0x3
	// Bit mask of INTDIS_DMA field.
	UDPHS_EPTCTLENB3_INTDIS_DMA_Msk = 0x8
	// Bit INTDIS_DMA.
	UDPHS_EPTCTLENB3_INTDIS_DMA = 0x8
	// Position of NYET_DIS field.
	UDPHS_EPTCTLENB3_NYET_DIS_Pos = 0x4
	// Bit mask of NYET_DIS field.
	UDPHS_EPTCTLENB3_NYET_DIS_Msk = 0x10
	// Bit NYET_DIS.
	UDPHS_EPTCTLENB3_NYET_DIS = 0x10
	// Position of ERR_OVFLW field.
	UDPHS_EPTCTLENB3_ERR_OVFLW_Pos = 0x8
	// Bit mask of ERR_OVFLW field.
	UDPHS_EPTCTLENB3_ERR_OVFLW_Msk = 0x100
	// Bit ERR_OVFLW.
	UDPHS_EPTCTLENB3_ERR_OVFLW = 0x100
	// Position of RXRDY_TXKL field.
	UDPHS_EPTCTLENB3_RXRDY_TXKL_Pos = 0x9
	// Bit mask of RXRDY_TXKL field.
	UDPHS_EPTCTLENB3_RXRDY_TXKL_Msk = 0x200
	// Bit RXRDY_TXKL.
	UDPHS_EPTCTLENB3_RXRDY_TXKL = 0x200
	// Position of TX_COMPLT field.
	UDPHS_EPTCTLENB3_TX_COMPLT_Pos = 0xa
	// Bit mask of TX_COMPLT field.
	UDPHS_EPTCTLENB3_TX_COMPLT_Msk = 0x400
	// Bit TX_COMPLT.
	UDPHS_EPTCTLENB3_TX_COMPLT = 0x400
	// Position of TXRDY field.
	UDPHS_EPTCTLENB3_TXRDY_Pos = 0xb
	// Bit mask of TXRDY field.
	UDPHS_EPTCTLENB3_TXRDY_Msk = 0x800
	// Bit TXRDY.
	UDPHS_EPTCTLENB3_TXRDY = 0x800
	// Position of RX_SETUP field.
	UDPHS_EPTCTLENB3_RX_SETUP_Pos = 0xc
	// Bit mask of RX_SETUP field.
	UDPHS_EPTCTLENB3_RX_SETUP_Msk = 0x1000
	// Bit RX_SETUP.
	UDPHS_EPTCTLENB3_RX_SETUP = 0x1000
	// Position of STALL_SNT field.
	UDPHS_EPTCTLENB3_STALL_SNT_Pos = 0xd
	// Bit mask of STALL_SNT field.
	UDPHS_EPTCTLENB3_STALL_SNT_Msk = 0x2000
	// Bit STALL_SNT.
	UDPHS_EPTCTLENB3_STALL_SNT = 0x2000
	// Position of NAK_IN field.
	UDPHS_EPTCTLENB3_NAK_IN_Pos = 0xe
	// Bit mask of NAK_IN field.
	UDPHS_EPTCTLENB3_NAK_IN_Msk = 0x4000
	// Bit NAK_IN.
	UDPHS_EPTCTLENB3_NAK_IN = 0x4000
	// Position of NAK_OUT field.
	UDPHS_EPTCTLENB3_NAK_OUT_Pos = 0xf
	// Bit mask of NAK_OUT field.
	UDPHS_EPTCTLENB3_NAK_OUT_Msk = 0x8000
	// Bit NAK_OUT.
	UDPHS_EPTCTLENB3_NAK_OUT = 0x8000
	// Position of BUSY_BANK field.
	UDPHS_EPTCTLENB3_BUSY_BANK_Pos = 0x12
	// Bit mask of BUSY_BANK field.
	UDPHS_EPTCTLENB3_BUSY_BANK_Msk = 0x40000
	// Bit BUSY_BANK.
	UDPHS_EPTCTLENB3_BUSY_BANK = 0x40000
	// Position of SHRT_PCKT field.
	UDPHS_EPTCTLENB3_SHRT_PCKT_Pos = 0x1f
	// Bit mask of SHRT_PCKT field.
	UDPHS_EPTCTLENB3_SHRT_PCKT_Msk = 0x80000000
	// Bit SHRT_PCKT.
	UDPHS_EPTCTLENB3_SHRT_PCKT = 0x80000000

	// EPTCTLENB3_ISOENDPT: UDPHS Endpoint Control Enable Register (endpoint = 3)
	// Position of EPT_ENABL field.
	UDPHS_EPTCTLENB3_ISOENDPT_EPT_ENABL_Pos = 0x0
	// Bit mask of EPT_ENABL field.
	UDPHS_EPTCTLENB3_ISOENDPT_EPT_ENABL_Msk = 0x1
	// Bit EPT_ENABL.
	UDPHS_EPTCTLENB3_ISOENDPT_EPT_ENABL = 0x1
	// Position of AUTO_VALID field.
	UDPHS_EPTCTLENB3_ISOENDPT_AUTO_VALID_Pos = 0x1
	// Bit mask of AUTO_VALID field.
	UDPHS_EPTCTLENB3_ISOENDPT_AUTO_VALID_Msk = 0x2
	// Bit AUTO_VALID.
	UDPHS_EPTCTLENB3_ISOENDPT_AUTO_VALID = 0x2
	// Position of INTDIS_DMA field.
	UDPHS_EPTCTLENB3_ISOENDPT_INTDIS_DMA_Pos = 0x3
	// Bit mask of INTDIS_DMA field.
	UDPHS_EPTCTLENB3_ISOENDPT_INTDIS_DMA_Msk = 0x8
	// Bit INTDIS_DMA.
	UDPHS_EPTCTLENB3_ISOENDPT_INTDIS_DMA = 0x8
	// Position of DATAX_RX field.
	UDPHS_EPTCTLENB3_ISOENDPT_DATAX_RX_Pos = 0x6
	// Bit mask of DATAX_RX field.
	UDPHS_EPTCTLENB3_ISOENDPT_DATAX_RX_Msk = 0x40
	// Bit DATAX_RX.
	UDPHS_EPTCTLENB3_ISOENDPT_DATAX_RX = 0x40
	// Position of MDATA_RX field.
	UDPHS_EPTCTLENB3_ISOENDPT_MDATA_RX_Pos = 0x7
	// Bit mask of MDATA_RX field.
	UDPHS_EPTCTLENB3_ISOENDPT_MDATA_RX_Msk = 0x80
	// Bit MDATA_RX.
	UDPHS_EPTCTLENB3_ISOENDPT_MDATA_RX = 0x80
	// Position of ERR_OVFLW field.
	UDPHS_EPTCTLENB3_ISOENDPT_ERR_OVFLW_Pos = 0x8
	// Bit mask of ERR_OVFLW field.
	UDPHS_EPTCTLENB3_ISOENDPT_ERR_OVFLW_Msk = 0x100
	// Bit ERR_OVFLW.
	UDPHS_EPTCTLENB3_ISOENDPT_ERR_OVFLW = 0x100
	// Position of RXRDY_TXKL field.
	UDPHS_EPTCTLENB3_ISOENDPT_RXRDY_TXKL_Pos = 0x9
	// Bit mask of RXRDY_TXKL field.
	UDPHS_EPTCTLENB3_ISOENDPT_RXRDY_TXKL_Msk = 0x200
	// Bit RXRDY_TXKL.
	UDPHS_EPTCTLENB3_ISOENDPT_RXRDY_TXKL = 0x200
	// Position of TX_COMPLT field.
	UDPHS_EPTCTLENB3_ISOENDPT_TX_COMPLT_Pos = 0xa
	// Bit mask of TX_COMPLT field.
	UDPHS_EPTCTLENB3_ISOENDPT_TX_COMPLT_Msk = 0x400
	// Bit TX_COMPLT.
	UDPHS_EPTCTLENB3_ISOENDPT_TX_COMPLT = 0x400
	// Position of TXRDY_TRER field.
	UDPHS_EPTCTLENB3_ISOENDPT_TXRDY_TRER_Pos = 0xb
	// Bit mask of TXRDY_TRER field.
	UDPHS_EPTCTLENB3_ISOENDPT_TXRDY_TRER_Msk = 0x800
	// Bit TXRDY_TRER.
	UDPHS_EPTCTLENB3_ISOENDPT_TXRDY_TRER = 0x800
	// Position of ERR_FL_ISO field.
	UDPHS_EPTCTLENB3_ISOENDPT_ERR_FL_ISO_Pos = 0xc
	// Bit mask of ERR_FL_ISO field.
	UDPHS_EPTCTLENB3_ISOENDPT_ERR_FL_ISO_Msk = 0x1000
	// Bit ERR_FL_ISO.
	UDPHS_EPTCTLENB3_ISOENDPT_ERR_FL_ISO = 0x1000
	// Position of ERR_CRC_NTR field.
	UDPHS_EPTCTLENB3_ISOENDPT_ERR_CRC_NTR_Pos = 0xd
	// Bit mask of ERR_CRC_NTR field.
	UDPHS_EPTCTLENB3_ISOENDPT_ERR_CRC_NTR_Msk = 0x2000
	// Bit ERR_CRC_NTR.
	UDPHS_EPTCTLENB3_ISOENDPT_ERR_CRC_NTR = 0x2000
	// Position of ERR_FLUSH field.
	UDPHS_EPTCTLENB3_ISOENDPT_ERR_FLUSH_Pos = 0xe
	// Bit mask of ERR_FLUSH field.
	UDPHS_EPTCTLENB3_ISOENDPT_ERR_FLUSH_Msk = 0x4000
	// Bit ERR_FLUSH.
	UDPHS_EPTCTLENB3_ISOENDPT_ERR_FLUSH = 0x4000
	// Position of BUSY_BANK field.
	UDPHS_EPTCTLENB3_ISOENDPT_BUSY_BANK_Pos = 0x12
	// Bit mask of BUSY_BANK field.
	UDPHS_EPTCTLENB3_ISOENDPT_BUSY_BANK_Msk = 0x40000
	// Bit BUSY_BANK.
	UDPHS_EPTCTLENB3_ISOENDPT_BUSY_BANK = 0x40000
	// Position of SHRT_PCKT field.
	UDPHS_EPTCTLENB3_ISOENDPT_SHRT_PCKT_Pos = 0x1f
	// Bit mask of SHRT_PCKT field.
	UDPHS_EPTCTLENB3_ISOENDPT_SHRT_PCKT_Msk = 0x80000000
	// Bit SHRT_PCKT.
	UDPHS_EPTCTLENB3_ISOENDPT_SHRT_PCKT = 0x80000000

	// EPTCTLDIS3: UDPHS Endpoint Control Disable Register (endpoint = 3)
	// Position of EPT_DISABL field.
	UDPHS_EPTCTLDIS3_EPT_DISABL_Pos = 0x0
	// Bit mask of EPT_DISABL field.
	UDPHS_EPTCTLDIS3_EPT_DISABL_Msk = 0x1
	// Bit EPT_DISABL.
	UDPHS_EPTCTLDIS3_EPT_DISABL = 0x1
	// Position of AUTO_VALID field.
	UDPHS_EPTCTLDIS3_AUTO_VALID_Pos = 0x1
	// Bit mask of AUTO_VALID field.
	UDPHS_EPTCTLDIS3_AUTO_VALID_Msk = 0x2
	// Bit AUTO_VALID.
	UDPHS_EPTCTLDIS3_AUTO_VALID = 0x2
	// Position of INTDIS_DMA field.
	UDPHS_EPTCTLDIS3_INTDIS_DMA_Pos = 0x3
	// Bit mask of INTDIS_DMA field.
	UDPHS_EPTCTLDIS3_INTDIS_DMA_Msk = 0x8
	// Bit INTDIS_DMA.
	UDPHS_EPTCTLDIS3_INTDIS_DMA = 0x8
	// Position of NYET_DIS field.
	UDPHS_EPTCTLDIS3_NYET_DIS_Pos = 0x4
	// Bit mask of NYET_DIS field.
	UDPHS_EPTCTLDIS3_NYET_DIS_Msk = 0x10
	// Bit NYET_DIS.
	UDPHS_EPTCTLDIS3_NYET_DIS = 0x10
	// Position of ERR_OVFLW field.
	UDPHS_EPTCTLDIS3_ERR_OVFLW_Pos = 0x8
	// Bit mask of ERR_OVFLW field.
	UDPHS_EPTCTLDIS3_ERR_OVFLW_Msk = 0x100
	// Bit ERR_OVFLW.
	UDPHS_EPTCTLDIS3_ERR_OVFLW = 0x100
	// Position of RXRDY_TXKL field.
	UDPHS_EPTCTLDIS3_RXRDY_TXKL_Pos = 0x9
	// Bit mask of RXRDY_TXKL field.
	UDPHS_EPTCTLDIS3_RXRDY_TXKL_Msk = 0x200
	// Bit RXRDY_TXKL.
	UDPHS_EPTCTLDIS3_RXRDY_TXKL = 0x200
	// Position of TX_COMPLT field.
	UDPHS_EPTCTLDIS3_TX_COMPLT_Pos = 0xa
	// Bit mask of TX_COMPLT field.
	UDPHS_EPTCTLDIS3_TX_COMPLT_Msk = 0x400
	// Bit TX_COMPLT.
	UDPHS_EPTCTLDIS3_TX_COMPLT = 0x400
	// Position of TXRDY field.
	UDPHS_EPTCTLDIS3_TXRDY_Pos = 0xb
	// Bit mask of TXRDY field.
	UDPHS_EPTCTLDIS3_TXRDY_Msk = 0x800
	// Bit TXRDY.
	UDPHS_EPTCTLDIS3_TXRDY = 0x800
	// Position of RX_SETUP field.
	UDPHS_EPTCTLDIS3_RX_SETUP_Pos = 0xc
	// Bit mask of RX_SETUP field.
	UDPHS_EPTCTLDIS3_RX_SETUP_Msk = 0x1000
	// Bit RX_SETUP.
	UDPHS_EPTCTLDIS3_RX_SETUP = 0x1000
	// Position of STALL_SNT field.
	UDPHS_EPTCTLDIS3_STALL_SNT_Pos = 0xd
	// Bit mask of STALL_SNT field.
	UDPHS_EPTCTLDIS3_STALL_SNT_Msk = 0x2000
	// Bit STALL_SNT.
	UDPHS_EPTCTLDIS3_STALL_SNT = 0x2000
	// Position of NAK_IN field.
	UDPHS_EPTCTLDIS3_NAK_IN_Pos = 0xe
	// Bit mask of NAK_IN field.
	UDPHS_EPTCTLDIS3_NAK_IN_Msk = 0x4000
	// Bit NAK_IN.
	UDPHS_EPTCTLDIS3_NAK_IN = 0x4000
	// Position of NAK_OUT field.
	UDPHS_EPTCTLDIS3_NAK_OUT_Pos = 0xf
	// Bit mask of NAK_OUT field.
	UDPHS_EPTCTLDIS3_NAK_OUT_Msk = 0x8000
	// Bit NAK_OUT.
	UDPHS_EPTCTLDIS3_NAK_OUT = 0x8000
	// Position of BUSY_BANK field.
	UDPHS_EPTCTLDIS3_BUSY_BANK_Pos = 0x12
	// Bit mask of BUSY_BANK field.
	UDPHS_EPTCTLDIS3_BUSY_BANK_Msk = 0x40000
	// Bit BUSY_BANK.
	UDPHS_EPTCTLDIS3_BUSY_BANK = 0x40000
	// Position of SHRT_PCKT field.
	UDPHS_EPTCTLDIS3_SHRT_PCKT_Pos = 0x1f
	// Bit mask of SHRT_PCKT field.
	UDPHS_EPTCTLDIS3_SHRT_PCKT_Msk = 0x80000000
	// Bit SHRT_PCKT.
	UDPHS_EPTCTLDIS3_SHRT_PCKT = 0x80000000

	// EPTCTLDIS3_ISOENDPT: UDPHS Endpoint Control Disable Register (endpoint = 3)
	// Position of EPT_DISABL field.
	UDPHS_EPTCTLDIS3_ISOENDPT_EPT_DISABL_Pos = 0x0
	// Bit mask of EPT_DISABL field.
	UDPHS_EPTCTLDIS3_ISOENDPT_EPT_DISABL_Msk = 0x1
	// Bit EPT_DISABL.
	UDPHS_EPTCTLDIS3_ISOENDPT_EPT_DISABL = 0x1
	// Position of AUTO_VALID field.
	UDPHS_EPTCTLDIS3_ISOENDPT_AUTO_VALID_Pos = 0x1
	// Bit mask of AUTO_VALID field.
	UDPHS_EPTCTLDIS3_ISOENDPT_AUTO_VALID_Msk = 0x2
	// Bit AUTO_VALID.
	UDPHS_EPTCTLDIS3_ISOENDPT_AUTO_VALID = 0x2
	// Position of INTDIS_DMA field.
	UDPHS_EPTCTLDIS3_ISOENDPT_INTDIS_DMA_Pos = 0x3
	// Bit mask of INTDIS_DMA field.
	UDPHS_EPTCTLDIS3_ISOENDPT_INTDIS_DMA_Msk = 0x8
	// Bit INTDIS_DMA.
	UDPHS_EPTCTLDIS3_ISOENDPT_INTDIS_DMA = 0x8
	// Position of DATAX_RX field.
	UDPHS_EPTCTLDIS3_ISOENDPT_DATAX_RX_Pos = 0x6
	// Bit mask of DATAX_RX field.
	UDPHS_EPTCTLDIS3_ISOENDPT_DATAX_RX_Msk = 0x40
	// Bit DATAX_RX.
	UDPHS_EPTCTLDIS3_ISOENDPT_DATAX_RX = 0x40
	// Position of MDATA_RX field.
	UDPHS_EPTCTLDIS3_ISOENDPT_MDATA_RX_Pos = 0x7
	// Bit mask of MDATA_RX field.
	UDPHS_EPTCTLDIS3_ISOENDPT_MDATA_RX_Msk = 0x80
	// Bit MDATA_RX.
	UDPHS_EPTCTLDIS3_ISOENDPT_MDATA_RX = 0x80
	// Position of ERR_OVFLW field.
	UDPHS_EPTCTLDIS3_ISOENDPT_ERR_OVFLW_Pos = 0x8
	// Bit mask of ERR_OVFLW field.
	UDPHS_EPTCTLDIS3_ISOENDPT_ERR_OVFLW_Msk = 0x100
	// Bit ERR_OVFLW.
	UDPHS_EPTCTLDIS3_ISOENDPT_ERR_OVFLW = 0x100
	// Position of RXRDY_TXKL field.
	UDPHS_EPTCTLDIS3_ISOENDPT_RXRDY_TXKL_Pos = 0x9
	// Bit mask of RXRDY_TXKL field.
	UDPHS_EPTCTLDIS3_ISOENDPT_RXRDY_TXKL_Msk = 0x200
	// Bit RXRDY_TXKL.
	UDPHS_EPTCTLDIS3_ISOENDPT_RXRDY_TXKL = 0x200
	// Position of TX_COMPLT field.
	UDPHS_EPTCTLDIS3_ISOENDPT_TX_COMPLT_Pos = 0xa
	// Bit mask of TX_COMPLT field.
	UDPHS_EPTCTLDIS3_ISOENDPT_TX_COMPLT_Msk = 0x400
	// Bit TX_COMPLT.
	UDPHS_EPTCTLDIS3_ISOENDPT_TX_COMPLT = 0x400
	// Position of TXRDY_TRER field.
	UDPHS_EPTCTLDIS3_ISOENDPT_TXRDY_TRER_Pos = 0xb
	// Bit mask of TXRDY_TRER field.
	UDPHS_EPTCTLDIS3_ISOENDPT_TXRDY_TRER_Msk = 0x800
	// Bit TXRDY_TRER.
	UDPHS_EPTCTLDIS3_ISOENDPT_TXRDY_TRER = 0x800
	// Position of ERR_FL_ISO field.
	UDPHS_EPTCTLDIS3_ISOENDPT_ERR_FL_ISO_Pos = 0xc
	// Bit mask of ERR_FL_ISO field.
	UDPHS_EPTCTLDIS3_ISOENDPT_ERR_FL_ISO_Msk = 0x1000
	// Bit ERR_FL_ISO.
	UDPHS_EPTCTLDIS3_ISOENDPT_ERR_FL_ISO = 0x1000
	// Position of ERR_CRC_NTR field.
	UDPHS_EPTCTLDIS3_ISOENDPT_ERR_CRC_NTR_Pos = 0xd
	// Bit mask of ERR_CRC_NTR field.
	UDPHS_EPTCTLDIS3_ISOENDPT_ERR_CRC_NTR_Msk = 0x2000
	// Bit ERR_CRC_NTR.
	UDPHS_EPTCTLDIS3_ISOENDPT_ERR_CRC_NTR = 0x2000
	// Position of ERR_FLUSH field.
	UDPHS_EPTCTLDIS3_ISOENDPT_ERR_FLUSH_Pos = 0xe
	// Bit mask of ERR_FLUSH field.
	UDPHS_EPTCTLDIS3_ISOENDPT_ERR_FLUSH_Msk = 0x4000
	// Bit ERR_FLUSH.
	UDPHS_EPTCTLDIS3_ISOENDPT_ERR_FLUSH = 0x4000
	// Position of BUSY_BANK field.
	UDPHS_EPTCTLDIS3_ISOENDPT_BUSY_BANK_Pos = 0x12
	// Bit mask of BUSY_BANK field.
	UDPHS_EPTCTLDIS3_ISOENDPT_BUSY_BANK_Msk = 0x40000
	// Bit BUSY_BANK.
	UDPHS_EPTCTLDIS3_ISOENDPT_BUSY_BANK = 0x40000
	// Position of SHRT_PCKT field.
	UDPHS_EPTCTLDIS3_ISOENDPT_SHRT_PCKT_Pos = 0x1f
	// Bit mask of SHRT_PCKT field.
	UDPHS_EPTCTLDIS3_ISOENDPT_SHRT_PCKT_Msk = 0x80000000
	// Bit SHRT_PCKT.
	UDPHS_EPTCTLDIS3_ISOENDPT_SHRT_PCKT = 0x80000000

	// EPTCTL3: UDPHS Endpoint Control Register (endpoint = 3)
	// Position of EPT_ENABL field.
	UDPHS_EPTCTL3_EPT_ENABL_Pos = 0x0
	// Bit mask of EPT_ENABL field.
	UDPHS_EPTCTL3_EPT_ENABL_Msk = 0x1
	// Bit EPT_ENABL.
	UDPHS_EPTCTL3_EPT_ENABL = 0x1
	// Position of AUTO_VALID field.
	UDPHS_EPTCTL3_AUTO_VALID_Pos = 0x1
	// Bit mask of AUTO_VALID field.
	UDPHS_EPTCTL3_AUTO_VALID_Msk = 0x2
	// Bit AUTO_VALID.
	UDPHS_EPTCTL3_AUTO_VALID = 0x2
	// Position of INTDIS_DMA field.
	UDPHS_EPTCTL3_INTDIS_DMA_Pos = 0x3
	// Bit mask of INTDIS_DMA field.
	UDPHS_EPTCTL3_INTDIS_DMA_Msk = 0x8
	// Bit INTDIS_DMA.
	UDPHS_EPTCTL3_INTDIS_DMA = 0x8
	// Position of NYET_DIS field.
	UDPHS_EPTCTL3_NYET_DIS_Pos = 0x4
	// Bit mask of NYET_DIS field.
	UDPHS_EPTCTL3_NYET_DIS_Msk = 0x10
	// Bit NYET_DIS.
	UDPHS_EPTCTL3_NYET_DIS = 0x10
	// Position of ERR_OVFLW field.
	UDPHS_EPTCTL3_ERR_OVFLW_Pos = 0x8
	// Bit mask of ERR_OVFLW field.
	UDPHS_EPTCTL3_ERR_OVFLW_Msk = 0x100
	// Bit ERR_OVFLW.
	UDPHS_EPTCTL3_ERR_OVFLW = 0x100
	// Position of RXRDY_TXKL field.
	UDPHS_EPTCTL3_RXRDY_TXKL_Pos = 0x9
	// Bit mask of RXRDY_TXKL field.
	UDPHS_EPTCTL3_RXRDY_TXKL_Msk = 0x200
	// Bit RXRDY_TXKL.
	UDPHS_EPTCTL3_RXRDY_TXKL = 0x200
	// Position of TX_COMPLT field.
	UDPHS_EPTCTL3_TX_COMPLT_Pos = 0xa
	// Bit mask of TX_COMPLT field.
	UDPHS_EPTCTL3_TX_COMPLT_Msk = 0x400
	// Bit TX_COMPLT.
	UDPHS_EPTCTL3_TX_COMPLT = 0x400
	// Position of TXRDY field.
	UDPHS_EPTCTL3_TXRDY_Pos = 0xb
	// Bit mask of TXRDY field.
	UDPHS_EPTCTL3_TXRDY_Msk = 0x800
	// Bit TXRDY.
	UDPHS_EPTCTL3_TXRDY = 0x800
	// Position of RX_SETUP field.
	UDPHS_EPTCTL3_RX_SETUP_Pos = 0xc
	// Bit mask of RX_SETUP field.
	UDPHS_EPTCTL3_RX_SETUP_Msk = 0x1000
	// Bit RX_SETUP.
	UDPHS_EPTCTL3_RX_SETUP = 0x1000
	// Position of STALL_SNT field.
	UDPHS_EPTCTL3_STALL_SNT_Pos = 0xd
	// Bit mask of STALL_SNT field.
	UDPHS_EPTCTL3_STALL_SNT_Msk = 0x2000
	// Bit STALL_SNT.
	UDPHS_EPTCTL3_STALL_SNT = 0x2000
	// Position of NAK_IN field.
	UDPHS_EPTCTL3_NAK_IN_Pos = 0xe
	// Bit mask of NAK_IN field.
	UDPHS_EPTCTL3_NAK_IN_Msk = 0x4000
	// Bit NAK_IN.
	UDPHS_EPTCTL3_NAK_IN = 0x4000
	// Position of NAK_OUT field.
	UDPHS_EPTCTL3_NAK_OUT_Pos = 0xf
	// Bit mask of NAK_OUT field.
	UDPHS_EPTCTL3_NAK_OUT_Msk = 0x8000
	// Bit NAK_OUT.
	UDPHS_EPTCTL3_NAK_OUT = 0x8000
	// Position of BUSY_BANK field.
	UDPHS_EPTCTL3_BUSY_BANK_Pos = 0x12
	// Bit mask of BUSY_BANK field.
	UDPHS_EPTCTL3_BUSY_BANK_Msk = 0x40000
	// Bit BUSY_BANK.
	UDPHS_EPTCTL3_BUSY_BANK = 0x40000
	// Position of SHRT_PCKT field.
	UDPHS_EPTCTL3_SHRT_PCKT_Pos = 0x1f
	// Bit mask of SHRT_PCKT field.
	UDPHS_EPTCTL3_SHRT_PCKT_Msk = 0x80000000
	// Bit SHRT_PCKT.
	UDPHS_EPTCTL3_SHRT_PCKT = 0x80000000

	// EPTCTL3_ISOENDPT: UDPHS Endpoint Control Register (endpoint = 3)
	// Position of EPT_ENABL field.
	UDPHS_EPTCTL3_ISOENDPT_EPT_ENABL_Pos = 0x0
	// Bit mask of EPT_ENABL field.
	UDPHS_EPTCTL3_ISOENDPT_EPT_ENABL_Msk = 0x1
	// Bit EPT_ENABL.
	UDPHS_EPTCTL3_ISOENDPT_EPT_ENABL = 0x1
	// Position of AUTO_VALID field.
	UDPHS_EPTCTL3_ISOENDPT_AUTO_VALID_Pos = 0x1
	// Bit mask of AUTO_VALID field.
	UDPHS_EPTCTL3_ISOENDPT_AUTO_VALID_Msk = 0x2
	// Bit AUTO_VALID.
	UDPHS_EPTCTL3_ISOENDPT_AUTO_VALID = 0x2
	// Position of INTDIS_DMA field.
	UDPHS_EPTCTL3_ISOENDPT_INTDIS_DMA_Pos = 0x3
	// Bit mask of INTDIS_DMA field.
	UDPHS_EPTCTL3_ISOENDPT_INTDIS_DMA_Msk = 0x8
	// Bit INTDIS_DMA.
	UDPHS_EPTCTL3_ISOENDPT_INTDIS_DMA = 0x8
	// Position of DATAX_RX field.
	UDPHS_EPTCTL3_ISOENDPT_DATAX_RX_Pos = 0x6
	// Bit mask of DATAX_RX field.
	UDPHS_EPTCTL3_ISOENDPT_DATAX_RX_Msk = 0x40
	// Bit DATAX_RX.
	UDPHS_EPTCTL3_ISOENDPT_DATAX_RX = 0x40
	// Position of MDATA_RX field.
	UDPHS_EPTCTL3_ISOENDPT_MDATA_RX_Pos = 0x7
	// Bit mask of MDATA_RX field.
	UDPHS_EPTCTL3_ISOENDPT_MDATA_RX_Msk = 0x80
	// Bit MDATA_RX.
	UDPHS_EPTCTL3_ISOENDPT_MDATA_RX = 0x80
	// Position of ERR_OVFLW field.
	UDPHS_EPTCTL3_ISOENDPT_ERR_OVFLW_Pos = 0x8
	// Bit mask of ERR_OVFLW field.
	UDPHS_EPTCTL3_ISOENDPT_ERR_OVFLW_Msk = 0x100
	// Bit ERR_OVFLW.
	UDPHS_EPTCTL3_ISOENDPT_ERR_OVFLW = 0x100
	// Position of RXRDY_TXKL field.
	UDPHS_EPTCTL3_ISOENDPT_RXRDY_TXKL_Pos = 0x9
	// Bit mask of RXRDY_TXKL field.
	UDPHS_EPTCTL3_ISOENDPT_RXRDY_TXKL_Msk = 0x200
	// Bit RXRDY_TXKL.
	UDPHS_EPTCTL3_ISOENDPT_RXRDY_TXKL = 0x200
	// Position of TX_COMPLT field.
	UDPHS_EPTCTL3_ISOENDPT_TX_COMPLT_Pos = 0xa
	// Bit mask of TX_COMPLT field.
	UDPHS_EPTCTL3_ISOENDPT_TX_COMPLT_Msk = 0x400
	// Bit TX_COMPLT.
	UDPHS_EPTCTL3_ISOENDPT_TX_COMPLT = 0x400
	// Position of TXRDY_TRER field.
	UDPHS_EPTCTL3_ISOENDPT_TXRDY_TRER_Pos = 0xb
	// Bit mask of TXRDY_TRER field.
	UDPHS_EPTCTL3_ISOENDPT_TXRDY_TRER_Msk = 0x800
	// Bit TXRDY_TRER.
	UDPHS_EPTCTL3_ISOENDPT_TXRDY_TRER = 0x800
	// Position of ERR_FL_ISO field.
	UDPHS_EPTCTL3_ISOENDPT_ERR_FL_ISO_Pos = 0xc
	// Bit mask of ERR_FL_ISO field.
	UDPHS_EPTCTL3_ISOENDPT_ERR_FL_ISO_Msk = 0x1000
	// Bit ERR_FL_ISO.
	UDPHS_EPTCTL3_ISOENDPT_ERR_FL_ISO = 0x1000
	// Position of ERR_CRC_NTR field.
	UDPHS_EPTCTL3_ISOENDPT_ERR_CRC_NTR_Pos = 0xd
	// Bit mask of ERR_CRC_NTR field.
	UDPHS_EPTCTL3_ISOENDPT_ERR_CRC_NTR_Msk = 0x2000
	// Bit ERR_CRC_NTR.
	UDPHS_EPTCTL3_ISOENDPT_ERR_CRC_NTR = 0x2000
	// Position of ERR_FLUSH field.
	UDPHS_EPTCTL3_ISOENDPT_ERR_FLUSH_Pos = 0xe
	// Bit mask of ERR_FLUSH field.
	UDPHS_EPTCTL3_ISOENDPT_ERR_FLUSH_Msk = 0x4000
	// Bit ERR_FLUSH.
	UDPHS_EPTCTL3_ISOENDPT_ERR_FLUSH = 0x4000
	// Position of BUSY_BANK field.
	UDPHS_EPTCTL3_ISOENDPT_BUSY_BANK_Pos = 0x12
	// Bit mask of BUSY_BANK field.
	UDPHS_EPTCTL3_ISOENDPT_BUSY_BANK_Msk = 0x40000
	// Bit BUSY_BANK.
	UDPHS_EPTCTL3_ISOENDPT_BUSY_BANK = 0x40000
	// Position of SHRT_PCKT field.
	UDPHS_EPTCTL3_ISOENDPT_SHRT_PCKT_Pos = 0x1f
	// Bit mask of SHRT_PCKT field.
	UDPHS_EPTCTL3_ISOENDPT_SHRT_PCKT_Msk = 0x80000000
	// Bit SHRT_PCKT.
	UDPHS_EPTCTL3_ISOENDPT_SHRT_PCKT = 0x80000000

	// EPTSETSTA3: UDPHS Endpoint Set Status Register (endpoint = 3)
	// Position of FRCESTALL field.
	UDPHS_EPTSETSTA3_FRCESTALL_Pos = 0x5
	// Bit mask of FRCESTALL field.
	UDPHS_EPTSETSTA3_FRCESTALL_Msk = 0x20
	// Bit FRCESTALL.
	UDPHS_EPTSETSTA3_FRCESTALL = 0x20
	// Position of RXRDY_TXKL field.
	UDPHS_EPTSETSTA3_RXRDY_TXKL_Pos = 0x9
	// Bit mask of RXRDY_TXKL field.
	UDPHS_EPTSETSTA3_RXRDY_TXKL_Msk = 0x200
	// Bit RXRDY_TXKL.
	UDPHS_EPTSETSTA3_RXRDY_TXKL = 0x200
	// Position of TXRDY field.
	UDPHS_EPTSETSTA3_TXRDY_Pos = 0xb
	// Bit mask of TXRDY field.
	UDPHS_EPTSETSTA3_TXRDY_Msk = 0x800
	// Bit TXRDY.
	UDPHS_EPTSETSTA3_TXRDY = 0x800

	// EPTSETSTA3_ISOENDPT: UDPHS Endpoint Set Status Register (endpoint = 3)
	// Position of RXRDY_TXKL field.
	UDPHS_EPTSETSTA3_ISOENDPT_RXRDY_TXKL_Pos = 0x9
	// Bit mask of RXRDY_TXKL field.
	UDPHS_EPTSETSTA3_ISOENDPT_RXRDY_TXKL_Msk = 0x200
	// Bit RXRDY_TXKL.
	UDPHS_EPTSETSTA3_ISOENDPT_RXRDY_TXKL = 0x200
	// Position of TXRDY_TRER field.
	UDPHS_EPTSETSTA3_ISOENDPT_TXRDY_TRER_Pos = 0xb
	// Bit mask of TXRDY_TRER field.
	UDPHS_EPTSETSTA3_ISOENDPT_TXRDY_TRER_Msk = 0x800
	// Bit TXRDY_TRER.
	UDPHS_EPTSETSTA3_ISOENDPT_TXRDY_TRER = 0x800

	// EPTCLRSTA3: UDPHS Endpoint Clear Status Register (endpoint = 3)
	// Position of FRCESTALL field.
	UDPHS_EPTCLRSTA3_FRCESTALL_Pos = 0x5
	// Bit mask of FRCESTALL field.
	UDPHS_EPTCLRSTA3_FRCESTALL_Msk = 0x20
	// Bit FRCESTALL.
	UDPHS_EPTCLRSTA3_FRCESTALL = 0x20
	// Position of TOGGLESQ field.
	UDPHS_EPTCLRSTA3_TOGGLESQ_Pos = 0x6
	// Bit mask of TOGGLESQ field.
	UDPHS_EPTCLRSTA3_TOGGLESQ_Msk = 0x40
	// Bit TOGGLESQ.
	UDPHS_EPTCLRSTA3_TOGGLESQ = 0x40
	// Position of RXRDY_TXKL field.
	UDPHS_EPTCLRSTA3_RXRDY_TXKL_Pos = 0x9
	// Bit mask of RXRDY_TXKL field.
	UDPHS_EPTCLRSTA3_RXRDY_TXKL_Msk = 0x200
	// Bit RXRDY_TXKL.
	UDPHS_EPTCLRSTA3_RXRDY_TXKL = 0x200
	// Position of TX_COMPLT field.
	UDPHS_EPTCLRSTA3_TX_COMPLT_Pos = 0xa
	// Bit mask of TX_COMPLT field.
	UDPHS_EPTCLRSTA3_TX_COMPLT_Msk = 0x400
	// Bit TX_COMPLT.
	UDPHS_EPTCLRSTA3_TX_COMPLT = 0x400
	// Position of RX_SETUP field.
	UDPHS_EPTCLRSTA3_RX_SETUP_Pos = 0xc
	// Bit mask of RX_SETUP field.
	UDPHS_EPTCLRSTA3_RX_SETUP_Msk = 0x1000
	// Bit RX_SETUP.
	UDPHS_EPTCLRSTA3_RX_SETUP = 0x1000
	// Position of STALL_SNT field.
	UDPHS_EPTCLRSTA3_STALL_SNT_Pos = 0xd
	// Bit mask of STALL_SNT field.
	UDPHS_EPTCLRSTA3_STALL_SNT_Msk = 0x2000
	// Bit STALL_SNT.
	UDPHS_EPTCLRSTA3_STALL_SNT = 0x2000
	// Position of NAK_IN field.
	UDPHS_EPTCLRSTA3_NAK_IN_Pos = 0xe
	// Bit mask of NAK_IN field.
	UDPHS_EPTCLRSTA3_NAK_IN_Msk = 0x4000
	// Bit NAK_IN.
	UDPHS_EPTCLRSTA3_NAK_IN = 0x4000
	// Position of NAK_OUT field.
	UDPHS_EPTCLRSTA3_NAK_OUT_Pos = 0xf
	// Bit mask of NAK_OUT field.
	UDPHS_EPTCLRSTA3_NAK_OUT_Msk = 0x8000
	// Bit NAK_OUT.
	UDPHS_EPTCLRSTA3_NAK_OUT = 0x8000

	// EPTCLRSTA3_ISOENDPT: UDPHS Endpoint Clear Status Register (endpoint = 3)
	// Position of TOGGLESQ field.
	UDPHS_EPTCLRSTA3_ISOENDPT_TOGGLESQ_Pos = 0x6
	// Bit mask of TOGGLESQ field.
	UDPHS_EPTCLRSTA3_ISOENDPT_TOGGLESQ_Msk = 0x40
	// Bit TOGGLESQ.
	UDPHS_EPTCLRSTA3_ISOENDPT_TOGGLESQ = 0x40
	// Position of RXRDY_TXKL field.
	UDPHS_EPTCLRSTA3_ISOENDPT_RXRDY_TXKL_Pos = 0x9
	// Bit mask of RXRDY_TXKL field.
	UDPHS_EPTCLRSTA3_ISOENDPT_RXRDY_TXKL_Msk = 0x200
	// Bit RXRDY_TXKL.
	UDPHS_EPTCLRSTA3_ISOENDPT_RXRDY_TXKL = 0x200
	// Position of TX_COMPLT field.
	UDPHS_EPTCLRSTA3_ISOENDPT_TX_COMPLT_Pos = 0xa
	// Bit mask of TX_COMPLT field.
	UDPHS_EPTCLRSTA3_ISOENDPT_TX_COMPLT_Msk = 0x400
	// Bit TX_COMPLT.
	UDPHS_EPTCLRSTA3_ISOENDPT_TX_COMPLT = 0x400
	// Position of ERR_FL_ISO field.
	UDPHS_EPTCLRSTA3_ISOENDPT_ERR_FL_ISO_Pos = 0xc
	// Bit mask of ERR_FL_ISO field.
	UDPHS_EPTCLRSTA3_ISOENDPT_ERR_FL_ISO_Msk = 0x1000
	// Bit ERR_FL_ISO.
	UDPHS_EPTCLRSTA3_ISOENDPT_ERR_FL_ISO = 0x1000
	// Position of ERR_CRC_NTR field.
	UDPHS_EPTCLRSTA3_ISOENDPT_ERR_CRC_NTR_Pos = 0xd
	// Bit mask of ERR_CRC_NTR field.
	UDPHS_EPTCLRSTA3_ISOENDPT_ERR_CRC_NTR_Msk = 0x2000
	// Bit ERR_CRC_NTR.
	UDPHS_EPTCLRSTA3_ISOENDPT_ERR_CRC_NTR = 0x2000
	// Position of ERR_FLUSH field.
	UDPHS_EPTCLRSTA3_ISOENDPT_ERR_FLUSH_Pos = 0xe
	// Bit mask of ERR_FLUSH field.
	UDPHS_EPTCLRSTA3_ISOENDPT_ERR_FLUSH_Msk = 0x4000
	// Bit ERR_FLUSH.
	UDPHS_EPTCLRSTA3_ISOENDPT_ERR_FLUSH = 0x4000

	// EPTSTA3: UDPHS Endpoint Status Register (endpoint = 3)
	// Position of FRCESTALL field.
	UDPHS_EPTSTA3_FRCESTALL_Pos = 0x5
	// Bit mask of FRCESTALL field.
	UDPHS_EPTSTA3_FRCESTALL_Msk = 0x20
	// Bit FRCESTALL.
	UDPHS_EPTSTA3_FRCESTALL = 0x20
	// Position of TOGGLESQ_STA field.
	UDPHS_EPTSTA3_TOGGLESQ_STA_Pos = 0x6
	// Bit mask of TOGGLESQ_STA field.
	UDPHS_EPTSTA3_TOGGLESQ_STA_Msk = 0xc0
	// DATA0
	UDPHS_EPTSTA3_TOGGLESQ_STA_DATA0 = 0x0
	// DATA1
	UDPHS_EPTSTA3_TOGGLESQ_STA_DATA1 = 0x1
	// Reserved for High Bandwidth Isochronous Endpoint
	UDPHS_EPTSTA3_TOGGLESQ_STA_DATA2 = 0x2
	// Reserved for High Bandwidth Isochronous Endpoint
	UDPHS_EPTSTA3_TOGGLESQ_STA_MDATA = 0x3
	// Position of ERR_OVFLW field.
	UDPHS_EPTSTA3_ERR_OVFLW_Pos = 0x8
	// Bit mask of ERR_OVFLW field.
	UDPHS_EPTSTA3_ERR_OVFLW_Msk = 0x100
	// Bit ERR_OVFLW.
	UDPHS_EPTSTA3_ERR_OVFLW = 0x100
	// Position of RXRDY_TXKL field.
	UDPHS_EPTSTA3_RXRDY_TXKL_Pos = 0x9
	// Bit mask of RXRDY_TXKL field.
	UDPHS_EPTSTA3_RXRDY_TXKL_Msk = 0x200
	// Bit RXRDY_TXKL.
	UDPHS_EPTSTA3_RXRDY_TXKL = 0x200
	// Position of TX_COMPLT field.
	UDPHS_EPTSTA3_TX_COMPLT_Pos = 0xa
	// Bit mask of TX_COMPLT field.
	UDPHS_EPTSTA3_TX_COMPLT_Msk = 0x400
	// Bit TX_COMPLT.
	UDPHS_EPTSTA3_TX_COMPLT = 0x400
	// Position of TXRDY field.
	UDPHS_EPTSTA3_TXRDY_Pos = 0xb
	// Bit mask of TXRDY field.
	UDPHS_EPTSTA3_TXRDY_Msk = 0x800
	// Bit TXRDY.
	UDPHS_EPTSTA3_TXRDY = 0x800
	// Position of RX_SETUP field.
	UDPHS_EPTSTA3_RX_SETUP_Pos = 0xc
	// Bit mask of RX_SETUP field.
	UDPHS_EPTSTA3_RX_SETUP_Msk = 0x1000
	// Bit RX_SETUP.
	UDPHS_EPTSTA3_RX_SETUP = 0x1000
	// Position of STALL_SNT field.
	UDPHS_EPTSTA3_STALL_SNT_Pos = 0xd
	// Bit mask of STALL_SNT field.
	UDPHS_EPTSTA3_STALL_SNT_Msk = 0x2000
	// Bit STALL_SNT.
	UDPHS_EPTSTA3_STALL_SNT = 0x2000
	// Position of NAK_IN field.
	UDPHS_EPTSTA3_NAK_IN_Pos = 0xe
	// Bit mask of NAK_IN field.
	UDPHS_EPTSTA3_NAK_IN_Msk = 0x4000
	// Bit NAK_IN.
	UDPHS_EPTSTA3_NAK_IN = 0x4000
	// Position of NAK_OUT field.
	UDPHS_EPTSTA3_NAK_OUT_Pos = 0xf
	// Bit mask of NAK_OUT field.
	UDPHS_EPTSTA3_NAK_OUT_Msk = 0x8000
	// Bit NAK_OUT.
	UDPHS_EPTSTA3_NAK_OUT = 0x8000
	// Position of CURBK_CTLDIR field.
	UDPHS_EPTSTA3_CURBK_CTLDIR_Pos = 0x10
	// Bit mask of CURBK_CTLDIR field.
	UDPHS_EPTSTA3_CURBK_CTLDIR_Msk = 0x30000
	// Position of BUSY_BANK_STA field.
	UDPHS_EPTSTA3_BUSY_BANK_STA_Pos = 0x12
	// Bit mask of BUSY_BANK_STA field.
	UDPHS_EPTSTA3_BUSY_BANK_STA_Msk = 0xc0000
	// 1 busy bank
	UDPHS_EPTSTA3_BUSY_BANK_STA_1BUSYBANK = 0x0
	// 2 busy banks
	UDPHS_EPTSTA3_BUSY_BANK_STA_2BUSYBANKS = 0x1
	// 3 busy banks
	UDPHS_EPTSTA3_BUSY_BANK_STA_3BUSYBANKS = 0x2
	// Position of BYTE_COUNT field.
	UDPHS_EPTSTA3_BYTE_COUNT_Pos = 0x14
	// Bit mask of BYTE_COUNT field.
	UDPHS_EPTSTA3_BYTE_COUNT_Msk = 0x7ff00000
	// Position of SHRT_PCKT field.
	UDPHS_EPTSTA3_SHRT_PCKT_Pos = 0x1f
	// Bit mask of SHRT_PCKT field.
	UDPHS_EPTSTA3_SHRT_PCKT_Msk = 0x80000000
	// Bit SHRT_PCKT.
	UDPHS_EPTSTA3_SHRT_PCKT = 0x80000000

	// EPTSTA3_ISOENDPT: UDPHS Endpoint Status Register (endpoint = 3)
	// Position of TOGGLESQ_STA field.
	UDPHS_EPTSTA3_ISOENDPT_TOGGLESQ_STA_Pos = 0x6
	// Bit mask of TOGGLESQ_STA field.
	UDPHS_EPTSTA3_ISOENDPT_TOGGLESQ_STA_Msk = 0xc0
	// DATA0
	UDPHS_EPTSTA3_ISOENDPT_TOGGLESQ_STA_DATA0 = 0x0
	// DATA1
	UDPHS_EPTSTA3_ISOENDPT_TOGGLESQ_STA_DATA1 = 0x1
	// Data2 (only for High Bandwidth Isochronous Endpoint)
	UDPHS_EPTSTA3_ISOENDPT_TOGGLESQ_STA_DATA2 = 0x2
	// MData (only for High Bandwidth Isochronous Endpoint)
	UDPHS_EPTSTA3_ISOENDPT_TOGGLESQ_STA_MDATA = 0x3
	// Position of ERR_OVFLW field.
	UDPHS_EPTSTA3_ISOENDPT_ERR_OVFLW_Pos = 0x8
	// Bit mask of ERR_OVFLW field.
	UDPHS_EPTSTA3_ISOENDPT_ERR_OVFLW_Msk = 0x100
	// Bit ERR_OVFLW.
	UDPHS_EPTSTA3_ISOENDPT_ERR_OVFLW = 0x100
	// Position of RXRDY_TXKL field.
	UDPHS_EPTSTA3_ISOENDPT_RXRDY_TXKL_Pos = 0x9
	// Bit mask of RXRDY_TXKL field.
	UDPHS_EPTSTA3_ISOENDPT_RXRDY_TXKL_Msk = 0x200
	// Bit RXRDY_TXKL.
	UDPHS_EPTSTA3_ISOENDPT_RXRDY_TXKL = 0x200
	// Position of TX_COMPLT field.
	UDPHS_EPTSTA3_ISOENDPT_TX_COMPLT_Pos = 0xa
	// Bit mask of TX_COMPLT field.
	UDPHS_EPTSTA3_ISOENDPT_TX_COMPLT_Msk = 0x400
	// Bit TX_COMPLT.
	UDPHS_EPTSTA3_ISOENDPT_TX_COMPLT = 0x400
	// Position of TXRDY_TRER field.
	UDPHS_EPTSTA3_ISOENDPT_TXRDY_TRER_Pos = 0xb
	// Bit mask of TXRDY_TRER field.
	UDPHS_EPTSTA3_ISOENDPT_TXRDY_TRER_Msk = 0x800
	// Bit TXRDY_TRER.
	UDPHS_EPTSTA3_ISOENDPT_TXRDY_TRER = 0x800
	// Position of ERR_FL_ISO field.
	UDPHS_EPTSTA3_ISOENDPT_ERR_FL_ISO_Pos = 0xc
	// Bit mask of ERR_FL_ISO field.
	UDPHS_EPTSTA3_ISOENDPT_ERR_FL_ISO_Msk = 0x1000
	// Bit ERR_FL_ISO.
	UDPHS_EPTSTA3_ISOENDPT_ERR_FL_ISO = 0x1000
	// Position of ERR_CRC_NTR field.
	UDPHS_EPTSTA3_ISOENDPT_ERR_CRC_NTR_Pos = 0xd
	// Bit mask of ERR_CRC_NTR field.
	UDPHS_EPTSTA3_ISOENDPT_ERR_CRC_NTR_Msk = 0x2000
	// Bit ERR_CRC_NTR.
	UDPHS_EPTSTA3_ISOENDPT_ERR_CRC_NTR = 0x2000
	// Position of ERR_FLUSH field.
	UDPHS_EPTSTA3_ISOENDPT_ERR_FLUSH_Pos = 0xe
	// Bit mask of ERR_FLUSH field.
	UDPHS_EPTSTA3_ISOENDPT_ERR_FLUSH_Msk = 0x4000
	// Bit ERR_FLUSH.
	UDPHS_EPTSTA3_ISOENDPT_ERR_FLUSH = 0x4000
	// Position of CURBK field.
	UDPHS_EPTSTA3_ISOENDPT_CURBK_Pos = 0x10
	// Bit mask of CURBK field.
	UDPHS_EPTSTA3_ISOENDPT_CURBK_Msk = 0x30000
	// Bank 0 (or single bank)
	UDPHS_EPTSTA3_ISOENDPT_CURBK_BANK0 = 0x0
	// Bank 1
	UDPHS_EPTSTA3_ISOENDPT_CURBK_BANK1 = 0x1
	// Bank 2
	UDPHS_EPTSTA3_ISOENDPT_CURBK_BANK2 = 0x2
	// Position of BUSY_BANK_STA field.
	UDPHS_EPTSTA3_ISOENDPT_BUSY_BANK_STA_Pos = 0x12
	// Bit mask of BUSY_BANK_STA field.
	UDPHS_EPTSTA3_ISOENDPT_BUSY_BANK_STA_Msk = 0xc0000
	// 1 busy bank
	UDPHS_EPTSTA3_ISOENDPT_BUSY_BANK_STA_1BUSYBANK = 0x0
	// 2 busy banks
	UDPHS_EPTSTA3_ISOENDPT_BUSY_BANK_STA_2BUSYBANKS = 0x1
	// 3 busy banks
	UDPHS_EPTSTA3_ISOENDPT_BUSY_BANK_STA_3BUSYBANKS = 0x2
	// Position of BYTE_COUNT field.
	UDPHS_EPTSTA3_ISOENDPT_BYTE_COUNT_Pos = 0x14
	// Bit mask of BYTE_COUNT field.
	UDPHS_EPTSTA3_ISOENDPT_BYTE_COUNT_Msk = 0x7ff00000
	// Position of SHRT_PCKT field.
	UDPHS_EPTSTA3_ISOENDPT_SHRT_PCKT_Pos = 0x1f
	// Bit mask of SHRT_PCKT field.
	UDPHS_EPTSTA3_ISOENDPT_SHRT_PCKT_Msk = 0x80000000
	// Bit SHRT_PCKT.
	UDPHS_EPTSTA3_ISOENDPT_SHRT_PCKT = 0x80000000

	// EPTCFG4: UDPHS Endpoint Configuration Register (endpoint = 4)
	// Position of EPT_SIZE field.
	UDPHS_EPTCFG4_EPT_SIZE_Pos = 0x0
	// Bit mask of EPT_SIZE field.
	UDPHS_EPTCFG4_EPT_SIZE_Msk = 0x7
	// 8 bytes
	UDPHS_EPTCFG4_EPT_SIZE_8 = 0x0
	// 16 bytes
	UDPHS_EPTCFG4_EPT_SIZE_16 = 0x1
	// 32 bytes
	UDPHS_EPTCFG4_EPT_SIZE_32 = 0x2
	// 64 bytes
	UDPHS_EPTCFG4_EPT_SIZE_64 = 0x3
	// 128 bytes
	UDPHS_EPTCFG4_EPT_SIZE_128 = 0x4
	// 256 bytes
	UDPHS_EPTCFG4_EPT_SIZE_256 = 0x5
	// 512 bytes
	UDPHS_EPTCFG4_EPT_SIZE_512 = 0x6
	// 1024 bytes
	UDPHS_EPTCFG4_EPT_SIZE_1024 = 0x7
	// Position of EPT_DIR field.
	UDPHS_EPTCFG4_EPT_DIR_Pos = 0x3
	// Bit mask of EPT_DIR field.
	UDPHS_EPTCFG4_EPT_DIR_Msk = 0x8
	// Bit EPT_DIR.
	UDPHS_EPTCFG4_EPT_DIR = 0x8
	// Position of EPT_TYPE field.
	UDPHS_EPTCFG4_EPT_TYPE_Pos = 0x4
	// Bit mask of EPT_TYPE field.
	UDPHS_EPTCFG4_EPT_TYPE_Msk = 0x30
	// Control endpoint
	UDPHS_EPTCFG4_EPT_TYPE_CTRL8 = 0x0
	// Isochronous endpoint
	UDPHS_EPTCFG4_EPT_TYPE_ISO = 0x1
	// Bulk endpoint
	UDPHS_EPTCFG4_EPT_TYPE_BULK = 0x2
	// Interrupt endpoint
	UDPHS_EPTCFG4_EPT_TYPE_INT = 0x3
	// Position of BK_NUMBER field.
	UDPHS_EPTCFG4_BK_NUMBER_Pos = 0x6
	// Bit mask of BK_NUMBER field.
	UDPHS_EPTCFG4_BK_NUMBER_Msk = 0xc0
	// Zero bank, the endpoint is not mapped in memory
	UDPHS_EPTCFG4_BK_NUMBER_0 = 0x0
	// One bank (bank 0)
	UDPHS_EPTCFG4_BK_NUMBER_1 = 0x1
	// Double bank (Ping-Pong: bank0/bank1)
	UDPHS_EPTCFG4_BK_NUMBER_2 = 0x2
	// Triple bank (bank0/bank1/bank2)
	UDPHS_EPTCFG4_BK_NUMBER_3 = 0x3
	// Position of NB_TRANS field.
	UDPHS_EPTCFG4_NB_TRANS_Pos = 0x8
	// Bit mask of NB_TRANS field.
	UDPHS_EPTCFG4_NB_TRANS_Msk = 0x300
	// Position of EPT_MAPD field.
	UDPHS_EPTCFG4_EPT_MAPD_Pos = 0x1f
	// Bit mask of EPT_MAPD field.
	UDPHS_EPTCFG4_EPT_MAPD_Msk = 0x80000000
	// Bit EPT_MAPD.
	UDPHS_EPTCFG4_EPT_MAPD = 0x80000000

	// EPTCTLENB4: UDPHS Endpoint Control Enable Register (endpoint = 4)
	// Position of EPT_ENABL field.
	UDPHS_EPTCTLENB4_EPT_ENABL_Pos = 0x0
	// Bit mask of EPT_ENABL field.
	UDPHS_EPTCTLENB4_EPT_ENABL_Msk = 0x1
	// Bit EPT_ENABL.
	UDPHS_EPTCTLENB4_EPT_ENABL = 0x1
	// Position of AUTO_VALID field.
	UDPHS_EPTCTLENB4_AUTO_VALID_Pos = 0x1
	// Bit mask of AUTO_VALID field.
	UDPHS_EPTCTLENB4_AUTO_VALID_Msk = 0x2
	// Bit AUTO_VALID.
	UDPHS_EPTCTLENB4_AUTO_VALID = 0x2
	// Position of INTDIS_DMA field.
	UDPHS_EPTCTLENB4_INTDIS_DMA_Pos = 0x3
	// Bit mask of INTDIS_DMA field.
	UDPHS_EPTCTLENB4_INTDIS_DMA_Msk = 0x8
	// Bit INTDIS_DMA.
	UDPHS_EPTCTLENB4_INTDIS_DMA = 0x8
	// Position of NYET_DIS field.
	UDPHS_EPTCTLENB4_NYET_DIS_Pos = 0x4
	// Bit mask of NYET_DIS field.
	UDPHS_EPTCTLENB4_NYET_DIS_Msk = 0x10
	// Bit NYET_DIS.
	UDPHS_EPTCTLENB4_NYET_DIS = 0x10
	// Position of ERR_OVFLW field.
	UDPHS_EPTCTLENB4_ERR_OVFLW_Pos = 0x8
	// Bit mask of ERR_OVFLW field.
	UDPHS_EPTCTLENB4_ERR_OVFLW_Msk = 0x100
	// Bit ERR_OVFLW.
	UDPHS_EPTCTLENB4_ERR_OVFLW = 0x100
	// Position of RXRDY_TXKL field.
	UDPHS_EPTCTLENB4_RXRDY_TXKL_Pos = 0x9
	// Bit mask of RXRDY_TXKL field.
	UDPHS_EPTCTLENB4_RXRDY_TXKL_Msk = 0x200
	// Bit RXRDY_TXKL.
	UDPHS_EPTCTLENB4_RXRDY_TXKL = 0x200
	// Position of TX_COMPLT field.
	UDPHS_EPTCTLENB4_TX_COMPLT_Pos = 0xa
	// Bit mask of TX_COMPLT field.
	UDPHS_EPTCTLENB4_TX_COMPLT_Msk = 0x400
	// Bit TX_COMPLT.
	UDPHS_EPTCTLENB4_TX_COMPLT = 0x400
	// Position of TXRDY field.
	UDPHS_EPTCTLENB4_TXRDY_Pos = 0xb
	// Bit mask of TXRDY field.
	UDPHS_EPTCTLENB4_TXRDY_Msk = 0x800
	// Bit TXRDY.
	UDPHS_EPTCTLENB4_TXRDY = 0x800
	// Position of RX_SETUP field.
	UDPHS_EPTCTLENB4_RX_SETUP_Pos = 0xc
	// Bit mask of RX_SETUP field.
	UDPHS_EPTCTLENB4_RX_SETUP_Msk = 0x1000
	// Bit RX_SETUP.
	UDPHS_EPTCTLENB4_RX_SETUP = 0x1000
	// Position of STALL_SNT field.
	UDPHS_EPTCTLENB4_STALL_SNT_Pos = 0xd
	// Bit mask of STALL_SNT field.
	UDPHS_EPTCTLENB4_STALL_SNT_Msk = 0x2000
	// Bit STALL_SNT.
	UDPHS_EPTCTLENB4_STALL_SNT = 0x2000
	// Position of NAK_IN field.
	UDPHS_EPTCTLENB4_NAK_IN_Pos = 0xe
	// Bit mask of NAK_IN field.
	UDPHS_EPTCTLENB4_NAK_IN_Msk = 0x4000
	// Bit NAK_IN.
	UDPHS_EPTCTLENB4_NAK_IN = 0x4000
	// Position of NAK_OUT field.
	UDPHS_EPTCTLENB4_NAK_OUT_Pos = 0xf
	// Bit mask of NAK_OUT field.
	UDPHS_EPTCTLENB4_NAK_OUT_Msk = 0x8000
	// Bit NAK_OUT.
	UDPHS_EPTCTLENB4_NAK_OUT = 0x8000
	// Position of BUSY_BANK field.
	UDPHS_EPTCTLENB4_BUSY_BANK_Pos = 0x12
	// Bit mask of BUSY_BANK field.
	UDPHS_EPTCTLENB4_BUSY_BANK_Msk = 0x40000
	// Bit BUSY_BANK.
	UDPHS_EPTCTLENB4_BUSY_BANK = 0x40000
	// Position of SHRT_PCKT field.
	UDPHS_EPTCTLENB4_SHRT_PCKT_Pos = 0x1f
	// Bit mask of SHRT_PCKT field.
	UDPHS_EPTCTLENB4_SHRT_PCKT_Msk = 0x80000000
	// Bit SHRT_PCKT.
	UDPHS_EPTCTLENB4_SHRT_PCKT = 0x80000000

	// EPTCTLENB4_ISOENDPT: UDPHS Endpoint Control Enable Register (endpoint = 4)
	// Position of EPT_ENABL field.
	UDPHS_EPTCTLENB4_ISOENDPT_EPT_ENABL_Pos = 0x0
	// Bit mask of EPT_ENABL field.
	UDPHS_EPTCTLENB4_ISOENDPT_EPT_ENABL_Msk = 0x1
	// Bit EPT_ENABL.
	UDPHS_EPTCTLENB4_ISOENDPT_EPT_ENABL = 0x1
	// Position of AUTO_VALID field.
	UDPHS_EPTCTLENB4_ISOENDPT_AUTO_VALID_Pos = 0x1
	// Bit mask of AUTO_VALID field.
	UDPHS_EPTCTLENB4_ISOENDPT_AUTO_VALID_Msk = 0x2
	// Bit AUTO_VALID.
	UDPHS_EPTCTLENB4_ISOENDPT_AUTO_VALID = 0x2
	// Position of INTDIS_DMA field.
	UDPHS_EPTCTLENB4_ISOENDPT_INTDIS_DMA_Pos = 0x3
	// Bit mask of INTDIS_DMA field.
	UDPHS_EPTCTLENB4_ISOENDPT_INTDIS_DMA_Msk = 0x8
	// Bit INTDIS_DMA.
	UDPHS_EPTCTLENB4_ISOENDPT_INTDIS_DMA = 0x8
	// Position of DATAX_RX field.
	UDPHS_EPTCTLENB4_ISOENDPT_DATAX_RX_Pos = 0x6
	// Bit mask of DATAX_RX field.
	UDPHS_EPTCTLENB4_ISOENDPT_DATAX_RX_Msk = 0x40
	// Bit DATAX_RX.
	UDPHS_EPTCTLENB4_ISOENDPT_DATAX_RX = 0x40
	// Position of MDATA_RX field.
	UDPHS_EPTCTLENB4_ISOENDPT_MDATA_RX_Pos = 0x7
	// Bit mask of MDATA_RX field.
	UDPHS_EPTCTLENB4_ISOENDPT_MDATA_RX_Msk = 0x80
	// Bit MDATA_RX.
	UDPHS_EPTCTLENB4_ISOENDPT_MDATA_RX = 0x80
	// Position of ERR_OVFLW field.
	UDPHS_EPTCTLENB4_ISOENDPT_ERR_OVFLW_Pos = 0x8
	// Bit mask of ERR_OVFLW field.
	UDPHS_EPTCTLENB4_ISOENDPT_ERR_OVFLW_Msk = 0x100
	// Bit ERR_OVFLW.
	UDPHS_EPTCTLENB4_ISOENDPT_ERR_OVFLW = 0x100
	// Position of RXRDY_TXKL field.
	UDPHS_EPTCTLENB4_ISOENDPT_RXRDY_TXKL_Pos = 0x9
	// Bit mask of RXRDY_TXKL field.
	UDPHS_EPTCTLENB4_ISOENDPT_RXRDY_TXKL_Msk = 0x200
	// Bit RXRDY_TXKL.
	UDPHS_EPTCTLENB4_ISOENDPT_RXRDY_TXKL = 0x200
	// Position of TX_COMPLT field.
	UDPHS_EPTCTLENB4_ISOENDPT_TX_COMPLT_Pos = 0xa
	// Bit mask of TX_COMPLT field.
	UDPHS_EPTCTLENB4_ISOENDPT_TX_COMPLT_Msk = 0x400
	// Bit TX_COMPLT.
	UDPHS_EPTCTLENB4_ISOENDPT_TX_COMPLT = 0x400
	// Position of TXRDY_TRER field.
	UDPHS_EPTCTLENB4_ISOENDPT_TXRDY_TRER_Pos = 0xb
	// Bit mask of TXRDY_TRER field.
	UDPHS_EPTCTLENB4_ISOENDPT_TXRDY_TRER_Msk = 0x800
	// Bit TXRDY_TRER.
	UDPHS_EPTCTLENB4_ISOENDPT_TXRDY_TRER = 0x800
	// Position of ERR_FL_ISO field.
	UDPHS_EPTCTLENB4_ISOENDPT_ERR_FL_ISO_Pos = 0xc
	// Bit mask of ERR_FL_ISO field.
	UDPHS_EPTCTLENB4_ISOENDPT_ERR_FL_ISO_Msk = 0x1000
	// Bit ERR_FL_ISO.
	UDPHS_EPTCTLENB4_ISOENDPT_ERR_FL_ISO = 0x1000
	// Position of ERR_CRC_NTR field.
	UDPHS_EPTCTLENB4_ISOENDPT_ERR_CRC_NTR_Pos = 0xd
	// Bit mask of ERR_CRC_NTR field.
	UDPHS_EPTCTLENB4_ISOENDPT_ERR_CRC_NTR_Msk = 0x2000
	// Bit ERR_CRC_NTR.
	UDPHS_EPTCTLENB4_ISOENDPT_ERR_CRC_NTR = 0x2000
	// Position of ERR_FLUSH field.
	UDPHS_EPTCTLENB4_ISOENDPT_ERR_FLUSH_Pos = 0xe
	// Bit mask of ERR_FLUSH field.
	UDPHS_EPTCTLENB4_ISOENDPT_ERR_FLUSH_Msk = 0x4000
	// Bit ERR_FLUSH.
	UDPHS_EPTCTLENB4_ISOENDPT_ERR_FLUSH = 0x4000
	// Position of BUSY_BANK field.
	UDPHS_EPTCTLENB4_ISOENDPT_BUSY_BANK_Pos = 0x12
	// Bit mask of BUSY_BANK field.
	UDPHS_EPTCTLENB4_ISOENDPT_BUSY_BANK_Msk = 0x40000
	// Bit BUSY_BANK.
	UDPHS_EPTCTLENB4_ISOENDPT_BUSY_BANK = 0x40000
	// Position of SHRT_PCKT field.
	UDPHS_EPTCTLENB4_ISOENDPT_SHRT_PCKT_Pos = 0x1f
	// Bit mask of SHRT_PCKT field.
	UDPHS_EPTCTLENB4_ISOENDPT_SHRT_PCKT_Msk = 0x80000000
	// Bit SHRT_PCKT.
	UDPHS_EPTCTLENB4_ISOENDPT_SHRT_PCKT = 0x80000000

	// EPTCTLDIS4: UDPHS Endpoint Control Disable Register (endpoint = 4)
	// Position of EPT_DISABL field.
	UDPHS_EPTCTLDIS4_EPT_DISABL_Pos = 0x0
	// Bit mask of EPT_DISABL field.
	UDPHS_EPTCTLDIS4_EPT_DISABL_Msk = 0x1
	// Bit EPT_DISABL.
	UDPHS_EPTCTLDIS4_EPT_DISABL = 0x1
	// Position of AUTO_VALID field.
	UDPHS_EPTCTLDIS4_AUTO_VALID_Pos = 0x1
	// Bit mask of AUTO_VALID field.
	UDPHS_EPTCTLDIS4_AUTO_VALID_Msk = 0x2
	// Bit AUTO_VALID.
	UDPHS_EPTCTLDIS4_AUTO_VALID = 0x2
	// Position of INTDIS_DMA field.
	UDPHS_EPTCTLDIS4_INTDIS_DMA_Pos = 0x3
	// Bit mask of INTDIS_DMA field.
	UDPHS_EPTCTLDIS4_INTDIS_DMA_Msk = 0x8
	// Bit INTDIS_DMA.
	UDPHS_EPTCTLDIS4_INTDIS_DMA = 0x8
	// Position of NYET_DIS field.
	UDPHS_EPTCTLDIS4_NYET_DIS_Pos = 0x4
	// Bit mask of NYET_DIS field.
	UDPHS_EPTCTLDIS4_NYET_DIS_Msk = 0x10
	// Bit NYET_DIS.
	UDPHS_EPTCTLDIS4_NYET_DIS = 0x10
	// Position of ERR_OVFLW field.
	UDPHS_EPTCTLDIS4_ERR_OVFLW_Pos = 0x8
	// Bit mask of ERR_OVFLW field.
	UDPHS_EPTCTLDIS4_ERR_OVFLW_Msk = 0x100
	// Bit ERR_OVFLW.
	UDPHS_EPTCTLDIS4_ERR_OVFLW = 0x100
	// Position of RXRDY_TXKL field.
	UDPHS_EPTCTLDIS4_RXRDY_TXKL_Pos = 0x9
	// Bit mask of RXRDY_TXKL field.
	UDPHS_EPTCTLDIS4_RXRDY_TXKL_Msk = 0x200
	// Bit RXRDY_TXKL.
	UDPHS_EPTCTLDIS4_RXRDY_TXKL = 0x200
	// Position of TX_COMPLT field.
	UDPHS_EPTCTLDIS4_TX_COMPLT_Pos = 0xa
	// Bit mask of TX_COMPLT field.
	UDPHS_EPTCTLDIS4_TX_COMPLT_Msk = 0x400
	// Bit TX_COMPLT.
	UDPHS_EPTCTLDIS4_TX_COMPLT = 0x400
	// Position of TXRDY field.
	UDPHS_EPTCTLDIS4_TXRDY_Pos = 0xb
	// Bit mask of TXRDY field.
	UDPHS_EPTCTLDIS4_TXRDY_Msk = 0x800
	// Bit TXRDY.
	UDPHS_EPTCTLDIS4_TXRDY = 0x800
	// Position of RX_SETUP field.
	UDPHS_EPTCTLDIS4_RX_SETUP_Pos = 0xc
	// Bit mask of RX_SETUP field.
	UDPHS_EPTCTLDIS4_RX_SETUP_Msk = 0x1000
	// Bit RX_SETUP.
	UDPHS_EPTCTLDIS4_RX_SETUP = 0x1000
	// Position of STALL_SNT field.
	UDPHS_EPTCTLDIS4_STALL_SNT_Pos = 0xd
	// Bit mask of STALL_SNT field.
	UDPHS_EPTCTLDIS4_STALL_SNT_Msk = 0x2000
	// Bit STALL_SNT.
	UDPHS_EPTCTLDIS4_STALL_SNT = 0x2000
	// Position of NAK_IN field.
	UDPHS_EPTCTLDIS4_NAK_IN_Pos = 0xe
	// Bit mask of NAK_IN field.
	UDPHS_EPTCTLDIS4_NAK_IN_Msk = 0x4000
	// Bit NAK_IN.
	UDPHS_EPTCTLDIS4_NAK_IN = 0x4000
	// Position of NAK_OUT field.
	UDPHS_EPTCTLDIS4_NAK_OUT_Pos = 0xf
	// Bit mask of NAK_OUT field.
	UDPHS_EPTCTLDIS4_NAK_OUT_Msk = 0x8000
	// Bit NAK_OUT.
	UDPHS_EPTCTLDIS4_NAK_OUT = 0x8000
	// Position of BUSY_BANK field.
	UDPHS_EPTCTLDIS4_BUSY_BANK_Pos = 0x12
	// Bit mask of BUSY_BANK field.
	UDPHS_EPTCTLDIS4_BUSY_BANK_Msk = 0x40000
	// Bit BUSY_BANK.
	UDPHS_EPTCTLDIS4_BUSY_BANK = 0x40000
	// Position of SHRT_PCKT field.
	UDPHS_EPTCTLDIS4_SHRT_PCKT_Pos = 0x1f
	// Bit mask of SHRT_PCKT field.
	UDPHS_EPTCTLDIS4_SHRT_PCKT_Msk = 0x80000000
	// Bit SHRT_PCKT.
	UDPHS_EPTCTLDIS4_SHRT_PCKT = 0x80000000

	// EPTCTLDIS4_ISOENDPT: UDPHS Endpoint Control Disable Register (endpoint = 4)
	// Position of EPT_DISABL field.
	UDPHS_EPTCTLDIS4_ISOENDPT_EPT_DISABL_Pos = 0x0
	// Bit mask of EPT_DISABL field.
	UDPHS_EPTCTLDIS4_ISOENDPT_EPT_DISABL_Msk = 0x1
	// Bit EPT_DISABL.
	UDPHS_EPTCTLDIS4_ISOENDPT_EPT_DISABL = 0x1
	// Position of AUTO_VALID field.
	UDPHS_EPTCTLDIS4_ISOENDPT_AUTO_VALID_Pos = 0x1
	// Bit mask of AUTO_VALID field.
	UDPHS_EPTCTLDIS4_ISOENDPT_AUTO_VALID_Msk = 0x2
	// Bit AUTO_VALID.
	UDPHS_EPTCTLDIS4_ISOENDPT_AUTO_VALID = 0x2
	// Position of INTDIS_DMA field.
	UDPHS_EPTCTLDIS4_ISOENDPT_INTDIS_DMA_Pos = 0x3
	// Bit mask of INTDIS_DMA field.
	UDPHS_EPTCTLDIS4_ISOENDPT_INTDIS_DMA_Msk = 0x8
	// Bit INTDIS_DMA.
	UDPHS_EPTCTLDIS4_ISOENDPT_INTDIS_DMA = 0x8
	// Position of DATAX_RX field.
	UDPHS_EPTCTLDIS4_ISOENDPT_DATAX_RX_Pos = 0x6
	// Bit mask of DATAX_RX field.
	UDPHS_EPTCTLDIS4_ISOENDPT_DATAX_RX_Msk = 0x40
	// Bit DATAX_RX.
	UDPHS_EPTCTLDIS4_ISOENDPT_DATAX_RX = 0x40
	// Position of MDATA_RX field.
	UDPHS_EPTCTLDIS4_ISOENDPT_MDATA_RX_Pos = 0x7
	// Bit mask of MDATA_RX field.
	UDPHS_EPTCTLDIS4_ISOENDPT_MDATA_RX_Msk = 0x80
	// Bit MDATA_RX.
	UDPHS_EPTCTLDIS4_ISOENDPT_MDATA_RX = 0x80
	// Position of ERR_OVFLW field.
	UDPHS_EPTCTLDIS4_ISOENDPT_ERR_OVFLW_Pos = 0x8
	// Bit mask of ERR_OVFLW field.
	UDPHS_EPTCTLDIS4_ISOENDPT_ERR_OVFLW_Msk = 0x100
	// Bit ERR_OVFLW.
	UDPHS_EPTCTLDIS4_ISOENDPT_ERR_OVFLW = 0x100
	// Position of RXRDY_TXKL field.
	UDPHS_EPTCTLDIS4_ISOENDPT_RXRDY_TXKL_Pos = 0x9
	// Bit mask of RXRDY_TXKL field.
	UDPHS_EPTCTLDIS4_ISOENDPT_RXRDY_TXKL_Msk = 0x200
	// Bit RXRDY_TXKL.
	UDPHS_EPTCTLDIS4_ISOENDPT_RXRDY_TXKL = 0x200
	// Position of TX_COMPLT field.
	UDPHS_EPTCTLDIS4_ISOENDPT_TX_COMPLT_Pos = 0xa
	// Bit mask of TX_COMPLT field.
	UDPHS_EPTCTLDIS4_ISOENDPT_TX_COMPLT_Msk = 0x400
	// Bit TX_COMPLT.
	UDPHS_EPTCTLDIS4_ISOENDPT_TX_COMPLT = 0x400
	// Position of TXRDY_TRER field.
	UDPHS_EPTCTLDIS4_ISOENDPT_TXRDY_TRER_Pos = 0xb
	// Bit mask of TXRDY_TRER field.
	UDPHS_EPTCTLDIS4_ISOENDPT_TXRDY_TRER_Msk = 0x800
	// Bit TXRDY_TRER.
	UDPHS_EPTCTLDIS4_ISOENDPT_TXRDY_TRER = 0x800
	// Position of ERR_FL_ISO field.
	UDPHS_EPTCTLDIS4_ISOENDPT_ERR_FL_ISO_Pos = 0xc
	// Bit mask of ERR_FL_ISO field.
	UDPHS_EPTCTLDIS4_ISOENDPT_ERR_FL_ISO_Msk = 0x1000
	// Bit ERR_FL_ISO.
	UDPHS_EPTCTLDIS4_ISOENDPT_ERR_FL_ISO = 0x1000
	// Position of ERR_CRC_NTR field.
	UDPHS_EPTCTLDIS4_ISOENDPT_ERR_CRC_NTR_Pos = 0xd
	// Bit mask of ERR_CRC_NTR field.
	UDPHS_EPTCTLDIS4_ISOENDPT_ERR_CRC_NTR_Msk = 0x2000
	// Bit ERR_CRC_NTR.
	UDPHS_EPTCTLDIS4_ISOENDPT_ERR_CRC_NTR = 0x2000
	// Position of ERR_FLUSH field.
	UDPHS_EPTCTLDIS4_ISOENDPT_ERR_FLUSH_Pos = 0xe
	// Bit mask of ERR_FLUSH field.
	UDPHS_EPTCTLDIS4_ISOENDPT_ERR_FLUSH_Msk = 0x4000
	// Bit ERR_FLUSH.
	UDPHS_EPTCTLDIS4_ISOENDPT_ERR_FLUSH = 0x4000
	// Position of BUSY_BANK field.
	UDPHS_EPTCTLDIS4_ISOENDPT_BUSY_BANK_Pos = 0x12
	// Bit mask of BUSY_BANK field.
	UDPHS_EPTCTLDIS4_ISOENDPT_BUSY_BANK_Msk = 0x40000
	// Bit BUSY_BANK.
	UDPHS_EPTCTLDIS4_ISOENDPT_BUSY_BANK = 0x40000
	// Position of SHRT_PCKT field.
	UDPHS_EPTCTLDIS4_ISOENDPT_SHRT_PCKT_Pos = 0x1f
	// Bit mask of SHRT_PCKT field.
	UDPHS_EPTCTLDIS4_ISOENDPT_SHRT_PCKT_Msk = 0x80000000
	// Bit SHRT_PCKT.
	UDPHS_EPTCTLDIS4_ISOENDPT_SHRT_PCKT = 0x80000000

	// EPTCTL4: UDPHS Endpoint Control Register (endpoint = 4)
	// Position of EPT_ENABL field.
	UDPHS_EPTCTL4_EPT_ENABL_Pos = 0x0
	// Bit mask of EPT_ENABL field.
	UDPHS_EPTCTL4_EPT_ENABL_Msk = 0x1
	// Bit EPT_ENABL.
	UDPHS_EPTCTL4_EPT_ENABL = 0x1
	// Position of AUTO_VALID field.
	UDPHS_EPTCTL4_AUTO_VALID_Pos = 0x1
	// Bit mask of AUTO_VALID field.
	UDPHS_EPTCTL4_AUTO_VALID_Msk = 0x2
	// Bit AUTO_VALID.
	UDPHS_EPTCTL4_AUTO_VALID = 0x2
	// Position of INTDIS_DMA field.
	UDPHS_EPTCTL4_INTDIS_DMA_Pos = 0x3
	// Bit mask of INTDIS_DMA field.
	UDPHS_EPTCTL4_INTDIS_DMA_Msk = 0x8
	// Bit INTDIS_DMA.
	UDPHS_EPTCTL4_INTDIS_DMA = 0x8
	// Position of NYET_DIS field.
	UDPHS_EPTCTL4_NYET_DIS_Pos = 0x4
	// Bit mask of NYET_DIS field.
	UDPHS_EPTCTL4_NYET_DIS_Msk = 0x10
	// Bit NYET_DIS.
	UDPHS_EPTCTL4_NYET_DIS = 0x10
	// Position of ERR_OVFLW field.
	UDPHS_EPTCTL4_ERR_OVFLW_Pos = 0x8
	// Bit mask of ERR_OVFLW field.
	UDPHS_EPTCTL4_ERR_OVFLW_Msk = 0x100
	// Bit ERR_OVFLW.
	UDPHS_EPTCTL4_ERR_OVFLW = 0x100
	// Position of RXRDY_TXKL field.
	UDPHS_EPTCTL4_RXRDY_TXKL_Pos = 0x9
	// Bit mask of RXRDY_TXKL field.
	UDPHS_EPTCTL4_RXRDY_TXKL_Msk = 0x200
	// Bit RXRDY_TXKL.
	UDPHS_EPTCTL4_RXRDY_TXKL = 0x200
	// Position of TX_COMPLT field.
	UDPHS_EPTCTL4_TX_COMPLT_Pos = 0xa
	// Bit mask of TX_COMPLT field.
	UDPHS_EPTCTL4_TX_COMPLT_Msk = 0x400
	// Bit TX_COMPLT.
	UDPHS_EPTCTL4_TX_COMPLT = 0x400
	// Position of TXRDY field.
	UDPHS_EPTCTL4_TXRDY_Pos = 0xb
	// Bit mask of TXRDY field.
	UDPHS_EPTCTL4_TXRDY_Msk = 0x800
	// Bit TXRDY.
	UDPHS_EPTCTL4_TXRDY = 0x800
	// Position of RX_SETUP field.
	UDPHS_EPTCTL4_RX_SETUP_Pos = 0xc
	// Bit mask of RX_SETUP field.
	UDPHS_EPTCTL4_RX_SETUP_Msk = 0x1000
	// Bit RX_SETUP.
	UDPHS_EPTCTL4_RX_SETUP = 0x1000
	// Position of STALL_SNT field.
	UDPHS_EPTCTL4_STALL_SNT_Pos = 0xd
	// Bit mask of STALL_SNT field.
	UDPHS_EPTCTL4_STALL_SNT_Msk = 0x2000
	// Bit STALL_SNT.
	UDPHS_EPTCTL4_STALL_SNT = 0x2000
	// Position of NAK_IN field.
	UDPHS_EPTCTL4_NAK_IN_Pos = 0xe
	// Bit mask of NAK_IN field.
	UDPHS_EPTCTL4_NAK_IN_Msk = 0x4000
	// Bit NAK_IN.
	UDPHS_EPTCTL4_NAK_IN = 0x4000
	// Position of NAK_OUT field.
	UDPHS_EPTCTL4_NAK_OUT_Pos = 0xf
	// Bit mask of NAK_OUT field.
	UDPHS_EPTCTL4_NAK_OUT_Msk = 0x8000
	// Bit NAK_OUT.
	UDPHS_EPTCTL4_NAK_OUT = 0x8000
	// Position of BUSY_BANK field.
	UDPHS_EPTCTL4_BUSY_BANK_Pos = 0x12
	// Bit mask of BUSY_BANK field.
	UDPHS_EPTCTL4_BUSY_BANK_Msk = 0x40000
	// Bit BUSY_BANK.
	UDPHS_EPTCTL4_BUSY_BANK = 0x40000
	// Position of SHRT_PCKT field.
	UDPHS_EPTCTL4_SHRT_PCKT_Pos = 0x1f
	// Bit mask of SHRT_PCKT field.
	UDPHS_EPTCTL4_SHRT_PCKT_Msk = 0x80000000
	// Bit SHRT_PCKT.
	UDPHS_EPTCTL4_SHRT_PCKT = 0x80000000

	// EPTCTL4_ISOENDPT: UDPHS Endpoint Control Register (endpoint = 4)
	// Position of EPT_ENABL field.
	UDPHS_EPTCTL4_ISOENDPT_EPT_ENABL_Pos = 0x0
	// Bit mask of EPT_ENABL field.
	UDPHS_EPTCTL4_ISOENDPT_EPT_ENABL_Msk = 0x1
	// Bit EPT_ENABL.
	UDPHS_EPTCTL4_ISOENDPT_EPT_ENABL = 0x1
	// Position of AUTO_VALID field.
	UDPHS_EPTCTL4_ISOENDPT_AUTO_VALID_Pos = 0x1
	// Bit mask of AUTO_VALID field.
	UDPHS_EPTCTL4_ISOENDPT_AUTO_VALID_Msk = 0x2
	// Bit AUTO_VALID.
	UDPHS_EPTCTL4_ISOENDPT_AUTO_VALID = 0x2
	// Position of INTDIS_DMA field.
	UDPHS_EPTCTL4_ISOENDPT_INTDIS_DMA_Pos = 0x3
	// Bit mask of INTDIS_DMA field.
	UDPHS_EPTCTL4_ISOENDPT_INTDIS_DMA_Msk = 0x8
	// Bit INTDIS_DMA.
	UDPHS_EPTCTL4_ISOENDPT_INTDIS_DMA = 0x8
	// Position of DATAX_RX field.
	UDPHS_EPTCTL4_ISOENDPT_DATAX_RX_Pos = 0x6
	// Bit mask of DATAX_RX field.
	UDPHS_EPTCTL4_ISOENDPT_DATAX_RX_Msk = 0x40
	// Bit DATAX_RX.
	UDPHS_EPTCTL4_ISOENDPT_DATAX_RX = 0x40
	// Position of MDATA_RX field.
	UDPHS_EPTCTL4_ISOENDPT_MDATA_RX_Pos = 0x7
	// Bit mask of MDATA_RX field.
	UDPHS_EPTCTL4_ISOENDPT_MDATA_RX_Msk = 0x80
	// Bit MDATA_RX.
	UDPHS_EPTCTL4_ISOENDPT_MDATA_RX = 0x80
	// Position of ERR_OVFLW field.
	UDPHS_EPTCTL4_ISOENDPT_ERR_OVFLW_Pos = 0x8
	// Bit mask of ERR_OVFLW field.
	UDPHS_EPTCTL4_ISOENDPT_ERR_OVFLW_Msk = 0x100
	// Bit ERR_OVFLW.
	UDPHS_EPTCTL4_ISOENDPT_ERR_OVFLW = 0x100
	// Position of RXRDY_TXKL field.
	UDPHS_EPTCTL4_ISOENDPT_RXRDY_TXKL_Pos = 0x9
	// Bit mask of RXRDY_TXKL field.
	UDPHS_EPTCTL4_ISOENDPT_RXRDY_TXKL_Msk = 0x200
	// Bit RXRDY_TXKL.
	UDPHS_EPTCTL4_ISOENDPT_RXRDY_TXKL = 0x200
	// Position of TX_COMPLT field.
	UDPHS_EPTCTL4_ISOENDPT_TX_COMPLT_Pos = 0xa
	// Bit mask of TX_COMPLT field.
	UDPHS_EPTCTL4_ISOENDPT_TX_COMPLT_Msk = 0x400
	// Bit TX_COMPLT.
	UDPHS_EPTCTL4_ISOENDPT_TX_COMPLT = 0x400
	// Position of TXRDY_TRER field.
	UDPHS_EPTCTL4_ISOENDPT_TXRDY_TRER_Pos = 0xb
	// Bit mask of TXRDY_TRER field.
	UDPHS_EPTCTL4_ISOENDPT_TXRDY_TRER_Msk = 0x800
	// Bit TXRDY_TRER.
	UDPHS_EPTCTL4_ISOENDPT_TXRDY_TRER = 0x800
	// Position of ERR_FL_ISO field.
	UDPHS_EPTCTL4_ISOENDPT_ERR_FL_ISO_Pos = 0xc
	// Bit mask of ERR_FL_ISO field.
	UDPHS_EPTCTL4_ISOENDPT_ERR_FL_ISO_Msk = 0x1000
	// Bit ERR_FL_ISO.
	UDPHS_EPTCTL4_ISOENDPT_ERR_FL_ISO = 0x1000
	// Position of ERR_CRC_NTR field.
	UDPHS_EPTCTL4_ISOENDPT_ERR_CRC_NTR_Pos = 0xd
	// Bit mask of ERR_CRC_NTR field.
	UDPHS_EPTCTL4_ISOENDPT_ERR_CRC_NTR_Msk = 0x2000
	// Bit ERR_CRC_NTR.
	UDPHS_EPTCTL4_ISOENDPT_ERR_CRC_NTR = 0x2000
	// Position of ERR_FLUSH field.
	UDPHS_EPTCTL4_ISOENDPT_ERR_FLUSH_Pos = 0xe
	// Bit mask of ERR_FLUSH field.
	UDPHS_EPTCTL4_ISOENDPT_ERR_FLUSH_Msk = 0x4000
	// Bit ERR_FLUSH.
	UDPHS_EPTCTL4_ISOENDPT_ERR_FLUSH = 0x4000
	// Position of BUSY_BANK field.
	UDPHS_EPTCTL4_ISOENDPT_BUSY_BANK_Pos = 0x12
	// Bit mask of BUSY_BANK field.
	UDPHS_EPTCTL4_ISOENDPT_BUSY_BANK_Msk = 0x40000
	// Bit BUSY_BANK.
	UDPHS_EPTCTL4_ISOENDPT_BUSY_BANK = 0x40000
	// Position of SHRT_PCKT field.
	UDPHS_EPTCTL4_ISOENDPT_SHRT_PCKT_Pos = 0x1f
	// Bit mask of SHRT_PCKT field.
	UDPHS_EPTCTL4_ISOENDPT_SHRT_PCKT_Msk = 0x80000000
	// Bit SHRT_PCKT.
	UDPHS_EPTCTL4_ISOENDPT_SHRT_PCKT = 0x80000000

	// EPTSETSTA4: UDPHS Endpoint Set Status Register (endpoint = 4)
	// Position of FRCESTALL field.
	UDPHS_EPTSETSTA4_FRCESTALL_Pos = 0x5
	// Bit mask of FRCESTALL field.
	UDPHS_EPTSETSTA4_FRCESTALL_Msk = 0x20
	// Bit FRCESTALL.
	UDPHS_EPTSETSTA4_FRCESTALL = 0x20
	// Position of RXRDY_TXKL field.
	UDPHS_EPTSETSTA4_RXRDY_TXKL_Pos = 0x9
	// Bit mask of RXRDY_TXKL field.
	UDPHS_EPTSETSTA4_RXRDY_TXKL_Msk = 0x200
	// Bit RXRDY_TXKL.
	UDPHS_EPTSETSTA4_RXRDY_TXKL = 0x200
	// Position of TXRDY field.
	UDPHS_EPTSETSTA4_TXRDY_Pos = 0xb
	// Bit mask of TXRDY field.
	UDPHS_EPTSETSTA4_TXRDY_Msk = 0x800
	// Bit TXRDY.
	UDPHS_EPTSETSTA4_TXRDY = 0x800

	// EPTSETSTA4_ISOENDPT: UDPHS Endpoint Set Status Register (endpoint = 4)
	// Position of RXRDY_TXKL field.
	UDPHS_EPTSETSTA4_ISOENDPT_RXRDY_TXKL_Pos = 0x9
	// Bit mask of RXRDY_TXKL field.
	UDPHS_EPTSETSTA4_ISOENDPT_RXRDY_TXKL_Msk = 0x200
	// Bit RXRDY_TXKL.
	UDPHS_EPTSETSTA4_ISOENDPT_RXRDY_TXKL = 0x200
	// Position of TXRDY_TRER field.
	UDPHS_EPTSETSTA4_ISOENDPT_TXRDY_TRER_Pos = 0xb
	// Bit mask of TXRDY_TRER field.
	UDPHS_EPTSETSTA4_ISOENDPT_TXRDY_TRER_Msk = 0x800
	// Bit TXRDY_TRER.
	UDPHS_EPTSETSTA4_ISOENDPT_TXRDY_TRER = 0x800

	// EPTCLRSTA4: UDPHS Endpoint Clear Status Register (endpoint = 4)
	// Position of FRCESTALL field.
	UDPHS_EPTCLRSTA4_FRCESTALL_Pos = 0x5
	// Bit mask of FRCESTALL field.
	UDPHS_EPTCLRSTA4_FRCESTALL_Msk = 0x20
	// Bit FRCESTALL.
	UDPHS_EPTCLRSTA4_FRCESTALL = 0x20
	// Position of TOGGLESQ field.
	UDPHS_EPTCLRSTA4_TOGGLESQ_Pos = 0x6
	// Bit mask of TOGGLESQ field.
	UDPHS_EPTCLRSTA4_TOGGLESQ_Msk = 0x40
	// Bit TOGGLESQ.
	UDPHS_EPTCLRSTA4_TOGGLESQ = 0x40
	// Position of RXRDY_TXKL field.
	UDPHS_EPTCLRSTA4_RXRDY_TXKL_Pos = 0x9
	// Bit mask of RXRDY_TXKL field.
	UDPHS_EPTCLRSTA4_RXRDY_TXKL_Msk = 0x200
	// Bit RXRDY_TXKL.
	UDPHS_EPTCLRSTA4_RXRDY_TXKL = 0x200
	// Position of TX_COMPLT field.
	UDPHS_EPTCLRSTA4_TX_COMPLT_Pos = 0xa
	// Bit mask of TX_COMPLT field.
	UDPHS_EPTCLRSTA4_TX_COMPLT_Msk = 0x400
	// Bit TX_COMPLT.
	UDPHS_EPTCLRSTA4_TX_COMPLT = 0x400
	// Position of RX_SETUP field.
	UDPHS_EPTCLRSTA4_RX_SETUP_Pos = 0xc
	// Bit mask of RX_SETUP field.
	UDPHS_EPTCLRSTA4_RX_SETUP_Msk = 0x1000
	// Bit RX_SETUP.
	UDPHS_EPTCLRSTA4_RX_SETUP = 0x1000
	// Position of STALL_SNT field.
	UDPHS_EPTCLRSTA4_STALL_SNT_Pos = 0xd
	// Bit mask of STALL_SNT field.
	UDPHS_EPTCLRSTA4_STALL_SNT_Msk = 0x2000
	// Bit STALL_SNT.
	UDPHS_EPTCLRSTA4_STALL_SNT = 0x2000
	// Position of NAK_IN field.
	UDPHS_EPTCLRSTA4_NAK_IN_Pos = 0xe
	// Bit mask of NAK_IN field.
	UDPHS_EPTCLRSTA4_NAK_IN_Msk = 0x4000
	// Bit NAK_IN.
	UDPHS_EPTCLRSTA4_NAK_IN = 0x4000
	// Position of NAK_OUT field.
	UDPHS_EPTCLRSTA4_NAK_OUT_Pos = 0xf
	// Bit mask of NAK_OUT field.
	UDPHS_EPTCLRSTA4_NAK_OUT_Msk = 0x8000
	// Bit NAK_OUT.
	UDPHS_EPTCLRSTA4_NAK_OUT = 0x8000

	// EPTCLRSTA4_ISOENDPT: UDPHS Endpoint Clear Status Register (endpoint = 4)
	// Position of TOGGLESQ field.
	UDPHS_EPTCLRSTA4_ISOENDPT_TOGGLESQ_Pos = 0x6
	// Bit mask of TOGGLESQ field.
	UDPHS_EPTCLRSTA4_ISOENDPT_TOGGLESQ_Msk = 0x40
	// Bit TOGGLESQ.
	UDPHS_EPTCLRSTA4_ISOENDPT_TOGGLESQ = 0x40
	// Position of RXRDY_TXKL field.
	UDPHS_EPTCLRSTA4_ISOENDPT_RXRDY_TXKL_Pos = 0x9
	// Bit mask of RXRDY_TXKL field.
	UDPHS_EPTCLRSTA4_ISOENDPT_RXRDY_TXKL_Msk = 0x200
	// Bit RXRDY_TXKL.
	UDPHS_EPTCLRSTA4_ISOENDPT_RXRDY_TXKL = 0x200
	// Position of TX_COMPLT field.
	UDPHS_EPTCLRSTA4_ISOENDPT_TX_COMPLT_Pos = 0xa
	// Bit mask of TX_COMPLT field.
	UDPHS_EPTCLRSTA4_ISOENDPT_TX_COMPLT_Msk = 0x400
	// Bit TX_COMPLT.
	UDPHS_EPTCLRSTA4_ISOENDPT_TX_COMPLT = 0x400
	// Position of ERR_FL_ISO field.
	UDPHS_EPTCLRSTA4_ISOENDPT_ERR_FL_ISO_Pos = 0xc
	// Bit mask of ERR_FL_ISO field.
	UDPHS_EPTCLRSTA4_ISOENDPT_ERR_FL_ISO_Msk = 0x1000
	// Bit ERR_FL_ISO.
	UDPHS_EPTCLRSTA4_ISOENDPT_ERR_FL_ISO = 0x1000
	// Position of ERR_CRC_NTR field.
	UDPHS_EPTCLRSTA4_ISOENDPT_ERR_CRC_NTR_Pos = 0xd
	// Bit mask of ERR_CRC_NTR field.
	UDPHS_EPTCLRSTA4_ISOENDPT_ERR_CRC_NTR_Msk = 0x2000
	// Bit ERR_CRC_NTR.
	UDPHS_EPTCLRSTA4_ISOENDPT_ERR_CRC_NTR = 0x2000
	// Position of ERR_FLUSH field.
	UDPHS_EPTCLRSTA4_ISOENDPT_ERR_FLUSH_Pos = 0xe
	// Bit mask of ERR_FLUSH field.
	UDPHS_EPTCLRSTA4_ISOENDPT_ERR_FLUSH_Msk = 0x4000
	// Bit ERR_FLUSH.
	UDPHS_EPTCLRSTA4_ISOENDPT_ERR_FLUSH = 0x4000

	// EPTSTA4: UDPHS Endpoint Status Register (endpoint = 4)
	// Position of FRCESTALL field.
	UDPHS_EPTSTA4_FRCESTALL_Pos = 0x5
	// Bit mask of FRCESTALL field.
	UDPHS_EPTSTA4_FRCESTALL_Msk = 0x20
	// Bit FRCESTALL.
	UDPHS_EPTSTA4_FRCESTALL = 0x20
	// Position of TOGGLESQ_STA field.
	UDPHS_EPTSTA4_TOGGLESQ_STA_Pos = 0x6
	// Bit mask of TOGGLESQ_STA field.
	UDPHS_EPTSTA4_TOGGLESQ_STA_Msk = 0xc0
	// DATA0
	UDPHS_EPTSTA4_TOGGLESQ_STA_DATA0 = 0x0
	// DATA1
	UDPHS_EPTSTA4_TOGGLESQ_STA_DATA1 = 0x1
	// Reserved for High Bandwidth Isochronous Endpoint
	UDPHS_EPTSTA4_TOGGLESQ_STA_DATA2 = 0x2
	// Reserved for High Bandwidth Isochronous Endpoint
	UDPHS_EPTSTA4_TOGGLESQ_STA_MDATA = 0x3
	// Position of ERR_OVFLW field.
	UDPHS_EPTSTA4_ERR_OVFLW_Pos = 0x8
	// Bit mask of ERR_OVFLW field.
	UDPHS_EPTSTA4_ERR_OVFLW_Msk = 0x100
	// Bit ERR_OVFLW.
	UDPHS_EPTSTA4_ERR_OVFLW = 0x100
	// Position of RXRDY_TXKL field.
	UDPHS_EPTSTA4_RXRDY_TXKL_Pos = 0x9
	// Bit mask of RXRDY_TXKL field.
	UDPHS_EPTSTA4_RXRDY_TXKL_Msk = 0x200
	// Bit RXRDY_TXKL.
	UDPHS_EPTSTA4_RXRDY_TXKL = 0x200
	// Position of TX_COMPLT field.
	UDPHS_EPTSTA4_TX_COMPLT_Pos = 0xa
	// Bit mask of TX_COMPLT field.
	UDPHS_EPTSTA4_TX_COMPLT_Msk = 0x400
	// Bit TX_COMPLT.
	UDPHS_EPTSTA4_TX_COMPLT = 0x400
	// Position of TXRDY field.
	UDPHS_EPTSTA4_TXRDY_Pos = 0xb
	// Bit mask of TXRDY field.
	UDPHS_EPTSTA4_TXRDY_Msk = 0x800
	// Bit TXRDY.
	UDPHS_EPTSTA4_TXRDY = 0x800
	// Position of RX_SETUP field.
	UDPHS_EPTSTA4_RX_SETUP_Pos = 0xc
	// Bit mask of RX_SETUP field.
	UDPHS_EPTSTA4_RX_SETUP_Msk = 0x1000
	// Bit RX_SETUP.
	UDPHS_EPTSTA4_RX_SETUP = 0x1000
	// Position of STALL_SNT field.
	UDPHS_EPTSTA4_STALL_SNT_Pos = 0xd
	// Bit mask of STALL_SNT field.
	UDPHS_EPTSTA4_STALL_SNT_Msk = 0x2000
	// Bit STALL_SNT.
	UDPHS_EPTSTA4_STALL_SNT = 0x2000
	// Position of NAK_IN field.
	UDPHS_EPTSTA4_NAK_IN_Pos = 0xe
	// Bit mask of NAK_IN field.
	UDPHS_EPTSTA4_NAK_IN_Msk = 0x4000
	// Bit NAK_IN.
	UDPHS_EPTSTA4_NAK_IN = 0x4000
	// Position of NAK_OUT field.
	UDPHS_EPTSTA4_NAK_OUT_Pos = 0xf
	// Bit mask of NAK_OUT field.
	UDPHS_EPTSTA4_NAK_OUT_Msk = 0x8000
	// Bit NAK_OUT.
	UDPHS_EPTSTA4_NAK_OUT = 0x8000
	// Position of CURBK_CTLDIR field.
	UDPHS_EPTSTA4_CURBK_CTLDIR_Pos = 0x10
	// Bit mask of CURBK_CTLDIR field.
	UDPHS_EPTSTA4_CURBK_CTLDIR_Msk = 0x30000
	// Position of BUSY_BANK_STA field.
	UDPHS_EPTSTA4_BUSY_BANK_STA_Pos = 0x12
	// Bit mask of BUSY_BANK_STA field.
	UDPHS_EPTSTA4_BUSY_BANK_STA_Msk = 0xc0000
	// 1 busy bank
	UDPHS_EPTSTA4_BUSY_BANK_STA_1BUSYBANK = 0x0
	// 2 busy banks
	UDPHS_EPTSTA4_BUSY_BANK_STA_2BUSYBANKS = 0x1
	// 3 busy banks
	UDPHS_EPTSTA4_BUSY_BANK_STA_3BUSYBANKS = 0x2
	// Position of BYTE_COUNT field.
	UDPHS_EPTSTA4_BYTE_COUNT_Pos = 0x14
	// Bit mask of BYTE_COUNT field.
	UDPHS_EPTSTA4_BYTE_COUNT_Msk = 0x7ff00000
	// Position of SHRT_PCKT field.
	UDPHS_EPTSTA4_SHRT_PCKT_Pos = 0x1f
	// Bit mask of SHRT_PCKT field.
	UDPHS_EPTSTA4_SHRT_PCKT_Msk = 0x80000000
	// Bit SHRT_PCKT.
	UDPHS_EPTSTA4_SHRT_PCKT = 0x80000000

	// EPTSTA4_ISOENDPT: UDPHS Endpoint Status Register (endpoint = 4)
	// Position of TOGGLESQ_STA field.
	UDPHS_EPTSTA4_ISOENDPT_TOGGLESQ_STA_Pos = 0x6
	// Bit mask of TOGGLESQ_STA field.
	UDPHS_EPTSTA4_ISOENDPT_TOGGLESQ_STA_Msk = 0xc0
	// DATA0
	UDPHS_EPTSTA4_ISOENDPT_TOGGLESQ_STA_DATA0 = 0x0
	// DATA1
	UDPHS_EPTSTA4_ISOENDPT_TOGGLESQ_STA_DATA1 = 0x1
	// Data2 (only for High Bandwidth Isochronous Endpoint)
	UDPHS_EPTSTA4_ISOENDPT_TOGGLESQ_STA_DATA2 = 0x2
	// MData (only for High Bandwidth Isochronous Endpoint)
	UDPHS_EPTSTA4_ISOENDPT_TOGGLESQ_STA_MDATA = 0x3
	// Position of ERR_OVFLW field.
	UDPHS_EPTSTA4_ISOENDPT_ERR_OVFLW_Pos = 0x8
	// Bit mask of ERR_OVFLW field.
	UDPHS_EPTSTA4_ISOENDPT_ERR_OVFLW_Msk = 0x100
	// Bit ERR_OVFLW.
	UDPHS_EPTSTA4_ISOENDPT_ERR_OVFLW = 0x100
	// Position of RXRDY_TXKL field.
	UDPHS_EPTSTA4_ISOENDPT_RXRDY_TXKL_Pos = 0x9
	// Bit mask of RXRDY_TXKL field.
	UDPHS_EPTSTA4_ISOENDPT_RXRDY_TXKL_Msk = 0x200
	// Bit RXRDY_TXKL.
	UDPHS_EPTSTA4_ISOENDPT_RXRDY_TXKL = 0x200
	// Position of TX_COMPLT field.
	UDPHS_EPTSTA4_ISOENDPT_TX_COMPLT_Pos = 0xa
	// Bit mask of TX_COMPLT field.
	UDPHS_EPTSTA4_ISOENDPT_TX_COMPLT_Msk = 0x400
	// Bit TX_COMPLT.
	UDPHS_EPTSTA4_ISOENDPT_TX_COMPLT = 0x400
	// Position of TXRDY_TRER field.
	UDPHS_EPTSTA4_ISOENDPT_TXRDY_TRER_Pos = 0xb
	// Bit mask of TXRDY_TRER field.
	UDPHS_EPTSTA4_ISOENDPT_TXRDY_TRER_Msk = 0x800
	// Bit TXRDY_TRER.
	UDPHS_EPTSTA4_ISOENDPT_TXRDY_TRER = 0x800
	// Position of ERR_FL_ISO field.
	UDPHS_EPTSTA4_ISOENDPT_ERR_FL_ISO_Pos = 0xc
	// Bit mask of ERR_FL_ISO field.
	UDPHS_EPTSTA4_ISOENDPT_ERR_FL_ISO_Msk = 0x1000
	// Bit ERR_FL_ISO.
	UDPHS_EPTSTA4_ISOENDPT_ERR_FL_ISO = 0x1000
	// Position of ERR_CRC_NTR field.
	UDPHS_EPTSTA4_ISOENDPT_ERR_CRC_NTR_Pos = 0xd
	// Bit mask of ERR_CRC_NTR field.
	UDPHS_EPTSTA4_ISOENDPT_ERR_CRC_NTR_Msk = 0x2000
	// Bit ERR_CRC_NTR.
	UDPHS_EPTSTA4_ISOENDPT_ERR_CRC_NTR = 0x2000
	// Position of ERR_FLUSH field.
	UDPHS_EPTSTA4_ISOENDPT_ERR_FLUSH_Pos = 0xe
	// Bit mask of ERR_FLUSH field.
	UDPHS_EPTSTA4_ISOENDPT_ERR_FLUSH_Msk = 0x4000
	// Bit ERR_FLUSH.
	UDPHS_EPTSTA4_ISOENDPT_ERR_FLUSH = 0x4000
	// Position of CURBK field.
	UDPHS_EPTSTA4_ISOENDPT_CURBK_Pos = 0x10
	// Bit mask of CURBK field.
	UDPHS_EPTSTA4_ISOENDPT_CURBK_Msk = 0x30000
	// Bank 0 (or single bank)
	UDPHS_EPTSTA4_ISOENDPT_CURBK_BANK0 = 0x0
	// Bank 1
	UDPHS_EPTSTA4_ISOENDPT_CURBK_BANK1 = 0x1
	// Bank 2
	UDPHS_EPTSTA4_ISOENDPT_CURBK_BANK2 = 0x2
	// Position of BUSY_BANK_STA field.
	UDPHS_EPTSTA4_ISOENDPT_BUSY_BANK_STA_Pos = 0x12
	// Bit mask of BUSY_BANK_STA field.
	UDPHS_EPTSTA4_ISOENDPT_BUSY_BANK_STA_Msk = 0xc0000
	// 1 busy bank
	UDPHS_EPTSTA4_ISOENDPT_BUSY_BANK_STA_1BUSYBANK = 0x0
	// 2 busy banks
	UDPHS_EPTSTA4_ISOENDPT_BUSY_BANK_STA_2BUSYBANKS = 0x1
	// 3 busy banks
	UDPHS_EPTSTA4_ISOENDPT_BUSY_BANK_STA_3BUSYBANKS = 0x2
	// Position of BYTE_COUNT field.
	UDPHS_EPTSTA4_ISOENDPT_BYTE_COUNT_Pos = 0x14
	// Bit mask of BYTE_COUNT field.
	UDPHS_EPTSTA4_ISOENDPT_BYTE_COUNT_Msk = 0x7ff00000
	// Position of SHRT_PCKT field.
	UDPHS_EPTSTA4_ISOENDPT_SHRT_PCKT_Pos = 0x1f
	// Bit mask of SHRT_PCKT field.
	UDPHS_EPTSTA4_ISOENDPT_SHRT_PCKT_Msk = 0x80000000
	// Bit SHRT_PCKT.
	UDPHS_EPTSTA4_ISOENDPT_SHRT_PCKT = 0x80000000

	// EPTCFG5: UDPHS Endpoint Configuration Register (endpoint = 5)
	// Position of EPT_SIZE field.
	UDPHS_EPTCFG5_EPT_SIZE_Pos = 0x0
	// Bit mask of EPT_SIZE field.
	UDPHS_EPTCFG5_EPT_SIZE_Msk = 0x7
	// 8 bytes
	UDPHS_EPTCFG5_EPT_SIZE_8 = 0x0
	// 16 bytes
	UDPHS_EPTCFG5_EPT_SIZE_16 = 0x1
	// 32 bytes
	UDPHS_EPTCFG5_EPT_SIZE_32 = 0x2
	// 64 bytes
	UDPHS_EPTCFG5_EPT_SIZE_64 = 0x3
	// 128 bytes
	UDPHS_EPTCFG5_EPT_SIZE_128 = 0x4
	// 256 bytes
	UDPHS_EPTCFG5_EPT_SIZE_256 = 0x5
	// 512 bytes
	UDPHS_EPTCFG5_EPT_SIZE_512 = 0x6
	// 1024 bytes
	UDPHS_EPTCFG5_EPT_SIZE_1024 = 0x7
	// Position of EPT_DIR field.
	UDPHS_EPTCFG5_EPT_DIR_Pos = 0x3
	// Bit mask of EPT_DIR field.
	UDPHS_EPTCFG5_EPT_DIR_Msk = 0x8
	// Bit EPT_DIR.
	UDPHS_EPTCFG5_EPT_DIR = 0x8
	// Position of EPT_TYPE field.
	UDPHS_EPTCFG5_EPT_TYPE_Pos = 0x4
	// Bit mask of EPT_TYPE field.
	UDPHS_EPTCFG5_EPT_TYPE_Msk = 0x30
	// Control endpoint
	UDPHS_EPTCFG5_EPT_TYPE_CTRL8 = 0x0
	// Isochronous endpoint
	UDPHS_EPTCFG5_EPT_TYPE_ISO = 0x1
	// Bulk endpoint
	UDPHS_EPTCFG5_EPT_TYPE_BULK = 0x2
	// Interrupt endpoint
	UDPHS_EPTCFG5_EPT_TYPE_INT = 0x3
	// Position of BK_NUMBER field.
	UDPHS_EPTCFG5_BK_NUMBER_Pos = 0x6
	// Bit mask of BK_NUMBER field.
	UDPHS_EPTCFG5_BK_NUMBER_Msk = 0xc0
	// Zero bank, the endpoint is not mapped in memory
	UDPHS_EPTCFG5_BK_NUMBER_0 = 0x0
	// One bank (bank 0)
	UDPHS_EPTCFG5_BK_NUMBER_1 = 0x1
	// Double bank (Ping-Pong: bank0/bank1)
	UDPHS_EPTCFG5_BK_NUMBER_2 = 0x2
	// Triple bank (bank0/bank1/bank2)
	UDPHS_EPTCFG5_BK_NUMBER_3 = 0x3
	// Position of NB_TRANS field.
	UDPHS_EPTCFG5_NB_TRANS_Pos = 0x8
	// Bit mask of NB_TRANS field.
	UDPHS_EPTCFG5_NB_TRANS_Msk = 0x300
	// Position of EPT_MAPD field.
	UDPHS_EPTCFG5_EPT_MAPD_Pos = 0x1f
	// Bit mask of EPT_MAPD field.
	UDPHS_EPTCFG5_EPT_MAPD_Msk = 0x80000000
	// Bit EPT_MAPD.
	UDPHS_EPTCFG5_EPT_MAPD = 0x80000000

	// EPTCTLENB5: UDPHS Endpoint Control Enable Register (endpoint = 5)
	// Position of EPT_ENABL field.
	UDPHS_EPTCTLENB5_EPT_ENABL_Pos = 0x0
	// Bit mask of EPT_ENABL field.
	UDPHS_EPTCTLENB5_EPT_ENABL_Msk = 0x1
	// Bit EPT_ENABL.
	UDPHS_EPTCTLENB5_EPT_ENABL = 0x1
	// Position of AUTO_VALID field.
	UDPHS_EPTCTLENB5_AUTO_VALID_Pos = 0x1
	// Bit mask of AUTO_VALID field.
	UDPHS_EPTCTLENB5_AUTO_VALID_Msk = 0x2
	// Bit AUTO_VALID.
	UDPHS_EPTCTLENB5_AUTO_VALID = 0x2
	// Position of INTDIS_DMA field.
	UDPHS_EPTCTLENB5_INTDIS_DMA_Pos = 0x3
	// Bit mask of INTDIS_DMA field.
	UDPHS_EPTCTLENB5_INTDIS_DMA_Msk = 0x8
	// Bit INTDIS_DMA.
	UDPHS_EPTCTLENB5_INTDIS_DMA = 0x8
	// Position of NYET_DIS field.
	UDPHS_EPTCTLENB5_NYET_DIS_Pos = 0x4
	// Bit mask of NYET_DIS field.
	UDPHS_EPTCTLENB5_NYET_DIS_Msk = 0x10
	// Bit NYET_DIS.
	UDPHS_EPTCTLENB5_NYET_DIS = 0x10
	// Position of ERR_OVFLW field.
	UDPHS_EPTCTLENB5_ERR_OVFLW_Pos = 0x8
	// Bit mask of ERR_OVFLW field.
	UDPHS_EPTCTLENB5_ERR_OVFLW_Msk = 0x100
	// Bit ERR_OVFLW.
	UDPHS_EPTCTLENB5_ERR_OVFLW = 0x100
	// Position of RXRDY_TXKL field.
	UDPHS_EPTCTLENB5_RXRDY_TXKL_Pos = 0x9
	// Bit mask of RXRDY_TXKL field.
	UDPHS_EPTCTLENB5_RXRDY_TXKL_Msk = 0x200
	// Bit RXRDY_TXKL.
	UDPHS_EPTCTLENB5_RXRDY_TXKL = 0x200
	// Position of TX_COMPLT field.
	UDPHS_EPTCTLENB5_TX_COMPLT_Pos = 0xa
	// Bit mask of TX_COMPLT field.
	UDPHS_EPTCTLENB5_TX_COMPLT_Msk = 0x400
	// Bit TX_COMPLT.
	UDPHS_EPTCTLENB5_TX_COMPLT = 0x400
	// Position of TXRDY field.
	UDPHS_EPTCTLENB5_TXRDY_Pos = 0xb
	// Bit mask of TXRDY field.
	UDPHS_EPTCTLENB5_TXRDY_Msk = 0x800
	// Bit TXRDY.
	UDPHS_EPTCTLENB5_TXRDY = 0x800
	// Position of RX_SETUP field.
	UDPHS_EPTCTLENB5_RX_SETUP_Pos = 0xc
	// Bit mask of RX_SETUP field.
	UDPHS_EPTCTLENB5_RX_SETUP_Msk = 0x1000
	// Bit RX_SETUP.
	UDPHS_EPTCTLENB5_RX_SETUP = 0x1000
	// Position of STALL_SNT field.
	UDPHS_EPTCTLENB5_STALL_SNT_Pos = 0xd
	// Bit mask of STALL_SNT field.
	UDPHS_EPTCTLENB5_STALL_SNT_Msk = 0x2000
	// Bit STALL_SNT.
	UDPHS_EPTCTLENB5_STALL_SNT = 0x2000
	// Position of NAK_IN field.
	UDPHS_EPTCTLENB5_NAK_IN_Pos = 0xe
	// Bit mask of NAK_IN field.
	UDPHS_EPTCTLENB5_NAK_IN_Msk = 0x4000
	// Bit NAK_IN.
	UDPHS_EPTCTLENB5_NAK_IN = 0x4000
	// Position of NAK_OUT field.
	UDPHS_EPTCTLENB5_NAK_OUT_Pos = 0xf
	// Bit mask of NAK_OUT field.
	UDPHS_EPTCTLENB5_NAK_OUT_Msk = 0x8000
	// Bit NAK_OUT.
	UDPHS_EPTCTLENB5_NAK_OUT = 0x8000
	// Position of BUSY_BANK field.
	UDPHS_EPTCTLENB5_BUSY_BANK_Pos = 0x12
	// Bit mask of BUSY_BANK field.
	UDPHS_EPTCTLENB5_BUSY_BANK_Msk = 0x40000
	// Bit BUSY_BANK.
	UDPHS_EPTCTLENB5_BUSY_BANK = 0x40000
	// Position of SHRT_PCKT field.
	UDPHS_EPTCTLENB5_SHRT_PCKT_Pos = 0x1f
	// Bit mask of SHRT_PCKT field.
	UDPHS_EPTCTLENB5_SHRT_PCKT_Msk = 0x80000000
	// Bit SHRT_PCKT.
	UDPHS_EPTCTLENB5_SHRT_PCKT = 0x80000000

	// EPTCTLENB5_ISOENDPT: UDPHS Endpoint Control Enable Register (endpoint = 5)
	// Position of EPT_ENABL field.
	UDPHS_EPTCTLENB5_ISOENDPT_EPT_ENABL_Pos = 0x0
	// Bit mask of EPT_ENABL field.
	UDPHS_EPTCTLENB5_ISOENDPT_EPT_ENABL_Msk = 0x1
	// Bit EPT_ENABL.
	UDPHS_EPTCTLENB5_ISOENDPT_EPT_ENABL = 0x1
	// Position of AUTO_VALID field.
	UDPHS_EPTCTLENB5_ISOENDPT_AUTO_VALID_Pos = 0x1
	// Bit mask of AUTO_VALID field.
	UDPHS_EPTCTLENB5_ISOENDPT_AUTO_VALID_Msk = 0x2
	// Bit AUTO_VALID.
	UDPHS_EPTCTLENB5_ISOENDPT_AUTO_VALID = 0x2
	// Position of INTDIS_DMA field.
	UDPHS_EPTCTLENB5_ISOENDPT_INTDIS_DMA_Pos = 0x3
	// Bit mask of INTDIS_DMA field.
	UDPHS_EPTCTLENB5_ISOENDPT_INTDIS_DMA_Msk = 0x8
	// Bit INTDIS_DMA.
	UDPHS_EPTCTLENB5_ISOENDPT_INTDIS_DMA = 0x8
	// Position of DATAX_RX field.
	UDPHS_EPTCTLENB5_ISOENDPT_DATAX_RX_Pos = 0x6
	// Bit mask of DATAX_RX field.
	UDPHS_EPTCTLENB5_ISOENDPT_DATAX_RX_Msk = 0x40
	// Bit DATAX_RX.
	UDPHS_EPTCTLENB5_ISOENDPT_DATAX_RX = 0x40
	// Position of MDATA_RX field.
	UDPHS_EPTCTLENB5_ISOENDPT_MDATA_RX_Pos = 0x7
	// Bit mask of MDATA_RX field.
	UDPHS_EPTCTLENB5_ISOENDPT_MDATA_RX_Msk = 0x80
	// Bit MDATA_RX.
	UDPHS_EPTCTLENB5_ISOENDPT_MDATA_RX = 0x80
	// Position of ERR_OVFLW field.
	UDPHS_EPTCTLENB5_ISOENDPT_ERR_OVFLW_Pos = 0x8
	// Bit mask of ERR_OVFLW field.
	UDPHS_EPTCTLENB5_ISOENDPT_ERR_OVFLW_Msk = 0x100
	// Bit ERR_OVFLW.
	UDPHS_EPTCTLENB5_ISOENDPT_ERR_OVFLW = 0x100
	// Position of RXRDY_TXKL field.
	UDPHS_EPTCTLENB5_ISOENDPT_RXRDY_TXKL_Pos = 0x9
	// Bit mask of RXRDY_TXKL field.
	UDPHS_EPTCTLENB5_ISOENDPT_RXRDY_TXKL_Msk = 0x200
	// Bit RXRDY_TXKL.
	UDPHS_EPTCTLENB5_ISOENDPT_RXRDY_TXKL = 0x200
	// Position of TX_COMPLT field.
	UDPHS_EPTCTLENB5_ISOENDPT_TX_COMPLT_Pos = 0xa
	// Bit mask of TX_COMPLT field.
	UDPHS_EPTCTLENB5_ISOENDPT_TX_COMPLT_Msk = 0x400
	// Bit TX_COMPLT.
	UDPHS_EPTCTLENB5_ISOENDPT_TX_COMPLT = 0x400
	// Position of TXRDY_TRER field.
	UDPHS_EPTCTLENB5_ISOENDPT_TXRDY_TRER_Pos = 0xb
	// Bit mask of TXRDY_TRER field.
	UDPHS_EPTCTLENB5_ISOENDPT_TXRDY_TRER_Msk = 0x800
	// Bit TXRDY_TRER.
	UDPHS_EPTCTLENB5_ISOENDPT_TXRDY_TRER = 0x800
	// Position of ERR_FL_ISO field.
	UDPHS_EPTCTLENB5_ISOENDPT_ERR_FL_ISO_Pos = 0xc
	// Bit mask of ERR_FL_ISO field.
	UDPHS_EPTCTLENB5_ISOENDPT_ERR_FL_ISO_Msk = 0x1000
	// Bit ERR_FL_ISO.
	UDPHS_EPTCTLENB5_ISOENDPT_ERR_FL_ISO = 0x1000
	// Position of ERR_CRC_NTR field.
	UDPHS_EPTCTLENB5_ISOENDPT_ERR_CRC_NTR_Pos = 0xd
	// Bit mask of ERR_CRC_NTR field.
	UDPHS_EPTCTLENB5_ISOENDPT_ERR_CRC_NTR_Msk = 0x2000
	// Bit ERR_CRC_NTR.
	UDPHS_EPTCTLENB5_ISOENDPT_ERR_CRC_NTR = 0x2000
	// Position of ERR_FLUSH field.
	UDPHS_EPTCTLENB5_ISOENDPT_ERR_FLUSH_Pos = 0xe
	// Bit mask of ERR_FLUSH field.
	UDPHS_EPTCTLENB5_ISOENDPT_ERR_FLUSH_Msk = 0x4000
	// Bit ERR_FLUSH.
	UDPHS_EPTCTLENB5_ISOENDPT_ERR_FLUSH = 0x4000
	// Position of BUSY_BANK field.
	UDPHS_EPTCTLENB5_ISOENDPT_BUSY_BANK_Pos = 0x12
	// Bit mask of BUSY_BANK field.
	UDPHS_EPTCTLENB5_ISOENDPT_BUSY_BANK_Msk = 0x40000
	// Bit BUSY_BANK.
	UDPHS_EPTCTLENB5_ISOENDPT_BUSY_BANK = 0x40000
	// Position of SHRT_PCKT field.
	UDPHS_EPTCTLENB5_ISOENDPT_SHRT_PCKT_Pos = 0x1f
	// Bit mask of SHRT_PCKT field.
	UDPHS_EPTCTLENB5_ISOENDPT_SHRT_PCKT_Msk = 0x80000000
	// Bit SHRT_PCKT.
	UDPHS_EPTCTLENB5_ISOENDPT_SHRT_PCKT = 0x80000000

	// EPTCTLDIS5: UDPHS Endpoint Control Disable Register (endpoint = 5)
	// Position of EPT_DISABL field.
	UDPHS_EPTCTLDIS5_EPT_DISABL_Pos = 0x0
	// Bit mask of EPT_DISABL field.
	UDPHS_EPTCTLDIS5_EPT_DISABL_Msk = 0x1
	// Bit EPT_DISABL.
	UDPHS_EPTCTLDIS5_EPT_DISABL = 0x1
	// Position of AUTO_VALID field.
	UDPHS_EPTCTLDIS5_AUTO_VALID_Pos = 0x1
	// Bit mask of AUTO_VALID field.
	UDPHS_EPTCTLDIS5_AUTO_VALID_Msk = 0x2
	// Bit AUTO_VALID.
	UDPHS_EPTCTLDIS5_AUTO_VALID = 0x2
	// Position of INTDIS_DMA field.
	UDPHS_EPTCTLDIS5_INTDIS_DMA_Pos = 0x3
	// Bit mask of INTDIS_DMA field.
	UDPHS_EPTCTLDIS5_INTDIS_DMA_Msk = 0x8
	// Bit INTDIS_DMA.
	UDPHS_EPTCTLDIS5_INTDIS_DMA = 0x8
	// Position of NYET_DIS field.
	UDPHS_EPTCTLDIS5_NYET_DIS_Pos = 0x4
	// Bit mask of NYET_DIS field.
	UDPHS_EPTCTLDIS5_NYET_DIS_Msk = 0x10
	// Bit NYET_DIS.
	UDPHS_EPTCTLDIS5_NYET_DIS = 0x10
	// Position of ERR_OVFLW field.
	UDPHS_EPTCTLDIS5_ERR_OVFLW_Pos = 0x8
	// Bit mask of ERR_OVFLW field.
	UDPHS_EPTCTLDIS5_ERR_OVFLW_Msk = 0x100
	// Bit ERR_OVFLW.
	UDPHS_EPTCTLDIS5_ERR_OVFLW = 0x100
	// Position of RXRDY_TXKL field.
	UDPHS_EPTCTLDIS5_RXRDY_TXKL_Pos = 0x9
	// Bit mask of RXRDY_TXKL field.
	UDPHS_EPTCTLDIS5_RXRDY_TXKL_Msk = 0x200
	// Bit RXRDY_TXKL.
	UDPHS_EPTCTLDIS5_RXRDY_TXKL = 0x200
	// Position of TX_COMPLT field.
	UDPHS_EPTCTLDIS5_TX_COMPLT_Pos = 0xa
	// Bit mask of TX_COMPLT field.
	UDPHS_EPTCTLDIS5_TX_COMPLT_Msk = 0x400
	// Bit TX_COMPLT.
	UDPHS_EPTCTLDIS5_TX_COMPLT = 0x400
	// Position of TXRDY field.
	UDPHS_EPTCTLDIS5_TXRDY_Pos = 0xb
	// Bit mask of TXRDY field.
	UDPHS_EPTCTLDIS5_TXRDY_Msk = 0x800
	// Bit TXRDY.
	UDPHS_EPTCTLDIS5_TXRDY = 0x800
	// Position of RX_SETUP field.
	UDPHS_EPTCTLDIS5_RX_SETUP_Pos = 0xc
	// Bit mask of RX_SETUP field.
	UDPHS_EPTCTLDIS5_RX_SETUP_Msk = 0x1000
	// Bit RX_SETUP.
	UDPHS_EPTCTLDIS5_RX_SETUP = 0x1000
	// Position of STALL_SNT field.
	UDPHS_EPTCTLDIS5_STALL_SNT_Pos = 0xd
	// Bit mask of STALL_SNT field.
	UDPHS_EPTCTLDIS5_STALL_SNT_Msk = 0x2000
	// Bit STALL_SNT.
	UDPHS_EPTCTLDIS5_STALL_SNT = 0x2000
	// Position of NAK_IN field.
	UDPHS_EPTCTLDIS5_NAK_IN_Pos = 0xe
	// Bit mask of NAK_IN field.
	UDPHS_EPTCTLDIS5_NAK_IN_Msk = 0x4000
	// Bit NAK_IN.
	UDPHS_EPTCTLDIS5_NAK_IN = 0x4000
	// Position of NAK_OUT field.
	UDPHS_EPTCTLDIS5_NAK_OUT_Pos = 0xf
	// Bit mask of NAK_OUT field.
	UDPHS_EPTCTLDIS5_NAK_OUT_Msk = 0x8000
	// Bit NAK_OUT.
	UDPHS_EPTCTLDIS5_NAK_OUT = 0x8000
	// Position of BUSY_BANK field.
	UDPHS_EPTCTLDIS5_BUSY_BANK_Pos = 0x12
	// Bit mask of BUSY_BANK field.
	UDPHS_EPTCTLDIS5_BUSY_BANK_Msk = 0x40000
	// Bit BUSY_BANK.
	UDPHS_EPTCTLDIS5_BUSY_BANK = 0x40000
	// Position of SHRT_PCKT field.
	UDPHS_EPTCTLDIS5_SHRT_PCKT_Pos = 0x1f
	// Bit mask of SHRT_PCKT field.
	UDPHS_EPTCTLDIS5_SHRT_PCKT_Msk = 0x80000000
	// Bit SHRT_PCKT.
	UDPHS_EPTCTLDIS5_SHRT_PCKT = 0x80000000

	// EPTCTLDIS5_ISOENDPT: UDPHS Endpoint Control Disable Register (endpoint = 5)
	// Position of EPT_DISABL field.
	UDPHS_EPTCTLDIS5_ISOENDPT_EPT_DISABL_Pos = 0x0
	// Bit mask of EPT_DISABL field.
	UDPHS_EPTCTLDIS5_ISOENDPT_EPT_DISABL_Msk = 0x1
	// Bit EPT_DISABL.
	UDPHS_EPTCTLDIS5_ISOENDPT_EPT_DISABL = 0x1
	// Position of AUTO_VALID field.
	UDPHS_EPTCTLDIS5_ISOENDPT_AUTO_VALID_Pos = 0x1
	// Bit mask of AUTO_VALID field.
	UDPHS_EPTCTLDIS5_ISOENDPT_AUTO_VALID_Msk = 0x2
	// Bit AUTO_VALID.
	UDPHS_EPTCTLDIS5_ISOENDPT_AUTO_VALID = 0x2
	// Position of INTDIS_DMA field.
	UDPHS_EPTCTLDIS5_ISOENDPT_INTDIS_DMA_Pos = 0x3
	// Bit mask of INTDIS_DMA field.
	UDPHS_EPTCTLDIS5_ISOENDPT_INTDIS_DMA_Msk = 0x8
	// Bit INTDIS_DMA.
	UDPHS_EPTCTLDIS5_ISOENDPT_INTDIS_DMA = 0x8
	// Position of DATAX_RX field.
	UDPHS_EPTCTLDIS5_ISOENDPT_DATAX_RX_Pos = 0x6
	// Bit mask of DATAX_RX field.
	UDPHS_EPTCTLDIS5_ISOENDPT_DATAX_RX_Msk = 0x40
	// Bit DATAX_RX.
	UDPHS_EPTCTLDIS5_ISOENDPT_DATAX_RX = 0x40
	// Position of MDATA_RX field.
	UDPHS_EPTCTLDIS5_ISOENDPT_MDATA_RX_Pos = 0x7
	// Bit mask of MDATA_RX field.
	UDPHS_EPTCTLDIS5_ISOENDPT_MDATA_RX_Msk = 0x80
	// Bit MDATA_RX.
	UDPHS_EPTCTLDIS5_ISOENDPT_MDATA_RX = 0x80
	// Position of ERR_OVFLW field.
	UDPHS_EPTCTLDIS5_ISOENDPT_ERR_OVFLW_Pos = 0x8
	// Bit mask of ERR_OVFLW field.
	UDPHS_EPTCTLDIS5_ISOENDPT_ERR_OVFLW_Msk = 0x100
	// Bit ERR_OVFLW.
	UDPHS_EPTCTLDIS5_ISOENDPT_ERR_OVFLW = 0x100
	// Position of RXRDY_TXKL field.
	UDPHS_EPTCTLDIS5_ISOENDPT_RXRDY_TXKL_Pos = 0x9
	// Bit mask of RXRDY_TXKL field.
	UDPHS_EPTCTLDIS5_ISOENDPT_RXRDY_TXKL_Msk = 0x200
	// Bit RXRDY_TXKL.
	UDPHS_EPTCTLDIS5_ISOENDPT_RXRDY_TXKL = 0x200
	// Position of TX_COMPLT field.
	UDPHS_EPTCTLDIS5_ISOENDPT_TX_COMPLT_Pos = 0xa
	// Bit mask of TX_COMPLT field.
	UDPHS_EPTCTLDIS5_ISOENDPT_TX_COMPLT_Msk = 0x400
	// Bit TX_COMPLT.
	UDPHS_EPTCTLDIS5_ISOENDPT_TX_COMPLT = 0x400
	// Position of TXRDY_TRER field.
	UDPHS_EPTCTLDIS5_ISOENDPT_TXRDY_TRER_Pos = 0xb
	// Bit mask of TXRDY_TRER field.
	UDPHS_EPTCTLDIS5_ISOENDPT_TXRDY_TRER_Msk = 0x800
	// Bit TXRDY_TRER.
	UDPHS_EPTCTLDIS5_ISOENDPT_TXRDY_TRER = 0x800
	// Position of ERR_FL_ISO field.
	UDPHS_EPTCTLDIS5_ISOENDPT_ERR_FL_ISO_Pos = 0xc
	// Bit mask of ERR_FL_ISO field.
	UDPHS_EPTCTLDIS5_ISOENDPT_ERR_FL_ISO_Msk = 0x1000
	// Bit ERR_FL_ISO.
	UDPHS_EPTCTLDIS5_ISOENDPT_ERR_FL_ISO = 0x1000
	// Position of ERR_CRC_NTR field.
	UDPHS_EPTCTLDIS5_ISOENDPT_ERR_CRC_NTR_Pos = 0xd
	// Bit mask of ERR_CRC_NTR field.
	UDPHS_EPTCTLDIS5_ISOENDPT_ERR_CRC_NTR_Msk = 0x2000
	// Bit ERR_CRC_NTR.
	UDPHS_EPTCTLDIS5_ISOENDPT_ERR_CRC_NTR = 0x2000
	// Position of ERR_FLUSH field.
	UDPHS_EPTCTLDIS5_ISOENDPT_ERR_FLUSH_Pos = 0xe
	// Bit mask of ERR_FLUSH field.
	UDPHS_EPTCTLDIS5_ISOENDPT_ERR_FLUSH_Msk = 0x4000
	// Bit ERR_FLUSH.
	UDPHS_EPTCTLDIS5_ISOENDPT_ERR_FLUSH = 0x4000
	// Position of BUSY_BANK field.
	UDPHS_EPTCTLDIS5_ISOENDPT_BUSY_BANK_Pos = 0x12
	// Bit mask of BUSY_BANK field.
	UDPHS_EPTCTLDIS5_ISOENDPT_BUSY_BANK_Msk = 0x40000
	// Bit BUSY_BANK.
	UDPHS_EPTCTLDIS5_ISOENDPT_BUSY_BANK = 0x40000
	// Position of SHRT_PCKT field.
	UDPHS_EPTCTLDIS5_ISOENDPT_SHRT_PCKT_Pos = 0x1f
	// Bit mask of SHRT_PCKT field.
	UDPHS_EPTCTLDIS5_ISOENDPT_SHRT_PCKT_Msk = 0x80000000
	// Bit SHRT_PCKT.
	UDPHS_EPTCTLDIS5_ISOENDPT_SHRT_PCKT = 0x80000000

	// EPTCTL5: UDPHS Endpoint Control Register (endpoint = 5)
	// Position of EPT_ENABL field.
	UDPHS_EPTCTL5_EPT_ENABL_Pos = 0x0
	// Bit mask of EPT_ENABL field.
	UDPHS_EPTCTL5_EPT_ENABL_Msk = 0x1
	// Bit EPT_ENABL.
	UDPHS_EPTCTL5_EPT_ENABL = 0x1
	// Position of AUTO_VALID field.
	UDPHS_EPTCTL5_AUTO_VALID_Pos = 0x1
	// Bit mask of AUTO_VALID field.
	UDPHS_EPTCTL5_AUTO_VALID_Msk = 0x2
	// Bit AUTO_VALID.
	UDPHS_EPTCTL5_AUTO_VALID = 0x2
	// Position of INTDIS_DMA field.
	UDPHS_EPTCTL5_INTDIS_DMA_Pos = 0x3
	// Bit mask of INTDIS_DMA field.
	UDPHS_EPTCTL5_INTDIS_DMA_Msk = 0x8
	// Bit INTDIS_DMA.
	UDPHS_EPTCTL5_INTDIS_DMA = 0x8
	// Position of NYET_DIS field.
	UDPHS_EPTCTL5_NYET_DIS_Pos = 0x4
	// Bit mask of NYET_DIS field.
	UDPHS_EPTCTL5_NYET_DIS_Msk = 0x10
	// Bit NYET_DIS.
	UDPHS_EPTCTL5_NYET_DIS = 0x10
	// Position of ERR_OVFLW field.
	UDPHS_EPTCTL5_ERR_OVFLW_Pos = 0x8
	// Bit mask of ERR_OVFLW field.
	UDPHS_EPTCTL5_ERR_OVFLW_Msk = 0x100
	// Bit ERR_OVFLW.
	UDPHS_EPTCTL5_ERR_OVFLW = 0x100
	// Position of RXRDY_TXKL field.
	UDPHS_EPTCTL5_RXRDY_TXKL_Pos = 0x9
	// Bit mask of RXRDY_TXKL field.
	UDPHS_EPTCTL5_RXRDY_TXKL_Msk = 0x200
	// Bit RXRDY_TXKL.
	UDPHS_EPTCTL5_RXRDY_TXKL = 0x200
	// Position of TX_COMPLT field.
	UDPHS_EPTCTL5_TX_COMPLT_Pos = 0xa
	// Bit mask of TX_COMPLT field.
	UDPHS_EPTCTL5_TX_COMPLT_Msk = 0x400
	// Bit TX_COMPLT.
	UDPHS_EPTCTL5_TX_COMPLT = 0x400
	// Position of TXRDY field.
	UDPHS_EPTCTL5_TXRDY_Pos = 0xb
	// Bit mask of TXRDY field.
	UDPHS_EPTCTL5_TXRDY_Msk = 0x800
	// Bit TXRDY.
	UDPHS_EPTCTL5_TXRDY = 0x800
	// Position of RX_SETUP field.
	UDPHS_EPTCTL5_RX_SETUP_Pos = 0xc
	// Bit mask of RX_SETUP field.
	UDPHS_EPTCTL5_RX_SETUP_Msk = 0x1000
	// Bit RX_SETUP.
	UDPHS_EPTCTL5_RX_SETUP = 0x1000
	// Position of STALL_SNT field.
	UDPHS_EPTCTL5_STALL_SNT_Pos = 0xd
	// Bit mask of STALL_SNT field.
	UDPHS_EPTCTL5_STALL_SNT_Msk = 0x2000
	// Bit STALL_SNT.
	UDPHS_EPTCTL5_STALL_SNT = 0x2000
	// Position of NAK_IN field.
	UDPHS_EPTCTL5_NAK_IN_Pos = 0xe
	// Bit mask of NAK_IN field.
	UDPHS_EPTCTL5_NAK_IN_Msk = 0x4000
	// Bit NAK_IN.
	UDPHS_EPTCTL5_NAK_IN = 0x4000
	// Position of NAK_OUT field.
	UDPHS_EPTCTL5_NAK_OUT_Pos = 0xf
	// Bit mask of NAK_OUT field.
	UDPHS_EPTCTL5_NAK_OUT_Msk = 0x8000
	// Bit NAK_OUT.
	UDPHS_EPTCTL5_NAK_OUT = 0x8000
	// Position of BUSY_BANK field.
	UDPHS_EPTCTL5_BUSY_BANK_Pos = 0x12
	// Bit mask of BUSY_BANK field.
	UDPHS_EPTCTL5_BUSY_BANK_Msk = 0x40000
	// Bit BUSY_BANK.
	UDPHS_EPTCTL5_BUSY_BANK = 0x40000
	// Position of SHRT_PCKT field.
	UDPHS_EPTCTL5_SHRT_PCKT_Pos = 0x1f
	// Bit mask of SHRT_PCKT field.
	UDPHS_EPTCTL5_SHRT_PCKT_Msk = 0x80000000
	// Bit SHRT_PCKT.
	UDPHS_EPTCTL5_SHRT_PCKT = 0x80000000

	// EPTCTL5_ISOENDPT: UDPHS Endpoint Control Register (endpoint = 5)
	// Position of EPT_ENABL field.
	UDPHS_EPTCTL5_ISOENDPT_EPT_ENABL_Pos = 0x0
	// Bit mask of EPT_ENABL field.
	UDPHS_EPTCTL5_ISOENDPT_EPT_ENABL_Msk = 0x1
	// Bit EPT_ENABL.
	UDPHS_EPTCTL5_ISOENDPT_EPT_ENABL = 0x1
	// Position of AUTO_VALID field.
	UDPHS_EPTCTL5_ISOENDPT_AUTO_VALID_Pos = 0x1
	// Bit mask of AUTO_VALID field.
	UDPHS_EPTCTL5_ISOENDPT_AUTO_VALID_Msk = 0x2
	// Bit AUTO_VALID.
	UDPHS_EPTCTL5_ISOENDPT_AUTO_VALID = 0x2
	// Position of INTDIS_DMA field.
	UDPHS_EPTCTL5_ISOENDPT_INTDIS_DMA_Pos = 0x3
	// Bit mask of INTDIS_DMA field.
	UDPHS_EPTCTL5_ISOENDPT_INTDIS_DMA_Msk = 0x8
	// Bit INTDIS_DMA.
	UDPHS_EPTCTL5_ISOENDPT_INTDIS_DMA = 0x8
	// Position of DATAX_RX field.
	UDPHS_EPTCTL5_ISOENDPT_DATAX_RX_Pos = 0x6
	// Bit mask of DATAX_RX field.
	UDPHS_EPTCTL5_ISOENDPT_DATAX_RX_Msk = 0x40
	// Bit DATAX_RX.
	UDPHS_EPTCTL5_ISOENDPT_DATAX_RX = 0x40
	// Position of MDATA_RX field.
	UDPHS_EPTCTL5_ISOENDPT_MDATA_RX_Pos = 0x7
	// Bit mask of MDATA_RX field.
	UDPHS_EPTCTL5_ISOENDPT_MDATA_RX_Msk = 0x80
	// Bit MDATA_RX.
	UDPHS_EPTCTL5_ISOENDPT_MDATA_RX = 0x80
	// Position of ERR_OVFLW field.
	UDPHS_EPTCTL5_ISOENDPT_ERR_OVFLW_Pos = 0x8
	// Bit mask of ERR_OVFLW field.
	UDPHS_EPTCTL5_ISOENDPT_ERR_OVFLW_Msk = 0x100
	// Bit ERR_OVFLW.
	UDPHS_EPTCTL5_ISOENDPT_ERR_OVFLW = 0x100
	// Position of RXRDY_TXKL field.
	UDPHS_EPTCTL5_ISOENDPT_RXRDY_TXKL_Pos = 0x9
	// Bit mask of RXRDY_TXKL field.
	UDPHS_EPTCTL5_ISOENDPT_RXRDY_TXKL_Msk = 0x200
	// Bit RXRDY_TXKL.
	UDPHS_EPTCTL5_ISOENDPT_RXRDY_TXKL = 0x200
	// Position of TX_COMPLT field.
	UDPHS_EPTCTL5_ISOENDPT_TX_COMPLT_Pos = 0xa
	// Bit mask of TX_COMPLT field.
	UDPHS_EPTCTL5_ISOENDPT_TX_COMPLT_Msk = 0x400
	// Bit TX_COMPLT.
	UDPHS_EPTCTL5_ISOENDPT_TX_COMPLT = 0x400
	// Position of TXRDY_TRER field.
	UDPHS_EPTCTL5_ISOENDPT_TXRDY_TRER_Pos = 0xb
	// Bit mask of TXRDY_TRER field.
	UDPHS_EPTCTL5_ISOENDPT_TXRDY_TRER_Msk = 0x800
	// Bit TXRDY_TRER.
	UDPHS_EPTCTL5_ISOENDPT_TXRDY_TRER = 0x800
	// Position of ERR_FL_ISO field.
	UDPHS_EPTCTL5_ISOENDPT_ERR_FL_ISO_Pos = 0xc
	// Bit mask of ERR_FL_ISO field.
	UDPHS_EPTCTL5_ISOENDPT_ERR_FL_ISO_Msk = 0x1000
	// Bit ERR_FL_ISO.
	UDPHS_EPTCTL5_ISOENDPT_ERR_FL_ISO = 0x1000
	// Position of ERR_CRC_NTR field.
	UDPHS_EPTCTL5_ISOENDPT_ERR_CRC_NTR_Pos = 0xd
	// Bit mask of ERR_CRC_NTR field.
	UDPHS_EPTCTL5_ISOENDPT_ERR_CRC_NTR_Msk = 0x2000
	// Bit ERR_CRC_NTR.
	UDPHS_EPTCTL5_ISOENDPT_ERR_CRC_NTR = 0x2000
	// Position of ERR_FLUSH field.
	UDPHS_EPTCTL5_ISOENDPT_ERR_FLUSH_Pos = 0xe
	// Bit mask of ERR_FLUSH field.
	UDPHS_EPTCTL5_ISOENDPT_ERR_FLUSH_Msk = 0x4000
	// Bit ERR_FLUSH.
	UDPHS_EPTCTL5_ISOENDPT_ERR_FLUSH = 0x4000
	// Position of BUSY_BANK field.
	UDPHS_EPTCTL5_ISOENDPT_BUSY_BANK_Pos = 0x12
	// Bit mask of BUSY_BANK field.
	UDPHS_EPTCTL5_ISOENDPT_BUSY_BANK_Msk = 0x40000
	// Bit BUSY_BANK.
	UDPHS_EPTCTL5_ISOENDPT_BUSY_BANK = 0x40000
	// Position of SHRT_PCKT field.
	UDPHS_EPTCTL5_ISOENDPT_SHRT_PCKT_Pos = 0x1f
	// Bit mask of SHRT_PCKT field.
	UDPHS_EPTCTL5_ISOENDPT_SHRT_PCKT_Msk = 0x80000000
	// Bit SHRT_PCKT.
	UDPHS_EPTCTL5_ISOENDPT_SHRT_PCKT = 0x80000000

	// EPTSETSTA5: UDPHS Endpoint Set Status Register (endpoint = 5)
	// Position of FRCESTALL field.
	UDPHS_EPTSETSTA5_FRCESTALL_Pos = 0x5
	// Bit mask of FRCESTALL field.
	UDPHS_EPTSETSTA5_FRCESTALL_Msk = 0x20
	// Bit FRCESTALL.
	UDPHS_EPTSETSTA5_FRCESTALL = 0x20
	// Position of RXRDY_TXKL field.
	UDPHS_EPTSETSTA5_RXRDY_TXKL_Pos = 0x9
	// Bit mask of RXRDY_TXKL field.
	UDPHS_EPTSETSTA5_RXRDY_TXKL_Msk = 0x200
	// Bit RXRDY_TXKL.
	UDPHS_EPTSETSTA5_RXRDY_TXKL = 0x200
	// Position of TXRDY field.
	UDPHS_EPTSETSTA5_TXRDY_Pos = 0xb
	// Bit mask of TXRDY field.
	UDPHS_EPTSETSTA5_TXRDY_Msk = 0x800
	// Bit TXRDY.
	UDPHS_EPTSETSTA5_TXRDY = 0x800

	// EPTSETSTA5_ISOENDPT: UDPHS Endpoint Set Status Register (endpoint = 5)
	// Position of RXRDY_TXKL field.
	UDPHS_EPTSETSTA5_ISOENDPT_RXRDY_TXKL_Pos = 0x9
	// Bit mask of RXRDY_TXKL field.
	UDPHS_EPTSETSTA5_ISOENDPT_RXRDY_TXKL_Msk = 0x200
	// Bit RXRDY_TXKL.
	UDPHS_EPTSETSTA5_ISOENDPT_RXRDY_TXKL = 0x200
	// Position of TXRDY_TRER field.
	UDPHS_EPTSETSTA5_ISOENDPT_TXRDY_TRER_Pos = 0xb
	// Bit mask of TXRDY_TRER field.
	UDPHS_EPTSETSTA5_ISOENDPT_TXRDY_TRER_Msk = 0x800
	// Bit TXRDY_TRER.
	UDPHS_EPTSETSTA5_ISOENDPT_TXRDY_TRER = 0x800

	// EPTCLRSTA5: UDPHS Endpoint Clear Status Register (endpoint = 5)
	// Position of FRCESTALL field.
	UDPHS_EPTCLRSTA5_FRCESTALL_Pos = 0x5
	// Bit mask of FRCESTALL field.
	UDPHS_EPTCLRSTA5_FRCESTALL_Msk = 0x20
	// Bit FRCESTALL.
	UDPHS_EPTCLRSTA5_FRCESTALL = 0x20
	// Position of TOGGLESQ field.
	UDPHS_EPTCLRSTA5_TOGGLESQ_Pos = 0x6
	// Bit mask of TOGGLESQ field.
	UDPHS_EPTCLRSTA5_TOGGLESQ_Msk = 0x40
	// Bit TOGGLESQ.
	UDPHS_EPTCLRSTA5_TOGGLESQ = 0x40
	// Position of RXRDY_TXKL field.
	UDPHS_EPTCLRSTA5_RXRDY_TXKL_Pos = 0x9
	// Bit mask of RXRDY_TXKL field.
	UDPHS_EPTCLRSTA5_RXRDY_TXKL_Msk = 0x200
	// Bit RXRDY_TXKL.
	UDPHS_EPTCLRSTA5_RXRDY_TXKL = 0x200
	// Position of TX_COMPLT field.
	UDPHS_EPTCLRSTA5_TX_COMPLT_Pos = 0xa
	// Bit mask of TX_COMPLT field.
	UDPHS_EPTCLRSTA5_TX_COMPLT_Msk = 0x400
	// Bit TX_COMPLT.
	UDPHS_EPTCLRSTA5_TX_COMPLT = 0x400
	// Position of RX_SETUP field.
	UDPHS_EPTCLRSTA5_RX_SETUP_Pos = 0xc
	// Bit mask of RX_SETUP field.
	UDPHS_EPTCLRSTA5_RX_SETUP_Msk = 0x1000
	// Bit RX_SETUP.
	UDPHS_EPTCLRSTA5_RX_SETUP = 0x1000
	// Position of STALL_SNT field.
	UDPHS_EPTCLRSTA5_STALL_SNT_Pos = 0xd
	// Bit mask of STALL_SNT field.
	UDPHS_EPTCLRSTA5_STALL_SNT_Msk = 0x2000
	// Bit STALL_SNT.
	UDPHS_EPTCLRSTA5_STALL_SNT = 0x2000
	// Position of NAK_IN field.
	UDPHS_EPTCLRSTA5_NAK_IN_Pos = 0xe
	// Bit mask of NAK_IN field.
	UDPHS_EPTCLRSTA5_NAK_IN_Msk = 0x4000
	// Bit NAK_IN.
	UDPHS_EPTCLRSTA5_NAK_IN = 0x4000
	// Position of NAK_OUT field.
	UDPHS_EPTCLRSTA5_NAK_OUT_Pos = 0xf
	// Bit mask of NAK_OUT field.
	UDPHS_EPTCLRSTA5_NAK_OUT_Msk = 0x8000
	// Bit NAK_OUT.
	UDPHS_EPTCLRSTA5_NAK_OUT = 0x8000

	// EPTCLRSTA5_ISOENDPT: UDPHS Endpoint Clear Status Register (endpoint = 5)
	// Position of TOGGLESQ field.
	UDPHS_EPTCLRSTA5_ISOENDPT_TOGGLESQ_Pos = 0x6
	// Bit mask of TOGGLESQ field.
	UDPHS_EPTCLRSTA5_ISOENDPT_TOGGLESQ_Msk = 0x40
	// Bit TOGGLESQ.
	UDPHS_EPTCLRSTA5_ISOENDPT_TOGGLESQ = 0x40
	// Position of RXRDY_TXKL field.
	UDPHS_EPTCLRSTA5_ISOENDPT_RXRDY_TXKL_Pos = 0x9
	// Bit mask of RXRDY_TXKL field.
	UDPHS_EPTCLRSTA5_ISOENDPT_RXRDY_TXKL_Msk = 0x200
	// Bit RXRDY_TXKL.
	UDPHS_EPTCLRSTA5_ISOENDPT_RXRDY_TXKL = 0x200
	// Position of TX_COMPLT field.
	UDPHS_EPTCLRSTA5_ISOENDPT_TX_COMPLT_Pos = 0xa
	// Bit mask of TX_COMPLT field.
	UDPHS_EPTCLRSTA5_ISOENDPT_TX_COMPLT_Msk = 0x400
	// Bit TX_COMPLT.
	UDPHS_EPTCLRSTA5_ISOENDPT_TX_COMPLT = 0x400
	// Position of ERR_FL_ISO field.
	UDPHS_EPTCLRSTA5_ISOENDPT_ERR_FL_ISO_Pos = 0xc
	// Bit mask of ERR_FL_ISO field.
	UDPHS_EPTCLRSTA5_ISOENDPT_ERR_FL_ISO_Msk = 0x1000
	// Bit ERR_FL_ISO.
	UDPHS_EPTCLRSTA5_ISOENDPT_ERR_FL_ISO = 0x1000
	// Position of ERR_CRC_NTR field.
	UDPHS_EPTCLRSTA5_ISOENDPT_ERR_CRC_NTR_Pos = 0xd
	// Bit mask of ERR_CRC_NTR field.
	UDPHS_EPTCLRSTA5_ISOENDPT_ERR_CRC_NTR_Msk = 0x2000
	// Bit ERR_CRC_NTR.
	UDPHS_EPTCLRSTA5_ISOENDPT_ERR_CRC_NTR = 0x2000
	// Position of ERR_FLUSH field.
	UDPHS_EPTCLRSTA5_ISOENDPT_ERR_FLUSH_Pos = 0xe
	// Bit mask of ERR_FLUSH field.
	UDPHS_EPTCLRSTA5_ISOENDPT_ERR_FLUSH_Msk = 0x4000
	// Bit ERR_FLUSH.
	UDPHS_EPTCLRSTA5_ISOENDPT_ERR_FLUSH = 0x4000

	// EPTSTA5: UDPHS Endpoint Status Register (endpoint = 5)
	// Position of FRCESTALL field.
	UDPHS_EPTSTA5_FRCESTALL_Pos = 0x5
	// Bit mask of FRCESTALL field.
	UDPHS_EPTSTA5_FRCESTALL_Msk = 0x20
	// Bit FRCESTALL.
	UDPHS_EPTSTA5_FRCESTALL = 0x20
	// Position of TOGGLESQ_STA field.
	UDPHS_EPTSTA5_TOGGLESQ_STA_Pos = 0x6
	// Bit mask of TOGGLESQ_STA field.
	UDPHS_EPTSTA5_TOGGLESQ_STA_Msk = 0xc0
	// DATA0
	UDPHS_EPTSTA5_TOGGLESQ_STA_DATA0 = 0x0
	// DATA1
	UDPHS_EPTSTA5_TOGGLESQ_STA_DATA1 = 0x1
	// Reserved for High Bandwidth Isochronous Endpoint
	UDPHS_EPTSTA5_TOGGLESQ_STA_DATA2 = 0x2
	// Reserved for High Bandwidth Isochronous Endpoint
	UDPHS_EPTSTA5_TOGGLESQ_STA_MDATA = 0x3
	// Position of ERR_OVFLW field.
	UDPHS_EPTSTA5_ERR_OVFLW_Pos = 0x8
	// Bit mask of ERR_OVFLW field.
	UDPHS_EPTSTA5_ERR_OVFLW_Msk = 0x100
	// Bit ERR_OVFLW.
	UDPHS_EPTSTA5_ERR_OVFLW = 0x100
	// Position of RXRDY_TXKL field.
	UDPHS_EPTSTA5_RXRDY_TXKL_Pos = 0x9
	// Bit mask of RXRDY_TXKL field.
	UDPHS_EPTSTA5_RXRDY_TXKL_Msk = 0x200
	// Bit RXRDY_TXKL.
	UDPHS_EPTSTA5_RXRDY_TXKL = 0x200
	// Position of TX_COMPLT field.
	UDPHS_EPTSTA5_TX_COMPLT_Pos = 0xa
	// Bit mask of TX_COMPLT field.
	UDPHS_EPTSTA5_TX_COMPLT_Msk = 0x400
	// Bit TX_COMPLT.
	UDPHS_EPTSTA5_TX_COMPLT = 0x400
	// Position of TXRDY field.
	UDPHS_EPTSTA5_TXRDY_Pos = 0xb
	// Bit mask of TXRDY field.
	UDPHS_EPTSTA5_TXRDY_Msk = 0x800
	// Bit TXRDY.
	UDPHS_EPTSTA5_TXRDY = 0x800
	// Position of RX_SETUP field.
	UDPHS_EPTSTA5_RX_SETUP_Pos = 0xc
	// Bit mask of RX_SETUP field.
	UDPHS_EPTSTA5_RX_SETUP_Msk = 0x1000
	// Bit RX_SETUP.
	UDPHS_EPTSTA5_RX_SETUP = 0x1000
	// Position of STALL_SNT field.
	UDPHS_EPTSTA5_STALL_SNT_Pos = 0xd
	// Bit mask of STALL_SNT field.
	UDPHS_EPTSTA5_STALL_SNT_Msk = 0x2000
	// Bit STALL_SNT.
	UDPHS_EPTSTA5_STALL_SNT = 0x2000
	// Position of NAK_IN field.
	UDPHS_EPTSTA5_NAK_IN_Pos = 0xe
	// Bit mask of NAK_IN field.
	UDPHS_EPTSTA5_NAK_IN_Msk = 0x4000
	// Bit NAK_IN.
	UDPHS_EPTSTA5_NAK_IN = 0x4000
	// Position of NAK_OUT field.
	UDPHS_EPTSTA5_NAK_OUT_Pos = 0xf
	// Bit mask of NAK_OUT field.
	UDPHS_EPTSTA5_NAK_OUT_Msk = 0x8000
	// Bit NAK_OUT.
	UDPHS_EPTSTA5_NAK_OUT = 0x8000
	// Position of CURBK_CTLDIR field.
	UDPHS_EPTSTA5_CURBK_CTLDIR_Pos = 0x10
	// Bit mask of CURBK_CTLDIR field.
	UDPHS_EPTSTA5_CURBK_CTLDIR_Msk = 0x30000
	// Position of BUSY_BANK_STA field.
	UDPHS_EPTSTA5_BUSY_BANK_STA_Pos = 0x12
	// Bit mask of BUSY_BANK_STA field.
	UDPHS_EPTSTA5_BUSY_BANK_STA_Msk = 0xc0000
	// 1 busy bank
	UDPHS_EPTSTA5_BUSY_BANK_STA_1BUSYBANK = 0x0
	// 2 busy banks
	UDPHS_EPTSTA5_BUSY_BANK_STA_2BUSYBANKS = 0x1
	// 3 busy banks
	UDPHS_EPTSTA5_BUSY_BANK_STA_3BUSYBANKS = 0x2
	// Position of BYTE_COUNT field.
	UDPHS_EPTSTA5_BYTE_COUNT_Pos = 0x14
	// Bit mask of BYTE_COUNT field.
	UDPHS_EPTSTA5_BYTE_COUNT_Msk = 0x7ff00000
	// Position of SHRT_PCKT field.
	UDPHS_EPTSTA5_SHRT_PCKT_Pos = 0x1f
	// Bit mask of SHRT_PCKT field.
	UDPHS_EPTSTA5_SHRT_PCKT_Msk = 0x80000000
	// Bit SHRT_PCKT.
	UDPHS_EPTSTA5_SHRT_PCKT = 0x80000000

	// EPTSTA5_ISOENDPT: UDPHS Endpoint Status Register (endpoint = 5)
	// Position of TOGGLESQ_STA field.
	UDPHS_EPTSTA5_ISOENDPT_TOGGLESQ_STA_Pos = 0x6
	// Bit mask of TOGGLESQ_STA field.
	UDPHS_EPTSTA5_ISOENDPT_TOGGLESQ_STA_Msk = 0xc0
	// DATA0
	UDPHS_EPTSTA5_ISOENDPT_TOGGLESQ_STA_DATA0 = 0x0
	// DATA1
	UDPHS_EPTSTA5_ISOENDPT_TOGGLESQ_STA_DATA1 = 0x1
	// Data2 (only for High Bandwidth Isochronous Endpoint)
	UDPHS_EPTSTA5_ISOENDPT_TOGGLESQ_STA_DATA2 = 0x2
	// MData (only for High Bandwidth Isochronous Endpoint)
	UDPHS_EPTSTA5_ISOENDPT_TOGGLESQ_STA_MDATA = 0x3
	// Position of ERR_OVFLW field.
	UDPHS_EPTSTA5_ISOENDPT_ERR_OVFLW_Pos = 0x8
	// Bit mask of ERR_OVFLW field.
	UDPHS_EPTSTA5_ISOENDPT_ERR_OVFLW_Msk = 0x100
	// Bit ERR_OVFLW.
	UDPHS_EPTSTA5_ISOENDPT_ERR_OVFLW = 0x100
	// Position of RXRDY_TXKL field.
	UDPHS_EPTSTA5_ISOENDPT_RXRDY_TXKL_Pos = 0x9
	// Bit mask of RXRDY_TXKL field.
	UDPHS_EPTSTA5_ISOENDPT_RXRDY_TXKL_Msk = 0x200
	// Bit RXRDY_TXKL.
	UDPHS_EPTSTA5_ISOENDPT_RXRDY_TXKL = 0x200
	// Position of TX_COMPLT field.
	UDPHS_EPTSTA5_ISOENDPT_TX_COMPLT_Pos = 0xa
	// Bit mask of TX_COMPLT field.
	UDPHS_EPTSTA5_ISOENDPT_TX_COMPLT_Msk = 0x400
	// Bit TX_COMPLT.
	UDPHS_EPTSTA5_ISOENDPT_TX_COMPLT = 0x400
	// Position of TXRDY_TRER field.
	UDPHS_EPTSTA5_ISOENDPT_TXRDY_TRER_Pos = 0xb
	// Bit mask of TXRDY_TRER field.
	UDPHS_EPTSTA5_ISOENDPT_TXRDY_TRER_Msk = 0x800
	// Bit TXRDY_TRER.
	UDPHS_EPTSTA5_ISOENDPT_TXRDY_TRER = 0x800
	// Position of ERR_FL_ISO field.
	UDPHS_EPTSTA5_ISOENDPT_ERR_FL_ISO_Pos = 0xc
	// Bit mask of ERR_FL_ISO field.
	UDPHS_EPTSTA5_ISOENDPT_ERR_FL_ISO_Msk = 0x1000
	// Bit ERR_FL_ISO.
	UDPHS_EPTSTA5_ISOENDPT_ERR_FL_ISO = 0x1000
	// Position of ERR_CRC_NTR field.
	UDPHS_EPTSTA5_ISOENDPT_ERR_CRC_NTR_Pos = 0xd
	// Bit mask of ERR_CRC_NTR field.
	UDPHS_EPTSTA5_ISOENDPT_ERR_CRC_NTR_Msk = 0x2000
	// Bit ERR_CRC_NTR.
	UDPHS_EPTSTA5_ISOENDPT_ERR_CRC_NTR = 0x2000
	// Position of ERR_FLUSH field.
	UDPHS_EPTSTA5_ISOENDPT_ERR_FLUSH_Pos = 0xe
	// Bit mask of ERR_FLUSH field.
	UDPHS_EPTSTA5_ISOENDPT_ERR_FLUSH_Msk = 0x4000
	// Bit ERR_FLUSH.
	UDPHS_EPTSTA5_ISOENDPT_ERR_FLUSH = 0x4000
	// Position of CURBK field.
	UDPHS_EPTSTA5_ISOENDPT_CURBK_Pos = 0x10
	// Bit mask of CURBK field.
	UDPHS_EPTSTA5_ISOENDPT_CURBK_Msk = 0x30000
	// Bank 0 (or single bank)
	UDPHS_EPTSTA5_ISOENDPT_CURBK_BANK0 = 0x0
	// Bank 1
	UDPHS_EPTSTA5_ISOENDPT_CURBK_BANK1 = 0x1
	// Bank 2
	UDPHS_EPTSTA5_ISOENDPT_CURBK_BANK2 = 0x2
	// Position of BUSY_BANK_STA field.
	UDPHS_EPTSTA5_ISOENDPT_BUSY_BANK_STA_Pos = 0x12
	// Bit mask of BUSY_BANK_STA field.
	UDPHS_EPTSTA5_ISOENDPT_BUSY_BANK_STA_Msk = 0xc0000
	// 1 busy bank
	UDPHS_EPTSTA5_ISOENDPT_BUSY_BANK_STA_1BUSYBANK = 0x0
	// 2 busy banks
	UDPHS_EPTSTA5_ISOENDPT_BUSY_BANK_STA_2BUSYBANKS = 0x1
	// 3 busy banks
	UDPHS_EPTSTA5_ISOENDPT_BUSY_BANK_STA_3BUSYBANKS = 0x2
	// Position of BYTE_COUNT field.
	UDPHS_EPTSTA5_ISOENDPT_BYTE_COUNT_Pos = 0x14
	// Bit mask of BYTE_COUNT field.
	UDPHS_EPTSTA5_ISOENDPT_BYTE_COUNT_Msk = 0x7ff00000
	// Position of SHRT_PCKT field.
	UDPHS_EPTSTA5_ISOENDPT_SHRT_PCKT_Pos = 0x1f
	// Bit mask of SHRT_PCKT field.
	UDPHS_EPTSTA5_ISOENDPT_SHRT_PCKT_Msk = 0x80000000
	// Bit SHRT_PCKT.
	UDPHS_EPTSTA5_ISOENDPT_SHRT_PCKT = 0x80000000

	// EPTCFG6: UDPHS Endpoint Configuration Register (endpoint = 6)
	// Position of EPT_SIZE field.
	UDPHS_EPTCFG6_EPT_SIZE_Pos = 0x0
	// Bit mask of EPT_SIZE field.
	UDPHS_EPTCFG6_EPT_SIZE_Msk = 0x7
	// 8 bytes
	UDPHS_EPTCFG6_EPT_SIZE_8 = 0x0
	// 16 bytes
	UDPHS_EPTCFG6_EPT_SIZE_16 = 0x1
	// 32 bytes
	UDPHS_EPTCFG6_EPT_SIZE_32 = 0x2
	// 64 bytes
	UDPHS_EPTCFG6_EPT_SIZE_64 = 0x3
	// 128 bytes
	UDPHS_EPTCFG6_EPT_SIZE_128 = 0x4
	// 256 bytes
	UDPHS_EPTCFG6_EPT_SIZE_256 = 0x5
	// 512 bytes
	UDPHS_EPTCFG6_EPT_SIZE_512 = 0x6
	// 1024 bytes
	UDPHS_EPTCFG6_EPT_SIZE_1024 = 0x7
	// Position of EPT_DIR field.
	UDPHS_EPTCFG6_EPT_DIR_Pos = 0x3
	// Bit mask of EPT_DIR field.
	UDPHS_EPTCFG6_EPT_DIR_Msk = 0x8
	// Bit EPT_DIR.
	UDPHS_EPTCFG6_EPT_DIR = 0x8
	// Position of EPT_TYPE field.
	UDPHS_EPTCFG6_EPT_TYPE_Pos = 0x4
	// Bit mask of EPT_TYPE field.
	UDPHS_EPTCFG6_EPT_TYPE_Msk = 0x30
	// Control endpoint
	UDPHS_EPTCFG6_EPT_TYPE_CTRL8 = 0x0
	// Isochronous endpoint
	UDPHS_EPTCFG6_EPT_TYPE_ISO = 0x1
	// Bulk endpoint
	UDPHS_EPTCFG6_EPT_TYPE_BULK = 0x2
	// Interrupt endpoint
	UDPHS_EPTCFG6_EPT_TYPE_INT = 0x3
	// Position of BK_NUMBER field.
	UDPHS_EPTCFG6_BK_NUMBER_Pos = 0x6
	// Bit mask of BK_NUMBER field.
	UDPHS_EPTCFG6_BK_NUMBER_Msk = 0xc0
	// Zero bank, the endpoint is not mapped in memory
	UDPHS_EPTCFG6_BK_NUMBER_0 = 0x0
	// One bank (bank 0)
	UDPHS_EPTCFG6_BK_NUMBER_1 = 0x1
	// Double bank (Ping-Pong: bank0/bank1)
	UDPHS_EPTCFG6_BK_NUMBER_2 = 0x2
	// Triple bank (bank0/bank1/bank2)
	UDPHS_EPTCFG6_BK_NUMBER_3 = 0x3
	// Position of NB_TRANS field.
	UDPHS_EPTCFG6_NB_TRANS_Pos = 0x8
	// Bit mask of NB_TRANS field.
	UDPHS_EPTCFG6_NB_TRANS_Msk = 0x300
	// Position of EPT_MAPD field.
	UDPHS_EPTCFG6_EPT_MAPD_Pos = 0x1f
	// Bit mask of EPT_MAPD field.
	UDPHS_EPTCFG6_EPT_MAPD_Msk = 0x80000000
	// Bit EPT_MAPD.
	UDPHS_EPTCFG6_EPT_MAPD = 0x80000000

	// EPTCTLENB6: UDPHS Endpoint Control Enable Register (endpoint = 6)
	// Position of EPT_ENABL field.
	UDPHS_EPTCTLENB6_EPT_ENABL_Pos = 0x0
	// Bit mask of EPT_ENABL field.
	UDPHS_EPTCTLENB6_EPT_ENABL_Msk = 0x1
	// Bit EPT_ENABL.
	UDPHS_EPTCTLENB6_EPT_ENABL = 0x1
	// Position of AUTO_VALID field.
	UDPHS_EPTCTLENB6_AUTO_VALID_Pos = 0x1
	// Bit mask of AUTO_VALID field.
	UDPHS_EPTCTLENB6_AUTO_VALID_Msk = 0x2
	// Bit AUTO_VALID.
	UDPHS_EPTCTLENB6_AUTO_VALID = 0x2
	// Position of INTDIS_DMA field.
	UDPHS_EPTCTLENB6_INTDIS_DMA_Pos = 0x3
	// Bit mask of INTDIS_DMA field.
	UDPHS_EPTCTLENB6_INTDIS_DMA_Msk = 0x8
	// Bit INTDIS_DMA.
	UDPHS_EPTCTLENB6_INTDIS_DMA = 0x8
	// Position of NYET_DIS field.
	UDPHS_EPTCTLENB6_NYET_DIS_Pos = 0x4
	// Bit mask of NYET_DIS field.
	UDPHS_EPTCTLENB6_NYET_DIS_Msk = 0x10
	// Bit NYET_DIS.
	UDPHS_EPTCTLENB6_NYET_DIS = 0x10
	// Position of ERR_OVFLW field.
	UDPHS_EPTCTLENB6_ERR_OVFLW_Pos = 0x8
	// Bit mask of ERR_OVFLW field.
	UDPHS_EPTCTLENB6_ERR_OVFLW_Msk = 0x100
	// Bit ERR_OVFLW.
	UDPHS_EPTCTLENB6_ERR_OVFLW = 0x100
	// Position of RXRDY_TXKL field.
	UDPHS_EPTCTLENB6_RXRDY_TXKL_Pos = 0x9
	// Bit mask of RXRDY_TXKL field.
	UDPHS_EPTCTLENB6_RXRDY_TXKL_Msk = 0x200
	// Bit RXRDY_TXKL.
	UDPHS_EPTCTLENB6_RXRDY_TXKL = 0x200
	// Position of TX_COMPLT field.
	UDPHS_EPTCTLENB6_TX_COMPLT_Pos = 0xa
	// Bit mask of TX_COMPLT field.
	UDPHS_EPTCTLENB6_TX_COMPLT_Msk = 0x400
	// Bit TX_COMPLT.
	UDPHS_EPTCTLENB6_TX_COMPLT = 0x400
	// Position of TXRDY field.
	UDPHS_EPTCTLENB6_TXRDY_Pos = 0xb
	// Bit mask of TXRDY field.
	UDPHS_EPTCTLENB6_TXRDY_Msk = 0x800
	// Bit TXRDY.
	UDPHS_EPTCTLENB6_TXRDY = 0x800
	// Position of RX_SETUP field.
	UDPHS_EPTCTLENB6_RX_SETUP_Pos = 0xc
	// Bit mask of RX_SETUP field.
	UDPHS_EPTCTLENB6_RX_SETUP_Msk = 0x1000
	// Bit RX_SETUP.
	UDPHS_EPTCTLENB6_RX_SETUP = 0x1000
	// Position of STALL_SNT field.
	UDPHS_EPTCTLENB6_STALL_SNT_Pos = 0xd
	// Bit mask of STALL_SNT field.
	UDPHS_EPTCTLENB6_STALL_SNT_Msk = 0x2000
	// Bit STALL_SNT.
	UDPHS_EPTCTLENB6_STALL_SNT = 0x2000
	// Position of NAK_IN field.
	UDPHS_EPTCTLENB6_NAK_IN_Pos = 0xe
	// Bit mask of NAK_IN field.
	UDPHS_EPTCTLENB6_NAK_IN_Msk = 0x4000
	// Bit NAK_IN.
	UDPHS_EPTCTLENB6_NAK_IN = 0x4000
	// Position of NAK_OUT field.
	UDPHS_EPTCTLENB6_NAK_OUT_Pos = 0xf
	// Bit mask of NAK_OUT field.
	UDPHS_EPTCTLENB6_NAK_OUT_Msk = 0x8000
	// Bit NAK_OUT.
	UDPHS_EPTCTLENB6_NAK_OUT = 0x8000
	// Position of BUSY_BANK field.
	UDPHS_EPTCTLENB6_BUSY_BANK_Pos = 0x12
	// Bit mask of BUSY_BANK field.
	UDPHS_EPTCTLENB6_BUSY_BANK_Msk = 0x40000
	// Bit BUSY_BANK.
	UDPHS_EPTCTLENB6_BUSY_BANK = 0x40000
	// Position of SHRT_PCKT field.
	UDPHS_EPTCTLENB6_SHRT_PCKT_Pos = 0x1f
	// Bit mask of SHRT_PCKT field.
	UDPHS_EPTCTLENB6_SHRT_PCKT_Msk = 0x80000000
	// Bit SHRT_PCKT.
	UDPHS_EPTCTLENB6_SHRT_PCKT = 0x80000000

	// EPTCTLENB6_ISOENDPT: UDPHS Endpoint Control Enable Register (endpoint = 6)
	// Position of EPT_ENABL field.
	UDPHS_EPTCTLENB6_ISOENDPT_EPT_ENABL_Pos = 0x0
	// Bit mask of EPT_ENABL field.
	UDPHS_EPTCTLENB6_ISOENDPT_EPT_ENABL_Msk = 0x1
	// Bit EPT_ENABL.
	UDPHS_EPTCTLENB6_ISOENDPT_EPT_ENABL = 0x1
	// Position of AUTO_VALID field.
	UDPHS_EPTCTLENB6_ISOENDPT_AUTO_VALID_Pos = 0x1
	// Bit mask of AUTO_VALID field.
	UDPHS_EPTCTLENB6_ISOENDPT_AUTO_VALID_Msk = 0x2
	// Bit AUTO_VALID.
	UDPHS_EPTCTLENB6_ISOENDPT_AUTO_VALID = 0x2
	// Position of INTDIS_DMA field.
	UDPHS_EPTCTLENB6_ISOENDPT_INTDIS_DMA_Pos = 0x3
	// Bit mask of INTDIS_DMA field.
	UDPHS_EPTCTLENB6_ISOENDPT_INTDIS_DMA_Msk = 0x8
	// Bit INTDIS_DMA.
	UDPHS_EPTCTLENB6_ISOENDPT_INTDIS_DMA = 0x8
	// Position of DATAX_RX field.
	UDPHS_EPTCTLENB6_ISOENDPT_DATAX_RX_Pos = 0x6
	// Bit mask of DATAX_RX field.
	UDPHS_EPTCTLENB6_ISOENDPT_DATAX_RX_Msk = 0x40
	// Bit DATAX_RX.
	UDPHS_EPTCTLENB6_ISOENDPT_DATAX_RX = 0x40
	// Position of MDATA_RX field.
	UDPHS_EPTCTLENB6_ISOENDPT_MDATA_RX_Pos = 0x7
	// Bit mask of MDATA_RX field.
	UDPHS_EPTCTLENB6_ISOENDPT_MDATA_RX_Msk = 0x80
	// Bit MDATA_RX.
	UDPHS_EPTCTLENB6_ISOENDPT_MDATA_RX = 0x80
	// Position of ERR_OVFLW field.
	UDPHS_EPTCTLENB6_ISOENDPT_ERR_OVFLW_Pos = 0x8
	// Bit mask of ERR_OVFLW field.
	UDPHS_EPTCTLENB6_ISOENDPT_ERR_OVFLW_Msk = 0x100
	// Bit ERR_OVFLW.
	UDPHS_EPTCTLENB6_ISOENDPT_ERR_OVFLW = 0x100
	// Position of RXRDY_TXKL field.
	UDPHS_EPTCTLENB6_ISOENDPT_RXRDY_TXKL_Pos = 0x9
	// Bit mask of RXRDY_TXKL field.
	UDPHS_EPTCTLENB6_ISOENDPT_RXRDY_TXKL_Msk = 0x200
	// Bit RXRDY_TXKL.
	UDPHS_EPTCTLENB6_ISOENDPT_RXRDY_TXKL = 0x200
	// Position of TX_COMPLT field.
	UDPHS_EPTCTLENB6_ISOENDPT_TX_COMPLT_Pos = 0xa
	// Bit mask of TX_COMPLT field.
	UDPHS_EPTCTLENB6_ISOENDPT_TX_COMPLT_Msk = 0x400
	// Bit TX_COMPLT.
	UDPHS_EPTCTLENB6_ISOENDPT_TX_COMPLT = 0x400
	// Position of TXRDY_TRER field.
	UDPHS_EPTCTLENB6_ISOENDPT_TXRDY_TRER_Pos = 0xb
	// Bit mask of TXRDY_TRER field.
	UDPHS_EPTCTLENB6_ISOENDPT_TXRDY_TRER_Msk = 0x800
	// Bit TXRDY_TRER.
	UDPHS_EPTCTLENB6_ISOENDPT_TXRDY_TRER = 0x800
	// Position of ERR_FL_ISO field.
	UDPHS_EPTCTLENB6_ISOENDPT_ERR_FL_ISO_Pos = 0xc
	// Bit mask of ERR_FL_ISO field.
	UDPHS_EPTCTLENB6_ISOENDPT_ERR_FL_ISO_Msk = 0x1000
	// Bit ERR_FL_ISO.
	UDPHS_EPTCTLENB6_ISOENDPT_ERR_FL_ISO = 0x1000
	// Position of ERR_CRC_NTR field.
	UDPHS_EPTCTLENB6_ISOENDPT_ERR_CRC_NTR_Pos = 0xd
	// Bit mask of ERR_CRC_NTR field.
	UDPHS_EPTCTLENB6_ISOENDPT_ERR_CRC_NTR_Msk = 0x2000
	// Bit ERR_CRC_NTR.
	UDPHS_EPTCTLENB6_ISOENDPT_ERR_CRC_NTR = 0x2000
	// Position of ERR_FLUSH field.
	UDPHS_EPTCTLENB6_ISOENDPT_ERR_FLUSH_Pos = 0xe
	// Bit mask of ERR_FLUSH field.
	UDPHS_EPTCTLENB6_ISOENDPT_ERR_FLUSH_Msk = 0x4000
	// Bit ERR_FLUSH.
	UDPHS_EPTCTLENB6_ISOENDPT_ERR_FLUSH = 0x4000
	// Position of BUSY_BANK field.
	UDPHS_EPTCTLENB6_ISOENDPT_BUSY_BANK_Pos = 0x12
	// Bit mask of BUSY_BANK field.
	UDPHS_EPTCTLENB6_ISOENDPT_BUSY_BANK_Msk = 0x40000
	// Bit BUSY_BANK.
	UDPHS_EPTCTLENB6_ISOENDPT_BUSY_BANK = 0x40000
	// Position of SHRT_PCKT field.
	UDPHS_EPTCTLENB6_ISOENDPT_SHRT_PCKT_Pos = 0x1f
	// Bit mask of SHRT_PCKT field.
	UDPHS_EPTCTLENB6_ISOENDPT_SHRT_PCKT_Msk = 0x80000000
	// Bit SHRT_PCKT.
	UDPHS_EPTCTLENB6_ISOENDPT_SHRT_PCKT = 0x80000000

	// EPTCTLDIS6: UDPHS Endpoint Control Disable Register (endpoint = 6)
	// Position of EPT_DISABL field.
	UDPHS_EPTCTLDIS6_EPT_DISABL_Pos = 0x0
	// Bit mask of EPT_DISABL field.
	UDPHS_EPTCTLDIS6_EPT_DISABL_Msk = 0x1
	// Bit EPT_DISABL.
	UDPHS_EPTCTLDIS6_EPT_DISABL = 0x1
	// Position of AUTO_VALID field.
	UDPHS_EPTCTLDIS6_AUTO_VALID_Pos = 0x1
	// Bit mask of AUTO_VALID field.
	UDPHS_EPTCTLDIS6_AUTO_VALID_Msk = 0x2
	// Bit AUTO_VALID.
	UDPHS_EPTCTLDIS6_AUTO_VALID = 0x2
	// Position of INTDIS_DMA field.
	UDPHS_EPTCTLDIS6_INTDIS_DMA_Pos = 0x3
	// Bit mask of INTDIS_DMA field.
	UDPHS_EPTCTLDIS6_INTDIS_DMA_Msk = 0x8
	// Bit INTDIS_DMA.
	UDPHS_EPTCTLDIS6_INTDIS_DMA = 0x8
	// Position of NYET_DIS field.
	UDPHS_EPTCTLDIS6_NYET_DIS_Pos = 0x4
	// Bit mask of NYET_DIS field.
	UDPHS_EPTCTLDIS6_NYET_DIS_Msk = 0x10
	// Bit NYET_DIS.
	UDPHS_EPTCTLDIS6_NYET_DIS = 0x10
	// Position of ERR_OVFLW field.
	UDPHS_EPTCTLDIS6_ERR_OVFLW_Pos = 0x8
	// Bit mask of ERR_OVFLW field.
	UDPHS_EPTCTLDIS6_ERR_OVFLW_Msk = 0x100
	// Bit ERR_OVFLW.
	UDPHS_EPTCTLDIS6_ERR_OVFLW = 0x100
	// Position of RXRDY_TXKL field.
	UDPHS_EPTCTLDIS6_RXRDY_TXKL_Pos = 0x9
	// Bit mask of RXRDY_TXKL field.
	UDPHS_EPTCTLDIS6_RXRDY_TXKL_Msk = 0x200
	// Bit RXRDY_TXKL.
	UDPHS_EPTCTLDIS6_RXRDY_TXKL = 0x200
	// Position of TX_COMPLT field.
	UDPHS_EPTCTLDIS6_TX_COMPLT_Pos = 0xa
	// Bit mask of TX_COMPLT field.
	UDPHS_EPTCTLDIS6_TX_COMPLT_Msk = 0x400
	// Bit TX_COMPLT.
	UDPHS_EPTCTLDIS6_TX_COMPLT = 0x400
	// Position of TXRDY field.
	UDPHS_EPTCTLDIS6_TXRDY_Pos = 0xb
	// Bit mask of TXRDY field.
	UDPHS_EPTCTLDIS6_TXRDY_Msk = 0x800
	// Bit TXRDY.
	UDPHS_EPTCTLDIS6_TXRDY = 0x800
	// Position of RX_SETUP field.
	UDPHS_EPTCTLDIS6_RX_SETUP_Pos = 0xc
	// Bit mask of RX_SETUP field.
	UDPHS_EPTCTLDIS6_RX_SETUP_Msk = 0x1000
	// Bit RX_SETUP.
	UDPHS_EPTCTLDIS6_RX_SETUP = 0x1000
	// Position of STALL_SNT field.
	UDPHS_EPTCTLDIS6_STALL_SNT_Pos = 0xd
	// Bit mask of STALL_SNT field.
	UDPHS_EPTCTLDIS6_STALL_SNT_Msk = 0x2000
	// Bit STALL_SNT.
	UDPHS_EPTCTLDIS6_STALL_SNT = 0x2000
	// Position of NAK_IN field.
	UDPHS_EPTCTLDIS6_NAK_IN_Pos = 0xe
	// Bit mask of NAK_IN field.
	UDPHS_EPTCTLDIS6_NAK_IN_Msk = 0x4000
	// Bit NAK_IN.
	UDPHS_EPTCTLDIS6_NAK_IN = 0x4000
	// Position of NAK_OUT field.
	UDPHS_EPTCTLDIS6_NAK_OUT_Pos = 0xf
	// Bit mask of NAK_OUT field.
	UDPHS_EPTCTLDIS6_NAK_OUT_Msk = 0x8000
	// Bit NAK_OUT.
	UDPHS_EPTCTLDIS6_NAK_OUT = 0x8000
	// Position of BUSY_BANK field.
	UDPHS_EPTCTLDIS6_BUSY_BANK_Pos = 0x12
	// Bit mask of BUSY_BANK field.
	UDPHS_EPTCTLDIS6_BUSY_BANK_Msk = 0x40000
	// Bit BUSY_BANK.
	UDPHS_EPTCTLDIS6_BUSY_BANK = 0x40000
	// Position of SHRT_PCKT field.
	UDPHS_EPTCTLDIS6_SHRT_PCKT_Pos = 0x1f
	// Bit mask of SHRT_PCKT field.
	UDPHS_EPTCTLDIS6_SHRT_PCKT_Msk = 0x80000000
	// Bit SHRT_PCKT.
	UDPHS_EPTCTLDIS6_SHRT_PCKT = 0x80000000

	// EPTCTLDIS6_ISOENDPT: UDPHS Endpoint Control Disable Register (endpoint = 6)
	// Position of EPT_DISABL field.
	UDPHS_EPTCTLDIS6_ISOENDPT_EPT_DISABL_Pos = 0x0
	// Bit mask of EPT_DISABL field.
	UDPHS_EPTCTLDIS6_ISOENDPT_EPT_DISABL_Msk = 0x1
	// Bit EPT_DISABL.
	UDPHS_EPTCTLDIS6_ISOENDPT_EPT_DISABL = 0x1
	// Position of AUTO_VALID field.
	UDPHS_EPTCTLDIS6_ISOENDPT_AUTO_VALID_Pos = 0x1
	// Bit mask of AUTO_VALID field.
	UDPHS_EPTCTLDIS6_ISOENDPT_AUTO_VALID_Msk = 0x2
	// Bit AUTO_VALID.
	UDPHS_EPTCTLDIS6_ISOENDPT_AUTO_VALID = 0x2
	// Position of INTDIS_DMA field.
	UDPHS_EPTCTLDIS6_ISOENDPT_INTDIS_DMA_Pos = 0x3
	// Bit mask of INTDIS_DMA field.
	UDPHS_EPTCTLDIS6_ISOENDPT_INTDIS_DMA_Msk = 0x8
	// Bit INTDIS_DMA.
	UDPHS_EPTCTLDIS6_ISOENDPT_INTDIS_DMA = 0x8
	// Position of DATAX_RX field.
	UDPHS_EPTCTLDIS6_ISOENDPT_DATAX_RX_Pos = 0x6
	// Bit mask of DATAX_RX field.
	UDPHS_EPTCTLDIS6_ISOENDPT_DATAX_RX_Msk = 0x40
	// Bit DATAX_RX.
	UDPHS_EPTCTLDIS6_ISOENDPT_DATAX_RX = 0x40
	// Position of MDATA_RX field.
	UDPHS_EPTCTLDIS6_ISOENDPT_MDATA_RX_Pos = 0x7
	// Bit mask of MDATA_RX field.
	UDPHS_EPTCTLDIS6_ISOENDPT_MDATA_RX_Msk = 0x80
	// Bit MDATA_RX.
	UDPHS_EPTCTLDIS6_ISOENDPT_MDATA_RX = 0x80
	// Position of ERR_OVFLW field.
	UDPHS_EPTCTLDIS6_ISOENDPT_ERR_OVFLW_Pos = 0x8
	// Bit mask of ERR_OVFLW field.
	UDPHS_EPTCTLDIS6_ISOENDPT_ERR_OVFLW_Msk = 0x100
	// Bit ERR_OVFLW.
	UDPHS_EPTCTLDIS6_ISOENDPT_ERR_OVFLW = 0x100
	// Position of RXRDY_TXKL field.
	UDPHS_EPTCTLDIS6_ISOENDPT_RXRDY_TXKL_Pos = 0x9
	// Bit mask of RXRDY_TXKL field.
	UDPHS_EPTCTLDIS6_ISOENDPT_RXRDY_TXKL_Msk = 0x200
	// Bit RXRDY_TXKL.
	UDPHS_EPTCTLDIS6_ISOENDPT_RXRDY_TXKL = 0x200
	// Position of TX_COMPLT field.
	UDPHS_EPTCTLDIS6_ISOENDPT_TX_COMPLT_Pos = 0xa
	// Bit mask of TX_COMPLT field.
	UDPHS_EPTCTLDIS6_ISOENDPT_TX_COMPLT_Msk = 0x400
	// Bit TX_COMPLT.
	UDPHS_EPTCTLDIS6_ISOENDPT_TX_COMPLT = 0x400
	// Position of TXRDY_TRER field.
	UDPHS_EPTCTLDIS6_ISOENDPT_TXRDY_TRER_Pos = 0xb
	// Bit mask of TXRDY_TRER field.
	UDPHS_EPTCTLDIS6_ISOENDPT_TXRDY_TRER_Msk = 0x800
	// Bit TXRDY_TRER.
	UDPHS_EPTCTLDIS6_ISOENDPT_TXRDY_TRER = 0x800
	// Position of ERR_FL_ISO field.
	UDPHS_EPTCTLDIS6_ISOENDPT_ERR_FL_ISO_Pos = 0xc
	// Bit mask of ERR_FL_ISO field.
	UDPHS_EPTCTLDIS6_ISOENDPT_ERR_FL_ISO_Msk = 0x1000
	// Bit ERR_FL_ISO.
	UDPHS_EPTCTLDIS6_ISOENDPT_ERR_FL_ISO = 0x1000
	// Position of ERR_CRC_NTR field.
	UDPHS_EPTCTLDIS6_ISOENDPT_ERR_CRC_NTR_Pos = 0xd
	// Bit mask of ERR_CRC_NTR field.
	UDPHS_EPTCTLDIS6_ISOENDPT_ERR_CRC_NTR_Msk = 0x2000
	// Bit ERR_CRC_NTR.
	UDPHS_EPTCTLDIS6_ISOENDPT_ERR_CRC_NTR = 0x2000
	// Position of ERR_FLUSH field.
	UDPHS_EPTCTLDIS6_ISOENDPT_ERR_FLUSH_Pos = 0xe
	// Bit mask of ERR_FLUSH field.
	UDPHS_EPTCTLDIS6_ISOENDPT_ERR_FLUSH_Msk = 0x4000
	// Bit ERR_FLUSH.
	UDPHS_EPTCTLDIS6_ISOENDPT_ERR_FLUSH = 0x4000
	// Position of BUSY_BANK field.
	UDPHS_EPTCTLDIS6_ISOENDPT_BUSY_BANK_Pos = 0x12
	// Bit mask of BUSY_BANK field.
	UDPHS_EPTCTLDIS6_ISOENDPT_BUSY_BANK_Msk = 0x40000
	// Bit BUSY_BANK.
	UDPHS_EPTCTLDIS6_ISOENDPT_BUSY_BANK = 0x40000
	// Position of SHRT_PCKT field.
	UDPHS_EPTCTLDIS6_ISOENDPT_SHRT_PCKT_Pos = 0x1f
	// Bit mask of SHRT_PCKT field.
	UDPHS_EPTCTLDIS6_ISOENDPT_SHRT_PCKT_Msk = 0x80000000
	// Bit SHRT_PCKT.
	UDPHS_EPTCTLDIS6_ISOENDPT_SHRT_PCKT = 0x80000000

	// EPTCTL6: UDPHS Endpoint Control Register (endpoint = 6)
	// Position of EPT_ENABL field.
	UDPHS_EPTCTL6_EPT_ENABL_Pos = 0x0
	// Bit mask of EPT_ENABL field.
	UDPHS_EPTCTL6_EPT_ENABL_Msk = 0x1
	// Bit EPT_ENABL.
	UDPHS_EPTCTL6_EPT_ENABL = 0x1
	// Position of AUTO_VALID field.
	UDPHS_EPTCTL6_AUTO_VALID_Pos = 0x1
	// Bit mask of AUTO_VALID field.
	UDPHS_EPTCTL6_AUTO_VALID_Msk = 0x2
	// Bit AUTO_VALID.
	UDPHS_EPTCTL6_AUTO_VALID = 0x2
	// Position of INTDIS_DMA field.
	UDPHS_EPTCTL6_INTDIS_DMA_Pos = 0x3
	// Bit mask of INTDIS_DMA field.
	UDPHS_EPTCTL6_INTDIS_DMA_Msk = 0x8
	// Bit INTDIS_DMA.
	UDPHS_EPTCTL6_INTDIS_DMA = 0x8
	// Position of NYET_DIS field.
	UDPHS_EPTCTL6_NYET_DIS_Pos = 0x4
	// Bit mask of NYET_DIS field.
	UDPHS_EPTCTL6_NYET_DIS_Msk = 0x10
	// Bit NYET_DIS.
	UDPHS_EPTCTL6_NYET_DIS = 0x10
	// Position of ERR_OVFLW field.
	UDPHS_EPTCTL6_ERR_OVFLW_Pos = 0x8
	// Bit mask of ERR_OVFLW field.
	UDPHS_EPTCTL6_ERR_OVFLW_Msk = 0x100
	// Bit ERR_OVFLW.
	UDPHS_EPTCTL6_ERR_OVFLW = 0x100
	// Position of RXRDY_TXKL field.
	UDPHS_EPTCTL6_RXRDY_TXKL_Pos = 0x9
	// Bit mask of RXRDY_TXKL field.
	UDPHS_EPTCTL6_RXRDY_TXKL_Msk = 0x200
	// Bit RXRDY_TXKL.
	UDPHS_EPTCTL6_RXRDY_TXKL = 0x200
	// Position of TX_COMPLT field.
	UDPHS_EPTCTL6_TX_COMPLT_Pos = 0xa
	// Bit mask of TX_COMPLT field.
	UDPHS_EPTCTL6_TX_COMPLT_Msk = 0x400
	// Bit TX_COMPLT.
	UDPHS_EPTCTL6_TX_COMPLT = 0x400
	// Position of TXRDY field.
	UDPHS_EPTCTL6_TXRDY_Pos = 0xb
	// Bit mask of TXRDY field.
	UDPHS_EPTCTL6_TXRDY_Msk = 0x800
	// Bit TXRDY.
	UDPHS_EPTCTL6_TXRDY = 0x800
	// Position of RX_SETUP field.
	UDPHS_EPTCTL6_RX_SETUP_Pos = 0xc
	// Bit mask of RX_SETUP field.
	UDPHS_EPTCTL6_RX_SETUP_Msk = 0x1000
	// Bit RX_SETUP.
	UDPHS_EPTCTL6_RX_SETUP = 0x1000
	// Position of STALL_SNT field.
	UDPHS_EPTCTL6_STALL_SNT_Pos = 0xd
	// Bit mask of STALL_SNT field.
	UDPHS_EPTCTL6_STALL_SNT_Msk = 0x2000
	// Bit STALL_SNT.
	UDPHS_EPTCTL6_STALL_SNT = 0x2000
	// Position of NAK_IN field.
	UDPHS_EPTCTL6_NAK_IN_Pos = 0xe
	// Bit mask of NAK_IN field.
	UDPHS_EPTCTL6_NAK_IN_Msk = 0x4000
	// Bit NAK_IN.
	UDPHS_EPTCTL6_NAK_IN = 0x4000
	// Position of NAK_OUT field.
	UDPHS_EPTCTL6_NAK_OUT_Pos = 0xf
	// Bit mask of NAK_OUT field.
	UDPHS_EPTCTL6_NAK_OUT_Msk = 0x8000
	// Bit NAK_OUT.
	UDPHS_EPTCTL6_NAK_OUT = 0x8000
	// Position of BUSY_BANK field.
	UDPHS_EPTCTL6_BUSY_BANK_Pos = 0x12
	// Bit mask of BUSY_BANK field.
	UDPHS_EPTCTL6_BUSY_BANK_Msk = 0x40000
	// Bit BUSY_BANK.
	UDPHS_EPTCTL6_BUSY_BANK = 0x40000
	// Position of SHRT_PCKT field.
	UDPHS_EPTCTL6_SHRT_PCKT_Pos = 0x1f
	// Bit mask of SHRT_PCKT field.
	UDPHS_EPTCTL6_SHRT_PCKT_Msk = 0x80000000
	// Bit SHRT_PCKT.
	UDPHS_EPTCTL6_SHRT_PCKT = 0x80000000

	// EPTCTL6_ISOENDPT: UDPHS Endpoint Control Register (endpoint = 6)
	// Position of EPT_ENABL field.
	UDPHS_EPTCTL6_ISOENDPT_EPT_ENABL_Pos = 0x0
	// Bit mask of EPT_ENABL field.
	UDPHS_EPTCTL6_ISOENDPT_EPT_ENABL_Msk = 0x1
	// Bit EPT_ENABL.
	UDPHS_EPTCTL6_ISOENDPT_EPT_ENABL = 0x1
	// Position of AUTO_VALID field.
	UDPHS_EPTCTL6_ISOENDPT_AUTO_VALID_Pos = 0x1
	// Bit mask of AUTO_VALID field.
	UDPHS_EPTCTL6_ISOENDPT_AUTO_VALID_Msk = 0x2
	// Bit AUTO_VALID.
	UDPHS_EPTCTL6_ISOENDPT_AUTO_VALID = 0x2
	// Position of INTDIS_DMA field.
	UDPHS_EPTCTL6_ISOENDPT_INTDIS_DMA_Pos = 0x3
	// Bit mask of INTDIS_DMA field.
	UDPHS_EPTCTL6_ISOENDPT_INTDIS_DMA_Msk = 0x8
	// Bit INTDIS_DMA.
	UDPHS_EPTCTL6_ISOENDPT_INTDIS_DMA = 0x8
	// Position of DATAX_RX field.
	UDPHS_EPTCTL6_ISOENDPT_DATAX_RX_Pos = 0x6
	// Bit mask of DATAX_RX field.
	UDPHS_EPTCTL6_ISOENDPT_DATAX_RX_Msk = 0x40
	// Bit DATAX_RX.
	UDPHS_EPTCTL6_ISOENDPT_DATAX_RX = 0x40
	// Position of MDATA_RX field.
	UDPHS_EPTCTL6_ISOENDPT_MDATA_RX_Pos = 0x7
	// Bit mask of MDATA_RX field.
	UDPHS_EPTCTL6_ISOENDPT_MDATA_RX_Msk = 0x80
	// Bit MDATA_RX.
	UDPHS_EPTCTL6_ISOENDPT_MDATA_RX = 0x80
	// Position of ERR_OVFLW field.
	UDPHS_EPTCTL6_ISOENDPT_ERR_OVFLW_Pos = 0x8
	// Bit mask of ERR_OVFLW field.
	UDPHS_EPTCTL6_ISOENDPT_ERR_OVFLW_Msk = 0x100
	// Bit ERR_OVFLW.
	UDPHS_EPTCTL6_ISOENDPT_ERR_OVFLW = 0x100
	// Position of RXRDY_TXKL field.
	UDPHS_EPTCTL6_ISOENDPT_RXRDY_TXKL_Pos = 0x9
	// Bit mask of RXRDY_TXKL field.
	UDPHS_EPTCTL6_ISOENDPT_RXRDY_TXKL_Msk = 0x200
	// Bit RXRDY_TXKL.
	UDPHS_EPTCTL6_ISOENDPT_RXRDY_TXKL = 0x200
	// Position of TX_COMPLT field.
	UDPHS_EPTCTL6_ISOENDPT_TX_COMPLT_Pos = 0xa
	// Bit mask of TX_COMPLT field.
	UDPHS_EPTCTL6_ISOENDPT_TX_COMPLT_Msk = 0x400
	// Bit TX_COMPLT.
	UDPHS_EPTCTL6_ISOENDPT_TX_COMPLT = 0x400
	// Position of TXRDY_TRER field.
	UDPHS_EPTCTL6_ISOENDPT_TXRDY_TRER_Pos = 0xb
	// Bit mask of TXRDY_TRER field.
	UDPHS_EPTCTL6_ISOENDPT_TXRDY_TRER_Msk = 0x800
	// Bit TXRDY_TRER.
	UDPHS_EPTCTL6_ISOENDPT_TXRDY_TRER = 0x800
	// Position of ERR_FL_ISO field.
	UDPHS_EPTCTL6_ISOENDPT_ERR_FL_ISO_Pos = 0xc
	// Bit mask of ERR_FL_ISO field.
	UDPHS_EPTCTL6_ISOENDPT_ERR_FL_ISO_Msk = 0x1000
	// Bit ERR_FL_ISO.
	UDPHS_EPTCTL6_ISOENDPT_ERR_FL_ISO = 0x1000
	// Position of ERR_CRC_NTR field.
	UDPHS_EPTCTL6_ISOENDPT_ERR_CRC_NTR_Pos = 0xd
	// Bit mask of ERR_CRC_NTR field.
	UDPHS_EPTCTL6_ISOENDPT_ERR_CRC_NTR_Msk = 0x2000
	// Bit ERR_CRC_NTR.
	UDPHS_EPTCTL6_ISOENDPT_ERR_CRC_NTR = 0x2000
	// Position of ERR_FLUSH field.
	UDPHS_EPTCTL6_ISOENDPT_ERR_FLUSH_Pos = 0xe
	// Bit mask of ERR_FLUSH field.
	UDPHS_EPTCTL6_ISOENDPT_ERR_FLUSH_Msk = 0x4000
	// Bit ERR_FLUSH.
	UDPHS_EPTCTL6_ISOENDPT_ERR_FLUSH = 0x4000
	// Position of BUSY_BANK field.
	UDPHS_EPTCTL6_ISOENDPT_BUSY_BANK_Pos = 0x12
	// Bit mask of BUSY_BANK field.
	UDPHS_EPTCTL6_ISOENDPT_BUSY_BANK_Msk = 0x40000
	// Bit BUSY_BANK.
	UDPHS_EPTCTL6_ISOENDPT_BUSY_BANK = 0x40000
	// Position of SHRT_PCKT field.
	UDPHS_EPTCTL6_ISOENDPT_SHRT_PCKT_Pos = 0x1f
	// Bit mask of SHRT_PCKT field.
	UDPHS_EPTCTL6_ISOENDPT_SHRT_PCKT_Msk = 0x80000000
	// Bit SHRT_PCKT.
	UDPHS_EPTCTL6_ISOENDPT_SHRT_PCKT = 0x80000000

	// EPTSETSTA6: UDPHS Endpoint Set Status Register (endpoint = 6)
	// Position of FRCESTALL field.
	UDPHS_EPTSETSTA6_FRCESTALL_Pos = 0x5
	// Bit mask of FRCESTALL field.
	UDPHS_EPTSETSTA6_FRCESTALL_Msk = 0x20
	// Bit FRCESTALL.
	UDPHS_EPTSETSTA6_FRCESTALL = 0x20
	// Position of RXRDY_TXKL field.
	UDPHS_EPTSETSTA6_RXRDY_TXKL_Pos = 0x9
	// Bit mask of RXRDY_TXKL field.
	UDPHS_EPTSETSTA6_RXRDY_TXKL_Msk = 0x200
	// Bit RXRDY_TXKL.
	UDPHS_EPTSETSTA6_RXRDY_TXKL = 0x200
	// Position of TXRDY field.
	UDPHS_EPTSETSTA6_TXRDY_Pos = 0xb
	// Bit mask of TXRDY field.
	UDPHS_EPTSETSTA6_TXRDY_Msk = 0x800
	// Bit TXRDY.
	UDPHS_EPTSETSTA6_TXRDY = 0x800

	// EPTSETSTA6_ISOENDPT: UDPHS Endpoint Set Status Register (endpoint = 6)
	// Position of RXRDY_TXKL field.
	UDPHS_EPTSETSTA6_ISOENDPT_RXRDY_TXKL_Pos = 0x9
	// Bit mask of RXRDY_TXKL field.
	UDPHS_EPTSETSTA6_ISOENDPT_RXRDY_TXKL_Msk = 0x200
	// Bit RXRDY_TXKL.
	UDPHS_EPTSETSTA6_ISOENDPT_RXRDY_TXKL = 0x200
	// Position of TXRDY_TRER field.
	UDPHS_EPTSETSTA6_ISOENDPT_TXRDY_TRER_Pos = 0xb
	// Bit mask of TXRDY_TRER field.
	UDPHS_EPTSETSTA6_ISOENDPT_TXRDY_TRER_Msk = 0x800
	// Bit TXRDY_TRER.
	UDPHS_EPTSETSTA6_ISOENDPT_TXRDY_TRER = 0x800

	// EPTCLRSTA6: UDPHS Endpoint Clear Status Register (endpoint = 6)
	// Position of FRCESTALL field.
	UDPHS_EPTCLRSTA6_FRCESTALL_Pos = 0x5
	// Bit mask of FRCESTALL field.
	UDPHS_EPTCLRSTA6_FRCESTALL_Msk = 0x20
	// Bit FRCESTALL.
	UDPHS_EPTCLRSTA6_FRCESTALL = 0x20
	// Position of TOGGLESQ field.
	UDPHS_EPTCLRSTA6_TOGGLESQ_Pos = 0x6
	// Bit mask of TOGGLESQ field.
	UDPHS_EPTCLRSTA6_TOGGLESQ_Msk = 0x40
	// Bit TOGGLESQ.
	UDPHS_EPTCLRSTA6_TOGGLESQ = 0x40
	// Position of RXRDY_TXKL field.
	UDPHS_EPTCLRSTA6_RXRDY_TXKL_Pos = 0x9
	// Bit mask of RXRDY_TXKL field.
	UDPHS_EPTCLRSTA6_RXRDY_TXKL_Msk = 0x200
	// Bit RXRDY_TXKL.
	UDPHS_EPTCLRSTA6_RXRDY_TXKL = 0x200
	// Position of TX_COMPLT field.
	UDPHS_EPTCLRSTA6_TX_COMPLT_Pos = 0xa
	// Bit mask of TX_COMPLT field.
	UDPHS_EPTCLRSTA6_TX_COMPLT_Msk = 0x400
	// Bit TX_COMPLT.
	UDPHS_EPTCLRSTA6_TX_COMPLT = 0x400
	// Position of RX_SETUP field.
	UDPHS_EPTCLRSTA6_RX_SETUP_Pos = 0xc
	// Bit mask of RX_SETUP field.
	UDPHS_EPTCLRSTA6_RX_SETUP_Msk = 0x1000
	// Bit RX_SETUP.
	UDPHS_EPTCLRSTA6_RX_SETUP = 0x1000
	// Position of STALL_SNT field.
	UDPHS_EPTCLRSTA6_STALL_SNT_Pos = 0xd
	// Bit mask of STALL_SNT field.
	UDPHS_EPTCLRSTA6_STALL_SNT_Msk = 0x2000
	// Bit STALL_SNT.
	UDPHS_EPTCLRSTA6_STALL_SNT = 0x2000
	// Position of NAK_IN field.
	UDPHS_EPTCLRSTA6_NAK_IN_Pos = 0xe
	// Bit mask of NAK_IN field.
	UDPHS_EPTCLRSTA6_NAK_IN_Msk = 0x4000
	// Bit NAK_IN.
	UDPHS_EPTCLRSTA6_NAK_IN = 0x4000
	// Position of NAK_OUT field.
	UDPHS_EPTCLRSTA6_NAK_OUT_Pos = 0xf
	// Bit mask of NAK_OUT field.
	UDPHS_EPTCLRSTA6_NAK_OUT_Msk = 0x8000
	// Bit NAK_OUT.
	UDPHS_EPTCLRSTA6_NAK_OUT = 0x8000

	// EPTCLRSTA6_ISOENDPT: UDPHS Endpoint Clear Status Register (endpoint = 6)
	// Position of TOGGLESQ field.
	UDPHS_EPTCLRSTA6_ISOENDPT_TOGGLESQ_Pos = 0x6
	// Bit mask of TOGGLESQ field.
	UDPHS_EPTCLRSTA6_ISOENDPT_TOGGLESQ_Msk = 0x40
	// Bit TOGGLESQ.
	UDPHS_EPTCLRSTA6_ISOENDPT_TOGGLESQ = 0x40
	// Position of RXRDY_TXKL field.
	UDPHS_EPTCLRSTA6_ISOENDPT_RXRDY_TXKL_Pos = 0x9
	// Bit mask of RXRDY_TXKL field.
	UDPHS_EPTCLRSTA6_ISOENDPT_RXRDY_TXKL_Msk = 0x200
	// Bit RXRDY_TXKL.
	UDPHS_EPTCLRSTA6_ISOENDPT_RXRDY_TXKL = 0x200
	// Position of TX_COMPLT field.
	UDPHS_EPTCLRSTA6_ISOENDPT_TX_COMPLT_Pos = 0xa
	// Bit mask of TX_COMPLT field.
	UDPHS_EPTCLRSTA6_ISOENDPT_TX_COMPLT_Msk = 0x400
	// Bit TX_COMPLT.
	UDPHS_EPTCLRSTA6_ISOENDPT_TX_COMPLT = 0x400
	// Position of ERR_FL_ISO field.
	UDPHS_EPTCLRSTA6_ISOENDPT_ERR_FL_ISO_Pos = 0xc
	// Bit mask of ERR_FL_ISO field.
	UDPHS_EPTCLRSTA6_ISOENDPT_ERR_FL_ISO_Msk = 0x1000
	// Bit ERR_FL_ISO.
	UDPHS_EPTCLRSTA6_ISOENDPT_ERR_FL_ISO = 0x1000
	// Position of ERR_CRC_NTR field.
	UDPHS_EPTCLRSTA6_ISOENDPT_ERR_CRC_NTR_Pos = 0xd
	// Bit mask of ERR_CRC_NTR field.
	UDPHS_EPTCLRSTA6_ISOENDPT_ERR_CRC_NTR_Msk = 0x2000
	// Bit ERR_CRC_NTR.
	UDPHS_EPTCLRSTA6_ISOENDPT_ERR_CRC_NTR = 0x2000
	// Position of ERR_FLUSH field.
	UDPHS_EPTCLRSTA6_ISOENDPT_ERR_FLUSH_Pos = 0xe
	// Bit mask of ERR_FLUSH field.
	UDPHS_EPTCLRSTA6_ISOENDPT_ERR_FLUSH_Msk = 0x4000
	// Bit ERR_FLUSH.
	UDPHS_EPTCLRSTA6_ISOENDPT_ERR_FLUSH = 0x4000

	// EPTSTA6: UDPHS Endpoint Status Register (endpoint = 6)
	// Position of FRCESTALL field.
	UDPHS_EPTSTA6_FRCESTALL_Pos = 0x5
	// Bit mask of FRCESTALL field.
	UDPHS_EPTSTA6_FRCESTALL_Msk = 0x20
	// Bit FRCESTALL.
	UDPHS_EPTSTA6_FRCESTALL = 0x20
	// Position of TOGGLESQ_STA field.
	UDPHS_EPTSTA6_TOGGLESQ_STA_Pos = 0x6
	// Bit mask of TOGGLESQ_STA field.
	UDPHS_EPTSTA6_TOGGLESQ_STA_Msk = 0xc0
	// DATA0
	UDPHS_EPTSTA6_TOGGLESQ_STA_DATA0 = 0x0
	// DATA1
	UDPHS_EPTSTA6_TOGGLESQ_STA_DATA1 = 0x1
	// Reserved for High Bandwidth Isochronous Endpoint
	UDPHS_EPTSTA6_TOGGLESQ_STA_DATA2 = 0x2
	// Reserved for High Bandwidth Isochronous Endpoint
	UDPHS_EPTSTA6_TOGGLESQ_STA_MDATA = 0x3
	// Position of ERR_OVFLW field.
	UDPHS_EPTSTA6_ERR_OVFLW_Pos = 0x8
	// Bit mask of ERR_OVFLW field.
	UDPHS_EPTSTA6_ERR_OVFLW_Msk = 0x100
	// Bit ERR_OVFLW.
	UDPHS_EPTSTA6_ERR_OVFLW = 0x100
	// Position of RXRDY_TXKL field.
	UDPHS_EPTSTA6_RXRDY_TXKL_Pos = 0x9
	// Bit mask of RXRDY_TXKL field.
	UDPHS_EPTSTA6_RXRDY_TXKL_Msk = 0x200
	// Bit RXRDY_TXKL.
	UDPHS_EPTSTA6_RXRDY_TXKL = 0x200
	// Position of TX_COMPLT field.
	UDPHS_EPTSTA6_TX_COMPLT_Pos = 0xa
	// Bit mask of TX_COMPLT field.
	UDPHS_EPTSTA6_TX_COMPLT_Msk = 0x400
	// Bit TX_COMPLT.
	UDPHS_EPTSTA6_TX_COMPLT = 0x400
	// Position of TXRDY field.
	UDPHS_EPTSTA6_TXRDY_Pos = 0xb
	// Bit mask of TXRDY field.
	UDPHS_EPTSTA6_TXRDY_Msk = 0x800
	// Bit TXRDY.
	UDPHS_EPTSTA6_TXRDY = 0x800
	// Position of RX_SETUP field.
	UDPHS_EPTSTA6_RX_SETUP_Pos = 0xc
	// Bit mask of RX_SETUP field.
	UDPHS_EPTSTA6_RX_SETUP_Msk = 0x1000
	// Bit RX_SETUP.
	UDPHS_EPTSTA6_RX_SETUP = 0x1000
	// Position of STALL_SNT field.
	UDPHS_EPTSTA6_STALL_SNT_Pos = 0xd
	// Bit mask of STALL_SNT field.
	UDPHS_EPTSTA6_STALL_SNT_Msk = 0x2000
	// Bit STALL_SNT.
	UDPHS_EPTSTA6_STALL_SNT = 0x2000
	// Position of NAK_IN field.
	UDPHS_EPTSTA6_NAK_IN_Pos = 0xe
	// Bit mask of NAK_IN field.
	UDPHS_EPTSTA6_NAK_IN_Msk = 0x4000
	// Bit NAK_IN.
	UDPHS_EPTSTA6_NAK_IN = 0x4000
	// Position of NAK_OUT field.
	UDPHS_EPTSTA6_NAK_OUT_Pos = 0xf
	// Bit mask of NAK_OUT field.
	UDPHS_EPTSTA6_NAK_OUT_Msk = 0x8000
	// Bit NAK_OUT.
	UDPHS_EPTSTA6_NAK_OUT = 0x8000
	// Position of CURBK_CTLDIR field.
	UDPHS_EPTSTA6_CURBK_CTLDIR_Pos = 0x10
	// Bit mask of CURBK_CTLDIR field.
	UDPHS_EPTSTA6_CURBK_CTLDIR_Msk = 0x30000
	// Position of BUSY_BANK_STA field.
	UDPHS_EPTSTA6_BUSY_BANK_STA_Pos = 0x12
	// Bit mask of BUSY_BANK_STA field.
	UDPHS_EPTSTA6_BUSY_BANK_STA_Msk = 0xc0000
	// 1 busy bank
	UDPHS_EPTSTA6_BUSY_BANK_STA_1BUSYBANK = 0x0
	// 2 busy banks
	UDPHS_EPTSTA6_BUSY_BANK_STA_2BUSYBANKS = 0x1
	// 3 busy banks
	UDPHS_EPTSTA6_BUSY_BANK_STA_3BUSYBANKS = 0x2
	// Position of BYTE_COUNT field.
	UDPHS_EPTSTA6_BYTE_COUNT_Pos = 0x14
	// Bit mask of BYTE_COUNT field.
	UDPHS_EPTSTA6_BYTE_COUNT_Msk = 0x7ff00000
	// Position of SHRT_PCKT field.
	UDPHS_EPTSTA6_SHRT_PCKT_Pos = 0x1f
	// Bit mask of SHRT_PCKT field.
	UDPHS_EPTSTA6_SHRT_PCKT_Msk = 0x80000000
	// Bit SHRT_PCKT.
	UDPHS_EPTSTA6_SHRT_PCKT = 0x80000000

	// EPTSTA6_ISOENDPT: UDPHS Endpoint Status Register (endpoint = 6)
	// Position of TOGGLESQ_STA field.
	UDPHS_EPTSTA6_ISOENDPT_TOGGLESQ_STA_Pos = 0x6
	// Bit mask of TOGGLESQ_STA field.
	UDPHS_EPTSTA6_ISOENDPT_TOGGLESQ_STA_Msk = 0xc0
	// DATA0
	UDPHS_EPTSTA6_ISOENDPT_TOGGLESQ_STA_DATA0 = 0x0
	// DATA1
	UDPHS_EPTSTA6_ISOENDPT_TOGGLESQ_STA_DATA1 = 0x1
	// Data2 (only for High Bandwidth Isochronous Endpoint)
	UDPHS_EPTSTA6_ISOENDPT_TOGGLESQ_STA_DATA2 = 0x2
	// MData (only for High Bandwidth Isochronous Endpoint)
	UDPHS_EPTSTA6_ISOENDPT_TOGGLESQ_STA_MDATA = 0x3
	// Position of ERR_OVFLW field.
	UDPHS_EPTSTA6_ISOENDPT_ERR_OVFLW_Pos = 0x8
	// Bit mask of ERR_OVFLW field.
	UDPHS_EPTSTA6_ISOENDPT_ERR_OVFLW_Msk = 0x100
	// Bit ERR_OVFLW.
	UDPHS_EPTSTA6_ISOENDPT_ERR_OVFLW = 0x100
	// Position of RXRDY_TXKL field.
	UDPHS_EPTSTA6_ISOENDPT_RXRDY_TXKL_Pos = 0x9
	// Bit mask of RXRDY_TXKL field.
	UDPHS_EPTSTA6_ISOENDPT_RXRDY_TXKL_Msk = 0x200
	// Bit RXRDY_TXKL.
	UDPHS_EPTSTA6_ISOENDPT_RXRDY_TXKL = 0x200
	// Position of TX_COMPLT field.
	UDPHS_EPTSTA6_ISOENDPT_TX_COMPLT_Pos = 0xa
	// Bit mask of TX_COMPLT field.
	UDPHS_EPTSTA6_ISOENDPT_TX_COMPLT_Msk = 0x400
	// Bit TX_COMPLT.
	UDPHS_EPTSTA6_ISOENDPT_TX_COMPLT = 0x400
	// Position of TXRDY_TRER field.
	UDPHS_EPTSTA6_ISOENDPT_TXRDY_TRER_Pos = 0xb
	// Bit mask of TXRDY_TRER field.
	UDPHS_EPTSTA6_ISOENDPT_TXRDY_TRER_Msk = 0x800
	// Bit TXRDY_TRER.
	UDPHS_EPTSTA6_ISOENDPT_TXRDY_TRER = 0x800
	// Position of ERR_FL_ISO field.
	UDPHS_EPTSTA6_ISOENDPT_ERR_FL_ISO_Pos = 0xc
	// Bit mask of ERR_FL_ISO field.
	UDPHS_EPTSTA6_ISOENDPT_ERR_FL_ISO_Msk = 0x1000
	// Bit ERR_FL_ISO.
	UDPHS_EPTSTA6_ISOENDPT_ERR_FL_ISO = 0x1000
	// Position of ERR_CRC_NTR field.
	UDPHS_EPTSTA6_ISOENDPT_ERR_CRC_NTR_Pos = 0xd
	// Bit mask of ERR_CRC_NTR field.
	UDPHS_EPTSTA6_ISOENDPT_ERR_CRC_NTR_Msk = 0x2000
	// Bit ERR_CRC_NTR.
	UDPHS_EPTSTA6_ISOENDPT_ERR_CRC_NTR = 0x2000
	// Position of ERR_FLUSH field.
	UDPHS_EPTSTA6_ISOENDPT_ERR_FLUSH_Pos = 0xe
	// Bit mask of ERR_FLUSH field.
	UDPHS_EPTSTA6_ISOENDPT_ERR_FLUSH_Msk = 0x4000
	// Bit ERR_FLUSH.
	UDPHS_EPTSTA6_ISOENDPT_ERR_FLUSH = 0x4000
	// Position of CURBK field.
	UDPHS_EPTSTA6_ISOENDPT_CURBK_Pos = 0x10
	// Bit mask of CURBK field.
	UDPHS_EPTSTA6_ISOENDPT_CURBK_Msk = 0x30000
	// Bank 0 (or single bank)
	UDPHS_EPTSTA6_ISOENDPT_CURBK_BANK0 = 0x0
	// Bank 1
	UDPHS_EPTSTA6_ISOENDPT_CURBK_BANK1 = 0x1
	// Bank 2
	UDPHS_EPTSTA6_ISOENDPT_CURBK_BANK2 = 0x2
	// Position of BUSY_BANK_STA field.
	UDPHS_EPTSTA6_ISOENDPT_BUSY_BANK_STA_Pos = 0x12
	// Bit mask of BUSY_BANK_STA field.
	UDPHS_EPTSTA6_ISOENDPT_BUSY_BANK_STA_Msk = 0xc0000
	// 1 busy bank
	UDPHS_EPTSTA6_ISOENDPT_BUSY_BANK_STA_1BUSYBANK = 0x0
	// 2 busy banks
	UDPHS_EPTSTA6_ISOENDPT_BUSY_BANK_STA_2BUSYBANKS = 0x1
	// 3 busy banks
	UDPHS_EPTSTA6_ISOENDPT_BUSY_BANK_STA_3BUSYBANKS = 0x2
	// Position of BYTE_COUNT field.
	UDPHS_EPTSTA6_ISOENDPT_BYTE_COUNT_Pos = 0x14
	// Bit mask of BYTE_COUNT field.
	UDPHS_EPTSTA6_ISOENDPT_BYTE_COUNT_Msk = 0x7ff00000
	// Position of SHRT_PCKT field.
	UDPHS_EPTSTA6_ISOENDPT_SHRT_PCKT_Pos = 0x1f
	// Bit mask of SHRT_PCKT field.
	UDPHS_EPTSTA6_ISOENDPT_SHRT_PCKT_Msk = 0x80000000
	// Bit SHRT_PCKT.
	UDPHS_EPTSTA6_ISOENDPT_SHRT_PCKT = 0x80000000

	// DMANXTDSC0: UDPHS DMA Next Descriptor Address Register (channel = 0)
	// Position of NXT_DSC_ADD field.
	UDPHS_DMANXTDSC0_NXT_DSC_ADD_Pos = 0x0
	// Bit mask of NXT_DSC_ADD field.
	UDPHS_DMANXTDSC0_NXT_DSC_ADD_Msk = 0xffffffff

	// DMAADDRESS0: UDPHS DMA Channel Address Register (channel = 0)
	// Position of BUFF_ADD field.
	UDPHS_DMAADDRESS0_BUFF_ADD_Pos = 0x0
	// Bit mask of BUFF_ADD field.
	UDPHS_DMAADDRESS0_BUFF_ADD_Msk = 0xffffffff

	// DMACONTROL0: UDPHS DMA Channel Control Register (channel = 0)
	// Position of CHANN_ENB field.
	UDPHS_DMACONTROL0_CHANN_ENB_Pos = 0x0
	// Bit mask of CHANN_ENB field.
	UDPHS_DMACONTROL0_CHANN_ENB_Msk = 0x1
	// Bit CHANN_ENB.
	UDPHS_DMACONTROL0_CHANN_ENB = 0x1
	// Position of LDNXT_DSC field.
	UDPHS_DMACONTROL0_LDNXT_DSC_Pos = 0x1
	// Bit mask of LDNXT_DSC field.
	UDPHS_DMACONTROL0_LDNXT_DSC_Msk = 0x2
	// Bit LDNXT_DSC.
	UDPHS_DMACONTROL0_LDNXT_DSC = 0x2
	// Position of END_TR_EN field.
	UDPHS_DMACONTROL0_END_TR_EN_Pos = 0x2
	// Bit mask of END_TR_EN field.
	UDPHS_DMACONTROL0_END_TR_EN_Msk = 0x4
	// Bit END_TR_EN.
	UDPHS_DMACONTROL0_END_TR_EN = 0x4
	// Position of END_B_EN field.
	UDPHS_DMACONTROL0_END_B_EN_Pos = 0x3
	// Bit mask of END_B_EN field.
	UDPHS_DMACONTROL0_END_B_EN_Msk = 0x8
	// Bit END_B_EN.
	UDPHS_DMACONTROL0_END_B_EN = 0x8
	// Position of END_TR_IT field.
	UDPHS_DMACONTROL0_END_TR_IT_Pos = 0x4
	// Bit mask of END_TR_IT field.
	UDPHS_DMACONTROL0_END_TR_IT_Msk = 0x10
	// Bit END_TR_IT.
	UDPHS_DMACONTROL0_END_TR_IT = 0x10
	// Position of END_BUFFIT field.
	UDPHS_DMACONTROL0_END_BUFFIT_Pos = 0x5
	// Bit mask of END_BUFFIT field.
	UDPHS_DMACONTROL0_END_BUFFIT_Msk = 0x20
	// Bit END_BUFFIT.
	UDPHS_DMACONTROL0_END_BUFFIT = 0x20
	// Position of DESC_LD_IT field.
	UDPHS_DMACONTROL0_DESC_LD_IT_Pos = 0x6
	// Bit mask of DESC_LD_IT field.
	UDPHS_DMACONTROL0_DESC_LD_IT_Msk = 0x40
	// Bit DESC_LD_IT.
	UDPHS_DMACONTROL0_DESC_LD_IT = 0x40
	// Position of BURST_LCK field.
	UDPHS_DMACONTROL0_BURST_LCK_Pos = 0x7
	// Bit mask of BURST_LCK field.
	UDPHS_DMACONTROL0_BURST_LCK_Msk = 0x80
	// Bit BURST_LCK.
	UDPHS_DMACONTROL0_BURST_LCK = 0x80
	// Position of BUFF_LENGTH field.
	UDPHS_DMACONTROL0_BUFF_LENGTH_Pos = 0x10
	// Bit mask of BUFF_LENGTH field.
	UDPHS_DMACONTROL0_BUFF_LENGTH_Msk = 0xffff0000

	// DMASTATUS0: UDPHS DMA Channel Status Register (channel = 0)
	// Position of CHANN_ENB field.
	UDPHS_DMASTATUS0_CHANN_ENB_Pos = 0x0
	// Bit mask of CHANN_ENB field.
	UDPHS_DMASTATUS0_CHANN_ENB_Msk = 0x1
	// Bit CHANN_ENB.
	UDPHS_DMASTATUS0_CHANN_ENB = 0x1
	// Position of CHANN_ACT field.
	UDPHS_DMASTATUS0_CHANN_ACT_Pos = 0x1
	// Bit mask of CHANN_ACT field.
	UDPHS_DMASTATUS0_CHANN_ACT_Msk = 0x2
	// Bit CHANN_ACT.
	UDPHS_DMASTATUS0_CHANN_ACT = 0x2
	// Position of END_TR_ST field.
	UDPHS_DMASTATUS0_END_TR_ST_Pos = 0x4
	// Bit mask of END_TR_ST field.
	UDPHS_DMASTATUS0_END_TR_ST_Msk = 0x10
	// Bit END_TR_ST.
	UDPHS_DMASTATUS0_END_TR_ST = 0x10
	// Position of END_BF_ST field.
	UDPHS_DMASTATUS0_END_BF_ST_Pos = 0x5
	// Bit mask of END_BF_ST field.
	UDPHS_DMASTATUS0_END_BF_ST_Msk = 0x20
	// Bit END_BF_ST.
	UDPHS_DMASTATUS0_END_BF_ST = 0x20
	// Position of DESC_LDST field.
	UDPHS_DMASTATUS0_DESC_LDST_Pos = 0x6
	// Bit mask of DESC_LDST field.
	UDPHS_DMASTATUS0_DESC_LDST_Msk = 0x40
	// Bit DESC_LDST.
	UDPHS_DMASTATUS0_DESC_LDST = 0x40
	// Position of BUFF_COUNT field.
	UDPHS_DMASTATUS0_BUFF_COUNT_Pos = 0x10
	// Bit mask of BUFF_COUNT field.
	UDPHS_DMASTATUS0_BUFF_COUNT_Msk = 0xffff0000

	// DMANXTDSC1: UDPHS DMA Next Descriptor Address Register (channel = 1)
	// Position of NXT_DSC_ADD field.
	UDPHS_DMANXTDSC1_NXT_DSC_ADD_Pos = 0x0
	// Bit mask of NXT_DSC_ADD field.
	UDPHS_DMANXTDSC1_NXT_DSC_ADD_Msk = 0xffffffff

	// DMAADDRESS1: UDPHS DMA Channel Address Register (channel = 1)
	// Position of BUFF_ADD field.
	UDPHS_DMAADDRESS1_BUFF_ADD_Pos = 0x0
	// Bit mask of BUFF_ADD field.
	UDPHS_DMAADDRESS1_BUFF_ADD_Msk = 0xffffffff

	// DMACONTROL1: UDPHS DMA Channel Control Register (channel = 1)
	// Position of CHANN_ENB field.
	UDPHS_DMACONTROL1_CHANN_ENB_Pos = 0x0
	// Bit mask of CHANN_ENB field.
	UDPHS_DMACONTROL1_CHANN_ENB_Msk = 0x1
	// Bit CHANN_ENB.
	UDPHS_DMACONTROL1_CHANN_ENB = 0x1
	// Position of LDNXT_DSC field.
	UDPHS_DMACONTROL1_LDNXT_DSC_Pos = 0x1
	// Bit mask of LDNXT_DSC field.
	UDPHS_DMACONTROL1_LDNXT_DSC_Msk = 0x2
	// Bit LDNXT_DSC.
	UDPHS_DMACONTROL1_LDNXT_DSC = 0x2
	// Position of END_TR_EN field.
	UDPHS_DMACONTROL1_END_TR_EN_Pos = 0x2
	// Bit mask of END_TR_EN field.
	UDPHS_DMACONTROL1_END_TR_EN_Msk = 0x4
	// Bit END_TR_EN.
	UDPHS_DMACONTROL1_END_TR_EN = 0x4
	// Position of END_B_EN field.
	UDPHS_DMACONTROL1_END_B_EN_Pos = 0x3
	// Bit mask of END_B_EN field.
	UDPHS_DMACONTROL1_END_B_EN_Msk = 0x8
	// Bit END_B_EN.
	UDPHS_DMACONTROL1_END_B_EN = 0x8
	// Position of END_TR_IT field.
	UDPHS_DMACONTROL1_END_TR_IT_Pos = 0x4
	// Bit mask of END_TR_IT field.
	UDPHS_DMACONTROL1_END_TR_IT_Msk = 0x10
	// Bit END_TR_IT.
	UDPHS_DMACONTROL1_END_TR_IT = 0x10
	// Position of END_BUFFIT field.
	UDPHS_DMACONTROL1_END_BUFFIT_Pos = 0x5
	// Bit mask of END_BUFFIT field.
	UDPHS_DMACONTROL1_END_BUFFIT_Msk = 0x20
	// Bit END_BUFFIT.
	UDPHS_DMACONTROL1_END_BUFFIT = 0x20
	// Position of DESC_LD_IT field.
	UDPHS_DMACONTROL1_DESC_LD_IT_Pos = 0x6
	// Bit mask of DESC_LD_IT field.
	UDPHS_DMACONTROL1_DESC_LD_IT_Msk = 0x40
	// Bit DESC_LD_IT.
	UDPHS_DMACONTROL1_DESC_LD_IT = 0x40
	// Position of BURST_LCK field.
	UDPHS_DMACONTROL1_BURST_LCK_Pos = 0x7
	// Bit mask of BURST_LCK field.
	UDPHS_DMACONTROL1_BURST_LCK_Msk = 0x80
	// Bit BURST_LCK.
	UDPHS_DMACONTROL1_BURST_LCK = 0x80
	// Position of BUFF_LENGTH field.
	UDPHS_DMACONTROL1_BUFF_LENGTH_Pos = 0x10
	// Bit mask of BUFF_LENGTH field.
	UDPHS_DMACONTROL1_BUFF_LENGTH_Msk = 0xffff0000

	// DMASTATUS1: UDPHS DMA Channel Status Register (channel = 1)
	// Position of CHANN_ENB field.
	UDPHS_DMASTATUS1_CHANN_ENB_Pos = 0x0
	// Bit mask of CHANN_ENB field.
	UDPHS_DMASTATUS1_CHANN_ENB_Msk = 0x1
	// Bit CHANN_ENB.
	UDPHS_DMASTATUS1_CHANN_ENB = 0x1
	// Position of CHANN_ACT field.
	UDPHS_DMASTATUS1_CHANN_ACT_Pos = 0x1
	// Bit mask of CHANN_ACT field.
	UDPHS_DMASTATUS1_CHANN_ACT_Msk = 0x2
	// Bit CHANN_ACT.
	UDPHS_DMASTATUS1_CHANN_ACT = 0x2
	// Position of END_TR_ST field.
	UDPHS_DMASTATUS1_END_TR_ST_Pos = 0x4
	// Bit mask of END_TR_ST field.
	UDPHS_DMASTATUS1_END_TR_ST_Msk = 0x10
	// Bit END_TR_ST.
	UDPHS_DMASTATUS1_END_TR_ST = 0x10
	// Position of END_BF_ST field.
	UDPHS_DMASTATUS1_END_BF_ST_Pos = 0x5
	// Bit mask of END_BF_ST field.
	UDPHS_DMASTATUS1_END_BF_ST_Msk = 0x20
	// Bit END_BF_ST.
	UDPHS_DMASTATUS1_END_BF_ST = 0x20
	// Position of DESC_LDST field.
	UDPHS_DMASTATUS1_DESC_LDST_Pos = 0x6
	// Bit mask of DESC_LDST field.
	UDPHS_DMASTATUS1_DESC_LDST_Msk = 0x40
	// Bit DESC_LDST.
	UDPHS_DMASTATUS1_DESC_LDST = 0x40
	// Position of BUFF_COUNT field.
	UDPHS_DMASTATUS1_BUFF_COUNT_Pos = 0x10
	// Bit mask of BUFF_COUNT field.
	UDPHS_DMASTATUS1_BUFF_COUNT_Msk = 0xffff0000

	// DMANXTDSC2: UDPHS DMA Next Descriptor Address Register (channel = 2)
	// Position of NXT_DSC_ADD field.
	UDPHS_DMANXTDSC2_NXT_DSC_ADD_Pos = 0x0
	// Bit mask of NXT_DSC_ADD field.
	UDPHS_DMANXTDSC2_NXT_DSC_ADD_Msk = 0xffffffff

	// DMAADDRESS2: UDPHS DMA Channel Address Register (channel = 2)
	// Position of BUFF_ADD field.
	UDPHS_DMAADDRESS2_BUFF_ADD_Pos = 0x0
	// Bit mask of BUFF_ADD field.
	UDPHS_DMAADDRESS2_BUFF_ADD_Msk = 0xffffffff

	// DMACONTROL2: UDPHS DMA Channel Control Register (channel = 2)
	// Position of CHANN_ENB field.
	UDPHS_DMACONTROL2_CHANN_ENB_Pos = 0x0
	// Bit mask of CHANN_ENB field.
	UDPHS_DMACONTROL2_CHANN_ENB_Msk = 0x1
	// Bit CHANN_ENB.
	UDPHS_DMACONTROL2_CHANN_ENB = 0x1
	// Position of LDNXT_DSC field.
	UDPHS_DMACONTROL2_LDNXT_DSC_Pos = 0x1
	// Bit mask of LDNXT_DSC field.
	UDPHS_DMACONTROL2_LDNXT_DSC_Msk = 0x2
	// Bit LDNXT_DSC.
	UDPHS_DMACONTROL2_LDNXT_DSC = 0x2
	// Position of END_TR_EN field.
	UDPHS_DMACONTROL2_END_TR_EN_Pos = 0x2
	// Bit mask of END_TR_EN field.
	UDPHS_DMACONTROL2_END_TR_EN_Msk = 0x4
	// Bit END_TR_EN.
	UDPHS_DMACONTROL2_END_TR_EN = 0x4
	// Position of END_B_EN field.
	UDPHS_DMACONTROL2_END_B_EN_Pos = 0x3
	// Bit mask of END_B_EN field.
	UDPHS_DMACONTROL2_END_B_EN_Msk = 0x8
	// Bit END_B_EN.
	UDPHS_DMACONTROL2_END_B_EN = 0x8
	// Position of END_TR_IT field.
	UDPHS_DMACONTROL2_END_TR_IT_Pos = 0x4
	// Bit mask of END_TR_IT field.
	UDPHS_DMACONTROL2_END_TR_IT_Msk = 0x10
	// Bit END_TR_IT.
	UDPHS_DMACONTROL2_END_TR_IT = 0x10
	// Position of END_BUFFIT field.
	UDPHS_DMACONTROL2_END_BUFFIT_Pos = 0x5
	// Bit mask of END_BUFFIT field.
	UDPHS_DMACONTROL2_END_BUFFIT_Msk = 0x20
	// Bit END_BUFFIT.
	UDPHS_DMACONTROL2_END_BUFFIT = 0x20
	// Position of DESC_LD_IT field.
	UDPHS_DMACONTROL2_DESC_LD_IT_Pos = 0x6
	// Bit mask of DESC_LD_IT field.
	UDPHS_DMACONTROL2_DESC_LD_IT_Msk = 0x40
	// Bit DESC_LD_IT.
	UDPHS_DMACONTROL2_DESC_LD_IT = 0x40
	// Position of BURST_LCK field.
	UDPHS_DMACONTROL2_BURST_LCK_Pos = 0x7
	// Bit mask of BURST_LCK field.
	UDPHS_DMACONTROL2_BURST_LCK_Msk = 0x80
	// Bit BURST_LCK.
	UDPHS_DMACONTROL2_BURST_LCK = 0x80
	// Position of BUFF_LENGTH field.
	UDPHS_DMACONTROL2_BUFF_LENGTH_Pos = 0x10
	// Bit mask of BUFF_LENGTH field.
	UDPHS_DMACONTROL2_BUFF_LENGTH_Msk = 0xffff0000

	// DMASTATUS2: UDPHS DMA Channel Status Register (channel = 2)
	// Position of CHANN_ENB field.
	UDPHS_DMASTATUS2_CHANN_ENB_Pos = 0x0
	// Bit mask of CHANN_ENB field.
	UDPHS_DMASTATUS2_CHANN_ENB_Msk = 0x1
	// Bit CHANN_ENB.
	UDPHS_DMASTATUS2_CHANN_ENB = 0x1
	// Position of CHANN_ACT field.
	UDPHS_DMASTATUS2_CHANN_ACT_Pos = 0x1
	// Bit mask of CHANN_ACT field.
	UDPHS_DMASTATUS2_CHANN_ACT_Msk = 0x2
	// Bit CHANN_ACT.
	UDPHS_DMASTATUS2_CHANN_ACT = 0x2
	// Position of END_TR_ST field.
	UDPHS_DMASTATUS2_END_TR_ST_Pos = 0x4
	// Bit mask of END_TR_ST field.
	UDPHS_DMASTATUS2_END_TR_ST_Msk = 0x10
	// Bit END_TR_ST.
	UDPHS_DMASTATUS2_END_TR_ST = 0x10
	// Position of END_BF_ST field.
	UDPHS_DMASTATUS2_END_BF_ST_Pos = 0x5
	// Bit mask of END_BF_ST field.
	UDPHS_DMASTATUS2_END_BF_ST_Msk = 0x20
	// Bit END_BF_ST.
	UDPHS_DMASTATUS2_END_BF_ST = 0x20
	// Position of DESC_LDST field.
	UDPHS_DMASTATUS2_DESC_LDST_Pos = 0x6
	// Bit mask of DESC_LDST field.
	UDPHS_DMASTATUS2_DESC_LDST_Msk = 0x40
	// Bit DESC_LDST.
	UDPHS_DMASTATUS2_DESC_LDST = 0x40
	// Position of BUFF_COUNT field.
	UDPHS_DMASTATUS2_BUFF_COUNT_Pos = 0x10
	// Bit mask of BUFF_COUNT field.
	UDPHS_DMASTATUS2_BUFF_COUNT_Msk = 0xffff0000

	// DMANXTDSC3: UDPHS DMA Next Descriptor Address Register (channel = 3)
	// Position of NXT_DSC_ADD field.
	UDPHS_DMANXTDSC3_NXT_DSC_ADD_Pos = 0x0
	// Bit mask of NXT_DSC_ADD field.
	UDPHS_DMANXTDSC3_NXT_DSC_ADD_Msk = 0xffffffff

	// DMAADDRESS3: UDPHS DMA Channel Address Register (channel = 3)
	// Position of BUFF_ADD field.
	UDPHS_DMAADDRESS3_BUFF_ADD_Pos = 0x0
	// Bit mask of BUFF_ADD field.
	UDPHS_DMAADDRESS3_BUFF_ADD_Msk = 0xffffffff

	// DMACONTROL3: UDPHS DMA Channel Control Register (channel = 3)
	// Position of CHANN_ENB field.
	UDPHS_DMACONTROL3_CHANN_ENB_Pos = 0x0
	// Bit mask of CHANN_ENB field.
	UDPHS_DMACONTROL3_CHANN_ENB_Msk = 0x1
	// Bit CHANN_ENB.
	UDPHS_DMACONTROL3_CHANN_ENB = 0x1
	// Position of LDNXT_DSC field.
	UDPHS_DMACONTROL3_LDNXT_DSC_Pos = 0x1
	// Bit mask of LDNXT_DSC field.
	UDPHS_DMACONTROL3_LDNXT_DSC_Msk = 0x2
	// Bit LDNXT_DSC.
	UDPHS_DMACONTROL3_LDNXT_DSC = 0x2
	// Position of END_TR_EN field.
	UDPHS_DMACONTROL3_END_TR_EN_Pos = 0x2
	// Bit mask of END_TR_EN field.
	UDPHS_DMACONTROL3_END_TR_EN_Msk = 0x4
	// Bit END_TR_EN.
	UDPHS_DMACONTROL3_END_TR_EN = 0x4
	// Position of END_B_EN field.
	UDPHS_DMACONTROL3_END_B_EN_Pos = 0x3
	// Bit mask of END_B_EN field.
	UDPHS_DMACONTROL3_END_B_EN_Msk = 0x8
	// Bit END_B_EN.
	UDPHS_DMACONTROL3_END_B_EN = 0x8
	// Position of END_TR_IT field.
	UDPHS_DMACONTROL3_END_TR_IT_Pos = 0x4
	// Bit mask of END_TR_IT field.
	UDPHS_DMACONTROL3_END_TR_IT_Msk = 0x10
	// Bit END_TR_IT.
	UDPHS_DMACONTROL3_END_TR_IT = 0x10
	// Position of END_BUFFIT field.
	UDPHS_DMACONTROL3_END_BUFFIT_Pos = 0x5
	// Bit mask of END_BUFFIT field.
	UDPHS_DMACONTROL3_END_BUFFIT_Msk = 0x20
	// Bit END_BUFFIT.
	UDPHS_DMACONTROL3_END_BUFFIT = 0x20
	// Position of DESC_LD_IT field.
	UDPHS_DMACONTROL3_DESC_LD_IT_Pos = 0x6
	// Bit mask of DESC_LD_IT field.
	UDPHS_DMACONTROL3_DESC_LD_IT_Msk = 0x40
	// Bit DESC_LD_IT.
	UDPHS_DMACONTROL3_DESC_LD_IT = 0x40
	// Position of BURST_LCK field.
	UDPHS_DMACONTROL3_BURST_LCK_Pos = 0x7
	// Bit mask of BURST_LCK field.
	UDPHS_DMACONTROL3_BURST_LCK_Msk = 0x80
	// Bit BURST_LCK.
	UDPHS_DMACONTROL3_BURST_LCK = 0x80
	// Position of BUFF_LENGTH field.
	UDPHS_DMACONTROL3_BUFF_LENGTH_Pos = 0x10
	// Bit mask of BUFF_LENGTH field.
	UDPHS_DMACONTROL3_BUFF_LENGTH_Msk = 0xffff0000

	// DMASTATUS3: UDPHS DMA Channel Status Register (channel = 3)
	// Position of CHANN_ENB field.
	UDPHS_DMASTATUS3_CHANN_ENB_Pos = 0x0
	// Bit mask of CHANN_ENB field.
	UDPHS_DMASTATUS3_CHANN_ENB_Msk = 0x1
	// Bit CHANN_ENB.
	UDPHS_DMASTATUS3_CHANN_ENB = 0x1
	// Position of CHANN_ACT field.
	UDPHS_DMASTATUS3_CHANN_ACT_Pos = 0x1
	// Bit mask of CHANN_ACT field.
	UDPHS_DMASTATUS3_CHANN_ACT_Msk = 0x2
	// Bit CHANN_ACT.
	UDPHS_DMASTATUS3_CHANN_ACT = 0x2
	// Position of END_TR_ST field.
	UDPHS_DMASTATUS3_END_TR_ST_Pos = 0x4
	// Bit mask of END_TR_ST field.
	UDPHS_DMASTATUS3_END_TR_ST_Msk = 0x10
	// Bit END_TR_ST.
	UDPHS_DMASTATUS3_END_TR_ST = 0x10
	// Position of END_BF_ST field.
	UDPHS_DMASTATUS3_END_BF_ST_Pos = 0x5
	// Bit mask of END_BF_ST field.
	UDPHS_DMASTATUS3_END_BF_ST_Msk = 0x20
	// Bit END_BF_ST.
	UDPHS_DMASTATUS3_END_BF_ST = 0x20
	// Position of DESC_LDST field.
	UDPHS_DMASTATUS3_DESC_LDST_Pos = 0x6
	// Bit mask of DESC_LDST field.
	UDPHS_DMASTATUS3_DESC_LDST_Msk = 0x40
	// Bit DESC_LDST.
	UDPHS_DMASTATUS3_DESC_LDST = 0x40
	// Position of BUFF_COUNT field.
	UDPHS_DMASTATUS3_BUFF_COUNT_Pos = 0x10
	// Bit mask of BUFF_COUNT field.
	UDPHS_DMASTATUS3_BUFF_COUNT_Msk = 0xffff0000

	// DMANXTDSC4: UDPHS DMA Next Descriptor Address Register (channel = 4)
	// Position of NXT_DSC_ADD field.
	UDPHS_DMANXTDSC4_NXT_DSC_ADD_Pos = 0x0
	// Bit mask of NXT_DSC_ADD field.
	UDPHS_DMANXTDSC4_NXT_DSC_ADD_Msk = 0xffffffff

	// DMAADDRESS4: UDPHS DMA Channel Address Register (channel = 4)
	// Position of BUFF_ADD field.
	UDPHS_DMAADDRESS4_BUFF_ADD_Pos = 0x0
	// Bit mask of BUFF_ADD field.
	UDPHS_DMAADDRESS4_BUFF_ADD_Msk = 0xffffffff

	// DMACONTROL4: UDPHS DMA Channel Control Register (channel = 4)
	// Position of CHANN_ENB field.
	UDPHS_DMACONTROL4_CHANN_ENB_Pos = 0x0
	// Bit mask of CHANN_ENB field.
	UDPHS_DMACONTROL4_CHANN_ENB_Msk = 0x1
	// Bit CHANN_ENB.
	UDPHS_DMACONTROL4_CHANN_ENB = 0x1
	// Position of LDNXT_DSC field.
	UDPHS_DMACONTROL4_LDNXT_DSC_Pos = 0x1
	// Bit mask of LDNXT_DSC field.
	UDPHS_DMACONTROL4_LDNXT_DSC_Msk = 0x2
	// Bit LDNXT_DSC.
	UDPHS_DMACONTROL4_LDNXT_DSC = 0x2
	// Position of END_TR_EN field.
	UDPHS_DMACONTROL4_END_TR_EN_Pos = 0x2
	// Bit mask of END_TR_EN field.
	UDPHS_DMACONTROL4_END_TR_EN_Msk = 0x4
	// Bit END_TR_EN.
	UDPHS_DMACONTROL4_END_TR_EN = 0x4
	// Position of END_B_EN field.
	UDPHS_DMACONTROL4_END_B_EN_Pos = 0x3
	// Bit mask of END_B_EN field.
	UDPHS_DMACONTROL4_END_B_EN_Msk = 0x8
	// Bit END_B_EN.
	UDPHS_DMACONTROL4_END_B_EN = 0x8
	// Position of END_TR_IT field.
	UDPHS_DMACONTROL4_END_TR_IT_Pos = 0x4
	// Bit mask of END_TR_IT field.
	UDPHS_DMACONTROL4_END_TR_IT_Msk = 0x10
	// Bit END_TR_IT.
	UDPHS_DMACONTROL4_END_TR_IT = 0x10
	// Position of END_BUFFIT field.
	UDPHS_DMACONTROL4_END_BUFFIT_Pos = 0x5
	// Bit mask of END_BUFFIT field.
	UDPHS_DMACONTROL4_END_BUFFIT_Msk = 0x20
	// Bit END_BUFFIT.
	UDPHS_DMACONTROL4_END_BUFFIT = 0x20
	// Position of DESC_LD_IT field.
	UDPHS_DMACONTROL4_DESC_LD_IT_Pos = 0x6
	// Bit mask of DESC_LD_IT field.
	UDPHS_DMACONTROL4_DESC_LD_IT_Msk = 0x40
	// Bit DESC_LD_IT.
	UDPHS_DMACONTROL4_DESC_LD_IT = 0x40
	// Position of BURST_LCK field.
	UDPHS_DMACONTROL4_BURST_LCK_Pos = 0x7
	// Bit mask of BURST_LCK field.
	UDPHS_DMACONTROL4_BURST_LCK_Msk = 0x80
	// Bit BURST_LCK.
	UDPHS_DMACONTROL4_BURST_LCK = 0x80
	// Position of BUFF_LENGTH field.
	UDPHS_DMACONTROL4_BUFF_LENGTH_Pos = 0x10
	// Bit mask of BUFF_LENGTH field.
	UDPHS_DMACONTROL4_BUFF_LENGTH_Msk = 0xffff0000

	// DMASTATUS4: UDPHS DMA Channel Status Register (channel = 4)
	// Position of CHANN_ENB field.
	UDPHS_DMASTATUS4_CHANN_ENB_Pos = 0x0
	// Bit mask of CHANN_ENB field.
	UDPHS_DMASTATUS4_CHANN_ENB_Msk = 0x1
	// Bit CHANN_ENB.
	UDPHS_DMASTATUS4_CHANN_ENB = 0x1
	// Position of CHANN_ACT field.
	UDPHS_DMASTATUS4_CHANN_ACT_Pos = 0x1
	// Bit mask of CHANN_ACT field.
	UDPHS_DMASTATUS4_CHANN_ACT_Msk = 0x2
	// Bit CHANN_ACT.
	UDPHS_DMASTATUS4_CHANN_ACT = 0x2
	// Position of END_TR_ST field.
	UDPHS_DMASTATUS4_END_TR_ST_Pos = 0x4
	// Bit mask of END_TR_ST field.
	UDPHS_DMASTATUS4_END_TR_ST_Msk = 0x10
	// Bit END_TR_ST.
	UDPHS_DMASTATUS4_END_TR_ST = 0x10
	// Position of END_BF_ST field.
	UDPHS_DMASTATUS4_END_BF_ST_Pos = 0x5
	// Bit mask of END_BF_ST field.
	UDPHS_DMASTATUS4_END_BF_ST_Msk = 0x20
	// Bit END_BF_ST.
	UDPHS_DMASTATUS4_END_BF_ST = 0x20
	// Position of DESC_LDST field.
	UDPHS_DMASTATUS4_DESC_LDST_Pos = 0x6
	// Bit mask of DESC_LDST field.
	UDPHS_DMASTATUS4_DESC_LDST_Msk = 0x40
	// Bit DESC_LDST.
	UDPHS_DMASTATUS4_DESC_LDST = 0x40
	// Position of BUFF_COUNT field.
	UDPHS_DMASTATUS4_BUFF_COUNT_Pos = 0x10
	// Bit mask of BUFF_COUNT field.
	UDPHS_DMASTATUS4_BUFF_COUNT_Msk = 0xffff0000

	// DMANXTDSC5: UDPHS DMA Next Descriptor Address Register (channel = 5)
	// Position of NXT_DSC_ADD field.
	UDPHS_DMANXTDSC5_NXT_DSC_ADD_Pos = 0x0
	// Bit mask of NXT_DSC_ADD field.
	UDPHS_DMANXTDSC5_NXT_DSC_ADD_Msk = 0xffffffff

	// DMAADDRESS5: UDPHS DMA Channel Address Register (channel = 5)
	// Position of BUFF_ADD field.
	UDPHS_DMAADDRESS5_BUFF_ADD_Pos = 0x0
	// Bit mask of BUFF_ADD field.
	UDPHS_DMAADDRESS5_BUFF_ADD_Msk = 0xffffffff

	// DMACONTROL5: UDPHS DMA Channel Control Register (channel = 5)
	// Position of CHANN_ENB field.
	UDPHS_DMACONTROL5_CHANN_ENB_Pos = 0x0
	// Bit mask of CHANN_ENB field.
	UDPHS_DMACONTROL5_CHANN_ENB_Msk = 0x1
	// Bit CHANN_ENB.
	UDPHS_DMACONTROL5_CHANN_ENB = 0x1
	// Position of LDNXT_DSC field.
	UDPHS_DMACONTROL5_LDNXT_DSC_Pos = 0x1
	// Bit mask of LDNXT_DSC field.
	UDPHS_DMACONTROL5_LDNXT_DSC_Msk = 0x2
	// Bit LDNXT_DSC.
	UDPHS_DMACONTROL5_LDNXT_DSC = 0x2
	// Position of END_TR_EN field.
	UDPHS_DMACONTROL5_END_TR_EN_Pos = 0x2
	// Bit mask of END_TR_EN field.
	UDPHS_DMACONTROL5_END_TR_EN_Msk = 0x4
	// Bit END_TR_EN.
	UDPHS_DMACONTROL5_END_TR_EN = 0x4
	// Position of END_B_EN field.
	UDPHS_DMACONTROL5_END_B_EN_Pos = 0x3
	// Bit mask of END_B_EN field.
	UDPHS_DMACONTROL5_END_B_EN_Msk = 0x8
	// Bit END_B_EN.
	UDPHS_DMACONTROL5_END_B_EN = 0x8
	// Position of END_TR_IT field.
	UDPHS_DMACONTROL5_END_TR_IT_Pos = 0x4
	// Bit mask of END_TR_IT field.
	UDPHS_DMACONTROL5_END_TR_IT_Msk = 0x10
	// Bit END_TR_IT.
	UDPHS_DMACONTROL5_END_TR_IT = 0x10
	// Position of END_BUFFIT field.
	UDPHS_DMACONTROL5_END_BUFFIT_Pos = 0x5
	// Bit mask of END_BUFFIT field.
	UDPHS_DMACONTROL5_END_BUFFIT_Msk = 0x20
	// Bit END_BUFFIT.
	UDPHS_DMACONTROL5_END_BUFFIT = 0x20
	// Position of DESC_LD_IT field.
	UDPHS_DMACONTROL5_DESC_LD_IT_Pos = 0x6
	// Bit mask of DESC_LD_IT field.
	UDPHS_DMACONTROL5_DESC_LD_IT_Msk = 0x40
	// Bit DESC_LD_IT.
	UDPHS_DMACONTROL5_DESC_LD_IT = 0x40
	// Position of BURST_LCK field.
	UDPHS_DMACONTROL5_BURST_LCK_Pos = 0x7
	// Bit mask of BURST_LCK field.
	UDPHS_DMACONTROL5_BURST_LCK_Msk = 0x80
	// Bit BURST_LCK.
	UDPHS_DMACONTROL5_BURST_LCK = 0x80
	// Position of BUFF_LENGTH field.
	UDPHS_DMACONTROL5_BUFF_LENGTH_Pos = 0x10
	// Bit mask of BUFF_LENGTH field.
	UDPHS_DMACONTROL5_BUFF_LENGTH_Msk = 0xffff0000

	// DMASTATUS5: UDPHS DMA Channel Status Register (channel = 5)
	// Position of CHANN_ENB field.
	UDPHS_DMASTATUS5_CHANN_ENB_Pos = 0x0
	// Bit mask of CHANN_ENB field.
	UDPHS_DMASTATUS5_CHANN_ENB_Msk = 0x1
	// Bit CHANN_ENB.
	UDPHS_DMASTATUS5_CHANN_ENB = 0x1
	// Position of CHANN_ACT field.
	UDPHS_DMASTATUS5_CHANN_ACT_Pos = 0x1
	// Bit mask of CHANN_ACT field.
	UDPHS_DMASTATUS5_CHANN_ACT_Msk = 0x2
	// Bit CHANN_ACT.
	UDPHS_DMASTATUS5_CHANN_ACT = 0x2
	// Position of END_TR_ST field.
	UDPHS_DMASTATUS5_END_TR_ST_Pos = 0x4
	// Bit mask of END_TR_ST field.
	UDPHS_DMASTATUS5_END_TR_ST_Msk = 0x10
	// Bit END_TR_ST.
	UDPHS_DMASTATUS5_END_TR_ST = 0x10
	// Position of END_BF_ST field.
	UDPHS_DMASTATUS5_END_BF_ST_Pos = 0x5
	// Bit mask of END_BF_ST field.
	UDPHS_DMASTATUS5_END_BF_ST_Msk = 0x20
	// Bit END_BF_ST.
	UDPHS_DMASTATUS5_END_BF_ST = 0x20
	// Position of DESC_LDST field.
	UDPHS_DMASTATUS5_DESC_LDST_Pos = 0x6
	// Bit mask of DESC_LDST field.
	UDPHS_DMASTATUS5_DESC_LDST_Msk = 0x40
	// Bit DESC_LDST.
	UDPHS_DMASTATUS5_DESC_LDST = 0x40
	// Position of BUFF_COUNT field.
	UDPHS_DMASTATUS5_BUFF_COUNT_Pos = 0x10
	// Bit mask of BUFF_COUNT field.
	UDPHS_DMASTATUS5_BUFF_COUNT_Msk = 0xffff0000
)

// Bitfields for ADC12B: Analog-to-Digital Converter 12bits
const (
	// CR: Control Register
	// Position of SWRST field.
	ADC12B_CR_SWRST_Pos = 0x0
	// Bit mask of SWRST field.
	ADC12B_CR_SWRST_Msk = 0x1
	// Bit SWRST.
	ADC12B_CR_SWRST = 0x1
	// Position of START field.
	ADC12B_CR_START_Pos = 0x1
	// Bit mask of START field.
	ADC12B_CR_START_Msk = 0x2
	// Bit START.
	ADC12B_CR_START = 0x2

	// MR: Mode Register
	// Position of TRGEN field.
	ADC12B_MR_TRGEN_Pos = 0x0
	// Bit mask of TRGEN field.
	ADC12B_MR_TRGEN_Msk = 0x1
	// Bit TRGEN.
	ADC12B_MR_TRGEN = 0x1
	// Position of TRGSEL field.
	ADC12B_MR_TRGSEL_Pos = 0x1
	// Bit mask of TRGSEL field.
	ADC12B_MR_TRGSEL_Msk = 0xe
	// Position of LOWRES field.
	ADC12B_MR_LOWRES_Pos = 0x4
	// Bit mask of LOWRES field.
	ADC12B_MR_LOWRES_Msk = 0x10
	// Bit LOWRES.
	ADC12B_MR_LOWRES = 0x10
	// Position of SLEEP field.
	ADC12B_MR_SLEEP_Pos = 0x5
	// Bit mask of SLEEP field.
	ADC12B_MR_SLEEP_Msk = 0x20
	// Bit SLEEP.
	ADC12B_MR_SLEEP = 0x20
	// Position of PRESCAL field.
	ADC12B_MR_PRESCAL_Pos = 0x8
	// Bit mask of PRESCAL field.
	ADC12B_MR_PRESCAL_Msk = 0xff00
	// Position of STARTUP field.
	ADC12B_MR_STARTUP_Pos = 0x10
	// Bit mask of STARTUP field.
	ADC12B_MR_STARTUP_Msk = 0xff0000
	// Position of SHTIM field.
	ADC12B_MR_SHTIM_Pos = 0x18
	// Bit mask of SHTIM field.
	ADC12B_MR_SHTIM_Msk = 0xf000000

	// CHER: Channel Enable Register
	// Position of CH0 field.
	ADC12B_CHER_CH0_Pos = 0x0
	// Bit mask of CH0 field.
	ADC12B_CHER_CH0_Msk = 0x1
	// Bit CH0.
	ADC12B_CHER_CH0 = 0x1
	// Position of CH1 field.
	ADC12B_CHER_CH1_Pos = 0x1
	// Bit mask of CH1 field.
	ADC12B_CHER_CH1_Msk = 0x2
	// Bit CH1.
	ADC12B_CHER_CH1 = 0x2
	// Position of CH2 field.
	ADC12B_CHER_CH2_Pos = 0x2
	// Bit mask of CH2 field.
	ADC12B_CHER_CH2_Msk = 0x4
	// Bit CH2.
	ADC12B_CHER_CH2 = 0x4
	// Position of CH3 field.
	ADC12B_CHER_CH3_Pos = 0x3
	// Bit mask of CH3 field.
	ADC12B_CHER_CH3_Msk = 0x8
	// Bit CH3.
	ADC12B_CHER_CH3 = 0x8
	// Position of CH4 field.
	ADC12B_CHER_CH4_Pos = 0x4
	// Bit mask of CH4 field.
	ADC12B_CHER_CH4_Msk = 0x10
	// Bit CH4.
	ADC12B_CHER_CH4 = 0x10
	// Position of CH5 field.
	ADC12B_CHER_CH5_Pos = 0x5
	// Bit mask of CH5 field.
	ADC12B_CHER_CH5_Msk = 0x20
	// Bit CH5.
	ADC12B_CHER_CH5 = 0x20
	// Position of CH6 field.
	ADC12B_CHER_CH6_Pos = 0x6
	// Bit mask of CH6 field.
	ADC12B_CHER_CH6_Msk = 0x40
	// Bit CH6.
	ADC12B_CHER_CH6 = 0x40
	// Position of CH7 field.
	ADC12B_CHER_CH7_Pos = 0x7
	// Bit mask of CH7 field.
	ADC12B_CHER_CH7_Msk = 0x80
	// Bit CH7.
	ADC12B_CHER_CH7 = 0x80

	// CHDR: Channel Disable Register
	// Position of CH0 field.
	ADC12B_CHDR_CH0_Pos = 0x0
	// Bit mask of CH0 field.
	ADC12B_CHDR_CH0_Msk = 0x1
	// Bit CH0.
	ADC12B_CHDR_CH0 = 0x1
	// Position of CH1 field.
	ADC12B_CHDR_CH1_Pos = 0x1
	// Bit mask of CH1 field.
	ADC12B_CHDR_CH1_Msk = 0x2
	// Bit CH1.
	ADC12B_CHDR_CH1 = 0x2
	// Position of CH2 field.
	ADC12B_CHDR_CH2_Pos = 0x2
	// Bit mask of CH2 field.
	ADC12B_CHDR_CH2_Msk = 0x4
	// Bit CH2.
	ADC12B_CHDR_CH2 = 0x4
	// Position of CH3 field.
	ADC12B_CHDR_CH3_Pos = 0x3
	// Bit mask of CH3 field.
	ADC12B_CHDR_CH3_Msk = 0x8
	// Bit CH3.
	ADC12B_CHDR_CH3 = 0x8
	// Position of CH4 field.
	ADC12B_CHDR_CH4_Pos = 0x4
	// Bit mask of CH4 field.
	ADC12B_CHDR_CH4_Msk = 0x10
	// Bit CH4.
	ADC12B_CHDR_CH4 = 0x10
	// Position of CH5 field.
	ADC12B_CHDR_CH5_Pos = 0x5
	// Bit mask of CH5 field.
	ADC12B_CHDR_CH5_Msk = 0x20
	// Bit CH5.
	ADC12B_CHDR_CH5 = 0x20
	// Position of CH6 field.
	ADC12B_CHDR_CH6_Pos = 0x6
	// Bit mask of CH6 field.
	ADC12B_CHDR_CH6_Msk = 0x40
	// Bit CH6.
	ADC12B_CHDR_CH6 = 0x40
	// Position of CH7 field.
	ADC12B_CHDR_CH7_Pos = 0x7
	// Bit mask of CH7 field.
	ADC12B_CHDR_CH7_Msk = 0x80
	// Bit CH7.
	ADC12B_CHDR_CH7 = 0x80

	// CHSR: Channel Status Register
	// Position of CH0 field.
	ADC12B_CHSR_CH0_Pos = 0x0
	// Bit mask of CH0 field.
	ADC12B_CHSR_CH0_Msk = 0x1
	// Bit CH0.
	ADC12B_CHSR_CH0 = 0x1
	// Position of CH1 field.
	ADC12B_CHSR_CH1_Pos = 0x1
	// Bit mask of CH1 field.
	ADC12B_CHSR_CH1_Msk = 0x2
	// Bit CH1.
	ADC12B_CHSR_CH1 = 0x2
	// Position of CH2 field.
	ADC12B_CHSR_CH2_Pos = 0x2
	// Bit mask of CH2 field.
	ADC12B_CHSR_CH2_Msk = 0x4
	// Bit CH2.
	ADC12B_CHSR_CH2 = 0x4
	// Position of CH3 field.
	ADC12B_CHSR_CH3_Pos = 0x3
	// Bit mask of CH3 field.
	ADC12B_CHSR_CH3_Msk = 0x8
	// Bit CH3.
	ADC12B_CHSR_CH3 = 0x8
	// Position of CH4 field.
	ADC12B_CHSR_CH4_Pos = 0x4
	// Bit mask of CH4 field.
	ADC12B_CHSR_CH4_Msk = 0x10
	// Bit CH4.
	ADC12B_CHSR_CH4 = 0x10
	// Position of CH5 field.
	ADC12B_CHSR_CH5_Pos = 0x5
	// Bit mask of CH5 field.
	ADC12B_CHSR_CH5_Msk = 0x20
	// Bit CH5.
	ADC12B_CHSR_CH5 = 0x20
	// Position of CH6 field.
	ADC12B_CHSR_CH6_Pos = 0x6
	// Bit mask of CH6 field.
	ADC12B_CHSR_CH6_Msk = 0x40
	// Bit CH6.
	ADC12B_CHSR_CH6 = 0x40
	// Position of CH7 field.
	ADC12B_CHSR_CH7_Pos = 0x7
	// Bit mask of CH7 field.
	ADC12B_CHSR_CH7_Msk = 0x80
	// Bit CH7.
	ADC12B_CHSR_CH7 = 0x80

	// SR: Status Register
	// Position of EOC0 field.
	ADC12B_SR_EOC0_Pos = 0x0
	// Bit mask of EOC0 field.
	ADC12B_SR_EOC0_Msk = 0x1
	// Bit EOC0.
	ADC12B_SR_EOC0 = 0x1
	// Position of EOC1 field.
	ADC12B_SR_EOC1_Pos = 0x1
	// Bit mask of EOC1 field.
	ADC12B_SR_EOC1_Msk = 0x2
	// Bit EOC1.
	ADC12B_SR_EOC1 = 0x2
	// Position of EOC2 field.
	ADC12B_SR_EOC2_Pos = 0x2
	// Bit mask of EOC2 field.
	ADC12B_SR_EOC2_Msk = 0x4
	// Bit EOC2.
	ADC12B_SR_EOC2 = 0x4
	// Position of EOC3 field.
	ADC12B_SR_EOC3_Pos = 0x3
	// Bit mask of EOC3 field.
	ADC12B_SR_EOC3_Msk = 0x8
	// Bit EOC3.
	ADC12B_SR_EOC3 = 0x8
	// Position of EOC4 field.
	ADC12B_SR_EOC4_Pos = 0x4
	// Bit mask of EOC4 field.
	ADC12B_SR_EOC4_Msk = 0x10
	// Bit EOC4.
	ADC12B_SR_EOC4 = 0x10
	// Position of EOC5 field.
	ADC12B_SR_EOC5_Pos = 0x5
	// Bit mask of EOC5 field.
	ADC12B_SR_EOC5_Msk = 0x20
	// Bit EOC5.
	ADC12B_SR_EOC5 = 0x20
	// Position of EOC6 field.
	ADC12B_SR_EOC6_Pos = 0x6
	// Bit mask of EOC6 field.
	ADC12B_SR_EOC6_Msk = 0x40
	// Bit EOC6.
	ADC12B_SR_EOC6 = 0x40
	// Position of EOC7 field.
	ADC12B_SR_EOC7_Pos = 0x7
	// Bit mask of EOC7 field.
	ADC12B_SR_EOC7_Msk = 0x80
	// Bit EOC7.
	ADC12B_SR_EOC7 = 0x80
	// Position of OVRE0 field.
	ADC12B_SR_OVRE0_Pos = 0x8
	// Bit mask of OVRE0 field.
	ADC12B_SR_OVRE0_Msk = 0x100
	// Bit OVRE0.
	ADC12B_SR_OVRE0 = 0x100
	// Position of OVRE1 field.
	ADC12B_SR_OVRE1_Pos = 0x9
	// Bit mask of OVRE1 field.
	ADC12B_SR_OVRE1_Msk = 0x200
	// Bit OVRE1.
	ADC12B_SR_OVRE1 = 0x200
	// Position of OVRE2 field.
	ADC12B_SR_OVRE2_Pos = 0xa
	// Bit mask of OVRE2 field.
	ADC12B_SR_OVRE2_Msk = 0x400
	// Bit OVRE2.
	ADC12B_SR_OVRE2 = 0x400
	// Position of OVRE3 field.
	ADC12B_SR_OVRE3_Pos = 0xb
	// Bit mask of OVRE3 field.
	ADC12B_SR_OVRE3_Msk = 0x800
	// Bit OVRE3.
	ADC12B_SR_OVRE3 = 0x800
	// Position of OVRE4 field.
	ADC12B_SR_OVRE4_Pos = 0xc
	// Bit mask of OVRE4 field.
	ADC12B_SR_OVRE4_Msk = 0x1000
	// Bit OVRE4.
	ADC12B_SR_OVRE4 = 0x1000
	// Position of OVRE5 field.
	ADC12B_SR_OVRE5_Pos = 0xd
	// Bit mask of OVRE5 field.
	ADC12B_SR_OVRE5_Msk = 0x2000
	// Bit OVRE5.
	ADC12B_SR_OVRE5 = 0x2000
	// Position of OVRE6 field.
	ADC12B_SR_OVRE6_Pos = 0xe
	// Bit mask of OVRE6 field.
	ADC12B_SR_OVRE6_Msk = 0x4000
	// Bit OVRE6.
	ADC12B_SR_OVRE6 = 0x4000
	// Position of OVRE7 field.
	ADC12B_SR_OVRE7_Pos = 0xf
	// Bit mask of OVRE7 field.
	ADC12B_SR_OVRE7_Msk = 0x8000
	// Bit OVRE7.
	ADC12B_SR_OVRE7 = 0x8000
	// Position of DRDY field.
	ADC12B_SR_DRDY_Pos = 0x10
	// Bit mask of DRDY field.
	ADC12B_SR_DRDY_Msk = 0x10000
	// Bit DRDY.
	ADC12B_SR_DRDY = 0x10000
	// Position of GOVRE field.
	ADC12B_SR_GOVRE_Pos = 0x11
	// Bit mask of GOVRE field.
	ADC12B_SR_GOVRE_Msk = 0x20000
	// Bit GOVRE.
	ADC12B_SR_GOVRE = 0x20000
	// Position of ENDRX field.
	ADC12B_SR_ENDRX_Pos = 0x12
	// Bit mask of ENDRX field.
	ADC12B_SR_ENDRX_Msk = 0x40000
	// Bit ENDRX.
	ADC12B_SR_ENDRX = 0x40000
	// Position of RXBUFF field.
	ADC12B_SR_RXBUFF_Pos = 0x13
	// Bit mask of RXBUFF field.
	ADC12B_SR_RXBUFF_Msk = 0x80000
	// Bit RXBUFF.
	ADC12B_SR_RXBUFF = 0x80000

	// LCDR: Last Converted Data Register
	// Position of LDATA field.
	ADC12B_LCDR_LDATA_Pos = 0x0
	// Bit mask of LDATA field.
	ADC12B_LCDR_LDATA_Msk = 0xfff

	// IER: Interrupt Enable Register
	// Position of EOC0 field.
	ADC12B_IER_EOC0_Pos = 0x0
	// Bit mask of EOC0 field.
	ADC12B_IER_EOC0_Msk = 0x1
	// Bit EOC0.
	ADC12B_IER_EOC0 = 0x1
	// Position of EOC1 field.
	ADC12B_IER_EOC1_Pos = 0x1
	// Bit mask of EOC1 field.
	ADC12B_IER_EOC1_Msk = 0x2
	// Bit EOC1.
	ADC12B_IER_EOC1 = 0x2
	// Position of EOC2 field.
	ADC12B_IER_EOC2_Pos = 0x2
	// Bit mask of EOC2 field.
	ADC12B_IER_EOC2_Msk = 0x4
	// Bit EOC2.
	ADC12B_IER_EOC2 = 0x4
	// Position of EOC3 field.
	ADC12B_IER_EOC3_Pos = 0x3
	// Bit mask of EOC3 field.
	ADC12B_IER_EOC3_Msk = 0x8
	// Bit EOC3.
	ADC12B_IER_EOC3 = 0x8
	// Position of EOC4 field.
	ADC12B_IER_EOC4_Pos = 0x4
	// Bit mask of EOC4 field.
	ADC12B_IER_EOC4_Msk = 0x10
	// Bit EOC4.
	ADC12B_IER_EOC4 = 0x10
	// Position of EOC5 field.
	ADC12B_IER_EOC5_Pos = 0x5
	// Bit mask of EOC5 field.
	ADC12B_IER_EOC5_Msk = 0x20
	// Bit EOC5.
	ADC12B_IER_EOC5 = 0x20
	// Position of EOC6 field.
	ADC12B_IER_EOC6_Pos = 0x6
	// Bit mask of EOC6 field.
	ADC12B_IER_EOC6_Msk = 0x40
	// Bit EOC6.
	ADC12B_IER_EOC6 = 0x40
	// Position of EOC7 field.
	ADC12B_IER_EOC7_Pos = 0x7
	// Bit mask of EOC7 field.
	ADC12B_IER_EOC7_Msk = 0x80
	// Bit EOC7.
	ADC12B_IER_EOC7 = 0x80
	// Position of OVRE0 field.
	ADC12B_IER_OVRE0_Pos = 0x8
	// Bit mask of OVRE0 field.
	ADC12B_IER_OVRE0_Msk = 0x100
	// Bit OVRE0.
	ADC12B_IER_OVRE0 = 0x100
	// Position of OVRE1 field.
	ADC12B_IER_OVRE1_Pos = 0x9
	// Bit mask of OVRE1 field.
	ADC12B_IER_OVRE1_Msk = 0x200
	// Bit OVRE1.
	ADC12B_IER_OVRE1 = 0x200
	// Position of OVRE2 field.
	ADC12B_IER_OVRE2_Pos = 0xa
	// Bit mask of OVRE2 field.
	ADC12B_IER_OVRE2_Msk = 0x400
	// Bit OVRE2.
	ADC12B_IER_OVRE2 = 0x400
	// Position of OVRE3 field.
	ADC12B_IER_OVRE3_Pos = 0xb
	// Bit mask of OVRE3 field.
	ADC12B_IER_OVRE3_Msk = 0x800
	// Bit OVRE3.
	ADC12B_IER_OVRE3 = 0x800
	// Position of OVRE4 field.
	ADC12B_IER_OVRE4_Pos = 0xc
	// Bit mask of OVRE4 field.
	ADC12B_IER_OVRE4_Msk = 0x1000
	// Bit OVRE4.
	ADC12B_IER_OVRE4 = 0x1000
	// Position of OVRE5 field.
	ADC12B_IER_OVRE5_Pos = 0xd
	// Bit mask of OVRE5 field.
	ADC12B_IER_OVRE5_Msk = 0x2000
	// Bit OVRE5.
	ADC12B_IER_OVRE5 = 0x2000
	// Position of OVRE6 field.
	ADC12B_IER_OVRE6_Pos = 0xe
	// Bit mask of OVRE6 field.
	ADC12B_IER_OVRE6_Msk = 0x4000
	// Bit OVRE6.
	ADC12B_IER_OVRE6 = 0x4000
	// Position of OVRE7 field.
	ADC12B_IER_OVRE7_Pos = 0xf
	// Bit mask of OVRE7 field.
	ADC12B_IER_OVRE7_Msk = 0x8000
	// Bit OVRE7.
	ADC12B_IER_OVRE7 = 0x8000
	// Position of DRDY field.
	ADC12B_IER_DRDY_Pos = 0x10
	// Bit mask of DRDY field.
	ADC12B_IER_DRDY_Msk = 0x10000
	// Bit DRDY.
	ADC12B_IER_DRDY = 0x10000
	// Position of GOVRE field.
	ADC12B_IER_GOVRE_Pos = 0x11
	// Bit mask of GOVRE field.
	ADC12B_IER_GOVRE_Msk = 0x20000
	// Bit GOVRE.
	ADC12B_IER_GOVRE = 0x20000
	// Position of ENDRX field.
	ADC12B_IER_ENDRX_Pos = 0x12
	// Bit mask of ENDRX field.
	ADC12B_IER_ENDRX_Msk = 0x40000
	// Bit ENDRX.
	ADC12B_IER_ENDRX = 0x40000
	// Position of RXBUFF field.
	ADC12B_IER_RXBUFF_Pos = 0x13
	// Bit mask of RXBUFF field.
	ADC12B_IER_RXBUFF_Msk = 0x80000
	// Bit RXBUFF.
	ADC12B_IER_RXBUFF = 0x80000

	// IDR: Interrupt Disable Register
	// Position of EOC0 field.
	ADC12B_IDR_EOC0_Pos = 0x0
	// Bit mask of EOC0 field.
	ADC12B_IDR_EOC0_Msk = 0x1
	// Bit EOC0.
	ADC12B_IDR_EOC0 = 0x1
	// Position of EOC1 field.
	ADC12B_IDR_EOC1_Pos = 0x1
	// Bit mask of EOC1 field.
	ADC12B_IDR_EOC1_Msk = 0x2
	// Bit EOC1.
	ADC12B_IDR_EOC1 = 0x2
	// Position of EOC2 field.
	ADC12B_IDR_EOC2_Pos = 0x2
	// Bit mask of EOC2 field.
	ADC12B_IDR_EOC2_Msk = 0x4
	// Bit EOC2.
	ADC12B_IDR_EOC2 = 0x4
	// Position of EOC3 field.
	ADC12B_IDR_EOC3_Pos = 0x3
	// Bit mask of EOC3 field.
	ADC12B_IDR_EOC3_Msk = 0x8
	// Bit EOC3.
	ADC12B_IDR_EOC3 = 0x8
	// Position of EOC4 field.
	ADC12B_IDR_EOC4_Pos = 0x4
	// Bit mask of EOC4 field.
	ADC12B_IDR_EOC4_Msk = 0x10
	// Bit EOC4.
	ADC12B_IDR_EOC4 = 0x10
	// Position of EOC5 field.
	ADC12B_IDR_EOC5_Pos = 0x5
	// Bit mask of EOC5 field.
	ADC12B_IDR_EOC5_Msk = 0x20
	// Bit EOC5.
	ADC12B_IDR_EOC5 = 0x20
	// Position of EOC6 field.
	ADC12B_IDR_EOC6_Pos = 0x6
	// Bit mask of EOC6 field.
	ADC12B_IDR_EOC6_Msk = 0x40
	// Bit EOC6.
	ADC12B_IDR_EOC6 = 0x40
	// Position of EOC7 field.
	ADC12B_IDR_EOC7_Pos = 0x7
	// Bit mask of EOC7 field.
	ADC12B_IDR_EOC7_Msk = 0x80
	// Bit EOC7.
	ADC12B_IDR_EOC7 = 0x80
	// Position of OVRE0 field.
	ADC12B_IDR_OVRE0_Pos = 0x8
	// Bit mask of OVRE0 field.
	ADC12B_IDR_OVRE0_Msk = 0x100
	// Bit OVRE0.
	ADC12B_IDR_OVRE0 = 0x100
	// Position of OVRE1 field.
	ADC12B_IDR_OVRE1_Pos = 0x9
	// Bit mask of OVRE1 field.
	ADC12B_IDR_OVRE1_Msk = 0x200
	// Bit OVRE1.
	ADC12B_IDR_OVRE1 = 0x200
	// Position of OVRE2 field.
	ADC12B_IDR_OVRE2_Pos = 0xa
	// Bit mask of OVRE2 field.
	ADC12B_IDR_OVRE2_Msk = 0x400
	// Bit OVRE2.
	ADC12B_IDR_OVRE2 = 0x400
	// Position of OVRE3 field.
	ADC12B_IDR_OVRE3_Pos = 0xb
	// Bit mask of OVRE3 field.
	ADC12B_IDR_OVRE3_Msk = 0x800
	// Bit OVRE3.
	ADC12B_IDR_OVRE3 = 0x800
	// Position of OVRE4 field.
	ADC12B_IDR_OVRE4_Pos = 0xc
	// Bit mask of OVRE4 field.
	ADC12B_IDR_OVRE4_Msk = 0x1000
	// Bit OVRE4.
	ADC12B_IDR_OVRE4 = 0x1000
	// Position of OVRE5 field.
	ADC12B_IDR_OVRE5_Pos = 0xd
	// Bit mask of OVRE5 field.
	ADC12B_IDR_OVRE5_Msk = 0x2000
	// Bit OVRE5.
	ADC12B_IDR_OVRE5 = 0x2000
	// Position of OVRE6 field.
	ADC12B_IDR_OVRE6_Pos = 0xe
	// Bit mask of OVRE6 field.
	ADC12B_IDR_OVRE6_Msk = 0x4000
	// Bit OVRE6.
	ADC12B_IDR_OVRE6 = 0x4000
	// Position of OVRE7 field.
	ADC12B_IDR_OVRE7_Pos = 0xf
	// Bit mask of OVRE7 field.
	ADC12B_IDR_OVRE7_Msk = 0x8000
	// Bit OVRE7.
	ADC12B_IDR_OVRE7 = 0x8000
	// Position of DRDY field.
	ADC12B_IDR_DRDY_Pos = 0x10
	// Bit mask of DRDY field.
	ADC12B_IDR_DRDY_Msk = 0x10000
	// Bit DRDY.
	ADC12B_IDR_DRDY = 0x10000
	// Position of GOVRE field.
	ADC12B_IDR_GOVRE_Pos = 0x11
	// Bit mask of GOVRE field.
	ADC12B_IDR_GOVRE_Msk = 0x20000
	// Bit GOVRE.
	ADC12B_IDR_GOVRE = 0x20000
	// Position of ENDRX field.
	ADC12B_IDR_ENDRX_Pos = 0x12
	// Bit mask of ENDRX field.
	ADC12B_IDR_ENDRX_Msk = 0x40000
	// Bit ENDRX.
	ADC12B_IDR_ENDRX = 0x40000
	// Position of RXBUFF field.
	ADC12B_IDR_RXBUFF_Pos = 0x13
	// Bit mask of RXBUFF field.
	ADC12B_IDR_RXBUFF_Msk = 0x80000
	// Bit RXBUFF.
	ADC12B_IDR_RXBUFF = 0x80000

	// IMR: Interrupt Mask Register
	// Position of EOC0 field.
	ADC12B_IMR_EOC0_Pos = 0x0
	// Bit mask of EOC0 field.
	ADC12B_IMR_EOC0_Msk = 0x1
	// Bit EOC0.
	ADC12B_IMR_EOC0 = 0x1
	// Position of EOC1 field.
	ADC12B_IMR_EOC1_Pos = 0x1
	// Bit mask of EOC1 field.
	ADC12B_IMR_EOC1_Msk = 0x2
	// Bit EOC1.
	ADC12B_IMR_EOC1 = 0x2
	// Position of EOC2 field.
	ADC12B_IMR_EOC2_Pos = 0x2
	// Bit mask of EOC2 field.
	ADC12B_IMR_EOC2_Msk = 0x4
	// Bit EOC2.
	ADC12B_IMR_EOC2 = 0x4
	// Position of EOC3 field.
	ADC12B_IMR_EOC3_Pos = 0x3
	// Bit mask of EOC3 field.
	ADC12B_IMR_EOC3_Msk = 0x8
	// Bit EOC3.
	ADC12B_IMR_EOC3 = 0x8
	// Position of EOC4 field.
	ADC12B_IMR_EOC4_Pos = 0x4
	// Bit mask of EOC4 field.
	ADC12B_IMR_EOC4_Msk = 0x10
	// Bit EOC4.
	ADC12B_IMR_EOC4 = 0x10
	// Position of EOC5 field.
	ADC12B_IMR_EOC5_Pos = 0x5
	// Bit mask of EOC5 field.
	ADC12B_IMR_EOC5_Msk = 0x20
	// Bit EOC5.
	ADC12B_IMR_EOC5 = 0x20
	// Position of EOC6 field.
	ADC12B_IMR_EOC6_Pos = 0x6
	// Bit mask of EOC6 field.
	ADC12B_IMR_EOC6_Msk = 0x40
	// Bit EOC6.
	ADC12B_IMR_EOC6 = 0x40
	// Position of EOC7 field.
	ADC12B_IMR_EOC7_Pos = 0x7
	// Bit mask of EOC7 field.
	ADC12B_IMR_EOC7_Msk = 0x80
	// Bit EOC7.
	ADC12B_IMR_EOC7 = 0x80
	// Position of OVRE0 field.
	ADC12B_IMR_OVRE0_Pos = 0x8
	// Bit mask of OVRE0 field.
	ADC12B_IMR_OVRE0_Msk = 0x100
	// Bit OVRE0.
	ADC12B_IMR_OVRE0 = 0x100
	// Position of OVRE1 field.
	ADC12B_IMR_OVRE1_Pos = 0x9
	// Bit mask of OVRE1 field.
	ADC12B_IMR_OVRE1_Msk = 0x200
	// Bit OVRE1.
	ADC12B_IMR_OVRE1 = 0x200
	// Position of OVRE2 field.
	ADC12B_IMR_OVRE2_Pos = 0xa
	// Bit mask of OVRE2 field.
	ADC12B_IMR_OVRE2_Msk = 0x400
	// Bit OVRE2.
	ADC12B_IMR_OVRE2 = 0x400
	// Position of OVRE3 field.
	ADC12B_IMR_OVRE3_Pos = 0xb
	// Bit mask of OVRE3 field.
	ADC12B_IMR_OVRE3_Msk = 0x800
	// Bit OVRE3.
	ADC12B_IMR_OVRE3 = 0x800
	// Position of OVRE4 field.
	ADC12B_IMR_OVRE4_Pos = 0xc
	// Bit mask of OVRE4 field.
	ADC12B_IMR_OVRE4_Msk = 0x1000
	// Bit OVRE4.
	ADC12B_IMR_OVRE4 = 0x1000
	// Position of OVRE5 field.
	ADC12B_IMR_OVRE5_Pos = 0xd
	// Bit mask of OVRE5 field.
	ADC12B_IMR_OVRE5_Msk = 0x2000
	// Bit OVRE5.
	ADC12B_IMR_OVRE5 = 0x2000
	// Position of OVRE6 field.
	ADC12B_IMR_OVRE6_Pos = 0xe
	// Bit mask of OVRE6 field.
	ADC12B_IMR_OVRE6_Msk = 0x4000
	// Bit OVRE6.
	ADC12B_IMR_OVRE6 = 0x4000
	// Position of OVRE7 field.
	ADC12B_IMR_OVRE7_Pos = 0xf
	// Bit mask of OVRE7 field.
	ADC12B_IMR_OVRE7_Msk = 0x8000
	// Bit OVRE7.
	ADC12B_IMR_OVRE7 = 0x8000
	// Position of DRDY field.
	ADC12B_IMR_DRDY_Pos = 0x10
	// Bit mask of DRDY field.
	ADC12B_IMR_DRDY_Msk = 0x10000
	// Bit DRDY.
	ADC12B_IMR_DRDY = 0x10000
	// Position of GOVRE field.
	ADC12B_IMR_GOVRE_Pos = 0x11
	// Bit mask of GOVRE field.
	ADC12B_IMR_GOVRE_Msk = 0x20000
	// Bit GOVRE.
	ADC12B_IMR_GOVRE = 0x20000
	// Position of ENDRX field.
	ADC12B_IMR_ENDRX_Pos = 0x12
	// Bit mask of ENDRX field.
	ADC12B_IMR_ENDRX_Msk = 0x40000
	// Bit ENDRX.
	ADC12B_IMR_ENDRX = 0x40000
	// Position of RXBUFF field.
	ADC12B_IMR_RXBUFF_Pos = 0x13
	// Bit mask of RXBUFF field.
	ADC12B_IMR_RXBUFF_Msk = 0x80000
	// Bit RXBUFF.
	ADC12B_IMR_RXBUFF = 0x80000

	// CDR: Channel Data Register
	// Position of DATA field.
	ADC12B_CDR_DATA_Pos = 0x0
	// Bit mask of DATA field.
	ADC12B_CDR_DATA_Msk = 0xfff

	// ACR: Analog Control Register
	// Position of GAIN field.
	ADC12B_ACR_GAIN_Pos = 0x0
	// Bit mask of GAIN field.
	ADC12B_ACR_GAIN_Msk = 0x3
	// Position of IBCTL field.
	ADC12B_ACR_IBCTL_Pos = 0x8
	// Bit mask of IBCTL field.
	ADC12B_ACR_IBCTL_Msk = 0x300
	// Position of DIFF field.
	ADC12B_ACR_DIFF_Pos = 0x10
	// Bit mask of DIFF field.
	ADC12B_ACR_DIFF_Msk = 0x10000
	// Bit DIFF.
	ADC12B_ACR_DIFF = 0x10000
	// Position of OFFSET field.
	ADC12B_ACR_OFFSET_Pos = 0x11
	// Bit mask of OFFSET field.
	ADC12B_ACR_OFFSET_Msk = 0x20000
	// Bit OFFSET.
	ADC12B_ACR_OFFSET = 0x20000

	// EMR: Extended Mode Register
	// Position of OFFMODES field.
	ADC12B_EMR_OFFMODES_Pos = 0x0
	// Bit mask of OFFMODES field.
	ADC12B_EMR_OFFMODES_Msk = 0x1
	// Bit OFFMODES.
	ADC12B_EMR_OFFMODES = 0x1
	// Position of OFF_MODE_STARTUP_TIME field.
	ADC12B_EMR_OFF_MODE_STARTUP_TIME_Pos = 0x10
	// Bit mask of OFF_MODE_STARTUP_TIME field.
	ADC12B_EMR_OFF_MODE_STARTUP_TIME_Msk = 0xff0000

	// RPR: Receive Pointer Register
	// Position of RXPTR field.
	ADC12B_RPR_RXPTR_Pos = 0x0
	// Bit mask of RXPTR field.
	ADC12B_RPR_RXPTR_Msk = 0xffffffff

	// RCR: Receive Counter Register
	// Position of RXCTR field.
	ADC12B_RCR_RXCTR_Pos = 0x0
	// Bit mask of RXCTR field.
	ADC12B_RCR_RXCTR_Msk = 0xffff

	// RNPR: Receive Next Pointer Register
	// Position of RXNPTR field.
	ADC12B_RNPR_RXNPTR_Pos = 0x0
	// Bit mask of RXNPTR field.
	ADC12B_RNPR_RXNPTR_Msk = 0xffffffff

	// RNCR: Receive Next Counter Register
	// Position of RXNCTR field.
	ADC12B_RNCR_RXNCTR_Pos = 0x0
	// Bit mask of RXNCTR field.
	ADC12B_RNCR_RXNCTR_Msk = 0xffff

	// PTCR: Transfer Control Register
	// Position of RXTEN field.
	ADC12B_PTCR_RXTEN_Pos = 0x0
	// Bit mask of RXTEN field.
	ADC12B_PTCR_RXTEN_Msk = 0x1
	// Bit RXTEN.
	ADC12B_PTCR_RXTEN = 0x1
	// Position of RXTDIS field.
	ADC12B_PTCR_RXTDIS_Pos = 0x1
	// Bit mask of RXTDIS field.
	ADC12B_PTCR_RXTDIS_Msk = 0x2
	// Bit RXTDIS.
	ADC12B_PTCR_RXTDIS = 0x2
	// Position of TXTEN field.
	ADC12B_PTCR_TXTEN_Pos = 0x8
	// Bit mask of TXTEN field.
	ADC12B_PTCR_TXTEN_Msk = 0x100
	// Bit TXTEN.
	ADC12B_PTCR_TXTEN = 0x100
	// Position of TXTDIS field.
	ADC12B_PTCR_TXTDIS_Pos = 0x9
	// Bit mask of TXTDIS field.
	ADC12B_PTCR_TXTDIS_Msk = 0x200
	// Bit TXTDIS.
	ADC12B_PTCR_TXTDIS = 0x200

	// PTSR: Transfer Status Register
	// Position of RXTEN field.
	ADC12B_PTSR_RXTEN_Pos = 0x0
	// Bit mask of RXTEN field.
	ADC12B_PTSR_RXTEN_Msk = 0x1
	// Bit RXTEN.
	ADC12B_PTSR_RXTEN = 0x1
	// Position of TXTEN field.
	ADC12B_PTSR_TXTEN_Pos = 0x8
	// Bit mask of TXTEN field.
	ADC12B_PTSR_TXTEN_Msk = 0x100
	// Bit TXTEN.
	ADC12B_PTSR_TXTEN = 0x100
)

// Bitfields for ADC: Analog-to-Digital Converter
const (
	// CR: Control Register
	// Position of SWRST field.
	ADC_CR_SWRST_Pos = 0x0
	// Bit mask of SWRST field.
	ADC_CR_SWRST_Msk = 0x1
	// Bit SWRST.
	ADC_CR_SWRST = 0x1
	// Position of START field.
	ADC_CR_START_Pos = 0x1
	// Bit mask of START field.
	ADC_CR_START_Msk = 0x2
	// Bit START.
	ADC_CR_START = 0x2

	// MR: Mode Register
	// Position of TRGEN field.
	ADC_MR_TRGEN_Pos = 0x0
	// Bit mask of TRGEN field.
	ADC_MR_TRGEN_Msk = 0x1
	// Bit TRGEN.
	ADC_MR_TRGEN = 0x1
	// Position of TRGSEL field.
	ADC_MR_TRGSEL_Pos = 0x1
	// Bit mask of TRGSEL field.
	ADC_MR_TRGSEL_Msk = 0xe
	// Position of LOWRES field.
	ADC_MR_LOWRES_Pos = 0x4
	// Bit mask of LOWRES field.
	ADC_MR_LOWRES_Msk = 0x10
	// Bit LOWRES.
	ADC_MR_LOWRES = 0x10
	// Position of SLEEP field.
	ADC_MR_SLEEP_Pos = 0x5
	// Bit mask of SLEEP field.
	ADC_MR_SLEEP_Msk = 0x20
	// Bit SLEEP.
	ADC_MR_SLEEP = 0x20
	// Position of PRESCAL field.
	ADC_MR_PRESCAL_Pos = 0x8
	// Bit mask of PRESCAL field.
	ADC_MR_PRESCAL_Msk = 0xff00
	// Position of STARTUP field.
	ADC_MR_STARTUP_Pos = 0x10
	// Bit mask of STARTUP field.
	ADC_MR_STARTUP_Msk = 0x7f0000
	// Position of SHTIM field.
	ADC_MR_SHTIM_Pos = 0x18
	// Bit mask of SHTIM field.
	ADC_MR_SHTIM_Msk = 0xf000000

	// CHER: Channel Enable Register
	// Position of CH0 field.
	ADC_CHER_CH0_Pos = 0x0
	// Bit mask of CH0 field.
	ADC_CHER_CH0_Msk = 0x1
	// Bit CH0.
	ADC_CHER_CH0 = 0x1
	// Position of CH1 field.
	ADC_CHER_CH1_Pos = 0x1
	// Bit mask of CH1 field.
	ADC_CHER_CH1_Msk = 0x2
	// Bit CH1.
	ADC_CHER_CH1 = 0x2
	// Position of CH2 field.
	ADC_CHER_CH2_Pos = 0x2
	// Bit mask of CH2 field.
	ADC_CHER_CH2_Msk = 0x4
	// Bit CH2.
	ADC_CHER_CH2 = 0x4
	// Position of CH3 field.
	ADC_CHER_CH3_Pos = 0x3
	// Bit mask of CH3 field.
	ADC_CHER_CH3_Msk = 0x8
	// Bit CH3.
	ADC_CHER_CH3 = 0x8
	// Position of CH4 field.
	ADC_CHER_CH4_Pos = 0x4
	// Bit mask of CH4 field.
	ADC_CHER_CH4_Msk = 0x10
	// Bit CH4.
	ADC_CHER_CH4 = 0x10
	// Position of CH5 field.
	ADC_CHER_CH5_Pos = 0x5
	// Bit mask of CH5 field.
	ADC_CHER_CH5_Msk = 0x20
	// Bit CH5.
	ADC_CHER_CH5 = 0x20
	// Position of CH6 field.
	ADC_CHER_CH6_Pos = 0x6
	// Bit mask of CH6 field.
	ADC_CHER_CH6_Msk = 0x40
	// Bit CH6.
	ADC_CHER_CH6 = 0x40
	// Position of CH7 field.
	ADC_CHER_CH7_Pos = 0x7
	// Bit mask of CH7 field.
	ADC_CHER_CH7_Msk = 0x80
	// Bit CH7.
	ADC_CHER_CH7 = 0x80

	// CHDR: Channel Disable Register
	// Position of CH0 field.
	ADC_CHDR_CH0_Pos = 0x0
	// Bit mask of CH0 field.
	ADC_CHDR_CH0_Msk = 0x1
	// Bit CH0.
	ADC_CHDR_CH0 = 0x1
	// Position of CH1 field.
	ADC_CHDR_CH1_Pos = 0x1
	// Bit mask of CH1 field.
	ADC_CHDR_CH1_Msk = 0x2
	// Bit CH1.
	ADC_CHDR_CH1 = 0x2
	// Position of CH2 field.
	ADC_CHDR_CH2_Pos = 0x2
	// Bit mask of CH2 field.
	ADC_CHDR_CH2_Msk = 0x4
	// Bit CH2.
	ADC_CHDR_CH2 = 0x4
	// Position of CH3 field.
	ADC_CHDR_CH3_Pos = 0x3
	// Bit mask of CH3 field.
	ADC_CHDR_CH3_Msk = 0x8
	// Bit CH3.
	ADC_CHDR_CH3 = 0x8
	// Position of CH4 field.
	ADC_CHDR_CH4_Pos = 0x4
	// Bit mask of CH4 field.
	ADC_CHDR_CH4_Msk = 0x10
	// Bit CH4.
	ADC_CHDR_CH4 = 0x10
	// Position of CH5 field.
	ADC_CHDR_CH5_Pos = 0x5
	// Bit mask of CH5 field.
	ADC_CHDR_CH5_Msk = 0x20
	// Bit CH5.
	ADC_CHDR_CH5 = 0x20
	// Position of CH6 field.
	ADC_CHDR_CH6_Pos = 0x6
	// Bit mask of CH6 field.
	ADC_CHDR_CH6_Msk = 0x40
	// Bit CH6.
	ADC_CHDR_CH6 = 0x40
	// Position of CH7 field.
	ADC_CHDR_CH7_Pos = 0x7
	// Bit mask of CH7 field.
	ADC_CHDR_CH7_Msk = 0x80
	// Bit CH7.
	ADC_CHDR_CH7 = 0x80

	// CHSR: Channel Status Register
	// Position of CH0 field.
	ADC_CHSR_CH0_Pos = 0x0
	// Bit mask of CH0 field.
	ADC_CHSR_CH0_Msk = 0x1
	// Bit CH0.
	ADC_CHSR_CH0 = 0x1
	// Position of CH1 field.
	ADC_CHSR_CH1_Pos = 0x1
	// Bit mask of CH1 field.
	ADC_CHSR_CH1_Msk = 0x2
	// Bit CH1.
	ADC_CHSR_CH1 = 0x2
	// Position of CH2 field.
	ADC_CHSR_CH2_Pos = 0x2
	// Bit mask of CH2 field.
	ADC_CHSR_CH2_Msk = 0x4
	// Bit CH2.
	ADC_CHSR_CH2 = 0x4
	// Position of CH3 field.
	ADC_CHSR_CH3_Pos = 0x3
	// Bit mask of CH3 field.
	ADC_CHSR_CH3_Msk = 0x8
	// Bit CH3.
	ADC_CHSR_CH3 = 0x8
	// Position of CH4 field.
	ADC_CHSR_CH4_Pos = 0x4
	// Bit mask of CH4 field.
	ADC_CHSR_CH4_Msk = 0x10
	// Bit CH4.
	ADC_CHSR_CH4 = 0x10
	// Position of CH5 field.
	ADC_CHSR_CH5_Pos = 0x5
	// Bit mask of CH5 field.
	ADC_CHSR_CH5_Msk = 0x20
	// Bit CH5.
	ADC_CHSR_CH5 = 0x20
	// Position of CH6 field.
	ADC_CHSR_CH6_Pos = 0x6
	// Bit mask of CH6 field.
	ADC_CHSR_CH6_Msk = 0x40
	// Bit CH6.
	ADC_CHSR_CH6 = 0x40
	// Position of CH7 field.
	ADC_CHSR_CH7_Pos = 0x7
	// Bit mask of CH7 field.
	ADC_CHSR_CH7_Msk = 0x80
	// Bit CH7.
	ADC_CHSR_CH7 = 0x80

	// SR: Status Register
	// Position of EOC0 field.
	ADC_SR_EOC0_Pos = 0x0
	// Bit mask of EOC0 field.
	ADC_SR_EOC0_Msk = 0x1
	// Bit EOC0.
	ADC_SR_EOC0 = 0x1
	// Position of EOC1 field.
	ADC_SR_EOC1_Pos = 0x1
	// Bit mask of EOC1 field.
	ADC_SR_EOC1_Msk = 0x2
	// Bit EOC1.
	ADC_SR_EOC1 = 0x2
	// Position of EOC2 field.
	ADC_SR_EOC2_Pos = 0x2
	// Bit mask of EOC2 field.
	ADC_SR_EOC2_Msk = 0x4
	// Bit EOC2.
	ADC_SR_EOC2 = 0x4
	// Position of EOC3 field.
	ADC_SR_EOC3_Pos = 0x3
	// Bit mask of EOC3 field.
	ADC_SR_EOC3_Msk = 0x8
	// Bit EOC3.
	ADC_SR_EOC3 = 0x8
	// Position of EOC4 field.
	ADC_SR_EOC4_Pos = 0x4
	// Bit mask of EOC4 field.
	ADC_SR_EOC4_Msk = 0x10
	// Bit EOC4.
	ADC_SR_EOC4 = 0x10
	// Position of EOC5 field.
	ADC_SR_EOC5_Pos = 0x5
	// Bit mask of EOC5 field.
	ADC_SR_EOC5_Msk = 0x20
	// Bit EOC5.
	ADC_SR_EOC5 = 0x20
	// Position of EOC6 field.
	ADC_SR_EOC6_Pos = 0x6
	// Bit mask of EOC6 field.
	ADC_SR_EOC6_Msk = 0x40
	// Bit EOC6.
	ADC_SR_EOC6 = 0x40
	// Position of EOC7 field.
	ADC_SR_EOC7_Pos = 0x7
	// Bit mask of EOC7 field.
	ADC_SR_EOC7_Msk = 0x80
	// Bit EOC7.
	ADC_SR_EOC7 = 0x80
	// Position of OVRE0 field.
	ADC_SR_OVRE0_Pos = 0x8
	// Bit mask of OVRE0 field.
	ADC_SR_OVRE0_Msk = 0x100
	// Bit OVRE0.
	ADC_SR_OVRE0 = 0x100
	// Position of OVRE1 field.
	ADC_SR_OVRE1_Pos = 0x9
	// Bit mask of OVRE1 field.
	ADC_SR_OVRE1_Msk = 0x200
	// Bit OVRE1.
	ADC_SR_OVRE1 = 0x200
	// Position of OVRE2 field.
	ADC_SR_OVRE2_Pos = 0xa
	// Bit mask of OVRE2 field.
	ADC_SR_OVRE2_Msk = 0x400
	// Bit OVRE2.
	ADC_SR_OVRE2 = 0x400
	// Position of OVRE3 field.
	ADC_SR_OVRE3_Pos = 0xb
	// Bit mask of OVRE3 field.
	ADC_SR_OVRE3_Msk = 0x800
	// Bit OVRE3.
	ADC_SR_OVRE3 = 0x800
	// Position of OVRE4 field.
	ADC_SR_OVRE4_Pos = 0xc
	// Bit mask of OVRE4 field.
	ADC_SR_OVRE4_Msk = 0x1000
	// Bit OVRE4.
	ADC_SR_OVRE4 = 0x1000
	// Position of OVRE5 field.
	ADC_SR_OVRE5_Pos = 0xd
	// Bit mask of OVRE5 field.
	ADC_SR_OVRE5_Msk = 0x2000
	// Bit OVRE5.
	ADC_SR_OVRE5 = 0x2000
	// Position of OVRE6 field.
	ADC_SR_OVRE6_Pos = 0xe
	// Bit mask of OVRE6 field.
	ADC_SR_OVRE6_Msk = 0x4000
	// Bit OVRE6.
	ADC_SR_OVRE6 = 0x4000
	// Position of OVRE7 field.
	ADC_SR_OVRE7_Pos = 0xf
	// Bit mask of OVRE7 field.
	ADC_SR_OVRE7_Msk = 0x8000
	// Bit OVRE7.
	ADC_SR_OVRE7 = 0x8000
	// Position of DRDY field.
	ADC_SR_DRDY_Pos = 0x10
	// Bit mask of DRDY field.
	ADC_SR_DRDY_Msk = 0x10000
	// Bit DRDY.
	ADC_SR_DRDY = 0x10000
	// Position of GOVRE field.
	ADC_SR_GOVRE_Pos = 0x11
	// Bit mask of GOVRE field.
	ADC_SR_GOVRE_Msk = 0x20000
	// Bit GOVRE.
	ADC_SR_GOVRE = 0x20000
	// Position of ENDRX field.
	ADC_SR_ENDRX_Pos = 0x12
	// Bit mask of ENDRX field.
	ADC_SR_ENDRX_Msk = 0x40000
	// Bit ENDRX.
	ADC_SR_ENDRX = 0x40000
	// Position of RXBUFF field.
	ADC_SR_RXBUFF_Pos = 0x13
	// Bit mask of RXBUFF field.
	ADC_SR_RXBUFF_Msk = 0x80000
	// Bit RXBUFF.
	ADC_SR_RXBUFF = 0x80000

	// LCDR: Last Converted Data Register
	// Position of LDATA field.
	ADC_LCDR_LDATA_Pos = 0x0
	// Bit mask of LDATA field.
	ADC_LCDR_LDATA_Msk = 0x3ff

	// IER: Interrupt Enable Register
	// Position of EOC0 field.
	ADC_IER_EOC0_Pos = 0x0
	// Bit mask of EOC0 field.
	ADC_IER_EOC0_Msk = 0x1
	// Bit EOC0.
	ADC_IER_EOC0 = 0x1
	// Position of EOC1 field.
	ADC_IER_EOC1_Pos = 0x1
	// Bit mask of EOC1 field.
	ADC_IER_EOC1_Msk = 0x2
	// Bit EOC1.
	ADC_IER_EOC1 = 0x2
	// Position of EOC2 field.
	ADC_IER_EOC2_Pos = 0x2
	// Bit mask of EOC2 field.
	ADC_IER_EOC2_Msk = 0x4
	// Bit EOC2.
	ADC_IER_EOC2 = 0x4
	// Position of EOC3 field.
	ADC_IER_EOC3_Pos = 0x3
	// Bit mask of EOC3 field.
	ADC_IER_EOC3_Msk = 0x8
	// Bit EOC3.
	ADC_IER_EOC3 = 0x8
	// Position of EOC4 field.
	ADC_IER_EOC4_Pos = 0x4
	// Bit mask of EOC4 field.
	ADC_IER_EOC4_Msk = 0x10
	// Bit EOC4.
	ADC_IER_EOC4 = 0x10
	// Position of EOC5 field.
	ADC_IER_EOC5_Pos = 0x5
	// Bit mask of EOC5 field.
	ADC_IER_EOC5_Msk = 0x20
	// Bit EOC5.
	ADC_IER_EOC5 = 0x20
	// Position of EOC6 field.
	ADC_IER_EOC6_Pos = 0x6
	// Bit mask of EOC6 field.
	ADC_IER_EOC6_Msk = 0x40
	// Bit EOC6.
	ADC_IER_EOC6 = 0x40
	// Position of EOC7 field.
	ADC_IER_EOC7_Pos = 0x7
	// Bit mask of EOC7 field.
	ADC_IER_EOC7_Msk = 0x80
	// Bit EOC7.
	ADC_IER_EOC7 = 0x80
	// Position of OVRE0 field.
	ADC_IER_OVRE0_Pos = 0x8
	// Bit mask of OVRE0 field.
	ADC_IER_OVRE0_Msk = 0x100
	// Bit OVRE0.
	ADC_IER_OVRE0 = 0x100
	// Position of OVRE1 field.
	ADC_IER_OVRE1_Pos = 0x9
	// Bit mask of OVRE1 field.
	ADC_IER_OVRE1_Msk = 0x200
	// Bit OVRE1.
	ADC_IER_OVRE1 = 0x200
	// Position of OVRE2 field.
	ADC_IER_OVRE2_Pos = 0xa
	// Bit mask of OVRE2 field.
	ADC_IER_OVRE2_Msk = 0x400
	// Bit OVRE2.
	ADC_IER_OVRE2 = 0x400
	// Position of OVRE3 field.
	ADC_IER_OVRE3_Pos = 0xb
	// Bit mask of OVRE3 field.
	ADC_IER_OVRE3_Msk = 0x800
	// Bit OVRE3.
	ADC_IER_OVRE3 = 0x800
	// Position of OVRE4 field.
	ADC_IER_OVRE4_Pos = 0xc
	// Bit mask of OVRE4 field.
	ADC_IER_OVRE4_Msk = 0x1000
	// Bit OVRE4.
	ADC_IER_OVRE4 = 0x1000
	// Position of OVRE5 field.
	ADC_IER_OVRE5_Pos = 0xd
	// Bit mask of OVRE5 field.
	ADC_IER_OVRE5_Msk = 0x2000
	// Bit OVRE5.
	ADC_IER_OVRE5 = 0x2000
	// Position of OVRE6 field.
	ADC_IER_OVRE6_Pos = 0xe
	// Bit mask of OVRE6 field.
	ADC_IER_OVRE6_Msk = 0x4000
	// Bit OVRE6.
	ADC_IER_OVRE6 = 0x4000
	// Position of OVRE7 field.
	ADC_IER_OVRE7_Pos = 0xf
	// Bit mask of OVRE7 field.
	ADC_IER_OVRE7_Msk = 0x8000
	// Bit OVRE7.
	ADC_IER_OVRE7 = 0x8000
	// Position of DRDY field.
	ADC_IER_DRDY_Pos = 0x10
	// Bit mask of DRDY field.
	ADC_IER_DRDY_Msk = 0x10000
	// Bit DRDY.
	ADC_IER_DRDY = 0x10000
	// Position of GOVRE field.
	ADC_IER_GOVRE_Pos = 0x11
	// Bit mask of GOVRE field.
	ADC_IER_GOVRE_Msk = 0x20000
	// Bit GOVRE.
	ADC_IER_GOVRE = 0x20000
	// Position of ENDRX field.
	ADC_IER_ENDRX_Pos = 0x12
	// Bit mask of ENDRX field.
	ADC_IER_ENDRX_Msk = 0x40000
	// Bit ENDRX.
	ADC_IER_ENDRX = 0x40000
	// Position of RXBUFF field.
	ADC_IER_RXBUFF_Pos = 0x13
	// Bit mask of RXBUFF field.
	ADC_IER_RXBUFF_Msk = 0x80000
	// Bit RXBUFF.
	ADC_IER_RXBUFF = 0x80000

	// IDR: Interrupt Disable Register
	// Position of EOC0 field.
	ADC_IDR_EOC0_Pos = 0x0
	// Bit mask of EOC0 field.
	ADC_IDR_EOC0_Msk = 0x1
	// Bit EOC0.
	ADC_IDR_EOC0 = 0x1
	// Position of EOC1 field.
	ADC_IDR_EOC1_Pos = 0x1
	// Bit mask of EOC1 field.
	ADC_IDR_EOC1_Msk = 0x2
	// Bit EOC1.
	ADC_IDR_EOC1 = 0x2
	// Position of EOC2 field.
	ADC_IDR_EOC2_Pos = 0x2
	// Bit mask of EOC2 field.
	ADC_IDR_EOC2_Msk = 0x4
	// Bit EOC2.
	ADC_IDR_EOC2 = 0x4
	// Position of EOC3 field.
	ADC_IDR_EOC3_Pos = 0x3
	// Bit mask of EOC3 field.
	ADC_IDR_EOC3_Msk = 0x8
	// Bit EOC3.
	ADC_IDR_EOC3 = 0x8
	// Position of EOC4 field.
	ADC_IDR_EOC4_Pos = 0x4
	// Bit mask of EOC4 field.
	ADC_IDR_EOC4_Msk = 0x10
	// Bit EOC4.
	ADC_IDR_EOC4 = 0x10
	// Position of EOC5 field.
	ADC_IDR_EOC5_Pos = 0x5
	// Bit mask of EOC5 field.
	ADC_IDR_EOC5_Msk = 0x20
	// Bit EOC5.
	ADC_IDR_EOC5 = 0x20
	// Position of EOC6 field.
	ADC_IDR_EOC6_Pos = 0x6
	// Bit mask of EOC6 field.
	ADC_IDR_EOC6_Msk = 0x40
	// Bit EOC6.
	ADC_IDR_EOC6 = 0x40
	// Position of EOC7 field.
	ADC_IDR_EOC7_Pos = 0x7
	// Bit mask of EOC7 field.
	ADC_IDR_EOC7_Msk = 0x80
	// Bit EOC7.
	ADC_IDR_EOC7 = 0x80
	// Position of OVRE0 field.
	ADC_IDR_OVRE0_Pos = 0x8
	// Bit mask of OVRE0 field.
	ADC_IDR_OVRE0_Msk = 0x100
	// Bit OVRE0.
	ADC_IDR_OVRE0 = 0x100
	// Position of OVRE1 field.
	ADC_IDR_OVRE1_Pos = 0x9
	// Bit mask of OVRE1 field.
	ADC_IDR_OVRE1_Msk = 0x200
	// Bit OVRE1.
	ADC_IDR_OVRE1 = 0x200
	// Position of OVRE2 field.
	ADC_IDR_OVRE2_Pos = 0xa
	// Bit mask of OVRE2 field.
	ADC_IDR_OVRE2_Msk = 0x400
	// Bit OVRE2.
	ADC_IDR_OVRE2 = 0x400
	// Position of OVRE3 field.
	ADC_IDR_OVRE3_Pos = 0xb
	// Bit mask of OVRE3 field.
	ADC_IDR_OVRE3_Msk = 0x800
	// Bit OVRE3.
	ADC_IDR_OVRE3 = 0x800
	// Position of OVRE4 field.
	ADC_IDR_OVRE4_Pos = 0xc
	// Bit mask of OVRE4 field.
	ADC_IDR_OVRE4_Msk = 0x1000
	// Bit OVRE4.
	ADC_IDR_OVRE4 = 0x1000
	// Position of OVRE5 field.
	ADC_IDR_OVRE5_Pos = 0xd
	// Bit mask of OVRE5 field.
	ADC_IDR_OVRE5_Msk = 0x2000
	// Bit OVRE5.
	ADC_IDR_OVRE5 = 0x2000
	// Position of OVRE6 field.
	ADC_IDR_OVRE6_Pos = 0xe
	// Bit mask of OVRE6 field.
	ADC_IDR_OVRE6_Msk = 0x4000
	// Bit OVRE6.
	ADC_IDR_OVRE6 = 0x4000
	// Position of OVRE7 field.
	ADC_IDR_OVRE7_Pos = 0xf
	// Bit mask of OVRE7 field.
	ADC_IDR_OVRE7_Msk = 0x8000
	// Bit OVRE7.
	ADC_IDR_OVRE7 = 0x8000
	// Position of DRDY field.
	ADC_IDR_DRDY_Pos = 0x10
	// Bit mask of DRDY field.
	ADC_IDR_DRDY_Msk = 0x10000
	// Bit DRDY.
	ADC_IDR_DRDY = 0x10000
	// Position of GOVRE field.
	ADC_IDR_GOVRE_Pos = 0x11
	// Bit mask of GOVRE field.
	ADC_IDR_GOVRE_Msk = 0x20000
	// Bit GOVRE.
	ADC_IDR_GOVRE = 0x20000
	// Position of ENDRX field.
	ADC_IDR_ENDRX_Pos = 0x12
	// Bit mask of ENDRX field.
	ADC_IDR_ENDRX_Msk = 0x40000
	// Bit ENDRX.
	ADC_IDR_ENDRX = 0x40000
	// Position of RXBUFF field.
	ADC_IDR_RXBUFF_Pos = 0x13
	// Bit mask of RXBUFF field.
	ADC_IDR_RXBUFF_Msk = 0x80000
	// Bit RXBUFF.
	ADC_IDR_RXBUFF = 0x80000

	// IMR: Interrupt Mask Register
	// Position of EOC0 field.
	ADC_IMR_EOC0_Pos = 0x0
	// Bit mask of EOC0 field.
	ADC_IMR_EOC0_Msk = 0x1
	// Bit EOC0.
	ADC_IMR_EOC0 = 0x1
	// Position of EOC1 field.
	ADC_IMR_EOC1_Pos = 0x1
	// Bit mask of EOC1 field.
	ADC_IMR_EOC1_Msk = 0x2
	// Bit EOC1.
	ADC_IMR_EOC1 = 0x2
	// Position of EOC2 field.
	ADC_IMR_EOC2_Pos = 0x2
	// Bit mask of EOC2 field.
	ADC_IMR_EOC2_Msk = 0x4
	// Bit EOC2.
	ADC_IMR_EOC2 = 0x4
	// Position of EOC3 field.
	ADC_IMR_EOC3_Pos = 0x3
	// Bit mask of EOC3 field.
	ADC_IMR_EOC3_Msk = 0x8
	// Bit EOC3.
	ADC_IMR_EOC3 = 0x8
	// Position of EOC4 field.
	ADC_IMR_EOC4_Pos = 0x4
	// Bit mask of EOC4 field.
	ADC_IMR_EOC4_Msk = 0x10
	// Bit EOC4.
	ADC_IMR_EOC4 = 0x10
	// Position of EOC5 field.
	ADC_IMR_EOC5_Pos = 0x5
	// Bit mask of EOC5 field.
	ADC_IMR_EOC5_Msk = 0x20
	// Bit EOC5.
	ADC_IMR_EOC5 = 0x20
	// Position of EOC6 field.
	ADC_IMR_EOC6_Pos = 0x6
	// Bit mask of EOC6 field.
	ADC_IMR_EOC6_Msk = 0x40
	// Bit EOC6.
	ADC_IMR_EOC6 = 0x40
	// Position of EOC7 field.
	ADC_IMR_EOC7_Pos = 0x7
	// Bit mask of EOC7 field.
	ADC_IMR_EOC7_Msk = 0x80
	// Bit EOC7.
	ADC_IMR_EOC7 = 0x80
	// Position of OVRE0 field.
	ADC_IMR_OVRE0_Pos = 0x8
	// Bit mask of OVRE0 field.
	ADC_IMR_OVRE0_Msk = 0x100
	// Bit OVRE0.
	ADC_IMR_OVRE0 = 0x100
	// Position of OVRE1 field.
	ADC_IMR_OVRE1_Pos = 0x9
	// Bit mask of OVRE1 field.
	ADC_IMR_OVRE1_Msk = 0x200
	// Bit OVRE1.
	ADC_IMR_OVRE1 = 0x200
	// Position of OVRE2 field.
	ADC_IMR_OVRE2_Pos = 0xa
	// Bit mask of OVRE2 field.
	ADC_IMR_OVRE2_Msk = 0x400
	// Bit OVRE2.
	ADC_IMR_OVRE2 = 0x400
	// Position of OVRE3 field.
	ADC_IMR_OVRE3_Pos = 0xb
	// Bit mask of OVRE3 field.
	ADC_IMR_OVRE3_Msk = 0x800
	// Bit OVRE3.
	ADC_IMR_OVRE3 = 0x800
	// Position of OVRE4 field.
	ADC_IMR_OVRE4_Pos = 0xc
	// Bit mask of OVRE4 field.
	ADC_IMR_OVRE4_Msk = 0x1000
	// Bit OVRE4.
	ADC_IMR_OVRE4 = 0x1000
	// Position of OVRE5 field.
	ADC_IMR_OVRE5_Pos = 0xd
	// Bit mask of OVRE5 field.
	ADC_IMR_OVRE5_Msk = 0x2000
	// Bit OVRE5.
	ADC_IMR_OVRE5 = 0x2000
	// Position of OVRE6 field.
	ADC_IMR_OVRE6_Pos = 0xe
	// Bit mask of OVRE6 field.
	ADC_IMR_OVRE6_Msk = 0x4000
	// Bit OVRE6.
	ADC_IMR_OVRE6 = 0x4000
	// Position of OVRE7 field.
	ADC_IMR_OVRE7_Pos = 0xf
	// Bit mask of OVRE7 field.
	ADC_IMR_OVRE7_Msk = 0x8000
	// Bit OVRE7.
	ADC_IMR_OVRE7 = 0x8000
	// Position of DRDY field.
	ADC_IMR_DRDY_Pos = 0x10
	// Bit mask of DRDY field.
	ADC_IMR_DRDY_Msk = 0x10000
	// Bit DRDY.
	ADC_IMR_DRDY = 0x10000
	// Position of GOVRE field.
	ADC_IMR_GOVRE_Pos = 0x11
	// Bit mask of GOVRE field.
	ADC_IMR_GOVRE_Msk = 0x20000
	// Bit GOVRE.
	ADC_IMR_GOVRE = 0x20000
	// Position of ENDRX field.
	ADC_IMR_ENDRX_Pos = 0x12
	// Bit mask of ENDRX field.
	ADC_IMR_ENDRX_Msk = 0x40000
	// Bit ENDRX.
	ADC_IMR_ENDRX = 0x40000
	// Position of RXBUFF field.
	ADC_IMR_RXBUFF_Pos = 0x13
	// Bit mask of RXBUFF field.
	ADC_IMR_RXBUFF_Msk = 0x80000
	// Bit RXBUFF.
	ADC_IMR_RXBUFF = 0x80000

	// CDR: Channel Data Register
	// Position of DATA field.
	ADC_CDR_DATA_Pos = 0x0
	// Bit mask of DATA field.
	ADC_CDR_DATA_Msk = 0x3ff

	// RPR: Receive Pointer Register
	// Position of RXPTR field.
	ADC_RPR_RXPTR_Pos = 0x0
	// Bit mask of RXPTR field.
	ADC_RPR_RXPTR_Msk = 0xffffffff

	// RCR: Receive Counter Register
	// Position of RXCTR field.
	ADC_RCR_RXCTR_Pos = 0x0
	// Bit mask of RXCTR field.
	ADC_RCR_RXCTR_Msk = 0xffff

	// RNPR: Receive Next Pointer Register
	// Position of RXNPTR field.
	ADC_RNPR_RXNPTR_Pos = 0x0
	// Bit mask of RXNPTR field.
	ADC_RNPR_RXNPTR_Msk = 0xffffffff

	// RNCR: Receive Next Counter Register
	// Position of RXNCTR field.
	ADC_RNCR_RXNCTR_Pos = 0x0
	// Bit mask of RXNCTR field.
	ADC_RNCR_RXNCTR_Msk = 0xffff

	// PTCR: Transfer Control Register
	// Position of RXTEN field.
	ADC_PTCR_RXTEN_Pos = 0x0
	// Bit mask of RXTEN field.
	ADC_PTCR_RXTEN_Msk = 0x1
	// Bit RXTEN.
	ADC_PTCR_RXTEN = 0x1
	// Position of RXTDIS field.
	ADC_PTCR_RXTDIS_Pos = 0x1
	// Bit mask of RXTDIS field.
	ADC_PTCR_RXTDIS_Msk = 0x2
	// Bit RXTDIS.
	ADC_PTCR_RXTDIS = 0x2
	// Position of TXTEN field.
	ADC_PTCR_TXTEN_Pos = 0x8
	// Bit mask of TXTEN field.
	ADC_PTCR_TXTEN_Msk = 0x100
	// Bit TXTEN.
	ADC_PTCR_TXTEN = 0x100
	// Position of TXTDIS field.
	ADC_PTCR_TXTDIS_Pos = 0x9
	// Bit mask of TXTDIS field.
	ADC_PTCR_TXTDIS_Msk = 0x200
	// Bit TXTDIS.
	ADC_PTCR_TXTDIS = 0x200

	// PTSR: Transfer Status Register
	// Position of RXTEN field.
	ADC_PTSR_RXTEN_Pos = 0x0
	// Bit mask of RXTEN field.
	ADC_PTSR_RXTEN_Msk = 0x1
	// Bit RXTEN.
	ADC_PTSR_RXTEN = 0x1
	// Position of TXTEN field.
	ADC_PTSR_TXTEN_Pos = 0x8
	// Bit mask of TXTEN field.
	ADC_PTSR_TXTEN_Msk = 0x100
	// Bit TXTEN.
	ADC_PTSR_TXTEN = 0x100
)

// Bitfields for DMAC: DMA Controller
const (
	// GCFG: DMAC Global Configuration Register
	// Position of ARB_CFG field.
	DMAC_GCFG_ARB_CFG_Pos = 0x4
	// Bit mask of ARB_CFG field.
	DMAC_GCFG_ARB_CFG_Msk = 0x10
	// Bit ARB_CFG.
	DMAC_GCFG_ARB_CFG = 0x10
	// Fixed priority arbiter (see "Basic Definitions" )
	DMAC_GCFG_ARB_CFG_FIXED = 0x0
	// Modified round robin arbiter.
	DMAC_GCFG_ARB_CFG_ROUND_ROBIN = 0x1

	// EN: DMAC Enable Register
	// Position of ENABLE field.
	DMAC_EN_ENABLE_Pos = 0x0
	// Bit mask of ENABLE field.
	DMAC_EN_ENABLE_Msk = 0x1
	// Bit ENABLE.
	DMAC_EN_ENABLE = 0x1

	// SREQ: DMAC Software Single Request Register
	// Position of SSREQ0 field.
	DMAC_SREQ_SSREQ0_Pos = 0x0
	// Bit mask of SSREQ0 field.
	DMAC_SREQ_SSREQ0_Msk = 0x1
	// Bit SSREQ0.
	DMAC_SREQ_SSREQ0 = 0x1
	// Position of DSREQ0 field.
	DMAC_SREQ_DSREQ0_Pos = 0x1
	// Bit mask of DSREQ0 field.
	DMAC_SREQ_DSREQ0_Msk = 0x2
	// Bit DSREQ0.
	DMAC_SREQ_DSREQ0 = 0x2
	// Position of SSREQ1 field.
	DMAC_SREQ_SSREQ1_Pos = 0x2
	// Bit mask of SSREQ1 field.
	DMAC_SREQ_SSREQ1_Msk = 0x4
	// Bit SSREQ1.
	DMAC_SREQ_SSREQ1 = 0x4
	// Position of DSREQ1 field.
	DMAC_SREQ_DSREQ1_Pos = 0x3
	// Bit mask of DSREQ1 field.
	DMAC_SREQ_DSREQ1_Msk = 0x8
	// Bit DSREQ1.
	DMAC_SREQ_DSREQ1 = 0x8
	// Position of SSREQ2 field.
	DMAC_SREQ_SSREQ2_Pos = 0x4
	// Bit mask of SSREQ2 field.
	DMAC_SREQ_SSREQ2_Msk = 0x10
	// Bit SSREQ2.
	DMAC_SREQ_SSREQ2 = 0x10
	// Position of DSREQ2 field.
	DMAC_SREQ_DSREQ2_Pos = 0x5
	// Bit mask of DSREQ2 field.
	DMAC_SREQ_DSREQ2_Msk = 0x20
	// Bit DSREQ2.
	DMAC_SREQ_DSREQ2 = 0x20
	// Position of SSREQ3 field.
	DMAC_SREQ_SSREQ3_Pos = 0x6
	// Bit mask of SSREQ3 field.
	DMAC_SREQ_SSREQ3_Msk = 0x40
	// Bit SSREQ3.
	DMAC_SREQ_SSREQ3 = 0x40
	// Position of DSREQ3 field.
	DMAC_SREQ_DSREQ3_Pos = 0x7
	// Bit mask of DSREQ3 field.
	DMAC_SREQ_DSREQ3_Msk = 0x80
	// Bit DSREQ3.
	DMAC_SREQ_DSREQ3 = 0x80

	// CREQ: DMAC Software Chunk Transfer Request Register
	// Position of SCREQ0 field.
	DMAC_CREQ_SCREQ0_Pos = 0x0
	// Bit mask of SCREQ0 field.
	DMAC_CREQ_SCREQ0_Msk = 0x1
	// Bit SCREQ0.
	DMAC_CREQ_SCREQ0 = 0x1
	// Position of DCREQ0 field.
	DMAC_CREQ_DCREQ0_Pos = 0x1
	// Bit mask of DCREQ0 field.
	DMAC_CREQ_DCREQ0_Msk = 0x2
	// Bit DCREQ0.
	DMAC_CREQ_DCREQ0 = 0x2
	// Position of SCREQ1 field.
	DMAC_CREQ_SCREQ1_Pos = 0x2
	// Bit mask of SCREQ1 field.
	DMAC_CREQ_SCREQ1_Msk = 0x4
	// Bit SCREQ1.
	DMAC_CREQ_SCREQ1 = 0x4
	// Position of DCREQ1 field.
	DMAC_CREQ_DCREQ1_Pos = 0x3
	// Bit mask of DCREQ1 field.
	DMAC_CREQ_DCREQ1_Msk = 0x8
	// Bit DCREQ1.
	DMAC_CREQ_DCREQ1 = 0x8
	// Position of SCREQ2 field.
	DMAC_CREQ_SCREQ2_Pos = 0x4
	// Bit mask of SCREQ2 field.
	DMAC_CREQ_SCREQ2_Msk = 0x10
	// Bit SCREQ2.
	DMAC_CREQ_SCREQ2 = 0x10
	// Position of DCREQ2 field.
	DMAC_CREQ_DCREQ2_Pos = 0x5
	// Bit mask of DCREQ2 field.
	DMAC_CREQ_DCREQ2_Msk = 0x20
	// Bit DCREQ2.
	DMAC_CREQ_DCREQ2 = 0x20
	// Position of SCREQ3 field.
	DMAC_CREQ_SCREQ3_Pos = 0x6
	// Bit mask of SCREQ3 field.
	DMAC_CREQ_SCREQ3_Msk = 0x40
	// Bit SCREQ3.
	DMAC_CREQ_SCREQ3 = 0x40
	// Position of DCREQ3 field.
	DMAC_CREQ_DCREQ3_Pos = 0x7
	// Bit mask of DCREQ3 field.
	DMAC_CREQ_DCREQ3_Msk = 0x80
	// Bit DCREQ3.
	DMAC_CREQ_DCREQ3 = 0x80

	// LAST: DMAC Software Last Transfer Flag Register
	// Position of SLAST0 field.
	DMAC_LAST_SLAST0_Pos = 0x0
	// Bit mask of SLAST0 field.
	DMAC_LAST_SLAST0_Msk = 0x1
	// Bit SLAST0.
	DMAC_LAST_SLAST0 = 0x1
	// Position of DLAST0 field.
	DMAC_LAST_DLAST0_Pos = 0x1
	// Bit mask of DLAST0 field.
	DMAC_LAST_DLAST0_Msk = 0x2
	// Bit DLAST0.
	DMAC_LAST_DLAST0 = 0x2
	// Position of SLAST1 field.
	DMAC_LAST_SLAST1_Pos = 0x2
	// Bit mask of SLAST1 field.
	DMAC_LAST_SLAST1_Msk = 0x4
	// Bit SLAST1.
	DMAC_LAST_SLAST1 = 0x4
	// Position of DLAST1 field.
	DMAC_LAST_DLAST1_Pos = 0x3
	// Bit mask of DLAST1 field.
	DMAC_LAST_DLAST1_Msk = 0x8
	// Bit DLAST1.
	DMAC_LAST_DLAST1 = 0x8
	// Position of SLAST2 field.
	DMAC_LAST_SLAST2_Pos = 0x4
	// Bit mask of SLAST2 field.
	DMAC_LAST_SLAST2_Msk = 0x10
	// Bit SLAST2.
	DMAC_LAST_SLAST2 = 0x10
	// Position of DLAST2 field.
	DMAC_LAST_DLAST2_Pos = 0x5
	// Bit mask of DLAST2 field.
	DMAC_LAST_DLAST2_Msk = 0x20
	// Bit DLAST2.
	DMAC_LAST_DLAST2 = 0x20
	// Position of SLAST3 field.
	DMAC_LAST_SLAST3_Pos = 0x6
	// Bit mask of SLAST3 field.
	DMAC_LAST_SLAST3_Msk = 0x40
	// Bit SLAST3.
	DMAC_LAST_SLAST3 = 0x40
	// Position of DLAST3 field.
	DMAC_LAST_DLAST3_Pos = 0x7
	// Bit mask of DLAST3 field.
	DMAC_LAST_DLAST3_Msk = 0x80
	// Bit DLAST3.
	DMAC_LAST_DLAST3 = 0x80

	// EBCIER: DMAC Error, Chained Buffer Transfer Completed Interrupt and Buffer Transfer Completed Interrupt Enable register.
	// Position of BTC0 field.
	DMAC_EBCIER_BTC0_Pos = 0x0
	// Bit mask of BTC0 field.
	DMAC_EBCIER_BTC0_Msk = 0x1
	// Bit BTC0.
	DMAC_EBCIER_BTC0 = 0x1
	// Position of BTC1 field.
	DMAC_EBCIER_BTC1_Pos = 0x1
	// Bit mask of BTC1 field.
	DMAC_EBCIER_BTC1_Msk = 0x2
	// Bit BTC1.
	DMAC_EBCIER_BTC1 = 0x2
	// Position of BTC2 field.
	DMAC_EBCIER_BTC2_Pos = 0x2
	// Bit mask of BTC2 field.
	DMAC_EBCIER_BTC2_Msk = 0x4
	// Bit BTC2.
	DMAC_EBCIER_BTC2 = 0x4
	// Position of BTC3 field.
	DMAC_EBCIER_BTC3_Pos = 0x3
	// Bit mask of BTC3 field.
	DMAC_EBCIER_BTC3_Msk = 0x8
	// Bit BTC3.
	DMAC_EBCIER_BTC3 = 0x8
	// Position of CBTC0 field.
	DMAC_EBCIER_CBTC0_Pos = 0x8
	// Bit mask of CBTC0 field.
	DMAC_EBCIER_CBTC0_Msk = 0x100
	// Bit CBTC0.
	DMAC_EBCIER_CBTC0 = 0x100
	// Position of CBTC1 field.
	DMAC_EBCIER_CBTC1_Pos = 0x9
	// Bit mask of CBTC1 field.
	DMAC_EBCIER_CBTC1_Msk = 0x200
	// Bit CBTC1.
	DMAC_EBCIER_CBTC1 = 0x200
	// Position of CBTC2 field.
	DMAC_EBCIER_CBTC2_Pos = 0xa
	// Bit mask of CBTC2 field.
	DMAC_EBCIER_CBTC2_Msk = 0x400
	// Bit CBTC2.
	DMAC_EBCIER_CBTC2 = 0x400
	// Position of CBTC3 field.
	DMAC_EBCIER_CBTC3_Pos = 0xb
	// Bit mask of CBTC3 field.
	DMAC_EBCIER_CBTC3_Msk = 0x800
	// Bit CBTC3.
	DMAC_EBCIER_CBTC3 = 0x800
	// Position of ERR0 field.
	DMAC_EBCIER_ERR0_Pos = 0x10
	// Bit mask of ERR0 field.
	DMAC_EBCIER_ERR0_Msk = 0x10000
	// Bit ERR0.
	DMAC_EBCIER_ERR0 = 0x10000
	// Position of ERR1 field.
	DMAC_EBCIER_ERR1_Pos = 0x11
	// Bit mask of ERR1 field.
	DMAC_EBCIER_ERR1_Msk = 0x20000
	// Bit ERR1.
	DMAC_EBCIER_ERR1 = 0x20000
	// Position of ERR2 field.
	DMAC_EBCIER_ERR2_Pos = 0x12
	// Bit mask of ERR2 field.
	DMAC_EBCIER_ERR2_Msk = 0x40000
	// Bit ERR2.
	DMAC_EBCIER_ERR2 = 0x40000
	// Position of ERR3 field.
	DMAC_EBCIER_ERR3_Pos = 0x13
	// Bit mask of ERR3 field.
	DMAC_EBCIER_ERR3_Msk = 0x80000
	// Bit ERR3.
	DMAC_EBCIER_ERR3 = 0x80000

	// EBCIDR: DMAC Error, Chained Buffer Transfer Completed Interrupt and Buffer Transfer Completed Interrupt Disable register.
	// Position of BTC0 field.
	DMAC_EBCIDR_BTC0_Pos = 0x0
	// Bit mask of BTC0 field.
	DMAC_EBCIDR_BTC0_Msk = 0x1
	// Bit BTC0.
	DMAC_EBCIDR_BTC0 = 0x1
	// Position of BTC1 field.
	DMAC_EBCIDR_BTC1_Pos = 0x1
	// Bit mask of BTC1 field.
	DMAC_EBCIDR_BTC1_Msk = 0x2
	// Bit BTC1.
	DMAC_EBCIDR_BTC1 = 0x2
	// Position of BTC2 field.
	DMAC_EBCIDR_BTC2_Pos = 0x2
	// Bit mask of BTC2 field.
	DMAC_EBCIDR_BTC2_Msk = 0x4
	// Bit BTC2.
	DMAC_EBCIDR_BTC2 = 0x4
	// Position of BTC3 field.
	DMAC_EBCIDR_BTC3_Pos = 0x3
	// Bit mask of BTC3 field.
	DMAC_EBCIDR_BTC3_Msk = 0x8
	// Bit BTC3.
	DMAC_EBCIDR_BTC3 = 0x8
	// Position of CBTC0 field.
	DMAC_EBCIDR_CBTC0_Pos = 0x8
	// Bit mask of CBTC0 field.
	DMAC_EBCIDR_CBTC0_Msk = 0x100
	// Bit CBTC0.
	DMAC_EBCIDR_CBTC0 = 0x100
	// Position of CBTC1 field.
	DMAC_EBCIDR_CBTC1_Pos = 0x9
	// Bit mask of CBTC1 field.
	DMAC_EBCIDR_CBTC1_Msk = 0x200
	// Bit CBTC1.
	DMAC_EBCIDR_CBTC1 = 0x200
	// Position of CBTC2 field.
	DMAC_EBCIDR_CBTC2_Pos = 0xa
	// Bit mask of CBTC2 field.
	DMAC_EBCIDR_CBTC2_Msk = 0x400
	// Bit CBTC2.
	DMAC_EBCIDR_CBTC2 = 0x400
	// Position of CBTC3 field.
	DMAC_EBCIDR_CBTC3_Pos = 0xb
	// Bit mask of CBTC3 field.
	DMAC_EBCIDR_CBTC3_Msk = 0x800
	// Bit CBTC3.
	DMAC_EBCIDR_CBTC3 = 0x800
	// Position of ERR0 field.
	DMAC_EBCIDR_ERR0_Pos = 0x10
	// Bit mask of ERR0 field.
	DMAC_EBCIDR_ERR0_Msk = 0x10000
	// Bit ERR0.
	DMAC_EBCIDR_ERR0 = 0x10000
	// Position of ERR1 field.
	DMAC_EBCIDR_ERR1_Pos = 0x11
	// Bit mask of ERR1 field.
	DMAC_EBCIDR_ERR1_Msk = 0x20000
	// Bit ERR1.
	DMAC_EBCIDR_ERR1 = 0x20000
	// Position of ERR2 field.
	DMAC_EBCIDR_ERR2_Pos = 0x12
	// Bit mask of ERR2 field.
	DMAC_EBCIDR_ERR2_Msk = 0x40000
	// Bit ERR2.
	DMAC_EBCIDR_ERR2 = 0x40000
	// Position of ERR3 field.
	DMAC_EBCIDR_ERR3_Pos = 0x13
	// Bit mask of ERR3 field.
	DMAC_EBCIDR_ERR3_Msk = 0x80000
	// Bit ERR3.
	DMAC_EBCIDR_ERR3 = 0x80000

	// EBCIMR: DMAC Error, Chained Buffer Transfer Completed Interrupt and Buffer transfer completed Mask Register.
	// Position of BTC0 field.
	DMAC_EBCIMR_BTC0_Pos = 0x0
	// Bit mask of BTC0 field.
	DMAC_EBCIMR_BTC0_Msk = 0x1
	// Bit BTC0.
	DMAC_EBCIMR_BTC0 = 0x1
	// Position of BTC1 field.
	DMAC_EBCIMR_BTC1_Pos = 0x1
	// Bit mask of BTC1 field.
	DMAC_EBCIMR_BTC1_Msk = 0x2
	// Bit BTC1.
	DMAC_EBCIMR_BTC1 = 0x2
	// Position of BTC2 field.
	DMAC_EBCIMR_BTC2_Pos = 0x2
	// Bit mask of BTC2 field.
	DMAC_EBCIMR_BTC2_Msk = 0x4
	// Bit BTC2.
	DMAC_EBCIMR_BTC2 = 0x4
	// Position of BTC3 field.
	DMAC_EBCIMR_BTC3_Pos = 0x3
	// Bit mask of BTC3 field.
	DMAC_EBCIMR_BTC3_Msk = 0x8
	// Bit BTC3.
	DMAC_EBCIMR_BTC3 = 0x8
	// Position of CBTC0 field.
	DMAC_EBCIMR_CBTC0_Pos = 0x8
	// Bit mask of CBTC0 field.
	DMAC_EBCIMR_CBTC0_Msk = 0x100
	// Bit CBTC0.
	DMAC_EBCIMR_CBTC0 = 0x100
	// Position of CBTC1 field.
	DMAC_EBCIMR_CBTC1_Pos = 0x9
	// Bit mask of CBTC1 field.
	DMAC_EBCIMR_CBTC1_Msk = 0x200
	// Bit CBTC1.
	DMAC_EBCIMR_CBTC1 = 0x200
	// Position of CBTC2 field.
	DMAC_EBCIMR_CBTC2_Pos = 0xa
	// Bit mask of CBTC2 field.
	DMAC_EBCIMR_CBTC2_Msk = 0x400
	// Bit CBTC2.
	DMAC_EBCIMR_CBTC2 = 0x400
	// Position of CBTC3 field.
	DMAC_EBCIMR_CBTC3_Pos = 0xb
	// Bit mask of CBTC3 field.
	DMAC_EBCIMR_CBTC3_Msk = 0x800
	// Bit CBTC3.
	DMAC_EBCIMR_CBTC3 = 0x800
	// Position of ERR0 field.
	DMAC_EBCIMR_ERR0_Pos = 0x10
	// Bit mask of ERR0 field.
	DMAC_EBCIMR_ERR0_Msk = 0x10000
	// Bit ERR0.
	DMAC_EBCIMR_ERR0 = 0x10000
	// Position of ERR1 field.
	DMAC_EBCIMR_ERR1_Pos = 0x11
	// Bit mask of ERR1 field.
	DMAC_EBCIMR_ERR1_Msk = 0x20000
	// Bit ERR1.
	DMAC_EBCIMR_ERR1 = 0x20000
	// Position of ERR2 field.
	DMAC_EBCIMR_ERR2_Pos = 0x12
	// Bit mask of ERR2 field.
	DMAC_EBCIMR_ERR2_Msk = 0x40000
	// Bit ERR2.
	DMAC_EBCIMR_ERR2 = 0x40000
	// Position of ERR3 field.
	DMAC_EBCIMR_ERR3_Pos = 0x13
	// Bit mask of ERR3 field.
	DMAC_EBCIMR_ERR3_Msk = 0x80000
	// Bit ERR3.
	DMAC_EBCIMR_ERR3 = 0x80000

	// EBCISR: DMAC Error, Chained Buffer Transfer Completed Interrupt and Buffer transfer completed Status Register.
	// Position of BTC0 field.
	DMAC_EBCISR_BTC0_Pos = 0x0
	// Bit mask of BTC0 field.
	DMAC_EBCISR_BTC0_Msk = 0x1
	// Bit BTC0.
	DMAC_EBCISR_BTC0 = 0x1
	// Position of BTC1 field.
	DMAC_EBCISR_BTC1_Pos = 0x1
	// Bit mask of BTC1 field.
	DMAC_EBCISR_BTC1_Msk = 0x2
	// Bit BTC1.
	DMAC_EBCISR_BTC1 = 0x2
	// Position of BTC2 field.
	DMAC_EBCISR_BTC2_Pos = 0x2
	// Bit mask of BTC2 field.
	DMAC_EBCISR_BTC2_Msk = 0x4
	// Bit BTC2.
	DMAC_EBCISR_BTC2 = 0x4
	// Position of BTC3 field.
	DMAC_EBCISR_BTC3_Pos = 0x3
	// Bit mask of BTC3 field.
	DMAC_EBCISR_BTC3_Msk = 0x8
	// Bit BTC3.
	DMAC_EBCISR_BTC3 = 0x8
	// Position of CBTC0 field.
	DMAC_EBCISR_CBTC0_Pos = 0x8
	// Bit mask of CBTC0 field.
	DMAC_EBCISR_CBTC0_Msk = 0x100
	// Bit CBTC0.
	DMAC_EBCISR_CBTC0 = 0x100
	// Position of CBTC1 field.
	DMAC_EBCISR_CBTC1_Pos = 0x9
	// Bit mask of CBTC1 field.
	DMAC_EBCISR_CBTC1_Msk = 0x200
	// Bit CBTC1.
	DMAC_EBCISR_CBTC1 = 0x200
	// Position of CBTC2 field.
	DMAC_EBCISR_CBTC2_Pos = 0xa
	// Bit mask of CBTC2 field.
	DMAC_EBCISR_CBTC2_Msk = 0x400
	// Bit CBTC2.
	DMAC_EBCISR_CBTC2 = 0x400
	// Position of CBTC3 field.
	DMAC_EBCISR_CBTC3_Pos = 0xb
	// Bit mask of CBTC3 field.
	DMAC_EBCISR_CBTC3_Msk = 0x800
	// Bit CBTC3.
	DMAC_EBCISR_CBTC3 = 0x800
	// Position of ERR0 field.
	DMAC_EBCISR_ERR0_Pos = 0x10
	// Bit mask of ERR0 field.
	DMAC_EBCISR_ERR0_Msk = 0x10000
	// Bit ERR0.
	DMAC_EBCISR_ERR0 = 0x10000
	// Position of ERR1 field.
	DMAC_EBCISR_ERR1_Pos = 0x11
	// Bit mask of ERR1 field.
	DMAC_EBCISR_ERR1_Msk = 0x20000
	// Bit ERR1.
	DMAC_EBCISR_ERR1 = 0x20000
	// Position of ERR2 field.
	DMAC_EBCISR_ERR2_Pos = 0x12
	// Bit mask of ERR2 field.
	DMAC_EBCISR_ERR2_Msk = 0x40000
	// Bit ERR2.
	DMAC_EBCISR_ERR2 = 0x40000
	// Position of ERR3 field.
	DMAC_EBCISR_ERR3_Pos = 0x13
	// Bit mask of ERR3 field.
	DMAC_EBCISR_ERR3_Msk = 0x80000
	// Bit ERR3.
	DMAC_EBCISR_ERR3 = 0x80000

	// CHER: DMAC Channel Handler Enable Register
	// Position of ENA0 field.
	DMAC_CHER_ENA0_Pos = 0x0
	// Bit mask of ENA0 field.
	DMAC_CHER_ENA0_Msk = 0x1
	// Bit ENA0.
	DMAC_CHER_ENA0 = 0x1
	// Position of ENA1 field.
	DMAC_CHER_ENA1_Pos = 0x1
	// Bit mask of ENA1 field.
	DMAC_CHER_ENA1_Msk = 0x2
	// Bit ENA1.
	DMAC_CHER_ENA1 = 0x2
	// Position of ENA2 field.
	DMAC_CHER_ENA2_Pos = 0x2
	// Bit mask of ENA2 field.
	DMAC_CHER_ENA2_Msk = 0x4
	// Bit ENA2.
	DMAC_CHER_ENA2 = 0x4
	// Position of ENA3 field.
	DMAC_CHER_ENA3_Pos = 0x3
	// Bit mask of ENA3 field.
	DMAC_CHER_ENA3_Msk = 0x8
	// Bit ENA3.
	DMAC_CHER_ENA3 = 0x8
	// Position of SUSP0 field.
	DMAC_CHER_SUSP0_Pos = 0x8
	// Bit mask of SUSP0 field.
	DMAC_CHER_SUSP0_Msk = 0x100
	// Bit SUSP0.
	DMAC_CHER_SUSP0 = 0x100
	// Position of SUSP1 field.
	DMAC_CHER_SUSP1_Pos = 0x9
	// Bit mask of SUSP1 field.
	DMAC_CHER_SUSP1_Msk = 0x200
	// Bit SUSP1.
	DMAC_CHER_SUSP1 = 0x200
	// Position of SUSP2 field.
	DMAC_CHER_SUSP2_Pos = 0xa
	// Bit mask of SUSP2 field.
	DMAC_CHER_SUSP2_Msk = 0x400
	// Bit SUSP2.
	DMAC_CHER_SUSP2 = 0x400
	// Position of SUSP3 field.
	DMAC_CHER_SUSP3_Pos = 0xb
	// Bit mask of SUSP3 field.
	DMAC_CHER_SUSP3_Msk = 0x800
	// Bit SUSP3.
	DMAC_CHER_SUSP3 = 0x800
	// Position of KEEP0 field.
	DMAC_CHER_KEEP0_Pos = 0x18
	// Bit mask of KEEP0 field.
	DMAC_CHER_KEEP0_Msk = 0x1000000
	// Bit KEEP0.
	DMAC_CHER_KEEP0 = 0x1000000
	// Position of KEEP1 field.
	DMAC_CHER_KEEP1_Pos = 0x19
	// Bit mask of KEEP1 field.
	DMAC_CHER_KEEP1_Msk = 0x2000000
	// Bit KEEP1.
	DMAC_CHER_KEEP1 = 0x2000000
	// Position of KEEP2 field.
	DMAC_CHER_KEEP2_Pos = 0x1a
	// Bit mask of KEEP2 field.
	DMAC_CHER_KEEP2_Msk = 0x4000000
	// Bit KEEP2.
	DMAC_CHER_KEEP2 = 0x4000000
	// Position of KEEP3 field.
	DMAC_CHER_KEEP3_Pos = 0x1b
	// Bit mask of KEEP3 field.
	DMAC_CHER_KEEP3_Msk = 0x8000000
	// Bit KEEP3.
	DMAC_CHER_KEEP3 = 0x8000000

	// CHDR: DMAC Channel Handler Disable Register
	// Position of DIS0 field.
	DMAC_CHDR_DIS0_Pos = 0x0
	// Bit mask of DIS0 field.
	DMAC_CHDR_DIS0_Msk = 0x1
	// Bit DIS0.
	DMAC_CHDR_DIS0 = 0x1
	// Position of DIS1 field.
	DMAC_CHDR_DIS1_Pos = 0x1
	// Bit mask of DIS1 field.
	DMAC_CHDR_DIS1_Msk = 0x2
	// Bit DIS1.
	DMAC_CHDR_DIS1 = 0x2
	// Position of DIS2 field.
	DMAC_CHDR_DIS2_Pos = 0x2
	// Bit mask of DIS2 field.
	DMAC_CHDR_DIS2_Msk = 0x4
	// Bit DIS2.
	DMAC_CHDR_DIS2 = 0x4
	// Position of DIS3 field.
	DMAC_CHDR_DIS3_Pos = 0x3
	// Bit mask of DIS3 field.
	DMAC_CHDR_DIS3_Msk = 0x8
	// Bit DIS3.
	DMAC_CHDR_DIS3 = 0x8
	// Position of RES0 field.
	DMAC_CHDR_RES0_Pos = 0x8
	// Bit mask of RES0 field.
	DMAC_CHDR_RES0_Msk = 0x100
	// Bit RES0.
	DMAC_CHDR_RES0 = 0x100
	// Position of RES1 field.
	DMAC_CHDR_RES1_Pos = 0x9
	// Bit mask of RES1 field.
	DMAC_CHDR_RES1_Msk = 0x200
	// Bit RES1.
	DMAC_CHDR_RES1 = 0x200
	// Position of RES2 field.
	DMAC_CHDR_RES2_Pos = 0xa
	// Bit mask of RES2 field.
	DMAC_CHDR_RES2_Msk = 0x400
	// Bit RES2.
	DMAC_CHDR_RES2 = 0x400
	// Position of RES3 field.
	DMAC_CHDR_RES3_Pos = 0xb
	// Bit mask of RES3 field.
	DMAC_CHDR_RES3_Msk = 0x800
	// Bit RES3.
	DMAC_CHDR_RES3 = 0x800

	// CHSR: DMAC Channel Handler Status Register
	// Position of ENA0 field.
	DMAC_CHSR_ENA0_Pos = 0x0
	// Bit mask of ENA0 field.
	DMAC_CHSR_ENA0_Msk = 0x1
	// Bit ENA0.
	DMAC_CHSR_ENA0 = 0x1
	// Position of ENA1 field.
	DMAC_CHSR_ENA1_Pos = 0x1
	// Bit mask of ENA1 field.
	DMAC_CHSR_ENA1_Msk = 0x2
	// Bit ENA1.
	DMAC_CHSR_ENA1 = 0x2
	// Position of ENA2 field.
	DMAC_CHSR_ENA2_Pos = 0x2
	// Bit mask of ENA2 field.
	DMAC_CHSR_ENA2_Msk = 0x4
	// Bit ENA2.
	DMAC_CHSR_ENA2 = 0x4
	// Position of ENA3 field.
	DMAC_CHSR_ENA3_Pos = 0x3
	// Bit mask of ENA3 field.
	DMAC_CHSR_ENA3_Msk = 0x8
	// Bit ENA3.
	DMAC_CHSR_ENA3 = 0x8
	// Position of SUSP0 field.
	DMAC_CHSR_SUSP0_Pos = 0x8
	// Bit mask of SUSP0 field.
	DMAC_CHSR_SUSP0_Msk = 0x100
	// Bit SUSP0.
	DMAC_CHSR_SUSP0 = 0x100
	// Position of SUSP1 field.
	DMAC_CHSR_SUSP1_Pos = 0x9
	// Bit mask of SUSP1 field.
	DMAC_CHSR_SUSP1_Msk = 0x200
	// Bit SUSP1.
	DMAC_CHSR_SUSP1 = 0x200
	// Position of SUSP2 field.
	DMAC_CHSR_SUSP2_Pos = 0xa
	// Bit mask of SUSP2 field.
	DMAC_CHSR_SUSP2_Msk = 0x400
	// Bit SUSP2.
	DMAC_CHSR_SUSP2 = 0x400
	// Position of SUSP3 field.
	DMAC_CHSR_SUSP3_Pos = 0xb
	// Bit mask of SUSP3 field.
	DMAC_CHSR_SUSP3_Msk = 0x800
	// Bit SUSP3.
	DMAC_CHSR_SUSP3 = 0x800
	// Position of EMPT0 field.
	DMAC_CHSR_EMPT0_Pos = 0x10
	// Bit mask of EMPT0 field.
	DMAC_CHSR_EMPT0_Msk = 0x10000
	// Bit EMPT0.
	DMAC_CHSR_EMPT0 = 0x10000
	// Position of EMPT1 field.
	DMAC_CHSR_EMPT1_Pos = 0x11
	// Bit mask of EMPT1 field.
	DMAC_CHSR_EMPT1_Msk = 0x20000
	// Bit EMPT1.
	DMAC_CHSR_EMPT1 = 0x20000
	// Position of EMPT2 field.
	DMAC_CHSR_EMPT2_Pos = 0x12
	// Bit mask of EMPT2 field.
	DMAC_CHSR_EMPT2_Msk = 0x40000
	// Bit EMPT2.
	DMAC_CHSR_EMPT2 = 0x40000
	// Position of EMPT3 field.
	DMAC_CHSR_EMPT3_Pos = 0x13
	// Bit mask of EMPT3 field.
	DMAC_CHSR_EMPT3_Msk = 0x80000
	// Bit EMPT3.
	DMAC_CHSR_EMPT3 = 0x80000
	// Position of STAL0 field.
	DMAC_CHSR_STAL0_Pos = 0x18
	// Bit mask of STAL0 field.
	DMAC_CHSR_STAL0_Msk = 0x1000000
	// Bit STAL0.
	DMAC_CHSR_STAL0 = 0x1000000
	// Position of STAL1 field.
	DMAC_CHSR_STAL1_Pos = 0x19
	// Bit mask of STAL1 field.
	DMAC_CHSR_STAL1_Msk = 0x2000000
	// Bit STAL1.
	DMAC_CHSR_STAL1 = 0x2000000
	// Position of STAL2 field.
	DMAC_CHSR_STAL2_Pos = 0x1a
	// Bit mask of STAL2 field.
	DMAC_CHSR_STAL2_Msk = 0x4000000
	// Bit STAL2.
	DMAC_CHSR_STAL2 = 0x4000000
	// Position of STAL3 field.
	DMAC_CHSR_STAL3_Pos = 0x1b
	// Bit mask of STAL3 field.
	DMAC_CHSR_STAL3_Msk = 0x8000000
	// Bit STAL3.
	DMAC_CHSR_STAL3 = 0x8000000

	// SADDR0: DMAC Channel Source Address Register (ch_num = 0)
	// Position of SADDR field.
	DMAC_SADDR0_SADDR_Pos = 0x0
	// Bit mask of SADDR field.
	DMAC_SADDR0_SADDR_Msk = 0xffffffff

	// DADDR0: DMAC Channel Destination Address Register (ch_num = 0)
	// Position of DADDR field.
	DMAC_DADDR0_DADDR_Pos = 0x0
	// Bit mask of DADDR field.
	DMAC_DADDR0_DADDR_Msk = 0xffffffff

	// DSCR0: DMAC Channel Descriptor Address Register (ch_num = 0)
	// Position of DSCR field.
	DMAC_DSCR0_DSCR_Pos = 0x2
	// Bit mask of DSCR field.
	DMAC_DSCR0_DSCR_Msk = 0xfffffffc

	// CTRLA0: DMAC Channel Control A Register (ch_num = 0)
	// Position of BTSIZE field.
	DMAC_CTRLA0_BTSIZE_Pos = 0x0
	// Bit mask of BTSIZE field.
	DMAC_CTRLA0_BTSIZE_Msk = 0xffff
	// Position of SRC_WIDTH field.
	DMAC_CTRLA0_SRC_WIDTH_Pos = 0x18
	// Bit mask of SRC_WIDTH field.
	DMAC_CTRLA0_SRC_WIDTH_Msk = 0x3000000
	// the transfer size is set to 8-bit width
	DMAC_CTRLA0_SRC_WIDTH_BYTE = 0x0
	// the transfer size is set to 16-bit width
	DMAC_CTRLA0_SRC_WIDTH_HALF_WORD = 0x1
	// the transfer size is set to 32-bit width
	DMAC_CTRLA0_SRC_WIDTH_WORD = 0x2
	// Position of DST_WIDTH field.
	DMAC_CTRLA0_DST_WIDTH_Pos = 0x1c
	// Bit mask of DST_WIDTH field.
	DMAC_CTRLA0_DST_WIDTH_Msk = 0x30000000
	// the transfer size is set to 8-bit width
	DMAC_CTRLA0_DST_WIDTH_BYTE = 0x0
	// the transfer size is set to 16-bit width
	DMAC_CTRLA0_DST_WIDTH_HALF_WORD = 0x1
	// the transfer size is set to 32-bit width
	DMAC_CTRLA0_DST_WIDTH_WORD = 0x2
	// Position of DONE field.
	DMAC_CTRLA0_DONE_Pos = 0x1f
	// Bit mask of DONE field.
	DMAC_CTRLA0_DONE_Msk = 0x80000000
	// Bit DONE.
	DMAC_CTRLA0_DONE = 0x80000000

	// CTRLB0: DMAC Channel Control B Register (ch_num = 0)
	// Position of SRC_DSCR field.
	DMAC_CTRLB0_SRC_DSCR_Pos = 0x10
	// Bit mask of SRC_DSCR field.
	DMAC_CTRLB0_SRC_DSCR_Msk = 0x10000
	// Bit SRC_DSCR.
	DMAC_CTRLB0_SRC_DSCR = 0x10000
	// Source address is updated when the descriptor is fetched from the memory.
	DMAC_CTRLB0_SRC_DSCR_FETCH_FROM_MEM = 0x0
	// Buffer Descriptor Fetch operation is disabled for the source.
	DMAC_CTRLB0_SRC_DSCR_FETCH_DISABLE = 0x1
	// Position of DST_DSCR field.
	DMAC_CTRLB0_DST_DSCR_Pos = 0x14
	// Bit mask of DST_DSCR field.
	DMAC_CTRLB0_DST_DSCR_Msk = 0x100000
	// Bit DST_DSCR.
	DMAC_CTRLB0_DST_DSCR = 0x100000
	// Destination address is updated when the descriptor is fetched from the memory.
	DMAC_CTRLB0_DST_DSCR_FETCH_FROM_MEM = 0x0
	// Buffer Descriptor Fetch operation is disabled for the destination.
	DMAC_CTRLB0_DST_DSCR_FETCH_DISABLE = 0x1
	// Position of FC field.
	DMAC_CTRLB0_FC_Pos = 0x15
	// Bit mask of FC field.
	DMAC_CTRLB0_FC_Msk = 0x600000
	// Memory-to-Memory Transfer DMAC is flow controller
	DMAC_CTRLB0_FC_MEM2MEM_DMA_FC = 0x0
	// Memory-to-Peripheral Transfer DMAC is flow controller
	DMAC_CTRLB0_FC_MEM2PER_DMA_FC = 0x1
	// Peripheral-to-Memory Transfer DMAC is flow controller
	DMAC_CTRLB0_FC_PER2MEM_DMA_FC = 0x2
	// Peripheral-to-Peripheral Transfer DMAC is flow controller
	DMAC_CTRLB0_FC_PER2PER_DMA_FC = 0x3
	// Position of SRC_INCR field.
	DMAC_CTRLB0_SRC_INCR_Pos = 0x18
	// Bit mask of SRC_INCR field.
	DMAC_CTRLB0_SRC_INCR_Msk = 0x3000000
	// The source address is incremented
	DMAC_CTRLB0_SRC_INCR_INCREMENTING = 0x0
	// The source address is decremented
	DMAC_CTRLB0_SRC_INCR_DECREMENTING = 0x1
	// The source address remains unchanged
	DMAC_CTRLB0_SRC_INCR_FIXED = 0x2
	// Position of DST_INCR field.
	DMAC_CTRLB0_DST_INCR_Pos = 0x1c
	// Bit mask of DST_INCR field.
	DMAC_CTRLB0_DST_INCR_Msk = 0x30000000
	// The destination address is incremented
	DMAC_CTRLB0_DST_INCR_INCREMENTING = 0x0
	// The destination address is decremented
	DMAC_CTRLB0_DST_INCR_DECREMENTING = 0x1
	// The destination address remains unchanged
	DMAC_CTRLB0_DST_INCR_FIXED = 0x2
	// Position of IEN field.
	DMAC_CTRLB0_IEN_Pos = 0x1e
	// Bit mask of IEN field.
	DMAC_CTRLB0_IEN_Msk = 0x40000000
	// Bit IEN.
	DMAC_CTRLB0_IEN = 0x40000000

	// CFG0: DMAC Channel Configuration Register (ch_num = 0)
	// Position of SRC_PER field.
	DMAC_CFG0_SRC_PER_Pos = 0x0
	// Bit mask of SRC_PER field.
	DMAC_CFG0_SRC_PER_Msk = 0xf
	// Position of DST_PER field.
	DMAC_CFG0_DST_PER_Pos = 0x4
	// Bit mask of DST_PER field.
	DMAC_CFG0_DST_PER_Msk = 0xf0
	// Position of SRC_H2SEL field.
	DMAC_CFG0_SRC_H2SEL_Pos = 0x9
	// Bit mask of SRC_H2SEL field.
	DMAC_CFG0_SRC_H2SEL_Msk = 0x200
	// Bit SRC_H2SEL.
	DMAC_CFG0_SRC_H2SEL = 0x200
	// Software handshaking interface is used to trigger a transfer request.
	DMAC_CFG0_SRC_H2SEL_SW = 0x0
	// Hardware handshaking interface is used to trigger a transfer request.
	DMAC_CFG0_SRC_H2SEL_HW = 0x1
	// Position of DST_H2SEL field.
	DMAC_CFG0_DST_H2SEL_Pos = 0xd
	// Bit mask of DST_H2SEL field.
	DMAC_CFG0_DST_H2SEL_Msk = 0x2000
	// Bit DST_H2SEL.
	DMAC_CFG0_DST_H2SEL = 0x2000
	// Software handshaking interface is used to trigger a transfer request.
	DMAC_CFG0_DST_H2SEL_SW = 0x0
	// Hardware handshaking interface is used to trigger a transfer request.
	DMAC_CFG0_DST_H2SEL_HW = 0x1
	// Position of SOD field.
	DMAC_CFG0_SOD_Pos = 0x10
	// Bit mask of SOD field.
	DMAC_CFG0_SOD_Msk = 0x10000
	// Bit SOD.
	DMAC_CFG0_SOD = 0x10000
	// STOP ON DONE disabled, the descriptor fetch operation ignores DONE Field of CTRLA register.
	DMAC_CFG0_SOD_DISABLE = 0x0
	// STOP ON DONE activated, the DMAC module is automatically disabled if DONE FIELD is set to 1.
	DMAC_CFG0_SOD_ENABLE = 0x1
	// Position of LOCK_IF field.
	DMAC_CFG0_LOCK_IF_Pos = 0x14
	// Bit mask of LOCK_IF field.
	DMAC_CFG0_LOCK_IF_Msk = 0x100000
	// Bit LOCK_IF.
	DMAC_CFG0_LOCK_IF = 0x100000
	// Interface Lock capability is disabled
	DMAC_CFG0_LOCK_IF_DISABLE = 0x0
	// Interface Lock capability is enabled
	DMAC_CFG0_LOCK_IF_ENABLE = 0x1
	// Position of LOCK_B field.
	DMAC_CFG0_LOCK_B_Pos = 0x15
	// Bit mask of LOCK_B field.
	DMAC_CFG0_LOCK_B_Msk = 0x200000
	// Bit LOCK_B.
	DMAC_CFG0_LOCK_B = 0x200000
	// AHB Bus Locking capability is disabled.
	DMAC_CFG0_LOCK_B_DISABLE = 0x0
	// Position of LOCK_IF_L field.
	DMAC_CFG0_LOCK_IF_L_Pos = 0x16
	// Bit mask of LOCK_IF_L field.
	DMAC_CFG0_LOCK_IF_L_Msk = 0x400000
	// Bit LOCK_IF_L.
	DMAC_CFG0_LOCK_IF_L = 0x400000
	// The Master Interface Arbiter is locked by the channel x for a chunk transfer.
	DMAC_CFG0_LOCK_IF_L_CHUNK = 0x0
	// The Master Interface Arbiter is locked by the channel x for a buffer transfer.
	DMAC_CFG0_LOCK_IF_L_BUFFER = 0x1
	// Position of AHB_PROT field.
	DMAC_CFG0_AHB_PROT_Pos = 0x18
	// Bit mask of AHB_PROT field.
	DMAC_CFG0_AHB_PROT_Msk = 0x7000000
	// Position of FIFOCFG field.
	DMAC_CFG0_FIFOCFG_Pos = 0x1c
	// Bit mask of FIFOCFG field.
	DMAC_CFG0_FIFOCFG_Msk = 0x30000000
	// The largest defined length AHB burst is performed on the destination AHB interface.
	DMAC_CFG0_FIFOCFG_ALAP_CFG = 0x0
	// When half FIFO size is available/filled, a source/destination request is serviced.
	DMAC_CFG0_FIFOCFG_HALF_CFG = 0x1
	// When there is enough space/data available to perform a single AHB access, then the request is serviced.
	DMAC_CFG0_FIFOCFG_ASAP_CFG = 0x2

	// SADDR1: DMAC Channel Source Address Register (ch_num = 1)
	// Position of SADDR field.
	DMAC_SADDR1_SADDR_Pos = 0x0
	// Bit mask of SADDR field.
	DMAC_SADDR1_SADDR_Msk = 0xffffffff

	// DADDR1: DMAC Channel Destination Address Register (ch_num = 1)
	// Position of DADDR field.
	DMAC_DADDR1_DADDR_Pos = 0x0
	// Bit mask of DADDR field.
	DMAC_DADDR1_DADDR_Msk = 0xffffffff

	// DSCR1: DMAC Channel Descriptor Address Register (ch_num = 1)
	// Position of DSCR field.
	DMAC_DSCR1_DSCR_Pos = 0x2
	// Bit mask of DSCR field.
	DMAC_DSCR1_DSCR_Msk = 0xfffffffc

	// CTRLA1: DMAC Channel Control A Register (ch_num = 1)
	// Position of BTSIZE field.
	DMAC_CTRLA1_BTSIZE_Pos = 0x0
	// Bit mask of BTSIZE field.
	DMAC_CTRLA1_BTSIZE_Msk = 0xffff
	// Position of SRC_WIDTH field.
	DMAC_CTRLA1_SRC_WIDTH_Pos = 0x18
	// Bit mask of SRC_WIDTH field.
	DMAC_CTRLA1_SRC_WIDTH_Msk = 0x3000000
	// the transfer size is set to 8-bit width
	DMAC_CTRLA1_SRC_WIDTH_BYTE = 0x0
	// the transfer size is set to 16-bit width
	DMAC_CTRLA1_SRC_WIDTH_HALF_WORD = 0x1
	// the transfer size is set to 32-bit width
	DMAC_CTRLA1_SRC_WIDTH_WORD = 0x2
	// Position of DST_WIDTH field.
	DMAC_CTRLA1_DST_WIDTH_Pos = 0x1c
	// Bit mask of DST_WIDTH field.
	DMAC_CTRLA1_DST_WIDTH_Msk = 0x30000000
	// the transfer size is set to 8-bit width
	DMAC_CTRLA1_DST_WIDTH_BYTE = 0x0
	// the transfer size is set to 16-bit width
	DMAC_CTRLA1_DST_WIDTH_HALF_WORD = 0x1
	// the transfer size is set to 32-bit width
	DMAC_CTRLA1_DST_WIDTH_WORD = 0x2
	// Position of DONE field.
	DMAC_CTRLA1_DONE_Pos = 0x1f
	// Bit mask of DONE field.
	DMAC_CTRLA1_DONE_Msk = 0x80000000
	// Bit DONE.
	DMAC_CTRLA1_DONE = 0x80000000

	// CTRLB1: DMAC Channel Control B Register (ch_num = 1)
	// Position of SRC_DSCR field.
	DMAC_CTRLB1_SRC_DSCR_Pos = 0x10
	// Bit mask of SRC_DSCR field.
	DMAC_CTRLB1_SRC_DSCR_Msk = 0x10000
	// Bit SRC_DSCR.
	DMAC_CTRLB1_SRC_DSCR = 0x10000
	// Source address is updated when the descriptor is fetched from the memory.
	DMAC_CTRLB1_SRC_DSCR_FETCH_FROM_MEM = 0x0
	// Buffer Descriptor Fetch operation is disabled for the source.
	DMAC_CTRLB1_SRC_DSCR_FETCH_DISABLE = 0x1
	// Position of DST_DSCR field.
	DMAC_CTRLB1_DST_DSCR_Pos = 0x14
	// Bit mask of DST_DSCR field.
	DMAC_CTRLB1_DST_DSCR_Msk = 0x100000
	// Bit DST_DSCR.
	DMAC_CTRLB1_DST_DSCR = 0x100000
	// Destination address is updated when the descriptor is fetched from the memory.
	DMAC_CTRLB1_DST_DSCR_FETCH_FROM_MEM = 0x0
	// Buffer Descriptor Fetch operation is disabled for the destination.
	DMAC_CTRLB1_DST_DSCR_FETCH_DISABLE = 0x1
	// Position of FC field.
	DMAC_CTRLB1_FC_Pos = 0x15
	// Bit mask of FC field.
	DMAC_CTRLB1_FC_Msk = 0x600000
	// Memory-to-Memory Transfer DMAC is flow controller
	DMAC_CTRLB1_FC_MEM2MEM_DMA_FC = 0x0
	// Memory-to-Peripheral Transfer DMAC is flow controller
	DMAC_CTRLB1_FC_MEM2PER_DMA_FC = 0x1
	// Peripheral-to-Memory Transfer DMAC is flow controller
	DMAC_CTRLB1_FC_PER2MEM_DMA_FC = 0x2
	// Peripheral-to-Peripheral Transfer DMAC is flow controller
	DMAC_CTRLB1_FC_PER2PER_DMA_FC = 0x3
	// Position of SRC_INCR field.
	DMAC_CTRLB1_SRC_INCR_Pos = 0x18
	// Bit mask of SRC_INCR field.
	DMAC_CTRLB1_SRC_INCR_Msk = 0x3000000
	// The source address is incremented
	DMAC_CTRLB1_SRC_INCR_INCREMENTING = 0x0
	// The source address is decremented
	DMAC_CTRLB1_SRC_INCR_DECREMENTING = 0x1
	// The source address remains unchanged
	DMAC_CTRLB1_SRC_INCR_FIXED = 0x2
	// Position of DST_INCR field.
	DMAC_CTRLB1_DST_INCR_Pos = 0x1c
	// Bit mask of DST_INCR field.
	DMAC_CTRLB1_DST_INCR_Msk = 0x30000000
	// The destination address is incremented
	DMAC_CTRLB1_DST_INCR_INCREMENTING = 0x0
	// The destination address is decremented
	DMAC_CTRLB1_DST_INCR_DECREMENTING = 0x1
	// The destination address remains unchanged
	DMAC_CTRLB1_DST_INCR_FIXED = 0x2
	// Position of IEN field.
	DMAC_CTRLB1_IEN_Pos = 0x1e
	// Bit mask of IEN field.
	DMAC_CTRLB1_IEN_Msk = 0x40000000
	// Bit IEN.
	DMAC_CTRLB1_IEN = 0x40000000

	// CFG1: DMAC Channel Configuration Register (ch_num = 1)
	// Position of SRC_PER field.
	DMAC_CFG1_SRC_PER_Pos = 0x0
	// Bit mask of SRC_PER field.
	DMAC_CFG1_SRC_PER_Msk = 0xf
	// Position of DST_PER field.
	DMAC_CFG1_DST_PER_Pos = 0x4
	// Bit mask of DST_PER field.
	DMAC_CFG1_DST_PER_Msk = 0xf0
	// Position of SRC_H2SEL field.
	DMAC_CFG1_SRC_H2SEL_Pos = 0x9
	// Bit mask of SRC_H2SEL field.
	DMAC_CFG1_SRC_H2SEL_Msk = 0x200
	// Bit SRC_H2SEL.
	DMAC_CFG1_SRC_H2SEL = 0x200
	// Software handshaking interface is used to trigger a transfer request.
	DMAC_CFG1_SRC_H2SEL_SW = 0x0
	// Hardware handshaking interface is used to trigger a transfer request.
	DMAC_CFG1_SRC_H2SEL_HW = 0x1
	// Position of DST_H2SEL field.
	DMAC_CFG1_DST_H2SEL_Pos = 0xd
	// Bit mask of DST_H2SEL field.
	DMAC_CFG1_DST_H2SEL_Msk = 0x2000
	// Bit DST_H2SEL.
	DMAC_CFG1_DST_H2SEL = 0x2000
	// Software handshaking interface is used to trigger a transfer request.
	DMAC_CFG1_DST_H2SEL_SW = 0x0
	// Hardware handshaking interface is used to trigger a transfer request.
	DMAC_CFG1_DST_H2SEL_HW = 0x1
	// Position of SOD field.
	DMAC_CFG1_SOD_Pos = 0x10
	// Bit mask of SOD field.
	DMAC_CFG1_SOD_Msk = 0x10000
	// Bit SOD.
	DMAC_CFG1_SOD = 0x10000
	// STOP ON DONE disabled, the descriptor fetch operation ignores DONE Field of CTRLA register.
	DMAC_CFG1_SOD_DISABLE = 0x0
	// STOP ON DONE activated, the DMAC module is automatically disabled if DONE FIELD is set to 1.
	DMAC_CFG1_SOD_ENABLE = 0x1
	// Position of LOCK_IF field.
	DMAC_CFG1_LOCK_IF_Pos = 0x14
	// Bit mask of LOCK_IF field.
	DMAC_CFG1_LOCK_IF_Msk = 0x100000
	// Bit LOCK_IF.
	DMAC_CFG1_LOCK_IF = 0x100000
	// Interface Lock capability is disabled
	DMAC_CFG1_LOCK_IF_DISABLE = 0x0
	// Interface Lock capability is enabled
	DMAC_CFG1_LOCK_IF_ENABLE = 0x1
	// Position of LOCK_B field.
	DMAC_CFG1_LOCK_B_Pos = 0x15
	// Bit mask of LOCK_B field.
	DMAC_CFG1_LOCK_B_Msk = 0x200000
	// Bit LOCK_B.
	DMAC_CFG1_LOCK_B = 0x200000
	// AHB Bus Locking capability is disabled.
	DMAC_CFG1_LOCK_B_DISABLE = 0x0
	// Position of LOCK_IF_L field.
	DMAC_CFG1_LOCK_IF_L_Pos = 0x16
	// Bit mask of LOCK_IF_L field.
	DMAC_CFG1_LOCK_IF_L_Msk = 0x400000
	// Bit LOCK_IF_L.
	DMAC_CFG1_LOCK_IF_L = 0x400000
	// The Master Interface Arbiter is locked by the channel x for a chunk transfer.
	DMAC_CFG1_LOCK_IF_L_CHUNK = 0x0
	// The Master Interface Arbiter is locked by the channel x for a buffer transfer.
	DMAC_CFG1_LOCK_IF_L_BUFFER = 0x1
	// Position of AHB_PROT field.
	DMAC_CFG1_AHB_PROT_Pos = 0x18
	// Bit mask of AHB_PROT field.
	DMAC_CFG1_AHB_PROT_Msk = 0x7000000
	// Position of FIFOCFG field.
	DMAC_CFG1_FIFOCFG_Pos = 0x1c
	// Bit mask of FIFOCFG field.
	DMAC_CFG1_FIFOCFG_Msk = 0x30000000
	// The largest defined length AHB burst is performed on the destination AHB interface.
	DMAC_CFG1_FIFOCFG_ALAP_CFG = 0x0
	// When half FIFO size is available/filled, a source/destination request is serviced.
	DMAC_CFG1_FIFOCFG_HALF_CFG = 0x1
	// When there is enough space/data available to perform a single AHB access, then the request is serviced.
	DMAC_CFG1_FIFOCFG_ASAP_CFG = 0x2

	// SADDR2: DMAC Channel Source Address Register (ch_num = 2)
	// Position of SADDR field.
	DMAC_SADDR2_SADDR_Pos = 0x0
	// Bit mask of SADDR field.
	DMAC_SADDR2_SADDR_Msk = 0xffffffff

	// DADDR2: DMAC Channel Destination Address Register (ch_num = 2)
	// Position of DADDR field.
	DMAC_DADDR2_DADDR_Pos = 0x0
	// Bit mask of DADDR field.
	DMAC_DADDR2_DADDR_Msk = 0xffffffff

	// DSCR2: DMAC Channel Descriptor Address Register (ch_num = 2)
	// Position of DSCR field.
	DMAC_DSCR2_DSCR_Pos = 0x2
	// Bit mask of DSCR field.
	DMAC_DSCR2_DSCR_Msk = 0xfffffffc

	// CTRLA2: DMAC Channel Control A Register (ch_num = 2)
	// Position of BTSIZE field.
	DMAC_CTRLA2_BTSIZE_Pos = 0x0
	// Bit mask of BTSIZE field.
	DMAC_CTRLA2_BTSIZE_Msk = 0xffff
	// Position of SRC_WIDTH field.
	DMAC_CTRLA2_SRC_WIDTH_Pos = 0x18
	// Bit mask of SRC_WIDTH field.
	DMAC_CTRLA2_SRC_WIDTH_Msk = 0x3000000
	// the transfer size is set to 8-bit width
	DMAC_CTRLA2_SRC_WIDTH_BYTE = 0x0
	// the transfer size is set to 16-bit width
	DMAC_CTRLA2_SRC_WIDTH_HALF_WORD = 0x1
	// the transfer size is set to 32-bit width
	DMAC_CTRLA2_SRC_WIDTH_WORD = 0x2
	// Position of DST_WIDTH field.
	DMAC_CTRLA2_DST_WIDTH_Pos = 0x1c
	// Bit mask of DST_WIDTH field.
	DMAC_CTRLA2_DST_WIDTH_Msk = 0x30000000
	// the transfer size is set to 8-bit width
	DMAC_CTRLA2_DST_WIDTH_BYTE = 0x0
	// the transfer size is set to 16-bit width
	DMAC_CTRLA2_DST_WIDTH_HALF_WORD = 0x1
	// the transfer size is set to 32-bit width
	DMAC_CTRLA2_DST_WIDTH_WORD = 0x2
	// Position of DONE field.
	DMAC_CTRLA2_DONE_Pos = 0x1f
	// Bit mask of DONE field.
	DMAC_CTRLA2_DONE_Msk = 0x80000000
	// Bit DONE.
	DMAC_CTRLA2_DONE = 0x80000000

	// CTRLB2: DMAC Channel Control B Register (ch_num = 2)
	// Position of SRC_DSCR field.
	DMAC_CTRLB2_SRC_DSCR_Pos = 0x10
	// Bit mask of SRC_DSCR field.
	DMAC_CTRLB2_SRC_DSCR_Msk = 0x10000
	// Bit SRC_DSCR.
	DMAC_CTRLB2_SRC_DSCR = 0x10000
	// Source address is updated when the descriptor is fetched from the memory.
	DMAC_CTRLB2_SRC_DSCR_FETCH_FROM_MEM = 0x0
	// Buffer Descriptor Fetch operation is disabled for the source.
	DMAC_CTRLB2_SRC_DSCR_FETCH_DISABLE = 0x1
	// Position of DST_DSCR field.
	DMAC_CTRLB2_DST_DSCR_Pos = 0x14
	// Bit mask of DST_DSCR field.
	DMAC_CTRLB2_DST_DSCR_Msk = 0x100000
	// Bit DST_DSCR.
	DMAC_CTRLB2_DST_DSCR = 0x100000
	// Destination address is updated when the descriptor is fetched from the memory.
	DMAC_CTRLB2_DST_DSCR_FETCH_FROM_MEM = 0x0
	// Buffer Descriptor Fetch operation is disabled for the destination.
	DMAC_CTRLB2_DST_DSCR_FETCH_DISABLE = 0x1
	// Position of FC field.
	DMAC_CTRLB2_FC_Pos = 0x15
	// Bit mask of FC field.
	DMAC_CTRLB2_FC_Msk = 0x600000
	// Memory-to-Memory Transfer DMAC is flow controller
	DMAC_CTRLB2_FC_MEM2MEM_DMA_FC = 0x0
	// Memory-to-Peripheral Transfer DMAC is flow controller
	DMAC_CTRLB2_FC_MEM2PER_DMA_FC = 0x1
	// Peripheral-to-Memory Transfer DMAC is flow controller
	DMAC_CTRLB2_FC_PER2MEM_DMA_FC = 0x2
	// Peripheral-to-Peripheral Transfer DMAC is flow controller
	DMAC_CTRLB2_FC_PER2PER_DMA_FC = 0x3
	// Position of SRC_INCR field.
	DMAC_CTRLB2_SRC_INCR_Pos = 0x18
	// Bit mask of SRC_INCR field.
	DMAC_CTRLB2_SRC_INCR_Msk = 0x3000000
	// The source address is incremented
	DMAC_CTRLB2_SRC_INCR_INCREMENTING = 0x0
	// The source address is decremented
	DMAC_CTRLB2_SRC_INCR_DECREMENTING = 0x1
	// The source address remains unchanged
	DMAC_CTRLB2_SRC_INCR_FIXED = 0x2
	// Position of DST_INCR field.
	DMAC_CTRLB2_DST_INCR_Pos = 0x1c
	// Bit mask of DST_INCR field.
	DMAC_CTRLB2_DST_INCR_Msk = 0x30000000
	// The destination address is incremented
	DMAC_CTRLB2_DST_INCR_INCREMENTING = 0x0
	// The destination address is decremented
	DMAC_CTRLB2_DST_INCR_DECREMENTING = 0x1
	// The destination address remains unchanged
	DMAC_CTRLB2_DST_INCR_FIXED = 0x2
	// Position of IEN field.
	DMAC_CTRLB2_IEN_Pos = 0x1e
	// Bit mask of IEN field.
	DMAC_CTRLB2_IEN_Msk = 0x40000000
	// Bit IEN.
	DMAC_CTRLB2_IEN = 0x40000000

	// CFG2: DMAC Channel Configuration Register (ch_num = 2)
	// Position of SRC_PER field.
	DMAC_CFG2_SRC_PER_Pos = 0x0
	// Bit mask of SRC_PER field.
	DMAC_CFG2_SRC_PER_Msk = 0xf
	// Position of DST_PER field.
	DMAC_CFG2_DST_PER_Pos = 0x4
	// Bit mask of DST_PER field.
	DMAC_CFG2_DST_PER_Msk = 0xf0
	// Position of SRC_H2SEL field.
	DMAC_CFG2_SRC_H2SEL_Pos = 0x9
	// Bit mask of SRC_H2SEL field.
	DMAC_CFG2_SRC_H2SEL_Msk = 0x200
	// Bit SRC_H2SEL.
	DMAC_CFG2_SRC_H2SEL = 0x200
	// Software handshaking interface is used to trigger a transfer request.
	DMAC_CFG2_SRC_H2SEL_SW = 0x0
	// Hardware handshaking interface is used to trigger a transfer request.
	DMAC_CFG2_SRC_H2SEL_HW = 0x1
	// Position of DST_H2SEL field.
	DMAC_CFG2_DST_H2SEL_Pos = 0xd
	// Bit mask of DST_H2SEL field.
	DMAC_CFG2_DST_H2SEL_Msk = 0x2000
	// Bit DST_H2SEL.
	DMAC_CFG2_DST_H2SEL = 0x2000
	// Software handshaking interface is used to trigger a transfer request.
	DMAC_CFG2_DST_H2SEL_SW = 0x0
	// Hardware handshaking interface is used to trigger a transfer request.
	DMAC_CFG2_DST_H2SEL_HW = 0x1
	// Position of SOD field.
	DMAC_CFG2_SOD_Pos = 0x10
	// Bit mask of SOD field.
	DMAC_CFG2_SOD_Msk = 0x10000
	// Bit SOD.
	DMAC_CFG2_SOD = 0x10000
	// STOP ON DONE disabled, the descriptor fetch operation ignores DONE Field of CTRLA register.
	DMAC_CFG2_SOD_DISABLE = 0x0
	// STOP ON DONE activated, the DMAC module is automatically disabled if DONE FIELD is set to 1.
	DMAC_CFG2_SOD_ENABLE = 0x1
	// Position of LOCK_IF field.
	DMAC_CFG2_LOCK_IF_Pos = 0x14
	// Bit mask of LOCK_IF field.
	DMAC_CFG2_LOCK_IF_Msk = 0x100000
	// Bit LOCK_IF.
	DMAC_CFG2_LOCK_IF = 0x100000
	// Interface Lock capability is disabled
	DMAC_CFG2_LOCK_IF_DISABLE = 0x0
	// Interface Lock capability is enabled
	DMAC_CFG2_LOCK_IF_ENABLE = 0x1
	// Position of LOCK_B field.
	DMAC_CFG2_LOCK_B_Pos = 0x15
	// Bit mask of LOCK_B field.
	DMAC_CFG2_LOCK_B_Msk = 0x200000
	// Bit LOCK_B.
	DMAC_CFG2_LOCK_B = 0x200000
	// AHB Bus Locking capability is disabled.
	DMAC_CFG2_LOCK_B_DISABLE = 0x0
	// Position of LOCK_IF_L field.
	DMAC_CFG2_LOCK_IF_L_Pos = 0x16
	// Bit mask of LOCK_IF_L field.
	DMAC_CFG2_LOCK_IF_L_Msk = 0x400000
	// Bit LOCK_IF_L.
	DMAC_CFG2_LOCK_IF_L = 0x400000
	// The Master Interface Arbiter is locked by the channel x for a chunk transfer.
	DMAC_CFG2_LOCK_IF_L_CHUNK = 0x0
	// The Master Interface Arbiter is locked by the channel x for a buffer transfer.
	DMAC_CFG2_LOCK_IF_L_BUFFER = 0x1
	// Position of AHB_PROT field.
	DMAC_CFG2_AHB_PROT_Pos = 0x18
	// Bit mask of AHB_PROT field.
	DMAC_CFG2_AHB_PROT_Msk = 0x7000000
	// Position of FIFOCFG field.
	DMAC_CFG2_FIFOCFG_Pos = 0x1c
	// Bit mask of FIFOCFG field.
	DMAC_CFG2_FIFOCFG_Msk = 0x30000000
	// The largest defined length AHB burst is performed on the destination AHB interface.
	DMAC_CFG2_FIFOCFG_ALAP_CFG = 0x0
	// When half FIFO size is available/filled, a source/destination request is serviced.
	DMAC_CFG2_FIFOCFG_HALF_CFG = 0x1
	// When there is enough space/data available to perform a single AHB access, then the request is serviced.
	DMAC_CFG2_FIFOCFG_ASAP_CFG = 0x2

	// SADDR3: DMAC Channel Source Address Register (ch_num = 3)
	// Position of SADDR field.
	DMAC_SADDR3_SADDR_Pos = 0x0
	// Bit mask of SADDR field.
	DMAC_SADDR3_SADDR_Msk = 0xffffffff

	// DADDR3: DMAC Channel Destination Address Register (ch_num = 3)
	// Position of DADDR field.
	DMAC_DADDR3_DADDR_Pos = 0x0
	// Bit mask of DADDR field.
	DMAC_DADDR3_DADDR_Msk = 0xffffffff

	// DSCR3: DMAC Channel Descriptor Address Register (ch_num = 3)
	// Position of DSCR field.
	DMAC_DSCR3_DSCR_Pos = 0x2
	// Bit mask of DSCR field.
	DMAC_DSCR3_DSCR_Msk = 0xfffffffc

	// CTRLA3: DMAC Channel Control A Register (ch_num = 3)
	// Position of BTSIZE field.
	DMAC_CTRLA3_BTSIZE_Pos = 0x0
	// Bit mask of BTSIZE field.
	DMAC_CTRLA3_BTSIZE_Msk = 0xffff
	// Position of SRC_WIDTH field.
	DMAC_CTRLA3_SRC_WIDTH_Pos = 0x18
	// Bit mask of SRC_WIDTH field.
	DMAC_CTRLA3_SRC_WIDTH_Msk = 0x3000000
	// the transfer size is set to 8-bit width
	DMAC_CTRLA3_SRC_WIDTH_BYTE = 0x0
	// the transfer size is set to 16-bit width
	DMAC_CTRLA3_SRC_WIDTH_HALF_WORD = 0x1
	// the transfer size is set to 32-bit width
	DMAC_CTRLA3_SRC_WIDTH_WORD = 0x2
	// Position of DST_WIDTH field.
	DMAC_CTRLA3_DST_WIDTH_Pos = 0x1c
	// Bit mask of DST_WIDTH field.
	DMAC_CTRLA3_DST_WIDTH_Msk = 0x30000000
	// the transfer size is set to 8-bit width
	DMAC_CTRLA3_DST_WIDTH_BYTE = 0x0
	// the transfer size is set to 16-bit width
	DMAC_CTRLA3_DST_WIDTH_HALF_WORD = 0x1
	// the transfer size is set to 32-bit width
	DMAC_CTRLA3_DST_WIDTH_WORD = 0x2
	// Position of DONE field.
	DMAC_CTRLA3_DONE_Pos = 0x1f
	// Bit mask of DONE field.
	DMAC_CTRLA3_DONE_Msk = 0x80000000
	// Bit DONE.
	DMAC_CTRLA3_DONE = 0x80000000

	// CTRLB3: DMAC Channel Control B Register (ch_num = 3)
	// Position of SRC_DSCR field.
	DMAC_CTRLB3_SRC_DSCR_Pos = 0x10
	// Bit mask of SRC_DSCR field.
	DMAC_CTRLB3_SRC_DSCR_Msk = 0x10000
	// Bit SRC_DSCR.
	DMAC_CTRLB3_SRC_DSCR = 0x10000
	// Source address is updated when the descriptor is fetched from the memory.
	DMAC_CTRLB3_SRC_DSCR_FETCH_FROM_MEM = 0x0
	// Buffer Descriptor Fetch operation is disabled for the source.
	DMAC_CTRLB3_SRC_DSCR_FETCH_DISABLE = 0x1
	// Position of DST_DSCR field.
	DMAC_CTRLB3_DST_DSCR_Pos = 0x14
	// Bit mask of DST_DSCR field.
	DMAC_CTRLB3_DST_DSCR_Msk = 0x100000
	// Bit DST_DSCR.
	DMAC_CTRLB3_DST_DSCR = 0x100000
	// Destination address is updated when the descriptor is fetched from the memory.
	DMAC_CTRLB3_DST_DSCR_FETCH_FROM_MEM = 0x0
	// Buffer Descriptor Fetch operation is disabled for the destination.
	DMAC_CTRLB3_DST_DSCR_FETCH_DISABLE = 0x1
	// Position of FC field.
	DMAC_CTRLB3_FC_Pos = 0x15
	// Bit mask of FC field.
	DMAC_CTRLB3_FC_Msk = 0x600000
	// Memory-to-Memory Transfer DMAC is flow controller
	DMAC_CTRLB3_FC_MEM2MEM_DMA_FC = 0x0
	// Memory-to-Peripheral Transfer DMAC is flow controller
	DMAC_CTRLB3_FC_MEM2PER_DMA_FC = 0x1
	// Peripheral-to-Memory Transfer DMAC is flow controller
	DMAC_CTRLB3_FC_PER2MEM_DMA_FC = 0x2
	// Peripheral-to-Peripheral Transfer DMAC is flow controller
	DMAC_CTRLB3_FC_PER2PER_DMA_FC = 0x3
	// Position of SRC_INCR field.
	DMAC_CTRLB3_SRC_INCR_Pos = 0x18
	// Bit mask of SRC_INCR field.
	DMAC_CTRLB3_SRC_INCR_Msk = 0x3000000
	// The source address is incremented
	DMAC_CTRLB3_SRC_INCR_INCREMENTING = 0x0
	// The source address is decremented
	DMAC_CTRLB3_SRC_INCR_DECREMENTING = 0x1
	// The source address remains unchanged
	DMAC_CTRLB3_SRC_INCR_FIXED = 0x2
	// Position of DST_INCR field.
	DMAC_CTRLB3_DST_INCR_Pos = 0x1c
	// Bit mask of DST_INCR field.
	DMAC_CTRLB3_DST_INCR_Msk = 0x30000000
	// The destination address is incremented
	DMAC_CTRLB3_DST_INCR_INCREMENTING = 0x0
	// The destination address is decremented
	DMAC_CTRLB3_DST_INCR_DECREMENTING = 0x1
	// The destination address remains unchanged
	DMAC_CTRLB3_DST_INCR_FIXED = 0x2
	// Position of IEN field.
	DMAC_CTRLB3_IEN_Pos = 0x1e
	// Bit mask of IEN field.
	DMAC_CTRLB3_IEN_Msk = 0x40000000
	// Bit IEN.
	DMAC_CTRLB3_IEN = 0x40000000

	// CFG3: DMAC Channel Configuration Register (ch_num = 3)
	// Position of SRC_PER field.
	DMAC_CFG3_SRC_PER_Pos = 0x0
	// Bit mask of SRC_PER field.
	DMAC_CFG3_SRC_PER_Msk = 0xf
	// Position of DST_PER field.
	DMAC_CFG3_DST_PER_Pos = 0x4
	// Bit mask of DST_PER field.
	DMAC_CFG3_DST_PER_Msk = 0xf0
	// Position of SRC_H2SEL field.
	DMAC_CFG3_SRC_H2SEL_Pos = 0x9
	// Bit mask of SRC_H2SEL field.
	DMAC_CFG3_SRC_H2SEL_Msk = 0x200
	// Bit SRC_H2SEL.
	DMAC_CFG3_SRC_H2SEL = 0x200
	// Software handshaking interface is used to trigger a transfer request.
	DMAC_CFG3_SRC_H2SEL_SW = 0x0
	// Hardware handshaking interface is used to trigger a transfer request.
	DMAC_CFG3_SRC_H2SEL_HW = 0x1
	// Position of DST_H2SEL field.
	DMAC_CFG3_DST_H2SEL_Pos = 0xd
	// Bit mask of DST_H2SEL field.
	DMAC_CFG3_DST_H2SEL_Msk = 0x2000
	// Bit DST_H2SEL.
	DMAC_CFG3_DST_H2SEL = 0x2000
	// Software handshaking interface is used to trigger a transfer request.
	DMAC_CFG3_DST_H2SEL_SW = 0x0
	// Hardware handshaking interface is used to trigger a transfer request.
	DMAC_CFG3_DST_H2SEL_HW = 0x1
	// Position of SOD field.
	DMAC_CFG3_SOD_Pos = 0x10
	// Bit mask of SOD field.
	DMAC_CFG3_SOD_Msk = 0x10000
	// Bit SOD.
	DMAC_CFG3_SOD = 0x10000
	// STOP ON DONE disabled, the descriptor fetch operation ignores DONE Field of CTRLA register.
	DMAC_CFG3_SOD_DISABLE = 0x0
	// STOP ON DONE activated, the DMAC module is automatically disabled if DONE FIELD is set to 1.
	DMAC_CFG3_SOD_ENABLE = 0x1
	// Position of LOCK_IF field.
	DMAC_CFG3_LOCK_IF_Pos = 0x14
	// Bit mask of LOCK_IF field.
	DMAC_CFG3_LOCK_IF_Msk = 0x100000
	// Bit LOCK_IF.
	DMAC_CFG3_LOCK_IF = 0x100000
	// Interface Lock capability is disabled
	DMAC_CFG3_LOCK_IF_DISABLE = 0x0
	// Interface Lock capability is enabled
	DMAC_CFG3_LOCK_IF_ENABLE = 0x1
	// Position of LOCK_B field.
	DMAC_CFG3_LOCK_B_Pos = 0x15
	// Bit mask of LOCK_B field.
	DMAC_CFG3_LOCK_B_Msk = 0x200000
	// Bit LOCK_B.
	DMAC_CFG3_LOCK_B = 0x200000
	// AHB Bus Locking capability is disabled.
	DMAC_CFG3_LOCK_B_DISABLE = 0x0
	// Position of LOCK_IF_L field.
	DMAC_CFG3_LOCK_IF_L_Pos = 0x16
	// Bit mask of LOCK_IF_L field.
	DMAC_CFG3_LOCK_IF_L_Msk = 0x400000
	// Bit LOCK_IF_L.
	DMAC_CFG3_LOCK_IF_L = 0x400000
	// The Master Interface Arbiter is locked by the channel x for a chunk transfer.
	DMAC_CFG3_LOCK_IF_L_CHUNK = 0x0
	// The Master Interface Arbiter is locked by the channel x for a buffer transfer.
	DMAC_CFG3_LOCK_IF_L_BUFFER = 0x1
	// Position of AHB_PROT field.
	DMAC_CFG3_AHB_PROT_Pos = 0x18
	// Bit mask of AHB_PROT field.
	DMAC_CFG3_AHB_PROT_Msk = 0x7000000
	// Position of FIFOCFG field.
	DMAC_CFG3_FIFOCFG_Pos = 0x1c
	// Bit mask of FIFOCFG field.
	DMAC_CFG3_FIFOCFG_Msk = 0x30000000
	// The largest defined length AHB burst is performed on the destination AHB interface.
	DMAC_CFG3_FIFOCFG_ALAP_CFG = 0x0
	// When half FIFO size is available/filled, a source/destination request is serviced.
	DMAC_CFG3_FIFOCFG_HALF_CFG = 0x1
	// When there is enough space/data available to perform a single AHB access, then the request is serviced.
	DMAC_CFG3_FIFOCFG_ASAP_CFG = 0x2

	// WPMR: DMAC Write Protect Mode Register
	// Position of WPEN field.
	DMAC_WPMR_WPEN_Pos = 0x0
	// Bit mask of WPEN field.
	DMAC_WPMR_WPEN_Msk = 0x1
	// Bit WPEN.
	DMAC_WPMR_WPEN = 0x1
	// Position of WPKEY field.
	DMAC_WPMR_WPKEY_Pos = 0x8
	// Bit mask of WPKEY field.
	DMAC_WPMR_WPKEY_Msk = 0xffffff00
	// Writing any other value in this field aborts the write operation of the WPEN bit.Always reads as 0.
	DMAC_WPMR_WPKEY_PASSWD = 0x444d41

	// WPSR: DMAC Write Protect Status Register
	// Position of WPVS field.
	DMAC_WPSR_WPVS_Pos = 0x0
	// Bit mask of WPVS field.
	DMAC_WPSR_WPVS_Msk = 0x1
	// Bit WPVS.
	DMAC_WPSR_WPVS = 0x1
	// Position of WPVSRC field.
	DMAC_WPSR_WPVSRC_Pos = 0x8
	// Bit mask of WPVSRC field.
	DMAC_WPSR_WPVSRC_Msk = 0xffff00
)

// Bitfields for SMC: Static Memory Controller
const (
	// CFG: SMC NFC Configuration Register
	// Position of PAGESIZE field.
	EBI_CFG_PAGESIZE_Pos = 0x0
	// Bit mask of PAGESIZE field.
	EBI_CFG_PAGESIZE_Msk = 0x3
	// Main area 512 Bytes + Spare area 16 Bytes = 528 Bytes
	EBI_CFG_PAGESIZE_PS512_16 = 0x0
	// Main area 1024 Bytes + Spare area 32 Bytes = 1056 Bytes
	EBI_CFG_PAGESIZE_PS1024_32 = 0x1
	// Main area 2048 Bytes + Spare area 64 Bytes = 2112 Bytes
	EBI_CFG_PAGESIZE_PS2048_64 = 0x2
	// Main area 4096 Bytes + Spare area 128 Bytes = 4224 Bytes
	EBI_CFG_PAGESIZE_PS4096_128 = 0x3
	// Position of WSPARE field.
	EBI_CFG_WSPARE_Pos = 0x8
	// Bit mask of WSPARE field.
	EBI_CFG_WSPARE_Msk = 0x100
	// Bit WSPARE.
	EBI_CFG_WSPARE = 0x100
	// Position of RSPARE field.
	EBI_CFG_RSPARE_Pos = 0x9
	// Bit mask of RSPARE field.
	EBI_CFG_RSPARE_Msk = 0x200
	// Bit RSPARE.
	EBI_CFG_RSPARE = 0x200
	// Position of EDGECTRL field.
	EBI_CFG_EDGECTRL_Pos = 0xc
	// Bit mask of EDGECTRL field.
	EBI_CFG_EDGECTRL_Msk = 0x1000
	// Bit EDGECTRL.
	EBI_CFG_EDGECTRL = 0x1000
	// Position of RBEDGE field.
	EBI_CFG_RBEDGE_Pos = 0xd
	// Bit mask of RBEDGE field.
	EBI_CFG_RBEDGE_Msk = 0x2000
	// Bit RBEDGE.
	EBI_CFG_RBEDGE = 0x2000
	// Position of DTOCYC field.
	EBI_CFG_DTOCYC_Pos = 0x10
	// Bit mask of DTOCYC field.
	EBI_CFG_DTOCYC_Msk = 0xf0000
	// Position of DTOMUL field.
	EBI_CFG_DTOMUL_Pos = 0x14
	// Bit mask of DTOMUL field.
	EBI_CFG_DTOMUL_Msk = 0x700000
	// DTOCYC
	EBI_CFG_DTOMUL_X1 = 0x0
	// DTOCYC x 16
	EBI_CFG_DTOMUL_X16 = 0x1
	// DTOCYC x 128
	EBI_CFG_DTOMUL_X128 = 0x2
	// DTOCYC x 256
	EBI_CFG_DTOMUL_X256 = 0x3
	// DTOCYC x 1024
	EBI_CFG_DTOMUL_X1024 = 0x4
	// DTOCYC x 4096
	EBI_CFG_DTOMUL_X4096 = 0x5
	// DTOCYC x 65536
	EBI_CFG_DTOMUL_X65536 = 0x6
	// DTOCYC x 1048576
	EBI_CFG_DTOMUL_X1048576 = 0x7

	// CTRL: SMC NFC Control Register
	// Position of NFCEN field.
	EBI_CTRL_NFCEN_Pos = 0x0
	// Bit mask of NFCEN field.
	EBI_CTRL_NFCEN_Msk = 0x1
	// Bit NFCEN.
	EBI_CTRL_NFCEN = 0x1
	// Position of NFCDIS field.
	EBI_CTRL_NFCDIS_Pos = 0x1
	// Bit mask of NFCDIS field.
	EBI_CTRL_NFCDIS_Msk = 0x2
	// Bit NFCDIS.
	EBI_CTRL_NFCDIS = 0x2

	// SR: SMC NFC Status Register
	// Position of SMCSTS field.
	EBI_SR_SMCSTS_Pos = 0x0
	// Bit mask of SMCSTS field.
	EBI_SR_SMCSTS_Msk = 0x1
	// Bit SMCSTS.
	EBI_SR_SMCSTS = 0x1
	// Position of RB_RISE field.
	EBI_SR_RB_RISE_Pos = 0x4
	// Bit mask of RB_RISE field.
	EBI_SR_RB_RISE_Msk = 0x10
	// Bit RB_RISE.
	EBI_SR_RB_RISE = 0x10
	// Position of RB_FALL field.
	EBI_SR_RB_FALL_Pos = 0x5
	// Bit mask of RB_FALL field.
	EBI_SR_RB_FALL_Msk = 0x20
	// Bit RB_FALL.
	EBI_SR_RB_FALL = 0x20
	// Position of NFCBUSY field.
	EBI_SR_NFCBUSY_Pos = 0x8
	// Bit mask of NFCBUSY field.
	EBI_SR_NFCBUSY_Msk = 0x100
	// Bit NFCBUSY.
	EBI_SR_NFCBUSY = 0x100
	// Position of NFCWR field.
	EBI_SR_NFCWR_Pos = 0xb
	// Bit mask of NFCWR field.
	EBI_SR_NFCWR_Msk = 0x800
	// Bit NFCWR.
	EBI_SR_NFCWR = 0x800
	// Position of NFCSID field.
	EBI_SR_NFCSID_Pos = 0xc
	// Bit mask of NFCSID field.
	EBI_SR_NFCSID_Msk = 0x7000
	// Position of XFRDONE field.
	EBI_SR_XFRDONE_Pos = 0x10
	// Bit mask of XFRDONE field.
	EBI_SR_XFRDONE_Msk = 0x10000
	// Bit XFRDONE.
	EBI_SR_XFRDONE = 0x10000
	// Position of CMDDONE field.
	EBI_SR_CMDDONE_Pos = 0x11
	// Bit mask of CMDDONE field.
	EBI_SR_CMDDONE_Msk = 0x20000
	// Bit CMDDONE.
	EBI_SR_CMDDONE = 0x20000
	// Position of DTOE field.
	EBI_SR_DTOE_Pos = 0x14
	// Bit mask of DTOE field.
	EBI_SR_DTOE_Msk = 0x100000
	// Bit DTOE.
	EBI_SR_DTOE = 0x100000
	// Position of UNDEF field.
	EBI_SR_UNDEF_Pos = 0x15
	// Bit mask of UNDEF field.
	EBI_SR_UNDEF_Msk = 0x200000
	// Bit UNDEF.
	EBI_SR_UNDEF = 0x200000
	// Position of AWB field.
	EBI_SR_AWB_Pos = 0x16
	// Bit mask of AWB field.
	EBI_SR_AWB_Msk = 0x400000
	// Bit AWB.
	EBI_SR_AWB = 0x400000
	// Position of NFCASE field.
	EBI_SR_NFCASE_Pos = 0x17
	// Bit mask of NFCASE field.
	EBI_SR_NFCASE_Msk = 0x800000
	// Bit NFCASE.
	EBI_SR_NFCASE = 0x800000
	// Position of RB_EDGE0 field.
	EBI_SR_RB_EDGE0_Pos = 0x18
	// Bit mask of RB_EDGE0 field.
	EBI_SR_RB_EDGE0_Msk = 0x1000000
	// Bit RB_EDGE0.
	EBI_SR_RB_EDGE0 = 0x1000000

	// IER: SMC NFC Interrupt Enable Register
	// Position of RB_RISE field.
	EBI_IER_RB_RISE_Pos = 0x4
	// Bit mask of RB_RISE field.
	EBI_IER_RB_RISE_Msk = 0x10
	// Bit RB_RISE.
	EBI_IER_RB_RISE = 0x10
	// Position of RB_FALL field.
	EBI_IER_RB_FALL_Pos = 0x5
	// Bit mask of RB_FALL field.
	EBI_IER_RB_FALL_Msk = 0x20
	// Bit RB_FALL.
	EBI_IER_RB_FALL = 0x20
	// Position of XFRDONE field.
	EBI_IER_XFRDONE_Pos = 0x10
	// Bit mask of XFRDONE field.
	EBI_IER_XFRDONE_Msk = 0x10000
	// Bit XFRDONE.
	EBI_IER_XFRDONE = 0x10000
	// Position of CMDDONE field.
	EBI_IER_CMDDONE_Pos = 0x11
	// Bit mask of CMDDONE field.
	EBI_IER_CMDDONE_Msk = 0x20000
	// Bit CMDDONE.
	EBI_IER_CMDDONE = 0x20000
	// Position of DTOE field.
	EBI_IER_DTOE_Pos = 0x14
	// Bit mask of DTOE field.
	EBI_IER_DTOE_Msk = 0x100000
	// Bit DTOE.
	EBI_IER_DTOE = 0x100000
	// Position of UNDEF field.
	EBI_IER_UNDEF_Pos = 0x15
	// Bit mask of UNDEF field.
	EBI_IER_UNDEF_Msk = 0x200000
	// Bit UNDEF.
	EBI_IER_UNDEF = 0x200000
	// Position of AWB field.
	EBI_IER_AWB_Pos = 0x16
	// Bit mask of AWB field.
	EBI_IER_AWB_Msk = 0x400000
	// Bit AWB.
	EBI_IER_AWB = 0x400000
	// Position of NFCASE field.
	EBI_IER_NFCASE_Pos = 0x17
	// Bit mask of NFCASE field.
	EBI_IER_NFCASE_Msk = 0x800000
	// Bit NFCASE.
	EBI_IER_NFCASE = 0x800000
	// Position of RB_EDGE0 field.
	EBI_IER_RB_EDGE0_Pos = 0x18
	// Bit mask of RB_EDGE0 field.
	EBI_IER_RB_EDGE0_Msk = 0x1000000
	// Bit RB_EDGE0.
	EBI_IER_RB_EDGE0 = 0x1000000

	// IDR: SMC NFC Interrupt Disable Register
	// Position of RB_RISE field.
	EBI_IDR_RB_RISE_Pos = 0x4
	// Bit mask of RB_RISE field.
	EBI_IDR_RB_RISE_Msk = 0x10
	// Bit RB_RISE.
	EBI_IDR_RB_RISE = 0x10
	// Position of RB_FALL field.
	EBI_IDR_RB_FALL_Pos = 0x5
	// Bit mask of RB_FALL field.
	EBI_IDR_RB_FALL_Msk = 0x20
	// Bit RB_FALL.
	EBI_IDR_RB_FALL = 0x20
	// Position of XFRDONE field.
	EBI_IDR_XFRDONE_Pos = 0x10
	// Bit mask of XFRDONE field.
	EBI_IDR_XFRDONE_Msk = 0x10000
	// Bit XFRDONE.
	EBI_IDR_XFRDONE = 0x10000
	// Position of CMDDONE field.
	EBI_IDR_CMDDONE_Pos = 0x11
	// Bit mask of CMDDONE field.
	EBI_IDR_CMDDONE_Msk = 0x20000
	// Bit CMDDONE.
	EBI_IDR_CMDDONE = 0x20000
	// Position of DTOE field.
	EBI_IDR_DTOE_Pos = 0x14
	// Bit mask of DTOE field.
	EBI_IDR_DTOE_Msk = 0x100000
	// Bit DTOE.
	EBI_IDR_DTOE = 0x100000
	// Position of UNDEF field.
	EBI_IDR_UNDEF_Pos = 0x15
	// Bit mask of UNDEF field.
	EBI_IDR_UNDEF_Msk = 0x200000
	// Bit UNDEF.
	EBI_IDR_UNDEF = 0x200000
	// Position of AWB field.
	EBI_IDR_AWB_Pos = 0x16
	// Bit mask of AWB field.
	EBI_IDR_AWB_Msk = 0x400000
	// Bit AWB.
	EBI_IDR_AWB = 0x400000
	// Position of NFCASE field.
	EBI_IDR_NFCASE_Pos = 0x17
	// Bit mask of NFCASE field.
	EBI_IDR_NFCASE_Msk = 0x800000
	// Bit NFCASE.
	EBI_IDR_NFCASE = 0x800000
	// Position of RB_EDGE0 field.
	EBI_IDR_RB_EDGE0_Pos = 0x18
	// Bit mask of RB_EDGE0 field.
	EBI_IDR_RB_EDGE0_Msk = 0x1000000
	// Bit RB_EDGE0.
	EBI_IDR_RB_EDGE0 = 0x1000000

	// IMR: SMC NFC Interrupt Mask Register
	// Position of RB_RISE field.
	EBI_IMR_RB_RISE_Pos = 0x4
	// Bit mask of RB_RISE field.
	EBI_IMR_RB_RISE_Msk = 0x10
	// Bit RB_RISE.
	EBI_IMR_RB_RISE = 0x10
	// Position of RB_FALL field.
	EBI_IMR_RB_FALL_Pos = 0x5
	// Bit mask of RB_FALL field.
	EBI_IMR_RB_FALL_Msk = 0x20
	// Bit RB_FALL.
	EBI_IMR_RB_FALL = 0x20
	// Position of XFRDONE field.
	EBI_IMR_XFRDONE_Pos = 0x10
	// Bit mask of XFRDONE field.
	EBI_IMR_XFRDONE_Msk = 0x10000
	// Bit XFRDONE.
	EBI_IMR_XFRDONE = 0x10000
	// Position of CMDDONE field.
	EBI_IMR_CMDDONE_Pos = 0x11
	// Bit mask of CMDDONE field.
	EBI_IMR_CMDDONE_Msk = 0x20000
	// Bit CMDDONE.
	EBI_IMR_CMDDONE = 0x20000
	// Position of DTOE field.
	EBI_IMR_DTOE_Pos = 0x14
	// Bit mask of DTOE field.
	EBI_IMR_DTOE_Msk = 0x100000
	// Bit DTOE.
	EBI_IMR_DTOE = 0x100000
	// Position of UNDEF field.
	EBI_IMR_UNDEF_Pos = 0x15
	// Bit mask of UNDEF field.
	EBI_IMR_UNDEF_Msk = 0x200000
	// Bit UNDEF.
	EBI_IMR_UNDEF = 0x200000
	// Position of AWB field.
	EBI_IMR_AWB_Pos = 0x16
	// Bit mask of AWB field.
	EBI_IMR_AWB_Msk = 0x400000
	// Bit AWB.
	EBI_IMR_AWB = 0x400000
	// Position of NFCASE field.
	EBI_IMR_NFCASE_Pos = 0x17
	// Bit mask of NFCASE field.
	EBI_IMR_NFCASE_Msk = 0x800000
	// Bit NFCASE.
	EBI_IMR_NFCASE = 0x800000
	// Position of RB_EDGE0 field.
	EBI_IMR_RB_EDGE0_Pos = 0x18
	// Bit mask of RB_EDGE0 field.
	EBI_IMR_RB_EDGE0_Msk = 0x1000000
	// Bit RB_EDGE0.
	EBI_IMR_RB_EDGE0 = 0x1000000

	// ADDR: SMC NFC Address Cycle Zero Register
	// Position of ADDR_CYCLE0 field.
	EBI_ADDR_ADDR_CYCLE0_Pos = 0x0
	// Bit mask of ADDR_CYCLE0 field.
	EBI_ADDR_ADDR_CYCLE0_Msk = 0xff

	// BANK: SMC Bank Address Register
	// Position of BANK field.
	EBI_BANK_BANK_Pos = 0x0
	// Bit mask of BANK field.
	EBI_BANK_BANK_Msk = 0x7

	// ECC_CTRL: SMC ECC Control Register
	// Position of RST field.
	EBI_ECC_CTRL_RST_Pos = 0x0
	// Bit mask of RST field.
	EBI_ECC_CTRL_RST_Msk = 0x1
	// Bit RST.
	EBI_ECC_CTRL_RST = 0x1
	// Position of SWRST field.
	EBI_ECC_CTRL_SWRST_Pos = 0x1
	// Bit mask of SWRST field.
	EBI_ECC_CTRL_SWRST_Msk = 0x2
	// Bit SWRST.
	EBI_ECC_CTRL_SWRST = 0x2

	// ECC_MD: SMC ECC Mode Register
	// Position of ECC_PAGESIZE field.
	EBI_ECC_MD_ECC_PAGESIZE_Pos = 0x0
	// Bit mask of ECC_PAGESIZE field.
	EBI_ECC_MD_ECC_PAGESIZE_Msk = 0x3
	// Main area 512 Bytes + Spare area 16 Bytes = 528 Bytes
	EBI_ECC_MD_ECC_PAGESIZE_PS512_16 = 0x0
	// Main area 1024 Bytes + Spare area 32 Bytes = 1056 Bytes
	EBI_ECC_MD_ECC_PAGESIZE_PS1024_32 = 0x1
	// Main area 2048 Bytes + Spare area 64 Bytes = 2112 Bytes
	EBI_ECC_MD_ECC_PAGESIZE_PS2048_64 = 0x2
	// Main area 4096 Bytes + Spare area 128 Bytes = 4224 Bytes
	EBI_ECC_MD_ECC_PAGESIZE_PS4096_128 = 0x3
	// Position of TYPCORREC field.
	EBI_ECC_MD_TYPCORREC_Pos = 0x4
	// Bit mask of TYPCORREC field.
	EBI_ECC_MD_TYPCORREC_Msk = 0x30
	// 1 bit correction for a page of 512/1024/2048/4096 Bytes (for 8 or 16-bit NAND Flash)
	EBI_ECC_MD_TYPCORREC_CPAGE = 0x0
	// 1 bit correction for 256 Bytes of data for a page of 512/2048/4096 bytes (for 8-bit NAND Flash only)
	EBI_ECC_MD_TYPCORREC_C256B = 0x1
	// 1 bit correction for 512 Bytes of data for a page of 512/2048/4096 bytes (for 8-bit NAND Flash only)
	EBI_ECC_MD_TYPCORREC_C512B = 0x2

	// ECC_SR1: SMC ECC Status 1 Register
	// Position of RECERR0 field.
	EBI_ECC_SR1_RECERR0_Pos = 0x0
	// Bit mask of RECERR0 field.
	EBI_ECC_SR1_RECERR0_Msk = 0x1
	// Bit RECERR0.
	EBI_ECC_SR1_RECERR0 = 0x1
	// Position of ECCERR0 field.
	EBI_ECC_SR1_ECCERR0_Pos = 0x1
	// Bit mask of ECCERR0 field.
	EBI_ECC_SR1_ECCERR0_Msk = 0x6
	// Position of RECERR1 field.
	EBI_ECC_SR1_RECERR1_Pos = 0x4
	// Bit mask of RECERR1 field.
	EBI_ECC_SR1_RECERR1_Msk = 0x10
	// Bit RECERR1.
	EBI_ECC_SR1_RECERR1 = 0x10
	// Position of ECCERR1 field.
	EBI_ECC_SR1_ECCERR1_Pos = 0x5
	// Bit mask of ECCERR1 field.
	EBI_ECC_SR1_ECCERR1_Msk = 0x20
	// Bit ECCERR1.
	EBI_ECC_SR1_ECCERR1 = 0x20
	// Position of MULERR1 field.
	EBI_ECC_SR1_MULERR1_Pos = 0x6
	// Bit mask of MULERR1 field.
	EBI_ECC_SR1_MULERR1_Msk = 0x40
	// Bit MULERR1.
	EBI_ECC_SR1_MULERR1 = 0x40
	// Position of RECERR2 field.
	EBI_ECC_SR1_RECERR2_Pos = 0x8
	// Bit mask of RECERR2 field.
	EBI_ECC_SR1_RECERR2_Msk = 0x100
	// Bit RECERR2.
	EBI_ECC_SR1_RECERR2 = 0x100
	// Position of ECCERR2 field.
	EBI_ECC_SR1_ECCERR2_Pos = 0x9
	// Bit mask of ECCERR2 field.
	EBI_ECC_SR1_ECCERR2_Msk = 0x200
	// Bit ECCERR2.
	EBI_ECC_SR1_ECCERR2 = 0x200
	// Position of MULERR2 field.
	EBI_ECC_SR1_MULERR2_Pos = 0xa
	// Bit mask of MULERR2 field.
	EBI_ECC_SR1_MULERR2_Msk = 0x400
	// Bit MULERR2.
	EBI_ECC_SR1_MULERR2 = 0x400
	// Position of RECERR3 field.
	EBI_ECC_SR1_RECERR3_Pos = 0xc
	// Bit mask of RECERR3 field.
	EBI_ECC_SR1_RECERR3_Msk = 0x1000
	// Bit RECERR3.
	EBI_ECC_SR1_RECERR3 = 0x1000
	// Position of ECCERR3 field.
	EBI_ECC_SR1_ECCERR3_Pos = 0xd
	// Bit mask of ECCERR3 field.
	EBI_ECC_SR1_ECCERR3_Msk = 0x2000
	// Bit ECCERR3.
	EBI_ECC_SR1_ECCERR3 = 0x2000
	// Position of MULERR3 field.
	EBI_ECC_SR1_MULERR3_Pos = 0xe
	// Bit mask of MULERR3 field.
	EBI_ECC_SR1_MULERR3_Msk = 0x4000
	// Bit MULERR3.
	EBI_ECC_SR1_MULERR3 = 0x4000
	// Position of RECERR4 field.
	EBI_ECC_SR1_RECERR4_Pos = 0x10
	// Bit mask of RECERR4 field.
	EBI_ECC_SR1_RECERR4_Msk = 0x10000
	// Bit RECERR4.
	EBI_ECC_SR1_RECERR4 = 0x10000
	// Position of ECCERR4 field.
	EBI_ECC_SR1_ECCERR4_Pos = 0x11
	// Bit mask of ECCERR4 field.
	EBI_ECC_SR1_ECCERR4_Msk = 0x60000
	// Position of RECERR5 field.
	EBI_ECC_SR1_RECERR5_Pos = 0x14
	// Bit mask of RECERR5 field.
	EBI_ECC_SR1_RECERR5_Msk = 0x100000
	// Bit RECERR5.
	EBI_ECC_SR1_RECERR5 = 0x100000
	// Position of ECCERR5 field.
	EBI_ECC_SR1_ECCERR5_Pos = 0x15
	// Bit mask of ECCERR5 field.
	EBI_ECC_SR1_ECCERR5_Msk = 0x600000
	// Position of RECERR6 field.
	EBI_ECC_SR1_RECERR6_Pos = 0x18
	// Bit mask of RECERR6 field.
	EBI_ECC_SR1_RECERR6_Msk = 0x1000000
	// Bit RECERR6.
	EBI_ECC_SR1_RECERR6 = 0x1000000
	// Position of ECCERR6 field.
	EBI_ECC_SR1_ECCERR6_Pos = 0x19
	// Bit mask of ECCERR6 field.
	EBI_ECC_SR1_ECCERR6_Msk = 0x6000000
	// Position of RECERR7 field.
	EBI_ECC_SR1_RECERR7_Pos = 0x1c
	// Bit mask of RECERR7 field.
	EBI_ECC_SR1_RECERR7_Msk = 0x10000000
	// Bit RECERR7.
	EBI_ECC_SR1_RECERR7 = 0x10000000
	// Position of ECCERR7 field.
	EBI_ECC_SR1_ECCERR7_Pos = 0x1d
	// Bit mask of ECCERR7 field.
	EBI_ECC_SR1_ECCERR7_Msk = 0x60000000

	// ECC_PR0: SMC ECC Parity 0 Register
	// Position of BITADDR field.
	EBI_ECC_PR0_BITADDR_Pos = 0x0
	// Bit mask of BITADDR field.
	EBI_ECC_PR0_BITADDR_Msk = 0xf
	// Position of WORDADDR field.
	EBI_ECC_PR0_WORDADDR_Pos = 0x4
	// Bit mask of WORDADDR field.
	EBI_ECC_PR0_WORDADDR_Msk = 0xfff0

	// ECC_PR0_W9BIT: SMC ECC Parity 0 Register
	// Position of BITADDR field.
	EBI_ECC_PR0_W9BIT_BITADDR_Pos = 0x0
	// Bit mask of BITADDR field.
	EBI_ECC_PR0_W9BIT_BITADDR_Msk = 0x7
	// Position of WORDADDR field.
	EBI_ECC_PR0_W9BIT_WORDADDR_Pos = 0x3
	// Bit mask of WORDADDR field.
	EBI_ECC_PR0_W9BIT_WORDADDR_Msk = 0xff8
	// Position of NPARITY field.
	EBI_ECC_PR0_W9BIT_NPARITY_Pos = 0xc
	// Bit mask of NPARITY field.
	EBI_ECC_PR0_W9BIT_NPARITY_Msk = 0xfff000

	// ECC_PR0_W8BIT: SMC ECC Parity 0 Register
	// Position of BITADDR field.
	EBI_ECC_PR0_W8BIT_BITADDR_Pos = 0x0
	// Bit mask of BITADDR field.
	EBI_ECC_PR0_W8BIT_BITADDR_Msk = 0x7
	// Position of WORDADDR field.
	EBI_ECC_PR0_W8BIT_WORDADDR_Pos = 0x3
	// Bit mask of WORDADDR field.
	EBI_ECC_PR0_W8BIT_WORDADDR_Msk = 0x7f8
	// Position of NPARITY field.
	EBI_ECC_PR0_W8BIT_NPARITY_Pos = 0xc
	// Bit mask of NPARITY field.
	EBI_ECC_PR0_W8BIT_NPARITY_Msk = 0x7ff000

	// ECC_PR1: SMC ECC parity 1 Register
	// Position of NPARITY field.
	EBI_ECC_PR1_NPARITY_Pos = 0x0
	// Bit mask of NPARITY field.
	EBI_ECC_PR1_NPARITY_Msk = 0xffff

	// ECC_PR1_W9BIT: SMC ECC parity 1 Register
	// Position of BITADDR field.
	EBI_ECC_PR1_W9BIT_BITADDR_Pos = 0x0
	// Bit mask of BITADDR field.
	EBI_ECC_PR1_W9BIT_BITADDR_Msk = 0x7
	// Position of WORDADDR field.
	EBI_ECC_PR1_W9BIT_WORDADDR_Pos = 0x3
	// Bit mask of WORDADDR field.
	EBI_ECC_PR1_W9BIT_WORDADDR_Msk = 0xff8
	// Position of NPARITY field.
	EBI_ECC_PR1_W9BIT_NPARITY_Pos = 0xc
	// Bit mask of NPARITY field.
	EBI_ECC_PR1_W9BIT_NPARITY_Msk = 0xfff000

	// ECC_PR1_W8BIT: SMC ECC parity 1 Register
	// Position of BITADDR field.
	EBI_ECC_PR1_W8BIT_BITADDR_Pos = 0x0
	// Bit mask of BITADDR field.
	EBI_ECC_PR1_W8BIT_BITADDR_Msk = 0x7
	// Position of WORDADDR field.
	EBI_ECC_PR1_W8BIT_WORDADDR_Pos = 0x3
	// Bit mask of WORDADDR field.
	EBI_ECC_PR1_W8BIT_WORDADDR_Msk = 0x7f8
	// Position of NPARITY field.
	EBI_ECC_PR1_W8BIT_NPARITY_Pos = 0xc
	// Bit mask of NPARITY field.
	EBI_ECC_PR1_W8BIT_NPARITY_Msk = 0x7ff000

	// ECC_SR2: SMC ECC status 2 Register
	// Position of RECERR8 field.
	EBI_ECC_SR2_RECERR8_Pos = 0x0
	// Bit mask of RECERR8 field.
	EBI_ECC_SR2_RECERR8_Msk = 0x1
	// Bit RECERR8.
	EBI_ECC_SR2_RECERR8 = 0x1
	// Position of ECCERR8 field.
	EBI_ECC_SR2_ECCERR8_Pos = 0x1
	// Bit mask of ECCERR8 field.
	EBI_ECC_SR2_ECCERR8_Msk = 0x6
	// Position of RECERR9 field.
	EBI_ECC_SR2_RECERR9_Pos = 0x4
	// Bit mask of RECERR9 field.
	EBI_ECC_SR2_RECERR9_Msk = 0x10
	// Bit RECERR9.
	EBI_ECC_SR2_RECERR9 = 0x10
	// Position of ECCERR9 field.
	EBI_ECC_SR2_ECCERR9_Pos = 0x5
	// Bit mask of ECCERR9 field.
	EBI_ECC_SR2_ECCERR9_Msk = 0x20
	// Bit ECCERR9.
	EBI_ECC_SR2_ECCERR9 = 0x20
	// Position of MULERR9 field.
	EBI_ECC_SR2_MULERR9_Pos = 0x6
	// Bit mask of MULERR9 field.
	EBI_ECC_SR2_MULERR9_Msk = 0x40
	// Bit MULERR9.
	EBI_ECC_SR2_MULERR9 = 0x40
	// Position of RECERR10 field.
	EBI_ECC_SR2_RECERR10_Pos = 0x8
	// Bit mask of RECERR10 field.
	EBI_ECC_SR2_RECERR10_Msk = 0x100
	// Bit RECERR10.
	EBI_ECC_SR2_RECERR10 = 0x100
	// Position of ECCERR10 field.
	EBI_ECC_SR2_ECCERR10_Pos = 0x9
	// Bit mask of ECCERR10 field.
	EBI_ECC_SR2_ECCERR10_Msk = 0x200
	// Bit ECCERR10.
	EBI_ECC_SR2_ECCERR10 = 0x200
	// Position of MULERR10 field.
	EBI_ECC_SR2_MULERR10_Pos = 0xa
	// Bit mask of MULERR10 field.
	EBI_ECC_SR2_MULERR10_Msk = 0x400
	// Bit MULERR10.
	EBI_ECC_SR2_MULERR10 = 0x400
	// Position of RECERR11 field.
	EBI_ECC_SR2_RECERR11_Pos = 0xc
	// Bit mask of RECERR11 field.
	EBI_ECC_SR2_RECERR11_Msk = 0x1000
	// Bit RECERR11.
	EBI_ECC_SR2_RECERR11 = 0x1000
	// Position of ECCERR11 field.
	EBI_ECC_SR2_ECCERR11_Pos = 0xd
	// Bit mask of ECCERR11 field.
	EBI_ECC_SR2_ECCERR11_Msk = 0x2000
	// Bit ECCERR11.
	EBI_ECC_SR2_ECCERR11 = 0x2000
	// Position of MULERR11 field.
	EBI_ECC_SR2_MULERR11_Pos = 0xe
	// Bit mask of MULERR11 field.
	EBI_ECC_SR2_MULERR11_Msk = 0x4000
	// Bit MULERR11.
	EBI_ECC_SR2_MULERR11 = 0x4000
	// Position of RECERR12 field.
	EBI_ECC_SR2_RECERR12_Pos = 0x10
	// Bit mask of RECERR12 field.
	EBI_ECC_SR2_RECERR12_Msk = 0x10000
	// Bit RECERR12.
	EBI_ECC_SR2_RECERR12 = 0x10000
	// Position of ECCERR12 field.
	EBI_ECC_SR2_ECCERR12_Pos = 0x11
	// Bit mask of ECCERR12 field.
	EBI_ECC_SR2_ECCERR12_Msk = 0x60000
	// Position of RECERR13 field.
	EBI_ECC_SR2_RECERR13_Pos = 0x14
	// Bit mask of RECERR13 field.
	EBI_ECC_SR2_RECERR13_Msk = 0x100000
	// Bit RECERR13.
	EBI_ECC_SR2_RECERR13 = 0x100000
	// Position of ECCERR13 field.
	EBI_ECC_SR2_ECCERR13_Pos = 0x15
	// Bit mask of ECCERR13 field.
	EBI_ECC_SR2_ECCERR13_Msk = 0x600000
	// Position of RECERR14 field.
	EBI_ECC_SR2_RECERR14_Pos = 0x18
	// Bit mask of RECERR14 field.
	EBI_ECC_SR2_RECERR14_Msk = 0x1000000
	// Bit RECERR14.
	EBI_ECC_SR2_RECERR14 = 0x1000000
	// Position of ECCERR14 field.
	EBI_ECC_SR2_ECCERR14_Pos = 0x19
	// Bit mask of ECCERR14 field.
	EBI_ECC_SR2_ECCERR14_Msk = 0x6000000
	// Position of RECERR15 field.
	EBI_ECC_SR2_RECERR15_Pos = 0x1c
	// Bit mask of RECERR15 field.
	EBI_ECC_SR2_RECERR15_Msk = 0x10000000
	// Bit RECERR15.
	EBI_ECC_SR2_RECERR15 = 0x10000000
	// Position of ECCERR15 field.
	EBI_ECC_SR2_ECCERR15_Pos = 0x1d
	// Bit mask of ECCERR15 field.
	EBI_ECC_SR2_ECCERR15_Msk = 0x60000000

	// ECC_PR2: SMC ECC parity 2 Register
	// Position of BITADDR field.
	EBI_ECC_PR2_BITADDR_Pos = 0x0
	// Bit mask of BITADDR field.
	EBI_ECC_PR2_BITADDR_Msk = 0x7
	// Position of WORDADDR field.
	EBI_ECC_PR2_WORDADDR_Pos = 0x3
	// Bit mask of WORDADDR field.
	EBI_ECC_PR2_WORDADDR_Msk = 0xff8
	// Position of NPARITY field.
	EBI_ECC_PR2_NPARITY_Pos = 0xc
	// Bit mask of NPARITY field.
	EBI_ECC_PR2_NPARITY_Msk = 0xfff000

	// ECC_PR2_W8BIT: SMC ECC parity 2 Register
	// Position of BITADDR field.
	EBI_ECC_PR2_W8BIT_BITADDR_Pos = 0x0
	// Bit mask of BITADDR field.
	EBI_ECC_PR2_W8BIT_BITADDR_Msk = 0x7
	// Position of WORDADDR field.
	EBI_ECC_PR2_W8BIT_WORDADDR_Pos = 0x3
	// Bit mask of WORDADDR field.
	EBI_ECC_PR2_W8BIT_WORDADDR_Msk = 0x7f8
	// Position of NPARITY field.
	EBI_ECC_PR2_W8BIT_NPARITY_Pos = 0xc
	// Bit mask of NPARITY field.
	EBI_ECC_PR2_W8BIT_NPARITY_Msk = 0x7ff000

	// ECC_PR3: SMC ECC parity 3 Register
	// Position of BITADDR field.
	EBI_ECC_PR3_BITADDR_Pos = 0x0
	// Bit mask of BITADDR field.
	EBI_ECC_PR3_BITADDR_Msk = 0x7
	// Position of WORDADDR field.
	EBI_ECC_PR3_WORDADDR_Pos = 0x3
	// Bit mask of WORDADDR field.
	EBI_ECC_PR3_WORDADDR_Msk = 0xff8
	// Position of NPARITY field.
	EBI_ECC_PR3_NPARITY_Pos = 0xc
	// Bit mask of NPARITY field.
	EBI_ECC_PR3_NPARITY_Msk = 0xfff000

	// ECC_PR3_W8BIT: SMC ECC parity 3 Register
	// Position of BITADDR field.
	EBI_ECC_PR3_W8BIT_BITADDR_Pos = 0x0
	// Bit mask of BITADDR field.
	EBI_ECC_PR3_W8BIT_BITADDR_Msk = 0x7
	// Position of WORDADDR field.
	EBI_ECC_PR3_W8BIT_WORDADDR_Pos = 0x3
	// Bit mask of WORDADDR field.
	EBI_ECC_PR3_W8BIT_WORDADDR_Msk = 0x7f8
	// Position of NPARITY field.
	EBI_ECC_PR3_W8BIT_NPARITY_Pos = 0xc
	// Bit mask of NPARITY field.
	EBI_ECC_PR3_W8BIT_NPARITY_Msk = 0x7ff000

	// ECC_PR4: SMC ECC parity 4 Register
	// Position of BITADDR field.
	EBI_ECC_PR4_BITADDR_Pos = 0x0
	// Bit mask of BITADDR field.
	EBI_ECC_PR4_BITADDR_Msk = 0x7
	// Position of WORDADDR field.
	EBI_ECC_PR4_WORDADDR_Pos = 0x3
	// Bit mask of WORDADDR field.
	EBI_ECC_PR4_WORDADDR_Msk = 0xff8
	// Position of NPARITY field.
	EBI_ECC_PR4_NPARITY_Pos = 0xc
	// Bit mask of NPARITY field.
	EBI_ECC_PR4_NPARITY_Msk = 0xfff000

	// ECC_PR4_W8BIT: SMC ECC parity 4 Register
	// Position of BITADDR field.
	EBI_ECC_PR4_W8BIT_BITADDR_Pos = 0x0
	// Bit mask of BITADDR field.
	EBI_ECC_PR4_W8BIT_BITADDR_Msk = 0x7
	// Position of WORDADDR field.
	EBI_ECC_PR4_W8BIT_WORDADDR_Pos = 0x3
	// Bit mask of WORDADDR field.
	EBI_ECC_PR4_W8BIT_WORDADDR_Msk = 0x7f8
	// Position of NPARITY field.
	EBI_ECC_PR4_W8BIT_NPARITY_Pos = 0xc
	// Bit mask of NPARITY field.
	EBI_ECC_PR4_W8BIT_NPARITY_Msk = 0x7ff000

	// ECC_PR5: SMC ECC parity 5 Register
	// Position of BITADDR field.
	EBI_ECC_PR5_BITADDR_Pos = 0x0
	// Bit mask of BITADDR field.
	EBI_ECC_PR5_BITADDR_Msk = 0x7
	// Position of WORDADDR field.
	EBI_ECC_PR5_WORDADDR_Pos = 0x3
	// Bit mask of WORDADDR field.
	EBI_ECC_PR5_WORDADDR_Msk = 0xff8
	// Position of NPARITY field.
	EBI_ECC_PR5_NPARITY_Pos = 0xc
	// Bit mask of NPARITY field.
	EBI_ECC_PR5_NPARITY_Msk = 0xfff000

	// ECC_PR5_W8BIT: SMC ECC parity 5 Register
	// Position of BITADDR field.
	EBI_ECC_PR5_W8BIT_BITADDR_Pos = 0x0
	// Bit mask of BITADDR field.
	EBI_ECC_PR5_W8BIT_BITADDR_Msk = 0x7
	// Position of WORDADDR field.
	EBI_ECC_PR5_W8BIT_WORDADDR_Pos = 0x3
	// Bit mask of WORDADDR field.
	EBI_ECC_PR5_W8BIT_WORDADDR_Msk = 0x7f8
	// Position of NPARITY field.
	EBI_ECC_PR5_W8BIT_NPARITY_Pos = 0xc
	// Bit mask of NPARITY field.
	EBI_ECC_PR5_W8BIT_NPARITY_Msk = 0x7ff000

	// ECC_PR6: SMC ECC parity 6 Register
	// Position of BITADDR field.
	EBI_ECC_PR6_BITADDR_Pos = 0x0
	// Bit mask of BITADDR field.
	EBI_ECC_PR6_BITADDR_Msk = 0x7
	// Position of WORDADDR field.
	EBI_ECC_PR6_WORDADDR_Pos = 0x3
	// Bit mask of WORDADDR field.
	EBI_ECC_PR6_WORDADDR_Msk = 0xff8
	// Position of NPARITY field.
	EBI_ECC_PR6_NPARITY_Pos = 0xc
	// Bit mask of NPARITY field.
	EBI_ECC_PR6_NPARITY_Msk = 0xfff000

	// ECC_PR6_W8BIT: SMC ECC parity 6 Register
	// Position of BITADDR field.
	EBI_ECC_PR6_W8BIT_BITADDR_Pos = 0x0
	// Bit mask of BITADDR field.
	EBI_ECC_PR6_W8BIT_BITADDR_Msk = 0x7
	// Position of WORDADDR field.
	EBI_ECC_PR6_W8BIT_WORDADDR_Pos = 0x3
	// Bit mask of WORDADDR field.
	EBI_ECC_PR6_W8BIT_WORDADDR_Msk = 0x7f8
	// Position of NPARITY field.
	EBI_ECC_PR6_W8BIT_NPARITY_Pos = 0xc
	// Bit mask of NPARITY field.
	EBI_ECC_PR6_W8BIT_NPARITY_Msk = 0x7ff000

	// ECC_PR7: SMC ECC parity 7 Register
	// Position of BITADDR field.
	EBI_ECC_PR7_BITADDR_Pos = 0x0
	// Bit mask of BITADDR field.
	EBI_ECC_PR7_BITADDR_Msk = 0x7
	// Position of WORDADDR field.
	EBI_ECC_PR7_WORDADDR_Pos = 0x3
	// Bit mask of WORDADDR field.
	EBI_ECC_PR7_WORDADDR_Msk = 0xff8
	// Position of NPARITY field.
	EBI_ECC_PR7_NPARITY_Pos = 0xc
	// Bit mask of NPARITY field.
	EBI_ECC_PR7_NPARITY_Msk = 0xfff000

	// ECC_PR7_W8BIT: SMC ECC parity 7 Register
	// Position of BITADDR field.
	EBI_ECC_PR7_W8BIT_BITADDR_Pos = 0x0
	// Bit mask of BITADDR field.
	EBI_ECC_PR7_W8BIT_BITADDR_Msk = 0x7
	// Position of WORDADDR field.
	EBI_ECC_PR7_W8BIT_WORDADDR_Pos = 0x3
	// Bit mask of WORDADDR field.
	EBI_ECC_PR7_W8BIT_WORDADDR_Msk = 0x7f8
	// Position of NPARITY field.
	EBI_ECC_PR7_W8BIT_NPARITY_Pos = 0xc
	// Bit mask of NPARITY field.
	EBI_ECC_PR7_W8BIT_NPARITY_Msk = 0x7ff000

	// ECC_PR8: SMC ECC parity 8 Register
	// Position of BITADDR field.
	EBI_ECC_PR8_BITADDR_Pos = 0x0
	// Bit mask of BITADDR field.
	EBI_ECC_PR8_BITADDR_Msk = 0x7
	// Position of WORDADDR field.
	EBI_ECC_PR8_WORDADDR_Pos = 0x3
	// Bit mask of WORDADDR field.
	EBI_ECC_PR8_WORDADDR_Msk = 0x7f8
	// Position of NPARITY field.
	EBI_ECC_PR8_NPARITY_Pos = 0xc
	// Bit mask of NPARITY field.
	EBI_ECC_PR8_NPARITY_Msk = 0x7ff000

	// ECC_PR9: SMC ECC parity 9 Register
	// Position of BITADDR field.
	EBI_ECC_PR9_BITADDR_Pos = 0x0
	// Bit mask of BITADDR field.
	EBI_ECC_PR9_BITADDR_Msk = 0x7
	// Position of WORDADDR field.
	EBI_ECC_PR9_WORDADDR_Pos = 0x3
	// Bit mask of WORDADDR field.
	EBI_ECC_PR9_WORDADDR_Msk = 0x7f8
	// Position of NPARITY field.
	EBI_ECC_PR9_NPARITY_Pos = 0xc
	// Bit mask of NPARITY field.
	EBI_ECC_PR9_NPARITY_Msk = 0x7ff000

	// ECC_PR10: SMC ECC parity 10 Register
	// Position of BITADDR field.
	EBI_ECC_PR10_BITADDR_Pos = 0x0
	// Bit mask of BITADDR field.
	EBI_ECC_PR10_BITADDR_Msk = 0x7
	// Position of WORDADDR field.
	EBI_ECC_PR10_WORDADDR_Pos = 0x3
	// Bit mask of WORDADDR field.
	EBI_ECC_PR10_WORDADDR_Msk = 0x7f8
	// Position of NPARITY field.
	EBI_ECC_PR10_NPARITY_Pos = 0xc
	// Bit mask of NPARITY field.
	EBI_ECC_PR10_NPARITY_Msk = 0x7ff000

	// ECC_PR11: SMC ECC parity 11 Register
	// Position of BITADDR field.
	EBI_ECC_PR11_BITADDR_Pos = 0x0
	// Bit mask of BITADDR field.
	EBI_ECC_PR11_BITADDR_Msk = 0x7
	// Position of WORDADDR field.
	EBI_ECC_PR11_WORDADDR_Pos = 0x3
	// Bit mask of WORDADDR field.
	EBI_ECC_PR11_WORDADDR_Msk = 0x7f8
	// Position of NPARITY field.
	EBI_ECC_PR11_NPARITY_Pos = 0xc
	// Bit mask of NPARITY field.
	EBI_ECC_PR11_NPARITY_Msk = 0x7ff000

	// ECC_PR12: SMC ECC parity 12 Register
	// Position of BITADDR field.
	EBI_ECC_PR12_BITADDR_Pos = 0x0
	// Bit mask of BITADDR field.
	EBI_ECC_PR12_BITADDR_Msk = 0x7
	// Position of WORDADDR field.
	EBI_ECC_PR12_WORDADDR_Pos = 0x3
	// Bit mask of WORDADDR field.
	EBI_ECC_PR12_WORDADDR_Msk = 0x7f8
	// Position of NPARITY field.
	EBI_ECC_PR12_NPARITY_Pos = 0xc
	// Bit mask of NPARITY field.
	EBI_ECC_PR12_NPARITY_Msk = 0x7ff000

	// ECC_PR13: SMC ECC parity 13 Register
	// Position of BITADDR field.
	EBI_ECC_PR13_BITADDR_Pos = 0x0
	// Bit mask of BITADDR field.
	EBI_ECC_PR13_BITADDR_Msk = 0x7
	// Position of WORDADDR field.
	EBI_ECC_PR13_WORDADDR_Pos = 0x3
	// Bit mask of WORDADDR field.
	EBI_ECC_PR13_WORDADDR_Msk = 0x7f8
	// Position of NPARITY field.
	EBI_ECC_PR13_NPARITY_Pos = 0xc
	// Bit mask of NPARITY field.
	EBI_ECC_PR13_NPARITY_Msk = 0x7ff000

	// ECC_PR14: SMC ECC parity 14 Register
	// Position of BITADDR field.
	EBI_ECC_PR14_BITADDR_Pos = 0x0
	// Bit mask of BITADDR field.
	EBI_ECC_PR14_BITADDR_Msk = 0x7
	// Position of WORDADDR field.
	EBI_ECC_PR14_WORDADDR_Pos = 0x3
	// Bit mask of WORDADDR field.
	EBI_ECC_PR14_WORDADDR_Msk = 0x7f8
	// Position of NPARITY field.
	EBI_ECC_PR14_NPARITY_Pos = 0xc
	// Bit mask of NPARITY field.
	EBI_ECC_PR14_NPARITY_Msk = 0x7ff000

	// ECC_PR15: SMC ECC parity 15 Register
	// Position of BITADDR field.
	EBI_ECC_PR15_BITADDR_Pos = 0x0
	// Bit mask of BITADDR field.
	EBI_ECC_PR15_BITADDR_Msk = 0x7
	// Position of WORDADDR field.
	EBI_ECC_PR15_WORDADDR_Pos = 0x3
	// Bit mask of WORDADDR field.
	EBI_ECC_PR15_WORDADDR_Msk = 0x7f8
	// Position of NPARITY field.
	EBI_ECC_PR15_NPARITY_Pos = 0xc
	// Bit mask of NPARITY field.
	EBI_ECC_PR15_NPARITY_Msk = 0x7ff000

	// SETUP0: SMC Setup Register (CS_number = 0)
	// Position of NWE_SETUP field.
	EBI_SETUP0_NWE_SETUP_Pos = 0x0
	// Bit mask of NWE_SETUP field.
	EBI_SETUP0_NWE_SETUP_Msk = 0x3f
	// Position of NCS_WR_SETUP field.
	EBI_SETUP0_NCS_WR_SETUP_Pos = 0x8
	// Bit mask of NCS_WR_SETUP field.
	EBI_SETUP0_NCS_WR_SETUP_Msk = 0x3f00
	// Position of NRD_SETUP field.
	EBI_SETUP0_NRD_SETUP_Pos = 0x10
	// Bit mask of NRD_SETUP field.
	EBI_SETUP0_NRD_SETUP_Msk = 0x3f0000
	// Position of NCS_RD_SETUP field.
	EBI_SETUP0_NCS_RD_SETUP_Pos = 0x18
	// Bit mask of NCS_RD_SETUP field.
	EBI_SETUP0_NCS_RD_SETUP_Msk = 0x3f000000

	// PULSE0: SMC Pulse Register (CS_number = 0)
	// Position of NWE_PULSE field.
	EBI_PULSE0_NWE_PULSE_Pos = 0x0
	// Bit mask of NWE_PULSE field.
	EBI_PULSE0_NWE_PULSE_Msk = 0x3f
	// Position of NCS_WR_PULSE field.
	EBI_PULSE0_NCS_WR_PULSE_Pos = 0x8
	// Bit mask of NCS_WR_PULSE field.
	EBI_PULSE0_NCS_WR_PULSE_Msk = 0x3f00
	// Position of NRD_PULSE field.
	EBI_PULSE0_NRD_PULSE_Pos = 0x10
	// Bit mask of NRD_PULSE field.
	EBI_PULSE0_NRD_PULSE_Msk = 0x3f0000
	// Position of NCS_RD_PULSE field.
	EBI_PULSE0_NCS_RD_PULSE_Pos = 0x18
	// Bit mask of NCS_RD_PULSE field.
	EBI_PULSE0_NCS_RD_PULSE_Msk = 0x3f000000

	// CYCLE0: SMC Cycle Register (CS_number = 0)
	// Position of NWE_CYCLE field.
	EBI_CYCLE0_NWE_CYCLE_Pos = 0x0
	// Bit mask of NWE_CYCLE field.
	EBI_CYCLE0_NWE_CYCLE_Msk = 0x1ff
	// Position of NRD_CYCLE field.
	EBI_CYCLE0_NRD_CYCLE_Pos = 0x10
	// Bit mask of NRD_CYCLE field.
	EBI_CYCLE0_NRD_CYCLE_Msk = 0x1ff0000

	// TIMINGS0: SMC Timings Register (CS_number = 0)
	// Position of TCLR field.
	EBI_TIMINGS0_TCLR_Pos = 0x0
	// Bit mask of TCLR field.
	EBI_TIMINGS0_TCLR_Msk = 0xf
	// Position of TADL field.
	EBI_TIMINGS0_TADL_Pos = 0x4
	// Bit mask of TADL field.
	EBI_TIMINGS0_TADL_Msk = 0xf0
	// Position of TAR field.
	EBI_TIMINGS0_TAR_Pos = 0x8
	// Bit mask of TAR field.
	EBI_TIMINGS0_TAR_Msk = 0xf00
	// Position of OCMS field.
	EBI_TIMINGS0_OCMS_Pos = 0xc
	// Bit mask of OCMS field.
	EBI_TIMINGS0_OCMS_Msk = 0x1000
	// Bit OCMS.
	EBI_TIMINGS0_OCMS = 0x1000
	// Position of TRR field.
	EBI_TIMINGS0_TRR_Pos = 0x10
	// Bit mask of TRR field.
	EBI_TIMINGS0_TRR_Msk = 0xf0000
	// Position of TWB field.
	EBI_TIMINGS0_TWB_Pos = 0x18
	// Bit mask of TWB field.
	EBI_TIMINGS0_TWB_Msk = 0xf000000
	// Position of RBNSEL field.
	EBI_TIMINGS0_RBNSEL_Pos = 0x1c
	// Bit mask of RBNSEL field.
	EBI_TIMINGS0_RBNSEL_Msk = 0x70000000
	// Position of NFSEL field.
	EBI_TIMINGS0_NFSEL_Pos = 0x1f
	// Bit mask of NFSEL field.
	EBI_TIMINGS0_NFSEL_Msk = 0x80000000
	// Bit NFSEL.
	EBI_TIMINGS0_NFSEL = 0x80000000

	// MODE0: SMC Mode Register (CS_number = 0)
	// Position of READ_MODE field.
	EBI_MODE0_READ_MODE_Pos = 0x0
	// Bit mask of READ_MODE field.
	EBI_MODE0_READ_MODE_Msk = 0x1
	// Bit READ_MODE.
	EBI_MODE0_READ_MODE = 0x1
	// The Read operation is controlled by the NCS signal.
	EBI_MODE0_READ_MODE_NCS_CTRL = 0x0
	// The Read operation is controlled by the NRD signal.
	EBI_MODE0_READ_MODE_NRD_CTRL = 0x1
	// Position of WRITE_MODE field.
	EBI_MODE0_WRITE_MODE_Pos = 0x1
	// Bit mask of WRITE_MODE field.
	EBI_MODE0_WRITE_MODE_Msk = 0x2
	// Bit WRITE_MODE.
	EBI_MODE0_WRITE_MODE = 0x2
	// The Write operation is controller by the NCS signal.
	EBI_MODE0_WRITE_MODE_NCS_CTRL = 0x0
	// The Write operation is controlled by the NWE signal.
	EBI_MODE0_WRITE_MODE_NWE_CTRL = 0x1
	// Position of EXNW_MODE field.
	EBI_MODE0_EXNW_MODE_Pos = 0x4
	// Bit mask of EXNW_MODE field.
	EBI_MODE0_EXNW_MODE_Msk = 0x30
	// Disabled
	EBI_MODE0_EXNW_MODE_DISABLED = 0x0
	// Frozen Mode
	EBI_MODE0_EXNW_MODE_FROZEN = 0x2
	// Ready Mode
	EBI_MODE0_EXNW_MODE_READY = 0x3
	// Position of BAT field.
	EBI_MODE0_BAT_Pos = 0x8
	// Bit mask of BAT field.
	EBI_MODE0_BAT_Msk = 0x100
	// Bit BAT.
	EBI_MODE0_BAT = 0x100
	// Position of DBW field.
	EBI_MODE0_DBW_Pos = 0xc
	// Bit mask of DBW field.
	EBI_MODE0_DBW_Msk = 0x1000
	// Bit DBW.
	EBI_MODE0_DBW = 0x1000
	// 8-bit bus
	EBI_MODE0_DBW_BIT_8 = 0x0
	// 16-bit bus
	EBI_MODE0_DBW_BIT_16 = 0x1
	// Position of TDF_CYCLES field.
	EBI_MODE0_TDF_CYCLES_Pos = 0x10
	// Bit mask of TDF_CYCLES field.
	EBI_MODE0_TDF_CYCLES_Msk = 0xf0000
	// Position of TDF_MODE field.
	EBI_MODE0_TDF_MODE_Pos = 0x14
	// Bit mask of TDF_MODE field.
	EBI_MODE0_TDF_MODE_Msk = 0x100000
	// Bit TDF_MODE.
	EBI_MODE0_TDF_MODE = 0x100000

	// SETUP1: SMC Setup Register (CS_number = 1)
	// Position of NWE_SETUP field.
	EBI_SETUP1_NWE_SETUP_Pos = 0x0
	// Bit mask of NWE_SETUP field.
	EBI_SETUP1_NWE_SETUP_Msk = 0x3f
	// Position of NCS_WR_SETUP field.
	EBI_SETUP1_NCS_WR_SETUP_Pos = 0x8
	// Bit mask of NCS_WR_SETUP field.
	EBI_SETUP1_NCS_WR_SETUP_Msk = 0x3f00
	// Position of NRD_SETUP field.
	EBI_SETUP1_NRD_SETUP_Pos = 0x10
	// Bit mask of NRD_SETUP field.
	EBI_SETUP1_NRD_SETUP_Msk = 0x3f0000
	// Position of NCS_RD_SETUP field.
	EBI_SETUP1_NCS_RD_SETUP_Pos = 0x18
	// Bit mask of NCS_RD_SETUP field.
	EBI_SETUP1_NCS_RD_SETUP_Msk = 0x3f000000

	// PULSE1: SMC Pulse Register (CS_number = 1)
	// Position of NWE_PULSE field.
	EBI_PULSE1_NWE_PULSE_Pos = 0x0
	// Bit mask of NWE_PULSE field.
	EBI_PULSE1_NWE_PULSE_Msk = 0x3f
	// Position of NCS_WR_PULSE field.
	EBI_PULSE1_NCS_WR_PULSE_Pos = 0x8
	// Bit mask of NCS_WR_PULSE field.
	EBI_PULSE1_NCS_WR_PULSE_Msk = 0x3f00
	// Position of NRD_PULSE field.
	EBI_PULSE1_NRD_PULSE_Pos = 0x10
	// Bit mask of NRD_PULSE field.
	EBI_PULSE1_NRD_PULSE_Msk = 0x3f0000
	// Position of NCS_RD_PULSE field.
	EBI_PULSE1_NCS_RD_PULSE_Pos = 0x18
	// Bit mask of NCS_RD_PULSE field.
	EBI_PULSE1_NCS_RD_PULSE_Msk = 0x3f000000

	// CYCLE1: SMC Cycle Register (CS_number = 1)
	// Position of NWE_CYCLE field.
	EBI_CYCLE1_NWE_CYCLE_Pos = 0x0
	// Bit mask of NWE_CYCLE field.
	EBI_CYCLE1_NWE_CYCLE_Msk = 0x1ff
	// Position of NRD_CYCLE field.
	EBI_CYCLE1_NRD_CYCLE_Pos = 0x10
	// Bit mask of NRD_CYCLE field.
	EBI_CYCLE1_NRD_CYCLE_Msk = 0x1ff0000

	// TIMINGS1: SMC Timings Register (CS_number = 1)
	// Position of TCLR field.
	EBI_TIMINGS1_TCLR_Pos = 0x0
	// Bit mask of TCLR field.
	EBI_TIMINGS1_TCLR_Msk = 0xf
	// Position of TADL field.
	EBI_TIMINGS1_TADL_Pos = 0x4
	// Bit mask of TADL field.
	EBI_TIMINGS1_TADL_Msk = 0xf0
	// Position of TAR field.
	EBI_TIMINGS1_TAR_Pos = 0x8
	// Bit mask of TAR field.
	EBI_TIMINGS1_TAR_Msk = 0xf00
	// Position of OCMS field.
	EBI_TIMINGS1_OCMS_Pos = 0xc
	// Bit mask of OCMS field.
	EBI_TIMINGS1_OCMS_Msk = 0x1000
	// Bit OCMS.
	EBI_TIMINGS1_OCMS = 0x1000
	// Position of TRR field.
	EBI_TIMINGS1_TRR_Pos = 0x10
	// Bit mask of TRR field.
	EBI_TIMINGS1_TRR_Msk = 0xf0000
	// Position of TWB field.
	EBI_TIMINGS1_TWB_Pos = 0x18
	// Bit mask of TWB field.
	EBI_TIMINGS1_TWB_Msk = 0xf000000
	// Position of RBNSEL field.
	EBI_TIMINGS1_RBNSEL_Pos = 0x1c
	// Bit mask of RBNSEL field.
	EBI_TIMINGS1_RBNSEL_Msk = 0x70000000
	// Position of NFSEL field.
	EBI_TIMINGS1_NFSEL_Pos = 0x1f
	// Bit mask of NFSEL field.
	EBI_TIMINGS1_NFSEL_Msk = 0x80000000
	// Bit NFSEL.
	EBI_TIMINGS1_NFSEL = 0x80000000

	// MODE1: SMC Mode Register (CS_number = 1)
	// Position of READ_MODE field.
	EBI_MODE1_READ_MODE_Pos = 0x0
	// Bit mask of READ_MODE field.
	EBI_MODE1_READ_MODE_Msk = 0x1
	// Bit READ_MODE.
	EBI_MODE1_READ_MODE = 0x1
	// The Read operation is controlled by the NCS signal.
	EBI_MODE1_READ_MODE_NCS_CTRL = 0x0
	// The Read operation is controlled by the NRD signal.
	EBI_MODE1_READ_MODE_NRD_CTRL = 0x1
	// Position of WRITE_MODE field.
	EBI_MODE1_WRITE_MODE_Pos = 0x1
	// Bit mask of WRITE_MODE field.
	EBI_MODE1_WRITE_MODE_Msk = 0x2
	// Bit WRITE_MODE.
	EBI_MODE1_WRITE_MODE = 0x2
	// The Write operation is controller by the NCS signal.
	EBI_MODE1_WRITE_MODE_NCS_CTRL = 0x0
	// The Write operation is controlled by the NWE signal.
	EBI_MODE1_WRITE_MODE_NWE_CTRL = 0x1
	// Position of EXNW_MODE field.
	EBI_MODE1_EXNW_MODE_Pos = 0x4
	// Bit mask of EXNW_MODE field.
	EBI_MODE1_EXNW_MODE_Msk = 0x30
	// Disabled
	EBI_MODE1_EXNW_MODE_DISABLED = 0x0
	// Frozen Mode
	EBI_MODE1_EXNW_MODE_FROZEN = 0x2
	// Ready Mode
	EBI_MODE1_EXNW_MODE_READY = 0x3
	// Position of BAT field.
	EBI_MODE1_BAT_Pos = 0x8
	// Bit mask of BAT field.
	EBI_MODE1_BAT_Msk = 0x100
	// Bit BAT.
	EBI_MODE1_BAT = 0x100
	// Position of DBW field.
	EBI_MODE1_DBW_Pos = 0xc
	// Bit mask of DBW field.
	EBI_MODE1_DBW_Msk = 0x1000
	// Bit DBW.
	EBI_MODE1_DBW = 0x1000
	// 8-bit bus
	EBI_MODE1_DBW_BIT_8 = 0x0
	// 16-bit bus
	EBI_MODE1_DBW_BIT_16 = 0x1
	// Position of TDF_CYCLES field.
	EBI_MODE1_TDF_CYCLES_Pos = 0x10
	// Bit mask of TDF_CYCLES field.
	EBI_MODE1_TDF_CYCLES_Msk = 0xf0000
	// Position of TDF_MODE field.
	EBI_MODE1_TDF_MODE_Pos = 0x14
	// Bit mask of TDF_MODE field.
	EBI_MODE1_TDF_MODE_Msk = 0x100000
	// Bit TDF_MODE.
	EBI_MODE1_TDF_MODE = 0x100000

	// SETUP2: SMC Setup Register (CS_number = 2)
	// Position of NWE_SETUP field.
	EBI_SETUP2_NWE_SETUP_Pos = 0x0
	// Bit mask of NWE_SETUP field.
	EBI_SETUP2_NWE_SETUP_Msk = 0x3f
	// Position of NCS_WR_SETUP field.
	EBI_SETUP2_NCS_WR_SETUP_Pos = 0x8
	// Bit mask of NCS_WR_SETUP field.
	EBI_SETUP2_NCS_WR_SETUP_Msk = 0x3f00
	// Position of NRD_SETUP field.
	EBI_SETUP2_NRD_SETUP_Pos = 0x10
	// Bit mask of NRD_SETUP field.
	EBI_SETUP2_NRD_SETUP_Msk = 0x3f0000
	// Position of NCS_RD_SETUP field.
	EBI_SETUP2_NCS_RD_SETUP_Pos = 0x18
	// Bit mask of NCS_RD_SETUP field.
	EBI_SETUP2_NCS_RD_SETUP_Msk = 0x3f000000

	// PULSE2: SMC Pulse Register (CS_number = 2)
	// Position of NWE_PULSE field.
	EBI_PULSE2_NWE_PULSE_Pos = 0x0
	// Bit mask of NWE_PULSE field.
	EBI_PULSE2_NWE_PULSE_Msk = 0x3f
	// Position of NCS_WR_PULSE field.
	EBI_PULSE2_NCS_WR_PULSE_Pos = 0x8
	// Bit mask of NCS_WR_PULSE field.
	EBI_PULSE2_NCS_WR_PULSE_Msk = 0x3f00
	// Position of NRD_PULSE field.
	EBI_PULSE2_NRD_PULSE_Pos = 0x10
	// Bit mask of NRD_PULSE field.
	EBI_PULSE2_NRD_PULSE_Msk = 0x3f0000
	// Position of NCS_RD_PULSE field.
	EBI_PULSE2_NCS_RD_PULSE_Pos = 0x18
	// Bit mask of NCS_RD_PULSE field.
	EBI_PULSE2_NCS_RD_PULSE_Msk = 0x3f000000

	// CYCLE2: SMC Cycle Register (CS_number = 2)
	// Position of NWE_CYCLE field.
	EBI_CYCLE2_NWE_CYCLE_Pos = 0x0
	// Bit mask of NWE_CYCLE field.
	EBI_CYCLE2_NWE_CYCLE_Msk = 0x1ff
	// Position of NRD_CYCLE field.
	EBI_CYCLE2_NRD_CYCLE_Pos = 0x10
	// Bit mask of NRD_CYCLE field.
	EBI_CYCLE2_NRD_CYCLE_Msk = 0x1ff0000

	// TIMINGS2: SMC Timings Register (CS_number = 2)
	// Position of TCLR field.
	EBI_TIMINGS2_TCLR_Pos = 0x0
	// Bit mask of TCLR field.
	EBI_TIMINGS2_TCLR_Msk = 0xf
	// Position of TADL field.
	EBI_TIMINGS2_TADL_Pos = 0x4
	// Bit mask of TADL field.
	EBI_TIMINGS2_TADL_Msk = 0xf0
	// Position of TAR field.
	EBI_TIMINGS2_TAR_Pos = 0x8
	// Bit mask of TAR field.
	EBI_TIMINGS2_TAR_Msk = 0xf00
	// Position of OCMS field.
	EBI_TIMINGS2_OCMS_Pos = 0xc
	// Bit mask of OCMS field.
	EBI_TIMINGS2_OCMS_Msk = 0x1000
	// Bit OCMS.
	EBI_TIMINGS2_OCMS = 0x1000
	// Position of TRR field.
	EBI_TIMINGS2_TRR_Pos = 0x10
	// Bit mask of TRR field.
	EBI_TIMINGS2_TRR_Msk = 0xf0000
	// Position of TWB field.
	EBI_TIMINGS2_TWB_Pos = 0x18
	// Bit mask of TWB field.
	EBI_TIMINGS2_TWB_Msk = 0xf000000
	// Position of RBNSEL field.
	EBI_TIMINGS2_RBNSEL_Pos = 0x1c
	// Bit mask of RBNSEL field.
	EBI_TIMINGS2_RBNSEL_Msk = 0x70000000
	// Position of NFSEL field.
	EBI_TIMINGS2_NFSEL_Pos = 0x1f
	// Bit mask of NFSEL field.
	EBI_TIMINGS2_NFSEL_Msk = 0x80000000
	// Bit NFSEL.
	EBI_TIMINGS2_NFSEL = 0x80000000

	// MODE2: SMC Mode Register (CS_number = 2)
	// Position of READ_MODE field.
	EBI_MODE2_READ_MODE_Pos = 0x0
	// Bit mask of READ_MODE field.
	EBI_MODE2_READ_MODE_Msk = 0x1
	// Bit READ_MODE.
	EBI_MODE2_READ_MODE = 0x1
	// The Read operation is controlled by the NCS signal.
	EBI_MODE2_READ_MODE_NCS_CTRL = 0x0
	// The Read operation is controlled by the NRD signal.
	EBI_MODE2_READ_MODE_NRD_CTRL = 0x1
	// Position of WRITE_MODE field.
	EBI_MODE2_WRITE_MODE_Pos = 0x1
	// Bit mask of WRITE_MODE field.
	EBI_MODE2_WRITE_MODE_Msk = 0x2
	// Bit WRITE_MODE.
	EBI_MODE2_WRITE_MODE = 0x2
	// The Write operation is controller by the NCS signal.
	EBI_MODE2_WRITE_MODE_NCS_CTRL = 0x0
	// The Write operation is controlled by the NWE signal.
	EBI_MODE2_WRITE_MODE_NWE_CTRL = 0x1
	// Position of EXNW_MODE field.
	EBI_MODE2_EXNW_MODE_Pos = 0x4
	// Bit mask of EXNW_MODE field.
	EBI_MODE2_EXNW_MODE_Msk = 0x30
	// Disabled
	EBI_MODE2_EXNW_MODE_DISABLED = 0x0
	// Frozen Mode
	EBI_MODE2_EXNW_MODE_FROZEN = 0x2
	// Ready Mode
	EBI_MODE2_EXNW_MODE_READY = 0x3
	// Position of BAT field.
	EBI_MODE2_BAT_Pos = 0x8
	// Bit mask of BAT field.
	EBI_MODE2_BAT_Msk = 0x100
	// Bit BAT.
	EBI_MODE2_BAT = 0x100
	// Position of DBW field.
	EBI_MODE2_DBW_Pos = 0xc
	// Bit mask of DBW field.
	EBI_MODE2_DBW_Msk = 0x1000
	// Bit DBW.
	EBI_MODE2_DBW = 0x1000
	// 8-bit bus
	EBI_MODE2_DBW_BIT_8 = 0x0
	// 16-bit bus
	EBI_MODE2_DBW_BIT_16 = 0x1
	// Position of TDF_CYCLES field.
	EBI_MODE2_TDF_CYCLES_Pos = 0x10
	// Bit mask of TDF_CYCLES field.
	EBI_MODE2_TDF_CYCLES_Msk = 0xf0000
	// Position of TDF_MODE field.
	EBI_MODE2_TDF_MODE_Pos = 0x14
	// Bit mask of TDF_MODE field.
	EBI_MODE2_TDF_MODE_Msk = 0x100000
	// Bit TDF_MODE.
	EBI_MODE2_TDF_MODE = 0x100000

	// SETUP3: SMC Setup Register (CS_number = 3)
	// Position of NWE_SETUP field.
	EBI_SETUP3_NWE_SETUP_Pos = 0x0
	// Bit mask of NWE_SETUP field.
	EBI_SETUP3_NWE_SETUP_Msk = 0x3f
	// Position of NCS_WR_SETUP field.
	EBI_SETUP3_NCS_WR_SETUP_Pos = 0x8
	// Bit mask of NCS_WR_SETUP field.
	EBI_SETUP3_NCS_WR_SETUP_Msk = 0x3f00
	// Position of NRD_SETUP field.
	EBI_SETUP3_NRD_SETUP_Pos = 0x10
	// Bit mask of NRD_SETUP field.
	EBI_SETUP3_NRD_SETUP_Msk = 0x3f0000
	// Position of NCS_RD_SETUP field.
	EBI_SETUP3_NCS_RD_SETUP_Pos = 0x18
	// Bit mask of NCS_RD_SETUP field.
	EBI_SETUP3_NCS_RD_SETUP_Msk = 0x3f000000

	// PULSE3: SMC Pulse Register (CS_number = 3)
	// Position of NWE_PULSE field.
	EBI_PULSE3_NWE_PULSE_Pos = 0x0
	// Bit mask of NWE_PULSE field.
	EBI_PULSE3_NWE_PULSE_Msk = 0x3f
	// Position of NCS_WR_PULSE field.
	EBI_PULSE3_NCS_WR_PULSE_Pos = 0x8
	// Bit mask of NCS_WR_PULSE field.
	EBI_PULSE3_NCS_WR_PULSE_Msk = 0x3f00
	// Position of NRD_PULSE field.
	EBI_PULSE3_NRD_PULSE_Pos = 0x10
	// Bit mask of NRD_PULSE field.
	EBI_PULSE3_NRD_PULSE_Msk = 0x3f0000
	// Position of NCS_RD_PULSE field.
	EBI_PULSE3_NCS_RD_PULSE_Pos = 0x18
	// Bit mask of NCS_RD_PULSE field.
	EBI_PULSE3_NCS_RD_PULSE_Msk = 0x3f000000

	// CYCLE3: SMC Cycle Register (CS_number = 3)
	// Position of NWE_CYCLE field.
	EBI_CYCLE3_NWE_CYCLE_Pos = 0x0
	// Bit mask of NWE_CYCLE field.
	EBI_CYCLE3_NWE_CYCLE_Msk = 0x1ff
	// Position of NRD_CYCLE field.
	EBI_CYCLE3_NRD_CYCLE_Pos = 0x10
	// Bit mask of NRD_CYCLE field.
	EBI_CYCLE3_NRD_CYCLE_Msk = 0x1ff0000

	// TIMINGS3: SMC Timings Register (CS_number = 3)
	// Position of TCLR field.
	EBI_TIMINGS3_TCLR_Pos = 0x0
	// Bit mask of TCLR field.
	EBI_TIMINGS3_TCLR_Msk = 0xf
	// Position of TADL field.
	EBI_TIMINGS3_TADL_Pos = 0x4
	// Bit mask of TADL field.
	EBI_TIMINGS3_TADL_Msk = 0xf0
	// Position of TAR field.
	EBI_TIMINGS3_TAR_Pos = 0x8
	// Bit mask of TAR field.
	EBI_TIMINGS3_TAR_Msk = 0xf00
	// Position of OCMS field.
	EBI_TIMINGS3_OCMS_Pos = 0xc
	// Bit mask of OCMS field.
	EBI_TIMINGS3_OCMS_Msk = 0x1000
	// Bit OCMS.
	EBI_TIMINGS3_OCMS = 0x1000
	// Position of TRR field.
	EBI_TIMINGS3_TRR_Pos = 0x10
	// Bit mask of TRR field.
	EBI_TIMINGS3_TRR_Msk = 0xf0000
	// Position of TWB field.
	EBI_TIMINGS3_TWB_Pos = 0x18
	// Bit mask of TWB field.
	EBI_TIMINGS3_TWB_Msk = 0xf000000
	// Position of RBNSEL field.
	EBI_TIMINGS3_RBNSEL_Pos = 0x1c
	// Bit mask of RBNSEL field.
	EBI_TIMINGS3_RBNSEL_Msk = 0x70000000
	// Position of NFSEL field.
	EBI_TIMINGS3_NFSEL_Pos = 0x1f
	// Bit mask of NFSEL field.
	EBI_TIMINGS3_NFSEL_Msk = 0x80000000
	// Bit NFSEL.
	EBI_TIMINGS3_NFSEL = 0x80000000

	// MODE3: SMC Mode Register (CS_number = 3)
	// Position of READ_MODE field.
	EBI_MODE3_READ_MODE_Pos = 0x0
	// Bit mask of READ_MODE field.
	EBI_MODE3_READ_MODE_Msk = 0x1
	// Bit READ_MODE.
	EBI_MODE3_READ_MODE = 0x1
	// The Read operation is controlled by the NCS signal.
	EBI_MODE3_READ_MODE_NCS_CTRL = 0x0
	// The Read operation is controlled by the NRD signal.
	EBI_MODE3_READ_MODE_NRD_CTRL = 0x1
	// Position of WRITE_MODE field.
	EBI_MODE3_WRITE_MODE_Pos = 0x1
	// Bit mask of WRITE_MODE field.
	EBI_MODE3_WRITE_MODE_Msk = 0x2
	// Bit WRITE_MODE.
	EBI_MODE3_WRITE_MODE = 0x2
	// The Write operation is controller by the NCS signal.
	EBI_MODE3_WRITE_MODE_NCS_CTRL = 0x0
	// The Write operation is controlled by the NWE signal.
	EBI_MODE3_WRITE_MODE_NWE_CTRL = 0x1
	// Position of EXNW_MODE field.
	EBI_MODE3_EXNW_MODE_Pos = 0x4
	// Bit mask of EXNW_MODE field.
	EBI_MODE3_EXNW_MODE_Msk = 0x30
	// Disabled
	EBI_MODE3_EXNW_MODE_DISABLED = 0x0
	// Frozen Mode
	EBI_MODE3_EXNW_MODE_FROZEN = 0x2
	// Ready Mode
	EBI_MODE3_EXNW_MODE_READY = 0x3
	// Position of BAT field.
	EBI_MODE3_BAT_Pos = 0x8
	// Bit mask of BAT field.
	EBI_MODE3_BAT_Msk = 0x100
	// Bit BAT.
	EBI_MODE3_BAT = 0x100
	// Position of DBW field.
	EBI_MODE3_DBW_Pos = 0xc
	// Bit mask of DBW field.
	EBI_MODE3_DBW_Msk = 0x1000
	// Bit DBW.
	EBI_MODE3_DBW = 0x1000
	// 8-bit bus
	EBI_MODE3_DBW_BIT_8 = 0x0
	// 16-bit bus
	EBI_MODE3_DBW_BIT_16 = 0x1
	// Position of TDF_CYCLES field.
	EBI_MODE3_TDF_CYCLES_Pos = 0x10
	// Bit mask of TDF_CYCLES field.
	EBI_MODE3_TDF_CYCLES_Msk = 0xf0000
	// Position of TDF_MODE field.
	EBI_MODE3_TDF_MODE_Pos = 0x14
	// Bit mask of TDF_MODE field.
	EBI_MODE3_TDF_MODE_Msk = 0x100000
	// Bit TDF_MODE.
	EBI_MODE3_TDF_MODE = 0x100000

	// OCMS: SMC OCMS Register
	// Position of SMSE field.
	EBI_OCMS_SMSE_Pos = 0x0
	// Bit mask of SMSE field.
	EBI_OCMS_SMSE_Msk = 0x1
	// Bit SMSE.
	EBI_OCMS_SMSE = 0x1
	// Position of SRSE field.
	EBI_OCMS_SRSE_Pos = 0x1
	// Bit mask of SRSE field.
	EBI_OCMS_SRSE_Msk = 0x2
	// Bit SRSE.
	EBI_OCMS_SRSE = 0x2

	// KEY1: SMC OCMS KEY1 Register
	// Position of KEY1 field.
	EBI_KEY1_KEY1_Pos = 0x0
	// Bit mask of KEY1 field.
	EBI_KEY1_KEY1_Msk = 0xffffffff

	// KEY2: SMC OCMS KEY2 Register
	// Position of KEY2 field.
	EBI_KEY2_KEY2_Pos = 0x0
	// Bit mask of KEY2 field.
	EBI_KEY2_KEY2_Msk = 0xffffffff

	// WPCR: Write Protection Control Register
	// Position of WP_EN field.
	EBI_WPCR_WP_EN_Pos = 0x0
	// Bit mask of WP_EN field.
	EBI_WPCR_WP_EN_Msk = 0x1
	// Bit WP_EN.
	EBI_WPCR_WP_EN = 0x1
	// Position of WP_KEY field.
	EBI_WPCR_WP_KEY_Pos = 0x8
	// Bit mask of WP_KEY field.
	EBI_WPCR_WP_KEY_Msk = 0xffffff00

	// WPSR: Write Protection Status Register
	// Position of WP_VS field.
	EBI_WPSR_WP_VS_Pos = 0x0
	// Bit mask of WP_VS field.
	EBI_WPSR_WP_VS_Msk = 0xf
	// Position of WP_VSRC field.
	EBI_WPSR_WP_VSRC_Pos = 0x8
	// Bit mask of WP_VSRC field.
	EBI_WPSR_WP_VSRC_Msk = 0xffff00
)

// Bitfields for MATRIX: AHB Bus Matrix
const (
	// MCFG: Master Configuration Register
	// Position of ULBT field.
	MATRIX_MCFG_ULBT_Pos = 0x0
	// Bit mask of ULBT field.
	MATRIX_MCFG_ULBT_Msk = 0x7

	// SCFG: Slave Configuration Register
	// Position of SLOT_CYCLE field.
	MATRIX_SCFG_SLOT_CYCLE_Pos = 0x0
	// Bit mask of SLOT_CYCLE field.
	MATRIX_SCFG_SLOT_CYCLE_Msk = 0xff
	// Position of DEFMSTR_TYPE field.
	MATRIX_SCFG_DEFMSTR_TYPE_Pos = 0x10
	// Bit mask of DEFMSTR_TYPE field.
	MATRIX_SCFG_DEFMSTR_TYPE_Msk = 0x30000
	// Position of FIXED_DEFMSTR field.
	MATRIX_SCFG_FIXED_DEFMSTR_Pos = 0x12
	// Bit mask of FIXED_DEFMSTR field.
	MATRIX_SCFG_FIXED_DEFMSTR_Msk = 0x1c0000
	// Position of ARBT field.
	MATRIX_SCFG_ARBT_Pos = 0x18
	// Bit mask of ARBT field.
	MATRIX_SCFG_ARBT_Msk = 0x3000000

	// PRAS0: Priority Register A for Slave 0
	// Position of M0PR field.
	MATRIX_PRAS0_M0PR_Pos = 0x0
	// Bit mask of M0PR field.
	MATRIX_PRAS0_M0PR_Msk = 0x3
	// Position of M1PR field.
	MATRIX_PRAS0_M1PR_Pos = 0x4
	// Bit mask of M1PR field.
	MATRIX_PRAS0_M1PR_Msk = 0x30
	// Position of M2PR field.
	MATRIX_PRAS0_M2PR_Pos = 0x8
	// Bit mask of M2PR field.
	MATRIX_PRAS0_M2PR_Msk = 0x300
	// Position of M3PR field.
	MATRIX_PRAS0_M3PR_Pos = 0xc
	// Bit mask of M3PR field.
	MATRIX_PRAS0_M3PR_Msk = 0x3000
	// Position of M4PR field.
	MATRIX_PRAS0_M4PR_Pos = 0x10
	// Bit mask of M4PR field.
	MATRIX_PRAS0_M4PR_Msk = 0x30000

	// PRAS1: Priority Register A for Slave 1
	// Position of M0PR field.
	MATRIX_PRAS1_M0PR_Pos = 0x0
	// Bit mask of M0PR field.
	MATRIX_PRAS1_M0PR_Msk = 0x3
	// Position of M1PR field.
	MATRIX_PRAS1_M1PR_Pos = 0x4
	// Bit mask of M1PR field.
	MATRIX_PRAS1_M1PR_Msk = 0x30
	// Position of M2PR field.
	MATRIX_PRAS1_M2PR_Pos = 0x8
	// Bit mask of M2PR field.
	MATRIX_PRAS1_M2PR_Msk = 0x300
	// Position of M3PR field.
	MATRIX_PRAS1_M3PR_Pos = 0xc
	// Bit mask of M3PR field.
	MATRIX_PRAS1_M3PR_Msk = 0x3000
	// Position of M4PR field.
	MATRIX_PRAS1_M4PR_Pos = 0x10
	// Bit mask of M4PR field.
	MATRIX_PRAS1_M4PR_Msk = 0x30000

	// PRAS2: Priority Register A for Slave 2
	// Position of M0PR field.
	MATRIX_PRAS2_M0PR_Pos = 0x0
	// Bit mask of M0PR field.
	MATRIX_PRAS2_M0PR_Msk = 0x3
	// Position of M1PR field.
	MATRIX_PRAS2_M1PR_Pos = 0x4
	// Bit mask of M1PR field.
	MATRIX_PRAS2_M1PR_Msk = 0x30
	// Position of M2PR field.
	MATRIX_PRAS2_M2PR_Pos = 0x8
	// Bit mask of M2PR field.
	MATRIX_PRAS2_M2PR_Msk = 0x300
	// Position of M3PR field.
	MATRIX_PRAS2_M3PR_Pos = 0xc
	// Bit mask of M3PR field.
	MATRIX_PRAS2_M3PR_Msk = 0x3000
	// Position of M4PR field.
	MATRIX_PRAS2_M4PR_Pos = 0x10
	// Bit mask of M4PR field.
	MATRIX_PRAS2_M4PR_Msk = 0x30000

	// PRAS3: Priority Register A for Slave 3
	// Position of M0PR field.
	MATRIX_PRAS3_M0PR_Pos = 0x0
	// Bit mask of M0PR field.
	MATRIX_PRAS3_M0PR_Msk = 0x3
	// Position of M1PR field.
	MATRIX_PRAS3_M1PR_Pos = 0x4
	// Bit mask of M1PR field.
	MATRIX_PRAS3_M1PR_Msk = 0x30
	// Position of M2PR field.
	MATRIX_PRAS3_M2PR_Pos = 0x8
	// Bit mask of M2PR field.
	MATRIX_PRAS3_M2PR_Msk = 0x300
	// Position of M3PR field.
	MATRIX_PRAS3_M3PR_Pos = 0xc
	// Bit mask of M3PR field.
	MATRIX_PRAS3_M3PR_Msk = 0x3000
	// Position of M4PR field.
	MATRIX_PRAS3_M4PR_Pos = 0x10
	// Bit mask of M4PR field.
	MATRIX_PRAS3_M4PR_Msk = 0x30000

	// PRAS4: Priority Register A for Slave 4
	// Position of M0PR field.
	MATRIX_PRAS4_M0PR_Pos = 0x0
	// Bit mask of M0PR field.
	MATRIX_PRAS4_M0PR_Msk = 0x3
	// Position of M1PR field.
	MATRIX_PRAS4_M1PR_Pos = 0x4
	// Bit mask of M1PR field.
	MATRIX_PRAS4_M1PR_Msk = 0x30
	// Position of M2PR field.
	MATRIX_PRAS4_M2PR_Pos = 0x8
	// Bit mask of M2PR field.
	MATRIX_PRAS4_M2PR_Msk = 0x300
	// Position of M3PR field.
	MATRIX_PRAS4_M3PR_Pos = 0xc
	// Bit mask of M3PR field.
	MATRIX_PRAS4_M3PR_Msk = 0x3000
	// Position of M4PR field.
	MATRIX_PRAS4_M4PR_Pos = 0x10
	// Bit mask of M4PR field.
	MATRIX_PRAS4_M4PR_Msk = 0x30000

	// PRAS5: Priority Register A for Slave 5
	// Position of M0PR field.
	MATRIX_PRAS5_M0PR_Pos = 0x0
	// Bit mask of M0PR field.
	MATRIX_PRAS5_M0PR_Msk = 0x3
	// Position of M1PR field.
	MATRIX_PRAS5_M1PR_Pos = 0x4
	// Bit mask of M1PR field.
	MATRIX_PRAS5_M1PR_Msk = 0x30
	// Position of M2PR field.
	MATRIX_PRAS5_M2PR_Pos = 0x8
	// Bit mask of M2PR field.
	MATRIX_PRAS5_M2PR_Msk = 0x300
	// Position of M3PR field.
	MATRIX_PRAS5_M3PR_Pos = 0xc
	// Bit mask of M3PR field.
	MATRIX_PRAS5_M3PR_Msk = 0x3000
	// Position of M4PR field.
	MATRIX_PRAS5_M4PR_Pos = 0x10
	// Bit mask of M4PR field.
	MATRIX_PRAS5_M4PR_Msk = 0x30000

	// PRAS6: Priority Register A for Slave 6
	// Position of M0PR field.
	MATRIX_PRAS6_M0PR_Pos = 0x0
	// Bit mask of M0PR field.
	MATRIX_PRAS6_M0PR_Msk = 0x3
	// Position of M1PR field.
	MATRIX_PRAS6_M1PR_Pos = 0x4
	// Bit mask of M1PR field.
	MATRIX_PRAS6_M1PR_Msk = 0x30
	// Position of M2PR field.
	MATRIX_PRAS6_M2PR_Pos = 0x8
	// Bit mask of M2PR field.
	MATRIX_PRAS6_M2PR_Msk = 0x300
	// Position of M3PR field.
	MATRIX_PRAS6_M3PR_Pos = 0xc
	// Bit mask of M3PR field.
	MATRIX_PRAS6_M3PR_Msk = 0x3000
	// Position of M4PR field.
	MATRIX_PRAS6_M4PR_Pos = 0x10
	// Bit mask of M4PR field.
	MATRIX_PRAS6_M4PR_Msk = 0x30000

	// PRAS7: Priority Register A for Slave 7
	// Position of M0PR field.
	MATRIX_PRAS7_M0PR_Pos = 0x0
	// Bit mask of M0PR field.
	MATRIX_PRAS7_M0PR_Msk = 0x3
	// Position of M1PR field.
	MATRIX_PRAS7_M1PR_Pos = 0x4
	// Bit mask of M1PR field.
	MATRIX_PRAS7_M1PR_Msk = 0x30
	// Position of M2PR field.
	MATRIX_PRAS7_M2PR_Pos = 0x8
	// Bit mask of M2PR field.
	MATRIX_PRAS7_M2PR_Msk = 0x300
	// Position of M3PR field.
	MATRIX_PRAS7_M3PR_Pos = 0xc
	// Bit mask of M3PR field.
	MATRIX_PRAS7_M3PR_Msk = 0x3000
	// Position of M4PR field.
	MATRIX_PRAS7_M4PR_Pos = 0x10
	// Bit mask of M4PR field.
	MATRIX_PRAS7_M4PR_Msk = 0x30000

	// PRAS8: Priority Register A for Slave 8
	// Position of M0PR field.
	MATRIX_PRAS8_M0PR_Pos = 0x0
	// Bit mask of M0PR field.
	MATRIX_PRAS8_M0PR_Msk = 0x3
	// Position of M1PR field.
	MATRIX_PRAS8_M1PR_Pos = 0x4
	// Bit mask of M1PR field.
	MATRIX_PRAS8_M1PR_Msk = 0x30
	// Position of M2PR field.
	MATRIX_PRAS8_M2PR_Pos = 0x8
	// Bit mask of M2PR field.
	MATRIX_PRAS8_M2PR_Msk = 0x300
	// Position of M3PR field.
	MATRIX_PRAS8_M3PR_Pos = 0xc
	// Bit mask of M3PR field.
	MATRIX_PRAS8_M3PR_Msk = 0x3000
	// Position of M4PR field.
	MATRIX_PRAS8_M4PR_Pos = 0x10
	// Bit mask of M4PR field.
	MATRIX_PRAS8_M4PR_Msk = 0x30000

	// PRAS9: Priority Register A for Slave 9
	// Position of M0PR field.
	MATRIX_PRAS9_M0PR_Pos = 0x0
	// Bit mask of M0PR field.
	MATRIX_PRAS9_M0PR_Msk = 0x3
	// Position of M1PR field.
	MATRIX_PRAS9_M1PR_Pos = 0x4
	// Bit mask of M1PR field.
	MATRIX_PRAS9_M1PR_Msk = 0x30
	// Position of M2PR field.
	MATRIX_PRAS9_M2PR_Pos = 0x8
	// Bit mask of M2PR field.
	MATRIX_PRAS9_M2PR_Msk = 0x300
	// Position of M3PR field.
	MATRIX_PRAS9_M3PR_Pos = 0xc
	// Bit mask of M3PR field.
	MATRIX_PRAS9_M3PR_Msk = 0x3000
	// Position of M4PR field.
	MATRIX_PRAS9_M4PR_Pos = 0x10
	// Bit mask of M4PR field.
	MATRIX_PRAS9_M4PR_Msk = 0x30000

	// MRCR: Master Remap Control Register
	// Position of RCB0 field.
	MATRIX_MRCR_RCB0_Pos = 0x0
	// Bit mask of RCB0 field.
	MATRIX_MRCR_RCB0_Msk = 0x1
	// Bit RCB0.
	MATRIX_MRCR_RCB0 = 0x1
	// Position of RCB1 field.
	MATRIX_MRCR_RCB1_Pos = 0x1
	// Bit mask of RCB1 field.
	MATRIX_MRCR_RCB1_Msk = 0x2
	// Bit RCB1.
	MATRIX_MRCR_RCB1 = 0x2
	// Position of RCB2 field.
	MATRIX_MRCR_RCB2_Pos = 0x2
	// Bit mask of RCB2 field.
	MATRIX_MRCR_RCB2_Msk = 0x4
	// Bit RCB2.
	MATRIX_MRCR_RCB2 = 0x4
	// Position of RCB3 field.
	MATRIX_MRCR_RCB3_Pos = 0x3
	// Bit mask of RCB3 field.
	MATRIX_MRCR_RCB3_Msk = 0x8
	// Bit RCB3.
	MATRIX_MRCR_RCB3 = 0x8
	// Position of RCB4 field.
	MATRIX_MRCR_RCB4_Pos = 0x4
	// Bit mask of RCB4 field.
	MATRIX_MRCR_RCB4_Msk = 0x10
	// Bit RCB4.
	MATRIX_MRCR_RCB4 = 0x10

	// WPMR: Write Protect Mode Register
	// Position of WPEN field.
	MATRIX_WPMR_WPEN_Pos = 0x0
	// Bit mask of WPEN field.
	MATRIX_WPMR_WPEN_Msk = 0x1
	// Bit WPEN.
	MATRIX_WPMR_WPEN = 0x1
	// Position of WPKEY field.
	MATRIX_WPMR_WPKEY_Pos = 0x8
	// Bit mask of WPKEY field.
	MATRIX_WPMR_WPKEY_Msk = 0xffffff00

	// WPSR: Write Protect Status Register
	// Position of WPVS field.
	MATRIX_WPSR_WPVS_Pos = 0x0
	// Bit mask of WPVS field.
	MATRIX_WPSR_WPVS_Msk = 0x1
	// Bit WPVS.
	MATRIX_WPSR_WPVS = 0x1
	// Position of WPVSRC field.
	MATRIX_WPSR_WPVSRC_Pos = 0x8
	// Bit mask of WPVSRC field.
	MATRIX_WPSR_WPVSRC_Msk = 0xffff00
)

// Bitfields for PMC: Power Management Controller
const (
	// PMC_SCER: System Clock Enable Register
	// Position of PCK0 field.
	PMC_PMC_SCER_PCK0_Pos = 0x8
	// Bit mask of PCK0 field.
	PMC_PMC_SCER_PCK0_Msk = 0x100
	// Bit PCK0.
	PMC_PMC_SCER_PCK0 = 0x100
	// Position of PCK1 field.
	PMC_PMC_SCER_PCK1_Pos = 0x9
	// Bit mask of PCK1 field.
	PMC_PMC_SCER_PCK1_Msk = 0x200
	// Bit PCK1.
	PMC_PMC_SCER_PCK1 = 0x200
	// Position of PCK2 field.
	PMC_PMC_SCER_PCK2_Pos = 0xa
	// Bit mask of PCK2 field.
	PMC_PMC_SCER_PCK2_Msk = 0x400
	// Bit PCK2.
	PMC_PMC_SCER_PCK2 = 0x400

	// PMC_SCDR: System Clock Disable Register
	// Position of PCK0 field.
	PMC_PMC_SCDR_PCK0_Pos = 0x8
	// Bit mask of PCK0 field.
	PMC_PMC_SCDR_PCK0_Msk = 0x100
	// Bit PCK0.
	PMC_PMC_SCDR_PCK0 = 0x100
	// Position of PCK1 field.
	PMC_PMC_SCDR_PCK1_Pos = 0x9
	// Bit mask of PCK1 field.
	PMC_PMC_SCDR_PCK1_Msk = 0x200
	// Bit PCK1.
	PMC_PMC_SCDR_PCK1 = 0x200
	// Position of PCK2 field.
	PMC_PMC_SCDR_PCK2_Pos = 0xa
	// Bit mask of PCK2 field.
	PMC_PMC_SCDR_PCK2_Msk = 0x400
	// Bit PCK2.
	PMC_PMC_SCDR_PCK2 = 0x400

	// PMC_SCSR: System Clock Status Register
	// Position of PCK0 field.
	PMC_PMC_SCSR_PCK0_Pos = 0x8
	// Bit mask of PCK0 field.
	PMC_PMC_SCSR_PCK0_Msk = 0x100
	// Bit PCK0.
	PMC_PMC_SCSR_PCK0 = 0x100
	// Position of PCK1 field.
	PMC_PMC_SCSR_PCK1_Pos = 0x9
	// Bit mask of PCK1 field.
	PMC_PMC_SCSR_PCK1_Msk = 0x200
	// Bit PCK1.
	PMC_PMC_SCSR_PCK1 = 0x200
	// Position of PCK2 field.
	PMC_PMC_SCSR_PCK2_Pos = 0xa
	// Bit mask of PCK2 field.
	PMC_PMC_SCSR_PCK2_Msk = 0x400
	// Bit PCK2.
	PMC_PMC_SCSR_PCK2 = 0x400

	// PMC_PCER0: Peripheral Clock Enable Register 0
	// Position of PID8 field.
	PMC_PMC_PCER0_PID8_Pos = 0x8
	// Bit mask of PID8 field.
	PMC_PMC_PCER0_PID8_Msk = 0x100
	// Bit PID8.
	PMC_PMC_PCER0_PID8 = 0x100
	// Position of PID9 field.
	PMC_PMC_PCER0_PID9_Pos = 0x9
	// Bit mask of PID9 field.
	PMC_PMC_PCER0_PID9_Msk = 0x200
	// Bit PID9.
	PMC_PMC_PCER0_PID9 = 0x200
	// Position of PID10 field.
	PMC_PMC_PCER0_PID10_Pos = 0xa
	// Bit mask of PID10 field.
	PMC_PMC_PCER0_PID10_Msk = 0x400
	// Bit PID10.
	PMC_PMC_PCER0_PID10 = 0x400
	// Position of PID11 field.
	PMC_PMC_PCER0_PID11_Pos = 0xb
	// Bit mask of PID11 field.
	PMC_PMC_PCER0_PID11_Msk = 0x800
	// Bit PID11.
	PMC_PMC_PCER0_PID11 = 0x800
	// Position of PID12 field.
	PMC_PMC_PCER0_PID12_Pos = 0xc
	// Bit mask of PID12 field.
	PMC_PMC_PCER0_PID12_Msk = 0x1000
	// Bit PID12.
	PMC_PMC_PCER0_PID12 = 0x1000
	// Position of PID13 field.
	PMC_PMC_PCER0_PID13_Pos = 0xd
	// Bit mask of PID13 field.
	PMC_PMC_PCER0_PID13_Msk = 0x2000
	// Bit PID13.
	PMC_PMC_PCER0_PID13 = 0x2000
	// Position of PID14 field.
	PMC_PMC_PCER0_PID14_Pos = 0xe
	// Bit mask of PID14 field.
	PMC_PMC_PCER0_PID14_Msk = 0x4000
	// Bit PID14.
	PMC_PMC_PCER0_PID14 = 0x4000
	// Position of PID15 field.
	PMC_PMC_PCER0_PID15_Pos = 0xf
	// Bit mask of PID15 field.
	PMC_PMC_PCER0_PID15_Msk = 0x8000
	// Bit PID15.
	PMC_PMC_PCER0_PID15 = 0x8000
	// Position of PID16 field.
	PMC_PMC_PCER0_PID16_Pos = 0x10
	// Bit mask of PID16 field.
	PMC_PMC_PCER0_PID16_Msk = 0x10000
	// Bit PID16.
	PMC_PMC_PCER0_PID16 = 0x10000
	// Position of PID18 field.
	PMC_PMC_PCER0_PID18_Pos = 0x12
	// Bit mask of PID18 field.
	PMC_PMC_PCER0_PID18_Msk = 0x40000
	// Bit PID18.
	PMC_PMC_PCER0_PID18 = 0x40000
	// Position of PID19 field.
	PMC_PMC_PCER0_PID19_Pos = 0x13
	// Bit mask of PID19 field.
	PMC_PMC_PCER0_PID19_Msk = 0x80000
	// Bit PID19.
	PMC_PMC_PCER0_PID19 = 0x80000
	// Position of PID20 field.
	PMC_PMC_PCER0_PID20_Pos = 0x14
	// Bit mask of PID20 field.
	PMC_PMC_PCER0_PID20_Msk = 0x100000
	// Bit PID20.
	PMC_PMC_PCER0_PID20 = 0x100000
	// Position of PID21 field.
	PMC_PMC_PCER0_PID21_Pos = 0x15
	// Bit mask of PID21 field.
	PMC_PMC_PCER0_PID21_Msk = 0x200000
	// Bit PID21.
	PMC_PMC_PCER0_PID21 = 0x200000
	// Position of PID22 field.
	PMC_PMC_PCER0_PID22_Pos = 0x16
	// Bit mask of PID22 field.
	PMC_PMC_PCER0_PID22_Msk = 0x400000
	// Bit PID22.
	PMC_PMC_PCER0_PID22 = 0x400000
	// Position of PID23 field.
	PMC_PMC_PCER0_PID23_Pos = 0x17
	// Bit mask of PID23 field.
	PMC_PMC_PCER0_PID23_Msk = 0x800000
	// Bit PID23.
	PMC_PMC_PCER0_PID23 = 0x800000
	// Position of PID24 field.
	PMC_PMC_PCER0_PID24_Pos = 0x18
	// Bit mask of PID24 field.
	PMC_PMC_PCER0_PID24_Msk = 0x1000000
	// Bit PID24.
	PMC_PMC_PCER0_PID24 = 0x1000000
	// Position of PID25 field.
	PMC_PMC_PCER0_PID25_Pos = 0x19
	// Bit mask of PID25 field.
	PMC_PMC_PCER0_PID25_Msk = 0x2000000
	// Bit PID25.
	PMC_PMC_PCER0_PID25 = 0x2000000
	// Position of PID26 field.
	PMC_PMC_PCER0_PID26_Pos = 0x1a
	// Bit mask of PID26 field.
	PMC_PMC_PCER0_PID26_Msk = 0x4000000
	// Bit PID26.
	PMC_PMC_PCER0_PID26 = 0x4000000
	// Position of PID27 field.
	PMC_PMC_PCER0_PID27_Pos = 0x1b
	// Bit mask of PID27 field.
	PMC_PMC_PCER0_PID27_Msk = 0x8000000
	// Bit PID27.
	PMC_PMC_PCER0_PID27 = 0x8000000
	// Position of PID28 field.
	PMC_PMC_PCER0_PID28_Pos = 0x1c
	// Bit mask of PID28 field.
	PMC_PMC_PCER0_PID28_Msk = 0x10000000
	// Bit PID28.
	PMC_PMC_PCER0_PID28 = 0x10000000
	// Position of PID29 field.
	PMC_PMC_PCER0_PID29_Pos = 0x1d
	// Bit mask of PID29 field.
	PMC_PMC_PCER0_PID29_Msk = 0x20000000
	// Bit PID29.
	PMC_PMC_PCER0_PID29 = 0x20000000

	// PMC_PCDR0: Peripheral Clock Disable Register 0
	// Position of PID8 field.
	PMC_PMC_PCDR0_PID8_Pos = 0x8
	// Bit mask of PID8 field.
	PMC_PMC_PCDR0_PID8_Msk = 0x100
	// Bit PID8.
	PMC_PMC_PCDR0_PID8 = 0x100
	// Position of PID9 field.
	PMC_PMC_PCDR0_PID9_Pos = 0x9
	// Bit mask of PID9 field.
	PMC_PMC_PCDR0_PID9_Msk = 0x200
	// Bit PID9.
	PMC_PMC_PCDR0_PID9 = 0x200
	// Position of PID10 field.
	PMC_PMC_PCDR0_PID10_Pos = 0xa
	// Bit mask of PID10 field.
	PMC_PMC_PCDR0_PID10_Msk = 0x400
	// Bit PID10.
	PMC_PMC_PCDR0_PID10 = 0x400
	// Position of PID11 field.
	PMC_PMC_PCDR0_PID11_Pos = 0xb
	// Bit mask of PID11 field.
	PMC_PMC_PCDR0_PID11_Msk = 0x800
	// Bit PID11.
	PMC_PMC_PCDR0_PID11 = 0x800
	// Position of PID12 field.
	PMC_PMC_PCDR0_PID12_Pos = 0xc
	// Bit mask of PID12 field.
	PMC_PMC_PCDR0_PID12_Msk = 0x1000
	// Bit PID12.
	PMC_PMC_PCDR0_PID12 = 0x1000
	// Position of PID13 field.
	PMC_PMC_PCDR0_PID13_Pos = 0xd
	// Bit mask of PID13 field.
	PMC_PMC_PCDR0_PID13_Msk = 0x2000
	// Bit PID13.
	PMC_PMC_PCDR0_PID13 = 0x2000
	// Position of PID14 field.
	PMC_PMC_PCDR0_PID14_Pos = 0xe
	// Bit mask of PID14 field.
	PMC_PMC_PCDR0_PID14_Msk = 0x4000
	// Bit PID14.
	PMC_PMC_PCDR0_PID14 = 0x4000
	// Position of PID15 field.
	PMC_PMC_PCDR0_PID15_Pos = 0xf
	// Bit mask of PID15 field.
	PMC_PMC_PCDR0_PID15_Msk = 0x8000
	// Bit PID15.
	PMC_PMC_PCDR0_PID15 = 0x8000
	// Position of PID16 field.
	PMC_PMC_PCDR0_PID16_Pos = 0x10
	// Bit mask of PID16 field.
	PMC_PMC_PCDR0_PID16_Msk = 0x10000
	// Bit PID16.
	PMC_PMC_PCDR0_PID16 = 0x10000
	// Position of PID18 field.
	PMC_PMC_PCDR0_PID18_Pos = 0x12
	// Bit mask of PID18 field.
	PMC_PMC_PCDR0_PID18_Msk = 0x40000
	// Bit PID18.
	PMC_PMC_PCDR0_PID18 = 0x40000
	// Position of PID19 field.
	PMC_PMC_PCDR0_PID19_Pos = 0x13
	// Bit mask of PID19 field.
	PMC_PMC_PCDR0_PID19_Msk = 0x80000
	// Bit PID19.
	PMC_PMC_PCDR0_PID19 = 0x80000
	// Position of PID20 field.
	PMC_PMC_PCDR0_PID20_Pos = 0x14
	// Bit mask of PID20 field.
	PMC_PMC_PCDR0_PID20_Msk = 0x100000
	// Bit PID20.
	PMC_PMC_PCDR0_PID20 = 0x100000
	// Position of PID21 field.
	PMC_PMC_PCDR0_PID21_Pos = 0x15
	// Bit mask of PID21 field.
	PMC_PMC_PCDR0_PID21_Msk = 0x200000
	// Bit PID21.
	PMC_PMC_PCDR0_PID21 = 0x200000
	// Position of PID22 field.
	PMC_PMC_PCDR0_PID22_Pos = 0x16
	// Bit mask of PID22 field.
	PMC_PMC_PCDR0_PID22_Msk = 0x400000
	// Bit PID22.
	PMC_PMC_PCDR0_PID22 = 0x400000
	// Position of PID23 field.
	PMC_PMC_PCDR0_PID23_Pos = 0x17
	// Bit mask of PID23 field.
	PMC_PMC_PCDR0_PID23_Msk = 0x800000
	// Bit PID23.
	PMC_PMC_PCDR0_PID23 = 0x800000
	// Position of PID24 field.
	PMC_PMC_PCDR0_PID24_Pos = 0x18
	// Bit mask of PID24 field.
	PMC_PMC_PCDR0_PID24_Msk = 0x1000000
	// Bit PID24.
	PMC_PMC_PCDR0_PID24 = 0x1000000
	// Position of PID25 field.
	PMC_PMC_PCDR0_PID25_Pos = 0x19
	// Bit mask of PID25 field.
	PMC_PMC_PCDR0_PID25_Msk = 0x2000000
	// Bit PID25.
	PMC_PMC_PCDR0_PID25 = 0x2000000
	// Position of PID26 field.
	PMC_PMC_PCDR0_PID26_Pos = 0x1a
	// Bit mask of PID26 field.
	PMC_PMC_PCDR0_PID26_Msk = 0x4000000
	// Bit PID26.
	PMC_PMC_PCDR0_PID26 = 0x4000000
	// Position of PID27 field.
	PMC_PMC_PCDR0_PID27_Pos = 0x1b
	// Bit mask of PID27 field.
	PMC_PMC_PCDR0_PID27_Msk = 0x8000000
	// Bit PID27.
	PMC_PMC_PCDR0_PID27 = 0x8000000
	// Position of PID28 field.
	PMC_PMC_PCDR0_PID28_Pos = 0x1c
	// Bit mask of PID28 field.
	PMC_PMC_PCDR0_PID28_Msk = 0x10000000
	// Bit PID28.
	PMC_PMC_PCDR0_PID28 = 0x10000000
	// Position of PID29 field.
	PMC_PMC_PCDR0_PID29_Pos = 0x1d
	// Bit mask of PID29 field.
	PMC_PMC_PCDR0_PID29_Msk = 0x20000000
	// Bit PID29.
	PMC_PMC_PCDR0_PID29 = 0x20000000

	// PMC_PCSR0: Peripheral Clock Status Register 0
	// Position of PID8 field.
	PMC_PMC_PCSR0_PID8_Pos = 0x8
	// Bit mask of PID8 field.
	PMC_PMC_PCSR0_PID8_Msk = 0x100
	// Bit PID8.
	PMC_PMC_PCSR0_PID8 = 0x100
	// Position of PID9 field.
	PMC_PMC_PCSR0_PID9_Pos = 0x9
	// Bit mask of PID9 field.
	PMC_PMC_PCSR0_PID9_Msk = 0x200
	// Bit PID9.
	PMC_PMC_PCSR0_PID9 = 0x200
	// Position of PID10 field.
	PMC_PMC_PCSR0_PID10_Pos = 0xa
	// Bit mask of PID10 field.
	PMC_PMC_PCSR0_PID10_Msk = 0x400
	// Bit PID10.
	PMC_PMC_PCSR0_PID10 = 0x400
	// Position of PID11 field.
	PMC_PMC_PCSR0_PID11_Pos = 0xb
	// Bit mask of PID11 field.
	PMC_PMC_PCSR0_PID11_Msk = 0x800
	// Bit PID11.
	PMC_PMC_PCSR0_PID11 = 0x800
	// Position of PID12 field.
	PMC_PMC_PCSR0_PID12_Pos = 0xc
	// Bit mask of PID12 field.
	PMC_PMC_PCSR0_PID12_Msk = 0x1000
	// Bit PID12.
	PMC_PMC_PCSR0_PID12 = 0x1000
	// Position of PID13 field.
	PMC_PMC_PCSR0_PID13_Pos = 0xd
	// Bit mask of PID13 field.
	PMC_PMC_PCSR0_PID13_Msk = 0x2000
	// Bit PID13.
	PMC_PMC_PCSR0_PID13 = 0x2000
	// Position of PID14 field.
	PMC_PMC_PCSR0_PID14_Pos = 0xe
	// Bit mask of PID14 field.
	PMC_PMC_PCSR0_PID14_Msk = 0x4000
	// Bit PID14.
	PMC_PMC_PCSR0_PID14 = 0x4000
	// Position of PID15 field.
	PMC_PMC_PCSR0_PID15_Pos = 0xf
	// Bit mask of PID15 field.
	PMC_PMC_PCSR0_PID15_Msk = 0x8000
	// Bit PID15.
	PMC_PMC_PCSR0_PID15 = 0x8000
	// Position of PID16 field.
	PMC_PMC_PCSR0_PID16_Pos = 0x10
	// Bit mask of PID16 field.
	PMC_PMC_PCSR0_PID16_Msk = 0x10000
	// Bit PID16.
	PMC_PMC_PCSR0_PID16 = 0x10000
	// Position of PID18 field.
	PMC_PMC_PCSR0_PID18_Pos = 0x12
	// Bit mask of PID18 field.
	PMC_PMC_PCSR0_PID18_Msk = 0x40000
	// Bit PID18.
	PMC_PMC_PCSR0_PID18 = 0x40000
	// Position of PID19 field.
	PMC_PMC_PCSR0_PID19_Pos = 0x13
	// Bit mask of PID19 field.
	PMC_PMC_PCSR0_PID19_Msk = 0x80000
	// Bit PID19.
	PMC_PMC_PCSR0_PID19 = 0x80000
	// Position of PID20 field.
	PMC_PMC_PCSR0_PID20_Pos = 0x14
	// Bit mask of PID20 field.
	PMC_PMC_PCSR0_PID20_Msk = 0x100000
	// Bit PID20.
	PMC_PMC_PCSR0_PID20 = 0x100000
	// Position of PID21 field.
	PMC_PMC_PCSR0_PID21_Pos = 0x15
	// Bit mask of PID21 field.
	PMC_PMC_PCSR0_PID21_Msk = 0x200000
	// Bit PID21.
	PMC_PMC_PCSR0_PID21 = 0x200000
	// Position of PID22 field.
	PMC_PMC_PCSR0_PID22_Pos = 0x16
	// Bit mask of PID22 field.
	PMC_PMC_PCSR0_PID22_Msk = 0x400000
	// Bit PID22.
	PMC_PMC_PCSR0_PID22 = 0x400000
	// Position of PID23 field.
	PMC_PMC_PCSR0_PID23_Pos = 0x17
	// Bit mask of PID23 field.
	PMC_PMC_PCSR0_PID23_Msk = 0x800000
	// Bit PID23.
	PMC_PMC_PCSR0_PID23 = 0x800000
	// Position of PID24 field.
	PMC_PMC_PCSR0_PID24_Pos = 0x18
	// Bit mask of PID24 field.
	PMC_PMC_PCSR0_PID24_Msk = 0x1000000
	// Bit PID24.
	PMC_PMC_PCSR0_PID24 = 0x1000000
	// Position of PID25 field.
	PMC_PMC_PCSR0_PID25_Pos = 0x19
	// Bit mask of PID25 field.
	PMC_PMC_PCSR0_PID25_Msk = 0x2000000
	// Bit PID25.
	PMC_PMC_PCSR0_PID25 = 0x2000000
	// Position of PID26 field.
	PMC_PMC_PCSR0_PID26_Pos = 0x1a
	// Bit mask of PID26 field.
	PMC_PMC_PCSR0_PID26_Msk = 0x4000000
	// Bit PID26.
	PMC_PMC_PCSR0_PID26 = 0x4000000
	// Position of PID27 field.
	PMC_PMC_PCSR0_PID27_Pos = 0x1b
	// Bit mask of PID27 field.
	PMC_PMC_PCSR0_PID27_Msk = 0x8000000
	// Bit PID27.
	PMC_PMC_PCSR0_PID27 = 0x8000000
	// Position of PID28 field.
	PMC_PMC_PCSR0_PID28_Pos = 0x1c
	// Bit mask of PID28 field.
	PMC_PMC_PCSR0_PID28_Msk = 0x10000000
	// Bit PID28.
	PMC_PMC_PCSR0_PID28 = 0x10000000
	// Position of PID29 field.
	PMC_PMC_PCSR0_PID29_Pos = 0x1d
	// Bit mask of PID29 field.
	PMC_PMC_PCSR0_PID29_Msk = 0x20000000
	// Bit PID29.
	PMC_PMC_PCSR0_PID29 = 0x20000000

	// CKGR_UCKR: UTMI Clock Register
	// Position of UPLLEN field.
	PMC_CKGR_UCKR_UPLLEN_Pos = 0x10
	// Bit mask of UPLLEN field.
	PMC_CKGR_UCKR_UPLLEN_Msk = 0x10000
	// Bit UPLLEN.
	PMC_CKGR_UCKR_UPLLEN = 0x10000
	// Position of UPLLCOUNT field.
	PMC_CKGR_UCKR_UPLLCOUNT_Pos = 0x14
	// Bit mask of UPLLCOUNT field.
	PMC_CKGR_UCKR_UPLLCOUNT_Msk = 0xf00000

	// CKGR_MOR: Main Oscillator Register
	// Position of MOSCXTEN field.
	PMC_CKGR_MOR_MOSCXTEN_Pos = 0x0
	// Bit mask of MOSCXTEN field.
	PMC_CKGR_MOR_MOSCXTEN_Msk = 0x1
	// Bit MOSCXTEN.
	PMC_CKGR_MOR_MOSCXTEN = 0x1
	// Position of MOSCXTBY field.
	PMC_CKGR_MOR_MOSCXTBY_Pos = 0x1
	// Bit mask of MOSCXTBY field.
	PMC_CKGR_MOR_MOSCXTBY_Msk = 0x2
	// Bit MOSCXTBY.
	PMC_CKGR_MOR_MOSCXTBY = 0x2
	// Position of MOSCRCEN field.
	PMC_CKGR_MOR_MOSCRCEN_Pos = 0x3
	// Bit mask of MOSCRCEN field.
	PMC_CKGR_MOR_MOSCRCEN_Msk = 0x8
	// Bit MOSCRCEN.
	PMC_CKGR_MOR_MOSCRCEN = 0x8
	// Position of MOSCRCF field.
	PMC_CKGR_MOR_MOSCRCF_Pos = 0x4
	// Bit mask of MOSCRCF field.
	PMC_CKGR_MOR_MOSCRCF_Msk = 0x70
	// The Fast RC Oscillator Frequency is at 4 MHz (default)
	PMC_CKGR_MOR_MOSCRCF_4_MHz = 0x0
	// The Fast RC Oscillator Frequency is at 8 MHz
	PMC_CKGR_MOR_MOSCRCF_8_MHz = 0x1
	// The Fast RC Oscillator Frequency is at 12 MHz
	PMC_CKGR_MOR_MOSCRCF_12_MHz = 0x2
	// Position of MOSCXTST field.
	PMC_CKGR_MOR_MOSCXTST_Pos = 0x8
	// Bit mask of MOSCXTST field.
	PMC_CKGR_MOR_MOSCXTST_Msk = 0xff00
	// Position of KEY field.
	PMC_CKGR_MOR_KEY_Pos = 0x10
	// Bit mask of KEY field.
	PMC_CKGR_MOR_KEY_Msk = 0xff0000
	// Writing any other value in this field aborts the write operation.Always reads as 0.
	PMC_CKGR_MOR_KEY_PASSWD = 0x37
	// Position of MOSCSEL field.
	PMC_CKGR_MOR_MOSCSEL_Pos = 0x18
	// Bit mask of MOSCSEL field.
	PMC_CKGR_MOR_MOSCSEL_Msk = 0x1000000
	// Bit MOSCSEL.
	PMC_CKGR_MOR_MOSCSEL = 0x1000000
	// Position of CFDEN field.
	PMC_CKGR_MOR_CFDEN_Pos = 0x19
	// Bit mask of CFDEN field.
	PMC_CKGR_MOR_CFDEN_Msk = 0x2000000
	// Bit CFDEN.
	PMC_CKGR_MOR_CFDEN = 0x2000000

	// CKGR_MCFR: Main Clock Frequency Register
	// Position of MAINF field.
	PMC_CKGR_MCFR_MAINF_Pos = 0x0
	// Bit mask of MAINF field.
	PMC_CKGR_MCFR_MAINF_Msk = 0xffff
	// Position of MAINFRDY field.
	PMC_CKGR_MCFR_MAINFRDY_Pos = 0x10
	// Bit mask of MAINFRDY field.
	PMC_CKGR_MCFR_MAINFRDY_Msk = 0x10000
	// Bit MAINFRDY.
	PMC_CKGR_MCFR_MAINFRDY = 0x10000

	// CKGR_PLLAR: PLLA Register
	// Position of DIVA field.
	PMC_CKGR_PLLAR_DIVA_Pos = 0x0
	// Bit mask of DIVA field.
	PMC_CKGR_PLLAR_DIVA_Msk = 0xff
	// Position of PLLACOUNT field.
	PMC_CKGR_PLLAR_PLLACOUNT_Pos = 0x8
	// Bit mask of PLLACOUNT field.
	PMC_CKGR_PLLAR_PLLACOUNT_Msk = 0x3f00
	// Position of MULA field.
	PMC_CKGR_PLLAR_MULA_Pos = 0x10
	// Bit mask of MULA field.
	PMC_CKGR_PLLAR_MULA_Msk = 0x7ff0000
	// Position of ONE field.
	PMC_CKGR_PLLAR_ONE_Pos = 0x1d
	// Bit mask of ONE field.
	PMC_CKGR_PLLAR_ONE_Msk = 0x20000000
	// Bit ONE.
	PMC_CKGR_PLLAR_ONE = 0x20000000

	// PMC_MCKR: Master Clock Register
	// Position of CSS field.
	PMC_PMC_MCKR_CSS_Pos = 0x0
	// Bit mask of CSS field.
	PMC_PMC_MCKR_CSS_Msk = 0x3
	// Slow Clock is selected
	PMC_PMC_MCKR_CSS_SLOW_CLK = 0x0
	// Main Clock is selected
	PMC_PMC_MCKR_CSS_MAIN_CLK = 0x1
	// PLLA Clock is selected
	PMC_PMC_MCKR_CSS_PLLA_CLK = 0x2
	// UPLLClock is selected
	PMC_PMC_MCKR_CSS_UPLL_CLK = 0x3
	// Position of PRES field.
	PMC_PMC_MCKR_PRES_Pos = 0x4
	// Bit mask of PRES field.
	PMC_PMC_MCKR_PRES_Msk = 0x70
	// Selected clock
	PMC_PMC_MCKR_PRES_CLK_1 = 0x0
	// Selected clock divided by 2
	PMC_PMC_MCKR_PRES_CLK_2 = 0x1
	// Selected clock divided by 4
	PMC_PMC_MCKR_PRES_CLK_4 = 0x2
	// Selected clock divided by 8
	PMC_PMC_MCKR_PRES_CLK_8 = 0x3
	// Selected clock divided by 16
	PMC_PMC_MCKR_PRES_CLK_16 = 0x4
	// Selected clock divided by 32
	PMC_PMC_MCKR_PRES_CLK_32 = 0x5
	// Selected clock divided by 64
	PMC_PMC_MCKR_PRES_CLK_64 = 0x6
	// Selected clock divided by 3
	PMC_PMC_MCKR_PRES_CLK_3 = 0x7
	// Position of PLLADIV2 field.
	PMC_PMC_MCKR_PLLADIV2_Pos = 0xc
	// Bit mask of PLLADIV2 field.
	PMC_PMC_MCKR_PLLADIV2_Msk = 0x1000
	// Bit PLLADIV2.
	PMC_PMC_MCKR_PLLADIV2 = 0x1000
	// Position of UPLLDIV2 field.
	PMC_PMC_MCKR_UPLLDIV2_Pos = 0xd
	// Bit mask of UPLLDIV2 field.
	PMC_PMC_MCKR_UPLLDIV2_Msk = 0x2000
	// Bit UPLLDIV2.
	PMC_PMC_MCKR_UPLLDIV2 = 0x2000

	// PMC_PCK: Programmable Clock 0 Register
	// Position of CSS field.
	PMC_PMC_PCK_CSS_Pos = 0x0
	// Bit mask of CSS field.
	PMC_PMC_PCK_CSS_Msk = 0x7
	// Slow Clock is selected
	PMC_PMC_PCK_CSS_SLOW_CLK = 0x0
	// Main Clock is selected
	PMC_PMC_PCK_CSS_MAIN_CLK = 0x1
	// PLLA Clock is selected
	PMC_PMC_PCK_CSS_PLLA_CLK = 0x2
	// UPLL Clock is selected
	PMC_PMC_PCK_CSS_UPLL_CLK = 0x3
	// Master Clock is selected
	PMC_PMC_PCK_CSS_MCK = 0x4
	// Position of PRES field.
	PMC_PMC_PCK_PRES_Pos = 0x4
	// Bit mask of PRES field.
	PMC_PMC_PCK_PRES_Msk = 0x70
	// Selected clock
	PMC_PMC_PCK_PRES_CLK_1 = 0x0
	// Selected clock divided by 2
	PMC_PMC_PCK_PRES_CLK_2 = 0x1
	// Selected clock divided by 4
	PMC_PMC_PCK_PRES_CLK_4 = 0x2
	// Selected clock divided by 8
	PMC_PMC_PCK_PRES_CLK_8 = 0x3
	// Selected clock divided by 16
	PMC_PMC_PCK_PRES_CLK_16 = 0x4
	// Selected clock divided by 32
	PMC_PMC_PCK_PRES_CLK_32 = 0x5
	// Selected clock divided by 64
	PMC_PMC_PCK_PRES_CLK_64 = 0x6

	// PMC_IER: Interrupt Enable Register
	// Position of MOSCXTS field.
	PMC_PMC_IER_MOSCXTS_Pos = 0x0
	// Bit mask of MOSCXTS field.
	PMC_PMC_IER_MOSCXTS_Msk = 0x1
	// Bit MOSCXTS.
	PMC_PMC_IER_MOSCXTS = 0x1
	// Position of LOCKA field.
	PMC_PMC_IER_LOCKA_Pos = 0x1
	// Bit mask of LOCKA field.
	PMC_PMC_IER_LOCKA_Msk = 0x2
	// Bit LOCKA.
	PMC_PMC_IER_LOCKA = 0x2
	// Position of MCKRDY field.
	PMC_PMC_IER_MCKRDY_Pos = 0x3
	// Bit mask of MCKRDY field.
	PMC_PMC_IER_MCKRDY_Msk = 0x8
	// Bit MCKRDY.
	PMC_PMC_IER_MCKRDY = 0x8
	// Position of LOCKU field.
	PMC_PMC_IER_LOCKU_Pos = 0x6
	// Bit mask of LOCKU field.
	PMC_PMC_IER_LOCKU_Msk = 0x40
	// Bit LOCKU.
	PMC_PMC_IER_LOCKU = 0x40
	// Position of PCKRDY0 field.
	PMC_PMC_IER_PCKRDY0_Pos = 0x8
	// Bit mask of PCKRDY0 field.
	PMC_PMC_IER_PCKRDY0_Msk = 0x100
	// Bit PCKRDY0.
	PMC_PMC_IER_PCKRDY0 = 0x100
	// Position of PCKRDY1 field.
	PMC_PMC_IER_PCKRDY1_Pos = 0x9
	// Bit mask of PCKRDY1 field.
	PMC_PMC_IER_PCKRDY1_Msk = 0x200
	// Bit PCKRDY1.
	PMC_PMC_IER_PCKRDY1 = 0x200
	// Position of PCKRDY2 field.
	PMC_PMC_IER_PCKRDY2_Pos = 0xa
	// Bit mask of PCKRDY2 field.
	PMC_PMC_IER_PCKRDY2_Msk = 0x400
	// Bit PCKRDY2.
	PMC_PMC_IER_PCKRDY2 = 0x400
	// Position of MOSCSELS field.
	PMC_PMC_IER_MOSCSELS_Pos = 0x10
	// Bit mask of MOSCSELS field.
	PMC_PMC_IER_MOSCSELS_Msk = 0x10000
	// Bit MOSCSELS.
	PMC_PMC_IER_MOSCSELS = 0x10000
	// Position of MOSCRCS field.
	PMC_PMC_IER_MOSCRCS_Pos = 0x11
	// Bit mask of MOSCRCS field.
	PMC_PMC_IER_MOSCRCS_Msk = 0x20000
	// Bit MOSCRCS.
	PMC_PMC_IER_MOSCRCS = 0x20000
	// Position of CFDEV field.
	PMC_PMC_IER_CFDEV_Pos = 0x12
	// Bit mask of CFDEV field.
	PMC_PMC_IER_CFDEV_Msk = 0x40000
	// Bit CFDEV.
	PMC_PMC_IER_CFDEV = 0x40000

	// PMC_IDR: Interrupt Disable Register
	// Position of MOSCXTS field.
	PMC_PMC_IDR_MOSCXTS_Pos = 0x0
	// Bit mask of MOSCXTS field.
	PMC_PMC_IDR_MOSCXTS_Msk = 0x1
	// Bit MOSCXTS.
	PMC_PMC_IDR_MOSCXTS = 0x1
	// Position of LOCKA field.
	PMC_PMC_IDR_LOCKA_Pos = 0x1
	// Bit mask of LOCKA field.
	PMC_PMC_IDR_LOCKA_Msk = 0x2
	// Bit LOCKA.
	PMC_PMC_IDR_LOCKA = 0x2
	// Position of MCKRDY field.
	PMC_PMC_IDR_MCKRDY_Pos = 0x3
	// Bit mask of MCKRDY field.
	PMC_PMC_IDR_MCKRDY_Msk = 0x8
	// Bit MCKRDY.
	PMC_PMC_IDR_MCKRDY = 0x8
	// Position of LOCKU field.
	PMC_PMC_IDR_LOCKU_Pos = 0x6
	// Bit mask of LOCKU field.
	PMC_PMC_IDR_LOCKU_Msk = 0x40
	// Bit LOCKU.
	PMC_PMC_IDR_LOCKU = 0x40
	// Position of PCKRDY0 field.
	PMC_PMC_IDR_PCKRDY0_Pos = 0x8
	// Bit mask of PCKRDY0 field.
	PMC_PMC_IDR_PCKRDY0_Msk = 0x100
	// Bit PCKRDY0.
	PMC_PMC_IDR_PCKRDY0 = 0x100
	// Position of PCKRDY1 field.
	PMC_PMC_IDR_PCKRDY1_Pos = 0x9
	// Bit mask of PCKRDY1 field.
	PMC_PMC_IDR_PCKRDY1_Msk = 0x200
	// Bit PCKRDY1.
	PMC_PMC_IDR_PCKRDY1 = 0x200
	// Position of PCKRDY2 field.
	PMC_PMC_IDR_PCKRDY2_Pos = 0xa
	// Bit mask of PCKRDY2 field.
	PMC_PMC_IDR_PCKRDY2_Msk = 0x400
	// Bit PCKRDY2.
	PMC_PMC_IDR_PCKRDY2 = 0x400
	// Position of MOSCSELS field.
	PMC_PMC_IDR_MOSCSELS_Pos = 0x10
	// Bit mask of MOSCSELS field.
	PMC_PMC_IDR_MOSCSELS_Msk = 0x10000
	// Bit MOSCSELS.
	PMC_PMC_IDR_MOSCSELS = 0x10000
	// Position of MOSCRCS field.
	PMC_PMC_IDR_MOSCRCS_Pos = 0x11
	// Bit mask of MOSCRCS field.
	PMC_PMC_IDR_MOSCRCS_Msk = 0x20000
	// Bit MOSCRCS.
	PMC_PMC_IDR_MOSCRCS = 0x20000
	// Position of CFDEV field.
	PMC_PMC_IDR_CFDEV_Pos = 0x12
	// Bit mask of CFDEV field.
	PMC_PMC_IDR_CFDEV_Msk = 0x40000
	// Bit CFDEV.
	PMC_PMC_IDR_CFDEV = 0x40000

	// PMC_SR: Status Register
	// Position of MOSCXTS field.
	PMC_PMC_SR_MOSCXTS_Pos = 0x0
	// Bit mask of MOSCXTS field.
	PMC_PMC_SR_MOSCXTS_Msk = 0x1
	// Bit MOSCXTS.
	PMC_PMC_SR_MOSCXTS = 0x1
	// Position of LOCKA field.
	PMC_PMC_SR_LOCKA_Pos = 0x1
	// Bit mask of LOCKA field.
	PMC_PMC_SR_LOCKA_Msk = 0x2
	// Bit LOCKA.
	PMC_PMC_SR_LOCKA = 0x2
	// Position of MCKRDY field.
	PMC_PMC_SR_MCKRDY_Pos = 0x3
	// Bit mask of MCKRDY field.
	PMC_PMC_SR_MCKRDY_Msk = 0x8
	// Bit MCKRDY.
	PMC_PMC_SR_MCKRDY = 0x8
	// Position of LOCKU field.
	PMC_PMC_SR_LOCKU_Pos = 0x6
	// Bit mask of LOCKU field.
	PMC_PMC_SR_LOCKU_Msk = 0x40
	// Bit LOCKU.
	PMC_PMC_SR_LOCKU = 0x40
	// Position of OSCSELS field.
	PMC_PMC_SR_OSCSELS_Pos = 0x7
	// Bit mask of OSCSELS field.
	PMC_PMC_SR_OSCSELS_Msk = 0x80
	// Bit OSCSELS.
	PMC_PMC_SR_OSCSELS = 0x80
	// Position of PCKRDY0 field.
	PMC_PMC_SR_PCKRDY0_Pos = 0x8
	// Bit mask of PCKRDY0 field.
	PMC_PMC_SR_PCKRDY0_Msk = 0x100
	// Bit PCKRDY0.
	PMC_PMC_SR_PCKRDY0 = 0x100
	// Position of PCKRDY1 field.
	PMC_PMC_SR_PCKRDY1_Pos = 0x9
	// Bit mask of PCKRDY1 field.
	PMC_PMC_SR_PCKRDY1_Msk = 0x200
	// Bit PCKRDY1.
	PMC_PMC_SR_PCKRDY1 = 0x200
	// Position of PCKRDY2 field.
	PMC_PMC_SR_PCKRDY2_Pos = 0xa
	// Bit mask of PCKRDY2 field.
	PMC_PMC_SR_PCKRDY2_Msk = 0x400
	// Bit PCKRDY2.
	PMC_PMC_SR_PCKRDY2 = 0x400
	// Position of MOSCSELS field.
	PMC_PMC_SR_MOSCSELS_Pos = 0x10
	// Bit mask of MOSCSELS field.
	PMC_PMC_SR_MOSCSELS_Msk = 0x10000
	// Bit MOSCSELS.
	PMC_PMC_SR_MOSCSELS = 0x10000
	// Position of MOSCRCS field.
	PMC_PMC_SR_MOSCRCS_Pos = 0x11
	// Bit mask of MOSCRCS field.
	PMC_PMC_SR_MOSCRCS_Msk = 0x20000
	// Bit MOSCRCS.
	PMC_PMC_SR_MOSCRCS = 0x20000
	// Position of CFDEV field.
	PMC_PMC_SR_CFDEV_Pos = 0x12
	// Bit mask of CFDEV field.
	PMC_PMC_SR_CFDEV_Msk = 0x40000
	// Bit CFDEV.
	PMC_PMC_SR_CFDEV = 0x40000
	// Position of CFDS field.
	PMC_PMC_SR_CFDS_Pos = 0x13
	// Bit mask of CFDS field.
	PMC_PMC_SR_CFDS_Msk = 0x80000
	// Bit CFDS.
	PMC_PMC_SR_CFDS = 0x80000
	// Position of FOS field.
	PMC_PMC_SR_FOS_Pos = 0x14
	// Bit mask of FOS field.
	PMC_PMC_SR_FOS_Msk = 0x100000
	// Bit FOS.
	PMC_PMC_SR_FOS = 0x100000

	// PMC_IMR: Interrupt Mask Register
	// Position of MOSCXTS field.
	PMC_PMC_IMR_MOSCXTS_Pos = 0x0
	// Bit mask of MOSCXTS field.
	PMC_PMC_IMR_MOSCXTS_Msk = 0x1
	// Bit MOSCXTS.
	PMC_PMC_IMR_MOSCXTS = 0x1
	// Position of LOCKA field.
	PMC_PMC_IMR_LOCKA_Pos = 0x1
	// Bit mask of LOCKA field.
	PMC_PMC_IMR_LOCKA_Msk = 0x2
	// Bit LOCKA.
	PMC_PMC_IMR_LOCKA = 0x2
	// Position of MCKRDY field.
	PMC_PMC_IMR_MCKRDY_Pos = 0x3
	// Bit mask of MCKRDY field.
	PMC_PMC_IMR_MCKRDY_Msk = 0x8
	// Bit MCKRDY.
	PMC_PMC_IMR_MCKRDY = 0x8
	// Position of LOCKU field.
	PMC_PMC_IMR_LOCKU_Pos = 0x6
	// Bit mask of LOCKU field.
	PMC_PMC_IMR_LOCKU_Msk = 0x40
	// Bit LOCKU.
	PMC_PMC_IMR_LOCKU = 0x40
	// Position of PCKRDY0 field.
	PMC_PMC_IMR_PCKRDY0_Pos = 0x8
	// Bit mask of PCKRDY0 field.
	PMC_PMC_IMR_PCKRDY0_Msk = 0x100
	// Bit PCKRDY0.
	PMC_PMC_IMR_PCKRDY0 = 0x100
	// Position of PCKRDY1 field.
	PMC_PMC_IMR_PCKRDY1_Pos = 0x9
	// Bit mask of PCKRDY1 field.
	PMC_PMC_IMR_PCKRDY1_Msk = 0x200
	// Bit PCKRDY1.
	PMC_PMC_IMR_PCKRDY1 = 0x200
	// Position of PCKRDY2 field.
	PMC_PMC_IMR_PCKRDY2_Pos = 0xa
	// Bit mask of PCKRDY2 field.
	PMC_PMC_IMR_PCKRDY2_Msk = 0x400
	// Bit PCKRDY2.
	PMC_PMC_IMR_PCKRDY2 = 0x400
	// Position of MOSCSELS field.
	PMC_PMC_IMR_MOSCSELS_Pos = 0x10
	// Bit mask of MOSCSELS field.
	PMC_PMC_IMR_MOSCSELS_Msk = 0x10000
	// Bit MOSCSELS.
	PMC_PMC_IMR_MOSCSELS = 0x10000
	// Position of MOSCRCS field.
	PMC_PMC_IMR_MOSCRCS_Pos = 0x11
	// Bit mask of MOSCRCS field.
	PMC_PMC_IMR_MOSCRCS_Msk = 0x20000
	// Bit MOSCRCS.
	PMC_PMC_IMR_MOSCRCS = 0x20000
	// Position of CFDEV field.
	PMC_PMC_IMR_CFDEV_Pos = 0x12
	// Bit mask of CFDEV field.
	PMC_PMC_IMR_CFDEV_Msk = 0x40000
	// Bit CFDEV.
	PMC_PMC_IMR_CFDEV = 0x40000

	// PMC_FSMR: Fast Start-up Mode Register
	// Position of FSTT0 field.
	PMC_PMC_FSMR_FSTT0_Pos = 0x0
	// Bit mask of FSTT0 field.
	PMC_PMC_FSMR_FSTT0_Msk = 0x1
	// Bit FSTT0.
	PMC_PMC_FSMR_FSTT0 = 0x1
	// Position of FSTT1 field.
	PMC_PMC_FSMR_FSTT1_Pos = 0x1
	// Bit mask of FSTT1 field.
	PMC_PMC_FSMR_FSTT1_Msk = 0x2
	// Bit FSTT1.
	PMC_PMC_FSMR_FSTT1 = 0x2
	// Position of FSTT2 field.
	PMC_PMC_FSMR_FSTT2_Pos = 0x2
	// Bit mask of FSTT2 field.
	PMC_PMC_FSMR_FSTT2_Msk = 0x4
	// Bit FSTT2.
	PMC_PMC_FSMR_FSTT2 = 0x4
	// Position of FSTT3 field.
	PMC_PMC_FSMR_FSTT3_Pos = 0x3
	// Bit mask of FSTT3 field.
	PMC_PMC_FSMR_FSTT3_Msk = 0x8
	// Bit FSTT3.
	PMC_PMC_FSMR_FSTT3 = 0x8
	// Position of FSTT4 field.
	PMC_PMC_FSMR_FSTT4_Pos = 0x4
	// Bit mask of FSTT4 field.
	PMC_PMC_FSMR_FSTT4_Msk = 0x10
	// Bit FSTT4.
	PMC_PMC_FSMR_FSTT4 = 0x10
	// Position of FSTT5 field.
	PMC_PMC_FSMR_FSTT5_Pos = 0x5
	// Bit mask of FSTT5 field.
	PMC_PMC_FSMR_FSTT5_Msk = 0x20
	// Bit FSTT5.
	PMC_PMC_FSMR_FSTT5 = 0x20
	// Position of FSTT6 field.
	PMC_PMC_FSMR_FSTT6_Pos = 0x6
	// Bit mask of FSTT6 field.
	PMC_PMC_FSMR_FSTT6_Msk = 0x40
	// Bit FSTT6.
	PMC_PMC_FSMR_FSTT6 = 0x40
	// Position of FSTT7 field.
	PMC_PMC_FSMR_FSTT7_Pos = 0x7
	// Bit mask of FSTT7 field.
	PMC_PMC_FSMR_FSTT7_Msk = 0x80
	// Bit FSTT7.
	PMC_PMC_FSMR_FSTT7 = 0x80
	// Position of FSTT8 field.
	PMC_PMC_FSMR_FSTT8_Pos = 0x8
	// Bit mask of FSTT8 field.
	PMC_PMC_FSMR_FSTT8_Msk = 0x100
	// Bit FSTT8.
	PMC_PMC_FSMR_FSTT8 = 0x100
	// Position of FSTT9 field.
	PMC_PMC_FSMR_FSTT9_Pos = 0x9
	// Bit mask of FSTT9 field.
	PMC_PMC_FSMR_FSTT9_Msk = 0x200
	// Bit FSTT9.
	PMC_PMC_FSMR_FSTT9 = 0x200
	// Position of FSTT10 field.
	PMC_PMC_FSMR_FSTT10_Pos = 0xa
	// Bit mask of FSTT10 field.
	PMC_PMC_FSMR_FSTT10_Msk = 0x400
	// Bit FSTT10.
	PMC_PMC_FSMR_FSTT10 = 0x400
	// Position of FSTT11 field.
	PMC_PMC_FSMR_FSTT11_Pos = 0xb
	// Bit mask of FSTT11 field.
	PMC_PMC_FSMR_FSTT11_Msk = 0x800
	// Bit FSTT11.
	PMC_PMC_FSMR_FSTT11 = 0x800
	// Position of FSTT12 field.
	PMC_PMC_FSMR_FSTT12_Pos = 0xc
	// Bit mask of FSTT12 field.
	PMC_PMC_FSMR_FSTT12_Msk = 0x1000
	// Bit FSTT12.
	PMC_PMC_FSMR_FSTT12 = 0x1000
	// Position of FSTT13 field.
	PMC_PMC_FSMR_FSTT13_Pos = 0xd
	// Bit mask of FSTT13 field.
	PMC_PMC_FSMR_FSTT13_Msk = 0x2000
	// Bit FSTT13.
	PMC_PMC_FSMR_FSTT13 = 0x2000
	// Position of FSTT14 field.
	PMC_PMC_FSMR_FSTT14_Pos = 0xe
	// Bit mask of FSTT14 field.
	PMC_PMC_FSMR_FSTT14_Msk = 0x4000
	// Bit FSTT14.
	PMC_PMC_FSMR_FSTT14 = 0x4000
	// Position of FSTT15 field.
	PMC_PMC_FSMR_FSTT15_Pos = 0xf
	// Bit mask of FSTT15 field.
	PMC_PMC_FSMR_FSTT15_Msk = 0x8000
	// Bit FSTT15.
	PMC_PMC_FSMR_FSTT15 = 0x8000
	// Position of RTTAL field.
	PMC_PMC_FSMR_RTTAL_Pos = 0x10
	// Bit mask of RTTAL field.
	PMC_PMC_FSMR_RTTAL_Msk = 0x10000
	// Bit RTTAL.
	PMC_PMC_FSMR_RTTAL = 0x10000
	// Position of RTCAL field.
	PMC_PMC_FSMR_RTCAL_Pos = 0x11
	// Bit mask of RTCAL field.
	PMC_PMC_FSMR_RTCAL_Msk = 0x20000
	// Bit RTCAL.
	PMC_PMC_FSMR_RTCAL = 0x20000
	// Position of USBAL field.
	PMC_PMC_FSMR_USBAL_Pos = 0x12
	// Bit mask of USBAL field.
	PMC_PMC_FSMR_USBAL_Msk = 0x40000
	// Bit USBAL.
	PMC_PMC_FSMR_USBAL = 0x40000
	// Position of LPM field.
	PMC_PMC_FSMR_LPM_Pos = 0x14
	// Bit mask of LPM field.
	PMC_PMC_FSMR_LPM_Msk = 0x100000
	// Bit LPM.
	PMC_PMC_FSMR_LPM = 0x100000

	// PMC_FSPR: Fast Start-up Polarity Register
	// Position of FSTP0 field.
	PMC_PMC_FSPR_FSTP0_Pos = 0x0
	// Bit mask of FSTP0 field.
	PMC_PMC_FSPR_FSTP0_Msk = 0x1
	// Bit FSTP0.
	PMC_PMC_FSPR_FSTP0 = 0x1
	// Position of FSTP1 field.
	PMC_PMC_FSPR_FSTP1_Pos = 0x1
	// Bit mask of FSTP1 field.
	PMC_PMC_FSPR_FSTP1_Msk = 0x2
	// Bit FSTP1.
	PMC_PMC_FSPR_FSTP1 = 0x2
	// Position of FSTP2 field.
	PMC_PMC_FSPR_FSTP2_Pos = 0x2
	// Bit mask of FSTP2 field.
	PMC_PMC_FSPR_FSTP2_Msk = 0x4
	// Bit FSTP2.
	PMC_PMC_FSPR_FSTP2 = 0x4
	// Position of FSTP3 field.
	PMC_PMC_FSPR_FSTP3_Pos = 0x3
	// Bit mask of FSTP3 field.
	PMC_PMC_FSPR_FSTP3_Msk = 0x8
	// Bit FSTP3.
	PMC_PMC_FSPR_FSTP3 = 0x8
	// Position of FSTP4 field.
	PMC_PMC_FSPR_FSTP4_Pos = 0x4
	// Bit mask of FSTP4 field.
	PMC_PMC_FSPR_FSTP4_Msk = 0x10
	// Bit FSTP4.
	PMC_PMC_FSPR_FSTP4 = 0x10
	// Position of FSTP5 field.
	PMC_PMC_FSPR_FSTP5_Pos = 0x5
	// Bit mask of FSTP5 field.
	PMC_PMC_FSPR_FSTP5_Msk = 0x20
	// Bit FSTP5.
	PMC_PMC_FSPR_FSTP5 = 0x20
	// Position of FSTP6 field.
	PMC_PMC_FSPR_FSTP6_Pos = 0x6
	// Bit mask of FSTP6 field.
	PMC_PMC_FSPR_FSTP6_Msk = 0x40
	// Bit FSTP6.
	PMC_PMC_FSPR_FSTP6 = 0x40
	// Position of FSTP7 field.
	PMC_PMC_FSPR_FSTP7_Pos = 0x7
	// Bit mask of FSTP7 field.
	PMC_PMC_FSPR_FSTP7_Msk = 0x80
	// Bit FSTP7.
	PMC_PMC_FSPR_FSTP7 = 0x80
	// Position of FSTP8 field.
	PMC_PMC_FSPR_FSTP8_Pos = 0x8
	// Bit mask of FSTP8 field.
	PMC_PMC_FSPR_FSTP8_Msk = 0x100
	// Bit FSTP8.
	PMC_PMC_FSPR_FSTP8 = 0x100
	// Position of FSTP9 field.
	PMC_PMC_FSPR_FSTP9_Pos = 0x9
	// Bit mask of FSTP9 field.
	PMC_PMC_FSPR_FSTP9_Msk = 0x200
	// Bit FSTP9.
	PMC_PMC_FSPR_FSTP9 = 0x200
	// Position of FSTP10 field.
	PMC_PMC_FSPR_FSTP10_Pos = 0xa
	// Bit mask of FSTP10 field.
	PMC_PMC_FSPR_FSTP10_Msk = 0x400
	// Bit FSTP10.
	PMC_PMC_FSPR_FSTP10 = 0x400
	// Position of FSTP11 field.
	PMC_PMC_FSPR_FSTP11_Pos = 0xb
	// Bit mask of FSTP11 field.
	PMC_PMC_FSPR_FSTP11_Msk = 0x800
	// Bit FSTP11.
	PMC_PMC_FSPR_FSTP11 = 0x800
	// Position of FSTP12 field.
	PMC_PMC_FSPR_FSTP12_Pos = 0xc
	// Bit mask of FSTP12 field.
	PMC_PMC_FSPR_FSTP12_Msk = 0x1000
	// Bit FSTP12.
	PMC_PMC_FSPR_FSTP12 = 0x1000
	// Position of FSTP13 field.
	PMC_PMC_FSPR_FSTP13_Pos = 0xd
	// Bit mask of FSTP13 field.
	PMC_PMC_FSPR_FSTP13_Msk = 0x2000
	// Bit FSTP13.
	PMC_PMC_FSPR_FSTP13 = 0x2000
	// Position of FSTP14 field.
	PMC_PMC_FSPR_FSTP14_Pos = 0xe
	// Bit mask of FSTP14 field.
	PMC_PMC_FSPR_FSTP14_Msk = 0x4000
	// Bit FSTP14.
	PMC_PMC_FSPR_FSTP14 = 0x4000
	// Position of FSTP15 field.
	PMC_PMC_FSPR_FSTP15_Pos = 0xf
	// Bit mask of FSTP15 field.
	PMC_PMC_FSPR_FSTP15_Msk = 0x8000
	// Bit FSTP15.
	PMC_PMC_FSPR_FSTP15 = 0x8000

	// PMC_FOCR: Fault Output Clear Register
	// Position of FOCLR field.
	PMC_PMC_FOCR_FOCLR_Pos = 0x0
	// Bit mask of FOCLR field.
	PMC_PMC_FOCR_FOCLR_Msk = 0x1
	// Bit FOCLR.
	PMC_PMC_FOCR_FOCLR = 0x1

	// PMC_WPMR: Write Protect Mode Register
	// Position of WPEN field.
	PMC_PMC_WPMR_WPEN_Pos = 0x0
	// Bit mask of WPEN field.
	PMC_PMC_WPMR_WPEN_Msk = 0x1
	// Bit WPEN.
	PMC_PMC_WPMR_WPEN = 0x1
	// Position of WPKEY field.
	PMC_PMC_WPMR_WPKEY_Pos = 0x8
	// Bit mask of WPKEY field.
	PMC_PMC_WPMR_WPKEY_Msk = 0xffffff00
	// Writing any other value in this field aborts the write operation of the WPEN bit. Always reads as 0.
	PMC_PMC_WPMR_WPKEY_PASSWD = 0x504d43

	// PMC_WPSR: Write Protect Status Register
	// Position of WPVS field.
	PMC_PMC_WPSR_WPVS_Pos = 0x0
	// Bit mask of WPVS field.
	PMC_PMC_WPSR_WPVS_Msk = 0x1
	// Bit WPVS.
	PMC_PMC_WPSR_WPVS = 0x1
	// Position of WPVSRC field.
	PMC_PMC_WPSR_WPVSRC_Pos = 0x8
	// Bit mask of WPVSRC field.
	PMC_PMC_WPSR_WPVSRC_Msk = 0xffff00
)

// Bitfields for UART: Universal Asynchronous Receiver Transmitter
const (
	// CR: Control Register
	// Position of RSTRX field.
	UART_CR_RSTRX_Pos = 0x2
	// Bit mask of RSTRX field.
	UART_CR_RSTRX_Msk = 0x4
	// Bit RSTRX.
	UART_CR_RSTRX = 0x4
	// Position of RSTTX field.
	UART_CR_RSTTX_Pos = 0x3
	// Bit mask of RSTTX field.
	UART_CR_RSTTX_Msk = 0x8
	// Bit RSTTX.
	UART_CR_RSTTX = 0x8
	// Position of RXEN field.
	UART_CR_RXEN_Pos = 0x4
	// Bit mask of RXEN field.
	UART_CR_RXEN_Msk = 0x10
	// Bit RXEN.
	UART_CR_RXEN = 0x10
	// Position of RXDIS field.
	UART_CR_RXDIS_Pos = 0x5
	// Bit mask of RXDIS field.
	UART_CR_RXDIS_Msk = 0x20
	// Bit RXDIS.
	UART_CR_RXDIS = 0x20
	// Position of TXEN field.
	UART_CR_TXEN_Pos = 0x6
	// Bit mask of TXEN field.
	UART_CR_TXEN_Msk = 0x40
	// Bit TXEN.
	UART_CR_TXEN = 0x40
	// Position of TXDIS field.
	UART_CR_TXDIS_Pos = 0x7
	// Bit mask of TXDIS field.
	UART_CR_TXDIS_Msk = 0x80
	// Bit TXDIS.
	UART_CR_TXDIS = 0x80
	// Position of RSTSTA field.
	UART_CR_RSTSTA_Pos = 0x8
	// Bit mask of RSTSTA field.
	UART_CR_RSTSTA_Msk = 0x100
	// Bit RSTSTA.
	UART_CR_RSTSTA = 0x100

	// MR: Mode Register
	// Position of PAR field.
	UART_MR_PAR_Pos = 0x9
	// Bit mask of PAR field.
	UART_MR_PAR_Msk = 0xe00
	// Even Parity
	UART_MR_PAR_EVEN = 0x0
	// Odd Parity
	UART_MR_PAR_ODD = 0x1
	// Space: parity forced to 0
	UART_MR_PAR_SPACE = 0x2
	// Mark: parity forced to 1
	UART_MR_PAR_MARK = 0x3
	// No Parity
	UART_MR_PAR_NO = 0x4
	// Position of CHMODE field.
	UART_MR_CHMODE_Pos = 0xe
	// Bit mask of CHMODE field.
	UART_MR_CHMODE_Msk = 0xc000
	// Normal Mode
	UART_MR_CHMODE_NORMAL = 0x0
	// Automatic Echo
	UART_MR_CHMODE_AUTOMATIC = 0x1
	// Local Loopback
	UART_MR_CHMODE_LOCAL_LOOPBACK = 0x2
	// Remote Loopback
	UART_MR_CHMODE_REMOTE_LOOPBACK = 0x3

	// IER: Interrupt Enable Register
	// Position of RXRDY field.
	UART_IER_RXRDY_Pos = 0x0
	// Bit mask of RXRDY field.
	UART_IER_RXRDY_Msk = 0x1
	// Bit RXRDY.
	UART_IER_RXRDY = 0x1
	// Position of TXRDY field.
	UART_IER_TXRDY_Pos = 0x1
	// Bit mask of TXRDY field.
	UART_IER_TXRDY_Msk = 0x2
	// Bit TXRDY.
	UART_IER_TXRDY = 0x2
	// Position of ENDRX field.
	UART_IER_ENDRX_Pos = 0x3
	// Bit mask of ENDRX field.
	UART_IER_ENDRX_Msk = 0x8
	// Bit ENDRX.
	UART_IER_ENDRX = 0x8
	// Position of ENDTX field.
	UART_IER_ENDTX_Pos = 0x4
	// Bit mask of ENDTX field.
	UART_IER_ENDTX_Msk = 0x10
	// Bit ENDTX.
	UART_IER_ENDTX = 0x10
	// Position of OVRE field.
	UART_IER_OVRE_Pos = 0x5
	// Bit mask of OVRE field.
	UART_IER_OVRE_Msk = 0x20
	// Bit OVRE.
	UART_IER_OVRE = 0x20
	// Position of FRAME field.
	UART_IER_FRAME_Pos = 0x6
	// Bit mask of FRAME field.
	UART_IER_FRAME_Msk = 0x40
	// Bit FRAME.
	UART_IER_FRAME = 0x40
	// Position of PARE field.
	UART_IER_PARE_Pos = 0x7
	// Bit mask of PARE field.
	UART_IER_PARE_Msk = 0x80
	// Bit PARE.
	UART_IER_PARE = 0x80
	// Position of TXEMPTY field.
	UART_IER_TXEMPTY_Pos = 0x9
	// Bit mask of TXEMPTY field.
	UART_IER_TXEMPTY_Msk = 0x200
	// Bit TXEMPTY.
	UART_IER_TXEMPTY = 0x200
	// Position of TXBUFE field.
	UART_IER_TXBUFE_Pos = 0xb
	// Bit mask of TXBUFE field.
	UART_IER_TXBUFE_Msk = 0x800
	// Bit TXBUFE.
	UART_IER_TXBUFE = 0x800
	// Position of RXBUFF field.
	UART_IER_RXBUFF_Pos = 0xc
	// Bit mask of RXBUFF field.
	UART_IER_RXBUFF_Msk = 0x1000
	// Bit RXBUFF.
	UART_IER_RXBUFF = 0x1000

	// IDR: Interrupt Disable Register
	// Position of RXRDY field.
	UART_IDR_RXRDY_Pos = 0x0
	// Bit mask of RXRDY field.
	UART_IDR_RXRDY_Msk = 0x1
	// Bit RXRDY.
	UART_IDR_RXRDY = 0x1
	// Position of TXRDY field.
	UART_IDR_TXRDY_Pos = 0x1
	// Bit mask of TXRDY field.
	UART_IDR_TXRDY_Msk = 0x2
	// Bit TXRDY.
	UART_IDR_TXRDY = 0x2
	// Position of ENDRX field.
	UART_IDR_ENDRX_Pos = 0x3
	// Bit mask of ENDRX field.
	UART_IDR_ENDRX_Msk = 0x8
	// Bit ENDRX.
	UART_IDR_ENDRX = 0x8
	// Position of ENDTX field.
	UART_IDR_ENDTX_Pos = 0x4
	// Bit mask of ENDTX field.
	UART_IDR_ENDTX_Msk = 0x10
	// Bit ENDTX.
	UART_IDR_ENDTX = 0x10
	// Position of OVRE field.
	UART_IDR_OVRE_Pos = 0x5
	// Bit mask of OVRE field.
	UART_IDR_OVRE_Msk = 0x20
	// Bit OVRE.
	UART_IDR_OVRE = 0x20
	// Position of FRAME field.
	UART_IDR_FRAME_Pos = 0x6
	// Bit mask of FRAME field.
	UART_IDR_FRAME_Msk = 0x40
	// Bit FRAME.
	UART_IDR_FRAME = 0x40
	// Position of PARE field.
	UART_IDR_PARE_Pos = 0x7
	// Bit mask of PARE field.
	UART_IDR_PARE_Msk = 0x80
	// Bit PARE.
	UART_IDR_PARE = 0x80
	// Position of TXEMPTY field.
	UART_IDR_TXEMPTY_Pos = 0x9
	// Bit mask of TXEMPTY field.
	UART_IDR_TXEMPTY_Msk = 0x200
	// Bit TXEMPTY.
	UART_IDR_TXEMPTY = 0x200
	// Position of TXBUFE field.
	UART_IDR_TXBUFE_Pos = 0xb
	// Bit mask of TXBUFE field.
	UART_IDR_TXBUFE_Msk = 0x800
	// Bit TXBUFE.
	UART_IDR_TXBUFE = 0x800
	// Position of RXBUFF field.
	UART_IDR_RXBUFF_Pos = 0xc
	// Bit mask of RXBUFF field.
	UART_IDR_RXBUFF_Msk = 0x1000
	// Bit RXBUFF.
	UART_IDR_RXBUFF = 0x1000

	// IMR: Interrupt Mask Register
	// Position of RXRDY field.
	UART_IMR_RXRDY_Pos = 0x0
	// Bit mask of RXRDY field.
	UART_IMR_RXRDY_Msk = 0x1
	// Bit RXRDY.
	UART_IMR_RXRDY = 0x1
	// Position of TXRDY field.
	UART_IMR_TXRDY_Pos = 0x1
	// Bit mask of TXRDY field.
	UART_IMR_TXRDY_Msk = 0x2
	// Bit TXRDY.
	UART_IMR_TXRDY = 0x2
	// Position of ENDRX field.
	UART_IMR_ENDRX_Pos = 0x3
	// Bit mask of ENDRX field.
	UART_IMR_ENDRX_Msk = 0x8
	// Bit ENDRX.
	UART_IMR_ENDRX = 0x8
	// Position of ENDTX field.
	UART_IMR_ENDTX_Pos = 0x4
	// Bit mask of ENDTX field.
	UART_IMR_ENDTX_Msk = 0x10
	// Bit ENDTX.
	UART_IMR_ENDTX = 0x10
	// Position of OVRE field.
	UART_IMR_OVRE_Pos = 0x5
	// Bit mask of OVRE field.
	UART_IMR_OVRE_Msk = 0x20
	// Bit OVRE.
	UART_IMR_OVRE = 0x20
	// Position of FRAME field.
	UART_IMR_FRAME_Pos = 0x6
	// Bit mask of FRAME field.
	UART_IMR_FRAME_Msk = 0x40
	// Bit FRAME.
	UART_IMR_FRAME = 0x40
	// Position of PARE field.
	UART_IMR_PARE_Pos = 0x7
	// Bit mask of PARE field.
	UART_IMR_PARE_Msk = 0x80
	// Bit PARE.
	UART_IMR_PARE = 0x80
	// Position of TXEMPTY field.
	UART_IMR_TXEMPTY_Pos = 0x9
	// Bit mask of TXEMPTY field.
	UART_IMR_TXEMPTY_Msk = 0x200
	// Bit TXEMPTY.
	UART_IMR_TXEMPTY = 0x200
	// Position of TXBUFE field.
	UART_IMR_TXBUFE_Pos = 0xb
	// Bit mask of TXBUFE field.
	UART_IMR_TXBUFE_Msk = 0x800
	// Bit TXBUFE.
	UART_IMR_TXBUFE = 0x800
	// Position of RXBUFF field.
	UART_IMR_RXBUFF_Pos = 0xc
	// Bit mask of RXBUFF field.
	UART_IMR_RXBUFF_Msk = 0x1000
	// Bit RXBUFF.
	UART_IMR_RXBUFF = 0x1000

	// SR: Status Register
	// Position of RXRDY field.
	UART_SR_RXRDY_Pos = 0x0
	// Bit mask of RXRDY field.
	UART_SR_RXRDY_Msk = 0x1
	// Bit RXRDY.
	UART_SR_RXRDY = 0x1
	// Position of TXRDY field.
	UART_SR_TXRDY_Pos = 0x1
	// Bit mask of TXRDY field.
	UART_SR_TXRDY_Msk = 0x2
	// Bit TXRDY.
	UART_SR_TXRDY = 0x2
	// Position of ENDRX field.
	UART_SR_ENDRX_Pos = 0x3
	// Bit mask of ENDRX field.
	UART_SR_ENDRX_Msk = 0x8
	// Bit ENDRX.
	UART_SR_ENDRX = 0x8
	// Position of ENDTX field.
	UART_SR_ENDTX_Pos = 0x4
	// Bit mask of ENDTX field.
	UART_SR_ENDTX_Msk = 0x10
	// Bit ENDTX.
	UART_SR_ENDTX = 0x10
	// Position of OVRE field.
	UART_SR_OVRE_Pos = 0x5
	// Bit mask of OVRE field.
	UART_SR_OVRE_Msk = 0x20
	// Bit OVRE.
	UART_SR_OVRE = 0x20
	// Position of FRAME field.
	UART_SR_FRAME_Pos = 0x6
	// Bit mask of FRAME field.
	UART_SR_FRAME_Msk = 0x40
	// Bit FRAME.
	UART_SR_FRAME = 0x40
	// Position of PARE field.
	UART_SR_PARE_Pos = 0x7
	// Bit mask of PARE field.
	UART_SR_PARE_Msk = 0x80
	// Bit PARE.
	UART_SR_PARE = 0x80
	// Position of TXEMPTY field.
	UART_SR_TXEMPTY_Pos = 0x9
	// Bit mask of TXEMPTY field.
	UART_SR_TXEMPTY_Msk = 0x200
	// Bit TXEMPTY.
	UART_SR_TXEMPTY = 0x200
	// Position of TXBUFE field.
	UART_SR_TXBUFE_Pos = 0xb
	// Bit mask of TXBUFE field.
	UART_SR_TXBUFE_Msk = 0x800
	// Bit TXBUFE.
	UART_SR_TXBUFE = 0x800
	// Position of RXBUFF field.
	UART_SR_RXBUFF_Pos = 0xc
	// Bit mask of RXBUFF field.
	UART_SR_RXBUFF_Msk = 0x1000
	// Bit RXBUFF.
	UART_SR_RXBUFF = 0x1000

	// RHR: Receive Holding Register
	// Position of RXCHR field.
	UART_RHR_RXCHR_Pos = 0x0
	// Bit mask of RXCHR field.
	UART_RHR_RXCHR_Msk = 0xff

	// THR: Transmit Holding Register
	// Position of TXCHR field.
	UART_THR_TXCHR_Pos = 0x0
	// Bit mask of TXCHR field.
	UART_THR_TXCHR_Msk = 0xff

	// BRGR: Baud Rate Generator Register
	// Position of CD field.
	UART_BRGR_CD_Pos = 0x0
	// Bit mask of CD field.
	UART_BRGR_CD_Msk = 0xffff

	// RPR: Receive Pointer Register
	// Position of RXPTR field.
	UART_RPR_RXPTR_Pos = 0x0
	// Bit mask of RXPTR field.
	UART_RPR_RXPTR_Msk = 0xffffffff

	// RCR: Receive Counter Register
	// Position of RXCTR field.
	UART_RCR_RXCTR_Pos = 0x0
	// Bit mask of RXCTR field.
	UART_RCR_RXCTR_Msk = 0xffff

	// TPR: Transmit Pointer Register
	// Position of TXPTR field.
	UART_TPR_TXPTR_Pos = 0x0
	// Bit mask of TXPTR field.
	UART_TPR_TXPTR_Msk = 0xffffffff

	// TCR: Transmit Counter Register
	// Position of TXCTR field.
	UART_TCR_TXCTR_Pos = 0x0
	// Bit mask of TXCTR field.
	UART_TCR_TXCTR_Msk = 0xffff

	// RNPR: Receive Next Pointer Register
	// Position of RXNPTR field.
	UART_RNPR_RXNPTR_Pos = 0x0
	// Bit mask of RXNPTR field.
	UART_RNPR_RXNPTR_Msk = 0xffffffff

	// RNCR: Receive Next Counter Register
	// Position of RXNCTR field.
	UART_RNCR_RXNCTR_Pos = 0x0
	// Bit mask of RXNCTR field.
	UART_RNCR_RXNCTR_Msk = 0xffff

	// TNPR: Transmit Next Pointer Register
	// Position of TXNPTR field.
	UART_TNPR_TXNPTR_Pos = 0x0
	// Bit mask of TXNPTR field.
	UART_TNPR_TXNPTR_Msk = 0xffffffff

	// TNCR: Transmit Next Counter Register
	// Position of TXNCTR field.
	UART_TNCR_TXNCTR_Pos = 0x0
	// Bit mask of TXNCTR field.
	UART_TNCR_TXNCTR_Msk = 0xffff

	// PTCR: Transfer Control Register
	// Position of RXTEN field.
	UART_PTCR_RXTEN_Pos = 0x0
	// Bit mask of RXTEN field.
	UART_PTCR_RXTEN_Msk = 0x1
	// Bit RXTEN.
	UART_PTCR_RXTEN = 0x1
	// Position of RXTDIS field.
	UART_PTCR_RXTDIS_Pos = 0x1
	// Bit mask of RXTDIS field.
	UART_PTCR_RXTDIS_Msk = 0x2
	// Bit RXTDIS.
	UART_PTCR_RXTDIS = 0x2
	// Position of TXTEN field.
	UART_PTCR_TXTEN_Pos = 0x8
	// Bit mask of TXTEN field.
	UART_PTCR_TXTEN_Msk = 0x100
	// Bit TXTEN.
	UART_PTCR_TXTEN = 0x100
	// Position of TXTDIS field.
	UART_PTCR_TXTDIS_Pos = 0x9
	// Bit mask of TXTDIS field.
	UART_PTCR_TXTDIS_Msk = 0x200
	// Bit TXTDIS.
	UART_PTCR_TXTDIS = 0x200

	// PTSR: Transfer Status Register
	// Position of RXTEN field.
	UART_PTSR_RXTEN_Pos = 0x0
	// Bit mask of RXTEN field.
	UART_PTSR_RXTEN_Msk = 0x1
	// Bit RXTEN.
	UART_PTSR_RXTEN = 0x1
	// Position of TXTEN field.
	UART_PTSR_TXTEN_Pos = 0x8
	// Bit mask of TXTEN field.
	UART_PTSR_TXTEN_Msk = 0x100
	// Bit TXTEN.
	UART_PTSR_TXTEN = 0x100
)

// Bitfields for CHIPID: Chip Identifier
const (
	// CIDR: Chip ID Register
	// Position of VERSION field.
	CHIPID_CIDR_VERSION_Pos = 0x0
	// Bit mask of VERSION field.
	CHIPID_CIDR_VERSION_Msk = 0x1f
	// Position of EPROC field.
	CHIPID_CIDR_EPROC_Pos = 0x5
	// Bit mask of EPROC field.
	CHIPID_CIDR_EPROC_Msk = 0xe0
	// ARM946ES
	CHIPID_CIDR_EPROC_ARM946ES = 0x1
	// ARM7TDMI
	CHIPID_CIDR_EPROC_ARM7TDMI = 0x2
	// Cortex-M3
	CHIPID_CIDR_EPROC_CM3 = 0x3
	// ARM920T
	CHIPID_CIDR_EPROC_ARM920T = 0x4
	// ARM926EJS
	CHIPID_CIDR_EPROC_ARM926EJS = 0x5
	// Cortex-A5
	CHIPID_CIDR_EPROC_CA5 = 0x6
	// Cortex-M4
	CHIPID_CIDR_EPROC_CM4 = 0x7
	// Position of NVPSIZ field.
	CHIPID_CIDR_NVPSIZ_Pos = 0x8
	// Bit mask of NVPSIZ field.
	CHIPID_CIDR_NVPSIZ_Msk = 0xf00
	// None
	CHIPID_CIDR_NVPSIZ_NONE = 0x0
	// 8 Kbytes
	CHIPID_CIDR_NVPSIZ_8K = 0x1
	// 16 Kbytes
	CHIPID_CIDR_NVPSIZ_16K = 0x2
	// 32 Kbytes
	CHIPID_CIDR_NVPSIZ_32K = 0x3
	// 64 Kbytes
	CHIPID_CIDR_NVPSIZ_64K = 0x5
	// 128 Kbytes
	CHIPID_CIDR_NVPSIZ_128K = 0x7
	// 256 Kbytes
	CHIPID_CIDR_NVPSIZ_256K = 0x9
	// 512 Kbytes
	CHIPID_CIDR_NVPSIZ_512K = 0xa
	// 1024 Kbytes
	CHIPID_CIDR_NVPSIZ_1024K = 0xc
	// 2048 Kbytes
	CHIPID_CIDR_NVPSIZ_2048K = 0xe
	// Position of NVPSIZ2 field.
	CHIPID_CIDR_NVPSIZ2_Pos = 0xc
	// Bit mask of NVPSIZ2 field.
	CHIPID_CIDR_NVPSIZ2_Msk = 0xf000
	// None
	CHIPID_CIDR_NVPSIZ2_NONE = 0x0
	// 8 Kbytes
	CHIPID_CIDR_NVPSIZ2_8K = 0x1
	// 16 Kbytes
	CHIPID_CIDR_NVPSIZ2_16K = 0x2
	// 32 Kbytes
	CHIPID_CIDR_NVPSIZ2_32K = 0x3
	// 64 Kbytes
	CHIPID_CIDR_NVPSIZ2_64K = 0x5
	// 128 Kbytes
	CHIPID_CIDR_NVPSIZ2_128K = 0x7
	// 256 Kbytes
	CHIPID_CIDR_NVPSIZ2_256K = 0x9
	// 512 Kbytes
	CHIPID_CIDR_NVPSIZ2_512K = 0xa
	// 1024 Kbytes
	CHIPID_CIDR_NVPSIZ2_1024K = 0xc
	// 2048 Kbytes
	CHIPID_CIDR_NVPSIZ2_2048K = 0xe
	// Position of SRAMSIZ field.
	CHIPID_CIDR_SRAMSIZ_Pos = 0x10
	// Bit mask of SRAMSIZ field.
	CHIPID_CIDR_SRAMSIZ_Msk = 0xf0000
	// 48 Kbytes
	CHIPID_CIDR_SRAMSIZ_48K = 0x0
	// 192 Kbytes
	CHIPID_CIDR_SRAMSIZ_192K = 0x1
	// 2 Kbytes
	CHIPID_CIDR_SRAMSIZ_2K = 0x2
	// 6 Kbytes
	CHIPID_CIDR_SRAMSIZ_6K = 0x3
	// 24 Kbytes
	CHIPID_CIDR_SRAMSIZ_24K = 0x4
	// 4 Kbytes
	CHIPID_CIDR_SRAMSIZ_4K = 0x5
	// 80 Kbytes
	CHIPID_CIDR_SRAMSIZ_80K = 0x6
	// 160 Kbytes
	CHIPID_CIDR_SRAMSIZ_160K = 0x7
	// 8 Kbytes
	CHIPID_CIDR_SRAMSIZ_8K = 0x8
	// 16 Kbytes
	CHIPID_CIDR_SRAMSIZ_16K = 0x9
	// 32 Kbytes
	CHIPID_CIDR_SRAMSIZ_32K = 0xa
	// 64 Kbytes
	CHIPID_CIDR_SRAMSIZ_64K = 0xb
	// 128 Kbytes
	CHIPID_CIDR_SRAMSIZ_128K = 0xc
	// 256 Kbytes
	CHIPID_CIDR_SRAMSIZ_256K = 0xd
	// 96 Kbytes
	CHIPID_CIDR_SRAMSIZ_96K = 0xe
	// 512 Kbytes
	CHIPID_CIDR_SRAMSIZ_512K = 0xf
	// Position of ARCH field.
	CHIPID_CIDR_ARCH_Pos = 0x14
	// Bit mask of ARCH field.
	CHIPID_CIDR_ARCH_Msk = 0xff00000
	// AT91SAM9xx Series
	CHIPID_CIDR_ARCH_AT91SAM9xx = 0x19
	// AT91SAM9XExx Series
	CHIPID_CIDR_ARCH_AT91SAM9XExx = 0x29
	// AT91x34 Series
	CHIPID_CIDR_ARCH_AT91x34 = 0x34
	// CAP7 Series
	CHIPID_CIDR_ARCH_CAP7 = 0x37
	// CAP9 Series
	CHIPID_CIDR_ARCH_CAP9 = 0x39
	// CAP11 Series
	CHIPID_CIDR_ARCH_CAP11 = 0x3b
	// AT91x40 Series
	CHIPID_CIDR_ARCH_AT91x40 = 0x40
	// AT91x42 Series
	CHIPID_CIDR_ARCH_AT91x42 = 0x42
	// AT91SAM4SH2 Series
	CHIPID_CIDR_ARCH_AT91SAM4SH2 = 0x45
	// AT91x55 Series
	CHIPID_CIDR_ARCH_AT91x55 = 0x55
	// AT91SAM7Axx Series
	CHIPID_CIDR_ARCH_AT91SAM7Axx = 0x60
	// AT91SAM7AQxx Series
	CHIPID_CIDR_ARCH_AT91SAM7AQxx = 0x61
	// AT91x63 Series
	CHIPID_CIDR_ARCH_AT91x63 = 0x63
	// SAM4CxC Series (100-pin version)
	CHIPID_CIDR_ARCH_SAM4CxxC = 0x64
	// AT91SAM7Sxx Series
	CHIPID_CIDR_ARCH_AT91SAM7Sxx = 0x70
	// AT91SAM7XCxx Series
	CHIPID_CIDR_ARCH_AT91SAM7XCxx = 0x71
	// AT91SAM7SExx Series
	CHIPID_CIDR_ARCH_AT91SAM7SExx = 0x72
	// AT91SAM7Lxx Series
	CHIPID_CIDR_ARCH_AT91SAM7Lxx = 0x73
	// AT91SAM7Xxx Series
	CHIPID_CIDR_ARCH_AT91SAM7Xxx = 0x75
	// AT91SAM7SLxx Series
	CHIPID_CIDR_ARCH_AT91SAM7SLxx = 0x76
	// SAM3UxC Series (100-pin version)
	CHIPID_CIDR_ARCH_SAM3UxC = 0x80
	// SAM3UxE Series (144-pin version)
	CHIPID_CIDR_ARCH_SAM3UxE = 0x81
	// SAM3AxC Series (100-pin version)
	CHIPID_CIDR_ARCH_SAM3AxC = 0x83
	// SAM3XxC Series (100-pin version)
	CHIPID_CIDR_ARCH_SAM3XxC = 0x84
	// SAM3XxE Series (144-pin version)
	CHIPID_CIDR_ARCH_SAM3XxE = 0x85
	// SAM3XxG Series (208/217-pin version)
	CHIPID_CIDR_ARCH_SAM3XxG = 0x86
	// AT91x92 Series
	CHIPID_CIDR_ARCH_AT91x92 = 0x92
	// SAM3SDxB Series (64-pin version)
	CHIPID_CIDR_ARCH_SAM3SDxB = 0x99
	// SAM3SDxC Series (100-pin version)
	CHIPID_CIDR_ARCH_SAM3SDxC = 0x9a
	// SAM5A
	CHIPID_CIDR_ARCH_SAM5A = 0xa5
	// SAM4LxA Series (48-pin version)
	CHIPID_CIDR_ARCH_SAM4LxA = 0xb0
	// SAM4LxB Series (64-pin version)
	CHIPID_CIDR_ARCH_SAM4LxB = 0xb1
	// SAM4LxC Series (100-pin version)
	CHIPID_CIDR_ARCH_SAM4LxC = 0xb2
	// AT75Cxx Series
	CHIPID_CIDR_ARCH_AT75Cxx = 0xf0
	// Position of NVPTYP field.
	CHIPID_CIDR_NVPTYP_Pos = 0x1c
	// Bit mask of NVPTYP field.
	CHIPID_CIDR_NVPTYP_Msk = 0x70000000
	// ROM
	CHIPID_CIDR_NVPTYP_ROM = 0x0
	// ROMless or on-chip Flash
	CHIPID_CIDR_NVPTYP_ROMLESS = 0x1
	// Embedded Flash Memory
	CHIPID_CIDR_NVPTYP_FLASH = 0x2
	// ROM and Embedded Flash Memory- NVPSIZ is ROM size- NVPSIZ2 is Flash size
	CHIPID_CIDR_NVPTYP_ROM_FLASH = 0x3
	// SRAM emulating ROM
	CHIPID_CIDR_NVPTYP_SRAM = 0x4
	// Position of EXT field.
	CHIPID_CIDR_EXT_Pos = 0x1f
	// Bit mask of EXT field.
	CHIPID_CIDR_EXT_Msk = 0x80000000
	// Bit EXT.
	CHIPID_CIDR_EXT = 0x80000000

	// EXID: Chip ID Extension Register
	// Position of EXID field.
	CHIPID_EXID_EXID_Pos = 0x0
	// Bit mask of EXID field.
	CHIPID_EXID_EXID_Msk = 0xffffffff
)

// Bitfields for EFC0: Embedded Flash Controller 0
const (
	// FMR: EEFC Flash Mode Register
	// Position of FRDY field.
	EFC_FMR_FRDY_Pos = 0x0
	// Bit mask of FRDY field.
	EFC_FMR_FRDY_Msk = 0x1
	// Bit FRDY.
	EFC_FMR_FRDY = 0x1
	// Position of FWS field.
	EFC_FMR_FWS_Pos = 0x8
	// Bit mask of FWS field.
	EFC_FMR_FWS_Msk = 0xf00
	// Position of SCOD field.
	EFC_FMR_SCOD_Pos = 0x10
	// Bit mask of SCOD field.
	EFC_FMR_SCOD_Msk = 0x10000
	// Bit SCOD.
	EFC_FMR_SCOD = 0x10000
	// Position of FAM field.
	EFC_FMR_FAM_Pos = 0x18
	// Bit mask of FAM field.
	EFC_FMR_FAM_Msk = 0x1000000
	// Bit FAM.
	EFC_FMR_FAM = 0x1000000

	// FCR: EEFC Flash Command Register
	// Position of FCMD field.
	EFC_FCR_FCMD_Pos = 0x0
	// Bit mask of FCMD field.
	EFC_FCR_FCMD_Msk = 0xff
	// Get Flash Descriptor
	EFC_FCR_FCMD_GETD = 0x0
	// Write page
	EFC_FCR_FCMD_WP = 0x1
	// Write page and lock
	EFC_FCR_FCMD_WPL = 0x2
	// Erase page and write page
	EFC_FCR_FCMD_EWP = 0x3
	// Erase page and write page then lock
	EFC_FCR_FCMD_EWPL = 0x4
	// Erase all
	EFC_FCR_FCMD_EA = 0x5
	// Set Lock Bit
	EFC_FCR_FCMD_SLB = 0x8
	// Clear Lock Bit
	EFC_FCR_FCMD_CLB = 0x9
	// Get Lock Bit
	EFC_FCR_FCMD_GLB = 0xa
	// Set GPNVM Bit
	EFC_FCR_FCMD_SGPB = 0xb
	// Clear GPNVM Bit
	EFC_FCR_FCMD_CGPB = 0xc
	// Get GPNVM Bit
	EFC_FCR_FCMD_GGPB = 0xd
	// Start Read Unique Identifier
	EFC_FCR_FCMD_STUI = 0xe
	// Stop Read Unique Identifier
	EFC_FCR_FCMD_SPUI = 0xf
	// Position of FARG field.
	EFC_FCR_FARG_Pos = 0x8
	// Bit mask of FARG field.
	EFC_FCR_FARG_Msk = 0xffff00
	// Position of FKEY field.
	EFC_FCR_FKEY_Pos = 0x18
	// Bit mask of FKEY field.
	EFC_FCR_FKEY_Msk = 0xff000000
	// The 0x5A value enables the command defined by the bits of the register. If the field is written with a different value, the write is not performed and no action is started.
	EFC_FCR_FKEY_PASSWD = 0x5a

	// FSR: EEFC Flash Status Register
	// Position of FRDY field.
	EFC_FSR_FRDY_Pos = 0x0
	// Bit mask of FRDY field.
	EFC_FSR_FRDY_Msk = 0x1
	// Bit FRDY.
	EFC_FSR_FRDY = 0x1
	// Position of FCMDE field.
	EFC_FSR_FCMDE_Pos = 0x1
	// Bit mask of FCMDE field.
	EFC_FSR_FCMDE_Msk = 0x2
	// Bit FCMDE.
	EFC_FSR_FCMDE = 0x2
	// Position of FLOCKE field.
	EFC_FSR_FLOCKE_Pos = 0x2
	// Bit mask of FLOCKE field.
	EFC_FSR_FLOCKE_Msk = 0x4
	// Bit FLOCKE.
	EFC_FSR_FLOCKE = 0x4

	// FRR: EEFC Flash Result Register
	// Position of FVALUE field.
	EFC_FRR_FVALUE_Pos = 0x0
	// Bit mask of FVALUE field.
	EFC_FRR_FVALUE_Msk = 0xffffffff
)

// Bitfields for PIOA: Parallel Input/Output Controller A
const (
	// PER: PIO Enable Register
	// Position of P0 field.
	PIO_PER_P0_Pos = 0x0
	// Bit mask of P0 field.
	PIO_PER_P0_Msk = 0x1
	// Bit P0.
	PIO_PER_P0 = 0x1
	// Position of P1 field.
	PIO_PER_P1_Pos = 0x1
	// Bit mask of P1 field.
	PIO_PER_P1_Msk = 0x2
	// Bit P1.
	PIO_PER_P1 = 0x2
	// Position of P2 field.
	PIO_PER_P2_Pos = 0x2
	// Bit mask of P2 field.
	PIO_PER_P2_Msk = 0x4
	// Bit P2.
	PIO_PER_P2 = 0x4
	// Position of P3 field.
	PIO_PER_P3_Pos = 0x3
	// Bit mask of P3 field.
	PIO_PER_P3_Msk = 0x8
	// Bit P3.
	PIO_PER_P3 = 0x8
	// Position of P4 field.
	PIO_PER_P4_Pos = 0x4
	// Bit mask of P4 field.
	PIO_PER_P4_Msk = 0x10
	// Bit P4.
	PIO_PER_P4 = 0x10
	// Position of P5 field.
	PIO_PER_P5_Pos = 0x5
	// Bit mask of P5 field.
	PIO_PER_P5_Msk = 0x20
	// Bit P5.
	PIO_PER_P5 = 0x20
	// Position of P6 field.
	PIO_PER_P6_Pos = 0x6
	// Bit mask of P6 field.
	PIO_PER_P6_Msk = 0x40
	// Bit P6.
	PIO_PER_P6 = 0x40
	// Position of P7 field.
	PIO_PER_P7_Pos = 0x7
	// Bit mask of P7 field.
	PIO_PER_P7_Msk = 0x80
	// Bit P7.
	PIO_PER_P7 = 0x80
	// Position of P8 field.
	PIO_PER_P8_Pos = 0x8
	// Bit mask of P8 field.
	PIO_PER_P8_Msk = 0x100
	// Bit P8.
	PIO_PER_P8 = 0x100
	// Position of P9 field.
	PIO_PER_P9_Pos = 0x9
	// Bit mask of P9 field.
	PIO_PER_P9_Msk = 0x200
	// Bit P9.
	PIO_PER_P9 = 0x200
	// Position of P10 field.
	PIO_PER_P10_Pos = 0xa
	// Bit mask of P10 field.
	PIO_PER_P10_Msk = 0x400
	// Bit P10.
	PIO_PER_P10 = 0x400
	// Position of P11 field.
	PIO_PER_P11_Pos = 0xb
	// Bit mask of P11 field.
	PIO_PER_P11_Msk = 0x800
	// Bit P11.
	PIO_PER_P11 = 0x800
	// Position of P12 field.
	PIO_PER_P12_Pos = 0xc
	// Bit mask of P12 field.
	PIO_PER_P12_Msk = 0x1000
	// Bit P12.
	PIO_PER_P12 = 0x1000
	// Position of P13 field.
	PIO_PER_P13_Pos = 0xd
	// Bit mask of P13 field.
	PIO_PER_P13_Msk = 0x2000
	// Bit P13.
	PIO_PER_P13 = 0x2000
	// Position of P14 field.
	PIO_PER_P14_Pos = 0xe
	// Bit mask of P14 field.
	PIO_PER_P14_Msk = 0x4000
	// Bit P14.
	PIO_PER_P14 = 0x4000
	// Position of P15 field.
	PIO_PER_P15_Pos = 0xf
	// Bit mask of P15 field.
	PIO_PER_P15_Msk = 0x8000
	// Bit P15.
	PIO_PER_P15 = 0x8000
	// Position of P16 field.
	PIO_PER_P16_Pos = 0x10
	// Bit mask of P16 field.
	PIO_PER_P16_Msk = 0x10000
	// Bit P16.
	PIO_PER_P16 = 0x10000
	// Position of P17 field.
	PIO_PER_P17_Pos = 0x11
	// Bit mask of P17 field.
	PIO_PER_P17_Msk = 0x20000
	// Bit P17.
	PIO_PER_P17 = 0x20000
	// Position of P18 field.
	PIO_PER_P18_Pos = 0x12
	// Bit mask of P18 field.
	PIO_PER_P18_Msk = 0x40000
	// Bit P18.
	PIO_PER_P18 = 0x40000
	// Position of P19 field.
	PIO_PER_P19_Pos = 0x13
	// Bit mask of P19 field.
	PIO_PER_P19_Msk = 0x80000
	// Bit P19.
	PIO_PER_P19 = 0x80000
	// Position of P20 field.
	PIO_PER_P20_Pos = 0x14
	// Bit mask of P20 field.
	PIO_PER_P20_Msk = 0x100000
	// Bit P20.
	PIO_PER_P20 = 0x100000
	// Position of P21 field.
	PIO_PER_P21_Pos = 0x15
	// Bit mask of P21 field.
	PIO_PER_P21_Msk = 0x200000
	// Bit P21.
	PIO_PER_P21 = 0x200000
	// Position of P22 field.
	PIO_PER_P22_Pos = 0x16
	// Bit mask of P22 field.
	PIO_PER_P22_Msk = 0x400000
	// Bit P22.
	PIO_PER_P22 = 0x400000
	// Position of P23 field.
	PIO_PER_P23_Pos = 0x17
	// Bit mask of P23 field.
	PIO_PER_P23_Msk = 0x800000
	// Bit P23.
	PIO_PER_P23 = 0x800000
	// Position of P24 field.
	PIO_PER_P24_Pos = 0x18
	// Bit mask of P24 field.
	PIO_PER_P24_Msk = 0x1000000
	// Bit P24.
	PIO_PER_P24 = 0x1000000
	// Position of P25 field.
	PIO_PER_P25_Pos = 0x19
	// Bit mask of P25 field.
	PIO_PER_P25_Msk = 0x2000000
	// Bit P25.
	PIO_PER_P25 = 0x2000000
	// Position of P26 field.
	PIO_PER_P26_Pos = 0x1a
	// Bit mask of P26 field.
	PIO_PER_P26_Msk = 0x4000000
	// Bit P26.
	PIO_PER_P26 = 0x4000000
	// Position of P27 field.
	PIO_PER_P27_Pos = 0x1b
	// Bit mask of P27 field.
	PIO_PER_P27_Msk = 0x8000000
	// Bit P27.
	PIO_PER_P27 = 0x8000000
	// Position of P28 field.
	PIO_PER_P28_Pos = 0x1c
	// Bit mask of P28 field.
	PIO_PER_P28_Msk = 0x10000000
	// Bit P28.
	PIO_PER_P28 = 0x10000000
	// Position of P29 field.
	PIO_PER_P29_Pos = 0x1d
	// Bit mask of P29 field.
	PIO_PER_P29_Msk = 0x20000000
	// Bit P29.
	PIO_PER_P29 = 0x20000000
	// Position of P30 field.
	PIO_PER_P30_Pos = 0x1e
	// Bit mask of P30 field.
	PIO_PER_P30_Msk = 0x40000000
	// Bit P30.
	PIO_PER_P30 = 0x40000000
	// Position of P31 field.
	PIO_PER_P31_Pos = 0x1f
	// Bit mask of P31 field.
	PIO_PER_P31_Msk = 0x80000000
	// Bit P31.
	PIO_PER_P31 = 0x80000000

	// PDR: PIO Disable Register
	// Position of P0 field.
	PIO_PDR_P0_Pos = 0x0
	// Bit mask of P0 field.
	PIO_PDR_P0_Msk = 0x1
	// Bit P0.
	PIO_PDR_P0 = 0x1
	// Position of P1 field.
	PIO_PDR_P1_Pos = 0x1
	// Bit mask of P1 field.
	PIO_PDR_P1_Msk = 0x2
	// Bit P1.
	PIO_PDR_P1 = 0x2
	// Position of P2 field.
	PIO_PDR_P2_Pos = 0x2
	// Bit mask of P2 field.
	PIO_PDR_P2_Msk = 0x4
	// Bit P2.
	PIO_PDR_P2 = 0x4
	// Position of P3 field.
	PIO_PDR_P3_Pos = 0x3
	// Bit mask of P3 field.
	PIO_PDR_P3_Msk = 0x8
	// Bit P3.
	PIO_PDR_P3 = 0x8
	// Position of P4 field.
	PIO_PDR_P4_Pos = 0x4
	// Bit mask of P4 field.
	PIO_PDR_P4_Msk = 0x10
	// Bit P4.
	PIO_PDR_P4 = 0x10
	// Position of P5 field.
	PIO_PDR_P5_Pos = 0x5
	// Bit mask of P5 field.
	PIO_PDR_P5_Msk = 0x20
	// Bit P5.
	PIO_PDR_P5 = 0x20
	// Position of P6 field.
	PIO_PDR_P6_Pos = 0x6
	// Bit mask of P6 field.
	PIO_PDR_P6_Msk = 0x40
	// Bit P6.
	PIO_PDR_P6 = 0x40
	// Position of P7 field.
	PIO_PDR_P7_Pos = 0x7
	// Bit mask of P7 field.
	PIO_PDR_P7_Msk = 0x80
	// Bit P7.
	PIO_PDR_P7 = 0x80
	// Position of P8 field.
	PIO_PDR_P8_Pos = 0x8
	// Bit mask of P8 field.
	PIO_PDR_P8_Msk = 0x100
	// Bit P8.
	PIO_PDR_P8 = 0x100
	// Position of P9 field.
	PIO_PDR_P9_Pos = 0x9
	// Bit mask of P9 field.
	PIO_PDR_P9_Msk = 0x200
	// Bit P9.
	PIO_PDR_P9 = 0x200
	// Position of P10 field.
	PIO_PDR_P10_Pos = 0xa
	// Bit mask of P10 field.
	PIO_PDR_P10_Msk = 0x400
	// Bit P10.
	PIO_PDR_P10 = 0x400
	// Position of P11 field.
	PIO_PDR_P11_Pos = 0xb
	// Bit mask of P11 field.
	PIO_PDR_P11_Msk = 0x800
	// Bit P11.
	PIO_PDR_P11 = 0x800
	// Position of P12 field.
	PIO_PDR_P12_Pos = 0xc
	// Bit mask of P12 field.
	PIO_PDR_P12_Msk = 0x1000
	// Bit P12.
	PIO_PDR_P12 = 0x1000
	// Position of P13 field.
	PIO_PDR_P13_Pos = 0xd
	// Bit mask of P13 field.
	PIO_PDR_P13_Msk = 0x2000
	// Bit P13.
	PIO_PDR_P13 = 0x2000
	// Position of P14 field.
	PIO_PDR_P14_Pos = 0xe
	// Bit mask of P14 field.
	PIO_PDR_P14_Msk = 0x4000
	// Bit P14.
	PIO_PDR_P14 = 0x4000
	// Position of P15 field.
	PIO_PDR_P15_Pos = 0xf
	// Bit mask of P15 field.
	PIO_PDR_P15_Msk = 0x8000
	// Bit P15.
	PIO_PDR_P15 = 0x8000
	// Position of P16 field.
	PIO_PDR_P16_Pos = 0x10
	// Bit mask of P16 field.
	PIO_PDR_P16_Msk = 0x10000
	// Bit P16.
	PIO_PDR_P16 = 0x10000
	// Position of P17 field.
	PIO_PDR_P17_Pos = 0x11
	// Bit mask of P17 field.
	PIO_PDR_P17_Msk = 0x20000
	// Bit P17.
	PIO_PDR_P17 = 0x20000
	// Position of P18 field.
	PIO_PDR_P18_Pos = 0x12
	// Bit mask of P18 field.
	PIO_PDR_P18_Msk = 0x40000
	// Bit P18.
	PIO_PDR_P18 = 0x40000
	// Position of P19 field.
	PIO_PDR_P19_Pos = 0x13
	// Bit mask of P19 field.
	PIO_PDR_P19_Msk = 0x80000
	// Bit P19.
	PIO_PDR_P19 = 0x80000
	// Position of P20 field.
	PIO_PDR_P20_Pos = 0x14
	// Bit mask of P20 field.
	PIO_PDR_P20_Msk = 0x100000
	// Bit P20.
	PIO_PDR_P20 = 0x100000
	// Position of P21 field.
	PIO_PDR_P21_Pos = 0x15
	// Bit mask of P21 field.
	PIO_PDR_P21_Msk = 0x200000
	// Bit P21.
	PIO_PDR_P21 = 0x200000
	// Position of P22 field.
	PIO_PDR_P22_Pos = 0x16
	// Bit mask of P22 field.
	PIO_PDR_P22_Msk = 0x400000
	// Bit P22.
	PIO_PDR_P22 = 0x400000
	// Position of P23 field.
	PIO_PDR_P23_Pos = 0x17
	// Bit mask of P23 field.
	PIO_PDR_P23_Msk = 0x800000
	// Bit P23.
	PIO_PDR_P23 = 0x800000
	// Position of P24 field.
	PIO_PDR_P24_Pos = 0x18
	// Bit mask of P24 field.
	PIO_PDR_P24_Msk = 0x1000000
	// Bit P24.
	PIO_PDR_P24 = 0x1000000
	// Position of P25 field.
	PIO_PDR_P25_Pos = 0x19
	// Bit mask of P25 field.
	PIO_PDR_P25_Msk = 0x2000000
	// Bit P25.
	PIO_PDR_P25 = 0x2000000
	// Position of P26 field.
	PIO_PDR_P26_Pos = 0x1a
	// Bit mask of P26 field.
	PIO_PDR_P26_Msk = 0x4000000
	// Bit P26.
	PIO_PDR_P26 = 0x4000000
	// Position of P27 field.
	PIO_PDR_P27_Pos = 0x1b
	// Bit mask of P27 field.
	PIO_PDR_P27_Msk = 0x8000000
	// Bit P27.
	PIO_PDR_P27 = 0x8000000
	// Position of P28 field.
	PIO_PDR_P28_Pos = 0x1c
	// Bit mask of P28 field.
	PIO_PDR_P28_Msk = 0x10000000
	// Bit P28.
	PIO_PDR_P28 = 0x10000000
	// Position of P29 field.
	PIO_PDR_P29_Pos = 0x1d
	// Bit mask of P29 field.
	PIO_PDR_P29_Msk = 0x20000000
	// Bit P29.
	PIO_PDR_P29 = 0x20000000
	// Position of P30 field.
	PIO_PDR_P30_Pos = 0x1e
	// Bit mask of P30 field.
	PIO_PDR_P30_Msk = 0x40000000
	// Bit P30.
	PIO_PDR_P30 = 0x40000000
	// Position of P31 field.
	PIO_PDR_P31_Pos = 0x1f
	// Bit mask of P31 field.
	PIO_PDR_P31_Msk = 0x80000000
	// Bit P31.
	PIO_PDR_P31 = 0x80000000

	// PSR: PIO Status Register
	// Position of P0 field.
	PIO_PSR_P0_Pos = 0x0
	// Bit mask of P0 field.
	PIO_PSR_P0_Msk = 0x1
	// Bit P0.
	PIO_PSR_P0 = 0x1
	// Position of P1 field.
	PIO_PSR_P1_Pos = 0x1
	// Bit mask of P1 field.
	PIO_PSR_P1_Msk = 0x2
	// Bit P1.
	PIO_PSR_P1 = 0x2
	// Position of P2 field.
	PIO_PSR_P2_Pos = 0x2
	// Bit mask of P2 field.
	PIO_PSR_P2_Msk = 0x4
	// Bit P2.
	PIO_PSR_P2 = 0x4
	// Position of P3 field.
	PIO_PSR_P3_Pos = 0x3
	// Bit mask of P3 field.
	PIO_PSR_P3_Msk = 0x8
	// Bit P3.
	PIO_PSR_P3 = 0x8
	// Position of P4 field.
	PIO_PSR_P4_Pos = 0x4
	// Bit mask of P4 field.
	PIO_PSR_P4_Msk = 0x10
	// Bit P4.
	PIO_PSR_P4 = 0x10
	// Position of P5 field.
	PIO_PSR_P5_Pos = 0x5
	// Bit mask of P5 field.
	PIO_PSR_P5_Msk = 0x20
	// Bit P5.
	PIO_PSR_P5 = 0x20
	// Position of P6 field.
	PIO_PSR_P6_Pos = 0x6
	// Bit mask of P6 field.
	PIO_PSR_P6_Msk = 0x40
	// Bit P6.
	PIO_PSR_P6 = 0x40
	// Position of P7 field.
	PIO_PSR_P7_Pos = 0x7
	// Bit mask of P7 field.
	PIO_PSR_P7_Msk = 0x80
	// Bit P7.
	PIO_PSR_P7 = 0x80
	// Position of P8 field.
	PIO_PSR_P8_Pos = 0x8
	// Bit mask of P8 field.
	PIO_PSR_P8_Msk = 0x100
	// Bit P8.
	PIO_PSR_P8 = 0x100
	// Position of P9 field.
	PIO_PSR_P9_Pos = 0x9
	// Bit mask of P9 field.
	PIO_PSR_P9_Msk = 0x200
	// Bit P9.
	PIO_PSR_P9 = 0x200
	// Position of P10 field.
	PIO_PSR_P10_Pos = 0xa
	// Bit mask of P10 field.
	PIO_PSR_P10_Msk = 0x400
	// Bit P10.
	PIO_PSR_P10 = 0x400
	// Position of P11 field.
	PIO_PSR_P11_Pos = 0xb
	// Bit mask of P11 field.
	PIO_PSR_P11_Msk = 0x800
	// Bit P11.
	PIO_PSR_P11 = 0x800
	// Position of P12 field.
	PIO_PSR_P12_Pos = 0xc
	// Bit mask of P12 field.
	PIO_PSR_P12_Msk = 0x1000
	// Bit P12.
	PIO_PSR_P12 = 0x1000
	// Position of P13 field.
	PIO_PSR_P13_Pos = 0xd
	// Bit mask of P13 field.
	PIO_PSR_P13_Msk = 0x2000
	// Bit P13.
	PIO_PSR_P13 = 0x2000
	// Position of P14 field.
	PIO_PSR_P14_Pos = 0xe
	// Bit mask of P14 field.
	PIO_PSR_P14_Msk = 0x4000
	// Bit P14.
	PIO_PSR_P14 = 0x4000
	// Position of P15 field.
	PIO_PSR_P15_Pos = 0xf
	// Bit mask of P15 field.
	PIO_PSR_P15_Msk = 0x8000
	// Bit P15.
	PIO_PSR_P15 = 0x8000
	// Position of P16 field.
	PIO_PSR_P16_Pos = 0x10
	// Bit mask of P16 field.
	PIO_PSR_P16_Msk = 0x10000
	// Bit P16.
	PIO_PSR_P16 = 0x10000
	// Position of P17 field.
	PIO_PSR_P17_Pos = 0x11
	// Bit mask of P17 field.
	PIO_PSR_P17_Msk = 0x20000
	// Bit P17.
	PIO_PSR_P17 = 0x20000
	// Position of P18 field.
	PIO_PSR_P18_Pos = 0x12
	// Bit mask of P18 field.
	PIO_PSR_P18_Msk = 0x40000
	// Bit P18.
	PIO_PSR_P18 = 0x40000
	// Position of P19 field.
	PIO_PSR_P19_Pos = 0x13
	// Bit mask of P19 field.
	PIO_PSR_P19_Msk = 0x80000
	// Bit P19.
	PIO_PSR_P19 = 0x80000
	// Position of P20 field.
	PIO_PSR_P20_Pos = 0x14
	// Bit mask of P20 field.
	PIO_PSR_P20_Msk = 0x100000
	// Bit P20.
	PIO_PSR_P20 = 0x100000
	// Position of P21 field.
	PIO_PSR_P21_Pos = 0x15
	// Bit mask of P21 field.
	PIO_PSR_P21_Msk = 0x200000
	// Bit P21.
	PIO_PSR_P21 = 0x200000
	// Position of P22 field.
	PIO_PSR_P22_Pos = 0x16
	// Bit mask of P22 field.
	PIO_PSR_P22_Msk = 0x400000
	// Bit P22.
	PIO_PSR_P22 = 0x400000
	// Position of P23 field.
	PIO_PSR_P23_Pos = 0x17
	// Bit mask of P23 field.
	PIO_PSR_P23_Msk = 0x800000
	// Bit P23.
	PIO_PSR_P23 = 0x800000
	// Position of P24 field.
	PIO_PSR_P24_Pos = 0x18
	// Bit mask of P24 field.
	PIO_PSR_P24_Msk = 0x1000000
	// Bit P24.
	PIO_PSR_P24 = 0x1000000
	// Position of P25 field.
	PIO_PSR_P25_Pos = 0x19
	// Bit mask of P25 field.
	PIO_PSR_P25_Msk = 0x2000000
	// Bit P25.
	PIO_PSR_P25 = 0x2000000
	// Position of P26 field.
	PIO_PSR_P26_Pos = 0x1a
	// Bit mask of P26 field.
	PIO_PSR_P26_Msk = 0x4000000
	// Bit P26.
	PIO_PSR_P26 = 0x4000000
	// Position of P27 field.
	PIO_PSR_P27_Pos = 0x1b
	// Bit mask of P27 field.
	PIO_PSR_P27_Msk = 0x8000000
	// Bit P27.
	PIO_PSR_P27 = 0x8000000
	// Position of P28 field.
	PIO_PSR_P28_Pos = 0x1c
	// Bit mask of P28 field.
	PIO_PSR_P28_Msk = 0x10000000
	// Bit P28.
	PIO_PSR_P28 = 0x10000000
	// Position of P29 field.
	PIO_PSR_P29_Pos = 0x1d
	// Bit mask of P29 field.
	PIO_PSR_P29_Msk = 0x20000000
	// Bit P29.
	PIO_PSR_P29 = 0x20000000
	// Position of P30 field.
	PIO_PSR_P30_Pos = 0x1e
	// Bit mask of P30 field.
	PIO_PSR_P30_Msk = 0x40000000
	// Bit P30.
	PIO_PSR_P30 = 0x40000000
	// Position of P31 field.
	PIO_PSR_P31_Pos = 0x1f
	// Bit mask of P31 field.
	PIO_PSR_P31_Msk = 0x80000000
	// Bit P31.
	PIO_PSR_P31 = 0x80000000

	// OER: Output Enable Register
	// Position of P0 field.
	PIO_OER_P0_Pos = 0x0
	// Bit mask of P0 field.
	PIO_OER_P0_Msk = 0x1
	// Bit P0.
	PIO_OER_P0 = 0x1
	// Position of P1 field.
	PIO_OER_P1_Pos = 0x1
	// Bit mask of P1 field.
	PIO_OER_P1_Msk = 0x2
	// Bit P1.
	PIO_OER_P1 = 0x2
	// Position of P2 field.
	PIO_OER_P2_Pos = 0x2
	// Bit mask of P2 field.
	PIO_OER_P2_Msk = 0x4
	// Bit P2.
	PIO_OER_P2 = 0x4
	// Position of P3 field.
	PIO_OER_P3_Pos = 0x3
	// Bit mask of P3 field.
	PIO_OER_P3_Msk = 0x8
	// Bit P3.
	PIO_OER_P3 = 0x8
	// Position of P4 field.
	PIO_OER_P4_Pos = 0x4
	// Bit mask of P4 field.
	PIO_OER_P4_Msk = 0x10
	// Bit P4.
	PIO_OER_P4 = 0x10
	// Position of P5 field.
	PIO_OER_P5_Pos = 0x5
	// Bit mask of P5 field.
	PIO_OER_P5_Msk = 0x20
	// Bit P5.
	PIO_OER_P5 = 0x20
	// Position of P6 field.
	PIO_OER_P6_Pos = 0x6
	// Bit mask of P6 field.
	PIO_OER_P6_Msk = 0x40
	// Bit P6.
	PIO_OER_P6 = 0x40
	// Position of P7 field.
	PIO_OER_P7_Pos = 0x7
	// Bit mask of P7 field.
	PIO_OER_P7_Msk = 0x80
	// Bit P7.
	PIO_OER_P7 = 0x80
	// Position of P8 field.
	PIO_OER_P8_Pos = 0x8
	// Bit mask of P8 field.
	PIO_OER_P8_Msk = 0x100
	// Bit P8.
	PIO_OER_P8 = 0x100
	// Position of P9 field.
	PIO_OER_P9_Pos = 0x9
	// Bit mask of P9 field.
	PIO_OER_P9_Msk = 0x200
	// Bit P9.
	PIO_OER_P9 = 0x200
	// Position of P10 field.
	PIO_OER_P10_Pos = 0xa
	// Bit mask of P10 field.
	PIO_OER_P10_Msk = 0x400
	// Bit P10.
	PIO_OER_P10 = 0x400
	// Position of P11 field.
	PIO_OER_P11_Pos = 0xb
	// Bit mask of P11 field.
	PIO_OER_P11_Msk = 0x800
	// Bit P11.
	PIO_OER_P11 = 0x800
	// Position of P12 field.
	PIO_OER_P12_Pos = 0xc
	// Bit mask of P12 field.
	PIO_OER_P12_Msk = 0x1000
	// Bit P12.
	PIO_OER_P12 = 0x1000
	// Position of P13 field.
	PIO_OER_P13_Pos = 0xd
	// Bit mask of P13 field.
	PIO_OER_P13_Msk = 0x2000
	// Bit P13.
	PIO_OER_P13 = 0x2000
	// Position of P14 field.
	PIO_OER_P14_Pos = 0xe
	// Bit mask of P14 field.
	PIO_OER_P14_Msk = 0x4000
	// Bit P14.
	PIO_OER_P14 = 0x4000
	// Position of P15 field.
	PIO_OER_P15_Pos = 0xf
	// Bit mask of P15 field.
	PIO_OER_P15_Msk = 0x8000
	// Bit P15.
	PIO_OER_P15 = 0x8000
	// Position of P16 field.
	PIO_OER_P16_Pos = 0x10
	// Bit mask of P16 field.
	PIO_OER_P16_Msk = 0x10000
	// Bit P16.
	PIO_OER_P16 = 0x10000
	// Position of P17 field.
	PIO_OER_P17_Pos = 0x11
	// Bit mask of P17 field.
	PIO_OER_P17_Msk = 0x20000
	// Bit P17.
	PIO_OER_P17 = 0x20000
	// Position of P18 field.
	PIO_OER_P18_Pos = 0x12
	// Bit mask of P18 field.
	PIO_OER_P18_Msk = 0x40000
	// Bit P18.
	PIO_OER_P18 = 0x40000
	// Position of P19 field.
	PIO_OER_P19_Pos = 0x13
	// Bit mask of P19 field.
	PIO_OER_P19_Msk = 0x80000
	// Bit P19.
	PIO_OER_P19 = 0x80000
	// Position of P20 field.
	PIO_OER_P20_Pos = 0x14
	// Bit mask of P20 field.
	PIO_OER_P20_Msk = 0x100000
	// Bit P20.
	PIO_OER_P20 = 0x100000
	// Position of P21 field.
	PIO_OER_P21_Pos = 0x15
	// Bit mask of P21 field.
	PIO_OER_P21_Msk = 0x200000
	// Bit P21.
	PIO_OER_P21 = 0x200000
	// Position of P22 field.
	PIO_OER_P22_Pos = 0x16
	// Bit mask of P22 field.
	PIO_OER_P22_Msk = 0x400000
	// Bit P22.
	PIO_OER_P22 = 0x400000
	// Position of P23 field.
	PIO_OER_P23_Pos = 0x17
	// Bit mask of P23 field.
	PIO_OER_P23_Msk = 0x800000
	// Bit P23.
	PIO_OER_P23 = 0x800000
	// Position of P24 field.
	PIO_OER_P24_Pos = 0x18
	// Bit mask of P24 field.
	PIO_OER_P24_Msk = 0x1000000
	// Bit P24.
	PIO_OER_P24 = 0x1000000
	// Position of P25 field.
	PIO_OER_P25_Pos = 0x19
	// Bit mask of P25 field.
	PIO_OER_P25_Msk = 0x2000000
	// Bit P25.
	PIO_OER_P25 = 0x2000000
	// Position of P26 field.
	PIO_OER_P26_Pos = 0x1a
	// Bit mask of P26 field.
	PIO_OER_P26_Msk = 0x4000000
	// Bit P26.
	PIO_OER_P26 = 0x4000000
	// Position of P27 field.
	PIO_OER_P27_Pos = 0x1b
	// Bit mask of P27 field.
	PIO_OER_P27_Msk = 0x8000000
	// Bit P27.
	PIO_OER_P27 = 0x8000000
	// Position of P28 field.
	PIO_OER_P28_Pos = 0x1c
	// Bit mask of P28 field.
	PIO_OER_P28_Msk = 0x10000000
	// Bit P28.
	PIO_OER_P28 = 0x10000000
	// Position of P29 field.
	PIO_OER_P29_Pos = 0x1d
	// Bit mask of P29 field.
	PIO_OER_P29_Msk = 0x20000000
	// Bit P29.
	PIO_OER_P29 = 0x20000000
	// Position of P30 field.
	PIO_OER_P30_Pos = 0x1e
	// Bit mask of P30 field.
	PIO_OER_P30_Msk = 0x40000000
	// Bit P30.
	PIO_OER_P30 = 0x40000000
	// Position of P31 field.
	PIO_OER_P31_Pos = 0x1f
	// Bit mask of P31 field.
	PIO_OER_P31_Msk = 0x80000000
	// Bit P31.
	PIO_OER_P31 = 0x80000000

	// ODR: Output Disable Register
	// Position of P0 field.
	PIO_ODR_P0_Pos = 0x0
	// Bit mask of P0 field.
	PIO_ODR_P0_Msk = 0x1
	// Bit P0.
	PIO_ODR_P0 = 0x1
	// Position of P1 field.
	PIO_ODR_P1_Pos = 0x1
	// Bit mask of P1 field.
	PIO_ODR_P1_Msk = 0x2
	// Bit P1.
	PIO_ODR_P1 = 0x2
	// Position of P2 field.
	PIO_ODR_P2_Pos = 0x2
	// Bit mask of P2 field.
	PIO_ODR_P2_Msk = 0x4
	// Bit P2.
	PIO_ODR_P2 = 0x4
	// Position of P3 field.
	PIO_ODR_P3_Pos = 0x3
	// Bit mask of P3 field.
	PIO_ODR_P3_Msk = 0x8
	// Bit P3.
	PIO_ODR_P3 = 0x8
	// Position of P4 field.
	PIO_ODR_P4_Pos = 0x4
	// Bit mask of P4 field.
	PIO_ODR_P4_Msk = 0x10
	// Bit P4.
	PIO_ODR_P4 = 0x10
	// Position of P5 field.
	PIO_ODR_P5_Pos = 0x5
	// Bit mask of P5 field.
	PIO_ODR_P5_Msk = 0x20
	// Bit P5.
	PIO_ODR_P5 = 0x20
	// Position of P6 field.
	PIO_ODR_P6_Pos = 0x6
	// Bit mask of P6 field.
	PIO_ODR_P6_Msk = 0x40
	// Bit P6.
	PIO_ODR_P6 = 0x40
	// Position of P7 field.
	PIO_ODR_P7_Pos = 0x7
	// Bit mask of P7 field.
	PIO_ODR_P7_Msk = 0x80
	// Bit P7.
	PIO_ODR_P7 = 0x80
	// Position of P8 field.
	PIO_ODR_P8_Pos = 0x8
	// Bit mask of P8 field.
	PIO_ODR_P8_Msk = 0x100
	// Bit P8.
	PIO_ODR_P8 = 0x100
	// Position of P9 field.
	PIO_ODR_P9_Pos = 0x9
	// Bit mask of P9 field.
	PIO_ODR_P9_Msk = 0x200
	// Bit P9.
	PIO_ODR_P9 = 0x200
	// Position of P10 field.
	PIO_ODR_P10_Pos = 0xa
	// Bit mask of P10 field.
	PIO_ODR_P10_Msk = 0x400
	// Bit P10.
	PIO_ODR_P10 = 0x400
	// Position of P11 field.
	PIO_ODR_P11_Pos = 0xb
	// Bit mask of P11 field.
	PIO_ODR_P11_Msk = 0x800
	// Bit P11.
	PIO_ODR_P11 = 0x800
	// Position of P12 field.
	PIO_ODR_P12_Pos = 0xc
	// Bit mask of P12 field.
	PIO_ODR_P12_Msk = 0x1000
	// Bit P12.
	PIO_ODR_P12 = 0x1000
	// Position of P13 field.
	PIO_ODR_P13_Pos = 0xd
	// Bit mask of P13 field.
	PIO_ODR_P13_Msk = 0x2000
	// Bit P13.
	PIO_ODR_P13 = 0x2000
	// Position of P14 field.
	PIO_ODR_P14_Pos = 0xe
	// Bit mask of P14 field.
	PIO_ODR_P14_Msk = 0x4000
	// Bit P14.
	PIO_ODR_P14 = 0x4000
	// Position of P15 field.
	PIO_ODR_P15_Pos = 0xf
	// Bit mask of P15 field.
	PIO_ODR_P15_Msk = 0x8000
	// Bit P15.
	PIO_ODR_P15 = 0x8000
	// Position of P16 field.
	PIO_ODR_P16_Pos = 0x10
	// Bit mask of P16 field.
	PIO_ODR_P16_Msk = 0x10000
	// Bit P16.
	PIO_ODR_P16 = 0x10000
	// Position of P17 field.
	PIO_ODR_P17_Pos = 0x11
	// Bit mask of P17 field.
	PIO_ODR_P17_Msk = 0x20000
	// Bit P17.
	PIO_ODR_P17 = 0x20000
	// Position of P18 field.
	PIO_ODR_P18_Pos = 0x12
	// Bit mask of P18 field.
	PIO_ODR_P18_Msk = 0x40000
	// Bit P18.
	PIO_ODR_P18 = 0x40000
	// Position of P19 field.
	PIO_ODR_P19_Pos = 0x13
	// Bit mask of P19 field.
	PIO_ODR_P19_Msk = 0x80000
	// Bit P19.
	PIO_ODR_P19 = 0x80000
	// Position of P20 field.
	PIO_ODR_P20_Pos = 0x14
	// Bit mask of P20 field.
	PIO_ODR_P20_Msk = 0x100000
	// Bit P20.
	PIO_ODR_P20 = 0x100000
	// Position of P21 field.
	PIO_ODR_P21_Pos = 0x15
	// Bit mask of P21 field.
	PIO_ODR_P21_Msk = 0x200000
	// Bit P21.
	PIO_ODR_P21 = 0x200000
	// Position of P22 field.
	PIO_ODR_P22_Pos = 0x16
	// Bit mask of P22 field.
	PIO_ODR_P22_Msk = 0x400000
	// Bit P22.
	PIO_ODR_P22 = 0x400000
	// Position of P23 field.
	PIO_ODR_P23_Pos = 0x17
	// Bit mask of P23 field.
	PIO_ODR_P23_Msk = 0x800000
	// Bit P23.
	PIO_ODR_P23 = 0x800000
	// Position of P24 field.
	PIO_ODR_P24_Pos = 0x18
	// Bit mask of P24 field.
	PIO_ODR_P24_Msk = 0x1000000
	// Bit P24.
	PIO_ODR_P24 = 0x1000000
	// Position of P25 field.
	PIO_ODR_P25_Pos = 0x19
	// Bit mask of P25 field.
	PIO_ODR_P25_Msk = 0x2000000
	// Bit P25.
	PIO_ODR_P25 = 0x2000000
	// Position of P26 field.
	PIO_ODR_P26_Pos = 0x1a
	// Bit mask of P26 field.
	PIO_ODR_P26_Msk = 0x4000000
	// Bit P26.
	PIO_ODR_P26 = 0x4000000
	// Position of P27 field.
	PIO_ODR_P27_Pos = 0x1b
	// Bit mask of P27 field.
	PIO_ODR_P27_Msk = 0x8000000
	// Bit P27.
	PIO_ODR_P27 = 0x8000000
	// Position of P28 field.
	PIO_ODR_P28_Pos = 0x1c
	// Bit mask of P28 field.
	PIO_ODR_P28_Msk = 0x10000000
	// Bit P28.
	PIO_ODR_P28 = 0x10000000
	// Position of P29 field.
	PIO_ODR_P29_Pos = 0x1d
	// Bit mask of P29 field.
	PIO_ODR_P29_Msk = 0x20000000
	// Bit P29.
	PIO_ODR_P29 = 0x20000000
	// Position of P30 field.
	PIO_ODR_P30_Pos = 0x1e
	// Bit mask of P30 field.
	PIO_ODR_P30_Msk = 0x40000000
	// Bit P30.
	PIO_ODR_P30 = 0x40000000
	// Position of P31 field.
	PIO_ODR_P31_Pos = 0x1f
	// Bit mask of P31 field.
	PIO_ODR_P31_Msk = 0x80000000
	// Bit P31.
	PIO_ODR_P31 = 0x80000000

	// OSR: Output Status Register
	// Position of P0 field.
	PIO_OSR_P0_Pos = 0x0
	// Bit mask of P0 field.
	PIO_OSR_P0_Msk = 0x1
	// Bit P0.
	PIO_OSR_P0 = 0x1
	// Position of P1 field.
	PIO_OSR_P1_Pos = 0x1
	// Bit mask of P1 field.
	PIO_OSR_P1_Msk = 0x2
	// Bit P1.
	PIO_OSR_P1 = 0x2
	// Position of P2 field.
	PIO_OSR_P2_Pos = 0x2
	// Bit mask of P2 field.
	PIO_OSR_P2_Msk = 0x4
	// Bit P2.
	PIO_OSR_P2 = 0x4
	// Position of P3 field.
	PIO_OSR_P3_Pos = 0x3
	// Bit mask of P3 field.
	PIO_OSR_P3_Msk = 0x8
	// Bit P3.
	PIO_OSR_P3 = 0x8
	// Position of P4 field.
	PIO_OSR_P4_Pos = 0x4
	// Bit mask of P4 field.
	PIO_OSR_P4_Msk = 0x10
	// Bit P4.
	PIO_OSR_P4 = 0x10
	// Position of P5 field.
	PIO_OSR_P5_Pos = 0x5
	// Bit mask of P5 field.
	PIO_OSR_P5_Msk = 0x20
	// Bit P5.
	PIO_OSR_P5 = 0x20
	// Position of P6 field.
	PIO_OSR_P6_Pos = 0x6
	// Bit mask of P6 field.
	PIO_OSR_P6_Msk = 0x40
	// Bit P6.
	PIO_OSR_P6 = 0x40
	// Position of P7 field.
	PIO_OSR_P7_Pos = 0x7
	// Bit mask of P7 field.
	PIO_OSR_P7_Msk = 0x80
	// Bit P7.
	PIO_OSR_P7 = 0x80
	// Position of P8 field.
	PIO_OSR_P8_Pos = 0x8
	// Bit mask of P8 field.
	PIO_OSR_P8_Msk = 0x100
	// Bit P8.
	PIO_OSR_P8 = 0x100
	// Position of P9 field.
	PIO_OSR_P9_Pos = 0x9
	// Bit mask of P9 field.
	PIO_OSR_P9_Msk = 0x200
	// Bit P9.
	PIO_OSR_P9 = 0x200
	// Position of P10 field.
	PIO_OSR_P10_Pos = 0xa
	// Bit mask of P10 field.
	PIO_OSR_P10_Msk = 0x400
	// Bit P10.
	PIO_OSR_P10 = 0x400
	// Position of P11 field.
	PIO_OSR_P11_Pos = 0xb
	// Bit mask of P11 field.
	PIO_OSR_P11_Msk = 0x800
	// Bit P11.
	PIO_OSR_P11 = 0x800
	// Position of P12 field.
	PIO_OSR_P12_Pos = 0xc
	// Bit mask of P12 field.
	PIO_OSR_P12_Msk = 0x1000
	// Bit P12.
	PIO_OSR_P12 = 0x1000
	// Position of P13 field.
	PIO_OSR_P13_Pos = 0xd
	// Bit mask of P13 field.
	PIO_OSR_P13_Msk = 0x2000
	// Bit P13.
	PIO_OSR_P13 = 0x2000
	// Position of P14 field.
	PIO_OSR_P14_Pos = 0xe
	// Bit mask of P14 field.
	PIO_OSR_P14_Msk = 0x4000
	// Bit P14.
	PIO_OSR_P14 = 0x4000
	// Position of P15 field.
	PIO_OSR_P15_Pos = 0xf
	// Bit mask of P15 field.
	PIO_OSR_P15_Msk = 0x8000
	// Bit P15.
	PIO_OSR_P15 = 0x8000
	// Position of P16 field.
	PIO_OSR_P16_Pos = 0x10
	// Bit mask of P16 field.
	PIO_OSR_P16_Msk = 0x10000
	// Bit P16.
	PIO_OSR_P16 = 0x10000
	// Position of P17 field.
	PIO_OSR_P17_Pos = 0x11
	// Bit mask of P17 field.
	PIO_OSR_P17_Msk = 0x20000
	// Bit P17.
	PIO_OSR_P17 = 0x20000
	// Position of P18 field.
	PIO_OSR_P18_Pos = 0x12
	// Bit mask of P18 field.
	PIO_OSR_P18_Msk = 0x40000
	// Bit P18.
	PIO_OSR_P18 = 0x40000
	// Position of P19 field.
	PIO_OSR_P19_Pos = 0x13
	// Bit mask of P19 field.
	PIO_OSR_P19_Msk = 0x80000
	// Bit P19.
	PIO_OSR_P19 = 0x80000
	// Position of P20 field.
	PIO_OSR_P20_Pos = 0x14
	// Bit mask of P20 field.
	PIO_OSR_P20_Msk = 0x100000
	// Bit P20.
	PIO_OSR_P20 = 0x100000
	// Position of P21 field.
	PIO_OSR_P21_Pos = 0x15
	// Bit mask of P21 field.
	PIO_OSR_P21_Msk = 0x200000
	// Bit P21.
	PIO_OSR_P21 = 0x200000
	// Position of P22 field.
	PIO_OSR_P22_Pos = 0x16
	// Bit mask of P22 field.
	PIO_OSR_P22_Msk = 0x400000
	// Bit P22.
	PIO_OSR_P22 = 0x400000
	// Position of P23 field.
	PIO_OSR_P23_Pos = 0x17
	// Bit mask of P23 field.
	PIO_OSR_P23_Msk = 0x800000
	// Bit P23.
	PIO_OSR_P23 = 0x800000
	// Position of P24 field.
	PIO_OSR_P24_Pos = 0x18
	// Bit mask of P24 field.
	PIO_OSR_P24_Msk = 0x1000000
	// Bit P24.
	PIO_OSR_P24 = 0x1000000
	// Position of P25 field.
	PIO_OSR_P25_Pos = 0x19
	// Bit mask of P25 field.
	PIO_OSR_P25_Msk = 0x2000000
	// Bit P25.
	PIO_OSR_P25 = 0x2000000
	// Position of P26 field.
	PIO_OSR_P26_Pos = 0x1a
	// Bit mask of P26 field.
	PIO_OSR_P26_Msk = 0x4000000
	// Bit P26.
	PIO_OSR_P26 = 0x4000000
	// Position of P27 field.
	PIO_OSR_P27_Pos = 0x1b
	// Bit mask of P27 field.
	PIO_OSR_P27_Msk = 0x8000000
	// Bit P27.
	PIO_OSR_P27 = 0x8000000
	// Position of P28 field.
	PIO_OSR_P28_Pos = 0x1c
	// Bit mask of P28 field.
	PIO_OSR_P28_Msk = 0x10000000
	// Bit P28.
	PIO_OSR_P28 = 0x10000000
	// Position of P29 field.
	PIO_OSR_P29_Pos = 0x1d
	// Bit mask of P29 field.
	PIO_OSR_P29_Msk = 0x20000000
	// Bit P29.
	PIO_OSR_P29 = 0x20000000
	// Position of P30 field.
	PIO_OSR_P30_Pos = 0x1e
	// Bit mask of P30 field.
	PIO_OSR_P30_Msk = 0x40000000
	// Bit P30.
	PIO_OSR_P30 = 0x40000000
	// Position of P31 field.
	PIO_OSR_P31_Pos = 0x1f
	// Bit mask of P31 field.
	PIO_OSR_P31_Msk = 0x80000000
	// Bit P31.
	PIO_OSR_P31 = 0x80000000

	// IFER: Glitch Input Filter Enable Register
	// Position of P0 field.
	PIO_IFER_P0_Pos = 0x0
	// Bit mask of P0 field.
	PIO_IFER_P0_Msk = 0x1
	// Bit P0.
	PIO_IFER_P0 = 0x1
	// Position of P1 field.
	PIO_IFER_P1_Pos = 0x1
	// Bit mask of P1 field.
	PIO_IFER_P1_Msk = 0x2
	// Bit P1.
	PIO_IFER_P1 = 0x2
	// Position of P2 field.
	PIO_IFER_P2_Pos = 0x2
	// Bit mask of P2 field.
	PIO_IFER_P2_Msk = 0x4
	// Bit P2.
	PIO_IFER_P2 = 0x4
	// Position of P3 field.
	PIO_IFER_P3_Pos = 0x3
	// Bit mask of P3 field.
	PIO_IFER_P3_Msk = 0x8
	// Bit P3.
	PIO_IFER_P3 = 0x8
	// Position of P4 field.
	PIO_IFER_P4_Pos = 0x4
	// Bit mask of P4 field.
	PIO_IFER_P4_Msk = 0x10
	// Bit P4.
	PIO_IFER_P4 = 0x10
	// Position of P5 field.
	PIO_IFER_P5_Pos = 0x5
	// Bit mask of P5 field.
	PIO_IFER_P5_Msk = 0x20
	// Bit P5.
	PIO_IFER_P5 = 0x20
	// Position of P6 field.
	PIO_IFER_P6_Pos = 0x6
	// Bit mask of P6 field.
	PIO_IFER_P6_Msk = 0x40
	// Bit P6.
	PIO_IFER_P6 = 0x40
	// Position of P7 field.
	PIO_IFER_P7_Pos = 0x7
	// Bit mask of P7 field.
	PIO_IFER_P7_Msk = 0x80
	// Bit P7.
	PIO_IFER_P7 = 0x80
	// Position of P8 field.
	PIO_IFER_P8_Pos = 0x8
	// Bit mask of P8 field.
	PIO_IFER_P8_Msk = 0x100
	// Bit P8.
	PIO_IFER_P8 = 0x100
	// Position of P9 field.
	PIO_IFER_P9_Pos = 0x9
	// Bit mask of P9 field.
	PIO_IFER_P9_Msk = 0x200
	// Bit P9.
	PIO_IFER_P9 = 0x200
	// Position of P10 field.
	PIO_IFER_P10_Pos = 0xa
	// Bit mask of P10 field.
	PIO_IFER_P10_Msk = 0x400
	// Bit P10.
	PIO_IFER_P10 = 0x400
	// Position of P11 field.
	PIO_IFER_P11_Pos = 0xb
	// Bit mask of P11 field.
	PIO_IFER_P11_Msk = 0x800
	// Bit P11.
	PIO_IFER_P11 = 0x800
	// Position of P12 field.
	PIO_IFER_P12_Pos = 0xc
	// Bit mask of P12 field.
	PIO_IFER_P12_Msk = 0x1000
	// Bit P12.
	PIO_IFER_P12 = 0x1000
	// Position of P13 field.
	PIO_IFER_P13_Pos = 0xd
	// Bit mask of P13 field.
	PIO_IFER_P13_Msk = 0x2000
	// Bit P13.
	PIO_IFER_P13 = 0x2000
	// Position of P14 field.
	PIO_IFER_P14_Pos = 0xe
	// Bit mask of P14 field.
	PIO_IFER_P14_Msk = 0x4000
	// Bit P14.
	PIO_IFER_P14 = 0x4000
	// Position of P15 field.
	PIO_IFER_P15_Pos = 0xf
	// Bit mask of P15 field.
	PIO_IFER_P15_Msk = 0x8000
	// Bit P15.
	PIO_IFER_P15 = 0x8000
	// Position of P16 field.
	PIO_IFER_P16_Pos = 0x10
	// Bit mask of P16 field.
	PIO_IFER_P16_Msk = 0x10000
	// Bit P16.
	PIO_IFER_P16 = 0x10000
	// Position of P17 field.
	PIO_IFER_P17_Pos = 0x11
	// Bit mask of P17 field.
	PIO_IFER_P17_Msk = 0x20000
	// Bit P17.
	PIO_IFER_P17 = 0x20000
	// Position of P18 field.
	PIO_IFER_P18_Pos = 0x12
	// Bit mask of P18 field.
	PIO_IFER_P18_Msk = 0x40000
	// Bit P18.
	PIO_IFER_P18 = 0x40000
	// Position of P19 field.
	PIO_IFER_P19_Pos = 0x13
	// Bit mask of P19 field.
	PIO_IFER_P19_Msk = 0x80000
	// Bit P19.
	PIO_IFER_P19 = 0x80000
	// Position of P20 field.
	PIO_IFER_P20_Pos = 0x14
	// Bit mask of P20 field.
	PIO_IFER_P20_Msk = 0x100000
	// Bit P20.
	PIO_IFER_P20 = 0x100000
	// Position of P21 field.
	PIO_IFER_P21_Pos = 0x15
	// Bit mask of P21 field.
	PIO_IFER_P21_Msk = 0x200000
	// Bit P21.
	PIO_IFER_P21 = 0x200000
	// Position of P22 field.
	PIO_IFER_P22_Pos = 0x16
	// Bit mask of P22 field.
	PIO_IFER_P22_Msk = 0x400000
	// Bit P22.
	PIO_IFER_P22 = 0x400000
	// Position of P23 field.
	PIO_IFER_P23_Pos = 0x17
	// Bit mask of P23 field.
	PIO_IFER_P23_Msk = 0x800000
	// Bit P23.
	PIO_IFER_P23 = 0x800000
	// Position of P24 field.
	PIO_IFER_P24_Pos = 0x18
	// Bit mask of P24 field.
	PIO_IFER_P24_Msk = 0x1000000
	// Bit P24.
	PIO_IFER_P24 = 0x1000000
	// Position of P25 field.
	PIO_IFER_P25_Pos = 0x19
	// Bit mask of P25 field.
	PIO_IFER_P25_Msk = 0x2000000
	// Bit P25.
	PIO_IFER_P25 = 0x2000000
	// Position of P26 field.
	PIO_IFER_P26_Pos = 0x1a
	// Bit mask of P26 field.
	PIO_IFER_P26_Msk = 0x4000000
	// Bit P26.
	PIO_IFER_P26 = 0x4000000
	// Position of P27 field.
	PIO_IFER_P27_Pos = 0x1b
	// Bit mask of P27 field.
	PIO_IFER_P27_Msk = 0x8000000
	// Bit P27.
	PIO_IFER_P27 = 0x8000000
	// Position of P28 field.
	PIO_IFER_P28_Pos = 0x1c
	// Bit mask of P28 field.
	PIO_IFER_P28_Msk = 0x10000000
	// Bit P28.
	PIO_IFER_P28 = 0x10000000
	// Position of P29 field.
	PIO_IFER_P29_Pos = 0x1d
	// Bit mask of P29 field.
	PIO_IFER_P29_Msk = 0x20000000
	// Bit P29.
	PIO_IFER_P29 = 0x20000000
	// Position of P30 field.
	PIO_IFER_P30_Pos = 0x1e
	// Bit mask of P30 field.
	PIO_IFER_P30_Msk = 0x40000000
	// Bit P30.
	PIO_IFER_P30 = 0x40000000
	// Position of P31 field.
	PIO_IFER_P31_Pos = 0x1f
	// Bit mask of P31 field.
	PIO_IFER_P31_Msk = 0x80000000
	// Bit P31.
	PIO_IFER_P31 = 0x80000000

	// IFDR: Glitch Input Filter Disable Register
	// Position of P0 field.
	PIO_IFDR_P0_Pos = 0x0
	// Bit mask of P0 field.
	PIO_IFDR_P0_Msk = 0x1
	// Bit P0.
	PIO_IFDR_P0 = 0x1
	// Position of P1 field.
	PIO_IFDR_P1_Pos = 0x1
	// Bit mask of P1 field.
	PIO_IFDR_P1_Msk = 0x2
	// Bit P1.
	PIO_IFDR_P1 = 0x2
	// Position of P2 field.
	PIO_IFDR_P2_Pos = 0x2
	// Bit mask of P2 field.
	PIO_IFDR_P2_Msk = 0x4
	// Bit P2.
	PIO_IFDR_P2 = 0x4
	// Position of P3 field.
	PIO_IFDR_P3_Pos = 0x3
	// Bit mask of P3 field.
	PIO_IFDR_P3_Msk = 0x8
	// Bit P3.
	PIO_IFDR_P3 = 0x8
	// Position of P4 field.
	PIO_IFDR_P4_Pos = 0x4
	// Bit mask of P4 field.
	PIO_IFDR_P4_Msk = 0x10
	// Bit P4.
	PIO_IFDR_P4 = 0x10
	// Position of P5 field.
	PIO_IFDR_P5_Pos = 0x5
	// Bit mask of P5 field.
	PIO_IFDR_P5_Msk = 0x20
	// Bit P5.
	PIO_IFDR_P5 = 0x20
	// Position of P6 field.
	PIO_IFDR_P6_Pos = 0x6
	// Bit mask of P6 field.
	PIO_IFDR_P6_Msk = 0x40
	// Bit P6.
	PIO_IFDR_P6 = 0x40
	// Position of P7 field.
	PIO_IFDR_P7_Pos = 0x7
	// Bit mask of P7 field.
	PIO_IFDR_P7_Msk = 0x80
	// Bit P7.
	PIO_IFDR_P7 = 0x80
	// Position of P8 field.
	PIO_IFDR_P8_Pos = 0x8
	// Bit mask of P8 field.
	PIO_IFDR_P8_Msk = 0x100
	// Bit P8.
	PIO_IFDR_P8 = 0x100
	// Position of P9 field.
	PIO_IFDR_P9_Pos = 0x9
	// Bit mask of P9 field.
	PIO_IFDR_P9_Msk = 0x200
	// Bit P9.
	PIO_IFDR_P9 = 0x200
	// Position of P10 field.
	PIO_IFDR_P10_Pos = 0xa
	// Bit mask of P10 field.
	PIO_IFDR_P10_Msk = 0x400
	// Bit P10.
	PIO_IFDR_P10 = 0x400
	// Position of P11 field.
	PIO_IFDR_P11_Pos = 0xb
	// Bit mask of P11 field.
	PIO_IFDR_P11_Msk = 0x800
	// Bit P11.
	PIO_IFDR_P11 = 0x800
	// Position of P12 field.
	PIO_IFDR_P12_Pos = 0xc
	// Bit mask of P12 field.
	PIO_IFDR_P12_Msk = 0x1000
	// Bit P12.
	PIO_IFDR_P12 = 0x1000
	// Position of P13 field.
	PIO_IFDR_P13_Pos = 0xd
	// Bit mask of P13 field.
	PIO_IFDR_P13_Msk = 0x2000
	// Bit P13.
	PIO_IFDR_P13 = 0x2000
	// Position of P14 field.
	PIO_IFDR_P14_Pos = 0xe
	// Bit mask of P14 field.
	PIO_IFDR_P14_Msk = 0x4000
	// Bit P14.
	PIO_IFDR_P14 = 0x4000
	// Position of P15 field.
	PIO_IFDR_P15_Pos = 0xf
	// Bit mask of P15 field.
	PIO_IFDR_P15_Msk = 0x8000
	// Bit P15.
	PIO_IFDR_P15 = 0x8000
	// Position of P16 field.
	PIO_IFDR_P16_Pos = 0x10
	// Bit mask of P16 field.
	PIO_IFDR_P16_Msk = 0x10000
	// Bit P16.
	PIO_IFDR_P16 = 0x10000
	// Position of P17 field.
	PIO_IFDR_P17_Pos = 0x11
	// Bit mask of P17 field.
	PIO_IFDR_P17_Msk = 0x20000
	// Bit P17.
	PIO_IFDR_P17 = 0x20000
	// Position of P18 field.
	PIO_IFDR_P18_Pos = 0x12
	// Bit mask of P18 field.
	PIO_IFDR_P18_Msk = 0x40000
	// Bit P18.
	PIO_IFDR_P18 = 0x40000
	// Position of P19 field.
	PIO_IFDR_P19_Pos = 0x13
	// Bit mask of P19 field.
	PIO_IFDR_P19_Msk = 0x80000
	// Bit P19.
	PIO_IFDR_P19 = 0x80000
	// Position of P20 field.
	PIO_IFDR_P20_Pos = 0x14
	// Bit mask of P20 field.
	PIO_IFDR_P20_Msk = 0x100000
	// Bit P20.
	PIO_IFDR_P20 = 0x100000
	// Position of P21 field.
	PIO_IFDR_P21_Pos = 0x15
	// Bit mask of P21 field.
	PIO_IFDR_P21_Msk = 0x200000
	// Bit P21.
	PIO_IFDR_P21 = 0x200000
	// Position of P22 field.
	PIO_IFDR_P22_Pos = 0x16
	// Bit mask of P22 field.
	PIO_IFDR_P22_Msk = 0x400000
	// Bit P22.
	PIO_IFDR_P22 = 0x400000
	// Position of P23 field.
	PIO_IFDR_P23_Pos = 0x17
	// Bit mask of P23 field.
	PIO_IFDR_P23_Msk = 0x800000
	// Bit P23.
	PIO_IFDR_P23 = 0x800000
	// Position of P24 field.
	PIO_IFDR_P24_Pos = 0x18
	// Bit mask of P24 field.
	PIO_IFDR_P24_Msk = 0x1000000
	// Bit P24.
	PIO_IFDR_P24 = 0x1000000
	// Position of P25 field.
	PIO_IFDR_P25_Pos = 0x19
	// Bit mask of P25 field.
	PIO_IFDR_P25_Msk = 0x2000000
	// Bit P25.
	PIO_IFDR_P25 = 0x2000000
	// Position of P26 field.
	PIO_IFDR_P26_Pos = 0x1a
	// Bit mask of P26 field.
	PIO_IFDR_P26_Msk = 0x4000000
	// Bit P26.
	PIO_IFDR_P26 = 0x4000000
	// Position of P27 field.
	PIO_IFDR_P27_Pos = 0x1b
	// Bit mask of P27 field.
	PIO_IFDR_P27_Msk = 0x8000000
	// Bit P27.
	PIO_IFDR_P27 = 0x8000000
	// Position of P28 field.
	PIO_IFDR_P28_Pos = 0x1c
	// Bit mask of P28 field.
	PIO_IFDR_P28_Msk = 0x10000000
	// Bit P28.
	PIO_IFDR_P28 = 0x10000000
	// Position of P29 field.
	PIO_IFDR_P29_Pos = 0x1d
	// Bit mask of P29 field.
	PIO_IFDR_P29_Msk = 0x20000000
	// Bit P29.
	PIO_IFDR_P29 = 0x20000000
	// Position of P30 field.
	PIO_IFDR_P30_Pos = 0x1e
	// Bit mask of P30 field.
	PIO_IFDR_P30_Msk = 0x40000000
	// Bit P30.
	PIO_IFDR_P30 = 0x40000000
	// Position of P31 field.
	PIO_IFDR_P31_Pos = 0x1f
	// Bit mask of P31 field.
	PIO_IFDR_P31_Msk = 0x80000000
	// Bit P31.
	PIO_IFDR_P31 = 0x80000000

	// IFSR: Glitch Input Filter Status Register
	// Position of P0 field.
	PIO_IFSR_P0_Pos = 0x0
	// Bit mask of P0 field.
	PIO_IFSR_P0_Msk = 0x1
	// Bit P0.
	PIO_IFSR_P0 = 0x1
	// Position of P1 field.
	PIO_IFSR_P1_Pos = 0x1
	// Bit mask of P1 field.
	PIO_IFSR_P1_Msk = 0x2
	// Bit P1.
	PIO_IFSR_P1 = 0x2
	// Position of P2 field.
	PIO_IFSR_P2_Pos = 0x2
	// Bit mask of P2 field.
	PIO_IFSR_P2_Msk = 0x4
	// Bit P2.
	PIO_IFSR_P2 = 0x4
	// Position of P3 field.
	PIO_IFSR_P3_Pos = 0x3
	// Bit mask of P3 field.
	PIO_IFSR_P3_Msk = 0x8
	// Bit P3.
	PIO_IFSR_P3 = 0x8
	// Position of P4 field.
	PIO_IFSR_P4_Pos = 0x4
	// Bit mask of P4 field.
	PIO_IFSR_P4_Msk = 0x10
	// Bit P4.
	PIO_IFSR_P4 = 0x10
	// Position of P5 field.
	PIO_IFSR_P5_Pos = 0x5
	// Bit mask of P5 field.
	PIO_IFSR_P5_Msk = 0x20
	// Bit P5.
	PIO_IFSR_P5 = 0x20
	// Position of P6 field.
	PIO_IFSR_P6_Pos = 0x6
	// Bit mask of P6 field.
	PIO_IFSR_P6_Msk = 0x40
	// Bit P6.
	PIO_IFSR_P6 = 0x40
	// Position of P7 field.
	PIO_IFSR_P7_Pos = 0x7
	// Bit mask of P7 field.
	PIO_IFSR_P7_Msk = 0x80
	// Bit P7.
	PIO_IFSR_P7 = 0x80
	// Position of P8 field.
	PIO_IFSR_P8_Pos = 0x8
	// Bit mask of P8 field.
	PIO_IFSR_P8_Msk = 0x100
	// Bit P8.
	PIO_IFSR_P8 = 0x100
	// Position of P9 field.
	PIO_IFSR_P9_Pos = 0x9
	// Bit mask of P9 field.
	PIO_IFSR_P9_Msk = 0x200
	// Bit P9.
	PIO_IFSR_P9 = 0x200
	// Position of P10 field.
	PIO_IFSR_P10_Pos = 0xa
	// Bit mask of P10 field.
	PIO_IFSR_P10_Msk = 0x400
	// Bit P10.
	PIO_IFSR_P10 = 0x400
	// Position of P11 field.
	PIO_IFSR_P11_Pos = 0xb
	// Bit mask of P11 field.
	PIO_IFSR_P11_Msk = 0x800
	// Bit P11.
	PIO_IFSR_P11 = 0x800
	// Position of P12 field.
	PIO_IFSR_P12_Pos = 0xc
	// Bit mask of P12 field.
	PIO_IFSR_P12_Msk = 0x1000
	// Bit P12.
	PIO_IFSR_P12 = 0x1000
	// Position of P13 field.
	PIO_IFSR_P13_Pos = 0xd
	// Bit mask of P13 field.
	PIO_IFSR_P13_Msk = 0x2000
	// Bit P13.
	PIO_IFSR_P13 = 0x2000
	// Position of P14 field.
	PIO_IFSR_P14_Pos = 0xe
	// Bit mask of P14 field.
	PIO_IFSR_P14_Msk = 0x4000
	// Bit P14.
	PIO_IFSR_P14 = 0x4000
	// Position of P15 field.
	PIO_IFSR_P15_Pos = 0xf
	// Bit mask of P15 field.
	PIO_IFSR_P15_Msk = 0x8000
	// Bit P15.
	PIO_IFSR_P15 = 0x8000
	// Position of P16 field.
	PIO_IFSR_P16_Pos = 0x10
	// Bit mask of P16 field.
	PIO_IFSR_P16_Msk = 0x10000
	// Bit P16.
	PIO_IFSR_P16 = 0x10000
	// Position of P17 field.
	PIO_IFSR_P17_Pos = 0x11
	// Bit mask of P17 field.
	PIO_IFSR_P17_Msk = 0x20000
	// Bit P17.
	PIO_IFSR_P17 = 0x20000
	// Position of P18 field.
	PIO_IFSR_P18_Pos = 0x12
	// Bit mask of P18 field.
	PIO_IFSR_P18_Msk = 0x40000
	// Bit P18.
	PIO_IFSR_P18 = 0x40000
	// Position of P19 field.
	PIO_IFSR_P19_Pos = 0x13
	// Bit mask of P19 field.
	PIO_IFSR_P19_Msk = 0x80000
	// Bit P19.
	PIO_IFSR_P19 = 0x80000
	// Position of P20 field.
	PIO_IFSR_P20_Pos = 0x14
	// Bit mask of P20 field.
	PIO_IFSR_P20_Msk = 0x100000
	// Bit P20.
	PIO_IFSR_P20 = 0x100000
	// Position of P21 field.
	PIO_IFSR_P21_Pos = 0x15
	// Bit mask of P21 field.
	PIO_IFSR_P21_Msk = 0x200000
	// Bit P21.
	PIO_IFSR_P21 = 0x200000
	// Position of P22 field.
	PIO_IFSR_P22_Pos = 0x16
	// Bit mask of P22 field.
	PIO_IFSR_P22_Msk = 0x400000
	// Bit P22.
	PIO_IFSR_P22 = 0x400000
	// Position of P23 field.
	PIO_IFSR_P23_Pos = 0x17
	// Bit mask of P23 field.
	PIO_IFSR_P23_Msk = 0x800000
	// Bit P23.
	PIO_IFSR_P23 = 0x800000
	// Position of P24 field.
	PIO_IFSR_P24_Pos = 0x18
	// Bit mask of P24 field.
	PIO_IFSR_P24_Msk = 0x1000000
	// Bit P24.
	PIO_IFSR_P24 = 0x1000000
	// Position of P25 field.
	PIO_IFSR_P25_Pos = 0x19
	// Bit mask of P25 field.
	PIO_IFSR_P25_Msk = 0x2000000
	// Bit P25.
	PIO_IFSR_P25 = 0x2000000
	// Position of P26 field.
	PIO_IFSR_P26_Pos = 0x1a
	// Bit mask of P26 field.
	PIO_IFSR_P26_Msk = 0x4000000
	// Bit P26.
	PIO_IFSR_P26 = 0x4000000
	// Position of P27 field.
	PIO_IFSR_P27_Pos = 0x1b
	// Bit mask of P27 field.
	PIO_IFSR_P27_Msk = 0x8000000
	// Bit P27.
	PIO_IFSR_P27 = 0x8000000
	// Position of P28 field.
	PIO_IFSR_P28_Pos = 0x1c
	// Bit mask of P28 field.
	PIO_IFSR_P28_Msk = 0x10000000
	// Bit P28.
	PIO_IFSR_P28 = 0x10000000
	// Position of P29 field.
	PIO_IFSR_P29_Pos = 0x1d
	// Bit mask of P29 field.
	PIO_IFSR_P29_Msk = 0x20000000
	// Bit P29.
	PIO_IFSR_P29 = 0x20000000
	// Position of P30 field.
	PIO_IFSR_P30_Pos = 0x1e
	// Bit mask of P30 field.
	PIO_IFSR_P30_Msk = 0x40000000
	// Bit P30.
	PIO_IFSR_P30 = 0x40000000
	// Position of P31 field.
	PIO_IFSR_P31_Pos = 0x1f
	// Bit mask of P31 field.
	PIO_IFSR_P31_Msk = 0x80000000
	// Bit P31.
	PIO_IFSR_P31 = 0x80000000

	// SODR: Set Output Data Register
	// Position of P0 field.
	PIO_SODR_P0_Pos = 0x0
	// Bit mask of P0 field.
	PIO_SODR_P0_Msk = 0x1
	// Bit P0.
	PIO_SODR_P0 = 0x1
	// Position of P1 field.
	PIO_SODR_P1_Pos = 0x1
	// Bit mask of P1 field.
	PIO_SODR_P1_Msk = 0x2
	// Bit P1.
	PIO_SODR_P1 = 0x2
	// Position of P2 field.
	PIO_SODR_P2_Pos = 0x2
	// Bit mask of P2 field.
	PIO_SODR_P2_Msk = 0x4
	// Bit P2.
	PIO_SODR_P2 = 0x4
	// Position of P3 field.
	PIO_SODR_P3_Pos = 0x3
	// Bit mask of P3 field.
	PIO_SODR_P3_Msk = 0x8
	// Bit P3.
	PIO_SODR_P3 = 0x8
	// Position of P4 field.
	PIO_SODR_P4_Pos = 0x4
	// Bit mask of P4 field.
	PIO_SODR_P4_Msk = 0x10
	// Bit P4.
	PIO_SODR_P4 = 0x10
	// Position of P5 field.
	PIO_SODR_P5_Pos = 0x5
	// Bit mask of P5 field.
	PIO_SODR_P5_Msk = 0x20
	// Bit P5.
	PIO_SODR_P5 = 0x20
	// Position of P6 field.
	PIO_SODR_P6_Pos = 0x6
	// Bit mask of P6 field.
	PIO_SODR_P6_Msk = 0x40
	// Bit P6.
	PIO_SODR_P6 = 0x40
	// Position of P7 field.
	PIO_SODR_P7_Pos = 0x7
	// Bit mask of P7 field.
	PIO_SODR_P7_Msk = 0x80
	// Bit P7.
	PIO_SODR_P7 = 0x80
	// Position of P8 field.
	PIO_SODR_P8_Pos = 0x8
	// Bit mask of P8 field.
	PIO_SODR_P8_Msk = 0x100
	// Bit P8.
	PIO_SODR_P8 = 0x100
	// Position of P9 field.
	PIO_SODR_P9_Pos = 0x9
	// Bit mask of P9 field.
	PIO_SODR_P9_Msk = 0x200
	// Bit P9.
	PIO_SODR_P9 = 0x200
	// Position of P10 field.
	PIO_SODR_P10_Pos = 0xa
	// Bit mask of P10 field.
	PIO_SODR_P10_Msk = 0x400
	// Bit P10.
	PIO_SODR_P10 = 0x400
	// Position of P11 field.
	PIO_SODR_P11_Pos = 0xb
	// Bit mask of P11 field.
	PIO_SODR_P11_Msk = 0x800
	// Bit P11.
	PIO_SODR_P11 = 0x800
	// Position of P12 field.
	PIO_SODR_P12_Pos = 0xc
	// Bit mask of P12 field.
	PIO_SODR_P12_Msk = 0x1000
	// Bit P12.
	PIO_SODR_P12 = 0x1000
	// Position of P13 field.
	PIO_SODR_P13_Pos = 0xd
	// Bit mask of P13 field.
	PIO_SODR_P13_Msk = 0x2000
	// Bit P13.
	PIO_SODR_P13 = 0x2000
	// Position of P14 field.
	PIO_SODR_P14_Pos = 0xe
	// Bit mask of P14 field.
	PIO_SODR_P14_Msk = 0x4000
	// Bit P14.
	PIO_SODR_P14 = 0x4000
	// Position of P15 field.
	PIO_SODR_P15_Pos = 0xf
	// Bit mask of P15 field.
	PIO_SODR_P15_Msk = 0x8000
	// Bit P15.
	PIO_SODR_P15 = 0x8000
	// Position of P16 field.
	PIO_SODR_P16_Pos = 0x10
	// Bit mask of P16 field.
	PIO_SODR_P16_Msk = 0x10000
	// Bit P16.
	PIO_SODR_P16 = 0x10000
	// Position of P17 field.
	PIO_SODR_P17_Pos = 0x11
	// Bit mask of P17 field.
	PIO_SODR_P17_Msk = 0x20000
	// Bit P17.
	PIO_SODR_P17 = 0x20000
	// Position of P18 field.
	PIO_SODR_P18_Pos = 0x12
	// Bit mask of P18 field.
	PIO_SODR_P18_Msk = 0x40000
	// Bit P18.
	PIO_SODR_P18 = 0x40000
	// Position of P19 field.
	PIO_SODR_P19_Pos = 0x13
	// Bit mask of P19 field.
	PIO_SODR_P19_Msk = 0x80000
	// Bit P19.
	PIO_SODR_P19 = 0x80000
	// Position of P20 field.
	PIO_SODR_P20_Pos = 0x14
	// Bit mask of P20 field.
	PIO_SODR_P20_Msk = 0x100000
	// Bit P20.
	PIO_SODR_P20 = 0x100000
	// Position of P21 field.
	PIO_SODR_P21_Pos = 0x15
	// Bit mask of P21 field.
	PIO_SODR_P21_Msk = 0x200000
	// Bit P21.
	PIO_SODR_P21 = 0x200000
	// Position of P22 field.
	PIO_SODR_P22_Pos = 0x16
	// Bit mask of P22 field.
	PIO_SODR_P22_Msk = 0x400000
	// Bit P22.
	PIO_SODR_P22 = 0x400000
	// Position of P23 field.
	PIO_SODR_P23_Pos = 0x17
	// Bit mask of P23 field.
	PIO_SODR_P23_Msk = 0x800000
	// Bit P23.
	PIO_SODR_P23 = 0x800000
	// Position of P24 field.
	PIO_SODR_P24_Pos = 0x18
	// Bit mask of P24 field.
	PIO_SODR_P24_Msk = 0x1000000
	// Bit P24.
	PIO_SODR_P24 = 0x1000000
	// Position of P25 field.
	PIO_SODR_P25_Pos = 0x19
	// Bit mask of P25 field.
	PIO_SODR_P25_Msk = 0x2000000
	// Bit P25.
	PIO_SODR_P25 = 0x2000000
	// Position of P26 field.
	PIO_SODR_P26_Pos = 0x1a
	// Bit mask of P26 field.
	PIO_SODR_P26_Msk = 0x4000000
	// Bit P26.
	PIO_SODR_P26 = 0x4000000
	// Position of P27 field.
	PIO_SODR_P27_Pos = 0x1b
	// Bit mask of P27 field.
	PIO_SODR_P27_Msk = 0x8000000
	// Bit P27.
	PIO_SODR_P27 = 0x8000000
	// Position of P28 field.
	PIO_SODR_P28_Pos = 0x1c
	// Bit mask of P28 field.
	PIO_SODR_P28_Msk = 0x10000000
	// Bit P28.
	PIO_SODR_P28 = 0x10000000
	// Position of P29 field.
	PIO_SODR_P29_Pos = 0x1d
	// Bit mask of P29 field.
	PIO_SODR_P29_Msk = 0x20000000
	// Bit P29.
	PIO_SODR_P29 = 0x20000000
	// Position of P30 field.
	PIO_SODR_P30_Pos = 0x1e
	// Bit mask of P30 field.
	PIO_SODR_P30_Msk = 0x40000000
	// Bit P30.
	PIO_SODR_P30 = 0x40000000
	// Position of P31 field.
	PIO_SODR_P31_Pos = 0x1f
	// Bit mask of P31 field.
	PIO_SODR_P31_Msk = 0x80000000
	// Bit P31.
	PIO_SODR_P31 = 0x80000000

	// CODR: Clear Output Data Register
	// Position of P0 field.
	PIO_CODR_P0_Pos = 0x0
	// Bit mask of P0 field.
	PIO_CODR_P0_Msk = 0x1
	// Bit P0.
	PIO_CODR_P0 = 0x1
	// Position of P1 field.
	PIO_CODR_P1_Pos = 0x1
	// Bit mask of P1 field.
	PIO_CODR_P1_Msk = 0x2
	// Bit P1.
	PIO_CODR_P1 = 0x2
	// Position of P2 field.
	PIO_CODR_P2_Pos = 0x2
	// Bit mask of P2 field.
	PIO_CODR_P2_Msk = 0x4
	// Bit P2.
	PIO_CODR_P2 = 0x4
	// Position of P3 field.
	PIO_CODR_P3_Pos = 0x3
	// Bit mask of P3 field.
	PIO_CODR_P3_Msk = 0x8
	// Bit P3.
	PIO_CODR_P3 = 0x8
	// Position of P4 field.
	PIO_CODR_P4_Pos = 0x4
	// Bit mask of P4 field.
	PIO_CODR_P4_Msk = 0x10
	// Bit P4.
	PIO_CODR_P4 = 0x10
	// Position of P5 field.
	PIO_CODR_P5_Pos = 0x5
	// Bit mask of P5 field.
	PIO_CODR_P5_Msk = 0x20
	// Bit P5.
	PIO_CODR_P5 = 0x20
	// Position of P6 field.
	PIO_CODR_P6_Pos = 0x6
	// Bit mask of P6 field.
	PIO_CODR_P6_Msk = 0x40
	// Bit P6.
	PIO_CODR_P6 = 0x40
	// Position of P7 field.
	PIO_CODR_P7_Pos = 0x7
	// Bit mask of P7 field.
	PIO_CODR_P7_Msk = 0x80
	// Bit P7.
	PIO_CODR_P7 = 0x80
	// Position of P8 field.
	PIO_CODR_P8_Pos = 0x8
	// Bit mask of P8 field.
	PIO_CODR_P8_Msk = 0x100
	// Bit P8.
	PIO_CODR_P8 = 0x100
	// Position of P9 field.
	PIO_CODR_P9_Pos = 0x9
	// Bit mask of P9 field.
	PIO_CODR_P9_Msk = 0x200
	// Bit P9.
	PIO_CODR_P9 = 0x200
	// Position of P10 field.
	PIO_CODR_P10_Pos = 0xa
	// Bit mask of P10 field.
	PIO_CODR_P10_Msk = 0x400
	// Bit P10.
	PIO_CODR_P10 = 0x400
	// Position of P11 field.
	PIO_CODR_P11_Pos = 0xb
	// Bit mask of P11 field.
	PIO_CODR_P11_Msk = 0x800
	// Bit P11.
	PIO_CODR_P11 = 0x800
	// Position of P12 field.
	PIO_CODR_P12_Pos = 0xc
	// Bit mask of P12 field.
	PIO_CODR_P12_Msk = 0x1000
	// Bit P12.
	PIO_CODR_P12 = 0x1000
	// Position of P13 field.
	PIO_CODR_P13_Pos = 0xd
	// Bit mask of P13 field.
	PIO_CODR_P13_Msk = 0x2000
	// Bit P13.
	PIO_CODR_P13 = 0x2000
	// Position of P14 field.
	PIO_CODR_P14_Pos = 0xe
	// Bit mask of P14 field.
	PIO_CODR_P14_Msk = 0x4000
	// Bit P14.
	PIO_CODR_P14 = 0x4000
	// Position of P15 field.
	PIO_CODR_P15_Pos = 0xf
	// Bit mask of P15 field.
	PIO_CODR_P15_Msk = 0x8000
	// Bit P15.
	PIO_CODR_P15 = 0x8000
	// Position of P16 field.
	PIO_CODR_P16_Pos = 0x10
	// Bit mask of P16 field.
	PIO_CODR_P16_Msk = 0x10000
	// Bit P16.
	PIO_CODR_P16 = 0x10000
	// Position of P17 field.
	PIO_CODR_P17_Pos = 0x11
	// Bit mask of P17 field.
	PIO_CODR_P17_Msk = 0x20000
	// Bit P17.
	PIO_CODR_P17 = 0x20000
	// Position of P18 field.
	PIO_CODR_P18_Pos = 0x12
	// Bit mask of P18 field.
	PIO_CODR_P18_Msk = 0x40000
	// Bit P18.
	PIO_CODR_P18 = 0x40000
	// Position of P19 field.
	PIO_CODR_P19_Pos = 0x13
	// Bit mask of P19 field.
	PIO_CODR_P19_Msk = 0x80000
	// Bit P19.
	PIO_CODR_P19 = 0x80000
	// Position of P20 field.
	PIO_CODR_P20_Pos = 0x14
	// Bit mask of P20 field.
	PIO_CODR_P20_Msk = 0x100000
	// Bit P20.
	PIO_CODR_P20 = 0x100000
	// Position of P21 field.
	PIO_CODR_P21_Pos = 0x15
	// Bit mask of P21 field.
	PIO_CODR_P21_Msk = 0x200000
	// Bit P21.
	PIO_CODR_P21 = 0x200000
	// Position of P22 field.
	PIO_CODR_P22_Pos = 0x16
	// Bit mask of P22 field.
	PIO_CODR_P22_Msk = 0x400000
	// Bit P22.
	PIO_CODR_P22 = 0x400000
	// Position of P23 field.
	PIO_CODR_P23_Pos = 0x17
	// Bit mask of P23 field.
	PIO_CODR_P23_Msk = 0x800000
	// Bit P23.
	PIO_CODR_P23 = 0x800000
	// Position of P24 field.
	PIO_CODR_P24_Pos = 0x18
	// Bit mask of P24 field.
	PIO_CODR_P24_Msk = 0x1000000
	// Bit P24.
	PIO_CODR_P24 = 0x1000000
	// Position of P25 field.
	PIO_CODR_P25_Pos = 0x19
	// Bit mask of P25 field.
	PIO_CODR_P25_Msk = 0x2000000
	// Bit P25.
	PIO_CODR_P25 = 0x2000000
	// Position of P26 field.
	PIO_CODR_P26_Pos = 0x1a
	// Bit mask of P26 field.
	PIO_CODR_P26_Msk = 0x4000000
	// Bit P26.
	PIO_CODR_P26 = 0x4000000
	// Position of P27 field.
	PIO_CODR_P27_Pos = 0x1b
	// Bit mask of P27 field.
	PIO_CODR_P27_Msk = 0x8000000
	// Bit P27.
	PIO_CODR_P27 = 0x8000000
	// Position of P28 field.
	PIO_CODR_P28_Pos = 0x1c
	// Bit mask of P28 field.
	PIO_CODR_P28_Msk = 0x10000000
	// Bit P28.
	PIO_CODR_P28 = 0x10000000
	// Position of P29 field.
	PIO_CODR_P29_Pos = 0x1d
	// Bit mask of P29 field.
	PIO_CODR_P29_Msk = 0x20000000
	// Bit P29.
	PIO_CODR_P29 = 0x20000000
	// Position of P30 field.
	PIO_CODR_P30_Pos = 0x1e
	// Bit mask of P30 field.
	PIO_CODR_P30_Msk = 0x40000000
	// Bit P30.
	PIO_CODR_P30 = 0x40000000
	// Position of P31 field.
	PIO_CODR_P31_Pos = 0x1f
	// Bit mask of P31 field.
	PIO_CODR_P31_Msk = 0x80000000
	// Bit P31.
	PIO_CODR_P31 = 0x80000000

	// ODSR: Output Data Status Register
	// Position of P0 field.
	PIO_ODSR_P0_Pos = 0x0
	// Bit mask of P0 field.
	PIO_ODSR_P0_Msk = 0x1
	// Bit P0.
	PIO_ODSR_P0 = 0x1
	// Position of P1 field.
	PIO_ODSR_P1_Pos = 0x1
	// Bit mask of P1 field.
	PIO_ODSR_P1_Msk = 0x2
	// Bit P1.
	PIO_ODSR_P1 = 0x2
	// Position of P2 field.
	PIO_ODSR_P2_Pos = 0x2
	// Bit mask of P2 field.
	PIO_ODSR_P2_Msk = 0x4
	// Bit P2.
	PIO_ODSR_P2 = 0x4
	// Position of P3 field.
	PIO_ODSR_P3_Pos = 0x3
	// Bit mask of P3 field.
	PIO_ODSR_P3_Msk = 0x8
	// Bit P3.
	PIO_ODSR_P3 = 0x8
	// Position of P4 field.
	PIO_ODSR_P4_Pos = 0x4
	// Bit mask of P4 field.
	PIO_ODSR_P4_Msk = 0x10
	// Bit P4.
	PIO_ODSR_P4 = 0x10
	// Position of P5 field.
	PIO_ODSR_P5_Pos = 0x5
	// Bit mask of P5 field.
	PIO_ODSR_P5_Msk = 0x20
	// Bit P5.
	PIO_ODSR_P5 = 0x20
	// Position of P6 field.
	PIO_ODSR_P6_Pos = 0x6
	// Bit mask of P6 field.
	PIO_ODSR_P6_Msk = 0x40
	// Bit P6.
	PIO_ODSR_P6 = 0x40
	// Position of P7 field.
	PIO_ODSR_P7_Pos = 0x7
	// Bit mask of P7 field.
	PIO_ODSR_P7_Msk = 0x80
	// Bit P7.
	PIO_ODSR_P7 = 0x80
	// Position of P8 field.
	PIO_ODSR_P8_Pos = 0x8
	// Bit mask of P8 field.
	PIO_ODSR_P8_Msk = 0x100
	// Bit P8.
	PIO_ODSR_P8 = 0x100
	// Position of P9 field.
	PIO_ODSR_P9_Pos = 0x9
	// Bit mask of P9 field.
	PIO_ODSR_P9_Msk = 0x200
	// Bit P9.
	PIO_ODSR_P9 = 0x200
	// Position of P10 field.
	PIO_ODSR_P10_Pos = 0xa
	// Bit mask of P10 field.
	PIO_ODSR_P10_Msk = 0x400
	// Bit P10.
	PIO_ODSR_P10 = 0x400
	// Position of P11 field.
	PIO_ODSR_P11_Pos = 0xb
	// Bit mask of P11 field.
	PIO_ODSR_P11_Msk = 0x800
	// Bit P11.
	PIO_ODSR_P11 = 0x800
	// Position of P12 field.
	PIO_ODSR_P12_Pos = 0xc
	// Bit mask of P12 field.
	PIO_ODSR_P12_Msk = 0x1000
	// Bit P12.
	PIO_ODSR_P12 = 0x1000
	// Position of P13 field.
	PIO_ODSR_P13_Pos = 0xd
	// Bit mask of P13 field.
	PIO_ODSR_P13_Msk = 0x2000
	// Bit P13.
	PIO_ODSR_P13 = 0x2000
	// Position of P14 field.
	PIO_ODSR_P14_Pos = 0xe
	// Bit mask of P14 field.
	PIO_ODSR_P14_Msk = 0x4000
	// Bit P14.
	PIO_ODSR_P14 = 0x4000
	// Position of P15 field.
	PIO_ODSR_P15_Pos = 0xf
	// Bit mask of P15 field.
	PIO_ODSR_P15_Msk = 0x8000
	// Bit P15.
	PIO_ODSR_P15 = 0x8000
	// Position of P16 field.
	PIO_ODSR_P16_Pos = 0x10
	// Bit mask of P16 field.
	PIO_ODSR_P16_Msk = 0x10000
	// Bit P16.
	PIO_ODSR_P16 = 0x10000
	// Position of P17 field.
	PIO_ODSR_P17_Pos = 0x11
	// Bit mask of P17 field.
	PIO_ODSR_P17_Msk = 0x20000
	// Bit P17.
	PIO_ODSR_P17 = 0x20000
	// Position of P18 field.
	PIO_ODSR_P18_Pos = 0x12
	// Bit mask of P18 field.
	PIO_ODSR_P18_Msk = 0x40000
	// Bit P18.
	PIO_ODSR_P18 = 0x40000
	// Position of P19 field.
	PIO_ODSR_P19_Pos = 0x13
	// Bit mask of P19 field.
	PIO_ODSR_P19_Msk = 0x80000
	// Bit P19.
	PIO_ODSR_P19 = 0x80000
	// Position of P20 field.
	PIO_ODSR_P20_Pos = 0x14
	// Bit mask of P20 field.
	PIO_ODSR_P20_Msk = 0x100000
	// Bit P20.
	PIO_ODSR_P20 = 0x100000
	// Position of P21 field.
	PIO_ODSR_P21_Pos = 0x15
	// Bit mask of P21 field.
	PIO_ODSR_P21_Msk = 0x200000
	// Bit P21.
	PIO_ODSR_P21 = 0x200000
	// Position of P22 field.
	PIO_ODSR_P22_Pos = 0x16
	// Bit mask of P22 field.
	PIO_ODSR_P22_Msk = 0x400000
	// Bit P22.
	PIO_ODSR_P22 = 0x400000
	// Position of P23 field.
	PIO_ODSR_P23_Pos = 0x17
	// Bit mask of P23 field.
	PIO_ODSR_P23_Msk = 0x800000
	// Bit P23.
	PIO_ODSR_P23 = 0x800000
	// Position of P24 field.
	PIO_ODSR_P24_Pos = 0x18
	// Bit mask of P24 field.
	PIO_ODSR_P24_Msk = 0x1000000
	// Bit P24.
	PIO_ODSR_P24 = 0x1000000
	// Position of P25 field.
	PIO_ODSR_P25_Pos = 0x19
	// Bit mask of P25 field.
	PIO_ODSR_P25_Msk = 0x2000000
	// Bit P25.
	PIO_ODSR_P25 = 0x2000000
	// Position of P26 field.
	PIO_ODSR_P26_Pos = 0x1a
	// Bit mask of P26 field.
	PIO_ODSR_P26_Msk = 0x4000000
	// Bit P26.
	PIO_ODSR_P26 = 0x4000000
	// Position of P27 field.
	PIO_ODSR_P27_Pos = 0x1b
	// Bit mask of P27 field.
	PIO_ODSR_P27_Msk = 0x8000000
	// Bit P27.
	PIO_ODSR_P27 = 0x8000000
	// Position of P28 field.
	PIO_ODSR_P28_Pos = 0x1c
	// Bit mask of P28 field.
	PIO_ODSR_P28_Msk = 0x10000000
	// Bit P28.
	PIO_ODSR_P28 = 0x10000000
	// Position of P29 field.
	PIO_ODSR_P29_Pos = 0x1d
	// Bit mask of P29 field.
	PIO_ODSR_P29_Msk = 0x20000000
	// Bit P29.
	PIO_ODSR_P29 = 0x20000000
	// Position of P30 field.
	PIO_ODSR_P30_Pos = 0x1e
	// Bit mask of P30 field.
	PIO_ODSR_P30_Msk = 0x40000000
	// Bit P30.
	PIO_ODSR_P30 = 0x40000000
	// Position of P31 field.
	PIO_ODSR_P31_Pos = 0x1f
	// Bit mask of P31 field.
	PIO_ODSR_P31_Msk = 0x80000000
	// Bit P31.
	PIO_ODSR_P31 = 0x80000000

	// PDSR: Pin Data Status Register
	// Position of P0 field.
	PIO_PDSR_P0_Pos = 0x0
	// Bit mask of P0 field.
	PIO_PDSR_P0_Msk = 0x1
	// Bit P0.
	PIO_PDSR_P0 = 0x1
	// Position of P1 field.
	PIO_PDSR_P1_Pos = 0x1
	// Bit mask of P1 field.
	PIO_PDSR_P1_Msk = 0x2
	// Bit P1.
	PIO_PDSR_P1 = 0x2
	// Position of P2 field.
	PIO_PDSR_P2_Pos = 0x2
	// Bit mask of P2 field.
	PIO_PDSR_P2_Msk = 0x4
	// Bit P2.
	PIO_PDSR_P2 = 0x4
	// Position of P3 field.
	PIO_PDSR_P3_Pos = 0x3
	// Bit mask of P3 field.
	PIO_PDSR_P3_Msk = 0x8
	// Bit P3.
	PIO_PDSR_P3 = 0x8
	// Position of P4 field.
	PIO_PDSR_P4_Pos = 0x4
	// Bit mask of P4 field.
	PIO_PDSR_P4_Msk = 0x10
	// Bit P4.
	PIO_PDSR_P4 = 0x10
	// Position of P5 field.
	PIO_PDSR_P5_Pos = 0x5
	// Bit mask of P5 field.
	PIO_PDSR_P5_Msk = 0x20
	// Bit P5.
	PIO_PDSR_P5 = 0x20
	// Position of P6 field.
	PIO_PDSR_P6_Pos = 0x6
	// Bit mask of P6 field.
	PIO_PDSR_P6_Msk = 0x40
	// Bit P6.
	PIO_PDSR_P6 = 0x40
	// Position of P7 field.
	PIO_PDSR_P7_Pos = 0x7
	// Bit mask of P7 field.
	PIO_PDSR_P7_Msk = 0x80
	// Bit P7.
	PIO_PDSR_P7 = 0x80
	// Position of P8 field.
	PIO_PDSR_P8_Pos = 0x8
	// Bit mask of P8 field.
	PIO_PDSR_P8_Msk = 0x100
	// Bit P8.
	PIO_PDSR_P8 = 0x100
	// Position of P9 field.
	PIO_PDSR_P9_Pos = 0x9
	// Bit mask of P9 field.
	PIO_PDSR_P9_Msk = 0x200
	// Bit P9.
	PIO_PDSR_P9 = 0x200
	// Position of P10 field.
	PIO_PDSR_P10_Pos = 0xa
	// Bit mask of P10 field.
	PIO_PDSR_P10_Msk = 0x400
	// Bit P10.
	PIO_PDSR_P10 = 0x400
	// Position of P11 field.
	PIO_PDSR_P11_Pos = 0xb
	// Bit mask of P11 field.
	PIO_PDSR_P11_Msk = 0x800
	// Bit P11.
	PIO_PDSR_P11 = 0x800
	// Position of P12 field.
	PIO_PDSR_P12_Pos = 0xc
	// Bit mask of P12 field.
	PIO_PDSR_P12_Msk = 0x1000
	// Bit P12.
	PIO_PDSR_P12 = 0x1000
	// Position of P13 field.
	PIO_PDSR_P13_Pos = 0xd
	// Bit mask of P13 field.
	PIO_PDSR_P13_Msk = 0x2000
	// Bit P13.
	PIO_PDSR_P13 = 0x2000
	// Position of P14 field.
	PIO_PDSR_P14_Pos = 0xe
	// Bit mask of P14 field.
	PIO_PDSR_P14_Msk = 0x4000
	// Bit P14.
	PIO_PDSR_P14 = 0x4000
	// Position of P15 field.
	PIO_PDSR_P15_Pos = 0xf
	// Bit mask of P15 field.
	PIO_PDSR_P15_Msk = 0x8000
	// Bit P15.
	PIO_PDSR_P15 = 0x8000
	// Position of P16 field.
	PIO_PDSR_P16_Pos = 0x10
	// Bit mask of P16 field.
	PIO_PDSR_P16_Msk = 0x10000
	// Bit P16.
	PIO_PDSR_P16 = 0x10000
	// Position of P17 field.
	PIO_PDSR_P17_Pos = 0x11
	// Bit mask of P17 field.
	PIO_PDSR_P17_Msk = 0x20000
	// Bit P17.
	PIO_PDSR_P17 = 0x20000
	// Position of P18 field.
	PIO_PDSR_P18_Pos = 0x12
	// Bit mask of P18 field.
	PIO_PDSR_P18_Msk = 0x40000
	// Bit P18.
	PIO_PDSR_P18 = 0x40000
	// Position of P19 field.
	PIO_PDSR_P19_Pos = 0x13
	// Bit mask of P19 field.
	PIO_PDSR_P19_Msk = 0x80000
	// Bit P19.
	PIO_PDSR_P19 = 0x80000
	// Position of P20 field.
	PIO_PDSR_P20_Pos = 0x14
	// Bit mask of P20 field.
	PIO_PDSR_P20_Msk = 0x100000
	// Bit P20.
	PIO_PDSR_P20 = 0x100000
	// Position of P21 field.
	PIO_PDSR_P21_Pos = 0x15
	// Bit mask of P21 field.
	PIO_PDSR_P21_Msk = 0x200000
	// Bit P21.
	PIO_PDSR_P21 = 0x200000
	// Position of P22 field.
	PIO_PDSR_P22_Pos = 0x16
	// Bit mask of P22 field.
	PIO_PDSR_P22_Msk = 0x400000
	// Bit P22.
	PIO_PDSR_P22 = 0x400000
	// Position of P23 field.
	PIO_PDSR_P23_Pos = 0x17
	// Bit mask of P23 field.
	PIO_PDSR_P23_Msk = 0x800000
	// Bit P23.
	PIO_PDSR_P23 = 0x800000
	// Position of P24 field.
	PIO_PDSR_P24_Pos = 0x18
	// Bit mask of P24 field.
	PIO_PDSR_P24_Msk = 0x1000000
	// Bit P24.
	PIO_PDSR_P24 = 0x1000000
	// Position of P25 field.
	PIO_PDSR_P25_Pos = 0x19
	// Bit mask of P25 field.
	PIO_PDSR_P25_Msk = 0x2000000
	// Bit P25.
	PIO_PDSR_P25 = 0x2000000
	// Position of P26 field.
	PIO_PDSR_P26_Pos = 0x1a
	// Bit mask of P26 field.
	PIO_PDSR_P26_Msk = 0x4000000
	// Bit P26.
	PIO_PDSR_P26 = 0x4000000
	// Position of P27 field.
	PIO_PDSR_P27_Pos = 0x1b
	// Bit mask of P27 field.
	PIO_PDSR_P27_Msk = 0x8000000
	// Bit P27.
	PIO_PDSR_P27 = 0x8000000
	// Position of P28 field.
	PIO_PDSR_P28_Pos = 0x1c
	// Bit mask of P28 field.
	PIO_PDSR_P28_Msk = 0x10000000
	// Bit P28.
	PIO_PDSR_P28 = 0x10000000
	// Position of P29 field.
	PIO_PDSR_P29_Pos = 0x1d
	// Bit mask of P29 field.
	PIO_PDSR_P29_Msk = 0x20000000
	// Bit P29.
	PIO_PDSR_P29 = 0x20000000
	// Position of P30 field.
	PIO_PDSR_P30_Pos = 0x1e
	// Bit mask of P30 field.
	PIO_PDSR_P30_Msk = 0x40000000
	// Bit P30.
	PIO_PDSR_P30 = 0x40000000
	// Position of P31 field.
	PIO_PDSR_P31_Pos = 0x1f
	// Bit mask of P31 field.
	PIO_PDSR_P31_Msk = 0x80000000
	// Bit P31.
	PIO_PDSR_P31 = 0x80000000

	// IER: Interrupt Enable Register
	// Position of P0 field.
	PIO_IER_P0_Pos = 0x0
	// Bit mask of P0 field.
	PIO_IER_P0_Msk = 0x1
	// Bit P0.
	PIO_IER_P0 = 0x1
	// Position of P1 field.
	PIO_IER_P1_Pos = 0x1
	// Bit mask of P1 field.
	PIO_IER_P1_Msk = 0x2
	// Bit P1.
	PIO_IER_P1 = 0x2
	// Position of P2 field.
	PIO_IER_P2_Pos = 0x2
	// Bit mask of P2 field.
	PIO_IER_P2_Msk = 0x4
	// Bit P2.
	PIO_IER_P2 = 0x4
	// Position of P3 field.
	PIO_IER_P3_Pos = 0x3
	// Bit mask of P3 field.
	PIO_IER_P3_Msk = 0x8
	// Bit P3.
	PIO_IER_P3 = 0x8
	// Position of P4 field.
	PIO_IER_P4_Pos = 0x4
	// Bit mask of P4 field.
	PIO_IER_P4_Msk = 0x10
	// Bit P4.
	PIO_IER_P4 = 0x10
	// Position of P5 field.
	PIO_IER_P5_Pos = 0x5
	// Bit mask of P5 field.
	PIO_IER_P5_Msk = 0x20
	// Bit P5.
	PIO_IER_P5 = 0x20
	// Position of P6 field.
	PIO_IER_P6_Pos = 0x6
	// Bit mask of P6 field.
	PIO_IER_P6_Msk = 0x40
	// Bit P6.
	PIO_IER_P6 = 0x40
	// Position of P7 field.
	PIO_IER_P7_Pos = 0x7
	// Bit mask of P7 field.
	PIO_IER_P7_Msk = 0x80
	// Bit P7.
	PIO_IER_P7 = 0x80
	// Position of P8 field.
	PIO_IER_P8_Pos = 0x8
	// Bit mask of P8 field.
	PIO_IER_P8_Msk = 0x100
	// Bit P8.
	PIO_IER_P8 = 0x100
	// Position of P9 field.
	PIO_IER_P9_Pos = 0x9
	// Bit mask of P9 field.
	PIO_IER_P9_Msk = 0x200
	// Bit P9.
	PIO_IER_P9 = 0x200
	// Position of P10 field.
	PIO_IER_P10_Pos = 0xa
	// Bit mask of P10 field.
	PIO_IER_P10_Msk = 0x400
	// Bit P10.
	PIO_IER_P10 = 0x400
	// Position of P11 field.
	PIO_IER_P11_Pos = 0xb
	// Bit mask of P11 field.
	PIO_IER_P11_Msk = 0x800
	// Bit P11.
	PIO_IER_P11 = 0x800
	// Position of P12 field.
	PIO_IER_P12_Pos = 0xc
	// Bit mask of P12 field.
	PIO_IER_P12_Msk = 0x1000
	// Bit P12.
	PIO_IER_P12 = 0x1000
	// Position of P13 field.
	PIO_IER_P13_Pos = 0xd
	// Bit mask of P13 field.
	PIO_IER_P13_Msk = 0x2000
	// Bit P13.
	PIO_IER_P13 = 0x2000
	// Position of P14 field.
	PIO_IER_P14_Pos = 0xe
	// Bit mask of P14 field.
	PIO_IER_P14_Msk = 0x4000
	// Bit P14.
	PIO_IER_P14 = 0x4000
	// Position of P15 field.
	PIO_IER_P15_Pos = 0xf
	// Bit mask of P15 field.
	PIO_IER_P15_Msk = 0x8000
	// Bit P15.
	PIO_IER_P15 = 0x8000
	// Position of P16 field.
	PIO_IER_P16_Pos = 0x10
	// Bit mask of P16 field.
	PIO_IER_P16_Msk = 0x10000
	// Bit P16.
	PIO_IER_P16 = 0x10000
	// Position of P17 field.
	PIO_IER_P17_Pos = 0x11
	// Bit mask of P17 field.
	PIO_IER_P17_Msk = 0x20000
	// Bit P17.
	PIO_IER_P17 = 0x20000
	// Position of P18 field.
	PIO_IER_P18_Pos = 0x12
	// Bit mask of P18 field.
	PIO_IER_P18_Msk = 0x40000
	// Bit P18.
	PIO_IER_P18 = 0x40000
	// Position of P19 field.
	PIO_IER_P19_Pos = 0x13
	// Bit mask of P19 field.
	PIO_IER_P19_Msk = 0x80000
	// Bit P19.
	PIO_IER_P19 = 0x80000
	// Position of P20 field.
	PIO_IER_P20_Pos = 0x14
	// Bit mask of P20 field.
	PIO_IER_P20_Msk = 0x100000
	// Bit P20.
	PIO_IER_P20 = 0x100000
	// Position of P21 field.
	PIO_IER_P21_Pos = 0x15
	// Bit mask of P21 field.
	PIO_IER_P21_Msk = 0x200000
	// Bit P21.
	PIO_IER_P21 = 0x200000
	// Position of P22 field.
	PIO_IER_P22_Pos = 0x16
	// Bit mask of P22 field.
	PIO_IER_P22_Msk = 0x400000
	// Bit P22.
	PIO_IER_P22 = 0x400000
	// Position of P23 field.
	PIO_IER_P23_Pos = 0x17
	// Bit mask of P23 field.
	PIO_IER_P23_Msk = 0x800000
	// Bit P23.
	PIO_IER_P23 = 0x800000
	// Position of P24 field.
	PIO_IER_P24_Pos = 0x18
	// Bit mask of P24 field.
	PIO_IER_P24_Msk = 0x1000000
	// Bit P24.
	PIO_IER_P24 = 0x1000000
	// Position of P25 field.
	PIO_IER_P25_Pos = 0x19
	// Bit mask of P25 field.
	PIO_IER_P25_Msk = 0x2000000
	// Bit P25.
	PIO_IER_P25 = 0x2000000
	// Position of P26 field.
	PIO_IER_P26_Pos = 0x1a
	// Bit mask of P26 field.
	PIO_IER_P26_Msk = 0x4000000
	// Bit P26.
	PIO_IER_P26 = 0x4000000
	// Position of P27 field.
	PIO_IER_P27_Pos = 0x1b
	// Bit mask of P27 field.
	PIO_IER_P27_Msk = 0x8000000
	// Bit P27.
	PIO_IER_P27 = 0x8000000
	// Position of P28 field.
	PIO_IER_P28_Pos = 0x1c
	// Bit mask of P28 field.
	PIO_IER_P28_Msk = 0x10000000
	// Bit P28.
	PIO_IER_P28 = 0x10000000
	// Position of P29 field.
	PIO_IER_P29_Pos = 0x1d
	// Bit mask of P29 field.
	PIO_IER_P29_Msk = 0x20000000
	// Bit P29.
	PIO_IER_P29 = 0x20000000
	// Position of P30 field.
	PIO_IER_P30_Pos = 0x1e
	// Bit mask of P30 field.
	PIO_IER_P30_Msk = 0x40000000
	// Bit P30.
	PIO_IER_P30 = 0x40000000
	// Position of P31 field.
	PIO_IER_P31_Pos = 0x1f
	// Bit mask of P31 field.
	PIO_IER_P31_Msk = 0x80000000
	// Bit P31.
	PIO_IER_P31 = 0x80000000

	// IDR: Interrupt Disable Register
	// Position of P0 field.
	PIO_IDR_P0_Pos = 0x0
	// Bit mask of P0 field.
	PIO_IDR_P0_Msk = 0x1
	// Bit P0.
	PIO_IDR_P0 = 0x1
	// Position of P1 field.
	PIO_IDR_P1_Pos = 0x1
	// Bit mask of P1 field.
	PIO_IDR_P1_Msk = 0x2
	// Bit P1.
	PIO_IDR_P1 = 0x2
	// Position of P2 field.
	PIO_IDR_P2_Pos = 0x2
	// Bit mask of P2 field.
	PIO_IDR_P2_Msk = 0x4
	// Bit P2.
	PIO_IDR_P2 = 0x4
	// Position of P3 field.
	PIO_IDR_P3_Pos = 0x3
	// Bit mask of P3 field.
	PIO_IDR_P3_Msk = 0x8
	// Bit P3.
	PIO_IDR_P3 = 0x8
	// Position of P4 field.
	PIO_IDR_P4_Pos = 0x4
	// Bit mask of P4 field.
	PIO_IDR_P4_Msk = 0x10
	// Bit P4.
	PIO_IDR_P4 = 0x10
	// Position of P5 field.
	PIO_IDR_P5_Pos = 0x5
	// Bit mask of P5 field.
	PIO_IDR_P5_Msk = 0x20
	// Bit P5.
	PIO_IDR_P5 = 0x20
	// Position of P6 field.
	PIO_IDR_P6_Pos = 0x6
	// Bit mask of P6 field.
	PIO_IDR_P6_Msk = 0x40
	// Bit P6.
	PIO_IDR_P6 = 0x40
	// Position of P7 field.
	PIO_IDR_P7_Pos = 0x7
	// Bit mask of P7 field.
	PIO_IDR_P7_Msk = 0x80
	// Bit P7.
	PIO_IDR_P7 = 0x80
	// Position of P8 field.
	PIO_IDR_P8_Pos = 0x8
	// Bit mask of P8 field.
	PIO_IDR_P8_Msk = 0x100
	// Bit P8.
	PIO_IDR_P8 = 0x100
	// Position of P9 field.
	PIO_IDR_P9_Pos = 0x9
	// Bit mask of P9 field.
	PIO_IDR_P9_Msk = 0x200
	// Bit P9.
	PIO_IDR_P9 = 0x200
	// Position of P10 field.
	PIO_IDR_P10_Pos = 0xa
	// Bit mask of P10 field.
	PIO_IDR_P10_Msk = 0x400
	// Bit P10.
	PIO_IDR_P10 = 0x400
	// Position of P11 field.
	PIO_IDR_P11_Pos = 0xb
	// Bit mask of P11 field.
	PIO_IDR_P11_Msk = 0x800
	// Bit P11.
	PIO_IDR_P11 = 0x800
	// Position of P12 field.
	PIO_IDR_P12_Pos = 0xc
	// Bit mask of P12 field.
	PIO_IDR_P12_Msk = 0x1000
	// Bit P12.
	PIO_IDR_P12 = 0x1000
	// Position of P13 field.
	PIO_IDR_P13_Pos = 0xd
	// Bit mask of P13 field.
	PIO_IDR_P13_Msk = 0x2000
	// Bit P13.
	PIO_IDR_P13 = 0x2000
	// Position of P14 field.
	PIO_IDR_P14_Pos = 0xe
	// Bit mask of P14 field.
	PIO_IDR_P14_Msk = 0x4000
	// Bit P14.
	PIO_IDR_P14 = 0x4000
	// Position of P15 field.
	PIO_IDR_P15_Pos = 0xf
	// Bit mask of P15 field.
	PIO_IDR_P15_Msk = 0x8000
	// Bit P15.
	PIO_IDR_P15 = 0x8000
	// Position of P16 field.
	PIO_IDR_P16_Pos = 0x10
	// Bit mask of P16 field.
	PIO_IDR_P16_Msk = 0x10000
	// Bit P16.
	PIO_IDR_P16 = 0x10000
	// Position of P17 field.
	PIO_IDR_P17_Pos = 0x11
	// Bit mask of P17 field.
	PIO_IDR_P17_Msk = 0x20000
	// Bit P17.
	PIO_IDR_P17 = 0x20000
	// Position of P18 field.
	PIO_IDR_P18_Pos = 0x12
	// Bit mask of P18 field.
	PIO_IDR_P18_Msk = 0x40000
	// Bit P18.
	PIO_IDR_P18 = 0x40000
	// Position of P19 field.
	PIO_IDR_P19_Pos = 0x13
	// Bit mask of P19 field.
	PIO_IDR_P19_Msk = 0x80000
	// Bit P19.
	PIO_IDR_P19 = 0x80000
	// Position of P20 field.
	PIO_IDR_P20_Pos = 0x14
	// Bit mask of P20 field.
	PIO_IDR_P20_Msk = 0x100000
	// Bit P20.
	PIO_IDR_P20 = 0x100000
	// Position of P21 field.
	PIO_IDR_P21_Pos = 0x15
	// Bit mask of P21 field.
	PIO_IDR_P21_Msk = 0x200000
	// Bit P21.
	PIO_IDR_P21 = 0x200000
	// Position of P22 field.
	PIO_IDR_P22_Pos = 0x16
	// Bit mask of P22 field.
	PIO_IDR_P22_Msk = 0x400000
	// Bit P22.
	PIO_IDR_P22 = 0x400000
	// Position of P23 field.
	PIO_IDR_P23_Pos = 0x17
	// Bit mask of P23 field.
	PIO_IDR_P23_Msk = 0x800000
	// Bit P23.
	PIO_IDR_P23 = 0x800000
	// Position of P24 field.
	PIO_IDR_P24_Pos = 0x18
	// Bit mask of P24 field.
	PIO_IDR_P24_Msk = 0x1000000
	// Bit P24.
	PIO_IDR_P24 = 0x1000000
	// Position of P25 field.
	PIO_IDR_P25_Pos = 0x19
	// Bit mask of P25 field.
	PIO_IDR_P25_Msk = 0x2000000
	// Bit P25.
	PIO_IDR_P25 = 0x2000000
	// Position of P26 field.
	PIO_IDR_P26_Pos = 0x1a
	// Bit mask of P26 field.
	PIO_IDR_P26_Msk = 0x4000000
	// Bit P26.
	PIO_IDR_P26 = 0x4000000
	// Position of P27 field.
	PIO_IDR_P27_Pos = 0x1b
	// Bit mask of P27 field.
	PIO_IDR_P27_Msk = 0x8000000
	// Bit P27.
	PIO_IDR_P27 = 0x8000000
	// Position of P28 field.
	PIO_IDR_P28_Pos = 0x1c
	// Bit mask of P28 field.
	PIO_IDR_P28_Msk = 0x10000000
	// Bit P28.
	PIO_IDR_P28 = 0x10000000
	// Position of P29 field.
	PIO_IDR_P29_Pos = 0x1d
	// Bit mask of P29 field.
	PIO_IDR_P29_Msk = 0x20000000
	// Bit P29.
	PIO_IDR_P29 = 0x20000000
	// Position of P30 field.
	PIO_IDR_P30_Pos = 0x1e
	// Bit mask of P30 field.
	PIO_IDR_P30_Msk = 0x40000000
	// Bit P30.
	PIO_IDR_P30 = 0x40000000
	// Position of P31 field.
	PIO_IDR_P31_Pos = 0x1f
	// Bit mask of P31 field.
	PIO_IDR_P31_Msk = 0x80000000
	// Bit P31.
	PIO_IDR_P31 = 0x80000000

	// IMR: Interrupt Mask Register
	// Position of P0 field.
	PIO_IMR_P0_Pos = 0x0
	// Bit mask of P0 field.
	PIO_IMR_P0_Msk = 0x1
	// Bit P0.
	PIO_IMR_P0 = 0x1
	// Position of P1 field.
	PIO_IMR_P1_Pos = 0x1
	// Bit mask of P1 field.
	PIO_IMR_P1_Msk = 0x2
	// Bit P1.
	PIO_IMR_P1 = 0x2
	// Position of P2 field.
	PIO_IMR_P2_Pos = 0x2
	// Bit mask of P2 field.
	PIO_IMR_P2_Msk = 0x4
	// Bit P2.
	PIO_IMR_P2 = 0x4
	// Position of P3 field.
	PIO_IMR_P3_Pos = 0x3
	// Bit mask of P3 field.
	PIO_IMR_P3_Msk = 0x8
	// Bit P3.
	PIO_IMR_P3 = 0x8
	// Position of P4 field.
	PIO_IMR_P4_Pos = 0x4
	// Bit mask of P4 field.
	PIO_IMR_P4_Msk = 0x10
	// Bit P4.
	PIO_IMR_P4 = 0x10
	// Position of P5 field.
	PIO_IMR_P5_Pos = 0x5
	// Bit mask of P5 field.
	PIO_IMR_P5_Msk = 0x20
	// Bit P5.
	PIO_IMR_P5 = 0x20
	// Position of P6 field.
	PIO_IMR_P6_Pos = 0x6
	// Bit mask of P6 field.
	PIO_IMR_P6_Msk = 0x40
	// Bit P6.
	PIO_IMR_P6 = 0x40
	// Position of P7 field.
	PIO_IMR_P7_Pos = 0x7
	// Bit mask of P7 field.
	PIO_IMR_P7_Msk = 0x80
	// Bit P7.
	PIO_IMR_P7 = 0x80
	// Position of P8 field.
	PIO_IMR_P8_Pos = 0x8
	// Bit mask of P8 field.
	PIO_IMR_P8_Msk = 0x100
	// Bit P8.
	PIO_IMR_P8 = 0x100
	// Position of P9 field.
	PIO_IMR_P9_Pos = 0x9
	// Bit mask of P9 field.
	PIO_IMR_P9_Msk = 0x200
	// Bit P9.
	PIO_IMR_P9 = 0x200
	// Position of P10 field.
	PIO_IMR_P10_Pos = 0xa
	// Bit mask of P10 field.
	PIO_IMR_P10_Msk = 0x400
	// Bit P10.
	PIO_IMR_P10 = 0x400
	// Position of P11 field.
	PIO_IMR_P11_Pos = 0xb
	// Bit mask of P11 field.
	PIO_IMR_P11_Msk = 0x800
	// Bit P11.
	PIO_IMR_P11 = 0x800
	// Position of P12 field.
	PIO_IMR_P12_Pos = 0xc
	// Bit mask of P12 field.
	PIO_IMR_P12_Msk = 0x1000
	// Bit P12.
	PIO_IMR_P12 = 0x1000
	// Position of P13 field.
	PIO_IMR_P13_Pos = 0xd
	// Bit mask of P13 field.
	PIO_IMR_P13_Msk = 0x2000
	// Bit P13.
	PIO_IMR_P13 = 0x2000
	// Position of P14 field.
	PIO_IMR_P14_Pos = 0xe
	// Bit mask of P14 field.
	PIO_IMR_P14_Msk = 0x4000
	// Bit P14.
	PIO_IMR_P14 = 0x4000
	// Position of P15 field.
	PIO_IMR_P15_Pos = 0xf
	// Bit mask of P15 field.
	PIO_IMR_P15_Msk = 0x8000
	// Bit P15.
	PIO_IMR_P15 = 0x8000
	// Position of P16 field.
	PIO_IMR_P16_Pos = 0x10
	// Bit mask of P16 field.
	PIO_IMR_P16_Msk = 0x10000
	// Bit P16.
	PIO_IMR_P16 = 0x10000
	// Position of P17 field.
	PIO_IMR_P17_Pos = 0x11
	// Bit mask of P17 field.
	PIO_IMR_P17_Msk = 0x20000
	// Bit P17.
	PIO_IMR_P17 = 0x20000
	// Position of P18 field.
	PIO_IMR_P18_Pos = 0x12
	// Bit mask of P18 field.
	PIO_IMR_P18_Msk = 0x40000
	// Bit P18.
	PIO_IMR_P18 = 0x40000
	// Position of P19 field.
	PIO_IMR_P19_Pos = 0x13
	// Bit mask of P19 field.
	PIO_IMR_P19_Msk = 0x80000
	// Bit P19.
	PIO_IMR_P19 = 0x80000
	// Position of P20 field.
	PIO_IMR_P20_Pos = 0x14
	// Bit mask of P20 field.
	PIO_IMR_P20_Msk = 0x100000
	// Bit P20.
	PIO_IMR_P20 = 0x100000
	// Position of P21 field.
	PIO_IMR_P21_Pos = 0x15
	// Bit mask of P21 field.
	PIO_IMR_P21_Msk = 0x200000
	// Bit P21.
	PIO_IMR_P21 = 0x200000
	// Position of P22 field.
	PIO_IMR_P22_Pos = 0x16
	// Bit mask of P22 field.
	PIO_IMR_P22_Msk = 0x400000
	// Bit P22.
	PIO_IMR_P22 = 0x400000
	// Position of P23 field.
	PIO_IMR_P23_Pos = 0x17
	// Bit mask of P23 field.
	PIO_IMR_P23_Msk = 0x800000
	// Bit P23.
	PIO_IMR_P23 = 0x800000
	// Position of P24 field.
	PIO_IMR_P24_Pos = 0x18
	// Bit mask of P24 field.
	PIO_IMR_P24_Msk = 0x1000000
	// Bit P24.
	PIO_IMR_P24 = 0x1000000
	// Position of P25 field.
	PIO_IMR_P25_Pos = 0x19
	// Bit mask of P25 field.
	PIO_IMR_P25_Msk = 0x2000000
	// Bit P25.
	PIO_IMR_P25 = 0x2000000
	// Position of P26 field.
	PIO_IMR_P26_Pos = 0x1a
	// Bit mask of P26 field.
	PIO_IMR_P26_Msk = 0x4000000
	// Bit P26.
	PIO_IMR_P26 = 0x4000000
	// Position of P27 field.
	PIO_IMR_P27_Pos = 0x1b
	// Bit mask of P27 field.
	PIO_IMR_P27_Msk = 0x8000000
	// Bit P27.
	PIO_IMR_P27 = 0x8000000
	// Position of P28 field.
	PIO_IMR_P28_Pos = 0x1c
	// Bit mask of P28 field.
	PIO_IMR_P28_Msk = 0x10000000
	// Bit P28.
	PIO_IMR_P28 = 0x10000000
	// Position of P29 field.
	PIO_IMR_P29_Pos = 0x1d
	// Bit mask of P29 field.
	PIO_IMR_P29_Msk = 0x20000000
	// Bit P29.
	PIO_IMR_P29 = 0x20000000
	// Position of P30 field.
	PIO_IMR_P30_Pos = 0x1e
	// Bit mask of P30 field.
	PIO_IMR_P30_Msk = 0x40000000
	// Bit P30.
	PIO_IMR_P30 = 0x40000000
	// Position of P31 field.
	PIO_IMR_P31_Pos = 0x1f
	// Bit mask of P31 field.
	PIO_IMR_P31_Msk = 0x80000000
	// Bit P31.
	PIO_IMR_P31 = 0x80000000

	// ISR: Interrupt Status Register
	// Position of P0 field.
	PIO_ISR_P0_Pos = 0x0
	// Bit mask of P0 field.
	PIO_ISR_P0_Msk = 0x1
	// Bit P0.
	PIO_ISR_P0 = 0x1
	// Position of P1 field.
	PIO_ISR_P1_Pos = 0x1
	// Bit mask of P1 field.
	PIO_ISR_P1_Msk = 0x2
	// Bit P1.
	PIO_ISR_P1 = 0x2
	// Position of P2 field.
	PIO_ISR_P2_Pos = 0x2
	// Bit mask of P2 field.
	PIO_ISR_P2_Msk = 0x4
	// Bit P2.
	PIO_ISR_P2 = 0x4
	// Position of P3 field.
	PIO_ISR_P3_Pos = 0x3
	// Bit mask of P3 field.
	PIO_ISR_P3_Msk = 0x8
	// Bit P3.
	PIO_ISR_P3 = 0x8
	// Position of P4 field.
	PIO_ISR_P4_Pos = 0x4
	// Bit mask of P4 field.
	PIO_ISR_P4_Msk = 0x10
	// Bit P4.
	PIO_ISR_P4 = 0x10
	// Position of P5 field.
	PIO_ISR_P5_Pos = 0x5
	// Bit mask of P5 field.
	PIO_ISR_P5_Msk = 0x20
	// Bit P5.
	PIO_ISR_P5 = 0x20
	// Position of P6 field.
	PIO_ISR_P6_Pos = 0x6
	// Bit mask of P6 field.
	PIO_ISR_P6_Msk = 0x40
	// Bit P6.
	PIO_ISR_P6 = 0x40
	// Position of P7 field.
	PIO_ISR_P7_Pos = 0x7
	// Bit mask of P7 field.
	PIO_ISR_P7_Msk = 0x80
	// Bit P7.
	PIO_ISR_P7 = 0x80
	// Position of P8 field.
	PIO_ISR_P8_Pos = 0x8
	// Bit mask of P8 field.
	PIO_ISR_P8_Msk = 0x100
	// Bit P8.
	PIO_ISR_P8 = 0x100
	// Position of P9 field.
	PIO_ISR_P9_Pos = 0x9
	// Bit mask of P9 field.
	PIO_ISR_P9_Msk = 0x200
	// Bit P9.
	PIO_ISR_P9 = 0x200
	// Position of P10 field.
	PIO_ISR_P10_Pos = 0xa
	// Bit mask of P10 field.
	PIO_ISR_P10_Msk = 0x400
	// Bit P10.
	PIO_ISR_P10 = 0x400
	// Position of P11 field.
	PIO_ISR_P11_Pos = 0xb
	// Bit mask of P11 field.
	PIO_ISR_P11_Msk = 0x800
	// Bit P11.
	PIO_ISR_P11 = 0x800
	// Position of P12 field.
	PIO_ISR_P12_Pos = 0xc
	// Bit mask of P12 field.
	PIO_ISR_P12_Msk = 0x1000
	// Bit P12.
	PIO_ISR_P12 = 0x1000
	// Position of P13 field.
	PIO_ISR_P13_Pos = 0xd
	// Bit mask of P13 field.
	PIO_ISR_P13_Msk = 0x2000
	// Bit P13.
	PIO_ISR_P13 = 0x2000
	// Position of P14 field.
	PIO_ISR_P14_Pos = 0xe
	// Bit mask of P14 field.
	PIO_ISR_P14_Msk = 0x4000
	// Bit P14.
	PIO_ISR_P14 = 0x4000
	// Position of P15 field.
	PIO_ISR_P15_Pos = 0xf
	// Bit mask of P15 field.
	PIO_ISR_P15_Msk = 0x8000
	// Bit P15.
	PIO_ISR_P15 = 0x8000
	// Position of P16 field.
	PIO_ISR_P16_Pos = 0x10
	// Bit mask of P16 field.
	PIO_ISR_P16_Msk = 0x10000
	// Bit P16.
	PIO_ISR_P16 = 0x10000
	// Position of P17 field.
	PIO_ISR_P17_Pos = 0x11
	// Bit mask of P17 field.
	PIO_ISR_P17_Msk = 0x20000
	// Bit P17.
	PIO_ISR_P17 = 0x20000
	// Position of P18 field.
	PIO_ISR_P18_Pos = 0x12
	// Bit mask of P18 field.
	PIO_ISR_P18_Msk = 0x40000
	// Bit P18.
	PIO_ISR_P18 = 0x40000
	// Position of P19 field.
	PIO_ISR_P19_Pos = 0x13
	// Bit mask of P19 field.
	PIO_ISR_P19_Msk = 0x80000
	// Bit P19.
	PIO_ISR_P19 = 0x80000
	// Position of P20 field.
	PIO_ISR_P20_Pos = 0x14
	// Bit mask of P20 field.
	PIO_ISR_P20_Msk = 0x100000
	// Bit P20.
	PIO_ISR_P20 = 0x100000
	// Position of P21 field.
	PIO_ISR_P21_Pos = 0x15
	// Bit mask of P21 field.
	PIO_ISR_P21_Msk = 0x200000
	// Bit P21.
	PIO_ISR_P21 = 0x200000
	// Position of P22 field.
	PIO_ISR_P22_Pos = 0x16
	// Bit mask of P22 field.
	PIO_ISR_P22_Msk = 0x400000
	// Bit P22.
	PIO_ISR_P22 = 0x400000
	// Position of P23 field.
	PIO_ISR_P23_Pos = 0x17
	// Bit mask of P23 field.
	PIO_ISR_P23_Msk = 0x800000
	// Bit P23.
	PIO_ISR_P23 = 0x800000
	// Position of P24 field.
	PIO_ISR_P24_Pos = 0x18
	// Bit mask of P24 field.
	PIO_ISR_P24_Msk = 0x1000000
	// Bit P24.
	PIO_ISR_P24 = 0x1000000
	// Position of P25 field.
	PIO_ISR_P25_Pos = 0x19
	// Bit mask of P25 field.
	PIO_ISR_P25_Msk = 0x2000000
	// Bit P25.
	PIO_ISR_P25 = 0x2000000
	// Position of P26 field.
	PIO_ISR_P26_Pos = 0x1a
	// Bit mask of P26 field.
	PIO_ISR_P26_Msk = 0x4000000
	// Bit P26.
	PIO_ISR_P26 = 0x4000000
	// Position of P27 field.
	PIO_ISR_P27_Pos = 0x1b
	// Bit mask of P27 field.
	PIO_ISR_P27_Msk = 0x8000000
	// Bit P27.
	PIO_ISR_P27 = 0x8000000
	// Position of P28 field.
	PIO_ISR_P28_Pos = 0x1c
	// Bit mask of P28 field.
	PIO_ISR_P28_Msk = 0x10000000
	// Bit P28.
	PIO_ISR_P28 = 0x10000000
	// Position of P29 field.
	PIO_ISR_P29_Pos = 0x1d
	// Bit mask of P29 field.
	PIO_ISR_P29_Msk = 0x20000000
	// Bit P29.
	PIO_ISR_P29 = 0x20000000
	// Position of P30 field.
	PIO_ISR_P30_Pos = 0x1e
	// Bit mask of P30 field.
	PIO_ISR_P30_Msk = 0x40000000
	// Bit P30.
	PIO_ISR_P30 = 0x40000000
	// Position of P31 field.
	PIO_ISR_P31_Pos = 0x1f
	// Bit mask of P31 field.
	PIO_ISR_P31_Msk = 0x80000000
	// Bit P31.
	PIO_ISR_P31 = 0x80000000

	// MDER: Multi-driver Enable Register
	// Position of P0 field.
	PIO_MDER_P0_Pos = 0x0
	// Bit mask of P0 field.
	PIO_MDER_P0_Msk = 0x1
	// Bit P0.
	PIO_MDER_P0 = 0x1
	// Position of P1 field.
	PIO_MDER_P1_Pos = 0x1
	// Bit mask of P1 field.
	PIO_MDER_P1_Msk = 0x2
	// Bit P1.
	PIO_MDER_P1 = 0x2
	// Position of P2 field.
	PIO_MDER_P2_Pos = 0x2
	// Bit mask of P2 field.
	PIO_MDER_P2_Msk = 0x4
	// Bit P2.
	PIO_MDER_P2 = 0x4
	// Position of P3 field.
	PIO_MDER_P3_Pos = 0x3
	// Bit mask of P3 field.
	PIO_MDER_P3_Msk = 0x8
	// Bit P3.
	PIO_MDER_P3 = 0x8
	// Position of P4 field.
	PIO_MDER_P4_Pos = 0x4
	// Bit mask of P4 field.
	PIO_MDER_P4_Msk = 0x10
	// Bit P4.
	PIO_MDER_P4 = 0x10
	// Position of P5 field.
	PIO_MDER_P5_Pos = 0x5
	// Bit mask of P5 field.
	PIO_MDER_P5_Msk = 0x20
	// Bit P5.
	PIO_MDER_P5 = 0x20
	// Position of P6 field.
	PIO_MDER_P6_Pos = 0x6
	// Bit mask of P6 field.
	PIO_MDER_P6_Msk = 0x40
	// Bit P6.
	PIO_MDER_P6 = 0x40
	// Position of P7 field.
	PIO_MDER_P7_Pos = 0x7
	// Bit mask of P7 field.
	PIO_MDER_P7_Msk = 0x80
	// Bit P7.
	PIO_MDER_P7 = 0x80
	// Position of P8 field.
	PIO_MDER_P8_Pos = 0x8
	// Bit mask of P8 field.
	PIO_MDER_P8_Msk = 0x100
	// Bit P8.
	PIO_MDER_P8 = 0x100
	// Position of P9 field.
	PIO_MDER_P9_Pos = 0x9
	// Bit mask of P9 field.
	PIO_MDER_P9_Msk = 0x200
	// Bit P9.
	PIO_MDER_P9 = 0x200
	// Position of P10 field.
	PIO_MDER_P10_Pos = 0xa
	// Bit mask of P10 field.
	PIO_MDER_P10_Msk = 0x400
	// Bit P10.
	PIO_MDER_P10 = 0x400
	// Position of P11 field.
	PIO_MDER_P11_Pos = 0xb
	// Bit mask of P11 field.
	PIO_MDER_P11_Msk = 0x800
	// Bit P11.
	PIO_MDER_P11 = 0x800
	// Position of P12 field.
	PIO_MDER_P12_Pos = 0xc
	// Bit mask of P12 field.
	PIO_MDER_P12_Msk = 0x1000
	// Bit P12.
	PIO_MDER_P12 = 0x1000
	// Position of P13 field.
	PIO_MDER_P13_Pos = 0xd
	// Bit mask of P13 field.
	PIO_MDER_P13_Msk = 0x2000
	// Bit P13.
	PIO_MDER_P13 = 0x2000
	// Position of P14 field.
	PIO_MDER_P14_Pos = 0xe
	// Bit mask of P14 field.
	PIO_MDER_P14_Msk = 0x4000
	// Bit P14.
	PIO_MDER_P14 = 0x4000
	// Position of P15 field.
	PIO_MDER_P15_Pos = 0xf
	// Bit mask of P15 field.
	PIO_MDER_P15_Msk = 0x8000
	// Bit P15.
	PIO_MDER_P15 = 0x8000
	// Position of P16 field.
	PIO_MDER_P16_Pos = 0x10
	// Bit mask of P16 field.
	PIO_MDER_P16_Msk = 0x10000
	// Bit P16.
	PIO_MDER_P16 = 0x10000
	// Position of P17 field.
	PIO_MDER_P17_Pos = 0x11
	// Bit mask of P17 field.
	PIO_MDER_P17_Msk = 0x20000
	// Bit P17.
	PIO_MDER_P17 = 0x20000
	// Position of P18 field.
	PIO_MDER_P18_Pos = 0x12
	// Bit mask of P18 field.
	PIO_MDER_P18_Msk = 0x40000
	// Bit P18.
	PIO_MDER_P18 = 0x40000
	// Position of P19 field.
	PIO_MDER_P19_Pos = 0x13
	// Bit mask of P19 field.
	PIO_MDER_P19_Msk = 0x80000
	// Bit P19.
	PIO_MDER_P19 = 0x80000
	// Position of P20 field.
	PIO_MDER_P20_Pos = 0x14
	// Bit mask of P20 field.
	PIO_MDER_P20_Msk = 0x100000
	// Bit P20.
	PIO_MDER_P20 = 0x100000
	// Position of P21 field.
	PIO_MDER_P21_Pos = 0x15
	// Bit mask of P21 field.
	PIO_MDER_P21_Msk = 0x200000
	// Bit P21.
	PIO_MDER_P21 = 0x200000
	// Position of P22 field.
	PIO_MDER_P22_Pos = 0x16
	// Bit mask of P22 field.
	PIO_MDER_P22_Msk = 0x400000
	// Bit P22.
	PIO_MDER_P22 = 0x400000
	// Position of P23 field.
	PIO_MDER_P23_Pos = 0x17
	// Bit mask of P23 field.
	PIO_MDER_P23_Msk = 0x800000
	// Bit P23.
	PIO_MDER_P23 = 0x800000
	// Position of P24 field.
	PIO_MDER_P24_Pos = 0x18
	// Bit mask of P24 field.
	PIO_MDER_P24_Msk = 0x1000000
	// Bit P24.
	PIO_MDER_P24 = 0x1000000
	// Position of P25 field.
	PIO_MDER_P25_Pos = 0x19
	// Bit mask of P25 field.
	PIO_MDER_P25_Msk = 0x2000000
	// Bit P25.
	PIO_MDER_P25 = 0x2000000
	// Position of P26 field.
	PIO_MDER_P26_Pos = 0x1a
	// Bit mask of P26 field.
	PIO_MDER_P26_Msk = 0x4000000
	// Bit P26.
	PIO_MDER_P26 = 0x4000000
	// Position of P27 field.
	PIO_MDER_P27_Pos = 0x1b
	// Bit mask of P27 field.
	PIO_MDER_P27_Msk = 0x8000000
	// Bit P27.
	PIO_MDER_P27 = 0x8000000
	// Position of P28 field.
	PIO_MDER_P28_Pos = 0x1c
	// Bit mask of P28 field.
	PIO_MDER_P28_Msk = 0x10000000
	// Bit P28.
	PIO_MDER_P28 = 0x10000000
	// Position of P29 field.
	PIO_MDER_P29_Pos = 0x1d
	// Bit mask of P29 field.
	PIO_MDER_P29_Msk = 0x20000000
	// Bit P29.
	PIO_MDER_P29 = 0x20000000
	// Position of P30 field.
	PIO_MDER_P30_Pos = 0x1e
	// Bit mask of P30 field.
	PIO_MDER_P30_Msk = 0x40000000
	// Bit P30.
	PIO_MDER_P30 = 0x40000000
	// Position of P31 field.
	PIO_MDER_P31_Pos = 0x1f
	// Bit mask of P31 field.
	PIO_MDER_P31_Msk = 0x80000000
	// Bit P31.
	PIO_MDER_P31 = 0x80000000

	// MDDR: Multi-driver Disable Register
	// Position of P0 field.
	PIO_MDDR_P0_Pos = 0x0
	// Bit mask of P0 field.
	PIO_MDDR_P0_Msk = 0x1
	// Bit P0.
	PIO_MDDR_P0 = 0x1
	// Position of P1 field.
	PIO_MDDR_P1_Pos = 0x1
	// Bit mask of P1 field.
	PIO_MDDR_P1_Msk = 0x2
	// Bit P1.
	PIO_MDDR_P1 = 0x2
	// Position of P2 field.
	PIO_MDDR_P2_Pos = 0x2
	// Bit mask of P2 field.
	PIO_MDDR_P2_Msk = 0x4
	// Bit P2.
	PIO_MDDR_P2 = 0x4
	// Position of P3 field.
	PIO_MDDR_P3_Pos = 0x3
	// Bit mask of P3 field.
	PIO_MDDR_P3_Msk = 0x8
	// Bit P3.
	PIO_MDDR_P3 = 0x8
	// Position of P4 field.
	PIO_MDDR_P4_Pos = 0x4
	// Bit mask of P4 field.
	PIO_MDDR_P4_Msk = 0x10
	// Bit P4.
	PIO_MDDR_P4 = 0x10
	// Position of P5 field.
	PIO_MDDR_P5_Pos = 0x5
	// Bit mask of P5 field.
	PIO_MDDR_P5_Msk = 0x20
	// Bit P5.
	PIO_MDDR_P5 = 0x20
	// Position of P6 field.
	PIO_MDDR_P6_Pos = 0x6
	// Bit mask of P6 field.
	PIO_MDDR_P6_Msk = 0x40
	// Bit P6.
	PIO_MDDR_P6 = 0x40
	// Position of P7 field.
	PIO_MDDR_P7_Pos = 0x7
	// Bit mask of P7 field.
	PIO_MDDR_P7_Msk = 0x80
	// Bit P7.
	PIO_MDDR_P7 = 0x80
	// Position of P8 field.
	PIO_MDDR_P8_Pos = 0x8
	// Bit mask of P8 field.
	PIO_MDDR_P8_Msk = 0x100
	// Bit P8.
	PIO_MDDR_P8 = 0x100
	// Position of P9 field.
	PIO_MDDR_P9_Pos = 0x9
	// Bit mask of P9 field.
	PIO_MDDR_P9_Msk = 0x200
	// Bit P9.
	PIO_MDDR_P9 = 0x200
	// Position of P10 field.
	PIO_MDDR_P10_Pos = 0xa
	// Bit mask of P10 field.
	PIO_MDDR_P10_Msk = 0x400
	// Bit P10.
	PIO_MDDR_P10 = 0x400
	// Position of P11 field.
	PIO_MDDR_P11_Pos = 0xb
	// Bit mask of P11 field.
	PIO_MDDR_P11_Msk = 0x800
	// Bit P11.
	PIO_MDDR_P11 = 0x800
	// Position of P12 field.
	PIO_MDDR_P12_Pos = 0xc
	// Bit mask of P12 field.
	PIO_MDDR_P12_Msk = 0x1000
	// Bit P12.
	PIO_MDDR_P12 = 0x1000
	// Position of P13 field.
	PIO_MDDR_P13_Pos = 0xd
	// Bit mask of P13 field.
	PIO_MDDR_P13_Msk = 0x2000
	// Bit P13.
	PIO_MDDR_P13 = 0x2000
	// Position of P14 field.
	PIO_MDDR_P14_Pos = 0xe
	// Bit mask of P14 field.
	PIO_MDDR_P14_Msk = 0x4000
	// Bit P14.
	PIO_MDDR_P14 = 0x4000
	// Position of P15 field.
	PIO_MDDR_P15_Pos = 0xf
	// Bit mask of P15 field.
	PIO_MDDR_P15_Msk = 0x8000
	// Bit P15.
	PIO_MDDR_P15 = 0x8000
	// Position of P16 field.
	PIO_MDDR_P16_Pos = 0x10
	// Bit mask of P16 field.
	PIO_MDDR_P16_Msk = 0x10000
	// Bit P16.
	PIO_MDDR_P16 = 0x10000
	// Position of P17 field.
	PIO_MDDR_P17_Pos = 0x11
	// Bit mask of P17 field.
	PIO_MDDR_P17_Msk = 0x20000
	// Bit P17.
	PIO_MDDR_P17 = 0x20000
	// Position of P18 field.
	PIO_MDDR_P18_Pos = 0x12
	// Bit mask of P18 field.
	PIO_MDDR_P18_Msk = 0x40000
	// Bit P18.
	PIO_MDDR_P18 = 0x40000
	// Position of P19 field.
	PIO_MDDR_P19_Pos = 0x13
	// Bit mask of P19 field.
	PIO_MDDR_P19_Msk = 0x80000
	// Bit P19.
	PIO_MDDR_P19 = 0x80000
	// Position of P20 field.
	PIO_MDDR_P20_Pos = 0x14
	// Bit mask of P20 field.
	PIO_MDDR_P20_Msk = 0x100000
	// Bit P20.
	PIO_MDDR_P20 = 0x100000
	// Position of P21 field.
	PIO_MDDR_P21_Pos = 0x15
	// Bit mask of P21 field.
	PIO_MDDR_P21_Msk = 0x200000
	// Bit P21.
	PIO_MDDR_P21 = 0x200000
	// Position of P22 field.
	PIO_MDDR_P22_Pos = 0x16
	// Bit mask of P22 field.
	PIO_MDDR_P22_Msk = 0x400000
	// Bit P22.
	PIO_MDDR_P22 = 0x400000
	// Position of P23 field.
	PIO_MDDR_P23_Pos = 0x17
	// Bit mask of P23 field.
	PIO_MDDR_P23_Msk = 0x800000
	// Bit P23.
	PIO_MDDR_P23 = 0x800000
	// Position of P24 field.
	PIO_MDDR_P24_Pos = 0x18
	// Bit mask of P24 field.
	PIO_MDDR_P24_Msk = 0x1000000
	// Bit P24.
	PIO_MDDR_P24 = 0x1000000
	// Position of P25 field.
	PIO_MDDR_P25_Pos = 0x19
	// Bit mask of P25 field.
	PIO_MDDR_P25_Msk = 0x2000000
	// Bit P25.
	PIO_MDDR_P25 = 0x2000000
	// Position of P26 field.
	PIO_MDDR_P26_Pos = 0x1a
	// Bit mask of P26 field.
	PIO_MDDR_P26_Msk = 0x4000000
	// Bit P26.
	PIO_MDDR_P26 = 0x4000000
	// Position of P27 field.
	PIO_MDDR_P27_Pos = 0x1b
	// Bit mask of P27 field.
	PIO_MDDR_P27_Msk = 0x8000000
	// Bit P27.
	PIO_MDDR_P27 = 0x8000000
	// Position of P28 field.
	PIO_MDDR_P28_Pos = 0x1c
	// Bit mask of P28 field.
	PIO_MDDR_P28_Msk = 0x10000000
	// Bit P28.
	PIO_MDDR_P28 = 0x10000000
	// Position of P29 field.
	PIO_MDDR_P29_Pos = 0x1d
	// Bit mask of P29 field.
	PIO_MDDR_P29_Msk = 0x20000000
	// Bit P29.
	PIO_MDDR_P29 = 0x20000000
	// Position of P30 field.
	PIO_MDDR_P30_Pos = 0x1e
	// Bit mask of P30 field.
	PIO_MDDR_P30_Msk = 0x40000000
	// Bit P30.
	PIO_MDDR_P30 = 0x40000000
	// Position of P31 field.
	PIO_MDDR_P31_Pos = 0x1f
	// Bit mask of P31 field.
	PIO_MDDR_P31_Msk = 0x80000000
	// Bit P31.
	PIO_MDDR_P31 = 0x80000000

	// MDSR: Multi-driver Status Register
	// Position of P0 field.
	PIO_MDSR_P0_Pos = 0x0
	// Bit mask of P0 field.
	PIO_MDSR_P0_Msk = 0x1
	// Bit P0.
	PIO_MDSR_P0 = 0x1
	// Position of P1 field.
	PIO_MDSR_P1_Pos = 0x1
	// Bit mask of P1 field.
	PIO_MDSR_P1_Msk = 0x2
	// Bit P1.
	PIO_MDSR_P1 = 0x2
	// Position of P2 field.
	PIO_MDSR_P2_Pos = 0x2
	// Bit mask of P2 field.
	PIO_MDSR_P2_Msk = 0x4
	// Bit P2.
	PIO_MDSR_P2 = 0x4
	// Position of P3 field.
	PIO_MDSR_P3_Pos = 0x3
	// Bit mask of P3 field.
	PIO_MDSR_P3_Msk = 0x8
	// Bit P3.
	PIO_MDSR_P3 = 0x8
	// Position of P4 field.
	PIO_MDSR_P4_Pos = 0x4
	// Bit mask of P4 field.
	PIO_MDSR_P4_Msk = 0x10
	// Bit P4.
	PIO_MDSR_P4 = 0x10
	// Position of P5 field.
	PIO_MDSR_P5_Pos = 0x5
	// Bit mask of P5 field.
	PIO_MDSR_P5_Msk = 0x20
	// Bit P5.
	PIO_MDSR_P5 = 0x20
	// Position of P6 field.
	PIO_MDSR_P6_Pos = 0x6
	// Bit mask of P6 field.
	PIO_MDSR_P6_Msk = 0x40
	// Bit P6.
	PIO_MDSR_P6 = 0x40
	// Position of P7 field.
	PIO_MDSR_P7_Pos = 0x7
	// Bit mask of P7 field.
	PIO_MDSR_P7_Msk = 0x80
	// Bit P7.
	PIO_MDSR_P7 = 0x80
	// Position of P8 field.
	PIO_MDSR_P8_Pos = 0x8
	// Bit mask of P8 field.
	PIO_MDSR_P8_Msk = 0x100
	// Bit P8.
	PIO_MDSR_P8 = 0x100
	// Position of P9 field.
	PIO_MDSR_P9_Pos = 0x9
	// Bit mask of P9 field.
	PIO_MDSR_P9_Msk = 0x200
	// Bit P9.
	PIO_MDSR_P9 = 0x200
	// Position of P10 field.
	PIO_MDSR_P10_Pos = 0xa
	// Bit mask of P10 field.
	PIO_MDSR_P10_Msk = 0x400
	// Bit P10.
	PIO_MDSR_P10 = 0x400
	// Position of P11 field.
	PIO_MDSR_P11_Pos = 0xb
	// Bit mask of P11 field.
	PIO_MDSR_P11_Msk = 0x800
	// Bit P11.
	PIO_MDSR_P11 = 0x800
	// Position of P12 field.
	PIO_MDSR_P12_Pos = 0xc
	// Bit mask of P12 field.
	PIO_MDSR_P12_Msk = 0x1000
	// Bit P12.
	PIO_MDSR_P12 = 0x1000
	// Position of P13 field.
	PIO_MDSR_P13_Pos = 0xd
	// Bit mask of P13 field.
	PIO_MDSR_P13_Msk = 0x2000
	// Bit P13.
	PIO_MDSR_P13 = 0x2000
	// Position of P14 field.
	PIO_MDSR_P14_Pos = 0xe
	// Bit mask of P14 field.
	PIO_MDSR_P14_Msk = 0x4000
	// Bit P14.
	PIO_MDSR_P14 = 0x4000
	// Position of P15 field.
	PIO_MDSR_P15_Pos = 0xf
	// Bit mask of P15 field.
	PIO_MDSR_P15_Msk = 0x8000
	// Bit P15.
	PIO_MDSR_P15 = 0x8000
	// Position of P16 field.
	PIO_MDSR_P16_Pos = 0x10
	// Bit mask of P16 field.
	PIO_MDSR_P16_Msk = 0x10000
	// Bit P16.
	PIO_MDSR_P16 = 0x10000
	// Position of P17 field.
	PIO_MDSR_P17_Pos = 0x11
	// Bit mask of P17 field.
	PIO_MDSR_P17_Msk = 0x20000
	// Bit P17.
	PIO_MDSR_P17 = 0x20000
	// Position of P18 field.
	PIO_MDSR_P18_Pos = 0x12
	// Bit mask of P18 field.
	PIO_MDSR_P18_Msk = 0x40000
	// Bit P18.
	PIO_MDSR_P18 = 0x40000
	// Position of P19 field.
	PIO_MDSR_P19_Pos = 0x13
	// Bit mask of P19 field.
	PIO_MDSR_P19_Msk = 0x80000
	// Bit P19.
	PIO_MDSR_P19 = 0x80000
	// Position of P20 field.
	PIO_MDSR_P20_Pos = 0x14
	// Bit mask of P20 field.
	PIO_MDSR_P20_Msk = 0x100000
	// Bit P20.
	PIO_MDSR_P20 = 0x100000
	// Position of P21 field.
	PIO_MDSR_P21_Pos = 0x15
	// Bit mask of P21 field.
	PIO_MDSR_P21_Msk = 0x200000
	// Bit P21.
	PIO_MDSR_P21 = 0x200000
	// Position of P22 field.
	PIO_MDSR_P22_Pos = 0x16
	// Bit mask of P22 field.
	PIO_MDSR_P22_Msk = 0x400000
	// Bit P22.
	PIO_MDSR_P22 = 0x400000
	// Position of P23 field.
	PIO_MDSR_P23_Pos = 0x17
	// Bit mask of P23 field.
	PIO_MDSR_P23_Msk = 0x800000
	// Bit P23.
	PIO_MDSR_P23 = 0x800000
	// Position of P24 field.
	PIO_MDSR_P24_Pos = 0x18
	// Bit mask of P24 field.
	PIO_MDSR_P24_Msk = 0x1000000
	// Bit P24.
	PIO_MDSR_P24 = 0x1000000
	// Position of P25 field.
	PIO_MDSR_P25_Pos = 0x19
	// Bit mask of P25 field.
	PIO_MDSR_P25_Msk = 0x2000000
	// Bit P25.
	PIO_MDSR_P25 = 0x2000000
	// Position of P26 field.
	PIO_MDSR_P26_Pos = 0x1a
	// Bit mask of P26 field.
	PIO_MDSR_P26_Msk = 0x4000000
	// Bit P26.
	PIO_MDSR_P26 = 0x4000000
	// Position of P27 field.
	PIO_MDSR_P27_Pos = 0x1b
	// Bit mask of P27 field.
	PIO_MDSR_P27_Msk = 0x8000000
	// Bit P27.
	PIO_MDSR_P27 = 0x8000000
	// Position of P28 field.
	PIO_MDSR_P28_Pos = 0x1c
	// Bit mask of P28 field.
	PIO_MDSR_P28_Msk = 0x10000000
	// Bit P28.
	PIO_MDSR_P28 = 0x10000000
	// Position of P29 field.
	PIO_MDSR_P29_Pos = 0x1d
	// Bit mask of P29 field.
	PIO_MDSR_P29_Msk = 0x20000000
	// Bit P29.
	PIO_MDSR_P29 = 0x20000000
	// Position of P30 field.
	PIO_MDSR_P30_Pos = 0x1e
	// Bit mask of P30 field.
	PIO_MDSR_P30_Msk = 0x40000000
	// Bit P30.
	PIO_MDSR_P30 = 0x40000000
	// Position of P31 field.
	PIO_MDSR_P31_Pos = 0x1f
	// Bit mask of P31 field.
	PIO_MDSR_P31_Msk = 0x80000000
	// Bit P31.
	PIO_MDSR_P31 = 0x80000000

	// PUDR: Pull-up Disable Register
	// Position of P0 field.
	PIO_PUDR_P0_Pos = 0x0
	// Bit mask of P0 field.
	PIO_PUDR_P0_Msk = 0x1
	// Bit P0.
	PIO_PUDR_P0 = 0x1
	// Position of P1 field.
	PIO_PUDR_P1_Pos = 0x1
	// Bit mask of P1 field.
	PIO_PUDR_P1_Msk = 0x2
	// Bit P1.
	PIO_PUDR_P1 = 0x2
	// Position of P2 field.
	PIO_PUDR_P2_Pos = 0x2
	// Bit mask of P2 field.
	PIO_PUDR_P2_Msk = 0x4
	// Bit P2.
	PIO_PUDR_P2 = 0x4
	// Position of P3 field.
	PIO_PUDR_P3_Pos = 0x3
	// Bit mask of P3 field.
	PIO_PUDR_P3_Msk = 0x8
	// Bit P3.
	PIO_PUDR_P3 = 0x8
	// Position of P4 field.
	PIO_PUDR_P4_Pos = 0x4
	// Bit mask of P4 field.
	PIO_PUDR_P4_Msk = 0x10
	// Bit P4.
	PIO_PUDR_P4 = 0x10
	// Position of P5 field.
	PIO_PUDR_P5_Pos = 0x5
	// Bit mask of P5 field.
	PIO_PUDR_P5_Msk = 0x20
	// Bit P5.
	PIO_PUDR_P5 = 0x20
	// Position of P6 field.
	PIO_PUDR_P6_Pos = 0x6
	// Bit mask of P6 field.
	PIO_PUDR_P6_Msk = 0x40
	// Bit P6.
	PIO_PUDR_P6 = 0x40
	// Position of P7 field.
	PIO_PUDR_P7_Pos = 0x7
	// Bit mask of P7 field.
	PIO_PUDR_P7_Msk = 0x80
	// Bit P7.
	PIO_PUDR_P7 = 0x80
	// Position of P8 field.
	PIO_PUDR_P8_Pos = 0x8
	// Bit mask of P8 field.
	PIO_PUDR_P8_Msk = 0x100
	// Bit P8.
	PIO_PUDR_P8 = 0x100
	// Position of P9 field.
	PIO_PUDR_P9_Pos = 0x9
	// Bit mask of P9 field.
	PIO_PUDR_P9_Msk = 0x200
	// Bit P9.
	PIO_PUDR_P9 = 0x200
	// Position of P10 field.
	PIO_PUDR_P10_Pos = 0xa
	// Bit mask of P10 field.
	PIO_PUDR_P10_Msk = 0x400
	// Bit P10.
	PIO_PUDR_P10 = 0x400
	// Position of P11 field.
	PIO_PUDR_P11_Pos = 0xb
	// Bit mask of P11 field.
	PIO_PUDR_P11_Msk = 0x800
	// Bit P11.
	PIO_PUDR_P11 = 0x800
	// Position of P12 field.
	PIO_PUDR_P12_Pos = 0xc
	// Bit mask of P12 field.
	PIO_PUDR_P12_Msk = 0x1000
	// Bit P12.
	PIO_PUDR_P12 = 0x1000
	// Position of P13 field.
	PIO_PUDR_P13_Pos = 0xd
	// Bit mask of P13 field.
	PIO_PUDR_P13_Msk = 0x2000
	// Bit P13.
	PIO_PUDR_P13 = 0x2000
	// Position of P14 field.
	PIO_PUDR_P14_Pos = 0xe
	// Bit mask of P14 field.
	PIO_PUDR_P14_Msk = 0x4000
	// Bit P14.
	PIO_PUDR_P14 = 0x4000
	// Position of P15 field.
	PIO_PUDR_P15_Pos = 0xf
	// Bit mask of P15 field.
	PIO_PUDR_P15_Msk = 0x8000
	// Bit P15.
	PIO_PUDR_P15 = 0x8000
	// Position of P16 field.
	PIO_PUDR_P16_Pos = 0x10
	// Bit mask of P16 field.
	PIO_PUDR_P16_Msk = 0x10000
	// Bit P16.
	PIO_PUDR_P16 = 0x10000
	// Position of P17 field.
	PIO_PUDR_P17_Pos = 0x11
	// Bit mask of P17 field.
	PIO_PUDR_P17_Msk = 0x20000
	// Bit P17.
	PIO_PUDR_P17 = 0x20000
	// Position of P18 field.
	PIO_PUDR_P18_Pos = 0x12
	// Bit mask of P18 field.
	PIO_PUDR_P18_Msk = 0x40000
	// Bit P18.
	PIO_PUDR_P18 = 0x40000
	// Position of P19 field.
	PIO_PUDR_P19_Pos = 0x13
	// Bit mask of P19 field.
	PIO_PUDR_P19_Msk = 0x80000
	// Bit P19.
	PIO_PUDR_P19 = 0x80000
	// Position of P20 field.
	PIO_PUDR_P20_Pos = 0x14
	// Bit mask of P20 field.
	PIO_PUDR_P20_Msk = 0x100000
	// Bit P20.
	PIO_PUDR_P20 = 0x100000
	// Position of P21 field.
	PIO_PUDR_P21_Pos = 0x15
	// Bit mask of P21 field.
	PIO_PUDR_P21_Msk = 0x200000
	// Bit P21.
	PIO_PUDR_P21 = 0x200000
	// Position of P22 field.
	PIO_PUDR_P22_Pos = 0x16
	// Bit mask of P22 field.
	PIO_PUDR_P22_Msk = 0x400000
	// Bit P22.
	PIO_PUDR_P22 = 0x400000
	// Position of P23 field.
	PIO_PUDR_P23_Pos = 0x17
	// Bit mask of P23 field.
	PIO_PUDR_P23_Msk = 0x800000
	// Bit P23.
	PIO_PUDR_P23 = 0x800000
	// Position of P24 field.
	PIO_PUDR_P24_Pos = 0x18
	// Bit mask of P24 field.
	PIO_PUDR_P24_Msk = 0x1000000
	// Bit P24.
	PIO_PUDR_P24 = 0x1000000
	// Position of P25 field.
	PIO_PUDR_P25_Pos = 0x19
	// Bit mask of P25 field.
	PIO_PUDR_P25_Msk = 0x2000000
	// Bit P25.
	PIO_PUDR_P25 = 0x2000000
	// Position of P26 field.
	PIO_PUDR_P26_Pos = 0x1a
	// Bit mask of P26 field.
	PIO_PUDR_P26_Msk = 0x4000000
	// Bit P26.
	PIO_PUDR_P26 = 0x4000000
	// Position of P27 field.
	PIO_PUDR_P27_Pos = 0x1b
	// Bit mask of P27 field.
	PIO_PUDR_P27_Msk = 0x8000000
	// Bit P27.
	PIO_PUDR_P27 = 0x8000000
	// Position of P28 field.
	PIO_PUDR_P28_Pos = 0x1c
	// Bit mask of P28 field.
	PIO_PUDR_P28_Msk = 0x10000000
	// Bit P28.
	PIO_PUDR_P28 = 0x10000000
	// Position of P29 field.
	PIO_PUDR_P29_Pos = 0x1d
	// Bit mask of P29 field.
	PIO_PUDR_P29_Msk = 0x20000000
	// Bit P29.
	PIO_PUDR_P29 = 0x20000000
	// Position of P30 field.
	PIO_PUDR_P30_Pos = 0x1e
	// Bit mask of P30 field.
	PIO_PUDR_P30_Msk = 0x40000000
	// Bit P30.
	PIO_PUDR_P30 = 0x40000000
	// Position of P31 field.
	PIO_PUDR_P31_Pos = 0x1f
	// Bit mask of P31 field.
	PIO_PUDR_P31_Msk = 0x80000000
	// Bit P31.
	PIO_PUDR_P31 = 0x80000000

	// PUER: Pull-up Enable Register
	// Position of P0 field.
	PIO_PUER_P0_Pos = 0x0
	// Bit mask of P0 field.
	PIO_PUER_P0_Msk = 0x1
	// Bit P0.
	PIO_PUER_P0 = 0x1
	// Position of P1 field.
	PIO_PUER_P1_Pos = 0x1
	// Bit mask of P1 field.
	PIO_PUER_P1_Msk = 0x2
	// Bit P1.
	PIO_PUER_P1 = 0x2
	// Position of P2 field.
	PIO_PUER_P2_Pos = 0x2
	// Bit mask of P2 field.
	PIO_PUER_P2_Msk = 0x4
	// Bit P2.
	PIO_PUER_P2 = 0x4
	// Position of P3 field.
	PIO_PUER_P3_Pos = 0x3
	// Bit mask of P3 field.
	PIO_PUER_P3_Msk = 0x8
	// Bit P3.
	PIO_PUER_P3 = 0x8
	// Position of P4 field.
	PIO_PUER_P4_Pos = 0x4
	// Bit mask of P4 field.
	PIO_PUER_P4_Msk = 0x10
	// Bit P4.
	PIO_PUER_P4 = 0x10
	// Position of P5 field.
	PIO_PUER_P5_Pos = 0x5
	// Bit mask of P5 field.
	PIO_PUER_P5_Msk = 0x20
	// Bit P5.
	PIO_PUER_P5 = 0x20
	// Position of P6 field.
	PIO_PUER_P6_Pos = 0x6
	// Bit mask of P6 field.
	PIO_PUER_P6_Msk = 0x40
	// Bit P6.
	PIO_PUER_P6 = 0x40
	// Position of P7 field.
	PIO_PUER_P7_Pos = 0x7
	// Bit mask of P7 field.
	PIO_PUER_P7_Msk = 0x80
	// Bit P7.
	PIO_PUER_P7 = 0x80
	// Position of P8 field.
	PIO_PUER_P8_Pos = 0x8
	// Bit mask of P8 field.
	PIO_PUER_P8_Msk = 0x100
	// Bit P8.
	PIO_PUER_P8 = 0x100
	// Position of P9 field.
	PIO_PUER_P9_Pos = 0x9
	// Bit mask of P9 field.
	PIO_PUER_P9_Msk = 0x200
	// Bit P9.
	PIO_PUER_P9 = 0x200
	// Position of P10 field.
	PIO_PUER_P10_Pos = 0xa
	// Bit mask of P10 field.
	PIO_PUER_P10_Msk = 0x400
	// Bit P10.
	PIO_PUER_P10 = 0x400
	// Position of P11 field.
	PIO_PUER_P11_Pos = 0xb
	// Bit mask of P11 field.
	PIO_PUER_P11_Msk = 0x800
	// Bit P11.
	PIO_PUER_P11 = 0x800
	// Position of P12 field.
	PIO_PUER_P12_Pos = 0xc
	// Bit mask of P12 field.
	PIO_PUER_P12_Msk = 0x1000
	// Bit P12.
	PIO_PUER_P12 = 0x1000
	// Position of P13 field.
	PIO_PUER_P13_Pos = 0xd
	// Bit mask of P13 field.
	PIO_PUER_P13_Msk = 0x2000
	// Bit P13.
	PIO_PUER_P13 = 0x2000
	// Position of P14 field.
	PIO_PUER_P14_Pos = 0xe
	// Bit mask of P14 field.
	PIO_PUER_P14_Msk = 0x4000
	// Bit P14.
	PIO_PUER_P14 = 0x4000
	// Position of P15 field.
	PIO_PUER_P15_Pos = 0xf
	// Bit mask of P15 field.
	PIO_PUER_P15_Msk = 0x8000
	// Bit P15.
	PIO_PUER_P15 = 0x8000
	// Position of P16 field.
	PIO_PUER_P16_Pos = 0x10
	// Bit mask of P16 field.
	PIO_PUER_P16_Msk = 0x10000
	// Bit P16.
	PIO_PUER_P16 = 0x10000
	// Position of P17 field.
	PIO_PUER_P17_Pos = 0x11
	// Bit mask of P17 field.
	PIO_PUER_P17_Msk = 0x20000
	// Bit P17.
	PIO_PUER_P17 = 0x20000
	// Position of P18 field.
	PIO_PUER_P18_Pos = 0x12
	// Bit mask of P18 field.
	PIO_PUER_P18_Msk = 0x40000
	// Bit P18.
	PIO_PUER_P18 = 0x40000
	// Position of P19 field.
	PIO_PUER_P19_Pos = 0x13
	// Bit mask of P19 field.
	PIO_PUER_P19_Msk = 0x80000
	// Bit P19.
	PIO_PUER_P19 = 0x80000
	// Position of P20 field.
	PIO_PUER_P20_Pos = 0x14
	// Bit mask of P20 field.
	PIO_PUER_P20_Msk = 0x100000
	// Bit P20.
	PIO_PUER_P20 = 0x100000
	// Position of P21 field.
	PIO_PUER_P21_Pos = 0x15
	// Bit mask of P21 field.
	PIO_PUER_P21_Msk = 0x200000
	// Bit P21.
	PIO_PUER_P21 = 0x200000
	// Position of P22 field.
	PIO_PUER_P22_Pos = 0x16
	// Bit mask of P22 field.
	PIO_PUER_P22_Msk = 0x400000
	// Bit P22.
	PIO_PUER_P22 = 0x400000
	// Position of P23 field.
	PIO_PUER_P23_Pos = 0x17
	// Bit mask of P23 field.
	PIO_PUER_P23_Msk = 0x800000
	// Bit P23.
	PIO_PUER_P23 = 0x800000
	// Position of P24 field.
	PIO_PUER_P24_Pos = 0x18
	// Bit mask of P24 field.
	PIO_PUER_P24_Msk = 0x1000000
	// Bit P24.
	PIO_PUER_P24 = 0x1000000
	// Position of P25 field.
	PIO_PUER_P25_Pos = 0x19
	// Bit mask of P25 field.
	PIO_PUER_P25_Msk = 0x2000000
	// Bit P25.
	PIO_PUER_P25 = 0x2000000
	// Position of P26 field.
	PIO_PUER_P26_Pos = 0x1a
	// Bit mask of P26 field.
	PIO_PUER_P26_Msk = 0x4000000
	// Bit P26.
	PIO_PUER_P26 = 0x4000000
	// Position of P27 field.
	PIO_PUER_P27_Pos = 0x1b
	// Bit mask of P27 field.
	PIO_PUER_P27_Msk = 0x8000000
	// Bit P27.
	PIO_PUER_P27 = 0x8000000
	// Position of P28 field.
	PIO_PUER_P28_Pos = 0x1c
	// Bit mask of P28 field.
	PIO_PUER_P28_Msk = 0x10000000
	// Bit P28.
	PIO_PUER_P28 = 0x10000000
	// Position of P29 field.
	PIO_PUER_P29_Pos = 0x1d
	// Bit mask of P29 field.
	PIO_PUER_P29_Msk = 0x20000000
	// Bit P29.
	PIO_PUER_P29 = 0x20000000
	// Position of P30 field.
	PIO_PUER_P30_Pos = 0x1e
	// Bit mask of P30 field.
	PIO_PUER_P30_Msk = 0x40000000
	// Bit P30.
	PIO_PUER_P30 = 0x40000000
	// Position of P31 field.
	PIO_PUER_P31_Pos = 0x1f
	// Bit mask of P31 field.
	PIO_PUER_P31_Msk = 0x80000000
	// Bit P31.
	PIO_PUER_P31 = 0x80000000

	// PUSR: Pad Pull-up Status Register
	// Position of P0 field.
	PIO_PUSR_P0_Pos = 0x0
	// Bit mask of P0 field.
	PIO_PUSR_P0_Msk = 0x1
	// Bit P0.
	PIO_PUSR_P0 = 0x1
	// Position of P1 field.
	PIO_PUSR_P1_Pos = 0x1
	// Bit mask of P1 field.
	PIO_PUSR_P1_Msk = 0x2
	// Bit P1.
	PIO_PUSR_P1 = 0x2
	// Position of P2 field.
	PIO_PUSR_P2_Pos = 0x2
	// Bit mask of P2 field.
	PIO_PUSR_P2_Msk = 0x4
	// Bit P2.
	PIO_PUSR_P2 = 0x4
	// Position of P3 field.
	PIO_PUSR_P3_Pos = 0x3
	// Bit mask of P3 field.
	PIO_PUSR_P3_Msk = 0x8
	// Bit P3.
	PIO_PUSR_P3 = 0x8
	// Position of P4 field.
	PIO_PUSR_P4_Pos = 0x4
	// Bit mask of P4 field.
	PIO_PUSR_P4_Msk = 0x10
	// Bit P4.
	PIO_PUSR_P4 = 0x10
	// Position of P5 field.
	PIO_PUSR_P5_Pos = 0x5
	// Bit mask of P5 field.
	PIO_PUSR_P5_Msk = 0x20
	// Bit P5.
	PIO_PUSR_P5 = 0x20
	// Position of P6 field.
	PIO_PUSR_P6_Pos = 0x6
	// Bit mask of P6 field.
	PIO_PUSR_P6_Msk = 0x40
	// Bit P6.
	PIO_PUSR_P6 = 0x40
	// Position of P7 field.
	PIO_PUSR_P7_Pos = 0x7
	// Bit mask of P7 field.
	PIO_PUSR_P7_Msk = 0x80
	// Bit P7.
	PIO_PUSR_P7 = 0x80
	// Position of P8 field.
	PIO_PUSR_P8_Pos = 0x8
	// Bit mask of P8 field.
	PIO_PUSR_P8_Msk = 0x100
	// Bit P8.
	PIO_PUSR_P8 = 0x100
	// Position of P9 field.
	PIO_PUSR_P9_Pos = 0x9
	// Bit mask of P9 field.
	PIO_PUSR_P9_Msk = 0x200
	// Bit P9.
	PIO_PUSR_P9 = 0x200
	// Position of P10 field.
	PIO_PUSR_P10_Pos = 0xa
	// Bit mask of P10 field.
	PIO_PUSR_P10_Msk = 0x400
	// Bit P10.
	PIO_PUSR_P10 = 0x400
	// Position of P11 field.
	PIO_PUSR_P11_Pos = 0xb
	// Bit mask of P11 field.
	PIO_PUSR_P11_Msk = 0x800
	// Bit P11.
	PIO_PUSR_P11 = 0x800
	// Position of P12 field.
	PIO_PUSR_P12_Pos = 0xc
	// Bit mask of P12 field.
	PIO_PUSR_P12_Msk = 0x1000
	// Bit P12.
	PIO_PUSR_P12 = 0x1000
	// Position of P13 field.
	PIO_PUSR_P13_Pos = 0xd
	// Bit mask of P13 field.
	PIO_PUSR_P13_Msk = 0x2000
	// Bit P13.
	PIO_PUSR_P13 = 0x2000
	// Position of P14 field.
	PIO_PUSR_P14_Pos = 0xe
	// Bit mask of P14 field.
	PIO_PUSR_P14_Msk = 0x4000
	// Bit P14.
	PIO_PUSR_P14 = 0x4000
	// Position of P15 field.
	PIO_PUSR_P15_Pos = 0xf
	// Bit mask of P15 field.
	PIO_PUSR_P15_Msk = 0x8000
	// Bit P15.
	PIO_PUSR_P15 = 0x8000
	// Position of P16 field.
	PIO_PUSR_P16_Pos = 0x10
	// Bit mask of P16 field.
	PIO_PUSR_P16_Msk = 0x10000
	// Bit P16.
	PIO_PUSR_P16 = 0x10000
	// Position of P17 field.
	PIO_PUSR_P17_Pos = 0x11
	// Bit mask of P17 field.
	PIO_PUSR_P17_Msk = 0x20000
	// Bit P17.
	PIO_PUSR_P17 = 0x20000
	// Position of P18 field.
	PIO_PUSR_P18_Pos = 0x12
	// Bit mask of P18 field.
	PIO_PUSR_P18_Msk = 0x40000
	// Bit P18.
	PIO_PUSR_P18 = 0x40000
	// Position of P19 field.
	PIO_PUSR_P19_Pos = 0x13
	// Bit mask of P19 field.
	PIO_PUSR_P19_Msk = 0x80000
	// Bit P19.
	PIO_PUSR_P19 = 0x80000
	// Position of P20 field.
	PIO_PUSR_P20_Pos = 0x14
	// Bit mask of P20 field.
	PIO_PUSR_P20_Msk = 0x100000
	// Bit P20.
	PIO_PUSR_P20 = 0x100000
	// Position of P21 field.
	PIO_PUSR_P21_Pos = 0x15
	// Bit mask of P21 field.
	PIO_PUSR_P21_Msk = 0x200000
	// Bit P21.
	PIO_PUSR_P21 = 0x200000
	// Position of P22 field.
	PIO_PUSR_P22_Pos = 0x16
	// Bit mask of P22 field.
	PIO_PUSR_P22_Msk = 0x400000
	// Bit P22.
	PIO_PUSR_P22 = 0x400000
	// Position of P23 field.
	PIO_PUSR_P23_Pos = 0x17
	// Bit mask of P23 field.
	PIO_PUSR_P23_Msk = 0x800000
	// Bit P23.
	PIO_PUSR_P23 = 0x800000
	// Position of P24 field.
	PIO_PUSR_P24_Pos = 0x18
	// Bit mask of P24 field.
	PIO_PUSR_P24_Msk = 0x1000000
	// Bit P24.
	PIO_PUSR_P24 = 0x1000000
	// Position of P25 field.
	PIO_PUSR_P25_Pos = 0x19
	// Bit mask of P25 field.
	PIO_PUSR_P25_Msk = 0x2000000
	// Bit P25.
	PIO_PUSR_P25 = 0x2000000
	// Position of P26 field.
	PIO_PUSR_P26_Pos = 0x1a
	// Bit mask of P26 field.
	PIO_PUSR_P26_Msk = 0x4000000
	// Bit P26.
	PIO_PUSR_P26 = 0x4000000
	// Position of P27 field.
	PIO_PUSR_P27_Pos = 0x1b
	// Bit mask of P27 field.
	PIO_PUSR_P27_Msk = 0x8000000
	// Bit P27.
	PIO_PUSR_P27 = 0x8000000
	// Position of P28 field.
	PIO_PUSR_P28_Pos = 0x1c
	// Bit mask of P28 field.
	PIO_PUSR_P28_Msk = 0x10000000
	// Bit P28.
	PIO_PUSR_P28 = 0x10000000
	// Position of P29 field.
	PIO_PUSR_P29_Pos = 0x1d
	// Bit mask of P29 field.
	PIO_PUSR_P29_Msk = 0x20000000
	// Bit P29.
	PIO_PUSR_P29 = 0x20000000
	// Position of P30 field.
	PIO_PUSR_P30_Pos = 0x1e
	// Bit mask of P30 field.
	PIO_PUSR_P30_Msk = 0x40000000
	// Bit P30.
	PIO_PUSR_P30 = 0x40000000
	// Position of P31 field.
	PIO_PUSR_P31_Pos = 0x1f
	// Bit mask of P31 field.
	PIO_PUSR_P31_Msk = 0x80000000
	// Bit P31.
	PIO_PUSR_P31 = 0x80000000

	// ABSR: Peripheral AB Select Register
	// Position of P0 field.
	PIO_ABSR_P0_Pos = 0x0
	// Bit mask of P0 field.
	PIO_ABSR_P0_Msk = 0x1
	// Bit P0.
	PIO_ABSR_P0 = 0x1
	// Position of P1 field.
	PIO_ABSR_P1_Pos = 0x1
	// Bit mask of P1 field.
	PIO_ABSR_P1_Msk = 0x2
	// Bit P1.
	PIO_ABSR_P1 = 0x2
	// Position of P2 field.
	PIO_ABSR_P2_Pos = 0x2
	// Bit mask of P2 field.
	PIO_ABSR_P2_Msk = 0x4
	// Bit P2.
	PIO_ABSR_P2 = 0x4
	// Position of P3 field.
	PIO_ABSR_P3_Pos = 0x3
	// Bit mask of P3 field.
	PIO_ABSR_P3_Msk = 0x8
	// Bit P3.
	PIO_ABSR_P3 = 0x8
	// Position of P4 field.
	PIO_ABSR_P4_Pos = 0x4
	// Bit mask of P4 field.
	PIO_ABSR_P4_Msk = 0x10
	// Bit P4.
	PIO_ABSR_P4 = 0x10
	// Position of P5 field.
	PIO_ABSR_P5_Pos = 0x5
	// Bit mask of P5 field.
	PIO_ABSR_P5_Msk = 0x20
	// Bit P5.
	PIO_ABSR_P5 = 0x20
	// Position of P6 field.
	PIO_ABSR_P6_Pos = 0x6
	// Bit mask of P6 field.
	PIO_ABSR_P6_Msk = 0x40
	// Bit P6.
	PIO_ABSR_P6 = 0x40
	// Position of P7 field.
	PIO_ABSR_P7_Pos = 0x7
	// Bit mask of P7 field.
	PIO_ABSR_P7_Msk = 0x80
	// Bit P7.
	PIO_ABSR_P7 = 0x80
	// Position of P8 field.
	PIO_ABSR_P8_Pos = 0x8
	// Bit mask of P8 field.
	PIO_ABSR_P8_Msk = 0x100
	// Bit P8.
	PIO_ABSR_P8 = 0x100
	// Position of P9 field.
	PIO_ABSR_P9_Pos = 0x9
	// Bit mask of P9 field.
	PIO_ABSR_P9_Msk = 0x200
	// Bit P9.
	PIO_ABSR_P9 = 0x200
	// Position of P10 field.
	PIO_ABSR_P10_Pos = 0xa
	// Bit mask of P10 field.
	PIO_ABSR_P10_Msk = 0x400
	// Bit P10.
	PIO_ABSR_P10 = 0x400
	// Position of P11 field.
	PIO_ABSR_P11_Pos = 0xb
	// Bit mask of P11 field.
	PIO_ABSR_P11_Msk = 0x800
	// Bit P11.
	PIO_ABSR_P11 = 0x800
	// Position of P12 field.
	PIO_ABSR_P12_Pos = 0xc
	// Bit mask of P12 field.
	PIO_ABSR_P12_Msk = 0x1000
	// Bit P12.
	PIO_ABSR_P12 = 0x1000
	// Position of P13 field.
	PIO_ABSR_P13_Pos = 0xd
	// Bit mask of P13 field.
	PIO_ABSR_P13_Msk = 0x2000
	// Bit P13.
	PIO_ABSR_P13 = 0x2000
	// Position of P14 field.
	PIO_ABSR_P14_Pos = 0xe
	// Bit mask of P14 field.
	PIO_ABSR_P14_Msk = 0x4000
	// Bit P14.
	PIO_ABSR_P14 = 0x4000
	// Position of P15 field.
	PIO_ABSR_P15_Pos = 0xf
	// Bit mask of P15 field.
	PIO_ABSR_P15_Msk = 0x8000
	// Bit P15.
	PIO_ABSR_P15 = 0x8000
	// Position of P16 field.
	PIO_ABSR_P16_Pos = 0x10
	// Bit mask of P16 field.
	PIO_ABSR_P16_Msk = 0x10000
	// Bit P16.
	PIO_ABSR_P16 = 0x10000
	// Position of P17 field.
	PIO_ABSR_P17_Pos = 0x11
	// Bit mask of P17 field.
	PIO_ABSR_P17_Msk = 0x20000
	// Bit P17.
	PIO_ABSR_P17 = 0x20000
	// Position of P18 field.
	PIO_ABSR_P18_Pos = 0x12
	// Bit mask of P18 field.
	PIO_ABSR_P18_Msk = 0x40000
	// Bit P18.
	PIO_ABSR_P18 = 0x40000
	// Position of P19 field.
	PIO_ABSR_P19_Pos = 0x13
	// Bit mask of P19 field.
	PIO_ABSR_P19_Msk = 0x80000
	// Bit P19.
	PIO_ABSR_P19 = 0x80000
	// Position of P20 field.
	PIO_ABSR_P20_Pos = 0x14
	// Bit mask of P20 field.
	PIO_ABSR_P20_Msk = 0x100000
	// Bit P20.
	PIO_ABSR_P20 = 0x100000
	// Position of P21 field.
	PIO_ABSR_P21_Pos = 0x15
	// Bit mask of P21 field.
	PIO_ABSR_P21_Msk = 0x200000
	// Bit P21.
	PIO_ABSR_P21 = 0x200000
	// Position of P22 field.
	PIO_ABSR_P22_Pos = 0x16
	// Bit mask of P22 field.
	PIO_ABSR_P22_Msk = 0x400000
	// Bit P22.
	PIO_ABSR_P22 = 0x400000
	// Position of P23 field.
	PIO_ABSR_P23_Pos = 0x17
	// Bit mask of P23 field.
	PIO_ABSR_P23_Msk = 0x800000
	// Bit P23.
	PIO_ABSR_P23 = 0x800000
	// Position of P24 field.
	PIO_ABSR_P24_Pos = 0x18
	// Bit mask of P24 field.
	PIO_ABSR_P24_Msk = 0x1000000
	// Bit P24.
	PIO_ABSR_P24 = 0x1000000
	// Position of P25 field.
	PIO_ABSR_P25_Pos = 0x19
	// Bit mask of P25 field.
	PIO_ABSR_P25_Msk = 0x2000000
	// Bit P25.
	PIO_ABSR_P25 = 0x2000000
	// Position of P26 field.
	PIO_ABSR_P26_Pos = 0x1a
	// Bit mask of P26 field.
	PIO_ABSR_P26_Msk = 0x4000000
	// Bit P26.
	PIO_ABSR_P26 = 0x4000000
	// Position of P27 field.
	PIO_ABSR_P27_Pos = 0x1b
	// Bit mask of P27 field.
	PIO_ABSR_P27_Msk = 0x8000000
	// Bit P27.
	PIO_ABSR_P27 = 0x8000000
	// Position of P28 field.
	PIO_ABSR_P28_Pos = 0x1c
	// Bit mask of P28 field.
	PIO_ABSR_P28_Msk = 0x10000000
	// Bit P28.
	PIO_ABSR_P28 = 0x10000000
	// Position of P29 field.
	PIO_ABSR_P29_Pos = 0x1d
	// Bit mask of P29 field.
	PIO_ABSR_P29_Msk = 0x20000000
	// Bit P29.
	PIO_ABSR_P29 = 0x20000000
	// Position of P30 field.
	PIO_ABSR_P30_Pos = 0x1e
	// Bit mask of P30 field.
	PIO_ABSR_P30_Msk = 0x40000000
	// Bit P30.
	PIO_ABSR_P30 = 0x40000000
	// Position of P31 field.
	PIO_ABSR_P31_Pos = 0x1f
	// Bit mask of P31 field.
	PIO_ABSR_P31_Msk = 0x80000000
	// Bit P31.
	PIO_ABSR_P31 = 0x80000000

	// SCIFSR: System Clock Glitch Input Filter Select Register
	// Position of P0 field.
	PIO_SCIFSR_P0_Pos = 0x0
	// Bit mask of P0 field.
	PIO_SCIFSR_P0_Msk = 0x1
	// Bit P0.
	PIO_SCIFSR_P0 = 0x1
	// Position of P1 field.
	PIO_SCIFSR_P1_Pos = 0x1
	// Bit mask of P1 field.
	PIO_SCIFSR_P1_Msk = 0x2
	// Bit P1.
	PIO_SCIFSR_P1 = 0x2
	// Position of P2 field.
	PIO_SCIFSR_P2_Pos = 0x2
	// Bit mask of P2 field.
	PIO_SCIFSR_P2_Msk = 0x4
	// Bit P2.
	PIO_SCIFSR_P2 = 0x4
	// Position of P3 field.
	PIO_SCIFSR_P3_Pos = 0x3
	// Bit mask of P3 field.
	PIO_SCIFSR_P3_Msk = 0x8
	// Bit P3.
	PIO_SCIFSR_P3 = 0x8
	// Position of P4 field.
	PIO_SCIFSR_P4_Pos = 0x4
	// Bit mask of P4 field.
	PIO_SCIFSR_P4_Msk = 0x10
	// Bit P4.
	PIO_SCIFSR_P4 = 0x10
	// Position of P5 field.
	PIO_SCIFSR_P5_Pos = 0x5
	// Bit mask of P5 field.
	PIO_SCIFSR_P5_Msk = 0x20
	// Bit P5.
	PIO_SCIFSR_P5 = 0x20
	// Position of P6 field.
	PIO_SCIFSR_P6_Pos = 0x6
	// Bit mask of P6 field.
	PIO_SCIFSR_P6_Msk = 0x40
	// Bit P6.
	PIO_SCIFSR_P6 = 0x40
	// Position of P7 field.
	PIO_SCIFSR_P7_Pos = 0x7
	// Bit mask of P7 field.
	PIO_SCIFSR_P7_Msk = 0x80
	// Bit P7.
	PIO_SCIFSR_P7 = 0x80
	// Position of P8 field.
	PIO_SCIFSR_P8_Pos = 0x8
	// Bit mask of P8 field.
	PIO_SCIFSR_P8_Msk = 0x100
	// Bit P8.
	PIO_SCIFSR_P8 = 0x100
	// Position of P9 field.
	PIO_SCIFSR_P9_Pos = 0x9
	// Bit mask of P9 field.
	PIO_SCIFSR_P9_Msk = 0x200
	// Bit P9.
	PIO_SCIFSR_P9 = 0x200
	// Position of P10 field.
	PIO_SCIFSR_P10_Pos = 0xa
	// Bit mask of P10 field.
	PIO_SCIFSR_P10_Msk = 0x400
	// Bit P10.
	PIO_SCIFSR_P10 = 0x400
	// Position of P11 field.
	PIO_SCIFSR_P11_Pos = 0xb
	// Bit mask of P11 field.
	PIO_SCIFSR_P11_Msk = 0x800
	// Bit P11.
	PIO_SCIFSR_P11 = 0x800
	// Position of P12 field.
	PIO_SCIFSR_P12_Pos = 0xc
	// Bit mask of P12 field.
	PIO_SCIFSR_P12_Msk = 0x1000
	// Bit P12.
	PIO_SCIFSR_P12 = 0x1000
	// Position of P13 field.
	PIO_SCIFSR_P13_Pos = 0xd
	// Bit mask of P13 field.
	PIO_SCIFSR_P13_Msk = 0x2000
	// Bit P13.
	PIO_SCIFSR_P13 = 0x2000
	// Position of P14 field.
	PIO_SCIFSR_P14_Pos = 0xe
	// Bit mask of P14 field.
	PIO_SCIFSR_P14_Msk = 0x4000
	// Bit P14.
	PIO_SCIFSR_P14 = 0x4000
	// Position of P15 field.
	PIO_SCIFSR_P15_Pos = 0xf
	// Bit mask of P15 field.
	PIO_SCIFSR_P15_Msk = 0x8000
	// Bit P15.
	PIO_SCIFSR_P15 = 0x8000
	// Position of P16 field.
	PIO_SCIFSR_P16_Pos = 0x10
	// Bit mask of P16 field.
	PIO_SCIFSR_P16_Msk = 0x10000
	// Bit P16.
	PIO_SCIFSR_P16 = 0x10000
	// Position of P17 field.
	PIO_SCIFSR_P17_Pos = 0x11
	// Bit mask of P17 field.
	PIO_SCIFSR_P17_Msk = 0x20000
	// Bit P17.
	PIO_SCIFSR_P17 = 0x20000
	// Position of P18 field.
	PIO_SCIFSR_P18_Pos = 0x12
	// Bit mask of P18 field.
	PIO_SCIFSR_P18_Msk = 0x40000
	// Bit P18.
	PIO_SCIFSR_P18 = 0x40000
	// Position of P19 field.
	PIO_SCIFSR_P19_Pos = 0x13
	// Bit mask of P19 field.
	PIO_SCIFSR_P19_Msk = 0x80000
	// Bit P19.
	PIO_SCIFSR_P19 = 0x80000
	// Position of P20 field.
	PIO_SCIFSR_P20_Pos = 0x14
	// Bit mask of P20 field.
	PIO_SCIFSR_P20_Msk = 0x100000
	// Bit P20.
	PIO_SCIFSR_P20 = 0x100000
	// Position of P21 field.
	PIO_SCIFSR_P21_Pos = 0x15
	// Bit mask of P21 field.
	PIO_SCIFSR_P21_Msk = 0x200000
	// Bit P21.
	PIO_SCIFSR_P21 = 0x200000
	// Position of P22 field.
	PIO_SCIFSR_P22_Pos = 0x16
	// Bit mask of P22 field.
	PIO_SCIFSR_P22_Msk = 0x400000
	// Bit P22.
	PIO_SCIFSR_P22 = 0x400000
	// Position of P23 field.
	PIO_SCIFSR_P23_Pos = 0x17
	// Bit mask of P23 field.
	PIO_SCIFSR_P23_Msk = 0x800000
	// Bit P23.
	PIO_SCIFSR_P23 = 0x800000
	// Position of P24 field.
	PIO_SCIFSR_P24_Pos = 0x18
	// Bit mask of P24 field.
	PIO_SCIFSR_P24_Msk = 0x1000000
	// Bit P24.
	PIO_SCIFSR_P24 = 0x1000000
	// Position of P25 field.
	PIO_SCIFSR_P25_Pos = 0x19
	// Bit mask of P25 field.
	PIO_SCIFSR_P25_Msk = 0x2000000
	// Bit P25.
	PIO_SCIFSR_P25 = 0x2000000
	// Position of P26 field.
	PIO_SCIFSR_P26_Pos = 0x1a
	// Bit mask of P26 field.
	PIO_SCIFSR_P26_Msk = 0x4000000
	// Bit P26.
	PIO_SCIFSR_P26 = 0x4000000
	// Position of P27 field.
	PIO_SCIFSR_P27_Pos = 0x1b
	// Bit mask of P27 field.
	PIO_SCIFSR_P27_Msk = 0x8000000
	// Bit P27.
	PIO_SCIFSR_P27 = 0x8000000
	// Position of P28 field.
	PIO_SCIFSR_P28_Pos = 0x1c
	// Bit mask of P28 field.
	PIO_SCIFSR_P28_Msk = 0x10000000
	// Bit P28.
	PIO_SCIFSR_P28 = 0x10000000
	// Position of P29 field.
	PIO_SCIFSR_P29_Pos = 0x1d
	// Bit mask of P29 field.
	PIO_SCIFSR_P29_Msk = 0x20000000
	// Bit P29.
	PIO_SCIFSR_P29 = 0x20000000
	// Position of P30 field.
	PIO_SCIFSR_P30_Pos = 0x1e
	// Bit mask of P30 field.
	PIO_SCIFSR_P30_Msk = 0x40000000
	// Bit P30.
	PIO_SCIFSR_P30 = 0x40000000
	// Position of P31 field.
	PIO_SCIFSR_P31_Pos = 0x1f
	// Bit mask of P31 field.
	PIO_SCIFSR_P31_Msk = 0x80000000
	// Bit P31.
	PIO_SCIFSR_P31 = 0x80000000

	// DIFSR: Debouncing Input Filter Select Register
	// Position of P0 field.
	PIO_DIFSR_P0_Pos = 0x0
	// Bit mask of P0 field.
	PIO_DIFSR_P0_Msk = 0x1
	// Bit P0.
	PIO_DIFSR_P0 = 0x1
	// Position of P1 field.
	PIO_DIFSR_P1_Pos = 0x1
	// Bit mask of P1 field.
	PIO_DIFSR_P1_Msk = 0x2
	// Bit P1.
	PIO_DIFSR_P1 = 0x2
	// Position of P2 field.
	PIO_DIFSR_P2_Pos = 0x2
	// Bit mask of P2 field.
	PIO_DIFSR_P2_Msk = 0x4
	// Bit P2.
	PIO_DIFSR_P2 = 0x4
	// Position of P3 field.
	PIO_DIFSR_P3_Pos = 0x3
	// Bit mask of P3 field.
	PIO_DIFSR_P3_Msk = 0x8
	// Bit P3.
	PIO_DIFSR_P3 = 0x8
	// Position of P4 field.
	PIO_DIFSR_P4_Pos = 0x4
	// Bit mask of P4 field.
	PIO_DIFSR_P4_Msk = 0x10
	// Bit P4.
	PIO_DIFSR_P4 = 0x10
	// Position of P5 field.
	PIO_DIFSR_P5_Pos = 0x5
	// Bit mask of P5 field.
	PIO_DIFSR_P5_Msk = 0x20
	// Bit P5.
	PIO_DIFSR_P5 = 0x20
	// Position of P6 field.
	PIO_DIFSR_P6_Pos = 0x6
	// Bit mask of P6 field.
	PIO_DIFSR_P6_Msk = 0x40
	// Bit P6.
	PIO_DIFSR_P6 = 0x40
	// Position of P7 field.
	PIO_DIFSR_P7_Pos = 0x7
	// Bit mask of P7 field.
	PIO_DIFSR_P7_Msk = 0x80
	// Bit P7.
	PIO_DIFSR_P7 = 0x80
	// Position of P8 field.
	PIO_DIFSR_P8_Pos = 0x8
	// Bit mask of P8 field.
	PIO_DIFSR_P8_Msk = 0x100
	// Bit P8.
	PIO_DIFSR_P8 = 0x100
	// Position of P9 field.
	PIO_DIFSR_P9_Pos = 0x9
	// Bit mask of P9 field.
	PIO_DIFSR_P9_Msk = 0x200
	// Bit P9.
	PIO_DIFSR_P9 = 0x200
	// Position of P10 field.
	PIO_DIFSR_P10_Pos = 0xa
	// Bit mask of P10 field.
	PIO_DIFSR_P10_Msk = 0x400
	// Bit P10.
	PIO_DIFSR_P10 = 0x400
	// Position of P11 field.
	PIO_DIFSR_P11_Pos = 0xb
	// Bit mask of P11 field.
	PIO_DIFSR_P11_Msk = 0x800
	// Bit P11.
	PIO_DIFSR_P11 = 0x800
	// Position of P12 field.
	PIO_DIFSR_P12_Pos = 0xc
	// Bit mask of P12 field.
	PIO_DIFSR_P12_Msk = 0x1000
	// Bit P12.
	PIO_DIFSR_P12 = 0x1000
	// Position of P13 field.
	PIO_DIFSR_P13_Pos = 0xd
	// Bit mask of P13 field.
	PIO_DIFSR_P13_Msk = 0x2000
	// Bit P13.
	PIO_DIFSR_P13 = 0x2000
	// Position of P14 field.
	PIO_DIFSR_P14_Pos = 0xe
	// Bit mask of P14 field.
	PIO_DIFSR_P14_Msk = 0x4000
	// Bit P14.
	PIO_DIFSR_P14 = 0x4000
	// Position of P15 field.
	PIO_DIFSR_P15_Pos = 0xf
	// Bit mask of P15 field.
	PIO_DIFSR_P15_Msk = 0x8000
	// Bit P15.
	PIO_DIFSR_P15 = 0x8000
	// Position of P16 field.
	PIO_DIFSR_P16_Pos = 0x10
	// Bit mask of P16 field.
	PIO_DIFSR_P16_Msk = 0x10000
	// Bit P16.
	PIO_DIFSR_P16 = 0x10000
	// Position of P17 field.
	PIO_DIFSR_P17_Pos = 0x11
	// Bit mask of P17 field.
	PIO_DIFSR_P17_Msk = 0x20000
	// Bit P17.
	PIO_DIFSR_P17 = 0x20000
	// Position of P18 field.
	PIO_DIFSR_P18_Pos = 0x12
	// Bit mask of P18 field.
	PIO_DIFSR_P18_Msk = 0x40000
	// Bit P18.
	PIO_DIFSR_P18 = 0x40000
	// Position of P19 field.
	PIO_DIFSR_P19_Pos = 0x13
	// Bit mask of P19 field.
	PIO_DIFSR_P19_Msk = 0x80000
	// Bit P19.
	PIO_DIFSR_P19 = 0x80000
	// Position of P20 field.
	PIO_DIFSR_P20_Pos = 0x14
	// Bit mask of P20 field.
	PIO_DIFSR_P20_Msk = 0x100000
	// Bit P20.
	PIO_DIFSR_P20 = 0x100000
	// Position of P21 field.
	PIO_DIFSR_P21_Pos = 0x15
	// Bit mask of P21 field.
	PIO_DIFSR_P21_Msk = 0x200000
	// Bit P21.
	PIO_DIFSR_P21 = 0x200000
	// Position of P22 field.
	PIO_DIFSR_P22_Pos = 0x16
	// Bit mask of P22 field.
	PIO_DIFSR_P22_Msk = 0x400000
	// Bit P22.
	PIO_DIFSR_P22 = 0x400000
	// Position of P23 field.
	PIO_DIFSR_P23_Pos = 0x17
	// Bit mask of P23 field.
	PIO_DIFSR_P23_Msk = 0x800000
	// Bit P23.
	PIO_DIFSR_P23 = 0x800000
	// Position of P24 field.
	PIO_DIFSR_P24_Pos = 0x18
	// Bit mask of P24 field.
	PIO_DIFSR_P24_Msk = 0x1000000
	// Bit P24.
	PIO_DIFSR_P24 = 0x1000000
	// Position of P25 field.
	PIO_DIFSR_P25_Pos = 0x19
	// Bit mask of P25 field.
	PIO_DIFSR_P25_Msk = 0x2000000
	// Bit P25.
	PIO_DIFSR_P25 = 0x2000000
	// Position of P26 field.
	PIO_DIFSR_P26_Pos = 0x1a
	// Bit mask of P26 field.
	PIO_DIFSR_P26_Msk = 0x4000000
	// Bit P26.
	PIO_DIFSR_P26 = 0x4000000
	// Position of P27 field.
	PIO_DIFSR_P27_Pos = 0x1b
	// Bit mask of P27 field.
	PIO_DIFSR_P27_Msk = 0x8000000
	// Bit P27.
	PIO_DIFSR_P27 = 0x8000000
	// Position of P28 field.
	PIO_DIFSR_P28_Pos = 0x1c
	// Bit mask of P28 field.
	PIO_DIFSR_P28_Msk = 0x10000000
	// Bit P28.
	PIO_DIFSR_P28 = 0x10000000
	// Position of P29 field.
	PIO_DIFSR_P29_Pos = 0x1d
	// Bit mask of P29 field.
	PIO_DIFSR_P29_Msk = 0x20000000
	// Bit P29.
	PIO_DIFSR_P29 = 0x20000000
	// Position of P30 field.
	PIO_DIFSR_P30_Pos = 0x1e
	// Bit mask of P30 field.
	PIO_DIFSR_P30_Msk = 0x40000000
	// Bit P30.
	PIO_DIFSR_P30 = 0x40000000
	// Position of P31 field.
	PIO_DIFSR_P31_Pos = 0x1f
	// Bit mask of P31 field.
	PIO_DIFSR_P31_Msk = 0x80000000
	// Bit P31.
	PIO_DIFSR_P31 = 0x80000000

	// IFDGSR: Glitch or Debouncing Input Filter Clock Selection Status Register
	// Position of P0 field.
	PIO_IFDGSR_P0_Pos = 0x0
	// Bit mask of P0 field.
	PIO_IFDGSR_P0_Msk = 0x1
	// Bit P0.
	PIO_IFDGSR_P0 = 0x1
	// Position of P1 field.
	PIO_IFDGSR_P1_Pos = 0x1
	// Bit mask of P1 field.
	PIO_IFDGSR_P1_Msk = 0x2
	// Bit P1.
	PIO_IFDGSR_P1 = 0x2
	// Position of P2 field.
	PIO_IFDGSR_P2_Pos = 0x2
	// Bit mask of P2 field.
	PIO_IFDGSR_P2_Msk = 0x4
	// Bit P2.
	PIO_IFDGSR_P2 = 0x4
	// Position of P3 field.
	PIO_IFDGSR_P3_Pos = 0x3
	// Bit mask of P3 field.
	PIO_IFDGSR_P3_Msk = 0x8
	// Bit P3.
	PIO_IFDGSR_P3 = 0x8
	// Position of P4 field.
	PIO_IFDGSR_P4_Pos = 0x4
	// Bit mask of P4 field.
	PIO_IFDGSR_P4_Msk = 0x10
	// Bit P4.
	PIO_IFDGSR_P4 = 0x10
	// Position of P5 field.
	PIO_IFDGSR_P5_Pos = 0x5
	// Bit mask of P5 field.
	PIO_IFDGSR_P5_Msk = 0x20
	// Bit P5.
	PIO_IFDGSR_P5 = 0x20
	// Position of P6 field.
	PIO_IFDGSR_P6_Pos = 0x6
	// Bit mask of P6 field.
	PIO_IFDGSR_P6_Msk = 0x40
	// Bit P6.
	PIO_IFDGSR_P6 = 0x40
	// Position of P7 field.
	PIO_IFDGSR_P7_Pos = 0x7
	// Bit mask of P7 field.
	PIO_IFDGSR_P7_Msk = 0x80
	// Bit P7.
	PIO_IFDGSR_P7 = 0x80
	// Position of P8 field.
	PIO_IFDGSR_P8_Pos = 0x8
	// Bit mask of P8 field.
	PIO_IFDGSR_P8_Msk = 0x100
	// Bit P8.
	PIO_IFDGSR_P8 = 0x100
	// Position of P9 field.
	PIO_IFDGSR_P9_Pos = 0x9
	// Bit mask of P9 field.
	PIO_IFDGSR_P9_Msk = 0x200
	// Bit P9.
	PIO_IFDGSR_P9 = 0x200
	// Position of P10 field.
	PIO_IFDGSR_P10_Pos = 0xa
	// Bit mask of P10 field.
	PIO_IFDGSR_P10_Msk = 0x400
	// Bit P10.
	PIO_IFDGSR_P10 = 0x400
	// Position of P11 field.
	PIO_IFDGSR_P11_Pos = 0xb
	// Bit mask of P11 field.
	PIO_IFDGSR_P11_Msk = 0x800
	// Bit P11.
	PIO_IFDGSR_P11 = 0x800
	// Position of P12 field.
	PIO_IFDGSR_P12_Pos = 0xc
	// Bit mask of P12 field.
	PIO_IFDGSR_P12_Msk = 0x1000
	// Bit P12.
	PIO_IFDGSR_P12 = 0x1000
	// Position of P13 field.
	PIO_IFDGSR_P13_Pos = 0xd
	// Bit mask of P13 field.
	PIO_IFDGSR_P13_Msk = 0x2000
	// Bit P13.
	PIO_IFDGSR_P13 = 0x2000
	// Position of P14 field.
	PIO_IFDGSR_P14_Pos = 0xe
	// Bit mask of P14 field.
	PIO_IFDGSR_P14_Msk = 0x4000
	// Bit P14.
	PIO_IFDGSR_P14 = 0x4000
	// Position of P15 field.
	PIO_IFDGSR_P15_Pos = 0xf
	// Bit mask of P15 field.
	PIO_IFDGSR_P15_Msk = 0x8000
	// Bit P15.
	PIO_IFDGSR_P15 = 0x8000
	// Position of P16 field.
	PIO_IFDGSR_P16_Pos = 0x10
	// Bit mask of P16 field.
	PIO_IFDGSR_P16_Msk = 0x10000
	// Bit P16.
	PIO_IFDGSR_P16 = 0x10000
	// Position of P17 field.
	PIO_IFDGSR_P17_Pos = 0x11
	// Bit mask of P17 field.
	PIO_IFDGSR_P17_Msk = 0x20000
	// Bit P17.
	PIO_IFDGSR_P17 = 0x20000
	// Position of P18 field.
	PIO_IFDGSR_P18_Pos = 0x12
	// Bit mask of P18 field.
	PIO_IFDGSR_P18_Msk = 0x40000
	// Bit P18.
	PIO_IFDGSR_P18 = 0x40000
	// Position of P19 field.
	PIO_IFDGSR_P19_Pos = 0x13
	// Bit mask of P19 field.
	PIO_IFDGSR_P19_Msk = 0x80000
	// Bit P19.
	PIO_IFDGSR_P19 = 0x80000
	// Position of P20 field.
	PIO_IFDGSR_P20_Pos = 0x14
	// Bit mask of P20 field.
	PIO_IFDGSR_P20_Msk = 0x100000
	// Bit P20.
	PIO_IFDGSR_P20 = 0x100000
	// Position of P21 field.
	PIO_IFDGSR_P21_Pos = 0x15
	// Bit mask of P21 field.
	PIO_IFDGSR_P21_Msk = 0x200000
	// Bit P21.
	PIO_IFDGSR_P21 = 0x200000
	// Position of P22 field.
	PIO_IFDGSR_P22_Pos = 0x16
	// Bit mask of P22 field.
	PIO_IFDGSR_P22_Msk = 0x400000
	// Bit P22.
	PIO_IFDGSR_P22 = 0x400000
	// Position of P23 field.
	PIO_IFDGSR_P23_Pos = 0x17
	// Bit mask of P23 field.
	PIO_IFDGSR_P23_Msk = 0x800000
	// Bit P23.
	PIO_IFDGSR_P23 = 0x800000
	// Position of P24 field.
	PIO_IFDGSR_P24_Pos = 0x18
	// Bit mask of P24 field.
	PIO_IFDGSR_P24_Msk = 0x1000000
	// Bit P24.
	PIO_IFDGSR_P24 = 0x1000000
	// Position of P25 field.
	PIO_IFDGSR_P25_Pos = 0x19
	// Bit mask of P25 field.
	PIO_IFDGSR_P25_Msk = 0x2000000
	// Bit P25.
	PIO_IFDGSR_P25 = 0x2000000
	// Position of P26 field.
	PIO_IFDGSR_P26_Pos = 0x1a
	// Bit mask of P26 field.
	PIO_IFDGSR_P26_Msk = 0x4000000
	// Bit P26.
	PIO_IFDGSR_P26 = 0x4000000
	// Position of P27 field.
	PIO_IFDGSR_P27_Pos = 0x1b
	// Bit mask of P27 field.
	PIO_IFDGSR_P27_Msk = 0x8000000
	// Bit P27.
	PIO_IFDGSR_P27 = 0x8000000
	// Position of P28 field.
	PIO_IFDGSR_P28_Pos = 0x1c
	// Bit mask of P28 field.
	PIO_IFDGSR_P28_Msk = 0x10000000
	// Bit P28.
	PIO_IFDGSR_P28 = 0x10000000
	// Position of P29 field.
	PIO_IFDGSR_P29_Pos = 0x1d
	// Bit mask of P29 field.
	PIO_IFDGSR_P29_Msk = 0x20000000
	// Bit P29.
	PIO_IFDGSR_P29 = 0x20000000
	// Position of P30 field.
	PIO_IFDGSR_P30_Pos = 0x1e
	// Bit mask of P30 field.
	PIO_IFDGSR_P30_Msk = 0x40000000
	// Bit P30.
	PIO_IFDGSR_P30 = 0x40000000
	// Position of P31 field.
	PIO_IFDGSR_P31_Pos = 0x1f
	// Bit mask of P31 field.
	PIO_IFDGSR_P31_Msk = 0x80000000
	// Bit P31.
	PIO_IFDGSR_P31 = 0x80000000

	// SCDR: Slow Clock Divider Debouncing Register
	// Position of DIV field.
	PIO_SCDR_DIV_Pos = 0x0
	// Bit mask of DIV field.
	PIO_SCDR_DIV_Msk = 0x3fff

	// OWER: Output Write Enable
	// Position of P0 field.
	PIO_OWER_P0_Pos = 0x0
	// Bit mask of P0 field.
	PIO_OWER_P0_Msk = 0x1
	// Bit P0.
	PIO_OWER_P0 = 0x1
	// Position of P1 field.
	PIO_OWER_P1_Pos = 0x1
	// Bit mask of P1 field.
	PIO_OWER_P1_Msk = 0x2
	// Bit P1.
	PIO_OWER_P1 = 0x2
	// Position of P2 field.
	PIO_OWER_P2_Pos = 0x2
	// Bit mask of P2 field.
	PIO_OWER_P2_Msk = 0x4
	// Bit P2.
	PIO_OWER_P2 = 0x4
	// Position of P3 field.
	PIO_OWER_P3_Pos = 0x3
	// Bit mask of P3 field.
	PIO_OWER_P3_Msk = 0x8
	// Bit P3.
	PIO_OWER_P3 = 0x8
	// Position of P4 field.
	PIO_OWER_P4_Pos = 0x4
	// Bit mask of P4 field.
	PIO_OWER_P4_Msk = 0x10
	// Bit P4.
	PIO_OWER_P4 = 0x10
	// Position of P5 field.
	PIO_OWER_P5_Pos = 0x5
	// Bit mask of P5 field.
	PIO_OWER_P5_Msk = 0x20
	// Bit P5.
	PIO_OWER_P5 = 0x20
	// Position of P6 field.
	PIO_OWER_P6_Pos = 0x6
	// Bit mask of P6 field.
	PIO_OWER_P6_Msk = 0x40
	// Bit P6.
	PIO_OWER_P6 = 0x40
	// Position of P7 field.
	PIO_OWER_P7_Pos = 0x7
	// Bit mask of P7 field.
	PIO_OWER_P7_Msk = 0x80
	// Bit P7.
	PIO_OWER_P7 = 0x80
	// Position of P8 field.
	PIO_OWER_P8_Pos = 0x8
	// Bit mask of P8 field.
	PIO_OWER_P8_Msk = 0x100
	// Bit P8.
	PIO_OWER_P8 = 0x100
	// Position of P9 field.
	PIO_OWER_P9_Pos = 0x9
	// Bit mask of P9 field.
	PIO_OWER_P9_Msk = 0x200
	// Bit P9.
	PIO_OWER_P9 = 0x200
	// Position of P10 field.
	PIO_OWER_P10_Pos = 0xa
	// Bit mask of P10 field.
	PIO_OWER_P10_Msk = 0x400
	// Bit P10.
	PIO_OWER_P10 = 0x400
	// Position of P11 field.
	PIO_OWER_P11_Pos = 0xb
	// Bit mask of P11 field.
	PIO_OWER_P11_Msk = 0x800
	// Bit P11.
	PIO_OWER_P11 = 0x800
	// Position of P12 field.
	PIO_OWER_P12_Pos = 0xc
	// Bit mask of P12 field.
	PIO_OWER_P12_Msk = 0x1000
	// Bit P12.
	PIO_OWER_P12 = 0x1000
	// Position of P13 field.
	PIO_OWER_P13_Pos = 0xd
	// Bit mask of P13 field.
	PIO_OWER_P13_Msk = 0x2000
	// Bit P13.
	PIO_OWER_P13 = 0x2000
	// Position of P14 field.
	PIO_OWER_P14_Pos = 0xe
	// Bit mask of P14 field.
	PIO_OWER_P14_Msk = 0x4000
	// Bit P14.
	PIO_OWER_P14 = 0x4000
	// Position of P15 field.
	PIO_OWER_P15_Pos = 0xf
	// Bit mask of P15 field.
	PIO_OWER_P15_Msk = 0x8000
	// Bit P15.
	PIO_OWER_P15 = 0x8000
	// Position of P16 field.
	PIO_OWER_P16_Pos = 0x10
	// Bit mask of P16 field.
	PIO_OWER_P16_Msk = 0x10000
	// Bit P16.
	PIO_OWER_P16 = 0x10000
	// Position of P17 field.
	PIO_OWER_P17_Pos = 0x11
	// Bit mask of P17 field.
	PIO_OWER_P17_Msk = 0x20000
	// Bit P17.
	PIO_OWER_P17 = 0x20000
	// Position of P18 field.
	PIO_OWER_P18_Pos = 0x12
	// Bit mask of P18 field.
	PIO_OWER_P18_Msk = 0x40000
	// Bit P18.
	PIO_OWER_P18 = 0x40000
	// Position of P19 field.
	PIO_OWER_P19_Pos = 0x13
	// Bit mask of P19 field.
	PIO_OWER_P19_Msk = 0x80000
	// Bit P19.
	PIO_OWER_P19 = 0x80000
	// Position of P20 field.
	PIO_OWER_P20_Pos = 0x14
	// Bit mask of P20 field.
	PIO_OWER_P20_Msk = 0x100000
	// Bit P20.
	PIO_OWER_P20 = 0x100000
	// Position of P21 field.
	PIO_OWER_P21_Pos = 0x15
	// Bit mask of P21 field.
	PIO_OWER_P21_Msk = 0x200000
	// Bit P21.
	PIO_OWER_P21 = 0x200000
	// Position of P22 field.
	PIO_OWER_P22_Pos = 0x16
	// Bit mask of P22 field.
	PIO_OWER_P22_Msk = 0x400000
	// Bit P22.
	PIO_OWER_P22 = 0x400000
	// Position of P23 field.
	PIO_OWER_P23_Pos = 0x17
	// Bit mask of P23 field.
	PIO_OWER_P23_Msk = 0x800000
	// Bit P23.
	PIO_OWER_P23 = 0x800000
	// Position of P24 field.
	PIO_OWER_P24_Pos = 0x18
	// Bit mask of P24 field.
	PIO_OWER_P24_Msk = 0x1000000
	// Bit P24.
	PIO_OWER_P24 = 0x1000000
	// Position of P25 field.
	PIO_OWER_P25_Pos = 0x19
	// Bit mask of P25 field.
	PIO_OWER_P25_Msk = 0x2000000
	// Bit P25.
	PIO_OWER_P25 = 0x2000000
	// Position of P26 field.
	PIO_OWER_P26_Pos = 0x1a
	// Bit mask of P26 field.
	PIO_OWER_P26_Msk = 0x4000000
	// Bit P26.
	PIO_OWER_P26 = 0x4000000
	// Position of P27 field.
	PIO_OWER_P27_Pos = 0x1b
	// Bit mask of P27 field.
	PIO_OWER_P27_Msk = 0x8000000
	// Bit P27.
	PIO_OWER_P27 = 0x8000000
	// Position of P28 field.
	PIO_OWER_P28_Pos = 0x1c
	// Bit mask of P28 field.
	PIO_OWER_P28_Msk = 0x10000000
	// Bit P28.
	PIO_OWER_P28 = 0x10000000
	// Position of P29 field.
	PIO_OWER_P29_Pos = 0x1d
	// Bit mask of P29 field.
	PIO_OWER_P29_Msk = 0x20000000
	// Bit P29.
	PIO_OWER_P29 = 0x20000000
	// Position of P30 field.
	PIO_OWER_P30_Pos = 0x1e
	// Bit mask of P30 field.
	PIO_OWER_P30_Msk = 0x40000000
	// Bit P30.
	PIO_OWER_P30 = 0x40000000
	// Position of P31 field.
	PIO_OWER_P31_Pos = 0x1f
	// Bit mask of P31 field.
	PIO_OWER_P31_Msk = 0x80000000
	// Bit P31.
	PIO_OWER_P31 = 0x80000000

	// OWDR: Output Write Disable
	// Position of P0 field.
	PIO_OWDR_P0_Pos = 0x0
	// Bit mask of P0 field.
	PIO_OWDR_P0_Msk = 0x1
	// Bit P0.
	PIO_OWDR_P0 = 0x1
	// Position of P1 field.
	PIO_OWDR_P1_Pos = 0x1
	// Bit mask of P1 field.
	PIO_OWDR_P1_Msk = 0x2
	// Bit P1.
	PIO_OWDR_P1 = 0x2
	// Position of P2 field.
	PIO_OWDR_P2_Pos = 0x2
	// Bit mask of P2 field.
	PIO_OWDR_P2_Msk = 0x4
	// Bit P2.
	PIO_OWDR_P2 = 0x4
	// Position of P3 field.
	PIO_OWDR_P3_Pos = 0x3
	// Bit mask of P3 field.
	PIO_OWDR_P3_Msk = 0x8
	// Bit P3.
	PIO_OWDR_P3 = 0x8
	// Position of P4 field.
	PIO_OWDR_P4_Pos = 0x4
	// Bit mask of P4 field.
	PIO_OWDR_P4_Msk = 0x10
	// Bit P4.
	PIO_OWDR_P4 = 0x10
	// Position of P5 field.
	PIO_OWDR_P5_Pos = 0x5
	// Bit mask of P5 field.
	PIO_OWDR_P5_Msk = 0x20
	// Bit P5.
	PIO_OWDR_P5 = 0x20
	// Position of P6 field.
	PIO_OWDR_P6_Pos = 0x6
	// Bit mask of P6 field.
	PIO_OWDR_P6_Msk = 0x40
	// Bit P6.
	PIO_OWDR_P6 = 0x40
	// Position of P7 field.
	PIO_OWDR_P7_Pos = 0x7
	// Bit mask of P7 field.
	PIO_OWDR_P7_Msk = 0x80
	// Bit P7.
	PIO_OWDR_P7 = 0x80
	// Position of P8 field.
	PIO_OWDR_P8_Pos = 0x8
	// Bit mask of P8 field.
	PIO_OWDR_P8_Msk = 0x100
	// Bit P8.
	PIO_OWDR_P8 = 0x100
	// Position of P9 field.
	PIO_OWDR_P9_Pos = 0x9
	// Bit mask of P9 field.
	PIO_OWDR_P9_Msk = 0x200
	// Bit P9.
	PIO_OWDR_P9 = 0x200
	// Position of P10 field.
	PIO_OWDR_P10_Pos = 0xa
	// Bit mask of P10 field.
	PIO_OWDR_P10_Msk = 0x400
	// Bit P10.
	PIO_OWDR_P10 = 0x400
	// Position of P11 field.
	PIO_OWDR_P11_Pos = 0xb
	// Bit mask of P11 field.
	PIO_OWDR_P11_Msk = 0x800
	// Bit P11.
	PIO_OWDR_P11 = 0x800
	// Position of P12 field.
	PIO_OWDR_P12_Pos = 0xc
	// Bit mask of P12 field.
	PIO_OWDR_P12_Msk = 0x1000
	// Bit P12.
	PIO_OWDR_P12 = 0x1000
	// Position of P13 field.
	PIO_OWDR_P13_Pos = 0xd
	// Bit mask of P13 field.
	PIO_OWDR_P13_Msk = 0x2000
	// Bit P13.
	PIO_OWDR_P13 = 0x2000
	// Position of P14 field.
	PIO_OWDR_P14_Pos = 0xe
	// Bit mask of P14 field.
	PIO_OWDR_P14_Msk = 0x4000
	// Bit P14.
	PIO_OWDR_P14 = 0x4000
	// Position of P15 field.
	PIO_OWDR_P15_Pos = 0xf
	// Bit mask of P15 field.
	PIO_OWDR_P15_Msk = 0x8000
	// Bit P15.
	PIO_OWDR_P15 = 0x8000
	// Position of P16 field.
	PIO_OWDR_P16_Pos = 0x10
	// Bit mask of P16 field.
	PIO_OWDR_P16_Msk = 0x10000
	// Bit P16.
	PIO_OWDR_P16 = 0x10000
	// Position of P17 field.
	PIO_OWDR_P17_Pos = 0x11
	// Bit mask of P17 field.
	PIO_OWDR_P17_Msk = 0x20000
	// Bit P17.
	PIO_OWDR_P17 = 0x20000
	// Position of P18 field.
	PIO_OWDR_P18_Pos = 0x12
	// Bit mask of P18 field.
	PIO_OWDR_P18_Msk = 0x40000
	// Bit P18.
	PIO_OWDR_P18 = 0x40000
	// Position of P19 field.
	PIO_OWDR_P19_Pos = 0x13
	// Bit mask of P19 field.
	PIO_OWDR_P19_Msk = 0x80000
	// Bit P19.
	PIO_OWDR_P19 = 0x80000
	// Position of P20 field.
	PIO_OWDR_P20_Pos = 0x14
	// Bit mask of P20 field.
	PIO_OWDR_P20_Msk = 0x100000
	// Bit P20.
	PIO_OWDR_P20 = 0x100000
	// Position of P21 field.
	PIO_OWDR_P21_Pos = 0x15
	// Bit mask of P21 field.
	PIO_OWDR_P21_Msk = 0x200000
	// Bit P21.
	PIO_OWDR_P21 = 0x200000
	// Position of P22 field.
	PIO_OWDR_P22_Pos = 0x16
	// Bit mask of P22 field.
	PIO_OWDR_P22_Msk = 0x400000
	// Bit P22.
	PIO_OWDR_P22 = 0x400000
	// Position of P23 field.
	PIO_OWDR_P23_Pos = 0x17
	// Bit mask of P23 field.
	PIO_OWDR_P23_Msk = 0x800000
	// Bit P23.
	PIO_OWDR_P23 = 0x800000
	// Position of P24 field.
	PIO_OWDR_P24_Pos = 0x18
	// Bit mask of P24 field.
	PIO_OWDR_P24_Msk = 0x1000000
	// Bit P24.
	PIO_OWDR_P24 = 0x1000000
	// Position of P25 field.
	PIO_OWDR_P25_Pos = 0x19
	// Bit mask of P25 field.
	PIO_OWDR_P25_Msk = 0x2000000
	// Bit P25.
	PIO_OWDR_P25 = 0x2000000
	// Position of P26 field.
	PIO_OWDR_P26_Pos = 0x1a
	// Bit mask of P26 field.
	PIO_OWDR_P26_Msk = 0x4000000
	// Bit P26.
	PIO_OWDR_P26 = 0x4000000
	// Position of P27 field.
	PIO_OWDR_P27_Pos = 0x1b
	// Bit mask of P27 field.
	PIO_OWDR_P27_Msk = 0x8000000
	// Bit P27.
	PIO_OWDR_P27 = 0x8000000
	// Position of P28 field.
	PIO_OWDR_P28_Pos = 0x1c
	// Bit mask of P28 field.
	PIO_OWDR_P28_Msk = 0x10000000
	// Bit P28.
	PIO_OWDR_P28 = 0x10000000
	// Position of P29 field.
	PIO_OWDR_P29_Pos = 0x1d
	// Bit mask of P29 field.
	PIO_OWDR_P29_Msk = 0x20000000
	// Bit P29.
	PIO_OWDR_P29 = 0x20000000
	// Position of P30 field.
	PIO_OWDR_P30_Pos = 0x1e
	// Bit mask of P30 field.
	PIO_OWDR_P30_Msk = 0x40000000
	// Bit P30.
	PIO_OWDR_P30 = 0x40000000
	// Position of P31 field.
	PIO_OWDR_P31_Pos = 0x1f
	// Bit mask of P31 field.
	PIO_OWDR_P31_Msk = 0x80000000
	// Bit P31.
	PIO_OWDR_P31 = 0x80000000

	// OWSR: Output Write Status Register
	// Position of P0 field.
	PIO_OWSR_P0_Pos = 0x0
	// Bit mask of P0 field.
	PIO_OWSR_P0_Msk = 0x1
	// Bit P0.
	PIO_OWSR_P0 = 0x1
	// Position of P1 field.
	PIO_OWSR_P1_Pos = 0x1
	// Bit mask of P1 field.
	PIO_OWSR_P1_Msk = 0x2
	// Bit P1.
	PIO_OWSR_P1 = 0x2
	// Position of P2 field.
	PIO_OWSR_P2_Pos = 0x2
	// Bit mask of P2 field.
	PIO_OWSR_P2_Msk = 0x4
	// Bit P2.
	PIO_OWSR_P2 = 0x4
	// Position of P3 field.
	PIO_OWSR_P3_Pos = 0x3
	// Bit mask of P3 field.
	PIO_OWSR_P3_Msk = 0x8
	// Bit P3.
	PIO_OWSR_P3 = 0x8
	// Position of P4 field.
	PIO_OWSR_P4_Pos = 0x4
	// Bit mask of P4 field.
	PIO_OWSR_P4_Msk = 0x10
	// Bit P4.
	PIO_OWSR_P4 = 0x10
	// Position of P5 field.
	PIO_OWSR_P5_Pos = 0x5
	// Bit mask of P5 field.
	PIO_OWSR_P5_Msk = 0x20
	// Bit P5.
	PIO_OWSR_P5 = 0x20
	// Position of P6 field.
	PIO_OWSR_P6_Pos = 0x6
	// Bit mask of P6 field.
	PIO_OWSR_P6_Msk = 0x40
	// Bit P6.
	PIO_OWSR_P6 = 0x40
	// Position of P7 field.
	PIO_OWSR_P7_Pos = 0x7
	// Bit mask of P7 field.
	PIO_OWSR_P7_Msk = 0x80
	// Bit P7.
	PIO_OWSR_P7 = 0x80
	// Position of P8 field.
	PIO_OWSR_P8_Pos = 0x8
	// Bit mask of P8 field.
	PIO_OWSR_P8_Msk = 0x100
	// Bit P8.
	PIO_OWSR_P8 = 0x100
	// Position of P9 field.
	PIO_OWSR_P9_Pos = 0x9
	// Bit mask of P9 field.
	PIO_OWSR_P9_Msk = 0x200
	// Bit P9.
	PIO_OWSR_P9 = 0x200
	// Position of P10 field.
	PIO_OWSR_P10_Pos = 0xa
	// Bit mask of P10 field.
	PIO_OWSR_P10_Msk = 0x400
	// Bit P10.
	PIO_OWSR_P10 = 0x400
	// Position of P11 field.
	PIO_OWSR_P11_Pos = 0xb
	// Bit mask of P11 field.
	PIO_OWSR_P11_Msk = 0x800
	// Bit P11.
	PIO_OWSR_P11 = 0x800
	// Position of P12 field.
	PIO_OWSR_P12_Pos = 0xc
	// Bit mask of P12 field.
	PIO_OWSR_P12_Msk = 0x1000
	// Bit P12.
	PIO_OWSR_P12 = 0x1000
	// Position of P13 field.
	PIO_OWSR_P13_Pos = 0xd
	// Bit mask of P13 field.
	PIO_OWSR_P13_Msk = 0x2000
	// Bit P13.
	PIO_OWSR_P13 = 0x2000
	// Position of P14 field.
	PIO_OWSR_P14_Pos = 0xe
	// Bit mask of P14 field.
	PIO_OWSR_P14_Msk = 0x4000
	// Bit P14.
	PIO_OWSR_P14 = 0x4000
	// Position of P15 field.
	PIO_OWSR_P15_Pos = 0xf
	// Bit mask of P15 field.
	PIO_OWSR_P15_Msk = 0x8000
	// Bit P15.
	PIO_OWSR_P15 = 0x8000
	// Position of P16 field.
	PIO_OWSR_P16_Pos = 0x10
	// Bit mask of P16 field.
	PIO_OWSR_P16_Msk = 0x10000
	// Bit P16.
	PIO_OWSR_P16 = 0x10000
	// Position of P17 field.
	PIO_OWSR_P17_Pos = 0x11
	// Bit mask of P17 field.
	PIO_OWSR_P17_Msk = 0x20000
	// Bit P17.
	PIO_OWSR_P17 = 0x20000
	// Position of P18 field.
	PIO_OWSR_P18_Pos = 0x12
	// Bit mask of P18 field.
	PIO_OWSR_P18_Msk = 0x40000
	// Bit P18.
	PIO_OWSR_P18 = 0x40000
	// Position of P19 field.
	PIO_OWSR_P19_Pos = 0x13
	// Bit mask of P19 field.
	PIO_OWSR_P19_Msk = 0x80000
	// Bit P19.
	PIO_OWSR_P19 = 0x80000
	// Position of P20 field.
	PIO_OWSR_P20_Pos = 0x14
	// Bit mask of P20 field.
	PIO_OWSR_P20_Msk = 0x100000
	// Bit P20.
	PIO_OWSR_P20 = 0x100000
	// Position of P21 field.
	PIO_OWSR_P21_Pos = 0x15
	// Bit mask of P21 field.
	PIO_OWSR_P21_Msk = 0x200000
	// Bit P21.
	PIO_OWSR_P21 = 0x200000
	// Position of P22 field.
	PIO_OWSR_P22_Pos = 0x16
	// Bit mask of P22 field.
	PIO_OWSR_P22_Msk = 0x400000
	// Bit P22.
	PIO_OWSR_P22 = 0x400000
	// Position of P23 field.
	PIO_OWSR_P23_Pos = 0x17
	// Bit mask of P23 field.
	PIO_OWSR_P23_Msk = 0x800000
	// Bit P23.
	PIO_OWSR_P23 = 0x800000
	// Position of P24 field.
	PIO_OWSR_P24_Pos = 0x18
	// Bit mask of P24 field.
	PIO_OWSR_P24_Msk = 0x1000000
	// Bit P24.
	PIO_OWSR_P24 = 0x1000000
	// Position of P25 field.
	PIO_OWSR_P25_Pos = 0x19
	// Bit mask of P25 field.
	PIO_OWSR_P25_Msk = 0x2000000
	// Bit P25.
	PIO_OWSR_P25 = 0x2000000
	// Position of P26 field.
	PIO_OWSR_P26_Pos = 0x1a
	// Bit mask of P26 field.
	PIO_OWSR_P26_Msk = 0x4000000
	// Bit P26.
	PIO_OWSR_P26 = 0x4000000
	// Position of P27 field.
	PIO_OWSR_P27_Pos = 0x1b
	// Bit mask of P27 field.
	PIO_OWSR_P27_Msk = 0x8000000
	// Bit P27.
	PIO_OWSR_P27 = 0x8000000
	// Position of P28 field.
	PIO_OWSR_P28_Pos = 0x1c
	// Bit mask of P28 field.
	PIO_OWSR_P28_Msk = 0x10000000
	// Bit P28.
	PIO_OWSR_P28 = 0x10000000
	// Position of P29 field.
	PIO_OWSR_P29_Pos = 0x1d
	// Bit mask of P29 field.
	PIO_OWSR_P29_Msk = 0x20000000
	// Bit P29.
	PIO_OWSR_P29 = 0x20000000
	// Position of P30 field.
	PIO_OWSR_P30_Pos = 0x1e
	// Bit mask of P30 field.
	PIO_OWSR_P30_Msk = 0x40000000
	// Bit P30.
	PIO_OWSR_P30 = 0x40000000
	// Position of P31 field.
	PIO_OWSR_P31_Pos = 0x1f
	// Bit mask of P31 field.
	PIO_OWSR_P31_Msk = 0x80000000
	// Bit P31.
	PIO_OWSR_P31 = 0x80000000

	// AIMER: Additional Interrupt Modes Enable Register
	// Position of P0 field.
	PIO_AIMER_P0_Pos = 0x0
	// Bit mask of P0 field.
	PIO_AIMER_P0_Msk = 0x1
	// Bit P0.
	PIO_AIMER_P0 = 0x1
	// Position of P1 field.
	PIO_AIMER_P1_Pos = 0x1
	// Bit mask of P1 field.
	PIO_AIMER_P1_Msk = 0x2
	// Bit P1.
	PIO_AIMER_P1 = 0x2
	// Position of P2 field.
	PIO_AIMER_P2_Pos = 0x2
	// Bit mask of P2 field.
	PIO_AIMER_P2_Msk = 0x4
	// Bit P2.
	PIO_AIMER_P2 = 0x4
	// Position of P3 field.
	PIO_AIMER_P3_Pos = 0x3
	// Bit mask of P3 field.
	PIO_AIMER_P3_Msk = 0x8
	// Bit P3.
	PIO_AIMER_P3 = 0x8
	// Position of P4 field.
	PIO_AIMER_P4_Pos = 0x4
	// Bit mask of P4 field.
	PIO_AIMER_P4_Msk = 0x10
	// Bit P4.
	PIO_AIMER_P4 = 0x10
	// Position of P5 field.
	PIO_AIMER_P5_Pos = 0x5
	// Bit mask of P5 field.
	PIO_AIMER_P5_Msk = 0x20
	// Bit P5.
	PIO_AIMER_P5 = 0x20
	// Position of P6 field.
	PIO_AIMER_P6_Pos = 0x6
	// Bit mask of P6 field.
	PIO_AIMER_P6_Msk = 0x40
	// Bit P6.
	PIO_AIMER_P6 = 0x40
	// Position of P7 field.
	PIO_AIMER_P7_Pos = 0x7
	// Bit mask of P7 field.
	PIO_AIMER_P7_Msk = 0x80
	// Bit P7.
	PIO_AIMER_P7 = 0x80
	// Position of P8 field.
	PIO_AIMER_P8_Pos = 0x8
	// Bit mask of P8 field.
	PIO_AIMER_P8_Msk = 0x100
	// Bit P8.
	PIO_AIMER_P8 = 0x100
	// Position of P9 field.
	PIO_AIMER_P9_Pos = 0x9
	// Bit mask of P9 field.
	PIO_AIMER_P9_Msk = 0x200
	// Bit P9.
	PIO_AIMER_P9 = 0x200
	// Position of P10 field.
	PIO_AIMER_P10_Pos = 0xa
	// Bit mask of P10 field.
	PIO_AIMER_P10_Msk = 0x400
	// Bit P10.
	PIO_AIMER_P10 = 0x400
	// Position of P11 field.
	PIO_AIMER_P11_Pos = 0xb
	// Bit mask of P11 field.
	PIO_AIMER_P11_Msk = 0x800
	// Bit P11.
	PIO_AIMER_P11 = 0x800
	// Position of P12 field.
	PIO_AIMER_P12_Pos = 0xc
	// Bit mask of P12 field.
	PIO_AIMER_P12_Msk = 0x1000
	// Bit P12.
	PIO_AIMER_P12 = 0x1000
	// Position of P13 field.
	PIO_AIMER_P13_Pos = 0xd
	// Bit mask of P13 field.
	PIO_AIMER_P13_Msk = 0x2000
	// Bit P13.
	PIO_AIMER_P13 = 0x2000
	// Position of P14 field.
	PIO_AIMER_P14_Pos = 0xe
	// Bit mask of P14 field.
	PIO_AIMER_P14_Msk = 0x4000
	// Bit P14.
	PIO_AIMER_P14 = 0x4000
	// Position of P15 field.
	PIO_AIMER_P15_Pos = 0xf
	// Bit mask of P15 field.
	PIO_AIMER_P15_Msk = 0x8000
	// Bit P15.
	PIO_AIMER_P15 = 0x8000
	// Position of P16 field.
	PIO_AIMER_P16_Pos = 0x10
	// Bit mask of P16 field.
	PIO_AIMER_P16_Msk = 0x10000
	// Bit P16.
	PIO_AIMER_P16 = 0x10000
	// Position of P17 field.
	PIO_AIMER_P17_Pos = 0x11
	// Bit mask of P17 field.
	PIO_AIMER_P17_Msk = 0x20000
	// Bit P17.
	PIO_AIMER_P17 = 0x20000
	// Position of P18 field.
	PIO_AIMER_P18_Pos = 0x12
	// Bit mask of P18 field.
	PIO_AIMER_P18_Msk = 0x40000
	// Bit P18.
	PIO_AIMER_P18 = 0x40000
	// Position of P19 field.
	PIO_AIMER_P19_Pos = 0x13
	// Bit mask of P19 field.
	PIO_AIMER_P19_Msk = 0x80000
	// Bit P19.
	PIO_AIMER_P19 = 0x80000
	// Position of P20 field.
	PIO_AIMER_P20_Pos = 0x14
	// Bit mask of P20 field.
	PIO_AIMER_P20_Msk = 0x100000
	// Bit P20.
	PIO_AIMER_P20 = 0x100000
	// Position of P21 field.
	PIO_AIMER_P21_Pos = 0x15
	// Bit mask of P21 field.
	PIO_AIMER_P21_Msk = 0x200000
	// Bit P21.
	PIO_AIMER_P21 = 0x200000
	// Position of P22 field.
	PIO_AIMER_P22_Pos = 0x16
	// Bit mask of P22 field.
	PIO_AIMER_P22_Msk = 0x400000
	// Bit P22.
	PIO_AIMER_P22 = 0x400000
	// Position of P23 field.
	PIO_AIMER_P23_Pos = 0x17
	// Bit mask of P23 field.
	PIO_AIMER_P23_Msk = 0x800000
	// Bit P23.
	PIO_AIMER_P23 = 0x800000
	// Position of P24 field.
	PIO_AIMER_P24_Pos = 0x18
	// Bit mask of P24 field.
	PIO_AIMER_P24_Msk = 0x1000000
	// Bit P24.
	PIO_AIMER_P24 = 0x1000000
	// Position of P25 field.
	PIO_AIMER_P25_Pos = 0x19
	// Bit mask of P25 field.
	PIO_AIMER_P25_Msk = 0x2000000
	// Bit P25.
	PIO_AIMER_P25 = 0x2000000
	// Position of P26 field.
	PIO_AIMER_P26_Pos = 0x1a
	// Bit mask of P26 field.
	PIO_AIMER_P26_Msk = 0x4000000
	// Bit P26.
	PIO_AIMER_P26 = 0x4000000
	// Position of P27 field.
	PIO_AIMER_P27_Pos = 0x1b
	// Bit mask of P27 field.
	PIO_AIMER_P27_Msk = 0x8000000
	// Bit P27.
	PIO_AIMER_P27 = 0x8000000
	// Position of P28 field.
	PIO_AIMER_P28_Pos = 0x1c
	// Bit mask of P28 field.
	PIO_AIMER_P28_Msk = 0x10000000
	// Bit P28.
	PIO_AIMER_P28 = 0x10000000
	// Position of P29 field.
	PIO_AIMER_P29_Pos = 0x1d
	// Bit mask of P29 field.
	PIO_AIMER_P29_Msk = 0x20000000
	// Bit P29.
	PIO_AIMER_P29 = 0x20000000
	// Position of P30 field.
	PIO_AIMER_P30_Pos = 0x1e
	// Bit mask of P30 field.
	PIO_AIMER_P30_Msk = 0x40000000
	// Bit P30.
	PIO_AIMER_P30 = 0x40000000
	// Position of P31 field.
	PIO_AIMER_P31_Pos = 0x1f
	// Bit mask of P31 field.
	PIO_AIMER_P31_Msk = 0x80000000
	// Bit P31.
	PIO_AIMER_P31 = 0x80000000

	// AIMDR: Additional Interrupt Modes Disables Register
	// Position of P0 field.
	PIO_AIMDR_P0_Pos = 0x0
	// Bit mask of P0 field.
	PIO_AIMDR_P0_Msk = 0x1
	// Bit P0.
	PIO_AIMDR_P0 = 0x1
	// Position of P1 field.
	PIO_AIMDR_P1_Pos = 0x1
	// Bit mask of P1 field.
	PIO_AIMDR_P1_Msk = 0x2
	// Bit P1.
	PIO_AIMDR_P1 = 0x2
	// Position of P2 field.
	PIO_AIMDR_P2_Pos = 0x2
	// Bit mask of P2 field.
	PIO_AIMDR_P2_Msk = 0x4
	// Bit P2.
	PIO_AIMDR_P2 = 0x4
	// Position of P3 field.
	PIO_AIMDR_P3_Pos = 0x3
	// Bit mask of P3 field.
	PIO_AIMDR_P3_Msk = 0x8
	// Bit P3.
	PIO_AIMDR_P3 = 0x8
	// Position of P4 field.
	PIO_AIMDR_P4_Pos = 0x4
	// Bit mask of P4 field.
	PIO_AIMDR_P4_Msk = 0x10
	// Bit P4.
	PIO_AIMDR_P4 = 0x10
	// Position of P5 field.
	PIO_AIMDR_P5_Pos = 0x5
	// Bit mask of P5 field.
	PIO_AIMDR_P5_Msk = 0x20
	// Bit P5.
	PIO_AIMDR_P5 = 0x20
	// Position of P6 field.
	PIO_AIMDR_P6_Pos = 0x6
	// Bit mask of P6 field.
	PIO_AIMDR_P6_Msk = 0x40
	// Bit P6.
	PIO_AIMDR_P6 = 0x40
	// Position of P7 field.
	PIO_AIMDR_P7_Pos = 0x7
	// Bit mask of P7 field.
	PIO_AIMDR_P7_Msk = 0x80
	// Bit P7.
	PIO_AIMDR_P7 = 0x80
	// Position of P8 field.
	PIO_AIMDR_P8_Pos = 0x8
	// Bit mask of P8 field.
	PIO_AIMDR_P8_Msk = 0x100
	// Bit P8.
	PIO_AIMDR_P8 = 0x100
	// Position of P9 field.
	PIO_AIMDR_P9_Pos = 0x9
	// Bit mask of P9 field.
	PIO_AIMDR_P9_Msk = 0x200
	// Bit P9.
	PIO_AIMDR_P9 = 0x200
	// Position of P10 field.
	PIO_AIMDR_P10_Pos = 0xa
	// Bit mask of P10 field.
	PIO_AIMDR_P10_Msk = 0x400
	// Bit P10.
	PIO_AIMDR_P10 = 0x400
	// Position of P11 field.
	PIO_AIMDR_P11_Pos = 0xb
	// Bit mask of P11 field.
	PIO_AIMDR_P11_Msk = 0x800
	// Bit P11.
	PIO_AIMDR_P11 = 0x800
	// Position of P12 field.
	PIO_AIMDR_P12_Pos = 0xc
	// Bit mask of P12 field.
	PIO_AIMDR_P12_Msk = 0x1000
	// Bit P12.
	PIO_AIMDR_P12 = 0x1000
	// Position of P13 field.
	PIO_AIMDR_P13_Pos = 0xd
	// Bit mask of P13 field.
	PIO_AIMDR_P13_Msk = 0x2000
	// Bit P13.
	PIO_AIMDR_P13 = 0x2000
	// Position of P14 field.
	PIO_AIMDR_P14_Pos = 0xe
	// Bit mask of P14 field.
	PIO_AIMDR_P14_Msk = 0x4000
	// Bit P14.
	PIO_AIMDR_P14 = 0x4000
	// Position of P15 field.
	PIO_AIMDR_P15_Pos = 0xf
	// Bit mask of P15 field.
	PIO_AIMDR_P15_Msk = 0x8000
	// Bit P15.
	PIO_AIMDR_P15 = 0x8000
	// Position of P16 field.
	PIO_AIMDR_P16_Pos = 0x10
	// Bit mask of P16 field.
	PIO_AIMDR_P16_Msk = 0x10000
	// Bit P16.
	PIO_AIMDR_P16 = 0x10000
	// Position of P17 field.
	PIO_AIMDR_P17_Pos = 0x11
	// Bit mask of P17 field.
	PIO_AIMDR_P17_Msk = 0x20000
	// Bit P17.
	PIO_AIMDR_P17 = 0x20000
	// Position of P18 field.
	PIO_AIMDR_P18_Pos = 0x12
	// Bit mask of P18 field.
	PIO_AIMDR_P18_Msk = 0x40000
	// Bit P18.
	PIO_AIMDR_P18 = 0x40000
	// Position of P19 field.
	PIO_AIMDR_P19_Pos = 0x13
	// Bit mask of P19 field.
	PIO_AIMDR_P19_Msk = 0x80000
	// Bit P19.
	PIO_AIMDR_P19 = 0x80000
	// Position of P20 field.
	PIO_AIMDR_P20_Pos = 0x14
	// Bit mask of P20 field.
	PIO_AIMDR_P20_Msk = 0x100000
	// Bit P20.
	PIO_AIMDR_P20 = 0x100000
	// Position of P21 field.
	PIO_AIMDR_P21_Pos = 0x15
	// Bit mask of P21 field.
	PIO_AIMDR_P21_Msk = 0x200000
	// Bit P21.
	PIO_AIMDR_P21 = 0x200000
	// Position of P22 field.
	PIO_AIMDR_P22_Pos = 0x16
	// Bit mask of P22 field.
	PIO_AIMDR_P22_Msk = 0x400000
	// Bit P22.
	PIO_AIMDR_P22 = 0x400000
	// Position of P23 field.
	PIO_AIMDR_P23_Pos = 0x17
	// Bit mask of P23 field.
	PIO_AIMDR_P23_Msk = 0x800000
	// Bit P23.
	PIO_AIMDR_P23 = 0x800000
	// Position of P24 field.
	PIO_AIMDR_P24_Pos = 0x18
	// Bit mask of P24 field.
	PIO_AIMDR_P24_Msk = 0x1000000
	// Bit P24.
	PIO_AIMDR_P24 = 0x1000000
	// Position of P25 field.
	PIO_AIMDR_P25_Pos = 0x19
	// Bit mask of P25 field.
	PIO_AIMDR_P25_Msk = 0x2000000
	// Bit P25.
	PIO_AIMDR_P25 = 0x2000000
	// Position of P26 field.
	PIO_AIMDR_P26_Pos = 0x1a
	// Bit mask of P26 field.
	PIO_AIMDR_P26_Msk = 0x4000000
	// Bit P26.
	PIO_AIMDR_P26 = 0x4000000
	// Position of P27 field.
	PIO_AIMDR_P27_Pos = 0x1b
	// Bit mask of P27 field.
	PIO_AIMDR_P27_Msk = 0x8000000
	// Bit P27.
	PIO_AIMDR_P27 = 0x8000000
	// Position of P28 field.
	PIO_AIMDR_P28_Pos = 0x1c
	// Bit mask of P28 field.
	PIO_AIMDR_P28_Msk = 0x10000000
	// Bit P28.
	PIO_AIMDR_P28 = 0x10000000
	// Position of P29 field.
	PIO_AIMDR_P29_Pos = 0x1d
	// Bit mask of P29 field.
	PIO_AIMDR_P29_Msk = 0x20000000
	// Bit P29.
	PIO_AIMDR_P29 = 0x20000000
	// Position of P30 field.
	PIO_AIMDR_P30_Pos = 0x1e
	// Bit mask of P30 field.
	PIO_AIMDR_P30_Msk = 0x40000000
	// Bit P30.
	PIO_AIMDR_P30 = 0x40000000
	// Position of P31 field.
	PIO_AIMDR_P31_Pos = 0x1f
	// Bit mask of P31 field.
	PIO_AIMDR_P31_Msk = 0x80000000
	// Bit P31.
	PIO_AIMDR_P31 = 0x80000000

	// AIMMR: Additional Interrupt Modes Mask Register
	// Position of P0 field.
	PIO_AIMMR_P0_Pos = 0x0
	// Bit mask of P0 field.
	PIO_AIMMR_P0_Msk = 0x1
	// Bit P0.
	PIO_AIMMR_P0 = 0x1
	// Position of P1 field.
	PIO_AIMMR_P1_Pos = 0x1
	// Bit mask of P1 field.
	PIO_AIMMR_P1_Msk = 0x2
	// Bit P1.
	PIO_AIMMR_P1 = 0x2
	// Position of P2 field.
	PIO_AIMMR_P2_Pos = 0x2
	// Bit mask of P2 field.
	PIO_AIMMR_P2_Msk = 0x4
	// Bit P2.
	PIO_AIMMR_P2 = 0x4
	// Position of P3 field.
	PIO_AIMMR_P3_Pos = 0x3
	// Bit mask of P3 field.
	PIO_AIMMR_P3_Msk = 0x8
	// Bit P3.
	PIO_AIMMR_P3 = 0x8
	// Position of P4 field.
	PIO_AIMMR_P4_Pos = 0x4
	// Bit mask of P4 field.
	PIO_AIMMR_P4_Msk = 0x10
	// Bit P4.
	PIO_AIMMR_P4 = 0x10
	// Position of P5 field.
	PIO_AIMMR_P5_Pos = 0x5
	// Bit mask of P5 field.
	PIO_AIMMR_P5_Msk = 0x20
	// Bit P5.
	PIO_AIMMR_P5 = 0x20
	// Position of P6 field.
	PIO_AIMMR_P6_Pos = 0x6
	// Bit mask of P6 field.
	PIO_AIMMR_P6_Msk = 0x40
	// Bit P6.
	PIO_AIMMR_P6 = 0x40
	// Position of P7 field.
	PIO_AIMMR_P7_Pos = 0x7
	// Bit mask of P7 field.
	PIO_AIMMR_P7_Msk = 0x80
	// Bit P7.
	PIO_AIMMR_P7 = 0x80
	// Position of P8 field.
	PIO_AIMMR_P8_Pos = 0x8
	// Bit mask of P8 field.
	PIO_AIMMR_P8_Msk = 0x100
	// Bit P8.
	PIO_AIMMR_P8 = 0x100
	// Position of P9 field.
	PIO_AIMMR_P9_Pos = 0x9
	// Bit mask of P9 field.
	PIO_AIMMR_P9_Msk = 0x200
	// Bit P9.
	PIO_AIMMR_P9 = 0x200
	// Position of P10 field.
	PIO_AIMMR_P10_Pos = 0xa
	// Bit mask of P10 field.
	PIO_AIMMR_P10_Msk = 0x400
	// Bit P10.
	PIO_AIMMR_P10 = 0x400
	// Position of P11 field.
	PIO_AIMMR_P11_Pos = 0xb
	// Bit mask of P11 field.
	PIO_AIMMR_P11_Msk = 0x800
	// Bit P11.
	PIO_AIMMR_P11 = 0x800
	// Position of P12 field.
	PIO_AIMMR_P12_Pos = 0xc
	// Bit mask of P12 field.
	PIO_AIMMR_P12_Msk = 0x1000
	// Bit P12.
	PIO_AIMMR_P12 = 0x1000
	// Position of P13 field.
	PIO_AIMMR_P13_Pos = 0xd
	// Bit mask of P13 field.
	PIO_AIMMR_P13_Msk = 0x2000
	// Bit P13.
	PIO_AIMMR_P13 = 0x2000
	// Position of P14 field.
	PIO_AIMMR_P14_Pos = 0xe
	// Bit mask of P14 field.
	PIO_AIMMR_P14_Msk = 0x4000
	// Bit P14.
	PIO_AIMMR_P14 = 0x4000
	// Position of P15 field.
	PIO_AIMMR_P15_Pos = 0xf
	// Bit mask of P15 field.
	PIO_AIMMR_P15_Msk = 0x8000
	// Bit P15.
	PIO_AIMMR_P15 = 0x8000
	// Position of P16 field.
	PIO_AIMMR_P16_Pos = 0x10
	// Bit mask of P16 field.
	PIO_AIMMR_P16_Msk = 0x10000
	// Bit P16.
	PIO_AIMMR_P16 = 0x10000
	// Position of P17 field.
	PIO_AIMMR_P17_Pos = 0x11
	// Bit mask of P17 field.
	PIO_AIMMR_P17_Msk = 0x20000
	// Bit P17.
	PIO_AIMMR_P17 = 0x20000
	// Position of P18 field.
	PIO_AIMMR_P18_Pos = 0x12
	// Bit mask of P18 field.
	PIO_AIMMR_P18_Msk = 0x40000
	// Bit P18.
	PIO_AIMMR_P18 = 0x40000
	// Position of P19 field.
	PIO_AIMMR_P19_Pos = 0x13
	// Bit mask of P19 field.
	PIO_AIMMR_P19_Msk = 0x80000
	// Bit P19.
	PIO_AIMMR_P19 = 0x80000
	// Position of P20 field.
	PIO_AIMMR_P20_Pos = 0x14
	// Bit mask of P20 field.
	PIO_AIMMR_P20_Msk = 0x100000
	// Bit P20.
	PIO_AIMMR_P20 = 0x100000
	// Position of P21 field.
	PIO_AIMMR_P21_Pos = 0x15
	// Bit mask of P21 field.
	PIO_AIMMR_P21_Msk = 0x200000
	// Bit P21.
	PIO_AIMMR_P21 = 0x200000
	// Position of P22 field.
	PIO_AIMMR_P22_Pos = 0x16
	// Bit mask of P22 field.
	PIO_AIMMR_P22_Msk = 0x400000
	// Bit P22.
	PIO_AIMMR_P22 = 0x400000
	// Position of P23 field.
	PIO_AIMMR_P23_Pos = 0x17
	// Bit mask of P23 field.
	PIO_AIMMR_P23_Msk = 0x800000
	// Bit P23.
	PIO_AIMMR_P23 = 0x800000
	// Position of P24 field.
	PIO_AIMMR_P24_Pos = 0x18
	// Bit mask of P24 field.
	PIO_AIMMR_P24_Msk = 0x1000000
	// Bit P24.
	PIO_AIMMR_P24 = 0x1000000
	// Position of P25 field.
	PIO_AIMMR_P25_Pos = 0x19
	// Bit mask of P25 field.
	PIO_AIMMR_P25_Msk = 0x2000000
	// Bit P25.
	PIO_AIMMR_P25 = 0x2000000
	// Position of P26 field.
	PIO_AIMMR_P26_Pos = 0x1a
	// Bit mask of P26 field.
	PIO_AIMMR_P26_Msk = 0x4000000
	// Bit P26.
	PIO_AIMMR_P26 = 0x4000000
	// Position of P27 field.
	PIO_AIMMR_P27_Pos = 0x1b
	// Bit mask of P27 field.
	PIO_AIMMR_P27_Msk = 0x8000000
	// Bit P27.
	PIO_AIMMR_P27 = 0x8000000
	// Position of P28 field.
	PIO_AIMMR_P28_Pos = 0x1c
	// Bit mask of P28 field.
	PIO_AIMMR_P28_Msk = 0x10000000
	// Bit P28.
	PIO_AIMMR_P28 = 0x10000000
	// Position of P29 field.
	PIO_AIMMR_P29_Pos = 0x1d
	// Bit mask of P29 field.
	PIO_AIMMR_P29_Msk = 0x20000000
	// Bit P29.
	PIO_AIMMR_P29 = 0x20000000
	// Position of P30 field.
	PIO_AIMMR_P30_Pos = 0x1e
	// Bit mask of P30 field.
	PIO_AIMMR_P30_Msk = 0x40000000
	// Bit P30.
	PIO_AIMMR_P30 = 0x40000000
	// Position of P31 field.
	PIO_AIMMR_P31_Pos = 0x1f
	// Bit mask of P31 field.
	PIO_AIMMR_P31_Msk = 0x80000000
	// Bit P31.
	PIO_AIMMR_P31 = 0x80000000

	// ESR: Edge Select Register
	// Position of P0 field.
	PIO_ESR_P0_Pos = 0x0
	// Bit mask of P0 field.
	PIO_ESR_P0_Msk = 0x1
	// Bit P0.
	PIO_ESR_P0 = 0x1
	// Position of P1 field.
	PIO_ESR_P1_Pos = 0x1
	// Bit mask of P1 field.
	PIO_ESR_P1_Msk = 0x2
	// Bit P1.
	PIO_ESR_P1 = 0x2
	// Position of P2 field.
	PIO_ESR_P2_Pos = 0x2
	// Bit mask of P2 field.
	PIO_ESR_P2_Msk = 0x4
	// Bit P2.
	PIO_ESR_P2 = 0x4
	// Position of P3 field.
	PIO_ESR_P3_Pos = 0x3
	// Bit mask of P3 field.
	PIO_ESR_P3_Msk = 0x8
	// Bit P3.
	PIO_ESR_P3 = 0x8
	// Position of P4 field.
	PIO_ESR_P4_Pos = 0x4
	// Bit mask of P4 field.
	PIO_ESR_P4_Msk = 0x10
	// Bit P4.
	PIO_ESR_P4 = 0x10
	// Position of P5 field.
	PIO_ESR_P5_Pos = 0x5
	// Bit mask of P5 field.
	PIO_ESR_P5_Msk = 0x20
	// Bit P5.
	PIO_ESR_P5 = 0x20
	// Position of P6 field.
	PIO_ESR_P6_Pos = 0x6
	// Bit mask of P6 field.
	PIO_ESR_P6_Msk = 0x40
	// Bit P6.
	PIO_ESR_P6 = 0x40
	// Position of P7 field.
	PIO_ESR_P7_Pos = 0x7
	// Bit mask of P7 field.
	PIO_ESR_P7_Msk = 0x80
	// Bit P7.
	PIO_ESR_P7 = 0x80
	// Position of P8 field.
	PIO_ESR_P8_Pos = 0x8
	// Bit mask of P8 field.
	PIO_ESR_P8_Msk = 0x100
	// Bit P8.
	PIO_ESR_P8 = 0x100
	// Position of P9 field.
	PIO_ESR_P9_Pos = 0x9
	// Bit mask of P9 field.
	PIO_ESR_P9_Msk = 0x200
	// Bit P9.
	PIO_ESR_P9 = 0x200
	// Position of P10 field.
	PIO_ESR_P10_Pos = 0xa
	// Bit mask of P10 field.
	PIO_ESR_P10_Msk = 0x400
	// Bit P10.
	PIO_ESR_P10 = 0x400
	// Position of P11 field.
	PIO_ESR_P11_Pos = 0xb
	// Bit mask of P11 field.
	PIO_ESR_P11_Msk = 0x800
	// Bit P11.
	PIO_ESR_P11 = 0x800
	// Position of P12 field.
	PIO_ESR_P12_Pos = 0xc
	// Bit mask of P12 field.
	PIO_ESR_P12_Msk = 0x1000
	// Bit P12.
	PIO_ESR_P12 = 0x1000
	// Position of P13 field.
	PIO_ESR_P13_Pos = 0xd
	// Bit mask of P13 field.
	PIO_ESR_P13_Msk = 0x2000
	// Bit P13.
	PIO_ESR_P13 = 0x2000
	// Position of P14 field.
	PIO_ESR_P14_Pos = 0xe
	// Bit mask of P14 field.
	PIO_ESR_P14_Msk = 0x4000
	// Bit P14.
	PIO_ESR_P14 = 0x4000
	// Position of P15 field.
	PIO_ESR_P15_Pos = 0xf
	// Bit mask of P15 field.
	PIO_ESR_P15_Msk = 0x8000
	// Bit P15.
	PIO_ESR_P15 = 0x8000
	// Position of P16 field.
	PIO_ESR_P16_Pos = 0x10
	// Bit mask of P16 field.
	PIO_ESR_P16_Msk = 0x10000
	// Bit P16.
	PIO_ESR_P16 = 0x10000
	// Position of P17 field.
	PIO_ESR_P17_Pos = 0x11
	// Bit mask of P17 field.
	PIO_ESR_P17_Msk = 0x20000
	// Bit P17.
	PIO_ESR_P17 = 0x20000
	// Position of P18 field.
	PIO_ESR_P18_Pos = 0x12
	// Bit mask of P18 field.
	PIO_ESR_P18_Msk = 0x40000
	// Bit P18.
	PIO_ESR_P18 = 0x40000
	// Position of P19 field.
	PIO_ESR_P19_Pos = 0x13
	// Bit mask of P19 field.
	PIO_ESR_P19_Msk = 0x80000
	// Bit P19.
	PIO_ESR_P19 = 0x80000
	// Position of P20 field.
	PIO_ESR_P20_Pos = 0x14
	// Bit mask of P20 field.
	PIO_ESR_P20_Msk = 0x100000
	// Bit P20.
	PIO_ESR_P20 = 0x100000
	// Position of P21 field.
	PIO_ESR_P21_Pos = 0x15
	// Bit mask of P21 field.
	PIO_ESR_P21_Msk = 0x200000
	// Bit P21.
	PIO_ESR_P21 = 0x200000
	// Position of P22 field.
	PIO_ESR_P22_Pos = 0x16
	// Bit mask of P22 field.
	PIO_ESR_P22_Msk = 0x400000
	// Bit P22.
	PIO_ESR_P22 = 0x400000
	// Position of P23 field.
	PIO_ESR_P23_Pos = 0x17
	// Bit mask of P23 field.
	PIO_ESR_P23_Msk = 0x800000
	// Bit P23.
	PIO_ESR_P23 = 0x800000
	// Position of P24 field.
	PIO_ESR_P24_Pos = 0x18
	// Bit mask of P24 field.
	PIO_ESR_P24_Msk = 0x1000000
	// Bit P24.
	PIO_ESR_P24 = 0x1000000
	// Position of P25 field.
	PIO_ESR_P25_Pos = 0x19
	// Bit mask of P25 field.
	PIO_ESR_P25_Msk = 0x2000000
	// Bit P25.
	PIO_ESR_P25 = 0x2000000
	// Position of P26 field.
	PIO_ESR_P26_Pos = 0x1a
	// Bit mask of P26 field.
	PIO_ESR_P26_Msk = 0x4000000
	// Bit P26.
	PIO_ESR_P26 = 0x4000000
	// Position of P27 field.
	PIO_ESR_P27_Pos = 0x1b
	// Bit mask of P27 field.
	PIO_ESR_P27_Msk = 0x8000000
	// Bit P27.
	PIO_ESR_P27 = 0x8000000
	// Position of P28 field.
	PIO_ESR_P28_Pos = 0x1c
	// Bit mask of P28 field.
	PIO_ESR_P28_Msk = 0x10000000
	// Bit P28.
	PIO_ESR_P28 = 0x10000000
	// Position of P29 field.
	PIO_ESR_P29_Pos = 0x1d
	// Bit mask of P29 field.
	PIO_ESR_P29_Msk = 0x20000000
	// Bit P29.
	PIO_ESR_P29 = 0x20000000
	// Position of P30 field.
	PIO_ESR_P30_Pos = 0x1e
	// Bit mask of P30 field.
	PIO_ESR_P30_Msk = 0x40000000
	// Bit P30.
	PIO_ESR_P30 = 0x40000000
	// Position of P31 field.
	PIO_ESR_P31_Pos = 0x1f
	// Bit mask of P31 field.
	PIO_ESR_P31_Msk = 0x80000000
	// Bit P31.
	PIO_ESR_P31 = 0x80000000

	// LSR: Level Select Register
	// Position of P0 field.
	PIO_LSR_P0_Pos = 0x0
	// Bit mask of P0 field.
	PIO_LSR_P0_Msk = 0x1
	// Bit P0.
	PIO_LSR_P0 = 0x1
	// Position of P1 field.
	PIO_LSR_P1_Pos = 0x1
	// Bit mask of P1 field.
	PIO_LSR_P1_Msk = 0x2
	// Bit P1.
	PIO_LSR_P1 = 0x2
	// Position of P2 field.
	PIO_LSR_P2_Pos = 0x2
	// Bit mask of P2 field.
	PIO_LSR_P2_Msk = 0x4
	// Bit P2.
	PIO_LSR_P2 = 0x4
	// Position of P3 field.
	PIO_LSR_P3_Pos = 0x3
	// Bit mask of P3 field.
	PIO_LSR_P3_Msk = 0x8
	// Bit P3.
	PIO_LSR_P3 = 0x8
	// Position of P4 field.
	PIO_LSR_P4_Pos = 0x4
	// Bit mask of P4 field.
	PIO_LSR_P4_Msk = 0x10
	// Bit P4.
	PIO_LSR_P4 = 0x10
	// Position of P5 field.
	PIO_LSR_P5_Pos = 0x5
	// Bit mask of P5 field.
	PIO_LSR_P5_Msk = 0x20
	// Bit P5.
	PIO_LSR_P5 = 0x20
	// Position of P6 field.
	PIO_LSR_P6_Pos = 0x6
	// Bit mask of P6 field.
	PIO_LSR_P6_Msk = 0x40
	// Bit P6.
	PIO_LSR_P6 = 0x40
	// Position of P7 field.
	PIO_LSR_P7_Pos = 0x7
	// Bit mask of P7 field.
	PIO_LSR_P7_Msk = 0x80
	// Bit P7.
	PIO_LSR_P7 = 0x80
	// Position of P8 field.
	PIO_LSR_P8_Pos = 0x8
	// Bit mask of P8 field.
	PIO_LSR_P8_Msk = 0x100
	// Bit P8.
	PIO_LSR_P8 = 0x100
	// Position of P9 field.
	PIO_LSR_P9_Pos = 0x9
	// Bit mask of P9 field.
	PIO_LSR_P9_Msk = 0x200
	// Bit P9.
	PIO_LSR_P9 = 0x200
	// Position of P10 field.
	PIO_LSR_P10_Pos = 0xa
	// Bit mask of P10 field.
	PIO_LSR_P10_Msk = 0x400
	// Bit P10.
	PIO_LSR_P10 = 0x400
	// Position of P11 field.
	PIO_LSR_P11_Pos = 0xb
	// Bit mask of P11 field.
	PIO_LSR_P11_Msk = 0x800
	// Bit P11.
	PIO_LSR_P11 = 0x800
	// Position of P12 field.
	PIO_LSR_P12_Pos = 0xc
	// Bit mask of P12 field.
	PIO_LSR_P12_Msk = 0x1000
	// Bit P12.
	PIO_LSR_P12 = 0x1000
	// Position of P13 field.
	PIO_LSR_P13_Pos = 0xd
	// Bit mask of P13 field.
	PIO_LSR_P13_Msk = 0x2000
	// Bit P13.
	PIO_LSR_P13 = 0x2000
	// Position of P14 field.
	PIO_LSR_P14_Pos = 0xe
	// Bit mask of P14 field.
	PIO_LSR_P14_Msk = 0x4000
	// Bit P14.
	PIO_LSR_P14 = 0x4000
	// Position of P15 field.
	PIO_LSR_P15_Pos = 0xf
	// Bit mask of P15 field.
	PIO_LSR_P15_Msk = 0x8000
	// Bit P15.
	PIO_LSR_P15 = 0x8000
	// Position of P16 field.
	PIO_LSR_P16_Pos = 0x10
	// Bit mask of P16 field.
	PIO_LSR_P16_Msk = 0x10000
	// Bit P16.
	PIO_LSR_P16 = 0x10000
	// Position of P17 field.
	PIO_LSR_P17_Pos = 0x11
	// Bit mask of P17 field.
	PIO_LSR_P17_Msk = 0x20000
	// Bit P17.
	PIO_LSR_P17 = 0x20000
	// Position of P18 field.
	PIO_LSR_P18_Pos = 0x12
	// Bit mask of P18 field.
	PIO_LSR_P18_Msk = 0x40000
	// Bit P18.
	PIO_LSR_P18 = 0x40000
	// Position of P19 field.
	PIO_LSR_P19_Pos = 0x13
	// Bit mask of P19 field.
	PIO_LSR_P19_Msk = 0x80000
	// Bit P19.
	PIO_LSR_P19 = 0x80000
	// Position of P20 field.
	PIO_LSR_P20_Pos = 0x14
	// Bit mask of P20 field.
	PIO_LSR_P20_Msk = 0x100000
	// Bit P20.
	PIO_LSR_P20 = 0x100000
	// Position of P21 field.
	PIO_LSR_P21_Pos = 0x15
	// Bit mask of P21 field.
	PIO_LSR_P21_Msk = 0x200000
	// Bit P21.
	PIO_LSR_P21 = 0x200000
	// Position of P22 field.
	PIO_LSR_P22_Pos = 0x16
	// Bit mask of P22 field.
	PIO_LSR_P22_Msk = 0x400000
	// Bit P22.
	PIO_LSR_P22 = 0x400000
	// Position of P23 field.
	PIO_LSR_P23_Pos = 0x17
	// Bit mask of P23 field.
	PIO_LSR_P23_Msk = 0x800000
	// Bit P23.
	PIO_LSR_P23 = 0x800000
	// Position of P24 field.
	PIO_LSR_P24_Pos = 0x18
	// Bit mask of P24 field.
	PIO_LSR_P24_Msk = 0x1000000
	// Bit P24.
	PIO_LSR_P24 = 0x1000000
	// Position of P25 field.
	PIO_LSR_P25_Pos = 0x19
	// Bit mask of P25 field.
	PIO_LSR_P25_Msk = 0x2000000
	// Bit P25.
	PIO_LSR_P25 = 0x2000000
	// Position of P26 field.
	PIO_LSR_P26_Pos = 0x1a
	// Bit mask of P26 field.
	PIO_LSR_P26_Msk = 0x4000000
	// Bit P26.
	PIO_LSR_P26 = 0x4000000
	// Position of P27 field.
	PIO_LSR_P27_Pos = 0x1b
	// Bit mask of P27 field.
	PIO_LSR_P27_Msk = 0x8000000
	// Bit P27.
	PIO_LSR_P27 = 0x8000000
	// Position of P28 field.
	PIO_LSR_P28_Pos = 0x1c
	// Bit mask of P28 field.
	PIO_LSR_P28_Msk = 0x10000000
	// Bit P28.
	PIO_LSR_P28 = 0x10000000
	// Position of P29 field.
	PIO_LSR_P29_Pos = 0x1d
	// Bit mask of P29 field.
	PIO_LSR_P29_Msk = 0x20000000
	// Bit P29.
	PIO_LSR_P29 = 0x20000000
	// Position of P30 field.
	PIO_LSR_P30_Pos = 0x1e
	// Bit mask of P30 field.
	PIO_LSR_P30_Msk = 0x40000000
	// Bit P30.
	PIO_LSR_P30 = 0x40000000
	// Position of P31 field.
	PIO_LSR_P31_Pos = 0x1f
	// Bit mask of P31 field.
	PIO_LSR_P31_Msk = 0x80000000
	// Bit P31.
	PIO_LSR_P31 = 0x80000000

	// ELSR: Edge/Level Status Register
	// Position of P0 field.
	PIO_ELSR_P0_Pos = 0x0
	// Bit mask of P0 field.
	PIO_ELSR_P0_Msk = 0x1
	// Bit P0.
	PIO_ELSR_P0 = 0x1
	// Position of P1 field.
	PIO_ELSR_P1_Pos = 0x1
	// Bit mask of P1 field.
	PIO_ELSR_P1_Msk = 0x2
	// Bit P1.
	PIO_ELSR_P1 = 0x2
	// Position of P2 field.
	PIO_ELSR_P2_Pos = 0x2
	// Bit mask of P2 field.
	PIO_ELSR_P2_Msk = 0x4
	// Bit P2.
	PIO_ELSR_P2 = 0x4
	// Position of P3 field.
	PIO_ELSR_P3_Pos = 0x3
	// Bit mask of P3 field.
	PIO_ELSR_P3_Msk = 0x8
	// Bit P3.
	PIO_ELSR_P3 = 0x8
	// Position of P4 field.
	PIO_ELSR_P4_Pos = 0x4
	// Bit mask of P4 field.
	PIO_ELSR_P4_Msk = 0x10
	// Bit P4.
	PIO_ELSR_P4 = 0x10
	// Position of P5 field.
	PIO_ELSR_P5_Pos = 0x5
	// Bit mask of P5 field.
	PIO_ELSR_P5_Msk = 0x20
	// Bit P5.
	PIO_ELSR_P5 = 0x20
	// Position of P6 field.
	PIO_ELSR_P6_Pos = 0x6
	// Bit mask of P6 field.
	PIO_ELSR_P6_Msk = 0x40
	// Bit P6.
	PIO_ELSR_P6 = 0x40
	// Position of P7 field.
	PIO_ELSR_P7_Pos = 0x7
	// Bit mask of P7 field.
	PIO_ELSR_P7_Msk = 0x80
	// Bit P7.
	PIO_ELSR_P7 = 0x80
	// Position of P8 field.
	PIO_ELSR_P8_Pos = 0x8
	// Bit mask of P8 field.
	PIO_ELSR_P8_Msk = 0x100
	// Bit P8.
	PIO_ELSR_P8 = 0x100
	// Position of P9 field.
	PIO_ELSR_P9_Pos = 0x9
	// Bit mask of P9 field.
	PIO_ELSR_P9_Msk = 0x200
	// Bit P9.
	PIO_ELSR_P9 = 0x200
	// Position of P10 field.
	PIO_ELSR_P10_Pos = 0xa
	// Bit mask of P10 field.
	PIO_ELSR_P10_Msk = 0x400
	// Bit P10.
	PIO_ELSR_P10 = 0x400
	// Position of P11 field.
	PIO_ELSR_P11_Pos = 0xb
	// Bit mask of P11 field.
	PIO_ELSR_P11_Msk = 0x800
	// Bit P11.
	PIO_ELSR_P11 = 0x800
	// Position of P12 field.
	PIO_ELSR_P12_Pos = 0xc
	// Bit mask of P12 field.
	PIO_ELSR_P12_Msk = 0x1000
	// Bit P12.
	PIO_ELSR_P12 = 0x1000
	// Position of P13 field.
	PIO_ELSR_P13_Pos = 0xd
	// Bit mask of P13 field.
	PIO_ELSR_P13_Msk = 0x2000
	// Bit P13.
	PIO_ELSR_P13 = 0x2000
	// Position of P14 field.
	PIO_ELSR_P14_Pos = 0xe
	// Bit mask of P14 field.
	PIO_ELSR_P14_Msk = 0x4000
	// Bit P14.
	PIO_ELSR_P14 = 0x4000
	// Position of P15 field.
	PIO_ELSR_P15_Pos = 0xf
	// Bit mask of P15 field.
	PIO_ELSR_P15_Msk = 0x8000
	// Bit P15.
	PIO_ELSR_P15 = 0x8000
	// Position of P16 field.
	PIO_ELSR_P16_Pos = 0x10
	// Bit mask of P16 field.
	PIO_ELSR_P16_Msk = 0x10000
	// Bit P16.
	PIO_ELSR_P16 = 0x10000
	// Position of P17 field.
	PIO_ELSR_P17_Pos = 0x11
	// Bit mask of P17 field.
	PIO_ELSR_P17_Msk = 0x20000
	// Bit P17.
	PIO_ELSR_P17 = 0x20000
	// Position of P18 field.
	PIO_ELSR_P18_Pos = 0x12
	// Bit mask of P18 field.
	PIO_ELSR_P18_Msk = 0x40000
	// Bit P18.
	PIO_ELSR_P18 = 0x40000
	// Position of P19 field.
	PIO_ELSR_P19_Pos = 0x13
	// Bit mask of P19 field.
	PIO_ELSR_P19_Msk = 0x80000
	// Bit P19.
	PIO_ELSR_P19 = 0x80000
	// Position of P20 field.
	PIO_ELSR_P20_Pos = 0x14
	// Bit mask of P20 field.
	PIO_ELSR_P20_Msk = 0x100000
	// Bit P20.
	PIO_ELSR_P20 = 0x100000
	// Position of P21 field.
	PIO_ELSR_P21_Pos = 0x15
	// Bit mask of P21 field.
	PIO_ELSR_P21_Msk = 0x200000
	// Bit P21.
	PIO_ELSR_P21 = 0x200000
	// Position of P22 field.
	PIO_ELSR_P22_Pos = 0x16
	// Bit mask of P22 field.
	PIO_ELSR_P22_Msk = 0x400000
	// Bit P22.
	PIO_ELSR_P22 = 0x400000
	// Position of P23 field.
	PIO_ELSR_P23_Pos = 0x17
	// Bit mask of P23 field.
	PIO_ELSR_P23_Msk = 0x800000
	// Bit P23.
	PIO_ELSR_P23 = 0x800000
	// Position of P24 field.
	PIO_ELSR_P24_Pos = 0x18
	// Bit mask of P24 field.
	PIO_ELSR_P24_Msk = 0x1000000
	// Bit P24.
	PIO_ELSR_P24 = 0x1000000
	// Position of P25 field.
	PIO_ELSR_P25_Pos = 0x19
	// Bit mask of P25 field.
	PIO_ELSR_P25_Msk = 0x2000000
	// Bit P25.
	PIO_ELSR_P25 = 0x2000000
	// Position of P26 field.
	PIO_ELSR_P26_Pos = 0x1a
	// Bit mask of P26 field.
	PIO_ELSR_P26_Msk = 0x4000000
	// Bit P26.
	PIO_ELSR_P26 = 0x4000000
	// Position of P27 field.
	PIO_ELSR_P27_Pos = 0x1b
	// Bit mask of P27 field.
	PIO_ELSR_P27_Msk = 0x8000000
	// Bit P27.
	PIO_ELSR_P27 = 0x8000000
	// Position of P28 field.
	PIO_ELSR_P28_Pos = 0x1c
	// Bit mask of P28 field.
	PIO_ELSR_P28_Msk = 0x10000000
	// Bit P28.
	PIO_ELSR_P28 = 0x10000000
	// Position of P29 field.
	PIO_ELSR_P29_Pos = 0x1d
	// Bit mask of P29 field.
	PIO_ELSR_P29_Msk = 0x20000000
	// Bit P29.
	PIO_ELSR_P29 = 0x20000000
	// Position of P30 field.
	PIO_ELSR_P30_Pos = 0x1e
	// Bit mask of P30 field.
	PIO_ELSR_P30_Msk = 0x40000000
	// Bit P30.
	PIO_ELSR_P30 = 0x40000000
	// Position of P31 field.
	PIO_ELSR_P31_Pos = 0x1f
	// Bit mask of P31 field.
	PIO_ELSR_P31_Msk = 0x80000000
	// Bit P31.
	PIO_ELSR_P31 = 0x80000000

	// FELLSR: Falling Edge/Low Level Select Register
	// Position of P0 field.
	PIO_FELLSR_P0_Pos = 0x0
	// Bit mask of P0 field.
	PIO_FELLSR_P0_Msk = 0x1
	// Bit P0.
	PIO_FELLSR_P0 = 0x1
	// Position of P1 field.
	PIO_FELLSR_P1_Pos = 0x1
	// Bit mask of P1 field.
	PIO_FELLSR_P1_Msk = 0x2
	// Bit P1.
	PIO_FELLSR_P1 = 0x2
	// Position of P2 field.
	PIO_FELLSR_P2_Pos = 0x2
	// Bit mask of P2 field.
	PIO_FELLSR_P2_Msk = 0x4
	// Bit P2.
	PIO_FELLSR_P2 = 0x4
	// Position of P3 field.
	PIO_FELLSR_P3_Pos = 0x3
	// Bit mask of P3 field.
	PIO_FELLSR_P3_Msk = 0x8
	// Bit P3.
	PIO_FELLSR_P3 = 0x8
	// Position of P4 field.
	PIO_FELLSR_P4_Pos = 0x4
	// Bit mask of P4 field.
	PIO_FELLSR_P4_Msk = 0x10
	// Bit P4.
	PIO_FELLSR_P4 = 0x10
	// Position of P5 field.
	PIO_FELLSR_P5_Pos = 0x5
	// Bit mask of P5 field.
	PIO_FELLSR_P5_Msk = 0x20
	// Bit P5.
	PIO_FELLSR_P5 = 0x20
	// Position of P6 field.
	PIO_FELLSR_P6_Pos = 0x6
	// Bit mask of P6 field.
	PIO_FELLSR_P6_Msk = 0x40
	// Bit P6.
	PIO_FELLSR_P6 = 0x40
	// Position of P7 field.
	PIO_FELLSR_P7_Pos = 0x7
	// Bit mask of P7 field.
	PIO_FELLSR_P7_Msk = 0x80
	// Bit P7.
	PIO_FELLSR_P7 = 0x80
	// Position of P8 field.
	PIO_FELLSR_P8_Pos = 0x8
	// Bit mask of P8 field.
	PIO_FELLSR_P8_Msk = 0x100
	// Bit P8.
	PIO_FELLSR_P8 = 0x100
	// Position of P9 field.
	PIO_FELLSR_P9_Pos = 0x9
	// Bit mask of P9 field.
	PIO_FELLSR_P9_Msk = 0x200
	// Bit P9.
	PIO_FELLSR_P9 = 0x200
	// Position of P10 field.
	PIO_FELLSR_P10_Pos = 0xa
	// Bit mask of P10 field.
	PIO_FELLSR_P10_Msk = 0x400
	// Bit P10.
	PIO_FELLSR_P10 = 0x400
	// Position of P11 field.
	PIO_FELLSR_P11_Pos = 0xb
	// Bit mask of P11 field.
	PIO_FELLSR_P11_Msk = 0x800
	// Bit P11.
	PIO_FELLSR_P11 = 0x800
	// Position of P12 field.
	PIO_FELLSR_P12_Pos = 0xc
	// Bit mask of P12 field.
	PIO_FELLSR_P12_Msk = 0x1000
	// Bit P12.
	PIO_FELLSR_P12 = 0x1000
	// Position of P13 field.
	PIO_FELLSR_P13_Pos = 0xd
	// Bit mask of P13 field.
	PIO_FELLSR_P13_Msk = 0x2000
	// Bit P13.
	PIO_FELLSR_P13 = 0x2000
	// Position of P14 field.
	PIO_FELLSR_P14_Pos = 0xe
	// Bit mask of P14 field.
	PIO_FELLSR_P14_Msk = 0x4000
	// Bit P14.
	PIO_FELLSR_P14 = 0x4000
	// Position of P15 field.
	PIO_FELLSR_P15_Pos = 0xf
	// Bit mask of P15 field.
	PIO_FELLSR_P15_Msk = 0x8000
	// Bit P15.
	PIO_FELLSR_P15 = 0x8000
	// Position of P16 field.
	PIO_FELLSR_P16_Pos = 0x10
	// Bit mask of P16 field.
	PIO_FELLSR_P16_Msk = 0x10000
	// Bit P16.
	PIO_FELLSR_P16 = 0x10000
	// Position of P17 field.
	PIO_FELLSR_P17_Pos = 0x11
	// Bit mask of P17 field.
	PIO_FELLSR_P17_Msk = 0x20000
	// Bit P17.
	PIO_FELLSR_P17 = 0x20000
	// Position of P18 field.
	PIO_FELLSR_P18_Pos = 0x12
	// Bit mask of P18 field.
	PIO_FELLSR_P18_Msk = 0x40000
	// Bit P18.
	PIO_FELLSR_P18 = 0x40000
	// Position of P19 field.
	PIO_FELLSR_P19_Pos = 0x13
	// Bit mask of P19 field.
	PIO_FELLSR_P19_Msk = 0x80000
	// Bit P19.
	PIO_FELLSR_P19 = 0x80000
	// Position of P20 field.
	PIO_FELLSR_P20_Pos = 0x14
	// Bit mask of P20 field.
	PIO_FELLSR_P20_Msk = 0x100000
	// Bit P20.
	PIO_FELLSR_P20 = 0x100000
	// Position of P21 field.
	PIO_FELLSR_P21_Pos = 0x15
	// Bit mask of P21 field.
	PIO_FELLSR_P21_Msk = 0x200000
	// Bit P21.
	PIO_FELLSR_P21 = 0x200000
	// Position of P22 field.
	PIO_FELLSR_P22_Pos = 0x16
	// Bit mask of P22 field.
	PIO_FELLSR_P22_Msk = 0x400000
	// Bit P22.
	PIO_FELLSR_P22 = 0x400000
	// Position of P23 field.
	PIO_FELLSR_P23_Pos = 0x17
	// Bit mask of P23 field.
	PIO_FELLSR_P23_Msk = 0x800000
	// Bit P23.
	PIO_FELLSR_P23 = 0x800000
	// Position of P24 field.
	PIO_FELLSR_P24_Pos = 0x18
	// Bit mask of P24 field.
	PIO_FELLSR_P24_Msk = 0x1000000
	// Bit P24.
	PIO_FELLSR_P24 = 0x1000000
	// Position of P25 field.
	PIO_FELLSR_P25_Pos = 0x19
	// Bit mask of P25 field.
	PIO_FELLSR_P25_Msk = 0x2000000
	// Bit P25.
	PIO_FELLSR_P25 = 0x2000000
	// Position of P26 field.
	PIO_FELLSR_P26_Pos = 0x1a
	// Bit mask of P26 field.
	PIO_FELLSR_P26_Msk = 0x4000000
	// Bit P26.
	PIO_FELLSR_P26 = 0x4000000
	// Position of P27 field.
	PIO_FELLSR_P27_Pos = 0x1b
	// Bit mask of P27 field.
	PIO_FELLSR_P27_Msk = 0x8000000
	// Bit P27.
	PIO_FELLSR_P27 = 0x8000000
	// Position of P28 field.
	PIO_FELLSR_P28_Pos = 0x1c
	// Bit mask of P28 field.
	PIO_FELLSR_P28_Msk = 0x10000000
	// Bit P28.
	PIO_FELLSR_P28 = 0x10000000
	// Position of P29 field.
	PIO_FELLSR_P29_Pos = 0x1d
	// Bit mask of P29 field.
	PIO_FELLSR_P29_Msk = 0x20000000
	// Bit P29.
	PIO_FELLSR_P29 = 0x20000000
	// Position of P30 field.
	PIO_FELLSR_P30_Pos = 0x1e
	// Bit mask of P30 field.
	PIO_FELLSR_P30_Msk = 0x40000000
	// Bit P30.
	PIO_FELLSR_P30 = 0x40000000
	// Position of P31 field.
	PIO_FELLSR_P31_Pos = 0x1f
	// Bit mask of P31 field.
	PIO_FELLSR_P31_Msk = 0x80000000
	// Bit P31.
	PIO_FELLSR_P31 = 0x80000000

	// REHLSR: Rising Edge/ High Level Select Register
	// Position of P0 field.
	PIO_REHLSR_P0_Pos = 0x0
	// Bit mask of P0 field.
	PIO_REHLSR_P0_Msk = 0x1
	// Bit P0.
	PIO_REHLSR_P0 = 0x1
	// Position of P1 field.
	PIO_REHLSR_P1_Pos = 0x1
	// Bit mask of P1 field.
	PIO_REHLSR_P1_Msk = 0x2
	// Bit P1.
	PIO_REHLSR_P1 = 0x2
	// Position of P2 field.
	PIO_REHLSR_P2_Pos = 0x2
	// Bit mask of P2 field.
	PIO_REHLSR_P2_Msk = 0x4
	// Bit P2.
	PIO_REHLSR_P2 = 0x4
	// Position of P3 field.
	PIO_REHLSR_P3_Pos = 0x3
	// Bit mask of P3 field.
	PIO_REHLSR_P3_Msk = 0x8
	// Bit P3.
	PIO_REHLSR_P3 = 0x8
	// Position of P4 field.
	PIO_REHLSR_P4_Pos = 0x4
	// Bit mask of P4 field.
	PIO_REHLSR_P4_Msk = 0x10
	// Bit P4.
	PIO_REHLSR_P4 = 0x10
	// Position of P5 field.
	PIO_REHLSR_P5_Pos = 0x5
	// Bit mask of P5 field.
	PIO_REHLSR_P5_Msk = 0x20
	// Bit P5.
	PIO_REHLSR_P5 = 0x20
	// Position of P6 field.
	PIO_REHLSR_P6_Pos = 0x6
	// Bit mask of P6 field.
	PIO_REHLSR_P6_Msk = 0x40
	// Bit P6.
	PIO_REHLSR_P6 = 0x40
	// Position of P7 field.
	PIO_REHLSR_P7_Pos = 0x7
	// Bit mask of P7 field.
	PIO_REHLSR_P7_Msk = 0x80
	// Bit P7.
	PIO_REHLSR_P7 = 0x80
	// Position of P8 field.
	PIO_REHLSR_P8_Pos = 0x8
	// Bit mask of P8 field.
	PIO_REHLSR_P8_Msk = 0x100
	// Bit P8.
	PIO_REHLSR_P8 = 0x100
	// Position of P9 field.
	PIO_REHLSR_P9_Pos = 0x9
	// Bit mask of P9 field.
	PIO_REHLSR_P9_Msk = 0x200
	// Bit P9.
	PIO_REHLSR_P9 = 0x200
	// Position of P10 field.
	PIO_REHLSR_P10_Pos = 0xa
	// Bit mask of P10 field.
	PIO_REHLSR_P10_Msk = 0x400
	// Bit P10.
	PIO_REHLSR_P10 = 0x400
	// Position of P11 field.
	PIO_REHLSR_P11_Pos = 0xb
	// Bit mask of P11 field.
	PIO_REHLSR_P11_Msk = 0x800
	// Bit P11.
	PIO_REHLSR_P11 = 0x800
	// Position of P12 field.
	PIO_REHLSR_P12_Pos = 0xc
	// Bit mask of P12 field.
	PIO_REHLSR_P12_Msk = 0x1000
	// Bit P12.
	PIO_REHLSR_P12 = 0x1000
	// Position of P13 field.
	PIO_REHLSR_P13_Pos = 0xd
	// Bit mask of P13 field.
	PIO_REHLSR_P13_Msk = 0x2000
	// Bit P13.
	PIO_REHLSR_P13 = 0x2000
	// Position of P14 field.
	PIO_REHLSR_P14_Pos = 0xe
	// Bit mask of P14 field.
	PIO_REHLSR_P14_Msk = 0x4000
	// Bit P14.
	PIO_REHLSR_P14 = 0x4000
	// Position of P15 field.
	PIO_REHLSR_P15_Pos = 0xf
	// Bit mask of P15 field.
	PIO_REHLSR_P15_Msk = 0x8000
	// Bit P15.
	PIO_REHLSR_P15 = 0x8000
	// Position of P16 field.
	PIO_REHLSR_P16_Pos = 0x10
	// Bit mask of P16 field.
	PIO_REHLSR_P16_Msk = 0x10000
	// Bit P16.
	PIO_REHLSR_P16 = 0x10000
	// Position of P17 field.
	PIO_REHLSR_P17_Pos = 0x11
	// Bit mask of P17 field.
	PIO_REHLSR_P17_Msk = 0x20000
	// Bit P17.
	PIO_REHLSR_P17 = 0x20000
	// Position of P18 field.
	PIO_REHLSR_P18_Pos = 0x12
	// Bit mask of P18 field.
	PIO_REHLSR_P18_Msk = 0x40000
	// Bit P18.
	PIO_REHLSR_P18 = 0x40000
	// Position of P19 field.
	PIO_REHLSR_P19_Pos = 0x13
	// Bit mask of P19 field.
	PIO_REHLSR_P19_Msk = 0x80000
	// Bit P19.
	PIO_REHLSR_P19 = 0x80000
	// Position of P20 field.
	PIO_REHLSR_P20_Pos = 0x14
	// Bit mask of P20 field.
	PIO_REHLSR_P20_Msk = 0x100000
	// Bit P20.
	PIO_REHLSR_P20 = 0x100000
	// Position of P21 field.
	PIO_REHLSR_P21_Pos = 0x15
	// Bit mask of P21 field.
	PIO_REHLSR_P21_Msk = 0x200000
	// Bit P21.
	PIO_REHLSR_P21 = 0x200000
	// Position of P22 field.
	PIO_REHLSR_P22_Pos = 0x16
	// Bit mask of P22 field.
	PIO_REHLSR_P22_Msk = 0x400000
	// Bit P22.
	PIO_REHLSR_P22 = 0x400000
	// Position of P23 field.
	PIO_REHLSR_P23_Pos = 0x17
	// Bit mask of P23 field.
	PIO_REHLSR_P23_Msk = 0x800000
	// Bit P23.
	PIO_REHLSR_P23 = 0x800000
	// Position of P24 field.
	PIO_REHLSR_P24_Pos = 0x18
	// Bit mask of P24 field.
	PIO_REHLSR_P24_Msk = 0x1000000
	// Bit P24.
	PIO_REHLSR_P24 = 0x1000000
	// Position of P25 field.
	PIO_REHLSR_P25_Pos = 0x19
	// Bit mask of P25 field.
	PIO_REHLSR_P25_Msk = 0x2000000
	// Bit P25.
	PIO_REHLSR_P25 = 0x2000000
	// Position of P26 field.
	PIO_REHLSR_P26_Pos = 0x1a
	// Bit mask of P26 field.
	PIO_REHLSR_P26_Msk = 0x4000000
	// Bit P26.
	PIO_REHLSR_P26 = 0x4000000
	// Position of P27 field.
	PIO_REHLSR_P27_Pos = 0x1b
	// Bit mask of P27 field.
	PIO_REHLSR_P27_Msk = 0x8000000
	// Bit P27.
	PIO_REHLSR_P27 = 0x8000000
	// Position of P28 field.
	PIO_REHLSR_P28_Pos = 0x1c
	// Bit mask of P28 field.
	PIO_REHLSR_P28_Msk = 0x10000000
	// Bit P28.
	PIO_REHLSR_P28 = 0x10000000
	// Position of P29 field.
	PIO_REHLSR_P29_Pos = 0x1d
	// Bit mask of P29 field.
	PIO_REHLSR_P29_Msk = 0x20000000
	// Bit P29.
	PIO_REHLSR_P29 = 0x20000000
	// Position of P30 field.
	PIO_REHLSR_P30_Pos = 0x1e
	// Bit mask of P30 field.
	PIO_REHLSR_P30_Msk = 0x40000000
	// Bit P30.
	PIO_REHLSR_P30 = 0x40000000
	// Position of P31 field.
	PIO_REHLSR_P31_Pos = 0x1f
	// Bit mask of P31 field.
	PIO_REHLSR_P31_Msk = 0x80000000
	// Bit P31.
	PIO_REHLSR_P31 = 0x80000000

	// FRLHSR: Fall/Rise - Low/High Status Register
	// Position of P0 field.
	PIO_FRLHSR_P0_Pos = 0x0
	// Bit mask of P0 field.
	PIO_FRLHSR_P0_Msk = 0x1
	// Bit P0.
	PIO_FRLHSR_P0 = 0x1
	// Position of P1 field.
	PIO_FRLHSR_P1_Pos = 0x1
	// Bit mask of P1 field.
	PIO_FRLHSR_P1_Msk = 0x2
	// Bit P1.
	PIO_FRLHSR_P1 = 0x2
	// Position of P2 field.
	PIO_FRLHSR_P2_Pos = 0x2
	// Bit mask of P2 field.
	PIO_FRLHSR_P2_Msk = 0x4
	// Bit P2.
	PIO_FRLHSR_P2 = 0x4
	// Position of P3 field.
	PIO_FRLHSR_P3_Pos = 0x3
	// Bit mask of P3 field.
	PIO_FRLHSR_P3_Msk = 0x8
	// Bit P3.
	PIO_FRLHSR_P3 = 0x8
	// Position of P4 field.
	PIO_FRLHSR_P4_Pos = 0x4
	// Bit mask of P4 field.
	PIO_FRLHSR_P4_Msk = 0x10
	// Bit P4.
	PIO_FRLHSR_P4 = 0x10
	// Position of P5 field.
	PIO_FRLHSR_P5_Pos = 0x5
	// Bit mask of P5 field.
	PIO_FRLHSR_P5_Msk = 0x20
	// Bit P5.
	PIO_FRLHSR_P5 = 0x20
	// Position of P6 field.
	PIO_FRLHSR_P6_Pos = 0x6
	// Bit mask of P6 field.
	PIO_FRLHSR_P6_Msk = 0x40
	// Bit P6.
	PIO_FRLHSR_P6 = 0x40
	// Position of P7 field.
	PIO_FRLHSR_P7_Pos = 0x7
	// Bit mask of P7 field.
	PIO_FRLHSR_P7_Msk = 0x80
	// Bit P7.
	PIO_FRLHSR_P7 = 0x80
	// Position of P8 field.
	PIO_FRLHSR_P8_Pos = 0x8
	// Bit mask of P8 field.
	PIO_FRLHSR_P8_Msk = 0x100
	// Bit P8.
	PIO_FRLHSR_P8 = 0x100
	// Position of P9 field.
	PIO_FRLHSR_P9_Pos = 0x9
	// Bit mask of P9 field.
	PIO_FRLHSR_P9_Msk = 0x200
	// Bit P9.
	PIO_FRLHSR_P9 = 0x200
	// Position of P10 field.
	PIO_FRLHSR_P10_Pos = 0xa
	// Bit mask of P10 field.
	PIO_FRLHSR_P10_Msk = 0x400
	// Bit P10.
	PIO_FRLHSR_P10 = 0x400
	// Position of P11 field.
	PIO_FRLHSR_P11_Pos = 0xb
	// Bit mask of P11 field.
	PIO_FRLHSR_P11_Msk = 0x800
	// Bit P11.
	PIO_FRLHSR_P11 = 0x800
	// Position of P12 field.
	PIO_FRLHSR_P12_Pos = 0xc
	// Bit mask of P12 field.
	PIO_FRLHSR_P12_Msk = 0x1000
	// Bit P12.
	PIO_FRLHSR_P12 = 0x1000
	// Position of P13 field.
	PIO_FRLHSR_P13_Pos = 0xd
	// Bit mask of P13 field.
	PIO_FRLHSR_P13_Msk = 0x2000
	// Bit P13.
	PIO_FRLHSR_P13 = 0x2000
	// Position of P14 field.
	PIO_FRLHSR_P14_Pos = 0xe
	// Bit mask of P14 field.
	PIO_FRLHSR_P14_Msk = 0x4000
	// Bit P14.
	PIO_FRLHSR_P14 = 0x4000
	// Position of P15 field.
	PIO_FRLHSR_P15_Pos = 0xf
	// Bit mask of P15 field.
	PIO_FRLHSR_P15_Msk = 0x8000
	// Bit P15.
	PIO_FRLHSR_P15 = 0x8000
	// Position of P16 field.
	PIO_FRLHSR_P16_Pos = 0x10
	// Bit mask of P16 field.
	PIO_FRLHSR_P16_Msk = 0x10000
	// Bit P16.
	PIO_FRLHSR_P16 = 0x10000
	// Position of P17 field.
	PIO_FRLHSR_P17_Pos = 0x11
	// Bit mask of P17 field.
	PIO_FRLHSR_P17_Msk = 0x20000
	// Bit P17.
	PIO_FRLHSR_P17 = 0x20000
	// Position of P18 field.
	PIO_FRLHSR_P18_Pos = 0x12
	// Bit mask of P18 field.
	PIO_FRLHSR_P18_Msk = 0x40000
	// Bit P18.
	PIO_FRLHSR_P18 = 0x40000
	// Position of P19 field.
	PIO_FRLHSR_P19_Pos = 0x13
	// Bit mask of P19 field.
	PIO_FRLHSR_P19_Msk = 0x80000
	// Bit P19.
	PIO_FRLHSR_P19 = 0x80000
	// Position of P20 field.
	PIO_FRLHSR_P20_Pos = 0x14
	// Bit mask of P20 field.
	PIO_FRLHSR_P20_Msk = 0x100000
	// Bit P20.
	PIO_FRLHSR_P20 = 0x100000
	// Position of P21 field.
	PIO_FRLHSR_P21_Pos = 0x15
	// Bit mask of P21 field.
	PIO_FRLHSR_P21_Msk = 0x200000
	// Bit P21.
	PIO_FRLHSR_P21 = 0x200000
	// Position of P22 field.
	PIO_FRLHSR_P22_Pos = 0x16
	// Bit mask of P22 field.
	PIO_FRLHSR_P22_Msk = 0x400000
	// Bit P22.
	PIO_FRLHSR_P22 = 0x400000
	// Position of P23 field.
	PIO_FRLHSR_P23_Pos = 0x17
	// Bit mask of P23 field.
	PIO_FRLHSR_P23_Msk = 0x800000
	// Bit P23.
	PIO_FRLHSR_P23 = 0x800000
	// Position of P24 field.
	PIO_FRLHSR_P24_Pos = 0x18
	// Bit mask of P24 field.
	PIO_FRLHSR_P24_Msk = 0x1000000
	// Bit P24.
	PIO_FRLHSR_P24 = 0x1000000
	// Position of P25 field.
	PIO_FRLHSR_P25_Pos = 0x19
	// Bit mask of P25 field.
	PIO_FRLHSR_P25_Msk = 0x2000000
	// Bit P25.
	PIO_FRLHSR_P25 = 0x2000000
	// Position of P26 field.
	PIO_FRLHSR_P26_Pos = 0x1a
	// Bit mask of P26 field.
	PIO_FRLHSR_P26_Msk = 0x4000000
	// Bit P26.
	PIO_FRLHSR_P26 = 0x4000000
	// Position of P27 field.
	PIO_FRLHSR_P27_Pos = 0x1b
	// Bit mask of P27 field.
	PIO_FRLHSR_P27_Msk = 0x8000000
	// Bit P27.
	PIO_FRLHSR_P27 = 0x8000000
	// Position of P28 field.
	PIO_FRLHSR_P28_Pos = 0x1c
	// Bit mask of P28 field.
	PIO_FRLHSR_P28_Msk = 0x10000000
	// Bit P28.
	PIO_FRLHSR_P28 = 0x10000000
	// Position of P29 field.
	PIO_FRLHSR_P29_Pos = 0x1d
	// Bit mask of P29 field.
	PIO_FRLHSR_P29_Msk = 0x20000000
	// Bit P29.
	PIO_FRLHSR_P29 = 0x20000000
	// Position of P30 field.
	PIO_FRLHSR_P30_Pos = 0x1e
	// Bit mask of P30 field.
	PIO_FRLHSR_P30_Msk = 0x40000000
	// Bit P30.
	PIO_FRLHSR_P30 = 0x40000000
	// Position of P31 field.
	PIO_FRLHSR_P31_Pos = 0x1f
	// Bit mask of P31 field.
	PIO_FRLHSR_P31_Msk = 0x80000000
	// Bit P31.
	PIO_FRLHSR_P31 = 0x80000000

	// LOCKSR: Lock Status
	// Position of P0 field.
	PIO_LOCKSR_P0_Pos = 0x0
	// Bit mask of P0 field.
	PIO_LOCKSR_P0_Msk = 0x1
	// Bit P0.
	PIO_LOCKSR_P0 = 0x1
	// Position of P1 field.
	PIO_LOCKSR_P1_Pos = 0x1
	// Bit mask of P1 field.
	PIO_LOCKSR_P1_Msk = 0x2
	// Bit P1.
	PIO_LOCKSR_P1 = 0x2
	// Position of P2 field.
	PIO_LOCKSR_P2_Pos = 0x2
	// Bit mask of P2 field.
	PIO_LOCKSR_P2_Msk = 0x4
	// Bit P2.
	PIO_LOCKSR_P2 = 0x4
	// Position of P3 field.
	PIO_LOCKSR_P3_Pos = 0x3
	// Bit mask of P3 field.
	PIO_LOCKSR_P3_Msk = 0x8
	// Bit P3.
	PIO_LOCKSR_P3 = 0x8
	// Position of P4 field.
	PIO_LOCKSR_P4_Pos = 0x4
	// Bit mask of P4 field.
	PIO_LOCKSR_P4_Msk = 0x10
	// Bit P4.
	PIO_LOCKSR_P4 = 0x10
	// Position of P5 field.
	PIO_LOCKSR_P5_Pos = 0x5
	// Bit mask of P5 field.
	PIO_LOCKSR_P5_Msk = 0x20
	// Bit P5.
	PIO_LOCKSR_P5 = 0x20
	// Position of P6 field.
	PIO_LOCKSR_P6_Pos = 0x6
	// Bit mask of P6 field.
	PIO_LOCKSR_P6_Msk = 0x40
	// Bit P6.
	PIO_LOCKSR_P6 = 0x40
	// Position of P7 field.
	PIO_LOCKSR_P7_Pos = 0x7
	// Bit mask of P7 field.
	PIO_LOCKSR_P7_Msk = 0x80
	// Bit P7.
	PIO_LOCKSR_P7 = 0x80
	// Position of P8 field.
	PIO_LOCKSR_P8_Pos = 0x8
	// Bit mask of P8 field.
	PIO_LOCKSR_P8_Msk = 0x100
	// Bit P8.
	PIO_LOCKSR_P8 = 0x100
	// Position of P9 field.
	PIO_LOCKSR_P9_Pos = 0x9
	// Bit mask of P9 field.
	PIO_LOCKSR_P9_Msk = 0x200
	// Bit P9.
	PIO_LOCKSR_P9 = 0x200
	// Position of P10 field.
	PIO_LOCKSR_P10_Pos = 0xa
	// Bit mask of P10 field.
	PIO_LOCKSR_P10_Msk = 0x400
	// Bit P10.
	PIO_LOCKSR_P10 = 0x400
	// Position of P11 field.
	PIO_LOCKSR_P11_Pos = 0xb
	// Bit mask of P11 field.
	PIO_LOCKSR_P11_Msk = 0x800
	// Bit P11.
	PIO_LOCKSR_P11 = 0x800
	// Position of P12 field.
	PIO_LOCKSR_P12_Pos = 0xc
	// Bit mask of P12 field.
	PIO_LOCKSR_P12_Msk = 0x1000
	// Bit P12.
	PIO_LOCKSR_P12 = 0x1000
	// Position of P13 field.
	PIO_LOCKSR_P13_Pos = 0xd
	// Bit mask of P13 field.
	PIO_LOCKSR_P13_Msk = 0x2000
	// Bit P13.
	PIO_LOCKSR_P13 = 0x2000
	// Position of P14 field.
	PIO_LOCKSR_P14_Pos = 0xe
	// Bit mask of P14 field.
	PIO_LOCKSR_P14_Msk = 0x4000
	// Bit P14.
	PIO_LOCKSR_P14 = 0x4000
	// Position of P15 field.
	PIO_LOCKSR_P15_Pos = 0xf
	// Bit mask of P15 field.
	PIO_LOCKSR_P15_Msk = 0x8000
	// Bit P15.
	PIO_LOCKSR_P15 = 0x8000
	// Position of P16 field.
	PIO_LOCKSR_P16_Pos = 0x10
	// Bit mask of P16 field.
	PIO_LOCKSR_P16_Msk = 0x10000
	// Bit P16.
	PIO_LOCKSR_P16 = 0x10000
	// Position of P17 field.
	PIO_LOCKSR_P17_Pos = 0x11
	// Bit mask of P17 field.
	PIO_LOCKSR_P17_Msk = 0x20000
	// Bit P17.
	PIO_LOCKSR_P17 = 0x20000
	// Position of P18 field.
	PIO_LOCKSR_P18_Pos = 0x12
	// Bit mask of P18 field.
	PIO_LOCKSR_P18_Msk = 0x40000
	// Bit P18.
	PIO_LOCKSR_P18 = 0x40000
	// Position of P19 field.
	PIO_LOCKSR_P19_Pos = 0x13
	// Bit mask of P19 field.
	PIO_LOCKSR_P19_Msk = 0x80000
	// Bit P19.
	PIO_LOCKSR_P19 = 0x80000
	// Position of P20 field.
	PIO_LOCKSR_P20_Pos = 0x14
	// Bit mask of P20 field.
	PIO_LOCKSR_P20_Msk = 0x100000
	// Bit P20.
	PIO_LOCKSR_P20 = 0x100000
	// Position of P21 field.
	PIO_LOCKSR_P21_Pos = 0x15
	// Bit mask of P21 field.
	PIO_LOCKSR_P21_Msk = 0x200000
	// Bit P21.
	PIO_LOCKSR_P21 = 0x200000
	// Position of P22 field.
	PIO_LOCKSR_P22_Pos = 0x16
	// Bit mask of P22 field.
	PIO_LOCKSR_P22_Msk = 0x400000
	// Bit P22.
	PIO_LOCKSR_P22 = 0x400000
	// Position of P23 field.
	PIO_LOCKSR_P23_Pos = 0x17
	// Bit mask of P23 field.
	PIO_LOCKSR_P23_Msk = 0x800000
	// Bit P23.
	PIO_LOCKSR_P23 = 0x800000
	// Position of P24 field.
	PIO_LOCKSR_P24_Pos = 0x18
	// Bit mask of P24 field.
	PIO_LOCKSR_P24_Msk = 0x1000000
	// Bit P24.
	PIO_LOCKSR_P24 = 0x1000000
	// Position of P25 field.
	PIO_LOCKSR_P25_Pos = 0x19
	// Bit mask of P25 field.
	PIO_LOCKSR_P25_Msk = 0x2000000
	// Bit P25.
	PIO_LOCKSR_P25 = 0x2000000
	// Position of P26 field.
	PIO_LOCKSR_P26_Pos = 0x1a
	// Bit mask of P26 field.
	PIO_LOCKSR_P26_Msk = 0x4000000
	// Bit P26.
	PIO_LOCKSR_P26 = 0x4000000
	// Position of P27 field.
	PIO_LOCKSR_P27_Pos = 0x1b
	// Bit mask of P27 field.
	PIO_LOCKSR_P27_Msk = 0x8000000
	// Bit P27.
	PIO_LOCKSR_P27 = 0x8000000
	// Position of P28 field.
	PIO_LOCKSR_P28_Pos = 0x1c
	// Bit mask of P28 field.
	PIO_LOCKSR_P28_Msk = 0x10000000
	// Bit P28.
	PIO_LOCKSR_P28 = 0x10000000
	// Position of P29 field.
	PIO_LOCKSR_P29_Pos = 0x1d
	// Bit mask of P29 field.
	PIO_LOCKSR_P29_Msk = 0x20000000
	// Bit P29.
	PIO_LOCKSR_P29 = 0x20000000
	// Position of P30 field.
	PIO_LOCKSR_P30_Pos = 0x1e
	// Bit mask of P30 field.
	PIO_LOCKSR_P30_Msk = 0x40000000
	// Bit P30.
	PIO_LOCKSR_P30 = 0x40000000
	// Position of P31 field.
	PIO_LOCKSR_P31_Pos = 0x1f
	// Bit mask of P31 field.
	PIO_LOCKSR_P31_Msk = 0x80000000
	// Bit P31.
	PIO_LOCKSR_P31 = 0x80000000

	// WPMR: Write Protect Mode Register
	// Position of WPEN field.
	PIO_WPMR_WPEN_Pos = 0x0
	// Bit mask of WPEN field.
	PIO_WPMR_WPEN_Msk = 0x1
	// Bit WPEN.
	PIO_WPMR_WPEN = 0x1
	// Position of WPKEY field.
	PIO_WPMR_WPKEY_Pos = 0x8
	// Bit mask of WPKEY field.
	PIO_WPMR_WPKEY_Msk = 0xffffff00

	// WPSR: Write Protect Status Register
	// Position of WPVS field.
	PIO_WPSR_WPVS_Pos = 0x0
	// Bit mask of WPVS field.
	PIO_WPSR_WPVS_Msk = 0x1
	// Bit WPVS.
	PIO_WPSR_WPVS = 0x1
	// Position of WPVSRC field.
	PIO_WPSR_WPVSRC_Pos = 0x8
	// Bit mask of WPVSRC field.
	PIO_WPSR_WPVSRC_Msk = 0xffff00
)

// Bitfields for RSTC: Reset Controller
const (
	// CR: Control Register
	// Position of PROCRST field.
	SYSC_CR_PROCRST_Pos = 0x0
	// Bit mask of PROCRST field.
	SYSC_CR_PROCRST_Msk = 0x1
	// Bit PROCRST.
	SYSC_CR_PROCRST = 0x1
	// Position of PERRST field.
	SYSC_CR_PERRST_Pos = 0x2
	// Bit mask of PERRST field.
	SYSC_CR_PERRST_Msk = 0x4
	// Bit PERRST.
	SYSC_CR_PERRST = 0x4
	// Position of EXTRST field.
	SYSC_CR_EXTRST_Pos = 0x3
	// Bit mask of EXTRST field.
	SYSC_CR_EXTRST_Msk = 0x8
	// Bit EXTRST.
	SYSC_CR_EXTRST = 0x8
	// Position of KEY field.
	SYSC_CR_KEY_Pos = 0x18
	// Bit mask of KEY field.
	SYSC_CR_KEY_Msk = 0xff000000

	// SR: Status Register
	// Position of URSTS field.
	SYSC_SR_URSTS_Pos = 0x0
	// Bit mask of URSTS field.
	SYSC_SR_URSTS_Msk = 0x1
	// Bit URSTS.
	SYSC_SR_URSTS = 0x1
	// Position of RSTTYP field.
	SYSC_SR_RSTTYP_Pos = 0x8
	// Bit mask of RSTTYP field.
	SYSC_SR_RSTTYP_Msk = 0x700
	// Position of NRSTL field.
	SYSC_SR_NRSTL_Pos = 0x10
	// Bit mask of NRSTL field.
	SYSC_SR_NRSTL_Msk = 0x10000
	// Bit NRSTL.
	SYSC_SR_NRSTL = 0x10000
	// Position of SRCMP field.
	SYSC_SR_SRCMP_Pos = 0x11
	// Bit mask of SRCMP field.
	SYSC_SR_SRCMP_Msk = 0x20000
	// Bit SRCMP.
	SYSC_SR_SRCMP = 0x20000

	// MR: Mode Register
	// Position of URSTEN field.
	SYSC_MR_URSTEN_Pos = 0x0
	// Bit mask of URSTEN field.
	SYSC_MR_URSTEN_Msk = 0x1
	// Bit URSTEN.
	SYSC_MR_URSTEN = 0x1
	// Position of URSTIEN field.
	SYSC_MR_URSTIEN_Pos = 0x4
	// Bit mask of URSTIEN field.
	SYSC_MR_URSTIEN_Msk = 0x10
	// Bit URSTIEN.
	SYSC_MR_URSTIEN = 0x10
	// Position of ERSTL field.
	SYSC_MR_ERSTL_Pos = 0x8
	// Bit mask of ERSTL field.
	SYSC_MR_ERSTL_Msk = 0xf00
	// Position of KEY field.
	SYSC_MR_KEY_Pos = 0x18
	// Bit mask of KEY field.
	SYSC_MR_KEY_Msk = 0xff000000
)
