/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.editor.mimelookup;

import org.netbeans.api.editor.mimelookup.MimePath;
import org.openide.util.Lookup;

public final class MimeLookup
extends Lookup {
    private Lookup mimePathLookup;
    private final MimePath mimePath;

    public static Lookup getLookup(MimePath mimePath) {
        if (mimePath == null) {
            throw new NullPointerException("The mimePath parameter must not be null.");
        }
        return mimePath.getLookup();
    }

    public static Lookup getLookup(String string) {
        return MimeLookup.getLookup(MimePath.parse(string));
    }

    public static MimeLookup getMimeLookup(String string) {
        if (string == null) {
            throw new NullPointerException("The mimeType parameter must not be null.");
        }
        MimePath mimePath = MimePath.get(string);
        return new MimeLookup(mimePath, MimePath.get(string).getLookup());
    }

    private MimeLookup(MimePath mimePath, Lookup lookup) {
        this.mimePathLookup = lookup;
        this.mimePath = mimePath;
    }

    public MimeLookup childLookup(String string) {
        if (string == null) {
            throw new NullPointerException("The mimeType parameter must not be null.");
        }
        MimePath mimePath = MimePath.get(this.mimePath, string);
        return new MimeLookup(mimePath, mimePath.getLookup());
    }

    public <T> T lookup(Class<T> clazz) {
        return (T)this.mimePathLookup.lookup(clazz);
    }

    public <T> Lookup.Result<T> lookup(Lookup.Template<T> template) {
        return this.mimePathLookup.lookup(template);
    }
}

