/*
 * Decompiled with CFR 0.152.
 */
package gps.convert;

import bt747.sys.I18N;
import bt747.sys.JavaLibBridge;
import bt747.sys.interfaces.BT747Time;
import gps.convert.ExternalUtils;
import gps.log.out.CommonOut;

public final class Conv {
    private static final byte[] daysInMonth = new byte[]{31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
    private static final String[] MONTHS_AS_SHORTTEXT = new String[]{"JAN", "FEB", "MAR", "APR", "MAY", "JUN", "JUL", "AUG", "SEP", "OCT", "NOV", "DEC"};
    private static final String[] MONTHS_AS_LONGTEXT = new String[]{"January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"};
    private static final String[] WEEKDAYS_AS_SHORTTEXT = new String[]{"Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"};
    private static final String[] WEEKDAYS_AS_LONGTEXT = new String[]{"Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday"};

    public static final int hexStringToBytes(String string, byte[] byArray) {
        int n = string.length() & 0xFFFFFFFE;
        for (int i = 0; i < n; i += 2) {
            int n2;
            switch (string.charAt(i)) {
                case '0': {
                    n2 = 0;
                    break;
                }
                case '1': {
                    n2 = 16;
                    break;
                }
                case '2': {
                    n2 = 32;
                    break;
                }
                case '3': {
                    n2 = 48;
                    break;
                }
                case '4': {
                    n2 = 64;
                    break;
                }
                case '5': {
                    n2 = 80;
                    break;
                }
                case '6': {
                    n2 = 96;
                    break;
                }
                case '7': {
                    n2 = 112;
                    break;
                }
                case '8': {
                    n2 = -128;
                    break;
                }
                case '9': {
                    n2 = -112;
                    break;
                }
                case 'A': 
                case 'a': {
                    n2 = -96;
                    break;
                }
                case 'B': 
                case 'b': {
                    n2 = -80;
                    break;
                }
                case 'C': 
                case 'c': {
                    n2 = -64;
                    break;
                }
                case 'D': 
                case 'd': {
                    n2 = -48;
                    break;
                }
                case 'E': 
                case 'e': {
                    n2 = -32;
                    break;
                }
                case 'F': 
                case 'f': {
                    n2 = -16;
                    break;
                }
                default: {
                    n2 = 0;
                }
            }
            switch (string.charAt(i + 1)) {
                case '0': {
                    break;
                }
                case '1': {
                    n2 = (byte)(n2 | 1);
                    break;
                }
                case '2': {
                    n2 = (byte)(n2 | 2);
                    break;
                }
                case '3': {
                    n2 = (byte)(n2 | 3);
                    break;
                }
                case '4': {
                    n2 = (byte)(n2 | 4);
                    break;
                }
                case '5': {
                    n2 = (byte)(n2 | 5);
                    break;
                }
                case '6': {
                    n2 = (byte)(n2 | 6);
                    break;
                }
                case '7': {
                    n2 = (byte)(n2 | 7);
                    break;
                }
                case '8': {
                    n2 = (byte)(n2 | 8);
                    break;
                }
                case '9': {
                    n2 = (byte)(n2 | 9);
                    break;
                }
                case 'A': 
                case 'a': {
                    n2 = (byte)(n2 | 0xA);
                    break;
                }
                case 'B': 
                case 'b': {
                    n2 = (byte)(n2 | 0xB);
                    break;
                }
                case 'C': 
                case 'c': {
                    n2 = (byte)(n2 | 0xC);
                    break;
                }
                case 'D': 
                case 'd': {
                    n2 = (byte)(n2 | 0xD);
                    break;
                }
                case 'E': 
                case 'e': {
                    n2 = (byte)(n2 | 0xE);
                    break;
                }
                case 'F': 
                case 'f': {
                    n2 = (byte)(n2 | 0xF);
                }
            }
            byArray[i >> 1] = n2;
        }
        return n;
    }

    public static final int hex2Int(String string) {
        int n = string.length();
        int n2 = 0;
        block18: for (int i = 0; i < n; ++i) {
            n2 <<= 4;
            switch (string.charAt(i)) {
                case '0': {
                    continue block18;
                }
                case '1': {
                    ++n2;
                    continue block18;
                }
                case '2': {
                    n2 += 2;
                    continue block18;
                }
                case '3': {
                    n2 += 3;
                    continue block18;
                }
                case '4': {
                    n2 += 4;
                    continue block18;
                }
                case '5': {
                    n2 += 5;
                    continue block18;
                }
                case '6': {
                    n2 += 6;
                    continue block18;
                }
                case '7': {
                    n2 += 7;
                    continue block18;
                }
                case '8': {
                    n2 += 8;
                    continue block18;
                }
                case '9': {
                    n2 += 9;
                    continue block18;
                }
                case 'A': 
                case 'a': {
                    n2 += 10;
                    continue block18;
                }
                case 'B': 
                case 'b': {
                    n2 += 11;
                    continue block18;
                }
                case 'C': 
                case 'c': {
                    n2 += 12;
                    continue block18;
                }
                case 'D': 
                case 'd': {
                    n2 += 13;
                    continue block18;
                }
                case 'E': 
                case 'e': {
                    n2 += 14;
                    continue block18;
                }
                case 'F': 
                case 'f': {
                    n2 += 15;
                }
            }
        }
        return n2;
    }

    public static final int hex2SignedInt(String string) {
        int n = Conv.hex2Int(string);
        if (n > 0 && n >> 4 * (string.length() - 1) >= 8) {
            n |= -1 << 32 - 4 * string.length();
        }
        return n;
    }

    public static final String expandDate(String string, BT747Time bT747Time) {
        StringBuffer stringBuffer = new StringBuffer(20);
        block44: for (int i = 0; i < string.length(); ++i) {
            int n = string.charAt(i);
            if (n != 37) {
                stringBuffer.append((char)n);
                continue;
            }
            if (i + 1 >= string.length()) {
                stringBuffer.append((char)n);
                continue;
            }
            n = string.charAt(++i);
            switch (n) {
                case 100: {
                    n = bT747Time.getDay();
                    if (n < 10) {
                        stringBuffer.append('0');
                    }
                    stringBuffer.append(n);
                    continue block44;
                }
                case 68: {
                    n = ExternalUtils.getDayOfWeek(bT747Time.getDay(), bT747Time.getMonth(), bT747Time.getYear());
                    stringBuffer.append(I18N.i18n(WEEKDAYS_AS_SHORTTEXT[n]));
                    continue block44;
                }
                case 106: {
                    n = bT747Time.getDay();
                    stringBuffer.append(n);
                    continue block44;
                }
                case 108: {
                    n = ExternalUtils.getDayOfWeek(bT747Time.getDay(), bT747Time.getMonth(), bT747Time.getYear());
                    stringBuffer.append(I18N.i18n(WEEKDAYS_AS_LONGTEXT[n]));
                    continue block44;
                }
                case 78: {
                    n = ExternalUtils.getDayOfWeek(bT747Time.getDay(), bT747Time.getMonth(), bT747Time.getYear());
                    if (n == 0) {
                        n = 7;
                    }
                    stringBuffer.append(n);
                    continue block44;
                }
                case 83: {
                    switch (bT747Time.getDay()) {
                        case 1: 
                        case 21: 
                        case 31: {
                            stringBuffer.append("st");
                            break;
                        }
                        case 2: 
                        case 14: 
                        case 15: 
                        case 16: 
                        case 17: 
                        case 18: 
                        case 19: 
                        case 22: {
                            stringBuffer.append("nd");
                            break;
                        }
                        case 3: 
                        case 23: {
                            stringBuffer.append("rd");
                            break;
                        }
                        case 4: 
                        case 5: 
                        case 6: 
                        case 7: 
                        case 8: 
                        case 9: 
                        case 10: 
                        case 11: 
                        case 12: 
                        case 20: 
                        case 24: 
                        case 25: 
                        case 26: 
                        case 27: 
                        case 28: 
                        case 29: 
                        case 30: {
                            stringBuffer.append("th");
                        }
                    }
                    continue block44;
                }
                case 119: {
                    n = ExternalUtils.getDayOfWeek(bT747Time.getDay(), bT747Time.getMonth(), bT747Time.getYear());
                    stringBuffer.append(n);
                    continue block44;
                }
                case 122: {
                    n = JavaLibBridge.getDateInstance(bT747Time.getDay(), bT747Time.getMonth(), bT747Time.getYear()).dateToUTCepoch1970() - JavaLibBridge.getDateInstance(1, 1, bT747Time.getYear()).dateToUTCepoch1970();
                    stringBuffer.append(n);
                    continue block44;
                }
                case 87: {
                    n = ExternalUtils.getDayOfWeek(1, 1, bT747Time.getYear());
                    int n2 = JavaLibBridge.getDateInstance(bT747Time.getDay(), bT747Time.getMonth(), bT747Time.getYear()).dateToUTCepoch1970() / 86400 - JavaLibBridge.getDateInstance(1, 1, bT747Time.getYear()).dateToUTCepoch1970() / 86400;
                    stringBuffer.append((n2 + 7 - n) / 7);
                    continue block44;
                }
                case 70: {
                    n = bT747Time.getMonth() - 1;
                    stringBuffer.append(I18N.i18n(MONTHS_AS_LONGTEXT[n]));
                    continue block44;
                }
                case 109: {
                    n = bT747Time.getMonth();
                    if (n < 10) {
                        stringBuffer.append('0');
                    }
                    stringBuffer.append(n);
                    continue block44;
                }
                case 77: {
                    String string2 = Conv.idxToShortMonthStr(bT747Time.getMonth() - 1);
                    stringBuffer.append(string2.charAt(0));
                    stringBuffer.append(string2.substring(1).toLowerCase());
                    continue block44;
                }
                case 110: {
                    n = bT747Time.getDay();
                    stringBuffer.append(n);
                    continue block44;
                }
                case 116: {
                    int n2 = bT747Time.getYear();
                    n = bT747Time.getMonth() - 1;
                    n2 = n == 1 && n2 % 4 == 0 && (n2 % 100 != 0 || n2 % 400 == 0) ? 1 : 0;
                    stringBuffer.append(daysInMonth[n] + n2);
                    continue block44;
                }
                case 76: {
                    continue block44;
                }
                case 111: {
                    continue block44;
                }
                case 89: {
                    stringBuffer.append(bT747Time.getYear());
                    continue block44;
                }
                case 121: {
                    stringBuffer.append(bT747Time.getYear() % 100);
                    continue block44;
                }
                case 97: {
                    if (bT747Time.getHour() < 12) {
                        stringBuffer.append("am");
                        continue block44;
                    }
                    stringBuffer.append("pm");
                    continue block44;
                }
                case 65: {
                    if (bT747Time.getHour() < 12) {
                        stringBuffer.append("AM");
                        continue block44;
                    }
                    stringBuffer.append("PM");
                    continue block44;
                }
                case 66: {
                    continue block44;
                }
                case 103: {
                    stringBuffer.append(bT747Time.getHour() % 12);
                    continue block44;
                }
                case 71: {
                    stringBuffer.append(bT747Time.getHour());
                    continue block44;
                }
                case 104: {
                    n = bT747Time.getHour() % 12;
                    if (n < 10) {
                        stringBuffer.append('0');
                    }
                    stringBuffer.append(n);
                    continue block44;
                }
                case 72: {
                    n = bT747Time.getHour();
                    if (n < 10) {
                        stringBuffer.append('0');
                    }
                    stringBuffer.append(n);
                    continue block44;
                }
                case 105: {
                    n = bT747Time.getMinute();
                    if (n < 10) {
                        stringBuffer.append('0');
                    }
                    stringBuffer.append(n);
                    continue block44;
                }
                case 115: {
                    n = bT747Time.getSecond();
                    if (n < 10) {
                        stringBuffer.append('0');
                    }
                    stringBuffer.append(n);
                    continue block44;
                }
                case 117: {
                    continue block44;
                }
                case 101: {
                    continue block44;
                }
                case 73: {
                    continue block44;
                }
                case 79: 
                case 80: {
                    continue block44;
                }
                case 84: {
                    continue block44;
                }
                case 90: {
                    continue block44;
                }
                case 99: {
                    stringBuffer.append(CommonOut.getDateTimeISO8601(bT747Time, 0));
                    continue block44;
                }
                case 114: {
                    continue block44;
                }
                case 85: {
                    n = JavaLibBridge.getDateInstance(bT747Time.getDay(), bT747Time.getMonth(), bT747Time.getYear()).dateToUTCepoch1970() + bT747Time.getHour() * 3600 + bT747Time.getMinute() * 60 + bT747Time.getSecond();
                    stringBuffer.append(n);
                    continue block44;
                }
                default: {
                    stringBuffer.append((char)n);
                }
            }
        }
        return stringBuffer.toString();
    }

    public static final String idxToShortMonthStr(int n) {
        return I18N.i18n(MONTHS_AS_SHORTTEXT[n]);
    }
}

