/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.io;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.Map;
import java.util.zip.ZipInputStream;
import javajs.api.GenericBinaryDocument;
import javajs.util.AU;
import javajs.util.PT;
import javajs.util.Rdr;
import org.jmol.api.Interface;
import org.jmol.util.Logger;
import org.jmol.viewer.Viewer;

public class FileReader {
    private final Viewer vwr;
    private String fileNameIn;
    private String fullPathNameIn;
    private String nameAsGivenIn;
    private String fileTypeIn;
    private Object atomSetCollection;
    private Object readerOrDocument;
    private Map<String, Object> htParams;
    private boolean isAppend;
    private Object bytesOrStream;

    public FileReader(Viewer vwr, String fileName, String fullPathName, String nameAsGiven, String type, Object reader, Map<String, Object> htParams, boolean isAppend) {
        this.vwr = vwr;
        this.fileNameIn = fileName == null ? fullPathName : fileName;
        this.fullPathNameIn = fullPathName == null ? this.fileNameIn : fullPathName;
        this.nameAsGivenIn = nameAsGiven == null ? this.fileNameIn : nameAsGiven;
        this.fileTypeIn = type;
        if (reader != null) {
            if (AU.isAB(reader) || reader instanceof BufferedInputStream) {
                this.bytesOrStream = reader;
                reader = null;
            } else if (reader instanceof Reader && !(reader instanceof BufferedReader)) {
                reader = new BufferedReader((Reader)reader);
            }
        }
        this.readerOrDocument = reader;
        this.htParams = htParams;
        this.isAppend = isAppend;
    }

    public void run() {
        if (!this.isAppend && this.vwr.displayLoadErrors) {
            this.vwr.zap(false, true, false);
        }
        String errorMessage = null;
        Object t = null;
        if (this.fullPathNameIn.contains("#_DOCACHE_")) {
            this.readerOrDocument = FileReader.getChangeableReader(this.vwr, this.nameAsGivenIn, this.fullPathNameIn);
        }
        if (this.readerOrDocument == null) {
            t = this.vwr.fm.getUnzippedReaderOrStreamFromName(this.fullPathNameIn, this.bytesOrStream, true, false, false, true, this.htParams);
            if (t == null || t instanceof String) {
                String string = errorMessage = t == null ? "error opening:" + this.nameAsGivenIn : (String)t;
                if (!errorMessage.startsWith("NOTE:")) {
                    Logger.error("file ERROR: " + this.fullPathNameIn + "\n" + errorMessage);
                }
                this.atomSetCollection = errorMessage;
                return;
            }
            if (t instanceof BufferedReader) {
                this.readerOrDocument = t;
            } else if (t instanceof ZipInputStream) {
                String name = this.fullPathNameIn;
                String[] subFileList = null;
                if ((name = name.replace('\\', '/')).indexOf("|") >= 0 && !name.endsWith(".zip")) {
                    subFileList = PT.split(name, "|");
                    name = subFileList[0];
                }
                if (subFileList != null) {
                    this.htParams.put("subFileList", subFileList);
                }
                InputStream zis = (InputStream)t;
                String[] zipDirectory = this.vwr.fm.getZipDirectory(name, true, true);
                this.atomSetCollection = t = this.vwr.fm.getJzu().getAtomSetCollectionOrBufferedReaderFromZip(this.vwr, zis, name, zipDirectory, this.htParams, 1, false);
                try {
                    zis.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        if (t instanceof BufferedInputStream) {
            this.readerOrDocument = ((GenericBinaryDocument)Interface.getInterface("javajs.util.BinaryDocument", this.vwr, "file")).setStream((BufferedInputStream)t, !this.htParams.containsKey("isLittleEndian"));
        }
        if (this.readerOrDocument != null) {
            this.atomSetCollection = this.vwr.getModelAdapter().getAtomSetCollectionReader(this.fullPathNameIn, this.fileTypeIn, this.readerOrDocument, this.htParams);
            if (!(this.atomSetCollection instanceof String)) {
                this.atomSetCollection = this.vwr.getModelAdapter().getAtomSetCollection(this.atomSetCollection);
            }
            try {
                if (this.readerOrDocument instanceof BufferedReader) {
                    ((BufferedReader)this.readerOrDocument).close();
                } else if (this.readerOrDocument instanceof GenericBinaryDocument) {
                    ((GenericBinaryDocument)this.readerOrDocument).close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (this.atomSetCollection instanceof String) {
            return;
        }
        if (!this.isAppend && !this.vwr.displayLoadErrors) {
            this.vwr.zap(false, true, false);
        }
        this.vwr.fm.setFileInfo(new String[]{this.fullPathNameIn, this.fileNameIn, this.nameAsGivenIn});
    }

    static final BufferedReader getChangeableReader(Viewer vwr, String nameAsGivenIn, String fullPathNameIn) {
        return Rdr.getBR((String)vwr.getLigandModel(nameAsGivenIn, fullPathNameIn, "_file", null));
    }

    public Object getAtomSetCollection() {
        return this.atomSetCollection;
    }
}

