/*
 * Decompiled with CFR 0.152.
 */
package mediathek.javafx.filmlist;

import javafx.application.Platform;
import javafx.scene.Node;
import javafx.scene.layout.HBox;
import javax.swing.SwingUtilities;
import mediathek.config.Daten;
import mediathek.filmeSuchen.ListenerFilmeLaden;
import mediathek.filmeSuchen.ListenerFilmeLadenEvent;
import mediathek.javafx.CenteredBorderPane;
import mediathek.javafx.VerticalSeparator;
import mediathek.javafx.filmlist.FilmListAgeLabel;
import mediathek.javafx.filmlist.FilmListCreationDateLabel;
import mediathek.tool.MessageBus;

public class FilmListInfoPane
extends HBox {
    private final FilmListCreationDateLabel filmListCreationDateLabel;
    private final FilmListAgeLabel filmListAgeLabel;

    public FilmListInfoPane(Daten daten) {
        this.setSpacing(4.0);
        SwingUtilities.invokeLater(() -> daten.getFilmeLaden().addAdListener(new ListenerFilmeLaden(){

            @Override
            public void start(ListenerFilmeLadenEvent event) {
                MessageBus.getMessageBus().unsubscribe(this);
                Platform.runLater(() -> FilmListInfoPane.this.setVisible(false));
            }

            @Override
            public void fertig(ListenerFilmeLadenEvent event) {
                MessageBus.getMessageBus().subscribe(this);
                Platform.runLater(() -> {
                    FilmListInfoPane.this.filmListCreationDateLabel.computeCreationDate();
                    FilmListInfoPane.this.setVisible(true);
                });
            }
        }));
        this.filmListCreationDateLabel = new FilmListCreationDateLabel(daten);
        this.filmListAgeLabel = new FilmListAgeLabel();
        this.getChildren().addAll((Node[])new Node[]{new CenteredBorderPane((Node)this.filmListCreationDateLabel), new VerticalSeparator(), new CenteredBorderPane((Node)this.filmListAgeLabel)});
    }

    public FilmListAgeLabel getFilmListAgeLabel() {
        return this.filmListAgeLabel;
    }
}

