(self.webpackChunkbookmarks=self.webpackChunkbookmarks||[]).push([["src_components_BookmarkContent_vue-src_components_BookmarksList_vue-src_components_Controls_vue"],{69552:(t,n,e)=>{"use strict";e.d(n,{Z:()=>i});var o=e(23645),r=e.n(o)()(!0);r.push([t.id,"\n.bookmark__icon {\n\tdisplay: inline-block;\n\tflex: 0;\n\theight: 20px;\n\twidth: 20px;\n\tbackground-size: cover;\n\tmargin: 0 15px;\n\tposition: relative;\n\ttop: 3px;\n}\n.bookmark__title {\n\tdisplay: flex;\n\tmin-width: calc(50px + 40%);\n}\n.bookmark__title,\n.bookmark__title > h3 {\n\ttext-overflow: ellipsis;\n\toverflow: hidden;\n\twhite-space: nowrap;\n}\n.bookmark__title > h3 {\n\tmargin: 0;\n}\n.bookmark__description {\n\tdisplay: inline-block;\n\tflex: 1;\n\tmargin: auto 10px;\n\theight: 20px;\n\tcolor: var(--color-text-lighter);\n\ttext-overflow: ellipsis;\n\toverflow: hidden;\n\tmin-width: 20px;\n}\n.bookmark__description figure {\n\tdisplay: none !important;\n}\n.item--gridview .bookmark__title {\n\tmin-width: auto;\n}\n.item--gridview .bookmark__description {\n\tflex: 0;\n}\n.item--gridview .bookmark__description figure {\n\tdisplay: inline-block !important;\n\tposition: relative;\n\ttop: 5px;\n}\n.item--gridview .bookmark__icon {\n\tmargin: 0 5px 0 8px;\n}\n","",{version:3,sources:["webpack://src/components/Bookmark.vue"],names:[],mappings:";AAuPA;CACA,qBAAA;CACA,OAAA;CACA,YAAA;CACA,WAAA;CACA,sBAAA;CACA,cAAA;CACA,kBAAA;CACA,QAAA;AACA;AAEA;CACA,aAAA;CACA,2BAAA;AACA;AAEA;;CAEA,uBAAA;CACA,gBAAA;CACA,mBAAA;AACA;AAEA;CACA,SAAA;AACA;AAEA;CACA,qBAAA;CACA,OAAA;CACA,iBAAA;CACA,YAAA;CACA,gCAAA;CACA,uBAAA;CACA,gBAAA;CACA,eAAA;AACA;AAEA;CACA,wBAAA;AACA;AAEA;CACA,eAAA;AACA;AAEA;CACA,OAAA;AACA;AAEA;CACA,gCAAA;CACA,kBAAA;CACA,QAAA;AACA;AAEA;CACA,mBAAA;AACA",sourcesContent:["\x3c!--\n  - Copyright (c) 2020. The Nextcloud Bookmarks contributors.\n  -\n  - This file is licensed under the Affero General Public License version 3 or later. See the COPYING file.\n  --\x3e\n\n<template>\n\t<Item\n\t\t:title=\"bookmark.title\"\n\t\t:tags=\"bookmark.tags\"\n\t\t:rename-placeholder=\"t('bookmarks', 'Enter new title')\"\n\t\t:select-label=\"t('bookmarks', 'Select bookmark')\"\n\t\t:active=\"isActive\"\n\t\t:editable=\"isEditable\"\n\t\t:selected=\"selected\"\n\t\t:draggable=\"isEditable\"\n\t\t:renaming=\"renaming\"\n\t\t:background=\"background\"\n\t\t:url=\"url\"\n\t\t:selectable=\"selectable\"\n\t\t@select=\"onSelect\"\n\t\t@rename=\"onRenameSubmit\"\n\t\t@rename-cancel=\"renaming = false\"\n\t\t@click=\"onClick\">\n\t\t<template #title>\n\t\t\t<div class=\"bookmark__title\">\n\t\t\t\t<h3 :title=\"bookmark.title\">\n\t\t\t\t\t<span v-if=\"bookmark.preliminary\" class=\"icon-loading-small bookmark__icon\" />\n\t\t\t\t\t<figure\n\t\t\t\t\t\tv-else\n\t\t\t\t\t\tclass=\"bookmark__icon\"\n\t\t\t\t\t\t:style=\"{ backgroundImage: 'url(' + iconUrl + ')' }\" />\n\t\t\t\t\t{{ bookmark.title }}\n\t\t\t\t</h3>\n\t\t\t\t<span\n\t\t\t\t\tv-if=\"bookmark.description\"\n\t\t\t\t\tv-tooltip=\"bookmark.description\"\n\t\t\t\t\tclass=\"bookmark__description\"><figure class=\"icon-file\" />\n\t\t\t\t\t{{ bookmark.description }}</span>\n\t\t\t</div>\n\t\t</template>\n\t\t<template #actions>\n\t\t\t<ActionButton\n\t\t\t\ticon=\"icon-info\"\n\t\t\t\t:close-after-click=\"true\"\n\t\t\t\t@click=\"onDetails\">\n\t\t\t\t{{ t('bookmarks', 'Details') }}\n\t\t\t</ActionButton>\n\t\t\t<ActionCheckbox @change=\"onSelect\">\n\t\t\t\t{{ t('bookmarks', 'Select bookmark') }}\n\t\t\t</ActionCheckbox>\n\t\t\t<ActionButton\n\t\t\t\ticon=\"icon-rename\"\n\t\t\t\t:close-after-click=\"true\"\n\t\t\t\t@click=\"onRename\">\n\t\t\t\t{{ t('bookmarks', 'Rename') }}\n\t\t\t</ActionButton>\n\t\t\t<ActionButton :close-after-click=\"true\" @click=\"onMove\">\n\t\t\t\t<template #icon>\n\t\t\t\t\t<FolderMoveIcon\n\t\t\t\t\t\t:fill-color=\"colorMainText\" />\n\t\t\t\t</template>\n\t\t\t\t{{ t('bookmarks', 'Move') }}\n\t\t\t</ActionButton>\n\t\t\t<ActionButton :close-after-click=\"true\" @click=\"onCopy\">\n\t\t\t\t<template #icon>\n\t\t\t\t\t<FolderPlusIcon\n\t\t\t\t\t\t:fill-color=\"colorMainText\" />\n\t\t\t\t</template>\n\t\t\t\t{{ t('bookmarks', 'Add to folders') }}\n\t\t\t</ActionButton>\n\t\t\t<ActionButton\n\t\t\t\ticon=\"icon-delete\"\n\t\t\t\t:close-after-click=\"true\"\n\t\t\t\t@click=\"onDelete\">\n\t\t\t\t{{ t('bookmarks', 'Delete') }}\n\t\t\t</ActionButton>\n\t\t</template>\n\t</Item>\n</template>\n<script>\nimport Item from './Item'\nimport ActionButton from '@nextcloud/vue/dist/Components/ActionButton'\nimport ActionCheckbox from '@nextcloud/vue/dist/Components/ActionCheckbox'\nimport FolderPlusIcon from 'vue-material-design-icons/FolderPlus'\nimport FolderMoveIcon from 'vue-material-design-icons/FolderMove'\nimport { getCurrentUser } from '@nextcloud/auth'\nimport { generateUrl } from '@nextcloud/router'\nimport { actions, mutations } from '../store/'\n\nexport default {\n\tname: 'Bookmark',\n\tcomponents: {\n\t\tItem,\n\t\tActionButton,\n\t\tActionCheckbox,\n\t\tFolderPlusIcon,\n\t\tFolderMoveIcon,\n\t},\n\tprops: {\n\t\tbookmark: {\n\t\t\ttype: Object,\n\t\t\trequired: true,\n\t\t},\n\t},\n\tdata() {\n\t\treturn {\n\t\t\ttitle: this.bookmark.title,\n\t\t\trenaming: false,\n\t\t}\n\t},\n\tcomputed: {\n\t\tapiUrl() {\n\t\t\tif (this.isPublic) {\n\t\t\t\treturn generateUrl('/apps/bookmarks/public/rest/v2')\n\t\t\t}\n\t\t\treturn generateUrl('/apps/bookmarks')\n\t\t},\n\t\ticonUrl() {\n\t\t\treturn (\n\t\t\t\tthis.apiUrl\n\t\t\t\t+ '/bookmark/'\n\t\t\t\t+ this.bookmark.id\n\t\t\t\t+ '/favicon'\n\t\t\t\t+ (this.$store.state.public\n\t\t\t\t\t? '?token=' + this.$store.state.authToken\n\t\t\t\t\t: '')\n\t\t\t)\n\t\t},\n\t\timageUrl() {\n\t\t\treturn (\n\t\t\t\tthis.apiUrl\n\t\t\t\t+ '/bookmark/'\n\t\t\t\t+ this.bookmark.id\n\t\t\t\t+ '/image'\n\t\t\t\t+ (this.$store.state.public\n\t\t\t\t\t? '?token=' + this.$store.state.authToken\n\t\t\t\t\t: '')\n\t\t\t)\n\t\t},\n\t\tbackground() {\n\t\t\treturn this.viewMode === 'grid'\n\t\t\t\t? `linear-gradient(0deg, var(--color-main-background) 25%, rgba(0, 212, 255, 0) 50%), url('${this.imageUrl}')`\n\t\t\t\t: undefined\n\t\t},\n\t\turl() {\n\t\t\treturn this.bookmark.url\n\t\t},\n\t\tisOpen() {\n\t\t\treturn this.$store.state.sidebar\n\t\t\t\t&& this.$store.state.sidebar.type === 'bookmark'\n\t\t\t\t? this.$store.state.sidebar.id === this.bookmark.id\n\t\t\t\t: false\n\t\t},\n\t\tviewMode() {\n\t\t\treturn this.$store.state.viewMode\n\t\t},\n\t\tisOwner() {\n\t\t\tconst currentUser = getCurrentUser()\n\t\t\treturn currentUser && this.bookmark.userId === currentUser.uid\n\t\t},\n\t\tpermissions() {\n\t\t\treturn this.$store.getters.getPermissionsForBookmark(\n\t\t\t\tthis.bookmark.id\n\t\t\t)\n\t\t},\n\t\tisEditable() {\n\t\t\treturn this.isOwner || (!this.isOwner && this.permissions.canWrite)\n\t\t},\n\t\tselectedBookmarks() {\n\t\t\treturn this.$store.state.selection.bookmarks\n\t\t},\n\t\tselectable() {\n\t\t\treturn Boolean(\n\t\t\t\tthis.$store.state.selection.bookmarks.length\n\t\t\t\t\t|| this.$store.state.selection.folders.length\n\t\t\t)\n\t\t},\n\t\tselected() {\n\t\t\treturn this.selectedBookmarks\n\t\t\t\t.map(b => b.id)\n\t\t\t\t.includes(this.bookmark.id)\n\t\t},\n\t\tisActive() {\n\t\t\treturn this.isOpen || this.selected\n\t\t},\n\t},\n\tcreated() {},\n\tmethods: {\n\t\tonDelete() {\n\t\t\tif (\n\t\t\t\t!confirm(\n\t\t\t\t\tt(\n\t\t\t\t\t\t'bookmarks',\n\t\t\t\t\t\t'Do you really want to delete this bookmark?'\n\t\t\t\t\t)\n\t\t\t\t)\n\t\t\t) {\n\t\t\t\treturn\n\t\t\t}\n\t\t\tthis.$store.dispatch(actions.DELETE_BOOKMARK, {\n\t\t\t\tid: this.bookmark.id,\n\t\t\t\tfolder: this.$store.state.fetchState.query.folder,\n\t\t\t})\n\t\t},\n\t\tonDetails() {\n\t\t\tthis.$store.dispatch(actions.OPEN_BOOKMARK, this.bookmark.id)\n\t\t},\n\t\tonMove() {\n\t\t\tthis.$store.commit(mutations.RESET_SELECTION)\n\t\t\tthis.$store.commit(mutations.ADD_SELECTION_BOOKMARK, this.bookmark)\n\t\t\tthis.$store.commit(mutations.DISPLAY_MOVE_DIALOG, true)\n\t\t},\n\t\tonCopy() {\n\t\t\tthis.$store.commit(mutations.RESET_SELECTION)\n\t\t\tthis.$store.commit(mutations.ADD_SELECTION_BOOKMARK, this.bookmark)\n\t\t\tthis.$store.commit(mutations.DISPLAY_COPY_DIALOG, true)\n\t\t},\n\t\tasync onRename() {\n\t\t\tthis.renaming = true\n\t\t},\n\t\tasync onRenameSubmit(title) {\n\t\t\t// eslint-disable-next-line vue/no-mutating-props\n\t\t\tthis.bookmark.title = title\n\t\t\tawait this.$store.dispatch(actions.SAVE_BOOKMARK, this.bookmark.id)\n\t\t\tthis.renaming = false\n\t\t},\n\t\tonSelect() {\n\t\t\tif (!this.selected) {\n\t\t\t\tthis.$store.commit(\n\t\t\t\t\tmutations.ADD_SELECTION_BOOKMARK,\n\t\t\t\t\tthis.bookmark\n\t\t\t\t)\n\t\t\t} else {\n\t\t\t\tthis.$store.commit(\n\t\t\t\t\tmutations.REMOVE_SELECTION_BOOKMARK,\n\t\t\t\t\tthis.bookmark\n\t\t\t\t)\n\t\t\t}\n\t\t},\n\t\tonClick() {\n\t\t\tthis.$store.dispatch(actions.CLICK_BOOKMARK, this.bookmark)\n\t\t},\n\t},\n}\n<\/script>\n<style>\n.bookmark__icon {\n\tdisplay: inline-block;\n\tflex: 0;\n\theight: 20px;\n\twidth: 20px;\n\tbackground-size: cover;\n\tmargin: 0 15px;\n\tposition: relative;\n\ttop: 3px;\n}\n\n.bookmark__title {\n\tdisplay: flex;\n\tmin-width: calc(50px + 40%);\n}\n\n.bookmark__title,\n.bookmark__title > h3 {\n\ttext-overflow: ellipsis;\n\toverflow: hidden;\n\twhite-space: nowrap;\n}\n\n.bookmark__title > h3 {\n\tmargin: 0;\n}\n\n.bookmark__description {\n\tdisplay: inline-block;\n\tflex: 1;\n\tmargin: auto 10px;\n\theight: 20px;\n\tcolor: var(--color-text-lighter);\n\ttext-overflow: ellipsis;\n\toverflow: hidden;\n\tmin-width: 20px;\n}\n\n.bookmark__description figure {\n\tdisplay: none !important;\n}\n\n.item--gridview .bookmark__title {\n\tmin-width: auto;\n}\n\n.item--gridview .bookmark__description {\n\tflex: 0;\n}\n\n.item--gridview .bookmark__description figure {\n\tdisplay: inline-block !important;\n\tposition: relative;\n\ttop: 5px;\n}\n\n.item--gridview .bookmark__icon {\n\tmargin: 0 5px 0 8px;\n}\n</style>\n"],sourceRoot:""}]);const i=r},47344:(t,n,e)=>{"use strict";e.d(n,{Z:()=>i});var o=e(23645),r=e.n(o)()(!0);r.push([t.id,"\n.bookmark-content {\n\tposition: absolute;\n\ttop: 50px;/* nc header bar */\n\tleft: 0;\n\tright: max( min(27vw, 500px), 300px); /* side bar */\n\tbottom: 0;\n\tbackground: var(--color-main-background);\n\tz-index: 1999;\n\tdisplay: flex;\n\toverflow: scroll;\n\tflex-direction: column;\n}\n.bookmark-content .content {\n\tmargin: 30px auto;\n\twidth: 600px;\n\tfont-size: 15px;\n\ttext-align: justify;\n\tposition: relative;\n\tflex-grow: 1;\n}\n.bookmark-content .content.iframe {\n\tmargin: 0;\n\tposition: relative;\n\toverflow: hidden;\n\twidth: auto;\n}\n.bookmark-content .content iframe {\n\theight: 100%;\n\twidth: 100%;\n}\n.bookmark-content h1, .bookmark-content h2, .bookmark-content h3, .bookmark-content h4, .bookmark-content h5, .bookmark-content p {\n\tmargin-top: 10px !important;\n}\n.bookmark-content a:link,\n.bookmark-content a[href] {\n\ttext-decoration: underline !important;\n}\n","",{version:3,sources:["webpack://src/components/BookmarkContent.vue"],names:[],mappings:";AAoEA;CACA,kBAAA;CACA,SAAA,CAAA,kBAAA;CACA,OAAA;CACA,oCAAA,EAAA,aAAA;CACA,SAAA;CACA,wCAAA;CACA,aAAA;CACA,aAAA;CACA,gBAAA;CACA,sBAAA;AACA;AAEA;CACA,iBAAA;CACA,YAAA;CACA,eAAA;CACA,mBAAA;CACA,kBAAA;CACA,YAAA;AACA;AAEA;CACA,SAAA;CACA,kBAAA;CACA,gBAAA;CACA,WAAA;AACA;AAEA;CACA,YAAA;CACA,WAAA;AACA;AAEA;CACA,2BAAA;AACA;AAEA;;CAEA,qCAAA;AACA",sourcesContent:["\x3c!--\n  - Copyright (c) 2021. The Nextcloud Bookmarks contributors.\n  -\n  - This file is licensed under the Affero General Public License version 3 or later. See the COPYING file.\n  --\x3e\n\n<template>\n\t<div v-if=\"isActive && hasMinLength\" class=\"bookmark-content\">\n\t\t<template v-if=\"archivedFile\">\n\t\t\t<div class=\"content iframe\">\n\t\t\t\t<iframe :src=\"archivedFileUrl\" />\n\t\t\t</div>\n\t\t</template>\n\t\t<div v-else-if=\"bookmark.textContent\" class=\"content\" v-html=\"content\" />\n\t\t<div v-else>\n\t\t\t<EmptyContent icon=\"icon-download\">\n\t\t\t\t{{ t('bookmarks', 'Content pending') }}\n\t\t\t\t<template #desc>\n\t\t\t\t\t{{ t('bookmarks', 'This content is being downloaded for offline use. Please check back later.') }}\n\t\t\t\t</template>\n\t\t\t</EmptyContent>\n\t\t</div>\n\t</div>\n</template>\n\n<script>\nimport sanitizeHtml from 'sanitize-html'\nimport { generateUrl, generateRemoteUrl } from '@nextcloud/router'\nimport EmptyContent from '@nextcloud/vue/dist/Components/EmptyContent'\n\nconst MIN_TEXT_LENGTH = 350\n\nexport default {\n\tname: 'BookmarkContent',\n\tcomponents: { EmptyContent },\n\tcomputed: {\n\t\tisActive() {\n\t\t\tif (!this.$store.state.sidebar) return false\n\t\t\treturn this.$store.state.sidebar.type === 'bookmark'\n\t\t},\n\t\tbookmark() {\n\t\t\tif (!this.isActive) return\n\t\t\treturn this.$store.getters.getBookmark(this.$store.state.sidebar.id)\n\t\t},\n\t\thasMinLength() {\n\t\t\treturn !this.bookmark.textContent || this.bookmark.textContent.length >= MIN_TEXT_LENGTH\n\t\t},\n\t\tcontent() {\n\t\t\treturn sanitizeHtml(this.bookmark.htmlContent, {\n\t\t\t\tallowProtocolRelative: false,\n\t\t\t})\n\t\t},\n\t\tarchivedFileUrl() {\n\t\t\t// remove `/username/files/`\n\t\t\tconst barePath = this.bookmark.archivedFilePath.split('/').slice(3).join('/')\n\t\t\treturn generateRemoteUrl(`webdav/${barePath}`)\n\t\t},\n\t\tarchivedFile() {\n\t\t\tif (this.bookmark.archivedFile) {\n\t\t\t\treturn generateUrl(`/apps/files/?fileid=${this.bookmark.archivedFile}`)\n\t\t\t}\n\t\t\treturn null\n\t\t},\n\t},\n}\n<\/script>\n\n<style>\n.bookmark-content {\n\tposition: absolute;\n\ttop: 50px;/* nc header bar */\n\tleft: 0;\n\tright: max( min(27vw, 500px), 300px); /* side bar */\n\tbottom: 0;\n\tbackground: var(--color-main-background);\n\tz-index: 1999;\n\tdisplay: flex;\n\toverflow: scroll;\n\tflex-direction: column;\n}\n\n.bookmark-content .content {\n\tmargin: 30px auto;\n\twidth: 600px;\n\tfont-size: 15px;\n\ttext-align: justify;\n\tposition: relative;\n\tflex-grow: 1;\n}\n\n.bookmark-content .content.iframe {\n\tmargin: 0;\n\tposition: relative;\n\toverflow: hidden;\n\twidth: auto;\n}\n\n.bookmark-content .content iframe {\n\theight: 100%;\n\twidth: 100%;\n}\n\n.bookmark-content h1, .bookmark-content h2, .bookmark-content h3, .bookmark-content h4, .bookmark-content h5, .bookmark-content p {\n\tmargin-top: 10px !important;\n}\n\n.bookmark-content a:link,\n.bookmark-content a[href] {\n\ttext-decoration: underline !important;\n}\n</style>\n"],sourceRoot:""}]);const i=r},95674:(t,n,e)=>{"use strict";e.d(n,{Z:()=>i});var o=e(23645),r=e.n(o)()(!0);r.push([t.id,"\n.bookmarkslist {\n\t/* 50px header; 50px breadcrumbs */\n\theight: calc(100vh - 50px - 50px);\n\toverflow-y: scroll;\n\tposition: relative;\n}\n.bookmarkslist .padding {\n\tmax-width: calc((250px + 10px + 10px) * 4);\n\tmargin: 0 auto;\n}\n.bookmarkslist__empty {\n\twidth: 200px;\n\tmargin: 200px auto;\n}\n.bookmarkslist__description {\n\twidth: 100%;\n\tmargin: 10px auto;\n\tflex-grow: 1;\n\tflex-shrink: 0;\n\ttext-align: center;\n}\n.bookmarkslist__loading {\n\twidth: 100%;\n\tmargin: 200px auto;\n\tflex-grow: 1;\n\tflex-shrink: 0;\n\ttext-align: center;\n}\n.bookmarkslist--gridview .padding {\n\tdisplay: flex;\n\tflex-flow: wrap;\n\talign-content: start;\n\tgap: 10px;\n\tpadding: 0 10px;\n}\n.folder--gridview,\n.bookmark--gridview,\n.bookmarkslist--gridview .create-folder,\n.bookmarkslist--gridview .create-bookmark {\n\twidth: 250px;\n\theight: 200px;\n\talign-items: flex-end;\n\tbackground: var(--color-main-background);\n\tborder: 1px solid var(--color-border);\n\tbox-shadow: #efefef7d 0px 0 13px 0px inset;\n\tborder-radius: var(--border-radius);\n}\n","",{version:3,sources:["webpack://src/components/BookmarksList.vue"],names:[],mappings:";AAiKA;CACA,kCAAA;CACA,iCAAA;CACA,kBAAA;CACA,kBAAA;AACA;AAEA;CACA,0CAAA;CACA,cAAA;AACA;AAEA;CACA,YAAA;CACA,kBAAA;AACA;AAEA;CACA,WAAA;CACA,iBAAA;CACA,YAAA;CACA,cAAA;CACA,kBAAA;AACA;AAEA;CACA,WAAA;CACA,kBAAA;CACA,YAAA;CACA,cAAA;CACA,kBAAA;AACA;AAEA;CACA,aAAA;CACA,eAAA;CACA,oBAAA;CACA,SAAA;CACA,eAAA;AACA;AAEA;;;;CAIA,YAAA;CACA,aAAA;CACA,qBAAA;CACA,wCAAA;CACA,qCAAA;CACA,0CAAA;CACA,mCAAA;AACA",sourcesContent:['\x3c!--\n  - Copyright (c) 2020. The Nextcloud Bookmarks contributors.\n  -\n  - This file is licensed under the Affero General Public License version 3 or later. See the COPYING file.\n  --\x3e\n\n<template>\n\t<div\n\t\t:class="{\n\t\t\tbookmarkslist: true,\n\t\t\t\'bookmarkslist--gridview\': viewMode === \'grid\'\n\t\t}"\n\t\t@scroll="onScroll">\n\t\t<div class="padding">\n\t\t\t<div v-if="$route.name === routes.ARCHIVED && bookmarks.length" class="bookmarkslist__description">\n\t\t\t\t{{\n\t\t\t\t\tt(\'bookmarks\', \'Bookmarks to files on the web like photos or PDFs will automatically be saved to your Nextcloud files, so you can still find them even when the link goes offline.\')\n\t\t\t\t}}\n\t\t\t</div>\n\t\t\t<CreateBookmark v-if="newBookmark" />\n\t\t\t<CreateFolder v-if="newFolder" />\n\t\t\t<template v-if="$route.name === routes.FOLDER || $route.name === routes.HOME">\n\t\t\t\t\x3c!-- FOLDER VIEW WITH CUSTOM SORTING --\x3e\n\t\t\t\t<template v-if="sortOrder === \'index\' && children.length">\n\t\t\t\t\t<template v-for="item in children">\n\t\t\t\t\t\t<Folder\n\t\t\t\t\t\t\tv-if="item.type === \'folder\' && getFolder(item.id)"\n\t\t\t\t\t\t\t:key="item.type + item.id"\n\t\t\t\t\t\t\t:folder="getFolder(item.id)" />\n\t\t\t\t\t\t<Bookmark\n\t\t\t\t\t\t\tv-if="item.type === \'bookmark\' && getBookmark(item.id)"\n\t\t\t\t\t\t\t:key="item.type + item.id"\n\t\t\t\t\t\t\t:bookmark="getBookmark(item.id)" />\n\t\t\t\t\t</template>\n\t\t\t\t</template>\n\t\t\t\t\x3c!-- FOLDER VIEW WITH NORMAL SORTING --\x3e\n\t\t\t\t<template v-else-if="(subFolders.length || bookmarks.length) && !loading">\n\t\t\t\t\t<Folder\n\t\t\t\t\t\tv-for="folder in subFolders"\n\t\t\t\t\t\t:key="\'folder\' + folder.id"\n\t\t\t\t\t\t:folder="folder" />\n\t\t\t\t\t<template v-if="bookmarks.length">\n\t\t\t\t\t\t<Bookmark\n\t\t\t\t\t\t\tv-for="bookmark in bookmarks"\n\t\t\t\t\t\t\t:key="\'bookmark\' + bookmark.id"\n\t\t\t\t\t\t\t:bookmark="bookmark" />\n\t\t\t\t\t</template>\n\t\t\t\t</template>\n\t\t\t\t<NoBookmarks v-else-if="!loading" />\n\t\t\t</template>\n\t\t\t\x3c!-- NON-FOLDER VIEW --\x3e\n\t\t\t<template v-else-if="bookmarks.length">\n\t\t\t\t<Bookmark\n\t\t\t\t\tv-for="bookmark in bookmarks"\n\t\t\t\t\t:key="\'bookmark\' + bookmark.id"\n\t\t\t\t\t:bookmark="bookmark" />\n\t\t\t</template>\n\t\t\t<NoBookmarks v-else-if="!loading" />\n\t\t\t<div v-if="showLoading" class="bookmarkslist__loading">\n\t\t\t\t<figure class="icon-loading" />\n\t\t\t</div>\n\t\t</div>\n\t</div>\n</template>\n\n<script>\nimport Bookmark from \'./Bookmark\'\nimport Folder from \'./Folder\'\nimport CreateBookmark from \'./CreateBookmark\'\nimport CreateFolder from \'./CreateFolder\'\nimport { actions } from \'../store\'\nimport NoBookmarks from \'./NoBookmarks\'\n\nexport default {\n\tname: \'BookmarksList\',\n\tcomponents: {\n\t\tNoBookmarks,\n\t\tBookmark,\n\t\tFolder,\n\t\tCreateBookmark,\n\t\tCreateFolder,\n\t},\n\tprops: {\n\t\tbookmarks: {\n\t\t\ttype: Array,\n\t\t\trequired: true,\n\t\t},\n\t},\n\tdata() {\n\t\treturn {\n\t\t\tshowLoading: true,\n\t\t\tloadingTimeout: null,\n\t\t}\n\t},\n\tcomputed: {\n\t\tchildren() {\n\t\t\tif (this.$route.name !== this.routes.HOME && this.$route.name !== this.routes.FOLDER) {\n\t\t\t\treturn []\n\t\t\t}\n\t\t\tconst folderId = this.$route.params.folder || \'-1\'\n\t\t\tif (!folderId) return []\n\t\t\treturn this.$store.getters.getFolderChildren(folderId)\n\t\t},\n\t\tsubFolders() {\n\t\t\tif (this.$route.name !== this.routes.HOME && this.$route.name !== this.routes.FOLDER) {\n\t\t\t\treturn []\n\t\t\t}\n\t\t\tconst folderId = this.$route.params.folder || \'-1\'\n\t\t\tif (!folderId) return []\n\t\t\tconst folder = this.$store.getters.getFolder(folderId)[0]\n\t\t\tif (!folder) return []\n\t\t\tthis.$store.dispatch(actions.LOAD_SHARES_OF_FOLDER, folderId)\n\t\t\treturn folder.children\n\t\t},\n\t\tnewBookmark() {\n\t\t\treturn this.$store.state.displayNewBookmark\n\t\t},\n\t\tnewFolder() {\n\t\t\treturn this.$store.state.displayNewFolder\n\t\t},\n\t\tviewMode() {\n\t\t\treturn this.$store.state.viewMode\n\t\t},\n\t\tsortOrder() {\n\t\t\treturn this.$store.state.settings.sorting\n\t\t},\n\t\tloading() {\n\t\t\treturn this.$store.state.loading.bookmarks || this.$store.state.loading.folders\n\t\t},\n\t},\n\twatch: {\n\t\tloading(state, previous) {\n\t\t\tif (state && !previous) {\n\t\t\t\tthis.loadingTimeout = setTimeout(() => {\n\t\t\t\t\tthis.showLoading = true\n\t\t\t\t}, 500)\n\t\t\t} else if (!state && previous) {\n\t\t\t\tclearTimeout(this.loadingTimeout)\n\t\t\t\tthis.showLoading = false\n\t\t\t}\n\t\t},\n\t},\n\tmethods: {\n\t\tonScroll() {\n\t\t\tif (\n\t\t\t\tthis.$el.scrollHeight\n\t\t\t\t\t< this.$el.scrollTop + this.$el.clientHeight + 500\n\t\t\t) {\n\t\t\t\tthis.$store.dispatch(actions.FETCH_PAGE)\n\t\t\t}\n\t\t},\n\t\tgetFolder(id) {\n\t\t\treturn this.$store.getters.getFolder(id)[0]\n\t\t},\n\t\tgetBookmark(id) {\n\t\t\treturn this.$store.getters.getBookmark(id)\n\t\t},\n\t},\n}\n<\/script>\n<style>\n.bookmarkslist {\n\t/* 50px header; 50px breadcrumbs */\n\theight: calc(100vh - 50px - 50px);\n\toverflow-y: scroll;\n\tposition: relative;\n}\n\n.bookmarkslist .padding {\n\tmax-width: calc((250px + 10px + 10px) * 4);\n\tmargin: 0 auto;\n}\n\n.bookmarkslist__empty {\n\twidth: 200px;\n\tmargin: 200px auto;\n}\n\n.bookmarkslist__description {\n\twidth: 100%;\n\tmargin: 10px auto;\n\tflex-grow: 1;\n\tflex-shrink: 0;\n\ttext-align: center;\n}\n\n.bookmarkslist__loading {\n\twidth: 100%;\n\tmargin: 200px auto;\n\tflex-grow: 1;\n\tflex-shrink: 0;\n\ttext-align: center;\n}\n\n.bookmarkslist--gridview .padding {\n\tdisplay: flex;\n\tflex-flow: wrap;\n\talign-content: start;\n\tgap: 10px;\n\tpadding: 0 10px;\n}\n\n.folder--gridview,\n.bookmark--gridview,\n.bookmarkslist--gridview .create-folder,\n.bookmarkslist--gridview .create-bookmark {\n\twidth: 250px;\n\theight: 200px;\n\talign-items: flex-end;\n\tbackground: var(--color-main-background);\n\tborder: 1px solid var(--color-border);\n\tbox-shadow: #efefef7d 0px 0 13px 0px inset;\n\tborder-radius: var(--border-radius);\n}\n</style>\n'],sourceRoot:""}]);const i=r},41138:(t,n,e)=>{"use strict";e.d(n,{Z:()=>i});var o=e(23645),r=e.n(o)()(!0);r.push([t.id,"\n.bulkediting {\n\topacity: 1 !important;\n\tpadding: 0 !important;\n\tmargin-top: 1px;\n}\n","",{version:3,sources:["webpack://src/components/BulkEditing.vue"],names:[],mappings:";AAqJA;CACA,qBAAA;CACA,qBAAA;CACA,eAAA;AACA",sourcesContent:["\x3c!--\n  - Copyright (c) 2021. The Nextcloud Bookmarks contributors.\n  -\n  - This file is licensed under the Affero General Public License version 3 or later. See the COPYING file.\n  --\x3e\n\n<template>\n\t<div class=\"bulkediting\">\n\t\t<Actions :primary=\"true\" :menu-title=\"selectionDescription\">\n\t\t\t<ActionButton icon=\"icon-external\" close-after-click @click=\"onBulkOpen\">\n\t\t\t\t{{ t('bookmarks', 'Open all selected') }}\n\t\t\t</ActionButton>\n\t\t\t<ActionButton close-after-click @click=\"onBulkMove\">\n\t\t\t\t<template #icon>\n\t\t\t\t\t<FolderMoveIcon :fill-color=\"colorMainText\" class=\"action-button-mdi-icon\" />\n\t\t\t\t</template>\n\t\t\t\t{{ t('bookmarks', 'Move selection') }}\n\t\t\t</ActionButton>\n\t\t\t<ActionButton v-if=\"!selectedFolders.length\" close-after-click @click=\"onBulkCopy\">\n\t\t\t\t<template #icon>\n\t\t\t\t\t<FolderPlusIcon :fill-color=\"colorMainText\" class=\"action-button-mdi-icon\" />\n\t\t\t\t</template>\n\t\t\t\t{{ t('bookmarks', 'Add to folders') }}\n\t\t\t</ActionButton>\n\t\t\t<ActionInput\n\t\t\t\tv-if=\"!selectedFolders.length\"\n\t\t\t\t:value=\"selectionTags\"\n\t\t\t\ticon=\"icon-tag\"\n\t\t\t\ttype=\"multiselect\"\n\t\t\t\t:options=\"allTags\"\n\t\t\t\t:multiple=\"true\"\n\t\t\t\t:taggable=\"true\"\n\t\t\t\t@tag=\"onBulkTag([...selectionTags, $event])\"\n\t\t\t\t@input=\"onBulkTag\">\n\t\t\t\t{{ t('bookmarks', 'Edit tags of selection') }}\n\t\t\t</ActionInput>\n\t\t\t<ActionButton icon=\"icon-delete\" close-after-click @click=\"onBulkDelete\">\n\t\t\t\t{{ t('bookmarks', 'Delete selection') }}\n\t\t\t</ActionButton>\n\t\t\t<ActionSeparator />\n\t\t\t<ActionButton icon=\"icon-checkmark\" @click=\"onSelectAll\">\n\t\t\t\t{{ t('bookmarks', 'Select all') }}\n\t\t\t</ActionButton>\n\t\t\t<ActionButton icon=\"icon-close\" @click=\"onCancelSelection\">\n\t\t\t\t{{ t('bookmarks', 'Cancel selection') }}\n\t\t\t</ActionButton>\n\t\t</Actions>\n\t</div>\n</template>\n\n<script>\n\nimport Actions from '@nextcloud/vue/dist/Components/Actions'\nimport ActionInput from '@nextcloud/vue/dist/Components/ActionInput'\nimport ActionButton from '@nextcloud/vue/dist/Components/ActionButton'\nimport ActionSeparator from '@nextcloud/vue/dist/Components/ActionSeparator'\nimport FolderPlusIcon from 'vue-material-design-icons/FolderPlus'\nimport FolderMoveIcon from 'vue-material-design-icons/FolderMove'\nimport { actions, mutations } from '../store'\nimport intersection from 'lodash/intersection'\n\nexport default {\n\tname: 'BulkEditing',\n\tcomponents: { ActionInput, ActionSeparator, FolderPlusIcon, FolderMoveIcon, ActionButton, Actions },\n\tdata() {\n\t\treturn {\n\t\t\tselectionTags: [],\n\t\t}\n\t},\n\tcomputed: {\n\t\tallTags() {\n\t\t\treturn this.$store.state.tags.map(tag => tag.name)\n\t\t},\n\t\tselectedFolders() {\n\t\t\treturn this.$store.state.selection.folders\n\t\t},\n\t\tselectedBookmarks() {\n\t\t\treturn this.$store.state.selection.bookmarks\n\t\t},\n\t\tselectionDescription() {\n\t\t\tif (this.$store.state.selection.bookmarks.length !== 0 && this.$store.state.selection.folders.length !== 0) {\n\t\t\t\treturn this.t('bookmarks',\n\t\t\t\t\t'Selected {folders} folders and {bookmarks} bookmarks',\n\t\t\t\t\t{ folders: this.$store.state.selection.folders.length, bookmarks: this.$store.state.selection.bookmarks.length }\n\t\t\t\t)\n\t\t\t}\n\t\t\tif (this.$store.state.selection.bookmarks.length !== 0) {\n\t\t\t\treturn this.n('bookmarks',\n\t\t\t\t\t'Selected %n bookmark',\n\t\t\t\t\t'Selected %n bookmarks',\n\t\t\t\t\tthis.$store.state.selection.bookmarks.length\n\t\t\t\t)\n\t\t\t}\n\t\t\tif (this.$store.state.selection.folders.length !== 0) {\n\t\t\t\treturn this.n('bookmarks',\n\t\t\t\t\t'Selected %n folder',\n\t\t\t\t\t'Selected %n folders',\n\t\t\t\t\tthis.$store.state.selection.folders.length\n\t\t\t\t)\n\t\t\t}\n\t\t\treturn ''\n\t\t},\n\t},\n\twatch: {\n\t\tselectedBookmarks(bookmarks) {\n\t\t\tthis.updateSelectionTags()\n\t\t},\n\t},\n\tmethods: {\n\t\tasync onBulkOpen() {\n\t\t\tfor (const { url } of this.$store.state.selection.bookmarks) {\n\t\t\t\twindow.open(url)\n\t\t\t\tawait new Promise(resolve => setTimeout(resolve, 200))\n\t\t\t}\n\t\t},\n\t\tasync onBulkDelete() {\n\t\t\tif (!confirm(t('bookmarks', 'Do you really want to delete these items?'))) {\n\t\t\t\treturn\n\t\t\t}\n\t\t\tawait this.$store.dispatch(actions.DELETE_SELECTION, { folder: this.$route.params.folder })\n\t\t\tthis.$store.commit(mutations.RESET_SELECTION)\n\t\t},\n\t\tonBulkMove() {\n\t\t\tthis.$store.commit(mutations.DISPLAY_MOVE_DIALOG, true)\n\t\t},\n\t\tonBulkCopy() {\n\t\t\tthis.$store.commit(mutations.DISPLAY_COPY_DIALOG, true)\n\t\t},\n\t\tasync onBulkTag(tags) {\n\t\t\tconst originalTags = this.selectionTags\n\t\t\tthis.selectionTags = tags\n\t\t\tawait this.$store.dispatch(actions.TAG_SELECTION, { tags, originalTags })\n\t\t},\n\t\tonCancelSelection() {\n\t\t\tthis.$store.commit(mutations.RESET_SELECTION)\n\t\t},\n\t\tasync onSelectAll() {\n\t\t\tawait this.$store.dispatch(actions.FETCH_ALL)\n\t\t\tthis.$store.state.bookmarks.forEach(bookmark => {\n\t\t\t\tthis.$store.commit(mutations.ADD_SELECTION_BOOKMARK, bookmark)\n\t\t\t})\n\t\t},\n\t\tupdateSelectionTags() {\n\t\t\tthis.selectionTags = intersection(...this.selectedBookmarks.map((bm) => bm.tags))\n\t\t},\n\t},\n}\n<\/script>\n<style>\n.bulkediting {\n\topacity: 1 !important;\n\tpadding: 0 !important;\n\tmargin-top: 1px;\n}\n</style>\n"],sourceRoot:""}]);const i=r},15051:(t,n,e)=>{"use strict";e.d(n,{Z:()=>i});var o=e(23645),r=e.n(o)()(!0);r.push([t.id,"\n.controls {\n\tpadding: 0 8px 0 44px;\n\tdisplay: flex;\n\tposition: absolute;\n\tz-index: 100;\n\tbackground: var(--color-main-background-translucent);\n\tleft: 0;\n\tright: 0;\n\ttop: 0;\n}\n.controls h2 {\n\tmargin: 0;\n\tmargin-left: 10px;\n\tdisplay: flex;\n\tposition: relative;\n\ttop: -2px;\n\tflex-shrink: 0;\n}\n.controls h2 :nth-child(2) {\n\tmargin-left: 5px;\n}\n.controls h2 > .material-design-icon {\n\tposition: relative;\n\ttop: 4px;\n}\n.controls.wide {\n\tpadding: 0 8px;\n}\n.controls .custom-button:hover,\n.controls .custom-button:active {\n\tbackground-color: var(--color-background-hover);\n}\n.controls + * {\n\tmargin-top: 50px;\n}\n.controls__left {\n\tdisplay: flex;\n\talign-items: center;\n\tflex: 0;\n}\n.controls__tags {\n\twidth: 300px;\n\tflex: 1;\n}\n.controls__tags .multiselect__tags {\n\tborder-top: none !important;\n\tborder-left: none !important;\n\tborder-right: none !important;\n}\n.controls__right {\n\tflex: 2;\n\tdisplay: flex;\n\tflex-direction: row-reverse;\n\tpadding: 0;\n}\n.controls__right > * {\n\tmin-width: 30px;\n}\n","",{version:3,sources:["webpack://src/components/Controls.vue"],names:[],mappings:";AAsRA;CACA,qBAAA;CACA,aAAA;CACA,kBAAA;CACA,YAAA;CACA,oDAAA;CACA,OAAA;CACA,QAAA;CACA,MAAA;AACA;AAEA;CACA,SAAA;CACA,iBAAA;CACA,aAAA;CACA,kBAAA;CACA,SAAA;CACA,cAAA;AACA;AAEA;CACA,gBAAA;AACA;AAEA;CACA,kBAAA;CACA,QAAA;AACA;AAEA;CACA,cAAA;AACA;AAEA;;CAEA,+CAAA;AACA;AAEA;CACA,gBAAA;AACA;AAEA;CACA,aAAA;CACA,mBAAA;CACA,OAAA;AACA;AAEA;CACA,YAAA;CACA,OAAA;AACA;AAEA;CACA,2BAAA;CACA,4BAAA;CACA,6BAAA;AACA;AAEA;CACA,OAAA;CACA,aAAA;CACA,2BAAA;CACA,UAAA;AACA;AAEA;CACA,eAAA;AACA",sourcesContent:["\x3c!--\n  - Copyright (c) 2020. The Nextcloud Bookmarks contributors.\n  -\n  - This file is licensed under the Affero General Public License version 3 or later. See the COPYING file.\n  --\x3e\n\n<template>\n\t<div :class=\"['controls', $store.state.public && 'wide']\">\n\t\t<div class=\"controls__left\">\n\t\t\t<Actions v-if=\"$route.name === routes.FOLDER\">\n\t\t\t\t<ActionButton @click=\"onClickBack\">\n\t\t\t\t\t<ArrowLeftIcon slot=\"icon\" :size=\"18\" :fill-color=\"colorMainText\" />\n\t\t\t\t\t{{ t('bookmarks', 'Go back') }}\n\t\t\t\t</ActionButton>\n\t\t\t</Actions>\n\t\t\t<template v-if=\"$route.name === routes.FOLDER\">\n\t\t\t\t<h2><FolderIcon :size=\"18\" :fill-color=\"colorMainText\" /> <span>{{ folder.title }}</span></h2>\n\t\t\t\t<Actions v-if=\"permissions.canShare\">\n\t\t\t\t\t<ActionButton icon=\"icon-share\" :close-after-click=\"true\" @click=\"onOpenFolderShare\">\n\t\t\t\t\t\t{{ t('bookmarks', 'Share folder') }}\n\t\t\t\t\t</ActionButton>\n\t\t\t\t</Actions>\n\t\t\t</template>\n\t\t\t<template v-if=\"$route.name === routes.TAGS\">\n\t\t\t\t<span class=\"icon-tag\" />\n\t\t\t\t<Multiselect\n\t\t\t\t\tclass=\"controls__tags\"\n\t\t\t\t\t:value=\"tags\"\n\t\t\t\t\t:auto-limit=\"false\"\n\t\t\t\t\t:limit=\"7\"\n\t\t\t\t\t:options=\"allTags\"\n\t\t\t\t\t:multiple=\"true\"\n\t\t\t\t\t:placeholder=\"t('bookmarks', 'Select one or more tags')\"\n\t\t\t\t\t@input=\"onTagsChange\" />\n\t\t\t</template>\n\t\t\t<Actions\n\t\t\t\tv-if=\"!isPublic\"\n\t\t\t\tv-tooltip=\"t('bookmarks', 'New')\"\n\t\t\t\t:title=\"t('bookmarks', 'New')\"\n\t\t\t\t:default-icon=\"'icon-add'\">\n\t\t\t\t<ActionButton\n\t\t\t\t\ticon=\"icon-link\"\n\t\t\t\t\t:close-after-click=\"true\"\n\t\t\t\t\t@click=\"onAddBookmark\">\n\t\t\t\t\t{{\n\t\t\t\t\t\tt('bookmarks', 'New bookmark')\n\t\t\t\t\t}}\n\t\t\t\t</ActionButton>\n\t\t\t\t<ActionButton\n\t\t\t\t\ticon=\"icon-folder\"\n\t\t\t\t\t:close-after-click=\"true\"\n\t\t\t\t\t@click=\"onAddFolder\">\n\t\t\t\t\t{{ t('bookmarks', 'New folder') }}\n\t\t\t\t</ActionButton>\n\t\t\t</Actions>\n\t\t\t<BulkEditing v-if=\"hasSelection\" />\n\t\t</div>\n\t\t<div class=\"controls__right\">\n\t\t\t<Actions>\n\t\t\t\t<ActionButton\n\t\t\t\t\t:icon=\"\n\t\t\t\t\t\tviewMode === 'list'\n\t\t\t\t\t\t\t? 'icon-toggle-pictures'\n\t\t\t\t\t\t\t: 'icon-toggle-filelist'\n\t\t\t\t\t\"\n\t\t\t\t\t@click=\"onToggleViewMode\">\n\t\t\t\t\t{{ viewMode === 'list' ? t('bookmarks', 'Change to grid view') : t('bookmarks', 'Change to list view') }}\n\t\t\t\t</ActionButton>\n\t\t\t</Actions>\n\t\t\t<Actions v-tooltip=\"sortingOptions[sorting].description\">\n\t\t\t\t<template #icon>\n\t\t\t\t\t<component :is=\"sortingOptions[sorting].icon\" :size=\"20\" :fill-color=\"colorMainText\" />\n\t\t\t\t</template>\n\t\t\t\t<ActionButton v-for=\"(option, key) in sortingOptions\"\n\t\t\t\t\t:key=\"key\"\n\t\t\t\t\t:close-after-click=\"true\"\n\t\t\t\t\t@click=\"onChangeSorting(key)\">\n\t\t\t\t\t<template #icon>\n\t\t\t\t\t\t<component :is=\"option.icon\"\n\t\t\t\t\t\t\t:size=\"20\"\n\t\t\t\t\t\t\t:fill-color=\"key === sorting? colorPrimaryElement : colorMainText\" />\n\t\t\t\t\t</template>\n\t\t\t\t\t{{ option.description }}\n\t\t\t\t</ActionButton>\n\t\t\t</Actions>\n\t\t\t<Actions force-menu>\n\t\t\t\t<template #icon>\n\t\t\t\t\t<RssIcon :fill-color=\"colorMainText\" :size=\"20\" class=\"action-button-mdi-icon\" />\n\t\t\t\t</template>\n\t\t\t\t<ActionButton\n\t\t\t\t\t:title=\"t('bookmarks', 'Copy RSS Feed of current view')\"\n\t\t\t\t\t:close-after-click=\"true\"\n\t\t\t\t\t@click=\"copyRssUrl\">\n\t\t\t\t\t<template #icon>\n\t\t\t\t\t\t<RssIcon :fill-color=\"colorMainText\" :size=\"20\" class=\"action-button-mdi-icon\" />\n\t\t\t\t\t</template>\n\t\t\t\t\t{{ !$store.state.public? t('bookmarks', 'The RSS feed requires authentication with your Nextcloud credentials') : '' }}\n\t\t\t\t</ActionButton>\n\t\t\t</Actions>\n\t\t</div>\n\t</div>\n</template>\n<script>\nimport Multiselect from '@nextcloud/vue/dist/Components/Multiselect'\nimport Actions from '@nextcloud/vue/dist/Components/Actions'\nimport ActionButton from '@nextcloud/vue/dist/Components/ActionButton'\nimport ActionInput from '@nextcloud/vue/dist/Components/ActionInput'\nimport ActionRouter from '@nextcloud/vue/dist/Components/ActionRouter'\nimport FolderIcon from 'vue-material-design-icons/Folder'\nimport ArrowLeftIcon from 'vue-material-design-icons/ArrowLeft'\nimport RssIcon from 'vue-material-design-icons/Rss'\nimport SortAlphabeticalAscendingIcon from 'vue-material-design-icons/SortAlphabeticalAscending'\nimport SortBoolAscendingIcon from 'vue-material-design-icons/SortBoolAscending'\nimport SortClockAscendingOutlineIcon from 'vue-material-design-icons/SortClockAscendingOutline'\nimport SortCalendarAscendingIcon from 'vue-material-design-icons/SortCalendarAscending'\nimport SortAscendingIcon from 'vue-material-design-icons/SortAscending'\nimport { actions, mutations } from '../store/'\nimport { generateUrl } from '@nextcloud/router'\nimport BulkEditing from './BulkEditing'\nimport copy from 'copy-text-to-clipboard'\n\nexport default {\n\tname: 'Controls',\n\tcomponents: {\n\t\tBulkEditing,\n\t\tMultiselect,\n\t\tActions,\n\t\tActionButton,\n\t\tActionInput,\n\t\tActionRouter,\n\t\tRssIcon,\n\t\tSortAscendingIcon,\n\t\tSortCalendarAscendingIcon,\n\t\tSortAlphabeticalAscendingIcon,\n\t\tSortClockAscendingOutlineIcon,\n\t\tSortBoolAscendingIcon,\n\t\tFolderIcon,\n\t\tArrowLeftIcon,\n\t},\n\tprops: {},\n\tdata() {\n\t\treturn {\n\t\t\turl: '',\n\t\t\tsearch: this.$route.params.search || '',\n\t\t\tsortingOptions: {\n\t\t\t\tadded: { icon: 'SortCalendarAscendingIcon', description: this.t('bookmarks', 'Sort by created date') },\n\t\t\t\tlastmodified: { icon: 'SortClockAscendingOutlineIcon', description: this.t('bookmarks', 'Sort by last modified') },\n\t\t\t\ttitle: { icon: 'SortAlphabeticalAscendingIcon', description: this.t('bookmarks', 'Sort by title') },\n\t\t\t\tclickcount: { icon: 'SortBoolAscendingIcon', description: this.t('bookmarks', 'Sort by click count') },\n\t\t\t\tindex: { icon: 'SortAscendingIcon', description: this.t('bookmarks', 'Sort by manual order') },\n\t\t\t},\n\t\t}\n\t},\n\tcomputed: {\n\t\tbackLink() {\n\t\t\tif (this.folder && this.folderPath.length > 1) {\n\t\t\t\treturn { name: this.routes.FOLDER, params: { folder: this.folder.parent_folder } }\n\t\t\t}\n\n\t\t\treturn { name: this.routes.HOME }\n\t\t},\n\t\tpermissions() {\n\t\t\tconst folder = this.folder\n\t\t\tif (!folder) {\n\t\t\t\treturn {}\n\t\t\t}\n\t\t\treturn this.$store.getters.getPermissionsForFolder(folder.id)\n\t\t},\n\t\tallTags() {\n\t\t\treturn this.$store.state.tags.map(tag => tag.name)\n\t\t},\n\t\ttags() {\n\t\t\tconst tags = this.$route.params.tags\n\t\t\tif (!tags) return []\n\t\t\treturn tags.split(',')\n\t\t},\n\t\tfolderPath() {\n\t\t\tconst folder = this.$route.params.folder\n\t\t\tif (!folder) return []\n\t\t\treturn this.$store.getters.getFolder(folder).reverse()\n\t\t},\n\t\tfolder() {\n\t\t\tconst folder = this.$route.params.folder\n\t\t\tif (!folder) return\n\t\t\treturn this.$store.getters.getFolder(folder)[0]\n\t\t},\n\t\tviewMode() {\n\t\t\treturn this.$store.state.viewMode\n\t\t},\n\t\thasSelection() {\n\t\t\treturn this.$store.state.selection.bookmarks.length || this.$store.state.selection.folders.length\n\t\t},\n\t\trssURL() {\n\t\t\tconst params = new URLSearchParams()\n\t\t\tfor (const field in this.$store.state.fetchState.query) {\n\t\t\t\tif (Array.isArray(this.$store.state.fetchState.query[field])) {\n\t\t\t\t\tthis.$store.state.fetchState.query[field].forEach(value => {\n\t\t\t\t\t\tparams.append(field + '[]', value)\n\t\t\t\t\t})\n\t\t\t\t} else {\n\t\t\t\t\tparams.append(field, this.$store.state.fetchState.query[field])\n\t\t\t\t}\n\t\t\t}\n\t\t\tparams.set('format', 'rss')\n\t\t\tparams.set('page', '-1')\n\t\t\tif (this.$store.state.public) {\n\t\t\t\tparams.set('token', this.$store.state.authToken)\n\t\t\t}\n\t\t\treturn (\n\t\t\t\twindow.location.origin\n\t\t\t\t\t+ generateUrl(\n\t\t\t\t\t\t'/apps/bookmarks/public/rest/v2/bookmark?'\n\t\t\t\t\t\t\t+ params.toString()\n\t\t\t\t\t)\n\t\t\t)\n\t\t},\n\t\tsorting() {\n\t\t\treturn this.$store.state.settings.sorting\n\t\t},\n\t},\n\tcreated() {},\n\tmethods: {\n\t\tonSelectHome() {\n\t\t\tthis.$router.push({ name: this.routes.HOME })\n\t\t},\n\n\t\tonClickBack() {\n\t\t\tthis.$router.push(this.backLink)\n\t\t},\n\n\t\tonTagsChange(tags) {\n\t\t\tthis.$router.push({ name: this.routes.TAGS, params: { tags: tags.join(',') } })\n\t\t},\n\n\t\tonSelectFolder(folder) {\n\t\t\tthis.$router.push({ name: this.routes.FOLDER, params: { folder } })\n\t\t},\n\n\t\tonOpenFolderShare() {\n\t\t\tthis.$store.dispatch(actions.OPEN_FOLDER_SHARING, this.folder.id)\n\t\t},\n\n\t\tonAddFolder() {\n\t\t\tthis.$store.commit(\n\t\t\t\tmutations.DISPLAY_NEW_FOLDER,\n\t\t\t\t!this.$store.state.displayNewFolder\n\t\t\t)\n\t\t},\n\t\tonAddBookmark() {\n\t\t\tthis.$store.commit(\n\t\t\t\tmutations.DISPLAY_NEW_BOOKMARK,\n\t\t\t\t!this.$store.state.displayNewBookmark\n\t\t\t)\n\t\t},\n\n\t\tonToggleViewMode() {\n\t\t\tthis.$store.dispatch(actions.SET_SETTING, {\n\t\t\t\tkey: 'viewMode',\n\t\t\t\tvalue: this.$store.state.viewMode === 'grid' ? 'list' : 'grid',\n\t\t\t})\n\t\t},\n\n\t\tcopyRssUrl() {\n\t\t\tcopy(this.rssURL)\n\t\t\tthis.$store.commit(mutations.SET_NOTIFICATION, t('bookmarks', 'RSS feed copied'))\n\t\t},\n\n\t\tasync onChangeSorting(value) {\n\t\t\tawait this.$store.dispatch(actions.SET_SETTING, {\n\t\t\t\tkey: 'sorting',\n\t\t\t\tvalue,\n\t\t\t})\n\t\t\tawait this.$store.dispatch(actions.FETCH_PAGE)\n\t\t},\n\t},\n}\n<\/script>\n<style>\n.controls {\n\tpadding: 0 8px 0 44px;\n\tdisplay: flex;\n\tposition: absolute;\n\tz-index: 100;\n\tbackground: var(--color-main-background-translucent);\n\tleft: 0;\n\tright: 0;\n\ttop: 0;\n}\n\n.controls h2 {\n\tmargin: 0;\n\tmargin-left: 10px;\n\tdisplay: flex;\n\tposition: relative;\n\ttop: -2px;\n\tflex-shrink: 0;\n}\n\n.controls h2 :nth-child(2) {\n\tmargin-left: 5px;\n}\n\n.controls h2 > .material-design-icon {\n\tposition: relative;\n\ttop: 4px;\n}\n\n.controls.wide {\n\tpadding: 0 8px;\n}\n\n.controls .custom-button:hover,\n.controls .custom-button:active {\n\tbackground-color: var(--color-background-hover);\n}\n\n.controls + * {\n\tmargin-top: 50px;\n}\n\n.controls__left {\n\tdisplay: flex;\n\talign-items: center;\n\tflex: 0;\n}\n\n.controls__tags {\n\twidth: 300px;\n\tflex: 1;\n}\n\n.controls__tags .multiselect__tags {\n\tborder-top: none !important;\n\tborder-left: none !important;\n\tborder-right: none !important;\n}\n\n.controls__right {\n\tflex: 2;\n\tdisplay: flex;\n\tflex-direction: row-reverse;\n\tpadding: 0;\n}\n\n.controls__right > * {\n\tmin-width: 30px;\n}\n</style>\n"],sourceRoot:""}]);const i=r},58211:(t,n,e)=>{"use strict";e.d(n,{Z:()=>i});var o=e(23645),r=e.n(o)()(!0);r.push([t.id,"\n.icon[data-v-32fb8798] {\n\tflex-grow: 0;\n\theight: 20px;\n\twidth: 20px;\n\tbackground-size: cover;\n\tmargin: 0 15px;\n\tcursor: pointer;\n}\n.item--gridview .icon[data-v-32fb8798] {\n\tbackground-size: cover;\n\tposition: absolute;\n\ttop: 20%;\n\tleft: calc(45% - 50px);\n\ttransform: scale(4);\n\ttransform-origin: top left;\n}\n","",{version:3,sources:["webpack://src/components/CreateBookmark.vue"],names:[],mappings:";AAyDA;CACA,YAAA;CACA,YAAA;CACA,WAAA;CACA,sBAAA;CACA,cAAA;CACA,eAAA;AACA;AAEA;CACA,sBAAA;CACA,kBAAA;CACA,QAAA;CACA,sBAAA;CACA,mBAAA;CACA,0BAAA;AACA",sourcesContent:['\x3c!--\n  - Copyright (c) 2020. The Nextcloud Bookmarks contributors.\n  -\n  - This file is licensed under the Affero General Public License version 3 or later. See the COPYING file.\n  --\x3e\n\n<template>\n\t<Item :selectable="false"\n\t\t:renaming="true"\n\t\ttitle=""\n\t\t:editable="true"\n\t\t:rename-placeholder="t(\'bookmarks\', \'Enter a link\')"\n\t\tselect-label=""\n\t\t@rename="submit"\n\t\t@rename-cancel="cancel">\n\t\t<template #icon>\n\t\t\t<EarthIcon :fill-color="colorMainText" class="icon" />\n\t\t</template>\n\t</Item>\n</template>\n<script>\nimport EarthIcon from \'vue-material-design-icons/Earth\'\nimport Item from \'./Item\'\nimport { actions, mutations } from \'../store/\'\n\nexport default {\n\tname: \'CreateBookmark\',\n\tcomponents: { Item, EarthIcon },\n\tcomputed: {\n\t\tcreating() {\n\t\t\treturn this.$store.state.loading.createBookmark\n\t\t},\n\t\tisFolderView() {\n\t\t\treturn this.$route.name === this.$store.getters.getRoutes().FOLDER\n\t\t},\n\t\tisTagView() {\n\t\t\treturn this.$route.name === this.$store.getters.getRoutes().TAGS\n\t\t},\n\t},\n\tmethods: {\n\t\tsubmit(url) {\n\t\t\tthis.$store.dispatch(actions.CREATE_BOOKMARK, {\n\t\t\t\turl,\n\t\t\t\t...(this.isFolderView && { folders: [this.$route.params.folder] }),\n\t\t\t\t...(this.isTagView && { tags: this.$route.params.tags.split(\',\') }),\n\t\t\t})\n\t\t},\n\t\tcancel() {\n\t\t\tthis.$store.commit(\n\t\t\t\tmutations.DISPLAY_NEW_BOOKMARK,\n\t\t\t\tfalse\n\t\t\t)\n\t\t},\n\t},\n}\n<\/script>\n<style scoped>\n.icon {\n\tflex-grow: 0;\n\theight: 20px;\n\twidth: 20px;\n\tbackground-size: cover;\n\tmargin: 0 15px;\n\tcursor: pointer;\n}\n\n.item--gridview .icon {\n\tbackground-size: cover;\n\tposition: absolute;\n\ttop: 20%;\n\tleft: calc(45% - 50px);\n\ttransform: scale(4);\n\ttransform-origin: top left;\n}\n</style>\n'],sourceRoot:""}]);const i=r},962:(t,n,e)=>{"use strict";e.d(n,{Z:()=>i});var o=e(23645),r=e.n(o)()(!0);r.push([t.id,"\n.icon[data-v-c3795188] {\n\tflex-grow: 0;\n\theight: 20px;\n\twidth: 20px;\n\tbackground-size: cover;\n\tmargin: 0 15px;\n\tcursor: pointer;\n}\n.item--gridview .icon[data-v-c3795188] {\n\tbackground-size: cover;\n\tposition: absolute;\n\ttop: 20%;\n\tleft: calc(45% - 50px);\n\ttransform: scale(4);\n\ttransform-origin: top left;\n}\n","",{version:3,sources:["webpack://src/components/CreateFolder.vue"],names:[],mappings:";AAmDA;CACA,YAAA;CACA,YAAA;CACA,WAAA;CACA,sBAAA;CACA,cAAA;CACA,eAAA;AACA;AAEA;CACA,sBAAA;CACA,kBAAA;CACA,QAAA;CACA,sBAAA;CACA,mBAAA;CACA,0BAAA;AACA",sourcesContent:['\x3c!--\n  - Copyright (c) 2020. The Nextcloud Bookmarks contributors.\n  -\n  - This file is licensed under the Affero General Public License version 3 or later. See the COPYING file.\n  --\x3e\n\n<template>\n\t<Item :selectable="false"\n\t\t:renaming="true"\n\t\ttitle=""\n\t\t:editable="true"\n\t\t:rename-placeholder="t(\'bookmarks\', \'Enter a title\')"\n\t\tselect-label=""\n\t\t@rename="submit"\n\t\t@rename-cancel="cancel">\n\t\t<template #icon>\n\t\t\t<FolderIcon :fill-color="colorPrimaryElement" class="icon" />\n\t\t</template>\n\t</Item>\n</template>\n<script>\nimport FolderIcon from \'vue-material-design-icons/Folder\'\nimport Item from \'./Item\'\nimport { actions, mutations } from \'../store/\'\n\nexport default {\n\tname: \'CreateFolder\',\n\tcomponents: { Item, FolderIcon },\n\tcomputed: {\n\t\tloading() {\n\t\t\treturn this.$store.state.loading.createFolder\n\t\t},\n\t},\n\tmethods: {\n\t\tsubmit(title) {\n\t\t\tconst parentFolder = this.$route.params.folder\n\t\t\tthis.$store.dispatch(actions.CREATE_FOLDER, {\n\t\t\t\tparentFolder,\n\t\t\t\ttitle,\n\t\t\t})\n\t\t},\n\t\tcancel() {\n\t\t\tthis.$store.commit(\n\t\t\t\tmutations.DISPLAY_NEW_FOLDER,\n\t\t\t\tfalse\n\t\t\t)\n\t\t},\n\t},\n}\n<\/script>\n<style scoped>\n.icon {\n\tflex-grow: 0;\n\theight: 20px;\n\twidth: 20px;\n\tbackground-size: cover;\n\tmargin: 0 15px;\n\tcursor: pointer;\n}\n\n.item--gridview .icon {\n\tbackground-size: cover;\n\tposition: absolute;\n\ttop: 20%;\n\tleft: calc(45% - 50px);\n\ttransform: scale(4);\n\ttransform-origin: top left;\n}\n</style>\n'],sourceRoot:""}]);const i=r},30349:(t,n,e)=>{"use strict";e.d(n,{Z:()=>i});var o=e(23645),r=e.n(o)()(!0);r.push([t.id,"\n.dragImage[data-v-cc3a0496] {\n\tbackground: var(--color-main-background);\n\tborder: 1px solid var(--color-border);\n\tbox-shadow: #efefef7d 0px 0 13px 0px;\n\tborder-radius: var(--border-radius-large);\n\twidth: 250px;\n\theight: 1.5em;\n\tpadding: 10px;\n\tdisplay: flex;\n\tflex-direction: row;\n}\n.dragImage .description[data-v-cc3a0496] {\n\ttext-overflow: ellipsis;\n\toverflow: hidden;\n\tflex-grow: 1;\n\theight: 1.5em;\n\tdisplay: inline-block;\n\tmargin-left: 3px;\n}\n","",{version:3,sources:["webpack://src/components/DragImage.vue"],names:[],mappings:";AAsDA;CACA,wCAAA;CACA,qCAAA;CACA,oCAAA;CACA,yCAAA;CACA,YAAA;CACA,aAAA;CACA,aAAA;CACA,aAAA;CACA,mBAAA;AACA;AAEA;CACA,uBAAA;CACA,gBAAA;CACA,YAAA;CACA,aAAA;CACA,qBAAA;CACA,gBAAA;AACA",sourcesContent:["\x3c!--\n  - Copyright (c) 2021. The Nextcloud Bookmarks contributors.\n  -\n  - This file is licensed under the Affero General Public License version 3 or later. See the COPYING file.\n  --\x3e\n\n<template>\n\t<div class=\"dragImage\">\n\t\t<FolderIcon v-if=\"$store.state.selection.folders.length\" :fill-color=\"colorPrimaryElement\" />\n\t\t<EarthIcon v-else :fill-color=\"colorPrimaryElement\" /><span class=\"description\">{{ selectionDescription }}</span>\n\t</div>\n</template>\n\n<script>\nimport FolderIcon from 'vue-material-design-icons/Folder'\nimport EarthIcon from 'vue-material-design-icons/Earth'\nexport default {\n\tname: 'DragImage',\n\tcomponents: { FolderIcon, EarthIcon },\n\tcomputed: {\n\t\tselectionDescription() {\n\t\t\tif (this.$store.state.selection.bookmarks.length !== 0 && this.$store.state.selection.folders.length !== 0) {\n\t\t\t\treturn this.t('bookmarks',\n\t\t\t\t\t'{folders} folders and {bookmarks} bookmarks',\n\t\t\t\t\t{ folders: this.$store.state.selection.folders.length, bookmarks: this.$store.state.selection.bookmarks.length }\n\t\t\t\t)\n\t\t\t}\n\t\t\tif (this.$store.state.selection.bookmarks.length !== 0) {\n\t\t\t\tif (this.$store.state.selection.bookmarks.length === 1) {\n\t\t\t\t\treturn this.$store.state.selection.bookmarks[0].title\n\t\t\t\t}\n\t\t\t\treturn this.n('bookmarks',\n\t\t\t\t\t'%n bookmark',\n\t\t\t\t\t'%n bookmarks',\n\t\t\t\t\tthis.$store.state.selection.bookmarks.length\n\t\t\t\t)\n\t\t\t}\n\t\t\tif (this.$store.state.selection.folders.length !== 0) {\n\t\t\t\tif (this.$store.state.selection.folders.length === 1) {\n\t\t\t\t\treturn this.$store.state.selection.folders[0].title\n\t\t\t\t}\n\t\t\t\treturn this.n('bookmarks',\n\t\t\t\t\t'%n folder',\n\t\t\t\t\t'%n folders',\n\t\t\t\t\tthis.$store.state.selection.folders.length\n\t\t\t\t)\n\t\t\t}\n\t\t\treturn ''\n\t\t},\n\t},\n}\n<\/script>\n\n<style scoped>\n.dragImage {\n\tbackground: var(--color-main-background);\n\tborder: 1px solid var(--color-border);\n\tbox-shadow: #efefef7d 0px 0 13px 0px;\n\tborder-radius: var(--border-radius-large);\n\twidth: 250px;\n\theight: 1.5em;\n\tpadding: 10px;\n\tdisplay: flex;\n\tflex-direction: row;\n}\n\n.dragImage .description {\n\ttext-overflow: ellipsis;\n\toverflow: hidden;\n\tflex-grow: 1;\n\theight: 1.5em;\n\tdisplay: inline-block;\n\tmargin-left: 3px;\n}\n</style>\n"],sourceRoot:""}]);const i=r},24692:(t,n,e)=>{"use strict";e.d(n,{Z:()=>i});var o=e(23645),r=e.n(o)()(!0);r.push([t.id,"\n.folder__icon {\n\tflex-grow: 0;\n\theight: 20px;\n\twidth: 20px;\n\tbackground-size: cover;\n\tmargin: 0 15px;\n\tcursor: pointer;\n}\n.folder__icon.shared {\n\ttransform: scale(0.5);\n\tposition: absolute;\n\ttop: 11px;\n\theight:auto;\n\twidth:auto;\n}\n.item--gridview .folder__icon {\n\tbackground-size: cover;\n\tposition: absolute;\n\ttop: 20%;\n\tleft: calc(45% - 50px);\n\ttransform: scale(4);\n\ttransform-origin: top left;\n}\n.item--gridview .folder__icon.shared {\n\ttransform: translate(100%, 90%) scale(2);\n}\n.folder__title {\n\tflex: 1;\n\ttext-overflow: ellipsis;\n\toverflow: hidden;\n\twhite-space: nowrap;\n\tcursor: pointer;\n\tmargin: 0;\n}\n.item--gridview .folder__title {\n\tmargin-left: 15px;\n}\n.folder__tags {\n\tfont-size: 12px;\n\theight: 24px;\n\tline-height: 1;\n\toverflow: hidden;\n\tdisplay: inline-block;\n\tmargin: 0 15px;\n}\n.item--gridview .folder__tags {\n\tposition: absolute;\n\tbottom: 47px;\n\tleft: 10px;\n\tmargin: 0;\n}\n.folder__tag {\n\tdisplay: inline-block;\n\tborder: 1px solid var(--color-border);\n\tborder-radius: var(--border-radius-pill);\n\tpadding: 5px 10px;\n\tmargin-right: 3px;\n\tbackground-color: var(--color-primary-light);\n}\n","",{version:3,sources:["webpack://src/components/Folder.vue"],names:[],mappings:";AAwMA;CACA,YAAA;CACA,YAAA;CACA,WAAA;CACA,sBAAA;CACA,cAAA;CACA,eAAA;AACA;AAEA;CACA,qBAAA;CACA,kBAAA;CACA,SAAA;CACA,WAAA;CACA,UAAA;AACA;AAEA;CACA,sBAAA;CACA,kBAAA;CACA,QAAA;CACA,sBAAA;CACA,mBAAA;CACA,0BAAA;AACA;AAEA;CACA,wCAAA;AACA;AAEA;CACA,OAAA;CACA,uBAAA;CACA,gBAAA;CACA,mBAAA;CACA,eAAA;CACA,SAAA;AACA;AAEA;CACA,iBAAA;AACA;AAEA;CACA,eAAA;CACA,YAAA;CACA,cAAA;CACA,gBAAA;CACA,qBAAA;CACA,cAAA;AACA;AAEA;CACA,kBAAA;CACA,YAAA;CACA,UAAA;CACA,SAAA;AACA;AAEA;CACA,qBAAA;CACA,qCAAA;CACA,wCAAA;CACA,iBAAA;CACA,iBAAA;CACA,4CAAA;AACA",sourcesContent:['\x3c!--\n  - Copyright (c) 2020. The Nextcloud Bookmarks contributors.\n  -\n  - This file is licensed under the Affero General Public License version 3 or later. See the COPYING file.\n  --\x3e\n\n<template>\n\t<Item :active="selected"\n\t\t:editable="isEditable"\n\t\t:draggable="isEditable"\n\t\t:selected="selected"\n\t\t:title="folder.title"\n\t\t:renaming="renaming"\n\t\t:select-label="t(\'bookmarks\', \'Select folder\')"\n\t\t:rename-placeholder="t(\'bookmarks\', \'Enter folder title\')"\n\t\t:selectable="selectable"\n\t\t:allow-drop="allowDrop"\n\t\t@drop="onDrop"\n\t\t@select="clickSelect"\n\t\t@rename="onRenameSubmit"\n\t\t@rename-cancel="renaming = false"\n\t\t@click="onSelect">\n\t\t<template #icon>\n\t\t\t<FolderIcon :fill-color="colorPrimaryElement" :class="\'folder__icon\'" @click="onSelect" />\n\t\t\t<ShareVariantIcon v-if="(isShared || !isOwner) || isSharedPublicly"\n\t\t\t\t:fill-color="colorPrimaryText"\n\t\t\t\t:class="[\'folder__icon\', \'shared\']" />\n\t\t</template>\n\t\t<template #title>\n\t\t\t<h3 class="folder__title">\n\t\t\t\t{{ folder.title }}\n\t\t\t</h3>\n\t\t</template>\n\t\t<template #tags>\n\t\t\t<div class="folder__tags">\n\t\t\t\t<div v-if="!isOwner && !isSharedPublicly" class="folder__tag">\n\t\t\t\t\t{{ t(\'bookmarks\', \'Shared by {user}\', {user: folder.userId}) }}\n\t\t\t\t</div>\n\t\t\t</div>\n\t\t</template>\n\t\t<template #actions>\n\t\t\t<ActionButton icon="icon-info" :close-after-click="true" @click="onDetails">\n\t\t\t\t{{ t(\'bookmarks\', \'Details\') }}\n\t\t\t</ActionButton>\n\t\t\t<ActionCheckbox @change="clickSelect">\n\t\t\t\t{{ t(\'bookmarks\', \'Select folder\') }}\n\t\t\t</ActionCheckbox>\n\t\t\t<ActionButton v-if="permissions.canShare"\n\t\t\t\ticon="icon-share"\n\t\t\t\t:close-after-click="true"\n\t\t\t\t@click="onShare">\n\t\t\t\t{{ t(\'bookmarks\', \'Share folder\') }}\n\t\t\t</ActionButton>\n\t\t\t<ActionButton icon="icon-rename" :close-after-click="true" @click="onRename">\n\t\t\t\t{{ t(\'bookmarks\', \'Rename folder\') }}\n\t\t\t</ActionButton>\n\t\t\t<ActionButton :close-after-click="true" @click="onMove">\n\t\t\t\t<template #icon>\n\t\t\t\t\t<FolderMoveIcon :fill-color="colorMainText" />\n\t\t\t\t</template>\n\t\t\t\t{{ t(\'bookmarks\', \'Move folder\') }}\n\t\t\t</ActionButton>\n\t\t\t<ActionButton icon="icon-delete" :close-after-click="true" @click="onDelete">\n\t\t\t\t{{ t(\'bookmarks\', \'Delete folder\') }}\n\t\t\t</ActionButton>\n\t\t</template>\n\t</Item>\n</template>\n<script>\nimport { getCurrentUser } from \'@nextcloud/auth\'\nimport FolderMoveIcon from \'vue-material-design-icons/FolderMove\'\nimport FolderIcon from \'vue-material-design-icons/Folder\'\nimport ShareVariantIcon from \'vue-material-design-icons/ShareVariant\'\nimport ActionButton from \'@nextcloud/vue/dist/Components/ActionButton\'\nimport ActionCheckbox from \'@nextcloud/vue/dist/Components/ActionCheckbox\'\nimport { actions, mutations } from \'../store/\'\nimport Item from \'./Item\'\n\nexport default {\n\tname: \'Folder\',\n\tcomponents: {\n\t\tItem,\n\t\tActionButton,\n\t\tActionCheckbox,\n\t\tFolderIcon,\n\t\tFolderMoveIcon,\n\t\tShareVariantIcon,\n\t},\n\tprops: {\n\t\tfolder: {\n\t\t\ttype: Object,\n\t\t\trequired: true,\n\t\t},\n\t},\n\tdata() {\n\t\treturn { renaming: false }\n\t},\n\tcomputed: {\n\t\tviewMode() {\n\t\t\treturn this.$store.state.viewMode\n\t\t},\n\t\tcurrentUser() {\n\t\t\treturn getCurrentUser().uid\n\t\t},\n\t\tisOwner() {\n\t\t\tconst currentUser = getCurrentUser()\n\t\t\treturn currentUser && this.folder.userId === currentUser.uid\n\t\t},\n\t\tpermissions() {\n\t\t\treturn this.$store.getters.getPermissionsForFolder(this.folder.id)\n\t\t},\n\t\tisEditable() {\n\t\t\treturn this.isOwner || (!this.isOwner && this.permissions.canWrite)\n\t\t},\n\t\tshares() {\n\t\t\treturn this.$store.getters.getSharesOfFolder(this.folder.id)\n\t\t},\n\t\tpublicToken() {\n\t\t\treturn this.$store.getters.getTokenOfFolder(this.folder.id)\n\t\t},\n\t\tisShared() {\n\t\t\treturn Boolean(this.shares.length)\n\t\t},\n\t\tisSharedPublicly() {\n\t\t\treturn Boolean(this.publicToken)\n\t\t},\n\t\tselectedFolders() {\n\t\t\treturn this.$store.state.selection.folders\n\t\t},\n\t\tselectable() {\n\t\t\treturn Boolean(this.$store.state.selection.bookmarks.length || this.$store.state.selection.folders.length)\n\t\t},\n\t\tselected() {\n\t\t\treturn this.selectedFolders.map(f => f.id).includes(this.folder.id)\n\t\t},\n\t},\n\tmounted() {\n\t\t// This slows down initial load otherwise and it\'s not directly necessary\n\t\tsetTimeout(() => {\n\t\t\tthis.$store.dispatch(actions.LOAD_SHARES_OF_FOLDER, this.folder.id)\n\t\t\tthis.$store.dispatch(actions.LOAD_PUBLIC_LINK, this.folder.id)\n\t\t\tthis.$store.dispatch(actions.COUNT_BOOKMARKS, this.folder.id)\n\t\t}, 2000)\n\t},\n\tmethods: {\n\t\tonDetails() {\n\t\t\tthis.$store.dispatch(actions.OPEN_FOLDER_DETAILS, this.folder.id)\n\t\t},\n\t\tonShare() {\n\t\t\tthis.$store.dispatch(actions.OPEN_FOLDER_SHARING, this.folder.id)\n\t\t},\n\t\tonDelete() {\n\t\t\tif (!confirm(t(\'bookmarks\', \'Do you really want to delete this folder?\'))) {\n\t\t\t\treturn\n\t\t\t}\n\t\t\tthis.$store.dispatch(actions.DELETE_FOLDER, { id: this.folder.id })\n\t\t},\n\t\tonMove() {\n\t\t\tthis.$store.commit(mutations.RESET_SELECTION)\n\t\t\tthis.$store.commit(mutations.ADD_SELECTION_FOLDER, this.folder)\n\t\t\tthis.$store.commit(mutations.DISPLAY_MOVE_DIALOG, true)\n\t\t},\n\t\tonSelect(e) {\n\t\t\tthis.$router.push({ name: this.routes.FOLDER, params: { folder: this.folder.id } })\n\t\t\te.preventDefault()\n\t\t},\n\t\tasync onRename() {\n\t\t\tthis.renaming = true\n\t\t},\n\t\tonRenameSubmit(title) {\n\t\t\t// eslint-disable-next-line vue/no-mutating-props\n\t\t\tthis.folder.title = title\n\t\t\tthis.$store.dispatch(actions.SAVE_FOLDER, this.folder.id)\n\t\t\tthis.renaming = false\n\t\t},\n\t\tclickSelect(e) {\n\t\t\tif (!this.selected) {\n\t\t\t\tthis.$store.commit(mutations.ADD_SELECTION_FOLDER, this.folder)\n\t\t\t} else {\n\t\t\t\tthis.$store.commit(mutations.REMOVE_SELECTION_FOLDER, this.folder)\n\t\t\t}\n\t\t},\n\t\tonEnter(e) {\n\t\t\tif (e.key === \'Enter\') {\n\t\t\t\tthis.onSelect(e)\n\t\t\t}\n\t\t},\n\t\tallowDrop() {\n\t\t\treturn !this.$store.state.selection.folders.includes(this.folder) && (this.$store.state.selection.folders.length || this.$store.state.selection.bookmarks.length)\n\t\t},\n\t\tasync onDrop(e) {\n\t\t\te.preventDefault()\n\t\t\tawait this.$store.dispatch(actions.MOVE_SELECTION, this.folder.id)\n\t\t\tthis.$store.commit(mutations.RESET_SELECTION)\n\t\t\tawait this.$store.dispatch(actions.RELOAD_VIEW)\n\t\t},\n\t},\n}\n<\/script>\n<style>\n.folder__icon {\n\tflex-grow: 0;\n\theight: 20px;\n\twidth: 20px;\n\tbackground-size: cover;\n\tmargin: 0 15px;\n\tcursor: pointer;\n}\n\n.folder__icon.shared {\n\ttransform: scale(0.5);\n\tposition: absolute;\n\ttop: 11px;\n\theight:auto;\n\twidth:auto;\n}\n\n.item--gridview .folder__icon {\n\tbackground-size: cover;\n\tposition: absolute;\n\ttop: 20%;\n\tleft: calc(45% - 50px);\n\ttransform: scale(4);\n\ttransform-origin: top left;\n}\n\n.item--gridview .folder__icon.shared {\n\ttransform: translate(100%, 90%) scale(2);\n}\n\n.folder__title {\n\tflex: 1;\n\ttext-overflow: ellipsis;\n\toverflow: hidden;\n\twhite-space: nowrap;\n\tcursor: pointer;\n\tmargin: 0;\n}\n\n.item--gridview .folder__title {\n\tmargin-left: 15px;\n}\n\n.folder__tags {\n\tfont-size: 12px;\n\theight: 24px;\n\tline-height: 1;\n\toverflow: hidden;\n\tdisplay: inline-block;\n\tmargin: 0 15px;\n}\n\n.item--gridview .folder__tags {\n\tposition: absolute;\n\tbottom: 47px;\n\tleft: 10px;\n\tmargin: 0;\n}\n\n.folder__tag {\n\tdisplay: inline-block;\n\tborder: 1px solid var(--color-border);\n\tborder-radius: var(--border-radius-pill);\n\tpadding: 5px 10px;\n\tmargin-right: 3px;\n\tbackground-color: var(--color-primary-light);\n}\n</style>\n'],sourceRoot:""}]);const i=r},59695:(t,n,e)=>{"use strict";e.d(n,{Z:()=>i});var o=e(23645),r=e.n(o)()(!0);r.push([t.id,"\n.item {\n\tborder-bottom: 1px solid var(--color-border);\n\tbackground-position: center !important;\n\tbackground-size: cover !important;\n\tbackground-color: var(--color-main-background);\n\tposition: relative;\n}\n.item--gridview {\n\twidth: 250px;\n\theight: 200px;\n\tbackground: var(--color-main-background);\n\tborder: 1px solid var(--color-border);\n\tbox-shadow: #efefef7d 0px 0 13px 0px inset;\n\tborder-radius: var(--border-radius-large);\n}\n.item__clickLink,\n.item__rename {\n\tdisplay: flex;\n\talign-items: center;\n}\n.item__rename {\n\tpadding: 0 8px 0 10px;\n}\n.item--gridview  .item__rename {\n\tpadding: 0 8px 5px 10px;\n}\n.item--gridview .item__clickLink,\n.item--gridview  .item__rename {\n\tposition: absolute;\n\tbottom: 0;\n\tleft: 0;\n\tright: 0;\n\ttop: 0;\n\tdisplay: flex;\n\talign-items: flex-end;\n}\n.item.dropTarget--available {\n\tbackground: var(--color-primary-light);\n}\n.item.dropTarget--active {\n\tbackground: var(--color-primary-element-light);\n}\n.item.active,\n.item:hover,\n.item:focus {\n\tbackground: var(--color-background-dark);\n}\n.item.item--gridview.active {\n\tborder-color: var(--color-primary-element);\n}\n.item__checkbox {\n\tdisplay: inline-block;\n}\n.item__checkbox label {\n\tpadding: 7px;\n\tdisplay: inline-block;\n}\n.item__labels {\n\tdisplay: flex;\n\tflex: 1;\n\ttext-overflow: ellipsis;\n\toverflow: hidden;\n\tmargin: 10px 0;\n\tmargin-left: 5px;\n}\n.item:not(.item--gridview) .item__rename input {\n\twidth: 100%;\n}\n.item--gridview .item__checkbox {\n\tposition: absolute;\n\ttop: -1px;\n\tleft: -1px;\n\tbackground: white;\n\tborder-radius: var(--border-radius);\n\tbox-shadow: #aaa 0 0 3px inset;\n}\n.item__actions {\n\tflex: 0;\n}\n.item--gridview .tagline {\n\tposition: absolute;\n\tbottom: 47px;\n\tleft: 10px;\n\tmargin: 0;\n\tright: 10px;\n}\n.item--gridview .item__checkbox input[type='checkbox'].checkbox + label::before {\n\tmargin: 0 3px 3px 3px;\n}\n\n","",{version:3,sources:["webpack://src/components/Item.vue"],names:[],mappings:";AAiNA;CACA,4CAAA;CACA,sCAAA;CACA,iCAAA;CACA,8CAAA;CACA,kBAAA;AACA;AAEA;CACA,YAAA;CACA,aAAA;CACA,wCAAA;CACA,qCAAA;CACA,0CAAA;CACA,yCAAA;AACA;AAEA;;CAEA,aAAA;CACA,mBAAA;AACA;AAEA;CACA,qBAAA;AACA;AAEA;CACA,uBAAA;AACA;AAEA;;CAEA,kBAAA;CACA,SAAA;CACA,OAAA;CACA,QAAA;CACA,MAAA;CACA,aAAA;CACA,qBAAA;AACA;AAEA;CACA,sCAAA;AACA;AAEA;CACA,8CAAA;AACA;AAEA;;;CAGA,wCAAA;AACA;AAEA;CACA,0CAAA;AACA;AAEA;CACA,qBAAA;AACA;AAEA;CACA,YAAA;CACA,qBAAA;AACA;AAEA;CACA,aAAA;CACA,OAAA;CACA,uBAAA;CACA,gBAAA;CACA,cAAA;CACA,gBAAA;AACA;AAEA;CACA,WAAA;AACA;AAEA;CACA,kBAAA;CACA,SAAA;CACA,UAAA;CACA,iBAAA;CACA,mCAAA;CACA,8BAAA;AACA;AAEA;CACA,OAAA;AACA;AAEA;CACA,kBAAA;CACA,YAAA;CACA,UAAA;CACA,SAAA;CACA,WAAA;AACA;AAEA;CACA,qBAAA;AACA",sourcesContent:['\x3c!--\n  - Copyright (c) 2020. The Nextcloud Bookmarks contributors.\n  -\n  - This file is licensed under the Affero General Public License version 3 or later. See the COPYING file.\n  --\x3e\n\n<template>\n\t<div\n\t\tv-drop-target="{allow: allowDrop, drop: (e) => $emit(\'drop\', e)}"\n\t\t:class="{\n\t\t\titem: true,\n\t\t\tactive,\n\t\t\t\'item--gridview\': viewMode === \'grid\'\n\t\t}"\n\t\t:style="{ background }"\n\t\t:draggable="draggable && !renaming"\n\t\t@dragstart="onDragStart">\n\t\t<template v-if="!renaming">\n\t\t\t<a\n\t\t\t\t:href="url"\n\t\t\t\tclass="item__clickLink"\n\t\t\t\ttabindex="0"\n\t\t\t\ttarget="_blank"\n\t\t\t\t@click="onClick">\n\t\t\t\t<div v-if="editable && selectable" ref="checkbox" class="item__checkbox">\n\t\t\t\t\t<input :checked="selected" class="checkbox" type="checkbox"><label\n\t\t\t\t\t\tv-tooltip="selectLabel"\n\t\t\t\t\t\t:aria-label="selectLabel"\n\t\t\t\t\t\t@click="$event.preventDefault(); $event.stopImmediatePropagation(); $emit(\'select\');" />\n\t\t\t\t</div>\n\t\t\t\t<slot name="icon" />\n\t\t\t\t<div class="item__labels">\n\t\t\t\t\t<slot name="title" />\n\t\t\t\t\t<slot name="tags">\n\t\t\t\t\t\t<TagLine :tags="tags" />\n\t\t\t\t\t</slot>\n\t\t\t\t</div>\n\t\t\t\t<div v-if="editable && !selected"\n\t\t\t\t\tref="actions"\n\t\t\t\t\tclass="item__actions"\n\t\t\t\t\t@click="$event.preventDefault(); $event.stopPropagation()">\n\t\t\t\t\t<Actions>\n\t\t\t\t\t\t<slot name="actions" />\n\t\t\t\t\t</Actions>\n\t\t\t\t</div>\n\t\t\t</a>\n\t\t</template>\n\t\t<div v-else class="item__rename">\n\t\t\t<slot name="icon" />\n\t\t\t<input\n\t\t\t\tref="input"\n\t\t\t\tv-model="newTitle"\n\t\t\t\ttype="text"\n\t\t\t\t:placeholder="renamePlaceholder"\n\t\t\t\t@keyup.enter="onRenameSubmit">\n\t\t\t<Actions>\n\t\t\t\t<ActionButton icon="icon-checkmark" @click="onRenameSubmit">\n\t\t\t\t\t{{ t(\'bookmarks\', \'Submit\') }}\n\t\t\t\t</ActionButton>\n\t\t\t</Actions>\n\t\t\t<Actions>\n\t\t\t\t<ActionButton icon="icon-close" @click="$emit(\'rename-cancel\')">\n\t\t\t\t\t{{ t(\'bookmarks\', \'Cancel\') }}\n\t\t\t\t</ActionButton>\n\t\t\t</Actions>\n\t\t</div>\n\t</div>\n</template>\n<script>\nimport Vue from \'vue\'\nimport Actions from \'@nextcloud/vue/dist/Components/Actions\'\nimport ActionButton from \'@nextcloud/vue/dist/Components/ActionButton\'\nimport TagLine from \'./TagLine\'\nimport DragImage from \'./DragImage\'\nimport { mutations } from \'../store\'\n\nexport default {\n\tname: \'Item\',\n\tcomponents: {\n\t\tActions,\n\t\tActionButton,\n\t\tTagLine,\n\t},\n\tprops: {\n\t\ttitle: {\n\t\t\ttype: String,\n\t\t\trequired: true,\n\t\t},\n\t\turl: {\n\t\t\ttype: String,\n\t\t\tdefault: undefined,\n\t\t},\n\t\tactive: {\n\t\t\ttype: Boolean,\n\t\t\tdefault: false,\n\t\t},\n\t\teditable: {\n\t\t\ttype: Boolean,\n\t\t\tdefault: false,\n\t\t},\n\t\tselected: {\n\t\t\ttype: Boolean,\n\t\t\tdefault: false,\n\t\t},\n\t\tselectable: {\n\t\t\ttype: Boolean,\n\t\t\tdefault: false,\n\t\t},\n\t\tdraggable: {\n\t\t\ttype: Boolean,\n\t\t\tdefault: false,\n\t\t},\n\t\tallowDrop: {\n\t\t\ttype: Function,\n\t\t\tdefault: () => false,\n\t\t},\n\t\trenaming: {\n\t\t\ttype: Boolean,\n\t\t\tdefault: false,\n\t\t},\n\t\tselectLabel: {\n\t\t\ttype: String,\n\t\t\trequired: true,\n\t\t},\n\t\trenamePlaceholder: {\n\t\t\ttype: String,\n\t\t\trequired: true,\n\t\t},\n\t\tbackground: {\n\t\t\ttype: String,\n\t\t\tdefault: undefined,\n\t\t},\n\t\ttags: {\n\t\t\ttype: Array,\n\t\t\tdefault: undefined,\n\t\t},\n\t},\n\tdata() {\n\t\treturn {\n\t\t\tnewTitle: this.title,\n\t\t}\n\t},\n\tcomputed: {\n\t\tviewMode() {\n\t\t\treturn this.$store.state.viewMode\n\t\t},\n\t},\n\twatch: {\n\t\tasync renaming() {\n\t\t\tif (this.renaming) {\n\t\t\t\tawait Vue.nextTick()\n\t\t\t\tthis.$refs.input.focus()\n\t\t\t}\n\t\t},\n\t},\n\tmounted() {\n\t\tif (typeof this.$refs.input !== \'undefined\') {\n\t\t\tthis.$refs.input.focus()\n\t\t}\n\t},\n\tmethods: {\n\t\tasync onRenameSubmit(event) {\n\t\t\tthis.$emit(\'rename\', this.newTitle)\n\t\t},\n\t\tonClick(e) {\n\t\t\tif (this.$refs.actions === e.target\n\t\t\t\t\t|| (this.$refs.actions && this.$refs.actions.contains(e.target))\n\t\t\t\t\t|| (this.$refs.checkbox\n\t\t\t\t\t\t\t&& (this.$refs.checkbox.contains(e.target) || this.$refs.checkbox === e.target)\n\t\t\t\t\t)) {\n\t\t\t\te.stopImmediatePropagation()\n\t\t\t\treturn\n\t\t\t}\n\t\t\tthis.$emit(\'click\', e)\n\t\t},\n\t\tasync onDragStart(e) {\n\t\t\tif (!this.draggable || this.renaming) {\n\t\t\t\treturn\n\t\t\t}\n\t\t\tif (!this.selected) {\n\t\t\t\tif (this.$store.state.selection.bookmarks.length || this.$store.state.selection.folders.length) {\n\t\t\t\t\t// If something is already selected not including the current element, reset selection\n\t\t\t\t\tthis.$store.commit(mutations.RESET_SELECTION)\n\t\t\t\t}\n\t\t\t\t// Select the current item\n\t\t\t\tthis.$emit(\'select\')\n\t\t\t\tawait this.$nextTick()\n\t\t\t}\n\t\t\t// Build the drag image\n\t\t\tconst element = document.createElement(\'div\')\n\t\t\tconst placeholder = element.appendChild(document.createElement(\'div\'))\n\t\t\tdocument.body.appendChild(element)\n\t\t\tconst vueInstance = new Vue({ el: placeholder, store: this.$store, render: (h) => h(DragImage) })\n\t\t\tawait vueInstance.$nextTick()\n\n\t\t\t// set drag data and drag image\n\t\t\te.dataTransfer.clearData()\n\t\t\te.dataTransfer.setData(\'text/plain\', JSON.stringify(this.$store.state.selection))\n\t\t\te.dataTransfer.setDragImage(element, 0, 0)\n\n\t\t\t// dispose of drag image element, as the browser only takes a visual snapshot once\n\t\t\tawait new Promise(resolve => setTimeout(resolve, 0))\n\t\t\tdocument.body.removeChild(element)\n\t\t},\n\t},\n}\n<\/script>\n<style>\n\n.item {\n\tborder-bottom: 1px solid var(--color-border);\n\tbackground-position: center !important;\n\tbackground-size: cover !important;\n\tbackground-color: var(--color-main-background);\n\tposition: relative;\n}\n\n.item--gridview {\n\twidth: 250px;\n\theight: 200px;\n\tbackground: var(--color-main-background);\n\tborder: 1px solid var(--color-border);\n\tbox-shadow: #efefef7d 0px 0 13px 0px inset;\n\tborder-radius: var(--border-radius-large);\n}\n\n.item__clickLink,\n.item__rename {\n\tdisplay: flex;\n\talign-items: center;\n}\n\n.item__rename {\n\tpadding: 0 8px 0 10px;\n}\n\n.item--gridview  .item__rename {\n\tpadding: 0 8px 5px 10px;\n}\n\n.item--gridview .item__clickLink,\n.item--gridview  .item__rename {\n\tposition: absolute;\n\tbottom: 0;\n\tleft: 0;\n\tright: 0;\n\ttop: 0;\n\tdisplay: flex;\n\talign-items: flex-end;\n}\n\n.item.dropTarget--available {\n\tbackground: var(--color-primary-light);\n}\n\n.item.dropTarget--active {\n\tbackground: var(--color-primary-element-light);\n}\n\n.item.active,\n.item:hover,\n.item:focus {\n\tbackground: var(--color-background-dark);\n}\n\n.item.item--gridview.active {\n\tborder-color: var(--color-primary-element);\n}\n\n.item__checkbox {\n\tdisplay: inline-block;\n}\n\n.item__checkbox label {\n\tpadding: 7px;\n\tdisplay: inline-block;\n}\n\n.item__labels {\n\tdisplay: flex;\n\tflex: 1;\n\ttext-overflow: ellipsis;\n\toverflow: hidden;\n\tmargin: 10px 0;\n\tmargin-left: 5px;\n}\n\n.item:not(.item--gridview) .item__rename input {\n\twidth: 100%;\n}\n\n.item--gridview .item__checkbox {\n\tposition: absolute;\n\ttop: -1px;\n\tleft: -1px;\n\tbackground: white;\n\tborder-radius: var(--border-radius);\n\tbox-shadow: #aaa 0 0 3px inset;\n}\n\n.item__actions {\n\tflex: 0;\n}\n\n.item--gridview .tagline {\n\tposition: absolute;\n\tbottom: 47px;\n\tleft: 10px;\n\tmargin: 0;\n\tright: 10px;\n}\n\n.item--gridview .item__checkbox input[type=\'checkbox\'].checkbox + label::before {\n\tmargin: 0 3px 3px 3px;\n}\n\n</style>\n'],sourceRoot:""}]);const i=r},6344:(t,n,e)=>{"use strict";e.d(n,{Z:()=>i});var o=e(23645),r=e.n(o)()(!0);r.push([t.id,"\n.bookmarkslist__emptyBookmarks[data-v-833d7fe0] {\n\twidth: 500px;\n\tmargin: 0 auto;\n}\n.import[data-v-833d7fe0] {\n\topacity: 0;\n\tposition: absolute;\n\ttop: 0;\n\tleft: -1000px;\n}\n.material-design-icon[data-v-833d7fe0] {\n\tposition: relative;\n\ttop: 4px;\n}\n","",{version:3,sources:["webpack://src/components/NoBookmarks.vue"],names:[],mappings:";AAuEA;CACA,YAAA;CACA,cAAA;AACA;AAEA;CACA,UAAA;CACA,kBAAA;CACA,MAAA;CACA,aAAA;AACA;AAEA;CACA,kBAAA;CACA,QAAA;AACA",sourcesContent:["\x3c!--\n  - Copyright (c) 2020. The Nextcloud Bookmarks contributors.\n  -\n  - This file is licensed under the Affero General Public License version 3 or later. See the COPYING file.\n  --\x3e\n\n<template>\n\t<div class=\"bookmarkslist__emptyBookmarks\">\n\t\t<EmptyContent v-if=\"$route.name === routes.ARCHIVED\">\n\t\t\t{{ t('bookmarks', 'No bookmarked files') }}\n\t\t\t<template #desc>\n\t\t\t\t{{ t('bookmarks', 'Bookmarks to files like photos or PDFs will automatically be saved to your Nextcloud files, so you can still find them even when the link goes offline.') }}\n\t\t\t</template>\n\t\t</EmptyContent>\n\t\t<EmptyContent v-else icon=\"icon-favorite\">\n\t\t\t{{ t('bookmarks', 'No bookmarks here') }}\n\t\t\t<template v-if=\"!isPublic\" #desc>\n\t\t\t\t<p>{{ t('bookmarks', 'Start by importing bookmarks from a file or synchronizing your browser bookmarks with this app') }}</p>\n\t\t\t\t<input ref=\"import\"\n\t\t\t\t\ttype=\"file\"\n\t\t\t\t\tclass=\"import\"\n\t\t\t\t\tsize=\"5\"\n\t\t\t\t\t@change=\"onImportSubmit\">\n\t\t\t\t<button @click=\"onImportOpen\">\n\t\t\t\t\t<span :class=\"{'icon-upload': !importing, 'icon-loading-small': importing}\" /> {{ t('bookmarks', 'Import bookmarks') }}\n\t\t\t\t</button>\n\t\t\t\t<button @click=\"onSyncOpen\">\n\t\t\t\t\t<SyncIcon :fill-color=\"colorMainText\" :size=\"18\" :style=\"{opacity: 0.5}\" /> {{ t('bookmarks', 'Sync with your browser') }}\n\t\t\t\t</button>\n\t\t\t</template>\n\t\t</EmptyContent>\n\t</div>\n</template>\n\n<script>\nimport EmptyContent from '@nextcloud/vue/dist/Components/EmptyContent'\nimport { actions } from '../store'\nimport { privateRoutes } from '../router'\nimport SyncIcon from 'vue-material-design-icons/Sync'\n\nexport default {\n\tname: 'NoBookmarks',\n\tcomponents: { EmptyContent, SyncIcon },\n\tdata() {\n\t\treturn { importing: false }\n\t},\n\tcomputed: {\n\t\troutes() {\n\t\t\treturn privateRoutes\n\t\t},\n\t},\n\tmethods: {\n\t\tonImportOpen() {\n\t\t\tthis.$refs.import.click()\n\t\t},\n\t\tonSyncOpen() {\n\t\t\twindow.open('https://floccus.org', '_blank')\n\t\t},\n\t\tasync onImportSubmit(e) {\n\t\t\tthis.importing = true\n\t\t\ttry {\n\t\t\t\tawait this.$store.dispatch(actions.IMPORT_BOOKMARKS, { file: e.target.files[0], folder: this.$route.params.folder || -1 })\n\t\t\t} catch (e) {\n\t\t\t\tconsole.warn(e)\n\t\t\t}\n\t\t\tthis.importing = false\n\t\t},\n\t},\n}\n<\/script>\n<style scoped>\n.bookmarkslist__emptyBookmarks {\n\twidth: 500px;\n\tmargin: 0 auto;\n}\n\n.import {\n\topacity: 0;\n\tposition: absolute;\n\ttop: 0;\n\tleft: -1000px;\n}\n\n.material-design-icon {\n\tposition: relative;\n\ttop: 4px;\n}\n</style>\n"],sourceRoot:""}]);const i=r},52920:(t,n,e)=>{"use strict";e.d(n,{Z:()=>i});var o=e(23645),r=e.n(o)()(!0);r.push([t.id,"\n.tagline {\n\tfont-size: 12px;\n\theight: 24px;\n\tline-height: 1;\n\toverflow: hidden;\n\tdisplay: inline-block;\n\tmargin: 0 15px;\n}\n.tagline__tag {\n\tdisplay: inline-block;\n\tborder: 1px solid var(--color-border);\n\tborder-radius: var(--border-radius-pill);\n\tpadding: 5px 10px;\n\tmargin-right: 3px;\n\tbackground-color: var(--color-main-background);\n\tcursor: pointer;\n}\n.tagline__tag:hover,\n.tagline__tag:focus {\n\tbackground-color: var(--color-background-dark);\n}\n","",{version:3,sources:["webpack://src/components/TagLine.vue"],names:[],mappings:";AAiDA;CACA,eAAA;CACA,YAAA;CACA,cAAA;CACA,gBAAA;CACA,qBAAA;CACA,cAAA;AACA;AAEA;CACA,qBAAA;CACA,qCAAA;CACA,wCAAA;CACA,iBAAA;CACA,iBAAA;CACA,8CAAA;CACA,eAAA;AACA;AAEA;;CAEA,8CAAA;AACA",sourcesContent:['\x3c!--\n  - Copyright (c) 2020. The Nextcloud Bookmarks contributors.\n  -\n  - This file is licensed under the Affero General Public License version 3 or later. See the COPYING file.\n  --\x3e\n\n<template>\n\t<div class="tagline">\n\t\t<div v-for="tag in tags"\n\t\t\t:key="tag"\n\t\t\tclass="tagline__tag"\n\t\t\trole="button"\n\t\t\t@click="clickTag($event, tag)">\n\t\t\t{{ tag }}\n\t\t</div>\n\t</div>\n</template>\n<script>\nimport { privateRoutes, publicRoutes } from \'../router\'\n\nexport default {\n\tname: \'TagLine\',\n\tcomponents: {},\n\tprops: {\n\t\ttags: {\n\t\t\ttype: Array,\n\t\t\trequired: true,\n\t\t},\n\t},\n\tdata() {\n\t\treturn {}\n\t},\n\tcomputed: {\n\t\troutes() {\n\t\t\treturn this.$store.state.public ? publicRoutes : privateRoutes\n\t\t},\n\t},\n\tcreated() {},\n\tmethods: {\n\t\tclickTag(e, tag) {\n\t\t\te.preventDefault()\n\t\t\te.stopImmediatePropagation()\n\t\t\te.stopPropagation()\n\t\t\tthis.$router.push({ name: this.routes.TAGS, params: { tags: tag } })\n\t\t},\n\t},\n}\n<\/script>\n<style>\n.tagline {\n\tfont-size: 12px;\n\theight: 24px;\n\tline-height: 1;\n\toverflow: hidden;\n\tdisplay: inline-block;\n\tmargin: 0 15px;\n}\n\n.tagline__tag {\n\tdisplay: inline-block;\n\tborder: 1px solid var(--color-border);\n\tborder-radius: var(--border-radius-pill);\n\tpadding: 5px 10px;\n\tmargin-right: 3px;\n\tbackground-color: var(--color-main-background);\n\tcursor: pointer;\n}\n\n.tagline__tag:hover,\n.tagline__tag:focus {\n\tbackground-color: var(--color-background-dark);\n}\n</style>\n'],sourceRoot:""}]);const i=r},76338:(t,n,e)=>{"use strict";e.d(n,{Z:()=>m});var o=e(91036),r=e.n(o),i=e(79753),s=e(97e3);const a={name:"BookmarkContent",components:{EmptyContent:e.n(s)()},computed:{isActive:function(){return!!this.$store.state.sidebar&&"bookmark"===this.$store.state.sidebar.type},bookmark:function(){if(this.isActive)return this.$store.getters.getBookmark(this.$store.state.sidebar.id)},hasMinLength:function(){return!this.bookmark.textContent||this.bookmark.textContent.length>=350},content:function(){return r()(this.bookmark.htmlContent,{allowProtocolRelative:!1})},archivedFileUrl:function(){var t=this.bookmark.archivedFilePath.split("/").slice(3).join("/");return(0,i.c)("webdav/".concat(t))},archivedFile:function(){return this.bookmark.archivedFile?(0,i.nu)("/apps/files/?fileid=".concat(this.bookmark.archivedFile)):null}}};var l=e(93379),c=e.n(l),A=e(47344),d={insert:"head",singleton:!1};c()(A.Z,d);A.Z.locals;const m=(0,e(51900).Z)(a,(function(){var t=this,n=t.$createElement,e=t._self._c||n;return t.isActive&&t.hasMinLength?e("div",{staticClass:"bookmark-content"},[t.archivedFile?[e("div",{staticClass:"content iframe"},[e("iframe",{attrs:{src:t.archivedFileUrl}})])]:t.bookmark.textContent?e("div",{staticClass:"content",domProps:{innerHTML:t._s(t.content)}}):e("div",[e("EmptyContent",{attrs:{icon:"icon-download"},scopedSlots:t._u([{key:"desc",fn:function(){return[t._v("\n\t\t\t\t"+t._s(t.t("bookmarks","This content is being downloaded for offline use. Please check back later."))+"\n\t\t\t")]},proxy:!0}],null,!1,731343852)},[t._v("\n\t\t\t"+t._s(t.t("bookmarks","Content pending"))+"\n\t\t\t")])],1)],2):t._e()}),[],!1,null,null,null).exports},82142:(n,e,o)=>{"use strict";o.d(e,{Z:()=>ft});var r=o(20144),i=o(79440),s=o.n(i),a=o(56286),l=o.n(a),c=o(41209);const A={name:"TagLine",components:{},props:{tags:{type:Array,required:!0}},data:function(){return{}},computed:{routes:function(){return this.$store.state.public?c.jE:c.xu}},created:function(){},methods:{clickTag:function(t,n){t.preventDefault(),t.stopImmediatePropagation(),t.stopPropagation(),this.$router.push({name:this.routes.TAGS,params:{tags:n}})}}};var d=o(93379),m=o.n(d),u=o(52920),p={insert:"head",singleton:!1};m()(u.Z,p);u.Z.locals;var k=o(51900);const h=(0,k.Z)(A,(function(){var t=this,n=t.$createElement,e=t._self._c||n;return e("div",{staticClass:"tagline"},t._l(t.tags,(function(n){return e("div",{key:n,staticClass:"tagline__tag",attrs:{role:"button"},on:{click:function(e){return t.clickTag(e,n)}}},[t._v("\n\t\t"+t._s(n)+"\n\t")])})),0)}),[],!1,null,null,null).exports;var f=o(35621),g=o(54867);const b={name:"DragImage",components:{FolderIcon:f.Z,EarthIcon:g.Z},computed:{selectionDescription:function(){return 0!==this.$store.state.selection.bookmarks.length&&0!==this.$store.state.selection.folders.length?this.t("bookmarks","{folders} folders and {bookmarks} bookmarks",{folders:this.$store.state.selection.folders.length,bookmarks:this.$store.state.selection.bookmarks.length}):0!==this.$store.state.selection.bookmarks.length?1===this.$store.state.selection.bookmarks.length?this.$store.state.selection.bookmarks[0].title:this.n("bookmarks","%n bookmark","%n bookmarks",this.$store.state.selection.bookmarks.length):0!==this.$store.state.selection.folders.length?1===this.$store.state.selection.folders.length?this.$store.state.selection.folders[0].title:this.n("bookmarks","%n folder","%n folders",this.$store.state.selection.folders.length):""}}};var C=o(30349),v={insert:"head",singleton:!1};m()(C.Z,v);C.Z.locals;const _=(0,k.Z)(b,(function(){var t=this,n=t.$createElement,e=t._self._c||n;return e("div",{staticClass:"dragImage"},[t.$store.state.selection.folders.length?e("FolderIcon",{attrs:{"fill-color":t.colorPrimaryElement}}):e("EarthIcon",{attrs:{"fill-color":t.colorPrimaryElement}}),e("span",{staticClass:"description"},[t._v(t._s(t.selectionDescription))])],1)}),[],!1,null,"cc3a0496",null).exports;var x=o(39790);function w(t,n,e,o,r,i,s){try{var a=t[i](s),l=a.value}catch(t){return void e(t)}a.done?n(l):Promise.resolve(l).then(o,r)}function y(t){return function(){var n=this,e=arguments;return new Promise((function(o,r){var i=t.apply(n,e);function s(t){w(i,o,r,s,a,"next",t)}function a(t){w(i,o,r,s,a,"throw",t)}s(void 0)}))}}const $={name:"Item",components:{Actions:s(),ActionButton:l(),TagLine:h},props:{title:{type:String,required:!0},url:{type:String,default:void 0},active:{type:Boolean,default:!1},editable:{type:Boolean,default:!1},selected:{type:Boolean,default:!1},selectable:{type:Boolean,default:!1},draggable:{type:Boolean,default:!1},allowDrop:{type:Function,default:function(){return!1}},renaming:{type:Boolean,default:!1},selectLabel:{type:String,required:!0},renamePlaceholder:{type:String,required:!0},background:{type:String,default:void 0},tags:{type:Array,default:void 0}},data:function(){return{newTitle:this.title}},computed:{viewMode:function(){return this.$store.state.viewMode}},watch:{renaming:function(){var t=this;return y(regeneratorRuntime.mark((function n(){return regeneratorRuntime.wrap((function(n){for(;;)switch(n.prev=n.next){case 0:if(!t.renaming){n.next=4;break}return n.next=3,r.default.nextTick();case 3:t.$refs.input.focus();case 4:case"end":return n.stop()}}),n)})))()}},mounted:function(){void 0!==this.$refs.input&&this.$refs.input.focus()},methods:{onRenameSubmit:function(t){var n=this;return y(regeneratorRuntime.mark((function t(){return regeneratorRuntime.wrap((function(t){for(;;)switch(t.prev=t.next){case 0:n.$emit("rename",n.newTitle);case 1:case"end":return t.stop()}}),t)})))()},onClick:function(t){this.$refs.actions===t.target||this.$refs.actions&&this.$refs.actions.contains(t.target)||this.$refs.checkbox&&(this.$refs.checkbox.contains(t.target)||this.$refs.checkbox===t.target)?t.stopImmediatePropagation():this.$emit("click",t)},onDragStart:function(t){var n=this;return y(regeneratorRuntime.mark((function e(){var o,i,s;return regeneratorRuntime.wrap((function(e){for(;;)switch(e.prev=e.next){case 0:if(n.draggable&&!n.renaming){e.next=2;break}return e.abrupt("return");case 2:if(n.selected){e.next=7;break}return(n.$store.state.selection.bookmarks.length||n.$store.state.selection.folders.length)&&n.$store.commit(x.P$.RESET_SELECTION),n.$emit("select"),e.next=7,n.$nextTick();case 7:return o=document.createElement("div"),i=o.appendChild(document.createElement("div")),document.body.appendChild(o),s=new r.default({el:i,store:n.$store,render:function(t){return t(_)}}),e.next=13,s.$nextTick();case 13:return t.dataTransfer.clearData(),t.dataTransfer.setData("text/plain",JSON.stringify(n.$store.state.selection)),t.dataTransfer.setDragImage(o,0,0),e.next=18,new Promise((function(t){return setTimeout(t,0)}));case 18:document.body.removeChild(o);case 19:case"end":return e.stop()}}),e)})))()}}};var E=o(59695),S={insert:"head",singleton:!1};m()(E.Z,S);E.Z.locals;const B=(0,k.Z)($,(function(){var t=this,n=t.$createElement,e=t._self._c||n;return e("div",{directives:[{name:"drop-target",rawName:"v-drop-target",value:{allow:t.allowDrop,drop:function(n){return t.$emit("drop",n)}},expression:"{allow: allowDrop, drop: (e) => $emit('drop', e)}"}],class:{item:!0,active:t.active,"item--gridview":"grid"===t.viewMode},style:{background:t.background},attrs:{draggable:t.draggable&&!t.renaming},on:{dragstart:t.onDragStart}},[t.renaming?e("div",{staticClass:"item__rename"},[t._t("icon"),t._v(" "),e("input",{directives:[{name:"model",rawName:"v-model",value:t.newTitle,expression:"newTitle"}],ref:"input",attrs:{type:"text",placeholder:t.renamePlaceholder},domProps:{value:t.newTitle},on:{keyup:function(n){return!n.type.indexOf("key")&&t._k(n.keyCode,"enter",13,n.key,"Enter")?null:t.onRenameSubmit.apply(null,arguments)},input:function(n){n.target.composing||(t.newTitle=n.target.value)}}}),t._v(" "),e("Actions",[e("ActionButton",{attrs:{icon:"icon-checkmark"},on:{click:t.onRenameSubmit}},[t._v("\n\t\t\t\t"+t._s(t.t("bookmarks","Submit"))+"\n\t\t\t")])],1),t._v(" "),e("Actions",[e("ActionButton",{attrs:{icon:"icon-close"},on:{click:function(n){return t.$emit("rename-cancel")}}},[t._v("\n\t\t\t\t"+t._s(t.t("bookmarks","Cancel"))+"\n\t\t\t")])],1)],2):[e("a",{staticClass:"item__clickLink",attrs:{href:t.url,tabindex:"0",target:"_blank"},on:{click:t.onClick}},[t.editable&&t.selectable?e("div",{ref:"checkbox",staticClass:"item__checkbox"},[e("input",{staticClass:"checkbox",attrs:{type:"checkbox"},domProps:{checked:t.selected}}),e("label",{directives:[{name:"tooltip",rawName:"v-tooltip",value:t.selectLabel,expression:"selectLabel"}],attrs:{"aria-label":t.selectLabel},on:{click:function(n){n.preventDefault(),n.stopImmediatePropagation(),t.$emit("select")}}})]):t._e(),t._v(" "),t._t("icon"),t._v(" "),e("div",{staticClass:"item__labels"},[t._t("title"),t._v(" "),t._t("tags",(function(){return[e("TagLine",{attrs:{tags:t.tags}})]}))],2),t._v(" "),t.editable&&!t.selected?e("div",{ref:"actions",staticClass:"item__actions",on:{click:function(t){t.preventDefault(),t.stopPropagation()}}},[e("Actions",[t._t("actions")],2)],1):t._e()],2)]],2)}),[],!1,null,null,null).exports;var O=o(83779),I=o.n(O),T=o(81328),F=o(19383),R=o(22200),D=o(79753);function L(t,n,e,o,r,i,s){try{var a=t[i](s),l=a.value}catch(t){return void e(t)}a.done?n(l):Promise.resolve(l).then(o,r)}function P(t){return function(){var n=this,e=arguments;return new Promise((function(o,r){var i=t.apply(n,e);function s(t){L(i,o,r,s,a,"next",t)}function a(t){L(i,o,r,s,a,"throw",t)}s(void 0)}))}}const N={name:"Bookmark",components:{Item:B,ActionButton:l(),ActionCheckbox:I(),FolderPlusIcon:T.Z,FolderMoveIcon:F.Z},props:{bookmark:{type:Object,required:!0}},data:function(){return{title:this.bookmark.title,renaming:!1}},computed:{apiUrl:function(){return this.isPublic?(0,D.nu)("/apps/bookmarks/public/rest/v2"):(0,D.nu)("/apps/bookmarks")},iconUrl:function(){return this.apiUrl+"/bookmark/"+this.bookmark.id+"/favicon"+(this.$store.state.public?"?token="+this.$store.state.authToken:"")},imageUrl:function(){return this.apiUrl+"/bookmark/"+this.bookmark.id+"/image"+(this.$store.state.public?"?token="+this.$store.state.authToken:"")},background:function(){return"grid"===this.viewMode?"linear-gradient(0deg, var(--color-main-background) 25%, rgba(0, 212, 255, 0) 50%), url('".concat(this.imageUrl,"')"):void 0},url:function(){return this.bookmark.url},isOpen:function(){return!(!this.$store.state.sidebar||"bookmark"!==this.$store.state.sidebar.type)&&this.$store.state.sidebar.id===this.bookmark.id},viewMode:function(){return this.$store.state.viewMode},isOwner:function(){var t=(0,R.getCurrentUser)();return t&&this.bookmark.userId===t.uid},permissions:function(){return this.$store.getters.getPermissionsForBookmark(this.bookmark.id)},isEditable:function(){return this.isOwner||!this.isOwner&&this.permissions.canWrite},selectedBookmarks:function(){return this.$store.state.selection.bookmarks},selectable:function(){return Boolean(this.$store.state.selection.bookmarks.length||this.$store.state.selection.folders.length)},selected:function(){return this.selectedBookmarks.map((function(t){return t.id})).includes(this.bookmark.id)},isActive:function(){return this.isOpen||this.selected}},created:function(){},methods:{onDelete:function(){confirm(t("bookmarks","Do you really want to delete this bookmark?"))&&this.$store.dispatch(x.Nw.DELETE_BOOKMARK,{id:this.bookmark.id,folder:this.$store.state.fetchState.query.folder})},onDetails:function(){this.$store.dispatch(x.Nw.OPEN_BOOKMARK,this.bookmark.id)},onMove:function(){this.$store.commit(x.P$.RESET_SELECTION),this.$store.commit(x.P$.ADD_SELECTION_BOOKMARK,this.bookmark),this.$store.commit(x.P$.DISPLAY_MOVE_DIALOG,!0)},onCopy:function(){this.$store.commit(x.P$.RESET_SELECTION),this.$store.commit(x.P$.ADD_SELECTION_BOOKMARK,this.bookmark),this.$store.commit(x.P$.DISPLAY_COPY_DIALOG,!0)},onRename:function(){var t=this;return P(regeneratorRuntime.mark((function n(){return regeneratorRuntime.wrap((function(n){for(;;)switch(n.prev=n.next){case 0:t.renaming=!0;case 1:case"end":return n.stop()}}),n)})))()},onRenameSubmit:function(t){var n=this;return P(regeneratorRuntime.mark((function e(){return regeneratorRuntime.wrap((function(e){for(;;)switch(e.prev=e.next){case 0:return n.bookmark.title=t,e.next=3,n.$store.dispatch(x.Nw.SAVE_BOOKMARK,n.bookmark.id);case 3:n.renaming=!1;case 4:case"end":return e.stop()}}),e)})))()},onSelect:function(){this.selected?this.$store.commit(x.P$.REMOVE_SELECTION_BOOKMARK,this.bookmark):this.$store.commit(x.P$.ADD_SELECTION_BOOKMARK,this.bookmark)},onClick:function(){this.$store.dispatch(x.Nw.CLICK_BOOKMARK,this.bookmark)}}};var M=o(69552),Z={insert:"head",singleton:!1};m()(M.Z,Z);M.Z.locals;const U=(0,k.Z)(N,(function(){var t=this,n=t.$createElement,e=t._self._c||n;return e("Item",{attrs:{title:t.bookmark.title,tags:t.bookmark.tags,"rename-placeholder":t.t("bookmarks","Enter new title"),"select-label":t.t("bookmarks","Select bookmark"),active:t.isActive,editable:t.isEditable,selected:t.selected,draggable:t.isEditable,renaming:t.renaming,background:t.background,url:t.url,selectable:t.selectable},on:{select:t.onSelect,rename:t.onRenameSubmit,"rename-cancel":function(n){t.renaming=!1},click:t.onClick},scopedSlots:t._u([{key:"title",fn:function(){return[e("div",{staticClass:"bookmark__title"},[e("h3",{attrs:{title:t.bookmark.title}},[t.bookmark.preliminary?e("span",{staticClass:"icon-loading-small bookmark__icon"}):e("figure",{staticClass:"bookmark__icon",style:{backgroundImage:"url("+t.iconUrl+")"}}),t._v("\n\t\t\t\t"+t._s(t.bookmark.title)+"\n\t\t\t")]),t._v(" "),t.bookmark.description?e("span",{directives:[{name:"tooltip",rawName:"v-tooltip",value:t.bookmark.description,expression:"bookmark.description"}],staticClass:"bookmark__description"},[e("figure",{staticClass:"icon-file"}),t._v("\n\t\t\t\t"+t._s(t.bookmark.description))]):t._e()])]},proxy:!0},{key:"actions",fn:function(){return[e("ActionButton",{attrs:{icon:"icon-info","close-after-click":!0},on:{click:t.onDetails}},[t._v("\n\t\t\t"+t._s(t.t("bookmarks","Details"))+"\n\t\t")]),t._v(" "),e("ActionCheckbox",{on:{change:t.onSelect}},[t._v("\n\t\t\t"+t._s(t.t("bookmarks","Select bookmark"))+"\n\t\t")]),t._v(" "),e("ActionButton",{attrs:{icon:"icon-rename","close-after-click":!0},on:{click:t.onRename}},[t._v("\n\t\t\t"+t._s(t.t("bookmarks","Rename"))+"\n\t\t")]),t._v(" "),e("ActionButton",{attrs:{"close-after-click":!0},on:{click:t.onMove},scopedSlots:t._u([{key:"icon",fn:function(){return[e("FolderMoveIcon",{attrs:{"fill-color":t.colorMainText}})]},proxy:!0}])},[t._v("\n\t\t\t"+t._s(t.t("bookmarks","Move"))+"\n\t\t")]),t._v(" "),e("ActionButton",{attrs:{"close-after-click":!0},on:{click:t.onCopy},scopedSlots:t._u([{key:"icon",fn:function(){return[e("FolderPlusIcon",{attrs:{"fill-color":t.colorMainText}})]},proxy:!0}])},[t._v("\n\t\t\t"+t._s(t.t("bookmarks","Add to folders"))+"\n\t\t")]),t._v(" "),e("ActionButton",{attrs:{icon:"icon-delete","close-after-click":!0},on:{click:t.onDelete}},[t._v("\n\t\t\t"+t._s(t.t("bookmarks","Delete"))+"\n\t\t")])]},proxy:!0}])})}),[],!1,null,null,null).exports;var G=o(39345);function K(t,n,e,o,r,i,s){try{var a=t[i](s),l=a.value}catch(t){return void e(t)}a.done?n(l):Promise.resolve(l).then(o,r)}function Y(t){return function(){var n=this,e=arguments;return new Promise((function(o,r){var i=t.apply(n,e);function s(t){K(i,o,r,s,a,"next",t)}function a(t){K(i,o,r,s,a,"throw",t)}s(void 0)}))}}const q={name:"Folder",components:{Item:B,ActionButton:l(),ActionCheckbox:I(),FolderIcon:f.Z,FolderMoveIcon:F.Z,ShareVariantIcon:G.Z},props:{folder:{type:Object,required:!0}},data:function(){return{renaming:!1}},computed:{viewMode:function(){return this.$store.state.viewMode},currentUser:function(){return(0,R.getCurrentUser)().uid},isOwner:function(){var t=(0,R.getCurrentUser)();return t&&this.folder.userId===t.uid},permissions:function(){return this.$store.getters.getPermissionsForFolder(this.folder.id)},isEditable:function(){return this.isOwner||!this.isOwner&&this.permissions.canWrite},shares:function(){return this.$store.getters.getSharesOfFolder(this.folder.id)},publicToken:function(){return this.$store.getters.getTokenOfFolder(this.folder.id)},isShared:function(){return Boolean(this.shares.length)},isSharedPublicly:function(){return Boolean(this.publicToken)},selectedFolders:function(){return this.$store.state.selection.folders},selectable:function(){return Boolean(this.$store.state.selection.bookmarks.length||this.$store.state.selection.folders.length)},selected:function(){return this.selectedFolders.map((function(t){return t.id})).includes(this.folder.id)}},mounted:function(){var t=this;setTimeout((function(){t.$store.dispatch(x.Nw.LOAD_SHARES_OF_FOLDER,t.folder.id),t.$store.dispatch(x.Nw.LOAD_PUBLIC_LINK,t.folder.id),t.$store.dispatch(x.Nw.COUNT_BOOKMARKS,t.folder.id)}),2e3)},methods:{onDetails:function(){this.$store.dispatch(x.Nw.OPEN_FOLDER_DETAILS,this.folder.id)},onShare:function(){this.$store.dispatch(x.Nw.OPEN_FOLDER_SHARING,this.folder.id)},onDelete:function(){confirm(t("bookmarks","Do you really want to delete this folder?"))&&this.$store.dispatch(x.Nw.DELETE_FOLDER,{id:this.folder.id})},onMove:function(){this.$store.commit(x.P$.RESET_SELECTION),this.$store.commit(x.P$.ADD_SELECTION_FOLDER,this.folder),this.$store.commit(x.P$.DISPLAY_MOVE_DIALOG,!0)},onSelect:function(t){this.$router.push({name:this.routes.FOLDER,params:{folder:this.folder.id}}),t.preventDefault()},onRename:function(){var t=this;return Y(regeneratorRuntime.mark((function n(){return regeneratorRuntime.wrap((function(n){for(;;)switch(n.prev=n.next){case 0:t.renaming=!0;case 1:case"end":return n.stop()}}),n)})))()},onRenameSubmit:function(t){this.folder.title=t,this.$store.dispatch(x.Nw.SAVE_FOLDER,this.folder.id),this.renaming=!1},clickSelect:function(t){this.selected?this.$store.commit(x.P$.REMOVE_SELECTION_FOLDER,this.folder):this.$store.commit(x.P$.ADD_SELECTION_FOLDER,this.folder)},onEnter:function(t){"Enter"===t.key&&this.onSelect(t)},allowDrop:function(){return!this.$store.state.selection.folders.includes(this.folder)&&(this.$store.state.selection.folders.length||this.$store.state.selection.bookmarks.length)},onDrop:function(t){var n=this;return Y(regeneratorRuntime.mark((function e(){return regeneratorRuntime.wrap((function(e){for(;;)switch(e.prev=e.next){case 0:return t.preventDefault(),e.next=3,n.$store.dispatch(x.Nw.MOVE_SELECTION,n.folder.id);case 3:return n.$store.commit(x.P$.RESET_SELECTION),e.next=6,n.$store.dispatch(x.Nw.RELOAD_VIEW);case 6:case"end":return e.stop()}}),e)})))()}}};var z=o(24692),V={insert:"head",singleton:!1};m()(z.Z,V);z.Z.locals;const H=(0,k.Z)(q,(function(){var t=this,n=t.$createElement,e=t._self._c||n;return e("Item",{attrs:{active:t.selected,editable:t.isEditable,draggable:t.isEditable,selected:t.selected,title:t.folder.title,renaming:t.renaming,"select-label":t.t("bookmarks","Select folder"),"rename-placeholder":t.t("bookmarks","Enter folder title"),selectable:t.selectable,"allow-drop":t.allowDrop},on:{drop:t.onDrop,select:t.clickSelect,rename:t.onRenameSubmit,"rename-cancel":function(n){t.renaming=!1},click:t.onSelect},scopedSlots:t._u([{key:"icon",fn:function(){return[e("FolderIcon",{class:"folder__icon",attrs:{"fill-color":t.colorPrimaryElement},on:{click:t.onSelect}}),t._v(" "),t.isShared||!t.isOwner||t.isSharedPublicly?e("ShareVariantIcon",{class:["folder__icon","shared"],attrs:{"fill-color":t.colorPrimaryText}}):t._e()]},proxy:!0},{key:"title",fn:function(){return[e("h3",{staticClass:"folder__title"},[t._v("\n\t\t\t"+t._s(t.folder.title)+"\n\t\t")])]},proxy:!0},{key:"tags",fn:function(){return[e("div",{staticClass:"folder__tags"},[t.isOwner||t.isSharedPublicly?t._e():e("div",{staticClass:"folder__tag"},[t._v("\n\t\t\t\t"+t._s(t.t("bookmarks","Shared by {user}",{user:t.folder.userId}))+"\n\t\t\t")])])]},proxy:!0},{key:"actions",fn:function(){return[e("ActionButton",{attrs:{icon:"icon-info","close-after-click":!0},on:{click:t.onDetails}},[t._v("\n\t\t\t"+t._s(t.t("bookmarks","Details"))+"\n\t\t")]),t._v(" "),e("ActionCheckbox",{on:{change:t.clickSelect}},[t._v("\n\t\t\t"+t._s(t.t("bookmarks","Select folder"))+"\n\t\t")]),t._v(" "),t.permissions.canShare?e("ActionButton",{attrs:{icon:"icon-share","close-after-click":!0},on:{click:t.onShare}},[t._v("\n\t\t\t"+t._s(t.t("bookmarks","Share folder"))+"\n\t\t")]):t._e(),t._v(" "),e("ActionButton",{attrs:{icon:"icon-rename","close-after-click":!0},on:{click:t.onRename}},[t._v("\n\t\t\t"+t._s(t.t("bookmarks","Rename folder"))+"\n\t\t")]),t._v(" "),e("ActionButton",{attrs:{"close-after-click":!0},on:{click:t.onMove},scopedSlots:t._u([{key:"icon",fn:function(){return[e("FolderMoveIcon",{attrs:{"fill-color":t.colorMainText}})]},proxy:!0}])},[t._v("\n\t\t\t"+t._s(t.t("bookmarks","Move folder"))+"\n\t\t")]),t._v(" "),e("ActionButton",{attrs:{icon:"icon-delete","close-after-click":!0},on:{click:t.onDelete}},[t._v("\n\t\t\t"+t._s(t.t("bookmarks","Delete folder"))+"\n\t\t")])]},proxy:!0}])})}),[],!1,null,null,null).exports;function W(t,n){var e=Object.keys(t);if(Object.getOwnPropertySymbols){var o=Object.getOwnPropertySymbols(t);n&&(o=o.filter((function(n){return Object.getOwnPropertyDescriptor(t,n).enumerable}))),e.push.apply(e,o)}return e}function j(t){for(var n=1;n<arguments.length;n++){var e=null!=arguments[n]?arguments[n]:{};n%2?W(Object(e),!0).forEach((function(n){Q(t,n,e[n])})):Object.getOwnPropertyDescriptors?Object.defineProperties(t,Object.getOwnPropertyDescriptors(e)):W(Object(e)).forEach((function(n){Object.defineProperty(t,n,Object.getOwnPropertyDescriptor(e,n))}))}return t}function Q(t,n,e){return n in t?Object.defineProperty(t,n,{value:e,enumerable:!0,configurable:!0,writable:!0}):t[n]=e,t}const J={name:"CreateBookmark",components:{Item:B,EarthIcon:g.Z},computed:{creating:function(){return this.$store.state.loading.createBookmark},isFolderView:function(){return this.$route.name===this.$store.getters.getRoutes().FOLDER},isTagView:function(){return this.$route.name===this.$store.getters.getRoutes().TAGS}},methods:{submit:function(t){this.$store.dispatch(x.Nw.CREATE_BOOKMARK,j(j({url:t},this.isFolderView&&{folders:[this.$route.params.folder]}),this.isTagView&&{tags:this.$route.params.tags.split(",")}))},cancel:function(){this.$store.commit(x.P$.DISPLAY_NEW_BOOKMARK,!1)}}};var X=o(58211),tt={insert:"head",singleton:!1};m()(X.Z,tt);X.Z.locals;const nt=(0,k.Z)(J,(function(){var t=this,n=t.$createElement,e=t._self._c||n;return e("Item",{attrs:{selectable:!1,renaming:!0,title:"",editable:!0,"rename-placeholder":t.t("bookmarks","Enter a link"),"select-label":""},on:{rename:t.submit,"rename-cancel":t.cancel},scopedSlots:t._u([{key:"icon",fn:function(){return[e("EarthIcon",{staticClass:"icon",attrs:{"fill-color":t.colorMainText}})]},proxy:!0}])})}),[],!1,null,"32fb8798",null).exports;const et={name:"CreateFolder",components:{Item:B,FolderIcon:f.Z},computed:{loading:function(){return this.$store.state.loading.createFolder}},methods:{submit:function(t){var n=this.$route.params.folder;this.$store.dispatch(x.Nw.CREATE_FOLDER,{parentFolder:n,title:t})},cancel:function(){this.$store.commit(x.P$.DISPLAY_NEW_FOLDER,!1)}}};var ot=o(962),rt={insert:"head",singleton:!1};m()(ot.Z,rt);ot.Z.locals;const it=(0,k.Z)(et,(function(){var t=this,n=t.$createElement,e=t._self._c||n;return e("Item",{attrs:{selectable:!1,renaming:!0,title:"",editable:!0,"rename-placeholder":t.t("bookmarks","Enter a title"),"select-label":""},on:{rename:t.submit,"rename-cancel":t.cancel},scopedSlots:t._u([{key:"icon",fn:function(){return[e("FolderIcon",{staticClass:"icon",attrs:{"fill-color":t.colorPrimaryElement}})]},proxy:!0}])})}),[],!1,null,"c3795188",null).exports;var st=o(97e3),at=o.n(st),lt=o(72658),ct=o(25108);function At(t,n,e,o,r,i,s){try{var a=t[i](s),l=a.value}catch(t){return void e(t)}a.done?n(l):Promise.resolve(l).then(o,r)}const dt={name:"NoBookmarks",components:{EmptyContent:at(),SyncIcon:lt.Z},data:function(){return{importing:!1}},computed:{routes:function(){return c.xu}},methods:{onImportOpen:function(){this.$refs.import.click()},onSyncOpen:function(){window.open("https://floccus.org","_blank")},onImportSubmit:function(t){var n,e=this;return(n=regeneratorRuntime.mark((function n(){return regeneratorRuntime.wrap((function(n){for(;;)switch(n.prev=n.next){case 0:return e.importing=!0,n.prev=1,n.next=4,e.$store.dispatch(x.Nw.IMPORT_BOOKMARKS,{file:t.target.files[0],folder:e.$route.params.folder||-1});case 4:n.next=9;break;case 6:n.prev=6,n.t0=n.catch(1),ct.warn(n.t0);case 9:e.importing=!1;case 10:case"end":return n.stop()}}),n,null,[[1,6]])})),function(){var t=this,e=arguments;return new Promise((function(o,r){var i=n.apply(t,e);function s(t){At(i,o,r,s,a,"next",t)}function a(t){At(i,o,r,s,a,"throw",t)}s(void 0)}))})()}}};var mt=o(6344),ut={insert:"head",singleton:!1};m()(mt.Z,ut);mt.Z.locals;const pt={name:"BookmarksList",components:{NoBookmarks:(0,k.Z)(dt,(function(){var t=this,n=t.$createElement,e=t._self._c||n;return e("div",{staticClass:"bookmarkslist__emptyBookmarks"},[t.$route.name===t.routes.ARCHIVED?e("EmptyContent",{scopedSlots:t._u([{key:"desc",fn:function(){return[t._v("\n\t\t\t"+t._s(t.t("bookmarks","Bookmarks to files like photos or PDFs will automatically be saved to your Nextcloud files, so you can still find them even when the link goes offline."))+"\n\t\t")]},proxy:!0}],null,!1,1857868770)},[t._v("\n\t\t"+t._s(t.t("bookmarks","No bookmarked files"))+"\n\t\t")]):e("EmptyContent",{attrs:{icon:"icon-favorite"},scopedSlots:t._u([t.isPublic?null:{key:"desc",fn:function(){return[e("p",[t._v(t._s(t.t("bookmarks","Start by importing bookmarks from a file or synchronizing your browser bookmarks with this app")))]),t._v(" "),e("input",{ref:"import",staticClass:"import",attrs:{type:"file",size:"5"},on:{change:t.onImportSubmit}}),t._v(" "),e("button",{on:{click:t.onImportOpen}},[e("span",{class:{"icon-upload":!t.importing,"icon-loading-small":t.importing}}),t._v(" "+t._s(t.t("bookmarks","Import bookmarks"))+"\n\t\t\t")]),t._v(" "),e("button",{on:{click:t.onSyncOpen}},[e("SyncIcon",{style:{opacity:.5},attrs:{"fill-color":t.colorMainText,size:18}}),t._v(" "+t._s(t.t("bookmarks","Sync with your browser"))+"\n\t\t\t")],1)]},proxy:!0}],null,!0)},[t._v("\n\t\t"+t._s(t.t("bookmarks","No bookmarks here"))+"\n\t\t")])],1)}),[],!1,null,"833d7fe0",null).exports,Bookmark:U,Folder:H,CreateBookmark:nt,CreateFolder:it},props:{bookmarks:{type:Array,required:!0}},data:function(){return{showLoading:!0,loadingTimeout:null}},computed:{children:function(){if(this.$route.name!==this.routes.HOME&&this.$route.name!==this.routes.FOLDER)return[];var t=this.$route.params.folder||"-1";return t?this.$store.getters.getFolderChildren(t):[]},subFolders:function(){if(this.$route.name!==this.routes.HOME&&this.$route.name!==this.routes.FOLDER)return[];var t=this.$route.params.folder||"-1";if(!t)return[];var n=this.$store.getters.getFolder(t)[0];return n?(this.$store.dispatch(x.Nw.LOAD_SHARES_OF_FOLDER,t),n.children):[]},newBookmark:function(){return this.$store.state.displayNewBookmark},newFolder:function(){return this.$store.state.displayNewFolder},viewMode:function(){return this.$store.state.viewMode},sortOrder:function(){return this.$store.state.settings.sorting},loading:function(){return this.$store.state.loading.bookmarks||this.$store.state.loading.folders}},watch:{loading:function(t,n){var e=this;t&&!n?this.loadingTimeout=setTimeout((function(){e.showLoading=!0}),500):!t&&n&&(clearTimeout(this.loadingTimeout),this.showLoading=!1)}},methods:{onScroll:function(){this.$el.scrollHeight<this.$el.scrollTop+this.$el.clientHeight+500&&this.$store.dispatch(x.Nw.FETCH_PAGE)},getFolder:function(t){return this.$store.getters.getFolder(t)[0]},getBookmark:function(t){return this.$store.getters.getBookmark(t)}}};var kt=o(95674),ht={insert:"head",singleton:!1};m()(kt.Z,ht);kt.Z.locals;const ft=(0,k.Z)(pt,(function(){var t=this,n=t.$createElement,e=t._self._c||n;return e("div",{class:{bookmarkslist:!0,"bookmarkslist--gridview":"grid"===t.viewMode},on:{scroll:t.onScroll}},[e("div",{staticClass:"padding"},[t.$route.name===t.routes.ARCHIVED&&t.bookmarks.length?e("div",{staticClass:"bookmarkslist__description"},[t._v("\n\t\t\t"+t._s(t.t("bookmarks","Bookmarks to files on the web like photos or PDFs will automatically be saved to your Nextcloud files, so you can still find them even when the link goes offline."))+"\n\t\t")]):t._e(),t._v(" "),t.newBookmark?e("CreateBookmark"):t._e(),t._v(" "),t.newFolder?e("CreateFolder"):t._e(),t._v(" "),t.$route.name===t.routes.FOLDER||t.$route.name===t.routes.HOME?["index"===t.sortOrder&&t.children.length?[t._l(t.children,(function(n){return["folder"===n.type&&t.getFolder(n.id)?e("Folder",{key:n.type+n.id,attrs:{folder:t.getFolder(n.id)}}):t._e(),t._v(" "),"bookmark"===n.type&&t.getBookmark(n.id)?e("Bookmark",{key:n.type+n.id,attrs:{bookmark:t.getBookmark(n.id)}}):t._e()]}))]:!t.subFolders.length&&!t.bookmarks.length||t.loading?t.loading?t._e():e("NoBookmarks"):[t._l(t.subFolders,(function(t){return e("Folder",{key:"folder"+t.id,attrs:{folder:t}})})),t._v(" "),t.bookmarks.length?t._l(t.bookmarks,(function(t){return e("Bookmark",{key:"bookmark"+t.id,attrs:{bookmark:t}})})):t._e()]]:t.bookmarks.length?t._l(t.bookmarks,(function(t){return e("Bookmark",{key:"bookmark"+t.id,attrs:{bookmark:t}})})):t.loading?t._e():e("NoBookmarks"),t._v(" "),t.showLoading?e("div",{staticClass:"bookmarkslist__loading"},[e("figure",{staticClass:"icon-loading"})]):t._e()],2)])}),[],!1,null,null,null).exports},72330:(n,e,o)=>{"use strict";o.d(e,{Z:()=>H});var r=o(7811),i=o.n(r),s=o(79440),a=o.n(s),l=o(56286),c=o.n(l),A=o(88408),d=o.n(A),m=o(94274),u=o.n(m),p=o(35621),k=o(25990),h=o(78174),f=o(92465),g=o(8751),b=o(73126),C=o(66309),v=o(95996),_=o(39790),x=o(79753),w=o(33521),y=o.n(w),$=o(81328),E=o(19383),S=o(25325),B=o.n(S);function O(t){return function(t){if(Array.isArray(t))return F(t)}(t)||function(t){if("undefined"!=typeof Symbol&&null!=t[Symbol.iterator]||null!=t["@@iterator"])return Array.from(t)}(t)||T(t)||function(){throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.")}()}function I(t,n){var e="undefined"!=typeof Symbol&&t[Symbol.iterator]||t["@@iterator"];if(!e){if(Array.isArray(t)||(e=T(t))||n&&t&&"number"==typeof t.length){e&&(t=e);var o=0,r=function(){};return{s:r,n:function(){return o>=t.length?{done:!0}:{done:!1,value:t[o++]}},e:function(t){throw t},f:r}}throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.")}var i,s=!0,a=!1;return{s:function(){e=e.call(t)},n:function(){var t=e.next();return s=t.done,t},e:function(t){a=!0,i=t},f:function(){try{s||null==e.return||e.return()}finally{if(a)throw i}}}}function T(t,n){if(t){if("string"==typeof t)return F(t,n);var e=Object.prototype.toString.call(t).slice(8,-1);return"Object"===e&&t.constructor&&(e=t.constructor.name),"Map"===e||"Set"===e?Array.from(t):"Arguments"===e||/^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(e)?F(t,n):void 0}}function F(t,n){(null==n||n>t.length)&&(n=t.length);for(var e=0,o=new Array(n);e<n;e++)o[e]=t[e];return o}function R(t,n,e,o,r,i,s){try{var a=t[i](s),l=a.value}catch(t){return void e(t)}a.done?n(l):Promise.resolve(l).then(o,r)}function D(t){return function(){var n=this,e=arguments;return new Promise((function(o,r){var i=t.apply(n,e);function s(t){R(i,o,r,s,a,"next",t)}function a(t){R(i,o,r,s,a,"throw",t)}s(void 0)}))}}const L={name:"BulkEditing",components:{ActionInput:d(),ActionSeparator:y(),FolderPlusIcon:$.Z,FolderMoveIcon:E.Z,ActionButton:c(),Actions:a()},data:function(){return{selectionTags:[]}},computed:{allTags:function(){return this.$store.state.tags.map((function(t){return t.name}))},selectedFolders:function(){return this.$store.state.selection.folders},selectedBookmarks:function(){return this.$store.state.selection.bookmarks},selectionDescription:function(){return 0!==this.$store.state.selection.bookmarks.length&&0!==this.$store.state.selection.folders.length?this.t("bookmarks","Selected {folders} folders and {bookmarks} bookmarks",{folders:this.$store.state.selection.folders.length,bookmarks:this.$store.state.selection.bookmarks.length}):0!==this.$store.state.selection.bookmarks.length?this.n("bookmarks","Selected %n bookmark","Selected %n bookmarks",this.$store.state.selection.bookmarks.length):0!==this.$store.state.selection.folders.length?this.n("bookmarks","Selected %n folder","Selected %n folders",this.$store.state.selection.folders.length):""}},watch:{selectedBookmarks:function(t){this.updateSelectionTags()}},methods:{onBulkOpen:function(){var t=this;return D(regeneratorRuntime.mark((function n(){var e,o,r;return regeneratorRuntime.wrap((function(n){for(;;)switch(n.prev=n.next){case 0:e=I(t.$store.state.selection.bookmarks),n.prev=1,e.s();case 3:if((o=e.n()).done){n.next=10;break}return r=o.value.url,window.open(r),n.next=8,new Promise((function(t){return setTimeout(t,200)}));case 8:n.next=3;break;case 10:n.next=15;break;case 12:n.prev=12,n.t0=n.catch(1),e.e(n.t0);case 15:return n.prev=15,e.f(),n.finish(15);case 18:case"end":return n.stop()}}),n,null,[[1,12,15,18]])})))()},onBulkDelete:function(){var n=this;return D(regeneratorRuntime.mark((function e(){return regeneratorRuntime.wrap((function(e){for(;;)switch(e.prev=e.next){case 0:if(confirm(t("bookmarks","Do you really want to delete these items?"))){e.next=2;break}return e.abrupt("return");case 2:return e.next=4,n.$store.dispatch(_.Nw.DELETE_SELECTION,{folder:n.$route.params.folder});case 4:n.$store.commit(_.P$.RESET_SELECTION);case 5:case"end":return e.stop()}}),e)})))()},onBulkMove:function(){this.$store.commit(_.P$.DISPLAY_MOVE_DIALOG,!0)},onBulkCopy:function(){this.$store.commit(_.P$.DISPLAY_COPY_DIALOG,!0)},onBulkTag:function(t){var n=this;return D(regeneratorRuntime.mark((function e(){var o;return regeneratorRuntime.wrap((function(e){for(;;)switch(e.prev=e.next){case 0:return o=n.selectionTags,n.selectionTags=t,e.next=4,n.$store.dispatch(_.Nw.TAG_SELECTION,{tags:t,originalTags:o});case 4:case"end":return e.stop()}}),e)})))()},onCancelSelection:function(){this.$store.commit(_.P$.RESET_SELECTION)},onSelectAll:function(){var t=this;return D(regeneratorRuntime.mark((function n(){return regeneratorRuntime.wrap((function(n){for(;;)switch(n.prev=n.next){case 0:return n.next=2,t.$store.dispatch(_.Nw.FETCH_ALL);case 2:t.$store.state.bookmarks.forEach((function(n){t.$store.commit(_.P$.ADD_SELECTION_BOOKMARK,n)}));case 3:case"end":return n.stop()}}),n)})))()},updateSelectionTags:function(){this.selectionTags=B().apply(void 0,O(this.selectedBookmarks.map((function(t){return t.tags}))))}}};var P=o(93379),N=o.n(P),M=o(41138),Z={insert:"head",singleton:!1};N()(M.Z,Z);M.Z.locals;var U=o(51900);const G=(0,U.Z)(L,(function(){var t=this,n=t.$createElement,e=t._self._c||n;return e("div",{staticClass:"bulkediting"},[e("Actions",{attrs:{primary:!0,"menu-title":t.selectionDescription}},[e("ActionButton",{attrs:{icon:"icon-external","close-after-click":""},on:{click:t.onBulkOpen}},[t._v("\n\t\t\t"+t._s(t.t("bookmarks","Open all selected"))+"\n\t\t")]),t._v(" "),e("ActionButton",{attrs:{"close-after-click":""},on:{click:t.onBulkMove},scopedSlots:t._u([{key:"icon",fn:function(){return[e("FolderMoveIcon",{staticClass:"action-button-mdi-icon",attrs:{"fill-color":t.colorMainText}})]},proxy:!0}])},[t._v("\n\t\t\t"+t._s(t.t("bookmarks","Move selection"))+"\n\t\t")]),t._v(" "),t.selectedFolders.length?t._e():e("ActionButton",{attrs:{"close-after-click":""},on:{click:t.onBulkCopy},scopedSlots:t._u([{key:"icon",fn:function(){return[e("FolderPlusIcon",{staticClass:"action-button-mdi-icon",attrs:{"fill-color":t.colorMainText}})]},proxy:!0}],null,!1,3915907570)},[t._v("\n\t\t\t"+t._s(t.t("bookmarks","Add to folders"))+"\n\t\t")]),t._v(" "),t.selectedFolders.length?t._e():e("ActionInput",{attrs:{value:t.selectionTags,icon:"icon-tag",type:"multiselect",options:t.allTags,multiple:!0,taggable:!0},on:{tag:function(n){return t.onBulkTag(t.selectionTags.concat([n]))},input:t.onBulkTag}},[t._v("\n\t\t\t"+t._s(t.t("bookmarks","Edit tags of selection"))+"\n\t\t")]),t._v(" "),e("ActionButton",{attrs:{icon:"icon-delete","close-after-click":""},on:{click:t.onBulkDelete}},[t._v("\n\t\t\t"+t._s(t.t("bookmarks","Delete selection"))+"\n\t\t")]),t._v(" "),e("ActionSeparator"),t._v(" "),e("ActionButton",{attrs:{icon:"icon-checkmark"},on:{click:t.onSelectAll}},[t._v("\n\t\t\t"+t._s(t.t("bookmarks","Select all"))+"\n\t\t")]),t._v(" "),e("ActionButton",{attrs:{icon:"icon-close"},on:{click:t.onCancelSelection}},[t._v("\n\t\t\t"+t._s(t.t("bookmarks","Cancel selection"))+"\n\t\t")])],1)],1)}),[],!1,null,null,null).exports;var K=o(735);function Y(t,n,e,o,r,i,s){try{var a=t[i](s),l=a.value}catch(t){return void e(t)}a.done?n(l):Promise.resolve(l).then(o,r)}const q={name:"Controls",components:{BulkEditing:G,Multiselect:i(),Actions:a(),ActionButton:c(),ActionInput:d(),ActionRouter:u(),RssIcon:h.Z,SortAscendingIcon:v.Z,SortCalendarAscendingIcon:C.Z,SortAlphabeticalAscendingIcon:f.Z,SortClockAscendingOutlineIcon:b.Z,SortBoolAscendingIcon:g.Z,FolderIcon:p.Z,ArrowLeftIcon:k.Z},props:{},data:function(){return{url:"",search:this.$route.params.search||"",sortingOptions:{added:{icon:"SortCalendarAscendingIcon",description:this.t("bookmarks","Sort by created date")},lastmodified:{icon:"SortClockAscendingOutlineIcon",description:this.t("bookmarks","Sort by last modified")},title:{icon:"SortAlphabeticalAscendingIcon",description:this.t("bookmarks","Sort by title")},clickcount:{icon:"SortBoolAscendingIcon",description:this.t("bookmarks","Sort by click count")},index:{icon:"SortAscendingIcon",description:this.t("bookmarks","Sort by manual order")}}}},computed:{backLink:function(){return this.folder&&this.folderPath.length>1?{name:this.routes.FOLDER,params:{folder:this.folder.parent_folder}}:{name:this.routes.HOME}},permissions:function(){var t=this.folder;return t?this.$store.getters.getPermissionsForFolder(t.id):{}},allTags:function(){return this.$store.state.tags.map((function(t){return t.name}))},tags:function(){var t=this.$route.params.tags;return t?t.split(","):[]},folderPath:function(){var t=this.$route.params.folder;return t?this.$store.getters.getFolder(t).reverse():[]},folder:function(){var t=this.$route.params.folder;if(t)return this.$store.getters.getFolder(t)[0]},viewMode:function(){return this.$store.state.viewMode},hasSelection:function(){return this.$store.state.selection.bookmarks.length||this.$store.state.selection.folders.length},rssURL:function(){var t=this,n=new URLSearchParams,e=function(e){Array.isArray(t.$store.state.fetchState.query[e])?t.$store.state.fetchState.query[e].forEach((function(t){n.append(e+"[]",t)})):n.append(e,t.$store.state.fetchState.query[e])};for(var o in this.$store.state.fetchState.query)e(o);return n.set("format","rss"),n.set("page","-1"),this.$store.state.public&&n.set("token",this.$store.state.authToken),window.location.origin+(0,x.nu)("/apps/bookmarks/public/rest/v2/bookmark?"+n.toString())},sorting:function(){return this.$store.state.settings.sorting}},created:function(){},methods:{onSelectHome:function(){this.$router.push({name:this.routes.HOME})},onClickBack:function(){this.$router.push(this.backLink)},onTagsChange:function(t){this.$router.push({name:this.routes.TAGS,params:{tags:t.join(",")}})},onSelectFolder:function(t){this.$router.push({name:this.routes.FOLDER,params:{folder:t}})},onOpenFolderShare:function(){this.$store.dispatch(_.Nw.OPEN_FOLDER_SHARING,this.folder.id)},onAddFolder:function(){this.$store.commit(_.P$.DISPLAY_NEW_FOLDER,!this.$store.state.displayNewFolder)},onAddBookmark:function(){this.$store.commit(_.P$.DISPLAY_NEW_BOOKMARK,!this.$store.state.displayNewBookmark)},onToggleViewMode:function(){this.$store.dispatch(_.Nw.SET_SETTING,{key:"viewMode",value:"grid"===this.$store.state.viewMode?"list":"grid"})},copyRssUrl:function(){(0,K.Z)(this.rssURL),this.$store.commit(_.P$.SET_NOTIFICATION,t("bookmarks","RSS feed copied"))},onChangeSorting:function(t){var n,e=this;return(n=regeneratorRuntime.mark((function n(){return regeneratorRuntime.wrap((function(n){for(;;)switch(n.prev=n.next){case 0:return n.next=2,e.$store.dispatch(_.Nw.SET_SETTING,{key:"sorting",value:t});case 2:return n.next=4,e.$store.dispatch(_.Nw.FETCH_PAGE);case 4:case"end":return n.stop()}}),n)})),function(){var t=this,e=arguments;return new Promise((function(o,r){var i=n.apply(t,e);function s(t){Y(i,o,r,s,a,"next",t)}function a(t){Y(i,o,r,s,a,"throw",t)}s(void 0)}))})()}}};var z=o(15051),V={insert:"head",singleton:!1};N()(z.Z,V);z.Z.locals;const H=(0,U.Z)(q,(function(){var t=this,n=t.$createElement,e=t._self._c||n;return e("div",{class:["controls",t.$store.state.public&&"wide"]},[e("div",{staticClass:"controls__left"},[t.$route.name===t.routes.FOLDER?e("Actions",[e("ActionButton",{on:{click:t.onClickBack}},[e("ArrowLeftIcon",{attrs:{slot:"icon",size:18,"fill-color":t.colorMainText},slot:"icon"}),t._v("\n\t\t\t\t"+t._s(t.t("bookmarks","Go back"))+"\n\t\t\t")],1)],1):t._e(),t._v(" "),t.$route.name===t.routes.FOLDER?[e("h2",[e("FolderIcon",{attrs:{size:18,"fill-color":t.colorMainText}}),t._v(" "),e("span",[t._v(t._s(t.folder.title))])],1),t._v(" "),t.permissions.canShare?e("Actions",[e("ActionButton",{attrs:{icon:"icon-share","close-after-click":!0},on:{click:t.onOpenFolderShare}},[t._v("\n\t\t\t\t\t"+t._s(t.t("bookmarks","Share folder"))+"\n\t\t\t\t")])],1):t._e()]:t._e(),t._v(" "),t.$route.name===t.routes.TAGS?[e("span",{staticClass:"icon-tag"}),t._v(" "),e("Multiselect",{staticClass:"controls__tags",attrs:{value:t.tags,"auto-limit":!1,limit:7,options:t.allTags,multiple:!0,placeholder:t.t("bookmarks","Select one or more tags")},on:{input:t.onTagsChange}})]:t._e(),t._v(" "),t.isPublic?t._e():e("Actions",{directives:[{name:"tooltip",rawName:"v-tooltip",value:t.t("bookmarks","New"),expression:"t('bookmarks', 'New')"}],attrs:{title:t.t("bookmarks","New"),"default-icon":"icon-add"}},[e("ActionButton",{attrs:{icon:"icon-link","close-after-click":!0},on:{click:t.onAddBookmark}},[t._v("\n\t\t\t\t"+t._s(t.t("bookmarks","New bookmark"))+"\n\t\t\t")]),t._v(" "),e("ActionButton",{attrs:{icon:"icon-folder","close-after-click":!0},on:{click:t.onAddFolder}},[t._v("\n\t\t\t\t"+t._s(t.t("bookmarks","New folder"))+"\n\t\t\t")])],1),t._v(" "),t.hasSelection?e("BulkEditing"):t._e()],2),t._v(" "),e("div",{staticClass:"controls__right"},[e("Actions",[e("ActionButton",{attrs:{icon:"list"===t.viewMode?"icon-toggle-pictures":"icon-toggle-filelist"},on:{click:t.onToggleViewMode}},[t._v("\n\t\t\t\t"+t._s("list"===t.viewMode?t.t("bookmarks","Change to grid view"):t.t("bookmarks","Change to list view"))+"\n\t\t\t")])],1),t._v(" "),e("Actions",{directives:[{name:"tooltip",rawName:"v-tooltip",value:t.sortingOptions[t.sorting].description,expression:"sortingOptions[sorting].description"}],scopedSlots:t._u([{key:"icon",fn:function(){return[e(t.sortingOptions[t.sorting].icon,{tag:"component",attrs:{size:20,"fill-color":t.colorMainText}})]},proxy:!0}])},[t._v(" "),t._l(t.sortingOptions,(function(n,o){return e("ActionButton",{key:o,attrs:{"close-after-click":!0},on:{click:function(n){return t.onChangeSorting(o)}},scopedSlots:t._u([{key:"icon",fn:function(){return[e(n.icon,{tag:"component",attrs:{size:20,"fill-color":o===t.sorting?t.colorPrimaryElement:t.colorMainText}})]},proxy:!0}],null,!0)},[t._v("\n\t\t\t\t"+t._s(n.description)+"\n\t\t\t")])}))],2),t._v(" "),e("Actions",{attrs:{"force-menu":""},scopedSlots:t._u([{key:"icon",fn:function(){return[e("RssIcon",{staticClass:"action-button-mdi-icon",attrs:{"fill-color":t.colorMainText,size:20}})]},proxy:!0}])},[t._v(" "),e("ActionButton",{attrs:{title:t.t("bookmarks","Copy RSS Feed of current view"),"close-after-click":!0},on:{click:t.copyRssUrl},scopedSlots:t._u([{key:"icon",fn:function(){return[e("RssIcon",{staticClass:"action-button-mdi-icon",attrs:{"fill-color":t.colorMainText,size:20}})]},proxy:!0}])},[t._v("\n\t\t\t\t"+t._s(t.$store.state.public?"":t.t("bookmarks","The RSS feed requires authentication with your Nextcloud credentials"))+"\n\t\t\t")])],1)],1)])}),[],!1,null,null,null).exports},75347:()=>{},36648:()=>{},31777:()=>{}}]);
//# sourceMappingURL=bookmarks-src_components_BookmarkContent_vue-src_components_BookmarksList_vue-src_components_Controls_vue.js.map?v=6720b925a86313aeb767