/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sdedit.ui.components.configuration;

import java.awt.BorderLayout;
import java.awt.Component;
import java.io.IOException;
import java.net.URL;
import java.util.LinkedList;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JPanel;
import net.sf.sdedit.ui.components.configuration.Bean;
import net.sf.sdedit.ui.components.configuration.ConfigurationUI;
import net.sf.sdedit.ui.components.configuration.ConfigurationUIListener;
import net.sf.sdedit.ui.components.configuration.DataObject;
import net.sf.sdedit.util.DocUtil;

public class BeanPane
extends JPanel
implements ConfigurationUIListener {
    private LinkedList<ConfigurationUIListener> listeners;
    private String description;
    private Bean<?> bean;
    private ConfigurationUI<?> cui;
    private boolean tabbed;
    private Map<String, Component> additionalTabs;

    public BeanPane(String description) {
        this(description, false);
    }

    public BeanPane(String description, boolean tabbed) {
        this.tabbed = tabbed;
        this.description = description;
        this.listeners = new LinkedList();
        this.additionalTabs = new TreeMap<String, Component>();
        this.setLayout(new BorderLayout());
    }

    public void addTab(Component tab, String title) {
        this.additionalTabs.put(title, tab);
    }

    public void addListener(ConfigurationUIListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(ConfigurationUIListener listener) {
        this.listeners.remove(listener);
    }

    public <D extends DataObject> Bean<D> load(Class<D> beanClass, URL configurationFile) throws DocUtil.XMLException, IOException {
        Bean<D> newBean = new Bean<D>(beanClass, null);
        newBean.load(configurationFile);
        this.load(newBean);
        return newBean;
    }

    public Bean<?> getBean() {
        return this.bean;
    }

    public ConfigurationUI<?> getConfigurationUI() {
        return this.cui;
    }

    public <D extends DataObject> void load(Bean<D> newBean) {
        this.cui = new ConfigurationUI<D>(this, newBean, null, null, null, this.description, this.tabbed);
        this.removeAll();
        this.cui.hideButtons();
        if (this.cui.getCategoryPanels().size() == 1) {
            this.cui.hideCategoryList();
        }
        this.add(this.cui, "Center");
        for (String name : this.additionalTabs.keySet()) {
            this.cui.addTab(this.additionalTabs.get(name), name);
        }
        this.revalidate();
        this.bean = newBean;
    }

    @Override
    public void applyConfiguration() {
    }

    @Override
    public void cancelConfiguration() {
    }
}

