// Automatically generated file. DO NOT EDIT.
// Generated by gen-device-avr.go from ATtiny1634.atdf, see http://packs.download.atmel.com/

//go:build avr && attiny1634
// +build avr,attiny1634

// Device information for the ATtiny1634.
package avr

import (
	"runtime/volatile"
	"unsafe"
)

// Some information about this device.
const (
	DEVICE = "ATtiny1634"
	ARCH   = "AVR8"
	FAMILY = "tinyAVR"
)

// Interrupts
const (
	IRQ_RESET        = 0  // External Pin, Power-on Reset, Brown-out Reset and Watchdog Reset
	IRQ_INT0         = 1  // External Interrupt Request 0
	IRQ_PCINT0       = 2  // Pin Change Interrupt Request 0
	IRQ_PCINT1       = 3  // Pin Change Interrupt Request 1
	IRQ_PCINT2       = 4  // Pin Change Interrupt Request 2
	IRQ_WDT          = 5  // Watchdog Time-out Interrupt
	IRQ_TIMER1_CAPT  = 6  // Timer/Counter1 Capture Event
	IRQ_TIM1_CAPT    = 6  // Timer/Counter1 Capture Event
	IRQ_TIMER1_COMPA = 7  // Timer/Counter1 Compare Match A
	IRQ_TIM1_COMPA   = 7  // Timer/Counter1 Compare Match A
	IRQ_TIMER1_COMPB = 8  // Timer/Counter1 Compare Match B
	IRQ_TIM1_COMPB   = 8  // Timer/Counter1 Compare Match B
	IRQ_TIMER1_OVF   = 9  // Timer/Counter1 Overflow
	IRQ_TIM1_OVF     = 9  // Timer/Counter1 Overflow
	IRQ_TIMER0_COMPA = 10 // TimerCounter0 Compare Match A
	IRQ_TIM0_COMPA   = 10 // TimerCounter0 Compare Match A
	IRQ_TIMER0_COMPB = 11 // TimerCounter0 Compare Match B
	IRQ_TIM0_COMPB   = 11 // TimerCounter0 Compare Match B
	IRQ_TIMER0_OVF   = 12 // Timer/Couner0 Overflow
	IRQ_TIM0_OVF     = 12 // Timer/Couner0 Overflow
	IRQ_ANA_COMP     = 13 // Analog Comparator
	IRQ_ADC          = 14 // ADC Conversion Complete
	IRQ_ADC_READY    = 14 // ADC Conversion Complete
	IRQ_USART0_START = 15 // USART0, Start
	IRQ_USART0_RXS   = 15 // USART0, Start
	IRQ_USART0_RX    = 16 // USART0, Rx Complete
	IRQ_USART0_RXC   = 16 // USART0, Rx Complete
	IRQ_USART0_UDRE  = 17 // USART0 Data Register Empty
	IRQ_USART0_DRE   = 17 // USART0 Data Register Empty
	IRQ_USART0_TX    = 18 // USART0, Tx Complete
	IRQ_USART0_TXC   = 18 // USART0, Tx Complete
	IRQ_USART1_START = 19 // USART1, Start
	IRQ_USART1_RXS   = 19 // USART1, Start
	IRQ_USART1_RX    = 20 // USART1, Rx Complete
	IRQ_USART1_RXC   = 20 // USART1, Rx Complete
	IRQ_USART1_UDRE  = 21 // USART1 Data Register Empty
	IRQ_USART1_DRE   = 21 // USART1 Data Register Empty
	IRQ_USART1_TX    = 22 // USART1, Tx Complete
	IRQ_USART1_TXC   = 22 // USART1, Tx Complete
	IRQ_USI_START    = 23 // USI Start Condition
	IRQ_USI_STR      = 23 // USI Start Condition
	IRQ_USI_OVERFLOW = 24 // USI Overflow
	IRQ_USI_OVF      = 24 // USI Overflow
	IRQ_TWI_SLAVE    = 25 // Two-wire Serial Interface
	IRQ_TWI          = 25 // Two-wire Serial Interface
	IRQ_EE_RDY       = 26 // EEPROM Ready
	IRQ_QTRIP        = 27 // Touch Sensing
	IRQ_max          = 27 // Highest interrupt number on this device.
)

// Pseudo function call that is replaced by the compiler with the actual
// functions registered through interrupt.New.
//go:linkname callHandlers runtime/interrupt.callHandlers
func callHandlers(num int)

//export __vector_RESET
//go:interrupt
func interruptRESET() {
	callHandlers(IRQ_RESET)
}

//export __vector_INT0
//go:interrupt
func interruptINT0() {
	callHandlers(IRQ_INT0)
}

//export __vector_PCINT0
//go:interrupt
func interruptPCINT0() {
	callHandlers(IRQ_PCINT0)
}

//export __vector_PCINT1
//go:interrupt
func interruptPCINT1() {
	callHandlers(IRQ_PCINT1)
}

//export __vector_PCINT2
//go:interrupt
func interruptPCINT2() {
	callHandlers(IRQ_PCINT2)
}

//export __vector_WDT
//go:interrupt
func interruptWDT() {
	callHandlers(IRQ_WDT)
}

//export __vector_TIMER1_CAPT
//go:interrupt
func interruptTIMER1_CAPT() {
	callHandlers(IRQ_TIMER1_CAPT)
}

//export __vector_TIM1_CAPT
//go:interrupt
func interruptTIM1_CAPT() {
	callHandlers(IRQ_TIM1_CAPT)
}

//export __vector_TIMER1_COMPA
//go:interrupt
func interruptTIMER1_COMPA() {
	callHandlers(IRQ_TIMER1_COMPA)
}

//export __vector_TIM1_COMPA
//go:interrupt
func interruptTIM1_COMPA() {
	callHandlers(IRQ_TIM1_COMPA)
}

//export __vector_TIMER1_COMPB
//go:interrupt
func interruptTIMER1_COMPB() {
	callHandlers(IRQ_TIMER1_COMPB)
}

//export __vector_TIM1_COMPB
//go:interrupt
func interruptTIM1_COMPB() {
	callHandlers(IRQ_TIM1_COMPB)
}

//export __vector_TIMER1_OVF
//go:interrupt
func interruptTIMER1_OVF() {
	callHandlers(IRQ_TIMER1_OVF)
}

//export __vector_TIM1_OVF
//go:interrupt
func interruptTIM1_OVF() {
	callHandlers(IRQ_TIM1_OVF)
}

//export __vector_TIMER0_COMPA
//go:interrupt
func interruptTIMER0_COMPA() {
	callHandlers(IRQ_TIMER0_COMPA)
}

//export __vector_TIM0_COMPA
//go:interrupt
func interruptTIM0_COMPA() {
	callHandlers(IRQ_TIM0_COMPA)
}

//export __vector_TIMER0_COMPB
//go:interrupt
func interruptTIMER0_COMPB() {
	callHandlers(IRQ_TIMER0_COMPB)
}

//export __vector_TIM0_COMPB
//go:interrupt
func interruptTIM0_COMPB() {
	callHandlers(IRQ_TIM0_COMPB)
}

//export __vector_TIMER0_OVF
//go:interrupt
func interruptTIMER0_OVF() {
	callHandlers(IRQ_TIMER0_OVF)
}

//export __vector_TIM0_OVF
//go:interrupt
func interruptTIM0_OVF() {
	callHandlers(IRQ_TIM0_OVF)
}

//export __vector_ANA_COMP
//go:interrupt
func interruptANA_COMP() {
	callHandlers(IRQ_ANA_COMP)
}

//export __vector_ADC
//go:interrupt
func interruptADC() {
	callHandlers(IRQ_ADC)
}

//export __vector_ADC_READY
//go:interrupt
func interruptADC_READY() {
	callHandlers(IRQ_ADC_READY)
}

//export __vector_USART0_START
//go:interrupt
func interruptUSART0_START() {
	callHandlers(IRQ_USART0_START)
}

//export __vector_USART0_RXS
//go:interrupt
func interruptUSART0_RXS() {
	callHandlers(IRQ_USART0_RXS)
}

//export __vector_USART0_RX
//go:interrupt
func interruptUSART0_RX() {
	callHandlers(IRQ_USART0_RX)
}

//export __vector_USART0_RXC
//go:interrupt
func interruptUSART0_RXC() {
	callHandlers(IRQ_USART0_RXC)
}

//export __vector_USART0_UDRE
//go:interrupt
func interruptUSART0_UDRE() {
	callHandlers(IRQ_USART0_UDRE)
}

//export __vector_USART0_DRE
//go:interrupt
func interruptUSART0_DRE() {
	callHandlers(IRQ_USART0_DRE)
}

//export __vector_USART0_TX
//go:interrupt
func interruptUSART0_TX() {
	callHandlers(IRQ_USART0_TX)
}

//export __vector_USART0_TXC
//go:interrupt
func interruptUSART0_TXC() {
	callHandlers(IRQ_USART0_TXC)
}

//export __vector_USART1_START
//go:interrupt
func interruptUSART1_START() {
	callHandlers(IRQ_USART1_START)
}

//export __vector_USART1_RXS
//go:interrupt
func interruptUSART1_RXS() {
	callHandlers(IRQ_USART1_RXS)
}

//export __vector_USART1_RX
//go:interrupt
func interruptUSART1_RX() {
	callHandlers(IRQ_USART1_RX)
}

//export __vector_USART1_RXC
//go:interrupt
func interruptUSART1_RXC() {
	callHandlers(IRQ_USART1_RXC)
}

//export __vector_USART1_UDRE
//go:interrupt
func interruptUSART1_UDRE() {
	callHandlers(IRQ_USART1_UDRE)
}

//export __vector_USART1_DRE
//go:interrupt
func interruptUSART1_DRE() {
	callHandlers(IRQ_USART1_DRE)
}

//export __vector_USART1_TX
//go:interrupt
func interruptUSART1_TX() {
	callHandlers(IRQ_USART1_TX)
}

//export __vector_USART1_TXC
//go:interrupt
func interruptUSART1_TXC() {
	callHandlers(IRQ_USART1_TXC)
}

//export __vector_USI_START
//go:interrupt
func interruptUSI_START() {
	callHandlers(IRQ_USI_START)
}

//export __vector_USI_STR
//go:interrupt
func interruptUSI_STR() {
	callHandlers(IRQ_USI_STR)
}

//export __vector_USI_OVERFLOW
//go:interrupt
func interruptUSI_OVERFLOW() {
	callHandlers(IRQ_USI_OVERFLOW)
}

//export __vector_USI_OVF
//go:interrupt
func interruptUSI_OVF() {
	callHandlers(IRQ_USI_OVF)
}

//export __vector_TWI_SLAVE
//go:interrupt
func interruptTWI_SLAVE() {
	callHandlers(IRQ_TWI_SLAVE)
}

//export __vector_TWI
//go:interrupt
func interruptTWI() {
	callHandlers(IRQ_TWI)
}

//export __vector_EE_RDY
//go:interrupt
func interruptEE_RDY() {
	callHandlers(IRQ_EE_RDY)
}

//export __vector_QTRIP
//go:interrupt
func interruptQTRIP() {
	callHandlers(IRQ_QTRIP)
}

// Peripherals.
var (
	// Fuses
	EXTENDED = (*volatile.Register8)(unsafe.Pointer(uintptr(0x2)))
	HIGH     = (*volatile.Register8)(unsafe.Pointer(uintptr(0x1)))
	LOW      = (*volatile.Register8)(unsafe.Pointer(uintptr(0x0)))

	// Lockbits
	LOCKBIT = (*volatile.Register8)(unsafe.Pointer(uintptr(0x0)))

	// Two Wire Serial Interface
	TWSCRA = (*volatile.Register8)(unsafe.Pointer(uintptr(0x7f)))
	TWSCRB = (*volatile.Register8)(unsafe.Pointer(uintptr(0x7e)))
	TWSSRA = (*volatile.Register8)(unsafe.Pointer(uintptr(0x7d)))
	TWSA   = (*volatile.Register8)(unsafe.Pointer(uintptr(0x7c)))
	TWSD   = (*volatile.Register8)(unsafe.Pointer(uintptr(0x7a)))
	TWSAM  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x7b)))

	// I/O Port
	PUEB  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x2e)))
	DDRB  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x2c)))
	PINB  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x2b)))
	PORTB = (*volatile.Register8)(unsafe.Pointer(uintptr(0x2d)))
	PUEC  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x2a)))
	PORTC = (*volatile.Register8)(unsafe.Pointer(uintptr(0x29)))
	DDRC  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x28)))
	PINC  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x27)))
	PUEA  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x32)))
	PORTA = (*volatile.Register8)(unsafe.Pointer(uintptr(0x31)))
	DDRA  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x30)))
	PINA  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x2f)))

	// Analog-to-Digital Converter
	ADMUX  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x24)))
	ADCSRA = (*volatile.Register8)(unsafe.Pointer(uintptr(0x23)))
	ADCL   = (*volatile.Register8)(unsafe.Pointer(uintptr(0x20)))
	ADCH   = (*volatile.Register8)(unsafe.Pointer(uintptr(0x21)))
	ADCSRB = (*volatile.Register8)(unsafe.Pointer(uintptr(0x22)))
	DIDR2  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x62)))
	DIDR1  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x61)))
	DIDR0  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x60)))

	// Analog Comparator
	ACSRB = (*volatile.Register8)(unsafe.Pointer(uintptr(0x25)))
	ACSRA = (*volatile.Register8)(unsafe.Pointer(uintptr(0x26)))

	// EEPROM
	EEARL = (*volatile.Register8)(unsafe.Pointer(uintptr(0x3e)))
	EEARH = (*volatile.Register8)(unsafe.Pointer(uintptr(0x3f)))
	EEDR  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x3d)))
	EECR  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x3c)))

	// Timer/Counter, 16-bit
	TCCR1A = (*volatile.Register8)(unsafe.Pointer(uintptr(0x72)))
	TCCR1B = (*volatile.Register8)(unsafe.Pointer(uintptr(0x71)))
	TCCR1C = (*volatile.Register8)(unsafe.Pointer(uintptr(0x70)))
	TCNT1L = (*volatile.Register8)(unsafe.Pointer(uintptr(0x6e)))
	TCNT1H = (*volatile.Register8)(unsafe.Pointer(uintptr(0x6f)))
	OCR1AL = (*volatile.Register8)(unsafe.Pointer(uintptr(0x6c)))
	OCR1AH = (*volatile.Register8)(unsafe.Pointer(uintptr(0x6d)))
	OCR1BL = (*volatile.Register8)(unsafe.Pointer(uintptr(0x6a)))
	OCR1BH = (*volatile.Register8)(unsafe.Pointer(uintptr(0x6b)))
	ICR1L  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x68)))
	ICR1H  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x69)))

	// Timer/Counter, 8-bit
	OCR0B  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x37)))
	OCR0A  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x38)))
	TCCR0A = (*volatile.Register8)(unsafe.Pointer(uintptr(0x3b)))
	TCNT0  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x39)))
	TCCR0B = (*volatile.Register8)(unsafe.Pointer(uintptr(0x3a)))

	// External Interrupts
	PCMSK2 = (*volatile.Register8)(unsafe.Pointer(uintptr(0x49)))
	PCMSK1 = (*volatile.Register8)(unsafe.Pointer(uintptr(0x48)))
	PCMSK0 = (*volatile.Register8)(unsafe.Pointer(uintptr(0x47)))
	GIFR   = (*volatile.Register8)(unsafe.Pointer(uintptr(0x5b)))
	GIMSK  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x5c)))

	// CPU Registers
	PRR       = (*volatile.Register8)(unsafe.Pointer(uintptr(0x54)))
	CCP       = (*volatile.Register8)(unsafe.Pointer(uintptr(0x4f)))
	OSCCAL0   = (*volatile.Register8)(unsafe.Pointer(uintptr(0x63)))
	OSCCAL1   = (*volatile.Register8)(unsafe.Pointer(uintptr(0x66)))
	OSCTCAL0A = (*volatile.Register8)(unsafe.Pointer(uintptr(0x64)))
	OSCTCAL0B = (*volatile.Register8)(unsafe.Pointer(uintptr(0x65)))
	CLKPR     = (*volatile.Register8)(unsafe.Pointer(uintptr(0x53)))
	CLKSR     = (*volatile.Register8)(unsafe.Pointer(uintptr(0x52)))
	SREG      = (*volatile.Register8)(unsafe.Pointer(uintptr(0x5f)))
	SPL       = (*volatile.Register8)(unsafe.Pointer(uintptr(0x5d)))
	SPH       = (*volatile.Register8)(unsafe.Pointer(uintptr(0x5e)))
	MCUCR     = (*volatile.Register8)(unsafe.Pointer(uintptr(0x56)))
	MCUSR     = (*volatile.Register8)(unsafe.Pointer(uintptr(0x55)))
	GPIOR2    = (*volatile.Register8)(unsafe.Pointer(uintptr(0x36)))
	GPIOR1    = (*volatile.Register8)(unsafe.Pointer(uintptr(0x35)))
	GPIOR0    = (*volatile.Register8)(unsafe.Pointer(uintptr(0x34)))
	SPMCSR    = (*volatile.Register8)(unsafe.Pointer(uintptr(0x57)))

	// Universal Serial Interface
	USIBR = (*volatile.Register8)(unsafe.Pointer(uintptr(0x4d)))
	USIDR = (*volatile.Register8)(unsafe.Pointer(uintptr(0x4c)))
	USISR = (*volatile.Register8)(unsafe.Pointer(uintptr(0x4b)))
	USICR = (*volatile.Register8)(unsafe.Pointer(uintptr(0x4a)))

	// USART
	UDR0   = (*volatile.Register8)(unsafe.Pointer(uintptr(0x40)))
	UCSR0A = (*volatile.Register8)(unsafe.Pointer(uintptr(0x46)))
	UCSR0B = (*volatile.Register8)(unsafe.Pointer(uintptr(0x45)))
	UCSR0C = (*volatile.Register8)(unsafe.Pointer(uintptr(0x44)))
	UCSR0D = (*volatile.Register8)(unsafe.Pointer(uintptr(0x43)))
	UBRR0L = (*volatile.Register8)(unsafe.Pointer(uintptr(0x41)))
	UBRR0H = (*volatile.Register8)(unsafe.Pointer(uintptr(0x42)))
	UDR1   = (*volatile.Register8)(unsafe.Pointer(uintptr(0x73)))
	UCSR1A = (*volatile.Register8)(unsafe.Pointer(uintptr(0x79)))
	UCSR1B = (*volatile.Register8)(unsafe.Pointer(uintptr(0x78)))
	UCSR1C = (*volatile.Register8)(unsafe.Pointer(uintptr(0x77)))
	UCSR1D = (*volatile.Register8)(unsafe.Pointer(uintptr(0x76)))
	UBRR1L = (*volatile.Register8)(unsafe.Pointer(uintptr(0x74)))
	UBRR1H = (*volatile.Register8)(unsafe.Pointer(uintptr(0x75)))

	// Watchdog Timer
	WDTCSR = (*volatile.Register8)(unsafe.Pointer(uintptr(0x50)))
)

// Bitfields for FUSE: Fuses
const (
	// EXTENDED
	EXTENDED_BODPD0    = 0x8  // BOD mode of operation when the device is in sleep mode
	EXTENDED_BODPD1    = 0x10 // BOD mode of operation when the device is in sleep mode
	EXTENDED_BODACT0   = 0x2  // BOD mode of operation when the device is active or idle
	EXTENDED_BODACT1   = 0x4  // BOD mode of operation when the device is active or idle
	EXTENDED_SELFPRGEN = 0x1  // Self Programming enable

	// HIGH
	HIGH_RSTDISBL  = 0x80 // Reset Disabled (Enable PC2 as i/o pin)
	HIGH_DWEN      = 0x40 // Debug Wire enable
	HIGH_SPIEN     = 0x20 // Serial program downloading (SPI) enabled
	HIGH_WDTON     = 0x10 // Watch-dog Timer always on
	HIGH_EESAVE    = 0x8  // Preserve EEPROM through the Chip Erase cycle
	HIGH_BODLEVEL0 = 0x1  // Brown-out Detector trigger level
	HIGH_BODLEVEL1 = 0x2  // Brown-out Detector trigger level
	HIGH_BODLEVEL2 = 0x4  // Brown-out Detector trigger level

	// LOW
	LOW_CKDIV8     = 0x80 // Divide clock by 8 internally
	LOW_CKOUT      = 0x40 // Clock output on PORTC2
	LOW_SUT_CKSEL0 = 0x1  // Select Clock Source
	LOW_SUT_CKSEL1 = 0x2  // Select Clock Source
	LOW_SUT_CKSEL2 = 0x4  // Select Clock Source
	LOW_SUT_CKSEL3 = 0x8  // Select Clock Source
	LOW_SUT_CKSEL4 = 0x10 // Select Clock Source
)

// Bitfields for LOCKBIT: Lockbits
const (
	// LOCKBIT
	LOCKBIT_LB0 = 0x1 // Memory Lock
	LOCKBIT_LB1 = 0x2 // Memory Lock
)

// Bitfields for TWI: Two Wire Serial Interface
const (
	// TWSCRA: TWI Slave Control Register A
	TWSCRA_TWSHE  = 0x80 // TWI SDA Hold Time Enable
	TWSCRA_TWDIE  = 0x20 // TWI Data Interrupt Enable
	TWSCRA_TWASIE = 0x10 // TWI Address/Stop Interrupt Enable
	TWSCRA_TWEN   = 0x8  // Two-Wire Interface Enable
	TWSCRA_TWSIE  = 0x4  // TWI Stop Interrupt Enable
	TWSCRA_TWPME  = 0x2  // TWI Promiscuous Mode Enable
	TWSCRA_TWSME  = 0x1  // TWI Smart Mode Enable

	// TWSCRB: TWI Slave Control Register B
	TWSCRB_TWAA   = 0x4 // TWI Acknowledge Action
	TWSCRB_TWCMD0 = 0x1
	TWSCRB_TWCMD1 = 0x2

	// TWSSRA: TWI Slave Status Register A
	TWSSRA_TWDIF  = 0x80 // TWI Data Interrupt Flag
	TWSSRA_TWASIF = 0x40 // TWI Address/Stop Interrupt Flag
	TWSSRA_TWCH   = 0x20 // TWI Clock Hold
	TWSSRA_TWRA   = 0x10 // TWI Receive Acknowledge
	TWSSRA_TWC    = 0x8  // TWI Collision
	TWSSRA_TWBE   = 0x4  // TWI Bus Error
	TWSSRA_TWDIR  = 0x2  // TWI Read/Write Direction
	TWSSRA_TWAS   = 0x1  // TWI Address or Stop

	// TWSA: TWI Slave Address Register
	TWSA_TWSA0 = 0x1  // TWI slave address bit
	TWSA_TWSA1 = 0x2  // TWI slave address bit
	TWSA_TWSA2 = 0x4  // TWI slave address bit
	TWSA_TWSA3 = 0x8  // TWI slave address bit
	TWSA_TWSA4 = 0x10 // TWI slave address bit
	TWSA_TWSA5 = 0x20 // TWI slave address bit
	TWSA_TWSA6 = 0x40 // TWI slave address bit
	TWSA_TWSA7 = 0x80 // TWI slave address bit

	// TWSD: TWI Slave Data Register
	TWSD_TWSD0 = 0x1  // TWI slave data bit
	TWSD_TWSD1 = 0x2  // TWI slave data bit
	TWSD_TWSD2 = 0x4  // TWI slave data bit
	TWSD_TWSD3 = 0x8  // TWI slave data bit
	TWSD_TWSD4 = 0x10 // TWI slave data bit
	TWSD_TWSD5 = 0x20 // TWI slave data bit
	TWSD_TWSD6 = 0x40 // TWI slave data bit
	TWSD_TWSD7 = 0x80 // TWI slave data bit
)

// Bitfields for PORT: I/O Port
const (
	// PUEB: Pull-up Enable Control Register
	PUEB_PUEB0 = 0x1 // Pull-up Enable Control bit
	PUEB_PUEB1 = 0x2 // Pull-up Enable Control bit
	PUEB_PUEB2 = 0x4 // Pull-up Enable Control bit
	PUEB_PUEB3 = 0x8 // Pull-up Enable Control bit

	// PUEC: Pull-up Enable Control Register
	PUEC_PUEC0 = 0x1  // Pull-up Enable Control bit
	PUEC_PUEC1 = 0x2  // Pull-up Enable Control bit
	PUEC_PUEC2 = 0x4  // Pull-up Enable Control bit
	PUEC_PUEC3 = 0x8  // Pull-up Enable Control bit
	PUEC_PUEC4 = 0x10 // Pull-up Enable Control bit
	PUEC_PUEC5 = 0x20 // Pull-up Enable Control bit

	// PUEA: Pull-up Enable Control Register
	PUEA_PUEA0 = 0x1  // Pull-up Enable Control bit
	PUEA_PUEA1 = 0x2  // Pull-up Enable Control bit
	PUEA_PUEA2 = 0x4  // Pull-up Enable Control bit
	PUEA_PUEA3 = 0x8  // Pull-up Enable Control bit
	PUEA_PUEA4 = 0x10 // Pull-up Enable Control bit
	PUEA_PUEA5 = 0x20 // Pull-up Enable Control bit
	PUEA_PUEA6 = 0x40 // Pull-up Enable Control bit
	PUEA_PUEA7 = 0x80 // Pull-up Enable Control bit
)

// Bitfields for ADC: Analog-to-Digital Converter
const (
	// ADMUX: The ADC multiplexer Selection Register
	ADMUX_REFS0  = 0x40 // Reference Selection Bit
	ADMUX_REFS1  = 0x80 // Reference Selection Bit
	ADMUX_REFEN  = 0x20
	ADMUX_ADC0EN = 0x10
	ADMUX_MUX0   = 0x1 // Analog Channel and Gain Selection Bits
	ADMUX_MUX1   = 0x2 // Analog Channel and Gain Selection Bits
	ADMUX_MUX2   = 0x4 // Analog Channel and Gain Selection Bits
	ADMUX_MUX3   = 0x8 // Analog Channel and Gain Selection Bits

	// ADCSRA: The ADC Control and Status register
	ADCSRA_ADEN  = 0x80 // ADC Enable
	ADCSRA_ADSC  = 0x40 // ADC Start Conversion
	ADCSRA_ADATE = 0x20 // ADC Auto Trigger Enable
	ADCSRA_ADIF  = 0x10 // ADC Interrupt Flag
	ADCSRA_ADIE  = 0x8  // ADC Interrupt Enable
	ADCSRA_ADPS0 = 0x1  // ADC Prescaler Select Bits
	ADCSRA_ADPS1 = 0x2  // ADC Prescaler Select Bits
	ADCSRA_ADPS2 = 0x4  // ADC Prescaler Select Bits

	// ADCSRB: ADC Control and Status Register B
	ADCSRB_VDEN  = 0x80
	ADCSRB_VDPD  = 0x40
	ADCSRB_ADLAR = 0x8
	ADCSRB_ADTS0 = 0x1 // ADC Auto Trigger Sources
	ADCSRB_ADTS1 = 0x2 // ADC Auto Trigger Sources
	ADCSRB_ADTS2 = 0x4 // ADC Auto Trigger Sources

	// DIDR2: Digital Input Disable Register 2
	DIDR2_ADC11D = 0x4 // ADC11 Digital input Disable
	DIDR2_ADC10D = 0x2 // ADC10 Digital input Disable
	DIDR2_ADC9D  = 0x1 // ADC9 Digital input Disable

	// DIDR1: Digital Input Disable Register 1
	DIDR1_ADC8D = 0x8 // ADC8 Digital Input Disable
	DIDR1_ADC7D = 0x4 // ADC7 Digital input Disable
	DIDR1_ADC6D = 0x2 // ADC6 Digital input Disable
	DIDR1_ADC5D = 0x1 // ADC5 Digital input Disable

	// DIDR0: Digital Input Disable Register 0
	DIDR0_ADC4D = 0x80 // ADC4 Digital input Disable
	DIDR0_ADC3D = 0x40 // ADC3 Digital input Disable
	DIDR0_ADC2D = 0x20 // ADC2 Digital input Disable
	DIDR0_ADC1D = 0x10 // ADC1 Digital input Disable
	DIDR0_ADC0D = 0x8  // ADC0 Digital Input Disable
	DIDR0_AIN1D = 0x4  // AIN1 Digital input Disable
	DIDR0_AIN0D = 0x2  // AIN0 Digital input Disable
	DIDR0_AREFD = 0x1  // AREF Digital input Disable
)

// Bitfields for AC: Analog Comparator
const (
	// ACSRB: Analog Comparator Control And Status Register B
	ACSRB_HSEL   = 0x80 // Hysteresis Select
	ACSRB_HLEV   = 0x40 // Hysteresis Level
	ACSRB_ACLP   = 0x20
	ACSRB_ACCE   = 0x8
	ACSRB_ACME   = 0x4 // Analog Comparator Multiplexer Enable
	ACSRB_ACIRS0 = 0x1
	ACSRB_ACIRS1 = 0x2

	// ACSRA: Analog Comparator Control And Status Register A
	ACSRA_ACD   = 0x80 // Analog Comparator Disable
	ACSRA_ACBG  = 0x40 // Analog Comparator Bandgap Select
	ACSRA_ACO   = 0x20 // Analog Compare Output
	ACSRA_ACI   = 0x10 // Analog Comparator Interrupt Flag
	ACSRA_ACIE  = 0x8  // Analog Comparator Interrupt Enable
	ACSRA_ACIC  = 0x4  // Analog Comparator Input Capture Enable
	ACSRA_ACIS0 = 0x1  // Analog Comparator Interrupt Mode Select bits
	ACSRA_ACIS1 = 0x2  // Analog Comparator Interrupt Mode Select bits
)

// Bitfields for EEPROM: EEPROM
const (
	// EECR: EEPROM Control Register
	EECR_EEPM0 = 0x10 // EEPROM Programming Mode Bits
	EECR_EEPM1 = 0x20 // EEPROM Programming Mode Bits
	EECR_EERIE = 0x8  // EEProm Ready Interrupt Enable
	EECR_EEMPE = 0x4  // EEPROM Master Write Enable
	EECR_EEPE  = 0x2  // EEPROM Write Enable
	EECR_EERE  = 0x1  // EEPROM Read Enable
)

// Bitfields for TC16: Timer/Counter, 16-bit
const (
	// TCCR1A: Timer/Counter1 Control Register A
	TCCR1A_COM1A0 = 0x40 // Compare Output Mode 1A, bits
	TCCR1A_COM1A1 = 0x80 // Compare Output Mode 1A, bits
	TCCR1A_COM1B0 = 0x10 // Compare Output Mode 1B, bits
	TCCR1A_COM1B1 = 0x20 // Compare Output Mode 1B, bits
	TCCR1A_WGM10  = 0x1  // Pulse Width Modulator Select Bits
	TCCR1A_WGM11  = 0x2  // Pulse Width Modulator Select Bits

	// TCCR1B: Timer/Counter1 Control Register B
	TCCR1B_ICNC1 = 0x80 // Input Capture 1 Noise Canceler
	TCCR1B_ICES1 = 0x40 // Input Capture 1 Edge Select
	TCCR1B_WGM10 = 0x8  // Waveform Generation Mode Bits
	TCCR1B_WGM11 = 0x10 // Waveform Generation Mode Bits
	TCCR1B_CS10  = 0x1  // Clock Select1 bits
	TCCR1B_CS11  = 0x2  // Clock Select1 bits
	TCCR1B_CS12  = 0x4  // Clock Select1 bits

	// TCCR1C: Timer/Counter1 Control Register C
	TCCR1C_FOC1A = 0x80 // Force Output Compare for Channel A
	TCCR1C_FOC1B = 0x40 // Force Output Compare for Channel B
)

// Bitfields for TC8: Timer/Counter, 8-bit
const (
	// TCCR0A: Timer/Counter  Control Register A
	TCCR0A_COM0A0 = 0x40 // Compare Match Output A Mode
	TCCR0A_COM0A1 = 0x80 // Compare Match Output A Mode
	TCCR0A_COM0B0 = 0x10 // Compare Match Output B Mode
	TCCR0A_COM0B1 = 0x20 // Compare Match Output B Mode
	TCCR0A_WGM00  = 0x1  // Waveform Generation Mode
	TCCR0A_WGM01  = 0x2  // Waveform Generation Mode

	// TCCR0B: Timer/Counter Control Register B
	TCCR0B_FOC0A = 0x80 // Force Output Compare B
	TCCR0B_FOC0B = 0x40 // Force Output Compare B
	TCCR0B_WGM02 = 0x8
	TCCR0B_CS00  = 0x1 // Clock Select
	TCCR0B_CS01  = 0x2 // Clock Select
	TCCR0B_CS02  = 0x4 // Clock Select
)

// Bitfields for EXINT: External Interrupts
const (
	// PCMSK2: Pin Change Mask Register 2
	PCMSK2_PCINT0 = 0x1  // Pin Change Enable Masks
	PCMSK2_PCINT1 = 0x2  // Pin Change Enable Masks
	PCMSK2_PCINT2 = 0x4  // Pin Change Enable Masks
	PCMSK2_PCINT3 = 0x8  // Pin Change Enable Masks
	PCMSK2_PCINT4 = 0x10 // Pin Change Enable Masks
	PCMSK2_PCINT5 = 0x20 // Pin Change Enable Masks

	// PCMSK1: Pin Change Mask Register 1
	PCMSK1_PCINT0 = 0x1 // Pin Change Enable Masks
	PCMSK1_PCINT1 = 0x2 // Pin Change Enable Masks
	PCMSK1_PCINT2 = 0x4 // Pin Change Enable Masks
	PCMSK1_PCINT3 = 0x8 // Pin Change Enable Masks

	// PCMSK0: Pin Change Mask Register 0
	PCMSK0_PCINT0 = 0x1  // Pin Change Enable Masks
	PCMSK0_PCINT1 = 0x2  // Pin Change Enable Masks
	PCMSK0_PCINT2 = 0x4  // Pin Change Enable Masks
	PCMSK0_PCINT3 = 0x8  // Pin Change Enable Masks
	PCMSK0_PCINT4 = 0x10 // Pin Change Enable Masks
	PCMSK0_PCINT5 = 0x20 // Pin Change Enable Masks
	PCMSK0_PCINT6 = 0x40 // Pin Change Enable Masks
	PCMSK0_PCINT7 = 0x80 // Pin Change Enable Masks

	// GIFR: General Interrupt Flag Register
	GIFR_INTF0 = 0x40 // External Interrupt Flag 0
	GIFR_PCIF0 = 0x8  // Pin Change Interrupt Flags
	GIFR_PCIF1 = 0x10 // Pin Change Interrupt Flags
	GIFR_PCIF2 = 0x20 // Pin Change Interrupt Flags

	// GIMSK: General Interrupt Mask Register
	GIMSK_INT0  = 0x40 // External Interrupt Request 0 Enable
	GIMSK_PCIE0 = 0x8  // Pin Change Interrupt Enables
	GIMSK_PCIE1 = 0x10 // Pin Change Interrupt Enables
	GIMSK_PCIE2 = 0x20 // Pin Change Interrupt Enables
)

// Bitfields for CPU: CPU Registers
const (
	// PRR: Power Reduction Register
	PRR_PRTWI    = 0x40 // Power Reduction TWI
	PRR_PRTIM1   = 0x20 // Power Reduction Timer/Counter1
	PRR_PRTIM0   = 0x10 // Power Reduction Timer/Counter0
	PRR_PRUSI    = 0x8  // Power Reduction USI
	PRR_PRUSART1 = 0x4  // Power Reduction USART1
	PRR_PRUSART0 = 0x2  // Power Reduction USART0
	PRR_PRADC    = 0x1  // Power Reduction ADC

	// CLKPR: Clock Prescale Register
	CLKPR_CLKPS0 = 0x1 // Clock Prescaler Select Bits
	CLKPR_CLKPS1 = 0x2 // Clock Prescaler Select Bits
	CLKPR_CLKPS2 = 0x4 // Clock Prescaler Select Bits
	CLKPR_CLKPS3 = 0x8 // Clock Prescaler Select Bits

	// CLKSR: Clock Setting Register
	CLKSR_OSCRDY   = 0x80 // Oscillator Ready
	CLKSR_CSTR     = 0x40 // Clock Switch Trigger
	CLKSR_CKOUT_IO = 0x20 // Clock Output (active low)
	CLKSR_SUT      = 0x10 // Start-up Time
	CLKSR_CKSEL0   = 0x1  // Clock Select Bits
	CLKSR_CKSEL1   = 0x2  // Clock Select Bits
	CLKSR_CKSEL2   = 0x4  // Clock Select Bits
	CLKSR_CKSEL3   = 0x8  // Clock Select Bits

	// SREG: Status Register
	SREG_I = 0x80 // Global Interrupt Enable
	SREG_T = 0x40 // Bit Copy Storage
	SREG_H = 0x20 // Half Carry Flag
	SREG_S = 0x10 // Sign Bit
	SREG_V = 0x8  // Two's Complement Overflow Flag
	SREG_N = 0x4  // Negative Flag
	SREG_Z = 0x2  // Zero Flag
	SREG_C = 0x1  // Carry Flag

	// MCUCR: MCU Control Register
	MCUCR_SM0   = 0x20 // Sleep Mode Select Bits
	MCUCR_SM1   = 0x40 // Sleep Mode Select Bits
	MCUCR_SE    = 0x10 // Sleep Enable
	MCUCR_ISC00 = 0x1  // Interrupt Sense Control 0 bits
	MCUCR_ISC01 = 0x2  // Interrupt Sense Control 0 bits

	// MCUSR: MCU Status Register
	MCUSR_WDRF  = 0x8 // Watchdog Reset Flag
	MCUSR_BORF  = 0x4 // Brown-out Reset Flag
	MCUSR_EXTRF = 0x2 // External Reset Flag
	MCUSR_PORF  = 0x1 // Power-on reset flag

	// SPMCSR: Store Program Memory Control and Status Register
	SPMCSR_RSIG  = 0x20 // Read Device Signature Imprint Table
	SPMCSR_CTPB  = 0x10 // Clear Temporary Page Buffer
	SPMCSR_RFLB  = 0x8  // Read Fuse and Lock Bits
	SPMCSR_PGWRT = 0x4  // Page Write
	SPMCSR_PGERS = 0x2  // Page Erase
	SPMCSR_SPMEN = 0x1  // Store program Memory Enable
)

// Bitfields for USI: Universal Serial Interface
const (
	// USISR: USI Status Register
	USISR_USISIF  = 0x80 // Start Condition Interrupt Flag
	USISR_USIOIF  = 0x40 // Counter Overflow Interrupt Flag
	USISR_USIPF   = 0x20 // Stop Condition Flag
	USISR_USIDC   = 0x10 // Data Output Collision
	USISR_USICNT0 = 0x1  // USI Counter Value Bits
	USISR_USICNT1 = 0x2  // USI Counter Value Bits
	USISR_USICNT2 = 0x4  // USI Counter Value Bits
	USISR_USICNT3 = 0x8  // USI Counter Value Bits

	// USICR: USI Control Register
	USICR_USISIE = 0x80 // Start Condition Interrupt Enable
	USICR_USIOIE = 0x40 // Counter Overflow Interrupt Enable
	USICR_USIWM0 = 0x10 // USI Wire Mode Bits
	USICR_USIWM1 = 0x20 // USI Wire Mode Bits
	USICR_USICS0 = 0x4  // USI Clock Source Select Bits
	USICR_USICS1 = 0x8  // USI Clock Source Select Bits
	USICR_USICLK = 0x2  // Clock Strobe
	USICR_USITC  = 0x1  // Toggle Clock Port Pin
)

// Bitfields for USART: USART
const (
	// UCSR0A: USART Control and Status Register A
	UCSR0A_RXC0  = 0x80 // USART Receive Complete
	UCSR0A_TXC0  = 0x40 // USART Transmitt Complete
	UCSR0A_UDRE0 = 0x20 // USART Data Register Empty
	UCSR0A_FE0   = 0x10 // Framing Error
	UCSR0A_DOR0  = 0x8  // Data overRun
	UCSR0A_UPE0  = 0x4  // Parity Error
	UCSR0A_U2X0  = 0x2  // Double the USART transmission speed
	UCSR0A_MPCM0 = 0x1  // Multi-processor Communication Mode

	// UCSR0B: USART Control and Status Register B
	UCSR0B_RXCIE0 = 0x80 // RX Complete Interrupt Enable
	UCSR0B_TXCIE0 = 0x40 // TX Complete Interrupt Enable
	UCSR0B_UDRIE0 = 0x20 // USART Data register Empty Interrupt Enable
	UCSR0B_RXEN0  = 0x10 // Receiver Enable
	UCSR0B_TXEN0  = 0x8  // Transmitter Enable
	UCSR0B_UCSZ02 = 0x4  // Character Size
	UCSR0B_RXB80  = 0x2  // Receive Data Bit 8
	UCSR0B_TXB80  = 0x1  // Transmit Data Bit 8

	// UCSR0C: USART Control and Status Register C
	UCSR0C_UMSEL00 = 0x40 // USART Mode Select
	UCSR0C_UMSEL01 = 0x80 // USART Mode Select
	UCSR0C_UPM00   = 0x10 // Parity Mode Bits
	UCSR0C_UPM01   = 0x20 // Parity Mode Bits
	UCSR0C_USBS0   = 0x8  // Stop Bit Select
	UCSR0C_UCSZ00  = 0x2  // Character Size
	UCSR0C_UCSZ01  = 0x4  // Character Size
	UCSR0C_UCPOL0  = 0x1  // Clock Polarity

	// UCSR0D: USART Control and Status Register D
	UCSR0D_RXSIE0 = 0x80 // USART RX Start Interrupt Enable
	UCSR0D_RXS0   = 0x40 // USART RX Start Flag
	UCSR0D_SFDE0  = 0x20 // USART RX Start Frame Detection Enable

	// UCSR1A: USART Control and Status Register A
	UCSR1A_RXC1  = 0x80 // USART Receive Complete
	UCSR1A_TXC1  = 0x40 // USART Transmitt Complete
	UCSR1A_UDRE1 = 0x20 // USART Data Register Empty
	UCSR1A_FE1   = 0x10 // Framing Error
	UCSR1A_DOR1  = 0x8  // Data overRun
	UCSR1A_UPE1  = 0x4  // Parity Error
	UCSR1A_U2X1  = 0x2  // Double the USART transmission speed
	UCSR1A_MPCM1 = 0x1  // Multi-processor Communication Mode

	// UCSR1B: USART Control and Status Register B
	UCSR1B_RXCIE1 = 0x80 // RX Complete Interrupt Enable
	UCSR1B_TXCIE1 = 0x40 // TX Complete Interrupt Enable
	UCSR1B_UDRIE1 = 0x20 // USART Data register Empty Interrupt Enable
	UCSR1B_RXEN1  = 0x10 // Receiver Enable
	UCSR1B_TXEN1  = 0x8  // Transmitter Enable
	UCSR1B_UCSZ12 = 0x4  // Character Size
	UCSR1B_RXB81  = 0x2  // Receive Data Bit 8
	UCSR1B_TXB81  = 0x1  // Transmit Data Bit 8

	// UCSR1C: USART Control and Status Register C
	UCSR1C_UMSEL10 = 0x40 // USART Mode Select
	UCSR1C_UMSEL11 = 0x80 // USART Mode Select
	UCSR1C_UPM10   = 0x10 // Parity Mode Bits
	UCSR1C_UPM11   = 0x20 // Parity Mode Bits
	UCSR1C_USBS1   = 0x8  // Stop Bit Select
	UCSR1C_UCSZ10  = 0x2  // Character Size
	UCSR1C_UCSZ11  = 0x4  // Character Size
	UCSR1C_UCPOL1  = 0x1  // Clock Polarity

	// UCSR1D: USART Control and Status Register D
	UCSR1D_RXSIE1 = 0x80 // USART RX Start Interrupt Enable
	UCSR1D_RXS1   = 0x40 // USART RX Start Flag
	UCSR1D_SFDE1  = 0x20 // USART RX Start Frame Detection Enable
)

// Bitfields for WDT: Watchdog Timer
const (
	// WDTCSR: Watchdog Timer Control and Status Register
	WDTCSR_WDIF = 0x80 // Watchdog Timer Interrupt Flag
	WDTCSR_WDIE = 0x40 // Watchdog Timer Interrupt Enable
	WDTCSR_WDP0 = 0x1  // Watchdog Timer Prescaler Bits
	WDTCSR_WDP1 = 0x2  // Watchdog Timer Prescaler Bits
	WDTCSR_WDP2 = 0x4  // Watchdog Timer Prescaler Bits
	WDTCSR_WDP3 = 0x20 // Watchdog Timer Prescaler Bits
	WDTCSR_WDE  = 0x8  // Watch Dog Enable
)
