// Automatically generated file. DO NOT EDIT.
// Generated by gen-device-svd.go from nrf51.svd, see https://github.com/NordicSemiconductor/nrfx/tree/master/mdk

//go:build nrf && nrf51
// +build nrf,nrf51

// nRF51 reference description for radio MCU with ARM 32-bit Cortex-M0 Microcontroller at 16MHz CPU clock
//
//     Copyright (c) 2010 - 2020, Nordic Semiconductor ASA All rights reserved.
//
//     Redistribution and use in source and binary forms, with or without
//     modification, are permitted provided that the following conditions are met:
//
//     1. Redistributions of source code must retain the above copyright notice, this
//     list of conditions and the following disclaimer.
//
//     2. Redistributions in binary form must reproduce the above copyright
//     notice, this list of conditions and the following disclaimer in the
//     documentation and/or other materials provided with the distribution.
//
//     3. Neither the name of Nordic Semiconductor ASA nor the names of its
//     contributors may be used to endorse or promote products derived from this
//     software without specific prior written permission.
//
//     THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
//     AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
//     IMPLIED WARRANTIES OF MERCHANTABILITY, AND FITNESS FOR A PARTICULAR PURPOSE
//     ARE DISCLAIMED. IN NO EVENT SHALL NORDIC SEMICONDUCTOR ASA OR CONTRIBUTORS BE
//     LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
//     CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
//     SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
//     INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
//     CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
//     ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
//     POSSIBILITY OF SUCH DAMAGE.
package nrf

import (
	"runtime/volatile"
	"unsafe"
)

// Some information about this device.
const (
	Device       = "nrf51"
	CPU          = "CM0"
	FPUPresent   = false
	NVICPrioBits = 2
)

// Interrupt numbers.
const (
	// Power Control. // Clock control.
	IRQ_POWER_CLOCK = 0

	// Power Control.
	IRQ_POWER = 0

	// Clock control.
	IRQ_CLOCK = 0

	// The radio.
	IRQ_RADIO = 1

	// Universal Asynchronous Receiver/Transmitter.
	IRQ_UART0 = 2

	// SPI master 0. // Two-wire interface master 0.
	IRQ_SPI0_TWI0 = 3

	// SPI master 0.
	IRQ_SPI0 = 3

	// Two-wire interface master 0.
	IRQ_TWI0 = 3

	// SPI slave 1. // SPI master 1. // Two-wire interface master 1.
	IRQ_SPI1_TWI1 = 4

	// SPI slave 1.
	IRQ_SPIS1 = 4

	// SPI master 1.
	IRQ_SPI1 = 4

	// Two-wire interface master 1.
	IRQ_TWI1 = 4

	// GPIO tasks and events.
	IRQ_GPIOTE = 6

	// Analog to digital converter.
	IRQ_ADC = 7

	// Timer 0.
	IRQ_TIMER0 = 8

	// Timer 1.
	IRQ_TIMER1 = 9

	// Timer 2.
	IRQ_TIMER2 = 10

	// Real time counter 0.
	IRQ_RTC0 = 11

	// Temperature Sensor.
	IRQ_TEMP = 12

	// Random Number Generator.
	IRQ_RNG = 13

	// AES ECB Mode Encryption.
	IRQ_ECB = 14

	// Accelerated Address Resolver. // AES CCM Mode Encryption.
	IRQ_CCM_AAR = 15

	// Accelerated Address Resolver.
	IRQ_AAR = 15

	// AES CCM Mode Encryption.
	IRQ_CCM = 15

	// Watchdog Timer.
	IRQ_WDT = 16

	// Real time counter 1.
	IRQ_RTC1 = 17

	// Rotary decoder.
	IRQ_QDEC = 18

	// Low power comparator.
	IRQ_LPCOMP = 19

	// SW Interrupts.
	IRQ_SWI0 = 20

	// SW Interrupts.
	IRQ_SWI1 = 21

	// SW Interrupts.
	IRQ_SWI2 = 22

	// SW Interrupts.
	IRQ_SWI3 = 23

	// SW Interrupts.
	IRQ_SWI4 = 24

	// SW Interrupts.
	IRQ_SWI5 = 25

	// Highest interrupt number on this device.
	IRQ_max = 25
)

// Pseudo function call that is replaced by the compiler with the actual
// functions registered through interrupt.New.
//go:linkname callHandlers runtime/interrupt.callHandlers
func callHandlers(num int)

//export POWER_CLOCK_IRQHandler
func interruptPOWER_CLOCK() {
	callHandlers(IRQ_POWER_CLOCK)
}

//export RADIO_IRQHandler
func interruptRADIO() {
	callHandlers(IRQ_RADIO)
}

//export UART0_IRQHandler
func interruptUART0() {
	callHandlers(IRQ_UART0)
}

//export SPI0_TWI0_IRQHandler
func interruptSPI0_TWI0() {
	callHandlers(IRQ_SPI0_TWI0)
}

//export SPI1_TWI1_IRQHandler
func interruptSPI1_TWI1() {
	callHandlers(IRQ_SPI1_TWI1)
}

//export GPIOTE_IRQHandler
func interruptGPIOTE() {
	callHandlers(IRQ_GPIOTE)
}

//export ADC_IRQHandler
func interruptADC() {
	callHandlers(IRQ_ADC)
}

//export TIMER0_IRQHandler
func interruptTIMER0() {
	callHandlers(IRQ_TIMER0)
}

//export TIMER1_IRQHandler
func interruptTIMER1() {
	callHandlers(IRQ_TIMER1)
}

//export TIMER2_IRQHandler
func interruptTIMER2() {
	callHandlers(IRQ_TIMER2)
}

//export RTC0_IRQHandler
func interruptRTC0() {
	callHandlers(IRQ_RTC0)
}

//export TEMP_IRQHandler
func interruptTEMP() {
	callHandlers(IRQ_TEMP)
}

//export RNG_IRQHandler
func interruptRNG() {
	callHandlers(IRQ_RNG)
}

//export ECB_IRQHandler
func interruptECB() {
	callHandlers(IRQ_ECB)
}

//export CCM_AAR_IRQHandler
func interruptCCM_AAR() {
	callHandlers(IRQ_CCM_AAR)
}

//export WDT_IRQHandler
func interruptWDT() {
	callHandlers(IRQ_WDT)
}

//export RTC1_IRQHandler
func interruptRTC1() {
	callHandlers(IRQ_RTC1)
}

//export QDEC_IRQHandler
func interruptQDEC() {
	callHandlers(IRQ_QDEC)
}

//export LPCOMP_IRQHandler
func interruptLPCOMP() {
	callHandlers(IRQ_LPCOMP)
}

//export SWI0_IRQHandler
func interruptSWI0() {
	callHandlers(IRQ_SWI0)
}

//export SWI1_IRQHandler
func interruptSWI1() {
	callHandlers(IRQ_SWI1)
}

//export SWI2_IRQHandler
func interruptSWI2() {
	callHandlers(IRQ_SWI2)
}

//export SWI3_IRQHandler
func interruptSWI3() {
	callHandlers(IRQ_SWI3)
}

//export SWI4_IRQHandler
func interruptSWI4() {
	callHandlers(IRQ_SWI4)
}

//export SWI5_IRQHandler
func interruptSWI5() {
	callHandlers(IRQ_SWI5)
}

// Peripherals.
var (
	// Power Control.
	POWER = (*POWER_Type)(unsafe.Pointer(uintptr(0x40000000)))

	// Clock control.
	CLOCK = (*CLOCK_Type)(unsafe.Pointer(uintptr(0x40000000)))

	// Memory Protection Unit.
	MPU = (*MPU_Type)(unsafe.Pointer(uintptr(0x40000000)))

	// The radio.
	RADIO = (*RADIO_Type)(unsafe.Pointer(uintptr(0x40001000)))

	// Universal Asynchronous Receiver/Transmitter.
	UART0 = (*UART_Type)(unsafe.Pointer(uintptr(0x40002000)))

	// SPI master 0.
	SPI0 = (*SPI_Type)(unsafe.Pointer(uintptr(0x40003000)))

	// Two-wire interface master 0.
	TWI0 = (*TWI_Type)(unsafe.Pointer(uintptr(0x40003000)))

	// SPI slave 1.
	SPIS1 = (*SPIS_Type)(unsafe.Pointer(uintptr(0x40004000)))

	// GPIO tasks and events.
	GPIOTE = (*GPIOTE_Type)(unsafe.Pointer(uintptr(0x40006000)))

	// Analog to digital converter.
	ADC = (*ADC_Type)(unsafe.Pointer(uintptr(0x40007000)))

	// Timer 0.
	TIMER0 = (*TIMER_Type)(unsafe.Pointer(uintptr(0x40008000)))

	// Real time counter 0.
	RTC0 = (*RTC_Type)(unsafe.Pointer(uintptr(0x4000b000)))

	// Temperature Sensor.
	TEMP = (*TEMP_Type)(unsafe.Pointer(uintptr(0x4000c000)))

	// Random Number Generator.
	RNG = (*RNG_Type)(unsafe.Pointer(uintptr(0x4000d000)))

	// AES ECB Mode Encryption.
	ECB = (*ECB_Type)(unsafe.Pointer(uintptr(0x4000e000)))

	// Accelerated Address Resolver.
	AAR = (*AAR_Type)(unsafe.Pointer(uintptr(0x4000f000)))

	// AES CCM Mode Encryption.
	CCM = (*CCM_Type)(unsafe.Pointer(uintptr(0x4000f000)))

	// Watchdog Timer.
	WDT = (*WDT_Type)(unsafe.Pointer(uintptr(0x40010000)))

	// Rotary decoder.
	QDEC = (*QDEC_Type)(unsafe.Pointer(uintptr(0x40012000)))

	// Low power comparator.
	LPCOMP = (*LPCOMP_Type)(unsafe.Pointer(uintptr(0x40013000)))

	// SW Interrupts.
	SWI = (*SWI_Type)(unsafe.Pointer(uintptr(0x40014000)))

	// Non Volatile Memory Controller.
	NVMC = (*NVMC_Type)(unsafe.Pointer(uintptr(0x4001e000)))

	// PPI controller.
	PPI = (*PPI_Type)(unsafe.Pointer(uintptr(0x4001f000)))

	// Factory Information Configuration.
	FICR = (*FICR_Type)(unsafe.Pointer(uintptr(0x10000000)))

	// User Information Configuration.
	UICR = (*UICR_Type)(unsafe.Pointer(uintptr(0x10001000)))

	// General purpose input and output.
	GPIO = (*GPIO_Type)(unsafe.Pointer(uintptr(0x50000000)))

	// SPI master 1.
	SPI1 = (*SPI_Type)(unsafe.Pointer(uintptr(0x40004000)))

	// Two-wire interface master 1.
	TWI1 = (*TWI_Type)(unsafe.Pointer(uintptr(0x40004000)))

	// Timer 1.
	TIMER1 = (*TIMER_Type)(unsafe.Pointer(uintptr(0x40009000)))

	// Timer 2.
	TIMER2 = (*TIMER_Type)(unsafe.Pointer(uintptr(0x4000a000)))

	// Real time counter 1.
	RTC1 = (*RTC_Type)(unsafe.Pointer(uintptr(0x40011000)))
)

// Power Control.
type POWER_Type struct {
	_              [120]byte
	TASKS_CONSTLAT volatile.Register32 // 0x78
	TASKS_LOWPWR   volatile.Register32 // 0x7C
	_              [136]byte
	EVENTS_POFWARN volatile.Register32 // 0x108
	_              [504]byte
	INTENSET       volatile.Register32 // 0x304
	INTENCLR       volatile.Register32 // 0x308
	_              [244]byte
	RESETREAS      volatile.Register32 // 0x400
	_              [36]byte
	RAMSTATUS      volatile.Register32 // 0x428
	_              [212]byte
	SYSTEMOFF      volatile.Register32 // 0x500
	_              [12]byte
	POFCON         volatile.Register32 // 0x510
	_              [8]byte
	GPREGRET       volatile.Register32 // 0x51C
	_              [4]byte
	RAMON          volatile.Register32 // 0x524
	_              [28]byte
	RESET          volatile.Register32 // 0x544
	_              [12]byte
	RAMONB         volatile.Register32 // 0x554
	_              [32]byte
	DCDCEN         volatile.Register32 // 0x578
	_              [1164]byte
	DCDCFORCE      volatile.Register32 // 0xA08
}

// Clock control.
type CLOCK_Type struct {
	TASKS_HFCLKSTART    volatile.Register32 // 0x0
	TASKS_HFCLKSTOP     volatile.Register32 // 0x4
	TASKS_LFCLKSTART    volatile.Register32 // 0x8
	TASKS_LFCLKSTOP     volatile.Register32 // 0xC
	TASKS_CAL           volatile.Register32 // 0x10
	TASKS_CTSTART       volatile.Register32 // 0x14
	TASKS_CTSTOP        volatile.Register32 // 0x18
	_                   [228]byte
	EVENTS_HFCLKSTARTED volatile.Register32 // 0x100
	EVENTS_LFCLKSTARTED volatile.Register32 // 0x104
	_                   [4]byte
	EVENTS_DONE         volatile.Register32 // 0x10C
	EVENTS_CTTO         volatile.Register32 // 0x110
	_                   [496]byte
	INTENSET            volatile.Register32 // 0x304
	INTENCLR            volatile.Register32 // 0x308
	_                   [252]byte
	HFCLKRUN            volatile.Register32 // 0x408
	HFCLKSTAT           volatile.Register32 // 0x40C
	_                   [4]byte
	LFCLKRUN            volatile.Register32 // 0x414
	LFCLKSTAT           volatile.Register32 // 0x418
	LFCLKSRCCOPY        volatile.Register32 // 0x41C
	_                   [248]byte
	LFCLKSRC            volatile.Register32 // 0x518
	_                   [28]byte
	CTIV                volatile.Register32 // 0x538
	_                   [20]byte
	XTALFREQ            volatile.Register32 // 0x550
}

// Memory Protection Unit.
type MPU_Type struct {
	_              [1320]byte
	PERR0          volatile.Register32 // 0x528
	RLENR0         volatile.Register32 // 0x52C
	_              [208]byte
	PROTENSET0     volatile.Register32 // 0x600
	PROTENSET1     volatile.Register32 // 0x604
	DISABLEINDEBUG volatile.Register32 // 0x608
	PROTBLOCKSIZE  volatile.Register32 // 0x60C
}

// The radio.
type RADIO_Type struct {
	TASKS_TXEN      volatile.Register32 // 0x0
	TASKS_RXEN      volatile.Register32 // 0x4
	TASKS_START     volatile.Register32 // 0x8
	TASKS_STOP      volatile.Register32 // 0xC
	TASKS_DISABLE   volatile.Register32 // 0x10
	TASKS_RSSISTART volatile.Register32 // 0x14
	TASKS_RSSISTOP  volatile.Register32 // 0x18
	TASKS_BCSTART   volatile.Register32 // 0x1C
	TASKS_BCSTOP    volatile.Register32 // 0x20
	_               [220]byte
	EVENTS_READY    volatile.Register32 // 0x100
	EVENTS_ADDRESS  volatile.Register32 // 0x104
	EVENTS_PAYLOAD  volatile.Register32 // 0x108
	EVENTS_END      volatile.Register32 // 0x10C
	EVENTS_DISABLED volatile.Register32 // 0x110
	EVENTS_DEVMATCH volatile.Register32 // 0x114
	EVENTS_DEVMISS  volatile.Register32 // 0x118
	EVENTS_RSSIEND  volatile.Register32 // 0x11C
	_               [8]byte
	EVENTS_BCMATCH  volatile.Register32 // 0x128
	_               [212]byte
	SHORTS          volatile.Register32 // 0x200
	_               [256]byte
	INTENSET        volatile.Register32 // 0x304
	INTENCLR        volatile.Register32 // 0x308
	_               [244]byte
	CRCSTATUS       volatile.Register32 // 0x400
	_               [4]byte
	RXMATCH         volatile.Register32 // 0x408
	RXCRC           volatile.Register32 // 0x40C
	DAI             volatile.Register32 // 0x410
	_               [240]byte
	PACKETPTR       volatile.Register32 // 0x504
	FREQUENCY       volatile.Register32 // 0x508
	TXPOWER         volatile.Register32 // 0x50C
	MODE            volatile.Register32 // 0x510
	PCNF0           volatile.Register32 // 0x514
	PCNF1           volatile.Register32 // 0x518
	BASE0           volatile.Register32 // 0x51C
	BASE1           volatile.Register32 // 0x520
	PREFIX0         volatile.Register32 // 0x524
	PREFIX1         volatile.Register32 // 0x528
	TXADDRESS       volatile.Register32 // 0x52C
	RXADDRESSES     volatile.Register32 // 0x530
	CRCCNF          volatile.Register32 // 0x534
	CRCPOLY         volatile.Register32 // 0x538
	CRCINIT         volatile.Register32 // 0x53C
	TEST            volatile.Register32 // 0x540
	TIFS            volatile.Register32 // 0x544
	RSSISAMPLE      volatile.Register32 // 0x548
	_               [4]byte
	STATE           volatile.Register32 // 0x550
	DATAWHITEIV     volatile.Register32 // 0x554
	_               [8]byte
	BCC             volatile.Register32 // 0x560
	_               [156]byte
	DAB             [8]volatile.Register32 // 0x600
	DAP             [8]volatile.Register32 // 0x620
	DACNF           volatile.Register32    // 0x640
	_               [224]byte
	OVERRIDE0       volatile.Register32 // 0x724
	OVERRIDE1       volatile.Register32 // 0x728
	OVERRIDE2       volatile.Register32 // 0x72C
	OVERRIDE3       volatile.Register32 // 0x730
	OVERRIDE4       volatile.Register32 // 0x734
	_               [2244]byte
	POWER           volatile.Register32 // 0xFFC
}

// Universal Asynchronous Receiver/Transmitter.
type UART_Type struct {
	TASKS_STARTRX volatile.Register32 // 0x0
	TASKS_STOPRX  volatile.Register32 // 0x4
	TASKS_STARTTX volatile.Register32 // 0x8
	TASKS_STOPTX  volatile.Register32 // 0xC
	_             [12]byte
	TASKS_SUSPEND volatile.Register32 // 0x1C
	_             [224]byte
	EVENTS_CTS    volatile.Register32 // 0x100
	EVENTS_NCTS   volatile.Register32 // 0x104
	EVENTS_RXDRDY volatile.Register32 // 0x108
	_             [16]byte
	EVENTS_TXDRDY volatile.Register32 // 0x11C
	_             [4]byte
	EVENTS_ERROR  volatile.Register32 // 0x124
	_             [28]byte
	EVENTS_RXTO   volatile.Register32 // 0x144
	_             [184]byte
	SHORTS        volatile.Register32 // 0x200
	_             [256]byte
	INTENSET      volatile.Register32 // 0x304
	INTENCLR      volatile.Register32 // 0x308
	_             [372]byte
	ERRORSRC      volatile.Register32 // 0x480
	_             [124]byte
	ENABLE        volatile.Register32 // 0x500
	_             [4]byte
	PSELRTS       volatile.Register32 // 0x508
	PSELTXD       volatile.Register32 // 0x50C
	PSELCTS       volatile.Register32 // 0x510
	PSELRXD       volatile.Register32 // 0x514
	RXD           volatile.Register32 // 0x518
	TXD           volatile.Register32 // 0x51C
	_             [4]byte
	BAUDRATE      volatile.Register32 // 0x524
	_             [68]byte
	CONFIG        volatile.Register32 // 0x56C
	_             [2700]byte
	POWER         volatile.Register32 // 0xFFC
}

// SPI master 0.
type SPI_Type struct {
	_            [264]byte
	EVENTS_READY volatile.Register32 // 0x108
	_            [504]byte
	INTENSET     volatile.Register32 // 0x304
	INTENCLR     volatile.Register32 // 0x308
	_            [500]byte
	ENABLE       volatile.Register32 // 0x500
	_            [4]byte
	PSELSCK      volatile.Register32 // 0x508
	PSELMOSI     volatile.Register32 // 0x50C
	PSELMISO     volatile.Register32 // 0x510
	_            [4]byte
	RXD          volatile.Register32 // 0x518
	TXD          volatile.Register32 // 0x51C
	_            [4]byte
	FREQUENCY    volatile.Register32 // 0x524
	_            [44]byte
	CONFIG       volatile.Register32 // 0x554
	_            [2724]byte
	POWER        volatile.Register32 // 0xFFC
}

// Two-wire interface master 0.
type TWI_Type struct {
	TASKS_STARTRX    volatile.Register32 // 0x0
	_                [4]byte
	TASKS_STARTTX    volatile.Register32 // 0x8
	_                [8]byte
	TASKS_STOP       volatile.Register32 // 0x14
	_                [4]byte
	TASKS_SUSPEND    volatile.Register32 // 0x1C
	TASKS_RESUME     volatile.Register32 // 0x20
	_                [224]byte
	EVENTS_STOPPED   volatile.Register32 // 0x104
	EVENTS_RXDREADY  volatile.Register32 // 0x108
	_                [16]byte
	EVENTS_TXDSENT   volatile.Register32 // 0x11C
	_                [4]byte
	EVENTS_ERROR     volatile.Register32 // 0x124
	_                [16]byte
	EVENTS_BB        volatile.Register32 // 0x138
	_                [12]byte
	EVENTS_SUSPENDED volatile.Register32 // 0x148
	_                [180]byte
	SHORTS           volatile.Register32 // 0x200
	_                [256]byte
	INTENSET         volatile.Register32 // 0x304
	INTENCLR         volatile.Register32 // 0x308
	_                [440]byte
	ERRORSRC         volatile.Register32 // 0x4C4
	_                [56]byte
	ENABLE           volatile.Register32 // 0x500
	_                [4]byte
	PSELSCL          volatile.Register32 // 0x508
	PSELSDA          volatile.Register32 // 0x50C
	_                [8]byte
	RXD              volatile.Register32 // 0x518
	TXD              volatile.Register32 // 0x51C
	_                [4]byte
	FREQUENCY        volatile.Register32 // 0x524
	_                [96]byte
	ADDRESS          volatile.Register32 // 0x588
	_                [2672]byte
	POWER            volatile.Register32 // 0xFFC
}

// SPI slave 1.
type SPIS_Type struct {
	_               [36]byte
	TASKS_ACQUIRE   volatile.Register32 // 0x24
	TASKS_RELEASE   volatile.Register32 // 0x28
	_               [216]byte
	EVENTS_END      volatile.Register32 // 0x104
	_               [8]byte
	EVENTS_ENDRX    volatile.Register32 // 0x110
	_               [20]byte
	EVENTS_ACQUIRED volatile.Register32 // 0x128
	_               [212]byte
	SHORTS          volatile.Register32 // 0x200
	_               [256]byte
	INTENSET        volatile.Register32 // 0x304
	INTENCLR        volatile.Register32 // 0x308
	_               [244]byte
	SEMSTAT         volatile.Register32 // 0x400
	_               [60]byte
	STATUS          volatile.Register32 // 0x440
	_               [188]byte
	ENABLE          volatile.Register32 // 0x500
	_               [4]byte
	PSELSCK         volatile.Register32 // 0x508
	PSELMISO        volatile.Register32 // 0x50C
	PSELMOSI        volatile.Register32 // 0x510
	PSELCSN         volatile.Register32 // 0x514
	_               [28]byte
	RXDPTR          volatile.Register32 // 0x534
	MAXRX           volatile.Register32 // 0x538
	AMOUNTRX        volatile.Register32 // 0x53C
	_               [4]byte
	TXDPTR          volatile.Register32 // 0x544
	MAXTX           volatile.Register32 // 0x548
	AMOUNTTX        volatile.Register32 // 0x54C
	_               [4]byte
	CONFIG          volatile.Register32 // 0x554
	_               [4]byte
	DEF             volatile.Register32 // 0x55C
	_               [96]byte
	ORC             volatile.Register32 // 0x5C0
	_               [2616]byte
	POWER           volatile.Register32 // 0xFFC
}

// GPIO tasks and events.
type GPIOTE_Type struct {
	TASKS_OUT   [4]volatile.Register32 // 0x0
	_           [240]byte
	EVENTS_IN   [4]volatile.Register32 // 0x100
	_           [108]byte
	EVENTS_PORT volatile.Register32 // 0x17C
	_           [388]byte
	INTENSET    volatile.Register32 // 0x304
	INTENCLR    volatile.Register32 // 0x308
	_           [516]byte
	CONFIG      [4]volatile.Register32 // 0x510
	_           [2780]byte
	POWER       volatile.Register32 // 0xFFC
}

// Analog to digital converter.
type ADC_Type struct {
	TASKS_START volatile.Register32 // 0x0
	TASKS_STOP  volatile.Register32 // 0x4
	_           [248]byte
	EVENTS_END  volatile.Register32 // 0x100
	_           [512]byte
	INTENSET    volatile.Register32 // 0x304
	INTENCLR    volatile.Register32 // 0x308
	_           [244]byte
	BUSY        volatile.Register32 // 0x400
	_           [252]byte
	ENABLE      volatile.Register32 // 0x500
	CONFIG      volatile.Register32 // 0x504
	RESULT      volatile.Register32 // 0x508
	_           [2800]byte
	POWER       volatile.Register32 // 0xFFC
}

// Timer 0.
type TIMER_Type struct {
	TASKS_START    volatile.Register32 // 0x0
	TASKS_STOP     volatile.Register32 // 0x4
	TASKS_COUNT    volatile.Register32 // 0x8
	TASKS_CLEAR    volatile.Register32 // 0xC
	TASKS_SHUTDOWN volatile.Register32 // 0x10
	_              [44]byte
	TASKS_CAPTURE  [4]volatile.Register32 // 0x40
	_              [240]byte
	EVENTS_COMPARE [4]volatile.Register32 // 0x140
	_              [176]byte
	SHORTS         volatile.Register32 // 0x200
	_              [256]byte
	INTENSET       volatile.Register32 // 0x304
	INTENCLR       volatile.Register32 // 0x308
	_              [504]byte
	MODE           volatile.Register32 // 0x504
	BITMODE        volatile.Register32 // 0x508
	_              [4]byte
	PRESCALER      volatile.Register32 // 0x510
	_              [44]byte
	CC             [4]volatile.Register32 // 0x540
	_              [2732]byte
	POWER          volatile.Register32 // 0xFFC
}

// Real time counter 0.
type RTC_Type struct {
	TASKS_START      volatile.Register32 // 0x0
	TASKS_STOP       volatile.Register32 // 0x4
	TASKS_CLEAR      volatile.Register32 // 0x8
	TASKS_TRIGOVRFLW volatile.Register32 // 0xC
	_                [240]byte
	EVENTS_TICK      volatile.Register32 // 0x100
	EVENTS_OVRFLW    volatile.Register32 // 0x104
	_                [56]byte
	EVENTS_COMPARE   [4]volatile.Register32 // 0x140
	_                [436]byte
	INTENSET         volatile.Register32 // 0x304
	INTENCLR         volatile.Register32 // 0x308
	_                [52]byte
	EVTEN            volatile.Register32 // 0x340
	EVTENSET         volatile.Register32 // 0x344
	EVTENCLR         volatile.Register32 // 0x348
	_                [440]byte
	COUNTER          volatile.Register32 // 0x504
	PRESCALER        volatile.Register32 // 0x508
	_                [52]byte
	CC               [4]volatile.Register32 // 0x540
	_                [2732]byte
	POWER            volatile.Register32 // 0xFFC
}

// Temperature Sensor.
type TEMP_Type struct {
	TASKS_START    volatile.Register32 // 0x0
	TASKS_STOP     volatile.Register32 // 0x4
	_              [248]byte
	EVENTS_DATARDY volatile.Register32 // 0x100
	_              [512]byte
	INTENSET       volatile.Register32 // 0x304
	INTENCLR       volatile.Register32 // 0x308
	_              [508]byte
	TEMP           volatile.Register32 // 0x508
	_              [2800]byte
	POWER          volatile.Register32 // 0xFFC
}

// Random Number Generator.
type RNG_Type struct {
	TASKS_START   volatile.Register32 // 0x0
	TASKS_STOP    volatile.Register32 // 0x4
	_             [248]byte
	EVENTS_VALRDY volatile.Register32 // 0x100
	_             [252]byte
	SHORTS        volatile.Register32 // 0x200
	_             [256]byte
	INTENSET      volatile.Register32 // 0x304
	INTENCLR      volatile.Register32 // 0x308
	_             [504]byte
	CONFIG        volatile.Register32 // 0x504
	VALUE         volatile.Register32 // 0x508
	_             [2800]byte
	POWER         volatile.Register32 // 0xFFC
}

// AES ECB Mode Encryption.
type ECB_Type struct {
	TASKS_STARTECB  volatile.Register32 // 0x0
	TASKS_STOPECB   volatile.Register32 // 0x4
	_               [248]byte
	EVENTS_ENDECB   volatile.Register32 // 0x100
	EVENTS_ERRORECB volatile.Register32 // 0x104
	_               [508]byte
	INTENSET        volatile.Register32 // 0x304
	INTENCLR        volatile.Register32 // 0x308
	_               [504]byte
	ECBDATAPTR      volatile.Register32 // 0x504
	_               [2804]byte
	POWER           volatile.Register32 // 0xFFC
}

// Accelerated Address Resolver.
type AAR_Type struct {
	TASKS_START        volatile.Register32 // 0x0
	_                  [4]byte
	TASKS_STOP         volatile.Register32 // 0x8
	_                  [244]byte
	EVENTS_END         volatile.Register32 // 0x100
	EVENTS_RESOLVED    volatile.Register32 // 0x104
	EVENTS_NOTRESOLVED volatile.Register32 // 0x108
	_                  [504]byte
	INTENSET           volatile.Register32 // 0x304
	INTENCLR           volatile.Register32 // 0x308
	_                  [244]byte
	STATUS             volatile.Register32 // 0x400
	_                  [252]byte
	ENABLE             volatile.Register32 // 0x500
	NIRK               volatile.Register32 // 0x504
	IRKPTR             volatile.Register32 // 0x508
	_                  [4]byte
	ADDRPTR            volatile.Register32 // 0x510
	SCRATCHPTR         volatile.Register32 // 0x514
	_                  [2788]byte
	POWER              volatile.Register32 // 0xFFC
}

// AES CCM Mode Encryption.
type CCM_Type struct {
	TASKS_KSGEN     volatile.Register32 // 0x0
	TASKS_CRYPT     volatile.Register32 // 0x4
	TASKS_STOP      volatile.Register32 // 0x8
	_               [244]byte
	EVENTS_ENDKSGEN volatile.Register32 // 0x100
	EVENTS_ENDCRYPT volatile.Register32 // 0x104
	EVENTS_ERROR    volatile.Register32 // 0x108
	_               [244]byte
	SHORTS          volatile.Register32 // 0x200
	_               [256]byte
	INTENSET        volatile.Register32 // 0x304
	INTENCLR        volatile.Register32 // 0x308
	_               [244]byte
	MICSTATUS       volatile.Register32 // 0x400
	_               [252]byte
	ENABLE          volatile.Register32 // 0x500
	MODE            volatile.Register32 // 0x504
	CNFPTR          volatile.Register32 // 0x508
	INPTR           volatile.Register32 // 0x50C
	OUTPTR          volatile.Register32 // 0x510
	SCRATCHPTR      volatile.Register32 // 0x514
	_               [2788]byte
	POWER           volatile.Register32 // 0xFFC
}

// Watchdog Timer.
type WDT_Type struct {
	TASKS_START    volatile.Register32 // 0x0
	_              [252]byte
	EVENTS_TIMEOUT volatile.Register32 // 0x100
	_              [512]byte
	INTENSET       volatile.Register32 // 0x304
	INTENCLR       volatile.Register32 // 0x308
	_              [244]byte
	RUNSTATUS      volatile.Register32 // 0x400
	REQSTATUS      volatile.Register32 // 0x404
	_              [252]byte
	CRV            volatile.Register32 // 0x504
	RREN           volatile.Register32 // 0x508
	CONFIG         volatile.Register32 // 0x50C
	_              [240]byte
	RR             [8]volatile.Register32 // 0x600
	_              [2524]byte
	POWER          volatile.Register32 // 0xFFC
}

// Rotary decoder.
type QDEC_Type struct {
	TASKS_START      volatile.Register32 // 0x0
	TASKS_STOP       volatile.Register32 // 0x4
	TASKS_READCLRACC volatile.Register32 // 0x8
	_                [244]byte
	EVENTS_SAMPLERDY volatile.Register32 // 0x100
	EVENTS_REPORTRDY volatile.Register32 // 0x104
	EVENTS_ACCOF     volatile.Register32 // 0x108
	_                [244]byte
	SHORTS           volatile.Register32 // 0x200
	_                [256]byte
	INTENSET         volatile.Register32 // 0x304
	INTENCLR         volatile.Register32 // 0x308
	_                [500]byte
	ENABLE           volatile.Register32 // 0x500
	LEDPOL           volatile.Register32 // 0x504
	SAMPLEPER        volatile.Register32 // 0x508
	SAMPLE           volatile.Register32 // 0x50C
	REPORTPER        volatile.Register32 // 0x510
	ACC              volatile.Register32 // 0x514
	ACCREAD          volatile.Register32 // 0x518
	PSELLED          volatile.Register32 // 0x51C
	PSELA            volatile.Register32 // 0x520
	PSELB            volatile.Register32 // 0x524
	DBFEN            volatile.Register32 // 0x528
	_                [20]byte
	LEDPRE           volatile.Register32 // 0x540
	ACCDBL           volatile.Register32 // 0x544
	ACCDBLREAD       volatile.Register32 // 0x548
	_                [2736]byte
	POWER            volatile.Register32 // 0xFFC
}

// Low power comparator.
type LPCOMP_Type struct {
	TASKS_START  volatile.Register32 // 0x0
	TASKS_STOP   volatile.Register32 // 0x4
	TASKS_SAMPLE volatile.Register32 // 0x8
	_            [244]byte
	EVENTS_READY volatile.Register32 // 0x100
	EVENTS_DOWN  volatile.Register32 // 0x104
	EVENTS_UP    volatile.Register32 // 0x108
	EVENTS_CROSS volatile.Register32 // 0x10C
	_            [240]byte
	SHORTS       volatile.Register32 // 0x200
	_            [256]byte
	INTENSET     volatile.Register32 // 0x304
	INTENCLR     volatile.Register32 // 0x308
	_            [244]byte
	RESULT       volatile.Register32 // 0x400
	_            [252]byte
	ENABLE       volatile.Register32 // 0x500
	PSEL         volatile.Register32 // 0x504
	REFSEL       volatile.Register32 // 0x508
	EXTREFSEL    volatile.Register32 // 0x50C
	_            [16]byte
	ANADETECT    volatile.Register32 // 0x520
	_            [2776]byte
	POWER        volatile.Register32 // 0xFFC
}

// SW Interrupts.
type SWI_Type struct {
	UNUSED volatile.Register32 // 0x0
}

// Non Volatile Memory Controller.
type NVMC_Type struct {
	_         [1024]byte
	READY     volatile.Register32 // 0x400
	_         [256]byte
	CONFIG    volatile.Register32 // 0x504
	ERASEPAGE volatile.Register32 // 0x508
	ERASEALL  volatile.Register32 // 0x50C
	ERASEPCR0 volatile.Register32 // 0x510
	ERASEUICR volatile.Register32 // 0x514
}

// PPI controller.
type PPI_Type struct {
	TASKS_CHG [4]struct {
		EN  volatile.Register32
		DIS volatile.Register32
	} // 0x0
	_       [1248]byte
	CHEN    volatile.Register32 // 0x500
	CHENSET volatile.Register32 // 0x504
	CHENCLR volatile.Register32 // 0x508
	_       [4]byte
	CH      [16]struct {
		EEP volatile.Register32
		TEP volatile.Register32
	} // 0x510
	_   [624]byte
	CHG [4]volatile.Register32 // 0x800
}

// Factory Information Configuration.
type FICR_Type struct {
	_              [16]byte
	CODEPAGESIZE   volatile.Register32 // 0x10
	CODESIZE       volatile.Register32 // 0x14
	_              [16]byte
	CLENR0         volatile.Register32 // 0x28
	PPFC           volatile.Register32 // 0x2C
	_              [4]byte
	NUMRAMBLOCK    volatile.Register32 // 0x34
	SIZERAMBLOCKS  volatile.Register32 // 0x38
	_              [32]byte
	CONFIGID       volatile.Register32    // 0x5C
	DEVICEID       [2]volatile.Register32 // 0x60
	_              [24]byte
	ER             [4]volatile.Register32 // 0x80
	IR             [4]volatile.Register32 // 0x90
	DEVICEADDRTYPE volatile.Register32    // 0xA0
	DEVICEADDR     [2]volatile.Register32 // 0xA4
	OVERRIDEEN     volatile.Register32    // 0xAC
	NRF_1MBIT      [5]volatile.Register32 // 0xB0
	_              [40]byte
	BLE_1MBIT      [5]volatile.Register32 // 0xEC
}

// User Information Configuration.
type UICR_Type struct {
	CLENR0         volatile.Register32 // 0x0
	RBPCONF        volatile.Register32 // 0x4
	XTALFREQ       volatile.Register32 // 0x8
	_              [4]byte
	FWID           volatile.Register32 // 0x10
	BOOTLOADERADDR volatile.Register32 // 0x14
	_              [56]byte
	NRFHW          [12]volatile.Register32 // 0x50
	CUSTOMER       [32]volatile.Register32 // 0x80
}

// General purpose input and output.
type GPIO_Type struct {
	_       [1284]byte
	OUT     volatile.Register32 // 0x504
	OUTSET  volatile.Register32 // 0x508
	OUTCLR  volatile.Register32 // 0x50C
	IN      volatile.Register32 // 0x510
	DIR     volatile.Register32 // 0x514
	DIRSET  volatile.Register32 // 0x518
	DIRCLR  volatile.Register32 // 0x51C
	_       [480]byte
	PIN_CNF [32]volatile.Register32 // 0x700
}

// Bitfields for POWER: Power Control.
const (
	// INTENSET: Interrupt enable set register.
	// Position of POFWARN field.
	POWER_INTENSET_POFWARN_Pos = 0x2
	// Bit mask of POFWARN field.
	POWER_INTENSET_POFWARN_Msk = 0x4
	// Bit POFWARN.
	POWER_INTENSET_POFWARN = 0x4
	// Interrupt disabled.
	POWER_INTENSET_POFWARN_Disabled = 0x0
	// Interrupt enabled.
	POWER_INTENSET_POFWARN_Enabled = 0x1
	// Enable interrupt on write.
	POWER_INTENSET_POFWARN_Set = 0x1

	// INTENCLR: Interrupt enable clear register.
	// Position of POFWARN field.
	POWER_INTENCLR_POFWARN_Pos = 0x2
	// Bit mask of POFWARN field.
	POWER_INTENCLR_POFWARN_Msk = 0x4
	// Bit POFWARN.
	POWER_INTENCLR_POFWARN = 0x4
	// Interrupt disabled.
	POWER_INTENCLR_POFWARN_Disabled = 0x0
	// Interrupt enabled.
	POWER_INTENCLR_POFWARN_Enabled = 0x1
	// Disable interrupt on write.
	POWER_INTENCLR_POFWARN_Clear = 0x1

	// RESETREAS: Reset reason.
	// Position of RESETPIN field.
	POWER_RESETREAS_RESETPIN_Pos = 0x0
	// Bit mask of RESETPIN field.
	POWER_RESETREAS_RESETPIN_Msk = 0x1
	// Bit RESETPIN.
	POWER_RESETREAS_RESETPIN = 0x1
	// Reset not detected.
	POWER_RESETREAS_RESETPIN_NotDetected = 0x0
	// Reset detected.
	POWER_RESETREAS_RESETPIN_Detected = 0x1
	// Position of DOG field.
	POWER_RESETREAS_DOG_Pos = 0x1
	// Bit mask of DOG field.
	POWER_RESETREAS_DOG_Msk = 0x2
	// Bit DOG.
	POWER_RESETREAS_DOG = 0x2
	// Reset not detected.
	POWER_RESETREAS_DOG_NotDetected = 0x0
	// Reset detected.
	POWER_RESETREAS_DOG_Detected = 0x1
	// Position of SREQ field.
	POWER_RESETREAS_SREQ_Pos = 0x2
	// Bit mask of SREQ field.
	POWER_RESETREAS_SREQ_Msk = 0x4
	// Bit SREQ.
	POWER_RESETREAS_SREQ = 0x4
	// Reset not detected.
	POWER_RESETREAS_SREQ_NotDetected = 0x0
	// Reset detected.
	POWER_RESETREAS_SREQ_Detected = 0x1
	// Position of LOCKUP field.
	POWER_RESETREAS_LOCKUP_Pos = 0x3
	// Bit mask of LOCKUP field.
	POWER_RESETREAS_LOCKUP_Msk = 0x8
	// Bit LOCKUP.
	POWER_RESETREAS_LOCKUP = 0x8
	// Reset not detected.
	POWER_RESETREAS_LOCKUP_NotDetected = 0x0
	// Reset detected.
	POWER_RESETREAS_LOCKUP_Detected = 0x1
	// Position of OFF field.
	POWER_RESETREAS_OFF_Pos = 0x10
	// Bit mask of OFF field.
	POWER_RESETREAS_OFF_Msk = 0x10000
	// Bit OFF.
	POWER_RESETREAS_OFF = 0x10000
	// Reset not detected.
	POWER_RESETREAS_OFF_NotDetected = 0x0
	// Reset detected.
	POWER_RESETREAS_OFF_Detected = 0x1
	// Position of LPCOMP field.
	POWER_RESETREAS_LPCOMP_Pos = 0x11
	// Bit mask of LPCOMP field.
	POWER_RESETREAS_LPCOMP_Msk = 0x20000
	// Bit LPCOMP.
	POWER_RESETREAS_LPCOMP = 0x20000
	// Reset not detected.
	POWER_RESETREAS_LPCOMP_NotDetected = 0x0
	// Reset detected.
	POWER_RESETREAS_LPCOMP_Detected = 0x1
	// Position of DIF field.
	POWER_RESETREAS_DIF_Pos = 0x12
	// Bit mask of DIF field.
	POWER_RESETREAS_DIF_Msk = 0x40000
	// Bit DIF.
	POWER_RESETREAS_DIF = 0x40000
	// Reset not detected.
	POWER_RESETREAS_DIF_NotDetected = 0x0
	// Reset detected.
	POWER_RESETREAS_DIF_Detected = 0x1

	// RAMSTATUS: Ram status register.
	// Position of RAMBLOCK0 field.
	POWER_RAMSTATUS_RAMBLOCK0_Pos = 0x0
	// Bit mask of RAMBLOCK0 field.
	POWER_RAMSTATUS_RAMBLOCK0_Msk = 0x1
	// Bit RAMBLOCK0.
	POWER_RAMSTATUS_RAMBLOCK0 = 0x1
	// RAM block 0 is off or powering up.
	POWER_RAMSTATUS_RAMBLOCK0_Off = 0x0
	// RAM block 0 is on.
	POWER_RAMSTATUS_RAMBLOCK0_On = 0x1
	// Position of RAMBLOCK1 field.
	POWER_RAMSTATUS_RAMBLOCK1_Pos = 0x1
	// Bit mask of RAMBLOCK1 field.
	POWER_RAMSTATUS_RAMBLOCK1_Msk = 0x2
	// Bit RAMBLOCK1.
	POWER_RAMSTATUS_RAMBLOCK1 = 0x2
	// RAM block 1 is off or powering up.
	POWER_RAMSTATUS_RAMBLOCK1_Off = 0x0
	// RAM block 1 is on.
	POWER_RAMSTATUS_RAMBLOCK1_On = 0x1
	// Position of RAMBLOCK2 field.
	POWER_RAMSTATUS_RAMBLOCK2_Pos = 0x2
	// Bit mask of RAMBLOCK2 field.
	POWER_RAMSTATUS_RAMBLOCK2_Msk = 0x4
	// Bit RAMBLOCK2.
	POWER_RAMSTATUS_RAMBLOCK2 = 0x4
	// RAM block 2 is off or powering up.
	POWER_RAMSTATUS_RAMBLOCK2_Off = 0x0
	// RAM block 2 is on.
	POWER_RAMSTATUS_RAMBLOCK2_On = 0x1
	// Position of RAMBLOCK3 field.
	POWER_RAMSTATUS_RAMBLOCK3_Pos = 0x3
	// Bit mask of RAMBLOCK3 field.
	POWER_RAMSTATUS_RAMBLOCK3_Msk = 0x8
	// Bit RAMBLOCK3.
	POWER_RAMSTATUS_RAMBLOCK3 = 0x8
	// RAM block 3 is off or powering up.
	POWER_RAMSTATUS_RAMBLOCK3_Off = 0x0
	// RAM block 3 is on.
	POWER_RAMSTATUS_RAMBLOCK3_On = 0x1

	// SYSTEMOFF: System off register.
	// Position of SYSTEMOFF field.
	POWER_SYSTEMOFF_SYSTEMOFF_Pos = 0x0
	// Bit mask of SYSTEMOFF field.
	POWER_SYSTEMOFF_SYSTEMOFF_Msk = 0x1
	// Bit SYSTEMOFF.
	POWER_SYSTEMOFF_SYSTEMOFF = 0x1
	// Enter system off mode.
	POWER_SYSTEMOFF_SYSTEMOFF_Enter = 0x1

	// POFCON: Power failure configuration.
	// Position of POF field.
	POWER_POFCON_POF_Pos = 0x0
	// Bit mask of POF field.
	POWER_POFCON_POF_Msk = 0x1
	// Bit POF.
	POWER_POFCON_POF = 0x1
	// Disabled.
	POWER_POFCON_POF_Disabled = 0x0
	// Enabled.
	POWER_POFCON_POF_Enabled = 0x1
	// Position of THRESHOLD field.
	POWER_POFCON_THRESHOLD_Pos = 0x1
	// Bit mask of THRESHOLD field.
	POWER_POFCON_THRESHOLD_Msk = 0x6
	// Set threshold to 2.1Volts.
	POWER_POFCON_THRESHOLD_V21 = 0x0
	// Set threshold to 2.3Volts.
	POWER_POFCON_THRESHOLD_V23 = 0x1
	// Set threshold to 2.5Volts.
	POWER_POFCON_THRESHOLD_V25 = 0x2
	// Set threshold to 2.7Volts.
	POWER_POFCON_THRESHOLD_V27 = 0x3

	// GPREGRET: General purpose retention register. This register is a retained register.
	// Position of GPREGRET field.
	POWER_GPREGRET_GPREGRET_Pos = 0x0
	// Bit mask of GPREGRET field.
	POWER_GPREGRET_GPREGRET_Msk = 0xff

	// RAMON: Ram on/off.
	// Position of ONRAM0 field.
	POWER_RAMON_ONRAM0_Pos = 0x0
	// Bit mask of ONRAM0 field.
	POWER_RAMON_ONRAM0_Msk = 0x1
	// Bit ONRAM0.
	POWER_RAMON_ONRAM0 = 0x1
	// RAM block 0 OFF in ON mode.
	POWER_RAMON_ONRAM0_RAM0Off = 0x0
	// RAM block 0 ON in ON mode.
	POWER_RAMON_ONRAM0_RAM0On = 0x1
	// Position of ONRAM1 field.
	POWER_RAMON_ONRAM1_Pos = 0x1
	// Bit mask of ONRAM1 field.
	POWER_RAMON_ONRAM1_Msk = 0x2
	// Bit ONRAM1.
	POWER_RAMON_ONRAM1 = 0x2
	// RAM block 1 OFF in ON mode.
	POWER_RAMON_ONRAM1_RAM1Off = 0x0
	// RAM block 1 ON in ON mode.
	POWER_RAMON_ONRAM1_RAM1On = 0x1
	// Position of OFFRAM0 field.
	POWER_RAMON_OFFRAM0_Pos = 0x10
	// Bit mask of OFFRAM0 field.
	POWER_RAMON_OFFRAM0_Msk = 0x10000
	// Bit OFFRAM0.
	POWER_RAMON_OFFRAM0 = 0x10000
	// RAM block 0 OFF in OFF mode.
	POWER_RAMON_OFFRAM0_RAM0Off = 0x0
	// RAM block 0 ON in OFF mode.
	POWER_RAMON_OFFRAM0_RAM0On = 0x1
	// Position of OFFRAM1 field.
	POWER_RAMON_OFFRAM1_Pos = 0x11
	// Bit mask of OFFRAM1 field.
	POWER_RAMON_OFFRAM1_Msk = 0x20000
	// Bit OFFRAM1.
	POWER_RAMON_OFFRAM1 = 0x20000
	// RAM block 1 OFF in OFF mode.
	POWER_RAMON_OFFRAM1_RAM1Off = 0x0
	// RAM block 1 ON in OFF mode.
	POWER_RAMON_OFFRAM1_RAM1On = 0x1

	// RESET: Pin reset functionality configuration register. This register is a retained register.
	// Position of RESET field.
	POWER_RESET_RESET_Pos = 0x0
	// Bit mask of RESET field.
	POWER_RESET_RESET_Msk = 0x1
	// Bit RESET.
	POWER_RESET_RESET = 0x1
	// Pin reset in debug interface mode disabled.
	POWER_RESET_RESET_Disabled = 0x0
	// Pin reset in debug interface mode enabled.
	POWER_RESET_RESET_Enabled = 0x1

	// RAMONB: Ram on/off.
	// Position of ONRAM2 field.
	POWER_RAMONB_ONRAM2_Pos = 0x0
	// Bit mask of ONRAM2 field.
	POWER_RAMONB_ONRAM2_Msk = 0x1
	// Bit ONRAM2.
	POWER_RAMONB_ONRAM2 = 0x1
	// RAM block 2 OFF in ON mode.
	POWER_RAMONB_ONRAM2_RAM2Off = 0x0
	// RAM block 2 ON in ON mode.
	POWER_RAMONB_ONRAM2_RAM2On = 0x1
	// Position of ONRAM3 field.
	POWER_RAMONB_ONRAM3_Pos = 0x1
	// Bit mask of ONRAM3 field.
	POWER_RAMONB_ONRAM3_Msk = 0x2
	// Bit ONRAM3.
	POWER_RAMONB_ONRAM3 = 0x2
	// RAM block 33 OFF in ON mode.
	POWER_RAMONB_ONRAM3_RAM3Off = 0x0
	// RAM block 3 ON in ON mode.
	POWER_RAMONB_ONRAM3_RAM3On = 0x1
	// Position of OFFRAM2 field.
	POWER_RAMONB_OFFRAM2_Pos = 0x10
	// Bit mask of OFFRAM2 field.
	POWER_RAMONB_OFFRAM2_Msk = 0x10000
	// Bit OFFRAM2.
	POWER_RAMONB_OFFRAM2 = 0x10000
	// RAM block 2 OFF in OFF mode.
	POWER_RAMONB_OFFRAM2_RAM2Off = 0x0
	// RAM block 2 ON in OFF mode.
	POWER_RAMONB_OFFRAM2_RAM2On = 0x1
	// Position of OFFRAM3 field.
	POWER_RAMONB_OFFRAM3_Pos = 0x11
	// Bit mask of OFFRAM3 field.
	POWER_RAMONB_OFFRAM3_Msk = 0x20000
	// Bit OFFRAM3.
	POWER_RAMONB_OFFRAM3 = 0x20000
	// RAM block 3 OFF in OFF mode.
	POWER_RAMONB_OFFRAM3_RAM3Off = 0x0
	// RAM block 3 ON in OFF mode.
	POWER_RAMONB_OFFRAM3_RAM3On = 0x1

	// DCDCEN: DCDC converter enable configuration register.
	// Position of DCDCEN field.
	POWER_DCDCEN_DCDCEN_Pos = 0x0
	// Bit mask of DCDCEN field.
	POWER_DCDCEN_DCDCEN_Msk = 0x1
	// Bit DCDCEN.
	POWER_DCDCEN_DCDCEN = 0x1
	// DCDC converter disabled.
	POWER_DCDCEN_DCDCEN_Disabled = 0x0
	// DCDC converter enabled.
	POWER_DCDCEN_DCDCEN_Enabled = 0x1

	// DCDCFORCE: DCDC power-up force register.
	// Position of FORCEOFF field.
	POWER_DCDCFORCE_FORCEOFF_Pos = 0x0
	// Bit mask of FORCEOFF field.
	POWER_DCDCFORCE_FORCEOFF_Msk = 0x1
	// Bit FORCEOFF.
	POWER_DCDCFORCE_FORCEOFF = 0x1
	// No force.
	POWER_DCDCFORCE_FORCEOFF_NoForce = 0x0
	// Force.
	POWER_DCDCFORCE_FORCEOFF_Force = 0x1
	// Position of FORCEON field.
	POWER_DCDCFORCE_FORCEON_Pos = 0x1
	// Bit mask of FORCEON field.
	POWER_DCDCFORCE_FORCEON_Msk = 0x2
	// Bit FORCEON.
	POWER_DCDCFORCE_FORCEON = 0x2
	// No force.
	POWER_DCDCFORCE_FORCEON_NoForce = 0x0
	// Force.
	POWER_DCDCFORCE_FORCEON_Force = 0x1
)

// Bitfields for CLOCK: Clock control.
const (
	// INTENSET: Interrupt enable set register.
	// Position of HFCLKSTARTED field.
	CLOCK_INTENSET_HFCLKSTARTED_Pos = 0x0
	// Bit mask of HFCLKSTARTED field.
	CLOCK_INTENSET_HFCLKSTARTED_Msk = 0x1
	// Bit HFCLKSTARTED.
	CLOCK_INTENSET_HFCLKSTARTED = 0x1
	// Interrupt disabled.
	CLOCK_INTENSET_HFCLKSTARTED_Disabled = 0x0
	// Interrupt enabled.
	CLOCK_INTENSET_HFCLKSTARTED_Enabled = 0x1
	// Enable interrupt on write.
	CLOCK_INTENSET_HFCLKSTARTED_Set = 0x1
	// Position of LFCLKSTARTED field.
	CLOCK_INTENSET_LFCLKSTARTED_Pos = 0x1
	// Bit mask of LFCLKSTARTED field.
	CLOCK_INTENSET_LFCLKSTARTED_Msk = 0x2
	// Bit LFCLKSTARTED.
	CLOCK_INTENSET_LFCLKSTARTED = 0x2
	// Interrupt disabled.
	CLOCK_INTENSET_LFCLKSTARTED_Disabled = 0x0
	// Interrupt enabled.
	CLOCK_INTENSET_LFCLKSTARTED_Enabled = 0x1
	// Enable interrupt on write.
	CLOCK_INTENSET_LFCLKSTARTED_Set = 0x1
	// Position of DONE field.
	CLOCK_INTENSET_DONE_Pos = 0x3
	// Bit mask of DONE field.
	CLOCK_INTENSET_DONE_Msk = 0x8
	// Bit DONE.
	CLOCK_INTENSET_DONE = 0x8
	// Interrupt disabled.
	CLOCK_INTENSET_DONE_Disabled = 0x0
	// Interrupt enabled.
	CLOCK_INTENSET_DONE_Enabled = 0x1
	// Enable interrupt on write.
	CLOCK_INTENSET_DONE_Set = 0x1
	// Position of CTTO field.
	CLOCK_INTENSET_CTTO_Pos = 0x4
	// Bit mask of CTTO field.
	CLOCK_INTENSET_CTTO_Msk = 0x10
	// Bit CTTO.
	CLOCK_INTENSET_CTTO = 0x10
	// Interrupt disabled.
	CLOCK_INTENSET_CTTO_Disabled = 0x0
	// Interrupt enabled.
	CLOCK_INTENSET_CTTO_Enabled = 0x1
	// Enable interrupt on write.
	CLOCK_INTENSET_CTTO_Set = 0x1

	// INTENCLR: Interrupt enable clear register.
	// Position of HFCLKSTARTED field.
	CLOCK_INTENCLR_HFCLKSTARTED_Pos = 0x0
	// Bit mask of HFCLKSTARTED field.
	CLOCK_INTENCLR_HFCLKSTARTED_Msk = 0x1
	// Bit HFCLKSTARTED.
	CLOCK_INTENCLR_HFCLKSTARTED = 0x1
	// Interrupt disabled.
	CLOCK_INTENCLR_HFCLKSTARTED_Disabled = 0x0
	// Interrupt enabled.
	CLOCK_INTENCLR_HFCLKSTARTED_Enabled = 0x1
	// Disable interrupt on write.
	CLOCK_INTENCLR_HFCLKSTARTED_Clear = 0x1
	// Position of LFCLKSTARTED field.
	CLOCK_INTENCLR_LFCLKSTARTED_Pos = 0x1
	// Bit mask of LFCLKSTARTED field.
	CLOCK_INTENCLR_LFCLKSTARTED_Msk = 0x2
	// Bit LFCLKSTARTED.
	CLOCK_INTENCLR_LFCLKSTARTED = 0x2
	// Interrupt disabled.
	CLOCK_INTENCLR_LFCLKSTARTED_Disabled = 0x0
	// Interrupt enabled.
	CLOCK_INTENCLR_LFCLKSTARTED_Enabled = 0x1
	// Disable interrupt on write.
	CLOCK_INTENCLR_LFCLKSTARTED_Clear = 0x1
	// Position of DONE field.
	CLOCK_INTENCLR_DONE_Pos = 0x3
	// Bit mask of DONE field.
	CLOCK_INTENCLR_DONE_Msk = 0x8
	// Bit DONE.
	CLOCK_INTENCLR_DONE = 0x8
	// Interrupt disabled.
	CLOCK_INTENCLR_DONE_Disabled = 0x0
	// Interrupt enabled.
	CLOCK_INTENCLR_DONE_Enabled = 0x1
	// Disable interrupt on write.
	CLOCK_INTENCLR_DONE_Clear = 0x1
	// Position of CTTO field.
	CLOCK_INTENCLR_CTTO_Pos = 0x4
	// Bit mask of CTTO field.
	CLOCK_INTENCLR_CTTO_Msk = 0x10
	// Bit CTTO.
	CLOCK_INTENCLR_CTTO = 0x10
	// Interrupt disabled.
	CLOCK_INTENCLR_CTTO_Disabled = 0x0
	// Interrupt enabled.
	CLOCK_INTENCLR_CTTO_Enabled = 0x1
	// Disable interrupt on write.
	CLOCK_INTENCLR_CTTO_Clear = 0x1

	// HFCLKRUN: Task HFCLKSTART trigger status.
	// Position of STATUS field.
	CLOCK_HFCLKRUN_STATUS_Pos = 0x0
	// Bit mask of STATUS field.
	CLOCK_HFCLKRUN_STATUS_Msk = 0x1
	// Bit STATUS.
	CLOCK_HFCLKRUN_STATUS = 0x1
	// Task HFCLKSTART has not been triggered.
	CLOCK_HFCLKRUN_STATUS_NotTriggered = 0x0
	// Task HFCLKSTART has been triggered.
	CLOCK_HFCLKRUN_STATUS_Triggered = 0x1

	// HFCLKSTAT: High frequency clock status.
	// Position of SRC field.
	CLOCK_HFCLKSTAT_SRC_Pos = 0x0
	// Bit mask of SRC field.
	CLOCK_HFCLKSTAT_SRC_Msk = 0x1
	// Bit SRC.
	CLOCK_HFCLKSTAT_SRC = 0x1
	// Internal 16MHz RC oscillator running and generating the HFCLK clock.
	CLOCK_HFCLKSTAT_SRC_RC = 0x0
	// External 16MHz/32MHz crystal oscillator running and generating the HFCLK clock.
	CLOCK_HFCLKSTAT_SRC_Xtal = 0x1
	// Position of STATE field.
	CLOCK_HFCLKSTAT_STATE_Pos = 0x10
	// Bit mask of STATE field.
	CLOCK_HFCLKSTAT_STATE_Msk = 0x10000
	// Bit STATE.
	CLOCK_HFCLKSTAT_STATE = 0x10000
	// HFCLK clock not running.
	CLOCK_HFCLKSTAT_STATE_NotRunning = 0x0
	// HFCLK clock running.
	CLOCK_HFCLKSTAT_STATE_Running = 0x1

	// LFCLKRUN: Task LFCLKSTART triggered status.
	// Position of STATUS field.
	CLOCK_LFCLKRUN_STATUS_Pos = 0x0
	// Bit mask of STATUS field.
	CLOCK_LFCLKRUN_STATUS_Msk = 0x1
	// Bit STATUS.
	CLOCK_LFCLKRUN_STATUS = 0x1
	// Task LFCLKSTART has not been triggered.
	CLOCK_LFCLKRUN_STATUS_NotTriggered = 0x0
	// Task LFCLKSTART has been triggered.
	CLOCK_LFCLKRUN_STATUS_Triggered = 0x1

	// LFCLKSTAT: Low frequency clock status.
	// Position of SRC field.
	CLOCK_LFCLKSTAT_SRC_Pos = 0x0
	// Bit mask of SRC field.
	CLOCK_LFCLKSTAT_SRC_Msk = 0x3
	// Internal 32KiHz RC oscillator running and generating the LFCLK clock.
	CLOCK_LFCLKSTAT_SRC_RC = 0x0
	// External 32KiHz crystal oscillator running and generating the LFCLK clock.
	CLOCK_LFCLKSTAT_SRC_Xtal = 0x1
	// Internal 32KiHz synthesizer from the HFCLK running and generating the LFCLK clock.
	CLOCK_LFCLKSTAT_SRC_Synth = 0x2
	// Position of STATE field.
	CLOCK_LFCLKSTAT_STATE_Pos = 0x10
	// Bit mask of STATE field.
	CLOCK_LFCLKSTAT_STATE_Msk = 0x10000
	// Bit STATE.
	CLOCK_LFCLKSTAT_STATE = 0x10000
	// LFCLK clock not running.
	CLOCK_LFCLKSTAT_STATE_NotRunning = 0x0
	// LFCLK clock running.
	CLOCK_LFCLKSTAT_STATE_Running = 0x1

	// LFCLKSRCCOPY: Clock source for the LFCLK clock, set when task LKCLKSTART is triggered.
	// Position of SRC field.
	CLOCK_LFCLKSRCCOPY_SRC_Pos = 0x0
	// Bit mask of SRC field.
	CLOCK_LFCLKSRCCOPY_SRC_Msk = 0x3
	// Internal 32KiHz RC oscillator.
	CLOCK_LFCLKSRCCOPY_SRC_RC = 0x0
	// External 32KiHz crystal.
	CLOCK_LFCLKSRCCOPY_SRC_Xtal = 0x1
	// Internal 32KiHz synthesizer from HFCLK system clock.
	CLOCK_LFCLKSRCCOPY_SRC_Synth = 0x2

	// LFCLKSRC: Clock source for the LFCLK clock.
	// Position of SRC field.
	CLOCK_LFCLKSRC_SRC_Pos = 0x0
	// Bit mask of SRC field.
	CLOCK_LFCLKSRC_SRC_Msk = 0x3
	// Internal 32KiHz RC oscillator.
	CLOCK_LFCLKSRC_SRC_RC = 0x0
	// External 32KiHz crystal.
	CLOCK_LFCLKSRC_SRC_Xtal = 0x1
	// Internal 32KiHz synthesizer from HFCLK system clock.
	CLOCK_LFCLKSRC_SRC_Synth = 0x2

	// CTIV: Calibration timer interval.
	// Position of CTIV field.
	CLOCK_CTIV_CTIV_Pos = 0x0
	// Bit mask of CTIV field.
	CLOCK_CTIV_CTIV_Msk = 0x7f

	// XTALFREQ: Crystal frequency.
	// Position of XTALFREQ field.
	CLOCK_XTALFREQ_XTALFREQ_Pos = 0x0
	// Bit mask of XTALFREQ field.
	CLOCK_XTALFREQ_XTALFREQ_Msk = 0xff
	// 16MHz xtal is used as source for the HFCLK oscillator.
	CLOCK_XTALFREQ_XTALFREQ_16MHz = 0xff
	// 32MHz xtal is used as source for the HFCLK oscillator.
	CLOCK_XTALFREQ_XTALFREQ_32MHz = 0x0
)

// Bitfields for MPU: Memory Protection Unit.
const (
	// PERR0: Configuration of peripherals in mpu regions.
	// Position of POWER_CLOCK field.
	MPU_PERR0_POWER_CLOCK_Pos = 0x0
	// Bit mask of POWER_CLOCK field.
	MPU_PERR0_POWER_CLOCK_Msk = 0x1
	// Bit POWER_CLOCK.
	MPU_PERR0_POWER_CLOCK = 0x1
	// Peripheral configured in region 0.
	MPU_PERR0_POWER_CLOCK_InRegion0 = 0x1
	// Peripheral configured in region 1.
	MPU_PERR0_POWER_CLOCK_InRegion1 = 0x0
	// Position of RADIO field.
	MPU_PERR0_RADIO_Pos = 0x1
	// Bit mask of RADIO field.
	MPU_PERR0_RADIO_Msk = 0x2
	// Bit RADIO.
	MPU_PERR0_RADIO = 0x2
	// Peripheral configured in region 0.
	MPU_PERR0_RADIO_InRegion0 = 0x1
	// Peripheral configured in region 1.
	MPU_PERR0_RADIO_InRegion1 = 0x0
	// Position of UART0 field.
	MPU_PERR0_UART0_Pos = 0x2
	// Bit mask of UART0 field.
	MPU_PERR0_UART0_Msk = 0x4
	// Bit UART0.
	MPU_PERR0_UART0 = 0x4
	// Peripheral configured in region 0.
	MPU_PERR0_UART0_InRegion0 = 0x1
	// Peripheral configured in region 1.
	MPU_PERR0_UART0_InRegion1 = 0x0
	// Position of SPI0_TWI0 field.
	MPU_PERR0_SPI0_TWI0_Pos = 0x3
	// Bit mask of SPI0_TWI0 field.
	MPU_PERR0_SPI0_TWI0_Msk = 0x8
	// Bit SPI0_TWI0.
	MPU_PERR0_SPI0_TWI0 = 0x8
	// Peripheral configured in region 0.
	MPU_PERR0_SPI0_TWI0_InRegion0 = 0x1
	// Peripheral configured in region 1.
	MPU_PERR0_SPI0_TWI0_InRegion1 = 0x0
	// Position of SPI1_TWI1 field.
	MPU_PERR0_SPI1_TWI1_Pos = 0x4
	// Bit mask of SPI1_TWI1 field.
	MPU_PERR0_SPI1_TWI1_Msk = 0x10
	// Bit SPI1_TWI1.
	MPU_PERR0_SPI1_TWI1 = 0x10
	// Peripheral configured in region 0.
	MPU_PERR0_SPI1_TWI1_InRegion0 = 0x1
	// Peripheral configured in region 1.
	MPU_PERR0_SPI1_TWI1_InRegion1 = 0x0
	// Position of GPIOTE field.
	MPU_PERR0_GPIOTE_Pos = 0x6
	// Bit mask of GPIOTE field.
	MPU_PERR0_GPIOTE_Msk = 0x40
	// Bit GPIOTE.
	MPU_PERR0_GPIOTE = 0x40
	// Peripheral configured in region 0.
	MPU_PERR0_GPIOTE_InRegion0 = 0x1
	// Peripheral configured in region 1.
	MPU_PERR0_GPIOTE_InRegion1 = 0x0
	// Position of ADC field.
	MPU_PERR0_ADC_Pos = 0x7
	// Bit mask of ADC field.
	MPU_PERR0_ADC_Msk = 0x80
	// Bit ADC.
	MPU_PERR0_ADC = 0x80
	// Peripheral configured in region 0.
	MPU_PERR0_ADC_InRegion0 = 0x1
	// Peripheral configured in region 1.
	MPU_PERR0_ADC_InRegion1 = 0x0
	// Position of TIMER0 field.
	MPU_PERR0_TIMER0_Pos = 0x8
	// Bit mask of TIMER0 field.
	MPU_PERR0_TIMER0_Msk = 0x100
	// Bit TIMER0.
	MPU_PERR0_TIMER0 = 0x100
	// Peripheral configured in region 0.
	MPU_PERR0_TIMER0_InRegion0 = 0x1
	// Peripheral configured in region 1.
	MPU_PERR0_TIMER0_InRegion1 = 0x0
	// Position of TIMER1 field.
	MPU_PERR0_TIMER1_Pos = 0x9
	// Bit mask of TIMER1 field.
	MPU_PERR0_TIMER1_Msk = 0x200
	// Bit TIMER1.
	MPU_PERR0_TIMER1 = 0x200
	// Peripheral configured in region 0.
	MPU_PERR0_TIMER1_InRegion0 = 0x1
	// Peripheral configured in region 1.
	MPU_PERR0_TIMER1_InRegion1 = 0x0
	// Position of TIMER2 field.
	MPU_PERR0_TIMER2_Pos = 0xa
	// Bit mask of TIMER2 field.
	MPU_PERR0_TIMER2_Msk = 0x400
	// Bit TIMER2.
	MPU_PERR0_TIMER2 = 0x400
	// Peripheral configured in region 0.
	MPU_PERR0_TIMER2_InRegion0 = 0x1
	// Peripheral configured in region 1.
	MPU_PERR0_TIMER2_InRegion1 = 0x0
	// Position of RTC0 field.
	MPU_PERR0_RTC0_Pos = 0xb
	// Bit mask of RTC0 field.
	MPU_PERR0_RTC0_Msk = 0x800
	// Bit RTC0.
	MPU_PERR0_RTC0 = 0x800
	// Peripheral configured in region 0.
	MPU_PERR0_RTC0_InRegion0 = 0x1
	// Peripheral configured in region 1.
	MPU_PERR0_RTC0_InRegion1 = 0x0
	// Position of TEMP field.
	MPU_PERR0_TEMP_Pos = 0xc
	// Bit mask of TEMP field.
	MPU_PERR0_TEMP_Msk = 0x1000
	// Bit TEMP.
	MPU_PERR0_TEMP = 0x1000
	// Peripheral configured in region 0.
	MPU_PERR0_TEMP_InRegion0 = 0x1
	// Peripheral configured in region 1.
	MPU_PERR0_TEMP_InRegion1 = 0x0
	// Position of RNG field.
	MPU_PERR0_RNG_Pos = 0xd
	// Bit mask of RNG field.
	MPU_PERR0_RNG_Msk = 0x2000
	// Bit RNG.
	MPU_PERR0_RNG = 0x2000
	// Peripheral configured in region 0.
	MPU_PERR0_RNG_InRegion0 = 0x1
	// Peripheral configured in region 1.
	MPU_PERR0_RNG_InRegion1 = 0x0
	// Position of ECB field.
	MPU_PERR0_ECB_Pos = 0xe
	// Bit mask of ECB field.
	MPU_PERR0_ECB_Msk = 0x4000
	// Bit ECB.
	MPU_PERR0_ECB = 0x4000
	// Peripheral configured in region 0.
	MPU_PERR0_ECB_InRegion0 = 0x1
	// Peripheral configured in region 1.
	MPU_PERR0_ECB_InRegion1 = 0x0
	// Position of CCM_AAR field.
	MPU_PERR0_CCM_AAR_Pos = 0xf
	// Bit mask of CCM_AAR field.
	MPU_PERR0_CCM_AAR_Msk = 0x8000
	// Bit CCM_AAR.
	MPU_PERR0_CCM_AAR = 0x8000
	// Peripheral configured in region 0.
	MPU_PERR0_CCM_AAR_InRegion0 = 0x1
	// Peripheral configured in region 1.
	MPU_PERR0_CCM_AAR_InRegion1 = 0x0
	// Position of WDT field.
	MPU_PERR0_WDT_Pos = 0x10
	// Bit mask of WDT field.
	MPU_PERR0_WDT_Msk = 0x10000
	// Bit WDT.
	MPU_PERR0_WDT = 0x10000
	// Peripheral configured in region 0.
	MPU_PERR0_WDT_InRegion0 = 0x1
	// Peripheral configured in region 1.
	MPU_PERR0_WDT_InRegion1 = 0x0
	// Position of RTC1 field.
	MPU_PERR0_RTC1_Pos = 0x11
	// Bit mask of RTC1 field.
	MPU_PERR0_RTC1_Msk = 0x20000
	// Bit RTC1.
	MPU_PERR0_RTC1 = 0x20000
	// Peripheral configured in region 0.
	MPU_PERR0_RTC1_InRegion0 = 0x1
	// Peripheral configured in region 1.
	MPU_PERR0_RTC1_InRegion1 = 0x0
	// Position of QDEC field.
	MPU_PERR0_QDEC_Pos = 0x12
	// Bit mask of QDEC field.
	MPU_PERR0_QDEC_Msk = 0x40000
	// Bit QDEC.
	MPU_PERR0_QDEC = 0x40000
	// Peripheral configured in region 0.
	MPU_PERR0_QDEC_InRegion0 = 0x1
	// Peripheral configured in region 1.
	MPU_PERR0_QDEC_InRegion1 = 0x0
	// Position of LPCOMP field.
	MPU_PERR0_LPCOMP_Pos = 0x13
	// Bit mask of LPCOMP field.
	MPU_PERR0_LPCOMP_Msk = 0x80000
	// Bit LPCOMP.
	MPU_PERR0_LPCOMP = 0x80000
	// Peripheral configured in region 0.
	MPU_PERR0_LPCOMP_InRegion0 = 0x1
	// Peripheral configured in region 1.
	MPU_PERR0_LPCOMP_InRegion1 = 0x0
	// Position of NVMC field.
	MPU_PERR0_NVMC_Pos = 0x1e
	// Bit mask of NVMC field.
	MPU_PERR0_NVMC_Msk = 0x40000000
	// Bit NVMC.
	MPU_PERR0_NVMC = 0x40000000
	// Peripheral configured in region 0.
	MPU_PERR0_NVMC_InRegion0 = 0x1
	// Peripheral configured in region 1.
	MPU_PERR0_NVMC_InRegion1 = 0x0
	// Position of PPI field.
	MPU_PERR0_PPI_Pos = 0x1f
	// Bit mask of PPI field.
	MPU_PERR0_PPI_Msk = 0x80000000
	// Bit PPI.
	MPU_PERR0_PPI = 0x80000000
	// Peripheral configured in region 0.
	MPU_PERR0_PPI_InRegion0 = 0x1
	// Peripheral configured in region 1.
	MPU_PERR0_PPI_InRegion1 = 0x0

	// PROTENSET0: Erase and write protection bit enable set register.
	// Position of PROTREG0 field.
	MPU_PROTENSET0_PROTREG0_Pos = 0x0
	// Bit mask of PROTREG0 field.
	MPU_PROTENSET0_PROTREG0_Msk = 0x1
	// Bit PROTREG0.
	MPU_PROTENSET0_PROTREG0 = 0x1
	// Protection disabled.
	MPU_PROTENSET0_PROTREG0_Disabled = 0x0
	// Protection enabled.
	MPU_PROTENSET0_PROTREG0_Enabled = 0x1
	// Enable protection on write.
	MPU_PROTENSET0_PROTREG0_Set = 0x1
	// Position of PROTREG1 field.
	MPU_PROTENSET0_PROTREG1_Pos = 0x1
	// Bit mask of PROTREG1 field.
	MPU_PROTENSET0_PROTREG1_Msk = 0x2
	// Bit PROTREG1.
	MPU_PROTENSET0_PROTREG1 = 0x2
	// Protection disabled.
	MPU_PROTENSET0_PROTREG1_Disabled = 0x0
	// Protection enabled.
	MPU_PROTENSET0_PROTREG1_Enabled = 0x1
	// Enable protection on write.
	MPU_PROTENSET0_PROTREG1_Set = 0x1
	// Position of PROTREG2 field.
	MPU_PROTENSET0_PROTREG2_Pos = 0x2
	// Bit mask of PROTREG2 field.
	MPU_PROTENSET0_PROTREG2_Msk = 0x4
	// Bit PROTREG2.
	MPU_PROTENSET0_PROTREG2 = 0x4
	// Protection disabled.
	MPU_PROTENSET0_PROTREG2_Disabled = 0x0
	// Protection enabled.
	MPU_PROTENSET0_PROTREG2_Enabled = 0x1
	// Enable protection on write.
	MPU_PROTENSET0_PROTREG2_Set = 0x1
	// Position of PROTREG3 field.
	MPU_PROTENSET0_PROTREG3_Pos = 0x3
	// Bit mask of PROTREG3 field.
	MPU_PROTENSET0_PROTREG3_Msk = 0x8
	// Bit PROTREG3.
	MPU_PROTENSET0_PROTREG3 = 0x8
	// Protection disabled.
	MPU_PROTENSET0_PROTREG3_Disabled = 0x0
	// Protection enabled.
	MPU_PROTENSET0_PROTREG3_Enabled = 0x1
	// Enable protection on write.
	MPU_PROTENSET0_PROTREG3_Set = 0x1
	// Position of PROTREG4 field.
	MPU_PROTENSET0_PROTREG4_Pos = 0x4
	// Bit mask of PROTREG4 field.
	MPU_PROTENSET0_PROTREG4_Msk = 0x10
	// Bit PROTREG4.
	MPU_PROTENSET0_PROTREG4 = 0x10
	// Protection disabled.
	MPU_PROTENSET0_PROTREG4_Disabled = 0x0
	// Protection enabled.
	MPU_PROTENSET0_PROTREG4_Enabled = 0x1
	// Enable protection on write.
	MPU_PROTENSET0_PROTREG4_Set = 0x1
	// Position of PROTREG5 field.
	MPU_PROTENSET0_PROTREG5_Pos = 0x5
	// Bit mask of PROTREG5 field.
	MPU_PROTENSET0_PROTREG5_Msk = 0x20
	// Bit PROTREG5.
	MPU_PROTENSET0_PROTREG5 = 0x20
	// Protection disabled.
	MPU_PROTENSET0_PROTREG5_Disabled = 0x0
	// Protection enabled.
	MPU_PROTENSET0_PROTREG5_Enabled = 0x1
	// Enable protection on write.
	MPU_PROTENSET0_PROTREG5_Set = 0x1
	// Position of PROTREG6 field.
	MPU_PROTENSET0_PROTREG6_Pos = 0x6
	// Bit mask of PROTREG6 field.
	MPU_PROTENSET0_PROTREG6_Msk = 0x40
	// Bit PROTREG6.
	MPU_PROTENSET0_PROTREG6 = 0x40
	// Protection disabled.
	MPU_PROTENSET0_PROTREG6_Disabled = 0x0
	// Protection enabled.
	MPU_PROTENSET0_PROTREG6_Enabled = 0x1
	// Enable protection on write.
	MPU_PROTENSET0_PROTREG6_Set = 0x1
	// Position of PROTREG7 field.
	MPU_PROTENSET0_PROTREG7_Pos = 0x7
	// Bit mask of PROTREG7 field.
	MPU_PROTENSET0_PROTREG7_Msk = 0x80
	// Bit PROTREG7.
	MPU_PROTENSET0_PROTREG7 = 0x80
	// Protection disabled.
	MPU_PROTENSET0_PROTREG7_Disabled = 0x0
	// Protection enabled.
	MPU_PROTENSET0_PROTREG7_Enabled = 0x1
	// Enable protection on write.
	MPU_PROTENSET0_PROTREG7_Set = 0x1
	// Position of PROTREG8 field.
	MPU_PROTENSET0_PROTREG8_Pos = 0x8
	// Bit mask of PROTREG8 field.
	MPU_PROTENSET0_PROTREG8_Msk = 0x100
	// Bit PROTREG8.
	MPU_PROTENSET0_PROTREG8 = 0x100
	// Protection disabled.
	MPU_PROTENSET0_PROTREG8_Disabled = 0x0
	// Protection enabled.
	MPU_PROTENSET0_PROTREG8_Enabled = 0x1
	// Enable protection on write.
	MPU_PROTENSET0_PROTREG8_Set = 0x1
	// Position of PROTREG9 field.
	MPU_PROTENSET0_PROTREG9_Pos = 0x9
	// Bit mask of PROTREG9 field.
	MPU_PROTENSET0_PROTREG9_Msk = 0x200
	// Bit PROTREG9.
	MPU_PROTENSET0_PROTREG9 = 0x200
	// Protection disabled.
	MPU_PROTENSET0_PROTREG9_Disabled = 0x0
	// Protection enabled.
	MPU_PROTENSET0_PROTREG9_Enabled = 0x1
	// Enable protection on write.
	MPU_PROTENSET0_PROTREG9_Set = 0x1
	// Position of PROTREG10 field.
	MPU_PROTENSET0_PROTREG10_Pos = 0xa
	// Bit mask of PROTREG10 field.
	MPU_PROTENSET0_PROTREG10_Msk = 0x400
	// Bit PROTREG10.
	MPU_PROTENSET0_PROTREG10 = 0x400
	// Protection disabled.
	MPU_PROTENSET0_PROTREG10_Disabled = 0x0
	// Protection enabled.
	MPU_PROTENSET0_PROTREG10_Enabled = 0x1
	// Enable protection on write.
	MPU_PROTENSET0_PROTREG10_Set = 0x1
	// Position of PROTREG11 field.
	MPU_PROTENSET0_PROTREG11_Pos = 0xb
	// Bit mask of PROTREG11 field.
	MPU_PROTENSET0_PROTREG11_Msk = 0x800
	// Bit PROTREG11.
	MPU_PROTENSET0_PROTREG11 = 0x800
	// Protection disabled.
	MPU_PROTENSET0_PROTREG11_Disabled = 0x0
	// Protection enabled.
	MPU_PROTENSET0_PROTREG11_Enabled = 0x1
	// Enable protection on write.
	MPU_PROTENSET0_PROTREG11_Set = 0x1
	// Position of PROTREG12 field.
	MPU_PROTENSET0_PROTREG12_Pos = 0xc
	// Bit mask of PROTREG12 field.
	MPU_PROTENSET0_PROTREG12_Msk = 0x1000
	// Bit PROTREG12.
	MPU_PROTENSET0_PROTREG12 = 0x1000
	// Protection disabled.
	MPU_PROTENSET0_PROTREG12_Disabled = 0x0
	// Protection enabled.
	MPU_PROTENSET0_PROTREG12_Enabled = 0x1
	// Enable protection on write.
	MPU_PROTENSET0_PROTREG12_Set = 0x1
	// Position of PROTREG13 field.
	MPU_PROTENSET0_PROTREG13_Pos = 0xd
	// Bit mask of PROTREG13 field.
	MPU_PROTENSET0_PROTREG13_Msk = 0x2000
	// Bit PROTREG13.
	MPU_PROTENSET0_PROTREG13 = 0x2000
	// Protection disabled.
	MPU_PROTENSET0_PROTREG13_Disabled = 0x0
	// Protection enabled.
	MPU_PROTENSET0_PROTREG13_Enabled = 0x1
	// Enable protection on write.
	MPU_PROTENSET0_PROTREG13_Set = 0x1
	// Position of PROTREG14 field.
	MPU_PROTENSET0_PROTREG14_Pos = 0xe
	// Bit mask of PROTREG14 field.
	MPU_PROTENSET0_PROTREG14_Msk = 0x4000
	// Bit PROTREG14.
	MPU_PROTENSET0_PROTREG14 = 0x4000
	// Protection disabled.
	MPU_PROTENSET0_PROTREG14_Disabled = 0x0
	// Protection enabled.
	MPU_PROTENSET0_PROTREG14_Enabled = 0x1
	// Enable protection on write.
	MPU_PROTENSET0_PROTREG14_Set = 0x1
	// Position of PROTREG15 field.
	MPU_PROTENSET0_PROTREG15_Pos = 0xf
	// Bit mask of PROTREG15 field.
	MPU_PROTENSET0_PROTREG15_Msk = 0x8000
	// Bit PROTREG15.
	MPU_PROTENSET0_PROTREG15 = 0x8000
	// Protection disabled.
	MPU_PROTENSET0_PROTREG15_Disabled = 0x0
	// Protection enabled.
	MPU_PROTENSET0_PROTREG15_Enabled = 0x1
	// Enable protection on write.
	MPU_PROTENSET0_PROTREG15_Set = 0x1
	// Position of PROTREG16 field.
	MPU_PROTENSET0_PROTREG16_Pos = 0x10
	// Bit mask of PROTREG16 field.
	MPU_PROTENSET0_PROTREG16_Msk = 0x10000
	// Bit PROTREG16.
	MPU_PROTENSET0_PROTREG16 = 0x10000
	// Protection disabled.
	MPU_PROTENSET0_PROTREG16_Disabled = 0x0
	// Protection enabled.
	MPU_PROTENSET0_PROTREG16_Enabled = 0x1
	// Enable protection on write.
	MPU_PROTENSET0_PROTREG16_Set = 0x1
	// Position of PROTREG17 field.
	MPU_PROTENSET0_PROTREG17_Pos = 0x11
	// Bit mask of PROTREG17 field.
	MPU_PROTENSET0_PROTREG17_Msk = 0x20000
	// Bit PROTREG17.
	MPU_PROTENSET0_PROTREG17 = 0x20000
	// Protection disabled.
	MPU_PROTENSET0_PROTREG17_Disabled = 0x0
	// Protection enabled.
	MPU_PROTENSET0_PROTREG17_Enabled = 0x1
	// Enable protection on write.
	MPU_PROTENSET0_PROTREG17_Set = 0x1
	// Position of PROTREG18 field.
	MPU_PROTENSET0_PROTREG18_Pos = 0x12
	// Bit mask of PROTREG18 field.
	MPU_PROTENSET0_PROTREG18_Msk = 0x40000
	// Bit PROTREG18.
	MPU_PROTENSET0_PROTREG18 = 0x40000
	// Protection disabled.
	MPU_PROTENSET0_PROTREG18_Disabled = 0x0
	// Protection enabled.
	MPU_PROTENSET0_PROTREG18_Enabled = 0x1
	// Enable protection on write.
	MPU_PROTENSET0_PROTREG18_Set = 0x1
	// Position of PROTREG19 field.
	MPU_PROTENSET0_PROTREG19_Pos = 0x13
	// Bit mask of PROTREG19 field.
	MPU_PROTENSET0_PROTREG19_Msk = 0x80000
	// Bit PROTREG19.
	MPU_PROTENSET0_PROTREG19 = 0x80000
	// Protection disabled.
	MPU_PROTENSET0_PROTREG19_Disabled = 0x0
	// Protection enabled.
	MPU_PROTENSET0_PROTREG19_Enabled = 0x1
	// Enable protection on write.
	MPU_PROTENSET0_PROTREG19_Set = 0x1
	// Position of PROTREG20 field.
	MPU_PROTENSET0_PROTREG20_Pos = 0x14
	// Bit mask of PROTREG20 field.
	MPU_PROTENSET0_PROTREG20_Msk = 0x100000
	// Bit PROTREG20.
	MPU_PROTENSET0_PROTREG20 = 0x100000
	// Protection disabled.
	MPU_PROTENSET0_PROTREG20_Disabled = 0x0
	// Protection enabled.
	MPU_PROTENSET0_PROTREG20_Enabled = 0x1
	// Enable protection on write.
	MPU_PROTENSET0_PROTREG20_Set = 0x1
	// Position of PROTREG21 field.
	MPU_PROTENSET0_PROTREG21_Pos = 0x15
	// Bit mask of PROTREG21 field.
	MPU_PROTENSET0_PROTREG21_Msk = 0x200000
	// Bit PROTREG21.
	MPU_PROTENSET0_PROTREG21 = 0x200000
	// Protection disabled.
	MPU_PROTENSET0_PROTREG21_Disabled = 0x0
	// Protection enabled.
	MPU_PROTENSET0_PROTREG21_Enabled = 0x1
	// Enable protection on write.
	MPU_PROTENSET0_PROTREG21_Set = 0x1
	// Position of PROTREG22 field.
	MPU_PROTENSET0_PROTREG22_Pos = 0x16
	// Bit mask of PROTREG22 field.
	MPU_PROTENSET0_PROTREG22_Msk = 0x400000
	// Bit PROTREG22.
	MPU_PROTENSET0_PROTREG22 = 0x400000
	// Protection disabled.
	MPU_PROTENSET0_PROTREG22_Disabled = 0x0
	// Protection enabled.
	MPU_PROTENSET0_PROTREG22_Enabled = 0x1
	// Enable protection on write.
	MPU_PROTENSET0_PROTREG22_Set = 0x1
	// Position of PROTREG23 field.
	MPU_PROTENSET0_PROTREG23_Pos = 0x17
	// Bit mask of PROTREG23 field.
	MPU_PROTENSET0_PROTREG23_Msk = 0x800000
	// Bit PROTREG23.
	MPU_PROTENSET0_PROTREG23 = 0x800000
	// Protection disabled.
	MPU_PROTENSET0_PROTREG23_Disabled = 0x0
	// Protection enabled.
	MPU_PROTENSET0_PROTREG23_Enabled = 0x1
	// Enable protection on write.
	MPU_PROTENSET0_PROTREG23_Set = 0x1
	// Position of PROTREG24 field.
	MPU_PROTENSET0_PROTREG24_Pos = 0x18
	// Bit mask of PROTREG24 field.
	MPU_PROTENSET0_PROTREG24_Msk = 0x1000000
	// Bit PROTREG24.
	MPU_PROTENSET0_PROTREG24 = 0x1000000
	// Protection disabled.
	MPU_PROTENSET0_PROTREG24_Disabled = 0x0
	// Protection enabled.
	MPU_PROTENSET0_PROTREG24_Enabled = 0x1
	// Enable protection on write.
	MPU_PROTENSET0_PROTREG24_Set = 0x1
	// Position of PROTREG25 field.
	MPU_PROTENSET0_PROTREG25_Pos = 0x19
	// Bit mask of PROTREG25 field.
	MPU_PROTENSET0_PROTREG25_Msk = 0x2000000
	// Bit PROTREG25.
	MPU_PROTENSET0_PROTREG25 = 0x2000000
	// Protection disabled.
	MPU_PROTENSET0_PROTREG25_Disabled = 0x0
	// Protection enabled.
	MPU_PROTENSET0_PROTREG25_Enabled = 0x1
	// Enable protection on write.
	MPU_PROTENSET0_PROTREG25_Set = 0x1
	// Position of PROTREG26 field.
	MPU_PROTENSET0_PROTREG26_Pos = 0x1a
	// Bit mask of PROTREG26 field.
	MPU_PROTENSET0_PROTREG26_Msk = 0x4000000
	// Bit PROTREG26.
	MPU_PROTENSET0_PROTREG26 = 0x4000000
	// Protection disabled.
	MPU_PROTENSET0_PROTREG26_Disabled = 0x0
	// Protection enabled.
	MPU_PROTENSET0_PROTREG26_Enabled = 0x1
	// Enable protection on write.
	MPU_PROTENSET0_PROTREG26_Set = 0x1
	// Position of PROTREG27 field.
	MPU_PROTENSET0_PROTREG27_Pos = 0x1b
	// Bit mask of PROTREG27 field.
	MPU_PROTENSET0_PROTREG27_Msk = 0x8000000
	// Bit PROTREG27.
	MPU_PROTENSET0_PROTREG27 = 0x8000000
	// Protection disabled.
	MPU_PROTENSET0_PROTREG27_Disabled = 0x0
	// Protection enabled.
	MPU_PROTENSET0_PROTREG27_Enabled = 0x1
	// Enable protection on write.
	MPU_PROTENSET0_PROTREG27_Set = 0x1
	// Position of PROTREG28 field.
	MPU_PROTENSET0_PROTREG28_Pos = 0x1c
	// Bit mask of PROTREG28 field.
	MPU_PROTENSET0_PROTREG28_Msk = 0x10000000
	// Bit PROTREG28.
	MPU_PROTENSET0_PROTREG28 = 0x10000000
	// Protection disabled.
	MPU_PROTENSET0_PROTREG28_Disabled = 0x0
	// Protection enabled.
	MPU_PROTENSET0_PROTREG28_Enabled = 0x1
	// Enable protection on write.
	MPU_PROTENSET0_PROTREG28_Set = 0x1
	// Position of PROTREG29 field.
	MPU_PROTENSET0_PROTREG29_Pos = 0x1d
	// Bit mask of PROTREG29 field.
	MPU_PROTENSET0_PROTREG29_Msk = 0x20000000
	// Bit PROTREG29.
	MPU_PROTENSET0_PROTREG29 = 0x20000000
	// Protection disabled.
	MPU_PROTENSET0_PROTREG29_Disabled = 0x0
	// Protection enabled.
	MPU_PROTENSET0_PROTREG29_Enabled = 0x1
	// Enable protection on write.
	MPU_PROTENSET0_PROTREG29_Set = 0x1
	// Position of PROTREG30 field.
	MPU_PROTENSET0_PROTREG30_Pos = 0x1e
	// Bit mask of PROTREG30 field.
	MPU_PROTENSET0_PROTREG30_Msk = 0x40000000
	// Bit PROTREG30.
	MPU_PROTENSET0_PROTREG30 = 0x40000000
	// Protection disabled.
	MPU_PROTENSET0_PROTREG30_Disabled = 0x0
	// Protection enabled.
	MPU_PROTENSET0_PROTREG30_Enabled = 0x1
	// Enable protection on write.
	MPU_PROTENSET0_PROTREG30_Set = 0x1
	// Position of PROTREG31 field.
	MPU_PROTENSET0_PROTREG31_Pos = 0x1f
	// Bit mask of PROTREG31 field.
	MPU_PROTENSET0_PROTREG31_Msk = 0x80000000
	// Bit PROTREG31.
	MPU_PROTENSET0_PROTREG31 = 0x80000000
	// Protection disabled.
	MPU_PROTENSET0_PROTREG31_Disabled = 0x0
	// Protection enabled.
	MPU_PROTENSET0_PROTREG31_Enabled = 0x1
	// Enable protection on write.
	MPU_PROTENSET0_PROTREG31_Set = 0x1

	// PROTENSET1: Erase and write protection bit enable set register.
	// Position of PROTREG32 field.
	MPU_PROTENSET1_PROTREG32_Pos = 0x0
	// Bit mask of PROTREG32 field.
	MPU_PROTENSET1_PROTREG32_Msk = 0x1
	// Bit PROTREG32.
	MPU_PROTENSET1_PROTREG32 = 0x1
	// Protection disabled.
	MPU_PROTENSET1_PROTREG32_Disabled = 0x0
	// Protection enabled.
	MPU_PROTENSET1_PROTREG32_Enabled = 0x1
	// Enable protection on write.
	MPU_PROTENSET1_PROTREG32_Set = 0x1
	// Position of PROTREG33 field.
	MPU_PROTENSET1_PROTREG33_Pos = 0x1
	// Bit mask of PROTREG33 field.
	MPU_PROTENSET1_PROTREG33_Msk = 0x2
	// Bit PROTREG33.
	MPU_PROTENSET1_PROTREG33 = 0x2
	// Protection disabled.
	MPU_PROTENSET1_PROTREG33_Disabled = 0x0
	// Protection enabled.
	MPU_PROTENSET1_PROTREG33_Enabled = 0x1
	// Enable protection on write.
	MPU_PROTENSET1_PROTREG33_Set = 0x1
	// Position of PROTREG34 field.
	MPU_PROTENSET1_PROTREG34_Pos = 0x2
	// Bit mask of PROTREG34 field.
	MPU_PROTENSET1_PROTREG34_Msk = 0x4
	// Bit PROTREG34.
	MPU_PROTENSET1_PROTREG34 = 0x4
	// Protection disabled.
	MPU_PROTENSET1_PROTREG34_Disabled = 0x0
	// Protection enabled.
	MPU_PROTENSET1_PROTREG34_Enabled = 0x1
	// Enable protection on write.
	MPU_PROTENSET1_PROTREG34_Set = 0x1
	// Position of PROTREG35 field.
	MPU_PROTENSET1_PROTREG35_Pos = 0x3
	// Bit mask of PROTREG35 field.
	MPU_PROTENSET1_PROTREG35_Msk = 0x8
	// Bit PROTREG35.
	MPU_PROTENSET1_PROTREG35 = 0x8
	// Protection disabled.
	MPU_PROTENSET1_PROTREG35_Disabled = 0x0
	// Protection enabled.
	MPU_PROTENSET1_PROTREG35_Enabled = 0x1
	// Enable protection on write.
	MPU_PROTENSET1_PROTREG35_Set = 0x1
	// Position of PROTREG36 field.
	MPU_PROTENSET1_PROTREG36_Pos = 0x4
	// Bit mask of PROTREG36 field.
	MPU_PROTENSET1_PROTREG36_Msk = 0x10
	// Bit PROTREG36.
	MPU_PROTENSET1_PROTREG36 = 0x10
	// Protection disabled.
	MPU_PROTENSET1_PROTREG36_Disabled = 0x0
	// Protection enabled.
	MPU_PROTENSET1_PROTREG36_Enabled = 0x1
	// Enable protection on write.
	MPU_PROTENSET1_PROTREG36_Set = 0x1
	// Position of PROTREG37 field.
	MPU_PROTENSET1_PROTREG37_Pos = 0x5
	// Bit mask of PROTREG37 field.
	MPU_PROTENSET1_PROTREG37_Msk = 0x20
	// Bit PROTREG37.
	MPU_PROTENSET1_PROTREG37 = 0x20
	// Protection disabled.
	MPU_PROTENSET1_PROTREG37_Disabled = 0x0
	// Protection enabled.
	MPU_PROTENSET1_PROTREG37_Enabled = 0x1
	// Enable protection on write.
	MPU_PROTENSET1_PROTREG37_Set = 0x1
	// Position of PROTREG38 field.
	MPU_PROTENSET1_PROTREG38_Pos = 0x6
	// Bit mask of PROTREG38 field.
	MPU_PROTENSET1_PROTREG38_Msk = 0x40
	// Bit PROTREG38.
	MPU_PROTENSET1_PROTREG38 = 0x40
	// Protection disabled.
	MPU_PROTENSET1_PROTREG38_Disabled = 0x0
	// Protection enabled.
	MPU_PROTENSET1_PROTREG38_Enabled = 0x1
	// Enable protection on write.
	MPU_PROTENSET1_PROTREG38_Set = 0x1
	// Position of PROTREG39 field.
	MPU_PROTENSET1_PROTREG39_Pos = 0x7
	// Bit mask of PROTREG39 field.
	MPU_PROTENSET1_PROTREG39_Msk = 0x80
	// Bit PROTREG39.
	MPU_PROTENSET1_PROTREG39 = 0x80
	// Protection disabled.
	MPU_PROTENSET1_PROTREG39_Disabled = 0x0
	// Protection enabled.
	MPU_PROTENSET1_PROTREG39_Enabled = 0x1
	// Enable protection on write.
	MPU_PROTENSET1_PROTREG39_Set = 0x1
	// Position of PROTREG40 field.
	MPU_PROTENSET1_PROTREG40_Pos = 0x8
	// Bit mask of PROTREG40 field.
	MPU_PROTENSET1_PROTREG40_Msk = 0x100
	// Bit PROTREG40.
	MPU_PROTENSET1_PROTREG40 = 0x100
	// Protection disabled.
	MPU_PROTENSET1_PROTREG40_Disabled = 0x0
	// Protection enabled.
	MPU_PROTENSET1_PROTREG40_Enabled = 0x1
	// Enable protection on write.
	MPU_PROTENSET1_PROTREG40_Set = 0x1
	// Position of PROTREG41 field.
	MPU_PROTENSET1_PROTREG41_Pos = 0x9
	// Bit mask of PROTREG41 field.
	MPU_PROTENSET1_PROTREG41_Msk = 0x200
	// Bit PROTREG41.
	MPU_PROTENSET1_PROTREG41 = 0x200
	// Protection disabled.
	MPU_PROTENSET1_PROTREG41_Disabled = 0x0
	// Protection enabled.
	MPU_PROTENSET1_PROTREG41_Enabled = 0x1
	// Enable protection on write.
	MPU_PROTENSET1_PROTREG41_Set = 0x1
	// Position of PROTREG42 field.
	MPU_PROTENSET1_PROTREG42_Pos = 0xa
	// Bit mask of PROTREG42 field.
	MPU_PROTENSET1_PROTREG42_Msk = 0x400
	// Bit PROTREG42.
	MPU_PROTENSET1_PROTREG42 = 0x400
	// Protection disabled.
	MPU_PROTENSET1_PROTREG42_Disabled = 0x0
	// Protection enabled.
	MPU_PROTENSET1_PROTREG42_Enabled = 0x1
	// Enable protection on write.
	MPU_PROTENSET1_PROTREG42_Set = 0x1
	// Position of PROTREG43 field.
	MPU_PROTENSET1_PROTREG43_Pos = 0xb
	// Bit mask of PROTREG43 field.
	MPU_PROTENSET1_PROTREG43_Msk = 0x800
	// Bit PROTREG43.
	MPU_PROTENSET1_PROTREG43 = 0x800
	// Protection disabled.
	MPU_PROTENSET1_PROTREG43_Disabled = 0x0
	// Protection enabled.
	MPU_PROTENSET1_PROTREG43_Enabled = 0x1
	// Enable protection on write.
	MPU_PROTENSET1_PROTREG43_Set = 0x1
	// Position of PROTREG44 field.
	MPU_PROTENSET1_PROTREG44_Pos = 0xc
	// Bit mask of PROTREG44 field.
	MPU_PROTENSET1_PROTREG44_Msk = 0x1000
	// Bit PROTREG44.
	MPU_PROTENSET1_PROTREG44 = 0x1000
	// Protection disabled.
	MPU_PROTENSET1_PROTREG44_Disabled = 0x0
	// Protection enabled.
	MPU_PROTENSET1_PROTREG44_Enabled = 0x1
	// Enable protection on write.
	MPU_PROTENSET1_PROTREG44_Set = 0x1
	// Position of PROTREG45 field.
	MPU_PROTENSET1_PROTREG45_Pos = 0xd
	// Bit mask of PROTREG45 field.
	MPU_PROTENSET1_PROTREG45_Msk = 0x2000
	// Bit PROTREG45.
	MPU_PROTENSET1_PROTREG45 = 0x2000
	// Protection disabled.
	MPU_PROTENSET1_PROTREG45_Disabled = 0x0
	// Protection enabled.
	MPU_PROTENSET1_PROTREG45_Enabled = 0x1
	// Enable protection on write.
	MPU_PROTENSET1_PROTREG45_Set = 0x1
	// Position of PROTREG46 field.
	MPU_PROTENSET1_PROTREG46_Pos = 0xe
	// Bit mask of PROTREG46 field.
	MPU_PROTENSET1_PROTREG46_Msk = 0x4000
	// Bit PROTREG46.
	MPU_PROTENSET1_PROTREG46 = 0x4000
	// Protection disabled.
	MPU_PROTENSET1_PROTREG46_Disabled = 0x0
	// Protection enabled.
	MPU_PROTENSET1_PROTREG46_Enabled = 0x1
	// Enable protection on write.
	MPU_PROTENSET1_PROTREG46_Set = 0x1
	// Position of PROTREG47 field.
	MPU_PROTENSET1_PROTREG47_Pos = 0xf
	// Bit mask of PROTREG47 field.
	MPU_PROTENSET1_PROTREG47_Msk = 0x8000
	// Bit PROTREG47.
	MPU_PROTENSET1_PROTREG47 = 0x8000
	// Protection disabled.
	MPU_PROTENSET1_PROTREG47_Disabled = 0x0
	// Protection enabled.
	MPU_PROTENSET1_PROTREG47_Enabled = 0x1
	// Enable protection on write.
	MPU_PROTENSET1_PROTREG47_Set = 0x1
	// Position of PROTREG48 field.
	MPU_PROTENSET1_PROTREG48_Pos = 0x10
	// Bit mask of PROTREG48 field.
	MPU_PROTENSET1_PROTREG48_Msk = 0x10000
	// Bit PROTREG48.
	MPU_PROTENSET1_PROTREG48 = 0x10000
	// Protection disabled.
	MPU_PROTENSET1_PROTREG48_Disabled = 0x0
	// Protection enabled.
	MPU_PROTENSET1_PROTREG48_Enabled = 0x1
	// Enable protection on write.
	MPU_PROTENSET1_PROTREG48_Set = 0x1
	// Position of PROTREG49 field.
	MPU_PROTENSET1_PROTREG49_Pos = 0x11
	// Bit mask of PROTREG49 field.
	MPU_PROTENSET1_PROTREG49_Msk = 0x20000
	// Bit PROTREG49.
	MPU_PROTENSET1_PROTREG49 = 0x20000
	// Protection disabled.
	MPU_PROTENSET1_PROTREG49_Disabled = 0x0
	// Protection enabled.
	MPU_PROTENSET1_PROTREG49_Enabled = 0x1
	// Enable protection on write.
	MPU_PROTENSET1_PROTREG49_Set = 0x1
	// Position of PROTREG50 field.
	MPU_PROTENSET1_PROTREG50_Pos = 0x12
	// Bit mask of PROTREG50 field.
	MPU_PROTENSET1_PROTREG50_Msk = 0x40000
	// Bit PROTREG50.
	MPU_PROTENSET1_PROTREG50 = 0x40000
	// Protection disabled.
	MPU_PROTENSET1_PROTREG50_Disabled = 0x0
	// Protection enabled.
	MPU_PROTENSET1_PROTREG50_Enabled = 0x1
	// Enable protection on write.
	MPU_PROTENSET1_PROTREG50_Set = 0x1
	// Position of PROTREG51 field.
	MPU_PROTENSET1_PROTREG51_Pos = 0x13
	// Bit mask of PROTREG51 field.
	MPU_PROTENSET1_PROTREG51_Msk = 0x80000
	// Bit PROTREG51.
	MPU_PROTENSET1_PROTREG51 = 0x80000
	// Protection disabled.
	MPU_PROTENSET1_PROTREG51_Disabled = 0x0
	// Protection enabled.
	MPU_PROTENSET1_PROTREG51_Enabled = 0x1
	// Enable protection on write.
	MPU_PROTENSET1_PROTREG51_Set = 0x1
	// Position of PROTREG52 field.
	MPU_PROTENSET1_PROTREG52_Pos = 0x14
	// Bit mask of PROTREG52 field.
	MPU_PROTENSET1_PROTREG52_Msk = 0x100000
	// Bit PROTREG52.
	MPU_PROTENSET1_PROTREG52 = 0x100000
	// Protection disabled.
	MPU_PROTENSET1_PROTREG52_Disabled = 0x0
	// Protection enabled.
	MPU_PROTENSET1_PROTREG52_Enabled = 0x1
	// Enable protection on write.
	MPU_PROTENSET1_PROTREG52_Set = 0x1
	// Position of PROTREG53 field.
	MPU_PROTENSET1_PROTREG53_Pos = 0x15
	// Bit mask of PROTREG53 field.
	MPU_PROTENSET1_PROTREG53_Msk = 0x200000
	// Bit PROTREG53.
	MPU_PROTENSET1_PROTREG53 = 0x200000
	// Protection disabled.
	MPU_PROTENSET1_PROTREG53_Disabled = 0x0
	// Protection enabled.
	MPU_PROTENSET1_PROTREG53_Enabled = 0x1
	// Enable protection on write.
	MPU_PROTENSET1_PROTREG53_Set = 0x1
	// Position of PROTREG54 field.
	MPU_PROTENSET1_PROTREG54_Pos = 0x16
	// Bit mask of PROTREG54 field.
	MPU_PROTENSET1_PROTREG54_Msk = 0x400000
	// Bit PROTREG54.
	MPU_PROTENSET1_PROTREG54 = 0x400000
	// Protection disabled.
	MPU_PROTENSET1_PROTREG54_Disabled = 0x0
	// Protection enabled.
	MPU_PROTENSET1_PROTREG54_Enabled = 0x1
	// Enable protection on write.
	MPU_PROTENSET1_PROTREG54_Set = 0x1
	// Position of PROTREG55 field.
	MPU_PROTENSET1_PROTREG55_Pos = 0x17
	// Bit mask of PROTREG55 field.
	MPU_PROTENSET1_PROTREG55_Msk = 0x800000
	// Bit PROTREG55.
	MPU_PROTENSET1_PROTREG55 = 0x800000
	// Protection disabled.
	MPU_PROTENSET1_PROTREG55_Disabled = 0x0
	// Protection enabled.
	MPU_PROTENSET1_PROTREG55_Enabled = 0x1
	// Enable protection on write.
	MPU_PROTENSET1_PROTREG55_Set = 0x1
	// Position of PROTREG56 field.
	MPU_PROTENSET1_PROTREG56_Pos = 0x18
	// Bit mask of PROTREG56 field.
	MPU_PROTENSET1_PROTREG56_Msk = 0x1000000
	// Bit PROTREG56.
	MPU_PROTENSET1_PROTREG56 = 0x1000000
	// Protection disabled.
	MPU_PROTENSET1_PROTREG56_Disabled = 0x0
	// Protection enabled.
	MPU_PROTENSET1_PROTREG56_Enabled = 0x1
	// Enable protection on write.
	MPU_PROTENSET1_PROTREG56_Set = 0x1
	// Position of PROTREG57 field.
	MPU_PROTENSET1_PROTREG57_Pos = 0x19
	// Bit mask of PROTREG57 field.
	MPU_PROTENSET1_PROTREG57_Msk = 0x2000000
	// Bit PROTREG57.
	MPU_PROTENSET1_PROTREG57 = 0x2000000
	// Protection disabled.
	MPU_PROTENSET1_PROTREG57_Disabled = 0x0
	// Protection enabled.
	MPU_PROTENSET1_PROTREG57_Enabled = 0x1
	// Enable protection on write.
	MPU_PROTENSET1_PROTREG57_Set = 0x1
	// Position of PROTREG58 field.
	MPU_PROTENSET1_PROTREG58_Pos = 0x1a
	// Bit mask of PROTREG58 field.
	MPU_PROTENSET1_PROTREG58_Msk = 0x4000000
	// Bit PROTREG58.
	MPU_PROTENSET1_PROTREG58 = 0x4000000
	// Protection disabled.
	MPU_PROTENSET1_PROTREG58_Disabled = 0x0
	// Protection enabled.
	MPU_PROTENSET1_PROTREG58_Enabled = 0x1
	// Enable protection on write.
	MPU_PROTENSET1_PROTREG58_Set = 0x1
	// Position of PROTREG59 field.
	MPU_PROTENSET1_PROTREG59_Pos = 0x1b
	// Bit mask of PROTREG59 field.
	MPU_PROTENSET1_PROTREG59_Msk = 0x8000000
	// Bit PROTREG59.
	MPU_PROTENSET1_PROTREG59 = 0x8000000
	// Protection disabled.
	MPU_PROTENSET1_PROTREG59_Disabled = 0x0
	// Protection enabled.
	MPU_PROTENSET1_PROTREG59_Enabled = 0x1
	// Enable protection on write.
	MPU_PROTENSET1_PROTREG59_Set = 0x1
	// Position of PROTREG60 field.
	MPU_PROTENSET1_PROTREG60_Pos = 0x1c
	// Bit mask of PROTREG60 field.
	MPU_PROTENSET1_PROTREG60_Msk = 0x10000000
	// Bit PROTREG60.
	MPU_PROTENSET1_PROTREG60 = 0x10000000
	// Protection disabled.
	MPU_PROTENSET1_PROTREG60_Disabled = 0x0
	// Protection enabled.
	MPU_PROTENSET1_PROTREG60_Enabled = 0x1
	// Enable protection on write.
	MPU_PROTENSET1_PROTREG60_Set = 0x1
	// Position of PROTREG61 field.
	MPU_PROTENSET1_PROTREG61_Pos = 0x1d
	// Bit mask of PROTREG61 field.
	MPU_PROTENSET1_PROTREG61_Msk = 0x20000000
	// Bit PROTREG61.
	MPU_PROTENSET1_PROTREG61 = 0x20000000
	// Protection disabled.
	MPU_PROTENSET1_PROTREG61_Disabled = 0x0
	// Protection enabled.
	MPU_PROTENSET1_PROTREG61_Enabled = 0x1
	// Enable protection on write.
	MPU_PROTENSET1_PROTREG61_Set = 0x1
	// Position of PROTREG62 field.
	MPU_PROTENSET1_PROTREG62_Pos = 0x1e
	// Bit mask of PROTREG62 field.
	MPU_PROTENSET1_PROTREG62_Msk = 0x40000000
	// Bit PROTREG62.
	MPU_PROTENSET1_PROTREG62 = 0x40000000
	// Protection disabled.
	MPU_PROTENSET1_PROTREG62_Disabled = 0x0
	// Protection enabled.
	MPU_PROTENSET1_PROTREG62_Enabled = 0x1
	// Enable protection on write.
	MPU_PROTENSET1_PROTREG62_Set = 0x1
	// Position of PROTREG63 field.
	MPU_PROTENSET1_PROTREG63_Pos = 0x1f
	// Bit mask of PROTREG63 field.
	MPU_PROTENSET1_PROTREG63_Msk = 0x80000000
	// Bit PROTREG63.
	MPU_PROTENSET1_PROTREG63 = 0x80000000
	// Protection disabled.
	MPU_PROTENSET1_PROTREG63_Disabled = 0x0
	// Protection enabled.
	MPU_PROTENSET1_PROTREG63_Enabled = 0x1
	// Enable protection on write.
	MPU_PROTENSET1_PROTREG63_Set = 0x1

	// DISABLEINDEBUG: Disable erase and write protection mechanism in debug mode.
	// Position of DISABLEINDEBUG field.
	MPU_DISABLEINDEBUG_DISABLEINDEBUG_Pos = 0x0
	// Bit mask of DISABLEINDEBUG field.
	MPU_DISABLEINDEBUG_DISABLEINDEBUG_Msk = 0x1
	// Bit DISABLEINDEBUG.
	MPU_DISABLEINDEBUG_DISABLEINDEBUG = 0x1
	// Protection enabled.
	MPU_DISABLEINDEBUG_DISABLEINDEBUG_Enabled = 0x0
	// Protection disabled.
	MPU_DISABLEINDEBUG_DISABLEINDEBUG_Disabled = 0x1

	// PROTBLOCKSIZE: Erase and write protection block size.
	// Position of PROTBLOCKSIZE field.
	MPU_PROTBLOCKSIZE_PROTBLOCKSIZE_Pos = 0x0
	// Bit mask of PROTBLOCKSIZE field.
	MPU_PROTBLOCKSIZE_PROTBLOCKSIZE_Msk = 0x3
	// Erase and write protection block size is 4k.
	MPU_PROTBLOCKSIZE_PROTBLOCKSIZE_4k = 0x0
)

// Bitfields for RADIO: The radio.
const (
	// SHORTS: Shortcuts for the radio.
	// Position of READY_START field.
	RADIO_SHORTS_READY_START_Pos = 0x0
	// Bit mask of READY_START field.
	RADIO_SHORTS_READY_START_Msk = 0x1
	// Bit READY_START.
	RADIO_SHORTS_READY_START = 0x1
	// Shortcut disabled.
	RADIO_SHORTS_READY_START_Disabled = 0x0
	// Shortcut enabled.
	RADIO_SHORTS_READY_START_Enabled = 0x1
	// Position of END_DISABLE field.
	RADIO_SHORTS_END_DISABLE_Pos = 0x1
	// Bit mask of END_DISABLE field.
	RADIO_SHORTS_END_DISABLE_Msk = 0x2
	// Bit END_DISABLE.
	RADIO_SHORTS_END_DISABLE = 0x2
	// Shortcut disabled.
	RADIO_SHORTS_END_DISABLE_Disabled = 0x0
	// Shortcut enabled.
	RADIO_SHORTS_END_DISABLE_Enabled = 0x1
	// Position of DISABLED_TXEN field.
	RADIO_SHORTS_DISABLED_TXEN_Pos = 0x2
	// Bit mask of DISABLED_TXEN field.
	RADIO_SHORTS_DISABLED_TXEN_Msk = 0x4
	// Bit DISABLED_TXEN.
	RADIO_SHORTS_DISABLED_TXEN = 0x4
	// Shortcut disabled.
	RADIO_SHORTS_DISABLED_TXEN_Disabled = 0x0
	// Shortcut enabled.
	RADIO_SHORTS_DISABLED_TXEN_Enabled = 0x1
	// Position of DISABLED_RXEN field.
	RADIO_SHORTS_DISABLED_RXEN_Pos = 0x3
	// Bit mask of DISABLED_RXEN field.
	RADIO_SHORTS_DISABLED_RXEN_Msk = 0x8
	// Bit DISABLED_RXEN.
	RADIO_SHORTS_DISABLED_RXEN = 0x8
	// Shortcut disabled.
	RADIO_SHORTS_DISABLED_RXEN_Disabled = 0x0
	// Shortcut enabled.
	RADIO_SHORTS_DISABLED_RXEN_Enabled = 0x1
	// Position of ADDRESS_RSSISTART field.
	RADIO_SHORTS_ADDRESS_RSSISTART_Pos = 0x4
	// Bit mask of ADDRESS_RSSISTART field.
	RADIO_SHORTS_ADDRESS_RSSISTART_Msk = 0x10
	// Bit ADDRESS_RSSISTART.
	RADIO_SHORTS_ADDRESS_RSSISTART = 0x10
	// Shortcut disabled.
	RADIO_SHORTS_ADDRESS_RSSISTART_Disabled = 0x0
	// Shortcut enabled.
	RADIO_SHORTS_ADDRESS_RSSISTART_Enabled = 0x1
	// Position of END_START field.
	RADIO_SHORTS_END_START_Pos = 0x5
	// Bit mask of END_START field.
	RADIO_SHORTS_END_START_Msk = 0x20
	// Bit END_START.
	RADIO_SHORTS_END_START = 0x20
	// Shortcut disabled.
	RADIO_SHORTS_END_START_Disabled = 0x0
	// Shortcut enabled.
	RADIO_SHORTS_END_START_Enabled = 0x1
	// Position of ADDRESS_BCSTART field.
	RADIO_SHORTS_ADDRESS_BCSTART_Pos = 0x6
	// Bit mask of ADDRESS_BCSTART field.
	RADIO_SHORTS_ADDRESS_BCSTART_Msk = 0x40
	// Bit ADDRESS_BCSTART.
	RADIO_SHORTS_ADDRESS_BCSTART = 0x40
	// Shortcut disabled.
	RADIO_SHORTS_ADDRESS_BCSTART_Disabled = 0x0
	// Shortcut enabled.
	RADIO_SHORTS_ADDRESS_BCSTART_Enabled = 0x1
	// Position of DISABLED_RSSISTOP field.
	RADIO_SHORTS_DISABLED_RSSISTOP_Pos = 0x8
	// Bit mask of DISABLED_RSSISTOP field.
	RADIO_SHORTS_DISABLED_RSSISTOP_Msk = 0x100
	// Bit DISABLED_RSSISTOP.
	RADIO_SHORTS_DISABLED_RSSISTOP = 0x100
	// Shortcut disabled.
	RADIO_SHORTS_DISABLED_RSSISTOP_Disabled = 0x0
	// Shortcut enabled.
	RADIO_SHORTS_DISABLED_RSSISTOP_Enabled = 0x1

	// INTENSET: Interrupt enable set register.
	// Position of READY field.
	RADIO_INTENSET_READY_Pos = 0x0
	// Bit mask of READY field.
	RADIO_INTENSET_READY_Msk = 0x1
	// Bit READY.
	RADIO_INTENSET_READY = 0x1
	// Interrupt disabled.
	RADIO_INTENSET_READY_Disabled = 0x0
	// Interrupt enabled.
	RADIO_INTENSET_READY_Enabled = 0x1
	// Enable interrupt on write.
	RADIO_INTENSET_READY_Set = 0x1
	// Position of ADDRESS field.
	RADIO_INTENSET_ADDRESS_Pos = 0x1
	// Bit mask of ADDRESS field.
	RADIO_INTENSET_ADDRESS_Msk = 0x2
	// Bit ADDRESS.
	RADIO_INTENSET_ADDRESS = 0x2
	// Interrupt disabled.
	RADIO_INTENSET_ADDRESS_Disabled = 0x0
	// Interrupt enabled.
	RADIO_INTENSET_ADDRESS_Enabled = 0x1
	// Enable interrupt on write.
	RADIO_INTENSET_ADDRESS_Set = 0x1
	// Position of PAYLOAD field.
	RADIO_INTENSET_PAYLOAD_Pos = 0x2
	// Bit mask of PAYLOAD field.
	RADIO_INTENSET_PAYLOAD_Msk = 0x4
	// Bit PAYLOAD.
	RADIO_INTENSET_PAYLOAD = 0x4
	// Interrupt disabled.
	RADIO_INTENSET_PAYLOAD_Disabled = 0x0
	// Interrupt enabled.
	RADIO_INTENSET_PAYLOAD_Enabled = 0x1
	// Enable interrupt on write.
	RADIO_INTENSET_PAYLOAD_Set = 0x1
	// Position of END field.
	RADIO_INTENSET_END_Pos = 0x3
	// Bit mask of END field.
	RADIO_INTENSET_END_Msk = 0x8
	// Bit END.
	RADIO_INTENSET_END = 0x8
	// Interrupt disabled.
	RADIO_INTENSET_END_Disabled = 0x0
	// Interrupt enabled.
	RADIO_INTENSET_END_Enabled = 0x1
	// Enable interrupt on write.
	RADIO_INTENSET_END_Set = 0x1
	// Position of DISABLED field.
	RADIO_INTENSET_DISABLED_Pos = 0x4
	// Bit mask of DISABLED field.
	RADIO_INTENSET_DISABLED_Msk = 0x10
	// Bit DISABLED.
	RADIO_INTENSET_DISABLED = 0x10
	// Interrupt disabled.
	RADIO_INTENSET_DISABLED_Disabled = 0x0
	// Interrupt enabled.
	RADIO_INTENSET_DISABLED_Enabled = 0x1
	// Enable interrupt on write.
	RADIO_INTENSET_DISABLED_Set = 0x1
	// Position of DEVMATCH field.
	RADIO_INTENSET_DEVMATCH_Pos = 0x5
	// Bit mask of DEVMATCH field.
	RADIO_INTENSET_DEVMATCH_Msk = 0x20
	// Bit DEVMATCH.
	RADIO_INTENSET_DEVMATCH = 0x20
	// Interrupt disabled.
	RADIO_INTENSET_DEVMATCH_Disabled = 0x0
	// Interrupt enabled.
	RADIO_INTENSET_DEVMATCH_Enabled = 0x1
	// Enable interrupt on write.
	RADIO_INTENSET_DEVMATCH_Set = 0x1
	// Position of DEVMISS field.
	RADIO_INTENSET_DEVMISS_Pos = 0x6
	// Bit mask of DEVMISS field.
	RADIO_INTENSET_DEVMISS_Msk = 0x40
	// Bit DEVMISS.
	RADIO_INTENSET_DEVMISS = 0x40
	// Interrupt disabled.
	RADIO_INTENSET_DEVMISS_Disabled = 0x0
	// Interrupt enabled.
	RADIO_INTENSET_DEVMISS_Enabled = 0x1
	// Enable interrupt on write.
	RADIO_INTENSET_DEVMISS_Set = 0x1
	// Position of RSSIEND field.
	RADIO_INTENSET_RSSIEND_Pos = 0x7
	// Bit mask of RSSIEND field.
	RADIO_INTENSET_RSSIEND_Msk = 0x80
	// Bit RSSIEND.
	RADIO_INTENSET_RSSIEND = 0x80
	// Interrupt disabled.
	RADIO_INTENSET_RSSIEND_Disabled = 0x0
	// Interrupt enabled.
	RADIO_INTENSET_RSSIEND_Enabled = 0x1
	// Enable interrupt on write.
	RADIO_INTENSET_RSSIEND_Set = 0x1
	// Position of BCMATCH field.
	RADIO_INTENSET_BCMATCH_Pos = 0xa
	// Bit mask of BCMATCH field.
	RADIO_INTENSET_BCMATCH_Msk = 0x400
	// Bit BCMATCH.
	RADIO_INTENSET_BCMATCH = 0x400
	// Interrupt disabled.
	RADIO_INTENSET_BCMATCH_Disabled = 0x0
	// Interrupt enabled.
	RADIO_INTENSET_BCMATCH_Enabled = 0x1
	// Enable interrupt on write.
	RADIO_INTENSET_BCMATCH_Set = 0x1

	// INTENCLR: Interrupt enable clear register.
	// Position of READY field.
	RADIO_INTENCLR_READY_Pos = 0x0
	// Bit mask of READY field.
	RADIO_INTENCLR_READY_Msk = 0x1
	// Bit READY.
	RADIO_INTENCLR_READY = 0x1
	// Interrupt disabled.
	RADIO_INTENCLR_READY_Disabled = 0x0
	// Interrupt enabled.
	RADIO_INTENCLR_READY_Enabled = 0x1
	// Disable interrupt on write.
	RADIO_INTENCLR_READY_Clear = 0x1
	// Position of ADDRESS field.
	RADIO_INTENCLR_ADDRESS_Pos = 0x1
	// Bit mask of ADDRESS field.
	RADIO_INTENCLR_ADDRESS_Msk = 0x2
	// Bit ADDRESS.
	RADIO_INTENCLR_ADDRESS = 0x2
	// Interrupt disabled.
	RADIO_INTENCLR_ADDRESS_Disabled = 0x0
	// Interrupt enabled.
	RADIO_INTENCLR_ADDRESS_Enabled = 0x1
	// Disable interrupt on write.
	RADIO_INTENCLR_ADDRESS_Clear = 0x1
	// Position of PAYLOAD field.
	RADIO_INTENCLR_PAYLOAD_Pos = 0x2
	// Bit mask of PAYLOAD field.
	RADIO_INTENCLR_PAYLOAD_Msk = 0x4
	// Bit PAYLOAD.
	RADIO_INTENCLR_PAYLOAD = 0x4
	// Interrupt disabled.
	RADIO_INTENCLR_PAYLOAD_Disabled = 0x0
	// Interrupt enabled.
	RADIO_INTENCLR_PAYLOAD_Enabled = 0x1
	// Disable interrupt on write.
	RADIO_INTENCLR_PAYLOAD_Clear = 0x1
	// Position of END field.
	RADIO_INTENCLR_END_Pos = 0x3
	// Bit mask of END field.
	RADIO_INTENCLR_END_Msk = 0x8
	// Bit END.
	RADIO_INTENCLR_END = 0x8
	// Interrupt disabled.
	RADIO_INTENCLR_END_Disabled = 0x0
	// Interrupt enabled.
	RADIO_INTENCLR_END_Enabled = 0x1
	// Disable interrupt on write.
	RADIO_INTENCLR_END_Clear = 0x1
	// Position of DISABLED field.
	RADIO_INTENCLR_DISABLED_Pos = 0x4
	// Bit mask of DISABLED field.
	RADIO_INTENCLR_DISABLED_Msk = 0x10
	// Bit DISABLED.
	RADIO_INTENCLR_DISABLED = 0x10
	// Interrupt disabled.
	RADIO_INTENCLR_DISABLED_Disabled = 0x0
	// Interrupt enabled.
	RADIO_INTENCLR_DISABLED_Enabled = 0x1
	// Disable interrupt on write.
	RADIO_INTENCLR_DISABLED_Clear = 0x1
	// Position of DEVMATCH field.
	RADIO_INTENCLR_DEVMATCH_Pos = 0x5
	// Bit mask of DEVMATCH field.
	RADIO_INTENCLR_DEVMATCH_Msk = 0x20
	// Bit DEVMATCH.
	RADIO_INTENCLR_DEVMATCH = 0x20
	// Interrupt disabled.
	RADIO_INTENCLR_DEVMATCH_Disabled = 0x0
	// Interrupt enabled.
	RADIO_INTENCLR_DEVMATCH_Enabled = 0x1
	// Disable interrupt on write.
	RADIO_INTENCLR_DEVMATCH_Clear = 0x1
	// Position of DEVMISS field.
	RADIO_INTENCLR_DEVMISS_Pos = 0x6
	// Bit mask of DEVMISS field.
	RADIO_INTENCLR_DEVMISS_Msk = 0x40
	// Bit DEVMISS.
	RADIO_INTENCLR_DEVMISS = 0x40
	// Interrupt disabled.
	RADIO_INTENCLR_DEVMISS_Disabled = 0x0
	// Interrupt enabled.
	RADIO_INTENCLR_DEVMISS_Enabled = 0x1
	// Disable interrupt on write.
	RADIO_INTENCLR_DEVMISS_Clear = 0x1
	// Position of RSSIEND field.
	RADIO_INTENCLR_RSSIEND_Pos = 0x7
	// Bit mask of RSSIEND field.
	RADIO_INTENCLR_RSSIEND_Msk = 0x80
	// Bit RSSIEND.
	RADIO_INTENCLR_RSSIEND = 0x80
	// Interrupt disabled.
	RADIO_INTENCLR_RSSIEND_Disabled = 0x0
	// Interrupt enabled.
	RADIO_INTENCLR_RSSIEND_Enabled = 0x1
	// Disable interrupt on write.
	RADIO_INTENCLR_RSSIEND_Clear = 0x1
	// Position of BCMATCH field.
	RADIO_INTENCLR_BCMATCH_Pos = 0xa
	// Bit mask of BCMATCH field.
	RADIO_INTENCLR_BCMATCH_Msk = 0x400
	// Bit BCMATCH.
	RADIO_INTENCLR_BCMATCH = 0x400
	// Interrupt disabled.
	RADIO_INTENCLR_BCMATCH_Disabled = 0x0
	// Interrupt enabled.
	RADIO_INTENCLR_BCMATCH_Enabled = 0x1
	// Disable interrupt on write.
	RADIO_INTENCLR_BCMATCH_Clear = 0x1

	// CRCSTATUS: CRC status of received packet.
	// Position of CRCSTATUS field.
	RADIO_CRCSTATUS_CRCSTATUS_Pos = 0x0
	// Bit mask of CRCSTATUS field.
	RADIO_CRCSTATUS_CRCSTATUS_Msk = 0x1
	// Bit CRCSTATUS.
	RADIO_CRCSTATUS_CRCSTATUS = 0x1
	// Packet received with CRC error.
	RADIO_CRCSTATUS_CRCSTATUS_CRCError = 0x0
	// Packet received with CRC ok.
	RADIO_CRCSTATUS_CRCSTATUS_CRCOk = 0x1

	// RXMATCH: Received address.
	// Position of RXMATCH field.
	RADIO_RXMATCH_RXMATCH_Pos = 0x0
	// Bit mask of RXMATCH field.
	RADIO_RXMATCH_RXMATCH_Msk = 0x7

	// RXCRC: Received CRC.
	// Position of RXCRC field.
	RADIO_RXCRC_RXCRC_Pos = 0x0
	// Bit mask of RXCRC field.
	RADIO_RXCRC_RXCRC_Msk = 0xffffff

	// DAI: Device address match index.
	// Position of DAI field.
	RADIO_DAI_DAI_Pos = 0x0
	// Bit mask of DAI field.
	RADIO_DAI_DAI_Msk = 0x7

	// FREQUENCY: Frequency.
	// Position of FREQUENCY field.
	RADIO_FREQUENCY_FREQUENCY_Pos = 0x0
	// Bit mask of FREQUENCY field.
	RADIO_FREQUENCY_FREQUENCY_Msk = 0x7f

	// TXPOWER: Output power.
	// Position of TXPOWER field.
	RADIO_TXPOWER_TXPOWER_Pos = 0x0
	// Bit mask of TXPOWER field.
	RADIO_TXPOWER_TXPOWER_Msk = 0xff
	// +4dBm.
	RADIO_TXPOWER_TXPOWER_Pos4dBm = 0x4
	// 0dBm.
	RADIO_TXPOWER_TXPOWER_0dBm = 0x0
	// -4dBm.
	RADIO_TXPOWER_TXPOWER_Neg4dBm = 0xfc
	// -8dBm.
	RADIO_TXPOWER_TXPOWER_Neg8dBm = 0xf8
	// -12dBm.
	RADIO_TXPOWER_TXPOWER_Neg12dBm = 0xf4
	// -16dBm.
	RADIO_TXPOWER_TXPOWER_Neg16dBm = 0xf0
	// -20dBm.
	RADIO_TXPOWER_TXPOWER_Neg20dBm = 0xec
	// -30dBm.
	RADIO_TXPOWER_TXPOWER_Neg30dBm = 0xd8

	// MODE: Data rate and modulation.
	// Position of MODE field.
	RADIO_MODE_MODE_Pos = 0x0
	// Bit mask of MODE field.
	RADIO_MODE_MODE_Msk = 0x3
	// 1Mbit/s Nordic propietary radio mode.
	RADIO_MODE_MODE_Nrf_1Mbit = 0x0
	// 2Mbit/s Nordic propietary radio mode.
	RADIO_MODE_MODE_Nrf_2Mbit = 0x1
	// 250kbit/s Nordic propietary radio mode.
	RADIO_MODE_MODE_Nrf_250Kbit = 0x2
	// 1Mbit/s Bluetooth Low Energy
	RADIO_MODE_MODE_Ble_1Mbit = 0x3

	// PCNF0: Packet configuration 0.
	// Position of LFLEN field.
	RADIO_PCNF0_LFLEN_Pos = 0x0
	// Bit mask of LFLEN field.
	RADIO_PCNF0_LFLEN_Msk = 0xf
	// Position of S0LEN field.
	RADIO_PCNF0_S0LEN_Pos = 0x8
	// Bit mask of S0LEN field.
	RADIO_PCNF0_S0LEN_Msk = 0x100
	// Bit S0LEN.
	RADIO_PCNF0_S0LEN = 0x100
	// Position of S1LEN field.
	RADIO_PCNF0_S1LEN_Pos = 0x10
	// Bit mask of S1LEN field.
	RADIO_PCNF0_S1LEN_Msk = 0xf0000

	// PCNF1: Packet configuration 1.
	// Position of MAXLEN field.
	RADIO_PCNF1_MAXLEN_Pos = 0x0
	// Bit mask of MAXLEN field.
	RADIO_PCNF1_MAXLEN_Msk = 0xff
	// Position of STATLEN field.
	RADIO_PCNF1_STATLEN_Pos = 0x8
	// Bit mask of STATLEN field.
	RADIO_PCNF1_STATLEN_Msk = 0xff00
	// Position of BALEN field.
	RADIO_PCNF1_BALEN_Pos = 0x10
	// Bit mask of BALEN field.
	RADIO_PCNF1_BALEN_Msk = 0x70000
	// Position of ENDIAN field.
	RADIO_PCNF1_ENDIAN_Pos = 0x18
	// Bit mask of ENDIAN field.
	RADIO_PCNF1_ENDIAN_Msk = 0x1000000
	// Bit ENDIAN.
	RADIO_PCNF1_ENDIAN = 0x1000000
	// Least significant bit on air first
	RADIO_PCNF1_ENDIAN_Little = 0x0
	// Most significant bit on air first
	RADIO_PCNF1_ENDIAN_Big = 0x1
	// Position of WHITEEN field.
	RADIO_PCNF1_WHITEEN_Pos = 0x19
	// Bit mask of WHITEEN field.
	RADIO_PCNF1_WHITEEN_Msk = 0x2000000
	// Bit WHITEEN.
	RADIO_PCNF1_WHITEEN = 0x2000000
	// Whitening disabled.
	RADIO_PCNF1_WHITEEN_Disabled = 0x0
	// Whitening enabled.
	RADIO_PCNF1_WHITEEN_Enabled = 0x1

	// PREFIX0: Prefixes bytes for logical addresses 0 to 3.
	// Position of AP0 field.
	RADIO_PREFIX0_AP0_Pos = 0x0
	// Bit mask of AP0 field.
	RADIO_PREFIX0_AP0_Msk = 0xff
	// Position of AP1 field.
	RADIO_PREFIX0_AP1_Pos = 0x8
	// Bit mask of AP1 field.
	RADIO_PREFIX0_AP1_Msk = 0xff00
	// Position of AP2 field.
	RADIO_PREFIX0_AP2_Pos = 0x10
	// Bit mask of AP2 field.
	RADIO_PREFIX0_AP2_Msk = 0xff0000
	// Position of AP3 field.
	RADIO_PREFIX0_AP3_Pos = 0x18
	// Bit mask of AP3 field.
	RADIO_PREFIX0_AP3_Msk = 0xff000000

	// PREFIX1: Prefixes bytes for logical addresses 4 to 7.
	// Position of AP4 field.
	RADIO_PREFIX1_AP4_Pos = 0x0
	// Bit mask of AP4 field.
	RADIO_PREFIX1_AP4_Msk = 0xff
	// Position of AP5 field.
	RADIO_PREFIX1_AP5_Pos = 0x8
	// Bit mask of AP5 field.
	RADIO_PREFIX1_AP5_Msk = 0xff00
	// Position of AP6 field.
	RADIO_PREFIX1_AP6_Pos = 0x10
	// Bit mask of AP6 field.
	RADIO_PREFIX1_AP6_Msk = 0xff0000
	// Position of AP7 field.
	RADIO_PREFIX1_AP7_Pos = 0x18
	// Bit mask of AP7 field.
	RADIO_PREFIX1_AP7_Msk = 0xff000000

	// TXADDRESS: Transmit address select.
	// Position of TXADDRESS field.
	RADIO_TXADDRESS_TXADDRESS_Pos = 0x0
	// Bit mask of TXADDRESS field.
	RADIO_TXADDRESS_TXADDRESS_Msk = 0x7

	// RXADDRESSES: Receive address select.
	// Position of ADDR0 field.
	RADIO_RXADDRESSES_ADDR0_Pos = 0x0
	// Bit mask of ADDR0 field.
	RADIO_RXADDRESSES_ADDR0_Msk = 0x1
	// Bit ADDR0.
	RADIO_RXADDRESSES_ADDR0 = 0x1
	// Reception disabled.
	RADIO_RXADDRESSES_ADDR0_Disabled = 0x0
	// Reception enabled.
	RADIO_RXADDRESSES_ADDR0_Enabled = 0x1
	// Position of ADDR1 field.
	RADIO_RXADDRESSES_ADDR1_Pos = 0x1
	// Bit mask of ADDR1 field.
	RADIO_RXADDRESSES_ADDR1_Msk = 0x2
	// Bit ADDR1.
	RADIO_RXADDRESSES_ADDR1 = 0x2
	// Reception disabled.
	RADIO_RXADDRESSES_ADDR1_Disabled = 0x0
	// Reception enabled.
	RADIO_RXADDRESSES_ADDR1_Enabled = 0x1
	// Position of ADDR2 field.
	RADIO_RXADDRESSES_ADDR2_Pos = 0x2
	// Bit mask of ADDR2 field.
	RADIO_RXADDRESSES_ADDR2_Msk = 0x4
	// Bit ADDR2.
	RADIO_RXADDRESSES_ADDR2 = 0x4
	// Reception disabled.
	RADIO_RXADDRESSES_ADDR2_Disabled = 0x0
	// Reception enabled.
	RADIO_RXADDRESSES_ADDR2_Enabled = 0x1
	// Position of ADDR3 field.
	RADIO_RXADDRESSES_ADDR3_Pos = 0x3
	// Bit mask of ADDR3 field.
	RADIO_RXADDRESSES_ADDR3_Msk = 0x8
	// Bit ADDR3.
	RADIO_RXADDRESSES_ADDR3 = 0x8
	// Reception disabled.
	RADIO_RXADDRESSES_ADDR3_Disabled = 0x0
	// Reception enabled.
	RADIO_RXADDRESSES_ADDR3_Enabled = 0x1
	// Position of ADDR4 field.
	RADIO_RXADDRESSES_ADDR4_Pos = 0x4
	// Bit mask of ADDR4 field.
	RADIO_RXADDRESSES_ADDR4_Msk = 0x10
	// Bit ADDR4.
	RADIO_RXADDRESSES_ADDR4 = 0x10
	// Reception disabled.
	RADIO_RXADDRESSES_ADDR4_Disabled = 0x0
	// Reception enabled.
	RADIO_RXADDRESSES_ADDR4_Enabled = 0x1
	// Position of ADDR5 field.
	RADIO_RXADDRESSES_ADDR5_Pos = 0x5
	// Bit mask of ADDR5 field.
	RADIO_RXADDRESSES_ADDR5_Msk = 0x20
	// Bit ADDR5.
	RADIO_RXADDRESSES_ADDR5 = 0x20
	// Reception disabled.
	RADIO_RXADDRESSES_ADDR5_Disabled = 0x0
	// Reception enabled.
	RADIO_RXADDRESSES_ADDR5_Enabled = 0x1
	// Position of ADDR6 field.
	RADIO_RXADDRESSES_ADDR6_Pos = 0x6
	// Bit mask of ADDR6 field.
	RADIO_RXADDRESSES_ADDR6_Msk = 0x40
	// Bit ADDR6.
	RADIO_RXADDRESSES_ADDR6 = 0x40
	// Reception disabled.
	RADIO_RXADDRESSES_ADDR6_Disabled = 0x0
	// Reception enabled.
	RADIO_RXADDRESSES_ADDR6_Enabled = 0x1
	// Position of ADDR7 field.
	RADIO_RXADDRESSES_ADDR7_Pos = 0x7
	// Bit mask of ADDR7 field.
	RADIO_RXADDRESSES_ADDR7_Msk = 0x80
	// Bit ADDR7.
	RADIO_RXADDRESSES_ADDR7 = 0x80
	// Reception disabled.
	RADIO_RXADDRESSES_ADDR7_Disabled = 0x0
	// Reception enabled.
	RADIO_RXADDRESSES_ADDR7_Enabled = 0x1

	// CRCCNF: CRC configuration.
	// Position of LEN field.
	RADIO_CRCCNF_LEN_Pos = 0x0
	// Bit mask of LEN field.
	RADIO_CRCCNF_LEN_Msk = 0x3
	// CRC calculation disabled.
	RADIO_CRCCNF_LEN_Disabled = 0x0
	// One byte long CRC.
	RADIO_CRCCNF_LEN_One = 0x1
	// Two bytes long CRC.
	RADIO_CRCCNF_LEN_Two = 0x2
	// Three bytes long CRC.
	RADIO_CRCCNF_LEN_Three = 0x3
	// Position of SKIPADDR field.
	RADIO_CRCCNF_SKIPADDR_Pos = 0x8
	// Bit mask of SKIPADDR field.
	RADIO_CRCCNF_SKIPADDR_Msk = 0x100
	// Bit SKIPADDR.
	RADIO_CRCCNF_SKIPADDR = 0x100
	// Include packet address in CRC calculation.
	RADIO_CRCCNF_SKIPADDR_Include = 0x0
	// Packet address is skipped in CRC calculation. The CRC calculation will start at the first byte after the address.
	RADIO_CRCCNF_SKIPADDR_Skip = 0x1

	// CRCPOLY: CRC polynomial.
	// Position of CRCPOLY field.
	RADIO_CRCPOLY_CRCPOLY_Pos = 0x0
	// Bit mask of CRCPOLY field.
	RADIO_CRCPOLY_CRCPOLY_Msk = 0xffffff

	// CRCINIT: CRC initial value.
	// Position of CRCINIT field.
	RADIO_CRCINIT_CRCINIT_Pos = 0x0
	// Bit mask of CRCINIT field.
	RADIO_CRCINIT_CRCINIT_Msk = 0xffffff

	// TEST: Test features enable register.
	// Position of CONSTCARRIER field.
	RADIO_TEST_CONSTCARRIER_Pos = 0x0
	// Bit mask of CONSTCARRIER field.
	RADIO_TEST_CONSTCARRIER_Msk = 0x1
	// Bit CONSTCARRIER.
	RADIO_TEST_CONSTCARRIER = 0x1
	// Constant carrier disabled.
	RADIO_TEST_CONSTCARRIER_Disabled = 0x0
	// Constant carrier enabled.
	RADIO_TEST_CONSTCARRIER_Enabled = 0x1
	// Position of PLLLOCK field.
	RADIO_TEST_PLLLOCK_Pos = 0x1
	// Bit mask of PLLLOCK field.
	RADIO_TEST_PLLLOCK_Msk = 0x2
	// Bit PLLLOCK.
	RADIO_TEST_PLLLOCK = 0x2
	// PLL lock disabled.
	RADIO_TEST_PLLLOCK_Disabled = 0x0
	// PLL lock enabled.
	RADIO_TEST_PLLLOCK_Enabled = 0x1

	// TIFS: Inter Frame Spacing in microseconds.
	// Position of TIFS field.
	RADIO_TIFS_TIFS_Pos = 0x0
	// Bit mask of TIFS field.
	RADIO_TIFS_TIFS_Msk = 0xff

	// RSSISAMPLE: RSSI sample.
	// Position of RSSISAMPLE field.
	RADIO_RSSISAMPLE_RSSISAMPLE_Pos = 0x0
	// Bit mask of RSSISAMPLE field.
	RADIO_RSSISAMPLE_RSSISAMPLE_Msk = 0x7f

	// STATE: Current radio state.
	// Position of STATE field.
	RADIO_STATE_STATE_Pos = 0x0
	// Bit mask of STATE field.
	RADIO_STATE_STATE_Msk = 0xf
	// Radio is in the Disabled state.
	RADIO_STATE_STATE_Disabled = 0x0
	// Radio is in the Rx Ramp Up state.
	RADIO_STATE_STATE_RxRu = 0x1
	// Radio is in the Rx Idle state.
	RADIO_STATE_STATE_RxIdle = 0x2
	// Radio is in the Rx state.
	RADIO_STATE_STATE_Rx = 0x3
	// Radio is in the Rx Disable state.
	RADIO_STATE_STATE_RxDisable = 0x4
	// Radio is in the Tx Ramp Up state.
	RADIO_STATE_STATE_TxRu = 0x9
	// Radio is in the Tx Idle state.
	RADIO_STATE_STATE_TxIdle = 0xa
	// Radio is in the Tx state.
	RADIO_STATE_STATE_Tx = 0xb
	// Radio is in the Tx Disable state.
	RADIO_STATE_STATE_TxDisable = 0xc

	// DATAWHITEIV: Data whitening initial value.
	// Position of DATAWHITEIV field.
	RADIO_DATAWHITEIV_DATAWHITEIV_Pos = 0x0
	// Bit mask of DATAWHITEIV field.
	RADIO_DATAWHITEIV_DATAWHITEIV_Msk = 0x7f

	// DAP: Device address prefix.
	// Position of DAP field.
	RADIO_DAP_DAP_Pos = 0x0
	// Bit mask of DAP field.
	RADIO_DAP_DAP_Msk = 0xffff

	// DACNF: Device address match configuration.
	// Position of ENA0 field.
	RADIO_DACNF_ENA0_Pos = 0x0
	// Bit mask of ENA0 field.
	RADIO_DACNF_ENA0_Msk = 0x1
	// Bit ENA0.
	RADIO_DACNF_ENA0 = 0x1
	// Disabled.
	RADIO_DACNF_ENA0_Disabled = 0x0
	// Enabled.
	RADIO_DACNF_ENA0_Enabled = 0x1
	// Position of ENA1 field.
	RADIO_DACNF_ENA1_Pos = 0x1
	// Bit mask of ENA1 field.
	RADIO_DACNF_ENA1_Msk = 0x2
	// Bit ENA1.
	RADIO_DACNF_ENA1 = 0x2
	// Disabled.
	RADIO_DACNF_ENA1_Disabled = 0x0
	// Enabled.
	RADIO_DACNF_ENA1_Enabled = 0x1
	// Position of ENA2 field.
	RADIO_DACNF_ENA2_Pos = 0x2
	// Bit mask of ENA2 field.
	RADIO_DACNF_ENA2_Msk = 0x4
	// Bit ENA2.
	RADIO_DACNF_ENA2 = 0x4
	// Disabled.
	RADIO_DACNF_ENA2_Disabled = 0x0
	// Enabled.
	RADIO_DACNF_ENA2_Enabled = 0x1
	// Position of ENA3 field.
	RADIO_DACNF_ENA3_Pos = 0x3
	// Bit mask of ENA3 field.
	RADIO_DACNF_ENA3_Msk = 0x8
	// Bit ENA3.
	RADIO_DACNF_ENA3 = 0x8
	// Disabled.
	RADIO_DACNF_ENA3_Disabled = 0x0
	// Enabled.
	RADIO_DACNF_ENA3_Enabled = 0x1
	// Position of ENA4 field.
	RADIO_DACNF_ENA4_Pos = 0x4
	// Bit mask of ENA4 field.
	RADIO_DACNF_ENA4_Msk = 0x10
	// Bit ENA4.
	RADIO_DACNF_ENA4 = 0x10
	// Disabled.
	RADIO_DACNF_ENA4_Disabled = 0x0
	// Enabled.
	RADIO_DACNF_ENA4_Enabled = 0x1
	// Position of ENA5 field.
	RADIO_DACNF_ENA5_Pos = 0x5
	// Bit mask of ENA5 field.
	RADIO_DACNF_ENA5_Msk = 0x20
	// Bit ENA5.
	RADIO_DACNF_ENA5 = 0x20
	// Disabled.
	RADIO_DACNF_ENA5_Disabled = 0x0
	// Enabled.
	RADIO_DACNF_ENA5_Enabled = 0x1
	// Position of ENA6 field.
	RADIO_DACNF_ENA6_Pos = 0x6
	// Bit mask of ENA6 field.
	RADIO_DACNF_ENA6_Msk = 0x40
	// Bit ENA6.
	RADIO_DACNF_ENA6 = 0x40
	// Disabled.
	RADIO_DACNF_ENA6_Disabled = 0x0
	// Enabled.
	RADIO_DACNF_ENA6_Enabled = 0x1
	// Position of ENA7 field.
	RADIO_DACNF_ENA7_Pos = 0x7
	// Bit mask of ENA7 field.
	RADIO_DACNF_ENA7_Msk = 0x80
	// Bit ENA7.
	RADIO_DACNF_ENA7 = 0x80
	// Disabled.
	RADIO_DACNF_ENA7_Disabled = 0x0
	// Enabled.
	RADIO_DACNF_ENA7_Enabled = 0x1
	// Position of TXADD0 field.
	RADIO_DACNF_TXADD0_Pos = 0x8
	// Bit mask of TXADD0 field.
	RADIO_DACNF_TXADD0_Msk = 0x100
	// Bit TXADD0.
	RADIO_DACNF_TXADD0 = 0x100
	// Position of TXADD1 field.
	RADIO_DACNF_TXADD1_Pos = 0x9
	// Bit mask of TXADD1 field.
	RADIO_DACNF_TXADD1_Msk = 0x200
	// Bit TXADD1.
	RADIO_DACNF_TXADD1 = 0x200
	// Position of TXADD2 field.
	RADIO_DACNF_TXADD2_Pos = 0xa
	// Bit mask of TXADD2 field.
	RADIO_DACNF_TXADD2_Msk = 0x400
	// Bit TXADD2.
	RADIO_DACNF_TXADD2 = 0x400
	// Position of TXADD3 field.
	RADIO_DACNF_TXADD3_Pos = 0xb
	// Bit mask of TXADD3 field.
	RADIO_DACNF_TXADD3_Msk = 0x800
	// Bit TXADD3.
	RADIO_DACNF_TXADD3 = 0x800
	// Position of TXADD4 field.
	RADIO_DACNF_TXADD4_Pos = 0xc
	// Bit mask of TXADD4 field.
	RADIO_DACNF_TXADD4_Msk = 0x1000
	// Bit TXADD4.
	RADIO_DACNF_TXADD4 = 0x1000
	// Position of TXADD5 field.
	RADIO_DACNF_TXADD5_Pos = 0xd
	// Bit mask of TXADD5 field.
	RADIO_DACNF_TXADD5_Msk = 0x2000
	// Bit TXADD5.
	RADIO_DACNF_TXADD5 = 0x2000
	// Position of TXADD6 field.
	RADIO_DACNF_TXADD6_Pos = 0xe
	// Bit mask of TXADD6 field.
	RADIO_DACNF_TXADD6_Msk = 0x4000
	// Bit TXADD6.
	RADIO_DACNF_TXADD6 = 0x4000
	// Position of TXADD7 field.
	RADIO_DACNF_TXADD7_Pos = 0xf
	// Bit mask of TXADD7 field.
	RADIO_DACNF_TXADD7_Msk = 0x8000
	// Bit TXADD7.
	RADIO_DACNF_TXADD7 = 0x8000

	// OVERRIDE0: Trim value override register 0.
	// Position of OVERRIDE0 field.
	RADIO_OVERRIDE0_OVERRIDE0_Pos = 0x0
	// Bit mask of OVERRIDE0 field.
	RADIO_OVERRIDE0_OVERRIDE0_Msk = 0xffffffff

	// OVERRIDE1: Trim value override register 1.
	// Position of OVERRIDE1 field.
	RADIO_OVERRIDE1_OVERRIDE1_Pos = 0x0
	// Bit mask of OVERRIDE1 field.
	RADIO_OVERRIDE1_OVERRIDE1_Msk = 0xffffffff

	// OVERRIDE2: Trim value override register 2.
	// Position of OVERRIDE2 field.
	RADIO_OVERRIDE2_OVERRIDE2_Pos = 0x0
	// Bit mask of OVERRIDE2 field.
	RADIO_OVERRIDE2_OVERRIDE2_Msk = 0xffffffff

	// OVERRIDE3: Trim value override register 3.
	// Position of OVERRIDE3 field.
	RADIO_OVERRIDE3_OVERRIDE3_Pos = 0x0
	// Bit mask of OVERRIDE3 field.
	RADIO_OVERRIDE3_OVERRIDE3_Msk = 0xffffffff

	// OVERRIDE4: Trim value override register 4.
	// Position of OVERRIDE4 field.
	RADIO_OVERRIDE4_OVERRIDE4_Pos = 0x0
	// Bit mask of OVERRIDE4 field.
	RADIO_OVERRIDE4_OVERRIDE4_Msk = 0xfffffff
	// Position of ENABLE field.
	RADIO_OVERRIDE4_ENABLE_Pos = 0x1f
	// Bit mask of ENABLE field.
	RADIO_OVERRIDE4_ENABLE_Msk = 0x80000000
	// Bit ENABLE.
	RADIO_OVERRIDE4_ENABLE = 0x80000000
	// Override trim values disabled.
	RADIO_OVERRIDE4_ENABLE_Disabled = 0x0
	// Override trim values enabled.
	RADIO_OVERRIDE4_ENABLE_Enabled = 0x1

	// POWER: Peripheral power control.
	// Position of POWER field.
	RADIO_POWER_POWER_Pos = 0x0
	// Bit mask of POWER field.
	RADIO_POWER_POWER_Msk = 0x1
	// Bit POWER.
	RADIO_POWER_POWER = 0x1
	// Module power disabled.
	RADIO_POWER_POWER_Disabled = 0x0
	// Module power enabled.
	RADIO_POWER_POWER_Enabled = 0x1
)

// Bitfields for UART0: Universal Asynchronous Receiver/Transmitter.
const (
	// SHORTS: Shortcuts for UART.
	// Position of CTS_STARTRX field.
	UART_SHORTS_CTS_STARTRX_Pos = 0x3
	// Bit mask of CTS_STARTRX field.
	UART_SHORTS_CTS_STARTRX_Msk = 0x8
	// Bit CTS_STARTRX.
	UART_SHORTS_CTS_STARTRX = 0x8
	// Shortcut disabled.
	UART_SHORTS_CTS_STARTRX_Disabled = 0x0
	// Shortcut enabled.
	UART_SHORTS_CTS_STARTRX_Enabled = 0x1
	// Position of NCTS_STOPRX field.
	UART_SHORTS_NCTS_STOPRX_Pos = 0x4
	// Bit mask of NCTS_STOPRX field.
	UART_SHORTS_NCTS_STOPRX_Msk = 0x10
	// Bit NCTS_STOPRX.
	UART_SHORTS_NCTS_STOPRX = 0x10
	// Shortcut disabled.
	UART_SHORTS_NCTS_STOPRX_Disabled = 0x0
	// Shortcut enabled.
	UART_SHORTS_NCTS_STOPRX_Enabled = 0x1

	// INTENSET: Interrupt enable set register.
	// Position of CTS field.
	UART_INTENSET_CTS_Pos = 0x0
	// Bit mask of CTS field.
	UART_INTENSET_CTS_Msk = 0x1
	// Bit CTS.
	UART_INTENSET_CTS = 0x1
	// Interrupt disabled.
	UART_INTENSET_CTS_Disabled = 0x0
	// Interrupt enabled.
	UART_INTENSET_CTS_Enabled = 0x1
	// Enable interrupt on write.
	UART_INTENSET_CTS_Set = 0x1
	// Position of NCTS field.
	UART_INTENSET_NCTS_Pos = 0x1
	// Bit mask of NCTS field.
	UART_INTENSET_NCTS_Msk = 0x2
	// Bit NCTS.
	UART_INTENSET_NCTS = 0x2
	// Interrupt disabled.
	UART_INTENSET_NCTS_Disabled = 0x0
	// Interrupt enabled.
	UART_INTENSET_NCTS_Enabled = 0x1
	// Enable interrupt on write.
	UART_INTENSET_NCTS_Set = 0x1
	// Position of RXDRDY field.
	UART_INTENSET_RXDRDY_Pos = 0x2
	// Bit mask of RXDRDY field.
	UART_INTENSET_RXDRDY_Msk = 0x4
	// Bit RXDRDY.
	UART_INTENSET_RXDRDY = 0x4
	// Interrupt disabled.
	UART_INTENSET_RXDRDY_Disabled = 0x0
	// Interrupt enabled.
	UART_INTENSET_RXDRDY_Enabled = 0x1
	// Enable interrupt on write.
	UART_INTENSET_RXDRDY_Set = 0x1
	// Position of TXDRDY field.
	UART_INTENSET_TXDRDY_Pos = 0x7
	// Bit mask of TXDRDY field.
	UART_INTENSET_TXDRDY_Msk = 0x80
	// Bit TXDRDY.
	UART_INTENSET_TXDRDY = 0x80
	// Interrupt disabled.
	UART_INTENSET_TXDRDY_Disabled = 0x0
	// Interrupt enabled.
	UART_INTENSET_TXDRDY_Enabled = 0x1
	// Enable interrupt on write.
	UART_INTENSET_TXDRDY_Set = 0x1
	// Position of ERROR field.
	UART_INTENSET_ERROR_Pos = 0x9
	// Bit mask of ERROR field.
	UART_INTENSET_ERROR_Msk = 0x200
	// Bit ERROR.
	UART_INTENSET_ERROR = 0x200
	// Interrupt disabled.
	UART_INTENSET_ERROR_Disabled = 0x0
	// Interrupt enabled.
	UART_INTENSET_ERROR_Enabled = 0x1
	// Enable interrupt on write.
	UART_INTENSET_ERROR_Set = 0x1
	// Position of RXTO field.
	UART_INTENSET_RXTO_Pos = 0x11
	// Bit mask of RXTO field.
	UART_INTENSET_RXTO_Msk = 0x20000
	// Bit RXTO.
	UART_INTENSET_RXTO = 0x20000
	// Interrupt disabled.
	UART_INTENSET_RXTO_Disabled = 0x0
	// Interrupt enabled.
	UART_INTENSET_RXTO_Enabled = 0x1
	// Enable interrupt on write.
	UART_INTENSET_RXTO_Set = 0x1

	// INTENCLR: Interrupt enable clear register.
	// Position of CTS field.
	UART_INTENCLR_CTS_Pos = 0x0
	// Bit mask of CTS field.
	UART_INTENCLR_CTS_Msk = 0x1
	// Bit CTS.
	UART_INTENCLR_CTS = 0x1
	// Interrupt disabled.
	UART_INTENCLR_CTS_Disabled = 0x0
	// Interrupt enabled.
	UART_INTENCLR_CTS_Enabled = 0x1
	// Disable interrupt on write.
	UART_INTENCLR_CTS_Clear = 0x1
	// Position of NCTS field.
	UART_INTENCLR_NCTS_Pos = 0x1
	// Bit mask of NCTS field.
	UART_INTENCLR_NCTS_Msk = 0x2
	// Bit NCTS.
	UART_INTENCLR_NCTS = 0x2
	// Interrupt disabled.
	UART_INTENCLR_NCTS_Disabled = 0x0
	// Interrupt enabled.
	UART_INTENCLR_NCTS_Enabled = 0x1
	// Disable interrupt on write.
	UART_INTENCLR_NCTS_Clear = 0x1
	// Position of RXDRDY field.
	UART_INTENCLR_RXDRDY_Pos = 0x2
	// Bit mask of RXDRDY field.
	UART_INTENCLR_RXDRDY_Msk = 0x4
	// Bit RXDRDY.
	UART_INTENCLR_RXDRDY = 0x4
	// Interrupt disabled.
	UART_INTENCLR_RXDRDY_Disabled = 0x0
	// Interrupt enabled.
	UART_INTENCLR_RXDRDY_Enabled = 0x1
	// Disable interrupt on write.
	UART_INTENCLR_RXDRDY_Clear = 0x1
	// Position of TXDRDY field.
	UART_INTENCLR_TXDRDY_Pos = 0x7
	// Bit mask of TXDRDY field.
	UART_INTENCLR_TXDRDY_Msk = 0x80
	// Bit TXDRDY.
	UART_INTENCLR_TXDRDY = 0x80
	// Interrupt disabled.
	UART_INTENCLR_TXDRDY_Disabled = 0x0
	// Interrupt enabled.
	UART_INTENCLR_TXDRDY_Enabled = 0x1
	// Disable interrupt on write.
	UART_INTENCLR_TXDRDY_Clear = 0x1
	// Position of ERROR field.
	UART_INTENCLR_ERROR_Pos = 0x9
	// Bit mask of ERROR field.
	UART_INTENCLR_ERROR_Msk = 0x200
	// Bit ERROR.
	UART_INTENCLR_ERROR = 0x200
	// Interrupt disabled.
	UART_INTENCLR_ERROR_Disabled = 0x0
	// Interrupt enabled.
	UART_INTENCLR_ERROR_Enabled = 0x1
	// Disable interrupt on write.
	UART_INTENCLR_ERROR_Clear = 0x1
	// Position of RXTO field.
	UART_INTENCLR_RXTO_Pos = 0x11
	// Bit mask of RXTO field.
	UART_INTENCLR_RXTO_Msk = 0x20000
	// Bit RXTO.
	UART_INTENCLR_RXTO = 0x20000
	// Interrupt disabled.
	UART_INTENCLR_RXTO_Disabled = 0x0
	// Interrupt enabled.
	UART_INTENCLR_RXTO_Enabled = 0x1
	// Disable interrupt on write.
	UART_INTENCLR_RXTO_Clear = 0x1

	// ERRORSRC: Error source. Write error field to 1 to clear error.
	// Position of OVERRUN field.
	UART_ERRORSRC_OVERRUN_Pos = 0x0
	// Bit mask of OVERRUN field.
	UART_ERRORSRC_OVERRUN_Msk = 0x1
	// Bit OVERRUN.
	UART_ERRORSRC_OVERRUN = 0x1
	// Error not present.
	UART_ERRORSRC_OVERRUN_NotPresent = 0x0
	// Error present.
	UART_ERRORSRC_OVERRUN_Present = 0x1
	// Clear error on write.
	UART_ERRORSRC_OVERRUN_Clear = 0x1
	// Position of PARITY field.
	UART_ERRORSRC_PARITY_Pos = 0x1
	// Bit mask of PARITY field.
	UART_ERRORSRC_PARITY_Msk = 0x2
	// Bit PARITY.
	UART_ERRORSRC_PARITY = 0x2
	// Error not present.
	UART_ERRORSRC_PARITY_NotPresent = 0x0
	// Error present.
	UART_ERRORSRC_PARITY_Present = 0x1
	// Clear error on write.
	UART_ERRORSRC_PARITY_Clear = 0x1
	// Position of FRAMING field.
	UART_ERRORSRC_FRAMING_Pos = 0x2
	// Bit mask of FRAMING field.
	UART_ERRORSRC_FRAMING_Msk = 0x4
	// Bit FRAMING.
	UART_ERRORSRC_FRAMING = 0x4
	// Error not present.
	UART_ERRORSRC_FRAMING_NotPresent = 0x0
	// Error present.
	UART_ERRORSRC_FRAMING_Present = 0x1
	// Clear error on write.
	UART_ERRORSRC_FRAMING_Clear = 0x1
	// Position of BREAK field.
	UART_ERRORSRC_BREAK_Pos = 0x3
	// Bit mask of BREAK field.
	UART_ERRORSRC_BREAK_Msk = 0x8
	// Bit BREAK.
	UART_ERRORSRC_BREAK = 0x8
	// Error not present.
	UART_ERRORSRC_BREAK_NotPresent = 0x0
	// Error present.
	UART_ERRORSRC_BREAK_Present = 0x1
	// Clear error on write.
	UART_ERRORSRC_BREAK_Clear = 0x1

	// ENABLE: Enable UART and acquire IOs.
	// Position of ENABLE field.
	UART_ENABLE_ENABLE_Pos = 0x0
	// Bit mask of ENABLE field.
	UART_ENABLE_ENABLE_Msk = 0x7
	// UART disabled.
	UART_ENABLE_ENABLE_Disabled = 0x0
	// UART enabled.
	UART_ENABLE_ENABLE_Enabled = 0x4

	// RXD: RXD register. On read action the buffer pointer is displaced. Once read the character is consumed. If read when no character available, the UART will stop working.
	// Position of RXD field.
	UART_RXD_RXD_Pos = 0x0
	// Bit mask of RXD field.
	UART_RXD_RXD_Msk = 0xff

	// TXD: TXD register.
	// Position of TXD field.
	UART_TXD_TXD_Pos = 0x0
	// Bit mask of TXD field.
	UART_TXD_TXD_Msk = 0xff

	// BAUDRATE: UART Baudrate.
	// Position of BAUDRATE field.
	UART_BAUDRATE_BAUDRATE_Pos = 0x0
	// Bit mask of BAUDRATE field.
	UART_BAUDRATE_BAUDRATE_Msk = 0xffffffff
	// 1200 baud.
	UART_BAUDRATE_BAUDRATE_Baud1200 = 0x4f000
	// 2400 baud.
	UART_BAUDRATE_BAUDRATE_Baud2400 = 0x9d000
	// 4800 baud.
	UART_BAUDRATE_BAUDRATE_Baud4800 = 0x13b000
	// 9600 baud.
	UART_BAUDRATE_BAUDRATE_Baud9600 = 0x275000
	// 14400 baud.
	UART_BAUDRATE_BAUDRATE_Baud14400 = 0x3b0000
	// 19200 baud.
	UART_BAUDRATE_BAUDRATE_Baud19200 = 0x4ea000
	// 28800 baud.
	UART_BAUDRATE_BAUDRATE_Baud28800 = 0x75f000
	// 31250 baud.
	UART_BAUDRATE_BAUDRATE_Baud31250 = 0x800000
	// 38400 baud.
	UART_BAUDRATE_BAUDRATE_Baud38400 = 0x9d5000
	// 56000 baud.
	UART_BAUDRATE_BAUDRATE_Baud56000 = 0xe50000
	// 57600 baud.
	UART_BAUDRATE_BAUDRATE_Baud57600 = 0xebf000
	// 76800 baud.
	UART_BAUDRATE_BAUDRATE_Baud76800 = 0x13a9000
	// 115200 baud.
	UART_BAUDRATE_BAUDRATE_Baud115200 = 0x1d7e000
	// 230400 baud.
	UART_BAUDRATE_BAUDRATE_Baud230400 = 0x3afb000
	// 250000 baud.
	UART_BAUDRATE_BAUDRATE_Baud250000 = 0x4000000
	// 460800 baud.
	UART_BAUDRATE_BAUDRATE_Baud460800 = 0x75f7000
	// 921600 baud.
	UART_BAUDRATE_BAUDRATE_Baud921600 = 0xebed000
	// 1M baud.
	UART_BAUDRATE_BAUDRATE_Baud1M = 0x10000000

	// CONFIG: Configuration of parity and hardware flow control register.
	// Position of HWFC field.
	UART_CONFIG_HWFC_Pos = 0x0
	// Bit mask of HWFC field.
	UART_CONFIG_HWFC_Msk = 0x1
	// Bit HWFC.
	UART_CONFIG_HWFC = 0x1
	// Hardware flow control disabled.
	UART_CONFIG_HWFC_Disabled = 0x0
	// Hardware flow control enabled.
	UART_CONFIG_HWFC_Enabled = 0x1
	// Position of PARITY field.
	UART_CONFIG_PARITY_Pos = 0x1
	// Bit mask of PARITY field.
	UART_CONFIG_PARITY_Msk = 0xe
	// Parity bit excluded.
	UART_CONFIG_PARITY_Excluded = 0x0
	// Parity bit included.
	UART_CONFIG_PARITY_Included = 0x7

	// POWER: Peripheral power control.
	// Position of POWER field.
	UART_POWER_POWER_Pos = 0x0
	// Bit mask of POWER field.
	UART_POWER_POWER_Msk = 0x1
	// Bit POWER.
	UART_POWER_POWER = 0x1
	// Module power disabled.
	UART_POWER_POWER_Disabled = 0x0
	// Module power enabled.
	UART_POWER_POWER_Enabled = 0x1
)

// Bitfields for SPI0: SPI master 0.
const (
	// INTENSET: Interrupt enable set register.
	// Position of READY field.
	SPI_INTENSET_READY_Pos = 0x2
	// Bit mask of READY field.
	SPI_INTENSET_READY_Msk = 0x4
	// Bit READY.
	SPI_INTENSET_READY = 0x4
	// Interrupt disabled.
	SPI_INTENSET_READY_Disabled = 0x0
	// Interrupt enabled.
	SPI_INTENSET_READY_Enabled = 0x1
	// Enable interrupt on write.
	SPI_INTENSET_READY_Set = 0x1

	// INTENCLR: Interrupt enable clear register.
	// Position of READY field.
	SPI_INTENCLR_READY_Pos = 0x2
	// Bit mask of READY field.
	SPI_INTENCLR_READY_Msk = 0x4
	// Bit READY.
	SPI_INTENCLR_READY = 0x4
	// Interrupt disabled.
	SPI_INTENCLR_READY_Disabled = 0x0
	// Interrupt enabled.
	SPI_INTENCLR_READY_Enabled = 0x1
	// Disable interrupt on write.
	SPI_INTENCLR_READY_Clear = 0x1

	// ENABLE: Enable SPI.
	// Position of ENABLE field.
	SPI_ENABLE_ENABLE_Pos = 0x0
	// Bit mask of ENABLE field.
	SPI_ENABLE_ENABLE_Msk = 0x7
	// Disabled SPI.
	SPI_ENABLE_ENABLE_Disabled = 0x0
	// Enable SPI.
	SPI_ENABLE_ENABLE_Enabled = 0x1

	// RXD: RX data.
	// Position of RXD field.
	SPI_RXD_RXD_Pos = 0x0
	// Bit mask of RXD field.
	SPI_RXD_RXD_Msk = 0xff

	// TXD: TX data.
	// Position of TXD field.
	SPI_TXD_TXD_Pos = 0x0
	// Bit mask of TXD field.
	SPI_TXD_TXD_Msk = 0xff

	// FREQUENCY: SPI frequency
	// Position of FREQUENCY field.
	SPI_FREQUENCY_FREQUENCY_Pos = 0x0
	// Bit mask of FREQUENCY field.
	SPI_FREQUENCY_FREQUENCY_Msk = 0xffffffff
	// 125kbps.
	SPI_FREQUENCY_FREQUENCY_K125 = 0x2000000
	// 250kbps.
	SPI_FREQUENCY_FREQUENCY_K250 = 0x4000000
	// 500kbps.
	SPI_FREQUENCY_FREQUENCY_K500 = 0x8000000
	// 1Mbps.
	SPI_FREQUENCY_FREQUENCY_M1 = 0x10000000
	// 2Mbps.
	SPI_FREQUENCY_FREQUENCY_M2 = 0x20000000
	// 4Mbps.
	SPI_FREQUENCY_FREQUENCY_M4 = 0x40000000
	// 8Mbps.
	SPI_FREQUENCY_FREQUENCY_M8 = 0x80000000

	// CONFIG: Configuration register.
	// Position of ORDER field.
	SPI_CONFIG_ORDER_Pos = 0x0
	// Bit mask of ORDER field.
	SPI_CONFIG_ORDER_Msk = 0x1
	// Bit ORDER.
	SPI_CONFIG_ORDER = 0x1
	// Most significant bit transmitted out first.
	SPI_CONFIG_ORDER_MsbFirst = 0x0
	// Least significant bit transmitted out first.
	SPI_CONFIG_ORDER_LsbFirst = 0x1
	// Position of CPHA field.
	SPI_CONFIG_CPHA_Pos = 0x1
	// Bit mask of CPHA field.
	SPI_CONFIG_CPHA_Msk = 0x2
	// Bit CPHA.
	SPI_CONFIG_CPHA = 0x2
	// Sample on leading edge of the clock. Shift serial data on trailing edge.
	SPI_CONFIG_CPHA_Leading = 0x0
	// Sample on trailing edge of the clock. Shift serial data on leading edge.
	SPI_CONFIG_CPHA_Trailing = 0x1
	// Position of CPOL field.
	SPI_CONFIG_CPOL_Pos = 0x2
	// Bit mask of CPOL field.
	SPI_CONFIG_CPOL_Msk = 0x4
	// Bit CPOL.
	SPI_CONFIG_CPOL = 0x4
	// Active high.
	SPI_CONFIG_CPOL_ActiveHigh = 0x0
	// Active low.
	SPI_CONFIG_CPOL_ActiveLow = 0x1

	// POWER: Peripheral power control.
	// Position of POWER field.
	SPI_POWER_POWER_Pos = 0x0
	// Bit mask of POWER field.
	SPI_POWER_POWER_Msk = 0x1
	// Bit POWER.
	SPI_POWER_POWER = 0x1
	// Module power disabled.
	SPI_POWER_POWER_Disabled = 0x0
	// Module power enabled.
	SPI_POWER_POWER_Enabled = 0x1
)

// Bitfields for TWI0: Two-wire interface master 0.
const (
	// SHORTS: Shortcuts for TWI.
	// Position of BB_SUSPEND field.
	TWI_SHORTS_BB_SUSPEND_Pos = 0x0
	// Bit mask of BB_SUSPEND field.
	TWI_SHORTS_BB_SUSPEND_Msk = 0x1
	// Bit BB_SUSPEND.
	TWI_SHORTS_BB_SUSPEND = 0x1
	// Shortcut disabled.
	TWI_SHORTS_BB_SUSPEND_Disabled = 0x0
	// Shortcut enabled.
	TWI_SHORTS_BB_SUSPEND_Enabled = 0x1
	// Position of BB_STOP field.
	TWI_SHORTS_BB_STOP_Pos = 0x1
	// Bit mask of BB_STOP field.
	TWI_SHORTS_BB_STOP_Msk = 0x2
	// Bit BB_STOP.
	TWI_SHORTS_BB_STOP = 0x2
	// Shortcut disabled.
	TWI_SHORTS_BB_STOP_Disabled = 0x0
	// Shortcut enabled.
	TWI_SHORTS_BB_STOP_Enabled = 0x1

	// INTENSET: Interrupt enable set register.
	// Position of STOPPED field.
	TWI_INTENSET_STOPPED_Pos = 0x1
	// Bit mask of STOPPED field.
	TWI_INTENSET_STOPPED_Msk = 0x2
	// Bit STOPPED.
	TWI_INTENSET_STOPPED = 0x2
	// Interrupt disabled.
	TWI_INTENSET_STOPPED_Disabled = 0x0
	// Interrupt enabled.
	TWI_INTENSET_STOPPED_Enabled = 0x1
	// Enable interrupt on write.
	TWI_INTENSET_STOPPED_Set = 0x1
	// Position of RXDREADY field.
	TWI_INTENSET_RXDREADY_Pos = 0x2
	// Bit mask of RXDREADY field.
	TWI_INTENSET_RXDREADY_Msk = 0x4
	// Bit RXDREADY.
	TWI_INTENSET_RXDREADY = 0x4
	// Interrupt disabled.
	TWI_INTENSET_RXDREADY_Disabled = 0x0
	// Interrupt enabled.
	TWI_INTENSET_RXDREADY_Enabled = 0x1
	// Enable interrupt on write.
	TWI_INTENSET_RXDREADY_Set = 0x1
	// Position of TXDSENT field.
	TWI_INTENSET_TXDSENT_Pos = 0x7
	// Bit mask of TXDSENT field.
	TWI_INTENSET_TXDSENT_Msk = 0x80
	// Bit TXDSENT.
	TWI_INTENSET_TXDSENT = 0x80
	// Interrupt disabled.
	TWI_INTENSET_TXDSENT_Disabled = 0x0
	// Interrupt enabled.
	TWI_INTENSET_TXDSENT_Enabled = 0x1
	// Enable interrupt on write.
	TWI_INTENSET_TXDSENT_Set = 0x1
	// Position of ERROR field.
	TWI_INTENSET_ERROR_Pos = 0x9
	// Bit mask of ERROR field.
	TWI_INTENSET_ERROR_Msk = 0x200
	// Bit ERROR.
	TWI_INTENSET_ERROR = 0x200
	// Interrupt disabled.
	TWI_INTENSET_ERROR_Disabled = 0x0
	// Interrupt enabled.
	TWI_INTENSET_ERROR_Enabled = 0x1
	// Enable interrupt on write.
	TWI_INTENSET_ERROR_Set = 0x1
	// Position of BB field.
	TWI_INTENSET_BB_Pos = 0xe
	// Bit mask of BB field.
	TWI_INTENSET_BB_Msk = 0x4000
	// Bit BB.
	TWI_INTENSET_BB = 0x4000
	// Interrupt disabled.
	TWI_INTENSET_BB_Disabled = 0x0
	// Interrupt enabled.
	TWI_INTENSET_BB_Enabled = 0x1
	// Enable interrupt on write.
	TWI_INTENSET_BB_Set = 0x1
	// Position of SUSPENDED field.
	TWI_INTENSET_SUSPENDED_Pos = 0x12
	// Bit mask of SUSPENDED field.
	TWI_INTENSET_SUSPENDED_Msk = 0x40000
	// Bit SUSPENDED.
	TWI_INTENSET_SUSPENDED = 0x40000
	// Interrupt disabled.
	TWI_INTENSET_SUSPENDED_Disabled = 0x0
	// Interrupt enabled.
	TWI_INTENSET_SUSPENDED_Enabled = 0x1
	// Enable interrupt on write.
	TWI_INTENSET_SUSPENDED_Set = 0x1

	// INTENCLR: Interrupt enable clear register.
	// Position of STOPPED field.
	TWI_INTENCLR_STOPPED_Pos = 0x1
	// Bit mask of STOPPED field.
	TWI_INTENCLR_STOPPED_Msk = 0x2
	// Bit STOPPED.
	TWI_INTENCLR_STOPPED = 0x2
	// Interrupt disabled.
	TWI_INTENCLR_STOPPED_Disabled = 0x0
	// Interrupt enabled.
	TWI_INTENCLR_STOPPED_Enabled = 0x1
	// Disable interrupt on write.
	TWI_INTENCLR_STOPPED_Clear = 0x1
	// Position of RXDREADY field.
	TWI_INTENCLR_RXDREADY_Pos = 0x2
	// Bit mask of RXDREADY field.
	TWI_INTENCLR_RXDREADY_Msk = 0x4
	// Bit RXDREADY.
	TWI_INTENCLR_RXDREADY = 0x4
	// Interrupt disabled.
	TWI_INTENCLR_RXDREADY_Disabled = 0x0
	// Interrupt enabled.
	TWI_INTENCLR_RXDREADY_Enabled = 0x1
	// Disable interrupt on write.
	TWI_INTENCLR_RXDREADY_Clear = 0x1
	// Position of TXDSENT field.
	TWI_INTENCLR_TXDSENT_Pos = 0x7
	// Bit mask of TXDSENT field.
	TWI_INTENCLR_TXDSENT_Msk = 0x80
	// Bit TXDSENT.
	TWI_INTENCLR_TXDSENT = 0x80
	// Interrupt disabled.
	TWI_INTENCLR_TXDSENT_Disabled = 0x0
	// Interrupt enabled.
	TWI_INTENCLR_TXDSENT_Enabled = 0x1
	// Disable interrupt on write.
	TWI_INTENCLR_TXDSENT_Clear = 0x1
	// Position of ERROR field.
	TWI_INTENCLR_ERROR_Pos = 0x9
	// Bit mask of ERROR field.
	TWI_INTENCLR_ERROR_Msk = 0x200
	// Bit ERROR.
	TWI_INTENCLR_ERROR = 0x200
	// Interrupt disabled.
	TWI_INTENCLR_ERROR_Disabled = 0x0
	// Interrupt enabled.
	TWI_INTENCLR_ERROR_Enabled = 0x1
	// Disable interrupt on write.
	TWI_INTENCLR_ERROR_Clear = 0x1
	// Position of BB field.
	TWI_INTENCLR_BB_Pos = 0xe
	// Bit mask of BB field.
	TWI_INTENCLR_BB_Msk = 0x4000
	// Bit BB.
	TWI_INTENCLR_BB = 0x4000
	// Interrupt disabled.
	TWI_INTENCLR_BB_Disabled = 0x0
	// Interrupt enabled.
	TWI_INTENCLR_BB_Enabled = 0x1
	// Disable interrupt on write.
	TWI_INTENCLR_BB_Clear = 0x1
	// Position of SUSPENDED field.
	TWI_INTENCLR_SUSPENDED_Pos = 0x12
	// Bit mask of SUSPENDED field.
	TWI_INTENCLR_SUSPENDED_Msk = 0x40000
	// Bit SUSPENDED.
	TWI_INTENCLR_SUSPENDED = 0x40000
	// Interrupt disabled.
	TWI_INTENCLR_SUSPENDED_Disabled = 0x0
	// Interrupt enabled.
	TWI_INTENCLR_SUSPENDED_Enabled = 0x1
	// Disable interrupt on write.
	TWI_INTENCLR_SUSPENDED_Clear = 0x1

	// ERRORSRC: Two-wire error source. Write error field to 1 to clear error.
	// Position of OVERRUN field.
	TWI_ERRORSRC_OVERRUN_Pos = 0x0
	// Bit mask of OVERRUN field.
	TWI_ERRORSRC_OVERRUN_Msk = 0x1
	// Bit OVERRUN.
	TWI_ERRORSRC_OVERRUN = 0x1
	// Error not present.
	TWI_ERRORSRC_OVERRUN_NotPresent = 0x0
	// Error present.
	TWI_ERRORSRC_OVERRUN_Present = 0x1
	// Clear error on write.
	TWI_ERRORSRC_OVERRUN_Clear = 0x1
	// Position of ANACK field.
	TWI_ERRORSRC_ANACK_Pos = 0x1
	// Bit mask of ANACK field.
	TWI_ERRORSRC_ANACK_Msk = 0x2
	// Bit ANACK.
	TWI_ERRORSRC_ANACK = 0x2
	// Error not present.
	TWI_ERRORSRC_ANACK_NotPresent = 0x0
	// Error present.
	TWI_ERRORSRC_ANACK_Present = 0x1
	// Clear error on write.
	TWI_ERRORSRC_ANACK_Clear = 0x1
	// Position of DNACK field.
	TWI_ERRORSRC_DNACK_Pos = 0x2
	// Bit mask of DNACK field.
	TWI_ERRORSRC_DNACK_Msk = 0x4
	// Bit DNACK.
	TWI_ERRORSRC_DNACK = 0x4
	// Error not present.
	TWI_ERRORSRC_DNACK_NotPresent = 0x0
	// Error present.
	TWI_ERRORSRC_DNACK_Present = 0x1
	// Clear error on write.
	TWI_ERRORSRC_DNACK_Clear = 0x1

	// ENABLE: Enable two-wire master.
	// Position of ENABLE field.
	TWI_ENABLE_ENABLE_Pos = 0x0
	// Bit mask of ENABLE field.
	TWI_ENABLE_ENABLE_Msk = 0x7
	// Disabled.
	TWI_ENABLE_ENABLE_Disabled = 0x0
	// Enabled.
	TWI_ENABLE_ENABLE_Enabled = 0x5

	// RXD: RX data register.
	// Position of RXD field.
	TWI_RXD_RXD_Pos = 0x0
	// Bit mask of RXD field.
	TWI_RXD_RXD_Msk = 0xff

	// TXD: TX data register.
	// Position of TXD field.
	TWI_TXD_TXD_Pos = 0x0
	// Bit mask of TXD field.
	TWI_TXD_TXD_Msk = 0xff

	// FREQUENCY: Two-wire frequency.
	// Position of FREQUENCY field.
	TWI_FREQUENCY_FREQUENCY_Pos = 0x0
	// Bit mask of FREQUENCY field.
	TWI_FREQUENCY_FREQUENCY_Msk = 0xffffffff
	// 100 kbps.
	TWI_FREQUENCY_FREQUENCY_K100 = 0x1980000
	// 250 kbps.
	TWI_FREQUENCY_FREQUENCY_K250 = 0x4000000
	// 400 kbps (actual rate 410.256 kbps).
	TWI_FREQUENCY_FREQUENCY_K400 = 0x6680000

	// ADDRESS: Address used in the two-wire transfer.
	// Position of ADDRESS field.
	TWI_ADDRESS_ADDRESS_Pos = 0x0
	// Bit mask of ADDRESS field.
	TWI_ADDRESS_ADDRESS_Msk = 0x7f

	// POWER: Peripheral power control.
	// Position of POWER field.
	TWI_POWER_POWER_Pos = 0x0
	// Bit mask of POWER field.
	TWI_POWER_POWER_Msk = 0x1
	// Bit POWER.
	TWI_POWER_POWER = 0x1
	// Module power disabled.
	TWI_POWER_POWER_Disabled = 0x0
	// Module power enabled.
	TWI_POWER_POWER_Enabled = 0x1
)

// Bitfields for SPIS1: SPI slave 1.
const (
	// SHORTS: Shortcuts for SPIS.
	// Position of END_ACQUIRE field.
	SPIS_SHORTS_END_ACQUIRE_Pos = 0x2
	// Bit mask of END_ACQUIRE field.
	SPIS_SHORTS_END_ACQUIRE_Msk = 0x4
	// Bit END_ACQUIRE.
	SPIS_SHORTS_END_ACQUIRE = 0x4
	// Shortcut disabled.
	SPIS_SHORTS_END_ACQUIRE_Disabled = 0x0
	// Shortcut enabled.
	SPIS_SHORTS_END_ACQUIRE_Enabled = 0x1

	// INTENSET: Interrupt enable set register.
	// Position of END field.
	SPIS_INTENSET_END_Pos = 0x1
	// Bit mask of END field.
	SPIS_INTENSET_END_Msk = 0x2
	// Bit END.
	SPIS_INTENSET_END = 0x2
	// Interrupt disabled.
	SPIS_INTENSET_END_Disabled = 0x0
	// Interrupt enabled.
	SPIS_INTENSET_END_Enabled = 0x1
	// Enable interrupt on write.
	SPIS_INTENSET_END_Set = 0x1
	// Position of ENDRX field.
	SPIS_INTENSET_ENDRX_Pos = 0x4
	// Bit mask of ENDRX field.
	SPIS_INTENSET_ENDRX_Msk = 0x10
	// Bit ENDRX.
	SPIS_INTENSET_ENDRX = 0x10
	// Interrupt disabled.
	SPIS_INTENSET_ENDRX_Disabled = 0x0
	// Interrupt enabled.
	SPIS_INTENSET_ENDRX_Enabled = 0x1
	// Enable interrupt on write.
	SPIS_INTENSET_ENDRX_Set = 0x1
	// Position of ACQUIRED field.
	SPIS_INTENSET_ACQUIRED_Pos = 0xa
	// Bit mask of ACQUIRED field.
	SPIS_INTENSET_ACQUIRED_Msk = 0x400
	// Bit ACQUIRED.
	SPIS_INTENSET_ACQUIRED = 0x400
	// Interrupt disabled.
	SPIS_INTENSET_ACQUIRED_Disabled = 0x0
	// Interrupt enabled.
	SPIS_INTENSET_ACQUIRED_Enabled = 0x1
	// Enable interrupt on write.
	SPIS_INTENSET_ACQUIRED_Set = 0x1

	// INTENCLR: Interrupt enable clear register.
	// Position of END field.
	SPIS_INTENCLR_END_Pos = 0x1
	// Bit mask of END field.
	SPIS_INTENCLR_END_Msk = 0x2
	// Bit END.
	SPIS_INTENCLR_END = 0x2
	// Interrupt disabled.
	SPIS_INTENCLR_END_Disabled = 0x0
	// Interrupt enabled.
	SPIS_INTENCLR_END_Enabled = 0x1
	// Disable interrupt on write.
	SPIS_INTENCLR_END_Clear = 0x1
	// Position of ENDRX field.
	SPIS_INTENCLR_ENDRX_Pos = 0x4
	// Bit mask of ENDRX field.
	SPIS_INTENCLR_ENDRX_Msk = 0x10
	// Bit ENDRX.
	SPIS_INTENCLR_ENDRX = 0x10
	// Interrupt disabled.
	SPIS_INTENCLR_ENDRX_Disabled = 0x0
	// Interrupt enabled.
	SPIS_INTENCLR_ENDRX_Enabled = 0x1
	// Disable interrupt on write.
	SPIS_INTENCLR_ENDRX_Clear = 0x1
	// Position of ACQUIRED field.
	SPIS_INTENCLR_ACQUIRED_Pos = 0xa
	// Bit mask of ACQUIRED field.
	SPIS_INTENCLR_ACQUIRED_Msk = 0x400
	// Bit ACQUIRED.
	SPIS_INTENCLR_ACQUIRED = 0x400
	// Interrupt disabled.
	SPIS_INTENCLR_ACQUIRED_Disabled = 0x0
	// Interrupt enabled.
	SPIS_INTENCLR_ACQUIRED_Enabled = 0x1
	// Disable interrupt on write.
	SPIS_INTENCLR_ACQUIRED_Clear = 0x1

	// SEMSTAT: Semaphore status.
	// Position of SEMSTAT field.
	SPIS_SEMSTAT_SEMSTAT_Pos = 0x0
	// Bit mask of SEMSTAT field.
	SPIS_SEMSTAT_SEMSTAT_Msk = 0x3
	// Semaphore is free.
	SPIS_SEMSTAT_SEMSTAT_Free = 0x0
	// Semaphore is assigned to the CPU.
	SPIS_SEMSTAT_SEMSTAT_CPU = 0x1
	// Semaphore is assigned to the SPIS.
	SPIS_SEMSTAT_SEMSTAT_SPIS = 0x2
	// Semaphore is assigned to the SPIS, but a handover to the CPU is pending.
	SPIS_SEMSTAT_SEMSTAT_CPUPending = 0x3

	// STATUS: Status from last transaction.
	// Position of OVERREAD field.
	SPIS_STATUS_OVERREAD_Pos = 0x0
	// Bit mask of OVERREAD field.
	SPIS_STATUS_OVERREAD_Msk = 0x1
	// Bit OVERREAD.
	SPIS_STATUS_OVERREAD = 0x1
	// Error not present.
	SPIS_STATUS_OVERREAD_NotPresent = 0x0
	// Error present.
	SPIS_STATUS_OVERREAD_Present = 0x1
	// Clear on write.
	SPIS_STATUS_OVERREAD_Clear = 0x1
	// Position of OVERFLOW field.
	SPIS_STATUS_OVERFLOW_Pos = 0x1
	// Bit mask of OVERFLOW field.
	SPIS_STATUS_OVERFLOW_Msk = 0x2
	// Bit OVERFLOW.
	SPIS_STATUS_OVERFLOW = 0x2
	// Error not present.
	SPIS_STATUS_OVERFLOW_NotPresent = 0x0
	// Error present.
	SPIS_STATUS_OVERFLOW_Present = 0x1
	// Clear on write.
	SPIS_STATUS_OVERFLOW_Clear = 0x1

	// ENABLE: Enable SPIS.
	// Position of ENABLE field.
	SPIS_ENABLE_ENABLE_Pos = 0x0
	// Bit mask of ENABLE field.
	SPIS_ENABLE_ENABLE_Msk = 0x7
	// Disabled SPIS.
	SPIS_ENABLE_ENABLE_Disabled = 0x0
	// Enable SPIS.
	SPIS_ENABLE_ENABLE_Enabled = 0x2

	// MAXRX: Maximum number of bytes in the receive buffer.
	// Position of MAXRX field.
	SPIS_MAXRX_MAXRX_Pos = 0x0
	// Bit mask of MAXRX field.
	SPIS_MAXRX_MAXRX_Msk = 0xff

	// AMOUNTRX: Number of bytes received in last granted transaction.
	// Position of AMOUNTRX field.
	SPIS_AMOUNTRX_AMOUNTRX_Pos = 0x0
	// Bit mask of AMOUNTRX field.
	SPIS_AMOUNTRX_AMOUNTRX_Msk = 0xff

	// MAXTX: Maximum number of bytes in the transmit buffer.
	// Position of MAXTX field.
	SPIS_MAXTX_MAXTX_Pos = 0x0
	// Bit mask of MAXTX field.
	SPIS_MAXTX_MAXTX_Msk = 0xff

	// AMOUNTTX: Number of bytes transmitted in last granted transaction.
	// Position of AMOUNTTX field.
	SPIS_AMOUNTTX_AMOUNTTX_Pos = 0x0
	// Bit mask of AMOUNTTX field.
	SPIS_AMOUNTTX_AMOUNTTX_Msk = 0xff

	// CONFIG: Configuration register.
	// Position of ORDER field.
	SPIS_CONFIG_ORDER_Pos = 0x0
	// Bit mask of ORDER field.
	SPIS_CONFIG_ORDER_Msk = 0x1
	// Bit ORDER.
	SPIS_CONFIG_ORDER = 0x1
	// Most significant bit transmitted out first.
	SPIS_CONFIG_ORDER_MsbFirst = 0x0
	// Least significant bit transmitted out first.
	SPIS_CONFIG_ORDER_LsbFirst = 0x1
	// Position of CPHA field.
	SPIS_CONFIG_CPHA_Pos = 0x1
	// Bit mask of CPHA field.
	SPIS_CONFIG_CPHA_Msk = 0x2
	// Bit CPHA.
	SPIS_CONFIG_CPHA = 0x2
	// Sample on leading edge of the clock. Shift serial data on trailing edge.
	SPIS_CONFIG_CPHA_Leading = 0x0
	// Sample on trailing edge of the clock. Shift serial data on leading edge.
	SPIS_CONFIG_CPHA_Trailing = 0x1
	// Position of CPOL field.
	SPIS_CONFIG_CPOL_Pos = 0x2
	// Bit mask of CPOL field.
	SPIS_CONFIG_CPOL_Msk = 0x4
	// Bit CPOL.
	SPIS_CONFIG_CPOL = 0x4
	// Active high.
	SPIS_CONFIG_CPOL_ActiveHigh = 0x0
	// Active low.
	SPIS_CONFIG_CPOL_ActiveLow = 0x1

	// DEF: Default character.
	// Position of DEF field.
	SPIS_DEF_DEF_Pos = 0x0
	// Bit mask of DEF field.
	SPIS_DEF_DEF_Msk = 0xff

	// ORC: Over-read character.
	// Position of ORC field.
	SPIS_ORC_ORC_Pos = 0x0
	// Bit mask of ORC field.
	SPIS_ORC_ORC_Msk = 0xff

	// POWER: Peripheral power control.
	// Position of POWER field.
	SPIS_POWER_POWER_Pos = 0x0
	// Bit mask of POWER field.
	SPIS_POWER_POWER_Msk = 0x1
	// Bit POWER.
	SPIS_POWER_POWER = 0x1
	// Module power disabled.
	SPIS_POWER_POWER_Disabled = 0x0
	// Module power enabled.
	SPIS_POWER_POWER_Enabled = 0x1
)

// Bitfields for GPIOTE: GPIO tasks and events.
const (
	// INTENSET: Interrupt enable set register.
	// Position of IN0 field.
	GPIOTE_INTENSET_IN0_Pos = 0x0
	// Bit mask of IN0 field.
	GPIOTE_INTENSET_IN0_Msk = 0x1
	// Bit IN0.
	GPIOTE_INTENSET_IN0 = 0x1
	// Interrupt disabled.
	GPIOTE_INTENSET_IN0_Disabled = 0x0
	// Interrupt enabled.
	GPIOTE_INTENSET_IN0_Enabled = 0x1
	// Enable interrupt on write.
	GPIOTE_INTENSET_IN0_Set = 0x1
	// Position of IN1 field.
	GPIOTE_INTENSET_IN1_Pos = 0x1
	// Bit mask of IN1 field.
	GPIOTE_INTENSET_IN1_Msk = 0x2
	// Bit IN1.
	GPIOTE_INTENSET_IN1 = 0x2
	// Interrupt disabled.
	GPIOTE_INTENSET_IN1_Disabled = 0x0
	// Interrupt enabled.
	GPIOTE_INTENSET_IN1_Enabled = 0x1
	// Enable interrupt on write.
	GPIOTE_INTENSET_IN1_Set = 0x1
	// Position of IN2 field.
	GPIOTE_INTENSET_IN2_Pos = 0x2
	// Bit mask of IN2 field.
	GPIOTE_INTENSET_IN2_Msk = 0x4
	// Bit IN2.
	GPIOTE_INTENSET_IN2 = 0x4
	// Interrupt disabled.
	GPIOTE_INTENSET_IN2_Disabled = 0x0
	// Interrupt enabled.
	GPIOTE_INTENSET_IN2_Enabled = 0x1
	// Enable interrupt on write.
	GPIOTE_INTENSET_IN2_Set = 0x1
	// Position of IN3 field.
	GPIOTE_INTENSET_IN3_Pos = 0x3
	// Bit mask of IN3 field.
	GPIOTE_INTENSET_IN3_Msk = 0x8
	// Bit IN3.
	GPIOTE_INTENSET_IN3 = 0x8
	// Interrupt disabled.
	GPIOTE_INTENSET_IN3_Disabled = 0x0
	// Interrupt enabled.
	GPIOTE_INTENSET_IN3_Enabled = 0x1
	// Enable interrupt on write.
	GPIOTE_INTENSET_IN3_Set = 0x1
	// Position of PORT field.
	GPIOTE_INTENSET_PORT_Pos = 0x1f
	// Bit mask of PORT field.
	GPIOTE_INTENSET_PORT_Msk = 0x80000000
	// Bit PORT.
	GPIOTE_INTENSET_PORT = 0x80000000
	// Interrupt disabled.
	GPIOTE_INTENSET_PORT_Disabled = 0x0
	// Interrupt enabled.
	GPIOTE_INTENSET_PORT_Enabled = 0x1
	// Enable interrupt on write.
	GPIOTE_INTENSET_PORT_Set = 0x1

	// INTENCLR: Interrupt enable clear register.
	// Position of IN0 field.
	GPIOTE_INTENCLR_IN0_Pos = 0x0
	// Bit mask of IN0 field.
	GPIOTE_INTENCLR_IN0_Msk = 0x1
	// Bit IN0.
	GPIOTE_INTENCLR_IN0 = 0x1
	// Interrupt disabled.
	GPIOTE_INTENCLR_IN0_Disabled = 0x0
	// Interrupt enabled.
	GPIOTE_INTENCLR_IN0_Enabled = 0x1
	// Disable interrupt on write.
	GPIOTE_INTENCLR_IN0_Clear = 0x1
	// Position of IN1 field.
	GPIOTE_INTENCLR_IN1_Pos = 0x1
	// Bit mask of IN1 field.
	GPIOTE_INTENCLR_IN1_Msk = 0x2
	// Bit IN1.
	GPIOTE_INTENCLR_IN1 = 0x2
	// Interrupt disabled.
	GPIOTE_INTENCLR_IN1_Disabled = 0x0
	// Interrupt enabled.
	GPIOTE_INTENCLR_IN1_Enabled = 0x1
	// Disable interrupt on write.
	GPIOTE_INTENCLR_IN1_Clear = 0x1
	// Position of IN2 field.
	GPIOTE_INTENCLR_IN2_Pos = 0x2
	// Bit mask of IN2 field.
	GPIOTE_INTENCLR_IN2_Msk = 0x4
	// Bit IN2.
	GPIOTE_INTENCLR_IN2 = 0x4
	// Interrupt disabled.
	GPIOTE_INTENCLR_IN2_Disabled = 0x0
	// Interrupt enabled.
	GPIOTE_INTENCLR_IN2_Enabled = 0x1
	// Disable interrupt on write.
	GPIOTE_INTENCLR_IN2_Clear = 0x1
	// Position of IN3 field.
	GPIOTE_INTENCLR_IN3_Pos = 0x3
	// Bit mask of IN3 field.
	GPIOTE_INTENCLR_IN3_Msk = 0x8
	// Bit IN3.
	GPIOTE_INTENCLR_IN3 = 0x8
	// Interrupt disabled.
	GPIOTE_INTENCLR_IN3_Disabled = 0x0
	// Interrupt enabled.
	GPIOTE_INTENCLR_IN3_Enabled = 0x1
	// Disable interrupt on write.
	GPIOTE_INTENCLR_IN3_Clear = 0x1
	// Position of PORT field.
	GPIOTE_INTENCLR_PORT_Pos = 0x1f
	// Bit mask of PORT field.
	GPIOTE_INTENCLR_PORT_Msk = 0x80000000
	// Bit PORT.
	GPIOTE_INTENCLR_PORT = 0x80000000
	// Interrupt disabled.
	GPIOTE_INTENCLR_PORT_Disabled = 0x0
	// Interrupt enabled.
	GPIOTE_INTENCLR_PORT_Enabled = 0x1
	// Disable interrupt on write.
	GPIOTE_INTENCLR_PORT_Clear = 0x1

	// CONFIG: Channel configuration registers.
	// Position of MODE field.
	GPIOTE_CONFIG_MODE_Pos = 0x0
	// Bit mask of MODE field.
	GPIOTE_CONFIG_MODE_Msk = 0x3
	// Disabled.
	GPIOTE_CONFIG_MODE_Disabled = 0x0
	// Channel configure in event mode.
	GPIOTE_CONFIG_MODE_Event = 0x1
	// Channel configure in task mode.
	GPIOTE_CONFIG_MODE_Task = 0x3
	// Position of PSEL field.
	GPIOTE_CONFIG_PSEL_Pos = 0x8
	// Bit mask of PSEL field.
	GPIOTE_CONFIG_PSEL_Msk = 0x1f00
	// Position of POLARITY field.
	GPIOTE_CONFIG_POLARITY_Pos = 0x10
	// Bit mask of POLARITY field.
	GPIOTE_CONFIG_POLARITY_Msk = 0x30000
	// No task or event.
	GPIOTE_CONFIG_POLARITY_None = 0x0
	// Low to high.
	GPIOTE_CONFIG_POLARITY_LoToHi = 0x1
	// High to low.
	GPIOTE_CONFIG_POLARITY_HiToLo = 0x2
	// Toggle.
	GPIOTE_CONFIG_POLARITY_Toggle = 0x3
	// Position of OUTINIT field.
	GPIOTE_CONFIG_OUTINIT_Pos = 0x14
	// Bit mask of OUTINIT field.
	GPIOTE_CONFIG_OUTINIT_Msk = 0x100000
	// Bit OUTINIT.
	GPIOTE_CONFIG_OUTINIT = 0x100000
	// Initial low output when in task mode.
	GPIOTE_CONFIG_OUTINIT_Low = 0x0
	// Initial high output when in task mode.
	GPIOTE_CONFIG_OUTINIT_High = 0x1

	// POWER: Peripheral power control.
	// Position of POWER field.
	GPIOTE_POWER_POWER_Pos = 0x0
	// Bit mask of POWER field.
	GPIOTE_POWER_POWER_Msk = 0x1
	// Bit POWER.
	GPIOTE_POWER_POWER = 0x1
	// Module power disabled.
	GPIOTE_POWER_POWER_Disabled = 0x0
	// Module power enabled.
	GPIOTE_POWER_POWER_Enabled = 0x1
)

// Bitfields for ADC: Analog to digital converter.
const (
	// INTENSET: Interrupt enable set register.
	// Position of END field.
	ADC_INTENSET_END_Pos = 0x0
	// Bit mask of END field.
	ADC_INTENSET_END_Msk = 0x1
	// Bit END.
	ADC_INTENSET_END = 0x1
	// Interrupt disabled.
	ADC_INTENSET_END_Disabled = 0x0
	// Interrupt enabled.
	ADC_INTENSET_END_Enabled = 0x1
	// Enable interrupt on write.
	ADC_INTENSET_END_Set = 0x1

	// INTENCLR: Interrupt enable clear register.
	// Position of END field.
	ADC_INTENCLR_END_Pos = 0x0
	// Bit mask of END field.
	ADC_INTENCLR_END_Msk = 0x1
	// Bit END.
	ADC_INTENCLR_END = 0x1
	// Interrupt disabled.
	ADC_INTENCLR_END_Disabled = 0x0
	// Interrupt enabled.
	ADC_INTENCLR_END_Enabled = 0x1
	// Disable interrupt on write.
	ADC_INTENCLR_END_Clear = 0x1

	// BUSY: ADC busy register.
	// Position of BUSY field.
	ADC_BUSY_BUSY_Pos = 0x0
	// Bit mask of BUSY field.
	ADC_BUSY_BUSY_Msk = 0x1
	// Bit BUSY.
	ADC_BUSY_BUSY = 0x1
	// No ongoing ADC conversion is taking place. ADC is ready.
	ADC_BUSY_BUSY_Ready = 0x0
	// An ADC conversion is taking place. ADC is busy.
	ADC_BUSY_BUSY_Busy = 0x1

	// ENABLE: ADC enable.
	// Position of ENABLE field.
	ADC_ENABLE_ENABLE_Pos = 0x0
	// Bit mask of ENABLE field.
	ADC_ENABLE_ENABLE_Msk = 0x3
	// ADC is disabled.
	ADC_ENABLE_ENABLE_Disabled = 0x0
	// ADC is enabled. If an analog input pin is selected as source of the conversion, the selected pin is configured as an analog input.
	ADC_ENABLE_ENABLE_Enabled = 0x1

	// CONFIG: ADC configuration register.
	// Position of RES field.
	ADC_CONFIG_RES_Pos = 0x0
	// Bit mask of RES field.
	ADC_CONFIG_RES_Msk = 0x3
	// 8bit ADC resolution.
	ADC_CONFIG_RES_8bit = 0x0
	// 9bit ADC resolution.
	ADC_CONFIG_RES_9bit = 0x1
	// 10bit ADC resolution.
	ADC_CONFIG_RES_10bit = 0x2
	// Position of INPSEL field.
	ADC_CONFIG_INPSEL_Pos = 0x2
	// Bit mask of INPSEL field.
	ADC_CONFIG_INPSEL_Msk = 0x1c
	// Analog input specified by PSEL with no prescaling used as input for the conversion.
	ADC_CONFIG_INPSEL_AnalogInputNoPrescaling = 0x0
	// Analog input specified by PSEL with 2/3 prescaling used as input for the conversion.
	ADC_CONFIG_INPSEL_AnalogInputTwoThirdsPrescaling = 0x1
	// Analog input specified by PSEL with 1/3 prescaling used as input for the conversion.
	ADC_CONFIG_INPSEL_AnalogInputOneThirdPrescaling = 0x2
	// Supply voltage with 2/3 prescaling used as input for the conversion.
	ADC_CONFIG_INPSEL_SupplyTwoThirdsPrescaling = 0x5
	// Supply voltage with 1/3 prescaling used as input for the conversion.
	ADC_CONFIG_INPSEL_SupplyOneThirdPrescaling = 0x6
	// Position of REFSEL field.
	ADC_CONFIG_REFSEL_Pos = 0x5
	// Bit mask of REFSEL field.
	ADC_CONFIG_REFSEL_Msk = 0x60
	// Use internal 1.2V bandgap voltage as reference for conversion.
	ADC_CONFIG_REFSEL_VBG = 0x0
	// Use external source configured by EXTREFSEL as reference for conversion.
	ADC_CONFIG_REFSEL_External = 0x1
	// Use supply voltage with 1/2 prescaling as reference for conversion. Only usable when supply voltage is between 1.7V and 2.6V.
	ADC_CONFIG_REFSEL_SupplyOneHalfPrescaling = 0x2
	// Use supply voltage with 1/3 prescaling as reference for conversion. Only usable when supply voltage is between 2.5V and 3.6V.
	ADC_CONFIG_REFSEL_SupplyOneThirdPrescaling = 0x3
	// Position of PSEL field.
	ADC_CONFIG_PSEL_Pos = 0x8
	// Bit mask of PSEL field.
	ADC_CONFIG_PSEL_Msk = 0xff00
	// Analog input pins disabled.
	ADC_CONFIG_PSEL_Disabled = 0x0
	// Use analog input 0 as analog input.
	ADC_CONFIG_PSEL_AnalogInput0 = 0x1
	// Use analog input 1 as analog input.
	ADC_CONFIG_PSEL_AnalogInput1 = 0x2
	// Use analog input 2 as analog input.
	ADC_CONFIG_PSEL_AnalogInput2 = 0x4
	// Use analog input 3 as analog input.
	ADC_CONFIG_PSEL_AnalogInput3 = 0x8
	// Use analog input 4 as analog input.
	ADC_CONFIG_PSEL_AnalogInput4 = 0x10
	// Use analog input 5 as analog input.
	ADC_CONFIG_PSEL_AnalogInput5 = 0x20
	// Use analog input 6 as analog input.
	ADC_CONFIG_PSEL_AnalogInput6 = 0x40
	// Use analog input 7 as analog input.
	ADC_CONFIG_PSEL_AnalogInput7 = 0x80
	// Position of EXTREFSEL field.
	ADC_CONFIG_EXTREFSEL_Pos = 0x10
	// Bit mask of EXTREFSEL field.
	ADC_CONFIG_EXTREFSEL_Msk = 0x30000
	// Analog external reference inputs disabled.
	ADC_CONFIG_EXTREFSEL_None = 0x0
	// Use analog reference 0 as reference.
	ADC_CONFIG_EXTREFSEL_AnalogReference0 = 0x1
	// Use analog reference 1 as reference.
	ADC_CONFIG_EXTREFSEL_AnalogReference1 = 0x2

	// RESULT: Result of ADC conversion.
	// Position of RESULT field.
	ADC_RESULT_RESULT_Pos = 0x0
	// Bit mask of RESULT field.
	ADC_RESULT_RESULT_Msk = 0x3ff

	// POWER: Peripheral power control.
	// Position of POWER field.
	ADC_POWER_POWER_Pos = 0x0
	// Bit mask of POWER field.
	ADC_POWER_POWER_Msk = 0x1
	// Bit POWER.
	ADC_POWER_POWER = 0x1
	// Module power disabled.
	ADC_POWER_POWER_Disabled = 0x0
	// Module power enabled.
	ADC_POWER_POWER_Enabled = 0x1
)

// Bitfields for TIMER0: Timer 0.
const (
	// SHORTS: Shortcuts for Timer.
	// Position of COMPARE0_CLEAR field.
	TIMER_SHORTS_COMPARE0_CLEAR_Pos = 0x0
	// Bit mask of COMPARE0_CLEAR field.
	TIMER_SHORTS_COMPARE0_CLEAR_Msk = 0x1
	// Bit COMPARE0_CLEAR.
	TIMER_SHORTS_COMPARE0_CLEAR = 0x1
	// Shortcut disabled.
	TIMER_SHORTS_COMPARE0_CLEAR_Disabled = 0x0
	// Shortcut enabled.
	TIMER_SHORTS_COMPARE0_CLEAR_Enabled = 0x1
	// Position of COMPARE1_CLEAR field.
	TIMER_SHORTS_COMPARE1_CLEAR_Pos = 0x1
	// Bit mask of COMPARE1_CLEAR field.
	TIMER_SHORTS_COMPARE1_CLEAR_Msk = 0x2
	// Bit COMPARE1_CLEAR.
	TIMER_SHORTS_COMPARE1_CLEAR = 0x2
	// Shortcut disabled.
	TIMER_SHORTS_COMPARE1_CLEAR_Disabled = 0x0
	// Shortcut enabled.
	TIMER_SHORTS_COMPARE1_CLEAR_Enabled = 0x1
	// Position of COMPARE2_CLEAR field.
	TIMER_SHORTS_COMPARE2_CLEAR_Pos = 0x2
	// Bit mask of COMPARE2_CLEAR field.
	TIMER_SHORTS_COMPARE2_CLEAR_Msk = 0x4
	// Bit COMPARE2_CLEAR.
	TIMER_SHORTS_COMPARE2_CLEAR = 0x4
	// Shortcut disabled.
	TIMER_SHORTS_COMPARE2_CLEAR_Disabled = 0x0
	// Shortcut enabled.
	TIMER_SHORTS_COMPARE2_CLEAR_Enabled = 0x1
	// Position of COMPARE3_CLEAR field.
	TIMER_SHORTS_COMPARE3_CLEAR_Pos = 0x3
	// Bit mask of COMPARE3_CLEAR field.
	TIMER_SHORTS_COMPARE3_CLEAR_Msk = 0x8
	// Bit COMPARE3_CLEAR.
	TIMER_SHORTS_COMPARE3_CLEAR = 0x8
	// Shortcut disabled.
	TIMER_SHORTS_COMPARE3_CLEAR_Disabled = 0x0
	// Shortcut enabled.
	TIMER_SHORTS_COMPARE3_CLEAR_Enabled = 0x1
	// Position of COMPARE0_STOP field.
	TIMER_SHORTS_COMPARE0_STOP_Pos = 0x8
	// Bit mask of COMPARE0_STOP field.
	TIMER_SHORTS_COMPARE0_STOP_Msk = 0x100
	// Bit COMPARE0_STOP.
	TIMER_SHORTS_COMPARE0_STOP = 0x100
	// Shortcut disabled.
	TIMER_SHORTS_COMPARE0_STOP_Disabled = 0x0
	// Shortcut enabled.
	TIMER_SHORTS_COMPARE0_STOP_Enabled = 0x1
	// Position of COMPARE1_STOP field.
	TIMER_SHORTS_COMPARE1_STOP_Pos = 0x9
	// Bit mask of COMPARE1_STOP field.
	TIMER_SHORTS_COMPARE1_STOP_Msk = 0x200
	// Bit COMPARE1_STOP.
	TIMER_SHORTS_COMPARE1_STOP = 0x200
	// Shortcut disabled.
	TIMER_SHORTS_COMPARE1_STOP_Disabled = 0x0
	// Shortcut enabled.
	TIMER_SHORTS_COMPARE1_STOP_Enabled = 0x1
	// Position of COMPARE2_STOP field.
	TIMER_SHORTS_COMPARE2_STOP_Pos = 0xa
	// Bit mask of COMPARE2_STOP field.
	TIMER_SHORTS_COMPARE2_STOP_Msk = 0x400
	// Bit COMPARE2_STOP.
	TIMER_SHORTS_COMPARE2_STOP = 0x400
	// Shortcut disabled.
	TIMER_SHORTS_COMPARE2_STOP_Disabled = 0x0
	// Shortcut enabled.
	TIMER_SHORTS_COMPARE2_STOP_Enabled = 0x1
	// Position of COMPARE3_STOP field.
	TIMER_SHORTS_COMPARE3_STOP_Pos = 0xb
	// Bit mask of COMPARE3_STOP field.
	TIMER_SHORTS_COMPARE3_STOP_Msk = 0x800
	// Bit COMPARE3_STOP.
	TIMER_SHORTS_COMPARE3_STOP = 0x800
	// Shortcut disabled.
	TIMER_SHORTS_COMPARE3_STOP_Disabled = 0x0
	// Shortcut enabled.
	TIMER_SHORTS_COMPARE3_STOP_Enabled = 0x1

	// INTENSET: Interrupt enable set register.
	// Position of COMPARE0 field.
	TIMER_INTENSET_COMPARE0_Pos = 0x10
	// Bit mask of COMPARE0 field.
	TIMER_INTENSET_COMPARE0_Msk = 0x10000
	// Bit COMPARE0.
	TIMER_INTENSET_COMPARE0 = 0x10000
	// Interrupt disabled.
	TIMER_INTENSET_COMPARE0_Disabled = 0x0
	// Interrupt enabled.
	TIMER_INTENSET_COMPARE0_Enabled = 0x1
	// Enable interrupt on write.
	TIMER_INTENSET_COMPARE0_Set = 0x1
	// Position of COMPARE1 field.
	TIMER_INTENSET_COMPARE1_Pos = 0x11
	// Bit mask of COMPARE1 field.
	TIMER_INTENSET_COMPARE1_Msk = 0x20000
	// Bit COMPARE1.
	TIMER_INTENSET_COMPARE1 = 0x20000
	// Interrupt disabled.
	TIMER_INTENSET_COMPARE1_Disabled = 0x0
	// Interrupt enabled.
	TIMER_INTENSET_COMPARE1_Enabled = 0x1
	// Enable interrupt on write.
	TIMER_INTENSET_COMPARE1_Set = 0x1
	// Position of COMPARE2 field.
	TIMER_INTENSET_COMPARE2_Pos = 0x12
	// Bit mask of COMPARE2 field.
	TIMER_INTENSET_COMPARE2_Msk = 0x40000
	// Bit COMPARE2.
	TIMER_INTENSET_COMPARE2 = 0x40000
	// Interrupt disabled.
	TIMER_INTENSET_COMPARE2_Disabled = 0x0
	// Interrupt enabled.
	TIMER_INTENSET_COMPARE2_Enabled = 0x1
	// Enable interrupt on write.
	TIMER_INTENSET_COMPARE2_Set = 0x1
	// Position of COMPARE3 field.
	TIMER_INTENSET_COMPARE3_Pos = 0x13
	// Bit mask of COMPARE3 field.
	TIMER_INTENSET_COMPARE3_Msk = 0x80000
	// Bit COMPARE3.
	TIMER_INTENSET_COMPARE3 = 0x80000
	// Interrupt disabled.
	TIMER_INTENSET_COMPARE3_Disabled = 0x0
	// Interrupt enabled.
	TIMER_INTENSET_COMPARE3_Enabled = 0x1
	// Enable interrupt on write.
	TIMER_INTENSET_COMPARE3_Set = 0x1

	// INTENCLR: Interrupt enable clear register.
	// Position of COMPARE0 field.
	TIMER_INTENCLR_COMPARE0_Pos = 0x10
	// Bit mask of COMPARE0 field.
	TIMER_INTENCLR_COMPARE0_Msk = 0x10000
	// Bit COMPARE0.
	TIMER_INTENCLR_COMPARE0 = 0x10000
	// Interrupt disabled.
	TIMER_INTENCLR_COMPARE0_Disabled = 0x0
	// Interrupt enabled.
	TIMER_INTENCLR_COMPARE0_Enabled = 0x1
	// Disable interrupt on write.
	TIMER_INTENCLR_COMPARE0_Clear = 0x1
	// Position of COMPARE1 field.
	TIMER_INTENCLR_COMPARE1_Pos = 0x11
	// Bit mask of COMPARE1 field.
	TIMER_INTENCLR_COMPARE1_Msk = 0x20000
	// Bit COMPARE1.
	TIMER_INTENCLR_COMPARE1 = 0x20000
	// Interrupt disabled.
	TIMER_INTENCLR_COMPARE1_Disabled = 0x0
	// Interrupt enabled.
	TIMER_INTENCLR_COMPARE1_Enabled = 0x1
	// Disable interrupt on write.
	TIMER_INTENCLR_COMPARE1_Clear = 0x1
	// Position of COMPARE2 field.
	TIMER_INTENCLR_COMPARE2_Pos = 0x12
	// Bit mask of COMPARE2 field.
	TIMER_INTENCLR_COMPARE2_Msk = 0x40000
	// Bit COMPARE2.
	TIMER_INTENCLR_COMPARE2 = 0x40000
	// Interrupt disabled.
	TIMER_INTENCLR_COMPARE2_Disabled = 0x0
	// Interrupt enabled.
	TIMER_INTENCLR_COMPARE2_Enabled = 0x1
	// Disable interrupt on write.
	TIMER_INTENCLR_COMPARE2_Clear = 0x1
	// Position of COMPARE3 field.
	TIMER_INTENCLR_COMPARE3_Pos = 0x13
	// Bit mask of COMPARE3 field.
	TIMER_INTENCLR_COMPARE3_Msk = 0x80000
	// Bit COMPARE3.
	TIMER_INTENCLR_COMPARE3 = 0x80000
	// Interrupt disabled.
	TIMER_INTENCLR_COMPARE3_Disabled = 0x0
	// Interrupt enabled.
	TIMER_INTENCLR_COMPARE3_Enabled = 0x1
	// Disable interrupt on write.
	TIMER_INTENCLR_COMPARE3_Clear = 0x1

	// MODE: Timer Mode selection.
	// Position of MODE field.
	TIMER_MODE_MODE_Pos = 0x0
	// Bit mask of MODE field.
	TIMER_MODE_MODE_Msk = 0x1
	// Bit MODE.
	TIMER_MODE_MODE = 0x1
	// Timer in Counter mode.
	TIMER_MODE_MODE_Counter = 0x1
	// Timer in Normal mode.
	TIMER_MODE_MODE_Timer = 0x0

	// BITMODE: Sets timer behaviour.
	// Position of BITMODE field.
	TIMER_BITMODE_BITMODE_Pos = 0x0
	// Bit mask of BITMODE field.
	TIMER_BITMODE_BITMODE_Msk = 0x3
	// 16-bit timer behaviour.
	TIMER_BITMODE_BITMODE_16Bit = 0x0
	// 8-bit timer behaviour.
	TIMER_BITMODE_BITMODE_08Bit = 0x1
	// 24-bit timer behaviour.
	TIMER_BITMODE_BITMODE_24Bit = 0x2
	// 32-bit timer behaviour.
	TIMER_BITMODE_BITMODE_32Bit = 0x3

	// PRESCALER: 4-bit prescaler to source clock frequency (max value 9). Source clock frequency is divided by 2^SCALE.
	// Position of PRESCALER field.
	TIMER_PRESCALER_PRESCALER_Pos = 0x0
	// Bit mask of PRESCALER field.
	TIMER_PRESCALER_PRESCALER_Msk = 0xf

	// POWER: Peripheral power control.
	// Position of POWER field.
	TIMER_POWER_POWER_Pos = 0x0
	// Bit mask of POWER field.
	TIMER_POWER_POWER_Msk = 0x1
	// Bit POWER.
	TIMER_POWER_POWER = 0x1
	// Module power disabled.
	TIMER_POWER_POWER_Disabled = 0x0
	// Module power enabled.
	TIMER_POWER_POWER_Enabled = 0x1
)

// Bitfields for RTC0: Real time counter 0.
const (
	// INTENSET: Interrupt enable set register.
	// Position of TICK field.
	RTC_INTENSET_TICK_Pos = 0x0
	// Bit mask of TICK field.
	RTC_INTENSET_TICK_Msk = 0x1
	// Bit TICK.
	RTC_INTENSET_TICK = 0x1
	// Interrupt disabled.
	RTC_INTENSET_TICK_Disabled = 0x0
	// Interrupt enabled.
	RTC_INTENSET_TICK_Enabled = 0x1
	// Enable interrupt on write.
	RTC_INTENSET_TICK_Set = 0x1
	// Position of OVRFLW field.
	RTC_INTENSET_OVRFLW_Pos = 0x1
	// Bit mask of OVRFLW field.
	RTC_INTENSET_OVRFLW_Msk = 0x2
	// Bit OVRFLW.
	RTC_INTENSET_OVRFLW = 0x2
	// Interrupt disabled.
	RTC_INTENSET_OVRFLW_Disabled = 0x0
	// Interrupt enabled.
	RTC_INTENSET_OVRFLW_Enabled = 0x1
	// Enable interrupt on write.
	RTC_INTENSET_OVRFLW_Set = 0x1
	// Position of COMPARE0 field.
	RTC_INTENSET_COMPARE0_Pos = 0x10
	// Bit mask of COMPARE0 field.
	RTC_INTENSET_COMPARE0_Msk = 0x10000
	// Bit COMPARE0.
	RTC_INTENSET_COMPARE0 = 0x10000
	// Interrupt disabled.
	RTC_INTENSET_COMPARE0_Disabled = 0x0
	// Interrupt enabled.
	RTC_INTENSET_COMPARE0_Enabled = 0x1
	// Enable interrupt on write.
	RTC_INTENSET_COMPARE0_Set = 0x1
	// Position of COMPARE1 field.
	RTC_INTENSET_COMPARE1_Pos = 0x11
	// Bit mask of COMPARE1 field.
	RTC_INTENSET_COMPARE1_Msk = 0x20000
	// Bit COMPARE1.
	RTC_INTENSET_COMPARE1 = 0x20000
	// Interrupt disabled.
	RTC_INTENSET_COMPARE1_Disabled = 0x0
	// Interrupt enabled.
	RTC_INTENSET_COMPARE1_Enabled = 0x1
	// Enable interrupt on write.
	RTC_INTENSET_COMPARE1_Set = 0x1
	// Position of COMPARE2 field.
	RTC_INTENSET_COMPARE2_Pos = 0x12
	// Bit mask of COMPARE2 field.
	RTC_INTENSET_COMPARE2_Msk = 0x40000
	// Bit COMPARE2.
	RTC_INTENSET_COMPARE2 = 0x40000
	// Interrupt disabled.
	RTC_INTENSET_COMPARE2_Disabled = 0x0
	// Interrupt enabled.
	RTC_INTENSET_COMPARE2_Enabled = 0x1
	// Enable interrupt on write.
	RTC_INTENSET_COMPARE2_Set = 0x1
	// Position of COMPARE3 field.
	RTC_INTENSET_COMPARE3_Pos = 0x13
	// Bit mask of COMPARE3 field.
	RTC_INTENSET_COMPARE3_Msk = 0x80000
	// Bit COMPARE3.
	RTC_INTENSET_COMPARE3 = 0x80000
	// Interrupt disabled.
	RTC_INTENSET_COMPARE3_Disabled = 0x0
	// Interrupt enabled.
	RTC_INTENSET_COMPARE3_Enabled = 0x1
	// Enable interrupt on write.
	RTC_INTENSET_COMPARE3_Set = 0x1

	// INTENCLR: Interrupt enable clear register.
	// Position of TICK field.
	RTC_INTENCLR_TICK_Pos = 0x0
	// Bit mask of TICK field.
	RTC_INTENCLR_TICK_Msk = 0x1
	// Bit TICK.
	RTC_INTENCLR_TICK = 0x1
	// Interrupt disabled.
	RTC_INTENCLR_TICK_Disabled = 0x0
	// Interrupt enabled.
	RTC_INTENCLR_TICK_Enabled = 0x1
	// Disable interrupt on write.
	RTC_INTENCLR_TICK_Clear = 0x1
	// Position of OVRFLW field.
	RTC_INTENCLR_OVRFLW_Pos = 0x1
	// Bit mask of OVRFLW field.
	RTC_INTENCLR_OVRFLW_Msk = 0x2
	// Bit OVRFLW.
	RTC_INTENCLR_OVRFLW = 0x2
	// Interrupt disabled.
	RTC_INTENCLR_OVRFLW_Disabled = 0x0
	// Interrupt enabled.
	RTC_INTENCLR_OVRFLW_Enabled = 0x1
	// Disable interrupt on write.
	RTC_INTENCLR_OVRFLW_Clear = 0x1
	// Position of COMPARE0 field.
	RTC_INTENCLR_COMPARE0_Pos = 0x10
	// Bit mask of COMPARE0 field.
	RTC_INTENCLR_COMPARE0_Msk = 0x10000
	// Bit COMPARE0.
	RTC_INTENCLR_COMPARE0 = 0x10000
	// Interrupt disabled.
	RTC_INTENCLR_COMPARE0_Disabled = 0x0
	// Interrupt enabled.
	RTC_INTENCLR_COMPARE0_Enabled = 0x1
	// Disable interrupt on write.
	RTC_INTENCLR_COMPARE0_Clear = 0x1
	// Position of COMPARE1 field.
	RTC_INTENCLR_COMPARE1_Pos = 0x11
	// Bit mask of COMPARE1 field.
	RTC_INTENCLR_COMPARE1_Msk = 0x20000
	// Bit COMPARE1.
	RTC_INTENCLR_COMPARE1 = 0x20000
	// Interrupt disabled.
	RTC_INTENCLR_COMPARE1_Disabled = 0x0
	// Interrupt enabled.
	RTC_INTENCLR_COMPARE1_Enabled = 0x1
	// Disable interrupt on write.
	RTC_INTENCLR_COMPARE1_Clear = 0x1
	// Position of COMPARE2 field.
	RTC_INTENCLR_COMPARE2_Pos = 0x12
	// Bit mask of COMPARE2 field.
	RTC_INTENCLR_COMPARE2_Msk = 0x40000
	// Bit COMPARE2.
	RTC_INTENCLR_COMPARE2 = 0x40000
	// Interrupt disabled.
	RTC_INTENCLR_COMPARE2_Disabled = 0x0
	// Interrupt enabled.
	RTC_INTENCLR_COMPARE2_Enabled = 0x1
	// Disable interrupt on write.
	RTC_INTENCLR_COMPARE2_Clear = 0x1
	// Position of COMPARE3 field.
	RTC_INTENCLR_COMPARE3_Pos = 0x13
	// Bit mask of COMPARE3 field.
	RTC_INTENCLR_COMPARE3_Msk = 0x80000
	// Bit COMPARE3.
	RTC_INTENCLR_COMPARE3 = 0x80000
	// Interrupt disabled.
	RTC_INTENCLR_COMPARE3_Disabled = 0x0
	// Interrupt enabled.
	RTC_INTENCLR_COMPARE3_Enabled = 0x1
	// Disable interrupt on write.
	RTC_INTENCLR_COMPARE3_Clear = 0x1

	// EVTEN: Configures event enable routing to PPI for each RTC event.
	// Position of TICK field.
	RTC_EVTEN_TICK_Pos = 0x0
	// Bit mask of TICK field.
	RTC_EVTEN_TICK_Msk = 0x1
	// Bit TICK.
	RTC_EVTEN_TICK = 0x1
	// Event disabled.
	RTC_EVTEN_TICK_Disabled = 0x0
	// Event enabled.
	RTC_EVTEN_TICK_Enabled = 0x1
	// Position of OVRFLW field.
	RTC_EVTEN_OVRFLW_Pos = 0x1
	// Bit mask of OVRFLW field.
	RTC_EVTEN_OVRFLW_Msk = 0x2
	// Bit OVRFLW.
	RTC_EVTEN_OVRFLW = 0x2
	// Event disabled.
	RTC_EVTEN_OVRFLW_Disabled = 0x0
	// Event enabled.
	RTC_EVTEN_OVRFLW_Enabled = 0x1
	// Position of COMPARE0 field.
	RTC_EVTEN_COMPARE0_Pos = 0x10
	// Bit mask of COMPARE0 field.
	RTC_EVTEN_COMPARE0_Msk = 0x10000
	// Bit COMPARE0.
	RTC_EVTEN_COMPARE0 = 0x10000
	// Event disabled.
	RTC_EVTEN_COMPARE0_Disabled = 0x0
	// Event enabled.
	RTC_EVTEN_COMPARE0_Enabled = 0x1
	// Position of COMPARE1 field.
	RTC_EVTEN_COMPARE1_Pos = 0x11
	// Bit mask of COMPARE1 field.
	RTC_EVTEN_COMPARE1_Msk = 0x20000
	// Bit COMPARE1.
	RTC_EVTEN_COMPARE1 = 0x20000
	// Event disabled.
	RTC_EVTEN_COMPARE1_Disabled = 0x0
	// Event enabled.
	RTC_EVTEN_COMPARE1_Enabled = 0x1
	// Position of COMPARE2 field.
	RTC_EVTEN_COMPARE2_Pos = 0x12
	// Bit mask of COMPARE2 field.
	RTC_EVTEN_COMPARE2_Msk = 0x40000
	// Bit COMPARE2.
	RTC_EVTEN_COMPARE2 = 0x40000
	// Event disabled.
	RTC_EVTEN_COMPARE2_Disabled = 0x0
	// Event enabled.
	RTC_EVTEN_COMPARE2_Enabled = 0x1
	// Position of COMPARE3 field.
	RTC_EVTEN_COMPARE3_Pos = 0x13
	// Bit mask of COMPARE3 field.
	RTC_EVTEN_COMPARE3_Msk = 0x80000
	// Bit COMPARE3.
	RTC_EVTEN_COMPARE3 = 0x80000
	// Event disabled.
	RTC_EVTEN_COMPARE3_Disabled = 0x0
	// Event enabled.
	RTC_EVTEN_COMPARE3_Enabled = 0x1

	// EVTENSET: Enable events routing to PPI. The reading of this register gives the value of EVTEN.
	// Position of TICK field.
	RTC_EVTENSET_TICK_Pos = 0x0
	// Bit mask of TICK field.
	RTC_EVTENSET_TICK_Msk = 0x1
	// Bit TICK.
	RTC_EVTENSET_TICK = 0x1
	// Event disabled.
	RTC_EVTENSET_TICK_Disabled = 0x0
	// Event enabled.
	RTC_EVTENSET_TICK_Enabled = 0x1
	// Enable event on write.
	RTC_EVTENSET_TICK_Set = 0x1
	// Position of OVRFLW field.
	RTC_EVTENSET_OVRFLW_Pos = 0x1
	// Bit mask of OVRFLW field.
	RTC_EVTENSET_OVRFLW_Msk = 0x2
	// Bit OVRFLW.
	RTC_EVTENSET_OVRFLW = 0x2
	// Event disabled.
	RTC_EVTENSET_OVRFLW_Disabled = 0x0
	// Event enabled.
	RTC_EVTENSET_OVRFLW_Enabled = 0x1
	// Enable event on write.
	RTC_EVTENSET_OVRFLW_Set = 0x1
	// Position of COMPARE0 field.
	RTC_EVTENSET_COMPARE0_Pos = 0x10
	// Bit mask of COMPARE0 field.
	RTC_EVTENSET_COMPARE0_Msk = 0x10000
	// Bit COMPARE0.
	RTC_EVTENSET_COMPARE0 = 0x10000
	// Event disabled.
	RTC_EVTENSET_COMPARE0_Disabled = 0x0
	// Event enabled.
	RTC_EVTENSET_COMPARE0_Enabled = 0x1
	// Enable event on write.
	RTC_EVTENSET_COMPARE0_Set = 0x1
	// Position of COMPARE1 field.
	RTC_EVTENSET_COMPARE1_Pos = 0x11
	// Bit mask of COMPARE1 field.
	RTC_EVTENSET_COMPARE1_Msk = 0x20000
	// Bit COMPARE1.
	RTC_EVTENSET_COMPARE1 = 0x20000
	// Event disabled.
	RTC_EVTENSET_COMPARE1_Disabled = 0x0
	// Event enabled.
	RTC_EVTENSET_COMPARE1_Enabled = 0x1
	// Enable event on write.
	RTC_EVTENSET_COMPARE1_Set = 0x1
	// Position of COMPARE2 field.
	RTC_EVTENSET_COMPARE2_Pos = 0x12
	// Bit mask of COMPARE2 field.
	RTC_EVTENSET_COMPARE2_Msk = 0x40000
	// Bit COMPARE2.
	RTC_EVTENSET_COMPARE2 = 0x40000
	// Event disabled.
	RTC_EVTENSET_COMPARE2_Disabled = 0x0
	// Event enabled.
	RTC_EVTENSET_COMPARE2_Enabled = 0x1
	// Enable event on write.
	RTC_EVTENSET_COMPARE2_Set = 0x1
	// Position of COMPARE3 field.
	RTC_EVTENSET_COMPARE3_Pos = 0x13
	// Bit mask of COMPARE3 field.
	RTC_EVTENSET_COMPARE3_Msk = 0x80000
	// Bit COMPARE3.
	RTC_EVTENSET_COMPARE3 = 0x80000
	// Event disabled.
	RTC_EVTENSET_COMPARE3_Disabled = 0x0
	// Event enabled.
	RTC_EVTENSET_COMPARE3_Enabled = 0x1
	// Enable event on write.
	RTC_EVTENSET_COMPARE3_Set = 0x1

	// EVTENCLR: Disable events routing to PPI. The reading of this register gives the value of EVTEN.
	// Position of TICK field.
	RTC_EVTENCLR_TICK_Pos = 0x0
	// Bit mask of TICK field.
	RTC_EVTENCLR_TICK_Msk = 0x1
	// Bit TICK.
	RTC_EVTENCLR_TICK = 0x1
	// Event disabled.
	RTC_EVTENCLR_TICK_Disabled = 0x0
	// Event enabled.
	RTC_EVTENCLR_TICK_Enabled = 0x1
	// Disable event on write.
	RTC_EVTENCLR_TICK_Clear = 0x1
	// Position of OVRFLW field.
	RTC_EVTENCLR_OVRFLW_Pos = 0x1
	// Bit mask of OVRFLW field.
	RTC_EVTENCLR_OVRFLW_Msk = 0x2
	// Bit OVRFLW.
	RTC_EVTENCLR_OVRFLW = 0x2
	// Event disabled.
	RTC_EVTENCLR_OVRFLW_Disabled = 0x0
	// Event enabled.
	RTC_EVTENCLR_OVRFLW_Enabled = 0x1
	// Disable event on write.
	RTC_EVTENCLR_OVRFLW_Clear = 0x1
	// Position of COMPARE0 field.
	RTC_EVTENCLR_COMPARE0_Pos = 0x10
	// Bit mask of COMPARE0 field.
	RTC_EVTENCLR_COMPARE0_Msk = 0x10000
	// Bit COMPARE0.
	RTC_EVTENCLR_COMPARE0 = 0x10000
	// Event disabled.
	RTC_EVTENCLR_COMPARE0_Disabled = 0x0
	// Event enabled.
	RTC_EVTENCLR_COMPARE0_Enabled = 0x1
	// Disable event on write.
	RTC_EVTENCLR_COMPARE0_Clear = 0x1
	// Position of COMPARE1 field.
	RTC_EVTENCLR_COMPARE1_Pos = 0x11
	// Bit mask of COMPARE1 field.
	RTC_EVTENCLR_COMPARE1_Msk = 0x20000
	// Bit COMPARE1.
	RTC_EVTENCLR_COMPARE1 = 0x20000
	// Event disabled.
	RTC_EVTENCLR_COMPARE1_Disabled = 0x0
	// Event enabled.
	RTC_EVTENCLR_COMPARE1_Enabled = 0x1
	// Disable event on write.
	RTC_EVTENCLR_COMPARE1_Clear = 0x1
	// Position of COMPARE2 field.
	RTC_EVTENCLR_COMPARE2_Pos = 0x12
	// Bit mask of COMPARE2 field.
	RTC_EVTENCLR_COMPARE2_Msk = 0x40000
	// Bit COMPARE2.
	RTC_EVTENCLR_COMPARE2 = 0x40000
	// Event disabled.
	RTC_EVTENCLR_COMPARE2_Disabled = 0x0
	// Event enabled.
	RTC_EVTENCLR_COMPARE2_Enabled = 0x1
	// Disable event on write.
	RTC_EVTENCLR_COMPARE2_Clear = 0x1
	// Position of COMPARE3 field.
	RTC_EVTENCLR_COMPARE3_Pos = 0x13
	// Bit mask of COMPARE3 field.
	RTC_EVTENCLR_COMPARE3_Msk = 0x80000
	// Bit COMPARE3.
	RTC_EVTENCLR_COMPARE3 = 0x80000
	// Event disabled.
	RTC_EVTENCLR_COMPARE3_Disabled = 0x0
	// Event enabled.
	RTC_EVTENCLR_COMPARE3_Enabled = 0x1
	// Disable event on write.
	RTC_EVTENCLR_COMPARE3_Clear = 0x1

	// COUNTER: Current COUNTER value.
	// Position of COUNTER field.
	RTC_COUNTER_COUNTER_Pos = 0x0
	// Bit mask of COUNTER field.
	RTC_COUNTER_COUNTER_Msk = 0xffffff

	// PRESCALER: 12-bit prescaler for COUNTER frequency (32768/(PRESCALER+1)). Must be written when RTC is STOPed.
	// Position of PRESCALER field.
	RTC_PRESCALER_PRESCALER_Pos = 0x0
	// Bit mask of PRESCALER field.
	RTC_PRESCALER_PRESCALER_Msk = 0xfff

	// CC: Capture/compare registers.
	// Position of COMPARE field.
	RTC_CC_COMPARE_Pos = 0x0
	// Bit mask of COMPARE field.
	RTC_CC_COMPARE_Msk = 0xffffff

	// POWER: Peripheral power control.
	// Position of POWER field.
	RTC_POWER_POWER_Pos = 0x0
	// Bit mask of POWER field.
	RTC_POWER_POWER_Msk = 0x1
	// Bit POWER.
	RTC_POWER_POWER = 0x1
	// Module power disabled.
	RTC_POWER_POWER_Disabled = 0x0
	// Module power enabled.
	RTC_POWER_POWER_Enabled = 0x1
)

// Bitfields for TEMP: Temperature Sensor.
const (
	// INTENSET: Interrupt enable set register.
	// Position of DATARDY field.
	TEMP_INTENSET_DATARDY_Pos = 0x0
	// Bit mask of DATARDY field.
	TEMP_INTENSET_DATARDY_Msk = 0x1
	// Bit DATARDY.
	TEMP_INTENSET_DATARDY = 0x1
	// Interrupt disabled.
	TEMP_INTENSET_DATARDY_Disabled = 0x0
	// Interrupt enabled.
	TEMP_INTENSET_DATARDY_Enabled = 0x1
	// Enable interrupt on write.
	TEMP_INTENSET_DATARDY_Set = 0x1

	// INTENCLR: Interrupt enable clear register.
	// Position of DATARDY field.
	TEMP_INTENCLR_DATARDY_Pos = 0x0
	// Bit mask of DATARDY field.
	TEMP_INTENCLR_DATARDY_Msk = 0x1
	// Bit DATARDY.
	TEMP_INTENCLR_DATARDY = 0x1
	// Interrupt disabled.
	TEMP_INTENCLR_DATARDY_Disabled = 0x0
	// Interrupt enabled.
	TEMP_INTENCLR_DATARDY_Enabled = 0x1
	// Disable interrupt on write.
	TEMP_INTENCLR_DATARDY_Clear = 0x1

	// POWER: Peripheral power control.
	// Position of POWER field.
	TEMP_POWER_POWER_Pos = 0x0
	// Bit mask of POWER field.
	TEMP_POWER_POWER_Msk = 0x1
	// Bit POWER.
	TEMP_POWER_POWER = 0x1
	// Module power disabled.
	TEMP_POWER_POWER_Disabled = 0x0
	// Module power enabled.
	TEMP_POWER_POWER_Enabled = 0x1
)

// Bitfields for RNG: Random Number Generator.
const (
	// SHORTS: Shortcuts for the RNG.
	// Position of VALRDY_STOP field.
	RNG_SHORTS_VALRDY_STOP_Pos = 0x0
	// Bit mask of VALRDY_STOP field.
	RNG_SHORTS_VALRDY_STOP_Msk = 0x1
	// Bit VALRDY_STOP.
	RNG_SHORTS_VALRDY_STOP = 0x1
	// Shortcut disabled.
	RNG_SHORTS_VALRDY_STOP_Disabled = 0x0
	// Shortcut enabled.
	RNG_SHORTS_VALRDY_STOP_Enabled = 0x1

	// INTENSET: Interrupt enable set register
	// Position of VALRDY field.
	RNG_INTENSET_VALRDY_Pos = 0x0
	// Bit mask of VALRDY field.
	RNG_INTENSET_VALRDY_Msk = 0x1
	// Bit VALRDY.
	RNG_INTENSET_VALRDY = 0x1
	// Interrupt disabled.
	RNG_INTENSET_VALRDY_Disabled = 0x0
	// Interrupt enabled.
	RNG_INTENSET_VALRDY_Enabled = 0x1
	// Enable interrupt on write.
	RNG_INTENSET_VALRDY_Set = 0x1

	// INTENCLR: Interrupt enable clear register
	// Position of VALRDY field.
	RNG_INTENCLR_VALRDY_Pos = 0x0
	// Bit mask of VALRDY field.
	RNG_INTENCLR_VALRDY_Msk = 0x1
	// Bit VALRDY.
	RNG_INTENCLR_VALRDY = 0x1
	// Interrupt disabled.
	RNG_INTENCLR_VALRDY_Disabled = 0x0
	// Interrupt enabled.
	RNG_INTENCLR_VALRDY_Enabled = 0x1
	// Disable interrupt on write.
	RNG_INTENCLR_VALRDY_Clear = 0x1

	// CONFIG: Configuration register.
	// Position of DERCEN field.
	RNG_CONFIG_DERCEN_Pos = 0x0
	// Bit mask of DERCEN field.
	RNG_CONFIG_DERCEN_Msk = 0x1
	// Bit DERCEN.
	RNG_CONFIG_DERCEN = 0x1
	// Digital error correction disabled.
	RNG_CONFIG_DERCEN_Disabled = 0x0
	// Digital error correction enabled.
	RNG_CONFIG_DERCEN_Enabled = 0x1

	// VALUE: RNG random number.
	// Position of VALUE field.
	RNG_VALUE_VALUE_Pos = 0x0
	// Bit mask of VALUE field.
	RNG_VALUE_VALUE_Msk = 0xff

	// POWER: Peripheral power control.
	// Position of POWER field.
	RNG_POWER_POWER_Pos = 0x0
	// Bit mask of POWER field.
	RNG_POWER_POWER_Msk = 0x1
	// Bit POWER.
	RNG_POWER_POWER = 0x1
	// Module power disabled.
	RNG_POWER_POWER_Disabled = 0x0
	// Module power enabled.
	RNG_POWER_POWER_Enabled = 0x1
)

// Bitfields for ECB: AES ECB Mode Encryption.
const (
	// INTENSET: Interrupt enable set register.
	// Position of ENDECB field.
	ECB_INTENSET_ENDECB_Pos = 0x0
	// Bit mask of ENDECB field.
	ECB_INTENSET_ENDECB_Msk = 0x1
	// Bit ENDECB.
	ECB_INTENSET_ENDECB = 0x1
	// Interrupt disabled.
	ECB_INTENSET_ENDECB_Disabled = 0x0
	// Interrupt enabled.
	ECB_INTENSET_ENDECB_Enabled = 0x1
	// Enable interrupt on write.
	ECB_INTENSET_ENDECB_Set = 0x1
	// Position of ERRORECB field.
	ECB_INTENSET_ERRORECB_Pos = 0x1
	// Bit mask of ERRORECB field.
	ECB_INTENSET_ERRORECB_Msk = 0x2
	// Bit ERRORECB.
	ECB_INTENSET_ERRORECB = 0x2
	// Interrupt disabled.
	ECB_INTENSET_ERRORECB_Disabled = 0x0
	// Interrupt enabled.
	ECB_INTENSET_ERRORECB_Enabled = 0x1
	// Enable interrupt on write.
	ECB_INTENSET_ERRORECB_Set = 0x1

	// INTENCLR: Interrupt enable clear register.
	// Position of ENDECB field.
	ECB_INTENCLR_ENDECB_Pos = 0x0
	// Bit mask of ENDECB field.
	ECB_INTENCLR_ENDECB_Msk = 0x1
	// Bit ENDECB.
	ECB_INTENCLR_ENDECB = 0x1
	// Interrupt disabled.
	ECB_INTENCLR_ENDECB_Disabled = 0x0
	// Interrupt enabled.
	ECB_INTENCLR_ENDECB_Enabled = 0x1
	// Disable interrupt on write.
	ECB_INTENCLR_ENDECB_Clear = 0x1
	// Position of ERRORECB field.
	ECB_INTENCLR_ERRORECB_Pos = 0x1
	// Bit mask of ERRORECB field.
	ECB_INTENCLR_ERRORECB_Msk = 0x2
	// Bit ERRORECB.
	ECB_INTENCLR_ERRORECB = 0x2
	// Interrupt disabled.
	ECB_INTENCLR_ERRORECB_Disabled = 0x0
	// Interrupt enabled.
	ECB_INTENCLR_ERRORECB_Enabled = 0x1
	// Disable interrupt on write.
	ECB_INTENCLR_ERRORECB_Clear = 0x1

	// POWER: Peripheral power control.
	// Position of POWER field.
	ECB_POWER_POWER_Pos = 0x0
	// Bit mask of POWER field.
	ECB_POWER_POWER_Msk = 0x1
	// Bit POWER.
	ECB_POWER_POWER = 0x1
	// Module power disabled.
	ECB_POWER_POWER_Disabled = 0x0
	// Module power enabled.
	ECB_POWER_POWER_Enabled = 0x1
)

// Bitfields for AAR: Accelerated Address Resolver.
const (
	// INTENSET: Interrupt enable set register.
	// Position of END field.
	AAR_INTENSET_END_Pos = 0x0
	// Bit mask of END field.
	AAR_INTENSET_END_Msk = 0x1
	// Bit END.
	AAR_INTENSET_END = 0x1
	// Interrupt disabled.
	AAR_INTENSET_END_Disabled = 0x0
	// Interrupt enabled.
	AAR_INTENSET_END_Enabled = 0x1
	// Enable interrupt on write.
	AAR_INTENSET_END_Set = 0x1
	// Position of RESOLVED field.
	AAR_INTENSET_RESOLVED_Pos = 0x1
	// Bit mask of RESOLVED field.
	AAR_INTENSET_RESOLVED_Msk = 0x2
	// Bit RESOLVED.
	AAR_INTENSET_RESOLVED = 0x2
	// Interrupt disabled.
	AAR_INTENSET_RESOLVED_Disabled = 0x0
	// Interrupt enabled.
	AAR_INTENSET_RESOLVED_Enabled = 0x1
	// Enable interrupt on write.
	AAR_INTENSET_RESOLVED_Set = 0x1
	// Position of NOTRESOLVED field.
	AAR_INTENSET_NOTRESOLVED_Pos = 0x2
	// Bit mask of NOTRESOLVED field.
	AAR_INTENSET_NOTRESOLVED_Msk = 0x4
	// Bit NOTRESOLVED.
	AAR_INTENSET_NOTRESOLVED = 0x4
	// Interrupt disabled.
	AAR_INTENSET_NOTRESOLVED_Disabled = 0x0
	// Interrupt enabled.
	AAR_INTENSET_NOTRESOLVED_Enabled = 0x1
	// Enable interrupt on write.
	AAR_INTENSET_NOTRESOLVED_Set = 0x1

	// INTENCLR: Interrupt enable clear register.
	// Position of END field.
	AAR_INTENCLR_END_Pos = 0x0
	// Bit mask of END field.
	AAR_INTENCLR_END_Msk = 0x1
	// Bit END.
	AAR_INTENCLR_END = 0x1
	// Interrupt disabled.
	AAR_INTENCLR_END_Disabled = 0x0
	// Interrupt enabled.
	AAR_INTENCLR_END_Enabled = 0x1
	// Disable interrupt on write.
	AAR_INTENCLR_END_Clear = 0x1
	// Position of RESOLVED field.
	AAR_INTENCLR_RESOLVED_Pos = 0x1
	// Bit mask of RESOLVED field.
	AAR_INTENCLR_RESOLVED_Msk = 0x2
	// Bit RESOLVED.
	AAR_INTENCLR_RESOLVED = 0x2
	// Interrupt disabled.
	AAR_INTENCLR_RESOLVED_Disabled = 0x0
	// Interrupt enabled.
	AAR_INTENCLR_RESOLVED_Enabled = 0x1
	// Disable interrupt on write.
	AAR_INTENCLR_RESOLVED_Clear = 0x1
	// Position of NOTRESOLVED field.
	AAR_INTENCLR_NOTRESOLVED_Pos = 0x2
	// Bit mask of NOTRESOLVED field.
	AAR_INTENCLR_NOTRESOLVED_Msk = 0x4
	// Bit NOTRESOLVED.
	AAR_INTENCLR_NOTRESOLVED = 0x4
	// Interrupt disabled.
	AAR_INTENCLR_NOTRESOLVED_Disabled = 0x0
	// Interrupt enabled.
	AAR_INTENCLR_NOTRESOLVED_Enabled = 0x1
	// Disable interrupt on write.
	AAR_INTENCLR_NOTRESOLVED_Clear = 0x1

	// STATUS: Resolution status.
	// Position of STATUS field.
	AAR_STATUS_STATUS_Pos = 0x0
	// Bit mask of STATUS field.
	AAR_STATUS_STATUS_Msk = 0xf

	// ENABLE: Enable AAR.
	// Position of ENABLE field.
	AAR_ENABLE_ENABLE_Pos = 0x0
	// Bit mask of ENABLE field.
	AAR_ENABLE_ENABLE_Msk = 0x3
	// Disabled AAR.
	AAR_ENABLE_ENABLE_Disabled = 0x0
	// Enable AAR.
	AAR_ENABLE_ENABLE_Enabled = 0x3

	// NIRK: Number of Identity root Keys in the IRK data structure.
	// Position of NIRK field.
	AAR_NIRK_NIRK_Pos = 0x0
	// Bit mask of NIRK field.
	AAR_NIRK_NIRK_Msk = 0x1f

	// POWER: Peripheral power control.
	// Position of POWER field.
	AAR_POWER_POWER_Pos = 0x0
	// Bit mask of POWER field.
	AAR_POWER_POWER_Msk = 0x1
	// Bit POWER.
	AAR_POWER_POWER = 0x1
	// Module power disabled.
	AAR_POWER_POWER_Disabled = 0x0
	// Module power enabled.
	AAR_POWER_POWER_Enabled = 0x1
)

// Bitfields for CCM: AES CCM Mode Encryption.
const (
	// SHORTS: Shortcuts for the CCM.
	// Position of ENDKSGEN_CRYPT field.
	CCM_SHORTS_ENDKSGEN_CRYPT_Pos = 0x0
	// Bit mask of ENDKSGEN_CRYPT field.
	CCM_SHORTS_ENDKSGEN_CRYPT_Msk = 0x1
	// Bit ENDKSGEN_CRYPT.
	CCM_SHORTS_ENDKSGEN_CRYPT = 0x1
	// Shortcut disabled.
	CCM_SHORTS_ENDKSGEN_CRYPT_Disabled = 0x0
	// Shortcut enabled.
	CCM_SHORTS_ENDKSGEN_CRYPT_Enabled = 0x1

	// INTENSET: Interrupt enable set register.
	// Position of ENDKSGEN field.
	CCM_INTENSET_ENDKSGEN_Pos = 0x0
	// Bit mask of ENDKSGEN field.
	CCM_INTENSET_ENDKSGEN_Msk = 0x1
	// Bit ENDKSGEN.
	CCM_INTENSET_ENDKSGEN = 0x1
	// Interrupt disabled.
	CCM_INTENSET_ENDKSGEN_Disabled = 0x0
	// Interrupt enabled.
	CCM_INTENSET_ENDKSGEN_Enabled = 0x1
	// Enable interrupt on write.
	CCM_INTENSET_ENDKSGEN_Set = 0x1
	// Position of ENDCRYPT field.
	CCM_INTENSET_ENDCRYPT_Pos = 0x1
	// Bit mask of ENDCRYPT field.
	CCM_INTENSET_ENDCRYPT_Msk = 0x2
	// Bit ENDCRYPT.
	CCM_INTENSET_ENDCRYPT = 0x2
	// Interrupt disabled.
	CCM_INTENSET_ENDCRYPT_Disabled = 0x0
	// Interrupt enabled.
	CCM_INTENSET_ENDCRYPT_Enabled = 0x1
	// Enable interrupt on write.
	CCM_INTENSET_ENDCRYPT_Set = 0x1
	// Position of ERROR field.
	CCM_INTENSET_ERROR_Pos = 0x2
	// Bit mask of ERROR field.
	CCM_INTENSET_ERROR_Msk = 0x4
	// Bit ERROR.
	CCM_INTENSET_ERROR = 0x4
	// Interrupt disabled.
	CCM_INTENSET_ERROR_Disabled = 0x0
	// Interrupt enabled.
	CCM_INTENSET_ERROR_Enabled = 0x1
	// Enable interrupt on write.
	CCM_INTENSET_ERROR_Set = 0x1

	// INTENCLR: Interrupt enable clear register.
	// Position of ENDKSGEN field.
	CCM_INTENCLR_ENDKSGEN_Pos = 0x0
	// Bit mask of ENDKSGEN field.
	CCM_INTENCLR_ENDKSGEN_Msk = 0x1
	// Bit ENDKSGEN.
	CCM_INTENCLR_ENDKSGEN = 0x1
	// Interrupt disabled.
	CCM_INTENCLR_ENDKSGEN_Disabled = 0x0
	// Interrupt enabled.
	CCM_INTENCLR_ENDKSGEN_Enabled = 0x1
	// Disable interrupt on write.
	CCM_INTENCLR_ENDKSGEN_Clear = 0x1
	// Position of ENDCRYPT field.
	CCM_INTENCLR_ENDCRYPT_Pos = 0x1
	// Bit mask of ENDCRYPT field.
	CCM_INTENCLR_ENDCRYPT_Msk = 0x2
	// Bit ENDCRYPT.
	CCM_INTENCLR_ENDCRYPT = 0x2
	// Interrupt disabled.
	CCM_INTENCLR_ENDCRYPT_Disabled = 0x0
	// Interrupt enabled.
	CCM_INTENCLR_ENDCRYPT_Enabled = 0x1
	// Disable interrupt on write.
	CCM_INTENCLR_ENDCRYPT_Clear = 0x1
	// Position of ERROR field.
	CCM_INTENCLR_ERROR_Pos = 0x2
	// Bit mask of ERROR field.
	CCM_INTENCLR_ERROR_Msk = 0x4
	// Bit ERROR.
	CCM_INTENCLR_ERROR = 0x4
	// Interrupt disabled.
	CCM_INTENCLR_ERROR_Disabled = 0x0
	// Interrupt enabled.
	CCM_INTENCLR_ERROR_Enabled = 0x1
	// Disable interrupt on write.
	CCM_INTENCLR_ERROR_Clear = 0x1

	// MICSTATUS: CCM RX MIC check result.
	// Position of MICSTATUS field.
	CCM_MICSTATUS_MICSTATUS_Pos = 0x0
	// Bit mask of MICSTATUS field.
	CCM_MICSTATUS_MICSTATUS_Msk = 0x1
	// Bit MICSTATUS.
	CCM_MICSTATUS_MICSTATUS = 0x1
	// MIC check failed.
	CCM_MICSTATUS_MICSTATUS_CheckFailed = 0x0
	// MIC check passed.
	CCM_MICSTATUS_MICSTATUS_CheckPassed = 0x1

	// ENABLE: CCM enable.
	// Position of ENABLE field.
	CCM_ENABLE_ENABLE_Pos = 0x0
	// Bit mask of ENABLE field.
	CCM_ENABLE_ENABLE_Msk = 0x3
	// CCM is disabled.
	CCM_ENABLE_ENABLE_Disabled = 0x0
	// CCM is enabled.
	CCM_ENABLE_ENABLE_Enabled = 0x2

	// MODE: Operation mode.
	// Position of MODE field.
	CCM_MODE_MODE_Pos = 0x0
	// Bit mask of MODE field.
	CCM_MODE_MODE_Msk = 0x1
	// Bit MODE.
	CCM_MODE_MODE = 0x1
	// CCM mode TX
	CCM_MODE_MODE_Encryption = 0x0
	// CCM mode TX
	CCM_MODE_MODE_Decryption = 0x1

	// POWER: Peripheral power control.
	// Position of POWER field.
	CCM_POWER_POWER_Pos = 0x0
	// Bit mask of POWER field.
	CCM_POWER_POWER_Msk = 0x1
	// Bit POWER.
	CCM_POWER_POWER = 0x1
	// Module power disabled.
	CCM_POWER_POWER_Disabled = 0x0
	// Module power enabled.
	CCM_POWER_POWER_Enabled = 0x1
)

// Bitfields for WDT: Watchdog Timer.
const (
	// INTENSET: Interrupt enable set register.
	// Position of TIMEOUT field.
	WDT_INTENSET_TIMEOUT_Pos = 0x0
	// Bit mask of TIMEOUT field.
	WDT_INTENSET_TIMEOUT_Msk = 0x1
	// Bit TIMEOUT.
	WDT_INTENSET_TIMEOUT = 0x1
	// Interrupt disabled.
	WDT_INTENSET_TIMEOUT_Disabled = 0x0
	// Interrupt enabled.
	WDT_INTENSET_TIMEOUT_Enabled = 0x1
	// Enable interrupt on write.
	WDT_INTENSET_TIMEOUT_Set = 0x1

	// INTENCLR: Interrupt enable clear register.
	// Position of TIMEOUT field.
	WDT_INTENCLR_TIMEOUT_Pos = 0x0
	// Bit mask of TIMEOUT field.
	WDT_INTENCLR_TIMEOUT_Msk = 0x1
	// Bit TIMEOUT.
	WDT_INTENCLR_TIMEOUT = 0x1
	// Interrupt disabled.
	WDT_INTENCLR_TIMEOUT_Disabled = 0x0
	// Interrupt enabled.
	WDT_INTENCLR_TIMEOUT_Enabled = 0x1
	// Disable interrupt on write.
	WDT_INTENCLR_TIMEOUT_Clear = 0x1

	// RUNSTATUS: Watchdog running status.
	// Position of RUNSTATUS field.
	WDT_RUNSTATUS_RUNSTATUS_Pos = 0x0
	// Bit mask of RUNSTATUS field.
	WDT_RUNSTATUS_RUNSTATUS_Msk = 0x1
	// Bit RUNSTATUS.
	WDT_RUNSTATUS_RUNSTATUS = 0x1
	// Watchdog timer is not running.
	WDT_RUNSTATUS_RUNSTATUS_NotRunning = 0x0
	// Watchdog timer is running.
	WDT_RUNSTATUS_RUNSTATUS_Running = 0x1

	// REQSTATUS: Request status.
	// Position of RR0 field.
	WDT_REQSTATUS_RR0_Pos = 0x0
	// Bit mask of RR0 field.
	WDT_REQSTATUS_RR0_Msk = 0x1
	// Bit RR0.
	WDT_REQSTATUS_RR0 = 0x1
	// RR[0] register is not enabled or has already requested reload.
	WDT_REQSTATUS_RR0_DisabledOrRequested = 0x0
	// RR[0] register is enabled and has not jet requested.
	WDT_REQSTATUS_RR0_EnabledAndUnrequested = 0x1
	// Position of RR1 field.
	WDT_REQSTATUS_RR1_Pos = 0x1
	// Bit mask of RR1 field.
	WDT_REQSTATUS_RR1_Msk = 0x2
	// Bit RR1.
	WDT_REQSTATUS_RR1 = 0x2
	// RR[1] register is not enabled or has already requested reload.
	WDT_REQSTATUS_RR1_DisabledOrRequested = 0x0
	// RR[1] register is enabled and has not jet requested.
	WDT_REQSTATUS_RR1_EnabledAndUnrequested = 0x1
	// Position of RR2 field.
	WDT_REQSTATUS_RR2_Pos = 0x2
	// Bit mask of RR2 field.
	WDT_REQSTATUS_RR2_Msk = 0x4
	// Bit RR2.
	WDT_REQSTATUS_RR2 = 0x4
	// RR[2] register is not enabled or has already requested reload.
	WDT_REQSTATUS_RR2_DisabledOrRequested = 0x0
	// RR[2] register is enabled and has not jet requested.
	WDT_REQSTATUS_RR2_EnabledAndUnrequested = 0x1
	// Position of RR3 field.
	WDT_REQSTATUS_RR3_Pos = 0x3
	// Bit mask of RR3 field.
	WDT_REQSTATUS_RR3_Msk = 0x8
	// Bit RR3.
	WDT_REQSTATUS_RR3 = 0x8
	// RR[3] register is not enabled or has already requested reload.
	WDT_REQSTATUS_RR3_DisabledOrRequested = 0x0
	// RR[3] register is enabled and has not jet requested.
	WDT_REQSTATUS_RR3_EnabledAndUnrequested = 0x1
	// Position of RR4 field.
	WDT_REQSTATUS_RR4_Pos = 0x4
	// Bit mask of RR4 field.
	WDT_REQSTATUS_RR4_Msk = 0x10
	// Bit RR4.
	WDT_REQSTATUS_RR4 = 0x10
	// RR[4] register is not enabled or has already requested reload.
	WDT_REQSTATUS_RR4_DisabledOrRequested = 0x0
	// RR[4] register is enabled and has not jet requested.
	WDT_REQSTATUS_RR4_EnabledAndUnrequested = 0x1
	// Position of RR5 field.
	WDT_REQSTATUS_RR5_Pos = 0x5
	// Bit mask of RR5 field.
	WDT_REQSTATUS_RR5_Msk = 0x20
	// Bit RR5.
	WDT_REQSTATUS_RR5 = 0x20
	// RR[5] register is not enabled or has already requested reload.
	WDT_REQSTATUS_RR5_DisabledOrRequested = 0x0
	// RR[5] register is enabled and has not jet requested.
	WDT_REQSTATUS_RR5_EnabledAndUnrequested = 0x1
	// Position of RR6 field.
	WDT_REQSTATUS_RR6_Pos = 0x6
	// Bit mask of RR6 field.
	WDT_REQSTATUS_RR6_Msk = 0x40
	// Bit RR6.
	WDT_REQSTATUS_RR6 = 0x40
	// RR[6] register is not enabled or has already requested reload.
	WDT_REQSTATUS_RR6_DisabledOrRequested = 0x0
	// RR[6] register is enabled and has not jet requested.
	WDT_REQSTATUS_RR6_EnabledAndUnrequested = 0x1
	// Position of RR7 field.
	WDT_REQSTATUS_RR7_Pos = 0x7
	// Bit mask of RR7 field.
	WDT_REQSTATUS_RR7_Msk = 0x80
	// Bit RR7.
	WDT_REQSTATUS_RR7 = 0x80
	// RR[7] register is not enabled or has already requested reload.
	WDT_REQSTATUS_RR7_DisabledOrRequested = 0x0
	// RR[7] register is enabled and has not jet requested.
	WDT_REQSTATUS_RR7_EnabledAndUnrequested = 0x1

	// RREN: Reload request enable.
	// Position of RR0 field.
	WDT_RREN_RR0_Pos = 0x0
	// Bit mask of RR0 field.
	WDT_RREN_RR0_Msk = 0x1
	// Bit RR0.
	WDT_RREN_RR0 = 0x1
	// RR[0] register is disabled.
	WDT_RREN_RR0_Disabled = 0x0
	// RR[0] register is enabled.
	WDT_RREN_RR0_Enabled = 0x1
	// Position of RR1 field.
	WDT_RREN_RR1_Pos = 0x1
	// Bit mask of RR1 field.
	WDT_RREN_RR1_Msk = 0x2
	// Bit RR1.
	WDT_RREN_RR1 = 0x2
	// RR[1] register is disabled.
	WDT_RREN_RR1_Disabled = 0x0
	// RR[1] register is enabled.
	WDT_RREN_RR1_Enabled = 0x1
	// Position of RR2 field.
	WDT_RREN_RR2_Pos = 0x2
	// Bit mask of RR2 field.
	WDT_RREN_RR2_Msk = 0x4
	// Bit RR2.
	WDT_RREN_RR2 = 0x4
	// RR[2] register is disabled.
	WDT_RREN_RR2_Disabled = 0x0
	// RR[2] register is enabled.
	WDT_RREN_RR2_Enabled = 0x1
	// Position of RR3 field.
	WDT_RREN_RR3_Pos = 0x3
	// Bit mask of RR3 field.
	WDT_RREN_RR3_Msk = 0x8
	// Bit RR3.
	WDT_RREN_RR3 = 0x8
	// RR[3] register is disabled.
	WDT_RREN_RR3_Disabled = 0x0
	// RR[3] register is enabled.
	WDT_RREN_RR3_Enabled = 0x1
	// Position of RR4 field.
	WDT_RREN_RR4_Pos = 0x4
	// Bit mask of RR4 field.
	WDT_RREN_RR4_Msk = 0x10
	// Bit RR4.
	WDT_RREN_RR4 = 0x10
	// RR[4] register is disabled.
	WDT_RREN_RR4_Disabled = 0x0
	// RR[4] register is enabled.
	WDT_RREN_RR4_Enabled = 0x1
	// Position of RR5 field.
	WDT_RREN_RR5_Pos = 0x5
	// Bit mask of RR5 field.
	WDT_RREN_RR5_Msk = 0x20
	// Bit RR5.
	WDT_RREN_RR5 = 0x20
	// RR[5] register is disabled.
	WDT_RREN_RR5_Disabled = 0x0
	// RR[5] register is enabled.
	WDT_RREN_RR5_Enabled = 0x1
	// Position of RR6 field.
	WDT_RREN_RR6_Pos = 0x6
	// Bit mask of RR6 field.
	WDT_RREN_RR6_Msk = 0x40
	// Bit RR6.
	WDT_RREN_RR6 = 0x40
	// RR[6] register is disabled.
	WDT_RREN_RR6_Disabled = 0x0
	// RR[6] register is enabled.
	WDT_RREN_RR6_Enabled = 0x1
	// Position of RR7 field.
	WDT_RREN_RR7_Pos = 0x7
	// Bit mask of RR7 field.
	WDT_RREN_RR7_Msk = 0x80
	// Bit RR7.
	WDT_RREN_RR7 = 0x80
	// RR[7] register is disabled.
	WDT_RREN_RR7_Disabled = 0x0
	// RR[7] register is enabled.
	WDT_RREN_RR7_Enabled = 0x1

	// CONFIG: Configuration register.
	// Position of SLEEP field.
	WDT_CONFIG_SLEEP_Pos = 0x0
	// Bit mask of SLEEP field.
	WDT_CONFIG_SLEEP_Msk = 0x1
	// Bit SLEEP.
	WDT_CONFIG_SLEEP = 0x1
	// Pause watchdog while the CPU is asleep.
	WDT_CONFIG_SLEEP_Pause = 0x0
	// Do not pause watchdog while the CPU is asleep.
	WDT_CONFIG_SLEEP_Run = 0x1
	// Position of HALT field.
	WDT_CONFIG_HALT_Pos = 0x3
	// Bit mask of HALT field.
	WDT_CONFIG_HALT_Msk = 0x8
	// Bit HALT.
	WDT_CONFIG_HALT = 0x8
	// Pause watchdog while the CPU is halted by the debugger.
	WDT_CONFIG_HALT_Pause = 0x0
	// Do not pause watchdog while the CPU is halted by the debugger.
	WDT_CONFIG_HALT_Run = 0x1

	// RR: Reload requests registers.
	// Position of RR field.
	WDT_RR_RR_Pos = 0x0
	// Bit mask of RR field.
	WDT_RR_RR_Msk = 0xffffffff
	// Value to request a reload of the watchdog timer.
	WDT_RR_RR_Reload = 0x6e524635

	// POWER: Peripheral power control.
	// Position of POWER field.
	WDT_POWER_POWER_Pos = 0x0
	// Bit mask of POWER field.
	WDT_POWER_POWER_Msk = 0x1
	// Bit POWER.
	WDT_POWER_POWER = 0x1
	// Module power disabled.
	WDT_POWER_POWER_Disabled = 0x0
	// Module power enabled.
	WDT_POWER_POWER_Enabled = 0x1
)

// Bitfields for QDEC: Rotary decoder.
const (
	// SHORTS: Shortcuts for the QDEC.
	// Position of REPORTRDY_READCLRACC field.
	QDEC_SHORTS_REPORTRDY_READCLRACC_Pos = 0x0
	// Bit mask of REPORTRDY_READCLRACC field.
	QDEC_SHORTS_REPORTRDY_READCLRACC_Msk = 0x1
	// Bit REPORTRDY_READCLRACC.
	QDEC_SHORTS_REPORTRDY_READCLRACC = 0x1
	// Shortcut disabled.
	QDEC_SHORTS_REPORTRDY_READCLRACC_Disabled = 0x0
	// Shortcut enabled.
	QDEC_SHORTS_REPORTRDY_READCLRACC_Enabled = 0x1
	// Position of SAMPLERDY_STOP field.
	QDEC_SHORTS_SAMPLERDY_STOP_Pos = 0x1
	// Bit mask of SAMPLERDY_STOP field.
	QDEC_SHORTS_SAMPLERDY_STOP_Msk = 0x2
	// Bit SAMPLERDY_STOP.
	QDEC_SHORTS_SAMPLERDY_STOP = 0x2
	// Shortcut disabled.
	QDEC_SHORTS_SAMPLERDY_STOP_Disabled = 0x0
	// Shortcut enabled.
	QDEC_SHORTS_SAMPLERDY_STOP_Enabled = 0x1

	// INTENSET: Interrupt enable set register.
	// Position of SAMPLERDY field.
	QDEC_INTENSET_SAMPLERDY_Pos = 0x0
	// Bit mask of SAMPLERDY field.
	QDEC_INTENSET_SAMPLERDY_Msk = 0x1
	// Bit SAMPLERDY.
	QDEC_INTENSET_SAMPLERDY = 0x1
	// Interrupt disabled.
	QDEC_INTENSET_SAMPLERDY_Disabled = 0x0
	// Interrupt enabled.
	QDEC_INTENSET_SAMPLERDY_Enabled = 0x1
	// Enable interrupt on write.
	QDEC_INTENSET_SAMPLERDY_Set = 0x1
	// Position of REPORTRDY field.
	QDEC_INTENSET_REPORTRDY_Pos = 0x1
	// Bit mask of REPORTRDY field.
	QDEC_INTENSET_REPORTRDY_Msk = 0x2
	// Bit REPORTRDY.
	QDEC_INTENSET_REPORTRDY = 0x2
	// Interrupt disabled.
	QDEC_INTENSET_REPORTRDY_Disabled = 0x0
	// Interrupt enabled.
	QDEC_INTENSET_REPORTRDY_Enabled = 0x1
	// Enable interrupt on write.
	QDEC_INTENSET_REPORTRDY_Set = 0x1
	// Position of ACCOF field.
	QDEC_INTENSET_ACCOF_Pos = 0x2
	// Bit mask of ACCOF field.
	QDEC_INTENSET_ACCOF_Msk = 0x4
	// Bit ACCOF.
	QDEC_INTENSET_ACCOF = 0x4
	// Interrupt disabled.
	QDEC_INTENSET_ACCOF_Disabled = 0x0
	// Interrupt enabled.
	QDEC_INTENSET_ACCOF_Enabled = 0x1
	// Enable interrupt on write.
	QDEC_INTENSET_ACCOF_Set = 0x1

	// INTENCLR: Interrupt enable clear register.
	// Position of SAMPLERDY field.
	QDEC_INTENCLR_SAMPLERDY_Pos = 0x0
	// Bit mask of SAMPLERDY field.
	QDEC_INTENCLR_SAMPLERDY_Msk = 0x1
	// Bit SAMPLERDY.
	QDEC_INTENCLR_SAMPLERDY = 0x1
	// Interrupt disabled.
	QDEC_INTENCLR_SAMPLERDY_Disabled = 0x0
	// Interrupt enabled.
	QDEC_INTENCLR_SAMPLERDY_Enabled = 0x1
	// Disable interrupt on write.
	QDEC_INTENCLR_SAMPLERDY_Clear = 0x1
	// Position of REPORTRDY field.
	QDEC_INTENCLR_REPORTRDY_Pos = 0x1
	// Bit mask of REPORTRDY field.
	QDEC_INTENCLR_REPORTRDY_Msk = 0x2
	// Bit REPORTRDY.
	QDEC_INTENCLR_REPORTRDY = 0x2
	// Interrupt disabled.
	QDEC_INTENCLR_REPORTRDY_Disabled = 0x0
	// Interrupt enabled.
	QDEC_INTENCLR_REPORTRDY_Enabled = 0x1
	// Disable interrupt on write.
	QDEC_INTENCLR_REPORTRDY_Clear = 0x1
	// Position of ACCOF field.
	QDEC_INTENCLR_ACCOF_Pos = 0x2
	// Bit mask of ACCOF field.
	QDEC_INTENCLR_ACCOF_Msk = 0x4
	// Bit ACCOF.
	QDEC_INTENCLR_ACCOF = 0x4
	// Interrupt disabled.
	QDEC_INTENCLR_ACCOF_Disabled = 0x0
	// Interrupt enabled.
	QDEC_INTENCLR_ACCOF_Enabled = 0x1
	// Disable interrupt on write.
	QDEC_INTENCLR_ACCOF_Clear = 0x1

	// ENABLE: Enable the QDEC.
	// Position of ENABLE field.
	QDEC_ENABLE_ENABLE_Pos = 0x0
	// Bit mask of ENABLE field.
	QDEC_ENABLE_ENABLE_Msk = 0x1
	// Bit ENABLE.
	QDEC_ENABLE_ENABLE = 0x1
	// Disabled QDEC.
	QDEC_ENABLE_ENABLE_Disabled = 0x0
	// Enable QDEC.
	QDEC_ENABLE_ENABLE_Enabled = 0x1

	// LEDPOL: LED output pin polarity.
	// Position of LEDPOL field.
	QDEC_LEDPOL_LEDPOL_Pos = 0x0
	// Bit mask of LEDPOL field.
	QDEC_LEDPOL_LEDPOL_Msk = 0x1
	// Bit LEDPOL.
	QDEC_LEDPOL_LEDPOL = 0x1
	// LED output is active low.
	QDEC_LEDPOL_LEDPOL_ActiveLow = 0x0
	// LED output is active high.
	QDEC_LEDPOL_LEDPOL_ActiveHigh = 0x1

	// SAMPLEPER: Sample period.
	// Position of SAMPLEPER field.
	QDEC_SAMPLEPER_SAMPLEPER_Pos = 0x0
	// Bit mask of SAMPLEPER field.
	QDEC_SAMPLEPER_SAMPLEPER_Msk = 0x7
	// 128us sample period.
	QDEC_SAMPLEPER_SAMPLEPER_128us = 0x0
	// 256us sample period.
	QDEC_SAMPLEPER_SAMPLEPER_256us = 0x1
	// 512us sample period.
	QDEC_SAMPLEPER_SAMPLEPER_512us = 0x2
	// 1024us sample period.
	QDEC_SAMPLEPER_SAMPLEPER_1024us = 0x3
	// 2048us sample period.
	QDEC_SAMPLEPER_SAMPLEPER_2048us = 0x4
	// 4096us sample period.
	QDEC_SAMPLEPER_SAMPLEPER_4096us = 0x5
	// 8192us sample period.
	QDEC_SAMPLEPER_SAMPLEPER_8192us = 0x6
	// 16384us sample period.
	QDEC_SAMPLEPER_SAMPLEPER_16384us = 0x7

	// SAMPLE: Motion sample value.
	// Position of SAMPLE field.
	QDEC_SAMPLE_SAMPLE_Pos = 0x0
	// Bit mask of SAMPLE field.
	QDEC_SAMPLE_SAMPLE_Msk = 0xffffffff

	// REPORTPER: Number of samples to generate an EVENT_REPORTRDY.
	// Position of REPORTPER field.
	QDEC_REPORTPER_REPORTPER_Pos = 0x0
	// Bit mask of REPORTPER field.
	QDEC_REPORTPER_REPORTPER_Msk = 0x7
	// 10 samples per report.
	QDEC_REPORTPER_REPORTPER_10Smpl = 0x0
	// 40 samples per report.
	QDEC_REPORTPER_REPORTPER_40Smpl = 0x1
	// 80 samples per report.
	QDEC_REPORTPER_REPORTPER_80Smpl = 0x2
	// 120 samples per report.
	QDEC_REPORTPER_REPORTPER_120Smpl = 0x3
	// 160 samples per report.
	QDEC_REPORTPER_REPORTPER_160Smpl = 0x4
	// 200 samples per report.
	QDEC_REPORTPER_REPORTPER_200Smpl = 0x5
	// 240 samples per report.
	QDEC_REPORTPER_REPORTPER_240Smpl = 0x6
	// 280 samples per report.
	QDEC_REPORTPER_REPORTPER_280Smpl = 0x7

	// DBFEN: Enable debouncer input filters.
	// Position of DBFEN field.
	QDEC_DBFEN_DBFEN_Pos = 0x0
	// Bit mask of DBFEN field.
	QDEC_DBFEN_DBFEN_Msk = 0x1
	// Bit DBFEN.
	QDEC_DBFEN_DBFEN = 0x1
	// Debounce input filters disabled.
	QDEC_DBFEN_DBFEN_Disabled = 0x0
	// Debounce input filters enabled.
	QDEC_DBFEN_DBFEN_Enabled = 0x1

	// LEDPRE: Time LED is switched ON before the sample.
	// Position of LEDPRE field.
	QDEC_LEDPRE_LEDPRE_Pos = 0x0
	// Bit mask of LEDPRE field.
	QDEC_LEDPRE_LEDPRE_Msk = 0x1ff

	// ACCDBL: Accumulated double (error) transitions register.
	// Position of ACCDBL field.
	QDEC_ACCDBL_ACCDBL_Pos = 0x0
	// Bit mask of ACCDBL field.
	QDEC_ACCDBL_ACCDBL_Msk = 0xf

	// ACCDBLREAD: Snapshot of ACCDBL register. Value generated by the TASKS_READCLEACC task.
	// Position of ACCDBLREAD field.
	QDEC_ACCDBLREAD_ACCDBLREAD_Pos = 0x0
	// Bit mask of ACCDBLREAD field.
	QDEC_ACCDBLREAD_ACCDBLREAD_Msk = 0xf

	// POWER: Peripheral power control.
	// Position of POWER field.
	QDEC_POWER_POWER_Pos = 0x0
	// Bit mask of POWER field.
	QDEC_POWER_POWER_Msk = 0x1
	// Bit POWER.
	QDEC_POWER_POWER = 0x1
	// Module power disabled.
	QDEC_POWER_POWER_Disabled = 0x0
	// Module power enabled.
	QDEC_POWER_POWER_Enabled = 0x1
)

// Bitfields for LPCOMP: Low power comparator.
const (
	// SHORTS: Shortcuts for the LPCOMP.
	// Position of READY_SAMPLE field.
	LPCOMP_SHORTS_READY_SAMPLE_Pos = 0x0
	// Bit mask of READY_SAMPLE field.
	LPCOMP_SHORTS_READY_SAMPLE_Msk = 0x1
	// Bit READY_SAMPLE.
	LPCOMP_SHORTS_READY_SAMPLE = 0x1
	// Shortcut disabled.
	LPCOMP_SHORTS_READY_SAMPLE_Disabled = 0x0
	// Shortcut enabled.
	LPCOMP_SHORTS_READY_SAMPLE_Enabled = 0x1
	// Position of READY_STOP field.
	LPCOMP_SHORTS_READY_STOP_Pos = 0x1
	// Bit mask of READY_STOP field.
	LPCOMP_SHORTS_READY_STOP_Msk = 0x2
	// Bit READY_STOP.
	LPCOMP_SHORTS_READY_STOP = 0x2
	// Shortcut disabled.
	LPCOMP_SHORTS_READY_STOP_Disabled = 0x0
	// Shortcut enabled.
	LPCOMP_SHORTS_READY_STOP_Enabled = 0x1
	// Position of DOWN_STOP field.
	LPCOMP_SHORTS_DOWN_STOP_Pos = 0x2
	// Bit mask of DOWN_STOP field.
	LPCOMP_SHORTS_DOWN_STOP_Msk = 0x4
	// Bit DOWN_STOP.
	LPCOMP_SHORTS_DOWN_STOP = 0x4
	// Shortcut disabled.
	LPCOMP_SHORTS_DOWN_STOP_Disabled = 0x0
	// Shortcut enabled.
	LPCOMP_SHORTS_DOWN_STOP_Enabled = 0x1
	// Position of UP_STOP field.
	LPCOMP_SHORTS_UP_STOP_Pos = 0x3
	// Bit mask of UP_STOP field.
	LPCOMP_SHORTS_UP_STOP_Msk = 0x8
	// Bit UP_STOP.
	LPCOMP_SHORTS_UP_STOP = 0x8
	// Shortcut disabled.
	LPCOMP_SHORTS_UP_STOP_Disabled = 0x0
	// Shortcut enabled.
	LPCOMP_SHORTS_UP_STOP_Enabled = 0x1
	// Position of CROSS_STOP field.
	LPCOMP_SHORTS_CROSS_STOP_Pos = 0x4
	// Bit mask of CROSS_STOP field.
	LPCOMP_SHORTS_CROSS_STOP_Msk = 0x10
	// Bit CROSS_STOP.
	LPCOMP_SHORTS_CROSS_STOP = 0x10
	// Shortcut disabled.
	LPCOMP_SHORTS_CROSS_STOP_Disabled = 0x0
	// Shortcut enabled.
	LPCOMP_SHORTS_CROSS_STOP_Enabled = 0x1

	// INTENSET: Interrupt enable set register.
	// Position of READY field.
	LPCOMP_INTENSET_READY_Pos = 0x0
	// Bit mask of READY field.
	LPCOMP_INTENSET_READY_Msk = 0x1
	// Bit READY.
	LPCOMP_INTENSET_READY = 0x1
	// Interrupt disabled.
	LPCOMP_INTENSET_READY_Disabled = 0x0
	// Interrupt enabled.
	LPCOMP_INTENSET_READY_Enabled = 0x1
	// Enable interrupt on write.
	LPCOMP_INTENSET_READY_Set = 0x1
	// Position of DOWN field.
	LPCOMP_INTENSET_DOWN_Pos = 0x1
	// Bit mask of DOWN field.
	LPCOMP_INTENSET_DOWN_Msk = 0x2
	// Bit DOWN.
	LPCOMP_INTENSET_DOWN = 0x2
	// Interrupt disabled.
	LPCOMP_INTENSET_DOWN_Disabled = 0x0
	// Interrupt enabled.
	LPCOMP_INTENSET_DOWN_Enabled = 0x1
	// Enable interrupt on write.
	LPCOMP_INTENSET_DOWN_Set = 0x1
	// Position of UP field.
	LPCOMP_INTENSET_UP_Pos = 0x2
	// Bit mask of UP field.
	LPCOMP_INTENSET_UP_Msk = 0x4
	// Bit UP.
	LPCOMP_INTENSET_UP = 0x4
	// Interrupt disabled.
	LPCOMP_INTENSET_UP_Disabled = 0x0
	// Interrupt enabled.
	LPCOMP_INTENSET_UP_Enabled = 0x1
	// Enable interrupt on write.
	LPCOMP_INTENSET_UP_Set = 0x1
	// Position of CROSS field.
	LPCOMP_INTENSET_CROSS_Pos = 0x3
	// Bit mask of CROSS field.
	LPCOMP_INTENSET_CROSS_Msk = 0x8
	// Bit CROSS.
	LPCOMP_INTENSET_CROSS = 0x8
	// Interrupt disabled.
	LPCOMP_INTENSET_CROSS_Disabled = 0x0
	// Interrupt enabled.
	LPCOMP_INTENSET_CROSS_Enabled = 0x1
	// Enable interrupt on write.
	LPCOMP_INTENSET_CROSS_Set = 0x1

	// INTENCLR: Interrupt enable clear register.
	// Position of READY field.
	LPCOMP_INTENCLR_READY_Pos = 0x0
	// Bit mask of READY field.
	LPCOMP_INTENCLR_READY_Msk = 0x1
	// Bit READY.
	LPCOMP_INTENCLR_READY = 0x1
	// Interrupt disabled.
	LPCOMP_INTENCLR_READY_Disabled = 0x0
	// Interrupt enabled.
	LPCOMP_INTENCLR_READY_Enabled = 0x1
	// Disable interrupt on write.
	LPCOMP_INTENCLR_READY_Clear = 0x1
	// Position of DOWN field.
	LPCOMP_INTENCLR_DOWN_Pos = 0x1
	// Bit mask of DOWN field.
	LPCOMP_INTENCLR_DOWN_Msk = 0x2
	// Bit DOWN.
	LPCOMP_INTENCLR_DOWN = 0x2
	// Interrupt disabled.
	LPCOMP_INTENCLR_DOWN_Disabled = 0x0
	// Interrupt enabled.
	LPCOMP_INTENCLR_DOWN_Enabled = 0x1
	// Disable interrupt on write.
	LPCOMP_INTENCLR_DOWN_Clear = 0x1
	// Position of UP field.
	LPCOMP_INTENCLR_UP_Pos = 0x2
	// Bit mask of UP field.
	LPCOMP_INTENCLR_UP_Msk = 0x4
	// Bit UP.
	LPCOMP_INTENCLR_UP = 0x4
	// Interrupt disabled.
	LPCOMP_INTENCLR_UP_Disabled = 0x0
	// Interrupt enabled.
	LPCOMP_INTENCLR_UP_Enabled = 0x1
	// Disable interrupt on write.
	LPCOMP_INTENCLR_UP_Clear = 0x1
	// Position of CROSS field.
	LPCOMP_INTENCLR_CROSS_Pos = 0x3
	// Bit mask of CROSS field.
	LPCOMP_INTENCLR_CROSS_Msk = 0x8
	// Bit CROSS.
	LPCOMP_INTENCLR_CROSS = 0x8
	// Interrupt disabled.
	LPCOMP_INTENCLR_CROSS_Disabled = 0x0
	// Interrupt enabled.
	LPCOMP_INTENCLR_CROSS_Enabled = 0x1
	// Disable interrupt on write.
	LPCOMP_INTENCLR_CROSS_Clear = 0x1

	// RESULT: Result of last compare.
	// Position of RESULT field.
	LPCOMP_RESULT_RESULT_Pos = 0x0
	// Bit mask of RESULT field.
	LPCOMP_RESULT_RESULT_Msk = 0x1
	// Bit RESULT.
	LPCOMP_RESULT_RESULT = 0x1
	// Input voltage is bellow the reference threshold.
	LPCOMP_RESULT_RESULT_Below = 0x0
	// Input voltage is above the reference threshold.
	LPCOMP_RESULT_RESULT_Above = 0x1

	// ENABLE: Enable the LPCOMP.
	// Position of ENABLE field.
	LPCOMP_ENABLE_ENABLE_Pos = 0x0
	// Bit mask of ENABLE field.
	LPCOMP_ENABLE_ENABLE_Msk = 0x3
	// Disabled LPCOMP.
	LPCOMP_ENABLE_ENABLE_Disabled = 0x0
	// Enable LPCOMP.
	LPCOMP_ENABLE_ENABLE_Enabled = 0x1

	// PSEL: Input pin select.
	// Position of PSEL field.
	LPCOMP_PSEL_PSEL_Pos = 0x0
	// Bit mask of PSEL field.
	LPCOMP_PSEL_PSEL_Msk = 0x7
	// Use analog input 0 as analog input.
	LPCOMP_PSEL_PSEL_AnalogInput0 = 0x0
	// Use analog input 1 as analog input.
	LPCOMP_PSEL_PSEL_AnalogInput1 = 0x1
	// Use analog input 2 as analog input.
	LPCOMP_PSEL_PSEL_AnalogInput2 = 0x2
	// Use analog input 3 as analog input.
	LPCOMP_PSEL_PSEL_AnalogInput3 = 0x3
	// Use analog input 4 as analog input.
	LPCOMP_PSEL_PSEL_AnalogInput4 = 0x4
	// Use analog input 5 as analog input.
	LPCOMP_PSEL_PSEL_AnalogInput5 = 0x5
	// Use analog input 6 as analog input.
	LPCOMP_PSEL_PSEL_AnalogInput6 = 0x6
	// Use analog input 7 as analog input.
	LPCOMP_PSEL_PSEL_AnalogInput7 = 0x7

	// REFSEL: Reference select.
	// Position of REFSEL field.
	LPCOMP_REFSEL_REFSEL_Pos = 0x0
	// Bit mask of REFSEL field.
	LPCOMP_REFSEL_REFSEL_Msk = 0x7
	// Use supply with a 1/8 prescaler as reference.
	LPCOMP_REFSEL_REFSEL_SupplyOneEighthPrescaling = 0x0
	// Use supply with a 2/8 prescaler as reference.
	LPCOMP_REFSEL_REFSEL_SupplyTwoEighthsPrescaling = 0x1
	// Use supply with a 3/8 prescaler as reference.
	LPCOMP_REFSEL_REFSEL_SupplyThreeEighthsPrescaling = 0x2
	// Use supply with a 4/8 prescaler as reference.
	LPCOMP_REFSEL_REFSEL_SupplyFourEighthsPrescaling = 0x3
	// Use supply with a 5/8 prescaler as reference.
	LPCOMP_REFSEL_REFSEL_SupplyFiveEighthsPrescaling = 0x4
	// Use supply with a 6/8 prescaler as reference.
	LPCOMP_REFSEL_REFSEL_SupplySixEighthsPrescaling = 0x5
	// Use supply with a 7/8 prescaler as reference.
	LPCOMP_REFSEL_REFSEL_SupplySevenEighthsPrescaling = 0x6
	// Use external analog reference as reference.
	LPCOMP_REFSEL_REFSEL_ARef = 0x7

	// EXTREFSEL: External reference select.
	// Position of EXTREFSEL field.
	LPCOMP_EXTREFSEL_EXTREFSEL_Pos = 0x0
	// Bit mask of EXTREFSEL field.
	LPCOMP_EXTREFSEL_EXTREFSEL_Msk = 0x1
	// Bit EXTREFSEL.
	LPCOMP_EXTREFSEL_EXTREFSEL = 0x1
	// Use analog reference 0 as reference.
	LPCOMP_EXTREFSEL_EXTREFSEL_AnalogReference0 = 0x0
	// Use analog reference 1 as reference.
	LPCOMP_EXTREFSEL_EXTREFSEL_AnalogReference1 = 0x1

	// ANADETECT: Analog detect configuration.
	// Position of ANADETECT field.
	LPCOMP_ANADETECT_ANADETECT_Pos = 0x0
	// Bit mask of ANADETECT field.
	LPCOMP_ANADETECT_ANADETECT_Msk = 0x3
	// Generate ANADETEC on crossing, both upwards and downwards crossing.
	LPCOMP_ANADETECT_ANADETECT_Cross = 0x0
	// Generate ANADETEC on upwards crossing only.
	LPCOMP_ANADETECT_ANADETECT_Up = 0x1
	// Generate ANADETEC on downwards crossing only.
	LPCOMP_ANADETECT_ANADETECT_Down = 0x2

	// POWER: Peripheral power control.
	// Position of POWER field.
	LPCOMP_POWER_POWER_Pos = 0x0
	// Bit mask of POWER field.
	LPCOMP_POWER_POWER_Msk = 0x1
	// Bit POWER.
	LPCOMP_POWER_POWER = 0x1
	// Module power disabled.
	LPCOMP_POWER_POWER_Disabled = 0x0
	// Module power enabled.
	LPCOMP_POWER_POWER_Enabled = 0x1
)

// Bitfields for SWI: SW Interrupts.
const ()

// Bitfields for NVMC: Non Volatile Memory Controller.
const (
	// READY: Ready flag.
	// Position of READY field.
	NVMC_READY_READY_Pos = 0x0
	// Bit mask of READY field.
	NVMC_READY_READY_Msk = 0x1
	// Bit READY.
	NVMC_READY_READY = 0x1
	// NVMC is busy (on-going write or erase operation).
	NVMC_READY_READY_Busy = 0x0
	// NVMC is ready.
	NVMC_READY_READY_Ready = 0x1

	// CONFIG: Configuration register.
	// Position of WEN field.
	NVMC_CONFIG_WEN_Pos = 0x0
	// Bit mask of WEN field.
	NVMC_CONFIG_WEN_Msk = 0x3
	// Read only access.
	NVMC_CONFIG_WEN_Ren = 0x0
	// Write enabled.
	NVMC_CONFIG_WEN_Wen = 0x1
	// Erase enabled.
	NVMC_CONFIG_WEN_Een = 0x2

	// ERASEALL: Register for erasing all non-volatile user memory.
	// Position of ERASEALL field.
	NVMC_ERASEALL_ERASEALL_Pos = 0x0
	// Bit mask of ERASEALL field.
	NVMC_ERASEALL_ERASEALL_Msk = 0x1
	// Bit ERASEALL.
	NVMC_ERASEALL_ERASEALL = 0x1
	// No operation.
	NVMC_ERASEALL_ERASEALL_NoOperation = 0x0
	// Start chip erase.
	NVMC_ERASEALL_ERASEALL_Erase = 0x1

	// ERASEUICR: Register for start erasing User Information Congfiguration Registers.
	// Position of ERASEUICR field.
	NVMC_ERASEUICR_ERASEUICR_Pos = 0x0
	// Bit mask of ERASEUICR field.
	NVMC_ERASEUICR_ERASEUICR_Msk = 0x1
	// Bit ERASEUICR.
	NVMC_ERASEUICR_ERASEUICR = 0x1
	// No operation.
	NVMC_ERASEUICR_ERASEUICR_NoOperation = 0x0
	// Start UICR erase.
	NVMC_ERASEUICR_ERASEUICR_Erase = 0x1
)

// Bitfields for PPI: PPI controller.
const (
	// TASKS_CHG.EN: Enable channel group.

	// TASKS_CHG.DIS: Disable channel group.

	// CHEN: Channel enable.
	// Position of CH0 field.
	PPI_CHEN_CH0_Pos = 0x0
	// Bit mask of CH0 field.
	PPI_CHEN_CH0_Msk = 0x1
	// Bit CH0.
	PPI_CHEN_CH0 = 0x1
	// Channel disabled.
	PPI_CHEN_CH0_Disabled = 0x0
	// Channel enabled.
	PPI_CHEN_CH0_Enabled = 0x1
	// Position of CH1 field.
	PPI_CHEN_CH1_Pos = 0x1
	// Bit mask of CH1 field.
	PPI_CHEN_CH1_Msk = 0x2
	// Bit CH1.
	PPI_CHEN_CH1 = 0x2
	// Channel disabled.
	PPI_CHEN_CH1_Disabled = 0x0
	// Channel enabled.
	PPI_CHEN_CH1_Enabled = 0x1
	// Position of CH2 field.
	PPI_CHEN_CH2_Pos = 0x2
	// Bit mask of CH2 field.
	PPI_CHEN_CH2_Msk = 0x4
	// Bit CH2.
	PPI_CHEN_CH2 = 0x4
	// Channel disabled.
	PPI_CHEN_CH2_Disabled = 0x0
	// Channel enabled.
	PPI_CHEN_CH2_Enabled = 0x1
	// Position of CH3 field.
	PPI_CHEN_CH3_Pos = 0x3
	// Bit mask of CH3 field.
	PPI_CHEN_CH3_Msk = 0x8
	// Bit CH3.
	PPI_CHEN_CH3 = 0x8
	// Channel disabled
	PPI_CHEN_CH3_Disabled = 0x0
	// Channel enabled
	PPI_CHEN_CH3_Enabled = 0x1
	// Position of CH4 field.
	PPI_CHEN_CH4_Pos = 0x4
	// Bit mask of CH4 field.
	PPI_CHEN_CH4_Msk = 0x10
	// Bit CH4.
	PPI_CHEN_CH4 = 0x10
	// Channel disabled.
	PPI_CHEN_CH4_Disabled = 0x0
	// Channel enabled.
	PPI_CHEN_CH4_Enabled = 0x1
	// Position of CH5 field.
	PPI_CHEN_CH5_Pos = 0x5
	// Bit mask of CH5 field.
	PPI_CHEN_CH5_Msk = 0x20
	// Bit CH5.
	PPI_CHEN_CH5 = 0x20
	// Channel disabled.
	PPI_CHEN_CH5_Disabled = 0x0
	// Channel enabled.
	PPI_CHEN_CH5_Enabled = 0x1
	// Position of CH6 field.
	PPI_CHEN_CH6_Pos = 0x6
	// Bit mask of CH6 field.
	PPI_CHEN_CH6_Msk = 0x40
	// Bit CH6.
	PPI_CHEN_CH6 = 0x40
	// Channel disabled.
	PPI_CHEN_CH6_Disabled = 0x0
	// Channel enabled.
	PPI_CHEN_CH6_Enabled = 0x1
	// Position of CH7 field.
	PPI_CHEN_CH7_Pos = 0x7
	// Bit mask of CH7 field.
	PPI_CHEN_CH7_Msk = 0x80
	// Bit CH7.
	PPI_CHEN_CH7 = 0x80
	// Channel disabled.
	PPI_CHEN_CH7_Disabled = 0x0
	// Channel enabled.
	PPI_CHEN_CH7_Enabled = 0x1
	// Position of CH8 field.
	PPI_CHEN_CH8_Pos = 0x8
	// Bit mask of CH8 field.
	PPI_CHEN_CH8_Msk = 0x100
	// Bit CH8.
	PPI_CHEN_CH8 = 0x100
	// Channel disabled.
	PPI_CHEN_CH8_Disabled = 0x0
	// Channel enabled.
	PPI_CHEN_CH8_Enabled = 0x1
	// Position of CH9 field.
	PPI_CHEN_CH9_Pos = 0x9
	// Bit mask of CH9 field.
	PPI_CHEN_CH9_Msk = 0x200
	// Bit CH9.
	PPI_CHEN_CH9 = 0x200
	// Channel disabled.
	PPI_CHEN_CH9_Disabled = 0x0
	// Channel enabled.
	PPI_CHEN_CH9_Enabled = 0x1
	// Position of CH10 field.
	PPI_CHEN_CH10_Pos = 0xa
	// Bit mask of CH10 field.
	PPI_CHEN_CH10_Msk = 0x400
	// Bit CH10.
	PPI_CHEN_CH10 = 0x400
	// Channel disabled.
	PPI_CHEN_CH10_Disabled = 0x0
	// Channel enabled.
	PPI_CHEN_CH10_Enabled = 0x1
	// Position of CH11 field.
	PPI_CHEN_CH11_Pos = 0xb
	// Bit mask of CH11 field.
	PPI_CHEN_CH11_Msk = 0x800
	// Bit CH11.
	PPI_CHEN_CH11 = 0x800
	// Channel disabled.
	PPI_CHEN_CH11_Disabled = 0x0
	// Channel enabled.
	PPI_CHEN_CH11_Enabled = 0x1
	// Position of CH12 field.
	PPI_CHEN_CH12_Pos = 0xc
	// Bit mask of CH12 field.
	PPI_CHEN_CH12_Msk = 0x1000
	// Bit CH12.
	PPI_CHEN_CH12 = 0x1000
	// Channel disabled.
	PPI_CHEN_CH12_Disabled = 0x0
	// Channel enabled.
	PPI_CHEN_CH12_Enabled = 0x1
	// Position of CH13 field.
	PPI_CHEN_CH13_Pos = 0xd
	// Bit mask of CH13 field.
	PPI_CHEN_CH13_Msk = 0x2000
	// Bit CH13.
	PPI_CHEN_CH13 = 0x2000
	// Channel disabled.
	PPI_CHEN_CH13_Disabled = 0x0
	// Channel enabled.
	PPI_CHEN_CH13_Enabled = 0x1
	// Position of CH14 field.
	PPI_CHEN_CH14_Pos = 0xe
	// Bit mask of CH14 field.
	PPI_CHEN_CH14_Msk = 0x4000
	// Bit CH14.
	PPI_CHEN_CH14 = 0x4000
	// Channel disabled.
	PPI_CHEN_CH14_Disabled = 0x0
	// Channel enabled.
	PPI_CHEN_CH14_Enabled = 0x1
	// Position of CH15 field.
	PPI_CHEN_CH15_Pos = 0xf
	// Bit mask of CH15 field.
	PPI_CHEN_CH15_Msk = 0x8000
	// Bit CH15.
	PPI_CHEN_CH15 = 0x8000
	// Channel disabled.
	PPI_CHEN_CH15_Disabled = 0x0
	// Channel enabled.
	PPI_CHEN_CH15_Enabled = 0x1
	// Position of CH20 field.
	PPI_CHEN_CH20_Pos = 0x14
	// Bit mask of CH20 field.
	PPI_CHEN_CH20_Msk = 0x100000
	// Bit CH20.
	PPI_CHEN_CH20 = 0x100000
	// Channel disabled.
	PPI_CHEN_CH20_Disabled = 0x0
	// Channel enabled.
	PPI_CHEN_CH20_Enabled = 0x1
	// Position of CH21 field.
	PPI_CHEN_CH21_Pos = 0x15
	// Bit mask of CH21 field.
	PPI_CHEN_CH21_Msk = 0x200000
	// Bit CH21.
	PPI_CHEN_CH21 = 0x200000
	// Channel disabled.
	PPI_CHEN_CH21_Disabled = 0x0
	// Channel enabled.
	PPI_CHEN_CH21_Enabled = 0x1
	// Position of CH22 field.
	PPI_CHEN_CH22_Pos = 0x16
	// Bit mask of CH22 field.
	PPI_CHEN_CH22_Msk = 0x400000
	// Bit CH22.
	PPI_CHEN_CH22 = 0x400000
	// Channel disabled.
	PPI_CHEN_CH22_Disabled = 0x0
	// Channel enabled.
	PPI_CHEN_CH22_Enabled = 0x1
	// Position of CH23 field.
	PPI_CHEN_CH23_Pos = 0x17
	// Bit mask of CH23 field.
	PPI_CHEN_CH23_Msk = 0x800000
	// Bit CH23.
	PPI_CHEN_CH23 = 0x800000
	// Channel disabled.
	PPI_CHEN_CH23_Disabled = 0x0
	// Channel enabled.
	PPI_CHEN_CH23_Enabled = 0x1
	// Position of CH24 field.
	PPI_CHEN_CH24_Pos = 0x18
	// Bit mask of CH24 field.
	PPI_CHEN_CH24_Msk = 0x1000000
	// Bit CH24.
	PPI_CHEN_CH24 = 0x1000000
	// Channel disabled.
	PPI_CHEN_CH24_Disabled = 0x0
	// Channel enabled.
	PPI_CHEN_CH24_Enabled = 0x1
	// Position of CH25 field.
	PPI_CHEN_CH25_Pos = 0x19
	// Bit mask of CH25 field.
	PPI_CHEN_CH25_Msk = 0x2000000
	// Bit CH25.
	PPI_CHEN_CH25 = 0x2000000
	// Channel disabled.
	PPI_CHEN_CH25_Disabled = 0x0
	// Channel enabled.
	PPI_CHEN_CH25_Enabled = 0x1
	// Position of CH26 field.
	PPI_CHEN_CH26_Pos = 0x1a
	// Bit mask of CH26 field.
	PPI_CHEN_CH26_Msk = 0x4000000
	// Bit CH26.
	PPI_CHEN_CH26 = 0x4000000
	// Channel disabled.
	PPI_CHEN_CH26_Disabled = 0x0
	// Channel enabled.
	PPI_CHEN_CH26_Enabled = 0x1
	// Position of CH27 field.
	PPI_CHEN_CH27_Pos = 0x1b
	// Bit mask of CH27 field.
	PPI_CHEN_CH27_Msk = 0x8000000
	// Bit CH27.
	PPI_CHEN_CH27 = 0x8000000
	// Channel disabled.
	PPI_CHEN_CH27_Disabled = 0x0
	// Channel enabled.
	PPI_CHEN_CH27_Enabled = 0x1
	// Position of CH28 field.
	PPI_CHEN_CH28_Pos = 0x1c
	// Bit mask of CH28 field.
	PPI_CHEN_CH28_Msk = 0x10000000
	// Bit CH28.
	PPI_CHEN_CH28 = 0x10000000
	// Channel disabled.
	PPI_CHEN_CH28_Disabled = 0x0
	// Channel enabled.
	PPI_CHEN_CH28_Enabled = 0x1
	// Position of CH29 field.
	PPI_CHEN_CH29_Pos = 0x1d
	// Bit mask of CH29 field.
	PPI_CHEN_CH29_Msk = 0x20000000
	// Bit CH29.
	PPI_CHEN_CH29 = 0x20000000
	// Channel disabled.
	PPI_CHEN_CH29_Disabled = 0x0
	// Channel enabled.
	PPI_CHEN_CH29_Enabled = 0x1
	// Position of CH30 field.
	PPI_CHEN_CH30_Pos = 0x1e
	// Bit mask of CH30 field.
	PPI_CHEN_CH30_Msk = 0x40000000
	// Bit CH30.
	PPI_CHEN_CH30 = 0x40000000
	// Channel disabled.
	PPI_CHEN_CH30_Disabled = 0x0
	// Channel enabled.
	PPI_CHEN_CH30_Enabled = 0x1
	// Position of CH31 field.
	PPI_CHEN_CH31_Pos = 0x1f
	// Bit mask of CH31 field.
	PPI_CHEN_CH31_Msk = 0x80000000
	// Bit CH31.
	PPI_CHEN_CH31 = 0x80000000
	// Channel disabled.
	PPI_CHEN_CH31_Disabled = 0x0
	// Channel enabled.
	PPI_CHEN_CH31_Enabled = 0x1

	// CHENSET: Channel enable set.
	// Position of CH0 field.
	PPI_CHENSET_CH0_Pos = 0x0
	// Bit mask of CH0 field.
	PPI_CHENSET_CH0_Msk = 0x1
	// Bit CH0.
	PPI_CHENSET_CH0 = 0x1
	// Channel disabled.
	PPI_CHENSET_CH0_Disabled = 0x0
	// Channel enabled.
	PPI_CHENSET_CH0_Enabled = 0x1
	// Enable channel on write.
	PPI_CHENSET_CH0_Set = 0x1
	// Position of CH1 field.
	PPI_CHENSET_CH1_Pos = 0x1
	// Bit mask of CH1 field.
	PPI_CHENSET_CH1_Msk = 0x2
	// Bit CH1.
	PPI_CHENSET_CH1 = 0x2
	// Channel disabled.
	PPI_CHENSET_CH1_Disabled = 0x0
	// Channel enabled.
	PPI_CHENSET_CH1_Enabled = 0x1
	// Enable channel on write.
	PPI_CHENSET_CH1_Set = 0x1
	// Position of CH2 field.
	PPI_CHENSET_CH2_Pos = 0x2
	// Bit mask of CH2 field.
	PPI_CHENSET_CH2_Msk = 0x4
	// Bit CH2.
	PPI_CHENSET_CH2 = 0x4
	// Channel disabled.
	PPI_CHENSET_CH2_Disabled = 0x0
	// Channel enabled.
	PPI_CHENSET_CH2_Enabled = 0x1
	// Enable channel on write.
	PPI_CHENSET_CH2_Set = 0x1
	// Position of CH3 field.
	PPI_CHENSET_CH3_Pos = 0x3
	// Bit mask of CH3 field.
	PPI_CHENSET_CH3_Msk = 0x8
	// Bit CH3.
	PPI_CHENSET_CH3 = 0x8
	// Channel disabled.
	PPI_CHENSET_CH3_Disabled = 0x0
	// Channel enabled.
	PPI_CHENSET_CH3_Enabled = 0x1
	// Enable channel on write.
	PPI_CHENSET_CH3_Set = 0x1
	// Position of CH4 field.
	PPI_CHENSET_CH4_Pos = 0x4
	// Bit mask of CH4 field.
	PPI_CHENSET_CH4_Msk = 0x10
	// Bit CH4.
	PPI_CHENSET_CH4 = 0x10
	// Channel disabled.
	PPI_CHENSET_CH4_Disabled = 0x0
	// Channel enabled.
	PPI_CHENSET_CH4_Enabled = 0x1
	// Enable channel on write.
	PPI_CHENSET_CH4_Set = 0x1
	// Position of CH5 field.
	PPI_CHENSET_CH5_Pos = 0x5
	// Bit mask of CH5 field.
	PPI_CHENSET_CH5_Msk = 0x20
	// Bit CH5.
	PPI_CHENSET_CH5 = 0x20
	// Channel disabled.
	PPI_CHENSET_CH5_Disabled = 0x0
	// Channel enabled.
	PPI_CHENSET_CH5_Enabled = 0x1
	// Enable channel on write.
	PPI_CHENSET_CH5_Set = 0x1
	// Position of CH6 field.
	PPI_CHENSET_CH6_Pos = 0x6
	// Bit mask of CH6 field.
	PPI_CHENSET_CH6_Msk = 0x40
	// Bit CH6.
	PPI_CHENSET_CH6 = 0x40
	// Channel disabled.
	PPI_CHENSET_CH6_Disabled = 0x0
	// Channel enabled.
	PPI_CHENSET_CH6_Enabled = 0x1
	// Enable channel on write.
	PPI_CHENSET_CH6_Set = 0x1
	// Position of CH7 field.
	PPI_CHENSET_CH7_Pos = 0x7
	// Bit mask of CH7 field.
	PPI_CHENSET_CH7_Msk = 0x80
	// Bit CH7.
	PPI_CHENSET_CH7 = 0x80
	// Channel disabled.
	PPI_CHENSET_CH7_Disabled = 0x0
	// Channel enabled.
	PPI_CHENSET_CH7_Enabled = 0x1
	// Enable channel on write.
	PPI_CHENSET_CH7_Set = 0x1
	// Position of CH8 field.
	PPI_CHENSET_CH8_Pos = 0x8
	// Bit mask of CH8 field.
	PPI_CHENSET_CH8_Msk = 0x100
	// Bit CH8.
	PPI_CHENSET_CH8 = 0x100
	// Channel disabled.
	PPI_CHENSET_CH8_Disabled = 0x0
	// Channel enabled.
	PPI_CHENSET_CH8_Enabled = 0x1
	// Enable channel on write.
	PPI_CHENSET_CH8_Set = 0x1
	// Position of CH9 field.
	PPI_CHENSET_CH9_Pos = 0x9
	// Bit mask of CH9 field.
	PPI_CHENSET_CH9_Msk = 0x200
	// Bit CH9.
	PPI_CHENSET_CH9 = 0x200
	// Channel disabled.
	PPI_CHENSET_CH9_Disabled = 0x0
	// Channel enabled.
	PPI_CHENSET_CH9_Enabled = 0x1
	// Enable channel on write.
	PPI_CHENSET_CH9_Set = 0x1
	// Position of CH10 field.
	PPI_CHENSET_CH10_Pos = 0xa
	// Bit mask of CH10 field.
	PPI_CHENSET_CH10_Msk = 0x400
	// Bit CH10.
	PPI_CHENSET_CH10 = 0x400
	// Channel disabled.
	PPI_CHENSET_CH10_Disabled = 0x0
	// Channel enabled.
	PPI_CHENSET_CH10_Enabled = 0x1
	// Enable channel on write.
	PPI_CHENSET_CH10_Set = 0x1
	// Position of CH11 field.
	PPI_CHENSET_CH11_Pos = 0xb
	// Bit mask of CH11 field.
	PPI_CHENSET_CH11_Msk = 0x800
	// Bit CH11.
	PPI_CHENSET_CH11 = 0x800
	// Channel disabled.
	PPI_CHENSET_CH11_Disabled = 0x0
	// Channel enabled.
	PPI_CHENSET_CH11_Enabled = 0x1
	// Enable channel on write.
	PPI_CHENSET_CH11_Set = 0x1
	// Position of CH12 field.
	PPI_CHENSET_CH12_Pos = 0xc
	// Bit mask of CH12 field.
	PPI_CHENSET_CH12_Msk = 0x1000
	// Bit CH12.
	PPI_CHENSET_CH12 = 0x1000
	// Channel disabled.
	PPI_CHENSET_CH12_Disabled = 0x0
	// Channel enabled.
	PPI_CHENSET_CH12_Enabled = 0x1
	// Enable channel on write.
	PPI_CHENSET_CH12_Set = 0x1
	// Position of CH13 field.
	PPI_CHENSET_CH13_Pos = 0xd
	// Bit mask of CH13 field.
	PPI_CHENSET_CH13_Msk = 0x2000
	// Bit CH13.
	PPI_CHENSET_CH13 = 0x2000
	// Channel disabled.
	PPI_CHENSET_CH13_Disabled = 0x0
	// Channel enabled.
	PPI_CHENSET_CH13_Enabled = 0x1
	// Enable channel on write.
	PPI_CHENSET_CH13_Set = 0x1
	// Position of CH14 field.
	PPI_CHENSET_CH14_Pos = 0xe
	// Bit mask of CH14 field.
	PPI_CHENSET_CH14_Msk = 0x4000
	// Bit CH14.
	PPI_CHENSET_CH14 = 0x4000
	// Channel disabled.
	PPI_CHENSET_CH14_Disabled = 0x0
	// Channel enabled.
	PPI_CHENSET_CH14_Enabled = 0x1
	// Enable channel on write.
	PPI_CHENSET_CH14_Set = 0x1
	// Position of CH15 field.
	PPI_CHENSET_CH15_Pos = 0xf
	// Bit mask of CH15 field.
	PPI_CHENSET_CH15_Msk = 0x8000
	// Bit CH15.
	PPI_CHENSET_CH15 = 0x8000
	// Channel disabled.
	PPI_CHENSET_CH15_Disabled = 0x0
	// Channel enabled.
	PPI_CHENSET_CH15_Enabled = 0x1
	// Enable channel on write.
	PPI_CHENSET_CH15_Set = 0x1
	// Position of CH20 field.
	PPI_CHENSET_CH20_Pos = 0x14
	// Bit mask of CH20 field.
	PPI_CHENSET_CH20_Msk = 0x100000
	// Bit CH20.
	PPI_CHENSET_CH20 = 0x100000
	// Channel disabled.
	PPI_CHENSET_CH20_Disabled = 0x0
	// Channel enabled.
	PPI_CHENSET_CH20_Enabled = 0x1
	// Enable channel on write.
	PPI_CHENSET_CH20_Set = 0x1
	// Position of CH21 field.
	PPI_CHENSET_CH21_Pos = 0x15
	// Bit mask of CH21 field.
	PPI_CHENSET_CH21_Msk = 0x200000
	// Bit CH21.
	PPI_CHENSET_CH21 = 0x200000
	// Channel disabled.
	PPI_CHENSET_CH21_Disabled = 0x0
	// Channel enabled.
	PPI_CHENSET_CH21_Enabled = 0x1
	// Enable channel on write.
	PPI_CHENSET_CH21_Set = 0x1
	// Position of CH22 field.
	PPI_CHENSET_CH22_Pos = 0x16
	// Bit mask of CH22 field.
	PPI_CHENSET_CH22_Msk = 0x400000
	// Bit CH22.
	PPI_CHENSET_CH22 = 0x400000
	// Channel disabled.
	PPI_CHENSET_CH22_Disabled = 0x0
	// Channel enabled.
	PPI_CHENSET_CH22_Enabled = 0x1
	// Enable channel on write.
	PPI_CHENSET_CH22_Set = 0x1
	// Position of CH23 field.
	PPI_CHENSET_CH23_Pos = 0x17
	// Bit mask of CH23 field.
	PPI_CHENSET_CH23_Msk = 0x800000
	// Bit CH23.
	PPI_CHENSET_CH23 = 0x800000
	// Channel disabled.
	PPI_CHENSET_CH23_Disabled = 0x0
	// Channel enabled.
	PPI_CHENSET_CH23_Enabled = 0x1
	// Enable channel on write.
	PPI_CHENSET_CH23_Set = 0x1
	// Position of CH24 field.
	PPI_CHENSET_CH24_Pos = 0x18
	// Bit mask of CH24 field.
	PPI_CHENSET_CH24_Msk = 0x1000000
	// Bit CH24.
	PPI_CHENSET_CH24 = 0x1000000
	// Channel disabled.
	PPI_CHENSET_CH24_Disabled = 0x0
	// Channel enabled.
	PPI_CHENSET_CH24_Enabled = 0x1
	// Enable channel on write.
	PPI_CHENSET_CH24_Set = 0x1
	// Position of CH25 field.
	PPI_CHENSET_CH25_Pos = 0x19
	// Bit mask of CH25 field.
	PPI_CHENSET_CH25_Msk = 0x2000000
	// Bit CH25.
	PPI_CHENSET_CH25 = 0x2000000
	// Channel disabled.
	PPI_CHENSET_CH25_Disabled = 0x0
	// Channel enabled.
	PPI_CHENSET_CH25_Enabled = 0x1
	// Enable channel on write.
	PPI_CHENSET_CH25_Set = 0x1
	// Position of CH26 field.
	PPI_CHENSET_CH26_Pos = 0x1a
	// Bit mask of CH26 field.
	PPI_CHENSET_CH26_Msk = 0x4000000
	// Bit CH26.
	PPI_CHENSET_CH26 = 0x4000000
	// Channel disabled.
	PPI_CHENSET_CH26_Disabled = 0x0
	// Channel enabled.
	PPI_CHENSET_CH26_Enabled = 0x1
	// Enable channel on write.
	PPI_CHENSET_CH26_Set = 0x1
	// Position of CH27 field.
	PPI_CHENSET_CH27_Pos = 0x1b
	// Bit mask of CH27 field.
	PPI_CHENSET_CH27_Msk = 0x8000000
	// Bit CH27.
	PPI_CHENSET_CH27 = 0x8000000
	// Channel disabled.
	PPI_CHENSET_CH27_Disabled = 0x0
	// Channel enabled.
	PPI_CHENSET_CH27_Enabled = 0x1
	// Enable channel on write.
	PPI_CHENSET_CH27_Set = 0x1
	// Position of CH28 field.
	PPI_CHENSET_CH28_Pos = 0x1c
	// Bit mask of CH28 field.
	PPI_CHENSET_CH28_Msk = 0x10000000
	// Bit CH28.
	PPI_CHENSET_CH28 = 0x10000000
	// Channel disabled.
	PPI_CHENSET_CH28_Disabled = 0x0
	// Channel enabled.
	PPI_CHENSET_CH28_Enabled = 0x1
	// Enable channel on write.
	PPI_CHENSET_CH28_Set = 0x1
	// Position of CH29 field.
	PPI_CHENSET_CH29_Pos = 0x1d
	// Bit mask of CH29 field.
	PPI_CHENSET_CH29_Msk = 0x20000000
	// Bit CH29.
	PPI_CHENSET_CH29 = 0x20000000
	// Channel disabled.
	PPI_CHENSET_CH29_Disabled = 0x0
	// Channel enabled.
	PPI_CHENSET_CH29_Enabled = 0x1
	// Enable channel on write.
	PPI_CHENSET_CH29_Set = 0x1
	// Position of CH30 field.
	PPI_CHENSET_CH30_Pos = 0x1e
	// Bit mask of CH30 field.
	PPI_CHENSET_CH30_Msk = 0x40000000
	// Bit CH30.
	PPI_CHENSET_CH30 = 0x40000000
	// Channel disabled.
	PPI_CHENSET_CH30_Disabled = 0x0
	// Channel enabled.
	PPI_CHENSET_CH30_Enabled = 0x1
	// Enable channel on write.
	PPI_CHENSET_CH30_Set = 0x1
	// Position of CH31 field.
	PPI_CHENSET_CH31_Pos = 0x1f
	// Bit mask of CH31 field.
	PPI_CHENSET_CH31_Msk = 0x80000000
	// Bit CH31.
	PPI_CHENSET_CH31 = 0x80000000
	// Channel disabled.
	PPI_CHENSET_CH31_Disabled = 0x0
	// Channel enabled.
	PPI_CHENSET_CH31_Enabled = 0x1
	// Enable channel on write.
	PPI_CHENSET_CH31_Set = 0x1

	// CHENCLR: Channel enable clear.
	// Position of CH0 field.
	PPI_CHENCLR_CH0_Pos = 0x0
	// Bit mask of CH0 field.
	PPI_CHENCLR_CH0_Msk = 0x1
	// Bit CH0.
	PPI_CHENCLR_CH0 = 0x1
	// Channel disabled.
	PPI_CHENCLR_CH0_Disabled = 0x0
	// Channel enabled.
	PPI_CHENCLR_CH0_Enabled = 0x1
	// Disable channel on write.
	PPI_CHENCLR_CH0_Clear = 0x1
	// Position of CH1 field.
	PPI_CHENCLR_CH1_Pos = 0x1
	// Bit mask of CH1 field.
	PPI_CHENCLR_CH1_Msk = 0x2
	// Bit CH1.
	PPI_CHENCLR_CH1 = 0x2
	// Channel disabled.
	PPI_CHENCLR_CH1_Disabled = 0x0
	// Channel enabled.
	PPI_CHENCLR_CH1_Enabled = 0x1
	// Disable channel on write.
	PPI_CHENCLR_CH1_Clear = 0x1
	// Position of CH2 field.
	PPI_CHENCLR_CH2_Pos = 0x2
	// Bit mask of CH2 field.
	PPI_CHENCLR_CH2_Msk = 0x4
	// Bit CH2.
	PPI_CHENCLR_CH2 = 0x4
	// Channel disabled.
	PPI_CHENCLR_CH2_Disabled = 0x0
	// Channel enabled.
	PPI_CHENCLR_CH2_Enabled = 0x1
	// Disable channel on write.
	PPI_CHENCLR_CH2_Clear = 0x1
	// Position of CH3 field.
	PPI_CHENCLR_CH3_Pos = 0x3
	// Bit mask of CH3 field.
	PPI_CHENCLR_CH3_Msk = 0x8
	// Bit CH3.
	PPI_CHENCLR_CH3 = 0x8
	// Channel disabled.
	PPI_CHENCLR_CH3_Disabled = 0x0
	// Channel enabled.
	PPI_CHENCLR_CH3_Enabled = 0x1
	// Disable channel on write.
	PPI_CHENCLR_CH3_Clear = 0x1
	// Position of CH4 field.
	PPI_CHENCLR_CH4_Pos = 0x4
	// Bit mask of CH4 field.
	PPI_CHENCLR_CH4_Msk = 0x10
	// Bit CH4.
	PPI_CHENCLR_CH4 = 0x10
	// Channel disabled.
	PPI_CHENCLR_CH4_Disabled = 0x0
	// Channel enabled.
	PPI_CHENCLR_CH4_Enabled = 0x1
	// Disable channel on write.
	PPI_CHENCLR_CH4_Clear = 0x1
	// Position of CH5 field.
	PPI_CHENCLR_CH5_Pos = 0x5
	// Bit mask of CH5 field.
	PPI_CHENCLR_CH5_Msk = 0x20
	// Bit CH5.
	PPI_CHENCLR_CH5 = 0x20
	// Channel disabled.
	PPI_CHENCLR_CH5_Disabled = 0x0
	// Channel enabled.
	PPI_CHENCLR_CH5_Enabled = 0x1
	// Disable channel on write.
	PPI_CHENCLR_CH5_Clear = 0x1
	// Position of CH6 field.
	PPI_CHENCLR_CH6_Pos = 0x6
	// Bit mask of CH6 field.
	PPI_CHENCLR_CH6_Msk = 0x40
	// Bit CH6.
	PPI_CHENCLR_CH6 = 0x40
	// Channel disabled.
	PPI_CHENCLR_CH6_Disabled = 0x0
	// Channel enabled.
	PPI_CHENCLR_CH6_Enabled = 0x1
	// Disable channel on write.
	PPI_CHENCLR_CH6_Clear = 0x1
	// Position of CH7 field.
	PPI_CHENCLR_CH7_Pos = 0x7
	// Bit mask of CH7 field.
	PPI_CHENCLR_CH7_Msk = 0x80
	// Bit CH7.
	PPI_CHENCLR_CH7 = 0x80
	// Channel disabled.
	PPI_CHENCLR_CH7_Disabled = 0x0
	// Channel enabled.
	PPI_CHENCLR_CH7_Enabled = 0x1
	// Disable channel on write.
	PPI_CHENCLR_CH7_Clear = 0x1
	// Position of CH8 field.
	PPI_CHENCLR_CH8_Pos = 0x8
	// Bit mask of CH8 field.
	PPI_CHENCLR_CH8_Msk = 0x100
	// Bit CH8.
	PPI_CHENCLR_CH8 = 0x100
	// Channel disabled.
	PPI_CHENCLR_CH8_Disabled = 0x0
	// Channel enabled.
	PPI_CHENCLR_CH8_Enabled = 0x1
	// Disable channel on write.
	PPI_CHENCLR_CH8_Clear = 0x1
	// Position of CH9 field.
	PPI_CHENCLR_CH9_Pos = 0x9
	// Bit mask of CH9 field.
	PPI_CHENCLR_CH9_Msk = 0x200
	// Bit CH9.
	PPI_CHENCLR_CH9 = 0x200
	// Channel disabled.
	PPI_CHENCLR_CH9_Disabled = 0x0
	// Channel enabled.
	PPI_CHENCLR_CH9_Enabled = 0x1
	// Disable channel on write.
	PPI_CHENCLR_CH9_Clear = 0x1
	// Position of CH10 field.
	PPI_CHENCLR_CH10_Pos = 0xa
	// Bit mask of CH10 field.
	PPI_CHENCLR_CH10_Msk = 0x400
	// Bit CH10.
	PPI_CHENCLR_CH10 = 0x400
	// Channel disabled.
	PPI_CHENCLR_CH10_Disabled = 0x0
	// Channel enabled.
	PPI_CHENCLR_CH10_Enabled = 0x1
	// Disable channel on write.
	PPI_CHENCLR_CH10_Clear = 0x1
	// Position of CH11 field.
	PPI_CHENCLR_CH11_Pos = 0xb
	// Bit mask of CH11 field.
	PPI_CHENCLR_CH11_Msk = 0x800
	// Bit CH11.
	PPI_CHENCLR_CH11 = 0x800
	// Channel disabled.
	PPI_CHENCLR_CH11_Disabled = 0x0
	// Channel enabled.
	PPI_CHENCLR_CH11_Enabled = 0x1
	// Disable channel on write.
	PPI_CHENCLR_CH11_Clear = 0x1
	// Position of CH12 field.
	PPI_CHENCLR_CH12_Pos = 0xc
	// Bit mask of CH12 field.
	PPI_CHENCLR_CH12_Msk = 0x1000
	// Bit CH12.
	PPI_CHENCLR_CH12 = 0x1000
	// Channel disabled.
	PPI_CHENCLR_CH12_Disabled = 0x0
	// Channel enabled.
	PPI_CHENCLR_CH12_Enabled = 0x1
	// Disable channel on write.
	PPI_CHENCLR_CH12_Clear = 0x1
	// Position of CH13 field.
	PPI_CHENCLR_CH13_Pos = 0xd
	// Bit mask of CH13 field.
	PPI_CHENCLR_CH13_Msk = 0x2000
	// Bit CH13.
	PPI_CHENCLR_CH13 = 0x2000
	// Channel disabled.
	PPI_CHENCLR_CH13_Disabled = 0x0
	// Channel enabled.
	PPI_CHENCLR_CH13_Enabled = 0x1
	// Disable channel on write.
	PPI_CHENCLR_CH13_Clear = 0x1
	// Position of CH14 field.
	PPI_CHENCLR_CH14_Pos = 0xe
	// Bit mask of CH14 field.
	PPI_CHENCLR_CH14_Msk = 0x4000
	// Bit CH14.
	PPI_CHENCLR_CH14 = 0x4000
	// Channel disabled.
	PPI_CHENCLR_CH14_Disabled = 0x0
	// Channel enabled.
	PPI_CHENCLR_CH14_Enabled = 0x1
	// Disable channel on write.
	PPI_CHENCLR_CH14_Clear = 0x1
	// Position of CH15 field.
	PPI_CHENCLR_CH15_Pos = 0xf
	// Bit mask of CH15 field.
	PPI_CHENCLR_CH15_Msk = 0x8000
	// Bit CH15.
	PPI_CHENCLR_CH15 = 0x8000
	// Channel disabled.
	PPI_CHENCLR_CH15_Disabled = 0x0
	// Channel enabled.
	PPI_CHENCLR_CH15_Enabled = 0x1
	// Disable channel on write.
	PPI_CHENCLR_CH15_Clear = 0x1
	// Position of CH20 field.
	PPI_CHENCLR_CH20_Pos = 0x14
	// Bit mask of CH20 field.
	PPI_CHENCLR_CH20_Msk = 0x100000
	// Bit CH20.
	PPI_CHENCLR_CH20 = 0x100000
	// Channel disabled.
	PPI_CHENCLR_CH20_Disabled = 0x0
	// Channel enabled.
	PPI_CHENCLR_CH20_Enabled = 0x1
	// Disable channel on write.
	PPI_CHENCLR_CH20_Clear = 0x1
	// Position of CH21 field.
	PPI_CHENCLR_CH21_Pos = 0x15
	// Bit mask of CH21 field.
	PPI_CHENCLR_CH21_Msk = 0x200000
	// Bit CH21.
	PPI_CHENCLR_CH21 = 0x200000
	// Channel disabled.
	PPI_CHENCLR_CH21_Disabled = 0x0
	// Channel enabled.
	PPI_CHENCLR_CH21_Enabled = 0x1
	// Disable channel on write.
	PPI_CHENCLR_CH21_Clear = 0x1
	// Position of CH22 field.
	PPI_CHENCLR_CH22_Pos = 0x16
	// Bit mask of CH22 field.
	PPI_CHENCLR_CH22_Msk = 0x400000
	// Bit CH22.
	PPI_CHENCLR_CH22 = 0x400000
	// Channel disabled.
	PPI_CHENCLR_CH22_Disabled = 0x0
	// Channel enabled.
	PPI_CHENCLR_CH22_Enabled = 0x1
	// Disable channel on write.
	PPI_CHENCLR_CH22_Clear = 0x1
	// Position of CH23 field.
	PPI_CHENCLR_CH23_Pos = 0x17
	// Bit mask of CH23 field.
	PPI_CHENCLR_CH23_Msk = 0x800000
	// Bit CH23.
	PPI_CHENCLR_CH23 = 0x800000
	// Channel disabled.
	PPI_CHENCLR_CH23_Disabled = 0x0
	// Channel enabled.
	PPI_CHENCLR_CH23_Enabled = 0x1
	// Disable channel on write.
	PPI_CHENCLR_CH23_Clear = 0x1
	// Position of CH24 field.
	PPI_CHENCLR_CH24_Pos = 0x18
	// Bit mask of CH24 field.
	PPI_CHENCLR_CH24_Msk = 0x1000000
	// Bit CH24.
	PPI_CHENCLR_CH24 = 0x1000000
	// Channel disabled.
	PPI_CHENCLR_CH24_Disabled = 0x0
	// Channel enabled.
	PPI_CHENCLR_CH24_Enabled = 0x1
	// Disable channel on write.
	PPI_CHENCLR_CH24_Clear = 0x1
	// Position of CH25 field.
	PPI_CHENCLR_CH25_Pos = 0x19
	// Bit mask of CH25 field.
	PPI_CHENCLR_CH25_Msk = 0x2000000
	// Bit CH25.
	PPI_CHENCLR_CH25 = 0x2000000
	// Channel disabled.
	PPI_CHENCLR_CH25_Disabled = 0x0
	// Channel enabled.
	PPI_CHENCLR_CH25_Enabled = 0x1
	// Disable channel on write.
	PPI_CHENCLR_CH25_Clear = 0x1
	// Position of CH26 field.
	PPI_CHENCLR_CH26_Pos = 0x1a
	// Bit mask of CH26 field.
	PPI_CHENCLR_CH26_Msk = 0x4000000
	// Bit CH26.
	PPI_CHENCLR_CH26 = 0x4000000
	// Channel disabled.
	PPI_CHENCLR_CH26_Disabled = 0x0
	// Channel enabled.
	PPI_CHENCLR_CH26_Enabled = 0x1
	// Disable channel on write.
	PPI_CHENCLR_CH26_Clear = 0x1
	// Position of CH27 field.
	PPI_CHENCLR_CH27_Pos = 0x1b
	// Bit mask of CH27 field.
	PPI_CHENCLR_CH27_Msk = 0x8000000
	// Bit CH27.
	PPI_CHENCLR_CH27 = 0x8000000
	// Channel disabled.
	PPI_CHENCLR_CH27_Disabled = 0x0
	// Channel enabled.
	PPI_CHENCLR_CH27_Enabled = 0x1
	// Disable channel on write.
	PPI_CHENCLR_CH27_Clear = 0x1
	// Position of CH28 field.
	PPI_CHENCLR_CH28_Pos = 0x1c
	// Bit mask of CH28 field.
	PPI_CHENCLR_CH28_Msk = 0x10000000
	// Bit CH28.
	PPI_CHENCLR_CH28 = 0x10000000
	// Channel disabled.
	PPI_CHENCLR_CH28_Disabled = 0x0
	// Channel enabled.
	PPI_CHENCLR_CH28_Enabled = 0x1
	// Disable channel on write.
	PPI_CHENCLR_CH28_Clear = 0x1
	// Position of CH29 field.
	PPI_CHENCLR_CH29_Pos = 0x1d
	// Bit mask of CH29 field.
	PPI_CHENCLR_CH29_Msk = 0x20000000
	// Bit CH29.
	PPI_CHENCLR_CH29 = 0x20000000
	// Channel disabled.
	PPI_CHENCLR_CH29_Disabled = 0x0
	// Channel enabled.
	PPI_CHENCLR_CH29_Enabled = 0x1
	// Disable channel on write.
	PPI_CHENCLR_CH29_Clear = 0x1
	// Position of CH30 field.
	PPI_CHENCLR_CH30_Pos = 0x1e
	// Bit mask of CH30 field.
	PPI_CHENCLR_CH30_Msk = 0x40000000
	// Bit CH30.
	PPI_CHENCLR_CH30 = 0x40000000
	// Channel disabled.
	PPI_CHENCLR_CH30_Disabled = 0x0
	// Channel enabled.
	PPI_CHENCLR_CH30_Enabled = 0x1
	// Disable channel on write.
	PPI_CHENCLR_CH30_Clear = 0x1
	// Position of CH31 field.
	PPI_CHENCLR_CH31_Pos = 0x1f
	// Bit mask of CH31 field.
	PPI_CHENCLR_CH31_Msk = 0x80000000
	// Bit CH31.
	PPI_CHENCLR_CH31 = 0x80000000
	// Channel disabled.
	PPI_CHENCLR_CH31_Disabled = 0x0
	// Channel enabled.
	PPI_CHENCLR_CH31_Enabled = 0x1
	// Disable channel on write.
	PPI_CHENCLR_CH31_Clear = 0x1

	// CH.EEP: Channel event end-point.

	// CH.TEP: Channel task end-point.

	// CHG: Channel group configuration.
	// Position of CH0 field.
	PPI_CHG_CH0_Pos = 0x0
	// Bit mask of CH0 field.
	PPI_CHG_CH0_Msk = 0x1
	// Bit CH0.
	PPI_CHG_CH0 = 0x1
	// Channel excluded.
	PPI_CHG_CH0_Excluded = 0x0
	// Channel included.
	PPI_CHG_CH0_Included = 0x1
	// Position of CH1 field.
	PPI_CHG_CH1_Pos = 0x1
	// Bit mask of CH1 field.
	PPI_CHG_CH1_Msk = 0x2
	// Bit CH1.
	PPI_CHG_CH1 = 0x2
	// Channel excluded.
	PPI_CHG_CH1_Excluded = 0x0
	// Channel included.
	PPI_CHG_CH1_Included = 0x1
	// Position of CH2 field.
	PPI_CHG_CH2_Pos = 0x2
	// Bit mask of CH2 field.
	PPI_CHG_CH2_Msk = 0x4
	// Bit CH2.
	PPI_CHG_CH2 = 0x4
	// Channel excluded.
	PPI_CHG_CH2_Excluded = 0x0
	// Channel included.
	PPI_CHG_CH2_Included = 0x1
	// Position of CH3 field.
	PPI_CHG_CH3_Pos = 0x3
	// Bit mask of CH3 field.
	PPI_CHG_CH3_Msk = 0x8
	// Bit CH3.
	PPI_CHG_CH3 = 0x8
	// Channel excluded.
	PPI_CHG_CH3_Excluded = 0x0
	// Channel included.
	PPI_CHG_CH3_Included = 0x1
	// Position of CH4 field.
	PPI_CHG_CH4_Pos = 0x4
	// Bit mask of CH4 field.
	PPI_CHG_CH4_Msk = 0x10
	// Bit CH4.
	PPI_CHG_CH4 = 0x10
	// Channel excluded.
	PPI_CHG_CH4_Excluded = 0x0
	// Channel included.
	PPI_CHG_CH4_Included = 0x1
	// Position of CH5 field.
	PPI_CHG_CH5_Pos = 0x5
	// Bit mask of CH5 field.
	PPI_CHG_CH5_Msk = 0x20
	// Bit CH5.
	PPI_CHG_CH5 = 0x20
	// Channel excluded.
	PPI_CHG_CH5_Excluded = 0x0
	// Channel included.
	PPI_CHG_CH5_Included = 0x1
	// Position of CH6 field.
	PPI_CHG_CH6_Pos = 0x6
	// Bit mask of CH6 field.
	PPI_CHG_CH6_Msk = 0x40
	// Bit CH6.
	PPI_CHG_CH6 = 0x40
	// Channel excluded.
	PPI_CHG_CH6_Excluded = 0x0
	// Channel included.
	PPI_CHG_CH6_Included = 0x1
	// Position of CH7 field.
	PPI_CHG_CH7_Pos = 0x7
	// Bit mask of CH7 field.
	PPI_CHG_CH7_Msk = 0x80
	// Bit CH7.
	PPI_CHG_CH7 = 0x80
	// Channel excluded.
	PPI_CHG_CH7_Excluded = 0x0
	// Channel included.
	PPI_CHG_CH7_Included = 0x1
	// Position of CH8 field.
	PPI_CHG_CH8_Pos = 0x8
	// Bit mask of CH8 field.
	PPI_CHG_CH8_Msk = 0x100
	// Bit CH8.
	PPI_CHG_CH8 = 0x100
	// Channel excluded.
	PPI_CHG_CH8_Excluded = 0x0
	// Channel included.
	PPI_CHG_CH8_Included = 0x1
	// Position of CH9 field.
	PPI_CHG_CH9_Pos = 0x9
	// Bit mask of CH9 field.
	PPI_CHG_CH9_Msk = 0x200
	// Bit CH9.
	PPI_CHG_CH9 = 0x200
	// Channel excluded.
	PPI_CHG_CH9_Excluded = 0x0
	// Channel included.
	PPI_CHG_CH9_Included = 0x1
	// Position of CH10 field.
	PPI_CHG_CH10_Pos = 0xa
	// Bit mask of CH10 field.
	PPI_CHG_CH10_Msk = 0x400
	// Bit CH10.
	PPI_CHG_CH10 = 0x400
	// Channel excluded.
	PPI_CHG_CH10_Excluded = 0x0
	// Channel included.
	PPI_CHG_CH10_Included = 0x1
	// Position of CH11 field.
	PPI_CHG_CH11_Pos = 0xb
	// Bit mask of CH11 field.
	PPI_CHG_CH11_Msk = 0x800
	// Bit CH11.
	PPI_CHG_CH11 = 0x800
	// Channel excluded.
	PPI_CHG_CH11_Excluded = 0x0
	// Channel included.
	PPI_CHG_CH11_Included = 0x1
	// Position of CH12 field.
	PPI_CHG_CH12_Pos = 0xc
	// Bit mask of CH12 field.
	PPI_CHG_CH12_Msk = 0x1000
	// Bit CH12.
	PPI_CHG_CH12 = 0x1000
	// Channel excluded.
	PPI_CHG_CH12_Excluded = 0x0
	// Channel included.
	PPI_CHG_CH12_Included = 0x1
	// Position of CH13 field.
	PPI_CHG_CH13_Pos = 0xd
	// Bit mask of CH13 field.
	PPI_CHG_CH13_Msk = 0x2000
	// Bit CH13.
	PPI_CHG_CH13 = 0x2000
	// Channel excluded.
	PPI_CHG_CH13_Excluded = 0x0
	// Channel included.
	PPI_CHG_CH13_Included = 0x1
	// Position of CH14 field.
	PPI_CHG_CH14_Pos = 0xe
	// Bit mask of CH14 field.
	PPI_CHG_CH14_Msk = 0x4000
	// Bit CH14.
	PPI_CHG_CH14 = 0x4000
	// Channel excluded.
	PPI_CHG_CH14_Excluded = 0x0
	// Channel included.
	PPI_CHG_CH14_Included = 0x1
	// Position of CH15 field.
	PPI_CHG_CH15_Pos = 0xf
	// Bit mask of CH15 field.
	PPI_CHG_CH15_Msk = 0x8000
	// Bit CH15.
	PPI_CHG_CH15 = 0x8000
	// Channel excluded.
	PPI_CHG_CH15_Excluded = 0x0
	// Channel included.
	PPI_CHG_CH15_Included = 0x1
	// Position of CH20 field.
	PPI_CHG_CH20_Pos = 0x14
	// Bit mask of CH20 field.
	PPI_CHG_CH20_Msk = 0x100000
	// Bit CH20.
	PPI_CHG_CH20 = 0x100000
	// Channel excluded.
	PPI_CHG_CH20_Excluded = 0x0
	// Channel included.
	PPI_CHG_CH20_Included = 0x1
	// Position of CH21 field.
	PPI_CHG_CH21_Pos = 0x15
	// Bit mask of CH21 field.
	PPI_CHG_CH21_Msk = 0x200000
	// Bit CH21.
	PPI_CHG_CH21 = 0x200000
	// Channel excluded.
	PPI_CHG_CH21_Excluded = 0x0
	// Channel included.
	PPI_CHG_CH21_Included = 0x1
	// Position of CH22 field.
	PPI_CHG_CH22_Pos = 0x16
	// Bit mask of CH22 field.
	PPI_CHG_CH22_Msk = 0x400000
	// Bit CH22.
	PPI_CHG_CH22 = 0x400000
	// Channel excluded.
	PPI_CHG_CH22_Excluded = 0x0
	// Channel included.
	PPI_CHG_CH22_Included = 0x1
	// Position of CH23 field.
	PPI_CHG_CH23_Pos = 0x17
	// Bit mask of CH23 field.
	PPI_CHG_CH23_Msk = 0x800000
	// Bit CH23.
	PPI_CHG_CH23 = 0x800000
	// Channel excluded.
	PPI_CHG_CH23_Excluded = 0x0
	// Channel included.
	PPI_CHG_CH23_Included = 0x1
	// Position of CH24 field.
	PPI_CHG_CH24_Pos = 0x18
	// Bit mask of CH24 field.
	PPI_CHG_CH24_Msk = 0x1000000
	// Bit CH24.
	PPI_CHG_CH24 = 0x1000000
	// Channel excluded.
	PPI_CHG_CH24_Excluded = 0x0
	// Channel included.
	PPI_CHG_CH24_Included = 0x1
	// Position of CH25 field.
	PPI_CHG_CH25_Pos = 0x19
	// Bit mask of CH25 field.
	PPI_CHG_CH25_Msk = 0x2000000
	// Bit CH25.
	PPI_CHG_CH25 = 0x2000000
	// Channel excluded.
	PPI_CHG_CH25_Excluded = 0x0
	// Channel included.
	PPI_CHG_CH25_Included = 0x1
	// Position of CH26 field.
	PPI_CHG_CH26_Pos = 0x1a
	// Bit mask of CH26 field.
	PPI_CHG_CH26_Msk = 0x4000000
	// Bit CH26.
	PPI_CHG_CH26 = 0x4000000
	// Channel excluded.
	PPI_CHG_CH26_Excluded = 0x0
	// Channel included.
	PPI_CHG_CH26_Included = 0x1
	// Position of CH27 field.
	PPI_CHG_CH27_Pos = 0x1b
	// Bit mask of CH27 field.
	PPI_CHG_CH27_Msk = 0x8000000
	// Bit CH27.
	PPI_CHG_CH27 = 0x8000000
	// Channel excluded.
	PPI_CHG_CH27_Excluded = 0x0
	// Channel included.
	PPI_CHG_CH27_Included = 0x1
	// Position of CH28 field.
	PPI_CHG_CH28_Pos = 0x1c
	// Bit mask of CH28 field.
	PPI_CHG_CH28_Msk = 0x10000000
	// Bit CH28.
	PPI_CHG_CH28 = 0x10000000
	// Channel excluded.
	PPI_CHG_CH28_Excluded = 0x0
	// Channel included.
	PPI_CHG_CH28_Included = 0x1
	// Position of CH29 field.
	PPI_CHG_CH29_Pos = 0x1d
	// Bit mask of CH29 field.
	PPI_CHG_CH29_Msk = 0x20000000
	// Bit CH29.
	PPI_CHG_CH29 = 0x20000000
	// Channel excluded.
	PPI_CHG_CH29_Excluded = 0x0
	// Channel included.
	PPI_CHG_CH29_Included = 0x1
	// Position of CH30 field.
	PPI_CHG_CH30_Pos = 0x1e
	// Bit mask of CH30 field.
	PPI_CHG_CH30_Msk = 0x40000000
	// Bit CH30.
	PPI_CHG_CH30 = 0x40000000
	// Channel excluded.
	PPI_CHG_CH30_Excluded = 0x0
	// Channel included.
	PPI_CHG_CH30_Included = 0x1
	// Position of CH31 field.
	PPI_CHG_CH31_Pos = 0x1f
	// Bit mask of CH31 field.
	PPI_CHG_CH31_Msk = 0x80000000
	// Bit CH31.
	PPI_CHG_CH31 = 0x80000000
	// Channel excluded.
	PPI_CHG_CH31_Excluded = 0x0
	// Channel included.
	PPI_CHG_CH31_Included = 0x1
)

// Bitfields for FICR: Factory Information Configuration.
const (
	// PPFC: Pre-programmed factory code present.
	// Position of PPFC field.
	FICR_PPFC_PPFC_Pos = 0x0
	// Bit mask of PPFC field.
	FICR_PPFC_PPFC_Msk = 0xff
	// Not present.
	FICR_PPFC_PPFC_NotPresent = 0xff
	// Present.
	FICR_PPFC_PPFC_Present = 0x0

	// CONFIGID: Configuration identifier.
	// Position of HWID field.
	FICR_CONFIGID_HWID_Pos = 0x0
	// Bit mask of HWID field.
	FICR_CONFIGID_HWID_Msk = 0xffff
	// Position of FWID field.
	FICR_CONFIGID_FWID_Pos = 0x10
	// Bit mask of FWID field.
	FICR_CONFIGID_FWID_Msk = 0xffff0000

	// DEVICEADDRTYPE: Device address type.
	// Position of DEVICEADDRTYPE field.
	FICR_DEVICEADDRTYPE_DEVICEADDRTYPE_Pos = 0x0
	// Bit mask of DEVICEADDRTYPE field.
	FICR_DEVICEADDRTYPE_DEVICEADDRTYPE_Msk = 0x1
	// Bit DEVICEADDRTYPE.
	FICR_DEVICEADDRTYPE_DEVICEADDRTYPE = 0x1
	// Public address.
	FICR_DEVICEADDRTYPE_DEVICEADDRTYPE_Public = 0x0
	// Random address.
	FICR_DEVICEADDRTYPE_DEVICEADDRTYPE_Random = 0x1

	// OVERRIDEEN: Radio calibration override enable.
	// Position of NRF_1MBIT field.
	FICR_OVERRIDEEN_NRF_1MBIT_Pos = 0x0
	// Bit mask of NRF_1MBIT field.
	FICR_OVERRIDEEN_NRF_1MBIT_Msk = 0x1
	// Bit NRF_1MBIT.
	FICR_OVERRIDEEN_NRF_1MBIT = 0x1
	// Override the default values for NRF_1Mbit mode.
	FICR_OVERRIDEEN_NRF_1MBIT_Override = 0x0
	// Do not override the default values for NRF_1Mbit mode.
	FICR_OVERRIDEEN_NRF_1MBIT_NotOverride = 0x1
	// Position of BLE_1MBIT field.
	FICR_OVERRIDEEN_BLE_1MBIT_Pos = 0x3
	// Bit mask of BLE_1MBIT field.
	FICR_OVERRIDEEN_BLE_1MBIT_Msk = 0x8
	// Bit BLE_1MBIT.
	FICR_OVERRIDEEN_BLE_1MBIT = 0x8
	// Override the default values for BLE_1Mbit mode.
	FICR_OVERRIDEEN_BLE_1MBIT_Override = 0x0
	// Do not override the default values for BLE_1Mbit mode.
	FICR_OVERRIDEEN_BLE_1MBIT_NotOverride = 0x1
)

// Bitfields for UICR: User Information Configuration.
const (
	// RBPCONF: Readback protection configuration.
	// Position of PR0 field.
	UICR_RBPCONF_PR0_Pos = 0x0
	// Bit mask of PR0 field.
	UICR_RBPCONF_PR0_Msk = 0xff
	// Disabled.
	UICR_RBPCONF_PR0_Disabled = 0xff
	// Enabled.
	UICR_RBPCONF_PR0_Enabled = 0x0
	// Position of PALL field.
	UICR_RBPCONF_PALL_Pos = 0x8
	// Bit mask of PALL field.
	UICR_RBPCONF_PALL_Msk = 0xff00
	// Disabled.
	UICR_RBPCONF_PALL_Disabled = 0xff
	// Enabled.
	UICR_RBPCONF_PALL_Enabled = 0x0

	// XTALFREQ: Reset value for CLOCK XTALFREQ register.
	// Position of XTALFREQ field.
	UICR_XTALFREQ_XTALFREQ_Pos = 0x0
	// Bit mask of XTALFREQ field.
	UICR_XTALFREQ_XTALFREQ_Msk = 0xff
	// 16MHz Xtal is used.
	UICR_XTALFREQ_XTALFREQ_16MHz = 0xff
	// 32MHz Xtal is used.
	UICR_XTALFREQ_XTALFREQ_32MHz = 0x0

	// FWID: Firmware ID.
	// Position of FWID field.
	UICR_FWID_FWID_Pos = 0x0
	// Bit mask of FWID field.
	UICR_FWID_FWID_Msk = 0xffff
)

// Bitfields for GPIO: General purpose input and output.
const (
	// OUT: Write GPIO port.
	// Position of PIN0 field.
	GPIO_OUT_PIN0_Pos = 0x0
	// Bit mask of PIN0 field.
	GPIO_OUT_PIN0_Msk = 0x1
	// Bit PIN0.
	GPIO_OUT_PIN0 = 0x1
	// Pin driver is low.
	GPIO_OUT_PIN0_Low = 0x0
	// Pin driver is high.
	GPIO_OUT_PIN0_High = 0x1
	// Position of PIN1 field.
	GPIO_OUT_PIN1_Pos = 0x1
	// Bit mask of PIN1 field.
	GPIO_OUT_PIN1_Msk = 0x2
	// Bit PIN1.
	GPIO_OUT_PIN1 = 0x2
	// Pin driver is low.
	GPIO_OUT_PIN1_Low = 0x0
	// Pin driver is high.
	GPIO_OUT_PIN1_High = 0x1
	// Position of PIN2 field.
	GPIO_OUT_PIN2_Pos = 0x2
	// Bit mask of PIN2 field.
	GPIO_OUT_PIN2_Msk = 0x4
	// Bit PIN2.
	GPIO_OUT_PIN2 = 0x4
	// Pin driver is low.
	GPIO_OUT_PIN2_Low = 0x0
	// Pin driver is high.
	GPIO_OUT_PIN2_High = 0x1
	// Position of PIN3 field.
	GPIO_OUT_PIN3_Pos = 0x3
	// Bit mask of PIN3 field.
	GPIO_OUT_PIN3_Msk = 0x8
	// Bit PIN3.
	GPIO_OUT_PIN3 = 0x8
	// Pin driver is low.
	GPIO_OUT_PIN3_Low = 0x0
	// Pin driver is high.
	GPIO_OUT_PIN3_High = 0x1
	// Position of PIN4 field.
	GPIO_OUT_PIN4_Pos = 0x4
	// Bit mask of PIN4 field.
	GPIO_OUT_PIN4_Msk = 0x10
	// Bit PIN4.
	GPIO_OUT_PIN4 = 0x10
	// Pin driver is low.
	GPIO_OUT_PIN4_Low = 0x0
	// Pin driver is high.
	GPIO_OUT_PIN4_High = 0x1
	// Position of PIN5 field.
	GPIO_OUT_PIN5_Pos = 0x5
	// Bit mask of PIN5 field.
	GPIO_OUT_PIN5_Msk = 0x20
	// Bit PIN5.
	GPIO_OUT_PIN5 = 0x20
	// Pin driver is low.
	GPIO_OUT_PIN5_Low = 0x0
	// Pin driver is high.
	GPIO_OUT_PIN5_High = 0x1
	// Position of PIN6 field.
	GPIO_OUT_PIN6_Pos = 0x6
	// Bit mask of PIN6 field.
	GPIO_OUT_PIN6_Msk = 0x40
	// Bit PIN6.
	GPIO_OUT_PIN6 = 0x40
	// Pin driver is low.
	GPIO_OUT_PIN6_Low = 0x0
	// Pin driver is high.
	GPIO_OUT_PIN6_High = 0x1
	// Position of PIN7 field.
	GPIO_OUT_PIN7_Pos = 0x7
	// Bit mask of PIN7 field.
	GPIO_OUT_PIN7_Msk = 0x80
	// Bit PIN7.
	GPIO_OUT_PIN7 = 0x80
	// Pin driver is low.
	GPIO_OUT_PIN7_Low = 0x0
	// Pin driver is high.
	GPIO_OUT_PIN7_High = 0x1
	// Position of PIN8 field.
	GPIO_OUT_PIN8_Pos = 0x8
	// Bit mask of PIN8 field.
	GPIO_OUT_PIN8_Msk = 0x100
	// Bit PIN8.
	GPIO_OUT_PIN8 = 0x100
	// Pin driver is low.
	GPIO_OUT_PIN8_Low = 0x0
	// Pin driver is high.
	GPIO_OUT_PIN8_High = 0x1
	// Position of PIN9 field.
	GPIO_OUT_PIN9_Pos = 0x9
	// Bit mask of PIN9 field.
	GPIO_OUT_PIN9_Msk = 0x200
	// Bit PIN9.
	GPIO_OUT_PIN9 = 0x200
	// Pin driver is low.
	GPIO_OUT_PIN9_Low = 0x0
	// Pin driver is high.
	GPIO_OUT_PIN9_High = 0x1
	// Position of PIN10 field.
	GPIO_OUT_PIN10_Pos = 0xa
	// Bit mask of PIN10 field.
	GPIO_OUT_PIN10_Msk = 0x400
	// Bit PIN10.
	GPIO_OUT_PIN10 = 0x400
	// Pin driver is low.
	GPIO_OUT_PIN10_Low = 0x0
	// Pin driver is high.
	GPIO_OUT_PIN10_High = 0x1
	// Position of PIN11 field.
	GPIO_OUT_PIN11_Pos = 0xb
	// Bit mask of PIN11 field.
	GPIO_OUT_PIN11_Msk = 0x800
	// Bit PIN11.
	GPIO_OUT_PIN11 = 0x800
	// Pin driver is low.
	GPIO_OUT_PIN11_Low = 0x0
	// Pin driver is high.
	GPIO_OUT_PIN11_High = 0x1
	// Position of PIN12 field.
	GPIO_OUT_PIN12_Pos = 0xc
	// Bit mask of PIN12 field.
	GPIO_OUT_PIN12_Msk = 0x1000
	// Bit PIN12.
	GPIO_OUT_PIN12 = 0x1000
	// Pin driver is low.
	GPIO_OUT_PIN12_Low = 0x0
	// Pin driver is high.
	GPIO_OUT_PIN12_High = 0x1
	// Position of PIN13 field.
	GPIO_OUT_PIN13_Pos = 0xd
	// Bit mask of PIN13 field.
	GPIO_OUT_PIN13_Msk = 0x2000
	// Bit PIN13.
	GPIO_OUT_PIN13 = 0x2000
	// Pin driver is low.
	GPIO_OUT_PIN13_Low = 0x0
	// Pin driver is high.
	GPIO_OUT_PIN13_High = 0x1
	// Position of PIN14 field.
	GPIO_OUT_PIN14_Pos = 0xe
	// Bit mask of PIN14 field.
	GPIO_OUT_PIN14_Msk = 0x4000
	// Bit PIN14.
	GPIO_OUT_PIN14 = 0x4000
	// Pin driver is low.
	GPIO_OUT_PIN14_Low = 0x0
	// Pin driver is high.
	GPIO_OUT_PIN14_High = 0x1
	// Position of PIN15 field.
	GPIO_OUT_PIN15_Pos = 0xf
	// Bit mask of PIN15 field.
	GPIO_OUT_PIN15_Msk = 0x8000
	// Bit PIN15.
	GPIO_OUT_PIN15 = 0x8000
	// Pin driver is low.
	GPIO_OUT_PIN15_Low = 0x0
	// Pin driver is high.
	GPIO_OUT_PIN15_High = 0x1
	// Position of PIN16 field.
	GPIO_OUT_PIN16_Pos = 0x10
	// Bit mask of PIN16 field.
	GPIO_OUT_PIN16_Msk = 0x10000
	// Bit PIN16.
	GPIO_OUT_PIN16 = 0x10000
	// Pin driver is low.
	GPIO_OUT_PIN16_Low = 0x0
	// Pin driver is high.
	GPIO_OUT_PIN16_High = 0x1
	// Position of PIN17 field.
	GPIO_OUT_PIN17_Pos = 0x11
	// Bit mask of PIN17 field.
	GPIO_OUT_PIN17_Msk = 0x20000
	// Bit PIN17.
	GPIO_OUT_PIN17 = 0x20000
	// Pin driver is low.
	GPIO_OUT_PIN17_Low = 0x0
	// Pin driver is high.
	GPIO_OUT_PIN17_High = 0x1
	// Position of PIN18 field.
	GPIO_OUT_PIN18_Pos = 0x12
	// Bit mask of PIN18 field.
	GPIO_OUT_PIN18_Msk = 0x40000
	// Bit PIN18.
	GPIO_OUT_PIN18 = 0x40000
	// Pin driver is low.
	GPIO_OUT_PIN18_Low = 0x0
	// Pin driver is high.
	GPIO_OUT_PIN18_High = 0x1
	// Position of PIN19 field.
	GPIO_OUT_PIN19_Pos = 0x13
	// Bit mask of PIN19 field.
	GPIO_OUT_PIN19_Msk = 0x80000
	// Bit PIN19.
	GPIO_OUT_PIN19 = 0x80000
	// Pin driver is low.
	GPIO_OUT_PIN19_Low = 0x0
	// Pin driver is high.
	GPIO_OUT_PIN19_High = 0x1
	// Position of PIN20 field.
	GPIO_OUT_PIN20_Pos = 0x14
	// Bit mask of PIN20 field.
	GPIO_OUT_PIN20_Msk = 0x100000
	// Bit PIN20.
	GPIO_OUT_PIN20 = 0x100000
	// Pin driver is low.
	GPIO_OUT_PIN20_Low = 0x0
	// Pin driver is high.
	GPIO_OUT_PIN20_High = 0x1
	// Position of PIN21 field.
	GPIO_OUT_PIN21_Pos = 0x15
	// Bit mask of PIN21 field.
	GPIO_OUT_PIN21_Msk = 0x200000
	// Bit PIN21.
	GPIO_OUT_PIN21 = 0x200000
	// Pin driver is low.
	GPIO_OUT_PIN21_Low = 0x0
	// Pin driver is high.
	GPIO_OUT_PIN21_High = 0x1
	// Position of PIN22 field.
	GPIO_OUT_PIN22_Pos = 0x16
	// Bit mask of PIN22 field.
	GPIO_OUT_PIN22_Msk = 0x400000
	// Bit PIN22.
	GPIO_OUT_PIN22 = 0x400000
	// Pin driver is low.
	GPIO_OUT_PIN22_Low = 0x0
	// Pin driver is high.
	GPIO_OUT_PIN22_High = 0x1
	// Position of PIN23 field.
	GPIO_OUT_PIN23_Pos = 0x17
	// Bit mask of PIN23 field.
	GPIO_OUT_PIN23_Msk = 0x800000
	// Bit PIN23.
	GPIO_OUT_PIN23 = 0x800000
	// Pin driver is low.
	GPIO_OUT_PIN23_Low = 0x0
	// Pin driver is high.
	GPIO_OUT_PIN23_High = 0x1
	// Position of PIN24 field.
	GPIO_OUT_PIN24_Pos = 0x18
	// Bit mask of PIN24 field.
	GPIO_OUT_PIN24_Msk = 0x1000000
	// Bit PIN24.
	GPIO_OUT_PIN24 = 0x1000000
	// Pin driver is low.
	GPIO_OUT_PIN24_Low = 0x0
	// Pin driver is high.
	GPIO_OUT_PIN24_High = 0x1
	// Position of PIN25 field.
	GPIO_OUT_PIN25_Pos = 0x19
	// Bit mask of PIN25 field.
	GPIO_OUT_PIN25_Msk = 0x2000000
	// Bit PIN25.
	GPIO_OUT_PIN25 = 0x2000000
	// Pin driver is low.
	GPIO_OUT_PIN25_Low = 0x0
	// Pin driver is high.
	GPIO_OUT_PIN25_High = 0x1
	// Position of PIN26 field.
	GPIO_OUT_PIN26_Pos = 0x1a
	// Bit mask of PIN26 field.
	GPIO_OUT_PIN26_Msk = 0x4000000
	// Bit PIN26.
	GPIO_OUT_PIN26 = 0x4000000
	// Pin driver is low.
	GPIO_OUT_PIN26_Low = 0x0
	// Pin driver is high.
	GPIO_OUT_PIN26_High = 0x1
	// Position of PIN27 field.
	GPIO_OUT_PIN27_Pos = 0x1b
	// Bit mask of PIN27 field.
	GPIO_OUT_PIN27_Msk = 0x8000000
	// Bit PIN27.
	GPIO_OUT_PIN27 = 0x8000000
	// Pin driver is low.
	GPIO_OUT_PIN27_Low = 0x0
	// Pin driver is high.
	GPIO_OUT_PIN27_High = 0x1
	// Position of PIN28 field.
	GPIO_OUT_PIN28_Pos = 0x1c
	// Bit mask of PIN28 field.
	GPIO_OUT_PIN28_Msk = 0x10000000
	// Bit PIN28.
	GPIO_OUT_PIN28 = 0x10000000
	// Pin driver is low.
	GPIO_OUT_PIN28_Low = 0x0
	// Pin driver is high.
	GPIO_OUT_PIN28_High = 0x1
	// Position of PIN29 field.
	GPIO_OUT_PIN29_Pos = 0x1d
	// Bit mask of PIN29 field.
	GPIO_OUT_PIN29_Msk = 0x20000000
	// Bit PIN29.
	GPIO_OUT_PIN29 = 0x20000000
	// Pin driver is low.
	GPIO_OUT_PIN29_Low = 0x0
	// Pin driver is high.
	GPIO_OUT_PIN29_High = 0x1
	// Position of PIN30 field.
	GPIO_OUT_PIN30_Pos = 0x1e
	// Bit mask of PIN30 field.
	GPIO_OUT_PIN30_Msk = 0x40000000
	// Bit PIN30.
	GPIO_OUT_PIN30 = 0x40000000
	// Pin driver is low.
	GPIO_OUT_PIN30_Low = 0x0
	// Pin driver is high.
	GPIO_OUT_PIN30_High = 0x1
	// Position of PIN31 field.
	GPIO_OUT_PIN31_Pos = 0x1f
	// Bit mask of PIN31 field.
	GPIO_OUT_PIN31_Msk = 0x80000000
	// Bit PIN31.
	GPIO_OUT_PIN31 = 0x80000000
	// Pin driver is low.
	GPIO_OUT_PIN31_Low = 0x0
	// Pin driver is high.
	GPIO_OUT_PIN31_High = 0x1

	// OUTSET: Set individual bits in GPIO port.
	// Position of PIN0 field.
	GPIO_OUTSET_PIN0_Pos = 0x0
	// Bit mask of PIN0 field.
	GPIO_OUTSET_PIN0_Msk = 0x1
	// Bit PIN0.
	GPIO_OUTSET_PIN0 = 0x1
	// Pin driver is low.
	GPIO_OUTSET_PIN0_Low = 0x0
	// Pin driver is high.
	GPIO_OUTSET_PIN0_High = 0x1
	// Set pin driver high.
	GPIO_OUTSET_PIN0_Set = 0x1
	// Position of PIN1 field.
	GPIO_OUTSET_PIN1_Pos = 0x1
	// Bit mask of PIN1 field.
	GPIO_OUTSET_PIN1_Msk = 0x2
	// Bit PIN1.
	GPIO_OUTSET_PIN1 = 0x2
	// Pin driver is low.
	GPIO_OUTSET_PIN1_Low = 0x0
	// Pin driver is high.
	GPIO_OUTSET_PIN1_High = 0x1
	// Set pin driver high.
	GPIO_OUTSET_PIN1_Set = 0x1
	// Position of PIN2 field.
	GPIO_OUTSET_PIN2_Pos = 0x2
	// Bit mask of PIN2 field.
	GPIO_OUTSET_PIN2_Msk = 0x4
	// Bit PIN2.
	GPIO_OUTSET_PIN2 = 0x4
	// Pin driver is low.
	GPIO_OUTSET_PIN2_Low = 0x0
	// Pin driver is high.
	GPIO_OUTSET_PIN2_High = 0x1
	// Set pin driver high.
	GPIO_OUTSET_PIN2_Set = 0x1
	// Position of PIN3 field.
	GPIO_OUTSET_PIN3_Pos = 0x3
	// Bit mask of PIN3 field.
	GPIO_OUTSET_PIN3_Msk = 0x8
	// Bit PIN3.
	GPIO_OUTSET_PIN3 = 0x8
	// Pin driver is low.
	GPIO_OUTSET_PIN3_Low = 0x0
	// Pin driver is high.
	GPIO_OUTSET_PIN3_High = 0x1
	// Set pin driver high.
	GPIO_OUTSET_PIN3_Set = 0x1
	// Position of PIN4 field.
	GPIO_OUTSET_PIN4_Pos = 0x4
	// Bit mask of PIN4 field.
	GPIO_OUTSET_PIN4_Msk = 0x10
	// Bit PIN4.
	GPIO_OUTSET_PIN4 = 0x10
	// Pin driver is low.
	GPIO_OUTSET_PIN4_Low = 0x0
	// Pin driver is high.
	GPIO_OUTSET_PIN4_High = 0x1
	// Set pin driver high.
	GPIO_OUTSET_PIN4_Set = 0x1
	// Position of PIN5 field.
	GPIO_OUTSET_PIN5_Pos = 0x5
	// Bit mask of PIN5 field.
	GPIO_OUTSET_PIN5_Msk = 0x20
	// Bit PIN5.
	GPIO_OUTSET_PIN5 = 0x20
	// Pin driver is low.
	GPIO_OUTSET_PIN5_Low = 0x0
	// Pin driver is high.
	GPIO_OUTSET_PIN5_High = 0x1
	// Set pin driver high.
	GPIO_OUTSET_PIN5_Set = 0x1
	// Position of PIN6 field.
	GPIO_OUTSET_PIN6_Pos = 0x6
	// Bit mask of PIN6 field.
	GPIO_OUTSET_PIN6_Msk = 0x40
	// Bit PIN6.
	GPIO_OUTSET_PIN6 = 0x40
	// Pin driver is low.
	GPIO_OUTSET_PIN6_Low = 0x0
	// Pin driver is high.
	GPIO_OUTSET_PIN6_High = 0x1
	// Set pin driver high.
	GPIO_OUTSET_PIN6_Set = 0x1
	// Position of PIN7 field.
	GPIO_OUTSET_PIN7_Pos = 0x7
	// Bit mask of PIN7 field.
	GPIO_OUTSET_PIN7_Msk = 0x80
	// Bit PIN7.
	GPIO_OUTSET_PIN7 = 0x80
	// Pin driver is low.
	GPIO_OUTSET_PIN7_Low = 0x0
	// Pin driver is high.
	GPIO_OUTSET_PIN7_High = 0x1
	// Set pin driver high.
	GPIO_OUTSET_PIN7_Set = 0x1
	// Position of PIN8 field.
	GPIO_OUTSET_PIN8_Pos = 0x8
	// Bit mask of PIN8 field.
	GPIO_OUTSET_PIN8_Msk = 0x100
	// Bit PIN8.
	GPIO_OUTSET_PIN8 = 0x100
	// Pin driver is low.
	GPIO_OUTSET_PIN8_Low = 0x0
	// Pin driver is high.
	GPIO_OUTSET_PIN8_High = 0x1
	// Set pin driver high.
	GPIO_OUTSET_PIN8_Set = 0x1
	// Position of PIN9 field.
	GPIO_OUTSET_PIN9_Pos = 0x9
	// Bit mask of PIN9 field.
	GPIO_OUTSET_PIN9_Msk = 0x200
	// Bit PIN9.
	GPIO_OUTSET_PIN9 = 0x200
	// Pin driver is low.
	GPIO_OUTSET_PIN9_Low = 0x0
	// Pin driver is high.
	GPIO_OUTSET_PIN9_High = 0x1
	// Set pin driver high.
	GPIO_OUTSET_PIN9_Set = 0x1
	// Position of PIN10 field.
	GPIO_OUTSET_PIN10_Pos = 0xa
	// Bit mask of PIN10 field.
	GPIO_OUTSET_PIN10_Msk = 0x400
	// Bit PIN10.
	GPIO_OUTSET_PIN10 = 0x400
	// Pin driver is low.
	GPIO_OUTSET_PIN10_Low = 0x0
	// Pin driver is high.
	GPIO_OUTSET_PIN10_High = 0x1
	// Set pin driver high.
	GPIO_OUTSET_PIN10_Set = 0x1
	// Position of PIN11 field.
	GPIO_OUTSET_PIN11_Pos = 0xb
	// Bit mask of PIN11 field.
	GPIO_OUTSET_PIN11_Msk = 0x800
	// Bit PIN11.
	GPIO_OUTSET_PIN11 = 0x800
	// Pin driver is low.
	GPIO_OUTSET_PIN11_Low = 0x0
	// Pin driver is high.
	GPIO_OUTSET_PIN11_High = 0x1
	// Set pin driver high.
	GPIO_OUTSET_PIN11_Set = 0x1
	// Position of PIN12 field.
	GPIO_OUTSET_PIN12_Pos = 0xc
	// Bit mask of PIN12 field.
	GPIO_OUTSET_PIN12_Msk = 0x1000
	// Bit PIN12.
	GPIO_OUTSET_PIN12 = 0x1000
	// Pin driver is low.
	GPIO_OUTSET_PIN12_Low = 0x0
	// Pin driver is high.
	GPIO_OUTSET_PIN12_High = 0x1
	// Set pin driver high.
	GPIO_OUTSET_PIN12_Set = 0x1
	// Position of PIN13 field.
	GPIO_OUTSET_PIN13_Pos = 0xd
	// Bit mask of PIN13 field.
	GPIO_OUTSET_PIN13_Msk = 0x2000
	// Bit PIN13.
	GPIO_OUTSET_PIN13 = 0x2000
	// Pin driver is low.
	GPIO_OUTSET_PIN13_Low = 0x0
	// Pin driver is high.
	GPIO_OUTSET_PIN13_High = 0x1
	// Set pin driver high.
	GPIO_OUTSET_PIN13_Set = 0x1
	// Position of PIN14 field.
	GPIO_OUTSET_PIN14_Pos = 0xe
	// Bit mask of PIN14 field.
	GPIO_OUTSET_PIN14_Msk = 0x4000
	// Bit PIN14.
	GPIO_OUTSET_PIN14 = 0x4000
	// Pin driver is low.
	GPIO_OUTSET_PIN14_Low = 0x0
	// Pin driver is high.
	GPIO_OUTSET_PIN14_High = 0x1
	// Set pin driver high.
	GPIO_OUTSET_PIN14_Set = 0x1
	// Position of PIN15 field.
	GPIO_OUTSET_PIN15_Pos = 0xf
	// Bit mask of PIN15 field.
	GPIO_OUTSET_PIN15_Msk = 0x8000
	// Bit PIN15.
	GPIO_OUTSET_PIN15 = 0x8000
	// Pin driver is low.
	GPIO_OUTSET_PIN15_Low = 0x0
	// Pin driver is high.
	GPIO_OUTSET_PIN15_High = 0x1
	// Set pin driver high.
	GPIO_OUTSET_PIN15_Set = 0x1
	// Position of PIN16 field.
	GPIO_OUTSET_PIN16_Pos = 0x10
	// Bit mask of PIN16 field.
	GPIO_OUTSET_PIN16_Msk = 0x10000
	// Bit PIN16.
	GPIO_OUTSET_PIN16 = 0x10000
	// Pin driver is low.
	GPIO_OUTSET_PIN16_Low = 0x0
	// Pin driver is high.
	GPIO_OUTSET_PIN16_High = 0x1
	// Set pin driver high.
	GPIO_OUTSET_PIN16_Set = 0x1
	// Position of PIN17 field.
	GPIO_OUTSET_PIN17_Pos = 0x11
	// Bit mask of PIN17 field.
	GPIO_OUTSET_PIN17_Msk = 0x20000
	// Bit PIN17.
	GPIO_OUTSET_PIN17 = 0x20000
	// Pin driver is low.
	GPIO_OUTSET_PIN17_Low = 0x0
	// Pin driver is high.
	GPIO_OUTSET_PIN17_High = 0x1
	// Set pin driver high.
	GPIO_OUTSET_PIN17_Set = 0x1
	// Position of PIN18 field.
	GPIO_OUTSET_PIN18_Pos = 0x12
	// Bit mask of PIN18 field.
	GPIO_OUTSET_PIN18_Msk = 0x40000
	// Bit PIN18.
	GPIO_OUTSET_PIN18 = 0x40000
	// Pin driver is low.
	GPIO_OUTSET_PIN18_Low = 0x0
	// Pin driver is high.
	GPIO_OUTSET_PIN18_High = 0x1
	// Set pin driver high.
	GPIO_OUTSET_PIN18_Set = 0x1
	// Position of PIN19 field.
	GPIO_OUTSET_PIN19_Pos = 0x13
	// Bit mask of PIN19 field.
	GPIO_OUTSET_PIN19_Msk = 0x80000
	// Bit PIN19.
	GPIO_OUTSET_PIN19 = 0x80000
	// Pin driver is low.
	GPIO_OUTSET_PIN19_Low = 0x0
	// Pin driver is high.
	GPIO_OUTSET_PIN19_High = 0x1
	// Set pin driver high.
	GPIO_OUTSET_PIN19_Set = 0x1
	// Position of PIN20 field.
	GPIO_OUTSET_PIN20_Pos = 0x14
	// Bit mask of PIN20 field.
	GPIO_OUTSET_PIN20_Msk = 0x100000
	// Bit PIN20.
	GPIO_OUTSET_PIN20 = 0x100000
	// Pin driver is low.
	GPIO_OUTSET_PIN20_Low = 0x0
	// Pin driver is high.
	GPIO_OUTSET_PIN20_High = 0x1
	// Set pin driver high.
	GPIO_OUTSET_PIN20_Set = 0x1
	// Position of PIN21 field.
	GPIO_OUTSET_PIN21_Pos = 0x15
	// Bit mask of PIN21 field.
	GPIO_OUTSET_PIN21_Msk = 0x200000
	// Bit PIN21.
	GPIO_OUTSET_PIN21 = 0x200000
	// Pin driver is low.
	GPIO_OUTSET_PIN21_Low = 0x0
	// Pin driver is high.
	GPIO_OUTSET_PIN21_High = 0x1
	// Set pin driver high.
	GPIO_OUTSET_PIN21_Set = 0x1
	// Position of PIN22 field.
	GPIO_OUTSET_PIN22_Pos = 0x16
	// Bit mask of PIN22 field.
	GPIO_OUTSET_PIN22_Msk = 0x400000
	// Bit PIN22.
	GPIO_OUTSET_PIN22 = 0x400000
	// Pin driver is low.
	GPIO_OUTSET_PIN22_Low = 0x0
	// Pin driver is high.
	GPIO_OUTSET_PIN22_High = 0x1
	// Set pin driver high.
	GPIO_OUTSET_PIN22_Set = 0x1
	// Position of PIN23 field.
	GPIO_OUTSET_PIN23_Pos = 0x17
	// Bit mask of PIN23 field.
	GPIO_OUTSET_PIN23_Msk = 0x800000
	// Bit PIN23.
	GPIO_OUTSET_PIN23 = 0x800000
	// Pin driver is low.
	GPIO_OUTSET_PIN23_Low = 0x0
	// Pin driver is high.
	GPIO_OUTSET_PIN23_High = 0x1
	// Set pin driver high.
	GPIO_OUTSET_PIN23_Set = 0x1
	// Position of PIN24 field.
	GPIO_OUTSET_PIN24_Pos = 0x18
	// Bit mask of PIN24 field.
	GPIO_OUTSET_PIN24_Msk = 0x1000000
	// Bit PIN24.
	GPIO_OUTSET_PIN24 = 0x1000000
	// Pin driver is low.
	GPIO_OUTSET_PIN24_Low = 0x0
	// Pin driver is high.
	GPIO_OUTSET_PIN24_High = 0x1
	// Set pin driver high.
	GPIO_OUTSET_PIN24_Set = 0x1
	// Position of PIN25 field.
	GPIO_OUTSET_PIN25_Pos = 0x19
	// Bit mask of PIN25 field.
	GPIO_OUTSET_PIN25_Msk = 0x2000000
	// Bit PIN25.
	GPIO_OUTSET_PIN25 = 0x2000000
	// Pin driver is low.
	GPIO_OUTSET_PIN25_Low = 0x0
	// Pin driver is high.
	GPIO_OUTSET_PIN25_High = 0x1
	// Set pin driver high.
	GPIO_OUTSET_PIN25_Set = 0x1
	// Position of PIN26 field.
	GPIO_OUTSET_PIN26_Pos = 0x1a
	// Bit mask of PIN26 field.
	GPIO_OUTSET_PIN26_Msk = 0x4000000
	// Bit PIN26.
	GPIO_OUTSET_PIN26 = 0x4000000
	// Pin driver is low.
	GPIO_OUTSET_PIN26_Low = 0x0
	// Pin driver is high.
	GPIO_OUTSET_PIN26_High = 0x1
	// Set pin driver high.
	GPIO_OUTSET_PIN26_Set = 0x1
	// Position of PIN27 field.
	GPIO_OUTSET_PIN27_Pos = 0x1b
	// Bit mask of PIN27 field.
	GPIO_OUTSET_PIN27_Msk = 0x8000000
	// Bit PIN27.
	GPIO_OUTSET_PIN27 = 0x8000000
	// Pin driver is low.
	GPIO_OUTSET_PIN27_Low = 0x0
	// Pin driver is high.
	GPIO_OUTSET_PIN27_High = 0x1
	// Set pin driver high.
	GPIO_OUTSET_PIN27_Set = 0x1
	// Position of PIN28 field.
	GPIO_OUTSET_PIN28_Pos = 0x1c
	// Bit mask of PIN28 field.
	GPIO_OUTSET_PIN28_Msk = 0x10000000
	// Bit PIN28.
	GPIO_OUTSET_PIN28 = 0x10000000
	// Pin driver is low.
	GPIO_OUTSET_PIN28_Low = 0x0
	// Pin driver is high.
	GPIO_OUTSET_PIN28_High = 0x1
	// Set pin driver high.
	GPIO_OUTSET_PIN28_Set = 0x1
	// Position of PIN29 field.
	GPIO_OUTSET_PIN29_Pos = 0x1d
	// Bit mask of PIN29 field.
	GPIO_OUTSET_PIN29_Msk = 0x20000000
	// Bit PIN29.
	GPIO_OUTSET_PIN29 = 0x20000000
	// Pin driver is low.
	GPIO_OUTSET_PIN29_Low = 0x0
	// Pin driver is high.
	GPIO_OUTSET_PIN29_High = 0x1
	// Set pin driver high.
	GPIO_OUTSET_PIN29_Set = 0x1
	// Position of PIN30 field.
	GPIO_OUTSET_PIN30_Pos = 0x1e
	// Bit mask of PIN30 field.
	GPIO_OUTSET_PIN30_Msk = 0x40000000
	// Bit PIN30.
	GPIO_OUTSET_PIN30 = 0x40000000
	// Pin driver is low.
	GPIO_OUTSET_PIN30_Low = 0x0
	// Pin driver is high.
	GPIO_OUTSET_PIN30_High = 0x1
	// Set pin driver high.
	GPIO_OUTSET_PIN30_Set = 0x1
	// Position of PIN31 field.
	GPIO_OUTSET_PIN31_Pos = 0x1f
	// Bit mask of PIN31 field.
	GPIO_OUTSET_PIN31_Msk = 0x80000000
	// Bit PIN31.
	GPIO_OUTSET_PIN31 = 0x80000000
	// Pin driver is low.
	GPIO_OUTSET_PIN31_Low = 0x0
	// Pin driver is high.
	GPIO_OUTSET_PIN31_High = 0x1
	// Set pin driver high.
	GPIO_OUTSET_PIN31_Set = 0x1

	// OUTCLR: Clear individual bits in GPIO port.
	// Position of PIN0 field.
	GPIO_OUTCLR_PIN0_Pos = 0x0
	// Bit mask of PIN0 field.
	GPIO_OUTCLR_PIN0_Msk = 0x1
	// Bit PIN0.
	GPIO_OUTCLR_PIN0 = 0x1
	// Pin driver is low.
	GPIO_OUTCLR_PIN0_Low = 0x0
	// Pin driver is high.
	GPIO_OUTCLR_PIN0_High = 0x1
	// Set pin driver low.
	GPIO_OUTCLR_PIN0_Clear = 0x1
	// Position of PIN1 field.
	GPIO_OUTCLR_PIN1_Pos = 0x1
	// Bit mask of PIN1 field.
	GPIO_OUTCLR_PIN1_Msk = 0x2
	// Bit PIN1.
	GPIO_OUTCLR_PIN1 = 0x2
	// Pin driver is low.
	GPIO_OUTCLR_PIN1_Low = 0x0
	// Pin driver is high.
	GPIO_OUTCLR_PIN1_High = 0x1
	// Set pin driver low.
	GPIO_OUTCLR_PIN1_Clear = 0x1
	// Position of PIN2 field.
	GPIO_OUTCLR_PIN2_Pos = 0x2
	// Bit mask of PIN2 field.
	GPIO_OUTCLR_PIN2_Msk = 0x4
	// Bit PIN2.
	GPIO_OUTCLR_PIN2 = 0x4
	// Pin driver is low.
	GPIO_OUTCLR_PIN2_Low = 0x0
	// Pin driver is high.
	GPIO_OUTCLR_PIN2_High = 0x1
	// Set pin driver low.
	GPIO_OUTCLR_PIN2_Clear = 0x1
	// Position of PIN3 field.
	GPIO_OUTCLR_PIN3_Pos = 0x3
	// Bit mask of PIN3 field.
	GPIO_OUTCLR_PIN3_Msk = 0x8
	// Bit PIN3.
	GPIO_OUTCLR_PIN3 = 0x8
	// Pin driver is low.
	GPIO_OUTCLR_PIN3_Low = 0x0
	// Pin driver is high.
	GPIO_OUTCLR_PIN3_High = 0x1
	// Set pin driver low.
	GPIO_OUTCLR_PIN3_Clear = 0x1
	// Position of PIN4 field.
	GPIO_OUTCLR_PIN4_Pos = 0x4
	// Bit mask of PIN4 field.
	GPIO_OUTCLR_PIN4_Msk = 0x10
	// Bit PIN4.
	GPIO_OUTCLR_PIN4 = 0x10
	// Pin driver is low.
	GPIO_OUTCLR_PIN4_Low = 0x0
	// Pin driver is high.
	GPIO_OUTCLR_PIN4_High = 0x1
	// Set pin driver low.
	GPIO_OUTCLR_PIN4_Clear = 0x1
	// Position of PIN5 field.
	GPIO_OUTCLR_PIN5_Pos = 0x5
	// Bit mask of PIN5 field.
	GPIO_OUTCLR_PIN5_Msk = 0x20
	// Bit PIN5.
	GPIO_OUTCLR_PIN5 = 0x20
	// Pin driver is low.
	GPIO_OUTCLR_PIN5_Low = 0x0
	// Pin driver is high.
	GPIO_OUTCLR_PIN5_High = 0x1
	// Set pin driver low.
	GPIO_OUTCLR_PIN5_Clear = 0x1
	// Position of PIN6 field.
	GPIO_OUTCLR_PIN6_Pos = 0x6
	// Bit mask of PIN6 field.
	GPIO_OUTCLR_PIN6_Msk = 0x40
	// Bit PIN6.
	GPIO_OUTCLR_PIN6 = 0x40
	// Pin driver is low.
	GPIO_OUTCLR_PIN6_Low = 0x0
	// Pin driver is high.
	GPIO_OUTCLR_PIN6_High = 0x1
	// Set pin driver low.
	GPIO_OUTCLR_PIN6_Clear = 0x1
	// Position of PIN7 field.
	GPIO_OUTCLR_PIN7_Pos = 0x7
	// Bit mask of PIN7 field.
	GPIO_OUTCLR_PIN7_Msk = 0x80
	// Bit PIN7.
	GPIO_OUTCLR_PIN7 = 0x80
	// Pin driver is low.
	GPIO_OUTCLR_PIN7_Low = 0x0
	// Pin driver is high.
	GPIO_OUTCLR_PIN7_High = 0x1
	// Set pin driver low.
	GPIO_OUTCLR_PIN7_Clear = 0x1
	// Position of PIN8 field.
	GPIO_OUTCLR_PIN8_Pos = 0x8
	// Bit mask of PIN8 field.
	GPIO_OUTCLR_PIN8_Msk = 0x100
	// Bit PIN8.
	GPIO_OUTCLR_PIN8 = 0x100
	// Pin driver is low.
	GPIO_OUTCLR_PIN8_Low = 0x0
	// Pin driver is high.
	GPIO_OUTCLR_PIN8_High = 0x1
	// Set pin driver low.
	GPIO_OUTCLR_PIN8_Clear = 0x1
	// Position of PIN9 field.
	GPIO_OUTCLR_PIN9_Pos = 0x9
	// Bit mask of PIN9 field.
	GPIO_OUTCLR_PIN9_Msk = 0x200
	// Bit PIN9.
	GPIO_OUTCLR_PIN9 = 0x200
	// Pin driver is low.
	GPIO_OUTCLR_PIN9_Low = 0x0
	// Pin driver is high.
	GPIO_OUTCLR_PIN9_High = 0x1
	// Set pin driver low.
	GPIO_OUTCLR_PIN9_Clear = 0x1
	// Position of PIN10 field.
	GPIO_OUTCLR_PIN10_Pos = 0xa
	// Bit mask of PIN10 field.
	GPIO_OUTCLR_PIN10_Msk = 0x400
	// Bit PIN10.
	GPIO_OUTCLR_PIN10 = 0x400
	// Pin driver is low.
	GPIO_OUTCLR_PIN10_Low = 0x0
	// Pin driver is high.
	GPIO_OUTCLR_PIN10_High = 0x1
	// Set pin driver low.
	GPIO_OUTCLR_PIN10_Clear = 0x1
	// Position of PIN11 field.
	GPIO_OUTCLR_PIN11_Pos = 0xb
	// Bit mask of PIN11 field.
	GPIO_OUTCLR_PIN11_Msk = 0x800
	// Bit PIN11.
	GPIO_OUTCLR_PIN11 = 0x800
	// Pin driver is low.
	GPIO_OUTCLR_PIN11_Low = 0x0
	// Pin driver is high.
	GPIO_OUTCLR_PIN11_High = 0x1
	// Set pin driver low.
	GPIO_OUTCLR_PIN11_Clear = 0x1
	// Position of PIN12 field.
	GPIO_OUTCLR_PIN12_Pos = 0xc
	// Bit mask of PIN12 field.
	GPIO_OUTCLR_PIN12_Msk = 0x1000
	// Bit PIN12.
	GPIO_OUTCLR_PIN12 = 0x1000
	// Pin driver is low.
	GPIO_OUTCLR_PIN12_Low = 0x0
	// Pin driver is high.
	GPIO_OUTCLR_PIN12_High = 0x1
	// Set pin driver low.
	GPIO_OUTCLR_PIN12_Clear = 0x1
	// Position of PIN13 field.
	GPIO_OUTCLR_PIN13_Pos = 0xd
	// Bit mask of PIN13 field.
	GPIO_OUTCLR_PIN13_Msk = 0x2000
	// Bit PIN13.
	GPIO_OUTCLR_PIN13 = 0x2000
	// Pin driver is low.
	GPIO_OUTCLR_PIN13_Low = 0x0
	// Pin driver is high.
	GPIO_OUTCLR_PIN13_High = 0x1
	// Set pin driver low.
	GPIO_OUTCLR_PIN13_Clear = 0x1
	// Position of PIN14 field.
	GPIO_OUTCLR_PIN14_Pos = 0xe
	// Bit mask of PIN14 field.
	GPIO_OUTCLR_PIN14_Msk = 0x4000
	// Bit PIN14.
	GPIO_OUTCLR_PIN14 = 0x4000
	// Pin driver is low.
	GPIO_OUTCLR_PIN14_Low = 0x0
	// Pin driver is high.
	GPIO_OUTCLR_PIN14_High = 0x1
	// Set pin driver low.
	GPIO_OUTCLR_PIN14_Clear = 0x1
	// Position of PIN15 field.
	GPIO_OUTCLR_PIN15_Pos = 0xf
	// Bit mask of PIN15 field.
	GPIO_OUTCLR_PIN15_Msk = 0x8000
	// Bit PIN15.
	GPIO_OUTCLR_PIN15 = 0x8000
	// Pin driver is low.
	GPIO_OUTCLR_PIN15_Low = 0x0
	// Pin driver is high.
	GPIO_OUTCLR_PIN15_High = 0x1
	// Set pin driver low.
	GPIO_OUTCLR_PIN15_Clear = 0x1
	// Position of PIN16 field.
	GPIO_OUTCLR_PIN16_Pos = 0x10
	// Bit mask of PIN16 field.
	GPIO_OUTCLR_PIN16_Msk = 0x10000
	// Bit PIN16.
	GPIO_OUTCLR_PIN16 = 0x10000
	// Pin driver is low.
	GPIO_OUTCLR_PIN16_Low = 0x0
	// Pin driver is high.
	GPIO_OUTCLR_PIN16_High = 0x1
	// Set pin driver low.
	GPIO_OUTCLR_PIN16_Clear = 0x1
	// Position of PIN17 field.
	GPIO_OUTCLR_PIN17_Pos = 0x11
	// Bit mask of PIN17 field.
	GPIO_OUTCLR_PIN17_Msk = 0x20000
	// Bit PIN17.
	GPIO_OUTCLR_PIN17 = 0x20000
	// Pin driver is low.
	GPIO_OUTCLR_PIN17_Low = 0x0
	// Pin driver is high.
	GPIO_OUTCLR_PIN17_High = 0x1
	// Set pin driver low.
	GPIO_OUTCLR_PIN17_Clear = 0x1
	// Position of PIN18 field.
	GPIO_OUTCLR_PIN18_Pos = 0x12
	// Bit mask of PIN18 field.
	GPIO_OUTCLR_PIN18_Msk = 0x40000
	// Bit PIN18.
	GPIO_OUTCLR_PIN18 = 0x40000
	// Pin driver is low.
	GPIO_OUTCLR_PIN18_Low = 0x0
	// Pin driver is high.
	GPIO_OUTCLR_PIN18_High = 0x1
	// Set pin driver low.
	GPIO_OUTCLR_PIN18_Clear = 0x1
	// Position of PIN19 field.
	GPIO_OUTCLR_PIN19_Pos = 0x13
	// Bit mask of PIN19 field.
	GPIO_OUTCLR_PIN19_Msk = 0x80000
	// Bit PIN19.
	GPIO_OUTCLR_PIN19 = 0x80000
	// Pin driver is low.
	GPIO_OUTCLR_PIN19_Low = 0x0
	// Pin driver is high.
	GPIO_OUTCLR_PIN19_High = 0x1
	// Set pin driver low.
	GPIO_OUTCLR_PIN19_Clear = 0x1
	// Position of PIN20 field.
	GPIO_OUTCLR_PIN20_Pos = 0x14
	// Bit mask of PIN20 field.
	GPIO_OUTCLR_PIN20_Msk = 0x100000
	// Bit PIN20.
	GPIO_OUTCLR_PIN20 = 0x100000
	// Pin driver is low.
	GPIO_OUTCLR_PIN20_Low = 0x0
	// Pin driver is high.
	GPIO_OUTCLR_PIN20_High = 0x1
	// Set pin driver low.
	GPIO_OUTCLR_PIN20_Clear = 0x1
	// Position of PIN21 field.
	GPIO_OUTCLR_PIN21_Pos = 0x15
	// Bit mask of PIN21 field.
	GPIO_OUTCLR_PIN21_Msk = 0x200000
	// Bit PIN21.
	GPIO_OUTCLR_PIN21 = 0x200000
	// Pin driver is low.
	GPIO_OUTCLR_PIN21_Low = 0x0
	// Pin driver is high.
	GPIO_OUTCLR_PIN21_High = 0x1
	// Set pin driver low.
	GPIO_OUTCLR_PIN21_Clear = 0x1
	// Position of PIN22 field.
	GPIO_OUTCLR_PIN22_Pos = 0x16
	// Bit mask of PIN22 field.
	GPIO_OUTCLR_PIN22_Msk = 0x400000
	// Bit PIN22.
	GPIO_OUTCLR_PIN22 = 0x400000
	// Pin driver is low.
	GPIO_OUTCLR_PIN22_Low = 0x0
	// Pin driver is high.
	GPIO_OUTCLR_PIN22_High = 0x1
	// Set pin driver low.
	GPIO_OUTCLR_PIN22_Clear = 0x1
	// Position of PIN23 field.
	GPIO_OUTCLR_PIN23_Pos = 0x17
	// Bit mask of PIN23 field.
	GPIO_OUTCLR_PIN23_Msk = 0x800000
	// Bit PIN23.
	GPIO_OUTCLR_PIN23 = 0x800000
	// Pin driver is low.
	GPIO_OUTCLR_PIN23_Low = 0x0
	// Pin driver is high.
	GPIO_OUTCLR_PIN23_High = 0x1
	// Set pin driver low.
	GPIO_OUTCLR_PIN23_Clear = 0x1
	// Position of PIN24 field.
	GPIO_OUTCLR_PIN24_Pos = 0x18
	// Bit mask of PIN24 field.
	GPIO_OUTCLR_PIN24_Msk = 0x1000000
	// Bit PIN24.
	GPIO_OUTCLR_PIN24 = 0x1000000
	// Pin driver is low.
	GPIO_OUTCLR_PIN24_Low = 0x0
	// Pin driver is high.
	GPIO_OUTCLR_PIN24_High = 0x1
	// Set pin driver low.
	GPIO_OUTCLR_PIN24_Clear = 0x1
	// Position of PIN25 field.
	GPIO_OUTCLR_PIN25_Pos = 0x19
	// Bit mask of PIN25 field.
	GPIO_OUTCLR_PIN25_Msk = 0x2000000
	// Bit PIN25.
	GPIO_OUTCLR_PIN25 = 0x2000000
	// Pin driver is low.
	GPIO_OUTCLR_PIN25_Low = 0x0
	// Pin driver is high.
	GPIO_OUTCLR_PIN25_High = 0x1
	// Set pin driver low.
	GPIO_OUTCLR_PIN25_Clear = 0x1
	// Position of PIN26 field.
	GPIO_OUTCLR_PIN26_Pos = 0x1a
	// Bit mask of PIN26 field.
	GPIO_OUTCLR_PIN26_Msk = 0x4000000
	// Bit PIN26.
	GPIO_OUTCLR_PIN26 = 0x4000000
	// Pin driver is low.
	GPIO_OUTCLR_PIN26_Low = 0x0
	// Pin driver is high.
	GPIO_OUTCLR_PIN26_High = 0x1
	// Set pin driver low.
	GPIO_OUTCLR_PIN26_Clear = 0x1
	// Position of PIN27 field.
	GPIO_OUTCLR_PIN27_Pos = 0x1b
	// Bit mask of PIN27 field.
	GPIO_OUTCLR_PIN27_Msk = 0x8000000
	// Bit PIN27.
	GPIO_OUTCLR_PIN27 = 0x8000000
	// Pin driver is low.
	GPIO_OUTCLR_PIN27_Low = 0x0
	// Pin driver is high.
	GPIO_OUTCLR_PIN27_High = 0x1
	// Set pin driver low.
	GPIO_OUTCLR_PIN27_Clear = 0x1
	// Position of PIN28 field.
	GPIO_OUTCLR_PIN28_Pos = 0x1c
	// Bit mask of PIN28 field.
	GPIO_OUTCLR_PIN28_Msk = 0x10000000
	// Bit PIN28.
	GPIO_OUTCLR_PIN28 = 0x10000000
	// Pin driver is low.
	GPIO_OUTCLR_PIN28_Low = 0x0
	// Pin driver is high.
	GPIO_OUTCLR_PIN28_High = 0x1
	// Set pin driver low.
	GPIO_OUTCLR_PIN28_Clear = 0x1
	// Position of PIN29 field.
	GPIO_OUTCLR_PIN29_Pos = 0x1d
	// Bit mask of PIN29 field.
	GPIO_OUTCLR_PIN29_Msk = 0x20000000
	// Bit PIN29.
	GPIO_OUTCLR_PIN29 = 0x20000000
	// Pin driver is low.
	GPIO_OUTCLR_PIN29_Low = 0x0
	// Pin driver is high.
	GPIO_OUTCLR_PIN29_High = 0x1
	// Set pin driver low.
	GPIO_OUTCLR_PIN29_Clear = 0x1
	// Position of PIN30 field.
	GPIO_OUTCLR_PIN30_Pos = 0x1e
	// Bit mask of PIN30 field.
	GPIO_OUTCLR_PIN30_Msk = 0x40000000
	// Bit PIN30.
	GPIO_OUTCLR_PIN30 = 0x40000000
	// Pin driver is low.
	GPIO_OUTCLR_PIN30_Low = 0x0
	// Pin driver is high.
	GPIO_OUTCLR_PIN30_High = 0x1
	// Set pin driver low.
	GPIO_OUTCLR_PIN30_Clear = 0x1
	// Position of PIN31 field.
	GPIO_OUTCLR_PIN31_Pos = 0x1f
	// Bit mask of PIN31 field.
	GPIO_OUTCLR_PIN31_Msk = 0x80000000
	// Bit PIN31.
	GPIO_OUTCLR_PIN31 = 0x80000000
	// Pin driver is low.
	GPIO_OUTCLR_PIN31_Low = 0x0
	// Pin driver is high.
	GPIO_OUTCLR_PIN31_High = 0x1
	// Set pin driver low.
	GPIO_OUTCLR_PIN31_Clear = 0x1

	// IN: Read GPIO port.
	// Position of PIN0 field.
	GPIO_IN_PIN0_Pos = 0x0
	// Bit mask of PIN0 field.
	GPIO_IN_PIN0_Msk = 0x1
	// Bit PIN0.
	GPIO_IN_PIN0 = 0x1
	// Pin input is low.
	GPIO_IN_PIN0_Low = 0x0
	// Pin input is high.
	GPIO_IN_PIN0_High = 0x1
	// Position of PIN1 field.
	GPIO_IN_PIN1_Pos = 0x1
	// Bit mask of PIN1 field.
	GPIO_IN_PIN1_Msk = 0x2
	// Bit PIN1.
	GPIO_IN_PIN1 = 0x2
	// Pin input is low.
	GPIO_IN_PIN1_Low = 0x0
	// Pin input is high.
	GPIO_IN_PIN1_High = 0x1
	// Position of PIN2 field.
	GPIO_IN_PIN2_Pos = 0x2
	// Bit mask of PIN2 field.
	GPIO_IN_PIN2_Msk = 0x4
	// Bit PIN2.
	GPIO_IN_PIN2 = 0x4
	// Pin input is low.
	GPIO_IN_PIN2_Low = 0x0
	// Pin input is high.
	GPIO_IN_PIN2_High = 0x1
	// Position of PIN3 field.
	GPIO_IN_PIN3_Pos = 0x3
	// Bit mask of PIN3 field.
	GPIO_IN_PIN3_Msk = 0x8
	// Bit PIN3.
	GPIO_IN_PIN3 = 0x8
	// Pin input is low.
	GPIO_IN_PIN3_Low = 0x0
	// Pin input is high.
	GPIO_IN_PIN3_High = 0x1
	// Position of PIN4 field.
	GPIO_IN_PIN4_Pos = 0x4
	// Bit mask of PIN4 field.
	GPIO_IN_PIN4_Msk = 0x10
	// Bit PIN4.
	GPIO_IN_PIN4 = 0x10
	// Pin input is low.
	GPIO_IN_PIN4_Low = 0x0
	// Pin input is high.
	GPIO_IN_PIN4_High = 0x1
	// Position of PIN5 field.
	GPIO_IN_PIN5_Pos = 0x5
	// Bit mask of PIN5 field.
	GPIO_IN_PIN5_Msk = 0x20
	// Bit PIN5.
	GPIO_IN_PIN5 = 0x20
	// Pin input is low.
	GPIO_IN_PIN5_Low = 0x0
	// Pin input is high.
	GPIO_IN_PIN5_High = 0x1
	// Position of PIN6 field.
	GPIO_IN_PIN6_Pos = 0x6
	// Bit mask of PIN6 field.
	GPIO_IN_PIN6_Msk = 0x40
	// Bit PIN6.
	GPIO_IN_PIN6 = 0x40
	// Pin input is low.
	GPIO_IN_PIN6_Low = 0x0
	// Pin input is high.
	GPIO_IN_PIN6_High = 0x1
	// Position of PIN7 field.
	GPIO_IN_PIN7_Pos = 0x7
	// Bit mask of PIN7 field.
	GPIO_IN_PIN7_Msk = 0x80
	// Bit PIN7.
	GPIO_IN_PIN7 = 0x80
	// Pin input is low.
	GPIO_IN_PIN7_Low = 0x0
	// Pin input is high.
	GPIO_IN_PIN7_High = 0x1
	// Position of PIN8 field.
	GPIO_IN_PIN8_Pos = 0x8
	// Bit mask of PIN8 field.
	GPIO_IN_PIN8_Msk = 0x100
	// Bit PIN8.
	GPIO_IN_PIN8 = 0x100
	// Pin input is low.
	GPIO_IN_PIN8_Low = 0x0
	// Pin input is high.
	GPIO_IN_PIN8_High = 0x1
	// Position of PIN9 field.
	GPIO_IN_PIN9_Pos = 0x9
	// Bit mask of PIN9 field.
	GPIO_IN_PIN9_Msk = 0x200
	// Bit PIN9.
	GPIO_IN_PIN9 = 0x200
	// Pin input is low.
	GPIO_IN_PIN9_Low = 0x0
	// Pin input is high.
	GPIO_IN_PIN9_High = 0x1
	// Position of PIN10 field.
	GPIO_IN_PIN10_Pos = 0xa
	// Bit mask of PIN10 field.
	GPIO_IN_PIN10_Msk = 0x400
	// Bit PIN10.
	GPIO_IN_PIN10 = 0x400
	// Pin input is low.
	GPIO_IN_PIN10_Low = 0x0
	// Pin input is high.
	GPIO_IN_PIN10_High = 0x1
	// Position of PIN11 field.
	GPIO_IN_PIN11_Pos = 0xb
	// Bit mask of PIN11 field.
	GPIO_IN_PIN11_Msk = 0x800
	// Bit PIN11.
	GPIO_IN_PIN11 = 0x800
	// Pin input is low.
	GPIO_IN_PIN11_Low = 0x0
	// Pin input is high.
	GPIO_IN_PIN11_High = 0x1
	// Position of PIN12 field.
	GPIO_IN_PIN12_Pos = 0xc
	// Bit mask of PIN12 field.
	GPIO_IN_PIN12_Msk = 0x1000
	// Bit PIN12.
	GPIO_IN_PIN12 = 0x1000
	// Pin input is low.
	GPIO_IN_PIN12_Low = 0x0
	// Pin input is high.
	GPIO_IN_PIN12_High = 0x1
	// Position of PIN13 field.
	GPIO_IN_PIN13_Pos = 0xd
	// Bit mask of PIN13 field.
	GPIO_IN_PIN13_Msk = 0x2000
	// Bit PIN13.
	GPIO_IN_PIN13 = 0x2000
	// Pin input is low.
	GPIO_IN_PIN13_Low = 0x0
	// Pin input is high.
	GPIO_IN_PIN13_High = 0x1
	// Position of PIN14 field.
	GPIO_IN_PIN14_Pos = 0xe
	// Bit mask of PIN14 field.
	GPIO_IN_PIN14_Msk = 0x4000
	// Bit PIN14.
	GPIO_IN_PIN14 = 0x4000
	// Pin input is low.
	GPIO_IN_PIN14_Low = 0x0
	// Pin input is high.
	GPIO_IN_PIN14_High = 0x1
	// Position of PIN15 field.
	GPIO_IN_PIN15_Pos = 0xf
	// Bit mask of PIN15 field.
	GPIO_IN_PIN15_Msk = 0x8000
	// Bit PIN15.
	GPIO_IN_PIN15 = 0x8000
	// Pin input is low.
	GPIO_IN_PIN15_Low = 0x0
	// Pin input is high.
	GPIO_IN_PIN15_High = 0x1
	// Position of PIN16 field.
	GPIO_IN_PIN16_Pos = 0x10
	// Bit mask of PIN16 field.
	GPIO_IN_PIN16_Msk = 0x10000
	// Bit PIN16.
	GPIO_IN_PIN16 = 0x10000
	// Pin input is low.
	GPIO_IN_PIN16_Low = 0x0
	// Pin input is high.
	GPIO_IN_PIN16_High = 0x1
	// Position of PIN17 field.
	GPIO_IN_PIN17_Pos = 0x11
	// Bit mask of PIN17 field.
	GPIO_IN_PIN17_Msk = 0x20000
	// Bit PIN17.
	GPIO_IN_PIN17 = 0x20000
	// Pin input is low.
	GPIO_IN_PIN17_Low = 0x0
	// Pin input is high.
	GPIO_IN_PIN17_High = 0x1
	// Position of PIN18 field.
	GPIO_IN_PIN18_Pos = 0x12
	// Bit mask of PIN18 field.
	GPIO_IN_PIN18_Msk = 0x40000
	// Bit PIN18.
	GPIO_IN_PIN18 = 0x40000
	// Pin input is low.
	GPIO_IN_PIN18_Low = 0x0
	// Pin input is high.
	GPIO_IN_PIN18_High = 0x1
	// Position of PIN19 field.
	GPIO_IN_PIN19_Pos = 0x13
	// Bit mask of PIN19 field.
	GPIO_IN_PIN19_Msk = 0x80000
	// Bit PIN19.
	GPIO_IN_PIN19 = 0x80000
	// Pin input is low.
	GPIO_IN_PIN19_Low = 0x0
	// Pin input is high.
	GPIO_IN_PIN19_High = 0x1
	// Position of PIN20 field.
	GPIO_IN_PIN20_Pos = 0x14
	// Bit mask of PIN20 field.
	GPIO_IN_PIN20_Msk = 0x100000
	// Bit PIN20.
	GPIO_IN_PIN20 = 0x100000
	// Pin input is low.
	GPIO_IN_PIN20_Low = 0x0
	// Pin input is high.
	GPIO_IN_PIN20_High = 0x1
	// Position of PIN21 field.
	GPIO_IN_PIN21_Pos = 0x15
	// Bit mask of PIN21 field.
	GPIO_IN_PIN21_Msk = 0x200000
	// Bit PIN21.
	GPIO_IN_PIN21 = 0x200000
	// Pin input is low.
	GPIO_IN_PIN21_Low = 0x0
	// Pin input is high.
	GPIO_IN_PIN21_High = 0x1
	// Position of PIN22 field.
	GPIO_IN_PIN22_Pos = 0x16
	// Bit mask of PIN22 field.
	GPIO_IN_PIN22_Msk = 0x400000
	// Bit PIN22.
	GPIO_IN_PIN22 = 0x400000
	// Pin input is low.
	GPIO_IN_PIN22_Low = 0x0
	// Pin input is high.
	GPIO_IN_PIN22_High = 0x1
	// Position of PIN23 field.
	GPIO_IN_PIN23_Pos = 0x17
	// Bit mask of PIN23 field.
	GPIO_IN_PIN23_Msk = 0x800000
	// Bit PIN23.
	GPIO_IN_PIN23 = 0x800000
	// Pin input is low.
	GPIO_IN_PIN23_Low = 0x0
	// Pin input is high.
	GPIO_IN_PIN23_High = 0x1
	// Position of PIN24 field.
	GPIO_IN_PIN24_Pos = 0x18
	// Bit mask of PIN24 field.
	GPIO_IN_PIN24_Msk = 0x1000000
	// Bit PIN24.
	GPIO_IN_PIN24 = 0x1000000
	// Pin input is low.
	GPIO_IN_PIN24_Low = 0x0
	// Pin input is high.
	GPIO_IN_PIN24_High = 0x1
	// Position of PIN25 field.
	GPIO_IN_PIN25_Pos = 0x19
	// Bit mask of PIN25 field.
	GPIO_IN_PIN25_Msk = 0x2000000
	// Bit PIN25.
	GPIO_IN_PIN25 = 0x2000000
	// Pin input is low.
	GPIO_IN_PIN25_Low = 0x0
	// Pin input is high.
	GPIO_IN_PIN25_High = 0x1
	// Position of PIN26 field.
	GPIO_IN_PIN26_Pos = 0x1a
	// Bit mask of PIN26 field.
	GPIO_IN_PIN26_Msk = 0x4000000
	// Bit PIN26.
	GPIO_IN_PIN26 = 0x4000000
	// Pin input is low.
	GPIO_IN_PIN26_Low = 0x0
	// Pin input is high.
	GPIO_IN_PIN26_High = 0x1
	// Position of PIN27 field.
	GPIO_IN_PIN27_Pos = 0x1b
	// Bit mask of PIN27 field.
	GPIO_IN_PIN27_Msk = 0x8000000
	// Bit PIN27.
	GPIO_IN_PIN27 = 0x8000000
	// Pin input is low.
	GPIO_IN_PIN27_Low = 0x0
	// Pin input is high.
	GPIO_IN_PIN27_High = 0x1
	// Position of PIN28 field.
	GPIO_IN_PIN28_Pos = 0x1c
	// Bit mask of PIN28 field.
	GPIO_IN_PIN28_Msk = 0x10000000
	// Bit PIN28.
	GPIO_IN_PIN28 = 0x10000000
	// Pin input is low.
	GPIO_IN_PIN28_Low = 0x0
	// Pin input is high.
	GPIO_IN_PIN28_High = 0x1
	// Position of PIN29 field.
	GPIO_IN_PIN29_Pos = 0x1d
	// Bit mask of PIN29 field.
	GPIO_IN_PIN29_Msk = 0x20000000
	// Bit PIN29.
	GPIO_IN_PIN29 = 0x20000000
	// Pin input is low.
	GPIO_IN_PIN29_Low = 0x0
	// Pin input is high.
	GPIO_IN_PIN29_High = 0x1
	// Position of PIN30 field.
	GPIO_IN_PIN30_Pos = 0x1e
	// Bit mask of PIN30 field.
	GPIO_IN_PIN30_Msk = 0x40000000
	// Bit PIN30.
	GPIO_IN_PIN30 = 0x40000000
	// Pin input is low.
	GPIO_IN_PIN30_Low = 0x0
	// Pin input is high.
	GPIO_IN_PIN30_High = 0x1
	// Position of PIN31 field.
	GPIO_IN_PIN31_Pos = 0x1f
	// Bit mask of PIN31 field.
	GPIO_IN_PIN31_Msk = 0x80000000
	// Bit PIN31.
	GPIO_IN_PIN31 = 0x80000000
	// Pin input is low.
	GPIO_IN_PIN31_Low = 0x0
	// Pin input is high.
	GPIO_IN_PIN31_High = 0x1

	// DIR: Direction of GPIO pins.
	// Position of PIN0 field.
	GPIO_DIR_PIN0_Pos = 0x0
	// Bit mask of PIN0 field.
	GPIO_DIR_PIN0_Msk = 0x1
	// Bit PIN0.
	GPIO_DIR_PIN0 = 0x1
	// Pin set as input.
	GPIO_DIR_PIN0_Input = 0x0
	// Pin set as output.
	GPIO_DIR_PIN0_Output = 0x1
	// Position of PIN1 field.
	GPIO_DIR_PIN1_Pos = 0x1
	// Bit mask of PIN1 field.
	GPIO_DIR_PIN1_Msk = 0x2
	// Bit PIN1.
	GPIO_DIR_PIN1 = 0x2
	// Pin set as input.
	GPIO_DIR_PIN1_Input = 0x0
	// Pin set as output.
	GPIO_DIR_PIN1_Output = 0x1
	// Position of PIN2 field.
	GPIO_DIR_PIN2_Pos = 0x2
	// Bit mask of PIN2 field.
	GPIO_DIR_PIN2_Msk = 0x4
	// Bit PIN2.
	GPIO_DIR_PIN2 = 0x4
	// Pin set as input.
	GPIO_DIR_PIN2_Input = 0x0
	// Pin set as output.
	GPIO_DIR_PIN2_Output = 0x1
	// Position of PIN3 field.
	GPIO_DIR_PIN3_Pos = 0x3
	// Bit mask of PIN3 field.
	GPIO_DIR_PIN3_Msk = 0x8
	// Bit PIN3.
	GPIO_DIR_PIN3 = 0x8
	// Pin set as input.
	GPIO_DIR_PIN3_Input = 0x0
	// Pin set as output.
	GPIO_DIR_PIN3_Output = 0x1
	// Position of PIN4 field.
	GPIO_DIR_PIN4_Pos = 0x4
	// Bit mask of PIN4 field.
	GPIO_DIR_PIN4_Msk = 0x10
	// Bit PIN4.
	GPIO_DIR_PIN4 = 0x10
	// Pin set as input.
	GPIO_DIR_PIN4_Input = 0x0
	// Pin set as output.
	GPIO_DIR_PIN4_Output = 0x1
	// Position of PIN5 field.
	GPIO_DIR_PIN5_Pos = 0x5
	// Bit mask of PIN5 field.
	GPIO_DIR_PIN5_Msk = 0x20
	// Bit PIN5.
	GPIO_DIR_PIN5 = 0x20
	// Pin set as input.
	GPIO_DIR_PIN5_Input = 0x0
	// Pin set as output.
	GPIO_DIR_PIN5_Output = 0x1
	// Position of PIN6 field.
	GPIO_DIR_PIN6_Pos = 0x6
	// Bit mask of PIN6 field.
	GPIO_DIR_PIN6_Msk = 0x40
	// Bit PIN6.
	GPIO_DIR_PIN6 = 0x40
	// Pin set as input.
	GPIO_DIR_PIN6_Input = 0x0
	// Pin set as output.
	GPIO_DIR_PIN6_Output = 0x1
	// Position of PIN7 field.
	GPIO_DIR_PIN7_Pos = 0x7
	// Bit mask of PIN7 field.
	GPIO_DIR_PIN7_Msk = 0x80
	// Bit PIN7.
	GPIO_DIR_PIN7 = 0x80
	// Pin set as input.
	GPIO_DIR_PIN7_Input = 0x0
	// Pin set as output.
	GPIO_DIR_PIN7_Output = 0x1
	// Position of PIN8 field.
	GPIO_DIR_PIN8_Pos = 0x8
	// Bit mask of PIN8 field.
	GPIO_DIR_PIN8_Msk = 0x100
	// Bit PIN8.
	GPIO_DIR_PIN8 = 0x100
	// Pin set as input.
	GPIO_DIR_PIN8_Input = 0x0
	// Pin set as output.
	GPIO_DIR_PIN8_Output = 0x1
	// Position of PIN9 field.
	GPIO_DIR_PIN9_Pos = 0x9
	// Bit mask of PIN9 field.
	GPIO_DIR_PIN9_Msk = 0x200
	// Bit PIN9.
	GPIO_DIR_PIN9 = 0x200
	// Pin set as input.
	GPIO_DIR_PIN9_Input = 0x0
	// Pin set as output.
	GPIO_DIR_PIN9_Output = 0x1
	// Position of PIN10 field.
	GPIO_DIR_PIN10_Pos = 0xa
	// Bit mask of PIN10 field.
	GPIO_DIR_PIN10_Msk = 0x400
	// Bit PIN10.
	GPIO_DIR_PIN10 = 0x400
	// Pin set as input.
	GPIO_DIR_PIN10_Input = 0x0
	// Pin set as output.
	GPIO_DIR_PIN10_Output = 0x1
	// Position of PIN11 field.
	GPIO_DIR_PIN11_Pos = 0xb
	// Bit mask of PIN11 field.
	GPIO_DIR_PIN11_Msk = 0x800
	// Bit PIN11.
	GPIO_DIR_PIN11 = 0x800
	// Pin set as input.
	GPIO_DIR_PIN11_Input = 0x0
	// Pin set as output.
	GPIO_DIR_PIN11_Output = 0x1
	// Position of PIN12 field.
	GPIO_DIR_PIN12_Pos = 0xc
	// Bit mask of PIN12 field.
	GPIO_DIR_PIN12_Msk = 0x1000
	// Bit PIN12.
	GPIO_DIR_PIN12 = 0x1000
	// Pin set as input.
	GPIO_DIR_PIN12_Input = 0x0
	// Pin set as output.
	GPIO_DIR_PIN12_Output = 0x1
	// Position of PIN13 field.
	GPIO_DIR_PIN13_Pos = 0xd
	// Bit mask of PIN13 field.
	GPIO_DIR_PIN13_Msk = 0x2000
	// Bit PIN13.
	GPIO_DIR_PIN13 = 0x2000
	// Pin set as input.
	GPIO_DIR_PIN13_Input = 0x0
	// Pin set as output.
	GPIO_DIR_PIN13_Output = 0x1
	// Position of PIN14 field.
	GPIO_DIR_PIN14_Pos = 0xe
	// Bit mask of PIN14 field.
	GPIO_DIR_PIN14_Msk = 0x4000
	// Bit PIN14.
	GPIO_DIR_PIN14 = 0x4000
	// Pin set as input.
	GPIO_DIR_PIN14_Input = 0x0
	// Pin set as output.
	GPIO_DIR_PIN14_Output = 0x1
	// Position of PIN15 field.
	GPIO_DIR_PIN15_Pos = 0xf
	// Bit mask of PIN15 field.
	GPIO_DIR_PIN15_Msk = 0x8000
	// Bit PIN15.
	GPIO_DIR_PIN15 = 0x8000
	// Pin set as input.
	GPIO_DIR_PIN15_Input = 0x0
	// Pin set as output.
	GPIO_DIR_PIN15_Output = 0x1
	// Position of PIN16 field.
	GPIO_DIR_PIN16_Pos = 0x10
	// Bit mask of PIN16 field.
	GPIO_DIR_PIN16_Msk = 0x10000
	// Bit PIN16.
	GPIO_DIR_PIN16 = 0x10000
	// Pin set as input.
	GPIO_DIR_PIN16_Input = 0x0
	// Pin set as output.
	GPIO_DIR_PIN16_Output = 0x1
	// Position of PIN17 field.
	GPIO_DIR_PIN17_Pos = 0x11
	// Bit mask of PIN17 field.
	GPIO_DIR_PIN17_Msk = 0x20000
	// Bit PIN17.
	GPIO_DIR_PIN17 = 0x20000
	// Pin set as input.
	GPIO_DIR_PIN17_Input = 0x0
	// Pin set as output.
	GPIO_DIR_PIN17_Output = 0x1
	// Position of PIN18 field.
	GPIO_DIR_PIN18_Pos = 0x12
	// Bit mask of PIN18 field.
	GPIO_DIR_PIN18_Msk = 0x40000
	// Bit PIN18.
	GPIO_DIR_PIN18 = 0x40000
	// Pin set as input.
	GPIO_DIR_PIN18_Input = 0x0
	// Pin set as output.
	GPIO_DIR_PIN18_Output = 0x1
	// Position of PIN19 field.
	GPIO_DIR_PIN19_Pos = 0x13
	// Bit mask of PIN19 field.
	GPIO_DIR_PIN19_Msk = 0x80000
	// Bit PIN19.
	GPIO_DIR_PIN19 = 0x80000
	// Pin set as input.
	GPIO_DIR_PIN19_Input = 0x0
	// Pin set as output.
	GPIO_DIR_PIN19_Output = 0x1
	// Position of PIN20 field.
	GPIO_DIR_PIN20_Pos = 0x14
	// Bit mask of PIN20 field.
	GPIO_DIR_PIN20_Msk = 0x100000
	// Bit PIN20.
	GPIO_DIR_PIN20 = 0x100000
	// Pin set as input.
	GPIO_DIR_PIN20_Input = 0x0
	// Pin set as output.
	GPIO_DIR_PIN20_Output = 0x1
	// Position of PIN21 field.
	GPIO_DIR_PIN21_Pos = 0x15
	// Bit mask of PIN21 field.
	GPIO_DIR_PIN21_Msk = 0x200000
	// Bit PIN21.
	GPIO_DIR_PIN21 = 0x200000
	// Pin set as input.
	GPIO_DIR_PIN21_Input = 0x0
	// Pin set as output.
	GPIO_DIR_PIN21_Output = 0x1
	// Position of PIN22 field.
	GPIO_DIR_PIN22_Pos = 0x16
	// Bit mask of PIN22 field.
	GPIO_DIR_PIN22_Msk = 0x400000
	// Bit PIN22.
	GPIO_DIR_PIN22 = 0x400000
	// Pin set as input.
	GPIO_DIR_PIN22_Input = 0x0
	// Pin set as output.
	GPIO_DIR_PIN22_Output = 0x1
	// Position of PIN23 field.
	GPIO_DIR_PIN23_Pos = 0x17
	// Bit mask of PIN23 field.
	GPIO_DIR_PIN23_Msk = 0x800000
	// Bit PIN23.
	GPIO_DIR_PIN23 = 0x800000
	// Pin set as input.
	GPIO_DIR_PIN23_Input = 0x0
	// Pin set as output.
	GPIO_DIR_PIN23_Output = 0x1
	// Position of PIN24 field.
	GPIO_DIR_PIN24_Pos = 0x18
	// Bit mask of PIN24 field.
	GPIO_DIR_PIN24_Msk = 0x1000000
	// Bit PIN24.
	GPIO_DIR_PIN24 = 0x1000000
	// Pin set as input.
	GPIO_DIR_PIN24_Input = 0x0
	// Pin set as output.
	GPIO_DIR_PIN24_Output = 0x1
	// Position of PIN25 field.
	GPIO_DIR_PIN25_Pos = 0x19
	// Bit mask of PIN25 field.
	GPIO_DIR_PIN25_Msk = 0x2000000
	// Bit PIN25.
	GPIO_DIR_PIN25 = 0x2000000
	// Pin set as input.
	GPIO_DIR_PIN25_Input = 0x0
	// Pin set as output.
	GPIO_DIR_PIN25_Output = 0x1
	// Position of PIN26 field.
	GPIO_DIR_PIN26_Pos = 0x1a
	// Bit mask of PIN26 field.
	GPIO_DIR_PIN26_Msk = 0x4000000
	// Bit PIN26.
	GPIO_DIR_PIN26 = 0x4000000
	// Pin set as input.
	GPIO_DIR_PIN26_Input = 0x0
	// Pin set as output.
	GPIO_DIR_PIN26_Output = 0x1
	// Position of PIN27 field.
	GPIO_DIR_PIN27_Pos = 0x1b
	// Bit mask of PIN27 field.
	GPIO_DIR_PIN27_Msk = 0x8000000
	// Bit PIN27.
	GPIO_DIR_PIN27 = 0x8000000
	// Pin set as input.
	GPIO_DIR_PIN27_Input = 0x0
	// Pin set as output.
	GPIO_DIR_PIN27_Output = 0x1
	// Position of PIN28 field.
	GPIO_DIR_PIN28_Pos = 0x1c
	// Bit mask of PIN28 field.
	GPIO_DIR_PIN28_Msk = 0x10000000
	// Bit PIN28.
	GPIO_DIR_PIN28 = 0x10000000
	// Pin set as input.
	GPIO_DIR_PIN28_Input = 0x0
	// Pin set as output.
	GPIO_DIR_PIN28_Output = 0x1
	// Position of PIN29 field.
	GPIO_DIR_PIN29_Pos = 0x1d
	// Bit mask of PIN29 field.
	GPIO_DIR_PIN29_Msk = 0x20000000
	// Bit PIN29.
	GPIO_DIR_PIN29 = 0x20000000
	// Pin set as input.
	GPIO_DIR_PIN29_Input = 0x0
	// Pin set as output.
	GPIO_DIR_PIN29_Output = 0x1
	// Position of PIN30 field.
	GPIO_DIR_PIN30_Pos = 0x1e
	// Bit mask of PIN30 field.
	GPIO_DIR_PIN30_Msk = 0x40000000
	// Bit PIN30.
	GPIO_DIR_PIN30 = 0x40000000
	// Pin set as input.
	GPIO_DIR_PIN30_Input = 0x0
	// Pin set as output.
	GPIO_DIR_PIN30_Output = 0x1
	// Position of PIN31 field.
	GPIO_DIR_PIN31_Pos = 0x1f
	// Bit mask of PIN31 field.
	GPIO_DIR_PIN31_Msk = 0x80000000
	// Bit PIN31.
	GPIO_DIR_PIN31 = 0x80000000
	// Pin set as input.
	GPIO_DIR_PIN31_Input = 0x0
	// Pin set as output.
	GPIO_DIR_PIN31_Output = 0x1

	// DIRSET: DIR set register.
	// Position of PIN0 field.
	GPIO_DIRSET_PIN0_Pos = 0x0
	// Bit mask of PIN0 field.
	GPIO_DIRSET_PIN0_Msk = 0x1
	// Bit PIN0.
	GPIO_DIRSET_PIN0 = 0x1
	// Pin set as input.
	GPIO_DIRSET_PIN0_Input = 0x0
	// Pin set as output.
	GPIO_DIRSET_PIN0_Output = 0x1
	// Set pin as output.
	GPIO_DIRSET_PIN0_Set = 0x1
	// Position of PIN1 field.
	GPIO_DIRSET_PIN1_Pos = 0x1
	// Bit mask of PIN1 field.
	GPIO_DIRSET_PIN1_Msk = 0x2
	// Bit PIN1.
	GPIO_DIRSET_PIN1 = 0x2
	// Pin set as input.
	GPIO_DIRSET_PIN1_Input = 0x0
	// Pin set as output.
	GPIO_DIRSET_PIN1_Output = 0x1
	// Set pin as output.
	GPIO_DIRSET_PIN1_Set = 0x1
	// Position of PIN2 field.
	GPIO_DIRSET_PIN2_Pos = 0x2
	// Bit mask of PIN2 field.
	GPIO_DIRSET_PIN2_Msk = 0x4
	// Bit PIN2.
	GPIO_DIRSET_PIN2 = 0x4
	// Pin set as input.
	GPIO_DIRSET_PIN2_Input = 0x0
	// Pin set as output.
	GPIO_DIRSET_PIN2_Output = 0x1
	// Set pin as output.
	GPIO_DIRSET_PIN2_Set = 0x1
	// Position of PIN3 field.
	GPIO_DIRSET_PIN3_Pos = 0x3
	// Bit mask of PIN3 field.
	GPIO_DIRSET_PIN3_Msk = 0x8
	// Bit PIN3.
	GPIO_DIRSET_PIN3 = 0x8
	// Pin set as input.
	GPIO_DIRSET_PIN3_Input = 0x0
	// Pin set as output.
	GPIO_DIRSET_PIN3_Output = 0x1
	// Set pin as output.
	GPIO_DIRSET_PIN3_Set = 0x1
	// Position of PIN4 field.
	GPIO_DIRSET_PIN4_Pos = 0x4
	// Bit mask of PIN4 field.
	GPIO_DIRSET_PIN4_Msk = 0x10
	// Bit PIN4.
	GPIO_DIRSET_PIN4 = 0x10
	// Pin set as input.
	GPIO_DIRSET_PIN4_Input = 0x0
	// Pin set as output.
	GPIO_DIRSET_PIN4_Output = 0x1
	// Set pin as output.
	GPIO_DIRSET_PIN4_Set = 0x1
	// Position of PIN5 field.
	GPIO_DIRSET_PIN5_Pos = 0x5
	// Bit mask of PIN5 field.
	GPIO_DIRSET_PIN5_Msk = 0x20
	// Bit PIN5.
	GPIO_DIRSET_PIN5 = 0x20
	// Pin set as input.
	GPIO_DIRSET_PIN5_Input = 0x0
	// Pin set as output.
	GPIO_DIRSET_PIN5_Output = 0x1
	// Set pin as output.
	GPIO_DIRSET_PIN5_Set = 0x1
	// Position of PIN6 field.
	GPIO_DIRSET_PIN6_Pos = 0x6
	// Bit mask of PIN6 field.
	GPIO_DIRSET_PIN6_Msk = 0x40
	// Bit PIN6.
	GPIO_DIRSET_PIN6 = 0x40
	// Pin set as input.
	GPIO_DIRSET_PIN6_Input = 0x0
	// Pin set as output.
	GPIO_DIRSET_PIN6_Output = 0x1
	// Set pin as output.
	GPIO_DIRSET_PIN6_Set = 0x1
	// Position of PIN7 field.
	GPIO_DIRSET_PIN7_Pos = 0x7
	// Bit mask of PIN7 field.
	GPIO_DIRSET_PIN7_Msk = 0x80
	// Bit PIN7.
	GPIO_DIRSET_PIN7 = 0x80
	// Pin set as input.
	GPIO_DIRSET_PIN7_Input = 0x0
	// Pin set as output.
	GPIO_DIRSET_PIN7_Output = 0x1
	// Set pin as output.
	GPIO_DIRSET_PIN7_Set = 0x1
	// Position of PIN8 field.
	GPIO_DIRSET_PIN8_Pos = 0x8
	// Bit mask of PIN8 field.
	GPIO_DIRSET_PIN8_Msk = 0x100
	// Bit PIN8.
	GPIO_DIRSET_PIN8 = 0x100
	// Pin set as input.
	GPIO_DIRSET_PIN8_Input = 0x0
	// Pin set as output.
	GPIO_DIRSET_PIN8_Output = 0x1
	// Set pin as output.
	GPIO_DIRSET_PIN8_Set = 0x1
	// Position of PIN9 field.
	GPIO_DIRSET_PIN9_Pos = 0x9
	// Bit mask of PIN9 field.
	GPIO_DIRSET_PIN9_Msk = 0x200
	// Bit PIN9.
	GPIO_DIRSET_PIN9 = 0x200
	// Pin set as input.
	GPIO_DIRSET_PIN9_Input = 0x0
	// Pin set as output.
	GPIO_DIRSET_PIN9_Output = 0x1
	// Set pin as output.
	GPIO_DIRSET_PIN9_Set = 0x1
	// Position of PIN10 field.
	GPIO_DIRSET_PIN10_Pos = 0xa
	// Bit mask of PIN10 field.
	GPIO_DIRSET_PIN10_Msk = 0x400
	// Bit PIN10.
	GPIO_DIRSET_PIN10 = 0x400
	// Pin set as input.
	GPIO_DIRSET_PIN10_Input = 0x0
	// Pin set as output.
	GPIO_DIRSET_PIN10_Output = 0x1
	// Set pin as output.
	GPIO_DIRSET_PIN10_Set = 0x1
	// Position of PIN11 field.
	GPIO_DIRSET_PIN11_Pos = 0xb
	// Bit mask of PIN11 field.
	GPIO_DIRSET_PIN11_Msk = 0x800
	// Bit PIN11.
	GPIO_DIRSET_PIN11 = 0x800
	// Pin set as input.
	GPIO_DIRSET_PIN11_Input = 0x0
	// Pin set as output.
	GPIO_DIRSET_PIN11_Output = 0x1
	// Set pin as output.
	GPIO_DIRSET_PIN11_Set = 0x1
	// Position of PIN12 field.
	GPIO_DIRSET_PIN12_Pos = 0xc
	// Bit mask of PIN12 field.
	GPIO_DIRSET_PIN12_Msk = 0x1000
	// Bit PIN12.
	GPIO_DIRSET_PIN12 = 0x1000
	// Pin set as input.
	GPIO_DIRSET_PIN12_Input = 0x0
	// Pin set as output.
	GPIO_DIRSET_PIN12_Output = 0x1
	// Set pin as output.
	GPIO_DIRSET_PIN12_Set = 0x1
	// Position of PIN13 field.
	GPIO_DIRSET_PIN13_Pos = 0xd
	// Bit mask of PIN13 field.
	GPIO_DIRSET_PIN13_Msk = 0x2000
	// Bit PIN13.
	GPIO_DIRSET_PIN13 = 0x2000
	// Pin set as input.
	GPIO_DIRSET_PIN13_Input = 0x0
	// Pin set as output.
	GPIO_DIRSET_PIN13_Output = 0x1
	// Set pin as output.
	GPIO_DIRSET_PIN13_Set = 0x1
	// Position of PIN14 field.
	GPIO_DIRSET_PIN14_Pos = 0xe
	// Bit mask of PIN14 field.
	GPIO_DIRSET_PIN14_Msk = 0x4000
	// Bit PIN14.
	GPIO_DIRSET_PIN14 = 0x4000
	// Pin set as input.
	GPIO_DIRSET_PIN14_Input = 0x0
	// Pin set as output.
	GPIO_DIRSET_PIN14_Output = 0x1
	// Set pin as output.
	GPIO_DIRSET_PIN14_Set = 0x1
	// Position of PIN15 field.
	GPIO_DIRSET_PIN15_Pos = 0xf
	// Bit mask of PIN15 field.
	GPIO_DIRSET_PIN15_Msk = 0x8000
	// Bit PIN15.
	GPIO_DIRSET_PIN15 = 0x8000
	// Pin set as input.
	GPIO_DIRSET_PIN15_Input = 0x0
	// Pin set as output.
	GPIO_DIRSET_PIN15_Output = 0x1
	// Set pin as output.
	GPIO_DIRSET_PIN15_Set = 0x1
	// Position of PIN16 field.
	GPIO_DIRSET_PIN16_Pos = 0x10
	// Bit mask of PIN16 field.
	GPIO_DIRSET_PIN16_Msk = 0x10000
	// Bit PIN16.
	GPIO_DIRSET_PIN16 = 0x10000
	// Pin set as input.
	GPIO_DIRSET_PIN16_Input = 0x0
	// Pin set as output.
	GPIO_DIRSET_PIN16_Output = 0x1
	// Set pin as output.
	GPIO_DIRSET_PIN16_Set = 0x1
	// Position of PIN17 field.
	GPIO_DIRSET_PIN17_Pos = 0x11
	// Bit mask of PIN17 field.
	GPIO_DIRSET_PIN17_Msk = 0x20000
	// Bit PIN17.
	GPIO_DIRSET_PIN17 = 0x20000
	// Pin set as input.
	GPIO_DIRSET_PIN17_Input = 0x0
	// Pin set as output.
	GPIO_DIRSET_PIN17_Output = 0x1
	// Set pin as output.
	GPIO_DIRSET_PIN17_Set = 0x1
	// Position of PIN18 field.
	GPIO_DIRSET_PIN18_Pos = 0x12
	// Bit mask of PIN18 field.
	GPIO_DIRSET_PIN18_Msk = 0x40000
	// Bit PIN18.
	GPIO_DIRSET_PIN18 = 0x40000
	// Pin set as input.
	GPIO_DIRSET_PIN18_Input = 0x0
	// Pin set as output.
	GPIO_DIRSET_PIN18_Output = 0x1
	// Set pin as output.
	GPIO_DIRSET_PIN18_Set = 0x1
	// Position of PIN19 field.
	GPIO_DIRSET_PIN19_Pos = 0x13
	// Bit mask of PIN19 field.
	GPIO_DIRSET_PIN19_Msk = 0x80000
	// Bit PIN19.
	GPIO_DIRSET_PIN19 = 0x80000
	// Pin set as input.
	GPIO_DIRSET_PIN19_Input = 0x0
	// Pin set as output.
	GPIO_DIRSET_PIN19_Output = 0x1
	// Set pin as output.
	GPIO_DIRSET_PIN19_Set = 0x1
	// Position of PIN20 field.
	GPIO_DIRSET_PIN20_Pos = 0x14
	// Bit mask of PIN20 field.
	GPIO_DIRSET_PIN20_Msk = 0x100000
	// Bit PIN20.
	GPIO_DIRSET_PIN20 = 0x100000
	// Pin set as input.
	GPIO_DIRSET_PIN20_Input = 0x0
	// Pin set as output.
	GPIO_DIRSET_PIN20_Output = 0x1
	// Set pin as output.
	GPIO_DIRSET_PIN20_Set = 0x1
	// Position of PIN21 field.
	GPIO_DIRSET_PIN21_Pos = 0x15
	// Bit mask of PIN21 field.
	GPIO_DIRSET_PIN21_Msk = 0x200000
	// Bit PIN21.
	GPIO_DIRSET_PIN21 = 0x200000
	// Pin set as input.
	GPIO_DIRSET_PIN21_Input = 0x0
	// Pin set as output.
	GPIO_DIRSET_PIN21_Output = 0x1
	// Set pin as output.
	GPIO_DIRSET_PIN21_Set = 0x1
	// Position of PIN22 field.
	GPIO_DIRSET_PIN22_Pos = 0x16
	// Bit mask of PIN22 field.
	GPIO_DIRSET_PIN22_Msk = 0x400000
	// Bit PIN22.
	GPIO_DIRSET_PIN22 = 0x400000
	// Pin set as input.
	GPIO_DIRSET_PIN22_Input = 0x0
	// Pin set as output.
	GPIO_DIRSET_PIN22_Output = 0x1
	// Set pin as output.
	GPIO_DIRSET_PIN22_Set = 0x1
	// Position of PIN23 field.
	GPIO_DIRSET_PIN23_Pos = 0x17
	// Bit mask of PIN23 field.
	GPIO_DIRSET_PIN23_Msk = 0x800000
	// Bit PIN23.
	GPIO_DIRSET_PIN23 = 0x800000
	// Pin set as input.
	GPIO_DIRSET_PIN23_Input = 0x0
	// Pin set as output.
	GPIO_DIRSET_PIN23_Output = 0x1
	// Set pin as output.
	GPIO_DIRSET_PIN23_Set = 0x1
	// Position of PIN24 field.
	GPIO_DIRSET_PIN24_Pos = 0x18
	// Bit mask of PIN24 field.
	GPIO_DIRSET_PIN24_Msk = 0x1000000
	// Bit PIN24.
	GPIO_DIRSET_PIN24 = 0x1000000
	// Pin set as input.
	GPIO_DIRSET_PIN24_Input = 0x0
	// Pin set as output.
	GPIO_DIRSET_PIN24_Output = 0x1
	// Set pin as output.
	GPIO_DIRSET_PIN24_Set = 0x1
	// Position of PIN25 field.
	GPIO_DIRSET_PIN25_Pos = 0x19
	// Bit mask of PIN25 field.
	GPIO_DIRSET_PIN25_Msk = 0x2000000
	// Bit PIN25.
	GPIO_DIRSET_PIN25 = 0x2000000
	// Pin set as input.
	GPIO_DIRSET_PIN25_Input = 0x0
	// Pin set as output.
	GPIO_DIRSET_PIN25_Output = 0x1
	// Set pin as output.
	GPIO_DIRSET_PIN25_Set = 0x1
	// Position of PIN26 field.
	GPIO_DIRSET_PIN26_Pos = 0x1a
	// Bit mask of PIN26 field.
	GPIO_DIRSET_PIN26_Msk = 0x4000000
	// Bit PIN26.
	GPIO_DIRSET_PIN26 = 0x4000000
	// Pin set as input.
	GPIO_DIRSET_PIN26_Input = 0x0
	// Pin set as output.
	GPIO_DIRSET_PIN26_Output = 0x1
	// Set pin as output.
	GPIO_DIRSET_PIN26_Set = 0x1
	// Position of PIN27 field.
	GPIO_DIRSET_PIN27_Pos = 0x1b
	// Bit mask of PIN27 field.
	GPIO_DIRSET_PIN27_Msk = 0x8000000
	// Bit PIN27.
	GPIO_DIRSET_PIN27 = 0x8000000
	// Pin set as input.
	GPIO_DIRSET_PIN27_Input = 0x0
	// Pin set as output.
	GPIO_DIRSET_PIN27_Output = 0x1
	// Set pin as output.
	GPIO_DIRSET_PIN27_Set = 0x1
	// Position of PIN28 field.
	GPIO_DIRSET_PIN28_Pos = 0x1c
	// Bit mask of PIN28 field.
	GPIO_DIRSET_PIN28_Msk = 0x10000000
	// Bit PIN28.
	GPIO_DIRSET_PIN28 = 0x10000000
	// Pin set as input.
	GPIO_DIRSET_PIN28_Input = 0x0
	// Pin set as output.
	GPIO_DIRSET_PIN28_Output = 0x1
	// Set pin as output.
	GPIO_DIRSET_PIN28_Set = 0x1
	// Position of PIN29 field.
	GPIO_DIRSET_PIN29_Pos = 0x1d
	// Bit mask of PIN29 field.
	GPIO_DIRSET_PIN29_Msk = 0x20000000
	// Bit PIN29.
	GPIO_DIRSET_PIN29 = 0x20000000
	// Pin set as input.
	GPIO_DIRSET_PIN29_Input = 0x0
	// Pin set as output.
	GPIO_DIRSET_PIN29_Output = 0x1
	// Set pin as output.
	GPIO_DIRSET_PIN29_Set = 0x1
	// Position of PIN30 field.
	GPIO_DIRSET_PIN30_Pos = 0x1e
	// Bit mask of PIN30 field.
	GPIO_DIRSET_PIN30_Msk = 0x40000000
	// Bit PIN30.
	GPIO_DIRSET_PIN30 = 0x40000000
	// Pin set as input.
	GPIO_DIRSET_PIN30_Input = 0x0
	// Pin set as output.
	GPIO_DIRSET_PIN30_Output = 0x1
	// Set pin as output.
	GPIO_DIRSET_PIN30_Set = 0x1
	// Position of PIN31 field.
	GPIO_DIRSET_PIN31_Pos = 0x1f
	// Bit mask of PIN31 field.
	GPIO_DIRSET_PIN31_Msk = 0x80000000
	// Bit PIN31.
	GPIO_DIRSET_PIN31 = 0x80000000
	// Pin set as input.
	GPIO_DIRSET_PIN31_Input = 0x0
	// Pin set as output.
	GPIO_DIRSET_PIN31_Output = 0x1
	// Set pin as output.
	GPIO_DIRSET_PIN31_Set = 0x1

	// DIRCLR: DIR clear register.
	// Position of PIN0 field.
	GPIO_DIRCLR_PIN0_Pos = 0x0
	// Bit mask of PIN0 field.
	GPIO_DIRCLR_PIN0_Msk = 0x1
	// Bit PIN0.
	GPIO_DIRCLR_PIN0 = 0x1
	// Pin set as input.
	GPIO_DIRCLR_PIN0_Input = 0x0
	// Pin set as output.
	GPIO_DIRCLR_PIN0_Output = 0x1
	// Set pin as input.
	GPIO_DIRCLR_PIN0_Clear = 0x1
	// Position of PIN1 field.
	GPIO_DIRCLR_PIN1_Pos = 0x1
	// Bit mask of PIN1 field.
	GPIO_DIRCLR_PIN1_Msk = 0x2
	// Bit PIN1.
	GPIO_DIRCLR_PIN1 = 0x2
	// Pin set as input.
	GPIO_DIRCLR_PIN1_Input = 0x0
	// Pin set as output.
	GPIO_DIRCLR_PIN1_Output = 0x1
	// Set pin as input.
	GPIO_DIRCLR_PIN1_Clear = 0x1
	// Position of PIN2 field.
	GPIO_DIRCLR_PIN2_Pos = 0x2
	// Bit mask of PIN2 field.
	GPIO_DIRCLR_PIN2_Msk = 0x4
	// Bit PIN2.
	GPIO_DIRCLR_PIN2 = 0x4
	// Pin set as input.
	GPIO_DIRCLR_PIN2_Input = 0x0
	// Pin set as output.
	GPIO_DIRCLR_PIN2_Output = 0x1
	// Set pin as input.
	GPIO_DIRCLR_PIN2_Clear = 0x1
	// Position of PIN3 field.
	GPIO_DIRCLR_PIN3_Pos = 0x3
	// Bit mask of PIN3 field.
	GPIO_DIRCLR_PIN3_Msk = 0x8
	// Bit PIN3.
	GPIO_DIRCLR_PIN3 = 0x8
	// Pin set as input.
	GPIO_DIRCLR_PIN3_Input = 0x0
	// Pin set as output.
	GPIO_DIRCLR_PIN3_Output = 0x1
	// Set pin as input.
	GPIO_DIRCLR_PIN3_Clear = 0x1
	// Position of PIN4 field.
	GPIO_DIRCLR_PIN4_Pos = 0x4
	// Bit mask of PIN4 field.
	GPIO_DIRCLR_PIN4_Msk = 0x10
	// Bit PIN4.
	GPIO_DIRCLR_PIN4 = 0x10
	// Pin set as input.
	GPIO_DIRCLR_PIN4_Input = 0x0
	// Pin set as output.
	GPIO_DIRCLR_PIN4_Output = 0x1
	// Set pin as input.
	GPIO_DIRCLR_PIN4_Clear = 0x1
	// Position of PIN5 field.
	GPIO_DIRCLR_PIN5_Pos = 0x5
	// Bit mask of PIN5 field.
	GPIO_DIRCLR_PIN5_Msk = 0x20
	// Bit PIN5.
	GPIO_DIRCLR_PIN5 = 0x20
	// Pin set as input.
	GPIO_DIRCLR_PIN5_Input = 0x0
	// Pin set as output.
	GPIO_DIRCLR_PIN5_Output = 0x1
	// Set pin as input.
	GPIO_DIRCLR_PIN5_Clear = 0x1
	// Position of PIN6 field.
	GPIO_DIRCLR_PIN6_Pos = 0x6
	// Bit mask of PIN6 field.
	GPIO_DIRCLR_PIN6_Msk = 0x40
	// Bit PIN6.
	GPIO_DIRCLR_PIN6 = 0x40
	// Pin set as input.
	GPIO_DIRCLR_PIN6_Input = 0x0
	// Pin set as output.
	GPIO_DIRCLR_PIN6_Output = 0x1
	// Set pin as input.
	GPIO_DIRCLR_PIN6_Clear = 0x1
	// Position of PIN7 field.
	GPIO_DIRCLR_PIN7_Pos = 0x7
	// Bit mask of PIN7 field.
	GPIO_DIRCLR_PIN7_Msk = 0x80
	// Bit PIN7.
	GPIO_DIRCLR_PIN7 = 0x80
	// Pin set as input.
	GPIO_DIRCLR_PIN7_Input = 0x0
	// Pin set as output.
	GPIO_DIRCLR_PIN7_Output = 0x1
	// Set pin as input.
	GPIO_DIRCLR_PIN7_Clear = 0x1
	// Position of PIN8 field.
	GPIO_DIRCLR_PIN8_Pos = 0x8
	// Bit mask of PIN8 field.
	GPIO_DIRCLR_PIN8_Msk = 0x100
	// Bit PIN8.
	GPIO_DIRCLR_PIN8 = 0x100
	// Pin set as input.
	GPIO_DIRCLR_PIN8_Input = 0x0
	// Pin set as output.
	GPIO_DIRCLR_PIN8_Output = 0x1
	// Set pin as input.
	GPIO_DIRCLR_PIN8_Clear = 0x1
	// Position of PIN9 field.
	GPIO_DIRCLR_PIN9_Pos = 0x9
	// Bit mask of PIN9 field.
	GPIO_DIRCLR_PIN9_Msk = 0x200
	// Bit PIN9.
	GPIO_DIRCLR_PIN9 = 0x200
	// Pin set as input.
	GPIO_DIRCLR_PIN9_Input = 0x0
	// Pin set as output.
	GPIO_DIRCLR_PIN9_Output = 0x1
	// Set pin as input.
	GPIO_DIRCLR_PIN9_Clear = 0x1
	// Position of PIN10 field.
	GPIO_DIRCLR_PIN10_Pos = 0xa
	// Bit mask of PIN10 field.
	GPIO_DIRCLR_PIN10_Msk = 0x400
	// Bit PIN10.
	GPIO_DIRCLR_PIN10 = 0x400
	// Pin set as input.
	GPIO_DIRCLR_PIN10_Input = 0x0
	// Pin set as output.
	GPIO_DIRCLR_PIN10_Output = 0x1
	// Set pin as input.
	GPIO_DIRCLR_PIN10_Clear = 0x1
	// Position of PIN11 field.
	GPIO_DIRCLR_PIN11_Pos = 0xb
	// Bit mask of PIN11 field.
	GPIO_DIRCLR_PIN11_Msk = 0x800
	// Bit PIN11.
	GPIO_DIRCLR_PIN11 = 0x800
	// Pin set as input.
	GPIO_DIRCLR_PIN11_Input = 0x0
	// Pin set as output.
	GPIO_DIRCLR_PIN11_Output = 0x1
	// Set pin as input.
	GPIO_DIRCLR_PIN11_Clear = 0x1
	// Position of PIN12 field.
	GPIO_DIRCLR_PIN12_Pos = 0xc
	// Bit mask of PIN12 field.
	GPIO_DIRCLR_PIN12_Msk = 0x1000
	// Bit PIN12.
	GPIO_DIRCLR_PIN12 = 0x1000
	// Pin set as input.
	GPIO_DIRCLR_PIN12_Input = 0x0
	// Pin set as output.
	GPIO_DIRCLR_PIN12_Output = 0x1
	// Set pin as input.
	GPIO_DIRCLR_PIN12_Clear = 0x1
	// Position of PIN13 field.
	GPIO_DIRCLR_PIN13_Pos = 0xd
	// Bit mask of PIN13 field.
	GPIO_DIRCLR_PIN13_Msk = 0x2000
	// Bit PIN13.
	GPIO_DIRCLR_PIN13 = 0x2000
	// Pin set as input.
	GPIO_DIRCLR_PIN13_Input = 0x0
	// Pin set as output.
	GPIO_DIRCLR_PIN13_Output = 0x1
	// Set pin as input.
	GPIO_DIRCLR_PIN13_Clear = 0x1
	// Position of PIN14 field.
	GPIO_DIRCLR_PIN14_Pos = 0xe
	// Bit mask of PIN14 field.
	GPIO_DIRCLR_PIN14_Msk = 0x4000
	// Bit PIN14.
	GPIO_DIRCLR_PIN14 = 0x4000
	// Pin set as input.
	GPIO_DIRCLR_PIN14_Input = 0x0
	// Pin set as output.
	GPIO_DIRCLR_PIN14_Output = 0x1
	// Set pin as input.
	GPIO_DIRCLR_PIN14_Clear = 0x1
	// Position of PIN15 field.
	GPIO_DIRCLR_PIN15_Pos = 0xf
	// Bit mask of PIN15 field.
	GPIO_DIRCLR_PIN15_Msk = 0x8000
	// Bit PIN15.
	GPIO_DIRCLR_PIN15 = 0x8000
	// Pin set as input.
	GPIO_DIRCLR_PIN15_Input = 0x0
	// Pin set as output.
	GPIO_DIRCLR_PIN15_Output = 0x1
	// Set pin as input.
	GPIO_DIRCLR_PIN15_Clear = 0x1
	// Position of PIN16 field.
	GPIO_DIRCLR_PIN16_Pos = 0x10
	// Bit mask of PIN16 field.
	GPIO_DIRCLR_PIN16_Msk = 0x10000
	// Bit PIN16.
	GPIO_DIRCLR_PIN16 = 0x10000
	// Pin set as input.
	GPIO_DIRCLR_PIN16_Input = 0x0
	// Pin set as output.
	GPIO_DIRCLR_PIN16_Output = 0x1
	// Set pin as input.
	GPIO_DIRCLR_PIN16_Clear = 0x1
	// Position of PIN17 field.
	GPIO_DIRCLR_PIN17_Pos = 0x11
	// Bit mask of PIN17 field.
	GPIO_DIRCLR_PIN17_Msk = 0x20000
	// Bit PIN17.
	GPIO_DIRCLR_PIN17 = 0x20000
	// Pin set as input.
	GPIO_DIRCLR_PIN17_Input = 0x0
	// Pin set as output.
	GPIO_DIRCLR_PIN17_Output = 0x1
	// Set pin as input.
	GPIO_DIRCLR_PIN17_Clear = 0x1
	// Position of PIN18 field.
	GPIO_DIRCLR_PIN18_Pos = 0x12
	// Bit mask of PIN18 field.
	GPIO_DIRCLR_PIN18_Msk = 0x40000
	// Bit PIN18.
	GPIO_DIRCLR_PIN18 = 0x40000
	// Pin set as input.
	GPIO_DIRCLR_PIN18_Input = 0x0
	// Pin set as output.
	GPIO_DIRCLR_PIN18_Output = 0x1
	// Set pin as input.
	GPIO_DIRCLR_PIN18_Clear = 0x1
	// Position of PIN19 field.
	GPIO_DIRCLR_PIN19_Pos = 0x13
	// Bit mask of PIN19 field.
	GPIO_DIRCLR_PIN19_Msk = 0x80000
	// Bit PIN19.
	GPIO_DIRCLR_PIN19 = 0x80000
	// Pin set as input.
	GPIO_DIRCLR_PIN19_Input = 0x0
	// Pin set as output.
	GPIO_DIRCLR_PIN19_Output = 0x1
	// Set pin as input.
	GPIO_DIRCLR_PIN19_Clear = 0x1
	// Position of PIN20 field.
	GPIO_DIRCLR_PIN20_Pos = 0x14
	// Bit mask of PIN20 field.
	GPIO_DIRCLR_PIN20_Msk = 0x100000
	// Bit PIN20.
	GPIO_DIRCLR_PIN20 = 0x100000
	// Pin set as input.
	GPIO_DIRCLR_PIN20_Input = 0x0
	// Pin set as output.
	GPIO_DIRCLR_PIN20_Output = 0x1
	// Set pin as input.
	GPIO_DIRCLR_PIN20_Clear = 0x1
	// Position of PIN21 field.
	GPIO_DIRCLR_PIN21_Pos = 0x15
	// Bit mask of PIN21 field.
	GPIO_DIRCLR_PIN21_Msk = 0x200000
	// Bit PIN21.
	GPIO_DIRCLR_PIN21 = 0x200000
	// Pin set as input.
	GPIO_DIRCLR_PIN21_Input = 0x0
	// Pin set as output.
	GPIO_DIRCLR_PIN21_Output = 0x1
	// Set pin as input.
	GPIO_DIRCLR_PIN21_Clear = 0x1
	// Position of PIN22 field.
	GPIO_DIRCLR_PIN22_Pos = 0x16
	// Bit mask of PIN22 field.
	GPIO_DIRCLR_PIN22_Msk = 0x400000
	// Bit PIN22.
	GPIO_DIRCLR_PIN22 = 0x400000
	// Pin set as input.
	GPIO_DIRCLR_PIN22_Input = 0x0
	// Pin set as output.
	GPIO_DIRCLR_PIN22_Output = 0x1
	// Set pin as input.
	GPIO_DIRCLR_PIN22_Clear = 0x1
	// Position of PIN23 field.
	GPIO_DIRCLR_PIN23_Pos = 0x17
	// Bit mask of PIN23 field.
	GPIO_DIRCLR_PIN23_Msk = 0x800000
	// Bit PIN23.
	GPIO_DIRCLR_PIN23 = 0x800000
	// Pin set as input.
	GPIO_DIRCLR_PIN23_Input = 0x0
	// Pin set as output.
	GPIO_DIRCLR_PIN23_Output = 0x1
	// Set pin as input.
	GPIO_DIRCLR_PIN23_Clear = 0x1
	// Position of PIN24 field.
	GPIO_DIRCLR_PIN24_Pos = 0x18
	// Bit mask of PIN24 field.
	GPIO_DIRCLR_PIN24_Msk = 0x1000000
	// Bit PIN24.
	GPIO_DIRCLR_PIN24 = 0x1000000
	// Pin set as input.
	GPIO_DIRCLR_PIN24_Input = 0x0
	// Pin set as output.
	GPIO_DIRCLR_PIN24_Output = 0x1
	// Set pin as input.
	GPIO_DIRCLR_PIN24_Clear = 0x1
	// Position of PIN25 field.
	GPIO_DIRCLR_PIN25_Pos = 0x19
	// Bit mask of PIN25 field.
	GPIO_DIRCLR_PIN25_Msk = 0x2000000
	// Bit PIN25.
	GPIO_DIRCLR_PIN25 = 0x2000000
	// Pin set as input.
	GPIO_DIRCLR_PIN25_Input = 0x0
	// Pin set as output.
	GPIO_DIRCLR_PIN25_Output = 0x1
	// Set pin as input.
	GPIO_DIRCLR_PIN25_Clear = 0x1
	// Position of PIN26 field.
	GPIO_DIRCLR_PIN26_Pos = 0x1a
	// Bit mask of PIN26 field.
	GPIO_DIRCLR_PIN26_Msk = 0x4000000
	// Bit PIN26.
	GPIO_DIRCLR_PIN26 = 0x4000000
	// Pin set as input.
	GPIO_DIRCLR_PIN26_Input = 0x0
	// Pin set as output.
	GPIO_DIRCLR_PIN26_Output = 0x1
	// Set pin as input.
	GPIO_DIRCLR_PIN26_Clear = 0x1
	// Position of PIN27 field.
	GPIO_DIRCLR_PIN27_Pos = 0x1b
	// Bit mask of PIN27 field.
	GPIO_DIRCLR_PIN27_Msk = 0x8000000
	// Bit PIN27.
	GPIO_DIRCLR_PIN27 = 0x8000000
	// Pin set as input.
	GPIO_DIRCLR_PIN27_Input = 0x0
	// Pin set as output.
	GPIO_DIRCLR_PIN27_Output = 0x1
	// Set pin as input.
	GPIO_DIRCLR_PIN27_Clear = 0x1
	// Position of PIN28 field.
	GPIO_DIRCLR_PIN28_Pos = 0x1c
	// Bit mask of PIN28 field.
	GPIO_DIRCLR_PIN28_Msk = 0x10000000
	// Bit PIN28.
	GPIO_DIRCLR_PIN28 = 0x10000000
	// Pin set as input.
	GPIO_DIRCLR_PIN28_Input = 0x0
	// Pin set as output.
	GPIO_DIRCLR_PIN28_Output = 0x1
	// Set pin as input.
	GPIO_DIRCLR_PIN28_Clear = 0x1
	// Position of PIN29 field.
	GPIO_DIRCLR_PIN29_Pos = 0x1d
	// Bit mask of PIN29 field.
	GPIO_DIRCLR_PIN29_Msk = 0x20000000
	// Bit PIN29.
	GPIO_DIRCLR_PIN29 = 0x20000000
	// Pin set as input.
	GPIO_DIRCLR_PIN29_Input = 0x0
	// Pin set as output.
	GPIO_DIRCLR_PIN29_Output = 0x1
	// Set pin as input.
	GPIO_DIRCLR_PIN29_Clear = 0x1
	// Position of PIN30 field.
	GPIO_DIRCLR_PIN30_Pos = 0x1e
	// Bit mask of PIN30 field.
	GPIO_DIRCLR_PIN30_Msk = 0x40000000
	// Bit PIN30.
	GPIO_DIRCLR_PIN30 = 0x40000000
	// Pin set as input.
	GPIO_DIRCLR_PIN30_Input = 0x0
	// Pin set as output.
	GPIO_DIRCLR_PIN30_Output = 0x1
	// Set pin as input.
	GPIO_DIRCLR_PIN30_Clear = 0x1
	// Position of PIN31 field.
	GPIO_DIRCLR_PIN31_Pos = 0x1f
	// Bit mask of PIN31 field.
	GPIO_DIRCLR_PIN31_Msk = 0x80000000
	// Bit PIN31.
	GPIO_DIRCLR_PIN31 = 0x80000000
	// Pin set as input.
	GPIO_DIRCLR_PIN31_Input = 0x0
	// Pin set as output.
	GPIO_DIRCLR_PIN31_Output = 0x1
	// Set pin as input.
	GPIO_DIRCLR_PIN31_Clear = 0x1

	// PIN_CNF: Configuration of GPIO pins.
	// Position of DIR field.
	GPIO_PIN_CNF_DIR_Pos = 0x0
	// Bit mask of DIR field.
	GPIO_PIN_CNF_DIR_Msk = 0x1
	// Bit DIR.
	GPIO_PIN_CNF_DIR = 0x1
	// Configure pin as an input pin.
	GPIO_PIN_CNF_DIR_Input = 0x0
	// Configure pin as an output pin.
	GPIO_PIN_CNF_DIR_Output = 0x1
	// Position of INPUT field.
	GPIO_PIN_CNF_INPUT_Pos = 0x1
	// Bit mask of INPUT field.
	GPIO_PIN_CNF_INPUT_Msk = 0x2
	// Bit INPUT.
	GPIO_PIN_CNF_INPUT = 0x2
	// Connect input pin.
	GPIO_PIN_CNF_INPUT_Connect = 0x0
	// Disconnect input pin.
	GPIO_PIN_CNF_INPUT_Disconnect = 0x1
	// Position of PULL field.
	GPIO_PIN_CNF_PULL_Pos = 0x2
	// Bit mask of PULL field.
	GPIO_PIN_CNF_PULL_Msk = 0xc
	// No pull.
	GPIO_PIN_CNF_PULL_Disabled = 0x0
	// Pulldown on pin.
	GPIO_PIN_CNF_PULL_Pulldown = 0x1
	// Pullup on pin.
	GPIO_PIN_CNF_PULL_Pullup = 0x3
	// Position of DRIVE field.
	GPIO_PIN_CNF_DRIVE_Pos = 0x8
	// Bit mask of DRIVE field.
	GPIO_PIN_CNF_DRIVE_Msk = 0x700
	// Standard '0', Standard '1'.
	GPIO_PIN_CNF_DRIVE_S0S1 = 0x0
	// High '0', Standard '1'.
	GPIO_PIN_CNF_DRIVE_H0S1 = 0x1
	// Standard '0', High '1'.
	GPIO_PIN_CNF_DRIVE_S0H1 = 0x2
	// High '0', High '1'.
	GPIO_PIN_CNF_DRIVE_H0H1 = 0x3
	// Disconnected '0', Standard '1'.
	GPIO_PIN_CNF_DRIVE_D0S1 = 0x4
	// Disconnected '0', High '1'.
	GPIO_PIN_CNF_DRIVE_D0H1 = 0x5
	// Standard '0', Disconnected '1'.
	GPIO_PIN_CNF_DRIVE_S0D1 = 0x6
	// High '0', Disconnected '1'.
	GPIO_PIN_CNF_DRIVE_H0D1 = 0x7
	// Position of SENSE field.
	GPIO_PIN_CNF_SENSE_Pos = 0x10
	// Bit mask of SENSE field.
	GPIO_PIN_CNF_SENSE_Msk = 0x30000
	// Disabled.
	GPIO_PIN_CNF_SENSE_Disabled = 0x0
	// Wakeup on high level.
	GPIO_PIN_CNF_SENSE_High = 0x2
	// Wakeup on low level.
	GPIO_PIN_CNF_SENSE_Low = 0x3
)
