// Automatically generated file. DO NOT EDIT.
// Generated by gen-device-svd.go from LPC5410x_v0.4.svd, see https://github.com/posborne/cmsis-svd/tree/master/data/NXP

//go:build nxp && lpc5410x
// +build nxp,lpc5410x

// LPC5410x Cortex-M4 MCU; Cortex-M0+ coprocessor
//

package nxp

import (
	"runtime/volatile"
	"unsafe"
)

// Some information about this device.
const (
	Device       = "LPC5410x"
	CPU          = "CM4"
	FPUPresent   = true
	NVICPrioBits = 3
)

// Interrupt numbers.
const (
	// Windowed Watchdog Timer
	IRQ_WDT = 0

	// Advanced System configuration
	IRQ_BOD = 1

	// DMA controller
	IRQ_DMA = 3

	// Group GPIO input interrupt 0
	IRQ_GINT0 = 4

	// Pin interrupt and pattern match engine
	IRQ_PIN_INT0 = 5

	// Pin interrupt and pattern match engine
	IRQ_PIN_INT1 = 6

	// Pin interrupt and pattern match engine
	IRQ_PIN_INT2 = 7

	// Pin interrupt and pattern match engine
	IRQ_PIN_INT3 = 8

	// Micro-tick timer
	IRQ_UTICK = 9

	// Multi-Rate Timer
	IRQ_MRT = 10

	// Standard counter/timer 0
	IRQ_CT32B0 = 11

	// Standard counter/timer 1
	IRQ_CT32B1 = 12

	// Standard counter/timer 2
	IRQ_CT32B2 = 13

	// Standard counter/timer 3
	IRQ_CT32B3 = 14

	// Standard counter/timer 4
	IRQ_CT32B4 = 15

	// State Configurable Timer/PWM 0
	IRQ_SCT0 = 16

	// USART0
	IRQ_UART0 = 17

	// USART1
	IRQ_UART1 = 18

	// USART2
	IRQ_UART2 = 19

	// USART3
	IRQ_UART3 = 20

	// I2C-bus interface 0
	IRQ_I2C0 = 21

	// I2C-bus interface 1
	IRQ_I2C1 = 22

	// I2C-bus interface 2
	IRQ_I2C2 = 23

	// SPI0
	IRQ_SPI0 = 24

	// SPI1
	IRQ_SPI1 = 25

	// 12-bit ADC controller 0
	IRQ_ADC_SEQA = 26

	// 12-bit ADC controller 0
	IRQ_ADC_SEQB = 27

	// 12-bit ADC controller 0
	IRQ_ADC_THCMP = 28

	// Real-Time Clock
	IRQ_RTC = 29

	// Mailbox
	IRQ_MAILBOX = 31

	// Group GPIO input interrupt 1
	IRQ_GINT1 = 32

	// Pin interrupt and pattern match engine
	IRQ_PIN_INT4 = 33

	// Pin interrupt and pattern match engine
	IRQ_PIN_INT5 = 34

	// Pin interrupt and pattern match engine
	IRQ_PIN_INT6 = 35

	// Pin interrupt and pattern match engine
	IRQ_PIN_INT7 = 36

	// Repetitive Interrupt Timer
	IRQ_RIT = 40

	// Highest interrupt number on this device.
	IRQ_max = 40
)

// Pseudo function call that is replaced by the compiler with the actual
// functions registered through interrupt.New.
//go:linkname callHandlers runtime/interrupt.callHandlers
func callHandlers(num int)

//export WDT_IRQHandler
func interruptWDT() {
	callHandlers(IRQ_WDT)
}

//export BOD_IRQHandler
func interruptBOD() {
	callHandlers(IRQ_BOD)
}

//export DMA_IRQHandler
func interruptDMA() {
	callHandlers(IRQ_DMA)
}

//export GINT0_IRQHandler
func interruptGINT0() {
	callHandlers(IRQ_GINT0)
}

//export PIN_INT0_IRQHandler
func interruptPIN_INT0() {
	callHandlers(IRQ_PIN_INT0)
}

//export PIN_INT1_IRQHandler
func interruptPIN_INT1() {
	callHandlers(IRQ_PIN_INT1)
}

//export PIN_INT2_IRQHandler
func interruptPIN_INT2() {
	callHandlers(IRQ_PIN_INT2)
}

//export PIN_INT3_IRQHandler
func interruptPIN_INT3() {
	callHandlers(IRQ_PIN_INT3)
}

//export UTICK_IRQHandler
func interruptUTICK() {
	callHandlers(IRQ_UTICK)
}

//export MRT_IRQHandler
func interruptMRT() {
	callHandlers(IRQ_MRT)
}

//export CT32B0_IRQHandler
func interruptCT32B0() {
	callHandlers(IRQ_CT32B0)
}

//export CT32B1_IRQHandler
func interruptCT32B1() {
	callHandlers(IRQ_CT32B1)
}

//export CT32B2_IRQHandler
func interruptCT32B2() {
	callHandlers(IRQ_CT32B2)
}

//export CT32B3_IRQHandler
func interruptCT32B3() {
	callHandlers(IRQ_CT32B3)
}

//export CT32B4_IRQHandler
func interruptCT32B4() {
	callHandlers(IRQ_CT32B4)
}

//export SCT0_IRQHandler
func interruptSCT0() {
	callHandlers(IRQ_SCT0)
}

//export UART0_IRQHandler
func interruptUART0() {
	callHandlers(IRQ_UART0)
}

//export UART1_IRQHandler
func interruptUART1() {
	callHandlers(IRQ_UART1)
}

//export UART2_IRQHandler
func interruptUART2() {
	callHandlers(IRQ_UART2)
}

//export UART3_IRQHandler
func interruptUART3() {
	callHandlers(IRQ_UART3)
}

//export I2C0_IRQHandler
func interruptI2C0() {
	callHandlers(IRQ_I2C0)
}

//export I2C1_IRQHandler
func interruptI2C1() {
	callHandlers(IRQ_I2C1)
}

//export I2C2_IRQHandler
func interruptI2C2() {
	callHandlers(IRQ_I2C2)
}

//export SPI0_IRQHandler
func interruptSPI0() {
	callHandlers(IRQ_SPI0)
}

//export SPI1_IRQHandler
func interruptSPI1() {
	callHandlers(IRQ_SPI1)
}

//export ADC_SEQA_IRQHandler
func interruptADC_SEQA() {
	callHandlers(IRQ_ADC_SEQA)
}

//export ADC_SEQB_IRQHandler
func interruptADC_SEQB() {
	callHandlers(IRQ_ADC_SEQB)
}

//export ADC_THCMP_IRQHandler
func interruptADC_THCMP() {
	callHandlers(IRQ_ADC_THCMP)
}

//export RTC_IRQHandler
func interruptRTC() {
	callHandlers(IRQ_RTC)
}

//export MAILBOX_IRQHandler
func interruptMAILBOX() {
	callHandlers(IRQ_MAILBOX)
}

//export GINT1_IRQHandler
func interruptGINT1() {
	callHandlers(IRQ_GINT1)
}

//export PIN_INT4_IRQHandler
func interruptPIN_INT4() {
	callHandlers(IRQ_PIN_INT4)
}

//export PIN_INT5_IRQHandler
func interruptPIN_INT5() {
	callHandlers(IRQ_PIN_INT5)
}

//export PIN_INT6_IRQHandler
func interruptPIN_INT6() {
	callHandlers(IRQ_PIN_INT6)
}

//export PIN_INT7_IRQHandler
func interruptPIN_INT7() {
	callHandlers(IRQ_PIN_INT7)
}

//export RIT_IRQHandler
func interruptRIT() {
	callHandlers(IRQ_RIT)
}

// Peripherals.
var (
	// General Purpose I/O
	GPIO = (*GPIO_Type)(unsafe.Pointer(uintptr(0x1c000000)))

	// DMA controller
	DMA = (*DMA_Type)(unsafe.Pointer(uintptr(0x1c004000)))

	// CRC engine
	CRC = (*CRC_Type)(unsafe.Pointer(uintptr(0x1c010000)))

	// State Configurable Timer/PWM 0
	SCT0 = (*SCT0_Type)(unsafe.Pointer(uintptr(0x1c018000)))

	// Mailbox
	MAILBOX = (*MAILBOX_Type)(unsafe.Pointer(uintptr(0x1c02c000)))

	// 12-bit ADC controller 0
	ADC0 = (*ADC0_Type)(unsafe.Pointer(uintptr(0x1c034000)))

	// System FIFO for Serial Peripherals
	VFIFO = (*VFIFO_Type)(unsafe.Pointer(uintptr(0x1c038000)))

	// System configuration
	SYSCON = (*SYSCON_Type)(unsafe.Pointer(uintptr(0x40000000)))

	// Standard counter/timer 2
	CT32B2 = (*CT32B2_Type)(unsafe.Pointer(uintptr(0x40004000)))

	// Standard counter/timer 3
	CT32B3 = (*CT32B2_Type)(unsafe.Pointer(uintptr(0x40008000)))

	// Standard counter/timer 4
	CT32B4 = (*CT32B2_Type)(unsafe.Pointer(uintptr(0x4000c000)))

	// Group GPIO input interrupt 0
	GINT0 = (*GINT0_Type)(unsafe.Pointer(uintptr(0x40010000)))

	// Group GPIO input interrupt 1
	GINT1 = (*GINT0_Type)(unsafe.Pointer(uintptr(0x40014000)))

	// Pin interrupt and pattern match engine
	PINT = (*PINT_Type)(unsafe.Pointer(uintptr(0x40018000)))

	// I/O pin configuration
	IOCON = (*IOCON_Type)(unsafe.Pointer(uintptr(0x4001c000)))

	// Micro-tick timer
	UTICK = (*UTICK_Type)(unsafe.Pointer(uintptr(0x40020000)))

	// Advanced System configuration
	ADVSYSCON = (*ADVSYSCON_Type)(unsafe.Pointer(uintptr(0x4002c000)))

	// Windowed Watchdog Timer
	WWDT = (*WWDT_Type)(unsafe.Pointer(uintptr(0x40038000)))

	// Real-Time Clock
	RTC = (*RTC_Type)(unsafe.Pointer(uintptr(0x4003c000)))

	// Input multiplexing
	INPUTMUX = (*INPUTMUX_Type)(unsafe.Pointer(uintptr(0x40050000)))

	// Repetitive Interrupt Timer
	RIT = (*RIT_Type)(unsafe.Pointer(uintptr(0x40070000)))

	// Multi-Rate Timer
	MRT = (*MRT_Type)(unsafe.Pointer(uintptr(0x40074000)))

	// Asynchronous system configuration
	ASYNCSYSCON = (*ASYNCSYSCON_Type)(unsafe.Pointer(uintptr(0x40080000)))

	// USART0
	USART0 = (*USART0_Type)(unsafe.Pointer(uintptr(0x40084000)))

	// USART1
	USART1 = (*USART0_Type)(unsafe.Pointer(uintptr(0x40088000)))

	// USART2
	USART2 = (*USART0_Type)(unsafe.Pointer(uintptr(0x4008c000)))

	// USART3
	USART3 = (*USART0_Type)(unsafe.Pointer(uintptr(0x40090000)))

	// I2C-bus interface 0
	I2C0 = (*I2C0_Type)(unsafe.Pointer(uintptr(0x40094000)))

	// I2C-bus interface 1
	I2C1 = (*I2C0_Type)(unsafe.Pointer(uintptr(0x40098000)))

	// I2C-bus interface 2
	I2C2 = (*I2C0_Type)(unsafe.Pointer(uintptr(0x4009c000)))

	// SPI0
	SPI0 = (*SPI0_Type)(unsafe.Pointer(uintptr(0x400a4000)))

	// SPI1
	SPI1 = (*SPI0_Type)(unsafe.Pointer(uintptr(0x400a8000)))

	// Standard counter/timer 0
	CT32B0 = (*CT32B2_Type)(unsafe.Pointer(uintptr(0x400b4000)))

	// Standard counter/timer 1
	CT32B1 = (*CT32B2_Type)(unsafe.Pointer(uintptr(0x400b8000)))
)

// General Purpose I/O
type GPIO_Type struct {
	B0    volatile.Register32 // 0x0
	_     byte
	B1    volatile.Register32 // 0x1
	_     byte
	B2    volatile.Register32 // 0x2
	_     byte
	B3    volatile.Register32 // 0x3
	_     byte
	B4    volatile.Register32 // 0x4
	_     byte
	B5    volatile.Register32 // 0x5
	_     byte
	B6    volatile.Register32 // 0x6
	_     byte
	B7    volatile.Register32 // 0x7
	_     byte
	B8    volatile.Register32 // 0x8
	_     byte
	B9    volatile.Register32 // 0x9
	_     byte
	B10   volatile.Register32 // 0xA
	_     byte
	B11   volatile.Register32 // 0xB
	_     byte
	B12   volatile.Register32 // 0xC
	_     byte
	B13   volatile.Register32 // 0xD
	_     byte
	B14   volatile.Register32 // 0xE
	_     byte
	B15   volatile.Register32 // 0xF
	_     byte
	B16   volatile.Register32 // 0x10
	_     byte
	B17   volatile.Register32 // 0x11
	_     byte
	B18   volatile.Register32 // 0x12
	_     byte
	B19   volatile.Register32 // 0x13
	_     byte
	B20   volatile.Register32 // 0x14
	_     byte
	B21   volatile.Register32 // 0x15
	_     byte
	B22   volatile.Register32 // 0x16
	_     byte
	B23   volatile.Register32 // 0x17
	_     byte
	B24   volatile.Register32 // 0x18
	_     byte
	B25   volatile.Register32 // 0x19
	_     byte
	B26   volatile.Register32 // 0x1A
	_     byte
	B27   volatile.Register32 // 0x1B
	_     byte
	B28   volatile.Register32 // 0x1C
	_     byte
	B29   volatile.Register32 // 0x1D
	_     byte
	B30   volatile.Register32 // 0x1E
	_     byte
	B31   volatile.Register32 // 0x1F
	_     byte
	B32   volatile.Register32 // 0x20
	_     byte
	B33   volatile.Register32 // 0x21
	_     byte
	B34   volatile.Register32 // 0x22
	_     byte
	B35   volatile.Register32 // 0x23
	_     byte
	B36   volatile.Register32 // 0x24
	_     byte
	B37   volatile.Register32 // 0x25
	_     byte
	B38   volatile.Register32 // 0x26
	_     byte
	B39   volatile.Register32 // 0x27
	_     byte
	B40   volatile.Register32 // 0x28
	_     byte
	B41   volatile.Register32 // 0x29
	_     byte
	B42   volatile.Register32 // 0x2A
	_     byte
	B43   volatile.Register32 // 0x2B
	_     byte
	B44   volatile.Register32 // 0x2C
	_     byte
	B45   volatile.Register32 // 0x2D
	_     byte
	B46   volatile.Register32 // 0x2E
	_     byte
	B47   volatile.Register32 // 0x2F
	_     byte
	B48   volatile.Register32 // 0x30
	_     byte
	B49   volatile.Register32 // 0x31
	_     [4047]byte
	W0    volatile.Register32 // 0x1000
	W1    volatile.Register32 // 0x1004
	W2    volatile.Register32 // 0x1008
	W3    volatile.Register32 // 0x100C
	W4    volatile.Register32 // 0x1010
	W5    volatile.Register32 // 0x1014
	W6    volatile.Register32 // 0x1018
	W7    volatile.Register32 // 0x101C
	W8    volatile.Register32 // 0x1020
	W9    volatile.Register32 // 0x1024
	W10   volatile.Register32 // 0x1028
	W11   volatile.Register32 // 0x102C
	W12   volatile.Register32 // 0x1030
	W13   volatile.Register32 // 0x1034
	W14   volatile.Register32 // 0x1038
	W15   volatile.Register32 // 0x103C
	W16   volatile.Register32 // 0x1040
	W17   volatile.Register32 // 0x1044
	W18   volatile.Register32 // 0x1048
	W19   volatile.Register32 // 0x104C
	W20   volatile.Register32 // 0x1050
	W21   volatile.Register32 // 0x1054
	W22   volatile.Register32 // 0x1058
	W23   volatile.Register32 // 0x105C
	W24   volatile.Register32 // 0x1060
	W25   volatile.Register32 // 0x1064
	W26   volatile.Register32 // 0x1068
	W27   volatile.Register32 // 0x106C
	W28   volatile.Register32 // 0x1070
	W29   volatile.Register32 // 0x1074
	W30   volatile.Register32 // 0x1078
	W31   volatile.Register32 // 0x107C
	W32   volatile.Register32 // 0x1080
	W33   volatile.Register32 // 0x1084
	W34   volatile.Register32 // 0x1088
	W35   volatile.Register32 // 0x108C
	W36   volatile.Register32 // 0x1090
	W37   volatile.Register32 // 0x1094
	W38   volatile.Register32 // 0x1098
	W39   volatile.Register32 // 0x109C
	W40   volatile.Register32 // 0x10A0
	W41   volatile.Register32 // 0x10A4
	W42   volatile.Register32 // 0x10A8
	W43   volatile.Register32 // 0x10AC
	W44   volatile.Register32 // 0x10B0
	W45   volatile.Register32 // 0x10B4
	W46   volatile.Register32 // 0x10B8
	W47   volatile.Register32 // 0x10BC
	W48   volatile.Register32 // 0x10C0
	W49   volatile.Register32 // 0x10C4
	_     [3896]byte
	DIR0  volatile.Register32 // 0x2000
	DIR1  volatile.Register32 // 0x2004
	_     [120]byte
	MASK0 volatile.Register32 // 0x2080
	MASK1 volatile.Register32 // 0x2084
	_     [120]byte
	PIN0  volatile.Register32 // 0x2100
	PIN1  volatile.Register32 // 0x2104
	_     [120]byte
	MPIN0 volatile.Register32 // 0x2180
	MPIN1 volatile.Register32 // 0x2184
	_     [120]byte
	SET0  volatile.Register32 // 0x2200
	SET1  volatile.Register32 // 0x2204
	_     [120]byte
	CLR0  volatile.Register32 // 0x2280
	CLR1  volatile.Register32 // 0x2284
	_     [120]byte
	NOT0  volatile.Register32 // 0x2300
	NOT1  volatile.Register32 // 0x2304
}

// DMA controller
type DMA_Type struct {
	CTRL       volatile.Register32 // 0x0
	INTSTAT    volatile.Register32 // 0x4
	SRAMBASE   volatile.Register32 // 0x8
	_          [20]byte
	ENABLESET0 volatile.Register32 // 0x20
	_          [4]byte
	ENABLECLR0 volatile.Register32 // 0x28
	_          [4]byte
	ACTIVE0    volatile.Register32 // 0x30
	_          [4]byte
	BUSY0      volatile.Register32 // 0x38
	_          [4]byte
	ERRINT0    volatile.Register32 // 0x40
	_          [4]byte
	INTENSET0  volatile.Register32 // 0x48
	_          [4]byte
	INTENCLR0  volatile.Register32 // 0x50
	_          [4]byte
	INTA0      volatile.Register32 // 0x58
	_          [4]byte
	INTB0      volatile.Register32 // 0x60
	_          [4]byte
	SETVALID0  volatile.Register32 // 0x68
	_          [4]byte
	SETTRIG0   volatile.Register32 // 0x70
	_          [4]byte
	ABORT0     volatile.Register32 // 0x78
	_          [900]byte
	CFG0       volatile.Register32 // 0x400
	CTLSTAT0   volatile.Register32 // 0x404
	XFERCFG0   volatile.Register32 // 0x408
	_          [4]byte
	CFG1       volatile.Register32 // 0x410
	CTLSTAT1   volatile.Register32 // 0x414
	XFERCFG1   volatile.Register32 // 0x418
	_          [4]byte
	CFG2       volatile.Register32 // 0x420
	CTLSTAT2   volatile.Register32 // 0x424
	XFERCFG2   volatile.Register32 // 0x428
	_          [4]byte
	CFG3       volatile.Register32 // 0x430
	CTLSTAT3   volatile.Register32 // 0x434
	XFERCFG3   volatile.Register32 // 0x438
	_          [4]byte
	CFG4       volatile.Register32 // 0x440
	CTLSTAT4   volatile.Register32 // 0x444
	XFERCFG4   volatile.Register32 // 0x448
	_          [4]byte
	CFG5       volatile.Register32 // 0x450
	CTLSTAT5   volatile.Register32 // 0x454
	XFERCFG5   volatile.Register32 // 0x458
	_          [4]byte
	CFG6       volatile.Register32 // 0x460
	CTLSTAT6   volatile.Register32 // 0x464
	XFERCFG6   volatile.Register32 // 0x468
	_          [4]byte
	CFG7       volatile.Register32 // 0x470
	CTLSTAT7   volatile.Register32 // 0x474
	XFERCFG7   volatile.Register32 // 0x478
	_          [4]byte
	CFG8       volatile.Register32 // 0x480
	CTLSTAT8   volatile.Register32 // 0x484
	XFERCFG8   volatile.Register32 // 0x488
	_          [4]byte
	CFG9       volatile.Register32 // 0x490
	CTLSTAT9   volatile.Register32 // 0x494
	XFERCFG9   volatile.Register32 // 0x498
	_          [4]byte
	CFG10      volatile.Register32 // 0x4A0
	CTLSTAT10  volatile.Register32 // 0x4A4
	XFERCFG10  volatile.Register32 // 0x4A8
	_          [4]byte
	CFG11      volatile.Register32 // 0x4B0
	CTLSTAT11  volatile.Register32 // 0x4B4
	XFERCFG11  volatile.Register32 // 0x4B8
	_          [4]byte
	CFG12      volatile.Register32 // 0x4C0
	CTLSTAT12  volatile.Register32 // 0x4C4
	XFERCFG12  volatile.Register32 // 0x4C8
	_          [4]byte
	CFG13      volatile.Register32 // 0x4D0
	CTLSTAT13  volatile.Register32 // 0x4D4
	XFERCFG13  volatile.Register32 // 0x4D8
	_          [4]byte
	CFG14      volatile.Register32 // 0x4E0
	CTLSTAT14  volatile.Register32 // 0x4E4
	XFERCFG14  volatile.Register32 // 0x4E8
	_          [4]byte
	CFG15      volatile.Register32 // 0x4F0
	CTLSTAT15  volatile.Register32 // 0x4F4
	XFERCFG15  volatile.Register32 // 0x4F8
	_          [4]byte
	CFG16      volatile.Register32 // 0x500
	CTLSTAT16  volatile.Register32 // 0x504
	XFERCFG16  volatile.Register32 // 0x508
	_          [4]byte
	CFG17      volatile.Register32 // 0x510
	CTLSTAT17  volatile.Register32 // 0x514
	XFERCFG17  volatile.Register32 // 0x518
	_          [4]byte
	CFG18      volatile.Register32 // 0x520
	CTLSTAT18  volatile.Register32 // 0x524
	XFERCFG18  volatile.Register32 // 0x528
	_          [4]byte
	CFG19      volatile.Register32 // 0x530
	CTLSTAT19  volatile.Register32 // 0x534
	XFERCFG19  volatile.Register32 // 0x538
	_          [4]byte
	CFG20      volatile.Register32 // 0x540
	CTLSTAT20  volatile.Register32 // 0x544
	XFERCFG20  volatile.Register32 // 0x548
	_          [4]byte
	CFG21      volatile.Register32 // 0x550
	CTLSTAT21  volatile.Register32 // 0x554
	XFERCFG21  volatile.Register32 // 0x558
}

// CRC engine
type CRC_Type struct {
	MODE volatile.Register32 // 0x0
	SEED volatile.Register32 // 0x4
	SUM  volatile.Register32 // 0x8
}

// State Configurable Timer/PWM 0
type SCT0_Type struct {
	CONFIG        volatile.Register32 // 0x0
	CTRL          volatile.Register32 // 0x4
	LIMIT         volatile.Register32 // 0x8
	HALT          volatile.Register32 // 0xC
	STOP          volatile.Register32 // 0x10
	START         volatile.Register32 // 0x14
	_             [40]byte
	COUNT         volatile.Register32 // 0x40
	STATE         volatile.Register32 // 0x44
	INPUT         volatile.Register32 // 0x48
	REGMODE       volatile.Register32 // 0x4C
	OUTPUT        volatile.Register32 // 0x50
	OUTPUTDIRCTRL volatile.Register32 // 0x54
	RES           volatile.Register32 // 0x58
	DMAREQ0       volatile.Register32 // 0x5C
	DMAREQ1       volatile.Register32 // 0x60
	_             [140]byte
	EVEN          volatile.Register32 // 0xF0
	EVFLAG        volatile.Register32 // 0xF4
	CONEN         volatile.Register32 // 0xF8
	CONFLAG       volatile.Register32 // 0xFC
	MATCH0        volatile.Register32 // 0x100
	MATCH1        volatile.Register32 // 0x104
	MATCH2        volatile.Register32 // 0x108
	MATCH3        volatile.Register32 // 0x10C
	MATCH4        volatile.Register32 // 0x110
	MATCH5        volatile.Register32 // 0x114
	MATCH6        volatile.Register32 // 0x118
	MATCH7        volatile.Register32 // 0x11C
	MATCH8        volatile.Register32 // 0x120
	MATCH9        volatile.Register32 // 0x124
	MATCH10       volatile.Register32 // 0x128
	MATCH11       volatile.Register32 // 0x12C
	MATCH12       volatile.Register32 // 0x130
	_             [204]byte
	MATCHREL0     volatile.Register32 // 0x200
	MATCHREL1     volatile.Register32 // 0x204
	MATCHREL2     volatile.Register32 // 0x208
	MATCHREL3     volatile.Register32 // 0x20C
	MATCHREL4     volatile.Register32 // 0x210
	MATCHREL5     volatile.Register32 // 0x214
	MATCHREL6     volatile.Register32 // 0x218
	MATCHREL7     volatile.Register32 // 0x21C
	MATCHREL8     volatile.Register32 // 0x220
	MATCHREL9     volatile.Register32 // 0x224
	MATCHREL10    volatile.Register32 // 0x228
	MATCHREL11    volatile.Register32 // 0x22C
	MATCHREL12    volatile.Register32 // 0x230
	_             [204]byte
	EV0_STATE     volatile.Register32 // 0x300
	EV0_CTRL      volatile.Register32 // 0x304
	EV1_STATE     volatile.Register32 // 0x308
	EV1_CTRL      volatile.Register32 // 0x30C
	EV2_STATE     volatile.Register32 // 0x310
	EV2_CTRL      volatile.Register32 // 0x314
	EV3_STATE     volatile.Register32 // 0x318
	EV3_CTRL      volatile.Register32 // 0x31C
	EV4_STATE     volatile.Register32 // 0x320
	EV4_CTRL      volatile.Register32 // 0x324
	EV5_STATE     volatile.Register32 // 0x328
	EV5_CTRL      volatile.Register32 // 0x32C
	EV6_STATE     volatile.Register32 // 0x330
	EV6_CTRL      volatile.Register32 // 0x334
	EV7_STATE     volatile.Register32 // 0x338
	EV7_CTRL      volatile.Register32 // 0x33C
	EV8_STATE     volatile.Register32 // 0x340
	EV8_CTRL      volatile.Register32 // 0x344
	EV9_STATE     volatile.Register32 // 0x348
	EV9_CTRL      volatile.Register32 // 0x34C
	EV10_STATE    volatile.Register32 // 0x350
	EV10_CTRL     volatile.Register32 // 0x354
	EV11_STATE    volatile.Register32 // 0x358
	EV11_CTRL     volatile.Register32 // 0x35C
	EV12_STATE    volatile.Register32 // 0x360
	EV12_CTRL     volatile.Register32 // 0x364
	_             [408]byte
	OUT0_SET      volatile.Register32 // 0x500
	OUT0_CLR      volatile.Register32 // 0x504
	OUT1_SET      volatile.Register32 // 0x508
	OUT1_CLR      volatile.Register32 // 0x50C
	OUT2_SET      volatile.Register32 // 0x510
	OUT2_CLR      volatile.Register32 // 0x514
	OUT3_SET      volatile.Register32 // 0x518
	OUT3_CLR      volatile.Register32 // 0x51C
	OUT4_SET      volatile.Register32 // 0x520
	OUT4_CLR      volatile.Register32 // 0x524
	OUT5_SET      volatile.Register32 // 0x528
	OUT5_CLR      volatile.Register32 // 0x52C
	OUT6_SET      volatile.Register32 // 0x530
	OUT6_CLR      volatile.Register32 // 0x534
	OUT7_SET      volatile.Register32 // 0x538
	OUT7_CLR      volatile.Register32 // 0x53C
}

// Mailbox
type MAILBOX_Type struct {
	IRQ0    volatile.Register32 // 0x0
	IRQ0SET volatile.Register32 // 0x4
	IRQ0CLR volatile.Register32 // 0x8
	_       [4]byte
	IRQ1    volatile.Register32 // 0x10
	IRQ1SET volatile.Register32 // 0x14
	IRQ1CLR volatile.Register32 // 0x18
	_       [220]byte
	MUTEX   volatile.Register32 // 0xF8
}

// 12-bit ADC controller 0
type ADC0_Type struct {
	CTRL        volatile.Register32 // 0x0
	_           [4]byte
	SEQA_CTRL   volatile.Register32 // 0x8
	SEQB_CTRL   volatile.Register32 // 0xC
	SEQA_GDAT   volatile.Register32 // 0x10
	SEQB_GDAT   volatile.Register32 // 0x14
	_           [8]byte
	DAT0        volatile.Register32 // 0x20
	DAT1        volatile.Register32 // 0x24
	DAT2        volatile.Register32 // 0x28
	DAT3        volatile.Register32 // 0x2C
	DAT4        volatile.Register32 // 0x30
	DAT5        volatile.Register32 // 0x34
	DAT6        volatile.Register32 // 0x38
	DAT7        volatile.Register32 // 0x3C
	DAT8        volatile.Register32 // 0x40
	DAT9        volatile.Register32 // 0x44
	DAT10       volatile.Register32 // 0x48
	DAT11       volatile.Register32 // 0x4C
	THR0_LOW    volatile.Register32 // 0x50
	THR1_LOW    volatile.Register32 // 0x54
	THR0_HIGH   volatile.Register32 // 0x58
	THR1_HIGH   volatile.Register32 // 0x5C
	CHAN_THRSEL volatile.Register32 // 0x60
	INTEN       volatile.Register32 // 0x64
	FLAGS       volatile.Register32 // 0x68
	STARTUP     volatile.Register32 // 0x6C
	CALIB       volatile.Register32 // 0x70
}

// System FIFO for Serial Peripherals
type VFIFO_Type struct {
	_               [256]byte
	FIFOCTLUSART    volatile.Register32 // 0x100
	FIFOUPDATEUSART volatile.Register32 // 0x104
	_               [8]byte
	FIFOCFGUSART0   volatile.Register32 // 0x110
	FIFOCFGUSART1   volatile.Register32 // 0x114
	FIFOCFGUSART2   volatile.Register32 // 0x118
	FIFOCFGUSART3   volatile.Register32 // 0x11C
	_               [224]byte
	FIFOCTLSPI      volatile.Register32 // 0x200
	FIFOUPDATESPI   volatile.Register32 // 0x204
	_               [8]byte
	FIFOCFGSPI0     volatile.Register32 // 0x210
	FIFOCFGSPI1     volatile.Register32 // 0x214
	_               [3560]byte
	CFGUSART0       volatile.Register32 // 0x1000
	STATUSART0      volatile.Register32 // 0x1004
	INTSTATUSART0   volatile.Register32 // 0x1008
	CTLSETUSART0    volatile.Register32 // 0x100C
	CTLCLRUSART0    volatile.Register32 // 0x1010
	RXDATUSART0     volatile.Register32 // 0x1014
	RXDATSTATUSART0 volatile.Register32 // 0x1018
	TXDATUSART0     volatile.Register32 // 0x101C
	_               [224]byte
	CFGUSART1       volatile.Register32 // 0x1100
	STATUSART1      volatile.Register32 // 0x1104
	INTSTATUSART1   volatile.Register32 // 0x1108
	CTLSETUSART1    volatile.Register32 // 0x110C
	CTLCLRUSART1    volatile.Register32 // 0x1110
	RXDATUSART1     volatile.Register32 // 0x1114
	RXDATSTATUSART1 volatile.Register32 // 0x1118
	TXDATUSART1     volatile.Register32 // 0x111C
	_               [224]byte
	CFGUSART2       volatile.Register32 // 0x1200
	STATUSART2      volatile.Register32 // 0x1204
	INTSTATUSART2   volatile.Register32 // 0x1208
	CTLSETUSART2    volatile.Register32 // 0x120C
	CTLCLRUSART2    volatile.Register32 // 0x1210
	RXDATUSART2     volatile.Register32 // 0x1214
	RXDATSTATUSART2 volatile.Register32 // 0x1218
	TXDATUSART2     volatile.Register32 // 0x121C
	_               [224]byte
	CFGUSART3       volatile.Register32 // 0x1300
	STATUSART3      volatile.Register32 // 0x1304
	INTSTATUSART3   volatile.Register32 // 0x1308
	CTLSETUSART3    volatile.Register32 // 0x130C
	CTLCLRUSART3    volatile.Register32 // 0x1310
	RXDATUSART3     volatile.Register32 // 0x1314
	RXDATSTATUSART3 volatile.Register32 // 0x1318
	TXDATUSART3     volatile.Register32 // 0x131C
	_               [3296]byte
	CFGSPI0         volatile.Register32 // 0x2000
	STATSPI0        volatile.Register32 // 0x2004
	INTSTATSPI0     volatile.Register32 // 0x2008
	CTLSETSPI0      volatile.Register32 // 0x200C
	CTLCLRSPI0      volatile.Register32 // 0x2010
	RXDATSPI0       volatile.Register32 // 0x2014
	TXDATSPI0       volatile.Register32 // 0x2018
	_               [228]byte
	CFGSPI1         volatile.Register32 // 0x2100
	STATSPI1        volatile.Register32 // 0x2104
	INTSTATSPI1     volatile.Register32 // 0x2108
	CTLSETSPI1      volatile.Register32 // 0x210C
	CTLCLRSPI1      volatile.Register32 // 0x2110
	RXDATSPI1       volatile.Register32 // 0x2114
	TXDATSPI1       volatile.Register32 // 0x2118
}

// System configuration
type SYSCON_Type struct {
	SYSMEMREMAP    volatile.Register32 // 0x0
	AHBMATPRIO     volatile.Register32 // 0x4
	_              [12]byte
	SYSTCKCAL      volatile.Register32 // 0x14
	_              [4]byte
	NMISRC         volatile.Register32 // 0x1C
	ASYNCAPBCTRL   volatile.Register32 // 0x20
	_              [28]byte
	SYSRSTSTAT     volatile.Register32 // 0x40
	PRESETCTRL0    volatile.Register32 // 0x44
	PRESETCTRL1    volatile.Register32 // 0x48
	PRESETCTRLSET0 volatile.Register32 // 0x4C
	PRESETCTRLSET1 volatile.Register32 // 0x50
	PRESETCTRLCLR0 volatile.Register32 // 0x54
	PRESETCTRLCLR1 volatile.Register32 // 0x58
	PIOPORCAP0     volatile.Register32 // 0x5C
	PIOPORCAP1     volatile.Register32 // 0x60
	_              [4]byte
	PIORESCAP0     volatile.Register32 // 0x68
	PIORESCAP1     volatile.Register32 // 0x6C
	_              [16]byte
	MAINCLKSELA    volatile.Register32 // 0x80
	MAINCLKSELB    volatile.Register32 // 0x84
	_              [4]byte
	ADCCLKSEL      volatile.Register32 // 0x8C
	_              [4]byte
	CLKOUTSELA     volatile.Register32 // 0x94
	CLKOUTSELB     volatile.Register32 // 0x98
	_              [4]byte
	SYSPLLCLKSEL   volatile.Register32 // 0xA0
	_              [28]byte
	AHBCLKCTRL0    volatile.Register32 // 0xC0
	AHBCLKCTRL1    volatile.Register32 // 0xC4
	AHBCLKCTRLSET0 volatile.Register32 // 0xC8
	AHBCLKCTRLSET1 volatile.Register32 // 0xCC
	AHBCLKCTRLCLR0 volatile.Register32 // 0xD0
	AHBCLKCTRLCLR1 volatile.Register32 // 0xD4
	_              [8]byte
	SYSTICKCLKDIV  volatile.Register32 // 0xE0
	_              [28]byte
	AHBCLKDIV      volatile.Register32 // 0x100
	_              [4]byte
	ADCCLKDIV      volatile.Register32 // 0x108
	CLKOUTDIV      volatile.Register32 // 0x10C
	_              [16]byte
	FREQMECTRL     volatile.Register32 // 0x120
	FLASHCFG       volatile.Register32 // 0x124
	_              [32]byte
	FIFOCTRL       volatile.Register32 // 0x148
	_              [56]byte
	IRCCTRL        volatile.Register32 // 0x184
	_              [8]byte
	RTCOSCCTRL     volatile.Register32 // 0x190
	_              [28]byte
	SYSPLLCTRL     volatile.Register32 // 0x1B0
	SYSPLLSTAT     volatile.Register32 // 0x1B4
	SYSPLLNDEC     volatile.Register32 // 0x1B8
	SYSPLLPDEC     volatile.Register32 // 0x1BC
	SYSPLLSSCTRL0  volatile.Register32 // 0x1C0
	SYSPLLSSCTRL1  volatile.Register32 // 0x1C4
	_              [72]byte
	PDRUNCFG       volatile.Register32 // 0x210
	PDRUNCFGSET    volatile.Register32 // 0x214
	PDRUNCFGCLR    volatile.Register32 // 0x218
	_              [36]byte
	STARTERP0      volatile.Register32 // 0x240
	STARTERP1      volatile.Register32 // 0x244
	STARTERPSET0   volatile.Register32 // 0x248
	STARTERPSET1   volatile.Register32 // 0x24C
	STARTERPCLR0   volatile.Register32 // 0x250
	STARTERPCLR1   volatile.Register32 // 0x254
	_              [168]byte
	CPUCTRL        volatile.Register32 // 0x300
	CPBOOT         volatile.Register32 // 0x304
	CPSTACK        volatile.Register32 // 0x308
	_              [232]byte
	JTAGIDCODE     volatile.Register32 // 0x3F4
	DEVICE_ID0     volatile.Register32 // 0x3F8
	DEVICE_ID1     volatile.Register32 // 0x3FC
}

// Standard counter/timer 2
type CT32B2_Type struct {
	IR   volatile.Register32 // 0x0
	TCR  volatile.Register32 // 0x4
	TC   volatile.Register32 // 0x8
	PR   volatile.Register32 // 0xC
	PC   volatile.Register32 // 0x10
	MCR  volatile.Register32 // 0x14
	MR0  volatile.Register32 // 0x18
	MR1  volatile.Register32 // 0x1C
	MR2  volatile.Register32 // 0x20
	MR3  volatile.Register32 // 0x24
	CCR  volatile.Register32 // 0x28
	CR0  volatile.Register32 // 0x2C
	CR1  volatile.Register32 // 0x30
	CR2  volatile.Register32 // 0x34
	CR3  volatile.Register32 // 0x38
	EMR  volatile.Register32 // 0x3C
	_    [48]byte
	CTCR volatile.Register32 // 0x70
	PWMC volatile.Register32 // 0x74
}

// Group GPIO input interrupt 0
type GINT0_Type struct {
	CTRL      volatile.Register32 // 0x0
	_         [28]byte
	PORT_POL0 volatile.Register32 // 0x20
	PORT_POL1 volatile.Register32 // 0x24
	PORT_POL2 volatile.Register32 // 0x28
	_         [20]byte
	PORT_ENA0 volatile.Register32 // 0x40
	PORT_ENA1 volatile.Register32 // 0x44
	PORT_ENA2 volatile.Register32 // 0x48
}

// Pin interrupt and pattern match engine
type PINT_Type struct {
	ISEL   volatile.Register32 // 0x0
	IENR   volatile.Register32 // 0x4
	SIENR  volatile.Register32 // 0x8
	CIENR  volatile.Register32 // 0xC
	IENF   volatile.Register32 // 0x10
	SIENF  volatile.Register32 // 0x14
	CIENF  volatile.Register32 // 0x18
	RISE   volatile.Register32 // 0x1C
	FALL   volatile.Register32 // 0x20
	IST    volatile.Register32 // 0x24
	PMCTRL volatile.Register32 // 0x28
	PMSRC  volatile.Register32 // 0x2C
	PMCFG  volatile.Register32 // 0x30
}

// I/O pin configuration
type IOCON_Type struct {
	PIO0_0  volatile.Register32 // 0x0
	PIO0_1  volatile.Register32 // 0x4
	PIO0_2  volatile.Register32 // 0x8
	PIO0_3  volatile.Register32 // 0xC
	PIO0_4  volatile.Register32 // 0x10
	PIO0_5  volatile.Register32 // 0x14
	PIO0_6  volatile.Register32 // 0x18
	PIO0_7  volatile.Register32 // 0x1C
	PIO0_8  volatile.Register32 // 0x20
	PIO0_9  volatile.Register32 // 0x24
	PIO0_10 volatile.Register32 // 0x28
	PIO0_11 volatile.Register32 // 0x2C
	PIO0_12 volatile.Register32 // 0x30
	PIO0_13 volatile.Register32 // 0x34
	PIO0_14 volatile.Register32 // 0x38
	PIO0_15 volatile.Register32 // 0x3C
	PIO0_16 volatile.Register32 // 0x40
	PIO0_17 volatile.Register32 // 0x44
	PIO0_18 volatile.Register32 // 0x48
	PIO0_19 volatile.Register32 // 0x4C
	PIO0_20 volatile.Register32 // 0x50
	PIO0_21 volatile.Register32 // 0x54
	PIO0_22 volatile.Register32 // 0x58
	PIO0_23 volatile.Register32 // 0x5C
	PIO0_24 volatile.Register32 // 0x60
	PIO0_25 volatile.Register32 // 0x64
	PIO0_26 volatile.Register32 // 0x68
	PIO0_27 volatile.Register32 // 0x6C
	PIO0_28 volatile.Register32 // 0x70
	PIO0_29 volatile.Register32 // 0x74
	PIO0_30 volatile.Register32 // 0x78
	PIO0_31 volatile.Register32 // 0x7C
	PIO1_0  volatile.Register32 // 0x80
	PIO1_1  volatile.Register32 // 0x84
	PIO1_2  volatile.Register32 // 0x88
	PIO1_3  volatile.Register32 // 0x8C
	PIO1_4  volatile.Register32 // 0x90
	PIO1_5  volatile.Register32 // 0x94
	PIO1_6  volatile.Register32 // 0x98
	PIO1_7  volatile.Register32 // 0x9C
	PIO1_8  volatile.Register32 // 0xA0
	PIO1_9  volatile.Register32 // 0xA4
	PIO1_10 volatile.Register32 // 0xA8
	PIO1_11 volatile.Register32 // 0xAC
	PIO1_12 volatile.Register32 // 0xB0
	PIO1_13 volatile.Register32 // 0xB4
	PIO1_14 volatile.Register32 // 0xB8
	PIO1_15 volatile.Register32 // 0xBC
	PIO1_16 volatile.Register32 // 0xC0
	PIO1_17 volatile.Register32 // 0xC4
}

// Micro-tick timer
type UTICK_Type struct {
	CTRL volatile.Register32 // 0x0
	STAT volatile.Register32 // 0x4
}

// Advanced System configuration
type ADVSYSCON_Type struct {
	_       [68]byte
	BODCTRL volatile.Register32 // 0x44
}

// Windowed Watchdog Timer
type WWDT_Type struct {
	MOD     volatile.Register32 // 0x0
	TC      volatile.Register32 // 0x4
	FEED    volatile.Register32 // 0x8
	TV      volatile.Register32 // 0xC
	_       [4]byte
	WARNINT volatile.Register32 // 0x14
	WINDOW  volatile.Register32 // 0x18
}

// Real-Time Clock
type RTC_Type struct {
	CTRL  volatile.Register32 // 0x0
	MATCH volatile.Register32 // 0x4
	COUNT volatile.Register32 // 0x8
	WAKE  volatile.Register32 // 0xC
}

// Input multiplexing
type INPUTMUX_Type struct {
	_                 [192]byte
	PINTSEL0          volatile.Register32 // 0xC0
	PINTSEL1          volatile.Register32 // 0xC4
	PINTSEL2          volatile.Register32 // 0xC8
	PINTSEL3          volatile.Register32 // 0xCC
	PINTSEL4          volatile.Register32 // 0xD0
	PINTSEL5          volatile.Register32 // 0xD4
	PINTSEL6          volatile.Register32 // 0xD8
	PINTSEL7          volatile.Register32 // 0xDC
	DMA_ITRIG_INMUX0  volatile.Register32 // 0xE0
	DMA_ITRIG_INMUX1  volatile.Register32 // 0xE4
	DMA_ITRIG_INMUX2  volatile.Register32 // 0xE8
	DMA_ITRIG_INMUX3  volatile.Register32 // 0xEC
	DMA_ITRIG_INMUX4  volatile.Register32 // 0xF0
	DMA_ITRIG_INMUX5  volatile.Register32 // 0xF4
	DMA_ITRIG_INMUX6  volatile.Register32 // 0xF8
	DMA_ITRIG_INMUX7  volatile.Register32 // 0xFC
	DMA_ITRIG_INMUX8  volatile.Register32 // 0x100
	DMA_ITRIG_INMUX9  volatile.Register32 // 0x104
	DMA_ITRIG_INMUX10 volatile.Register32 // 0x108
	DMA_ITRIG_INMUX11 volatile.Register32 // 0x10C
	DMA_ITRIG_INMUX12 volatile.Register32 // 0x110
	DMA_ITRIG_INMUX13 volatile.Register32 // 0x114
	DMA_ITRIG_INMUX14 volatile.Register32 // 0x118
	DMA_ITRIG_INMUX15 volatile.Register32 // 0x11C
	DMA_ITRIG_INMUX16 volatile.Register32 // 0x120
	DMA_ITRIG_INMUX17 volatile.Register32 // 0x124
	DMA_ITRIG_INMUX18 volatile.Register32 // 0x128
	DMA_ITRIG_INMUX19 volatile.Register32 // 0x12C
	DMA_ITRIG_INMUX20 volatile.Register32 // 0x130
	DMA_ITRIG_INMUX21 volatile.Register32 // 0x134
	_                 [8]byte
	DMA_OTRIG_INMUX0  volatile.Register32 // 0x140
	DMA_OTRIG_INMUX1  volatile.Register32 // 0x144
	DMA_OTRIG_INMUX2  volatile.Register32 // 0x148
	DMA_OTRIG_INMUX3  volatile.Register32 // 0x14C
	_                 [16]byte
	FREQMEAS_REF      volatile.Register32 // 0x160
	FREQMEAS_TARGET   volatile.Register32 // 0x164
}

// Repetitive Interrupt Timer
type RIT_Type struct {
	COMPVAL   volatile.Register32 // 0x0
	MASK      volatile.Register32 // 0x4
	CTRL      volatile.Register32 // 0x8
	COUNTER   volatile.Register32 // 0xC
	COMPVAL_H volatile.Register32 // 0x10
	MASK_H    volatile.Register32 // 0x14
	_         [4]byte
	COUNTER_H volatile.Register32 // 0x1C
}

// Multi-Rate Timer
type MRT_Type struct {
	INTVAL0  volatile.Register32 // 0x0
	TIMER0   volatile.Register32 // 0x4
	CTRL0    volatile.Register32 // 0x8
	STAT0    volatile.Register32 // 0xC
	INTVAL1  volatile.Register32 // 0x10
	TIMER1   volatile.Register32 // 0x14
	CTRL1    volatile.Register32 // 0x18
	STAT1    volatile.Register32 // 0x1C
	INTVAL2  volatile.Register32 // 0x20
	TIMER2   volatile.Register32 // 0x24
	CTRL2    volatile.Register32 // 0x28
	STAT2    volatile.Register32 // 0x2C
	INTVAL3  volatile.Register32 // 0x30
	TIMER3   volatile.Register32 // 0x34
	CTRL3    volatile.Register32 // 0x38
	STAT3    volatile.Register32 // 0x3C
	_        [176]byte
	MODCFG   volatile.Register32 // 0xF0
	IDLE_CH  volatile.Register32 // 0xF4
	IRQ_FLAG volatile.Register32 // 0xF8
}

// Asynchronous system configuration
type ASYNCSYSCON_Type struct {
	AYSNCPRESETCTRL    volatile.Register32 // 0x0
	AYSNCPRESETCTRLSET volatile.Register32 // 0x4
	AYSNCPRESETCTRLCLR volatile.Register32 // 0x8
	_                  [4]byte
	ASYNCAPBCLKCTRL    volatile.Register32 // 0x10
	ASYNCAPBCLKCTRLSET volatile.Register32 // 0x14
	ASYNCAPBCLKCTRLCLR volatile.Register32 // 0x18
	_                  [4]byte
	ASYNCAPBCLKSELA    volatile.Register32 // 0x20
	ASYNCAPBCLKSELB    volatile.Register32 // 0x24
	ASYNCCLKDIV        volatile.Register32 // 0x28
	_                  [4]byte
	FRGCTRL            volatile.Register32 // 0x30
	_                  [16]byte
	BODCTRL            volatile.Register32 // 0x44
}

// USART0
type USART0_Type struct {
	CFG       volatile.Register32 // 0x0
	CTL       volatile.Register32 // 0x4
	STAT      volatile.Register32 // 0x8
	INTENSET  volatile.Register32 // 0xC
	INTENCLR  volatile.Register32 // 0x10
	RXDAT     volatile.Register32 // 0x14
	RXDATSTAT volatile.Register32 // 0x18
	TXDAT     volatile.Register32 // 0x1C
	BRG       volatile.Register32 // 0x20
	INTSTAT   volatile.Register32 // 0x24
	OSR       volatile.Register32 // 0x28
	ADDR      volatile.Register32 // 0x2C
}

// I2C-bus interface 0
type I2C0_Type struct {
	CFG      volatile.Register32 // 0x0
	STAT     volatile.Register32 // 0x4
	INTENSET volatile.Register32 // 0x8
	INTENCLR volatile.Register32 // 0xC
	TIMEOUT  volatile.Register32 // 0x10
	CLKDIV   volatile.Register32 // 0x14
	INTSTAT  volatile.Register32 // 0x18
	_        [4]byte
	MSTCTL   volatile.Register32 // 0x20
	MSTTIME  volatile.Register32 // 0x24
	MSTDAT   volatile.Register32 // 0x28
	_        [20]byte
	SLVCTL   volatile.Register32 // 0x40
	SLVDAT   volatile.Register32 // 0x44
	SLVADR0  volatile.Register32 // 0x48
	SLVADR1  volatile.Register32 // 0x4C
	SLVADR2  volatile.Register32 // 0x50
	SLVADR3  volatile.Register32 // 0x54
	SLVQUAL0 volatile.Register32 // 0x58
	_        [36]byte
	MONRXDAT volatile.Register32 // 0x80
}

// SPI0
type SPI0_Type struct {
	CFG      volatile.Register32 // 0x0
	DLY      volatile.Register32 // 0x4
	STAT     volatile.Register32 // 0x8
	INTENSET volatile.Register32 // 0xC
	INTENCLR volatile.Register32 // 0x10
	RXDAT    volatile.Register32 // 0x14
	TXDATCTL volatile.Register32 // 0x18
	TXDAT    volatile.Register32 // 0x1C
	TXCTL    volatile.Register32 // 0x20
	DIV      volatile.Register32 // 0x24
	INTSTAT  volatile.Register32 // 0x28
}

// Bitfields for GPIO: General Purpose I/O
const (
	// B0: Byte pin registers port 0/1; pins PIO0_0 to PIO1_8
	// Position of PBYTE field.
	GPIO_B_PBYTE_Pos = 0x0
	// Bit mask of PBYTE field.
	GPIO_B_PBYTE_Msk = 0x1
	// Bit PBYTE.
	GPIO_B_PBYTE = 0x1

	// W0: Word pin registers port 0/1; pins PIO0_0 to PIO1_8
	// Position of PWORD field.
	GPIO_W_PWORD_Pos = 0x0
	// Bit mask of PWORD field.
	GPIO_W_PWORD_Msk = 0xffffffff

	// DIR0: Direction registers port 0/1
	// Position of DIRP field.
	GPIO_DIR_DIRP_Pos = 0x0
	// Bit mask of DIRP field.
	GPIO_DIR_DIRP_Msk = 0xffffffff

	// MASK0: Mask register port 0/1
	// Position of MASKP field.
	GPIO_MASK_MASKP_Pos = 0x0
	// Bit mask of MASKP field.
	GPIO_MASK_MASKP_Msk = 0xffffffff

	// PIN0: Port pin register port 0/1
	// Position of PORT field.
	GPIO_PIN_PORT_Pos = 0x0
	// Bit mask of PORT field.
	GPIO_PIN_PORT_Msk = 0xffffffff

	// MPIN0: Masked port register port 0/1
	// Position of MPORTP field.
	GPIO_MPIN_MPORTP_Pos = 0x0
	// Bit mask of MPORTP field.
	GPIO_MPIN_MPORTP_Msk = 0xffffffff

	// SET0: Write: Set register for port 0/1 Read: output bits for port 0/1
	// Position of SETP field.
	GPIO_SET_SETP_Pos = 0x0
	// Bit mask of SETP field.
	GPIO_SET_SETP_Msk = 0xffffffff

	// CLR0: Clear port 0/1
	// Position of CLRP field.
	GPIO_CLR_CLRP_Pos = 0x0
	// Bit mask of CLRP field.
	GPIO_CLR_CLRP_Msk = 0xffffffff

	// NOT0: Toggle port 0/1
	// Position of NOTP field.
	GPIO_NOT_NOTP_Pos = 0x0
	// Bit mask of NOTP field.
	GPIO_NOT_NOTP_Msk = 0xffffffff
)

// Bitfields for DMA: DMA controller
const (
	// CTRL: DMA control.
	// Position of ENABLE field.
	DMA_CTRL_ENABLE_Pos = 0x0
	// Bit mask of ENABLE field.
	DMA_CTRL_ENABLE_Msk = 0x1
	// Bit ENABLE.
	DMA_CTRL_ENABLE = 0x1
	// Disabled. The DMA controller is disabled. This clears any triggers that were asserted at the point when disabled, but does not prevent re-triggering when the DMA controller is re-enabled.
	DMA_CTRL_ENABLE_DISABLED = 0x0
	// Enabled. The DMA controller is enabled.
	DMA_CTRL_ENABLE_ENABLED = 0x1
	// Position of RESERVED field.
	DMA_CTRL_RESERVED_Pos = 0x1
	// Bit mask of RESERVED field.
	DMA_CTRL_RESERVED_Msk = 0xfffffffe

	// INTSTAT: Interrupt status.
	// Position of RESERVED field.
	DMA_INTSTAT_RESERVED_Pos = 0x0
	// Bit mask of RESERVED field.
	DMA_INTSTAT_RESERVED_Msk = 0x1
	// Bit RESERVED.
	DMA_INTSTAT_RESERVED = 0x1
	// Position of ACTIVEINT field.
	DMA_INTSTAT_ACTIVEINT_Pos = 0x1
	// Bit mask of ACTIVEINT field.
	DMA_INTSTAT_ACTIVEINT_Msk = 0x2
	// Bit ACTIVEINT.
	DMA_INTSTAT_ACTIVEINT = 0x2
	// Not pending. No enabled interrupts are pending.
	DMA_INTSTAT_ACTIVEINT_NOT_PENDING = 0x0
	// Pending. At least one enabled interrupt is pending.
	DMA_INTSTAT_ACTIVEINT_PENDING = 0x1
	// Position of ACTIVEERRINT field.
	DMA_INTSTAT_ACTIVEERRINT_Pos = 0x2
	// Bit mask of ACTIVEERRINT field.
	DMA_INTSTAT_ACTIVEERRINT_Msk = 0x4
	// Bit ACTIVEERRINT.
	DMA_INTSTAT_ACTIVEERRINT = 0x4
	// Not pending. No error interrupts are pending.
	DMA_INTSTAT_ACTIVEERRINT_NOT_PENDING = 0x0
	// Pending. At least one error interrupt is pending.
	DMA_INTSTAT_ACTIVEERRINT_PENDING = 0x1
	// Position of RESERVED field.
	DMA_INTSTAT_RESERVED_Pos = 0x3
	// Bit mask of RESERVED field.
	DMA_INTSTAT_RESERVED_Msk = 0xfffffff8

	// SRAMBASE: SRAM address of the channel configuration table.
	// Position of RESERVED field.
	DMA_SRAMBASE_RESERVED_Pos = 0x0
	// Bit mask of RESERVED field.
	DMA_SRAMBASE_RESERVED_Msk = 0x1ff
	// Position of OFFSET field.
	DMA_SRAMBASE_OFFSET_Pos = 0x9
	// Bit mask of OFFSET field.
	DMA_SRAMBASE_OFFSET_Msk = 0xfffffe00

	// ENABLESET0: Channel Enable read and Set for all DMA channels.
	// Position of ENA field.
	DMA_ENABLESET0_ENA_Pos = 0x0
	// Bit mask of ENA field.
	DMA_ENABLESET0_ENA_Msk = 0x3fffff
	// Position of RESERVED field.
	DMA_ENABLESET0_RESERVED_Pos = 0x16
	// Bit mask of RESERVED field.
	DMA_ENABLESET0_RESERVED_Msk = 0xffc00000

	// ENABLECLR0: Channel Enable Clear for all DMA channels.
	// Position of CLR field.
	DMA_ENABLECLR0_CLR_Pos = 0x0
	// Bit mask of CLR field.
	DMA_ENABLECLR0_CLR_Msk = 0x3fffff
	// Position of RESERVED field.
	DMA_ENABLECLR0_RESERVED_Pos = 0x16
	// Bit mask of RESERVED field.
	DMA_ENABLECLR0_RESERVED_Msk = 0xffc00000

	// ACTIVE0: Channel Active status for all DMA channels.
	// Position of ACT field.
	DMA_ACTIVE0_ACT_Pos = 0x0
	// Bit mask of ACT field.
	DMA_ACTIVE0_ACT_Msk = 0x3fffff
	// Position of RESERVED field.
	DMA_ACTIVE0_RESERVED_Pos = 0x16
	// Bit mask of RESERVED field.
	DMA_ACTIVE0_RESERVED_Msk = 0xffc00000

	// BUSY0: Channel Busy status for all DMA channels.
	// Position of BSY field.
	DMA_BUSY0_BSY_Pos = 0x0
	// Bit mask of BSY field.
	DMA_BUSY0_BSY_Msk = 0x3fffff
	// Position of RESERVED field.
	DMA_BUSY0_RESERVED_Pos = 0x16
	// Bit mask of RESERVED field.
	DMA_BUSY0_RESERVED_Msk = 0xffc00000

	// ERRINT0: Error Interrupt status for all DMA channels.
	// Position of ERR field.
	DMA_ERRINT0_ERR_Pos = 0x0
	// Bit mask of ERR field.
	DMA_ERRINT0_ERR_Msk = 0x3fffff
	// Position of RESERVED field.
	DMA_ERRINT0_RESERVED_Pos = 0x16
	// Bit mask of RESERVED field.
	DMA_ERRINT0_RESERVED_Msk = 0xffc00000

	// INTENSET0: Interrupt Enable read and Set for all DMA channels.
	// Position of INTEN field.
	DMA_INTENSET0_INTEN_Pos = 0x0
	// Bit mask of INTEN field.
	DMA_INTENSET0_INTEN_Msk = 0x3fffff
	// Position of RESERVED field.
	DMA_INTENSET0_RESERVED_Pos = 0x16
	// Bit mask of RESERVED field.
	DMA_INTENSET0_RESERVED_Msk = 0xffc00000

	// INTENCLR0: Interrupt Enable Clear for all DMA channels.
	// Position of CLR field.
	DMA_INTENCLR0_CLR_Pos = 0x0
	// Bit mask of CLR field.
	DMA_INTENCLR0_CLR_Msk = 0x3fffff
	// Position of RESERVED field.
	DMA_INTENCLR0_RESERVED_Pos = 0x16
	// Bit mask of RESERVED field.
	DMA_INTENCLR0_RESERVED_Msk = 0xffc00000

	// INTA0: Interrupt A status for all DMA channels.
	// Position of IA field.
	DMA_INTA0_IA_Pos = 0x0
	// Bit mask of IA field.
	DMA_INTA0_IA_Msk = 0x3fffff
	// Position of RESERVED field.
	DMA_INTA0_RESERVED_Pos = 0x16
	// Bit mask of RESERVED field.
	DMA_INTA0_RESERVED_Msk = 0xffc00000

	// INTB0: Interrupt B status for all DMA channels.
	// Position of IB field.
	DMA_INTB0_IB_Pos = 0x0
	// Bit mask of IB field.
	DMA_INTB0_IB_Msk = 0x3fffff
	// Position of RESERVED field.
	DMA_INTB0_RESERVED_Pos = 0x16
	// Bit mask of RESERVED field.
	DMA_INTB0_RESERVED_Msk = 0xffc00000

	// SETVALID0: Set ValidPending control bits for all DMA channels.
	// Position of SV field.
	DMA_SETVALID0_SV_Pos = 0x0
	// Bit mask of SV field.
	DMA_SETVALID0_SV_Msk = 0x3fffff
	// Position of RESERVED field.
	DMA_SETVALID0_RESERVED_Pos = 0x16
	// Bit mask of RESERVED field.
	DMA_SETVALID0_RESERVED_Msk = 0xffc00000

	// SETTRIG0: Set Trigger control bits for all DMA channels.
	// Position of TRIG field.
	DMA_SETTRIG0_TRIG_Pos = 0x0
	// Bit mask of TRIG field.
	DMA_SETTRIG0_TRIG_Msk = 0x3fffff
	// Position of RESERVED field.
	DMA_SETTRIG0_RESERVED_Pos = 0x16
	// Bit mask of RESERVED field.
	DMA_SETTRIG0_RESERVED_Msk = 0xffc00000

	// ABORT0: Channel Abort control for all DMA channels.
	// Position of ABORTCTRL field.
	DMA_ABORT0_ABORTCTRL_Pos = 0x0
	// Bit mask of ABORTCTRL field.
	DMA_ABORT0_ABORTCTRL_Msk = 0x3fffff
	// Position of RESERVED field.
	DMA_ABORT0_RESERVED_Pos = 0x16
	// Bit mask of RESERVED field.
	DMA_ABORT0_RESERVED_Msk = 0xffc00000

	// CFG0: Configuration register for DMA channel 0.
	// Position of PERIPHREQEN field.
	DMA_CFG_PERIPHREQEN_Pos = 0x0
	// Bit mask of PERIPHREQEN field.
	DMA_CFG_PERIPHREQEN_Msk = 0x1
	// Bit PERIPHREQEN.
	DMA_CFG_PERIPHREQEN = 0x1
	// Disabled. Peripheral DMA requests are disabled.
	DMA_CFG_PERIPHREQEN_DISABLED = 0x0
	// Enabled. Peripheral DMA requests are enabled.
	DMA_CFG_PERIPHREQEN_ENABLED = 0x1
	// Position of HWTRIGEN field.
	DMA_CFG_HWTRIGEN_Pos = 0x1
	// Bit mask of HWTRIGEN field.
	DMA_CFG_HWTRIGEN_Msk = 0x2
	// Bit HWTRIGEN.
	DMA_CFG_HWTRIGEN = 0x2
	// Disabled. Hardware triggering is not used.
	DMA_CFG_HWTRIGEN_DISABLED = 0x0
	// Enabled. Use hardware triggering.
	DMA_CFG_HWTRIGEN_ENABLED = 0x1
	// Position of RESERVED field.
	DMA_CFG_RESERVED_Pos = 0x2
	// Bit mask of RESERVED field.
	DMA_CFG_RESERVED_Msk = 0xc
	// Position of TRIGPOL field.
	DMA_CFG_TRIGPOL_Pos = 0x4
	// Bit mask of TRIGPOL field.
	DMA_CFG_TRIGPOL_Msk = 0x10
	// Bit TRIGPOL.
	DMA_CFG_TRIGPOL = 0x10
	// Active low - falling edge. Hardware trigger is active low or falling edge triggered, based on TRIGTYPE.
	DMA_CFG_TRIGPOL_ACTIVE_LOW__FALLING = 0x0
	// Active high - rising edge. Hardware trigger is active high or rising edge triggered, based on TRIGTYPE.
	DMA_CFG_TRIGPOL_ACTIVE_HIGH__RISING = 0x1
	// Position of TRIGTYPE field.
	DMA_CFG_TRIGTYPE_Pos = 0x5
	// Bit mask of TRIGTYPE field.
	DMA_CFG_TRIGTYPE_Msk = 0x20
	// Bit TRIGTYPE.
	DMA_CFG_TRIGTYPE = 0x20
	// Edge. Hardware trigger is edge triggered. Transfers will be initiated and completed, as specified for a single trigger.
	DMA_CFG_TRIGTYPE_EDGE = 0x0
	// Level. Hardware trigger is level triggered. Note that when level triggering without burst (BURSTPOWER = 0) is selected, only hardware triggers should be used on that channel. Transfers continue as long as the trigger level is asserted. Once the trigger is de-asserted, the transfer will be paused until the trigger is, again, asserted. However, the transfer will not be paused until any remaining transfers within the current BURSTPOWER length are completed.
	DMA_CFG_TRIGTYPE_LEVEL = 0x1
	// Position of TRIGBURST field.
	DMA_CFG_TRIGBURST_Pos = 0x6
	// Bit mask of TRIGBURST field.
	DMA_CFG_TRIGBURST_Msk = 0x40
	// Bit TRIGBURST.
	DMA_CFG_TRIGBURST = 0x40
	// Single transfer. Hardware trigger causes a single transfer.
	DMA_CFG_TRIGBURST_SINGLE_TRANSFER = 0x0
	// Burst transfer. When the trigger for this channel is set to edge triggered, a hardware trigger causes a burst transfer, as defined by BURSTPOWER. When the trigger for this channel is set to level triggered, a hardware trigger causes transfers to continue as long as the trigger is asserted, unless the transfer is complete.
	DMA_CFG_TRIGBURST_BURST_TRANSFER = 0x1
	// Position of RESERVED field.
	DMA_CFG_RESERVED_Pos = 0x7
	// Bit mask of RESERVED field.
	DMA_CFG_RESERVED_Msk = 0x80
	// Bit RESERVED.
	DMA_CFG_RESERVED = 0x80
	// Position of BURSTPOWER field.
	DMA_CFG_BURSTPOWER_Pos = 0x8
	// Bit mask of BURSTPOWER field.
	DMA_CFG_BURSTPOWER_Msk = 0xf00
	// Position of RESERVED field.
	DMA_CFG_RESERVED_Pos = 0xc
	// Bit mask of RESERVED field.
	DMA_CFG_RESERVED_Msk = 0x3000
	// Position of SRCBURSTWRAP field.
	DMA_CFG_SRCBURSTWRAP_Pos = 0xe
	// Bit mask of SRCBURSTWRAP field.
	DMA_CFG_SRCBURSTWRAP_Msk = 0x4000
	// Bit SRCBURSTWRAP.
	DMA_CFG_SRCBURSTWRAP = 0x4000
	// Disabled. Source burst wrapping is not enabled for this DMA channel.
	DMA_CFG_SRCBURSTWRAP_DISABLED = 0x0
	// Enabled. Source burst wrapping is enabled for this DMA channel.
	DMA_CFG_SRCBURSTWRAP_ENABLED = 0x1
	// Position of DSTBURSTWRAP field.
	DMA_CFG_DSTBURSTWRAP_Pos = 0xf
	// Bit mask of DSTBURSTWRAP field.
	DMA_CFG_DSTBURSTWRAP_Msk = 0x8000
	// Bit DSTBURSTWRAP.
	DMA_CFG_DSTBURSTWRAP = 0x8000
	// Disabled. Destination burst wrapping is not enabled for this DMA channel.
	DMA_CFG_DSTBURSTWRAP_DISABLED = 0x0
	// Enabled. Destination burst wrapping is enabled for this DMA channel.
	DMA_CFG_DSTBURSTWRAP_ENABLED = 0x1
	// Position of CHPRIORITY field.
	DMA_CFG_CHPRIORITY_Pos = 0x10
	// Bit mask of CHPRIORITY field.
	DMA_CFG_CHPRIORITY_Msk = 0x70000
	// Position of RESERVED field.
	DMA_CFG_RESERVED_Pos = 0x13
	// Bit mask of RESERVED field.
	DMA_CFG_RESERVED_Msk = 0xfff80000

	// CTLSTAT0: Control and status register for DMA channel 0.
	// Position of VALIDPENDING field.
	DMA_CTLSTAT_VALIDPENDING_Pos = 0x0
	// Bit mask of VALIDPENDING field.
	DMA_CTLSTAT_VALIDPENDING_Msk = 0x1
	// Bit VALIDPENDING.
	DMA_CTLSTAT_VALIDPENDING = 0x1
	// No effect. No effect on DMA operation.
	DMA_CTLSTAT_VALIDPENDING_NO_EFFECT = 0x0
	// Valid pending.
	DMA_CTLSTAT_VALIDPENDING_VALID_PENDING = 0x1
	// Position of RESERVED field.
	DMA_CTLSTAT_RESERVED_Pos = 0x1
	// Bit mask of RESERVED field.
	DMA_CTLSTAT_RESERVED_Msk = 0x2
	// Bit RESERVED.
	DMA_CTLSTAT_RESERVED = 0x2
	// Position of TRIG field.
	DMA_CTLSTAT_TRIG_Pos = 0x2
	// Bit mask of TRIG field.
	DMA_CTLSTAT_TRIG_Msk = 0x4
	// Bit TRIG.
	DMA_CTLSTAT_TRIG = 0x4
	// Not triggered. The trigger for this DMA channel is not set. DMA operations will not be carried out.
	DMA_CTLSTAT_TRIG_NOT_TRIGGERED = 0x0
	// Triggered. The trigger for this DMA channel is set. DMA operations will be carried out.
	DMA_CTLSTAT_TRIG_TRIGGERED = 0x1
	// Position of RESERVED field.
	DMA_CTLSTAT_RESERVED_Pos = 0x3
	// Bit mask of RESERVED field.
	DMA_CTLSTAT_RESERVED_Msk = 0xfffffff8

	// XFERCFG0: Transfer configuration register for DMA channel 0.
	// Position of CFGVALID field.
	DMA_XFERCFG_CFGVALID_Pos = 0x0
	// Bit mask of CFGVALID field.
	DMA_XFERCFG_CFGVALID_Msk = 0x1
	// Bit CFGVALID.
	DMA_XFERCFG_CFGVALID = 0x1
	// Not valid. The channel descriptor is not considered valid until validated by an associated SETVALID0 setting.
	DMA_XFERCFG_CFGVALID_NOT_VALID = 0x0
	// Valid. The current channel descriptor is considered valid.
	DMA_XFERCFG_CFGVALID_VALID = 0x1
	// Position of RELOAD field.
	DMA_XFERCFG_RELOAD_Pos = 0x1
	// Bit mask of RELOAD field.
	DMA_XFERCFG_RELOAD_Msk = 0x2
	// Bit RELOAD.
	DMA_XFERCFG_RELOAD = 0x2
	// Disabled. Do not reload the channels' control structure when the current descriptor is exhausted.
	DMA_XFERCFG_RELOAD_DISABLED = 0x0
	// Enabled. Reload the channels' control structure when the current descriptor is exhausted.
	DMA_XFERCFG_RELOAD_ENABLED = 0x1
	// Position of SWTRIG field.
	DMA_XFERCFG_SWTRIG_Pos = 0x2
	// Bit mask of SWTRIG field.
	DMA_XFERCFG_SWTRIG_Msk = 0x4
	// Bit SWTRIG.
	DMA_XFERCFG_SWTRIG = 0x4
	// Not set. When written by software, the trigger for this channel is not set. A new trigger, as defined by the HWTRIGEN, TRIGPOL, and TRIGTYPE will be needed to start the channel.
	DMA_XFERCFG_SWTRIG_NOT_SET = 0x0
	// Set, When written by software, the trigger for this channel is set immediately. This feature should not be used with level triggering when TRIGBURST = 0.
	DMA_XFERCFG_SWTRIG_SET = 0x1
	// Position of CLRTRIG field.
	DMA_XFERCFG_CLRTRIG_Pos = 0x3
	// Bit mask of CLRTRIG field.
	DMA_XFERCFG_CLRTRIG_Msk = 0x8
	// Bit CLRTRIG.
	DMA_XFERCFG_CLRTRIG = 0x8
	// Not cleared. The trigger is not cleared when this descriptor is exhausted. If there is a reload, the next descriptor will be started.
	DMA_XFERCFG_CLRTRIG_NOT_CLEARED = 0x0
	// Cleared. The trigger is cleared when this descriptor is exhausted.
	DMA_XFERCFG_CLRTRIG_CLEARED = 0x1
	// Position of SETINTA field.
	DMA_XFERCFG_SETINTA_Pos = 0x4
	// Bit mask of SETINTA field.
	DMA_XFERCFG_SETINTA_Msk = 0x10
	// Bit SETINTA.
	DMA_XFERCFG_SETINTA = 0x10
	// No effect.
	DMA_XFERCFG_SETINTA_NO_EFFECT = 0x0
	// Set. The INTA flag for this channel will be set when the current descriptor is exhausted.
	DMA_XFERCFG_SETINTA_SET = 0x1
	// Position of SETINTB field.
	DMA_XFERCFG_SETINTB_Pos = 0x5
	// Bit mask of SETINTB field.
	DMA_XFERCFG_SETINTB_Msk = 0x20
	// Bit SETINTB.
	DMA_XFERCFG_SETINTB = 0x20
	// No effect.
	DMA_XFERCFG_SETINTB_NO_EFFECT = 0x0
	// Set. The INTB flag for this channel will be set when the current descriptor is exhausted.
	DMA_XFERCFG_SETINTB_SET = 0x1
	// Position of RESERVED field.
	DMA_XFERCFG_RESERVED_Pos = 0x6
	// Bit mask of RESERVED field.
	DMA_XFERCFG_RESERVED_Msk = 0xc0
	// Position of WIDTH field.
	DMA_XFERCFG_WIDTH_Pos = 0x8
	// Bit mask of WIDTH field.
	DMA_XFERCFG_WIDTH_Msk = 0x300
	// 8-bit. 8-bit transfers are performed (8-bit source reads and destination writes).
	DMA_XFERCFG_WIDTH_8_BIT = 0x0
	// 16-bit. 6-bit transfers are performed (16-bit source reads and destination writes).
	DMA_XFERCFG_WIDTH_16_BIT = 0x1
	// 32-bit. 32-bit transfers are performed (32-bit source reads and destination writes).
	DMA_XFERCFG_WIDTH_32_BIT = 0x2
	// Position of RESERVED field.
	DMA_XFERCFG_RESERVED_Pos = 0xa
	// Bit mask of RESERVED field.
	DMA_XFERCFG_RESERVED_Msk = 0xc00
	// Position of SRCINC field.
	DMA_XFERCFG_SRCINC_Pos = 0xc
	// Bit mask of SRCINC field.
	DMA_XFERCFG_SRCINC_Msk = 0x3000
	// No increment. The source address is not incremented for each transfer. This is the usual case when the source is a peripheral device.
	DMA_XFERCFG_SRCINC_NO_INCREMENT = 0x0
	// 1 x width. The source address is incremented by the amount specified by Width for each transfer. This is the usual case when the source is memory.
	DMA_XFERCFG_SRCINC_1_X_WIDTH = 0x1
	// 2 x width. The source address is incremented by 2 times the amount specified by Width for each transfer.
	DMA_XFERCFG_SRCINC_2_X_WIDTH = 0x2
	// 4 x width. The source address is incremented by 4 times the amount specified by Width for each transfer.
	DMA_XFERCFG_SRCINC_4_X_WIDTH = 0x3
	// Position of DSTINC field.
	DMA_XFERCFG_DSTINC_Pos = 0xe
	// Bit mask of DSTINC field.
	DMA_XFERCFG_DSTINC_Msk = 0xc000
	// No increment. The destination address is not incremented for each transfer. This is the usual case when the destination is a peripheral device.
	DMA_XFERCFG_DSTINC_NO_INCREMENT = 0x0
	// 1 x width. The destination address is incremented by the amount specified by Width for each transfer. This is the usual case when the destination is memory.
	DMA_XFERCFG_DSTINC_1_X_WIDTH = 0x1
	// 2 x width. The destination address is incremented by 2 times the amount specified by Width for each transfer.
	DMA_XFERCFG_DSTINC_2_X_WIDTH = 0x2
	// 4 x width. The destination address is incremented by 4 times the amount specified by Width for each transfer.
	DMA_XFERCFG_DSTINC_4_X_WIDTH = 0x3
	// Position of XFERCOUNT field.
	DMA_XFERCFG_XFERCOUNT_Pos = 0x10
	// Bit mask of XFERCOUNT field.
	DMA_XFERCFG_XFERCOUNT_Msk = 0x3ff0000
	// Position of RESERVED field.
	DMA_XFERCFG_RESERVED_Pos = 0x1a
	// Bit mask of RESERVED field.
	DMA_XFERCFG_RESERVED_Msk = 0xfc000000
)

// Bitfields for CRC: CRC engine
const (
	// MODE: CRC mode register
	// Position of CRC_POLY field.
	CRC_MODE_CRC_POLY_Pos = 0x0
	// Bit mask of CRC_POLY field.
	CRC_MODE_CRC_POLY_Msk = 0x3
	// Position of BIT_RVS_WR field.
	CRC_MODE_BIT_RVS_WR_Pos = 0x2
	// Bit mask of BIT_RVS_WR field.
	CRC_MODE_BIT_RVS_WR_Msk = 0x4
	// Bit BIT_RVS_WR.
	CRC_MODE_BIT_RVS_WR = 0x4
	// Position of CMPL_WR field.
	CRC_MODE_CMPL_WR_Pos = 0x3
	// Bit mask of CMPL_WR field.
	CRC_MODE_CMPL_WR_Msk = 0x8
	// Bit CMPL_WR.
	CRC_MODE_CMPL_WR = 0x8
	// Position of BIT_RVS_SUM field.
	CRC_MODE_BIT_RVS_SUM_Pos = 0x4
	// Bit mask of BIT_RVS_SUM field.
	CRC_MODE_BIT_RVS_SUM_Msk = 0x10
	// Bit BIT_RVS_SUM.
	CRC_MODE_BIT_RVS_SUM = 0x10
	// Position of CMPL_SUM field.
	CRC_MODE_CMPL_SUM_Pos = 0x5
	// Bit mask of CMPL_SUM field.
	CRC_MODE_CMPL_SUM_Msk = 0x20
	// Bit CMPL_SUM.
	CRC_MODE_CMPL_SUM = 0x20
	// Position of Reserved field.
	CRC_MODE_Reserved_Pos = 0x6
	// Bit mask of Reserved field.
	CRC_MODE_Reserved_Msk = 0xffffffc0

	// SEED: CRC seed register
	// Position of CRC_SEED field.
	CRC_SEED_CRC_SEED_Pos = 0x0
	// Bit mask of CRC_SEED field.
	CRC_SEED_CRC_SEED_Msk = 0xffffffff

	// SUM: CRC checksum register
	// Position of CRC_SUM field.
	CRC_SUM_CRC_SUM_Pos = 0x0
	// Bit mask of CRC_SUM field.
	CRC_SUM_CRC_SUM_Msk = 0xffffffff

	// WR_DATA: CRC data register
	// Position of CRC_WR_DATA field.
	CRC_WR_DATA_CRC_WR_DATA_Pos = 0x0
	// Bit mask of CRC_WR_DATA field.
	CRC_WR_DATA_CRC_WR_DATA_Msk = 0xffffffff
)

// Bitfields for SCT0: State Configurable Timer/PWM 0
const (
	// CONFIG: SCT configuration register
	// Position of UNIFY field.
	SCT0_CONFIG_UNIFY_Pos = 0x0
	// Bit mask of UNIFY field.
	SCT0_CONFIG_UNIFY_Msk = 0x1
	// Bit UNIFY.
	SCT0_CONFIG_UNIFY = 0x1
	// Dual counter. The SCT operates as two 16-bit counters named L and H.
	SCT0_CONFIG_UNIFY_DUAL_COUNTER = 0x0
	// Unified counter. The SCT operates as a unified 32-bit counter.
	SCT0_CONFIG_UNIFY_UNIFIED_COUNTER = 0x1
	// Position of CLKMODE field.
	SCT0_CONFIG_CLKMODE_Pos = 0x1
	// Bit mask of CLKMODE field.
	SCT0_CONFIG_CLKMODE_Msk = 0x6
	// System clock. The system clock clocks the SCT and prescalers.
	SCT0_CONFIG_CLKMODE_SYSTEM_CLOCK = 0x0
	// Prescaled system clock. The SCT clock is the system clock, but the prescalers are enabled to count only when sampling of the input selected by the CKSEL field finds the selected edge. The minimum pulse width on the clock input is 1 bus clock period. This mode is the high-performance sampled-clock mode.
	SCT0_CONFIG_CLKMODE_PRESCALED_SYSTEM_CLO = 0x1
	// SCT input. The input selected by CKSEL clocks the SCT and prescalers. The input is synchronized to the system clock and possibly inverted. The minimum pulse width on the clock input is 1 bus clock period. This mode is the low-power sampled-clock mode.
	SCT0_CONFIG_CLKMODE_SCT_INPUT = 0x2
	// Prescaled SCT input. The SCT and prescalers are clocked by the input edge selected by the CKSEL field. In this mode, most of the SCT is clocked by the (selected polarity of the) input. The outputs are switched synchronously to the input clock. The input clock rate must be at least half the system clock rate and can be the same or faster than the system clock.
	SCT0_CONFIG_CLKMODE_PRESCALED_SCT_INPUT = 0x3
	// Position of CKSEL field.
	SCT0_CONFIG_CKSEL_Pos = 0x3
	// Bit mask of CKSEL field.
	SCT0_CONFIG_CKSEL_Msk = 0x78
	// Input 0 rising edges.
	SCT0_CONFIG_CKSEL_INPUT_0_RISING_EDGES = 0x0
	// Input 0 falling edges.
	SCT0_CONFIG_CKSEL_INPUT_0_FALLING_EDGE = 0x1
	// Input 1 rising edges.
	SCT0_CONFIG_CKSEL_INPUT_1_RISING_EDGES = 0x2
	// Input 1 falling edges.
	SCT0_CONFIG_CKSEL_INPUT_1_FALLING_EDGE = 0x3
	// Input 2 rising edges.
	SCT0_CONFIG_CKSEL_INPUT_2_RISING_EDGES = 0x4
	// Input 2 falling edges.
	SCT0_CONFIG_CKSEL_INPUT_2_FALLING_EDGE = 0x5
	// Input 3 rising edges.
	SCT0_CONFIG_CKSEL_INPUT_3_RISING_EDGES = 0x6
	// Input 3 falling edges.
	SCT0_CONFIG_CKSEL_INPUT_3_FALLING_EDGE = 0x7
	// Input 4 rising edges.
	SCT0_CONFIG_CKSEL_INPUT_4_RISING_EDGES = 0x8
	// Input 4 falling edges.
	SCT0_CONFIG_CKSEL_INPUT_4_FALLING_EDGE = 0x9
	// Input 5 rising edges.
	SCT0_CONFIG_CKSEL_INPUT_5_RISING_EDGES = 0xa
	// Input 5 falling edges.
	SCT0_CONFIG_CKSEL_INPUT_5_FALLING_EDGE = 0xb
	// Input 6 rising edges.
	SCT0_CONFIG_CKSEL_INPUT_6_RISING_EDGES = 0xc
	// Input 6 falling edges.
	SCT0_CONFIG_CKSEL_INPUT_6_FALLING_EDGE = 0xd
	// Input 7 rising edges.
	SCT0_CONFIG_CKSEL_INPUT_7_RISING_EDGES = 0xe
	// Input 7 falling edges.
	SCT0_CONFIG_CKSEL_INPUT_7_FALLING_EDGE = 0xf
	// Position of NORELOAD_L field.
	SCT0_CONFIG_NORELOAD_L_Pos = 0x7
	// Bit mask of NORELOAD_L field.
	SCT0_CONFIG_NORELOAD_L_Msk = 0x80
	// Bit NORELOAD_L.
	SCT0_CONFIG_NORELOAD_L = 0x80
	// Position of NORELOAD_H field.
	SCT0_CONFIG_NORELOAD_H_Pos = 0x8
	// Bit mask of NORELOAD_H field.
	SCT0_CONFIG_NORELOAD_H_Msk = 0x100
	// Bit NORELOAD_H.
	SCT0_CONFIG_NORELOAD_H = 0x100
	// Position of INSYNC field.
	SCT0_CONFIG_INSYNC_Pos = 0x9
	// Bit mask of INSYNC field.
	SCT0_CONFIG_INSYNC_Msk = 0x7e00
	// Position of RESERVED field.
	SCT0_CONFIG_RESERVED_Pos = 0xf
	// Bit mask of RESERVED field.
	SCT0_CONFIG_RESERVED_Msk = 0x18000
	// Position of AUTOLIMIT_L field.
	SCT0_CONFIG_AUTOLIMIT_L_Pos = 0x11
	// Bit mask of AUTOLIMIT_L field.
	SCT0_CONFIG_AUTOLIMIT_L_Msk = 0x20000
	// Bit AUTOLIMIT_L.
	SCT0_CONFIG_AUTOLIMIT_L = 0x20000
	// Position of AUTOLIMIT_H field.
	SCT0_CONFIG_AUTOLIMIT_H_Pos = 0x12
	// Bit mask of AUTOLIMIT_H field.
	SCT0_CONFIG_AUTOLIMIT_H_Msk = 0x40000
	// Bit AUTOLIMIT_H.
	SCT0_CONFIG_AUTOLIMIT_H = 0x40000
	// Position of RESERVED field.
	SCT0_CONFIG_RESERVED_Pos = 0x13
	// Bit mask of RESERVED field.
	SCT0_CONFIG_RESERVED_Msk = 0xfff80000

	// CTRL: SCT control register
	// Position of DOWN_L field.
	SCT0_CTRL_DOWN_L_Pos = 0x0
	// Bit mask of DOWN_L field.
	SCT0_CTRL_DOWN_L_Msk = 0x1
	// Bit DOWN_L.
	SCT0_CTRL_DOWN_L = 0x1
	// Position of STOP_L field.
	SCT0_CTRL_STOP_L_Pos = 0x1
	// Bit mask of STOP_L field.
	SCT0_CTRL_STOP_L_Msk = 0x2
	// Bit STOP_L.
	SCT0_CTRL_STOP_L = 0x2
	// Position of HALT_L field.
	SCT0_CTRL_HALT_L_Pos = 0x2
	// Bit mask of HALT_L field.
	SCT0_CTRL_HALT_L_Msk = 0x4
	// Bit HALT_L.
	SCT0_CTRL_HALT_L = 0x4
	// Position of CLRCTR_L field.
	SCT0_CTRL_CLRCTR_L_Pos = 0x3
	// Bit mask of CLRCTR_L field.
	SCT0_CTRL_CLRCTR_L_Msk = 0x8
	// Bit CLRCTR_L.
	SCT0_CTRL_CLRCTR_L = 0x8
	// Position of BIDIR_L field.
	SCT0_CTRL_BIDIR_L_Pos = 0x4
	// Bit mask of BIDIR_L field.
	SCT0_CTRL_BIDIR_L_Msk = 0x10
	// Bit BIDIR_L.
	SCT0_CTRL_BIDIR_L = 0x10
	// Unidirectional. The counter counts up to its limit condition, then is cleared to zero.
	SCT0_CTRL_BIDIR_L_UNIDIRECTIONAL = 0x0
	// Bidirectional. The counter counts up to its limit, then counts down to a limit condition or to 0.
	SCT0_CTRL_BIDIR_L_BIDIRECTIONAL = 0x1
	// Position of PRE_L field.
	SCT0_CTRL_PRE_L_Pos = 0x5
	// Bit mask of PRE_L field.
	SCT0_CTRL_PRE_L_Msk = 0x1fe0
	// Position of RESERVED field.
	SCT0_CTRL_RESERVED_Pos = 0xd
	// Bit mask of RESERVED field.
	SCT0_CTRL_RESERVED_Msk = 0xe000
	// Position of DOWN_H field.
	SCT0_CTRL_DOWN_H_Pos = 0x10
	// Bit mask of DOWN_H field.
	SCT0_CTRL_DOWN_H_Msk = 0x10000
	// Bit DOWN_H.
	SCT0_CTRL_DOWN_H = 0x10000
	// Position of STOP_H field.
	SCT0_CTRL_STOP_H_Pos = 0x11
	// Bit mask of STOP_H field.
	SCT0_CTRL_STOP_H_Msk = 0x20000
	// Bit STOP_H.
	SCT0_CTRL_STOP_H = 0x20000
	// Position of HALT_H field.
	SCT0_CTRL_HALT_H_Pos = 0x12
	// Bit mask of HALT_H field.
	SCT0_CTRL_HALT_H_Msk = 0x40000
	// Bit HALT_H.
	SCT0_CTRL_HALT_H = 0x40000
	// Position of CLRCTR_H field.
	SCT0_CTRL_CLRCTR_H_Pos = 0x13
	// Bit mask of CLRCTR_H field.
	SCT0_CTRL_CLRCTR_H_Msk = 0x80000
	// Bit CLRCTR_H.
	SCT0_CTRL_CLRCTR_H = 0x80000
	// Position of BIDIR_H field.
	SCT0_CTRL_BIDIR_H_Pos = 0x14
	// Bit mask of BIDIR_H field.
	SCT0_CTRL_BIDIR_H_Msk = 0x100000
	// Bit BIDIR_H.
	SCT0_CTRL_BIDIR_H = 0x100000
	// Unidirectional. The H counter counts up to its limit condition, then is cleared to zero.
	SCT0_CTRL_BIDIR_H_UNIDIRECTIONAL = 0x0
	// Bidirectional. The H counter counts up to its limit, then counts down to a limit condition or to 0.
	SCT0_CTRL_BIDIR_H_BIDIRECTIONAL = 0x1
	// Position of PRE_H field.
	SCT0_CTRL_PRE_H_Pos = 0x15
	// Bit mask of PRE_H field.
	SCT0_CTRL_PRE_H_Msk = 0x1fe00000
	// Position of RESERVED field.
	SCT0_CTRL_RESERVED_Pos = 0x1d
	// Bit mask of RESERVED field.
	SCT0_CTRL_RESERVED_Msk = 0xe0000000

	// LIMIT: SCT limit register
	// Position of LIMMSK_L field.
	SCT0_LIMIT_LIMMSK_L_Pos = 0x0
	// Bit mask of LIMMSK_L field.
	SCT0_LIMIT_LIMMSK_L_Msk = 0xffff
	// Position of LIMMSK_H field.
	SCT0_LIMIT_LIMMSK_H_Pos = 0x10
	// Bit mask of LIMMSK_H field.
	SCT0_LIMIT_LIMMSK_H_Msk = 0xffff0000

	// HALT: SCT halt condition register
	// Position of HALTMSK_L field.
	SCT0_HALT_HALTMSK_L_Pos = 0x0
	// Bit mask of HALTMSK_L field.
	SCT0_HALT_HALTMSK_L_Msk = 0xffff
	// Position of HALTMSK_H field.
	SCT0_HALT_HALTMSK_H_Pos = 0x10
	// Bit mask of HALTMSK_H field.
	SCT0_HALT_HALTMSK_H_Msk = 0xffff0000

	// STOP: SCT stop condition register
	// Position of STOPMSK_L field.
	SCT0_STOP_STOPMSK_L_Pos = 0x0
	// Bit mask of STOPMSK_L field.
	SCT0_STOP_STOPMSK_L_Msk = 0xffff
	// Position of STOPMSK_H field.
	SCT0_STOP_STOPMSK_H_Pos = 0x10
	// Bit mask of STOPMSK_H field.
	SCT0_STOP_STOPMSK_H_Msk = 0xffff0000

	// START: SCT start condition register
	// Position of STARTMSK_L field.
	SCT0_START_STARTMSK_L_Pos = 0x0
	// Bit mask of STARTMSK_L field.
	SCT0_START_STARTMSK_L_Msk = 0xffff
	// Position of STARTMSK_H field.
	SCT0_START_STARTMSK_H_Pos = 0x10
	// Bit mask of STARTMSK_H field.
	SCT0_START_STARTMSK_H_Msk = 0xffff0000

	// COUNT: SCT counter register
	// Position of CTR_L field.
	SCT0_COUNT_CTR_L_Pos = 0x0
	// Bit mask of CTR_L field.
	SCT0_COUNT_CTR_L_Msk = 0xffff
	// Position of CTR_H field.
	SCT0_COUNT_CTR_H_Pos = 0x10
	// Bit mask of CTR_H field.
	SCT0_COUNT_CTR_H_Msk = 0xffff0000

	// STATE: SCT state register
	// Position of STATE_L field.
	SCT0_STATE_STATE_L_Pos = 0x0
	// Bit mask of STATE_L field.
	SCT0_STATE_STATE_L_Msk = 0x1f
	// Position of RESERVED field.
	SCT0_STATE_RESERVED_Pos = 0x5
	// Bit mask of RESERVED field.
	SCT0_STATE_RESERVED_Msk = 0xffe0
	// Position of STATE_H field.
	SCT0_STATE_STATE_H_Pos = 0x10
	// Bit mask of STATE_H field.
	SCT0_STATE_STATE_H_Msk = 0x1f0000
	// Position of RESERVED field.
	SCT0_STATE_RESERVED_Pos = 0x15
	// Bit mask of RESERVED field.
	SCT0_STATE_RESERVED_Msk = 0xffe00000

	// INPUT: SCT input register
	// Position of AIN0 field.
	SCT0_INPUT_AIN0_Pos = 0x0
	// Bit mask of AIN0 field.
	SCT0_INPUT_AIN0_Msk = 0x1
	// Bit AIN0.
	SCT0_INPUT_AIN0 = 0x1
	// Position of AIN1 field.
	SCT0_INPUT_AIN1_Pos = 0x1
	// Bit mask of AIN1 field.
	SCT0_INPUT_AIN1_Msk = 0x2
	// Bit AIN1.
	SCT0_INPUT_AIN1 = 0x2
	// Position of AIN2 field.
	SCT0_INPUT_AIN2_Pos = 0x2
	// Bit mask of AIN2 field.
	SCT0_INPUT_AIN2_Msk = 0x4
	// Bit AIN2.
	SCT0_INPUT_AIN2 = 0x4
	// Position of AIN3 field.
	SCT0_INPUT_AIN3_Pos = 0x3
	// Bit mask of AIN3 field.
	SCT0_INPUT_AIN3_Msk = 0x8
	// Bit AIN3.
	SCT0_INPUT_AIN3 = 0x8
	// Position of AIN4 field.
	SCT0_INPUT_AIN4_Pos = 0x4
	// Bit mask of AIN4 field.
	SCT0_INPUT_AIN4_Msk = 0x10
	// Bit AIN4.
	SCT0_INPUT_AIN4 = 0x10
	// Position of AIN5 field.
	SCT0_INPUT_AIN5_Pos = 0x5
	// Bit mask of AIN5 field.
	SCT0_INPUT_AIN5_Msk = 0x20
	// Bit AIN5.
	SCT0_INPUT_AIN5 = 0x20
	// Position of RESERVED field.
	SCT0_INPUT_RESERVED_Pos = 0x6
	// Bit mask of RESERVED field.
	SCT0_INPUT_RESERVED_Msk = 0xffc0
	// Position of SIN0 field.
	SCT0_INPUT_SIN0_Pos = 0x10
	// Bit mask of SIN0 field.
	SCT0_INPUT_SIN0_Msk = 0x10000
	// Bit SIN0.
	SCT0_INPUT_SIN0 = 0x10000
	// Position of SIN1 field.
	SCT0_INPUT_SIN1_Pos = 0x11
	// Bit mask of SIN1 field.
	SCT0_INPUT_SIN1_Msk = 0x20000
	// Bit SIN1.
	SCT0_INPUT_SIN1 = 0x20000
	// Position of SIN2 field.
	SCT0_INPUT_SIN2_Pos = 0x12
	// Bit mask of SIN2 field.
	SCT0_INPUT_SIN2_Msk = 0x40000
	// Bit SIN2.
	SCT0_INPUT_SIN2 = 0x40000
	// Position of SIN3 field.
	SCT0_INPUT_SIN3_Pos = 0x13
	// Bit mask of SIN3 field.
	SCT0_INPUT_SIN3_Msk = 0x80000
	// Bit SIN3.
	SCT0_INPUT_SIN3 = 0x80000
	// Position of SIN4 field.
	SCT0_INPUT_SIN4_Pos = 0x14
	// Bit mask of SIN4 field.
	SCT0_INPUT_SIN4_Msk = 0x100000
	// Bit SIN4.
	SCT0_INPUT_SIN4 = 0x100000
	// Position of SIN5 field.
	SCT0_INPUT_SIN5_Pos = 0x15
	// Bit mask of SIN5 field.
	SCT0_INPUT_SIN5_Msk = 0x200000
	// Bit SIN5.
	SCT0_INPUT_SIN5 = 0x200000
	// Position of RESERVED field.
	SCT0_INPUT_RESERVED_Pos = 0x16
	// Bit mask of RESERVED field.
	SCT0_INPUT_RESERVED_Msk = 0xffc00000

	// REGMODE: SCT match/capture registers mode register
	// Position of REGMOD_L field.
	SCT0_REGMODE_REGMOD_L_Pos = 0x0
	// Bit mask of REGMOD_L field.
	SCT0_REGMODE_REGMOD_L_Msk = 0xffff
	// Position of REGMOD_H field.
	SCT0_REGMODE_REGMOD_H_Pos = 0x10
	// Bit mask of REGMOD_H field.
	SCT0_REGMODE_REGMOD_H_Msk = 0xffff0000

	// OUTPUT: SCT output register
	// Position of OUT field.
	SCT0_OUTPUT_OUT_Pos = 0x0
	// Bit mask of OUT field.
	SCT0_OUTPUT_OUT_Msk = 0xff
	// Position of RESERVED field.
	SCT0_OUTPUT_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	SCT0_OUTPUT_RESERVED_Msk = 0xffffff00

	// OUTPUTDIRCTRL: SCT output counter direction control register
	// Position of SETCLR0 field.
	SCT0_OUTPUTDIRCTRL_SETCLR0_Pos = 0x0
	// Bit mask of SETCLR0 field.
	SCT0_OUTPUTDIRCTRL_SETCLR0_Msk = 0x3
	// Independent. Set and clear do not depend on any counter.
	SCT0_OUTPUTDIRCTRL_SETCLR0_INDEPENDENT = 0x0
	// L-Reversed. Set and clear are reversed when counter L or the unified counter is counting down.
	SCT0_OUTPUTDIRCTRL_SETCLR0_L_REVERSED = 0x1
	// H-Reversed. Set and clear are reversed when counter H is counting down. Do not use if UNIFY = 1.
	SCT0_OUTPUTDIRCTRL_SETCLR0_H_REVERSED = 0x2
	// Position of SETCLR1 field.
	SCT0_OUTPUTDIRCTRL_SETCLR1_Pos = 0x2
	// Bit mask of SETCLR1 field.
	SCT0_OUTPUTDIRCTRL_SETCLR1_Msk = 0xc
	// Position of SETCLR2 field.
	SCT0_OUTPUTDIRCTRL_SETCLR2_Pos = 0x4
	// Bit mask of SETCLR2 field.
	SCT0_OUTPUTDIRCTRL_SETCLR2_Msk = 0x30
	// Position of SETCLR3 field.
	SCT0_OUTPUTDIRCTRL_SETCLR3_Pos = 0x6
	// Bit mask of SETCLR3 field.
	SCT0_OUTPUTDIRCTRL_SETCLR3_Msk = 0xc0
	// Position of SETCLR4 field.
	SCT0_OUTPUTDIRCTRL_SETCLR4_Pos = 0x8
	// Bit mask of SETCLR4 field.
	SCT0_OUTPUTDIRCTRL_SETCLR4_Msk = 0x300
	// Position of SETCLR5 field.
	SCT0_OUTPUTDIRCTRL_SETCLR5_Pos = 0xa
	// Bit mask of SETCLR5 field.
	SCT0_OUTPUTDIRCTRL_SETCLR5_Msk = 0xc00
	// Position of SETCLR6 field.
	SCT0_OUTPUTDIRCTRL_SETCLR6_Pos = 0xc
	// Bit mask of SETCLR6 field.
	SCT0_OUTPUTDIRCTRL_SETCLR6_Msk = 0x3000
	// Position of SETCLR7 field.
	SCT0_OUTPUTDIRCTRL_SETCLR7_Pos = 0xe
	// Bit mask of SETCLR7 field.
	SCT0_OUTPUTDIRCTRL_SETCLR7_Msk = 0xc000
	// Position of RESERVED field.
	SCT0_OUTPUTDIRCTRL_RESERVED_Pos = 0x1a
	// Bit mask of RESERVED field.
	SCT0_OUTPUTDIRCTRL_RESERVED_Msk = 0xfc000000

	// RES: SCT conflict resolution register
	// Position of O0RES field.
	SCT0_RES_O0RES_Pos = 0x0
	// Bit mask of O0RES field.
	SCT0_RES_O0RES_Msk = 0x3
	// No change.
	SCT0_RES_O0RES_NO_CHANGE = 0x0
	// Set. Set output (or clear based on the SETCLR0 field).
	SCT0_RES_O0RES_SET = 0x1
	// Clear. Clear output (or set based on the SETCLR0 field).
	SCT0_RES_O0RES_CLEAR = 0x2
	// Toggle output.
	SCT0_RES_O0RES_TOGGLE_OUTPUT = 0x3
	// Position of O1RES field.
	SCT0_RES_O1RES_Pos = 0x2
	// Bit mask of O1RES field.
	SCT0_RES_O1RES_Msk = 0xc
	// No change.
	SCT0_RES_O1RES_NO_CHANGE = 0x0
	// Set. Set output (or clear based on the SETCLR1 field).
	SCT0_RES_O1RES_SET = 0x1
	// Clear. Clear output (or set based on the SETCLR1 field).
	SCT0_RES_O1RES_CLEAR = 0x2
	// Toggle output.
	SCT0_RES_O1RES_TOGGLE_OUTPUT = 0x3
	// Position of O2RES field.
	SCT0_RES_O2RES_Pos = 0x4
	// Bit mask of O2RES field.
	SCT0_RES_O2RES_Msk = 0x30
	// No change.
	SCT0_RES_O2RES_NO_CHANGE = 0x0
	// Set. Set output (or clear based on the SETCLR2 field).
	SCT0_RES_O2RES_SET = 0x1
	// Clear. Clear output (or set based on the SETCLR2 field).
	SCT0_RES_O2RES_CLEAR = 0x2
	// Toggle output.
	SCT0_RES_O2RES_TOGGLE_OUTPUT = 0x3
	// Position of O3RES field.
	SCT0_RES_O3RES_Pos = 0x6
	// Bit mask of O3RES field.
	SCT0_RES_O3RES_Msk = 0xc0
	// No change.
	SCT0_RES_O3RES_NO_CHANGE = 0x0
	// Set. Set output (or clear based on the SETCLR3 field).
	SCT0_RES_O3RES_SET = 0x1
	// Clear. Clear output (or set based on the SETCLR3 field).
	SCT0_RES_O3RES_CLEAR = 0x2
	// Toggle output.
	SCT0_RES_O3RES_TOGGLE_OUTPUT = 0x3
	// Position of O4RES field.
	SCT0_RES_O4RES_Pos = 0x8
	// Bit mask of O4RES field.
	SCT0_RES_O4RES_Msk = 0x300
	// No change.
	SCT0_RES_O4RES_NO_CHANGE = 0x0
	// Set. Set output (or clear based on the SETCLR4 field).
	SCT0_RES_O4RES_SET = 0x1
	// Clear. Clear output (or set based on the SETCLR4 field).
	SCT0_RES_O4RES_CLEAR = 0x2
	// Toggle output.
	SCT0_RES_O4RES_TOGGLE_OUTPUT = 0x3
	// Position of O5RES field.
	SCT0_RES_O5RES_Pos = 0xa
	// Bit mask of O5RES field.
	SCT0_RES_O5RES_Msk = 0xc00
	// No change.
	SCT0_RES_O5RES_NO_CHANGE = 0x0
	// Set. Set output (or clear based on the SETCLR5 field).
	SCT0_RES_O5RES_SET = 0x1
	// Clear. Clear output (or set based on the SETCLR5 field).
	SCT0_RES_O5RES_CLEAR = 0x2
	// Toggle output.
	SCT0_RES_O5RES_TOGGLE_OUTPUT = 0x3
	// Position of O6RES field.
	SCT0_RES_O6RES_Pos = 0xc
	// Bit mask of O6RES field.
	SCT0_RES_O6RES_Msk = 0x3000
	// No change.
	SCT0_RES_O6RES_NO_CHANGE = 0x0
	// Set. Set output (or clear based on the SETCLR6 field).
	SCT0_RES_O6RES_SET = 0x1
	// Clear. Clear output (or set based on the SETCLR6 field).
	SCT0_RES_O6RES_CLEAR = 0x2
	// Toggle output.
	SCT0_RES_O6RES_TOGGLE_OUTPUT = 0x3
	// Position of O7RES field.
	SCT0_RES_O7RES_Pos = 0xe
	// Bit mask of O7RES field.
	SCT0_RES_O7RES_Msk = 0xc000
	// No change.
	SCT0_RES_O7RES_NO_CHANGE = 0x0
	// Set. Set output (or clear based on the SETCLR7 field).
	SCT0_RES_O7RES_SET = 0x1
	// Clear. Clear output (or set based on the SETCLR7 field).
	SCT0_RES_O7RES_CLEAR = 0x2
	// Toggle output.
	SCT0_RES_O7RES_TOGGLE_OUTPUT = 0x3
	// Position of RESERVED field.
	SCT0_RES_RESERVED_Pos = 0x10
	// Bit mask of RESERVED field.
	SCT0_RES_RESERVED_Msk = 0xffff0000

	// DMAREQ0: SCT DMA request 0 register
	// Position of DEV_0 field.
	SCT0_DMAREQ0_DEV_0_Pos = 0x0
	// Bit mask of DEV_0 field.
	SCT0_DMAREQ0_DEV_0_Msk = 0xffff
	// Position of RESERVED field.
	SCT0_DMAREQ0_RESERVED_Pos = 0x10
	// Bit mask of RESERVED field.
	SCT0_DMAREQ0_RESERVED_Msk = 0x3fff0000
	// Position of DRL0 field.
	SCT0_DMAREQ0_DRL0_Pos = 0x1e
	// Bit mask of DRL0 field.
	SCT0_DMAREQ0_DRL0_Msk = 0x40000000
	// Bit DRL0.
	SCT0_DMAREQ0_DRL0 = 0x40000000
	// Position of DRQ0 field.
	SCT0_DMAREQ0_DRQ0_Pos = 0x1f
	// Bit mask of DRQ0 field.
	SCT0_DMAREQ0_DRQ0_Msk = 0x80000000
	// Bit DRQ0.
	SCT0_DMAREQ0_DRQ0 = 0x80000000

	// DMAREQ1: SCT DMA request 1 register
	// Position of DEV_1 field.
	SCT0_DMAREQ1_DEV_1_Pos = 0x0
	// Bit mask of DEV_1 field.
	SCT0_DMAREQ1_DEV_1_Msk = 0xffff
	// Position of RESERVED field.
	SCT0_DMAREQ1_RESERVED_Pos = 0x10
	// Bit mask of RESERVED field.
	SCT0_DMAREQ1_RESERVED_Msk = 0x3fff0000
	// Position of DRL1 field.
	SCT0_DMAREQ1_DRL1_Pos = 0x1e
	// Bit mask of DRL1 field.
	SCT0_DMAREQ1_DRL1_Msk = 0x40000000
	// Bit DRL1.
	SCT0_DMAREQ1_DRL1 = 0x40000000
	// Position of DRQ1 field.
	SCT0_DMAREQ1_DRQ1_Pos = 0x1f
	// Bit mask of DRQ1 field.
	SCT0_DMAREQ1_DRQ1_Msk = 0x80000000
	// Bit DRQ1.
	SCT0_DMAREQ1_DRQ1 = 0x80000000

	// EVEN: SCT event enable register
	// Position of IEN field.
	SCT0_EVEN_IEN_Pos = 0x0
	// Bit mask of IEN field.
	SCT0_EVEN_IEN_Msk = 0xffff
	// Position of RESERVED field.
	SCT0_EVEN_RESERVED_Pos = 0x10
	// Bit mask of RESERVED field.
	SCT0_EVEN_RESERVED_Msk = 0xffff0000

	// EVFLAG: SCT event flag register
	// Position of FLAG field.
	SCT0_EVFLAG_FLAG_Pos = 0x0
	// Bit mask of FLAG field.
	SCT0_EVFLAG_FLAG_Msk = 0xffff
	// Position of RESERVED field.
	SCT0_EVFLAG_RESERVED_Pos = 0x10
	// Bit mask of RESERVED field.
	SCT0_EVFLAG_RESERVED_Msk = 0xffff0000

	// CONEN: SCT conflict enable register
	// Position of NCEN field.
	SCT0_CONEN_NCEN_Pos = 0x0
	// Bit mask of NCEN field.
	SCT0_CONEN_NCEN_Msk = 0xff
	// Position of RESERVED field.
	SCT0_CONEN_RESERVED_Pos = 0xa
	// Bit mask of RESERVED field.
	SCT0_CONEN_RESERVED_Msk = 0xfffffc00

	// CONFLAG: SCT conflict flag register
	// Position of NCFLAG field.
	SCT0_CONFLAG_NCFLAG_Pos = 0x0
	// Bit mask of NCFLAG field.
	SCT0_CONFLAG_NCFLAG_Msk = 0xff
	// Position of RESERVED field.
	SCT0_CONFLAG_RESERVED_Pos = 0xa
	// Bit mask of RESERVED field.
	SCT0_CONFLAG_RESERVED_Msk = 0x3ffffc00
	// Position of BUSERRL field.
	SCT0_CONFLAG_BUSERRL_Pos = 0x1e
	// Bit mask of BUSERRL field.
	SCT0_CONFLAG_BUSERRL_Msk = 0x40000000
	// Bit BUSERRL.
	SCT0_CONFLAG_BUSERRL = 0x40000000
	// Position of BUSERRH field.
	SCT0_CONFLAG_BUSERRH_Pos = 0x1f
	// Bit mask of BUSERRH field.
	SCT0_CONFLAG_BUSERRH_Msk = 0x80000000
	// Bit BUSERRH.
	SCT0_CONFLAG_BUSERRH = 0x80000000

	// MATCH0: SCT match value register of match channels 0 to 12; REGMOD0 to REGMODE12 = 0
	// Position of MATCHn_L field.
	SCT0_MATCH_MATCHn_L_Pos = 0x0
	// Bit mask of MATCHn_L field.
	SCT0_MATCH_MATCHn_L_Msk = 0xffff
	// Position of MATCHn_H field.
	SCT0_MATCH_MATCHn_H_Pos = 0x10
	// Bit mask of MATCHn_H field.
	SCT0_MATCH_MATCHn_H_Msk = 0xffff0000

	// CAP0: SCT capture register of capture channel 0 to 12; REGMOD0 to REGMODE12 = 1
	// Position of CAPn_L field.
	SCT0_CAP_CAPn_L_Pos = 0x0
	// Bit mask of CAPn_L field.
	SCT0_CAP_CAPn_L_Msk = 0xffff
	// Position of CAPn_H field.
	SCT0_CAP_CAPn_H_Pos = 0x10
	// Bit mask of CAPn_H field.
	SCT0_CAP_CAPn_H_Msk = 0xffff0000

	// MATCHREL0: SCT match reload value register 0 to 12; REGMOD0 = 0 to REGMODE12 = 0
	// Position of RELOADn_L field.
	SCT0_MATCHREL_RELOADn_L_Pos = 0x0
	// Bit mask of RELOADn_L field.
	SCT0_MATCHREL_RELOADn_L_Msk = 0xffff
	// Position of RELOADn_H field.
	SCT0_MATCHREL_RELOADn_H_Pos = 0x10
	// Bit mask of RELOADn_H field.
	SCT0_MATCHREL_RELOADn_H_Msk = 0xffff0000

	// CAPCTRL0: SCT capture control register 0 to 12; REGMOD0 = 1 to REGMODE12 = 1
	// Position of CAPCONn_L field.
	SCT0_CAPCTRL_CAPCONn_L_Pos = 0x0
	// Bit mask of CAPCONn_L field.
	SCT0_CAPCTRL_CAPCONn_L_Msk = 0xffff
	// Position of CAPCONn_H field.
	SCT0_CAPCTRL_CAPCONn_H_Pos = 0x10
	// Bit mask of CAPCONn_H field.
	SCT0_CAPCTRL_CAPCONn_H_Msk = 0xffff0000

	// EV0_STATE: SCT event state register 0
	// Position of STATEMSKn field.
	SCT0_EV_STATE_STATEMSKn_Pos = 0x0
	// Bit mask of STATEMSKn field.
	SCT0_EV_STATE_STATEMSKn_Msk = 0x1fff

	// EV0_CTRL: SCT event control register 0
	// Position of MATCHSEL field.
	SCT0_EV_CTRL_MATCHSEL_Pos = 0x0
	// Bit mask of MATCHSEL field.
	SCT0_EV_CTRL_MATCHSEL_Msk = 0xf
	// Position of HEVENT field.
	SCT0_EV_CTRL_HEVENT_Pos = 0x4
	// Bit mask of HEVENT field.
	SCT0_EV_CTRL_HEVENT_Msk = 0x10
	// Bit HEVENT.
	SCT0_EV_CTRL_HEVENT = 0x10
	// L counter. Selects the L state and the L match register selected by MATCHSEL.
	SCT0_EV_CTRL_HEVENT_L_COUNTER = 0x0
	// H counter. Selects the H state and the H match register selected by MATCHSEL.
	SCT0_EV_CTRL_HEVENT_H_COUNTER = 0x1
	// Position of OUTSEL field.
	SCT0_EV_CTRL_OUTSEL_Pos = 0x5
	// Bit mask of OUTSEL field.
	SCT0_EV_CTRL_OUTSEL_Msk = 0x20
	// Bit OUTSEL.
	SCT0_EV_CTRL_OUTSEL = 0x20
	// Input. Selects the input selected by IOSEL.
	SCT0_EV_CTRL_OUTSEL_INPUT = 0x0
	// Output. Selects the output selected by IOSEL.
	SCT0_EV_CTRL_OUTSEL_OUTPUT = 0x1
	// Position of IOSEL field.
	SCT0_EV_CTRL_IOSEL_Pos = 0x6
	// Bit mask of IOSEL field.
	SCT0_EV_CTRL_IOSEL_Msk = 0x3c0
	// Position of IOCOND field.
	SCT0_EV_CTRL_IOCOND_Pos = 0xa
	// Bit mask of IOCOND field.
	SCT0_EV_CTRL_IOCOND_Msk = 0xc00
	// LOW
	SCT0_EV_CTRL_IOCOND_LOW = 0x0
	// Rise
	SCT0_EV_CTRL_IOCOND_RISE = 0x1
	// Fall
	SCT0_EV_CTRL_IOCOND_FALL = 0x2
	// HIGH
	SCT0_EV_CTRL_IOCOND_HIGH = 0x3
	// Position of COMBMODE field.
	SCT0_EV_CTRL_COMBMODE_Pos = 0xc
	// Bit mask of COMBMODE field.
	SCT0_EV_CTRL_COMBMODE_Msk = 0x3000
	// OR. The event occurs when either the specified match or I/O condition occurs.
	SCT0_EV_CTRL_COMBMODE_OR = 0x0
	// MATCH. Uses the specified match only.
	SCT0_EV_CTRL_COMBMODE_MATCH = 0x1
	// IO. Uses the specified I/O condition only.
	SCT0_EV_CTRL_COMBMODE_IO = 0x2
	// AND. The event occurs when the specified match and I/O condition occur simultaneously.
	SCT0_EV_CTRL_COMBMODE_AND = 0x3
	// Position of STATELD field.
	SCT0_EV_CTRL_STATELD_Pos = 0xe
	// Bit mask of STATELD field.
	SCT0_EV_CTRL_STATELD_Msk = 0x4000
	// Bit STATELD.
	SCT0_EV_CTRL_STATELD = 0x4000
	// Add. STATEV value is added into STATE (the carry-out is ignored).
	SCT0_EV_CTRL_STATELD_ADD = 0x0
	// Load. STATEV value is loaded into STATE.
	SCT0_EV_CTRL_STATELD_LOAD = 0x1
	// Position of STATEV field.
	SCT0_EV_CTRL_STATEV_Pos = 0xf
	// Bit mask of STATEV field.
	SCT0_EV_CTRL_STATEV_Msk = 0xf8000
	// Position of MATCHMEM field.
	SCT0_EV_CTRL_MATCHMEM_Pos = 0x14
	// Bit mask of MATCHMEM field.
	SCT0_EV_CTRL_MATCHMEM_Msk = 0x100000
	// Bit MATCHMEM.
	SCT0_EV_CTRL_MATCHMEM = 0x100000
	// Position of DIRECTION field.
	SCT0_EV_CTRL_DIRECTION_Pos = 0x15
	// Bit mask of DIRECTION field.
	SCT0_EV_CTRL_DIRECTION_Msk = 0x600000
	// Direction independent. This event is triggered regardless of the count direction.
	SCT0_EV_CTRL_DIRECTION_DIRECTION_INDEPENDEN = 0x0
	// Counting up. This event is triggered only during up-counting when BIDIR = 1.
	SCT0_EV_CTRL_DIRECTION_COUNTING_UP = 0x1
	// Counting down. This event is triggered only during down-counting when BIDIR = 1.
	SCT0_EV_CTRL_DIRECTION_COUNTING_DOWN = 0x2
	// Position of RESERVED field.
	SCT0_EV_CTRL_RESERVED_Pos = 0x17
	// Bit mask of RESERVED field.
	SCT0_EV_CTRL_RESERVED_Msk = 0xff800000

	// OUT0_SET: SCT output 0 set register
	// Position of SET field.
	SCT0_OUT_SET_SET_Pos = 0x0
	// Bit mask of SET field.
	SCT0_OUT_SET_SET_Msk = 0xffff
	// Position of RESERVED field.
	SCT0_OUT_SET_RESERVED_Pos = 0x10
	// Bit mask of RESERVED field.
	SCT0_OUT_SET_RESERVED_Msk = 0xffff0000

	// OUT0_CLR: SCT output 0 clear register
	// Position of CLR field.
	SCT0_OUT_CLR_CLR_Pos = 0x0
	// Bit mask of CLR field.
	SCT0_OUT_CLR_CLR_Msk = 0xffff
	// Position of RESERVED field.
	SCT0_OUT_CLR_RESERVED_Pos = 0x10
	// Bit mask of RESERVED field.
	SCT0_OUT_CLR_RESERVED_Msk = 0xffff0000
)

// Bitfields for MAILBOX: Mailbox
const (
	// IRQ0: Interrupt request register for the Cortex-M0+ CPU.
	// Position of INTREQ field.
	MAILBOX_IRQ0_INTREQ_Pos = 0x0
	// Bit mask of INTREQ field.
	MAILBOX_IRQ0_INTREQ_Msk = 0xffffffff

	// IRQ0SET: Set bits in IRQ0
	// Position of INTREQSET field.
	MAILBOX_IRQ0SET_INTREQSET_Pos = 0x0
	// Bit mask of INTREQSET field.
	MAILBOX_IRQ0SET_INTREQSET_Msk = 0xffffffff

	// IRQ0CLR: Clear bits in IRQ0
	// Position of INTREQCLR field.
	MAILBOX_IRQ0CLR_INTREQCLR_Pos = 0x0
	// Bit mask of INTREQCLR field.
	MAILBOX_IRQ0CLR_INTREQCLR_Msk = 0xffffffff

	// IRQ1: Interrupt request register for the Cortex M4 CPU.
	// Position of INTREQ field.
	MAILBOX_IRQ1_INTREQ_Pos = 0x0
	// Bit mask of INTREQ field.
	MAILBOX_IRQ1_INTREQ_Msk = 0xffffffff

	// IRQ1SET: Set bits in IRQ1
	// Position of INTREQSET field.
	MAILBOX_IRQ1SET_INTREQSET_Pos = 0x0
	// Bit mask of INTREQSET field.
	MAILBOX_IRQ1SET_INTREQSET_Msk = 0xffffffff

	// IRQ1CLR: Clear bits in IRQ1
	// Position of INTREQCLR field.
	MAILBOX_IRQ1CLR_INTREQCLR_Pos = 0x0
	// Bit mask of INTREQCLR field.
	MAILBOX_IRQ1CLR_INTREQCLR_Msk = 0xffffffff

	// MUTEX: Mutual exclusion register
	// Position of EX field.
	MAILBOX_MUTEX_EX_Pos = 0x0
	// Bit mask of EX field.
	MAILBOX_MUTEX_EX_Msk = 0x1
	// Bit EX.
	MAILBOX_MUTEX_EX = 0x1
	// Position of RESERVED field.
	MAILBOX_MUTEX_RESERVED_Pos = 0x1
	// Bit mask of RESERVED field.
	MAILBOX_MUTEX_RESERVED_Msk = 0xfffffffe
)

// Bitfields for ADC0: 12-bit ADC controller 0
const (
	// CTRL: ADC Control Register. Contains the clock divide value, enable bits for each sequence and the ADC power-down bit.
	// Position of CLKDIV field.
	ADC0_CTRL_CLKDIV_Pos = 0x0
	// Bit mask of CLKDIV field.
	ADC0_CTRL_CLKDIV_Msk = 0xff
	// Position of ASYNMODE field.
	ADC0_CTRL_ASYNMODE_Pos = 0x8
	// Bit mask of ASYNMODE field.
	ADC0_CTRL_ASYNMODE_Msk = 0x100
	// Bit ASYNMODE.
	ADC0_CTRL_ASYNMODE = 0x100
	// Synchronous mode. The ADC clock is derived from the system clock based on the divide value selected in the CLKDIV field. The ADC clock will be started in a controlled fashion in response to a trigger to eliminate any uncertainty in the launching of an ADC conversion in response to any synchronous (on-chip) trigger. In Synchronous mode with the SYNCBYPASS bit (in a sequence control register) set, sampling of the ADC input and start of conversion will initiate 2 system clocks after the leading edge of a (synchronous) trigger pulse.
	ADC0_CTRL_ASYNMODE_SYNCHRONOUS_MODE = 0x0
	// Asynchronous mode. The ADC clock is based on the output of the ADC clock divider ADCCLKSEL in the SYSCON block.
	ADC0_CTRL_ASYNMODE_ASYNCHRONOUS_MODE = 0x1
	// Position of RESOL field.
	ADC0_CTRL_RESOL_Pos = 0x9
	// Bit mask of RESOL field.
	ADC0_CTRL_RESOL_Msk = 0x600
	// 6-bit resolution. An ADC conversion requires 9 ADC clocks, plus any clocks specified by the TSAMP field.
	ADC0_CTRL_RESOL_6_BIT_RESOLUTION = 0x0
	// 8-bit resolution. An ADC conversion requires 11 ADC clocks, plus any clocks specified by the TSAMP field.
	ADC0_CTRL_RESOL_8_BIT_RESOLUTION = 0x1
	// 10-bit resolution. An ADC conversion requires 13 ADC clocks, plus any clocks specified by the TSAMP field.
	ADC0_CTRL_RESOL_10_BIT_RESOLUTION = 0x2
	// 12-bit resolution. An ADC conversion requires 15 ADC clocks, plus any clocks specified by the TSAMP field.
	ADC0_CTRL_RESOL_12_BIT_RESOLUTION = 0x3
	// Position of BYPASSCAL field.
	ADC0_CTRL_BYPASSCAL_Pos = 0xb
	// Bit mask of BYPASSCAL field.
	ADC0_CTRL_BYPASSCAL_Msk = 0x800
	// Bit BYPASSCAL.
	ADC0_CTRL_BYPASSCAL = 0x800
	// Calibrate. The stored calibration value will be applied to the ADC during conversions to compensated for offset error. A calibration cycle must be performed each time the chip is powered-up. Re-calibration may be warranted periodically - especially if operating conditions have changed.
	ADC0_CTRL_BYPASSCAL_CALIBRATE = 0x0
	// Bypass calibration. Calibration is not utilized. Less time is required when enabling the ADC - particularly following chip power-up. Attempts to launch a calibration cycle are blocked when this bit is set.
	ADC0_CTRL_BYPASSCAL_BYPASS_CALIBRATION = 0x1
	// Position of TSAMP field.
	ADC0_CTRL_TSAMP_Pos = 0xc
	// Bit mask of TSAMP field.
	ADC0_CTRL_TSAMP_Msk = 0x7000

	// SEQA_CTRL: ADC Conversion Sequence-A control Register: Controls triggering and channel selection for conversion sequence-A. Also specifies interrupt mode for sequence-A.
	// Position of CHANNELS field.
	ADC0_SEQA_CTRL_CHANNELS_Pos = 0x0
	// Bit mask of CHANNELS field.
	ADC0_SEQA_CTRL_CHANNELS_Msk = 0xfff
	// Position of TRIGGER field.
	ADC0_SEQA_CTRL_TRIGGER_Pos = 0xc
	// Bit mask of TRIGGER field.
	ADC0_SEQA_CTRL_TRIGGER_Msk = 0x3f000
	// Position of TRIGPOL field.
	ADC0_SEQA_CTRL_TRIGPOL_Pos = 0x12
	// Bit mask of TRIGPOL field.
	ADC0_SEQA_CTRL_TRIGPOL_Msk = 0x40000
	// Bit TRIGPOL.
	ADC0_SEQA_CTRL_TRIGPOL = 0x40000
	// Negative edge. A negative edge launches the conversion sequence on the selected trigger input.
	ADC0_SEQA_CTRL_TRIGPOL_NEGATIVE_EDGE = 0x0
	// Positive edge. A positive edge launches the conversion sequence on the selected trigger input.
	ADC0_SEQA_CTRL_TRIGPOL_POSITIVE_EDGE = 0x1
	// Position of SYNCBYPASS field.
	ADC0_SEQA_CTRL_SYNCBYPASS_Pos = 0x13
	// Bit mask of SYNCBYPASS field.
	ADC0_SEQA_CTRL_SYNCBYPASS_Msk = 0x80000
	// Bit SYNCBYPASS.
	ADC0_SEQA_CTRL_SYNCBYPASS = 0x80000
	// Enable trigger synchronization. The hardware trigger bypass is not enabled.
	ADC0_SEQA_CTRL_SYNCBYPASS_ENABLE_TRIGGER_SYNCH = 0x0
	// Bypass trigger synchronization. The hardware trigger bypass is enabled.
	ADC0_SEQA_CTRL_SYNCBYPASS_BYPASS_TRIGGER_SYNCH = 0x1
	// Position of RESERVED field.
	ADC0_SEQA_CTRL_RESERVED_Pos = 0x14
	// Bit mask of RESERVED field.
	ADC0_SEQA_CTRL_RESERVED_Msk = 0x3f00000
	// Position of START field.
	ADC0_SEQA_CTRL_START_Pos = 0x1a
	// Bit mask of START field.
	ADC0_SEQA_CTRL_START_Msk = 0x4000000
	// Bit START.
	ADC0_SEQA_CTRL_START = 0x4000000
	// Position of BURST field.
	ADC0_SEQA_CTRL_BURST_Pos = 0x1b
	// Bit mask of BURST field.
	ADC0_SEQA_CTRL_BURST_Msk = 0x8000000
	// Bit BURST.
	ADC0_SEQA_CTRL_BURST = 0x8000000
	// Position of SINGLESTEP field.
	ADC0_SEQA_CTRL_SINGLESTEP_Pos = 0x1c
	// Bit mask of SINGLESTEP field.
	ADC0_SEQA_CTRL_SINGLESTEP_Msk = 0x10000000
	// Bit SINGLESTEP.
	ADC0_SEQA_CTRL_SINGLESTEP = 0x10000000
	// Position of LOWPRIO field.
	ADC0_SEQA_CTRL_LOWPRIO_Pos = 0x1d
	// Bit mask of LOWPRIO field.
	ADC0_SEQA_CTRL_LOWPRIO_Msk = 0x20000000
	// Bit LOWPRIO.
	ADC0_SEQA_CTRL_LOWPRIO = 0x20000000
	// Low priority. Any B trigger which occurs while an A conversion sequence is active will be ignored and lost.
	ADC0_SEQA_CTRL_LOWPRIO_LOW_PRIORITY = 0x0
	// High priority. Setting this bit to a 1 will permit any enabled B sequence trigger (including a B sequence software start) to immediately interrupt sequence A and launch a B sequence in its place. The conversion currently in progress will be terminated. The A sequence that was interrupted will automatically resume after the B sequence completes. The channel whose conversion was terminated will be re-sampled and the conversion sequence will resume from that point.
	ADC0_SEQA_CTRL_LOWPRIO_HIGH_PRIORITY = 0x1
	// Position of MODE field.
	ADC0_SEQA_CTRL_MODE_Pos = 0x1e
	// Bit mask of MODE field.
	ADC0_SEQA_CTRL_MODE_Msk = 0x40000000
	// Bit MODE.
	ADC0_SEQA_CTRL_MODE = 0x40000000
	// End of conversion. The sequence A interrupt/DMA trigger will be set at the end of each individual ADC conversion performed under sequence A. This flag will mirror the DATAVALID bit in the SEQA_GDAT register. The OVERRUN bit in the SEQA_GDAT register will contribute to generation of an overrun interrupt/DMA trigger if enabled.
	ADC0_SEQA_CTRL_MODE_END_OF_CONVERSION = 0x0
	// End of sequence. The sequence A interrupt/DMA trigger will be set when the entire set of sequence-A conversions completes. This flag will need to be explicitly cleared by software or by the DMA-clear signal in this mode. The OVERRUN bit in the SEQA_GDAT register will NOT contribute to generation of an overrun interrupt/DMA trigger since it is assumed this register may not be utilized in this mode.
	ADC0_SEQA_CTRL_MODE_END_OF_SEQUENCE = 0x1
	// Position of SEQA_ENA field.
	ADC0_SEQA_CTRL_SEQA_ENA_Pos = 0x1f
	// Bit mask of SEQA_ENA field.
	ADC0_SEQA_CTRL_SEQA_ENA_Msk = 0x80000000
	// Bit SEQA_ENA.
	ADC0_SEQA_CTRL_SEQA_ENA = 0x80000000
	// Disabled. Sequence A is disabled. Sequence A triggers are ignored. If this bit is cleared while sequence A is in progress, the sequence will be halted at the end of the current conversion. After the sequence is re-enabled, a new trigger will be required to restart the sequence beginning with the next enabled channel.
	ADC0_SEQA_CTRL_SEQA_ENA_DISABLED = 0x0
	// Enabled. Sequence A is enabled.
	ADC0_SEQA_CTRL_SEQA_ENA_ENABLED = 0x1

	// SEQB_CTRL: ADC Conversion Sequence-B Control Register: Controls triggering and channel selection for conversion sequence-B. Also specifies interrupt mode for sequence-B.
	// Position of CHANNELS field.
	ADC0_SEQB_CTRL_CHANNELS_Pos = 0x0
	// Bit mask of CHANNELS field.
	ADC0_SEQB_CTRL_CHANNELS_Msk = 0xfff
	// Position of TRIGGER field.
	ADC0_SEQB_CTRL_TRIGGER_Pos = 0xc
	// Bit mask of TRIGGER field.
	ADC0_SEQB_CTRL_TRIGGER_Msk = 0x3f000
	// Position of TRIGPOL field.
	ADC0_SEQB_CTRL_TRIGPOL_Pos = 0x12
	// Bit mask of TRIGPOL field.
	ADC0_SEQB_CTRL_TRIGPOL_Msk = 0x40000
	// Bit TRIGPOL.
	ADC0_SEQB_CTRL_TRIGPOL = 0x40000
	// Negative edge. A negative edge launches the conversion sequence on the selected trigger input.
	ADC0_SEQB_CTRL_TRIGPOL_NEGATIVE_EDGE = 0x0
	// Positive edge. A positive edge launches the conversion sequence on the selected trigger input.
	ADC0_SEQB_CTRL_TRIGPOL_POSITIVE_EDGE = 0x1
	// Position of SYNCBYPASS field.
	ADC0_SEQB_CTRL_SYNCBYPASS_Pos = 0x13
	// Bit mask of SYNCBYPASS field.
	ADC0_SEQB_CTRL_SYNCBYPASS_Msk = 0x80000
	// Bit SYNCBYPASS.
	ADC0_SEQB_CTRL_SYNCBYPASS = 0x80000
	// Enable synchronization. The hardware trigger bypass is not enabled.
	ADC0_SEQB_CTRL_SYNCBYPASS_ENABLE_SYNCHRONIZATI = 0x0
	// Bypass synchronization. The hardware trigger bypass is enabled.
	ADC0_SEQB_CTRL_SYNCBYPASS_BYPASS_SYNCHRONIZATI = 0x1
	// Position of RESERVED field.
	ADC0_SEQB_CTRL_RESERVED_Pos = 0x14
	// Bit mask of RESERVED field.
	ADC0_SEQB_CTRL_RESERVED_Msk = 0x3f00000
	// Position of START field.
	ADC0_SEQB_CTRL_START_Pos = 0x1a
	// Bit mask of START field.
	ADC0_SEQB_CTRL_START_Msk = 0x4000000
	// Bit START.
	ADC0_SEQB_CTRL_START = 0x4000000
	// Position of BURST field.
	ADC0_SEQB_CTRL_BURST_Pos = 0x1b
	// Bit mask of BURST field.
	ADC0_SEQB_CTRL_BURST_Msk = 0x8000000
	// Bit BURST.
	ADC0_SEQB_CTRL_BURST = 0x8000000
	// Position of SINGLESTEP field.
	ADC0_SEQB_CTRL_SINGLESTEP_Pos = 0x1c
	// Bit mask of SINGLESTEP field.
	ADC0_SEQB_CTRL_SINGLESTEP_Msk = 0x10000000
	// Bit SINGLESTEP.
	ADC0_SEQB_CTRL_SINGLESTEP = 0x10000000
	// Position of RESERVED field.
	ADC0_SEQB_CTRL_RESERVED_Pos = 0x1d
	// Bit mask of RESERVED field.
	ADC0_SEQB_CTRL_RESERVED_Msk = 0x20000000
	// Bit RESERVED.
	ADC0_SEQB_CTRL_RESERVED = 0x20000000
	// Position of MODE field.
	ADC0_SEQB_CTRL_MODE_Pos = 0x1e
	// Bit mask of MODE field.
	ADC0_SEQB_CTRL_MODE_Msk = 0x40000000
	// Bit MODE.
	ADC0_SEQB_CTRL_MODE = 0x40000000
	// End of conversion. The sequence B interrupt/DMA trigger will be set at the end of each individual ADC conversion performed under sequence B. This flag will mirror the DATAVALID bit in the SEQB_GDAT register. The OVERRUN bit in the SEQB_GDAT register will contribute to generation of an overrun interrupt/DMA trigger if enabled.
	ADC0_SEQB_CTRL_MODE_END_OF_CONVERSION = 0x0
	// End of sequence. The sequence B interrupt/DMA trigger will be set when the entire set of sequence-B conversions completes. This flag will need to be explicitly cleared by software or by the DMA-clear signal in this mode. The OVERRUN bit in the SEQB_GDAT register will NOT contribute to generation of an overrun interrupt/DMA trigger since it is assumed this register may not be utilized in this mode.
	ADC0_SEQB_CTRL_MODE_END_OF_SEQUENCE = 0x1
	// Position of SEQB_ENA field.
	ADC0_SEQB_CTRL_SEQB_ENA_Pos = 0x1f
	// Bit mask of SEQB_ENA field.
	ADC0_SEQB_CTRL_SEQB_ENA_Msk = 0x80000000
	// Bit SEQB_ENA.
	ADC0_SEQB_CTRL_SEQB_ENA = 0x80000000
	// Disabled. Sequence B is disabled. Sequence B triggers are ignored. If this bit is cleared while sequence B is in progress, the sequence will be halted at the end of the current conversion. After the sequence is re-enabled, a new trigger will be required to restart the sequence beginning with the next enabled channel.
	ADC0_SEQB_CTRL_SEQB_ENA_DISABLED = 0x0
	// Enabled. Sequence B is enabled.
	ADC0_SEQB_CTRL_SEQB_ENA_ENABLED = 0x1

	// SEQA_GDAT: ADC Sequence-A Global Data Register. This register contains the result of the most recent ADC conversion performed under sequence-A
	// Position of RESERVED field.
	ADC0_SEQA_GDAT_RESERVED_Pos = 0x0
	// Bit mask of RESERVED field.
	ADC0_SEQA_GDAT_RESERVED_Msk = 0xf
	// Position of RESULT field.
	ADC0_SEQA_GDAT_RESULT_Pos = 0x4
	// Bit mask of RESULT field.
	ADC0_SEQA_GDAT_RESULT_Msk = 0xfff0
	// Position of THCMPRANGE field.
	ADC0_SEQA_GDAT_THCMPRANGE_Pos = 0x10
	// Bit mask of THCMPRANGE field.
	ADC0_SEQA_GDAT_THCMPRANGE_Msk = 0x30000
	// Position of THCMPCROSS field.
	ADC0_SEQA_GDAT_THCMPCROSS_Pos = 0x12
	// Bit mask of THCMPCROSS field.
	ADC0_SEQA_GDAT_THCMPCROSS_Msk = 0xc0000
	// Position of RESERVED field.
	ADC0_SEQA_GDAT_RESERVED_Pos = 0x14
	// Bit mask of RESERVED field.
	ADC0_SEQA_GDAT_RESERVED_Msk = 0x3f00000
	// Position of CHN field.
	ADC0_SEQA_GDAT_CHN_Pos = 0x1a
	// Bit mask of CHN field.
	ADC0_SEQA_GDAT_CHN_Msk = 0x3c000000
	// Position of OVERRUN field.
	ADC0_SEQA_GDAT_OVERRUN_Pos = 0x1e
	// Bit mask of OVERRUN field.
	ADC0_SEQA_GDAT_OVERRUN_Msk = 0x40000000
	// Bit OVERRUN.
	ADC0_SEQA_GDAT_OVERRUN = 0x40000000
	// Position of DATAVALID field.
	ADC0_SEQA_GDAT_DATAVALID_Pos = 0x1f
	// Bit mask of DATAVALID field.
	ADC0_SEQA_GDAT_DATAVALID_Msk = 0x80000000
	// Bit DATAVALID.
	ADC0_SEQA_GDAT_DATAVALID = 0x80000000

	// SEQB_GDAT: ADC Sequence-B Global Data Register. This register contains the result of the most recent ADC conversion performed under sequence-B
	// Position of RESERVED field.
	ADC0_SEQB_GDAT_RESERVED_Pos = 0x0
	// Bit mask of RESERVED field.
	ADC0_SEQB_GDAT_RESERVED_Msk = 0xf
	// Position of RESULT field.
	ADC0_SEQB_GDAT_RESULT_Pos = 0x4
	// Bit mask of RESULT field.
	ADC0_SEQB_GDAT_RESULT_Msk = 0xfff0
	// Position of THCMPRANGE field.
	ADC0_SEQB_GDAT_THCMPRANGE_Pos = 0x10
	// Bit mask of THCMPRANGE field.
	ADC0_SEQB_GDAT_THCMPRANGE_Msk = 0x30000
	// Position of THCMPCROSS field.
	ADC0_SEQB_GDAT_THCMPCROSS_Pos = 0x12
	// Bit mask of THCMPCROSS field.
	ADC0_SEQB_GDAT_THCMPCROSS_Msk = 0xc0000
	// Position of RESERVED field.
	ADC0_SEQB_GDAT_RESERVED_Pos = 0x14
	// Bit mask of RESERVED field.
	ADC0_SEQB_GDAT_RESERVED_Msk = 0x3f00000
	// Position of CHN field.
	ADC0_SEQB_GDAT_CHN_Pos = 0x1a
	// Bit mask of CHN field.
	ADC0_SEQB_GDAT_CHN_Msk = 0x3c000000
	// Position of OVERRUN field.
	ADC0_SEQB_GDAT_OVERRUN_Pos = 0x1e
	// Bit mask of OVERRUN field.
	ADC0_SEQB_GDAT_OVERRUN_Msk = 0x40000000
	// Bit OVERRUN.
	ADC0_SEQB_GDAT_OVERRUN = 0x40000000
	// Position of DATAVALID field.
	ADC0_SEQB_GDAT_DATAVALID_Pos = 0x1f
	// Bit mask of DATAVALID field.
	ADC0_SEQB_GDAT_DATAVALID_Msk = 0x80000000
	// Bit DATAVALID.
	ADC0_SEQB_GDAT_DATAVALID = 0x80000000

	// DAT0: ADC Channel 0 Data Register. This register contains the result of the most recent conversion completed on channel 0.
	// Position of RESERVED field.
	ADC0_DAT_RESERVED_Pos = 0x0
	// Bit mask of RESERVED field.
	ADC0_DAT_RESERVED_Msk = 0xf
	// Position of RESULT field.
	ADC0_DAT_RESULT_Pos = 0x4
	// Bit mask of RESULT field.
	ADC0_DAT_RESULT_Msk = 0xfff0
	// Position of THCMPRANGE field.
	ADC0_DAT_THCMPRANGE_Pos = 0x10
	// Bit mask of THCMPRANGE field.
	ADC0_DAT_THCMPRANGE_Msk = 0x30000
	// Position of THCMPCROSS field.
	ADC0_DAT_THCMPCROSS_Pos = 0x12
	// Bit mask of THCMPCROSS field.
	ADC0_DAT_THCMPCROSS_Msk = 0xc0000
	// Position of RESERVED field.
	ADC0_DAT_RESERVED_Pos = 0x14
	// Bit mask of RESERVED field.
	ADC0_DAT_RESERVED_Msk = 0x3f00000
	// Position of CHANNEL field.
	ADC0_DAT_CHANNEL_Pos = 0x1a
	// Bit mask of CHANNEL field.
	ADC0_DAT_CHANNEL_Msk = 0x3c000000
	// Position of OVERRUN field.
	ADC0_DAT_OVERRUN_Pos = 0x1e
	// Bit mask of OVERRUN field.
	ADC0_DAT_OVERRUN_Msk = 0x40000000
	// Bit OVERRUN.
	ADC0_DAT_OVERRUN = 0x40000000
	// Position of DATAVALID field.
	ADC0_DAT_DATAVALID_Pos = 0x1f
	// Bit mask of DATAVALID field.
	ADC0_DAT_DATAVALID_Msk = 0x80000000
	// Bit DATAVALID.
	ADC0_DAT_DATAVALID = 0x80000000

	// THR0_LOW: ADC Low Compare Threshold Register 0: Contains the lower threshold level for automatic threshold comparison for any channels linked to threshold pair 0.
	// Position of RESERVED field.
	ADC0_THR0_LOW_RESERVED_Pos = 0x0
	// Bit mask of RESERVED field.
	ADC0_THR0_LOW_RESERVED_Msk = 0xf
	// Position of THRLOW field.
	ADC0_THR0_LOW_THRLOW_Pos = 0x4
	// Bit mask of THRLOW field.
	ADC0_THR0_LOW_THRLOW_Msk = 0xfff0
	// Position of RESERVED field.
	ADC0_THR0_LOW_RESERVED_Pos = 0x10
	// Bit mask of RESERVED field.
	ADC0_THR0_LOW_RESERVED_Msk = 0xffff0000

	// THR1_LOW: ADC Low Compare Threshold Register 1: Contains the lower threshold level for automatic threshold comparison for any channels linked to threshold pair 1.
	// Position of RESERVED field.
	ADC0_THR1_LOW_RESERVED_Pos = 0x0
	// Bit mask of RESERVED field.
	ADC0_THR1_LOW_RESERVED_Msk = 0xf
	// Position of THRLOW field.
	ADC0_THR1_LOW_THRLOW_Pos = 0x4
	// Bit mask of THRLOW field.
	ADC0_THR1_LOW_THRLOW_Msk = 0xfff0
	// Position of RESERVED field.
	ADC0_THR1_LOW_RESERVED_Pos = 0x10
	// Bit mask of RESERVED field.
	ADC0_THR1_LOW_RESERVED_Msk = 0xffff0000

	// THR0_HIGH: ADC High Compare Threshold Register 0: Contains the upper threshold level for automatic threshold comparison for any channels linked to threshold pair 0.
	// Position of RESERVED field.
	ADC0_THR0_HIGH_RESERVED_Pos = 0x0
	// Bit mask of RESERVED field.
	ADC0_THR0_HIGH_RESERVED_Msk = 0xf
	// Position of THRHIGH field.
	ADC0_THR0_HIGH_THRHIGH_Pos = 0x4
	// Bit mask of THRHIGH field.
	ADC0_THR0_HIGH_THRHIGH_Msk = 0xfff0
	// Position of RESERVED field.
	ADC0_THR0_HIGH_RESERVED_Pos = 0x10
	// Bit mask of RESERVED field.
	ADC0_THR0_HIGH_RESERVED_Msk = 0xffff0000

	// THR1_HIGH: ADC High Compare Threshold Register 1: Contains the upper threshold level for automatic threshold comparison for any channels linked to threshold pair 1.
	// Position of RESERVED field.
	ADC0_THR1_HIGH_RESERVED_Pos = 0x0
	// Bit mask of RESERVED field.
	ADC0_THR1_HIGH_RESERVED_Msk = 0xf
	// Position of THRHIGH field.
	ADC0_THR1_HIGH_THRHIGH_Pos = 0x4
	// Bit mask of THRHIGH field.
	ADC0_THR1_HIGH_THRHIGH_Msk = 0xfff0
	// Position of RESERVED field.
	ADC0_THR1_HIGH_RESERVED_Pos = 0x10
	// Bit mask of RESERVED field.
	ADC0_THR1_HIGH_RESERVED_Msk = 0xffff0000

	// CHAN_THRSEL: ADC Channel-Threshold Select Register. Specifies which set of threshold compare registers are to be used for each channel
	// Position of CH0_THRSEL field.
	ADC0_CHAN_THRSEL_CH0_THRSEL_Pos = 0x0
	// Bit mask of CH0_THRSEL field.
	ADC0_CHAN_THRSEL_CH0_THRSEL_Msk = 0x1
	// Bit CH0_THRSEL.
	ADC0_CHAN_THRSEL_CH0_THRSEL = 0x1
	// Threshold 0. Results for this channel will be compared against the threshold levels indicated in the THR0_LOW and THR0_HIGH registers.
	ADC0_CHAN_THRSEL_CH0_THRSEL_THRESHOLD0 = 0x0
	// Threshold 1. Results for this channel will be compared against the threshold levels indicated in the THR1_LOW and THR1_HIGH registers.
	ADC0_CHAN_THRSEL_CH0_THRSEL_THRESHOLD1 = 0x1
	// Position of CH1_THRSEL field.
	ADC0_CHAN_THRSEL_CH1_THRSEL_Pos = 0x1
	// Bit mask of CH1_THRSEL field.
	ADC0_CHAN_THRSEL_CH1_THRSEL_Msk = 0x2
	// Bit CH1_THRSEL.
	ADC0_CHAN_THRSEL_CH1_THRSEL = 0x2
	// Position of CH2_THRSEL field.
	ADC0_CHAN_THRSEL_CH2_THRSEL_Pos = 0x2
	// Bit mask of CH2_THRSEL field.
	ADC0_CHAN_THRSEL_CH2_THRSEL_Msk = 0x4
	// Bit CH2_THRSEL.
	ADC0_CHAN_THRSEL_CH2_THRSEL = 0x4
	// Position of CH3_THRSEL field.
	ADC0_CHAN_THRSEL_CH3_THRSEL_Pos = 0x3
	// Bit mask of CH3_THRSEL field.
	ADC0_CHAN_THRSEL_CH3_THRSEL_Msk = 0x8
	// Bit CH3_THRSEL.
	ADC0_CHAN_THRSEL_CH3_THRSEL = 0x8
	// Position of CH4_THRSEL field.
	ADC0_CHAN_THRSEL_CH4_THRSEL_Pos = 0x4
	// Bit mask of CH4_THRSEL field.
	ADC0_CHAN_THRSEL_CH4_THRSEL_Msk = 0x10
	// Bit CH4_THRSEL.
	ADC0_CHAN_THRSEL_CH4_THRSEL = 0x10
	// Position of CH5_THRSEL field.
	ADC0_CHAN_THRSEL_CH5_THRSEL_Pos = 0x5
	// Bit mask of CH5_THRSEL field.
	ADC0_CHAN_THRSEL_CH5_THRSEL_Msk = 0x20
	// Bit CH5_THRSEL.
	ADC0_CHAN_THRSEL_CH5_THRSEL = 0x20
	// Position of CH6_THRSEL field.
	ADC0_CHAN_THRSEL_CH6_THRSEL_Pos = 0x6
	// Bit mask of CH6_THRSEL field.
	ADC0_CHAN_THRSEL_CH6_THRSEL_Msk = 0x40
	// Bit CH6_THRSEL.
	ADC0_CHAN_THRSEL_CH6_THRSEL = 0x40
	// Position of CH7_THRSEL field.
	ADC0_CHAN_THRSEL_CH7_THRSEL_Pos = 0x7
	// Bit mask of CH7_THRSEL field.
	ADC0_CHAN_THRSEL_CH7_THRSEL_Msk = 0x80
	// Bit CH7_THRSEL.
	ADC0_CHAN_THRSEL_CH7_THRSEL = 0x80
	// Position of CH8_THRSEL field.
	ADC0_CHAN_THRSEL_CH8_THRSEL_Pos = 0x8
	// Bit mask of CH8_THRSEL field.
	ADC0_CHAN_THRSEL_CH8_THRSEL_Msk = 0x100
	// Bit CH8_THRSEL.
	ADC0_CHAN_THRSEL_CH8_THRSEL = 0x100
	// Position of CH9_THRSEL field.
	ADC0_CHAN_THRSEL_CH9_THRSEL_Pos = 0x9
	// Bit mask of CH9_THRSEL field.
	ADC0_CHAN_THRSEL_CH9_THRSEL_Msk = 0x200
	// Bit CH9_THRSEL.
	ADC0_CHAN_THRSEL_CH9_THRSEL = 0x200
	// Position of CH10_THRSEL field.
	ADC0_CHAN_THRSEL_CH10_THRSEL_Pos = 0xa
	// Bit mask of CH10_THRSEL field.
	ADC0_CHAN_THRSEL_CH10_THRSEL_Msk = 0x400
	// Bit CH10_THRSEL.
	ADC0_CHAN_THRSEL_CH10_THRSEL = 0x400
	// Position of CH11_THRSEL field.
	ADC0_CHAN_THRSEL_CH11_THRSEL_Pos = 0xb
	// Bit mask of CH11_THRSEL field.
	ADC0_CHAN_THRSEL_CH11_THRSEL_Msk = 0x800
	// Bit CH11_THRSEL.
	ADC0_CHAN_THRSEL_CH11_THRSEL = 0x800
	// Position of RESERVED field.
	ADC0_CHAN_THRSEL_RESERVED_Pos = 0xc
	// Bit mask of RESERVED field.
	ADC0_CHAN_THRSEL_RESERVED_Msk = 0xfffff000

	// INTEN: ADC Interrupt Enable Register. This register contains enable bits that enable the sequence-A, sequence-B, threshold compare and data overrun interrupts to be generated.
	// Position of SEQA_INTEN field.
	ADC0_INTEN_SEQA_INTEN_Pos = 0x0
	// Bit mask of SEQA_INTEN field.
	ADC0_INTEN_SEQA_INTEN_Msk = 0x1
	// Bit SEQA_INTEN.
	ADC0_INTEN_SEQA_INTEN = 0x1
	// Disabled. The sequence A interrupt/DMA trigger is disabled.
	ADC0_INTEN_SEQA_INTEN_DISABLED = 0x0
	// Enabled. The sequence A interrupt/DMA trigger is enabled and will be asserted either upon completion of each individual conversion performed as part of sequence A, or upon completion of the entire A sequence of conversions, depending on the MODE bit in the SEQA_CTRL register.
	ADC0_INTEN_SEQA_INTEN_ENABLED = 0x1
	// Position of SEQB_INTEN field.
	ADC0_INTEN_SEQB_INTEN_Pos = 0x1
	// Bit mask of SEQB_INTEN field.
	ADC0_INTEN_SEQB_INTEN_Msk = 0x2
	// Bit SEQB_INTEN.
	ADC0_INTEN_SEQB_INTEN = 0x2
	// Disabled. The sequence B interrupt/DMA trigger is disabled.
	ADC0_INTEN_SEQB_INTEN_DISABLED = 0x0
	// Enabled. The sequence B interrupt/DMA trigger is enabled and will be asserted either upon completion of each individual conversion performed as part of sequence B, or upon completion of the entire B sequence of conversions, depending on the MODE bit in the SEQB_CTRL register.
	ADC0_INTEN_SEQB_INTEN_ENABLED = 0x1
	// Position of OVR_INTEN field.
	ADC0_INTEN_OVR_INTEN_Pos = 0x2
	// Bit mask of OVR_INTEN field.
	ADC0_INTEN_OVR_INTEN_Msk = 0x4
	// Bit OVR_INTEN.
	ADC0_INTEN_OVR_INTEN = 0x4
	// Disabled. The overrun interrupt is disabled.
	ADC0_INTEN_OVR_INTEN_DISABLED = 0x0
	// Enabled. The overrun interrupt is enabled. Detection of an overrun condition on any of the 12 channel data registers will cause an overrun interrupt/DMA trigger. In addition, if the MODE bit for a particular sequence is 0, then an overrun in the global data register for that sequence will also cause this interrupt/DMA trigger to be asserted.
	ADC0_INTEN_OVR_INTEN_ENABLED = 0x1
	// Position of ADCMPINTEN0 field.
	ADC0_INTEN_ADCMPINTEN0_Pos = 0x3
	// Bit mask of ADCMPINTEN0 field.
	ADC0_INTEN_ADCMPINTEN0_Msk = 0x18
	// Disabled.
	ADC0_INTEN_ADCMPINTEN0_DISABLED = 0x0
	// Outside threshold.
	ADC0_INTEN_ADCMPINTEN0_OUTSIDE_THRESHOLD = 0x1
	// Crossing threshold.
	ADC0_INTEN_ADCMPINTEN0_CROSSING_THRESHOLD = 0x2
	// Position of ADCMPINTEN1 field.
	ADC0_INTEN_ADCMPINTEN1_Pos = 0x5
	// Bit mask of ADCMPINTEN1 field.
	ADC0_INTEN_ADCMPINTEN1_Msk = 0x60
	// Position of ADCMPINTEN2 field.
	ADC0_INTEN_ADCMPINTEN2_Pos = 0x7
	// Bit mask of ADCMPINTEN2 field.
	ADC0_INTEN_ADCMPINTEN2_Msk = 0x180
	// Position of ADCMPINTEN3 field.
	ADC0_INTEN_ADCMPINTEN3_Pos = 0x9
	// Bit mask of ADCMPINTEN3 field.
	ADC0_INTEN_ADCMPINTEN3_Msk = 0x600
	// Position of ADCMPINTEN4 field.
	ADC0_INTEN_ADCMPINTEN4_Pos = 0xb
	// Bit mask of ADCMPINTEN4 field.
	ADC0_INTEN_ADCMPINTEN4_Msk = 0x1800
	// Position of ADCMPINTEN5 field.
	ADC0_INTEN_ADCMPINTEN5_Pos = 0xd
	// Bit mask of ADCMPINTEN5 field.
	ADC0_INTEN_ADCMPINTEN5_Msk = 0x6000
	// Position of ADCMPINTEN6 field.
	ADC0_INTEN_ADCMPINTEN6_Pos = 0xf
	// Bit mask of ADCMPINTEN6 field.
	ADC0_INTEN_ADCMPINTEN6_Msk = 0x18000
	// Position of ADCMPINTEN7 field.
	ADC0_INTEN_ADCMPINTEN7_Pos = 0x11
	// Bit mask of ADCMPINTEN7 field.
	ADC0_INTEN_ADCMPINTEN7_Msk = 0x60000
	// Position of ADCMPINTEN8 field.
	ADC0_INTEN_ADCMPINTEN8_Pos = 0x13
	// Bit mask of ADCMPINTEN8 field.
	ADC0_INTEN_ADCMPINTEN8_Msk = 0x180000
	// Position of ADCMPINTEN9 field.
	ADC0_INTEN_ADCMPINTEN9_Pos = 0x15
	// Bit mask of ADCMPINTEN9 field.
	ADC0_INTEN_ADCMPINTEN9_Msk = 0x600000
	// Position of ADCMPINTEN10 field.
	ADC0_INTEN_ADCMPINTEN10_Pos = 0x17
	// Bit mask of ADCMPINTEN10 field.
	ADC0_INTEN_ADCMPINTEN10_Msk = 0x1800000
	// Position of ADCMPINTEN11 field.
	ADC0_INTEN_ADCMPINTEN11_Pos = 0x19
	// Bit mask of ADCMPINTEN11 field.
	ADC0_INTEN_ADCMPINTEN11_Msk = 0x6000000
	// Position of RESERVED field.
	ADC0_INTEN_RESERVED_Pos = 0x1b
	// Bit mask of RESERVED field.
	ADC0_INTEN_RESERVED_Msk = 0xf8000000

	// FLAGS: ADC Flags Register. Contains the four interrupt/DMA trigger flags and the individual component overrun and threshold-compare flags. (The overrun bits replicate information stored in the result registers).
	// Position of THCMP0 field.
	ADC0_FLAGS_THCMP0_Pos = 0x0
	// Bit mask of THCMP0 field.
	ADC0_FLAGS_THCMP0_Msk = 0x1
	// Bit THCMP0.
	ADC0_FLAGS_THCMP0 = 0x1
	// Position of THCMP1 field.
	ADC0_FLAGS_THCMP1_Pos = 0x1
	// Bit mask of THCMP1 field.
	ADC0_FLAGS_THCMP1_Msk = 0x2
	// Bit THCMP1.
	ADC0_FLAGS_THCMP1 = 0x2
	// Position of THCMP2 field.
	ADC0_FLAGS_THCMP2_Pos = 0x2
	// Bit mask of THCMP2 field.
	ADC0_FLAGS_THCMP2_Msk = 0x4
	// Bit THCMP2.
	ADC0_FLAGS_THCMP2 = 0x4
	// Position of THCMP3 field.
	ADC0_FLAGS_THCMP3_Pos = 0x3
	// Bit mask of THCMP3 field.
	ADC0_FLAGS_THCMP3_Msk = 0x8
	// Bit THCMP3.
	ADC0_FLAGS_THCMP3 = 0x8
	// Position of THCMP4 field.
	ADC0_FLAGS_THCMP4_Pos = 0x4
	// Bit mask of THCMP4 field.
	ADC0_FLAGS_THCMP4_Msk = 0x10
	// Bit THCMP4.
	ADC0_FLAGS_THCMP4 = 0x10
	// Position of THCMP5 field.
	ADC0_FLAGS_THCMP5_Pos = 0x5
	// Bit mask of THCMP5 field.
	ADC0_FLAGS_THCMP5_Msk = 0x20
	// Bit THCMP5.
	ADC0_FLAGS_THCMP5 = 0x20
	// Position of THCMP6 field.
	ADC0_FLAGS_THCMP6_Pos = 0x6
	// Bit mask of THCMP6 field.
	ADC0_FLAGS_THCMP6_Msk = 0x40
	// Bit THCMP6.
	ADC0_FLAGS_THCMP6 = 0x40
	// Position of THCMP7 field.
	ADC0_FLAGS_THCMP7_Pos = 0x7
	// Bit mask of THCMP7 field.
	ADC0_FLAGS_THCMP7_Msk = 0x80
	// Bit THCMP7.
	ADC0_FLAGS_THCMP7 = 0x80
	// Position of THCMP8 field.
	ADC0_FLAGS_THCMP8_Pos = 0x8
	// Bit mask of THCMP8 field.
	ADC0_FLAGS_THCMP8_Msk = 0x100
	// Bit THCMP8.
	ADC0_FLAGS_THCMP8 = 0x100
	// Position of THCMP9 field.
	ADC0_FLAGS_THCMP9_Pos = 0x9
	// Bit mask of THCMP9 field.
	ADC0_FLAGS_THCMP9_Msk = 0x200
	// Bit THCMP9.
	ADC0_FLAGS_THCMP9 = 0x200
	// Position of THCMP10 field.
	ADC0_FLAGS_THCMP10_Pos = 0xa
	// Bit mask of THCMP10 field.
	ADC0_FLAGS_THCMP10_Msk = 0x400
	// Bit THCMP10.
	ADC0_FLAGS_THCMP10 = 0x400
	// Position of THCMP11 field.
	ADC0_FLAGS_THCMP11_Pos = 0xb
	// Bit mask of THCMP11 field.
	ADC0_FLAGS_THCMP11_Msk = 0x800
	// Bit THCMP11.
	ADC0_FLAGS_THCMP11 = 0x800
	// Position of OVERRUN0 field.
	ADC0_FLAGS_OVERRUN0_Pos = 0xc
	// Bit mask of OVERRUN0 field.
	ADC0_FLAGS_OVERRUN0_Msk = 0x1000
	// Bit OVERRUN0.
	ADC0_FLAGS_OVERRUN0 = 0x1000
	// Position of OVERRUN1 field.
	ADC0_FLAGS_OVERRUN1_Pos = 0xd
	// Bit mask of OVERRUN1 field.
	ADC0_FLAGS_OVERRUN1_Msk = 0x2000
	// Bit OVERRUN1.
	ADC0_FLAGS_OVERRUN1 = 0x2000
	// Position of OVERRUN2 field.
	ADC0_FLAGS_OVERRUN2_Pos = 0xe
	// Bit mask of OVERRUN2 field.
	ADC0_FLAGS_OVERRUN2_Msk = 0x4000
	// Bit OVERRUN2.
	ADC0_FLAGS_OVERRUN2 = 0x4000
	// Position of OVERRUN3 field.
	ADC0_FLAGS_OVERRUN3_Pos = 0xf
	// Bit mask of OVERRUN3 field.
	ADC0_FLAGS_OVERRUN3_Msk = 0x8000
	// Bit OVERRUN3.
	ADC0_FLAGS_OVERRUN3 = 0x8000
	// Position of OVERRUN4 field.
	ADC0_FLAGS_OVERRUN4_Pos = 0x10
	// Bit mask of OVERRUN4 field.
	ADC0_FLAGS_OVERRUN4_Msk = 0x10000
	// Bit OVERRUN4.
	ADC0_FLAGS_OVERRUN4 = 0x10000
	// Position of OVERRUN5 field.
	ADC0_FLAGS_OVERRUN5_Pos = 0x11
	// Bit mask of OVERRUN5 field.
	ADC0_FLAGS_OVERRUN5_Msk = 0x20000
	// Bit OVERRUN5.
	ADC0_FLAGS_OVERRUN5 = 0x20000
	// Position of OVERRUN6 field.
	ADC0_FLAGS_OVERRUN6_Pos = 0x12
	// Bit mask of OVERRUN6 field.
	ADC0_FLAGS_OVERRUN6_Msk = 0x40000
	// Bit OVERRUN6.
	ADC0_FLAGS_OVERRUN6 = 0x40000
	// Position of OVERRUN7 field.
	ADC0_FLAGS_OVERRUN7_Pos = 0x13
	// Bit mask of OVERRUN7 field.
	ADC0_FLAGS_OVERRUN7_Msk = 0x80000
	// Bit OVERRUN7.
	ADC0_FLAGS_OVERRUN7 = 0x80000
	// Position of OVERRUN8 field.
	ADC0_FLAGS_OVERRUN8_Pos = 0x14
	// Bit mask of OVERRUN8 field.
	ADC0_FLAGS_OVERRUN8_Msk = 0x100000
	// Bit OVERRUN8.
	ADC0_FLAGS_OVERRUN8 = 0x100000
	// Position of OVERRUN9 field.
	ADC0_FLAGS_OVERRUN9_Pos = 0x15
	// Bit mask of OVERRUN9 field.
	ADC0_FLAGS_OVERRUN9_Msk = 0x200000
	// Bit OVERRUN9.
	ADC0_FLAGS_OVERRUN9 = 0x200000
	// Position of OVERRUN10 field.
	ADC0_FLAGS_OVERRUN10_Pos = 0x16
	// Bit mask of OVERRUN10 field.
	ADC0_FLAGS_OVERRUN10_Msk = 0x400000
	// Bit OVERRUN10.
	ADC0_FLAGS_OVERRUN10 = 0x400000
	// Position of OVERRUN11 field.
	ADC0_FLAGS_OVERRUN11_Pos = 0x17
	// Bit mask of OVERRUN11 field.
	ADC0_FLAGS_OVERRUN11_Msk = 0x800000
	// Bit OVERRUN11.
	ADC0_FLAGS_OVERRUN11 = 0x800000
	// Position of SEQA_OVR field.
	ADC0_FLAGS_SEQA_OVR_Pos = 0x18
	// Bit mask of SEQA_OVR field.
	ADC0_FLAGS_SEQA_OVR_Msk = 0x1000000
	// Bit SEQA_OVR.
	ADC0_FLAGS_SEQA_OVR = 0x1000000
	// Position of SEQB_OVR field.
	ADC0_FLAGS_SEQB_OVR_Pos = 0x19
	// Bit mask of SEQB_OVR field.
	ADC0_FLAGS_SEQB_OVR_Msk = 0x2000000
	// Bit SEQB_OVR.
	ADC0_FLAGS_SEQB_OVR = 0x2000000
	// Position of RESERVED field.
	ADC0_FLAGS_RESERVED_Pos = 0x1a
	// Bit mask of RESERVED field.
	ADC0_FLAGS_RESERVED_Msk = 0xc000000
	// Position of SEQA_INT field.
	ADC0_FLAGS_SEQA_INT_Pos = 0x1c
	// Bit mask of SEQA_INT field.
	ADC0_FLAGS_SEQA_INT_Msk = 0x10000000
	// Bit SEQA_INT.
	ADC0_FLAGS_SEQA_INT = 0x10000000
	// Position of SEQB_INT field.
	ADC0_FLAGS_SEQB_INT_Pos = 0x1d
	// Bit mask of SEQB_INT field.
	ADC0_FLAGS_SEQB_INT_Msk = 0x20000000
	// Bit SEQB_INT.
	ADC0_FLAGS_SEQB_INT = 0x20000000
	// Position of THCMP_INT field.
	ADC0_FLAGS_THCMP_INT_Pos = 0x1e
	// Bit mask of THCMP_INT field.
	ADC0_FLAGS_THCMP_INT_Msk = 0x40000000
	// Bit THCMP_INT.
	ADC0_FLAGS_THCMP_INT = 0x40000000
	// Position of OVR_INT field.
	ADC0_FLAGS_OVR_INT_Pos = 0x1f
	// Bit mask of OVR_INT field.
	ADC0_FLAGS_OVR_INT_Msk = 0x80000000
	// Bit OVR_INT.
	ADC0_FLAGS_OVR_INT = 0x80000000

	// STARTUP: ADC Startup Register (typically only used by the ADC API).
	// Position of ADC_ENA field.
	ADC0_STARTUP_ADC_ENA_Pos = 0x0
	// Bit mask of ADC_ENA field.
	ADC0_STARTUP_ADC_ENA_Msk = 0x1
	// Bit ADC_ENA.
	ADC0_STARTUP_ADC_ENA = 0x1
	// Position of ADC_INT field.
	ADC0_STARTUP_ADC_INT_Pos = 0x1
	// Bit mask of ADC_INT field.
	ADC0_STARTUP_ADC_INT_Msk = 0x2
	// Bit ADC_INT.
	ADC0_STARTUP_ADC_INT = 0x2
	// Position of RESERVED field.
	ADC0_STARTUP_RESERVED_Pos = 0x2
	// Bit mask of RESERVED field.
	ADC0_STARTUP_RESERVED_Msk = 0xfffffffc

	// CALIB: ADC Calibration Register.
	// Position of CALIB field.
	ADC0_CALIB_CALIB_Pos = 0x0
	// Bit mask of CALIB field.
	ADC0_CALIB_CALIB_Msk = 0x1
	// Bit CALIB.
	ADC0_CALIB_CALIB = 0x1
	// Position of CALREQD field.
	ADC0_CALIB_CALREQD_Pos = 0x1
	// Bit mask of CALREQD field.
	ADC0_CALIB_CALREQD_Msk = 0x2
	// Bit CALREQD.
	ADC0_CALIB_CALREQD = 0x2
	// Position of CALVALUE field.
	ADC0_CALIB_CALVALUE_Pos = 0x2
	// Bit mask of CALVALUE field.
	ADC0_CALIB_CALVALUE_Msk = 0x1fc
	// Position of RESERVED field.
	ADC0_CALIB_RESERVED_Pos = 0x9
	// Bit mask of RESERVED field.
	ADC0_CALIB_RESERVED_Msk = 0xfffffe00
)

// Bitfields for VFIFO: System FIFO for Serial Peripherals
const (
	// FIFOCTLUSART: USART FIFO global control register. These registers are byte, halfword, and word addressable.The upper 16 bits of these registers provide information about the System FIFO configuration, and are specific to each device type.
	// Position of RXPAUSE field.
	VFIFO_FIFOCTLUSART_RXPAUSE_Pos = 0x0
	// Bit mask of RXPAUSE field.
	VFIFO_FIFOCTLUSART_RXPAUSE_Msk = 0x1
	// Bit RXPAUSE.
	VFIFO_FIFOCTLUSART_RXPAUSE = 0x1
	// Position of RXPAUSED field.
	VFIFO_FIFOCTLUSART_RXPAUSED_Pos = 0x1
	// Bit mask of RXPAUSED field.
	VFIFO_FIFOCTLUSART_RXPAUSED_Msk = 0x2
	// Bit RXPAUSED.
	VFIFO_FIFOCTLUSART_RXPAUSED = 0x2
	// Position of RXEMPTY field.
	VFIFO_FIFOCTLUSART_RXEMPTY_Pos = 0x2
	// Bit mask of RXEMPTY field.
	VFIFO_FIFOCTLUSART_RXEMPTY_Msk = 0x4
	// Bit RXEMPTY.
	VFIFO_FIFOCTLUSART_RXEMPTY = 0x4
	// Position of RESERVED field.
	VFIFO_FIFOCTLUSART_RESERVED_Pos = 0x3
	// Bit mask of RESERVED field.
	VFIFO_FIFOCTLUSART_RESERVED_Msk = 0xf8
	// Position of TXPAUSE field.
	VFIFO_FIFOCTLUSART_TXPAUSE_Pos = 0x8
	// Bit mask of TXPAUSE field.
	VFIFO_FIFOCTLUSART_TXPAUSE_Msk = 0x100
	// Bit TXPAUSE.
	VFIFO_FIFOCTLUSART_TXPAUSE = 0x100
	// Position of TXPAUSED field.
	VFIFO_FIFOCTLUSART_TXPAUSED_Pos = 0x9
	// Bit mask of TXPAUSED field.
	VFIFO_FIFOCTLUSART_TXPAUSED_Msk = 0x200
	// Bit TXPAUSED.
	VFIFO_FIFOCTLUSART_TXPAUSED = 0x200
	// Position of TXEMPTY field.
	VFIFO_FIFOCTLUSART_TXEMPTY_Pos = 0xa
	// Bit mask of TXEMPTY field.
	VFIFO_FIFOCTLUSART_TXEMPTY_Msk = 0x400
	// Bit TXEMPTY.
	VFIFO_FIFOCTLUSART_TXEMPTY = 0x400
	// Position of RESERVED field.
	VFIFO_FIFOCTLUSART_RESERVED_Pos = 0xb
	// Bit mask of RESERVED field.
	VFIFO_FIFOCTLUSART_RESERVED_Msk = 0xf800
	// Position of RXFIFOTOTAL field.
	VFIFO_FIFOCTLUSART_RXFIFOTOTAL_Pos = 0x10
	// Bit mask of RXFIFOTOTAL field.
	VFIFO_FIFOCTLUSART_RXFIFOTOTAL_Msk = 0xff0000
	// Position of TXFIFOTOTAL field.
	VFIFO_FIFOCTLUSART_TXFIFOTOTAL_Pos = 0x18
	// Bit mask of TXFIFOTOTAL field.
	VFIFO_FIFOCTLUSART_TXFIFOTOTAL_Msk = 0xff000000

	// FIFOUPDATEUSART: USART FIFO global update register
	// Position of USART0RXUPDATESIZE field.
	VFIFO_FIFOUPDATEUSART_USART0RXUPDATESIZE_Pos = 0x0
	// Bit mask of USART0RXUPDATESIZE field.
	VFIFO_FIFOUPDATEUSART_USART0RXUPDATESIZE_Msk = 0x1
	// Bit USART0RXUPDATESIZE.
	VFIFO_FIFOUPDATEUSART_USART0RXUPDATESIZE = 0x1
	// Position of USART1RXUPDATESIZE field.
	VFIFO_FIFOUPDATEUSART_USART1RXUPDATESIZE_Pos = 0x1
	// Bit mask of USART1RXUPDATESIZE field.
	VFIFO_FIFOUPDATEUSART_USART1RXUPDATESIZE_Msk = 0x2
	// Bit USART1RXUPDATESIZE.
	VFIFO_FIFOUPDATEUSART_USART1RXUPDATESIZE = 0x2
	// Position of USART2RXUPDATESIZE field.
	VFIFO_FIFOUPDATEUSART_USART2RXUPDATESIZE_Pos = 0x2
	// Bit mask of USART2RXUPDATESIZE field.
	VFIFO_FIFOUPDATEUSART_USART2RXUPDATESIZE_Msk = 0x4
	// Bit USART2RXUPDATESIZE.
	VFIFO_FIFOUPDATEUSART_USART2RXUPDATESIZE = 0x4
	// Position of USART3RXUPDATESIZE field.
	VFIFO_FIFOUPDATEUSART_USART3RXUPDATESIZE_Pos = 0x3
	// Bit mask of USART3RXUPDATESIZE field.
	VFIFO_FIFOUPDATEUSART_USART3RXUPDATESIZE_Msk = 0x8
	// Bit USART3RXUPDATESIZE.
	VFIFO_FIFOUPDATEUSART_USART3RXUPDATESIZE = 0x8
	// Position of RESERVED field.
	VFIFO_FIFOUPDATEUSART_RESERVED_Pos = 0x4
	// Bit mask of RESERVED field.
	VFIFO_FIFOUPDATEUSART_RESERVED_Msk = 0xfff0
	// Position of USART0TXUPDATESIZE field.
	VFIFO_FIFOUPDATEUSART_USART0TXUPDATESIZE_Pos = 0x10
	// Bit mask of USART0TXUPDATESIZE field.
	VFIFO_FIFOUPDATEUSART_USART0TXUPDATESIZE_Msk = 0x10000
	// Bit USART0TXUPDATESIZE.
	VFIFO_FIFOUPDATEUSART_USART0TXUPDATESIZE = 0x10000
	// Position of USART1TXUPDATESIZE field.
	VFIFO_FIFOUPDATEUSART_USART1TXUPDATESIZE_Pos = 0x11
	// Bit mask of USART1TXUPDATESIZE field.
	VFIFO_FIFOUPDATEUSART_USART1TXUPDATESIZE_Msk = 0x20000
	// Bit USART1TXUPDATESIZE.
	VFIFO_FIFOUPDATEUSART_USART1TXUPDATESIZE = 0x20000
	// Position of USART2TXUPDATESIZE field.
	VFIFO_FIFOUPDATEUSART_USART2TXUPDATESIZE_Pos = 0x12
	// Bit mask of USART2TXUPDATESIZE field.
	VFIFO_FIFOUPDATEUSART_USART2TXUPDATESIZE_Msk = 0x40000
	// Bit USART2TXUPDATESIZE.
	VFIFO_FIFOUPDATEUSART_USART2TXUPDATESIZE = 0x40000
	// Position of USART3TXUPDATESIZE field.
	VFIFO_FIFOUPDATEUSART_USART3TXUPDATESIZE_Pos = 0x13
	// Bit mask of USART3TXUPDATESIZE field.
	VFIFO_FIFOUPDATEUSART_USART3TXUPDATESIZE_Msk = 0x80000
	// Bit USART3TXUPDATESIZE.
	VFIFO_FIFOUPDATEUSART_USART3TXUPDATESIZE = 0x80000
	// Position of RESERVED field.
	VFIFO_FIFOUPDATEUSART_RESERVED_Pos = 0x14
	// Bit mask of RESERVED field.
	VFIFO_FIFOUPDATEUSART_RESERVED_Msk = 0xfff00000

	// FIFOCFGUSART0: FIFO configuration register for USART0
	// Position of RXSIZE field.
	VFIFO_FIFOCFGUSART_RXSIZE_Pos = 0x0
	// Bit mask of RXSIZE field.
	VFIFO_FIFOCFGUSART_RXSIZE_Msk = 0xff
	// Position of TXSIZE field.
	VFIFO_FIFOCFGUSART_TXSIZE_Pos = 0x8
	// Bit mask of TXSIZE field.
	VFIFO_FIFOCFGUSART_TXSIZE_Msk = 0xff00
	// Position of RESERVED field.
	VFIFO_FIFOCFGUSART_RESERVED_Pos = 0x10
	// Bit mask of RESERVED field.
	VFIFO_FIFOCFGUSART_RESERVED_Msk = 0xffff0000

	// FIFOCTLSPI: SPI FIFO global control register. These registers are byte, halfword, and word addressable. The upper 16 bits of these registers provide information about the System FIFO configuration, and are specific to each device type.
	// Position of RXPAUSE field.
	VFIFO_FIFOCTLSPI_RXPAUSE_Pos = 0x0
	// Bit mask of RXPAUSE field.
	VFIFO_FIFOCTLSPI_RXPAUSE_Msk = 0x1
	// Bit RXPAUSE.
	VFIFO_FIFOCTLSPI_RXPAUSE = 0x1
	// Position of RXPAUSED field.
	VFIFO_FIFOCTLSPI_RXPAUSED_Pos = 0x1
	// Bit mask of RXPAUSED field.
	VFIFO_FIFOCTLSPI_RXPAUSED_Msk = 0x2
	// Bit RXPAUSED.
	VFIFO_FIFOCTLSPI_RXPAUSED = 0x2
	// Position of RXEMPTY field.
	VFIFO_FIFOCTLSPI_RXEMPTY_Pos = 0x2
	// Bit mask of RXEMPTY field.
	VFIFO_FIFOCTLSPI_RXEMPTY_Msk = 0x4
	// Bit RXEMPTY.
	VFIFO_FIFOCTLSPI_RXEMPTY = 0x4
	// Position of RESERVED field.
	VFIFO_FIFOCTLSPI_RESERVED_Pos = 0x3
	// Bit mask of RESERVED field.
	VFIFO_FIFOCTLSPI_RESERVED_Msk = 0xf8
	// Position of TXPAUSE field.
	VFIFO_FIFOCTLSPI_TXPAUSE_Pos = 0x8
	// Bit mask of TXPAUSE field.
	VFIFO_FIFOCTLSPI_TXPAUSE_Msk = 0x100
	// Bit TXPAUSE.
	VFIFO_FIFOCTLSPI_TXPAUSE = 0x100
	// Position of TXPAUSED field.
	VFIFO_FIFOCTLSPI_TXPAUSED_Pos = 0x9
	// Bit mask of TXPAUSED field.
	VFIFO_FIFOCTLSPI_TXPAUSED_Msk = 0x200
	// Bit TXPAUSED.
	VFIFO_FIFOCTLSPI_TXPAUSED = 0x200
	// Position of TXEMPTY field.
	VFIFO_FIFOCTLSPI_TXEMPTY_Pos = 0xa
	// Bit mask of TXEMPTY field.
	VFIFO_FIFOCTLSPI_TXEMPTY_Msk = 0x400
	// Bit TXEMPTY.
	VFIFO_FIFOCTLSPI_TXEMPTY = 0x400
	// Position of RESERVED field.
	VFIFO_FIFOCTLSPI_RESERVED_Pos = 0xb
	// Bit mask of RESERVED field.
	VFIFO_FIFOCTLSPI_RESERVED_Msk = 0xf800
	// Position of RXFIFOTOTAL field.
	VFIFO_FIFOCTLSPI_RXFIFOTOTAL_Pos = 0x10
	// Bit mask of RXFIFOTOTAL field.
	VFIFO_FIFOCTLSPI_RXFIFOTOTAL_Msk = 0xff0000
	// Position of TXFIFOTOTAL field.
	VFIFO_FIFOCTLSPI_TXFIFOTOTAL_Pos = 0x18
	// Bit mask of TXFIFOTOTAL field.
	VFIFO_FIFOCTLSPI_TXFIFOTOTAL_Msk = 0xff000000

	// FIFOUPDATESPI: SPI FIFO global update register
	// Position of SPI0RXUPDATESIZE field.
	VFIFO_FIFOUPDATESPI_SPI0RXUPDATESIZE_Pos = 0x0
	// Bit mask of SPI0RXUPDATESIZE field.
	VFIFO_FIFOUPDATESPI_SPI0RXUPDATESIZE_Msk = 0x1
	// Bit SPI0RXUPDATESIZE.
	VFIFO_FIFOUPDATESPI_SPI0RXUPDATESIZE = 0x1
	// Position of SPI1RXUPDATESIZE field.
	VFIFO_FIFOUPDATESPI_SPI1RXUPDATESIZE_Pos = 0x1
	// Bit mask of SPI1RXUPDATESIZE field.
	VFIFO_FIFOUPDATESPI_SPI1RXUPDATESIZE_Msk = 0x2
	// Bit SPI1RXUPDATESIZE.
	VFIFO_FIFOUPDATESPI_SPI1RXUPDATESIZE = 0x2
	// Position of RESERVED field.
	VFIFO_FIFOUPDATESPI_RESERVED_Pos = 0x3
	// Bit mask of RESERVED field.
	VFIFO_FIFOUPDATESPI_RESERVED_Msk = 0xfff8
	// Position of SPI0TXUPDATESIZE field.
	VFIFO_FIFOUPDATESPI_SPI0TXUPDATESIZE_Pos = 0x10
	// Bit mask of SPI0TXUPDATESIZE field.
	VFIFO_FIFOUPDATESPI_SPI0TXUPDATESIZE_Msk = 0x10000
	// Bit SPI0TXUPDATESIZE.
	VFIFO_FIFOUPDATESPI_SPI0TXUPDATESIZE = 0x10000
	// Position of SPI1TXUPDATESIZE field.
	VFIFO_FIFOUPDATESPI_SPI1TXUPDATESIZE_Pos = 0x11
	// Bit mask of SPI1TXUPDATESIZE field.
	VFIFO_FIFOUPDATESPI_SPI1TXUPDATESIZE_Msk = 0x20000
	// Bit SPI1TXUPDATESIZE.
	VFIFO_FIFOUPDATESPI_SPI1TXUPDATESIZE = 0x20000
	// Position of RESERVED field.
	VFIFO_FIFOUPDATESPI_RESERVED_Pos = 0x12
	// Bit mask of RESERVED field.
	VFIFO_FIFOUPDATESPI_RESERVED_Msk = 0xfffc0000

	// FIFOCFGSPI0: FIFO configuration register for SPI0
	// Position of RXSIZE field.
	VFIFO_FIFOCFGSPI_RXSIZE_Pos = 0x0
	// Bit mask of RXSIZE field.
	VFIFO_FIFOCFGSPI_RXSIZE_Msk = 0xff
	// Position of TXSIZE field.
	VFIFO_FIFOCFGSPI_TXSIZE_Pos = 0x8
	// Bit mask of TXSIZE field.
	VFIFO_FIFOCFGSPI_TXSIZE_Msk = 0xff00
	// Position of RESERVED field.
	VFIFO_FIFOCFGSPI_RESERVED_Pos = 0x10
	// Bit mask of RESERVED field.
	VFIFO_FIFOCFGSPI_RESERVED_Msk = 0xffff0000

	// CFGUSART0: USART0 configuration
	// Position of RESERVED field.
	VFIFO_CFGUSART_RESERVED_Pos = 0x0
	// Bit mask of RESERVED field.
	VFIFO_CFGUSART_RESERVED_Msk = 0xf
	// Position of TIMEOUTCONTONWRITE field.
	VFIFO_CFGUSART_TIMEOUTCONTONWRITE_Pos = 0x4
	// Bit mask of TIMEOUTCONTONWRITE field.
	VFIFO_CFGUSART_TIMEOUTCONTONWRITE_Msk = 0x10
	// Bit TIMEOUTCONTONWRITE.
	VFIFO_CFGUSART_TIMEOUTCONTONWRITE = 0x10
	// Position of TIMEOUTCONTONEMPTY field.
	VFIFO_CFGUSART_TIMEOUTCONTONEMPTY_Pos = 0x5
	// Bit mask of TIMEOUTCONTONEMPTY field.
	VFIFO_CFGUSART_TIMEOUTCONTONEMPTY_Msk = 0x20
	// Bit TIMEOUTCONTONEMPTY.
	VFIFO_CFGUSART_TIMEOUTCONTONEMPTY = 0x20
	// Position of RESERVED field.
	VFIFO_CFGUSART_RESERVED_Pos = 0x6
	// Bit mask of RESERVED field.
	VFIFO_CFGUSART_RESERVED_Msk = 0xc0
	// Position of TIMEOUTBASE field.
	VFIFO_CFGUSART_TIMEOUTBASE_Pos = 0x8
	// Bit mask of TIMEOUTBASE field.
	VFIFO_CFGUSART_TIMEOUTBASE_Msk = 0xf00
	// Position of TIMEOUTVALUE field.
	VFIFO_CFGUSART_TIMEOUTVALUE_Pos = 0xc
	// Bit mask of TIMEOUTVALUE field.
	VFIFO_CFGUSART_TIMEOUTVALUE_Msk = 0xf000
	// Position of RXTHRESHOLD field.
	VFIFO_CFGUSART_RXTHRESHOLD_Pos = 0x10
	// Bit mask of RXTHRESHOLD field.
	VFIFO_CFGUSART_RXTHRESHOLD_Msk = 0xff0000
	// Position of TXTHRESHOLD field.
	VFIFO_CFGUSART_TXTHRESHOLD_Pos = 0x18
	// Bit mask of TXTHRESHOLD field.
	VFIFO_CFGUSART_TXTHRESHOLD_Msk = 0xff000000

	// STATUSART0: USART0 status
	// Position of RXTH field.
	VFIFO_STATUSART_RXTH_Pos = 0x0
	// Bit mask of RXTH field.
	VFIFO_STATUSART_RXTH_Msk = 0x1
	// Bit RXTH.
	VFIFO_STATUSART_RXTH = 0x1
	// Position of TXTH field.
	VFIFO_STATUSART_TXTH_Pos = 0x1
	// Bit mask of TXTH field.
	VFIFO_STATUSART_TXTH_Msk = 0x2
	// Bit TXTH.
	VFIFO_STATUSART_TXTH = 0x2
	// Position of RESERVED field.
	VFIFO_STATUSART_RESERVED_Pos = 0x2
	// Bit mask of RESERVED field.
	VFIFO_STATUSART_RESERVED_Msk = 0xc
	// Position of RXTIMEOUT field.
	VFIFO_STATUSART_RXTIMEOUT_Pos = 0x4
	// Bit mask of RXTIMEOUT field.
	VFIFO_STATUSART_RXTIMEOUT_Msk = 0x10
	// Bit RXTIMEOUT.
	VFIFO_STATUSART_RXTIMEOUT = 0x10
	// Position of RESERVED field.
	VFIFO_STATUSART_RESERVED_Pos = 0x5
	// Bit mask of RESERVED field.
	VFIFO_STATUSART_RESERVED_Msk = 0x60
	// Position of BUSERR field.
	VFIFO_STATUSART_BUSERR_Pos = 0x7
	// Bit mask of BUSERR field.
	VFIFO_STATUSART_BUSERR_Msk = 0x80
	// Bit BUSERR.
	VFIFO_STATUSART_BUSERR = 0x80
	// Position of RXEMPTY field.
	VFIFO_STATUSART_RXEMPTY_Pos = 0x8
	// Bit mask of RXEMPTY field.
	VFIFO_STATUSART_RXEMPTY_Msk = 0x100
	// Bit RXEMPTY.
	VFIFO_STATUSART_RXEMPTY = 0x100
	// Position of TXEMPTY field.
	VFIFO_STATUSART_TXEMPTY_Pos = 0x9
	// Bit mask of TXEMPTY field.
	VFIFO_STATUSART_TXEMPTY_Msk = 0x200
	// Bit TXEMPTY.
	VFIFO_STATUSART_TXEMPTY = 0x200
	// Position of RESERVED field.
	VFIFO_STATUSART_RESERVED_Pos = 0xa
	// Bit mask of RESERVED field.
	VFIFO_STATUSART_RESERVED_Msk = 0xfc00
	// Position of RXCOUNT field.
	VFIFO_STATUSART_RXCOUNT_Pos = 0x10
	// Bit mask of RXCOUNT field.
	VFIFO_STATUSART_RXCOUNT_Msk = 0xff0000
	// Position of TXCOUNT field.
	VFIFO_STATUSART_TXCOUNT_Pos = 0x18
	// Bit mask of TXCOUNT field.
	VFIFO_STATUSART_TXCOUNT_Msk = 0xff000000

	// INTSTATUSART0: USART0 interrupt status
	// Position of RXTH field.
	VFIFO_INTSTATUSART_RXTH_Pos = 0x0
	// Bit mask of RXTH field.
	VFIFO_INTSTATUSART_RXTH_Msk = 0x1
	// Bit RXTH.
	VFIFO_INTSTATUSART_RXTH = 0x1
	// Position of TXTH field.
	VFIFO_INTSTATUSART_TXTH_Pos = 0x1
	// Bit mask of TXTH field.
	VFIFO_INTSTATUSART_TXTH_Msk = 0x2
	// Bit TXTH.
	VFIFO_INTSTATUSART_TXTH = 0x2
	// Position of RESERVED field.
	VFIFO_INTSTATUSART_RESERVED_Pos = 0x2
	// Bit mask of RESERVED field.
	VFIFO_INTSTATUSART_RESERVED_Msk = 0xc
	// Position of RXTIMEOUT field.
	VFIFO_INTSTATUSART_RXTIMEOUT_Pos = 0x4
	// Bit mask of RXTIMEOUT field.
	VFIFO_INTSTATUSART_RXTIMEOUT_Msk = 0x10
	// Bit RXTIMEOUT.
	VFIFO_INTSTATUSART_RXTIMEOUT = 0x10
	// Position of RESERVED field.
	VFIFO_INTSTATUSART_RESERVED_Pos = 0x5
	// Bit mask of RESERVED field.
	VFIFO_INTSTATUSART_RESERVED_Msk = 0x60
	// Position of BUSERR field.
	VFIFO_INTSTATUSART_BUSERR_Pos = 0x7
	// Bit mask of BUSERR field.
	VFIFO_INTSTATUSART_BUSERR_Msk = 0x80
	// Bit BUSERR.
	VFIFO_INTSTATUSART_BUSERR = 0x80
	// Position of RXEMPTY field.
	VFIFO_INTSTATUSART_RXEMPTY_Pos = 0x8
	// Bit mask of RXEMPTY field.
	VFIFO_INTSTATUSART_RXEMPTY_Msk = 0x100
	// Bit RXEMPTY.
	VFIFO_INTSTATUSART_RXEMPTY = 0x100
	// Position of TXEMPTY field.
	VFIFO_INTSTATUSART_TXEMPTY_Pos = 0x9
	// Bit mask of TXEMPTY field.
	VFIFO_INTSTATUSART_TXEMPTY_Msk = 0x200
	// Bit TXEMPTY.
	VFIFO_INTSTATUSART_TXEMPTY = 0x200
	// Position of RESERVED field.
	VFIFO_INTSTATUSART_RESERVED_Pos = 0xa
	// Bit mask of RESERVED field.
	VFIFO_INTSTATUSART_RESERVED_Msk = 0xfc00
	// Position of RXCOUNT field.
	VFIFO_INTSTATUSART_RXCOUNT_Pos = 0x10
	// Bit mask of RXCOUNT field.
	VFIFO_INTSTATUSART_RXCOUNT_Msk = 0xff0000
	// Position of TXCOUNT field.
	VFIFO_INTSTATUSART_TXCOUNT_Pos = 0x18
	// Bit mask of TXCOUNT field.
	VFIFO_INTSTATUSART_TXCOUNT_Msk = 0xff000000

	// CTLSETUSART0: USART0 control read and set register. A complete value may be read from this register. Writing a 1 to any implemented bit position causes that bit to be set.
	// Position of RXTHINTEN field.
	VFIFO_CTLSETUSART_RXTHINTEN_Pos = 0x0
	// Bit mask of RXTHINTEN field.
	VFIFO_CTLSETUSART_RXTHINTEN_Msk = 0x1
	// Bit RXTHINTEN.
	VFIFO_CTLSETUSART_RXTHINTEN = 0x1
	// Position of TXTHINTEN field.
	VFIFO_CTLSETUSART_TXTHINTEN_Pos = 0x1
	// Bit mask of TXTHINTEN field.
	VFIFO_CTLSETUSART_TXTHINTEN_Msk = 0x2
	// Bit TXTHINTEN.
	VFIFO_CTLSETUSART_TXTHINTEN = 0x2
	// Position of RESERVED field.
	VFIFO_CTLSETUSART_RESERVED_Pos = 0x2
	// Bit mask of RESERVED field.
	VFIFO_CTLSETUSART_RESERVED_Msk = 0xc
	// Position of RXTIMEOUTINTEN field.
	VFIFO_CTLSETUSART_RXTIMEOUTINTEN_Pos = 0x4
	// Bit mask of RXTIMEOUTINTEN field.
	VFIFO_CTLSETUSART_RXTIMEOUTINTEN_Msk = 0x10
	// Bit RXTIMEOUTINTEN.
	VFIFO_CTLSETUSART_RXTIMEOUTINTEN = 0x10
	// Position of RESERVED field.
	VFIFO_CTLSETUSART_RESERVED_Pos = 0x5
	// Bit mask of RESERVED field.
	VFIFO_CTLSETUSART_RESERVED_Msk = 0xe0
	// Position of RXFLUSH field.
	VFIFO_CTLSETUSART_RXFLUSH_Pos = 0x8
	// Bit mask of RXFLUSH field.
	VFIFO_CTLSETUSART_RXFLUSH_Msk = 0x100
	// Bit RXFLUSH.
	VFIFO_CTLSETUSART_RXFLUSH = 0x100
	// Position of TXFLUSH field.
	VFIFO_CTLSETUSART_TXFLUSH_Pos = 0x9
	// Bit mask of TXFLUSH field.
	VFIFO_CTLSETUSART_TXFLUSH_Msk = 0x200
	// Bit TXFLUSH.
	VFIFO_CTLSETUSART_TXFLUSH = 0x200
	// Position of RESERVED field.
	VFIFO_CTLSETUSART_RESERVED_Pos = 0xa
	// Bit mask of RESERVED field.
	VFIFO_CTLSETUSART_RESERVED_Msk = 0xfffffc00

	// CTLCLRUSART0: USART0 control clear register. Writing a 1 to any implemented bit position causes the corresponding bit in the related CTLSET register to be cleared.
	// Position of RXTHINTCLR field.
	VFIFO_CTLCLRUSART_RXTHINTCLR_Pos = 0x0
	// Bit mask of RXTHINTCLR field.
	VFIFO_CTLCLRUSART_RXTHINTCLR_Msk = 0x1
	// Bit RXTHINTCLR.
	VFIFO_CTLCLRUSART_RXTHINTCLR = 0x1
	// Position of TXTHINTCLR field.
	VFIFO_CTLCLRUSART_TXTHINTCLR_Pos = 0x1
	// Bit mask of TXTHINTCLR field.
	VFIFO_CTLCLRUSART_TXTHINTCLR_Msk = 0x2
	// Bit TXTHINTCLR.
	VFIFO_CTLCLRUSART_TXTHINTCLR = 0x2
	// Position of RESERVED field.
	VFIFO_CTLCLRUSART_RESERVED_Pos = 0x2
	// Bit mask of RESERVED field.
	VFIFO_CTLCLRUSART_RESERVED_Msk = 0xc
	// Position of RXTIMEOUTINTCLR field.
	VFIFO_CTLCLRUSART_RXTIMEOUTINTCLR_Pos = 0x4
	// Bit mask of RXTIMEOUTINTCLR field.
	VFIFO_CTLCLRUSART_RXTIMEOUTINTCLR_Msk = 0x10
	// Bit RXTIMEOUTINTCLR.
	VFIFO_CTLCLRUSART_RXTIMEOUTINTCLR = 0x10
	// Position of RESERVED field.
	VFIFO_CTLCLRUSART_RESERVED_Pos = 0x5
	// Bit mask of RESERVED field.
	VFIFO_CTLCLRUSART_RESERVED_Msk = 0xe0
	// Position of RXFLUSHCLR field.
	VFIFO_CTLCLRUSART_RXFLUSHCLR_Pos = 0x8
	// Bit mask of RXFLUSHCLR field.
	VFIFO_CTLCLRUSART_RXFLUSHCLR_Msk = 0x100
	// Bit RXFLUSHCLR.
	VFIFO_CTLCLRUSART_RXFLUSHCLR = 0x100
	// Position of TXFLUSHCLR field.
	VFIFO_CTLCLRUSART_TXFLUSHCLR_Pos = 0x9
	// Bit mask of TXFLUSHCLR field.
	VFIFO_CTLCLRUSART_TXFLUSHCLR_Msk = 0x200
	// Bit TXFLUSHCLR.
	VFIFO_CTLCLRUSART_TXFLUSHCLR = 0x200
	// Position of RESERVED field.
	VFIFO_CTLCLRUSART_RESERVED_Pos = 0xa
	// Bit mask of RESERVED field.
	VFIFO_CTLCLRUSART_RESERVED_Msk = 0xfffffc00

	// RXDATUSART0: USART0 received data
	// Position of RXDAT field.
	VFIFO_RXDATUSART_RXDAT_Pos = 0x0
	// Bit mask of RXDAT field.
	VFIFO_RXDATUSART_RXDAT_Msk = 0x1ff
	// Position of RESERVED field.
	VFIFO_RXDATUSART_RESERVED_Pos = 0x9
	// Bit mask of RESERVED field.
	VFIFO_RXDATUSART_RESERVED_Msk = 0xfffffe00

	// RXDATSTATUSART0: USART0 received data with status
	// Position of RXDAT field.
	VFIFO_RXDATSTATUSART_RXDAT_Pos = 0x0
	// Bit mask of RXDAT field.
	VFIFO_RXDATSTATUSART_RXDAT_Msk = 0x1ff
	// Position of RESERVED field.
	VFIFO_RXDATSTATUSART_RESERVED_Pos = 0x9
	// Bit mask of RESERVED field.
	VFIFO_RXDATSTATUSART_RESERVED_Msk = 0x1e00
	// Position of FRAMERR field.
	VFIFO_RXDATSTATUSART_FRAMERR_Pos = 0xd
	// Bit mask of FRAMERR field.
	VFIFO_RXDATSTATUSART_FRAMERR_Msk = 0x2000
	// Bit FRAMERR.
	VFIFO_RXDATSTATUSART_FRAMERR = 0x2000
	// Position of PARITYERR field.
	VFIFO_RXDATSTATUSART_PARITYERR_Pos = 0xe
	// Bit mask of PARITYERR field.
	VFIFO_RXDATSTATUSART_PARITYERR_Msk = 0x4000
	// Bit PARITYERR.
	VFIFO_RXDATSTATUSART_PARITYERR = 0x4000
	// Position of RXNOISE field.
	VFIFO_RXDATSTATUSART_RXNOISE_Pos = 0xf
	// Bit mask of RXNOISE field.
	VFIFO_RXDATSTATUSART_RXNOISE_Msk = 0x8000
	// Bit RXNOISE.
	VFIFO_RXDATSTATUSART_RXNOISE = 0x8000
	// Position of RESERVED field.
	VFIFO_RXDATSTATUSART_RESERVED_Pos = 0x10
	// Bit mask of RESERVED field.
	VFIFO_RXDATSTATUSART_RESERVED_Msk = 0xffff0000

	// TXDATUSART0: USART0 transmit data
	// Position of TXDAT field.
	VFIFO_TXDATUSART_TXDAT_Pos = 0x0
	// Bit mask of TXDAT field.
	VFIFO_TXDATUSART_TXDAT_Msk = 0x1ff
	// Position of RESERVED field.
	VFIFO_TXDATUSART_RESERVED_Pos = 0x9
	// Bit mask of RESERVED field.
	VFIFO_TXDATUSART_RESERVED_Msk = 0xfffffe00

	// CFGSPI0: SPI0 configuration
	// Position of RESERVED field.
	VFIFO_CFGSPI_RESERVED_Pos = 0x0
	// Bit mask of RESERVED field.
	VFIFO_CFGSPI_RESERVED_Msk = 0xf
	// Position of TIMEOUTCONTONWRITE field.
	VFIFO_CFGSPI_TIMEOUTCONTONWRITE_Pos = 0x4
	// Bit mask of TIMEOUTCONTONWRITE field.
	VFIFO_CFGSPI_TIMEOUTCONTONWRITE_Msk = 0x10
	// Bit TIMEOUTCONTONWRITE.
	VFIFO_CFGSPI_TIMEOUTCONTONWRITE = 0x10
	// Position of TIMEOUTCONTONEMPTY field.
	VFIFO_CFGSPI_TIMEOUTCONTONEMPTY_Pos = 0x5
	// Bit mask of TIMEOUTCONTONEMPTY field.
	VFIFO_CFGSPI_TIMEOUTCONTONEMPTY_Msk = 0x20
	// Bit TIMEOUTCONTONEMPTY.
	VFIFO_CFGSPI_TIMEOUTCONTONEMPTY = 0x20
	// Position of RESERVED field.
	VFIFO_CFGSPI_RESERVED_Pos = 0x6
	// Bit mask of RESERVED field.
	VFIFO_CFGSPI_RESERVED_Msk = 0xc0
	// Position of TIMEOUTBASE field.
	VFIFO_CFGSPI_TIMEOUTBASE_Pos = 0x8
	// Bit mask of TIMEOUTBASE field.
	VFIFO_CFGSPI_TIMEOUTBASE_Msk = 0xf00
	// Position of TIMEOUTVALUE field.
	VFIFO_CFGSPI_TIMEOUTVALUE_Pos = 0xc
	// Bit mask of TIMEOUTVALUE field.
	VFIFO_CFGSPI_TIMEOUTVALUE_Msk = 0xf000
	// Position of RXTHRESHOLD field.
	VFIFO_CFGSPI_RXTHRESHOLD_Pos = 0x10
	// Bit mask of RXTHRESHOLD field.
	VFIFO_CFGSPI_RXTHRESHOLD_Msk = 0xff0000
	// Position of TXTHRESHOLD field.
	VFIFO_CFGSPI_TXTHRESHOLD_Pos = 0x18
	// Bit mask of TXTHRESHOLD field.
	VFIFO_CFGSPI_TXTHRESHOLD_Msk = 0xff000000

	// STATSPI0: SPI0 status
	// Position of RXTH field.
	VFIFO_STATSPI_RXTH_Pos = 0x0
	// Bit mask of RXTH field.
	VFIFO_STATSPI_RXTH_Msk = 0x1
	// Bit RXTH.
	VFIFO_STATSPI_RXTH = 0x1
	// Position of TXTH field.
	VFIFO_STATSPI_TXTH_Pos = 0x1
	// Bit mask of TXTH field.
	VFIFO_STATSPI_TXTH_Msk = 0x2
	// Bit TXTH.
	VFIFO_STATSPI_TXTH = 0x2
	// Position of RESERVED field.
	VFIFO_STATSPI_RESERVED_Pos = 0x2
	// Bit mask of RESERVED field.
	VFIFO_STATSPI_RESERVED_Msk = 0xc
	// Position of RXTIMEOUT field.
	VFIFO_STATSPI_RXTIMEOUT_Pos = 0x4
	// Bit mask of RXTIMEOUT field.
	VFIFO_STATSPI_RXTIMEOUT_Msk = 0x10
	// Bit RXTIMEOUT.
	VFIFO_STATSPI_RXTIMEOUT = 0x10
	// Position of RESERVED field.
	VFIFO_STATSPI_RESERVED_Pos = 0x5
	// Bit mask of RESERVED field.
	VFIFO_STATSPI_RESERVED_Msk = 0x60
	// Position of BUSERR field.
	VFIFO_STATSPI_BUSERR_Pos = 0x7
	// Bit mask of BUSERR field.
	VFIFO_STATSPI_BUSERR_Msk = 0x80
	// Bit BUSERR.
	VFIFO_STATSPI_BUSERR = 0x80
	// Position of RXEMPTY field.
	VFIFO_STATSPI_RXEMPTY_Pos = 0x8
	// Bit mask of RXEMPTY field.
	VFIFO_STATSPI_RXEMPTY_Msk = 0x100
	// Bit RXEMPTY.
	VFIFO_STATSPI_RXEMPTY = 0x100
	// Position of TXEMPTY field.
	VFIFO_STATSPI_TXEMPTY_Pos = 0x9
	// Bit mask of TXEMPTY field.
	VFIFO_STATSPI_TXEMPTY_Msk = 0x200
	// Bit TXEMPTY.
	VFIFO_STATSPI_TXEMPTY = 0x200
	// Position of RESERVED field.
	VFIFO_STATSPI_RESERVED_Pos = 0xa
	// Bit mask of RESERVED field.
	VFIFO_STATSPI_RESERVED_Msk = 0xfc00
	// Position of RXCOUNT field.
	VFIFO_STATSPI_RXCOUNT_Pos = 0x10
	// Bit mask of RXCOUNT field.
	VFIFO_STATSPI_RXCOUNT_Msk = 0xff0000
	// Position of TXCOUNT field.
	VFIFO_STATSPI_TXCOUNT_Pos = 0x18
	// Bit mask of TXCOUNT field.
	VFIFO_STATSPI_TXCOUNT_Msk = 0xff000000

	// INTSTATSPI0: SPI0 interrupt status
	// Position of RXTH field.
	VFIFO_INTSTATSPI_RXTH_Pos = 0x0
	// Bit mask of RXTH field.
	VFIFO_INTSTATSPI_RXTH_Msk = 0x1
	// Bit RXTH.
	VFIFO_INTSTATSPI_RXTH = 0x1
	// Position of TXTH field.
	VFIFO_INTSTATSPI_TXTH_Pos = 0x1
	// Bit mask of TXTH field.
	VFIFO_INTSTATSPI_TXTH_Msk = 0x2
	// Bit TXTH.
	VFIFO_INTSTATSPI_TXTH = 0x2
	// Position of RESERVED field.
	VFIFO_INTSTATSPI_RESERVED_Pos = 0x2
	// Bit mask of RESERVED field.
	VFIFO_INTSTATSPI_RESERVED_Msk = 0xc
	// Position of RXTIMEOUT field.
	VFIFO_INTSTATSPI_RXTIMEOUT_Pos = 0x4
	// Bit mask of RXTIMEOUT field.
	VFIFO_INTSTATSPI_RXTIMEOUT_Msk = 0x10
	// Bit RXTIMEOUT.
	VFIFO_INTSTATSPI_RXTIMEOUT = 0x10
	// Position of RESERVED field.
	VFIFO_INTSTATSPI_RESERVED_Pos = 0x5
	// Bit mask of RESERVED field.
	VFIFO_INTSTATSPI_RESERVED_Msk = 0x60
	// Position of BUSERR field.
	VFIFO_INTSTATSPI_BUSERR_Pos = 0x7
	// Bit mask of BUSERR field.
	VFIFO_INTSTATSPI_BUSERR_Msk = 0x80
	// Bit BUSERR.
	VFIFO_INTSTATSPI_BUSERR = 0x80
	// Position of RXEMPTY field.
	VFIFO_INTSTATSPI_RXEMPTY_Pos = 0x8
	// Bit mask of RXEMPTY field.
	VFIFO_INTSTATSPI_RXEMPTY_Msk = 0x100
	// Bit RXEMPTY.
	VFIFO_INTSTATSPI_RXEMPTY = 0x100
	// Position of TXEMPTY field.
	VFIFO_INTSTATSPI_TXEMPTY_Pos = 0x9
	// Bit mask of TXEMPTY field.
	VFIFO_INTSTATSPI_TXEMPTY_Msk = 0x200
	// Bit TXEMPTY.
	VFIFO_INTSTATSPI_TXEMPTY = 0x200
	// Position of RESERVED field.
	VFIFO_INTSTATSPI_RESERVED_Pos = 0xa
	// Bit mask of RESERVED field.
	VFIFO_INTSTATSPI_RESERVED_Msk = 0xfc00
	// Position of RXCOUNT field.
	VFIFO_INTSTATSPI_RXCOUNT_Pos = 0x10
	// Bit mask of RXCOUNT field.
	VFIFO_INTSTATSPI_RXCOUNT_Msk = 0xff0000
	// Position of TXCOUNT field.
	VFIFO_INTSTATSPI_TXCOUNT_Pos = 0x18
	// Bit mask of TXCOUNT field.
	VFIFO_INTSTATSPI_TXCOUNT_Msk = 0xff000000

	// CTLSETSPI0: SPI0 control read and set register. A complete value may be read from this register. Writing a 1 to any implemented bit position causes that bit to be set.
	// Position of RXTHINTEN field.
	VFIFO_CTLSETSPI_RXTHINTEN_Pos = 0x0
	// Bit mask of RXTHINTEN field.
	VFIFO_CTLSETSPI_RXTHINTEN_Msk = 0x1
	// Bit RXTHINTEN.
	VFIFO_CTLSETSPI_RXTHINTEN = 0x1
	// Position of TXTHINTEN field.
	VFIFO_CTLSETSPI_TXTHINTEN_Pos = 0x1
	// Bit mask of TXTHINTEN field.
	VFIFO_CTLSETSPI_TXTHINTEN_Msk = 0x2
	// Bit TXTHINTEN.
	VFIFO_CTLSETSPI_TXTHINTEN = 0x2
	// Position of RESERVED field.
	VFIFO_CTLSETSPI_RESERVED_Pos = 0x2
	// Bit mask of RESERVED field.
	VFIFO_CTLSETSPI_RESERVED_Msk = 0xc
	// Position of RXTIMEOUTINTEN field.
	VFIFO_CTLSETSPI_RXTIMEOUTINTEN_Pos = 0x4
	// Bit mask of RXTIMEOUTINTEN field.
	VFIFO_CTLSETSPI_RXTIMEOUTINTEN_Msk = 0x10
	// Bit RXTIMEOUTINTEN.
	VFIFO_CTLSETSPI_RXTIMEOUTINTEN = 0x10
	// Position of RESERVED field.
	VFIFO_CTLSETSPI_RESERVED_Pos = 0x5
	// Bit mask of RESERVED field.
	VFIFO_CTLSETSPI_RESERVED_Msk = 0xe0
	// Position of RXFLUSH field.
	VFIFO_CTLSETSPI_RXFLUSH_Pos = 0x8
	// Bit mask of RXFLUSH field.
	VFIFO_CTLSETSPI_RXFLUSH_Msk = 0x100
	// Bit RXFLUSH.
	VFIFO_CTLSETSPI_RXFLUSH = 0x100
	// Position of TXFLUSH field.
	VFIFO_CTLSETSPI_TXFLUSH_Pos = 0x9
	// Bit mask of TXFLUSH field.
	VFIFO_CTLSETSPI_TXFLUSH_Msk = 0x200
	// Bit TXFLUSH.
	VFIFO_CTLSETSPI_TXFLUSH = 0x200
	// Position of RESERVED field.
	VFIFO_CTLSETSPI_RESERVED_Pos = 0xa
	// Bit mask of RESERVED field.
	VFIFO_CTLSETSPI_RESERVED_Msk = 0xfffffc00

	// CTLCLRSPI0: SPI0 control clear register. Writing a 1 to any implemented bit position causes the corresponding bit in the related CTLSET register to be cleared.
	// Position of RESERVED field.
	VFIFO_CTLCLRSPI_RESERVED_Pos = 0x0
	// Bit mask of RESERVED field.
	VFIFO_CTLCLRSPI_RESERVED_Msk = 0xffffffff
	// Position of RXTHINTCLR field.
	VFIFO_CTLCLRSPI_RXTHINTCLR_Pos = 0x0
	// Bit mask of RXTHINTCLR field.
	VFIFO_CTLCLRSPI_RXTHINTCLR_Msk = 0x1
	// Bit RXTHINTCLR.
	VFIFO_CTLCLRSPI_RXTHINTCLR = 0x1
	// Position of TXTHINTCLR field.
	VFIFO_CTLCLRSPI_TXTHINTCLR_Pos = 0x1
	// Bit mask of TXTHINTCLR field.
	VFIFO_CTLCLRSPI_TXTHINTCLR_Msk = 0x2
	// Bit TXTHINTCLR.
	VFIFO_CTLCLRSPI_TXTHINTCLR = 0x2
	// Position of RESERVED field.
	VFIFO_CTLCLRSPI_RESERVED_Pos = 0x2
	// Bit mask of RESERVED field.
	VFIFO_CTLCLRSPI_RESERVED_Msk = 0xc
	// Position of RXTIMEOUTINTCLR field.
	VFIFO_CTLCLRSPI_RXTIMEOUTINTCLR_Pos = 0x4
	// Bit mask of RXTIMEOUTINTCLR field.
	VFIFO_CTLCLRSPI_RXTIMEOUTINTCLR_Msk = 0x10
	// Bit RXTIMEOUTINTCLR.
	VFIFO_CTLCLRSPI_RXTIMEOUTINTCLR = 0x10
	// Position of RESERVED field.
	VFIFO_CTLCLRSPI_RESERVED_Pos = 0x5
	// Bit mask of RESERVED field.
	VFIFO_CTLCLRSPI_RESERVED_Msk = 0xe0
	// Position of RXFLUSHCLR field.
	VFIFO_CTLCLRSPI_RXFLUSHCLR_Pos = 0x8
	// Bit mask of RXFLUSHCLR field.
	VFIFO_CTLCLRSPI_RXFLUSHCLR_Msk = 0x100
	// Bit RXFLUSHCLR.
	VFIFO_CTLCLRSPI_RXFLUSHCLR = 0x100
	// Position of TXFLUSHCLR field.
	VFIFO_CTLCLRSPI_TXFLUSHCLR_Pos = 0x9
	// Bit mask of TXFLUSHCLR field.
	VFIFO_CTLCLRSPI_TXFLUSHCLR_Msk = 0x200
	// Bit TXFLUSHCLR.
	VFIFO_CTLCLRSPI_TXFLUSHCLR = 0x200
	// Position of RESERVED field.
	VFIFO_CTLCLRSPI_RESERVED_Pos = 0xa
	// Bit mask of RESERVED field.
	VFIFO_CTLCLRSPI_RESERVED_Msk = 0xfffffc00

	// RXDATSPI0: SPI0 received data. These registers are half word addressable.
	// Position of RXDAT field.
	VFIFO_RXDATSPI_RXDAT_Pos = 0x0
	// Bit mask of RXDAT field.
	VFIFO_RXDATSPI_RXDAT_Msk = 0xffff
	// Position of RXSSEL0_N field.
	VFIFO_RXDATSPI_RXSSEL0_N_Pos = 0x10
	// Bit mask of RXSSEL0_N field.
	VFIFO_RXDATSPI_RXSSEL0_N_Msk = 0x10000
	// Bit RXSSEL0_N.
	VFIFO_RXDATSPI_RXSSEL0_N = 0x10000
	// Position of RXSSEL1_N field.
	VFIFO_RXDATSPI_RXSSEL1_N_Pos = 0x11
	// Bit mask of RXSSEL1_N field.
	VFIFO_RXDATSPI_RXSSEL1_N_Msk = 0x20000
	// Bit RXSSEL1_N.
	VFIFO_RXDATSPI_RXSSEL1_N = 0x20000
	// Position of RXSSEL2_N field.
	VFIFO_RXDATSPI_RXSSEL2_N_Pos = 0x12
	// Bit mask of RXSSEL2_N field.
	VFIFO_RXDATSPI_RXSSEL2_N_Msk = 0x40000
	// Bit RXSSEL2_N.
	VFIFO_RXDATSPI_RXSSEL2_N = 0x40000
	// Position of RXSSEL3_N field.
	VFIFO_RXDATSPI_RXSSEL3_N_Pos = 0x13
	// Bit mask of RXSSEL3_N field.
	VFIFO_RXDATSPI_RXSSEL3_N_Msk = 0x80000
	// Bit RXSSEL3_N.
	VFIFO_RXDATSPI_RXSSEL3_N = 0x80000
	// Position of SOT field.
	VFIFO_RXDATSPI_SOT_Pos = 0x14
	// Bit mask of SOT field.
	VFIFO_RXDATSPI_SOT_Msk = 0x100000
	// Bit SOT.
	VFIFO_RXDATSPI_SOT = 0x100000
	// Position of RESERVED field.
	VFIFO_RXDATSPI_RESERVED_Pos = 0x15
	// Bit mask of RESERVED field.
	VFIFO_RXDATSPI_RESERVED_Msk = 0xffe00000

	// TXDATSPI0: SPI0 transmit data. These registers are half word addressable.
	// Position of TXDAT field.
	VFIFO_TXDATSPI_TXDAT_Pos = 0x0
	// Bit mask of TXDAT field.
	VFIFO_TXDATSPI_TXDAT_Msk = 0xffff
	// Position of TXSSEL0_N field.
	VFIFO_TXDATSPI_TXSSEL0_N_Pos = 0x10
	// Bit mask of TXSSEL0_N field.
	VFIFO_TXDATSPI_TXSSEL0_N_Msk = 0x10000
	// Bit TXSSEL0_N.
	VFIFO_TXDATSPI_TXSSEL0_N = 0x10000
	// Asserted. SSEL0 asserted.
	VFIFO_TXDATSPI_TXSSEL0_N_ASSERTED = 0x0
	// Not asserted. SSEL0 not asserted.
	VFIFO_TXDATSPI_TXSSEL0_N_NOT_ASSERTED = 0x1
	// Position of TXSSEL1_N field.
	VFIFO_TXDATSPI_TXSSEL1_N_Pos = 0x11
	// Bit mask of TXSSEL1_N field.
	VFIFO_TXDATSPI_TXSSEL1_N_Msk = 0x20000
	// Bit TXSSEL1_N.
	VFIFO_TXDATSPI_TXSSEL1_N = 0x20000
	// Asserted. SSEL1 asserted.
	VFIFO_TXDATSPI_TXSSEL1_N_ASSERTED = 0x0
	// Not asserted. SSEL1 not asserted.
	VFIFO_TXDATSPI_TXSSEL1_N_NOT_ASSERTED = 0x1
	// Position of TXSSEL2_N field.
	VFIFO_TXDATSPI_TXSSEL2_N_Pos = 0x12
	// Bit mask of TXSSEL2_N field.
	VFIFO_TXDATSPI_TXSSEL2_N_Msk = 0x40000
	// Bit TXSSEL2_N.
	VFIFO_TXDATSPI_TXSSEL2_N = 0x40000
	// Asserted. SSEL2 asserted.
	VFIFO_TXDATSPI_TXSSEL2_N_ASSERTED = 0x0
	// Not asserted. SSEL2 not asserted.
	VFIFO_TXDATSPI_TXSSEL2_N_NOT_ASSERTED = 0x1
	// Position of TXSSEL3_N field.
	VFIFO_TXDATSPI_TXSSEL3_N_Pos = 0x13
	// Bit mask of TXSSEL3_N field.
	VFIFO_TXDATSPI_TXSSEL3_N_Msk = 0x80000
	// Bit TXSSEL3_N.
	VFIFO_TXDATSPI_TXSSEL3_N = 0x80000
	// Asserted. SSEL3 asserted.
	VFIFO_TXDATSPI_TXSSEL3_N_ASSERTED = 0x0
	// Not asserted. SSEL3 not asserted.
	VFIFO_TXDATSPI_TXSSEL3_N_NOT_ASSERTED = 0x1
	// Position of EOT field.
	VFIFO_TXDATSPI_EOT_Pos = 0x14
	// Bit mask of EOT field.
	VFIFO_TXDATSPI_EOT_Msk = 0x100000
	// Bit EOT.
	VFIFO_TXDATSPI_EOT = 0x100000
	// Not deasserted. SSEL not deasserted. This piece of data is not treated as the end of a transfer. SSEL will not be deasserted at the end of this data.
	VFIFO_TXDATSPI_EOT_NOT_DEASSERTED = 0x0
	// Deasserted. SSEL deasserted. This piece of data is treated as the end of a transfer. SSEL will be deasserted at the end of this piece of data.
	VFIFO_TXDATSPI_EOT_DEASSERTED = 0x1
	// Position of EOF field.
	VFIFO_TXDATSPI_EOF_Pos = 0x15
	// Bit mask of EOF field.
	VFIFO_TXDATSPI_EOF_Msk = 0x200000
	// Bit EOF.
	VFIFO_TXDATSPI_EOF = 0x200000
	// Data not EOF. This piece of data transmitted is not treated as the end of a frame.
	VFIFO_TXDATSPI_EOF_DATA_NOT_EOF = 0x0
	// Data EOF. This piece of data is treated as the end of a frame, causing the FRAME_DELAY time to be inserted before subsequent data is transmitted.
	VFIFO_TXDATSPI_EOF_DATA_EOF = 0x1
	// Position of RXIGNORE field.
	VFIFO_TXDATSPI_RXIGNORE_Pos = 0x16
	// Bit mask of RXIGNORE field.
	VFIFO_TXDATSPI_RXIGNORE_Msk = 0x400000
	// Bit RXIGNORE.
	VFIFO_TXDATSPI_RXIGNORE = 0x400000
	// Read received data. Received data must be read in order to allow transmission to progress. In slave mode, an overrun error will occur if received data is not read before new data is received.
	VFIFO_TXDATSPI_RXIGNORE_READ_RECEIVED_DATA = 0x0
	// Ignore received data. Received data is ignored, allowing transmission without reading unneeded received data. No receiver flags are generated.
	VFIFO_TXDATSPI_RXIGNORE_IGNORE_RECEIVED_DATA = 0x1
	// Position of RESERVED field.
	VFIFO_TXDATSPI_RESERVED_Pos = 0x17
	// Bit mask of RESERVED field.
	VFIFO_TXDATSPI_RESERVED_Msk = 0x800000
	// Bit RESERVED.
	VFIFO_TXDATSPI_RESERVED = 0x800000
	// Position of LEN field.
	VFIFO_TXDATSPI_LEN_Pos = 0x18
	// Bit mask of LEN field.
	VFIFO_TXDATSPI_LEN_Msk = 0xf000000
	// Position of RESERVED field.
	VFIFO_TXDATSPI_RESERVED_Pos = 0x1c
	// Bit mask of RESERVED field.
	VFIFO_TXDATSPI_RESERVED_Msk = 0xf0000000
)

// Bitfields for SYSCON: System configuration
const (
	// SYSMEMREMAP: System memory remap
	// Position of MAP field.
	SYSCON_SYSMEMREMAP_MAP_Pos = 0x0
	// Bit mask of MAP field.
	SYSCON_SYSMEMREMAP_MAP_Msk = 0x3
	// Boot Loader Mode. Interrupt vectors are re-mapped to Boot ROM.
	SYSCON_SYSMEMREMAP_MAP_BOOT_LOADER_MODE = 0x0
	// User RAM Mode. Interrupt vectors are re-mapped to Static RAM.
	SYSCON_SYSMEMREMAP_MAP_USER_RAM_MODE = 0x1
	// User Flash Mode. Interrupt vectors are not re-mapped and reside in Flash.
	SYSCON_SYSMEMREMAP_MAP_USER_FLASH_MODE = 0x2
	// Position of RESERVED field.
	SYSCON_SYSMEMREMAP_RESERVED_Pos = 0x2
	// Bit mask of RESERVED field.
	SYSCON_SYSMEMREMAP_RESERVED_Msk = 0xfffffffc

	// AHBMATPRIO: AHB multilayer matrix priority control
	// Position of PRI_ICODE field.
	SYSCON_AHBMATPRIO_PRI_ICODE_Pos = 0x0
	// Bit mask of PRI_ICODE field.
	SYSCON_AHBMATPRIO_PRI_ICODE_Msk = 0x3
	// Position of PRI_DCODE field.
	SYSCON_AHBMATPRIO_PRI_DCODE_Pos = 0x2
	// Bit mask of PRI_DCODE field.
	SYSCON_AHBMATPRIO_PRI_DCODE_Msk = 0xc
	// Position of PRI_SYS field.
	SYSCON_AHBMATPRIO_PRI_SYS_Pos = 0x4
	// Bit mask of PRI_SYS field.
	SYSCON_AHBMATPRIO_PRI_SYS_Msk = 0x30
	// Position of RESERVED field.
	SYSCON_AHBMATPRIO_RESERVED_Pos = 0x6
	// Bit mask of RESERVED field.
	SYSCON_AHBMATPRIO_RESERVED_Msk = 0xc0
	// Position of PRI_DMA field.
	SYSCON_AHBMATPRIO_PRI_DMA_Pos = 0x8
	// Bit mask of PRI_DMA field.
	SYSCON_AHBMATPRIO_PRI_DMA_Msk = 0x300
	// Position of RESERVED field.
	SYSCON_AHBMATPRIO_RESERVED_Pos = 0xa
	// Bit mask of RESERVED field.
	SYSCON_AHBMATPRIO_RESERVED_Msk = 0x3c00
	// Position of PRI_FIFO field.
	SYSCON_AHBMATPRIO_PRI_FIFO_Pos = 0xe
	// Bit mask of PRI_FIFO field.
	SYSCON_AHBMATPRIO_PRI_FIFO_Msk = 0xc000
	// Position of PRI_M0 field.
	SYSCON_AHBMATPRIO_PRI_M0_Pos = 0x10
	// Bit mask of PRI_M0 field.
	SYSCON_AHBMATPRIO_PRI_M0_Msk = 0x30000
	// Position of RESERVED field.
	SYSCON_AHBMATPRIO_RESERVED_Pos = 0x12
	// Bit mask of RESERVED field.
	SYSCON_AHBMATPRIO_RESERVED_Msk = 0xfffc0000

	// SYSTCKCAL: System tick counter calibration
	// Position of CAL field.
	SYSCON_SYSTCKCAL_CAL_Pos = 0x0
	// Bit mask of CAL field.
	SYSCON_SYSTCKCAL_CAL_Msk = 0xffffff
	// Position of SKEW field.
	SYSCON_SYSTCKCAL_SKEW_Pos = 0x18
	// Bit mask of SKEW field.
	SYSCON_SYSTCKCAL_SKEW_Msk = 0x1000000
	// Bit SKEW.
	SYSCON_SYSTCKCAL_SKEW = 0x1000000
	// Position of NOREF field.
	SYSCON_SYSTCKCAL_NOREF_Pos = 0x19
	// Bit mask of NOREF field.
	SYSCON_SYSTCKCAL_NOREF_Msk = 0x2000000
	// Bit NOREF.
	SYSCON_SYSTCKCAL_NOREF = 0x2000000
	// Position of RESERVED field.
	SYSCON_SYSTCKCAL_RESERVED_Pos = 0x1a
	// Bit mask of RESERVED field.
	SYSCON_SYSTCKCAL_RESERVED_Msk = 0xfc000000

	// NMISRC: NMI Source Select
	// Position of IRQM4 field.
	SYSCON_NMISRC_IRQM4_Pos = 0x0
	// Bit mask of IRQM4 field.
	SYSCON_NMISRC_IRQM4_Msk = 0x3f
	// Position of RESERVED field.
	SYSCON_NMISRC_RESERVED_Pos = 0x6
	// Bit mask of RESERVED field.
	SYSCON_NMISRC_RESERVED_Msk = 0xc0
	// Position of IRQM0 field.
	SYSCON_NMISRC_IRQM0_Pos = 0x8
	// Bit mask of IRQM0 field.
	SYSCON_NMISRC_IRQM0_Msk = 0x3f00
	// Position of RESERVED field.
	SYSCON_NMISRC_RESERVED_Pos = 0xe
	// Bit mask of RESERVED field.
	SYSCON_NMISRC_RESERVED_Msk = 0x3fffc000
	// Position of NMIENM0 field.
	SYSCON_NMISRC_NMIENM0_Pos = 0x1e
	// Bit mask of NMIENM0 field.
	SYSCON_NMISRC_NMIENM0_Msk = 0x40000000
	// Bit NMIENM0.
	SYSCON_NMISRC_NMIENM0 = 0x40000000
	// Position of NMIENM4 field.
	SYSCON_NMISRC_NMIENM4_Pos = 0x1f
	// Bit mask of NMIENM4 field.
	SYSCON_NMISRC_NMIENM4_Msk = 0x80000000
	// Bit NMIENM4.
	SYSCON_NMISRC_NMIENM4 = 0x80000000

	// ASYNCAPBCTRL: Asynchronous APB Control
	// Position of ENABLE field.
	SYSCON_ASYNCAPBCTRL_ENABLE_Pos = 0x0
	// Bit mask of ENABLE field.
	SYSCON_ASYNCAPBCTRL_ENABLE_Msk = 0x1
	// Bit ENABLE.
	SYSCON_ASYNCAPBCTRL_ENABLE = 0x1
	// Disabled. Asynchronous APB bridge is disabled.
	SYSCON_ASYNCAPBCTRL_ENABLE_DISABLED = 0x0
	// Enabled. Asynchronous APB bridge is enabled.
	SYSCON_ASYNCAPBCTRL_ENABLE_ENABLED = 0x1
	// Position of RESERVED field.
	SYSCON_ASYNCAPBCTRL_RESERVED_Pos = 0x1
	// Bit mask of RESERVED field.
	SYSCON_ASYNCAPBCTRL_RESERVED_Msk = 0xfffffffe

	// SYSRSTSTAT: System reset status register
	// Position of POR field.
	SYSCON_SYSRSTSTAT_POR_Pos = 0x0
	// Bit mask of POR field.
	SYSCON_SYSRSTSTAT_POR_Msk = 0x1
	// Bit POR.
	SYSCON_SYSRSTSTAT_POR = 0x1
	// No POR detected
	SYSCON_SYSRSTSTAT_POR_NO_POR_DETECTED = 0x0
	// POR detected. Writing a one clears this reset.
	SYSCON_SYSRSTSTAT_POR_POR_DETECTED = 0x1
	// Position of EXTRST field.
	SYSCON_SYSRSTSTAT_EXTRST_Pos = 0x1
	// Bit mask of EXTRST field.
	SYSCON_SYSRSTSTAT_EXTRST_Msk = 0x2
	// Bit EXTRST.
	SYSCON_SYSRSTSTAT_EXTRST = 0x2
	// No reset event detected.
	SYSCON_SYSRSTSTAT_EXTRST_NO_RESET_EVENT_DETEC = 0x0
	// Reset detected. Writing a one clears this reset.
	SYSCON_SYSRSTSTAT_EXTRST_RESET_DETECTED = 0x1
	// Position of WDT field.
	SYSCON_SYSRSTSTAT_WDT_Pos = 0x2
	// Bit mask of WDT field.
	SYSCON_SYSRSTSTAT_WDT_Msk = 0x4
	// Bit WDT.
	SYSCON_SYSRSTSTAT_WDT = 0x4
	// No WDT reset detected
	SYSCON_SYSRSTSTAT_WDT_NO_WDT_RESET_DETECTE = 0x0
	// WDT reset detected. Writing a one clears this reset.
	SYSCON_SYSRSTSTAT_WDT_WDT_RESET_DETECTED = 0x1
	// Position of BOD field.
	SYSCON_SYSRSTSTAT_BOD_Pos = 0x3
	// Bit mask of BOD field.
	SYSCON_SYSRSTSTAT_BOD_Msk = 0x8
	// Bit BOD.
	SYSCON_SYSRSTSTAT_BOD = 0x8
	// No BOD reset detected
	SYSCON_SYSRSTSTAT_BOD_NO_BOD_RESET_DETECTE = 0x0
	// BOD reset detected. Writing a one clears this reset.
	SYSCON_SYSRSTSTAT_BOD_BOD_RESET_DETECTED = 0x1
	// Position of SYSRST field.
	SYSCON_SYSRSTSTAT_SYSRST_Pos = 0x4
	// Bit mask of SYSRST field.
	SYSCON_SYSRSTSTAT_SYSRST_Msk = 0x10
	// Bit SYSRST.
	SYSCON_SYSRSTSTAT_SYSRST = 0x10
	// No System reset detected
	SYSCON_SYSRSTSTAT_SYSRST_NO_SYSTEM_RESET_DETE = 0x0
	// System reset detected. Writing a one clears this reset.
	SYSCON_SYSRSTSTAT_SYSRST_SYSTEM_RESET_DETECTE = 0x1
	// Position of RESERVED field.
	SYSCON_SYSRSTSTAT_RESERVED_Pos = 0x5
	// Bit mask of RESERVED field.
	SYSCON_SYSRSTSTAT_RESERVED_Msk = 0xffffffe0

	// PRESETCTRL0: Peripheral reset control 0
	// Position of RESERVED field.
	SYSCON_PRESETCTRL0_RESERVED_Pos = 0x0
	// Bit mask of RESERVED field.
	SYSCON_PRESETCTRL0_RESERVED_Msk = 0x7f
	// Position of FLASH_RST field.
	SYSCON_PRESETCTRL0_FLASH_RST_Pos = 0x7
	// Bit mask of FLASH_RST field.
	SYSCON_PRESETCTRL0_FLASH_RST_Msk = 0x80
	// Bit FLASH_RST.
	SYSCON_PRESETCTRL0_FLASH_RST = 0x80
	// Position of FMC_RST field.
	SYSCON_PRESETCTRL0_FMC_RST_Pos = 0x8
	// Bit mask of FMC_RST field.
	SYSCON_PRESETCTRL0_FMC_RST_Msk = 0x100
	// Bit FMC_RST.
	SYSCON_PRESETCTRL0_FMC_RST = 0x100
	// Position of RESERVED field.
	SYSCON_PRESETCTRL0_RESERVED_Pos = 0x9
	// Bit mask of RESERVED field.
	SYSCON_PRESETCTRL0_RESERVED_Msk = 0x600
	// Position of MUX_RST field.
	SYSCON_PRESETCTRL0_MUX_RST_Pos = 0xb
	// Bit mask of MUX_RST field.
	SYSCON_PRESETCTRL0_MUX_RST_Msk = 0x800
	// Bit MUX_RST.
	SYSCON_PRESETCTRL0_MUX_RST = 0x800
	// Position of RESERVED field.
	SYSCON_PRESETCTRL0_RESERVED_Pos = 0xc
	// Bit mask of RESERVED field.
	SYSCON_PRESETCTRL0_RESERVED_Msk = 0x1000
	// Bit RESERVED.
	SYSCON_PRESETCTRL0_RESERVED = 0x1000
	// Position of IOCON_RST field.
	SYSCON_PRESETCTRL0_IOCON_RST_Pos = 0xd
	// Bit mask of IOCON_RST field.
	SYSCON_PRESETCTRL0_IOCON_RST_Msk = 0x2000
	// Bit IOCON_RST.
	SYSCON_PRESETCTRL0_IOCON_RST = 0x2000
	// Position of GPIO0_RST field.
	SYSCON_PRESETCTRL0_GPIO0_RST_Pos = 0xe
	// Bit mask of GPIO0_RST field.
	SYSCON_PRESETCTRL0_GPIO0_RST_Msk = 0x4000
	// Bit GPIO0_RST.
	SYSCON_PRESETCTRL0_GPIO0_RST = 0x4000
	// Position of GPIO1_RST field.
	SYSCON_PRESETCTRL0_GPIO1_RST_Pos = 0xf
	// Bit mask of GPIO1_RST field.
	SYSCON_PRESETCTRL0_GPIO1_RST_Msk = 0x8000
	// Bit GPIO1_RST.
	SYSCON_PRESETCTRL0_GPIO1_RST = 0x8000
	// Position of RESERVED field.
	SYSCON_PRESETCTRL0_RESERVED_Pos = 0x10
	// Bit mask of RESERVED field.
	SYSCON_PRESETCTRL0_RESERVED_Msk = 0x30000
	// Position of PINT_RST field.
	SYSCON_PRESETCTRL0_PINT_RST_Pos = 0x12
	// Bit mask of PINT_RST field.
	SYSCON_PRESETCTRL0_PINT_RST_Msk = 0x40000
	// Bit PINT_RST.
	SYSCON_PRESETCTRL0_PINT_RST = 0x40000
	// Position of GINT_RST field.
	SYSCON_PRESETCTRL0_GINT_RST_Pos = 0x13
	// Bit mask of GINT_RST field.
	SYSCON_PRESETCTRL0_GINT_RST_Msk = 0x80000
	// Bit GINT_RST.
	SYSCON_PRESETCTRL0_GINT_RST = 0x80000
	// Position of DMA_RST field.
	SYSCON_PRESETCTRL0_DMA_RST_Pos = 0x14
	// Bit mask of DMA_RST field.
	SYSCON_PRESETCTRL0_DMA_RST_Msk = 0x100000
	// Bit DMA_RST.
	SYSCON_PRESETCTRL0_DMA_RST = 0x100000
	// Position of CRC_RST field.
	SYSCON_PRESETCTRL0_CRC_RST_Pos = 0x15
	// Bit mask of CRC_RST field.
	SYSCON_PRESETCTRL0_CRC_RST_Msk = 0x200000
	// Bit CRC_RST.
	SYSCON_PRESETCTRL0_CRC_RST = 0x200000
	// Position of WWDT_RST field.
	SYSCON_PRESETCTRL0_WWDT_RST_Pos = 0x16
	// Bit mask of WWDT_RST field.
	SYSCON_PRESETCTRL0_WWDT_RST_Msk = 0x400000
	// Bit WWDT_RST.
	SYSCON_PRESETCTRL0_WWDT_RST = 0x400000
	// Position of RTC_RST field.
	SYSCON_PRESETCTRL0_RTC_RST_Pos = 0x17
	// Bit mask of RTC_RST field.
	SYSCON_PRESETCTRL0_RTC_RST_Msk = 0x800000
	// Bit RTC_RST.
	SYSCON_PRESETCTRL0_RTC_RST = 0x800000
	// Position of RESERVED field.
	SYSCON_PRESETCTRL0_RESERVED_Pos = 0x18
	// Bit mask of RESERVED field.
	SYSCON_PRESETCTRL0_RESERVED_Msk = 0x3000000
	// Position of MAILBOX_RST field.
	SYSCON_PRESETCTRL0_MAILBOX_RST_Pos = 0x1a
	// Bit mask of MAILBOX_RST field.
	SYSCON_PRESETCTRL0_MAILBOX_RST_Msk = 0x4000000
	// Bit MAILBOX_RST.
	SYSCON_PRESETCTRL0_MAILBOX_RST = 0x4000000
	// Position of ADC0_RST field.
	SYSCON_PRESETCTRL0_ADC0_RST_Pos = 0x1b
	// Bit mask of ADC0_RST field.
	SYSCON_PRESETCTRL0_ADC0_RST_Msk = 0x8000000
	// Bit ADC0_RST.
	SYSCON_PRESETCTRL0_ADC0_RST = 0x8000000
	// Position of RESERVED field.
	SYSCON_PRESETCTRL0_RESERVED_Pos = 0x1c
	// Bit mask of RESERVED field.
	SYSCON_PRESETCTRL0_RESERVED_Msk = 0xf0000000

	// PRESETCTRL1: Peripheral reset control 1
	// Position of MRT_RST field.
	SYSCON_PRESETCTRL1_MRT_RST_Pos = 0x0
	// Bit mask of MRT_RST field.
	SYSCON_PRESETCTRL1_MRT_RST_Msk = 0x1
	// Bit MRT_RST.
	SYSCON_PRESETCTRL1_MRT_RST = 0x1
	// Position of RIT_RST field.
	SYSCON_PRESETCTRL1_RIT_RST_Pos = 0x1
	// Bit mask of RIT_RST field.
	SYSCON_PRESETCTRL1_RIT_RST_Msk = 0x2
	// Bit RIT_RST.
	SYSCON_PRESETCTRL1_RIT_RST = 0x2
	// Position of SCT0_RST field.
	SYSCON_PRESETCTRL1_SCT0_RST_Pos = 0x2
	// Bit mask of SCT0_RST field.
	SYSCON_PRESETCTRL1_SCT0_RST_Msk = 0x4
	// Bit SCT0_RST.
	SYSCON_PRESETCTRL1_SCT0_RST = 0x4
	// Position of RESERVED field.
	SYSCON_PRESETCTRL1_RESERVED_Pos = 0x3
	// Bit mask of RESERVED field.
	SYSCON_PRESETCTRL1_RESERVED_Msk = 0x1f8
	// Position of FIFO_RST field.
	SYSCON_PRESETCTRL1_FIFO_RST_Pos = 0x9
	// Bit mask of FIFO_RST field.
	SYSCON_PRESETCTRL1_FIFO_RST_Msk = 0x200
	// Bit FIFO_RST.
	SYSCON_PRESETCTRL1_FIFO_RST = 0x200
	// Position of UTICK_RST field.
	SYSCON_PRESETCTRL1_UTICK_RST_Pos = 0xa
	// Bit mask of UTICK_RST field.
	SYSCON_PRESETCTRL1_UTICK_RST_Msk = 0x400
	// Bit UTICK_RST.
	SYSCON_PRESETCTRL1_UTICK_RST = 0x400
	// Position of RESERVED field.
	SYSCON_PRESETCTRL1_RESERVED_Pos = 0xb
	// Bit mask of RESERVED field.
	SYSCON_PRESETCTRL1_RESERVED_Msk = 0x3ff800
	// Position of TIMER2_RST field.
	SYSCON_PRESETCTRL1_TIMER2_RST_Pos = 0x16
	// Bit mask of TIMER2_RST field.
	SYSCON_PRESETCTRL1_TIMER2_RST_Msk = 0x400000
	// Bit TIMER2_RST.
	SYSCON_PRESETCTRL1_TIMER2_RST = 0x400000
	// Position of RESERVED field.
	SYSCON_PRESETCTRL1_RESERVED_Pos = 0x17
	// Bit mask of RESERVED field.
	SYSCON_PRESETCTRL1_RESERVED_Msk = 0x3800000
	// Position of TIMER3_RST field.
	SYSCON_PRESETCTRL1_TIMER3_RST_Pos = 0x1a
	// Bit mask of TIMER3_RST field.
	SYSCON_PRESETCTRL1_TIMER3_RST_Msk = 0x4000000
	// Bit TIMER3_RST.
	SYSCON_PRESETCTRL1_TIMER3_RST = 0x4000000
	// Position of TIMER4_RST field.
	SYSCON_PRESETCTRL1_TIMER4_RST_Pos = 0x1b
	// Bit mask of TIMER4_RST field.
	SYSCON_PRESETCTRL1_TIMER4_RST_Msk = 0x8000000
	// Bit TIMER4_RST.
	SYSCON_PRESETCTRL1_TIMER4_RST = 0x8000000
	// Position of RESERVED field.
	SYSCON_PRESETCTRL1_RESERVED_Pos = 0x1c
	// Bit mask of RESERVED field.
	SYSCON_PRESETCTRL1_RESERVED_Msk = 0xf0000000

	// PRESETCTRLSET0: Set bits in PRESETCTRL0
	// Position of RST_SET0 field.
	SYSCON_PRESETCTRLSET0_RST_SET0_Pos = 0x0
	// Bit mask of RST_SET0 field.
	SYSCON_PRESETCTRLSET0_RST_SET0_Msk = 0xffffffff

	// PRESETCTRLSET1: Set bits in PRESETCTRL1
	// Position of RST_SET1 field.
	SYSCON_PRESETCTRLSET1_RST_SET1_Pos = 0x0
	// Bit mask of RST_SET1 field.
	SYSCON_PRESETCTRLSET1_RST_SET1_Msk = 0xffffffff

	// PRESETCTRLCLR0: Clear bits in PRESETCTRL0
	// Position of RST_CLR0 field.
	SYSCON_PRESETCTRLCLR0_RST_CLR0_Pos = 0x0
	// Bit mask of RST_CLR0 field.
	SYSCON_PRESETCTRLCLR0_RST_CLR0_Msk = 0xffffffff

	// PRESETCTRLCLR1: Clear bits in PRESETCTRL1
	// Position of RST_CLR1 field.
	SYSCON_PRESETCTRLCLR1_RST_CLR1_Pos = 0x0
	// Bit mask of RST_CLR1 field.
	SYSCON_PRESETCTRLCLR1_RST_CLR1_Msk = 0xffffffff

	// PIOPORCAP0: POR captured PIO status 0
	// Position of PIOPORSTAT field.
	SYSCON_PIOPORCAP0_PIOPORSTAT_Pos = 0x0
	// Bit mask of PIOPORSTAT field.
	SYSCON_PIOPORCAP0_PIOPORSTAT_Msk = 0xffffffff

	// PIOPORCAP1: POR captured PIO status 1
	// Position of PIOPORSTAT field.
	SYSCON_PIOPORCAP1_PIOPORSTAT_Pos = 0x0
	// Bit mask of PIOPORSTAT field.
	SYSCON_PIOPORCAP1_PIOPORSTAT_Msk = 0xffffffff

	// PIORESCAP0: Reset captured PIO status 0
	// Position of PIORESSTAT field.
	SYSCON_PIORESCAP0_PIORESSTAT_Pos = 0x0
	// Bit mask of PIORESSTAT field.
	SYSCON_PIORESCAP0_PIORESSTAT_Msk = 0xffffffff

	// PIORESCAP1: Reset captured PIO status 1
	// Position of PIORESSTAT field.
	SYSCON_PIORESCAP1_PIORESSTAT_Pos = 0x0
	// Bit mask of PIORESSTAT field.
	SYSCON_PIORESCAP1_PIORESSTAT_Msk = 0xffffffff

	// MAINCLKSELA: Main clock source select A
	// Position of SEL field.
	SYSCON_MAINCLKSELA_SEL_Pos = 0x0
	// Bit mask of SEL field.
	SYSCON_MAINCLKSELA_SEL_Msk = 0x3
	// IRC Oscillator
	SYSCON_MAINCLKSELA_SEL_IRC_OSCILLATOR = 0x0
	// CLKIN
	SYSCON_MAINCLKSELA_SEL_CLKIN = 0x1
	// Watchdog oscillator
	SYSCON_MAINCLKSELA_SEL_WATCHDOG_OSCILLATOR = 0x2
	// Position of RESERVED field.
	SYSCON_MAINCLKSELA_RESERVED_Pos = 0x2
	// Bit mask of RESERVED field.
	SYSCON_MAINCLKSELA_RESERVED_Msk = 0xfffffffc

	// MAINCLKSELB: Main clock source select B
	// Position of SEL field.
	SYSCON_MAINCLKSELB_SEL_Pos = 0x0
	// Bit mask of SEL field.
	SYSCON_MAINCLKSELB_SEL_Msk = 0x3
	// MAINCLKSELA. Use the clock source selected in MAINCLKSELA register.
	SYSCON_MAINCLKSELB_SEL_MAINCLKSELA = 0x0
	// System PLL input.
	SYSCON_MAINCLKSELB_SEL_SYSTEM_PLL_INPUT = 0x1
	// System PLL output.
	SYSCON_MAINCLKSELB_SEL_SYSTEM_PLL_OUTPUT = 0x2
	// RTC osc output. RTC oscillator 32 kHz output.
	SYSCON_MAINCLKSELB_SEL_RTC_OSC_OUTPUT = 0x3
	// Position of RESERVED field.
	SYSCON_MAINCLKSELB_RESERVED_Pos = 0x2
	// Bit mask of RESERVED field.
	SYSCON_MAINCLKSELB_RESERVED_Msk = 0xfffffffc

	// ADCCLKSEL: ADC clock source select
	// Position of SEL field.
	SYSCON_ADCCLKSEL_SEL_Pos = 0x0
	// Bit mask of SEL field.
	SYSCON_ADCCLKSEL_SEL_Msk = 0x3
	// Main clock
	SYSCON_ADCCLKSEL_SEL_MAIN_CLOCK = 0x0
	// System PLL output
	SYSCON_ADCCLKSEL_SEL_SYSTEM_PLL_OUTPUT = 0x1
	// IRC Oscillator
	SYSCON_ADCCLKSEL_SEL_IRC_OSCILLATOR = 0x2
	// Position of RESERVED field.
	SYSCON_ADCCLKSEL_RESERVED_Pos = 0x2
	// Bit mask of RESERVED field.
	SYSCON_ADCCLKSEL_RESERVED_Msk = 0xfffffffc

	// CLKOUTSELA: CLKOUT clock source select A
	// Position of SEL field.
	SYSCON_CLKOUTSELA_SEL_Pos = 0x0
	// Bit mask of SEL field.
	SYSCON_CLKOUTSELA_SEL_Msk = 0x3
	// Main clock
	SYSCON_CLKOUTSELA_SEL_MAIN_CLOCK = 0x0
	// CLKIN
	SYSCON_CLKOUTSELA_SEL_CLKIN = 0x1
	// Watchdog oscillator
	SYSCON_CLKOUTSELA_SEL_WATCHDOG_OSCILLATOR = 0x2
	// IRC oscillator
	SYSCON_CLKOUTSELA_SEL_IRC_OSCILLATOR = 0x3
	// Position of RESERVED field.
	SYSCON_CLKOUTSELA_RESERVED_Pos = 0x2
	// Bit mask of RESERVED field.
	SYSCON_CLKOUTSELA_RESERVED_Msk = 0xfffffffc

	// CLKOUTSELB: CLKOUT clock source select B
	// Position of SEL field.
	SYSCON_CLKOUTSELB_SEL_Pos = 0x0
	// Bit mask of SEL field.
	SYSCON_CLKOUTSELB_SEL_Msk = 0x3
	// CLKOUTSELA. Clock source selected in the CLKOUTSELA register.
	SYSCON_CLKOUTSELB_SEL_CLKOUTSELA = 0x0
	// RTC 32 kHz clock
	SYSCON_CLKOUTSELB_SEL_RTC_32_KHZ_CLOCK = 0x3
	// Position of RESERVED field.
	SYSCON_CLKOUTSELB_RESERVED_Pos = 0x2
	// Bit mask of RESERVED field.
	SYSCON_CLKOUTSELB_RESERVED_Msk = 0xfffffffc

	// SYSPLLCLKSEL: PLL clock source select
	// Position of SEL field.
	SYSCON_SYSPLLCLKSEL_SEL_Pos = 0x0
	// Bit mask of SEL field.
	SYSCON_SYSPLLCLKSEL_SEL_Msk = 0x3
	// IRC Oscillator
	SYSCON_SYSPLLCLKSEL_SEL_IRC_OSCILLATOR = 0x0
	// CLKIN
	SYSCON_SYSPLLCLKSEL_SEL_CLKIN = 0x1
	// Watchdog oscillator
	SYSCON_SYSPLLCLKSEL_SEL_WATCHDOG_OSCILLATOR = 0x2
	// RTC 32 kHz clock
	SYSCON_SYSPLLCLKSEL_SEL_RTC_32_KHZ_CLOCK = 0x3
	// Position of RESERVED field.
	SYSCON_SYSPLLCLKSEL_RESERVED_Pos = 0x2
	// Bit mask of RESERVED field.
	SYSCON_SYSPLLCLKSEL_RESERVED_Msk = 0xfffffffc

	// AHBCLKCTRL0: AHB Clock control 0
	// Position of RESERVED field.
	SYSCON_AHBCLKCTRL0_RESERVED_Pos = 0x0
	// Bit mask of RESERVED field.
	SYSCON_AHBCLKCTRL0_RESERVED_Msk = 0x1
	// Bit RESERVED.
	SYSCON_AHBCLKCTRL0_RESERVED = 0x1
	// Position of ROM field.
	SYSCON_AHBCLKCTRL0_ROM_Pos = 0x1
	// Bit mask of ROM field.
	SYSCON_AHBCLKCTRL0_ROM_Msk = 0x2
	// Bit ROM.
	SYSCON_AHBCLKCTRL0_ROM = 0x2
	// Position of RESERVED field.
	SYSCON_AHBCLKCTRL0_RESERVED_Pos = 0x2
	// Bit mask of RESERVED field.
	SYSCON_AHBCLKCTRL0_RESERVED_Msk = 0x4
	// Bit RESERVED.
	SYSCON_AHBCLKCTRL0_RESERVED = 0x4
	// Position of SRAM1 field.
	SYSCON_AHBCLKCTRL0_SRAM1_Pos = 0x3
	// Bit mask of SRAM1 field.
	SYSCON_AHBCLKCTRL0_SRAM1_Msk = 0x8
	// Bit SRAM1.
	SYSCON_AHBCLKCTRL0_SRAM1 = 0x8
	// Position of SRAM2 field.
	SYSCON_AHBCLKCTRL0_SRAM2_Pos = 0x4
	// Bit mask of SRAM2 field.
	SYSCON_AHBCLKCTRL0_SRAM2_Msk = 0x10
	// Bit SRAM2.
	SYSCON_AHBCLKCTRL0_SRAM2 = 0x10
	// Position of RESERVED field.
	SYSCON_AHBCLKCTRL0_RESERVED_Pos = 0x5
	// Bit mask of RESERVED field.
	SYSCON_AHBCLKCTRL0_RESERVED_Msk = 0x60
	// Position of FLASH field.
	SYSCON_AHBCLKCTRL0_FLASH_Pos = 0x7
	// Bit mask of FLASH field.
	SYSCON_AHBCLKCTRL0_FLASH_Msk = 0x80
	// Bit FLASH.
	SYSCON_AHBCLKCTRL0_FLASH = 0x80
	// Position of FMC field.
	SYSCON_AHBCLKCTRL0_FMC_Pos = 0x8
	// Bit mask of FMC field.
	SYSCON_AHBCLKCTRL0_FMC_Msk = 0x100
	// Bit FMC.
	SYSCON_AHBCLKCTRL0_FMC = 0x100
	// Position of RESERVED field.
	SYSCON_AHBCLKCTRL0_RESERVED_Pos = 0x9
	// Bit mask of RESERVED field.
	SYSCON_AHBCLKCTRL0_RESERVED_Msk = 0x600
	// Position of INPUTMUX field.
	SYSCON_AHBCLKCTRL0_INPUTMUX_Pos = 0xb
	// Bit mask of INPUTMUX field.
	SYSCON_AHBCLKCTRL0_INPUTMUX_Msk = 0x800
	// Bit INPUTMUX.
	SYSCON_AHBCLKCTRL0_INPUTMUX = 0x800
	// Position of RESERVED field.
	SYSCON_AHBCLKCTRL0_RESERVED_Pos = 0xc
	// Bit mask of RESERVED field.
	SYSCON_AHBCLKCTRL0_RESERVED_Msk = 0x1000
	// Bit RESERVED.
	SYSCON_AHBCLKCTRL0_RESERVED = 0x1000
	// Position of IOCON field.
	SYSCON_AHBCLKCTRL0_IOCON_Pos = 0xd
	// Bit mask of IOCON field.
	SYSCON_AHBCLKCTRL0_IOCON_Msk = 0x2000
	// Bit IOCON.
	SYSCON_AHBCLKCTRL0_IOCON = 0x2000
	// Position of GPIO0 field.
	SYSCON_AHBCLKCTRL0_GPIO0_Pos = 0xe
	// Bit mask of GPIO0 field.
	SYSCON_AHBCLKCTRL0_GPIO0_Msk = 0x4000
	// Bit GPIO0.
	SYSCON_AHBCLKCTRL0_GPIO0 = 0x4000
	// Position of GPIO1 field.
	SYSCON_AHBCLKCTRL0_GPIO1_Pos = 0xf
	// Bit mask of GPIO1 field.
	SYSCON_AHBCLKCTRL0_GPIO1_Msk = 0x8000
	// Bit GPIO1.
	SYSCON_AHBCLKCTRL0_GPIO1 = 0x8000
	// Position of RESERVED field.
	SYSCON_AHBCLKCTRL0_RESERVED_Pos = 0x10
	// Bit mask of RESERVED field.
	SYSCON_AHBCLKCTRL0_RESERVED_Msk = 0x30000
	// Position of PINT field.
	SYSCON_AHBCLKCTRL0_PINT_Pos = 0x12
	// Bit mask of PINT field.
	SYSCON_AHBCLKCTRL0_PINT_Msk = 0x40000
	// Bit PINT.
	SYSCON_AHBCLKCTRL0_PINT = 0x40000
	// Position of GINT field.
	SYSCON_AHBCLKCTRL0_GINT_Pos = 0x13
	// Bit mask of GINT field.
	SYSCON_AHBCLKCTRL0_GINT_Msk = 0x80000
	// Bit GINT.
	SYSCON_AHBCLKCTRL0_GINT = 0x80000
	// Position of DMA field.
	SYSCON_AHBCLKCTRL0_DMA_Pos = 0x14
	// Bit mask of DMA field.
	SYSCON_AHBCLKCTRL0_DMA_Msk = 0x100000
	// Bit DMA.
	SYSCON_AHBCLKCTRL0_DMA = 0x100000
	// Position of CRC field.
	SYSCON_AHBCLKCTRL0_CRC_Pos = 0x15
	// Bit mask of CRC field.
	SYSCON_AHBCLKCTRL0_CRC_Msk = 0x200000
	// Bit CRC.
	SYSCON_AHBCLKCTRL0_CRC = 0x200000
	// Position of WWDT field.
	SYSCON_AHBCLKCTRL0_WWDT_Pos = 0x16
	// Bit mask of WWDT field.
	SYSCON_AHBCLKCTRL0_WWDT_Msk = 0x400000
	// Bit WWDT.
	SYSCON_AHBCLKCTRL0_WWDT = 0x400000
	// Position of RTC field.
	SYSCON_AHBCLKCTRL0_RTC_Pos = 0x17
	// Bit mask of RTC field.
	SYSCON_AHBCLKCTRL0_RTC_Msk = 0x800000
	// Bit RTC.
	SYSCON_AHBCLKCTRL0_RTC = 0x800000
	// Position of RESERVED field.
	SYSCON_AHBCLKCTRL0_RESERVED_Pos = 0x18
	// Bit mask of RESERVED field.
	SYSCON_AHBCLKCTRL0_RESERVED_Msk = 0x3000000
	// Position of MAILBOX field.
	SYSCON_AHBCLKCTRL0_MAILBOX_Pos = 0x1a
	// Bit mask of MAILBOX field.
	SYSCON_AHBCLKCTRL0_MAILBOX_Msk = 0x4000000
	// Bit MAILBOX.
	SYSCON_AHBCLKCTRL0_MAILBOX = 0x4000000
	// Position of ADC0 field.
	SYSCON_AHBCLKCTRL0_ADC0_Pos = 0x1b
	// Bit mask of ADC0 field.
	SYSCON_AHBCLKCTRL0_ADC0_Msk = 0x8000000
	// Bit ADC0.
	SYSCON_AHBCLKCTRL0_ADC0 = 0x8000000
	// Position of RESERVED field.
	SYSCON_AHBCLKCTRL0_RESERVED_Pos = 0x1c
	// Bit mask of RESERVED field.
	SYSCON_AHBCLKCTRL0_RESERVED_Msk = 0xf0000000

	// AHBCLKCTRL1: AHB Clock control 1
	// Position of MRT field.
	SYSCON_AHBCLKCTRL1_MRT_Pos = 0x0
	// Bit mask of MRT field.
	SYSCON_AHBCLKCTRL1_MRT_Msk = 0x1
	// Bit MRT.
	SYSCON_AHBCLKCTRL1_MRT = 0x1
	// Position of RIT field.
	SYSCON_AHBCLKCTRL1_RIT_Pos = 0x1
	// Bit mask of RIT field.
	SYSCON_AHBCLKCTRL1_RIT_Msk = 0x2
	// Bit RIT.
	SYSCON_AHBCLKCTRL1_RIT = 0x2
	// Position of SCT0 field.
	SYSCON_AHBCLKCTRL1_SCT0_Pos = 0x2
	// Bit mask of SCT0 field.
	SYSCON_AHBCLKCTRL1_SCT0_Msk = 0x4
	// Bit SCT0.
	SYSCON_AHBCLKCTRL1_SCT0 = 0x4
	// Position of RESERVED field.
	SYSCON_AHBCLKCTRL1_RESERVED_Pos = 0x3
	// Bit mask of RESERVED field.
	SYSCON_AHBCLKCTRL1_RESERVED_Msk = 0x1f8
	// Position of FIFO field.
	SYSCON_AHBCLKCTRL1_FIFO_Pos = 0x9
	// Bit mask of FIFO field.
	SYSCON_AHBCLKCTRL1_FIFO_Msk = 0x200
	// Bit FIFO.
	SYSCON_AHBCLKCTRL1_FIFO = 0x200
	// Position of UTICK field.
	SYSCON_AHBCLKCTRL1_UTICK_Pos = 0xa
	// Bit mask of UTICK field.
	SYSCON_AHBCLKCTRL1_UTICK_Msk = 0x400
	// Bit UTICK.
	SYSCON_AHBCLKCTRL1_UTICK = 0x400
	// Position of RESERVED field.
	SYSCON_AHBCLKCTRL1_RESERVED_Pos = 0xb
	// Bit mask of RESERVED field.
	SYSCON_AHBCLKCTRL1_RESERVED_Msk = 0x3ff800
	// Position of TIMER2 field.
	SYSCON_AHBCLKCTRL1_TIMER2_Pos = 0x16
	// Bit mask of TIMER2 field.
	SYSCON_AHBCLKCTRL1_TIMER2_Msk = 0x400000
	// Bit TIMER2.
	SYSCON_AHBCLKCTRL1_TIMER2 = 0x400000
	// Position of RESERVED field.
	SYSCON_AHBCLKCTRL1_RESERVED_Pos = 0x17
	// Bit mask of RESERVED field.
	SYSCON_AHBCLKCTRL1_RESERVED_Msk = 0x3800000
	// Position of TIMER3 field.
	SYSCON_AHBCLKCTRL1_TIMER3_Pos = 0x1a
	// Bit mask of TIMER3 field.
	SYSCON_AHBCLKCTRL1_TIMER3_Msk = 0x4000000
	// Bit TIMER3.
	SYSCON_AHBCLKCTRL1_TIMER3 = 0x4000000
	// Position of TIMER4 field.
	SYSCON_AHBCLKCTRL1_TIMER4_Pos = 0x1b
	// Bit mask of TIMER4 field.
	SYSCON_AHBCLKCTRL1_TIMER4_Msk = 0x8000000
	// Bit TIMER4.
	SYSCON_AHBCLKCTRL1_TIMER4 = 0x8000000
	// Position of RESERVED field.
	SYSCON_AHBCLKCTRL1_RESERVED_Pos = 0x1c
	// Bit mask of RESERVED field.
	SYSCON_AHBCLKCTRL1_RESERVED_Msk = 0xf0000000

	// AHBCLKCTRLSET0: Set bits in AHBCLKCTRL0
	// Position of CLK_SET0 field.
	SYSCON_AHBCLKCTRLSET0_CLK_SET0_Pos = 0x0
	// Bit mask of CLK_SET0 field.
	SYSCON_AHBCLKCTRLSET0_CLK_SET0_Msk = 0xffffffff

	// AHBCLKCTRLSET1: Set bits in AHBCLKCTRL1
	// Position of CLK_SET1 field.
	SYSCON_AHBCLKCTRLSET1_CLK_SET1_Pos = 0x0
	// Bit mask of CLK_SET1 field.
	SYSCON_AHBCLKCTRLSET1_CLK_SET1_Msk = 0xffffffff

	// AHBCLKCTRLCLR0: Clear bits in AHBCLKCTRL0
	// Position of CLK_CLR0 field.
	SYSCON_AHBCLKCTRLCLR0_CLK_CLR0_Pos = 0x0
	// Bit mask of CLK_CLR0 field.
	SYSCON_AHBCLKCTRLCLR0_CLK_CLR0_Msk = 0xffffffff

	// AHBCLKCTRLCLR1: Clear bits in AHBCLKCTRL1
	// Position of CLK_CLR1 field.
	SYSCON_AHBCLKCTRLCLR1_CLK_CLR1_Pos = 0x0
	// Bit mask of CLK_CLR1 field.
	SYSCON_AHBCLKCTRLCLR1_CLK_CLR1_Msk = 0xffffffff

	// SYSTICKCLKDIV: SYSTICK clock divider
	// Position of DIV field.
	SYSCON_SYSTICKCLKDIV_DIV_Pos = 0x0
	// Bit mask of DIV field.
	SYSCON_SYSTICKCLKDIV_DIV_Msk = 0xff
	// Position of RESERVED field.
	SYSCON_SYSTICKCLKDIV_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	SYSCON_SYSTICKCLKDIV_RESERVED_Msk = 0xffffff00

	// AHBCLKDIV: System clock divider
	// Position of DIV field.
	SYSCON_AHBCLKDIV_DIV_Pos = 0x0
	// Bit mask of DIV field.
	SYSCON_AHBCLKDIV_DIV_Msk = 0xff
	// Position of RESERVED field.
	SYSCON_AHBCLKDIV_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	SYSCON_AHBCLKDIV_RESERVED_Msk = 0xffffff00

	// ADCCLKDIV: ADC clock divider
	// Position of DIV field.
	SYSCON_ADCCLKDIV_DIV_Pos = 0x0
	// Bit mask of DIV field.
	SYSCON_ADCCLKDIV_DIV_Msk = 0xff
	// Position of RESERVED field.
	SYSCON_ADCCLKDIV_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	SYSCON_ADCCLKDIV_RESERVED_Msk = 0xffffff00

	// CLKOUTDIV: CLKOUT clock divider
	// Position of DIV field.
	SYSCON_CLKOUTDIV_DIV_Pos = 0x0
	// Bit mask of DIV field.
	SYSCON_CLKOUTDIV_DIV_Msk = 0xff
	// Position of RESERVED field.
	SYSCON_CLKOUTDIV_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	SYSCON_CLKOUTDIV_RESERVED_Msk = 0xffffff00

	// FREQMECTRL: Frequency measure register
	// Position of CAPVAL field.
	SYSCON_FREQMECTRL_CAPVAL_Pos = 0x0
	// Bit mask of CAPVAL field.
	SYSCON_FREQMECTRL_CAPVAL_Msk = 0x3fff
	// Position of RESERVED field.
	SYSCON_FREQMECTRL_RESERVED_Pos = 0xe
	// Bit mask of RESERVED field.
	SYSCON_FREQMECTRL_RESERVED_Msk = 0x7fffc000
	// Position of PROG field.
	SYSCON_FREQMECTRL_PROG_Pos = 0x1f
	// Bit mask of PROG field.
	SYSCON_FREQMECTRL_PROG_Msk = 0x80000000
	// Bit PROG.
	SYSCON_FREQMECTRL_PROG = 0x80000000

	// FLASHCFG: Flash wait states configuration
	// Position of RESERVED field.
	SYSCON_FLASHCFG_RESERVED_Pos = 0x0
	// Bit mask of RESERVED field.
	SYSCON_FLASHCFG_RESERVED_Msk = 0xfff
	// Position of FLASHTIM field.
	SYSCON_FLASHCFG_FLASHTIM_Pos = 0xc
	// Bit mask of FLASHTIM field.
	SYSCON_FLASHCFG_FLASHTIM_Msk = 0x7000
	// 1 clock cycle. 1 system clock flash access time (for system clock frequencies of up to MHz).
	SYSCON_FLASHCFG_FLASHTIM_1_CLOCK_CYCLE = 0x0
	// 2 clock cycles. 2 system clocks flash access time (for system clock frequencies of up to MHz).
	SYSCON_FLASHCFG_FLASHTIM_2_CLOCK_CYCLES = 0x1
	// 3 clock cycles. 3 system clocks flash access time (for system clock frequencies of up to MHz).
	SYSCON_FLASHCFG_FLASHTIM_3_CLOCK_CYCLES = 0x2
	// 4 clock cycles. 4 system clocks flash access time.
	SYSCON_FLASHCFG_FLASHTIM_4_CLOCK_CYCLES = 0x3
	// 5 clock cycles. 5 system clocks flash access time.
	SYSCON_FLASHCFG_FLASHTIM_5_CLOCK_CYCLES = 0x4
	// 6 clock cycles. 6 system clocks flash access time.
	SYSCON_FLASHCFG_FLASHTIM_6_CLOCK_CYCLES = 0x5
	// 7 clock cycles. 7 system clocks flash access time.
	SYSCON_FLASHCFG_FLASHTIM_7_CLOCK_CYCLES = 0x6
	// 8 clock cycles. 8 system clocks flash access time.
	SYSCON_FLASHCFG_FLASHTIM_8_CLOCK_CYCLES = 0x7
	// Position of RESERVED field.
	SYSCON_FLASHCFG_RESERVED_Pos = 0xf
	// Bit mask of RESERVED field.
	SYSCON_FLASHCFG_RESERVED_Msk = 0xffff8000

	// FIFOCTRL: Serial interface FIFO enables
	// Position of U0TXFIFOEN field.
	SYSCON_FIFOCTRL_U0TXFIFOEN_Pos = 0x0
	// Bit mask of U0TXFIFOEN field.
	SYSCON_FIFOCTRL_U0TXFIFOEN_Msk = 0x1
	// Bit U0TXFIFOEN.
	SYSCON_FIFOCTRL_U0TXFIFOEN = 0x1
	// Position of U1TXFIFOEN field.
	SYSCON_FIFOCTRL_U1TXFIFOEN_Pos = 0x1
	// Bit mask of U1TXFIFOEN field.
	SYSCON_FIFOCTRL_U1TXFIFOEN_Msk = 0x2
	// Bit U1TXFIFOEN.
	SYSCON_FIFOCTRL_U1TXFIFOEN = 0x2
	// Position of U2TXFIFOEN field.
	SYSCON_FIFOCTRL_U2TXFIFOEN_Pos = 0x2
	// Bit mask of U2TXFIFOEN field.
	SYSCON_FIFOCTRL_U2TXFIFOEN_Msk = 0x4
	// Bit U2TXFIFOEN.
	SYSCON_FIFOCTRL_U2TXFIFOEN = 0x4
	// Position of U3TXFIFOEN field.
	SYSCON_FIFOCTRL_U3TXFIFOEN_Pos = 0x3
	// Bit mask of U3TXFIFOEN field.
	SYSCON_FIFOCTRL_U3TXFIFOEN_Msk = 0x8
	// Bit U3TXFIFOEN.
	SYSCON_FIFOCTRL_U3TXFIFOEN = 0x8
	// Position of SPI0TXFIFOEN field.
	SYSCON_FIFOCTRL_SPI0TXFIFOEN_Pos = 0x4
	// Bit mask of SPI0TXFIFOEN field.
	SYSCON_FIFOCTRL_SPI0TXFIFOEN_Msk = 0x10
	// Bit SPI0TXFIFOEN.
	SYSCON_FIFOCTRL_SPI0TXFIFOEN = 0x10
	// Position of SPI1TXFIFOEN field.
	SYSCON_FIFOCTRL_SPI1TXFIFOEN_Pos = 0x5
	// Bit mask of SPI1TXFIFOEN field.
	SYSCON_FIFOCTRL_SPI1TXFIFOEN_Msk = 0x20
	// Bit SPI1TXFIFOEN.
	SYSCON_FIFOCTRL_SPI1TXFIFOEN = 0x20
	// Position of RESERVED field.
	SYSCON_FIFOCTRL_RESERVED_Pos = 0x6
	// Bit mask of RESERVED field.
	SYSCON_FIFOCTRL_RESERVED_Msk = 0x40
	// Bit RESERVED.
	SYSCON_FIFOCTRL_RESERVED = 0x40
	// Position of RESERVED field.
	SYSCON_FIFOCTRL_RESERVED_Pos = 0x7
	// Bit mask of RESERVED field.
	SYSCON_FIFOCTRL_RESERVED_Msk = 0x80
	// Bit RESERVED.
	SYSCON_FIFOCTRL_RESERVED = 0x80
	// Position of U0RXFIFOEN field.
	SYSCON_FIFOCTRL_U0RXFIFOEN_Pos = 0x8
	// Bit mask of U0RXFIFOEN field.
	SYSCON_FIFOCTRL_U0RXFIFOEN_Msk = 0x100
	// Bit U0RXFIFOEN.
	SYSCON_FIFOCTRL_U0RXFIFOEN = 0x100
	// Position of U1RXFIFOEN field.
	SYSCON_FIFOCTRL_U1RXFIFOEN_Pos = 0x9
	// Bit mask of U1RXFIFOEN field.
	SYSCON_FIFOCTRL_U1RXFIFOEN_Msk = 0x200
	// Bit U1RXFIFOEN.
	SYSCON_FIFOCTRL_U1RXFIFOEN = 0x200
	// Position of U2RXFIFOEN field.
	SYSCON_FIFOCTRL_U2RXFIFOEN_Pos = 0xa
	// Bit mask of U2RXFIFOEN field.
	SYSCON_FIFOCTRL_U2RXFIFOEN_Msk = 0x400
	// Bit U2RXFIFOEN.
	SYSCON_FIFOCTRL_U2RXFIFOEN = 0x400
	// Position of U3RXFIFOEN field.
	SYSCON_FIFOCTRL_U3RXFIFOEN_Pos = 0xb
	// Bit mask of U3RXFIFOEN field.
	SYSCON_FIFOCTRL_U3RXFIFOEN_Msk = 0x800
	// Bit U3RXFIFOEN.
	SYSCON_FIFOCTRL_U3RXFIFOEN = 0x800
	// Position of SPI0RXFIFOEN field.
	SYSCON_FIFOCTRL_SPI0RXFIFOEN_Pos = 0xc
	// Bit mask of SPI0RXFIFOEN field.
	SYSCON_FIFOCTRL_SPI0RXFIFOEN_Msk = 0x1000
	// Bit SPI0RXFIFOEN.
	SYSCON_FIFOCTRL_SPI0RXFIFOEN = 0x1000
	// Position of SPI1RXFIFOEN field.
	SYSCON_FIFOCTRL_SPI1RXFIFOEN_Pos = 0xd
	// Bit mask of SPI1RXFIFOEN field.
	SYSCON_FIFOCTRL_SPI1RXFIFOEN_Msk = 0x2000
	// Bit SPI1RXFIFOEN.
	SYSCON_FIFOCTRL_SPI1RXFIFOEN = 0x2000
	// Position of RESERVED field.
	SYSCON_FIFOCTRL_RESERVED_Pos = 0xe
	// Bit mask of RESERVED field.
	SYSCON_FIFOCTRL_RESERVED_Msk = 0xffffc000

	// IRCCTRL: IRC oscillator control
	// Position of TRIM field.
	SYSCON_IRCCTRL_TRIM_Pos = 0x0
	// Bit mask of TRIM field.
	SYSCON_IRCCTRL_TRIM_Msk = 0xff
	// Position of RESERVED field.
	SYSCON_IRCCTRL_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	SYSCON_IRCCTRL_RESERVED_Msk = 0xffffff00

	// RTCOSCCTRL: RTC oscillator 32 kHz output control
	// Position of EN field.
	SYSCON_RTCOSCCTRL_EN_Pos = 0x0
	// Bit mask of EN field.
	SYSCON_RTCOSCCTRL_EN_Msk = 0x1
	// Bit EN.
	SYSCON_RTCOSCCTRL_EN = 0x1
	// Disabled. RTC clock off.
	SYSCON_RTCOSCCTRL_EN_DISABLED = 0x0
	// Enabled. RTC clock on.
	SYSCON_RTCOSCCTRL_EN_ENABLED = 0x1
	// Position of RESERVED field.
	SYSCON_RTCOSCCTRL_RESERVED_Pos = 0x1
	// Bit mask of RESERVED field.
	SYSCON_RTCOSCCTRL_RESERVED_Msk = 0xfffffffe

	// SYSPLLCTRL: PLL control
	// Position of SELR field.
	SYSCON_SYSPLLCTRL_SELR_Pos = 0x0
	// Bit mask of SELR field.
	SYSCON_SYSPLLCTRL_SELR_Msk = 0xf
	// Position of SELI field.
	SYSCON_SYSPLLCTRL_SELI_Pos = 0x4
	// Bit mask of SELI field.
	SYSCON_SYSPLLCTRL_SELI_Msk = 0x3f0
	// Position of SELP field.
	SYSCON_SYSPLLCTRL_SELP_Pos = 0xa
	// Bit mask of SELP field.
	SYSCON_SYSPLLCTRL_SELP_Msk = 0x7c00
	// Position of BYPASS field.
	SYSCON_SYSPLLCTRL_BYPASS_Pos = 0xf
	// Bit mask of BYPASS field.
	SYSCON_SYSPLLCTRL_BYPASS_Msk = 0x8000
	// Bit BYPASS.
	SYSCON_SYSPLLCTRL_BYPASS = 0x8000
	// Disabled. PLL CCO is used to create the PLL output.
	SYSCON_SYSPLLCTRL_BYPASS_DISABLED = 0x0
	// Enabled. PLL is bypassed, the PLL input clock is routed directly to the PLL output (default).
	SYSCON_SYSPLLCTRL_BYPASS_ENABLED = 0x1
	// Position of BYPASSCCODIV2 field.
	SYSCON_SYSPLLCTRL_BYPASSCCODIV2_Pos = 0x10
	// Bit mask of BYPASSCCODIV2 field.
	SYSCON_SYSPLLCTRL_BYPASSCCODIV2_Msk = 0x10000
	// Bit BYPASSCCODIV2.
	SYSCON_SYSPLLCTRL_BYPASSCCODIV2 = 0x10000
	// Divide by 2. The CCO feedback clock is divided by 2 in addition to the programmed M divide.
	SYSCON_SYSPLLCTRL_BYPASSCCODIV2_DIVIDE_BY_2 = 0x0
	// Bypass. The CCO feedback clock is divided only by the programmed M divide.
	SYSCON_SYSPLLCTRL_BYPASSCCODIV2_BYPASS = 0x1
	// Position of UPLIMOFF field.
	SYSCON_SYSPLLCTRL_UPLIMOFF_Pos = 0x11
	// Bit mask of UPLIMOFF field.
	SYSCON_SYSPLLCTRL_UPLIMOFF_Msk = 0x20000
	// Bit UPLIMOFF.
	SYSCON_SYSPLLCTRL_UPLIMOFF = 0x20000
	// Normal mode.
	SYSCON_SYSPLLCTRL_UPLIMOFF_NORMAL_MODE = 0x0
	// SSGC mode. Spread spectrum/fractional mode.
	SYSCON_SYSPLLCTRL_UPLIMOFF_SSGC_MODE = 0x1
	// Position of BANDSEL field.
	SYSCON_SYSPLLCTRL_BANDSEL_Pos = 0x12
	// Bit mask of BANDSEL field.
	SYSCON_SYSPLLCTRL_BANDSEL_Msk = 0x40000
	// Bit BANDSEL.
	SYSCON_SYSPLLCTRL_BANDSEL = 0x40000
	// SSCG control. The PLL filter uses the parameters derived from the SSCG decoder.
	SYSCON_SYSPLLCTRL_BANDSEL_SSCG_CONTROL = 0x0
	// MDEC control. The PLL filter uses the programmable fields SELP, SELR, and SELI in this register to control the filter constants.
	SYSCON_SYSPLLCTRL_BANDSEL_MDEC_CONTROL = 0x1
	// Position of DIRECTI field.
	SYSCON_SYSPLLCTRL_DIRECTI_Pos = 0x13
	// Bit mask of DIRECTI field.
	SYSCON_SYSPLLCTRL_DIRECTI_Msk = 0x80000
	// Bit DIRECTI.
	SYSCON_SYSPLLCTRL_DIRECTI = 0x80000
	// Disabled. The PLL input divider (N divider) output is used to drive the PLL CCO.
	SYSCON_SYSPLLCTRL_DIRECTI_DISABLED = 0x0
	// Enabled. The PLL input divider (N divider) is bypassed. the PLL input clock is used directly to drive the PLL CCO.
	SYSCON_SYSPLLCTRL_DIRECTI_ENABLED = 0x1
	// Position of DIRECTO field.
	SYSCON_SYSPLLCTRL_DIRECTO_Pos = 0x14
	// Bit mask of DIRECTO field.
	SYSCON_SYSPLLCTRL_DIRECTO_Msk = 0x100000
	// Bit DIRECTO.
	SYSCON_SYSPLLCTRL_DIRECTO = 0x100000
	// Disabled. The PLL output divider (P divider) is used to create the PLL output.
	SYSCON_SYSPLLCTRL_DIRECTO_DISABLED = 0x0
	// Enabled. The PLL output divider (P divider) is bypassed, the PLL CCO output is used as the PLL output.
	SYSCON_SYSPLLCTRL_DIRECTO_ENABLED = 0x1
	// Position of RESERVED field.
	SYSCON_SYSPLLCTRL_RESERVED_Pos = 0x15
	// Bit mask of RESERVED field.
	SYSCON_SYSPLLCTRL_RESERVED_Msk = 0xffe00000

	// SYSPLLSTAT: PLL status
	// Position of LOCK field.
	SYSCON_SYSPLLSTAT_LOCK_Pos = 0x0
	// Bit mask of LOCK field.
	SYSCON_SYSPLLSTAT_LOCK_Msk = 0x1
	// Bit LOCK.
	SYSCON_SYSPLLSTAT_LOCK = 0x1
	// Position of RESERVED field.
	SYSCON_SYSPLLSTAT_RESERVED_Pos = 0x1
	// Bit mask of RESERVED field.
	SYSCON_SYSPLLSTAT_RESERVED_Msk = 0xfffffffe

	// SYSPLLNDEC: PLL N decoder
	// Position of NDEC field.
	SYSCON_SYSPLLNDEC_NDEC_Pos = 0x0
	// Bit mask of NDEC field.
	SYSCON_SYSPLLNDEC_NDEC_Msk = 0x3ff
	// Position of NREQ field.
	SYSCON_SYSPLLNDEC_NREQ_Pos = 0xa
	// Bit mask of NREQ field.
	SYSCON_SYSPLLNDEC_NREQ_Msk = 0x400
	// Bit NREQ.
	SYSCON_SYSPLLNDEC_NREQ = 0x400
	// Position of RESERVED field.
	SYSCON_SYSPLLNDEC_RESERVED_Pos = 0xb
	// Bit mask of RESERVED field.
	SYSCON_SYSPLLNDEC_RESERVED_Msk = 0xfffff800

	// SYSPLLPDEC: PLL P decoder
	// Position of PDEC field.
	SYSCON_SYSPLLPDEC_PDEC_Pos = 0x0
	// Bit mask of PDEC field.
	SYSCON_SYSPLLPDEC_PDEC_Msk = 0x7f
	// Position of PREQ field.
	SYSCON_SYSPLLPDEC_PREQ_Pos = 0x7
	// Bit mask of PREQ field.
	SYSCON_SYSPLLPDEC_PREQ_Msk = 0x80
	// Bit PREQ.
	SYSCON_SYSPLLPDEC_PREQ = 0x80
	// Position of RESERVED field.
	SYSCON_SYSPLLPDEC_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	SYSCON_SYSPLLPDEC_RESERVED_Msk = 0xffffff00

	// SYSPLLSSCTRL0: PLL spread spectrum control 0
	// Position of MDEC field.
	SYSCON_SYSPLLSSCTRL0_MDEC_Pos = 0x0
	// Bit mask of MDEC field.
	SYSCON_SYSPLLSSCTRL0_MDEC_Msk = 0x1ffff
	// Position of MREQ field.
	SYSCON_SYSPLLSSCTRL0_MREQ_Pos = 0x11
	// Bit mask of MREQ field.
	SYSCON_SYSPLLSSCTRL0_MREQ_Msk = 0x20000
	// Bit MREQ.
	SYSCON_SYSPLLSSCTRL0_MREQ = 0x20000
	// Position of SEL_EXT field.
	SYSCON_SYSPLLSSCTRL0_SEL_EXT_Pos = 0x12
	// Bit mask of SEL_EXT field.
	SYSCON_SYSPLLSSCTRL0_SEL_EXT_Msk = 0x40000
	// Bit SEL_EXT.
	SYSCON_SYSPLLSSCTRL0_SEL_EXT = 0x40000
	// Spread spectrum mode. Spread spectrum mode enabled.
	SYSCON_SYSPLLSSCTRL0_SEL_EXT_SPREAD_SPECTRUM_MODE = 0x0
	// MDEC enabled. Spread spectrum clock generator not used.
	SYSCON_SYSPLLSSCTRL0_SEL_EXT_MDEC_ENABLED = 0x1
	// Position of RESERVED field.
	SYSCON_SYSPLLSSCTRL0_RESERVED_Pos = 0x13
	// Bit mask of RESERVED field.
	SYSCON_SYSPLLSSCTRL0_RESERVED_Msk = 0xfff80000

	// SYSPLLSSCTRL1: PLL spread spectrum control 1
	// Position of MD field.
	SYSCON_SYSPLLSSCTRL1_MD_Pos = 0x0
	// Bit mask of MD field.
	SYSCON_SYSPLLSSCTRL1_MD_Msk = 0x7ffff
	// Position of MDREQ field.
	SYSCON_SYSPLLSSCTRL1_MDREQ_Pos = 0x13
	// Bit mask of MDREQ field.
	SYSCON_SYSPLLSSCTRL1_MDREQ_Msk = 0x80000
	// Bit MDREQ.
	SYSCON_SYSPLLSSCTRL1_MDREQ = 0x80000
	// Position of MF field.
	SYSCON_SYSPLLSSCTRL1_MF_Pos = 0x14
	// Bit mask of MF field.
	SYSCON_SYSPLLSSCTRL1_MF_Msk = 0x700000
	// Position of MR field.
	SYSCON_SYSPLLSSCTRL1_MR_Pos = 0x17
	// Bit mask of MR field.
	SYSCON_SYSPLLSSCTRL1_MR_Msk = 0x3800000
	// Position of MC field.
	SYSCON_SYSPLLSSCTRL1_MC_Pos = 0x1a
	// Bit mask of MC field.
	SYSCON_SYSPLLSSCTRL1_MC_Msk = 0xc000000
	// Position of PD field.
	SYSCON_SYSPLLSSCTRL1_PD_Pos = 0x1c
	// Bit mask of PD field.
	SYSCON_SYSPLLSSCTRL1_PD_Msk = 0x10000000
	// Bit PD.
	SYSCON_SYSPLLSSCTRL1_PD = 0x10000000
	// Enabled. Spread spectrum controller is enabled
	SYSCON_SYSPLLSSCTRL1_PD_ENABLED = 0x0
	// Disabled. Spread spectrum controller is disabled
	SYSCON_SYSPLLSSCTRL1_PD_DISABLED = 0x1
	// Position of DITHER field.
	SYSCON_SYSPLLSSCTRL1_DITHER_Pos = 0x1d
	// Bit mask of DITHER field.
	SYSCON_SYSPLLSSCTRL1_DITHER_Msk = 0x20000000
	// Bit DITHER.
	SYSCON_SYSPLLSSCTRL1_DITHER = 0x20000000
	// Fixed. Fixed modulation frequency.
	SYSCON_SYSPLLSSCTRL1_DITHER_FIXED = 0x0
	// Dither. Randomly dither between two modulation frequencies.
	SYSCON_SYSPLLSSCTRL1_DITHER_DITHER = 0x1
	// Position of RESERVED field.
	SYSCON_SYSPLLSSCTRL1_RESERVED_Pos = 0x1e
	// Bit mask of RESERVED field.
	SYSCON_SYSPLLSSCTRL1_RESERVED_Msk = 0xc0000000

	// PDRUNCFG: Power configuration register
	// Position of RESERVED field.
	SYSCON_PDRUNCFG_RESERVED_Pos = 0x0
	// Bit mask of RESERVED field.
	SYSCON_PDRUNCFG_RESERVED_Msk = 0x7
	// Position of PDEN_IRC_OSC field.
	SYSCON_PDRUNCFG_PDEN_IRC_OSC_Pos = 0x3
	// Bit mask of PDEN_IRC_OSC field.
	SYSCON_PDRUNCFG_PDEN_IRC_OSC_Msk = 0x8
	// Bit PDEN_IRC_OSC.
	SYSCON_PDRUNCFG_PDEN_IRC_OSC = 0x8
	// Position of PDEN_IRC field.
	SYSCON_PDRUNCFG_PDEN_IRC_Pos = 0x4
	// Bit mask of PDEN_IRC field.
	SYSCON_PDRUNCFG_PDEN_IRC_Msk = 0x10
	// Bit PDEN_IRC.
	SYSCON_PDRUNCFG_PDEN_IRC = 0x10
	// Position of PDEN_FLASH field.
	SYSCON_PDRUNCFG_PDEN_FLASH_Pos = 0x5
	// Bit mask of PDEN_FLASH field.
	SYSCON_PDRUNCFG_PDEN_FLASH_Msk = 0x20
	// Bit PDEN_FLASH.
	SYSCON_PDRUNCFG_PDEN_FLASH = 0x20
	// Position of RESERVED field.
	SYSCON_PDRUNCFG_RESERVED_Pos = 0x6
	// Bit mask of RESERVED field.
	SYSCON_PDRUNCFG_RESERVED_Msk = 0x40
	// Bit RESERVED.
	SYSCON_PDRUNCFG_RESERVED = 0x40
	// Position of PDEN_BOD_RST field.
	SYSCON_PDRUNCFG_PDEN_BOD_RST_Pos = 0x7
	// Bit mask of PDEN_BOD_RST field.
	SYSCON_PDRUNCFG_PDEN_BOD_RST_Msk = 0x80
	// Bit PDEN_BOD_RST.
	SYSCON_PDRUNCFG_PDEN_BOD_RST = 0x80
	// Position of PDEN_BOD_INTR field.
	SYSCON_PDRUNCFG_PDEN_BOD_INTR_Pos = 0x8
	// Bit mask of PDEN_BOD_INTR field.
	SYSCON_PDRUNCFG_PDEN_BOD_INTR_Msk = 0x100
	// Bit PDEN_BOD_INTR.
	SYSCON_PDRUNCFG_PDEN_BOD_INTR = 0x100
	// Position of RESERVED field.
	SYSCON_PDRUNCFG_RESERVED_Pos = 0x9
	// Bit mask of RESERVED field.
	SYSCON_PDRUNCFG_RESERVED_Msk = 0x200
	// Bit RESERVED.
	SYSCON_PDRUNCFG_RESERVED = 0x200
	// Position of PDEN_ADC0 field.
	SYSCON_PDRUNCFG_PDEN_ADC0_Pos = 0xa
	// Bit mask of PDEN_ADC0 field.
	SYSCON_PDRUNCFG_PDEN_ADC0_Msk = 0x400
	// Bit PDEN_ADC0.
	SYSCON_PDRUNCFG_PDEN_ADC0 = 0x400
	// Position of RESERVED field.
	SYSCON_PDRUNCFG_RESERVED_Pos = 0xb
	// Bit mask of RESERVED field.
	SYSCON_PDRUNCFG_RESERVED_Msk = 0x1800
	// Position of PDEN_SRAM0A field.
	SYSCON_PDRUNCFG_PDEN_SRAM0A_Pos = 0xd
	// Bit mask of PDEN_SRAM0A field.
	SYSCON_PDRUNCFG_PDEN_SRAM0A_Msk = 0x2000
	// Bit PDEN_SRAM0A.
	SYSCON_PDRUNCFG_PDEN_SRAM0A = 0x2000
	// Position of PDEN_SRAM0B field.
	SYSCON_PDRUNCFG_PDEN_SRAM0B_Pos = 0xe
	// Bit mask of PDEN_SRAM0B field.
	SYSCON_PDRUNCFG_PDEN_SRAM0B_Msk = 0x4000
	// Bit PDEN_SRAM0B.
	SYSCON_PDRUNCFG_PDEN_SRAM0B = 0x4000
	// Position of PDEN_SRAM1 field.
	SYSCON_PDRUNCFG_PDEN_SRAM1_Pos = 0xf
	// Bit mask of PDEN_SRAM1 field.
	SYSCON_PDRUNCFG_PDEN_SRAM1_Msk = 0x8000
	// Bit PDEN_SRAM1.
	SYSCON_PDRUNCFG_PDEN_SRAM1 = 0x8000
	// Position of PDEN_SRAM2 field.
	SYSCON_PDRUNCFG_PDEN_SRAM2_Pos = 0x10
	// Bit mask of PDEN_SRAM2 field.
	SYSCON_PDRUNCFG_PDEN_SRAM2_Msk = 0x10000
	// Bit PDEN_SRAM2.
	SYSCON_PDRUNCFG_PDEN_SRAM2 = 0x10000
	// Position of PDEN_ROM field.
	SYSCON_PDRUNCFG_PDEN_ROM_Pos = 0x11
	// Bit mask of PDEN_ROM field.
	SYSCON_PDRUNCFG_PDEN_ROM_Msk = 0x20000
	// Bit PDEN_ROM.
	SYSCON_PDRUNCFG_PDEN_ROM = 0x20000
	// Position of RESERVED field.
	SYSCON_PDRUNCFG_RESERVED_Pos = 0x12
	// Bit mask of RESERVED field.
	SYSCON_PDRUNCFG_RESERVED_Msk = 0x40000
	// Bit RESERVED.
	SYSCON_PDRUNCFG_RESERVED = 0x40000
	// Position of PDEN_VDDA field.
	SYSCON_PDRUNCFG_PDEN_VDDA_Pos = 0x13
	// Bit mask of PDEN_VDDA field.
	SYSCON_PDRUNCFG_PDEN_VDDA_Msk = 0x80000
	// Bit PDEN_VDDA.
	SYSCON_PDRUNCFG_PDEN_VDDA = 0x80000
	// Position of PDEN_WDT_OSC field.
	SYSCON_PDRUNCFG_PDEN_WDT_OSC_Pos = 0x14
	// Bit mask of PDEN_WDT_OSC field.
	SYSCON_PDRUNCFG_PDEN_WDT_OSC_Msk = 0x100000
	// Bit PDEN_WDT_OSC.
	SYSCON_PDRUNCFG_PDEN_WDT_OSC = 0x100000
	// Position of RESERVED field.
	SYSCON_PDRUNCFG_RESERVED_Pos = 0x15
	// Bit mask of RESERVED field.
	SYSCON_PDRUNCFG_RESERVED_Msk = 0x200000
	// Bit RESERVED.
	SYSCON_PDRUNCFG_RESERVED = 0x200000
	// Position of PDEN_SYS_PLL field.
	SYSCON_PDRUNCFG_PDEN_SYS_PLL_Pos = 0x16
	// Bit mask of PDEN_SYS_PLL field.
	SYSCON_PDRUNCFG_PDEN_SYS_PLL_Msk = 0x400000
	// Bit PDEN_SYS_PLL.
	SYSCON_PDRUNCFG_PDEN_SYS_PLL = 0x400000
	// Position of PDEN_VREFP field.
	SYSCON_PDRUNCFG_PDEN_VREFP_Pos = 0x17
	// Bit mask of PDEN_VREFP field.
	SYSCON_PDRUNCFG_PDEN_VREFP_Msk = 0x800000
	// Bit PDEN_VREFP.
	SYSCON_PDRUNCFG_PDEN_VREFP = 0x800000
	// Position of PDEN_32K_OSC field.
	SYSCON_PDRUNCFG_PDEN_32K_OSC_Pos = 0x18
	// Bit mask of PDEN_32K_OSC field.
	SYSCON_PDRUNCFG_PDEN_32K_OSC_Msk = 0x1000000
	// Bit PDEN_32K_OSC.
	SYSCON_PDRUNCFG_PDEN_32K_OSC = 0x1000000
	// Position of RESERVED field.
	SYSCON_PDRUNCFG_RESERVED_Pos = 0x19
	// Bit mask of RESERVED field.
	SYSCON_PDRUNCFG_RESERVED_Msk = 0xfe000000

	// PDRUNCFGSET: Set bits in PDRUNCFG
	// Position of PD_SET field.
	SYSCON_PDRUNCFGSET_PD_SET_Pos = 0x0
	// Bit mask of PD_SET field.
	SYSCON_PDRUNCFGSET_PD_SET_Msk = 0xffffffff

	// PDRUNCFGCLR: Clear bits in PDRUNCFG
	// Position of PD_CLR field.
	SYSCON_PDRUNCFGCLR_PD_CLR_Pos = 0x0
	// Bit mask of PD_CLR field.
	SYSCON_PDRUNCFGCLR_PD_CLR_Msk = 0xffffffff

	// STARTERP0: Start logic 0 wake-up enable register
	// Position of WWDT field.
	SYSCON_STARTERP0_WWDT_Pos = 0x0
	// Bit mask of WWDT field.
	SYSCON_STARTERP0_WWDT_Msk = 0x1
	// Bit WWDT.
	SYSCON_STARTERP0_WWDT = 0x1
	// Position of BOD field.
	SYSCON_STARTERP0_BOD_Pos = 0x1
	// Bit mask of BOD field.
	SYSCON_STARTERP0_BOD_Msk = 0x2
	// Bit BOD.
	SYSCON_STARTERP0_BOD = 0x2
	// Position of RESERVED field.
	SYSCON_STARTERP0_RESERVED_Pos = 0x2
	// Bit mask of RESERVED field.
	SYSCON_STARTERP0_RESERVED_Msk = 0x4
	// Bit RESERVED.
	SYSCON_STARTERP0_RESERVED = 0x4
	// Position of DMA field.
	SYSCON_STARTERP0_DMA_Pos = 0x3
	// Bit mask of DMA field.
	SYSCON_STARTERP0_DMA_Msk = 0x8
	// Bit DMA.
	SYSCON_STARTERP0_DMA = 0x8
	// Position of GINT0 field.
	SYSCON_STARTERP0_GINT0_Pos = 0x4
	// Bit mask of GINT0 field.
	SYSCON_STARTERP0_GINT0_Msk = 0x10
	// Bit GINT0.
	SYSCON_STARTERP0_GINT0 = 0x10
	// Position of PINT0 field.
	SYSCON_STARTERP0_PINT0_Pos = 0x5
	// Bit mask of PINT0 field.
	SYSCON_STARTERP0_PINT0_Msk = 0x20
	// Bit PINT0.
	SYSCON_STARTERP0_PINT0 = 0x20
	// Position of PINT1 field.
	SYSCON_STARTERP0_PINT1_Pos = 0x6
	// Bit mask of PINT1 field.
	SYSCON_STARTERP0_PINT1_Msk = 0x40
	// Bit PINT1.
	SYSCON_STARTERP0_PINT1 = 0x40
	// Position of PINT2 field.
	SYSCON_STARTERP0_PINT2_Pos = 0x7
	// Bit mask of PINT2 field.
	SYSCON_STARTERP0_PINT2_Msk = 0x80
	// Bit PINT2.
	SYSCON_STARTERP0_PINT2 = 0x80
	// Position of PINT3 field.
	SYSCON_STARTERP0_PINT3_Pos = 0x8
	// Bit mask of PINT3 field.
	SYSCON_STARTERP0_PINT3_Msk = 0x100
	// Bit PINT3.
	SYSCON_STARTERP0_PINT3 = 0x100
	// Position of UTICK field.
	SYSCON_STARTERP0_UTICK_Pos = 0x9
	// Bit mask of UTICK field.
	SYSCON_STARTERP0_UTICK_Msk = 0x200
	// Bit UTICK.
	SYSCON_STARTERP0_UTICK = 0x200
	// Position of MRT field.
	SYSCON_STARTERP0_MRT_Pos = 0xa
	// Bit mask of MRT field.
	SYSCON_STARTERP0_MRT_Msk = 0x400
	// Bit MRT.
	SYSCON_STARTERP0_MRT = 0x400
	// Position of TIMER0 field.
	SYSCON_STARTERP0_TIMER0_Pos = 0xb
	// Bit mask of TIMER0 field.
	SYSCON_STARTERP0_TIMER0_Msk = 0x800
	// Bit TIMER0.
	SYSCON_STARTERP0_TIMER0 = 0x800
	// Position of TIMER1 field.
	SYSCON_STARTERP0_TIMER1_Pos = 0xc
	// Bit mask of TIMER1 field.
	SYSCON_STARTERP0_TIMER1_Msk = 0x1000
	// Bit TIMER1.
	SYSCON_STARTERP0_TIMER1 = 0x1000
	// Position of TIMER2 field.
	SYSCON_STARTERP0_TIMER2_Pos = 0xd
	// Bit mask of TIMER2 field.
	SYSCON_STARTERP0_TIMER2_Msk = 0x2000
	// Bit TIMER2.
	SYSCON_STARTERP0_TIMER2 = 0x2000
	// Position of TIMER3 field.
	SYSCON_STARTERP0_TIMER3_Pos = 0xe
	// Bit mask of TIMER3 field.
	SYSCON_STARTERP0_TIMER3_Msk = 0x4000
	// Bit TIMER3.
	SYSCON_STARTERP0_TIMER3 = 0x4000
	// Position of TIMER4 field.
	SYSCON_STARTERP0_TIMER4_Pos = 0xf
	// Bit mask of TIMER4 field.
	SYSCON_STARTERP0_TIMER4_Msk = 0x8000
	// Bit TIMER4.
	SYSCON_STARTERP0_TIMER4 = 0x8000
	// Position of SCT0 field.
	SYSCON_STARTERP0_SCT0_Pos = 0x10
	// Bit mask of SCT0 field.
	SYSCON_STARTERP0_SCT0_Msk = 0x10000
	// Bit SCT0.
	SYSCON_STARTERP0_SCT0 = 0x10000
	// Position of USART0 field.
	SYSCON_STARTERP0_USART0_Pos = 0x11
	// Bit mask of USART0 field.
	SYSCON_STARTERP0_USART0_Msk = 0x20000
	// Bit USART0.
	SYSCON_STARTERP0_USART0 = 0x20000
	// Position of USART1 field.
	SYSCON_STARTERP0_USART1_Pos = 0x12
	// Bit mask of USART1 field.
	SYSCON_STARTERP0_USART1_Msk = 0x40000
	// Bit USART1.
	SYSCON_STARTERP0_USART1 = 0x40000
	// Position of USART2 field.
	SYSCON_STARTERP0_USART2_Pos = 0x13
	// Bit mask of USART2 field.
	SYSCON_STARTERP0_USART2_Msk = 0x80000
	// Bit USART2.
	SYSCON_STARTERP0_USART2 = 0x80000
	// Position of USART3 field.
	SYSCON_STARTERP0_USART3_Pos = 0x14
	// Bit mask of USART3 field.
	SYSCON_STARTERP0_USART3_Msk = 0x100000
	// Bit USART3.
	SYSCON_STARTERP0_USART3 = 0x100000
	// Position of I2C0 field.
	SYSCON_STARTERP0_I2C0_Pos = 0x15
	// Bit mask of I2C0 field.
	SYSCON_STARTERP0_I2C0_Msk = 0x200000
	// Bit I2C0.
	SYSCON_STARTERP0_I2C0 = 0x200000
	// Position of I2C1 field.
	SYSCON_STARTERP0_I2C1_Pos = 0x16
	// Bit mask of I2C1 field.
	SYSCON_STARTERP0_I2C1_Msk = 0x400000
	// Bit I2C1.
	SYSCON_STARTERP0_I2C1 = 0x400000
	// Position of I2C2 field.
	SYSCON_STARTERP0_I2C2_Pos = 0x17
	// Bit mask of I2C2 field.
	SYSCON_STARTERP0_I2C2_Msk = 0x800000
	// Bit I2C2.
	SYSCON_STARTERP0_I2C2 = 0x800000
	// Position of SPI0 field.
	SYSCON_STARTERP0_SPI0_Pos = 0x18
	// Bit mask of SPI0 field.
	SYSCON_STARTERP0_SPI0_Msk = 0x1000000
	// Bit SPI0.
	SYSCON_STARTERP0_SPI0 = 0x1000000
	// Position of SPI1 field.
	SYSCON_STARTERP0_SPI1_Pos = 0x19
	// Bit mask of SPI1 field.
	SYSCON_STARTERP0_SPI1_Msk = 0x2000000
	// Bit SPI1.
	SYSCON_STARTERP0_SPI1 = 0x2000000
	// Position of ADC0_SEQA field.
	SYSCON_STARTERP0_ADC0_SEQA_Pos = 0x1a
	// Bit mask of ADC0_SEQA field.
	SYSCON_STARTERP0_ADC0_SEQA_Msk = 0x4000000
	// Bit ADC0_SEQA.
	SYSCON_STARTERP0_ADC0_SEQA = 0x4000000
	// Position of ADC0_SEQB field.
	SYSCON_STARTERP0_ADC0_SEQB_Pos = 0x1b
	// Bit mask of ADC0_SEQB field.
	SYSCON_STARTERP0_ADC0_SEQB_Msk = 0x8000000
	// Bit ADC0_SEQB.
	SYSCON_STARTERP0_ADC0_SEQB = 0x8000000
	// Position of ADC0_THCMP field.
	SYSCON_STARTERP0_ADC0_THCMP_Pos = 0x1c
	// Bit mask of ADC0_THCMP field.
	SYSCON_STARTERP0_ADC0_THCMP_Msk = 0x10000000
	// Bit ADC0_THCMP.
	SYSCON_STARTERP0_ADC0_THCMP = 0x10000000
	// Position of RTC field.
	SYSCON_STARTERP0_RTC_Pos = 0x1d
	// Bit mask of RTC field.
	SYSCON_STARTERP0_RTC_Msk = 0x20000000
	// Bit RTC.
	SYSCON_STARTERP0_RTC = 0x20000000
	// Position of RESERVED field.
	SYSCON_STARTERP0_RESERVED_Pos = 0x1e
	// Bit mask of RESERVED field.
	SYSCON_STARTERP0_RESERVED_Msk = 0x40000000
	// Bit RESERVED.
	SYSCON_STARTERP0_RESERVED = 0x40000000
	// Position of MAILBOX field.
	SYSCON_STARTERP0_MAILBOX_Pos = 0x1f
	// Bit mask of MAILBOX field.
	SYSCON_STARTERP0_MAILBOX_Msk = 0x80000000
	// Bit MAILBOX.
	SYSCON_STARTERP0_MAILBOX = 0x80000000

	// STARTERP1: Start logic 1 wake-up enable register
	// Position of GINT1 field.
	SYSCON_STARTERP1_GINT1_Pos = 0x0
	// Bit mask of GINT1 field.
	SYSCON_STARTERP1_GINT1_Msk = 0x1
	// Bit GINT1.
	SYSCON_STARTERP1_GINT1 = 0x1
	// Position of PINT4 field.
	SYSCON_STARTERP1_PINT4_Pos = 0x1
	// Bit mask of PINT4 field.
	SYSCON_STARTERP1_PINT4_Msk = 0x2
	// Bit PINT4.
	SYSCON_STARTERP1_PINT4 = 0x2
	// Position of PINT5 field.
	SYSCON_STARTERP1_PINT5_Pos = 0x2
	// Bit mask of PINT5 field.
	SYSCON_STARTERP1_PINT5_Msk = 0x4
	// Bit PINT5.
	SYSCON_STARTERP1_PINT5 = 0x4
	// Position of PINT6 field.
	SYSCON_STARTERP1_PINT6_Pos = 0x3
	// Bit mask of PINT6 field.
	SYSCON_STARTERP1_PINT6_Msk = 0x8
	// Bit PINT6.
	SYSCON_STARTERP1_PINT6 = 0x8
	// Position of PINT7 field.
	SYSCON_STARTERP1_PINT7_Pos = 0x4
	// Bit mask of PINT7 field.
	SYSCON_STARTERP1_PINT7_Msk = 0x10
	// Bit PINT7.
	SYSCON_STARTERP1_PINT7 = 0x10
	// Position of RESERVED field.
	SYSCON_STARTERP1_RESERVED_Pos = 0x5
	// Bit mask of RESERVED field.
	SYSCON_STARTERP1_RESERVED_Msk = 0xe0
	// Position of RIT field.
	SYSCON_STARTERP1_RIT_Pos = 0x8
	// Bit mask of RIT field.
	SYSCON_STARTERP1_RIT_Msk = 0x100
	// Bit RIT.
	SYSCON_STARTERP1_RIT = 0x100
	// Position of RESERVED field.
	SYSCON_STARTERP1_RESERVED_Pos = 0xf
	// Bit mask of RESERVED field.
	SYSCON_STARTERP1_RESERVED_Msk = 0xffff8000

	// STARTERPSET0: Set bits in STARTERP0
	// Position of START_SET0 field.
	SYSCON_STARTERPSET0_START_SET0_Pos = 0x0
	// Bit mask of START_SET0 field.
	SYSCON_STARTERPSET0_START_SET0_Msk = 0xffffffff

	// STARTERPSET1: Set bits in STARTERP1
	// Position of START_SET1 field.
	SYSCON_STARTERPSET1_START_SET1_Pos = 0x0
	// Bit mask of START_SET1 field.
	SYSCON_STARTERPSET1_START_SET1_Msk = 0xffffffff

	// STARTERPCLR0: Clear bits in STARTERP0
	// Position of START_CLR0 field.
	SYSCON_STARTERPCLR0_START_CLR0_Pos = 0x0
	// Bit mask of START_CLR0 field.
	SYSCON_STARTERPCLR0_START_CLR0_Msk = 0xffffffff

	// STARTERPCLR1: Clear bits in STARTERP1
	// Position of START_CLR1 field.
	SYSCON_STARTERPCLR1_START_CLR1_Pos = 0x0
	// Bit mask of START_CLR1 field.
	SYSCON_STARTERPCLR1_START_CLR1_Msk = 0xffffffff

	// CPUCTRL: CPU Control for multiple processors
	// Position of MASTERCPU field.
	SYSCON_CPUCTRL_MASTERCPU_Pos = 0x0
	// Bit mask of MASTERCPU field.
	SYSCON_CPUCTRL_MASTERCPU_Msk = 0x1
	// Bit MASTERCPU.
	SYSCON_CPUCTRL_MASTERCPU = 0x1
	// M0+. Cortex-M0+ is the master CPU.
	SYSCON_CPUCTRL_MASTERCPU_M0P = 0x0
	// M4. Cortex-M4 is the master CPU.
	SYSCON_CPUCTRL_MASTERCPU_M4 = 0x1
	// Position of RESERVED field.
	SYSCON_CPUCTRL_RESERVED_Pos = 0x1
	// Bit mask of RESERVED field.
	SYSCON_CPUCTRL_RESERVED_Msk = 0x2
	// Bit RESERVED.
	SYSCON_CPUCTRL_RESERVED = 0x2
	// Position of CM4CLKEN field.
	SYSCON_CPUCTRL_CM4CLKEN_Pos = 0x2
	// Bit mask of CM4CLKEN field.
	SYSCON_CPUCTRL_CM4CLKEN_Msk = 0x4
	// Bit CM4CLKEN.
	SYSCON_CPUCTRL_CM4CLKEN = 0x4
	// Disabled. The Cortex-M4 clock is not enabled.
	SYSCON_CPUCTRL_CM4CLKEN_DISABLED = 0x0
	// Enabled. The Cortex-M4 clock is enabled.
	SYSCON_CPUCTRL_CM4CLKEN_ENABLED = 0x1
	// Position of CM0CLKEN field.
	SYSCON_CPUCTRL_CM0CLKEN_Pos = 0x3
	// Bit mask of CM0CLKEN field.
	SYSCON_CPUCTRL_CM0CLKEN_Msk = 0x8
	// Bit CM0CLKEN.
	SYSCON_CPUCTRL_CM0CLKEN = 0x8
	// Disabled. The Cortex-M0+ clock is not enabled.
	SYSCON_CPUCTRL_CM0CLKEN_DISABLED = 0x0
	// Enabled. The Cortex-M0+ clock is enabled.
	SYSCON_CPUCTRL_CM0CLKEN_ENABLED = 0x1
	// Position of CM4RSTEN field.
	SYSCON_CPUCTRL_CM4RSTEN_Pos = 0x4
	// Bit mask of CM4RSTEN field.
	SYSCON_CPUCTRL_CM4RSTEN_Msk = 0x10
	// Bit CM4RSTEN.
	SYSCON_CPUCTRL_CM4RSTEN = 0x10
	// Disabled. The Cortex-M4 is not being reset.
	SYSCON_CPUCTRL_CM4RSTEN_DISABLED = 0x0
	// Enabled. The Cortex-M4 is being reset.
	SYSCON_CPUCTRL_CM4RSTEN_ENABLED = 0x1
	// Position of CM0RSTEN field.
	SYSCON_CPUCTRL_CM0RSTEN_Pos = 0x5
	// Bit mask of CM0RSTEN field.
	SYSCON_CPUCTRL_CM0RSTEN_Msk = 0x20
	// Bit CM0RSTEN.
	SYSCON_CPUCTRL_CM0RSTEN = 0x20
	// Disabled. The Cortex-M0+ is not being reset.
	SYSCON_CPUCTRL_CM0RSTEN_DISABLED = 0x0
	// Enabled. The Cortex-M0+ is being reset.
	SYSCON_CPUCTRL_CM0RSTEN_ENABLED = 0x1
	// Position of POWERCPU field.
	SYSCON_CPUCTRL_POWERCPU_Pos = 0x6
	// Bit mask of POWERCPU field.
	SYSCON_CPUCTRL_POWERCPU_Msk = 0x40
	// Bit POWERCPU.
	SYSCON_CPUCTRL_POWERCPU = 0x40
	// M0+. Cortex-M0+ is the owner of reduced power mode control.
	SYSCON_CPUCTRL_POWERCPU_M0P = 0x0
	// M4. Cortex-M4 is the owner of reduced power mode control.
	SYSCON_CPUCTRL_POWERCPU_M4 = 0x1
	// Position of RESERVED field.
	SYSCON_CPUCTRL_RESERVED_Pos = 0x7
	// Bit mask of RESERVED field.
	SYSCON_CPUCTRL_RESERVED_Msk = 0xffffff80

	// CPBOOT: Coprocessor Boot Address
	// Position of BOOTADDR field.
	SYSCON_CPBOOT_BOOTADDR_Pos = 0x0
	// Bit mask of BOOTADDR field.
	SYSCON_CPBOOT_BOOTADDR_Msk = 0xffffffff

	// CPSTACK: Coprocessor Stack Address
	// Position of STACKADDR field.
	SYSCON_CPSTACK_STACKADDR_Pos = 0x0
	// Bit mask of STACKADDR field.
	SYSCON_CPSTACK_STACKADDR_Msk = 0xffffffff

	// JTAGIDCODE: JTAG ID code register
	// Position of JTAGID field.
	SYSCON_JTAGIDCODE_JTAGID_Pos = 0x0
	// Bit mask of JTAGID field.
	SYSCON_JTAGIDCODE_JTAGID_Msk = 0xffffffff

	// DEVICE_ID0: Part ID register
	// Position of PARTID field.
	SYSCON_DEVICE_ID0_PARTID_Pos = 0x0
	// Bit mask of PARTID field.
	SYSCON_DEVICE_ID0_PARTID_Msk = 0xffffffff

	// DEVICE_ID1: Boot ROM and die revision register
	// Position of REVID field.
	SYSCON_DEVICE_ID1_REVID_Pos = 0x0
	// Bit mask of REVID field.
	SYSCON_DEVICE_ID1_REVID_Msk = 0xffffffff
)

// Bitfields for CT32B2: Standard counter/timer 2
const (
	// IR: Interrupt Register. The IR can be written to clear interrupts. The IR can be read to identify which of eight possible interrupt sources are pending.
	// Position of MR0INT field.
	CT32B2_IR_MR0INT_Pos = 0x0
	// Bit mask of MR0INT field.
	CT32B2_IR_MR0INT_Msk = 0x1
	// Bit MR0INT.
	CT32B2_IR_MR0INT = 0x1
	// Position of MR1INT field.
	CT32B2_IR_MR1INT_Pos = 0x1
	// Bit mask of MR1INT field.
	CT32B2_IR_MR1INT_Msk = 0x2
	// Bit MR1INT.
	CT32B2_IR_MR1INT = 0x2
	// Position of MR2INT field.
	CT32B2_IR_MR2INT_Pos = 0x2
	// Bit mask of MR2INT field.
	CT32B2_IR_MR2INT_Msk = 0x4
	// Bit MR2INT.
	CT32B2_IR_MR2INT = 0x4
	// Position of MR3INT field.
	CT32B2_IR_MR3INT_Pos = 0x3
	// Bit mask of MR3INT field.
	CT32B2_IR_MR3INT_Msk = 0x8
	// Bit MR3INT.
	CT32B2_IR_MR3INT = 0x8
	// Position of CR0INT field.
	CT32B2_IR_CR0INT_Pos = 0x4
	// Bit mask of CR0INT field.
	CT32B2_IR_CR0INT_Msk = 0x10
	// Bit CR0INT.
	CT32B2_IR_CR0INT = 0x10
	// Position of CR1INT field.
	CT32B2_IR_CR1INT_Pos = 0x5
	// Bit mask of CR1INT field.
	CT32B2_IR_CR1INT_Msk = 0x20
	// Bit CR1INT.
	CT32B2_IR_CR1INT = 0x20
	// Position of CR2INT field.
	CT32B2_IR_CR2INT_Pos = 0x6
	// Bit mask of CR2INT field.
	CT32B2_IR_CR2INT_Msk = 0x40
	// Bit CR2INT.
	CT32B2_IR_CR2INT = 0x40
	// Position of CR3INT field.
	CT32B2_IR_CR3INT_Pos = 0x7
	// Bit mask of CR3INT field.
	CT32B2_IR_CR3INT_Msk = 0x80
	// Bit CR3INT.
	CT32B2_IR_CR3INT = 0x80
	// Position of RESERVED field.
	CT32B2_IR_RESERVED_Pos = 0x6
	// Bit mask of RESERVED field.
	CT32B2_IR_RESERVED_Msk = 0xffffffc0

	// TCR: Timer Control Register. The TCR is used to control the Timer Counter functions. The Timer Counter can be disabled or reset through the TCR.
	// Position of CEN field.
	CT32B2_TCR_CEN_Pos = 0x0
	// Bit mask of CEN field.
	CT32B2_TCR_CEN_Msk = 0x1
	// Bit CEN.
	CT32B2_TCR_CEN = 0x1
	// Disabled.The counters are disabled.
	CT32B2_TCR_CEN_DISABLED = 0x0
	// Enabled. The Timer Counter and Prescale Counter are enabled.
	CT32B2_TCR_CEN_ENABLED = 0x1
	// Position of CRST field.
	CT32B2_TCR_CRST_Pos = 0x1
	// Bit mask of CRST field.
	CT32B2_TCR_CRST_Msk = 0x2
	// Bit CRST.
	CT32B2_TCR_CRST = 0x2
	// Disabled. Do nothing.
	CT32B2_TCR_CRST_DISABLED = 0x0
	// Enabled. The Timer Counter and the Prescale Counter are synchronously reset on the next positive edge of PCLK. The counters remain reset until TCR[1] is returned to zero.
	CT32B2_TCR_CRST_ENABLED = 0x1
	// Position of RESERVED field.
	CT32B2_TCR_RESERVED_Pos = 0x2
	// Bit mask of RESERVED field.
	CT32B2_TCR_RESERVED_Msk = 0xfffffffc

	// TC: Timer Counter. The 32 bit TC is incremented every PR+1 cycles of PCLK. The TC is controlled through the TCR.
	// Position of TCVAL field.
	CT32B2_TC_TCVAL_Pos = 0x0
	// Bit mask of TCVAL field.
	CT32B2_TC_TCVAL_Msk = 0xffffffff

	// PR: Prescale Register. When the Prescale Counter (PC) is equal to this value, the next clock increments the TC and clears the PC.
	// Position of PRVAL field.
	CT32B2_PR_PRVAL_Pos = 0x0
	// Bit mask of PRVAL field.
	CT32B2_PR_PRVAL_Msk = 0xffffffff

	// PC: Prescale Counter. The 32 bit PC is a counter which is incremented to the value stored in PR. When the value in PR is reached, the TC is incremented and the PC is cleared. The PC is observable and controllable through the bus interface.
	// Position of PCVAL field.
	CT32B2_PC_PCVAL_Pos = 0x0
	// Bit mask of PCVAL field.
	CT32B2_PC_PCVAL_Msk = 0xffffffff

	// MCR: Match Control Register. The MCR is used to control if an interrupt is generated and if the TC is reset when a Match occurs.
	// Position of MR0I field.
	CT32B2_MCR_MR0I_Pos = 0x0
	// Bit mask of MR0I field.
	CT32B2_MCR_MR0I_Msk = 0x1
	// Bit MR0I.
	CT32B2_MCR_MR0I = 0x1
	// Position of MR0R field.
	CT32B2_MCR_MR0R_Pos = 0x1
	// Bit mask of MR0R field.
	CT32B2_MCR_MR0R_Msk = 0x2
	// Bit MR0R.
	CT32B2_MCR_MR0R = 0x2
	// Position of MR0S field.
	CT32B2_MCR_MR0S_Pos = 0x2
	// Bit mask of MR0S field.
	CT32B2_MCR_MR0S_Msk = 0x4
	// Bit MR0S.
	CT32B2_MCR_MR0S = 0x4
	// Position of MR1I field.
	CT32B2_MCR_MR1I_Pos = 0x3
	// Bit mask of MR1I field.
	CT32B2_MCR_MR1I_Msk = 0x8
	// Bit MR1I.
	CT32B2_MCR_MR1I = 0x8
	// Position of MR1R field.
	CT32B2_MCR_MR1R_Pos = 0x4
	// Bit mask of MR1R field.
	CT32B2_MCR_MR1R_Msk = 0x10
	// Bit MR1R.
	CT32B2_MCR_MR1R = 0x10
	// Position of MR1S field.
	CT32B2_MCR_MR1S_Pos = 0x5
	// Bit mask of MR1S field.
	CT32B2_MCR_MR1S_Msk = 0x20
	// Bit MR1S.
	CT32B2_MCR_MR1S = 0x20
	// Position of MR2I field.
	CT32B2_MCR_MR2I_Pos = 0x6
	// Bit mask of MR2I field.
	CT32B2_MCR_MR2I_Msk = 0x40
	// Bit MR2I.
	CT32B2_MCR_MR2I = 0x40
	// Position of MR2R field.
	CT32B2_MCR_MR2R_Pos = 0x7
	// Bit mask of MR2R field.
	CT32B2_MCR_MR2R_Msk = 0x80
	// Bit MR2R.
	CT32B2_MCR_MR2R = 0x80
	// Position of MR2S field.
	CT32B2_MCR_MR2S_Pos = 0x8
	// Bit mask of MR2S field.
	CT32B2_MCR_MR2S_Msk = 0x100
	// Bit MR2S.
	CT32B2_MCR_MR2S = 0x100
	// Position of MR3I field.
	CT32B2_MCR_MR3I_Pos = 0x9
	// Bit mask of MR3I field.
	CT32B2_MCR_MR3I_Msk = 0x200
	// Bit MR3I.
	CT32B2_MCR_MR3I = 0x200
	// Position of MR3R field.
	CT32B2_MCR_MR3R_Pos = 0xa
	// Bit mask of MR3R field.
	CT32B2_MCR_MR3R_Msk = 0x400
	// Bit MR3R.
	CT32B2_MCR_MR3R = 0x400
	// Position of MR3S field.
	CT32B2_MCR_MR3S_Pos = 0xb
	// Bit mask of MR3S field.
	CT32B2_MCR_MR3S_Msk = 0x800
	// Bit MR3S.
	CT32B2_MCR_MR3S = 0x800
	// Position of RESERVED field.
	CT32B2_MCR_RESERVED_Pos = 0xc
	// Bit mask of RESERVED field.
	CT32B2_MCR_RESERVED_Msk = 0xfffff000

	// MR0: Match Register 0. MR0 can be enabled through the MCR to reset the TC, stop both the TC and PC, and/or generate an interrupt every time MR0 matches the TC.
	// Position of MATCH field.
	CT32B2_MR_MATCH_Pos = 0x0
	// Bit mask of MATCH field.
	CT32B2_MR_MATCH_Msk = 0xffffffff

	// CCR: Capture Control Register. The CCR controls which edges of the capture inputs are used to load the Capture Registers and whether or not an interrupt is generated when a capture takes place.
	// Position of CAP0RE field.
	CT32B2_CCR_CAP0RE_Pos = 0x0
	// Bit mask of CAP0RE field.
	CT32B2_CCR_CAP0RE_Msk = 0x1
	// Bit CAP0RE.
	CT32B2_CCR_CAP0RE = 0x1
	// Position of CAP0FE field.
	CT32B2_CCR_CAP0FE_Pos = 0x1
	// Bit mask of CAP0FE field.
	CT32B2_CCR_CAP0FE_Msk = 0x2
	// Bit CAP0FE.
	CT32B2_CCR_CAP0FE = 0x2
	// Position of CAP0I field.
	CT32B2_CCR_CAP0I_Pos = 0x2
	// Bit mask of CAP0I field.
	CT32B2_CCR_CAP0I_Msk = 0x4
	// Bit CAP0I.
	CT32B2_CCR_CAP0I = 0x4
	// Position of CAP1RE field.
	CT32B2_CCR_CAP1RE_Pos = 0x3
	// Bit mask of CAP1RE field.
	CT32B2_CCR_CAP1RE_Msk = 0x8
	// Bit CAP1RE.
	CT32B2_CCR_CAP1RE = 0x8
	// Position of CAP1FE field.
	CT32B2_CCR_CAP1FE_Pos = 0x4
	// Bit mask of CAP1FE field.
	CT32B2_CCR_CAP1FE_Msk = 0x10
	// Bit CAP1FE.
	CT32B2_CCR_CAP1FE = 0x10
	// Position of CAP1I field.
	CT32B2_CCR_CAP1I_Pos = 0x5
	// Bit mask of CAP1I field.
	CT32B2_CCR_CAP1I_Msk = 0x20
	// Bit CAP1I.
	CT32B2_CCR_CAP1I = 0x20
	// Position of CAP2RE field.
	CT32B2_CCR_CAP2RE_Pos = 0x6
	// Bit mask of CAP2RE field.
	CT32B2_CCR_CAP2RE_Msk = 0x40
	// Bit CAP2RE.
	CT32B2_CCR_CAP2RE = 0x40
	// Position of CAP2FE field.
	CT32B2_CCR_CAP2FE_Pos = 0x7
	// Bit mask of CAP2FE field.
	CT32B2_CCR_CAP2FE_Msk = 0x80
	// Bit CAP2FE.
	CT32B2_CCR_CAP2FE = 0x80
	// Position of CAP2I field.
	CT32B2_CCR_CAP2I_Pos = 0x8
	// Bit mask of CAP2I field.
	CT32B2_CCR_CAP2I_Msk = 0x100
	// Bit CAP2I.
	CT32B2_CCR_CAP2I = 0x100
	// Position of CAP3RE field.
	CT32B2_CCR_CAP3RE_Pos = 0x9
	// Bit mask of CAP3RE field.
	CT32B2_CCR_CAP3RE_Msk = 0x200
	// Bit CAP3RE.
	CT32B2_CCR_CAP3RE = 0x200
	// Position of CAP3FE field.
	CT32B2_CCR_CAP3FE_Pos = 0xa
	// Bit mask of CAP3FE field.
	CT32B2_CCR_CAP3FE_Msk = 0x400
	// Bit CAP3FE.
	CT32B2_CCR_CAP3FE = 0x400
	// Position of CAP3I field.
	CT32B2_CCR_CAP3I_Pos = 0xb
	// Bit mask of CAP3I field.
	CT32B2_CCR_CAP3I_Msk = 0x800
	// Bit CAP3I.
	CT32B2_CCR_CAP3I = 0x800
	// Position of RESERVED field.
	CT32B2_CCR_RESERVED_Pos = 0xc
	// Bit mask of RESERVED field.
	CT32B2_CCR_RESERVED_Msk = 0xfffff000

	// CR0: Capture Register 0. CR0 is loaded with the value of TC when there is an event on the CAPn.0 input.
	// Position of CAP field.
	CT32B2_CR_CAP_Pos = 0x0
	// Bit mask of CAP field.
	CT32B2_CR_CAP_Msk = 0xffffffff

	// EMR: External Match Register. The EMR controls the match function and the external match pins.
	// Position of EM0 field.
	CT32B2_EMR_EM0_Pos = 0x0
	// Bit mask of EM0 field.
	CT32B2_EMR_EM0_Msk = 0x1
	// Bit EM0.
	CT32B2_EMR_EM0 = 0x1
	// Position of EM1 field.
	CT32B2_EMR_EM1_Pos = 0x1
	// Bit mask of EM1 field.
	CT32B2_EMR_EM1_Msk = 0x2
	// Bit EM1.
	CT32B2_EMR_EM1 = 0x2
	// Position of EM2 field.
	CT32B2_EMR_EM2_Pos = 0x2
	// Bit mask of EM2 field.
	CT32B2_EMR_EM2_Msk = 0x4
	// Bit EM2.
	CT32B2_EMR_EM2 = 0x4
	// Position of EM3 field.
	CT32B2_EMR_EM3_Pos = 0x3
	// Bit mask of EM3 field.
	CT32B2_EMR_EM3_Msk = 0x8
	// Bit EM3.
	CT32B2_EMR_EM3 = 0x8
	// Position of EMC0 field.
	CT32B2_EMR_EMC0_Pos = 0x4
	// Bit mask of EMC0 field.
	CT32B2_EMR_EMC0_Msk = 0x30
	// Do Nothing.
	CT32B2_EMR_EMC0_DO_NOTHING = 0x0
	// Clear. Clear the corresponding External Match bit/output to 0 (MAT0 pin is LOW if pinned out).
	CT32B2_EMR_EMC0_CLEAR = 0x1
	// Set. Set the corresponding External Match bit/output to 1 (MAT0 pin is HIGH if pinned out).
	CT32B2_EMR_EMC0_SET = 0x2
	// Toggle. Toggle the corresponding External Match bit/output.
	CT32B2_EMR_EMC0_TOGGLE = 0x3
	// Position of EMC1 field.
	CT32B2_EMR_EMC1_Pos = 0x6
	// Bit mask of EMC1 field.
	CT32B2_EMR_EMC1_Msk = 0xc0
	// Do Nothing.
	CT32B2_EMR_EMC1_DO_NOTHING = 0x0
	// Clear. Clear the corresponding External Match bit/output to 0 (MAT1 pin is LOW if pinned out).
	CT32B2_EMR_EMC1_CLEAR = 0x1
	// Set. Set the corresponding External Match bit/output to 1 (MAT1 pin is HIGH if pinned out).
	CT32B2_EMR_EMC1_SET = 0x2
	// Toggle. Toggle the corresponding External Match bit/output.
	CT32B2_EMR_EMC1_TOGGLE = 0x3
	// Position of EMC2 field.
	CT32B2_EMR_EMC2_Pos = 0x8
	// Bit mask of EMC2 field.
	CT32B2_EMR_EMC2_Msk = 0x300
	// Do Nothing.
	CT32B2_EMR_EMC2_DO_NOTHING = 0x0
	// Clear. Clear the corresponding External Match bit/output to 0 (MAT2 pin is LOW if pinned out).
	CT32B2_EMR_EMC2_CLEAR = 0x1
	// Set. Set the corresponding External Match bit/output to 1 (MAT2 pin is HIGH if pinned out).
	CT32B2_EMR_EMC2_SET = 0x2
	// Toggle. Toggle the corresponding External Match bit/output.
	CT32B2_EMR_EMC2_TOGGLE = 0x3
	// Position of EMC3 field.
	CT32B2_EMR_EMC3_Pos = 0xa
	// Bit mask of EMC3 field.
	CT32B2_EMR_EMC3_Msk = 0xc00
	// Do Nothing.
	CT32B2_EMR_EMC3_DO_NOTHING = 0x0
	// Clear. Clear the corresponding External Match bit/output to 0 (MAT3 pin is LOW if pinned out).
	CT32B2_EMR_EMC3_CLEAR = 0x1
	// Set. Set the corresponding External Match bit/output to 1 (MAT3 pin is HIGH if pinned out).
	CT32B2_EMR_EMC3_SET = 0x2
	// Toggle. Toggle the corresponding External Match bit/output.
	CT32B2_EMR_EMC3_TOGGLE = 0x3
	// Position of RESERVED field.
	CT32B2_EMR_RESERVED_Pos = 0xc
	// Bit mask of RESERVED field.
	CT32B2_EMR_RESERVED_Msk = 0xfffff000

	// CTCR: Count Control Register. The CTCR selects between Timer and Counter mode, and in Counter mode selects the signal and edge(s) for counting.
	// Position of CTMODE field.
	CT32B2_CTCR_CTMODE_Pos = 0x0
	// Bit mask of CTMODE field.
	CT32B2_CTCR_CTMODE_Msk = 0x3
	// Timer Mode. Incremented every rising PCLK edge.
	CT32B2_CTCR_CTMODE_TIMER_MODE = 0x0
	// Counter Mode rising edge. TC is incremented on rising edges on the CAP input selected by bits 3:2.
	CT32B2_CTCR_CTMODE_COUNTER_MODE_RISING = 0x1
	// Counter Mode falling edge. TC is incremented on falling edges on the CAP input selected by bits 3:2.
	CT32B2_CTCR_CTMODE_COUNTER_MODE_FALLING = 0x2
	// Counter Mode dual edge. TC is incremented on both edges on the CAP input selected by bits 3:2.
	CT32B2_CTCR_CTMODE_COUNTER_MODE_DUAL_ED = 0x3
	// Position of CINSEL field.
	CT32B2_CTCR_CINSEL_Pos = 0x2
	// Bit mask of CINSEL field.
	CT32B2_CTCR_CINSEL_Msk = 0xc
	// Channel 0. CAPn.0 for TIMERn
	CT32B2_CTCR_CINSEL_CHANNEL_0 = 0x0
	// Channel 1. CAPn.1 for TIMERn
	CT32B2_CTCR_CINSEL_CHANNEL_1 = 0x1
	// Channel 2. CAPn.2 for TIMERn
	CT32B2_CTCR_CINSEL_CHANNEL_2 = 0x2
	// Channel 3. CAPn.3 for TIMERn
	CT32B2_CTCR_CINSEL_CHANNEL_3 = 0x3
	// Position of ENCC field.
	CT32B2_CTCR_ENCC_Pos = 0x4
	// Bit mask of ENCC field.
	CT32B2_CTCR_ENCC_Msk = 0x10
	// Bit ENCC.
	CT32B2_CTCR_ENCC = 0x10
	// Position of SELCC field.
	CT32B2_CTCR_SELCC_Pos = 0x5
	// Bit mask of SELCC field.
	CT32B2_CTCR_SELCC_Msk = 0xe0
	// Channel 0 Rising Edge. Rising edge of the signal on capture channel 0 clears the timer (if bit 4 is set).
	CT32B2_CTCR_SELCC_CHANNEL_0_RISING_EDG = 0x0
	// Channel 0 Falling Edge. Falling edge of the signal on capture channel 0 clears the timer (if bit 4 is set).
	CT32B2_CTCR_SELCC_CHANNEL_0_FALLING_ED = 0x1
	// Channel 1 Rising Edge. Rising edge of the signal on capture channel 1 clears the timer (if bit 4 is set).
	CT32B2_CTCR_SELCC_CHANNEL_1_RISING_EDG = 0x2
	// Channel 1 Falling Edge. Falling edge of the signal on capture channel 1 clears the timer (if bit 4 is set).
	CT32B2_CTCR_SELCC_CHANNEL_1_FALLING_ED = 0x3
	// Channel 2 Rising Edge. Rising edge of the signal on capture channel 2 clears the timer (if bit 4 is set).
	CT32B2_CTCR_SELCC_CHANNEL_2_RISING_EDG = 0x4
	// Channel 2 Falling Edge. Falling edge of the signal on capture channel 2 clears the timer (if bit 4 is set).
	CT32B2_CTCR_SELCC_CHANNEL_2_FALLING_ED = 0x5
	// Position of RESERVED field.
	CT32B2_CTCR_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	CT32B2_CTCR_RESERVED_Msk = 0xffffff00

	// PWMC: PWM Control Register. The PWMCON enables PWM mode for the external match pins.
	// Position of PWMEN0 field.
	CT32B2_PWMC_PWMEN0_Pos = 0x0
	// Bit mask of PWMEN0 field.
	CT32B2_PWMC_PWMEN0_Msk = 0x1
	// Bit PWMEN0.
	CT32B2_PWMC_PWMEN0 = 0x1
	// Match. CT32Bn_MAT0 is controlled by EM0.
	CT32B2_PWMC_PWMEN0_MATCH = 0x0
	// PWM. PWM mode is enabled for CT32Bn_MAT0.
	CT32B2_PWMC_PWMEN0_PWM = 0x1
	// Position of PWMEN1 field.
	CT32B2_PWMC_PWMEN1_Pos = 0x1
	// Bit mask of PWMEN1 field.
	CT32B2_PWMC_PWMEN1_Msk = 0x2
	// Bit PWMEN1.
	CT32B2_PWMC_PWMEN1 = 0x2
	// Match. CT32Bn_MAT01 is controlled by EM1.
	CT32B2_PWMC_PWMEN1_MATCH = 0x0
	// PWM. PWM mode is enabled for CT32Bn_MAT1.
	CT32B2_PWMC_PWMEN1_PWM = 0x1
	// Position of PWMEN2 field.
	CT32B2_PWMC_PWMEN2_Pos = 0x2
	// Bit mask of PWMEN2 field.
	CT32B2_PWMC_PWMEN2_Msk = 0x4
	// Bit PWMEN2.
	CT32B2_PWMC_PWMEN2 = 0x4
	// Match. CT32Bn_MAT2 is controlled by EM2.
	CT32B2_PWMC_PWMEN2_MATCH = 0x0
	// PWM. PWM mode is enabled for CT32Bn_MAT2.
	CT32B2_PWMC_PWMEN2_PWM = 0x1
	// Position of PWMEN3 field.
	CT32B2_PWMC_PWMEN3_Pos = 0x3
	// Bit mask of PWMEN3 field.
	CT32B2_PWMC_PWMEN3_Msk = 0x8
	// Bit PWMEN3.
	CT32B2_PWMC_PWMEN3 = 0x8
	// Match. CT32Bn_MAT3 is controlled by EM3.
	CT32B2_PWMC_PWMEN3_MATCH = 0x0
	// PWM. PWM mode is enabled for CT132Bn_MAT3.
	CT32B2_PWMC_PWMEN3_PWM = 0x1
	// Position of RESERVED field.
	CT32B2_PWMC_RESERVED_Pos = 0x4
	// Bit mask of RESERVED field.
	CT32B2_PWMC_RESERVED_Msk = 0xfffffff0
)

// Bitfields for GINT0: Group GPIO input interrupt 0
const (
	// CTRL: GPIO grouped interrupt control register
	// Position of INT field.
	GINT0_CTRL_INT_Pos = 0x0
	// Bit mask of INT field.
	GINT0_CTRL_INT_Msk = 0x1
	// Bit INT.
	GINT0_CTRL_INT = 0x1
	// No request. No interrupt request is pending.
	GINT0_CTRL_INT_NO_REQUEST = 0x0
	// Request active. Interrupt request is active.
	GINT0_CTRL_INT_REQUEST_ACTIVE = 0x1
	// Position of COMB field.
	GINT0_CTRL_COMB_Pos = 0x1
	// Bit mask of COMB field.
	GINT0_CTRL_COMB_Msk = 0x2
	// Bit COMB.
	GINT0_CTRL_COMB = 0x2
	// Or. OR functionality: A grouped interrupt is generated when any one of the enabled inputs is active (based on its programmed polarity).
	GINT0_CTRL_COMB_OR = 0x0
	// And. AND functionality: An interrupt is generated when all enabled bits are active (based on their programmed polarity).
	GINT0_CTRL_COMB_AND = 0x1
	// Position of TRIG field.
	GINT0_CTRL_TRIG_Pos = 0x2
	// Bit mask of TRIG field.
	GINT0_CTRL_TRIG_Msk = 0x4
	// Bit TRIG.
	GINT0_CTRL_TRIG = 0x4
	// Edge-triggered.
	GINT0_CTRL_TRIG_EDGE_TRIGGERED = 0x0
	// Level-triggered.
	GINT0_CTRL_TRIG_LEVEL_TRIGGERED = 0x1
	// Position of RESERVED field.
	GINT0_CTRL_RESERVED_Pos = 0x3
	// Bit mask of RESERVED field.
	GINT0_CTRL_RESERVED_Msk = 0xfffffff8

	// PORT_POL0: GPIO grouped interrupt port 0 polarity register
	// Position of POL field.
	GINT0_PORT_POL_POL_Pos = 0x0
	// Bit mask of POL field.
	GINT0_PORT_POL_POL_Msk = 0xffffffff

	// PORT_ENA0: GPIO grouped interrupt port 0 enable register
	// Position of ENA field.
	GINT0_PORT_ENA_ENA_Pos = 0x0
	// Bit mask of ENA field.
	GINT0_PORT_ENA_ENA_Msk = 0xffffffff
)

// Bitfields for PINT: Pin interrupt and pattern match engine
const (
	// ISEL: Pin Interrupt Mode register
	// Position of PMODE field.
	PINT_ISEL_PMODE_Pos = 0x0
	// Bit mask of PMODE field.
	PINT_ISEL_PMODE_Msk = 0xff
	// Position of RESERVED field.
	PINT_ISEL_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	PINT_ISEL_RESERVED_Msk = 0xffffff00

	// IENR: Pin interrupt level or rising edge interrupt enable register
	// Position of ENRL field.
	PINT_IENR_ENRL_Pos = 0x0
	// Bit mask of ENRL field.
	PINT_IENR_ENRL_Msk = 0xff
	// Position of RESERVED field.
	PINT_IENR_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	PINT_IENR_RESERVED_Msk = 0xffffff00

	// SIENR: Pin interrupt level or rising edge interrupt set register
	// Position of SETENRL field.
	PINT_SIENR_SETENRL_Pos = 0x0
	// Bit mask of SETENRL field.
	PINT_SIENR_SETENRL_Msk = 0xff
	// Position of RESERVED field.
	PINT_SIENR_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	PINT_SIENR_RESERVED_Msk = 0xffffff00

	// CIENR: Pin interrupt level (rising edge interrupt) clear register
	// Position of CENRL field.
	PINT_CIENR_CENRL_Pos = 0x0
	// Bit mask of CENRL field.
	PINT_CIENR_CENRL_Msk = 0xff
	// Position of RESERVED field.
	PINT_CIENR_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	PINT_CIENR_RESERVED_Msk = 0xffffff00

	// IENF: Pin interrupt active level or falling edge interrupt enable register
	// Position of ENAF field.
	PINT_IENF_ENAF_Pos = 0x0
	// Bit mask of ENAF field.
	PINT_IENF_ENAF_Msk = 0xff
	// Position of RESERVED field.
	PINT_IENF_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	PINT_IENF_RESERVED_Msk = 0xffffff00

	// SIENF: Pin interrupt active level or falling edge interrupt set register
	// Position of SETENAF field.
	PINT_SIENF_SETENAF_Pos = 0x0
	// Bit mask of SETENAF field.
	PINT_SIENF_SETENAF_Msk = 0xff
	// Position of RESERVED field.
	PINT_SIENF_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	PINT_SIENF_RESERVED_Msk = 0xffffff00

	// CIENF: Pin interrupt active level or falling edge interrupt clear register
	// Position of CENAF field.
	PINT_CIENF_CENAF_Pos = 0x0
	// Bit mask of CENAF field.
	PINT_CIENF_CENAF_Msk = 0xff
	// Position of RESERVED field.
	PINT_CIENF_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	PINT_CIENF_RESERVED_Msk = 0xffffff00

	// RISE: Pin interrupt rising edge register
	// Position of RDET field.
	PINT_RISE_RDET_Pos = 0x0
	// Bit mask of RDET field.
	PINT_RISE_RDET_Msk = 0xff
	// Position of RESERVED field.
	PINT_RISE_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	PINT_RISE_RESERVED_Msk = 0xffffff00

	// FALL: Pin interrupt falling edge register
	// Position of FDET field.
	PINT_FALL_FDET_Pos = 0x0
	// Bit mask of FDET field.
	PINT_FALL_FDET_Msk = 0xff
	// Position of RESERVED field.
	PINT_FALL_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	PINT_FALL_RESERVED_Msk = 0xffffff00

	// IST: Pin interrupt status register
	// Position of PSTAT field.
	PINT_IST_PSTAT_Pos = 0x0
	// Bit mask of PSTAT field.
	PINT_IST_PSTAT_Msk = 0xff
	// Position of RESERVED field.
	PINT_IST_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	PINT_IST_RESERVED_Msk = 0xffffff00

	// PMCTRL: Pattern match interrupt control register
	// Position of SEL_PMATCH field.
	PINT_PMCTRL_SEL_PMATCH_Pos = 0x0
	// Bit mask of SEL_PMATCH field.
	PINT_PMCTRL_SEL_PMATCH_Msk = 0x1
	// Bit SEL_PMATCH.
	PINT_PMCTRL_SEL_PMATCH = 0x1
	// Pin interrupt. Interrupts are driven in response to the standard pin interrupt function.
	PINT_PMCTRL_SEL_PMATCH_PIN_INTERRUPT = 0x0
	// Pattern match. Interrupts are driven in response to pattern matches.
	PINT_PMCTRL_SEL_PMATCH_PATTERN_MATCH = 0x1
	// Position of ENA_RXEV field.
	PINT_PMCTRL_ENA_RXEV_Pos = 0x1
	// Bit mask of ENA_RXEV field.
	PINT_PMCTRL_ENA_RXEV_Msk = 0x2
	// Bit ENA_RXEV.
	PINT_PMCTRL_ENA_RXEV = 0x2
	// Disabled. RXEV output to the CPU is disabled.
	PINT_PMCTRL_ENA_RXEV_DISABLED = 0x0
	// Enabled. RXEV output to the CPU is enabled.
	PINT_PMCTRL_ENA_RXEV_ENABLED = 0x1
	// Position of RESERVED field.
	PINT_PMCTRL_RESERVED_Pos = 0x2
	// Bit mask of RESERVED field.
	PINT_PMCTRL_RESERVED_Msk = 0xfffffc
	// Position of PMAT field.
	PINT_PMCTRL_PMAT_Pos = 0x18
	// Bit mask of PMAT field.
	PINT_PMCTRL_PMAT_Msk = 0xff000000

	// PMSRC: Pattern match interrupt bit-slice source register
	// Position of Reserved field.
	PINT_PMSRC_Reserved_Pos = 0x0
	// Bit mask of Reserved field.
	PINT_PMSRC_Reserved_Msk = 0xff
	// Position of SRC0 field.
	PINT_PMSRC_SRC0_Pos = 0x8
	// Bit mask of SRC0 field.
	PINT_PMSRC_SRC0_Msk = 0x700
	// Input 0. Selects the pin selected in the PINTSEL0 register as the source to bit slice 0.
	PINT_PMSRC_SRC0_INPUT_0 = 0x0
	// Input 1. Selects the pin selected in the PINTSEL1 register as the source to bit slice 0.
	PINT_PMSRC_SRC0_INPUT_1 = 0x1
	// Input 2. Selects the pin selected in the PINTSEL2 register as the source to bit slice 0.
	PINT_PMSRC_SRC0_INPUT_2 = 0x2
	// Input 3. Selects the pin selected in the PINTSEL3 register as the source to bit slice 0.
	PINT_PMSRC_SRC0_INPUT_3 = 0x3
	// Input 4. Selects the pin selected in the PINTSEL4 register as the source to bit slice 0.
	PINT_PMSRC_SRC0_INPUT_4 = 0x4
	// Input 5. Selects the pin selected in the PINTSEL5 register as the source to bit slice 0.
	PINT_PMSRC_SRC0_INPUT_5 = 0x5
	// Input 6. Selects the pin selected in the PINTSEL6 register as the source to bit slice 0.
	PINT_PMSRC_SRC0_INPUT_6 = 0x6
	// Input 7. Selects the pin selected in the PINTSEL7 register as the source to bit slice 0.
	PINT_PMSRC_SRC0_INPUT_7 = 0x7
	// Position of SRC1 field.
	PINT_PMSRC_SRC1_Pos = 0xb
	// Bit mask of SRC1 field.
	PINT_PMSRC_SRC1_Msk = 0x3800
	// Input 0. Selects the pin selected in the PINTSEL0 register as the source to bit slice 1.
	PINT_PMSRC_SRC1_INPUT_0 = 0x0
	// Input 1. Selects the pin selected in the PINTSEL1 register as the source to bit slice 1.
	PINT_PMSRC_SRC1_INPUT_1 = 0x1
	// Input 2. Selects the pin selected in the PINTSEL2 register as the source to bit slice 1.
	PINT_PMSRC_SRC1_INPUT_2 = 0x2
	// Input 3. Selects the pin selected in the PINTSEL3 register as the source to bit slice 1.
	PINT_PMSRC_SRC1_INPUT_3 = 0x3
	// Input 4. Selects the pin selected in the PINTSEL4 register as the source to bit slice 1.
	PINT_PMSRC_SRC1_INPUT_4 = 0x4
	// Input 5. Selects the pin selected in the PINTSEL5 register as the source to bit slice 1.
	PINT_PMSRC_SRC1_INPUT_5 = 0x5
	// Input 6. Selects the pin selected in the PINTSEL6 register as the source to bit slice 1.
	PINT_PMSRC_SRC1_INPUT_6 = 0x6
	// Input 7. Selects the pin selected in the PINTSEL7 register as the source to bit slice 1.
	PINT_PMSRC_SRC1_INPUT_7 = 0x7
	// Position of SRC2 field.
	PINT_PMSRC_SRC2_Pos = 0xe
	// Bit mask of SRC2 field.
	PINT_PMSRC_SRC2_Msk = 0x1c000
	// Input 0. Selects the pin selected in the PINTSEL0 register as the source to bit slice 2.
	PINT_PMSRC_SRC2_INPUT_0 = 0x0
	// Input 1. Selects the pin selected in the PINTSEL1 register as the source to bit slice 2.
	PINT_PMSRC_SRC2_INPUT_1 = 0x1
	// Input 2. Selects the pin selected in the PINTSEL2 register as the source to bit slice 2.
	PINT_PMSRC_SRC2_INPUT_2 = 0x2
	// Input 3. Selects the pin selected in the PINTSEL3 register as the source to bit slice 2.
	PINT_PMSRC_SRC2_INPUT_3 = 0x3
	// Input 4. Selects the pin selected in the PINTSEL4 register as the source to bit slice 2.
	PINT_PMSRC_SRC2_INPUT_4 = 0x4
	// Input 5. Selects the pin selected in the PINTSEL5 register as the source to bit slice 2.
	PINT_PMSRC_SRC2_INPUT_5 = 0x5
	// Input 6. Selects the pin selected in the PINTSEL6 register as the source to bit slice 2.
	PINT_PMSRC_SRC2_INPUT_6 = 0x6
	// Input 7. Selects the pin selected in the PINTSEL7 register as the source to bit slice 2.
	PINT_PMSRC_SRC2_INPUT_7 = 0x7
	// Position of SRC3 field.
	PINT_PMSRC_SRC3_Pos = 0x11
	// Bit mask of SRC3 field.
	PINT_PMSRC_SRC3_Msk = 0xe0000
	// Input 0. Selects the pin selected in the PINTSEL0 register as the source to bit slice 3.
	PINT_PMSRC_SRC3_INPUT_0 = 0x0
	// Input 1. Selects the pin selected in the PINTSEL1 register as the source to bit slice 3.
	PINT_PMSRC_SRC3_INPUT_1 = 0x1
	// Input 2. Selects the pin selected in the PINTSEL2 register as the source to bit slice 3.
	PINT_PMSRC_SRC3_INPUT_2 = 0x2
	// Input 3. Selects the pin selected in the PINTSEL3 register as the source to bit slice 3.
	PINT_PMSRC_SRC3_INPUT_3 = 0x3
	// Input 4. Selects the pin selected in the PINTSEL4 register as the source to bit slice 3.
	PINT_PMSRC_SRC3_INPUT_4 = 0x4
	// Input 5. Selects the pin selected in the PINTSEL5 register as the source to bit slice 3.
	PINT_PMSRC_SRC3_INPUT_5 = 0x5
	// Input 6. Selects the pin selected in the PINTSEL6 register as the source to bit slice 3.
	PINT_PMSRC_SRC3_INPUT_6 = 0x6
	// Input 7. Selects the pin selected in the PINTSEL7 register as the source to bit slice 3.
	PINT_PMSRC_SRC3_INPUT_7 = 0x7
	// Position of SRC4 field.
	PINT_PMSRC_SRC4_Pos = 0x14
	// Bit mask of SRC4 field.
	PINT_PMSRC_SRC4_Msk = 0x700000
	// Input 0. Selects the pin selected in the PINTSEL0 register as the source to bit slice 4.
	PINT_PMSRC_SRC4_INPUT_0 = 0x0
	// Input 1. Selects the pin selected in the PINTSEL1 register as the source to bit slice 4.
	PINT_PMSRC_SRC4_INPUT_1 = 0x1
	// Input 2. Selects the pin selected in the PINTSEL2 register as the source to bit slice 4.
	PINT_PMSRC_SRC4_INPUT_2 = 0x2
	// Input 3. Selects the pin selected in the PINTSEL3 register as the source to bit slice 4.
	PINT_PMSRC_SRC4_INPUT_3 = 0x3
	// Input 4. Selects the pin selected in the PINTSEL4 register as the source to bit slice 4.
	PINT_PMSRC_SRC4_INPUT_4 = 0x4
	// Input 5. Selects the pin selected in the PINTSEL5 register as the source to bit slice 4.
	PINT_PMSRC_SRC4_INPUT_5 = 0x5
	// Input 6. Selects the pin selected in the PINTSEL6 register as the source to bit slice 4.
	PINT_PMSRC_SRC4_INPUT_6 = 0x6
	// Input 7. Selects the pin selected in the PINTSEL7 register as the source to bit slice 4.
	PINT_PMSRC_SRC4_INPUT_7 = 0x7
	// Position of SRC5 field.
	PINT_PMSRC_SRC5_Pos = 0x17
	// Bit mask of SRC5 field.
	PINT_PMSRC_SRC5_Msk = 0x3800000
	// Input 0. Selects the pin selected in the PINTSEL0 register as the source to bit slice 5.
	PINT_PMSRC_SRC5_INPUT_0 = 0x0
	// Input 1. Selects the pin selected in the PINTSEL1 register as the source to bit slice 5.
	PINT_PMSRC_SRC5_INPUT_1 = 0x1
	// Input 2. Selects the pin selected in the PINTSEL2 register as the source to bit slice 5.
	PINT_PMSRC_SRC5_INPUT_2 = 0x2
	// Input 3. Selects the pin selected in the PINTSEL3 register as the source to bit slice 5.
	PINT_PMSRC_SRC5_INPUT_3 = 0x3
	// Input 4. Selects the pin selected in the PINTSEL4 register as the source to bit slice 5.
	PINT_PMSRC_SRC5_INPUT_4 = 0x4
	// Input 5. Selects the pin selected in the PINTSEL5 register as the source to bit slice 5.
	PINT_PMSRC_SRC5_INPUT_5 = 0x5
	// Input 6. Selects the pin selected in the PINTSEL6 register as the source to bit slice 5.
	PINT_PMSRC_SRC5_INPUT_6 = 0x6
	// Input 7. Selects the pin selected in the PINTSEL7 register as the source to bit slice 5.
	PINT_PMSRC_SRC5_INPUT_7 = 0x7
	// Position of SRC6 field.
	PINT_PMSRC_SRC6_Pos = 0x1a
	// Bit mask of SRC6 field.
	PINT_PMSRC_SRC6_Msk = 0x1c000000
	// Input 0. Selects the pin selected in the PINTSEL0 register as the source to bit slice 6.
	PINT_PMSRC_SRC6_INPUT_0 = 0x0
	// Input 1. Selects the pin selected in the PINTSEL1 register as the source to bit slice 6.
	PINT_PMSRC_SRC6_INPUT_1 = 0x1
	// Input 2. Selects the pin selected in the PINTSEL2 register as the source to bit slice 6.
	PINT_PMSRC_SRC6_INPUT_2 = 0x2
	// Input 3. Selects the pin selected in the PINTSEL3 register as the source to bit slice 6.
	PINT_PMSRC_SRC6_INPUT_3 = 0x3
	// Input 4. Selects the pin selected in the PINTSEL4 register as the source to bit slice 6.
	PINT_PMSRC_SRC6_INPUT_4 = 0x4
	// Input 5. Selects the pin selected in the PINTSEL5 register as the source to bit slice 6.
	PINT_PMSRC_SRC6_INPUT_5 = 0x5
	// Input 6. Selects the pin selected in the PINTSEL6 register as the source to bit slice 6.
	PINT_PMSRC_SRC6_INPUT_6 = 0x6
	// Input 7. Selects the pin selected in the PINTSEL7 register as the source to bit slice 6.
	PINT_PMSRC_SRC6_INPUT_7 = 0x7
	// Position of SRC7 field.
	PINT_PMSRC_SRC7_Pos = 0x1d
	// Bit mask of SRC7 field.
	PINT_PMSRC_SRC7_Msk = 0xe0000000
	// Input 0. Selects the pin selected in the PINTSEL0 register as the source to bit slice 7.
	PINT_PMSRC_SRC7_INPUT_0 = 0x0
	// Input 1. Selects the pin selected in the PINTSEL1 register as the source to bit slice 7.
	PINT_PMSRC_SRC7_INPUT_1 = 0x1
	// Input 2. Selects the pin selected in the PINTSEL2 register as the source to bit slice 7.
	PINT_PMSRC_SRC7_INPUT_2 = 0x2
	// Input 3. Selects the pin selected in the PINTSEL3 register as the source to bit slice 7.
	PINT_PMSRC_SRC7_INPUT_3 = 0x3
	// Input 4. Selects the pin selected in the PINTSEL4 register as the source to bit slice 7.
	PINT_PMSRC_SRC7_INPUT_4 = 0x4
	// Input 5. Selects the pin selected in the PINTSEL5 register as the source to bit slice 7.
	PINT_PMSRC_SRC7_INPUT_5 = 0x5
	// Input 6. Selects the pin selected in the PINTSEL6 register as the source to bit slice 7.
	PINT_PMSRC_SRC7_INPUT_6 = 0x6
	// Input 7. Selects the pin selected in the PINTSEL7 register as the source to bit slice 7.
	PINT_PMSRC_SRC7_INPUT_7 = 0x7

	// PMCFG: Pattern match interrupt bit slice configuration register
	// Position of PROD_ENDPTS0 field.
	PINT_PMCFG_PROD_ENDPTS0_Pos = 0x0
	// Bit mask of PROD_ENDPTS0 field.
	PINT_PMCFG_PROD_ENDPTS0_Msk = 0x1
	// Bit PROD_ENDPTS0.
	PINT_PMCFG_PROD_ENDPTS0 = 0x1
	// No effect. Slice 0 is not an endpoint.
	PINT_PMCFG_PROD_ENDPTS0_NO_EFFECT = 0x0
	// endpoint. Slice 0 is the endpoint of a product term (minterm). Pin interrupt 0 in the NVIC is raised if the minterm evaluates as true.
	PINT_PMCFG_PROD_ENDPTS0_ENDPOINT = 0x1
	// Position of PROD_ENDPTS1 field.
	PINT_PMCFG_PROD_ENDPTS1_Pos = 0x1
	// Bit mask of PROD_ENDPTS1 field.
	PINT_PMCFG_PROD_ENDPTS1_Msk = 0x2
	// Bit PROD_ENDPTS1.
	PINT_PMCFG_PROD_ENDPTS1 = 0x2
	// No effect. Slice 1 is not an endpoint.
	PINT_PMCFG_PROD_ENDPTS1_NO_EFFECT = 0x0
	// endpoint. Slice 1 is the endpoint of a product term (minterm). Pin interrupt 1 in the NVIC is raised if the minterm evaluates as true.
	PINT_PMCFG_PROD_ENDPTS1_ENDPOINT = 0x1
	// Position of PROD_ENDPTS2 field.
	PINT_PMCFG_PROD_ENDPTS2_Pos = 0x2
	// Bit mask of PROD_ENDPTS2 field.
	PINT_PMCFG_PROD_ENDPTS2_Msk = 0x4
	// Bit PROD_ENDPTS2.
	PINT_PMCFG_PROD_ENDPTS2 = 0x4
	// No effect. Slice 2 is not an endpoint.
	PINT_PMCFG_PROD_ENDPTS2_NO_EFFECT = 0x0
	// endpoint. Slice 2 is the endpoint of a product term (minterm). Pin interrupt 2 in the NVIC is raised if the minterm evaluates as true.
	PINT_PMCFG_PROD_ENDPTS2_ENDPOINT = 0x1
	// Position of PROD_ENDPTS3 field.
	PINT_PMCFG_PROD_ENDPTS3_Pos = 0x3
	// Bit mask of PROD_ENDPTS3 field.
	PINT_PMCFG_PROD_ENDPTS3_Msk = 0x8
	// Bit PROD_ENDPTS3.
	PINT_PMCFG_PROD_ENDPTS3 = 0x8
	// No effect. Slice 3 is not an endpoint.
	PINT_PMCFG_PROD_ENDPTS3_NO_EFFECT = 0x0
	// endpoint. Slice 3 is the endpoint of a product term (minterm). Pin interrupt 3 in the NVIC is raised if the minterm evaluates as true.
	PINT_PMCFG_PROD_ENDPTS3_ENDPOINT = 0x1
	// Position of PROD_ENDPTS4 field.
	PINT_PMCFG_PROD_ENDPTS4_Pos = 0x4
	// Bit mask of PROD_ENDPTS4 field.
	PINT_PMCFG_PROD_ENDPTS4_Msk = 0x10
	// Bit PROD_ENDPTS4.
	PINT_PMCFG_PROD_ENDPTS4 = 0x10
	// No effect. Slice 4 is not an endpoint.
	PINT_PMCFG_PROD_ENDPTS4_NO_EFFECT = 0x0
	// endpoint. Slice 4 is the endpoint of a product term (minterm). Pin interrupt 4 in the NVIC is raised if the minterm evaluates as true.
	PINT_PMCFG_PROD_ENDPTS4_ENDPOINT = 0x1
	// Position of PROD_ENDPTS5 field.
	PINT_PMCFG_PROD_ENDPTS5_Pos = 0x5
	// Bit mask of PROD_ENDPTS5 field.
	PINT_PMCFG_PROD_ENDPTS5_Msk = 0x20
	// Bit PROD_ENDPTS5.
	PINT_PMCFG_PROD_ENDPTS5 = 0x20
	// No effect. Slice 5 is not an endpoint.
	PINT_PMCFG_PROD_ENDPTS5_NO_EFFECT = 0x0
	// endpoint. Slice 5 is the endpoint of a product term (minterm). Pin interrupt 5 in the NVIC is raised if the minterm evaluates as true.
	PINT_PMCFG_PROD_ENDPTS5_ENDPOINT = 0x1
	// Position of PROD_ENDPTS6 field.
	PINT_PMCFG_PROD_ENDPTS6_Pos = 0x6
	// Bit mask of PROD_ENDPTS6 field.
	PINT_PMCFG_PROD_ENDPTS6_Msk = 0x40
	// Bit PROD_ENDPTS6.
	PINT_PMCFG_PROD_ENDPTS6 = 0x40
	// No effect. Slice 6 is not an endpoint.
	PINT_PMCFG_PROD_ENDPTS6_NO_EFFECT = 0x0
	// endpoint. Slice 6 is the endpoint of a product term (minterm). Pin interrupt 6 in the NVIC is raised if the minterm evaluates as true.
	PINT_PMCFG_PROD_ENDPTS6_ENDPOINT = 0x1
	// Position of RESERVED field.
	PINT_PMCFG_RESERVED_Pos = 0x7
	// Bit mask of RESERVED field.
	PINT_PMCFG_RESERVED_Msk = 0x80
	// Bit RESERVED.
	PINT_PMCFG_RESERVED = 0x80
	// Position of CFG0 field.
	PINT_PMCFG_CFG0_Pos = 0x8
	// Bit mask of CFG0 field.
	PINT_PMCFG_CFG0_Msk = 0x700
	// Constant HIGH. This bit slice always contributes to a product term match.
	PINT_PMCFG_CFG0_CONSTANT_HIGH = 0x0
	// Sticky rising edge. Match occurs if a rising edge on the specified input has occurred since the last time the edge detection for this bit slice was cleared. This bit is only cleared when the PMCFG or the PMSRC registers are written to.
	PINT_PMCFG_CFG0_STICKY_RISING_EDGE = 0x1
	// Sticky falling edge. Match occurs if a falling edge on the specified input has occurred since the last time the edge detection for this bit slice was cleared. This bit is only cleared when the PMCFG or the PMSRC registers are written to.
	PINT_PMCFG_CFG0_STICKY_FALLING_EDGE = 0x2
	// Sticky rising or falling edge. Match occurs if either a rising or falling edge on the specified input has occurred since the last time the edge detection for this bit slice was cleared. This bit is only cleared when the PMCFG or the PMSRC registers are written to.
	PINT_PMCFG_CFG0_STICKY_RISING_OR_FAL = 0x3
	// High level. Match (for this bit slice) occurs when there is a high level on the input specified for this bit slice in the PMSRC register.
	PINT_PMCFG_CFG0_HIGH_LEVEL = 0x4
	// Low level. Match occurs when there is a low level on the specified input.
	PINT_PMCFG_CFG0_LOW_LEVEL = 0x5
	// Constant 0. This bit slice never contributes to a match (should be used to disable any unused bit slices).
	PINT_PMCFG_CFG0_CONSTANT_0 = 0x6
	// Event. Non-sticky rising or falling edge. Match occurs on an event - i.e. when either a rising or falling edge is first detected on the specified input (this is a non-sticky version of value 0x3) . This bit is cleared after one clock cycle.
	PINT_PMCFG_CFG0_EVENT = 0x7
	// Position of CFG1 field.
	PINT_PMCFG_CFG1_Pos = 0xb
	// Bit mask of CFG1 field.
	PINT_PMCFG_CFG1_Msk = 0x3800
	// Constant HIGH. This bit slice always contributes to a product term match.
	PINT_PMCFG_CFG1_CONSTANT_HIGH = 0x0
	// Sticky rising edge. Match occurs if a rising edge on the specified input has occurred since the last time the edge detection for this bit slice was cleared. This bit is only cleared when the PMCFG or the PMSRC registers are written to.
	PINT_PMCFG_CFG1_STICKY_RISING_EDGE = 0x1
	// Sticky falling edge. Match occurs if a falling edge on the specified input has occurred since the last time the edge detection for this bit slice was cleared. This bit is only cleared when the PMCFG or the PMSRC registers are written to.
	PINT_PMCFG_CFG1_STICKY_FALLING_EDGE = 0x2
	// Sticky rising or falling edge. Match occurs if either a rising or falling edge on the specified input has occurred since the last time the edge detection for this bit slice was cleared. This bit is only cleared when the PMCFG or the PMSRC registers are written to.
	PINT_PMCFG_CFG1_STICKY_RISING_OR_FAL = 0x3
	// High level. Match (for this bit slice) occurs when there is a high level on the input specified for this bit slice in the PMSRC register.
	PINT_PMCFG_CFG1_HIGH_LEVEL = 0x4
	// Low level. Match occurs when there is a low level on the specified input.
	PINT_PMCFG_CFG1_LOW_LEVEL = 0x5
	// Constant 0. This bit slice never contributes to a match (should be used to disable any unused bit slices).
	PINT_PMCFG_CFG1_CONSTANT_0 = 0x6
	// Event. Non-sticky rising or falling edge. Match occurs on an event - i.e. when either a rising or falling edge is first detected on the specified input (this is a non-sticky version of value 0x3) . This bit is cleared after one clock cycle.
	PINT_PMCFG_CFG1_EVENT = 0x7
	// Position of CFG2 field.
	PINT_PMCFG_CFG2_Pos = 0xe
	// Bit mask of CFG2 field.
	PINT_PMCFG_CFG2_Msk = 0x1c000
	// Constant HIGH. This bit slice always contributes to a product term match.
	PINT_PMCFG_CFG2_CONSTANT_HIGH = 0x0
	// Sticky rising edge. Match occurs if a rising edge on the specified input has occurred since the last time the edge detection for this bit slice was cleared. This bit is only cleared when the PMCFG or the PMSRC registers are written to.
	PINT_PMCFG_CFG2_STICKY_RISING_EDGE = 0x1
	// Sticky falling edge. Match occurs if a falling edge on the specified input has occurred since the last time the edge detection for this bit slice was cleared. This bit is only cleared when the PMCFG or the PMSRC registers are written to.
	PINT_PMCFG_CFG2_STICKY_FALLING_EDGE = 0x2
	// Sticky rising or falling edge. Match occurs if either a rising or falling edge on the specified input has occurred since the last time the edge detection for this bit slice was cleared. This bit is only cleared when the PMCFG or the PMSRC registers are written to.
	PINT_PMCFG_CFG2_STICKY_RISING_OR_FAL = 0x3
	// High level. Match (for this bit slice) occurs when there is a high level on the input specified for this bit slice in the PMSRC register.
	PINT_PMCFG_CFG2_HIGH_LEVEL = 0x4
	// Low level. Match occurs when there is a low level on the specified input.
	PINT_PMCFG_CFG2_LOW_LEVEL = 0x5
	// Constant 0. This bit slice never contributes to a match (should be used to disable any unused bit slices).
	PINT_PMCFG_CFG2_CONSTANT_0 = 0x6
	// Event. Non-sticky rising or falling edge. Match occurs on an event - i.e. when either a rising or falling edge is first detected on the specified input (this is a non-sticky version of value 0x3) . This bit is cleared after one clock cycle.
	PINT_PMCFG_CFG2_EVENT = 0x7
	// Position of CFG3 field.
	PINT_PMCFG_CFG3_Pos = 0x11
	// Bit mask of CFG3 field.
	PINT_PMCFG_CFG3_Msk = 0xe0000
	// Constant HIGH. This bit slice always contributes to a product term match.
	PINT_PMCFG_CFG3_CONSTANT_HIGH = 0x0
	// Sticky rising edge. Match occurs if a rising edge on the specified input has occurred since the last time the edge detection for this bit slice was cleared. This bit is only cleared when the PMCFG or the PMSRC registers are written to.
	PINT_PMCFG_CFG3_STICKY_RISING_EDGE = 0x1
	// Sticky falling edge. Match occurs if a falling edge on the specified input has occurred since the last time the edge detection for this bit slice was cleared. This bit is only cleared when the PMCFG or the PMSRC registers are written to.
	PINT_PMCFG_CFG3_STICKY_FALLING_EDGE = 0x2
	// Sticky rising or falling edge. Match occurs if either a rising or falling edge on the specified input has occurred since the last time the edge detection for this bit slice was cleared. This bit is only cleared when the PMCFG or the PMSRC registers are written to.
	PINT_PMCFG_CFG3_STICKY_RISING_OR_FAL = 0x3
	// High level. Match (for this bit slice) occurs when there is a high level on the input specified for this bit slice in the PMSRC register.
	PINT_PMCFG_CFG3_HIGH_LEVEL = 0x4
	// Low level. Match occurs when there is a low level on the specified input.
	PINT_PMCFG_CFG3_LOW_LEVEL = 0x5
	// Constant 0. This bit slice never contributes to a match (should be used to disable any unused bit slices).
	PINT_PMCFG_CFG3_CONSTANT_0 = 0x6
	// Event. Non-sticky rising or falling edge. Match occurs on an event - i.e. when either a rising or falling edge is first detected on the specified input (this is a non-sticky version of value 0x3) . This bit is cleared after one clock cycle.
	PINT_PMCFG_CFG3_EVENT = 0x7
	// Position of CFG4 field.
	PINT_PMCFG_CFG4_Pos = 0x14
	// Bit mask of CFG4 field.
	PINT_PMCFG_CFG4_Msk = 0x700000
	// Constant HIGH. This bit slice always contributes to a product term match.
	PINT_PMCFG_CFG4_CONSTANT_HIGH = 0x0
	// Sticky rising edge. Match occurs if a rising edge on the specified input has occurred since the last time the edge detection for this bit slice was cleared. This bit is only cleared when the PMCFG or the PMSRC registers are written to.
	PINT_PMCFG_CFG4_STICKY_RISING_EDGE = 0x1
	// Sticky falling edge. Match occurs if a falling edge on the specified input has occurred since the last time the edge detection for this bit slice was cleared. This bit is only cleared when the PMCFG or the PMSRC registers are written to.
	PINT_PMCFG_CFG4_STICKY_FALLING_EDGE = 0x2
	// Sticky rising or falling edge. Match occurs if either a rising or falling edge on the specified input has occurred since the last time the edge detection for this bit slice was cleared. This bit is only cleared when the PMCFG or the PMSRC registers are written to.
	PINT_PMCFG_CFG4_STICKY_RISING_OR_FAL = 0x3
	// High level. Match (for this bit slice) occurs when there is a high level on the input specified for this bit slice in the PMSRC register.
	PINT_PMCFG_CFG4_HIGH_LEVEL = 0x4
	// Low level. Match occurs when there is a low level on the specified input.
	PINT_PMCFG_CFG4_LOW_LEVEL = 0x5
	// Constant 0. This bit slice never contributes to a match (should be used to disable any unused bit slices).
	PINT_PMCFG_CFG4_CONSTANT_0 = 0x6
	// Event. Non-sticky rising or falling edge. Match occurs on an event - i.e. when either a rising or falling edge is first detected on the specified input (this is a non-sticky version of value 0x3) . This bit is cleared after one clock cycle.
	PINT_PMCFG_CFG4_EVENT = 0x7
	// Position of CFG5 field.
	PINT_PMCFG_CFG5_Pos = 0x17
	// Bit mask of CFG5 field.
	PINT_PMCFG_CFG5_Msk = 0x3800000
	// Constant HIGH. This bit slice always contributes to a product term match.
	PINT_PMCFG_CFG5_CONSTANT_HIGH = 0x0
	// Sticky rising edge. Match occurs if a rising edge on the specified input has occurred since the last time the edge detection for this bit slice was cleared. This bit is only cleared when the PMCFG or the PMSRC registers are written to.
	PINT_PMCFG_CFG5_STICKY_RISING_EDGE = 0x1
	// Sticky falling edge. Match occurs if a falling edge on the specified input has occurred since the last time the edge detection for this bit slice was cleared. This bit is only cleared when the PMCFG or the PMSRC registers are written to.
	PINT_PMCFG_CFG5_STICKY_FALLING_EDGE = 0x2
	// Sticky rising or falling edge. Match occurs if either a rising or falling edge on the specified input has occurred since the last time the edge detection for this bit slice was cleared. This bit is only cleared when the PMCFG or the PMSRC registers are written to.
	PINT_PMCFG_CFG5_STICKY_RISING_OR_FAL = 0x3
	// High level. Match (for this bit slice) occurs when there is a high level on the input specified for this bit slice in the PMSRC register.
	PINT_PMCFG_CFG5_HIGH_LEVEL = 0x4
	// Low level. Match occurs when there is a low level on the specified input.
	PINT_PMCFG_CFG5_LOW_LEVEL = 0x5
	// Constant 0. This bit slice never contributes to a match (should be used to disable any unused bit slices).
	PINT_PMCFG_CFG5_CONSTANT_0 = 0x6
	// Event. Non-sticky rising or falling edge. Match occurs on an event - i.e. when either a rising or falling edge is first detected on the specified input (this is a non-sticky version of value 0x3) . This bit is cleared after one clock cycle.
	PINT_PMCFG_CFG5_EVENT = 0x7
	// Position of CFG6 field.
	PINT_PMCFG_CFG6_Pos = 0x1a
	// Bit mask of CFG6 field.
	PINT_PMCFG_CFG6_Msk = 0x1c000000
	// Constant HIGH. This bit slice always contributes to a product term match.
	PINT_PMCFG_CFG6_CONSTANT_HIGH = 0x0
	// Sticky rising edge. Match occurs if a rising edge on the specified input has occurred since the last time the edge detection for this bit slice was cleared. This bit is only cleared when the PMCFG or the PMSRC registers are written to.
	PINT_PMCFG_CFG6_STICKY_RISING_EDGE = 0x1
	// Sticky falling edge. Match occurs if a falling edge on the specified input has occurred since the last time the edge detection for this bit slice was cleared. This bit is only cleared when the PMCFG or the PMSRC registers are written to.
	PINT_PMCFG_CFG6_STICKY_FALLING_EDGE = 0x2
	// Sticky rising or falling edge. Match occurs if either a rising or falling edge on the specified input has occurred since the last time the edge detection for this bit slice was cleared. This bit is only cleared when the PMCFG or the PMSRC registers are written to.
	PINT_PMCFG_CFG6_STICKY_RISING_OR_FAL = 0x3
	// High level. Match (for this bit slice) occurs when there is a high level on the input specified for this bit slice in the PMSRC register.
	PINT_PMCFG_CFG6_HIGH_LEVEL = 0x4
	// Low level. Match occurs when there is a low level on the specified input.
	PINT_PMCFG_CFG6_LOW_LEVEL = 0x5
	// Constant 0. This bit slice never contributes to a match (should be used to disable any unused bit slices).
	PINT_PMCFG_CFG6_CONSTANT_0 = 0x6
	// Event. Non-sticky rising or falling edge. Match occurs on an event - i.e. when either a rising or falling edge is first detected on the specified input (this is a non-sticky version of value 0x3) . This bit is cleared after one clock cycle.
	PINT_PMCFG_CFG6_EVENT = 0x7
	// Position of CFG7 field.
	PINT_PMCFG_CFG7_Pos = 0x1d
	// Bit mask of CFG7 field.
	PINT_PMCFG_CFG7_Msk = 0xe0000000
	// Constant HIGH. This bit slice always contributes to a product term match.
	PINT_PMCFG_CFG7_CONSTANT_HIGH = 0x0
	// Sticky rising edge. Match occurs if a rising edge on the specified input has occurred since the last time the edge detection for this bit slice was cleared. This bit is only cleared when the PMCFG or the PMSRC registers are written to.
	PINT_PMCFG_CFG7_STICKY_RISING_EDGE = 0x1
	// Sticky falling edge. Match occurs if a falling edge on the specified input has occurred since the last time the edge detection for this bit slice was cleared. This bit is only cleared when the PMCFG or the PMSRC registers are written to.
	PINT_PMCFG_CFG7_STICKY_FALLING_EDGE = 0x2
	// Sticky rising or falling edge. Match occurs if either a rising or falling edge on the specified input has occurred since the last time the edge detection for this bit slice was cleared. This bit is only cleared when the PMCFG or the PMSRC registers are written to.
	PINT_PMCFG_CFG7_STICKY_RISING_OR_FAL = 0x3
	// High level. Match (for this bit slice) occurs when there is a high level on the input specified for this bit slice in the PMSRC register.
	PINT_PMCFG_CFG7_HIGH_LEVEL = 0x4
	// Low level. Match occurs when there is a low level on the specified input.
	PINT_PMCFG_CFG7_LOW_LEVEL = 0x5
	// Constant 0. This bit slice never contributes to a match (should be used to disable any unused bit slices).
	PINT_PMCFG_CFG7_CONSTANT_0 = 0x6
	// Event. Non-sticky rising or falling edge. Match occurs on an event - i.e. when either a rising or falling edge is first detected on the specified input (this is a non-sticky version of value 0x3) . This bit is cleared after one clock cycle.
	PINT_PMCFG_CFG7_EVENT = 0x7
)

// Bitfields for IOCON: I/O pin configuration
const (
	// PIO0_0: Digital I/O control for port 0 pins PIO0_0 to PIO0_15.
	// Position of FUNC field.
	IOCON_PIO0_FUNC_Pos = 0x0
	// Bit mask of FUNC field.
	IOCON_PIO0_FUNC_Msk = 0x7
	// Position of MODE field.
	IOCON_PIO0_MODE_Pos = 0x3
	// Bit mask of MODE field.
	IOCON_PIO0_MODE_Msk = 0x18
	// Inactive. Inactive (no pull-down/pull-up resistor enabled).
	IOCON_PIO0_MODE_INACTIVE = 0x0
	// Pull-down. Pull-down resistor enabled.
	IOCON_PIO0_MODE_PULL_DOWN = 0x1
	// Pull-up. Pull-up resistor enabled.
	IOCON_PIO0_MODE_PULL_UP = 0x2
	// Repeater. Repeater mode.
	IOCON_PIO0_MODE_REPEATER = 0x3
	// Position of RESERVED field.
	IOCON_PIO0_RESERVED_Pos = 0x5
	// Bit mask of RESERVED field.
	IOCON_PIO0_RESERVED_Msk = 0x20
	// Bit RESERVED.
	IOCON_PIO0_RESERVED = 0x20
	// Position of INVERT field.
	IOCON_PIO0_INVERT_Pos = 0x6
	// Bit mask of INVERT field.
	IOCON_PIO0_INVERT_Msk = 0x40
	// Bit INVERT.
	IOCON_PIO0_INVERT = 0x40
	// Disabled. Input function is not inverted.
	IOCON_PIO0_INVERT_DISABLED = 0x0
	// Enabled. Input is function inverted.
	IOCON_PIO0_INVERT_ENABLED = 0x1
	// Position of DIGIMODE field.
	IOCON_PIO0_DIGIMODE_Pos = 0x7
	// Bit mask of DIGIMODE field.
	IOCON_PIO0_DIGIMODE_Msk = 0x80
	// Bit DIGIMODE.
	IOCON_PIO0_DIGIMODE = 0x80
	// Analog mode.
	IOCON_PIO0_DIGIMODE_ANALOG_MODE = 0x0
	// Digital mode.
	IOCON_PIO0_DIGIMODE_DIGITAL_MODE = 0x1
	// Position of FILTEROFF field.
	IOCON_PIO0_FILTEROFF_Pos = 0x8
	// Bit mask of FILTEROFF field.
	IOCON_PIO0_FILTEROFF_Msk = 0x100
	// Bit FILTEROFF.
	IOCON_PIO0_FILTEROFF = 0x100
	// Filter enabled. Noise pulses below approximately 10 ns are filtered out
	IOCON_PIO0_FILTEROFF_FILTER_ENABLED = 0x0
	// Filter disabled. No input filtering is done
	IOCON_PIO0_FILTEROFF_FILTER_DISABLED = 0x1
	// Position of SLEW field.
	IOCON_PIO0_SLEW_Pos = 0x9
	// Bit mask of SLEW field.
	IOCON_PIO0_SLEW_Msk = 0x200
	// Bit SLEW.
	IOCON_PIO0_SLEW = 0x200
	// Standard mode, output slew rate control is enabled. More outputs can be switched simultaneously.
	IOCON_PIO0_SLEW_STANDARD_MODE = 0x0
	// Fast mode, slew rate control is disabled. Refer to the appropriate specific device data sheet for details.
	IOCON_PIO0_SLEW_FAST_MODE = 0x1
	// Position of OD field.
	IOCON_PIO0_OD_Pos = 0xa
	// Bit mask of OD field.
	IOCON_PIO0_OD_Msk = 0x400
	// Bit OD.
	IOCON_PIO0_OD = 0x400
	// Normal. Normal push-pull output
	IOCON_PIO0_OD_NORMAL = 0x0
	// Open-drain. Simulated open-drain output (high drive disabled)
	IOCON_PIO0_OD_OPEN_DRAIN = 0x1
	// Position of RESERVED field.
	IOCON_PIO0_RESERVED_Pos = 0xb
	// Bit mask of RESERVED field.
	IOCON_PIO0_RESERVED_Msk = 0xfffff800

	// PIO0_16: Digital I/O control for port 0 pins PIO0_16 to PIO0_17.
	// Position of FUNC field.
	IOCON_PIO0_FUNC_Pos = 0x0
	// Bit mask of FUNC field.
	IOCON_PIO0_FUNC_Msk = 0x7
	// Position of MODE field.
	IOCON_PIO0_MODE_Pos = 0x3
	// Bit mask of MODE field.
	IOCON_PIO0_MODE_Msk = 0x18
	// Inactive. Inactive (no pull-down/pull-up resistor enabled).
	IOCON_PIO0_MODE_INACTIVE = 0x0
	// Pull-down. Pull-down resistor enabled.
	IOCON_PIO0_MODE_PULL_DOWN = 0x1
	// Pull-up. Pull-up resistor enabled.
	IOCON_PIO0_MODE_PULL_UP = 0x2
	// Repeater. Repeater mode.
	IOCON_PIO0_MODE_REPEATER = 0x3
	// Position of RESERVED field.
	IOCON_PIO0_RESERVED_Pos = 0x5
	// Bit mask of RESERVED field.
	IOCON_PIO0_RESERVED_Msk = 0x20
	// Bit RESERVED.
	IOCON_PIO0_RESERVED = 0x20
	// Position of INVERT field.
	IOCON_PIO0_INVERT_Pos = 0x6
	// Bit mask of INVERT field.
	IOCON_PIO0_INVERT_Msk = 0x40
	// Bit INVERT.
	IOCON_PIO0_INVERT = 0x40
	// Disabled. Input function is not inverted.
	IOCON_PIO0_INVERT_DISABLED = 0x0
	// Enabled. Input is function inverted.
	IOCON_PIO0_INVERT_ENABLED = 0x1
	// Position of DIGIMODE field.
	IOCON_PIO0_DIGIMODE_Pos = 0x7
	// Bit mask of DIGIMODE field.
	IOCON_PIO0_DIGIMODE_Msk = 0x80
	// Bit DIGIMODE.
	IOCON_PIO0_DIGIMODE = 0x80
	// Analog mode.
	IOCON_PIO0_DIGIMODE_ANALOG_MODE = 0x0
	// Digital mode.
	IOCON_PIO0_DIGIMODE_DIGITAL_MODE = 0x1
	// Position of FILTEROFF field.
	IOCON_PIO0_FILTEROFF_Pos = 0x8
	// Bit mask of FILTEROFF field.
	IOCON_PIO0_FILTEROFF_Msk = 0x100
	// Bit FILTEROFF.
	IOCON_PIO0_FILTEROFF = 0x100
	// Filter enabled. Noise pulses below approximately 10 ns are filtered out
	IOCON_PIO0_FILTEROFF_FILTER_ENABLED = 0x0
	// Filter disabled. No input filtering is done
	IOCON_PIO0_FILTEROFF_FILTER_DISABLED = 0x1
	// Position of SLEW field.
	IOCON_PIO0_SLEW_Pos = 0x9
	// Bit mask of SLEW field.
	IOCON_PIO0_SLEW_Msk = 0x200
	// Bit SLEW.
	IOCON_PIO0_SLEW = 0x200
	// Standard mode, output slew rate control is enabled. More outputs can be switched simultaneously.
	IOCON_PIO0_SLEW_STANDARD_MODE = 0x0
	// Fast mode, slew rate control is disabled. Refer to the appropriate specific device data sheet for details.
	IOCON_PIO0_SLEW_FAST_MODE = 0x1
	// Position of OD field.
	IOCON_PIO0_OD_Pos = 0xa
	// Bit mask of OD field.
	IOCON_PIO0_OD_Msk = 0x400
	// Bit OD.
	IOCON_PIO0_OD = 0x400
	// Normal. Normal push-pull output
	IOCON_PIO0_OD_NORMAL = 0x0
	// Open-drain. Simulated open-drain output (high drive disabled)
	IOCON_PIO0_OD_OPEN_DRAIN = 0x1
	// Position of RESERVED field.
	IOCON_PIO0_RESERVED_Pos = 0xb
	// Bit mask of RESERVED field.
	IOCON_PIO0_RESERVED_Msk = 0xfffff800

	// PIO0_18: Digital I/O control for port 0 pins PIO0_18 to PIO0_22.
	// Position of FUNC field.
	IOCON_PIO0_FUNC_Pos = 0x0
	// Bit mask of FUNC field.
	IOCON_PIO0_FUNC_Msk = 0x7
	// Position of MODE field.
	IOCON_PIO0_MODE_Pos = 0x3
	// Bit mask of MODE field.
	IOCON_PIO0_MODE_Msk = 0x18
	// Inactive. Inactive (no pull-down/pull-up resistor enabled).
	IOCON_PIO0_MODE_INACTIVE = 0x0
	// Pull-down. Pull-down resistor enabled.
	IOCON_PIO0_MODE_PULL_DOWN = 0x1
	// Pull-up. Pull-up resistor enabled.
	IOCON_PIO0_MODE_PULL_UP = 0x2
	// Repeater. Repeater mode.
	IOCON_PIO0_MODE_REPEATER = 0x3
	// Position of RESERVED field.
	IOCON_PIO0_RESERVED_Pos = 0x5
	// Bit mask of RESERVED field.
	IOCON_PIO0_RESERVED_Msk = 0x20
	// Bit RESERVED.
	IOCON_PIO0_RESERVED = 0x20
	// Position of INVERT field.
	IOCON_PIO0_INVERT_Pos = 0x6
	// Bit mask of INVERT field.
	IOCON_PIO0_INVERT_Msk = 0x40
	// Bit INVERT.
	IOCON_PIO0_INVERT = 0x40
	// Disabled. Input function is not inverted.
	IOCON_PIO0_INVERT_DISABLED = 0x0
	// Enabled. Input is function inverted.
	IOCON_PIO0_INVERT_ENABLED = 0x1
	// Position of DIGIMODE field.
	IOCON_PIO0_DIGIMODE_Pos = 0x7
	// Bit mask of DIGIMODE field.
	IOCON_PIO0_DIGIMODE_Msk = 0x80
	// Bit DIGIMODE.
	IOCON_PIO0_DIGIMODE = 0x80
	// Analog mode.
	IOCON_PIO0_DIGIMODE_ANALOG_MODE = 0x0
	// Digital mode.
	IOCON_PIO0_DIGIMODE_DIGITAL_MODE = 0x1
	// Position of FILTEROFF field.
	IOCON_PIO0_FILTEROFF_Pos = 0x8
	// Bit mask of FILTEROFF field.
	IOCON_PIO0_FILTEROFF_Msk = 0x100
	// Bit FILTEROFF.
	IOCON_PIO0_FILTEROFF = 0x100
	// Filter enabled. Noise pulses below approximately 10 ns are filtered out
	IOCON_PIO0_FILTEROFF_FILTER_ENABLED = 0x0
	// Filter disabled. No input filtering is done
	IOCON_PIO0_FILTEROFF_FILTER_DISABLED = 0x1
	// Position of SLEW field.
	IOCON_PIO0_SLEW_Pos = 0x9
	// Bit mask of SLEW field.
	IOCON_PIO0_SLEW_Msk = 0x200
	// Bit SLEW.
	IOCON_PIO0_SLEW = 0x200
	// Standard mode, output slew rate control is enabled. More outputs can be switched simultaneously.
	IOCON_PIO0_SLEW_STANDARD_MODE = 0x0
	// Fast mode, slew rate control is disabled. Refer to the appropriate specific device data sheet for details.
	IOCON_PIO0_SLEW_FAST_MODE = 0x1
	// Position of OD field.
	IOCON_PIO0_OD_Pos = 0xa
	// Bit mask of OD field.
	IOCON_PIO0_OD_Msk = 0x400
	// Bit OD.
	IOCON_PIO0_OD = 0x400
	// Normal. Normal push-pull output
	IOCON_PIO0_OD_NORMAL = 0x0
	// Open-drain. Simulated open-drain output (high drive disabled)
	IOCON_PIO0_OD_OPEN_DRAIN = 0x1
	// Position of RESERVED field.
	IOCON_PIO0_RESERVED_Pos = 0xb
	// Bit mask of RESERVED field.
	IOCON_PIO0_RESERVED_Msk = 0xfffff800

	// PIO0_23: Digital I/O control for port 0 pins PIO0_23 to PIO0_28. These pins support I2C with true open-drain, drive and filtering for modes up to Fast-mode Plus.
	// Position of FUNC field.
	IOCON_PIO0_FUNC_Pos = 0x0
	// Bit mask of FUNC field.
	IOCON_PIO0_FUNC_Msk = 0x7
	// Position of RESERVED field.
	IOCON_PIO0_RESERVED_Pos = 0x3
	// Bit mask of RESERVED field.
	IOCON_PIO0_RESERVED_Msk = 0x18
	// Position of I2CSLEW field.
	IOCON_PIO0_I2CSLEW_Pos = 0x5
	// Bit mask of I2CSLEW field.
	IOCON_PIO0_I2CSLEW_Msk = 0x20
	// Bit I2CSLEW.
	IOCON_PIO0_I2CSLEW = 0x20
	// I2C mode.
	IOCON_PIO0_I2CSLEW_I2C_MODE = 0x0
	// GPIO mode.
	IOCON_PIO0_I2CSLEW_GPIO_MODE = 0x1
	// Position of INVERT field.
	IOCON_PIO0_INVERT_Pos = 0x6
	// Bit mask of INVERT field.
	IOCON_PIO0_INVERT_Msk = 0x40
	// Bit INVERT.
	IOCON_PIO0_INVERT = 0x40
	// Disabled. Input function is not inverted.
	IOCON_PIO0_INVERT_DISABLED = 0x0
	// Enabled. Input is function inverted.
	IOCON_PIO0_INVERT_ENABLED = 0x1
	// Position of DIGIMODE field.
	IOCON_PIO0_DIGIMODE_Pos = 0x7
	// Bit mask of DIGIMODE field.
	IOCON_PIO0_DIGIMODE_Msk = 0x80
	// Bit DIGIMODE.
	IOCON_PIO0_DIGIMODE = 0x80
	// Analog mode.
	IOCON_PIO0_DIGIMODE_ANALOG_MODE = 0x0
	// Digital mode.
	IOCON_PIO0_DIGIMODE_DIGITAL_MODE = 0x1
	// Position of FILTEROFF field.
	IOCON_PIO0_FILTEROFF_Pos = 0x8
	// Bit mask of FILTEROFF field.
	IOCON_PIO0_FILTEROFF_Msk = 0x100
	// Bit FILTEROFF.
	IOCON_PIO0_FILTEROFF = 0x100
	// Filter enabled. Noise pulses below approximately 10 ns are filtered out
	IOCON_PIO0_FILTEROFF_FILTER_ENABLED = 0x0
	// Filter disabled. No input filtering is done
	IOCON_PIO0_FILTEROFF_FILTER_DISABLED = 0x1
	// Position of I2CDRIVE field.
	IOCON_PIO0_I2CDRIVE_Pos = 0x9
	// Bit mask of I2CDRIVE field.
	IOCON_PIO0_I2CDRIVE_Msk = 0x200
	// Bit I2CDRIVE.
	IOCON_PIO0_I2CDRIVE = 0x200
	// Low drive. Output drive sink is 4 mA. This is sufficient for standard and fast mode I2C.
	IOCON_PIO0_I2CDRIVE_LOW_DRIVE = 0x0
	// High drive. Output drive sink is 20 mA. This is needed for Fast Mode Plus I 2C. Refer to the appropriate specific device data sheet for details.
	IOCON_PIO0_I2CDRIVE_HIGH_DRIVE = 0x1
	// Position of I2CFILTER field.
	IOCON_PIO0_I2CFILTER_Pos = 0xa
	// Bit mask of I2CFILTER field.
	IOCON_PIO0_I2CFILTER_Msk = 0x400
	// Bit I2CFILTER.
	IOCON_PIO0_I2CFILTER = 0x400
	// Enabled. I2C 50 ns glitch filter enabled.
	IOCON_PIO0_I2CFILTER_ENABLED = 0x0
	// Disabled. I2C 50 ns glitch filter disabled.
	IOCON_PIO0_I2CFILTER_DISABLED = 0x1
	// Position of RESERVED field.
	IOCON_PIO0_RESERVED_Pos = 0xb
	// Bit mask of RESERVED field.
	IOCON_PIO0_RESERVED_Msk = 0xfffff800

	// PIO0_29: Digital I/O control for port 0 pins PIO0_29 to PIO0_31. These pins include an ADC input.
	// Position of FUNC field.
	IOCON_PIO0_FUNC_Pos = 0x0
	// Bit mask of FUNC field.
	IOCON_PIO0_FUNC_Msk = 0x7
	// Position of MODE field.
	IOCON_PIO0_MODE_Pos = 0x3
	// Bit mask of MODE field.
	IOCON_PIO0_MODE_Msk = 0x18
	// Inactive. Inactive (no pull-down/pull-up resistor enabled).
	IOCON_PIO0_MODE_INACTIVE = 0x0
	// Pull-down. Pull-down resistor enabled.
	IOCON_PIO0_MODE_PULL_DOWN = 0x1
	// Pull-up. Pull-up resistor enabled.
	IOCON_PIO0_MODE_PULL_UP = 0x2
	// Repeater. Repeater mode.
	IOCON_PIO0_MODE_REPEATER = 0x3
	// Position of RESERVED field.
	IOCON_PIO0_RESERVED_Pos = 0x5
	// Bit mask of RESERVED field.
	IOCON_PIO0_RESERVED_Msk = 0x20
	// Bit RESERVED.
	IOCON_PIO0_RESERVED = 0x20
	// Position of INVERT field.
	IOCON_PIO0_INVERT_Pos = 0x6
	// Bit mask of INVERT field.
	IOCON_PIO0_INVERT_Msk = 0x40
	// Bit INVERT.
	IOCON_PIO0_INVERT = 0x40
	// Disabled. Input function is not inverted.
	IOCON_PIO0_INVERT_DISABLED = 0x0
	// Enabled. Input is function inverted.
	IOCON_PIO0_INVERT_ENABLED = 0x1
	// Position of DIGIMODE field.
	IOCON_PIO0_DIGIMODE_Pos = 0x7
	// Bit mask of DIGIMODE field.
	IOCON_PIO0_DIGIMODE_Msk = 0x80
	// Bit DIGIMODE.
	IOCON_PIO0_DIGIMODE = 0x80
	// Analog mode.
	IOCON_PIO0_DIGIMODE_ANALOG_MODE = 0x0
	// Digital mode.
	IOCON_PIO0_DIGIMODE_DIGITAL_MODE = 0x1
	// Position of FILTEROFF field.
	IOCON_PIO0_FILTEROFF_Pos = 0x8
	// Bit mask of FILTEROFF field.
	IOCON_PIO0_FILTEROFF_Msk = 0x100
	// Bit FILTEROFF.
	IOCON_PIO0_FILTEROFF = 0x100
	// Filter enabled. Noise pulses below approximately 10 ns are filtered out
	IOCON_PIO0_FILTEROFF_FILTER_ENABLED = 0x0
	// Filter disabled. No input filtering is done
	IOCON_PIO0_FILTEROFF_FILTER_DISABLED = 0x1
	// Position of RESERVED field.
	IOCON_PIO0_RESERVED_Pos = 0x9
	// Bit mask of RESERVED field.
	IOCON_PIO0_RESERVED_Msk = 0x200
	// Bit RESERVED.
	IOCON_PIO0_RESERVED = 0x200
	// Position of OD field.
	IOCON_PIO0_OD_Pos = 0xa
	// Bit mask of OD field.
	IOCON_PIO0_OD_Msk = 0x400
	// Bit OD.
	IOCON_PIO0_OD = 0x400
	// Normal. Normal push-pull output
	IOCON_PIO0_OD_NORMAL = 0x0
	// Open-drain. Simulated open-drain output (high drive disabled)
	IOCON_PIO0_OD_OPEN_DRAIN = 0x1
	// Position of RESERVED field.
	IOCON_PIO0_RESERVED_Pos = 0xb
	// Bit mask of RESERVED field.
	IOCON_PIO0_RESERVED_Msk = 0xfffff800

	// PIO1_0: Digital I/O control for port 1 pins PIO0_0 to PIO0_8. These pins include an ADC input.
	// Position of FUNC field.
	IOCON_PIO1_FUNC_Pos = 0x0
	// Bit mask of FUNC field.
	IOCON_PIO1_FUNC_Msk = 0x7
	// Position of MODE field.
	IOCON_PIO1_MODE_Pos = 0x3
	// Bit mask of MODE field.
	IOCON_PIO1_MODE_Msk = 0x18
	// Inactive. Inactive (no pull-down/pull-up resistor enabled).
	IOCON_PIO1_MODE_INACTIVE = 0x0
	// Pull-down. Pull-down resistor enabled.
	IOCON_PIO1_MODE_PULL_DOWN = 0x1
	// Pull-up. Pull-up resistor enabled.
	IOCON_PIO1_MODE_PULL_UP = 0x2
	// Repeater. Repeater mode.
	IOCON_PIO1_MODE_REPEATER = 0x3
	// Position of RESERVED field.
	IOCON_PIO1_RESERVED_Pos = 0x5
	// Bit mask of RESERVED field.
	IOCON_PIO1_RESERVED_Msk = 0x20
	// Bit RESERVED.
	IOCON_PIO1_RESERVED = 0x20
	// Position of INVERT field.
	IOCON_PIO1_INVERT_Pos = 0x6
	// Bit mask of INVERT field.
	IOCON_PIO1_INVERT_Msk = 0x40
	// Bit INVERT.
	IOCON_PIO1_INVERT = 0x40
	// Disabled. Input function is not inverted.
	IOCON_PIO1_INVERT_DISABLED = 0x0
	// Enabled. Input is function inverted.
	IOCON_PIO1_INVERT_ENABLED = 0x1
	// Position of DIGIMODE field.
	IOCON_PIO1_DIGIMODE_Pos = 0x7
	// Bit mask of DIGIMODE field.
	IOCON_PIO1_DIGIMODE_Msk = 0x80
	// Bit DIGIMODE.
	IOCON_PIO1_DIGIMODE = 0x80
	// Analog mode.
	IOCON_PIO1_DIGIMODE_ANALOG_MODE = 0x0
	// Digital mode.
	IOCON_PIO1_DIGIMODE_DIGITAL_MODE = 0x1
	// Position of FILTEROFF field.
	IOCON_PIO1_FILTEROFF_Pos = 0x8
	// Bit mask of FILTEROFF field.
	IOCON_PIO1_FILTEROFF_Msk = 0x100
	// Bit FILTEROFF.
	IOCON_PIO1_FILTEROFF = 0x100
	// Filter enabled. Noise pulses below approximately 10 ns are filtered out
	IOCON_PIO1_FILTEROFF_FILTER_ENABLED = 0x0
	// Filter disabled. No input filtering is done
	IOCON_PIO1_FILTEROFF_FILTER_DISABLED = 0x1
	// Position of RESERVED field.
	IOCON_PIO1_RESERVED_Pos = 0x9
	// Bit mask of RESERVED field.
	IOCON_PIO1_RESERVED_Msk = 0x200
	// Bit RESERVED.
	IOCON_PIO1_RESERVED = 0x200
	// Position of OD field.
	IOCON_PIO1_OD_Pos = 0xa
	// Bit mask of OD field.
	IOCON_PIO1_OD_Msk = 0x400
	// Bit OD.
	IOCON_PIO1_OD = 0x400
	// Normal. Normal push-pull output
	IOCON_PIO1_OD_NORMAL = 0x0
	// Open-drain. Simulated open-drain output (high drive disabled)
	IOCON_PIO1_OD_OPEN_DRAIN = 0x1
	// Position of RESERVED field.
	IOCON_PIO1_RESERVED_Pos = 0xb
	// Bit mask of RESERVED field.
	IOCON_PIO1_RESERVED_Msk = 0xfffff800

	// PIO1_9: Digital I/O control for port 1 pins PIO1_9 to PIO1_17.
	// Position of FUNC field.
	IOCON_PIO1_FUNC_Pos = 0x0
	// Bit mask of FUNC field.
	IOCON_PIO1_FUNC_Msk = 0x7
	// Position of MODE field.
	IOCON_PIO1_MODE_Pos = 0x3
	// Bit mask of MODE field.
	IOCON_PIO1_MODE_Msk = 0x18
	// Inactive. Inactive (no pull-down/pull-up resistor enabled).
	IOCON_PIO1_MODE_INACTIVE = 0x0
	// Pull-down. Pull-down resistor enabled.
	IOCON_PIO1_MODE_PULL_DOWN = 0x1
	// Pull-up. Pull-up resistor enabled.
	IOCON_PIO1_MODE_PULL_UP = 0x2
	// Repeater. Repeater mode.
	IOCON_PIO1_MODE_REPEATER = 0x3
	// Position of RESERVED field.
	IOCON_PIO1_RESERVED_Pos = 0x5
	// Bit mask of RESERVED field.
	IOCON_PIO1_RESERVED_Msk = 0x20
	// Bit RESERVED.
	IOCON_PIO1_RESERVED = 0x20
	// Position of INVERT field.
	IOCON_PIO1_INVERT_Pos = 0x6
	// Bit mask of INVERT field.
	IOCON_PIO1_INVERT_Msk = 0x40
	// Bit INVERT.
	IOCON_PIO1_INVERT = 0x40
	// Disabled. Input function is not inverted.
	IOCON_PIO1_INVERT_DISABLED = 0x0
	// Enabled. Input is function inverted.
	IOCON_PIO1_INVERT_ENABLED = 0x1
	// Position of DIGIMODE field.
	IOCON_PIO1_DIGIMODE_Pos = 0x7
	// Bit mask of DIGIMODE field.
	IOCON_PIO1_DIGIMODE_Msk = 0x80
	// Bit DIGIMODE.
	IOCON_PIO1_DIGIMODE = 0x80
	// Analog mode.
	IOCON_PIO1_DIGIMODE_ANALOG_MODE = 0x0
	// Digital mode.
	IOCON_PIO1_DIGIMODE_DIGITAL_MODE = 0x1
	// Position of FILTEROFF field.
	IOCON_PIO1_FILTEROFF_Pos = 0x8
	// Bit mask of FILTEROFF field.
	IOCON_PIO1_FILTEROFF_Msk = 0x100
	// Bit FILTEROFF.
	IOCON_PIO1_FILTEROFF = 0x100
	// Filter enabled. Noise pulses below approximately 10 ns are filtered out
	IOCON_PIO1_FILTEROFF_FILTER_ENABLED = 0x0
	// Filter disabled. No input filtering is done
	IOCON_PIO1_FILTEROFF_FILTER_DISABLED = 0x1
	// Position of SLEW field.
	IOCON_PIO1_SLEW_Pos = 0x9
	// Bit mask of SLEW field.
	IOCON_PIO1_SLEW_Msk = 0x200
	// Bit SLEW.
	IOCON_PIO1_SLEW = 0x200
	// Standard mode, output slew rate control is enabled. More outputs can be switched simultaneously.
	IOCON_PIO1_SLEW_STANDARD_MODE = 0x0
	// Fast mode, slew rate control is disabled. Refer to the appropriate specific device data sheet for details.
	IOCON_PIO1_SLEW_FAST_MODE = 0x1
	// Position of OD field.
	IOCON_PIO1_OD_Pos = 0xa
	// Bit mask of OD field.
	IOCON_PIO1_OD_Msk = 0x400
	// Bit OD.
	IOCON_PIO1_OD = 0x400
	// Normal. Normal push-pull output
	IOCON_PIO1_OD_NORMAL = 0x0
	// Open-drain. Simulated open-drain output (high drive disabled)
	IOCON_PIO1_OD_OPEN_DRAIN = 0x1
	// Position of RESERVED field.
	IOCON_PIO1_RESERVED_Pos = 0xb
	// Bit mask of RESERVED field.
	IOCON_PIO1_RESERVED_Msk = 0xfffff800
)

// Bitfields for UTICK: Micro-tick timer
const (
	// CTRL: Control register.
	// Position of DELAYVAL field.
	UTICK_CTRL_DELAYVAL_Pos = 0x0
	// Bit mask of DELAYVAL field.
	UTICK_CTRL_DELAYVAL_Msk = 0x7fffffff
	// Position of REPEAT field.
	UTICK_CTRL_REPEAT_Pos = 0x1f
	// Bit mask of REPEAT field.
	UTICK_CTRL_REPEAT_Msk = 0x80000000
	// Bit REPEAT.
	UTICK_CTRL_REPEAT = 0x80000000

	// STAT: Status register.
	// Position of INTR field.
	UTICK_STAT_INTR_Pos = 0x0
	// Bit mask of INTR field.
	UTICK_STAT_INTR_Msk = 0x1
	// Bit INTR.
	UTICK_STAT_INTR = 0x1
	// Position of ACTIVE field.
	UTICK_STAT_ACTIVE_Pos = 0x1
	// Bit mask of ACTIVE field.
	UTICK_STAT_ACTIVE_Msk = 0x2
	// Bit ACTIVE.
	UTICK_STAT_ACTIVE = 0x2
	// Position of RESERVED field.
	UTICK_STAT_RESERVED_Pos = 0x2
	// Bit mask of RESERVED field.
	UTICK_STAT_RESERVED_Msk = 0xfffffffc
)

// Bitfields for ADVSYSCON: Advanced System configuration
const (
	// BODCTRL: Brown-Out Detect control
	// Position of BODRSTLEV field.
	ADVSYSCON_BODCTRL_BODRSTLEV_Pos = 0x0
	// Bit mask of BODRSTLEV field.
	ADVSYSCON_BODCTRL_BODRSTLEV_Msk = 0x3
	// Level 0: 1.5 V
	ADVSYSCON_BODCTRL_BODRSTLEV_LEVEL_0_1 = 0x0
	// Level 1: 1.85 V
	ADVSYSCON_BODCTRL_BODRSTLEV_LEVEL_1_1 = 0x1
	// Level 2: 2.0 V
	ADVSYSCON_BODCTRL_BODRSTLEV_LEVEL_2_2 = 0x2
	// Level 3: 2.3 V
	ADVSYSCON_BODCTRL_BODRSTLEV_LEVEL_3_2 = 0x3
	// Position of BODINTVAL field.
	ADVSYSCON_BODCTRL_BODINTVAL_Pos = 0x2
	// Bit mask of BODINTVAL field.
	ADVSYSCON_BODCTRL_BODINTVAL_Msk = 0xc
	// Level 0: 2.05 V
	ADVSYSCON_BODCTRL_BODINTVAL_LEVEL_0_2 = 0x0
	// Level 1: 2.45 V
	ADVSYSCON_BODCTRL_BODINTVAL_LEVEL_1_2 = 0x1
	// Level 2: 2.75 V
	ADVSYSCON_BODCTRL_BODINTVAL_LEVEL_2_2 = 0x2
	// Level 3: 3.05 V
	ADVSYSCON_BODCTRL_BODINTVAL_LEVEL_3_3 = 0x3
	// Position of BODRSTENA field.
	ADVSYSCON_BODCTRL_BODRSTENA_Pos = 0x4
	// Bit mask of BODRSTENA field.
	ADVSYSCON_BODCTRL_BODRSTENA_Msk = 0x10
	// Bit BODRSTENA.
	ADVSYSCON_BODCTRL_BODRSTENA = 0x10
	// Disable reset function.
	ADVSYSCON_BODCTRL_BODRSTENA_DISABLE_RESET_FUNCTI = 0x0
	// Enable reset function.
	ADVSYSCON_BODCTRL_BODRSTENA_ENABLE_RESET_FUNCTIO = 0x1
	// Position of RESERVED field.
	ADVSYSCON_BODCTRL_RESERVED_Pos = 0x5
	// Bit mask of RESERVED field.
	ADVSYSCON_BODCTRL_RESERVED_Msk = 0xffffffe0
)

// Bitfields for WWDT: Windowed Watchdog Timer
const (
	// MOD: Watchdog mode register. This register contains the basic mode and status of the Watchdog Timer.
	// Position of WDEN field.
	WWDT_MOD_WDEN_Pos = 0x0
	// Bit mask of WDEN field.
	WWDT_MOD_WDEN_Msk = 0x1
	// Bit WDEN.
	WWDT_MOD_WDEN = 0x1
	// Stop. The watchdog timer is stopped.
	WWDT_MOD_WDEN_STOP = 0x0
	// Run. The watchdog timer is running.
	WWDT_MOD_WDEN_RUN = 0x1
	// Position of WDRESET field.
	WWDT_MOD_WDRESET_Pos = 0x1
	// Bit mask of WDRESET field.
	WWDT_MOD_WDRESET_Msk = 0x2
	// Bit WDRESET.
	WWDT_MOD_WDRESET = 0x2
	// Interrupt. A watchdog time-out will not cause a chip reset.
	WWDT_MOD_WDRESET_INTERRUPT = 0x0
	// Reset. A watchdog time-out will cause a chip reset.
	WWDT_MOD_WDRESET_RESET = 0x1
	// Position of WDTOF field.
	WWDT_MOD_WDTOF_Pos = 0x2
	// Bit mask of WDTOF field.
	WWDT_MOD_WDTOF_Msk = 0x4
	// Bit WDTOF.
	WWDT_MOD_WDTOF = 0x4
	// Position of WDINT field.
	WWDT_MOD_WDINT_Pos = 0x3
	// Bit mask of WDINT field.
	WWDT_MOD_WDINT_Msk = 0x8
	// Bit WDINT.
	WWDT_MOD_WDINT = 0x8
	// Position of WDPROTECT field.
	WWDT_MOD_WDPROTECT_Pos = 0x4
	// Bit mask of WDPROTECT field.
	WWDT_MOD_WDPROTECT_Msk = 0x10
	// Bit WDPROTECT.
	WWDT_MOD_WDPROTECT = 0x10
	// Flexible. The watchdog time-out value (TC) can be changed at any time.
	WWDT_MOD_WDPROTECT_FLEXIBLE = 0x0
	// Threshold. The watchdog time-out value (TC) can be changed only after the counter is below the value of WDWARNINT and WDWINDOW.
	WWDT_MOD_WDPROTECT_THRESHOLD = 0x1
	// Position of LOCK field.
	WWDT_MOD_LOCK_Pos = 0x5
	// Bit mask of LOCK field.
	WWDT_MOD_LOCK_Msk = 0x20
	// Bit LOCK.
	WWDT_MOD_LOCK = 0x20
	// Position of RESERVED field.
	WWDT_MOD_RESERVED_Pos = 0x6
	// Bit mask of RESERVED field.
	WWDT_MOD_RESERVED_Msk = 0xffffffc0

	// TC: Watchdog timer constant register. This 24-bit register determines the time-out value.
	// Position of COUNT field.
	WWDT_TC_COUNT_Pos = 0x0
	// Bit mask of COUNT field.
	WWDT_TC_COUNT_Msk = 0xffffff
	// Position of RESERVED field.
	WWDT_TC_RESERVED_Pos = 0x18
	// Bit mask of RESERVED field.
	WWDT_TC_RESERVED_Msk = 0xff000000

	// FEED: Watchdog feed sequence register. Writing 0xAA followed by 0x55 to this register reloads the Watchdog timer with the value contained in WDTC.
	// Position of FEED field.
	WWDT_FEED_FEED_Pos = 0x0
	// Bit mask of FEED field.
	WWDT_FEED_FEED_Msk = 0xff
	// Position of RESERVED field.
	WWDT_FEED_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	WWDT_FEED_RESERVED_Msk = 0xffffff00

	// TV: Watchdog timer value register. This 24-bit register reads out the current value of the Watchdog timer.
	// Position of COUNT field.
	WWDT_TV_COUNT_Pos = 0x0
	// Bit mask of COUNT field.
	WWDT_TV_COUNT_Msk = 0xffffff
	// Position of RESERVED field.
	WWDT_TV_RESERVED_Pos = 0x18
	// Bit mask of RESERVED field.
	WWDT_TV_RESERVED_Msk = 0xff000000

	// WARNINT: Watchdog Warning Interrupt compare value.
	// Position of WARNINT field.
	WWDT_WARNINT_WARNINT_Pos = 0x0
	// Bit mask of WARNINT field.
	WWDT_WARNINT_WARNINT_Msk = 0x3ff
	// Position of RESERVED field.
	WWDT_WARNINT_RESERVED_Pos = 0xa
	// Bit mask of RESERVED field.
	WWDT_WARNINT_RESERVED_Msk = 0xfffffc00

	// WINDOW: Watchdog Window compare value.
	// Position of WINDOW field.
	WWDT_WINDOW_WINDOW_Pos = 0x0
	// Bit mask of WINDOW field.
	WWDT_WINDOW_WINDOW_Msk = 0xffffff
	// Position of RESERVED field.
	WWDT_WINDOW_RESERVED_Pos = 0x18
	// Bit mask of RESERVED field.
	WWDT_WINDOW_RESERVED_Msk = 0xff000000
)

// Bitfields for RTC: Real-Time Clock
const (
	// CTRL: RTC control register
	// Position of SWRESET field.
	RTC_CTRL_SWRESET_Pos = 0x0
	// Bit mask of SWRESET field.
	RTC_CTRL_SWRESET_Msk = 0x1
	// Bit SWRESET.
	RTC_CTRL_SWRESET = 0x1
	// Not in reset. The RTC is not held in reset. This bit must be cleared prior to configuring or initiating any operation of the RTC.
	RTC_CTRL_SWRESET_NOT_IN_RESET = 0x0
	// In reset. The RTC is held in reset. All register bits within the RTC will be forced to their reset value except the OFD bit. This bit must be cleared before writing to any register in the RTC - including writes to set any of the other bits within this register. Do not attempt to write to any bits of this register at the same time that the reset bit is being cleared.
	RTC_CTRL_SWRESET_IN_RESET = 0x1
	// Position of OFD field.
	RTC_CTRL_OFD_Pos = 0x1
	// Bit mask of OFD field.
	RTC_CTRL_OFD_Msk = 0x2
	// Bit OFD.
	RTC_CTRL_OFD = 0x2
	// Run. The RTC oscillator is running properly. Writing a 0 has no effect.
	RTC_CTRL_OFD_RUN = 0x0
	// Fail. RTC oscillator fail detected. Clear this flag after the following power-up. Writing a 1 clears this bit.
	RTC_CTRL_OFD_FAIL = 0x1
	// Position of ALARM1HZ field.
	RTC_CTRL_ALARM1HZ_Pos = 0x2
	// Bit mask of ALARM1HZ field.
	RTC_CTRL_ALARM1HZ_Msk = 0x4
	// Bit ALARM1HZ.
	RTC_CTRL_ALARM1HZ = 0x4
	// No match. No match has occurred on the 1 Hz RTC timer. Writing a 0 has no effect.
	RTC_CTRL_ALARM1HZ_NO_MATCH = 0x0
	// Match. A match condition has occurred on the 1 Hz RTC timer. This flag generates an RTC alarm interrupt request RTC_ALARM which can also wake up the part from any low power mode. Writing a 1 clears this bit.
	RTC_CTRL_ALARM1HZ_MATCH = 0x1
	// Position of WAKE1KHZ field.
	RTC_CTRL_WAKE1KHZ_Pos = 0x3
	// Bit mask of WAKE1KHZ field.
	RTC_CTRL_WAKE1KHZ_Msk = 0x8
	// Bit WAKE1KHZ.
	RTC_CTRL_WAKE1KHZ = 0x8
	// Run. The RTC 1 kHz timer is running. Writing a 0 has no effect.
	RTC_CTRL_WAKE1KHZ_RUN = 0x0
	// Time-out. The 1 kHz high-resolution/wake-up timer has timed out. This flag generates an RTC wake-up interrupt request RTC-WAKE which can also wake up the part from any low power mode. Writing a 1 clears this bit.
	RTC_CTRL_WAKE1KHZ_TIME_OUT = 0x1
	// Position of ALARMDPD_EN field.
	RTC_CTRL_ALARMDPD_EN_Pos = 0x4
	// Bit mask of ALARMDPD_EN field.
	RTC_CTRL_ALARMDPD_EN_Msk = 0x10
	// Bit ALARMDPD_EN.
	RTC_CTRL_ALARMDPD_EN = 0x10
	// Disable. A match on the 1 Hz RTC timer will not bring the part out of Deep power-down mode.
	RTC_CTRL_ALARMDPD_EN_DISABLE = 0x0
	// Enable. A match on the 1 Hz RTC timer bring the part out of Deep power-down mode.
	RTC_CTRL_ALARMDPD_EN_ENABLE = 0x1
	// Position of WAKEDPD_EN field.
	RTC_CTRL_WAKEDPD_EN_Pos = 0x5
	// Bit mask of WAKEDPD_EN field.
	RTC_CTRL_WAKEDPD_EN_Msk = 0x20
	// Bit WAKEDPD_EN.
	RTC_CTRL_WAKEDPD_EN = 0x20
	// Disable. A match on the 1 kHz RTC timer will not bring the part out of Deep power-down mode.
	RTC_CTRL_WAKEDPD_EN_DISABLE = 0x0
	// Enable. A match on the 1 kHz RTC timer bring the part out of Deep power-down mode.
	RTC_CTRL_WAKEDPD_EN_ENABLE = 0x1
	// Position of RTC1KHZ_EN field.
	RTC_CTRL_RTC1KHZ_EN_Pos = 0x6
	// Bit mask of RTC1KHZ_EN field.
	RTC_CTRL_RTC1KHZ_EN_Msk = 0x40
	// Bit RTC1KHZ_EN.
	RTC_CTRL_RTC1KHZ_EN = 0x40
	// Disable. A match on the 1 kHz RTC timer will not bring the part out of Deep power-down mode.
	RTC_CTRL_RTC1KHZ_EN_DISABLE = 0x0
	// Enable. The 1 kHz RTC timer is enabled.
	RTC_CTRL_RTC1KHZ_EN_ENABLE = 0x1
	// Position of RTC_EN field.
	RTC_CTRL_RTC_EN_Pos = 0x7
	// Bit mask of RTC_EN field.
	RTC_CTRL_RTC_EN_Msk = 0x80
	// Bit RTC_EN.
	RTC_CTRL_RTC_EN = 0x80
	// Disable. The RTC 1 Hz and 1 kHz clocks are shut down and the RTC operation is disabled. This bit should be 0 when writing to load a value in the RTC counter register.
	RTC_CTRL_RTC_EN_DISABLE = 0x0
	// Enable. The 1 Hz RTC clock is running and RTC operation is enabled. This bit must be set to initiate operation of the RTC. The first clock to the RTC counter occurs 1 s after this bit is set. To also enable the high-resolution, 1 kHz clock, set bit 6 in this register.
	RTC_CTRL_RTC_EN_ENABLE = 0x1
	// Position of RESERVED field.
	RTC_CTRL_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	RTC_CTRL_RESERVED_Msk = 0xffffff00

	// MATCH: RTC match register
	// Position of MATVAL field.
	RTC_MATCH_MATVAL_Pos = 0x0
	// Bit mask of MATVAL field.
	RTC_MATCH_MATVAL_Msk = 0xffffffff

	// COUNT: RTC counter register
	// Position of VAL field.
	RTC_COUNT_VAL_Pos = 0x0
	// Bit mask of VAL field.
	RTC_COUNT_VAL_Msk = 0xffffffff

	// WAKE: RTC high-resolution/wake-up timer control register
	// Position of VAL field.
	RTC_WAKE_VAL_Pos = 0x0
	// Bit mask of VAL field.
	RTC_WAKE_VAL_Msk = 0xffff
	// Position of RESERVED field.
	RTC_WAKE_RESERVED_Pos = 0x10
	// Bit mask of RESERVED field.
	RTC_WAKE_RESERVED_Msk = 0xffff0000
)

// Bitfields for INPUTMUX: Input multiplexing
const (
	// PINTSEL0: Pin interrupt select register 0
	// Position of INTPIN field.
	INPUTMUX_PINTSEL_INTPIN_Pos = 0x0
	// Bit mask of INTPIN field.
	INPUTMUX_PINTSEL_INTPIN_Msk = 0xff
	// Position of RESERVED field.
	INPUTMUX_PINTSEL_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	INPUTMUX_PINTSEL_RESERVED_Msk = 0xffffff00

	// DMA_ITRIG_INMUX0: Trigger select register for DMA channel 0
	// Position of INP field.
	INPUTMUX_DMA_ITRIG_INMUX_INP_Pos = 0x0
	// Bit mask of INP field.
	INPUTMUX_DMA_ITRIG_INMUX_INP_Msk = 0x1f
	// Position of RESERVED field.
	INPUTMUX_DMA_ITRIG_INMUX_RESERVED_Pos = 0x5
	// Bit mask of RESERVED field.
	INPUTMUX_DMA_ITRIG_INMUX_RESERVED_Msk = 0xffffffe0

	// DMA_OTRIG_INMUX0: DMA output trigger selection to become DMA trigger 16
	// Position of INP field.
	INPUTMUX_DMA_OTRIG_INMUX_INP_Pos = 0x0
	// Bit mask of INP field.
	INPUTMUX_DMA_OTRIG_INMUX_INP_Msk = 0x1f
	// Position of RESERVED field.
	INPUTMUX_DMA_OTRIG_INMUX_RESERVED_Pos = 0x5
	// Bit mask of RESERVED field.
	INPUTMUX_DMA_OTRIG_INMUX_RESERVED_Msk = 0xffffffe0

	// FREQMEAS_REF: Clock selection for frequency measurement function reference clock
	// Position of CLKIN field.
	INPUTMUX_FREQMEAS_REF_CLKIN_Pos = 0x0
	// Bit mask of CLKIN field.
	INPUTMUX_FREQMEAS_REF_CLKIN_Msk = 0x1f
	// Position of RESERVED field.
	INPUTMUX_FREQMEAS_REF_RESERVED_Pos = 0x5
	// Bit mask of RESERVED field.
	INPUTMUX_FREQMEAS_REF_RESERVED_Msk = 0xffffffe0

	// FREQMEAS_TARGET: Clock selection for frequency measurement function target clock
	// Position of CLKIN field.
	INPUTMUX_FREQMEAS_TARGET_CLKIN_Pos = 0x0
	// Bit mask of CLKIN field.
	INPUTMUX_FREQMEAS_TARGET_CLKIN_Msk = 0x1f
	// Position of RESERVED field.
	INPUTMUX_FREQMEAS_TARGET_RESERVED_Pos = 0x5
	// Bit mask of RESERVED field.
	INPUTMUX_FREQMEAS_TARGET_RESERVED_Msk = 0xffffffe0
)

// Bitfields for RIT: Repetitive Interrupt Timer
const (
	// COMPVAL: Compare value LSB register. Holds the 32 LSBs of the compare value.
	// Position of RICOMP field.
	RIT_COMPVAL_RICOMP_Pos = 0x0
	// Bit mask of RICOMP field.
	RIT_COMPVAL_RICOMP_Msk = 0xffffffff

	// MASK: Mask LSB register. This register holds the 32 LSB s of the mask value. A 1 written to any bit will force the compare to be true for the corresponding bit of the counter and compare register.
	// Position of RIMASK field.
	RIT_MASK_RIMASK_Pos = 0x0
	// Bit mask of RIMASK field.
	RIT_MASK_RIMASK_Msk = 0xffffffff

	// CTRL: Control register.
	// Position of RITINT field.
	RIT_CTRL_RITINT_Pos = 0x0
	// Bit mask of RITINT field.
	RIT_CTRL_RITINT_Msk = 0x1
	// Bit RITINT.
	RIT_CTRL_RITINT = 0x1
	// This bit is set to 1 by hardware whenever the counter value equals the masked compare value specified by the contents of RICOMPVAL and RIMASK registers. Writing a 1 to this bit will clear it to 0. Writing a 0 has no effect.
	RIT_CTRL_RITINT_MATCH = 0x1
	// The counter value does not equal the masked compare value.
	RIT_CTRL_RITINT_NOMTCH = 0x0
	// Position of RITENCLR field.
	RIT_CTRL_RITENCLR_Pos = 0x1
	// Bit mask of RITENCLR field.
	RIT_CTRL_RITENCLR_Msk = 0x2
	// Bit RITENCLR.
	RIT_CTRL_RITENCLR = 0x2
	// The timer will be cleared to 0 whenever the counter value equals the masked compare value specified by the contents of COMPVAL/COMPVAL_H and MASK/MASK_H registers. This will occur on the same clock that sets the interrupt flag.
	RIT_CTRL_RITENCLR_CLEAR = 0x1
	// The timer will not be cleared to 0.
	RIT_CTRL_RITENCLR_NOCLEAR = 0x0
	// Position of RITENBR field.
	RIT_CTRL_RITENBR_Pos = 0x2
	// Bit mask of RITENBR field.
	RIT_CTRL_RITENBR_Msk = 0x4
	// Bit RITENBR.
	RIT_CTRL_RITENBR = 0x4
	// The timer is halted when the processor is halted for debugging.
	RIT_CTRL_RITENBR_HALT = 0x1
	// Debug has no effect on the timer operation.
	RIT_CTRL_RITENBR_DEBUG = 0x0
	// Position of RITEN field.
	RIT_CTRL_RITEN_Pos = 0x3
	// Bit mask of RITEN field.
	RIT_CTRL_RITEN_Msk = 0x8
	// Bit RITEN.
	RIT_CTRL_RITEN = 0x8
	// Timer enabled. This can be overruled by a debug halt if enabled in bit 2.
	RIT_CTRL_RITEN_TIMER_ENABLED = 0x1
	// Timer disabled.
	RIT_CTRL_RITEN_TIMER_DISABLED = 0x0
	// Position of RESERVED field.
	RIT_CTRL_RESERVED_Pos = 0x4
	// Bit mask of RESERVED field.
	RIT_CTRL_RESERVED_Msk = 0xfffffff0

	// COUNTER: Counter LSB register. 32 LSBs of the counter.
	// Position of RICOUNTER field.
	RIT_COUNTER_RICOUNTER_Pos = 0x0
	// Bit mask of RICOUNTER field.
	RIT_COUNTER_RICOUNTER_Msk = 0xffffffff

	// COMPVAL_H: Compare value MSB register. Holds the 16 MSBs of the compare value.
	// Position of RICOMP field.
	RIT_COMPVAL_H_RICOMP_Pos = 0x0
	// Bit mask of RICOMP field.
	RIT_COMPVAL_H_RICOMP_Msk = 0xffff
	// Position of RESERVED field.
	RIT_COMPVAL_H_RESERVED_Pos = 0x10
	// Bit mask of RESERVED field.
	RIT_COMPVAL_H_RESERVED_Msk = 0xffff0000

	// MASK_H: Mask MSB register. This register holds the 16 MSBs of the mask value. A 1 written to any bit will force a compare on the corresponding bit of the counter and compare register.
	// Position of RIMASK field.
	RIT_MASK_H_RIMASK_Pos = 0x0
	// Bit mask of RIMASK field.
	RIT_MASK_H_RIMASK_Msk = 0xffff
	// Position of RESERVED field.
	RIT_MASK_H_RESERVED_Pos = 0x10
	// Bit mask of RESERVED field.
	RIT_MASK_H_RESERVED_Msk = 0xffff0000

	// COUNTER_H: Counter MSB register. 16 MSBs of the counter.
	// Position of RICOUNTER field.
	RIT_COUNTER_H_RICOUNTER_Pos = 0x0
	// Bit mask of RICOUNTER field.
	RIT_COUNTER_H_RICOUNTER_Msk = 0xffff
	// Position of RESERVED field.
	RIT_COUNTER_H_RESERVED_Pos = 0x10
	// Bit mask of RESERVED field.
	RIT_COUNTER_H_RESERVED_Msk = 0xffff0000
)

// Bitfields for MRT: Multi-Rate Timer
const (
	// INTVAL0: MRTn Time interval value register. This value is loaded into the TIMER0 register.
	// Position of IVALUE field.
	MRT_INTVAL_IVALUE_Pos = 0x0
	// Bit mask of IVALUE field.
	MRT_INTVAL_IVALUE_Msk = 0xffffff
	// Position of RESERVED field.
	MRT_INTVAL_RESERVED_Pos = 0x18
	// Bit mask of RESERVED field.
	MRT_INTVAL_RESERVED_Msk = 0x7f000000
	// Position of LOAD field.
	MRT_INTVAL_LOAD_Pos = 0x1f
	// Bit mask of LOAD field.
	MRT_INTVAL_LOAD_Msk = 0x80000000
	// Bit LOAD.
	MRT_INTVAL_LOAD = 0x80000000
	// No force load. The load from the INTVALn register to the TIMERn register is processed at the end of the time interval if the repeat mode is selected.
	MRT_INTVAL_LOAD_NO_FORCE_LOAD = 0x0
	// Force load. The INTVALn interval value IVALUE -1 is immediately loaded into the TIMERn register while TIMERn is running.
	MRT_INTVAL_LOAD_FORCE_LOAD = 0x1

	// TIMER0: MRTn Timer register. This register reads the value of the down-counter.
	// Position of VALUE field.
	MRT_TIMER_VALUE_Pos = 0x0
	// Bit mask of VALUE field.
	MRT_TIMER_VALUE_Msk = 0xffffff
	// Position of RESERVED field.
	MRT_TIMER_RESERVED_Pos = 0x18
	// Bit mask of RESERVED field.
	MRT_TIMER_RESERVED_Msk = 0xff000000

	// CTRL0: MRTn Control register. This register controls the MRTn modes.
	// Position of INTEN field.
	MRT_CTRL_INTEN_Pos = 0x0
	// Bit mask of INTEN field.
	MRT_CTRL_INTEN_Msk = 0x1
	// Bit INTEN.
	MRT_CTRL_INTEN = 0x1
	// TIMERn interrupt is disabled.
	MRT_CTRL_INTEN_DISABLED = 0x0
	// TIMERn interrupt is enabled.
	MRT_CTRL_INTEN_ENABLED = 0x1
	// Position of MODE field.
	MRT_CTRL_MODE_Pos = 0x1
	// Bit mask of MODE field.
	MRT_CTRL_MODE_Msk = 0x6
	// Repeat interrupt mode.
	MRT_CTRL_MODE_REPEAT_INTERRUPT_MOD = 0x0
	// One-shot interrupt mode.
	MRT_CTRL_MODE_ONE_SHOT_INTERRUPT_M = 0x1
	// One-shot stall mode.
	MRT_CTRL_MODE_ONE_SHOT_STALL_MODE = 0x2
	// Position of RESERVED field.
	MRT_CTRL_RESERVED_Pos = 0x3
	// Bit mask of RESERVED field.
	MRT_CTRL_RESERVED_Msk = 0xfffffff8

	// STAT0: MRTn Status register.
	// Position of INTFLAG field.
	MRT_STAT_INTFLAG_Pos = 0x0
	// Bit mask of INTFLAG field.
	MRT_STAT_INTFLAG_Msk = 0x1
	// Bit INTFLAG.
	MRT_STAT_INTFLAG = 0x1
	// No pending interrupt. Writing a zero is equivalent to no operation.
	MRT_STAT_INTFLAG_NO_PENDING_INTERRUPT = 0x0
	// Pending interrupt. The interrupt is pending because TIMERn has reached the end of the time interval. If the INTEN bit in the CONTROLn is also set to 1, the interrupt for timer channel n and the global interrupt are raised. Writing a 1 to this bit clears the interrupt request.
	MRT_STAT_INTFLAG_PENDING_INTERRUPT = 0x1
	// Position of RUN field.
	MRT_STAT_RUN_Pos = 0x1
	// Bit mask of RUN field.
	MRT_STAT_RUN_Msk = 0x2
	// Bit RUN.
	MRT_STAT_RUN = 0x2
	// Idle state. TIMERn is stopped.
	MRT_STAT_RUN_IDLE_STATE = 0x0
	// Running. TIMERn is running.
	MRT_STAT_RUN_RUNNING = 0x1
	// Position of INUSE field.
	MRT_STAT_INUSE_Pos = 0x2
	// Bit mask of INUSE field.
	MRT_STAT_INUSE_Msk = 0x4
	// Bit INUSE.
	MRT_STAT_INUSE = 0x4
	// This channel is not in use.
	MRT_STAT_INUSE_NO = 0x0
	// This channel is in use.
	MRT_STAT_INUSE_YES = 0x1
	// Position of RESERVED field.
	MRT_STAT_RESERVED_Pos = 0x2
	// Bit mask of RESERVED field.
	MRT_STAT_RESERVED_Msk = 0xfffffffc

	// MODCFG: Module Configuration register. This register provides information about this particular MRT instance, and allows choosing an overall mode for the idle channel feature.
	// Position of NOC field.
	MRT_MODCFG_NOC_Pos = 0x0
	// Bit mask of NOC field.
	MRT_MODCFG_NOC_Msk = 0xf
	// Position of NOB field.
	MRT_MODCFG_NOB_Pos = 0x4
	// Bit mask of NOB field.
	MRT_MODCFG_NOB_Msk = 0x1f0
	// Position of RESERVED field.
	MRT_MODCFG_RESERVED_Pos = 0x9
	// Bit mask of RESERVED field.
	MRT_MODCFG_RESERVED_Msk = 0x7ffffe00
	// Position of MULTITASK field.
	MRT_MODCFG_MULTITASK_Pos = 0x1f
	// Bit mask of MULTITASK field.
	MRT_MODCFG_MULTITASK_Msk = 0x80000000
	// Bit MULTITASK.
	MRT_MODCFG_MULTITASK = 0x80000000
	// Hardware status mode. In this mode, the INUSE(n) flags for all channels are reset.
	MRT_MODCFG_MULTITASK_HARDWARE_STATUS_MODE = 0x0
	// Multi-task mode.
	MRT_MODCFG_MULTITASK_MULTI_TASK_MODE = 0x1

	// IDLE_CH: Idle channel register. This register returns the number of the first idle channel.
	// Position of RESERVED field.
	MRT_IDLE_CH_RESERVED_Pos = 0x0
	// Bit mask of RESERVED field.
	MRT_IDLE_CH_RESERVED_Msk = 0xf
	// Position of CHAN field.
	MRT_IDLE_CH_CHAN_Pos = 0x4
	// Bit mask of CHAN field.
	MRT_IDLE_CH_CHAN_Msk = 0xf0
	// Position of RESERVED field.
	MRT_IDLE_CH_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	MRT_IDLE_CH_RESERVED_Msk = 0xffffff00

	// IRQ_FLAG: Global interrupt flag register
	// Position of GFLAG0 field.
	MRT_IRQ_FLAG_GFLAG0_Pos = 0x0
	// Bit mask of GFLAG0 field.
	MRT_IRQ_FLAG_GFLAG0_Msk = 0x1
	// Bit GFLAG0.
	MRT_IRQ_FLAG_GFLAG0 = 0x1
	// No pending interrupt. Writing a zero is equivalent to no operation.
	MRT_IRQ_FLAG_GFLAG0_NO_PENDING_INTERRUPT = 0x0
	// Pending interrupt. The interrupt is pending because TIMER0 has reached the end of the time interval. If the INTEN bit in the CONTROL0 register is also set to 1, the interrupt for timer channel 0 and the global interrupt are raised. Writing a 1 to this bit clears the interrupt request.
	MRT_IRQ_FLAG_GFLAG0_PENDING_INTERRUPT = 0x1
	// Position of GFLAG1 field.
	MRT_IRQ_FLAG_GFLAG1_Pos = 0x1
	// Bit mask of GFLAG1 field.
	MRT_IRQ_FLAG_GFLAG1_Msk = 0x2
	// Bit GFLAG1.
	MRT_IRQ_FLAG_GFLAG1 = 0x2
	// Position of GFLAG2 field.
	MRT_IRQ_FLAG_GFLAG2_Pos = 0x2
	// Bit mask of GFLAG2 field.
	MRT_IRQ_FLAG_GFLAG2_Msk = 0x4
	// Bit GFLAG2.
	MRT_IRQ_FLAG_GFLAG2 = 0x4
	// Position of GFLAG3 field.
	MRT_IRQ_FLAG_GFLAG3_Pos = 0x3
	// Bit mask of GFLAG3 field.
	MRT_IRQ_FLAG_GFLAG3_Msk = 0x8
	// Bit GFLAG3.
	MRT_IRQ_FLAG_GFLAG3 = 0x8
	// Position of RESERVED field.
	MRT_IRQ_FLAG_RESERVED_Pos = 0x4
	// Bit mask of RESERVED field.
	MRT_IRQ_FLAG_RESERVED_Msk = 0xfffffff0
)

// Bitfields for ASYNCSYSCON: Asynchronous system configuration
const (
	// AYSNCPRESETCTRL: Async peripheral reset control
	// Position of RESERVED field.
	ASYNCSYSCON_AYSNCPRESETCTRL_RESERVED_Pos = 0x0
	// Bit mask of RESERVED field.
	ASYNCSYSCON_AYSNCPRESETCTRL_RESERVED_Msk = 0x1
	// Bit RESERVED.
	ASYNCSYSCON_AYSNCPRESETCTRL_RESERVED = 0x1
	// Position of USART0 field.
	ASYNCSYSCON_AYSNCPRESETCTRL_USART0_Pos = 0x1
	// Bit mask of USART0 field.
	ASYNCSYSCON_AYSNCPRESETCTRL_USART0_Msk = 0x2
	// Bit USART0.
	ASYNCSYSCON_AYSNCPRESETCTRL_USART0 = 0x2
	// Position of USART1 field.
	ASYNCSYSCON_AYSNCPRESETCTRL_USART1_Pos = 0x2
	// Bit mask of USART1 field.
	ASYNCSYSCON_AYSNCPRESETCTRL_USART1_Msk = 0x4
	// Bit USART1.
	ASYNCSYSCON_AYSNCPRESETCTRL_USART1 = 0x4
	// Position of USART2 field.
	ASYNCSYSCON_AYSNCPRESETCTRL_USART2_Pos = 0x3
	// Bit mask of USART2 field.
	ASYNCSYSCON_AYSNCPRESETCTRL_USART2_Msk = 0x8
	// Bit USART2.
	ASYNCSYSCON_AYSNCPRESETCTRL_USART2 = 0x8
	// Position of USART3 field.
	ASYNCSYSCON_AYSNCPRESETCTRL_USART3_Pos = 0x4
	// Bit mask of USART3 field.
	ASYNCSYSCON_AYSNCPRESETCTRL_USART3_Msk = 0x10
	// Bit USART3.
	ASYNCSYSCON_AYSNCPRESETCTRL_USART3 = 0x10
	// Position of I2C0 field.
	ASYNCSYSCON_AYSNCPRESETCTRL_I2C0_Pos = 0x5
	// Bit mask of I2C0 field.
	ASYNCSYSCON_AYSNCPRESETCTRL_I2C0_Msk = 0x20
	// Bit I2C0.
	ASYNCSYSCON_AYSNCPRESETCTRL_I2C0 = 0x20
	// Position of I2C1 field.
	ASYNCSYSCON_AYSNCPRESETCTRL_I2C1_Pos = 0x6
	// Bit mask of I2C1 field.
	ASYNCSYSCON_AYSNCPRESETCTRL_I2C1_Msk = 0x40
	// Bit I2C1.
	ASYNCSYSCON_AYSNCPRESETCTRL_I2C1 = 0x40
	// Position of I2C2 field.
	ASYNCSYSCON_AYSNCPRESETCTRL_I2C2_Pos = 0x7
	// Bit mask of I2C2 field.
	ASYNCSYSCON_AYSNCPRESETCTRL_I2C2_Msk = 0x80
	// Bit I2C2.
	ASYNCSYSCON_AYSNCPRESETCTRL_I2C2 = 0x80
	// Position of RESERVED field.
	ASYNCSYSCON_AYSNCPRESETCTRL_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	ASYNCSYSCON_AYSNCPRESETCTRL_RESERVED_Msk = 0x100
	// Bit RESERVED.
	ASYNCSYSCON_AYSNCPRESETCTRL_RESERVED = 0x100
	// Position of SPI0 field.
	ASYNCSYSCON_AYSNCPRESETCTRL_SPI0_Pos = 0x9
	// Bit mask of SPI0 field.
	ASYNCSYSCON_AYSNCPRESETCTRL_SPI0_Msk = 0x200
	// Bit SPI0.
	ASYNCSYSCON_AYSNCPRESETCTRL_SPI0 = 0x200
	// Position of SPI1 field.
	ASYNCSYSCON_AYSNCPRESETCTRL_SPI1_Pos = 0xa
	// Bit mask of SPI1 field.
	ASYNCSYSCON_AYSNCPRESETCTRL_SPI1_Msk = 0x400
	// Bit SPI1.
	ASYNCSYSCON_AYSNCPRESETCTRL_SPI1 = 0x400
	// Position of RESERVED field.
	ASYNCSYSCON_AYSNCPRESETCTRL_RESERVED_Pos = 0xb
	// Bit mask of RESERVED field.
	ASYNCSYSCON_AYSNCPRESETCTRL_RESERVED_Msk = 0x1800
	// Position of TIMER0 field.
	ASYNCSYSCON_AYSNCPRESETCTRL_TIMER0_Pos = 0xd
	// Bit mask of TIMER0 field.
	ASYNCSYSCON_AYSNCPRESETCTRL_TIMER0_Msk = 0x2000
	// Bit TIMER0.
	ASYNCSYSCON_AYSNCPRESETCTRL_TIMER0 = 0x2000
	// Position of TIMER1 field.
	ASYNCSYSCON_AYSNCPRESETCTRL_TIMER1_Pos = 0xe
	// Bit mask of TIMER1 field.
	ASYNCSYSCON_AYSNCPRESETCTRL_TIMER1_Msk = 0x4000
	// Bit TIMER1.
	ASYNCSYSCON_AYSNCPRESETCTRL_TIMER1 = 0x4000
	// Position of FRG0 field.
	ASYNCSYSCON_AYSNCPRESETCTRL_FRG0_Pos = 0xf
	// Bit mask of FRG0 field.
	ASYNCSYSCON_AYSNCPRESETCTRL_FRG0_Msk = 0x8000
	// Bit FRG0.
	ASYNCSYSCON_AYSNCPRESETCTRL_FRG0 = 0x8000
	// Position of RESERVED field.
	ASYNCSYSCON_AYSNCPRESETCTRL_RESERVED_Pos = 0x10
	// Bit mask of RESERVED field.
	ASYNCSYSCON_AYSNCPRESETCTRL_RESERVED_Msk = 0xffff0000

	// AYSNCPRESETCTRLSET: Set bits in AYSNCPRESETCTRL
	// Position of ARST_SET field.
	ASYNCSYSCON_AYSNCPRESETCTRLSET_ARST_SET_Pos = 0x0
	// Bit mask of ARST_SET field.
	ASYNCSYSCON_AYSNCPRESETCTRLSET_ARST_SET_Msk = 0xffffffff

	// AYSNCPRESETCTRLCLR: Clear bits in AYSNCPRESETCTRL
	// Position of ARST_CLR field.
	ASYNCSYSCON_AYSNCPRESETCTRLCLR_ARST_CLR_Pos = 0x0
	// Bit mask of ARST_CLR field.
	ASYNCSYSCON_AYSNCPRESETCTRLCLR_ARST_CLR_Msk = 0xffffffff

	// ASYNCAPBCLKCTRL: Async peripheral clock control
	// Position of RESERVED field.
	ASYNCSYSCON_ASYNCAPBCLKCTRL_RESERVED_Pos = 0x0
	// Bit mask of RESERVED field.
	ASYNCSYSCON_ASYNCAPBCLKCTRL_RESERVED_Msk = 0x1
	// Bit RESERVED.
	ASYNCSYSCON_ASYNCAPBCLKCTRL_RESERVED = 0x1
	// Position of USART0 field.
	ASYNCSYSCON_ASYNCAPBCLKCTRL_USART0_Pos = 0x1
	// Bit mask of USART0 field.
	ASYNCSYSCON_ASYNCAPBCLKCTRL_USART0_Msk = 0x2
	// Bit USART0.
	ASYNCSYSCON_ASYNCAPBCLKCTRL_USART0 = 0x2
	// Position of USART1 field.
	ASYNCSYSCON_ASYNCAPBCLKCTRL_USART1_Pos = 0x2
	// Bit mask of USART1 field.
	ASYNCSYSCON_ASYNCAPBCLKCTRL_USART1_Msk = 0x4
	// Bit USART1.
	ASYNCSYSCON_ASYNCAPBCLKCTRL_USART1 = 0x4
	// Position of USART2 field.
	ASYNCSYSCON_ASYNCAPBCLKCTRL_USART2_Pos = 0x3
	// Bit mask of USART2 field.
	ASYNCSYSCON_ASYNCAPBCLKCTRL_USART2_Msk = 0x8
	// Bit USART2.
	ASYNCSYSCON_ASYNCAPBCLKCTRL_USART2 = 0x8
	// Position of USART3 field.
	ASYNCSYSCON_ASYNCAPBCLKCTRL_USART3_Pos = 0x4
	// Bit mask of USART3 field.
	ASYNCSYSCON_ASYNCAPBCLKCTRL_USART3_Msk = 0x10
	// Bit USART3.
	ASYNCSYSCON_ASYNCAPBCLKCTRL_USART3 = 0x10
	// Position of I2C0 field.
	ASYNCSYSCON_ASYNCAPBCLKCTRL_I2C0_Pos = 0x5
	// Bit mask of I2C0 field.
	ASYNCSYSCON_ASYNCAPBCLKCTRL_I2C0_Msk = 0x20
	// Bit I2C0.
	ASYNCSYSCON_ASYNCAPBCLKCTRL_I2C0 = 0x20
	// Position of I2C1 field.
	ASYNCSYSCON_ASYNCAPBCLKCTRL_I2C1_Pos = 0x6
	// Bit mask of I2C1 field.
	ASYNCSYSCON_ASYNCAPBCLKCTRL_I2C1_Msk = 0x40
	// Bit I2C1.
	ASYNCSYSCON_ASYNCAPBCLKCTRL_I2C1 = 0x40
	// Position of I2C2 field.
	ASYNCSYSCON_ASYNCAPBCLKCTRL_I2C2_Pos = 0x7
	// Bit mask of I2C2 field.
	ASYNCSYSCON_ASYNCAPBCLKCTRL_I2C2_Msk = 0x80
	// Bit I2C2.
	ASYNCSYSCON_ASYNCAPBCLKCTRL_I2C2 = 0x80
	// Position of RESERVED field.
	ASYNCSYSCON_ASYNCAPBCLKCTRL_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	ASYNCSYSCON_ASYNCAPBCLKCTRL_RESERVED_Msk = 0x100
	// Bit RESERVED.
	ASYNCSYSCON_ASYNCAPBCLKCTRL_RESERVED = 0x100
	// Position of SPI0 field.
	ASYNCSYSCON_ASYNCAPBCLKCTRL_SPI0_Pos = 0x9
	// Bit mask of SPI0 field.
	ASYNCSYSCON_ASYNCAPBCLKCTRL_SPI0_Msk = 0x200
	// Bit SPI0.
	ASYNCSYSCON_ASYNCAPBCLKCTRL_SPI0 = 0x200
	// Position of SPI1 field.
	ASYNCSYSCON_ASYNCAPBCLKCTRL_SPI1_Pos = 0xa
	// Bit mask of SPI1 field.
	ASYNCSYSCON_ASYNCAPBCLKCTRL_SPI1_Msk = 0x400
	// Bit SPI1.
	ASYNCSYSCON_ASYNCAPBCLKCTRL_SPI1 = 0x400
	// Position of RESERVED field.
	ASYNCSYSCON_ASYNCAPBCLKCTRL_RESERVED_Pos = 0xb
	// Bit mask of RESERVED field.
	ASYNCSYSCON_ASYNCAPBCLKCTRL_RESERVED_Msk = 0x1800
	// Position of TIMER0 field.
	ASYNCSYSCON_ASYNCAPBCLKCTRL_TIMER0_Pos = 0xd
	// Bit mask of TIMER0 field.
	ASYNCSYSCON_ASYNCAPBCLKCTRL_TIMER0_Msk = 0x2000
	// Bit TIMER0.
	ASYNCSYSCON_ASYNCAPBCLKCTRL_TIMER0 = 0x2000
	// Position of TIMER1 field.
	ASYNCSYSCON_ASYNCAPBCLKCTRL_TIMER1_Pos = 0xe
	// Bit mask of TIMER1 field.
	ASYNCSYSCON_ASYNCAPBCLKCTRL_TIMER1_Msk = 0x4000
	// Bit TIMER1.
	ASYNCSYSCON_ASYNCAPBCLKCTRL_TIMER1 = 0x4000
	// Position of FRG0 field.
	ASYNCSYSCON_ASYNCAPBCLKCTRL_FRG0_Pos = 0xf
	// Bit mask of FRG0 field.
	ASYNCSYSCON_ASYNCAPBCLKCTRL_FRG0_Msk = 0x8000
	// Bit FRG0.
	ASYNCSYSCON_ASYNCAPBCLKCTRL_FRG0 = 0x8000
	// Position of RESERVED field.
	ASYNCSYSCON_ASYNCAPBCLKCTRL_RESERVED_Pos = 0x10
	// Bit mask of RESERVED field.
	ASYNCSYSCON_ASYNCAPBCLKCTRL_RESERVED_Msk = 0xffff0000

	// ASYNCAPBCLKCTRLSET: Set bits in ASYNCAPBCLKCTRL
	// Position of ACLK_SET field.
	ASYNCSYSCON_ASYNCAPBCLKCTRLSET_ACLK_SET_Pos = 0x0
	// Bit mask of ACLK_SET field.
	ASYNCSYSCON_ASYNCAPBCLKCTRLSET_ACLK_SET_Msk = 0xffffffff

	// ASYNCAPBCLKCTRLCLR: Clear bits in ASYNCAPBCLKCTRL
	// Position of ACLK_CLR field.
	ASYNCSYSCON_ASYNCAPBCLKCTRLCLR_ACLK_CLR_Pos = 0x0
	// Bit mask of ACLK_CLR field.
	ASYNCSYSCON_ASYNCAPBCLKCTRLCLR_ACLK_CLR_Msk = 0xffffffff

	// ASYNCAPBCLKSELA: Async APB clock source select A
	// Position of SEL field.
	ASYNCSYSCON_ASYNCAPBCLKSELA_SEL_Pos = 0x0
	// Bit mask of SEL field.
	ASYNCSYSCON_ASYNCAPBCLKSELA_SEL_Msk = 0x3
	// IRC Oscillator
	ASYNCSYSCON_ASYNCAPBCLKSELA_SEL_IRC_OSCILLATOR = 0x0
	// Watchdog oscillator
	ASYNCSYSCON_ASYNCAPBCLKSELA_SEL_WATCHDOG_OSCILLATOR = 0x1
	// Position of RESERVED field.
	ASYNCSYSCON_ASYNCAPBCLKSELA_RESERVED_Pos = 0x2
	// Bit mask of RESERVED field.
	ASYNCSYSCON_ASYNCAPBCLKSELA_RESERVED_Msk = 0xfffffffc

	// ASYNCAPBCLKSELB: Async APB clock source select B
	// Position of SEL field.
	ASYNCSYSCON_ASYNCAPBCLKSELB_SEL_Pos = 0x0
	// Bit mask of SEL field.
	ASYNCSYSCON_ASYNCAPBCLKSELB_SEL_Msk = 0x3
	// Main clock
	ASYNCSYSCON_ASYNCAPBCLKSELB_SEL_MAIN_CLOCK = 0x0
	// CLKIN
	ASYNCSYSCON_ASYNCAPBCLKSELB_SEL_CLKIN = 0x1
	// System PLL output.
	ASYNCSYSCON_ASYNCAPBCLKSELB_SEL_SYSTEM_PLL_OUTPUT = 0x2
	// ASYNCAPBCLKSELA. Clock selected by the ASYNCAPBCLKSELA register.
	ASYNCSYSCON_ASYNCAPBCLKSELB_SEL_ASYNCAPBCLKSELA = 0x3
	// Position of RESERVED field.
	ASYNCSYSCON_ASYNCAPBCLKSELB_RESERVED_Pos = 0x2
	// Bit mask of RESERVED field.
	ASYNCSYSCON_ASYNCAPBCLKSELB_RESERVED_Msk = 0xfffffffc

	// ASYNCCLKDIV: Async APB clock divider
	// Position of DIV field.
	ASYNCSYSCON_ASYNCCLKDIV_DIV_Pos = 0x0
	// Bit mask of DIV field.
	ASYNCSYSCON_ASYNCCLKDIV_DIV_Msk = 0xff
	// Position of RESERVED field.
	ASYNCSYSCON_ASYNCCLKDIV_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	ASYNCSYSCON_ASYNCCLKDIV_RESERVED_Msk = 0xffffff00

	// FRGCTRL: USART fractional rate generator control
	// Position of DIV field.
	ASYNCSYSCON_FRGCTRL_DIV_Pos = 0x0
	// Bit mask of DIV field.
	ASYNCSYSCON_FRGCTRL_DIV_Msk = 0xff
	// Position of MULT field.
	ASYNCSYSCON_FRGCTRL_MULT_Pos = 0x8
	// Bit mask of MULT field.
	ASYNCSYSCON_FRGCTRL_MULT_Msk = 0xff00
	// Position of RESERVED field.
	ASYNCSYSCON_FRGCTRL_RESERVED_Pos = 0x10
	// Bit mask of RESERVED field.
	ASYNCSYSCON_FRGCTRL_RESERVED_Msk = 0xffff0000

	// BODCTRL: Brown-Out Detect control
	// Position of BODRSTLEV field.
	ASYNCSYSCON_BODCTRL_BODRSTLEV_Pos = 0x0
	// Bit mask of BODRSTLEV field.
	ASYNCSYSCON_BODCTRL_BODRSTLEV_Msk = 0x3
	// Level 0: 1.5 V
	ASYNCSYSCON_BODCTRL_BODRSTLEV_LEVEL_0_1 = 0x0
	// Level 1: 1.85 V
	ASYNCSYSCON_BODCTRL_BODRSTLEV_LEVEL_1_1 = 0x1
	// Level 2: 2.0 V
	ASYNCSYSCON_BODCTRL_BODRSTLEV_LEVEL_2_2 = 0x2
	// Level 3: 2.3 V
	ASYNCSYSCON_BODCTRL_BODRSTLEV_LEVEL_3_2 = 0x3
	// Position of BODINTVAL field.
	ASYNCSYSCON_BODCTRL_BODINTVAL_Pos = 0x2
	// Bit mask of BODINTVAL field.
	ASYNCSYSCON_BODCTRL_BODINTVAL_Msk = 0xc
	// Level 0: 2.05 V
	ASYNCSYSCON_BODCTRL_BODINTVAL_LEVEL_0_2 = 0x0
	// Level 1: 2.45 V
	ASYNCSYSCON_BODCTRL_BODINTVAL_LEVEL_1_2 = 0x1
	// Level 2: 2.75 V
	ASYNCSYSCON_BODCTRL_BODINTVAL_LEVEL_2_2 = 0x2
	// Level 3: 3.05 V
	ASYNCSYSCON_BODCTRL_BODINTVAL_LEVEL_3_3 = 0x3
	// Position of BODRSTENA field.
	ASYNCSYSCON_BODCTRL_BODRSTENA_Pos = 0x4
	// Bit mask of BODRSTENA field.
	ASYNCSYSCON_BODCTRL_BODRSTENA_Msk = 0x10
	// Bit BODRSTENA.
	ASYNCSYSCON_BODCTRL_BODRSTENA = 0x10
	// Disable reset function.
	ASYNCSYSCON_BODCTRL_BODRSTENA_DISABLE_RESET_FUNCTI = 0x0
	// Enable reset function.
	ASYNCSYSCON_BODCTRL_BODRSTENA_ENABLE_RESET_FUNCTIO = 0x1
	// Position of RESERVED field.
	ASYNCSYSCON_BODCTRL_RESERVED_Pos = 0x5
	// Bit mask of RESERVED field.
	ASYNCSYSCON_BODCTRL_RESERVED_Msk = 0xffffffe0
)

// Bitfields for USART0: USART0
const (
	// CFG: USART Configuration register. Basic USART configuration settings that typically are not changed during operation.
	// Position of ENABLE field.
	USART0_CFG_ENABLE_Pos = 0x0
	// Bit mask of ENABLE field.
	USART0_CFG_ENABLE_Msk = 0x1
	// Bit ENABLE.
	USART0_CFG_ENABLE = 0x1
	// Disabled. The USART is disabled and the internal state machine and counters are reset. While Enable = 0, all USART interrupts and DMA transfers are disabled. When Enable is set again, CFG and most other control bits remain unchanged. For instance, when re-enabled, the USART will immediately generate a TxRdy interrupt (if enabled in the INTENSET register) or a DMA transfer request because the transmitter has been reset and is therefore available.
	USART0_CFG_ENABLE_DISABLED = 0x0
	// Enabled. The USART is enabled for operation.
	USART0_CFG_ENABLE_ENABLED = 0x1
	// Position of RESERVED field.
	USART0_CFG_RESERVED_Pos = 0x1
	// Bit mask of RESERVED field.
	USART0_CFG_RESERVED_Msk = 0x2
	// Bit RESERVED.
	USART0_CFG_RESERVED = 0x2
	// Position of DATALEN field.
	USART0_CFG_DATALEN_Pos = 0x2
	// Bit mask of DATALEN field.
	USART0_CFG_DATALEN_Msk = 0xc
	// 7 bit Data length.
	USART0_CFG_DATALEN_7_BIT_DATA_LENGTH = 0x0
	// 8 bit Data length.
	USART0_CFG_DATALEN_8_BIT_DATA_LENGTH = 0x1
	// 9 bit data length. The 9th bit is commonly used for addressing in multidrop mode. See the ADDRDET bit in the CTL register.
	USART0_CFG_DATALEN_9_BIT_DATA_LENGTH = 0x2
	// Position of PARITYSEL field.
	USART0_CFG_PARITYSEL_Pos = 0x4
	// Bit mask of PARITYSEL field.
	USART0_CFG_PARITYSEL_Msk = 0x30
	// No parity.
	USART0_CFG_PARITYSEL_NO_PARITY = 0x0
	// Even parity. Adds a bit to each character such that the number of 1s in a transmitted character is even, and the number of 1s in a received character is expected to be even.
	USART0_CFG_PARITYSEL_EVEN_PARITY = 0x2
	// Odd parity. Adds a bit to each character such that the number of 1s in a transmitted character is odd, and the number of 1s in a received character is expected to be odd.
	USART0_CFG_PARITYSEL_ODD_PARITY = 0x3
	// Position of STOPLEN field.
	USART0_CFG_STOPLEN_Pos = 0x6
	// Bit mask of STOPLEN field.
	USART0_CFG_STOPLEN_Msk = 0x40
	// Bit STOPLEN.
	USART0_CFG_STOPLEN = 0x40
	// 1 stop bit.
	USART0_CFG_STOPLEN_1_STOP_BIT = 0x0
	// 2 stop bits. This setting should only be used for asynchronous communication.
	USART0_CFG_STOPLEN_2_STOP_BITS = 0x1
	// Position of MODE32K field.
	USART0_CFG_MODE32K_Pos = 0x7
	// Bit mask of MODE32K field.
	USART0_CFG_MODE32K_Msk = 0x80
	// Bit MODE32K.
	USART0_CFG_MODE32K = 0x80
	// Disabled. USART uses standard clocking.
	USART0_CFG_MODE32K_DISABLED = 0x0
	// Enabled. USART uses the 32 kHz clock from the RTC oscillator as the clock source to the BRG, and uses a special bit clocking scheme.
	USART0_CFG_MODE32K_ENABLED = 0x1
	// Position of LINMODE field.
	USART0_CFG_LINMODE_Pos = 0x8
	// Bit mask of LINMODE field.
	USART0_CFG_LINMODE_Msk = 0x100
	// Bit LINMODE.
	USART0_CFG_LINMODE = 0x100
	// Disabled. Break detect and generate is configured for normal operation.
	USART0_CFG_LINMODE_DISABLED = 0x0
	// Enabled. Break detect and generate is configured for LIN bus operation.
	USART0_CFG_LINMODE_ENABLED = 0x1
	// Position of CTSEN field.
	USART0_CFG_CTSEN_Pos = 0x9
	// Bit mask of CTSEN field.
	USART0_CFG_CTSEN_Msk = 0x200
	// Bit CTSEN.
	USART0_CFG_CTSEN = 0x200
	// No flow control. The transmitter does not receive any automatic flow control signal.
	USART0_CFG_CTSEN_NO_FLOW_CONTROL = 0x0
	// Flow control enabled. The transmitter uses the CTS input (or RTS output in loopback mode) for flow control purposes.
	USART0_CFG_CTSEN_FLOW_CONTROL_ENABLED = 0x1
	// Position of RESERVED field.
	USART0_CFG_RESERVED_Pos = 0xa
	// Bit mask of RESERVED field.
	USART0_CFG_RESERVED_Msk = 0x400
	// Bit RESERVED.
	USART0_CFG_RESERVED = 0x400
	// Position of SYNCEN field.
	USART0_CFG_SYNCEN_Pos = 0xb
	// Bit mask of SYNCEN field.
	USART0_CFG_SYNCEN_Msk = 0x800
	// Bit SYNCEN.
	USART0_CFG_SYNCEN = 0x800
	// Asynchronous mode.
	USART0_CFG_SYNCEN_ASYNCHRONOUS_MODE = 0x0
	// Synchronous mode.
	USART0_CFG_SYNCEN_SYNCHRONOUS_MODE = 0x1
	// Position of CLKPOL field.
	USART0_CFG_CLKPOL_Pos = 0xc
	// Bit mask of CLKPOL field.
	USART0_CFG_CLKPOL_Msk = 0x1000
	// Bit CLKPOL.
	USART0_CFG_CLKPOL = 0x1000
	// Falling edge. Un_RXD is sampled on the falling edge of SCLK.
	USART0_CFG_CLKPOL_FALLING_EDGE = 0x0
	// Rising edge. Un_RXD is sampled on the rising edge of SCLK.
	USART0_CFG_CLKPOL_RISING_EDGE = 0x1
	// Position of RESERVED field.
	USART0_CFG_RESERVED_Pos = 0xd
	// Bit mask of RESERVED field.
	USART0_CFG_RESERVED_Msk = 0x2000
	// Bit RESERVED.
	USART0_CFG_RESERVED = 0x2000
	// Position of SYNCMST field.
	USART0_CFG_SYNCMST_Pos = 0xe
	// Bit mask of SYNCMST field.
	USART0_CFG_SYNCMST_Msk = 0x4000
	// Bit SYNCMST.
	USART0_CFG_SYNCMST = 0x4000
	// Slave. When synchronous mode is enabled, the USART is a slave.
	USART0_CFG_SYNCMST_SLAVE = 0x0
	// Master. When synchronous mode is enabled, the USART is a master.
	USART0_CFG_SYNCMST_MASTER = 0x1
	// Position of LOOP field.
	USART0_CFG_LOOP_Pos = 0xf
	// Bit mask of LOOP field.
	USART0_CFG_LOOP_Msk = 0x8000
	// Bit LOOP.
	USART0_CFG_LOOP = 0x8000
	// Normal operation.
	USART0_CFG_LOOP_NORMAL_OPERATION = 0x0
	// Loopback mode. This provides a mechanism to perform diagnostic loopback testing for USART data. Serial data from the transmitter (Un_TXD) is connected internally to serial input of the receive (Un_RXD). Un_TXD and Un_RTS activity will also appear on external pins if these functions are configured to appear on device pins. The receiver RTS signal is also looped back to CTS and performs flow control if enabled by CTSEN.
	USART0_CFG_LOOP_LOOPBACK_MODE = 0x1
	// Position of IOMODE field.
	USART0_CFG_IOMODE_Pos = 0x10
	// Bit mask of IOMODE field.
	USART0_CFG_IOMODE_Msk = 0x10000
	// Bit IOMODE.
	USART0_CFG_IOMODE = 0x10000
	// Standard. USART output and input operate in standard fashion.
	USART0_CFG_IOMODE_STANDARD = 0x0
	// IrDA. USART output and input operate in IrDA mode.
	USART0_CFG_IOMODE_IRDA = 0x1
	// Position of RESERVED field.
	USART0_CFG_RESERVED_Pos = 0x11
	// Bit mask of RESERVED field.
	USART0_CFG_RESERVED_Msk = 0x20000
	// Bit RESERVED.
	USART0_CFG_RESERVED = 0x20000
	// Position of OETA field.
	USART0_CFG_OETA_Pos = 0x12
	// Bit mask of OETA field.
	USART0_CFG_OETA_Msk = 0x40000
	// Bit OETA.
	USART0_CFG_OETA = 0x40000
	// Disabled. If selected by OESEL, the Output Enable signal deasserted at the end of the last stop bit of a transmission.
	USART0_CFG_OETA_DISABLED = 0x0
	// Enabled. If selected by OESEL, the Output Enable signal remains asserted for one character time after the end of the last stop bit of a transmission. OE will also remain asserted if another transmit begins before it is deasserted.
	USART0_CFG_OETA_ENABLED = 0x1
	// Position of AUTOADDR field.
	USART0_CFG_AUTOADDR_Pos = 0x13
	// Bit mask of AUTOADDR field.
	USART0_CFG_AUTOADDR_Msk = 0x80000
	// Bit AUTOADDR.
	USART0_CFG_AUTOADDR = 0x80000
	// Disabled. When addressing is enabled by ADDRDET, address matching is done by software. This provides the possibility of versatile addressing (e.g. respond to more than one address).
	USART0_CFG_AUTOADDR_DISABLED = 0x0
	// Enabled. When addressing is enabled by ADDRDET, address matching is done by hardware, using the value in the ADDR register as the address to match.
	USART0_CFG_AUTOADDR_ENABLED = 0x1
	// Position of OESEL field.
	USART0_CFG_OESEL_Pos = 0x14
	// Bit mask of OESEL field.
	USART0_CFG_OESEL_Msk = 0x100000
	// Bit OESEL.
	USART0_CFG_OESEL = 0x100000
	// Standard. The RTS signal is used as the standard flow control function.
	USART0_CFG_OESEL_STANDARD = 0x0
	// RS-485. The RTS signal configured to provide an output enable signal to control an RS-485 transceiver.
	USART0_CFG_OESEL_RS_485 = 0x1
	// Position of OEPOL field.
	USART0_CFG_OEPOL_Pos = 0x15
	// Bit mask of OEPOL field.
	USART0_CFG_OEPOL_Msk = 0x200000
	// Bit OEPOL.
	USART0_CFG_OEPOL = 0x200000
	// Low. If selected by OESEL, the output enable is active low.
	USART0_CFG_OEPOL_LOW = 0x0
	// High. If selected by OESEL, the output enable is active high.
	USART0_CFG_OEPOL_HIGH = 0x1
	// Position of RXPOL field.
	USART0_CFG_RXPOL_Pos = 0x16
	// Bit mask of RXPOL field.
	USART0_CFG_RXPOL_Msk = 0x400000
	// Bit RXPOL.
	USART0_CFG_RXPOL = 0x400000
	// Standard. The RX signal is used as it arrives from the pin. This means that the RX rest value is 1, start bit is 0, data is not inverted, and the stop bit is 1.
	USART0_CFG_RXPOL_STANDARD = 0x0
	// Inverted. The RX signal is inverted before being used by the USART. This means that the RX rest value is 0, start bit is 1, data is inverted, and the stop bit is 0.
	USART0_CFG_RXPOL_INVERTED = 0x1
	// Position of TXPOL field.
	USART0_CFG_TXPOL_Pos = 0x17
	// Bit mask of TXPOL field.
	USART0_CFG_TXPOL_Msk = 0x800000
	// Bit TXPOL.
	USART0_CFG_TXPOL = 0x800000
	// Standard. The TX signal is sent out without change. This means that the TX rest value is 1, start bit is 0, data is not inverted, and the stop bit is 1.
	USART0_CFG_TXPOL_STANDARD = 0x0
	// Inverted. The TX signal is inverted by the USART before being sent out. This means that the TX rest value is 0, start bit is 1, data is inverted, and the stop bit is 0.
	USART0_CFG_TXPOL_INVERTED = 0x1
	// Position of RESERVED field.
	USART0_CFG_RESERVED_Pos = 0x18
	// Bit mask of RESERVED field.
	USART0_CFG_RESERVED_Msk = 0xff000000

	// CTL: USART Control register. USART control settings that are more likely to change during operation.
	// Position of RESERVED field.
	USART0_CTL_RESERVED_Pos = 0x0
	// Bit mask of RESERVED field.
	USART0_CTL_RESERVED_Msk = 0x1
	// Bit RESERVED.
	USART0_CTL_RESERVED = 0x1
	// Position of TXBRKEN field.
	USART0_CTL_TXBRKEN_Pos = 0x1
	// Bit mask of TXBRKEN field.
	USART0_CTL_TXBRKEN_Msk = 0x2
	// Bit TXBRKEN.
	USART0_CTL_TXBRKEN = 0x2
	// Normal operation.
	USART0_CTL_TXBRKEN_NORMAL_OPERATION = 0x0
	// Continuous break. Continuous break is sent immediately when this bit is set, and remains until this bit is cleared. A break may be sent without danger of corrupting any currently transmitting character if the transmitter is first disabled (TXDIS in CTL is set) and then waiting for the transmitter to be disabled (TXDISINT in STAT = 1) before writing 1 to TXBRKEN.
	USART0_CTL_TXBRKEN_CONTINUOUS_BREAK = 0x1
	// Position of ADDRDET field.
	USART0_CTL_ADDRDET_Pos = 0x2
	// Bit mask of ADDRDET field.
	USART0_CTL_ADDRDET_Msk = 0x4
	// Bit ADDRDET.
	USART0_CTL_ADDRDET = 0x4
	// Disabled. The USART presents all incoming data.
	USART0_CTL_ADDRDET_DISABLED = 0x0
	// Enabled. The USART receiver ignores incoming data that does not have the most significant bit of the data (typically the 9th bit) = 1. When the data MSB bit = 1, the receiver treats the incoming data normally, generating a received data interrupt. Software can then check the data to see if this is an address that should be handled. If it is, the ADDRDET bit is cleared by software and further incoming data is handled normally.
	USART0_CTL_ADDRDET_ENABLED = 0x1
	// Position of RESERVED field.
	USART0_CTL_RESERVED_Pos = 0x3
	// Bit mask of RESERVED field.
	USART0_CTL_RESERVED_Msk = 0x38
	// Position of TXDIS field.
	USART0_CTL_TXDIS_Pos = 0x6
	// Bit mask of TXDIS field.
	USART0_CTL_TXDIS_Msk = 0x40
	// Bit TXDIS.
	USART0_CTL_TXDIS = 0x40
	// Not disabled. USART transmitter is not disabled.
	USART0_CTL_TXDIS_NOT_DISABLED = 0x0
	// Disabled. USART transmitter is disabled after any character currently being transmitted is complete. This feature can be used to facilitate software flow control.
	USART0_CTL_TXDIS_DISABLED = 0x1
	// Position of RESERVED field.
	USART0_CTL_RESERVED_Pos = 0x7
	// Bit mask of RESERVED field.
	USART0_CTL_RESERVED_Msk = 0x80
	// Bit RESERVED.
	USART0_CTL_RESERVED = 0x80
	// Position of CC field.
	USART0_CTL_CC_Pos = 0x8
	// Bit mask of CC field.
	USART0_CTL_CC_Msk = 0x100
	// Bit CC.
	USART0_CTL_CC = 0x100
	// Clock on character. In synchronous mode, SCLK cycles only when characters are being sent on Un_TXD or to complete a character that is being received.
	USART0_CTL_CC_CLOCK_ON_CHARACTER = 0x0
	// Continuous clock. SCLK runs continuously in synchronous mode, allowing characters to be received on Un_RxD independently from transmission on Un_TXD).
	USART0_CTL_CC_CONTINUOUS_CLOCK = 0x1
	// Position of CLRCCONRX field.
	USART0_CTL_CLRCCONRX_Pos = 0x9
	// Bit mask of CLRCCONRX field.
	USART0_CTL_CLRCCONRX_Msk = 0x200
	// Bit CLRCCONRX.
	USART0_CTL_CLRCCONRX = 0x200
	// No effect. No effect on the CC bit.
	USART0_CTL_CLRCCONRX_NO_EFFECT = 0x0
	// Auto-clear. The CC bit is automatically cleared when a complete character has been received. This bit is cleared at the same time.
	USART0_CTL_CLRCCONRX_AUTO_CLEAR = 0x1
	// Position of RESERVED field.
	USART0_CTL_RESERVED_Pos = 0xa
	// Bit mask of RESERVED field.
	USART0_CTL_RESERVED_Msk = 0xfc00
	// Position of AUTOBAUD field.
	USART0_CTL_AUTOBAUD_Pos = 0x10
	// Bit mask of AUTOBAUD field.
	USART0_CTL_AUTOBAUD_Msk = 0x10000
	// Bit AUTOBAUD.
	USART0_CTL_AUTOBAUD = 0x10000
	// Disabled. USART is in normal operating mode.
	USART0_CTL_AUTOBAUD_DISABLED = 0x0
	// Enabled. USART is in autobaud mode. This bit should only be set when the USART receiver is idle. The first start bit of RX is measured and used the update the BRG register to match the received data rate. AUTOBAUD is cleared once this process is complete, or if there is an AERR.
	USART0_CTL_AUTOBAUD_ENABLED = 0x1
	// Position of RESERVED field.
	USART0_CTL_RESERVED_Pos = 0x11
	// Bit mask of RESERVED field.
	USART0_CTL_RESERVED_Msk = 0xfffe0000

	// STAT: USART Status register. The complete status value can be read here. Writing ones clears some bits in the register. Some bits can be cleared by writing a 1 to them.
	// Position of RXRDY field.
	USART0_STAT_RXRDY_Pos = 0x0
	// Bit mask of RXRDY field.
	USART0_STAT_RXRDY_Msk = 0x1
	// Bit RXRDY.
	USART0_STAT_RXRDY = 0x1
	// Position of RXIDLE field.
	USART0_STAT_RXIDLE_Pos = 0x1
	// Bit mask of RXIDLE field.
	USART0_STAT_RXIDLE_Msk = 0x2
	// Bit RXIDLE.
	USART0_STAT_RXIDLE = 0x2
	// Position of TXRDY field.
	USART0_STAT_TXRDY_Pos = 0x2
	// Bit mask of TXRDY field.
	USART0_STAT_TXRDY_Msk = 0x4
	// Bit TXRDY.
	USART0_STAT_TXRDY = 0x4
	// Position of TXIDLE field.
	USART0_STAT_TXIDLE_Pos = 0x3
	// Bit mask of TXIDLE field.
	USART0_STAT_TXIDLE_Msk = 0x8
	// Bit TXIDLE.
	USART0_STAT_TXIDLE = 0x8
	// Position of CTS field.
	USART0_STAT_CTS_Pos = 0x4
	// Bit mask of CTS field.
	USART0_STAT_CTS_Msk = 0x10
	// Bit CTS.
	USART0_STAT_CTS = 0x10
	// Position of DELTACTS field.
	USART0_STAT_DELTACTS_Pos = 0x5
	// Bit mask of DELTACTS field.
	USART0_STAT_DELTACTS_Msk = 0x20
	// Bit DELTACTS.
	USART0_STAT_DELTACTS = 0x20
	// Position of TXDISSTAT field.
	USART0_STAT_TXDISSTAT_Pos = 0x6
	// Bit mask of TXDISSTAT field.
	USART0_STAT_TXDISSTAT_Msk = 0x40
	// Bit TXDISSTAT.
	USART0_STAT_TXDISSTAT = 0x40
	// Position of RESERVED field.
	USART0_STAT_RESERVED_Pos = 0x7
	// Bit mask of RESERVED field.
	USART0_STAT_RESERVED_Msk = 0x80
	// Bit RESERVED.
	USART0_STAT_RESERVED = 0x80
	// Position of OVERRUNINT field.
	USART0_STAT_OVERRUNINT_Pos = 0x8
	// Bit mask of OVERRUNINT field.
	USART0_STAT_OVERRUNINT_Msk = 0x100
	// Bit OVERRUNINT.
	USART0_STAT_OVERRUNINT = 0x100
	// Position of RESERVED field.
	USART0_STAT_RESERVED_Pos = 0x9
	// Bit mask of RESERVED field.
	USART0_STAT_RESERVED_Msk = 0x200
	// Bit RESERVED.
	USART0_STAT_RESERVED = 0x200
	// Position of RXBRK field.
	USART0_STAT_RXBRK_Pos = 0xa
	// Bit mask of RXBRK field.
	USART0_STAT_RXBRK_Msk = 0x400
	// Bit RXBRK.
	USART0_STAT_RXBRK = 0x400
	// Position of DELTARXBRK field.
	USART0_STAT_DELTARXBRK_Pos = 0xb
	// Bit mask of DELTARXBRK field.
	USART0_STAT_DELTARXBRK_Msk = 0x800
	// Bit DELTARXBRK.
	USART0_STAT_DELTARXBRK = 0x800
	// Position of START field.
	USART0_STAT_START_Pos = 0xc
	// Bit mask of START field.
	USART0_STAT_START_Msk = 0x1000
	// Bit START.
	USART0_STAT_START = 0x1000
	// Position of FRAMERRINT field.
	USART0_STAT_FRAMERRINT_Pos = 0xd
	// Bit mask of FRAMERRINT field.
	USART0_STAT_FRAMERRINT_Msk = 0x2000
	// Bit FRAMERRINT.
	USART0_STAT_FRAMERRINT = 0x2000
	// Position of PARITYERRINT field.
	USART0_STAT_PARITYERRINT_Pos = 0xe
	// Bit mask of PARITYERRINT field.
	USART0_STAT_PARITYERRINT_Msk = 0x4000
	// Bit PARITYERRINT.
	USART0_STAT_PARITYERRINT = 0x4000
	// Position of RXNOISEINT field.
	USART0_STAT_RXNOISEINT_Pos = 0xf
	// Bit mask of RXNOISEINT field.
	USART0_STAT_RXNOISEINT_Msk = 0x8000
	// Bit RXNOISEINT.
	USART0_STAT_RXNOISEINT = 0x8000
	// Position of ABERR field.
	USART0_STAT_ABERR_Pos = 0x10
	// Bit mask of ABERR field.
	USART0_STAT_ABERR_Msk = 0x10000
	// Bit ABERR.
	USART0_STAT_ABERR = 0x10000
	// Position of RESERVED field.
	USART0_STAT_RESERVED_Pos = 0x11
	// Bit mask of RESERVED field.
	USART0_STAT_RESERVED_Msk = 0xfffe0000

	// INTENSET: Interrupt Enable read and Set register. Contains an individual interrupt enable bit for each potential USART interrupt. A complete value may be read from this register. Writing a 1 to any implemented bit position causes that bit to be set.
	// Position of RXRDYEN field.
	USART0_INTENSET_RXRDYEN_Pos = 0x0
	// Bit mask of RXRDYEN field.
	USART0_INTENSET_RXRDYEN_Msk = 0x1
	// Bit RXRDYEN.
	USART0_INTENSET_RXRDYEN = 0x1
	// Position of RESERVED field.
	USART0_INTENSET_RESERVED_Pos = 0x1
	// Bit mask of RESERVED field.
	USART0_INTENSET_RESERVED_Msk = 0x2
	// Bit RESERVED.
	USART0_INTENSET_RESERVED = 0x2
	// Position of TXRDYEN field.
	USART0_INTENSET_TXRDYEN_Pos = 0x2
	// Bit mask of TXRDYEN field.
	USART0_INTENSET_TXRDYEN_Msk = 0x4
	// Bit TXRDYEN.
	USART0_INTENSET_TXRDYEN = 0x4
	// Position of TXIDLEEN field.
	USART0_INTENSET_TXIDLEEN_Pos = 0x3
	// Bit mask of TXIDLEEN field.
	USART0_INTENSET_TXIDLEEN_Msk = 0x8
	// Bit TXIDLEEN.
	USART0_INTENSET_TXIDLEEN = 0x8
	// Position of RESERVED field.
	USART0_INTENSET_RESERVED_Pos = 0x4
	// Bit mask of RESERVED field.
	USART0_INTENSET_RESERVED_Msk = 0x10
	// Bit RESERVED.
	USART0_INTENSET_RESERVED = 0x10
	// Position of DELTACTSEN field.
	USART0_INTENSET_DELTACTSEN_Pos = 0x5
	// Bit mask of DELTACTSEN field.
	USART0_INTENSET_DELTACTSEN_Msk = 0x20
	// Bit DELTACTSEN.
	USART0_INTENSET_DELTACTSEN = 0x20
	// Position of TXDISEN field.
	USART0_INTENSET_TXDISEN_Pos = 0x6
	// Bit mask of TXDISEN field.
	USART0_INTENSET_TXDISEN_Msk = 0x40
	// Bit TXDISEN.
	USART0_INTENSET_TXDISEN = 0x40
	// Position of RESERVED field.
	USART0_INTENSET_RESERVED_Pos = 0x7
	// Bit mask of RESERVED field.
	USART0_INTENSET_RESERVED_Msk = 0x80
	// Bit RESERVED.
	USART0_INTENSET_RESERVED = 0x80
	// Position of OVERRUNEN field.
	USART0_INTENSET_OVERRUNEN_Pos = 0x8
	// Bit mask of OVERRUNEN field.
	USART0_INTENSET_OVERRUNEN_Msk = 0x100
	// Bit OVERRUNEN.
	USART0_INTENSET_OVERRUNEN = 0x100
	// Position of RESERVED field.
	USART0_INTENSET_RESERVED_Pos = 0x9
	// Bit mask of RESERVED field.
	USART0_INTENSET_RESERVED_Msk = 0x600
	// Position of DELTARXBRKEN field.
	USART0_INTENSET_DELTARXBRKEN_Pos = 0xb
	// Bit mask of DELTARXBRKEN field.
	USART0_INTENSET_DELTARXBRKEN_Msk = 0x800
	// Bit DELTARXBRKEN.
	USART0_INTENSET_DELTARXBRKEN = 0x800
	// Position of STARTEN field.
	USART0_INTENSET_STARTEN_Pos = 0xc
	// Bit mask of STARTEN field.
	USART0_INTENSET_STARTEN_Msk = 0x1000
	// Bit STARTEN.
	USART0_INTENSET_STARTEN = 0x1000
	// Position of FRAMERREN field.
	USART0_INTENSET_FRAMERREN_Pos = 0xd
	// Bit mask of FRAMERREN field.
	USART0_INTENSET_FRAMERREN_Msk = 0x2000
	// Bit FRAMERREN.
	USART0_INTENSET_FRAMERREN = 0x2000
	// Position of PARITYERREN field.
	USART0_INTENSET_PARITYERREN_Pos = 0xe
	// Bit mask of PARITYERREN field.
	USART0_INTENSET_PARITYERREN_Msk = 0x4000
	// Bit PARITYERREN.
	USART0_INTENSET_PARITYERREN = 0x4000
	// Position of RXNOISEEN field.
	USART0_INTENSET_RXNOISEEN_Pos = 0xf
	// Bit mask of RXNOISEEN field.
	USART0_INTENSET_RXNOISEEN_Msk = 0x8000
	// Bit RXNOISEEN.
	USART0_INTENSET_RXNOISEEN = 0x8000
	// Position of ABERREN field.
	USART0_INTENSET_ABERREN_Pos = 0x10
	// Bit mask of ABERREN field.
	USART0_INTENSET_ABERREN_Msk = 0x10000
	// Bit ABERREN.
	USART0_INTENSET_ABERREN = 0x10000
	// Position of RESERVED field.
	USART0_INTENSET_RESERVED_Pos = 0x11
	// Bit mask of RESERVED field.
	USART0_INTENSET_RESERVED_Msk = 0xfffe0000

	// INTENCLR: Interrupt Enable Clear register. Allows clearing any combination of bits in the INTENSET register. Writing a 1 to any implemented bit position causes the corresponding bit to be cleared.
	// Position of RXRDYCLR field.
	USART0_INTENCLR_RXRDYCLR_Pos = 0x0
	// Bit mask of RXRDYCLR field.
	USART0_INTENCLR_RXRDYCLR_Msk = 0x1
	// Bit RXRDYCLR.
	USART0_INTENCLR_RXRDYCLR = 0x1
	// Position of RESERVED field.
	USART0_INTENCLR_RESERVED_Pos = 0x1
	// Bit mask of RESERVED field.
	USART0_INTENCLR_RESERVED_Msk = 0x2
	// Bit RESERVED.
	USART0_INTENCLR_RESERVED = 0x2
	// Position of TXRDYCLR field.
	USART0_INTENCLR_TXRDYCLR_Pos = 0x2
	// Bit mask of TXRDYCLR field.
	USART0_INTENCLR_TXRDYCLR_Msk = 0x4
	// Bit TXRDYCLR.
	USART0_INTENCLR_TXRDYCLR = 0x4
	// Position of TXIDLECLR field.
	USART0_INTENCLR_TXIDLECLR_Pos = 0x3
	// Bit mask of TXIDLECLR field.
	USART0_INTENCLR_TXIDLECLR_Msk = 0x8
	// Bit TXIDLECLR.
	USART0_INTENCLR_TXIDLECLR = 0x8
	// Position of RESERVED field.
	USART0_INTENCLR_RESERVED_Pos = 0x4
	// Bit mask of RESERVED field.
	USART0_INTENCLR_RESERVED_Msk = 0x10
	// Bit RESERVED.
	USART0_INTENCLR_RESERVED = 0x10
	// Position of DELTACTSCLR field.
	USART0_INTENCLR_DELTACTSCLR_Pos = 0x5
	// Bit mask of DELTACTSCLR field.
	USART0_INTENCLR_DELTACTSCLR_Msk = 0x20
	// Bit DELTACTSCLR.
	USART0_INTENCLR_DELTACTSCLR = 0x20
	// Position of TXDISCLR field.
	USART0_INTENCLR_TXDISCLR_Pos = 0x6
	// Bit mask of TXDISCLR field.
	USART0_INTENCLR_TXDISCLR_Msk = 0x40
	// Bit TXDISCLR.
	USART0_INTENCLR_TXDISCLR = 0x40
	// Position of RESERVED field.
	USART0_INTENCLR_RESERVED_Pos = 0x7
	// Bit mask of RESERVED field.
	USART0_INTENCLR_RESERVED_Msk = 0x80
	// Bit RESERVED.
	USART0_INTENCLR_RESERVED = 0x80
	// Position of OVERRUNCLR field.
	USART0_INTENCLR_OVERRUNCLR_Pos = 0x8
	// Bit mask of OVERRUNCLR field.
	USART0_INTENCLR_OVERRUNCLR_Msk = 0x100
	// Bit OVERRUNCLR.
	USART0_INTENCLR_OVERRUNCLR = 0x100
	// Position of RESERVED field.
	USART0_INTENCLR_RESERVED_Pos = 0x9
	// Bit mask of RESERVED field.
	USART0_INTENCLR_RESERVED_Msk = 0x600
	// Position of DELTARXBRKCLR field.
	USART0_INTENCLR_DELTARXBRKCLR_Pos = 0xb
	// Bit mask of DELTARXBRKCLR field.
	USART0_INTENCLR_DELTARXBRKCLR_Msk = 0x800
	// Bit DELTARXBRKCLR.
	USART0_INTENCLR_DELTARXBRKCLR = 0x800
	// Position of STARTCLR field.
	USART0_INTENCLR_STARTCLR_Pos = 0xc
	// Bit mask of STARTCLR field.
	USART0_INTENCLR_STARTCLR_Msk = 0x1000
	// Bit STARTCLR.
	USART0_INTENCLR_STARTCLR = 0x1000
	// Position of FRAMERRCLR field.
	USART0_INTENCLR_FRAMERRCLR_Pos = 0xd
	// Bit mask of FRAMERRCLR field.
	USART0_INTENCLR_FRAMERRCLR_Msk = 0x2000
	// Bit FRAMERRCLR.
	USART0_INTENCLR_FRAMERRCLR = 0x2000
	// Position of PARITYERRCLR field.
	USART0_INTENCLR_PARITYERRCLR_Pos = 0xe
	// Bit mask of PARITYERRCLR field.
	USART0_INTENCLR_PARITYERRCLR_Msk = 0x4000
	// Bit PARITYERRCLR.
	USART0_INTENCLR_PARITYERRCLR = 0x4000
	// Position of RXNOISECLR field.
	USART0_INTENCLR_RXNOISECLR_Pos = 0xf
	// Bit mask of RXNOISECLR field.
	USART0_INTENCLR_RXNOISECLR_Msk = 0x8000
	// Bit RXNOISECLR.
	USART0_INTENCLR_RXNOISECLR = 0x8000
	// Position of ABERRCLR field.
	USART0_INTENCLR_ABERRCLR_Pos = 0x10
	// Bit mask of ABERRCLR field.
	USART0_INTENCLR_ABERRCLR_Msk = 0x10000
	// Bit ABERRCLR.
	USART0_INTENCLR_ABERRCLR = 0x10000
	// Position of RESERVED field.
	USART0_INTENCLR_RESERVED_Pos = 0x11
	// Bit mask of RESERVED field.
	USART0_INTENCLR_RESERVED_Msk = 0xfffe0000

	// RXDAT: Receiver Data register. Contains the last character received.
	// Position of DATA field.
	USART0_RXDAT_DATA_Pos = 0x0
	// Bit mask of DATA field.
	USART0_RXDAT_DATA_Msk = 0x1ff
	// Position of RESERVED field.
	USART0_RXDAT_RESERVED_Pos = 0x9
	// Bit mask of RESERVED field.
	USART0_RXDAT_RESERVED_Msk = 0xfffffe00

	// RXDATSTAT: Receiver Data with Status register. Combines the last character received with the current USART receive status. Allows DMA or software to recover incoming data and status together.
	// Position of RXDATA field.
	USART0_RXDATSTAT_RXDATA_Pos = 0x0
	// Bit mask of RXDATA field.
	USART0_RXDATSTAT_RXDATA_Msk = 0x1ff
	// Position of RESERVED field.
	USART0_RXDATSTAT_RESERVED_Pos = 0x9
	// Bit mask of RESERVED field.
	USART0_RXDATSTAT_RESERVED_Msk = 0x1e00
	// Position of FRAMERR field.
	USART0_RXDATSTAT_FRAMERR_Pos = 0xd
	// Bit mask of FRAMERR field.
	USART0_RXDATSTAT_FRAMERR_Msk = 0x2000
	// Bit FRAMERR.
	USART0_RXDATSTAT_FRAMERR = 0x2000
	// Position of PARITYERR field.
	USART0_RXDATSTAT_PARITYERR_Pos = 0xe
	// Bit mask of PARITYERR field.
	USART0_RXDATSTAT_PARITYERR_Msk = 0x4000
	// Bit PARITYERR.
	USART0_RXDATSTAT_PARITYERR = 0x4000
	// Position of RXNOISE field.
	USART0_RXDATSTAT_RXNOISE_Pos = 0xf
	// Bit mask of RXNOISE field.
	USART0_RXDATSTAT_RXNOISE_Msk = 0x8000
	// Bit RXNOISE.
	USART0_RXDATSTAT_RXNOISE = 0x8000
	// Position of RESERVED field.
	USART0_RXDATSTAT_RESERVED_Pos = 0x10
	// Bit mask of RESERVED field.
	USART0_RXDATSTAT_RESERVED_Msk = 0xffff0000

	// TXDAT: Transmit Data register. Data to be transmitted is written here.
	// Position of TXDATA field.
	USART0_TXDAT_TXDATA_Pos = 0x0
	// Bit mask of TXDATA field.
	USART0_TXDAT_TXDATA_Msk = 0x1ff
	// Position of RESERVED field.
	USART0_TXDAT_RESERVED_Pos = 0x9
	// Bit mask of RESERVED field.
	USART0_TXDAT_RESERVED_Msk = 0xfffffe00

	// BRG: Baud Rate Generator register. 16-bit integer baud rate divisor value.
	// Position of BRGVAL field.
	USART0_BRG_BRGVAL_Pos = 0x0
	// Bit mask of BRGVAL field.
	USART0_BRG_BRGVAL_Msk = 0xffff
	// Position of RESERVED field.
	USART0_BRG_RESERVED_Pos = 0x10
	// Bit mask of RESERVED field.
	USART0_BRG_RESERVED_Msk = 0xffff0000

	// INTSTAT: Interrupt status register. Reflects interrupts that are currently enabled.
	// Position of RXRDY field.
	USART0_INTSTAT_RXRDY_Pos = 0x0
	// Bit mask of RXRDY field.
	USART0_INTSTAT_RXRDY_Msk = 0x1
	// Bit RXRDY.
	USART0_INTSTAT_RXRDY = 0x1
	// Position of RESERVED field.
	USART0_INTSTAT_RESERVED_Pos = 0x1
	// Bit mask of RESERVED field.
	USART0_INTSTAT_RESERVED_Msk = 0x2
	// Bit RESERVED.
	USART0_INTSTAT_RESERVED = 0x2
	// Position of TXRDY field.
	USART0_INTSTAT_TXRDY_Pos = 0x2
	// Bit mask of TXRDY field.
	USART0_INTSTAT_TXRDY_Msk = 0x4
	// Bit TXRDY.
	USART0_INTSTAT_TXRDY = 0x4
	// Position of TXIDLE field.
	USART0_INTSTAT_TXIDLE_Pos = 0x3
	// Bit mask of TXIDLE field.
	USART0_INTSTAT_TXIDLE_Msk = 0x8
	// Bit TXIDLE.
	USART0_INTSTAT_TXIDLE = 0x8
	// Position of RESERVED field.
	USART0_INTSTAT_RESERVED_Pos = 0x4
	// Bit mask of RESERVED field.
	USART0_INTSTAT_RESERVED_Msk = 0x10
	// Bit RESERVED.
	USART0_INTSTAT_RESERVED = 0x10
	// Position of DELTACTS field.
	USART0_INTSTAT_DELTACTS_Pos = 0x5
	// Bit mask of DELTACTS field.
	USART0_INTSTAT_DELTACTS_Msk = 0x20
	// Bit DELTACTS.
	USART0_INTSTAT_DELTACTS = 0x20
	// Position of TXDISINT field.
	USART0_INTSTAT_TXDISINT_Pos = 0x6
	// Bit mask of TXDISINT field.
	USART0_INTSTAT_TXDISINT_Msk = 0x40
	// Bit TXDISINT.
	USART0_INTSTAT_TXDISINT = 0x40
	// Position of RESERVED field.
	USART0_INTSTAT_RESERVED_Pos = 0x7
	// Bit mask of RESERVED field.
	USART0_INTSTAT_RESERVED_Msk = 0x80
	// Bit RESERVED.
	USART0_INTSTAT_RESERVED = 0x80
	// Position of OVERRUNINT field.
	USART0_INTSTAT_OVERRUNINT_Pos = 0x8
	// Bit mask of OVERRUNINT field.
	USART0_INTSTAT_OVERRUNINT_Msk = 0x100
	// Bit OVERRUNINT.
	USART0_INTSTAT_OVERRUNINT = 0x100
	// Position of RESERVED field.
	USART0_INTSTAT_RESERVED_Pos = 0x9
	// Bit mask of RESERVED field.
	USART0_INTSTAT_RESERVED_Msk = 0x600
	// Position of DELTARXBRK field.
	USART0_INTSTAT_DELTARXBRK_Pos = 0xb
	// Bit mask of DELTARXBRK field.
	USART0_INTSTAT_DELTARXBRK_Msk = 0x800
	// Bit DELTARXBRK.
	USART0_INTSTAT_DELTARXBRK = 0x800
	// Position of START field.
	USART0_INTSTAT_START_Pos = 0xc
	// Bit mask of START field.
	USART0_INTSTAT_START_Msk = 0x1000
	// Bit START.
	USART0_INTSTAT_START = 0x1000
	// Position of FRAMERRINT field.
	USART0_INTSTAT_FRAMERRINT_Pos = 0xd
	// Bit mask of FRAMERRINT field.
	USART0_INTSTAT_FRAMERRINT_Msk = 0x2000
	// Bit FRAMERRINT.
	USART0_INTSTAT_FRAMERRINT = 0x2000
	// Position of PARITYERRINT field.
	USART0_INTSTAT_PARITYERRINT_Pos = 0xe
	// Bit mask of PARITYERRINT field.
	USART0_INTSTAT_PARITYERRINT_Msk = 0x4000
	// Bit PARITYERRINT.
	USART0_INTSTAT_PARITYERRINT = 0x4000
	// Position of RXNOISEINT field.
	USART0_INTSTAT_RXNOISEINT_Pos = 0xf
	// Bit mask of RXNOISEINT field.
	USART0_INTSTAT_RXNOISEINT_Msk = 0x8000
	// Bit RXNOISEINT.
	USART0_INTSTAT_RXNOISEINT = 0x8000
	// Position of ABERRINT field.
	USART0_INTSTAT_ABERRINT_Pos = 0x10
	// Bit mask of ABERRINT field.
	USART0_INTSTAT_ABERRINT_Msk = 0x10000
	// Bit ABERRINT.
	USART0_INTSTAT_ABERRINT = 0x10000
	// Position of RESERVED field.
	USART0_INTSTAT_RESERVED_Pos = 0x11
	// Bit mask of RESERVED field.
	USART0_INTSTAT_RESERVED_Msk = 0xfffe0000

	// OSR: Oversample selection register for asynchronous communication.
	// Position of OSRVAL field.
	USART0_OSR_OSRVAL_Pos = 0x0
	// Bit mask of OSRVAL field.
	USART0_OSR_OSRVAL_Msk = 0xf
	// Position of RESERVED field.
	USART0_OSR_RESERVED_Pos = 0x4
	// Bit mask of RESERVED field.
	USART0_OSR_RESERVED_Msk = 0xfffffff0

	// ADDR: Address register for automatic address matching.
	// Position of ADDRESS field.
	USART0_ADDR_ADDRESS_Pos = 0x0
	// Bit mask of ADDRESS field.
	USART0_ADDR_ADDRESS_Msk = 0xff
	// Position of RESERVED field.
	USART0_ADDR_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	USART0_ADDR_RESERVED_Msk = 0xffffff00
)

// Bitfields for I2C0: I2C-bus interface 0
const (
	// CFG: Configuration for shared functions.
	// Position of MSTEN field.
	I2C0_CFG_MSTEN_Pos = 0x0
	// Bit mask of MSTEN field.
	I2C0_CFG_MSTEN_Msk = 0x1
	// Bit MSTEN.
	I2C0_CFG_MSTEN = 0x1
	// Disabled. The I2C Master function is disabled.
	I2C0_CFG_MSTEN_DISABLED = 0x0
	// Enabled. The I2C Master function is enabled.
	I2C0_CFG_MSTEN_ENABLED = 0x1
	// Position of SLVEN field.
	I2C0_CFG_SLVEN_Pos = 0x1
	// Bit mask of SLVEN field.
	I2C0_CFG_SLVEN_Msk = 0x2
	// Bit SLVEN.
	I2C0_CFG_SLVEN = 0x2
	// Disabled. The I2C slave function is disabled.
	I2C0_CFG_SLVEN_DISABLED = 0x0
	// Enabled. The I2C slave function is enabled.
	I2C0_CFG_SLVEN_ENABLED = 0x1
	// Position of MONEN field.
	I2C0_CFG_MONEN_Pos = 0x2
	// Bit mask of MONEN field.
	I2C0_CFG_MONEN_Msk = 0x4
	// Bit MONEN.
	I2C0_CFG_MONEN = 0x4
	// Disabled. The I2C monitor function is disabled.
	I2C0_CFG_MONEN_DISABLED = 0x0
	// Enabled. The I2C monitor function is enabled.
	I2C0_CFG_MONEN_ENABLED = 0x1
	// Position of TIMEOUTEN field.
	I2C0_CFG_TIMEOUTEN_Pos = 0x3
	// Bit mask of TIMEOUTEN field.
	I2C0_CFG_TIMEOUTEN_Msk = 0x8
	// Bit TIMEOUTEN.
	I2C0_CFG_TIMEOUTEN = 0x8
	// Disabled. Time-out function is disabled.
	I2C0_CFG_TIMEOUTEN_DISABLED = 0x0
	// Enabled. Time-out function is enabled. Both types of time-out flags will be generated and will cause interrupts if they are enabled. Typically, only one time-out will be used in a system.
	I2C0_CFG_TIMEOUTEN_ENABLED = 0x1
	// Position of MONCLKSTR field.
	I2C0_CFG_MONCLKSTR_Pos = 0x4
	// Bit mask of MONCLKSTR field.
	I2C0_CFG_MONCLKSTR_Msk = 0x10
	// Bit MONCLKSTR.
	I2C0_CFG_MONCLKSTR = 0x10
	// Disabled. The monitor function will not perform clock stretching. Software or DMA may not always be able to read data provided by the monitor function before it is overwritten. This mode may be used when non-invasive monitoring is critical.
	I2C0_CFG_MONCLKSTR_DISABLED = 0x0
	// Enabled. The monitor function will perform clock stretching in order to ensure that software or DMA can read all incoming data supplied by the monitor function.
	I2C0_CFG_MONCLKSTR_ENABLED = 0x1
	// Position of HSCAPABLE field.
	I2C0_CFG_HSCAPABLE_Pos = 0x5
	// Bit mask of HSCAPABLE field.
	I2C0_CFG_HSCAPABLE_Msk = 0x20
	// Bit HSCAPABLE.
	I2C0_CFG_HSCAPABLE = 0x20
	// Fast-mode plus. The I2C block will support Standard-mode, Fast-mode, and Fast-mode Plus, to the extent that the pin electronics support these modes. Any changes that need to be made to the pin controls, such as changing the drive strength or filtering, must be made by software via the IOCON register associated with each I2C pin,
	I2C0_CFG_HSCAPABLE_FAST_MODE_PLUS = 0x0
	// High-speed. In addition to Standard-mode, Fast-mode, and Fast-mode Plus, the I 2C block will support High-speed mode to the extent that the pin electronics support these modes. See Section 23.7.1.2 for more information.
	I2C0_CFG_HSCAPABLE_HIGH_SPEED = 0x1
	// Position of RESERVED field.
	I2C0_CFG_RESERVED_Pos = 0x6
	// Bit mask of RESERVED field.
	I2C0_CFG_RESERVED_Msk = 0xffffffc0

	// STAT: Status register for Master, Slave, and Monitor functions.
	// Position of MSTPENDING field.
	I2C0_STAT_MSTPENDING_Pos = 0x0
	// Bit mask of MSTPENDING field.
	I2C0_STAT_MSTPENDING_Msk = 0x1
	// Bit MSTPENDING.
	I2C0_STAT_MSTPENDING = 0x1
	// In progress. Communication is in progress and the Master function is busy and cannot currently accept a command.
	I2C0_STAT_MSTPENDING_IN_PROGRESS = 0x0
	// Pending. The Master function needs software service or is in the idle state. If the master is not in the idle state, it is waiting to receive or transmit data or the NACK bit.
	I2C0_STAT_MSTPENDING_PENDING = 0x1
	// Position of MSTSTATE field.
	I2C0_STAT_MSTSTATE_Pos = 0x1
	// Bit mask of MSTSTATE field.
	I2C0_STAT_MSTSTATE_Msk = 0xe
	// Idle. The Master function is available to be used for a new transaction.
	I2C0_STAT_MSTSTATE_IDLE = 0x0
	// Receive ready. Received data available (Master Receiver mode). Address plus Read was previously sent and Acknowledged by slave.
	I2C0_STAT_MSTSTATE_RECEIVE_READY = 0x1
	// Transmit ready. Data can be transmitted (Master Transmitter mode). Address plus Write was previously sent and Acknowledged by slave.
	I2C0_STAT_MSTSTATE_TRANSMIT_READY = 0x2
	// NACK Address. Slave NACKed address.
	I2C0_STAT_MSTSTATE_NACK_ADDRESS = 0x3
	// NACK Data. Slave NACKed transmitted data.
	I2C0_STAT_MSTSTATE_NACK_DATA = 0x4
	// Position of MSTARBLOSS field.
	I2C0_STAT_MSTARBLOSS_Pos = 0x4
	// Bit mask of MSTARBLOSS field.
	I2C0_STAT_MSTARBLOSS_Msk = 0x10
	// Bit MSTARBLOSS.
	I2C0_STAT_MSTARBLOSS = 0x10
	// No Arbitration Loss has occurred.
	I2C0_STAT_MSTARBLOSS_NO_ARBITRATION_LOSS = 0x0
	// Arbitration loss. The Master function has experienced an Arbitration Loss. At this point, the Master function has already stopped driving the bus and gone to an idle state. Software can respond by doing nothing, or by sending a Start in order to attempt to gain control of the bus when it next becomes idle.
	I2C0_STAT_MSTARBLOSS_ARBITRATION_LOSS = 0x1
	// Position of RESERVED field.
	I2C0_STAT_RESERVED_Pos = 0x5
	// Bit mask of RESERVED field.
	I2C0_STAT_RESERVED_Msk = 0x20
	// Bit RESERVED.
	I2C0_STAT_RESERVED = 0x20
	// Position of MSTSTSTPERR field.
	I2C0_STAT_MSTSTSTPERR_Pos = 0x6
	// Bit mask of MSTSTSTPERR field.
	I2C0_STAT_MSTSTSTPERR_Msk = 0x40
	// Bit MSTSTSTPERR.
	I2C0_STAT_MSTSTSTPERR = 0x40
	// No Start/Stop Error has occurred.
	I2C0_STAT_MSTSTSTPERR_NO_STARTSTOP_ERROR = 0x0
	// The Master function has experienced a Start/Stop Error. A Start or Stop was detected at a time when it is not allowed by the I2C specification. The Master interface has stopped driving the bus and gone to an idle state, no action is required. A request for a Start could be made, or software could attempt to insure that the bus has not stalled.
	I2C0_STAT_MSTSTSTPERR_THE_MASTER_FUNCTION = 0x1
	// Position of RESERVED field.
	I2C0_STAT_RESERVED_Pos = 0x7
	// Bit mask of RESERVED field.
	I2C0_STAT_RESERVED_Msk = 0x80
	// Bit RESERVED.
	I2C0_STAT_RESERVED = 0x80
	// Position of SLVPENDING field.
	I2C0_STAT_SLVPENDING_Pos = 0x8
	// Bit mask of SLVPENDING field.
	I2C0_STAT_SLVPENDING_Msk = 0x100
	// Bit SLVPENDING.
	I2C0_STAT_SLVPENDING = 0x100
	// In progress. The Slave function does not currently need service.
	I2C0_STAT_SLVPENDING_IN_PROGRESS = 0x0
	// Pending. The Slave function needs service. Information on what is needed can be found in the adjacent SLVSTATE field.
	I2C0_STAT_SLVPENDING_PENDING = 0x1
	// Position of SLVSTATE field.
	I2C0_STAT_SLVSTATE_Pos = 0x9
	// Bit mask of SLVSTATE field.
	I2C0_STAT_SLVSTATE_Msk = 0x600
	// Slave address. Address plus R/W received. At least one of the four slave addresses has been matched by hardware.
	I2C0_STAT_SLVSTATE_SLAVE_ADDRESS = 0x0
	// Slave receive. Received data is available (Slave Receiver mode).
	I2C0_STAT_SLVSTATE_SLAVE_RECEIVE = 0x1
	// Slave transmit. Data can be transmitted (Slave Transmitter mode).
	I2C0_STAT_SLVSTATE_SLAVE_TRANSMIT = 0x2
	// Position of SLVNOTSTR field.
	I2C0_STAT_SLVNOTSTR_Pos = 0xb
	// Bit mask of SLVNOTSTR field.
	I2C0_STAT_SLVNOTSTR_Msk = 0x800
	// Bit SLVNOTSTR.
	I2C0_STAT_SLVNOTSTR = 0x800
	// Stretching. The slave function is currently stretching the I2C bus clock. Deep-Sleep or Power-down mode cannot be entered at this time.
	I2C0_STAT_SLVNOTSTR_STRETCHING = 0x0
	// Not stretching. The slave function is not currently stretching the I 2C bus clock. Deep-sleep or Power-down mode could be entered at this time.
	I2C0_STAT_SLVNOTSTR_NOT_STRETCHING = 0x1
	// Position of SLVIDX field.
	I2C0_STAT_SLVIDX_Pos = 0xc
	// Bit mask of SLVIDX field.
	I2C0_STAT_SLVIDX_Msk = 0x3000
	// Address 0. Slave address 0 was matched.
	I2C0_STAT_SLVIDX_ADDRESS_0 = 0x0
	// Address 1. Slave address 1 was matched.
	I2C0_STAT_SLVIDX_ADDRESS_1 = 0x1
	// Address 2. Slave address 2 was matched.
	I2C0_STAT_SLVIDX_ADDRESS_2 = 0x2
	// Address 3. Slave address 3 was matched.
	I2C0_STAT_SLVIDX_ADDRESS_3 = 0x3
	// Position of SLVSEL field.
	I2C0_STAT_SLVSEL_Pos = 0xe
	// Bit mask of SLVSEL field.
	I2C0_STAT_SLVSEL_Msk = 0x4000
	// Bit SLVSEL.
	I2C0_STAT_SLVSEL = 0x4000
	// Not selected. The Slave function is not currently selected.
	I2C0_STAT_SLVSEL_NOT_SELECTED = 0x0
	// Selected. The Slave function is currently selected.
	I2C0_STAT_SLVSEL_SELECTED = 0x1
	// Position of SLVDESEL field.
	I2C0_STAT_SLVDESEL_Pos = 0xf
	// Bit mask of SLVDESEL field.
	I2C0_STAT_SLVDESEL_Msk = 0x8000
	// Bit SLVDESEL.
	I2C0_STAT_SLVDESEL = 0x8000
	// Not deselected. The Slave function has not become deselected. This does not mean that it is currently selected. That information can be found in the SLVSEL flag.
	I2C0_STAT_SLVDESEL_NOT_DESELECTED = 0x0
	// Deselected. The Slave function has become deselected. This is specifically caused by the SLVSEL flag changing from 1 to 0. See the description of SLVSEL for details on when that event occurs.
	I2C0_STAT_SLVDESEL_DESELECTED = 0x1
	// Position of MONRDY field.
	I2C0_STAT_MONRDY_Pos = 0x10
	// Bit mask of MONRDY field.
	I2C0_STAT_MONRDY_Msk = 0x10000
	// Bit MONRDY.
	I2C0_STAT_MONRDY = 0x10000
	// No data. The Monitor function does not currently have data available.
	I2C0_STAT_MONRDY_NO_DATA = 0x0
	// Data waiting. The Monitor function has data waiting to be read.
	I2C0_STAT_MONRDY_DATA_WAITING = 0x1
	// Position of MONOV field.
	I2C0_STAT_MONOV_Pos = 0x11
	// Bit mask of MONOV field.
	I2C0_STAT_MONOV_Msk = 0x20000
	// Bit MONOV.
	I2C0_STAT_MONOV = 0x20000
	// No overrun. Monitor data has not overrun.
	I2C0_STAT_MONOV_NO_OVERRUN = 0x0
	// Overrun. A Monitor data overrun has occurred. This can only happen when Monitor clock stretching not enabled via the MONCLKSTR bit in the CFG register. Writing 1 to this bit clears the flag.
	I2C0_STAT_MONOV_OVERRUN = 0x1
	// Position of MONACTIVE field.
	I2C0_STAT_MONACTIVE_Pos = 0x12
	// Bit mask of MONACTIVE field.
	I2C0_STAT_MONACTIVE_Msk = 0x40000
	// Bit MONACTIVE.
	I2C0_STAT_MONACTIVE = 0x40000
	// Inactive. The Monitor function considers the I2C bus to be inactive.
	I2C0_STAT_MONACTIVE_INACTIVE = 0x0
	// Active. The Monitor function considers the I2C bus to be active.
	I2C0_STAT_MONACTIVE_ACTIVE = 0x1
	// Position of MONIDLE field.
	I2C0_STAT_MONIDLE_Pos = 0x13
	// Bit mask of MONIDLE field.
	I2C0_STAT_MONIDLE_Msk = 0x80000
	// Bit MONIDLE.
	I2C0_STAT_MONIDLE = 0x80000
	// Not idle. The I2C bus is not idle, or this flag has been cleared by software.
	I2C0_STAT_MONIDLE_NOT_IDLE = 0x0
	// Idle. The I2C bus has gone idle at least once since the last time this flag was cleared by software.
	I2C0_STAT_MONIDLE_IDLE = 0x1
	// Position of RESERVED field.
	I2C0_STAT_RESERVED_Pos = 0x14
	// Bit mask of RESERVED field.
	I2C0_STAT_RESERVED_Msk = 0xf00000
	// Position of EVENTTIMEOUT field.
	I2C0_STAT_EVENTTIMEOUT_Pos = 0x18
	// Bit mask of EVENTTIMEOUT field.
	I2C0_STAT_EVENTTIMEOUT_Msk = 0x1000000
	// Bit EVENTTIMEOUT.
	I2C0_STAT_EVENTTIMEOUT = 0x1000000
	// No time-out. I2C bus events have not caused a time-out.
	I2C0_STAT_EVENTTIMEOUT_NO_TIME_OUT = 0x0
	// Event time-out. The time between I2C bus events has been longer than the time specified by the I2C TIMEOUT register.
	I2C0_STAT_EVENTTIMEOUT_EVENT_TIME_OUT = 0x1
	// Position of SCLTIMEOUT field.
	I2C0_STAT_SCLTIMEOUT_Pos = 0x19
	// Bit mask of SCLTIMEOUT field.
	I2C0_STAT_SCLTIMEOUT_Msk = 0x2000000
	// Bit SCLTIMEOUT.
	I2C0_STAT_SCLTIMEOUT = 0x2000000
	// No time-out. SCL low time has not caused a time-out.
	I2C0_STAT_SCLTIMEOUT_NO_TIME_OUT = 0x0
	// Time-out. SCL low time has caused a time-out.
	I2C0_STAT_SCLTIMEOUT_TIME_OUT = 0x1
	// Position of RESERVED field.
	I2C0_STAT_RESERVED_Pos = 0x1a
	// Bit mask of RESERVED field.
	I2C0_STAT_RESERVED_Msk = 0xfc000000

	// INTENSET: Interrupt Enable Set and read register.
	// Position of MSTPENDINGEN field.
	I2C0_INTENSET_MSTPENDINGEN_Pos = 0x0
	// Bit mask of MSTPENDINGEN field.
	I2C0_INTENSET_MSTPENDINGEN_Msk = 0x1
	// Bit MSTPENDINGEN.
	I2C0_INTENSET_MSTPENDINGEN = 0x1
	// Disabled. The MstPending interrupt is disabled.
	I2C0_INTENSET_MSTPENDINGEN_DISABLED = 0x0
	// Enabled. The MstPending interrupt is enabled.
	I2C0_INTENSET_MSTPENDINGEN_ENABLED = 0x1
	// Position of RESERVED field.
	I2C0_INTENSET_RESERVED_Pos = 0x1
	// Bit mask of RESERVED field.
	I2C0_INTENSET_RESERVED_Msk = 0xe
	// Position of MSTARBLOSSEN field.
	I2C0_INTENSET_MSTARBLOSSEN_Pos = 0x4
	// Bit mask of MSTARBLOSSEN field.
	I2C0_INTENSET_MSTARBLOSSEN_Msk = 0x10
	// Bit MSTARBLOSSEN.
	I2C0_INTENSET_MSTARBLOSSEN = 0x10
	// Disabled. The MstArbLoss interrupt is disabled.
	I2C0_INTENSET_MSTARBLOSSEN_DISABLED = 0x0
	// Enabled. The MstArbLoss interrupt is enabled.
	I2C0_INTENSET_MSTARBLOSSEN_ENABLED = 0x1
	// Position of RESERVED field.
	I2C0_INTENSET_RESERVED_Pos = 0x5
	// Bit mask of RESERVED field.
	I2C0_INTENSET_RESERVED_Msk = 0x20
	// Bit RESERVED.
	I2C0_INTENSET_RESERVED = 0x20
	// Position of MSTSTSTPERREN field.
	I2C0_INTENSET_MSTSTSTPERREN_Pos = 0x6
	// Bit mask of MSTSTSTPERREN field.
	I2C0_INTENSET_MSTSTSTPERREN_Msk = 0x40
	// Bit MSTSTSTPERREN.
	I2C0_INTENSET_MSTSTSTPERREN = 0x40
	// Disabled. The MstStStpErr interrupt is disabled.
	I2C0_INTENSET_MSTSTSTPERREN_DISABLED = 0x0
	// Enabled. The MstStStpErr interrupt is enabled.
	I2C0_INTENSET_MSTSTSTPERREN_ENABLED = 0x1
	// Position of RESERVED field.
	I2C0_INTENSET_RESERVED_Pos = 0x7
	// Bit mask of RESERVED field.
	I2C0_INTENSET_RESERVED_Msk = 0x80
	// Bit RESERVED.
	I2C0_INTENSET_RESERVED = 0x80
	// Position of SLVPENDINGEN field.
	I2C0_INTENSET_SLVPENDINGEN_Pos = 0x8
	// Bit mask of SLVPENDINGEN field.
	I2C0_INTENSET_SLVPENDINGEN_Msk = 0x100
	// Bit SLVPENDINGEN.
	I2C0_INTENSET_SLVPENDINGEN = 0x100
	// Disabled. The SlvPending interrupt is disabled.
	I2C0_INTENSET_SLVPENDINGEN_DISABLED = 0x0
	// Enabled. The SlvPending interrupt is enabled.
	I2C0_INTENSET_SLVPENDINGEN_ENABLED = 0x1
	// Position of RESERVED field.
	I2C0_INTENSET_RESERVED_Pos = 0x9
	// Bit mask of RESERVED field.
	I2C0_INTENSET_RESERVED_Msk = 0x600
	// Position of SLVNOTSTREN field.
	I2C0_INTENSET_SLVNOTSTREN_Pos = 0xb
	// Bit mask of SLVNOTSTREN field.
	I2C0_INTENSET_SLVNOTSTREN_Msk = 0x800
	// Bit SLVNOTSTREN.
	I2C0_INTENSET_SLVNOTSTREN = 0x800
	// Disabled. The SlvNotStr interrupt is disabled.
	I2C0_INTENSET_SLVNOTSTREN_DISABLED = 0x0
	// Enabled. The SlvNotStr interrupt is enabled.
	I2C0_INTENSET_SLVNOTSTREN_ENABLED = 0x1
	// Position of RESERVED field.
	I2C0_INTENSET_RESERVED_Pos = 0xc
	// Bit mask of RESERVED field.
	I2C0_INTENSET_RESERVED_Msk = 0x7000
	// Position of SLVDESELEN field.
	I2C0_INTENSET_SLVDESELEN_Pos = 0xf
	// Bit mask of SLVDESELEN field.
	I2C0_INTENSET_SLVDESELEN_Msk = 0x8000
	// Bit SLVDESELEN.
	I2C0_INTENSET_SLVDESELEN = 0x8000
	// Disabled. The SlvDeSel interrupt is disabled.
	I2C0_INTENSET_SLVDESELEN_DISABLED = 0x0
	// Enabled. The SlvDeSel interrupt is enabled.
	I2C0_INTENSET_SLVDESELEN_ENABLED = 0x1
	// Position of MONRDYEN field.
	I2C0_INTENSET_MONRDYEN_Pos = 0x10
	// Bit mask of MONRDYEN field.
	I2C0_INTENSET_MONRDYEN_Msk = 0x10000
	// Bit MONRDYEN.
	I2C0_INTENSET_MONRDYEN = 0x10000
	// Disabled. The MonRdy interrupt is disabled.
	I2C0_INTENSET_MONRDYEN_DISABLED = 0x0
	// Enabled. The MonRdy interrupt is enabled.
	I2C0_INTENSET_MONRDYEN_ENABLED = 0x1
	// Position of MONOVEN field.
	I2C0_INTENSET_MONOVEN_Pos = 0x11
	// Bit mask of MONOVEN field.
	I2C0_INTENSET_MONOVEN_Msk = 0x20000
	// Bit MONOVEN.
	I2C0_INTENSET_MONOVEN = 0x20000
	// Disabled. The MonOv interrupt is disabled.
	I2C0_INTENSET_MONOVEN_DISABLED = 0x0
	// Enabled. The MonOv interrupt is enabled.
	I2C0_INTENSET_MONOVEN_ENABLED = 0x1
	// Position of RESERVED field.
	I2C0_INTENSET_RESERVED_Pos = 0x12
	// Bit mask of RESERVED field.
	I2C0_INTENSET_RESERVED_Msk = 0x40000
	// Bit RESERVED.
	I2C0_INTENSET_RESERVED = 0x40000
	// Position of MONIDLEEN field.
	I2C0_INTENSET_MONIDLEEN_Pos = 0x13
	// Bit mask of MONIDLEEN field.
	I2C0_INTENSET_MONIDLEEN_Msk = 0x80000
	// Bit MONIDLEEN.
	I2C0_INTENSET_MONIDLEEN = 0x80000
	// Disabled. The MonIdle interrupt is disabled.
	I2C0_INTENSET_MONIDLEEN_DISABLED = 0x0
	// Enabled. The MonIdle interrupt is enabled.
	I2C0_INTENSET_MONIDLEEN_ENABLED = 0x1
	// Position of RESERVED field.
	I2C0_INTENSET_RESERVED_Pos = 0x14
	// Bit mask of RESERVED field.
	I2C0_INTENSET_RESERVED_Msk = 0xf00000
	// Position of EVENTTIMEOUTEN field.
	I2C0_INTENSET_EVENTTIMEOUTEN_Pos = 0x18
	// Bit mask of EVENTTIMEOUTEN field.
	I2C0_INTENSET_EVENTTIMEOUTEN_Msk = 0x1000000
	// Bit EVENTTIMEOUTEN.
	I2C0_INTENSET_EVENTTIMEOUTEN = 0x1000000
	// Disabled. The Event time-out interrupt is disabled.
	I2C0_INTENSET_EVENTTIMEOUTEN_DISABLED = 0x0
	// Enabled. The Event time-out interrupt is enabled.
	I2C0_INTENSET_EVENTTIMEOUTEN_ENABLED = 0x1
	// Position of SCLTIMEOUTEN field.
	I2C0_INTENSET_SCLTIMEOUTEN_Pos = 0x19
	// Bit mask of SCLTIMEOUTEN field.
	I2C0_INTENSET_SCLTIMEOUTEN_Msk = 0x2000000
	// Bit SCLTIMEOUTEN.
	I2C0_INTENSET_SCLTIMEOUTEN = 0x2000000
	// Disabled. The SCL time-out interrupt is disabled.
	I2C0_INTENSET_SCLTIMEOUTEN_DISABLED = 0x0
	// Enabled. The SCL time-out interrupt is enabled.
	I2C0_INTENSET_SCLTIMEOUTEN_ENABLED = 0x1
	// Position of RESERVED field.
	I2C0_INTENSET_RESERVED_Pos = 0x1a
	// Bit mask of RESERVED field.
	I2C0_INTENSET_RESERVED_Msk = 0xfc000000

	// INTENCLR: Interrupt Enable Clear register.
	// Position of MSTPENDINGCLR field.
	I2C0_INTENCLR_MSTPENDINGCLR_Pos = 0x0
	// Bit mask of MSTPENDINGCLR field.
	I2C0_INTENCLR_MSTPENDINGCLR_Msk = 0x1
	// Bit MSTPENDINGCLR.
	I2C0_INTENCLR_MSTPENDINGCLR = 0x1
	// Position of RESERVED field.
	I2C0_INTENCLR_RESERVED_Pos = 0x1
	// Bit mask of RESERVED field.
	I2C0_INTENCLR_RESERVED_Msk = 0xe
	// Position of MSTARBLOSSCLR field.
	I2C0_INTENCLR_MSTARBLOSSCLR_Pos = 0x4
	// Bit mask of MSTARBLOSSCLR field.
	I2C0_INTENCLR_MSTARBLOSSCLR_Msk = 0x10
	// Bit MSTARBLOSSCLR.
	I2C0_INTENCLR_MSTARBLOSSCLR = 0x10
	// Position of RESERVED field.
	I2C0_INTENCLR_RESERVED_Pos = 0x5
	// Bit mask of RESERVED field.
	I2C0_INTENCLR_RESERVED_Msk = 0x20
	// Bit RESERVED.
	I2C0_INTENCLR_RESERVED = 0x20
	// Position of MSTSTSTPERRCLR field.
	I2C0_INTENCLR_MSTSTSTPERRCLR_Pos = 0x6
	// Bit mask of MSTSTSTPERRCLR field.
	I2C0_INTENCLR_MSTSTSTPERRCLR_Msk = 0x40
	// Bit MSTSTSTPERRCLR.
	I2C0_INTENCLR_MSTSTSTPERRCLR = 0x40
	// Position of RESERVED field.
	I2C0_INTENCLR_RESERVED_Pos = 0x7
	// Bit mask of RESERVED field.
	I2C0_INTENCLR_RESERVED_Msk = 0x80
	// Bit RESERVED.
	I2C0_INTENCLR_RESERVED = 0x80
	// Position of SLVPENDINGCLR field.
	I2C0_INTENCLR_SLVPENDINGCLR_Pos = 0x8
	// Bit mask of SLVPENDINGCLR field.
	I2C0_INTENCLR_SLVPENDINGCLR_Msk = 0x100
	// Bit SLVPENDINGCLR.
	I2C0_INTENCLR_SLVPENDINGCLR = 0x100
	// Position of RESERVED field.
	I2C0_INTENCLR_RESERVED_Pos = 0x9
	// Bit mask of RESERVED field.
	I2C0_INTENCLR_RESERVED_Msk = 0x600
	// Position of SLVNOTSTRCLR field.
	I2C0_INTENCLR_SLVNOTSTRCLR_Pos = 0xb
	// Bit mask of SLVNOTSTRCLR field.
	I2C0_INTENCLR_SLVNOTSTRCLR_Msk = 0x800
	// Bit SLVNOTSTRCLR.
	I2C0_INTENCLR_SLVNOTSTRCLR = 0x800
	// Position of RESERVED field.
	I2C0_INTENCLR_RESERVED_Pos = 0xc
	// Bit mask of RESERVED field.
	I2C0_INTENCLR_RESERVED_Msk = 0x7000
	// Position of SLVDESELCLR field.
	I2C0_INTENCLR_SLVDESELCLR_Pos = 0xf
	// Bit mask of SLVDESELCLR field.
	I2C0_INTENCLR_SLVDESELCLR_Msk = 0x8000
	// Bit SLVDESELCLR.
	I2C0_INTENCLR_SLVDESELCLR = 0x8000
	// Position of MONRDYCLR field.
	I2C0_INTENCLR_MONRDYCLR_Pos = 0x10
	// Bit mask of MONRDYCLR field.
	I2C0_INTENCLR_MONRDYCLR_Msk = 0x10000
	// Bit MONRDYCLR.
	I2C0_INTENCLR_MONRDYCLR = 0x10000
	// Position of MONOVCLR field.
	I2C0_INTENCLR_MONOVCLR_Pos = 0x11
	// Bit mask of MONOVCLR field.
	I2C0_INTENCLR_MONOVCLR_Msk = 0x20000
	// Bit MONOVCLR.
	I2C0_INTENCLR_MONOVCLR = 0x20000
	// Position of RESERVED field.
	I2C0_INTENCLR_RESERVED_Pos = 0x12
	// Bit mask of RESERVED field.
	I2C0_INTENCLR_RESERVED_Msk = 0x40000
	// Bit RESERVED.
	I2C0_INTENCLR_RESERVED = 0x40000
	// Position of MONIDLECLR field.
	I2C0_INTENCLR_MONIDLECLR_Pos = 0x13
	// Bit mask of MONIDLECLR field.
	I2C0_INTENCLR_MONIDLECLR_Msk = 0x80000
	// Bit MONIDLECLR.
	I2C0_INTENCLR_MONIDLECLR = 0x80000
	// Position of RESERVED field.
	I2C0_INTENCLR_RESERVED_Pos = 0x14
	// Bit mask of RESERVED field.
	I2C0_INTENCLR_RESERVED_Msk = 0xf00000
	// Position of EVENTTIMEOUTCLR field.
	I2C0_INTENCLR_EVENTTIMEOUTCLR_Pos = 0x18
	// Bit mask of EVENTTIMEOUTCLR field.
	I2C0_INTENCLR_EVENTTIMEOUTCLR_Msk = 0x1000000
	// Bit EVENTTIMEOUTCLR.
	I2C0_INTENCLR_EVENTTIMEOUTCLR = 0x1000000
	// Position of SCLTIMEOUTCLR field.
	I2C0_INTENCLR_SCLTIMEOUTCLR_Pos = 0x19
	// Bit mask of SCLTIMEOUTCLR field.
	I2C0_INTENCLR_SCLTIMEOUTCLR_Msk = 0x2000000
	// Bit SCLTIMEOUTCLR.
	I2C0_INTENCLR_SCLTIMEOUTCLR = 0x2000000
	// Position of RESERVED field.
	I2C0_INTENCLR_RESERVED_Pos = 0x1a
	// Bit mask of RESERVED field.
	I2C0_INTENCLR_RESERVED_Msk = 0xfc000000

	// TIMEOUT: Time-out value register.
	// Position of TOMIN field.
	I2C0_TIMEOUT_TOMIN_Pos = 0x0
	// Bit mask of TOMIN field.
	I2C0_TIMEOUT_TOMIN_Msk = 0xf
	// Position of TO field.
	I2C0_TIMEOUT_TO_Pos = 0x4
	// Bit mask of TO field.
	I2C0_TIMEOUT_TO_Msk = 0xfff0
	// Position of RESERVED field.
	I2C0_TIMEOUT_RESERVED_Pos = 0x10
	// Bit mask of RESERVED field.
	I2C0_TIMEOUT_RESERVED_Msk = 0xffff0000

	// CLKDIV: Clock pre-divider for the entire I2C block. This determines what time increments are used for the MSTTIME register, and controls some timing of the Slave function.
	// Position of DIVVAL field.
	I2C0_CLKDIV_DIVVAL_Pos = 0x0
	// Bit mask of DIVVAL field.
	I2C0_CLKDIV_DIVVAL_Msk = 0xffff
	// Position of RESERVED field.
	I2C0_CLKDIV_RESERVED_Pos = 0x10
	// Bit mask of RESERVED field.
	I2C0_CLKDIV_RESERVED_Msk = 0xffff0000

	// INTSTAT: Interrupt Status register for Master, Slave, and Monitor functions.
	// Position of MSTPENDING field.
	I2C0_INTSTAT_MSTPENDING_Pos = 0x0
	// Bit mask of MSTPENDING field.
	I2C0_INTSTAT_MSTPENDING_Msk = 0x1
	// Bit MSTPENDING.
	I2C0_INTSTAT_MSTPENDING = 0x1
	// Position of RESERVED field.
	I2C0_INTSTAT_RESERVED_Pos = 0x1
	// Bit mask of RESERVED field.
	I2C0_INTSTAT_RESERVED_Msk = 0xe
	// Position of MSTARBLOSS field.
	I2C0_INTSTAT_MSTARBLOSS_Pos = 0x4
	// Bit mask of MSTARBLOSS field.
	I2C0_INTSTAT_MSTARBLOSS_Msk = 0x10
	// Bit MSTARBLOSS.
	I2C0_INTSTAT_MSTARBLOSS = 0x10
	// Position of RESERVED field.
	I2C0_INTSTAT_RESERVED_Pos = 0x5
	// Bit mask of RESERVED field.
	I2C0_INTSTAT_RESERVED_Msk = 0x20
	// Bit RESERVED.
	I2C0_INTSTAT_RESERVED = 0x20
	// Position of MSTSTSTPERR field.
	I2C0_INTSTAT_MSTSTSTPERR_Pos = 0x6
	// Bit mask of MSTSTSTPERR field.
	I2C0_INTSTAT_MSTSTSTPERR_Msk = 0x40
	// Bit MSTSTSTPERR.
	I2C0_INTSTAT_MSTSTSTPERR = 0x40
	// Position of RESERVED field.
	I2C0_INTSTAT_RESERVED_Pos = 0x7
	// Bit mask of RESERVED field.
	I2C0_INTSTAT_RESERVED_Msk = 0x80
	// Bit RESERVED.
	I2C0_INTSTAT_RESERVED = 0x80
	// Position of SLVPENDING field.
	I2C0_INTSTAT_SLVPENDING_Pos = 0x8
	// Bit mask of SLVPENDING field.
	I2C0_INTSTAT_SLVPENDING_Msk = 0x100
	// Bit SLVPENDING.
	I2C0_INTSTAT_SLVPENDING = 0x100
	// Position of RESERVED field.
	I2C0_INTSTAT_RESERVED_Pos = 0x9
	// Bit mask of RESERVED field.
	I2C0_INTSTAT_RESERVED_Msk = 0x600
	// Position of SLVNOTSTR field.
	I2C0_INTSTAT_SLVNOTSTR_Pos = 0xb
	// Bit mask of SLVNOTSTR field.
	I2C0_INTSTAT_SLVNOTSTR_Msk = 0x800
	// Bit SLVNOTSTR.
	I2C0_INTSTAT_SLVNOTSTR = 0x800
	// Position of RESERVED field.
	I2C0_INTSTAT_RESERVED_Pos = 0xc
	// Bit mask of RESERVED field.
	I2C0_INTSTAT_RESERVED_Msk = 0x7000
	// Position of SLVDESEL field.
	I2C0_INTSTAT_SLVDESEL_Pos = 0xf
	// Bit mask of SLVDESEL field.
	I2C0_INTSTAT_SLVDESEL_Msk = 0x8000
	// Bit SLVDESEL.
	I2C0_INTSTAT_SLVDESEL = 0x8000
	// Position of MONRDY field.
	I2C0_INTSTAT_MONRDY_Pos = 0x10
	// Bit mask of MONRDY field.
	I2C0_INTSTAT_MONRDY_Msk = 0x10000
	// Bit MONRDY.
	I2C0_INTSTAT_MONRDY = 0x10000
	// Position of MONOV field.
	I2C0_INTSTAT_MONOV_Pos = 0x11
	// Bit mask of MONOV field.
	I2C0_INTSTAT_MONOV_Msk = 0x20000
	// Bit MONOV.
	I2C0_INTSTAT_MONOV = 0x20000
	// Position of RESERVED field.
	I2C0_INTSTAT_RESERVED_Pos = 0x12
	// Bit mask of RESERVED field.
	I2C0_INTSTAT_RESERVED_Msk = 0x40000
	// Bit RESERVED.
	I2C0_INTSTAT_RESERVED = 0x40000
	// Position of MONIDLE field.
	I2C0_INTSTAT_MONIDLE_Pos = 0x13
	// Bit mask of MONIDLE field.
	I2C0_INTSTAT_MONIDLE_Msk = 0x80000
	// Bit MONIDLE.
	I2C0_INTSTAT_MONIDLE = 0x80000
	// Position of RESERVED field.
	I2C0_INTSTAT_RESERVED_Pos = 0x14
	// Bit mask of RESERVED field.
	I2C0_INTSTAT_RESERVED_Msk = 0xf00000
	// Position of EVENTTIMEOUT field.
	I2C0_INTSTAT_EVENTTIMEOUT_Pos = 0x18
	// Bit mask of EVENTTIMEOUT field.
	I2C0_INTSTAT_EVENTTIMEOUT_Msk = 0x1000000
	// Bit EVENTTIMEOUT.
	I2C0_INTSTAT_EVENTTIMEOUT = 0x1000000
	// Position of SCLTIMEOUT field.
	I2C0_INTSTAT_SCLTIMEOUT_Pos = 0x19
	// Bit mask of SCLTIMEOUT field.
	I2C0_INTSTAT_SCLTIMEOUT_Msk = 0x2000000
	// Bit SCLTIMEOUT.
	I2C0_INTSTAT_SCLTIMEOUT = 0x2000000
	// Position of RESERVED field.
	I2C0_INTSTAT_RESERVED_Pos = 0x1a
	// Bit mask of RESERVED field.
	I2C0_INTSTAT_RESERVED_Msk = 0xfc000000

	// MSTCTL: Master control register.
	// Position of MSTCONTINUE field.
	I2C0_MSTCTL_MSTCONTINUE_Pos = 0x0
	// Bit mask of MSTCONTINUE field.
	I2C0_MSTCTL_MSTCONTINUE_Msk = 0x1
	// Bit MSTCONTINUE.
	I2C0_MSTCTL_MSTCONTINUE = 0x1
	// No effect.
	I2C0_MSTCTL_MSTCONTINUE_NO_EFFECT = 0x0
	// Continue. Informs the Master function to continue to the next operation. This must done after writing transmit data, reading received data, or any other housekeeping related to the next bus operation.
	I2C0_MSTCTL_MSTCONTINUE_CONTINUE = 0x1
	// Position of MSTSTART field.
	I2C0_MSTCTL_MSTSTART_Pos = 0x1
	// Bit mask of MSTSTART field.
	I2C0_MSTCTL_MSTSTART_Msk = 0x2
	// Bit MSTSTART.
	I2C0_MSTCTL_MSTSTART = 0x2
	// No effect.
	I2C0_MSTCTL_MSTSTART_NO_EFFECT = 0x0
	// Start. A Start will be generated on the I2C bus at the next allowed time.
	I2C0_MSTCTL_MSTSTART_START = 0x1
	// Position of MSTSTOP field.
	I2C0_MSTCTL_MSTSTOP_Pos = 0x2
	// Bit mask of MSTSTOP field.
	I2C0_MSTCTL_MSTSTOP_Msk = 0x4
	// Bit MSTSTOP.
	I2C0_MSTCTL_MSTSTOP = 0x4
	// No effect.
	I2C0_MSTCTL_MSTSTOP_NO_EFFECT = 0x0
	// Stop. A Stop will be generated on the I2C bus at the next allowed time, preceded by a NACK to the slave if the master is receiving data from the slave (Master Receiver mode).
	I2C0_MSTCTL_MSTSTOP_STOP = 0x1
	// Position of MSTDMA field.
	I2C0_MSTCTL_MSTDMA_Pos = 0x3
	// Bit mask of MSTDMA field.
	I2C0_MSTCTL_MSTDMA_Msk = 0x8
	// Bit MSTDMA.
	I2C0_MSTCTL_MSTDMA = 0x8
	// Disable. No DMA requests are generated for master operation.
	I2C0_MSTCTL_MSTDMA_DISABLE = 0x0
	// Enable. A DMA request is generated for I2C master data operations. When this I2C master is generating Acknowledge bits in Master Receiver mode, the acknowledge is generated automatically.
	I2C0_MSTCTL_MSTDMA_ENABLE = 0x1
	// Position of RESERVED field.
	I2C0_MSTCTL_RESERVED_Pos = 0x4
	// Bit mask of RESERVED field.
	I2C0_MSTCTL_RESERVED_Msk = 0xfffffff0

	// MSTTIME: Master timing configuration.
	// Position of MSTSCLLOW field.
	I2C0_MSTTIME_MSTSCLLOW_Pos = 0x0
	// Bit mask of MSTSCLLOW field.
	I2C0_MSTTIME_MSTSCLLOW_Msk = 0x7
	// 2 clocks. Minimum SCL low time is 2 clocks of the I2C clock pre-divider.
	I2C0_MSTTIME_MSTSCLLOW_2_CLOCKS = 0x0
	// 3 clocks. Minimum SCL low time is 3 clocks of the I2C clock pre-divider.
	I2C0_MSTTIME_MSTSCLLOW_3_CLOCKS = 0x1
	// 4 clocks. Minimum SCL low time is 4 clocks of the I2C clock pre-divider.
	I2C0_MSTTIME_MSTSCLLOW_4_CLOCKS = 0x2
	// 5 clocks. Minimum SCL low time is 5 clocks of the I2C clock pre-divider.
	I2C0_MSTTIME_MSTSCLLOW_5_CLOCKS = 0x3
	// 6 clocks. Minimum SCL low time is 6 clocks of the I2C clock pre-divider.
	I2C0_MSTTIME_MSTSCLLOW_6_CLOCKS = 0x4
	// 7 clocks. Minimum SCL low time is 7 clocks of the I2C clock pre-divider.
	I2C0_MSTTIME_MSTSCLLOW_7_CLOCKS = 0x5
	// 8 clocks. Minimum SCL low time is 8 clocks of the I2C clock pre-divider.
	I2C0_MSTTIME_MSTSCLLOW_8_CLOCKS = 0x6
	// 9 clocks. Minimum SCL low time is 9 clocks of the I2C clock pre-divider.
	I2C0_MSTTIME_MSTSCLLOW_9_CLOCKS = 0x7
	// Position of RESERVED field.
	I2C0_MSTTIME_RESERVED_Pos = 0x3
	// Bit mask of RESERVED field.
	I2C0_MSTTIME_RESERVED_Msk = 0x8
	// Bit RESERVED.
	I2C0_MSTTIME_RESERVED = 0x8
	// Position of MSTSCLHIGH field.
	I2C0_MSTTIME_MSTSCLHIGH_Pos = 0x4
	// Bit mask of MSTSCLHIGH field.
	I2C0_MSTTIME_MSTSCLHIGH_Msk = 0x70
	// 2 clocks. Minimum SCL high time is 2 clock of the I2C clock pre-divider.
	I2C0_MSTTIME_MSTSCLHIGH_2_CLOCKS = 0x0
	// 3 clocks. Minimum SCL high time is 3 clocks of the I2C clock pre-divider .
	I2C0_MSTTIME_MSTSCLHIGH_3_CLOCKS = 0x1
	// 4 clocks. Minimum SCL high time is 4 clock of the I2C clock pre-divider.
	I2C0_MSTTIME_MSTSCLHIGH_4_CLOCKS = 0x2
	// 5 clocks. Minimum SCL high time is 5 clock of the I2C clock pre-divider.
	I2C0_MSTTIME_MSTSCLHIGH_5_CLOCKS = 0x3
	// 6 clocks. Minimum SCL high time is 6 clock of the I2C clock pre-divider.
	I2C0_MSTTIME_MSTSCLHIGH_6_CLOCKS = 0x4
	// 7 clocks. Minimum SCL high time is 7 clock of the I2C clock pre-divider.
	I2C0_MSTTIME_MSTSCLHIGH_7_CLOCKS = 0x5
	// 8 clocks. Minimum SCL high time is 8 clock of the I2C clock pre-divider.
	I2C0_MSTTIME_MSTSCLHIGH_8_CLOCKS = 0x6
	// 9 clocks. Minimum SCL high time is 9 clocks of the I2C clock pre-divider.
	I2C0_MSTTIME_MSTSCLHIGH_9_CLOCKS = 0x7
	// Position of RESERVED field.
	I2C0_MSTTIME_RESERVED_Pos = 0x7
	// Bit mask of RESERVED field.
	I2C0_MSTTIME_RESERVED_Msk = 0xffffff80

	// MSTDAT: Combined Master receiver and transmitter data register.
	// Position of DATA field.
	I2C0_MSTDAT_DATA_Pos = 0x0
	// Bit mask of DATA field.
	I2C0_MSTDAT_DATA_Msk = 0xff
	// Position of RESERVED field.
	I2C0_MSTDAT_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	I2C0_MSTDAT_RESERVED_Msk = 0xffffff00

	// SLVCTL: Slave control register.
	// Position of SLVCONTINUE field.
	I2C0_SLVCTL_SLVCONTINUE_Pos = 0x0
	// Bit mask of SLVCONTINUE field.
	I2C0_SLVCTL_SLVCONTINUE_Msk = 0x1
	// Bit SLVCONTINUE.
	I2C0_SLVCTL_SLVCONTINUE = 0x1
	// No effect.
	I2C0_SLVCTL_SLVCONTINUE_NO_EFFECT = 0x0
	// Continue. Informs the Slave function to continue to the next operation. This must be done after writing transmit data, reading received data, or any other housekeeping related to the next bus operation.
	I2C0_SLVCTL_SLVCONTINUE_CONTINUE = 0x1
	// Position of SLVNACK field.
	I2C0_SLVCTL_SLVNACK_Pos = 0x1
	// Bit mask of SLVNACK field.
	I2C0_SLVCTL_SLVNACK_Msk = 0x2
	// Bit SLVNACK.
	I2C0_SLVCTL_SLVNACK = 0x2
	// No effect.
	I2C0_SLVCTL_SLVNACK_NO_EFFECT = 0x0
	// NACK. Causes the Slave function to NACK the master when the slave is receiving data from the master (Slave Receiver mode).
	I2C0_SLVCTL_SLVNACK_NACK = 0x1
	// Position of SLVDMA field.
	I2C0_SLVCTL_SLVDMA_Pos = 0x3
	// Bit mask of SLVDMA field.
	I2C0_SLVCTL_SLVDMA_Msk = 0x8
	// Bit SLVDMA.
	I2C0_SLVCTL_SLVDMA = 0x8
	// Disabled. No DMA requests are issued for Slave mode operation.
	I2C0_SLVCTL_SLVDMA_DISABLED = 0x0
	// Enabled. DMA requests are issued for I2C slave data transmission and reception.
	I2C0_SLVCTL_SLVDMA_ENABLED = 0x1
	// Position of RESERVED field.
	I2C0_SLVCTL_RESERVED_Pos = 0x4
	// Bit mask of RESERVED field.
	I2C0_SLVCTL_RESERVED_Msk = 0xfffffff0

	// SLVDAT: Combined Slave receiver and transmitter data register.
	// Position of DATA field.
	I2C0_SLVDAT_DATA_Pos = 0x0
	// Bit mask of DATA field.
	I2C0_SLVDAT_DATA_Msk = 0xff
	// Position of RESERVED field.
	I2C0_SLVDAT_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	I2C0_SLVDAT_RESERVED_Msk = 0xffffff00

	// SLVADR0: Slave address 0.
	// Position of SADISABLE field.
	I2C0_SLVADR_SADISABLE_Pos = 0x0
	// Bit mask of SADISABLE field.
	I2C0_SLVADR_SADISABLE_Msk = 0x1
	// Bit SADISABLE.
	I2C0_SLVADR_SADISABLE = 0x1
	// Enabled. Slave Address n is enabled.
	I2C0_SLVADR_SADISABLE_ENABLED = 0x0
	// Ignored Slave Address n is ignored.
	I2C0_SLVADR_SADISABLE_IGNORED_SLAVE_ADDRES = 0x1
	// Position of SLVADR field.
	I2C0_SLVADR_SLVADR_Pos = 0x1
	// Bit mask of SLVADR field.
	I2C0_SLVADR_SLVADR_Msk = 0xfe
	// Position of RESERVED field.
	I2C0_SLVADR_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	I2C0_SLVADR_RESERVED_Msk = 0xffffff00

	// SLVQUAL0: Slave Qualification for address 0.
	// Position of QUALMODE0 field.
	I2C0_SLVQUAL0_QUALMODE0_Pos = 0x0
	// Bit mask of QUALMODE0 field.
	I2C0_SLVQUAL0_QUALMODE0_Msk = 0x1
	// Bit QUALMODE0.
	I2C0_SLVQUAL0_QUALMODE0 = 0x1
	// Mask. The SLVQUAL0 field is used as a logical mask for matching address 0.
	I2C0_SLVQUAL0_QUALMODE0_MASK = 0x0
	// Extend. The SLVQUAL0 field is used to extend address 0 matching in a range of addresses.
	I2C0_SLVQUAL0_QUALMODE0_EXTEND = 0x1
	// Position of SLVQUAL0 field.
	I2C0_SLVQUAL0_SLVQUAL0_Pos = 0x1
	// Bit mask of SLVQUAL0 field.
	I2C0_SLVQUAL0_SLVQUAL0_Msk = 0xfe
	// Position of RESERVED field.
	I2C0_SLVQUAL0_RESERVED_Pos = 0x8
	// Bit mask of RESERVED field.
	I2C0_SLVQUAL0_RESERVED_Msk = 0xffffff00

	// MONRXDAT: Monitor receiver data register.
	// Position of MONRXDAT field.
	I2C0_MONRXDAT_MONRXDAT_Pos = 0x0
	// Bit mask of MONRXDAT field.
	I2C0_MONRXDAT_MONRXDAT_Msk = 0xff
	// Position of MONSTART field.
	I2C0_MONRXDAT_MONSTART_Pos = 0x8
	// Bit mask of MONSTART field.
	I2C0_MONRXDAT_MONSTART_Msk = 0x100
	// Bit MONSTART.
	I2C0_MONRXDAT_MONSTART = 0x100
	// No start detected. The monitor function has not detected a Start event on the I2C bus.
	I2C0_MONRXDAT_MONSTART_NO_START_DETECTED = 0x0
	// Start detected. The monitor function has detected a Start event on the I2C bus.
	I2C0_MONRXDAT_MONSTART_START_DETECTED = 0x1
	// Position of MONRESTART field.
	I2C0_MONRXDAT_MONRESTART_Pos = 0x9
	// Bit mask of MONRESTART field.
	I2C0_MONRXDAT_MONRESTART_Msk = 0x200
	// Bit MONRESTART.
	I2C0_MONRXDAT_MONRESTART = 0x200
	// No repeated start detected. The monitor function has not detected a Repeated Start event on the I2C bus.
	I2C0_MONRXDAT_MONRESTART_NO_REPEATED_START_DE = 0x0
	// Repeated start detected. The monitor function has detected a Repeated Start event on the I2C bus.
	I2C0_MONRXDAT_MONRESTART_REPEATED_START_DETEC = 0x1
	// Position of MONNACK field.
	I2C0_MONRXDAT_MONNACK_Pos = 0xa
	// Bit mask of MONNACK field.
	I2C0_MONRXDAT_MONNACK_Msk = 0x400
	// Bit MONNACK.
	I2C0_MONRXDAT_MONNACK = 0x400
	// Acknowledged. The data currently being provided by the monitor function was acknowledged by at least one master or slave receiver.
	I2C0_MONRXDAT_MONNACK_ACKNOWLEDGED = 0x0
	// Not acknowledged. The data currently being provided by the monitor function was not acknowledged by any receiver.
	I2C0_MONRXDAT_MONNACK_NOT_ACKNOWLEDGED = 0x1
	// Position of RESERVED field.
	I2C0_MONRXDAT_RESERVED_Pos = 0xb
	// Bit mask of RESERVED field.
	I2C0_MONRXDAT_RESERVED_Msk = 0xfffff800
)

// Bitfields for SPI0: SPI0
const (
	// CFG: SPI Configuration register
	// Position of ENABLE field.
	SPI0_CFG_ENABLE_Pos = 0x0
	// Bit mask of ENABLE field.
	SPI0_CFG_ENABLE_Msk = 0x1
	// Bit ENABLE.
	SPI0_CFG_ENABLE = 0x1
	// Disabled. The SPI is disabled and the internal state machine and counters are reset.
	SPI0_CFG_ENABLE_DISABLED = 0x0
	// Enabled. The SPI is enabled for operation.
	SPI0_CFG_ENABLE_ENABLED = 0x1
	// Position of RESERVED field.
	SPI0_CFG_RESERVED_Pos = 0x1
	// Bit mask of RESERVED field.
	SPI0_CFG_RESERVED_Msk = 0x2
	// Bit RESERVED.
	SPI0_CFG_RESERVED = 0x2
	// Position of MASTER field.
	SPI0_CFG_MASTER_Pos = 0x2
	// Bit mask of MASTER field.
	SPI0_CFG_MASTER_Msk = 0x4
	// Bit MASTER.
	SPI0_CFG_MASTER = 0x4
	// Slave mode. The SPI will operate in slave mode. SCK, MOSI, and the SSEL signals are inputs, MISO is an output.
	SPI0_CFG_MASTER_SLAVE_MODE = 0x0
	// Master mode. The SPI will operate in master mode. SCK, MOSI, and the SSEL signals are outputs, MISO is an input.
	SPI0_CFG_MASTER_MASTER_MODE = 0x1
	// Position of LSBF field.
	SPI0_CFG_LSBF_Pos = 0x3
	// Bit mask of LSBF field.
	SPI0_CFG_LSBF_Msk = 0x8
	// Bit LSBF.
	SPI0_CFG_LSBF = 0x8
	// Standard. Data is transmitted and received in standard MSB first order.
	SPI0_CFG_LSBF_STANDARD = 0x0
	// Reverse. Data is transmitted and received in reverse order (LSB first).
	SPI0_CFG_LSBF_REVERSE = 0x1
	// Position of CPHA field.
	SPI0_CFG_CPHA_Pos = 0x4
	// Bit mask of CPHA field.
	SPI0_CFG_CPHA_Msk = 0x10
	// Bit CPHA.
	SPI0_CFG_CPHA = 0x10
	// Change. The SPI captures serial data on the first clock transition of the transfer (when the clock changes away from the rest state). Data is changed on the following edge.
	SPI0_CFG_CPHA_CHANGE = 0x0
	// Capture. The SPI changes serial data on the first clock transition of the transfer (when the clock changes away from the rest state). Data is captured on the following edge.
	SPI0_CFG_CPHA_CAPTURE = 0x1
	// Position of CPOL field.
	SPI0_CFG_CPOL_Pos = 0x5
	// Bit mask of CPOL field.
	SPI0_CFG_CPOL_Msk = 0x20
	// Bit CPOL.
	SPI0_CFG_CPOL = 0x20
	// Low. The rest state of the clock (between transfers) is low.
	SPI0_CFG_CPOL_LOW = 0x0
	// High. The rest state of the clock (between transfers) is high.
	SPI0_CFG_CPOL_HIGH = 0x1
	// Position of RESERVED field.
	SPI0_CFG_RESERVED_Pos = 0x6
	// Bit mask of RESERVED field.
	SPI0_CFG_RESERVED_Msk = 0x40
	// Bit RESERVED.
	SPI0_CFG_RESERVED = 0x40
	// Position of LOOP field.
	SPI0_CFG_LOOP_Pos = 0x7
	// Bit mask of LOOP field.
	SPI0_CFG_LOOP_Msk = 0x80
	// Bit LOOP.
	SPI0_CFG_LOOP = 0x80
	// Disabled.
	SPI0_CFG_LOOP_DISABLED = 0x0
	// Enabled.
	SPI0_CFG_LOOP_ENABLED = 0x1
	// Position of SPOL0 field.
	SPI0_CFG_SPOL0_Pos = 0x8
	// Bit mask of SPOL0 field.
	SPI0_CFG_SPOL0_Msk = 0x100
	// Bit SPOL0.
	SPI0_CFG_SPOL0 = 0x100
	// Low. The SSEL0 pin is active low. The value in the SSEL0 fields of the RXDAT, TXDATCTL, and TXCTL registers related to SSEL0 is not inverted relative to the pins.
	SPI0_CFG_SPOL0_LOW = 0x0
	// High. The SSEL0 pin is active high. The value in the SSEL0 fields of the RXDAT, TXDATCTL, and TXCTL registers related to SSEL0 is inverted relative to the pins.
	SPI0_CFG_SPOL0_HIGH = 0x1
	// Position of SPOL1 field.
	SPI0_CFG_SPOL1_Pos = 0x9
	// Bit mask of SPOL1 field.
	SPI0_CFG_SPOL1_Msk = 0x200
	// Bit SPOL1.
	SPI0_CFG_SPOL1 = 0x200
	// Low. The SSEL1 pin is active low. The value in the SSEL1 fields of the RXDAT, TXDATCTL, and TXCTL registers related to SSEL1 is not inverted relative to the pins.
	SPI0_CFG_SPOL1_LOW = 0x0
	// High. The SSEL1 pin is active high. The value in the SSEL1 fields of the RXDAT, TXDATCTL, and TXCTL registers related to SSEL1 is inverted relative to the pins.
	SPI0_CFG_SPOL1_HIGH = 0x1
	// Position of SPOL2 field.
	SPI0_CFG_SPOL2_Pos = 0xa
	// Bit mask of SPOL2 field.
	SPI0_CFG_SPOL2_Msk = 0x400
	// Bit SPOL2.
	SPI0_CFG_SPOL2 = 0x400
	// Low. The SSEL2 pin is active low. The value in the SSEL2 fields of the RXDAT, TXDATCTL, and TXCTL registers related to SSEL2 is not inverted relative to the pins.
	SPI0_CFG_SPOL2_LOW = 0x0
	// High. The SSEL2 pin is active high. The value in the SSEL2 fields of the RXDAT, TXDATCTL, and TXCTL registers related to SSEL2 is inverted relative to the pins.
	SPI0_CFG_SPOL2_HIGH = 0x1
	// Position of SPOL3 field.
	SPI0_CFG_SPOL3_Pos = 0xb
	// Bit mask of SPOL3 field.
	SPI0_CFG_SPOL3_Msk = 0x800
	// Bit SPOL3.
	SPI0_CFG_SPOL3 = 0x800
	// Low. The SSEL3 pin is active low. The value in the SSEL3 fields of the RXDAT, TXDATCTL, and TXCTL registers related to SSEL3 is not inverted relative to the pins.
	SPI0_CFG_SPOL3_LOW = 0x0
	// High. The SSEL3 pin is active high. The value in the SSEL3 fields of the RXDAT, TXDATCTL, and TXCTL registers related to SSEL3 is inverted relative to the pins.
	SPI0_CFG_SPOL3_HIGH = 0x1
	// Position of RESERVED field.
	SPI0_CFG_RESERVED_Pos = 0xc
	// Bit mask of RESERVED field.
	SPI0_CFG_RESERVED_Msk = 0xfffff000

	// DLY: SPI Delay register
	// Position of PRE_DELAY field.
	SPI0_DLY_PRE_DELAY_Pos = 0x0
	// Bit mask of PRE_DELAY field.
	SPI0_DLY_PRE_DELAY_Msk = 0xf
	// Position of POST_DELAY field.
	SPI0_DLY_POST_DELAY_Pos = 0x4
	// Bit mask of POST_DELAY field.
	SPI0_DLY_POST_DELAY_Msk = 0xf0
	// Position of FRAME_DELAY field.
	SPI0_DLY_FRAME_DELAY_Pos = 0x8
	// Bit mask of FRAME_DELAY field.
	SPI0_DLY_FRAME_DELAY_Msk = 0xf00
	// Position of TRANSFER_DELAY field.
	SPI0_DLY_TRANSFER_DELAY_Pos = 0xc
	// Bit mask of TRANSFER_DELAY field.
	SPI0_DLY_TRANSFER_DELAY_Msk = 0xf000
	// Position of RESERVED field.
	SPI0_DLY_RESERVED_Pos = 0x10
	// Bit mask of RESERVED field.
	SPI0_DLY_RESERVED_Msk = 0xffff0000

	// STAT: SPI Status. Some status flags can be cleared by writing a 1 to that bit position
	// Position of RXRDY field.
	SPI0_STAT_RXRDY_Pos = 0x0
	// Bit mask of RXRDY field.
	SPI0_STAT_RXRDY_Msk = 0x1
	// Bit RXRDY.
	SPI0_STAT_RXRDY = 0x1
	// Position of TXRDY field.
	SPI0_STAT_TXRDY_Pos = 0x1
	// Bit mask of TXRDY field.
	SPI0_STAT_TXRDY_Msk = 0x2
	// Bit TXRDY.
	SPI0_STAT_TXRDY = 0x2
	// Position of RXOV field.
	SPI0_STAT_RXOV_Pos = 0x2
	// Bit mask of RXOV field.
	SPI0_STAT_RXOV_Msk = 0x4
	// Bit RXOV.
	SPI0_STAT_RXOV = 0x4
	// Position of TXUR field.
	SPI0_STAT_TXUR_Pos = 0x3
	// Bit mask of TXUR field.
	SPI0_STAT_TXUR_Msk = 0x8
	// Bit TXUR.
	SPI0_STAT_TXUR = 0x8
	// Position of SSA field.
	SPI0_STAT_SSA_Pos = 0x4
	// Bit mask of SSA field.
	SPI0_STAT_SSA_Msk = 0x10
	// Bit SSA.
	SPI0_STAT_SSA = 0x10
	// Position of SSD field.
	SPI0_STAT_SSD_Pos = 0x5
	// Bit mask of SSD field.
	SPI0_STAT_SSD_Msk = 0x20
	// Bit SSD.
	SPI0_STAT_SSD = 0x20
	// Position of STALLED field.
	SPI0_STAT_STALLED_Pos = 0x6
	// Bit mask of STALLED field.
	SPI0_STAT_STALLED_Msk = 0x40
	// Bit STALLED.
	SPI0_STAT_STALLED = 0x40
	// Position of ENDTRANSFER field.
	SPI0_STAT_ENDTRANSFER_Pos = 0x7
	// Bit mask of ENDTRANSFER field.
	SPI0_STAT_ENDTRANSFER_Msk = 0x80
	// Bit ENDTRANSFER.
	SPI0_STAT_ENDTRANSFER = 0x80
	// Position of MSTIDLE field.
	SPI0_STAT_MSTIDLE_Pos = 0x8
	// Bit mask of MSTIDLE field.
	SPI0_STAT_MSTIDLE_Msk = 0x100
	// Bit MSTIDLE.
	SPI0_STAT_MSTIDLE = 0x100
	// Position of RESERVED field.
	SPI0_STAT_RESERVED_Pos = 0x9
	// Bit mask of RESERVED field.
	SPI0_STAT_RESERVED_Msk = 0xfffffe00

	// INTENSET: SPI Interrupt Enable read and Set. A complete value may be read from this register. Writing a 1 to any implemented bit position causes that bit to be set.
	// Position of RXRDYEN field.
	SPI0_INTENSET_RXRDYEN_Pos = 0x0
	// Bit mask of RXRDYEN field.
	SPI0_INTENSET_RXRDYEN_Msk = 0x1
	// Bit RXRDYEN.
	SPI0_INTENSET_RXRDYEN = 0x1
	// Disabled. No interrupt will be generated when receiver data is available.
	SPI0_INTENSET_RXRDYEN_DISABLED = 0x0
	// Enabled. An interrupt will be generated when receiver data is available in the RXDAT register.
	SPI0_INTENSET_RXRDYEN_ENABLED = 0x1
	// Position of TXRDYEN field.
	SPI0_INTENSET_TXRDYEN_Pos = 0x1
	// Bit mask of TXRDYEN field.
	SPI0_INTENSET_TXRDYEN_Msk = 0x2
	// Bit TXRDYEN.
	SPI0_INTENSET_TXRDYEN = 0x2
	// Disabled. No interrupt will be generated when the transmitter holding register is available.
	SPI0_INTENSET_TXRDYEN_DISABLED = 0x0
	// Enabled. An interrupt will be generated when data may be written to TXDAT.
	SPI0_INTENSET_TXRDYEN_ENABLED = 0x1
	// Position of RXOVEN field.
	SPI0_INTENSET_RXOVEN_Pos = 0x2
	// Bit mask of RXOVEN field.
	SPI0_INTENSET_RXOVEN_Msk = 0x4
	// Bit RXOVEN.
	SPI0_INTENSET_RXOVEN = 0x4
	// Disabled. No interrupt will be generated when a receiver overrun occurs.
	SPI0_INTENSET_RXOVEN_DISABLED = 0x0
	// Enabled. An interrupt will be generated if a receiver overrun occurs.
	SPI0_INTENSET_RXOVEN_ENABLED = 0x1
	// Position of TXUREN field.
	SPI0_INTENSET_TXUREN_Pos = 0x3
	// Bit mask of TXUREN field.
	SPI0_INTENSET_TXUREN_Msk = 0x8
	// Bit TXUREN.
	SPI0_INTENSET_TXUREN = 0x8
	// Disabled. No interrupt will be generated when the transmitter underruns.
	SPI0_INTENSET_TXUREN_DISABLED = 0x0
	// Enabled. An interrupt will be generated if the transmitter underruns.
	SPI0_INTENSET_TXUREN_ENABLED = 0x1
	// Position of SSAEN field.
	SPI0_INTENSET_SSAEN_Pos = 0x4
	// Bit mask of SSAEN field.
	SPI0_INTENSET_SSAEN_Msk = 0x10
	// Bit SSAEN.
	SPI0_INTENSET_SSAEN = 0x10
	// Disabled. No interrupt will be generated when any Slave Select transitions from deasserted to asserted.
	SPI0_INTENSET_SSAEN_DISABLED = 0x0
	// Enabled. An interrupt will be generated when any Slave Select transitions from deasserted to asserted.
	SPI0_INTENSET_SSAEN_ENABLED = 0x1
	// Position of SSDEN field.
	SPI0_INTENSET_SSDEN_Pos = 0x5
	// Bit mask of SSDEN field.
	SPI0_INTENSET_SSDEN_Msk = 0x20
	// Bit SSDEN.
	SPI0_INTENSET_SSDEN = 0x20
	// Disabled. No interrupt will be generated when all asserted Slave Selects transition to deasserted.
	SPI0_INTENSET_SSDEN_DISABLED = 0x0
	// Enabled. An interrupt will be generated when all asserted Slave Selects transition to deasserted.
	SPI0_INTENSET_SSDEN_ENABLED = 0x1
	// Position of RESERVED field.
	SPI0_INTENSET_RESERVED_Pos = 0x6
	// Bit mask of RESERVED field.
	SPI0_INTENSET_RESERVED_Msk = 0xc0
	// Position of MSTIDLEEN field.
	SPI0_INTENSET_MSTIDLEEN_Pos = 0x8
	// Bit mask of MSTIDLEEN field.
	SPI0_INTENSET_MSTIDLEEN_Msk = 0x100
	// Bit MSTIDLEEN.
	SPI0_INTENSET_MSTIDLEEN = 0x100
	// Disabled. No interrupt will be generated when the SPI master function is idle.
	SPI0_INTENSET_MSTIDLEEN_DISABLED = 0x0
	// Enabled. An interrupt will be generated when the SPI master function is idle.
	SPI0_INTENSET_MSTIDLEEN_ENABLED = 0x1
	// Position of RESERVED field.
	SPI0_INTENSET_RESERVED_Pos = 0x9
	// Bit mask of RESERVED field.
	SPI0_INTENSET_RESERVED_Msk = 0xfffffe00

	// INTENCLR: SPI Interrupt Enable Clear. Writing a 1 to any implemented bit position causes the corresponding bit in INTENSET to be cleared.
	// Position of RXRDYEN field.
	SPI0_INTENCLR_RXRDYEN_Pos = 0x0
	// Bit mask of RXRDYEN field.
	SPI0_INTENCLR_RXRDYEN_Msk = 0x1
	// Bit RXRDYEN.
	SPI0_INTENCLR_RXRDYEN = 0x1
	// Position of TXRDYEN field.
	SPI0_INTENCLR_TXRDYEN_Pos = 0x1
	// Bit mask of TXRDYEN field.
	SPI0_INTENCLR_TXRDYEN_Msk = 0x2
	// Bit TXRDYEN.
	SPI0_INTENCLR_TXRDYEN = 0x2
	// Position of RXOVEN field.
	SPI0_INTENCLR_RXOVEN_Pos = 0x2
	// Bit mask of RXOVEN field.
	SPI0_INTENCLR_RXOVEN_Msk = 0x4
	// Bit RXOVEN.
	SPI0_INTENCLR_RXOVEN = 0x4
	// Position of TXUREN field.
	SPI0_INTENCLR_TXUREN_Pos = 0x3
	// Bit mask of TXUREN field.
	SPI0_INTENCLR_TXUREN_Msk = 0x8
	// Bit TXUREN.
	SPI0_INTENCLR_TXUREN = 0x8
	// Position of SSAEN field.
	SPI0_INTENCLR_SSAEN_Pos = 0x4
	// Bit mask of SSAEN field.
	SPI0_INTENCLR_SSAEN_Msk = 0x10
	// Bit SSAEN.
	SPI0_INTENCLR_SSAEN = 0x10
	// Position of SSDEN field.
	SPI0_INTENCLR_SSDEN_Pos = 0x5
	// Bit mask of SSDEN field.
	SPI0_INTENCLR_SSDEN_Msk = 0x20
	// Bit SSDEN.
	SPI0_INTENCLR_SSDEN = 0x20
	// Position of RESERVED field.
	SPI0_INTENCLR_RESERVED_Pos = 0x6
	// Bit mask of RESERVED field.
	SPI0_INTENCLR_RESERVED_Msk = 0xc0
	// Position of MSTIDLE field.
	SPI0_INTENCLR_MSTIDLE_Pos = 0x8
	// Bit mask of MSTIDLE field.
	SPI0_INTENCLR_MSTIDLE_Msk = 0x100
	// Bit MSTIDLE.
	SPI0_INTENCLR_MSTIDLE = 0x100
	// Position of RESERVED field.
	SPI0_INTENCLR_RESERVED_Pos = 0x9
	// Bit mask of RESERVED field.
	SPI0_INTENCLR_RESERVED_Msk = 0xfffffe00

	// RXDAT: SPI Receive Data
	// Position of RXDAT field.
	SPI0_RXDAT_RXDAT_Pos = 0x0
	// Bit mask of RXDAT field.
	SPI0_RXDAT_RXDAT_Msk = 0xffff
	// Position of RXSSEL0_N field.
	SPI0_RXDAT_RXSSEL0_N_Pos = 0x10
	// Bit mask of RXSSEL0_N field.
	SPI0_RXDAT_RXSSEL0_N_Msk = 0x10000
	// Bit RXSSEL0_N.
	SPI0_RXDAT_RXSSEL0_N = 0x10000
	// Position of RXSSEL1_N field.
	SPI0_RXDAT_RXSSEL1_N_Pos = 0x11
	// Bit mask of RXSSEL1_N field.
	SPI0_RXDAT_RXSSEL1_N_Msk = 0x20000
	// Bit RXSSEL1_N.
	SPI0_RXDAT_RXSSEL1_N = 0x20000
	// Position of RXSSEL2_N field.
	SPI0_RXDAT_RXSSEL2_N_Pos = 0x12
	// Bit mask of RXSSEL2_N field.
	SPI0_RXDAT_RXSSEL2_N_Msk = 0x40000
	// Bit RXSSEL2_N.
	SPI0_RXDAT_RXSSEL2_N = 0x40000
	// Position of RXSSEL3_N field.
	SPI0_RXDAT_RXSSEL3_N_Pos = 0x13
	// Bit mask of RXSSEL3_N field.
	SPI0_RXDAT_RXSSEL3_N_Msk = 0x80000
	// Bit RXSSEL3_N.
	SPI0_RXDAT_RXSSEL3_N = 0x80000
	// Position of SOT field.
	SPI0_RXDAT_SOT_Pos = 0x14
	// Bit mask of SOT field.
	SPI0_RXDAT_SOT_Msk = 0x100000
	// Bit SOT.
	SPI0_RXDAT_SOT = 0x100000
	// Position of RESERVED field.
	SPI0_RXDAT_RESERVED_Pos = 0x15
	// Bit mask of RESERVED field.
	SPI0_RXDAT_RESERVED_Msk = 0xffe00000

	// TXDATCTL: SPI Transmit Data with Control
	// Position of TXDAT field.
	SPI0_TXDATCTL_TXDAT_Pos = 0x0
	// Bit mask of TXDAT field.
	SPI0_TXDATCTL_TXDAT_Msk = 0xffff
	// Position of TXSSEL0_N field.
	SPI0_TXDATCTL_TXSSEL0_N_Pos = 0x10
	// Bit mask of TXSSEL0_N field.
	SPI0_TXDATCTL_TXSSEL0_N_Msk = 0x10000
	// Bit TXSSEL0_N.
	SPI0_TXDATCTL_TXSSEL0_N = 0x10000
	// SSEL0 asserted.
	SPI0_TXDATCTL_TXSSEL0_N_SSEL0_ASSERTED = 0x0
	// SSEL0 not asserted.
	SPI0_TXDATCTL_TXSSEL0_N_SSEL0_NOT_ASSERTED = 0x1
	// Position of TXSSEL1_N field.
	SPI0_TXDATCTL_TXSSEL1_N_Pos = 0x11
	// Bit mask of TXSSEL1_N field.
	SPI0_TXDATCTL_TXSSEL1_N_Msk = 0x20000
	// Bit TXSSEL1_N.
	SPI0_TXDATCTL_TXSSEL1_N = 0x20000
	// SSEL1 asserted.
	SPI0_TXDATCTL_TXSSEL1_N_SSEL1_ASSERTED = 0x0
	// SSEL1 not asserted.
	SPI0_TXDATCTL_TXSSEL1_N_SSEL1_NOT_ASSERTED = 0x1
	// Position of TXSSEL2_N field.
	SPI0_TXDATCTL_TXSSEL2_N_Pos = 0x12
	// Bit mask of TXSSEL2_N field.
	SPI0_TXDATCTL_TXSSEL2_N_Msk = 0x40000
	// Bit TXSSEL2_N.
	SPI0_TXDATCTL_TXSSEL2_N = 0x40000
	// SSEL2 asserted.
	SPI0_TXDATCTL_TXSSEL2_N_SSEL2_ASSERTED = 0x0
	// SSEL2 not asserted.
	SPI0_TXDATCTL_TXSSEL2_N_SSEL2_NOT_ASSERTED = 0x1
	// Position of TXSSEL3_N field.
	SPI0_TXDATCTL_TXSSEL3_N_Pos = 0x13
	// Bit mask of TXSSEL3_N field.
	SPI0_TXDATCTL_TXSSEL3_N_Msk = 0x80000
	// Bit TXSSEL3_N.
	SPI0_TXDATCTL_TXSSEL3_N = 0x80000
	// SSEL3 asserted.
	SPI0_TXDATCTL_TXSSEL3_N_SSEL3_ASSERTED = 0x0
	// SSEL3 not asserted.
	SPI0_TXDATCTL_TXSSEL3_N_SSEL3_NOT_ASSERTED = 0x1
	// Position of EOT field.
	SPI0_TXDATCTL_EOT_Pos = 0x14
	// Bit mask of EOT field.
	SPI0_TXDATCTL_EOT_Msk = 0x100000
	// Bit EOT.
	SPI0_TXDATCTL_EOT = 0x100000
	// SSEL not deasserted. This piece of data is not treated as the end of a transfer. SSEL will not be deasserted at the end of this data.
	SPI0_TXDATCTL_EOT_SSEL_NOT_DEASSERTED = 0x0
	// SSEL deasserted. This piece of data is treated as the end of a transfer. SSEL will be deasserted at the end of this piece of data.
	SPI0_TXDATCTL_EOT_SSEL_DEASSERTED = 0x1
	// Position of EOF field.
	SPI0_TXDATCTL_EOF_Pos = 0x15
	// Bit mask of EOF field.
	SPI0_TXDATCTL_EOF_Msk = 0x200000
	// Bit EOF.
	SPI0_TXDATCTL_EOF = 0x200000
	// Data not EOF. This piece of data transmitted is not treated as the end of a frame.
	SPI0_TXDATCTL_EOF_DATA_NOT_EOF = 0x0
	// Data EOF. This piece of data is treated as the end of a frame, causing the FRAME_DELAY time to be inserted before subsequent data is transmitted.
	SPI0_TXDATCTL_EOF_DATA_EOF = 0x1
	// Position of RXIGNORE field.
	SPI0_TXDATCTL_RXIGNORE_Pos = 0x16
	// Bit mask of RXIGNORE field.
	SPI0_TXDATCTL_RXIGNORE_Msk = 0x400000
	// Bit RXIGNORE.
	SPI0_TXDATCTL_RXIGNORE = 0x400000
	// Read received data. Received data must be read in order to allow transmission to progress. In slave mode, an overrun error will occur if received data is not read before new data is received.
	SPI0_TXDATCTL_RXIGNORE_READ_RECEIVED_DATA = 0x0
	// Ignore received data. Received data is ignored, allowing transmission without reading unneeded received data. No receiver flags are generated.
	SPI0_TXDATCTL_RXIGNORE_IGNORE_RECEIVED_DATA = 0x1
	// Position of RESERVED field.
	SPI0_TXDATCTL_RESERVED_Pos = 0x17
	// Bit mask of RESERVED field.
	SPI0_TXDATCTL_RESERVED_Msk = 0x800000
	// Bit RESERVED.
	SPI0_TXDATCTL_RESERVED = 0x800000
	// Position of LEN field.
	SPI0_TXDATCTL_LEN_Pos = 0x18
	// Bit mask of LEN field.
	SPI0_TXDATCTL_LEN_Msk = 0xf000000
	// Position of RESERVED field.
	SPI0_TXDATCTL_RESERVED_Pos = 0x1c
	// Bit mask of RESERVED field.
	SPI0_TXDATCTL_RESERVED_Msk = 0xf0000000

	// TXDAT: SPI Transmit Data
	// Position of DATA field.
	SPI0_TXDAT_DATA_Pos = 0x0
	// Bit mask of DATA field.
	SPI0_TXDAT_DATA_Msk = 0xffff
	// Position of RESERVED field.
	SPI0_TXDAT_RESERVED_Pos = 0x10
	// Bit mask of RESERVED field.
	SPI0_TXDAT_RESERVED_Msk = 0xffff0000

	// TXCTL: SPI Transmit Control
	// Position of RESERVED field.
	SPI0_TXCTL_RESERVED_Pos = 0x0
	// Bit mask of RESERVED field.
	SPI0_TXCTL_RESERVED_Msk = 0xffff
	// Position of TXSSEL0_N field.
	SPI0_TXCTL_TXSSEL0_N_Pos = 0x10
	// Bit mask of TXSSEL0_N field.
	SPI0_TXCTL_TXSSEL0_N_Msk = 0x10000
	// Bit TXSSEL0_N.
	SPI0_TXCTL_TXSSEL0_N = 0x10000
	// Position of TXSSEL1_N field.
	SPI0_TXCTL_TXSSEL1_N_Pos = 0x11
	// Bit mask of TXSSEL1_N field.
	SPI0_TXCTL_TXSSEL1_N_Msk = 0x20000
	// Bit TXSSEL1_N.
	SPI0_TXCTL_TXSSEL1_N = 0x20000
	// Position of TXSSEL2_N field.
	SPI0_TXCTL_TXSSEL2_N_Pos = 0x12
	// Bit mask of TXSSEL2_N field.
	SPI0_TXCTL_TXSSEL2_N_Msk = 0x40000
	// Bit TXSSEL2_N.
	SPI0_TXCTL_TXSSEL2_N = 0x40000
	// Position of TXSSEL3_n field.
	SPI0_TXCTL_TXSSEL3_n_Pos = 0x13
	// Bit mask of TXSSEL3_n field.
	SPI0_TXCTL_TXSSEL3_n_Msk = 0x80000
	// Bit TXSSEL3_n.
	SPI0_TXCTL_TXSSEL3_n = 0x80000
	// Position of EOT field.
	SPI0_TXCTL_EOT_Pos = 0x14
	// Bit mask of EOT field.
	SPI0_TXCTL_EOT_Msk = 0x100000
	// Bit EOT.
	SPI0_TXCTL_EOT = 0x100000
	// Position of EOF field.
	SPI0_TXCTL_EOF_Pos = 0x15
	// Bit mask of EOF field.
	SPI0_TXCTL_EOF_Msk = 0x200000
	// Bit EOF.
	SPI0_TXCTL_EOF = 0x200000
	// Position of RXIGNORE field.
	SPI0_TXCTL_RXIGNORE_Pos = 0x16
	// Bit mask of RXIGNORE field.
	SPI0_TXCTL_RXIGNORE_Msk = 0x400000
	// Bit RXIGNORE.
	SPI0_TXCTL_RXIGNORE = 0x400000
	// Position of RESERVED field.
	SPI0_TXCTL_RESERVED_Pos = 0x17
	// Bit mask of RESERVED field.
	SPI0_TXCTL_RESERVED_Msk = 0x800000
	// Bit RESERVED.
	SPI0_TXCTL_RESERVED = 0x800000
	// Position of LEN field.
	SPI0_TXCTL_LEN_Pos = 0x18
	// Bit mask of LEN field.
	SPI0_TXCTL_LEN_Msk = 0xf000000
	// Position of RESERVED field.
	SPI0_TXCTL_RESERVED_Pos = 0x1c
	// Bit mask of RESERVED field.
	SPI0_TXCTL_RESERVED_Msk = 0xf0000000

	// DIV: SPI clock Divider
	// Position of DIVVAL field.
	SPI0_DIV_DIVVAL_Pos = 0x0
	// Bit mask of DIVVAL field.
	SPI0_DIV_DIVVAL_Msk = 0xffff
	// Position of RESERVED field.
	SPI0_DIV_RESERVED_Pos = 0x10
	// Bit mask of RESERVED field.
	SPI0_DIV_RESERVED_Msk = 0xffff0000

	// INTSTAT: SPI Interrupt Status
	// Position of RXRDY field.
	SPI0_INTSTAT_RXRDY_Pos = 0x0
	// Bit mask of RXRDY field.
	SPI0_INTSTAT_RXRDY_Msk = 0x1
	// Bit RXRDY.
	SPI0_INTSTAT_RXRDY = 0x1
	// Position of TXRDY field.
	SPI0_INTSTAT_TXRDY_Pos = 0x1
	// Bit mask of TXRDY field.
	SPI0_INTSTAT_TXRDY_Msk = 0x2
	// Bit TXRDY.
	SPI0_INTSTAT_TXRDY = 0x2
	// Position of RXOV field.
	SPI0_INTSTAT_RXOV_Pos = 0x2
	// Bit mask of RXOV field.
	SPI0_INTSTAT_RXOV_Msk = 0x4
	// Bit RXOV.
	SPI0_INTSTAT_RXOV = 0x4
	// Position of TXUR field.
	SPI0_INTSTAT_TXUR_Pos = 0x3
	// Bit mask of TXUR field.
	SPI0_INTSTAT_TXUR_Msk = 0x8
	// Bit TXUR.
	SPI0_INTSTAT_TXUR = 0x8
	// Position of SSA field.
	SPI0_INTSTAT_SSA_Pos = 0x4
	// Bit mask of SSA field.
	SPI0_INTSTAT_SSA_Msk = 0x10
	// Bit SSA.
	SPI0_INTSTAT_SSA = 0x10
	// Position of SSD field.
	SPI0_INTSTAT_SSD_Pos = 0x5
	// Bit mask of SSD field.
	SPI0_INTSTAT_SSD_Msk = 0x20
	// Bit SSD.
	SPI0_INTSTAT_SSD = 0x20
	// Position of RESERVED field.
	SPI0_INTSTAT_RESERVED_Pos = 0x6
	// Bit mask of RESERVED field.
	SPI0_INTSTAT_RESERVED_Msk = 0xc0
	// Position of MSTIDLE field.
	SPI0_INTSTAT_MSTIDLE_Pos = 0x8
	// Bit mask of MSTIDLE field.
	SPI0_INTSTAT_MSTIDLE_Msk = 0x100
	// Bit MSTIDLE.
	SPI0_INTSTAT_MSTIDLE = 0x100
	// Position of RESERVED field.
	SPI0_INTSTAT_RESERVED_Pos = 0x9
	// Bit mask of RESERVED field.
	SPI0_INTSTAT_RESERVED_Msk = 0xfffffe00
)
