// Automatically generated file. DO NOT EDIT.
// Generated by gen-device-svd.go from stm32f302.svd, see https://github.com/tinygo-org/stm32-svd

//go:build stm32 && stm32f302
// +build stm32,stm32f302

// STM32F302
//

package stm32

import (
	"runtime/volatile"
	"unsafe"
)

// Some information about this device.
const (
	Device       = "STM32F302"
	CPU          = "CM4"
	FPUPresent   = false
	NVICPrioBits = 4
)

// Interrupt numbers.
const (
	// Window watchdog
	IRQ_WWDG = 0

	// Power control
	IRQ_PVD = 1

	// External interrupt/event controller
	IRQ_TAMP_STAMP = 2

	// Real-time clock
	IRQ_RTC_WKUP = 3

	// Flash
	IRQ_FLASH = 4

	// Reset and clock control
	IRQ_RCC = 5

	// External interrupt/event controller
	IRQ_EXTI0 = 6

	// External interrupt/event controller
	IRQ_EXTI1 = 7

	// Touch sensing controller // External interrupt/event controller
	IRQ_EXTI2_TSC = 8

	// External interrupt/event controller
	IRQ_EXTI3 = 9

	// External interrupt/event controller
	IRQ_EXTI4 = 10

	// DMA controller 1
	IRQ_DMA1_CH1 = 11

	// DMA controller 1
	IRQ_DMA1_CH2 = 12

	// DMA controller 1
	IRQ_DMA1_CH3 = 13

	// DMA controller 1
	IRQ_DMA1_CH4 = 14

	// DMA controller 1
	IRQ_DMA1_CH5 = 15

	// DMA controller 1
	IRQ_DMA1_CH6 = 16

	// DMA controller 1
	IRQ_DMA1_CH7 = 17

	// Analog-to-Digital Converter //
	IRQ_ADC1_2 = 18

	// Controller area network
	IRQ_USB_HP_CAN_TX = 19

	// Controller area network
	IRQ_USB_LP_CAN_RX0 = 20

	// Controller area network
	IRQ_CAN_RX1 = 21

	// Controller area network
	IRQ_CAN_SCE = 22

	// External interrupt/event controller
	IRQ_EXTI9_5 = 23

	// General purpose timers
	IRQ_TIM1_BRK_TIM15 = 24

	// General-purpose-timers
	IRQ_TIM1_UP_TIM16 = 25

	// General purpose timer
	IRQ_TIM1_TRG_COM_TIM17 = 26

	// Advanced timer //
	IRQ_TIM1_CC = 27

	// General purpose timer
	IRQ_TIM2 = 28

	// General purpose timer
	IRQ_TIM3 = 29

	// General purpose timer
	IRQ_TIM4 = 30

	// External interrupt/event controller // Inter-integrated circuit
	IRQ_I2C1_EV_EXTI23 = 31

	// Inter-integrated circuit
	IRQ_I2C1_ER = 32

	IRQ_I2C2_EV_EXTI24 = 33

	IRQ_I2C2_ER = 34

	// Serial peripheral interface/Inter-IC sound
	IRQ_SPI1 = 35

	IRQ_SPI2 = 36

	// Universal synchronous asynchronous receiver transmitter // External interrupt/event controller
	IRQ_USART1_EXTI25 = 37

	// External interrupt/event controller //
	IRQ_USART2_EXTI26 = 38

	// External interrupt/event controller //
	IRQ_USART3_EXTI28 = 39

	// External interrupt/event controller
	IRQ_EXTI15_10 = 40

	// Real-time clock
	IRQ_RTCAlarm = 41

	// Universal serial bus full-speed device interface
	IRQ_USB_WKUP = 42

	// Advanced-timers
	IRQ_TIM8_BRK = 43

	// Advanced-timers
	IRQ_TIM8_UP = 44

	// Advanced-timers
	IRQ_TIM8_TRG_COM = 45

	// Advanced-timers
	IRQ_TIM8_CC = 46

	// Flexible memory controller
	IRQ_FMC = 48

	IRQ_SPI3 = 51

	// External interrupt/event controller //
	IRQ_UART4_EXTI34 = 52

	// External interrupt/event controller //
	IRQ_UART5_EXTI35 = 53

	// Basic timers // Digital-to-analog converter
	IRQ_TIM6_DACUNDER = 54

	IRQ_TIM7 = 55

	IRQ_DMA2_CH1 = 56

	IRQ_DMA2_CH2 = 57

	IRQ_DMA2_CH3 = 58

	IRQ_DMA2_CH4 = 59

	IRQ_DMA2_CH5 = 60

	// General purpose comparators
	IRQ_COMP1_2_3 = 64

	// General purpose comparators
	IRQ_COMP4_5_6 = 65

	// Universal serial bus full-speed device interface
	IRQ_USB_HP = 74

	// Universal serial bus full-speed device interface
	IRQ_USB_LP = 75

	// External interrupt/event controller
	IRQ_USB_WKUP_EXTI = 76

	// Floting point unit
	IRQ_FPU = 81

	// Highest interrupt number on this device.
	IRQ_max = 81
)

// Pseudo function call that is replaced by the compiler with the actual
// functions registered through interrupt.New.
//go:linkname callHandlers runtime/interrupt.callHandlers
func callHandlers(num int)

//export WWDG_IRQHandler
func interruptWWDG() {
	callHandlers(IRQ_WWDG)
}

//export PVD_IRQHandler
func interruptPVD() {
	callHandlers(IRQ_PVD)
}

//export TAMP_STAMP_IRQHandler
func interruptTAMP_STAMP() {
	callHandlers(IRQ_TAMP_STAMP)
}

//export RTC_WKUP_IRQHandler
func interruptRTC_WKUP() {
	callHandlers(IRQ_RTC_WKUP)
}

//export FLASH_IRQHandler
func interruptFLASH() {
	callHandlers(IRQ_FLASH)
}

//export RCC_IRQHandler
func interruptRCC() {
	callHandlers(IRQ_RCC)
}

//export EXTI0_IRQHandler
func interruptEXTI0() {
	callHandlers(IRQ_EXTI0)
}

//export EXTI1_IRQHandler
func interruptEXTI1() {
	callHandlers(IRQ_EXTI1)
}

//export EXTI2_TSC_IRQHandler
func interruptEXTI2_TSC() {
	callHandlers(IRQ_EXTI2_TSC)
}

//export EXTI3_IRQHandler
func interruptEXTI3() {
	callHandlers(IRQ_EXTI3)
}

//export EXTI4_IRQHandler
func interruptEXTI4() {
	callHandlers(IRQ_EXTI4)
}

//export DMA1_CH1_IRQHandler
func interruptDMA1_CH1() {
	callHandlers(IRQ_DMA1_CH1)
}

//export DMA1_CH2_IRQHandler
func interruptDMA1_CH2() {
	callHandlers(IRQ_DMA1_CH2)
}

//export DMA1_CH3_IRQHandler
func interruptDMA1_CH3() {
	callHandlers(IRQ_DMA1_CH3)
}

//export DMA1_CH4_IRQHandler
func interruptDMA1_CH4() {
	callHandlers(IRQ_DMA1_CH4)
}

//export DMA1_CH5_IRQHandler
func interruptDMA1_CH5() {
	callHandlers(IRQ_DMA1_CH5)
}

//export DMA1_CH6_IRQHandler
func interruptDMA1_CH6() {
	callHandlers(IRQ_DMA1_CH6)
}

//export DMA1_CH7_IRQHandler
func interruptDMA1_CH7() {
	callHandlers(IRQ_DMA1_CH7)
}

//export ADC1_2_IRQHandler
func interruptADC1_2() {
	callHandlers(IRQ_ADC1_2)
}

//export USB_HP_CAN_TX_IRQHandler
func interruptUSB_HP_CAN_TX() {
	callHandlers(IRQ_USB_HP_CAN_TX)
}

//export USB_LP_CAN_RX0_IRQHandler
func interruptUSB_LP_CAN_RX0() {
	callHandlers(IRQ_USB_LP_CAN_RX0)
}

//export CAN_RX1_IRQHandler
func interruptCAN_RX1() {
	callHandlers(IRQ_CAN_RX1)
}

//export CAN_SCE_IRQHandler
func interruptCAN_SCE() {
	callHandlers(IRQ_CAN_SCE)
}

//export EXTI9_5_IRQHandler
func interruptEXTI9_5() {
	callHandlers(IRQ_EXTI9_5)
}

//export TIM1_BRK_TIM15_IRQHandler
func interruptTIM1_BRK_TIM15() {
	callHandlers(IRQ_TIM1_BRK_TIM15)
}

//export TIM1_UP_TIM16_IRQHandler
func interruptTIM1_UP_TIM16() {
	callHandlers(IRQ_TIM1_UP_TIM16)
}

//export TIM1_TRG_COM_TIM17_IRQHandler
func interruptTIM1_TRG_COM_TIM17() {
	callHandlers(IRQ_TIM1_TRG_COM_TIM17)
}

//export TIM1_CC_IRQHandler
func interruptTIM1_CC() {
	callHandlers(IRQ_TIM1_CC)
}

//export TIM2_IRQHandler
func interruptTIM2() {
	callHandlers(IRQ_TIM2)
}

//export TIM3_IRQHandler
func interruptTIM3() {
	callHandlers(IRQ_TIM3)
}

//export TIM4_IRQHandler
func interruptTIM4() {
	callHandlers(IRQ_TIM4)
}

//export I2C1_EV_EXTI23_IRQHandler
func interruptI2C1_EV_EXTI23() {
	callHandlers(IRQ_I2C1_EV_EXTI23)
}

//export I2C1_ER_IRQHandler
func interruptI2C1_ER() {
	callHandlers(IRQ_I2C1_ER)
}

//export I2C2_EV_EXTI24_IRQHandler
func interruptI2C2_EV_EXTI24() {
	callHandlers(IRQ_I2C2_EV_EXTI24)
}

//export I2C2_ER_IRQHandler
func interruptI2C2_ER() {
	callHandlers(IRQ_I2C2_ER)
}

//export SPI1_IRQHandler
func interruptSPI1() {
	callHandlers(IRQ_SPI1)
}

//export SPI2_IRQHandler
func interruptSPI2() {
	callHandlers(IRQ_SPI2)
}

//export USART1_EXTI25_IRQHandler
func interruptUSART1_EXTI25() {
	callHandlers(IRQ_USART1_EXTI25)
}

//export USART2_EXTI26_IRQHandler
func interruptUSART2_EXTI26() {
	callHandlers(IRQ_USART2_EXTI26)
}

//export USART3_EXTI28_IRQHandler
func interruptUSART3_EXTI28() {
	callHandlers(IRQ_USART3_EXTI28)
}

//export EXTI15_10_IRQHandler
func interruptEXTI15_10() {
	callHandlers(IRQ_EXTI15_10)
}

//export RTCAlarm_IRQHandler
func interruptRTCAlarm() {
	callHandlers(IRQ_RTCAlarm)
}

//export USB_WKUP_IRQHandler
func interruptUSB_WKUP() {
	callHandlers(IRQ_USB_WKUP)
}

//export TIM8_BRK_IRQHandler
func interruptTIM8_BRK() {
	callHandlers(IRQ_TIM8_BRK)
}

//export TIM8_UP_IRQHandler
func interruptTIM8_UP() {
	callHandlers(IRQ_TIM8_UP)
}

//export TIM8_TRG_COM_IRQHandler
func interruptTIM8_TRG_COM() {
	callHandlers(IRQ_TIM8_TRG_COM)
}

//export TIM8_CC_IRQHandler
func interruptTIM8_CC() {
	callHandlers(IRQ_TIM8_CC)
}

//export FMC_IRQHandler
func interruptFMC() {
	callHandlers(IRQ_FMC)
}

//export SPI3_IRQHandler
func interruptSPI3() {
	callHandlers(IRQ_SPI3)
}

//export UART4_EXTI34_IRQHandler
func interruptUART4_EXTI34() {
	callHandlers(IRQ_UART4_EXTI34)
}

//export UART5_EXTI35_IRQHandler
func interruptUART5_EXTI35() {
	callHandlers(IRQ_UART5_EXTI35)
}

//export TIM6_DACUNDER_IRQHandler
func interruptTIM6_DACUNDER() {
	callHandlers(IRQ_TIM6_DACUNDER)
}

//export TIM7_IRQHandler
func interruptTIM7() {
	callHandlers(IRQ_TIM7)
}

//export DMA2_CH1_IRQHandler
func interruptDMA2_CH1() {
	callHandlers(IRQ_DMA2_CH1)
}

//export DMA2_CH2_IRQHandler
func interruptDMA2_CH2() {
	callHandlers(IRQ_DMA2_CH2)
}

//export DMA2_CH3_IRQHandler
func interruptDMA2_CH3() {
	callHandlers(IRQ_DMA2_CH3)
}

//export DMA2_CH4_IRQHandler
func interruptDMA2_CH4() {
	callHandlers(IRQ_DMA2_CH4)
}

//export DMA2_CH5_IRQHandler
func interruptDMA2_CH5() {
	callHandlers(IRQ_DMA2_CH5)
}

//export COMP1_2_3_IRQHandler
func interruptCOMP1_2_3() {
	callHandlers(IRQ_COMP1_2_3)
}

//export COMP4_5_6_IRQHandler
func interruptCOMP4_5_6() {
	callHandlers(IRQ_COMP4_5_6)
}

//export USB_HP_IRQHandler
func interruptUSB_HP() {
	callHandlers(IRQ_USB_HP)
}

//export USB_LP_IRQHandler
func interruptUSB_LP() {
	callHandlers(IRQ_USB_LP)
}

//export USB_WKUP_EXTI_IRQHandler
func interruptUSB_WKUP_EXTI() {
	callHandlers(IRQ_USB_WKUP_EXTI)
}

//export FPU_IRQHandler
func interruptFPU() {
	callHandlers(IRQ_FPU)
}

// Peripherals.
var (
	// General-purpose I/Os
	GPIOA = (*GPIO_Type)(unsafe.Pointer(uintptr(0x48000000)))

	// General-purpose I/Os
	GPIOB = (*GPIO_Type)(unsafe.Pointer(uintptr(0x48000400)))

	// Touch sensing controller
	TSC = (*TSC_Type)(unsafe.Pointer(uintptr(0x40024000)))

	// cyclic redundancy check calculation unit
	CRC = (*CRC_Type)(unsafe.Pointer(uintptr(0x40023000)))

	// Flash
	FLASH = (*Flash_Type)(unsafe.Pointer(uintptr(0x40022000)))

	// Reset and clock control
	RCC = (*RCC_Type)(unsafe.Pointer(uintptr(0x40021000)))

	// DMA controller 1
	DMA1 = (*DMA_Type)(unsafe.Pointer(uintptr(0x40020000)))

	// General purpose timer
	TIM2 = (*TIMs_Type)(unsafe.Pointer(uintptr(0x40000000)))

	// General purpose timers
	TIM15 = (*TIMs_Type)(unsafe.Pointer(uintptr(0x40014000)))

	// General-purpose-timers
	TIM16 = (*TIMs_Type)(unsafe.Pointer(uintptr(0x40014400)))

	// General purpose timer
	TIM17 = (*TIMs_Type)(unsafe.Pointer(uintptr(0x40014800)))

	// Universal synchronous asynchronous receiver transmitter
	USART1 = (*USART_Type)(unsafe.Pointer(uintptr(0x40013800)))

	// Serial peripheral interface/Inter-IC sound
	SPI1 = (*SPI_Type)(unsafe.Pointer(uintptr(0x40013000)))

	// External interrupt/event controller
	EXTI = (*EXTI_Type)(unsafe.Pointer(uintptr(0x40010400)))

	// Power control
	PWR = (*PWR_Type)(unsafe.Pointer(uintptr(0x40007000)))

	// Controller area network
	CAN = (*CAN_Type)(unsafe.Pointer(uintptr(0x40006400)))

	// Universal serial bus full-speed device interface
	USB = (*USB_FS_Type)(unsafe.Pointer(uintptr(0x40005c00)))

	// Inter-integrated circuit
	I2C1 = (*I2C_Type)(unsafe.Pointer(uintptr(0x40005400)))

	// Independent watchdog
	IWDG = (*IWDG_Type)(unsafe.Pointer(uintptr(0x40003000)))

	// Window watchdog
	WWDG = (*WWDG_Type)(unsafe.Pointer(uintptr(0x40002c00)))

	// Real-time clock
	RTC = (*RTC_Type)(unsafe.Pointer(uintptr(0x40002800)))

	// Basic timers
	TIM6 = (*TIMs_Type)(unsafe.Pointer(uintptr(0x40001000)))

	// Digital-to-analog converter
	DAC = (*DAC_Type)(unsafe.Pointer(uintptr(0x40007400)))

	// Debug support
	DBGMCU = (*DBGMCU_Type)(unsafe.Pointer(uintptr(0xe0042000)))

	// Advanced timer
	TIM1 = (*TIMs_Type)(unsafe.Pointer(uintptr(0x40012c00)))

	// Advanced-timers
	TIM8 = (*TIMs_Type)(unsafe.Pointer(uintptr(0x40013400)))

	// Analog-to-Digital Converter
	ADC1 = (*ADC_Type)(unsafe.Pointer(uintptr(0x50000000)))

	// Analog-to-Digital Converter
	ADC1_2 = (*ADC_Type)(unsafe.Pointer(uintptr(0x50000300)))

	// Flexible memory controller
	FMC = (*FMC_Type)(unsafe.Pointer(uintptr(0xa0000000)))

	// System configuration controller
	SYSCFG = (*SYSCFG_Type)(unsafe.Pointer(uintptr(0x40010000)))

	// Nested Vectored Interrupt Controller
	NVIC = (*NVIC_Type)(unsafe.Pointer(uintptr(0xe000e100)))

	// Floting point unit
	FPU = (*FPU_Type)(unsafe.Pointer(uintptr(0xe000ef34)))

	// Memory protection unit
	MPU = (*MPU_Type)(unsafe.Pointer(uintptr(0xe000ed90)))

	// SysTick timer
	STK = (*STK_Type)(unsafe.Pointer(uintptr(0xe000e010)))

	// System control block
	SCB = (*SCB_Type)(unsafe.Pointer(uintptr(0xe000ed00)))

	// Nested vectored interrupt controller
	NVIC_STIR = (*NVIC_Type)(unsafe.Pointer(uintptr(0xe000ef00)))

	// Floating point unit CPACR
	FPU_CPACR = (*FPU_Type)(unsafe.Pointer(uintptr(0xe000ed88)))

	// System control block ACTLR
	SCB_ACTRL = (*SCB_Type)(unsafe.Pointer(uintptr(0xe000e008)))

	// General purpose timer
	TIM3 = (*TIMs_Type)(unsafe.Pointer(uintptr(0x40000400)))

	// General purpose timer
	TIM4 = (*TIMs_Type)(unsafe.Pointer(uintptr(0x40000800)))

	// General-purpose I/Os
	GPIOC = (*GPIO_Type)(unsafe.Pointer(uintptr(0x48000800)))

	// Operational Amplifier
	OPAMP = (*OPAMP_Type)(unsafe.Pointer(uintptr(0x40010000)))

	// General purpose comparators
	COMP = (*COMP_Type)(unsafe.Pointer(uintptr(0x40010000)))

	// General-purpose I/Os
	GPIOD = (*GPIO_Type)(unsafe.Pointer(uintptr(0x48000c00)))

	// General-purpose I/Os
	GPIOE = (*GPIO_Type)(unsafe.Pointer(uintptr(0x48001000)))

	// General-purpose I/Os
	GPIOF = (*GPIO_Type)(unsafe.Pointer(uintptr(0x48001400)))

	// General-purpose I/Os
	GPIOG = (*GPIO_Type)(unsafe.Pointer(uintptr(0x48001800)))

	// General-purpose I/Os
	GPIOH = (*GPIO_Type)(unsafe.Pointer(uintptr(0x48001c00)))

	// DMA controller 1
	DMA2 = (*DMA_Type)(unsafe.Pointer(uintptr(0x40020400)))

	// Universal synchronous asynchronous receiver transmitter
	USART2 = (*USART_Type)(unsafe.Pointer(uintptr(0x40004400)))

	// Universal synchronous asynchronous receiver transmitter
	USART3 = (*USART_Type)(unsafe.Pointer(uintptr(0x40004800)))

	// Universal synchronous asynchronous receiver transmitter
	UART4 = (*USART_Type)(unsafe.Pointer(uintptr(0x40004c00)))

	// Universal synchronous asynchronous receiver transmitter
	UART5 = (*USART_Type)(unsafe.Pointer(uintptr(0x40005000)))

	// Serial peripheral interface/Inter-IC sound
	SPI2 = (*SPI_Type)(unsafe.Pointer(uintptr(0x40003800)))

	// Serial peripheral interface/Inter-IC sound
	SPI3 = (*SPI_Type)(unsafe.Pointer(uintptr(0x40003c00)))

	// Serial peripheral interface/Inter-IC sound
	I2S2ext = (*SPI_Type)(unsafe.Pointer(uintptr(0x40003400)))

	// Serial peripheral interface/Inter-IC sound
	I2S3ext = (*SPI_Type)(unsafe.Pointer(uintptr(0x40004000)))

	// Serial peripheral interface/Inter-IC sound
	SPI4 = (*SPI_Type)(unsafe.Pointer(uintptr(0x40013c00)))

	// Inter-integrated circuit
	I2C2 = (*I2C_Type)(unsafe.Pointer(uintptr(0x40005800)))

	// Inter-integrated circuit
	I2C3 = (*I2C_Type)(unsafe.Pointer(uintptr(0x40007800)))

	// Basic timers
	TIM7 = (*TIMs_Type)(unsafe.Pointer(uintptr(0x40001400)))

	// Advanced timer
	TIM20 = (*TIMs_Type)(unsafe.Pointer(uintptr(0x40015000)))

	// Analog-to-Digital Converter
	ADC2 = (*ADC_Type)(unsafe.Pointer(uintptr(0x50000100)))
)

// General-purpose I/Os
type GPIO_Type struct {
	MODER   volatile.Register32 // 0x0
	OTYPER  volatile.Register32 // 0x4
	OSPEEDR volatile.Register32 // 0x8
	PUPDR   volatile.Register32 // 0xC
	IDR     volatile.Register32 // 0x10
	ODR     volatile.Register32 // 0x14
	BSRR    volatile.Register32 // 0x18
	LCKR    volatile.Register32 // 0x1C
	AFRL    volatile.Register32 // 0x20
	AFRH    volatile.Register32 // 0x24
	BRR     volatile.Register32 // 0x28
}

// Touch sensing controller
type TSC_Type struct {
	CR     volatile.Register32 // 0x0
	IER    volatile.Register32 // 0x4
	ICR    volatile.Register32 // 0x8
	ISR    volatile.Register32 // 0xC
	IOHCR  volatile.Register32 // 0x10
	_      [4]byte
	IOASCR volatile.Register32 // 0x18
	_      [4]byte
	IOSCR  volatile.Register32 // 0x20
	_      [4]byte
	IOCCR  volatile.Register32 // 0x28
	_      [4]byte
	IOGCSR volatile.Register32 // 0x30
	IOG1CR volatile.Register32 // 0x34
	IOG2CR volatile.Register32 // 0x38
	IOG3CR volatile.Register32 // 0x3C
	IOG4CR volatile.Register32 // 0x40
	IOG5CR volatile.Register32 // 0x44
	IOG6CR volatile.Register32 // 0x48
	IOG7CR volatile.Register32 // 0x4C
	IOG8CR volatile.Register32 // 0x50
}

// cyclic redundancy check calculation unit
type CRC_Type struct {
	DR   volatile.Register32 // 0x0
	IDR  volatile.Register32 // 0x4
	CR   volatile.Register32 // 0x8
	_    [4]byte
	INIT volatile.Register32 // 0x10
	POL  volatile.Register32 // 0x14
}

// Flash
type Flash_Type struct {
	ACR     volatile.Register32 // 0x0
	KEYR    volatile.Register32 // 0x4
	OPTKEYR volatile.Register32 // 0x8
	SR      volatile.Register32 // 0xC
	CR      volatile.Register32 // 0x10
	AR      volatile.Register32 // 0x14
	_       [4]byte
	OBR     volatile.Register32 // 0x1C
	WRPR    volatile.Register32 // 0x20
}

// Reset and clock control
type RCC_Type struct {
	CR       volatile.Register32 // 0x0
	CFGR     volatile.Register32 // 0x4
	CIR      volatile.Register32 // 0x8
	APB2RSTR volatile.Register32 // 0xC
	APB1RSTR volatile.Register32 // 0x10
	AHBENR   volatile.Register32 // 0x14
	APB2ENR  volatile.Register32 // 0x18
	APB1ENR  volatile.Register32 // 0x1C
	BDCR     volatile.Register32 // 0x20
	CSR      volatile.Register32 // 0x24
	AHBRSTR  volatile.Register32 // 0x28
	CFGR2    volatile.Register32 // 0x2C
	CFGR3    volatile.Register32 // 0x30
}

// DMA controller 1
type DMA_Type struct {
	ISR  volatile.Register32 // 0x0
	IFCR volatile.Register32 // 0x4
	CH   [7]struct {
		CR   volatile.Register32
		NDTR volatile.Register32
		PAR  volatile.Register32
		MAR  volatile.Register32
		_    [4]byte
	} // 0x8
}

// General purpose timer
type TIMs_Type struct {
	CR1          volatile.Register32 // 0x0
	CR2          volatile.Register32 // 0x4
	SMCR         volatile.Register32 // 0x8
	DIER         volatile.Register32 // 0xC
	SR           volatile.Register32 // 0x10
	EGR          volatile.Register32 // 0x14
	CCMR1_Output volatile.Register32 // 0x18
	CCMR2_Output volatile.Register32 // 0x1C
	CCER         volatile.Register32 // 0x20
	CNT          volatile.Register32 // 0x24
	PSC          volatile.Register32 // 0x28
	ARR          volatile.Register32 // 0x2C
	_            [4]byte
	CCR1         volatile.Register32 // 0x34
	CCR2         volatile.Register32 // 0x38
	CCR3         volatile.Register32 // 0x3C
	CCR4         volatile.Register32 // 0x40
	_            [4]byte
	DCR          volatile.Register32 // 0x48
	DMAR         volatile.Register32 // 0x4C
}

// Universal synchronous asynchronous receiver transmitter
type USART_Type struct {
	CR1  volatile.Register32 // 0x0
	CR2  volatile.Register32 // 0x4
	CR3  volatile.Register32 // 0x8
	BRR  volatile.Register32 // 0xC
	GTPR volatile.Register32 // 0x10
	RTOR volatile.Register32 // 0x14
	RQR  volatile.Register32 // 0x18
	ISR  volatile.Register32 // 0x1C
	ICR  volatile.Register32 // 0x20
	RDR  volatile.Register32 // 0x24
	TDR  volatile.Register32 // 0x28
}

// Serial peripheral interface/Inter-IC sound
type SPI_Type struct {
	CR1     volatile.Register32 // 0x0
	CR2     volatile.Register32 // 0x4
	SR      volatile.Register32 // 0x8
	DR      volatile.Register32 // 0xC
	CRCPR   volatile.Register32 // 0x10
	RXCRCR  volatile.Register32 // 0x14
	TXCRCR  volatile.Register32 // 0x18
	I2SCFGR volatile.Register32 // 0x1C
	I2SPR   volatile.Register32 // 0x20
}

// External interrupt/event controller
type EXTI_Type struct {
	IMR1   volatile.Register32 // 0x0
	EMR1   volatile.Register32 // 0x4
	RTSR1  volatile.Register32 // 0x8
	FTSR1  volatile.Register32 // 0xC
	SWIER1 volatile.Register32 // 0x10
	PR1    volatile.Register32 // 0x14
	_      [8]byte
	IMR2   volatile.Register32 // 0x20
	EMR2   volatile.Register32 // 0x24
	RTSR2  volatile.Register32 // 0x28
	FTSR2  volatile.Register32 // 0x2C
	SWIER2 volatile.Register32 // 0x30
	PR2    volatile.Register32 // 0x34
}

// Power control
type PWR_Type struct {
	CR  volatile.Register32 // 0x0
	CSR volatile.Register32 // 0x4
}

// Controller area network
type CAN_Type struct {
	MCR  volatile.Register32 // 0x0
	MSR  volatile.Register32 // 0x4
	TSR  volatile.Register32 // 0x8
	RF0R volatile.Register32 // 0xC
	RF1R volatile.Register32 // 0x10
	IER  volatile.Register32 // 0x14
	ESR  volatile.Register32 // 0x18
	BTR  volatile.Register32 // 0x1C
	_    [352]byte
	TX   [3]struct {
		TIR  volatile.Register32
		TDTR volatile.Register32
		TDLR volatile.Register32
		TDHR volatile.Register32
	} // 0x180
	RX [2]struct {
		RIR  volatile.Register32
		RDTR volatile.Register32
		RDLR volatile.Register32
		RDHR volatile.Register32
	} // 0x1B0
	_     [48]byte
	FMR   volatile.Register32 // 0x200
	FM1R  volatile.Register32 // 0x204
	_     [4]byte
	FS1R  volatile.Register32 // 0x20C
	_     [4]byte
	FFA1R volatile.Register32 // 0x214
	_     [4]byte
	FA1R  volatile.Register32 // 0x21C
	_     [32]byte
	FB    [28]struct {
		FR1 volatile.Register32
		FR2 volatile.Register32
	} // 0x240
}

// Universal serial bus full-speed device interface
type USB_FS_Type struct {
	EP0R   volatile.Register32 // 0x0
	EP1R   volatile.Register32 // 0x4
	EP2R   volatile.Register32 // 0x8
	EP3R   volatile.Register32 // 0xC
	EP4R   volatile.Register32 // 0x10
	EP5R   volatile.Register32 // 0x14
	EP6R   volatile.Register32 // 0x18
	EP7R   volatile.Register32 // 0x1C
	_      [32]byte
	CNTR   volatile.Register32 // 0x40
	ISTR   volatile.Register32 // 0x44
	FNR    volatile.Register32 // 0x48
	DADDR  volatile.Register32 // 0x4C
	BTABLE volatile.Register32 // 0x50
}

// Inter-integrated circuit
type I2C_Type struct {
	CR1      volatile.Register32 // 0x0
	CR2      volatile.Register32 // 0x4
	OAR1     volatile.Register32 // 0x8
	OAR2     volatile.Register32 // 0xC
	TIMINGR  volatile.Register32 // 0x10
	TIMEOUTR volatile.Register32 // 0x14
	ISR      volatile.Register32 // 0x18
	ICR      volatile.Register32 // 0x1C
	PECR     volatile.Register32 // 0x20
	RXDR     volatile.Register32 // 0x24
	TXDR     volatile.Register32 // 0x28
}

// Independent watchdog
type IWDG_Type struct {
	KR   volatile.Register32 // 0x0
	PR   volatile.Register32 // 0x4
	RLR  volatile.Register32 // 0x8
	SR   volatile.Register32 // 0xC
	WINR volatile.Register32 // 0x10
}

// Window watchdog
type WWDG_Type struct {
	CR  volatile.Register32 // 0x0
	CFR volatile.Register32 // 0x4
	SR  volatile.Register32 // 0x8
}

// Real-time clock
type RTC_Type struct {
	TR       volatile.Register32 // 0x0
	DR       volatile.Register32 // 0x4
	CR       volatile.Register32 // 0x8
	ISR      volatile.Register32 // 0xC
	PRER     volatile.Register32 // 0x10
	WUTR     volatile.Register32 // 0x14
	_        [4]byte
	ALRMAR   volatile.Register32 // 0x1C
	ALRMBR   volatile.Register32 // 0x20
	WPR      volatile.Register32 // 0x24
	SSR      volatile.Register32 // 0x28
	SHIFTR   volatile.Register32 // 0x2C
	TSTR     volatile.Register32 // 0x30
	TSDR     volatile.Register32 // 0x34
	TSSSR    volatile.Register32 // 0x38
	CALR     volatile.Register32 // 0x3C
	TAFCR    volatile.Register32 // 0x40
	ALRMASSR volatile.Register32 // 0x44
	ALRMBSSR volatile.Register32 // 0x48
	_        [4]byte
	BKP0R    volatile.Register32 // 0x50
	BKP1R    volatile.Register32 // 0x54
	BKP2R    volatile.Register32 // 0x58
	BKP3R    volatile.Register32 // 0x5C
	BKP4R    volatile.Register32 // 0x60
	BKP5R    volatile.Register32 // 0x64
	BKP6R    volatile.Register32 // 0x68
	BKP7R    volatile.Register32 // 0x6C
	BKP8R    volatile.Register32 // 0x70
	BKP9R    volatile.Register32 // 0x74
	BKP10R   volatile.Register32 // 0x78
	BKP11R   volatile.Register32 // 0x7C
	BKP12R   volatile.Register32 // 0x80
	BKP13R   volatile.Register32 // 0x84
	BKP14R   volatile.Register32 // 0x88
	BKP15R   volatile.Register32 // 0x8C
	BKP16R   volatile.Register32 // 0x90
	BKP17R   volatile.Register32 // 0x94
	BKP18R   volatile.Register32 // 0x98
	BKP19R   volatile.Register32 // 0x9C
	BKP20R   volatile.Register32 // 0xA0
	BKP21R   volatile.Register32 // 0xA4
	BKP22R   volatile.Register32 // 0xA8
	BKP23R   volatile.Register32 // 0xAC
	BKP24R   volatile.Register32 // 0xB0
	BKP25R   volatile.Register32 // 0xB4
	BKP26R   volatile.Register32 // 0xB8
	BKP27R   volatile.Register32 // 0xBC
	BKP28R   volatile.Register32 // 0xC0
	BKP29R   volatile.Register32 // 0xC4
	BKP30R   volatile.Register32 // 0xC8
	BKP31R   volatile.Register32 // 0xCC
}

// Digital-to-analog converter
type DAC_Type struct {
	CR      volatile.Register32 // 0x0
	SWTRIGR volatile.Register32 // 0x4
	DHR12R1 volatile.Register32 // 0x8
	DHR12L1 volatile.Register32 // 0xC
	DHR8R1  volatile.Register32 // 0x10
	DHR12R2 volatile.Register32 // 0x14
	DHR12L2 volatile.Register32 // 0x18
	DHR8R2  volatile.Register32 // 0x1C
	DHR12RD volatile.Register32 // 0x20
	DHR12LD volatile.Register32 // 0x24
	DHR8RD  volatile.Register32 // 0x28
	DOR1    volatile.Register32 // 0x2C
	DOR2    volatile.Register32 // 0x30
	SR      volatile.Register32 // 0x34
}

// Debug support
type DBGMCU_Type struct {
	IDCODE  volatile.Register32 // 0x0
	CR      volatile.Register32 // 0x4
	APB1_FZ volatile.Register32 // 0x8
	APB2FZ  volatile.Register32 // 0xC
}

// Analog-to-Digital Converter
type ADC_Type struct {
	ISR     volatile.Register32 // 0x0
	IER     volatile.Register32 // 0x4
	CR      volatile.Register32 // 0x8
	CFGR    volatile.Register32 // 0xC
	_       [4]byte
	SMPR1   volatile.Register32 // 0x14
	SMPR2   volatile.Register32 // 0x18
	_       [4]byte
	TR1     volatile.Register32 // 0x20
	TR2     volatile.Register32 // 0x24
	TR3     volatile.Register32 // 0x28
	_       [4]byte
	SQR1    volatile.Register32 // 0x30
	SQR2    volatile.Register32 // 0x34
	SQR3    volatile.Register32 // 0x38
	SQR4    volatile.Register32 // 0x3C
	DR      volatile.Register32 // 0x40
	_       [8]byte
	JSQR    volatile.Register32 // 0x4C
	_       [16]byte
	OFR1    volatile.Register32 // 0x60
	OFR2    volatile.Register32 // 0x64
	OFR3    volatile.Register32 // 0x68
	OFR4    volatile.Register32 // 0x6C
	_       [16]byte
	JDR1    volatile.Register32 // 0x80
	JDR2    volatile.Register32 // 0x84
	JDR3    volatile.Register32 // 0x88
	JDR4    volatile.Register32 // 0x8C
	_       [16]byte
	AWD2CR  volatile.Register32 // 0xA0
	AWD3CR  volatile.Register32 // 0xA4
	_       [8]byte
	DIFSEL  volatile.Register32 // 0xB0
	CALFACT volatile.Register32 // 0xB4
}

// Flexible memory controller
type FMC_Type struct {
	BCR1  volatile.Register32 // 0x0
	BTR1  volatile.Register32 // 0x4
	BCR2  volatile.Register32 // 0x8
	BTR2  volatile.Register32 // 0xC
	BCR3  volatile.Register32 // 0x10
	BTR3  volatile.Register32 // 0x14
	BCR4  volatile.Register32 // 0x18
	BTR4  volatile.Register32 // 0x1C
	_     [64]byte
	PCR2  volatile.Register32 // 0x60
	SR2   volatile.Register32 // 0x64
	PMEM2 volatile.Register32 // 0x68
	PATT2 volatile.Register32 // 0x6C
	_     [4]byte
	ECCR2 volatile.Register32 // 0x74
	_     [8]byte
	PCR3  volatile.Register32 // 0x80
	SR3   volatile.Register32 // 0x84
	PMEM3 volatile.Register32 // 0x88
	PATT3 volatile.Register32 // 0x8C
	_     [4]byte
	ECCR3 volatile.Register32 // 0x94
	_     [8]byte
	PCR4  volatile.Register32 // 0xA0
	SR4   volatile.Register32 // 0xA4
	PMEM4 volatile.Register32 // 0xA8
	PATT4 volatile.Register32 // 0xAC
	PIO4  volatile.Register32 // 0xB0
	_     [80]byte
	BWTR1 volatile.Register32 // 0x104
	_     [4]byte
	BWTR2 volatile.Register32 // 0x10C
	_     [4]byte
	BWTR3 volatile.Register32 // 0x114
	_     [4]byte
	BWTR4 volatile.Register32 // 0x11C
}

// System configuration controller
type SYSCFG_Type struct {
	CFGR1   volatile.Register32 // 0x0
	_       [4]byte
	EXTICR1 volatile.Register32 // 0x8
	EXTICR2 volatile.Register32 // 0xC
	EXTICR3 volatile.Register32 // 0x10
	EXTICR4 volatile.Register32 // 0x14
	CFGR2   volatile.Register32 // 0x18
}

// Nested Vectored Interrupt Controller
type NVIC_Type struct {
	ISER0 volatile.Register32 // 0x0
	ISER1 volatile.Register32 // 0x4
	ISER2 volatile.Register32 // 0x8
	_     [116]byte
	ICER0 volatile.Register32 // 0x80
	ICER1 volatile.Register32 // 0x84
	ICER2 volatile.Register32 // 0x88
	_     [116]byte
	ISPR0 volatile.Register32 // 0x100
	ISPR1 volatile.Register32 // 0x104
	ISPR2 volatile.Register32 // 0x108
	_     [116]byte
	ICPR0 volatile.Register32 // 0x180
	ICPR1 volatile.Register32 // 0x184
	ICPR2 volatile.Register32 // 0x188
	_     [116]byte
	IABR0 volatile.Register32 // 0x200
	IABR1 volatile.Register32 // 0x204
	IABR2 volatile.Register32 // 0x208
	_     [244]byte
	IPR0  volatile.Register32 // 0x300
	IPR1  volatile.Register32 // 0x304
	IPR2  volatile.Register32 // 0x308
	IPR3  volatile.Register32 // 0x30C
	IPR4  volatile.Register32 // 0x310
	IPR5  volatile.Register32 // 0x314
	IPR6  volatile.Register32 // 0x318
	IPR7  volatile.Register32 // 0x31C
	IPR8  volatile.Register32 // 0x320
	IPR9  volatile.Register32 // 0x324
	IPR10 volatile.Register32 // 0x328
	IPR11 volatile.Register32 // 0x32C
	IPR12 volatile.Register32 // 0x330
	IPR13 volatile.Register32 // 0x334
	IPR14 volatile.Register32 // 0x338
	IPR15 volatile.Register32 // 0x33C
	IPR16 volatile.Register32 // 0x340
	IPR17 volatile.Register32 // 0x344
	IPR18 volatile.Register32 // 0x348
	IPR19 volatile.Register32 // 0x34C
	IPR20 volatile.Register32 // 0x350
}

// Floting point unit
type FPU_Type struct {
	FPCCR volatile.Register32 // 0x0
	FPCAR volatile.Register32 // 0x4
	FPSCR volatile.Register32 // 0x8
}

// Memory protection unit
type MPU_Type struct {
	MPU_TYPER volatile.Register32 // 0x0
	MPU_CTRL  volatile.Register32 // 0x4
	MPU_RNR   volatile.Register32 // 0x8
	MPU_RBAR  volatile.Register32 // 0xC
	MPU_RASR  volatile.Register32 // 0x10
}

// SysTick timer
type STK_Type struct {
	CTRL  volatile.Register32 // 0x0
	LOAD  volatile.Register32 // 0x4
	VAL   volatile.Register32 // 0x8
	CALIB volatile.Register32 // 0xC
}

// System control block
type SCB_Type struct {
	CPUID                volatile.Register32 // 0x0
	ICSR                 volatile.Register32 // 0x4
	VTOR                 volatile.Register32 // 0x8
	AIRCR                volatile.Register32 // 0xC
	SCR                  volatile.Register32 // 0x10
	CCR                  volatile.Register32 // 0x14
	SHPR1                volatile.Register32 // 0x18
	SHPR2                volatile.Register32 // 0x1C
	SHPR3                volatile.Register32 // 0x20
	SHCRS                volatile.Register32 // 0x24
	CFSR_UFSR_BFSR_MMFSR volatile.Register32 // 0x28
	HFSR                 volatile.Register32 // 0x2C
	_                    [4]byte
	MMFAR                volatile.Register32 // 0x34
	BFAR                 volatile.Register32 // 0x38
	AFSR                 volatile.Register32 // 0x3C
}

// Operational Amplifier
type OPAMP_Type struct {
	_          [56]byte
	OPAMP1_CSR volatile.Register32 // 0x38
	OPAMP2_CSR volatile.Register32 // 0x3C
}

// General purpose comparators
type COMP_Type struct {
	_         [28]byte
	COMP1_CSR volatile.Register32 // 0x1C
	COMP2_CSR volatile.Register32 // 0x20
	_         [4]byte
	COMP4_CSR volatile.Register32 // 0x28
	_         [4]byte
	COMP6_CSR volatile.Register32 // 0x30
}

// Bitfields for GPIOA: General-purpose I/Os
const (
	// MODER: GPIO port mode register
	// Position of MODER15 field.
	GPIO_MODER_MODER15_Pos = 0x1e
	// Bit mask of MODER15 field.
	GPIO_MODER_MODER15_Msk = 0xc0000000
	// Input mode (reset state)
	GPIO_MODER_MODER15_Input = 0x0
	// General purpose output mode
	GPIO_MODER_MODER15_Output = 0x1
	// Alternate function mode
	GPIO_MODER_MODER15_Alternate = 0x2
	// Analog mode
	GPIO_MODER_MODER15_Analog = 0x3
	// Position of MODER14 field.
	GPIO_MODER_MODER14_Pos = 0x1c
	// Bit mask of MODER14 field.
	GPIO_MODER_MODER14_Msk = 0x30000000
	// Input mode (reset state)
	GPIO_MODER_MODER14_Input = 0x0
	// General purpose output mode
	GPIO_MODER_MODER14_Output = 0x1
	// Alternate function mode
	GPIO_MODER_MODER14_Alternate = 0x2
	// Analog mode
	GPIO_MODER_MODER14_Analog = 0x3
	// Position of MODER13 field.
	GPIO_MODER_MODER13_Pos = 0x1a
	// Bit mask of MODER13 field.
	GPIO_MODER_MODER13_Msk = 0xc000000
	// Input mode (reset state)
	GPIO_MODER_MODER13_Input = 0x0
	// General purpose output mode
	GPIO_MODER_MODER13_Output = 0x1
	// Alternate function mode
	GPIO_MODER_MODER13_Alternate = 0x2
	// Analog mode
	GPIO_MODER_MODER13_Analog = 0x3
	// Position of MODER12 field.
	GPIO_MODER_MODER12_Pos = 0x18
	// Bit mask of MODER12 field.
	GPIO_MODER_MODER12_Msk = 0x3000000
	// Input mode (reset state)
	GPIO_MODER_MODER12_Input = 0x0
	// General purpose output mode
	GPIO_MODER_MODER12_Output = 0x1
	// Alternate function mode
	GPIO_MODER_MODER12_Alternate = 0x2
	// Analog mode
	GPIO_MODER_MODER12_Analog = 0x3
	// Position of MODER11 field.
	GPIO_MODER_MODER11_Pos = 0x16
	// Bit mask of MODER11 field.
	GPIO_MODER_MODER11_Msk = 0xc00000
	// Input mode (reset state)
	GPIO_MODER_MODER11_Input = 0x0
	// General purpose output mode
	GPIO_MODER_MODER11_Output = 0x1
	// Alternate function mode
	GPIO_MODER_MODER11_Alternate = 0x2
	// Analog mode
	GPIO_MODER_MODER11_Analog = 0x3
	// Position of MODER10 field.
	GPIO_MODER_MODER10_Pos = 0x14
	// Bit mask of MODER10 field.
	GPIO_MODER_MODER10_Msk = 0x300000
	// Input mode (reset state)
	GPIO_MODER_MODER10_Input = 0x0
	// General purpose output mode
	GPIO_MODER_MODER10_Output = 0x1
	// Alternate function mode
	GPIO_MODER_MODER10_Alternate = 0x2
	// Analog mode
	GPIO_MODER_MODER10_Analog = 0x3
	// Position of MODER9 field.
	GPIO_MODER_MODER9_Pos = 0x12
	// Bit mask of MODER9 field.
	GPIO_MODER_MODER9_Msk = 0xc0000
	// Input mode (reset state)
	GPIO_MODER_MODER9_Input = 0x0
	// General purpose output mode
	GPIO_MODER_MODER9_Output = 0x1
	// Alternate function mode
	GPIO_MODER_MODER9_Alternate = 0x2
	// Analog mode
	GPIO_MODER_MODER9_Analog = 0x3
	// Position of MODER8 field.
	GPIO_MODER_MODER8_Pos = 0x10
	// Bit mask of MODER8 field.
	GPIO_MODER_MODER8_Msk = 0x30000
	// Input mode (reset state)
	GPIO_MODER_MODER8_Input = 0x0
	// General purpose output mode
	GPIO_MODER_MODER8_Output = 0x1
	// Alternate function mode
	GPIO_MODER_MODER8_Alternate = 0x2
	// Analog mode
	GPIO_MODER_MODER8_Analog = 0x3
	// Position of MODER7 field.
	GPIO_MODER_MODER7_Pos = 0xe
	// Bit mask of MODER7 field.
	GPIO_MODER_MODER7_Msk = 0xc000
	// Input mode (reset state)
	GPIO_MODER_MODER7_Input = 0x0
	// General purpose output mode
	GPIO_MODER_MODER7_Output = 0x1
	// Alternate function mode
	GPIO_MODER_MODER7_Alternate = 0x2
	// Analog mode
	GPIO_MODER_MODER7_Analog = 0x3
	// Position of MODER6 field.
	GPIO_MODER_MODER6_Pos = 0xc
	// Bit mask of MODER6 field.
	GPIO_MODER_MODER6_Msk = 0x3000
	// Input mode (reset state)
	GPIO_MODER_MODER6_Input = 0x0
	// General purpose output mode
	GPIO_MODER_MODER6_Output = 0x1
	// Alternate function mode
	GPIO_MODER_MODER6_Alternate = 0x2
	// Analog mode
	GPIO_MODER_MODER6_Analog = 0x3
	// Position of MODER5 field.
	GPIO_MODER_MODER5_Pos = 0xa
	// Bit mask of MODER5 field.
	GPIO_MODER_MODER5_Msk = 0xc00
	// Input mode (reset state)
	GPIO_MODER_MODER5_Input = 0x0
	// General purpose output mode
	GPIO_MODER_MODER5_Output = 0x1
	// Alternate function mode
	GPIO_MODER_MODER5_Alternate = 0x2
	// Analog mode
	GPIO_MODER_MODER5_Analog = 0x3
	// Position of MODER4 field.
	GPIO_MODER_MODER4_Pos = 0x8
	// Bit mask of MODER4 field.
	GPIO_MODER_MODER4_Msk = 0x300
	// Input mode (reset state)
	GPIO_MODER_MODER4_Input = 0x0
	// General purpose output mode
	GPIO_MODER_MODER4_Output = 0x1
	// Alternate function mode
	GPIO_MODER_MODER4_Alternate = 0x2
	// Analog mode
	GPIO_MODER_MODER4_Analog = 0x3
	// Position of MODER3 field.
	GPIO_MODER_MODER3_Pos = 0x6
	// Bit mask of MODER3 field.
	GPIO_MODER_MODER3_Msk = 0xc0
	// Input mode (reset state)
	GPIO_MODER_MODER3_Input = 0x0
	// General purpose output mode
	GPIO_MODER_MODER3_Output = 0x1
	// Alternate function mode
	GPIO_MODER_MODER3_Alternate = 0x2
	// Analog mode
	GPIO_MODER_MODER3_Analog = 0x3
	// Position of MODER2 field.
	GPIO_MODER_MODER2_Pos = 0x4
	// Bit mask of MODER2 field.
	GPIO_MODER_MODER2_Msk = 0x30
	// Input mode (reset state)
	GPIO_MODER_MODER2_Input = 0x0
	// General purpose output mode
	GPIO_MODER_MODER2_Output = 0x1
	// Alternate function mode
	GPIO_MODER_MODER2_Alternate = 0x2
	// Analog mode
	GPIO_MODER_MODER2_Analog = 0x3
	// Position of MODER1 field.
	GPIO_MODER_MODER1_Pos = 0x2
	// Bit mask of MODER1 field.
	GPIO_MODER_MODER1_Msk = 0xc
	// Input mode (reset state)
	GPIO_MODER_MODER1_Input = 0x0
	// General purpose output mode
	GPIO_MODER_MODER1_Output = 0x1
	// Alternate function mode
	GPIO_MODER_MODER1_Alternate = 0x2
	// Analog mode
	GPIO_MODER_MODER1_Analog = 0x3
	// Position of MODER0 field.
	GPIO_MODER_MODER0_Pos = 0x0
	// Bit mask of MODER0 field.
	GPIO_MODER_MODER0_Msk = 0x3
	// Input mode (reset state)
	GPIO_MODER_MODER0_Input = 0x0
	// General purpose output mode
	GPIO_MODER_MODER0_Output = 0x1
	// Alternate function mode
	GPIO_MODER_MODER0_Alternate = 0x2
	// Analog mode
	GPIO_MODER_MODER0_Analog = 0x3

	// OTYPER: GPIO port output type register
	// Position of OT15 field.
	GPIO_OTYPER_OT15_Pos = 0xf
	// Bit mask of OT15 field.
	GPIO_OTYPER_OT15_Msk = 0x8000
	// Bit OT15.
	GPIO_OTYPER_OT15 = 0x8000
	// Output push-pull (reset state)
	GPIO_OTYPER_OT15_PushPull = 0x0
	// Output open-drain
	GPIO_OTYPER_OT15_OpenDrain = 0x1
	// Position of OT14 field.
	GPIO_OTYPER_OT14_Pos = 0xe
	// Bit mask of OT14 field.
	GPIO_OTYPER_OT14_Msk = 0x4000
	// Bit OT14.
	GPIO_OTYPER_OT14 = 0x4000
	// Output push-pull (reset state)
	GPIO_OTYPER_OT14_PushPull = 0x0
	// Output open-drain
	GPIO_OTYPER_OT14_OpenDrain = 0x1
	// Position of OT13 field.
	GPIO_OTYPER_OT13_Pos = 0xd
	// Bit mask of OT13 field.
	GPIO_OTYPER_OT13_Msk = 0x2000
	// Bit OT13.
	GPIO_OTYPER_OT13 = 0x2000
	// Output push-pull (reset state)
	GPIO_OTYPER_OT13_PushPull = 0x0
	// Output open-drain
	GPIO_OTYPER_OT13_OpenDrain = 0x1
	// Position of OT12 field.
	GPIO_OTYPER_OT12_Pos = 0xc
	// Bit mask of OT12 field.
	GPIO_OTYPER_OT12_Msk = 0x1000
	// Bit OT12.
	GPIO_OTYPER_OT12 = 0x1000
	// Output push-pull (reset state)
	GPIO_OTYPER_OT12_PushPull = 0x0
	// Output open-drain
	GPIO_OTYPER_OT12_OpenDrain = 0x1
	// Position of OT11 field.
	GPIO_OTYPER_OT11_Pos = 0xb
	// Bit mask of OT11 field.
	GPIO_OTYPER_OT11_Msk = 0x800
	// Bit OT11.
	GPIO_OTYPER_OT11 = 0x800
	// Output push-pull (reset state)
	GPIO_OTYPER_OT11_PushPull = 0x0
	// Output open-drain
	GPIO_OTYPER_OT11_OpenDrain = 0x1
	// Position of OT10 field.
	GPIO_OTYPER_OT10_Pos = 0xa
	// Bit mask of OT10 field.
	GPIO_OTYPER_OT10_Msk = 0x400
	// Bit OT10.
	GPIO_OTYPER_OT10 = 0x400
	// Output push-pull (reset state)
	GPIO_OTYPER_OT10_PushPull = 0x0
	// Output open-drain
	GPIO_OTYPER_OT10_OpenDrain = 0x1
	// Position of OT9 field.
	GPIO_OTYPER_OT9_Pos = 0x9
	// Bit mask of OT9 field.
	GPIO_OTYPER_OT9_Msk = 0x200
	// Bit OT9.
	GPIO_OTYPER_OT9 = 0x200
	// Output push-pull (reset state)
	GPIO_OTYPER_OT9_PushPull = 0x0
	// Output open-drain
	GPIO_OTYPER_OT9_OpenDrain = 0x1
	// Position of OT8 field.
	GPIO_OTYPER_OT8_Pos = 0x8
	// Bit mask of OT8 field.
	GPIO_OTYPER_OT8_Msk = 0x100
	// Bit OT8.
	GPIO_OTYPER_OT8 = 0x100
	// Output push-pull (reset state)
	GPIO_OTYPER_OT8_PushPull = 0x0
	// Output open-drain
	GPIO_OTYPER_OT8_OpenDrain = 0x1
	// Position of OT7 field.
	GPIO_OTYPER_OT7_Pos = 0x7
	// Bit mask of OT7 field.
	GPIO_OTYPER_OT7_Msk = 0x80
	// Bit OT7.
	GPIO_OTYPER_OT7 = 0x80
	// Output push-pull (reset state)
	GPIO_OTYPER_OT7_PushPull = 0x0
	// Output open-drain
	GPIO_OTYPER_OT7_OpenDrain = 0x1
	// Position of OT6 field.
	GPIO_OTYPER_OT6_Pos = 0x6
	// Bit mask of OT6 field.
	GPIO_OTYPER_OT6_Msk = 0x40
	// Bit OT6.
	GPIO_OTYPER_OT6 = 0x40
	// Output push-pull (reset state)
	GPIO_OTYPER_OT6_PushPull = 0x0
	// Output open-drain
	GPIO_OTYPER_OT6_OpenDrain = 0x1
	// Position of OT5 field.
	GPIO_OTYPER_OT5_Pos = 0x5
	// Bit mask of OT5 field.
	GPIO_OTYPER_OT5_Msk = 0x20
	// Bit OT5.
	GPIO_OTYPER_OT5 = 0x20
	// Output push-pull (reset state)
	GPIO_OTYPER_OT5_PushPull = 0x0
	// Output open-drain
	GPIO_OTYPER_OT5_OpenDrain = 0x1
	// Position of OT4 field.
	GPIO_OTYPER_OT4_Pos = 0x4
	// Bit mask of OT4 field.
	GPIO_OTYPER_OT4_Msk = 0x10
	// Bit OT4.
	GPIO_OTYPER_OT4 = 0x10
	// Output push-pull (reset state)
	GPIO_OTYPER_OT4_PushPull = 0x0
	// Output open-drain
	GPIO_OTYPER_OT4_OpenDrain = 0x1
	// Position of OT3 field.
	GPIO_OTYPER_OT3_Pos = 0x3
	// Bit mask of OT3 field.
	GPIO_OTYPER_OT3_Msk = 0x8
	// Bit OT3.
	GPIO_OTYPER_OT3 = 0x8
	// Output push-pull (reset state)
	GPIO_OTYPER_OT3_PushPull = 0x0
	// Output open-drain
	GPIO_OTYPER_OT3_OpenDrain = 0x1
	// Position of OT2 field.
	GPIO_OTYPER_OT2_Pos = 0x2
	// Bit mask of OT2 field.
	GPIO_OTYPER_OT2_Msk = 0x4
	// Bit OT2.
	GPIO_OTYPER_OT2 = 0x4
	// Output push-pull (reset state)
	GPIO_OTYPER_OT2_PushPull = 0x0
	// Output open-drain
	GPIO_OTYPER_OT2_OpenDrain = 0x1
	// Position of OT1 field.
	GPIO_OTYPER_OT1_Pos = 0x1
	// Bit mask of OT1 field.
	GPIO_OTYPER_OT1_Msk = 0x2
	// Bit OT1.
	GPIO_OTYPER_OT1 = 0x2
	// Output push-pull (reset state)
	GPIO_OTYPER_OT1_PushPull = 0x0
	// Output open-drain
	GPIO_OTYPER_OT1_OpenDrain = 0x1
	// Position of OT0 field.
	GPIO_OTYPER_OT0_Pos = 0x0
	// Bit mask of OT0 field.
	GPIO_OTYPER_OT0_Msk = 0x1
	// Bit OT0.
	GPIO_OTYPER_OT0 = 0x1
	// Output push-pull (reset state)
	GPIO_OTYPER_OT0_PushPull = 0x0
	// Output open-drain
	GPIO_OTYPER_OT0_OpenDrain = 0x1

	// OSPEEDR: GPIO port output speed register
	// Position of OSPEEDR15 field.
	GPIO_OSPEEDR_OSPEEDR15_Pos = 0x1e
	// Bit mask of OSPEEDR15 field.
	GPIO_OSPEEDR_OSPEEDR15_Msk = 0xc0000000
	// Low speed
	GPIO_OSPEEDR_OSPEEDR15_LowSpeed = 0x0
	// Medium speed
	GPIO_OSPEEDR_OSPEEDR15_MediumSpeed = 0x1
	// High speed
	GPIO_OSPEEDR_OSPEEDR15_HighSpeed = 0x3
	// Position of OSPEEDR14 field.
	GPIO_OSPEEDR_OSPEEDR14_Pos = 0x1c
	// Bit mask of OSPEEDR14 field.
	GPIO_OSPEEDR_OSPEEDR14_Msk = 0x30000000
	// Low speed
	GPIO_OSPEEDR_OSPEEDR14_LowSpeed = 0x0
	// Medium speed
	GPIO_OSPEEDR_OSPEEDR14_MediumSpeed = 0x1
	// High speed
	GPIO_OSPEEDR_OSPEEDR14_HighSpeed = 0x3
	// Position of OSPEEDR13 field.
	GPIO_OSPEEDR_OSPEEDR13_Pos = 0x1a
	// Bit mask of OSPEEDR13 field.
	GPIO_OSPEEDR_OSPEEDR13_Msk = 0xc000000
	// Low speed
	GPIO_OSPEEDR_OSPEEDR13_LowSpeed = 0x0
	// Medium speed
	GPIO_OSPEEDR_OSPEEDR13_MediumSpeed = 0x1
	// High speed
	GPIO_OSPEEDR_OSPEEDR13_HighSpeed = 0x3
	// Position of OSPEEDR12 field.
	GPIO_OSPEEDR_OSPEEDR12_Pos = 0x18
	// Bit mask of OSPEEDR12 field.
	GPIO_OSPEEDR_OSPEEDR12_Msk = 0x3000000
	// Low speed
	GPIO_OSPEEDR_OSPEEDR12_LowSpeed = 0x0
	// Medium speed
	GPIO_OSPEEDR_OSPEEDR12_MediumSpeed = 0x1
	// High speed
	GPIO_OSPEEDR_OSPEEDR12_HighSpeed = 0x3
	// Position of OSPEEDR11 field.
	GPIO_OSPEEDR_OSPEEDR11_Pos = 0x16
	// Bit mask of OSPEEDR11 field.
	GPIO_OSPEEDR_OSPEEDR11_Msk = 0xc00000
	// Low speed
	GPIO_OSPEEDR_OSPEEDR11_LowSpeed = 0x0
	// Medium speed
	GPIO_OSPEEDR_OSPEEDR11_MediumSpeed = 0x1
	// High speed
	GPIO_OSPEEDR_OSPEEDR11_HighSpeed = 0x3
	// Position of OSPEEDR10 field.
	GPIO_OSPEEDR_OSPEEDR10_Pos = 0x14
	// Bit mask of OSPEEDR10 field.
	GPIO_OSPEEDR_OSPEEDR10_Msk = 0x300000
	// Low speed
	GPIO_OSPEEDR_OSPEEDR10_LowSpeed = 0x0
	// Medium speed
	GPIO_OSPEEDR_OSPEEDR10_MediumSpeed = 0x1
	// High speed
	GPIO_OSPEEDR_OSPEEDR10_HighSpeed = 0x3
	// Position of OSPEEDR9 field.
	GPIO_OSPEEDR_OSPEEDR9_Pos = 0x12
	// Bit mask of OSPEEDR9 field.
	GPIO_OSPEEDR_OSPEEDR9_Msk = 0xc0000
	// Low speed
	GPIO_OSPEEDR_OSPEEDR9_LowSpeed = 0x0
	// Medium speed
	GPIO_OSPEEDR_OSPEEDR9_MediumSpeed = 0x1
	// High speed
	GPIO_OSPEEDR_OSPEEDR9_HighSpeed = 0x3
	// Position of OSPEEDR8 field.
	GPIO_OSPEEDR_OSPEEDR8_Pos = 0x10
	// Bit mask of OSPEEDR8 field.
	GPIO_OSPEEDR_OSPEEDR8_Msk = 0x30000
	// Low speed
	GPIO_OSPEEDR_OSPEEDR8_LowSpeed = 0x0
	// Medium speed
	GPIO_OSPEEDR_OSPEEDR8_MediumSpeed = 0x1
	// High speed
	GPIO_OSPEEDR_OSPEEDR8_HighSpeed = 0x3
	// Position of OSPEEDR7 field.
	GPIO_OSPEEDR_OSPEEDR7_Pos = 0xe
	// Bit mask of OSPEEDR7 field.
	GPIO_OSPEEDR_OSPEEDR7_Msk = 0xc000
	// Low speed
	GPIO_OSPEEDR_OSPEEDR7_LowSpeed = 0x0
	// Medium speed
	GPIO_OSPEEDR_OSPEEDR7_MediumSpeed = 0x1
	// High speed
	GPIO_OSPEEDR_OSPEEDR7_HighSpeed = 0x3
	// Position of OSPEEDR6 field.
	GPIO_OSPEEDR_OSPEEDR6_Pos = 0xc
	// Bit mask of OSPEEDR6 field.
	GPIO_OSPEEDR_OSPEEDR6_Msk = 0x3000
	// Low speed
	GPIO_OSPEEDR_OSPEEDR6_LowSpeed = 0x0
	// Medium speed
	GPIO_OSPEEDR_OSPEEDR6_MediumSpeed = 0x1
	// High speed
	GPIO_OSPEEDR_OSPEEDR6_HighSpeed = 0x3
	// Position of OSPEEDR5 field.
	GPIO_OSPEEDR_OSPEEDR5_Pos = 0xa
	// Bit mask of OSPEEDR5 field.
	GPIO_OSPEEDR_OSPEEDR5_Msk = 0xc00
	// Low speed
	GPIO_OSPEEDR_OSPEEDR5_LowSpeed = 0x0
	// Medium speed
	GPIO_OSPEEDR_OSPEEDR5_MediumSpeed = 0x1
	// High speed
	GPIO_OSPEEDR_OSPEEDR5_HighSpeed = 0x3
	// Position of OSPEEDR4 field.
	GPIO_OSPEEDR_OSPEEDR4_Pos = 0x8
	// Bit mask of OSPEEDR4 field.
	GPIO_OSPEEDR_OSPEEDR4_Msk = 0x300
	// Low speed
	GPIO_OSPEEDR_OSPEEDR4_LowSpeed = 0x0
	// Medium speed
	GPIO_OSPEEDR_OSPEEDR4_MediumSpeed = 0x1
	// High speed
	GPIO_OSPEEDR_OSPEEDR4_HighSpeed = 0x3
	// Position of OSPEEDR3 field.
	GPIO_OSPEEDR_OSPEEDR3_Pos = 0x6
	// Bit mask of OSPEEDR3 field.
	GPIO_OSPEEDR_OSPEEDR3_Msk = 0xc0
	// Low speed
	GPIO_OSPEEDR_OSPEEDR3_LowSpeed = 0x0
	// Medium speed
	GPIO_OSPEEDR_OSPEEDR3_MediumSpeed = 0x1
	// High speed
	GPIO_OSPEEDR_OSPEEDR3_HighSpeed = 0x3
	// Position of OSPEEDR2 field.
	GPIO_OSPEEDR_OSPEEDR2_Pos = 0x4
	// Bit mask of OSPEEDR2 field.
	GPIO_OSPEEDR_OSPEEDR2_Msk = 0x30
	// Low speed
	GPIO_OSPEEDR_OSPEEDR2_LowSpeed = 0x0
	// Medium speed
	GPIO_OSPEEDR_OSPEEDR2_MediumSpeed = 0x1
	// High speed
	GPIO_OSPEEDR_OSPEEDR2_HighSpeed = 0x3
	// Position of OSPEEDR1 field.
	GPIO_OSPEEDR_OSPEEDR1_Pos = 0x2
	// Bit mask of OSPEEDR1 field.
	GPIO_OSPEEDR_OSPEEDR1_Msk = 0xc
	// Low speed
	GPIO_OSPEEDR_OSPEEDR1_LowSpeed = 0x0
	// Medium speed
	GPIO_OSPEEDR_OSPEEDR1_MediumSpeed = 0x1
	// High speed
	GPIO_OSPEEDR_OSPEEDR1_HighSpeed = 0x3
	// Position of OSPEEDR0 field.
	GPIO_OSPEEDR_OSPEEDR0_Pos = 0x0
	// Bit mask of OSPEEDR0 field.
	GPIO_OSPEEDR_OSPEEDR0_Msk = 0x3
	// Low speed
	GPIO_OSPEEDR_OSPEEDR0_LowSpeed = 0x0
	// Medium speed
	GPIO_OSPEEDR_OSPEEDR0_MediumSpeed = 0x1
	// High speed
	GPIO_OSPEEDR_OSPEEDR0_HighSpeed = 0x3

	// PUPDR: GPIO port pull-up/pull-down register
	// Position of PUPDR15 field.
	GPIO_PUPDR_PUPDR15_Pos = 0x1e
	// Bit mask of PUPDR15 field.
	GPIO_PUPDR_PUPDR15_Msk = 0xc0000000
	// No pull-up, pull-down
	GPIO_PUPDR_PUPDR15_Floating = 0x0
	// Pull-up
	GPIO_PUPDR_PUPDR15_PullUp = 0x1
	// Pull-down
	GPIO_PUPDR_PUPDR15_PullDown = 0x2
	// Position of PUPDR14 field.
	GPIO_PUPDR_PUPDR14_Pos = 0x1c
	// Bit mask of PUPDR14 field.
	GPIO_PUPDR_PUPDR14_Msk = 0x30000000
	// No pull-up, pull-down
	GPIO_PUPDR_PUPDR14_Floating = 0x0
	// Pull-up
	GPIO_PUPDR_PUPDR14_PullUp = 0x1
	// Pull-down
	GPIO_PUPDR_PUPDR14_PullDown = 0x2
	// Position of PUPDR13 field.
	GPIO_PUPDR_PUPDR13_Pos = 0x1a
	// Bit mask of PUPDR13 field.
	GPIO_PUPDR_PUPDR13_Msk = 0xc000000
	// No pull-up, pull-down
	GPIO_PUPDR_PUPDR13_Floating = 0x0
	// Pull-up
	GPIO_PUPDR_PUPDR13_PullUp = 0x1
	// Pull-down
	GPIO_PUPDR_PUPDR13_PullDown = 0x2
	// Position of PUPDR12 field.
	GPIO_PUPDR_PUPDR12_Pos = 0x18
	// Bit mask of PUPDR12 field.
	GPIO_PUPDR_PUPDR12_Msk = 0x3000000
	// No pull-up, pull-down
	GPIO_PUPDR_PUPDR12_Floating = 0x0
	// Pull-up
	GPIO_PUPDR_PUPDR12_PullUp = 0x1
	// Pull-down
	GPIO_PUPDR_PUPDR12_PullDown = 0x2
	// Position of PUPDR11 field.
	GPIO_PUPDR_PUPDR11_Pos = 0x16
	// Bit mask of PUPDR11 field.
	GPIO_PUPDR_PUPDR11_Msk = 0xc00000
	// No pull-up, pull-down
	GPIO_PUPDR_PUPDR11_Floating = 0x0
	// Pull-up
	GPIO_PUPDR_PUPDR11_PullUp = 0x1
	// Pull-down
	GPIO_PUPDR_PUPDR11_PullDown = 0x2
	// Position of PUPDR10 field.
	GPIO_PUPDR_PUPDR10_Pos = 0x14
	// Bit mask of PUPDR10 field.
	GPIO_PUPDR_PUPDR10_Msk = 0x300000
	// No pull-up, pull-down
	GPIO_PUPDR_PUPDR10_Floating = 0x0
	// Pull-up
	GPIO_PUPDR_PUPDR10_PullUp = 0x1
	// Pull-down
	GPIO_PUPDR_PUPDR10_PullDown = 0x2
	// Position of PUPDR9 field.
	GPIO_PUPDR_PUPDR9_Pos = 0x12
	// Bit mask of PUPDR9 field.
	GPIO_PUPDR_PUPDR9_Msk = 0xc0000
	// No pull-up, pull-down
	GPIO_PUPDR_PUPDR9_Floating = 0x0
	// Pull-up
	GPIO_PUPDR_PUPDR9_PullUp = 0x1
	// Pull-down
	GPIO_PUPDR_PUPDR9_PullDown = 0x2
	// Position of PUPDR8 field.
	GPIO_PUPDR_PUPDR8_Pos = 0x10
	// Bit mask of PUPDR8 field.
	GPIO_PUPDR_PUPDR8_Msk = 0x30000
	// No pull-up, pull-down
	GPIO_PUPDR_PUPDR8_Floating = 0x0
	// Pull-up
	GPIO_PUPDR_PUPDR8_PullUp = 0x1
	// Pull-down
	GPIO_PUPDR_PUPDR8_PullDown = 0x2
	// Position of PUPDR7 field.
	GPIO_PUPDR_PUPDR7_Pos = 0xe
	// Bit mask of PUPDR7 field.
	GPIO_PUPDR_PUPDR7_Msk = 0xc000
	// No pull-up, pull-down
	GPIO_PUPDR_PUPDR7_Floating = 0x0
	// Pull-up
	GPIO_PUPDR_PUPDR7_PullUp = 0x1
	// Pull-down
	GPIO_PUPDR_PUPDR7_PullDown = 0x2
	// Position of PUPDR6 field.
	GPIO_PUPDR_PUPDR6_Pos = 0xc
	// Bit mask of PUPDR6 field.
	GPIO_PUPDR_PUPDR6_Msk = 0x3000
	// No pull-up, pull-down
	GPIO_PUPDR_PUPDR6_Floating = 0x0
	// Pull-up
	GPIO_PUPDR_PUPDR6_PullUp = 0x1
	// Pull-down
	GPIO_PUPDR_PUPDR6_PullDown = 0x2
	// Position of PUPDR5 field.
	GPIO_PUPDR_PUPDR5_Pos = 0xa
	// Bit mask of PUPDR5 field.
	GPIO_PUPDR_PUPDR5_Msk = 0xc00
	// No pull-up, pull-down
	GPIO_PUPDR_PUPDR5_Floating = 0x0
	// Pull-up
	GPIO_PUPDR_PUPDR5_PullUp = 0x1
	// Pull-down
	GPIO_PUPDR_PUPDR5_PullDown = 0x2
	// Position of PUPDR4 field.
	GPIO_PUPDR_PUPDR4_Pos = 0x8
	// Bit mask of PUPDR4 field.
	GPIO_PUPDR_PUPDR4_Msk = 0x300
	// No pull-up, pull-down
	GPIO_PUPDR_PUPDR4_Floating = 0x0
	// Pull-up
	GPIO_PUPDR_PUPDR4_PullUp = 0x1
	// Pull-down
	GPIO_PUPDR_PUPDR4_PullDown = 0x2
	// Position of PUPDR3 field.
	GPIO_PUPDR_PUPDR3_Pos = 0x6
	// Bit mask of PUPDR3 field.
	GPIO_PUPDR_PUPDR3_Msk = 0xc0
	// No pull-up, pull-down
	GPIO_PUPDR_PUPDR3_Floating = 0x0
	// Pull-up
	GPIO_PUPDR_PUPDR3_PullUp = 0x1
	// Pull-down
	GPIO_PUPDR_PUPDR3_PullDown = 0x2
	// Position of PUPDR2 field.
	GPIO_PUPDR_PUPDR2_Pos = 0x4
	// Bit mask of PUPDR2 field.
	GPIO_PUPDR_PUPDR2_Msk = 0x30
	// No pull-up, pull-down
	GPIO_PUPDR_PUPDR2_Floating = 0x0
	// Pull-up
	GPIO_PUPDR_PUPDR2_PullUp = 0x1
	// Pull-down
	GPIO_PUPDR_PUPDR2_PullDown = 0x2
	// Position of PUPDR1 field.
	GPIO_PUPDR_PUPDR1_Pos = 0x2
	// Bit mask of PUPDR1 field.
	GPIO_PUPDR_PUPDR1_Msk = 0xc
	// No pull-up, pull-down
	GPIO_PUPDR_PUPDR1_Floating = 0x0
	// Pull-up
	GPIO_PUPDR_PUPDR1_PullUp = 0x1
	// Pull-down
	GPIO_PUPDR_PUPDR1_PullDown = 0x2
	// Position of PUPDR0 field.
	GPIO_PUPDR_PUPDR0_Pos = 0x0
	// Bit mask of PUPDR0 field.
	GPIO_PUPDR_PUPDR0_Msk = 0x3
	// No pull-up, pull-down
	GPIO_PUPDR_PUPDR0_Floating = 0x0
	// Pull-up
	GPIO_PUPDR_PUPDR0_PullUp = 0x1
	// Pull-down
	GPIO_PUPDR_PUPDR0_PullDown = 0x2

	// IDR: GPIO port input data register
	// Position of IDR15 field.
	GPIO_IDR_IDR15_Pos = 0xf
	// Bit mask of IDR15 field.
	GPIO_IDR_IDR15_Msk = 0x8000
	// Bit IDR15.
	GPIO_IDR_IDR15 = 0x8000
	// Input is logic high
	GPIO_IDR_IDR15_High = 0x1
	// Input is logic low
	GPIO_IDR_IDR15_Low = 0x0
	// Position of IDR14 field.
	GPIO_IDR_IDR14_Pos = 0xe
	// Bit mask of IDR14 field.
	GPIO_IDR_IDR14_Msk = 0x4000
	// Bit IDR14.
	GPIO_IDR_IDR14 = 0x4000
	// Input is logic high
	GPIO_IDR_IDR14_High = 0x1
	// Input is logic low
	GPIO_IDR_IDR14_Low = 0x0
	// Position of IDR13 field.
	GPIO_IDR_IDR13_Pos = 0xd
	// Bit mask of IDR13 field.
	GPIO_IDR_IDR13_Msk = 0x2000
	// Bit IDR13.
	GPIO_IDR_IDR13 = 0x2000
	// Input is logic high
	GPIO_IDR_IDR13_High = 0x1
	// Input is logic low
	GPIO_IDR_IDR13_Low = 0x0
	// Position of IDR12 field.
	GPIO_IDR_IDR12_Pos = 0xc
	// Bit mask of IDR12 field.
	GPIO_IDR_IDR12_Msk = 0x1000
	// Bit IDR12.
	GPIO_IDR_IDR12 = 0x1000
	// Input is logic high
	GPIO_IDR_IDR12_High = 0x1
	// Input is logic low
	GPIO_IDR_IDR12_Low = 0x0
	// Position of IDR11 field.
	GPIO_IDR_IDR11_Pos = 0xb
	// Bit mask of IDR11 field.
	GPIO_IDR_IDR11_Msk = 0x800
	// Bit IDR11.
	GPIO_IDR_IDR11 = 0x800
	// Input is logic high
	GPIO_IDR_IDR11_High = 0x1
	// Input is logic low
	GPIO_IDR_IDR11_Low = 0x0
	// Position of IDR10 field.
	GPIO_IDR_IDR10_Pos = 0xa
	// Bit mask of IDR10 field.
	GPIO_IDR_IDR10_Msk = 0x400
	// Bit IDR10.
	GPIO_IDR_IDR10 = 0x400
	// Input is logic high
	GPIO_IDR_IDR10_High = 0x1
	// Input is logic low
	GPIO_IDR_IDR10_Low = 0x0
	// Position of IDR9 field.
	GPIO_IDR_IDR9_Pos = 0x9
	// Bit mask of IDR9 field.
	GPIO_IDR_IDR9_Msk = 0x200
	// Bit IDR9.
	GPIO_IDR_IDR9 = 0x200
	// Input is logic high
	GPIO_IDR_IDR9_High = 0x1
	// Input is logic low
	GPIO_IDR_IDR9_Low = 0x0
	// Position of IDR8 field.
	GPIO_IDR_IDR8_Pos = 0x8
	// Bit mask of IDR8 field.
	GPIO_IDR_IDR8_Msk = 0x100
	// Bit IDR8.
	GPIO_IDR_IDR8 = 0x100
	// Input is logic high
	GPIO_IDR_IDR8_High = 0x1
	// Input is logic low
	GPIO_IDR_IDR8_Low = 0x0
	// Position of IDR7 field.
	GPIO_IDR_IDR7_Pos = 0x7
	// Bit mask of IDR7 field.
	GPIO_IDR_IDR7_Msk = 0x80
	// Bit IDR7.
	GPIO_IDR_IDR7 = 0x80
	// Input is logic high
	GPIO_IDR_IDR7_High = 0x1
	// Input is logic low
	GPIO_IDR_IDR7_Low = 0x0
	// Position of IDR6 field.
	GPIO_IDR_IDR6_Pos = 0x6
	// Bit mask of IDR6 field.
	GPIO_IDR_IDR6_Msk = 0x40
	// Bit IDR6.
	GPIO_IDR_IDR6 = 0x40
	// Input is logic high
	GPIO_IDR_IDR6_High = 0x1
	// Input is logic low
	GPIO_IDR_IDR6_Low = 0x0
	// Position of IDR5 field.
	GPIO_IDR_IDR5_Pos = 0x5
	// Bit mask of IDR5 field.
	GPIO_IDR_IDR5_Msk = 0x20
	// Bit IDR5.
	GPIO_IDR_IDR5 = 0x20
	// Input is logic high
	GPIO_IDR_IDR5_High = 0x1
	// Input is logic low
	GPIO_IDR_IDR5_Low = 0x0
	// Position of IDR4 field.
	GPIO_IDR_IDR4_Pos = 0x4
	// Bit mask of IDR4 field.
	GPIO_IDR_IDR4_Msk = 0x10
	// Bit IDR4.
	GPIO_IDR_IDR4 = 0x10
	// Input is logic high
	GPIO_IDR_IDR4_High = 0x1
	// Input is logic low
	GPIO_IDR_IDR4_Low = 0x0
	// Position of IDR3 field.
	GPIO_IDR_IDR3_Pos = 0x3
	// Bit mask of IDR3 field.
	GPIO_IDR_IDR3_Msk = 0x8
	// Bit IDR3.
	GPIO_IDR_IDR3 = 0x8
	// Input is logic high
	GPIO_IDR_IDR3_High = 0x1
	// Input is logic low
	GPIO_IDR_IDR3_Low = 0x0
	// Position of IDR2 field.
	GPIO_IDR_IDR2_Pos = 0x2
	// Bit mask of IDR2 field.
	GPIO_IDR_IDR2_Msk = 0x4
	// Bit IDR2.
	GPIO_IDR_IDR2 = 0x4
	// Input is logic high
	GPIO_IDR_IDR2_High = 0x1
	// Input is logic low
	GPIO_IDR_IDR2_Low = 0x0
	// Position of IDR1 field.
	GPIO_IDR_IDR1_Pos = 0x1
	// Bit mask of IDR1 field.
	GPIO_IDR_IDR1_Msk = 0x2
	// Bit IDR1.
	GPIO_IDR_IDR1 = 0x2
	// Input is logic high
	GPIO_IDR_IDR1_High = 0x1
	// Input is logic low
	GPIO_IDR_IDR1_Low = 0x0
	// Position of IDR0 field.
	GPIO_IDR_IDR0_Pos = 0x0
	// Bit mask of IDR0 field.
	GPIO_IDR_IDR0_Msk = 0x1
	// Bit IDR0.
	GPIO_IDR_IDR0 = 0x1
	// Input is logic high
	GPIO_IDR_IDR0_High = 0x1
	// Input is logic low
	GPIO_IDR_IDR0_Low = 0x0

	// ODR: GPIO port output data register
	// Position of ODR15 field.
	GPIO_ODR_ODR15_Pos = 0xf
	// Bit mask of ODR15 field.
	GPIO_ODR_ODR15_Msk = 0x8000
	// Bit ODR15.
	GPIO_ODR_ODR15 = 0x8000
	// Set output to logic high
	GPIO_ODR_ODR15_High = 0x1
	// Set output to logic low
	GPIO_ODR_ODR15_Low = 0x0
	// Position of ODR14 field.
	GPIO_ODR_ODR14_Pos = 0xe
	// Bit mask of ODR14 field.
	GPIO_ODR_ODR14_Msk = 0x4000
	// Bit ODR14.
	GPIO_ODR_ODR14 = 0x4000
	// Set output to logic high
	GPIO_ODR_ODR14_High = 0x1
	// Set output to logic low
	GPIO_ODR_ODR14_Low = 0x0
	// Position of ODR13 field.
	GPIO_ODR_ODR13_Pos = 0xd
	// Bit mask of ODR13 field.
	GPIO_ODR_ODR13_Msk = 0x2000
	// Bit ODR13.
	GPIO_ODR_ODR13 = 0x2000
	// Set output to logic high
	GPIO_ODR_ODR13_High = 0x1
	// Set output to logic low
	GPIO_ODR_ODR13_Low = 0x0
	// Position of ODR12 field.
	GPIO_ODR_ODR12_Pos = 0xc
	// Bit mask of ODR12 field.
	GPIO_ODR_ODR12_Msk = 0x1000
	// Bit ODR12.
	GPIO_ODR_ODR12 = 0x1000
	// Set output to logic high
	GPIO_ODR_ODR12_High = 0x1
	// Set output to logic low
	GPIO_ODR_ODR12_Low = 0x0
	// Position of ODR11 field.
	GPIO_ODR_ODR11_Pos = 0xb
	// Bit mask of ODR11 field.
	GPIO_ODR_ODR11_Msk = 0x800
	// Bit ODR11.
	GPIO_ODR_ODR11 = 0x800
	// Set output to logic high
	GPIO_ODR_ODR11_High = 0x1
	// Set output to logic low
	GPIO_ODR_ODR11_Low = 0x0
	// Position of ODR10 field.
	GPIO_ODR_ODR10_Pos = 0xa
	// Bit mask of ODR10 field.
	GPIO_ODR_ODR10_Msk = 0x400
	// Bit ODR10.
	GPIO_ODR_ODR10 = 0x400
	// Set output to logic high
	GPIO_ODR_ODR10_High = 0x1
	// Set output to logic low
	GPIO_ODR_ODR10_Low = 0x0
	// Position of ODR9 field.
	GPIO_ODR_ODR9_Pos = 0x9
	// Bit mask of ODR9 field.
	GPIO_ODR_ODR9_Msk = 0x200
	// Bit ODR9.
	GPIO_ODR_ODR9 = 0x200
	// Set output to logic high
	GPIO_ODR_ODR9_High = 0x1
	// Set output to logic low
	GPIO_ODR_ODR9_Low = 0x0
	// Position of ODR8 field.
	GPIO_ODR_ODR8_Pos = 0x8
	// Bit mask of ODR8 field.
	GPIO_ODR_ODR8_Msk = 0x100
	// Bit ODR8.
	GPIO_ODR_ODR8 = 0x100
	// Set output to logic high
	GPIO_ODR_ODR8_High = 0x1
	// Set output to logic low
	GPIO_ODR_ODR8_Low = 0x0
	// Position of ODR7 field.
	GPIO_ODR_ODR7_Pos = 0x7
	// Bit mask of ODR7 field.
	GPIO_ODR_ODR7_Msk = 0x80
	// Bit ODR7.
	GPIO_ODR_ODR7 = 0x80
	// Set output to logic high
	GPIO_ODR_ODR7_High = 0x1
	// Set output to logic low
	GPIO_ODR_ODR7_Low = 0x0
	// Position of ODR6 field.
	GPIO_ODR_ODR6_Pos = 0x6
	// Bit mask of ODR6 field.
	GPIO_ODR_ODR6_Msk = 0x40
	// Bit ODR6.
	GPIO_ODR_ODR6 = 0x40
	// Set output to logic high
	GPIO_ODR_ODR6_High = 0x1
	// Set output to logic low
	GPIO_ODR_ODR6_Low = 0x0
	// Position of ODR5 field.
	GPIO_ODR_ODR5_Pos = 0x5
	// Bit mask of ODR5 field.
	GPIO_ODR_ODR5_Msk = 0x20
	// Bit ODR5.
	GPIO_ODR_ODR5 = 0x20
	// Set output to logic high
	GPIO_ODR_ODR5_High = 0x1
	// Set output to logic low
	GPIO_ODR_ODR5_Low = 0x0
	// Position of ODR4 field.
	GPIO_ODR_ODR4_Pos = 0x4
	// Bit mask of ODR4 field.
	GPIO_ODR_ODR4_Msk = 0x10
	// Bit ODR4.
	GPIO_ODR_ODR4 = 0x10
	// Set output to logic high
	GPIO_ODR_ODR4_High = 0x1
	// Set output to logic low
	GPIO_ODR_ODR4_Low = 0x0
	// Position of ODR3 field.
	GPIO_ODR_ODR3_Pos = 0x3
	// Bit mask of ODR3 field.
	GPIO_ODR_ODR3_Msk = 0x8
	// Bit ODR3.
	GPIO_ODR_ODR3 = 0x8
	// Set output to logic high
	GPIO_ODR_ODR3_High = 0x1
	// Set output to logic low
	GPIO_ODR_ODR3_Low = 0x0
	// Position of ODR2 field.
	GPIO_ODR_ODR2_Pos = 0x2
	// Bit mask of ODR2 field.
	GPIO_ODR_ODR2_Msk = 0x4
	// Bit ODR2.
	GPIO_ODR_ODR2 = 0x4
	// Set output to logic high
	GPIO_ODR_ODR2_High = 0x1
	// Set output to logic low
	GPIO_ODR_ODR2_Low = 0x0
	// Position of ODR1 field.
	GPIO_ODR_ODR1_Pos = 0x1
	// Bit mask of ODR1 field.
	GPIO_ODR_ODR1_Msk = 0x2
	// Bit ODR1.
	GPIO_ODR_ODR1 = 0x2
	// Set output to logic high
	GPIO_ODR_ODR1_High = 0x1
	// Set output to logic low
	GPIO_ODR_ODR1_Low = 0x0
	// Position of ODR0 field.
	GPIO_ODR_ODR0_Pos = 0x0
	// Bit mask of ODR0 field.
	GPIO_ODR_ODR0_Msk = 0x1
	// Bit ODR0.
	GPIO_ODR_ODR0 = 0x1
	// Set output to logic high
	GPIO_ODR_ODR0_High = 0x1
	// Set output to logic low
	GPIO_ODR_ODR0_Low = 0x0

	// BSRR: GPIO port bit set/reset register
	// Position of BR15 field.
	GPIO_BSRR_BR15_Pos = 0x1f
	// Bit mask of BR15 field.
	GPIO_BSRR_BR15_Msk = 0x80000000
	// Bit BR15.
	GPIO_BSRR_BR15 = 0x80000000
	// Resets the corresponding ODRx bit
	GPIO_BSRR_BR15_Reset = 0x1
	// Position of BR14 field.
	GPIO_BSRR_BR14_Pos = 0x1e
	// Bit mask of BR14 field.
	GPIO_BSRR_BR14_Msk = 0x40000000
	// Bit BR14.
	GPIO_BSRR_BR14 = 0x40000000
	// Resets the corresponding ODRx bit
	GPIO_BSRR_BR14_Reset = 0x1
	// Position of BR13 field.
	GPIO_BSRR_BR13_Pos = 0x1d
	// Bit mask of BR13 field.
	GPIO_BSRR_BR13_Msk = 0x20000000
	// Bit BR13.
	GPIO_BSRR_BR13 = 0x20000000
	// Resets the corresponding ODRx bit
	GPIO_BSRR_BR13_Reset = 0x1
	// Position of BR12 field.
	GPIO_BSRR_BR12_Pos = 0x1c
	// Bit mask of BR12 field.
	GPIO_BSRR_BR12_Msk = 0x10000000
	// Bit BR12.
	GPIO_BSRR_BR12 = 0x10000000
	// Resets the corresponding ODRx bit
	GPIO_BSRR_BR12_Reset = 0x1
	// Position of BR11 field.
	GPIO_BSRR_BR11_Pos = 0x1b
	// Bit mask of BR11 field.
	GPIO_BSRR_BR11_Msk = 0x8000000
	// Bit BR11.
	GPIO_BSRR_BR11 = 0x8000000
	// Resets the corresponding ODRx bit
	GPIO_BSRR_BR11_Reset = 0x1
	// Position of BR10 field.
	GPIO_BSRR_BR10_Pos = 0x1a
	// Bit mask of BR10 field.
	GPIO_BSRR_BR10_Msk = 0x4000000
	// Bit BR10.
	GPIO_BSRR_BR10 = 0x4000000
	// Resets the corresponding ODRx bit
	GPIO_BSRR_BR10_Reset = 0x1
	// Position of BR9 field.
	GPIO_BSRR_BR9_Pos = 0x19
	// Bit mask of BR9 field.
	GPIO_BSRR_BR9_Msk = 0x2000000
	// Bit BR9.
	GPIO_BSRR_BR9 = 0x2000000
	// Resets the corresponding ODRx bit
	GPIO_BSRR_BR9_Reset = 0x1
	// Position of BR8 field.
	GPIO_BSRR_BR8_Pos = 0x18
	// Bit mask of BR8 field.
	GPIO_BSRR_BR8_Msk = 0x1000000
	// Bit BR8.
	GPIO_BSRR_BR8 = 0x1000000
	// Resets the corresponding ODRx bit
	GPIO_BSRR_BR8_Reset = 0x1
	// Position of BR7 field.
	GPIO_BSRR_BR7_Pos = 0x17
	// Bit mask of BR7 field.
	GPIO_BSRR_BR7_Msk = 0x800000
	// Bit BR7.
	GPIO_BSRR_BR7 = 0x800000
	// Resets the corresponding ODRx bit
	GPIO_BSRR_BR7_Reset = 0x1
	// Position of BR6 field.
	GPIO_BSRR_BR6_Pos = 0x16
	// Bit mask of BR6 field.
	GPIO_BSRR_BR6_Msk = 0x400000
	// Bit BR6.
	GPIO_BSRR_BR6 = 0x400000
	// Resets the corresponding ODRx bit
	GPIO_BSRR_BR6_Reset = 0x1
	// Position of BR5 field.
	GPIO_BSRR_BR5_Pos = 0x15
	// Bit mask of BR5 field.
	GPIO_BSRR_BR5_Msk = 0x200000
	// Bit BR5.
	GPIO_BSRR_BR5 = 0x200000
	// Resets the corresponding ODRx bit
	GPIO_BSRR_BR5_Reset = 0x1
	// Position of BR4 field.
	GPIO_BSRR_BR4_Pos = 0x14
	// Bit mask of BR4 field.
	GPIO_BSRR_BR4_Msk = 0x100000
	// Bit BR4.
	GPIO_BSRR_BR4 = 0x100000
	// Resets the corresponding ODRx bit
	GPIO_BSRR_BR4_Reset = 0x1
	// Position of BR3 field.
	GPIO_BSRR_BR3_Pos = 0x13
	// Bit mask of BR3 field.
	GPIO_BSRR_BR3_Msk = 0x80000
	// Bit BR3.
	GPIO_BSRR_BR3 = 0x80000
	// Resets the corresponding ODRx bit
	GPIO_BSRR_BR3_Reset = 0x1
	// Position of BR2 field.
	GPIO_BSRR_BR2_Pos = 0x12
	// Bit mask of BR2 field.
	GPIO_BSRR_BR2_Msk = 0x40000
	// Bit BR2.
	GPIO_BSRR_BR2 = 0x40000
	// Resets the corresponding ODRx bit
	GPIO_BSRR_BR2_Reset = 0x1
	// Position of BR1 field.
	GPIO_BSRR_BR1_Pos = 0x11
	// Bit mask of BR1 field.
	GPIO_BSRR_BR1_Msk = 0x20000
	// Bit BR1.
	GPIO_BSRR_BR1 = 0x20000
	// Resets the corresponding ODRx bit
	GPIO_BSRR_BR1_Reset = 0x1
	// Position of BR0 field.
	GPIO_BSRR_BR0_Pos = 0x10
	// Bit mask of BR0 field.
	GPIO_BSRR_BR0_Msk = 0x10000
	// Bit BR0.
	GPIO_BSRR_BR0 = 0x10000
	// Resets the corresponding ODRx bit
	GPIO_BSRR_BR0_Reset = 0x1
	// Position of BS15 field.
	GPIO_BSRR_BS15_Pos = 0xf
	// Bit mask of BS15 field.
	GPIO_BSRR_BS15_Msk = 0x8000
	// Bit BS15.
	GPIO_BSRR_BS15 = 0x8000
	// Sets the corresponding ODRx bit
	GPIO_BSRR_BS15_Set = 0x1
	// Position of BS14 field.
	GPIO_BSRR_BS14_Pos = 0xe
	// Bit mask of BS14 field.
	GPIO_BSRR_BS14_Msk = 0x4000
	// Bit BS14.
	GPIO_BSRR_BS14 = 0x4000
	// Sets the corresponding ODRx bit
	GPIO_BSRR_BS14_Set = 0x1
	// Position of BS13 field.
	GPIO_BSRR_BS13_Pos = 0xd
	// Bit mask of BS13 field.
	GPIO_BSRR_BS13_Msk = 0x2000
	// Bit BS13.
	GPIO_BSRR_BS13 = 0x2000
	// Sets the corresponding ODRx bit
	GPIO_BSRR_BS13_Set = 0x1
	// Position of BS12 field.
	GPIO_BSRR_BS12_Pos = 0xc
	// Bit mask of BS12 field.
	GPIO_BSRR_BS12_Msk = 0x1000
	// Bit BS12.
	GPIO_BSRR_BS12 = 0x1000
	// Sets the corresponding ODRx bit
	GPIO_BSRR_BS12_Set = 0x1
	// Position of BS11 field.
	GPIO_BSRR_BS11_Pos = 0xb
	// Bit mask of BS11 field.
	GPIO_BSRR_BS11_Msk = 0x800
	// Bit BS11.
	GPIO_BSRR_BS11 = 0x800
	// Sets the corresponding ODRx bit
	GPIO_BSRR_BS11_Set = 0x1
	// Position of BS10 field.
	GPIO_BSRR_BS10_Pos = 0xa
	// Bit mask of BS10 field.
	GPIO_BSRR_BS10_Msk = 0x400
	// Bit BS10.
	GPIO_BSRR_BS10 = 0x400
	// Sets the corresponding ODRx bit
	GPIO_BSRR_BS10_Set = 0x1
	// Position of BS9 field.
	GPIO_BSRR_BS9_Pos = 0x9
	// Bit mask of BS9 field.
	GPIO_BSRR_BS9_Msk = 0x200
	// Bit BS9.
	GPIO_BSRR_BS9 = 0x200
	// Sets the corresponding ODRx bit
	GPIO_BSRR_BS9_Set = 0x1
	// Position of BS8 field.
	GPIO_BSRR_BS8_Pos = 0x8
	// Bit mask of BS8 field.
	GPIO_BSRR_BS8_Msk = 0x100
	// Bit BS8.
	GPIO_BSRR_BS8 = 0x100
	// Sets the corresponding ODRx bit
	GPIO_BSRR_BS8_Set = 0x1
	// Position of BS7 field.
	GPIO_BSRR_BS7_Pos = 0x7
	// Bit mask of BS7 field.
	GPIO_BSRR_BS7_Msk = 0x80
	// Bit BS7.
	GPIO_BSRR_BS7 = 0x80
	// Sets the corresponding ODRx bit
	GPIO_BSRR_BS7_Set = 0x1
	// Position of BS6 field.
	GPIO_BSRR_BS6_Pos = 0x6
	// Bit mask of BS6 field.
	GPIO_BSRR_BS6_Msk = 0x40
	// Bit BS6.
	GPIO_BSRR_BS6 = 0x40
	// Sets the corresponding ODRx bit
	GPIO_BSRR_BS6_Set = 0x1
	// Position of BS5 field.
	GPIO_BSRR_BS5_Pos = 0x5
	// Bit mask of BS5 field.
	GPIO_BSRR_BS5_Msk = 0x20
	// Bit BS5.
	GPIO_BSRR_BS5 = 0x20
	// Sets the corresponding ODRx bit
	GPIO_BSRR_BS5_Set = 0x1
	// Position of BS4 field.
	GPIO_BSRR_BS4_Pos = 0x4
	// Bit mask of BS4 field.
	GPIO_BSRR_BS4_Msk = 0x10
	// Bit BS4.
	GPIO_BSRR_BS4 = 0x10
	// Sets the corresponding ODRx bit
	GPIO_BSRR_BS4_Set = 0x1
	// Position of BS3 field.
	GPIO_BSRR_BS3_Pos = 0x3
	// Bit mask of BS3 field.
	GPIO_BSRR_BS3_Msk = 0x8
	// Bit BS3.
	GPIO_BSRR_BS3 = 0x8
	// Sets the corresponding ODRx bit
	GPIO_BSRR_BS3_Set = 0x1
	// Position of BS2 field.
	GPIO_BSRR_BS2_Pos = 0x2
	// Bit mask of BS2 field.
	GPIO_BSRR_BS2_Msk = 0x4
	// Bit BS2.
	GPIO_BSRR_BS2 = 0x4
	// Sets the corresponding ODRx bit
	GPIO_BSRR_BS2_Set = 0x1
	// Position of BS1 field.
	GPIO_BSRR_BS1_Pos = 0x1
	// Bit mask of BS1 field.
	GPIO_BSRR_BS1_Msk = 0x2
	// Bit BS1.
	GPIO_BSRR_BS1 = 0x2
	// Sets the corresponding ODRx bit
	GPIO_BSRR_BS1_Set = 0x1
	// Position of BS0 field.
	GPIO_BSRR_BS0_Pos = 0x0
	// Bit mask of BS0 field.
	GPIO_BSRR_BS0_Msk = 0x1
	// Bit BS0.
	GPIO_BSRR_BS0 = 0x1
	// Sets the corresponding ODRx bit
	GPIO_BSRR_BS0_Set = 0x1

	// LCKR: GPIO port configuration lock register
	// Position of LCKK field.
	GPIO_LCKR_LCKK_Pos = 0x10
	// Bit mask of LCKK field.
	GPIO_LCKR_LCKK_Msk = 0x10000
	// Bit LCKK.
	GPIO_LCKR_LCKK = 0x10000
	// Port configuration lock key not active
	GPIO_LCKR_LCKK_NotActive = 0x0
	// Port configuration lock key active
	GPIO_LCKR_LCKK_Active = 0x1
	// Position of LCK15 field.
	GPIO_LCKR_LCK15_Pos = 0xf
	// Bit mask of LCK15 field.
	GPIO_LCKR_LCK15_Msk = 0x8000
	// Bit LCK15.
	GPIO_LCKR_LCK15 = 0x8000
	// Port configuration not locked
	GPIO_LCKR_LCK15_Unlocked = 0x0
	// Port configuration locked
	GPIO_LCKR_LCK15_Locked = 0x1
	// Position of LCK14 field.
	GPIO_LCKR_LCK14_Pos = 0xe
	// Bit mask of LCK14 field.
	GPIO_LCKR_LCK14_Msk = 0x4000
	// Bit LCK14.
	GPIO_LCKR_LCK14 = 0x4000
	// Port configuration not locked
	GPIO_LCKR_LCK14_Unlocked = 0x0
	// Port configuration locked
	GPIO_LCKR_LCK14_Locked = 0x1
	// Position of LCK13 field.
	GPIO_LCKR_LCK13_Pos = 0xd
	// Bit mask of LCK13 field.
	GPIO_LCKR_LCK13_Msk = 0x2000
	// Bit LCK13.
	GPIO_LCKR_LCK13 = 0x2000
	// Port configuration not locked
	GPIO_LCKR_LCK13_Unlocked = 0x0
	// Port configuration locked
	GPIO_LCKR_LCK13_Locked = 0x1
	// Position of LCK12 field.
	GPIO_LCKR_LCK12_Pos = 0xc
	// Bit mask of LCK12 field.
	GPIO_LCKR_LCK12_Msk = 0x1000
	// Bit LCK12.
	GPIO_LCKR_LCK12 = 0x1000
	// Port configuration not locked
	GPIO_LCKR_LCK12_Unlocked = 0x0
	// Port configuration locked
	GPIO_LCKR_LCK12_Locked = 0x1
	// Position of LCK11 field.
	GPIO_LCKR_LCK11_Pos = 0xb
	// Bit mask of LCK11 field.
	GPIO_LCKR_LCK11_Msk = 0x800
	// Bit LCK11.
	GPIO_LCKR_LCK11 = 0x800
	// Port configuration not locked
	GPIO_LCKR_LCK11_Unlocked = 0x0
	// Port configuration locked
	GPIO_LCKR_LCK11_Locked = 0x1
	// Position of LCK10 field.
	GPIO_LCKR_LCK10_Pos = 0xa
	// Bit mask of LCK10 field.
	GPIO_LCKR_LCK10_Msk = 0x400
	// Bit LCK10.
	GPIO_LCKR_LCK10 = 0x400
	// Port configuration not locked
	GPIO_LCKR_LCK10_Unlocked = 0x0
	// Port configuration locked
	GPIO_LCKR_LCK10_Locked = 0x1
	// Position of LCK9 field.
	GPIO_LCKR_LCK9_Pos = 0x9
	// Bit mask of LCK9 field.
	GPIO_LCKR_LCK9_Msk = 0x200
	// Bit LCK9.
	GPIO_LCKR_LCK9 = 0x200
	// Port configuration not locked
	GPIO_LCKR_LCK9_Unlocked = 0x0
	// Port configuration locked
	GPIO_LCKR_LCK9_Locked = 0x1
	// Position of LCK8 field.
	GPIO_LCKR_LCK8_Pos = 0x8
	// Bit mask of LCK8 field.
	GPIO_LCKR_LCK8_Msk = 0x100
	// Bit LCK8.
	GPIO_LCKR_LCK8 = 0x100
	// Port configuration not locked
	GPIO_LCKR_LCK8_Unlocked = 0x0
	// Port configuration locked
	GPIO_LCKR_LCK8_Locked = 0x1
	// Position of LCK7 field.
	GPIO_LCKR_LCK7_Pos = 0x7
	// Bit mask of LCK7 field.
	GPIO_LCKR_LCK7_Msk = 0x80
	// Bit LCK7.
	GPIO_LCKR_LCK7 = 0x80
	// Port configuration not locked
	GPIO_LCKR_LCK7_Unlocked = 0x0
	// Port configuration locked
	GPIO_LCKR_LCK7_Locked = 0x1
	// Position of LCK6 field.
	GPIO_LCKR_LCK6_Pos = 0x6
	// Bit mask of LCK6 field.
	GPIO_LCKR_LCK6_Msk = 0x40
	// Bit LCK6.
	GPIO_LCKR_LCK6 = 0x40
	// Port configuration not locked
	GPIO_LCKR_LCK6_Unlocked = 0x0
	// Port configuration locked
	GPIO_LCKR_LCK6_Locked = 0x1
	// Position of LCK5 field.
	GPIO_LCKR_LCK5_Pos = 0x5
	// Bit mask of LCK5 field.
	GPIO_LCKR_LCK5_Msk = 0x20
	// Bit LCK5.
	GPIO_LCKR_LCK5 = 0x20
	// Port configuration not locked
	GPIO_LCKR_LCK5_Unlocked = 0x0
	// Port configuration locked
	GPIO_LCKR_LCK5_Locked = 0x1
	// Position of LCK4 field.
	GPIO_LCKR_LCK4_Pos = 0x4
	// Bit mask of LCK4 field.
	GPIO_LCKR_LCK4_Msk = 0x10
	// Bit LCK4.
	GPIO_LCKR_LCK4 = 0x10
	// Port configuration not locked
	GPIO_LCKR_LCK4_Unlocked = 0x0
	// Port configuration locked
	GPIO_LCKR_LCK4_Locked = 0x1
	// Position of LCK3 field.
	GPIO_LCKR_LCK3_Pos = 0x3
	// Bit mask of LCK3 field.
	GPIO_LCKR_LCK3_Msk = 0x8
	// Bit LCK3.
	GPIO_LCKR_LCK3 = 0x8
	// Port configuration not locked
	GPIO_LCKR_LCK3_Unlocked = 0x0
	// Port configuration locked
	GPIO_LCKR_LCK3_Locked = 0x1
	// Position of LCK2 field.
	GPIO_LCKR_LCK2_Pos = 0x2
	// Bit mask of LCK2 field.
	GPIO_LCKR_LCK2_Msk = 0x4
	// Bit LCK2.
	GPIO_LCKR_LCK2 = 0x4
	// Port configuration not locked
	GPIO_LCKR_LCK2_Unlocked = 0x0
	// Port configuration locked
	GPIO_LCKR_LCK2_Locked = 0x1
	// Position of LCK1 field.
	GPIO_LCKR_LCK1_Pos = 0x1
	// Bit mask of LCK1 field.
	GPIO_LCKR_LCK1_Msk = 0x2
	// Bit LCK1.
	GPIO_LCKR_LCK1 = 0x2
	// Port configuration not locked
	GPIO_LCKR_LCK1_Unlocked = 0x0
	// Port configuration locked
	GPIO_LCKR_LCK1_Locked = 0x1
	// Position of LCK0 field.
	GPIO_LCKR_LCK0_Pos = 0x0
	// Bit mask of LCK0 field.
	GPIO_LCKR_LCK0_Msk = 0x1
	// Bit LCK0.
	GPIO_LCKR_LCK0 = 0x1
	// Port configuration not locked
	GPIO_LCKR_LCK0_Unlocked = 0x0
	// Port configuration locked
	GPIO_LCKR_LCK0_Locked = 0x1

	// AFRL: GPIO alternate function low register
	// Position of AFRL7 field.
	GPIO_AFRL_AFRL7_Pos = 0x1c
	// Bit mask of AFRL7 field.
	GPIO_AFRL_AFRL7_Msk = 0xf0000000
	// AF0
	GPIO_AFRL_AFRL7_AF0 = 0x0
	// AF1
	GPIO_AFRL_AFRL7_AF1 = 0x1
	// AF2
	GPIO_AFRL_AFRL7_AF2 = 0x2
	// AF3
	GPIO_AFRL_AFRL7_AF3 = 0x3
	// AF4
	GPIO_AFRL_AFRL7_AF4 = 0x4
	// AF5
	GPIO_AFRL_AFRL7_AF5 = 0x5
	// AF6
	GPIO_AFRL_AFRL7_AF6 = 0x6
	// AF7
	GPIO_AFRL_AFRL7_AF7 = 0x7
	// AF8
	GPIO_AFRL_AFRL7_AF8 = 0x8
	// AF9
	GPIO_AFRL_AFRL7_AF9 = 0x9
	// AF10
	GPIO_AFRL_AFRL7_AF10 = 0xa
	// AF11
	GPIO_AFRL_AFRL7_AF11 = 0xb
	// AF12
	GPIO_AFRL_AFRL7_AF12 = 0xc
	// AF13
	GPIO_AFRL_AFRL7_AF13 = 0xd
	// AF14
	GPIO_AFRL_AFRL7_AF14 = 0xe
	// AF15
	GPIO_AFRL_AFRL7_AF15 = 0xf
	// Position of AFRL6 field.
	GPIO_AFRL_AFRL6_Pos = 0x18
	// Bit mask of AFRL6 field.
	GPIO_AFRL_AFRL6_Msk = 0xf000000
	// AF0
	GPIO_AFRL_AFRL6_AF0 = 0x0
	// AF1
	GPIO_AFRL_AFRL6_AF1 = 0x1
	// AF2
	GPIO_AFRL_AFRL6_AF2 = 0x2
	// AF3
	GPIO_AFRL_AFRL6_AF3 = 0x3
	// AF4
	GPIO_AFRL_AFRL6_AF4 = 0x4
	// AF5
	GPIO_AFRL_AFRL6_AF5 = 0x5
	// AF6
	GPIO_AFRL_AFRL6_AF6 = 0x6
	// AF7
	GPIO_AFRL_AFRL6_AF7 = 0x7
	// AF8
	GPIO_AFRL_AFRL6_AF8 = 0x8
	// AF9
	GPIO_AFRL_AFRL6_AF9 = 0x9
	// AF10
	GPIO_AFRL_AFRL6_AF10 = 0xa
	// AF11
	GPIO_AFRL_AFRL6_AF11 = 0xb
	// AF12
	GPIO_AFRL_AFRL6_AF12 = 0xc
	// AF13
	GPIO_AFRL_AFRL6_AF13 = 0xd
	// AF14
	GPIO_AFRL_AFRL6_AF14 = 0xe
	// AF15
	GPIO_AFRL_AFRL6_AF15 = 0xf
	// Position of AFRL5 field.
	GPIO_AFRL_AFRL5_Pos = 0x14
	// Bit mask of AFRL5 field.
	GPIO_AFRL_AFRL5_Msk = 0xf00000
	// AF0
	GPIO_AFRL_AFRL5_AF0 = 0x0
	// AF1
	GPIO_AFRL_AFRL5_AF1 = 0x1
	// AF2
	GPIO_AFRL_AFRL5_AF2 = 0x2
	// AF3
	GPIO_AFRL_AFRL5_AF3 = 0x3
	// AF4
	GPIO_AFRL_AFRL5_AF4 = 0x4
	// AF5
	GPIO_AFRL_AFRL5_AF5 = 0x5
	// AF6
	GPIO_AFRL_AFRL5_AF6 = 0x6
	// AF7
	GPIO_AFRL_AFRL5_AF7 = 0x7
	// AF8
	GPIO_AFRL_AFRL5_AF8 = 0x8
	// AF9
	GPIO_AFRL_AFRL5_AF9 = 0x9
	// AF10
	GPIO_AFRL_AFRL5_AF10 = 0xa
	// AF11
	GPIO_AFRL_AFRL5_AF11 = 0xb
	// AF12
	GPIO_AFRL_AFRL5_AF12 = 0xc
	// AF13
	GPIO_AFRL_AFRL5_AF13 = 0xd
	// AF14
	GPIO_AFRL_AFRL5_AF14 = 0xe
	// AF15
	GPIO_AFRL_AFRL5_AF15 = 0xf
	// Position of AFRL4 field.
	GPIO_AFRL_AFRL4_Pos = 0x10
	// Bit mask of AFRL4 field.
	GPIO_AFRL_AFRL4_Msk = 0xf0000
	// AF0
	GPIO_AFRL_AFRL4_AF0 = 0x0
	// AF1
	GPIO_AFRL_AFRL4_AF1 = 0x1
	// AF2
	GPIO_AFRL_AFRL4_AF2 = 0x2
	// AF3
	GPIO_AFRL_AFRL4_AF3 = 0x3
	// AF4
	GPIO_AFRL_AFRL4_AF4 = 0x4
	// AF5
	GPIO_AFRL_AFRL4_AF5 = 0x5
	// AF6
	GPIO_AFRL_AFRL4_AF6 = 0x6
	// AF7
	GPIO_AFRL_AFRL4_AF7 = 0x7
	// AF8
	GPIO_AFRL_AFRL4_AF8 = 0x8
	// AF9
	GPIO_AFRL_AFRL4_AF9 = 0x9
	// AF10
	GPIO_AFRL_AFRL4_AF10 = 0xa
	// AF11
	GPIO_AFRL_AFRL4_AF11 = 0xb
	// AF12
	GPIO_AFRL_AFRL4_AF12 = 0xc
	// AF13
	GPIO_AFRL_AFRL4_AF13 = 0xd
	// AF14
	GPIO_AFRL_AFRL4_AF14 = 0xe
	// AF15
	GPIO_AFRL_AFRL4_AF15 = 0xf
	// Position of AFRL3 field.
	GPIO_AFRL_AFRL3_Pos = 0xc
	// Bit mask of AFRL3 field.
	GPIO_AFRL_AFRL3_Msk = 0xf000
	// AF0
	GPIO_AFRL_AFRL3_AF0 = 0x0
	// AF1
	GPIO_AFRL_AFRL3_AF1 = 0x1
	// AF2
	GPIO_AFRL_AFRL3_AF2 = 0x2
	// AF3
	GPIO_AFRL_AFRL3_AF3 = 0x3
	// AF4
	GPIO_AFRL_AFRL3_AF4 = 0x4
	// AF5
	GPIO_AFRL_AFRL3_AF5 = 0x5
	// AF6
	GPIO_AFRL_AFRL3_AF6 = 0x6
	// AF7
	GPIO_AFRL_AFRL3_AF7 = 0x7
	// AF8
	GPIO_AFRL_AFRL3_AF8 = 0x8
	// AF9
	GPIO_AFRL_AFRL3_AF9 = 0x9
	// AF10
	GPIO_AFRL_AFRL3_AF10 = 0xa
	// AF11
	GPIO_AFRL_AFRL3_AF11 = 0xb
	// AF12
	GPIO_AFRL_AFRL3_AF12 = 0xc
	// AF13
	GPIO_AFRL_AFRL3_AF13 = 0xd
	// AF14
	GPIO_AFRL_AFRL3_AF14 = 0xe
	// AF15
	GPIO_AFRL_AFRL3_AF15 = 0xf
	// Position of AFRL2 field.
	GPIO_AFRL_AFRL2_Pos = 0x8
	// Bit mask of AFRL2 field.
	GPIO_AFRL_AFRL2_Msk = 0xf00
	// AF0
	GPIO_AFRL_AFRL2_AF0 = 0x0
	// AF1
	GPIO_AFRL_AFRL2_AF1 = 0x1
	// AF2
	GPIO_AFRL_AFRL2_AF2 = 0x2
	// AF3
	GPIO_AFRL_AFRL2_AF3 = 0x3
	// AF4
	GPIO_AFRL_AFRL2_AF4 = 0x4
	// AF5
	GPIO_AFRL_AFRL2_AF5 = 0x5
	// AF6
	GPIO_AFRL_AFRL2_AF6 = 0x6
	// AF7
	GPIO_AFRL_AFRL2_AF7 = 0x7
	// AF8
	GPIO_AFRL_AFRL2_AF8 = 0x8
	// AF9
	GPIO_AFRL_AFRL2_AF9 = 0x9
	// AF10
	GPIO_AFRL_AFRL2_AF10 = 0xa
	// AF11
	GPIO_AFRL_AFRL2_AF11 = 0xb
	// AF12
	GPIO_AFRL_AFRL2_AF12 = 0xc
	// AF13
	GPIO_AFRL_AFRL2_AF13 = 0xd
	// AF14
	GPIO_AFRL_AFRL2_AF14 = 0xe
	// AF15
	GPIO_AFRL_AFRL2_AF15 = 0xf
	// Position of AFRL1 field.
	GPIO_AFRL_AFRL1_Pos = 0x4
	// Bit mask of AFRL1 field.
	GPIO_AFRL_AFRL1_Msk = 0xf0
	// AF0
	GPIO_AFRL_AFRL1_AF0 = 0x0
	// AF1
	GPIO_AFRL_AFRL1_AF1 = 0x1
	// AF2
	GPIO_AFRL_AFRL1_AF2 = 0x2
	// AF3
	GPIO_AFRL_AFRL1_AF3 = 0x3
	// AF4
	GPIO_AFRL_AFRL1_AF4 = 0x4
	// AF5
	GPIO_AFRL_AFRL1_AF5 = 0x5
	// AF6
	GPIO_AFRL_AFRL1_AF6 = 0x6
	// AF7
	GPIO_AFRL_AFRL1_AF7 = 0x7
	// AF8
	GPIO_AFRL_AFRL1_AF8 = 0x8
	// AF9
	GPIO_AFRL_AFRL1_AF9 = 0x9
	// AF10
	GPIO_AFRL_AFRL1_AF10 = 0xa
	// AF11
	GPIO_AFRL_AFRL1_AF11 = 0xb
	// AF12
	GPIO_AFRL_AFRL1_AF12 = 0xc
	// AF13
	GPIO_AFRL_AFRL1_AF13 = 0xd
	// AF14
	GPIO_AFRL_AFRL1_AF14 = 0xe
	// AF15
	GPIO_AFRL_AFRL1_AF15 = 0xf
	// Position of AFRL0 field.
	GPIO_AFRL_AFRL0_Pos = 0x0
	// Bit mask of AFRL0 field.
	GPIO_AFRL_AFRL0_Msk = 0xf
	// AF0
	GPIO_AFRL_AFRL0_AF0 = 0x0
	// AF1
	GPIO_AFRL_AFRL0_AF1 = 0x1
	// AF2
	GPIO_AFRL_AFRL0_AF2 = 0x2
	// AF3
	GPIO_AFRL_AFRL0_AF3 = 0x3
	// AF4
	GPIO_AFRL_AFRL0_AF4 = 0x4
	// AF5
	GPIO_AFRL_AFRL0_AF5 = 0x5
	// AF6
	GPIO_AFRL_AFRL0_AF6 = 0x6
	// AF7
	GPIO_AFRL_AFRL0_AF7 = 0x7
	// AF8
	GPIO_AFRL_AFRL0_AF8 = 0x8
	// AF9
	GPIO_AFRL_AFRL0_AF9 = 0x9
	// AF10
	GPIO_AFRL_AFRL0_AF10 = 0xa
	// AF11
	GPIO_AFRL_AFRL0_AF11 = 0xb
	// AF12
	GPIO_AFRL_AFRL0_AF12 = 0xc
	// AF13
	GPIO_AFRL_AFRL0_AF13 = 0xd
	// AF14
	GPIO_AFRL_AFRL0_AF14 = 0xe
	// AF15
	GPIO_AFRL_AFRL0_AF15 = 0xf

	// AFRH: GPIO alternate function high register
	// Position of AFRH15 field.
	GPIO_AFRH_AFRH15_Pos = 0x1c
	// Bit mask of AFRH15 field.
	GPIO_AFRH_AFRH15_Msk = 0xf0000000
	// AF0
	GPIO_AFRH_AFRH15_AF0 = 0x0
	// AF1
	GPIO_AFRH_AFRH15_AF1 = 0x1
	// AF2
	GPIO_AFRH_AFRH15_AF2 = 0x2
	// AF3
	GPIO_AFRH_AFRH15_AF3 = 0x3
	// AF4
	GPIO_AFRH_AFRH15_AF4 = 0x4
	// AF5
	GPIO_AFRH_AFRH15_AF5 = 0x5
	// AF6
	GPIO_AFRH_AFRH15_AF6 = 0x6
	// AF7
	GPIO_AFRH_AFRH15_AF7 = 0x7
	// AF8
	GPIO_AFRH_AFRH15_AF8 = 0x8
	// AF9
	GPIO_AFRH_AFRH15_AF9 = 0x9
	// AF10
	GPIO_AFRH_AFRH15_AF10 = 0xa
	// AF11
	GPIO_AFRH_AFRH15_AF11 = 0xb
	// AF12
	GPIO_AFRH_AFRH15_AF12 = 0xc
	// AF13
	GPIO_AFRH_AFRH15_AF13 = 0xd
	// AF14
	GPIO_AFRH_AFRH15_AF14 = 0xe
	// AF15
	GPIO_AFRH_AFRH15_AF15 = 0xf
	// Position of AFRH14 field.
	GPIO_AFRH_AFRH14_Pos = 0x18
	// Bit mask of AFRH14 field.
	GPIO_AFRH_AFRH14_Msk = 0xf000000
	// AF0
	GPIO_AFRH_AFRH14_AF0 = 0x0
	// AF1
	GPIO_AFRH_AFRH14_AF1 = 0x1
	// AF2
	GPIO_AFRH_AFRH14_AF2 = 0x2
	// AF3
	GPIO_AFRH_AFRH14_AF3 = 0x3
	// AF4
	GPIO_AFRH_AFRH14_AF4 = 0x4
	// AF5
	GPIO_AFRH_AFRH14_AF5 = 0x5
	// AF6
	GPIO_AFRH_AFRH14_AF6 = 0x6
	// AF7
	GPIO_AFRH_AFRH14_AF7 = 0x7
	// AF8
	GPIO_AFRH_AFRH14_AF8 = 0x8
	// AF9
	GPIO_AFRH_AFRH14_AF9 = 0x9
	// AF10
	GPIO_AFRH_AFRH14_AF10 = 0xa
	// AF11
	GPIO_AFRH_AFRH14_AF11 = 0xb
	// AF12
	GPIO_AFRH_AFRH14_AF12 = 0xc
	// AF13
	GPIO_AFRH_AFRH14_AF13 = 0xd
	// AF14
	GPIO_AFRH_AFRH14_AF14 = 0xe
	// AF15
	GPIO_AFRH_AFRH14_AF15 = 0xf
	// Position of AFRH13 field.
	GPIO_AFRH_AFRH13_Pos = 0x14
	// Bit mask of AFRH13 field.
	GPIO_AFRH_AFRH13_Msk = 0xf00000
	// AF0
	GPIO_AFRH_AFRH13_AF0 = 0x0
	// AF1
	GPIO_AFRH_AFRH13_AF1 = 0x1
	// AF2
	GPIO_AFRH_AFRH13_AF2 = 0x2
	// AF3
	GPIO_AFRH_AFRH13_AF3 = 0x3
	// AF4
	GPIO_AFRH_AFRH13_AF4 = 0x4
	// AF5
	GPIO_AFRH_AFRH13_AF5 = 0x5
	// AF6
	GPIO_AFRH_AFRH13_AF6 = 0x6
	// AF7
	GPIO_AFRH_AFRH13_AF7 = 0x7
	// AF8
	GPIO_AFRH_AFRH13_AF8 = 0x8
	// AF9
	GPIO_AFRH_AFRH13_AF9 = 0x9
	// AF10
	GPIO_AFRH_AFRH13_AF10 = 0xa
	// AF11
	GPIO_AFRH_AFRH13_AF11 = 0xb
	// AF12
	GPIO_AFRH_AFRH13_AF12 = 0xc
	// AF13
	GPIO_AFRH_AFRH13_AF13 = 0xd
	// AF14
	GPIO_AFRH_AFRH13_AF14 = 0xe
	// AF15
	GPIO_AFRH_AFRH13_AF15 = 0xf
	// Position of AFRH12 field.
	GPIO_AFRH_AFRH12_Pos = 0x10
	// Bit mask of AFRH12 field.
	GPIO_AFRH_AFRH12_Msk = 0xf0000
	// AF0
	GPIO_AFRH_AFRH12_AF0 = 0x0
	// AF1
	GPIO_AFRH_AFRH12_AF1 = 0x1
	// AF2
	GPIO_AFRH_AFRH12_AF2 = 0x2
	// AF3
	GPIO_AFRH_AFRH12_AF3 = 0x3
	// AF4
	GPIO_AFRH_AFRH12_AF4 = 0x4
	// AF5
	GPIO_AFRH_AFRH12_AF5 = 0x5
	// AF6
	GPIO_AFRH_AFRH12_AF6 = 0x6
	// AF7
	GPIO_AFRH_AFRH12_AF7 = 0x7
	// AF8
	GPIO_AFRH_AFRH12_AF8 = 0x8
	// AF9
	GPIO_AFRH_AFRH12_AF9 = 0x9
	// AF10
	GPIO_AFRH_AFRH12_AF10 = 0xa
	// AF11
	GPIO_AFRH_AFRH12_AF11 = 0xb
	// AF12
	GPIO_AFRH_AFRH12_AF12 = 0xc
	// AF13
	GPIO_AFRH_AFRH12_AF13 = 0xd
	// AF14
	GPIO_AFRH_AFRH12_AF14 = 0xe
	// AF15
	GPIO_AFRH_AFRH12_AF15 = 0xf
	// Position of AFRH11 field.
	GPIO_AFRH_AFRH11_Pos = 0xc
	// Bit mask of AFRH11 field.
	GPIO_AFRH_AFRH11_Msk = 0xf000
	// AF0
	GPIO_AFRH_AFRH11_AF0 = 0x0
	// AF1
	GPIO_AFRH_AFRH11_AF1 = 0x1
	// AF2
	GPIO_AFRH_AFRH11_AF2 = 0x2
	// AF3
	GPIO_AFRH_AFRH11_AF3 = 0x3
	// AF4
	GPIO_AFRH_AFRH11_AF4 = 0x4
	// AF5
	GPIO_AFRH_AFRH11_AF5 = 0x5
	// AF6
	GPIO_AFRH_AFRH11_AF6 = 0x6
	// AF7
	GPIO_AFRH_AFRH11_AF7 = 0x7
	// AF8
	GPIO_AFRH_AFRH11_AF8 = 0x8
	// AF9
	GPIO_AFRH_AFRH11_AF9 = 0x9
	// AF10
	GPIO_AFRH_AFRH11_AF10 = 0xa
	// AF11
	GPIO_AFRH_AFRH11_AF11 = 0xb
	// AF12
	GPIO_AFRH_AFRH11_AF12 = 0xc
	// AF13
	GPIO_AFRH_AFRH11_AF13 = 0xd
	// AF14
	GPIO_AFRH_AFRH11_AF14 = 0xe
	// AF15
	GPIO_AFRH_AFRH11_AF15 = 0xf
	// Position of AFRH10 field.
	GPIO_AFRH_AFRH10_Pos = 0x8
	// Bit mask of AFRH10 field.
	GPIO_AFRH_AFRH10_Msk = 0xf00
	// AF0
	GPIO_AFRH_AFRH10_AF0 = 0x0
	// AF1
	GPIO_AFRH_AFRH10_AF1 = 0x1
	// AF2
	GPIO_AFRH_AFRH10_AF2 = 0x2
	// AF3
	GPIO_AFRH_AFRH10_AF3 = 0x3
	// AF4
	GPIO_AFRH_AFRH10_AF4 = 0x4
	// AF5
	GPIO_AFRH_AFRH10_AF5 = 0x5
	// AF6
	GPIO_AFRH_AFRH10_AF6 = 0x6
	// AF7
	GPIO_AFRH_AFRH10_AF7 = 0x7
	// AF8
	GPIO_AFRH_AFRH10_AF8 = 0x8
	// AF9
	GPIO_AFRH_AFRH10_AF9 = 0x9
	// AF10
	GPIO_AFRH_AFRH10_AF10 = 0xa
	// AF11
	GPIO_AFRH_AFRH10_AF11 = 0xb
	// AF12
	GPIO_AFRH_AFRH10_AF12 = 0xc
	// AF13
	GPIO_AFRH_AFRH10_AF13 = 0xd
	// AF14
	GPIO_AFRH_AFRH10_AF14 = 0xe
	// AF15
	GPIO_AFRH_AFRH10_AF15 = 0xf
	// Position of AFRH9 field.
	GPIO_AFRH_AFRH9_Pos = 0x4
	// Bit mask of AFRH9 field.
	GPIO_AFRH_AFRH9_Msk = 0xf0
	// AF0
	GPIO_AFRH_AFRH9_AF0 = 0x0
	// AF1
	GPIO_AFRH_AFRH9_AF1 = 0x1
	// AF2
	GPIO_AFRH_AFRH9_AF2 = 0x2
	// AF3
	GPIO_AFRH_AFRH9_AF3 = 0x3
	// AF4
	GPIO_AFRH_AFRH9_AF4 = 0x4
	// AF5
	GPIO_AFRH_AFRH9_AF5 = 0x5
	// AF6
	GPIO_AFRH_AFRH9_AF6 = 0x6
	// AF7
	GPIO_AFRH_AFRH9_AF7 = 0x7
	// AF8
	GPIO_AFRH_AFRH9_AF8 = 0x8
	// AF9
	GPIO_AFRH_AFRH9_AF9 = 0x9
	// AF10
	GPIO_AFRH_AFRH9_AF10 = 0xa
	// AF11
	GPIO_AFRH_AFRH9_AF11 = 0xb
	// AF12
	GPIO_AFRH_AFRH9_AF12 = 0xc
	// AF13
	GPIO_AFRH_AFRH9_AF13 = 0xd
	// AF14
	GPIO_AFRH_AFRH9_AF14 = 0xe
	// AF15
	GPIO_AFRH_AFRH9_AF15 = 0xf
	// Position of AFRH8 field.
	GPIO_AFRH_AFRH8_Pos = 0x0
	// Bit mask of AFRH8 field.
	GPIO_AFRH_AFRH8_Msk = 0xf
	// AF0
	GPIO_AFRH_AFRH8_AF0 = 0x0
	// AF1
	GPIO_AFRH_AFRH8_AF1 = 0x1
	// AF2
	GPIO_AFRH_AFRH8_AF2 = 0x2
	// AF3
	GPIO_AFRH_AFRH8_AF3 = 0x3
	// AF4
	GPIO_AFRH_AFRH8_AF4 = 0x4
	// AF5
	GPIO_AFRH_AFRH8_AF5 = 0x5
	// AF6
	GPIO_AFRH_AFRH8_AF6 = 0x6
	// AF7
	GPIO_AFRH_AFRH8_AF7 = 0x7
	// AF8
	GPIO_AFRH_AFRH8_AF8 = 0x8
	// AF9
	GPIO_AFRH_AFRH8_AF9 = 0x9
	// AF10
	GPIO_AFRH_AFRH8_AF10 = 0xa
	// AF11
	GPIO_AFRH_AFRH8_AF11 = 0xb
	// AF12
	GPIO_AFRH_AFRH8_AF12 = 0xc
	// AF13
	GPIO_AFRH_AFRH8_AF13 = 0xd
	// AF14
	GPIO_AFRH_AFRH8_AF14 = 0xe
	// AF15
	GPIO_AFRH_AFRH8_AF15 = 0xf

	// BRR: Port bit reset register
	// Position of BR0 field.
	GPIO_BRR_BR0_Pos = 0x0
	// Bit mask of BR0 field.
	GPIO_BRR_BR0_Msk = 0x1
	// Bit BR0.
	GPIO_BRR_BR0 = 0x1
	// No action on the corresponding ODx bit
	GPIO_BRR_BR0_NoAction = 0x0
	// Reset the ODx bit
	GPIO_BRR_BR0_Reset = 0x1
	// Position of BR1 field.
	GPIO_BRR_BR1_Pos = 0x1
	// Bit mask of BR1 field.
	GPIO_BRR_BR1_Msk = 0x2
	// Bit BR1.
	GPIO_BRR_BR1 = 0x2
	// No action on the corresponding ODx bit
	GPIO_BRR_BR1_NoAction = 0x0
	// Reset the ODx bit
	GPIO_BRR_BR1_Reset = 0x1
	// Position of BR2 field.
	GPIO_BRR_BR2_Pos = 0x2
	// Bit mask of BR2 field.
	GPIO_BRR_BR2_Msk = 0x4
	// Bit BR2.
	GPIO_BRR_BR2 = 0x4
	// No action on the corresponding ODx bit
	GPIO_BRR_BR2_NoAction = 0x0
	// Reset the ODx bit
	GPIO_BRR_BR2_Reset = 0x1
	// Position of BR3 field.
	GPIO_BRR_BR3_Pos = 0x3
	// Bit mask of BR3 field.
	GPIO_BRR_BR3_Msk = 0x8
	// Bit BR3.
	GPIO_BRR_BR3 = 0x8
	// No action on the corresponding ODx bit
	GPIO_BRR_BR3_NoAction = 0x0
	// Reset the ODx bit
	GPIO_BRR_BR3_Reset = 0x1
	// Position of BR4 field.
	GPIO_BRR_BR4_Pos = 0x4
	// Bit mask of BR4 field.
	GPIO_BRR_BR4_Msk = 0x10
	// Bit BR4.
	GPIO_BRR_BR4 = 0x10
	// No action on the corresponding ODx bit
	GPIO_BRR_BR4_NoAction = 0x0
	// Reset the ODx bit
	GPIO_BRR_BR4_Reset = 0x1
	// Position of BR5 field.
	GPIO_BRR_BR5_Pos = 0x5
	// Bit mask of BR5 field.
	GPIO_BRR_BR5_Msk = 0x20
	// Bit BR5.
	GPIO_BRR_BR5 = 0x20
	// No action on the corresponding ODx bit
	GPIO_BRR_BR5_NoAction = 0x0
	// Reset the ODx bit
	GPIO_BRR_BR5_Reset = 0x1
	// Position of BR6 field.
	GPIO_BRR_BR6_Pos = 0x6
	// Bit mask of BR6 field.
	GPIO_BRR_BR6_Msk = 0x40
	// Bit BR6.
	GPIO_BRR_BR6 = 0x40
	// No action on the corresponding ODx bit
	GPIO_BRR_BR6_NoAction = 0x0
	// Reset the ODx bit
	GPIO_BRR_BR6_Reset = 0x1
	// Position of BR7 field.
	GPIO_BRR_BR7_Pos = 0x7
	// Bit mask of BR7 field.
	GPIO_BRR_BR7_Msk = 0x80
	// Bit BR7.
	GPIO_BRR_BR7 = 0x80
	// No action on the corresponding ODx bit
	GPIO_BRR_BR7_NoAction = 0x0
	// Reset the ODx bit
	GPIO_BRR_BR7_Reset = 0x1
	// Position of BR8 field.
	GPIO_BRR_BR8_Pos = 0x8
	// Bit mask of BR8 field.
	GPIO_BRR_BR8_Msk = 0x100
	// Bit BR8.
	GPIO_BRR_BR8 = 0x100
	// No action on the corresponding ODx bit
	GPIO_BRR_BR8_NoAction = 0x0
	// Reset the ODx bit
	GPIO_BRR_BR8_Reset = 0x1
	// Position of BR9 field.
	GPIO_BRR_BR9_Pos = 0x9
	// Bit mask of BR9 field.
	GPIO_BRR_BR9_Msk = 0x200
	// Bit BR9.
	GPIO_BRR_BR9 = 0x200
	// No action on the corresponding ODx bit
	GPIO_BRR_BR9_NoAction = 0x0
	// Reset the ODx bit
	GPIO_BRR_BR9_Reset = 0x1
	// Position of BR10 field.
	GPIO_BRR_BR10_Pos = 0xa
	// Bit mask of BR10 field.
	GPIO_BRR_BR10_Msk = 0x400
	// Bit BR10.
	GPIO_BRR_BR10 = 0x400
	// No action on the corresponding ODx bit
	GPIO_BRR_BR10_NoAction = 0x0
	// Reset the ODx bit
	GPIO_BRR_BR10_Reset = 0x1
	// Position of BR11 field.
	GPIO_BRR_BR11_Pos = 0xb
	// Bit mask of BR11 field.
	GPIO_BRR_BR11_Msk = 0x800
	// Bit BR11.
	GPIO_BRR_BR11 = 0x800
	// No action on the corresponding ODx bit
	GPIO_BRR_BR11_NoAction = 0x0
	// Reset the ODx bit
	GPIO_BRR_BR11_Reset = 0x1
	// Position of BR12 field.
	GPIO_BRR_BR12_Pos = 0xc
	// Bit mask of BR12 field.
	GPIO_BRR_BR12_Msk = 0x1000
	// Bit BR12.
	GPIO_BRR_BR12 = 0x1000
	// No action on the corresponding ODx bit
	GPIO_BRR_BR12_NoAction = 0x0
	// Reset the ODx bit
	GPIO_BRR_BR12_Reset = 0x1
	// Position of BR13 field.
	GPIO_BRR_BR13_Pos = 0xd
	// Bit mask of BR13 field.
	GPIO_BRR_BR13_Msk = 0x2000
	// Bit BR13.
	GPIO_BRR_BR13 = 0x2000
	// No action on the corresponding ODx bit
	GPIO_BRR_BR13_NoAction = 0x0
	// Reset the ODx bit
	GPIO_BRR_BR13_Reset = 0x1
	// Position of BR14 field.
	GPIO_BRR_BR14_Pos = 0xe
	// Bit mask of BR14 field.
	GPIO_BRR_BR14_Msk = 0x4000
	// Bit BR14.
	GPIO_BRR_BR14 = 0x4000
	// No action on the corresponding ODx bit
	GPIO_BRR_BR14_NoAction = 0x0
	// Reset the ODx bit
	GPIO_BRR_BR14_Reset = 0x1
	// Position of BR15 field.
	GPIO_BRR_BR15_Pos = 0xf
	// Bit mask of BR15 field.
	GPIO_BRR_BR15_Msk = 0x8000
	// Bit BR15.
	GPIO_BRR_BR15 = 0x8000
	// No action on the corresponding ODx bit
	GPIO_BRR_BR15_NoAction = 0x0
	// Reset the ODx bit
	GPIO_BRR_BR15_Reset = 0x1
)

// Bitfields for TSC: Touch sensing controller
const (
	// CR: control register
	// Position of CTPH field.
	TSC_CR_CTPH_Pos = 0x1c
	// Bit mask of CTPH field.
	TSC_CR_CTPH_Msk = 0xf0000000
	// Position of CTPL field.
	TSC_CR_CTPL_Pos = 0x18
	// Bit mask of CTPL field.
	TSC_CR_CTPL_Msk = 0xf000000
	// Position of SSD field.
	TSC_CR_SSD_Pos = 0x11
	// Bit mask of SSD field.
	TSC_CR_SSD_Msk = 0xfe0000
	// Position of SSE field.
	TSC_CR_SSE_Pos = 0x10
	// Bit mask of SSE field.
	TSC_CR_SSE_Msk = 0x10000
	// Bit SSE.
	TSC_CR_SSE = 0x10000
	// Position of SSPSC field.
	TSC_CR_SSPSC_Pos = 0xf
	// Bit mask of SSPSC field.
	TSC_CR_SSPSC_Msk = 0x8000
	// Bit SSPSC.
	TSC_CR_SSPSC = 0x8000
	// Position of PGPSC field.
	TSC_CR_PGPSC_Pos = 0xc
	// Bit mask of PGPSC field.
	TSC_CR_PGPSC_Msk = 0x7000
	// Position of MCV field.
	TSC_CR_MCV_Pos = 0x5
	// Bit mask of MCV field.
	TSC_CR_MCV_Msk = 0xe0
	// Position of IODEF field.
	TSC_CR_IODEF_Pos = 0x4
	// Bit mask of IODEF field.
	TSC_CR_IODEF_Msk = 0x10
	// Bit IODEF.
	TSC_CR_IODEF = 0x10
	// Position of SYNCPOL field.
	TSC_CR_SYNCPOL_Pos = 0x3
	// Bit mask of SYNCPOL field.
	TSC_CR_SYNCPOL_Msk = 0x8
	// Bit SYNCPOL.
	TSC_CR_SYNCPOL = 0x8
	// Position of AM field.
	TSC_CR_AM_Pos = 0x2
	// Bit mask of AM field.
	TSC_CR_AM_Msk = 0x4
	// Bit AM.
	TSC_CR_AM = 0x4
	// Position of START field.
	TSC_CR_START_Pos = 0x1
	// Bit mask of START field.
	TSC_CR_START_Msk = 0x2
	// Bit START.
	TSC_CR_START = 0x2
	// Position of TSCE field.
	TSC_CR_TSCE_Pos = 0x0
	// Bit mask of TSCE field.
	TSC_CR_TSCE_Msk = 0x1
	// Bit TSCE.
	TSC_CR_TSCE = 0x1

	// IER: interrupt enable register
	// Position of MCEIE field.
	TSC_IER_MCEIE_Pos = 0x1
	// Bit mask of MCEIE field.
	TSC_IER_MCEIE_Msk = 0x2
	// Bit MCEIE.
	TSC_IER_MCEIE = 0x2
	// Position of EOAIE field.
	TSC_IER_EOAIE_Pos = 0x0
	// Bit mask of EOAIE field.
	TSC_IER_EOAIE_Msk = 0x1
	// Bit EOAIE.
	TSC_IER_EOAIE = 0x1

	// ICR: interrupt clear register
	// Position of MCEIC field.
	TSC_ICR_MCEIC_Pos = 0x1
	// Bit mask of MCEIC field.
	TSC_ICR_MCEIC_Msk = 0x2
	// Bit MCEIC.
	TSC_ICR_MCEIC = 0x2
	// Position of EOAIC field.
	TSC_ICR_EOAIC_Pos = 0x0
	// Bit mask of EOAIC field.
	TSC_ICR_EOAIC_Msk = 0x1
	// Bit EOAIC.
	TSC_ICR_EOAIC = 0x1

	// ISR: interrupt status register
	// Position of MCEF field.
	TSC_ISR_MCEF_Pos = 0x1
	// Bit mask of MCEF field.
	TSC_ISR_MCEF_Msk = 0x2
	// Bit MCEF.
	TSC_ISR_MCEF = 0x2
	// Position of EOAF field.
	TSC_ISR_EOAF_Pos = 0x0
	// Bit mask of EOAF field.
	TSC_ISR_EOAF_Msk = 0x1
	// Bit EOAF.
	TSC_ISR_EOAF = 0x1

	// IOHCR: I/O hysteresis control register
	// Position of G1_IO1 field.
	TSC_IOHCR_G1_IO1_Pos = 0x0
	// Bit mask of G1_IO1 field.
	TSC_IOHCR_G1_IO1_Msk = 0x1
	// Bit G1_IO1.
	TSC_IOHCR_G1_IO1 = 0x1
	// Position of G1_IO2 field.
	TSC_IOHCR_G1_IO2_Pos = 0x1
	// Bit mask of G1_IO2 field.
	TSC_IOHCR_G1_IO2_Msk = 0x2
	// Bit G1_IO2.
	TSC_IOHCR_G1_IO2 = 0x2
	// Position of G1_IO3 field.
	TSC_IOHCR_G1_IO3_Pos = 0x2
	// Bit mask of G1_IO3 field.
	TSC_IOHCR_G1_IO3_Msk = 0x4
	// Bit G1_IO3.
	TSC_IOHCR_G1_IO3 = 0x4
	// Position of G1_IO4 field.
	TSC_IOHCR_G1_IO4_Pos = 0x3
	// Bit mask of G1_IO4 field.
	TSC_IOHCR_G1_IO4_Msk = 0x8
	// Bit G1_IO4.
	TSC_IOHCR_G1_IO4 = 0x8
	// Position of G2_IO1 field.
	TSC_IOHCR_G2_IO1_Pos = 0x4
	// Bit mask of G2_IO1 field.
	TSC_IOHCR_G2_IO1_Msk = 0x10
	// Bit G2_IO1.
	TSC_IOHCR_G2_IO1 = 0x10
	// Position of G2_IO2 field.
	TSC_IOHCR_G2_IO2_Pos = 0x5
	// Bit mask of G2_IO2 field.
	TSC_IOHCR_G2_IO2_Msk = 0x20
	// Bit G2_IO2.
	TSC_IOHCR_G2_IO2 = 0x20
	// Position of G2_IO3 field.
	TSC_IOHCR_G2_IO3_Pos = 0x6
	// Bit mask of G2_IO3 field.
	TSC_IOHCR_G2_IO3_Msk = 0x40
	// Bit G2_IO3.
	TSC_IOHCR_G2_IO3 = 0x40
	// Position of G2_IO4 field.
	TSC_IOHCR_G2_IO4_Pos = 0x7
	// Bit mask of G2_IO4 field.
	TSC_IOHCR_G2_IO4_Msk = 0x80
	// Bit G2_IO4.
	TSC_IOHCR_G2_IO4 = 0x80
	// Position of G3_IO1 field.
	TSC_IOHCR_G3_IO1_Pos = 0x8
	// Bit mask of G3_IO1 field.
	TSC_IOHCR_G3_IO1_Msk = 0x100
	// Bit G3_IO1.
	TSC_IOHCR_G3_IO1 = 0x100
	// Position of G3_IO2 field.
	TSC_IOHCR_G3_IO2_Pos = 0x9
	// Bit mask of G3_IO2 field.
	TSC_IOHCR_G3_IO2_Msk = 0x200
	// Bit G3_IO2.
	TSC_IOHCR_G3_IO2 = 0x200
	// Position of G3_IO3 field.
	TSC_IOHCR_G3_IO3_Pos = 0xa
	// Bit mask of G3_IO3 field.
	TSC_IOHCR_G3_IO3_Msk = 0x400
	// Bit G3_IO3.
	TSC_IOHCR_G3_IO3 = 0x400
	// Position of G3_IO4 field.
	TSC_IOHCR_G3_IO4_Pos = 0xb
	// Bit mask of G3_IO4 field.
	TSC_IOHCR_G3_IO4_Msk = 0x800
	// Bit G3_IO4.
	TSC_IOHCR_G3_IO4 = 0x800
	// Position of G4_IO1 field.
	TSC_IOHCR_G4_IO1_Pos = 0xc
	// Bit mask of G4_IO1 field.
	TSC_IOHCR_G4_IO1_Msk = 0x1000
	// Bit G4_IO1.
	TSC_IOHCR_G4_IO1 = 0x1000
	// Position of G4_IO2 field.
	TSC_IOHCR_G4_IO2_Pos = 0xd
	// Bit mask of G4_IO2 field.
	TSC_IOHCR_G4_IO2_Msk = 0x2000
	// Bit G4_IO2.
	TSC_IOHCR_G4_IO2 = 0x2000
	// Position of G4_IO3 field.
	TSC_IOHCR_G4_IO3_Pos = 0xe
	// Bit mask of G4_IO3 field.
	TSC_IOHCR_G4_IO3_Msk = 0x4000
	// Bit G4_IO3.
	TSC_IOHCR_G4_IO3 = 0x4000
	// Position of G4_IO4 field.
	TSC_IOHCR_G4_IO4_Pos = 0xf
	// Bit mask of G4_IO4 field.
	TSC_IOHCR_G4_IO4_Msk = 0x8000
	// Bit G4_IO4.
	TSC_IOHCR_G4_IO4 = 0x8000
	// Position of G5_IO1 field.
	TSC_IOHCR_G5_IO1_Pos = 0x10
	// Bit mask of G5_IO1 field.
	TSC_IOHCR_G5_IO1_Msk = 0x10000
	// Bit G5_IO1.
	TSC_IOHCR_G5_IO1 = 0x10000
	// Position of G5_IO2 field.
	TSC_IOHCR_G5_IO2_Pos = 0x11
	// Bit mask of G5_IO2 field.
	TSC_IOHCR_G5_IO2_Msk = 0x20000
	// Bit G5_IO2.
	TSC_IOHCR_G5_IO2 = 0x20000
	// Position of G5_IO3 field.
	TSC_IOHCR_G5_IO3_Pos = 0x12
	// Bit mask of G5_IO3 field.
	TSC_IOHCR_G5_IO3_Msk = 0x40000
	// Bit G5_IO3.
	TSC_IOHCR_G5_IO3 = 0x40000
	// Position of G5_IO4 field.
	TSC_IOHCR_G5_IO4_Pos = 0x13
	// Bit mask of G5_IO4 field.
	TSC_IOHCR_G5_IO4_Msk = 0x80000
	// Bit G5_IO4.
	TSC_IOHCR_G5_IO4 = 0x80000
	// Position of G6_IO1 field.
	TSC_IOHCR_G6_IO1_Pos = 0x14
	// Bit mask of G6_IO1 field.
	TSC_IOHCR_G6_IO1_Msk = 0x100000
	// Bit G6_IO1.
	TSC_IOHCR_G6_IO1 = 0x100000
	// Position of G6_IO2 field.
	TSC_IOHCR_G6_IO2_Pos = 0x15
	// Bit mask of G6_IO2 field.
	TSC_IOHCR_G6_IO2_Msk = 0x200000
	// Bit G6_IO2.
	TSC_IOHCR_G6_IO2 = 0x200000
	// Position of G6_IO3 field.
	TSC_IOHCR_G6_IO3_Pos = 0x16
	// Bit mask of G6_IO3 field.
	TSC_IOHCR_G6_IO3_Msk = 0x400000
	// Bit G6_IO3.
	TSC_IOHCR_G6_IO3 = 0x400000
	// Position of G6_IO4 field.
	TSC_IOHCR_G6_IO4_Pos = 0x17
	// Bit mask of G6_IO4 field.
	TSC_IOHCR_G6_IO4_Msk = 0x800000
	// Bit G6_IO4.
	TSC_IOHCR_G6_IO4 = 0x800000
	// Position of G7_IO1 field.
	TSC_IOHCR_G7_IO1_Pos = 0x18
	// Bit mask of G7_IO1 field.
	TSC_IOHCR_G7_IO1_Msk = 0x1000000
	// Bit G7_IO1.
	TSC_IOHCR_G7_IO1 = 0x1000000
	// Position of G7_IO2 field.
	TSC_IOHCR_G7_IO2_Pos = 0x19
	// Bit mask of G7_IO2 field.
	TSC_IOHCR_G7_IO2_Msk = 0x2000000
	// Bit G7_IO2.
	TSC_IOHCR_G7_IO2 = 0x2000000
	// Position of G7_IO3 field.
	TSC_IOHCR_G7_IO3_Pos = 0x1a
	// Bit mask of G7_IO3 field.
	TSC_IOHCR_G7_IO3_Msk = 0x4000000
	// Bit G7_IO3.
	TSC_IOHCR_G7_IO3 = 0x4000000
	// Position of G7_IO4 field.
	TSC_IOHCR_G7_IO4_Pos = 0x1b
	// Bit mask of G7_IO4 field.
	TSC_IOHCR_G7_IO4_Msk = 0x8000000
	// Bit G7_IO4.
	TSC_IOHCR_G7_IO4 = 0x8000000
	// Position of G8_IO1 field.
	TSC_IOHCR_G8_IO1_Pos = 0x1c
	// Bit mask of G8_IO1 field.
	TSC_IOHCR_G8_IO1_Msk = 0x10000000
	// Bit G8_IO1.
	TSC_IOHCR_G8_IO1 = 0x10000000
	// Position of G8_IO2 field.
	TSC_IOHCR_G8_IO2_Pos = 0x1d
	// Bit mask of G8_IO2 field.
	TSC_IOHCR_G8_IO2_Msk = 0x20000000
	// Bit G8_IO2.
	TSC_IOHCR_G8_IO2 = 0x20000000
	// Position of G8_IO3 field.
	TSC_IOHCR_G8_IO3_Pos = 0x1e
	// Bit mask of G8_IO3 field.
	TSC_IOHCR_G8_IO3_Msk = 0x40000000
	// Bit G8_IO3.
	TSC_IOHCR_G8_IO3 = 0x40000000
	// Position of G8_IO4 field.
	TSC_IOHCR_G8_IO4_Pos = 0x1f
	// Bit mask of G8_IO4 field.
	TSC_IOHCR_G8_IO4_Msk = 0x80000000
	// Bit G8_IO4.
	TSC_IOHCR_G8_IO4 = 0x80000000

	// IOASCR: I/O analog switch control register
	// Position of G1_IO1 field.
	TSC_IOASCR_G1_IO1_Pos = 0x0
	// Bit mask of G1_IO1 field.
	TSC_IOASCR_G1_IO1_Msk = 0x1
	// Bit G1_IO1.
	TSC_IOASCR_G1_IO1 = 0x1
	// Position of G1_IO2 field.
	TSC_IOASCR_G1_IO2_Pos = 0x1
	// Bit mask of G1_IO2 field.
	TSC_IOASCR_G1_IO2_Msk = 0x2
	// Bit G1_IO2.
	TSC_IOASCR_G1_IO2 = 0x2
	// Position of G1_IO3 field.
	TSC_IOASCR_G1_IO3_Pos = 0x2
	// Bit mask of G1_IO3 field.
	TSC_IOASCR_G1_IO3_Msk = 0x4
	// Bit G1_IO3.
	TSC_IOASCR_G1_IO3 = 0x4
	// Position of G1_IO4 field.
	TSC_IOASCR_G1_IO4_Pos = 0x3
	// Bit mask of G1_IO4 field.
	TSC_IOASCR_G1_IO4_Msk = 0x8
	// Bit G1_IO4.
	TSC_IOASCR_G1_IO4 = 0x8
	// Position of G2_IO1 field.
	TSC_IOASCR_G2_IO1_Pos = 0x4
	// Bit mask of G2_IO1 field.
	TSC_IOASCR_G2_IO1_Msk = 0x10
	// Bit G2_IO1.
	TSC_IOASCR_G2_IO1 = 0x10
	// Position of G2_IO2 field.
	TSC_IOASCR_G2_IO2_Pos = 0x5
	// Bit mask of G2_IO2 field.
	TSC_IOASCR_G2_IO2_Msk = 0x20
	// Bit G2_IO2.
	TSC_IOASCR_G2_IO2 = 0x20
	// Position of G2_IO3 field.
	TSC_IOASCR_G2_IO3_Pos = 0x6
	// Bit mask of G2_IO3 field.
	TSC_IOASCR_G2_IO3_Msk = 0x40
	// Bit G2_IO3.
	TSC_IOASCR_G2_IO3 = 0x40
	// Position of G2_IO4 field.
	TSC_IOASCR_G2_IO4_Pos = 0x7
	// Bit mask of G2_IO4 field.
	TSC_IOASCR_G2_IO4_Msk = 0x80
	// Bit G2_IO4.
	TSC_IOASCR_G2_IO4 = 0x80
	// Position of G3_IO1 field.
	TSC_IOASCR_G3_IO1_Pos = 0x8
	// Bit mask of G3_IO1 field.
	TSC_IOASCR_G3_IO1_Msk = 0x100
	// Bit G3_IO1.
	TSC_IOASCR_G3_IO1 = 0x100
	// Position of G3_IO2 field.
	TSC_IOASCR_G3_IO2_Pos = 0x9
	// Bit mask of G3_IO2 field.
	TSC_IOASCR_G3_IO2_Msk = 0x200
	// Bit G3_IO2.
	TSC_IOASCR_G3_IO2 = 0x200
	// Position of G3_IO3 field.
	TSC_IOASCR_G3_IO3_Pos = 0xa
	// Bit mask of G3_IO3 field.
	TSC_IOASCR_G3_IO3_Msk = 0x400
	// Bit G3_IO3.
	TSC_IOASCR_G3_IO3 = 0x400
	// Position of G3_IO4 field.
	TSC_IOASCR_G3_IO4_Pos = 0xb
	// Bit mask of G3_IO4 field.
	TSC_IOASCR_G3_IO4_Msk = 0x800
	// Bit G3_IO4.
	TSC_IOASCR_G3_IO4 = 0x800
	// Position of G4_IO1 field.
	TSC_IOASCR_G4_IO1_Pos = 0xc
	// Bit mask of G4_IO1 field.
	TSC_IOASCR_G4_IO1_Msk = 0x1000
	// Bit G4_IO1.
	TSC_IOASCR_G4_IO1 = 0x1000
	// Position of G4_IO2 field.
	TSC_IOASCR_G4_IO2_Pos = 0xd
	// Bit mask of G4_IO2 field.
	TSC_IOASCR_G4_IO2_Msk = 0x2000
	// Bit G4_IO2.
	TSC_IOASCR_G4_IO2 = 0x2000
	// Position of G4_IO3 field.
	TSC_IOASCR_G4_IO3_Pos = 0xe
	// Bit mask of G4_IO3 field.
	TSC_IOASCR_G4_IO3_Msk = 0x4000
	// Bit G4_IO3.
	TSC_IOASCR_G4_IO3 = 0x4000
	// Position of G4_IO4 field.
	TSC_IOASCR_G4_IO4_Pos = 0xf
	// Bit mask of G4_IO4 field.
	TSC_IOASCR_G4_IO4_Msk = 0x8000
	// Bit G4_IO4.
	TSC_IOASCR_G4_IO4 = 0x8000
	// Position of G5_IO1 field.
	TSC_IOASCR_G5_IO1_Pos = 0x10
	// Bit mask of G5_IO1 field.
	TSC_IOASCR_G5_IO1_Msk = 0x10000
	// Bit G5_IO1.
	TSC_IOASCR_G5_IO1 = 0x10000
	// Position of G5_IO2 field.
	TSC_IOASCR_G5_IO2_Pos = 0x11
	// Bit mask of G5_IO2 field.
	TSC_IOASCR_G5_IO2_Msk = 0x20000
	// Bit G5_IO2.
	TSC_IOASCR_G5_IO2 = 0x20000
	// Position of G5_IO3 field.
	TSC_IOASCR_G5_IO3_Pos = 0x12
	// Bit mask of G5_IO3 field.
	TSC_IOASCR_G5_IO3_Msk = 0x40000
	// Bit G5_IO3.
	TSC_IOASCR_G5_IO3 = 0x40000
	// Position of G5_IO4 field.
	TSC_IOASCR_G5_IO4_Pos = 0x13
	// Bit mask of G5_IO4 field.
	TSC_IOASCR_G5_IO4_Msk = 0x80000
	// Bit G5_IO4.
	TSC_IOASCR_G5_IO4 = 0x80000
	// Position of G6_IO1 field.
	TSC_IOASCR_G6_IO1_Pos = 0x14
	// Bit mask of G6_IO1 field.
	TSC_IOASCR_G6_IO1_Msk = 0x100000
	// Bit G6_IO1.
	TSC_IOASCR_G6_IO1 = 0x100000
	// Position of G6_IO2 field.
	TSC_IOASCR_G6_IO2_Pos = 0x15
	// Bit mask of G6_IO2 field.
	TSC_IOASCR_G6_IO2_Msk = 0x200000
	// Bit G6_IO2.
	TSC_IOASCR_G6_IO2 = 0x200000
	// Position of G6_IO3 field.
	TSC_IOASCR_G6_IO3_Pos = 0x16
	// Bit mask of G6_IO3 field.
	TSC_IOASCR_G6_IO3_Msk = 0x400000
	// Bit G6_IO3.
	TSC_IOASCR_G6_IO3 = 0x400000
	// Position of G6_IO4 field.
	TSC_IOASCR_G6_IO4_Pos = 0x17
	// Bit mask of G6_IO4 field.
	TSC_IOASCR_G6_IO4_Msk = 0x800000
	// Bit G6_IO4.
	TSC_IOASCR_G6_IO4 = 0x800000
	// Position of G7_IO1 field.
	TSC_IOASCR_G7_IO1_Pos = 0x18
	// Bit mask of G7_IO1 field.
	TSC_IOASCR_G7_IO1_Msk = 0x1000000
	// Bit G7_IO1.
	TSC_IOASCR_G7_IO1 = 0x1000000
	// Position of G7_IO2 field.
	TSC_IOASCR_G7_IO2_Pos = 0x19
	// Bit mask of G7_IO2 field.
	TSC_IOASCR_G7_IO2_Msk = 0x2000000
	// Bit G7_IO2.
	TSC_IOASCR_G7_IO2 = 0x2000000
	// Position of G7_IO3 field.
	TSC_IOASCR_G7_IO3_Pos = 0x1a
	// Bit mask of G7_IO3 field.
	TSC_IOASCR_G7_IO3_Msk = 0x4000000
	// Bit G7_IO3.
	TSC_IOASCR_G7_IO3 = 0x4000000
	// Position of G7_IO4 field.
	TSC_IOASCR_G7_IO4_Pos = 0x1b
	// Bit mask of G7_IO4 field.
	TSC_IOASCR_G7_IO4_Msk = 0x8000000
	// Bit G7_IO4.
	TSC_IOASCR_G7_IO4 = 0x8000000
	// Position of G8_IO1 field.
	TSC_IOASCR_G8_IO1_Pos = 0x1c
	// Bit mask of G8_IO1 field.
	TSC_IOASCR_G8_IO1_Msk = 0x10000000
	// Bit G8_IO1.
	TSC_IOASCR_G8_IO1 = 0x10000000
	// Position of G8_IO2 field.
	TSC_IOASCR_G8_IO2_Pos = 0x1d
	// Bit mask of G8_IO2 field.
	TSC_IOASCR_G8_IO2_Msk = 0x20000000
	// Bit G8_IO2.
	TSC_IOASCR_G8_IO2 = 0x20000000
	// Position of G8_IO3 field.
	TSC_IOASCR_G8_IO3_Pos = 0x1e
	// Bit mask of G8_IO3 field.
	TSC_IOASCR_G8_IO3_Msk = 0x40000000
	// Bit G8_IO3.
	TSC_IOASCR_G8_IO3 = 0x40000000
	// Position of G8_IO4 field.
	TSC_IOASCR_G8_IO4_Pos = 0x1f
	// Bit mask of G8_IO4 field.
	TSC_IOASCR_G8_IO4_Msk = 0x80000000
	// Bit G8_IO4.
	TSC_IOASCR_G8_IO4 = 0x80000000

	// IOSCR: I/O sampling control register
	// Position of G1_IO1 field.
	TSC_IOSCR_G1_IO1_Pos = 0x0
	// Bit mask of G1_IO1 field.
	TSC_IOSCR_G1_IO1_Msk = 0x1
	// Bit G1_IO1.
	TSC_IOSCR_G1_IO1 = 0x1
	// Position of G1_IO2 field.
	TSC_IOSCR_G1_IO2_Pos = 0x1
	// Bit mask of G1_IO2 field.
	TSC_IOSCR_G1_IO2_Msk = 0x2
	// Bit G1_IO2.
	TSC_IOSCR_G1_IO2 = 0x2
	// Position of G1_IO3 field.
	TSC_IOSCR_G1_IO3_Pos = 0x2
	// Bit mask of G1_IO3 field.
	TSC_IOSCR_G1_IO3_Msk = 0x4
	// Bit G1_IO3.
	TSC_IOSCR_G1_IO3 = 0x4
	// Position of G1_IO4 field.
	TSC_IOSCR_G1_IO4_Pos = 0x3
	// Bit mask of G1_IO4 field.
	TSC_IOSCR_G1_IO4_Msk = 0x8
	// Bit G1_IO4.
	TSC_IOSCR_G1_IO4 = 0x8
	// Position of G2_IO1 field.
	TSC_IOSCR_G2_IO1_Pos = 0x4
	// Bit mask of G2_IO1 field.
	TSC_IOSCR_G2_IO1_Msk = 0x10
	// Bit G2_IO1.
	TSC_IOSCR_G2_IO1 = 0x10
	// Position of G2_IO2 field.
	TSC_IOSCR_G2_IO2_Pos = 0x5
	// Bit mask of G2_IO2 field.
	TSC_IOSCR_G2_IO2_Msk = 0x20
	// Bit G2_IO2.
	TSC_IOSCR_G2_IO2 = 0x20
	// Position of G2_IO3 field.
	TSC_IOSCR_G2_IO3_Pos = 0x6
	// Bit mask of G2_IO3 field.
	TSC_IOSCR_G2_IO3_Msk = 0x40
	// Bit G2_IO3.
	TSC_IOSCR_G2_IO3 = 0x40
	// Position of G2_IO4 field.
	TSC_IOSCR_G2_IO4_Pos = 0x7
	// Bit mask of G2_IO4 field.
	TSC_IOSCR_G2_IO4_Msk = 0x80
	// Bit G2_IO4.
	TSC_IOSCR_G2_IO4 = 0x80
	// Position of G3_IO1 field.
	TSC_IOSCR_G3_IO1_Pos = 0x8
	// Bit mask of G3_IO1 field.
	TSC_IOSCR_G3_IO1_Msk = 0x100
	// Bit G3_IO1.
	TSC_IOSCR_G3_IO1 = 0x100
	// Position of G3_IO2 field.
	TSC_IOSCR_G3_IO2_Pos = 0x9
	// Bit mask of G3_IO2 field.
	TSC_IOSCR_G3_IO2_Msk = 0x200
	// Bit G3_IO2.
	TSC_IOSCR_G3_IO2 = 0x200
	// Position of G3_IO3 field.
	TSC_IOSCR_G3_IO3_Pos = 0xa
	// Bit mask of G3_IO3 field.
	TSC_IOSCR_G3_IO3_Msk = 0x400
	// Bit G3_IO3.
	TSC_IOSCR_G3_IO3 = 0x400
	// Position of G3_IO4 field.
	TSC_IOSCR_G3_IO4_Pos = 0xb
	// Bit mask of G3_IO4 field.
	TSC_IOSCR_G3_IO4_Msk = 0x800
	// Bit G3_IO4.
	TSC_IOSCR_G3_IO4 = 0x800
	// Position of G4_IO1 field.
	TSC_IOSCR_G4_IO1_Pos = 0xc
	// Bit mask of G4_IO1 field.
	TSC_IOSCR_G4_IO1_Msk = 0x1000
	// Bit G4_IO1.
	TSC_IOSCR_G4_IO1 = 0x1000
	// Position of G4_IO2 field.
	TSC_IOSCR_G4_IO2_Pos = 0xd
	// Bit mask of G4_IO2 field.
	TSC_IOSCR_G4_IO2_Msk = 0x2000
	// Bit G4_IO2.
	TSC_IOSCR_G4_IO2 = 0x2000
	// Position of G4_IO3 field.
	TSC_IOSCR_G4_IO3_Pos = 0xe
	// Bit mask of G4_IO3 field.
	TSC_IOSCR_G4_IO3_Msk = 0x4000
	// Bit G4_IO3.
	TSC_IOSCR_G4_IO3 = 0x4000
	// Position of G4_IO4 field.
	TSC_IOSCR_G4_IO4_Pos = 0xf
	// Bit mask of G4_IO4 field.
	TSC_IOSCR_G4_IO4_Msk = 0x8000
	// Bit G4_IO4.
	TSC_IOSCR_G4_IO4 = 0x8000
	// Position of G5_IO1 field.
	TSC_IOSCR_G5_IO1_Pos = 0x10
	// Bit mask of G5_IO1 field.
	TSC_IOSCR_G5_IO1_Msk = 0x10000
	// Bit G5_IO1.
	TSC_IOSCR_G5_IO1 = 0x10000
	// Position of G5_IO2 field.
	TSC_IOSCR_G5_IO2_Pos = 0x11
	// Bit mask of G5_IO2 field.
	TSC_IOSCR_G5_IO2_Msk = 0x20000
	// Bit G5_IO2.
	TSC_IOSCR_G5_IO2 = 0x20000
	// Position of G5_IO3 field.
	TSC_IOSCR_G5_IO3_Pos = 0x12
	// Bit mask of G5_IO3 field.
	TSC_IOSCR_G5_IO3_Msk = 0x40000
	// Bit G5_IO3.
	TSC_IOSCR_G5_IO3 = 0x40000
	// Position of G5_IO4 field.
	TSC_IOSCR_G5_IO4_Pos = 0x13
	// Bit mask of G5_IO4 field.
	TSC_IOSCR_G5_IO4_Msk = 0x80000
	// Bit G5_IO4.
	TSC_IOSCR_G5_IO4 = 0x80000
	// Position of G6_IO1 field.
	TSC_IOSCR_G6_IO1_Pos = 0x14
	// Bit mask of G6_IO1 field.
	TSC_IOSCR_G6_IO1_Msk = 0x100000
	// Bit G6_IO1.
	TSC_IOSCR_G6_IO1 = 0x100000
	// Position of G6_IO2 field.
	TSC_IOSCR_G6_IO2_Pos = 0x15
	// Bit mask of G6_IO2 field.
	TSC_IOSCR_G6_IO2_Msk = 0x200000
	// Bit G6_IO2.
	TSC_IOSCR_G6_IO2 = 0x200000
	// Position of G6_IO3 field.
	TSC_IOSCR_G6_IO3_Pos = 0x16
	// Bit mask of G6_IO3 field.
	TSC_IOSCR_G6_IO3_Msk = 0x400000
	// Bit G6_IO3.
	TSC_IOSCR_G6_IO3 = 0x400000
	// Position of G6_IO4 field.
	TSC_IOSCR_G6_IO4_Pos = 0x17
	// Bit mask of G6_IO4 field.
	TSC_IOSCR_G6_IO4_Msk = 0x800000
	// Bit G6_IO4.
	TSC_IOSCR_G6_IO4 = 0x800000
	// Position of G7_IO1 field.
	TSC_IOSCR_G7_IO1_Pos = 0x18
	// Bit mask of G7_IO1 field.
	TSC_IOSCR_G7_IO1_Msk = 0x1000000
	// Bit G7_IO1.
	TSC_IOSCR_G7_IO1 = 0x1000000
	// Position of G7_IO2 field.
	TSC_IOSCR_G7_IO2_Pos = 0x19
	// Bit mask of G7_IO2 field.
	TSC_IOSCR_G7_IO2_Msk = 0x2000000
	// Bit G7_IO2.
	TSC_IOSCR_G7_IO2 = 0x2000000
	// Position of G7_IO3 field.
	TSC_IOSCR_G7_IO3_Pos = 0x1a
	// Bit mask of G7_IO3 field.
	TSC_IOSCR_G7_IO3_Msk = 0x4000000
	// Bit G7_IO3.
	TSC_IOSCR_G7_IO3 = 0x4000000
	// Position of G7_IO4 field.
	TSC_IOSCR_G7_IO4_Pos = 0x1b
	// Bit mask of G7_IO4 field.
	TSC_IOSCR_G7_IO4_Msk = 0x8000000
	// Bit G7_IO4.
	TSC_IOSCR_G7_IO4 = 0x8000000
	// Position of G8_IO1 field.
	TSC_IOSCR_G8_IO1_Pos = 0x1c
	// Bit mask of G8_IO1 field.
	TSC_IOSCR_G8_IO1_Msk = 0x10000000
	// Bit G8_IO1.
	TSC_IOSCR_G8_IO1 = 0x10000000
	// Position of G8_IO2 field.
	TSC_IOSCR_G8_IO2_Pos = 0x1d
	// Bit mask of G8_IO2 field.
	TSC_IOSCR_G8_IO2_Msk = 0x20000000
	// Bit G8_IO2.
	TSC_IOSCR_G8_IO2 = 0x20000000
	// Position of G8_IO3 field.
	TSC_IOSCR_G8_IO3_Pos = 0x1e
	// Bit mask of G8_IO3 field.
	TSC_IOSCR_G8_IO3_Msk = 0x40000000
	// Bit G8_IO3.
	TSC_IOSCR_G8_IO3 = 0x40000000
	// Position of G8_IO4 field.
	TSC_IOSCR_G8_IO4_Pos = 0x1f
	// Bit mask of G8_IO4 field.
	TSC_IOSCR_G8_IO4_Msk = 0x80000000
	// Bit G8_IO4.
	TSC_IOSCR_G8_IO4 = 0x80000000

	// IOCCR: I/O channel control register
	// Position of G1_IO1 field.
	TSC_IOCCR_G1_IO1_Pos = 0x0
	// Bit mask of G1_IO1 field.
	TSC_IOCCR_G1_IO1_Msk = 0x1
	// Bit G1_IO1.
	TSC_IOCCR_G1_IO1 = 0x1
	// Position of G1_IO2 field.
	TSC_IOCCR_G1_IO2_Pos = 0x1
	// Bit mask of G1_IO2 field.
	TSC_IOCCR_G1_IO2_Msk = 0x2
	// Bit G1_IO2.
	TSC_IOCCR_G1_IO2 = 0x2
	// Position of G1_IO3 field.
	TSC_IOCCR_G1_IO3_Pos = 0x2
	// Bit mask of G1_IO3 field.
	TSC_IOCCR_G1_IO3_Msk = 0x4
	// Bit G1_IO3.
	TSC_IOCCR_G1_IO3 = 0x4
	// Position of G1_IO4 field.
	TSC_IOCCR_G1_IO4_Pos = 0x3
	// Bit mask of G1_IO4 field.
	TSC_IOCCR_G1_IO4_Msk = 0x8
	// Bit G1_IO4.
	TSC_IOCCR_G1_IO4 = 0x8
	// Position of G2_IO1 field.
	TSC_IOCCR_G2_IO1_Pos = 0x4
	// Bit mask of G2_IO1 field.
	TSC_IOCCR_G2_IO1_Msk = 0x10
	// Bit G2_IO1.
	TSC_IOCCR_G2_IO1 = 0x10
	// Position of G2_IO2 field.
	TSC_IOCCR_G2_IO2_Pos = 0x5
	// Bit mask of G2_IO2 field.
	TSC_IOCCR_G2_IO2_Msk = 0x20
	// Bit G2_IO2.
	TSC_IOCCR_G2_IO2 = 0x20
	// Position of G2_IO3 field.
	TSC_IOCCR_G2_IO3_Pos = 0x6
	// Bit mask of G2_IO3 field.
	TSC_IOCCR_G2_IO3_Msk = 0x40
	// Bit G2_IO3.
	TSC_IOCCR_G2_IO3 = 0x40
	// Position of G2_IO4 field.
	TSC_IOCCR_G2_IO4_Pos = 0x7
	// Bit mask of G2_IO4 field.
	TSC_IOCCR_G2_IO4_Msk = 0x80
	// Bit G2_IO4.
	TSC_IOCCR_G2_IO4 = 0x80
	// Position of G3_IO1 field.
	TSC_IOCCR_G3_IO1_Pos = 0x8
	// Bit mask of G3_IO1 field.
	TSC_IOCCR_G3_IO1_Msk = 0x100
	// Bit G3_IO1.
	TSC_IOCCR_G3_IO1 = 0x100
	// Position of G3_IO2 field.
	TSC_IOCCR_G3_IO2_Pos = 0x9
	// Bit mask of G3_IO2 field.
	TSC_IOCCR_G3_IO2_Msk = 0x200
	// Bit G3_IO2.
	TSC_IOCCR_G3_IO2 = 0x200
	// Position of G3_IO3 field.
	TSC_IOCCR_G3_IO3_Pos = 0xa
	// Bit mask of G3_IO3 field.
	TSC_IOCCR_G3_IO3_Msk = 0x400
	// Bit G3_IO3.
	TSC_IOCCR_G3_IO3 = 0x400
	// Position of G3_IO4 field.
	TSC_IOCCR_G3_IO4_Pos = 0xb
	// Bit mask of G3_IO4 field.
	TSC_IOCCR_G3_IO4_Msk = 0x800
	// Bit G3_IO4.
	TSC_IOCCR_G3_IO4 = 0x800
	// Position of G4_IO1 field.
	TSC_IOCCR_G4_IO1_Pos = 0xc
	// Bit mask of G4_IO1 field.
	TSC_IOCCR_G4_IO1_Msk = 0x1000
	// Bit G4_IO1.
	TSC_IOCCR_G4_IO1 = 0x1000
	// Position of G4_IO2 field.
	TSC_IOCCR_G4_IO2_Pos = 0xd
	// Bit mask of G4_IO2 field.
	TSC_IOCCR_G4_IO2_Msk = 0x2000
	// Bit G4_IO2.
	TSC_IOCCR_G4_IO2 = 0x2000
	// Position of G4_IO3 field.
	TSC_IOCCR_G4_IO3_Pos = 0xe
	// Bit mask of G4_IO3 field.
	TSC_IOCCR_G4_IO3_Msk = 0x4000
	// Bit G4_IO3.
	TSC_IOCCR_G4_IO3 = 0x4000
	// Position of G4_IO4 field.
	TSC_IOCCR_G4_IO4_Pos = 0xf
	// Bit mask of G4_IO4 field.
	TSC_IOCCR_G4_IO4_Msk = 0x8000
	// Bit G4_IO4.
	TSC_IOCCR_G4_IO4 = 0x8000
	// Position of G5_IO1 field.
	TSC_IOCCR_G5_IO1_Pos = 0x10
	// Bit mask of G5_IO1 field.
	TSC_IOCCR_G5_IO1_Msk = 0x10000
	// Bit G5_IO1.
	TSC_IOCCR_G5_IO1 = 0x10000
	// Position of G5_IO2 field.
	TSC_IOCCR_G5_IO2_Pos = 0x11
	// Bit mask of G5_IO2 field.
	TSC_IOCCR_G5_IO2_Msk = 0x20000
	// Bit G5_IO2.
	TSC_IOCCR_G5_IO2 = 0x20000
	// Position of G5_IO3 field.
	TSC_IOCCR_G5_IO3_Pos = 0x12
	// Bit mask of G5_IO3 field.
	TSC_IOCCR_G5_IO3_Msk = 0x40000
	// Bit G5_IO3.
	TSC_IOCCR_G5_IO3 = 0x40000
	// Position of G5_IO4 field.
	TSC_IOCCR_G5_IO4_Pos = 0x13
	// Bit mask of G5_IO4 field.
	TSC_IOCCR_G5_IO4_Msk = 0x80000
	// Bit G5_IO4.
	TSC_IOCCR_G5_IO4 = 0x80000
	// Position of G6_IO1 field.
	TSC_IOCCR_G6_IO1_Pos = 0x14
	// Bit mask of G6_IO1 field.
	TSC_IOCCR_G6_IO1_Msk = 0x100000
	// Bit G6_IO1.
	TSC_IOCCR_G6_IO1 = 0x100000
	// Position of G6_IO2 field.
	TSC_IOCCR_G6_IO2_Pos = 0x15
	// Bit mask of G6_IO2 field.
	TSC_IOCCR_G6_IO2_Msk = 0x200000
	// Bit G6_IO2.
	TSC_IOCCR_G6_IO2 = 0x200000
	// Position of G6_IO3 field.
	TSC_IOCCR_G6_IO3_Pos = 0x16
	// Bit mask of G6_IO3 field.
	TSC_IOCCR_G6_IO3_Msk = 0x400000
	// Bit G6_IO3.
	TSC_IOCCR_G6_IO3 = 0x400000
	// Position of G6_IO4 field.
	TSC_IOCCR_G6_IO4_Pos = 0x17
	// Bit mask of G6_IO4 field.
	TSC_IOCCR_G6_IO4_Msk = 0x800000
	// Bit G6_IO4.
	TSC_IOCCR_G6_IO4 = 0x800000
	// Position of G7_IO1 field.
	TSC_IOCCR_G7_IO1_Pos = 0x18
	// Bit mask of G7_IO1 field.
	TSC_IOCCR_G7_IO1_Msk = 0x1000000
	// Bit G7_IO1.
	TSC_IOCCR_G7_IO1 = 0x1000000
	// Position of G7_IO2 field.
	TSC_IOCCR_G7_IO2_Pos = 0x19
	// Bit mask of G7_IO2 field.
	TSC_IOCCR_G7_IO2_Msk = 0x2000000
	// Bit G7_IO2.
	TSC_IOCCR_G7_IO2 = 0x2000000
	// Position of G7_IO3 field.
	TSC_IOCCR_G7_IO3_Pos = 0x1a
	// Bit mask of G7_IO3 field.
	TSC_IOCCR_G7_IO3_Msk = 0x4000000
	// Bit G7_IO3.
	TSC_IOCCR_G7_IO3 = 0x4000000
	// Position of G7_IO4 field.
	TSC_IOCCR_G7_IO4_Pos = 0x1b
	// Bit mask of G7_IO4 field.
	TSC_IOCCR_G7_IO4_Msk = 0x8000000
	// Bit G7_IO4.
	TSC_IOCCR_G7_IO4 = 0x8000000
	// Position of G8_IO1 field.
	TSC_IOCCR_G8_IO1_Pos = 0x1c
	// Bit mask of G8_IO1 field.
	TSC_IOCCR_G8_IO1_Msk = 0x10000000
	// Bit G8_IO1.
	TSC_IOCCR_G8_IO1 = 0x10000000
	// Position of G8_IO2 field.
	TSC_IOCCR_G8_IO2_Pos = 0x1d
	// Bit mask of G8_IO2 field.
	TSC_IOCCR_G8_IO2_Msk = 0x20000000
	// Bit G8_IO2.
	TSC_IOCCR_G8_IO2 = 0x20000000
	// Position of G8_IO3 field.
	TSC_IOCCR_G8_IO3_Pos = 0x1e
	// Bit mask of G8_IO3 field.
	TSC_IOCCR_G8_IO3_Msk = 0x40000000
	// Bit G8_IO3.
	TSC_IOCCR_G8_IO3 = 0x40000000
	// Position of G8_IO4 field.
	TSC_IOCCR_G8_IO4_Pos = 0x1f
	// Bit mask of G8_IO4 field.
	TSC_IOCCR_G8_IO4_Msk = 0x80000000
	// Bit G8_IO4.
	TSC_IOCCR_G8_IO4 = 0x80000000

	// IOGCSR: I/O group control status register
	// Position of G8S field.
	TSC_IOGCSR_G8S_Pos = 0x17
	// Bit mask of G8S field.
	TSC_IOGCSR_G8S_Msk = 0x800000
	// Bit G8S.
	TSC_IOGCSR_G8S = 0x800000
	// Position of G7S field.
	TSC_IOGCSR_G7S_Pos = 0x16
	// Bit mask of G7S field.
	TSC_IOGCSR_G7S_Msk = 0x400000
	// Bit G7S.
	TSC_IOGCSR_G7S = 0x400000
	// Position of G6S field.
	TSC_IOGCSR_G6S_Pos = 0x15
	// Bit mask of G6S field.
	TSC_IOGCSR_G6S_Msk = 0x200000
	// Bit G6S.
	TSC_IOGCSR_G6S = 0x200000
	// Position of G5S field.
	TSC_IOGCSR_G5S_Pos = 0x14
	// Bit mask of G5S field.
	TSC_IOGCSR_G5S_Msk = 0x100000
	// Bit G5S.
	TSC_IOGCSR_G5S = 0x100000
	// Position of G4S field.
	TSC_IOGCSR_G4S_Pos = 0x13
	// Bit mask of G4S field.
	TSC_IOGCSR_G4S_Msk = 0x80000
	// Bit G4S.
	TSC_IOGCSR_G4S = 0x80000
	// Position of G3S field.
	TSC_IOGCSR_G3S_Pos = 0x12
	// Bit mask of G3S field.
	TSC_IOGCSR_G3S_Msk = 0x40000
	// Bit G3S.
	TSC_IOGCSR_G3S = 0x40000
	// Position of G2S field.
	TSC_IOGCSR_G2S_Pos = 0x11
	// Bit mask of G2S field.
	TSC_IOGCSR_G2S_Msk = 0x20000
	// Bit G2S.
	TSC_IOGCSR_G2S = 0x20000
	// Position of G1S field.
	TSC_IOGCSR_G1S_Pos = 0x10
	// Bit mask of G1S field.
	TSC_IOGCSR_G1S_Msk = 0x10000
	// Bit G1S.
	TSC_IOGCSR_G1S = 0x10000
	// Position of G8E field.
	TSC_IOGCSR_G8E_Pos = 0x7
	// Bit mask of G8E field.
	TSC_IOGCSR_G8E_Msk = 0x80
	// Bit G8E.
	TSC_IOGCSR_G8E = 0x80
	// Position of G7E field.
	TSC_IOGCSR_G7E_Pos = 0x6
	// Bit mask of G7E field.
	TSC_IOGCSR_G7E_Msk = 0x40
	// Bit G7E.
	TSC_IOGCSR_G7E = 0x40
	// Position of G6E field.
	TSC_IOGCSR_G6E_Pos = 0x5
	// Bit mask of G6E field.
	TSC_IOGCSR_G6E_Msk = 0x20
	// Bit G6E.
	TSC_IOGCSR_G6E = 0x20
	// Position of G5E field.
	TSC_IOGCSR_G5E_Pos = 0x4
	// Bit mask of G5E field.
	TSC_IOGCSR_G5E_Msk = 0x10
	// Bit G5E.
	TSC_IOGCSR_G5E = 0x10
	// Position of G4E field.
	TSC_IOGCSR_G4E_Pos = 0x3
	// Bit mask of G4E field.
	TSC_IOGCSR_G4E_Msk = 0x8
	// Bit G4E.
	TSC_IOGCSR_G4E = 0x8
	// Position of G3E field.
	TSC_IOGCSR_G3E_Pos = 0x2
	// Bit mask of G3E field.
	TSC_IOGCSR_G3E_Msk = 0x4
	// Bit G3E.
	TSC_IOGCSR_G3E = 0x4
	// Position of G2E field.
	TSC_IOGCSR_G2E_Pos = 0x1
	// Bit mask of G2E field.
	TSC_IOGCSR_G2E_Msk = 0x2
	// Bit G2E.
	TSC_IOGCSR_G2E = 0x2
	// Position of G1E field.
	TSC_IOGCSR_G1E_Pos = 0x0
	// Bit mask of G1E field.
	TSC_IOGCSR_G1E_Msk = 0x1
	// Bit G1E.
	TSC_IOGCSR_G1E = 0x1

	// IOG1CR: I/O group x counter register
	// Position of CNT field.
	TSC_IOGCR_CNT_Pos = 0x0
	// Bit mask of CNT field.
	TSC_IOGCR_CNT_Msk = 0x3fff
)

// Bitfields for CRC: cyclic redundancy check calculation unit
const (
	// DR: Data register
	// Position of DR field.
	CRC_DR_DR_Pos = 0x0
	// Bit mask of DR field.
	CRC_DR_DR_Msk = 0xffffffff

	// DR8: Data register - byte sized
	// Position of DR8 field.
	CRC_DR8_DR8_Pos = 0x0
	// Bit mask of DR8 field.
	CRC_DR8_DR8_Msk = 0xff

	// DR16: Data register - half-word sized
	// Position of DR16 field.
	CRC_DR16_DR16_Pos = 0x0
	// Bit mask of DR16 field.
	CRC_DR16_DR16_Msk = 0xffff

	// IDR: Independent data register
	// Position of IDR field.
	CRC_IDR_IDR_Pos = 0x0
	// Bit mask of IDR field.
	CRC_IDR_IDR_Msk = 0xff

	// CR: Control register
	// Position of RESET field.
	CRC_CR_RESET_Pos = 0x0
	// Bit mask of RESET field.
	CRC_CR_RESET_Msk = 0x1
	// Bit RESET.
	CRC_CR_RESET = 0x1
	// Resets the CRC calculation unit and sets the data register to 0xFFFF FFFF
	CRC_CR_RESET_Reset = 0x1
	// Position of POLYSIZE field.
	CRC_CR_POLYSIZE_Pos = 0x3
	// Bit mask of POLYSIZE field.
	CRC_CR_POLYSIZE_Msk = 0x18
	// 32-bit polynomial
	CRC_CR_POLYSIZE_Polysize32 = 0x0
	// 16-bit polynomial
	CRC_CR_POLYSIZE_Polysize16 = 0x1
	// 8-bit polynomial
	CRC_CR_POLYSIZE_Polysize8 = 0x2
	// 7-bit polynomial
	CRC_CR_POLYSIZE_Polysize7 = 0x3
	// Position of REV_IN field.
	CRC_CR_REV_IN_Pos = 0x5
	// Bit mask of REV_IN field.
	CRC_CR_REV_IN_Msk = 0x60
	// Bit order not affected
	CRC_CR_REV_IN_Normal = 0x0
	// Bit reversal done by byte
	CRC_CR_REV_IN_Byte = 0x1
	// Bit reversal done by half-word
	CRC_CR_REV_IN_HalfWord = 0x2
	// Bit reversal done by word
	CRC_CR_REV_IN_Word = 0x3
	// Position of REV_OUT field.
	CRC_CR_REV_OUT_Pos = 0x7
	// Bit mask of REV_OUT field.
	CRC_CR_REV_OUT_Msk = 0x80
	// Bit REV_OUT.
	CRC_CR_REV_OUT = 0x80
	// Bit order not affected
	CRC_CR_REV_OUT_Normal = 0x0
	// Bit reversed output
	CRC_CR_REV_OUT_Reversed = 0x1

	// INIT: Initial CRC value
	// Position of INIT field.
	CRC_INIT_INIT_Pos = 0x0
	// Bit mask of INIT field.
	CRC_INIT_INIT_Msk = 0xffffffff

	// POL: CRC polynomial
	// Position of POL field.
	CRC_POL_POL_Pos = 0x0
	// Bit mask of POL field.
	CRC_POL_POL_Msk = 0xffffffff
)

// Bitfields for FLASH: Flash
const (
	// ACR: Flash access control register
	// Position of LATENCY field.
	Flash_ACR_LATENCY_Pos = 0x0
	// Bit mask of LATENCY field.
	Flash_ACR_LATENCY_Msk = 0x7
	// 0 wait states, if 0 < HCLK <= 24 MHz
	Flash_ACR_LATENCY_WS0 = 0x0
	// 1 wait state, if 24 < HCLK <= 48 MHz
	Flash_ACR_LATENCY_WS1 = 0x1
	// 2 wait states, if 48 < HCLK <= 72 MHz
	Flash_ACR_LATENCY_WS2 = 0x2
	// Position of PRFTBE field.
	Flash_ACR_PRFTBE_Pos = 0x4
	// Bit mask of PRFTBE field.
	Flash_ACR_PRFTBE_Msk = 0x10
	// Bit PRFTBE.
	Flash_ACR_PRFTBE = 0x10
	// Prefetch is disabled
	Flash_ACR_PRFTBE_Disabled = 0x0
	// Prefetch is enabled
	Flash_ACR_PRFTBE_Enabled = 0x1
	// Position of PRFTBS field.
	Flash_ACR_PRFTBS_Pos = 0x5
	// Bit mask of PRFTBS field.
	Flash_ACR_PRFTBS_Msk = 0x20
	// Bit PRFTBS.
	Flash_ACR_PRFTBS = 0x20
	// Prefetch buffer is disabled
	Flash_ACR_PRFTBS_Disabled = 0x0
	// Prefetch buffer is enabled
	Flash_ACR_PRFTBS_Enabled = 0x1
	// Position of HLFCYA field.
	Flash_ACR_HLFCYA_Pos = 0x3
	// Bit mask of HLFCYA field.
	Flash_ACR_HLFCYA_Msk = 0x8
	// Bit HLFCYA.
	Flash_ACR_HLFCYA = 0x8
	// Half cycle is disabled
	Flash_ACR_HLFCYA_Disabled = 0x0
	// Half cycle is enabled
	Flash_ACR_HLFCYA_Enabled = 0x1

	// KEYR: Flash key register
	// Position of FKEYR field.
	Flash_KEYR_FKEYR_Pos = 0x0
	// Bit mask of FKEYR field.
	Flash_KEYR_FKEYR_Msk = 0xffffffff

	// OPTKEYR: Flash option key register
	// Position of OPTKEYR field.
	Flash_OPTKEYR_OPTKEYR_Pos = 0x0
	// Bit mask of OPTKEYR field.
	Flash_OPTKEYR_OPTKEYR_Msk = 0xffffffff

	// SR: Flash status register
	// Position of EOP field.
	Flash_SR_EOP_Pos = 0x5
	// Bit mask of EOP field.
	Flash_SR_EOP_Msk = 0x20
	// Bit EOP.
	Flash_SR_EOP = 0x20
	// No EOP event occurred
	Flash_SR_EOP_NoEvent = 0x0
	// An EOP event occurred
	Flash_SR_EOP_Event = 0x1
	// Reset EOP event
	Flash_SR_EOP_Reset = 0x1
	// Position of WRPRTERR field.
	Flash_SR_WRPRTERR_Pos = 0x4
	// Bit mask of WRPRTERR field.
	Flash_SR_WRPRTERR_Msk = 0x10
	// Bit WRPRTERR.
	Flash_SR_WRPRTERR = 0x10
	// No write protection error occurred
	Flash_SR_WRPRTERR_NoError = 0x0
	// A write protection error occurred
	Flash_SR_WRPRTERR_Error = 0x1
	// Reset write protection error
	Flash_SR_WRPRTERR_Reset = 0x1
	// Position of PGERR field.
	Flash_SR_PGERR_Pos = 0x2
	// Bit mask of PGERR field.
	Flash_SR_PGERR_Msk = 0x4
	// Bit PGERR.
	Flash_SR_PGERR = 0x4
	// No programming error occurred
	Flash_SR_PGERR_NoError = 0x0
	// A programming error occurred
	Flash_SR_PGERR_Error = 0x1
	// Reset programming error
	Flash_SR_PGERR_Reset = 0x1
	// Position of BSY field.
	Flash_SR_BSY_Pos = 0x0
	// Bit mask of BSY field.
	Flash_SR_BSY_Msk = 0x1
	// Bit BSY.
	Flash_SR_BSY = 0x1
	// No write/erase operation is in progress
	Flash_SR_BSY_Inactive = 0x0
	// No write/erase operation is in progress
	Flash_SR_BSY_Active = 0x1

	// CR: Flash control register
	// Position of OBL_LAUNCH field.
	Flash_CR_OBL_LAUNCH_Pos = 0xd
	// Bit mask of OBL_LAUNCH field.
	Flash_CR_OBL_LAUNCH_Msk = 0x2000
	// Bit OBL_LAUNCH.
	Flash_CR_OBL_LAUNCH = 0x2000
	// Force option byte loading inactive
	Flash_CR_OBL_LAUNCH_Inactive = 0x0
	// Force option byte loading active
	Flash_CR_OBL_LAUNCH_Active = 0x1
	// Position of EOPIE field.
	Flash_CR_EOPIE_Pos = 0xc
	// Bit mask of EOPIE field.
	Flash_CR_EOPIE_Msk = 0x1000
	// Bit EOPIE.
	Flash_CR_EOPIE = 0x1000
	// End of operation interrupt disabled
	Flash_CR_EOPIE_Disabled = 0x0
	// End of operation interrupt enabled
	Flash_CR_EOPIE_Enabled = 0x1
	// Position of ERRIE field.
	Flash_CR_ERRIE_Pos = 0xa
	// Bit mask of ERRIE field.
	Flash_CR_ERRIE_Msk = 0x400
	// Bit ERRIE.
	Flash_CR_ERRIE = 0x400
	// Error interrupt generation disabled
	Flash_CR_ERRIE_Disabled = 0x0
	// Error interrupt generation enabled
	Flash_CR_ERRIE_Enabled = 0x1
	// Position of OPTWRE field.
	Flash_CR_OPTWRE_Pos = 0x9
	// Bit mask of OPTWRE field.
	Flash_CR_OPTWRE_Msk = 0x200
	// Bit OPTWRE.
	Flash_CR_OPTWRE = 0x200
	// Option byte write enabled
	Flash_CR_OPTWRE_Disabled = 0x0
	// Option byte write disabled
	Flash_CR_OPTWRE_Enabled = 0x1
	// Position of LOCK field.
	Flash_CR_LOCK_Pos = 0x7
	// Bit mask of LOCK field.
	Flash_CR_LOCK_Msk = 0x80
	// Bit LOCK.
	Flash_CR_LOCK = 0x80
	// FLASH_CR register is unlocked
	Flash_CR_LOCK_Unlocked = 0x0
	// FLASH_CR register is locked
	Flash_CR_LOCK_Locked = 0x1
	// Lock the FLASH_CR register
	Flash_CR_LOCK_Lock = 0x1
	// Position of STRT field.
	Flash_CR_STRT_Pos = 0x6
	// Bit mask of STRT field.
	Flash_CR_STRT_Msk = 0x40
	// Bit STRT.
	Flash_CR_STRT = 0x40
	// Trigger an erase operation
	Flash_CR_STRT_Start = 0x1
	// Position of OPTER field.
	Flash_CR_OPTER_Pos = 0x5
	// Bit mask of OPTER field.
	Flash_CR_OPTER_Msk = 0x20
	// Bit OPTER.
	Flash_CR_OPTER = 0x20
	// Erase option byte activated
	Flash_CR_OPTER_OptionByteErase = 0x1
	// Position of OPTPG field.
	Flash_CR_OPTPG_Pos = 0x4
	// Bit mask of OPTPG field.
	Flash_CR_OPTPG_Msk = 0x10
	// Bit OPTPG.
	Flash_CR_OPTPG = 0x10
	// Program option byte activated
	Flash_CR_OPTPG_OptionByteProgramming = 0x1
	// Position of MER field.
	Flash_CR_MER_Pos = 0x2
	// Bit mask of MER field.
	Flash_CR_MER_Msk = 0x4
	// Bit MER.
	Flash_CR_MER = 0x4
	// Erase activated for all user sectors
	Flash_CR_MER_MassErase = 0x1
	// Position of PER field.
	Flash_CR_PER_Pos = 0x1
	// Bit mask of PER field.
	Flash_CR_PER_Msk = 0x2
	// Bit PER.
	Flash_CR_PER = 0x2
	// Erase activated for selected page
	Flash_CR_PER_PageErase = 0x1
	// Position of PG field.
	Flash_CR_PG_Pos = 0x0
	// Bit mask of PG field.
	Flash_CR_PG_Msk = 0x1
	// Bit PG.
	Flash_CR_PG = 0x1
	// Flash programming activated
	Flash_CR_PG_Program = 0x1

	// AR: Flash address register
	// Position of FAR field.
	Flash_AR_FAR_Pos = 0x0
	// Bit mask of FAR field.
	Flash_AR_FAR_Msk = 0xffffffff

	// OBR: Option byte register
	// Position of OPTERR field.
	Flash_OBR_OPTERR_Pos = 0x0
	// Bit mask of OPTERR field.
	Flash_OBR_OPTERR_Msk = 0x1
	// Bit OPTERR.
	Flash_OBR_OPTERR = 0x1
	// The loaded option byte and its complement do not match
	Flash_OBR_OPTERR_OptionByteError = 0x1
	// Position of WDG_SW field.
	Flash_OBR_WDG_SW_Pos = 0x8
	// Bit mask of WDG_SW field.
	Flash_OBR_WDG_SW_Msk = 0x100
	// Bit WDG_SW.
	Flash_OBR_WDG_SW = 0x100
	// Hardware watchdog
	Flash_OBR_WDG_SW_Hardware = 0x0
	// Software watchdog
	Flash_OBR_WDG_SW_Software = 0x1
	// Position of NRST_STOP field.
	Flash_OBR_NRST_STOP_Pos = 0x9
	// Bit mask of NRST_STOP field.
	Flash_OBR_NRST_STOP_Msk = 0x200
	// Bit NRST_STOP.
	Flash_OBR_NRST_STOP = 0x200
	// Reset generated when entering Stop mode
	Flash_OBR_NRST_STOP_Reset = 0x0
	// No reset generated
	Flash_OBR_NRST_STOP_NoReset = 0x1
	// Position of NRST_STDBY field.
	Flash_OBR_NRST_STDBY_Pos = 0xa
	// Bit mask of NRST_STDBY field.
	Flash_OBR_NRST_STDBY_Msk = 0x400
	// Bit NRST_STDBY.
	Flash_OBR_NRST_STDBY = 0x400
	// Reset generated when entering Standby mode
	Flash_OBR_NRST_STDBY_Reset = 0x0
	// No reset generated
	Flash_OBR_NRST_STDBY_NoReset = 0x1
	// Position of NBOOT1 field.
	Flash_OBR_NBOOT1_Pos = 0xc
	// Bit mask of NBOOT1 field.
	Flash_OBR_NBOOT1_Msk = 0x1000
	// Bit NBOOT1.
	Flash_OBR_NBOOT1 = 0x1000
	// Together with BOOT0, select the device boot mode
	Flash_OBR_NBOOT1_Disabled = 0x0
	// Together with BOOT0, select the device boot mode
	Flash_OBR_NBOOT1_Enabled = 0x1
	// Position of VDDA_MONITOR field.
	Flash_OBR_VDDA_MONITOR_Pos = 0xd
	// Bit mask of VDDA_MONITOR field.
	Flash_OBR_VDDA_MONITOR_Msk = 0x2000
	// Bit VDDA_MONITOR.
	Flash_OBR_VDDA_MONITOR = 0x2000
	// VDDA power supply supervisor disabled
	Flash_OBR_VDDA_MONITOR_Disabled = 0x0
	// VDDA power supply supervisor enabled
	Flash_OBR_VDDA_MONITOR_Enabled = 0x1
	// Position of SRAM_PARITY_CHECK field.
	Flash_OBR_SRAM_PARITY_CHECK_Pos = 0xe
	// Bit mask of SRAM_PARITY_CHECK field.
	Flash_OBR_SRAM_PARITY_CHECK_Msk = 0x4000
	// Bit SRAM_PARITY_CHECK.
	Flash_OBR_SRAM_PARITY_CHECK = 0x4000
	// RAM parity check disabled
	Flash_OBR_SRAM_PARITY_CHECK_Disabled = 0x0
	// RAM parity check enabled
	Flash_OBR_SRAM_PARITY_CHECK_Enabled = 0x1
	// Position of Data0 field.
	Flash_OBR_Data0_Pos = 0x10
	// Bit mask of Data0 field.
	Flash_OBR_Data0_Msk = 0xff0000
	// Position of Data1 field.
	Flash_OBR_Data1_Pos = 0x18
	// Bit mask of Data1 field.
	Flash_OBR_Data1_Msk = 0xff000000
	// Position of RDPRT field.
	Flash_OBR_RDPRT_Pos = 0x1
	// Bit mask of RDPRT field.
	Flash_OBR_RDPRT_Msk = 0x6
	// Level 0
	Flash_OBR_RDPRT_Level0 = 0x0
	// Level 1
	Flash_OBR_RDPRT_Level1 = 0x1
	// Level 2
	Flash_OBR_RDPRT_Level2 = 0x3

	// WRPR: Write protection register
	// Position of WRP field.
	Flash_WRPR_WRP_Pos = 0x0
	// Bit mask of WRP field.
	Flash_WRPR_WRP_Msk = 0xffffffff
)

// Bitfields for RCC: Reset and clock control
const (
	// CR: Clock control register
	// Position of HSION field.
	RCC_CR_HSION_Pos = 0x0
	// Bit mask of HSION field.
	RCC_CR_HSION_Msk = 0x1
	// Bit HSION.
	RCC_CR_HSION = 0x1
	// Clock Off
	RCC_CR_HSION_Off = 0x0
	// Clock On
	RCC_CR_HSION_On = 0x1
	// Position of HSIRDY field.
	RCC_CR_HSIRDY_Pos = 0x1
	// Bit mask of HSIRDY field.
	RCC_CR_HSIRDY_Msk = 0x2
	// Bit HSIRDY.
	RCC_CR_HSIRDY = 0x2
	// Clock not ready
	RCC_CR_HSIRDY_NotReady = 0x0
	// Clock ready
	RCC_CR_HSIRDY_Ready = 0x1
	// Position of HSITRIM field.
	RCC_CR_HSITRIM_Pos = 0x3
	// Bit mask of HSITRIM field.
	RCC_CR_HSITRIM_Msk = 0xf8
	// Position of HSICAL field.
	RCC_CR_HSICAL_Pos = 0x8
	// Bit mask of HSICAL field.
	RCC_CR_HSICAL_Msk = 0xff00
	// Position of HSEON field.
	RCC_CR_HSEON_Pos = 0x10
	// Bit mask of HSEON field.
	RCC_CR_HSEON_Msk = 0x10000
	// Bit HSEON.
	RCC_CR_HSEON = 0x10000
	// Clock Off
	RCC_CR_HSEON_Off = 0x0
	// Clock On
	RCC_CR_HSEON_On = 0x1
	// Position of HSERDY field.
	RCC_CR_HSERDY_Pos = 0x11
	// Bit mask of HSERDY field.
	RCC_CR_HSERDY_Msk = 0x20000
	// Bit HSERDY.
	RCC_CR_HSERDY = 0x20000
	// Clock not ready
	RCC_CR_HSERDY_NotReady = 0x0
	// Clock ready
	RCC_CR_HSERDY_Ready = 0x1
	// Position of HSEBYP field.
	RCC_CR_HSEBYP_Pos = 0x12
	// Bit mask of HSEBYP field.
	RCC_CR_HSEBYP_Msk = 0x40000
	// Bit HSEBYP.
	RCC_CR_HSEBYP = 0x40000
	// HSE crystal oscillator not bypassed
	RCC_CR_HSEBYP_NotBypassed = 0x0
	// HSE crystal oscillator bypassed with external clock
	RCC_CR_HSEBYP_Bypassed = 0x1
	// Position of CSSON field.
	RCC_CR_CSSON_Pos = 0x13
	// Bit mask of CSSON field.
	RCC_CR_CSSON_Msk = 0x80000
	// Bit CSSON.
	RCC_CR_CSSON = 0x80000
	// Clock security system disabled (clock detector OFF)
	RCC_CR_CSSON_Off = 0x0
	// Clock security system enable (clock detector ON if the HSE is ready, OFF if not)
	RCC_CR_CSSON_On = 0x1
	// Position of PLLON field.
	RCC_CR_PLLON_Pos = 0x18
	// Bit mask of PLLON field.
	RCC_CR_PLLON_Msk = 0x1000000
	// Bit PLLON.
	RCC_CR_PLLON = 0x1000000
	// Clock Off
	RCC_CR_PLLON_Off = 0x0
	// Clock On
	RCC_CR_PLLON_On = 0x1
	// Position of PLLRDY field.
	RCC_CR_PLLRDY_Pos = 0x19
	// Bit mask of PLLRDY field.
	RCC_CR_PLLRDY_Msk = 0x2000000
	// Bit PLLRDY.
	RCC_CR_PLLRDY = 0x2000000
	// Clock not ready
	RCC_CR_PLLRDY_NotReady = 0x0
	// Clock ready
	RCC_CR_PLLRDY_Ready = 0x1

	// CFGR: Clock configuration register (RCC_CFGR)
	// Position of SW field.
	RCC_CFGR_SW_Pos = 0x0
	// Bit mask of SW field.
	RCC_CFGR_SW_Msk = 0x3
	// HSI selected as system clock
	RCC_CFGR_SW_HSI = 0x0
	// HSE selected as system clock
	RCC_CFGR_SW_HSE = 0x1
	// PLL selected as system clock
	RCC_CFGR_SW_PLL = 0x2
	// Position of SWS field.
	RCC_CFGR_SWS_Pos = 0x2
	// Bit mask of SWS field.
	RCC_CFGR_SWS_Msk = 0xc
	// HSI oscillator used as system clock
	RCC_CFGR_SWS_HSI = 0x0
	// HSE oscillator used as system clock
	RCC_CFGR_SWS_HSE = 0x1
	// PLL used as system clock
	RCC_CFGR_SWS_PLL = 0x2
	// Position of HPRE field.
	RCC_CFGR_HPRE_Pos = 0x4
	// Bit mask of HPRE field.
	RCC_CFGR_HPRE_Msk = 0xf0
	// SYSCLK not divided
	RCC_CFGR_HPRE_Div1 = 0x0
	// SYSCLK divided by 2
	RCC_CFGR_HPRE_Div2 = 0x8
	// SYSCLK divided by 4
	RCC_CFGR_HPRE_Div4 = 0x9
	// SYSCLK divided by 8
	RCC_CFGR_HPRE_Div8 = 0xa
	// SYSCLK divided by 16
	RCC_CFGR_HPRE_Div16 = 0xb
	// SYSCLK divided by 64
	RCC_CFGR_HPRE_Div64 = 0xc
	// SYSCLK divided by 128
	RCC_CFGR_HPRE_Div128 = 0xd
	// SYSCLK divided by 256
	RCC_CFGR_HPRE_Div256 = 0xe
	// SYSCLK divided by 512
	RCC_CFGR_HPRE_Div512 = 0xf
	// Position of PPRE1 field.
	RCC_CFGR_PPRE1_Pos = 0x8
	// Bit mask of PPRE1 field.
	RCC_CFGR_PPRE1_Msk = 0x700
	// HCLK not divided
	RCC_CFGR_PPRE1_Div1 = 0x0
	// HCLK divided by 2
	RCC_CFGR_PPRE1_Div2 = 0x4
	// HCLK divided by 4
	RCC_CFGR_PPRE1_Div4 = 0x5
	// HCLK divided by 8
	RCC_CFGR_PPRE1_Div8 = 0x6
	// HCLK divided by 16
	RCC_CFGR_PPRE1_Div16 = 0x7
	// Position of PPRE2 field.
	RCC_CFGR_PPRE2_Pos = 0xb
	// Bit mask of PPRE2 field.
	RCC_CFGR_PPRE2_Msk = 0x3800
	// HCLK not divided
	RCC_CFGR_PPRE2_Div1 = 0x0
	// HCLK divided by 2
	RCC_CFGR_PPRE2_Div2 = 0x4
	// HCLK divided by 4
	RCC_CFGR_PPRE2_Div4 = 0x5
	// HCLK divided by 8
	RCC_CFGR_PPRE2_Div8 = 0x6
	// HCLK divided by 16
	RCC_CFGR_PPRE2_Div16 = 0x7
	// Position of PLLSRC field.
	RCC_CFGR_PLLSRC_Pos = 0xf
	// Bit mask of PLLSRC field.
	RCC_CFGR_PLLSRC_Msk = 0x18000
	// HSI divided by 2 selected as PLL input clock
	RCC_CFGR_PLLSRC_HSI_Div2 = 0x0
	// HSI divided by PREDIV selected as PLL input clock
	RCC_CFGR_PLLSRC_HSI_Div_PREDIV = 0x1
	// HSE divided by PREDIV selected as PLL input clock
	RCC_CFGR_PLLSRC_HSE_Div_PREDIV = 0x2
	// Position of PLLXTPRE field.
	RCC_CFGR_PLLXTPRE_Pos = 0x11
	// Bit mask of PLLXTPRE field.
	RCC_CFGR_PLLXTPRE_Msk = 0x20000
	// Bit PLLXTPRE.
	RCC_CFGR_PLLXTPRE = 0x20000
	// HSE clock not divided
	RCC_CFGR_PLLXTPRE_Div1 = 0x0
	// HSE clock divided by 2
	RCC_CFGR_PLLXTPRE_Div2 = 0x1
	// Position of PLLMUL field.
	RCC_CFGR_PLLMUL_Pos = 0x12
	// Bit mask of PLLMUL field.
	RCC_CFGR_PLLMUL_Msk = 0x3c0000
	// PLL input clock x2
	RCC_CFGR_PLLMUL_Mul2 = 0x0
	// PLL input clock x3
	RCC_CFGR_PLLMUL_Mul3 = 0x1
	// PLL input clock x4
	RCC_CFGR_PLLMUL_Mul4 = 0x2
	// PLL input clock x5
	RCC_CFGR_PLLMUL_Mul5 = 0x3
	// PLL input clock x6
	RCC_CFGR_PLLMUL_Mul6 = 0x4
	// PLL input clock x7
	RCC_CFGR_PLLMUL_Mul7 = 0x5
	// PLL input clock x8
	RCC_CFGR_PLLMUL_Mul8 = 0x6
	// PLL input clock x9
	RCC_CFGR_PLLMUL_Mul9 = 0x7
	// PLL input clock x10
	RCC_CFGR_PLLMUL_Mul10 = 0x8
	// PLL input clock x11
	RCC_CFGR_PLLMUL_Mul11 = 0x9
	// PLL input clock x12
	RCC_CFGR_PLLMUL_Mul12 = 0xa
	// PLL input clock x13
	RCC_CFGR_PLLMUL_Mul13 = 0xb
	// PLL input clock x14
	RCC_CFGR_PLLMUL_Mul14 = 0xc
	// PLL input clock x15
	RCC_CFGR_PLLMUL_Mul15 = 0xd
	// PLL input clock x16
	RCC_CFGR_PLLMUL_Mul16 = 0xe
	// PLL input clock x16
	RCC_CFGR_PLLMUL_Mul16x = 0xf
	// Position of USBPRE field.
	RCC_CFGR_USBPRE_Pos = 0x16
	// Bit mask of USBPRE field.
	RCC_CFGR_USBPRE_Msk = 0x400000
	// Bit USBPRE.
	RCC_CFGR_USBPRE = 0x400000
	// PLL clock is divided by 1.5
	RCC_CFGR_USBPRE_DIV1_5 = 0x0
	// PLL clock is not divided
	RCC_CFGR_USBPRE_DIV1 = 0x1
	// Position of MCO field.
	RCC_CFGR_MCO_Pos = 0x18
	// Bit mask of MCO field.
	RCC_CFGR_MCO_Msk = 0x7000000
	// MCO output disabled, no clock on MCO
	RCC_CFGR_MCO_NoMCO = 0x0
	// Internal low speed (LSI) oscillator clock selected
	RCC_CFGR_MCO_LSI = 0x2
	// External low speed (LSE) oscillator clock selected
	RCC_CFGR_MCO_LSE = 0x3
	// System clock selected
	RCC_CFGR_MCO_SYSCLK = 0x4
	// Internal RC 8 MHz (HSI) oscillator clock selected
	RCC_CFGR_MCO_HSI = 0x5
	// External 4-32 MHz (HSE) oscillator clock selected
	RCC_CFGR_MCO_HSE = 0x6
	// PLL clock selected (divided by 1 or 2, depending en PLLNODIV)
	RCC_CFGR_MCO_PLL = 0x7
	// Position of I2SSRC field.
	RCC_CFGR_I2SSRC_Pos = 0x17
	// Bit mask of I2SSRC field.
	RCC_CFGR_I2SSRC_Msk = 0x800000
	// Bit I2SSRC.
	RCC_CFGR_I2SSRC = 0x800000
	// System clock used as I2S clock source
	RCC_CFGR_I2SSRC_SYSCLK = 0x0
	// External clock mapped on the I2S_CKIN pin used as I2S clock source
	RCC_CFGR_I2SSRC_CKIN = 0x1
	// Position of MCOPRE field.
	RCC_CFGR_MCOPRE_Pos = 0x1c
	// Bit mask of MCOPRE field.
	RCC_CFGR_MCOPRE_Msk = 0x70000000
	// MCO is divided by 1
	RCC_CFGR_MCOPRE_Div1 = 0x0
	// MCO is divided by 2
	RCC_CFGR_MCOPRE_Div2 = 0x1
	// MCO is divided by 4
	RCC_CFGR_MCOPRE_Div4 = 0x2
	// MCO is divided by 8
	RCC_CFGR_MCOPRE_Div8 = 0x3
	// MCO is divided by 16
	RCC_CFGR_MCOPRE_Div16 = 0x4
	// MCO is divided by 32
	RCC_CFGR_MCOPRE_Div32 = 0x5
	// MCO is divided by 64
	RCC_CFGR_MCOPRE_Div64 = 0x6
	// MCO is divided by 128
	RCC_CFGR_MCOPRE_Div128 = 0x7
	// Position of PLLNODIV field.
	RCC_CFGR_PLLNODIV_Pos = 0x1f
	// Bit mask of PLLNODIV field.
	RCC_CFGR_PLLNODIV_Msk = 0x80000000
	// Bit PLLNODIV.
	RCC_CFGR_PLLNODIV = 0x80000000
	// PLL is divided by 2 for MCO
	RCC_CFGR_PLLNODIV_Div2 = 0x0
	// PLL is not divided for MCO
	RCC_CFGR_PLLNODIV_Div1 = 0x1

	// CIR: Clock interrupt register (RCC_CIR)
	// Position of LSIRDYF field.
	RCC_CIR_LSIRDYF_Pos = 0x0
	// Bit mask of LSIRDYF field.
	RCC_CIR_LSIRDYF_Msk = 0x1
	// Bit LSIRDYF.
	RCC_CIR_LSIRDYF = 0x1
	// No clock ready interrupt
	RCC_CIR_LSIRDYF_NotInterrupted = 0x0
	// Clock ready interrupt
	RCC_CIR_LSIRDYF_Interrupted = 0x1
	// Position of LSERDYF field.
	RCC_CIR_LSERDYF_Pos = 0x1
	// Bit mask of LSERDYF field.
	RCC_CIR_LSERDYF_Msk = 0x2
	// Bit LSERDYF.
	RCC_CIR_LSERDYF = 0x2
	// No clock ready interrupt
	RCC_CIR_LSERDYF_NotInterrupted = 0x0
	// Clock ready interrupt
	RCC_CIR_LSERDYF_Interrupted = 0x1
	// Position of HSIRDYF field.
	RCC_CIR_HSIRDYF_Pos = 0x2
	// Bit mask of HSIRDYF field.
	RCC_CIR_HSIRDYF_Msk = 0x4
	// Bit HSIRDYF.
	RCC_CIR_HSIRDYF = 0x4
	// No clock ready interrupt
	RCC_CIR_HSIRDYF_NotInterrupted = 0x0
	// Clock ready interrupt
	RCC_CIR_HSIRDYF_Interrupted = 0x1
	// Position of HSERDYF field.
	RCC_CIR_HSERDYF_Pos = 0x3
	// Bit mask of HSERDYF field.
	RCC_CIR_HSERDYF_Msk = 0x8
	// Bit HSERDYF.
	RCC_CIR_HSERDYF = 0x8
	// No clock ready interrupt
	RCC_CIR_HSERDYF_NotInterrupted = 0x0
	// Clock ready interrupt
	RCC_CIR_HSERDYF_Interrupted = 0x1
	// Position of PLLRDYF field.
	RCC_CIR_PLLRDYF_Pos = 0x4
	// Bit mask of PLLRDYF field.
	RCC_CIR_PLLRDYF_Msk = 0x10
	// Bit PLLRDYF.
	RCC_CIR_PLLRDYF = 0x10
	// No clock ready interrupt
	RCC_CIR_PLLRDYF_NotInterrupted = 0x0
	// Clock ready interrupt
	RCC_CIR_PLLRDYF_Interrupted = 0x1
	// Position of CSSF field.
	RCC_CIR_CSSF_Pos = 0x7
	// Bit mask of CSSF field.
	RCC_CIR_CSSF_Msk = 0x80
	// Bit CSSF.
	RCC_CIR_CSSF = 0x80
	// No clock security interrupt caused by HSE clock failure
	RCC_CIR_CSSF_NotInterrupted = 0x0
	// Clock security interrupt caused by HSE clock failure
	RCC_CIR_CSSF_Interrupted = 0x1
	// Position of LSIRDYIE field.
	RCC_CIR_LSIRDYIE_Pos = 0x8
	// Bit mask of LSIRDYIE field.
	RCC_CIR_LSIRDYIE_Msk = 0x100
	// Bit LSIRDYIE.
	RCC_CIR_LSIRDYIE = 0x100
	// Interrupt disabled
	RCC_CIR_LSIRDYIE_Disabled = 0x0
	// Interrupt enabled
	RCC_CIR_LSIRDYIE_Enabled = 0x1
	// Position of LSERDYIE field.
	RCC_CIR_LSERDYIE_Pos = 0x9
	// Bit mask of LSERDYIE field.
	RCC_CIR_LSERDYIE_Msk = 0x200
	// Bit LSERDYIE.
	RCC_CIR_LSERDYIE = 0x200
	// Interrupt disabled
	RCC_CIR_LSERDYIE_Disabled = 0x0
	// Interrupt enabled
	RCC_CIR_LSERDYIE_Enabled = 0x1
	// Position of HSIRDYIE field.
	RCC_CIR_HSIRDYIE_Pos = 0xa
	// Bit mask of HSIRDYIE field.
	RCC_CIR_HSIRDYIE_Msk = 0x400
	// Bit HSIRDYIE.
	RCC_CIR_HSIRDYIE = 0x400
	// Interrupt disabled
	RCC_CIR_HSIRDYIE_Disabled = 0x0
	// Interrupt enabled
	RCC_CIR_HSIRDYIE_Enabled = 0x1
	// Position of HSERDYIE field.
	RCC_CIR_HSERDYIE_Pos = 0xb
	// Bit mask of HSERDYIE field.
	RCC_CIR_HSERDYIE_Msk = 0x800
	// Bit HSERDYIE.
	RCC_CIR_HSERDYIE = 0x800
	// Interrupt disabled
	RCC_CIR_HSERDYIE_Disabled = 0x0
	// Interrupt enabled
	RCC_CIR_HSERDYIE_Enabled = 0x1
	// Position of PLLRDYIE field.
	RCC_CIR_PLLRDYIE_Pos = 0xc
	// Bit mask of PLLRDYIE field.
	RCC_CIR_PLLRDYIE_Msk = 0x1000
	// Bit PLLRDYIE.
	RCC_CIR_PLLRDYIE = 0x1000
	// Interrupt disabled
	RCC_CIR_PLLRDYIE_Disabled = 0x0
	// Interrupt enabled
	RCC_CIR_PLLRDYIE_Enabled = 0x1
	// Position of LSIRDYC field.
	RCC_CIR_LSIRDYC_Pos = 0x10
	// Bit mask of LSIRDYC field.
	RCC_CIR_LSIRDYC_Msk = 0x10000
	// Bit LSIRDYC.
	RCC_CIR_LSIRDYC = 0x10000
	// Clear interrupt flag
	RCC_CIR_LSIRDYC_Clear = 0x1
	// Position of LSERDYC field.
	RCC_CIR_LSERDYC_Pos = 0x11
	// Bit mask of LSERDYC field.
	RCC_CIR_LSERDYC_Msk = 0x20000
	// Bit LSERDYC.
	RCC_CIR_LSERDYC = 0x20000
	// Clear interrupt flag
	RCC_CIR_LSERDYC_Clear = 0x1
	// Position of HSIRDYC field.
	RCC_CIR_HSIRDYC_Pos = 0x12
	// Bit mask of HSIRDYC field.
	RCC_CIR_HSIRDYC_Msk = 0x40000
	// Bit HSIRDYC.
	RCC_CIR_HSIRDYC = 0x40000
	// Clear interrupt flag
	RCC_CIR_HSIRDYC_Clear = 0x1
	// Position of HSERDYC field.
	RCC_CIR_HSERDYC_Pos = 0x13
	// Bit mask of HSERDYC field.
	RCC_CIR_HSERDYC_Msk = 0x80000
	// Bit HSERDYC.
	RCC_CIR_HSERDYC = 0x80000
	// Clear interrupt flag
	RCC_CIR_HSERDYC_Clear = 0x1
	// Position of PLLRDYC field.
	RCC_CIR_PLLRDYC_Pos = 0x14
	// Bit mask of PLLRDYC field.
	RCC_CIR_PLLRDYC_Msk = 0x100000
	// Bit PLLRDYC.
	RCC_CIR_PLLRDYC = 0x100000
	// Clear interrupt flag
	RCC_CIR_PLLRDYC_Clear = 0x1
	// Position of CSSC field.
	RCC_CIR_CSSC_Pos = 0x17
	// Bit mask of CSSC field.
	RCC_CIR_CSSC_Msk = 0x800000
	// Bit CSSC.
	RCC_CIR_CSSC = 0x800000
	// Clear CSSF flag
	RCC_CIR_CSSC_Clear = 0x1

	// APB2RSTR: APB2 peripheral reset register (RCC_APB2RSTR)
	// Position of SYSCFGRST field.
	RCC_APB2RSTR_SYSCFGRST_Pos = 0x0
	// Bit mask of SYSCFGRST field.
	RCC_APB2RSTR_SYSCFGRST_Msk = 0x1
	// Bit SYSCFGRST.
	RCC_APB2RSTR_SYSCFGRST = 0x1
	// Reset the selected module
	RCC_APB2RSTR_SYSCFGRST_Reset = 0x1
	// Position of TIM1RST field.
	RCC_APB2RSTR_TIM1RST_Pos = 0xb
	// Bit mask of TIM1RST field.
	RCC_APB2RSTR_TIM1RST_Msk = 0x800
	// Bit TIM1RST.
	RCC_APB2RSTR_TIM1RST = 0x800
	// Reset the selected module
	RCC_APB2RSTR_TIM1RST_Reset = 0x1
	// Position of SPI1RST field.
	RCC_APB2RSTR_SPI1RST_Pos = 0xc
	// Bit mask of SPI1RST field.
	RCC_APB2RSTR_SPI1RST_Msk = 0x1000
	// Bit SPI1RST.
	RCC_APB2RSTR_SPI1RST = 0x1000
	// Reset the selected module
	RCC_APB2RSTR_SPI1RST_Reset = 0x1
	// Position of USART1RST field.
	RCC_APB2RSTR_USART1RST_Pos = 0xe
	// Bit mask of USART1RST field.
	RCC_APB2RSTR_USART1RST_Msk = 0x4000
	// Bit USART1RST.
	RCC_APB2RSTR_USART1RST = 0x4000
	// Reset the selected module
	RCC_APB2RSTR_USART1RST_Reset = 0x1
	// Position of TIM15RST field.
	RCC_APB2RSTR_TIM15RST_Pos = 0x10
	// Bit mask of TIM15RST field.
	RCC_APB2RSTR_TIM15RST_Msk = 0x10000
	// Bit TIM15RST.
	RCC_APB2RSTR_TIM15RST = 0x10000
	// Reset the selected module
	RCC_APB2RSTR_TIM15RST_Reset = 0x1
	// Position of TIM16RST field.
	RCC_APB2RSTR_TIM16RST_Pos = 0x11
	// Bit mask of TIM16RST field.
	RCC_APB2RSTR_TIM16RST_Msk = 0x20000
	// Bit TIM16RST.
	RCC_APB2RSTR_TIM16RST = 0x20000
	// Reset the selected module
	RCC_APB2RSTR_TIM16RST_Reset = 0x1
	// Position of TIM17RST field.
	RCC_APB2RSTR_TIM17RST_Pos = 0x12
	// Bit mask of TIM17RST field.
	RCC_APB2RSTR_TIM17RST_Msk = 0x40000
	// Bit TIM17RST.
	RCC_APB2RSTR_TIM17RST = 0x40000
	// Reset the selected module
	RCC_APB2RSTR_TIM17RST_Reset = 0x1
	// Position of SPI4RST field.
	RCC_APB2RSTR_SPI4RST_Pos = 0xf
	// Bit mask of SPI4RST field.
	RCC_APB2RSTR_SPI4RST_Msk = 0x8000
	// Bit SPI4RST.
	RCC_APB2RSTR_SPI4RST = 0x8000
	// Reset the selected module
	RCC_APB2RSTR_SPI4RST_Reset = 0x1

	// APB1RSTR: APB1 peripheral reset register (RCC_APB1RSTR)
	// Position of TIM2RST field.
	RCC_APB1RSTR_TIM2RST_Pos = 0x0
	// Bit mask of TIM2RST field.
	RCC_APB1RSTR_TIM2RST_Msk = 0x1
	// Bit TIM2RST.
	RCC_APB1RSTR_TIM2RST = 0x1
	// Reset the selected module
	RCC_APB1RSTR_TIM2RST_Reset = 0x1
	// Position of TIM3RST field.
	RCC_APB1RSTR_TIM3RST_Pos = 0x1
	// Bit mask of TIM3RST field.
	RCC_APB1RSTR_TIM3RST_Msk = 0x2
	// Bit TIM3RST.
	RCC_APB1RSTR_TIM3RST = 0x2
	// Reset the selected module
	RCC_APB1RSTR_TIM3RST_Reset = 0x1
	// Position of TIM4RST field.
	RCC_APB1RSTR_TIM4RST_Pos = 0x2
	// Bit mask of TIM4RST field.
	RCC_APB1RSTR_TIM4RST_Msk = 0x4
	// Bit TIM4RST.
	RCC_APB1RSTR_TIM4RST = 0x4
	// Reset the selected module
	RCC_APB1RSTR_TIM4RST_Reset = 0x1
	// Position of TIM6RST field.
	RCC_APB1RSTR_TIM6RST_Pos = 0x4
	// Bit mask of TIM6RST field.
	RCC_APB1RSTR_TIM6RST_Msk = 0x10
	// Bit TIM6RST.
	RCC_APB1RSTR_TIM6RST = 0x10
	// Reset the selected module
	RCC_APB1RSTR_TIM6RST_Reset = 0x1
	// Position of WWDGRST field.
	RCC_APB1RSTR_WWDGRST_Pos = 0xb
	// Bit mask of WWDGRST field.
	RCC_APB1RSTR_WWDGRST_Msk = 0x800
	// Bit WWDGRST.
	RCC_APB1RSTR_WWDGRST = 0x800
	// Reset the selected module
	RCC_APB1RSTR_WWDGRST_Reset = 0x1
	// Position of SPI2RST field.
	RCC_APB1RSTR_SPI2RST_Pos = 0xe
	// Bit mask of SPI2RST field.
	RCC_APB1RSTR_SPI2RST_Msk = 0x4000
	// Bit SPI2RST.
	RCC_APB1RSTR_SPI2RST = 0x4000
	// Reset the selected module
	RCC_APB1RSTR_SPI2RST_Reset = 0x1
	// Position of SPI3RST field.
	RCC_APB1RSTR_SPI3RST_Pos = 0xf
	// Bit mask of SPI3RST field.
	RCC_APB1RSTR_SPI3RST_Msk = 0x8000
	// Bit SPI3RST.
	RCC_APB1RSTR_SPI3RST = 0x8000
	// Reset the selected module
	RCC_APB1RSTR_SPI3RST_Reset = 0x1
	// Position of USART2RST field.
	RCC_APB1RSTR_USART2RST_Pos = 0x11
	// Bit mask of USART2RST field.
	RCC_APB1RSTR_USART2RST_Msk = 0x20000
	// Bit USART2RST.
	RCC_APB1RSTR_USART2RST = 0x20000
	// Reset the selected module
	RCC_APB1RSTR_USART2RST_Reset = 0x1
	// Position of USART3RST field.
	RCC_APB1RSTR_USART3RST_Pos = 0x12
	// Bit mask of USART3RST field.
	RCC_APB1RSTR_USART3RST_Msk = 0x40000
	// Bit USART3RST.
	RCC_APB1RSTR_USART3RST = 0x40000
	// Reset the selected module
	RCC_APB1RSTR_USART3RST_Reset = 0x1
	// Position of UART4RST field.
	RCC_APB1RSTR_UART4RST_Pos = 0x13
	// Bit mask of UART4RST field.
	RCC_APB1RSTR_UART4RST_Msk = 0x80000
	// Bit UART4RST.
	RCC_APB1RSTR_UART4RST = 0x80000
	// Reset the selected module
	RCC_APB1RSTR_UART4RST_Reset = 0x1
	// Position of UART5RST field.
	RCC_APB1RSTR_UART5RST_Pos = 0x14
	// Bit mask of UART5RST field.
	RCC_APB1RSTR_UART5RST_Msk = 0x100000
	// Bit UART5RST.
	RCC_APB1RSTR_UART5RST = 0x100000
	// Reset the selected module
	RCC_APB1RSTR_UART5RST_Reset = 0x1
	// Position of I2C1RST field.
	RCC_APB1RSTR_I2C1RST_Pos = 0x15
	// Bit mask of I2C1RST field.
	RCC_APB1RSTR_I2C1RST_Msk = 0x200000
	// Bit I2C1RST.
	RCC_APB1RSTR_I2C1RST = 0x200000
	// Reset the selected module
	RCC_APB1RSTR_I2C1RST_Reset = 0x1
	// Position of I2C2RST field.
	RCC_APB1RSTR_I2C2RST_Pos = 0x16
	// Bit mask of I2C2RST field.
	RCC_APB1RSTR_I2C2RST_Msk = 0x400000
	// Bit I2C2RST.
	RCC_APB1RSTR_I2C2RST = 0x400000
	// Reset the selected module
	RCC_APB1RSTR_I2C2RST_Reset = 0x1
	// Position of USBRST field.
	RCC_APB1RSTR_USBRST_Pos = 0x17
	// Bit mask of USBRST field.
	RCC_APB1RSTR_USBRST_Msk = 0x800000
	// Bit USBRST.
	RCC_APB1RSTR_USBRST = 0x800000
	// Reset the selected module
	RCC_APB1RSTR_USBRST_Reset = 0x1
	// Position of CANRST field.
	RCC_APB1RSTR_CANRST_Pos = 0x19
	// Bit mask of CANRST field.
	RCC_APB1RSTR_CANRST_Msk = 0x2000000
	// Bit CANRST.
	RCC_APB1RSTR_CANRST = 0x2000000
	// Reset the selected module
	RCC_APB1RSTR_CANRST_Reset = 0x1
	// Position of PWRRST field.
	RCC_APB1RSTR_PWRRST_Pos = 0x1c
	// Bit mask of PWRRST field.
	RCC_APB1RSTR_PWRRST_Msk = 0x10000000
	// Bit PWRRST.
	RCC_APB1RSTR_PWRRST = 0x10000000
	// Reset the selected module
	RCC_APB1RSTR_PWRRST_Reset = 0x1
	// Position of DAC1RST field.
	RCC_APB1RSTR_DAC1RST_Pos = 0x1d
	// Bit mask of DAC1RST field.
	RCC_APB1RSTR_DAC1RST_Msk = 0x20000000
	// Bit DAC1RST.
	RCC_APB1RSTR_DAC1RST = 0x20000000
	// Reset the selected module
	RCC_APB1RSTR_DAC1RST_Reset = 0x1
	// Position of I2C3RST field.
	RCC_APB1RSTR_I2C3RST_Pos = 0x1e
	// Bit mask of I2C3RST field.
	RCC_APB1RSTR_I2C3RST_Msk = 0x40000000
	// Bit I2C3RST.
	RCC_APB1RSTR_I2C3RST = 0x40000000
	// Reset the selected module
	RCC_APB1RSTR_I2C3RST_Reset = 0x1

	// AHBENR: AHB Peripheral Clock enable register (RCC_AHBENR)
	// Position of DMA1EN field.
	RCC_AHBENR_DMA1EN_Pos = 0x0
	// Bit mask of DMA1EN field.
	RCC_AHBENR_DMA1EN_Msk = 0x1
	// Bit DMA1EN.
	RCC_AHBENR_DMA1EN = 0x1
	// The selected clock is disabled
	RCC_AHBENR_DMA1EN_Disabled = 0x0
	// The selected clock is enabled
	RCC_AHBENR_DMA1EN_Enabled = 0x1
	// Position of DMA2EN field.
	RCC_AHBENR_DMA2EN_Pos = 0x1
	// Bit mask of DMA2EN field.
	RCC_AHBENR_DMA2EN_Msk = 0x2
	// Bit DMA2EN.
	RCC_AHBENR_DMA2EN = 0x2
	// The selected clock is disabled
	RCC_AHBENR_DMA2EN_Disabled = 0x0
	// The selected clock is enabled
	RCC_AHBENR_DMA2EN_Enabled = 0x1
	// Position of SRAMEN field.
	RCC_AHBENR_SRAMEN_Pos = 0x2
	// Bit mask of SRAMEN field.
	RCC_AHBENR_SRAMEN_Msk = 0x4
	// Bit SRAMEN.
	RCC_AHBENR_SRAMEN = 0x4
	// The selected clock is disabled
	RCC_AHBENR_SRAMEN_Disabled = 0x0
	// The selected clock is enabled
	RCC_AHBENR_SRAMEN_Enabled = 0x1
	// Position of FLITFEN field.
	RCC_AHBENR_FLITFEN_Pos = 0x4
	// Bit mask of FLITFEN field.
	RCC_AHBENR_FLITFEN_Msk = 0x10
	// Bit FLITFEN.
	RCC_AHBENR_FLITFEN = 0x10
	// The selected clock is disabled
	RCC_AHBENR_FLITFEN_Disabled = 0x0
	// The selected clock is enabled
	RCC_AHBENR_FLITFEN_Enabled = 0x1
	// Position of CRCEN field.
	RCC_AHBENR_CRCEN_Pos = 0x6
	// Bit mask of CRCEN field.
	RCC_AHBENR_CRCEN_Msk = 0x40
	// Bit CRCEN.
	RCC_AHBENR_CRCEN = 0x40
	// The selected clock is disabled
	RCC_AHBENR_CRCEN_Disabled = 0x0
	// The selected clock is enabled
	RCC_AHBENR_CRCEN_Enabled = 0x1
	// Position of IOPAEN field.
	RCC_AHBENR_IOPAEN_Pos = 0x11
	// Bit mask of IOPAEN field.
	RCC_AHBENR_IOPAEN_Msk = 0x20000
	// Bit IOPAEN.
	RCC_AHBENR_IOPAEN = 0x20000
	// The selected clock is disabled
	RCC_AHBENR_IOPAEN_Disabled = 0x0
	// The selected clock is enabled
	RCC_AHBENR_IOPAEN_Enabled = 0x1
	// Position of IOPBEN field.
	RCC_AHBENR_IOPBEN_Pos = 0x12
	// Bit mask of IOPBEN field.
	RCC_AHBENR_IOPBEN_Msk = 0x40000
	// Bit IOPBEN.
	RCC_AHBENR_IOPBEN = 0x40000
	// The selected clock is disabled
	RCC_AHBENR_IOPBEN_Disabled = 0x0
	// The selected clock is enabled
	RCC_AHBENR_IOPBEN_Enabled = 0x1
	// Position of IOPCEN field.
	RCC_AHBENR_IOPCEN_Pos = 0x13
	// Bit mask of IOPCEN field.
	RCC_AHBENR_IOPCEN_Msk = 0x80000
	// Bit IOPCEN.
	RCC_AHBENR_IOPCEN = 0x80000
	// The selected clock is disabled
	RCC_AHBENR_IOPCEN_Disabled = 0x0
	// The selected clock is enabled
	RCC_AHBENR_IOPCEN_Enabled = 0x1
	// Position of IOPDEN field.
	RCC_AHBENR_IOPDEN_Pos = 0x14
	// Bit mask of IOPDEN field.
	RCC_AHBENR_IOPDEN_Msk = 0x100000
	// Bit IOPDEN.
	RCC_AHBENR_IOPDEN = 0x100000
	// The selected clock is disabled
	RCC_AHBENR_IOPDEN_Disabled = 0x0
	// The selected clock is enabled
	RCC_AHBENR_IOPDEN_Enabled = 0x1
	// Position of IOPEEN field.
	RCC_AHBENR_IOPEEN_Pos = 0x15
	// Bit mask of IOPEEN field.
	RCC_AHBENR_IOPEEN_Msk = 0x200000
	// Bit IOPEEN.
	RCC_AHBENR_IOPEEN = 0x200000
	// The selected clock is disabled
	RCC_AHBENR_IOPEEN_Disabled = 0x0
	// The selected clock is enabled
	RCC_AHBENR_IOPEEN_Enabled = 0x1
	// Position of IOPFEN field.
	RCC_AHBENR_IOPFEN_Pos = 0x16
	// Bit mask of IOPFEN field.
	RCC_AHBENR_IOPFEN_Msk = 0x400000
	// Bit IOPFEN.
	RCC_AHBENR_IOPFEN = 0x400000
	// The selected clock is disabled
	RCC_AHBENR_IOPFEN_Disabled = 0x0
	// The selected clock is enabled
	RCC_AHBENR_IOPFEN_Enabled = 0x1
	// Position of TSCEN field.
	RCC_AHBENR_TSCEN_Pos = 0x18
	// Bit mask of TSCEN field.
	RCC_AHBENR_TSCEN_Msk = 0x1000000
	// Bit TSCEN.
	RCC_AHBENR_TSCEN = 0x1000000
	// The selected clock is disabled
	RCC_AHBENR_TSCEN_Disabled = 0x0
	// The selected clock is enabled
	RCC_AHBENR_TSCEN_Enabled = 0x1
	// Position of ADC12EN field.
	RCC_AHBENR_ADC12EN_Pos = 0x1c
	// Bit mask of ADC12EN field.
	RCC_AHBENR_ADC12EN_Msk = 0x10000000
	// Bit ADC12EN.
	RCC_AHBENR_ADC12EN = 0x10000000
	// The selected clock is disabled
	RCC_AHBENR_ADC12EN_Disabled = 0x0
	// The selected clock is enabled
	RCC_AHBENR_ADC12EN_Enabled = 0x1
	// Position of FMCEN field.
	RCC_AHBENR_FMCEN_Pos = 0x5
	// Bit mask of FMCEN field.
	RCC_AHBENR_FMCEN_Msk = 0x20
	// Bit FMCEN.
	RCC_AHBENR_FMCEN = 0x20
	// The selected clock is disabled
	RCC_AHBENR_FMCEN_Disabled = 0x0
	// The selected clock is enabled
	RCC_AHBENR_FMCEN_Enabled = 0x1
	// Position of IOPHEN field.
	RCC_AHBENR_IOPHEN_Pos = 0x10
	// Bit mask of IOPHEN field.
	RCC_AHBENR_IOPHEN_Msk = 0x10000
	// Bit IOPHEN.
	RCC_AHBENR_IOPHEN = 0x10000
	// The selected clock is disabled
	RCC_AHBENR_IOPHEN_Disabled = 0x0
	// The selected clock is enabled
	RCC_AHBENR_IOPHEN_Enabled = 0x1
	// Position of IOPGEN field.
	RCC_AHBENR_IOPGEN_Pos = 0x17
	// Bit mask of IOPGEN field.
	RCC_AHBENR_IOPGEN_Msk = 0x800000
	// Bit IOPGEN.
	RCC_AHBENR_IOPGEN = 0x800000
	// The selected clock is disabled
	RCC_AHBENR_IOPGEN_Disabled = 0x0
	// The selected clock is enabled
	RCC_AHBENR_IOPGEN_Enabled = 0x1

	// APB2ENR: APB2 peripheral clock enable register (RCC_APB2ENR)
	// Position of SYSCFGEN field.
	RCC_APB2ENR_SYSCFGEN_Pos = 0x0
	// Bit mask of SYSCFGEN field.
	RCC_APB2ENR_SYSCFGEN_Msk = 0x1
	// Bit SYSCFGEN.
	RCC_APB2ENR_SYSCFGEN = 0x1
	// The selected clock is disabled
	RCC_APB2ENR_SYSCFGEN_Disabled = 0x0
	// The selected clock is enabled
	RCC_APB2ENR_SYSCFGEN_Enabled = 0x1
	// Position of TIM1EN field.
	RCC_APB2ENR_TIM1EN_Pos = 0xb
	// Bit mask of TIM1EN field.
	RCC_APB2ENR_TIM1EN_Msk = 0x800
	// Bit TIM1EN.
	RCC_APB2ENR_TIM1EN = 0x800
	// The selected clock is disabled
	RCC_APB2ENR_TIM1EN_Disabled = 0x0
	// The selected clock is enabled
	RCC_APB2ENR_TIM1EN_Enabled = 0x1
	// Position of SPI1EN field.
	RCC_APB2ENR_SPI1EN_Pos = 0xc
	// Bit mask of SPI1EN field.
	RCC_APB2ENR_SPI1EN_Msk = 0x1000
	// Bit SPI1EN.
	RCC_APB2ENR_SPI1EN = 0x1000
	// The selected clock is disabled
	RCC_APB2ENR_SPI1EN_Disabled = 0x0
	// The selected clock is enabled
	RCC_APB2ENR_SPI1EN_Enabled = 0x1
	// Position of USART1EN field.
	RCC_APB2ENR_USART1EN_Pos = 0xe
	// Bit mask of USART1EN field.
	RCC_APB2ENR_USART1EN_Msk = 0x4000
	// Bit USART1EN.
	RCC_APB2ENR_USART1EN = 0x4000
	// The selected clock is disabled
	RCC_APB2ENR_USART1EN_Disabled = 0x0
	// The selected clock is enabled
	RCC_APB2ENR_USART1EN_Enabled = 0x1
	// Position of TIM15EN field.
	RCC_APB2ENR_TIM15EN_Pos = 0x10
	// Bit mask of TIM15EN field.
	RCC_APB2ENR_TIM15EN_Msk = 0x10000
	// Bit TIM15EN.
	RCC_APB2ENR_TIM15EN = 0x10000
	// The selected clock is disabled
	RCC_APB2ENR_TIM15EN_Disabled = 0x0
	// The selected clock is enabled
	RCC_APB2ENR_TIM15EN_Enabled = 0x1
	// Position of TIM16EN field.
	RCC_APB2ENR_TIM16EN_Pos = 0x11
	// Bit mask of TIM16EN field.
	RCC_APB2ENR_TIM16EN_Msk = 0x20000
	// Bit TIM16EN.
	RCC_APB2ENR_TIM16EN = 0x20000
	// The selected clock is disabled
	RCC_APB2ENR_TIM16EN_Disabled = 0x0
	// The selected clock is enabled
	RCC_APB2ENR_TIM16EN_Enabled = 0x1
	// Position of TIM17EN field.
	RCC_APB2ENR_TIM17EN_Pos = 0x12
	// Bit mask of TIM17EN field.
	RCC_APB2ENR_TIM17EN_Msk = 0x40000
	// Bit TIM17EN.
	RCC_APB2ENR_TIM17EN = 0x40000
	// The selected clock is disabled
	RCC_APB2ENR_TIM17EN_Disabled = 0x0
	// The selected clock is enabled
	RCC_APB2ENR_TIM17EN_Enabled = 0x1
	// Position of SPI4EN field.
	RCC_APB2ENR_SPI4EN_Pos = 0xf
	// Bit mask of SPI4EN field.
	RCC_APB2ENR_SPI4EN_Msk = 0x8000
	// Bit SPI4EN.
	RCC_APB2ENR_SPI4EN = 0x8000
	// The selected clock is disabled
	RCC_APB2ENR_SPI4EN_Disabled = 0x0
	// The selected clock is enabled
	RCC_APB2ENR_SPI4EN_Enabled = 0x1

	// APB1ENR: APB1 peripheral clock enable register (RCC_APB1ENR)
	// Position of TIM2EN field.
	RCC_APB1ENR_TIM2EN_Pos = 0x0
	// Bit mask of TIM2EN field.
	RCC_APB1ENR_TIM2EN_Msk = 0x1
	// Bit TIM2EN.
	RCC_APB1ENR_TIM2EN = 0x1
	// The selected clock is disabled
	RCC_APB1ENR_TIM2EN_Disabled = 0x0
	// The selected clock is enabled
	RCC_APB1ENR_TIM2EN_Enabled = 0x1
	// Position of TIM3EN field.
	RCC_APB1ENR_TIM3EN_Pos = 0x1
	// Bit mask of TIM3EN field.
	RCC_APB1ENR_TIM3EN_Msk = 0x2
	// Bit TIM3EN.
	RCC_APB1ENR_TIM3EN = 0x2
	// The selected clock is disabled
	RCC_APB1ENR_TIM3EN_Disabled = 0x0
	// The selected clock is enabled
	RCC_APB1ENR_TIM3EN_Enabled = 0x1
	// Position of TIM4EN field.
	RCC_APB1ENR_TIM4EN_Pos = 0x2
	// Bit mask of TIM4EN field.
	RCC_APB1ENR_TIM4EN_Msk = 0x4
	// Bit TIM4EN.
	RCC_APB1ENR_TIM4EN = 0x4
	// The selected clock is disabled
	RCC_APB1ENR_TIM4EN_Disabled = 0x0
	// The selected clock is enabled
	RCC_APB1ENR_TIM4EN_Enabled = 0x1
	// Position of TIM6EN field.
	RCC_APB1ENR_TIM6EN_Pos = 0x4
	// Bit mask of TIM6EN field.
	RCC_APB1ENR_TIM6EN_Msk = 0x10
	// Bit TIM6EN.
	RCC_APB1ENR_TIM6EN = 0x10
	// The selected clock is disabled
	RCC_APB1ENR_TIM6EN_Disabled = 0x0
	// The selected clock is enabled
	RCC_APB1ENR_TIM6EN_Enabled = 0x1
	// Position of WWDGEN field.
	RCC_APB1ENR_WWDGEN_Pos = 0xb
	// Bit mask of WWDGEN field.
	RCC_APB1ENR_WWDGEN_Msk = 0x800
	// Bit WWDGEN.
	RCC_APB1ENR_WWDGEN = 0x800
	// The selected clock is disabled
	RCC_APB1ENR_WWDGEN_Disabled = 0x0
	// The selected clock is enabled
	RCC_APB1ENR_WWDGEN_Enabled = 0x1
	// Position of SPI2EN field.
	RCC_APB1ENR_SPI2EN_Pos = 0xe
	// Bit mask of SPI2EN field.
	RCC_APB1ENR_SPI2EN_Msk = 0x4000
	// Bit SPI2EN.
	RCC_APB1ENR_SPI2EN = 0x4000
	// The selected clock is disabled
	RCC_APB1ENR_SPI2EN_Disabled = 0x0
	// The selected clock is enabled
	RCC_APB1ENR_SPI2EN_Enabled = 0x1
	// Position of SPI3EN field.
	RCC_APB1ENR_SPI3EN_Pos = 0xf
	// Bit mask of SPI3EN field.
	RCC_APB1ENR_SPI3EN_Msk = 0x8000
	// Bit SPI3EN.
	RCC_APB1ENR_SPI3EN = 0x8000
	// The selected clock is disabled
	RCC_APB1ENR_SPI3EN_Disabled = 0x0
	// The selected clock is enabled
	RCC_APB1ENR_SPI3EN_Enabled = 0x1
	// Position of USART2EN field.
	RCC_APB1ENR_USART2EN_Pos = 0x11
	// Bit mask of USART2EN field.
	RCC_APB1ENR_USART2EN_Msk = 0x20000
	// Bit USART2EN.
	RCC_APB1ENR_USART2EN = 0x20000
	// The selected clock is disabled
	RCC_APB1ENR_USART2EN_Disabled = 0x0
	// The selected clock is enabled
	RCC_APB1ENR_USART2EN_Enabled = 0x1
	// Position of I2C1EN field.
	RCC_APB1ENR_I2C1EN_Pos = 0x15
	// Bit mask of I2C1EN field.
	RCC_APB1ENR_I2C1EN_Msk = 0x200000
	// Bit I2C1EN.
	RCC_APB1ENR_I2C1EN = 0x200000
	// The selected clock is disabled
	RCC_APB1ENR_I2C1EN_Disabled = 0x0
	// The selected clock is enabled
	RCC_APB1ENR_I2C1EN_Enabled = 0x1
	// Position of I2C2EN field.
	RCC_APB1ENR_I2C2EN_Pos = 0x16
	// Bit mask of I2C2EN field.
	RCC_APB1ENR_I2C2EN_Msk = 0x400000
	// Bit I2C2EN.
	RCC_APB1ENR_I2C2EN = 0x400000
	// The selected clock is disabled
	RCC_APB1ENR_I2C2EN_Disabled = 0x0
	// The selected clock is enabled
	RCC_APB1ENR_I2C2EN_Enabled = 0x1
	// Position of USBEN field.
	RCC_APB1ENR_USBEN_Pos = 0x17
	// Bit mask of USBEN field.
	RCC_APB1ENR_USBEN_Msk = 0x800000
	// Bit USBEN.
	RCC_APB1ENR_USBEN = 0x800000
	// The selected clock is disabled
	RCC_APB1ENR_USBEN_Disabled = 0x0
	// The selected clock is enabled
	RCC_APB1ENR_USBEN_Enabled = 0x1
	// Position of CANEN field.
	RCC_APB1ENR_CANEN_Pos = 0x19
	// Bit mask of CANEN field.
	RCC_APB1ENR_CANEN_Msk = 0x2000000
	// Bit CANEN.
	RCC_APB1ENR_CANEN = 0x2000000
	// The selected clock is disabled
	RCC_APB1ENR_CANEN_Disabled = 0x0
	// The selected clock is enabled
	RCC_APB1ENR_CANEN_Enabled = 0x1
	// Position of PWREN field.
	RCC_APB1ENR_PWREN_Pos = 0x1c
	// Bit mask of PWREN field.
	RCC_APB1ENR_PWREN_Msk = 0x10000000
	// Bit PWREN.
	RCC_APB1ENR_PWREN = 0x10000000
	// The selected clock is disabled
	RCC_APB1ENR_PWREN_Disabled = 0x0
	// The selected clock is enabled
	RCC_APB1ENR_PWREN_Enabled = 0x1
	// Position of DAC1EN field.
	RCC_APB1ENR_DAC1EN_Pos = 0x1d
	// Bit mask of DAC1EN field.
	RCC_APB1ENR_DAC1EN_Msk = 0x20000000
	// Bit DAC1EN.
	RCC_APB1ENR_DAC1EN = 0x20000000
	// The selected clock is disabled
	RCC_APB1ENR_DAC1EN_Disabled = 0x0
	// The selected clock is enabled
	RCC_APB1ENR_DAC1EN_Enabled = 0x1
	// Position of USART3EN field.
	RCC_APB1ENR_USART3EN_Pos = 0x12
	// Bit mask of USART3EN field.
	RCC_APB1ENR_USART3EN_Msk = 0x40000
	// Bit USART3EN.
	RCC_APB1ENR_USART3EN = 0x40000
	// The selected clock is disabled
	RCC_APB1ENR_USART3EN_Disabled = 0x0
	// The selected clock is enabled
	RCC_APB1ENR_USART3EN_Enabled = 0x1
	// Position of UART4EN field.
	RCC_APB1ENR_UART4EN_Pos = 0x13
	// Bit mask of UART4EN field.
	RCC_APB1ENR_UART4EN_Msk = 0x80000
	// Bit UART4EN.
	RCC_APB1ENR_UART4EN = 0x80000
	// The selected clock is disabled
	RCC_APB1ENR_UART4EN_Disabled = 0x0
	// The selected clock is enabled
	RCC_APB1ENR_UART4EN_Enabled = 0x1
	// Position of UART5EN field.
	RCC_APB1ENR_UART5EN_Pos = 0x14
	// Bit mask of UART5EN field.
	RCC_APB1ENR_UART5EN_Msk = 0x100000
	// Bit UART5EN.
	RCC_APB1ENR_UART5EN = 0x100000
	// The selected clock is disabled
	RCC_APB1ENR_UART5EN_Disabled = 0x0
	// The selected clock is enabled
	RCC_APB1ENR_UART5EN_Enabled = 0x1
	// Position of I2C3EN field.
	RCC_APB1ENR_I2C3EN_Pos = 0x1e
	// Bit mask of I2C3EN field.
	RCC_APB1ENR_I2C3EN_Msk = 0x40000000
	// Bit I2C3EN.
	RCC_APB1ENR_I2C3EN = 0x40000000
	// The selected clock is disabled
	RCC_APB1ENR_I2C3EN_Disabled = 0x0
	// The selected clock is enabled
	RCC_APB1ENR_I2C3EN_Enabled = 0x1

	// BDCR: Backup domain control register (RCC_BDCR)
	// Position of LSEON field.
	RCC_BDCR_LSEON_Pos = 0x0
	// Bit mask of LSEON field.
	RCC_BDCR_LSEON_Msk = 0x1
	// Bit LSEON.
	RCC_BDCR_LSEON = 0x1
	// LSE oscillator Off
	RCC_BDCR_LSEON_Off = 0x0
	// LSE oscillator On
	RCC_BDCR_LSEON_On = 0x1
	// Position of LSERDY field.
	RCC_BDCR_LSERDY_Pos = 0x1
	// Bit mask of LSERDY field.
	RCC_BDCR_LSERDY_Msk = 0x2
	// Bit LSERDY.
	RCC_BDCR_LSERDY = 0x2
	// LSE oscillator not ready
	RCC_BDCR_LSERDY_NotReady = 0x0
	// LSE oscillator ready
	RCC_BDCR_LSERDY_Ready = 0x1
	// Position of LSEBYP field.
	RCC_BDCR_LSEBYP_Pos = 0x2
	// Bit mask of LSEBYP field.
	RCC_BDCR_LSEBYP_Msk = 0x4
	// Bit LSEBYP.
	RCC_BDCR_LSEBYP = 0x4
	// LSE crystal oscillator not bypassed
	RCC_BDCR_LSEBYP_NotBypassed = 0x0
	// LSE crystal oscillator bypassed with external clock
	RCC_BDCR_LSEBYP_Bypassed = 0x1
	// Position of LSEDRV field.
	RCC_BDCR_LSEDRV_Pos = 0x3
	// Bit mask of LSEDRV field.
	RCC_BDCR_LSEDRV_Msk = 0x18
	// Low drive capacity
	RCC_BDCR_LSEDRV_Low = 0x0
	// Medium-high drive capacity
	RCC_BDCR_LSEDRV_MediumHigh = 0x1
	// Medium-low drive capacity
	RCC_BDCR_LSEDRV_MediumLow = 0x2
	// High drive capacity
	RCC_BDCR_LSEDRV_High = 0x3
	// Position of RTCSEL field.
	RCC_BDCR_RTCSEL_Pos = 0x8
	// Bit mask of RTCSEL field.
	RCC_BDCR_RTCSEL_Msk = 0x300
	// No clock
	RCC_BDCR_RTCSEL_NoClock = 0x0
	// LSE oscillator clock used as RTC clock
	RCC_BDCR_RTCSEL_LSE = 0x1
	// LSI oscillator clock used as RTC clock
	RCC_BDCR_RTCSEL_LSI = 0x2
	// HSE oscillator clock divided by a prescaler used as RTC clock
	RCC_BDCR_RTCSEL_HSE = 0x3
	// Position of RTCEN field.
	RCC_BDCR_RTCEN_Pos = 0xf
	// Bit mask of RTCEN field.
	RCC_BDCR_RTCEN_Msk = 0x8000
	// Bit RTCEN.
	RCC_BDCR_RTCEN = 0x8000
	// RTC clock disabled
	RCC_BDCR_RTCEN_Disabled = 0x0
	// RTC clock enabled
	RCC_BDCR_RTCEN_Enabled = 0x1
	// Position of BDRST field.
	RCC_BDCR_BDRST_Pos = 0x10
	// Bit mask of BDRST field.
	RCC_BDCR_BDRST_Msk = 0x10000
	// Bit BDRST.
	RCC_BDCR_BDRST = 0x10000
	// Reset not activated
	RCC_BDCR_BDRST_Disabled = 0x0
	// Reset the entire RTC domain
	RCC_BDCR_BDRST_Enabled = 0x1

	// CSR: Control/status register (RCC_CSR)
	// Position of LSION field.
	RCC_CSR_LSION_Pos = 0x0
	// Bit mask of LSION field.
	RCC_CSR_LSION_Msk = 0x1
	// Bit LSION.
	RCC_CSR_LSION = 0x1
	// LSI oscillator Off
	RCC_CSR_LSION_Off = 0x0
	// LSI oscillator On
	RCC_CSR_LSION_On = 0x1
	// Position of LSIRDY field.
	RCC_CSR_LSIRDY_Pos = 0x1
	// Bit mask of LSIRDY field.
	RCC_CSR_LSIRDY_Msk = 0x2
	// Bit LSIRDY.
	RCC_CSR_LSIRDY = 0x2
	// LSI oscillator not ready
	RCC_CSR_LSIRDY_NotReady = 0x0
	// LSI oscillator ready
	RCC_CSR_LSIRDY_Ready = 0x1
	// Position of RMVF field.
	RCC_CSR_RMVF_Pos = 0x18
	// Bit mask of RMVF field.
	RCC_CSR_RMVF_Msk = 0x1000000
	// Bit RMVF.
	RCC_CSR_RMVF = 0x1000000
	// Clears the reset flag
	RCC_CSR_RMVF_Clear = 0x1
	// Position of OBLRSTF field.
	RCC_CSR_OBLRSTF_Pos = 0x19
	// Bit mask of OBLRSTF field.
	RCC_CSR_OBLRSTF_Msk = 0x2000000
	// Bit OBLRSTF.
	RCC_CSR_OBLRSTF = 0x2000000
	// No reset has occured
	RCC_CSR_OBLRSTF_NoReset = 0x0
	// A reset has occured
	RCC_CSR_OBLRSTF_Reset = 0x1
	// Position of PINRSTF field.
	RCC_CSR_PINRSTF_Pos = 0x1a
	// Bit mask of PINRSTF field.
	RCC_CSR_PINRSTF_Msk = 0x4000000
	// Bit PINRSTF.
	RCC_CSR_PINRSTF = 0x4000000
	// No reset has occured
	RCC_CSR_PINRSTF_NoReset = 0x0
	// A reset has occured
	RCC_CSR_PINRSTF_Reset = 0x1
	// Position of PORRSTF field.
	RCC_CSR_PORRSTF_Pos = 0x1b
	// Bit mask of PORRSTF field.
	RCC_CSR_PORRSTF_Msk = 0x8000000
	// Bit PORRSTF.
	RCC_CSR_PORRSTF = 0x8000000
	// No reset has occured
	RCC_CSR_PORRSTF_NoReset = 0x0
	// A reset has occured
	RCC_CSR_PORRSTF_Reset = 0x1
	// Position of SFTRSTF field.
	RCC_CSR_SFTRSTF_Pos = 0x1c
	// Bit mask of SFTRSTF field.
	RCC_CSR_SFTRSTF_Msk = 0x10000000
	// Bit SFTRSTF.
	RCC_CSR_SFTRSTF = 0x10000000
	// No reset has occured
	RCC_CSR_SFTRSTF_NoReset = 0x0
	// A reset has occured
	RCC_CSR_SFTRSTF_Reset = 0x1
	// Position of IWDGRSTF field.
	RCC_CSR_IWDGRSTF_Pos = 0x1d
	// Bit mask of IWDGRSTF field.
	RCC_CSR_IWDGRSTF_Msk = 0x20000000
	// Bit IWDGRSTF.
	RCC_CSR_IWDGRSTF = 0x20000000
	// No reset has occured
	RCC_CSR_IWDGRSTF_NoReset = 0x0
	// A reset has occured
	RCC_CSR_IWDGRSTF_Reset = 0x1
	// Position of WWDGRSTF field.
	RCC_CSR_WWDGRSTF_Pos = 0x1e
	// Bit mask of WWDGRSTF field.
	RCC_CSR_WWDGRSTF_Msk = 0x40000000
	// Bit WWDGRSTF.
	RCC_CSR_WWDGRSTF = 0x40000000
	// No reset has occured
	RCC_CSR_WWDGRSTF_NoReset = 0x0
	// A reset has occured
	RCC_CSR_WWDGRSTF_Reset = 0x1
	// Position of LPWRRSTF field.
	RCC_CSR_LPWRRSTF_Pos = 0x1f
	// Bit mask of LPWRRSTF field.
	RCC_CSR_LPWRRSTF_Msk = 0x80000000
	// Bit LPWRRSTF.
	RCC_CSR_LPWRRSTF = 0x80000000
	// No reset has occured
	RCC_CSR_LPWRRSTF_NoReset = 0x0
	// A reset has occured
	RCC_CSR_LPWRRSTF_Reset = 0x1
	// Position of V18PWRRSTF field.
	RCC_CSR_V18PWRRSTF_Pos = 0x17
	// Bit mask of V18PWRRSTF field.
	RCC_CSR_V18PWRRSTF_Msk = 0x800000
	// Bit V18PWRRSTF.
	RCC_CSR_V18PWRRSTF = 0x800000
	// No reset has occured
	RCC_CSR_V18PWRRSTF_NoReset = 0x0
	// A reset has occured
	RCC_CSR_V18PWRRSTF_Reset = 0x1

	// AHBRSTR: AHB peripheral reset register
	// Position of IOPARST field.
	RCC_AHBRSTR_IOPARST_Pos = 0x11
	// Bit mask of IOPARST field.
	RCC_AHBRSTR_IOPARST_Msk = 0x20000
	// Bit IOPARST.
	RCC_AHBRSTR_IOPARST = 0x20000
	// Reset the selected module
	RCC_AHBRSTR_IOPARST_Reset = 0x1
	// Position of IOPBRST field.
	RCC_AHBRSTR_IOPBRST_Pos = 0x12
	// Bit mask of IOPBRST field.
	RCC_AHBRSTR_IOPBRST_Msk = 0x40000
	// Bit IOPBRST.
	RCC_AHBRSTR_IOPBRST = 0x40000
	// Reset the selected module
	RCC_AHBRSTR_IOPBRST_Reset = 0x1
	// Position of IOPCRST field.
	RCC_AHBRSTR_IOPCRST_Pos = 0x13
	// Bit mask of IOPCRST field.
	RCC_AHBRSTR_IOPCRST_Msk = 0x80000
	// Bit IOPCRST.
	RCC_AHBRSTR_IOPCRST = 0x80000
	// Reset the selected module
	RCC_AHBRSTR_IOPCRST_Reset = 0x1
	// Position of IOPDRST field.
	RCC_AHBRSTR_IOPDRST_Pos = 0x14
	// Bit mask of IOPDRST field.
	RCC_AHBRSTR_IOPDRST_Msk = 0x100000
	// Bit IOPDRST.
	RCC_AHBRSTR_IOPDRST = 0x100000
	// Reset the selected module
	RCC_AHBRSTR_IOPDRST_Reset = 0x1
	// Position of IOPERST field.
	RCC_AHBRSTR_IOPERST_Pos = 0x15
	// Bit mask of IOPERST field.
	RCC_AHBRSTR_IOPERST_Msk = 0x200000
	// Bit IOPERST.
	RCC_AHBRSTR_IOPERST = 0x200000
	// Reset the selected module
	RCC_AHBRSTR_IOPERST_Reset = 0x1
	// Position of IOPFRST field.
	RCC_AHBRSTR_IOPFRST_Pos = 0x16
	// Bit mask of IOPFRST field.
	RCC_AHBRSTR_IOPFRST_Msk = 0x400000
	// Bit IOPFRST.
	RCC_AHBRSTR_IOPFRST = 0x400000
	// Reset the selected module
	RCC_AHBRSTR_IOPFRST_Reset = 0x1
	// Position of TSCRST field.
	RCC_AHBRSTR_TSCRST_Pos = 0x18
	// Bit mask of TSCRST field.
	RCC_AHBRSTR_TSCRST_Msk = 0x1000000
	// Bit TSCRST.
	RCC_AHBRSTR_TSCRST = 0x1000000
	// Reset the selected module
	RCC_AHBRSTR_TSCRST_Reset = 0x1
	// Position of ADC12RST field.
	RCC_AHBRSTR_ADC12RST_Pos = 0x1c
	// Bit mask of ADC12RST field.
	RCC_AHBRSTR_ADC12RST_Msk = 0x10000000
	// Bit ADC12RST.
	RCC_AHBRSTR_ADC12RST = 0x10000000
	// Reset the selected module
	RCC_AHBRSTR_ADC12RST_Reset = 0x1
	// Position of FMCRST field.
	RCC_AHBRSTR_FMCRST_Pos = 0x5
	// Bit mask of FMCRST field.
	RCC_AHBRSTR_FMCRST_Msk = 0x20
	// Bit FMCRST.
	RCC_AHBRSTR_FMCRST = 0x20
	// Reset the selected module
	RCC_AHBRSTR_FMCRST_Reset = 0x1
	// Position of IOPHRST field.
	RCC_AHBRSTR_IOPHRST_Pos = 0x10
	// Bit mask of IOPHRST field.
	RCC_AHBRSTR_IOPHRST_Msk = 0x10000
	// Bit IOPHRST.
	RCC_AHBRSTR_IOPHRST = 0x10000
	// Reset the selected module
	RCC_AHBRSTR_IOPHRST_Reset = 0x1
	// Position of IOPGRST field.
	RCC_AHBRSTR_IOPGRST_Pos = 0x17
	// Bit mask of IOPGRST field.
	RCC_AHBRSTR_IOPGRST_Msk = 0x800000
	// Bit IOPGRST.
	RCC_AHBRSTR_IOPGRST = 0x800000
	// Reset the selected module
	RCC_AHBRSTR_IOPGRST_Reset = 0x1

	// CFGR2: Clock configuration register 2
	// Position of PREDIV field.
	RCC_CFGR2_PREDIV_Pos = 0x0
	// Bit mask of PREDIV field.
	RCC_CFGR2_PREDIV_Msk = 0xf
	// PREDIV input clock not divided
	RCC_CFGR2_PREDIV_Div1 = 0x0
	// PREDIV input clock divided by 2
	RCC_CFGR2_PREDIV_Div2 = 0x1
	// PREDIV input clock divided by 3
	RCC_CFGR2_PREDIV_Div3 = 0x2
	// PREDIV input clock divided by 4
	RCC_CFGR2_PREDIV_Div4 = 0x3
	// PREDIV input clock divided by 5
	RCC_CFGR2_PREDIV_Div5 = 0x4
	// PREDIV input clock divided by 6
	RCC_CFGR2_PREDIV_Div6 = 0x5
	// PREDIV input clock divided by 7
	RCC_CFGR2_PREDIV_Div7 = 0x6
	// PREDIV input clock divided by 8
	RCC_CFGR2_PREDIV_Div8 = 0x7
	// PREDIV input clock divided by 9
	RCC_CFGR2_PREDIV_Div9 = 0x8
	// PREDIV input clock divided by 10
	RCC_CFGR2_PREDIV_Div10 = 0x9
	// PREDIV input clock divided by 11
	RCC_CFGR2_PREDIV_Div11 = 0xa
	// PREDIV input clock divided by 12
	RCC_CFGR2_PREDIV_Div12 = 0xb
	// PREDIV input clock divided by 13
	RCC_CFGR2_PREDIV_Div13 = 0xc
	// PREDIV input clock divided by 14
	RCC_CFGR2_PREDIV_Div14 = 0xd
	// PREDIV input clock divided by 15
	RCC_CFGR2_PREDIV_Div15 = 0xe
	// PREDIV input clock divided by 16
	RCC_CFGR2_PREDIV_Div16 = 0xf
	// Position of ADC12PRES field.
	RCC_CFGR2_ADC12PRES_Pos = 0x4
	// Bit mask of ADC12PRES field.
	RCC_CFGR2_ADC12PRES_Msk = 0x1f0
	// No clock
	RCC_CFGR2_ADC12PRES_NoClock = 0x0
	// PLL clock not divided
	RCC_CFGR2_ADC12PRES_Div1 = 0x10
	// PLL clock divided by 2
	RCC_CFGR2_ADC12PRES_Div2 = 0x11
	// PLL clock divided by 4
	RCC_CFGR2_ADC12PRES_Div4 = 0x12
	// PLL clock divided by 6
	RCC_CFGR2_ADC12PRES_Div6 = 0x13
	// PLL clock divided by 8
	RCC_CFGR2_ADC12PRES_Div8 = 0x14
	// PLL clock divided by 10
	RCC_CFGR2_ADC12PRES_Div10 = 0x15
	// PLL clock divided by 12
	RCC_CFGR2_ADC12PRES_Div12 = 0x16
	// PLL clock divided by 16
	RCC_CFGR2_ADC12PRES_Div16 = 0x17
	// PLL clock divided by 32
	RCC_CFGR2_ADC12PRES_Div32 = 0x18
	// PLL clock divided by 64
	RCC_CFGR2_ADC12PRES_Div64 = 0x19
	// PLL clock divided by 128
	RCC_CFGR2_ADC12PRES_Div128 = 0x1a
	// PLL clock divided by 256
	RCC_CFGR2_ADC12PRES_Div256 = 0x1b

	// CFGR3: Clock configuration register 3
	// Position of USART1SW field.
	RCC_CFGR3_USART1SW_Pos = 0x0
	// Bit mask of USART1SW field.
	RCC_CFGR3_USART1SW_Msk = 0x3
	// PCLK selected as USART clock source
	RCC_CFGR3_USART1SW_PCLK = 0x0
	// SYSCLK selected as USART clock source
	RCC_CFGR3_USART1SW_SYSCLK = 0x1
	// LSE selected as USART clock source
	RCC_CFGR3_USART1SW_LSE = 0x2
	// HSI selected as USART clock source
	RCC_CFGR3_USART1SW_HSI = 0x3
	// Position of I2C1SW field.
	RCC_CFGR3_I2C1SW_Pos = 0x4
	// Bit mask of I2C1SW field.
	RCC_CFGR3_I2C1SW_Msk = 0x10
	// Bit I2C1SW.
	RCC_CFGR3_I2C1SW = 0x10
	// HSI clock selected as I2C clock source
	RCC_CFGR3_I2C1SW_HSI = 0x0
	// SYSCLK clock selected as I2C clock source
	RCC_CFGR3_I2C1SW_SYSCLK = 0x1
	// Position of I2C2SW field.
	RCC_CFGR3_I2C2SW_Pos = 0x5
	// Bit mask of I2C2SW field.
	RCC_CFGR3_I2C2SW_Msk = 0x20
	// Bit I2C2SW.
	RCC_CFGR3_I2C2SW = 0x20
	// HSI clock selected as I2C clock source
	RCC_CFGR3_I2C2SW_HSI = 0x0
	// SYSCLK clock selected as I2C clock source
	RCC_CFGR3_I2C2SW_SYSCLK = 0x1
	// Position of USART2SW field.
	RCC_CFGR3_USART2SW_Pos = 0x10
	// Bit mask of USART2SW field.
	RCC_CFGR3_USART2SW_Msk = 0x30000
	// PCLK selected as USART clock source
	RCC_CFGR3_USART2SW_PCLK = 0x0
	// SYSCLK selected as USART clock source
	RCC_CFGR3_USART2SW_SYSCLK = 0x1
	// LSE selected as USART clock source
	RCC_CFGR3_USART2SW_LSE = 0x2
	// HSI selected as USART clock source
	RCC_CFGR3_USART2SW_HSI = 0x3
	// Position of USART3SW field.
	RCC_CFGR3_USART3SW_Pos = 0x12
	// Bit mask of USART3SW field.
	RCC_CFGR3_USART3SW_Msk = 0xc0000
	// PCLK selected as USART clock source
	RCC_CFGR3_USART3SW_PCLK = 0x0
	// SYSCLK selected as USART clock source
	RCC_CFGR3_USART3SW_SYSCLK = 0x1
	// LSE selected as USART clock source
	RCC_CFGR3_USART3SW_LSE = 0x2
	// HSI selected as USART clock source
	RCC_CFGR3_USART3SW_HSI = 0x3
	// Position of TIM1SW field.
	RCC_CFGR3_TIM1SW_Pos = 0x8
	// Bit mask of TIM1SW field.
	RCC_CFGR3_TIM1SW_Msk = 0x100
	// Bit TIM1SW.
	RCC_CFGR3_TIM1SW = 0x100
	// PCLK2 clock (doubled frequency when prescaled)
	RCC_CFGR3_TIM1SW_PCLK2 = 0x0
	// PLL vco output (running up to 144 MHz)
	RCC_CFGR3_TIM1SW_PLL = 0x1
	// Position of UART4SW field.
	RCC_CFGR3_UART4SW_Pos = 0x14
	// Bit mask of UART4SW field.
	RCC_CFGR3_UART4SW_Msk = 0x300000
	// PCLK selected as USART clock source
	RCC_CFGR3_UART4SW_PCLK = 0x0
	// SYSCLK selected as USART clock source
	RCC_CFGR3_UART4SW_SYSCLK = 0x1
	// LSE selected as USART clock source
	RCC_CFGR3_UART4SW_LSE = 0x2
	// HSI selected as USART clock source
	RCC_CFGR3_UART4SW_HSI = 0x3
	// Position of UART5SW field.
	RCC_CFGR3_UART5SW_Pos = 0x16
	// Bit mask of UART5SW field.
	RCC_CFGR3_UART5SW_Msk = 0xc00000
	// PCLK selected as USART clock source
	RCC_CFGR3_UART5SW_PCLK = 0x0
	// SYSCLK selected as USART clock source
	RCC_CFGR3_UART5SW_SYSCLK = 0x1
	// LSE selected as USART clock source
	RCC_CFGR3_UART5SW_LSE = 0x2
	// HSI selected as USART clock source
	RCC_CFGR3_UART5SW_HSI = 0x3
	// Position of I2C3SW field.
	RCC_CFGR3_I2C3SW_Pos = 0x6
	// Bit mask of I2C3SW field.
	RCC_CFGR3_I2C3SW_Msk = 0x40
	// Bit I2C3SW.
	RCC_CFGR3_I2C3SW = 0x40
	// HSI clock selected as I2C clock source
	RCC_CFGR3_I2C3SW_HSI = 0x0
	// SYSCLK clock selected as I2C clock source
	RCC_CFGR3_I2C3SW_SYSCLK = 0x1
	// Position of TIM15SW field.
	RCC_CFGR3_TIM15SW_Pos = 0xa
	// Bit mask of TIM15SW field.
	RCC_CFGR3_TIM15SW_Msk = 0x400
	// Bit TIM15SW.
	RCC_CFGR3_TIM15SW = 0x400
	// PCLK2 clock (doubled frequency when prescaled)
	RCC_CFGR3_TIM15SW_PCLK2 = 0x0
	// PLL vco output (running up to 144 MHz)
	RCC_CFGR3_TIM15SW_PLL = 0x1
	// Position of TIM16SW field.
	RCC_CFGR3_TIM16SW_Pos = 0xb
	// Bit mask of TIM16SW field.
	RCC_CFGR3_TIM16SW_Msk = 0x800
	// Bit TIM16SW.
	RCC_CFGR3_TIM16SW = 0x800
	// PCLK2 clock (doubled frequency when prescaled)
	RCC_CFGR3_TIM16SW_PCLK2 = 0x0
	// PLL vco output (running up to 144 MHz)
	RCC_CFGR3_TIM16SW_PLL = 0x1
	// Position of TIM17SW field.
	RCC_CFGR3_TIM17SW_Pos = 0xd
	// Bit mask of TIM17SW field.
	RCC_CFGR3_TIM17SW_Msk = 0x2000
	// Bit TIM17SW.
	RCC_CFGR3_TIM17SW = 0x2000
	// PCLK2 clock (doubled frequency when prescaled)
	RCC_CFGR3_TIM17SW_PCLK2 = 0x0
	// PLL vco output (running up to 144 MHz)
	RCC_CFGR3_TIM17SW_PLL = 0x1
	// Position of TIM2SW field.
	RCC_CFGR3_TIM2SW_Pos = 0x18
	// Bit mask of TIM2SW field.
	RCC_CFGR3_TIM2SW_Msk = 0x1000000
	// Bit TIM2SW.
	RCC_CFGR3_TIM2SW = 0x1000000
	// PCLK2 clock (doubled frequency when prescaled)
	RCC_CFGR3_TIM2SW_PCLK2 = 0x0
	// PLL vco output (running up to 144 MHz)
	RCC_CFGR3_TIM2SW_PLL = 0x1
	// Position of TIM34SW field.
	RCC_CFGR3_TIM34SW_Pos = 0x19
	// Bit mask of TIM34SW field.
	RCC_CFGR3_TIM34SW_Msk = 0x2000000
	// Bit TIM34SW.
	RCC_CFGR3_TIM34SW = 0x2000000
	// PCLK2 clock (doubled frequency when prescaled)
	RCC_CFGR3_TIM34SW_PCLK2 = 0x0
	// PLL vco output (running up to 144 MHz)
	RCC_CFGR3_TIM34SW_PLL = 0x1
)

// Bitfields for DMA1: DMA controller 1
const (
	// ISR: DMA interrupt status register (DMA_ISR)
	// Position of GIF1 field.
	DMA_ISR_GIF1_Pos = 0x0
	// Bit mask of GIF1 field.
	DMA_ISR_GIF1_Msk = 0x1
	// Bit GIF1.
	DMA_ISR_GIF1 = 0x1
	// No transfer error, half event, complete event
	DMA_ISR_GIF1_NoEvent = 0x0
	// A transfer error, half event or complete event has occured
	DMA_ISR_GIF1_Event = 0x1
	// Position of TCIF1 field.
	DMA_ISR_TCIF1_Pos = 0x1
	// Bit mask of TCIF1 field.
	DMA_ISR_TCIF1_Msk = 0x2
	// Bit TCIF1.
	DMA_ISR_TCIF1 = 0x2
	// No transfer complete event
	DMA_ISR_TCIF1_NotComplete = 0x0
	// A transfer complete event has occured
	DMA_ISR_TCIF1_Complete = 0x1
	// Position of HTIF1 field.
	DMA_ISR_HTIF1_Pos = 0x2
	// Bit mask of HTIF1 field.
	DMA_ISR_HTIF1_Msk = 0x4
	// Bit HTIF1.
	DMA_ISR_HTIF1 = 0x4
	// No half transfer event
	DMA_ISR_HTIF1_NotHalf = 0x0
	// A half transfer event has occured
	DMA_ISR_HTIF1_Half = 0x1
	// Position of TEIF1 field.
	DMA_ISR_TEIF1_Pos = 0x3
	// Bit mask of TEIF1 field.
	DMA_ISR_TEIF1_Msk = 0x8
	// Bit TEIF1.
	DMA_ISR_TEIF1 = 0x8
	// No transfer error
	DMA_ISR_TEIF1_NoError = 0x0
	// A transfer error has occured
	DMA_ISR_TEIF1_Error = 0x1
	// Position of GIF2 field.
	DMA_ISR_GIF2_Pos = 0x4
	// Bit mask of GIF2 field.
	DMA_ISR_GIF2_Msk = 0x10
	// Bit GIF2.
	DMA_ISR_GIF2 = 0x10
	// No transfer error, half event, complete event
	DMA_ISR_GIF2_NoEvent = 0x0
	// A transfer error, half event or complete event has occured
	DMA_ISR_GIF2_Event = 0x1
	// Position of TCIF2 field.
	DMA_ISR_TCIF2_Pos = 0x5
	// Bit mask of TCIF2 field.
	DMA_ISR_TCIF2_Msk = 0x20
	// Bit TCIF2.
	DMA_ISR_TCIF2 = 0x20
	// No transfer complete event
	DMA_ISR_TCIF2_NotComplete = 0x0
	// A transfer complete event has occured
	DMA_ISR_TCIF2_Complete = 0x1
	// Position of HTIF2 field.
	DMA_ISR_HTIF2_Pos = 0x6
	// Bit mask of HTIF2 field.
	DMA_ISR_HTIF2_Msk = 0x40
	// Bit HTIF2.
	DMA_ISR_HTIF2 = 0x40
	// No half transfer event
	DMA_ISR_HTIF2_NotHalf = 0x0
	// A half transfer event has occured
	DMA_ISR_HTIF2_Half = 0x1
	// Position of TEIF2 field.
	DMA_ISR_TEIF2_Pos = 0x7
	// Bit mask of TEIF2 field.
	DMA_ISR_TEIF2_Msk = 0x80
	// Bit TEIF2.
	DMA_ISR_TEIF2 = 0x80
	// No transfer error
	DMA_ISR_TEIF2_NoError = 0x0
	// A transfer error has occured
	DMA_ISR_TEIF2_Error = 0x1
	// Position of GIF3 field.
	DMA_ISR_GIF3_Pos = 0x8
	// Bit mask of GIF3 field.
	DMA_ISR_GIF3_Msk = 0x100
	// Bit GIF3.
	DMA_ISR_GIF3 = 0x100
	// No transfer error, half event, complete event
	DMA_ISR_GIF3_NoEvent = 0x0
	// A transfer error, half event or complete event has occured
	DMA_ISR_GIF3_Event = 0x1
	// Position of TCIF3 field.
	DMA_ISR_TCIF3_Pos = 0x9
	// Bit mask of TCIF3 field.
	DMA_ISR_TCIF3_Msk = 0x200
	// Bit TCIF3.
	DMA_ISR_TCIF3 = 0x200
	// No transfer complete event
	DMA_ISR_TCIF3_NotComplete = 0x0
	// A transfer complete event has occured
	DMA_ISR_TCIF3_Complete = 0x1
	// Position of HTIF3 field.
	DMA_ISR_HTIF3_Pos = 0xa
	// Bit mask of HTIF3 field.
	DMA_ISR_HTIF3_Msk = 0x400
	// Bit HTIF3.
	DMA_ISR_HTIF3 = 0x400
	// No half transfer event
	DMA_ISR_HTIF3_NotHalf = 0x0
	// A half transfer event has occured
	DMA_ISR_HTIF3_Half = 0x1
	// Position of TEIF3 field.
	DMA_ISR_TEIF3_Pos = 0xb
	// Bit mask of TEIF3 field.
	DMA_ISR_TEIF3_Msk = 0x800
	// Bit TEIF3.
	DMA_ISR_TEIF3 = 0x800
	// No transfer error
	DMA_ISR_TEIF3_NoError = 0x0
	// A transfer error has occured
	DMA_ISR_TEIF3_Error = 0x1
	// Position of GIF4 field.
	DMA_ISR_GIF4_Pos = 0xc
	// Bit mask of GIF4 field.
	DMA_ISR_GIF4_Msk = 0x1000
	// Bit GIF4.
	DMA_ISR_GIF4 = 0x1000
	// No transfer error, half event, complete event
	DMA_ISR_GIF4_NoEvent = 0x0
	// A transfer error, half event or complete event has occured
	DMA_ISR_GIF4_Event = 0x1
	// Position of TCIF4 field.
	DMA_ISR_TCIF4_Pos = 0xd
	// Bit mask of TCIF4 field.
	DMA_ISR_TCIF4_Msk = 0x2000
	// Bit TCIF4.
	DMA_ISR_TCIF4 = 0x2000
	// No transfer complete event
	DMA_ISR_TCIF4_NotComplete = 0x0
	// A transfer complete event has occured
	DMA_ISR_TCIF4_Complete = 0x1
	// Position of HTIF4 field.
	DMA_ISR_HTIF4_Pos = 0xe
	// Bit mask of HTIF4 field.
	DMA_ISR_HTIF4_Msk = 0x4000
	// Bit HTIF4.
	DMA_ISR_HTIF4 = 0x4000
	// No half transfer event
	DMA_ISR_HTIF4_NotHalf = 0x0
	// A half transfer event has occured
	DMA_ISR_HTIF4_Half = 0x1
	// Position of TEIF4 field.
	DMA_ISR_TEIF4_Pos = 0xf
	// Bit mask of TEIF4 field.
	DMA_ISR_TEIF4_Msk = 0x8000
	// Bit TEIF4.
	DMA_ISR_TEIF4 = 0x8000
	// No transfer error
	DMA_ISR_TEIF4_NoError = 0x0
	// A transfer error has occured
	DMA_ISR_TEIF4_Error = 0x1
	// Position of GIF5 field.
	DMA_ISR_GIF5_Pos = 0x10
	// Bit mask of GIF5 field.
	DMA_ISR_GIF5_Msk = 0x10000
	// Bit GIF5.
	DMA_ISR_GIF5 = 0x10000
	// No transfer error, half event, complete event
	DMA_ISR_GIF5_NoEvent = 0x0
	// A transfer error, half event or complete event has occured
	DMA_ISR_GIF5_Event = 0x1
	// Position of TCIF5 field.
	DMA_ISR_TCIF5_Pos = 0x11
	// Bit mask of TCIF5 field.
	DMA_ISR_TCIF5_Msk = 0x20000
	// Bit TCIF5.
	DMA_ISR_TCIF5 = 0x20000
	// No transfer complete event
	DMA_ISR_TCIF5_NotComplete = 0x0
	// A transfer complete event has occured
	DMA_ISR_TCIF5_Complete = 0x1
	// Position of HTIF5 field.
	DMA_ISR_HTIF5_Pos = 0x12
	// Bit mask of HTIF5 field.
	DMA_ISR_HTIF5_Msk = 0x40000
	// Bit HTIF5.
	DMA_ISR_HTIF5 = 0x40000
	// No half transfer event
	DMA_ISR_HTIF5_NotHalf = 0x0
	// A half transfer event has occured
	DMA_ISR_HTIF5_Half = 0x1
	// Position of TEIF5 field.
	DMA_ISR_TEIF5_Pos = 0x13
	// Bit mask of TEIF5 field.
	DMA_ISR_TEIF5_Msk = 0x80000
	// Bit TEIF5.
	DMA_ISR_TEIF5 = 0x80000
	// No transfer error
	DMA_ISR_TEIF5_NoError = 0x0
	// A transfer error has occured
	DMA_ISR_TEIF5_Error = 0x1
	// Position of GIF6 field.
	DMA_ISR_GIF6_Pos = 0x14
	// Bit mask of GIF6 field.
	DMA_ISR_GIF6_Msk = 0x100000
	// Bit GIF6.
	DMA_ISR_GIF6 = 0x100000
	// No transfer error, half event, complete event
	DMA_ISR_GIF6_NoEvent = 0x0
	// A transfer error, half event or complete event has occured
	DMA_ISR_GIF6_Event = 0x1
	// Position of TCIF6 field.
	DMA_ISR_TCIF6_Pos = 0x15
	// Bit mask of TCIF6 field.
	DMA_ISR_TCIF6_Msk = 0x200000
	// Bit TCIF6.
	DMA_ISR_TCIF6 = 0x200000
	// No transfer complete event
	DMA_ISR_TCIF6_NotComplete = 0x0
	// A transfer complete event has occured
	DMA_ISR_TCIF6_Complete = 0x1
	// Position of HTIF6 field.
	DMA_ISR_HTIF6_Pos = 0x16
	// Bit mask of HTIF6 field.
	DMA_ISR_HTIF6_Msk = 0x400000
	// Bit HTIF6.
	DMA_ISR_HTIF6 = 0x400000
	// No half transfer event
	DMA_ISR_HTIF6_NotHalf = 0x0
	// A half transfer event has occured
	DMA_ISR_HTIF6_Half = 0x1
	// Position of TEIF6 field.
	DMA_ISR_TEIF6_Pos = 0x17
	// Bit mask of TEIF6 field.
	DMA_ISR_TEIF6_Msk = 0x800000
	// Bit TEIF6.
	DMA_ISR_TEIF6 = 0x800000
	// No transfer error
	DMA_ISR_TEIF6_NoError = 0x0
	// A transfer error has occured
	DMA_ISR_TEIF6_Error = 0x1
	// Position of GIF7 field.
	DMA_ISR_GIF7_Pos = 0x18
	// Bit mask of GIF7 field.
	DMA_ISR_GIF7_Msk = 0x1000000
	// Bit GIF7.
	DMA_ISR_GIF7 = 0x1000000
	// No transfer error, half event, complete event
	DMA_ISR_GIF7_NoEvent = 0x0
	// A transfer error, half event or complete event has occured
	DMA_ISR_GIF7_Event = 0x1
	// Position of TCIF7 field.
	DMA_ISR_TCIF7_Pos = 0x19
	// Bit mask of TCIF7 field.
	DMA_ISR_TCIF7_Msk = 0x2000000
	// Bit TCIF7.
	DMA_ISR_TCIF7 = 0x2000000
	// No transfer complete event
	DMA_ISR_TCIF7_NotComplete = 0x0
	// A transfer complete event has occured
	DMA_ISR_TCIF7_Complete = 0x1
	// Position of HTIF7 field.
	DMA_ISR_HTIF7_Pos = 0x1a
	// Bit mask of HTIF7 field.
	DMA_ISR_HTIF7_Msk = 0x4000000
	// Bit HTIF7.
	DMA_ISR_HTIF7 = 0x4000000
	// No half transfer event
	DMA_ISR_HTIF7_NotHalf = 0x0
	// A half transfer event has occured
	DMA_ISR_HTIF7_Half = 0x1
	// Position of TEIF7 field.
	DMA_ISR_TEIF7_Pos = 0x1b
	// Bit mask of TEIF7 field.
	DMA_ISR_TEIF7_Msk = 0x8000000
	// Bit TEIF7.
	DMA_ISR_TEIF7 = 0x8000000
	// No transfer error
	DMA_ISR_TEIF7_NoError = 0x0
	// A transfer error has occured
	DMA_ISR_TEIF7_Error = 0x1

	// IFCR: DMA interrupt flag clear register (DMA_IFCR)
	// Position of CGIF1 field.
	DMA_IFCR_CGIF1_Pos = 0x0
	// Bit mask of CGIF1 field.
	DMA_IFCR_CGIF1_Msk = 0x1
	// Bit CGIF1.
	DMA_IFCR_CGIF1 = 0x1
	// Clears the GIF, TEIF, HTIF, TCIF flags in the ISR register
	DMA_IFCR_CGIF1_Clear = 0x1
	// Position of CTCIF1 field.
	DMA_IFCR_CTCIF1_Pos = 0x1
	// Bit mask of CTCIF1 field.
	DMA_IFCR_CTCIF1_Msk = 0x2
	// Bit CTCIF1.
	DMA_IFCR_CTCIF1 = 0x2
	// Clears the TCIF flag in the ISR register
	DMA_IFCR_CTCIF1_Clear = 0x1
	// Position of CHTIF1 field.
	DMA_IFCR_CHTIF1_Pos = 0x2
	// Bit mask of CHTIF1 field.
	DMA_IFCR_CHTIF1_Msk = 0x4
	// Bit CHTIF1.
	DMA_IFCR_CHTIF1 = 0x4
	// Clears the HTIF flag in the ISR register
	DMA_IFCR_CHTIF1_Clear = 0x1
	// Position of CTEIF1 field.
	DMA_IFCR_CTEIF1_Pos = 0x3
	// Bit mask of CTEIF1 field.
	DMA_IFCR_CTEIF1_Msk = 0x8
	// Bit CTEIF1.
	DMA_IFCR_CTEIF1 = 0x8
	// Clears the TEIF flag in the ISR register
	DMA_IFCR_CTEIF1_Clear = 0x1
	// Position of CGIF2 field.
	DMA_IFCR_CGIF2_Pos = 0x4
	// Bit mask of CGIF2 field.
	DMA_IFCR_CGIF2_Msk = 0x10
	// Bit CGIF2.
	DMA_IFCR_CGIF2 = 0x10
	// Clears the GIF, TEIF, HTIF, TCIF flags in the ISR register
	DMA_IFCR_CGIF2_Clear = 0x1
	// Position of CTCIF2 field.
	DMA_IFCR_CTCIF2_Pos = 0x5
	// Bit mask of CTCIF2 field.
	DMA_IFCR_CTCIF2_Msk = 0x20
	// Bit CTCIF2.
	DMA_IFCR_CTCIF2 = 0x20
	// Clears the TCIF flag in the ISR register
	DMA_IFCR_CTCIF2_Clear = 0x1
	// Position of CHTIF2 field.
	DMA_IFCR_CHTIF2_Pos = 0x6
	// Bit mask of CHTIF2 field.
	DMA_IFCR_CHTIF2_Msk = 0x40
	// Bit CHTIF2.
	DMA_IFCR_CHTIF2 = 0x40
	// Clears the HTIF flag in the ISR register
	DMA_IFCR_CHTIF2_Clear = 0x1
	// Position of CTEIF2 field.
	DMA_IFCR_CTEIF2_Pos = 0x7
	// Bit mask of CTEIF2 field.
	DMA_IFCR_CTEIF2_Msk = 0x80
	// Bit CTEIF2.
	DMA_IFCR_CTEIF2 = 0x80
	// Clears the TEIF flag in the ISR register
	DMA_IFCR_CTEIF2_Clear = 0x1
	// Position of CGIF3 field.
	DMA_IFCR_CGIF3_Pos = 0x8
	// Bit mask of CGIF3 field.
	DMA_IFCR_CGIF3_Msk = 0x100
	// Bit CGIF3.
	DMA_IFCR_CGIF3 = 0x100
	// Clears the GIF, TEIF, HTIF, TCIF flags in the ISR register
	DMA_IFCR_CGIF3_Clear = 0x1
	// Position of CTCIF3 field.
	DMA_IFCR_CTCIF3_Pos = 0x9
	// Bit mask of CTCIF3 field.
	DMA_IFCR_CTCIF3_Msk = 0x200
	// Bit CTCIF3.
	DMA_IFCR_CTCIF3 = 0x200
	// Clears the TCIF flag in the ISR register
	DMA_IFCR_CTCIF3_Clear = 0x1
	// Position of CHTIF3 field.
	DMA_IFCR_CHTIF3_Pos = 0xa
	// Bit mask of CHTIF3 field.
	DMA_IFCR_CHTIF3_Msk = 0x400
	// Bit CHTIF3.
	DMA_IFCR_CHTIF3 = 0x400
	// Clears the HTIF flag in the ISR register
	DMA_IFCR_CHTIF3_Clear = 0x1
	// Position of CTEIF3 field.
	DMA_IFCR_CTEIF3_Pos = 0xb
	// Bit mask of CTEIF3 field.
	DMA_IFCR_CTEIF3_Msk = 0x800
	// Bit CTEIF3.
	DMA_IFCR_CTEIF3 = 0x800
	// Clears the TEIF flag in the ISR register
	DMA_IFCR_CTEIF3_Clear = 0x1
	// Position of CGIF4 field.
	DMA_IFCR_CGIF4_Pos = 0xc
	// Bit mask of CGIF4 field.
	DMA_IFCR_CGIF4_Msk = 0x1000
	// Bit CGIF4.
	DMA_IFCR_CGIF4 = 0x1000
	// Clears the GIF, TEIF, HTIF, TCIF flags in the ISR register
	DMA_IFCR_CGIF4_Clear = 0x1
	// Position of CTCIF4 field.
	DMA_IFCR_CTCIF4_Pos = 0xd
	// Bit mask of CTCIF4 field.
	DMA_IFCR_CTCIF4_Msk = 0x2000
	// Bit CTCIF4.
	DMA_IFCR_CTCIF4 = 0x2000
	// Clears the TCIF flag in the ISR register
	DMA_IFCR_CTCIF4_Clear = 0x1
	// Position of CHTIF4 field.
	DMA_IFCR_CHTIF4_Pos = 0xe
	// Bit mask of CHTIF4 field.
	DMA_IFCR_CHTIF4_Msk = 0x4000
	// Bit CHTIF4.
	DMA_IFCR_CHTIF4 = 0x4000
	// Clears the HTIF flag in the ISR register
	DMA_IFCR_CHTIF4_Clear = 0x1
	// Position of CTEIF4 field.
	DMA_IFCR_CTEIF4_Pos = 0xf
	// Bit mask of CTEIF4 field.
	DMA_IFCR_CTEIF4_Msk = 0x8000
	// Bit CTEIF4.
	DMA_IFCR_CTEIF4 = 0x8000
	// Clears the TEIF flag in the ISR register
	DMA_IFCR_CTEIF4_Clear = 0x1
	// Position of CGIF5 field.
	DMA_IFCR_CGIF5_Pos = 0x10
	// Bit mask of CGIF5 field.
	DMA_IFCR_CGIF5_Msk = 0x10000
	// Bit CGIF5.
	DMA_IFCR_CGIF5 = 0x10000
	// Clears the GIF, TEIF, HTIF, TCIF flags in the ISR register
	DMA_IFCR_CGIF5_Clear = 0x1
	// Position of CTCIF5 field.
	DMA_IFCR_CTCIF5_Pos = 0x11
	// Bit mask of CTCIF5 field.
	DMA_IFCR_CTCIF5_Msk = 0x20000
	// Bit CTCIF5.
	DMA_IFCR_CTCIF5 = 0x20000
	// Clears the TCIF flag in the ISR register
	DMA_IFCR_CTCIF5_Clear = 0x1
	// Position of CHTIF5 field.
	DMA_IFCR_CHTIF5_Pos = 0x12
	// Bit mask of CHTIF5 field.
	DMA_IFCR_CHTIF5_Msk = 0x40000
	// Bit CHTIF5.
	DMA_IFCR_CHTIF5 = 0x40000
	// Clears the HTIF flag in the ISR register
	DMA_IFCR_CHTIF5_Clear = 0x1
	// Position of CTEIF5 field.
	DMA_IFCR_CTEIF5_Pos = 0x13
	// Bit mask of CTEIF5 field.
	DMA_IFCR_CTEIF5_Msk = 0x80000
	// Bit CTEIF5.
	DMA_IFCR_CTEIF5 = 0x80000
	// Clears the TEIF flag in the ISR register
	DMA_IFCR_CTEIF5_Clear = 0x1
	// Position of CGIF6 field.
	DMA_IFCR_CGIF6_Pos = 0x14
	// Bit mask of CGIF6 field.
	DMA_IFCR_CGIF6_Msk = 0x100000
	// Bit CGIF6.
	DMA_IFCR_CGIF6 = 0x100000
	// Clears the GIF, TEIF, HTIF, TCIF flags in the ISR register
	DMA_IFCR_CGIF6_Clear = 0x1
	// Position of CTCIF6 field.
	DMA_IFCR_CTCIF6_Pos = 0x15
	// Bit mask of CTCIF6 field.
	DMA_IFCR_CTCIF6_Msk = 0x200000
	// Bit CTCIF6.
	DMA_IFCR_CTCIF6 = 0x200000
	// Clears the TCIF flag in the ISR register
	DMA_IFCR_CTCIF6_Clear = 0x1
	// Position of CHTIF6 field.
	DMA_IFCR_CHTIF6_Pos = 0x16
	// Bit mask of CHTIF6 field.
	DMA_IFCR_CHTIF6_Msk = 0x400000
	// Bit CHTIF6.
	DMA_IFCR_CHTIF6 = 0x400000
	// Clears the HTIF flag in the ISR register
	DMA_IFCR_CHTIF6_Clear = 0x1
	// Position of CTEIF6 field.
	DMA_IFCR_CTEIF6_Pos = 0x17
	// Bit mask of CTEIF6 field.
	DMA_IFCR_CTEIF6_Msk = 0x800000
	// Bit CTEIF6.
	DMA_IFCR_CTEIF6 = 0x800000
	// Clears the TEIF flag in the ISR register
	DMA_IFCR_CTEIF6_Clear = 0x1
	// Position of CGIF7 field.
	DMA_IFCR_CGIF7_Pos = 0x18
	// Bit mask of CGIF7 field.
	DMA_IFCR_CGIF7_Msk = 0x1000000
	// Bit CGIF7.
	DMA_IFCR_CGIF7 = 0x1000000
	// Clears the GIF, TEIF, HTIF, TCIF flags in the ISR register
	DMA_IFCR_CGIF7_Clear = 0x1
	// Position of CTCIF7 field.
	DMA_IFCR_CTCIF7_Pos = 0x19
	// Bit mask of CTCIF7 field.
	DMA_IFCR_CTCIF7_Msk = 0x2000000
	// Bit CTCIF7.
	DMA_IFCR_CTCIF7 = 0x2000000
	// Clears the TCIF flag in the ISR register
	DMA_IFCR_CTCIF7_Clear = 0x1
	// Position of CHTIF7 field.
	DMA_IFCR_CHTIF7_Pos = 0x1a
	// Bit mask of CHTIF7 field.
	DMA_IFCR_CHTIF7_Msk = 0x4000000
	// Bit CHTIF7.
	DMA_IFCR_CHTIF7 = 0x4000000
	// Clears the HTIF flag in the ISR register
	DMA_IFCR_CHTIF7_Clear = 0x1
	// Position of CTEIF7 field.
	DMA_IFCR_CTEIF7_Pos = 0x1b
	// Bit mask of CTEIF7 field.
	DMA_IFCR_CTEIF7_Msk = 0x8000000
	// Bit CTEIF7.
	DMA_IFCR_CTEIF7 = 0x8000000
	// Clears the TEIF flag in the ISR register
	DMA_IFCR_CTEIF7_Clear = 0x1

	// CH.CR: DMA channel configuration register (DMA_CCR)
	// Position of EN field.
	DMA_CH_CR_EN_Pos = 0x0
	// Bit mask of EN field.
	DMA_CH_CR_EN_Msk = 0x1
	// Bit EN.
	DMA_CH_CR_EN = 0x1
	// Channel disabled
	DMA_CH_CR_EN_Disabled = 0x0
	// Channel enabled
	DMA_CH_CR_EN_Enabled = 0x1
	// Position of TCIE field.
	DMA_CH_CR_TCIE_Pos = 0x1
	// Bit mask of TCIE field.
	DMA_CH_CR_TCIE_Msk = 0x2
	// Bit TCIE.
	DMA_CH_CR_TCIE = 0x2
	// Transfer Complete interrupt disabled
	DMA_CH_CR_TCIE_Disabled = 0x0
	// Transfer Complete interrupt enabled
	DMA_CH_CR_TCIE_Enabled = 0x1
	// Position of HTIE field.
	DMA_CH_CR_HTIE_Pos = 0x2
	// Bit mask of HTIE field.
	DMA_CH_CR_HTIE_Msk = 0x4
	// Bit HTIE.
	DMA_CH_CR_HTIE = 0x4
	// Half Transfer interrupt disabled
	DMA_CH_CR_HTIE_Disabled = 0x0
	// Half Transfer interrupt enabled
	DMA_CH_CR_HTIE_Enabled = 0x1
	// Position of TEIE field.
	DMA_CH_CR_TEIE_Pos = 0x3
	// Bit mask of TEIE field.
	DMA_CH_CR_TEIE_Msk = 0x8
	// Bit TEIE.
	DMA_CH_CR_TEIE = 0x8
	// Transfer Error interrupt disabled
	DMA_CH_CR_TEIE_Disabled = 0x0
	// Transfer Error interrupt enabled
	DMA_CH_CR_TEIE_Enabled = 0x1
	// Position of DIR field.
	DMA_CH_CR_DIR_Pos = 0x4
	// Bit mask of DIR field.
	DMA_CH_CR_DIR_Msk = 0x10
	// Bit DIR.
	DMA_CH_CR_DIR = 0x10
	// Read from peripheral
	DMA_CH_CR_DIR_FromPeripheral = 0x0
	// Read from memory
	DMA_CH_CR_DIR_FromMemory = 0x1
	// Position of CIRC field.
	DMA_CH_CR_CIRC_Pos = 0x5
	// Bit mask of CIRC field.
	DMA_CH_CR_CIRC_Msk = 0x20
	// Bit CIRC.
	DMA_CH_CR_CIRC = 0x20
	// Circular buffer disabled
	DMA_CH_CR_CIRC_Disabled = 0x0
	// Circular buffer enabled
	DMA_CH_CR_CIRC_Enabled = 0x1
	// Position of PINC field.
	DMA_CH_CR_PINC_Pos = 0x6
	// Bit mask of PINC field.
	DMA_CH_CR_PINC_Msk = 0x40
	// Bit PINC.
	DMA_CH_CR_PINC = 0x40
	// Increment mode disabled
	DMA_CH_CR_PINC_Disabled = 0x0
	// Increment mode enabled
	DMA_CH_CR_PINC_Enabled = 0x1
	// Position of MINC field.
	DMA_CH_CR_MINC_Pos = 0x7
	// Bit mask of MINC field.
	DMA_CH_CR_MINC_Msk = 0x80
	// Bit MINC.
	DMA_CH_CR_MINC = 0x80
	// Increment mode disabled
	DMA_CH_CR_MINC_Disabled = 0x0
	// Increment mode enabled
	DMA_CH_CR_MINC_Enabled = 0x1
	// Position of PSIZE field.
	DMA_CH_CR_PSIZE_Pos = 0x8
	// Bit mask of PSIZE field.
	DMA_CH_CR_PSIZE_Msk = 0x300
	// 8-bit size
	DMA_CH_CR_PSIZE_Bits8 = 0x0
	// 16-bit size
	DMA_CH_CR_PSIZE_Bits16 = 0x1
	// 32-bit size
	DMA_CH_CR_PSIZE_Bits32 = 0x2
	// Position of MSIZE field.
	DMA_CH_CR_MSIZE_Pos = 0xa
	// Bit mask of MSIZE field.
	DMA_CH_CR_MSIZE_Msk = 0xc00
	// 8-bit size
	DMA_CH_CR_MSIZE_Bits8 = 0x0
	// 16-bit size
	DMA_CH_CR_MSIZE_Bits16 = 0x1
	// 32-bit size
	DMA_CH_CR_MSIZE_Bits32 = 0x2
	// Position of PL field.
	DMA_CH_CR_PL_Pos = 0xc
	// Bit mask of PL field.
	DMA_CH_CR_PL_Msk = 0x3000
	// Low priority
	DMA_CH_CR_PL_Low = 0x0
	// Medium priority
	DMA_CH_CR_PL_Medium = 0x1
	// High priority
	DMA_CH_CR_PL_High = 0x2
	// Very high priority
	DMA_CH_CR_PL_VeryHigh = 0x3
	// Position of MEM2MEM field.
	DMA_CH_CR_MEM2MEM_Pos = 0xe
	// Bit mask of MEM2MEM field.
	DMA_CH_CR_MEM2MEM_Msk = 0x4000
	// Bit MEM2MEM.
	DMA_CH_CR_MEM2MEM = 0x4000
	// Memory to memory mode disabled
	DMA_CH_CR_MEM2MEM_Disabled = 0x0
	// Memory to memory mode enabled
	DMA_CH_CR_MEM2MEM_Enabled = 0x1

	// CH.NDTR: DMA channel 1 number of data register
	// Position of NDT field.
	DMA_CH_NDTR_NDT_Pos = 0x0
	// Bit mask of NDT field.
	DMA_CH_NDTR_NDT_Msk = 0xffff

	// CH.PAR: DMA channel 1 peripheral address register
	// Position of PA field.
	DMA_CH_PAR_PA_Pos = 0x0
	// Bit mask of PA field.
	DMA_CH_PAR_PA_Msk = 0xffffffff

	// CH.MAR: DMA channel 1 memory address register
	// Position of MA field.
	DMA_CH_MAR_MA_Pos = 0x0
	// Bit mask of MA field.
	DMA_CH_MAR_MA_Msk = 0xffffffff
)

// Bitfields for TIM2: General purpose timer
const (
	// CR1: control register 1
	// Position of CEN field.
	TIMs_CR1_CEN_Pos = 0x0
	// Bit mask of CEN field.
	TIMs_CR1_CEN_Msk = 0x1
	// Bit CEN.
	TIMs_CR1_CEN = 0x1
	// Counter disabled
	TIMs_CR1_CEN_Disabled = 0x0
	// Counter enabled
	TIMs_CR1_CEN_Enabled = 0x1
	// Position of UDIS field.
	TIMs_CR1_UDIS_Pos = 0x1
	// Bit mask of UDIS field.
	TIMs_CR1_UDIS_Msk = 0x2
	// Bit UDIS.
	TIMs_CR1_UDIS = 0x2
	// Update event enabled
	TIMs_CR1_UDIS_Enabled = 0x0
	// Update event disabled
	TIMs_CR1_UDIS_Disabled = 0x1
	// Position of URS field.
	TIMs_CR1_URS_Pos = 0x2
	// Bit mask of URS field.
	TIMs_CR1_URS_Msk = 0x4
	// Bit URS.
	TIMs_CR1_URS = 0x4
	// Any of counter overflow/underflow, setting UG, or update through slave mode, generates an update interrupt or DMA request
	TIMs_CR1_URS_AnyEvent = 0x0
	// Only counter overflow/underflow generates an update interrupt or DMA request
	TIMs_CR1_URS_CounterOnly = 0x1
	// Position of OPM field.
	TIMs_CR1_OPM_Pos = 0x3
	// Bit mask of OPM field.
	TIMs_CR1_OPM_Msk = 0x8
	// Bit OPM.
	TIMs_CR1_OPM = 0x8
	// Counter is not stopped at update event
	TIMs_CR1_OPM_Disabled = 0x0
	// Counter stops counting at the next update event (clearing the CEN bit)
	TIMs_CR1_OPM_Enabled = 0x1
	// Position of DIR field.
	TIMs_CR1_DIR_Pos = 0x4
	// Bit mask of DIR field.
	TIMs_CR1_DIR_Msk = 0x10
	// Bit DIR.
	TIMs_CR1_DIR = 0x10
	// Counter used as upcounter
	TIMs_CR1_DIR_Up = 0x0
	// Counter used as downcounter
	TIMs_CR1_DIR_Down = 0x1
	// Position of CMS field.
	TIMs_CR1_CMS_Pos = 0x5
	// Bit mask of CMS field.
	TIMs_CR1_CMS_Msk = 0x60
	// The counter counts up or down depending on the direction bit
	TIMs_CR1_CMS_EdgeAligned = 0x0
	// The counter counts up and down alternatively. Output compare interrupt flags are set only when the counter is counting down.
	TIMs_CR1_CMS_CenterAligned1 = 0x1
	// The counter counts up and down alternatively. Output compare interrupt flags are set only when the counter is counting up.
	TIMs_CR1_CMS_CenterAligned2 = 0x2
	// The counter counts up and down alternatively. Output compare interrupt flags are set both when the counter is counting up or down.
	TIMs_CR1_CMS_CenterAligned3 = 0x3
	// Position of ARPE field.
	TIMs_CR1_ARPE_Pos = 0x7
	// Bit mask of ARPE field.
	TIMs_CR1_ARPE_Msk = 0x80
	// Bit ARPE.
	TIMs_CR1_ARPE = 0x80
	// TIMx_APRR register is not buffered
	TIMs_CR1_ARPE_Disabled = 0x0
	// TIMx_APRR register is buffered
	TIMs_CR1_ARPE_Enabled = 0x1
	// Position of CKD field.
	TIMs_CR1_CKD_Pos = 0x8
	// Bit mask of CKD field.
	TIMs_CR1_CKD_Msk = 0x300
	// t_DTS = t_CK_INT
	TIMs_CR1_CKD_Div1 = 0x0
	// t_DTS = 2 × t_CK_INT
	TIMs_CR1_CKD_Div2 = 0x1
	// t_DTS = 4 × t_CK_INT
	TIMs_CR1_CKD_Div4 = 0x2
	// Position of UIFREMAP field.
	TIMs_CR1_UIFREMAP_Pos = 0xb
	// Bit mask of UIFREMAP field.
	TIMs_CR1_UIFREMAP_Msk = 0x800
	// Bit UIFREMAP.
	TIMs_CR1_UIFREMAP = 0x800

	// CR2: control register 2
	// Position of TI1S field.
	TIMs_CR2_TI1S_Pos = 0x7
	// Bit mask of TI1S field.
	TIMs_CR2_TI1S_Msk = 0x80
	// Bit TI1S.
	TIMs_CR2_TI1S = 0x80
	// The TIMx_CH1 pin is connected to TI1 input
	TIMs_CR2_TI1S_Normal = 0x0
	// The TIMx_CH1, CH2, CH3 pins are connected to TI1 input
	TIMs_CR2_TI1S_XOR = 0x1
	// Position of MMS field.
	TIMs_CR2_MMS_Pos = 0x4
	// Bit mask of MMS field.
	TIMs_CR2_MMS_Msk = 0x70
	// The UG bit from the TIMx_EGR register is used as trigger output
	TIMs_CR2_MMS_Reset = 0x0
	// The counter enable signal, CNT_EN, is used as trigger output
	TIMs_CR2_MMS_Enable = 0x1
	// The update event is selected as trigger output
	TIMs_CR2_MMS_Update = 0x2
	// The trigger output send a positive pulse when the CC1IF flag it to be set, as soon as a capture or a compare match occurred
	TIMs_CR2_MMS_ComparePulse = 0x3
	// OC1REF signal is used as trigger output
	TIMs_CR2_MMS_CompareOC1 = 0x4
	// OC2REF signal is used as trigger output
	TIMs_CR2_MMS_CompareOC2 = 0x5
	// OC3REF signal is used as trigger output
	TIMs_CR2_MMS_CompareOC3 = 0x6
	// OC4REF signal is used as trigger output
	TIMs_CR2_MMS_CompareOC4 = 0x7
	// Position of CCDS field.
	TIMs_CR2_CCDS_Pos = 0x3
	// Bit mask of CCDS field.
	TIMs_CR2_CCDS_Msk = 0x8
	// Bit CCDS.
	TIMs_CR2_CCDS = 0x8
	// CCx DMA request sent when CCx event occurs
	TIMs_CR2_CCDS_OnCompare = 0x0
	// CCx DMA request sent when update event occurs
	TIMs_CR2_CCDS_OnUpdate = 0x1

	// SMCR: slave mode control register
	// Position of SMS field.
	TIMs_SMCR_SMS_Pos = 0x0
	// Bit mask of SMS field.
	TIMs_SMCR_SMS_Msk = 0x7
	// Slave mode disabled - if CEN = ‘1 then the prescaler is clocked directly by the internal clock.
	TIMs_SMCR_SMS_Disabled = 0x0
	// Encoder mode 1 - Counter counts up/down on TI2FP1 edge depending on TI1FP2 level.
	TIMs_SMCR_SMS_Encoder_Mode_1 = 0x1
	// Encoder mode 2 - Counter counts up/down on TI1FP2 edge depending on TI2FP1 level.
	TIMs_SMCR_SMS_Encoder_Mode_2 = 0x2
	// Encoder mode 3 - Counter counts up/down on both TI1FP1 and TI2FP2 edges depending on the level of the other input.
	TIMs_SMCR_SMS_Encoder_Mode_3 = 0x3
	// Reset Mode - Rising edge of the selected trigger input (TRGI) reinitializes the counter and generates an update of the registers.
	TIMs_SMCR_SMS_Reset_Mode = 0x4
	// Gated Mode - The counter clock is enabled when the trigger input (TRGI) is high. The counter stops (but is not reset) as soon as the trigger becomes low. Both start and stop of the counter are controlled.
	TIMs_SMCR_SMS_Gated_Mode = 0x5
	// Trigger Mode - The counter starts at a rising edge of the trigger TRGI (but it is not reset). Only the start of the counter is controlled.
	TIMs_SMCR_SMS_Trigger_Mode = 0x6
	// External Clock Mode 1 - Rising edges of the selected trigger (TRGI) clock the counter.
	TIMs_SMCR_SMS_Ext_Clock_Mode = 0x7
	// Position of OCCS field.
	TIMs_SMCR_OCCS_Pos = 0x3
	// Bit mask of OCCS field.
	TIMs_SMCR_OCCS_Msk = 0x8
	// Bit OCCS.
	TIMs_SMCR_OCCS = 0x8
	// Position of TS field.
	TIMs_SMCR_TS_Pos = 0x4
	// Bit mask of TS field.
	TIMs_SMCR_TS_Msk = 0x70
	// Internal Trigger 0 (ITR0)
	TIMs_SMCR_TS_ITR0 = 0x0
	// Internal Trigger 1 (ITR1)
	TIMs_SMCR_TS_ITR1 = 0x1
	// Internal Trigger 2 (ITR2)
	TIMs_SMCR_TS_ITR2 = 0x2
	// TI1 Edge Detector (TI1F_ED)
	TIMs_SMCR_TS_TI1F_ED = 0x4
	// Filtered Timer Input 1 (TI1FP1)
	TIMs_SMCR_TS_TI1FP1 = 0x5
	// Filtered Timer Input 2 (TI2FP2)
	TIMs_SMCR_TS_TI2FP2 = 0x6
	// External Trigger input (ETRF)
	TIMs_SMCR_TS_ETRF = 0x7
	// Position of MSM field.
	TIMs_SMCR_MSM_Pos = 0x7
	// Bit mask of MSM field.
	TIMs_SMCR_MSM_Msk = 0x80
	// Bit MSM.
	TIMs_SMCR_MSM = 0x80
	// No action
	TIMs_SMCR_MSM_NoSync = 0x0
	// The effect of an event on the trigger input (TRGI) is delayed to allow a perfect synchronization between the current timer and its slaves (through TRGO). It is useful if we want to synchronize several timers on a single external event.
	TIMs_SMCR_MSM_Sync = 0x1
	// Position of ETF field.
	TIMs_SMCR_ETF_Pos = 0x8
	// Bit mask of ETF field.
	TIMs_SMCR_ETF_Msk = 0xf00
	// No filter, sampling is done at fDTS
	TIMs_SMCR_ETF_NoFilter = 0x0
	// fSAMPLING=fCK_INT, N=2
	TIMs_SMCR_ETF_FCK_INT_N2 = 0x1
	// fSAMPLING=fCK_INT, N=4
	TIMs_SMCR_ETF_FCK_INT_N4 = 0x2
	// fSAMPLING=fCK_INT, N=8
	TIMs_SMCR_ETF_FCK_INT_N8 = 0x3
	// fSAMPLING=fDTS/2, N=6
	TIMs_SMCR_ETF_FDTS_Div2_N6 = 0x4
	// fSAMPLING=fDTS/2, N=8
	TIMs_SMCR_ETF_FDTS_Div2_N8 = 0x5
	// fSAMPLING=fDTS/4, N=6
	TIMs_SMCR_ETF_FDTS_Div4_N6 = 0x6
	// fSAMPLING=fDTS/4, N=8
	TIMs_SMCR_ETF_FDTS_Div4_N8 = 0x7
	// fSAMPLING=fDTS/8, N=6
	TIMs_SMCR_ETF_FDTS_Div8_N6 = 0x8
	// fSAMPLING=fDTS/8, N=8
	TIMs_SMCR_ETF_FDTS_Div8_N8 = 0x9
	// fSAMPLING=fDTS/16, N=5
	TIMs_SMCR_ETF_FDTS_Div16_N5 = 0xa
	// fSAMPLING=fDTS/16, N=6
	TIMs_SMCR_ETF_FDTS_Div16_N6 = 0xb
	// fSAMPLING=fDTS/16, N=8
	TIMs_SMCR_ETF_FDTS_Div16_N8 = 0xc
	// fSAMPLING=fDTS/32, N=5
	TIMs_SMCR_ETF_FDTS_Div32_N5 = 0xd
	// fSAMPLING=fDTS/32, N=6
	TIMs_SMCR_ETF_FDTS_Div32_N6 = 0xe
	// fSAMPLING=fDTS/32, N=8
	TIMs_SMCR_ETF_FDTS_Div32_N8 = 0xf
	// Position of ETPS field.
	TIMs_SMCR_ETPS_Pos = 0xc
	// Bit mask of ETPS field.
	TIMs_SMCR_ETPS_Msk = 0x3000
	// Prescaler OFF
	TIMs_SMCR_ETPS_Div1 = 0x0
	// ETRP frequency divided by 2
	TIMs_SMCR_ETPS_Div2 = 0x1
	// ETRP frequency divided by 4
	TIMs_SMCR_ETPS_Div4 = 0x2
	// ETRP frequency divided by 8
	TIMs_SMCR_ETPS_Div8 = 0x3
	// Position of ECE field.
	TIMs_SMCR_ECE_Pos = 0xe
	// Bit mask of ECE field.
	TIMs_SMCR_ECE_Msk = 0x4000
	// Bit ECE.
	TIMs_SMCR_ECE = 0x4000
	// External clock mode 2 disabled
	TIMs_SMCR_ECE_Disabled = 0x0
	// External clock mode 2 enabled. The counter is clocked by any active edge on the ETRF signal.
	TIMs_SMCR_ECE_Enabled = 0x1
	// Position of ETP field.
	TIMs_SMCR_ETP_Pos = 0xf
	// Bit mask of ETP field.
	TIMs_SMCR_ETP_Msk = 0x8000
	// Bit ETP.
	TIMs_SMCR_ETP = 0x8000
	// ETR is noninverted, active at high level or rising edge
	TIMs_SMCR_ETP_NotInverted = 0x0
	// ETR is inverted, active at low level or falling edge
	TIMs_SMCR_ETP_Inverted = 0x1
	// Position of SMS_3 field.
	TIMs_SMCR_SMS_3_Pos = 0x10
	// Bit mask of SMS_3 field.
	TIMs_SMCR_SMS_3_Msk = 0x10000
	// Bit SMS_3.
	TIMs_SMCR_SMS_3 = 0x10000

	// DIER: DMA/Interrupt enable register
	// Position of TDE field.
	TIMs_DIER_TDE_Pos = 0xe
	// Bit mask of TDE field.
	TIMs_DIER_TDE_Msk = 0x4000
	// Bit TDE.
	TIMs_DIER_TDE = 0x4000
	// Trigger DMA request disabled
	TIMs_DIER_TDE_Disabled = 0x0
	// Trigger DMA request enabled
	TIMs_DIER_TDE_Enabled = 0x1
	// Position of CC4DE field.
	TIMs_DIER_CC4DE_Pos = 0xc
	// Bit mask of CC4DE field.
	TIMs_DIER_CC4DE_Msk = 0x1000
	// Bit CC4DE.
	TIMs_DIER_CC4DE = 0x1000
	// CCx DMA request disabled
	TIMs_DIER_CC4DE_Disabled = 0x0
	// CCx DMA request enabled
	TIMs_DIER_CC4DE_Enabled = 0x1
	// Position of CC3DE field.
	TIMs_DIER_CC3DE_Pos = 0xb
	// Bit mask of CC3DE field.
	TIMs_DIER_CC3DE_Msk = 0x800
	// Bit CC3DE.
	TIMs_DIER_CC3DE = 0x800
	// CCx DMA request disabled
	TIMs_DIER_CC3DE_Disabled = 0x0
	// CCx DMA request enabled
	TIMs_DIER_CC3DE_Enabled = 0x1
	// Position of CC2DE field.
	TIMs_DIER_CC2DE_Pos = 0xa
	// Bit mask of CC2DE field.
	TIMs_DIER_CC2DE_Msk = 0x400
	// Bit CC2DE.
	TIMs_DIER_CC2DE = 0x400
	// CCx DMA request disabled
	TIMs_DIER_CC2DE_Disabled = 0x0
	// CCx DMA request enabled
	TIMs_DIER_CC2DE_Enabled = 0x1
	// Position of CC1DE field.
	TIMs_DIER_CC1DE_Pos = 0x9
	// Bit mask of CC1DE field.
	TIMs_DIER_CC1DE_Msk = 0x200
	// Bit CC1DE.
	TIMs_DIER_CC1DE = 0x200
	// CCx DMA request disabled
	TIMs_DIER_CC1DE_Disabled = 0x0
	// CCx DMA request enabled
	TIMs_DIER_CC1DE_Enabled = 0x1
	// Position of UDE field.
	TIMs_DIER_UDE_Pos = 0x8
	// Bit mask of UDE field.
	TIMs_DIER_UDE_Msk = 0x100
	// Bit UDE.
	TIMs_DIER_UDE = 0x100
	// Update DMA request disabled
	TIMs_DIER_UDE_Disabled = 0x0
	// Update DMA request enabled
	TIMs_DIER_UDE_Enabled = 0x1
	// Position of TIE field.
	TIMs_DIER_TIE_Pos = 0x6
	// Bit mask of TIE field.
	TIMs_DIER_TIE_Msk = 0x40
	// Bit TIE.
	TIMs_DIER_TIE = 0x40
	// Trigger interrupt disabled
	TIMs_DIER_TIE_Disabled = 0x0
	// Trigger interrupt enabled
	TIMs_DIER_TIE_Enabled = 0x1
	// Position of CC4IE field.
	TIMs_DIER_CC4IE_Pos = 0x4
	// Bit mask of CC4IE field.
	TIMs_DIER_CC4IE_Msk = 0x10
	// Bit CC4IE.
	TIMs_DIER_CC4IE = 0x10
	// CCx interrupt disabled
	TIMs_DIER_CC4IE_Disabled = 0x0
	// CCx interrupt enabled
	TIMs_DIER_CC4IE_Enabled = 0x1
	// Position of CC3IE field.
	TIMs_DIER_CC3IE_Pos = 0x3
	// Bit mask of CC3IE field.
	TIMs_DIER_CC3IE_Msk = 0x8
	// Bit CC3IE.
	TIMs_DIER_CC3IE = 0x8
	// CCx interrupt disabled
	TIMs_DIER_CC3IE_Disabled = 0x0
	// CCx interrupt enabled
	TIMs_DIER_CC3IE_Enabled = 0x1
	// Position of CC2IE field.
	TIMs_DIER_CC2IE_Pos = 0x2
	// Bit mask of CC2IE field.
	TIMs_DIER_CC2IE_Msk = 0x4
	// Bit CC2IE.
	TIMs_DIER_CC2IE = 0x4
	// CCx interrupt disabled
	TIMs_DIER_CC2IE_Disabled = 0x0
	// CCx interrupt enabled
	TIMs_DIER_CC2IE_Enabled = 0x1
	// Position of CC1IE field.
	TIMs_DIER_CC1IE_Pos = 0x1
	// Bit mask of CC1IE field.
	TIMs_DIER_CC1IE_Msk = 0x2
	// Bit CC1IE.
	TIMs_DIER_CC1IE = 0x2
	// CCx interrupt disabled
	TIMs_DIER_CC1IE_Disabled = 0x0
	// CCx interrupt enabled
	TIMs_DIER_CC1IE_Enabled = 0x1
	// Position of UIE field.
	TIMs_DIER_UIE_Pos = 0x0
	// Bit mask of UIE field.
	TIMs_DIER_UIE_Msk = 0x1
	// Bit UIE.
	TIMs_DIER_UIE = 0x1
	// Update interrupt disabled
	TIMs_DIER_UIE_Disabled = 0x0
	// Update interrupt enabled
	TIMs_DIER_UIE_Enabled = 0x1

	// SR: status register
	// Position of CC4OF field.
	TIMs_SR_CC4OF_Pos = 0xc
	// Bit mask of CC4OF field.
	TIMs_SR_CC4OF_Msk = 0x1000
	// Bit CC4OF.
	TIMs_SR_CC4OF = 0x1000
	// The counter value has been captured in TIMx_CCRx register while CCxIF flag was already set
	TIMs_SR_CC4OF_Overcapture = 0x1
	// Clear flag
	TIMs_SR_CC4OF_Clear = 0x0
	// Position of CC3OF field.
	TIMs_SR_CC3OF_Pos = 0xb
	// Bit mask of CC3OF field.
	TIMs_SR_CC3OF_Msk = 0x800
	// Bit CC3OF.
	TIMs_SR_CC3OF = 0x800
	// The counter value has been captured in TIMx_CCRx register while CCxIF flag was already set
	TIMs_SR_CC3OF_Overcapture = 0x1
	// Clear flag
	TIMs_SR_CC3OF_Clear = 0x0
	// Position of CC2OF field.
	TIMs_SR_CC2OF_Pos = 0xa
	// Bit mask of CC2OF field.
	TIMs_SR_CC2OF_Msk = 0x400
	// Bit CC2OF.
	TIMs_SR_CC2OF = 0x400
	// The counter value has been captured in TIMx_CCRx register while CCxIF flag was already set
	TIMs_SR_CC2OF_Overcapture = 0x1
	// Clear flag
	TIMs_SR_CC2OF_Clear = 0x0
	// Position of CC1OF field.
	TIMs_SR_CC1OF_Pos = 0x9
	// Bit mask of CC1OF field.
	TIMs_SR_CC1OF_Msk = 0x200
	// Bit CC1OF.
	TIMs_SR_CC1OF = 0x200
	// The counter value has been captured in TIMx_CCRx register while CCxIF flag was already set
	TIMs_SR_CC1OF_Overcapture = 0x1
	// Clear flag
	TIMs_SR_CC1OF_Clear = 0x0
	// Position of TIF field.
	TIMs_SR_TIF_Pos = 0x6
	// Bit mask of TIF field.
	TIMs_SR_TIF_Msk = 0x40
	// Bit TIF.
	TIMs_SR_TIF = 0x40
	// No trigger event occurred
	TIMs_SR_TIF_NoTrigger = 0x0
	// Trigger interrupt pending
	TIMs_SR_TIF_Trigger = 0x1
	// Clear flag
	TIMs_SR_TIF_Clear = 0x0
	// Position of CC4IF field.
	TIMs_SR_CC4IF_Pos = 0x4
	// Bit mask of CC4IF field.
	TIMs_SR_CC4IF_Msk = 0x10
	// Bit CC4IF.
	TIMs_SR_CC4IF = 0x10
	// If CC1 is an output: The content of the counter TIMx_CNT matches the content of the TIMx_CCR1 register. If CC1 is an input: The counter value has been captured in TIMx_CCR1 register.
	TIMs_SR_CC4IF_Match = 0x1
	// Clear flag
	TIMs_SR_CC4IF_Clear = 0x0
	// Position of CC3IF field.
	TIMs_SR_CC3IF_Pos = 0x3
	// Bit mask of CC3IF field.
	TIMs_SR_CC3IF_Msk = 0x8
	// Bit CC3IF.
	TIMs_SR_CC3IF = 0x8
	// If CC1 is an output: The content of the counter TIMx_CNT matches the content of the TIMx_CCR1 register. If CC1 is an input: The counter value has been captured in TIMx_CCR1 register.
	TIMs_SR_CC3IF_Match = 0x1
	// Clear flag
	TIMs_SR_CC3IF_Clear = 0x0
	// Position of CC2IF field.
	TIMs_SR_CC2IF_Pos = 0x2
	// Bit mask of CC2IF field.
	TIMs_SR_CC2IF_Msk = 0x4
	// Bit CC2IF.
	TIMs_SR_CC2IF = 0x4
	// If CC1 is an output: The content of the counter TIMx_CNT matches the content of the TIMx_CCR1 register. If CC1 is an input: The counter value has been captured in TIMx_CCR1 register.
	TIMs_SR_CC2IF_Match = 0x1
	// Clear flag
	TIMs_SR_CC2IF_Clear = 0x0
	// Position of CC1IF field.
	TIMs_SR_CC1IF_Pos = 0x1
	// Bit mask of CC1IF field.
	TIMs_SR_CC1IF_Msk = 0x2
	// Bit CC1IF.
	TIMs_SR_CC1IF = 0x2
	// If CC1 is an output: The content of the counter TIMx_CNT matches the content of the TIMx_CCR1 register. If CC1 is an input: The counter value has been captured in TIMx_CCR1 register.
	TIMs_SR_CC1IF_Match = 0x1
	// Clear flag
	TIMs_SR_CC1IF_Clear = 0x0
	// Position of UIF field.
	TIMs_SR_UIF_Pos = 0x0
	// Bit mask of UIF field.
	TIMs_SR_UIF_Msk = 0x1
	// Bit UIF.
	TIMs_SR_UIF = 0x1
	// No update occurred
	TIMs_SR_UIF_Clear = 0x0
	// Update interrupt pending.
	TIMs_SR_UIF_UpdatePending = 0x1

	// EGR: event generation register
	// Position of TG field.
	TIMs_EGR_TG_Pos = 0x6
	// Bit mask of TG field.
	TIMs_EGR_TG_Msk = 0x40
	// Bit TG.
	TIMs_EGR_TG = 0x40
	// The TIF flag is set in TIMx_SR register. Related interrupt or DMA transfer can occur if enabled.
	TIMs_EGR_TG_Trigger = 0x1
	// Position of CC4G field.
	TIMs_EGR_CC4G_Pos = 0x4
	// Bit mask of CC4G field.
	TIMs_EGR_CC4G_Msk = 0x10
	// Bit CC4G.
	TIMs_EGR_CC4G = 0x10
	// If CC1 is an output: CC1IF flag is set, Corresponding interrupt or DMA request is sent if enabled. If CC1 is an input: The current value of the counter is captured in TIMx_CCR1 register.
	TIMs_EGR_CC4G_Trigger = 0x1
	// Position of CC3G field.
	TIMs_EGR_CC3G_Pos = 0x3
	// Bit mask of CC3G field.
	TIMs_EGR_CC3G_Msk = 0x8
	// Bit CC3G.
	TIMs_EGR_CC3G = 0x8
	// If CC1 is an output: CC1IF flag is set, Corresponding interrupt or DMA request is sent if enabled. If CC1 is an input: The current value of the counter is captured in TIMx_CCR1 register.
	TIMs_EGR_CC3G_Trigger = 0x1
	// Position of CC2G field.
	TIMs_EGR_CC2G_Pos = 0x2
	// Bit mask of CC2G field.
	TIMs_EGR_CC2G_Msk = 0x4
	// Bit CC2G.
	TIMs_EGR_CC2G = 0x4
	// If CC1 is an output: CC1IF flag is set, Corresponding interrupt or DMA request is sent if enabled. If CC1 is an input: The current value of the counter is captured in TIMx_CCR1 register.
	TIMs_EGR_CC2G_Trigger = 0x1
	// Position of CC1G field.
	TIMs_EGR_CC1G_Pos = 0x1
	// Bit mask of CC1G field.
	TIMs_EGR_CC1G_Msk = 0x2
	// Bit CC1G.
	TIMs_EGR_CC1G = 0x2
	// If CC1 is an output: CC1IF flag is set, Corresponding interrupt or DMA request is sent if enabled. If CC1 is an input: The current value of the counter is captured in TIMx_CCR1 register.
	TIMs_EGR_CC1G_Trigger = 0x1
	// Position of UG field.
	TIMs_EGR_UG_Pos = 0x0
	// Bit mask of UG field.
	TIMs_EGR_UG_Msk = 0x1
	// Bit UG.
	TIMs_EGR_UG = 0x1
	// Re-initializes the timer counter and generates an update of the registers.
	TIMs_EGR_UG_Update = 0x1

	// CCMR1_Output: capture/compare mode register 1 (output mode)
	// Position of CC1S field.
	TIMs_CCMR1_Output_CC1S_Pos = 0x0
	// Bit mask of CC1S field.
	TIMs_CCMR1_Output_CC1S_Msk = 0x3
	// CC1 channel is configured as output
	TIMs_CCMR1_Output_CC1S_Output = 0x0
	// Position of OC1FE field.
	TIMs_CCMR1_Output_OC1FE_Pos = 0x2
	// Bit mask of OC1FE field.
	TIMs_CCMR1_Output_OC1FE_Msk = 0x4
	// Bit OC1FE.
	TIMs_CCMR1_Output_OC1FE = 0x4
	// Position of OC1PE field.
	TIMs_CCMR1_Output_OC1PE_Pos = 0x3
	// Bit mask of OC1PE field.
	TIMs_CCMR1_Output_OC1PE_Msk = 0x8
	// Bit OC1PE.
	TIMs_CCMR1_Output_OC1PE = 0x8
	// Preload register on CCR1 disabled. New values written to CCR1 are taken into account immediately
	TIMs_CCMR1_Output_OC1PE_Disabled = 0x0
	// Preload register on CCR1 enabled. Preload value is loaded into active register on each update event
	TIMs_CCMR1_Output_OC1PE_Enabled = 0x1
	// Position of OC1M field.
	TIMs_CCMR1_Output_OC1M_Pos = 0x4
	// Bit mask of OC1M field.
	TIMs_CCMR1_Output_OC1M_Msk = 0x70
	// The comparison between the output compare register TIMx_CCRy and the counter TIMx_CNT has no effect on the outputs
	TIMs_CCMR1_Output_OC1M_Frozen = 0x0
	// Set channel to active level on match. OCyREF signal is forced high when the counter matches the capture/compare register
	TIMs_CCMR1_Output_OC1M_ActiveOnMatch = 0x1
	// Set channel to inactive level on match. OCyREF signal is forced low when the counter matches the capture/compare register
	TIMs_CCMR1_Output_OC1M_InactiveOnMatch = 0x2
	// OCyREF toggles when TIMx_CNT=TIMx_CCRy
	TIMs_CCMR1_Output_OC1M_Toggle = 0x3
	// OCyREF is forced low
	TIMs_CCMR1_Output_OC1M_ForceInactive = 0x4
	// OCyREF is forced high
	TIMs_CCMR1_Output_OC1M_ForceActive = 0x5
	// In upcounting, channel is active as long as TIMx_CNT<TIMx_CCRy else inactive. In downcounting, channel is inactive as long as TIMx_CNT>TIMx_CCRy else active
	TIMs_CCMR1_Output_OC1M_PwmMode1 = 0x6
	// Inversely to PwmMode1
	TIMs_CCMR1_Output_OC1M_PwmMode2 = 0x7
	// Position of OC1CE field.
	TIMs_CCMR1_Output_OC1CE_Pos = 0x7
	// Bit mask of OC1CE field.
	TIMs_CCMR1_Output_OC1CE_Msk = 0x80
	// Bit OC1CE.
	TIMs_CCMR1_Output_OC1CE = 0x80
	// Position of CC2S field.
	TIMs_CCMR1_Output_CC2S_Pos = 0x8
	// Bit mask of CC2S field.
	TIMs_CCMR1_Output_CC2S_Msk = 0x300
	// CC2 channel is configured as output
	TIMs_CCMR1_Output_CC2S_Output = 0x0
	// Position of OC2FE field.
	TIMs_CCMR1_Output_OC2FE_Pos = 0xa
	// Bit mask of OC2FE field.
	TIMs_CCMR1_Output_OC2FE_Msk = 0x400
	// Bit OC2FE.
	TIMs_CCMR1_Output_OC2FE = 0x400
	// Position of OC2PE field.
	TIMs_CCMR1_Output_OC2PE_Pos = 0xb
	// Bit mask of OC2PE field.
	TIMs_CCMR1_Output_OC2PE_Msk = 0x800
	// Bit OC2PE.
	TIMs_CCMR1_Output_OC2PE = 0x800
	// Preload register on CCR2 disabled. New values written to CCR2 are taken into account immediately
	TIMs_CCMR1_Output_OC2PE_Disabled = 0x0
	// Preload register on CCR2 enabled. Preload value is loaded into active register on each update event
	TIMs_CCMR1_Output_OC2PE_Enabled = 0x1
	// Position of OC2M field.
	TIMs_CCMR1_Output_OC2M_Pos = 0xc
	// Bit mask of OC2M field.
	TIMs_CCMR1_Output_OC2M_Msk = 0x7000
	// The comparison between the output compare register TIMx_CCRy and the counter TIMx_CNT has no effect on the outputs
	TIMs_CCMR1_Output_OC2M_Frozen = 0x0
	// Set channel to active level on match. OCyREF signal is forced high when the counter matches the capture/compare register
	TIMs_CCMR1_Output_OC2M_ActiveOnMatch = 0x1
	// Set channel to inactive level on match. OCyREF signal is forced low when the counter matches the capture/compare register
	TIMs_CCMR1_Output_OC2M_InactiveOnMatch = 0x2
	// OCyREF toggles when TIMx_CNT=TIMx_CCRy
	TIMs_CCMR1_Output_OC2M_Toggle = 0x3
	// OCyREF is forced low
	TIMs_CCMR1_Output_OC2M_ForceInactive = 0x4
	// OCyREF is forced high
	TIMs_CCMR1_Output_OC2M_ForceActive = 0x5
	// In upcounting, channel is active as long as TIMx_CNT<TIMx_CCRy else inactive. In downcounting, channel is inactive as long as TIMx_CNT>TIMx_CCRy else active
	TIMs_CCMR1_Output_OC2M_PwmMode1 = 0x6
	// Inversely to PwmMode1
	TIMs_CCMR1_Output_OC2M_PwmMode2 = 0x7
	// Position of OC2CE field.
	TIMs_CCMR1_Output_OC2CE_Pos = 0xf
	// Bit mask of OC2CE field.
	TIMs_CCMR1_Output_OC2CE_Msk = 0x8000
	// Bit OC2CE.
	TIMs_CCMR1_Output_OC2CE = 0x8000
	// Position of OC1M_3 field.
	TIMs_CCMR1_Output_OC1M_3_Pos = 0x10
	// Bit mask of OC1M_3 field.
	TIMs_CCMR1_Output_OC1M_3_Msk = 0x10000
	// Bit OC1M_3.
	TIMs_CCMR1_Output_OC1M_3 = 0x10000
	// Position of OC2M_3 field.
	TIMs_CCMR1_Output_OC2M_3_Pos = 0x18
	// Bit mask of OC2M_3 field.
	TIMs_CCMR1_Output_OC2M_3_Msk = 0x1000000
	// Bit OC2M_3.
	TIMs_CCMR1_Output_OC2M_3 = 0x1000000

	// CCMR1_Input: capture/compare mode register 1 (input mode)
	// Position of IC2F field.
	TIMs_CCMR1_Input_IC2F_Pos = 0xc
	// Bit mask of IC2F field.
	TIMs_CCMR1_Input_IC2F_Msk = 0xf000
	// Position of IC2PSC field.
	TIMs_CCMR1_Input_IC2PSC_Pos = 0xa
	// Bit mask of IC2PSC field.
	TIMs_CCMR1_Input_IC2PSC_Msk = 0xc00
	// Position of CC2S field.
	TIMs_CCMR1_Input_CC2S_Pos = 0x8
	// Bit mask of CC2S field.
	TIMs_CCMR1_Input_CC2S_Msk = 0x300
	// CC2 channel is configured as input, IC2 is mapped on TI2
	TIMs_CCMR1_Input_CC2S_TI2 = 0x1
	// CC2 channel is configured as input, IC2 is mapped on TI1
	TIMs_CCMR1_Input_CC2S_TI1 = 0x2
	// CC2 channel is configured as input, IC2 is mapped on TRC
	TIMs_CCMR1_Input_CC2S_TRC = 0x3
	// Position of IC1F field.
	TIMs_CCMR1_Input_IC1F_Pos = 0x4
	// Bit mask of IC1F field.
	TIMs_CCMR1_Input_IC1F_Msk = 0xf0
	// No filter, sampling is done at fDTS
	TIMs_CCMR1_Input_IC1F_NoFilter = 0x0
	// fSAMPLING=fCK_INT, N=2
	TIMs_CCMR1_Input_IC1F_FCK_INT_N2 = 0x1
	// fSAMPLING=fCK_INT, N=4
	TIMs_CCMR1_Input_IC1F_FCK_INT_N4 = 0x2
	// fSAMPLING=fCK_INT, N=8
	TIMs_CCMR1_Input_IC1F_FCK_INT_N8 = 0x3
	// fSAMPLING=fDTS/2, N=6
	TIMs_CCMR1_Input_IC1F_FDTS_Div2_N6 = 0x4
	// fSAMPLING=fDTS/2, N=8
	TIMs_CCMR1_Input_IC1F_FDTS_Div2_N8 = 0x5
	// fSAMPLING=fDTS/4, N=6
	TIMs_CCMR1_Input_IC1F_FDTS_Div4_N6 = 0x6
	// fSAMPLING=fDTS/4, N=8
	TIMs_CCMR1_Input_IC1F_FDTS_Div4_N8 = 0x7
	// fSAMPLING=fDTS/8, N=6
	TIMs_CCMR1_Input_IC1F_FDTS_Div8_N6 = 0x8
	// fSAMPLING=fDTS/8, N=8
	TIMs_CCMR1_Input_IC1F_FDTS_Div8_N8 = 0x9
	// fSAMPLING=fDTS/16, N=5
	TIMs_CCMR1_Input_IC1F_FDTS_Div16_N5 = 0xa
	// fSAMPLING=fDTS/16, N=6
	TIMs_CCMR1_Input_IC1F_FDTS_Div16_N6 = 0xb
	// fSAMPLING=fDTS/16, N=8
	TIMs_CCMR1_Input_IC1F_FDTS_Div16_N8 = 0xc
	// fSAMPLING=fDTS/32, N=5
	TIMs_CCMR1_Input_IC1F_FDTS_Div32_N5 = 0xd
	// fSAMPLING=fDTS/32, N=6
	TIMs_CCMR1_Input_IC1F_FDTS_Div32_N6 = 0xe
	// fSAMPLING=fDTS/32, N=8
	TIMs_CCMR1_Input_IC1F_FDTS_Div32_N8 = 0xf
	// Position of IC1PSC field.
	TIMs_CCMR1_Input_IC1PSC_Pos = 0x2
	// Bit mask of IC1PSC field.
	TIMs_CCMR1_Input_IC1PSC_Msk = 0xc
	// Position of CC1S field.
	TIMs_CCMR1_Input_CC1S_Pos = 0x0
	// Bit mask of CC1S field.
	TIMs_CCMR1_Input_CC1S_Msk = 0x3
	// CC1 channel is configured as input, IC1 is mapped on TI1
	TIMs_CCMR1_Input_CC1S_TI1 = 0x1
	// CC1 channel is configured as input, IC1 is mapped on TI2
	TIMs_CCMR1_Input_CC1S_TI2 = 0x2
	// CC1 channel is configured as input, IC1 is mapped on TRC
	TIMs_CCMR1_Input_CC1S_TRC = 0x3

	// CCMR2_Output: capture/compare mode register 2 (output mode)
	// Position of CC3S field.
	TIMs_CCMR2_Output_CC3S_Pos = 0x0
	// Bit mask of CC3S field.
	TIMs_CCMR2_Output_CC3S_Msk = 0x3
	// CC3 channel is configured as output
	TIMs_CCMR2_Output_CC3S_Output = 0x0
	// Position of OC3FE field.
	TIMs_CCMR2_Output_OC3FE_Pos = 0x2
	// Bit mask of OC3FE field.
	TIMs_CCMR2_Output_OC3FE_Msk = 0x4
	// Bit OC3FE.
	TIMs_CCMR2_Output_OC3FE = 0x4
	// Position of OC3PE field.
	TIMs_CCMR2_Output_OC3PE_Pos = 0x3
	// Bit mask of OC3PE field.
	TIMs_CCMR2_Output_OC3PE_Msk = 0x8
	// Bit OC3PE.
	TIMs_CCMR2_Output_OC3PE = 0x8
	// Preload register on CCR3 disabled. New values written to CCR3 are taken into account immediately
	TIMs_CCMR2_Output_OC3PE_Disabled = 0x0
	// Preload register on CCR3 enabled. Preload value is loaded into active register on each update event
	TIMs_CCMR2_Output_OC3PE_Enabled = 0x1
	// Position of OC3M field.
	TIMs_CCMR2_Output_OC3M_Pos = 0x4
	// Bit mask of OC3M field.
	TIMs_CCMR2_Output_OC3M_Msk = 0x70
	// The comparison between the output compare register TIMx_CCRy and the counter TIMx_CNT has no effect on the outputs
	TIMs_CCMR2_Output_OC3M_Frozen = 0x0
	// Set channel to active level on match. OCyREF signal is forced high when the counter matches the capture/compare register
	TIMs_CCMR2_Output_OC3M_ActiveOnMatch = 0x1
	// Set channel to inactive level on match. OCyREF signal is forced low when the counter matches the capture/compare register
	TIMs_CCMR2_Output_OC3M_InactiveOnMatch = 0x2
	// OCyREF toggles when TIMx_CNT=TIMx_CCRy
	TIMs_CCMR2_Output_OC3M_Toggle = 0x3
	// OCyREF is forced low
	TIMs_CCMR2_Output_OC3M_ForceInactive = 0x4
	// OCyREF is forced high
	TIMs_CCMR2_Output_OC3M_ForceActive = 0x5
	// In upcounting, channel is active as long as TIMx_CNT<TIMx_CCRy else inactive. In downcounting, channel is inactive as long as TIMx_CNT>TIMx_CCRy else active
	TIMs_CCMR2_Output_OC3M_PwmMode1 = 0x6
	// Inversely to PwmMode1
	TIMs_CCMR2_Output_OC3M_PwmMode2 = 0x7
	// Position of OC3CE field.
	TIMs_CCMR2_Output_OC3CE_Pos = 0x7
	// Bit mask of OC3CE field.
	TIMs_CCMR2_Output_OC3CE_Msk = 0x80
	// Bit OC3CE.
	TIMs_CCMR2_Output_OC3CE = 0x80
	// Position of CC4S field.
	TIMs_CCMR2_Output_CC4S_Pos = 0x8
	// Bit mask of CC4S field.
	TIMs_CCMR2_Output_CC4S_Msk = 0x300
	// CC4 channel is configured as output
	TIMs_CCMR2_Output_CC4S_Output = 0x0
	// Position of OC4FE field.
	TIMs_CCMR2_Output_OC4FE_Pos = 0xa
	// Bit mask of OC4FE field.
	TIMs_CCMR2_Output_OC4FE_Msk = 0x400
	// Bit OC4FE.
	TIMs_CCMR2_Output_OC4FE = 0x400
	// Position of OC4PE field.
	TIMs_CCMR2_Output_OC4PE_Pos = 0xb
	// Bit mask of OC4PE field.
	TIMs_CCMR2_Output_OC4PE_Msk = 0x800
	// Bit OC4PE.
	TIMs_CCMR2_Output_OC4PE = 0x800
	// Preload register on CCR4 disabled. New values written to CCR4 are taken into account immediately
	TIMs_CCMR2_Output_OC4PE_Disabled = 0x0
	// Preload register on CCR4 enabled. Preload value is loaded into active register on each update event
	TIMs_CCMR2_Output_OC4PE_Enabled = 0x1
	// Position of OC4M field.
	TIMs_CCMR2_Output_OC4M_Pos = 0xc
	// Bit mask of OC4M field.
	TIMs_CCMR2_Output_OC4M_Msk = 0x7000
	// The comparison between the output compare register TIMx_CCRy and the counter TIMx_CNT has no effect on the outputs
	TIMs_CCMR2_Output_OC4M_Frozen = 0x0
	// Set channel to active level on match. OCyREF signal is forced high when the counter matches the capture/compare register
	TIMs_CCMR2_Output_OC4M_ActiveOnMatch = 0x1
	// Set channel to inactive level on match. OCyREF signal is forced low when the counter matches the capture/compare register
	TIMs_CCMR2_Output_OC4M_InactiveOnMatch = 0x2
	// OCyREF toggles when TIMx_CNT=TIMx_CCRy
	TIMs_CCMR2_Output_OC4M_Toggle = 0x3
	// OCyREF is forced low
	TIMs_CCMR2_Output_OC4M_ForceInactive = 0x4
	// OCyREF is forced high
	TIMs_CCMR2_Output_OC4M_ForceActive = 0x5
	// In upcounting, channel is active as long as TIMx_CNT<TIMx_CCRy else inactive. In downcounting, channel is inactive as long as TIMx_CNT>TIMx_CCRy else active
	TIMs_CCMR2_Output_OC4M_PwmMode1 = 0x6
	// Inversely to PwmMode1
	TIMs_CCMR2_Output_OC4M_PwmMode2 = 0x7
	// Position of OC4CE field.
	TIMs_CCMR2_Output_OC4CE_Pos = 0xf
	// Bit mask of OC4CE field.
	TIMs_CCMR2_Output_OC4CE_Msk = 0x8000
	// Bit OC4CE.
	TIMs_CCMR2_Output_OC4CE = 0x8000
	// Position of OC3M_3 field.
	TIMs_CCMR2_Output_OC3M_3_Pos = 0x10
	// Bit mask of OC3M_3 field.
	TIMs_CCMR2_Output_OC3M_3_Msk = 0x10000
	// Bit OC3M_3.
	TIMs_CCMR2_Output_OC3M_3 = 0x10000
	// Position of OC4M_3 field.
	TIMs_CCMR2_Output_OC4M_3_Pos = 0x18
	// Bit mask of OC4M_3 field.
	TIMs_CCMR2_Output_OC4M_3_Msk = 0x1000000
	// Bit OC4M_3.
	TIMs_CCMR2_Output_OC4M_3 = 0x1000000

	// CCMR2_Input: capture/compare mode register 2 (input mode)
	// Position of IC4F field.
	TIMs_CCMR2_Input_IC4F_Pos = 0xc
	// Bit mask of IC4F field.
	TIMs_CCMR2_Input_IC4F_Msk = 0xf000
	// Position of IC4PSC field.
	TIMs_CCMR2_Input_IC4PSC_Pos = 0xa
	// Bit mask of IC4PSC field.
	TIMs_CCMR2_Input_IC4PSC_Msk = 0xc00
	// Position of CC4S field.
	TIMs_CCMR2_Input_CC4S_Pos = 0x8
	// Bit mask of CC4S field.
	TIMs_CCMR2_Input_CC4S_Msk = 0x300
	// CC4 channel is configured as input, IC4 is mapped on TI4
	TIMs_CCMR2_Input_CC4S_TI4 = 0x1
	// CC4 channel is configured as input, IC4 is mapped on TI3
	TIMs_CCMR2_Input_CC4S_TI3 = 0x2
	// CC4 channel is configured as input, IC4 is mapped on TRC
	TIMs_CCMR2_Input_CC4S_TRC = 0x3
	// Position of IC3F field.
	TIMs_CCMR2_Input_IC3F_Pos = 0x4
	// Bit mask of IC3F field.
	TIMs_CCMR2_Input_IC3F_Msk = 0xf0
	// Position of IC3PSC field.
	TIMs_CCMR2_Input_IC3PSC_Pos = 0x2
	// Bit mask of IC3PSC field.
	TIMs_CCMR2_Input_IC3PSC_Msk = 0xc
	// Position of CC3S field.
	TIMs_CCMR2_Input_CC3S_Pos = 0x0
	// Bit mask of CC3S field.
	TIMs_CCMR2_Input_CC3S_Msk = 0x3
	// CC3 channel is configured as input, IC3 is mapped on TI3
	TIMs_CCMR2_Input_CC3S_TI3 = 0x1
	// CC3 channel is configured as input, IC3 is mapped on TI4
	TIMs_CCMR2_Input_CC3S_TI4 = 0x2
	// CC3 channel is configured as input, IC3 is mapped on TRC
	TIMs_CCMR2_Input_CC3S_TRC = 0x3

	// CCER: capture/compare enable register
	// Position of CC1E field.
	TIMs_CCER_CC1E_Pos = 0x0
	// Bit mask of CC1E field.
	TIMs_CCER_CC1E_Msk = 0x1
	// Bit CC1E.
	TIMs_CCER_CC1E = 0x1
	// Position of CC1P field.
	TIMs_CCER_CC1P_Pos = 0x1
	// Bit mask of CC1P field.
	TIMs_CCER_CC1P_Msk = 0x2
	// Bit CC1P.
	TIMs_CCER_CC1P = 0x2
	// Position of CC1NP field.
	TIMs_CCER_CC1NP_Pos = 0x3
	// Bit mask of CC1NP field.
	TIMs_CCER_CC1NP_Msk = 0x8
	// Bit CC1NP.
	TIMs_CCER_CC1NP = 0x8
	// Position of CC2E field.
	TIMs_CCER_CC2E_Pos = 0x4
	// Bit mask of CC2E field.
	TIMs_CCER_CC2E_Msk = 0x10
	// Bit CC2E.
	TIMs_CCER_CC2E = 0x10
	// Position of CC2P field.
	TIMs_CCER_CC2P_Pos = 0x5
	// Bit mask of CC2P field.
	TIMs_CCER_CC2P_Msk = 0x20
	// Bit CC2P.
	TIMs_CCER_CC2P = 0x20
	// Position of CC2NP field.
	TIMs_CCER_CC2NP_Pos = 0x7
	// Bit mask of CC2NP field.
	TIMs_CCER_CC2NP_Msk = 0x80
	// Bit CC2NP.
	TIMs_CCER_CC2NP = 0x80
	// Position of CC3E field.
	TIMs_CCER_CC3E_Pos = 0x8
	// Bit mask of CC3E field.
	TIMs_CCER_CC3E_Msk = 0x100
	// Bit CC3E.
	TIMs_CCER_CC3E = 0x100
	// Position of CC3P field.
	TIMs_CCER_CC3P_Pos = 0x9
	// Bit mask of CC3P field.
	TIMs_CCER_CC3P_Msk = 0x200
	// Bit CC3P.
	TIMs_CCER_CC3P = 0x200
	// Position of CC3NP field.
	TIMs_CCER_CC3NP_Pos = 0xb
	// Bit mask of CC3NP field.
	TIMs_CCER_CC3NP_Msk = 0x800
	// Bit CC3NP.
	TIMs_CCER_CC3NP = 0x800
	// Position of CC4E field.
	TIMs_CCER_CC4E_Pos = 0xc
	// Bit mask of CC4E field.
	TIMs_CCER_CC4E_Msk = 0x1000
	// Bit CC4E.
	TIMs_CCER_CC4E = 0x1000
	// Position of CC4P field.
	TIMs_CCER_CC4P_Pos = 0xd
	// Bit mask of CC4P field.
	TIMs_CCER_CC4P_Msk = 0x2000
	// Bit CC4P.
	TIMs_CCER_CC4P = 0x2000
	// Position of CC4NP field.
	TIMs_CCER_CC4NP_Pos = 0xf
	// Bit mask of CC4NP field.
	TIMs_CCER_CC4NP_Msk = 0x8000
	// Bit CC4NP.
	TIMs_CCER_CC4NP = 0x8000

	// CNT: counter
	// Position of CNT field.
	TIMs_CNT_CNT_Pos = 0x0
	// Bit mask of CNT field.
	TIMs_CNT_CNT_Msk = 0xffffffff

	// PSC: prescaler
	// Position of PSC field.
	TIMs_PSC_PSC_Pos = 0x0
	// Bit mask of PSC field.
	TIMs_PSC_PSC_Msk = 0xffff

	// ARR: auto-reload register
	// Position of ARR field.
	TIMs_ARR_ARR_Pos = 0x0
	// Bit mask of ARR field.
	TIMs_ARR_ARR_Msk = 0xffffffff

	// CCR1: capture/compare register 1
	// Position of CCR field.
	TIMs_CCR_CCR_Pos = 0x0
	// Bit mask of CCR field.
	TIMs_CCR_CCR_Msk = 0xffffffff

	// DCR: DMA control register
	// Position of DBL field.
	TIMs_DCR_DBL_Pos = 0x8
	// Bit mask of DBL field.
	TIMs_DCR_DBL_Msk = 0x1f00
	// Position of DBA field.
	TIMs_DCR_DBA_Pos = 0x0
	// Bit mask of DBA field.
	TIMs_DCR_DBA_Msk = 0x1f

	// DMAR: DMA address for full transfer
	// Position of DMAB field.
	TIMs_DMAR_DMAB_Pos = 0x0
	// Bit mask of DMAB field.
	TIMs_DMAR_DMAB_Msk = 0xffff
)

// Bitfields for USART1: Universal synchronous asynchronous receiver transmitter
const (
	// CR1: Control register 1
	// Position of EOBIE field.
	USART_CR1_EOBIE_Pos = 0x1b
	// Bit mask of EOBIE field.
	USART_CR1_EOBIE_Msk = 0x8000000
	// Bit EOBIE.
	USART_CR1_EOBIE = 0x8000000
	// Interrupt is inhibited
	USART_CR1_EOBIE_Disabled = 0x0
	// A USART interrupt is generated when the EOBF flag is set in the ISR register
	USART_CR1_EOBIE_Enabled = 0x1
	// Position of RTOIE field.
	USART_CR1_RTOIE_Pos = 0x1a
	// Bit mask of RTOIE field.
	USART_CR1_RTOIE_Msk = 0x4000000
	// Bit RTOIE.
	USART_CR1_RTOIE = 0x4000000
	// Interrupt is inhibited
	USART_CR1_RTOIE_Disabled = 0x0
	// An USART interrupt is generated when the RTOF bit is set in the ISR register
	USART_CR1_RTOIE_Enabled = 0x1
	// Position of DEAT field.
	USART_CR1_DEAT_Pos = 0x15
	// Bit mask of DEAT field.
	USART_CR1_DEAT_Msk = 0x3e00000
	// Position of DEDT field.
	USART_CR1_DEDT_Pos = 0x10
	// Bit mask of DEDT field.
	USART_CR1_DEDT_Msk = 0x1f0000
	// Position of OVER8 field.
	USART_CR1_OVER8_Pos = 0xf
	// Bit mask of OVER8 field.
	USART_CR1_OVER8_Msk = 0x8000
	// Bit OVER8.
	USART_CR1_OVER8 = 0x8000
	// Oversampling by 16
	USART_CR1_OVER8_Oversampling16 = 0x0
	// Oversampling by 8
	USART_CR1_OVER8_Oversampling8 = 0x1
	// Position of CMIE field.
	USART_CR1_CMIE_Pos = 0xe
	// Bit mask of CMIE field.
	USART_CR1_CMIE_Msk = 0x4000
	// Bit CMIE.
	USART_CR1_CMIE = 0x4000
	// Interrupt is disabled
	USART_CR1_CMIE_Disabled = 0x0
	// Interrupt is generated when the CMF bit is set in the ISR register
	USART_CR1_CMIE_Enabled = 0x1
	// Position of MME field.
	USART_CR1_MME_Pos = 0xd
	// Bit mask of MME field.
	USART_CR1_MME_Msk = 0x2000
	// Bit MME.
	USART_CR1_MME = 0x2000
	// Receiver in active mode permanently
	USART_CR1_MME_Disabled = 0x0
	// Receiver can switch between mute mode and active mode
	USART_CR1_MME_Enabled = 0x1
	// Position of M field.
	USART_CR1_M_Pos = 0xc
	// Bit mask of M field.
	USART_CR1_M_Msk = 0x1000
	// Bit M.
	USART_CR1_M = 0x1000
	// 1 start bit, 8 data bits, n stop bits
	USART_CR1_M_Bit8 = 0x0
	// 1 start bit, 9 data bits, n stop bits
	USART_CR1_M_Bit9 = 0x1
	// Position of WAKE field.
	USART_CR1_WAKE_Pos = 0xb
	// Bit mask of WAKE field.
	USART_CR1_WAKE_Msk = 0x800
	// Bit WAKE.
	USART_CR1_WAKE = 0x800
	// Idle line
	USART_CR1_WAKE_Idle = 0x0
	// Address mask
	USART_CR1_WAKE_Address = 0x1
	// Position of PCE field.
	USART_CR1_PCE_Pos = 0xa
	// Bit mask of PCE field.
	USART_CR1_PCE_Msk = 0x400
	// Bit PCE.
	USART_CR1_PCE = 0x400
	// Parity control disabled
	USART_CR1_PCE_Disabled = 0x0
	// Parity control enabled
	USART_CR1_PCE_Enabled = 0x1
	// Position of PS field.
	USART_CR1_PS_Pos = 0x9
	// Bit mask of PS field.
	USART_CR1_PS_Msk = 0x200
	// Bit PS.
	USART_CR1_PS = 0x200
	// Even parity
	USART_CR1_PS_Even = 0x0
	// Odd parity
	USART_CR1_PS_Odd = 0x1
	// Position of PEIE field.
	USART_CR1_PEIE_Pos = 0x8
	// Bit mask of PEIE field.
	USART_CR1_PEIE_Msk = 0x100
	// Bit PEIE.
	USART_CR1_PEIE = 0x100
	// Interrupt is disabled
	USART_CR1_PEIE_Disabled = 0x0
	// Interrupt is generated whenever PE=1 in the ISR register
	USART_CR1_PEIE_Enabled = 0x1
	// Position of TXEIE field.
	USART_CR1_TXEIE_Pos = 0x7
	// Bit mask of TXEIE field.
	USART_CR1_TXEIE_Msk = 0x80
	// Bit TXEIE.
	USART_CR1_TXEIE = 0x80
	// Interrupt is disabled
	USART_CR1_TXEIE_Disabled = 0x0
	// Interrupt is generated whenever TXE=1 in the ISR register
	USART_CR1_TXEIE_Enabled = 0x1
	// Position of TCIE field.
	USART_CR1_TCIE_Pos = 0x6
	// Bit mask of TCIE field.
	USART_CR1_TCIE_Msk = 0x40
	// Bit TCIE.
	USART_CR1_TCIE = 0x40
	// Interrupt is disabled
	USART_CR1_TCIE_Disabled = 0x0
	// Interrupt is generated whenever TC=1 in the ISR register
	USART_CR1_TCIE_Enabled = 0x1
	// Position of RXNEIE field.
	USART_CR1_RXNEIE_Pos = 0x5
	// Bit mask of RXNEIE field.
	USART_CR1_RXNEIE_Msk = 0x20
	// Bit RXNEIE.
	USART_CR1_RXNEIE = 0x20
	// Interrupt is disabled
	USART_CR1_RXNEIE_Disabled = 0x0
	// Interrupt is generated whenever ORE=1 or RXNE=1 in the ISR register
	USART_CR1_RXNEIE_Enabled = 0x1
	// Position of IDLEIE field.
	USART_CR1_IDLEIE_Pos = 0x4
	// Bit mask of IDLEIE field.
	USART_CR1_IDLEIE_Msk = 0x10
	// Bit IDLEIE.
	USART_CR1_IDLEIE = 0x10
	// Interrupt is disabled
	USART_CR1_IDLEIE_Disabled = 0x0
	// Interrupt is generated whenever IDLE=1 in the ISR register
	USART_CR1_IDLEIE_Enabled = 0x1
	// Position of TE field.
	USART_CR1_TE_Pos = 0x3
	// Bit mask of TE field.
	USART_CR1_TE_Msk = 0x8
	// Bit TE.
	USART_CR1_TE = 0x8
	// Transmitter is disabled
	USART_CR1_TE_Disabled = 0x0
	// Transmitter is enabled
	USART_CR1_TE_Enabled = 0x1
	// Position of RE field.
	USART_CR1_RE_Pos = 0x2
	// Bit mask of RE field.
	USART_CR1_RE_Msk = 0x4
	// Bit RE.
	USART_CR1_RE = 0x4
	// Receiver is disabled
	USART_CR1_RE_Disabled = 0x0
	// Receiver is enabled
	USART_CR1_RE_Enabled = 0x1
	// Position of UESM field.
	USART_CR1_UESM_Pos = 0x1
	// Bit mask of UESM field.
	USART_CR1_UESM_Msk = 0x2
	// Bit UESM.
	USART_CR1_UESM = 0x2
	// USART not able to wake up the MCU from Stop mode
	USART_CR1_UESM_Disabled = 0x0
	// USART able to wake up the MCU from Stop mode
	USART_CR1_UESM_Enabled = 0x1
	// Position of UE field.
	USART_CR1_UE_Pos = 0x0
	// Bit mask of UE field.
	USART_CR1_UE_Msk = 0x1
	// Bit UE.
	USART_CR1_UE = 0x1
	// UART is disabled
	USART_CR1_UE_Disabled = 0x0
	// UART is enabled
	USART_CR1_UE_Enabled = 0x1

	// CR2: Control register 2
	// Position of RTOEN field.
	USART_CR2_RTOEN_Pos = 0x17
	// Bit mask of RTOEN field.
	USART_CR2_RTOEN_Msk = 0x800000
	// Bit RTOEN.
	USART_CR2_RTOEN = 0x800000
	// Receiver timeout feature disabled
	USART_CR2_RTOEN_Disabled = 0x0
	// Receiver timeout feature enabled
	USART_CR2_RTOEN_Enabled = 0x1
	// Position of ABRMOD field.
	USART_CR2_ABRMOD_Pos = 0x15
	// Bit mask of ABRMOD field.
	USART_CR2_ABRMOD_Msk = 0x600000
	// Measurement of the start bit is used to detect the baud rate
	USART_CR2_ABRMOD_Start = 0x0
	// Falling edge to falling edge measurement
	USART_CR2_ABRMOD_Edge = 0x1
	// 0x7F frame detection
	USART_CR2_ABRMOD_Frame7F = 0x2
	// 0x55 frame detection
	USART_CR2_ABRMOD_Frame55 = 0x3
	// Position of ABREN field.
	USART_CR2_ABREN_Pos = 0x14
	// Bit mask of ABREN field.
	USART_CR2_ABREN_Msk = 0x100000
	// Bit ABREN.
	USART_CR2_ABREN = 0x100000
	// Auto baud rate detection is disabled
	USART_CR2_ABREN_Disabled = 0x0
	// Auto baud rate detection is enabled
	USART_CR2_ABREN_Enabled = 0x1
	// Position of MSBFIRST field.
	USART_CR2_MSBFIRST_Pos = 0x13
	// Bit mask of MSBFIRST field.
	USART_CR2_MSBFIRST_Msk = 0x80000
	// Bit MSBFIRST.
	USART_CR2_MSBFIRST = 0x80000
	// data is transmitted/received with data bit 0 first, following the start bit
	USART_CR2_MSBFIRST_LSB = 0x0
	// data is transmitted/received with MSB (bit 7/8/9) first, following the start bit
	USART_CR2_MSBFIRST_MSB = 0x1
	// Position of DATAINV field.
	USART_CR2_DATAINV_Pos = 0x12
	// Bit mask of DATAINV field.
	USART_CR2_DATAINV_Msk = 0x40000
	// Bit DATAINV.
	USART_CR2_DATAINV = 0x40000
	// Logical data from the data register are send/received in positive/direct logic
	USART_CR2_DATAINV_Positive = 0x0
	// Logical data from the data register are send/received in negative/inverse logic
	USART_CR2_DATAINV_Negative = 0x1
	// Position of TXINV field.
	USART_CR2_TXINV_Pos = 0x11
	// Bit mask of TXINV field.
	USART_CR2_TXINV_Msk = 0x20000
	// Bit TXINV.
	USART_CR2_TXINV = 0x20000
	// TX pin signal works using the standard logic levels
	USART_CR2_TXINV_Standard = 0x0
	// TX pin signal values are inverted
	USART_CR2_TXINV_Inverted = 0x1
	// Position of RXINV field.
	USART_CR2_RXINV_Pos = 0x10
	// Bit mask of RXINV field.
	USART_CR2_RXINV_Msk = 0x10000
	// Bit RXINV.
	USART_CR2_RXINV = 0x10000
	// RX pin signal works using the standard logic levels
	USART_CR2_RXINV_Standard = 0x0
	// RX pin signal values are inverted
	USART_CR2_RXINV_Inverted = 0x1
	// Position of SWAP field.
	USART_CR2_SWAP_Pos = 0xf
	// Bit mask of SWAP field.
	USART_CR2_SWAP_Msk = 0x8000
	// Bit SWAP.
	USART_CR2_SWAP = 0x8000
	// TX/RX pins are used as defined in standard pinout
	USART_CR2_SWAP_Standard = 0x0
	// The TX and RX pins functions are swapped
	USART_CR2_SWAP_Swapped = 0x1
	// Position of LINEN field.
	USART_CR2_LINEN_Pos = 0xe
	// Bit mask of LINEN field.
	USART_CR2_LINEN_Msk = 0x4000
	// Bit LINEN.
	USART_CR2_LINEN = 0x4000
	// LIN mode disabled
	USART_CR2_LINEN_Disabled = 0x0
	// LIN mode enabled
	USART_CR2_LINEN_Enabled = 0x1
	// Position of STOP field.
	USART_CR2_STOP_Pos = 0xc
	// Bit mask of STOP field.
	USART_CR2_STOP_Msk = 0x3000
	// 1 stop bit
	USART_CR2_STOP_Stop1 = 0x0
	// 0.5 stop bit
	USART_CR2_STOP_Stop0p5 = 0x1
	// 2 stop bit
	USART_CR2_STOP_Stop2 = 0x2
	// 1.5 stop bit
	USART_CR2_STOP_Stop1p5 = 0x3
	// Position of CLKEN field.
	USART_CR2_CLKEN_Pos = 0xb
	// Bit mask of CLKEN field.
	USART_CR2_CLKEN_Msk = 0x800
	// Bit CLKEN.
	USART_CR2_CLKEN = 0x800
	// CK pin disabled
	USART_CR2_CLKEN_Disabled = 0x0
	// CK pin enabled
	USART_CR2_CLKEN_Enabled = 0x1
	// Position of CPOL field.
	USART_CR2_CPOL_Pos = 0xa
	// Bit mask of CPOL field.
	USART_CR2_CPOL_Msk = 0x400
	// Bit CPOL.
	USART_CR2_CPOL = 0x400
	// Steady low value on CK pin outside transmission window
	USART_CR2_CPOL_Low = 0x0
	// Steady high value on CK pin outside transmission window
	USART_CR2_CPOL_High = 0x1
	// Position of CPHA field.
	USART_CR2_CPHA_Pos = 0x9
	// Bit mask of CPHA field.
	USART_CR2_CPHA_Msk = 0x200
	// Bit CPHA.
	USART_CR2_CPHA = 0x200
	// The first clock transition is the first data capture edge
	USART_CR2_CPHA_First = 0x0
	// The second clock transition is the first data capture edge
	USART_CR2_CPHA_Second = 0x1
	// Position of LBCL field.
	USART_CR2_LBCL_Pos = 0x8
	// Bit mask of LBCL field.
	USART_CR2_LBCL_Msk = 0x100
	// Bit LBCL.
	USART_CR2_LBCL = 0x100
	// The clock pulse of the last data bit is not output to the CK pin
	USART_CR2_LBCL_NotOutput = 0x0
	// The clock pulse of the last data bit is output to the CK pin
	USART_CR2_LBCL_Output = 0x1
	// Position of LBDIE field.
	USART_CR2_LBDIE_Pos = 0x6
	// Bit mask of LBDIE field.
	USART_CR2_LBDIE_Msk = 0x40
	// Bit LBDIE.
	USART_CR2_LBDIE = 0x40
	// Interrupt is inhibited
	USART_CR2_LBDIE_Disabled = 0x0
	// An interrupt is generated whenever LBDF=1 in the ISR register
	USART_CR2_LBDIE_Enabled = 0x1
	// Position of LBDL field.
	USART_CR2_LBDL_Pos = 0x5
	// Bit mask of LBDL field.
	USART_CR2_LBDL_Msk = 0x20
	// Bit LBDL.
	USART_CR2_LBDL = 0x20
	// 10-bit break detection
	USART_CR2_LBDL_Bit10 = 0x0
	// 11-bit break detection
	USART_CR2_LBDL_Bit11 = 0x1
	// Position of ADDM7 field.
	USART_CR2_ADDM7_Pos = 0x4
	// Bit mask of ADDM7 field.
	USART_CR2_ADDM7_Msk = 0x10
	// Bit ADDM7.
	USART_CR2_ADDM7 = 0x10
	// 4-bit address detection
	USART_CR2_ADDM7_Bit4 = 0x0
	// 7-bit address detection
	USART_CR2_ADDM7_Bit7 = 0x1
	// Position of ADD field.
	USART_CR2_ADD_Pos = 0x18
	// Bit mask of ADD field.
	USART_CR2_ADD_Msk = 0xff000000

	// CR3: Control register 3
	// Position of WUFIE field.
	USART_CR3_WUFIE_Pos = 0x16
	// Bit mask of WUFIE field.
	USART_CR3_WUFIE_Msk = 0x400000
	// Bit WUFIE.
	USART_CR3_WUFIE = 0x400000
	// Interrupt is inhibited
	USART_CR3_WUFIE_Disabled = 0x0
	// An USART interrupt is generated whenever WUF=1 in the ISR register
	USART_CR3_WUFIE_Enabled = 0x1
	// Position of WUS field.
	USART_CR3_WUS_Pos = 0x14
	// Bit mask of WUS field.
	USART_CR3_WUS_Msk = 0x300000
	// WUF active on address match
	USART_CR3_WUS_Address = 0x0
	// WuF active on Start bit detection
	USART_CR3_WUS_Start = 0x2
	// WUF active on RXNE
	USART_CR3_WUS_RXNE = 0x3
	// Position of SCARCNT field.
	USART_CR3_SCARCNT_Pos = 0x11
	// Bit mask of SCARCNT field.
	USART_CR3_SCARCNT_Msk = 0xe0000
	// Position of DEP field.
	USART_CR3_DEP_Pos = 0xf
	// Bit mask of DEP field.
	USART_CR3_DEP_Msk = 0x8000
	// Bit DEP.
	USART_CR3_DEP = 0x8000
	// DE signal is active high
	USART_CR3_DEP_High = 0x0
	// DE signal is active low
	USART_CR3_DEP_Low = 0x1
	// Position of DEM field.
	USART_CR3_DEM_Pos = 0xe
	// Bit mask of DEM field.
	USART_CR3_DEM_Msk = 0x4000
	// Bit DEM.
	USART_CR3_DEM = 0x4000
	// DE function is disabled
	USART_CR3_DEM_Disabled = 0x0
	// The DE signal is output on the RTS pin
	USART_CR3_DEM_Enabled = 0x1
	// Position of DDRE field.
	USART_CR3_DDRE_Pos = 0xd
	// Bit mask of DDRE field.
	USART_CR3_DDRE_Msk = 0x2000
	// Bit DDRE.
	USART_CR3_DDRE = 0x2000
	// DMA is not disabled in case of reception error
	USART_CR3_DDRE_NotDisabled = 0x0
	// DMA is disabled following a reception error
	USART_CR3_DDRE_Disabled = 0x1
	// Position of OVRDIS field.
	USART_CR3_OVRDIS_Pos = 0xc
	// Bit mask of OVRDIS field.
	USART_CR3_OVRDIS_Msk = 0x1000
	// Bit OVRDIS.
	USART_CR3_OVRDIS = 0x1000
	// Overrun Error Flag, ORE, is set when received data is not read before receiving new data
	USART_CR3_OVRDIS_Enabled = 0x0
	// Overrun functionality is disabled. If new data is received while the RXNE flag is still set the ORE flag is not set and the new received data overwrites the previous content of the RDR register
	USART_CR3_OVRDIS_Disabled = 0x1
	// Position of ONEBIT field.
	USART_CR3_ONEBIT_Pos = 0xb
	// Bit mask of ONEBIT field.
	USART_CR3_ONEBIT_Msk = 0x800
	// Bit ONEBIT.
	USART_CR3_ONEBIT = 0x800
	// Three sample bit method
	USART_CR3_ONEBIT_Sample3 = 0x0
	// One sample bit method
	USART_CR3_ONEBIT_Sample1 = 0x1
	// Position of CTSIE field.
	USART_CR3_CTSIE_Pos = 0xa
	// Bit mask of CTSIE field.
	USART_CR3_CTSIE_Msk = 0x400
	// Bit CTSIE.
	USART_CR3_CTSIE = 0x400
	// Interrupt is inhibited
	USART_CR3_CTSIE_Disabled = 0x0
	// An interrupt is generated whenever CTSIF=1 in the ISR register
	USART_CR3_CTSIE_Enabled = 0x1
	// Position of CTSE field.
	USART_CR3_CTSE_Pos = 0x9
	// Bit mask of CTSE field.
	USART_CR3_CTSE_Msk = 0x200
	// Bit CTSE.
	USART_CR3_CTSE = 0x200
	// CTS hardware flow control disabled
	USART_CR3_CTSE_Disabled = 0x0
	// CTS mode enabled, data is only transmitted when the CTS input is asserted
	USART_CR3_CTSE_Enabled = 0x1
	// Position of RTSE field.
	USART_CR3_RTSE_Pos = 0x8
	// Bit mask of RTSE field.
	USART_CR3_RTSE_Msk = 0x100
	// Bit RTSE.
	USART_CR3_RTSE = 0x100
	// RTS hardware flow control disabled
	USART_CR3_RTSE_Disabled = 0x0
	// RTS output enabled, data is only requested when there is space in the receive buffer
	USART_CR3_RTSE_Enabled = 0x1
	// Position of DMAT field.
	USART_CR3_DMAT_Pos = 0x7
	// Bit mask of DMAT field.
	USART_CR3_DMAT_Msk = 0x80
	// Bit DMAT.
	USART_CR3_DMAT = 0x80
	// DMA mode is disabled for transmission
	USART_CR3_DMAT_Disabled = 0x0
	// DMA mode is enabled for transmission
	USART_CR3_DMAT_Enabled = 0x1
	// Position of DMAR field.
	USART_CR3_DMAR_Pos = 0x6
	// Bit mask of DMAR field.
	USART_CR3_DMAR_Msk = 0x40
	// Bit DMAR.
	USART_CR3_DMAR = 0x40
	// DMA mode is disabled for reception
	USART_CR3_DMAR_Disabled = 0x0
	// DMA mode is enabled for reception
	USART_CR3_DMAR_Enabled = 0x1
	// Position of SCEN field.
	USART_CR3_SCEN_Pos = 0x5
	// Bit mask of SCEN field.
	USART_CR3_SCEN_Msk = 0x20
	// Bit SCEN.
	USART_CR3_SCEN = 0x20
	// Smartcard Mode disabled
	USART_CR3_SCEN_Disabled = 0x0
	// Smartcard Mode enabled
	USART_CR3_SCEN_Enabled = 0x1
	// Position of NACK field.
	USART_CR3_NACK_Pos = 0x4
	// Bit mask of NACK field.
	USART_CR3_NACK_Msk = 0x10
	// Bit NACK.
	USART_CR3_NACK = 0x10
	// NACK transmission in case of parity error is disabled
	USART_CR3_NACK_Disabled = 0x0
	// NACK transmission during parity error is enabled
	USART_CR3_NACK_Enabled = 0x1
	// Position of HDSEL field.
	USART_CR3_HDSEL_Pos = 0x3
	// Bit mask of HDSEL field.
	USART_CR3_HDSEL_Msk = 0x8
	// Bit HDSEL.
	USART_CR3_HDSEL = 0x8
	// Half duplex mode is not selected
	USART_CR3_HDSEL_NotSelected = 0x0
	// Half duplex mode is selected
	USART_CR3_HDSEL_Selected = 0x1
	// Position of IRLP field.
	USART_CR3_IRLP_Pos = 0x2
	// Bit mask of IRLP field.
	USART_CR3_IRLP_Msk = 0x4
	// Bit IRLP.
	USART_CR3_IRLP = 0x4
	// Normal mode
	USART_CR3_IRLP_Normal = 0x0
	// Low-power mode
	USART_CR3_IRLP_LowPower = 0x1
	// Position of IREN field.
	USART_CR3_IREN_Pos = 0x1
	// Bit mask of IREN field.
	USART_CR3_IREN_Msk = 0x2
	// Bit IREN.
	USART_CR3_IREN = 0x2
	// IrDA disabled
	USART_CR3_IREN_Disabled = 0x0
	// IrDA enabled
	USART_CR3_IREN_Enabled = 0x1
	// Position of EIE field.
	USART_CR3_EIE_Pos = 0x0
	// Bit mask of EIE field.
	USART_CR3_EIE_Msk = 0x1
	// Bit EIE.
	USART_CR3_EIE = 0x1
	// Interrupt is inhibited
	USART_CR3_EIE_Disabled = 0x0
	// An interrupt is generated when FE=1 or ORE=1 or NF=1 in the ISR register
	USART_CR3_EIE_Enabled = 0x1

	// BRR: Baud rate register
	// Position of BRR field.
	USART_BRR_BRR_Pos = 0x0
	// Bit mask of BRR field.
	USART_BRR_BRR_Msk = 0xffff

	// GTPR: Guard time and prescaler register
	// Position of GT field.
	USART_GTPR_GT_Pos = 0x8
	// Bit mask of GT field.
	USART_GTPR_GT_Msk = 0xff00
	// Position of PSC field.
	USART_GTPR_PSC_Pos = 0x0
	// Bit mask of PSC field.
	USART_GTPR_PSC_Msk = 0xff

	// RTOR: Receiver timeout register
	// Position of BLEN field.
	USART_RTOR_BLEN_Pos = 0x18
	// Bit mask of BLEN field.
	USART_RTOR_BLEN_Msk = 0xff000000
	// Position of RTO field.
	USART_RTOR_RTO_Pos = 0x0
	// Bit mask of RTO field.
	USART_RTOR_RTO_Msk = 0xffffff

	// RQR: Request register
	// Position of TXFRQ field.
	USART_RQR_TXFRQ_Pos = 0x4
	// Bit mask of TXFRQ field.
	USART_RQR_TXFRQ_Msk = 0x10
	// Bit TXFRQ.
	USART_RQR_TXFRQ = 0x10
	// Set the TXE flags. This allows to discard the transmit data
	USART_RQR_TXFRQ_Discard = 0x1
	// Position of RXFRQ field.
	USART_RQR_RXFRQ_Pos = 0x3
	// Bit mask of RXFRQ field.
	USART_RQR_RXFRQ_Msk = 0x8
	// Bit RXFRQ.
	USART_RQR_RXFRQ = 0x8
	// clears the RXNE flag. This allows to discard the received data without reading it, and avoid an overrun condition
	USART_RQR_RXFRQ_Discard = 0x1
	// Position of MMRQ field.
	USART_RQR_MMRQ_Pos = 0x2
	// Bit mask of MMRQ field.
	USART_RQR_MMRQ_Msk = 0x4
	// Bit MMRQ.
	USART_RQR_MMRQ = 0x4
	// Puts the USART in mute mode and sets the RWU flag
	USART_RQR_MMRQ_Mute = 0x1
	// Position of SBKRQ field.
	USART_RQR_SBKRQ_Pos = 0x1
	// Bit mask of SBKRQ field.
	USART_RQR_SBKRQ_Msk = 0x2
	// Bit SBKRQ.
	USART_RQR_SBKRQ = 0x2
	// sets the SBKF flag and request to send a BREAK on the line, as soon as the transmit machine is available
	USART_RQR_SBKRQ_Break = 0x1
	// Position of ABRRQ field.
	USART_RQR_ABRRQ_Pos = 0x0
	// Bit mask of ABRRQ field.
	USART_RQR_ABRRQ_Msk = 0x1
	// Bit ABRRQ.
	USART_RQR_ABRRQ = 0x1
	// resets the ABRF flag in the USART_ISR and request an automatic baud rate measurement on the next received data frame
	USART_RQR_ABRRQ_Request = 0x1

	// ISR: Interrupt & status register
	// Position of REACK field.
	USART_ISR_REACK_Pos = 0x16
	// Bit mask of REACK field.
	USART_ISR_REACK_Msk = 0x400000
	// Bit REACK.
	USART_ISR_REACK = 0x400000
	// Position of TEACK field.
	USART_ISR_TEACK_Pos = 0x15
	// Bit mask of TEACK field.
	USART_ISR_TEACK_Msk = 0x200000
	// Bit TEACK.
	USART_ISR_TEACK = 0x200000
	// Position of WUF field.
	USART_ISR_WUF_Pos = 0x14
	// Bit mask of WUF field.
	USART_ISR_WUF_Msk = 0x100000
	// Bit WUF.
	USART_ISR_WUF = 0x100000
	// Position of RWU field.
	USART_ISR_RWU_Pos = 0x13
	// Bit mask of RWU field.
	USART_ISR_RWU_Msk = 0x80000
	// Bit RWU.
	USART_ISR_RWU = 0x80000
	// Position of SBKF field.
	USART_ISR_SBKF_Pos = 0x12
	// Bit mask of SBKF field.
	USART_ISR_SBKF_Msk = 0x40000
	// Bit SBKF.
	USART_ISR_SBKF = 0x40000
	// Position of CMF field.
	USART_ISR_CMF_Pos = 0x11
	// Bit mask of CMF field.
	USART_ISR_CMF_Msk = 0x20000
	// Bit CMF.
	USART_ISR_CMF = 0x20000
	// Position of BUSY field.
	USART_ISR_BUSY_Pos = 0x10
	// Bit mask of BUSY field.
	USART_ISR_BUSY_Msk = 0x10000
	// Bit BUSY.
	USART_ISR_BUSY = 0x10000
	// Position of ABRF field.
	USART_ISR_ABRF_Pos = 0xf
	// Bit mask of ABRF field.
	USART_ISR_ABRF_Msk = 0x8000
	// Bit ABRF.
	USART_ISR_ABRF = 0x8000
	// Position of ABRE field.
	USART_ISR_ABRE_Pos = 0xe
	// Bit mask of ABRE field.
	USART_ISR_ABRE_Msk = 0x4000
	// Bit ABRE.
	USART_ISR_ABRE = 0x4000
	// Position of EOBF field.
	USART_ISR_EOBF_Pos = 0xc
	// Bit mask of EOBF field.
	USART_ISR_EOBF_Msk = 0x1000
	// Bit EOBF.
	USART_ISR_EOBF = 0x1000
	// Position of RTOF field.
	USART_ISR_RTOF_Pos = 0xb
	// Bit mask of RTOF field.
	USART_ISR_RTOF_Msk = 0x800
	// Bit RTOF.
	USART_ISR_RTOF = 0x800
	// Position of CTS field.
	USART_ISR_CTS_Pos = 0xa
	// Bit mask of CTS field.
	USART_ISR_CTS_Msk = 0x400
	// Bit CTS.
	USART_ISR_CTS = 0x400
	// Position of CTSIF field.
	USART_ISR_CTSIF_Pos = 0x9
	// Bit mask of CTSIF field.
	USART_ISR_CTSIF_Msk = 0x200
	// Bit CTSIF.
	USART_ISR_CTSIF = 0x200
	// Position of LBDF field.
	USART_ISR_LBDF_Pos = 0x8
	// Bit mask of LBDF field.
	USART_ISR_LBDF_Msk = 0x100
	// Bit LBDF.
	USART_ISR_LBDF = 0x100
	// Position of TXE field.
	USART_ISR_TXE_Pos = 0x7
	// Bit mask of TXE field.
	USART_ISR_TXE_Msk = 0x80
	// Bit TXE.
	USART_ISR_TXE = 0x80
	// Position of TC field.
	USART_ISR_TC_Pos = 0x6
	// Bit mask of TC field.
	USART_ISR_TC_Msk = 0x40
	// Bit TC.
	USART_ISR_TC = 0x40
	// Position of RXNE field.
	USART_ISR_RXNE_Pos = 0x5
	// Bit mask of RXNE field.
	USART_ISR_RXNE_Msk = 0x20
	// Bit RXNE.
	USART_ISR_RXNE = 0x20
	// Position of IDLE field.
	USART_ISR_IDLE_Pos = 0x4
	// Bit mask of IDLE field.
	USART_ISR_IDLE_Msk = 0x10
	// Bit IDLE.
	USART_ISR_IDLE = 0x10
	// Position of ORE field.
	USART_ISR_ORE_Pos = 0x3
	// Bit mask of ORE field.
	USART_ISR_ORE_Msk = 0x8
	// Bit ORE.
	USART_ISR_ORE = 0x8
	// Position of NF field.
	USART_ISR_NF_Pos = 0x2
	// Bit mask of NF field.
	USART_ISR_NF_Msk = 0x4
	// Bit NF.
	USART_ISR_NF = 0x4
	// Position of FE field.
	USART_ISR_FE_Pos = 0x1
	// Bit mask of FE field.
	USART_ISR_FE_Msk = 0x2
	// Bit FE.
	USART_ISR_FE = 0x2
	// Position of PE field.
	USART_ISR_PE_Pos = 0x0
	// Bit mask of PE field.
	USART_ISR_PE_Msk = 0x1
	// Bit PE.
	USART_ISR_PE = 0x1

	// ICR: Interrupt flag clear register
	// Position of WUCF field.
	USART_ICR_WUCF_Pos = 0x14
	// Bit mask of WUCF field.
	USART_ICR_WUCF_Msk = 0x100000
	// Bit WUCF.
	USART_ICR_WUCF = 0x100000
	// Clears the WUF flag in the ISR register
	USART_ICR_WUCF_Clear = 0x1
	// Position of CMCF field.
	USART_ICR_CMCF_Pos = 0x11
	// Bit mask of CMCF field.
	USART_ICR_CMCF_Msk = 0x20000
	// Bit CMCF.
	USART_ICR_CMCF = 0x20000
	// Clears the CMF flag in the ISR register
	USART_ICR_CMCF_Clear = 0x1
	// Position of EOBCF field.
	USART_ICR_EOBCF_Pos = 0xc
	// Bit mask of EOBCF field.
	USART_ICR_EOBCF_Msk = 0x1000
	// Bit EOBCF.
	USART_ICR_EOBCF = 0x1000
	// Clears the EOBF flag in the ISR register
	USART_ICR_EOBCF_Clear = 0x1
	// Position of RTOCF field.
	USART_ICR_RTOCF_Pos = 0xb
	// Bit mask of RTOCF field.
	USART_ICR_RTOCF_Msk = 0x800
	// Bit RTOCF.
	USART_ICR_RTOCF = 0x800
	// Clears the RTOF flag in the ISR register
	USART_ICR_RTOCF_Clear = 0x1
	// Position of CTSCF field.
	USART_ICR_CTSCF_Pos = 0x9
	// Bit mask of CTSCF field.
	USART_ICR_CTSCF_Msk = 0x200
	// Bit CTSCF.
	USART_ICR_CTSCF = 0x200
	// Clears the CTSIF flag in the ISR register
	USART_ICR_CTSCF_Clear = 0x1
	// Position of LBDCF field.
	USART_ICR_LBDCF_Pos = 0x8
	// Bit mask of LBDCF field.
	USART_ICR_LBDCF_Msk = 0x100
	// Bit LBDCF.
	USART_ICR_LBDCF = 0x100
	// Clears the LBDF flag in the ISR register
	USART_ICR_LBDCF_Clear = 0x1
	// Position of TCCF field.
	USART_ICR_TCCF_Pos = 0x6
	// Bit mask of TCCF field.
	USART_ICR_TCCF_Msk = 0x40
	// Bit TCCF.
	USART_ICR_TCCF = 0x40
	// Clears the TC flag in the ISR register
	USART_ICR_TCCF_Clear = 0x1
	// Position of IDLECF field.
	USART_ICR_IDLECF_Pos = 0x4
	// Bit mask of IDLECF field.
	USART_ICR_IDLECF_Msk = 0x10
	// Bit IDLECF.
	USART_ICR_IDLECF = 0x10
	// Clears the IDLE flag in the ISR register
	USART_ICR_IDLECF_Clear = 0x1
	// Position of ORECF field.
	USART_ICR_ORECF_Pos = 0x3
	// Bit mask of ORECF field.
	USART_ICR_ORECF_Msk = 0x8
	// Bit ORECF.
	USART_ICR_ORECF = 0x8
	// Clears the ORE flag in the ISR register
	USART_ICR_ORECF_Clear = 0x1
	// Position of NCF field.
	USART_ICR_NCF_Pos = 0x2
	// Bit mask of NCF field.
	USART_ICR_NCF_Msk = 0x4
	// Bit NCF.
	USART_ICR_NCF = 0x4
	// Clears the NF flag in the ISR register
	USART_ICR_NCF_Clear = 0x1
	// Position of FECF field.
	USART_ICR_FECF_Pos = 0x1
	// Bit mask of FECF field.
	USART_ICR_FECF_Msk = 0x2
	// Bit FECF.
	USART_ICR_FECF = 0x2
	// Clears the FE flag in the ISR register
	USART_ICR_FECF_Clear = 0x1
	// Position of PECF field.
	USART_ICR_PECF_Pos = 0x0
	// Bit mask of PECF field.
	USART_ICR_PECF_Msk = 0x1
	// Bit PECF.
	USART_ICR_PECF = 0x1
	// Clears the PE flag in the ISR register
	USART_ICR_PECF_Clear = 0x1

	// RDR: Receive data register
	// Position of RDR field.
	USART_RDR_RDR_Pos = 0x0
	// Bit mask of RDR field.
	USART_RDR_RDR_Msk = 0x1ff

	// TDR: Transmit data register
	// Position of TDR field.
	USART_TDR_TDR_Pos = 0x0
	// Bit mask of TDR field.
	USART_TDR_TDR_Msk = 0x1ff
)

// Bitfields for SPI1: Serial peripheral interface/Inter-IC sound
const (
	// CR1: control register 1
	// Position of BIDIMODE field.
	SPI_CR1_BIDIMODE_Pos = 0xf
	// Bit mask of BIDIMODE field.
	SPI_CR1_BIDIMODE_Msk = 0x8000
	// Bit BIDIMODE.
	SPI_CR1_BIDIMODE = 0x8000
	// 2-line unidirectional data mode selected
	SPI_CR1_BIDIMODE_Unidirectional = 0x0
	// 1-line bidirectional data mode selected
	SPI_CR1_BIDIMODE_Bidirectional = 0x1
	// Position of BIDIOE field.
	SPI_CR1_BIDIOE_Pos = 0xe
	// Bit mask of BIDIOE field.
	SPI_CR1_BIDIOE_Msk = 0x4000
	// Bit BIDIOE.
	SPI_CR1_BIDIOE = 0x4000
	// Output disabled (receive-only mode)
	SPI_CR1_BIDIOE_OutputDisabled = 0x0
	// Output enabled (transmit-only mode)
	SPI_CR1_BIDIOE_OutputEnabled = 0x1
	// Position of CRCEN field.
	SPI_CR1_CRCEN_Pos = 0xd
	// Bit mask of CRCEN field.
	SPI_CR1_CRCEN_Msk = 0x2000
	// Bit CRCEN.
	SPI_CR1_CRCEN = 0x2000
	// CRC calculation disabled
	SPI_CR1_CRCEN_Disabled = 0x0
	// CRC calculation enabled
	SPI_CR1_CRCEN_Enabled = 0x1
	// Position of CRCNEXT field.
	SPI_CR1_CRCNEXT_Pos = 0xc
	// Bit mask of CRCNEXT field.
	SPI_CR1_CRCNEXT_Msk = 0x1000
	// Bit CRCNEXT.
	SPI_CR1_CRCNEXT = 0x1000
	// Next transmit value is from Tx buffer
	SPI_CR1_CRCNEXT_TxBuffer = 0x0
	// Next transmit value is from Tx CRC register
	SPI_CR1_CRCNEXT_CRC = 0x1
	// Position of CRCL field.
	SPI_CR1_CRCL_Pos = 0xb
	// Bit mask of CRCL field.
	SPI_CR1_CRCL_Msk = 0x800
	// Bit CRCL.
	SPI_CR1_CRCL = 0x800
	// 8-bit CRC length
	SPI_CR1_CRCL_EightBit = 0x0
	// 16-bit CRC length
	SPI_CR1_CRCL_SixteenBit = 0x1
	// Position of RXONLY field.
	SPI_CR1_RXONLY_Pos = 0xa
	// Bit mask of RXONLY field.
	SPI_CR1_RXONLY_Msk = 0x400
	// Bit RXONLY.
	SPI_CR1_RXONLY = 0x400
	// Full duplex (Transmit and receive)
	SPI_CR1_RXONLY_FullDuplex = 0x0
	// Output disabled (Receive-only mode)
	SPI_CR1_RXONLY_OutputDisabled = 0x1
	// Position of SSM field.
	SPI_CR1_SSM_Pos = 0x9
	// Bit mask of SSM field.
	SPI_CR1_SSM_Msk = 0x200
	// Bit SSM.
	SPI_CR1_SSM = 0x200
	// Software slave management disabled
	SPI_CR1_SSM_Disabled = 0x0
	// Software slave management enabled
	SPI_CR1_SSM_Enabled = 0x1
	// Position of SSI field.
	SPI_CR1_SSI_Pos = 0x8
	// Bit mask of SSI field.
	SPI_CR1_SSI_Msk = 0x100
	// Bit SSI.
	SPI_CR1_SSI = 0x100
	// 0 is forced onto the NSS pin and the I/O value of the NSS pin is ignored
	SPI_CR1_SSI_SlaveSelected = 0x0
	// 1 is forced onto the NSS pin and the I/O value of the NSS pin is ignored
	SPI_CR1_SSI_SlaveNotSelected = 0x1
	// Position of LSBFIRST field.
	SPI_CR1_LSBFIRST_Pos = 0x7
	// Bit mask of LSBFIRST field.
	SPI_CR1_LSBFIRST_Msk = 0x80
	// Bit LSBFIRST.
	SPI_CR1_LSBFIRST = 0x80
	// Data is transmitted/received with the MSB first
	SPI_CR1_LSBFIRST_MSBFirst = 0x0
	// Data is transmitted/received with the LSB first
	SPI_CR1_LSBFIRST_LSBFirst = 0x1
	// Position of SPE field.
	SPI_CR1_SPE_Pos = 0x6
	// Bit mask of SPE field.
	SPI_CR1_SPE_Msk = 0x40
	// Bit SPE.
	SPI_CR1_SPE = 0x40
	// Peripheral disabled
	SPI_CR1_SPE_Disabled = 0x0
	// Peripheral enabled
	SPI_CR1_SPE_Enabled = 0x1
	// Position of BR field.
	SPI_CR1_BR_Pos = 0x3
	// Bit mask of BR field.
	SPI_CR1_BR_Msk = 0x38
	// f_PCLK / 2
	SPI_CR1_BR_Div2 = 0x0
	// f_PCLK / 4
	SPI_CR1_BR_Div4 = 0x1
	// f_PCLK / 8
	SPI_CR1_BR_Div8 = 0x2
	// f_PCLK / 16
	SPI_CR1_BR_Div16 = 0x3
	// f_PCLK / 32
	SPI_CR1_BR_Div32 = 0x4
	// f_PCLK / 64
	SPI_CR1_BR_Div64 = 0x5
	// f_PCLK / 128
	SPI_CR1_BR_Div128 = 0x6
	// f_PCLK / 256
	SPI_CR1_BR_Div256 = 0x7
	// Position of MSTR field.
	SPI_CR1_MSTR_Pos = 0x2
	// Bit mask of MSTR field.
	SPI_CR1_MSTR_Msk = 0x4
	// Bit MSTR.
	SPI_CR1_MSTR = 0x4
	// Slave configuration
	SPI_CR1_MSTR_Slave = 0x0
	// Master configuration
	SPI_CR1_MSTR_Master = 0x1
	// Position of CPOL field.
	SPI_CR1_CPOL_Pos = 0x1
	// Bit mask of CPOL field.
	SPI_CR1_CPOL_Msk = 0x2
	// Bit CPOL.
	SPI_CR1_CPOL = 0x2
	// CK to 0 when idle
	SPI_CR1_CPOL_IdleLow = 0x0
	// CK to 1 when idle
	SPI_CR1_CPOL_IdleHigh = 0x1
	// Position of CPHA field.
	SPI_CR1_CPHA_Pos = 0x0
	// Bit mask of CPHA field.
	SPI_CR1_CPHA_Msk = 0x1
	// Bit CPHA.
	SPI_CR1_CPHA = 0x1
	// The first clock transition is the first data capture edge
	SPI_CR1_CPHA_FirstEdge = 0x0
	// The second clock transition is the first data capture edge
	SPI_CR1_CPHA_SecondEdge = 0x1

	// CR2: control register 2
	// Position of RXDMAEN field.
	SPI_CR2_RXDMAEN_Pos = 0x0
	// Bit mask of RXDMAEN field.
	SPI_CR2_RXDMAEN_Msk = 0x1
	// Bit RXDMAEN.
	SPI_CR2_RXDMAEN = 0x1
	// Rx buffer DMA disabled
	SPI_CR2_RXDMAEN_Disabled = 0x0
	// Rx buffer DMA enabled
	SPI_CR2_RXDMAEN_Enabled = 0x1
	// Position of TXDMAEN field.
	SPI_CR2_TXDMAEN_Pos = 0x1
	// Bit mask of TXDMAEN field.
	SPI_CR2_TXDMAEN_Msk = 0x2
	// Bit TXDMAEN.
	SPI_CR2_TXDMAEN = 0x2
	// Tx buffer DMA disabled
	SPI_CR2_TXDMAEN_Disabled = 0x0
	// Tx buffer DMA enabled
	SPI_CR2_TXDMAEN_Enabled = 0x1
	// Position of SSOE field.
	SPI_CR2_SSOE_Pos = 0x2
	// Bit mask of SSOE field.
	SPI_CR2_SSOE_Msk = 0x4
	// Bit SSOE.
	SPI_CR2_SSOE = 0x4
	// SS output is disabled in master mode
	SPI_CR2_SSOE_Disabled = 0x0
	// SS output is enabled in master mode
	SPI_CR2_SSOE_Enabled = 0x1
	// Position of NSSP field.
	SPI_CR2_NSSP_Pos = 0x3
	// Bit mask of NSSP field.
	SPI_CR2_NSSP_Msk = 0x8
	// Bit NSSP.
	SPI_CR2_NSSP = 0x8
	// No NSS pulse
	SPI_CR2_NSSP_NoPulse = 0x0
	// NSS pulse generated
	SPI_CR2_NSSP_PulseGenerated = 0x1
	// Position of FRF field.
	SPI_CR2_FRF_Pos = 0x4
	// Bit mask of FRF field.
	SPI_CR2_FRF_Msk = 0x10
	// Bit FRF.
	SPI_CR2_FRF = 0x10
	// SPI Motorola mode
	SPI_CR2_FRF_Motorola = 0x0
	// SPI TI mode
	SPI_CR2_FRF_TI = 0x1
	// Position of ERRIE field.
	SPI_CR2_ERRIE_Pos = 0x5
	// Bit mask of ERRIE field.
	SPI_CR2_ERRIE_Msk = 0x20
	// Bit ERRIE.
	SPI_CR2_ERRIE = 0x20
	// Error interrupt masked
	SPI_CR2_ERRIE_Masked = 0x0
	// Error interrupt not masked
	SPI_CR2_ERRIE_NotMasked = 0x1
	// Position of RXNEIE field.
	SPI_CR2_RXNEIE_Pos = 0x6
	// Bit mask of RXNEIE field.
	SPI_CR2_RXNEIE_Msk = 0x40
	// Bit RXNEIE.
	SPI_CR2_RXNEIE = 0x40
	// RXE interrupt masked
	SPI_CR2_RXNEIE_Masked = 0x0
	// RXE interrupt not masked
	SPI_CR2_RXNEIE_NotMasked = 0x1
	// Position of TXEIE field.
	SPI_CR2_TXEIE_Pos = 0x7
	// Bit mask of TXEIE field.
	SPI_CR2_TXEIE_Msk = 0x80
	// Bit TXEIE.
	SPI_CR2_TXEIE = 0x80
	// TXE interrupt masked
	SPI_CR2_TXEIE_Masked = 0x0
	// TXE interrupt not masked
	SPI_CR2_TXEIE_NotMasked = 0x1
	// Position of DS field.
	SPI_CR2_DS_Pos = 0x8
	// Bit mask of DS field.
	SPI_CR2_DS_Msk = 0xf00
	// 4-bit
	SPI_CR2_DS_FourBit = 0x3
	// 5-bit
	SPI_CR2_DS_FiveBit = 0x4
	// 6-bit
	SPI_CR2_DS_SixBit = 0x5
	// 7-bit
	SPI_CR2_DS_SevenBit = 0x6
	// 8-bit
	SPI_CR2_DS_EightBit = 0x7
	// 9-bit
	SPI_CR2_DS_NineBit = 0x8
	// 10-bit
	SPI_CR2_DS_TenBit = 0x9
	// 11-bit
	SPI_CR2_DS_ElevenBit = 0xa
	// 12-bit
	SPI_CR2_DS_TwelveBit = 0xb
	// 13-bit
	SPI_CR2_DS_ThirteenBit = 0xc
	// 14-bit
	SPI_CR2_DS_FourteenBit = 0xd
	// 15-bit
	SPI_CR2_DS_FifteenBit = 0xe
	// 16-bit
	SPI_CR2_DS_SixteenBit = 0xf
	// Position of FRXTH field.
	SPI_CR2_FRXTH_Pos = 0xc
	// Bit mask of FRXTH field.
	SPI_CR2_FRXTH_Msk = 0x1000
	// Bit FRXTH.
	SPI_CR2_FRXTH = 0x1000
	// RXNE event is generated if the FIFO level is greater than or equal to 1/2 (16-bit)
	SPI_CR2_FRXTH_Half = 0x0
	// RXNE event is generated if the FIFO level is greater than or equal to 1/4 (8-bit)
	SPI_CR2_FRXTH_Quarter = 0x1
	// Position of LDMA_RX field.
	SPI_CR2_LDMA_RX_Pos = 0xd
	// Bit mask of LDMA_RX field.
	SPI_CR2_LDMA_RX_Msk = 0x2000
	// Bit LDMA_RX.
	SPI_CR2_LDMA_RX = 0x2000
	// Number of data to transfer for receive is even
	SPI_CR2_LDMA_RX_Even = 0x0
	// Number of data to transfer for receive is odd
	SPI_CR2_LDMA_RX_Odd = 0x1
	// Position of LDMA_TX field.
	SPI_CR2_LDMA_TX_Pos = 0xe
	// Bit mask of LDMA_TX field.
	SPI_CR2_LDMA_TX_Msk = 0x4000
	// Bit LDMA_TX.
	SPI_CR2_LDMA_TX = 0x4000
	// Number of data to transfer for transmit is even
	SPI_CR2_LDMA_TX_Even = 0x0
	// Number of data to transfer for transmit is odd
	SPI_CR2_LDMA_TX_Odd = 0x1

	// SR: status register
	// Position of RXNE field.
	SPI_SR_RXNE_Pos = 0x0
	// Bit mask of RXNE field.
	SPI_SR_RXNE_Msk = 0x1
	// Bit RXNE.
	SPI_SR_RXNE = 0x1
	// Rx buffer empty
	SPI_SR_RXNE_Empty = 0x0
	// Rx buffer not empty
	SPI_SR_RXNE_NotEmpty = 0x1
	// Position of TXE field.
	SPI_SR_TXE_Pos = 0x1
	// Bit mask of TXE field.
	SPI_SR_TXE_Msk = 0x2
	// Bit TXE.
	SPI_SR_TXE = 0x2
	// Tx buffer not empty
	SPI_SR_TXE_NotEmpty = 0x0
	// Tx buffer empty
	SPI_SR_TXE_Empty = 0x1
	// Position of CHSIDE field.
	SPI_SR_CHSIDE_Pos = 0x2
	// Bit mask of CHSIDE field.
	SPI_SR_CHSIDE_Msk = 0x4
	// Bit CHSIDE.
	SPI_SR_CHSIDE = 0x4
	// Channel left has to be transmitted or has been received
	SPI_SR_CHSIDE_Left = 0x0
	// Channel right has to be transmitted or has been received
	SPI_SR_CHSIDE_Right = 0x1
	// Position of UDR field.
	SPI_SR_UDR_Pos = 0x3
	// Bit mask of UDR field.
	SPI_SR_UDR_Msk = 0x8
	// Bit UDR.
	SPI_SR_UDR = 0x8
	// No underrun occurred
	SPI_SR_UDR_NoUnderrun = 0x0
	// Underrun occurred
	SPI_SR_UDR_Underrun = 0x1
	// Position of CRCERR field.
	SPI_SR_CRCERR_Pos = 0x4
	// Bit mask of CRCERR field.
	SPI_SR_CRCERR_Msk = 0x10
	// Bit CRCERR.
	SPI_SR_CRCERR = 0x10
	// CRC value received matches the SPIx_RXCRCR value
	SPI_SR_CRCERR_Match = 0x0
	// CRC value received does not match the SPIx_RXCRCR value
	SPI_SR_CRCERR_NoMatch = 0x1
	// Position of MODF field.
	SPI_SR_MODF_Pos = 0x5
	// Bit mask of MODF field.
	SPI_SR_MODF_Msk = 0x20
	// Bit MODF.
	SPI_SR_MODF = 0x20
	// No mode fault occurred
	SPI_SR_MODF_NoFault = 0x0
	// Mode fault occurred
	SPI_SR_MODF_Fault = 0x1
	// Position of OVR field.
	SPI_SR_OVR_Pos = 0x6
	// Bit mask of OVR field.
	SPI_SR_OVR_Msk = 0x40
	// Bit OVR.
	SPI_SR_OVR = 0x40
	// No overrun occurred
	SPI_SR_OVR_NoOverrun = 0x0
	// Overrun occurred
	SPI_SR_OVR_Overrun = 0x1
	// Position of BSY field.
	SPI_SR_BSY_Pos = 0x7
	// Bit mask of BSY field.
	SPI_SR_BSY_Msk = 0x80
	// Bit BSY.
	SPI_SR_BSY = 0x80
	// SPI not busy
	SPI_SR_BSY_NotBusy = 0x0
	// SPI busy
	SPI_SR_BSY_Busy = 0x1
	// Position of FRE field.
	SPI_SR_FRE_Pos = 0x8
	// Bit mask of FRE field.
	SPI_SR_FRE_Msk = 0x100
	// Bit FRE.
	SPI_SR_FRE = 0x100
	// No frame format error
	SPI_SR_FRE_NoError = 0x0
	// A frame format error occurred
	SPI_SR_FRE_Error = 0x1
	// Position of FRLVL field.
	SPI_SR_FRLVL_Pos = 0x9
	// Bit mask of FRLVL field.
	SPI_SR_FRLVL_Msk = 0x600
	// Rx FIFO Empty
	SPI_SR_FRLVL_Empty = 0x0
	// Rx 1/4 FIFO
	SPI_SR_FRLVL_Quarter = 0x1
	// Rx 1/2 FIFO
	SPI_SR_FRLVL_Half = 0x2
	// Rx FIFO full
	SPI_SR_FRLVL_Full = 0x3
	// Position of FTLVL field.
	SPI_SR_FTLVL_Pos = 0xb
	// Bit mask of FTLVL field.
	SPI_SR_FTLVL_Msk = 0x1800
	// Tx FIFO Empty
	SPI_SR_FTLVL_Empty = 0x0
	// Tx 1/4 FIFO
	SPI_SR_FTLVL_Quarter = 0x1
	// Tx 1/2 FIFO
	SPI_SR_FTLVL_Half = 0x2
	// Tx FIFO full
	SPI_SR_FTLVL_Full = 0x3

	// DR: data register
	// Position of DR field.
	SPI_DR_DR_Pos = 0x0
	// Bit mask of DR field.
	SPI_DR_DR_Msk = 0xffff

	// CRCPR: CRC polynomial register
	// Position of CRCPOLY field.
	SPI_CRCPR_CRCPOLY_Pos = 0x0
	// Bit mask of CRCPOLY field.
	SPI_CRCPR_CRCPOLY_Msk = 0xffff

	// RXCRCR: RX CRC register
	// Position of RxCRC field.
	SPI_RXCRCR_RxCRC_Pos = 0x0
	// Bit mask of RxCRC field.
	SPI_RXCRCR_RxCRC_Msk = 0xffff

	// TXCRCR: TX CRC register
	// Position of TxCRC field.
	SPI_TXCRCR_TxCRC_Pos = 0x0
	// Bit mask of TxCRC field.
	SPI_TXCRCR_TxCRC_Msk = 0xffff

	// I2SCFGR: I2S configuration register
	// Position of I2SMOD field.
	SPI_I2SCFGR_I2SMOD_Pos = 0xb
	// Bit mask of I2SMOD field.
	SPI_I2SCFGR_I2SMOD_Msk = 0x800
	// Bit I2SMOD.
	SPI_I2SCFGR_I2SMOD = 0x800
	// SPI mode is selected
	SPI_I2SCFGR_I2SMOD_SPIMode = 0x0
	// I2S mode is selected
	SPI_I2SCFGR_I2SMOD_I2SMode = 0x1
	// Position of I2SE field.
	SPI_I2SCFGR_I2SE_Pos = 0xa
	// Bit mask of I2SE field.
	SPI_I2SCFGR_I2SE_Msk = 0x400
	// Bit I2SE.
	SPI_I2SCFGR_I2SE = 0x400
	// I2S peripheral is disabled
	SPI_I2SCFGR_I2SE_Disabled = 0x0
	// I2S peripheral is enabled
	SPI_I2SCFGR_I2SE_Enabled = 0x1
	// Position of I2SCFG field.
	SPI_I2SCFGR_I2SCFG_Pos = 0x8
	// Bit mask of I2SCFG field.
	SPI_I2SCFGR_I2SCFG_Msk = 0x300
	// Slave - transmit
	SPI_I2SCFGR_I2SCFG_SlaveTx = 0x0
	// Slave - receive
	SPI_I2SCFGR_I2SCFG_SlaveRx = 0x1
	// Master - transmit
	SPI_I2SCFGR_I2SCFG_MasterTx = 0x2
	// Master - receive
	SPI_I2SCFGR_I2SCFG_MasterRx = 0x3
	// Position of PCMSYNC field.
	SPI_I2SCFGR_PCMSYNC_Pos = 0x7
	// Bit mask of PCMSYNC field.
	SPI_I2SCFGR_PCMSYNC_Msk = 0x80
	// Bit PCMSYNC.
	SPI_I2SCFGR_PCMSYNC = 0x80
	// Short frame synchronisation
	SPI_I2SCFGR_PCMSYNC_Short = 0x0
	// Long frame synchronisation
	SPI_I2SCFGR_PCMSYNC_Long = 0x1
	// Position of I2SSTD field.
	SPI_I2SCFGR_I2SSTD_Pos = 0x4
	// Bit mask of I2SSTD field.
	SPI_I2SCFGR_I2SSTD_Msk = 0x30
	// I2S Philips standard
	SPI_I2SCFGR_I2SSTD_Philips = 0x0
	// MSB justified standard
	SPI_I2SCFGR_I2SSTD_MSB = 0x1
	// LSB justified standard
	SPI_I2SCFGR_I2SSTD_LSB = 0x2
	// PCM standard
	SPI_I2SCFGR_I2SSTD_PCM = 0x3
	// Position of CKPOL field.
	SPI_I2SCFGR_CKPOL_Pos = 0x3
	// Bit mask of CKPOL field.
	SPI_I2SCFGR_CKPOL_Msk = 0x8
	// Bit CKPOL.
	SPI_I2SCFGR_CKPOL = 0x8
	// I2S clock inactive state is low level
	SPI_I2SCFGR_CKPOL_IdleLow = 0x0
	// I2S clock inactive state is high level
	SPI_I2SCFGR_CKPOL_IdleHigh = 0x1
	// Position of DATLEN field.
	SPI_I2SCFGR_DATLEN_Pos = 0x1
	// Bit mask of DATLEN field.
	SPI_I2SCFGR_DATLEN_Msk = 0x6
	// 16-bit data length
	SPI_I2SCFGR_DATLEN_SixteenBit = 0x0
	// 24-bit data length
	SPI_I2SCFGR_DATLEN_TwentyFourBit = 0x1
	// 32-bit data length
	SPI_I2SCFGR_DATLEN_ThirtyTwoBit = 0x2
	// Position of CHLEN field.
	SPI_I2SCFGR_CHLEN_Pos = 0x0
	// Bit mask of CHLEN field.
	SPI_I2SCFGR_CHLEN_Msk = 0x1
	// Bit CHLEN.
	SPI_I2SCFGR_CHLEN = 0x1
	// 16-bit wide
	SPI_I2SCFGR_CHLEN_SixteenBit = 0x0
	// 32-bit wide
	SPI_I2SCFGR_CHLEN_ThirtyTwoBit = 0x1

	// I2SPR: I2S prescaler register
	// Position of MCKOE field.
	SPI_I2SPR_MCKOE_Pos = 0x9
	// Bit mask of MCKOE field.
	SPI_I2SPR_MCKOE_Msk = 0x200
	// Bit MCKOE.
	SPI_I2SPR_MCKOE = 0x200
	// Master clock output is disabled
	SPI_I2SPR_MCKOE_Disabled = 0x0
	// Master clock output is enabled
	SPI_I2SPR_MCKOE_Enabled = 0x1
	// Position of ODD field.
	SPI_I2SPR_ODD_Pos = 0x8
	// Bit mask of ODD field.
	SPI_I2SPR_ODD_Msk = 0x100
	// Bit ODD.
	SPI_I2SPR_ODD = 0x100
	// Real divider value is I2SDIV * 2
	SPI_I2SPR_ODD_Even = 0x0
	// Real divider value is (I2SDIV * 2) + 1
	SPI_I2SPR_ODD_Odd = 0x1
	// Position of I2SDIV field.
	SPI_I2SPR_I2SDIV_Pos = 0x0
	// Bit mask of I2SDIV field.
	SPI_I2SPR_I2SDIV_Msk = 0xff
)

// Bitfields for EXTI: External interrupt/event controller
const (
	// IMR1: Interrupt mask register
	// Position of MR0 field.
	EXTI_IMR1_MR0_Pos = 0x0
	// Bit mask of MR0 field.
	EXTI_IMR1_MR0_Msk = 0x1
	// Bit MR0.
	EXTI_IMR1_MR0 = 0x1
	// Interrupt request line is masked
	EXTI_IMR1_MR0_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_IMR1_MR0_Unmasked = 0x1
	// Position of MR1 field.
	EXTI_IMR1_MR1_Pos = 0x1
	// Bit mask of MR1 field.
	EXTI_IMR1_MR1_Msk = 0x2
	// Bit MR1.
	EXTI_IMR1_MR1 = 0x2
	// Interrupt request line is masked
	EXTI_IMR1_MR1_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_IMR1_MR1_Unmasked = 0x1
	// Position of MR2 field.
	EXTI_IMR1_MR2_Pos = 0x2
	// Bit mask of MR2 field.
	EXTI_IMR1_MR2_Msk = 0x4
	// Bit MR2.
	EXTI_IMR1_MR2 = 0x4
	// Interrupt request line is masked
	EXTI_IMR1_MR2_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_IMR1_MR2_Unmasked = 0x1
	// Position of MR3 field.
	EXTI_IMR1_MR3_Pos = 0x3
	// Bit mask of MR3 field.
	EXTI_IMR1_MR3_Msk = 0x8
	// Bit MR3.
	EXTI_IMR1_MR3 = 0x8
	// Interrupt request line is masked
	EXTI_IMR1_MR3_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_IMR1_MR3_Unmasked = 0x1
	// Position of MR4 field.
	EXTI_IMR1_MR4_Pos = 0x4
	// Bit mask of MR4 field.
	EXTI_IMR1_MR4_Msk = 0x10
	// Bit MR4.
	EXTI_IMR1_MR4 = 0x10
	// Interrupt request line is masked
	EXTI_IMR1_MR4_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_IMR1_MR4_Unmasked = 0x1
	// Position of MR5 field.
	EXTI_IMR1_MR5_Pos = 0x5
	// Bit mask of MR5 field.
	EXTI_IMR1_MR5_Msk = 0x20
	// Bit MR5.
	EXTI_IMR1_MR5 = 0x20
	// Interrupt request line is masked
	EXTI_IMR1_MR5_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_IMR1_MR5_Unmasked = 0x1
	// Position of MR6 field.
	EXTI_IMR1_MR6_Pos = 0x6
	// Bit mask of MR6 field.
	EXTI_IMR1_MR6_Msk = 0x40
	// Bit MR6.
	EXTI_IMR1_MR6 = 0x40
	// Interrupt request line is masked
	EXTI_IMR1_MR6_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_IMR1_MR6_Unmasked = 0x1
	// Position of MR7 field.
	EXTI_IMR1_MR7_Pos = 0x7
	// Bit mask of MR7 field.
	EXTI_IMR1_MR7_Msk = 0x80
	// Bit MR7.
	EXTI_IMR1_MR7 = 0x80
	// Interrupt request line is masked
	EXTI_IMR1_MR7_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_IMR1_MR7_Unmasked = 0x1
	// Position of MR8 field.
	EXTI_IMR1_MR8_Pos = 0x8
	// Bit mask of MR8 field.
	EXTI_IMR1_MR8_Msk = 0x100
	// Bit MR8.
	EXTI_IMR1_MR8 = 0x100
	// Interrupt request line is masked
	EXTI_IMR1_MR8_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_IMR1_MR8_Unmasked = 0x1
	// Position of MR9 field.
	EXTI_IMR1_MR9_Pos = 0x9
	// Bit mask of MR9 field.
	EXTI_IMR1_MR9_Msk = 0x200
	// Bit MR9.
	EXTI_IMR1_MR9 = 0x200
	// Interrupt request line is masked
	EXTI_IMR1_MR9_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_IMR1_MR9_Unmasked = 0x1
	// Position of MR10 field.
	EXTI_IMR1_MR10_Pos = 0xa
	// Bit mask of MR10 field.
	EXTI_IMR1_MR10_Msk = 0x400
	// Bit MR10.
	EXTI_IMR1_MR10 = 0x400
	// Interrupt request line is masked
	EXTI_IMR1_MR10_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_IMR1_MR10_Unmasked = 0x1
	// Position of MR11 field.
	EXTI_IMR1_MR11_Pos = 0xb
	// Bit mask of MR11 field.
	EXTI_IMR1_MR11_Msk = 0x800
	// Bit MR11.
	EXTI_IMR1_MR11 = 0x800
	// Interrupt request line is masked
	EXTI_IMR1_MR11_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_IMR1_MR11_Unmasked = 0x1
	// Position of MR12 field.
	EXTI_IMR1_MR12_Pos = 0xc
	// Bit mask of MR12 field.
	EXTI_IMR1_MR12_Msk = 0x1000
	// Bit MR12.
	EXTI_IMR1_MR12 = 0x1000
	// Interrupt request line is masked
	EXTI_IMR1_MR12_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_IMR1_MR12_Unmasked = 0x1
	// Position of MR13 field.
	EXTI_IMR1_MR13_Pos = 0xd
	// Bit mask of MR13 field.
	EXTI_IMR1_MR13_Msk = 0x2000
	// Bit MR13.
	EXTI_IMR1_MR13 = 0x2000
	// Interrupt request line is masked
	EXTI_IMR1_MR13_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_IMR1_MR13_Unmasked = 0x1
	// Position of MR14 field.
	EXTI_IMR1_MR14_Pos = 0xe
	// Bit mask of MR14 field.
	EXTI_IMR1_MR14_Msk = 0x4000
	// Bit MR14.
	EXTI_IMR1_MR14 = 0x4000
	// Interrupt request line is masked
	EXTI_IMR1_MR14_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_IMR1_MR14_Unmasked = 0x1
	// Position of MR15 field.
	EXTI_IMR1_MR15_Pos = 0xf
	// Bit mask of MR15 field.
	EXTI_IMR1_MR15_Msk = 0x8000
	// Bit MR15.
	EXTI_IMR1_MR15 = 0x8000
	// Interrupt request line is masked
	EXTI_IMR1_MR15_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_IMR1_MR15_Unmasked = 0x1
	// Position of MR16 field.
	EXTI_IMR1_MR16_Pos = 0x10
	// Bit mask of MR16 field.
	EXTI_IMR1_MR16_Msk = 0x10000
	// Bit MR16.
	EXTI_IMR1_MR16 = 0x10000
	// Interrupt request line is masked
	EXTI_IMR1_MR16_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_IMR1_MR16_Unmasked = 0x1
	// Position of MR17 field.
	EXTI_IMR1_MR17_Pos = 0x11
	// Bit mask of MR17 field.
	EXTI_IMR1_MR17_Msk = 0x20000
	// Bit MR17.
	EXTI_IMR1_MR17 = 0x20000
	// Interrupt request line is masked
	EXTI_IMR1_MR17_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_IMR1_MR17_Unmasked = 0x1
	// Position of MR18 field.
	EXTI_IMR1_MR18_Pos = 0x12
	// Bit mask of MR18 field.
	EXTI_IMR1_MR18_Msk = 0x40000
	// Bit MR18.
	EXTI_IMR1_MR18 = 0x40000
	// Interrupt request line is masked
	EXTI_IMR1_MR18_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_IMR1_MR18_Unmasked = 0x1
	// Position of MR19 field.
	EXTI_IMR1_MR19_Pos = 0x13
	// Bit mask of MR19 field.
	EXTI_IMR1_MR19_Msk = 0x80000
	// Bit MR19.
	EXTI_IMR1_MR19 = 0x80000
	// Interrupt request line is masked
	EXTI_IMR1_MR19_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_IMR1_MR19_Unmasked = 0x1
	// Position of MR20 field.
	EXTI_IMR1_MR20_Pos = 0x14
	// Bit mask of MR20 field.
	EXTI_IMR1_MR20_Msk = 0x100000
	// Bit MR20.
	EXTI_IMR1_MR20 = 0x100000
	// Interrupt request line is masked
	EXTI_IMR1_MR20_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_IMR1_MR20_Unmasked = 0x1
	// Position of MR21 field.
	EXTI_IMR1_MR21_Pos = 0x15
	// Bit mask of MR21 field.
	EXTI_IMR1_MR21_Msk = 0x200000
	// Bit MR21.
	EXTI_IMR1_MR21 = 0x200000
	// Interrupt request line is masked
	EXTI_IMR1_MR21_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_IMR1_MR21_Unmasked = 0x1
	// Position of MR22 field.
	EXTI_IMR1_MR22_Pos = 0x16
	// Bit mask of MR22 field.
	EXTI_IMR1_MR22_Msk = 0x400000
	// Bit MR22.
	EXTI_IMR1_MR22 = 0x400000
	// Interrupt request line is masked
	EXTI_IMR1_MR22_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_IMR1_MR22_Unmasked = 0x1
	// Position of MR23 field.
	EXTI_IMR1_MR23_Pos = 0x17
	// Bit mask of MR23 field.
	EXTI_IMR1_MR23_Msk = 0x800000
	// Bit MR23.
	EXTI_IMR1_MR23 = 0x800000
	// Interrupt request line is masked
	EXTI_IMR1_MR23_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_IMR1_MR23_Unmasked = 0x1
	// Position of MR24 field.
	EXTI_IMR1_MR24_Pos = 0x18
	// Bit mask of MR24 field.
	EXTI_IMR1_MR24_Msk = 0x1000000
	// Bit MR24.
	EXTI_IMR1_MR24 = 0x1000000
	// Interrupt request line is masked
	EXTI_IMR1_MR24_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_IMR1_MR24_Unmasked = 0x1
	// Position of MR25 field.
	EXTI_IMR1_MR25_Pos = 0x19
	// Bit mask of MR25 field.
	EXTI_IMR1_MR25_Msk = 0x2000000
	// Bit MR25.
	EXTI_IMR1_MR25 = 0x2000000
	// Interrupt request line is masked
	EXTI_IMR1_MR25_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_IMR1_MR25_Unmasked = 0x1
	// Position of MR26 field.
	EXTI_IMR1_MR26_Pos = 0x1a
	// Bit mask of MR26 field.
	EXTI_IMR1_MR26_Msk = 0x4000000
	// Bit MR26.
	EXTI_IMR1_MR26 = 0x4000000
	// Interrupt request line is masked
	EXTI_IMR1_MR26_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_IMR1_MR26_Unmasked = 0x1
	// Position of MR27 field.
	EXTI_IMR1_MR27_Pos = 0x1b
	// Bit mask of MR27 field.
	EXTI_IMR1_MR27_Msk = 0x8000000
	// Bit MR27.
	EXTI_IMR1_MR27 = 0x8000000
	// Interrupt request line is masked
	EXTI_IMR1_MR27_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_IMR1_MR27_Unmasked = 0x1
	// Position of MR28 field.
	EXTI_IMR1_MR28_Pos = 0x1c
	// Bit mask of MR28 field.
	EXTI_IMR1_MR28_Msk = 0x10000000
	// Bit MR28.
	EXTI_IMR1_MR28 = 0x10000000
	// Interrupt request line is masked
	EXTI_IMR1_MR28_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_IMR1_MR28_Unmasked = 0x1
	// Position of MR29 field.
	EXTI_IMR1_MR29_Pos = 0x1d
	// Bit mask of MR29 field.
	EXTI_IMR1_MR29_Msk = 0x20000000
	// Bit MR29.
	EXTI_IMR1_MR29 = 0x20000000
	// Interrupt request line is masked
	EXTI_IMR1_MR29_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_IMR1_MR29_Unmasked = 0x1
	// Position of MR30 field.
	EXTI_IMR1_MR30_Pos = 0x1e
	// Bit mask of MR30 field.
	EXTI_IMR1_MR30_Msk = 0x40000000
	// Bit MR30.
	EXTI_IMR1_MR30 = 0x40000000
	// Interrupt request line is masked
	EXTI_IMR1_MR30_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_IMR1_MR30_Unmasked = 0x1
	// Position of MR31 field.
	EXTI_IMR1_MR31_Pos = 0x1f
	// Bit mask of MR31 field.
	EXTI_IMR1_MR31_Msk = 0x80000000
	// Bit MR31.
	EXTI_IMR1_MR31 = 0x80000000
	// Interrupt request line is masked
	EXTI_IMR1_MR31_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_IMR1_MR31_Unmasked = 0x1

	// EMR1: Event mask register
	// Position of MR0 field.
	EXTI_EMR1_MR0_Pos = 0x0
	// Bit mask of MR0 field.
	EXTI_EMR1_MR0_Msk = 0x1
	// Bit MR0.
	EXTI_EMR1_MR0 = 0x1
	// Interrupt request line is masked
	EXTI_EMR1_MR0_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_EMR1_MR0_Unmasked = 0x1
	// Position of MR1 field.
	EXTI_EMR1_MR1_Pos = 0x1
	// Bit mask of MR1 field.
	EXTI_EMR1_MR1_Msk = 0x2
	// Bit MR1.
	EXTI_EMR1_MR1 = 0x2
	// Interrupt request line is masked
	EXTI_EMR1_MR1_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_EMR1_MR1_Unmasked = 0x1
	// Position of MR2 field.
	EXTI_EMR1_MR2_Pos = 0x2
	// Bit mask of MR2 field.
	EXTI_EMR1_MR2_Msk = 0x4
	// Bit MR2.
	EXTI_EMR1_MR2 = 0x4
	// Interrupt request line is masked
	EXTI_EMR1_MR2_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_EMR1_MR2_Unmasked = 0x1
	// Position of MR3 field.
	EXTI_EMR1_MR3_Pos = 0x3
	// Bit mask of MR3 field.
	EXTI_EMR1_MR3_Msk = 0x8
	// Bit MR3.
	EXTI_EMR1_MR3 = 0x8
	// Interrupt request line is masked
	EXTI_EMR1_MR3_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_EMR1_MR3_Unmasked = 0x1
	// Position of MR4 field.
	EXTI_EMR1_MR4_Pos = 0x4
	// Bit mask of MR4 field.
	EXTI_EMR1_MR4_Msk = 0x10
	// Bit MR4.
	EXTI_EMR1_MR4 = 0x10
	// Interrupt request line is masked
	EXTI_EMR1_MR4_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_EMR1_MR4_Unmasked = 0x1
	// Position of MR5 field.
	EXTI_EMR1_MR5_Pos = 0x5
	// Bit mask of MR5 field.
	EXTI_EMR1_MR5_Msk = 0x20
	// Bit MR5.
	EXTI_EMR1_MR5 = 0x20
	// Interrupt request line is masked
	EXTI_EMR1_MR5_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_EMR1_MR5_Unmasked = 0x1
	// Position of MR6 field.
	EXTI_EMR1_MR6_Pos = 0x6
	// Bit mask of MR6 field.
	EXTI_EMR1_MR6_Msk = 0x40
	// Bit MR6.
	EXTI_EMR1_MR6 = 0x40
	// Interrupt request line is masked
	EXTI_EMR1_MR6_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_EMR1_MR6_Unmasked = 0x1
	// Position of MR7 field.
	EXTI_EMR1_MR7_Pos = 0x7
	// Bit mask of MR7 field.
	EXTI_EMR1_MR7_Msk = 0x80
	// Bit MR7.
	EXTI_EMR1_MR7 = 0x80
	// Interrupt request line is masked
	EXTI_EMR1_MR7_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_EMR1_MR7_Unmasked = 0x1
	// Position of MR8 field.
	EXTI_EMR1_MR8_Pos = 0x8
	// Bit mask of MR8 field.
	EXTI_EMR1_MR8_Msk = 0x100
	// Bit MR8.
	EXTI_EMR1_MR8 = 0x100
	// Interrupt request line is masked
	EXTI_EMR1_MR8_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_EMR1_MR8_Unmasked = 0x1
	// Position of MR9 field.
	EXTI_EMR1_MR9_Pos = 0x9
	// Bit mask of MR9 field.
	EXTI_EMR1_MR9_Msk = 0x200
	// Bit MR9.
	EXTI_EMR1_MR9 = 0x200
	// Interrupt request line is masked
	EXTI_EMR1_MR9_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_EMR1_MR9_Unmasked = 0x1
	// Position of MR10 field.
	EXTI_EMR1_MR10_Pos = 0xa
	// Bit mask of MR10 field.
	EXTI_EMR1_MR10_Msk = 0x400
	// Bit MR10.
	EXTI_EMR1_MR10 = 0x400
	// Interrupt request line is masked
	EXTI_EMR1_MR10_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_EMR1_MR10_Unmasked = 0x1
	// Position of MR11 field.
	EXTI_EMR1_MR11_Pos = 0xb
	// Bit mask of MR11 field.
	EXTI_EMR1_MR11_Msk = 0x800
	// Bit MR11.
	EXTI_EMR1_MR11 = 0x800
	// Interrupt request line is masked
	EXTI_EMR1_MR11_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_EMR1_MR11_Unmasked = 0x1
	// Position of MR12 field.
	EXTI_EMR1_MR12_Pos = 0xc
	// Bit mask of MR12 field.
	EXTI_EMR1_MR12_Msk = 0x1000
	// Bit MR12.
	EXTI_EMR1_MR12 = 0x1000
	// Interrupt request line is masked
	EXTI_EMR1_MR12_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_EMR1_MR12_Unmasked = 0x1
	// Position of MR13 field.
	EXTI_EMR1_MR13_Pos = 0xd
	// Bit mask of MR13 field.
	EXTI_EMR1_MR13_Msk = 0x2000
	// Bit MR13.
	EXTI_EMR1_MR13 = 0x2000
	// Interrupt request line is masked
	EXTI_EMR1_MR13_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_EMR1_MR13_Unmasked = 0x1
	// Position of MR14 field.
	EXTI_EMR1_MR14_Pos = 0xe
	// Bit mask of MR14 field.
	EXTI_EMR1_MR14_Msk = 0x4000
	// Bit MR14.
	EXTI_EMR1_MR14 = 0x4000
	// Interrupt request line is masked
	EXTI_EMR1_MR14_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_EMR1_MR14_Unmasked = 0x1
	// Position of MR15 field.
	EXTI_EMR1_MR15_Pos = 0xf
	// Bit mask of MR15 field.
	EXTI_EMR1_MR15_Msk = 0x8000
	// Bit MR15.
	EXTI_EMR1_MR15 = 0x8000
	// Interrupt request line is masked
	EXTI_EMR1_MR15_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_EMR1_MR15_Unmasked = 0x1
	// Position of MR16 field.
	EXTI_EMR1_MR16_Pos = 0x10
	// Bit mask of MR16 field.
	EXTI_EMR1_MR16_Msk = 0x10000
	// Bit MR16.
	EXTI_EMR1_MR16 = 0x10000
	// Interrupt request line is masked
	EXTI_EMR1_MR16_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_EMR1_MR16_Unmasked = 0x1
	// Position of MR17 field.
	EXTI_EMR1_MR17_Pos = 0x11
	// Bit mask of MR17 field.
	EXTI_EMR1_MR17_Msk = 0x20000
	// Bit MR17.
	EXTI_EMR1_MR17 = 0x20000
	// Interrupt request line is masked
	EXTI_EMR1_MR17_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_EMR1_MR17_Unmasked = 0x1
	// Position of MR18 field.
	EXTI_EMR1_MR18_Pos = 0x12
	// Bit mask of MR18 field.
	EXTI_EMR1_MR18_Msk = 0x40000
	// Bit MR18.
	EXTI_EMR1_MR18 = 0x40000
	// Interrupt request line is masked
	EXTI_EMR1_MR18_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_EMR1_MR18_Unmasked = 0x1
	// Position of MR19 field.
	EXTI_EMR1_MR19_Pos = 0x13
	// Bit mask of MR19 field.
	EXTI_EMR1_MR19_Msk = 0x80000
	// Bit MR19.
	EXTI_EMR1_MR19 = 0x80000
	// Interrupt request line is masked
	EXTI_EMR1_MR19_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_EMR1_MR19_Unmasked = 0x1
	// Position of MR20 field.
	EXTI_EMR1_MR20_Pos = 0x14
	// Bit mask of MR20 field.
	EXTI_EMR1_MR20_Msk = 0x100000
	// Bit MR20.
	EXTI_EMR1_MR20 = 0x100000
	// Interrupt request line is masked
	EXTI_EMR1_MR20_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_EMR1_MR20_Unmasked = 0x1
	// Position of MR21 field.
	EXTI_EMR1_MR21_Pos = 0x15
	// Bit mask of MR21 field.
	EXTI_EMR1_MR21_Msk = 0x200000
	// Bit MR21.
	EXTI_EMR1_MR21 = 0x200000
	// Interrupt request line is masked
	EXTI_EMR1_MR21_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_EMR1_MR21_Unmasked = 0x1
	// Position of MR22 field.
	EXTI_EMR1_MR22_Pos = 0x16
	// Bit mask of MR22 field.
	EXTI_EMR1_MR22_Msk = 0x400000
	// Bit MR22.
	EXTI_EMR1_MR22 = 0x400000
	// Interrupt request line is masked
	EXTI_EMR1_MR22_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_EMR1_MR22_Unmasked = 0x1
	// Position of MR23 field.
	EXTI_EMR1_MR23_Pos = 0x17
	// Bit mask of MR23 field.
	EXTI_EMR1_MR23_Msk = 0x800000
	// Bit MR23.
	EXTI_EMR1_MR23 = 0x800000
	// Interrupt request line is masked
	EXTI_EMR1_MR23_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_EMR1_MR23_Unmasked = 0x1
	// Position of MR24 field.
	EXTI_EMR1_MR24_Pos = 0x18
	// Bit mask of MR24 field.
	EXTI_EMR1_MR24_Msk = 0x1000000
	// Bit MR24.
	EXTI_EMR1_MR24 = 0x1000000
	// Interrupt request line is masked
	EXTI_EMR1_MR24_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_EMR1_MR24_Unmasked = 0x1
	// Position of MR25 field.
	EXTI_EMR1_MR25_Pos = 0x19
	// Bit mask of MR25 field.
	EXTI_EMR1_MR25_Msk = 0x2000000
	// Bit MR25.
	EXTI_EMR1_MR25 = 0x2000000
	// Interrupt request line is masked
	EXTI_EMR1_MR25_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_EMR1_MR25_Unmasked = 0x1
	// Position of MR26 field.
	EXTI_EMR1_MR26_Pos = 0x1a
	// Bit mask of MR26 field.
	EXTI_EMR1_MR26_Msk = 0x4000000
	// Bit MR26.
	EXTI_EMR1_MR26 = 0x4000000
	// Interrupt request line is masked
	EXTI_EMR1_MR26_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_EMR1_MR26_Unmasked = 0x1
	// Position of MR27 field.
	EXTI_EMR1_MR27_Pos = 0x1b
	// Bit mask of MR27 field.
	EXTI_EMR1_MR27_Msk = 0x8000000
	// Bit MR27.
	EXTI_EMR1_MR27 = 0x8000000
	// Interrupt request line is masked
	EXTI_EMR1_MR27_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_EMR1_MR27_Unmasked = 0x1
	// Position of MR28 field.
	EXTI_EMR1_MR28_Pos = 0x1c
	// Bit mask of MR28 field.
	EXTI_EMR1_MR28_Msk = 0x10000000
	// Bit MR28.
	EXTI_EMR1_MR28 = 0x10000000
	// Interrupt request line is masked
	EXTI_EMR1_MR28_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_EMR1_MR28_Unmasked = 0x1
	// Position of MR29 field.
	EXTI_EMR1_MR29_Pos = 0x1d
	// Bit mask of MR29 field.
	EXTI_EMR1_MR29_Msk = 0x20000000
	// Bit MR29.
	EXTI_EMR1_MR29 = 0x20000000
	// Interrupt request line is masked
	EXTI_EMR1_MR29_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_EMR1_MR29_Unmasked = 0x1
	// Position of MR30 field.
	EXTI_EMR1_MR30_Pos = 0x1e
	// Bit mask of MR30 field.
	EXTI_EMR1_MR30_Msk = 0x40000000
	// Bit MR30.
	EXTI_EMR1_MR30 = 0x40000000
	// Interrupt request line is masked
	EXTI_EMR1_MR30_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_EMR1_MR30_Unmasked = 0x1
	// Position of MR31 field.
	EXTI_EMR1_MR31_Pos = 0x1f
	// Bit mask of MR31 field.
	EXTI_EMR1_MR31_Msk = 0x80000000
	// Bit MR31.
	EXTI_EMR1_MR31 = 0x80000000
	// Interrupt request line is masked
	EXTI_EMR1_MR31_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_EMR1_MR31_Unmasked = 0x1

	// RTSR1: Rising Trigger selection register
	// Position of TR0 field.
	EXTI_RTSR1_TR0_Pos = 0x0
	// Bit mask of TR0 field.
	EXTI_RTSR1_TR0_Msk = 0x1
	// Bit TR0.
	EXTI_RTSR1_TR0 = 0x1
	// Rising edge trigger is disabled
	EXTI_RTSR1_TR0_Disabled = 0x0
	// Rising edge trigger is enabled
	EXTI_RTSR1_TR0_Enabled = 0x1
	// Position of TR1 field.
	EXTI_RTSR1_TR1_Pos = 0x1
	// Bit mask of TR1 field.
	EXTI_RTSR1_TR1_Msk = 0x2
	// Bit TR1.
	EXTI_RTSR1_TR1 = 0x2
	// Rising edge trigger is disabled
	EXTI_RTSR1_TR1_Disabled = 0x0
	// Rising edge trigger is enabled
	EXTI_RTSR1_TR1_Enabled = 0x1
	// Position of TR2 field.
	EXTI_RTSR1_TR2_Pos = 0x2
	// Bit mask of TR2 field.
	EXTI_RTSR1_TR2_Msk = 0x4
	// Bit TR2.
	EXTI_RTSR1_TR2 = 0x4
	// Rising edge trigger is disabled
	EXTI_RTSR1_TR2_Disabled = 0x0
	// Rising edge trigger is enabled
	EXTI_RTSR1_TR2_Enabled = 0x1
	// Position of TR3 field.
	EXTI_RTSR1_TR3_Pos = 0x3
	// Bit mask of TR3 field.
	EXTI_RTSR1_TR3_Msk = 0x8
	// Bit TR3.
	EXTI_RTSR1_TR3 = 0x8
	// Rising edge trigger is disabled
	EXTI_RTSR1_TR3_Disabled = 0x0
	// Rising edge trigger is enabled
	EXTI_RTSR1_TR3_Enabled = 0x1
	// Position of TR4 field.
	EXTI_RTSR1_TR4_Pos = 0x4
	// Bit mask of TR4 field.
	EXTI_RTSR1_TR4_Msk = 0x10
	// Bit TR4.
	EXTI_RTSR1_TR4 = 0x10
	// Rising edge trigger is disabled
	EXTI_RTSR1_TR4_Disabled = 0x0
	// Rising edge trigger is enabled
	EXTI_RTSR1_TR4_Enabled = 0x1
	// Position of TR5 field.
	EXTI_RTSR1_TR5_Pos = 0x5
	// Bit mask of TR5 field.
	EXTI_RTSR1_TR5_Msk = 0x20
	// Bit TR5.
	EXTI_RTSR1_TR5 = 0x20
	// Rising edge trigger is disabled
	EXTI_RTSR1_TR5_Disabled = 0x0
	// Rising edge trigger is enabled
	EXTI_RTSR1_TR5_Enabled = 0x1
	// Position of TR6 field.
	EXTI_RTSR1_TR6_Pos = 0x6
	// Bit mask of TR6 field.
	EXTI_RTSR1_TR6_Msk = 0x40
	// Bit TR6.
	EXTI_RTSR1_TR6 = 0x40
	// Rising edge trigger is disabled
	EXTI_RTSR1_TR6_Disabled = 0x0
	// Rising edge trigger is enabled
	EXTI_RTSR1_TR6_Enabled = 0x1
	// Position of TR7 field.
	EXTI_RTSR1_TR7_Pos = 0x7
	// Bit mask of TR7 field.
	EXTI_RTSR1_TR7_Msk = 0x80
	// Bit TR7.
	EXTI_RTSR1_TR7 = 0x80
	// Rising edge trigger is disabled
	EXTI_RTSR1_TR7_Disabled = 0x0
	// Rising edge trigger is enabled
	EXTI_RTSR1_TR7_Enabled = 0x1
	// Position of TR8 field.
	EXTI_RTSR1_TR8_Pos = 0x8
	// Bit mask of TR8 field.
	EXTI_RTSR1_TR8_Msk = 0x100
	// Bit TR8.
	EXTI_RTSR1_TR8 = 0x100
	// Rising edge trigger is disabled
	EXTI_RTSR1_TR8_Disabled = 0x0
	// Rising edge trigger is enabled
	EXTI_RTSR1_TR8_Enabled = 0x1
	// Position of TR9 field.
	EXTI_RTSR1_TR9_Pos = 0x9
	// Bit mask of TR9 field.
	EXTI_RTSR1_TR9_Msk = 0x200
	// Bit TR9.
	EXTI_RTSR1_TR9 = 0x200
	// Rising edge trigger is disabled
	EXTI_RTSR1_TR9_Disabled = 0x0
	// Rising edge trigger is enabled
	EXTI_RTSR1_TR9_Enabled = 0x1
	// Position of TR10 field.
	EXTI_RTSR1_TR10_Pos = 0xa
	// Bit mask of TR10 field.
	EXTI_RTSR1_TR10_Msk = 0x400
	// Bit TR10.
	EXTI_RTSR1_TR10 = 0x400
	// Rising edge trigger is disabled
	EXTI_RTSR1_TR10_Disabled = 0x0
	// Rising edge trigger is enabled
	EXTI_RTSR1_TR10_Enabled = 0x1
	// Position of TR11 field.
	EXTI_RTSR1_TR11_Pos = 0xb
	// Bit mask of TR11 field.
	EXTI_RTSR1_TR11_Msk = 0x800
	// Bit TR11.
	EXTI_RTSR1_TR11 = 0x800
	// Rising edge trigger is disabled
	EXTI_RTSR1_TR11_Disabled = 0x0
	// Rising edge trigger is enabled
	EXTI_RTSR1_TR11_Enabled = 0x1
	// Position of TR12 field.
	EXTI_RTSR1_TR12_Pos = 0xc
	// Bit mask of TR12 field.
	EXTI_RTSR1_TR12_Msk = 0x1000
	// Bit TR12.
	EXTI_RTSR1_TR12 = 0x1000
	// Rising edge trigger is disabled
	EXTI_RTSR1_TR12_Disabled = 0x0
	// Rising edge trigger is enabled
	EXTI_RTSR1_TR12_Enabled = 0x1
	// Position of TR13 field.
	EXTI_RTSR1_TR13_Pos = 0xd
	// Bit mask of TR13 field.
	EXTI_RTSR1_TR13_Msk = 0x2000
	// Bit TR13.
	EXTI_RTSR1_TR13 = 0x2000
	// Rising edge trigger is disabled
	EXTI_RTSR1_TR13_Disabled = 0x0
	// Rising edge trigger is enabled
	EXTI_RTSR1_TR13_Enabled = 0x1
	// Position of TR14 field.
	EXTI_RTSR1_TR14_Pos = 0xe
	// Bit mask of TR14 field.
	EXTI_RTSR1_TR14_Msk = 0x4000
	// Bit TR14.
	EXTI_RTSR1_TR14 = 0x4000
	// Rising edge trigger is disabled
	EXTI_RTSR1_TR14_Disabled = 0x0
	// Rising edge trigger is enabled
	EXTI_RTSR1_TR14_Enabled = 0x1
	// Position of TR15 field.
	EXTI_RTSR1_TR15_Pos = 0xf
	// Bit mask of TR15 field.
	EXTI_RTSR1_TR15_Msk = 0x8000
	// Bit TR15.
	EXTI_RTSR1_TR15 = 0x8000
	// Rising edge trigger is disabled
	EXTI_RTSR1_TR15_Disabled = 0x0
	// Rising edge trigger is enabled
	EXTI_RTSR1_TR15_Enabled = 0x1
	// Position of TR16 field.
	EXTI_RTSR1_TR16_Pos = 0x10
	// Bit mask of TR16 field.
	EXTI_RTSR1_TR16_Msk = 0x10000
	// Bit TR16.
	EXTI_RTSR1_TR16 = 0x10000
	// Rising edge trigger is disabled
	EXTI_RTSR1_TR16_Disabled = 0x0
	// Rising edge trigger is enabled
	EXTI_RTSR1_TR16_Enabled = 0x1
	// Position of TR17 field.
	EXTI_RTSR1_TR17_Pos = 0x11
	// Bit mask of TR17 field.
	EXTI_RTSR1_TR17_Msk = 0x20000
	// Bit TR17.
	EXTI_RTSR1_TR17 = 0x20000
	// Rising edge trigger is disabled
	EXTI_RTSR1_TR17_Disabled = 0x0
	// Rising edge trigger is enabled
	EXTI_RTSR1_TR17_Enabled = 0x1
	// Position of TR18 field.
	EXTI_RTSR1_TR18_Pos = 0x12
	// Bit mask of TR18 field.
	EXTI_RTSR1_TR18_Msk = 0x40000
	// Bit TR18.
	EXTI_RTSR1_TR18 = 0x40000
	// Rising edge trigger is disabled
	EXTI_RTSR1_TR18_Disabled = 0x0
	// Rising edge trigger is enabled
	EXTI_RTSR1_TR18_Enabled = 0x1
	// Position of TR19 field.
	EXTI_RTSR1_TR19_Pos = 0x13
	// Bit mask of TR19 field.
	EXTI_RTSR1_TR19_Msk = 0x80000
	// Bit TR19.
	EXTI_RTSR1_TR19 = 0x80000
	// Rising edge trigger is disabled
	EXTI_RTSR1_TR19_Disabled = 0x0
	// Rising edge trigger is enabled
	EXTI_RTSR1_TR19_Enabled = 0x1
	// Position of TR20 field.
	EXTI_RTSR1_TR20_Pos = 0x14
	// Bit mask of TR20 field.
	EXTI_RTSR1_TR20_Msk = 0x100000
	// Bit TR20.
	EXTI_RTSR1_TR20 = 0x100000
	// Rising edge trigger is disabled
	EXTI_RTSR1_TR20_Disabled = 0x0
	// Rising edge trigger is enabled
	EXTI_RTSR1_TR20_Enabled = 0x1
	// Position of TR21 field.
	EXTI_RTSR1_TR21_Pos = 0x15
	// Bit mask of TR21 field.
	EXTI_RTSR1_TR21_Msk = 0x200000
	// Bit TR21.
	EXTI_RTSR1_TR21 = 0x200000
	// Rising edge trigger is disabled
	EXTI_RTSR1_TR21_Disabled = 0x0
	// Rising edge trigger is enabled
	EXTI_RTSR1_TR21_Enabled = 0x1
	// Position of TR22 field.
	EXTI_RTSR1_TR22_Pos = 0x16
	// Bit mask of TR22 field.
	EXTI_RTSR1_TR22_Msk = 0x400000
	// Bit TR22.
	EXTI_RTSR1_TR22 = 0x400000
	// Rising edge trigger is disabled
	EXTI_RTSR1_TR22_Disabled = 0x0
	// Rising edge trigger is enabled
	EXTI_RTSR1_TR22_Enabled = 0x1
	// Position of TR29 field.
	EXTI_RTSR1_TR29_Pos = 0x1d
	// Bit mask of TR29 field.
	EXTI_RTSR1_TR29_Msk = 0x20000000
	// Bit TR29.
	EXTI_RTSR1_TR29 = 0x20000000
	// Rising edge trigger is disabled
	EXTI_RTSR1_TR29_Disabled = 0x0
	// Rising edge trigger is enabled
	EXTI_RTSR1_TR29_Enabled = 0x1
	// Position of TR30 field.
	EXTI_RTSR1_TR30_Pos = 0x1e
	// Bit mask of TR30 field.
	EXTI_RTSR1_TR30_Msk = 0x40000000
	// Bit TR30.
	EXTI_RTSR1_TR30 = 0x40000000
	// Rising edge trigger is disabled
	EXTI_RTSR1_TR30_Disabled = 0x0
	// Rising edge trigger is enabled
	EXTI_RTSR1_TR30_Enabled = 0x1
	// Position of TR31 field.
	EXTI_RTSR1_TR31_Pos = 0x1f
	// Bit mask of TR31 field.
	EXTI_RTSR1_TR31_Msk = 0x80000000
	// Bit TR31.
	EXTI_RTSR1_TR31 = 0x80000000
	// Rising edge trigger is disabled
	EXTI_RTSR1_TR31_Disabled = 0x0
	// Rising edge trigger is enabled
	EXTI_RTSR1_TR31_Enabled = 0x1

	// FTSR1: Falling Trigger selection register
	// Position of TR0 field.
	EXTI_FTSR1_TR0_Pos = 0x0
	// Bit mask of TR0 field.
	EXTI_FTSR1_TR0_Msk = 0x1
	// Bit TR0.
	EXTI_FTSR1_TR0 = 0x1
	// Falling edge trigger is disabled
	EXTI_FTSR1_TR0_Disabled = 0x0
	// Falling edge trigger is enabled
	EXTI_FTSR1_TR0_Enabled = 0x1
	// Position of TR1 field.
	EXTI_FTSR1_TR1_Pos = 0x1
	// Bit mask of TR1 field.
	EXTI_FTSR1_TR1_Msk = 0x2
	// Bit TR1.
	EXTI_FTSR1_TR1 = 0x2
	// Falling edge trigger is disabled
	EXTI_FTSR1_TR1_Disabled = 0x0
	// Falling edge trigger is enabled
	EXTI_FTSR1_TR1_Enabled = 0x1
	// Position of TR2 field.
	EXTI_FTSR1_TR2_Pos = 0x2
	// Bit mask of TR2 field.
	EXTI_FTSR1_TR2_Msk = 0x4
	// Bit TR2.
	EXTI_FTSR1_TR2 = 0x4
	// Falling edge trigger is disabled
	EXTI_FTSR1_TR2_Disabled = 0x0
	// Falling edge trigger is enabled
	EXTI_FTSR1_TR2_Enabled = 0x1
	// Position of TR3 field.
	EXTI_FTSR1_TR3_Pos = 0x3
	// Bit mask of TR3 field.
	EXTI_FTSR1_TR3_Msk = 0x8
	// Bit TR3.
	EXTI_FTSR1_TR3 = 0x8
	// Falling edge trigger is disabled
	EXTI_FTSR1_TR3_Disabled = 0x0
	// Falling edge trigger is enabled
	EXTI_FTSR1_TR3_Enabled = 0x1
	// Position of TR4 field.
	EXTI_FTSR1_TR4_Pos = 0x4
	// Bit mask of TR4 field.
	EXTI_FTSR1_TR4_Msk = 0x10
	// Bit TR4.
	EXTI_FTSR1_TR4 = 0x10
	// Falling edge trigger is disabled
	EXTI_FTSR1_TR4_Disabled = 0x0
	// Falling edge trigger is enabled
	EXTI_FTSR1_TR4_Enabled = 0x1
	// Position of TR5 field.
	EXTI_FTSR1_TR5_Pos = 0x5
	// Bit mask of TR5 field.
	EXTI_FTSR1_TR5_Msk = 0x20
	// Bit TR5.
	EXTI_FTSR1_TR5 = 0x20
	// Falling edge trigger is disabled
	EXTI_FTSR1_TR5_Disabled = 0x0
	// Falling edge trigger is enabled
	EXTI_FTSR1_TR5_Enabled = 0x1
	// Position of TR6 field.
	EXTI_FTSR1_TR6_Pos = 0x6
	// Bit mask of TR6 field.
	EXTI_FTSR1_TR6_Msk = 0x40
	// Bit TR6.
	EXTI_FTSR1_TR6 = 0x40
	// Falling edge trigger is disabled
	EXTI_FTSR1_TR6_Disabled = 0x0
	// Falling edge trigger is enabled
	EXTI_FTSR1_TR6_Enabled = 0x1
	// Position of TR7 field.
	EXTI_FTSR1_TR7_Pos = 0x7
	// Bit mask of TR7 field.
	EXTI_FTSR1_TR7_Msk = 0x80
	// Bit TR7.
	EXTI_FTSR1_TR7 = 0x80
	// Falling edge trigger is disabled
	EXTI_FTSR1_TR7_Disabled = 0x0
	// Falling edge trigger is enabled
	EXTI_FTSR1_TR7_Enabled = 0x1
	// Position of TR8 field.
	EXTI_FTSR1_TR8_Pos = 0x8
	// Bit mask of TR8 field.
	EXTI_FTSR1_TR8_Msk = 0x100
	// Bit TR8.
	EXTI_FTSR1_TR8 = 0x100
	// Falling edge trigger is disabled
	EXTI_FTSR1_TR8_Disabled = 0x0
	// Falling edge trigger is enabled
	EXTI_FTSR1_TR8_Enabled = 0x1
	// Position of TR9 field.
	EXTI_FTSR1_TR9_Pos = 0x9
	// Bit mask of TR9 field.
	EXTI_FTSR1_TR9_Msk = 0x200
	// Bit TR9.
	EXTI_FTSR1_TR9 = 0x200
	// Falling edge trigger is disabled
	EXTI_FTSR1_TR9_Disabled = 0x0
	// Falling edge trigger is enabled
	EXTI_FTSR1_TR9_Enabled = 0x1
	// Position of TR10 field.
	EXTI_FTSR1_TR10_Pos = 0xa
	// Bit mask of TR10 field.
	EXTI_FTSR1_TR10_Msk = 0x400
	// Bit TR10.
	EXTI_FTSR1_TR10 = 0x400
	// Falling edge trigger is disabled
	EXTI_FTSR1_TR10_Disabled = 0x0
	// Falling edge trigger is enabled
	EXTI_FTSR1_TR10_Enabled = 0x1
	// Position of TR11 field.
	EXTI_FTSR1_TR11_Pos = 0xb
	// Bit mask of TR11 field.
	EXTI_FTSR1_TR11_Msk = 0x800
	// Bit TR11.
	EXTI_FTSR1_TR11 = 0x800
	// Falling edge trigger is disabled
	EXTI_FTSR1_TR11_Disabled = 0x0
	// Falling edge trigger is enabled
	EXTI_FTSR1_TR11_Enabled = 0x1
	// Position of TR12 field.
	EXTI_FTSR1_TR12_Pos = 0xc
	// Bit mask of TR12 field.
	EXTI_FTSR1_TR12_Msk = 0x1000
	// Bit TR12.
	EXTI_FTSR1_TR12 = 0x1000
	// Falling edge trigger is disabled
	EXTI_FTSR1_TR12_Disabled = 0x0
	// Falling edge trigger is enabled
	EXTI_FTSR1_TR12_Enabled = 0x1
	// Position of TR13 field.
	EXTI_FTSR1_TR13_Pos = 0xd
	// Bit mask of TR13 field.
	EXTI_FTSR1_TR13_Msk = 0x2000
	// Bit TR13.
	EXTI_FTSR1_TR13 = 0x2000
	// Falling edge trigger is disabled
	EXTI_FTSR1_TR13_Disabled = 0x0
	// Falling edge trigger is enabled
	EXTI_FTSR1_TR13_Enabled = 0x1
	// Position of TR14 field.
	EXTI_FTSR1_TR14_Pos = 0xe
	// Bit mask of TR14 field.
	EXTI_FTSR1_TR14_Msk = 0x4000
	// Bit TR14.
	EXTI_FTSR1_TR14 = 0x4000
	// Falling edge trigger is disabled
	EXTI_FTSR1_TR14_Disabled = 0x0
	// Falling edge trigger is enabled
	EXTI_FTSR1_TR14_Enabled = 0x1
	// Position of TR15 field.
	EXTI_FTSR1_TR15_Pos = 0xf
	// Bit mask of TR15 field.
	EXTI_FTSR1_TR15_Msk = 0x8000
	// Bit TR15.
	EXTI_FTSR1_TR15 = 0x8000
	// Falling edge trigger is disabled
	EXTI_FTSR1_TR15_Disabled = 0x0
	// Falling edge trigger is enabled
	EXTI_FTSR1_TR15_Enabled = 0x1
	// Position of TR16 field.
	EXTI_FTSR1_TR16_Pos = 0x10
	// Bit mask of TR16 field.
	EXTI_FTSR1_TR16_Msk = 0x10000
	// Bit TR16.
	EXTI_FTSR1_TR16 = 0x10000
	// Falling edge trigger is disabled
	EXTI_FTSR1_TR16_Disabled = 0x0
	// Falling edge trigger is enabled
	EXTI_FTSR1_TR16_Enabled = 0x1
	// Position of TR17 field.
	EXTI_FTSR1_TR17_Pos = 0x11
	// Bit mask of TR17 field.
	EXTI_FTSR1_TR17_Msk = 0x20000
	// Bit TR17.
	EXTI_FTSR1_TR17 = 0x20000
	// Falling edge trigger is disabled
	EXTI_FTSR1_TR17_Disabled = 0x0
	// Falling edge trigger is enabled
	EXTI_FTSR1_TR17_Enabled = 0x1
	// Position of TR18 field.
	EXTI_FTSR1_TR18_Pos = 0x12
	// Bit mask of TR18 field.
	EXTI_FTSR1_TR18_Msk = 0x40000
	// Bit TR18.
	EXTI_FTSR1_TR18 = 0x40000
	// Falling edge trigger is disabled
	EXTI_FTSR1_TR18_Disabled = 0x0
	// Falling edge trigger is enabled
	EXTI_FTSR1_TR18_Enabled = 0x1
	// Position of TR19 field.
	EXTI_FTSR1_TR19_Pos = 0x13
	// Bit mask of TR19 field.
	EXTI_FTSR1_TR19_Msk = 0x80000
	// Bit TR19.
	EXTI_FTSR1_TR19 = 0x80000
	// Falling edge trigger is disabled
	EXTI_FTSR1_TR19_Disabled = 0x0
	// Falling edge trigger is enabled
	EXTI_FTSR1_TR19_Enabled = 0x1
	// Position of TR20 field.
	EXTI_FTSR1_TR20_Pos = 0x14
	// Bit mask of TR20 field.
	EXTI_FTSR1_TR20_Msk = 0x100000
	// Bit TR20.
	EXTI_FTSR1_TR20 = 0x100000
	// Falling edge trigger is disabled
	EXTI_FTSR1_TR20_Disabled = 0x0
	// Falling edge trigger is enabled
	EXTI_FTSR1_TR20_Enabled = 0x1
	// Position of TR21 field.
	EXTI_FTSR1_TR21_Pos = 0x15
	// Bit mask of TR21 field.
	EXTI_FTSR1_TR21_Msk = 0x200000
	// Bit TR21.
	EXTI_FTSR1_TR21 = 0x200000
	// Falling edge trigger is disabled
	EXTI_FTSR1_TR21_Disabled = 0x0
	// Falling edge trigger is enabled
	EXTI_FTSR1_TR21_Enabled = 0x1
	// Position of TR22 field.
	EXTI_FTSR1_TR22_Pos = 0x16
	// Bit mask of TR22 field.
	EXTI_FTSR1_TR22_Msk = 0x400000
	// Bit TR22.
	EXTI_FTSR1_TR22 = 0x400000
	// Falling edge trigger is disabled
	EXTI_FTSR1_TR22_Disabled = 0x0
	// Falling edge trigger is enabled
	EXTI_FTSR1_TR22_Enabled = 0x1
	// Position of TR29 field.
	EXTI_FTSR1_TR29_Pos = 0x1d
	// Bit mask of TR29 field.
	EXTI_FTSR1_TR29_Msk = 0x20000000
	// Bit TR29.
	EXTI_FTSR1_TR29 = 0x20000000
	// Falling edge trigger is disabled
	EXTI_FTSR1_TR29_Disabled = 0x0
	// Falling edge trigger is enabled
	EXTI_FTSR1_TR29_Enabled = 0x1
	// Position of TR30 field.
	EXTI_FTSR1_TR30_Pos = 0x1e
	// Bit mask of TR30 field.
	EXTI_FTSR1_TR30_Msk = 0x40000000
	// Bit TR30.
	EXTI_FTSR1_TR30 = 0x40000000
	// Falling edge trigger is disabled
	EXTI_FTSR1_TR30_Disabled = 0x0
	// Falling edge trigger is enabled
	EXTI_FTSR1_TR30_Enabled = 0x1
	// Position of TR31 field.
	EXTI_FTSR1_TR31_Pos = 0x1f
	// Bit mask of TR31 field.
	EXTI_FTSR1_TR31_Msk = 0x80000000
	// Bit TR31.
	EXTI_FTSR1_TR31 = 0x80000000
	// Falling edge trigger is disabled
	EXTI_FTSR1_TR31_Disabled = 0x0
	// Falling edge trigger is enabled
	EXTI_FTSR1_TR31_Enabled = 0x1

	// SWIER1: Software interrupt event register
	// Position of SWIER0 field.
	EXTI_SWIER1_SWIER0_Pos = 0x0
	// Bit mask of SWIER0 field.
	EXTI_SWIER1_SWIER0_Msk = 0x1
	// Bit SWIER0.
	EXTI_SWIER1_SWIER0 = 0x1
	// Generates an interrupt request
	EXTI_SWIER1_SWIER0_Pend = 0x1
	// Position of SWIER1 field.
	EXTI_SWIER1_SWIER1_Pos = 0x1
	// Bit mask of SWIER1 field.
	EXTI_SWIER1_SWIER1_Msk = 0x2
	// Bit SWIER1.
	EXTI_SWIER1_SWIER1 = 0x2
	// Generates an interrupt request
	EXTI_SWIER1_SWIER1_Pend = 0x1
	// Position of SWIER2 field.
	EXTI_SWIER1_SWIER2_Pos = 0x2
	// Bit mask of SWIER2 field.
	EXTI_SWIER1_SWIER2_Msk = 0x4
	// Bit SWIER2.
	EXTI_SWIER1_SWIER2 = 0x4
	// Generates an interrupt request
	EXTI_SWIER1_SWIER2_Pend = 0x1
	// Position of SWIER3 field.
	EXTI_SWIER1_SWIER3_Pos = 0x3
	// Bit mask of SWIER3 field.
	EXTI_SWIER1_SWIER3_Msk = 0x8
	// Bit SWIER3.
	EXTI_SWIER1_SWIER3 = 0x8
	// Generates an interrupt request
	EXTI_SWIER1_SWIER3_Pend = 0x1
	// Position of SWIER4 field.
	EXTI_SWIER1_SWIER4_Pos = 0x4
	// Bit mask of SWIER4 field.
	EXTI_SWIER1_SWIER4_Msk = 0x10
	// Bit SWIER4.
	EXTI_SWIER1_SWIER4 = 0x10
	// Generates an interrupt request
	EXTI_SWIER1_SWIER4_Pend = 0x1
	// Position of SWIER5 field.
	EXTI_SWIER1_SWIER5_Pos = 0x5
	// Bit mask of SWIER5 field.
	EXTI_SWIER1_SWIER5_Msk = 0x20
	// Bit SWIER5.
	EXTI_SWIER1_SWIER5 = 0x20
	// Generates an interrupt request
	EXTI_SWIER1_SWIER5_Pend = 0x1
	// Position of SWIER6 field.
	EXTI_SWIER1_SWIER6_Pos = 0x6
	// Bit mask of SWIER6 field.
	EXTI_SWIER1_SWIER6_Msk = 0x40
	// Bit SWIER6.
	EXTI_SWIER1_SWIER6 = 0x40
	// Generates an interrupt request
	EXTI_SWIER1_SWIER6_Pend = 0x1
	// Position of SWIER7 field.
	EXTI_SWIER1_SWIER7_Pos = 0x7
	// Bit mask of SWIER7 field.
	EXTI_SWIER1_SWIER7_Msk = 0x80
	// Bit SWIER7.
	EXTI_SWIER1_SWIER7 = 0x80
	// Generates an interrupt request
	EXTI_SWIER1_SWIER7_Pend = 0x1
	// Position of SWIER8 field.
	EXTI_SWIER1_SWIER8_Pos = 0x8
	// Bit mask of SWIER8 field.
	EXTI_SWIER1_SWIER8_Msk = 0x100
	// Bit SWIER8.
	EXTI_SWIER1_SWIER8 = 0x100
	// Generates an interrupt request
	EXTI_SWIER1_SWIER8_Pend = 0x1
	// Position of SWIER9 field.
	EXTI_SWIER1_SWIER9_Pos = 0x9
	// Bit mask of SWIER9 field.
	EXTI_SWIER1_SWIER9_Msk = 0x200
	// Bit SWIER9.
	EXTI_SWIER1_SWIER9 = 0x200
	// Generates an interrupt request
	EXTI_SWIER1_SWIER9_Pend = 0x1
	// Position of SWIER10 field.
	EXTI_SWIER1_SWIER10_Pos = 0xa
	// Bit mask of SWIER10 field.
	EXTI_SWIER1_SWIER10_Msk = 0x400
	// Bit SWIER10.
	EXTI_SWIER1_SWIER10 = 0x400
	// Generates an interrupt request
	EXTI_SWIER1_SWIER10_Pend = 0x1
	// Position of SWIER11 field.
	EXTI_SWIER1_SWIER11_Pos = 0xb
	// Bit mask of SWIER11 field.
	EXTI_SWIER1_SWIER11_Msk = 0x800
	// Bit SWIER11.
	EXTI_SWIER1_SWIER11 = 0x800
	// Generates an interrupt request
	EXTI_SWIER1_SWIER11_Pend = 0x1
	// Position of SWIER12 field.
	EXTI_SWIER1_SWIER12_Pos = 0xc
	// Bit mask of SWIER12 field.
	EXTI_SWIER1_SWIER12_Msk = 0x1000
	// Bit SWIER12.
	EXTI_SWIER1_SWIER12 = 0x1000
	// Generates an interrupt request
	EXTI_SWIER1_SWIER12_Pend = 0x1
	// Position of SWIER13 field.
	EXTI_SWIER1_SWIER13_Pos = 0xd
	// Bit mask of SWIER13 field.
	EXTI_SWIER1_SWIER13_Msk = 0x2000
	// Bit SWIER13.
	EXTI_SWIER1_SWIER13 = 0x2000
	// Generates an interrupt request
	EXTI_SWIER1_SWIER13_Pend = 0x1
	// Position of SWIER14 field.
	EXTI_SWIER1_SWIER14_Pos = 0xe
	// Bit mask of SWIER14 field.
	EXTI_SWIER1_SWIER14_Msk = 0x4000
	// Bit SWIER14.
	EXTI_SWIER1_SWIER14 = 0x4000
	// Generates an interrupt request
	EXTI_SWIER1_SWIER14_Pend = 0x1
	// Position of SWIER15 field.
	EXTI_SWIER1_SWIER15_Pos = 0xf
	// Bit mask of SWIER15 field.
	EXTI_SWIER1_SWIER15_Msk = 0x8000
	// Bit SWIER15.
	EXTI_SWIER1_SWIER15 = 0x8000
	// Generates an interrupt request
	EXTI_SWIER1_SWIER15_Pend = 0x1
	// Position of SWIER16 field.
	EXTI_SWIER1_SWIER16_Pos = 0x10
	// Bit mask of SWIER16 field.
	EXTI_SWIER1_SWIER16_Msk = 0x10000
	// Bit SWIER16.
	EXTI_SWIER1_SWIER16 = 0x10000
	// Generates an interrupt request
	EXTI_SWIER1_SWIER16_Pend = 0x1
	// Position of SWIER17 field.
	EXTI_SWIER1_SWIER17_Pos = 0x11
	// Bit mask of SWIER17 field.
	EXTI_SWIER1_SWIER17_Msk = 0x20000
	// Bit SWIER17.
	EXTI_SWIER1_SWIER17 = 0x20000
	// Generates an interrupt request
	EXTI_SWIER1_SWIER17_Pend = 0x1
	// Position of SWIER18 field.
	EXTI_SWIER1_SWIER18_Pos = 0x12
	// Bit mask of SWIER18 field.
	EXTI_SWIER1_SWIER18_Msk = 0x40000
	// Bit SWIER18.
	EXTI_SWIER1_SWIER18 = 0x40000
	// Generates an interrupt request
	EXTI_SWIER1_SWIER18_Pend = 0x1
	// Position of SWIER19 field.
	EXTI_SWIER1_SWIER19_Pos = 0x13
	// Bit mask of SWIER19 field.
	EXTI_SWIER1_SWIER19_Msk = 0x80000
	// Bit SWIER19.
	EXTI_SWIER1_SWIER19 = 0x80000
	// Generates an interrupt request
	EXTI_SWIER1_SWIER19_Pend = 0x1
	// Position of SWIER20 field.
	EXTI_SWIER1_SWIER20_Pos = 0x14
	// Bit mask of SWIER20 field.
	EXTI_SWIER1_SWIER20_Msk = 0x100000
	// Bit SWIER20.
	EXTI_SWIER1_SWIER20 = 0x100000
	// Generates an interrupt request
	EXTI_SWIER1_SWIER20_Pend = 0x1
	// Position of SWIER21 field.
	EXTI_SWIER1_SWIER21_Pos = 0x15
	// Bit mask of SWIER21 field.
	EXTI_SWIER1_SWIER21_Msk = 0x200000
	// Bit SWIER21.
	EXTI_SWIER1_SWIER21 = 0x200000
	// Generates an interrupt request
	EXTI_SWIER1_SWIER21_Pend = 0x1
	// Position of SWIER22 field.
	EXTI_SWIER1_SWIER22_Pos = 0x16
	// Bit mask of SWIER22 field.
	EXTI_SWIER1_SWIER22_Msk = 0x400000
	// Bit SWIER22.
	EXTI_SWIER1_SWIER22 = 0x400000
	// Generates an interrupt request
	EXTI_SWIER1_SWIER22_Pend = 0x1
	// Position of SWIER29 field.
	EXTI_SWIER1_SWIER29_Pos = 0x1d
	// Bit mask of SWIER29 field.
	EXTI_SWIER1_SWIER29_Msk = 0x20000000
	// Bit SWIER29.
	EXTI_SWIER1_SWIER29 = 0x20000000
	// Generates an interrupt request
	EXTI_SWIER1_SWIER29_Pend = 0x1
	// Position of SWIER30 field.
	EXTI_SWIER1_SWIER30_Pos = 0x1e
	// Bit mask of SWIER30 field.
	EXTI_SWIER1_SWIER30_Msk = 0x40000000
	// Bit SWIER30.
	EXTI_SWIER1_SWIER30 = 0x40000000
	// Generates an interrupt request
	EXTI_SWIER1_SWIER30_Pend = 0x1
	// Position of SWIER31 field.
	EXTI_SWIER1_SWIER31_Pos = 0x1f
	// Bit mask of SWIER31 field.
	EXTI_SWIER1_SWIER31_Msk = 0x80000000
	// Bit SWIER31.
	EXTI_SWIER1_SWIER31 = 0x80000000
	// Generates an interrupt request
	EXTI_SWIER1_SWIER31_Pend = 0x1

	// PR1: Pending register
	// Position of PR0 field.
	EXTI_PR1_PR0_Pos = 0x0
	// Bit mask of PR0 field.
	EXTI_PR1_PR0_Msk = 0x1
	// Bit PR0.
	EXTI_PR1_PR0 = 0x1
	// No trigger request occurred
	EXTI_PR1_PR0_NotPending = 0x0
	// Selected trigger request occurred
	EXTI_PR1_PR0_Pending = 0x1
	// Clears pending bit
	EXTI_PR1_PR0_Clear = 0x1
	// Position of PR1 field.
	EXTI_PR1_PR1_Pos = 0x1
	// Bit mask of PR1 field.
	EXTI_PR1_PR1_Msk = 0x2
	// Bit PR1.
	EXTI_PR1_PR1 = 0x2
	// No trigger request occurred
	EXTI_PR1_PR1_NotPending = 0x0
	// Selected trigger request occurred
	EXTI_PR1_PR1_Pending = 0x1
	// Clears pending bit
	EXTI_PR1_PR1_Clear = 0x1
	// Position of PR2 field.
	EXTI_PR1_PR2_Pos = 0x2
	// Bit mask of PR2 field.
	EXTI_PR1_PR2_Msk = 0x4
	// Bit PR2.
	EXTI_PR1_PR2 = 0x4
	// No trigger request occurred
	EXTI_PR1_PR2_NotPending = 0x0
	// Selected trigger request occurred
	EXTI_PR1_PR2_Pending = 0x1
	// Clears pending bit
	EXTI_PR1_PR2_Clear = 0x1
	// Position of PR3 field.
	EXTI_PR1_PR3_Pos = 0x3
	// Bit mask of PR3 field.
	EXTI_PR1_PR3_Msk = 0x8
	// Bit PR3.
	EXTI_PR1_PR3 = 0x8
	// No trigger request occurred
	EXTI_PR1_PR3_NotPending = 0x0
	// Selected trigger request occurred
	EXTI_PR1_PR3_Pending = 0x1
	// Clears pending bit
	EXTI_PR1_PR3_Clear = 0x1
	// Position of PR4 field.
	EXTI_PR1_PR4_Pos = 0x4
	// Bit mask of PR4 field.
	EXTI_PR1_PR4_Msk = 0x10
	// Bit PR4.
	EXTI_PR1_PR4 = 0x10
	// No trigger request occurred
	EXTI_PR1_PR4_NotPending = 0x0
	// Selected trigger request occurred
	EXTI_PR1_PR4_Pending = 0x1
	// Clears pending bit
	EXTI_PR1_PR4_Clear = 0x1
	// Position of PR5 field.
	EXTI_PR1_PR5_Pos = 0x5
	// Bit mask of PR5 field.
	EXTI_PR1_PR5_Msk = 0x20
	// Bit PR5.
	EXTI_PR1_PR5 = 0x20
	// No trigger request occurred
	EXTI_PR1_PR5_NotPending = 0x0
	// Selected trigger request occurred
	EXTI_PR1_PR5_Pending = 0x1
	// Clears pending bit
	EXTI_PR1_PR5_Clear = 0x1
	// Position of PR6 field.
	EXTI_PR1_PR6_Pos = 0x6
	// Bit mask of PR6 field.
	EXTI_PR1_PR6_Msk = 0x40
	// Bit PR6.
	EXTI_PR1_PR6 = 0x40
	// No trigger request occurred
	EXTI_PR1_PR6_NotPending = 0x0
	// Selected trigger request occurred
	EXTI_PR1_PR6_Pending = 0x1
	// Clears pending bit
	EXTI_PR1_PR6_Clear = 0x1
	// Position of PR7 field.
	EXTI_PR1_PR7_Pos = 0x7
	// Bit mask of PR7 field.
	EXTI_PR1_PR7_Msk = 0x80
	// Bit PR7.
	EXTI_PR1_PR7 = 0x80
	// No trigger request occurred
	EXTI_PR1_PR7_NotPending = 0x0
	// Selected trigger request occurred
	EXTI_PR1_PR7_Pending = 0x1
	// Clears pending bit
	EXTI_PR1_PR7_Clear = 0x1
	// Position of PR8 field.
	EXTI_PR1_PR8_Pos = 0x8
	// Bit mask of PR8 field.
	EXTI_PR1_PR8_Msk = 0x100
	// Bit PR8.
	EXTI_PR1_PR8 = 0x100
	// No trigger request occurred
	EXTI_PR1_PR8_NotPending = 0x0
	// Selected trigger request occurred
	EXTI_PR1_PR8_Pending = 0x1
	// Clears pending bit
	EXTI_PR1_PR8_Clear = 0x1
	// Position of PR9 field.
	EXTI_PR1_PR9_Pos = 0x9
	// Bit mask of PR9 field.
	EXTI_PR1_PR9_Msk = 0x200
	// Bit PR9.
	EXTI_PR1_PR9 = 0x200
	// No trigger request occurred
	EXTI_PR1_PR9_NotPending = 0x0
	// Selected trigger request occurred
	EXTI_PR1_PR9_Pending = 0x1
	// Clears pending bit
	EXTI_PR1_PR9_Clear = 0x1
	// Position of PR10 field.
	EXTI_PR1_PR10_Pos = 0xa
	// Bit mask of PR10 field.
	EXTI_PR1_PR10_Msk = 0x400
	// Bit PR10.
	EXTI_PR1_PR10 = 0x400
	// No trigger request occurred
	EXTI_PR1_PR10_NotPending = 0x0
	// Selected trigger request occurred
	EXTI_PR1_PR10_Pending = 0x1
	// Clears pending bit
	EXTI_PR1_PR10_Clear = 0x1
	// Position of PR11 field.
	EXTI_PR1_PR11_Pos = 0xb
	// Bit mask of PR11 field.
	EXTI_PR1_PR11_Msk = 0x800
	// Bit PR11.
	EXTI_PR1_PR11 = 0x800
	// No trigger request occurred
	EXTI_PR1_PR11_NotPending = 0x0
	// Selected trigger request occurred
	EXTI_PR1_PR11_Pending = 0x1
	// Clears pending bit
	EXTI_PR1_PR11_Clear = 0x1
	// Position of PR12 field.
	EXTI_PR1_PR12_Pos = 0xc
	// Bit mask of PR12 field.
	EXTI_PR1_PR12_Msk = 0x1000
	// Bit PR12.
	EXTI_PR1_PR12 = 0x1000
	// No trigger request occurred
	EXTI_PR1_PR12_NotPending = 0x0
	// Selected trigger request occurred
	EXTI_PR1_PR12_Pending = 0x1
	// Clears pending bit
	EXTI_PR1_PR12_Clear = 0x1
	// Position of PR13 field.
	EXTI_PR1_PR13_Pos = 0xd
	// Bit mask of PR13 field.
	EXTI_PR1_PR13_Msk = 0x2000
	// Bit PR13.
	EXTI_PR1_PR13 = 0x2000
	// No trigger request occurred
	EXTI_PR1_PR13_NotPending = 0x0
	// Selected trigger request occurred
	EXTI_PR1_PR13_Pending = 0x1
	// Clears pending bit
	EXTI_PR1_PR13_Clear = 0x1
	// Position of PR14 field.
	EXTI_PR1_PR14_Pos = 0xe
	// Bit mask of PR14 field.
	EXTI_PR1_PR14_Msk = 0x4000
	// Bit PR14.
	EXTI_PR1_PR14 = 0x4000
	// No trigger request occurred
	EXTI_PR1_PR14_NotPending = 0x0
	// Selected trigger request occurred
	EXTI_PR1_PR14_Pending = 0x1
	// Clears pending bit
	EXTI_PR1_PR14_Clear = 0x1
	// Position of PR15 field.
	EXTI_PR1_PR15_Pos = 0xf
	// Bit mask of PR15 field.
	EXTI_PR1_PR15_Msk = 0x8000
	// Bit PR15.
	EXTI_PR1_PR15 = 0x8000
	// No trigger request occurred
	EXTI_PR1_PR15_NotPending = 0x0
	// Selected trigger request occurred
	EXTI_PR1_PR15_Pending = 0x1
	// Clears pending bit
	EXTI_PR1_PR15_Clear = 0x1
	// Position of PR16 field.
	EXTI_PR1_PR16_Pos = 0x10
	// Bit mask of PR16 field.
	EXTI_PR1_PR16_Msk = 0x10000
	// Bit PR16.
	EXTI_PR1_PR16 = 0x10000
	// No trigger request occurred
	EXTI_PR1_PR16_NotPending = 0x0
	// Selected trigger request occurred
	EXTI_PR1_PR16_Pending = 0x1
	// Clears pending bit
	EXTI_PR1_PR16_Clear = 0x1
	// Position of PR17 field.
	EXTI_PR1_PR17_Pos = 0x11
	// Bit mask of PR17 field.
	EXTI_PR1_PR17_Msk = 0x20000
	// Bit PR17.
	EXTI_PR1_PR17 = 0x20000
	// No trigger request occurred
	EXTI_PR1_PR17_NotPending = 0x0
	// Selected trigger request occurred
	EXTI_PR1_PR17_Pending = 0x1
	// Clears pending bit
	EXTI_PR1_PR17_Clear = 0x1
	// Position of PR18 field.
	EXTI_PR1_PR18_Pos = 0x12
	// Bit mask of PR18 field.
	EXTI_PR1_PR18_Msk = 0x40000
	// Bit PR18.
	EXTI_PR1_PR18 = 0x40000
	// No trigger request occurred
	EXTI_PR1_PR18_NotPending = 0x0
	// Selected trigger request occurred
	EXTI_PR1_PR18_Pending = 0x1
	// Clears pending bit
	EXTI_PR1_PR18_Clear = 0x1
	// Position of PR19 field.
	EXTI_PR1_PR19_Pos = 0x13
	// Bit mask of PR19 field.
	EXTI_PR1_PR19_Msk = 0x80000
	// Bit PR19.
	EXTI_PR1_PR19 = 0x80000
	// No trigger request occurred
	EXTI_PR1_PR19_NotPending = 0x0
	// Selected trigger request occurred
	EXTI_PR1_PR19_Pending = 0x1
	// Clears pending bit
	EXTI_PR1_PR19_Clear = 0x1
	// Position of PR20 field.
	EXTI_PR1_PR20_Pos = 0x14
	// Bit mask of PR20 field.
	EXTI_PR1_PR20_Msk = 0x100000
	// Bit PR20.
	EXTI_PR1_PR20 = 0x100000
	// No trigger request occurred
	EXTI_PR1_PR20_NotPending = 0x0
	// Selected trigger request occurred
	EXTI_PR1_PR20_Pending = 0x1
	// Clears pending bit
	EXTI_PR1_PR20_Clear = 0x1
	// Position of PR21 field.
	EXTI_PR1_PR21_Pos = 0x15
	// Bit mask of PR21 field.
	EXTI_PR1_PR21_Msk = 0x200000
	// Bit PR21.
	EXTI_PR1_PR21 = 0x200000
	// No trigger request occurred
	EXTI_PR1_PR21_NotPending = 0x0
	// Selected trigger request occurred
	EXTI_PR1_PR21_Pending = 0x1
	// Clears pending bit
	EXTI_PR1_PR21_Clear = 0x1
	// Position of PR22 field.
	EXTI_PR1_PR22_Pos = 0x16
	// Bit mask of PR22 field.
	EXTI_PR1_PR22_Msk = 0x400000
	// Bit PR22.
	EXTI_PR1_PR22 = 0x400000
	// No trigger request occurred
	EXTI_PR1_PR22_NotPending = 0x0
	// Selected trigger request occurred
	EXTI_PR1_PR22_Pending = 0x1
	// Clears pending bit
	EXTI_PR1_PR22_Clear = 0x1
	// Position of PR29 field.
	EXTI_PR1_PR29_Pos = 0x1d
	// Bit mask of PR29 field.
	EXTI_PR1_PR29_Msk = 0x20000000
	// Bit PR29.
	EXTI_PR1_PR29 = 0x20000000
	// No trigger request occurred
	EXTI_PR1_PR29_NotPending = 0x0
	// Selected trigger request occurred
	EXTI_PR1_PR29_Pending = 0x1
	// Clears pending bit
	EXTI_PR1_PR29_Clear = 0x1
	// Position of PR30 field.
	EXTI_PR1_PR30_Pos = 0x1e
	// Bit mask of PR30 field.
	EXTI_PR1_PR30_Msk = 0x40000000
	// Bit PR30.
	EXTI_PR1_PR30 = 0x40000000
	// No trigger request occurred
	EXTI_PR1_PR30_NotPending = 0x0
	// Selected trigger request occurred
	EXTI_PR1_PR30_Pending = 0x1
	// Clears pending bit
	EXTI_PR1_PR30_Clear = 0x1
	// Position of PR31 field.
	EXTI_PR1_PR31_Pos = 0x1f
	// Bit mask of PR31 field.
	EXTI_PR1_PR31_Msk = 0x80000000
	// Bit PR31.
	EXTI_PR1_PR31 = 0x80000000
	// No trigger request occurred
	EXTI_PR1_PR31_NotPending = 0x0
	// Selected trigger request occurred
	EXTI_PR1_PR31_Pending = 0x1
	// Clears pending bit
	EXTI_PR1_PR31_Clear = 0x1

	// IMR2: Interrupt mask register
	// Position of MR32 field.
	EXTI_IMR2_MR32_Pos = 0x0
	// Bit mask of MR32 field.
	EXTI_IMR2_MR32_Msk = 0x1
	// Bit MR32.
	EXTI_IMR2_MR32 = 0x1
	// Interrupt request line is masked
	EXTI_IMR2_MR32_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_IMR2_MR32_Unmasked = 0x1
	// Position of MR33 field.
	EXTI_IMR2_MR33_Pos = 0x1
	// Bit mask of MR33 field.
	EXTI_IMR2_MR33_Msk = 0x2
	// Bit MR33.
	EXTI_IMR2_MR33 = 0x2
	// Interrupt request line is masked
	EXTI_IMR2_MR33_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_IMR2_MR33_Unmasked = 0x1
	// Position of MR34 field.
	EXTI_IMR2_MR34_Pos = 0x2
	// Bit mask of MR34 field.
	EXTI_IMR2_MR34_Msk = 0x4
	// Bit MR34.
	EXTI_IMR2_MR34 = 0x4
	// Interrupt request line is masked
	EXTI_IMR2_MR34_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_IMR2_MR34_Unmasked = 0x1
	// Position of MR35 field.
	EXTI_IMR2_MR35_Pos = 0x3
	// Bit mask of MR35 field.
	EXTI_IMR2_MR35_Msk = 0x8
	// Bit MR35.
	EXTI_IMR2_MR35 = 0x8
	// Interrupt request line is masked
	EXTI_IMR2_MR35_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_IMR2_MR35_Unmasked = 0x1

	// EMR2: Event mask register
	// Position of MR32 field.
	EXTI_EMR2_MR32_Pos = 0x0
	// Bit mask of MR32 field.
	EXTI_EMR2_MR32_Msk = 0x1
	// Bit MR32.
	EXTI_EMR2_MR32 = 0x1
	// Interrupt request line is masked
	EXTI_EMR2_MR32_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_EMR2_MR32_Unmasked = 0x1
	// Position of MR33 field.
	EXTI_EMR2_MR33_Pos = 0x1
	// Bit mask of MR33 field.
	EXTI_EMR2_MR33_Msk = 0x2
	// Bit MR33.
	EXTI_EMR2_MR33 = 0x2
	// Interrupt request line is masked
	EXTI_EMR2_MR33_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_EMR2_MR33_Unmasked = 0x1
	// Position of MR34 field.
	EXTI_EMR2_MR34_Pos = 0x2
	// Bit mask of MR34 field.
	EXTI_EMR2_MR34_Msk = 0x4
	// Bit MR34.
	EXTI_EMR2_MR34 = 0x4
	// Interrupt request line is masked
	EXTI_EMR2_MR34_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_EMR2_MR34_Unmasked = 0x1
	// Position of MR35 field.
	EXTI_EMR2_MR35_Pos = 0x3
	// Bit mask of MR35 field.
	EXTI_EMR2_MR35_Msk = 0x8
	// Bit MR35.
	EXTI_EMR2_MR35 = 0x8
	// Interrupt request line is masked
	EXTI_EMR2_MR35_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_EMR2_MR35_Unmasked = 0x1

	// RTSR2: Rising Trigger selection register
	// Position of TR32 field.
	EXTI_RTSR2_TR32_Pos = 0x0
	// Bit mask of TR32 field.
	EXTI_RTSR2_TR32_Msk = 0x1
	// Bit TR32.
	EXTI_RTSR2_TR32 = 0x1
	// Rising edge trigger is disabled
	EXTI_RTSR2_TR32_Disabled = 0x0
	// Rising edge trigger is enabled
	EXTI_RTSR2_TR32_Enabled = 0x1
	// Position of TR33 field.
	EXTI_RTSR2_TR33_Pos = 0x1
	// Bit mask of TR33 field.
	EXTI_RTSR2_TR33_Msk = 0x2
	// Bit TR33.
	EXTI_RTSR2_TR33 = 0x2
	// Rising edge trigger is disabled
	EXTI_RTSR2_TR33_Disabled = 0x0
	// Rising edge trigger is enabled
	EXTI_RTSR2_TR33_Enabled = 0x1

	// FTSR2: Falling Trigger selection register
	// Position of TR32 field.
	EXTI_FTSR2_TR32_Pos = 0x0
	// Bit mask of TR32 field.
	EXTI_FTSR2_TR32_Msk = 0x1
	// Bit TR32.
	EXTI_FTSR2_TR32 = 0x1
	// Falling edge trigger is disabled
	EXTI_FTSR2_TR32_Disabled = 0x0
	// Falling edge trigger is enabled
	EXTI_FTSR2_TR32_Enabled = 0x1
	// Position of TR33 field.
	EXTI_FTSR2_TR33_Pos = 0x1
	// Bit mask of TR33 field.
	EXTI_FTSR2_TR33_Msk = 0x2
	// Bit TR33.
	EXTI_FTSR2_TR33 = 0x2
	// Falling edge trigger is disabled
	EXTI_FTSR2_TR33_Disabled = 0x0
	// Falling edge trigger is enabled
	EXTI_FTSR2_TR33_Enabled = 0x1

	// SWIER2: Software interrupt event register
	// Position of SWIER32 field.
	EXTI_SWIER2_SWIER32_Pos = 0x0
	// Bit mask of SWIER32 field.
	EXTI_SWIER2_SWIER32_Msk = 0x1
	// Bit SWIER32.
	EXTI_SWIER2_SWIER32 = 0x1
	// Generates an interrupt request
	EXTI_SWIER2_SWIER32_Pend = 0x1
	// Position of SWIER33 field.
	EXTI_SWIER2_SWIER33_Pos = 0x1
	// Bit mask of SWIER33 field.
	EXTI_SWIER2_SWIER33_Msk = 0x2
	// Bit SWIER33.
	EXTI_SWIER2_SWIER33 = 0x2
	// Generates an interrupt request
	EXTI_SWIER2_SWIER33_Pend = 0x1

	// PR2: Pending register
	// Position of PR32 field.
	EXTI_PR2_PR32_Pos = 0x0
	// Bit mask of PR32 field.
	EXTI_PR2_PR32_Msk = 0x1
	// Bit PR32.
	EXTI_PR2_PR32 = 0x1
	// No trigger request occurred
	EXTI_PR2_PR32_NotPending = 0x0
	// Selected trigger request occurred
	EXTI_PR2_PR32_Pending = 0x1
	// Clears pending bit
	EXTI_PR2_PR32_Clear = 0x1
	// Position of PR33 field.
	EXTI_PR2_PR33_Pos = 0x1
	// Bit mask of PR33 field.
	EXTI_PR2_PR33_Msk = 0x2
	// Bit PR33.
	EXTI_PR2_PR33 = 0x2
	// No trigger request occurred
	EXTI_PR2_PR33_NotPending = 0x0
	// Selected trigger request occurred
	EXTI_PR2_PR33_Pending = 0x1
	// Clears pending bit
	EXTI_PR2_PR33_Clear = 0x1
)

// Bitfields for PWR: Power control
const (
	// CR: power control register
	// Position of LPDS field.
	PWR_CR_LPDS_Pos = 0x0
	// Bit mask of LPDS field.
	PWR_CR_LPDS_Msk = 0x1
	// Bit LPDS.
	PWR_CR_LPDS = 0x1
	// Position of PDDS field.
	PWR_CR_PDDS_Pos = 0x1
	// Bit mask of PDDS field.
	PWR_CR_PDDS_Msk = 0x2
	// Bit PDDS.
	PWR_CR_PDDS = 0x2
	// Position of CWUF field.
	PWR_CR_CWUF_Pos = 0x2
	// Bit mask of CWUF field.
	PWR_CR_CWUF_Msk = 0x4
	// Bit CWUF.
	PWR_CR_CWUF = 0x4
	// Position of CSBF field.
	PWR_CR_CSBF_Pos = 0x3
	// Bit mask of CSBF field.
	PWR_CR_CSBF_Msk = 0x8
	// Bit CSBF.
	PWR_CR_CSBF = 0x8
	// Position of PVDE field.
	PWR_CR_PVDE_Pos = 0x4
	// Bit mask of PVDE field.
	PWR_CR_PVDE_Msk = 0x10
	// Bit PVDE.
	PWR_CR_PVDE = 0x10
	// Position of PLS field.
	PWR_CR_PLS_Pos = 0x5
	// Bit mask of PLS field.
	PWR_CR_PLS_Msk = 0xe0
	// Position of DBP field.
	PWR_CR_DBP_Pos = 0x8
	// Bit mask of DBP field.
	PWR_CR_DBP_Msk = 0x100
	// Bit DBP.
	PWR_CR_DBP = 0x100

	// CSR: power control/status register
	// Position of WUF field.
	PWR_CSR_WUF_Pos = 0x0
	// Bit mask of WUF field.
	PWR_CSR_WUF_Msk = 0x1
	// Bit WUF.
	PWR_CSR_WUF = 0x1
	// Position of SBF field.
	PWR_CSR_SBF_Pos = 0x1
	// Bit mask of SBF field.
	PWR_CSR_SBF_Msk = 0x2
	// Bit SBF.
	PWR_CSR_SBF = 0x2
	// Position of PVDO field.
	PWR_CSR_PVDO_Pos = 0x2
	// Bit mask of PVDO field.
	PWR_CSR_PVDO_Msk = 0x4
	// Bit PVDO.
	PWR_CSR_PVDO = 0x4
	// Position of EWUP1 field.
	PWR_CSR_EWUP1_Pos = 0x8
	// Bit mask of EWUP1 field.
	PWR_CSR_EWUP1_Msk = 0x100
	// Bit EWUP1.
	PWR_CSR_EWUP1 = 0x100
	// Position of EWUP2 field.
	PWR_CSR_EWUP2_Pos = 0x9
	// Bit mask of EWUP2 field.
	PWR_CSR_EWUP2_Msk = 0x200
	// Bit EWUP2.
	PWR_CSR_EWUP2 = 0x200
)

// Bitfields for CAN: Controller area network
const (
	// MCR: master control register
	// Position of DBF field.
	CAN_MCR_DBF_Pos = 0x10
	// Bit mask of DBF field.
	CAN_MCR_DBF_Msk = 0x10000
	// Bit DBF.
	CAN_MCR_DBF = 0x10000
	// Position of RESET field.
	CAN_MCR_RESET_Pos = 0xf
	// Bit mask of RESET field.
	CAN_MCR_RESET_Msk = 0x8000
	// Bit RESET.
	CAN_MCR_RESET = 0x8000
	// Position of TTCM field.
	CAN_MCR_TTCM_Pos = 0x7
	// Bit mask of TTCM field.
	CAN_MCR_TTCM_Msk = 0x80
	// Bit TTCM.
	CAN_MCR_TTCM = 0x80
	// Position of ABOM field.
	CAN_MCR_ABOM_Pos = 0x6
	// Bit mask of ABOM field.
	CAN_MCR_ABOM_Msk = 0x40
	// Bit ABOM.
	CAN_MCR_ABOM = 0x40
	// Position of AWUM field.
	CAN_MCR_AWUM_Pos = 0x5
	// Bit mask of AWUM field.
	CAN_MCR_AWUM_Msk = 0x20
	// Bit AWUM.
	CAN_MCR_AWUM = 0x20
	// Position of NART field.
	CAN_MCR_NART_Pos = 0x4
	// Bit mask of NART field.
	CAN_MCR_NART_Msk = 0x10
	// Bit NART.
	CAN_MCR_NART = 0x10
	// Position of RFLM field.
	CAN_MCR_RFLM_Pos = 0x3
	// Bit mask of RFLM field.
	CAN_MCR_RFLM_Msk = 0x8
	// Bit RFLM.
	CAN_MCR_RFLM = 0x8
	// Position of TXFP field.
	CAN_MCR_TXFP_Pos = 0x2
	// Bit mask of TXFP field.
	CAN_MCR_TXFP_Msk = 0x4
	// Bit TXFP.
	CAN_MCR_TXFP = 0x4
	// Position of SLEEP field.
	CAN_MCR_SLEEP_Pos = 0x1
	// Bit mask of SLEEP field.
	CAN_MCR_SLEEP_Msk = 0x2
	// Bit SLEEP.
	CAN_MCR_SLEEP = 0x2
	// Position of INRQ field.
	CAN_MCR_INRQ_Pos = 0x0
	// Bit mask of INRQ field.
	CAN_MCR_INRQ_Msk = 0x1
	// Bit INRQ.
	CAN_MCR_INRQ = 0x1

	// MSR: master status register
	// Position of RX field.
	CAN_MSR_RX_Pos = 0xb
	// Bit mask of RX field.
	CAN_MSR_RX_Msk = 0x800
	// Bit RX.
	CAN_MSR_RX = 0x800
	// Position of SAMP field.
	CAN_MSR_SAMP_Pos = 0xa
	// Bit mask of SAMP field.
	CAN_MSR_SAMP_Msk = 0x400
	// Bit SAMP.
	CAN_MSR_SAMP = 0x400
	// Position of RXM field.
	CAN_MSR_RXM_Pos = 0x9
	// Bit mask of RXM field.
	CAN_MSR_RXM_Msk = 0x200
	// Bit RXM.
	CAN_MSR_RXM = 0x200
	// Position of TXM field.
	CAN_MSR_TXM_Pos = 0x8
	// Bit mask of TXM field.
	CAN_MSR_TXM_Msk = 0x100
	// Bit TXM.
	CAN_MSR_TXM = 0x100
	// Position of SLAKI field.
	CAN_MSR_SLAKI_Pos = 0x4
	// Bit mask of SLAKI field.
	CAN_MSR_SLAKI_Msk = 0x10
	// Bit SLAKI.
	CAN_MSR_SLAKI = 0x10
	// Position of WKUI field.
	CAN_MSR_WKUI_Pos = 0x3
	// Bit mask of WKUI field.
	CAN_MSR_WKUI_Msk = 0x8
	// Bit WKUI.
	CAN_MSR_WKUI = 0x8
	// Position of ERRI field.
	CAN_MSR_ERRI_Pos = 0x2
	// Bit mask of ERRI field.
	CAN_MSR_ERRI_Msk = 0x4
	// Bit ERRI.
	CAN_MSR_ERRI = 0x4
	// Position of SLAK field.
	CAN_MSR_SLAK_Pos = 0x1
	// Bit mask of SLAK field.
	CAN_MSR_SLAK_Msk = 0x2
	// Bit SLAK.
	CAN_MSR_SLAK = 0x2
	// Position of INAK field.
	CAN_MSR_INAK_Pos = 0x0
	// Bit mask of INAK field.
	CAN_MSR_INAK_Msk = 0x1
	// Bit INAK.
	CAN_MSR_INAK = 0x1

	// TSR: transmit status register
	// Position of LOW2 field.
	CAN_TSR_LOW2_Pos = 0x1f
	// Bit mask of LOW2 field.
	CAN_TSR_LOW2_Msk = 0x80000000
	// Bit LOW2.
	CAN_TSR_LOW2 = 0x80000000
	// Position of LOW1 field.
	CAN_TSR_LOW1_Pos = 0x1e
	// Bit mask of LOW1 field.
	CAN_TSR_LOW1_Msk = 0x40000000
	// Bit LOW1.
	CAN_TSR_LOW1 = 0x40000000
	// Position of LOW0 field.
	CAN_TSR_LOW0_Pos = 0x1d
	// Bit mask of LOW0 field.
	CAN_TSR_LOW0_Msk = 0x20000000
	// Bit LOW0.
	CAN_TSR_LOW0 = 0x20000000
	// Position of TME2 field.
	CAN_TSR_TME2_Pos = 0x1c
	// Bit mask of TME2 field.
	CAN_TSR_TME2_Msk = 0x10000000
	// Bit TME2.
	CAN_TSR_TME2 = 0x10000000
	// Position of TME1 field.
	CAN_TSR_TME1_Pos = 0x1b
	// Bit mask of TME1 field.
	CAN_TSR_TME1_Msk = 0x8000000
	// Bit TME1.
	CAN_TSR_TME1 = 0x8000000
	// Position of TME0 field.
	CAN_TSR_TME0_Pos = 0x1a
	// Bit mask of TME0 field.
	CAN_TSR_TME0_Msk = 0x4000000
	// Bit TME0.
	CAN_TSR_TME0 = 0x4000000
	// Position of CODE field.
	CAN_TSR_CODE_Pos = 0x18
	// Bit mask of CODE field.
	CAN_TSR_CODE_Msk = 0x3000000
	// Position of ABRQ2 field.
	CAN_TSR_ABRQ2_Pos = 0x17
	// Bit mask of ABRQ2 field.
	CAN_TSR_ABRQ2_Msk = 0x800000
	// Bit ABRQ2.
	CAN_TSR_ABRQ2 = 0x800000
	// Position of TERR2 field.
	CAN_TSR_TERR2_Pos = 0x13
	// Bit mask of TERR2 field.
	CAN_TSR_TERR2_Msk = 0x80000
	// Bit TERR2.
	CAN_TSR_TERR2 = 0x80000
	// Position of ALST2 field.
	CAN_TSR_ALST2_Pos = 0x12
	// Bit mask of ALST2 field.
	CAN_TSR_ALST2_Msk = 0x40000
	// Bit ALST2.
	CAN_TSR_ALST2 = 0x40000
	// Position of TXOK2 field.
	CAN_TSR_TXOK2_Pos = 0x11
	// Bit mask of TXOK2 field.
	CAN_TSR_TXOK2_Msk = 0x20000
	// Bit TXOK2.
	CAN_TSR_TXOK2 = 0x20000
	// Position of RQCP2 field.
	CAN_TSR_RQCP2_Pos = 0x10
	// Bit mask of RQCP2 field.
	CAN_TSR_RQCP2_Msk = 0x10000
	// Bit RQCP2.
	CAN_TSR_RQCP2 = 0x10000
	// Position of ABRQ1 field.
	CAN_TSR_ABRQ1_Pos = 0xf
	// Bit mask of ABRQ1 field.
	CAN_TSR_ABRQ1_Msk = 0x8000
	// Bit ABRQ1.
	CAN_TSR_ABRQ1 = 0x8000
	// Position of TERR1 field.
	CAN_TSR_TERR1_Pos = 0xb
	// Bit mask of TERR1 field.
	CAN_TSR_TERR1_Msk = 0x800
	// Bit TERR1.
	CAN_TSR_TERR1 = 0x800
	// Position of ALST1 field.
	CAN_TSR_ALST1_Pos = 0xa
	// Bit mask of ALST1 field.
	CAN_TSR_ALST1_Msk = 0x400
	// Bit ALST1.
	CAN_TSR_ALST1 = 0x400
	// Position of TXOK1 field.
	CAN_TSR_TXOK1_Pos = 0x9
	// Bit mask of TXOK1 field.
	CAN_TSR_TXOK1_Msk = 0x200
	// Bit TXOK1.
	CAN_TSR_TXOK1 = 0x200
	// Position of RQCP1 field.
	CAN_TSR_RQCP1_Pos = 0x8
	// Bit mask of RQCP1 field.
	CAN_TSR_RQCP1_Msk = 0x100
	// Bit RQCP1.
	CAN_TSR_RQCP1 = 0x100
	// Position of ABRQ0 field.
	CAN_TSR_ABRQ0_Pos = 0x7
	// Bit mask of ABRQ0 field.
	CAN_TSR_ABRQ0_Msk = 0x80
	// Bit ABRQ0.
	CAN_TSR_ABRQ0 = 0x80
	// Position of TERR0 field.
	CAN_TSR_TERR0_Pos = 0x3
	// Bit mask of TERR0 field.
	CAN_TSR_TERR0_Msk = 0x8
	// Bit TERR0.
	CAN_TSR_TERR0 = 0x8
	// Position of ALST0 field.
	CAN_TSR_ALST0_Pos = 0x2
	// Bit mask of ALST0 field.
	CAN_TSR_ALST0_Msk = 0x4
	// Bit ALST0.
	CAN_TSR_ALST0 = 0x4
	// Position of TXOK0 field.
	CAN_TSR_TXOK0_Pos = 0x1
	// Bit mask of TXOK0 field.
	CAN_TSR_TXOK0_Msk = 0x2
	// Bit TXOK0.
	CAN_TSR_TXOK0 = 0x2
	// Position of RQCP0 field.
	CAN_TSR_RQCP0_Pos = 0x0
	// Bit mask of RQCP0 field.
	CAN_TSR_RQCP0_Msk = 0x1
	// Bit RQCP0.
	CAN_TSR_RQCP0 = 0x1

	// RF0R: receive FIFO 0 register
	// Position of RFOM field.
	CAN_RFR_RFOM_Pos = 0x5
	// Bit mask of RFOM field.
	CAN_RFR_RFOM_Msk = 0x20
	// Bit RFOM.
	CAN_RFR_RFOM = 0x20
	// Set by software to release the output mailbox of the FIFO
	CAN_RFR_RFOM_Release = 0x1
	// Position of FOVR field.
	CAN_RFR_FOVR_Pos = 0x4
	// Bit mask of FOVR field.
	CAN_RFR_FOVR_Msk = 0x10
	// Bit FOVR.
	CAN_RFR_FOVR = 0x10
	// No FIFO x overrun
	CAN_RFR_FOVR_NoOverrun = 0x0
	// FIFO x overrun
	CAN_RFR_FOVR_Overrun = 0x1
	// Clear flag
	CAN_RFR_FOVR_Clear = 0x1
	// Position of FULL field.
	CAN_RFR_FULL_Pos = 0x3
	// Bit mask of FULL field.
	CAN_RFR_FULL_Msk = 0x8
	// Bit FULL.
	CAN_RFR_FULL = 0x8
	// FIFO x is not full
	CAN_RFR_FULL_NotFull = 0x0
	// FIFO x is full
	CAN_RFR_FULL_Full = 0x1
	// Clear flag
	CAN_RFR_FULL_Clear = 0x1
	// Position of FMP field.
	CAN_RFR_FMP_Pos = 0x0
	// Bit mask of FMP field.
	CAN_RFR_FMP_Msk = 0x3

	// IER: interrupt enable register
	// Position of SLKIE field.
	CAN_IER_SLKIE_Pos = 0x11
	// Bit mask of SLKIE field.
	CAN_IER_SLKIE_Msk = 0x20000
	// Bit SLKIE.
	CAN_IER_SLKIE = 0x20000
	// No interrupt when SLAKI bit is set
	CAN_IER_SLKIE_Disabled = 0x0
	// Interrupt generated when SLAKI bit is set
	CAN_IER_SLKIE_Enabled = 0x1
	// Position of WKUIE field.
	CAN_IER_WKUIE_Pos = 0x10
	// Bit mask of WKUIE field.
	CAN_IER_WKUIE_Msk = 0x10000
	// Bit WKUIE.
	CAN_IER_WKUIE = 0x10000
	// No interrupt when WKUI is set
	CAN_IER_WKUIE_Disabled = 0x0
	// Interrupt generated when WKUI bit is set
	CAN_IER_WKUIE_Enabled = 0x1
	// Position of ERRIE field.
	CAN_IER_ERRIE_Pos = 0xf
	// Bit mask of ERRIE field.
	CAN_IER_ERRIE_Msk = 0x8000
	// Bit ERRIE.
	CAN_IER_ERRIE = 0x8000
	// No interrupt will be generated when an error condition is pending in the CAN_ESR
	CAN_IER_ERRIE_Disabled = 0x0
	// An interrupt will be generation when an error condition is pending in the CAN_ESR
	CAN_IER_ERRIE_Enabled = 0x1
	// Position of LECIE field.
	CAN_IER_LECIE_Pos = 0xb
	// Bit mask of LECIE field.
	CAN_IER_LECIE_Msk = 0x800
	// Bit LECIE.
	CAN_IER_LECIE = 0x800
	// ERRI bit will not be set when the error code in LEC[2:0] is set by hardware on error detection
	CAN_IER_LECIE_Disabled = 0x0
	// ERRI bit will be set when the error code in LEC[2:0] is set by hardware on error detection
	CAN_IER_LECIE_Enabled = 0x1
	// Position of BOFIE field.
	CAN_IER_BOFIE_Pos = 0xa
	// Bit mask of BOFIE field.
	CAN_IER_BOFIE_Msk = 0x400
	// Bit BOFIE.
	CAN_IER_BOFIE = 0x400
	// ERRI bit will not be set when BOFF is set
	CAN_IER_BOFIE_Disabled = 0x0
	// ERRI bit will be set when BOFF is set
	CAN_IER_BOFIE_Enabled = 0x1
	// Position of EPVIE field.
	CAN_IER_EPVIE_Pos = 0x9
	// Bit mask of EPVIE field.
	CAN_IER_EPVIE_Msk = 0x200
	// Bit EPVIE.
	CAN_IER_EPVIE = 0x200
	// ERRI bit will not be set when EPVF is set
	CAN_IER_EPVIE_Disabled = 0x0
	// ERRI bit will be set when EPVF is set
	CAN_IER_EPVIE_Enabled = 0x1
	// Position of EWGIE field.
	CAN_IER_EWGIE_Pos = 0x8
	// Bit mask of EWGIE field.
	CAN_IER_EWGIE_Msk = 0x100
	// Bit EWGIE.
	CAN_IER_EWGIE = 0x100
	// ERRI bit will not be set when EWGF is set
	CAN_IER_EWGIE_Disabled = 0x0
	// ERRI bit will be set when EWGF is set
	CAN_IER_EWGIE_Enabled = 0x1
	// Position of FOVIE1 field.
	CAN_IER_FOVIE1_Pos = 0x6
	// Bit mask of FOVIE1 field.
	CAN_IER_FOVIE1_Msk = 0x40
	// Bit FOVIE1.
	CAN_IER_FOVIE1 = 0x40
	// No interrupt when FOVR is set
	CAN_IER_FOVIE1_Disabled = 0x0
	// Interrupt generation when FOVR is set
	CAN_IER_FOVIE1_Enabled = 0x1
	// Position of FFIE1 field.
	CAN_IER_FFIE1_Pos = 0x5
	// Bit mask of FFIE1 field.
	CAN_IER_FFIE1_Msk = 0x20
	// Bit FFIE1.
	CAN_IER_FFIE1 = 0x20
	// No interrupt when FULL bit is set
	CAN_IER_FFIE1_Disabled = 0x0
	// Interrupt generated when FULL bit is set
	CAN_IER_FFIE1_Enabled = 0x1
	// Position of FMPIE1 field.
	CAN_IER_FMPIE1_Pos = 0x4
	// Bit mask of FMPIE1 field.
	CAN_IER_FMPIE1_Msk = 0x10
	// Bit FMPIE1.
	CAN_IER_FMPIE1 = 0x10
	// No interrupt generated when state of FMP[1:0] bits are not 00b
	CAN_IER_FMPIE1_Disabled = 0x0
	// Interrupt generated when state of FMP[1:0] bits are not 00b
	CAN_IER_FMPIE1_Enabled = 0x1
	// Position of FOVIE0 field.
	CAN_IER_FOVIE0_Pos = 0x3
	// Bit mask of FOVIE0 field.
	CAN_IER_FOVIE0_Msk = 0x8
	// Bit FOVIE0.
	CAN_IER_FOVIE0 = 0x8
	// No interrupt when FOVR bit is set
	CAN_IER_FOVIE0_Disabled = 0x0
	// Interrupt generated when FOVR bit is set
	CAN_IER_FOVIE0_Enabled = 0x1
	// Position of FFIE0 field.
	CAN_IER_FFIE0_Pos = 0x2
	// Bit mask of FFIE0 field.
	CAN_IER_FFIE0_Msk = 0x4
	// Bit FFIE0.
	CAN_IER_FFIE0 = 0x4
	// No interrupt when FULL bit is set
	CAN_IER_FFIE0_Disabled = 0x0
	// Interrupt generated when FULL bit is set
	CAN_IER_FFIE0_Enabled = 0x1
	// Position of FMPIE0 field.
	CAN_IER_FMPIE0_Pos = 0x1
	// Bit mask of FMPIE0 field.
	CAN_IER_FMPIE0_Msk = 0x2
	// Bit FMPIE0.
	CAN_IER_FMPIE0 = 0x2
	// No interrupt generated when state of FMP[1:0] bits are not 00
	CAN_IER_FMPIE0_Disabled = 0x0
	// Interrupt generated when state of FMP[1:0] bits are not 00b
	CAN_IER_FMPIE0_Enabled = 0x1
	// Position of TMEIE field.
	CAN_IER_TMEIE_Pos = 0x0
	// Bit mask of TMEIE field.
	CAN_IER_TMEIE_Msk = 0x1
	// Bit TMEIE.
	CAN_IER_TMEIE = 0x1
	// No interrupt when RQCPx bit is set
	CAN_IER_TMEIE_Disabled = 0x0
	// Interrupt generated when RQCPx bit is set
	CAN_IER_TMEIE_Enabled = 0x1

	// ESR: error status register
	// Position of REC field.
	CAN_ESR_REC_Pos = 0x18
	// Bit mask of REC field.
	CAN_ESR_REC_Msk = 0xff000000
	// Position of TEC field.
	CAN_ESR_TEC_Pos = 0x10
	// Bit mask of TEC field.
	CAN_ESR_TEC_Msk = 0xff0000
	// Position of LEC field.
	CAN_ESR_LEC_Pos = 0x4
	// Bit mask of LEC field.
	CAN_ESR_LEC_Msk = 0x70
	// No Error
	CAN_ESR_LEC_NoError = 0x0
	// Stuff Error
	CAN_ESR_LEC_Stuff = 0x1
	// Form Error
	CAN_ESR_LEC_Form = 0x2
	// Acknowledgment Error
	CAN_ESR_LEC_Ack = 0x3
	// Bit recessive Error
	CAN_ESR_LEC_BitRecessive = 0x4
	// Bit dominant Error
	CAN_ESR_LEC_BitDominant = 0x5
	// CRC Error
	CAN_ESR_LEC_Crc = 0x6
	// Set by software
	CAN_ESR_LEC_Custom = 0x7
	// Position of BOFF field.
	CAN_ESR_BOFF_Pos = 0x2
	// Bit mask of BOFF field.
	CAN_ESR_BOFF_Msk = 0x4
	// Bit BOFF.
	CAN_ESR_BOFF = 0x4
	// Position of EPVF field.
	CAN_ESR_EPVF_Pos = 0x1
	// Bit mask of EPVF field.
	CAN_ESR_EPVF_Msk = 0x2
	// Bit EPVF.
	CAN_ESR_EPVF = 0x2
	// Position of EWGF field.
	CAN_ESR_EWGF_Pos = 0x0
	// Bit mask of EWGF field.
	CAN_ESR_EWGF_Msk = 0x1
	// Bit EWGF.
	CAN_ESR_EWGF = 0x1

	// BTR: bit timing register
	// Position of SILM field.
	CAN_BTR_SILM_Pos = 0x1f
	// Bit mask of SILM field.
	CAN_BTR_SILM_Msk = 0x80000000
	// Bit SILM.
	CAN_BTR_SILM = 0x80000000
	// Normal operation
	CAN_BTR_SILM_Normal = 0x0
	// Silent Mode
	CAN_BTR_SILM_Silent = 0x1
	// Position of LBKM field.
	CAN_BTR_LBKM_Pos = 0x1e
	// Bit mask of LBKM field.
	CAN_BTR_LBKM_Msk = 0x40000000
	// Bit LBKM.
	CAN_BTR_LBKM = 0x40000000
	// Loop Back Mode disabled
	CAN_BTR_LBKM_Disabled = 0x0
	// Loop Back Mode enabled
	CAN_BTR_LBKM_Enabled = 0x1
	// Position of SJW field.
	CAN_BTR_SJW_Pos = 0x18
	// Bit mask of SJW field.
	CAN_BTR_SJW_Msk = 0x3000000
	// Position of TS2 field.
	CAN_BTR_TS2_Pos = 0x14
	// Bit mask of TS2 field.
	CAN_BTR_TS2_Msk = 0x700000
	// Position of TS1 field.
	CAN_BTR_TS1_Pos = 0x10
	// Bit mask of TS1 field.
	CAN_BTR_TS1_Msk = 0xf0000
	// Position of BRP field.
	CAN_BTR_BRP_Pos = 0x0
	// Bit mask of BRP field.
	CAN_BTR_BRP_Msk = 0x3ff

	// TX.TIR: TX mailbox identifier register
	// Position of STID field.
	CAN_TX_TIR_STID_Pos = 0x15
	// Bit mask of STID field.
	CAN_TX_TIR_STID_Msk = 0xffe00000
	// Position of EXID field.
	CAN_TX_TIR_EXID_Pos = 0x3
	// Bit mask of EXID field.
	CAN_TX_TIR_EXID_Msk = 0x1ffff8
	// Position of IDE field.
	CAN_TX_TIR_IDE_Pos = 0x2
	// Bit mask of IDE field.
	CAN_TX_TIR_IDE_Msk = 0x4
	// Bit IDE.
	CAN_TX_TIR_IDE = 0x4
	// Standard identifier
	CAN_TX_TIR_IDE_Standard = 0x0
	// Extended identifier
	CAN_TX_TIR_IDE_Extended = 0x1
	// Position of RTR field.
	CAN_TX_TIR_RTR_Pos = 0x1
	// Bit mask of RTR field.
	CAN_TX_TIR_RTR_Msk = 0x2
	// Bit RTR.
	CAN_TX_TIR_RTR = 0x2
	// Data frame
	CAN_TX_TIR_RTR_Data = 0x0
	// Remote frame
	CAN_TX_TIR_RTR_Remote = 0x1
	// Position of TXRQ field.
	CAN_TX_TIR_TXRQ_Pos = 0x0
	// Bit mask of TXRQ field.
	CAN_TX_TIR_TXRQ_Msk = 0x1
	// Bit TXRQ.
	CAN_TX_TIR_TXRQ = 0x1

	// TX.TDTR: mailbox data length control and time stamp register
	// Position of TIME field.
	CAN_TX_TDTR_TIME_Pos = 0x10
	// Bit mask of TIME field.
	CAN_TX_TDTR_TIME_Msk = 0xffff0000
	// Position of TGT field.
	CAN_TX_TDTR_TGT_Pos = 0x8
	// Bit mask of TGT field.
	CAN_TX_TDTR_TGT_Msk = 0x100
	// Bit TGT.
	CAN_TX_TDTR_TGT = 0x100
	// Position of DLC field.
	CAN_TX_TDTR_DLC_Pos = 0x0
	// Bit mask of DLC field.
	CAN_TX_TDTR_DLC_Msk = 0xf

	// TX.TDLR: mailbox data low register
	// Position of DATA3 field.
	CAN_TX_TDLR_DATA3_Pos = 0x18
	// Bit mask of DATA3 field.
	CAN_TX_TDLR_DATA3_Msk = 0xff000000
	// Position of DATA2 field.
	CAN_TX_TDLR_DATA2_Pos = 0x10
	// Bit mask of DATA2 field.
	CAN_TX_TDLR_DATA2_Msk = 0xff0000
	// Position of DATA1 field.
	CAN_TX_TDLR_DATA1_Pos = 0x8
	// Bit mask of DATA1 field.
	CAN_TX_TDLR_DATA1_Msk = 0xff00
	// Position of DATA0 field.
	CAN_TX_TDLR_DATA0_Pos = 0x0
	// Bit mask of DATA0 field.
	CAN_TX_TDLR_DATA0_Msk = 0xff

	// TX.TDHR: mailbox data high register
	// Position of DATA7 field.
	CAN_TX_TDHR_DATA7_Pos = 0x18
	// Bit mask of DATA7 field.
	CAN_TX_TDHR_DATA7_Msk = 0xff000000
	// Position of DATA6 field.
	CAN_TX_TDHR_DATA6_Pos = 0x10
	// Bit mask of DATA6 field.
	CAN_TX_TDHR_DATA6_Msk = 0xff0000
	// Position of DATA5 field.
	CAN_TX_TDHR_DATA5_Pos = 0x8
	// Bit mask of DATA5 field.
	CAN_TX_TDHR_DATA5_Msk = 0xff00
	// Position of DATA4 field.
	CAN_TX_TDHR_DATA4_Pos = 0x0
	// Bit mask of DATA4 field.
	CAN_TX_TDHR_DATA4_Msk = 0xff

	// RX.RIR: receive FIFO mailbox identifier register
	// Position of STID field.
	CAN_RX_RIR_STID_Pos = 0x15
	// Bit mask of STID field.
	CAN_RX_RIR_STID_Msk = 0xffe00000
	// Position of EXID field.
	CAN_RX_RIR_EXID_Pos = 0x3
	// Bit mask of EXID field.
	CAN_RX_RIR_EXID_Msk = 0x1ffff8
	// Position of IDE field.
	CAN_RX_RIR_IDE_Pos = 0x2
	// Bit mask of IDE field.
	CAN_RX_RIR_IDE_Msk = 0x4
	// Bit IDE.
	CAN_RX_RIR_IDE = 0x4
	// Standard identifier
	CAN_RX_RIR_IDE_Standard = 0x0
	// Extended identifier
	CAN_RX_RIR_IDE_Extended = 0x1
	// Position of RTR field.
	CAN_RX_RIR_RTR_Pos = 0x1
	// Bit mask of RTR field.
	CAN_RX_RIR_RTR_Msk = 0x2
	// Bit RTR.
	CAN_RX_RIR_RTR = 0x2
	// Data frame
	CAN_RX_RIR_RTR_Data = 0x0
	// Remote frame
	CAN_RX_RIR_RTR_Remote = 0x1

	// RX.RDTR: receive FIFO mailbox data length control and time stamp register
	// Position of TIME field.
	CAN_RX_RDTR_TIME_Pos = 0x10
	// Bit mask of TIME field.
	CAN_RX_RDTR_TIME_Msk = 0xffff0000
	// Position of FMI field.
	CAN_RX_RDTR_FMI_Pos = 0x8
	// Bit mask of FMI field.
	CAN_RX_RDTR_FMI_Msk = 0xff00
	// Position of DLC field.
	CAN_RX_RDTR_DLC_Pos = 0x0
	// Bit mask of DLC field.
	CAN_RX_RDTR_DLC_Msk = 0xf

	// RX.RDLR: receive FIFO mailbox data low register
	// Position of DATA3 field.
	CAN_RX_RDLR_DATA3_Pos = 0x18
	// Bit mask of DATA3 field.
	CAN_RX_RDLR_DATA3_Msk = 0xff000000
	// Position of DATA2 field.
	CAN_RX_RDLR_DATA2_Pos = 0x10
	// Bit mask of DATA2 field.
	CAN_RX_RDLR_DATA2_Msk = 0xff0000
	// Position of DATA1 field.
	CAN_RX_RDLR_DATA1_Pos = 0x8
	// Bit mask of DATA1 field.
	CAN_RX_RDLR_DATA1_Msk = 0xff00
	// Position of DATA0 field.
	CAN_RX_RDLR_DATA0_Pos = 0x0
	// Bit mask of DATA0 field.
	CAN_RX_RDLR_DATA0_Msk = 0xff

	// RX.RDHR: receive FIFO mailbox data high register
	// Position of DATA7 field.
	CAN_RX_RDHR_DATA7_Pos = 0x18
	// Bit mask of DATA7 field.
	CAN_RX_RDHR_DATA7_Msk = 0xff000000
	// Position of DATA6 field.
	CAN_RX_RDHR_DATA6_Pos = 0x10
	// Bit mask of DATA6 field.
	CAN_RX_RDHR_DATA6_Msk = 0xff0000
	// Position of DATA5 field.
	CAN_RX_RDHR_DATA5_Pos = 0x8
	// Bit mask of DATA5 field.
	CAN_RX_RDHR_DATA5_Msk = 0xff00
	// Position of DATA4 field.
	CAN_RX_RDHR_DATA4_Pos = 0x0
	// Bit mask of DATA4 field.
	CAN_RX_RDHR_DATA4_Msk = 0xff

	// FMR: filter master register
	// Position of CAN2SB field.
	CAN_FMR_CAN2SB_Pos = 0x8
	// Bit mask of CAN2SB field.
	CAN_FMR_CAN2SB_Msk = 0x3f00
	// Position of FINIT field.
	CAN_FMR_FINIT_Pos = 0x0
	// Bit mask of FINIT field.
	CAN_FMR_FINIT_Msk = 0x1
	// Bit FINIT.
	CAN_FMR_FINIT = 0x1

	// FM1R: filter mode register
	// Position of FBM0 field.
	CAN_FM1R_FBM0_Pos = 0x0
	// Bit mask of FBM0 field.
	CAN_FM1R_FBM0_Msk = 0x1
	// Bit FBM0.
	CAN_FM1R_FBM0 = 0x1
	// Position of FBM1 field.
	CAN_FM1R_FBM1_Pos = 0x1
	// Bit mask of FBM1 field.
	CAN_FM1R_FBM1_Msk = 0x2
	// Bit FBM1.
	CAN_FM1R_FBM1 = 0x2
	// Position of FBM2 field.
	CAN_FM1R_FBM2_Pos = 0x2
	// Bit mask of FBM2 field.
	CAN_FM1R_FBM2_Msk = 0x4
	// Bit FBM2.
	CAN_FM1R_FBM2 = 0x4
	// Position of FBM3 field.
	CAN_FM1R_FBM3_Pos = 0x3
	// Bit mask of FBM3 field.
	CAN_FM1R_FBM3_Msk = 0x8
	// Bit FBM3.
	CAN_FM1R_FBM3 = 0x8
	// Position of FBM4 field.
	CAN_FM1R_FBM4_Pos = 0x4
	// Bit mask of FBM4 field.
	CAN_FM1R_FBM4_Msk = 0x10
	// Bit FBM4.
	CAN_FM1R_FBM4 = 0x10
	// Position of FBM5 field.
	CAN_FM1R_FBM5_Pos = 0x5
	// Bit mask of FBM5 field.
	CAN_FM1R_FBM5_Msk = 0x20
	// Bit FBM5.
	CAN_FM1R_FBM5 = 0x20
	// Position of FBM6 field.
	CAN_FM1R_FBM6_Pos = 0x6
	// Bit mask of FBM6 field.
	CAN_FM1R_FBM6_Msk = 0x40
	// Bit FBM6.
	CAN_FM1R_FBM6 = 0x40
	// Position of FBM7 field.
	CAN_FM1R_FBM7_Pos = 0x7
	// Bit mask of FBM7 field.
	CAN_FM1R_FBM7_Msk = 0x80
	// Bit FBM7.
	CAN_FM1R_FBM7 = 0x80
	// Position of FBM8 field.
	CAN_FM1R_FBM8_Pos = 0x8
	// Bit mask of FBM8 field.
	CAN_FM1R_FBM8_Msk = 0x100
	// Bit FBM8.
	CAN_FM1R_FBM8 = 0x100
	// Position of FBM9 field.
	CAN_FM1R_FBM9_Pos = 0x9
	// Bit mask of FBM9 field.
	CAN_FM1R_FBM9_Msk = 0x200
	// Bit FBM9.
	CAN_FM1R_FBM9 = 0x200
	// Position of FBM10 field.
	CAN_FM1R_FBM10_Pos = 0xa
	// Bit mask of FBM10 field.
	CAN_FM1R_FBM10_Msk = 0x400
	// Bit FBM10.
	CAN_FM1R_FBM10 = 0x400
	// Position of FBM11 field.
	CAN_FM1R_FBM11_Pos = 0xb
	// Bit mask of FBM11 field.
	CAN_FM1R_FBM11_Msk = 0x800
	// Bit FBM11.
	CAN_FM1R_FBM11 = 0x800
	// Position of FBM12 field.
	CAN_FM1R_FBM12_Pos = 0xc
	// Bit mask of FBM12 field.
	CAN_FM1R_FBM12_Msk = 0x1000
	// Bit FBM12.
	CAN_FM1R_FBM12 = 0x1000
	// Position of FBM13 field.
	CAN_FM1R_FBM13_Pos = 0xd
	// Bit mask of FBM13 field.
	CAN_FM1R_FBM13_Msk = 0x2000
	// Bit FBM13.
	CAN_FM1R_FBM13 = 0x2000
	// Position of FBM14 field.
	CAN_FM1R_FBM14_Pos = 0xe
	// Bit mask of FBM14 field.
	CAN_FM1R_FBM14_Msk = 0x4000
	// Bit FBM14.
	CAN_FM1R_FBM14 = 0x4000
	// Position of FBM15 field.
	CAN_FM1R_FBM15_Pos = 0xf
	// Bit mask of FBM15 field.
	CAN_FM1R_FBM15_Msk = 0x8000
	// Bit FBM15.
	CAN_FM1R_FBM15 = 0x8000
	// Position of FBM16 field.
	CAN_FM1R_FBM16_Pos = 0x10
	// Bit mask of FBM16 field.
	CAN_FM1R_FBM16_Msk = 0x10000
	// Bit FBM16.
	CAN_FM1R_FBM16 = 0x10000
	// Position of FBM17 field.
	CAN_FM1R_FBM17_Pos = 0x11
	// Bit mask of FBM17 field.
	CAN_FM1R_FBM17_Msk = 0x20000
	// Bit FBM17.
	CAN_FM1R_FBM17 = 0x20000
	// Position of FBM18 field.
	CAN_FM1R_FBM18_Pos = 0x12
	// Bit mask of FBM18 field.
	CAN_FM1R_FBM18_Msk = 0x40000
	// Bit FBM18.
	CAN_FM1R_FBM18 = 0x40000
	// Position of FBM19 field.
	CAN_FM1R_FBM19_Pos = 0x13
	// Bit mask of FBM19 field.
	CAN_FM1R_FBM19_Msk = 0x80000
	// Bit FBM19.
	CAN_FM1R_FBM19 = 0x80000
	// Position of FBM20 field.
	CAN_FM1R_FBM20_Pos = 0x14
	// Bit mask of FBM20 field.
	CAN_FM1R_FBM20_Msk = 0x100000
	// Bit FBM20.
	CAN_FM1R_FBM20 = 0x100000
	// Position of FBM21 field.
	CAN_FM1R_FBM21_Pos = 0x15
	// Bit mask of FBM21 field.
	CAN_FM1R_FBM21_Msk = 0x200000
	// Bit FBM21.
	CAN_FM1R_FBM21 = 0x200000
	// Position of FBM22 field.
	CAN_FM1R_FBM22_Pos = 0x16
	// Bit mask of FBM22 field.
	CAN_FM1R_FBM22_Msk = 0x400000
	// Bit FBM22.
	CAN_FM1R_FBM22 = 0x400000
	// Position of FBM23 field.
	CAN_FM1R_FBM23_Pos = 0x17
	// Bit mask of FBM23 field.
	CAN_FM1R_FBM23_Msk = 0x800000
	// Bit FBM23.
	CAN_FM1R_FBM23 = 0x800000
	// Position of FBM24 field.
	CAN_FM1R_FBM24_Pos = 0x18
	// Bit mask of FBM24 field.
	CAN_FM1R_FBM24_Msk = 0x1000000
	// Bit FBM24.
	CAN_FM1R_FBM24 = 0x1000000
	// Position of FBM25 field.
	CAN_FM1R_FBM25_Pos = 0x19
	// Bit mask of FBM25 field.
	CAN_FM1R_FBM25_Msk = 0x2000000
	// Bit FBM25.
	CAN_FM1R_FBM25 = 0x2000000
	// Position of FBM26 field.
	CAN_FM1R_FBM26_Pos = 0x1a
	// Bit mask of FBM26 field.
	CAN_FM1R_FBM26_Msk = 0x4000000
	// Bit FBM26.
	CAN_FM1R_FBM26 = 0x4000000
	// Position of FBM27 field.
	CAN_FM1R_FBM27_Pos = 0x1b
	// Bit mask of FBM27 field.
	CAN_FM1R_FBM27_Msk = 0x8000000
	// Bit FBM27.
	CAN_FM1R_FBM27 = 0x8000000

	// FS1R: filter scale register
	// Position of FSC0 field.
	CAN_FS1R_FSC0_Pos = 0x0
	// Bit mask of FSC0 field.
	CAN_FS1R_FSC0_Msk = 0x1
	// Bit FSC0.
	CAN_FS1R_FSC0 = 0x1
	// Position of FSC1 field.
	CAN_FS1R_FSC1_Pos = 0x1
	// Bit mask of FSC1 field.
	CAN_FS1R_FSC1_Msk = 0x2
	// Bit FSC1.
	CAN_FS1R_FSC1 = 0x2
	// Position of FSC2 field.
	CAN_FS1R_FSC2_Pos = 0x2
	// Bit mask of FSC2 field.
	CAN_FS1R_FSC2_Msk = 0x4
	// Bit FSC2.
	CAN_FS1R_FSC2 = 0x4
	// Position of FSC3 field.
	CAN_FS1R_FSC3_Pos = 0x3
	// Bit mask of FSC3 field.
	CAN_FS1R_FSC3_Msk = 0x8
	// Bit FSC3.
	CAN_FS1R_FSC3 = 0x8
	// Position of FSC4 field.
	CAN_FS1R_FSC4_Pos = 0x4
	// Bit mask of FSC4 field.
	CAN_FS1R_FSC4_Msk = 0x10
	// Bit FSC4.
	CAN_FS1R_FSC4 = 0x10
	// Position of FSC5 field.
	CAN_FS1R_FSC5_Pos = 0x5
	// Bit mask of FSC5 field.
	CAN_FS1R_FSC5_Msk = 0x20
	// Bit FSC5.
	CAN_FS1R_FSC5 = 0x20
	// Position of FSC6 field.
	CAN_FS1R_FSC6_Pos = 0x6
	// Bit mask of FSC6 field.
	CAN_FS1R_FSC6_Msk = 0x40
	// Bit FSC6.
	CAN_FS1R_FSC6 = 0x40
	// Position of FSC7 field.
	CAN_FS1R_FSC7_Pos = 0x7
	// Bit mask of FSC7 field.
	CAN_FS1R_FSC7_Msk = 0x80
	// Bit FSC7.
	CAN_FS1R_FSC7 = 0x80
	// Position of FSC8 field.
	CAN_FS1R_FSC8_Pos = 0x8
	// Bit mask of FSC8 field.
	CAN_FS1R_FSC8_Msk = 0x100
	// Bit FSC8.
	CAN_FS1R_FSC8 = 0x100
	// Position of FSC9 field.
	CAN_FS1R_FSC9_Pos = 0x9
	// Bit mask of FSC9 field.
	CAN_FS1R_FSC9_Msk = 0x200
	// Bit FSC9.
	CAN_FS1R_FSC9 = 0x200
	// Position of FSC10 field.
	CAN_FS1R_FSC10_Pos = 0xa
	// Bit mask of FSC10 field.
	CAN_FS1R_FSC10_Msk = 0x400
	// Bit FSC10.
	CAN_FS1R_FSC10 = 0x400
	// Position of FSC11 field.
	CAN_FS1R_FSC11_Pos = 0xb
	// Bit mask of FSC11 field.
	CAN_FS1R_FSC11_Msk = 0x800
	// Bit FSC11.
	CAN_FS1R_FSC11 = 0x800
	// Position of FSC12 field.
	CAN_FS1R_FSC12_Pos = 0xc
	// Bit mask of FSC12 field.
	CAN_FS1R_FSC12_Msk = 0x1000
	// Bit FSC12.
	CAN_FS1R_FSC12 = 0x1000
	// Position of FSC13 field.
	CAN_FS1R_FSC13_Pos = 0xd
	// Bit mask of FSC13 field.
	CAN_FS1R_FSC13_Msk = 0x2000
	// Bit FSC13.
	CAN_FS1R_FSC13 = 0x2000
	// Position of FSC14 field.
	CAN_FS1R_FSC14_Pos = 0xe
	// Bit mask of FSC14 field.
	CAN_FS1R_FSC14_Msk = 0x4000
	// Bit FSC14.
	CAN_FS1R_FSC14 = 0x4000
	// Position of FSC15 field.
	CAN_FS1R_FSC15_Pos = 0xf
	// Bit mask of FSC15 field.
	CAN_FS1R_FSC15_Msk = 0x8000
	// Bit FSC15.
	CAN_FS1R_FSC15 = 0x8000
	// Position of FSC16 field.
	CAN_FS1R_FSC16_Pos = 0x10
	// Bit mask of FSC16 field.
	CAN_FS1R_FSC16_Msk = 0x10000
	// Bit FSC16.
	CAN_FS1R_FSC16 = 0x10000
	// Position of FSC17 field.
	CAN_FS1R_FSC17_Pos = 0x11
	// Bit mask of FSC17 field.
	CAN_FS1R_FSC17_Msk = 0x20000
	// Bit FSC17.
	CAN_FS1R_FSC17 = 0x20000
	// Position of FSC18 field.
	CAN_FS1R_FSC18_Pos = 0x12
	// Bit mask of FSC18 field.
	CAN_FS1R_FSC18_Msk = 0x40000
	// Bit FSC18.
	CAN_FS1R_FSC18 = 0x40000
	// Position of FSC19 field.
	CAN_FS1R_FSC19_Pos = 0x13
	// Bit mask of FSC19 field.
	CAN_FS1R_FSC19_Msk = 0x80000
	// Bit FSC19.
	CAN_FS1R_FSC19 = 0x80000
	// Position of FSC20 field.
	CAN_FS1R_FSC20_Pos = 0x14
	// Bit mask of FSC20 field.
	CAN_FS1R_FSC20_Msk = 0x100000
	// Bit FSC20.
	CAN_FS1R_FSC20 = 0x100000
	// Position of FSC21 field.
	CAN_FS1R_FSC21_Pos = 0x15
	// Bit mask of FSC21 field.
	CAN_FS1R_FSC21_Msk = 0x200000
	// Bit FSC21.
	CAN_FS1R_FSC21 = 0x200000
	// Position of FSC22 field.
	CAN_FS1R_FSC22_Pos = 0x16
	// Bit mask of FSC22 field.
	CAN_FS1R_FSC22_Msk = 0x400000
	// Bit FSC22.
	CAN_FS1R_FSC22 = 0x400000
	// Position of FSC23 field.
	CAN_FS1R_FSC23_Pos = 0x17
	// Bit mask of FSC23 field.
	CAN_FS1R_FSC23_Msk = 0x800000
	// Bit FSC23.
	CAN_FS1R_FSC23 = 0x800000
	// Position of FSC24 field.
	CAN_FS1R_FSC24_Pos = 0x18
	// Bit mask of FSC24 field.
	CAN_FS1R_FSC24_Msk = 0x1000000
	// Bit FSC24.
	CAN_FS1R_FSC24 = 0x1000000
	// Position of FSC25 field.
	CAN_FS1R_FSC25_Pos = 0x19
	// Bit mask of FSC25 field.
	CAN_FS1R_FSC25_Msk = 0x2000000
	// Bit FSC25.
	CAN_FS1R_FSC25 = 0x2000000
	// Position of FSC26 field.
	CAN_FS1R_FSC26_Pos = 0x1a
	// Bit mask of FSC26 field.
	CAN_FS1R_FSC26_Msk = 0x4000000
	// Bit FSC26.
	CAN_FS1R_FSC26 = 0x4000000
	// Position of FSC27 field.
	CAN_FS1R_FSC27_Pos = 0x1b
	// Bit mask of FSC27 field.
	CAN_FS1R_FSC27_Msk = 0x8000000
	// Bit FSC27.
	CAN_FS1R_FSC27 = 0x8000000

	// FFA1R: filter FIFO assignment register
	// Position of FFA0 field.
	CAN_FFA1R_FFA0_Pos = 0x0
	// Bit mask of FFA0 field.
	CAN_FFA1R_FFA0_Msk = 0x1
	// Bit FFA0.
	CAN_FFA1R_FFA0 = 0x1
	// Position of FFA1 field.
	CAN_FFA1R_FFA1_Pos = 0x1
	// Bit mask of FFA1 field.
	CAN_FFA1R_FFA1_Msk = 0x2
	// Bit FFA1.
	CAN_FFA1R_FFA1 = 0x2
	// Position of FFA2 field.
	CAN_FFA1R_FFA2_Pos = 0x2
	// Bit mask of FFA2 field.
	CAN_FFA1R_FFA2_Msk = 0x4
	// Bit FFA2.
	CAN_FFA1R_FFA2 = 0x4
	// Position of FFA3 field.
	CAN_FFA1R_FFA3_Pos = 0x3
	// Bit mask of FFA3 field.
	CAN_FFA1R_FFA3_Msk = 0x8
	// Bit FFA3.
	CAN_FFA1R_FFA3 = 0x8
	// Position of FFA4 field.
	CAN_FFA1R_FFA4_Pos = 0x4
	// Bit mask of FFA4 field.
	CAN_FFA1R_FFA4_Msk = 0x10
	// Bit FFA4.
	CAN_FFA1R_FFA4 = 0x10
	// Position of FFA5 field.
	CAN_FFA1R_FFA5_Pos = 0x5
	// Bit mask of FFA5 field.
	CAN_FFA1R_FFA5_Msk = 0x20
	// Bit FFA5.
	CAN_FFA1R_FFA5 = 0x20
	// Position of FFA6 field.
	CAN_FFA1R_FFA6_Pos = 0x6
	// Bit mask of FFA6 field.
	CAN_FFA1R_FFA6_Msk = 0x40
	// Bit FFA6.
	CAN_FFA1R_FFA6 = 0x40
	// Position of FFA7 field.
	CAN_FFA1R_FFA7_Pos = 0x7
	// Bit mask of FFA7 field.
	CAN_FFA1R_FFA7_Msk = 0x80
	// Bit FFA7.
	CAN_FFA1R_FFA7 = 0x80
	// Position of FFA8 field.
	CAN_FFA1R_FFA8_Pos = 0x8
	// Bit mask of FFA8 field.
	CAN_FFA1R_FFA8_Msk = 0x100
	// Bit FFA8.
	CAN_FFA1R_FFA8 = 0x100
	// Position of FFA9 field.
	CAN_FFA1R_FFA9_Pos = 0x9
	// Bit mask of FFA9 field.
	CAN_FFA1R_FFA9_Msk = 0x200
	// Bit FFA9.
	CAN_FFA1R_FFA9 = 0x200
	// Position of FFA10 field.
	CAN_FFA1R_FFA10_Pos = 0xa
	// Bit mask of FFA10 field.
	CAN_FFA1R_FFA10_Msk = 0x400
	// Bit FFA10.
	CAN_FFA1R_FFA10 = 0x400
	// Position of FFA11 field.
	CAN_FFA1R_FFA11_Pos = 0xb
	// Bit mask of FFA11 field.
	CAN_FFA1R_FFA11_Msk = 0x800
	// Bit FFA11.
	CAN_FFA1R_FFA11 = 0x800
	// Position of FFA12 field.
	CAN_FFA1R_FFA12_Pos = 0xc
	// Bit mask of FFA12 field.
	CAN_FFA1R_FFA12_Msk = 0x1000
	// Bit FFA12.
	CAN_FFA1R_FFA12 = 0x1000
	// Position of FFA13 field.
	CAN_FFA1R_FFA13_Pos = 0xd
	// Bit mask of FFA13 field.
	CAN_FFA1R_FFA13_Msk = 0x2000
	// Bit FFA13.
	CAN_FFA1R_FFA13 = 0x2000
	// Position of FFA14 field.
	CAN_FFA1R_FFA14_Pos = 0xe
	// Bit mask of FFA14 field.
	CAN_FFA1R_FFA14_Msk = 0x4000
	// Bit FFA14.
	CAN_FFA1R_FFA14 = 0x4000
	// Position of FFA15 field.
	CAN_FFA1R_FFA15_Pos = 0xf
	// Bit mask of FFA15 field.
	CAN_FFA1R_FFA15_Msk = 0x8000
	// Bit FFA15.
	CAN_FFA1R_FFA15 = 0x8000
	// Position of FFA16 field.
	CAN_FFA1R_FFA16_Pos = 0x10
	// Bit mask of FFA16 field.
	CAN_FFA1R_FFA16_Msk = 0x10000
	// Bit FFA16.
	CAN_FFA1R_FFA16 = 0x10000
	// Position of FFA17 field.
	CAN_FFA1R_FFA17_Pos = 0x11
	// Bit mask of FFA17 field.
	CAN_FFA1R_FFA17_Msk = 0x20000
	// Bit FFA17.
	CAN_FFA1R_FFA17 = 0x20000
	// Position of FFA18 field.
	CAN_FFA1R_FFA18_Pos = 0x12
	// Bit mask of FFA18 field.
	CAN_FFA1R_FFA18_Msk = 0x40000
	// Bit FFA18.
	CAN_FFA1R_FFA18 = 0x40000
	// Position of FFA19 field.
	CAN_FFA1R_FFA19_Pos = 0x13
	// Bit mask of FFA19 field.
	CAN_FFA1R_FFA19_Msk = 0x80000
	// Bit FFA19.
	CAN_FFA1R_FFA19 = 0x80000
	// Position of FFA20 field.
	CAN_FFA1R_FFA20_Pos = 0x14
	// Bit mask of FFA20 field.
	CAN_FFA1R_FFA20_Msk = 0x100000
	// Bit FFA20.
	CAN_FFA1R_FFA20 = 0x100000
	// Position of FFA21 field.
	CAN_FFA1R_FFA21_Pos = 0x15
	// Bit mask of FFA21 field.
	CAN_FFA1R_FFA21_Msk = 0x200000
	// Bit FFA21.
	CAN_FFA1R_FFA21 = 0x200000
	// Position of FFA22 field.
	CAN_FFA1R_FFA22_Pos = 0x16
	// Bit mask of FFA22 field.
	CAN_FFA1R_FFA22_Msk = 0x400000
	// Bit FFA22.
	CAN_FFA1R_FFA22 = 0x400000
	// Position of FFA23 field.
	CAN_FFA1R_FFA23_Pos = 0x17
	// Bit mask of FFA23 field.
	CAN_FFA1R_FFA23_Msk = 0x800000
	// Bit FFA23.
	CAN_FFA1R_FFA23 = 0x800000
	// Position of FFA24 field.
	CAN_FFA1R_FFA24_Pos = 0x18
	// Bit mask of FFA24 field.
	CAN_FFA1R_FFA24_Msk = 0x1000000
	// Bit FFA24.
	CAN_FFA1R_FFA24 = 0x1000000
	// Position of FFA25 field.
	CAN_FFA1R_FFA25_Pos = 0x19
	// Bit mask of FFA25 field.
	CAN_FFA1R_FFA25_Msk = 0x2000000
	// Bit FFA25.
	CAN_FFA1R_FFA25 = 0x2000000
	// Position of FFA26 field.
	CAN_FFA1R_FFA26_Pos = 0x1a
	// Bit mask of FFA26 field.
	CAN_FFA1R_FFA26_Msk = 0x4000000
	// Bit FFA26.
	CAN_FFA1R_FFA26 = 0x4000000
	// Position of FFA27 field.
	CAN_FFA1R_FFA27_Pos = 0x1b
	// Bit mask of FFA27 field.
	CAN_FFA1R_FFA27_Msk = 0x8000000
	// Bit FFA27.
	CAN_FFA1R_FFA27 = 0x8000000

	// FA1R: CAN filter activation register
	// Position of FACT0 field.
	CAN_FA1R_FACT0_Pos = 0x0
	// Bit mask of FACT0 field.
	CAN_FA1R_FACT0_Msk = 0x1
	// Bit FACT0.
	CAN_FA1R_FACT0 = 0x1
	// Position of FACT1 field.
	CAN_FA1R_FACT1_Pos = 0x1
	// Bit mask of FACT1 field.
	CAN_FA1R_FACT1_Msk = 0x2
	// Bit FACT1.
	CAN_FA1R_FACT1 = 0x2
	// Position of FACT2 field.
	CAN_FA1R_FACT2_Pos = 0x2
	// Bit mask of FACT2 field.
	CAN_FA1R_FACT2_Msk = 0x4
	// Bit FACT2.
	CAN_FA1R_FACT2 = 0x4
	// Position of FACT3 field.
	CAN_FA1R_FACT3_Pos = 0x3
	// Bit mask of FACT3 field.
	CAN_FA1R_FACT3_Msk = 0x8
	// Bit FACT3.
	CAN_FA1R_FACT3 = 0x8
	// Position of FACT4 field.
	CAN_FA1R_FACT4_Pos = 0x4
	// Bit mask of FACT4 field.
	CAN_FA1R_FACT4_Msk = 0x10
	// Bit FACT4.
	CAN_FA1R_FACT4 = 0x10
	// Position of FACT5 field.
	CAN_FA1R_FACT5_Pos = 0x5
	// Bit mask of FACT5 field.
	CAN_FA1R_FACT5_Msk = 0x20
	// Bit FACT5.
	CAN_FA1R_FACT5 = 0x20
	// Position of FACT6 field.
	CAN_FA1R_FACT6_Pos = 0x6
	// Bit mask of FACT6 field.
	CAN_FA1R_FACT6_Msk = 0x40
	// Bit FACT6.
	CAN_FA1R_FACT6 = 0x40
	// Position of FACT7 field.
	CAN_FA1R_FACT7_Pos = 0x7
	// Bit mask of FACT7 field.
	CAN_FA1R_FACT7_Msk = 0x80
	// Bit FACT7.
	CAN_FA1R_FACT7 = 0x80
	// Position of FACT8 field.
	CAN_FA1R_FACT8_Pos = 0x8
	// Bit mask of FACT8 field.
	CAN_FA1R_FACT8_Msk = 0x100
	// Bit FACT8.
	CAN_FA1R_FACT8 = 0x100
	// Position of FACT9 field.
	CAN_FA1R_FACT9_Pos = 0x9
	// Bit mask of FACT9 field.
	CAN_FA1R_FACT9_Msk = 0x200
	// Bit FACT9.
	CAN_FA1R_FACT9 = 0x200
	// Position of FACT10 field.
	CAN_FA1R_FACT10_Pos = 0xa
	// Bit mask of FACT10 field.
	CAN_FA1R_FACT10_Msk = 0x400
	// Bit FACT10.
	CAN_FA1R_FACT10 = 0x400
	// Position of FACT11 field.
	CAN_FA1R_FACT11_Pos = 0xb
	// Bit mask of FACT11 field.
	CAN_FA1R_FACT11_Msk = 0x800
	// Bit FACT11.
	CAN_FA1R_FACT11 = 0x800
	// Position of FACT12 field.
	CAN_FA1R_FACT12_Pos = 0xc
	// Bit mask of FACT12 field.
	CAN_FA1R_FACT12_Msk = 0x1000
	// Bit FACT12.
	CAN_FA1R_FACT12 = 0x1000
	// Position of FACT13 field.
	CAN_FA1R_FACT13_Pos = 0xd
	// Bit mask of FACT13 field.
	CAN_FA1R_FACT13_Msk = 0x2000
	// Bit FACT13.
	CAN_FA1R_FACT13 = 0x2000
	// Position of FACT14 field.
	CAN_FA1R_FACT14_Pos = 0xe
	// Bit mask of FACT14 field.
	CAN_FA1R_FACT14_Msk = 0x4000
	// Bit FACT14.
	CAN_FA1R_FACT14 = 0x4000
	// Position of FACT15 field.
	CAN_FA1R_FACT15_Pos = 0xf
	// Bit mask of FACT15 field.
	CAN_FA1R_FACT15_Msk = 0x8000
	// Bit FACT15.
	CAN_FA1R_FACT15 = 0x8000
	// Position of FACT16 field.
	CAN_FA1R_FACT16_Pos = 0x10
	// Bit mask of FACT16 field.
	CAN_FA1R_FACT16_Msk = 0x10000
	// Bit FACT16.
	CAN_FA1R_FACT16 = 0x10000
	// Position of FACT17 field.
	CAN_FA1R_FACT17_Pos = 0x11
	// Bit mask of FACT17 field.
	CAN_FA1R_FACT17_Msk = 0x20000
	// Bit FACT17.
	CAN_FA1R_FACT17 = 0x20000
	// Position of FACT18 field.
	CAN_FA1R_FACT18_Pos = 0x12
	// Bit mask of FACT18 field.
	CAN_FA1R_FACT18_Msk = 0x40000
	// Bit FACT18.
	CAN_FA1R_FACT18 = 0x40000
	// Position of FACT19 field.
	CAN_FA1R_FACT19_Pos = 0x13
	// Bit mask of FACT19 field.
	CAN_FA1R_FACT19_Msk = 0x80000
	// Bit FACT19.
	CAN_FA1R_FACT19 = 0x80000
	// Position of FACT20 field.
	CAN_FA1R_FACT20_Pos = 0x14
	// Bit mask of FACT20 field.
	CAN_FA1R_FACT20_Msk = 0x100000
	// Bit FACT20.
	CAN_FA1R_FACT20 = 0x100000
	// Position of FACT21 field.
	CAN_FA1R_FACT21_Pos = 0x15
	// Bit mask of FACT21 field.
	CAN_FA1R_FACT21_Msk = 0x200000
	// Bit FACT21.
	CAN_FA1R_FACT21 = 0x200000
	// Position of FACT22 field.
	CAN_FA1R_FACT22_Pos = 0x16
	// Bit mask of FACT22 field.
	CAN_FA1R_FACT22_Msk = 0x400000
	// Bit FACT22.
	CAN_FA1R_FACT22 = 0x400000
	// Position of FACT23 field.
	CAN_FA1R_FACT23_Pos = 0x17
	// Bit mask of FACT23 field.
	CAN_FA1R_FACT23_Msk = 0x800000
	// Bit FACT23.
	CAN_FA1R_FACT23 = 0x800000
	// Position of FACT24 field.
	CAN_FA1R_FACT24_Pos = 0x18
	// Bit mask of FACT24 field.
	CAN_FA1R_FACT24_Msk = 0x1000000
	// Bit FACT24.
	CAN_FA1R_FACT24 = 0x1000000
	// Position of FACT25 field.
	CAN_FA1R_FACT25_Pos = 0x19
	// Bit mask of FACT25 field.
	CAN_FA1R_FACT25_Msk = 0x2000000
	// Bit FACT25.
	CAN_FA1R_FACT25 = 0x2000000
	// Position of FACT26 field.
	CAN_FA1R_FACT26_Pos = 0x1a
	// Bit mask of FACT26 field.
	CAN_FA1R_FACT26_Msk = 0x4000000
	// Bit FACT26.
	CAN_FA1R_FACT26 = 0x4000000
	// Position of FACT27 field.
	CAN_FA1R_FACT27_Pos = 0x1b
	// Bit mask of FACT27 field.
	CAN_FA1R_FACT27_Msk = 0x8000000
	// Bit FACT27.
	CAN_FA1R_FACT27 = 0x8000000

	// FB.FR1: Filter bank 0 register 1
	// Position of FB0 field.
	CAN_FB_FR1_FB0_Pos = 0x0
	// Bit mask of FB0 field.
	CAN_FB_FR1_FB0_Msk = 0x1
	// Bit FB0.
	CAN_FB_FR1_FB0 = 0x1
	// Position of FB1 field.
	CAN_FB_FR1_FB1_Pos = 0x1
	// Bit mask of FB1 field.
	CAN_FB_FR1_FB1_Msk = 0x2
	// Bit FB1.
	CAN_FB_FR1_FB1 = 0x2
	// Position of FB2 field.
	CAN_FB_FR1_FB2_Pos = 0x2
	// Bit mask of FB2 field.
	CAN_FB_FR1_FB2_Msk = 0x4
	// Bit FB2.
	CAN_FB_FR1_FB2 = 0x4
	// Position of FB3 field.
	CAN_FB_FR1_FB3_Pos = 0x3
	// Bit mask of FB3 field.
	CAN_FB_FR1_FB3_Msk = 0x8
	// Bit FB3.
	CAN_FB_FR1_FB3 = 0x8
	// Position of FB4 field.
	CAN_FB_FR1_FB4_Pos = 0x4
	// Bit mask of FB4 field.
	CAN_FB_FR1_FB4_Msk = 0x10
	// Bit FB4.
	CAN_FB_FR1_FB4 = 0x10
	// Position of FB5 field.
	CAN_FB_FR1_FB5_Pos = 0x5
	// Bit mask of FB5 field.
	CAN_FB_FR1_FB5_Msk = 0x20
	// Bit FB5.
	CAN_FB_FR1_FB5 = 0x20
	// Position of FB6 field.
	CAN_FB_FR1_FB6_Pos = 0x6
	// Bit mask of FB6 field.
	CAN_FB_FR1_FB6_Msk = 0x40
	// Bit FB6.
	CAN_FB_FR1_FB6 = 0x40
	// Position of FB7 field.
	CAN_FB_FR1_FB7_Pos = 0x7
	// Bit mask of FB7 field.
	CAN_FB_FR1_FB7_Msk = 0x80
	// Bit FB7.
	CAN_FB_FR1_FB7 = 0x80
	// Position of FB8 field.
	CAN_FB_FR1_FB8_Pos = 0x8
	// Bit mask of FB8 field.
	CAN_FB_FR1_FB8_Msk = 0x100
	// Bit FB8.
	CAN_FB_FR1_FB8 = 0x100
	// Position of FB9 field.
	CAN_FB_FR1_FB9_Pos = 0x9
	// Bit mask of FB9 field.
	CAN_FB_FR1_FB9_Msk = 0x200
	// Bit FB9.
	CAN_FB_FR1_FB9 = 0x200
	// Position of FB10 field.
	CAN_FB_FR1_FB10_Pos = 0xa
	// Bit mask of FB10 field.
	CAN_FB_FR1_FB10_Msk = 0x400
	// Bit FB10.
	CAN_FB_FR1_FB10 = 0x400
	// Position of FB11 field.
	CAN_FB_FR1_FB11_Pos = 0xb
	// Bit mask of FB11 field.
	CAN_FB_FR1_FB11_Msk = 0x800
	// Bit FB11.
	CAN_FB_FR1_FB11 = 0x800
	// Position of FB12 field.
	CAN_FB_FR1_FB12_Pos = 0xc
	// Bit mask of FB12 field.
	CAN_FB_FR1_FB12_Msk = 0x1000
	// Bit FB12.
	CAN_FB_FR1_FB12 = 0x1000
	// Position of FB13 field.
	CAN_FB_FR1_FB13_Pos = 0xd
	// Bit mask of FB13 field.
	CAN_FB_FR1_FB13_Msk = 0x2000
	// Bit FB13.
	CAN_FB_FR1_FB13 = 0x2000
	// Position of FB14 field.
	CAN_FB_FR1_FB14_Pos = 0xe
	// Bit mask of FB14 field.
	CAN_FB_FR1_FB14_Msk = 0x4000
	// Bit FB14.
	CAN_FB_FR1_FB14 = 0x4000
	// Position of FB15 field.
	CAN_FB_FR1_FB15_Pos = 0xf
	// Bit mask of FB15 field.
	CAN_FB_FR1_FB15_Msk = 0x8000
	// Bit FB15.
	CAN_FB_FR1_FB15 = 0x8000
	// Position of FB16 field.
	CAN_FB_FR1_FB16_Pos = 0x10
	// Bit mask of FB16 field.
	CAN_FB_FR1_FB16_Msk = 0x10000
	// Bit FB16.
	CAN_FB_FR1_FB16 = 0x10000
	// Position of FB17 field.
	CAN_FB_FR1_FB17_Pos = 0x11
	// Bit mask of FB17 field.
	CAN_FB_FR1_FB17_Msk = 0x20000
	// Bit FB17.
	CAN_FB_FR1_FB17 = 0x20000
	// Position of FB18 field.
	CAN_FB_FR1_FB18_Pos = 0x12
	// Bit mask of FB18 field.
	CAN_FB_FR1_FB18_Msk = 0x40000
	// Bit FB18.
	CAN_FB_FR1_FB18 = 0x40000
	// Position of FB19 field.
	CAN_FB_FR1_FB19_Pos = 0x13
	// Bit mask of FB19 field.
	CAN_FB_FR1_FB19_Msk = 0x80000
	// Bit FB19.
	CAN_FB_FR1_FB19 = 0x80000
	// Position of FB20 field.
	CAN_FB_FR1_FB20_Pos = 0x14
	// Bit mask of FB20 field.
	CAN_FB_FR1_FB20_Msk = 0x100000
	// Bit FB20.
	CAN_FB_FR1_FB20 = 0x100000
	// Position of FB21 field.
	CAN_FB_FR1_FB21_Pos = 0x15
	// Bit mask of FB21 field.
	CAN_FB_FR1_FB21_Msk = 0x200000
	// Bit FB21.
	CAN_FB_FR1_FB21 = 0x200000
	// Position of FB22 field.
	CAN_FB_FR1_FB22_Pos = 0x16
	// Bit mask of FB22 field.
	CAN_FB_FR1_FB22_Msk = 0x400000
	// Bit FB22.
	CAN_FB_FR1_FB22 = 0x400000
	// Position of FB23 field.
	CAN_FB_FR1_FB23_Pos = 0x17
	// Bit mask of FB23 field.
	CAN_FB_FR1_FB23_Msk = 0x800000
	// Bit FB23.
	CAN_FB_FR1_FB23 = 0x800000
	// Position of FB24 field.
	CAN_FB_FR1_FB24_Pos = 0x18
	// Bit mask of FB24 field.
	CAN_FB_FR1_FB24_Msk = 0x1000000
	// Bit FB24.
	CAN_FB_FR1_FB24 = 0x1000000
	// Position of FB25 field.
	CAN_FB_FR1_FB25_Pos = 0x19
	// Bit mask of FB25 field.
	CAN_FB_FR1_FB25_Msk = 0x2000000
	// Bit FB25.
	CAN_FB_FR1_FB25 = 0x2000000
	// Position of FB26 field.
	CAN_FB_FR1_FB26_Pos = 0x1a
	// Bit mask of FB26 field.
	CAN_FB_FR1_FB26_Msk = 0x4000000
	// Bit FB26.
	CAN_FB_FR1_FB26 = 0x4000000
	// Position of FB27 field.
	CAN_FB_FR1_FB27_Pos = 0x1b
	// Bit mask of FB27 field.
	CAN_FB_FR1_FB27_Msk = 0x8000000
	// Bit FB27.
	CAN_FB_FR1_FB27 = 0x8000000
	// Position of FB28 field.
	CAN_FB_FR1_FB28_Pos = 0x1c
	// Bit mask of FB28 field.
	CAN_FB_FR1_FB28_Msk = 0x10000000
	// Bit FB28.
	CAN_FB_FR1_FB28 = 0x10000000
	// Position of FB29 field.
	CAN_FB_FR1_FB29_Pos = 0x1d
	// Bit mask of FB29 field.
	CAN_FB_FR1_FB29_Msk = 0x20000000
	// Bit FB29.
	CAN_FB_FR1_FB29 = 0x20000000
	// Position of FB30 field.
	CAN_FB_FR1_FB30_Pos = 0x1e
	// Bit mask of FB30 field.
	CAN_FB_FR1_FB30_Msk = 0x40000000
	// Bit FB30.
	CAN_FB_FR1_FB30 = 0x40000000
	// Position of FB31 field.
	CAN_FB_FR1_FB31_Pos = 0x1f
	// Bit mask of FB31 field.
	CAN_FB_FR1_FB31_Msk = 0x80000000
	// Bit FB31.
	CAN_FB_FR1_FB31 = 0x80000000

	// FB.FR2: Filter bank 0 register 2
	// Position of FB0 field.
	CAN_FB_FR2_FB0_Pos = 0x0
	// Bit mask of FB0 field.
	CAN_FB_FR2_FB0_Msk = 0x1
	// Bit FB0.
	CAN_FB_FR2_FB0 = 0x1
	// Position of FB1 field.
	CAN_FB_FR2_FB1_Pos = 0x1
	// Bit mask of FB1 field.
	CAN_FB_FR2_FB1_Msk = 0x2
	// Bit FB1.
	CAN_FB_FR2_FB1 = 0x2
	// Position of FB2 field.
	CAN_FB_FR2_FB2_Pos = 0x2
	// Bit mask of FB2 field.
	CAN_FB_FR2_FB2_Msk = 0x4
	// Bit FB2.
	CAN_FB_FR2_FB2 = 0x4
	// Position of FB3 field.
	CAN_FB_FR2_FB3_Pos = 0x3
	// Bit mask of FB3 field.
	CAN_FB_FR2_FB3_Msk = 0x8
	// Bit FB3.
	CAN_FB_FR2_FB3 = 0x8
	// Position of FB4 field.
	CAN_FB_FR2_FB4_Pos = 0x4
	// Bit mask of FB4 field.
	CAN_FB_FR2_FB4_Msk = 0x10
	// Bit FB4.
	CAN_FB_FR2_FB4 = 0x10
	// Position of FB5 field.
	CAN_FB_FR2_FB5_Pos = 0x5
	// Bit mask of FB5 field.
	CAN_FB_FR2_FB5_Msk = 0x20
	// Bit FB5.
	CAN_FB_FR2_FB5 = 0x20
	// Position of FB6 field.
	CAN_FB_FR2_FB6_Pos = 0x6
	// Bit mask of FB6 field.
	CAN_FB_FR2_FB6_Msk = 0x40
	// Bit FB6.
	CAN_FB_FR2_FB6 = 0x40
	// Position of FB7 field.
	CAN_FB_FR2_FB7_Pos = 0x7
	// Bit mask of FB7 field.
	CAN_FB_FR2_FB7_Msk = 0x80
	// Bit FB7.
	CAN_FB_FR2_FB7 = 0x80
	// Position of FB8 field.
	CAN_FB_FR2_FB8_Pos = 0x8
	// Bit mask of FB8 field.
	CAN_FB_FR2_FB8_Msk = 0x100
	// Bit FB8.
	CAN_FB_FR2_FB8 = 0x100
	// Position of FB9 field.
	CAN_FB_FR2_FB9_Pos = 0x9
	// Bit mask of FB9 field.
	CAN_FB_FR2_FB9_Msk = 0x200
	// Bit FB9.
	CAN_FB_FR2_FB9 = 0x200
	// Position of FB10 field.
	CAN_FB_FR2_FB10_Pos = 0xa
	// Bit mask of FB10 field.
	CAN_FB_FR2_FB10_Msk = 0x400
	// Bit FB10.
	CAN_FB_FR2_FB10 = 0x400
	// Position of FB11 field.
	CAN_FB_FR2_FB11_Pos = 0xb
	// Bit mask of FB11 field.
	CAN_FB_FR2_FB11_Msk = 0x800
	// Bit FB11.
	CAN_FB_FR2_FB11 = 0x800
	// Position of FB12 field.
	CAN_FB_FR2_FB12_Pos = 0xc
	// Bit mask of FB12 field.
	CAN_FB_FR2_FB12_Msk = 0x1000
	// Bit FB12.
	CAN_FB_FR2_FB12 = 0x1000
	// Position of FB13 field.
	CAN_FB_FR2_FB13_Pos = 0xd
	// Bit mask of FB13 field.
	CAN_FB_FR2_FB13_Msk = 0x2000
	// Bit FB13.
	CAN_FB_FR2_FB13 = 0x2000
	// Position of FB14 field.
	CAN_FB_FR2_FB14_Pos = 0xe
	// Bit mask of FB14 field.
	CAN_FB_FR2_FB14_Msk = 0x4000
	// Bit FB14.
	CAN_FB_FR2_FB14 = 0x4000
	// Position of FB15 field.
	CAN_FB_FR2_FB15_Pos = 0xf
	// Bit mask of FB15 field.
	CAN_FB_FR2_FB15_Msk = 0x8000
	// Bit FB15.
	CAN_FB_FR2_FB15 = 0x8000
	// Position of FB16 field.
	CAN_FB_FR2_FB16_Pos = 0x10
	// Bit mask of FB16 field.
	CAN_FB_FR2_FB16_Msk = 0x10000
	// Bit FB16.
	CAN_FB_FR2_FB16 = 0x10000
	// Position of FB17 field.
	CAN_FB_FR2_FB17_Pos = 0x11
	// Bit mask of FB17 field.
	CAN_FB_FR2_FB17_Msk = 0x20000
	// Bit FB17.
	CAN_FB_FR2_FB17 = 0x20000
	// Position of FB18 field.
	CAN_FB_FR2_FB18_Pos = 0x12
	// Bit mask of FB18 field.
	CAN_FB_FR2_FB18_Msk = 0x40000
	// Bit FB18.
	CAN_FB_FR2_FB18 = 0x40000
	// Position of FB19 field.
	CAN_FB_FR2_FB19_Pos = 0x13
	// Bit mask of FB19 field.
	CAN_FB_FR2_FB19_Msk = 0x80000
	// Bit FB19.
	CAN_FB_FR2_FB19 = 0x80000
	// Position of FB20 field.
	CAN_FB_FR2_FB20_Pos = 0x14
	// Bit mask of FB20 field.
	CAN_FB_FR2_FB20_Msk = 0x100000
	// Bit FB20.
	CAN_FB_FR2_FB20 = 0x100000
	// Position of FB21 field.
	CAN_FB_FR2_FB21_Pos = 0x15
	// Bit mask of FB21 field.
	CAN_FB_FR2_FB21_Msk = 0x200000
	// Bit FB21.
	CAN_FB_FR2_FB21 = 0x200000
	// Position of FB22 field.
	CAN_FB_FR2_FB22_Pos = 0x16
	// Bit mask of FB22 field.
	CAN_FB_FR2_FB22_Msk = 0x400000
	// Bit FB22.
	CAN_FB_FR2_FB22 = 0x400000
	// Position of FB23 field.
	CAN_FB_FR2_FB23_Pos = 0x17
	// Bit mask of FB23 field.
	CAN_FB_FR2_FB23_Msk = 0x800000
	// Bit FB23.
	CAN_FB_FR2_FB23 = 0x800000
	// Position of FB24 field.
	CAN_FB_FR2_FB24_Pos = 0x18
	// Bit mask of FB24 field.
	CAN_FB_FR2_FB24_Msk = 0x1000000
	// Bit FB24.
	CAN_FB_FR2_FB24 = 0x1000000
	// Position of FB25 field.
	CAN_FB_FR2_FB25_Pos = 0x19
	// Bit mask of FB25 field.
	CAN_FB_FR2_FB25_Msk = 0x2000000
	// Bit FB25.
	CAN_FB_FR2_FB25 = 0x2000000
	// Position of FB26 field.
	CAN_FB_FR2_FB26_Pos = 0x1a
	// Bit mask of FB26 field.
	CAN_FB_FR2_FB26_Msk = 0x4000000
	// Bit FB26.
	CAN_FB_FR2_FB26 = 0x4000000
	// Position of FB27 field.
	CAN_FB_FR2_FB27_Pos = 0x1b
	// Bit mask of FB27 field.
	CAN_FB_FR2_FB27_Msk = 0x8000000
	// Bit FB27.
	CAN_FB_FR2_FB27 = 0x8000000
	// Position of FB28 field.
	CAN_FB_FR2_FB28_Pos = 0x1c
	// Bit mask of FB28 field.
	CAN_FB_FR2_FB28_Msk = 0x10000000
	// Bit FB28.
	CAN_FB_FR2_FB28 = 0x10000000
	// Position of FB29 field.
	CAN_FB_FR2_FB29_Pos = 0x1d
	// Bit mask of FB29 field.
	CAN_FB_FR2_FB29_Msk = 0x20000000
	// Bit FB29.
	CAN_FB_FR2_FB29 = 0x20000000
	// Position of FB30 field.
	CAN_FB_FR2_FB30_Pos = 0x1e
	// Bit mask of FB30 field.
	CAN_FB_FR2_FB30_Msk = 0x40000000
	// Bit FB30.
	CAN_FB_FR2_FB30 = 0x40000000
	// Position of FB31 field.
	CAN_FB_FR2_FB31_Pos = 0x1f
	// Bit mask of FB31 field.
	CAN_FB_FR2_FB31_Msk = 0x80000000
	// Bit FB31.
	CAN_FB_FR2_FB31 = 0x80000000
)

// Bitfields for USB: Universal serial bus full-speed device interface
const (
	// EP0R: endpoint 0 register
	// Position of EA field.
	USB_FS_EP0R_EA_Pos = 0x0
	// Bit mask of EA field.
	USB_FS_EP0R_EA_Msk = 0xf
	// Position of STAT_TX field.
	USB_FS_EP0R_STAT_TX_Pos = 0x4
	// Bit mask of STAT_TX field.
	USB_FS_EP0R_STAT_TX_Msk = 0x30
	// all transmission requests addressed to this endpoint are ignored
	USB_FS_EP0R_STAT_TX_Disabled = 0x0
	// the endpoint is stalled and all transmission requests result in a STALL handshake
	USB_FS_EP0R_STAT_TX_Stall = 0x1
	// the endpoint is naked and all transmission requests result in a NAK handshake
	USB_FS_EP0R_STAT_TX_Nak = 0x2
	// this endpoint is enabled for transmission
	USB_FS_EP0R_STAT_TX_Valid = 0x3
	// Position of DTOG_TX field.
	USB_FS_EP0R_DTOG_TX_Pos = 0x6
	// Bit mask of DTOG_TX field.
	USB_FS_EP0R_DTOG_TX_Msk = 0x40
	// Bit DTOG_TX.
	USB_FS_EP0R_DTOG_TX = 0x40
	// Position of CTR_TX field.
	USB_FS_EP0R_CTR_TX_Pos = 0x7
	// Bit mask of CTR_TX field.
	USB_FS_EP0R_CTR_TX_Msk = 0x80
	// Bit CTR_TX.
	USB_FS_EP0R_CTR_TX = 0x80
	// Position of EP_KIND field.
	USB_FS_EP0R_EP_KIND_Pos = 0x8
	// Bit mask of EP_KIND field.
	USB_FS_EP0R_EP_KIND_Msk = 0x100
	// Bit EP_KIND.
	USB_FS_EP0R_EP_KIND = 0x100
	// Position of EP_TYPE field.
	USB_FS_EP0R_EP_TYPE_Pos = 0x9
	// Bit mask of EP_TYPE field.
	USB_FS_EP0R_EP_TYPE_Msk = 0x600
	// Bulk endpoint
	USB_FS_EP0R_EP_TYPE_Bulk = 0x0
	// Control endpoint
	USB_FS_EP0R_EP_TYPE_Control = 0x1
	// Iso endpoint
	USB_FS_EP0R_EP_TYPE_Iso = 0x2
	// Interrupt endpoint
	USB_FS_EP0R_EP_TYPE_Interrupt = 0x3
	// Position of SETUP field.
	USB_FS_EP0R_SETUP_Pos = 0xb
	// Bit mask of SETUP field.
	USB_FS_EP0R_SETUP_Msk = 0x800
	// Bit SETUP.
	USB_FS_EP0R_SETUP = 0x800
	// Position of STAT_RX field.
	USB_FS_EP0R_STAT_RX_Pos = 0xc
	// Bit mask of STAT_RX field.
	USB_FS_EP0R_STAT_RX_Msk = 0x3000
	// all reception requests addressed to this endpoint are ignored
	USB_FS_EP0R_STAT_RX_Disabled = 0x0
	// the endpoint is stalled and all reception requests result in a STALL handshake
	USB_FS_EP0R_STAT_RX_Stall = 0x1
	// the endpoint is naked and all reception requests result in a NAK handshake
	USB_FS_EP0R_STAT_RX_Nak = 0x2
	// this endpoint is enabled for reception
	USB_FS_EP0R_STAT_RX_Valid = 0x3
	// Position of DTOG_RX field.
	USB_FS_EP0R_DTOG_RX_Pos = 0xe
	// Bit mask of DTOG_RX field.
	USB_FS_EP0R_DTOG_RX_Msk = 0x4000
	// Bit DTOG_RX.
	USB_FS_EP0R_DTOG_RX = 0x4000
	// Position of CTR_RX field.
	USB_FS_EP0R_CTR_RX_Pos = 0xf
	// Bit mask of CTR_RX field.
	USB_FS_EP0R_CTR_RX_Msk = 0x8000
	// Bit CTR_RX.
	USB_FS_EP0R_CTR_RX = 0x8000

	// EP1R: endpoint 1 register
	// Position of EA field.
	USB_FS_EP1R_EA_Pos = 0x0
	// Bit mask of EA field.
	USB_FS_EP1R_EA_Msk = 0xf
	// Position of STAT_TX field.
	USB_FS_EP1R_STAT_TX_Pos = 0x4
	// Bit mask of STAT_TX field.
	USB_FS_EP1R_STAT_TX_Msk = 0x30
	// all transmission requests addressed to this endpoint are ignored
	USB_FS_EP1R_STAT_TX_Disabled = 0x0
	// the endpoint is stalled and all transmission requests result in a STALL handshake
	USB_FS_EP1R_STAT_TX_Stall = 0x1
	// the endpoint is naked and all transmission requests result in a NAK handshake
	USB_FS_EP1R_STAT_TX_Nak = 0x2
	// this endpoint is enabled for transmission
	USB_FS_EP1R_STAT_TX_Valid = 0x3
	// Position of DTOG_TX field.
	USB_FS_EP1R_DTOG_TX_Pos = 0x6
	// Bit mask of DTOG_TX field.
	USB_FS_EP1R_DTOG_TX_Msk = 0x40
	// Bit DTOG_TX.
	USB_FS_EP1R_DTOG_TX = 0x40
	// Position of CTR_TX field.
	USB_FS_EP1R_CTR_TX_Pos = 0x7
	// Bit mask of CTR_TX field.
	USB_FS_EP1R_CTR_TX_Msk = 0x80
	// Bit CTR_TX.
	USB_FS_EP1R_CTR_TX = 0x80
	// Position of EP_KIND field.
	USB_FS_EP1R_EP_KIND_Pos = 0x8
	// Bit mask of EP_KIND field.
	USB_FS_EP1R_EP_KIND_Msk = 0x100
	// Bit EP_KIND.
	USB_FS_EP1R_EP_KIND = 0x100
	// Position of EP_TYPE field.
	USB_FS_EP1R_EP_TYPE_Pos = 0x9
	// Bit mask of EP_TYPE field.
	USB_FS_EP1R_EP_TYPE_Msk = 0x600
	// Bulk endpoint
	USB_FS_EP1R_EP_TYPE_Bulk = 0x0
	// Control endpoint
	USB_FS_EP1R_EP_TYPE_Control = 0x1
	// Iso endpoint
	USB_FS_EP1R_EP_TYPE_Iso = 0x2
	// Interrupt endpoint
	USB_FS_EP1R_EP_TYPE_Interrupt = 0x3
	// Position of SETUP field.
	USB_FS_EP1R_SETUP_Pos = 0xb
	// Bit mask of SETUP field.
	USB_FS_EP1R_SETUP_Msk = 0x800
	// Bit SETUP.
	USB_FS_EP1R_SETUP = 0x800
	// Position of STAT_RX field.
	USB_FS_EP1R_STAT_RX_Pos = 0xc
	// Bit mask of STAT_RX field.
	USB_FS_EP1R_STAT_RX_Msk = 0x3000
	// all reception requests addressed to this endpoint are ignored
	USB_FS_EP1R_STAT_RX_Disabled = 0x0
	// the endpoint is stalled and all reception requests result in a STALL handshake
	USB_FS_EP1R_STAT_RX_Stall = 0x1
	// the endpoint is naked and all reception requests result in a NAK handshake
	USB_FS_EP1R_STAT_RX_Nak = 0x2
	// this endpoint is enabled for reception
	USB_FS_EP1R_STAT_RX_Valid = 0x3
	// Position of DTOG_RX field.
	USB_FS_EP1R_DTOG_RX_Pos = 0xe
	// Bit mask of DTOG_RX field.
	USB_FS_EP1R_DTOG_RX_Msk = 0x4000
	// Bit DTOG_RX.
	USB_FS_EP1R_DTOG_RX = 0x4000
	// Position of CTR_RX field.
	USB_FS_EP1R_CTR_RX_Pos = 0xf
	// Bit mask of CTR_RX field.
	USB_FS_EP1R_CTR_RX_Msk = 0x8000
	// Bit CTR_RX.
	USB_FS_EP1R_CTR_RX = 0x8000

	// EP2R: endpoint 2 register
	// Position of EA field.
	USB_FS_EP2R_EA_Pos = 0x0
	// Bit mask of EA field.
	USB_FS_EP2R_EA_Msk = 0xf
	// Position of STAT_TX field.
	USB_FS_EP2R_STAT_TX_Pos = 0x4
	// Bit mask of STAT_TX field.
	USB_FS_EP2R_STAT_TX_Msk = 0x30
	// all transmission requests addressed to this endpoint are ignored
	USB_FS_EP2R_STAT_TX_Disabled = 0x0
	// the endpoint is stalled and all transmission requests result in a STALL handshake
	USB_FS_EP2R_STAT_TX_Stall = 0x1
	// the endpoint is naked and all transmission requests result in a NAK handshake
	USB_FS_EP2R_STAT_TX_Nak = 0x2
	// this endpoint is enabled for transmission
	USB_FS_EP2R_STAT_TX_Valid = 0x3
	// Position of DTOG_TX field.
	USB_FS_EP2R_DTOG_TX_Pos = 0x6
	// Bit mask of DTOG_TX field.
	USB_FS_EP2R_DTOG_TX_Msk = 0x40
	// Bit DTOG_TX.
	USB_FS_EP2R_DTOG_TX = 0x40
	// Position of CTR_TX field.
	USB_FS_EP2R_CTR_TX_Pos = 0x7
	// Bit mask of CTR_TX field.
	USB_FS_EP2R_CTR_TX_Msk = 0x80
	// Bit CTR_TX.
	USB_FS_EP2R_CTR_TX = 0x80
	// Position of EP_KIND field.
	USB_FS_EP2R_EP_KIND_Pos = 0x8
	// Bit mask of EP_KIND field.
	USB_FS_EP2R_EP_KIND_Msk = 0x100
	// Bit EP_KIND.
	USB_FS_EP2R_EP_KIND = 0x100
	// Position of EP_TYPE field.
	USB_FS_EP2R_EP_TYPE_Pos = 0x9
	// Bit mask of EP_TYPE field.
	USB_FS_EP2R_EP_TYPE_Msk = 0x600
	// Bulk endpoint
	USB_FS_EP2R_EP_TYPE_Bulk = 0x0
	// Control endpoint
	USB_FS_EP2R_EP_TYPE_Control = 0x1
	// Iso endpoint
	USB_FS_EP2R_EP_TYPE_Iso = 0x2
	// Interrupt endpoint
	USB_FS_EP2R_EP_TYPE_Interrupt = 0x3
	// Position of SETUP field.
	USB_FS_EP2R_SETUP_Pos = 0xb
	// Bit mask of SETUP field.
	USB_FS_EP2R_SETUP_Msk = 0x800
	// Bit SETUP.
	USB_FS_EP2R_SETUP = 0x800
	// Position of STAT_RX field.
	USB_FS_EP2R_STAT_RX_Pos = 0xc
	// Bit mask of STAT_RX field.
	USB_FS_EP2R_STAT_RX_Msk = 0x3000
	// all reception requests addressed to this endpoint are ignored
	USB_FS_EP2R_STAT_RX_Disabled = 0x0
	// the endpoint is stalled and all reception requests result in a STALL handshake
	USB_FS_EP2R_STAT_RX_Stall = 0x1
	// the endpoint is naked and all reception requests result in a NAK handshake
	USB_FS_EP2R_STAT_RX_Nak = 0x2
	// this endpoint is enabled for reception
	USB_FS_EP2R_STAT_RX_Valid = 0x3
	// Position of DTOG_RX field.
	USB_FS_EP2R_DTOG_RX_Pos = 0xe
	// Bit mask of DTOG_RX field.
	USB_FS_EP2R_DTOG_RX_Msk = 0x4000
	// Bit DTOG_RX.
	USB_FS_EP2R_DTOG_RX = 0x4000
	// Position of CTR_RX field.
	USB_FS_EP2R_CTR_RX_Pos = 0xf
	// Bit mask of CTR_RX field.
	USB_FS_EP2R_CTR_RX_Msk = 0x8000
	// Bit CTR_RX.
	USB_FS_EP2R_CTR_RX = 0x8000

	// EP3R: endpoint 3 register
	// Position of EA field.
	USB_FS_EP3R_EA_Pos = 0x0
	// Bit mask of EA field.
	USB_FS_EP3R_EA_Msk = 0xf
	// Position of STAT_TX field.
	USB_FS_EP3R_STAT_TX_Pos = 0x4
	// Bit mask of STAT_TX field.
	USB_FS_EP3R_STAT_TX_Msk = 0x30
	// all transmission requests addressed to this endpoint are ignored
	USB_FS_EP3R_STAT_TX_Disabled = 0x0
	// the endpoint is stalled and all transmission requests result in a STALL handshake
	USB_FS_EP3R_STAT_TX_Stall = 0x1
	// the endpoint is naked and all transmission requests result in a NAK handshake
	USB_FS_EP3R_STAT_TX_Nak = 0x2
	// this endpoint is enabled for transmission
	USB_FS_EP3R_STAT_TX_Valid = 0x3
	// Position of DTOG_TX field.
	USB_FS_EP3R_DTOG_TX_Pos = 0x6
	// Bit mask of DTOG_TX field.
	USB_FS_EP3R_DTOG_TX_Msk = 0x40
	// Bit DTOG_TX.
	USB_FS_EP3R_DTOG_TX = 0x40
	// Position of CTR_TX field.
	USB_FS_EP3R_CTR_TX_Pos = 0x7
	// Bit mask of CTR_TX field.
	USB_FS_EP3R_CTR_TX_Msk = 0x80
	// Bit CTR_TX.
	USB_FS_EP3R_CTR_TX = 0x80
	// Position of EP_KIND field.
	USB_FS_EP3R_EP_KIND_Pos = 0x8
	// Bit mask of EP_KIND field.
	USB_FS_EP3R_EP_KIND_Msk = 0x100
	// Bit EP_KIND.
	USB_FS_EP3R_EP_KIND = 0x100
	// Position of EP_TYPE field.
	USB_FS_EP3R_EP_TYPE_Pos = 0x9
	// Bit mask of EP_TYPE field.
	USB_FS_EP3R_EP_TYPE_Msk = 0x600
	// Bulk endpoint
	USB_FS_EP3R_EP_TYPE_Bulk = 0x0
	// Control endpoint
	USB_FS_EP3R_EP_TYPE_Control = 0x1
	// Iso endpoint
	USB_FS_EP3R_EP_TYPE_Iso = 0x2
	// Interrupt endpoint
	USB_FS_EP3R_EP_TYPE_Interrupt = 0x3
	// Position of SETUP field.
	USB_FS_EP3R_SETUP_Pos = 0xb
	// Bit mask of SETUP field.
	USB_FS_EP3R_SETUP_Msk = 0x800
	// Bit SETUP.
	USB_FS_EP3R_SETUP = 0x800
	// Position of STAT_RX field.
	USB_FS_EP3R_STAT_RX_Pos = 0xc
	// Bit mask of STAT_RX field.
	USB_FS_EP3R_STAT_RX_Msk = 0x3000
	// all reception requests addressed to this endpoint are ignored
	USB_FS_EP3R_STAT_RX_Disabled = 0x0
	// the endpoint is stalled and all reception requests result in a STALL handshake
	USB_FS_EP3R_STAT_RX_Stall = 0x1
	// the endpoint is naked and all reception requests result in a NAK handshake
	USB_FS_EP3R_STAT_RX_Nak = 0x2
	// this endpoint is enabled for reception
	USB_FS_EP3R_STAT_RX_Valid = 0x3
	// Position of DTOG_RX field.
	USB_FS_EP3R_DTOG_RX_Pos = 0xe
	// Bit mask of DTOG_RX field.
	USB_FS_EP3R_DTOG_RX_Msk = 0x4000
	// Bit DTOG_RX.
	USB_FS_EP3R_DTOG_RX = 0x4000
	// Position of CTR_RX field.
	USB_FS_EP3R_CTR_RX_Pos = 0xf
	// Bit mask of CTR_RX field.
	USB_FS_EP3R_CTR_RX_Msk = 0x8000
	// Bit CTR_RX.
	USB_FS_EP3R_CTR_RX = 0x8000

	// EP4R: endpoint 4 register
	// Position of EA field.
	USB_FS_EP4R_EA_Pos = 0x0
	// Bit mask of EA field.
	USB_FS_EP4R_EA_Msk = 0xf
	// Position of STAT_TX field.
	USB_FS_EP4R_STAT_TX_Pos = 0x4
	// Bit mask of STAT_TX field.
	USB_FS_EP4R_STAT_TX_Msk = 0x30
	// all transmission requests addressed to this endpoint are ignored
	USB_FS_EP4R_STAT_TX_Disabled = 0x0
	// the endpoint is stalled and all transmission requests result in a STALL handshake
	USB_FS_EP4R_STAT_TX_Stall = 0x1
	// the endpoint is naked and all transmission requests result in a NAK handshake
	USB_FS_EP4R_STAT_TX_Nak = 0x2
	// this endpoint is enabled for transmission
	USB_FS_EP4R_STAT_TX_Valid = 0x3
	// Position of DTOG_TX field.
	USB_FS_EP4R_DTOG_TX_Pos = 0x6
	// Bit mask of DTOG_TX field.
	USB_FS_EP4R_DTOG_TX_Msk = 0x40
	// Bit DTOG_TX.
	USB_FS_EP4R_DTOG_TX = 0x40
	// Position of CTR_TX field.
	USB_FS_EP4R_CTR_TX_Pos = 0x7
	// Bit mask of CTR_TX field.
	USB_FS_EP4R_CTR_TX_Msk = 0x80
	// Bit CTR_TX.
	USB_FS_EP4R_CTR_TX = 0x80
	// Position of EP_KIND field.
	USB_FS_EP4R_EP_KIND_Pos = 0x8
	// Bit mask of EP_KIND field.
	USB_FS_EP4R_EP_KIND_Msk = 0x100
	// Bit EP_KIND.
	USB_FS_EP4R_EP_KIND = 0x100
	// Position of EP_TYPE field.
	USB_FS_EP4R_EP_TYPE_Pos = 0x9
	// Bit mask of EP_TYPE field.
	USB_FS_EP4R_EP_TYPE_Msk = 0x600
	// Bulk endpoint
	USB_FS_EP4R_EP_TYPE_Bulk = 0x0
	// Control endpoint
	USB_FS_EP4R_EP_TYPE_Control = 0x1
	// Iso endpoint
	USB_FS_EP4R_EP_TYPE_Iso = 0x2
	// Interrupt endpoint
	USB_FS_EP4R_EP_TYPE_Interrupt = 0x3
	// Position of SETUP field.
	USB_FS_EP4R_SETUP_Pos = 0xb
	// Bit mask of SETUP field.
	USB_FS_EP4R_SETUP_Msk = 0x800
	// Bit SETUP.
	USB_FS_EP4R_SETUP = 0x800
	// Position of STAT_RX field.
	USB_FS_EP4R_STAT_RX_Pos = 0xc
	// Bit mask of STAT_RX field.
	USB_FS_EP4R_STAT_RX_Msk = 0x3000
	// all reception requests addressed to this endpoint are ignored
	USB_FS_EP4R_STAT_RX_Disabled = 0x0
	// the endpoint is stalled and all reception requests result in a STALL handshake
	USB_FS_EP4R_STAT_RX_Stall = 0x1
	// the endpoint is naked and all reception requests result in a NAK handshake
	USB_FS_EP4R_STAT_RX_Nak = 0x2
	// this endpoint is enabled for reception
	USB_FS_EP4R_STAT_RX_Valid = 0x3
	// Position of DTOG_RX field.
	USB_FS_EP4R_DTOG_RX_Pos = 0xe
	// Bit mask of DTOG_RX field.
	USB_FS_EP4R_DTOG_RX_Msk = 0x4000
	// Bit DTOG_RX.
	USB_FS_EP4R_DTOG_RX = 0x4000
	// Position of CTR_RX field.
	USB_FS_EP4R_CTR_RX_Pos = 0xf
	// Bit mask of CTR_RX field.
	USB_FS_EP4R_CTR_RX_Msk = 0x8000
	// Bit CTR_RX.
	USB_FS_EP4R_CTR_RX = 0x8000

	// EP5R: endpoint 5 register
	// Position of EA field.
	USB_FS_EP5R_EA_Pos = 0x0
	// Bit mask of EA field.
	USB_FS_EP5R_EA_Msk = 0xf
	// Position of STAT_TX field.
	USB_FS_EP5R_STAT_TX_Pos = 0x4
	// Bit mask of STAT_TX field.
	USB_FS_EP5R_STAT_TX_Msk = 0x30
	// all transmission requests addressed to this endpoint are ignored
	USB_FS_EP5R_STAT_TX_Disabled = 0x0
	// the endpoint is stalled and all transmission requests result in a STALL handshake
	USB_FS_EP5R_STAT_TX_Stall = 0x1
	// the endpoint is naked and all transmission requests result in a NAK handshake
	USB_FS_EP5R_STAT_TX_Nak = 0x2
	// this endpoint is enabled for transmission
	USB_FS_EP5R_STAT_TX_Valid = 0x3
	// Position of DTOG_TX field.
	USB_FS_EP5R_DTOG_TX_Pos = 0x6
	// Bit mask of DTOG_TX field.
	USB_FS_EP5R_DTOG_TX_Msk = 0x40
	// Bit DTOG_TX.
	USB_FS_EP5R_DTOG_TX = 0x40
	// Position of CTR_TX field.
	USB_FS_EP5R_CTR_TX_Pos = 0x7
	// Bit mask of CTR_TX field.
	USB_FS_EP5R_CTR_TX_Msk = 0x80
	// Bit CTR_TX.
	USB_FS_EP5R_CTR_TX = 0x80
	// Position of EP_KIND field.
	USB_FS_EP5R_EP_KIND_Pos = 0x8
	// Bit mask of EP_KIND field.
	USB_FS_EP5R_EP_KIND_Msk = 0x100
	// Bit EP_KIND.
	USB_FS_EP5R_EP_KIND = 0x100
	// Position of EP_TYPE field.
	USB_FS_EP5R_EP_TYPE_Pos = 0x9
	// Bit mask of EP_TYPE field.
	USB_FS_EP5R_EP_TYPE_Msk = 0x600
	// Bulk endpoint
	USB_FS_EP5R_EP_TYPE_Bulk = 0x0
	// Control endpoint
	USB_FS_EP5R_EP_TYPE_Control = 0x1
	// Iso endpoint
	USB_FS_EP5R_EP_TYPE_Iso = 0x2
	// Interrupt endpoint
	USB_FS_EP5R_EP_TYPE_Interrupt = 0x3
	// Position of SETUP field.
	USB_FS_EP5R_SETUP_Pos = 0xb
	// Bit mask of SETUP field.
	USB_FS_EP5R_SETUP_Msk = 0x800
	// Bit SETUP.
	USB_FS_EP5R_SETUP = 0x800
	// Position of STAT_RX field.
	USB_FS_EP5R_STAT_RX_Pos = 0xc
	// Bit mask of STAT_RX field.
	USB_FS_EP5R_STAT_RX_Msk = 0x3000
	// all reception requests addressed to this endpoint are ignored
	USB_FS_EP5R_STAT_RX_Disabled = 0x0
	// the endpoint is stalled and all reception requests result in a STALL handshake
	USB_FS_EP5R_STAT_RX_Stall = 0x1
	// the endpoint is naked and all reception requests result in a NAK handshake
	USB_FS_EP5R_STAT_RX_Nak = 0x2
	// this endpoint is enabled for reception
	USB_FS_EP5R_STAT_RX_Valid = 0x3
	// Position of DTOG_RX field.
	USB_FS_EP5R_DTOG_RX_Pos = 0xe
	// Bit mask of DTOG_RX field.
	USB_FS_EP5R_DTOG_RX_Msk = 0x4000
	// Bit DTOG_RX.
	USB_FS_EP5R_DTOG_RX = 0x4000
	// Position of CTR_RX field.
	USB_FS_EP5R_CTR_RX_Pos = 0xf
	// Bit mask of CTR_RX field.
	USB_FS_EP5R_CTR_RX_Msk = 0x8000
	// Bit CTR_RX.
	USB_FS_EP5R_CTR_RX = 0x8000

	// EP6R: endpoint 6 register
	// Position of EA field.
	USB_FS_EP6R_EA_Pos = 0x0
	// Bit mask of EA field.
	USB_FS_EP6R_EA_Msk = 0xf
	// Position of STAT_TX field.
	USB_FS_EP6R_STAT_TX_Pos = 0x4
	// Bit mask of STAT_TX field.
	USB_FS_EP6R_STAT_TX_Msk = 0x30
	// all transmission requests addressed to this endpoint are ignored
	USB_FS_EP6R_STAT_TX_Disabled = 0x0
	// the endpoint is stalled and all transmission requests result in a STALL handshake
	USB_FS_EP6R_STAT_TX_Stall = 0x1
	// the endpoint is naked and all transmission requests result in a NAK handshake
	USB_FS_EP6R_STAT_TX_Nak = 0x2
	// this endpoint is enabled for transmission
	USB_FS_EP6R_STAT_TX_Valid = 0x3
	// Position of DTOG_TX field.
	USB_FS_EP6R_DTOG_TX_Pos = 0x6
	// Bit mask of DTOG_TX field.
	USB_FS_EP6R_DTOG_TX_Msk = 0x40
	// Bit DTOG_TX.
	USB_FS_EP6R_DTOG_TX = 0x40
	// Position of CTR_TX field.
	USB_FS_EP6R_CTR_TX_Pos = 0x7
	// Bit mask of CTR_TX field.
	USB_FS_EP6R_CTR_TX_Msk = 0x80
	// Bit CTR_TX.
	USB_FS_EP6R_CTR_TX = 0x80
	// Position of EP_KIND field.
	USB_FS_EP6R_EP_KIND_Pos = 0x8
	// Bit mask of EP_KIND field.
	USB_FS_EP6R_EP_KIND_Msk = 0x100
	// Bit EP_KIND.
	USB_FS_EP6R_EP_KIND = 0x100
	// Position of EP_TYPE field.
	USB_FS_EP6R_EP_TYPE_Pos = 0x9
	// Bit mask of EP_TYPE field.
	USB_FS_EP6R_EP_TYPE_Msk = 0x600
	// Bulk endpoint
	USB_FS_EP6R_EP_TYPE_Bulk = 0x0
	// Control endpoint
	USB_FS_EP6R_EP_TYPE_Control = 0x1
	// Iso endpoint
	USB_FS_EP6R_EP_TYPE_Iso = 0x2
	// Interrupt endpoint
	USB_FS_EP6R_EP_TYPE_Interrupt = 0x3
	// Position of SETUP field.
	USB_FS_EP6R_SETUP_Pos = 0xb
	// Bit mask of SETUP field.
	USB_FS_EP6R_SETUP_Msk = 0x800
	// Bit SETUP.
	USB_FS_EP6R_SETUP = 0x800
	// Position of STAT_RX field.
	USB_FS_EP6R_STAT_RX_Pos = 0xc
	// Bit mask of STAT_RX field.
	USB_FS_EP6R_STAT_RX_Msk = 0x3000
	// all reception requests addressed to this endpoint are ignored
	USB_FS_EP6R_STAT_RX_Disabled = 0x0
	// the endpoint is stalled and all reception requests result in a STALL handshake
	USB_FS_EP6R_STAT_RX_Stall = 0x1
	// the endpoint is naked and all reception requests result in a NAK handshake
	USB_FS_EP6R_STAT_RX_Nak = 0x2
	// this endpoint is enabled for reception
	USB_FS_EP6R_STAT_RX_Valid = 0x3
	// Position of DTOG_RX field.
	USB_FS_EP6R_DTOG_RX_Pos = 0xe
	// Bit mask of DTOG_RX field.
	USB_FS_EP6R_DTOG_RX_Msk = 0x4000
	// Bit DTOG_RX.
	USB_FS_EP6R_DTOG_RX = 0x4000
	// Position of CTR_RX field.
	USB_FS_EP6R_CTR_RX_Pos = 0xf
	// Bit mask of CTR_RX field.
	USB_FS_EP6R_CTR_RX_Msk = 0x8000
	// Bit CTR_RX.
	USB_FS_EP6R_CTR_RX = 0x8000

	// EP7R: endpoint 7 register
	// Position of EA field.
	USB_FS_EP7R_EA_Pos = 0x0
	// Bit mask of EA field.
	USB_FS_EP7R_EA_Msk = 0xf
	// Position of STAT_TX field.
	USB_FS_EP7R_STAT_TX_Pos = 0x4
	// Bit mask of STAT_TX field.
	USB_FS_EP7R_STAT_TX_Msk = 0x30
	// all transmission requests addressed to this endpoint are ignored
	USB_FS_EP7R_STAT_TX_Disabled = 0x0
	// the endpoint is stalled and all transmission requests result in a STALL handshake
	USB_FS_EP7R_STAT_TX_Stall = 0x1
	// the endpoint is naked and all transmission requests result in a NAK handshake
	USB_FS_EP7R_STAT_TX_Nak = 0x2
	// this endpoint is enabled for transmission
	USB_FS_EP7R_STAT_TX_Valid = 0x3
	// Position of DTOG_TX field.
	USB_FS_EP7R_DTOG_TX_Pos = 0x6
	// Bit mask of DTOG_TX field.
	USB_FS_EP7R_DTOG_TX_Msk = 0x40
	// Bit DTOG_TX.
	USB_FS_EP7R_DTOG_TX = 0x40
	// Position of CTR_TX field.
	USB_FS_EP7R_CTR_TX_Pos = 0x7
	// Bit mask of CTR_TX field.
	USB_FS_EP7R_CTR_TX_Msk = 0x80
	// Bit CTR_TX.
	USB_FS_EP7R_CTR_TX = 0x80
	// Position of EP_KIND field.
	USB_FS_EP7R_EP_KIND_Pos = 0x8
	// Bit mask of EP_KIND field.
	USB_FS_EP7R_EP_KIND_Msk = 0x100
	// Bit EP_KIND.
	USB_FS_EP7R_EP_KIND = 0x100
	// Position of EP_TYPE field.
	USB_FS_EP7R_EP_TYPE_Pos = 0x9
	// Bit mask of EP_TYPE field.
	USB_FS_EP7R_EP_TYPE_Msk = 0x600
	// Bulk endpoint
	USB_FS_EP7R_EP_TYPE_Bulk = 0x0
	// Control endpoint
	USB_FS_EP7R_EP_TYPE_Control = 0x1
	// Iso endpoint
	USB_FS_EP7R_EP_TYPE_Iso = 0x2
	// Interrupt endpoint
	USB_FS_EP7R_EP_TYPE_Interrupt = 0x3
	// Position of SETUP field.
	USB_FS_EP7R_SETUP_Pos = 0xb
	// Bit mask of SETUP field.
	USB_FS_EP7R_SETUP_Msk = 0x800
	// Bit SETUP.
	USB_FS_EP7R_SETUP = 0x800
	// Position of STAT_RX field.
	USB_FS_EP7R_STAT_RX_Pos = 0xc
	// Bit mask of STAT_RX field.
	USB_FS_EP7R_STAT_RX_Msk = 0x3000
	// all reception requests addressed to this endpoint are ignored
	USB_FS_EP7R_STAT_RX_Disabled = 0x0
	// the endpoint is stalled and all reception requests result in a STALL handshake
	USB_FS_EP7R_STAT_RX_Stall = 0x1
	// the endpoint is naked and all reception requests result in a NAK handshake
	USB_FS_EP7R_STAT_RX_Nak = 0x2
	// this endpoint is enabled for reception
	USB_FS_EP7R_STAT_RX_Valid = 0x3
	// Position of DTOG_RX field.
	USB_FS_EP7R_DTOG_RX_Pos = 0xe
	// Bit mask of DTOG_RX field.
	USB_FS_EP7R_DTOG_RX_Msk = 0x4000
	// Bit DTOG_RX.
	USB_FS_EP7R_DTOG_RX = 0x4000
	// Position of CTR_RX field.
	USB_FS_EP7R_CTR_RX_Pos = 0xf
	// Bit mask of CTR_RX field.
	USB_FS_EP7R_CTR_RX_Msk = 0x8000
	// Bit CTR_RX.
	USB_FS_EP7R_CTR_RX = 0x8000

	// CNTR: control register
	// Position of FRES field.
	USB_FS_CNTR_FRES_Pos = 0x0
	// Bit mask of FRES field.
	USB_FS_CNTR_FRES_Msk = 0x1
	// Bit FRES.
	USB_FS_CNTR_FRES = 0x1
	// Clear USB reset
	USB_FS_CNTR_FRES_NoReset = 0x0
	// Force a reset of the USB peripheral, exactly like a RESET signaling on the USB
	USB_FS_CNTR_FRES_Reset = 0x1
	// Position of PDWN field.
	USB_FS_CNTR_PDWN_Pos = 0x1
	// Bit mask of PDWN field.
	USB_FS_CNTR_PDWN_Msk = 0x2
	// Bit PDWN.
	USB_FS_CNTR_PDWN = 0x2
	// No power down
	USB_FS_CNTR_PDWN_Disabled = 0x0
	// Enter power down mode
	USB_FS_CNTR_PDWN_Enabled = 0x1
	// Position of LPMODE field.
	USB_FS_CNTR_LPMODE_Pos = 0x2
	// Bit mask of LPMODE field.
	USB_FS_CNTR_LPMODE_Msk = 0x4
	// Bit LPMODE.
	USB_FS_CNTR_LPMODE = 0x4
	// No low-power mode
	USB_FS_CNTR_LPMODE_Disabled = 0x0
	// Enter low-power mode
	USB_FS_CNTR_LPMODE_Enabled = 0x1
	// Position of FSUSP field.
	USB_FS_CNTR_FSUSP_Pos = 0x3
	// Bit mask of FSUSP field.
	USB_FS_CNTR_FSUSP_Msk = 0x8
	// Bit FSUSP.
	USB_FS_CNTR_FSUSP = 0x8
	// No effect
	USB_FS_CNTR_FSUSP_NoEffect = 0x0
	// Enter suspend mode. Clocks and static power dissipation in the analog transceiver are left unaffected
	USB_FS_CNTR_FSUSP_Suspend = 0x1
	// Position of RESUME field.
	USB_FS_CNTR_RESUME_Pos = 0x4
	// Bit mask of RESUME field.
	USB_FS_CNTR_RESUME_Msk = 0x10
	// Bit RESUME.
	USB_FS_CNTR_RESUME = 0x10
	// Resume requested
	USB_FS_CNTR_RESUME_Requested = 0x1
	// Position of ESOFM field.
	USB_FS_CNTR_ESOFM_Pos = 0x8
	// Bit mask of ESOFM field.
	USB_FS_CNTR_ESOFM_Msk = 0x100
	// Bit ESOFM.
	USB_FS_CNTR_ESOFM = 0x100
	// ESOF Interrupt disabled
	USB_FS_CNTR_ESOFM_Disabled = 0x0
	// ESOF Interrupt enabled, an interrupt request is generated when the corresponding bit in the USB_ISTR register is set
	USB_FS_CNTR_ESOFM_Enabled = 0x1
	// Position of SOFM field.
	USB_FS_CNTR_SOFM_Pos = 0x9
	// Bit mask of SOFM field.
	USB_FS_CNTR_SOFM_Msk = 0x200
	// Bit SOFM.
	USB_FS_CNTR_SOFM = 0x200
	// SOF Interrupt disabled
	USB_FS_CNTR_SOFM_Disabled = 0x0
	// SOF Interrupt enabled, an interrupt request is generated when the corresponding bit in the USB_ISTR register is set
	USB_FS_CNTR_SOFM_Enabled = 0x1
	// Position of RESETM field.
	USB_FS_CNTR_RESETM_Pos = 0xa
	// Bit mask of RESETM field.
	USB_FS_CNTR_RESETM_Msk = 0x400
	// Bit RESETM.
	USB_FS_CNTR_RESETM = 0x400
	// RESET Interrupt disabled
	USB_FS_CNTR_RESETM_Disabled = 0x0
	// RESET Interrupt enabled, an interrupt request is generated when the corresponding bit in the USB_ISTR register is set
	USB_FS_CNTR_RESETM_Enabled = 0x1
	// Position of SUSPM field.
	USB_FS_CNTR_SUSPM_Pos = 0xb
	// Bit mask of SUSPM field.
	USB_FS_CNTR_SUSPM_Msk = 0x800
	// Bit SUSPM.
	USB_FS_CNTR_SUSPM = 0x800
	// Suspend Mode Request SUSP Interrupt disabled
	USB_FS_CNTR_SUSPM_Disabled = 0x0
	// SUSP Interrupt enabled, an interrupt request is generated when the corresponding bit in the USB_ISTR register is set
	USB_FS_CNTR_SUSPM_Enabled = 0x1
	// Position of WKUPM field.
	USB_FS_CNTR_WKUPM_Pos = 0xc
	// Bit mask of WKUPM field.
	USB_FS_CNTR_WKUPM_Msk = 0x1000
	// Bit WKUPM.
	USB_FS_CNTR_WKUPM = 0x1000
	// WKUP Interrupt disabled
	USB_FS_CNTR_WKUPM_Disabled = 0x0
	// WKUP Interrupt enabled, an interrupt request is generated when the corresponding bit in the USB_ISTR register is set
	USB_FS_CNTR_WKUPM_Enabled = 0x1
	// Position of ERRM field.
	USB_FS_CNTR_ERRM_Pos = 0xd
	// Bit mask of ERRM field.
	USB_FS_CNTR_ERRM_Msk = 0x2000
	// Bit ERRM.
	USB_FS_CNTR_ERRM = 0x2000
	// ERR Interrupt disabled
	USB_FS_CNTR_ERRM_Disabled = 0x0
	// ERR Interrupt enabled, an interrupt request is generated when the corresponding bit in the USB_ISTR register is set
	USB_FS_CNTR_ERRM_Enabled = 0x1
	// Position of PMAOVRM field.
	USB_FS_CNTR_PMAOVRM_Pos = 0xe
	// Bit mask of PMAOVRM field.
	USB_FS_CNTR_PMAOVRM_Msk = 0x4000
	// Bit PMAOVRM.
	USB_FS_CNTR_PMAOVRM = 0x4000
	// PMAOVR Interrupt disabled
	USB_FS_CNTR_PMAOVRM_Disabled = 0x0
	// PMAOVR Interrupt enabled, an interrupt request is generated when the corresponding bit in the USB_ISTR register is set
	USB_FS_CNTR_PMAOVRM_Enabled = 0x1
	// Position of CTRM field.
	USB_FS_CNTR_CTRM_Pos = 0xf
	// Bit mask of CTRM field.
	USB_FS_CNTR_CTRM_Msk = 0x8000
	// Bit CTRM.
	USB_FS_CNTR_CTRM = 0x8000
	// Correct Transfer (CTR) Interrupt disabled
	USB_FS_CNTR_CTRM_Disabled = 0x0
	// CTR Interrupt enabled, an interrupt request is generated when the corresponding bit in the USB_ISTR register is set
	USB_FS_CNTR_CTRM_Enabled = 0x1

	// ISTR: interrupt status register
	// Position of EP_ID field.
	USB_FS_ISTR_EP_ID_Pos = 0x0
	// Bit mask of EP_ID field.
	USB_FS_ISTR_EP_ID_Msk = 0xf
	// Position of DIR field.
	USB_FS_ISTR_DIR_Pos = 0x4
	// Bit mask of DIR field.
	USB_FS_ISTR_DIR_Msk = 0x10
	// Bit DIR.
	USB_FS_ISTR_DIR = 0x10
	// data transmitted by the USB peripheral to the host PC
	USB_FS_ISTR_DIR_To = 0x0
	// data received by the USB peripheral from the host PC
	USB_FS_ISTR_DIR_From = 0x1
	// Position of ESOF field.
	USB_FS_ISTR_ESOF_Pos = 0x8
	// Bit mask of ESOF field.
	USB_FS_ISTR_ESOF_Msk = 0x100
	// Bit ESOF.
	USB_FS_ISTR_ESOF = 0x100
	// an SOF packet is expected but not received
	USB_FS_ISTR_ESOF_ExpectedStartOfFrame = 0x1
	// Position of SOF field.
	USB_FS_ISTR_SOF_Pos = 0x9
	// Bit mask of SOF field.
	USB_FS_ISTR_SOF_Msk = 0x200
	// Bit SOF.
	USB_FS_ISTR_SOF = 0x200
	// beginning of a new USB frame and it is set when a SOF packet arrives through the USB bus
	USB_FS_ISTR_SOF_StartOfFrame = 0x1
	// Position of RESET field.
	USB_FS_ISTR_RESET_Pos = 0xa
	// Bit mask of RESET field.
	USB_FS_ISTR_RESET_Msk = 0x400
	// Bit RESET.
	USB_FS_ISTR_RESET = 0x400
	// peripheral detects an active USB RESET signal at its inputs
	USB_FS_ISTR_RESET_Reset = 0x1
	// Position of SUSP field.
	USB_FS_ISTR_SUSP_Pos = 0xb
	// Bit mask of SUSP field.
	USB_FS_ISTR_SUSP_Msk = 0x800
	// Bit SUSP.
	USB_FS_ISTR_SUSP = 0x800
	// no traffic has been received for 3 ms, indicating a suspend mode request from the USB bus
	USB_FS_ISTR_SUSP_Suspend = 0x1
	// Position of WKUP field.
	USB_FS_ISTR_WKUP_Pos = 0xc
	// Bit mask of WKUP field.
	USB_FS_ISTR_WKUP_Msk = 0x1000
	// Bit WKUP.
	USB_FS_ISTR_WKUP = 0x1000
	// activity is detected that wakes up the USB peripheral
	USB_FS_ISTR_WKUP_Wakeup = 0x1
	// Position of ERR field.
	USB_FS_ISTR_ERR_Pos = 0xd
	// Bit mask of ERR field.
	USB_FS_ISTR_ERR_Msk = 0x2000
	// Bit ERR.
	USB_FS_ISTR_ERR = 0x2000
	// One of No ANSwer, Cyclic Redundancy Check, Bit Stuffing or Framing format Violation error occurred
	USB_FS_ISTR_ERR_Error = 0x1
	// Position of PMAOVR field.
	USB_FS_ISTR_PMAOVR_Pos = 0xe
	// Bit mask of PMAOVR field.
	USB_FS_ISTR_PMAOVR_Msk = 0x4000
	// Bit PMAOVR.
	USB_FS_ISTR_PMAOVR = 0x4000
	// microcontroller has not been able to respond in time to an USB memory request
	USB_FS_ISTR_PMAOVR_Overrun = 0x1
	// Position of CTR field.
	USB_FS_ISTR_CTR_Pos = 0xf
	// Bit mask of CTR field.
	USB_FS_ISTR_CTR_Msk = 0x8000
	// Bit CTR.
	USB_FS_ISTR_CTR = 0x8000
	// endpoint has successfully completed a transaction
	USB_FS_ISTR_CTR_Completed = 0x1

	// FNR: frame number register
	// Position of FN field.
	USB_FS_FNR_FN_Pos = 0x0
	// Bit mask of FN field.
	USB_FS_FNR_FN_Msk = 0x7ff
	// Position of LSOF field.
	USB_FS_FNR_LSOF_Pos = 0xb
	// Bit mask of LSOF field.
	USB_FS_FNR_LSOF_Msk = 0x1800
	// Position of LCK field.
	USB_FS_FNR_LCK_Pos = 0xd
	// Bit mask of LCK field.
	USB_FS_FNR_LCK_Msk = 0x2000
	// Bit LCK.
	USB_FS_FNR_LCK = 0x2000
	// the frame timer remains in this state until an USB reset or USB suspend event occurs
	USB_FS_FNR_LCK_Locked = 0x1
	// Position of RXDM field.
	USB_FS_FNR_RXDM_Pos = 0xe
	// Bit mask of RXDM field.
	USB_FS_FNR_RXDM_Msk = 0x4000
	// Bit RXDM.
	USB_FS_FNR_RXDM = 0x4000
	// received data minus upstream port data line
	USB_FS_FNR_RXDM_Received = 0x1
	// Position of RXDP field.
	USB_FS_FNR_RXDP_Pos = 0xf
	// Bit mask of RXDP field.
	USB_FS_FNR_RXDP_Msk = 0x8000
	// Bit RXDP.
	USB_FS_FNR_RXDP = 0x8000
	// received data plus upstream port data line
	USB_FS_FNR_RXDP_Received = 0x1

	// DADDR: device address
	// Position of ADD field.
	USB_FS_DADDR_ADD_Pos = 0x0
	// Bit mask of ADD field.
	USB_FS_DADDR_ADD_Msk = 0x1
	// Bit ADD.
	USB_FS_DADDR_ADD = 0x1
	// Position of ADD1 field.
	USB_FS_DADDR_ADD1_Pos = 0x1
	// Bit mask of ADD1 field.
	USB_FS_DADDR_ADD1_Msk = 0x2
	// Bit ADD1.
	USB_FS_DADDR_ADD1 = 0x2
	// Position of ADD2 field.
	USB_FS_DADDR_ADD2_Pos = 0x2
	// Bit mask of ADD2 field.
	USB_FS_DADDR_ADD2_Msk = 0x4
	// Bit ADD2.
	USB_FS_DADDR_ADD2 = 0x4
	// Position of ADD3 field.
	USB_FS_DADDR_ADD3_Pos = 0x3
	// Bit mask of ADD3 field.
	USB_FS_DADDR_ADD3_Msk = 0x8
	// Bit ADD3.
	USB_FS_DADDR_ADD3 = 0x8
	// Position of ADD4 field.
	USB_FS_DADDR_ADD4_Pos = 0x4
	// Bit mask of ADD4 field.
	USB_FS_DADDR_ADD4_Msk = 0x10
	// Bit ADD4.
	USB_FS_DADDR_ADD4 = 0x10
	// Position of ADD5 field.
	USB_FS_DADDR_ADD5_Pos = 0x5
	// Bit mask of ADD5 field.
	USB_FS_DADDR_ADD5_Msk = 0x20
	// Bit ADD5.
	USB_FS_DADDR_ADD5 = 0x20
	// Position of ADD6 field.
	USB_FS_DADDR_ADD6_Pos = 0x6
	// Bit mask of ADD6 field.
	USB_FS_DADDR_ADD6_Msk = 0x40
	// Bit ADD6.
	USB_FS_DADDR_ADD6 = 0x40
	// Position of EF field.
	USB_FS_DADDR_EF_Pos = 0x7
	// Bit mask of EF field.
	USB_FS_DADDR_EF_Msk = 0x80
	// Bit EF.
	USB_FS_DADDR_EF = 0x80
	// USB device disabled
	USB_FS_DADDR_EF_Disabled = 0x0
	// USB device enabled
	USB_FS_DADDR_EF_Enabled = 0x1

	// BTABLE: Buffer table address
	// Position of BTABLE field.
	USB_FS_BTABLE_BTABLE_Pos = 0x3
	// Bit mask of BTABLE field.
	USB_FS_BTABLE_BTABLE_Msk = 0xfff8
)

// Bitfields for I2C1: Inter-integrated circuit
const (
	// CR1: Control register 1
	// Position of PE field.
	I2C_CR1_PE_Pos = 0x0
	// Bit mask of PE field.
	I2C_CR1_PE_Msk = 0x1
	// Bit PE.
	I2C_CR1_PE = 0x1
	// Peripheral disabled
	I2C_CR1_PE_Disabled = 0x0
	// Peripheral enabled
	I2C_CR1_PE_Enabled = 0x1
	// Position of TXIE field.
	I2C_CR1_TXIE_Pos = 0x1
	// Bit mask of TXIE field.
	I2C_CR1_TXIE_Msk = 0x2
	// Bit TXIE.
	I2C_CR1_TXIE = 0x2
	// Transmit (TXIS) interrupt disabled
	I2C_CR1_TXIE_Disabled = 0x0
	// Transmit (TXIS) interrupt enabled
	I2C_CR1_TXIE_Enabled = 0x1
	// Position of RXIE field.
	I2C_CR1_RXIE_Pos = 0x2
	// Bit mask of RXIE field.
	I2C_CR1_RXIE_Msk = 0x4
	// Bit RXIE.
	I2C_CR1_RXIE = 0x4
	// Receive (RXNE) interrupt disabled
	I2C_CR1_RXIE_Disabled = 0x0
	// Receive (RXNE) interrupt enabled
	I2C_CR1_RXIE_Enabled = 0x1
	// Position of ADDRIE field.
	I2C_CR1_ADDRIE_Pos = 0x3
	// Bit mask of ADDRIE field.
	I2C_CR1_ADDRIE_Msk = 0x8
	// Bit ADDRIE.
	I2C_CR1_ADDRIE = 0x8
	// Address match (ADDR) interrupts disabled
	I2C_CR1_ADDRIE_Disabled = 0x0
	// Address match (ADDR) interrupts enabled
	I2C_CR1_ADDRIE_Enabled = 0x1
	// Position of NACKIE field.
	I2C_CR1_NACKIE_Pos = 0x4
	// Bit mask of NACKIE field.
	I2C_CR1_NACKIE_Msk = 0x10
	// Bit NACKIE.
	I2C_CR1_NACKIE = 0x10
	// Not acknowledge (NACKF) received interrupts disabled
	I2C_CR1_NACKIE_Disabled = 0x0
	// Not acknowledge (NACKF) received interrupts enabled
	I2C_CR1_NACKIE_Enabled = 0x1
	// Position of STOPIE field.
	I2C_CR1_STOPIE_Pos = 0x5
	// Bit mask of STOPIE field.
	I2C_CR1_STOPIE_Msk = 0x20
	// Bit STOPIE.
	I2C_CR1_STOPIE = 0x20
	// Stop detection (STOPF) interrupt disabled
	I2C_CR1_STOPIE_Disabled = 0x0
	// Stop detection (STOPF) interrupt enabled
	I2C_CR1_STOPIE_Enabled = 0x1
	// Position of TCIE field.
	I2C_CR1_TCIE_Pos = 0x6
	// Bit mask of TCIE field.
	I2C_CR1_TCIE_Msk = 0x40
	// Bit TCIE.
	I2C_CR1_TCIE = 0x40
	// Transfer Complete interrupt disabled
	I2C_CR1_TCIE_Disabled = 0x0
	// Transfer Complete interrupt enabled
	I2C_CR1_TCIE_Enabled = 0x1
	// Position of ERRIE field.
	I2C_CR1_ERRIE_Pos = 0x7
	// Bit mask of ERRIE field.
	I2C_CR1_ERRIE_Msk = 0x80
	// Bit ERRIE.
	I2C_CR1_ERRIE = 0x80
	// Error detection interrupts disabled
	I2C_CR1_ERRIE_Disabled = 0x0
	// Error detection interrupts enabled
	I2C_CR1_ERRIE_Enabled = 0x1
	// Position of DNF field.
	I2C_CR1_DNF_Pos = 0x8
	// Bit mask of DNF field.
	I2C_CR1_DNF_Msk = 0xf00
	// Digital filter disabled
	I2C_CR1_DNF_NoFilter = 0x0
	// Digital filter enabled and filtering capability up to 1 tI2CCLK
	I2C_CR1_DNF_Filter1 = 0x1
	// Digital filter enabled and filtering capability up to 2 tI2CCLK
	I2C_CR1_DNF_Filter2 = 0x2
	// Digital filter enabled and filtering capability up to 3 tI2CCLK
	I2C_CR1_DNF_Filter3 = 0x3
	// Digital filter enabled and filtering capability up to 4 tI2CCLK
	I2C_CR1_DNF_Filter4 = 0x4
	// Digital filter enabled and filtering capability up to 5 tI2CCLK
	I2C_CR1_DNF_Filter5 = 0x5
	// Digital filter enabled and filtering capability up to 6 tI2CCLK
	I2C_CR1_DNF_Filter6 = 0x6
	// Digital filter enabled and filtering capability up to 7 tI2CCLK
	I2C_CR1_DNF_Filter7 = 0x7
	// Digital filter enabled and filtering capability up to 8 tI2CCLK
	I2C_CR1_DNF_Filter8 = 0x8
	// Digital filter enabled and filtering capability up to 9 tI2CCLK
	I2C_CR1_DNF_Filter9 = 0x9
	// Digital filter enabled and filtering capability up to 10 tI2CCLK
	I2C_CR1_DNF_Filter10 = 0xa
	// Digital filter enabled and filtering capability up to 11 tI2CCLK
	I2C_CR1_DNF_Filter11 = 0xb
	// Digital filter enabled and filtering capability up to 12 tI2CCLK
	I2C_CR1_DNF_Filter12 = 0xc
	// Digital filter enabled and filtering capability up to 13 tI2CCLK
	I2C_CR1_DNF_Filter13 = 0xd
	// Digital filter enabled and filtering capability up to 14 tI2CCLK
	I2C_CR1_DNF_Filter14 = 0xe
	// Digital filter enabled and filtering capability up to 15 tI2CCLK
	I2C_CR1_DNF_Filter15 = 0xf
	// Position of ANFOFF field.
	I2C_CR1_ANFOFF_Pos = 0xc
	// Bit mask of ANFOFF field.
	I2C_CR1_ANFOFF_Msk = 0x1000
	// Bit ANFOFF.
	I2C_CR1_ANFOFF = 0x1000
	// Analog noise filter enabled
	I2C_CR1_ANFOFF_Enabled = 0x0
	// Analog noise filter disabled
	I2C_CR1_ANFOFF_Disabled = 0x1
	// Position of SWRST field.
	I2C_CR1_SWRST_Pos = 0xd
	// Bit mask of SWRST field.
	I2C_CR1_SWRST_Msk = 0x2000
	// Bit SWRST.
	I2C_CR1_SWRST = 0x2000
	// Position of TXDMAEN field.
	I2C_CR1_TXDMAEN_Pos = 0xe
	// Bit mask of TXDMAEN field.
	I2C_CR1_TXDMAEN_Msk = 0x4000
	// Bit TXDMAEN.
	I2C_CR1_TXDMAEN = 0x4000
	// DMA mode disabled for transmission
	I2C_CR1_TXDMAEN_Disabled = 0x0
	// DMA mode enabled for transmission
	I2C_CR1_TXDMAEN_Enabled = 0x1
	// Position of RXDMAEN field.
	I2C_CR1_RXDMAEN_Pos = 0xf
	// Bit mask of RXDMAEN field.
	I2C_CR1_RXDMAEN_Msk = 0x8000
	// Bit RXDMAEN.
	I2C_CR1_RXDMAEN = 0x8000
	// DMA mode disabled for reception
	I2C_CR1_RXDMAEN_Disabled = 0x0
	// DMA mode enabled for reception
	I2C_CR1_RXDMAEN_Enabled = 0x1
	// Position of SBC field.
	I2C_CR1_SBC_Pos = 0x10
	// Bit mask of SBC field.
	I2C_CR1_SBC_Msk = 0x10000
	// Bit SBC.
	I2C_CR1_SBC = 0x10000
	// Slave byte control disabled
	I2C_CR1_SBC_Disabled = 0x0
	// Slave byte control enabled
	I2C_CR1_SBC_Enabled = 0x1
	// Position of NOSTRETCH field.
	I2C_CR1_NOSTRETCH_Pos = 0x11
	// Bit mask of NOSTRETCH field.
	I2C_CR1_NOSTRETCH_Msk = 0x20000
	// Bit NOSTRETCH.
	I2C_CR1_NOSTRETCH = 0x20000
	// Clock stretching enabled
	I2C_CR1_NOSTRETCH_Enabled = 0x0
	// Clock stretching disabled
	I2C_CR1_NOSTRETCH_Disabled = 0x1
	// Position of WUPEN field.
	I2C_CR1_WUPEN_Pos = 0x12
	// Bit mask of WUPEN field.
	I2C_CR1_WUPEN_Msk = 0x40000
	// Bit WUPEN.
	I2C_CR1_WUPEN = 0x40000
	// Wakeup from Stop mode disabled
	I2C_CR1_WUPEN_Disabled = 0x0
	// Wakeup from Stop mode enabled
	I2C_CR1_WUPEN_Enabled = 0x1
	// Position of GCEN field.
	I2C_CR1_GCEN_Pos = 0x13
	// Bit mask of GCEN field.
	I2C_CR1_GCEN_Msk = 0x80000
	// Bit GCEN.
	I2C_CR1_GCEN = 0x80000
	// General call disabled. Address 0b00000000 is NACKed
	I2C_CR1_GCEN_Disabled = 0x0
	// General call enabled. Address 0b00000000 is ACKed
	I2C_CR1_GCEN_Enabled = 0x1
	// Position of SMBHEN field.
	I2C_CR1_SMBHEN_Pos = 0x14
	// Bit mask of SMBHEN field.
	I2C_CR1_SMBHEN_Msk = 0x100000
	// Bit SMBHEN.
	I2C_CR1_SMBHEN = 0x100000
	// Host address disabled. Address 0b0001000x is NACKed
	I2C_CR1_SMBHEN_Disabled = 0x0
	// Host address enabled. Address 0b0001000x is ACKed
	I2C_CR1_SMBHEN_Enabled = 0x1
	// Position of SMBDEN field.
	I2C_CR1_SMBDEN_Pos = 0x15
	// Bit mask of SMBDEN field.
	I2C_CR1_SMBDEN_Msk = 0x200000
	// Bit SMBDEN.
	I2C_CR1_SMBDEN = 0x200000
	// Device default address disabled. Address 0b1100001x is NACKed
	I2C_CR1_SMBDEN_Disabled = 0x0
	// Device default address enabled. Address 0b1100001x is ACKed
	I2C_CR1_SMBDEN_Enabled = 0x1
	// Position of ALERTEN field.
	I2C_CR1_ALERTEN_Pos = 0x16
	// Bit mask of ALERTEN field.
	I2C_CR1_ALERTEN_Msk = 0x400000
	// Bit ALERTEN.
	I2C_CR1_ALERTEN = 0x400000
	// In device mode (SMBHEN=Disabled) Releases SMBA pin high and Alert Response Address Header disabled (0001100x) followed by NACK. In host mode (SMBHEN=Enabled) SMBus Alert pin (SMBA) not supported
	I2C_CR1_ALERTEN_Disabled = 0x0
	// In device mode (SMBHEN=Disabled) Drives SMBA pin low and Alert Response Address Header enabled (0001100x) followed by ACK.In host mode (SMBHEN=Enabled) SMBus Alert pin (SMBA) supported
	I2C_CR1_ALERTEN_Enabled = 0x1
	// Position of PECEN field.
	I2C_CR1_PECEN_Pos = 0x17
	// Bit mask of PECEN field.
	I2C_CR1_PECEN_Msk = 0x800000
	// Bit PECEN.
	I2C_CR1_PECEN = 0x800000
	// PEC calculation disabled
	I2C_CR1_PECEN_Disabled = 0x0
	// PEC calculation enabled
	I2C_CR1_PECEN_Enabled = 0x1

	// CR2: Control register 2
	// Position of PECBYTE field.
	I2C_CR2_PECBYTE_Pos = 0x1a
	// Bit mask of PECBYTE field.
	I2C_CR2_PECBYTE_Msk = 0x4000000
	// Bit PECBYTE.
	I2C_CR2_PECBYTE = 0x4000000
	// No PEC transfer
	I2C_CR2_PECBYTE_NoPec = 0x0
	// PEC transmission/reception is requested
	I2C_CR2_PECBYTE_Pec = 0x1
	// Position of AUTOEND field.
	I2C_CR2_AUTOEND_Pos = 0x19
	// Bit mask of AUTOEND field.
	I2C_CR2_AUTOEND_Msk = 0x2000000
	// Bit AUTOEND.
	I2C_CR2_AUTOEND = 0x2000000
	// Software end mode: TC flag is set when NBYTES data are transferred, stretching SCL low
	I2C_CR2_AUTOEND_Software = 0x0
	// Automatic end mode: a STOP condition is automatically sent when NBYTES data are transferred
	I2C_CR2_AUTOEND_Automatic = 0x1
	// Position of RELOAD field.
	I2C_CR2_RELOAD_Pos = 0x18
	// Bit mask of RELOAD field.
	I2C_CR2_RELOAD_Msk = 0x1000000
	// Bit RELOAD.
	I2C_CR2_RELOAD = 0x1000000
	// The transfer is completed after the NBYTES data transfer (STOP or RESTART will follow)
	I2C_CR2_RELOAD_Completed = 0x0
	// The transfer is not completed after the NBYTES data transfer (NBYTES will be reloaded)
	I2C_CR2_RELOAD_NotCompleted = 0x1
	// Position of NBYTES field.
	I2C_CR2_NBYTES_Pos = 0x10
	// Bit mask of NBYTES field.
	I2C_CR2_NBYTES_Msk = 0xff0000
	// Position of NACK field.
	I2C_CR2_NACK_Pos = 0xf
	// Bit mask of NACK field.
	I2C_CR2_NACK_Msk = 0x8000
	// Bit NACK.
	I2C_CR2_NACK = 0x8000
	// an ACK is sent after current received byte
	I2C_CR2_NACK_Ack = 0x0
	// a NACK is sent after current received byte
	I2C_CR2_NACK_Nack = 0x1
	// Position of STOP field.
	I2C_CR2_STOP_Pos = 0xe
	// Bit mask of STOP field.
	I2C_CR2_STOP_Msk = 0x4000
	// Bit STOP.
	I2C_CR2_STOP = 0x4000
	// No Stop generation
	I2C_CR2_STOP_NoStop = 0x0
	// Stop generation after current byte transfer
	I2C_CR2_STOP_Stop = 0x1
	// Position of START field.
	I2C_CR2_START_Pos = 0xd
	// Bit mask of START field.
	I2C_CR2_START_Msk = 0x2000
	// Bit START.
	I2C_CR2_START = 0x2000
	// No Start generation
	I2C_CR2_START_NoStart = 0x0
	// Restart/Start generation
	I2C_CR2_START_Start = 0x1
	// Position of HEAD10R field.
	I2C_CR2_HEAD10R_Pos = 0xc
	// Bit mask of HEAD10R field.
	I2C_CR2_HEAD10R_Msk = 0x1000
	// Bit HEAD10R.
	I2C_CR2_HEAD10R = 0x1000
	// The master sends the complete 10 bit slave address read sequence
	I2C_CR2_HEAD10R_Complete = 0x0
	// The master only sends the 1st 7 bits of the 10 bit address, followed by Read direction
	I2C_CR2_HEAD10R_Partial = 0x1
	// Position of ADD10 field.
	I2C_CR2_ADD10_Pos = 0xb
	// Bit mask of ADD10 field.
	I2C_CR2_ADD10_Msk = 0x800
	// Bit ADD10.
	I2C_CR2_ADD10 = 0x800
	// The master operates in 7-bit addressing mode
	I2C_CR2_ADD10_Bit7 = 0x0
	// The master operates in 10-bit addressing mode
	I2C_CR2_ADD10_Bit10 = 0x1
	// Position of RD_WRN field.
	I2C_CR2_RD_WRN_Pos = 0xa
	// Bit mask of RD_WRN field.
	I2C_CR2_RD_WRN_Msk = 0x400
	// Bit RD_WRN.
	I2C_CR2_RD_WRN = 0x400
	// Master requests a write transfer
	I2C_CR2_RD_WRN_Write = 0x0
	// Master requests a read transfer
	I2C_CR2_RD_WRN_Read = 0x1
	// Position of SADD field.
	I2C_CR2_SADD_Pos = 0x0
	// Bit mask of SADD field.
	I2C_CR2_SADD_Msk = 0x3ff

	// OAR1: Own address register 1
	// Position of OA1MODE field.
	I2C_OAR1_OA1MODE_Pos = 0xa
	// Bit mask of OA1MODE field.
	I2C_OAR1_OA1MODE_Msk = 0x400
	// Bit OA1MODE.
	I2C_OAR1_OA1MODE = 0x400
	// Own address 1 is a 7-bit address
	I2C_OAR1_OA1MODE_Bit7 = 0x0
	// Own address 1 is a 10-bit address
	I2C_OAR1_OA1MODE_Bit10 = 0x1
	// Position of OA1EN field.
	I2C_OAR1_OA1EN_Pos = 0xf
	// Bit mask of OA1EN field.
	I2C_OAR1_OA1EN_Msk = 0x8000
	// Bit OA1EN.
	I2C_OAR1_OA1EN = 0x8000
	// Own address 1 disabled. The received slave address OA1 is NACKed
	I2C_OAR1_OA1EN_Disabled = 0x0
	// Own address 1 enabled. The received slave address OA1 is ACKed
	I2C_OAR1_OA1EN_Enabled = 0x1
	// Position of OA1 field.
	I2C_OAR1_OA1_Pos = 0x0
	// Bit mask of OA1 field.
	I2C_OAR1_OA1_Msk = 0x3ff

	// OAR2: Own address register 2
	// Position of OA2 field.
	I2C_OAR2_OA2_Pos = 0x1
	// Bit mask of OA2 field.
	I2C_OAR2_OA2_Msk = 0xfe
	// Position of OA2MSK field.
	I2C_OAR2_OA2MSK_Pos = 0x8
	// Bit mask of OA2MSK field.
	I2C_OAR2_OA2MSK_Msk = 0x700
	// No mask
	I2C_OAR2_OA2MSK_NoMask = 0x0
	// OA2[1] is masked and don’t care. Only OA2[7:2] are compared
	I2C_OAR2_OA2MSK_Mask1 = 0x1
	// OA2[2:1] are masked and don’t care. Only OA2[7:3] are compared
	I2C_OAR2_OA2MSK_Mask2 = 0x2
	// OA2[3:1] are masked and don’t care. Only OA2[7:4] are compared
	I2C_OAR2_OA2MSK_Mask3 = 0x3
	// OA2[4:1] are masked and don’t care. Only OA2[7:5] are compared
	I2C_OAR2_OA2MSK_Mask4 = 0x4
	// OA2[5:1] are masked and don’t care. Only OA2[7:6] are compared
	I2C_OAR2_OA2MSK_Mask5 = 0x5
	// OA2[6:1] are masked and don’t care. Only OA2[7] is compared.
	I2C_OAR2_OA2MSK_Mask6 = 0x6
	// OA2[7:1] are masked and don’t care. No comparison is done, and all (except reserved) 7-bit received addresses are acknowledged
	I2C_OAR2_OA2MSK_Mask7 = 0x7
	// Position of OA2EN field.
	I2C_OAR2_OA2EN_Pos = 0xf
	// Bit mask of OA2EN field.
	I2C_OAR2_OA2EN_Msk = 0x8000
	// Bit OA2EN.
	I2C_OAR2_OA2EN = 0x8000
	// Own address 2 disabled. The received slave address OA2 is NACKed
	I2C_OAR2_OA2EN_Disabled = 0x0
	// Own address 2 enabled. The received slave address OA2 is ACKed
	I2C_OAR2_OA2EN_Enabled = 0x1

	// TIMINGR: Timing register
	// Position of SCLL field.
	I2C_TIMINGR_SCLL_Pos = 0x0
	// Bit mask of SCLL field.
	I2C_TIMINGR_SCLL_Msk = 0xff
	// Position of SCLH field.
	I2C_TIMINGR_SCLH_Pos = 0x8
	// Bit mask of SCLH field.
	I2C_TIMINGR_SCLH_Msk = 0xff00
	// Position of SDADEL field.
	I2C_TIMINGR_SDADEL_Pos = 0x10
	// Bit mask of SDADEL field.
	I2C_TIMINGR_SDADEL_Msk = 0xf0000
	// Position of SCLDEL field.
	I2C_TIMINGR_SCLDEL_Pos = 0x14
	// Bit mask of SCLDEL field.
	I2C_TIMINGR_SCLDEL_Msk = 0xf00000
	// Position of PRESC field.
	I2C_TIMINGR_PRESC_Pos = 0x1c
	// Bit mask of PRESC field.
	I2C_TIMINGR_PRESC_Msk = 0xf0000000

	// TIMEOUTR: Status register 1
	// Position of TIMEOUTA field.
	I2C_TIMEOUTR_TIMEOUTA_Pos = 0x0
	// Bit mask of TIMEOUTA field.
	I2C_TIMEOUTR_TIMEOUTA_Msk = 0xfff
	// Position of TIDLE field.
	I2C_TIMEOUTR_TIDLE_Pos = 0xc
	// Bit mask of TIDLE field.
	I2C_TIMEOUTR_TIDLE_Msk = 0x1000
	// Bit TIDLE.
	I2C_TIMEOUTR_TIDLE = 0x1000
	// TIMEOUTA is used to detect SCL low timeout
	I2C_TIMEOUTR_TIDLE_Disabled = 0x0
	// TIMEOUTA is used to detect both SCL and SDA high timeout (bus idle condition)
	I2C_TIMEOUTR_TIDLE_Enabled = 0x1
	// Position of TIMOUTEN field.
	I2C_TIMEOUTR_TIMOUTEN_Pos = 0xf
	// Bit mask of TIMOUTEN field.
	I2C_TIMEOUTR_TIMOUTEN_Msk = 0x8000
	// Bit TIMOUTEN.
	I2C_TIMEOUTR_TIMOUTEN = 0x8000
	// SCL timeout detection is disabled
	I2C_TIMEOUTR_TIMOUTEN_Disabled = 0x0
	// SCL timeout detection is enabled
	I2C_TIMEOUTR_TIMOUTEN_Enabled = 0x1
	// Position of TIMEOUTB field.
	I2C_TIMEOUTR_TIMEOUTB_Pos = 0x10
	// Bit mask of TIMEOUTB field.
	I2C_TIMEOUTR_TIMEOUTB_Msk = 0xfff0000
	// Position of TEXTEN field.
	I2C_TIMEOUTR_TEXTEN_Pos = 0x1f
	// Bit mask of TEXTEN field.
	I2C_TIMEOUTR_TEXTEN_Msk = 0x80000000
	// Bit TEXTEN.
	I2C_TIMEOUTR_TEXTEN = 0x80000000
	// Extended clock timeout detection is disabled
	I2C_TIMEOUTR_TEXTEN_Disabled = 0x0
	// Extended clock timeout detection is enabled
	I2C_TIMEOUTR_TEXTEN_Enabled = 0x1

	// ISR: Interrupt and Status register
	// Position of ADDCODE field.
	I2C_ISR_ADDCODE_Pos = 0x11
	// Bit mask of ADDCODE field.
	I2C_ISR_ADDCODE_Msk = 0xfe0000
	// Position of DIR field.
	I2C_ISR_DIR_Pos = 0x10
	// Bit mask of DIR field.
	I2C_ISR_DIR_Msk = 0x10000
	// Bit DIR.
	I2C_ISR_DIR = 0x10000
	// Write transfer, slave enters receiver mode
	I2C_ISR_DIR_Write = 0x0
	// Read transfer, slave enters transmitter mode
	I2C_ISR_DIR_Read = 0x1
	// Position of BUSY field.
	I2C_ISR_BUSY_Pos = 0xf
	// Bit mask of BUSY field.
	I2C_ISR_BUSY_Msk = 0x8000
	// Bit BUSY.
	I2C_ISR_BUSY = 0x8000
	// No communication is in progress on the bus
	I2C_ISR_BUSY_NotBusy = 0x0
	// A communication is in progress on the bus
	I2C_ISR_BUSY_Busy = 0x1
	// Position of ALERT field.
	I2C_ISR_ALERT_Pos = 0xd
	// Bit mask of ALERT field.
	I2C_ISR_ALERT_Msk = 0x2000
	// Bit ALERT.
	I2C_ISR_ALERT = 0x2000
	// SMBA alert is not detected
	I2C_ISR_ALERT_NoAlert = 0x0
	// SMBA alert event is detected on SMBA pin
	I2C_ISR_ALERT_Alert = 0x1
	// Position of TIMEOUT field.
	I2C_ISR_TIMEOUT_Pos = 0xc
	// Bit mask of TIMEOUT field.
	I2C_ISR_TIMEOUT_Msk = 0x1000
	// Bit TIMEOUT.
	I2C_ISR_TIMEOUT = 0x1000
	// No timeout occured
	I2C_ISR_TIMEOUT_NoTimeout = 0x0
	// Timeout occured
	I2C_ISR_TIMEOUT_Timeout = 0x1
	// Position of PECERR field.
	I2C_ISR_PECERR_Pos = 0xb
	// Bit mask of PECERR field.
	I2C_ISR_PECERR_Msk = 0x800
	// Bit PECERR.
	I2C_ISR_PECERR = 0x800
	// Received PEC does match with PEC register
	I2C_ISR_PECERR_Match = 0x0
	// Received PEC does not match with PEC register
	I2C_ISR_PECERR_NoMatch = 0x1
	// Position of OVR field.
	I2C_ISR_OVR_Pos = 0xa
	// Bit mask of OVR field.
	I2C_ISR_OVR_Msk = 0x400
	// Bit OVR.
	I2C_ISR_OVR = 0x400
	// No overrun/underrun error occurs
	I2C_ISR_OVR_NoOverrun = 0x0
	// slave mode with NOSTRETCH=1, when an overrun/underrun error occurs
	I2C_ISR_OVR_Overrun = 0x1
	// Position of ARLO field.
	I2C_ISR_ARLO_Pos = 0x9
	// Bit mask of ARLO field.
	I2C_ISR_ARLO_Msk = 0x200
	// Bit ARLO.
	I2C_ISR_ARLO = 0x200
	// No arbitration lost
	I2C_ISR_ARLO_NotLost = 0x0
	// Arbitration lost
	I2C_ISR_ARLO_Lost = 0x1
	// Position of BERR field.
	I2C_ISR_BERR_Pos = 0x8
	// Bit mask of BERR field.
	I2C_ISR_BERR_Msk = 0x100
	// Bit BERR.
	I2C_ISR_BERR = 0x100
	// No bus error
	I2C_ISR_BERR_NoError = 0x0
	// Misplaced Start and Stop condition is detected
	I2C_ISR_BERR_Error = 0x1
	// Position of TCR field.
	I2C_ISR_TCR_Pos = 0x7
	// Bit mask of TCR field.
	I2C_ISR_TCR_Msk = 0x80
	// Bit TCR.
	I2C_ISR_TCR = 0x80
	// Transfer is not complete
	I2C_ISR_TCR_NotComplete = 0x0
	// NBYTES has been transfered
	I2C_ISR_TCR_Complete = 0x1
	// Position of TC field.
	I2C_ISR_TC_Pos = 0x6
	// Bit mask of TC field.
	I2C_ISR_TC_Msk = 0x40
	// Bit TC.
	I2C_ISR_TC = 0x40
	// Transfer is not complete
	I2C_ISR_TC_NotComplete = 0x0
	// NBYTES has been transfered
	I2C_ISR_TC_Complete = 0x1
	// Position of STOPF field.
	I2C_ISR_STOPF_Pos = 0x5
	// Bit mask of STOPF field.
	I2C_ISR_STOPF_Msk = 0x20
	// Bit STOPF.
	I2C_ISR_STOPF = 0x20
	// No Stop condition detected
	I2C_ISR_STOPF_NoStop = 0x0
	// Stop condition detected
	I2C_ISR_STOPF_Stop = 0x1
	// Position of NACKF field.
	I2C_ISR_NACKF_Pos = 0x4
	// Bit mask of NACKF field.
	I2C_ISR_NACKF_Msk = 0x10
	// Bit NACKF.
	I2C_ISR_NACKF = 0x10
	// No NACK has been received
	I2C_ISR_NACKF_NoNack = 0x0
	// NACK has been received
	I2C_ISR_NACKF_Nack = 0x1
	// Position of ADDR field.
	I2C_ISR_ADDR_Pos = 0x3
	// Bit mask of ADDR field.
	I2C_ISR_ADDR_Msk = 0x8
	// Bit ADDR.
	I2C_ISR_ADDR = 0x8
	// Adress mismatched or not received
	I2C_ISR_ADDR_NotMatch = 0x0
	// Received slave address matched with one of the enabled slave addresses
	I2C_ISR_ADDR_Match = 0x1
	// Position of RXNE field.
	I2C_ISR_RXNE_Pos = 0x2
	// Bit mask of RXNE field.
	I2C_ISR_RXNE_Msk = 0x4
	// Bit RXNE.
	I2C_ISR_RXNE = 0x4
	// The RXDR register is empty
	I2C_ISR_RXNE_Empty = 0x0
	// Received data is copied into the RXDR register, and is ready to be read
	I2C_ISR_RXNE_NotEmpty = 0x1
	// Position of TXIS field.
	I2C_ISR_TXIS_Pos = 0x1
	// Bit mask of TXIS field.
	I2C_ISR_TXIS_Msk = 0x2
	// Bit TXIS.
	I2C_ISR_TXIS = 0x2
	// The TXDR register is not empty
	I2C_ISR_TXIS_NotEmpty = 0x0
	// The TXDR register is empty and the data to be transmitted must be written in the TXDR register
	I2C_ISR_TXIS_Empty = 0x1
	// Position of TXE field.
	I2C_ISR_TXE_Pos = 0x0
	// Bit mask of TXE field.
	I2C_ISR_TXE_Msk = 0x1
	// Bit TXE.
	I2C_ISR_TXE = 0x1
	// TXDR register not empty
	I2C_ISR_TXE_NotEmpty = 0x0
	// TXDR register empty
	I2C_ISR_TXE_Empty = 0x1

	// ICR: Interrupt clear register
	// Position of ALERTCF field.
	I2C_ICR_ALERTCF_Pos = 0xd
	// Bit mask of ALERTCF field.
	I2C_ICR_ALERTCF_Msk = 0x2000
	// Bit ALERTCF.
	I2C_ICR_ALERTCF = 0x2000
	// Clears the ALERT flag in ISR register
	I2C_ICR_ALERTCF_Clear = 0x1
	// Position of TIMOUTCF field.
	I2C_ICR_TIMOUTCF_Pos = 0xc
	// Bit mask of TIMOUTCF field.
	I2C_ICR_TIMOUTCF_Msk = 0x1000
	// Bit TIMOUTCF.
	I2C_ICR_TIMOUTCF = 0x1000
	// Clears the TIMOUT flag in ISR register
	I2C_ICR_TIMOUTCF_Clear = 0x1
	// Position of PECCF field.
	I2C_ICR_PECCF_Pos = 0xb
	// Bit mask of PECCF field.
	I2C_ICR_PECCF_Msk = 0x800
	// Bit PECCF.
	I2C_ICR_PECCF = 0x800
	// Clears the PEC flag in ISR register
	I2C_ICR_PECCF_Clear = 0x1
	// Position of OVRCF field.
	I2C_ICR_OVRCF_Pos = 0xa
	// Bit mask of OVRCF field.
	I2C_ICR_OVRCF_Msk = 0x400
	// Bit OVRCF.
	I2C_ICR_OVRCF = 0x400
	// Clears the OVR flag in ISR register
	I2C_ICR_OVRCF_Clear = 0x1
	// Position of ARLOCF field.
	I2C_ICR_ARLOCF_Pos = 0x9
	// Bit mask of ARLOCF field.
	I2C_ICR_ARLOCF_Msk = 0x200
	// Bit ARLOCF.
	I2C_ICR_ARLOCF = 0x200
	// Clears the ARLO flag in ISR register
	I2C_ICR_ARLOCF_Clear = 0x1
	// Position of BERRCF field.
	I2C_ICR_BERRCF_Pos = 0x8
	// Bit mask of BERRCF field.
	I2C_ICR_BERRCF_Msk = 0x100
	// Bit BERRCF.
	I2C_ICR_BERRCF = 0x100
	// Clears the BERR flag in ISR register
	I2C_ICR_BERRCF_Clear = 0x1
	// Position of STOPCF field.
	I2C_ICR_STOPCF_Pos = 0x5
	// Bit mask of STOPCF field.
	I2C_ICR_STOPCF_Msk = 0x20
	// Bit STOPCF.
	I2C_ICR_STOPCF = 0x20
	// Clears the STOP flag in ISR register
	I2C_ICR_STOPCF_Clear = 0x1
	// Position of NACKCF field.
	I2C_ICR_NACKCF_Pos = 0x4
	// Bit mask of NACKCF field.
	I2C_ICR_NACKCF_Msk = 0x10
	// Bit NACKCF.
	I2C_ICR_NACKCF = 0x10
	// Clears the NACK flag in ISR register
	I2C_ICR_NACKCF_Clear = 0x1
	// Position of ADDRCF field.
	I2C_ICR_ADDRCF_Pos = 0x3
	// Bit mask of ADDRCF field.
	I2C_ICR_ADDRCF_Msk = 0x8
	// Bit ADDRCF.
	I2C_ICR_ADDRCF = 0x8
	// Clears the ADDR flag in ISR register
	I2C_ICR_ADDRCF_Clear = 0x1

	// PECR: PEC register
	// Position of PEC field.
	I2C_PECR_PEC_Pos = 0x0
	// Bit mask of PEC field.
	I2C_PECR_PEC_Msk = 0xff

	// RXDR: Receive data register
	// Position of RXDATA field.
	I2C_RXDR_RXDATA_Pos = 0x0
	// Bit mask of RXDATA field.
	I2C_RXDR_RXDATA_Msk = 0xff

	// TXDR: Transmit data register
	// Position of TXDATA field.
	I2C_TXDR_TXDATA_Pos = 0x0
	// Bit mask of TXDATA field.
	I2C_TXDR_TXDATA_Msk = 0xff
)

// Bitfields for IWDG: Independent watchdog
const (
	// KR: Key register
	// Position of KEY field.
	IWDG_KR_KEY_Pos = 0x0
	// Bit mask of KEY field.
	IWDG_KR_KEY_Msk = 0xffff
	// Enable access to PR, RLR and WINR registers (0x5555)
	IWDG_KR_KEY_Enable = 0x5555
	// Reset the watchdog value (0xAAAA)
	IWDG_KR_KEY_Reset = 0xaaaa
	// Start the watchdog (0xCCCC)
	IWDG_KR_KEY_Start = 0xcccc

	// PR: Prescaler register
	// Position of PR field.
	IWDG_PR_PR_Pos = 0x0
	// Bit mask of PR field.
	IWDG_PR_PR_Msk = 0x7
	// Divider /4
	IWDG_PR_PR_DivideBy4 = 0x0
	// Divider /8
	IWDG_PR_PR_DivideBy8 = 0x1
	// Divider /16
	IWDG_PR_PR_DivideBy16 = 0x2
	// Divider /32
	IWDG_PR_PR_DivideBy32 = 0x3
	// Divider /64
	IWDG_PR_PR_DivideBy64 = 0x4
	// Divider /128
	IWDG_PR_PR_DivideBy128 = 0x5
	// Divider /256
	IWDG_PR_PR_DivideBy256 = 0x6
	// Divider /256
	IWDG_PR_PR_DivideBy256bis = 0x7

	// RLR: Reload register
	// Position of RL field.
	IWDG_RLR_RL_Pos = 0x0
	// Bit mask of RL field.
	IWDG_RLR_RL_Msk = 0xfff

	// SR: Status register
	// Position of PVU field.
	IWDG_SR_PVU_Pos = 0x0
	// Bit mask of PVU field.
	IWDG_SR_PVU_Msk = 0x1
	// Bit PVU.
	IWDG_SR_PVU = 0x1
	// Position of RVU field.
	IWDG_SR_RVU_Pos = 0x1
	// Bit mask of RVU field.
	IWDG_SR_RVU_Msk = 0x2
	// Bit RVU.
	IWDG_SR_RVU = 0x2
	// Position of WVU field.
	IWDG_SR_WVU_Pos = 0x2
	// Bit mask of WVU field.
	IWDG_SR_WVU_Msk = 0x4
	// Bit WVU.
	IWDG_SR_WVU = 0x4

	// WINR: Window register
	// Position of WIN field.
	IWDG_WINR_WIN_Pos = 0x0
	// Bit mask of WIN field.
	IWDG_WINR_WIN_Msk = 0xfff
)

// Bitfields for WWDG: Window watchdog
const (
	// CR: Control register
	// Position of T field.
	WWDG_CR_T_Pos = 0x0
	// Bit mask of T field.
	WWDG_CR_T_Msk = 0x7f
	// Position of WDGA field.
	WWDG_CR_WDGA_Pos = 0x7
	// Bit mask of WDGA field.
	WWDG_CR_WDGA_Msk = 0x80
	// Bit WDGA.
	WWDG_CR_WDGA = 0x80
	// Watchdog disabled
	WWDG_CR_WDGA_Disabled = 0x0
	// Watchdog enabled
	WWDG_CR_WDGA_Enabled = 0x1

	// CFR: Configuration register
	// Position of EWI field.
	WWDG_CFR_EWI_Pos = 0x9
	// Bit mask of EWI field.
	WWDG_CFR_EWI_Msk = 0x200
	// Bit EWI.
	WWDG_CFR_EWI = 0x200
	// interrupt occurs whenever the counter reaches the value 0x40
	WWDG_CFR_EWI_Enable = 0x1
	// Position of W field.
	WWDG_CFR_W_Pos = 0x0
	// Bit mask of W field.
	WWDG_CFR_W_Msk = 0x7f
	// Position of WDGTB field.
	WWDG_CFR_WDGTB_Pos = 0x7
	// Bit mask of WDGTB field.
	WWDG_CFR_WDGTB_Msk = 0x180
	// Counter clock (PCLK1 div 4096) div 1
	WWDG_CFR_WDGTB_Div1 = 0x0
	// Counter clock (PCLK1 div 4096) div 2
	WWDG_CFR_WDGTB_Div2 = 0x1
	// Counter clock (PCLK1 div 4096) div 4
	WWDG_CFR_WDGTB_Div4 = 0x2
	// Counter clock (PCLK1 div 4096) div 8
	WWDG_CFR_WDGTB_Div8 = 0x3

	// SR: Status register
	// Position of EWIF field.
	WWDG_SR_EWIF_Pos = 0x0
	// Bit mask of EWIF field.
	WWDG_SR_EWIF_Msk = 0x1
	// Bit EWIF.
	WWDG_SR_EWIF = 0x1
	// The EWI Interrupt Service Routine has been triggered
	WWDG_SR_EWIF_Pending = 0x1
	// The EWI Interrupt Service Routine has been serviced
	WWDG_SR_EWIF_Finished = 0x0
)

// Bitfields for RTC: Real-time clock
const (
	// TR: time register
	// Position of PM field.
	RTC_TR_PM_Pos = 0x16
	// Bit mask of PM field.
	RTC_TR_PM_Msk = 0x400000
	// Bit PM.
	RTC_TR_PM = 0x400000
	// AM or 24-hour format
	RTC_TR_PM_AM = 0x0
	// PM
	RTC_TR_PM_PM = 0x1
	// Position of HT field.
	RTC_TR_HT_Pos = 0x14
	// Bit mask of HT field.
	RTC_TR_HT_Msk = 0x300000
	// Position of HU field.
	RTC_TR_HU_Pos = 0x10
	// Bit mask of HU field.
	RTC_TR_HU_Msk = 0xf0000
	// Position of MNT field.
	RTC_TR_MNT_Pos = 0xc
	// Bit mask of MNT field.
	RTC_TR_MNT_Msk = 0x7000
	// Position of MNU field.
	RTC_TR_MNU_Pos = 0x8
	// Bit mask of MNU field.
	RTC_TR_MNU_Msk = 0xf00
	// Position of ST field.
	RTC_TR_ST_Pos = 0x4
	// Bit mask of ST field.
	RTC_TR_ST_Msk = 0x70
	// Position of SU field.
	RTC_TR_SU_Pos = 0x0
	// Bit mask of SU field.
	RTC_TR_SU_Msk = 0xf

	// DR: date register
	// Position of YT field.
	RTC_DR_YT_Pos = 0x14
	// Bit mask of YT field.
	RTC_DR_YT_Msk = 0xf00000
	// Position of YU field.
	RTC_DR_YU_Pos = 0x10
	// Bit mask of YU field.
	RTC_DR_YU_Msk = 0xf0000
	// Position of WDU field.
	RTC_DR_WDU_Pos = 0xd
	// Bit mask of WDU field.
	RTC_DR_WDU_Msk = 0xe000
	// Position of MT field.
	RTC_DR_MT_Pos = 0xc
	// Bit mask of MT field.
	RTC_DR_MT_Msk = 0x1000
	// Bit MT.
	RTC_DR_MT = 0x1000
	// Position of MU field.
	RTC_DR_MU_Pos = 0x8
	// Bit mask of MU field.
	RTC_DR_MU_Msk = 0xf00
	// Position of DT field.
	RTC_DR_DT_Pos = 0x4
	// Bit mask of DT field.
	RTC_DR_DT_Msk = 0x30
	// Position of DU field.
	RTC_DR_DU_Pos = 0x0
	// Bit mask of DU field.
	RTC_DR_DU_Msk = 0xf

	// CR: control register
	// Position of WUCKSEL field.
	RTC_CR_WUCKSEL_Pos = 0x0
	// Bit mask of WUCKSEL field.
	RTC_CR_WUCKSEL_Msk = 0x7
	// RTC/16 clock is selected
	RTC_CR_WUCKSEL_Div16 = 0x0
	// RTC/8 clock is selected
	RTC_CR_WUCKSEL_Div8 = 0x1
	// RTC/4 clock is selected
	RTC_CR_WUCKSEL_Div4 = 0x2
	// RTC/2 clock is selected
	RTC_CR_WUCKSEL_Div2 = 0x3
	// ck_spre (usually 1 Hz) clock is selected
	RTC_CR_WUCKSEL_ClockSpare = 0x4
	// ck_spre (usually 1 Hz) clock is selected and 2^16 is added to the WUT counter value
	RTC_CR_WUCKSEL_ClockSpareWithOffset = 0x6
	// Position of TSEDGE field.
	RTC_CR_TSEDGE_Pos = 0x3
	// Bit mask of TSEDGE field.
	RTC_CR_TSEDGE_Msk = 0x8
	// Bit TSEDGE.
	RTC_CR_TSEDGE = 0x8
	// RTC_TS input rising edge generates a time-stamp event
	RTC_CR_TSEDGE_RisingEdge = 0x0
	// RTC_TS input falling edge generates a time-stamp event
	RTC_CR_TSEDGE_FallingEdge = 0x1
	// Position of REFCKON field.
	RTC_CR_REFCKON_Pos = 0x4
	// Bit mask of REFCKON field.
	RTC_CR_REFCKON_Msk = 0x10
	// Bit REFCKON.
	RTC_CR_REFCKON = 0x10
	// RTC_REFIN detection disabled
	RTC_CR_REFCKON_Disabled = 0x0
	// RTC_REFIN detection enabled
	RTC_CR_REFCKON_Enabled = 0x1
	// Position of BYPSHAD field.
	RTC_CR_BYPSHAD_Pos = 0x5
	// Bit mask of BYPSHAD field.
	RTC_CR_BYPSHAD_Msk = 0x20
	// Bit BYPSHAD.
	RTC_CR_BYPSHAD = 0x20
	// Calendar values (when reading from RTC_SSR, RTC_TR, and RTC_DR) are taken from the shadow registers, which are updated once every two RTCCLK cycles
	RTC_CR_BYPSHAD_ShadowReg = 0x0
	// Calendar values (when reading from RTC_SSR, RTC_TR, and RTC_DR) are taken directly from the calendar counters
	RTC_CR_BYPSHAD_BypassShadowReg = 0x1
	// Position of FMT field.
	RTC_CR_FMT_Pos = 0x6
	// Bit mask of FMT field.
	RTC_CR_FMT_Msk = 0x40
	// Bit FMT.
	RTC_CR_FMT = 0x40
	// 24 hour/day format
	RTC_CR_FMT_Twenty_Four_Hour = 0x0
	// AM/PM hour format
	RTC_CR_FMT_AM_PM = 0x1
	// Position of ALRAE field.
	RTC_CR_ALRAE_Pos = 0x8
	// Bit mask of ALRAE field.
	RTC_CR_ALRAE_Msk = 0x100
	// Bit ALRAE.
	RTC_CR_ALRAE = 0x100
	// Alarm A disabled
	RTC_CR_ALRAE_Disabled = 0x0
	// Alarm A enabled
	RTC_CR_ALRAE_Enabled = 0x1
	// Position of ALRBE field.
	RTC_CR_ALRBE_Pos = 0x9
	// Bit mask of ALRBE field.
	RTC_CR_ALRBE_Msk = 0x200
	// Bit ALRBE.
	RTC_CR_ALRBE = 0x200
	// Alarm B disabled
	RTC_CR_ALRBE_Disabled = 0x0
	// Alarm B enabled
	RTC_CR_ALRBE_Enabled = 0x1
	// Position of WUTE field.
	RTC_CR_WUTE_Pos = 0xa
	// Bit mask of WUTE field.
	RTC_CR_WUTE_Msk = 0x400
	// Bit WUTE.
	RTC_CR_WUTE = 0x400
	// Wakeup timer disabled
	RTC_CR_WUTE_Disabled = 0x0
	// Wakeup timer enabled
	RTC_CR_WUTE_Enabled = 0x1
	// Position of TSE field.
	RTC_CR_TSE_Pos = 0xb
	// Bit mask of TSE field.
	RTC_CR_TSE_Msk = 0x800
	// Bit TSE.
	RTC_CR_TSE = 0x800
	// Timestamp disabled
	RTC_CR_TSE_Disabled = 0x0
	// Timestamp enabled
	RTC_CR_TSE_Enabled = 0x1
	// Position of ALRAIE field.
	RTC_CR_ALRAIE_Pos = 0xc
	// Bit mask of ALRAIE field.
	RTC_CR_ALRAIE_Msk = 0x1000
	// Bit ALRAIE.
	RTC_CR_ALRAIE = 0x1000
	// Alarm A interrupt disabled
	RTC_CR_ALRAIE_Disabled = 0x0
	// Alarm A interrupt enabled
	RTC_CR_ALRAIE_Enabled = 0x1
	// Position of ALRBIE field.
	RTC_CR_ALRBIE_Pos = 0xd
	// Bit mask of ALRBIE field.
	RTC_CR_ALRBIE_Msk = 0x2000
	// Bit ALRBIE.
	RTC_CR_ALRBIE = 0x2000
	// Alarm B Interrupt disabled
	RTC_CR_ALRBIE_Disabled = 0x0
	// Alarm B Interrupt enabled
	RTC_CR_ALRBIE_Enabled = 0x1
	// Position of WUTIE field.
	RTC_CR_WUTIE_Pos = 0xe
	// Bit mask of WUTIE field.
	RTC_CR_WUTIE_Msk = 0x4000
	// Bit WUTIE.
	RTC_CR_WUTIE = 0x4000
	// Wakeup timer interrupt disabled
	RTC_CR_WUTIE_Disabled = 0x0
	// Wakeup timer interrupt enabled
	RTC_CR_WUTIE_Enabled = 0x1
	// Position of TSIE field.
	RTC_CR_TSIE_Pos = 0xf
	// Bit mask of TSIE field.
	RTC_CR_TSIE_Msk = 0x8000
	// Bit TSIE.
	RTC_CR_TSIE = 0x8000
	// Time-stamp Interrupt disabled
	RTC_CR_TSIE_Disabled = 0x0
	// Time-stamp Interrupt enabled
	RTC_CR_TSIE_Enabled = 0x1
	// Position of ADD1H field.
	RTC_CR_ADD1H_Pos = 0x10
	// Bit mask of ADD1H field.
	RTC_CR_ADD1H_Msk = 0x10000
	// Bit ADD1H.
	RTC_CR_ADD1H = 0x10000
	// Adds 1 hour to the current time. This can be used for summer time change outside initialization mode
	RTC_CR_ADD1H_Add1 = 0x1
	// Position of SUB1H field.
	RTC_CR_SUB1H_Pos = 0x11
	// Bit mask of SUB1H field.
	RTC_CR_SUB1H_Msk = 0x20000
	// Bit SUB1H.
	RTC_CR_SUB1H = 0x20000
	// Subtracts 1 hour to the current time. This can be used for winter time change outside initialization mode
	RTC_CR_SUB1H_Sub1 = 0x1
	// Position of BKP field.
	RTC_CR_BKP_Pos = 0x12
	// Bit mask of BKP field.
	RTC_CR_BKP_Msk = 0x40000
	// Bit BKP.
	RTC_CR_BKP = 0x40000
	// Daylight Saving Time change has not been performed
	RTC_CR_BKP_DST_Not_Changed = 0x0
	// Daylight Saving Time change has been performed
	RTC_CR_BKP_DST_Changed = 0x1
	// Position of COSEL field.
	RTC_CR_COSEL_Pos = 0x13
	// Bit mask of COSEL field.
	RTC_CR_COSEL_Msk = 0x80000
	// Bit COSEL.
	RTC_CR_COSEL = 0x80000
	// Calibration output is 512 Hz (with default prescaler setting)
	RTC_CR_COSEL_CalFreq_512Hz = 0x0
	// Calibration output is 1 Hz (with default prescaler setting)
	RTC_CR_COSEL_CalFreq_1Hz = 0x1
	// Position of POL field.
	RTC_CR_POL_Pos = 0x14
	// Bit mask of POL field.
	RTC_CR_POL_Msk = 0x100000
	// Bit POL.
	RTC_CR_POL = 0x100000
	// The pin is high when ALRAF/ALRBF/WUTF is asserted (depending on OSEL[1:0])
	RTC_CR_POL_High = 0x0
	// The pin is low when ALRAF/ALRBF/WUTF is asserted (depending on OSEL[1:0])
	RTC_CR_POL_Low = 0x1
	// Position of OSEL field.
	RTC_CR_OSEL_Pos = 0x15
	// Bit mask of OSEL field.
	RTC_CR_OSEL_Msk = 0x600000
	// Output disabled
	RTC_CR_OSEL_Disabled = 0x0
	// Alarm A output enabled
	RTC_CR_OSEL_AlarmA = 0x1
	// Alarm B output enabled
	RTC_CR_OSEL_AlarmB = 0x2
	// Wakeup output enabled
	RTC_CR_OSEL_Wakeup = 0x3
	// Position of COE field.
	RTC_CR_COE_Pos = 0x17
	// Bit mask of COE field.
	RTC_CR_COE_Msk = 0x800000
	// Bit COE.
	RTC_CR_COE = 0x800000
	// Calibration output disabled
	RTC_CR_COE_Disabled = 0x0
	// Calibration output enabled
	RTC_CR_COE_Enabled = 0x1

	// ISR: initialization and status register
	// Position of ALRAWF field.
	RTC_ISR_ALRAWF_Pos = 0x0
	// Bit mask of ALRAWF field.
	RTC_ISR_ALRAWF_Msk = 0x1
	// Bit ALRAWF.
	RTC_ISR_ALRAWF = 0x1
	// Alarm update not allowed
	RTC_ISR_ALRAWF_UpdateNotAllowed = 0x0
	// Alarm update allowed
	RTC_ISR_ALRAWF_UpdateAllowed = 0x1
	// Position of ALRBWF field.
	RTC_ISR_ALRBWF_Pos = 0x1
	// Bit mask of ALRBWF field.
	RTC_ISR_ALRBWF_Msk = 0x2
	// Bit ALRBWF.
	RTC_ISR_ALRBWF = 0x2
	// Alarm update not allowed
	RTC_ISR_ALRBWF_UpdateNotAllowed = 0x0
	// Alarm update allowed
	RTC_ISR_ALRBWF_UpdateAllowed = 0x1
	// Position of WUTWF field.
	RTC_ISR_WUTWF_Pos = 0x2
	// Bit mask of WUTWF field.
	RTC_ISR_WUTWF_Msk = 0x4
	// Bit WUTWF.
	RTC_ISR_WUTWF = 0x4
	// Wakeup timer configuration update not allowed
	RTC_ISR_WUTWF_UpdateNotAllowed = 0x0
	// Wakeup timer configuration update allowed
	RTC_ISR_WUTWF_UpdateAllowed = 0x1
	// Position of SHPF field.
	RTC_ISR_SHPF_Pos = 0x3
	// Bit mask of SHPF field.
	RTC_ISR_SHPF_Msk = 0x8
	// Bit SHPF.
	RTC_ISR_SHPF = 0x8
	// No shift operation is pending
	RTC_ISR_SHPF_NoShiftPending = 0x0
	// A shift operation is pending
	RTC_ISR_SHPF_ShiftPending = 0x1
	// Position of INITS field.
	RTC_ISR_INITS_Pos = 0x4
	// Bit mask of INITS field.
	RTC_ISR_INITS_Msk = 0x10
	// Bit INITS.
	RTC_ISR_INITS = 0x10
	// Calendar has not been initialized
	RTC_ISR_INITS_NotInitalized = 0x0
	// Calendar has been initialized
	RTC_ISR_INITS_Initalized = 0x1
	// Position of RSF field.
	RTC_ISR_RSF_Pos = 0x5
	// Bit mask of RSF field.
	RTC_ISR_RSF_Msk = 0x20
	// Bit RSF.
	RTC_ISR_RSF = 0x20
	// Calendar shadow registers not yet synchronized
	RTC_ISR_RSF_NotSynced = 0x0
	// Calendar shadow registers synchronized
	RTC_ISR_RSF_Synced = 0x1
	// This flag is cleared by software by writing 0
	RTC_ISR_RSF_Clear = 0x0
	// Position of INITF field.
	RTC_ISR_INITF_Pos = 0x6
	// Bit mask of INITF field.
	RTC_ISR_INITF_Msk = 0x40
	// Bit INITF.
	RTC_ISR_INITF = 0x40
	// Calendar registers update is not allowed
	RTC_ISR_INITF_NotAllowed = 0x0
	// Calendar registers update is allowed
	RTC_ISR_INITF_Allowed = 0x1
	// Position of INIT field.
	RTC_ISR_INIT_Pos = 0x7
	// Bit mask of INIT field.
	RTC_ISR_INIT_Msk = 0x80
	// Bit INIT.
	RTC_ISR_INIT = 0x80
	// Free running mode
	RTC_ISR_INIT_FreeRunningMode = 0x0
	// Initialization mode used to program time and date register (RTC_TR and RTC_DR), and prescaler register (RTC_PRER). Counters are stopped and start counting from the new value when INIT is reset.
	RTC_ISR_INIT_InitMode = 0x1
	// Position of ALRAF field.
	RTC_ISR_ALRAF_Pos = 0x8
	// Bit mask of ALRAF field.
	RTC_ISR_ALRAF_Msk = 0x100
	// Bit ALRAF.
	RTC_ISR_ALRAF = 0x100
	// This flag is set by hardware when the time/date registers (RTC_TR and RTC_DR) match the Alarm A register (RTC_ALRMAR)
	RTC_ISR_ALRAF_Match = 0x1
	// This flag is cleared by software by writing 0
	RTC_ISR_ALRAF_Clear = 0x0
	// Position of ALRBF field.
	RTC_ISR_ALRBF_Pos = 0x9
	// Bit mask of ALRBF field.
	RTC_ISR_ALRBF_Msk = 0x200
	// Bit ALRBF.
	RTC_ISR_ALRBF = 0x200
	// This flag is set by hardware when the time/date registers (RTC_TR and RTC_DR) match the Alarm B register (RTC_ALRMBR)
	RTC_ISR_ALRBF_Match = 0x1
	// This flag is cleared by software by writing 0
	RTC_ISR_ALRBF_Clear = 0x0
	// Position of WUTF field.
	RTC_ISR_WUTF_Pos = 0xa
	// Bit mask of WUTF field.
	RTC_ISR_WUTF_Msk = 0x400
	// Bit WUTF.
	RTC_ISR_WUTF = 0x400
	// This flag is set by hardware when the wakeup auto-reload counter reaches 0
	RTC_ISR_WUTF_Zero = 0x1
	// This flag is cleared by software by writing 0
	RTC_ISR_WUTF_Clear = 0x0
	// Position of TSF field.
	RTC_ISR_TSF_Pos = 0xb
	// Bit mask of TSF field.
	RTC_ISR_TSF_Msk = 0x800
	// Bit TSF.
	RTC_ISR_TSF = 0x800
	// This flag is set by hardware when a time-stamp event occurs
	RTC_ISR_TSF_TimestampEvent = 0x1
	// This flag is cleared by software by writing 0
	RTC_ISR_TSF_Clear = 0x0
	// Position of TSOVF field.
	RTC_ISR_TSOVF_Pos = 0xc
	// Bit mask of TSOVF field.
	RTC_ISR_TSOVF_Msk = 0x1000
	// Bit TSOVF.
	RTC_ISR_TSOVF = 0x1000
	// This flag is set by hardware when a time-stamp event occurs while TSF is already set
	RTC_ISR_TSOVF_Overflow = 0x1
	// This flag is cleared by software by writing 0
	RTC_ISR_TSOVF_Clear = 0x0
	// Position of TAMP1F field.
	RTC_ISR_TAMP1F_Pos = 0xd
	// Bit mask of TAMP1F field.
	RTC_ISR_TAMP1F_Msk = 0x2000
	// Bit TAMP1F.
	RTC_ISR_TAMP1F = 0x2000
	// This flag is set by hardware when a tamper detection event is detected on the RTC_TAMPx input
	RTC_ISR_TAMP1F_Tampered = 0x1
	// Flag cleared by software writing 0
	RTC_ISR_TAMP1F_Clear = 0x0
	// Position of TAMP2F field.
	RTC_ISR_TAMP2F_Pos = 0xe
	// Bit mask of TAMP2F field.
	RTC_ISR_TAMP2F_Msk = 0x4000
	// Bit TAMP2F.
	RTC_ISR_TAMP2F = 0x4000
	// This flag is set by hardware when a tamper detection event is detected on the RTC_TAMPx input
	RTC_ISR_TAMP2F_Tampered = 0x1
	// Flag cleared by software writing 0
	RTC_ISR_TAMP2F_Clear = 0x0
	// Position of TAMP3F field.
	RTC_ISR_TAMP3F_Pos = 0xf
	// Bit mask of TAMP3F field.
	RTC_ISR_TAMP3F_Msk = 0x8000
	// Bit TAMP3F.
	RTC_ISR_TAMP3F = 0x8000
	// This flag is set by hardware when a tamper detection event is detected on the RTC_TAMPx input
	RTC_ISR_TAMP3F_Tampered = 0x1
	// Flag cleared by software writing 0
	RTC_ISR_TAMP3F_Clear = 0x0
	// Position of RECALPF field.
	RTC_ISR_RECALPF_Pos = 0x10
	// Bit mask of RECALPF field.
	RTC_ISR_RECALPF_Msk = 0x10000
	// Bit RECALPF.
	RTC_ISR_RECALPF = 0x10000
	// The RECALPF status flag is automatically set to 1 when software writes to the RTC_CALR register, indicating that the RTC_CALR register is blocked. When the new calibration settings are taken into account, this bit returns to 0
	RTC_ISR_RECALPF_Pending = 0x1

	// PRER: prescaler register
	// Position of PREDIV_A field.
	RTC_PRER_PREDIV_A_Pos = 0x10
	// Bit mask of PREDIV_A field.
	RTC_PRER_PREDIV_A_Msk = 0x7f0000
	// Position of PREDIV_S field.
	RTC_PRER_PREDIV_S_Pos = 0x0
	// Bit mask of PREDIV_S field.
	RTC_PRER_PREDIV_S_Msk = 0x7fff

	// WUTR: wakeup timer register
	// Position of WUT field.
	RTC_WUTR_WUT_Pos = 0x0
	// Bit mask of WUT field.
	RTC_WUTR_WUT_Msk = 0xffff

	// ALRMAR: alarm A register
	// Position of MSK4 field.
	RTC_ALRMAR_MSK4_Pos = 0x1f
	// Bit mask of MSK4 field.
	RTC_ALRMAR_MSK4_Msk = 0x80000000
	// Bit MSK4.
	RTC_ALRMAR_MSK4 = 0x80000000
	// Alarm set if the date/day match
	RTC_ALRMAR_MSK4_Mask = 0x0
	// Date/day don’t care in Alarm comparison
	RTC_ALRMAR_MSK4_NotMask = 0x1
	// Position of WDSEL field.
	RTC_ALRMAR_WDSEL_Pos = 0x1e
	// Bit mask of WDSEL field.
	RTC_ALRMAR_WDSEL_Msk = 0x40000000
	// Bit WDSEL.
	RTC_ALRMAR_WDSEL = 0x40000000
	// DU[3:0] represents the date units
	RTC_ALRMAR_WDSEL_DateUnits = 0x0
	// DU[3:0] represents the week day. DT[1:0] is don’t care.
	RTC_ALRMAR_WDSEL_WeekDay = 0x1
	// Position of DT field.
	RTC_ALRMAR_DT_Pos = 0x1c
	// Bit mask of DT field.
	RTC_ALRMAR_DT_Msk = 0x30000000
	// Position of DU field.
	RTC_ALRMAR_DU_Pos = 0x18
	// Bit mask of DU field.
	RTC_ALRMAR_DU_Msk = 0xf000000
	// Position of MSK3 field.
	RTC_ALRMAR_MSK3_Pos = 0x17
	// Bit mask of MSK3 field.
	RTC_ALRMAR_MSK3_Msk = 0x800000
	// Bit MSK3.
	RTC_ALRMAR_MSK3 = 0x800000
	// Alarm set if the date/day match
	RTC_ALRMAR_MSK3_Mask = 0x0
	// Date/day don’t care in Alarm comparison
	RTC_ALRMAR_MSK3_NotMask = 0x1
	// Position of PM field.
	RTC_ALRMAR_PM_Pos = 0x16
	// Bit mask of PM field.
	RTC_ALRMAR_PM_Msk = 0x400000
	// Bit PM.
	RTC_ALRMAR_PM = 0x400000
	// AM or 24-hour format
	RTC_ALRMAR_PM_AM = 0x0
	// PM
	RTC_ALRMAR_PM_PM = 0x1
	// Position of HT field.
	RTC_ALRMAR_HT_Pos = 0x14
	// Bit mask of HT field.
	RTC_ALRMAR_HT_Msk = 0x300000
	// Position of HU field.
	RTC_ALRMAR_HU_Pos = 0x10
	// Bit mask of HU field.
	RTC_ALRMAR_HU_Msk = 0xf0000
	// Position of MSK2 field.
	RTC_ALRMAR_MSK2_Pos = 0xf
	// Bit mask of MSK2 field.
	RTC_ALRMAR_MSK2_Msk = 0x8000
	// Bit MSK2.
	RTC_ALRMAR_MSK2 = 0x8000
	// Alarm set if the date/day match
	RTC_ALRMAR_MSK2_Mask = 0x0
	// Date/day don’t care in Alarm comparison
	RTC_ALRMAR_MSK2_NotMask = 0x1
	// Position of MNT field.
	RTC_ALRMAR_MNT_Pos = 0xc
	// Bit mask of MNT field.
	RTC_ALRMAR_MNT_Msk = 0x7000
	// Position of MNU field.
	RTC_ALRMAR_MNU_Pos = 0x8
	// Bit mask of MNU field.
	RTC_ALRMAR_MNU_Msk = 0xf00
	// Position of MSK1 field.
	RTC_ALRMAR_MSK1_Pos = 0x7
	// Bit mask of MSK1 field.
	RTC_ALRMAR_MSK1_Msk = 0x80
	// Bit MSK1.
	RTC_ALRMAR_MSK1 = 0x80
	// Alarm set if the date/day match
	RTC_ALRMAR_MSK1_Mask = 0x0
	// Date/day don’t care in Alarm comparison
	RTC_ALRMAR_MSK1_NotMask = 0x1
	// Position of ST field.
	RTC_ALRMAR_ST_Pos = 0x4
	// Bit mask of ST field.
	RTC_ALRMAR_ST_Msk = 0x70
	// Position of SU field.
	RTC_ALRMAR_SU_Pos = 0x0
	// Bit mask of SU field.
	RTC_ALRMAR_SU_Msk = 0xf

	// ALRMBR: alarm B register
	// Position of MSK4 field.
	RTC_ALRMBR_MSK4_Pos = 0x1f
	// Bit mask of MSK4 field.
	RTC_ALRMBR_MSK4_Msk = 0x80000000
	// Bit MSK4.
	RTC_ALRMBR_MSK4 = 0x80000000
	// Alarm set if the date/day match
	RTC_ALRMBR_MSK4_Mask = 0x0
	// Date/day don’t care in Alarm comparison
	RTC_ALRMBR_MSK4_NotMask = 0x1
	// Position of WDSEL field.
	RTC_ALRMBR_WDSEL_Pos = 0x1e
	// Bit mask of WDSEL field.
	RTC_ALRMBR_WDSEL_Msk = 0x40000000
	// Bit WDSEL.
	RTC_ALRMBR_WDSEL = 0x40000000
	// DU[3:0] represents the date units
	RTC_ALRMBR_WDSEL_DateUnits = 0x0
	// DU[3:0] represents the week day. DT[1:0] is don’t care.
	RTC_ALRMBR_WDSEL_WeekDay = 0x1
	// Position of DT field.
	RTC_ALRMBR_DT_Pos = 0x1c
	// Bit mask of DT field.
	RTC_ALRMBR_DT_Msk = 0x30000000
	// Position of DU field.
	RTC_ALRMBR_DU_Pos = 0x18
	// Bit mask of DU field.
	RTC_ALRMBR_DU_Msk = 0xf000000
	// Position of MSK3 field.
	RTC_ALRMBR_MSK3_Pos = 0x17
	// Bit mask of MSK3 field.
	RTC_ALRMBR_MSK3_Msk = 0x800000
	// Bit MSK3.
	RTC_ALRMBR_MSK3 = 0x800000
	// Alarm set if the date/day match
	RTC_ALRMBR_MSK3_Mask = 0x0
	// Date/day don’t care in Alarm comparison
	RTC_ALRMBR_MSK3_NotMask = 0x1
	// Position of PM field.
	RTC_ALRMBR_PM_Pos = 0x16
	// Bit mask of PM field.
	RTC_ALRMBR_PM_Msk = 0x400000
	// Bit PM.
	RTC_ALRMBR_PM = 0x400000
	// AM or 24-hour format
	RTC_ALRMBR_PM_AM = 0x0
	// PM
	RTC_ALRMBR_PM_PM = 0x1
	// Position of HT field.
	RTC_ALRMBR_HT_Pos = 0x14
	// Bit mask of HT field.
	RTC_ALRMBR_HT_Msk = 0x300000
	// Position of HU field.
	RTC_ALRMBR_HU_Pos = 0x10
	// Bit mask of HU field.
	RTC_ALRMBR_HU_Msk = 0xf0000
	// Position of MSK2 field.
	RTC_ALRMBR_MSK2_Pos = 0xf
	// Bit mask of MSK2 field.
	RTC_ALRMBR_MSK2_Msk = 0x8000
	// Bit MSK2.
	RTC_ALRMBR_MSK2 = 0x8000
	// Alarm set if the date/day match
	RTC_ALRMBR_MSK2_Mask = 0x0
	// Date/day don’t care in Alarm comparison
	RTC_ALRMBR_MSK2_NotMask = 0x1
	// Position of MNT field.
	RTC_ALRMBR_MNT_Pos = 0xc
	// Bit mask of MNT field.
	RTC_ALRMBR_MNT_Msk = 0x7000
	// Position of MNU field.
	RTC_ALRMBR_MNU_Pos = 0x8
	// Bit mask of MNU field.
	RTC_ALRMBR_MNU_Msk = 0xf00
	// Position of MSK1 field.
	RTC_ALRMBR_MSK1_Pos = 0x7
	// Bit mask of MSK1 field.
	RTC_ALRMBR_MSK1_Msk = 0x80
	// Bit MSK1.
	RTC_ALRMBR_MSK1 = 0x80
	// Alarm set if the date/day match
	RTC_ALRMBR_MSK1_Mask = 0x0
	// Date/day don’t care in Alarm comparison
	RTC_ALRMBR_MSK1_NotMask = 0x1
	// Position of ST field.
	RTC_ALRMBR_ST_Pos = 0x4
	// Bit mask of ST field.
	RTC_ALRMBR_ST_Msk = 0x70
	// Position of SU field.
	RTC_ALRMBR_SU_Pos = 0x0
	// Bit mask of SU field.
	RTC_ALRMBR_SU_Msk = 0xf

	// WPR: write protection register
	// Position of KEY field.
	RTC_WPR_KEY_Pos = 0x0
	// Bit mask of KEY field.
	RTC_WPR_KEY_Msk = 0xff

	// SSR: sub second register
	// Position of SS field.
	RTC_SSR_SS_Pos = 0x0
	// Bit mask of SS field.
	RTC_SSR_SS_Msk = 0xffff

	// SHIFTR: shift control register
	// Position of ADD1S field.
	RTC_SHIFTR_ADD1S_Pos = 0x1f
	// Bit mask of ADD1S field.
	RTC_SHIFTR_ADD1S_Msk = 0x80000000
	// Bit ADD1S.
	RTC_SHIFTR_ADD1S = 0x80000000
	// Add one second to the clock/calendar
	RTC_SHIFTR_ADD1S_Add1 = 0x1
	// Position of SUBFS field.
	RTC_SHIFTR_SUBFS_Pos = 0x0
	// Bit mask of SUBFS field.
	RTC_SHIFTR_SUBFS_Msk = 0x7fff

	// TSTR: time stamp time register
	// Position of SU field.
	RTC_TSTR_SU_Pos = 0x0
	// Bit mask of SU field.
	RTC_TSTR_SU_Msk = 0xf
	// Position of ST field.
	RTC_TSTR_ST_Pos = 0x4
	// Bit mask of ST field.
	RTC_TSTR_ST_Msk = 0x70
	// Position of MNU field.
	RTC_TSTR_MNU_Pos = 0x8
	// Bit mask of MNU field.
	RTC_TSTR_MNU_Msk = 0xf00
	// Position of MNT field.
	RTC_TSTR_MNT_Pos = 0xc
	// Bit mask of MNT field.
	RTC_TSTR_MNT_Msk = 0x7000
	// Position of HU field.
	RTC_TSTR_HU_Pos = 0x10
	// Bit mask of HU field.
	RTC_TSTR_HU_Msk = 0xf0000
	// Position of HT field.
	RTC_TSTR_HT_Pos = 0x14
	// Bit mask of HT field.
	RTC_TSTR_HT_Msk = 0x300000
	// Position of PM field.
	RTC_TSTR_PM_Pos = 0x16
	// Bit mask of PM field.
	RTC_TSTR_PM_Msk = 0x400000
	// Bit PM.
	RTC_TSTR_PM = 0x400000

	// TSDR: time stamp date register
	// Position of WDU field.
	RTC_TSDR_WDU_Pos = 0xd
	// Bit mask of WDU field.
	RTC_TSDR_WDU_Msk = 0xe000
	// Position of MT field.
	RTC_TSDR_MT_Pos = 0xc
	// Bit mask of MT field.
	RTC_TSDR_MT_Msk = 0x1000
	// Bit MT.
	RTC_TSDR_MT = 0x1000
	// Position of MU field.
	RTC_TSDR_MU_Pos = 0x8
	// Bit mask of MU field.
	RTC_TSDR_MU_Msk = 0xf00
	// Position of DT field.
	RTC_TSDR_DT_Pos = 0x4
	// Bit mask of DT field.
	RTC_TSDR_DT_Msk = 0x30
	// Position of DU field.
	RTC_TSDR_DU_Pos = 0x0
	// Bit mask of DU field.
	RTC_TSDR_DU_Msk = 0xf

	// TSSSR: timestamp sub second register
	// Position of SS field.
	RTC_TSSSR_SS_Pos = 0x0
	// Bit mask of SS field.
	RTC_TSSSR_SS_Msk = 0xffff

	// CALR: calibration register
	// Position of CALP field.
	RTC_CALR_CALP_Pos = 0xf
	// Bit mask of CALP field.
	RTC_CALR_CALP_Msk = 0x8000
	// Bit CALP.
	RTC_CALR_CALP = 0x8000
	// No RTCCLK pulses are added
	RTC_CALR_CALP_NoChange = 0x0
	// One RTCCLK pulse is effectively inserted every 2^11 pulses (frequency increased by 488.5 ppm)
	RTC_CALR_CALP_IncreaseFreq = 0x1
	// Position of CALW8 field.
	RTC_CALR_CALW8_Pos = 0xe
	// Bit mask of CALW8 field.
	RTC_CALR_CALW8_Msk = 0x4000
	// Bit CALW8.
	RTC_CALR_CALW8 = 0x4000
	// When CALW8 is set to ‘1’, the 8-second calibration cycle period is selected
	RTC_CALR_CALW8_Eight_Second = 0x1
	// Position of CALW16 field.
	RTC_CALR_CALW16_Pos = 0xd
	// Bit mask of CALW16 field.
	RTC_CALR_CALW16_Msk = 0x2000
	// Bit CALW16.
	RTC_CALR_CALW16 = 0x2000
	// When CALW16 is set to ‘1’, the 16-second calibration cycle period is selected.This bit must not be set to ‘1’ if CALW8=1
	RTC_CALR_CALW16_Sixteen_Second = 0x1
	// Position of CALM field.
	RTC_CALR_CALM_Pos = 0x0
	// Bit mask of CALM field.
	RTC_CALR_CALM_Msk = 0x1ff

	// TAFCR: tamper and alternate function configuration register
	// Position of TAMP1E field.
	RTC_TAFCR_TAMP1E_Pos = 0x0
	// Bit mask of TAMP1E field.
	RTC_TAFCR_TAMP1E_Msk = 0x1
	// Bit TAMP1E.
	RTC_TAFCR_TAMP1E = 0x1
	// RTC_TAMPx input detection disabled
	RTC_TAFCR_TAMP1E_Disabled = 0x0
	// RTC_TAMPx input detection enabled
	RTC_TAFCR_TAMP1E_Enabled = 0x1
	// Position of TAMP1TRG field.
	RTC_TAFCR_TAMP1TRG_Pos = 0x1
	// Bit mask of TAMP1TRG field.
	RTC_TAFCR_TAMP1TRG_Msk = 0x2
	// Bit TAMP1TRG.
	RTC_TAFCR_TAMP1TRG = 0x2
	// If TAMPFLT = 00: RTC_TAMPx input rising edge triggers a tamper detection event. If TAMPFLT ≠ 00: RTC_TAMPx input staying low triggers a tamper detection event.
	RTC_TAFCR_TAMP1TRG_RisingEdge = 0x0
	// If TAMPFLT = 00: RTC_TAMPx input staying high triggers a tamper detection event. If TAMPFLT ≠ 00: RTC_TAMPx input falling edge triggers a tamper detection event
	RTC_TAFCR_TAMP1TRG_FallingEdge = 0x1
	// Position of TAMPIE field.
	RTC_TAFCR_TAMPIE_Pos = 0x2
	// Bit mask of TAMPIE field.
	RTC_TAFCR_TAMPIE_Msk = 0x4
	// Bit TAMPIE.
	RTC_TAFCR_TAMPIE = 0x4
	// Tamper interrupt disabled
	RTC_TAFCR_TAMPIE_Disabled = 0x0
	// Tamper interrupt enabled
	RTC_TAFCR_TAMPIE_Enabled = 0x1
	// Position of TAMP2E field.
	RTC_TAFCR_TAMP2E_Pos = 0x3
	// Bit mask of TAMP2E field.
	RTC_TAFCR_TAMP2E_Msk = 0x8
	// Bit TAMP2E.
	RTC_TAFCR_TAMP2E = 0x8
	// RTC_TAMPx input detection disabled
	RTC_TAFCR_TAMP2E_Disabled = 0x0
	// RTC_TAMPx input detection enabled
	RTC_TAFCR_TAMP2E_Enabled = 0x1
	// Position of TAMP2TRG field.
	RTC_TAFCR_TAMP2TRG_Pos = 0x4
	// Bit mask of TAMP2TRG field.
	RTC_TAFCR_TAMP2TRG_Msk = 0x10
	// Bit TAMP2TRG.
	RTC_TAFCR_TAMP2TRG = 0x10
	// If TAMPFLT = 00: RTC_TAMPx input rising edge triggers a tamper detection event. If TAMPFLT ≠ 00: RTC_TAMPx input staying low triggers a tamper detection event.
	RTC_TAFCR_TAMP2TRG_RisingEdge = 0x0
	// If TAMPFLT = 00: RTC_TAMPx input staying high triggers a tamper detection event. If TAMPFLT ≠ 00: RTC_TAMPx input falling edge triggers a tamper detection event
	RTC_TAFCR_TAMP2TRG_FallingEdge = 0x1
	// Position of TAMP3E field.
	RTC_TAFCR_TAMP3E_Pos = 0x5
	// Bit mask of TAMP3E field.
	RTC_TAFCR_TAMP3E_Msk = 0x20
	// Bit TAMP3E.
	RTC_TAFCR_TAMP3E = 0x20
	// RTC_TAMPx input detection disabled
	RTC_TAFCR_TAMP3E_Disabled = 0x0
	// RTC_TAMPx input detection enabled
	RTC_TAFCR_TAMP3E_Enabled = 0x1
	// Position of TAMP3TRG field.
	RTC_TAFCR_TAMP3TRG_Pos = 0x6
	// Bit mask of TAMP3TRG field.
	RTC_TAFCR_TAMP3TRG_Msk = 0x40
	// Bit TAMP3TRG.
	RTC_TAFCR_TAMP3TRG = 0x40
	// If TAMPFLT = 00: RTC_TAMPx input rising edge triggers a tamper detection event. If TAMPFLT ≠ 00: RTC_TAMPx input staying low triggers a tamper detection event.
	RTC_TAFCR_TAMP3TRG_RisingEdge = 0x0
	// If TAMPFLT = 00: RTC_TAMPx input staying high triggers a tamper detection event. If TAMPFLT ≠ 00: RTC_TAMPx input falling edge triggers a tamper detection event
	RTC_TAFCR_TAMP3TRG_FallingEdge = 0x1
	// Position of TAMPTS field.
	RTC_TAFCR_TAMPTS_Pos = 0x7
	// Bit mask of TAMPTS field.
	RTC_TAFCR_TAMPTS_Msk = 0x80
	// Bit TAMPTS.
	RTC_TAFCR_TAMPTS = 0x80
	// Tamper detection event does not cause a timestamp to be saved
	RTC_TAFCR_TAMPTS_NoSave = 0x0
	// Save timestamp on tamper detection event
	RTC_TAFCR_TAMPTS_Save = 0x1
	// Position of TAMPFREQ field.
	RTC_TAFCR_TAMPFREQ_Pos = 0x8
	// Bit mask of TAMPFREQ field.
	RTC_TAFCR_TAMPFREQ_Msk = 0x700
	// RTCCLK / 32768 (1 Hz when RTCCLK = 32768 Hz)
	RTC_TAFCR_TAMPFREQ_Div32768 = 0x0
	// RTCCLK / 16384 (2 Hz when RTCCLK = 32768 Hz)
	RTC_TAFCR_TAMPFREQ_Div16384 = 0x1
	// RTCCLK / 8192 (4 Hz when RTCCLK = 32768 Hz)
	RTC_TAFCR_TAMPFREQ_Div8192 = 0x2
	// RTCCLK / 4096 (8 Hz when RTCCLK = 32768 Hz)
	RTC_TAFCR_TAMPFREQ_Div4096 = 0x3
	// RTCCLK / 2048 (16 Hz when RTCCLK = 32768 Hz)
	RTC_TAFCR_TAMPFREQ_Div2048 = 0x4
	// RTCCLK / 1024 (32 Hz when RTCCLK = 32768 Hz)
	RTC_TAFCR_TAMPFREQ_Div1024 = 0x5
	// RTCCLK / 512 (64 Hz when RTCCLK = 32768 Hz)
	RTC_TAFCR_TAMPFREQ_Div512 = 0x6
	// RTCCLK / 256 (128 Hz when RTCCLK = 32768 Hz)
	RTC_TAFCR_TAMPFREQ_Div256 = 0x7
	// Position of TAMPFLT field.
	RTC_TAFCR_TAMPFLT_Pos = 0xb
	// Bit mask of TAMPFLT field.
	RTC_TAFCR_TAMPFLT_Msk = 0x1800
	// Tamper event is activated on edge of RTC_TAMPx input transitions to the active level (no internal pull-up on RTC_TAMPx input)
	RTC_TAFCR_TAMPFLT_Immediate = 0x0
	// Tamper event is activated after 2 consecutive samples at the active level
	RTC_TAFCR_TAMPFLT_Samples2 = 0x1
	// Tamper event is activated after 4 consecutive samples at the active level
	RTC_TAFCR_TAMPFLT_Samples4 = 0x2
	// Tamper event is activated after 8 consecutive samples at the active level
	RTC_TAFCR_TAMPFLT_Samples8 = 0x3
	// Position of TAMPPRCH field.
	RTC_TAFCR_TAMPPRCH_Pos = 0xd
	// Bit mask of TAMPPRCH field.
	RTC_TAFCR_TAMPPRCH_Msk = 0x6000
	// 1 RTCCLK cycle
	RTC_TAFCR_TAMPPRCH_Cycles1 = 0x0
	// 2 RTCCLK cycles
	RTC_TAFCR_TAMPPRCH_Cycles2 = 0x1
	// 4 RTCCLK cycles
	RTC_TAFCR_TAMPPRCH_Cycles4 = 0x2
	// 8 RTCCLK cycles
	RTC_TAFCR_TAMPPRCH_Cycles8 = 0x3
	// Position of TAMPPUDIS field.
	RTC_TAFCR_TAMPPUDIS_Pos = 0xf
	// Bit mask of TAMPPUDIS field.
	RTC_TAFCR_TAMPPUDIS_Msk = 0x8000
	// Bit TAMPPUDIS.
	RTC_TAFCR_TAMPPUDIS = 0x8000
	// Precharge RTC_TAMPx pins before sampling (enable internal pull-up)
	RTC_TAFCR_TAMPPUDIS_Enabled = 0x0
	// Disable precharge of RTC_TAMPx pins
	RTC_TAFCR_TAMPPUDIS_Disabled = 0x1
	// Position of PC13VALUE field.
	RTC_TAFCR_PC13VALUE_Pos = 0x12
	// Bit mask of PC13VALUE field.
	RTC_TAFCR_PC13VALUE_Msk = 0x40000
	// Bit PC13VALUE.
	RTC_TAFCR_PC13VALUE = 0x40000
	// If the LSE is disabled and PCxMODE = 1, set PCxVALUE to logic high
	RTC_TAFCR_PC13VALUE_High = 0x1
	// If the LSE is disabled and PCxMODE = 1, set PCxVALUE to logic low
	RTC_TAFCR_PC13VALUE_Low = 0x0
	// Position of PC13MODE field.
	RTC_TAFCR_PC13MODE_Pos = 0x13
	// Bit mask of PC13MODE field.
	RTC_TAFCR_PC13MODE_Msk = 0x80000
	// Bit PC13MODE.
	RTC_TAFCR_PC13MODE = 0x80000
	// PCx is controlled by the GPIO configuration Register. Consequently PC15 is floating in Standby mode
	RTC_TAFCR_PC13MODE_Floating = 0x0
	// PCx is forced to push-pull output if LSE is disabled
	RTC_TAFCR_PC13MODE_PushPull = 0x1
	// Position of PC14VALUE field.
	RTC_TAFCR_PC14VALUE_Pos = 0x14
	// Bit mask of PC14VALUE field.
	RTC_TAFCR_PC14VALUE_Msk = 0x100000
	// Bit PC14VALUE.
	RTC_TAFCR_PC14VALUE = 0x100000
	// If the LSE is disabled and PCxMODE = 1, set PCxVALUE to logic high
	RTC_TAFCR_PC14VALUE_High = 0x1
	// If the LSE is disabled and PCxMODE = 1, set PCxVALUE to logic low
	RTC_TAFCR_PC14VALUE_Low = 0x0
	// Position of PC14MODE field.
	RTC_TAFCR_PC14MODE_Pos = 0x15
	// Bit mask of PC14MODE field.
	RTC_TAFCR_PC14MODE_Msk = 0x200000
	// Bit PC14MODE.
	RTC_TAFCR_PC14MODE = 0x200000
	// PCx is controlled by the GPIO configuration Register. Consequently PC15 is floating in Standby mode
	RTC_TAFCR_PC14MODE_Floating = 0x0
	// PCx is forced to push-pull output if LSE is disabled
	RTC_TAFCR_PC14MODE_PushPull = 0x1
	// Position of PC15VALUE field.
	RTC_TAFCR_PC15VALUE_Pos = 0x16
	// Bit mask of PC15VALUE field.
	RTC_TAFCR_PC15VALUE_Msk = 0x400000
	// Bit PC15VALUE.
	RTC_TAFCR_PC15VALUE = 0x400000
	// If the LSE is disabled and PCxMODE = 1, set PCxVALUE to logic high
	RTC_TAFCR_PC15VALUE_High = 0x1
	// If the LSE is disabled and PCxMODE = 1, set PCxVALUE to logic low
	RTC_TAFCR_PC15VALUE_Low = 0x0
	// Position of PC15MODE field.
	RTC_TAFCR_PC15MODE_Pos = 0x17
	// Bit mask of PC15MODE field.
	RTC_TAFCR_PC15MODE_Msk = 0x800000
	// Bit PC15MODE.
	RTC_TAFCR_PC15MODE = 0x800000
	// PCx is controlled by the GPIO configuration Register. Consequently PC15 is floating in Standby mode
	RTC_TAFCR_PC15MODE_Floating = 0x0
	// PCx is forced to push-pull output if LSE is disabled
	RTC_TAFCR_PC15MODE_PushPull = 0x1

	// ALRMASSR: alarm A sub second register
	// Position of MASKSS field.
	RTC_ALRMASSR_MASKSS_Pos = 0x18
	// Bit mask of MASKSS field.
	RTC_ALRMASSR_MASKSS_Msk = 0xf000000
	// Position of SS field.
	RTC_ALRMASSR_SS_Pos = 0x0
	// Bit mask of SS field.
	RTC_ALRMASSR_SS_Msk = 0x7fff

	// ALRMBSSR: alarm B sub second register
	// Position of MASKSS field.
	RTC_ALRMBSSR_MASKSS_Pos = 0x18
	// Bit mask of MASKSS field.
	RTC_ALRMBSSR_MASKSS_Msk = 0xf000000
	// Position of SS field.
	RTC_ALRMBSSR_SS_Pos = 0x0
	// Bit mask of SS field.
	RTC_ALRMBSSR_SS_Msk = 0x7fff

	// BKP0R: backup register
	// Position of BKP field.
	RTC_BKPR_BKP_Pos = 0x0
	// Bit mask of BKP field.
	RTC_BKPR_BKP_Msk = 0xffffffff
)

// Bitfields for DAC: Digital-to-analog converter
const (
	// CR: control register
	// Position of DMAUDRIE2 field.
	DAC_CR_DMAUDRIE2_Pos = 0x1d
	// Bit mask of DMAUDRIE2 field.
	DAC_CR_DMAUDRIE2_Msk = 0x20000000
	// Bit DMAUDRIE2.
	DAC_CR_DMAUDRIE2 = 0x20000000
	// DAC channel X DMA Underrun Interrupt disabled
	DAC_CR_DMAUDRIE2_Disabled = 0x0
	// DAC channel X DMA Underrun Interrupt enabled
	DAC_CR_DMAUDRIE2_Enabled = 0x1
	// Position of DMAEN2 field.
	DAC_CR_DMAEN2_Pos = 0x1c
	// Bit mask of DMAEN2 field.
	DAC_CR_DMAEN2_Msk = 0x10000000
	// Bit DMAEN2.
	DAC_CR_DMAEN2 = 0x10000000
	// DAC channel X DMA mode disabled
	DAC_CR_DMAEN2_Disabled = 0x0
	// DAC channel X DMA mode enabled
	DAC_CR_DMAEN2_Enabled = 0x1
	// Position of MAMP2 field.
	DAC_CR_MAMP2_Pos = 0x18
	// Bit mask of MAMP2 field.
	DAC_CR_MAMP2_Msk = 0xf000000
	// Position of WAVE2 field.
	DAC_CR_WAVE2_Pos = 0x16
	// Bit mask of WAVE2 field.
	DAC_CR_WAVE2_Msk = 0xc00000
	// Wave generation disabled
	DAC_CR_WAVE2_Disabled = 0x0
	// Noise wave generation enabled
	DAC_CR_WAVE2_Noise = 0x1
	// Triangle wave generation enabled
	DAC_CR_WAVE2_Triangle = 0x2
	// Position of TSEL2 field.
	DAC_CR_TSEL2_Pos = 0x13
	// Bit mask of TSEL2 field.
	DAC_CR_TSEL2_Msk = 0x380000
	// Timer 6 TRGO event
	DAC_CR_TSEL2_TIM6_TRGO = 0x0
	// Timer 8 TRGO event
	DAC_CR_TSEL2_TIM8_TRGO = 0x1
	// Timer 7 TRGO event
	DAC_CR_TSEL2_TIM7_TRGO = 0x2
	// Timer 5 TRGO event
	DAC_CR_TSEL2_TIM5_TRGO = 0x3
	// Timer 2 TRGO event
	DAC_CR_TSEL2_TIM2_TRGO = 0x4
	// Timer 4 TRGO event
	DAC_CR_TSEL2_TIM4_TRGO = 0x5
	// EXTI line9
	DAC_CR_TSEL2_EXTI9 = 0x6
	// Software trigger
	DAC_CR_TSEL2_SOFTWARE = 0x7
	// Position of TEN2 field.
	DAC_CR_TEN2_Pos = 0x12
	// Bit mask of TEN2 field.
	DAC_CR_TEN2_Msk = 0x40000
	// Bit TEN2.
	DAC_CR_TEN2 = 0x40000
	// DAC channel X trigger disabled
	DAC_CR_TEN2_Disabled = 0x0
	// DAC channel X trigger enabled
	DAC_CR_TEN2_Enabled = 0x1
	// Position of BOFF2 field.
	DAC_CR_BOFF2_Pos = 0x11
	// Bit mask of BOFF2 field.
	DAC_CR_BOFF2_Msk = 0x20000
	// Bit BOFF2.
	DAC_CR_BOFF2 = 0x20000
	// DAC channel X output buffer enabled
	DAC_CR_BOFF2_Enabled = 0x0
	// DAC channel X output buffer disabled
	DAC_CR_BOFF2_Disabled = 0x1
	// Position of EN2 field.
	DAC_CR_EN2_Pos = 0x10
	// Bit mask of EN2 field.
	DAC_CR_EN2_Msk = 0x10000
	// Bit EN2.
	DAC_CR_EN2 = 0x10000
	// DAC channel X disabled
	DAC_CR_EN2_Disabled = 0x0
	// DAC channel X enabled
	DAC_CR_EN2_Enabled = 0x1
	// Position of DMAUDRIE1 field.
	DAC_CR_DMAUDRIE1_Pos = 0xd
	// Bit mask of DMAUDRIE1 field.
	DAC_CR_DMAUDRIE1_Msk = 0x2000
	// Bit DMAUDRIE1.
	DAC_CR_DMAUDRIE1 = 0x2000
	// DAC channel X DMA Underrun Interrupt disabled
	DAC_CR_DMAUDRIE1_Disabled = 0x0
	// DAC channel X DMA Underrun Interrupt enabled
	DAC_CR_DMAUDRIE1_Enabled = 0x1
	// Position of DMAEN1 field.
	DAC_CR_DMAEN1_Pos = 0xc
	// Bit mask of DMAEN1 field.
	DAC_CR_DMAEN1_Msk = 0x1000
	// Bit DMAEN1.
	DAC_CR_DMAEN1 = 0x1000
	// DAC channel X DMA mode disabled
	DAC_CR_DMAEN1_Disabled = 0x0
	// DAC channel X DMA mode enabled
	DAC_CR_DMAEN1_Enabled = 0x1
	// Position of MAMP1 field.
	DAC_CR_MAMP1_Pos = 0x8
	// Bit mask of MAMP1 field.
	DAC_CR_MAMP1_Msk = 0xf00
	// Position of WAVE1 field.
	DAC_CR_WAVE1_Pos = 0x6
	// Bit mask of WAVE1 field.
	DAC_CR_WAVE1_Msk = 0xc0
	// Wave generation disabled
	DAC_CR_WAVE1_Disabled = 0x0
	// Noise wave generation enabled
	DAC_CR_WAVE1_Noise = 0x1
	// Triangle wave generation enabled
	DAC_CR_WAVE1_Triangle = 0x2
	// Position of TSEL1 field.
	DAC_CR_TSEL1_Pos = 0x3
	// Bit mask of TSEL1 field.
	DAC_CR_TSEL1_Msk = 0x38
	// Timer 6 TRGO event
	DAC_CR_TSEL1_TIM6_TRGO = 0x0
	// Timer 3 TRGO event
	DAC_CR_TSEL1_TIM3_TRGO = 0x1
	// Timer 7 TRGO event
	DAC_CR_TSEL1_TIM7_TRGO = 0x2
	// Timer 15 TRGO event
	DAC_CR_TSEL1_TIM15_TRGO = 0x3
	// Timer 2 TRGO event
	DAC_CR_TSEL1_TIM2_TRGO = 0x4
	// EXTI line9
	DAC_CR_TSEL1_EXTI9 = 0x6
	// Software trigger
	DAC_CR_TSEL1_SOFTWARE = 0x7
	// Position of TEN1 field.
	DAC_CR_TEN1_Pos = 0x2
	// Bit mask of TEN1 field.
	DAC_CR_TEN1_Msk = 0x4
	// Bit TEN1.
	DAC_CR_TEN1 = 0x4
	// DAC channel X trigger disabled
	DAC_CR_TEN1_Disabled = 0x0
	// DAC channel X trigger enabled
	DAC_CR_TEN1_Enabled = 0x1
	// Position of BOFF1 field.
	DAC_CR_BOFF1_Pos = 0x1
	// Bit mask of BOFF1 field.
	DAC_CR_BOFF1_Msk = 0x2
	// Bit BOFF1.
	DAC_CR_BOFF1 = 0x2
	// DAC channel X output buffer enabled
	DAC_CR_BOFF1_Enabled = 0x0
	// DAC channel X output buffer disabled
	DAC_CR_BOFF1_Disabled = 0x1
	// Position of EN1 field.
	DAC_CR_EN1_Pos = 0x0
	// Bit mask of EN1 field.
	DAC_CR_EN1_Msk = 0x1
	// Bit EN1.
	DAC_CR_EN1 = 0x1
	// DAC channel X disabled
	DAC_CR_EN1_Disabled = 0x0
	// DAC channel X enabled
	DAC_CR_EN1_Enabled = 0x1

	// SWTRIGR: software trigger register
	// Position of SWTRIG2 field.
	DAC_SWTRIGR_SWTRIG2_Pos = 0x1
	// Bit mask of SWTRIG2 field.
	DAC_SWTRIGR_SWTRIG2_Msk = 0x2
	// Bit SWTRIG2.
	DAC_SWTRIGR_SWTRIG2 = 0x2
	// DAC channel X software trigger disabled
	DAC_SWTRIGR_SWTRIG2_Disabled = 0x0
	// DAC channel X software trigger enabled
	DAC_SWTRIGR_SWTRIG2_Enabled = 0x1
	// Position of SWTRIG1 field.
	DAC_SWTRIGR_SWTRIG1_Pos = 0x0
	// Bit mask of SWTRIG1 field.
	DAC_SWTRIGR_SWTRIG1_Msk = 0x1
	// Bit SWTRIG1.
	DAC_SWTRIGR_SWTRIG1 = 0x1
	// DAC channel X software trigger disabled
	DAC_SWTRIGR_SWTRIG1_Disabled = 0x0
	// DAC channel X software trigger enabled
	DAC_SWTRIGR_SWTRIG1_Enabled = 0x1

	// DHR12R1: channel1 12-bit right-aligned data holding register
	// Position of DACC1DHR field.
	DAC_DHR12R1_DACC1DHR_Pos = 0x0
	// Bit mask of DACC1DHR field.
	DAC_DHR12R1_DACC1DHR_Msk = 0xfff

	// DHR12L1: channel1 12-bit left aligned data holding register
	// Position of DACC1DHR field.
	DAC_DHR12L1_DACC1DHR_Pos = 0x4
	// Bit mask of DACC1DHR field.
	DAC_DHR12L1_DACC1DHR_Msk = 0xfff0

	// DHR8R1: channel1 8-bit right aligned data holding register
	// Position of DACC1DHR field.
	DAC_DHR8R1_DACC1DHR_Pos = 0x0
	// Bit mask of DACC1DHR field.
	DAC_DHR8R1_DACC1DHR_Msk = 0xff

	// DHR12R2: channel2 12-bit right aligned data holding register
	// Position of DACC2DHR field.
	DAC_DHR12R2_DACC2DHR_Pos = 0x0
	// Bit mask of DACC2DHR field.
	DAC_DHR12R2_DACC2DHR_Msk = 0xfff

	// DHR12L2: channel2 12-bit left aligned data holding register
	// Position of DACC2DHR field.
	DAC_DHR12L2_DACC2DHR_Pos = 0x4
	// Bit mask of DACC2DHR field.
	DAC_DHR12L2_DACC2DHR_Msk = 0xfff0

	// DHR8R2: channel2 8-bit right-aligned data holding register
	// Position of DACC2DHR field.
	DAC_DHR8R2_DACC2DHR_Pos = 0x0
	// Bit mask of DACC2DHR field.
	DAC_DHR8R2_DACC2DHR_Msk = 0xff

	// DHR12RD: Dual DAC 12-bit right-aligned data holding register
	// Position of DACC2DHR field.
	DAC_DHR12RD_DACC2DHR_Pos = 0x10
	// Bit mask of DACC2DHR field.
	DAC_DHR12RD_DACC2DHR_Msk = 0xfff0000
	// Position of DACC1DHR field.
	DAC_DHR12RD_DACC1DHR_Pos = 0x0
	// Bit mask of DACC1DHR field.
	DAC_DHR12RD_DACC1DHR_Msk = 0xfff

	// DHR12LD: DUAL DAC 12-bit left aligned data holding register
	// Position of DACC2DHR field.
	DAC_DHR12LD_DACC2DHR_Pos = 0x14
	// Bit mask of DACC2DHR field.
	DAC_DHR12LD_DACC2DHR_Msk = 0xfff00000
	// Position of DACC1DHR field.
	DAC_DHR12LD_DACC1DHR_Pos = 0x4
	// Bit mask of DACC1DHR field.
	DAC_DHR12LD_DACC1DHR_Msk = 0xfff0

	// DHR8RD: DUAL DAC 8-bit right aligned data holding register
	// Position of DACC2DHR field.
	DAC_DHR8RD_DACC2DHR_Pos = 0x8
	// Bit mask of DACC2DHR field.
	DAC_DHR8RD_DACC2DHR_Msk = 0xff00
	// Position of DACC1DHR field.
	DAC_DHR8RD_DACC1DHR_Pos = 0x0
	// Bit mask of DACC1DHR field.
	DAC_DHR8RD_DACC1DHR_Msk = 0xff

	// DOR1: channel1 data output register
	// Position of DACC1DOR field.
	DAC_DOR1_DACC1DOR_Pos = 0x0
	// Bit mask of DACC1DOR field.
	DAC_DOR1_DACC1DOR_Msk = 0xfff

	// DOR2: channel2 data output register
	// Position of DACC2DOR field.
	DAC_DOR2_DACC2DOR_Pos = 0x0
	// Bit mask of DACC2DOR field.
	DAC_DOR2_DACC2DOR_Msk = 0xfff

	// SR: status register
	// Position of DMAUDR2 field.
	DAC_SR_DMAUDR2_Pos = 0x1d
	// Bit mask of DMAUDR2 field.
	DAC_SR_DMAUDR2_Msk = 0x20000000
	// Bit DMAUDR2.
	DAC_SR_DMAUDR2 = 0x20000000
	// No DMA underrun error condition occurred for DAC channel X
	DAC_SR_DMAUDR2_NoUnderrun = 0x0
	// DMA underrun error condition occurred for DAC channel X
	DAC_SR_DMAUDR2_Underrun = 0x1
	// Position of DMAUDR1 field.
	DAC_SR_DMAUDR1_Pos = 0xd
	// Bit mask of DMAUDR1 field.
	DAC_SR_DMAUDR1_Msk = 0x2000
	// Bit DMAUDR1.
	DAC_SR_DMAUDR1 = 0x2000
	// No DMA underrun error condition occurred for DAC channel X
	DAC_SR_DMAUDR1_NoUnderrun = 0x0
	// DMA underrun error condition occurred for DAC channel X
	DAC_SR_DMAUDR1_Underrun = 0x1
)

// Bitfields for DBGMCU: Debug support
const (
	// IDCODE: MCU Device ID Code Register
	// Position of DEV_ID field.
	DBGMCU_IDCODE_DEV_ID_Pos = 0x0
	// Bit mask of DEV_ID field.
	DBGMCU_IDCODE_DEV_ID_Msk = 0xfff
	// Position of REV_ID field.
	DBGMCU_IDCODE_REV_ID_Pos = 0x10
	// Bit mask of REV_ID field.
	DBGMCU_IDCODE_REV_ID_Msk = 0xffff0000

	// CR: Debug MCU Configuration Register
	// Position of DBG_SLEEP field.
	DBGMCU_CR_DBG_SLEEP_Pos = 0x0
	// Bit mask of DBG_SLEEP field.
	DBGMCU_CR_DBG_SLEEP_Msk = 0x1
	// Bit DBG_SLEEP.
	DBGMCU_CR_DBG_SLEEP = 0x1
	// Position of DBG_STOP field.
	DBGMCU_CR_DBG_STOP_Pos = 0x1
	// Bit mask of DBG_STOP field.
	DBGMCU_CR_DBG_STOP_Msk = 0x2
	// Bit DBG_STOP.
	DBGMCU_CR_DBG_STOP = 0x2
	// Position of DBG_STANDBY field.
	DBGMCU_CR_DBG_STANDBY_Pos = 0x2
	// Bit mask of DBG_STANDBY field.
	DBGMCU_CR_DBG_STANDBY_Msk = 0x4
	// Bit DBG_STANDBY.
	DBGMCU_CR_DBG_STANDBY = 0x4
	// Position of TRACE_IOEN field.
	DBGMCU_CR_TRACE_IOEN_Pos = 0x5
	// Bit mask of TRACE_IOEN field.
	DBGMCU_CR_TRACE_IOEN_Msk = 0x20
	// Bit TRACE_IOEN.
	DBGMCU_CR_TRACE_IOEN = 0x20
	// Position of TRACE_MODE field.
	DBGMCU_CR_TRACE_MODE_Pos = 0x6
	// Bit mask of TRACE_MODE field.
	DBGMCU_CR_TRACE_MODE_Msk = 0xc0

	// APB1_FZ: APB Low Freeze Register
	// Position of DBG_TIM2_STOP field.
	DBGMCU_APB1_FZ_DBG_TIM2_STOP_Pos = 0x0
	// Bit mask of DBG_TIM2_STOP field.
	DBGMCU_APB1_FZ_DBG_TIM2_STOP_Msk = 0x1
	// Bit DBG_TIM2_STOP.
	DBGMCU_APB1_FZ_DBG_TIM2_STOP = 0x1
	// Position of DBG_TIM3_STOP field.
	DBGMCU_APB1_FZ_DBG_TIM3_STOP_Pos = 0x1
	// Bit mask of DBG_TIM3_STOP field.
	DBGMCU_APB1_FZ_DBG_TIM3_STOP_Msk = 0x2
	// Bit DBG_TIM3_STOP.
	DBGMCU_APB1_FZ_DBG_TIM3_STOP = 0x2
	// Position of DBG_TIM4_STOP field.
	DBGMCU_APB1_FZ_DBG_TIM4_STOP_Pos = 0x2
	// Bit mask of DBG_TIM4_STOP field.
	DBGMCU_APB1_FZ_DBG_TIM4_STOP_Msk = 0x4
	// Bit DBG_TIM4_STOP.
	DBGMCU_APB1_FZ_DBG_TIM4_STOP = 0x4
	// Position of DBG_TIM5_STOP field.
	DBGMCU_APB1_FZ_DBG_TIM5_STOP_Pos = 0x3
	// Bit mask of DBG_TIM5_STOP field.
	DBGMCU_APB1_FZ_DBG_TIM5_STOP_Msk = 0x8
	// Bit DBG_TIM5_STOP.
	DBGMCU_APB1_FZ_DBG_TIM5_STOP = 0x8
	// Position of DBG_TIM6_STOP field.
	DBGMCU_APB1_FZ_DBG_TIM6_STOP_Pos = 0x4
	// Bit mask of DBG_TIM6_STOP field.
	DBGMCU_APB1_FZ_DBG_TIM6_STOP_Msk = 0x10
	// Bit DBG_TIM6_STOP.
	DBGMCU_APB1_FZ_DBG_TIM6_STOP = 0x10
	// Position of DBG_TIM7_STOP field.
	DBGMCU_APB1_FZ_DBG_TIM7_STOP_Pos = 0x5
	// Bit mask of DBG_TIM7_STOP field.
	DBGMCU_APB1_FZ_DBG_TIM7_STOP_Msk = 0x20
	// Bit DBG_TIM7_STOP.
	DBGMCU_APB1_FZ_DBG_TIM7_STOP = 0x20
	// Position of DBG_TIM12_STOP field.
	DBGMCU_APB1_FZ_DBG_TIM12_STOP_Pos = 0x6
	// Bit mask of DBG_TIM12_STOP field.
	DBGMCU_APB1_FZ_DBG_TIM12_STOP_Msk = 0x40
	// Bit DBG_TIM12_STOP.
	DBGMCU_APB1_FZ_DBG_TIM12_STOP = 0x40
	// Position of DBG_TIM13_STOP field.
	DBGMCU_APB1_FZ_DBG_TIM13_STOP_Pos = 0x7
	// Bit mask of DBG_TIM13_STOP field.
	DBGMCU_APB1_FZ_DBG_TIM13_STOP_Msk = 0x80
	// Bit DBG_TIM13_STOP.
	DBGMCU_APB1_FZ_DBG_TIM13_STOP = 0x80
	// Position of DBG_TIMER14_STOP field.
	DBGMCU_APB1_FZ_DBG_TIMER14_STOP_Pos = 0x8
	// Bit mask of DBG_TIMER14_STOP field.
	DBGMCU_APB1_FZ_DBG_TIMER14_STOP_Msk = 0x100
	// Bit DBG_TIMER14_STOP.
	DBGMCU_APB1_FZ_DBG_TIMER14_STOP = 0x100
	// Position of DBG_TIM18_STOP field.
	DBGMCU_APB1_FZ_DBG_TIM18_STOP_Pos = 0x9
	// Bit mask of DBG_TIM18_STOP field.
	DBGMCU_APB1_FZ_DBG_TIM18_STOP_Msk = 0x200
	// Bit DBG_TIM18_STOP.
	DBGMCU_APB1_FZ_DBG_TIM18_STOP = 0x200
	// Position of DBG_RTC_STOP field.
	DBGMCU_APB1_FZ_DBG_RTC_STOP_Pos = 0xa
	// Bit mask of DBG_RTC_STOP field.
	DBGMCU_APB1_FZ_DBG_RTC_STOP_Msk = 0x400
	// Bit DBG_RTC_STOP.
	DBGMCU_APB1_FZ_DBG_RTC_STOP = 0x400
	// Position of DBG_WWDG_STOP field.
	DBGMCU_APB1_FZ_DBG_WWDG_STOP_Pos = 0xb
	// Bit mask of DBG_WWDG_STOP field.
	DBGMCU_APB1_FZ_DBG_WWDG_STOP_Msk = 0x800
	// Bit DBG_WWDG_STOP.
	DBGMCU_APB1_FZ_DBG_WWDG_STOP = 0x800
	// Position of DBG_IWDG_STOP field.
	DBGMCU_APB1_FZ_DBG_IWDG_STOP_Pos = 0xc
	// Bit mask of DBG_IWDG_STOP field.
	DBGMCU_APB1_FZ_DBG_IWDG_STOP_Msk = 0x1000
	// Bit DBG_IWDG_STOP.
	DBGMCU_APB1_FZ_DBG_IWDG_STOP = 0x1000
	// Position of I2C1_SMBUS_TIMEOUT field.
	DBGMCU_APB1_FZ_I2C1_SMBUS_TIMEOUT_Pos = 0x15
	// Bit mask of I2C1_SMBUS_TIMEOUT field.
	DBGMCU_APB1_FZ_I2C1_SMBUS_TIMEOUT_Msk = 0x200000
	// Bit I2C1_SMBUS_TIMEOUT.
	DBGMCU_APB1_FZ_I2C1_SMBUS_TIMEOUT = 0x200000
	// Position of I2C2_SMBUS_TIMEOUT field.
	DBGMCU_APB1_FZ_I2C2_SMBUS_TIMEOUT_Pos = 0x16
	// Bit mask of I2C2_SMBUS_TIMEOUT field.
	DBGMCU_APB1_FZ_I2C2_SMBUS_TIMEOUT_Msk = 0x400000
	// Bit I2C2_SMBUS_TIMEOUT.
	DBGMCU_APB1_FZ_I2C2_SMBUS_TIMEOUT = 0x400000
	// Position of DBG_CAN_STOP field.
	DBGMCU_APB1_FZ_DBG_CAN_STOP_Pos = 0x19
	// Bit mask of DBG_CAN_STOP field.
	DBGMCU_APB1_FZ_DBG_CAN_STOP_Msk = 0x2000000
	// Bit DBG_CAN_STOP.
	DBGMCU_APB1_FZ_DBG_CAN_STOP = 0x2000000

	// APB2FZ: APB High Freeze Register
	// Position of DBG_TIM15_STOP field.
	DBGMCU_APB2FZ_DBG_TIM15_STOP_Pos = 0x2
	// Bit mask of DBG_TIM15_STOP field.
	DBGMCU_APB2FZ_DBG_TIM15_STOP_Msk = 0x4
	// Bit DBG_TIM15_STOP.
	DBGMCU_APB2FZ_DBG_TIM15_STOP = 0x4
	// Position of DBG_TIM16_STOP field.
	DBGMCU_APB2FZ_DBG_TIM16_STOP_Pos = 0x3
	// Bit mask of DBG_TIM16_STOP field.
	DBGMCU_APB2FZ_DBG_TIM16_STOP_Msk = 0x8
	// Bit DBG_TIM16_STOP.
	DBGMCU_APB2FZ_DBG_TIM16_STOP = 0x8
	// Position of DBG_TIM17_STO field.
	DBGMCU_APB2FZ_DBG_TIM17_STO_Pos = 0x4
	// Bit mask of DBG_TIM17_STO field.
	DBGMCU_APB2FZ_DBG_TIM17_STO_Msk = 0x10
	// Bit DBG_TIM17_STO.
	DBGMCU_APB2FZ_DBG_TIM17_STO = 0x10
	// Position of DBG_TIM19_STOP field.
	DBGMCU_APB2FZ_DBG_TIM19_STOP_Pos = 0x5
	// Bit mask of DBG_TIM19_STOP field.
	DBGMCU_APB2FZ_DBG_TIM19_STOP_Msk = 0x20
	// Bit DBG_TIM19_STOP.
	DBGMCU_APB2FZ_DBG_TIM19_STOP = 0x20
)

// Bitfields for ADC1: Analog-to-Digital Converter
const (
	// ISR: interrupt and status register
	// Position of JQOVF field.
	ADC_ISR_JQOVF_Pos = 0xa
	// Bit mask of JQOVF field.
	ADC_ISR_JQOVF_Msk = 0x400
	// Bit JQOVF.
	ADC_ISR_JQOVF = 0x400
	// No injected context queue overflow has occurred
	ADC_ISR_JQOVF_NoOverflow = 0x0
	// Injected context queue overflow has occurred
	ADC_ISR_JQOVF_Overflow = 0x1
	// Clear injected context queue overflow flag
	ADC_ISR_JQOVF_Clear = 0x1
	// Position of AWD3 field.
	ADC_ISR_AWD3_Pos = 0x9
	// Bit mask of AWD3 field.
	ADC_ISR_AWD3_Msk = 0x200
	// Bit AWD3.
	ADC_ISR_AWD3 = 0x200
	// No analog watchdog event occurred
	ADC_ISR_AWD3_NoEvent = 0x0
	// Analog watchdog event occurred
	ADC_ISR_AWD3_Event = 0x1
	// Clear analog watchdog event occurred flag
	ADC_ISR_AWD3_Clear = 0x1
	// Position of AWD2 field.
	ADC_ISR_AWD2_Pos = 0x8
	// Bit mask of AWD2 field.
	ADC_ISR_AWD2_Msk = 0x100
	// Bit AWD2.
	ADC_ISR_AWD2 = 0x100
	// No analog watchdog event occurred
	ADC_ISR_AWD2_NoEvent = 0x0
	// Analog watchdog event occurred
	ADC_ISR_AWD2_Event = 0x1
	// Clear analog watchdog event occurred flag
	ADC_ISR_AWD2_Clear = 0x1
	// Position of AWD1 field.
	ADC_ISR_AWD1_Pos = 0x7
	// Bit mask of AWD1 field.
	ADC_ISR_AWD1_Msk = 0x80
	// Bit AWD1.
	ADC_ISR_AWD1 = 0x80
	// No analog watchdog event occurred
	ADC_ISR_AWD1_NoEvent = 0x0
	// Analog watchdog event occurred
	ADC_ISR_AWD1_Event = 0x1
	// Clear analog watchdog event occurred flag
	ADC_ISR_AWD1_Clear = 0x1
	// Position of JEOS field.
	ADC_ISR_JEOS_Pos = 0x6
	// Bit mask of JEOS field.
	ADC_ISR_JEOS_Msk = 0x40
	// Bit JEOS.
	ADC_ISR_JEOS = 0x40
	// Injected sequence is not complete
	ADC_ISR_JEOS_NotComplete = 0x0
	// Injected sequence complete
	ADC_ISR_JEOS_Complete = 0x1
	// Clear Injected sequence complete flag
	ADC_ISR_JEOS_Clear = 0x1
	// Position of JEOC field.
	ADC_ISR_JEOC_Pos = 0x5
	// Bit mask of JEOC field.
	ADC_ISR_JEOC_Msk = 0x20
	// Bit JEOC.
	ADC_ISR_JEOC = 0x20
	// Injected conversion is not complete
	ADC_ISR_JEOC_NotComplete = 0x0
	// Injected conversion complete
	ADC_ISR_JEOC_Complete = 0x1
	// Clear injected conversion complete flag
	ADC_ISR_JEOC_Clear = 0x1
	// Position of OVR field.
	ADC_ISR_OVR_Pos = 0x4
	// Bit mask of OVR field.
	ADC_ISR_OVR_Msk = 0x10
	// Bit OVR.
	ADC_ISR_OVR = 0x10
	// No overrun occurred
	ADC_ISR_OVR_NoOverrun = 0x0
	// Overrun occurred
	ADC_ISR_OVR_Overrun = 0x1
	// Clear overrun occurred flag
	ADC_ISR_OVR_Clear = 0x1
	// Position of EOS field.
	ADC_ISR_EOS_Pos = 0x3
	// Bit mask of EOS field.
	ADC_ISR_EOS_Msk = 0x8
	// Bit EOS.
	ADC_ISR_EOS = 0x8
	// Regular sequence is not complete
	ADC_ISR_EOS_NotComplete = 0x0
	// Regular sequence complete
	ADC_ISR_EOS_Complete = 0x1
	// Clear regular sequence complete flag
	ADC_ISR_EOS_Clear = 0x1
	// Position of EOC field.
	ADC_ISR_EOC_Pos = 0x2
	// Bit mask of EOC field.
	ADC_ISR_EOC_Msk = 0x4
	// Bit EOC.
	ADC_ISR_EOC = 0x4
	// Regular conversion is not complete
	ADC_ISR_EOC_NotComplete = 0x0
	// Regular conversion complete
	ADC_ISR_EOC_Complete = 0x1
	// Clear regular conversion complete flag
	ADC_ISR_EOC_Clear = 0x1
	// Position of EOSMP field.
	ADC_ISR_EOSMP_Pos = 0x1
	// Bit mask of EOSMP field.
	ADC_ISR_EOSMP_Msk = 0x2
	// Bit EOSMP.
	ADC_ISR_EOSMP = 0x2
	// End of sampling phase no yet reached
	ADC_ISR_EOSMP_NotEnded = 0x0
	// End of sampling phase reached
	ADC_ISR_EOSMP_Ended = 0x1
	// Clear end of sampling phase reached flag
	ADC_ISR_EOSMP_Clear = 0x1
	// Position of ADRDY field.
	ADC_ISR_ADRDY_Pos = 0x0
	// Bit mask of ADRDY field.
	ADC_ISR_ADRDY_Msk = 0x1
	// Bit ADRDY.
	ADC_ISR_ADRDY = 0x1
	// ADC is not ready to start conversion
	ADC_ISR_ADRDY_NotReady = 0x0
	// ADC is ready to start conversion
	ADC_ISR_ADRDY_Ready = 0x1
	// Clear ADC is ready to start conversion flag
	ADC_ISR_ADRDY_Clear = 0x1

	// IER: interrupt enable register
	// Position of JQOVFIE field.
	ADC_IER_JQOVFIE_Pos = 0xa
	// Bit mask of JQOVFIE field.
	ADC_IER_JQOVFIE_Msk = 0x400
	// Bit JQOVFIE.
	ADC_IER_JQOVFIE = 0x400
	// Injected context queue overflow interrupt disabled
	ADC_IER_JQOVFIE_Disabled = 0x0
	// Injected context queue overflow interrupt enabled
	ADC_IER_JQOVFIE_Enabled = 0x1
	// Position of AWD3IE field.
	ADC_IER_AWD3IE_Pos = 0x9
	// Bit mask of AWD3IE field.
	ADC_IER_AWD3IE_Msk = 0x200
	// Bit AWD3IE.
	ADC_IER_AWD3IE = 0x200
	// Analog watchdog interrupt disabled
	ADC_IER_AWD3IE_Disabled = 0x0
	// Analog watchdog interrupt enabled
	ADC_IER_AWD3IE_Enabled = 0x1
	// Position of AWD2IE field.
	ADC_IER_AWD2IE_Pos = 0x8
	// Bit mask of AWD2IE field.
	ADC_IER_AWD2IE_Msk = 0x100
	// Bit AWD2IE.
	ADC_IER_AWD2IE = 0x100
	// Analog watchdog interrupt disabled
	ADC_IER_AWD2IE_Disabled = 0x0
	// Analog watchdog interrupt enabled
	ADC_IER_AWD2IE_Enabled = 0x1
	// Position of AWD1IE field.
	ADC_IER_AWD1IE_Pos = 0x7
	// Bit mask of AWD1IE field.
	ADC_IER_AWD1IE_Msk = 0x80
	// Bit AWD1IE.
	ADC_IER_AWD1IE = 0x80
	// Analog watchdog interrupt disabled
	ADC_IER_AWD1IE_Disabled = 0x0
	// Analog watchdog interrupt enabled
	ADC_IER_AWD1IE_Enabled = 0x1
	// Position of JEOSIE field.
	ADC_IER_JEOSIE_Pos = 0x6
	// Bit mask of JEOSIE field.
	ADC_IER_JEOSIE_Msk = 0x40
	// Bit JEOSIE.
	ADC_IER_JEOSIE = 0x40
	// End of injected sequence interrupt disabled
	ADC_IER_JEOSIE_Disabled = 0x0
	// End of injected sequence interrupt enabled
	ADC_IER_JEOSIE_Enabled = 0x1
	// Position of JEOCIE field.
	ADC_IER_JEOCIE_Pos = 0x5
	// Bit mask of JEOCIE field.
	ADC_IER_JEOCIE_Msk = 0x20
	// Bit JEOCIE.
	ADC_IER_JEOCIE = 0x20
	// End of injected conversion interrupt disabled
	ADC_IER_JEOCIE_Disabled = 0x0
	// End of injected conversion interrupt enabled
	ADC_IER_JEOCIE_Enabled = 0x1
	// Position of OVRIE field.
	ADC_IER_OVRIE_Pos = 0x4
	// Bit mask of OVRIE field.
	ADC_IER_OVRIE_Msk = 0x10
	// Bit OVRIE.
	ADC_IER_OVRIE = 0x10
	// Overrun interrupt disabled
	ADC_IER_OVRIE_Disabled = 0x0
	// Overrun interrupt enabled
	ADC_IER_OVRIE_Enabled = 0x1
	// Position of EOSIE field.
	ADC_IER_EOSIE_Pos = 0x3
	// Bit mask of EOSIE field.
	ADC_IER_EOSIE_Msk = 0x8
	// Bit EOSIE.
	ADC_IER_EOSIE = 0x8
	// End of regular sequence interrupt disabled
	ADC_IER_EOSIE_Disabled = 0x0
	// End of regular sequence interrupt enabled
	ADC_IER_EOSIE_Enabled = 0x1
	// Position of EOCIE field.
	ADC_IER_EOCIE_Pos = 0x2
	// Bit mask of EOCIE field.
	ADC_IER_EOCIE_Msk = 0x4
	// Bit EOCIE.
	ADC_IER_EOCIE = 0x4
	// End of regular conversion interrupt disabled
	ADC_IER_EOCIE_Disabled = 0x0
	// End of regular conversion interrupt enabled
	ADC_IER_EOCIE_Enabled = 0x1
	// Position of EOSMPIE field.
	ADC_IER_EOSMPIE_Pos = 0x1
	// Bit mask of EOSMPIE field.
	ADC_IER_EOSMPIE_Msk = 0x2
	// Bit EOSMPIE.
	ADC_IER_EOSMPIE = 0x2
	// End of regular conversion sampling phase interrupt disabled
	ADC_IER_EOSMPIE_Disabled = 0x0
	// End of regular conversion sampling phase interrupt enabled
	ADC_IER_EOSMPIE_Enabled = 0x1
	// Position of ADRDYIE field.
	ADC_IER_ADRDYIE_Pos = 0x0
	// Bit mask of ADRDYIE field.
	ADC_IER_ADRDYIE_Msk = 0x1
	// Bit ADRDYIE.
	ADC_IER_ADRDYIE = 0x1
	// ADC ready interrupt disabled
	ADC_IER_ADRDYIE_Disabled = 0x0
	// ADC ready interrupt enabled
	ADC_IER_ADRDYIE_Enabled = 0x1

	// CR: control register
	// Position of ADCAL field.
	ADC_CR_ADCAL_Pos = 0x1f
	// Bit mask of ADCAL field.
	ADC_CR_ADCAL_Msk = 0x80000000
	// Bit ADCAL.
	ADC_CR_ADCAL = 0x80000000
	// Calibration complete
	ADC_CR_ADCAL_Complete = 0x0
	// Start the calibration of the ADC
	ADC_CR_ADCAL_Calibration = 0x1
	// Position of ADCALDIF field.
	ADC_CR_ADCALDIF_Pos = 0x1e
	// Bit mask of ADCALDIF field.
	ADC_CR_ADCALDIF_Msk = 0x40000000
	// Bit ADCALDIF.
	ADC_CR_ADCALDIF = 0x40000000
	// Calibration for single-ended mode
	ADC_CR_ADCALDIF_SingleEnded = 0x0
	// Calibration for differential mode
	ADC_CR_ADCALDIF_Differential = 0x1
	// Position of ADVREGEN field.
	ADC_CR_ADVREGEN_Pos = 0x1c
	// Bit mask of ADVREGEN field.
	ADC_CR_ADVREGEN_Msk = 0x30000000
	// Intermediate state required when moving the ADC voltage regulator between states
	ADC_CR_ADVREGEN_Intermediate = 0x0
	// ADC voltage regulator enabled
	ADC_CR_ADVREGEN_Enabled = 0x1
	// ADC voltage regulator disabled
	ADC_CR_ADVREGEN_Disabled = 0x2
	// Position of JADSTP field.
	ADC_CR_JADSTP_Pos = 0x5
	// Bit mask of JADSTP field.
	ADC_CR_JADSTP_Msk = 0x20
	// Bit JADSTP.
	ADC_CR_JADSTP = 0x20
	// Stop conversion of channel
	ADC_CR_JADSTP_Stop = 0x1
	// Position of ADSTP field.
	ADC_CR_ADSTP_Pos = 0x4
	// Bit mask of ADSTP field.
	ADC_CR_ADSTP_Msk = 0x10
	// Bit ADSTP.
	ADC_CR_ADSTP = 0x10
	// Stop conversion of channel
	ADC_CR_ADSTP_Stop = 0x1
	// Position of JADSTART field.
	ADC_CR_JADSTART_Pos = 0x3
	// Bit mask of JADSTART field.
	ADC_CR_JADSTART_Msk = 0x8
	// Bit JADSTART.
	ADC_CR_JADSTART = 0x8
	// Starts conversion of channel
	ADC_CR_JADSTART_Start = 0x1
	// Position of ADSTART field.
	ADC_CR_ADSTART_Pos = 0x2
	// Bit mask of ADSTART field.
	ADC_CR_ADSTART_Msk = 0x4
	// Bit ADSTART.
	ADC_CR_ADSTART = 0x4
	// Starts conversion of channel
	ADC_CR_ADSTART_Start = 0x1
	// Position of ADDIS field.
	ADC_CR_ADDIS_Pos = 0x1
	// Bit mask of ADDIS field.
	ADC_CR_ADDIS_Msk = 0x2
	// Bit ADDIS.
	ADC_CR_ADDIS = 0x2
	// Disable ADC conversion and go to power down mode
	ADC_CR_ADDIS_Disable = 0x0
	// Position of ADEN field.
	ADC_CR_ADEN_Pos = 0x0
	// Bit mask of ADEN field.
	ADC_CR_ADEN_Msk = 0x1
	// Bit ADEN.
	ADC_CR_ADEN = 0x1
	// Enable ADC
	ADC_CR_ADEN_Enable = 0x1

	// CFGR: configuration register
	// Position of AWD1CH field.
	ADC_CFGR_AWD1CH_Pos = 0x1a
	// Bit mask of AWD1CH field.
	ADC_CFGR_AWD1CH_Msk = 0x7c000000
	// Position of JAUTO field.
	ADC_CFGR_JAUTO_Pos = 0x19
	// Bit mask of JAUTO field.
	ADC_CFGR_JAUTO_Msk = 0x2000000
	// Bit JAUTO.
	ADC_CFGR_JAUTO = 0x2000000
	// Automatic injected group conversion disabled
	ADC_CFGR_JAUTO_Disabled = 0x0
	// Automatic injected group conversion enabled
	ADC_CFGR_JAUTO_Enabled = 0x1
	// Position of JAWD1EN field.
	ADC_CFGR_JAWD1EN_Pos = 0x18
	// Bit mask of JAWD1EN field.
	ADC_CFGR_JAWD1EN_Msk = 0x1000000
	// Bit JAWD1EN.
	ADC_CFGR_JAWD1EN = 0x1000000
	// Analog watchdog 1 disabled on injected channels
	ADC_CFGR_JAWD1EN_Disabled = 0x0
	// Analog watchdog 1 enabled on injected channels
	ADC_CFGR_JAWD1EN_Enabled = 0x1
	// Position of AWD1EN field.
	ADC_CFGR_AWD1EN_Pos = 0x17
	// Bit mask of AWD1EN field.
	ADC_CFGR_AWD1EN_Msk = 0x800000
	// Bit AWD1EN.
	ADC_CFGR_AWD1EN = 0x800000
	// Analog watchdog 1 disabled on regular channels
	ADC_CFGR_AWD1EN_Disabled = 0x0
	// Analog watchdog 1 enabled on regular channels
	ADC_CFGR_AWD1EN_Enabled = 0x1
	// Position of AWD1SGL field.
	ADC_CFGR_AWD1SGL_Pos = 0x16
	// Bit mask of AWD1SGL field.
	ADC_CFGR_AWD1SGL_Msk = 0x400000
	// Bit AWD1SGL.
	ADC_CFGR_AWD1SGL = 0x400000
	// Analog watchdog 1 enabled on all channels
	ADC_CFGR_AWD1SGL_All = 0x0
	// Analog watchdog 1 enabled on single channel selected in AWD1CH
	ADC_CFGR_AWD1SGL_Single = 0x1
	// Position of JQM field.
	ADC_CFGR_JQM_Pos = 0x15
	// Bit mask of JQM field.
	ADC_CFGR_JQM_Msk = 0x200000
	// Bit JQM.
	ADC_CFGR_JQM = 0x200000
	// JSQR Mode 0: Queue maintains the last written configuration into JSQR
	ADC_CFGR_JQM_Mode0 = 0x0
	// JSQR Mode 1: An empty queue disables software and hardware triggers of the injected sequence
	ADC_CFGR_JQM_Mode1 = 0x1
	// Position of JDISCEN field.
	ADC_CFGR_JDISCEN_Pos = 0x14
	// Bit mask of JDISCEN field.
	ADC_CFGR_JDISCEN_Msk = 0x100000
	// Bit JDISCEN.
	ADC_CFGR_JDISCEN = 0x100000
	// Discontinuous mode on injected channels disabled
	ADC_CFGR_JDISCEN_Disabled = 0x0
	// Discontinuous mode on injected channels enabled
	ADC_CFGR_JDISCEN_Enabled = 0x1
	// Position of DISCNUM field.
	ADC_CFGR_DISCNUM_Pos = 0x11
	// Bit mask of DISCNUM field.
	ADC_CFGR_DISCNUM_Msk = 0xe0000
	// Position of DISCEN field.
	ADC_CFGR_DISCEN_Pos = 0x10
	// Bit mask of DISCEN field.
	ADC_CFGR_DISCEN_Msk = 0x10000
	// Bit DISCEN.
	ADC_CFGR_DISCEN = 0x10000
	// Discontinuous mode on regular channels disabled
	ADC_CFGR_DISCEN_Disabled = 0x0
	// Discontinuous mode on regular channels enabled
	ADC_CFGR_DISCEN_Enabled = 0x1
	// Position of AUTDLY field.
	ADC_CFGR_AUTDLY_Pos = 0xe
	// Bit mask of AUTDLY field.
	ADC_CFGR_AUTDLY_Msk = 0x4000
	// Bit AUTDLY.
	ADC_CFGR_AUTDLY = 0x4000
	// Auto delayed conversion mode off
	ADC_CFGR_AUTDLY_Off = 0x0
	// Auto delayed conversion mode on
	ADC_CFGR_AUTDLY_On = 0x1
	// Position of CONT field.
	ADC_CFGR_CONT_Pos = 0xd
	// Bit mask of CONT field.
	ADC_CFGR_CONT_Msk = 0x2000
	// Bit CONT.
	ADC_CFGR_CONT = 0x2000
	// Single conversion mode
	ADC_CFGR_CONT_Single = 0x0
	// Continuous conversion mode
	ADC_CFGR_CONT_Continuous = 0x1
	// Position of OVRMOD field.
	ADC_CFGR_OVRMOD_Pos = 0xc
	// Bit mask of OVRMOD field.
	ADC_CFGR_OVRMOD_Msk = 0x1000
	// Bit OVRMOD.
	ADC_CFGR_OVRMOD = 0x1000
	// Preserve DR register when an overrun is detected
	ADC_CFGR_OVRMOD_Preserve = 0x0
	// Overwrite DR register when an overrun is detected
	ADC_CFGR_OVRMOD_Overwrite = 0x1
	// Position of EXTEN field.
	ADC_CFGR_EXTEN_Pos = 0xa
	// Bit mask of EXTEN field.
	ADC_CFGR_EXTEN_Msk = 0xc00
	// Trigger detection disabled
	ADC_CFGR_EXTEN_Disabled = 0x0
	// Trigger detection on the rising edge
	ADC_CFGR_EXTEN_RisingEdge = 0x1
	// Trigger detection on the falling edge
	ADC_CFGR_EXTEN_FallingEdge = 0x2
	// Trigger detection on both the rising and falling edges
	ADC_CFGR_EXTEN_BothEdges = 0x3
	// Position of EXTSEL field.
	ADC_CFGR_EXTSEL_Pos = 0x6
	// Bit mask of EXTSEL field.
	ADC_CFGR_EXTSEL_Msk = 0x3c0
	// HRTIM_ADCTRG1 event
	ADC_CFGR_EXTSEL_HRTIM_ADCTRG1 = 0x7
	// HRTIM_ADCTRG3 event
	ADC_CFGR_EXTSEL_HRTIM_ADCTRG3 = 0x8
	// Timer 1 CC1 event
	ADC_CFGR_EXTSEL_TIM1_CC1 = 0x0
	// Timer 1 CC2 event
	ADC_CFGR_EXTSEL_TIM1_CC2 = 0x1
	// Timer 1 CC3 event
	ADC_CFGR_EXTSEL_TIM1_CC3 = 0x2
	// Timer 2 CC2 event
	ADC_CFGR_EXTSEL_TIM2_CC2 = 0x3
	// Timer 3 TRGO event
	ADC_CFGR_EXTSEL_TIM3_TRGO = 0x4
	// EXTI line 11
	ADC_CFGR_EXTSEL_EXTI11 = 0x6
	// Timer 1 TRGO event
	ADC_CFGR_EXTSEL_TIM1_TRGO = 0x9
	// Timer 1 TRGO2 event
	ADC_CFGR_EXTSEL_TIM1_TRGO2 = 0xa
	// Timer 2 TRGO event
	ADC_CFGR_EXTSEL_TIM2_TRGO = 0xb
	// Timer 6 TRGO event
	ADC_CFGR_EXTSEL_TIM6_TRGO = 0xd
	// Timer 15 TRGO event
	ADC_CFGR_EXTSEL_TIM15_TRGO = 0xe
	// Timer 3 CC4 event
	ADC_CFGR_EXTSEL_TIM3_CC4 = 0xf
	// Position of ALIGN field.
	ADC_CFGR_ALIGN_Pos = 0x5
	// Bit mask of ALIGN field.
	ADC_CFGR_ALIGN_Msk = 0x20
	// Bit ALIGN.
	ADC_CFGR_ALIGN = 0x20
	// Right alignment
	ADC_CFGR_ALIGN_Right = 0x0
	// Left alignment
	ADC_CFGR_ALIGN_Left = 0x1
	// Position of RES field.
	ADC_CFGR_RES_Pos = 0x3
	// Bit mask of RES field.
	ADC_CFGR_RES_Msk = 0x18
	// 12-bit
	ADC_CFGR_RES_Bits12 = 0x0
	// 10-bit
	ADC_CFGR_RES_Bits10 = 0x1
	// 8-bit
	ADC_CFGR_RES_Bits8 = 0x2
	// 6-bit
	ADC_CFGR_RES_Bits6 = 0x3
	// Position of DMACFG field.
	ADC_CFGR_DMACFG_Pos = 0x1
	// Bit mask of DMACFG field.
	ADC_CFGR_DMACFG_Msk = 0x2
	// Bit DMACFG.
	ADC_CFGR_DMACFG = 0x2
	// DMA One Shot Mode selected
	ADC_CFGR_DMACFG_OneShot = 0x0
	// DMA circular mode selected
	ADC_CFGR_DMACFG_Circular = 0x1
	// Position of DMAEN field.
	ADC_CFGR_DMAEN_Pos = 0x0
	// Bit mask of DMAEN field.
	ADC_CFGR_DMAEN_Msk = 0x1
	// Bit DMAEN.
	ADC_CFGR_DMAEN = 0x1
	// DMA disabled
	ADC_CFGR_DMAEN_Disabled = 0x0
	// DMA enabled
	ADC_CFGR_DMAEN_Enabled = 0x1

	// SMPR1: sample time register 1
	// Position of SMP9 field.
	ADC_SMPR1_SMP9_Pos = 0x1b
	// Bit mask of SMP9 field.
	ADC_SMPR1_SMP9_Msk = 0x38000000
	// 1.5 ADC clock cycles
	ADC_SMPR1_SMP9_Cycles1_5 = 0x0
	// 2.5 ADC clock cycles
	ADC_SMPR1_SMP9_Cycles2_5 = 0x1
	// 4.5 ADC clock cycles
	ADC_SMPR1_SMP9_Cycles4_5 = 0x2
	// 7.5 ADC clock cycles
	ADC_SMPR1_SMP9_Cycles7_5 = 0x3
	// 19.5 ADC clock cycles
	ADC_SMPR1_SMP9_Cycles19_5 = 0x4
	// 61.5 ADC clock cycles
	ADC_SMPR1_SMP9_Cycles61_5 = 0x5
	// 181.5 ADC clock cycles
	ADC_SMPR1_SMP9_Cycles181_5 = 0x6
	// 601.5 ADC clock cycles
	ADC_SMPR1_SMP9_Cycles601_5 = 0x7
	// Position of SMP8 field.
	ADC_SMPR1_SMP8_Pos = 0x18
	// Bit mask of SMP8 field.
	ADC_SMPR1_SMP8_Msk = 0x7000000
	// 1.5 ADC clock cycles
	ADC_SMPR1_SMP8_Cycles1_5 = 0x0
	// 2.5 ADC clock cycles
	ADC_SMPR1_SMP8_Cycles2_5 = 0x1
	// 4.5 ADC clock cycles
	ADC_SMPR1_SMP8_Cycles4_5 = 0x2
	// 7.5 ADC clock cycles
	ADC_SMPR1_SMP8_Cycles7_5 = 0x3
	// 19.5 ADC clock cycles
	ADC_SMPR1_SMP8_Cycles19_5 = 0x4
	// 61.5 ADC clock cycles
	ADC_SMPR1_SMP8_Cycles61_5 = 0x5
	// 181.5 ADC clock cycles
	ADC_SMPR1_SMP8_Cycles181_5 = 0x6
	// 601.5 ADC clock cycles
	ADC_SMPR1_SMP8_Cycles601_5 = 0x7
	// Position of SMP7 field.
	ADC_SMPR1_SMP7_Pos = 0x15
	// Bit mask of SMP7 field.
	ADC_SMPR1_SMP7_Msk = 0xe00000
	// 1.5 ADC clock cycles
	ADC_SMPR1_SMP7_Cycles1_5 = 0x0
	// 2.5 ADC clock cycles
	ADC_SMPR1_SMP7_Cycles2_5 = 0x1
	// 4.5 ADC clock cycles
	ADC_SMPR1_SMP7_Cycles4_5 = 0x2
	// 7.5 ADC clock cycles
	ADC_SMPR1_SMP7_Cycles7_5 = 0x3
	// 19.5 ADC clock cycles
	ADC_SMPR1_SMP7_Cycles19_5 = 0x4
	// 61.5 ADC clock cycles
	ADC_SMPR1_SMP7_Cycles61_5 = 0x5
	// 181.5 ADC clock cycles
	ADC_SMPR1_SMP7_Cycles181_5 = 0x6
	// 601.5 ADC clock cycles
	ADC_SMPR1_SMP7_Cycles601_5 = 0x7
	// Position of SMP6 field.
	ADC_SMPR1_SMP6_Pos = 0x12
	// Bit mask of SMP6 field.
	ADC_SMPR1_SMP6_Msk = 0x1c0000
	// 1.5 ADC clock cycles
	ADC_SMPR1_SMP6_Cycles1_5 = 0x0
	// 2.5 ADC clock cycles
	ADC_SMPR1_SMP6_Cycles2_5 = 0x1
	// 4.5 ADC clock cycles
	ADC_SMPR1_SMP6_Cycles4_5 = 0x2
	// 7.5 ADC clock cycles
	ADC_SMPR1_SMP6_Cycles7_5 = 0x3
	// 19.5 ADC clock cycles
	ADC_SMPR1_SMP6_Cycles19_5 = 0x4
	// 61.5 ADC clock cycles
	ADC_SMPR1_SMP6_Cycles61_5 = 0x5
	// 181.5 ADC clock cycles
	ADC_SMPR1_SMP6_Cycles181_5 = 0x6
	// 601.5 ADC clock cycles
	ADC_SMPR1_SMP6_Cycles601_5 = 0x7
	// Position of SMP5 field.
	ADC_SMPR1_SMP5_Pos = 0xf
	// Bit mask of SMP5 field.
	ADC_SMPR1_SMP5_Msk = 0x38000
	// 1.5 ADC clock cycles
	ADC_SMPR1_SMP5_Cycles1_5 = 0x0
	// 2.5 ADC clock cycles
	ADC_SMPR1_SMP5_Cycles2_5 = 0x1
	// 4.5 ADC clock cycles
	ADC_SMPR1_SMP5_Cycles4_5 = 0x2
	// 7.5 ADC clock cycles
	ADC_SMPR1_SMP5_Cycles7_5 = 0x3
	// 19.5 ADC clock cycles
	ADC_SMPR1_SMP5_Cycles19_5 = 0x4
	// 61.5 ADC clock cycles
	ADC_SMPR1_SMP5_Cycles61_5 = 0x5
	// 181.5 ADC clock cycles
	ADC_SMPR1_SMP5_Cycles181_5 = 0x6
	// 601.5 ADC clock cycles
	ADC_SMPR1_SMP5_Cycles601_5 = 0x7
	// Position of SMP4 field.
	ADC_SMPR1_SMP4_Pos = 0xc
	// Bit mask of SMP4 field.
	ADC_SMPR1_SMP4_Msk = 0x7000
	// 1.5 ADC clock cycles
	ADC_SMPR1_SMP4_Cycles1_5 = 0x0
	// 2.5 ADC clock cycles
	ADC_SMPR1_SMP4_Cycles2_5 = 0x1
	// 4.5 ADC clock cycles
	ADC_SMPR1_SMP4_Cycles4_5 = 0x2
	// 7.5 ADC clock cycles
	ADC_SMPR1_SMP4_Cycles7_5 = 0x3
	// 19.5 ADC clock cycles
	ADC_SMPR1_SMP4_Cycles19_5 = 0x4
	// 61.5 ADC clock cycles
	ADC_SMPR1_SMP4_Cycles61_5 = 0x5
	// 181.5 ADC clock cycles
	ADC_SMPR1_SMP4_Cycles181_5 = 0x6
	// 601.5 ADC clock cycles
	ADC_SMPR1_SMP4_Cycles601_5 = 0x7
	// Position of SMP3 field.
	ADC_SMPR1_SMP3_Pos = 0x9
	// Bit mask of SMP3 field.
	ADC_SMPR1_SMP3_Msk = 0xe00
	// 1.5 ADC clock cycles
	ADC_SMPR1_SMP3_Cycles1_5 = 0x0
	// 2.5 ADC clock cycles
	ADC_SMPR1_SMP3_Cycles2_5 = 0x1
	// 4.5 ADC clock cycles
	ADC_SMPR1_SMP3_Cycles4_5 = 0x2
	// 7.5 ADC clock cycles
	ADC_SMPR1_SMP3_Cycles7_5 = 0x3
	// 19.5 ADC clock cycles
	ADC_SMPR1_SMP3_Cycles19_5 = 0x4
	// 61.5 ADC clock cycles
	ADC_SMPR1_SMP3_Cycles61_5 = 0x5
	// 181.5 ADC clock cycles
	ADC_SMPR1_SMP3_Cycles181_5 = 0x6
	// 601.5 ADC clock cycles
	ADC_SMPR1_SMP3_Cycles601_5 = 0x7
	// Position of SMP2 field.
	ADC_SMPR1_SMP2_Pos = 0x6
	// Bit mask of SMP2 field.
	ADC_SMPR1_SMP2_Msk = 0x1c0
	// 1.5 ADC clock cycles
	ADC_SMPR1_SMP2_Cycles1_5 = 0x0
	// 2.5 ADC clock cycles
	ADC_SMPR1_SMP2_Cycles2_5 = 0x1
	// 4.5 ADC clock cycles
	ADC_SMPR1_SMP2_Cycles4_5 = 0x2
	// 7.5 ADC clock cycles
	ADC_SMPR1_SMP2_Cycles7_5 = 0x3
	// 19.5 ADC clock cycles
	ADC_SMPR1_SMP2_Cycles19_5 = 0x4
	// 61.5 ADC clock cycles
	ADC_SMPR1_SMP2_Cycles61_5 = 0x5
	// 181.5 ADC clock cycles
	ADC_SMPR1_SMP2_Cycles181_5 = 0x6
	// 601.5 ADC clock cycles
	ADC_SMPR1_SMP2_Cycles601_5 = 0x7
	// Position of SMP1 field.
	ADC_SMPR1_SMP1_Pos = 0x3
	// Bit mask of SMP1 field.
	ADC_SMPR1_SMP1_Msk = 0x38
	// 1.5 ADC clock cycles
	ADC_SMPR1_SMP1_Cycles1_5 = 0x0
	// 2.5 ADC clock cycles
	ADC_SMPR1_SMP1_Cycles2_5 = 0x1
	// 4.5 ADC clock cycles
	ADC_SMPR1_SMP1_Cycles4_5 = 0x2
	// 7.5 ADC clock cycles
	ADC_SMPR1_SMP1_Cycles7_5 = 0x3
	// 19.5 ADC clock cycles
	ADC_SMPR1_SMP1_Cycles19_5 = 0x4
	// 61.5 ADC clock cycles
	ADC_SMPR1_SMP1_Cycles61_5 = 0x5
	// 181.5 ADC clock cycles
	ADC_SMPR1_SMP1_Cycles181_5 = 0x6
	// 601.5 ADC clock cycles
	ADC_SMPR1_SMP1_Cycles601_5 = 0x7

	// SMPR2: sample time register 2
	// Position of SMP18 field.
	ADC_SMPR2_SMP18_Pos = 0x18
	// Bit mask of SMP18 field.
	ADC_SMPR2_SMP18_Msk = 0x7000000
	// 1.5 ADC clock cycles
	ADC_SMPR2_SMP18_Cycles1_5 = 0x0
	// 2.5 ADC clock cycles
	ADC_SMPR2_SMP18_Cycles2_5 = 0x1
	// 4.5 ADC clock cycles
	ADC_SMPR2_SMP18_Cycles4_5 = 0x2
	// 7.5 ADC clock cycles
	ADC_SMPR2_SMP18_Cycles7_5 = 0x3
	// 19.5 ADC clock cycles
	ADC_SMPR2_SMP18_Cycles19_5 = 0x4
	// 61.5 ADC clock cycles
	ADC_SMPR2_SMP18_Cycles61_5 = 0x5
	// 181.5 ADC clock cycles
	ADC_SMPR2_SMP18_Cycles181_5 = 0x6
	// 601.5 ADC clock cycles
	ADC_SMPR2_SMP18_Cycles601_5 = 0x7
	// Position of SMP17 field.
	ADC_SMPR2_SMP17_Pos = 0x15
	// Bit mask of SMP17 field.
	ADC_SMPR2_SMP17_Msk = 0xe00000
	// 1.5 ADC clock cycles
	ADC_SMPR2_SMP17_Cycles1_5 = 0x0
	// 2.5 ADC clock cycles
	ADC_SMPR2_SMP17_Cycles2_5 = 0x1
	// 4.5 ADC clock cycles
	ADC_SMPR2_SMP17_Cycles4_5 = 0x2
	// 7.5 ADC clock cycles
	ADC_SMPR2_SMP17_Cycles7_5 = 0x3
	// 19.5 ADC clock cycles
	ADC_SMPR2_SMP17_Cycles19_5 = 0x4
	// 61.5 ADC clock cycles
	ADC_SMPR2_SMP17_Cycles61_5 = 0x5
	// 181.5 ADC clock cycles
	ADC_SMPR2_SMP17_Cycles181_5 = 0x6
	// 601.5 ADC clock cycles
	ADC_SMPR2_SMP17_Cycles601_5 = 0x7
	// Position of SMP16 field.
	ADC_SMPR2_SMP16_Pos = 0x12
	// Bit mask of SMP16 field.
	ADC_SMPR2_SMP16_Msk = 0x1c0000
	// 1.5 ADC clock cycles
	ADC_SMPR2_SMP16_Cycles1_5 = 0x0
	// 2.5 ADC clock cycles
	ADC_SMPR2_SMP16_Cycles2_5 = 0x1
	// 4.5 ADC clock cycles
	ADC_SMPR2_SMP16_Cycles4_5 = 0x2
	// 7.5 ADC clock cycles
	ADC_SMPR2_SMP16_Cycles7_5 = 0x3
	// 19.5 ADC clock cycles
	ADC_SMPR2_SMP16_Cycles19_5 = 0x4
	// 61.5 ADC clock cycles
	ADC_SMPR2_SMP16_Cycles61_5 = 0x5
	// 181.5 ADC clock cycles
	ADC_SMPR2_SMP16_Cycles181_5 = 0x6
	// 601.5 ADC clock cycles
	ADC_SMPR2_SMP16_Cycles601_5 = 0x7
	// Position of SMP15 field.
	ADC_SMPR2_SMP15_Pos = 0xf
	// Bit mask of SMP15 field.
	ADC_SMPR2_SMP15_Msk = 0x38000
	// 1.5 ADC clock cycles
	ADC_SMPR2_SMP15_Cycles1_5 = 0x0
	// 2.5 ADC clock cycles
	ADC_SMPR2_SMP15_Cycles2_5 = 0x1
	// 4.5 ADC clock cycles
	ADC_SMPR2_SMP15_Cycles4_5 = 0x2
	// 7.5 ADC clock cycles
	ADC_SMPR2_SMP15_Cycles7_5 = 0x3
	// 19.5 ADC clock cycles
	ADC_SMPR2_SMP15_Cycles19_5 = 0x4
	// 61.5 ADC clock cycles
	ADC_SMPR2_SMP15_Cycles61_5 = 0x5
	// 181.5 ADC clock cycles
	ADC_SMPR2_SMP15_Cycles181_5 = 0x6
	// 601.5 ADC clock cycles
	ADC_SMPR2_SMP15_Cycles601_5 = 0x7
	// Position of SMP14 field.
	ADC_SMPR2_SMP14_Pos = 0xc
	// Bit mask of SMP14 field.
	ADC_SMPR2_SMP14_Msk = 0x7000
	// 1.5 ADC clock cycles
	ADC_SMPR2_SMP14_Cycles1_5 = 0x0
	// 2.5 ADC clock cycles
	ADC_SMPR2_SMP14_Cycles2_5 = 0x1
	// 4.5 ADC clock cycles
	ADC_SMPR2_SMP14_Cycles4_5 = 0x2
	// 7.5 ADC clock cycles
	ADC_SMPR2_SMP14_Cycles7_5 = 0x3
	// 19.5 ADC clock cycles
	ADC_SMPR2_SMP14_Cycles19_5 = 0x4
	// 61.5 ADC clock cycles
	ADC_SMPR2_SMP14_Cycles61_5 = 0x5
	// 181.5 ADC clock cycles
	ADC_SMPR2_SMP14_Cycles181_5 = 0x6
	// 601.5 ADC clock cycles
	ADC_SMPR2_SMP14_Cycles601_5 = 0x7
	// Position of SMP13 field.
	ADC_SMPR2_SMP13_Pos = 0x9
	// Bit mask of SMP13 field.
	ADC_SMPR2_SMP13_Msk = 0xe00
	// 1.5 ADC clock cycles
	ADC_SMPR2_SMP13_Cycles1_5 = 0x0
	// 2.5 ADC clock cycles
	ADC_SMPR2_SMP13_Cycles2_5 = 0x1
	// 4.5 ADC clock cycles
	ADC_SMPR2_SMP13_Cycles4_5 = 0x2
	// 7.5 ADC clock cycles
	ADC_SMPR2_SMP13_Cycles7_5 = 0x3
	// 19.5 ADC clock cycles
	ADC_SMPR2_SMP13_Cycles19_5 = 0x4
	// 61.5 ADC clock cycles
	ADC_SMPR2_SMP13_Cycles61_5 = 0x5
	// 181.5 ADC clock cycles
	ADC_SMPR2_SMP13_Cycles181_5 = 0x6
	// 601.5 ADC clock cycles
	ADC_SMPR2_SMP13_Cycles601_5 = 0x7
	// Position of SMP12 field.
	ADC_SMPR2_SMP12_Pos = 0x6
	// Bit mask of SMP12 field.
	ADC_SMPR2_SMP12_Msk = 0x1c0
	// 1.5 ADC clock cycles
	ADC_SMPR2_SMP12_Cycles1_5 = 0x0
	// 2.5 ADC clock cycles
	ADC_SMPR2_SMP12_Cycles2_5 = 0x1
	// 4.5 ADC clock cycles
	ADC_SMPR2_SMP12_Cycles4_5 = 0x2
	// 7.5 ADC clock cycles
	ADC_SMPR2_SMP12_Cycles7_5 = 0x3
	// 19.5 ADC clock cycles
	ADC_SMPR2_SMP12_Cycles19_5 = 0x4
	// 61.5 ADC clock cycles
	ADC_SMPR2_SMP12_Cycles61_5 = 0x5
	// 181.5 ADC clock cycles
	ADC_SMPR2_SMP12_Cycles181_5 = 0x6
	// 601.5 ADC clock cycles
	ADC_SMPR2_SMP12_Cycles601_5 = 0x7
	// Position of SMP11 field.
	ADC_SMPR2_SMP11_Pos = 0x3
	// Bit mask of SMP11 field.
	ADC_SMPR2_SMP11_Msk = 0x38
	// 1.5 ADC clock cycles
	ADC_SMPR2_SMP11_Cycles1_5 = 0x0
	// 2.5 ADC clock cycles
	ADC_SMPR2_SMP11_Cycles2_5 = 0x1
	// 4.5 ADC clock cycles
	ADC_SMPR2_SMP11_Cycles4_5 = 0x2
	// 7.5 ADC clock cycles
	ADC_SMPR2_SMP11_Cycles7_5 = 0x3
	// 19.5 ADC clock cycles
	ADC_SMPR2_SMP11_Cycles19_5 = 0x4
	// 61.5 ADC clock cycles
	ADC_SMPR2_SMP11_Cycles61_5 = 0x5
	// 181.5 ADC clock cycles
	ADC_SMPR2_SMP11_Cycles181_5 = 0x6
	// 601.5 ADC clock cycles
	ADC_SMPR2_SMP11_Cycles601_5 = 0x7
	// Position of SMP10 field.
	ADC_SMPR2_SMP10_Pos = 0x0
	// Bit mask of SMP10 field.
	ADC_SMPR2_SMP10_Msk = 0x7
	// 1.5 ADC clock cycles
	ADC_SMPR2_SMP10_Cycles1_5 = 0x0
	// 2.5 ADC clock cycles
	ADC_SMPR2_SMP10_Cycles2_5 = 0x1
	// 4.5 ADC clock cycles
	ADC_SMPR2_SMP10_Cycles4_5 = 0x2
	// 7.5 ADC clock cycles
	ADC_SMPR2_SMP10_Cycles7_5 = 0x3
	// 19.5 ADC clock cycles
	ADC_SMPR2_SMP10_Cycles19_5 = 0x4
	// 61.5 ADC clock cycles
	ADC_SMPR2_SMP10_Cycles61_5 = 0x5
	// 181.5 ADC clock cycles
	ADC_SMPR2_SMP10_Cycles181_5 = 0x6
	// 601.5 ADC clock cycles
	ADC_SMPR2_SMP10_Cycles601_5 = 0x7

	// TR1: watchdog threshold register 1
	// Position of HT1 field.
	ADC_TR1_HT1_Pos = 0x10
	// Bit mask of HT1 field.
	ADC_TR1_HT1_Msk = 0xfff0000
	// Position of LT1 field.
	ADC_TR1_LT1_Pos = 0x0
	// Bit mask of LT1 field.
	ADC_TR1_LT1_Msk = 0xfff

	// TR2: watchdog threshold register
	// Position of HT2 field.
	ADC_TR2_HT2_Pos = 0x10
	// Bit mask of HT2 field.
	ADC_TR2_HT2_Msk = 0xff0000
	// Position of LT2 field.
	ADC_TR2_LT2_Pos = 0x0
	// Bit mask of LT2 field.
	ADC_TR2_LT2_Msk = 0xff

	// TR3: watchdog threshold register 3
	// Position of HT3 field.
	ADC_TR3_HT3_Pos = 0x10
	// Bit mask of HT3 field.
	ADC_TR3_HT3_Msk = 0xff0000
	// Position of LT3 field.
	ADC_TR3_LT3_Pos = 0x0
	// Bit mask of LT3 field.
	ADC_TR3_LT3_Msk = 0xff

	// SQR1: regular sequence register 1
	// Position of SQ4 field.
	ADC_SQR1_SQ4_Pos = 0x18
	// Bit mask of SQ4 field.
	ADC_SQR1_SQ4_Msk = 0x1f000000
	// Position of SQ3 field.
	ADC_SQR1_SQ3_Pos = 0x12
	// Bit mask of SQ3 field.
	ADC_SQR1_SQ3_Msk = 0x7c0000
	// Position of SQ2 field.
	ADC_SQR1_SQ2_Pos = 0xc
	// Bit mask of SQ2 field.
	ADC_SQR1_SQ2_Msk = 0x1f000
	// Position of SQ1 field.
	ADC_SQR1_SQ1_Pos = 0x6
	// Bit mask of SQ1 field.
	ADC_SQR1_SQ1_Msk = 0x7c0
	// Position of L field.
	ADC_SQR1_L_Pos = 0x0
	// Bit mask of L field.
	ADC_SQR1_L_Msk = 0xf

	// SQR2: regular sequence register 2
	// Position of SQ9 field.
	ADC_SQR2_SQ9_Pos = 0x18
	// Bit mask of SQ9 field.
	ADC_SQR2_SQ9_Msk = 0x1f000000
	// Position of SQ8 field.
	ADC_SQR2_SQ8_Pos = 0x12
	// Bit mask of SQ8 field.
	ADC_SQR2_SQ8_Msk = 0x7c0000
	// Position of SQ7 field.
	ADC_SQR2_SQ7_Pos = 0xc
	// Bit mask of SQ7 field.
	ADC_SQR2_SQ7_Msk = 0x1f000
	// Position of SQ6 field.
	ADC_SQR2_SQ6_Pos = 0x6
	// Bit mask of SQ6 field.
	ADC_SQR2_SQ6_Msk = 0x7c0
	// Position of SQ5 field.
	ADC_SQR2_SQ5_Pos = 0x0
	// Bit mask of SQ5 field.
	ADC_SQR2_SQ5_Msk = 0x1f

	// SQR3: regular sequence register 3
	// Position of SQ14 field.
	ADC_SQR3_SQ14_Pos = 0x18
	// Bit mask of SQ14 field.
	ADC_SQR3_SQ14_Msk = 0x1f000000
	// Position of SQ13 field.
	ADC_SQR3_SQ13_Pos = 0x12
	// Bit mask of SQ13 field.
	ADC_SQR3_SQ13_Msk = 0x7c0000
	// Position of SQ12 field.
	ADC_SQR3_SQ12_Pos = 0xc
	// Bit mask of SQ12 field.
	ADC_SQR3_SQ12_Msk = 0x1f000
	// Position of SQ11 field.
	ADC_SQR3_SQ11_Pos = 0x6
	// Bit mask of SQ11 field.
	ADC_SQR3_SQ11_Msk = 0x7c0
	// Position of SQ10 field.
	ADC_SQR3_SQ10_Pos = 0x0
	// Bit mask of SQ10 field.
	ADC_SQR3_SQ10_Msk = 0x1f

	// SQR4: regular sequence register 4
	// Position of SQ16 field.
	ADC_SQR4_SQ16_Pos = 0x6
	// Bit mask of SQ16 field.
	ADC_SQR4_SQ16_Msk = 0x7c0
	// Position of SQ15 field.
	ADC_SQR4_SQ15_Pos = 0x0
	// Bit mask of SQ15 field.
	ADC_SQR4_SQ15_Msk = 0x1f

	// DR: regular Data Register
	// Position of RDATA field.
	ADC_DR_RDATA_Pos = 0x0
	// Bit mask of RDATA field.
	ADC_DR_RDATA_Msk = 0xffff

	// JSQR: injected sequence register
	// Position of JSQ4 field.
	ADC_JSQR_JSQ4_Pos = 0x1a
	// Bit mask of JSQ4 field.
	ADC_JSQR_JSQ4_Msk = 0x7c000000
	// Position of JSQ3 field.
	ADC_JSQR_JSQ3_Pos = 0x14
	// Bit mask of JSQ3 field.
	ADC_JSQR_JSQ3_Msk = 0x1f00000
	// Position of JSQ2 field.
	ADC_JSQR_JSQ2_Pos = 0xe
	// Bit mask of JSQ2 field.
	ADC_JSQR_JSQ2_Msk = 0x7c000
	// Position of JSQ1 field.
	ADC_JSQR_JSQ1_Pos = 0x8
	// Bit mask of JSQ1 field.
	ADC_JSQR_JSQ1_Msk = 0x1f00
	// Position of JEXTEN field.
	ADC_JSQR_JEXTEN_Pos = 0x6
	// Bit mask of JEXTEN field.
	ADC_JSQR_JEXTEN_Msk = 0xc0
	// Trigger detection disabled
	ADC_JSQR_JEXTEN_Disabled = 0x0
	// Trigger detection on the rising edge
	ADC_JSQR_JEXTEN_RisingEdge = 0x1
	// Trigger detection on the falling edge
	ADC_JSQR_JEXTEN_FallingEdge = 0x2
	// Trigger detection on both the rising and falling edges
	ADC_JSQR_JEXTEN_BothEdges = 0x3
	// Position of JEXTSEL field.
	ADC_JSQR_JEXTSEL_Pos = 0x2
	// Bit mask of JEXTSEL field.
	ADC_JSQR_JEXTSEL_Msk = 0x3c
	// HRTIM_ADCTRG2 event
	ADC_JSQR_JEXTSEL_HRTIM_ADCTRG2 = 0x9
	// HRTIM_ADCTRG4 event
	ADC_JSQR_JEXTSEL_HRTIM_ADCTRG4 = 0xa
	// Position of JL field.
	ADC_JSQR_JL_Pos = 0x0
	// Bit mask of JL field.
	ADC_JSQR_JL_Msk = 0x3

	// OFR1: offset register 1
	// Position of OFFSET1_EN field.
	ADC_OFR1_OFFSET1_EN_Pos = 0x1f
	// Bit mask of OFFSET1_EN field.
	ADC_OFR1_OFFSET1_EN_Msk = 0x80000000
	// Bit OFFSET1_EN.
	ADC_OFR1_OFFSET1_EN = 0x80000000
	// Offset disabled
	ADC_OFR1_OFFSET1_EN_Disabled = 0x0
	// Offset enabled
	ADC_OFR1_OFFSET1_EN_Enabled = 0x1
	// Position of OFFSET1_CH field.
	ADC_OFR1_OFFSET1_CH_Pos = 0x1a
	// Bit mask of OFFSET1_CH field.
	ADC_OFR1_OFFSET1_CH_Msk = 0x7c000000
	// Position of OFFSET1 field.
	ADC_OFR1_OFFSET1_Pos = 0x0
	// Bit mask of OFFSET1 field.
	ADC_OFR1_OFFSET1_Msk = 0xfff

	// OFR2: offset register 2
	// Position of OFFSET2_EN field.
	ADC_OFR2_OFFSET2_EN_Pos = 0x1f
	// Bit mask of OFFSET2_EN field.
	ADC_OFR2_OFFSET2_EN_Msk = 0x80000000
	// Bit OFFSET2_EN.
	ADC_OFR2_OFFSET2_EN = 0x80000000
	// Offset disabled
	ADC_OFR2_OFFSET2_EN_Disabled = 0x0
	// Offset enabled
	ADC_OFR2_OFFSET2_EN_Enabled = 0x1
	// Position of OFFSET2_CH field.
	ADC_OFR2_OFFSET2_CH_Pos = 0x1a
	// Bit mask of OFFSET2_CH field.
	ADC_OFR2_OFFSET2_CH_Msk = 0x7c000000
	// Position of OFFSET2 field.
	ADC_OFR2_OFFSET2_Pos = 0x0
	// Bit mask of OFFSET2 field.
	ADC_OFR2_OFFSET2_Msk = 0xfff

	// OFR3: offset register 3
	// Position of OFFSET3_EN field.
	ADC_OFR3_OFFSET3_EN_Pos = 0x1f
	// Bit mask of OFFSET3_EN field.
	ADC_OFR3_OFFSET3_EN_Msk = 0x80000000
	// Bit OFFSET3_EN.
	ADC_OFR3_OFFSET3_EN = 0x80000000
	// Offset disabled
	ADC_OFR3_OFFSET3_EN_Disabled = 0x0
	// Offset enabled
	ADC_OFR3_OFFSET3_EN_Enabled = 0x1
	// Position of OFFSET3_CH field.
	ADC_OFR3_OFFSET3_CH_Pos = 0x1a
	// Bit mask of OFFSET3_CH field.
	ADC_OFR3_OFFSET3_CH_Msk = 0x7c000000
	// Position of OFFSET3 field.
	ADC_OFR3_OFFSET3_Pos = 0x0
	// Bit mask of OFFSET3 field.
	ADC_OFR3_OFFSET3_Msk = 0xfff

	// OFR4: offset register 4
	// Position of OFFSET4_EN field.
	ADC_OFR4_OFFSET4_EN_Pos = 0x1f
	// Bit mask of OFFSET4_EN field.
	ADC_OFR4_OFFSET4_EN_Msk = 0x80000000
	// Bit OFFSET4_EN.
	ADC_OFR4_OFFSET4_EN = 0x80000000
	// Offset disabled
	ADC_OFR4_OFFSET4_EN_Disabled = 0x0
	// Offset enabled
	ADC_OFR4_OFFSET4_EN_Enabled = 0x1
	// Position of OFFSET4_CH field.
	ADC_OFR4_OFFSET4_CH_Pos = 0x1a
	// Bit mask of OFFSET4_CH field.
	ADC_OFR4_OFFSET4_CH_Msk = 0x7c000000
	// Position of OFFSET4 field.
	ADC_OFR4_OFFSET4_Pos = 0x0
	// Bit mask of OFFSET4 field.
	ADC_OFR4_OFFSET4_Msk = 0xfff

	// JDR1: injected data register 1
	// Position of JDATA1 field.
	ADC_JDR1_JDATA1_Pos = 0x0
	// Bit mask of JDATA1 field.
	ADC_JDR1_JDATA1_Msk = 0xffff

	// JDR2: injected data register 2
	// Position of JDATA2 field.
	ADC_JDR2_JDATA2_Pos = 0x0
	// Bit mask of JDATA2 field.
	ADC_JDR2_JDATA2_Msk = 0xffff

	// JDR3: injected data register 3
	// Position of JDATA3 field.
	ADC_JDR3_JDATA3_Pos = 0x0
	// Bit mask of JDATA3 field.
	ADC_JDR3_JDATA3_Msk = 0xffff

	// JDR4: injected data register 4
	// Position of JDATA4 field.
	ADC_JDR4_JDATA4_Pos = 0x0
	// Bit mask of JDATA4 field.
	ADC_JDR4_JDATA4_Msk = 0xffff

	// AWD2CR: Analog Watchdog 2 Configuration Register
	// Position of AWD2CH0 field.
	ADC_AWD2CR_AWD2CH0_Pos = 0x0
	// Bit mask of AWD2CH0 field.
	ADC_AWD2CR_AWD2CH0_Msk = 0x1
	// Bit AWD2CH0.
	ADC_AWD2CR_AWD2CH0 = 0x1
	// Input channel not monitored by AWDx
	ADC_AWD2CR_AWD2CH0_NotMonitored = 0x0
	// Input channel monitored by AWDx
	ADC_AWD2CR_AWD2CH0_Monitored = 0x1
	// Position of AWD2CH1 field.
	ADC_AWD2CR_AWD2CH1_Pos = 0x1
	// Bit mask of AWD2CH1 field.
	ADC_AWD2CR_AWD2CH1_Msk = 0x2
	// Bit AWD2CH1.
	ADC_AWD2CR_AWD2CH1 = 0x2
	// Input channel not monitored by AWDx
	ADC_AWD2CR_AWD2CH1_NotMonitored = 0x0
	// Input channel monitored by AWDx
	ADC_AWD2CR_AWD2CH1_Monitored = 0x1
	// Position of AWD2CH2 field.
	ADC_AWD2CR_AWD2CH2_Pos = 0x2
	// Bit mask of AWD2CH2 field.
	ADC_AWD2CR_AWD2CH2_Msk = 0x4
	// Bit AWD2CH2.
	ADC_AWD2CR_AWD2CH2 = 0x4
	// Input channel not monitored by AWDx
	ADC_AWD2CR_AWD2CH2_NotMonitored = 0x0
	// Input channel monitored by AWDx
	ADC_AWD2CR_AWD2CH2_Monitored = 0x1
	// Position of AWD2CH3 field.
	ADC_AWD2CR_AWD2CH3_Pos = 0x3
	// Bit mask of AWD2CH3 field.
	ADC_AWD2CR_AWD2CH3_Msk = 0x8
	// Bit AWD2CH3.
	ADC_AWD2CR_AWD2CH3 = 0x8
	// Input channel not monitored by AWDx
	ADC_AWD2CR_AWD2CH3_NotMonitored = 0x0
	// Input channel monitored by AWDx
	ADC_AWD2CR_AWD2CH3_Monitored = 0x1
	// Position of AWD2CH4 field.
	ADC_AWD2CR_AWD2CH4_Pos = 0x4
	// Bit mask of AWD2CH4 field.
	ADC_AWD2CR_AWD2CH4_Msk = 0x10
	// Bit AWD2CH4.
	ADC_AWD2CR_AWD2CH4 = 0x10
	// Input channel not monitored by AWDx
	ADC_AWD2CR_AWD2CH4_NotMonitored = 0x0
	// Input channel monitored by AWDx
	ADC_AWD2CR_AWD2CH4_Monitored = 0x1
	// Position of AWD2CH5 field.
	ADC_AWD2CR_AWD2CH5_Pos = 0x5
	// Bit mask of AWD2CH5 field.
	ADC_AWD2CR_AWD2CH5_Msk = 0x20
	// Bit AWD2CH5.
	ADC_AWD2CR_AWD2CH5 = 0x20
	// Input channel not monitored by AWDx
	ADC_AWD2CR_AWD2CH5_NotMonitored = 0x0
	// Input channel monitored by AWDx
	ADC_AWD2CR_AWD2CH5_Monitored = 0x1
	// Position of AWD2CH6 field.
	ADC_AWD2CR_AWD2CH6_Pos = 0x6
	// Bit mask of AWD2CH6 field.
	ADC_AWD2CR_AWD2CH6_Msk = 0x40
	// Bit AWD2CH6.
	ADC_AWD2CR_AWD2CH6 = 0x40
	// Input channel not monitored by AWDx
	ADC_AWD2CR_AWD2CH6_NotMonitored = 0x0
	// Input channel monitored by AWDx
	ADC_AWD2CR_AWD2CH6_Monitored = 0x1
	// Position of AWD2CH7 field.
	ADC_AWD2CR_AWD2CH7_Pos = 0x7
	// Bit mask of AWD2CH7 field.
	ADC_AWD2CR_AWD2CH7_Msk = 0x80
	// Bit AWD2CH7.
	ADC_AWD2CR_AWD2CH7 = 0x80
	// Input channel not monitored by AWDx
	ADC_AWD2CR_AWD2CH7_NotMonitored = 0x0
	// Input channel monitored by AWDx
	ADC_AWD2CR_AWD2CH7_Monitored = 0x1
	// Position of AWD2CH8 field.
	ADC_AWD2CR_AWD2CH8_Pos = 0x8
	// Bit mask of AWD2CH8 field.
	ADC_AWD2CR_AWD2CH8_Msk = 0x100
	// Bit AWD2CH8.
	ADC_AWD2CR_AWD2CH8 = 0x100
	// Input channel not monitored by AWDx
	ADC_AWD2CR_AWD2CH8_NotMonitored = 0x0
	// Input channel monitored by AWDx
	ADC_AWD2CR_AWD2CH8_Monitored = 0x1
	// Position of AWD2CH9 field.
	ADC_AWD2CR_AWD2CH9_Pos = 0x9
	// Bit mask of AWD2CH9 field.
	ADC_AWD2CR_AWD2CH9_Msk = 0x200
	// Bit AWD2CH9.
	ADC_AWD2CR_AWD2CH9 = 0x200
	// Input channel not monitored by AWDx
	ADC_AWD2CR_AWD2CH9_NotMonitored = 0x0
	// Input channel monitored by AWDx
	ADC_AWD2CR_AWD2CH9_Monitored = 0x1
	// Position of AWD2CH10 field.
	ADC_AWD2CR_AWD2CH10_Pos = 0xa
	// Bit mask of AWD2CH10 field.
	ADC_AWD2CR_AWD2CH10_Msk = 0x400
	// Bit AWD2CH10.
	ADC_AWD2CR_AWD2CH10 = 0x400
	// Input channel not monitored by AWDx
	ADC_AWD2CR_AWD2CH10_NotMonitored = 0x0
	// Input channel monitored by AWDx
	ADC_AWD2CR_AWD2CH10_Monitored = 0x1
	// Position of AWD2CH11 field.
	ADC_AWD2CR_AWD2CH11_Pos = 0xb
	// Bit mask of AWD2CH11 field.
	ADC_AWD2CR_AWD2CH11_Msk = 0x800
	// Bit AWD2CH11.
	ADC_AWD2CR_AWD2CH11 = 0x800
	// Input channel not monitored by AWDx
	ADC_AWD2CR_AWD2CH11_NotMonitored = 0x0
	// Input channel monitored by AWDx
	ADC_AWD2CR_AWD2CH11_Monitored = 0x1
	// Position of AWD2CH12 field.
	ADC_AWD2CR_AWD2CH12_Pos = 0xc
	// Bit mask of AWD2CH12 field.
	ADC_AWD2CR_AWD2CH12_Msk = 0x1000
	// Bit AWD2CH12.
	ADC_AWD2CR_AWD2CH12 = 0x1000
	// Input channel not monitored by AWDx
	ADC_AWD2CR_AWD2CH12_NotMonitored = 0x0
	// Input channel monitored by AWDx
	ADC_AWD2CR_AWD2CH12_Monitored = 0x1
	// Position of AWD2CH13 field.
	ADC_AWD2CR_AWD2CH13_Pos = 0xd
	// Bit mask of AWD2CH13 field.
	ADC_AWD2CR_AWD2CH13_Msk = 0x2000
	// Bit AWD2CH13.
	ADC_AWD2CR_AWD2CH13 = 0x2000
	// Input channel not monitored by AWDx
	ADC_AWD2CR_AWD2CH13_NotMonitored = 0x0
	// Input channel monitored by AWDx
	ADC_AWD2CR_AWD2CH13_Monitored = 0x1
	// Position of AWD2CH14 field.
	ADC_AWD2CR_AWD2CH14_Pos = 0xe
	// Bit mask of AWD2CH14 field.
	ADC_AWD2CR_AWD2CH14_Msk = 0x4000
	// Bit AWD2CH14.
	ADC_AWD2CR_AWD2CH14 = 0x4000
	// Input channel not monitored by AWDx
	ADC_AWD2CR_AWD2CH14_NotMonitored = 0x0
	// Input channel monitored by AWDx
	ADC_AWD2CR_AWD2CH14_Monitored = 0x1
	// Position of AWD2CH15 field.
	ADC_AWD2CR_AWD2CH15_Pos = 0xf
	// Bit mask of AWD2CH15 field.
	ADC_AWD2CR_AWD2CH15_Msk = 0x8000
	// Bit AWD2CH15.
	ADC_AWD2CR_AWD2CH15 = 0x8000
	// Input channel not monitored by AWDx
	ADC_AWD2CR_AWD2CH15_NotMonitored = 0x0
	// Input channel monitored by AWDx
	ADC_AWD2CR_AWD2CH15_Monitored = 0x1
	// Position of AWD2CH16 field.
	ADC_AWD2CR_AWD2CH16_Pos = 0x10
	// Bit mask of AWD2CH16 field.
	ADC_AWD2CR_AWD2CH16_Msk = 0x10000
	// Bit AWD2CH16.
	ADC_AWD2CR_AWD2CH16 = 0x10000
	// Input channel not monitored by AWDx
	ADC_AWD2CR_AWD2CH16_NotMonitored = 0x0
	// Input channel monitored by AWDx
	ADC_AWD2CR_AWD2CH16_Monitored = 0x1
	// Position of AWD2CH17 field.
	ADC_AWD2CR_AWD2CH17_Pos = 0x11
	// Bit mask of AWD2CH17 field.
	ADC_AWD2CR_AWD2CH17_Msk = 0x20000
	// Bit AWD2CH17.
	ADC_AWD2CR_AWD2CH17 = 0x20000
	// Input channel not monitored by AWDx
	ADC_AWD2CR_AWD2CH17_NotMonitored = 0x0
	// Input channel monitored by AWDx
	ADC_AWD2CR_AWD2CH17_Monitored = 0x1

	// AWD3CR: Analog Watchdog 3 Configuration Register
	// Position of AWD3CH0 field.
	ADC_AWD3CR_AWD3CH0_Pos = 0x0
	// Bit mask of AWD3CH0 field.
	ADC_AWD3CR_AWD3CH0_Msk = 0x1
	// Bit AWD3CH0.
	ADC_AWD3CR_AWD3CH0 = 0x1
	// Input channel not monitored by AWDx
	ADC_AWD3CR_AWD3CH0_NotMonitored = 0x0
	// Input channel monitored by AWDx
	ADC_AWD3CR_AWD3CH0_Monitored = 0x1
	// Position of AWD3CH1 field.
	ADC_AWD3CR_AWD3CH1_Pos = 0x1
	// Bit mask of AWD3CH1 field.
	ADC_AWD3CR_AWD3CH1_Msk = 0x2
	// Bit AWD3CH1.
	ADC_AWD3CR_AWD3CH1 = 0x2
	// Input channel not monitored by AWDx
	ADC_AWD3CR_AWD3CH1_NotMonitored = 0x0
	// Input channel monitored by AWDx
	ADC_AWD3CR_AWD3CH1_Monitored = 0x1
	// Position of AWD3CH2 field.
	ADC_AWD3CR_AWD3CH2_Pos = 0x2
	// Bit mask of AWD3CH2 field.
	ADC_AWD3CR_AWD3CH2_Msk = 0x4
	// Bit AWD3CH2.
	ADC_AWD3CR_AWD3CH2 = 0x4
	// Input channel not monitored by AWDx
	ADC_AWD3CR_AWD3CH2_NotMonitored = 0x0
	// Input channel monitored by AWDx
	ADC_AWD3CR_AWD3CH2_Monitored = 0x1
	// Position of AWD3CH3 field.
	ADC_AWD3CR_AWD3CH3_Pos = 0x3
	// Bit mask of AWD3CH3 field.
	ADC_AWD3CR_AWD3CH3_Msk = 0x8
	// Bit AWD3CH3.
	ADC_AWD3CR_AWD3CH3 = 0x8
	// Input channel not monitored by AWDx
	ADC_AWD3CR_AWD3CH3_NotMonitored = 0x0
	// Input channel monitored by AWDx
	ADC_AWD3CR_AWD3CH3_Monitored = 0x1
	// Position of AWD3CH4 field.
	ADC_AWD3CR_AWD3CH4_Pos = 0x4
	// Bit mask of AWD3CH4 field.
	ADC_AWD3CR_AWD3CH4_Msk = 0x10
	// Bit AWD3CH4.
	ADC_AWD3CR_AWD3CH4 = 0x10
	// Input channel not monitored by AWDx
	ADC_AWD3CR_AWD3CH4_NotMonitored = 0x0
	// Input channel monitored by AWDx
	ADC_AWD3CR_AWD3CH4_Monitored = 0x1
	// Position of AWD3CH5 field.
	ADC_AWD3CR_AWD3CH5_Pos = 0x5
	// Bit mask of AWD3CH5 field.
	ADC_AWD3CR_AWD3CH5_Msk = 0x20
	// Bit AWD3CH5.
	ADC_AWD3CR_AWD3CH5 = 0x20
	// Input channel not monitored by AWDx
	ADC_AWD3CR_AWD3CH5_NotMonitored = 0x0
	// Input channel monitored by AWDx
	ADC_AWD3CR_AWD3CH5_Monitored = 0x1
	// Position of AWD3CH6 field.
	ADC_AWD3CR_AWD3CH6_Pos = 0x6
	// Bit mask of AWD3CH6 field.
	ADC_AWD3CR_AWD3CH6_Msk = 0x40
	// Bit AWD3CH6.
	ADC_AWD3CR_AWD3CH6 = 0x40
	// Input channel not monitored by AWDx
	ADC_AWD3CR_AWD3CH6_NotMonitored = 0x0
	// Input channel monitored by AWDx
	ADC_AWD3CR_AWD3CH6_Monitored = 0x1
	// Position of AWD3CH7 field.
	ADC_AWD3CR_AWD3CH7_Pos = 0x7
	// Bit mask of AWD3CH7 field.
	ADC_AWD3CR_AWD3CH7_Msk = 0x80
	// Bit AWD3CH7.
	ADC_AWD3CR_AWD3CH7 = 0x80
	// Input channel not monitored by AWDx
	ADC_AWD3CR_AWD3CH7_NotMonitored = 0x0
	// Input channel monitored by AWDx
	ADC_AWD3CR_AWD3CH7_Monitored = 0x1
	// Position of AWD3CH8 field.
	ADC_AWD3CR_AWD3CH8_Pos = 0x8
	// Bit mask of AWD3CH8 field.
	ADC_AWD3CR_AWD3CH8_Msk = 0x100
	// Bit AWD3CH8.
	ADC_AWD3CR_AWD3CH8 = 0x100
	// Input channel not monitored by AWDx
	ADC_AWD3CR_AWD3CH8_NotMonitored = 0x0
	// Input channel monitored by AWDx
	ADC_AWD3CR_AWD3CH8_Monitored = 0x1
	// Position of AWD3CH9 field.
	ADC_AWD3CR_AWD3CH9_Pos = 0x9
	// Bit mask of AWD3CH9 field.
	ADC_AWD3CR_AWD3CH9_Msk = 0x200
	// Bit AWD3CH9.
	ADC_AWD3CR_AWD3CH9 = 0x200
	// Input channel not monitored by AWDx
	ADC_AWD3CR_AWD3CH9_NotMonitored = 0x0
	// Input channel monitored by AWDx
	ADC_AWD3CR_AWD3CH9_Monitored = 0x1
	// Position of AWD3CH10 field.
	ADC_AWD3CR_AWD3CH10_Pos = 0xa
	// Bit mask of AWD3CH10 field.
	ADC_AWD3CR_AWD3CH10_Msk = 0x400
	// Bit AWD3CH10.
	ADC_AWD3CR_AWD3CH10 = 0x400
	// Input channel not monitored by AWDx
	ADC_AWD3CR_AWD3CH10_NotMonitored = 0x0
	// Input channel monitored by AWDx
	ADC_AWD3CR_AWD3CH10_Monitored = 0x1
	// Position of AWD3CH11 field.
	ADC_AWD3CR_AWD3CH11_Pos = 0xb
	// Bit mask of AWD3CH11 field.
	ADC_AWD3CR_AWD3CH11_Msk = 0x800
	// Bit AWD3CH11.
	ADC_AWD3CR_AWD3CH11 = 0x800
	// Input channel not monitored by AWDx
	ADC_AWD3CR_AWD3CH11_NotMonitored = 0x0
	// Input channel monitored by AWDx
	ADC_AWD3CR_AWD3CH11_Monitored = 0x1
	// Position of AWD3CH12 field.
	ADC_AWD3CR_AWD3CH12_Pos = 0xc
	// Bit mask of AWD3CH12 field.
	ADC_AWD3CR_AWD3CH12_Msk = 0x1000
	// Bit AWD3CH12.
	ADC_AWD3CR_AWD3CH12 = 0x1000
	// Input channel not monitored by AWDx
	ADC_AWD3CR_AWD3CH12_NotMonitored = 0x0
	// Input channel monitored by AWDx
	ADC_AWD3CR_AWD3CH12_Monitored = 0x1
	// Position of AWD3CH13 field.
	ADC_AWD3CR_AWD3CH13_Pos = 0xd
	// Bit mask of AWD3CH13 field.
	ADC_AWD3CR_AWD3CH13_Msk = 0x2000
	// Bit AWD3CH13.
	ADC_AWD3CR_AWD3CH13 = 0x2000
	// Input channel not monitored by AWDx
	ADC_AWD3CR_AWD3CH13_NotMonitored = 0x0
	// Input channel monitored by AWDx
	ADC_AWD3CR_AWD3CH13_Monitored = 0x1
	// Position of AWD3CH14 field.
	ADC_AWD3CR_AWD3CH14_Pos = 0xe
	// Bit mask of AWD3CH14 field.
	ADC_AWD3CR_AWD3CH14_Msk = 0x4000
	// Bit AWD3CH14.
	ADC_AWD3CR_AWD3CH14 = 0x4000
	// Input channel not monitored by AWDx
	ADC_AWD3CR_AWD3CH14_NotMonitored = 0x0
	// Input channel monitored by AWDx
	ADC_AWD3CR_AWD3CH14_Monitored = 0x1
	// Position of AWD3CH15 field.
	ADC_AWD3CR_AWD3CH15_Pos = 0xf
	// Bit mask of AWD3CH15 field.
	ADC_AWD3CR_AWD3CH15_Msk = 0x8000
	// Bit AWD3CH15.
	ADC_AWD3CR_AWD3CH15 = 0x8000
	// Input channel not monitored by AWDx
	ADC_AWD3CR_AWD3CH15_NotMonitored = 0x0
	// Input channel monitored by AWDx
	ADC_AWD3CR_AWD3CH15_Monitored = 0x1
	// Position of AWD3CH16 field.
	ADC_AWD3CR_AWD3CH16_Pos = 0x10
	// Bit mask of AWD3CH16 field.
	ADC_AWD3CR_AWD3CH16_Msk = 0x10000
	// Bit AWD3CH16.
	ADC_AWD3CR_AWD3CH16 = 0x10000
	// Input channel not monitored by AWDx
	ADC_AWD3CR_AWD3CH16_NotMonitored = 0x0
	// Input channel monitored by AWDx
	ADC_AWD3CR_AWD3CH16_Monitored = 0x1
	// Position of AWD3CH17 field.
	ADC_AWD3CR_AWD3CH17_Pos = 0x11
	// Bit mask of AWD3CH17 field.
	ADC_AWD3CR_AWD3CH17_Msk = 0x20000
	// Bit AWD3CH17.
	ADC_AWD3CR_AWD3CH17 = 0x20000
	// Input channel not monitored by AWDx
	ADC_AWD3CR_AWD3CH17_NotMonitored = 0x0
	// Input channel monitored by AWDx
	ADC_AWD3CR_AWD3CH17_Monitored = 0x1

	// DIFSEL: Differential Mode Selection Register 2
	// Position of DIFSEL_10 field.
	ADC_DIFSEL_DIFSEL_10_Pos = 0x0
	// Bit mask of DIFSEL_10 field.
	ADC_DIFSEL_DIFSEL_10_Msk = 0x1
	// Bit DIFSEL_10.
	ADC_DIFSEL_DIFSEL_10 = 0x1
	// Input channel is configured in single-ended mode
	ADC_DIFSEL_DIFSEL_10_SingleEnded = 0x0
	// Input channel is configured in differential mode
	ADC_DIFSEL_DIFSEL_10_Differential = 0x1
	// Position of DIFSEL_11 field.
	ADC_DIFSEL_DIFSEL_11_Pos = 0x1
	// Bit mask of DIFSEL_11 field.
	ADC_DIFSEL_DIFSEL_11_Msk = 0x2
	// Bit DIFSEL_11.
	ADC_DIFSEL_DIFSEL_11 = 0x2
	// Input channel is configured in single-ended mode
	ADC_DIFSEL_DIFSEL_11_SingleEnded = 0x0
	// Input channel is configured in differential mode
	ADC_DIFSEL_DIFSEL_11_Differential = 0x1
	// Position of DIFSEL_12 field.
	ADC_DIFSEL_DIFSEL_12_Pos = 0x2
	// Bit mask of DIFSEL_12 field.
	ADC_DIFSEL_DIFSEL_12_Msk = 0x4
	// Bit DIFSEL_12.
	ADC_DIFSEL_DIFSEL_12 = 0x4
	// Input channel is configured in single-ended mode
	ADC_DIFSEL_DIFSEL_12_SingleEnded = 0x0
	// Input channel is configured in differential mode
	ADC_DIFSEL_DIFSEL_12_Differential = 0x1
	// Position of DIFSEL_13 field.
	ADC_DIFSEL_DIFSEL_13_Pos = 0x3
	// Bit mask of DIFSEL_13 field.
	ADC_DIFSEL_DIFSEL_13_Msk = 0x8
	// Bit DIFSEL_13.
	ADC_DIFSEL_DIFSEL_13 = 0x8
	// Input channel is configured in single-ended mode
	ADC_DIFSEL_DIFSEL_13_SingleEnded = 0x0
	// Input channel is configured in differential mode
	ADC_DIFSEL_DIFSEL_13_Differential = 0x1
	// Position of DIFSEL_14 field.
	ADC_DIFSEL_DIFSEL_14_Pos = 0x4
	// Bit mask of DIFSEL_14 field.
	ADC_DIFSEL_DIFSEL_14_Msk = 0x10
	// Bit DIFSEL_14.
	ADC_DIFSEL_DIFSEL_14 = 0x10
	// Input channel is configured in single-ended mode
	ADC_DIFSEL_DIFSEL_14_SingleEnded = 0x0
	// Input channel is configured in differential mode
	ADC_DIFSEL_DIFSEL_14_Differential = 0x1
	// Position of DIFSEL_15 field.
	ADC_DIFSEL_DIFSEL_15_Pos = 0x5
	// Bit mask of DIFSEL_15 field.
	ADC_DIFSEL_DIFSEL_15_Msk = 0x20
	// Bit DIFSEL_15.
	ADC_DIFSEL_DIFSEL_15 = 0x20
	// Input channel is configured in single-ended mode
	ADC_DIFSEL_DIFSEL_15_SingleEnded = 0x0
	// Input channel is configured in differential mode
	ADC_DIFSEL_DIFSEL_15_Differential = 0x1
	// Position of DIFSEL_16 field.
	ADC_DIFSEL_DIFSEL_16_Pos = 0x6
	// Bit mask of DIFSEL_16 field.
	ADC_DIFSEL_DIFSEL_16_Msk = 0x40
	// Bit DIFSEL_16.
	ADC_DIFSEL_DIFSEL_16 = 0x40
	// Input channel is configured in single-ended mode
	ADC_DIFSEL_DIFSEL_16_SingleEnded = 0x0
	// Input channel is configured in differential mode
	ADC_DIFSEL_DIFSEL_16_Differential = 0x1
	// Position of DIFSEL_17 field.
	ADC_DIFSEL_DIFSEL_17_Pos = 0x7
	// Bit mask of DIFSEL_17 field.
	ADC_DIFSEL_DIFSEL_17_Msk = 0x80
	// Bit DIFSEL_17.
	ADC_DIFSEL_DIFSEL_17 = 0x80
	// Input channel is configured in single-ended mode
	ADC_DIFSEL_DIFSEL_17_SingleEnded = 0x0
	// Input channel is configured in differential mode
	ADC_DIFSEL_DIFSEL_17_Differential = 0x1
	// Position of DIFSEL_18 field.
	ADC_DIFSEL_DIFSEL_18_Pos = 0x8
	// Bit mask of DIFSEL_18 field.
	ADC_DIFSEL_DIFSEL_18_Msk = 0x100
	// Bit DIFSEL_18.
	ADC_DIFSEL_DIFSEL_18 = 0x100
	// Input channel is configured in single-ended mode
	ADC_DIFSEL_DIFSEL_18_SingleEnded = 0x0
	// Input channel is configured in differential mode
	ADC_DIFSEL_DIFSEL_18_Differential = 0x1
	// Position of DIFSEL_19 field.
	ADC_DIFSEL_DIFSEL_19_Pos = 0x9
	// Bit mask of DIFSEL_19 field.
	ADC_DIFSEL_DIFSEL_19_Msk = 0x200
	// Bit DIFSEL_19.
	ADC_DIFSEL_DIFSEL_19 = 0x200
	// Input channel is configured in single-ended mode
	ADC_DIFSEL_DIFSEL_19_SingleEnded = 0x0
	// Input channel is configured in differential mode
	ADC_DIFSEL_DIFSEL_19_Differential = 0x1
	// Position of DIFSEL_110 field.
	ADC_DIFSEL_DIFSEL_110_Pos = 0xa
	// Bit mask of DIFSEL_110 field.
	ADC_DIFSEL_DIFSEL_110_Msk = 0x400
	// Bit DIFSEL_110.
	ADC_DIFSEL_DIFSEL_110 = 0x400
	// Input channel is configured in single-ended mode
	ADC_DIFSEL_DIFSEL_110_SingleEnded = 0x0
	// Input channel is configured in differential mode
	ADC_DIFSEL_DIFSEL_110_Differential = 0x1
	// Position of DIFSEL_111 field.
	ADC_DIFSEL_DIFSEL_111_Pos = 0xb
	// Bit mask of DIFSEL_111 field.
	ADC_DIFSEL_DIFSEL_111_Msk = 0x800
	// Bit DIFSEL_111.
	ADC_DIFSEL_DIFSEL_111 = 0x800
	// Input channel is configured in single-ended mode
	ADC_DIFSEL_DIFSEL_111_SingleEnded = 0x0
	// Input channel is configured in differential mode
	ADC_DIFSEL_DIFSEL_111_Differential = 0x1
	// Position of DIFSEL_112 field.
	ADC_DIFSEL_DIFSEL_112_Pos = 0xc
	// Bit mask of DIFSEL_112 field.
	ADC_DIFSEL_DIFSEL_112_Msk = 0x1000
	// Bit DIFSEL_112.
	ADC_DIFSEL_DIFSEL_112 = 0x1000
	// Input channel is configured in single-ended mode
	ADC_DIFSEL_DIFSEL_112_SingleEnded = 0x0
	// Input channel is configured in differential mode
	ADC_DIFSEL_DIFSEL_112_Differential = 0x1
	// Position of DIFSEL_113 field.
	ADC_DIFSEL_DIFSEL_113_Pos = 0xd
	// Bit mask of DIFSEL_113 field.
	ADC_DIFSEL_DIFSEL_113_Msk = 0x2000
	// Bit DIFSEL_113.
	ADC_DIFSEL_DIFSEL_113 = 0x2000
	// Input channel is configured in single-ended mode
	ADC_DIFSEL_DIFSEL_113_SingleEnded = 0x0
	// Input channel is configured in differential mode
	ADC_DIFSEL_DIFSEL_113_Differential = 0x1
	// Position of DIFSEL_114 field.
	ADC_DIFSEL_DIFSEL_114_Pos = 0xe
	// Bit mask of DIFSEL_114 field.
	ADC_DIFSEL_DIFSEL_114_Msk = 0x4000
	// Bit DIFSEL_114.
	ADC_DIFSEL_DIFSEL_114 = 0x4000
	// Input channel is configured in single-ended mode
	ADC_DIFSEL_DIFSEL_114_SingleEnded = 0x0
	// Input channel is configured in differential mode
	ADC_DIFSEL_DIFSEL_114_Differential = 0x1
	// Position of DIFSEL_115 field.
	ADC_DIFSEL_DIFSEL_115_Pos = 0xf
	// Bit mask of DIFSEL_115 field.
	ADC_DIFSEL_DIFSEL_115_Msk = 0x8000
	// Bit DIFSEL_115.
	ADC_DIFSEL_DIFSEL_115 = 0x8000
	// Input channel is configured in single-ended mode
	ADC_DIFSEL_DIFSEL_115_SingleEnded = 0x0
	// Input channel is configured in differential mode
	ADC_DIFSEL_DIFSEL_115_Differential = 0x1
	// Position of DIFSEL_116 field.
	ADC_DIFSEL_DIFSEL_116_Pos = 0x10
	// Bit mask of DIFSEL_116 field.
	ADC_DIFSEL_DIFSEL_116_Msk = 0x10000
	// Bit DIFSEL_116.
	ADC_DIFSEL_DIFSEL_116 = 0x10000
	// Input channel is configured in single-ended mode
	ADC_DIFSEL_DIFSEL_116_SingleEnded = 0x0
	// Input channel is configured in differential mode
	ADC_DIFSEL_DIFSEL_116_Differential = 0x1
	// Position of DIFSEL_117 field.
	ADC_DIFSEL_DIFSEL_117_Pos = 0x11
	// Bit mask of DIFSEL_117 field.
	ADC_DIFSEL_DIFSEL_117_Msk = 0x20000
	// Bit DIFSEL_117.
	ADC_DIFSEL_DIFSEL_117 = 0x20000
	// Input channel is configured in single-ended mode
	ADC_DIFSEL_DIFSEL_117_SingleEnded = 0x0
	// Input channel is configured in differential mode
	ADC_DIFSEL_DIFSEL_117_Differential = 0x1

	// CALFACT: Calibration Factors
	// Position of CALFACT_D field.
	ADC_CALFACT_CALFACT_D_Pos = 0x10
	// Bit mask of CALFACT_D field.
	ADC_CALFACT_CALFACT_D_Msk = 0x7f0000
	// Position of CALFACT_S field.
	ADC_CALFACT_CALFACT_S_Pos = 0x0
	// Bit mask of CALFACT_S field.
	ADC_CALFACT_CALFACT_S_Msk = 0x7f
)

// Bitfields for FMC: Flexible memory controller
const (
	// BCR1: SRAM/NOR-Flash chip-select control register 1
	// Position of CCLKEN field.
	FMC_BCR1_CCLKEN_Pos = 0x14
	// Bit mask of CCLKEN field.
	FMC_BCR1_CCLKEN_Msk = 0x100000
	// Bit CCLKEN.
	FMC_BCR1_CCLKEN = 0x100000
	// Position of CBURSTRW field.
	FMC_BCR1_CBURSTRW_Pos = 0x13
	// Bit mask of CBURSTRW field.
	FMC_BCR1_CBURSTRW_Msk = 0x80000
	// Bit CBURSTRW.
	FMC_BCR1_CBURSTRW = 0x80000
	// Position of ASYNCWAIT field.
	FMC_BCR1_ASYNCWAIT_Pos = 0xf
	// Bit mask of ASYNCWAIT field.
	FMC_BCR1_ASYNCWAIT_Msk = 0x8000
	// Bit ASYNCWAIT.
	FMC_BCR1_ASYNCWAIT = 0x8000
	// Position of EXTMOD field.
	FMC_BCR1_EXTMOD_Pos = 0xe
	// Bit mask of EXTMOD field.
	FMC_BCR1_EXTMOD_Msk = 0x4000
	// Bit EXTMOD.
	FMC_BCR1_EXTMOD = 0x4000
	// Position of WAITEN field.
	FMC_BCR1_WAITEN_Pos = 0xd
	// Bit mask of WAITEN field.
	FMC_BCR1_WAITEN_Msk = 0x2000
	// Bit WAITEN.
	FMC_BCR1_WAITEN = 0x2000
	// Position of WREN field.
	FMC_BCR1_WREN_Pos = 0xc
	// Bit mask of WREN field.
	FMC_BCR1_WREN_Msk = 0x1000
	// Bit WREN.
	FMC_BCR1_WREN = 0x1000
	// Position of WAITCFG field.
	FMC_BCR1_WAITCFG_Pos = 0xb
	// Bit mask of WAITCFG field.
	FMC_BCR1_WAITCFG_Msk = 0x800
	// Bit WAITCFG.
	FMC_BCR1_WAITCFG = 0x800
	// Position of WAITPOL field.
	FMC_BCR1_WAITPOL_Pos = 0x9
	// Bit mask of WAITPOL field.
	FMC_BCR1_WAITPOL_Msk = 0x200
	// Bit WAITPOL.
	FMC_BCR1_WAITPOL = 0x200
	// Position of BURSTEN field.
	FMC_BCR1_BURSTEN_Pos = 0x8
	// Bit mask of BURSTEN field.
	FMC_BCR1_BURSTEN_Msk = 0x100
	// Bit BURSTEN.
	FMC_BCR1_BURSTEN = 0x100
	// Position of FACCEN field.
	FMC_BCR1_FACCEN_Pos = 0x6
	// Bit mask of FACCEN field.
	FMC_BCR1_FACCEN_Msk = 0x40
	// Bit FACCEN.
	FMC_BCR1_FACCEN = 0x40
	// Position of MWID field.
	FMC_BCR1_MWID_Pos = 0x4
	// Bit mask of MWID field.
	FMC_BCR1_MWID_Msk = 0x30
	// Position of MTYP field.
	FMC_BCR1_MTYP_Pos = 0x2
	// Bit mask of MTYP field.
	FMC_BCR1_MTYP_Msk = 0xc
	// Position of MUXEN field.
	FMC_BCR1_MUXEN_Pos = 0x1
	// Bit mask of MUXEN field.
	FMC_BCR1_MUXEN_Msk = 0x2
	// Bit MUXEN.
	FMC_BCR1_MUXEN = 0x2
	// Position of MBKEN field.
	FMC_BCR1_MBKEN_Pos = 0x0
	// Bit mask of MBKEN field.
	FMC_BCR1_MBKEN_Msk = 0x1
	// Bit MBKEN.
	FMC_BCR1_MBKEN = 0x1

	// BTR1: SRAM/NOR-Flash chip-select timing register 1
	// Position of ACCMOD field.
	FMC_BTR1_ACCMOD_Pos = 0x1c
	// Bit mask of ACCMOD field.
	FMC_BTR1_ACCMOD_Msk = 0x30000000
	// Position of DATLAT field.
	FMC_BTR1_DATLAT_Pos = 0x18
	// Bit mask of DATLAT field.
	FMC_BTR1_DATLAT_Msk = 0xf000000
	// Position of CLKDIV field.
	FMC_BTR1_CLKDIV_Pos = 0x14
	// Bit mask of CLKDIV field.
	FMC_BTR1_CLKDIV_Msk = 0xf00000
	// Position of BUSTURN field.
	FMC_BTR1_BUSTURN_Pos = 0x10
	// Bit mask of BUSTURN field.
	FMC_BTR1_BUSTURN_Msk = 0xf0000
	// Position of DATAST field.
	FMC_BTR1_DATAST_Pos = 0x8
	// Bit mask of DATAST field.
	FMC_BTR1_DATAST_Msk = 0xff00
	// Position of ADDHLD field.
	FMC_BTR1_ADDHLD_Pos = 0x4
	// Bit mask of ADDHLD field.
	FMC_BTR1_ADDHLD_Msk = 0xf0
	// Position of ADDSET field.
	FMC_BTR1_ADDSET_Pos = 0x0
	// Bit mask of ADDSET field.
	FMC_BTR1_ADDSET_Msk = 0xf

	// BCR2: SRAM/NOR-Flash chip-select control register 2
	// Position of CBURSTRW field.
	FMC_BCR2_CBURSTRW_Pos = 0x13
	// Bit mask of CBURSTRW field.
	FMC_BCR2_CBURSTRW_Msk = 0x80000
	// Bit CBURSTRW.
	FMC_BCR2_CBURSTRW = 0x80000
	// Position of ASYNCWAIT field.
	FMC_BCR2_ASYNCWAIT_Pos = 0xf
	// Bit mask of ASYNCWAIT field.
	FMC_BCR2_ASYNCWAIT_Msk = 0x8000
	// Bit ASYNCWAIT.
	FMC_BCR2_ASYNCWAIT = 0x8000
	// Position of EXTMOD field.
	FMC_BCR2_EXTMOD_Pos = 0xe
	// Bit mask of EXTMOD field.
	FMC_BCR2_EXTMOD_Msk = 0x4000
	// Bit EXTMOD.
	FMC_BCR2_EXTMOD = 0x4000
	// Position of WAITEN field.
	FMC_BCR2_WAITEN_Pos = 0xd
	// Bit mask of WAITEN field.
	FMC_BCR2_WAITEN_Msk = 0x2000
	// Bit WAITEN.
	FMC_BCR2_WAITEN = 0x2000
	// Position of WREN field.
	FMC_BCR2_WREN_Pos = 0xc
	// Bit mask of WREN field.
	FMC_BCR2_WREN_Msk = 0x1000
	// Bit WREN.
	FMC_BCR2_WREN = 0x1000
	// Position of WAITCFG field.
	FMC_BCR2_WAITCFG_Pos = 0xb
	// Bit mask of WAITCFG field.
	FMC_BCR2_WAITCFG_Msk = 0x800
	// Bit WAITCFG.
	FMC_BCR2_WAITCFG = 0x800
	// Position of WRAPMOD field.
	FMC_BCR2_WRAPMOD_Pos = 0xa
	// Bit mask of WRAPMOD field.
	FMC_BCR2_WRAPMOD_Msk = 0x400
	// Bit WRAPMOD.
	FMC_BCR2_WRAPMOD = 0x400
	// Position of WAITPOL field.
	FMC_BCR2_WAITPOL_Pos = 0x9
	// Bit mask of WAITPOL field.
	FMC_BCR2_WAITPOL_Msk = 0x200
	// Bit WAITPOL.
	FMC_BCR2_WAITPOL = 0x200
	// Position of BURSTEN field.
	FMC_BCR2_BURSTEN_Pos = 0x8
	// Bit mask of BURSTEN field.
	FMC_BCR2_BURSTEN_Msk = 0x100
	// Bit BURSTEN.
	FMC_BCR2_BURSTEN = 0x100
	// Position of FACCEN field.
	FMC_BCR2_FACCEN_Pos = 0x6
	// Bit mask of FACCEN field.
	FMC_BCR2_FACCEN_Msk = 0x40
	// Bit FACCEN.
	FMC_BCR2_FACCEN = 0x40
	// Position of MWID field.
	FMC_BCR2_MWID_Pos = 0x4
	// Bit mask of MWID field.
	FMC_BCR2_MWID_Msk = 0x30
	// Position of MTYP field.
	FMC_BCR2_MTYP_Pos = 0x2
	// Bit mask of MTYP field.
	FMC_BCR2_MTYP_Msk = 0xc
	// Position of MUXEN field.
	FMC_BCR2_MUXEN_Pos = 0x1
	// Bit mask of MUXEN field.
	FMC_BCR2_MUXEN_Msk = 0x2
	// Bit MUXEN.
	FMC_BCR2_MUXEN = 0x2
	// Position of MBKEN field.
	FMC_BCR2_MBKEN_Pos = 0x0
	// Bit mask of MBKEN field.
	FMC_BCR2_MBKEN_Msk = 0x1
	// Bit MBKEN.
	FMC_BCR2_MBKEN = 0x1

	// BTR2: SRAM/NOR-Flash chip-select timing register 2
	// Position of ACCMOD field.
	FMC_BTR2_ACCMOD_Pos = 0x1c
	// Bit mask of ACCMOD field.
	FMC_BTR2_ACCMOD_Msk = 0x30000000
	// Position of DATLAT field.
	FMC_BTR2_DATLAT_Pos = 0x18
	// Bit mask of DATLAT field.
	FMC_BTR2_DATLAT_Msk = 0xf000000
	// Position of CLKDIV field.
	FMC_BTR2_CLKDIV_Pos = 0x14
	// Bit mask of CLKDIV field.
	FMC_BTR2_CLKDIV_Msk = 0xf00000
	// Position of BUSTURN field.
	FMC_BTR2_BUSTURN_Pos = 0x10
	// Bit mask of BUSTURN field.
	FMC_BTR2_BUSTURN_Msk = 0xf0000
	// Position of DATAST field.
	FMC_BTR2_DATAST_Pos = 0x8
	// Bit mask of DATAST field.
	FMC_BTR2_DATAST_Msk = 0xff00
	// Position of ADDHLD field.
	FMC_BTR2_ADDHLD_Pos = 0x4
	// Bit mask of ADDHLD field.
	FMC_BTR2_ADDHLD_Msk = 0xf0
	// Position of ADDSET field.
	FMC_BTR2_ADDSET_Pos = 0x0
	// Bit mask of ADDSET field.
	FMC_BTR2_ADDSET_Msk = 0xf

	// BCR3: SRAM/NOR-Flash chip-select control register 3
	// Position of CBURSTRW field.
	FMC_BCR3_CBURSTRW_Pos = 0x13
	// Bit mask of CBURSTRW field.
	FMC_BCR3_CBURSTRW_Msk = 0x80000
	// Bit CBURSTRW.
	FMC_BCR3_CBURSTRW = 0x80000
	// Position of ASYNCWAIT field.
	FMC_BCR3_ASYNCWAIT_Pos = 0xf
	// Bit mask of ASYNCWAIT field.
	FMC_BCR3_ASYNCWAIT_Msk = 0x8000
	// Bit ASYNCWAIT.
	FMC_BCR3_ASYNCWAIT = 0x8000
	// Position of EXTMOD field.
	FMC_BCR3_EXTMOD_Pos = 0xe
	// Bit mask of EXTMOD field.
	FMC_BCR3_EXTMOD_Msk = 0x4000
	// Bit EXTMOD.
	FMC_BCR3_EXTMOD = 0x4000
	// Position of WAITEN field.
	FMC_BCR3_WAITEN_Pos = 0xd
	// Bit mask of WAITEN field.
	FMC_BCR3_WAITEN_Msk = 0x2000
	// Bit WAITEN.
	FMC_BCR3_WAITEN = 0x2000
	// Position of WREN field.
	FMC_BCR3_WREN_Pos = 0xc
	// Bit mask of WREN field.
	FMC_BCR3_WREN_Msk = 0x1000
	// Bit WREN.
	FMC_BCR3_WREN = 0x1000
	// Position of WAITCFG field.
	FMC_BCR3_WAITCFG_Pos = 0xb
	// Bit mask of WAITCFG field.
	FMC_BCR3_WAITCFG_Msk = 0x800
	// Bit WAITCFG.
	FMC_BCR3_WAITCFG = 0x800
	// Position of WRAPMOD field.
	FMC_BCR3_WRAPMOD_Pos = 0xa
	// Bit mask of WRAPMOD field.
	FMC_BCR3_WRAPMOD_Msk = 0x400
	// Bit WRAPMOD.
	FMC_BCR3_WRAPMOD = 0x400
	// Position of WAITPOL field.
	FMC_BCR3_WAITPOL_Pos = 0x9
	// Bit mask of WAITPOL field.
	FMC_BCR3_WAITPOL_Msk = 0x200
	// Bit WAITPOL.
	FMC_BCR3_WAITPOL = 0x200
	// Position of BURSTEN field.
	FMC_BCR3_BURSTEN_Pos = 0x8
	// Bit mask of BURSTEN field.
	FMC_BCR3_BURSTEN_Msk = 0x100
	// Bit BURSTEN.
	FMC_BCR3_BURSTEN = 0x100
	// Position of FACCEN field.
	FMC_BCR3_FACCEN_Pos = 0x6
	// Bit mask of FACCEN field.
	FMC_BCR3_FACCEN_Msk = 0x40
	// Bit FACCEN.
	FMC_BCR3_FACCEN = 0x40
	// Position of MWID field.
	FMC_BCR3_MWID_Pos = 0x4
	// Bit mask of MWID field.
	FMC_BCR3_MWID_Msk = 0x30
	// Position of MTYP field.
	FMC_BCR3_MTYP_Pos = 0x2
	// Bit mask of MTYP field.
	FMC_BCR3_MTYP_Msk = 0xc
	// Position of MUXEN field.
	FMC_BCR3_MUXEN_Pos = 0x1
	// Bit mask of MUXEN field.
	FMC_BCR3_MUXEN_Msk = 0x2
	// Bit MUXEN.
	FMC_BCR3_MUXEN = 0x2
	// Position of MBKEN field.
	FMC_BCR3_MBKEN_Pos = 0x0
	// Bit mask of MBKEN field.
	FMC_BCR3_MBKEN_Msk = 0x1
	// Bit MBKEN.
	FMC_BCR3_MBKEN = 0x1

	// BTR3: SRAM/NOR-Flash chip-select timing register 3
	// Position of ACCMOD field.
	FMC_BTR3_ACCMOD_Pos = 0x1c
	// Bit mask of ACCMOD field.
	FMC_BTR3_ACCMOD_Msk = 0x30000000
	// Position of DATLAT field.
	FMC_BTR3_DATLAT_Pos = 0x18
	// Bit mask of DATLAT field.
	FMC_BTR3_DATLAT_Msk = 0xf000000
	// Position of CLKDIV field.
	FMC_BTR3_CLKDIV_Pos = 0x14
	// Bit mask of CLKDIV field.
	FMC_BTR3_CLKDIV_Msk = 0xf00000
	// Position of BUSTURN field.
	FMC_BTR3_BUSTURN_Pos = 0x10
	// Bit mask of BUSTURN field.
	FMC_BTR3_BUSTURN_Msk = 0xf0000
	// Position of DATAST field.
	FMC_BTR3_DATAST_Pos = 0x8
	// Bit mask of DATAST field.
	FMC_BTR3_DATAST_Msk = 0xff00
	// Position of ADDHLD field.
	FMC_BTR3_ADDHLD_Pos = 0x4
	// Bit mask of ADDHLD field.
	FMC_BTR3_ADDHLD_Msk = 0xf0
	// Position of ADDSET field.
	FMC_BTR3_ADDSET_Pos = 0x0
	// Bit mask of ADDSET field.
	FMC_BTR3_ADDSET_Msk = 0xf

	// BCR4: SRAM/NOR-Flash chip-select control register 4
	// Position of CBURSTRW field.
	FMC_BCR4_CBURSTRW_Pos = 0x13
	// Bit mask of CBURSTRW field.
	FMC_BCR4_CBURSTRW_Msk = 0x80000
	// Bit CBURSTRW.
	FMC_BCR4_CBURSTRW = 0x80000
	// Position of ASYNCWAIT field.
	FMC_BCR4_ASYNCWAIT_Pos = 0xf
	// Bit mask of ASYNCWAIT field.
	FMC_BCR4_ASYNCWAIT_Msk = 0x8000
	// Bit ASYNCWAIT.
	FMC_BCR4_ASYNCWAIT = 0x8000
	// Position of EXTMOD field.
	FMC_BCR4_EXTMOD_Pos = 0xe
	// Bit mask of EXTMOD field.
	FMC_BCR4_EXTMOD_Msk = 0x4000
	// Bit EXTMOD.
	FMC_BCR4_EXTMOD = 0x4000
	// Position of WAITEN field.
	FMC_BCR4_WAITEN_Pos = 0xd
	// Bit mask of WAITEN field.
	FMC_BCR4_WAITEN_Msk = 0x2000
	// Bit WAITEN.
	FMC_BCR4_WAITEN = 0x2000
	// Position of WREN field.
	FMC_BCR4_WREN_Pos = 0xc
	// Bit mask of WREN field.
	FMC_BCR4_WREN_Msk = 0x1000
	// Bit WREN.
	FMC_BCR4_WREN = 0x1000
	// Position of WAITCFG field.
	FMC_BCR4_WAITCFG_Pos = 0xb
	// Bit mask of WAITCFG field.
	FMC_BCR4_WAITCFG_Msk = 0x800
	// Bit WAITCFG.
	FMC_BCR4_WAITCFG = 0x800
	// Position of WRAPMOD field.
	FMC_BCR4_WRAPMOD_Pos = 0xa
	// Bit mask of WRAPMOD field.
	FMC_BCR4_WRAPMOD_Msk = 0x400
	// Bit WRAPMOD.
	FMC_BCR4_WRAPMOD = 0x400
	// Position of WAITPOL field.
	FMC_BCR4_WAITPOL_Pos = 0x9
	// Bit mask of WAITPOL field.
	FMC_BCR4_WAITPOL_Msk = 0x200
	// Bit WAITPOL.
	FMC_BCR4_WAITPOL = 0x200
	// Position of BURSTEN field.
	FMC_BCR4_BURSTEN_Pos = 0x8
	// Bit mask of BURSTEN field.
	FMC_BCR4_BURSTEN_Msk = 0x100
	// Bit BURSTEN.
	FMC_BCR4_BURSTEN = 0x100
	// Position of FACCEN field.
	FMC_BCR4_FACCEN_Pos = 0x6
	// Bit mask of FACCEN field.
	FMC_BCR4_FACCEN_Msk = 0x40
	// Bit FACCEN.
	FMC_BCR4_FACCEN = 0x40
	// Position of MWID field.
	FMC_BCR4_MWID_Pos = 0x4
	// Bit mask of MWID field.
	FMC_BCR4_MWID_Msk = 0x30
	// Position of MTYP field.
	FMC_BCR4_MTYP_Pos = 0x2
	// Bit mask of MTYP field.
	FMC_BCR4_MTYP_Msk = 0xc
	// Position of MUXEN field.
	FMC_BCR4_MUXEN_Pos = 0x1
	// Bit mask of MUXEN field.
	FMC_BCR4_MUXEN_Msk = 0x2
	// Bit MUXEN.
	FMC_BCR4_MUXEN = 0x2
	// Position of MBKEN field.
	FMC_BCR4_MBKEN_Pos = 0x0
	// Bit mask of MBKEN field.
	FMC_BCR4_MBKEN_Msk = 0x1
	// Bit MBKEN.
	FMC_BCR4_MBKEN = 0x1

	// BTR4: SRAM/NOR-Flash chip-select timing register 4
	// Position of ACCMOD field.
	FMC_BTR4_ACCMOD_Pos = 0x1c
	// Bit mask of ACCMOD field.
	FMC_BTR4_ACCMOD_Msk = 0x30000000
	// Position of DATLAT field.
	FMC_BTR4_DATLAT_Pos = 0x18
	// Bit mask of DATLAT field.
	FMC_BTR4_DATLAT_Msk = 0xf000000
	// Position of CLKDIV field.
	FMC_BTR4_CLKDIV_Pos = 0x14
	// Bit mask of CLKDIV field.
	FMC_BTR4_CLKDIV_Msk = 0xf00000
	// Position of BUSTURN field.
	FMC_BTR4_BUSTURN_Pos = 0x10
	// Bit mask of BUSTURN field.
	FMC_BTR4_BUSTURN_Msk = 0xf0000
	// Position of DATAST field.
	FMC_BTR4_DATAST_Pos = 0x8
	// Bit mask of DATAST field.
	FMC_BTR4_DATAST_Msk = 0xff00
	// Position of ADDHLD field.
	FMC_BTR4_ADDHLD_Pos = 0x4
	// Bit mask of ADDHLD field.
	FMC_BTR4_ADDHLD_Msk = 0xf0
	// Position of ADDSET field.
	FMC_BTR4_ADDSET_Pos = 0x0
	// Bit mask of ADDSET field.
	FMC_BTR4_ADDSET_Msk = 0xf

	// PCR2: PC Card/NAND Flash control register 2
	// Position of ECCPS field.
	FMC_PCR2_ECCPS_Pos = 0x11
	// Bit mask of ECCPS field.
	FMC_PCR2_ECCPS_Msk = 0xe0000
	// Position of TAR field.
	FMC_PCR2_TAR_Pos = 0xd
	// Bit mask of TAR field.
	FMC_PCR2_TAR_Msk = 0x1e000
	// Position of TCLR field.
	FMC_PCR2_TCLR_Pos = 0x9
	// Bit mask of TCLR field.
	FMC_PCR2_TCLR_Msk = 0x1e00
	// Position of ECCEN field.
	FMC_PCR2_ECCEN_Pos = 0x6
	// Bit mask of ECCEN field.
	FMC_PCR2_ECCEN_Msk = 0x40
	// Bit ECCEN.
	FMC_PCR2_ECCEN = 0x40
	// Position of PWID field.
	FMC_PCR2_PWID_Pos = 0x4
	// Bit mask of PWID field.
	FMC_PCR2_PWID_Msk = 0x30
	// Position of PTYP field.
	FMC_PCR2_PTYP_Pos = 0x3
	// Bit mask of PTYP field.
	FMC_PCR2_PTYP_Msk = 0x8
	// Bit PTYP.
	FMC_PCR2_PTYP = 0x8
	// Position of PBKEN field.
	FMC_PCR2_PBKEN_Pos = 0x2
	// Bit mask of PBKEN field.
	FMC_PCR2_PBKEN_Msk = 0x4
	// Bit PBKEN.
	FMC_PCR2_PBKEN = 0x4
	// Position of PWAITEN field.
	FMC_PCR2_PWAITEN_Pos = 0x1
	// Bit mask of PWAITEN field.
	FMC_PCR2_PWAITEN_Msk = 0x2
	// Bit PWAITEN.
	FMC_PCR2_PWAITEN = 0x2

	// SR2: FIFO status and interrupt register 2
	// Position of FEMPT field.
	FMC_SR2_FEMPT_Pos = 0x6
	// Bit mask of FEMPT field.
	FMC_SR2_FEMPT_Msk = 0x40
	// Bit FEMPT.
	FMC_SR2_FEMPT = 0x40
	// Position of IFEN field.
	FMC_SR2_IFEN_Pos = 0x5
	// Bit mask of IFEN field.
	FMC_SR2_IFEN_Msk = 0x20
	// Bit IFEN.
	FMC_SR2_IFEN = 0x20
	// Position of ILEN field.
	FMC_SR2_ILEN_Pos = 0x4
	// Bit mask of ILEN field.
	FMC_SR2_ILEN_Msk = 0x10
	// Bit ILEN.
	FMC_SR2_ILEN = 0x10
	// Position of IREN field.
	FMC_SR2_IREN_Pos = 0x3
	// Bit mask of IREN field.
	FMC_SR2_IREN_Msk = 0x8
	// Bit IREN.
	FMC_SR2_IREN = 0x8
	// Position of IFS field.
	FMC_SR2_IFS_Pos = 0x2
	// Bit mask of IFS field.
	FMC_SR2_IFS_Msk = 0x4
	// Bit IFS.
	FMC_SR2_IFS = 0x4
	// Position of ILS field.
	FMC_SR2_ILS_Pos = 0x1
	// Bit mask of ILS field.
	FMC_SR2_ILS_Msk = 0x2
	// Bit ILS.
	FMC_SR2_ILS = 0x2
	// Position of IRS field.
	FMC_SR2_IRS_Pos = 0x0
	// Bit mask of IRS field.
	FMC_SR2_IRS_Msk = 0x1
	// Bit IRS.
	FMC_SR2_IRS = 0x1

	// PMEM2: Common memory space timing register 2
	// Position of MEMHIZx field.
	FMC_PMEM2_MEMHIZx_Pos = 0x18
	// Bit mask of MEMHIZx field.
	FMC_PMEM2_MEMHIZx_Msk = 0xff000000
	// Position of MEMHOLDx field.
	FMC_PMEM2_MEMHOLDx_Pos = 0x10
	// Bit mask of MEMHOLDx field.
	FMC_PMEM2_MEMHOLDx_Msk = 0xff0000
	// Position of MEMWAITx field.
	FMC_PMEM2_MEMWAITx_Pos = 0x8
	// Bit mask of MEMWAITx field.
	FMC_PMEM2_MEMWAITx_Msk = 0xff00
	// Position of MEMSETx field.
	FMC_PMEM2_MEMSETx_Pos = 0x0
	// Bit mask of MEMSETx field.
	FMC_PMEM2_MEMSETx_Msk = 0xff

	// PATT2: Attribute memory space timing register 2
	// Position of ATTHIZx field.
	FMC_PATT2_ATTHIZx_Pos = 0x18
	// Bit mask of ATTHIZx field.
	FMC_PATT2_ATTHIZx_Msk = 0xff000000
	// Position of ATTHOLDx field.
	FMC_PATT2_ATTHOLDx_Pos = 0x10
	// Bit mask of ATTHOLDx field.
	FMC_PATT2_ATTHOLDx_Msk = 0xff0000
	// Position of ATTWAITx field.
	FMC_PATT2_ATTWAITx_Pos = 0x8
	// Bit mask of ATTWAITx field.
	FMC_PATT2_ATTWAITx_Msk = 0xff00
	// Position of ATTSETx field.
	FMC_PATT2_ATTSETx_Pos = 0x0
	// Bit mask of ATTSETx field.
	FMC_PATT2_ATTSETx_Msk = 0xff

	// ECCR2: ECC result register 2
	// Position of ECCx field.
	FMC_ECCR2_ECCx_Pos = 0x0
	// Bit mask of ECCx field.
	FMC_ECCR2_ECCx_Msk = 0xffffffff

	// PCR3: PC Card/NAND Flash control register 3
	// Position of ECCPS field.
	FMC_PCR3_ECCPS_Pos = 0x11
	// Bit mask of ECCPS field.
	FMC_PCR3_ECCPS_Msk = 0xe0000
	// Position of TAR field.
	FMC_PCR3_TAR_Pos = 0xd
	// Bit mask of TAR field.
	FMC_PCR3_TAR_Msk = 0x1e000
	// Position of TCLR field.
	FMC_PCR3_TCLR_Pos = 0x9
	// Bit mask of TCLR field.
	FMC_PCR3_TCLR_Msk = 0x1e00
	// Position of ECCEN field.
	FMC_PCR3_ECCEN_Pos = 0x6
	// Bit mask of ECCEN field.
	FMC_PCR3_ECCEN_Msk = 0x40
	// Bit ECCEN.
	FMC_PCR3_ECCEN = 0x40
	// Position of PWID field.
	FMC_PCR3_PWID_Pos = 0x4
	// Bit mask of PWID field.
	FMC_PCR3_PWID_Msk = 0x30
	// Position of PTYP field.
	FMC_PCR3_PTYP_Pos = 0x3
	// Bit mask of PTYP field.
	FMC_PCR3_PTYP_Msk = 0x8
	// Bit PTYP.
	FMC_PCR3_PTYP = 0x8
	// Position of PBKEN field.
	FMC_PCR3_PBKEN_Pos = 0x2
	// Bit mask of PBKEN field.
	FMC_PCR3_PBKEN_Msk = 0x4
	// Bit PBKEN.
	FMC_PCR3_PBKEN = 0x4
	// Position of PWAITEN field.
	FMC_PCR3_PWAITEN_Pos = 0x1
	// Bit mask of PWAITEN field.
	FMC_PCR3_PWAITEN_Msk = 0x2
	// Bit PWAITEN.
	FMC_PCR3_PWAITEN = 0x2

	// SR3: FIFO status and interrupt register 3
	// Position of FEMPT field.
	FMC_SR3_FEMPT_Pos = 0x6
	// Bit mask of FEMPT field.
	FMC_SR3_FEMPT_Msk = 0x40
	// Bit FEMPT.
	FMC_SR3_FEMPT = 0x40
	// Position of IFEN field.
	FMC_SR3_IFEN_Pos = 0x5
	// Bit mask of IFEN field.
	FMC_SR3_IFEN_Msk = 0x20
	// Bit IFEN.
	FMC_SR3_IFEN = 0x20
	// Position of ILEN field.
	FMC_SR3_ILEN_Pos = 0x4
	// Bit mask of ILEN field.
	FMC_SR3_ILEN_Msk = 0x10
	// Bit ILEN.
	FMC_SR3_ILEN = 0x10
	// Position of IREN field.
	FMC_SR3_IREN_Pos = 0x3
	// Bit mask of IREN field.
	FMC_SR3_IREN_Msk = 0x8
	// Bit IREN.
	FMC_SR3_IREN = 0x8
	// Position of IFS field.
	FMC_SR3_IFS_Pos = 0x2
	// Bit mask of IFS field.
	FMC_SR3_IFS_Msk = 0x4
	// Bit IFS.
	FMC_SR3_IFS = 0x4
	// Position of ILS field.
	FMC_SR3_ILS_Pos = 0x1
	// Bit mask of ILS field.
	FMC_SR3_ILS_Msk = 0x2
	// Bit ILS.
	FMC_SR3_ILS = 0x2
	// Position of IRS field.
	FMC_SR3_IRS_Pos = 0x0
	// Bit mask of IRS field.
	FMC_SR3_IRS_Msk = 0x1
	// Bit IRS.
	FMC_SR3_IRS = 0x1

	// PMEM3: Common memory space timing register 3
	// Position of MEMHIZx field.
	FMC_PMEM3_MEMHIZx_Pos = 0x18
	// Bit mask of MEMHIZx field.
	FMC_PMEM3_MEMHIZx_Msk = 0xff000000
	// Position of MEMHOLDx field.
	FMC_PMEM3_MEMHOLDx_Pos = 0x10
	// Bit mask of MEMHOLDx field.
	FMC_PMEM3_MEMHOLDx_Msk = 0xff0000
	// Position of MEMWAITx field.
	FMC_PMEM3_MEMWAITx_Pos = 0x8
	// Bit mask of MEMWAITx field.
	FMC_PMEM3_MEMWAITx_Msk = 0xff00
	// Position of MEMSETx field.
	FMC_PMEM3_MEMSETx_Pos = 0x0
	// Bit mask of MEMSETx field.
	FMC_PMEM3_MEMSETx_Msk = 0xff

	// PATT3: Attribute memory space timing register 3
	// Position of ATTHIZx field.
	FMC_PATT3_ATTHIZx_Pos = 0x18
	// Bit mask of ATTHIZx field.
	FMC_PATT3_ATTHIZx_Msk = 0xff000000
	// Position of ATTHOLDx field.
	FMC_PATT3_ATTHOLDx_Pos = 0x10
	// Bit mask of ATTHOLDx field.
	FMC_PATT3_ATTHOLDx_Msk = 0xff0000
	// Position of ATTWAITx field.
	FMC_PATT3_ATTWAITx_Pos = 0x8
	// Bit mask of ATTWAITx field.
	FMC_PATT3_ATTWAITx_Msk = 0xff00
	// Position of ATTSETx field.
	FMC_PATT3_ATTSETx_Pos = 0x0
	// Bit mask of ATTSETx field.
	FMC_PATT3_ATTSETx_Msk = 0xff

	// ECCR3: ECC result register 3
	// Position of ECCx field.
	FMC_ECCR3_ECCx_Pos = 0x0
	// Bit mask of ECCx field.
	FMC_ECCR3_ECCx_Msk = 0xffffffff

	// PCR4: PC Card/NAND Flash control register 4
	// Position of ECCPS field.
	FMC_PCR4_ECCPS_Pos = 0x11
	// Bit mask of ECCPS field.
	FMC_PCR4_ECCPS_Msk = 0xe0000
	// Position of TAR field.
	FMC_PCR4_TAR_Pos = 0xd
	// Bit mask of TAR field.
	FMC_PCR4_TAR_Msk = 0x1e000
	// Position of TCLR field.
	FMC_PCR4_TCLR_Pos = 0x9
	// Bit mask of TCLR field.
	FMC_PCR4_TCLR_Msk = 0x1e00
	// Position of ECCEN field.
	FMC_PCR4_ECCEN_Pos = 0x6
	// Bit mask of ECCEN field.
	FMC_PCR4_ECCEN_Msk = 0x40
	// Bit ECCEN.
	FMC_PCR4_ECCEN = 0x40
	// Position of PWID field.
	FMC_PCR4_PWID_Pos = 0x4
	// Bit mask of PWID field.
	FMC_PCR4_PWID_Msk = 0x30
	// Position of PTYP field.
	FMC_PCR4_PTYP_Pos = 0x3
	// Bit mask of PTYP field.
	FMC_PCR4_PTYP_Msk = 0x8
	// Bit PTYP.
	FMC_PCR4_PTYP = 0x8
	// Position of PBKEN field.
	FMC_PCR4_PBKEN_Pos = 0x2
	// Bit mask of PBKEN field.
	FMC_PCR4_PBKEN_Msk = 0x4
	// Bit PBKEN.
	FMC_PCR4_PBKEN = 0x4
	// Position of PWAITEN field.
	FMC_PCR4_PWAITEN_Pos = 0x1
	// Bit mask of PWAITEN field.
	FMC_PCR4_PWAITEN_Msk = 0x2
	// Bit PWAITEN.
	FMC_PCR4_PWAITEN = 0x2

	// SR4: FIFO status and interrupt register 4
	// Position of FEMPT field.
	FMC_SR4_FEMPT_Pos = 0x6
	// Bit mask of FEMPT field.
	FMC_SR4_FEMPT_Msk = 0x40
	// Bit FEMPT.
	FMC_SR4_FEMPT = 0x40
	// Position of IFEN field.
	FMC_SR4_IFEN_Pos = 0x5
	// Bit mask of IFEN field.
	FMC_SR4_IFEN_Msk = 0x20
	// Bit IFEN.
	FMC_SR4_IFEN = 0x20
	// Position of ILEN field.
	FMC_SR4_ILEN_Pos = 0x4
	// Bit mask of ILEN field.
	FMC_SR4_ILEN_Msk = 0x10
	// Bit ILEN.
	FMC_SR4_ILEN = 0x10
	// Position of IREN field.
	FMC_SR4_IREN_Pos = 0x3
	// Bit mask of IREN field.
	FMC_SR4_IREN_Msk = 0x8
	// Bit IREN.
	FMC_SR4_IREN = 0x8
	// Position of IFS field.
	FMC_SR4_IFS_Pos = 0x2
	// Bit mask of IFS field.
	FMC_SR4_IFS_Msk = 0x4
	// Bit IFS.
	FMC_SR4_IFS = 0x4
	// Position of ILS field.
	FMC_SR4_ILS_Pos = 0x1
	// Bit mask of ILS field.
	FMC_SR4_ILS_Msk = 0x2
	// Bit ILS.
	FMC_SR4_ILS = 0x2
	// Position of IRS field.
	FMC_SR4_IRS_Pos = 0x0
	// Bit mask of IRS field.
	FMC_SR4_IRS_Msk = 0x1
	// Bit IRS.
	FMC_SR4_IRS = 0x1

	// PMEM4: Common memory space timing register 4
	// Position of MEMHIZx field.
	FMC_PMEM4_MEMHIZx_Pos = 0x18
	// Bit mask of MEMHIZx field.
	FMC_PMEM4_MEMHIZx_Msk = 0xff000000
	// Position of MEMHOLDx field.
	FMC_PMEM4_MEMHOLDx_Pos = 0x10
	// Bit mask of MEMHOLDx field.
	FMC_PMEM4_MEMHOLDx_Msk = 0xff0000
	// Position of MEMWAITx field.
	FMC_PMEM4_MEMWAITx_Pos = 0x8
	// Bit mask of MEMWAITx field.
	FMC_PMEM4_MEMWAITx_Msk = 0xff00
	// Position of MEMSETx field.
	FMC_PMEM4_MEMSETx_Pos = 0x0
	// Bit mask of MEMSETx field.
	FMC_PMEM4_MEMSETx_Msk = 0xff

	// PATT4: Attribute memory space timing register 4
	// Position of ATTHIZx field.
	FMC_PATT4_ATTHIZx_Pos = 0x18
	// Bit mask of ATTHIZx field.
	FMC_PATT4_ATTHIZx_Msk = 0xff000000
	// Position of ATTHOLDx field.
	FMC_PATT4_ATTHOLDx_Pos = 0x10
	// Bit mask of ATTHOLDx field.
	FMC_PATT4_ATTHOLDx_Msk = 0xff0000
	// Position of ATTWAITx field.
	FMC_PATT4_ATTWAITx_Pos = 0x8
	// Bit mask of ATTWAITx field.
	FMC_PATT4_ATTWAITx_Msk = 0xff00
	// Position of ATTSETx field.
	FMC_PATT4_ATTSETx_Pos = 0x0
	// Bit mask of ATTSETx field.
	FMC_PATT4_ATTSETx_Msk = 0xff

	// PIO4: I/O space timing register 4
	// Position of IOHIZx field.
	FMC_PIO4_IOHIZx_Pos = 0x18
	// Bit mask of IOHIZx field.
	FMC_PIO4_IOHIZx_Msk = 0xff000000
	// Position of IOHOLDx field.
	FMC_PIO4_IOHOLDx_Pos = 0x10
	// Bit mask of IOHOLDx field.
	FMC_PIO4_IOHOLDx_Msk = 0xff0000
	// Position of IOWAITx field.
	FMC_PIO4_IOWAITx_Pos = 0x8
	// Bit mask of IOWAITx field.
	FMC_PIO4_IOWAITx_Msk = 0xff00
	// Position of IOSETx field.
	FMC_PIO4_IOSETx_Pos = 0x0
	// Bit mask of IOSETx field.
	FMC_PIO4_IOSETx_Msk = 0xff

	// BWTR1: SRAM/NOR-Flash write timing registers 1
	// Position of ACCMOD field.
	FMC_BWTR1_ACCMOD_Pos = 0x1c
	// Bit mask of ACCMOD field.
	FMC_BWTR1_ACCMOD_Msk = 0x30000000
	// Position of DATLAT field.
	FMC_BWTR1_DATLAT_Pos = 0x18
	// Bit mask of DATLAT field.
	FMC_BWTR1_DATLAT_Msk = 0xf000000
	// Position of CLKDIV field.
	FMC_BWTR1_CLKDIV_Pos = 0x14
	// Bit mask of CLKDIV field.
	FMC_BWTR1_CLKDIV_Msk = 0xf00000
	// Position of BUSTURN field.
	FMC_BWTR1_BUSTURN_Pos = 0x10
	// Bit mask of BUSTURN field.
	FMC_BWTR1_BUSTURN_Msk = 0xf0000
	// Position of DATAST field.
	FMC_BWTR1_DATAST_Pos = 0x8
	// Bit mask of DATAST field.
	FMC_BWTR1_DATAST_Msk = 0xff00
	// Position of ADDHLD field.
	FMC_BWTR1_ADDHLD_Pos = 0x4
	// Bit mask of ADDHLD field.
	FMC_BWTR1_ADDHLD_Msk = 0xf0
	// Position of ADDSET field.
	FMC_BWTR1_ADDSET_Pos = 0x0
	// Bit mask of ADDSET field.
	FMC_BWTR1_ADDSET_Msk = 0xf

	// BWTR2: SRAM/NOR-Flash write timing registers 2
	// Position of ACCMOD field.
	FMC_BWTR2_ACCMOD_Pos = 0x1c
	// Bit mask of ACCMOD field.
	FMC_BWTR2_ACCMOD_Msk = 0x30000000
	// Position of DATLAT field.
	FMC_BWTR2_DATLAT_Pos = 0x18
	// Bit mask of DATLAT field.
	FMC_BWTR2_DATLAT_Msk = 0xf000000
	// Position of CLKDIV field.
	FMC_BWTR2_CLKDIV_Pos = 0x14
	// Bit mask of CLKDIV field.
	FMC_BWTR2_CLKDIV_Msk = 0xf00000
	// Position of BUSTURN field.
	FMC_BWTR2_BUSTURN_Pos = 0x10
	// Bit mask of BUSTURN field.
	FMC_BWTR2_BUSTURN_Msk = 0xf0000
	// Position of DATAST field.
	FMC_BWTR2_DATAST_Pos = 0x8
	// Bit mask of DATAST field.
	FMC_BWTR2_DATAST_Msk = 0xff00
	// Position of ADDHLD field.
	FMC_BWTR2_ADDHLD_Pos = 0x4
	// Bit mask of ADDHLD field.
	FMC_BWTR2_ADDHLD_Msk = 0xf0
	// Position of ADDSET field.
	FMC_BWTR2_ADDSET_Pos = 0x0
	// Bit mask of ADDSET field.
	FMC_BWTR2_ADDSET_Msk = 0xf

	// BWTR3: SRAM/NOR-Flash write timing registers 3
	// Position of ACCMOD field.
	FMC_BWTR3_ACCMOD_Pos = 0x1c
	// Bit mask of ACCMOD field.
	FMC_BWTR3_ACCMOD_Msk = 0x30000000
	// Position of DATLAT field.
	FMC_BWTR3_DATLAT_Pos = 0x18
	// Bit mask of DATLAT field.
	FMC_BWTR3_DATLAT_Msk = 0xf000000
	// Position of CLKDIV field.
	FMC_BWTR3_CLKDIV_Pos = 0x14
	// Bit mask of CLKDIV field.
	FMC_BWTR3_CLKDIV_Msk = 0xf00000
	// Position of BUSTURN field.
	FMC_BWTR3_BUSTURN_Pos = 0x10
	// Bit mask of BUSTURN field.
	FMC_BWTR3_BUSTURN_Msk = 0xf0000
	// Position of DATAST field.
	FMC_BWTR3_DATAST_Pos = 0x8
	// Bit mask of DATAST field.
	FMC_BWTR3_DATAST_Msk = 0xff00
	// Position of ADDHLD field.
	FMC_BWTR3_ADDHLD_Pos = 0x4
	// Bit mask of ADDHLD field.
	FMC_BWTR3_ADDHLD_Msk = 0xf0
	// Position of ADDSET field.
	FMC_BWTR3_ADDSET_Pos = 0x0
	// Bit mask of ADDSET field.
	FMC_BWTR3_ADDSET_Msk = 0xf

	// BWTR4: SRAM/NOR-Flash write timing registers 4
	// Position of ACCMOD field.
	FMC_BWTR4_ACCMOD_Pos = 0x1c
	// Bit mask of ACCMOD field.
	FMC_BWTR4_ACCMOD_Msk = 0x30000000
	// Position of DATLAT field.
	FMC_BWTR4_DATLAT_Pos = 0x18
	// Bit mask of DATLAT field.
	FMC_BWTR4_DATLAT_Msk = 0xf000000
	// Position of CLKDIV field.
	FMC_BWTR4_CLKDIV_Pos = 0x14
	// Bit mask of CLKDIV field.
	FMC_BWTR4_CLKDIV_Msk = 0xf00000
	// Position of BUSTURN field.
	FMC_BWTR4_BUSTURN_Pos = 0x10
	// Bit mask of BUSTURN field.
	FMC_BWTR4_BUSTURN_Msk = 0xf0000
	// Position of DATAST field.
	FMC_BWTR4_DATAST_Pos = 0x8
	// Bit mask of DATAST field.
	FMC_BWTR4_DATAST_Msk = 0xff00
	// Position of ADDHLD field.
	FMC_BWTR4_ADDHLD_Pos = 0x4
	// Bit mask of ADDHLD field.
	FMC_BWTR4_ADDHLD_Msk = 0xf0
	// Position of ADDSET field.
	FMC_BWTR4_ADDSET_Pos = 0x0
	// Bit mask of ADDSET field.
	FMC_BWTR4_ADDSET_Msk = 0xf
)

// Bitfields for SYSCFG: System configuration controller
const (
	// CFGR1: configuration register 1
	// Position of MEM_MODE field.
	SYSCFG_CFGR1_MEM_MODE_Pos = 0x0
	// Bit mask of MEM_MODE field.
	SYSCFG_CFGR1_MEM_MODE_Msk = 0x7
	// Main Flash memory mapped at 0x0000_0000
	SYSCFG_CFGR1_MEM_MODE_MainFlash = 0x0
	// System Flash memory mapped at 0x0000_0000
	SYSCFG_CFGR1_MEM_MODE_SystemFlash = 0x1
	// Embedded SRAM mapped at 0x0000_0000
	SYSCFG_CFGR1_MEM_MODE_SRAM = 0x3
	// FMC Bank (Only the first two banks) (Available on STM32F302xD/E only)
	SYSCFG_CFGR1_MEM_MODE_FMC = 0x4
	// Position of USB_IT_RMP field.
	SYSCFG_CFGR1_USB_IT_RMP_Pos = 0x5
	// Bit mask of USB_IT_RMP field.
	SYSCFG_CFGR1_USB_IT_RMP_Msk = 0x20
	// Bit USB_IT_RMP.
	SYSCFG_CFGR1_USB_IT_RMP = 0x20
	// USB_HP, USB_LP and USB_WAKEUP interrupts are mapped on interrupt lines 19, 20 and 42 respectively
	SYSCFG_CFGR1_USB_IT_RMP_NotRemapped = 0x0
	// USB_HP, USB_LP and USB_WAKEUP interrupts are mapped on interrupt lines 74, 75 and 76 respectively
	SYSCFG_CFGR1_USB_IT_RMP_Remapped = 0x1
	// Position of TIM1_ITR3_RMP field.
	SYSCFG_CFGR1_TIM1_ITR3_RMP_Pos = 0x6
	// Bit mask of TIM1_ITR3_RMP field.
	SYSCFG_CFGR1_TIM1_ITR3_RMP_Msk = 0x40
	// Bit TIM1_ITR3_RMP.
	SYSCFG_CFGR1_TIM1_ITR3_RMP = 0x40
	// TIM1_ITR3 = TIM4_TRGO in STM32F303xB/C and STM32F358xC devices
	SYSCFG_CFGR1_TIM1_ITR3_RMP_NotRemapped = 0x0
	// TIM1_ITR3 = TIM17_OC
	SYSCFG_CFGR1_TIM1_ITR3_RMP_Remapped = 0x1
	// Position of DAC1_TRIG_RMP field.
	SYSCFG_CFGR1_DAC1_TRIG_RMP_Pos = 0x7
	// Bit mask of DAC1_TRIG_RMP field.
	SYSCFG_CFGR1_DAC1_TRIG_RMP_Msk = 0x80
	// Bit DAC1_TRIG_RMP.
	SYSCFG_CFGR1_DAC1_TRIG_RMP = 0x80
	// DAC trigger is TIM8_TRGO in STM32F303xB/C and STM32F358xC devices
	SYSCFG_CFGR1_DAC1_TRIG_RMP_NotRemapped = 0x0
	// DAC trigger is TIM3_TRGO
	SYSCFG_CFGR1_DAC1_TRIG_RMP_Remapped = 0x1
	// Position of ADC2_DMA_RMP field.
	SYSCFG_CFGR1_ADC2_DMA_RMP_Pos = 0x8
	// Bit mask of ADC2_DMA_RMP field.
	SYSCFG_CFGR1_ADC2_DMA_RMP_Msk = 0x100
	// Bit ADC2_DMA_RMP.
	SYSCFG_CFGR1_ADC2_DMA_RMP = 0x100
	// ADC24 DMA requests mapped on DMA2 channels 1 and 2
	SYSCFG_CFGR1_ADC2_DMA_RMP_NotRemapped = 0x0
	// ADC24 DMA requests mapped on DMA2 channels 3 and 4
	SYSCFG_CFGR1_ADC2_DMA_RMP_Remapped = 0x1
	// Position of TIM16_DMA_RMP field.
	SYSCFG_CFGR1_TIM16_DMA_RMP_Pos = 0xb
	// Bit mask of TIM16_DMA_RMP field.
	SYSCFG_CFGR1_TIM16_DMA_RMP_Msk = 0x800
	// Bit TIM16_DMA_RMP.
	SYSCFG_CFGR1_TIM16_DMA_RMP = 0x800
	// TIM16_CH1 and TIM16_UP DMA requests mapped on DMA channel 3
	SYSCFG_CFGR1_TIM16_DMA_RMP_NotRemapped = 0x0
	// TIM16_CH1 and TIM16_UP DMA requests mapped on DMA channel 4
	SYSCFG_CFGR1_TIM16_DMA_RMP_Remapped = 0x1
	// Position of TIM17_DMA_RMP field.
	SYSCFG_CFGR1_TIM17_DMA_RMP_Pos = 0xc
	// Bit mask of TIM17_DMA_RMP field.
	SYSCFG_CFGR1_TIM17_DMA_RMP_Msk = 0x1000
	// Bit TIM17_DMA_RMP.
	SYSCFG_CFGR1_TIM17_DMA_RMP = 0x1000
	// TIM17_CH1 and TIM17_UP DMA requests mapped on DMA channel 1
	SYSCFG_CFGR1_TIM17_DMA_RMP_NotRemapped = 0x0
	// TIM17_CH1 and TIM17_UP DMA requests mapped on DMA channel 2
	SYSCFG_CFGR1_TIM17_DMA_RMP_Remapped = 0x1
	// Position of TIM6_DAC1_DMA_RMP field.
	SYSCFG_CFGR1_TIM6_DAC1_DMA_RMP_Pos = 0xd
	// Bit mask of TIM6_DAC1_DMA_RMP field.
	SYSCFG_CFGR1_TIM6_DAC1_DMA_RMP_Msk = 0x2000
	// Bit TIM6_DAC1_DMA_RMP.
	SYSCFG_CFGR1_TIM6_DAC1_DMA_RMP = 0x2000
	// TIM6_UP and DAC_CH1 DMA requests mapped on DMA2 channel 3
	SYSCFG_CFGR1_TIM6_DAC1_DMA_RMP_NotRemapped = 0x0
	// TIM6_UP and DAC_CH1 DMA requests mapped on DMA1 channel 3
	SYSCFG_CFGR1_TIM6_DAC1_DMA_RMP_Remapped = 0x1
	// Position of I2C_PB6_FMP field.
	SYSCFG_CFGR1_I2C_PB6_FMP_Pos = 0x10
	// Bit mask of I2C_PB6_FMP field.
	SYSCFG_CFGR1_I2C_PB6_FMP_Msk = 0x10000
	// Bit I2C_PB6_FMP.
	SYSCFG_CFGR1_I2C_PB6_FMP = 0x10000
	// PB6 pin operate in standard mode
	SYSCFG_CFGR1_I2C_PB6_FMP_Standard = 0x0
	// I2C FM+ mode enabled on PB6 and the Speed control is bypassed
	SYSCFG_CFGR1_I2C_PB6_FMP_FMP = 0x1
	// Position of I2C_PB7_FMP field.
	SYSCFG_CFGR1_I2C_PB7_FMP_Pos = 0x11
	// Bit mask of I2C_PB7_FMP field.
	SYSCFG_CFGR1_I2C_PB7_FMP_Msk = 0x20000
	// Bit I2C_PB7_FMP.
	SYSCFG_CFGR1_I2C_PB7_FMP = 0x20000
	// PB7 pin operate in standard mode
	SYSCFG_CFGR1_I2C_PB7_FMP_Standard = 0x0
	// I2C FM+ mode enabled on PB7 and the Speed control is bypassed
	SYSCFG_CFGR1_I2C_PB7_FMP_FMP = 0x1
	// Position of I2C_PB8_FMP field.
	SYSCFG_CFGR1_I2C_PB8_FMP_Pos = 0x12
	// Bit mask of I2C_PB8_FMP field.
	SYSCFG_CFGR1_I2C_PB8_FMP_Msk = 0x40000
	// Bit I2C_PB8_FMP.
	SYSCFG_CFGR1_I2C_PB8_FMP = 0x40000
	// PB8 pin operate in standard mode
	SYSCFG_CFGR1_I2C_PB8_FMP_Standard = 0x0
	// I2C FM+ mode enabled on PB8 and the Speed control is bypassed
	SYSCFG_CFGR1_I2C_PB8_FMP_FMP = 0x1
	// Position of I2C_PB9_FMP field.
	SYSCFG_CFGR1_I2C_PB9_FMP_Pos = 0x13
	// Bit mask of I2C_PB9_FMP field.
	SYSCFG_CFGR1_I2C_PB9_FMP_Msk = 0x80000
	// Bit I2C_PB9_FMP.
	SYSCFG_CFGR1_I2C_PB9_FMP = 0x80000
	// PB9 pin operate in standard mode
	SYSCFG_CFGR1_I2C_PB9_FMP_Standard = 0x0
	// I2C FM+ mode enabled on PB9 and the Speed control is bypassed
	SYSCFG_CFGR1_I2C_PB9_FMP_FMP = 0x1
	// Position of I2C1_FMP field.
	SYSCFG_CFGR1_I2C1_FMP_Pos = 0x14
	// Bit mask of I2C1_FMP field.
	SYSCFG_CFGR1_I2C1_FMP_Msk = 0x100000
	// Bit I2C1_FMP.
	SYSCFG_CFGR1_I2C1_FMP = 0x100000
	// FM+ mode is controlled by I2C_Pxx_FMP bits only
	SYSCFG_CFGR1_I2C1_FMP_Standard = 0x0
	// FM+ mode is enabled on all I2C1 pins selected through selection through IOPORT control registers AF selection bits
	SYSCFG_CFGR1_I2C1_FMP_FMP = 0x1
	// Position of I2C2_FMP field.
	SYSCFG_CFGR1_I2C2_FMP_Pos = 0x15
	// Bit mask of I2C2_FMP field.
	SYSCFG_CFGR1_I2C2_FMP_Msk = 0x200000
	// Bit I2C2_FMP.
	SYSCFG_CFGR1_I2C2_FMP = 0x200000
	// FM+ mode is controlled by I2C_Pxx_FMP bits only
	SYSCFG_CFGR1_I2C2_FMP_Standard = 0x0
	// FM+ mode is enabled on all I2C2 pins selected through selection through IOPORT control registers AF selection bits
	SYSCFG_CFGR1_I2C2_FMP_FMP = 0x1
	// Position of ENCODER_MODE field.
	SYSCFG_CFGR1_ENCODER_MODE_Pos = 0x16
	// Bit mask of ENCODER_MODE field.
	SYSCFG_CFGR1_ENCODER_MODE_Msk = 0xc00000
	// No redirection
	SYSCFG_CFGR1_ENCODER_MODE_NoRedirection = 0x0
	// TIM2 IC1 and TIM2 IC2 are connected to TIM15 IC1 and TIM15 IC2 respectively
	SYSCFG_CFGR1_ENCODER_MODE_MapTim2Tim15 = 0x1
	// TIM3 IC1 and TIM3 IC2 are connected to TIM15 IC1 and TIM15 IC2 respectively
	SYSCFG_CFGR1_ENCODER_MODE_MapTim3Tim15 = 0x2
	// TIM4 IC1 and TIM4 IC2 are connected to TIM15 IC1 and TIM15 IC2 respectively (STM32F302xB/C devices only)
	SYSCFG_CFGR1_ENCODER_MODE_MapTim4Tim15 = 0x3
	// Position of FPU_IE5 field.
	SYSCFG_CFGR1_FPU_IE5_Pos = 0x1f
	// Bit mask of FPU_IE5 field.
	SYSCFG_CFGR1_FPU_IE5_Msk = 0x80000000
	// Bit FPU_IE5.
	SYSCFG_CFGR1_FPU_IE5 = 0x80000000
	// Inexact interrupt disable
	SYSCFG_CFGR1_FPU_IE5_Disabled = 0x0
	// Inexact interrupt enable
	SYSCFG_CFGR1_FPU_IE5_Enabled = 0x1
	// Position of FPU_IE4 field.
	SYSCFG_CFGR1_FPU_IE4_Pos = 0x1e
	// Bit mask of FPU_IE4 field.
	SYSCFG_CFGR1_FPU_IE4_Msk = 0x40000000
	// Bit FPU_IE4.
	SYSCFG_CFGR1_FPU_IE4 = 0x40000000
	// Input denormal interrupt disable
	SYSCFG_CFGR1_FPU_IE4_Disabled = 0x0
	// Input denormal interrupt enable
	SYSCFG_CFGR1_FPU_IE4_Enabled = 0x1
	// Position of FPU_IE3 field.
	SYSCFG_CFGR1_FPU_IE3_Pos = 0x1d
	// Bit mask of FPU_IE3 field.
	SYSCFG_CFGR1_FPU_IE3_Msk = 0x20000000
	// Bit FPU_IE3.
	SYSCFG_CFGR1_FPU_IE3 = 0x20000000
	// Overflow interrupt disable
	SYSCFG_CFGR1_FPU_IE3_Disabled = 0x0
	// Overflow interrupt enable
	SYSCFG_CFGR1_FPU_IE3_Enabled = 0x1
	// Position of FPU_IE2 field.
	SYSCFG_CFGR1_FPU_IE2_Pos = 0x1c
	// Bit mask of FPU_IE2 field.
	SYSCFG_CFGR1_FPU_IE2_Msk = 0x10000000
	// Bit FPU_IE2.
	SYSCFG_CFGR1_FPU_IE2 = 0x10000000
	// Underflow interrupt disable
	SYSCFG_CFGR1_FPU_IE2_Disabled = 0x0
	// Underflow interrupt enable
	SYSCFG_CFGR1_FPU_IE2_Enabled = 0x1
	// Position of FPU_IE1 field.
	SYSCFG_CFGR1_FPU_IE1_Pos = 0x1b
	// Bit mask of FPU_IE1 field.
	SYSCFG_CFGR1_FPU_IE1_Msk = 0x8000000
	// Bit FPU_IE1.
	SYSCFG_CFGR1_FPU_IE1 = 0x8000000
	// Devide-by-zero interrupt disable
	SYSCFG_CFGR1_FPU_IE1_Disabled = 0x0
	// Devide-by-zero interrupt enable
	SYSCFG_CFGR1_FPU_IE1_Enabled = 0x1
	// Position of FPU_IE0 field.
	SYSCFG_CFGR1_FPU_IE0_Pos = 0x1a
	// Bit mask of FPU_IE0 field.
	SYSCFG_CFGR1_FPU_IE0_Msk = 0x4000000
	// Bit FPU_IE0.
	SYSCFG_CFGR1_FPU_IE0 = 0x4000000
	// Invalid operation interrupt disable
	SYSCFG_CFGR1_FPU_IE0_Disabled = 0x0
	// Invalid operation interrupt enable
	SYSCFG_CFGR1_FPU_IE0_Enabled = 0x1
	// Position of I2C3_FMP field.
	SYSCFG_CFGR1_I2C3_FMP_Pos = 0x18
	// Bit mask of I2C3_FMP field.
	SYSCFG_CFGR1_I2C3_FMP_Msk = 0x1000000
	// Bit I2C3_FMP.
	SYSCFG_CFGR1_I2C3_FMP = 0x1000000
	// FM+ mode is controlled by I2C_Pxx_FMP bits only
	SYSCFG_CFGR1_I2C3_FMP_Standard = 0x0
	// FM+ mode is enabled on all I2C3 pins selected through selection trhough IOPORT control registers AF selection bits
	SYSCFG_CFGR1_I2C3_FMP_FMP = 0x1

	// EXTICR1: external interrupt configuration register 1
	// Position of EXTI3 field.
	SYSCFG_EXTICR1_EXTI3_Pos = 0xc
	// Bit mask of EXTI3 field.
	SYSCFG_EXTICR1_EXTI3_Msk = 0xf000
	// Select PA3 as the source input for the EXTI3 external interrupt
	SYSCFG_EXTICR1_EXTI3_PA3 = 0x0
	// Select PB3 as the source input for the EXTI3 external interrupt
	SYSCFG_EXTICR1_EXTI3_PB3 = 0x1
	// Select PC3 as the source input for the EXTI3 external interrupt
	SYSCFG_EXTICR1_EXTI3_PC3 = 0x2
	// Select PD3 as the source input for the EXTI3 external interrupt
	SYSCFG_EXTICR1_EXTI3_PD3 = 0x3
	// Select PE3 as the source input for the EXTI3 external interrupt
	SYSCFG_EXTICR1_EXTI3_PE3 = 0x4
	// Position of EXTI2 field.
	SYSCFG_EXTICR1_EXTI2_Pos = 0x8
	// Bit mask of EXTI2 field.
	SYSCFG_EXTICR1_EXTI2_Msk = 0xf00
	// Select PA2 as the source input for the EXTI2 external interrupt
	SYSCFG_EXTICR1_EXTI2_PA2 = 0x0
	// Select PB2 as the source input for the EXTI2 external interrupt
	SYSCFG_EXTICR1_EXTI2_PB2 = 0x1
	// Select PC2 as the source input for the EXTI2 external interrupt
	SYSCFG_EXTICR1_EXTI2_PC2 = 0x2
	// Select PD2 as the source input for the EXTI2 external interrupt
	SYSCFG_EXTICR1_EXTI2_PD2 = 0x3
	// Select PE2 as the source input for the EXTI2 external interrupt
	SYSCFG_EXTICR1_EXTI2_PE2 = 0x4
	// Select PF2 as the source input for the EXTI2 external interrupt
	SYSCFG_EXTICR1_EXTI2_PF2 = 0x5
	// Position of EXTI1 field.
	SYSCFG_EXTICR1_EXTI1_Pos = 0x4
	// Bit mask of EXTI1 field.
	SYSCFG_EXTICR1_EXTI1_Msk = 0xf0
	// Select PA1 as the source input for the EXTI1 external interrupt
	SYSCFG_EXTICR1_EXTI1_PA1 = 0x0
	// Select PB1 as the source input for the EXTI1 external interrupt
	SYSCFG_EXTICR1_EXTI1_PB1 = 0x1
	// Select PC1 as the source input for the EXTI1 external interrupt
	SYSCFG_EXTICR1_EXTI1_PC1 = 0x2
	// Select PD1 as the source input for the EXTI1 external interrupt
	SYSCFG_EXTICR1_EXTI1_PD1 = 0x3
	// Select PE1 as the source input for the EXTI1 external interrupt
	SYSCFG_EXTICR1_EXTI1_PE1 = 0x4
	// Select PF1 as the source input for the EXTI1 external interrupt
	SYSCFG_EXTICR1_EXTI1_PF1 = 0x5
	// Position of EXTI0 field.
	SYSCFG_EXTICR1_EXTI0_Pos = 0x0
	// Bit mask of EXTI0 field.
	SYSCFG_EXTICR1_EXTI0_Msk = 0xf
	// Select PA0 as the source input for the EXTI0 external interrupt
	SYSCFG_EXTICR1_EXTI0_PA0 = 0x0
	// Select PB0 as the source input for the EXTI0 external interrupt
	SYSCFG_EXTICR1_EXTI0_PB0 = 0x1
	// Select PC0 as the source input for the EXTI0 external interrupt
	SYSCFG_EXTICR1_EXTI0_PC0 = 0x2
	// Select PD0 as the source input for the EXTI0 external interrupt
	SYSCFG_EXTICR1_EXTI0_PD0 = 0x3
	// Select PE0 as the source input for the EXTI0 external interrupt
	SYSCFG_EXTICR1_EXTI0_PE0 = 0x4
	// Select PF0 as the source input for the EXTI0 external interrupt
	SYSCFG_EXTICR1_EXTI0_PF0 = 0x5

	// EXTICR2: external interrupt configuration register 2
	// Position of EXTI7 field.
	SYSCFG_EXTICR2_EXTI7_Pos = 0xc
	// Bit mask of EXTI7 field.
	SYSCFG_EXTICR2_EXTI7_Msk = 0xf000
	// Select PA7 as the source input for the EXTI7 external interrupt
	SYSCFG_EXTICR2_EXTI7_PA7 = 0x0
	// Select PB7 as the source input for the EXTI7 external interrupt
	SYSCFG_EXTICR2_EXTI7_PB7 = 0x1
	// Select PC7 as the source input for the EXTI7 external interrupt
	SYSCFG_EXTICR2_EXTI7_PC7 = 0x2
	// Select PD7 as the source input for the EXTI7 external interrupt
	SYSCFG_EXTICR2_EXTI7_PD7 = 0x3
	// Select PE7 as the source input for the EXTI7 external interrupt
	SYSCFG_EXTICR2_EXTI7_PE7 = 0x4
	// Position of EXTI6 field.
	SYSCFG_EXTICR2_EXTI6_Pos = 0x8
	// Bit mask of EXTI6 field.
	SYSCFG_EXTICR2_EXTI6_Msk = 0xf00
	// Select PA6 as the source input for the EXTI6 external interrupt
	SYSCFG_EXTICR2_EXTI6_PA6 = 0x0
	// Select PB6 as the source input for the EXTI6 external interrupt
	SYSCFG_EXTICR2_EXTI6_PB6 = 0x1
	// Select PC6 as the source input for the EXTI6 external interrupt
	SYSCFG_EXTICR2_EXTI6_PC6 = 0x2
	// Select PD6 as the source input for the EXTI6 external interrupt
	SYSCFG_EXTICR2_EXTI6_PD6 = 0x3
	// Select PE6 as the source input for the EXTI6 external interrupt
	SYSCFG_EXTICR2_EXTI6_PE6 = 0x4
	// Select PF6 as the source input for the EXTI6 external interrupt
	SYSCFG_EXTICR2_EXTI6_PF6 = 0x5
	// Position of EXTI5 field.
	SYSCFG_EXTICR2_EXTI5_Pos = 0x4
	// Bit mask of EXTI5 field.
	SYSCFG_EXTICR2_EXTI5_Msk = 0xf0
	// Select PA5 as the source input for the EXTI5 external interrupt
	SYSCFG_EXTICR2_EXTI5_PA5 = 0x0
	// Select PB5 as the source input for the EXTI5 external interrupt
	SYSCFG_EXTICR2_EXTI5_PB5 = 0x1
	// Select PC5 as the source input for the EXTI5 external interrupt
	SYSCFG_EXTICR2_EXTI5_PC5 = 0x2
	// Select PD5 as the source input for the EXTI5 external interrupt
	SYSCFG_EXTICR2_EXTI5_PD5 = 0x3
	// Select PE5 as the source input for the EXTI5 external interrupt
	SYSCFG_EXTICR2_EXTI5_PE5 = 0x4
	// Select PF5 as the source input for the EXTI5 external interrupt
	SYSCFG_EXTICR2_EXTI5_PF5 = 0x5
	// Position of EXTI4 field.
	SYSCFG_EXTICR2_EXTI4_Pos = 0x0
	// Bit mask of EXTI4 field.
	SYSCFG_EXTICR2_EXTI4_Msk = 0xf
	// Select PA4 as the source input for the EXTI4 external interrupt
	SYSCFG_EXTICR2_EXTI4_PA4 = 0x0
	// Select PB4 as the source input for the EXTI4 external interrupt
	SYSCFG_EXTICR2_EXTI4_PB4 = 0x1
	// Select PC4 as the source input for the EXTI4 external interrupt
	SYSCFG_EXTICR2_EXTI4_PC4 = 0x2
	// Select PD4 as the source input for the EXTI4 external interrupt
	SYSCFG_EXTICR2_EXTI4_PD4 = 0x3
	// Select PE4 as the source input for the EXTI4 external interrupt
	SYSCFG_EXTICR2_EXTI4_PE4 = 0x4
	// Select PF4 as the source input for the EXTI4 external interrupt
	SYSCFG_EXTICR2_EXTI4_PF4 = 0x5

	// EXTICR3: external interrupt configuration register 3
	// Position of EXTI11 field.
	SYSCFG_EXTICR3_EXTI11_Pos = 0xc
	// Bit mask of EXTI11 field.
	SYSCFG_EXTICR3_EXTI11_Msk = 0xf000
	// Select PA11 as the source input for the EXTI11 external interrupt
	SYSCFG_EXTICR3_EXTI11_PA11 = 0x0
	// Select PB11 as the source input for the EXTI11 external interrupt
	SYSCFG_EXTICR3_EXTI11_PB11 = 0x1
	// Select PC11 as the source input for the EXTI11 external interrupt
	SYSCFG_EXTICR3_EXTI11_PC11 = 0x2
	// Select PD11 as the source input for the EXTI11 external interrupt
	SYSCFG_EXTICR3_EXTI11_PD11 = 0x3
	// Select PE11 as the source input for the EXTI11 external interrupt
	SYSCFG_EXTICR3_EXTI11_PE11 = 0x4
	// Position of EXTI10 field.
	SYSCFG_EXTICR3_EXTI10_Pos = 0x8
	// Bit mask of EXTI10 field.
	SYSCFG_EXTICR3_EXTI10_Msk = 0xf00
	// Select PA10 as the source input for the EXTI10 external interrupt
	SYSCFG_EXTICR3_EXTI10_PA10 = 0x0
	// Select PB10 as the source input for the EXTI10 external interrupt
	SYSCFG_EXTICR3_EXTI10_PB10 = 0x1
	// Select PC10 as the source input for the EXTI10 external interrupt
	SYSCFG_EXTICR3_EXTI10_PC10 = 0x2
	// Select PD10 as the source input for the EXTI10 external interrupt
	SYSCFG_EXTICR3_EXTI10_PD10 = 0x3
	// Select PE10 as the source input for the EXTI10 external interrupt
	SYSCFG_EXTICR3_EXTI10_PE10 = 0x4
	// Select PF10 as the source input for the EXTI10 external interrupt
	SYSCFG_EXTICR3_EXTI10_PF10 = 0x5
	// Position of EXTI9 field.
	SYSCFG_EXTICR3_EXTI9_Pos = 0x4
	// Bit mask of EXTI9 field.
	SYSCFG_EXTICR3_EXTI9_Msk = 0xf0
	// Select PA9 as the source input for the EXTI9 external interrupt
	SYSCFG_EXTICR3_EXTI9_PA9 = 0x0
	// Select PB9 as the source input for the EXTI9 external interrupt
	SYSCFG_EXTICR3_EXTI9_PB9 = 0x1
	// Select PC9 as the source input for the EXTI9 external interrupt
	SYSCFG_EXTICR3_EXTI9_PC9 = 0x2
	// Select PD9 as the source input for the EXTI9 external interrupt
	SYSCFG_EXTICR3_EXTI9_PD9 = 0x3
	// Select PE9 as the source input for the EXTI9 external interrupt
	SYSCFG_EXTICR3_EXTI9_PE9 = 0x4
	// Select PF9 as the source input for the EXTI9 external interrupt
	SYSCFG_EXTICR3_EXTI9_PF9 = 0x5
	// Position of EXTI8 field.
	SYSCFG_EXTICR3_EXTI8_Pos = 0x0
	// Bit mask of EXTI8 field.
	SYSCFG_EXTICR3_EXTI8_Msk = 0xf
	// Select PA8 as the source input for the EXTI8 external interrupt
	SYSCFG_EXTICR3_EXTI8_PA8 = 0x0
	// Select PB8 as the source input for the EXTI8 external interrupt
	SYSCFG_EXTICR3_EXTI8_PB8 = 0x1
	// Select PC8 as the source input for the EXTI8 external interrupt
	SYSCFG_EXTICR3_EXTI8_PC8 = 0x2
	// Select PD8 as the source input for the EXTI8 external interrupt
	SYSCFG_EXTICR3_EXTI8_PD8 = 0x3
	// Select PE8 as the source input for the EXTI8 external interrupt
	SYSCFG_EXTICR3_EXTI8_PE8 = 0x4

	// EXTICR4: external interrupt configuration register 4
	// Position of EXTI15 field.
	SYSCFG_EXTICR4_EXTI15_Pos = 0xc
	// Bit mask of EXTI15 field.
	SYSCFG_EXTICR4_EXTI15_Msk = 0xf000
	// Select PA15 as the source input for the EXTI15 external interrupt
	SYSCFG_EXTICR4_EXTI15_PA15 = 0x0
	// Select PB15 as the source input for the EXTI15 external interrupt
	SYSCFG_EXTICR4_EXTI15_PB15 = 0x1
	// Select PC15 as the source input for the EXTI15 external interrupt
	SYSCFG_EXTICR4_EXTI15_PC15 = 0x2
	// Select PD15 as the source input for the EXTI15 external interrupt
	SYSCFG_EXTICR4_EXTI15_PD15 = 0x3
	// Select PE15 as the source input for the EXTI15 external interrupt
	SYSCFG_EXTICR4_EXTI15_PE15 = 0x4
	// Position of EXTI14 field.
	SYSCFG_EXTICR4_EXTI14_Pos = 0x8
	// Bit mask of EXTI14 field.
	SYSCFG_EXTICR4_EXTI14_Msk = 0xf00
	// Select PA14 as the source input for the EXTI14 external interrupt
	SYSCFG_EXTICR4_EXTI14_PA14 = 0x0
	// Select PB14 as the source input for the EXTI14 external interrupt
	SYSCFG_EXTICR4_EXTI14_PB14 = 0x1
	// Select PC14 as the source input for the EXTI14 external interrupt
	SYSCFG_EXTICR4_EXTI14_PC14 = 0x2
	// Select PD14 as the source input for the EXTI14 external interrupt
	SYSCFG_EXTICR4_EXTI14_PD14 = 0x3
	// Select PE14 as the source input for the EXTI14 external interrupt
	SYSCFG_EXTICR4_EXTI14_PE14 = 0x4
	// Position of EXTI13 field.
	SYSCFG_EXTICR4_EXTI13_Pos = 0x4
	// Bit mask of EXTI13 field.
	SYSCFG_EXTICR4_EXTI13_Msk = 0xf0
	// Select PA13 as the source input for the EXTI13 external interrupt
	SYSCFG_EXTICR4_EXTI13_PA13 = 0x0
	// Select PB13 as the source input for the EXTI13 external interrupt
	SYSCFG_EXTICR4_EXTI13_PB13 = 0x1
	// Select PC13 as the source input for the EXTI13 external interrupt
	SYSCFG_EXTICR4_EXTI13_PC13 = 0x2
	// Select PD13 as the source input for the EXTI13 external interrupt
	SYSCFG_EXTICR4_EXTI13_PD13 = 0x3
	// Select PE13 as the source input for the EXTI13 external interrupt
	SYSCFG_EXTICR4_EXTI13_PE13 = 0x4
	// Position of EXTI12 field.
	SYSCFG_EXTICR4_EXTI12_Pos = 0x0
	// Bit mask of EXTI12 field.
	SYSCFG_EXTICR4_EXTI12_Msk = 0xf
	// Select PA12 as the source input for the EXTI12 external interrupt
	SYSCFG_EXTICR4_EXTI12_PA12 = 0x0
	// Select PB12 as the source input for the EXTI12 external interrupt
	SYSCFG_EXTICR4_EXTI12_PB12 = 0x1
	// Select PC12 as the source input for the EXTI12 external interrupt
	SYSCFG_EXTICR4_EXTI12_PC12 = 0x2
	// Select PD12 as the source input for the EXTI12 external interrupt
	SYSCFG_EXTICR4_EXTI12_PD12 = 0x3
	// Select PE12 as the source input for the EXTI12 external interrupt
	SYSCFG_EXTICR4_EXTI12_PE12 = 0x4

	// CFGR2: configuration register 2
	// Position of LOCKUP_LOCK field.
	SYSCFG_CFGR2_LOCKUP_LOCK_Pos = 0x0
	// Bit mask of LOCKUP_LOCK field.
	SYSCFG_CFGR2_LOCKUP_LOCK_Msk = 0x1
	// Bit LOCKUP_LOCK.
	SYSCFG_CFGR2_LOCKUP_LOCK = 0x1
	// Cortex-M4 LOCKUP output disconnected from TIM1/15/16/17 Break input
	SYSCFG_CFGR2_LOCKUP_LOCK_Disconnected = 0x0
	// Cortex-M4 LOCKUP output connected to TIM1/15/16/17 Break input
	SYSCFG_CFGR2_LOCKUP_LOCK_Connected = 0x1
	// Position of SRAM_PARITY_LOCK field.
	SYSCFG_CFGR2_SRAM_PARITY_LOCK_Pos = 0x1
	// Bit mask of SRAM_PARITY_LOCK field.
	SYSCFG_CFGR2_SRAM_PARITY_LOCK_Msk = 0x2
	// Bit SRAM_PARITY_LOCK.
	SYSCFG_CFGR2_SRAM_PARITY_LOCK = 0x2
	// SRAM parity error disconnected from TIM1/15/16/17 Break input
	SYSCFG_CFGR2_SRAM_PARITY_LOCK_Disconnected = 0x0
	// SRAM parity error connected to TIM1/15/16/17 Break input
	SYSCFG_CFGR2_SRAM_PARITY_LOCK_Connected = 0x1
	// Position of PVD_LOCK field.
	SYSCFG_CFGR2_PVD_LOCK_Pos = 0x2
	// Bit mask of PVD_LOCK field.
	SYSCFG_CFGR2_PVD_LOCK_Msk = 0x4
	// Bit PVD_LOCK.
	SYSCFG_CFGR2_PVD_LOCK = 0x4
	// PVD interrupt disconnected from TIM15/16/17 Break input
	SYSCFG_CFGR2_PVD_LOCK_Disconnected = 0x0
	// PVD interrupt connected to TIM15/16/17 Break input
	SYSCFG_CFGR2_PVD_LOCK_Connected = 0x1
	// Position of BYP_ADDR_PAR field.
	SYSCFG_CFGR2_BYP_ADDR_PAR_Pos = 0x4
	// Bit mask of BYP_ADDR_PAR field.
	SYSCFG_CFGR2_BYP_ADDR_PAR_Msk = 0x10
	// Bit BYP_ADDR_PAR.
	SYSCFG_CFGR2_BYP_ADDR_PAR = 0x10
	// The ramload operation is performed taking into consideration bit 29 of the address when the parity is calculated
	SYSCFG_CFGR2_BYP_ADDR_PAR_NoBypass = 0x0
	// The ramload operation is performed without taking into consideration bit 29 of the address when the parity is calculated
	SYSCFG_CFGR2_BYP_ADDR_PAR_Bypass = 0x1
	// Position of SRAM_PEF field.
	SYSCFG_CFGR2_SRAM_PEF_Pos = 0x8
	// Bit mask of SRAM_PEF field.
	SYSCFG_CFGR2_SRAM_PEF_Msk = 0x100
	// Bit SRAM_PEF.
	SYSCFG_CFGR2_SRAM_PEF = 0x100
	// No SRAM parity error detected
	SYSCFG_CFGR2_SRAM_PEF_NoParityError = 0x0
	// SRAM parity error detected
	SYSCFG_CFGR2_SRAM_PEF_ParityErrorDetected = 0x1
	// Clear SRAM parity error flag
	SYSCFG_CFGR2_SRAM_PEF_Clear = 0x1
)

// Bitfields for NVIC: Nested Vectored Interrupt Controller
const (
	// ISER0: Interrupt Set-Enable Register
	// Position of SETENA field.
	NVIC_ISER0_SETENA_Pos = 0x0
	// Bit mask of SETENA field.
	NVIC_ISER0_SETENA_Msk = 0xffffffff

	// ISER1: Interrupt Set-Enable Register
	// Position of SETENA field.
	NVIC_ISER1_SETENA_Pos = 0x0
	// Bit mask of SETENA field.
	NVIC_ISER1_SETENA_Msk = 0xffffffff

	// ISER2: Interrupt Set-Enable Register
	// Position of SETENA field.
	NVIC_ISER2_SETENA_Pos = 0x0
	// Bit mask of SETENA field.
	NVIC_ISER2_SETENA_Msk = 0xffffffff

	// ICER0: Interrupt Clear-Enable Register
	// Position of CLRENA field.
	NVIC_ICER0_CLRENA_Pos = 0x0
	// Bit mask of CLRENA field.
	NVIC_ICER0_CLRENA_Msk = 0xffffffff

	// ICER1: Interrupt Clear-Enable Register
	// Position of CLRENA field.
	NVIC_ICER1_CLRENA_Pos = 0x0
	// Bit mask of CLRENA field.
	NVIC_ICER1_CLRENA_Msk = 0xffffffff

	// ICER2: Interrupt Clear-Enable Register
	// Position of CLRENA field.
	NVIC_ICER2_CLRENA_Pos = 0x0
	// Bit mask of CLRENA field.
	NVIC_ICER2_CLRENA_Msk = 0xffffffff

	// ISPR0: Interrupt Set-Pending Register
	// Position of SETPEND field.
	NVIC_ISPR0_SETPEND_Pos = 0x0
	// Bit mask of SETPEND field.
	NVIC_ISPR0_SETPEND_Msk = 0xffffffff

	// ISPR1: Interrupt Set-Pending Register
	// Position of SETPEND field.
	NVIC_ISPR1_SETPEND_Pos = 0x0
	// Bit mask of SETPEND field.
	NVIC_ISPR1_SETPEND_Msk = 0xffffffff

	// ISPR2: Interrupt Set-Pending Register
	// Position of SETPEND field.
	NVIC_ISPR2_SETPEND_Pos = 0x0
	// Bit mask of SETPEND field.
	NVIC_ISPR2_SETPEND_Msk = 0xffffffff

	// ICPR0: Interrupt Clear-Pending Register
	// Position of CLRPEND field.
	NVIC_ICPR0_CLRPEND_Pos = 0x0
	// Bit mask of CLRPEND field.
	NVIC_ICPR0_CLRPEND_Msk = 0xffffffff

	// ICPR1: Interrupt Clear-Pending Register
	// Position of CLRPEND field.
	NVIC_ICPR1_CLRPEND_Pos = 0x0
	// Bit mask of CLRPEND field.
	NVIC_ICPR1_CLRPEND_Msk = 0xffffffff

	// ICPR2: Interrupt Clear-Pending Register
	// Position of CLRPEND field.
	NVIC_ICPR2_CLRPEND_Pos = 0x0
	// Bit mask of CLRPEND field.
	NVIC_ICPR2_CLRPEND_Msk = 0xffffffff

	// IABR0: Interrupt Active Bit Register
	// Position of ACTIVE field.
	NVIC_IABR0_ACTIVE_Pos = 0x0
	// Bit mask of ACTIVE field.
	NVIC_IABR0_ACTIVE_Msk = 0xffffffff

	// IABR1: Interrupt Active Bit Register
	// Position of ACTIVE field.
	NVIC_IABR1_ACTIVE_Pos = 0x0
	// Bit mask of ACTIVE field.
	NVIC_IABR1_ACTIVE_Msk = 0xffffffff

	// IABR2: Interrupt Active Bit Register
	// Position of ACTIVE field.
	NVIC_IABR2_ACTIVE_Pos = 0x0
	// Bit mask of ACTIVE field.
	NVIC_IABR2_ACTIVE_Msk = 0xffffffff

	// IPR0: Interrupt Priority Register
	// Position of IPR_N0 field.
	NVIC_IPR0_IPR_N0_Pos = 0x0
	// Bit mask of IPR_N0 field.
	NVIC_IPR0_IPR_N0_Msk = 0xff
	// Position of IPR_N1 field.
	NVIC_IPR0_IPR_N1_Pos = 0x8
	// Bit mask of IPR_N1 field.
	NVIC_IPR0_IPR_N1_Msk = 0xff00
	// Position of IPR_N2 field.
	NVIC_IPR0_IPR_N2_Pos = 0x10
	// Bit mask of IPR_N2 field.
	NVIC_IPR0_IPR_N2_Msk = 0xff0000
	// Position of IPR_N3 field.
	NVIC_IPR0_IPR_N3_Pos = 0x18
	// Bit mask of IPR_N3 field.
	NVIC_IPR0_IPR_N3_Msk = 0xff000000

	// IPR1: Interrupt Priority Register
	// Position of IPR_N0 field.
	NVIC_IPR1_IPR_N0_Pos = 0x0
	// Bit mask of IPR_N0 field.
	NVIC_IPR1_IPR_N0_Msk = 0xff
	// Position of IPR_N1 field.
	NVIC_IPR1_IPR_N1_Pos = 0x8
	// Bit mask of IPR_N1 field.
	NVIC_IPR1_IPR_N1_Msk = 0xff00
	// Position of IPR_N2 field.
	NVIC_IPR1_IPR_N2_Pos = 0x10
	// Bit mask of IPR_N2 field.
	NVIC_IPR1_IPR_N2_Msk = 0xff0000
	// Position of IPR_N3 field.
	NVIC_IPR1_IPR_N3_Pos = 0x18
	// Bit mask of IPR_N3 field.
	NVIC_IPR1_IPR_N3_Msk = 0xff000000

	// IPR2: Interrupt Priority Register
	// Position of IPR_N0 field.
	NVIC_IPR2_IPR_N0_Pos = 0x0
	// Bit mask of IPR_N0 field.
	NVIC_IPR2_IPR_N0_Msk = 0xff
	// Position of IPR_N1 field.
	NVIC_IPR2_IPR_N1_Pos = 0x8
	// Bit mask of IPR_N1 field.
	NVIC_IPR2_IPR_N1_Msk = 0xff00
	// Position of IPR_N2 field.
	NVIC_IPR2_IPR_N2_Pos = 0x10
	// Bit mask of IPR_N2 field.
	NVIC_IPR2_IPR_N2_Msk = 0xff0000
	// Position of IPR_N3 field.
	NVIC_IPR2_IPR_N3_Pos = 0x18
	// Bit mask of IPR_N3 field.
	NVIC_IPR2_IPR_N3_Msk = 0xff000000

	// IPR3: Interrupt Priority Register
	// Position of IPR_N0 field.
	NVIC_IPR3_IPR_N0_Pos = 0x0
	// Bit mask of IPR_N0 field.
	NVIC_IPR3_IPR_N0_Msk = 0xff
	// Position of IPR_N1 field.
	NVIC_IPR3_IPR_N1_Pos = 0x8
	// Bit mask of IPR_N1 field.
	NVIC_IPR3_IPR_N1_Msk = 0xff00
	// Position of IPR_N2 field.
	NVIC_IPR3_IPR_N2_Pos = 0x10
	// Bit mask of IPR_N2 field.
	NVIC_IPR3_IPR_N2_Msk = 0xff0000
	// Position of IPR_N3 field.
	NVIC_IPR3_IPR_N3_Pos = 0x18
	// Bit mask of IPR_N3 field.
	NVIC_IPR3_IPR_N3_Msk = 0xff000000

	// IPR4: Interrupt Priority Register
	// Position of IPR_N0 field.
	NVIC_IPR4_IPR_N0_Pos = 0x0
	// Bit mask of IPR_N0 field.
	NVIC_IPR4_IPR_N0_Msk = 0xff
	// Position of IPR_N1 field.
	NVIC_IPR4_IPR_N1_Pos = 0x8
	// Bit mask of IPR_N1 field.
	NVIC_IPR4_IPR_N1_Msk = 0xff00
	// Position of IPR_N2 field.
	NVIC_IPR4_IPR_N2_Pos = 0x10
	// Bit mask of IPR_N2 field.
	NVIC_IPR4_IPR_N2_Msk = 0xff0000
	// Position of IPR_N3 field.
	NVIC_IPR4_IPR_N3_Pos = 0x18
	// Bit mask of IPR_N3 field.
	NVIC_IPR4_IPR_N3_Msk = 0xff000000

	// IPR5: Interrupt Priority Register
	// Position of IPR_N0 field.
	NVIC_IPR5_IPR_N0_Pos = 0x0
	// Bit mask of IPR_N0 field.
	NVIC_IPR5_IPR_N0_Msk = 0xff
	// Position of IPR_N1 field.
	NVIC_IPR5_IPR_N1_Pos = 0x8
	// Bit mask of IPR_N1 field.
	NVIC_IPR5_IPR_N1_Msk = 0xff00
	// Position of IPR_N2 field.
	NVIC_IPR5_IPR_N2_Pos = 0x10
	// Bit mask of IPR_N2 field.
	NVIC_IPR5_IPR_N2_Msk = 0xff0000
	// Position of IPR_N3 field.
	NVIC_IPR5_IPR_N3_Pos = 0x18
	// Bit mask of IPR_N3 field.
	NVIC_IPR5_IPR_N3_Msk = 0xff000000

	// IPR6: Interrupt Priority Register
	// Position of IPR_N0 field.
	NVIC_IPR6_IPR_N0_Pos = 0x0
	// Bit mask of IPR_N0 field.
	NVIC_IPR6_IPR_N0_Msk = 0xff
	// Position of IPR_N1 field.
	NVIC_IPR6_IPR_N1_Pos = 0x8
	// Bit mask of IPR_N1 field.
	NVIC_IPR6_IPR_N1_Msk = 0xff00
	// Position of IPR_N2 field.
	NVIC_IPR6_IPR_N2_Pos = 0x10
	// Bit mask of IPR_N2 field.
	NVIC_IPR6_IPR_N2_Msk = 0xff0000
	// Position of IPR_N3 field.
	NVIC_IPR6_IPR_N3_Pos = 0x18
	// Bit mask of IPR_N3 field.
	NVIC_IPR6_IPR_N3_Msk = 0xff000000

	// IPR7: Interrupt Priority Register
	// Position of IPR_N0 field.
	NVIC_IPR7_IPR_N0_Pos = 0x0
	// Bit mask of IPR_N0 field.
	NVIC_IPR7_IPR_N0_Msk = 0xff
	// Position of IPR_N1 field.
	NVIC_IPR7_IPR_N1_Pos = 0x8
	// Bit mask of IPR_N1 field.
	NVIC_IPR7_IPR_N1_Msk = 0xff00
	// Position of IPR_N2 field.
	NVIC_IPR7_IPR_N2_Pos = 0x10
	// Bit mask of IPR_N2 field.
	NVIC_IPR7_IPR_N2_Msk = 0xff0000
	// Position of IPR_N3 field.
	NVIC_IPR7_IPR_N3_Pos = 0x18
	// Bit mask of IPR_N3 field.
	NVIC_IPR7_IPR_N3_Msk = 0xff000000

	// IPR8: Interrupt Priority Register
	// Position of IPR_N0 field.
	NVIC_IPR8_IPR_N0_Pos = 0x0
	// Bit mask of IPR_N0 field.
	NVIC_IPR8_IPR_N0_Msk = 0xff
	// Position of IPR_N1 field.
	NVIC_IPR8_IPR_N1_Pos = 0x8
	// Bit mask of IPR_N1 field.
	NVIC_IPR8_IPR_N1_Msk = 0xff00
	// Position of IPR_N2 field.
	NVIC_IPR8_IPR_N2_Pos = 0x10
	// Bit mask of IPR_N2 field.
	NVIC_IPR8_IPR_N2_Msk = 0xff0000
	// Position of IPR_N3 field.
	NVIC_IPR8_IPR_N3_Pos = 0x18
	// Bit mask of IPR_N3 field.
	NVIC_IPR8_IPR_N3_Msk = 0xff000000

	// IPR9: Interrupt Priority Register
	// Position of IPR_N0 field.
	NVIC_IPR9_IPR_N0_Pos = 0x0
	// Bit mask of IPR_N0 field.
	NVIC_IPR9_IPR_N0_Msk = 0xff
	// Position of IPR_N1 field.
	NVIC_IPR9_IPR_N1_Pos = 0x8
	// Bit mask of IPR_N1 field.
	NVIC_IPR9_IPR_N1_Msk = 0xff00
	// Position of IPR_N2 field.
	NVIC_IPR9_IPR_N2_Pos = 0x10
	// Bit mask of IPR_N2 field.
	NVIC_IPR9_IPR_N2_Msk = 0xff0000
	// Position of IPR_N3 field.
	NVIC_IPR9_IPR_N3_Pos = 0x18
	// Bit mask of IPR_N3 field.
	NVIC_IPR9_IPR_N3_Msk = 0xff000000

	// IPR10: Interrupt Priority Register
	// Position of IPR_N0 field.
	NVIC_IPR10_IPR_N0_Pos = 0x0
	// Bit mask of IPR_N0 field.
	NVIC_IPR10_IPR_N0_Msk = 0xff
	// Position of IPR_N1 field.
	NVIC_IPR10_IPR_N1_Pos = 0x8
	// Bit mask of IPR_N1 field.
	NVIC_IPR10_IPR_N1_Msk = 0xff00
	// Position of IPR_N2 field.
	NVIC_IPR10_IPR_N2_Pos = 0x10
	// Bit mask of IPR_N2 field.
	NVIC_IPR10_IPR_N2_Msk = 0xff0000
	// Position of IPR_N3 field.
	NVIC_IPR10_IPR_N3_Pos = 0x18
	// Bit mask of IPR_N3 field.
	NVIC_IPR10_IPR_N3_Msk = 0xff000000

	// IPR11: Interrupt Priority Register
	// Position of IPR_N0 field.
	NVIC_IPR11_IPR_N0_Pos = 0x0
	// Bit mask of IPR_N0 field.
	NVIC_IPR11_IPR_N0_Msk = 0xff
	// Position of IPR_N1 field.
	NVIC_IPR11_IPR_N1_Pos = 0x8
	// Bit mask of IPR_N1 field.
	NVIC_IPR11_IPR_N1_Msk = 0xff00
	// Position of IPR_N2 field.
	NVIC_IPR11_IPR_N2_Pos = 0x10
	// Bit mask of IPR_N2 field.
	NVIC_IPR11_IPR_N2_Msk = 0xff0000
	// Position of IPR_N3 field.
	NVIC_IPR11_IPR_N3_Pos = 0x18
	// Bit mask of IPR_N3 field.
	NVIC_IPR11_IPR_N3_Msk = 0xff000000

	// IPR12: Interrupt Priority Register
	// Position of IPR_N0 field.
	NVIC_IPR12_IPR_N0_Pos = 0x0
	// Bit mask of IPR_N0 field.
	NVIC_IPR12_IPR_N0_Msk = 0xff
	// Position of IPR_N1 field.
	NVIC_IPR12_IPR_N1_Pos = 0x8
	// Bit mask of IPR_N1 field.
	NVIC_IPR12_IPR_N1_Msk = 0xff00
	// Position of IPR_N2 field.
	NVIC_IPR12_IPR_N2_Pos = 0x10
	// Bit mask of IPR_N2 field.
	NVIC_IPR12_IPR_N2_Msk = 0xff0000
	// Position of IPR_N3 field.
	NVIC_IPR12_IPR_N3_Pos = 0x18
	// Bit mask of IPR_N3 field.
	NVIC_IPR12_IPR_N3_Msk = 0xff000000

	// IPR13: Interrupt Priority Register
	// Position of IPR_N0 field.
	NVIC_IPR13_IPR_N0_Pos = 0x0
	// Bit mask of IPR_N0 field.
	NVIC_IPR13_IPR_N0_Msk = 0xff
	// Position of IPR_N1 field.
	NVIC_IPR13_IPR_N1_Pos = 0x8
	// Bit mask of IPR_N1 field.
	NVIC_IPR13_IPR_N1_Msk = 0xff00
	// Position of IPR_N2 field.
	NVIC_IPR13_IPR_N2_Pos = 0x10
	// Bit mask of IPR_N2 field.
	NVIC_IPR13_IPR_N2_Msk = 0xff0000
	// Position of IPR_N3 field.
	NVIC_IPR13_IPR_N3_Pos = 0x18
	// Bit mask of IPR_N3 field.
	NVIC_IPR13_IPR_N3_Msk = 0xff000000

	// IPR14: Interrupt Priority Register
	// Position of IPR_N0 field.
	NVIC_IPR14_IPR_N0_Pos = 0x0
	// Bit mask of IPR_N0 field.
	NVIC_IPR14_IPR_N0_Msk = 0xff
	// Position of IPR_N1 field.
	NVIC_IPR14_IPR_N1_Pos = 0x8
	// Bit mask of IPR_N1 field.
	NVIC_IPR14_IPR_N1_Msk = 0xff00
	// Position of IPR_N2 field.
	NVIC_IPR14_IPR_N2_Pos = 0x10
	// Bit mask of IPR_N2 field.
	NVIC_IPR14_IPR_N2_Msk = 0xff0000
	// Position of IPR_N3 field.
	NVIC_IPR14_IPR_N3_Pos = 0x18
	// Bit mask of IPR_N3 field.
	NVIC_IPR14_IPR_N3_Msk = 0xff000000

	// IPR15: Interrupt Priority Register
	// Position of IPR_N0 field.
	NVIC_IPR15_IPR_N0_Pos = 0x0
	// Bit mask of IPR_N0 field.
	NVIC_IPR15_IPR_N0_Msk = 0xff
	// Position of IPR_N1 field.
	NVIC_IPR15_IPR_N1_Pos = 0x8
	// Bit mask of IPR_N1 field.
	NVIC_IPR15_IPR_N1_Msk = 0xff00
	// Position of IPR_N2 field.
	NVIC_IPR15_IPR_N2_Pos = 0x10
	// Bit mask of IPR_N2 field.
	NVIC_IPR15_IPR_N2_Msk = 0xff0000
	// Position of IPR_N3 field.
	NVIC_IPR15_IPR_N3_Pos = 0x18
	// Bit mask of IPR_N3 field.
	NVIC_IPR15_IPR_N3_Msk = 0xff000000

	// IPR16: Interrupt Priority Register
	// Position of IPR_N0 field.
	NVIC_IPR16_IPR_N0_Pos = 0x0
	// Bit mask of IPR_N0 field.
	NVIC_IPR16_IPR_N0_Msk = 0xff
	// Position of IPR_N1 field.
	NVIC_IPR16_IPR_N1_Pos = 0x8
	// Bit mask of IPR_N1 field.
	NVIC_IPR16_IPR_N1_Msk = 0xff00
	// Position of IPR_N2 field.
	NVIC_IPR16_IPR_N2_Pos = 0x10
	// Bit mask of IPR_N2 field.
	NVIC_IPR16_IPR_N2_Msk = 0xff0000
	// Position of IPR_N3 field.
	NVIC_IPR16_IPR_N3_Pos = 0x18
	// Bit mask of IPR_N3 field.
	NVIC_IPR16_IPR_N3_Msk = 0xff000000

	// IPR17: Interrupt Priority Register
	// Position of IPR_N0 field.
	NVIC_IPR17_IPR_N0_Pos = 0x0
	// Bit mask of IPR_N0 field.
	NVIC_IPR17_IPR_N0_Msk = 0xff
	// Position of IPR_N1 field.
	NVIC_IPR17_IPR_N1_Pos = 0x8
	// Bit mask of IPR_N1 field.
	NVIC_IPR17_IPR_N1_Msk = 0xff00
	// Position of IPR_N2 field.
	NVIC_IPR17_IPR_N2_Pos = 0x10
	// Bit mask of IPR_N2 field.
	NVIC_IPR17_IPR_N2_Msk = 0xff0000
	// Position of IPR_N3 field.
	NVIC_IPR17_IPR_N3_Pos = 0x18
	// Bit mask of IPR_N3 field.
	NVIC_IPR17_IPR_N3_Msk = 0xff000000

	// IPR18: Interrupt Priority Register
	// Position of IPR_N0 field.
	NVIC_IPR18_IPR_N0_Pos = 0x0
	// Bit mask of IPR_N0 field.
	NVIC_IPR18_IPR_N0_Msk = 0xff
	// Position of IPR_N1 field.
	NVIC_IPR18_IPR_N1_Pos = 0x8
	// Bit mask of IPR_N1 field.
	NVIC_IPR18_IPR_N1_Msk = 0xff00
	// Position of IPR_N2 field.
	NVIC_IPR18_IPR_N2_Pos = 0x10
	// Bit mask of IPR_N2 field.
	NVIC_IPR18_IPR_N2_Msk = 0xff0000
	// Position of IPR_N3 field.
	NVIC_IPR18_IPR_N3_Pos = 0x18
	// Bit mask of IPR_N3 field.
	NVIC_IPR18_IPR_N3_Msk = 0xff000000

	// IPR19: Interrupt Priority Register
	// Position of IPR_N0 field.
	NVIC_IPR19_IPR_N0_Pos = 0x0
	// Bit mask of IPR_N0 field.
	NVIC_IPR19_IPR_N0_Msk = 0xff
	// Position of IPR_N1 field.
	NVIC_IPR19_IPR_N1_Pos = 0x8
	// Bit mask of IPR_N1 field.
	NVIC_IPR19_IPR_N1_Msk = 0xff00
	// Position of IPR_N2 field.
	NVIC_IPR19_IPR_N2_Pos = 0x10
	// Bit mask of IPR_N2 field.
	NVIC_IPR19_IPR_N2_Msk = 0xff0000
	// Position of IPR_N3 field.
	NVIC_IPR19_IPR_N3_Pos = 0x18
	// Bit mask of IPR_N3 field.
	NVIC_IPR19_IPR_N3_Msk = 0xff000000

	// IPR20: Interrupt Priority Register
	// Position of IPR_N0 field.
	NVIC_IPR20_IPR_N0_Pos = 0x0
	// Bit mask of IPR_N0 field.
	NVIC_IPR20_IPR_N0_Msk = 0xff
	// Position of IPR_N1 field.
	NVIC_IPR20_IPR_N1_Pos = 0x8
	// Bit mask of IPR_N1 field.
	NVIC_IPR20_IPR_N1_Msk = 0xff00
	// Position of IPR_N2 field.
	NVIC_IPR20_IPR_N2_Pos = 0x10
	// Bit mask of IPR_N2 field.
	NVIC_IPR20_IPR_N2_Msk = 0xff0000
	// Position of IPR_N3 field.
	NVIC_IPR20_IPR_N3_Pos = 0x18
	// Bit mask of IPR_N3 field.
	NVIC_IPR20_IPR_N3_Msk = 0xff000000
)

// Bitfields for FPU: Floting point unit
const (
	// FPCCR: Floating-point context control register
	// Position of LSPACT field.
	FPU_FPCCR_LSPACT_Pos = 0x0
	// Bit mask of LSPACT field.
	FPU_FPCCR_LSPACT_Msk = 0x1
	// Bit LSPACT.
	FPU_FPCCR_LSPACT = 0x1
	// Position of USER field.
	FPU_FPCCR_USER_Pos = 0x1
	// Bit mask of USER field.
	FPU_FPCCR_USER_Msk = 0x2
	// Bit USER.
	FPU_FPCCR_USER = 0x2
	// Position of THREAD field.
	FPU_FPCCR_THREAD_Pos = 0x3
	// Bit mask of THREAD field.
	FPU_FPCCR_THREAD_Msk = 0x8
	// Bit THREAD.
	FPU_FPCCR_THREAD = 0x8
	// Position of HFRDY field.
	FPU_FPCCR_HFRDY_Pos = 0x4
	// Bit mask of HFRDY field.
	FPU_FPCCR_HFRDY_Msk = 0x10
	// Bit HFRDY.
	FPU_FPCCR_HFRDY = 0x10
	// Position of MMRDY field.
	FPU_FPCCR_MMRDY_Pos = 0x5
	// Bit mask of MMRDY field.
	FPU_FPCCR_MMRDY_Msk = 0x20
	// Bit MMRDY.
	FPU_FPCCR_MMRDY = 0x20
	// Position of BFRDY field.
	FPU_FPCCR_BFRDY_Pos = 0x6
	// Bit mask of BFRDY field.
	FPU_FPCCR_BFRDY_Msk = 0x40
	// Bit BFRDY.
	FPU_FPCCR_BFRDY = 0x40
	// Position of MONRDY field.
	FPU_FPCCR_MONRDY_Pos = 0x8
	// Bit mask of MONRDY field.
	FPU_FPCCR_MONRDY_Msk = 0x100
	// Bit MONRDY.
	FPU_FPCCR_MONRDY = 0x100
	// Position of LSPEN field.
	FPU_FPCCR_LSPEN_Pos = 0x1e
	// Bit mask of LSPEN field.
	FPU_FPCCR_LSPEN_Msk = 0x40000000
	// Bit LSPEN.
	FPU_FPCCR_LSPEN = 0x40000000
	// Position of ASPEN field.
	FPU_FPCCR_ASPEN_Pos = 0x1f
	// Bit mask of ASPEN field.
	FPU_FPCCR_ASPEN_Msk = 0x80000000
	// Bit ASPEN.
	FPU_FPCCR_ASPEN = 0x80000000

	// FPCAR: Floating-point context address register
	// Position of ADDRESS field.
	FPU_FPCAR_ADDRESS_Pos = 0x3
	// Bit mask of ADDRESS field.
	FPU_FPCAR_ADDRESS_Msk = 0xfffffff8

	// FPSCR: Floating-point status control register
	// Position of IOC field.
	FPU_FPSCR_IOC_Pos = 0x0
	// Bit mask of IOC field.
	FPU_FPSCR_IOC_Msk = 0x1
	// Bit IOC.
	FPU_FPSCR_IOC = 0x1
	// Position of DZC field.
	FPU_FPSCR_DZC_Pos = 0x1
	// Bit mask of DZC field.
	FPU_FPSCR_DZC_Msk = 0x2
	// Bit DZC.
	FPU_FPSCR_DZC = 0x2
	// Position of OFC field.
	FPU_FPSCR_OFC_Pos = 0x2
	// Bit mask of OFC field.
	FPU_FPSCR_OFC_Msk = 0x4
	// Bit OFC.
	FPU_FPSCR_OFC = 0x4
	// Position of UFC field.
	FPU_FPSCR_UFC_Pos = 0x3
	// Bit mask of UFC field.
	FPU_FPSCR_UFC_Msk = 0x8
	// Bit UFC.
	FPU_FPSCR_UFC = 0x8
	// Position of IXC field.
	FPU_FPSCR_IXC_Pos = 0x4
	// Bit mask of IXC field.
	FPU_FPSCR_IXC_Msk = 0x10
	// Bit IXC.
	FPU_FPSCR_IXC = 0x10
	// Position of IDC field.
	FPU_FPSCR_IDC_Pos = 0x7
	// Bit mask of IDC field.
	FPU_FPSCR_IDC_Msk = 0x80
	// Bit IDC.
	FPU_FPSCR_IDC = 0x80
	// Position of RMode field.
	FPU_FPSCR_RMode_Pos = 0x16
	// Bit mask of RMode field.
	FPU_FPSCR_RMode_Msk = 0xc00000
	// Position of FZ field.
	FPU_FPSCR_FZ_Pos = 0x18
	// Bit mask of FZ field.
	FPU_FPSCR_FZ_Msk = 0x1000000
	// Bit FZ.
	FPU_FPSCR_FZ = 0x1000000
	// Position of DN field.
	FPU_FPSCR_DN_Pos = 0x19
	// Bit mask of DN field.
	FPU_FPSCR_DN_Msk = 0x2000000
	// Bit DN.
	FPU_FPSCR_DN = 0x2000000
	// Position of AHP field.
	FPU_FPSCR_AHP_Pos = 0x1a
	// Bit mask of AHP field.
	FPU_FPSCR_AHP_Msk = 0x4000000
	// Bit AHP.
	FPU_FPSCR_AHP = 0x4000000
	// Position of V field.
	FPU_FPSCR_V_Pos = 0x1c
	// Bit mask of V field.
	FPU_FPSCR_V_Msk = 0x10000000
	// Bit V.
	FPU_FPSCR_V = 0x10000000
	// Position of C field.
	FPU_FPSCR_C_Pos = 0x1d
	// Bit mask of C field.
	FPU_FPSCR_C_Msk = 0x20000000
	// Bit C.
	FPU_FPSCR_C = 0x20000000
	// Position of Z field.
	FPU_FPSCR_Z_Pos = 0x1e
	// Bit mask of Z field.
	FPU_FPSCR_Z_Msk = 0x40000000
	// Bit Z.
	FPU_FPSCR_Z = 0x40000000
	// Position of N field.
	FPU_FPSCR_N_Pos = 0x1f
	// Bit mask of N field.
	FPU_FPSCR_N_Msk = 0x80000000
	// Bit N.
	FPU_FPSCR_N = 0x80000000
)

// Bitfields for MPU: Memory protection unit
const (
	// MPU_TYPER: MPU type register
	// Position of SEPARATE field.
	MPU_MPU_TYPER_SEPARATE_Pos = 0x0
	// Bit mask of SEPARATE field.
	MPU_MPU_TYPER_SEPARATE_Msk = 0x1
	// Bit SEPARATE.
	MPU_MPU_TYPER_SEPARATE = 0x1
	// Position of DREGION field.
	MPU_MPU_TYPER_DREGION_Pos = 0x8
	// Bit mask of DREGION field.
	MPU_MPU_TYPER_DREGION_Msk = 0xff00
	// Position of IREGION field.
	MPU_MPU_TYPER_IREGION_Pos = 0x10
	// Bit mask of IREGION field.
	MPU_MPU_TYPER_IREGION_Msk = 0xff0000

	// MPU_CTRL: MPU control register
	// Position of ENABLE field.
	MPU_MPU_CTRL_ENABLE_Pos = 0x0
	// Bit mask of ENABLE field.
	MPU_MPU_CTRL_ENABLE_Msk = 0x1
	// Bit ENABLE.
	MPU_MPU_CTRL_ENABLE = 0x1
	// Position of HFNMIENA field.
	MPU_MPU_CTRL_HFNMIENA_Pos = 0x1
	// Bit mask of HFNMIENA field.
	MPU_MPU_CTRL_HFNMIENA_Msk = 0x2
	// Bit HFNMIENA.
	MPU_MPU_CTRL_HFNMIENA = 0x2
	// Position of PRIVDEFENA field.
	MPU_MPU_CTRL_PRIVDEFENA_Pos = 0x2
	// Bit mask of PRIVDEFENA field.
	MPU_MPU_CTRL_PRIVDEFENA_Msk = 0x4
	// Bit PRIVDEFENA.
	MPU_MPU_CTRL_PRIVDEFENA = 0x4

	// MPU_RNR: MPU region number register
	// Position of REGION field.
	MPU_MPU_RNR_REGION_Pos = 0x0
	// Bit mask of REGION field.
	MPU_MPU_RNR_REGION_Msk = 0xff

	// MPU_RBAR: MPU region base address register
	// Position of REGION field.
	MPU_MPU_RBAR_REGION_Pos = 0x0
	// Bit mask of REGION field.
	MPU_MPU_RBAR_REGION_Msk = 0xf
	// Position of VALID field.
	MPU_MPU_RBAR_VALID_Pos = 0x4
	// Bit mask of VALID field.
	MPU_MPU_RBAR_VALID_Msk = 0x10
	// Bit VALID.
	MPU_MPU_RBAR_VALID = 0x10
	// Position of ADDR field.
	MPU_MPU_RBAR_ADDR_Pos = 0x5
	// Bit mask of ADDR field.
	MPU_MPU_RBAR_ADDR_Msk = 0xffffffe0

	// MPU_RASR: MPU region attribute and size register
	// Position of ENABLE field.
	MPU_MPU_RASR_ENABLE_Pos = 0x0
	// Bit mask of ENABLE field.
	MPU_MPU_RASR_ENABLE_Msk = 0x1
	// Bit ENABLE.
	MPU_MPU_RASR_ENABLE = 0x1
	// Position of SIZE field.
	MPU_MPU_RASR_SIZE_Pos = 0x1
	// Bit mask of SIZE field.
	MPU_MPU_RASR_SIZE_Msk = 0x3e
	// Position of SRD field.
	MPU_MPU_RASR_SRD_Pos = 0x8
	// Bit mask of SRD field.
	MPU_MPU_RASR_SRD_Msk = 0xff00
	// Position of B field.
	MPU_MPU_RASR_B_Pos = 0x10
	// Bit mask of B field.
	MPU_MPU_RASR_B_Msk = 0x10000
	// Bit B.
	MPU_MPU_RASR_B = 0x10000
	// Position of C field.
	MPU_MPU_RASR_C_Pos = 0x11
	// Bit mask of C field.
	MPU_MPU_RASR_C_Msk = 0x20000
	// Bit C.
	MPU_MPU_RASR_C = 0x20000
	// Position of S field.
	MPU_MPU_RASR_S_Pos = 0x12
	// Bit mask of S field.
	MPU_MPU_RASR_S_Msk = 0x40000
	// Bit S.
	MPU_MPU_RASR_S = 0x40000
	// Position of TEX field.
	MPU_MPU_RASR_TEX_Pos = 0x13
	// Bit mask of TEX field.
	MPU_MPU_RASR_TEX_Msk = 0x380000
	// Position of AP field.
	MPU_MPU_RASR_AP_Pos = 0x18
	// Bit mask of AP field.
	MPU_MPU_RASR_AP_Msk = 0x7000000
	// Position of XN field.
	MPU_MPU_RASR_XN_Pos = 0x1c
	// Bit mask of XN field.
	MPU_MPU_RASR_XN_Msk = 0x10000000
	// Bit XN.
	MPU_MPU_RASR_XN = 0x10000000
)

// Bitfields for STK: SysTick timer
const (
	// CTRL: SysTick control and status register
	// Position of ENABLE field.
	STK_CTRL_ENABLE_Pos = 0x0
	// Bit mask of ENABLE field.
	STK_CTRL_ENABLE_Msk = 0x1
	// Bit ENABLE.
	STK_CTRL_ENABLE = 0x1
	// Position of TICKINT field.
	STK_CTRL_TICKINT_Pos = 0x1
	// Bit mask of TICKINT field.
	STK_CTRL_TICKINT_Msk = 0x2
	// Bit TICKINT.
	STK_CTRL_TICKINT = 0x2
	// Position of CLKSOURCE field.
	STK_CTRL_CLKSOURCE_Pos = 0x2
	// Bit mask of CLKSOURCE field.
	STK_CTRL_CLKSOURCE_Msk = 0x4
	// Bit CLKSOURCE.
	STK_CTRL_CLKSOURCE = 0x4
	// Position of COUNTFLAG field.
	STK_CTRL_COUNTFLAG_Pos = 0x10
	// Bit mask of COUNTFLAG field.
	STK_CTRL_COUNTFLAG_Msk = 0x10000
	// Bit COUNTFLAG.
	STK_CTRL_COUNTFLAG = 0x10000

	// LOAD: SysTick reload value register
	// Position of RELOAD field.
	STK_LOAD_RELOAD_Pos = 0x0
	// Bit mask of RELOAD field.
	STK_LOAD_RELOAD_Msk = 0xffffff

	// VAL: SysTick current value register
	// Position of CURRENT field.
	STK_VAL_CURRENT_Pos = 0x0
	// Bit mask of CURRENT field.
	STK_VAL_CURRENT_Msk = 0xffffff

	// CALIB: SysTick calibration value register
	// Position of TENMS field.
	STK_CALIB_TENMS_Pos = 0x0
	// Bit mask of TENMS field.
	STK_CALIB_TENMS_Msk = 0xffffff
	// Position of SKEW field.
	STK_CALIB_SKEW_Pos = 0x1e
	// Bit mask of SKEW field.
	STK_CALIB_SKEW_Msk = 0x40000000
	// Bit SKEW.
	STK_CALIB_SKEW = 0x40000000
	// Position of NOREF field.
	STK_CALIB_NOREF_Pos = 0x1f
	// Bit mask of NOREF field.
	STK_CALIB_NOREF_Msk = 0x80000000
	// Bit NOREF.
	STK_CALIB_NOREF = 0x80000000
)

// Bitfields for SCB: System control block
const (
	// CPUID: CPUID base register
	// Position of Revision field.
	SCB_CPUID_Revision_Pos = 0x0
	// Bit mask of Revision field.
	SCB_CPUID_Revision_Msk = 0xf
	// Position of PartNo field.
	SCB_CPUID_PartNo_Pos = 0x4
	// Bit mask of PartNo field.
	SCB_CPUID_PartNo_Msk = 0xfff0
	// Position of Constant field.
	SCB_CPUID_Constant_Pos = 0x10
	// Bit mask of Constant field.
	SCB_CPUID_Constant_Msk = 0xf0000
	// Position of Variant field.
	SCB_CPUID_Variant_Pos = 0x14
	// Bit mask of Variant field.
	SCB_CPUID_Variant_Msk = 0xf00000
	// Position of Implementer field.
	SCB_CPUID_Implementer_Pos = 0x18
	// Bit mask of Implementer field.
	SCB_CPUID_Implementer_Msk = 0xff000000

	// ICSR: Interrupt control and state register
	// Position of VECTACTIVE field.
	SCB_ICSR_VECTACTIVE_Pos = 0x0
	// Bit mask of VECTACTIVE field.
	SCB_ICSR_VECTACTIVE_Msk = 0x1ff
	// Position of RETTOBASE field.
	SCB_ICSR_RETTOBASE_Pos = 0xb
	// Bit mask of RETTOBASE field.
	SCB_ICSR_RETTOBASE_Msk = 0x800
	// Bit RETTOBASE.
	SCB_ICSR_RETTOBASE = 0x800
	// Position of VECTPENDING field.
	SCB_ICSR_VECTPENDING_Pos = 0xc
	// Bit mask of VECTPENDING field.
	SCB_ICSR_VECTPENDING_Msk = 0x7f000
	// Position of ISRPENDING field.
	SCB_ICSR_ISRPENDING_Pos = 0x16
	// Bit mask of ISRPENDING field.
	SCB_ICSR_ISRPENDING_Msk = 0x400000
	// Bit ISRPENDING.
	SCB_ICSR_ISRPENDING = 0x400000
	// Position of PENDSTCLR field.
	SCB_ICSR_PENDSTCLR_Pos = 0x19
	// Bit mask of PENDSTCLR field.
	SCB_ICSR_PENDSTCLR_Msk = 0x2000000
	// Bit PENDSTCLR.
	SCB_ICSR_PENDSTCLR = 0x2000000
	// Position of PENDSTSET field.
	SCB_ICSR_PENDSTSET_Pos = 0x1a
	// Bit mask of PENDSTSET field.
	SCB_ICSR_PENDSTSET_Msk = 0x4000000
	// Bit PENDSTSET.
	SCB_ICSR_PENDSTSET = 0x4000000
	// Position of PENDSVCLR field.
	SCB_ICSR_PENDSVCLR_Pos = 0x1b
	// Bit mask of PENDSVCLR field.
	SCB_ICSR_PENDSVCLR_Msk = 0x8000000
	// Bit PENDSVCLR.
	SCB_ICSR_PENDSVCLR = 0x8000000
	// Position of PENDSVSET field.
	SCB_ICSR_PENDSVSET_Pos = 0x1c
	// Bit mask of PENDSVSET field.
	SCB_ICSR_PENDSVSET_Msk = 0x10000000
	// Bit PENDSVSET.
	SCB_ICSR_PENDSVSET = 0x10000000
	// Position of NMIPENDSET field.
	SCB_ICSR_NMIPENDSET_Pos = 0x1f
	// Bit mask of NMIPENDSET field.
	SCB_ICSR_NMIPENDSET_Msk = 0x80000000
	// Bit NMIPENDSET.
	SCB_ICSR_NMIPENDSET = 0x80000000

	// VTOR: Vector table offset register
	// Position of TBLOFF field.
	SCB_VTOR_TBLOFF_Pos = 0x9
	// Bit mask of TBLOFF field.
	SCB_VTOR_TBLOFF_Msk = 0x3ffffe00

	// AIRCR: Application interrupt and reset control register
	// Position of VECTRESET field.
	SCB_AIRCR_VECTRESET_Pos = 0x0
	// Bit mask of VECTRESET field.
	SCB_AIRCR_VECTRESET_Msk = 0x1
	// Bit VECTRESET.
	SCB_AIRCR_VECTRESET = 0x1
	// Position of VECTCLRACTIVE field.
	SCB_AIRCR_VECTCLRACTIVE_Pos = 0x1
	// Bit mask of VECTCLRACTIVE field.
	SCB_AIRCR_VECTCLRACTIVE_Msk = 0x2
	// Bit VECTCLRACTIVE.
	SCB_AIRCR_VECTCLRACTIVE = 0x2
	// Position of SYSRESETREQ field.
	SCB_AIRCR_SYSRESETREQ_Pos = 0x2
	// Bit mask of SYSRESETREQ field.
	SCB_AIRCR_SYSRESETREQ_Msk = 0x4
	// Bit SYSRESETREQ.
	SCB_AIRCR_SYSRESETREQ = 0x4
	// Position of PRIGROUP field.
	SCB_AIRCR_PRIGROUP_Pos = 0x8
	// Bit mask of PRIGROUP field.
	SCB_AIRCR_PRIGROUP_Msk = 0x700
	// Position of ENDIANESS field.
	SCB_AIRCR_ENDIANESS_Pos = 0xf
	// Bit mask of ENDIANESS field.
	SCB_AIRCR_ENDIANESS_Msk = 0x8000
	// Bit ENDIANESS.
	SCB_AIRCR_ENDIANESS = 0x8000
	// Position of VECTKEYSTAT field.
	SCB_AIRCR_VECTKEYSTAT_Pos = 0x10
	// Bit mask of VECTKEYSTAT field.
	SCB_AIRCR_VECTKEYSTAT_Msk = 0xffff0000

	// SCR: System control register
	// Position of SLEEPONEXIT field.
	SCB_SCR_SLEEPONEXIT_Pos = 0x1
	// Bit mask of SLEEPONEXIT field.
	SCB_SCR_SLEEPONEXIT_Msk = 0x2
	// Bit SLEEPONEXIT.
	SCB_SCR_SLEEPONEXIT = 0x2
	// Position of SLEEPDEEP field.
	SCB_SCR_SLEEPDEEP_Pos = 0x2
	// Bit mask of SLEEPDEEP field.
	SCB_SCR_SLEEPDEEP_Msk = 0x4
	// Bit SLEEPDEEP.
	SCB_SCR_SLEEPDEEP = 0x4
	// Position of SEVEONPEND field.
	SCB_SCR_SEVEONPEND_Pos = 0x4
	// Bit mask of SEVEONPEND field.
	SCB_SCR_SEVEONPEND_Msk = 0x10
	// Bit SEVEONPEND.
	SCB_SCR_SEVEONPEND = 0x10

	// CCR: Configuration and control register
	// Position of NONBASETHRDENA field.
	SCB_CCR_NONBASETHRDENA_Pos = 0x0
	// Bit mask of NONBASETHRDENA field.
	SCB_CCR_NONBASETHRDENA_Msk = 0x1
	// Bit NONBASETHRDENA.
	SCB_CCR_NONBASETHRDENA = 0x1
	// Position of USERSETMPEND field.
	SCB_CCR_USERSETMPEND_Pos = 0x1
	// Bit mask of USERSETMPEND field.
	SCB_CCR_USERSETMPEND_Msk = 0x2
	// Bit USERSETMPEND.
	SCB_CCR_USERSETMPEND = 0x2
	// Position of UNALIGN__TRP field.
	SCB_CCR_UNALIGN__TRP_Pos = 0x3
	// Bit mask of UNALIGN__TRP field.
	SCB_CCR_UNALIGN__TRP_Msk = 0x8
	// Bit UNALIGN__TRP.
	SCB_CCR_UNALIGN__TRP = 0x8
	// Position of DIV_0_TRP field.
	SCB_CCR_DIV_0_TRP_Pos = 0x4
	// Bit mask of DIV_0_TRP field.
	SCB_CCR_DIV_0_TRP_Msk = 0x10
	// Bit DIV_0_TRP.
	SCB_CCR_DIV_0_TRP = 0x10
	// Position of BFHFNMIGN field.
	SCB_CCR_BFHFNMIGN_Pos = 0x8
	// Bit mask of BFHFNMIGN field.
	SCB_CCR_BFHFNMIGN_Msk = 0x100
	// Bit BFHFNMIGN.
	SCB_CCR_BFHFNMIGN = 0x100
	// Position of STKALIGN field.
	SCB_CCR_STKALIGN_Pos = 0x9
	// Bit mask of STKALIGN field.
	SCB_CCR_STKALIGN_Msk = 0x200
	// Bit STKALIGN.
	SCB_CCR_STKALIGN = 0x200

	// SHPR1: System handler priority registers
	// Position of PRI_4 field.
	SCB_SHPR1_PRI_4_Pos = 0x0
	// Bit mask of PRI_4 field.
	SCB_SHPR1_PRI_4_Msk = 0xff
	// Position of PRI_5 field.
	SCB_SHPR1_PRI_5_Pos = 0x8
	// Bit mask of PRI_5 field.
	SCB_SHPR1_PRI_5_Msk = 0xff00
	// Position of PRI_6 field.
	SCB_SHPR1_PRI_6_Pos = 0x10
	// Bit mask of PRI_6 field.
	SCB_SHPR1_PRI_6_Msk = 0xff0000

	// SHPR2: System handler priority registers
	// Position of PRI_11 field.
	SCB_SHPR2_PRI_11_Pos = 0x18
	// Bit mask of PRI_11 field.
	SCB_SHPR2_PRI_11_Msk = 0xff000000

	// SHPR3: System handler priority registers
	// Position of PRI_14 field.
	SCB_SHPR3_PRI_14_Pos = 0x10
	// Bit mask of PRI_14 field.
	SCB_SHPR3_PRI_14_Msk = 0xff0000
	// Position of PRI_15 field.
	SCB_SHPR3_PRI_15_Pos = 0x18
	// Bit mask of PRI_15 field.
	SCB_SHPR3_PRI_15_Msk = 0xff000000

	// SHCRS: System handler control and state register
	// Position of MEMFAULTACT field.
	SCB_SHCRS_MEMFAULTACT_Pos = 0x0
	// Bit mask of MEMFAULTACT field.
	SCB_SHCRS_MEMFAULTACT_Msk = 0x1
	// Bit MEMFAULTACT.
	SCB_SHCRS_MEMFAULTACT = 0x1
	// Position of BUSFAULTACT field.
	SCB_SHCRS_BUSFAULTACT_Pos = 0x1
	// Bit mask of BUSFAULTACT field.
	SCB_SHCRS_BUSFAULTACT_Msk = 0x2
	// Bit BUSFAULTACT.
	SCB_SHCRS_BUSFAULTACT = 0x2
	// Position of USGFAULTACT field.
	SCB_SHCRS_USGFAULTACT_Pos = 0x3
	// Bit mask of USGFAULTACT field.
	SCB_SHCRS_USGFAULTACT_Msk = 0x8
	// Bit USGFAULTACT.
	SCB_SHCRS_USGFAULTACT = 0x8
	// Position of SVCALLACT field.
	SCB_SHCRS_SVCALLACT_Pos = 0x7
	// Bit mask of SVCALLACT field.
	SCB_SHCRS_SVCALLACT_Msk = 0x80
	// Bit SVCALLACT.
	SCB_SHCRS_SVCALLACT = 0x80
	// Position of MONITORACT field.
	SCB_SHCRS_MONITORACT_Pos = 0x8
	// Bit mask of MONITORACT field.
	SCB_SHCRS_MONITORACT_Msk = 0x100
	// Bit MONITORACT.
	SCB_SHCRS_MONITORACT = 0x100
	// Position of PENDSVACT field.
	SCB_SHCRS_PENDSVACT_Pos = 0xa
	// Bit mask of PENDSVACT field.
	SCB_SHCRS_PENDSVACT_Msk = 0x400
	// Bit PENDSVACT.
	SCB_SHCRS_PENDSVACT = 0x400
	// Position of SYSTICKACT field.
	SCB_SHCRS_SYSTICKACT_Pos = 0xb
	// Bit mask of SYSTICKACT field.
	SCB_SHCRS_SYSTICKACT_Msk = 0x800
	// Bit SYSTICKACT.
	SCB_SHCRS_SYSTICKACT = 0x800
	// Position of USGFAULTPENDED field.
	SCB_SHCRS_USGFAULTPENDED_Pos = 0xc
	// Bit mask of USGFAULTPENDED field.
	SCB_SHCRS_USGFAULTPENDED_Msk = 0x1000
	// Bit USGFAULTPENDED.
	SCB_SHCRS_USGFAULTPENDED = 0x1000
	// Position of MEMFAULTPENDED field.
	SCB_SHCRS_MEMFAULTPENDED_Pos = 0xd
	// Bit mask of MEMFAULTPENDED field.
	SCB_SHCRS_MEMFAULTPENDED_Msk = 0x2000
	// Bit MEMFAULTPENDED.
	SCB_SHCRS_MEMFAULTPENDED = 0x2000
	// Position of BUSFAULTPENDED field.
	SCB_SHCRS_BUSFAULTPENDED_Pos = 0xe
	// Bit mask of BUSFAULTPENDED field.
	SCB_SHCRS_BUSFAULTPENDED_Msk = 0x4000
	// Bit BUSFAULTPENDED.
	SCB_SHCRS_BUSFAULTPENDED = 0x4000
	// Position of SVCALLPENDED field.
	SCB_SHCRS_SVCALLPENDED_Pos = 0xf
	// Bit mask of SVCALLPENDED field.
	SCB_SHCRS_SVCALLPENDED_Msk = 0x8000
	// Bit SVCALLPENDED.
	SCB_SHCRS_SVCALLPENDED = 0x8000
	// Position of MEMFAULTENA field.
	SCB_SHCRS_MEMFAULTENA_Pos = 0x10
	// Bit mask of MEMFAULTENA field.
	SCB_SHCRS_MEMFAULTENA_Msk = 0x10000
	// Bit MEMFAULTENA.
	SCB_SHCRS_MEMFAULTENA = 0x10000
	// Position of BUSFAULTENA field.
	SCB_SHCRS_BUSFAULTENA_Pos = 0x11
	// Bit mask of BUSFAULTENA field.
	SCB_SHCRS_BUSFAULTENA_Msk = 0x20000
	// Bit BUSFAULTENA.
	SCB_SHCRS_BUSFAULTENA = 0x20000
	// Position of USGFAULTENA field.
	SCB_SHCRS_USGFAULTENA_Pos = 0x12
	// Bit mask of USGFAULTENA field.
	SCB_SHCRS_USGFAULTENA_Msk = 0x40000
	// Bit USGFAULTENA.
	SCB_SHCRS_USGFAULTENA = 0x40000

	// CFSR_UFSR_BFSR_MMFSR: Configurable fault status register
	// Position of IACCVIOL field.
	SCB_CFSR_UFSR_BFSR_MMFSR_IACCVIOL_Pos = 0x1
	// Bit mask of IACCVIOL field.
	SCB_CFSR_UFSR_BFSR_MMFSR_IACCVIOL_Msk = 0x2
	// Bit IACCVIOL.
	SCB_CFSR_UFSR_BFSR_MMFSR_IACCVIOL = 0x2
	// Position of MUNSTKERR field.
	SCB_CFSR_UFSR_BFSR_MMFSR_MUNSTKERR_Pos = 0x3
	// Bit mask of MUNSTKERR field.
	SCB_CFSR_UFSR_BFSR_MMFSR_MUNSTKERR_Msk = 0x8
	// Bit MUNSTKERR.
	SCB_CFSR_UFSR_BFSR_MMFSR_MUNSTKERR = 0x8
	// Position of MSTKERR field.
	SCB_CFSR_UFSR_BFSR_MMFSR_MSTKERR_Pos = 0x4
	// Bit mask of MSTKERR field.
	SCB_CFSR_UFSR_BFSR_MMFSR_MSTKERR_Msk = 0x10
	// Bit MSTKERR.
	SCB_CFSR_UFSR_BFSR_MMFSR_MSTKERR = 0x10
	// Position of MLSPERR field.
	SCB_CFSR_UFSR_BFSR_MMFSR_MLSPERR_Pos = 0x5
	// Bit mask of MLSPERR field.
	SCB_CFSR_UFSR_BFSR_MMFSR_MLSPERR_Msk = 0x20
	// Bit MLSPERR.
	SCB_CFSR_UFSR_BFSR_MMFSR_MLSPERR = 0x20
	// Position of MMARVALID field.
	SCB_CFSR_UFSR_BFSR_MMFSR_MMARVALID_Pos = 0x7
	// Bit mask of MMARVALID field.
	SCB_CFSR_UFSR_BFSR_MMFSR_MMARVALID_Msk = 0x80
	// Bit MMARVALID.
	SCB_CFSR_UFSR_BFSR_MMFSR_MMARVALID = 0x80
	// Position of IBUSERR field.
	SCB_CFSR_UFSR_BFSR_MMFSR_IBUSERR_Pos = 0x8
	// Bit mask of IBUSERR field.
	SCB_CFSR_UFSR_BFSR_MMFSR_IBUSERR_Msk = 0x100
	// Bit IBUSERR.
	SCB_CFSR_UFSR_BFSR_MMFSR_IBUSERR = 0x100
	// Position of PRECISERR field.
	SCB_CFSR_UFSR_BFSR_MMFSR_PRECISERR_Pos = 0x9
	// Bit mask of PRECISERR field.
	SCB_CFSR_UFSR_BFSR_MMFSR_PRECISERR_Msk = 0x200
	// Bit PRECISERR.
	SCB_CFSR_UFSR_BFSR_MMFSR_PRECISERR = 0x200
	// Position of IMPRECISERR field.
	SCB_CFSR_UFSR_BFSR_MMFSR_IMPRECISERR_Pos = 0xa
	// Bit mask of IMPRECISERR field.
	SCB_CFSR_UFSR_BFSR_MMFSR_IMPRECISERR_Msk = 0x400
	// Bit IMPRECISERR.
	SCB_CFSR_UFSR_BFSR_MMFSR_IMPRECISERR = 0x400
	// Position of UNSTKERR field.
	SCB_CFSR_UFSR_BFSR_MMFSR_UNSTKERR_Pos = 0xb
	// Bit mask of UNSTKERR field.
	SCB_CFSR_UFSR_BFSR_MMFSR_UNSTKERR_Msk = 0x800
	// Bit UNSTKERR.
	SCB_CFSR_UFSR_BFSR_MMFSR_UNSTKERR = 0x800
	// Position of STKERR field.
	SCB_CFSR_UFSR_BFSR_MMFSR_STKERR_Pos = 0xc
	// Bit mask of STKERR field.
	SCB_CFSR_UFSR_BFSR_MMFSR_STKERR_Msk = 0x1000
	// Bit STKERR.
	SCB_CFSR_UFSR_BFSR_MMFSR_STKERR = 0x1000
	// Position of LSPERR field.
	SCB_CFSR_UFSR_BFSR_MMFSR_LSPERR_Pos = 0xd
	// Bit mask of LSPERR field.
	SCB_CFSR_UFSR_BFSR_MMFSR_LSPERR_Msk = 0x2000
	// Bit LSPERR.
	SCB_CFSR_UFSR_BFSR_MMFSR_LSPERR = 0x2000
	// Position of BFARVALID field.
	SCB_CFSR_UFSR_BFSR_MMFSR_BFARVALID_Pos = 0xf
	// Bit mask of BFARVALID field.
	SCB_CFSR_UFSR_BFSR_MMFSR_BFARVALID_Msk = 0x8000
	// Bit BFARVALID.
	SCB_CFSR_UFSR_BFSR_MMFSR_BFARVALID = 0x8000
	// Position of UNDEFINSTR field.
	SCB_CFSR_UFSR_BFSR_MMFSR_UNDEFINSTR_Pos = 0x10
	// Bit mask of UNDEFINSTR field.
	SCB_CFSR_UFSR_BFSR_MMFSR_UNDEFINSTR_Msk = 0x10000
	// Bit UNDEFINSTR.
	SCB_CFSR_UFSR_BFSR_MMFSR_UNDEFINSTR = 0x10000
	// Position of INVSTATE field.
	SCB_CFSR_UFSR_BFSR_MMFSR_INVSTATE_Pos = 0x11
	// Bit mask of INVSTATE field.
	SCB_CFSR_UFSR_BFSR_MMFSR_INVSTATE_Msk = 0x20000
	// Bit INVSTATE.
	SCB_CFSR_UFSR_BFSR_MMFSR_INVSTATE = 0x20000
	// Position of INVPC field.
	SCB_CFSR_UFSR_BFSR_MMFSR_INVPC_Pos = 0x12
	// Bit mask of INVPC field.
	SCB_CFSR_UFSR_BFSR_MMFSR_INVPC_Msk = 0x40000
	// Bit INVPC.
	SCB_CFSR_UFSR_BFSR_MMFSR_INVPC = 0x40000
	// Position of NOCP field.
	SCB_CFSR_UFSR_BFSR_MMFSR_NOCP_Pos = 0x13
	// Bit mask of NOCP field.
	SCB_CFSR_UFSR_BFSR_MMFSR_NOCP_Msk = 0x80000
	// Bit NOCP.
	SCB_CFSR_UFSR_BFSR_MMFSR_NOCP = 0x80000
	// Position of UNALIGNED field.
	SCB_CFSR_UFSR_BFSR_MMFSR_UNALIGNED_Pos = 0x18
	// Bit mask of UNALIGNED field.
	SCB_CFSR_UFSR_BFSR_MMFSR_UNALIGNED_Msk = 0x1000000
	// Bit UNALIGNED.
	SCB_CFSR_UFSR_BFSR_MMFSR_UNALIGNED = 0x1000000
	// Position of DIVBYZERO field.
	SCB_CFSR_UFSR_BFSR_MMFSR_DIVBYZERO_Pos = 0x19
	// Bit mask of DIVBYZERO field.
	SCB_CFSR_UFSR_BFSR_MMFSR_DIVBYZERO_Msk = 0x2000000
	// Bit DIVBYZERO.
	SCB_CFSR_UFSR_BFSR_MMFSR_DIVBYZERO = 0x2000000

	// HFSR: Hard fault status register
	// Position of VECTTBL field.
	SCB_HFSR_VECTTBL_Pos = 0x1
	// Bit mask of VECTTBL field.
	SCB_HFSR_VECTTBL_Msk = 0x2
	// Bit VECTTBL.
	SCB_HFSR_VECTTBL = 0x2
	// Position of FORCED field.
	SCB_HFSR_FORCED_Pos = 0x1e
	// Bit mask of FORCED field.
	SCB_HFSR_FORCED_Msk = 0x40000000
	// Bit FORCED.
	SCB_HFSR_FORCED = 0x40000000
	// Position of DEBUG_VT field.
	SCB_HFSR_DEBUG_VT_Pos = 0x1f
	// Bit mask of DEBUG_VT field.
	SCB_HFSR_DEBUG_VT_Msk = 0x80000000
	// Bit DEBUG_VT.
	SCB_HFSR_DEBUG_VT = 0x80000000

	// MMFAR: Memory management fault address register
	// Position of MMFAR field.
	SCB_MMFAR_MMFAR_Pos = 0x0
	// Bit mask of MMFAR field.
	SCB_MMFAR_MMFAR_Msk = 0xffffffff

	// BFAR: Bus fault address register
	// Position of BFAR field.
	SCB_BFAR_BFAR_Pos = 0x0
	// Bit mask of BFAR field.
	SCB_BFAR_BFAR_Msk = 0xffffffff

	// AFSR: Auxiliary fault status register
	// Position of IMPDEF field.
	SCB_AFSR_IMPDEF_Pos = 0x0
	// Bit mask of IMPDEF field.
	SCB_AFSR_IMPDEF_Msk = 0xffffffff
)

// Bitfields for OPAMP: Operational Amplifier
const (
	// OPAMP1_CSR: OPAMP1 control register
	// Position of OPAMP1EN field.
	OPAMP_OPAMP1_CSR_OPAMP1EN_Pos = 0x0
	// Bit mask of OPAMP1EN field.
	OPAMP_OPAMP1_CSR_OPAMP1EN_Msk = 0x1
	// Bit OPAMP1EN.
	OPAMP_OPAMP1_CSR_OPAMP1EN = 0x1
	// Position of FORCE_VP field.
	OPAMP_OPAMP1_CSR_FORCE_VP_Pos = 0x1
	// Bit mask of FORCE_VP field.
	OPAMP_OPAMP1_CSR_FORCE_VP_Msk = 0x2
	// Bit FORCE_VP.
	OPAMP_OPAMP1_CSR_FORCE_VP = 0x2
	// Position of VP_SEL field.
	OPAMP_OPAMP1_CSR_VP_SEL_Pos = 0x2
	// Bit mask of VP_SEL field.
	OPAMP_OPAMP1_CSR_VP_SEL_Msk = 0xc
	// Position of VM_SEL field.
	OPAMP_OPAMP1_CSR_VM_SEL_Pos = 0x5
	// Bit mask of VM_SEL field.
	OPAMP_OPAMP1_CSR_VM_SEL_Msk = 0x60
	// Position of TCM_EN field.
	OPAMP_OPAMP1_CSR_TCM_EN_Pos = 0x7
	// Bit mask of TCM_EN field.
	OPAMP_OPAMP1_CSR_TCM_EN_Msk = 0x80
	// Bit TCM_EN.
	OPAMP_OPAMP1_CSR_TCM_EN = 0x80
	// Position of VMS_SEL field.
	OPAMP_OPAMP1_CSR_VMS_SEL_Pos = 0x8
	// Bit mask of VMS_SEL field.
	OPAMP_OPAMP1_CSR_VMS_SEL_Msk = 0x100
	// Bit VMS_SEL.
	OPAMP_OPAMP1_CSR_VMS_SEL = 0x100
	// Position of VPS_SEL field.
	OPAMP_OPAMP1_CSR_VPS_SEL_Pos = 0x9
	// Bit mask of VPS_SEL field.
	OPAMP_OPAMP1_CSR_VPS_SEL_Msk = 0x600
	// Position of CALON field.
	OPAMP_OPAMP1_CSR_CALON_Pos = 0xb
	// Bit mask of CALON field.
	OPAMP_OPAMP1_CSR_CALON_Msk = 0x800
	// Bit CALON.
	OPAMP_OPAMP1_CSR_CALON = 0x800
	// Position of CALSEL field.
	OPAMP_OPAMP1_CSR_CALSEL_Pos = 0xc
	// Bit mask of CALSEL field.
	OPAMP_OPAMP1_CSR_CALSEL_Msk = 0x3000
	// Position of PGA_GAIN field.
	OPAMP_OPAMP1_CSR_PGA_GAIN_Pos = 0xe
	// Bit mask of PGA_GAIN field.
	OPAMP_OPAMP1_CSR_PGA_GAIN_Msk = 0x3c000
	// Position of USER_TRIM field.
	OPAMP_OPAMP1_CSR_USER_TRIM_Pos = 0x12
	// Bit mask of USER_TRIM field.
	OPAMP_OPAMP1_CSR_USER_TRIM_Msk = 0x40000
	// Bit USER_TRIM.
	OPAMP_OPAMP1_CSR_USER_TRIM = 0x40000
	// Position of TRIMOFFSETP field.
	OPAMP_OPAMP1_CSR_TRIMOFFSETP_Pos = 0x13
	// Bit mask of TRIMOFFSETP field.
	OPAMP_OPAMP1_CSR_TRIMOFFSETP_Msk = 0xf80000
	// Position of TRIMOFFSETN field.
	OPAMP_OPAMP1_CSR_TRIMOFFSETN_Pos = 0x18
	// Bit mask of TRIMOFFSETN field.
	OPAMP_OPAMP1_CSR_TRIMOFFSETN_Msk = 0x1f000000
	// Position of TSTREF field.
	OPAMP_OPAMP1_CSR_TSTREF_Pos = 0x1d
	// Bit mask of TSTREF field.
	OPAMP_OPAMP1_CSR_TSTREF_Msk = 0x20000000
	// Bit TSTREF.
	OPAMP_OPAMP1_CSR_TSTREF = 0x20000000
	// Position of OUTCAL field.
	OPAMP_OPAMP1_CSR_OUTCAL_Pos = 0x1e
	// Bit mask of OUTCAL field.
	OPAMP_OPAMP1_CSR_OUTCAL_Msk = 0x40000000
	// Bit OUTCAL.
	OPAMP_OPAMP1_CSR_OUTCAL = 0x40000000
	// Position of LOCK field.
	OPAMP_OPAMP1_CSR_LOCK_Pos = 0x1f
	// Bit mask of LOCK field.
	OPAMP_OPAMP1_CSR_LOCK_Msk = 0x80000000
	// Bit LOCK.
	OPAMP_OPAMP1_CSR_LOCK = 0x80000000

	// OPAMP2_CSR: OPAMP2 control register
	// Position of OPAMP2EN field.
	OPAMP_OPAMP2_CSR_OPAMP2EN_Pos = 0x0
	// Bit mask of OPAMP2EN field.
	OPAMP_OPAMP2_CSR_OPAMP2EN_Msk = 0x1
	// Bit OPAMP2EN.
	OPAMP_OPAMP2_CSR_OPAMP2EN = 0x1
	// OPAMP2 is disabled
	OPAMP_OPAMP2_CSR_OPAMP2EN_Disabled = 0x0
	// OPAMP2 is enabled
	OPAMP_OPAMP2_CSR_OPAMP2EN_Enabled = 0x1
	// Position of FORCE_VP field.
	OPAMP_OPAMP2_CSR_FORCE_VP_Pos = 0x1
	// Bit mask of FORCE_VP field.
	OPAMP_OPAMP2_CSR_FORCE_VP_Msk = 0x2
	// Bit FORCE_VP.
	OPAMP_OPAMP2_CSR_FORCE_VP = 0x2
	// Normal operating mode
	OPAMP_OPAMP2_CSR_FORCE_VP_Normal = 0x0
	// Calibration mode. Non-inverting input connected to calibration reference
	OPAMP_OPAMP2_CSR_FORCE_VP_Calibration = 0x1
	// Position of VP_SEL field.
	OPAMP_OPAMP2_CSR_VP_SEL_Pos = 0x2
	// Bit mask of VP_SEL field.
	OPAMP_OPAMP2_CSR_VP_SEL_Msk = 0xc
	// PB14 used as OPAMP2 non-inverting input
	OPAMP_OPAMP2_CSR_VP_SEL_PB14 = 0x1
	// PB0 used as OPAMP2 non-inverting input
	OPAMP_OPAMP2_CSR_VP_SEL_PB0 = 0x2
	// PA7 used as OPAMP2 non-inverting input
	OPAMP_OPAMP2_CSR_VP_SEL_PA7 = 0x3
	// Position of VM_SEL field.
	OPAMP_OPAMP2_CSR_VM_SEL_Pos = 0x5
	// Bit mask of VM_SEL field.
	OPAMP_OPAMP2_CSR_VM_SEL_Msk = 0x60
	// PC5 (VM0) used as OPAMP2 inverting input
	OPAMP_OPAMP2_CSR_VM_SEL_PC5 = 0x0
	// PA5 (VM1) used as OPAMP2 inverting input
	OPAMP_OPAMP2_CSR_VM_SEL_PA5 = 0x1
	// Resistor feedback output (PGA mode)
	OPAMP_OPAMP2_CSR_VM_SEL_PGA = 0x2
	// Follower mode
	OPAMP_OPAMP2_CSR_VM_SEL_Follower = 0x3
	// Position of TCM_EN field.
	OPAMP_OPAMP2_CSR_TCM_EN_Pos = 0x7
	// Bit mask of TCM_EN field.
	OPAMP_OPAMP2_CSR_TCM_EN_Msk = 0x80
	// Bit TCM_EN.
	OPAMP_OPAMP2_CSR_TCM_EN = 0x80
	// Timer controlled mux disabled
	OPAMP_OPAMP2_CSR_TCM_EN_Disabled = 0x0
	// Timer controlled mux enabled
	OPAMP_OPAMP2_CSR_TCM_EN_Enabled = 0x1
	// Position of VMS_SEL field.
	OPAMP_OPAMP2_CSR_VMS_SEL_Pos = 0x8
	// Bit mask of VMS_SEL field.
	OPAMP_OPAMP2_CSR_VMS_SEL_Msk = 0x100
	// Bit VMS_SEL.
	OPAMP_OPAMP2_CSR_VMS_SEL = 0x100
	// PC5 (VM0) used as OPAMP2 inverting input when TCM_EN=1
	OPAMP_OPAMP2_CSR_VMS_SEL_PC5 = 0x0
	// PA5 (VM1) used as OPAMP2 inverting input when TCM_EN=1
	OPAMP_OPAMP2_CSR_VMS_SEL_PA5 = 0x1
	// Position of VPS_SEL field.
	OPAMP_OPAMP2_CSR_VPS_SEL_Pos = 0x9
	// Bit mask of VPS_SEL field.
	OPAMP_OPAMP2_CSR_VPS_SEL_Msk = 0x600
	// PB14 used as OPAMP2 non-inverting input when TCM_EN=1
	OPAMP_OPAMP2_CSR_VPS_SEL_PB14 = 0x1
	// PB0 used as OPAMP2 non-inverting input when TCM_EN=1
	OPAMP_OPAMP2_CSR_VPS_SEL_PB0 = 0x2
	// PA7 used as OPAMP2 non-inverting input when TCM_EN=1
	OPAMP_OPAMP2_CSR_VPS_SEL_PA7 = 0x3
	// Position of CALON field.
	OPAMP_OPAMP2_CSR_CALON_Pos = 0xb
	// Bit mask of CALON field.
	OPAMP_OPAMP2_CSR_CALON_Msk = 0x800
	// Bit CALON.
	OPAMP_OPAMP2_CSR_CALON = 0x800
	// Calibration mode disabled
	OPAMP_OPAMP2_CSR_CALON_Disabled = 0x0
	// Calibration mode enabled
	OPAMP_OPAMP2_CSR_CALON_Enabled = 0x1
	// Position of CALSEL field.
	OPAMP_OPAMP2_CSR_CALSEL_Pos = 0xc
	// Bit mask of CALSEL field.
	OPAMP_OPAMP2_CSR_CALSEL_Msk = 0x3000
	// VREFOPAMP=3.3% VDDA
	OPAMP_OPAMP2_CSR_CALSEL_Percent3_3 = 0x0
	// VREFOPAMP=10% VDDA
	OPAMP_OPAMP2_CSR_CALSEL_Percent10 = 0x1
	// VREFOPAMP=50% VDDA
	OPAMP_OPAMP2_CSR_CALSEL_Percent50 = 0x2
	// VREFOPAMP=90% VDDA
	OPAMP_OPAMP2_CSR_CALSEL_Percent90 = 0x3
	// Position of PGA_GAIN field.
	OPAMP_OPAMP2_CSR_PGA_GAIN_Pos = 0xe
	// Bit mask of PGA_GAIN field.
	OPAMP_OPAMP2_CSR_PGA_GAIN_Msk = 0x3c000
	// Gain 2
	OPAMP_OPAMP2_CSR_PGA_GAIN_Gain2 = 0x0
	// Gain 4
	OPAMP_OPAMP2_CSR_PGA_GAIN_Gain4 = 0x1
	// Gain 8
	OPAMP_OPAMP2_CSR_PGA_GAIN_Gain8 = 0x2
	// Gain 16
	OPAMP_OPAMP2_CSR_PGA_GAIN_Gain16 = 0x4
	// Gain 2, feedback connected to VM0
	OPAMP_OPAMP2_CSR_PGA_GAIN_Gain2_VM0 = 0x8
	// Gain 4, feedback connected to VM0
	OPAMP_OPAMP2_CSR_PGA_GAIN_Gain4_VM0 = 0x9
	// Gain 8, feedback connected to VM0
	OPAMP_OPAMP2_CSR_PGA_GAIN_Gain8_VM0 = 0xa
	// Gain 16, feedback connected to VM0
	OPAMP_OPAMP2_CSR_PGA_GAIN_Gain16_VM0 = 0xb
	// Gain 2, feedback connected to VM1
	OPAMP_OPAMP2_CSR_PGA_GAIN_Gain2_VM1 = 0xc
	// Gain 4, feedback connected to VM1
	OPAMP_OPAMP2_CSR_PGA_GAIN_Gain4_VM1 = 0xd
	// Gain 8, feedback connected to VM1
	OPAMP_OPAMP2_CSR_PGA_GAIN_Gain8_VM1 = 0xe
	// Gain 16, feedback connected to VM1
	OPAMP_OPAMP2_CSR_PGA_GAIN_Gain16_VM1 = 0xf
	// Position of USER_TRIM field.
	OPAMP_OPAMP2_CSR_USER_TRIM_Pos = 0x12
	// Bit mask of USER_TRIM field.
	OPAMP_OPAMP2_CSR_USER_TRIM_Msk = 0x40000
	// Bit USER_TRIM.
	OPAMP_OPAMP2_CSR_USER_TRIM = 0x40000
	// User trimming disabled
	OPAMP_OPAMP2_CSR_USER_TRIM_Disabled = 0x0
	// User trimming enabled
	OPAMP_OPAMP2_CSR_USER_TRIM_Enabled = 0x1
	// Position of TRIMOFFSETP field.
	OPAMP_OPAMP2_CSR_TRIMOFFSETP_Pos = 0x13
	// Bit mask of TRIMOFFSETP field.
	OPAMP_OPAMP2_CSR_TRIMOFFSETP_Msk = 0xf80000
	// Position of TRIMOFFSETN field.
	OPAMP_OPAMP2_CSR_TRIMOFFSETN_Pos = 0x18
	// Bit mask of TRIMOFFSETN field.
	OPAMP_OPAMP2_CSR_TRIMOFFSETN_Msk = 0x1f000000
	// Position of TSTREF field.
	OPAMP_OPAMP2_CSR_TSTREF_Pos = 0x1d
	// Bit mask of TSTREF field.
	OPAMP_OPAMP2_CSR_TSTREF_Msk = 0x20000000
	// Bit TSTREF.
	OPAMP_OPAMP2_CSR_TSTREF = 0x20000000
	// VREFOPAMP2 is output
	OPAMP_OPAMP2_CSR_TSTREF_Output = 0x0
	// VREFOPAMP2 is not output
	OPAMP_OPAMP2_CSR_TSTREF_NotOutput = 0x1
	// Position of OUTCAL field.
	OPAMP_OPAMP2_CSR_OUTCAL_Pos = 0x1e
	// Bit mask of OUTCAL field.
	OPAMP_OPAMP2_CSR_OUTCAL_Msk = 0x40000000
	// Bit OUTCAL.
	OPAMP_OPAMP2_CSR_OUTCAL = 0x40000000
	// Non-inverting < inverting
	OPAMP_OPAMP2_CSR_OUTCAL_Low = 0x0
	// Non-inverting > inverting
	OPAMP_OPAMP2_CSR_OUTCAL_High = 0x1
	// Position of LOCK field.
	OPAMP_OPAMP2_CSR_LOCK_Pos = 0x1f
	// Bit mask of LOCK field.
	OPAMP_OPAMP2_CSR_LOCK_Msk = 0x80000000
	// Bit LOCK.
	OPAMP_OPAMP2_CSR_LOCK = 0x80000000
	// Comparator CSR bits are read-write
	OPAMP_OPAMP2_CSR_LOCK_Unlocked = 0x0
	// Comparator CSR bits are read-only
	OPAMP_OPAMP2_CSR_LOCK_Locked = 0x1
)

// Bitfields for COMP: General purpose comparators
const (
	// COMP1_CSR: control and status register
	// Position of COMP1EN field.
	COMP_COMP1_CSR_COMP1EN_Pos = 0x0
	// Bit mask of COMP1EN field.
	COMP_COMP1_CSR_COMP1EN_Msk = 0x1
	// Bit COMP1EN.
	COMP_COMP1_CSR_COMP1EN = 0x1
	// Position of COMP1_INP_DAC field.
	COMP_COMP1_CSR_COMP1_INP_DAC_Pos = 0x1
	// Bit mask of COMP1_INP_DAC field.
	COMP_COMP1_CSR_COMP1_INP_DAC_Msk = 0x2
	// Bit COMP1_INP_DAC.
	COMP_COMP1_CSR_COMP1_INP_DAC = 0x2
	// Position of COMP1MODE field.
	COMP_COMP1_CSR_COMP1MODE_Pos = 0x2
	// Bit mask of COMP1MODE field.
	COMP_COMP1_CSR_COMP1MODE_Msk = 0xc
	// Position of COMP1INMSEL field.
	COMP_COMP1_CSR_COMP1INMSEL_Pos = 0x4
	// Bit mask of COMP1INMSEL field.
	COMP_COMP1_CSR_COMP1INMSEL_Msk = 0x70
	// Position of COMP1OUTSEL field.
	COMP_COMP1_CSR_COMP1OUTSEL_Pos = 0xa
	// Bit mask of COMP1OUTSEL field.
	COMP_COMP1_CSR_COMP1OUTSEL_Msk = 0x3c00
	// Position of COMP1POL field.
	COMP_COMP1_CSR_COMP1POL_Pos = 0xf
	// Bit mask of COMP1POL field.
	COMP_COMP1_CSR_COMP1POL_Msk = 0x8000
	// Bit COMP1POL.
	COMP_COMP1_CSR_COMP1POL = 0x8000
	// Position of COMP1HYST field.
	COMP_COMP1_CSR_COMP1HYST_Pos = 0x10
	// Bit mask of COMP1HYST field.
	COMP_COMP1_CSR_COMP1HYST_Msk = 0x30000
	// Position of COMP1_BLANKING field.
	COMP_COMP1_CSR_COMP1_BLANKING_Pos = 0x12
	// Bit mask of COMP1_BLANKING field.
	COMP_COMP1_CSR_COMP1_BLANKING_Msk = 0x1c0000
	// Position of COMP1OUT field.
	COMP_COMP1_CSR_COMP1OUT_Pos = 0x1e
	// Bit mask of COMP1OUT field.
	COMP_COMP1_CSR_COMP1OUT_Msk = 0x40000000
	// Bit COMP1OUT.
	COMP_COMP1_CSR_COMP1OUT = 0x40000000
	// Position of COMP1LOCK field.
	COMP_COMP1_CSR_COMP1LOCK_Pos = 0x1f
	// Bit mask of COMP1LOCK field.
	COMP_COMP1_CSR_COMP1LOCK_Msk = 0x80000000
	// Bit COMP1LOCK.
	COMP_COMP1_CSR_COMP1LOCK = 0x80000000

	// COMP2_CSR: control and status register
	// Position of COMP2EN field.
	COMP_COMP2_CSR_COMP2EN_Pos = 0x0
	// Bit mask of COMP2EN field.
	COMP_COMP2_CSR_COMP2EN_Msk = 0x1
	// Bit COMP2EN.
	COMP_COMP2_CSR_COMP2EN = 0x1
	// Comparator disabled
	COMP_COMP2_CSR_COMP2EN_Disabled = 0x0
	// Comparator enabled
	COMP_COMP2_CSR_COMP2EN_Enabled = 0x1
	// Position of COMP2INMSEL field.
	COMP_COMP2_CSR_COMP2INMSEL_Pos = 0x4
	// Bit mask of COMP2INMSEL field.
	COMP_COMP2_CSR_COMP2INMSEL_Msk = 0x70
	// 1/4 of VRefint
	COMP_COMP2_CSR_COMP2INMSEL_OneQuarterVRef = 0x0
	// 1/2 of VRefint
	COMP_COMP2_CSR_COMP2INMSEL_OneHalfVRef = 0x1
	// 3/4 of VRefint
	COMP_COMP2_CSR_COMP2INMSEL_ThreeQuarterVRef = 0x2
	// VRefint
	COMP_COMP2_CSR_COMP2INMSEL_VRef = 0x3
	// PA4 or DAC1_CH1 output if enabled
	COMP_COMP2_CSR_COMP2INMSEL_PA4_DAC1_CH1 = 0x4
	// DAC1_CH2
	COMP_COMP2_CSR_COMP2INMSEL_DAC1_CH2 = 0x5
	// PA2
	COMP_COMP2_CSR_COMP2INMSEL_PA2 = 0x6
	// Position of COMP2OUTSEL field.
	COMP_COMP2_CSR_COMP2OUTSEL_Pos = 0xa
	// Bit mask of COMP2OUTSEL field.
	COMP_COMP2_CSR_COMP2OUTSEL_Msk = 0x3c00
	// No selection
	COMP_COMP2_CSR_COMP2OUTSEL_NoSelection = 0x0
	// Timer 1 break input
	COMP_COMP2_CSR_COMP2OUTSEL_Timer1BreakInput = 0x1
	// Timer 1 break input 2
	COMP_COMP2_CSR_COMP2OUTSEL_Timer1BreakInput2 = 0x2
	// Timer 1 OCREF_CLR input
	COMP_COMP2_CSR_COMP2OUTSEL_Timer1OCRefClearInput = 0x6
	// Timer 1 input capture 1
	COMP_COMP2_CSR_COMP2OUTSEL_Timer1InputCapture1 = 0x7
	// Timer 2 input capture 4
	COMP_COMP2_CSR_COMP2OUTSEL_Timer2InputCapture4 = 0x8
	// Timer 2 OCREF_CLR input
	COMP_COMP2_CSR_COMP2OUTSEL_Timer2OCRefClearInput = 0x9
	// Timer 3 input capture 1
	COMP_COMP2_CSR_COMP2OUTSEL_Timer3InputCapture1 = 0xa
	// Timer 3 OCREF_CLR input
	COMP_COMP2_CSR_COMP2OUTSEL_Timer3OCRefClearInput = 0xb
	// Position of COMP2POL field.
	COMP_COMP2_CSR_COMP2POL_Pos = 0xf
	// Bit mask of COMP2POL field.
	COMP_COMP2_CSR_COMP2POL_Msk = 0x8000
	// Bit COMP2POL.
	COMP_COMP2_CSR_COMP2POL = 0x8000
	// Output is not inverted
	COMP_COMP2_CSR_COMP2POL_NotInverted = 0x0
	// Output is inverted
	COMP_COMP2_CSR_COMP2POL_Inverted = 0x1
	// Position of COMP2_BLANKING field.
	COMP_COMP2_CSR_COMP2_BLANKING_Pos = 0x12
	// Bit mask of COMP2_BLANKING field.
	COMP_COMP2_CSR_COMP2_BLANKING_Msk = 0x1c0000
	// No blanking
	COMP_COMP2_CSR_COMP2_BLANKING_NoBlanking = 0x0
	// TIM1 OC5 selected as blanking source
	COMP_COMP2_CSR_COMP2_BLANKING_TIM1OC5 = 0x1
	// TIM2 OC3 selected as blanking source
	COMP_COMP2_CSR_COMP2_BLANKING_TIM2OC3 = 0x2
	// TIM3 OC3 selected as blanking source
	COMP_COMP2_CSR_COMP2_BLANKING_TIM3OC3 = 0x3
	// Position of COMP2OUT field.
	COMP_COMP2_CSR_COMP2OUT_Pos = 0x1e
	// Bit mask of COMP2OUT field.
	COMP_COMP2_CSR_COMP2OUT_Msk = 0x40000000
	// Bit COMP2OUT.
	COMP_COMP2_CSR_COMP2OUT = 0x40000000
	// Non-inverting input below inverting input
	COMP_COMP2_CSR_COMP2OUT_Low = 0x0
	// Non-inverting input above inverting input
	COMP_COMP2_CSR_COMP2OUT_High = 0x1
	// Position of COMP2LOCK field.
	COMP_COMP2_CSR_COMP2LOCK_Pos = 0x1f
	// Bit mask of COMP2LOCK field.
	COMP_COMP2_CSR_COMP2LOCK_Msk = 0x80000000
	// Bit COMP2LOCK.
	COMP_COMP2_CSR_COMP2LOCK = 0x80000000
	// Comparator CSR bits are read-write
	COMP_COMP2_CSR_COMP2LOCK_Unlocked = 0x0
	// Comparator CSR bits are read-only
	COMP_COMP2_CSR_COMP2LOCK_Locked = 0x1
	// Position of COMP2MODE field.
	COMP_COMP2_CSR_COMP2MODE_Pos = 0x2
	// Bit mask of COMP2MODE field.
	COMP_COMP2_CSR_COMP2MODE_Msk = 0xc
	// Position of COMP2INPSEL field.
	COMP_COMP2_CSR_COMP2INPSEL_Pos = 0x7
	// Bit mask of COMP2INPSEL field.
	COMP_COMP2_CSR_COMP2INPSEL_Msk = 0x80
	// Bit COMP2INPSEL.
	COMP_COMP2_CSR_COMP2INPSEL = 0x80
	// Position of COMP2WINMODE field.
	COMP_COMP2_CSR_COMP2WINMODE_Pos = 0x9
	// Bit mask of COMP2WINMODE field.
	COMP_COMP2_CSR_COMP2WINMODE_Msk = 0x200
	// Bit COMP2WINMODE.
	COMP_COMP2_CSR_COMP2WINMODE = 0x200
	// Position of COMP2HYST field.
	COMP_COMP2_CSR_COMP2HYST_Pos = 0x10
	// Bit mask of COMP2HYST field.
	COMP_COMP2_CSR_COMP2HYST_Msk = 0x30000
	// Position of COMP2_INP_DAC field.
	COMP_COMP2_CSR_COMP2_INP_DAC_Pos = 0x1
	// Bit mask of COMP2_INP_DAC field.
	COMP_COMP2_CSR_COMP2_INP_DAC_Msk = 0x2
	// Bit COMP2_INP_DAC.
	COMP_COMP2_CSR_COMP2_INP_DAC = 0x2

	// COMP4_CSR: control and status register
	// Position of COMP4EN field.
	COMP_COMP4_CSR_COMP4EN_Pos = 0x0
	// Bit mask of COMP4EN field.
	COMP_COMP4_CSR_COMP4EN_Msk = 0x1
	// Bit COMP4EN.
	COMP_COMP4_CSR_COMP4EN = 0x1
	// Comparator disabled
	COMP_COMP4_CSR_COMP4EN_Disabled = 0x0
	// Comparator enabled
	COMP_COMP4_CSR_COMP4EN_Enabled = 0x1
	// Position of COMP4INMSEL field.
	COMP_COMP4_CSR_COMP4INMSEL_Pos = 0x4
	// Bit mask of COMP4INMSEL field.
	COMP_COMP4_CSR_COMP4INMSEL_Msk = 0x70
	// 1/4 of VRefint
	COMP_COMP4_CSR_COMP4INMSEL_OneQuarterVRef = 0x0
	// 1/2 of VRefint
	COMP_COMP4_CSR_COMP4INMSEL_OneHalfVRef = 0x1
	// 3/4 of VRefint
	COMP_COMP4_CSR_COMP4INMSEL_ThreeQuarterVRef = 0x2
	// VRefint
	COMP_COMP4_CSR_COMP4INMSEL_VRef = 0x3
	// PA4 or DAC1_CH1 output if enabled
	COMP_COMP4_CSR_COMP4INMSEL_PA4_DAC1_CH1 = 0x4
	// DAC1_CH2
	COMP_COMP4_CSR_COMP4INMSEL_DAC1_CH2 = 0x5
	// PB2
	COMP_COMP4_CSR_COMP4INMSEL_PB2 = 0x7
	// Position of COMP4OUTSEL field.
	COMP_COMP4_CSR_COMP4OUTSEL_Pos = 0xa
	// Bit mask of COMP4OUTSEL field.
	COMP_COMP4_CSR_COMP4OUTSEL_Msk = 0x3c00
	// No selection
	COMP_COMP4_CSR_COMP4OUTSEL_NoSelection = 0x0
	// Timer 1 break input
	COMP_COMP4_CSR_COMP4OUTSEL_Timer1BreakInput = 0x1
	// Timer 1 break input 2
	COMP_COMP4_CSR_COMP4OUTSEL_Timer1BreakInput2 = 0x2
	// Timer 3 input capture 3
	COMP_COMP4_CSR_COMP4OUTSEL_Timer3InputCapture3 = 0x6
	// Timer 15 input capture 2
	COMP_COMP4_CSR_COMP4OUTSEL_Timer15InputCapture2 = 0x8
	// Timer 15 OCREF_CLR input
	COMP_COMP4_CSR_COMP4OUTSEL_Timer15OCRefClearInput = 0xa
	// Timer 3 OCREF_CLR input
	COMP_COMP4_CSR_COMP4OUTSEL_Timer3OCRefClearInput = 0xb
	// Position of COMP4POL field.
	COMP_COMP4_CSR_COMP4POL_Pos = 0xf
	// Bit mask of COMP4POL field.
	COMP_COMP4_CSR_COMP4POL_Msk = 0x8000
	// Bit COMP4POL.
	COMP_COMP4_CSR_COMP4POL = 0x8000
	// Output is not inverted
	COMP_COMP4_CSR_COMP4POL_NotInverted = 0x0
	// Output is inverted
	COMP_COMP4_CSR_COMP4POL_Inverted = 0x1
	// Position of COMP4_BLANKING field.
	COMP_COMP4_CSR_COMP4_BLANKING_Pos = 0x12
	// Bit mask of COMP4_BLANKING field.
	COMP_COMP4_CSR_COMP4_BLANKING_Msk = 0x1c0000
	// No blanking
	COMP_COMP4_CSR_COMP4_BLANKING_NoBlanking = 0x0
	// TIM3 OC4 selected as blanking source
	COMP_COMP4_CSR_COMP4_BLANKING_TIM3OC4 = 0x1
	// TIM15 OC1 selected as blanking source
	COMP_COMP4_CSR_COMP4_BLANKING_TIM15OC1 = 0x3
	// Position of COMP4OUT field.
	COMP_COMP4_CSR_COMP4OUT_Pos = 0x1e
	// Bit mask of COMP4OUT field.
	COMP_COMP4_CSR_COMP4OUT_Msk = 0x40000000
	// Bit COMP4OUT.
	COMP_COMP4_CSR_COMP4OUT = 0x40000000
	// Non-inverting input below inverting input
	COMP_COMP4_CSR_COMP4OUT_Low = 0x0
	// Non-inverting input above inverting input
	COMP_COMP4_CSR_COMP4OUT_High = 0x1
	// Position of COMP4LOCK field.
	COMP_COMP4_CSR_COMP4LOCK_Pos = 0x1f
	// Bit mask of COMP4LOCK field.
	COMP_COMP4_CSR_COMP4LOCK_Msk = 0x80000000
	// Bit COMP4LOCK.
	COMP_COMP4_CSR_COMP4LOCK = 0x80000000
	// Comparator CSR bits are read-write
	COMP_COMP4_CSR_COMP4LOCK_Unlocked = 0x0
	// Comparator CSR bits are read-only
	COMP_COMP4_CSR_COMP4LOCK_Locked = 0x1
	// Position of COMP4MODE field.
	COMP_COMP4_CSR_COMP4MODE_Pos = 0x2
	// Bit mask of COMP4MODE field.
	COMP_COMP4_CSR_COMP4MODE_Msk = 0xc
	// Position of COMP4INPSEL field.
	COMP_COMP4_CSR_COMP4INPSEL_Pos = 0x7
	// Bit mask of COMP4INPSEL field.
	COMP_COMP4_CSR_COMP4INPSEL_Msk = 0x80
	// Bit COMP4INPSEL.
	COMP_COMP4_CSR_COMP4INPSEL = 0x80
	// Position of COMP4HYST field.
	COMP_COMP4_CSR_COMP4HYST_Pos = 0x10
	// Bit mask of COMP4HYST field.
	COMP_COMP4_CSR_COMP4HYST_Msk = 0x30000

	// COMP6_CSR: control and status register
	// Position of COMP6EN field.
	COMP_COMP6_CSR_COMP6EN_Pos = 0x0
	// Bit mask of COMP6EN field.
	COMP_COMP6_CSR_COMP6EN_Msk = 0x1
	// Bit COMP6EN.
	COMP_COMP6_CSR_COMP6EN = 0x1
	// Comparator disabled
	COMP_COMP6_CSR_COMP6EN_Disabled = 0x0
	// Comparator enabled
	COMP_COMP6_CSR_COMP6EN_Enabled = 0x1
	// Position of COMP6INMSEL field.
	COMP_COMP6_CSR_COMP6INMSEL_Pos = 0x4
	// Bit mask of COMP6INMSEL field.
	COMP_COMP6_CSR_COMP6INMSEL_Msk = 0x70
	// 1/4 of VRefint
	COMP_COMP6_CSR_COMP6INMSEL_OneQuarterVRef = 0x0
	// 1/2 of VRefint
	COMP_COMP6_CSR_COMP6INMSEL_OneHalfVRef = 0x1
	// 3/4 of VRefint
	COMP_COMP6_CSR_COMP6INMSEL_ThreeQuarterVRef = 0x2
	// VRefint
	COMP_COMP6_CSR_COMP6INMSEL_VRef = 0x3
	// PA4 or DAC1_CH1 output if enabled
	COMP_COMP6_CSR_COMP6INMSEL_PA4_DAC1_CH1 = 0x4
	// DAC1_CH2
	COMP_COMP6_CSR_COMP6INMSEL_DAC1_CH2 = 0x5
	// PB15
	COMP_COMP6_CSR_COMP6INMSEL_PB15 = 0x7
	// Position of COMP6OUTSEL field.
	COMP_COMP6_CSR_COMP6OUTSEL_Pos = 0xa
	// Bit mask of COMP6OUTSEL field.
	COMP_COMP6_CSR_COMP6OUTSEL_Msk = 0x3c00
	// No selection
	COMP_COMP6_CSR_COMP6OUTSEL_NoSelection = 0x0
	// Timer 1 break input
	COMP_COMP6_CSR_COMP6OUTSEL_Timer1BreakInput = 0x1
	// Timer 1 break input 2
	COMP_COMP6_CSR_COMP6OUTSEL_Timer1BreakInput2 = 0x2
	// Timer 2 input capture 2
	COMP_COMP6_CSR_COMP6OUTSEL_Timer2InputCapture2 = 0x6
	// Timer 2 OCREF_CLR input
	COMP_COMP6_CSR_COMP6OUTSEL_Timer2OCRefClearInput = 0x8
	// Timer 16 OCREF_CLR input
	COMP_COMP6_CSR_COMP6OUTSEL_Timer16OCRefClearInput = 0x9
	// Timer 16 input capture 1
	COMP_COMP6_CSR_COMP6OUTSEL_Timer16InputCapture1 = 0xa
	// Position of COMP6POL field.
	COMP_COMP6_CSR_COMP6POL_Pos = 0xf
	// Bit mask of COMP6POL field.
	COMP_COMP6_CSR_COMP6POL_Msk = 0x8000
	// Bit COMP6POL.
	COMP_COMP6_CSR_COMP6POL = 0x8000
	// Output is not inverted
	COMP_COMP6_CSR_COMP6POL_NotInverted = 0x0
	// Output is inverted
	COMP_COMP6_CSR_COMP6POL_Inverted = 0x1
	// Position of COMP6_BLANKING field.
	COMP_COMP6_CSR_COMP6_BLANKING_Pos = 0x12
	// Bit mask of COMP6_BLANKING field.
	COMP_COMP6_CSR_COMP6_BLANKING_Msk = 0x1c0000
	// No blanking
	COMP_COMP6_CSR_COMP6_BLANKING_NoBlanking = 0x0
	// TIM2 OC4 selected as blanking source
	COMP_COMP6_CSR_COMP6_BLANKING_TIM2OC4 = 0x3
	// TIM15 OC2 selected as blanking source
	COMP_COMP6_CSR_COMP6_BLANKING_TIM15OC2 = 0x4
	// Position of COMP6OUT field.
	COMP_COMP6_CSR_COMP6OUT_Pos = 0x1e
	// Bit mask of COMP6OUT field.
	COMP_COMP6_CSR_COMP6OUT_Msk = 0x40000000
	// Bit COMP6OUT.
	COMP_COMP6_CSR_COMP6OUT = 0x40000000
	// Non-inverting input below inverting input
	COMP_COMP6_CSR_COMP6OUT_Low = 0x0
	// Non-inverting input above inverting input
	COMP_COMP6_CSR_COMP6OUT_High = 0x1
	// Position of COMP6LOCK field.
	COMP_COMP6_CSR_COMP6LOCK_Pos = 0x1f
	// Bit mask of COMP6LOCK field.
	COMP_COMP6_CSR_COMP6LOCK_Msk = 0x80000000
	// Bit COMP6LOCK.
	COMP_COMP6_CSR_COMP6LOCK = 0x80000000
	// Comparator CSR bits are read-write
	COMP_COMP6_CSR_COMP6LOCK_Unlocked = 0x0
	// Comparator CSR bits are read-only
	COMP_COMP6_CSR_COMP6LOCK_Locked = 0x1
	// Position of COMP6MODE field.
	COMP_COMP6_CSR_COMP6MODE_Pos = 0x2
	// Bit mask of COMP6MODE field.
	COMP_COMP6_CSR_COMP6MODE_Msk = 0xc
	// Position of COMP6INPSEL field.
	COMP_COMP6_CSR_COMP6INPSEL_Pos = 0x7
	// Bit mask of COMP6INPSEL field.
	COMP_COMP6_CSR_COMP6INPSEL_Msk = 0x80
	// Bit COMP6INPSEL.
	COMP_COMP6_CSR_COMP6INPSEL = 0x80
	// Position of COMP6HYST field.
	COMP_COMP6_CSR_COMP6HYST_Pos = 0x10
	// Bit mask of COMP6HYST field.
	COMP_COMP6_CSR_COMP6HYST_Msk = 0x30000
)
