/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.ssi;

public class ExpressionTokenizer {
    public static final int TOKEN_STRING = 0;
    public static final int TOKEN_AND = 1;
    public static final int TOKEN_OR = 2;
    public static final int TOKEN_NOT = 3;
    public static final int TOKEN_EQ = 4;
    public static final int TOKEN_NOT_EQ = 5;
    public static final int TOKEN_RBRACE = 6;
    public static final int TOKEN_LBRACE = 7;
    public static final int TOKEN_GE = 8;
    public static final int TOKEN_LE = 9;
    public static final int TOKEN_GT = 10;
    public static final int TOKEN_LT = 11;
    public static final int TOKEN_END = 12;
    private char[] expr;
    private String tokenVal = null;
    private int index;
    private int length;

    public ExpressionTokenizer(String string) {
        this.expr = string.trim().toCharArray();
        this.length = this.expr.length;
    }

    public boolean hasMoreTokens() {
        return this.index < this.length;
    }

    public int getIndex() {
        return this.index;
    }

    protected boolean isMetaChar(char c) {
        return Character.isWhitespace(c) || c == '(' || c == ')' || c == '!' || c == '<' || c == '>' || c == '|' || c == '&' || c == '=';
    }

    public int nextToken() {
        while (this.index < this.length && Character.isWhitespace(this.expr[this.index])) {
            ++this.index;
        }
        this.tokenVal = null;
        if (this.index == this.length) {
            return 12;
        }
        int n = this.index;
        char c = this.expr[this.index];
        int n2 = 0;
        ++this.index;
        if (this.index < this.length) {
            n2 = this.expr[this.index];
        }
        switch (c) {
            case '(': {
                return 7;
            }
            case ')': {
                return 6;
            }
            case '=': {
                return 4;
            }
            case '!': {
                if (n2 == 61) {
                    ++this.index;
                    return 5;
                }
                return 3;
            }
            case '|': {
                if (n2 != 124) break;
                ++this.index;
                return 2;
            }
            case '&': {
                if (n2 != 38) break;
                ++this.index;
                return 1;
            }
            case '>': {
                if (n2 == 61) {
                    ++this.index;
                    return 8;
                }
                return 10;
            }
            case '<': {
                if (n2 == 61) {
                    ++this.index;
                    return 9;
                }
                return 11;
            }
        }
        int n3 = this.index;
        if (c == '\"' || c == '\'') {
            char c2 = c;
            boolean bl = false;
            ++n;
            while (this.index < this.length) {
                if (this.expr[this.index] == '\\' && !bl) {
                    bl = true;
                } else {
                    if (this.expr[this.index] == c2 && !bl) break;
                    bl = false;
                }
                ++this.index;
            }
            n3 = this.index++;
        } else {
            while (this.index < this.length && !this.isMetaChar(this.expr[this.index])) {
                ++this.index;
            }
            n3 = this.index;
        }
        this.tokenVal = new String(this.expr, n, n3 - n);
        return 0;
    }

    public String getTokenValue() {
        return this.tokenVal;
    }
}

