/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sdedit.drawable;

import net.sf.sdedit.diagram.Lifeline;
import net.sf.sdedit.drawable.Drawable;

public abstract class ExtensibleDrawable
extends Drawable {
    private final Lifeline lifeline;

    protected ExtensibleDrawable(int width, Lifeline lifeline) {
        super(lifeline == null ? null : lifeline.getDiagram());
        this.setWidth(width);
        this.setHeight(0);
        this.lifeline = lifeline;
        if (lifeline != null) {
            lifeline.addView(this);
        }
    }

    @Override
    public boolean isVisible() {
        if (this.lifeline == null) {
            return super.isVisible();
        }
        return !this.lifeline.isExternal() && super.isVisible();
    }

    public Lifeline getLifeline() {
        return this.lifeline;
    }

    public final void extend(int amount) {
        this.setHeight(this.getHeight() + amount);
    }

    @Override
    public void computeLayoutInformation() {
    }
}

