/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.internal.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.impl.MetadataGenerator;
import org.eclipse.aether.impl.MetadataGeneratorFactory;
import org.eclipse.aether.impl.OfflineController;
import org.eclipse.aether.internal.impl.PrioritizedComponents;
import org.eclipse.aether.metadata.Metadata;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.resolution.ResolutionErrorPolicy;
import org.eclipse.aether.resolution.ResolutionErrorPolicyRequest;
import org.eclipse.aether.transfer.RepositoryOfflineException;

final class Utils {
    Utils() {
    }

    public static PrioritizedComponents<MetadataGeneratorFactory> sortMetadataGeneratorFactories(RepositorySystemSession session2, Collection<? extends MetadataGeneratorFactory> factories) {
        PrioritizedComponents<MetadataGeneratorFactory> result = new PrioritizedComponents<MetadataGeneratorFactory>(session2);
        for (MetadataGeneratorFactory metadataGeneratorFactory : factories) {
            result.add(metadataGeneratorFactory, metadataGeneratorFactory.getPriority());
        }
        return result;
    }

    public static List<Metadata> prepareMetadata(List<? extends MetadataGenerator> generators, List<? extends Artifact> artifacts) {
        ArrayList<Metadata> metadatas = new ArrayList<Metadata>();
        for (MetadataGenerator metadataGenerator : generators) {
            metadatas.addAll(metadataGenerator.prepare(artifacts));
        }
        return metadatas;
    }

    public static List<Metadata> finishMetadata(List<? extends MetadataGenerator> generators, List<? extends Artifact> artifacts) {
        ArrayList<Metadata> metadatas = new ArrayList<Metadata>();
        for (MetadataGenerator metadataGenerator : generators) {
            metadatas.addAll(metadataGenerator.finish(artifacts));
        }
        return metadatas;
    }

    public static <T> List<T> combine(Collection<? extends T> first, Collection<? extends T> second) {
        ArrayList<T> result = new ArrayList<T>(first.size() + second.size());
        result.addAll(first);
        result.addAll(second);
        return result;
    }

    public static int getPolicy(RepositorySystemSession session2, Artifact artifact, RemoteRepository repository) {
        ResolutionErrorPolicy rep = session2.getResolutionErrorPolicy();
        if (rep == null) {
            return 0;
        }
        return rep.getArtifactPolicy(session2, new ResolutionErrorPolicyRequest<Artifact>(artifact, repository));
    }

    public static int getPolicy(RepositorySystemSession session2, Metadata metadata, RemoteRepository repository) {
        ResolutionErrorPolicy rep = session2.getResolutionErrorPolicy();
        if (rep == null) {
            return 0;
        }
        return rep.getMetadataPolicy(session2, new ResolutionErrorPolicyRequest<Metadata>(metadata, repository));
    }

    public static void appendClassLoader(StringBuilder buffer, Object component) {
        ClassLoader loader = component.getClass().getClassLoader();
        if (loader != null && !loader.equals(Utils.class.getClassLoader())) {
            buffer.append(" from ").append(loader);
        }
    }

    public static void checkOffline(RepositorySystemSession session2, OfflineController offlineController, RemoteRepository repository) throws RepositoryOfflineException {
        if (session2.isOffline()) {
            offlineController.checkOffline(session2, repository);
        }
    }
}

